/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import org.graphstream.graph.Graph;
import org.graphstream.stream.file.FileSource;
import org.junit.Assert;
import org.junit.Test;

public abstract class TestFileSourceBase {
    protected Graph graph;
    protected FileSource input;
    protected boolean testEdgeIds = true;

    public abstract String anUndirectedTriangle();

    public abstract String aDirectedTriangle();

    public abstract String basicAttributes();

    public abstract String anUndirectedTriangleFileName();

    public abstract String anUndirectedTriangleHttpURL();

    @Test
    public void test_Access_ReadAll_Reader() {
        try {
            this.input.addSink(this.graph);
            this.input.readAll(new StringReader(this.anUndirectedTriangle()));
            this.undirectedTriangleTests();
        }
        catch (IOException e) {
            Assert.assertTrue((String)("IOException, should not happen" + e.getMessage()), (boolean)false);
            e.printStackTrace();
        }
    }

    @Test
    public void test_Access_ByStep_Reader() {
        try {
            this.input.addSink(this.graph);
            this.input.begin(new StringReader(this.anUndirectedTriangle()));
            while (this.input.nextEvents()) {
            }
            this.input.end();
            this.undirectedTriangleTests();
        }
        catch (IOException e) {
            Assert.assertTrue((String)("IOException, should not happen" + e.getMessage()), (boolean)false);
            e.printStackTrace();
        }
    }

    @Test
    public void test_Access_ReadAll_Stream() {
        try {
            this.input.addSink(this.graph);
            this.input.readAll(new FileInputStream(this.anUndirectedTriangleFileName()));
            this.undirectedTriangleTests();
        }
        catch (IOException e) {
            Assert.assertTrue((String)("IOException, should not happen" + e.getMessage()), (boolean)false);
            e.printStackTrace();
        }
    }

    @Test
    public void test_Access_ReadAll_URL() {
        try {
            URL url = new URL(this.anUndirectedTriangleHttpURL());
            URLConnection c = url.openConnection();
            c.setDefaultUseCaches(false);
            this.input.addSink(this.graph);
            this.input.readAll(url);
            this.undirectedTriangleTests();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)("IOException, should not happen" + e.getMessage()), (boolean)false);
        }
    }

    @Test
    public void test_Access_ReadAll_FileName() {
        try {
            this.input.addSink(this.graph);
            this.input.readAll(this.anUndirectedTriangleFileName());
            this.undirectedTriangleTests();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)("IOException, should not happen" + e.getMessage()), (boolean)false);
        }
    }

    @Test
    public void test_DirectedTriangle() {
        try {
            this.input.addSink(this.graph);
            this.input.readAll(new StringReader(this.aDirectedTriangle()));
            this.directedTriangleTests();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)("IOException, should not happen" + e.getMessage()), (boolean)false);
        }
    }

    @Test
    public void test_Attributes() {
        try {
            this.input.addSink(this.graph);
            this.input.readAll(new StringReader(this.basicAttributes()));
            this.basicAttributesTests();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((String)("IOException, should not happen" + e.getMessage()), (boolean)true);
        }
    }

    protected void undirectedTriangleTests() {
        Assert.assertEquals((long)3L, (long)this.graph.getEdgeCount());
        Assert.assertEquals((long)3L, (long)this.graph.getNodeCount());
        Assert.assertNotNull(this.graph.getNode("A"));
        Assert.assertNotNull(this.graph.getNode("B"));
        Assert.assertNotNull(this.graph.getNode("C"));
        if (this.testEdgeIds) {
            Assert.assertNotNull(this.graph.getEdge("AB"));
            Assert.assertNotNull(this.graph.getEdge("BC"));
            Assert.assertNotNull(this.graph.getEdge("CA"));
        }
    }

    protected void directedTriangleTests() {
        Object CA;
        Object BC;
        Object AB;
        Assert.assertEquals((long)3L, (long)this.graph.getEdgeCount());
        Assert.assertEquals((long)3L, (long)this.graph.getNodeCount());
        Object A = this.graph.getNode("A");
        Object B = this.graph.getNode("B");
        Object C = this.graph.getNode("C");
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        if (this.testEdgeIds) {
            AB = this.graph.getEdge("AB");
            BC = this.graph.getEdge("BC");
            CA = this.graph.getEdge("CA");
            Assert.assertNotNull(AB);
            Assert.assertNotNull(BC);
            Assert.assertNotNull(CA);
            Assert.assertTrue((boolean)AB.isDirected());
            Assert.assertFalse((boolean)BC.isDirected());
            Assert.assertTrue((boolean)CA.isDirected());
            Assert.assertEquals((Object)"A", (Object)AB.getNode0().getId());
            Assert.assertEquals((Object)"B", (Object)AB.getNode1().getId());
            Assert.assertEquals((Object)"B", (Object)BC.getNode0().getId());
            Assert.assertEquals((Object)"C", (Object)BC.getNode1().getId());
            Assert.assertEquals((Object)"A", (Object)CA.getNode0().getId());
            Assert.assertEquals((Object)"C", (Object)CA.getNode1().getId());
        }
        Assert.assertTrue((boolean)A.hasEdgeToward("B"));
        Assert.assertTrue((boolean)A.hasEdgeToward("C"));
        Assert.assertTrue((boolean)B.hasEdgeToward("C"));
        Assert.assertFalse((boolean)B.hasEdgeToward("A"));
        Assert.assertFalse((boolean)C.hasEdgeToward("A"));
        Assert.assertTrue((boolean)C.hasEdgeToward("B"));
        AB = A.getEdgeToward("B");
        BC = B.getEdgeToward("C");
        CA = A.getEdgeToward("C");
        Assert.assertNotNull(AB);
        Assert.assertNotNull(BC);
        Assert.assertNotNull(CA);
        Assert.assertTrue((boolean)AB.isDirected());
        Assert.assertFalse((boolean)BC.isDirected());
        Assert.assertTrue((boolean)CA.isDirected());
        Assert.assertEquals((Object)"B", (Object)AB.getNode1().getId());
        Assert.assertEquals((Object)"C", (Object)BC.getNode1().getId());
        Assert.assertEquals((Object)"C", (Object)CA.getNode1().getId());
    }

    protected void basicAttributesTests() {
        Assert.assertEquals((long)3L, (long)this.graph.getEdgeCount());
        Assert.assertEquals((long)3L, (long)this.graph.getNodeCount());
        Object A = this.graph.getNode("A");
        Object B = this.graph.getNode("B");
        Object C = this.graph.getNode("C");
        Assert.assertNotNull(A);
        Assert.assertNotNull(B);
        Assert.assertNotNull(C);
        Assert.assertTrue((boolean)A.hasAttribute("a"));
        Assert.assertTrue((boolean)A.hasAttribute("b"));
        Assert.assertTrue((boolean)A.hasAttribute("c"));
        Assert.assertTrue((boolean)B.hasAttribute("aa"));
        Assert.assertTrue((boolean)B.hasAttribute("bb"));
        Assert.assertTrue((boolean)B.hasAttribute("cc"));
        Assert.assertTrue((boolean)C.hasAttribute("aaa"));
        Assert.assertEquals((Object)1.0, A.getAttribute("a"));
        Assert.assertEquals((Object)"truc", A.getAttribute("b"));
        Assert.assertEquals((Object)"true", A.getAttribute("c"));
        Assert.assertNotNull(B.getAttribute("aa"));
        Assert.assertEquals((Object)"foo", B.getAttribute("bb"));
        Assert.assertEquals((Object)"bar", B.getAttribute("cc"));
        Assert.assertEquals((Object)1.234, C.getAttribute("aaa"));
    }
}

