/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.viewer.test;

import java.io.IOException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.MultiGraph;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.file.FileSourceDGS;
import org.graphstream.stream.file.FileSourceGML;
import org.graphstream.stream.file.FileSourceParser;
import org.graphstream.stream.thread.ThreadProxyPipe;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphPosLengthUtils;
import org.graphstream.ui.layout.springbox.implementations.LinLog;
import org.graphstream.ui.swingViewer.Viewer;

public class DemoLayoutAndViewer {
    public static final String GRAPH = "data/dolphins.gml";
    public static double a = 0.0;
    public static double r = -1.2;
    public static double force = 8.0;
    protected static String styleSheet = "node { size: 7px; fill-color: rgb(150,150,150); }edge { fill-color: rgb(255,50,50); size: 2px; }edge.cut { fill-color: rgba(200,200,200,128); }";

    public static void main(String[] args) {
        new DemoLayoutAndViewer();
    }

    public DemoLayoutAndViewer() {
        boolean loop = true;
        MultiGraph graph = new MultiGraph("test");
        Viewer viewer = new Viewer(new ThreadProxyPipe(graph));
        ProxyPipe fromViewer = viewer.newThreadProxyOnGraphicGraph();
        LinLog layout = new LinLog(false);
        layout.configure(a, r, true, force);
        graph.addAttribute("ui.antialias", new Object[0]);
        graph.addAttribute("ui.stylesheet", styleSheet);
        fromViewer.addSink(graph);
        viewer.addDefaultView(true);
        graph.addSink(layout);
        layout.addAttributeSink(graph);
        FileSourceParser dgs = GRAPH.endsWith(".gml") ? new FileSourceGML() : new FileSourceDGS();
        dgs.addSink(graph);
        try {
            dgs.begin(this.getClass().getResourceAsStream(GRAPH));
            int i = 0;
            while (i < 5000 && dgs.nextEvents()) {
                ++i;
            }
            dgs.end();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.exit(1);
        }
        System.out.println("Finished creating the graph.");
        while (loop) {
            fromViewer.pump();
            if (graph.hasAttribute("ui.viewClosed")) {
                loop = false;
                continue;
            }
            layout.compute();
            this.findCommunities(graph, 1.3);
        }
        System.exit(0);
    }

    protected void findCommunities(Graph graph, double threshold) {
        Object edge;
        int nedges = graph.getEdgeCount();
        double avgDist = 0.0;
        double[] edgesDists = new double[nedges];
        int i = 0;
        while (i < nedges) {
            edge = graph.getEdge(i);
            Point3 posFrom = GraphPosLengthUtils.nodePointPosition(edge.getNode0());
            Point3 posTo = GraphPosLengthUtils.nodePointPosition(edge.getNode1());
            edgesDists[i] = posFrom.distance(posTo);
            avgDist += edgesDists[i];
            ++i;
        }
        avgDist /= (double)nedges;
        i = 0;
        while (i < nedges) {
            edge = graph.getEdge(i);
            if (edgesDists[i] > avgDist * threshold) {
                edge.addAttribute("ui.class", "cut");
            } else {
                edge.removeAttribute("ui.class");
            }
            ++i;
        }
    }

    protected static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

