package Absyn
  uniontype Info
      record INFO
          String x1;
      Integer x2;
      Integer x3;
      Integer x4;
      Integer x5;
    end INFO;
  end Info;
  type Ident = String;
  uniontype Program
      type ClassList = list<Class>;
    type PathOption = option<Path>;
    type RMLInterfaceList = list<RMLInterface>;
    type RMLDefsList = list<RMLDefs>;
    record PROGRAM
          ClassList x1;
      Within x2;
    end PROGRAM;
    record BEGIN_DEFINITION
          Path x1;
      Restriction x2;
      Boolean x3;
      Boolean x4;
    end BEGIN_DEFINITION;
    record END_DEFINITION
          Ident x1;
    end END_DEFINITION;
    record COMP_DEFINITION
          ElementSpec x1;
      PathOption x2;
    end COMP_DEFINITION;
    record IMPORT_DEFINITION
          ElementSpec x1;
      PathOption x2;
    end IMPORT_DEFINITION;
    record RML_FILE
          RMLIdent x1;
      RMLInterfaceList x2;
      RMLDefsList x3;
    end RML_FILE;
  end Program;
  uniontype Within
      record WITHIN
          Path x1;
    end WITHIN;
    record TOP
    end TOP;
  end Within;
  uniontype Class
      record CLASS
          Ident x1;
      Boolean x2;
      Boolean x3;
      Boolean x4;
      Restriction x5;
      ClassDef x6;
    end CLASS;
  end Class;
  uniontype ClassDef
      type ClassPartList = list<ClassPart>;
    type StringOption = option<String>;
    type ArrayDimOption = option<ArrayDim>;
    type ElementArgList = list<ElementArg>;
    type CommentOption = option<Comment>;
    type PathList = list<Path>;
    type EnumLiteralList = list<EnumLiteral>;
    record PARTS
          ClassPartList x1;
      StringOption x2;
    end PARTS;
    record DERIVED
          Path x1;
      ArrayDimOption x2;
      ElementAttributes x3;
      ElementArgList x4;
      CommentOption x5;
    end DERIVED;
    record DERIVED_TYPES
          Path x1;
      PathList x2;
      CommentOption x3;
    end DERIVED_TYPES;
    record ENUMERATION
          EnumLiteralList x1;
      CommentOption x2;
    end ENUMERATION;
    record OVERLOAD
          PathList x1;
      CommentOption x2;
    end OVERLOAD;
  end ClassDef;
  uniontype EnumLiteral
      type CommentOption = option<Comment>;
    record ENUMLITERAL
          Ident x1;
      CommentOption x2;
    end ENUMLITERAL;
  end EnumLiteral;
  uniontype ClassPart
      type ElementItemList = list<ElementItem>;
    type EquationItemList = list<EquationItem>;
    type AlgorithmItemList = list<AlgorithmItem>;
    type AnnotationOption = option<Annotation>;
    record PUBLIC
          ElementItemList x1;
    end PUBLIC;
    record PROTECTED
          ElementItemList x1;
    end PROTECTED;
    record EQUATIONS
          EquationItemList x1;
    end EQUATIONS;
    record INITIALEQUATIONS
          EquationItemList x1;
    end INITIALEQUATIONS;
    record ALGORITHMS
          AlgorithmItemList x1;
    end ALGORITHMS;
    record INITIALALGORITHMS
          AlgorithmItemList x1;
    end INITIALALGORITHMS;
    record EXTERNAL
          ExternalDecl x1;
      AnnotationOption x2;
    end EXTERNAL;
  end ClassPart;
  uniontype ElementItem
      record ELEMENTITEM
          Element x1;
    end ELEMENTITEM;
    record ANNOTATIONITEM
          Annotation x1;
    end ANNOTATIONITEM;
  end ElementItem;
  uniontype Element
      type ConstrainClassOption = option<ConstrainClass>;
    record ELEMENT
          Boolean x1;
      Boolean x2;
      InnerOuter x3;
      Ident x4;
      ElementSpec x5;
      String x6;
      Integer x7;
      ConstrainClassOption x8;
    end ELEMENT;
  end Element;
  type ConstrainClass = ElementSpec;
  uniontype ElementSpec
      type ElementArgList = list<ElementArg>;
    type CommentOption = option<Comment>;
    type ComponentItemList = list<ComponentItem>;
    record CLASSDEF
          Boolean x1;
      Class x2;
    end CLASSDEF;
    record EXTENDS
          Path x1;
      ElementArgList x2;
    end EXTENDS;
    record IMPORT
          Import x1;
      CommentOption x2;
    end IMPORT;
    record COMPONENTS
          ElementAttributes x1;
      Path x2;
      ComponentItemList x3;
    end COMPONENTS;
  end ElementSpec;
  uniontype InnerOuter
      record INNER
    end INNER;
    record OUTER
    end OUTER;
    record UNSPECIFIED
    end UNSPECIFIED;
  end InnerOuter;
  uniontype Import
      record NAMED_IMPORT
          Ident x1;
      Path x2;
    end NAMED_IMPORT;
    record QUAL_IMPORT
          Path x1;
    end QUAL_IMPORT;
    record UNQUAL_IMPORT
          Path x1;
    end UNQUAL_IMPORT;
  end Import;
  uniontype ComponentItem
      type CommentOption = option<Comment>;
    record COMPONENTITEM
          Component x1;
      CommentOption x2;
    end COMPONENTITEM;
  end ComponentItem;
  uniontype Component
      type ModificationOption = option<Modification>;
    record COMPONENT
          Ident x1;
      ArrayDim x2;
      ModificationOption x3;
    end COMPONENT;
  end Component;
  uniontype EquationItem
      type CommentOption = option<Comment>;
    record EQUATIONITEM
          Equation x1;
      CommentOption x2;
    end EQUATIONITEM;
    record EQUATIONITEMANN
          Annotation x1;
    end EQUATIONITEMANN;
  end EquationItem;
  uniontype AlgorithmItem
      type CommentOption = option<Comment>;
    record ALGORITHMITEM
          Algorithm x1;
      CommentOption x2;
    end ALGORITHMITEM;
    record ALGORITHMITEMANN
          Annotation x1;
    end ALGORITHMITEMANN;
  end AlgorithmItem;
  uniontype Equation
      type EquationItemList = list<EquationItem>;
    type ExpEquationItemListRecord = record<Exp,EquationItemList>;
    type ExpEquationItemListRecordList = list<ExpEquationItemListRecord>;
    type EquationList = list<Equation>;
    record EQ_IF
          Exp x1;
      EquationItemList x2;
      ExpEquationItemListRecordList x3;
      EquationItemList x4;
    end EQ_IF;
    record EQ_EQUALS
          Exp x1;
      Exp x2;
    end EQ_EQUALS;
    record EQ_CONNECT
          ComponentRef x1;
      ComponentRef x2;
    end EQ_CONNECT;
    record EQ_FOR
          Ident x1;
      Exp x2;
      EquationItemList x3;
    end EQ_FOR;
    record EQ_WHEN_E
          Exp x1;
      EquationItemList x2;
      ExpEquationItemListRecordList x3;
    end EQ_WHEN_E;
    record EQ_NORETCALL
          Ident x1;
      FunctionArgs x2;
    end EQ_NORETCALL;
    record EQ_LET
          Pattern x1;
      Exp x2;
    end EQ_LET;
    record EQ_STRUCTEQUAL
          Ident x1;
      Exp x2;
    end EQ_STRUCTEQUAL;
    record EQ_NOT
          EquationList x1;
    end EQ_NOT;
    record EQ_CALL
          Path x1;
      FunctionArgs x2;
      Pattern x3;
    end EQ_CALL;
  end Equation;
  uniontype Algorithm
      type AlgorithmItemList = list<AlgorithmItem>;
    type ExpAlgorithmItemListRecord = record<Exp,AlgorithmItemList>;
    type ExpAlgorithmItemListRecordList = list<ExpAlgorithmItemListRecord>;
    type ComponentRefOption = option<ComponentRef>;
    type ElementItemList = list<ElementItem>;
    type CaseList = list<Case>;
    record ALG_ASSIGN
          ComponentRef x1;
      Exp x2;
    end ALG_ASSIGN;
    record ALG_TUPLE_ASSIGN
          Exp x1;
      Exp x2;
    end ALG_TUPLE_ASSIGN;
    record ALG_IF
          Exp x1;
      AlgorithmItemList x2;
      ExpAlgorithmItemListRecordList x3;
      AlgorithmItemList x4;
    end ALG_IF;
    record ALG_FOR
          Ident x1;
      Exp x2;
      AlgorithmItemList x3;
    end ALG_FOR;
    record ALG_WHILE
          Exp x1;
      AlgorithmItemList x2;
    end ALG_WHILE;
    record ALG_WHEN_A
          Exp x1;
      AlgorithmItemList x2;
      ExpAlgorithmItemListRecordList x3;
    end ALG_WHEN_A;
    record ALG_NORETCALL
          ComponentRef x1;
      FunctionArgs x2;
    end ALG_NORETCALL;
    record ALG_MATCH
          ComponentRefOption x1;
      Exp x2;
      ElementItemList x3;
      CaseList x4;
    end ALG_MATCH;
  end Algorithm;
  uniontype Case
      type PatternList = list<Pattern>;
    type ElementItemList = list<ElementItem>;
    record CASE
          PatternList x1;
      ElementItemList x2;
      ClassPart x3;
      Exp x4;
    end CASE;
  end Case;
  uniontype Pattern
      type PathOption = option<Path>;
    type PatternList = list<Pattern>;
    record MWILDpat
    end MWILDpat;
    record MLITpat
          Exp x1;
    end MLITpat;
    record MCONpat
          Path x1;
    end MCONpat;
    record MSTRUCTpat
          PathOption x1;
      PatternList x2;
    end MSTRUCTpat;
    record MBINDpat
          Ident x1;
      Pattern x2;
    end MBINDpat;
    record MIDENTpat
          Ident x1;
      Pattern x2;
    end MIDENTpat;
  end Pattern;
  uniontype Modification
      type ElementArgList = list<ElementArg>;
    type ExpOption = option<Exp>;
    record CLASSMOD
          ElementArgList x1;
      ExpOption x2;
    end CLASSMOD;
  end Modification;
  uniontype ElementArg
      type ModificationOption = option<Modification>;
    type StringOption = option<String>;
    type ConstrainClassOption = option<ConstrainClass>;
    record MODIFICATION
          Boolean x1;
      Each x2;
      ComponentRef x3;
      ModificationOption x4;
      StringOption x5;
    end MODIFICATION;
    record REDECLARATION
          Boolean x1;
      Each x2;
      ElementSpec x3;
      ConstrainClassOption x4;
    end REDECLARATION;
  end ElementArg;
  uniontype Each
      record EACH
    end EACH;
    record NON_EACH
    end NON_EACH;
  end Each;
  uniontype ElementAttributes
      record ATTR
          Boolean x1;
      Variability x2;
      Direction x3;
      ArrayDim x4;
    end ATTR;
  end ElementAttributes;
  uniontype Variability
      record VAR
    end VAR;
    record DISCRETE
    end DISCRETE;
    record PARAM
    end PARAM;
    record CONST
    end CONST;
  end Variability;
  uniontype Direction
      record INPUT
    end INPUT;
    record OUTPUT
    end OUTPUT;
    record BIDIR
    end BIDIR;
  end Direction;
  type ArrayDim = list<Subscript>;
  uniontype Exp
      type ExpExpRecord = record<Exp,Exp>;
    type ExpExpRecordList = list<ExpExpRecord>;
    type ExpList = list<Exp>;
    type ExpListList = list<ExpList>;
    type ExpOption = option<Exp>;
    type PathOption = option<Path>;
    record INTEGER
          Integer x1;
    end INTEGER;
    record REAL
          Real x1;
    end REAL;
    record CREF
          ComponentRef x1;
    end CREF;
    record STRING
          String x1;
    end STRING;
    record BOOL
          Boolean x1;
    end BOOL;
    record BINARY
          Exp x1;
      Operator x2;
      Exp x3;
    end BINARY;
    record UNARY
          Operator x1;
      Exp x2;
    end UNARY;
    record LBINARY
          Exp x1;
      Operator x2;
      Exp x3;
    end LBINARY;
    record LUNARY
          Operator x1;
      Exp x2;
    end LUNARY;
    record RELATION
          Exp x1;
      Operator x2;
      Exp x3;
    end RELATION;
    record IFEXP
          Exp x1;
      Exp x2;
      Exp x3;
      ExpExpRecordList x4;
    end IFEXP;
    record CALL
          ComponentRef x1;
      FunctionArgs x2;
    end CALL;
    record ARRAY
          ExpList x1;
    end ARRAY;
    record MATRIX
          ExpListList x1;
    end MATRIX;
    record RANGE
          Exp x1;
      ExpOption x2;
      Exp x3;
    end RANGE;
    record TUPLE
          ExpList x1;
    end TUPLE;
    record END
    end END;
    record CODE
          Code x1;
    end CODE;
    record RMLCALL
          RMLIdent x1;
      ExpList x2;
    end RMLCALL;
    record RMLCONS
          Exp x1;
      Exp x2;
    end RMLCONS;
    record RMLNIL
    end RMLNIL;
    record RMLLIST
          ExpList x1;
    end RMLLIST;
    record RMLLIT
          RMLLiteral x1;
    end RMLLIT;
    record RML_REFERENCE
          RMLIdent x1;
    end RML_REFERENCE;
    record MSTRUCTURAL
          PathOption x1;
      ExpList x2;
    end MSTRUCTURAL;
  end Exp;
  uniontype Code
      type EquationItemList = list<EquationItem>;
    type AlgorithmItemList = list<AlgorithmItem>;
    record C_TYPENAME
          Path x1;
    end C_TYPENAME;
    record C_VARIABLENAME
          ComponentRef x1;
    end C_VARIABLENAME;
    record C_EQUATIONSECTION
          Boolean x1;
      EquationItemList x2;
    end C_EQUATIONSECTION;
    record C_ALGORITHMSECTION
          Boolean x1;
      AlgorithmItemList x2;
    end C_ALGORITHMSECTION;
    record C_ELEMENT
          Element x1;
    end C_ELEMENT;
    record C_EXPRESSION
          Exp x1;
    end C_EXPRESSION;
    record C_MODIFICATION
          Modification x1;
    end C_MODIFICATION;
  end Code;
  uniontype FunctionArgs
      type ExpList = list<Exp>;
    type NamedArgList = list<NamedArg>;
    record FUNCTIONARGS
          ExpList x1;
      NamedArgList x2;
    end FUNCTIONARGS;
    record FOR_ITER_FARG
          Exp x1;
      Ident x2;
      Exp x3;
    end FOR_ITER_FARG;
  end FunctionArgs;
  uniontype NamedArg
      record NAMEDARG
          Ident x1;
      Exp x2;
    end NAMEDARG;
  end NamedArg;
  uniontype Operator
      record ADD
    end ADD;
    record SUB
    end SUB;
    record MUL
    end MUL;
    record DIV
    end DIV;
    record POW
    end POW;
    record UPLUS
    end UPLUS;
    record UMINUS
    end UMINUS;
    record AND
    end AND;
    record OR
    end OR;
    record NOT
    end NOT;
    record LESS
    end LESS;
    record LESSEQ
    end LESSEQ;
    record GREATER
    end GREATER;
    record GREATEREQ
    end GREATEREQ;
    record EQUAL
    end EQUAL;
    record NEQUAL
    end NEQUAL;
  end Operator;
  uniontype Subscript
      record NOSUB
    end NOSUB;
    record SUBSCRIPT
          Exp x1;
    end SUBSCRIPT;
  end Subscript;
  uniontype ComponentRef
      type SubscriptList = list<Subscript>;
    type SubscriptListRecord = record<SubscriptList>;
    record CREF_QUAL
          Ident x1;
      SubscriptList x2;
      ComponentRef x3;
    end CREF_QUAL;
    record CREF_IDENT
          Ident x1;
      SubscriptList x2;
    end CREF_IDENT;
  end ComponentRef;
  uniontype Path
      record QUALIFIED
          Ident x1;
      Path x2;
    end QUALIFIED;
    record IDENT
          Ident x1;
    end IDENT;
  end Path;
  uniontype Restriction
      record R_CLASS
    end R_CLASS;
    record R_MODEL
    end R_MODEL;
    record R_RECORD
    end R_RECORD;
    record R_BLOCK
    end R_BLOCK;
    record R_CONNECTOR
    end R_CONNECTOR;
    record R_TYPE
    end R_TYPE;
    record R_PACKAGE
    end R_PACKAGE;
    record R_FUNCTION
    end R_FUNCTION;
    record R_ENUMERATION
    end R_ENUMERATION;
    record R_PREDEFINED_INT
    end R_PREDEFINED_INT;
    record R_PREDEFINED_REAL
    end R_PREDEFINED_REAL;
    record R_PREDEFINED_STRING
    end R_PREDEFINED_STRING;
    record R_PREDEFINED_BOOL
    end R_PREDEFINED_BOOL;
    record R_PREDEFINED_ENUM
    end R_PREDEFINED_ENUM;
    record R_UNIONTYPE
    end R_UNIONTYPE;
  end Restriction;
  uniontype Annotation
      type ElementArgList = list<ElementArg>;
    record ANNOTATION
          ElementArgList x1;
    end ANNOTATION;
  end Annotation;
  uniontype Comment
      type AnnotationOption = option<Annotation>;
    type StringOption = option<String>;
    record COMMENT
          AnnotationOption x1;
      StringOption x2;
    end COMMENT;
  end Comment;
  uniontype ExternalDecl
      type IdentOption = option<Ident>;
    type StringOption = option<String>;
    type ComponentRefOption = option<ComponentRef>;
    type ExpList = list<Exp>;
    record EXTERNALDECL
          IdentOption x1;
      StringOption x2;
      ComponentRefOption x3;
      ExpList x4;
    end EXTERNALDECL;
  end ExternalDecl;
  uniontype RMLDatatype
      type RMLTypeList = list<RMLType>;
    type DTMemberList = list<DTMember>;
    record DATATYPE
          RMLTypeList x1;
      RMLIdent x2;
      DTMemberList x3;
    end DATATYPE;
  end RMLDatatype;
  uniontype RMLDecl
      type RMLTypeOption = option<RMLType>;
    type RMLRuleList = list<RMLRule>;
    record RELATION_INTERFACE
          RMLIdent x1;
      RMLType x2;
    end RELATION_INTERFACE;
    record DATATYPEDECL
          RMLDatatype x1;
    end DATATYPEDECL;
    record TYPE
          RMLIdent x1;
      RMLType x2;
    end TYPE;
    record WITH
          String x1;
    end WITH;
    record VALINTERFACE
          RMLIdent x1;
      RMLType x2;
    end VALINTERFACE;
    record VALDEF
          RMLIdent x1;
      Exp x2;
    end VALDEF;
    record RELATION_DEFINITION
          RMLIdent x1;
      RMLTypeOption x2;
      RMLRuleList x3;
    end RELATION_DEFINITION;
    record RMLDECLCOMMENT
          String x1;
    end RMLDECLCOMMENT;
  end RMLDecl;
  type RMLInterface = RMLDecl;
  type RMLDefs = RMLDecl;
  uniontype RMLSignature
      type RMLTypeList = list<RMLType>;
    record CALLSIGN
          RMLTypeList x1;
      RMLTypeList x2;
    end CALLSIGN;
  end RMLSignature;
  uniontype RMLType
      type RMLTypeList = list<RMLType>;
    record RMLTYPE_INT
    end RMLTYPE_INT;
    record RMLTYPE_STRING
    end RMLTYPE_STRING;
    record RMLTYPE_REAL
    end RMLTYPE_REAL;
    record RMLTYPE_TYCONS
          RMLTypeList x1;
      RMLIdent x2;
    end RMLTYPE_TYCONS;
    record RMLTYPE_SIGNATURE
          RMLSignature x1;
    end RMLTYPE_SIGNATURE;
    record RMLTYPE_TUPLE
          RMLTypeList x1;
    end RMLTYPE_TUPLE;
    record RMLTYPE_TYVAR
          RMLIdent x1;
    end RMLTYPE_TYVAR;
    record RMLTYPE_USERDEFINED
          RMLIdent x1;
    end RMLTYPE_USERDEFINED;
  end RMLType;
  uniontype RMLRule
      type RMLGoalOption = option<RMLGoal>;
    record RMLRULE
          RMLIdent x1;
      RMLPattern x2;
      RMLGoalOption x3;
      RMLResult x4;
    end RMLRULE;
  end RMLRule;
  uniontype RMLResult
      type ExpList = list<Exp>;
    record RMLNoResult
    end RMLNoResult;
    record RMLResultExp
          ExpList x1;
    end RMLResultExp;
    record RMLResultFail
    end RMLResultFail;
  end RMLResult;
  uniontype RMLGoal
      type ExpList = list<Exp>;
    type RMLPatternOption = option<RMLPattern>;
    record RMLGOAL_NOT
          RMLGoal x1;
    end RMLGOAL_NOT;
    record RMLGOAL_AND
          RMLGoal x1;
      RMLGoal x2;
    end RMLGOAL_AND;
    record RMLGOAL_PAT
          RMLPattern x1;
    end RMLGOAL_PAT;
    record RMLGOAL_LET
          RMLPattern x1;
      Exp x2;
    end RMLGOAL_LET;
    record RMLGOAL_EQUAL
          RMLIdent x1;
      Exp x2;
    end RMLGOAL_EQUAL;
    record RMLGOAL_RELATION
          RMLIdent x1;
      ExpList x2;
      RMLPatternOption x3;
    end RMLGOAL_RELATION;
  end RMLGoal;
  uniontype RMLPattern
      type RMLIdentOption = option<RMLIdent>;
    type RMLPatternList = list<RMLPattern>;
    record RMLPAT_WILDCARD
    end RMLPAT_WILDCARD;
    record RMLPAT_LITERAL
          RMLLiteral x1;
    end RMLPAT_LITERAL;
    record RMLPAT_IDENT
          RMLIdent x1;
    end RMLPAT_IDENT;
    record RMLPAT_AS
          RMLIdent x1;
      RMLPattern x2;
    end RMLPAT_AS;
    record RMLPAT_CONS
          RMLPattern x1;
      RMLPattern x2;
    end RMLPAT_CONS;
    record RMLPAT_STRUCT
          RMLIdentOption x1;
      RMLPatternList x2;
    end RMLPAT_STRUCT;
    record RMLPAT_NIL
    end RMLPAT_NIL;
    record RMLPAT_LIST
          RMLPatternList x1;
    end RMLPAT_LIST;
  end RMLPattern;
  uniontype RMLIdent
      record RMLSHORTID
          Ident x1;
      Info x2;
    end RMLSHORTID;
    record RMLLONGID
          Ident x1;
      Ident x2;
    end RMLLONGID;
  end RMLIdent;
  uniontype RMLLiteral
      record RMLLIT_INTEGER
          Integer x1;
    end RMLLIT_INTEGER;
    record RMLLIT_STRING
          String x1;
    end RMLLIT_STRING;
    record RMLLIT_REAL
          Real x1;
    end RMLLIT_REAL;
    record RMLLIT_CHAR
          Integer x1;
    end RMLLIT_CHAR;
  end RMLLiteral;
  uniontype DTMember
      type RMLTypeList = list<RMLType>;
    record DTCONS
          RMLIdent x1;
      RMLTypeList x2;
    end DTCONS;
  end DTMember;
  uniontype RMLDbRange
      record RMLDB_RANGE
          Integer x1;
      Integer x2;
      Integer x3;
      Integer x4;
    end RMLDB_RANGE;
  end RMLDbRange;
  uniontype RMLDbElement
      record RMLDB_VAR
          String x1;
      RMLIdent x2;
      RMLDbRange x3;
      RMLDbRange x4;
      RMLIdent x5;
      RMLType x6;
    end RMLDB_VAR;
    record RMLDB_REL
          String x1;
      RMLIdent x2;
      RMLDbRange x3;
      RMLType x4;
    end RMLDB_REL;
    record RMLDB_TY
          String x1;
      RMLIdent x2;
      RMLDbRange x3;
    end RMLDB_TY;
    record RMLDB_CTOR
          String x1;
      RMLIdent x2;
      RMLDbRange x3;
      RMLType x4;
    end RMLDB_CTOR;
  end RMLDbElement;
  uniontype RMLDb
      type RMLDbElementList = list<RMLDbElement>;
    record RMLDB
          RMLDbElementList x1;
    end RMLDB;
  end RMLDb;
end Absyn;

