within OpenFDM.Aircraft.Aerosonde;

package Datcom

constant OpenFDM.Aerodynamics.Datcom.Tables tables(

  // lift
  CL_Basic =   {      
    { -16,    -1.533},      
    {  -8,    -0.602},      
    {  -6,    -0.369},      
    {  -4,    -0.142},      
    {  -2,     0.083},      
    {   0,     0.315},      
    {   2,     0.552},      
    {   4,     0.795},      
    {   8,     1.288},      
    {   9,     1.401},      
    {  10,     1.503},      
    {  12,     1.685},      
    {  14,     1.832},      
    {  16,     1.933},      
    {  18,     1.892},      
    {  19,     1.589},      
    {  20,     1.226},      
    {  21,     0.891},      
    {  22,     0.646},      
    {  24,      0.18}},
  dCL_Flap  =   {      
    {   0,         0},      
    {   5,     0.086},      
    {  10,     0.172},      
    {  15,     0.254},      
    {  20,     0.332},      
    {  25,     0.407},      
    {  30,     0.468},      
    {  35,     0.515},      
    {  40,     0.547}},
  dCL_Elevator  =   {      
    { -28,    -0.142},      
    { -20,    -0.125},      
    { -10,     -0.09},      
    {  -5,    -0.045},      
    {   0,         0},      
    {   5,     0.045},      
    {  10,      0.09},      
    {  20,     0.125},      
    {  28,     0.142}},
  dCL_PitchRate =   {      
    { -16,    0.1727}},
  dCL_AlphaDot  =   {      
    { -16,   0.02933},      
    {  -8,   0.03257},      
    {  -6,   0.03381},      
    {  -4,   0.03499},      
    {  -2,   0.03694},      
    {   0,   0.03907},      
    {   2,   0.04098},      
    {   4,   0.04275},      
    {   8,   0.04536},      
    {   9,   0.03893},      
    {  10,   0.02967},      
    {  12,   0.02287},      
    {  14,   0.01428},      
    {  16, -0.009362},      
    {  18,  -0.04021},      
    {  19,   -0.0978},      
    {  20,   -0.1347},      
    {  21,   -0.1004},      
    {  22,  -0.08004},      
    {  24,  -0.07793}},

  // drag
  CD_Basic  =   {      
    { -16,     0.813},      
    {  -8,     0.235},      
    {  -6,     0.151},      
    {  -4,     0.092},      
    {  -2,     0.058},      
    {   0,      0.05},      
    {   2,     0.067},      
    {   4,     0.111},      
    {   8,     0.276},      
    {   9,     0.332},      
    {  10,     0.393},      
    {  12,     0.529},      
    {  14,     0.683},      
    {  16,     0.852},      
    {  18,     1.021},      
    {  19,     1.082},      
    {  20,     1.152},      
    {  21,     1.236},      
    {  22,     1.334},      
    {  24,     1.562}},
  dCD_Flap  =     {
    {-999,         0,         5,        10,        15,        20,        25,        30,        35,        40  },    
    { -16, -1.18e-05,  -0.00543,  -0.00986,   -0.0131,   -0.0155,   -0.0169,   -0.0176,   -0.0177,   -0.0177},    
    {  -8, -4.17e-06,  -0.00159,  -0.00219,  -0.00185, -0.000688,   0.00117,   0.00326,   0.00517,   0.00668},    
    {  -6, -2.25e-06,  -0.00063, -0.000272,  0.000975,   0.00301,    0.0057,   0.00847,    0.0109,    0.0128},    
    {  -4, -3.29e-07,  0.000329,   0.00165,    0.0038,    0.0067,    0.0102,    0.0137,    0.0166,    0.0189},    
    {  -2,  1.59e-06,   0.00129,   0.00356,   0.00662,    0.0104,    0.0147,    0.0189,    0.0223,    0.0249},    
    {   0,  3.51e-06,   0.00225,   0.00548,   0.00945,    0.0141,    0.0193,    0.0241,    0.0281,     0.031},    
    {   2,  5.43e-06,   0.00321,    0.0074,    0.0123,    0.0178,    0.0238,    0.0293,    0.0338,    0.0371},    
    {   4,  7.35e-06,   0.00417,   0.00932,    0.0151,    0.0215,    0.0283,    0.0345,    0.0395,    0.0432},    
    {   8,  1.12e-05,   0.00609,    0.0131,    0.0207,    0.0289,    0.0374,    0.0449,     0.051,    0.0554},    
    {   9,  1.22e-05,   0.00657,    0.0141,    0.0222,    0.0307,    0.0396,    0.0475,    0.0538,    0.0584},    
    {  10,  1.31e-05,   0.00705,    0.0151,    0.0236,    0.0326,    0.0419,    0.0501,    0.0567,    0.0614},    
    {  12,   1.5e-05,     0.008,     0.017,    0.0264,    0.0363,    0.0464,    0.0553,    0.0624,    0.0675},    
    {  14,  1.69e-05,   0.00896,    0.0189,    0.0292,      0.04,    0.0509,    0.0605,    0.0681,    0.0736},    
    {  16,  1.89e-05,   0.00992,    0.0208,     0.032,    0.0437,    0.0555,    0.0657,    0.0738,    0.0797},    
    {  18,  2.08e-05,    0.0109,    0.0227,    0.0349,    0.0474,      0.06,    0.0709,    0.0796,    0.0858},    
    {  19,  2.18e-05,    0.0114,    0.0237,    0.0363,    0.0492,    0.0623,    0.0735,    0.0824,    0.0888},    
    {  20,  2.27e-05,    0.0118,    0.0247,    0.0377,    0.0511,    0.0645,    0.0762,    0.0853,    0.0919},    
    {  21,  2.37e-05,    0.0123,    0.0256,    0.0391,    0.0529,    0.0668,    0.0788,    0.0882,    0.0949},    
    {  22,  2.47e-05,    0.0128,    0.0266,    0.0405,    0.0547,     0.069,    0.0814,     0.091,     0.098},    
    {  24,  2.66e-05,    0.0138,    0.0285,    0.0433,    0.0584,    0.0736,    0.0866,    0.0967,     0.104}},
  dCD_Elevator  =     {
    {-999,       -28,       -20,       -10,        -5,         0,         5,        10,        20,        28  },    
    { -16,    0.0134,    0.0113,   0.00725,   0.00307, -5.04e-06,  -0.00197,  -0.00283,  -0.00273,  -0.00246},    
    {  -8,   0.00817,   0.00666,   0.00393,   0.00141, -1.72e-06, -0.000306,  0.000496,   0.00189,   0.00277},    
    {  -6,   0.00692,   0.00556,   0.00314,   0.00101,  -9.2e-07,  9.22e-05,   0.00129,   0.00299,   0.00402},    
    {  -4,   0.00568,   0.00446,   0.00235,   0.00062, -1.32e-07,  0.000486,   0.00208,   0.00409,   0.00526},    
    {  -2,   0.00446,   0.00339,   0.00157,  0.000233,  6.43e-07,  0.000874,   0.00285,   0.00517,   0.00647},    
    {   0,   0.00328,   0.00234,  0.000819, -0.000144,   1.4e-06,   0.00125,   0.00361,   0.00621,   0.00766},    
    {   2,   0.00212,   0.00131,  8.13e-05, -0.000513,  2.13e-06,   0.00162,   0.00435,   0.00724,   0.00882},    
    {   4,  0.000985,  0.000312, -0.000639, -0.000873,  2.85e-06,   0.00198,   0.00507,   0.00824,   0.00995},    
    {   8,  -0.00122,  -0.00164,  -0.00204,  -0.00157,  4.25e-06,   0.00268,   0.00647,    0.0102,    0.0122},    
    {   9,  -0.00176,  -0.00211,  -0.00238,  -0.00175,   4.6e-06,   0.00285,   0.00681,    0.0107,    0.0127},    
    {  10,  -0.00239,  -0.00267,  -0.00279,  -0.00195,     5e-06,   0.00305,   0.00721,    0.0112,    0.0133},    
    {  12,  -0.00376,  -0.00389,  -0.00366,  -0.00238,  5.87e-06,   0.00349,   0.00809,    0.0124,    0.0147},    
    {  14,  -0.00518,  -0.00514,  -0.00456,  -0.00283,  6.78e-06,   0.00394,   0.00899,    0.0137,    0.0161},    
    {  16,  -0.00679,  -0.00656,  -0.00558,  -0.00335,   7.8e-06,   0.00445,      0.01,    0.0151,    0.0177},    
    {  18,  -0.00885,  -0.00839,   -0.0069,    -0.004,  9.12e-06,   0.00511,    0.0113,    0.0169,    0.0198},    
    {  19,     -0.01,  -0.00945,  -0.00766,  -0.00438,  9.88e-06,   0.00549,    0.0121,     0.018,     0.021},    
    {  20,   -0.0119,   -0.0111,  -0.00886,  -0.00498,  1.11e-05,   0.00609,    0.0133,    0.0197,    0.0229},    
    {  21,   -0.0136,   -0.0126,  -0.00992,  -0.00552,  1.21e-05,   0.00662,    0.0144,    0.0211,    0.0245},    
    {  22,    -0.015,   -0.0138,   -0.0108,  -0.00596,   1.3e-05,   0.00707,    0.0152,    0.0224,     0.026},    
    {  24,   -0.0178,   -0.0163,   -0.0126,  -0.00685,  1.48e-05,   0.00796,     0.017,    0.0249,    0.0287}},

  // side force
  dCY_Beta  =   {      
    { -16, -0.008703}},
  dCY_RollRate  =   {      
    { -16,-2.141e-05},      
    {  -8, -0.001097},      
    {  -6, -0.001353},      
    {  -4, -0.001599},      
    {  -2, -0.001841},      
    {   0, -0.002093},      
    {   2, -0.002353},      
    {   4, -0.002622},      
    {   8, -0.003208},      
    {   9, -0.003365},      
    {  10, -0.003514},      
    {  12, -0.003777},      
    {  14,  -0.00402},      
    {  16, -0.004538},      
    {  18, -0.002749},      
    {  19, -0.002559},      
    {  20, -0.002014},      
    {  21, -0.001387},      
    {  22,-0.0008488},      
    {  24, 0.0003659}},

  // roll moment
  dCl_Aileron  =   {      
    { -56, -0.057601},      
    { -40,  -0.05196},      
    { -20, -0.030247},      
    { -10, -0.015124},      
    {   0,         0},      
    {  10,  0.015124},      
    {  20,  0.030247},      
    {  40,   0.05196},      
    {  56,  0.057601}},
  dCl_Beta  =   {     
    { -16, -0.002301},     
    {  -8, -0.001955},     
    {  -6, -0.001871},     
    {  -4, -0.001787},     
    {  -2, -0.001703},     
    {   0, -0.001616},     
    {   2, -0.001527},     
    {   4, -0.001437},     
    {   8, -0.001255},     
    {   9, -0.001213},     
    {  10, -0.001173},     
    {  12, -0.001097},     
    {  14,  -0.00103},     
    {  16, -0.000971},     
    {  18,-0.0009398},     
    {  19,-0.0009883},     
    {  20, -0.001047},     
    {  21, -0.001095},     
    {  22, -0.001121},     
    {  24, -0.001181}},
  dCl_RollRate  =   {      
    { -16, -0.006514},      
    {  -8,  -0.00617},      
    {  -6, -0.006025},      
    {  -4, -0.005877},      
    {  -2, -0.005953},      
    {   0, -0.006171},      
    {   2,  -0.00636},      
    {   4, -0.006499},      
    {   8,  -0.00609},      
    {   9, -0.005561},      
    {  10, -0.004919},      
    {  12, -0.003873},      
    {  14, -0.002589},      
    {  16, 0.0004904},      
    {  18,   0.01534},      
    {  19,   0.02274},      
    {  20,   0.02216},      
    {  21,   0.01776},      
    {  22,   0.01508},      
    {  24,   0.01509}},
  dCl_YawRate  =   {      
    { -16, -0.002374},      
    {  -8,-0.0005274},      
    {  -6,-8.532e-05},      
    {  -4,  0.000339},      
    {  -2, 0.0007572},      
    {   0,  0.001195},      
    {   2,  0.001648},      
    {   4,  0.002113},      
    {   8,  0.003062},      
    {   9,   0.00327},      
    {  10,  0.003445},      
    {  12,  0.003736},      
    {  14,  0.003933},      
    {  16,  0.004013},      
    {  18,  0.003717},      
    {  19,  0.002808},      
    {  20,  0.001802},      
    {  21, 0.0009363},      
    {  22, 0.0002949},      
    {  24, -0.001001}},

  // pitch moment
  Cm_Basic =   {     
    { -16,     0.434},     
    {  -8,     0.277},     
    {  -6,    0.1997},     
    {  -4,    0.1202},     
    {  -2,    0.0403},     
    {   0,   -0.0397},     
    {   2,   -0.1216},     
    {   4,   -0.2076},     
    {   8,   -0.3993},     
    {   9,   -0.4548},     
    {  10,   -0.5165},     
    {  12,   -0.6391},     
    {  14,   -0.7634},     
    {  16,   -0.0153},     
    {  18,   -0.0095},     
    {  19,    0.0126},     
    {  20,    0.1351},     
    {  21,    0.1985},     
    {  22,     0.155},     
    {  24,    0.0624}},
  dCm_Flap  =   {      
    {   0,    0.0001},      
    {   5,    0.0267},      
    {  10,    0.0534},      
    {  15,    0.0786},      
    {  20,    0.1029},      
    {  25,     0.126},      
    {  30,    0.1449},      
    {  35,    0.1593},      
    {  40,    0.1694}},
  dCm_Elevator  =   {      
    { -28,    0.7933},      
    { -20,    0.7003},      
    { -10,    0.5024},      
    {  -5,    0.2512},      
    {   0,   -0.0005},      
    {   5,   -0.2512},      
    {  10,   -0.5024},      
    {  20,   -0.7003},      
    {  28,   -0.7933}},
  dCm_PitchRate  =   {      
    { -16,   -0.7118}},
  dCm_AlphaDot  =   {      
    { -16,   -0.1644},      
    {  -8,   -0.1826},      
    {  -6,   -0.1896},      
    {  -4,   -0.1962},      
    {  -2,   -0.2071},      
    {   0,   -0.2191},      
    {   2,   -0.2298},      
    {   4,   -0.2397},      
    {   8,   -0.2544},      
    {   9,   -0.2183},      
    {  10,   -0.1663},      
    {  12,   -0.1282},      
    {  14,  -0.08008},      
    {  16,   0.05249},      
    {  18,    0.2255},      
    {  19,    0.5484},      
    {  20,    0.7554},      
    {  21,    0.5632},      
    {  22,    0.4488},      
    {  24,    0.4369}},

  // yaw moment
  dCn_Aileron  =     {
    {-999,       -56,       -40,       -20,       -10,         0,        10,        20,        40,        56  },    
    { -16, -0.005268, -0.004751, -0.002765, -0.001382,         0,  0.001382,  0.002765,  0.004751,  0.005268},    
    {  -8, -0.001798, -0.001622,-0.0009436,-0.0004718,         0, 0.0004718, 0.0009436,  0.001622,  0.001798},    
    {  -6,-0.0009541,-0.0008604,-0.0005007,-0.0002503,         0, 0.0002503, 0.0005007, 0.0008604, 0.0009541},    
    {  -4,-0.0001375, -0.000124,-7.213e-05,-3.607e-05,         0, 3.607e-05, 7.213e-05,  0.000124, 0.0001375},    
    {  -2, 0.0006716, 0.0006057, 0.0003525, 0.0001762,         0,-0.0001762,-0.0003525,-0.0006057,-0.0006716},    
    {   0,  0.001517,  0.001368,  0.000796,  0.000398,         0, -0.000398, -0.000796, -0.001368, -0.001517},    
    {   2,  0.002392,  0.002157,  0.001255, 0.0006277,         0,-0.0006277, -0.001255, -0.002157, -0.002392},    
    {   4,  0.003291,  0.002967,  0.001727, 0.0008634,         0,-0.0008634, -0.001727, -0.002967, -0.003291},    
    {   8,  0.005124,   0.00462,  0.002689,  0.001344,         0, -0.001344, -0.002689,  -0.00462, -0.005124},    
    {   9,  0.005532,  0.004989,  0.002903,  0.001452,         0, -0.001452, -0.002903, -0.004989, -0.005532},    
    {  10,  0.005882,  0.005305,  0.003087,  0.001543,         0, -0.001543, -0.003087, -0.005305, -0.005882},    
    {  12,   0.00648,  0.005844,  0.003401,    0.0017,         0,   -0.0017, -0.003401, -0.005844,  -0.00648},    
    {  14,  0.006915,  0.006236,  0.003629,  0.001814,         0, -0.001814, -0.003629, -0.006236, -0.006915},    
    {  16,  0.007144,  0.006442,  0.003749,  0.001874,         0, -0.001874, -0.003749, -0.006442, -0.007144},    
    {  18,  0.006717,  0.006057,  0.003525,  0.001763,         0, -0.001763, -0.003525, -0.006057, -0.006717},    
    {  19,  0.005176,  0.004668,  0.002716,  0.001358,         0, -0.001358, -0.002716, -0.004668, -0.005176},    
    {  20,  0.003466,  0.003126,  0.001819, 0.0009095,         0,-0.0009095, -0.001819, -0.003126, -0.003466},    
    {  21,  0.001999,  0.001803,  0.001049, 0.0005246,         0,-0.0005246, -0.001049, -0.001803, -0.001999},    
    {  22, 0.0009235, 0.0008328, 0.0004846, 0.0002423,         0,-0.0002423,-0.0004846,-0.0008328,-0.0009235},    
    {  24, -0.001253, -0.001129,-0.0006573,-0.0003286,         0, 0.0003286, 0.0006573,  0.001129,  0.001253}},
  // not provided by DATCOM
  dCn_Rudder  =   {      
    { -16,    0.0001}},
  dCn_Beta  =   {      
    { -16, 0.0008503}},
  dCn_RollRate  =   {      
    { -16,  0.001618},      
    {  -8, 0.0006283},      
    {  -6, 0.0003792},      
    {  -4,  0.000132},      
    {  -2,-0.0001151},      
    {   0,-0.0003664},      
    {   2,-0.0006206},      
    {   4,-0.0008793},      
    {   8, -0.001473},      
    {   9, -0.001661},      
    {  10, -0.001856},      
    {  12, -0.002213},      
    {  14, -0.002573},      
    {  16, -0.003125},      
    {  18, -0.004242},      
    {  19, -0.004199},      
    {  20, -0.003005},      
    {  21, -0.001853},      
    {  22, -0.001099},      
    {  24,-0.0001072}},
  dCn_YawRate  =   {      
    { -16, -0.001442},      
    {  -8, -0.001415},      
    {  -6, -0.001429},      
    {  -4,  -0.00145},      
    {  -2, -0.001478},      
    {   0, -0.001513},      
    {   2, -0.001555},      
    {   4, -0.001607},      
    {   8, -0.001737},      
    {   9, -0.001771},      
    {  10, -0.001801},      
    {  12, -0.001855},      
    {  14, -0.001893},      
    {  16, -0.001909},      
    {  18, -0.001856},      
    {  19, -0.001717},      
    {  20, -0.001602},      
    {  21, -0.001536},      
    {  22, -0.001504},      
    {  24, -0.001488}}
);

end Datcom;

// vim:ts=2:sw=2:expandtab
