/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout.springbox.implementations;

import java.util.Iterator;
import org.graphstream.ui.geom.Vector3;
import org.graphstream.ui.layout.springbox.EdgeSpring;
import org.graphstream.ui.layout.springbox.Energies;
import org.graphstream.ui.layout.springbox.GraphCellData;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;
import org.miv.pherd.ParticleBox;
import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Anchor;
import org.miv.pherd.ntree.Cell;

public class SpringBoxNodeParticle
extends NodeParticle {
    public SpringBoxNodeParticle(SpringBox box, String id) {
        this(box, id, box.randomXInsideBounds(), box.randomYInsideBounds(), box.is3D() ? box.randomZInsideBounds() : 0.0);
        this.box = box;
    }

    public SpringBoxNodeParticle(SpringBox box, String id, double x, double y, double z) {
        super(box, id, x, y, z);
    }

    @Override
    protected void repulsionN2(Vector3 delta) {
        SpringBox box = (SpringBox)this.box;
        boolean is3D = box.is3D();
        ParticleBox nodes = box.getSpatialIndex();
        Energies energies = box.getEnergies();
        Iterator i = nodes.getParticleIdIterator();
        while (i.hasNext()) {
            SpringBoxNodeParticle node = (SpringBoxNodeParticle)nodes.getParticle(i.next());
            if (node == this) continue;
            delta.set(node.pos.x - this.pos.x, node.pos.y - this.pos.y, is3D ? node.pos.z - this.pos.z : 0.0);
            double len = delta.normalize();
            if (!(len > 0.0)) continue;
            if (len < box.k) {
                len = box.k;
            }
            double factor = len != 0.0 ? box.K2 / (len * len) * node.weight : 1.0E-5;
            energies.accumulateEnergy(factor);
            delta.scalarMult(-factor);
            this.disp.add(delta);
        }
    }

    @Override
    protected void repulsionNLogN(Vector3 delta) {
        this.recurseRepulsion(this.box.getSpatialIndex().getNTree().getRootCell(), delta);
    }

    protected void recurseRepulsion(Cell cell, Vector3 delta) {
        SpringBox box = (SpringBox)this.box;
        boolean is3D = box.is3D();
        Energies energies = box.getEnergies();
        if (this.intersection(cell)) {
            if (cell.isLeaf()) {
                Iterator i = cell.getParticles();
                while (i.hasNext()) {
                    SpringBoxNodeParticle node = (SpringBoxNodeParticle)((Object)i.next());
                    if (node == this) continue;
                    delta.set(node.pos.x - this.pos.x, node.pos.y - this.pos.y, is3D ? node.pos.z - this.pos.z : 0.0);
                    double len = delta.normalize();
                    if (!(len > 0.0)) continue;
                    if (len < box.k) {
                        len = box.k;
                    }
                    double factor = len != 0.0 ? box.K2 / (len * len) * node.weight : 1.0E-5;
                    energies.accumulateEnergy(factor);
                    this.repE += factor;
                    delta.scalarMult(-factor);
                    this.disp.add(delta);
                }
            } else {
                int div = cell.getSpace().getDivisions();
                int i = 0;
                while (i < div) {
                    this.recurseRepulsion(cell.getSub(i), delta);
                    ++i;
                }
            }
        } else if (cell != this.cell) {
            GraphCellData bary = (GraphCellData)cell.getData();
            double dist = bary.distanceFrom(this.pos);
            double size = cell.getSpace().getSize();
            if (!cell.isLeaf() && size / dist > box.getBarnesHutTheta()) {
                int div = cell.getSpace().getDivisions();
                int i = 0;
                while (i < div) {
                    this.recurseRepulsion(cell.getSub(i), delta);
                    ++i;
                }
            } else if (bary.weight != 0.0) {
                delta.set(bary.center.x - this.pos.x, bary.center.y - this.pos.y, is3D ? bary.center.z - this.pos.z : 0.0);
                double len = delta.normalize();
                if (len > 0.0) {
                    if (len < box.k) {
                        len = box.k;
                    }
                    double factor = len != 0.0 ? box.K2 / (len * len) * bary.weight : (double)1.0E-5f;
                    energies.accumulateEnergy(factor);
                    delta.scalarMult(-factor);
                    this.repE += factor;
                    this.disp.add(delta);
                }
            }
        }
    }

    @Override
    protected void attraction(Vector3 delta) {
        SpringBox box = (SpringBox)this.box;
        boolean is3D = box.is3D();
        Energies energies = box.getEnergies();
        int neighbourCount = this.neighbours.size();
        for (EdgeSpring edge : this.neighbours) {
            if (edge.ignored) continue;
            NodeParticle other = edge.getOpposite(this);
            Point3 opos = other.getPosition();
            delta.set(opos.x - this.pos.x, opos.y - this.pos.y, is3D ? opos.z - this.pos.z : 0.0);
            double len = delta.normalize();
            double k = box.k * edge.weight;
            double factor = box.K1 * (len - k);
            delta.scalarMult(factor * (double)(1.0f / ((float)neighbourCount * 0.1f)));
            this.disp.add(delta);
            this.attE += factor;
            energies.accumulateEnergy(factor);
        }
    }

    @Override
    protected void gravity(Vector3 delta) {
        SpringBox box = (SpringBox)this.box;
        boolean is3D = box.is3D();
        delta.set(-this.pos.x, -this.pos.y, is3D ? -this.pos.z : 0.0);
        delta.normalize();
        delta.scalarMult(box.getGravityFactor());
        this.disp.add(delta);
    }

    protected boolean intersection(Cell cell) {
        SpringBox box = (SpringBox)this.box;
        double k = box.k;
        double vz = box.getViewZone();
        Anchor lo = cell.getSpace().getLoAnchor();
        Anchor hi = cell.getSpace().getHiAnchor();
        double x1 = lo.x;
        double x2 = hi.x;
        double X1 = this.pos.x - k * vz;
        double X2 = this.pos.x + k * vz;
        if (X2 < x1 || X1 > x2) {
            return false;
        }
        double y1 = lo.y;
        double y2 = hi.y;
        double Y1 = this.pos.y - k * vz;
        double Y2 = this.pos.y + k * vz;
        if (Y2 < y1 || Y1 > y2) {
            return false;
        }
        double z1 = lo.z;
        double z2 = hi.z;
        double Z1 = this.pos.z - k * vz;
        double Z2 = this.pos.z + k * vz;
        return !(Z2 < z1) && !(Z1 > z2);
    }
}

