// name:     RecursiveShort
// keywords: Recursive Short Class Definition
// status:   incorrect
// 
// Checks that compiler does not enter infinite lookup loop in the case
// of recursive short class definition (like type Env = Env.Env; here)
// 

model RecursiveShort
  class Env
    type Env = Real;
  end Env;

  class A
    type Env = Env.Env;
    Env e = 1.0;
  end A;
  
  A a;  
end RecursiveShort;

// Result:
// Error processing file: RecursiveShort.mo
// [RecursiveShort.mo:15:5-15:23:writable] Error: Class Env.Env not found in scope RecursiveShort.A.Env.
// [RecursiveShort.mo:15:5-15:23:writable] Error: Recursive short class definition of Env in terms of Env.Env
// [RecursiveShort.mo:15:5-15:23:writable] Error: Class Env.Env not found in scope RecursiveShort.A.Env.
// 
// # Error encountered! Exiting...
// # Please check the error message and the flags.
// 
// Execution failed!
// endResult
