﻿// $Id$
/**
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Open Source Modelica Consortium (OSMC),
 * c/o Linköpings universitet, Department of Computer and Information Science,
 * SE-58183 Linköping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF GPL VERSION 3 LICENSE OR 
 * THIS OSMC PUBLIC LICENSE (OSMC-PL). 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES RECIPIENT'S ACCEPTANCE
 * OF THE OSMC PUBLIC LICENSE OR THE GPL VERSION 3, ACCORDING TO RECIPIENTS CHOICE. 
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from OSMC, either from the above address,
 * from the URLs: http://www.ida.liu.se/projects/OpenModelica or  
 * http://www.openmodelica.org, and in the OpenModelica distribution. 
 * GNU version 3 is obtained from: http://www.gnu.org/copyleft/gpl.html.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 * Main contributor 2010, Hubert Thierot, CEP - ARMINES (France)

 	@file SimpleMilpTarget.h
 	@brief Comments for file documentation.
 	@author Hubert Thieriot, hubert.thieriot@mines-paristech.fr
 	Company : CEP - ARMINES (France)
 	http://www-cep.ensmp.fr/english/
 	@version 0.9 

  */
#ifndef SIMPLEMILPTARGET_H
#define SIMPLEMILPTARGET_H

#include <glpk.h>
#include <stdio.h>
#include <stdlib.h>
#include "EIItem.h"
#include "EIStream.h"
#include "EITools.h"
#include "GlpkTools.h"
#include "EITargetResult.h"
#include "InfoSender.h"



class SimpleMilpTarget
{
public:
	SimpleMilpTarget(EIItem* rootEI,EIReader *eiReader,MOOptVector *variables,QString modFilePath, QString dataFilePath);
	~SimpleMilpTarget(void);

	EITargetResult* launch();
	

private :
	glp_prob * launchGLPK(QString resFilePath);
	void DataToFile(QString dataFilePath, QList<METemperature> &Tk,
	QList<EIStream*> &eiProcessStreams,
	QList<QList<MEQflow> > &Qpk, //.at(iStream).at(iDTk)
	QList<EIStream*> &eiUtilityStreams,
	QList<QList<MEQflow> > &Quk,//.at(iStream).at(iDTk)
	QMultiMap<EIGroupFact*,EIStream*> &factStreamMap, // multimap <unit multiplier, Streams concerned>,
	QMap<EIGroupFact*,EIGroupFact*> &factsRelation, // map<child unit multiplier, parent unit multiplier> for constraint (e.g. fchild <= fparent * fchildmax)
	QMap<EIGroupFact*,EIGroup*> &factGroupMap);

	EITargetResult* readResult(glp_prob *);


	EIItem* rootEI;
	EIReader *eiReader;
	MOOptVector *variables;
	QString modFilePath;
	QString dataFilePath;

};


#endif
