encapsulated package SimCodeC
"
  file:        SimCodeC.mo
  package:     SimCodeC
  description: Generated by Susan.
  
  $Id: SimCodeC.mo 10577 2011-11-25 11:29:37Z sjoelund.se $
"

public import Tpl;

public import SimCode;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;

protected function fun_26
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;
  input String in_a_fileNamePrefix;
  input Tpl.Text in_a_guid;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simulationSettingsOpt, in_a_fileNamePrefix, in_a_guid, in_a_simCode)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      Tpl.Text a_guid;
      SimCode.SimCode a_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix,
           a_guid,
           a_simCode )
      equation
        txt_0 = simulationInitFile(Tpl.emptyTxt, a_simCode, Tpl.textString(a_guid));
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_init.xml"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end matchcontinue;
end fun_26;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<DAE.Exp> i_literals;
      list<SimCode.RecordDeclaration> i_recordDecls;
      list<SimCode.Function> i_modelInfo_functions;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text l_0__;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text l_guid;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, recordDecls = i_recordDecls, literals = i_literals, simulationSettingsOpt = i_simulationSettingsOpt)) )
      equation
        ret_1 = System.getUUIDStr();
        l_guid = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        txt_2 = simulationMakefile(Tpl.emptyTxt, i_simCode);
        txt_3 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt_4 = simulationFunctionsHeaderFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_recordDecls);
        txt_5 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING("_functions.h"));
        Tpl.textFile(txt_4, Tpl.textString(txt_5));
        txt_6 = simulationFunctionsFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_literals);
        txt_7 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_7 = Tpl.writeTok(txt_7, Tpl.ST_STRING("_functions.c"));
        Tpl.textFile(txt_6, Tpl.textString(txt_7));
        txt_8 = recordsFile(Tpl.emptyTxt, i_fileNamePrefix, i_recordDecls);
        txt_9 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_9 = Tpl.writeTok(txt_9, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_8, Tpl.textString(txt_9));
        l_0__ = fun_26(Tpl.emptyTxt, i_simulationSettingsOpt, i_fileNamePrefix, l_guid, i_simCode);
        txt_11 = simulationFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        txt_12 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_12 = Tpl.writeTok(txt_12, Tpl.ST_STRING(".c"));
        Tpl.textFile(txt_11, Tpl.textString(txt_12));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end translateModel;

protected function fun_28
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;
  input Tpl.Text in_a_filePrefix;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_mainFunction, in_a_filePrefix, in_a_functionCode)
    local
      Tpl.Text txt;
      Tpl.Text a_filePrefix;
      SimCode.FunctionCode a_functionCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_filePrefix,
           a_functionCode )
      equation
        txt_0 = functionsMakefile(Tpl.emptyTxt, a_functionCode);
        txt_1 = Tpl.writeText(Tpl.emptyTxt, a_filePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end matchcontinue;
end fun_28;

public function translateFunctions
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_functionCode)
    local
      Tpl.Text txt;
      SimCode.FunctionCode i_functionCode;
      list<DAE.Exp> i_literals;
      list<String> i_externalFunctionIncludes;
      list<SimCode.RecordDeclaration> i_extraRecordDecls;
      list<SimCode.Function> i_functions;
      Option<SimCode.Function> i_mainFunction;
      String i_name;
      Tpl.Text l_0__;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text l_filePrefix;

    case ( txt,
           (i_functionCode as SimCode.FUNCTIONCODE(name = i_name, mainFunction = i_mainFunction, functions = i_functions, extraRecordDecls = i_extraRecordDecls, externalFunctionIncludes = i_externalFunctionIncludes, literals = i_literals)) )
      equation
        l_filePrefix = Tpl.writeStr(Tpl.emptyTxt, i_name);
        txt_1 = functionsHeaderFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_mainFunction, i_functions, i_extraRecordDecls, i_externalFunctionIncludes);
        txt_2 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_1, Tpl.textString(txt_2));
        txt_3 = functionsFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_mainFunction, i_functions, i_literals);
        txt_4 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_4 = Tpl.writeTok(txt_4, Tpl.ST_STRING(".c"));
        Tpl.textFile(txt_3, Tpl.textString(txt_4));
        txt_5 = recordsFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_extraRecordDecls);
        txt_6 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_6 = Tpl.writeTok(txt_6, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_5, Tpl.textString(txt_6));
        l_0__ = fun_28(Tpl.emptyTxt, i_mainFunction, l_filePrefix, i_functionCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end translateFunctions;

protected function fun_30
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simulationSettingsOpt)
    local
      Tpl.Text txt;
      String i_settings_method;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(method = i_settings_method)) )
      equation
        txt = Tpl.writeStr(txt, i_settings_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_30;

public function simulationFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      list<DAE.Statement> i_algorithmAndEquationAsserts;
      list<DAE.ComponentRef> i_discreteModelVars;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<SimCode.HelpVarInfo> i_helpVarInfo;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_removedEquations;
      list<SimCode.SimEqSystem> i_algebraicEquations;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_residualEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      SimCode.DelayedExpression i_delayedExps;
      list<SimCode.SimEqSystem> i_sampleEquations;
      list<SimCode.SampleCondition> i_sampleConditions;
      SimCode.ExtObjInfo i_extObjInfo;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.ModelInfo i_modelInfo;
      String i_fileNamePrefix;
      list<String> i_externalFunctionIncludes;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_2;
      list<SimCode.SimEqSystem> ret_1;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(externalFunctionIncludes = i_externalFunctionIncludes, fileNamePrefix = i_fileNamePrefix, modelInfo = i_modelInfo, allEquations = i_allEquations, jacobianMatrixes = i_jacobianMatrixes, extObjInfo = i_extObjInfo, sampleConditions = i_sampleConditions, sampleEquations = i_sampleEquations, delayedExps = i_delayedExps, initialEquations = i_initialEquations, residualEquations = i_residualEquations, parameterEquations = i_parameterEquations, odeEquations = i_odeEquations, simulationSettingsOpt = i_simulationSettingsOpt, algebraicEquations = i_algebraicEquations, removedEquations = i_removedEquations, whenClauses = i_whenClauses, helpVarInfo = i_helpVarInfo, zeroCrossings = i_zeroCrossings, discreteModelVars = i_discreteModelVars, algorithmAndEquationAsserts = i_algorithmAndEquationAsserts)),
           a_guid )
      equation
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = externalFunctionIncludes(txt, i_externalFunctionIncludes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.c\"\n",
                                    "#define _OMC_SEED_HACK\n",
                                    "#define _OMC_SEED_HACK_2\n",
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "int measure_time_flag = 1;\n",
                                    "#else\n",
                                    "int measure_time_flag = 0;\n",
                                    "#endif\n"
                                }, true));
        txt = globalData(txt, i_modelInfo, i_fileNamePrefix, a_guid);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_0 = SimCode.appendAllequations(i_jacobianMatrixes);
        ret_1 = SimCode.appendLists(i_allEquations, ret_0);
        txt = equationInfo(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionSetLocalData(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitializeDataStruc(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCallExternalObjectConstructors(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionDeInitializeDataStruc(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionExtraResiduals(txt, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOutput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitSample(txt, i_sampleConditions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionSampleEquations(txt, i_sampleEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionStoreDelayed(txt, i_delayedExps);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitial(txt, i_initialEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitialResidual(txt, i_residualEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionBoundParameters(txt, i_parameterEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_2 = fun_30(Tpl.emptyTxt, i_simulationSettingsOpt);
        (txt, txt_2) = functionODE(txt, i_odeEquations, txt_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAlgebraic(txt, i_algebraicEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAliasEquation(txt, i_removedEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionDAE(txt, i_allEquations, i_whenClauses, i_helpVarInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOnlyZeroCrossing(txt, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCheckForDiscreteChanges(txt, i_discreteModelVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAssertsforCheck(txt, i_algorithmAndEquationAsserts);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = generateLinearMatrixes(txt, i_jacobianMatrixes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionlinearmodel(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif\n",
                                    "\n",
                                    "/* forward the main in the simulation runtime */\n",
                                    "extern int _main_SimulationRuntime(int argc, char**argv);\n",
                                    "\n",
                                    "/* call the simulation runtime main from our main! */\n",
                                    "int main(int argc, char**argv)\n",
                                    "{\n",
                                    "  return _main_SimulationRuntime(argc, argv);\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end simulationFile;

public function simulationFileHeader
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(vars = _), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Simulation code for "));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".\n",
                                    "\n",
                                    "#include \"modelica.h\"\n",
                                    "#include \"assert.h\"\n",
                                    "#include \"string.h\"\n",
                                    "#include \"simulation_runtime.h\"\n",
                                    "\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\"\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationFileHeader;

protected function lm_33
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "states");
        txt = Tpl.nextIter(txt);
        txt = lm_33(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_33(txt, rest);
      then txt;
  end matchcontinue;
end lm_33;

protected function lm_34
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "statesDerivatives");
        txt = Tpl.nextIter(txt);
        txt = lm_34(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_34(txt, rest);
      then txt;
  end matchcontinue;
end lm_34;

protected function lm_35
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_35(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_35(txt, rest);
      then txt;
  end matchcontinue;
end lm_35;

protected function lm_36
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_36(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_36(txt, rest);
      then txt;
  end matchcontinue;
end lm_36;

protected function lm_37
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "extObjs");
        txt = Tpl.nextIter(txt);
        txt = lm_37(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_37(txt, rest);
      then txt;
  end matchcontinue;
end lm_37;

protected function lm_38
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "intVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_38(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_38(txt, rest);
      then txt;
  end matchcontinue;
end lm_38;

protected function lm_39
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "intVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_39(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_39(txt, rest);
      then txt;
  end matchcontinue;
end lm_39;

protected function lm_40
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "boolVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_40(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_40(txt, rest);
      then txt;
  end matchcontinue;
end lm_40;

protected function lm_41
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "boolVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_41(txt, rest);
      then txt;
  end matchcontinue;
end lm_41;

protected function lm_42
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "stringVariables.algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_42(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_42(txt, rest);
      then txt;
  end matchcontinue;
end lm_42;

protected function lm_43
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "stringVariables.parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_43(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_43(txt, rest);
      then txt;
  end matchcontinue;
end lm_43;

protected function lm_44
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "jacobianVars");
        txt = Tpl.nextIter(txt);
        txt = lm_44(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_44(txt, rest);
      then txt;
  end matchcontinue;
end lm_44;

protected function lm_45
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Integer x_i0;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = functionName(txt, i_fn, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_index "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_45(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_45(txt, rest);
      then txt;
  end matchcontinue;
end lm_45;

protected function lm_46
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_46(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_46(txt, rest);
      then txt;
  end matchcontinue;
end lm_46;

protected function lm_47
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_47(txt, rest);
      then txt;
  end matchcontinue;
end lm_47;

protected function lm_48
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_48(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_48(txt, rest);
      then txt;
  end matchcontinue;
end lm_48;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_49(txt, rest);
      then txt;
  end matchcontinue;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_50(txt, rest);
      then txt;
  end matchcontinue;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_51(txt, rest);
      then txt;
  end matchcontinue;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_52(txt, rest);
      then txt;
  end matchcontinue;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isFixed;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      equation
        txt = globalDataFixedInt(txt, i_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_53(txt, rest);
      then txt;
  end matchcontinue;
end lm_53;

protected function smf_54
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_54;

protected function smf_55
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_55;

protected function smf_56
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_56;

protected function smf_57
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_57;

protected function smf_58
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_58;

protected function smf_59
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_59;

protected function smf_60
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_60;

protected function smf_61
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_61;

protected function lm_62
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataHasNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_62(txt, rest);
      then txt;
  end matchcontinue;
end lm_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataHasNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_63(txt, rest);
      then txt;
  end matchcontinue;
end lm_63;

protected function lm_64
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataHasNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_64(txt, rest);
      then txt;
  end matchcontinue;
end lm_64;

protected function smf_65
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_65;

protected function smf_66
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_66;

protected function smf_67
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_67;

protected function lm_68
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_68(txt, rest);
      then txt;
  end matchcontinue;
end lm_68;

protected function lm_69
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_69(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_69(txt, rest);
      then txt;
  end matchcontinue;
end lm_69;

protected function lm_70
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue, name = i_name) :: rest )
      equation
        txt = globalDataNominalValue(txt, i_nominalValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_70(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_70(txt, rest);
      then txt;
  end matchcontinue;
end lm_70;

protected function smf_71
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_71;

protected function smf_72
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_72;

protected function smf_73
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_73;

protected function lm_74
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.ExpType i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_74(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_74(txt, rest);
      then txt;
  end matchcontinue;
end lm_74;

protected function lm_75
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.ExpType i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_75(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_75(txt, rest);
      then txt;
  end matchcontinue;
end lm_75;

protected function lm_76
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.ExpType i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_76(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_76(txt, rest);
      then txt;
  end matchcontinue;
end lm_76;

protected function lm_77
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.ExpType i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_77(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_77(txt, rest);
      then txt;
  end matchcontinue;
end lm_77;

protected function lm_78
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.ExpType i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_78(txt, rest);
      then txt;
  end matchcontinue;
end lm_78;

protected function lm_79
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.ExpType i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_79(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_79(txt, rest);
      then txt;
  end matchcontinue;
end lm_79;

protected function lm_80
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.ExpType i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_80(txt, rest);
      then txt;
  end matchcontinue;
end lm_80;

protected function lm_81
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.ExpType i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_81(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_81(txt, rest);
      then txt;
  end matchcontinue;
end lm_81;

protected function lm_82
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean i_isDiscrete;
      DAE.ExpType i_type__;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__, isDiscrete = i_isDiscrete, name = i_name) :: rest )
      equation
        txt = globalDataAttrInt(txt, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = globalDataDiscAttrInt(txt, i_isDiscrete);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_82(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_82(txt, rest);
      then txt;
  end matchcontinue;
end lm_82;

protected function smf_83
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_83;

protected function smf_84
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_84;

protected function smf_85
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_85;

protected function smf_86
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_86;

protected function smf_87
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_87;

protected function smf_88
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_88;

protected function smf_89
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_89;

protected function smf_90
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_90;

protected function smf_91
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_91;

protected function fun_92
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_fileNamePrefix;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo, in_a_fileNamePrefix, in_a_guid)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      String a_guid;
      list<SimCode.SimVar> i_vars_extObjVars;
      list<SimCode.SimVar> i_vars_jacobianVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      String i_directory;
      Absyn.Path i_name;
      Integer i_varInfo_numJacobianVars;
      Integer i_varInfo_numBoolParams;
      Integer i_varInfo_numBoolAliasVars;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numIntParams;
      Integer i_varInfo_numIntAliasVars;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numStringParamVars;
      Integer i_varInfo_numStringAliasVars;
      Integer i_varInfo_numStringAlgVars;
      list<SimCode.Function> i_functions;
      Integer i_varInfo_numExternalObjects;
      Integer i_varInfo_numResiduals;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numParams;
      Integer i_varInfo_numAlgAliasVars;
      Integer i_varInfo_numAlgVars;
      Integer i_varInfo_numStateVars;
      Integer i_varInfo_numTimeEvents;
      Integer i_varInfo_numZeroCrossings;
      Integer i_varInfo_numHelpVars;
      Tpl.Text txt_23;
      Tpl.Text txt_22;
      Tpl.Text txt_21;
      Tpl.Text txt_20;
      Tpl.Text txt_19;
      Tpl.Text txt_18;
      Tpl.Text txt_17;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Integer ret_0;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numHelpVars = i_varInfo_numHelpVars, numZeroCrossings = i_varInfo_numZeroCrossings, numTimeEvents = i_varInfo_numTimeEvents, numStateVars = i_varInfo_numStateVars, numAlgVars = i_varInfo_numAlgVars, numAlgAliasVars = i_varInfo_numAlgAliasVars, numParams = i_varInfo_numParams, numOutVars = i_varInfo_numOutVars, numInVars = i_varInfo_numInVars, numResiduals = i_varInfo_numResiduals, numExternalObjects = i_varInfo_numExternalObjects, numStringAlgVars = i_varInfo_numStringAlgVars, numStringAliasVars = i_varInfo_numStringAliasVars, numStringParamVars = i_varInfo_numStringParamVars, numIntAlgVars = i_varInfo_numIntAlgVars, numIntAliasVars = i_varInfo_numIntAliasVars, numIntParams = i_varInfo_numIntParams, numBoolAlgVars = i_varInfo_numBoolAlgVars, numBoolAliasVars = i_varInfo_numBoolAliasVars, numBoolParams = i_varInfo_numBoolParams, numJacobianVars = i_varInfo_numJacobianVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, jacobianVars = i_vars_jacobianVars, extObjVars = i_vars_extObjVars), functions = i_functions, name = i_name, directory = i_directory),
           a_fileNamePrefix,
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define MODEL_GUID  \"{"));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\" // to check if the init file match the model!\n",
                                    "#define NHELP "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numHelpVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of helper vars\n",
                                    "#define NG "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of zero crossings\n",
                                    "#define NG_SAM "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of zero crossings that are samples\n",
                                    "#define NX "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  // number of states\n",
                                    "#define NY "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  // number of real variables\n",
                                    "#define NA "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  // number of alias variables\n",
                                    "#define NP "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of parameters\n",
                                    "#define NO "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of outputvar on topmodel\n",
                                    "#define NI "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of inputvar on topmodel\n",
                                    "#define NR "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of residuals for initialialization function\n",
                                    "#define NEXT "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of external objects\n",
                                    "#define NFUNC "
                                }, false));
        ret_0 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of functions used by the simulation\n",
                                    "#define MAXORD 5\n",
                                    "#define NYSTR "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alg. string variables\n",
                                    "#define NASTR "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alias string variables\n",
                                    "#define NPSTR "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of string parameters\n",
                                    "#define NYINT "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alg. int variables\n",
                                    "#define NAINT "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alias int variables\n",
                                    "#define NPINT "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of int parameters\n",
                                    "#define NYBOOL "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alg. bool variables\n",
                                    "#define NABOOL "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of alias bool variables\n",
                                    "#define NPBOOL "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of bool parameters\n",
                                    "#define NJACVARS "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numJacobianVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // number of jacobian variables\n",
                                    "\n",
                                    "static DATA* localData = 0;\n",
                                    "#define time localData->timeValue\n",
                                    "#define $P$old$Ptime localData->oldTime\n",
                                    "#define $P$current_step_size globalData->current_stepsize\n",
                                    "\n",
                                    "#ifndef _OMC_QSS\n",
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" { // adrpo: this is needed for Visual C++ compilation to work!\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *model_name=\""));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "const char *model_fileprefix=\""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "const char *model_dir=\""
                                }, false));
        txt = Tpl.writeStr(txt, i_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt = globalDataVarInfoArray(txt, "state_names", i_vars_stateVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "derivative_names", i_vars_derivativeVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "algvars_names", i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "param_names", i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "alias_names", i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "int_alg_names", i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "int_param_names", i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "int_alias_names", i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "bool_alg_names", i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "bool_param_names", i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "bool_alias_names", i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "string_alg_names", i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "string_param_names", i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "string_alias_names", i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataVarInfoArray(txt, "jacobian_names", i_vars_jacobianVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataFunctionInfoArray(txt, "function_names", i_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_33(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_34(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_35(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_36(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_37(txt, i_vars_extObjVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_38(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_39(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_40(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_41(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_42(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_43(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_44(txt, i_vars_jacobianVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_45(txt, i_functions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void init_Alias(DATA* data)\n",
                                    "{\n"
                                }, true));
        txt = globalDataAliasVarArray(txt, "DATA_REAL_ALIAS", "omc__realAlias", i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataAliasVarArray(txt, "DATA_INT_ALIAS", "omc__intAlias", i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataAliasVarArray(txt, "DATA_BOOL_ALIAS", "omc__boolAlias", i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = globalDataAliasVarArray(txt, "DATA_STRING_ALIAS", "omc__stringAlias", i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if (data->nAlias)\n",
                                    "  memcpy(data->realAlias,omc__realAlias,sizeof(DATA_REAL_ALIAS)*data->nAlias);\n",
                                    "if (data->intVariables.nAlias)\n",
                                    "  memcpy(data->intVariables.alias,omc__intAlias,sizeof(DATA_INT_ALIAS)*data->intVariables.nAlias);\n",
                                    "if (data->boolVariables.nAlias)\n",
                                    "  memcpy(data->boolVariables.alias,omc__boolAlias,sizeof(DATA_BOOL_ALIAS)*data->boolVariables.nAlias);\n",
                                    "if (data->stringVariables.nAlias)\n",
                                    "  memcpy(data->stringVariables.alias,omc__stringAlias,sizeof(DATA_STRING_ALIAS)*data->stringVariables.nAlias);\n",
                                    "};\n",
                                    "\n",
                                    "static char init_fixed[NX+NX+NY+NYINT+NYBOOL+NP+NPINT+NPBOOL] = {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_1 = lm_46(txt_1, i_vars_stateVars);
        txt_1 = Tpl.popIter(txt_1);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_47(txt_2, i_vars_derivativeVars);
        txt_2 = Tpl.popIter(txt_2);
        txt_3 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_3 = lm_48(txt_3, i_vars_algVars);
        txt_3 = Tpl.popIter(txt_3);
        txt_4 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_4 = lm_49(txt_4, i_vars_intAlgVars);
        txt_4 = Tpl.popIter(txt_4);
        txt_5 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_5 = lm_50(txt_5, i_vars_boolAlgVars);
        txt_5 = Tpl.popIter(txt_5);
        txt_6 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_6 = lm_51(txt_6, i_vars_paramVars);
        txt_6 = Tpl.popIter(txt_6);
        txt_7 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_7 = lm_52(txt_7, i_vars_intParamVars);
        txt_7 = Tpl.popIter(txt_7);
        txt_8 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_8 = lm_53(txt_8, i_vars_boolParamVars);
        txt_8 = Tpl.popIter(txt_8);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_54(txt, txt_1);
        txt = smf_55(txt, txt_2);
        txt = smf_56(txt, txt_3);
        txt = smf_57(txt, txt_4);
        txt = smf_58(txt, txt_5);
        txt = smf_59(txt, txt_6);
        txt = smf_60(txt, txt_7);
        txt = smf_61(txt, txt_8);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "char hasNominalValue[NX+NY+NP] = {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_9 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_9 = lm_62(txt_9, i_vars_stateVars);
        txt_9 = Tpl.popIter(txt_9);
        txt_10 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_10 = lm_63(txt_10, i_vars_algVars);
        txt_10 = Tpl.popIter(txt_10);
        txt_11 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_11 = lm_64(txt_11, i_vars_paramVars);
        txt_11 = Tpl.popIter(txt_11);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_65(txt, txt_9);
        txt = smf_66(txt, txt_10);
        txt = smf_67(txt, txt_11);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "double nominalValue[NX+NY+NP] = {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_12 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_12 = lm_68(txt_12, i_vars_stateVars);
        txt_12 = Tpl.popIter(txt_12);
        txt_13 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_13 = lm_69(txt_13, i_vars_algVars);
        txt_13 = Tpl.popIter(txt_13);
        txt_14 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_14 = lm_70(txt_14, i_vars_paramVars);
        txt_14 = Tpl.popIter(txt_14);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_71(txt, txt_12);
        txt = smf_72(txt, txt_13);
        txt = smf_73(txt, txt_14);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "char var_attr[NX+NY+NYINT+NYBOOL+NYSTR+NP+NPINT+NPBOOL+NPSTR] = {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_15 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_15 = lm_74(txt_15, i_vars_stateVars);
        txt_15 = Tpl.popIter(txt_15);
        txt_16 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_16 = lm_75(txt_16, i_vars_algVars);
        txt_16 = Tpl.popIter(txt_16);
        txt_17 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_17 = lm_76(txt_17, i_vars_intAlgVars);
        txt_17 = Tpl.popIter(txt_17);
        txt_18 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_18 = lm_77(txt_18, i_vars_boolAlgVars);
        txt_18 = Tpl.popIter(txt_18);
        txt_19 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_19 = lm_78(txt_19, i_vars_stringAlgVars);
        txt_19 = Tpl.popIter(txt_19);
        txt_20 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_20 = lm_79(txt_20, i_vars_paramVars);
        txt_20 = Tpl.popIter(txt_20);
        txt_21 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_21 = lm_80(txt_21, i_vars_intParamVars);
        txt_21 = Tpl.popIter(txt_21);
        txt_22 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_22 = lm_81(txt_22, i_vars_boolParamVars);
        txt_22 = Tpl.popIter(txt_22);
        txt_23 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_23 = lm_82(txt_23, i_vars_stringParamVars);
        txt_23 = Tpl.popIter(txt_23);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_83(txt, txt_15);
        txt = smf_84(txt, txt_16);
        txt = smf_85(txt, txt_17);
        txt = smf_86(txt, txt_18);
        txt = smf_87(txt, txt_19);
        txt = smf_88(txt, txt_20);
        txt = smf_89(txt, txt_21);
        txt = smf_90(txt, txt_22);
        txt = smf_91(txt, txt_23);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_92;

public function globalData
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input String a_fileNamePrefix;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1000);
  out_txt := fun_92(txt, a_modelInfo, a_fileNamePrefix, a_guid);
end globalData;

protected function lm_94
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Absyn.Info i_info;
      String i_var_comment;
      DAE.ComponentRef i_var_name;
      String ret_3;
      String ret_2;
      Tpl.Text txt_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(source = DAE.SOURCE(info = (i_info as Absyn.INFO(fileName = _))), name = i_var_name, comment = i_var_comment) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt_1 = crefStr(Tpl.emptyTxt, i_var_name);
        ret_2 = System.escapedString(Tpl.textString(txt_1));
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",\""));
        ret_3 = Util.escapeModelicaStringToCString(i_var_comment);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",{"));
        txt = infoArgs(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
        txt = Tpl.nextIter(txt);
        txt = lm_94(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_94(txt, rest);
      then txt;
  end matchcontinue;
end lm_94;

protected function lm_95
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_0__name)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_0__name;
      Integer x_i0;
      DAE.ComponentRef i_var_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(source = DAE.SOURCE(info = Absyn.INFO(fileName = _)), name = i_var_name) :: rest,
           a_0__name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
        txt = Tpl.nextIter(txt);
        txt = lm_95(txt, rest, a_0__name);
      then txt;

    case ( txt,
           _ :: rest,
           a_0__name )
      equation
        txt = lm_95(txt, rest, a_0__name);
      then txt;
  end matchcontinue;
end lm_95;

protected function fun_96
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_items;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_items, in_a_0__name)
    local
      Tpl.Text txt;
      String a_0__name;
      list<SimCode.SimVar> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_0__name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct omc_varInfo "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{-1,\"\",\"\",omc_dummyFileInfo}};"));
      then txt;

    case ( txt,
           i_items,
           a_0__name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct omc_varInfo "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_94(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_95(txt, i_items, a_0__name);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_96;

public function globalDataVarInfoArray
  input Tpl.Text txt;
  input String a_0__name;
  input list<SimCode.SimVar> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_96(txt, a_items, a_0__name);
end globalDataVarInfoArray;

protected function lm_98
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;
      Absyn.Info ret_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = functionName(txt, i_fn, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",{"));
        ret_1 = SimCode.functionInfo(i_fn);
        txt = infoArgs(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
        txt = Tpl.nextIter(txt);
        txt = lm_98(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_98(txt, rest);
      then txt;
  end matchcontinue;
end lm_98;

protected function fun_99
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_a_items;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_items, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      list<SimCode.Function> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct omc_functionInfo "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{-1,\"\",omc_dummyFileInfo}};"));
      then txt;

    case ( txt,
           i_items,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct omc_functionInfo "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_98(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end matchcontinue;
end fun_99;

public function globalDataFunctionInfoArray
  input Tpl.Text txt;
  input String a_name;
  input list<SimCode.Function> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_99(txt, a_items, a_name);
end globalDataFunctionInfoArray;

protected function fun_101
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_101;

protected function fun_102
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      DAE.ComponentRef i_name;
      Integer i_index;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(i_c), aliasvar = SimCode.NOALIAS(), index = i_index, name = i_name),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_saved["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$old"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_old["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$old2"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_old2["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_saved["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$old"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_old["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$old2"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_old2["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" localData->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_saved["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_102;

protected function fun_103
  input Tpl.Text in_txt;
  input String in_a_arrayName;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_arrayName, in_a_simVar)
    local
      Tpl.Text txt;
      SimCode.SimVar a_simVar;
      String i_arrayName;

    case ( txt,
           (i_arrayName as "jacobianVars"),
           a_simVar )
      equation
        txt = fun_101(txt, a_simVar, i_arrayName);
      then txt;

    case ( txt,
           i_arrayName,
           a_simVar )
      equation
        txt = fun_102(txt, a_simVar, i_arrayName);
      then txt;
  end matchcontinue;
end fun_103;

public function globalDataVarDefine
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_103(txt, a_arrayName, a_simVar);
end globalDataVarDefine;

protected function lm_105
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer i_index;
      SimCode.AliasVariable i_aliasvar;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = i_aliasvar, index = i_index) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = aliasVarNameType(txt, i_aliasvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_105(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_105(txt, rest);
      then txt;
  end matchcontinue;
end lm_105;

protected function fun_106
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_items;
  input String in_a_0__type;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_items, in_a_0__type, in_a_0__name)
    local
      Tpl.Text txt;
      String a_0__type;
      String a_0__name;
      list<SimCode.SimVar> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{0,0,-1}};"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_items,
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_105(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_106;

public function globalDataAliasVarArray
  input Tpl.Text txt;
  input String a_0__type;
  input String a_0__name;
  input list<SimCode.SimVar> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_106(txt, a_items, a_0__type, a_0__name);
end globalDataAliasVarArray;

public function aliasVarNameType
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_varName;

    case ( txt,
           SimCode.NOALIAS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0,0"));
      then txt;

    case ( txt,
           SimCode.ALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = cref(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",0"));
      then txt;

    case ( txt,
           SimCode.NEGATEDALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = cref(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",1"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end aliasVarNameType;

public function globalDataFixedInt
  input Tpl.Text in_txt;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isFixed)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataFixedInt;

public function globalDataNominalValue
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominal;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_nominal)
    local
      Tpl.Text txt;
      DAE.Exp i_v;

    case ( txt,
           NONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0 /* default */"));
      then txt;

    case ( txt,
           SOME(i_v) )
      equation
        txt = initVal(txt, i_v);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataNominalValue;

public function globalDataHasNominalValue
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominal;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_nominal)
    local
      Tpl.Text txt;

    case ( txt,
           NONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           SOME(_) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataHasNominalValue;

public function globalDataAttrInt
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_REAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           DAE.ET_STRING() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("2"));
      then txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("4"));
      then txt;

    case ( txt,
           DAE.ET_ENUMERATION(path = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("4"));
      then txt;

    case ( txt,
           DAE.ET_BOOL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("8"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataAttrInt;

public function globalDataDiscAttrInt
  input Tpl.Text in_txt;
  input Boolean in_a_isDiscrete;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isDiscrete)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("16"));
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end globalDataDiscAttrInt;

public function functionSetLocalData
  input Tpl.Text txt;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "void setLocalData(DATA* data)\n",
                                   "{\n",
                                   "  localData = data;\n",
                                   "  init_Alias(data);\n",
                                   "}"
                               }, false));
end functionSetLocalData;

public function functionInitializeDataStruc
  input Tpl.Text txt;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "DATA* initializeDataStruc()\n",
                                   "{\n",
                                   "  DATA* returnData = (DATA*)malloc(sizeof(DATA));\n",
                                   "\n",
                                   "  if(!returnData) //error check\n",
                                   "    return 0;\n",
                                   "\n",
                                   "  memset(returnData,0,sizeof(DATA));\n",
                                   "  returnData->nStates = NX;\n",
                                   "  returnData->nAlgebraic = NY;\n",
                                   "  returnData->nAlias = NA;\n",
                                   "  returnData->nParameters = NP;\n",
                                   "  returnData->nInputVars = NI;\n",
                                   "  returnData->nOutputVars = NO;\n",
                                   "  returnData->nFunctions = NFUNC;\n",
                                   "  returnData->nEquations = nEquation;\n",
                                   "  returnData->nProfileBlocks = n_omc_equationInfo_reverse_prof_index;\n",
                                   "  returnData->nZeroCrossing = NG;\n",
                                   "  returnData->nRawSamples = NG_SAM;\n",
                                   "  returnData->nInitialResiduals = NR;\n",
                                   "  returnData->nHelpVars = NHELP;\n",
                                   "  returnData->stringVariables.nParameters = NPSTR;\n",
                                   "  returnData->stringVariables.nAlgebraic = NYSTR;\n",
                                   "  returnData->stringVariables.nAlias = NASTR;\n",
                                   "  returnData->intVariables.nParameters = NPINT;\n",
                                   "  returnData->intVariables.nAlgebraic = NYINT;\n",
                                   "  returnData->intVariables.nAlias = NAINT;\n",
                                   "  returnData->boolVariables.nParameters = NPBOOL;\n",
                                   "  returnData->boolVariables.nAlgebraic = NYBOOL;\n",
                                   "  returnData->boolVariables.nAlias = NABOOL;\n",
                                   "  returnData->nJacobianvars = NJACVARS;\n",
                                   "\n",
                                   "  returnData->initFixed = init_fixed;\n",
                                   "  returnData->var_attr = var_attr;\n",
                                   "  returnData->modelName = model_name;\n",
                                   "  returnData->modelFilePrefix = model_fileprefix;\n",
                                   "  returnData->modelGUID = MODEL_GUID;\n",
                                   "  returnData->statesNames = state_names;\n",
                                   "  returnData->stateDerivativesNames = derivative_names;\n",
                                   "  returnData->algebraicsNames = algvars_names;\n",
                                   "  returnData->int_alg_names = int_alg_names;\n",
                                   "  returnData->bool_alg_names = bool_alg_names;\n",
                                   "  returnData->string_alg_names = string_alg_names;\n",
                                   "  returnData->parametersNames = param_names;\n",
                                   "  returnData->int_param_names = int_param_names;\n",
                                   "  returnData->bool_param_names = bool_param_names;\n",
                                   "  returnData->string_param_names = string_param_names;\n",
                                   "  returnData->alias_names = alias_names;\n",
                                   "  returnData->int_alias_names = int_alias_names;\n",
                                   "  returnData->bool_alias_names = bool_alias_names;\n",
                                   "  returnData->string_alias_names = string_alias_names;\n",
                                   "  returnData->jacobian_names = jacobian_names;\n",
                                   "  returnData->functionNames = function_names;\n",
                                   "  returnData->equationInfo = equation_info;\n",
                                   "  returnData->equationInfo_reverse_prof_index = omc_equationInfo_reverse_prof_index;\n",
                                   "\n",
                                   "  if (NEXT) {\n",
                                   "    returnData->extObjs = (void**)malloc(sizeof(void*)*NEXT);\n",
                                   "    if (!returnData->extObjs) {\n",
                                   "      printf(\"error allocating external objects\\n\");\n",
                                   "      exit(-2);\n",
                                   "    }\n",
                                   "    memset(returnData->extObjs,0,sizeof(void*)*NEXT);\n",
                                   "  } else {\n",
                                   "    returnData->extObjs = 0;\n",
                                   "  }\n",
                                   "\n",
                                   "  return returnData;\n",
                                   "}\n",
                                   "\n"
                               }, true));
end functionInitializeDataStruc;

protected function lm_116
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_arg;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMVAR(initialValue = SOME(i_exp), name = i_var_name) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arg, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_arg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "restore_memory_state(mem_state);"
                                }, false));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_116(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_116(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_116;

protected function lm_117
  input Tpl.Text in_txt;
  input list<SimCode.ExtAlias> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> rest;
      DAE.ComponentRef i_var2;
      DAE.ComponentRef i_var1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var1, i_var2) :: rest )
      equation
        txt = cref(txt, i_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = cref(txt, i_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_117(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_117(txt, rest);
      then txt;
  end matchcontinue;
end lm_117;

public function functionCallExternalObjectConstructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extObjInfo)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> i_aliases;
      list<SimCode.SimVar> i_vars;
      Tpl.Text l_ctorCalls;
      Tpl.Text l_varDecls;
      Tpl.Text l_funDecls;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_vars, aliases = i_aliases) )
      equation
        l_funDecls = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_ctorCalls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_ctorCalls, l_varDecls) = lm_116(l_ctorCalls, i_vars, l_varDecls);
        l_ctorCalls = Tpl.popIter(l_ctorCalls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* Has to be performed after _init.xml file has been read */\n",
                                    "void callExternalObjectConstructors(DATA* localData) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "state mem_state;\n",
                                    "mem_state = get_memory_state();\n"
                                }, true));
        txt = Tpl.writeText(txt, l_ctorCalls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_117(txt, i_aliases);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionCallExternalObjectConstructors;

protected function lm_119
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_var_name;
      Absyn.Path i_ext_fullClassName;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(varKind = BackendDAE.EXTOBJ(fullClassName = i_ext_fullClassName), name = i_var_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_ext_fullClassName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_destructor("));
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_119(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_119(txt, rest);
      then txt;
  end matchcontinue;
end lm_119;

public function functionDeInitializeDataStruc
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extObjInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_extObjInfo_vars;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_extObjInfo_vars) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void deInitializeDataStruc(DATA* data)\n",
                                    "{\n",
                                    "  if (data->extObjs) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_119(txt, i_extObjInfo_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "free(data->extObjs);\n",
                                    "data->extObjs = 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionDeInitializeDataStruc;

protected function lm_121
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = localData->inputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_121(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_121(txt, rest);
      then txt;
  end matchcontinue;
end lm_121;

public function functionInput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_inputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(inputVars = i_vars_inputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int input_function()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_121(txt, i_vars_inputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionInput;

protected function lm_123
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->outputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_123(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_123(txt, rest);
      then txt;
  end matchcontinue;
end lm_123;

public function functionOutput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(outputVars = i_vars_outputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int output_function()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_123(txt, i_vars_outputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionOutput;

protected function fun_125
  input Tpl.Text in_txt;
  input Tpl.Text in_a_timeEventCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_timeEventCode)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int i = 0; // Current index"));
      then txt;
  end matchcontinue;
end fun_125;

public function functionInitSample
  input Tpl.Text txt;
  input list<SimCode.SampleCondition> a_sampleConditions;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_timeEventCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_timeEventCode, l_varDecls) := timeEventsTpl(Tpl.emptyTxt, a_sampleConditions, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* Initializes the raw time events of the simulation using the now\n",
                                   "   calcualted parameters. */\n",
                                   "void function_sampleInit()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := fun_125(out_txt, l_timeEventCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_timeEventCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitSample;

protected function lm_127
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_127(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_127(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_127;

public function functionSampleEquations
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_sampleEqns;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqs;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_tmp, l_varDecls) := lm_127(l_eqs, a_sampleEqns, l_tmp, l_varDecls);
  l_eqs := Tpl.popIter(l_eqs);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int function_updateSample()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionSampleEquations;

protected function lm_129
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_129(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_129(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_129;

protected function lm_130
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (sim_verbose >= LOG_INIT) { printf(\"Setting variable start value: %s(start=%f)\\n\", \""));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", ("));
        txt = crefType(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); }"));
        txt = Tpl.nextIter(txt);
        txt = lm_130(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_130(txt, rest);
      then txt;
  end matchcontinue;
end lm_130;

public function functionInitial
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqPart, l_tmp, l_varDecls) := lm_129(l_eqPart, a_initialEquations, l_tmp, l_varDecls);
  l_eqPart := Tpl.popIter(l_eqPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int initial_function()\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_eqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_130(out_txt, a_initialEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitial;

protected function fun_132
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      String ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.SCONST(string = _),
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->initialResiduals[i++] = 0;"));
      then (txt, a_varDecls);

    case ( txt,
           i_exp,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->initialResiduals[i++] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "if (sim_verbose == LOG_RES_INIT) { printf(\" Residual[%d] : "
                                }, false));
        ret_2 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = %f\\n\",i,localData->initialResiduals[i-1]); }"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_132;

protected function lm_133
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp) :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_132(txt, i_exp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_133(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_133(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_133;

public function functionInitialResidual
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_residualEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_varDecls) := lm_133(l_body, a_residualEquations, l_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int initial_residual(double $P$_lambda)\n",
                                   "{\n",
                                   "  int i = 0;\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialResidual;

protected function lm_135
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_ALGORITHM(statements = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq2, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_135(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_135(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_135;

protected function lm_136
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq2, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_136(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_136(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_136;

protected function lm_137
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_eq2_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_eq2_exp) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq2_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_137(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_137(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_137;

protected function fun_138
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_index;
      list<SimCode.SimEqSystem> i_eq_eqs;
      SimCode.SimEqSystem i_eq_cont;
      Tpl.Text l_body;
      Tpl.Text l_prebody;
      Tpl.Text l_algs;
      Tpl.Text l_tmp;
      Tpl.Text l_varDecls;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont) )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionExtraResiduals(txt, ret_0);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eq_eqs, index = i_index) )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_tmp = Tpl.emptyTxt;
        l_algs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_algs, l_tmp, l_varDecls) = lm_135(l_algs, i_eq_eqs, l_tmp, l_varDecls);
        l_algs = Tpl.popIter(l_algs);
        l_prebody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_prebody, l_tmp, l_varDecls) = lm_136(l_prebody, i_eq_eqs, l_tmp, l_varDecls);
        l_prebody = Tpl.popIter(l_prebody);
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, l_varDecls) = lm_137(l_body, i_eq_eqs, l_varDecls);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void residualFunc"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int *n, double* xloc, double* res, int* iflag)\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ADD_NCALL_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",1);\n",
                                    "#endif\n",
                                    "mem_state = get_memory_state();\n"
                                }, true));
        txt = Tpl.writeText(txt, l_algs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_prebody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_138;

protected function lm_139
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_138(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_139(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_139(txt, rest);
      then txt;
  end matchcontinue;
end lm_139;

public function functionExtraResiduals
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_139(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionExtraResiduals;

protected function lm_141
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_141(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_141(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_141;

protected function lm_142
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_ALGORITHM(statements = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_142(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_142(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_142;

public function functionBoundParameters
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_parameterEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_divbody;
  Tpl.Text l_body;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  System.tmpTickReset(0);
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_141(l_body, a_parameterEquations, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  l_divbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_divbody, l_tmp, l_varDecls) := lm_142(l_divbody, a_parameterEquations, l_tmp, l_varDecls);
  l_divbody := Tpl.popIter(l_divbody);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int bound_parameters()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_divbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionBoundParameters;

protected function lm_144
  input Tpl.Text in_txt;
  input list<tuple<Integer, DAE.Exp>> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, DAE.Exp>> rest;
      Tpl.Text a_varDecls;
      Integer i_id;
      DAE.Exp i_e;
      Tpl.Text l_eRes;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_id, i_e) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_eRes, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("storeDelayedExpression("));
        txt = Tpl.writeStr(txt, intString(i_id));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_eRes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        (txt, a_varDecls) = lm_144(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_144(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_144;

protected function fun_145
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_delayed, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<tuple<Integer, DAE.Exp>> i_delayedExps;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(delayedExps = i_delayedExps),
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_144(txt, i_delayedExps, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_145;

protected function fun_146
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_delayed)
    local
      Tpl.Text txt;
      Integer i_maxDelayedIndex;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(maxDelayedIndex = i_maxDelayedIndex) )
      equation
        txt = Tpl.writeStr(txt, intString(i_maxDelayedIndex));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_146;

public function functionStoreDelayed
  input Tpl.Text txt;
  input SimCode.DelayedExpression a_delayed;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_storePart;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_storePart, l_varDecls) := fun_145(Tpl.emptyTxt, a_delayed, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("int numDelayExpressionIndex = "));
  out_txt := fun_146(out_txt, a_delayed);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";\n",
                                       "int function_storeDelayed()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_storePart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionStoreDelayed;

public function functionWhenReinitStatement
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_reinit, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_condition;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_msgVar;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  MODELICA_TERMINATE("));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message),
           a_varDecls )
      equation
        (txt, a_varDecls) = assertCommon(txt, i_condition, i_message, SimCode.contextSimulationDiscrete, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end functionWhenReinitStatement;

protected function lm_149
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("localData->helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !localData->helpVars_saved["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_149(txt, rest, a_helpInits, a_varDecls, a_preExp);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_149(txt, rest, a_helpInits, a_varDecls, a_preExp);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_149;

protected function fun_150
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_a_reinits;
  input Tpl.Text in_a_ifthen;
  input Tpl.Text in_a_helpIf;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_preExp;
  input Integer in_a_int;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_reinits, in_a_ifthen, in_a_helpIf, in_a_helpInits, in_a_preExp, in_a_int)
    local
      Tpl.Text txt;
      Tpl.Text a_ifthen;
      Tpl.Text a_helpIf;
      Tpl.Text a_helpInits;
      Tpl.Text a_preExp;
      Integer a_int;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_ifthen,
           a_helpIf,
           a_helpInits,
           a_preExp,
           a_int )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//For whenclause index: "));
        txt = Tpl.writeStr(txt, intString(a_int));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_helpInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, a_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_ifthen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_150;

public function genreinits
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_whenClauses;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_int;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_whenClauses, in_a_varDecls, in_a_int)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer a_int;
      list<BackendDAE.WhenOperator> i_reinits;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_ifthen;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions, reinits = i_reinits),
           a_varDecls,
           a_int )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, l_helpInits, a_varDecls, l_preExp) = lm_149(l_helpIf, i_conditions, l_helpInits, a_varDecls, l_preExp);
        l_helpIf = Tpl.popIter(l_helpIf);
        (l_ifthen, a_varDecls) = functionWhenReinitStatementThen(Tpl.emptyTxt, i_reinits, a_varDecls);
        txt = fun_150(txt, i_reinits, l_ifthen, l_helpIf, l_helpInits, l_preExp, a_int);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end genreinits;

protected function fun_152
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_reinit, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_condition;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_msgVar;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(10));
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "*needToIterate=1;"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(12));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE("));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message),
           a_varDecls )
      equation
        (txt, a_varDecls) = assertCommon(txt, i_condition, i_message, SimCode.contextSimulationDiscrete, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_152;

protected function lm_153
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      Tpl.Text a_varDecls;
      BackendDAE.WhenOperator i_reinit;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_reinit :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_152(txt, i_reinit, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_153(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_153(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_153;

public function functionWhenReinitStatementThen
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_body;
algorithm
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, out_a_varDecls) := lm_153(l_body, a_reinits, a_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.popBlock(out_txt);
end functionWhenReinitStatementThen;

protected function fun_155
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_reinit, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_val;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls,
           a_preExp )
      equation
        (l_val, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_155;

protected function lm_156
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      BackendDAE.WhenOperator i_reinit;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_reinit :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = fun_155(txt, i_reinit, a_varDecls, a_preExp);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_156(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_156(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_156;

public function functionWhenReinitStatementElse
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_body;
algorithm
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, out_a_varDecls, out_a_preExp) := lm_156(l_body, a_reinits, a_varDecls, a_preExp);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.popBlock(out_txt);
end functionWhenReinitStatementElse;

protected function lm_158
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_158(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_158(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_158;

public function functionODE_system
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input Integer a_n;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_odeEqs;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_odeEqs, l_tmp, l_varDecls) := lm_158(l_odeEqs, a_derivativEquations, l_tmp, l_varDecls);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("static void functionODE_system"));
  out_txt := Tpl.writeStr(out_txt, intString(a_n));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(int omc_thread_number)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_odeEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionODE_system;

protected function lm_160
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Integer x_i1;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqs :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = functionODE_system(txt, i_eqs, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_160(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_160(txt, rest);
      then txt;
  end matchcontinue;
end lm_160;

protected function lm_161
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Integer x_i1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("functionODE_system"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_161(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_161(txt, rest);
      then txt;
  end matchcontinue;
end lm_161;

protected function lm_162
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls2) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls2;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls2 )
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_varDecls2, a_tmp) = equation_(txt, i_eq, SimCode.contextInlineSolver, a_varDecls2, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls2) = lm_162(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_tmp, a_varDecls2) = lm_162(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);
  end matchcontinue;
end lm_162;

protected function lm_163
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls2) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls2;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           a_tmp,
           a_varDecls2 )
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           i_eqs :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_tmp, a_varDecls2) = lm_162(txt, i_eqs, a_tmp, a_varDecls2);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls2) = lm_163(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_tmp, a_varDecls2) = lm_163(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);
  end matchcontinue;
end lm_163;

protected function fun_164
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      equation
        ret_0 = Config.noProc();
        txt = Tpl.writeStr(txt, intString(ret_0));
      then txt;
  end matchcontinue;
end fun_164;

protected function fun_165
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dynamic"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static"));
      then txt;
  end matchcontinue;
end fun_165;

protected function fun_166
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel for private(id,th_id) schedule("));
        ret_0 = Config.noProc();
        txt = fun_165(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_166;

protected function fun_167
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_stateContPartInline;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateContPartInline, in_a_varDecls2)
    local
      Tpl.Text txt;
      Tpl.Text a_stateContPartInline;
      Tpl.Text a_varDecls2;

    case ( txt,
           "inline-euler",
           a_stateContPartInline,
           a_varDecls2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// we need to access the inline define that we compiled the simulation with\n",
                                    "// from the simulation runtime.\n",
                                    "int functionODE_inline()\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "mem_state = get_memory_state();\n",
                                    "begin_inline();\n"
                                }, true));
        txt = Tpl.writeText(txt, a_stateContPartInline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "end_inline();\n",
                                    "restore_memory_state(mem_state);\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "inline-rungekutta",
           a_stateContPartInline,
           a_varDecls2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// we need to access the inline define that we compiled the simulation with\n",
                                    "// from the simulation runtime.\n",
                                    "int functionODE_inline()\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "mem_state = get_memory_state();\n",
                                    "begin_inline();\n"
                                }, true));
        txt = Tpl.writeText(txt, a_stateContPartInline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "end_inline();\n",
                                    "restore_memory_state(mem_state);\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int functionODE_inline()\n",
                                    "{\n",
                                    "  return 0;\n",
                                    "}"
                                }, false));
      then txt;
  end matchcontinue;
end fun_167;

public function functionODE
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_derivativEquations;
  input Tpl.Text a_method;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_method;
protected
  String str_9;
  Boolean ret_8;
  Boolean ret_7;
  Tpl.Text l_stateContPartInline;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls2;
  Tpl.Text l_funcNames;
  Integer ret_2;
  Tpl.Text l_nFuncs;
  Tpl.Text l_funcs;
algorithm
  System.tmpTickReset(0);
  l_funcs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcs := lm_160(l_funcs, a_derivativEquations);
  l_funcs := Tpl.popIter(l_funcs);
  ret_2 := listLength(a_derivativEquations);
  l_nFuncs := Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
  l_funcNames := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcNames := lm_161(l_funcNames, a_derivativEquations);
  l_funcNames := Tpl.popIter(l_funcNames);
  l_varDecls2 := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_stateContPartInline := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_stateContPartInline, l_tmp, l_varDecls2) := lm_163(l_stateContPartInline, a_derivativEquations, l_tmp, l_varDecls2);
  l_stateContPartInline := Tpl.popIter(l_stateContPartInline);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_funcs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("static void (*functionODE_systems["));
  out_txt := Tpl.writeText(out_txt, l_nFuncs);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("])(int) = {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_funcNames);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "};\n",
                                       "\n",
                                       "void function_initMemoryState()\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("push_memory_states("));
  ret_7 := Flags.isSet(Flags.OPENMP);
  out_txt := fun_164(out_txt, ret_7);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(");\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "\n",
                                       "int functionODE()\n",
                                       "{\n",
                                       "  int id,th_id;\n",
                                       "  state mem_state; /* We need to have separate memory pools for separate systems... */\n",
                                       "  mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_8 := Flags.isSet(Flags.OPENMP);
  out_txt := fun_166(out_txt, ret_8);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("for (id=0; id<"));
  out_txt := Tpl.writeText(out_txt, l_nFuncs);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "; id++) {\n",
                                       "  th_id = omp_get_thread_num();\n",
                                       "  functionODE_systems[id](th_id);\n",
                                       "}\n",
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "#include <simulation_inline_solver.h>\n",
                                       "const char *_omc_force_solver=_OMC_FORCE_SOLVER;\n",
                                       "const int inline_work_states_ndims=_OMC_SOLVER_WORK_STATES_NDIMS;\n"
                                   }, true));
  str_9 := Tpl.textString(a_method);
  out_txt := fun_167(out_txt, str_9, l_stateContPartInline, l_varDecls2);
  out_a_method := a_method;
end functionODE;

protected function lm_169
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_169(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_169(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_169;

public function functionAlgebraic
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_algebraicEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algEquations;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_algEquations := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algEquations, l_tmp, l_varDecls) := lm_169(l_algEquations, a_algebraicEquations, l_tmp, l_varDecls);
  l_algEquations := Tpl.popIter(l_algEquations);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int functionAlgebraics()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_algEquations);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAlgebraic;

protected function lm_171
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_171(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_171(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_171;

public function functionAliasEquation
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_removedEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_removedPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_removedPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_removedPart, l_tmp, l_varDecls) := lm_171(l_removedPart, a_removedEquations, l_tmp, l_varDecls);
  l_removedPart := Tpl.popIter(l_removedPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int functionAliasEquations()\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_removedPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAliasEquation;

protected function lm_173
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_173(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_173(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_173;

protected function lm_174
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = genreinits(txt, i_when, a_varDecls, x_i0);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_174(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_174(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_174;

public function functionDAE
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.HelpVarInfo> a_helpVarInfo;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_reinit;
  Tpl.Text l_eqs;
  Tpl.Text l_tmp;
  Tpl.Text l_jens;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  System.tmpTickReset(0);
  l_jens := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_tmp, l_varDecls) := lm_173(l_eqs, a_allEquationsPlusWhen, l_tmp, l_varDecls);
  l_eqs := Tpl.popIter(l_eqs);
  l_reinit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_reinit, l_varDecls) := lm_174(l_reinit, a_whenClauses, l_varDecls);
  l_reinit := Tpl.popIter(l_reinit);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int functionDAE(int *needToIterate)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "*needToIterate = 0;\n",
                                       "inUpdate=initial()?0:1;\n",
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_reinit);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "inUpdate=0;\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionDAE;

public function functionOnlyZeroCrossing
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_zeroCrossingsCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_zeroCrossingsCode, l_varDecls) := zeroCrossingsTpl2(Tpl.emptyTxt, a_zeroCrossings, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int function_onlyZeroCrossings(double *gout,double *t)\n",
                                   "{\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_zeroCrossingsCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionOnlyZeroCrossing;

protected function fun_177
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_var;

    case ( txt,
           (i_var as DAE.CREF_QUAL(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") { if (sim_verbose >= LOG_EVENTS) { printf(\"Discrete Var "));
        txt = crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\n\", $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); }  needToIterate=1; }"));
      then txt;

    case ( txt,
           (i_var as DAE.CREF_IDENT(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") { if (sim_verbose >= LOG_EVENTS) { printf(\"Discrete Var "));
        txt = crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\n\", $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); }  needToIterate=1; }"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_177;

protected function lm_178
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_177(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_178(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_178(txt, rest);
      then txt;
  end matchcontinue;
end lm_178;

public function functionCheckForDiscreteChanges
  input Tpl.Text txt;
  input list<DAE.ComponentRef> a_discreteModelVars;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_changediscreteVars;
algorithm
  l_changediscreteVars := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_changediscreteVars := lm_178(l_changediscreteVars, a_discreteModelVars);
  l_changediscreteVars := Tpl.popIter(l_changediscreteVars);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int checkForDiscreteChanges()\n",
                                   "{\n",
                                   "  int needToIterate = 0;\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_changediscreteVars);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return needToIterate;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionCheckForDiscreteChanges;

protected function fun_180
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      Tpl.Text txt_0;

    case ( txt,
           "modelica_real",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%g"));
      then txt;

    case ( txt,
           "modelica_integer",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%ld"));
      then txt;

    case ( txt,
           "modelica_boolean",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%d"));
      then txt;

    case ( txt,
           "modelica_string",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%s"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Do not know what printf argument to give "));
        txt_0 = crefStr(txt_0, a_cr);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 1245, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_180;

public function crefToPrintfArg
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
protected
  String str_1;
  Tpl.Text txt_0;
algorithm
  txt_0 := crefType(Tpl.emptyTxt, a_cr);
  str_1 := Tpl.textString(txt_0);
  out_txt := fun_180(txt, str_1, a_cr);
end crefToPrintfArg;

public function crefType
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.ExpType i_identType;

    case ( txt,
           DAE.CREF_IDENT(identType = i_identType) )
      equation
        txt = expTypeModelica(txt, i_identType);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(componentRef = i_componentRef) )
      equation
        txt = crefType(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("crefType:ERROR"));
      then txt;
  end matchcontinue;
end crefType;

protected function lm_183
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, SimCode.contextSimulationDiscrete, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_183(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_183(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_183;

public function functionAssertsforCheck
  input Tpl.Text txt;
  input list<DAE.Statement> a_algorithmAndEquationAsserts;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algAndEqAssertsPart;
  Tpl.Text l_varDecls;
algorithm
  System.tmpTickReset(0);
  l_varDecls := Tpl.emptyTxt;
  l_algAndEqAssertsPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algAndEqAssertsPart, l_varDecls) := lm_183(l_algAndEqAssertsPart, a_algorithmAndEquationAsserts, l_varDecls);
  l_algAndEqAssertsPart := Tpl.popIter(l_algAndEqAssertsPart);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* for continuous time variables */\n",
                                   "int checkForAsserts()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_algAndEqAssertsPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAssertsforCheck;

public function defvars
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_item;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_item)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name) )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end defvars;

public function functionlinearmodel
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;
      list<SimCode.SimVar> i_vars_inputVars;
      list<SimCode.SimVar> i_vars_stateVars;
      Absyn.Path i_name;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numStateVars;
      Tpl.Text l_vectorY;
      Tpl.Text l_vectorU;
      Tpl.Text l_vectorX;
      Tpl.Text l_matrixD;
      Tpl.Text l_matrixC;
      Tpl.Text l_matrixB;
      Tpl.Text l_matrixA;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numInVars = i_varInfo_numInVars, numOutVars = i_varInfo_numOutVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, inputVars = i_vars_inputVars, outputVars = i_vars_outputVars), name = i_name) )
      equation
        l_matrixA = genMatrix(Tpl.emptyTxt, "A", i_varInfo_numStateVars, i_varInfo_numStateVars);
        l_matrixB = genMatrix(Tpl.emptyTxt, "B", i_varInfo_numStateVars, i_varInfo_numInVars);
        l_matrixC = genMatrix(Tpl.emptyTxt, "C", i_varInfo_numOutVars, i_varInfo_numStateVars);
        l_matrixD = genMatrix(Tpl.emptyTxt, "D", i_varInfo_numOutVars, i_varInfo_numInVars);
        l_vectorX = genVector(Tpl.emptyTxt, "x", i_varInfo_numStateVars, 0);
        l_vectorU = genVector(Tpl.emptyTxt, "u", i_varInfo_numInVars, 1);
        l_vectorY = genVector(Tpl.emptyTxt, "y", i_varInfo_numOutVars, 2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("const char *linear_model_frame =\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"model linear_"));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\n  parameter Integer n = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // states \\n  parameter Integer k = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // top-level inputs \\n  parameter Integer l = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; // top-level outputs \\n\"\n",
                                    "\"  parameter Real x0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {%s};\\n\"\n",
                                    "\"  parameter Real u0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {%s};\\n\"\n"));
        txt = Tpl.writeText(txt, l_matrixA);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixB);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixD);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorX);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorU);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorY);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"\\n  "));
        txt = getVarName(txt, i_vars_stateVars, "x", i_varInfo_numStateVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = getVarName(txt, i_vars_inputVars, "u", i_varInfo_numInVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = getVarName(txt, i_vars_outputVars, "y", i_varInfo_numOutVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\n\"\n",
                                    "\"equation\\n  der(x) = A * x + B * u;\\n  y = C * x + D * u;\\nend linear_"
                                }, false));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\\n\"\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionlinearmodel;

protected function fun_187
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input Tpl.Text in_a_rest;
  input Tpl.Text in_a_arrindex;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_rest, in_a_arrindex, in_a_arrayName)
    local
      Tpl.Text txt;
      Tpl.Text a_rest;
      Tpl.Text a_arrindex;
      String a_arrayName;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name),
           a_rest,
           a_arrindex,
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefM(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, a_arrindex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n  "));
        txt = Tpl.writeText(txt, a_rest);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_187;

public function getVarName
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_simVars;
  input String in_a_arrayName;
  input Integer in_a_arraySize;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVars, in_a_arrayName, in_a_arraySize)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_arraySize;
      SimCode.SimVar i_var;
      list<SimCode.SimVar> i_restVars;
      Integer ret_3;
      Integer ret_2;
      Tpl.Text l_arrindex;
      Tpl.Text l_rest;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: i_restVars,
           a_arrayName,
           a_arraySize )
      equation
        l_rest = getVarName(Tpl.emptyTxt, i_restVars, a_arrayName, a_arraySize);
        ret_2 = listLength(i_restVars);
        ret_3 = SimCode.decrementInt(a_arraySize, ret_2);
        l_arrindex = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        txt = fun_187(txt, i_var, l_rest, l_arrindex, a_arrayName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end getVarName;

protected function fun_189
  input Tpl.Text in_txt;
  input Integer in_a_col;
  input Integer in_a_row;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_col, in_a_row, in_a_name)
    local
      Tpl.Text txt;
      Integer a_row;
      String a_name;
      Integer i_col;

    case ( txt,
           (i_col as 0),
           a_row,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = zeros("));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");%s\\n\""));
      then txt;

    case ( txt,
           i_col,
           a_row,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = [%s];\\n\""));
      then txt;
  end matchcontinue;
end fun_189;

protected function fun_190
  input Tpl.Text in_txt;
  input Integer in_a_row;
  input String in_a_name;
  input Integer in_a_col;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_row, in_a_name, in_a_col)
    local
      Tpl.Text txt;
      String a_name;
      Integer a_col;
      Integer i_row;

    case ( txt,
           (i_row as 0),
           a_name,
           a_col )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = zeros("));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");%s\\n\""));
      then txt;

    case ( txt,
           i_row,
           a_name,
           a_col )
      equation
        txt = fun_189(txt, a_col, i_row, a_name);
      then txt;
  end matchcontinue;
end fun_190;

public function genMatrix
  input Tpl.Text txt;
  input String a_name;
  input Integer a_row;
  input Integer a_col;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_190(txt, a_row, a_name, a_col);
end genMatrix;

protected function fun_192
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("](start="));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0);\\n\""));
      then txt;
  end matchcontinue;
end fun_192;

protected function fun_193
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  input Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  input Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("](start= "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0);\\n\""));
      then txt;
  end matchcontinue;
end fun_193;

protected function fun_194
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  output Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  output Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;
  end matchcontinue;
end fun_194;

protected function fun_195
  input Tpl.Text in_txt;
  input Integer in_a_flag;
  input String in_a_name;
  input Integer in_a_numIn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_flag, in_a_name, in_a_numIn)
    local
      Tpl.Text txt;
      String a_name;
      Integer a_numIn;

    case ( txt,
           0,
           a_name,
           a_numIn )
      equation
        txt = fun_192(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           1,
           a_name,
           a_numIn )
      equation
        txt = fun_193(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           2,
           a_name,
           a_numIn )
      equation
        txt = fun_194(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_195;

public function genVector
  input Tpl.Text txt;
  input String a_name;
  input Integer a_numIn;
  input Integer a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_195(txt, a_flag, a_name, a_numIn);
end genVector;

protected function lm_197
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_197(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_197(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_197;

protected function lm_198
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = genoutVars(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_198(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_198(txt, rest);
      then txt;
  end matchcontinue;
end lm_198;

public function functionJac
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_jacEquations;
  input list<SimCode.SimVar> a_tmpVars;
  input String a_columnName;
  input String a_matrixName;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_outvars__;
  Tpl.Text l_eqns__;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqns__ := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqns__, l_tmp, l_varDecls) := lm_197(l_eqns__, a_jacEquations, l_tmp, l_varDecls);
  l_eqns__ := Tpl.popIter(l_eqns__);
  l_outvars__ := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_outvars__ := lm_198(l_outvars__, a_tmpVars);
  l_outvars__ := Tpl.popIter(l_outvars__);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int functionJac"));
  out_txt := Tpl.writeStr(out_txt, a_matrixName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_0(double *seed, double *out_col)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("mem_state = get_memory_state();\n"));
  out_txt := Tpl.writeText(out_txt, l_eqns__);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "// write column\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_outvars__);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int i;\n",
                                       "for(i=0;i<"
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_columnName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";i++){\n",
                                       "    if (sim_verbose == LOG_JAC || sim_verbose == LOG_ENDJAC){\n",
                                       "      printf(\"col: col[%d] = %f \\n\",i,out_col[i]);\n",
                                       "    }\n",
                                       "}\n",
                                       "\n",
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionJac;

protected function fun_200
  input Tpl.Text in_txt;
  input Integer in_a_index;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_index, in_a_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_name;
      Integer i_index;

    case ( txt,
           -1,
           _ )
      then txt;

    case ( txt,
           i_index,
           a_name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out_col["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_200;

public function genoutVars
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      Integer i_index;

    case ( txt,
           SimCode.SIMVAR(name = i_name, index = i_index) )
      equation
        txt = fun_200(txt, i_index, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end genoutVars;

protected function lm_202
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_matrixname)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String a_matrixname;
      String i_name;
      list<SimCode.SimVar> i_vars;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_eqs, i_vars, i_name) :: rest,
           a_matrixname )
      equation
        txt = functionJac(txt, i_eqs, i_vars, i_name, a_matrixname);
        txt = Tpl.nextIter(txt);
        txt = lm_202(txt, rest, a_matrixname);
      then txt;

    case ( txt,
           _ :: rest,
           a_matrixname )
      equation
        txt = lm_202(txt, rest, a_matrixname);
      then txt;
  end matchcontinue;
end lm_202;

protected function lm_203
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_name) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_203(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_203(txt, rest);
      then txt;
  end matchcontinue;
end lm_203;

protected function fun_204
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_i0)
    local
      Tpl.Text txt;
      Integer a_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name),
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" seed["));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_204;

protected function lm_205
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = fun_204(txt, i_var, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_205(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_205(txt, rest);
      then txt;
  end matchcontinue;
end lm_205;

protected function fun_206
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_seedVars;
  input list<SimCode.JacobianColumn> in_a_jacobianMatrix;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_seedVars, in_a_jacobianMatrix, in_a_matrixname)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> a_jacobianMatrix;
      String a_matrixname;
      list<SimCode.SimVar> i_seedVars;
      Integer ret_4;
      Tpl.Text l_index__;
      Tpl.Text l_writeJac__;
      Tpl.Text l_indexColumn;
      Tpl.Text l_jacMats;

    case ( txt,
           {},
           _,
           a_matrixname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(double* jac){\n",
                                    "   return 0;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_seedVars,
           a_jacobianMatrix,
           a_matrixname )
      equation
        l_jacMats = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jacMats = lm_202(l_jacMats, a_jacobianMatrix, a_matrixname);
        l_jacMats = Tpl.popIter(l_jacMats);
        l_indexColumn = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexColumn = lm_203(l_indexColumn, a_jacobianMatrix);
        l_indexColumn = Tpl.popIter(l_indexColumn);
        l_writeJac__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_writeJac__ = lm_205(l_writeJac__, i_seedVars);
        l_writeJac__ = Tpl.popIter(l_writeJac__);
        ret_4 = listLength(i_seedVars);
        l_index__ = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#define _OMC_SEED_HACK double *seed\n",
                                    "#define _OMC_SEED_HACK_2 seed\n"
                                }, true));
        txt = Tpl.writeText(txt, l_writeJac__);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_jacMats);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(double* jac){\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double seed["));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {0};\n",
                                    "double localtmp["
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {0};\n",
                                    "int i,j,l,k;\n",
                                    "for(i=0,k=0;  i < "
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";i++){\n",
                                    "  seed[i] = 1;\n",
                                    "\n",
                                    "  if (sim_verbose == LOG_JAC || sim_verbose == LOG_ENDJAC){\n",
                                    "    printf(\"Caluculate one row:\\n\");\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(l=0;  l < "));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";l++){\n",
                                    "  printf(\"seed: seed[%d]= %f\\n\",l,seed[l]);\n",
                                    "}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_0(seed,localtmp);\n",
                                    "seed[i] = 0;\n",
                                    "for(j=0; j < "
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";j++)\n",
                                    "  jac[k++] = localtmp[j];\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    " return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end matchcontinue;
end fun_206;

public function generateMatrix
  input Tpl.Text txt;
  input list<SimCode.JacobianColumn> a_jacobianMatrix;
  input list<SimCode.SimVar> a_seedVars;
  input String a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_206(txt, a_seedVars, a_jacobianMatrix, a_matrixname);
end generateMatrix;

protected function lm_208
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String i_name;
      list<SimCode.SimVar> i_vars;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_mat, i_vars, i_name) :: rest )
      equation
        txt = generateMatrix(txt, i_mat, i_vars, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_208(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_208(txt, rest);
      then txt;
  end matchcontinue;
end lm_208;

public function generateLinearMatrixes
  input Tpl.Text txt;
  input list<SimCode.JacobianMatrix> a_JacobianMatrixes;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacMats;
algorithm
  l_jacMats := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                               "\n",
                                                                               "\n"
                                                                           }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_jacMats := lm_208(l_jacMats, a_JacobianMatrixes);
  l_jacMats := Tpl.popIter(l_jacMats);
  out_txt := Tpl.writeText(txt, l_jacMats);
end generateLinearMatrixes;

protected function lm_210
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = zeroCrossingTpl2(txt, x_i0, i_relation__, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_210(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_210(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_210;

public function zeroCrossingsTpl2
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_210(out_txt, a_zeroCrossings, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end zeroCrossingsTpl2;

protected function fun_212
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_relation, in_a_index1, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_index1;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp2;
      DAE.Operator i_operator;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_op;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.RELATION(exp1 = i_exp1, operator = i_operator, exp2 = i_exp2),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextOther, l_preExp, a_varDecls);
        l_op = zeroCrossingOpFunc(Tpl.emptyTxt, i_operator);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_op);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {_, _}),
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_index1,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// UNKNOWN ZERO CROSSING for "));
        txt = Tpl.writeStr(txt, intString(a_index1));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_212;

public function zeroCrossingTpl2
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_212(txt, a_relation, a_index1, a_varDecls);
end zeroCrossingTpl2;

protected function lm_214
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = zeroCrossingTpl(txt, x_i0, i_relation__, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_214(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_214(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_214;

public function zeroCrossingsTpl
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_214(out_txt, a_zeroCrossings, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end zeroCrossingsTpl;

protected function fun_216
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_relation, in_a_index1, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_index1;
      Tpl.Text a_varDecls;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      DAE.Exp i_exp2;
      DAE.Operator i_operator;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_op;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.RELATION(exp1 = i_exp1, operator = i_operator, exp2 = i_exp2),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextOther, l_preExp, a_varDecls);
        l_op = zeroCrossingOpFunc(Tpl.emptyTxt, i_operator);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_op);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval}),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, l_preExp, a_varDecls);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",Sample(*t,"));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZERO CROSSING ERROR"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_216;

public function zeroCrossingTpl
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_216(txt, a_relation, a_index1, a_varDecls);
end zeroCrossingTpl;

protected function lm_218
  input Tpl.Text in_txt;
  input list<SimCode.SampleCondition> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SampleCondition> rest;
      Tpl.Text a_varDecls;
      DAE.Exp i_relation__;
      Integer i_index;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_relation__, i_index) :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = timeEventTpl(txt, i_index, i_relation__, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_218(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_218(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_218;

public function timeEventsTpl
  input Tpl.Text txt;
  input list<SimCode.SampleCondition> a_sampleConditions;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_218(out_txt, a_sampleConditions, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end timeEventsTpl;

protected function fun_220
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_relation, in_a_index1, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_index1;
      Tpl.Text a_varDecls;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      Tpl.Text l_e2;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.RELATION(exp1 = _),
           a_index1,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" Not a time event */"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval, _}),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, l_preExp, a_varDecls);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->rawSampleExps[i].start = "));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "localData->rawSampleExps[i].interval = "
                                }, false));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "localData->rawSampleExps[i++].zc_index = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_index1,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* UNKNOWN ZERO CROSSING for "));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_220;

public function timeEventTpl
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_220(txt, a_relation, a_index1, a_varDecls);
end timeEventTpl;

public function zeroCrossingOpFunc
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.LESS(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Less"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Greater"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LessEq"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("GreaterEq"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end zeroCrossingOpFunc;

protected function fun_223
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varD;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varD;
algorithm
  (out_txt, out_a_varD) :=
  matchcontinue(in_txt, in_a_eq, in_a_varD, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varD;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationSimpleAssign(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationArrayCallAssign(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationAlgorithm(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationLinear(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationNonlinear(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_WHEN(left = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationWhen(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           _,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_varD);
  end matchcontinue;
end fun_223;

protected function fun_224
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_eqs;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqs, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_eqs, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_eqs;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_x;
      Tpl.Text l_varD;
      Tpl.Text l_tmp;
      Integer ret_1;
      Tpl.Text l_ix;

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_eqs,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls, a_eqs) = equationMixed(txt, i_e, a_context, a_varDecls, a_eqs);
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           a_eqs,
           a_varDecls,
           _ )
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           i_eq,
           a_eqs,
           a_varDecls,
           a_context )
      equation
        ret_1 = System.tmpTickIndex(10);
        l_ix = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_tmp = Tpl.emptyTxt;
        l_varD = Tpl.emptyTxt;
        (l_x, l_varD) = fun_223(Tpl.emptyTxt, i_eq, l_varD, a_context);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING_LIST({
                                        "\n",
                                        "void eqFunction_"
                                    }, false));
        a_eqs = Tpl.writeText(a_eqs, l_ix);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_LINE("(_OMC_SEED_HACK) {\n"));
        a_eqs = Tpl.pushBlock(a_eqs, Tpl.BT_INDENT(2));
        a_eqs = Tpl.writeText(a_eqs, l_varD);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.writeText(a_eqs, l_x);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.popBlock(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING_LIST({
                                        "}\n",
                                        "\n"
                                    }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("eqFunction_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(_OMC_SEED_HACK_2);"));
      then (txt, a_eqs, a_varDecls);
  end matchcontinue;
end fun_224;

protected function fun_225
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) :=
  matchcontinue(in_txt, in_a_context, in_a_eq, in_a_varDecls, in_a_eqs)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqs;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.INLINE_CONTEXT()),
           a_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_varDecls) = old_equation_(txt, a_eq, i_context, a_varDecls);
      then (txt, a_varDecls, a_eqs);

    case ( txt,
           i_context,
           a_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_eqs, a_varDecls) = fun_224(txt, a_eq, a_eqs, a_varDecls, i_context);
      then (txt, a_varDecls, a_eqs);
  end matchcontinue;
end fun_225;

public function equation_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) := fun_225(txt, a_context, a_eq, a_varDecls, a_eqs);
end equation_;

public function old_equation_
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationArrayCallAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationAlgorithm(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationLinear(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationNonlinear(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(left = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationWhen(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_varDecls);
  end matchcontinue;
end old_equation_;

protected function fun_228
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_tmp, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_e;
      Integer ret_6;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_1 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationArrayCallAssign(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_2 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationAlgorithm(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_3 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationLinear(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_4 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls, a_tmp) = equationMixed(txt, i_e, a_context, a_varDecls, a_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_5 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationNonlinear(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(left = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_6 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_6));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationWhen(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _,
           a_tmp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end fun_228;

public function myequation_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
algorithm
  l_tmp := Tpl.emptyTxt;
  (out_txt, l_tmp, out_a_varDecls) := fun_228(txt, a_eq, l_tmp, a_varDecls, a_context);
end myequation_;

protected function fun_230
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_c;
  input String in_a_arr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_c, in_a_arr)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef i_c;

    case ( txt,
           (i_c as DAE.CREF_QUAL(ident = "$DER")),
           a_arr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "inline_integrate_array(size_of_dimension_real_array("
                                }, false));
        txt = Tpl.writeStr(txt, a_arr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",1),"));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_230;

public function inlineArray
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input String in_a_arr;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_arr, in_a_c)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef a_c;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_arr,
           a_c )
      equation
        txt = fun_230(txt, a_c, a_arr);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineArray;

protected function fun_232
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           SimCode.SIMVAR(name = (i_cr as DAE.CREF_QUAL(ident = "$DER"))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inline_integrate("));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_232;

protected function lm_233
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_232(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_233(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_233(txt, rest);
      then txt;
  end matchcontinue;
end lm_233;

protected function fun_234
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_simvars;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_simvars )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_233(txt, i_simvars);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_234;

public function inlineVars
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> a_simvars;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_simvars )
      equation
        txt = fun_234(txt, a_simvars);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineVars;

protected function fun_236
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(ident = "$DER")) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inline_integrate("));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_236;

protected function lm_237
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = fun_236(txt, i_cr);
        txt = Tpl.nextIter(txt);
        txt = lm_237(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_237(txt, rest);
      then txt;
  end matchcontinue;
end lm_237;

protected function fun_238
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_a_crefs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_crefs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> i_crefs;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_crefs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_237(txt, i_crefs);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_238;

public function inlineCrefs
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input list<DAE.ComponentRef> in_a_crefs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_crefs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_crefs;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_crefs )
      equation
        txt = fun_238(txt, a_crefs);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineCrefs;

protected function fun_240
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(ident = "$DER")) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "inline_integrate("
                                }, false));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_240;

public function inlineCref
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_cr )
      equation
        txt = fun_240(txt, a_cr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineCref;

public function equationSimpleAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cref;
      SimCode.SimEqSystem i_eq;
      DAE.Exp i_exp;
      Absyn.Info ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref)),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_2 = SimCode.eqInfo(i_eq);
        txt = modelicaLine(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = inlineCref(txt, a_context, i_cref);
        txt = Tpl.softNewLine(txt);
        txt = endModelicaLine(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end equationSimpleAssign;

protected function fun_243
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_eqn_exp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_eqn_componentRef;
  input Tpl.Text in_a_expPart;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_eqn_exp, in_a_context, in_a_eqn_componentRef, in_a_expPart, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_eqn_exp;
      SimCode.Context a_context;
      DAE.ComponentRef a_eqn_componentRef;
      Tpl.Text a_expPart;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text txt_1;
      String ret_1;
      Tpl.Text l_tvar;

    case ( txt,
           "boolean",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "boolean_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_boolean_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(l_tvar), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           "integer",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "integer_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_integer_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(l_tvar), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           "real",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_real_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(a_expPart), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_eqn_exp,
           _,
           _,
           _,
           _,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("No runtime support for this sort of array call: "));
        ret_1 = ExpressionDump.printExpStr(a_eqn_exp);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 1842, 14), Tpl.textString(txt_1));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_243;

protected function fun_244
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_eqn_componentRef;
      DAE.Exp i_eqn_exp;
      DAE.Exp i_exp;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(exp = (i_eqn_exp as i_exp), componentRef = i_eqn_componentRef),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt_2 = expTypeFromExpShort(Tpl.emptyTxt, i_eqn_exp);
        str_3 = Tpl.textString(txt_2);
        (txt, a_varDecls) = fun_243(txt, str_3, i_eqn_exp, a_context, i_eqn_componentRef, l_expPart, l_preExp, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_244;

public function equationArrayCallAssign
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Absyn.Info ret_0;
algorithm
  ret_0 := SimCode.eqInfo(a_eq);
  out_txt := modelicaLine(txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  (out_txt, out_a_varDecls) := fun_244(out_txt, a_eq, a_context, a_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := endModelicaLine(out_txt);
end equationArrayCallAssign;

protected function lm_246
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_246(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_246(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_246;

public function equationAlgorithm
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statements;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = i_statements),
           a_context,
           a_varDecls )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_246(txt, i_statements, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end equationAlgorithm;

protected function fun_248
  input Tpl.Text in_txt;
  input Boolean in_a_partOfMixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_partOfMixed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_mixed"));
      then txt;
  end matchcontinue;
end fun_248;

protected function fun_249
  input Tpl.Text in_txt;
  input Boolean in_a_partOfMixed;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_partOfMixed, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_249;

protected function lm_250
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_size;
  input Tpl.Text in_a_aname;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_size, in_a_aname, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      Tpl.Text a_size;
      Tpl.Text a_aname;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_size,
           a_aname,
           a_varDecls,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("set_matrix_elt("));
        txt = Tpl.writeText(txt, a_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_250(txt, rest, a_size, a_aname, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_size,
           a_aname,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_250(txt, rest, a_size, a_aname, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_250;

protected function lm_251
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_bname;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_bname, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_bname;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_exp :: rest,
           a_bname,
           a_varDecls,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("set_vector_elt("));
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_251(txt, rest, a_bname, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_bname,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_251(txt, rest, a_bname, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_251;

protected function lm_252
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_bname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_bname)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_bname;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_bname )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_vector_elt("));
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_252(txt, rest, a_bname);
      then txt;

    case ( txt,
           _ :: rest,
           a_bname )
      equation
        txt = lm_252(txt, rest, a_bname);
      then txt;
  end matchcontinue;
end lm_252;

protected function fun_253
  input Tpl.Text in_txt;
  input Boolean in_a_partOfMixed;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_partOfMixed, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_253;

public function equationLinear
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      Integer i_index;
      Boolean i_partOfMixed;
      list<SimCode.SimVar> i_vars;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      Tpl.Text l_mixedPostfix;
      Tpl.Text l_bname;
      Tpl.Text l_aname;
      Integer ret_3;
      Tpl.Text l_size;
      Integer ret_1;
      Tpl.Text l_uid;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, partOfMixed = i_partOfMixed, index = i_index, simJac = i_simJac, beqs = i_beqs),
           a_context,
           a_varDecls )
      equation
        ret_1 = System.tmpTick();
        l_uid = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        ret_3 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_aname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("A"));
        l_aname = Tpl.writeText(l_aname, l_uid);
        l_bname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("b"));
        l_bname = Tpl.writeText(l_bname, l_uid);
        l_mixedPostfix = fun_248(Tpl.emptyTxt, i_partOfMixed);
        txt = fun_249(txt, i_partOfMixed, i_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* Linear equation system */\n",
                                    "double "
                                }, false));
        txt = Tpl.writeText(txt, l_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_7 = listLength(i_vars);
        ret_8 = listLength(i_vars);
        ret_9 = intMul(ret_7, ret_8);
        txt = Tpl.writeStr(txt, intString(ret_9));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {0};\n",
                                    "double "
                                }, false));
        txt = Tpl.writeText(txt, l_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {0};\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_250(txt, i_simJac, l_size, l_aname, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_251(txt, i_beqs, l_bname, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("solve_linear_equation_system"));
        txt = Tpl.writeText(txt, l_mixedPostfix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_uid);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_252(txt, i_vars, l_bname);
        txt = Tpl.popIter(txt);
        txt = inlineVars(txt, a_context, i_vars);
        txt = Tpl.softNewLine(txt);
        txt = fun_253(txt, i_partOfMixed, i_index);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end equationLinear;

protected function lm_255
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preDisc;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preDisc;
algorithm
  (out_txt, out_a_varDecls, out_a_preDisc) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preDisc, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preDisc;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           a_varDecls,
           a_preDisc,
           _ )
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref) :: rest,
           a_varDecls,
           a_preDisc,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_expPart, a_preDisc, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preDisc, a_varDecls);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "discrete_loc2["
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preDisc) = lm_255(txt, rest, a_varDecls, a_preDisc, a_context);
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preDisc,
           a_context )
      equation
        (txt, a_varDecls, a_preDisc) = lm_255(txt, rest, a_varDecls, a_preDisc, a_context);
      then (txt, a_varDecls, a_preDisc);
  end matchcontinue;
end lm_255;

protected function lm_256
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
        txt = lm_256(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_256(txt, rest);
      then txt;
  end matchcontinue;
end lm_256;

protected function lm_257
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
        txt = lm_257(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_257(txt, rest);
      then txt;
  end matchcontinue;
end lm_257;

protected function lm_258
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete_loc["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_258(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_258(txt, rest);
      then txt;
  end matchcontinue;
end lm_258;

protected function lm_259
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_boolean*)&"));
        txt = cref(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_259(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_259(txt, rest);
      then txt;
  end matchcontinue;
end lm_259;

public function equationMixed
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_tmp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_tmp;
algorithm
  (out_txt, out_a_varDecls, out_a_tmp) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_tmp)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_tmp;
      list<Integer> i_value__dims;
      Integer i_index;
      list<SimCode.SimEqSystem> i_discEqs;
      list<Integer> i_values;
      list<SimCode.SimVar> i_discVars;
      SimCode.SimEqSystem i_cont;
      Tpl.Text l_discLoc2;
      Tpl.Text l_preDisc;
      Integer ret_4;
      Tpl.Text l_valuesLenStr;
      Integer ret_2;
      Tpl.Text l_numDiscVarsStr;
      Tpl.Text l_contEqs;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discVars = i_discVars, values = i_values, discEqs = i_discEqs, index = i_index, value_dims = i_value__dims),
           a_context,
           a_varDecls,
           a_tmp )
      equation
        (l_contEqs, a_varDecls, a_tmp) = equation_(Tpl.emptyTxt, i_cont, a_context, a_varDecls, a_tmp);
        ret_2 = listLength(i_discVars);
        l_numDiscVarsStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        ret_4 = listLength(i_values);
        l_valuesLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        l_preDisc = Tpl.emptyTxt;
        l_discLoc2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_discLoc2, a_varDecls, l_preDisc) = lm_255(l_discLoc2, i_discEqs, a_varDecls, l_preDisc, a_context);
        l_discLoc2 = Tpl.popIter(l_discLoc2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#endif\n",
                                    "mixed_equation_system("
                                }, false));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "modelica_boolean values["
                                }, false));
        txt = Tpl.writeText(txt, l_valuesLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_256(txt, i_values);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "int value_dims["
                                }, false));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_257(txt, i_value__dims);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_258(txt, i_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_contEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_preDisc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_discLoc2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean *loc_ptrs["));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_259(txt, i_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "check_discrete_values("
                                }, false));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_valuesLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "mixed_equation_system_end("
                                }, false));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_tmp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_tmp )
      then (txt, a_varDecls, a_tmp);
  end matchcontinue;
end equationMixed;

protected function lm_261
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nls_x["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = extraPolate("));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",$P$old"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",$P$old2"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "nls_xold["
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = $P$old"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_261(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_261(txt, rest);
      then txt;
  end matchcontinue;
end lm_261;

protected function lm_262
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = nls_x["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_262(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_262(txt, rest);
      then txt;
  end matchcontinue;
end lm_262;

protected function fun_263
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Integer i_index;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, index = i_index),
           a_context )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "SIM_PROF_ADD_NCALL_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",-1);\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "start_nonlinear_system("
                                }, false));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_261(txt, i_crefs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("solve_nonlinear_system(residualFunc"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = reverseLookupEquationNumber(txt, i_index);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_262(txt, i_crefs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end_nonlinear_system();"));
        txt = inlineCrefs(txt, a_context, i_crefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_263;

public function equationNonlinear
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_263(txt, a_eq, a_context);
  out_a_varDecls := a_varDecls;
end equationNonlinear;

public function reverseLookupEquationNumber
  input Tpl.Text txt;
  input Integer a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("localData->equationInfo[omc_equationInfo_reverse_prof_index[SIM_PROF_EQ_"));
  out_txt := Tpl.writeStr(out_txt, intString(a_index));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("]]"));
end reverseLookupEquationNumber;

protected function lm_266
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("localData->helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !localData->helpVars_saved["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_266(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_266(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_266;

protected function lm_267
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("localData->helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !localData->helpVars_saved["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_267(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_267(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_267;

public function equationWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_elseWhen;
      Tpl.Text l_exp;
      Tpl.Text l_preExp2;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE()),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, l_helpInits, a_varDecls, l_preExp) = lm_266(l_helpIf, i_conditions, l_helpInits, a_varDecls, l_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_helpInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp2);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("} else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq)),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, l_helpInits, a_varDecls, l_preExp) = lm_267(l_helpIf, i_conditions, l_helpInits, a_varDecls, l_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        (l_elseWhen, l_preExp, l_helpInits, a_varDecls) = equationElseWhen(Tpl.emptyTxt, i_elseWhenEq, a_context, l_preExp, l_helpInits, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_helpInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp2);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_elseWhen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end equationWhen;

protected function lm_269
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("localData->helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !localData->helpVars_saved["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_269(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_269(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_269;

protected function lm_270
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("localData->helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !localData->helpVars_saved["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_270(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_270(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_270;

public function equationElseWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_helpInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_preExp, in_a_helpInits, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_elseWhen;
      Tpl.Text l_exp;
      Tpl.Text l_preExp2;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE()),
           a_context,
           a_preExp,
           a_helpInits,
           a_varDecls )
      equation
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, a_helpInits, a_varDecls, a_preExp) = lm_269(l_helpIf, i_conditions, a_helpInits, a_varDecls, a_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if ("));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp2);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_preExp, a_helpInits, a_varDecls);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq)),
           a_context,
           a_preExp,
           a_helpInits,
           a_varDecls )
      equation
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, a_helpInits, a_varDecls, a_preExp) = lm_270(l_helpIf, i_conditions, a_helpInits, a_varDecls, a_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        (l_elseWhen, a_preExp, a_helpInits, a_varDecls) = equationElseWhen(Tpl.emptyTxt, i_elseWhenEq, a_context, a_preExp, a_helpInits, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if ("));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp2);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_elseWhen);
      then (txt, a_preExp, a_helpInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_helpInits,
           a_varDecls )
      then (txt, a_preExp, a_helpInits, a_varDecls);
  end matchcontinue;
end equationElseWhen;

protected function lm_272
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_272(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_272(txt, rest);
      then txt;
  end matchcontinue;
end lm_272;

public function simulationFunctionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_functions.h\"\n",
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_272(out_txt, a_literals);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodies(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
end simulationFunctionsFile;

protected function lm_274
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclaration(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_274(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_274(txt, rest);
      then txt;
  end matchcontinue;
end lm_274;

public function recordsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.RecordDeclaration> a_recordDecls;

  output Tpl.Text out_txt;
protected
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/* Additional record code for "));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
  ret_0 := Settings.getVersionNr();
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ". */\n",
                                       "#include \"meta_modelica.h\"\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_274(out_txt, a_recordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end recordsFile;

protected function lm_276
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclarationHeader(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_276(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_276(txt, rest);
      then txt;
  end matchcontinue;
end lm_276;

public function simulationFunctionsHeaderFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<SimCode.RecordDeclaration> a_recordDecls;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_0 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__H\n"));
  out_txt := commonHeader(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#include \"simulation_runtime.h\"\n",
                                       "#include <stdio.h>\n",
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_276(out_txt, a_recordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionHeaders(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end simulationFunctionsHeaderFile;

protected function fun_278
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end matchcontinue;
end fun_278;

protected function lm_279
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_279(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_279(txt, rest);
      then txt;
  end matchcontinue;
end lm_279;

protected function fun_280
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_280;

protected function fun_281
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end matchcontinue;
end fun_281;

protected function fun_282
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end matchcontinue;
end fun_282;

protected function fun_283
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_283;

protected function fun_284
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_282(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_283(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_284;

protected function fun_285
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-O3"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-O0"));
      then txt;
  end matchcontinue;
end fun_285;

protected function fun_286
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_286;

protected function lm_287
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_287(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_287(txt, rest);
      then txt;
  end matchcontinue;
end lm_287;

protected function fun_288
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end matchcontinue;
end fun_288;

protected function fun_289
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end matchcontinue;
end fun_289;

protected function fun_290
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "OSX" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lf2c"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-Bstatic -lf2c -Wl,-Bdynamic"));
      then txt;
  end matchcontinue;
end fun_290;

public function simulationMakefile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      String i_makefileParams_senddatalibs;
      String i_makefileParams_ldflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      String i_makefileParams_cflags;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      String ret_9;
      Boolean ret_8;
      Boolean ret_7;
      Boolean ret_6;
      Tpl.Text l_optimizationLevel;
      Tpl.Text l_extraCflags;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, cflags = i_makefileParams_cflags, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes, ldflags = i_makefileParams_ldflags, senddatalibs = i_makefileParams_senddatalibs), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_278(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_279(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_280(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_281(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_extraCflags = fun_284(Tpl.emptyTxt, i_sopt);
        ret_6 = Config.getRunningTestsuite();
        l_optimizationLevel = fun_285(Tpl.emptyTxt, ret_6);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default if not running the testsuite when is -O0\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL="
                                }, false));
        txt = Tpl.writeText(txt, l_optimizationLevel);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CC="));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_286(txt, i_sopt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CPPFLAGS=-I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" -I. "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_287(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS=-L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -lSimulationRuntimeC "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SENDDATALIBS="));
        txt = Tpl.writeStr(txt, i_makefileParams_senddatalibs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "MAINFILE="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        ret_7 = Config.acceptMetaModelicaGrammar();
        txt = fun_288(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "MAINOBJ="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        ret_8 = Config.acceptMetaModelicaGrammar();
        txt = fun_289(txt, ret_8);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".o\n",
                                    "\n",
                                    ".PHONY: clean "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": clean $(MAINOBJ) "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.o\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CXX) -I. -o "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(EXEEXT) $(MAINOBJ) "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o $(CPPFLAGS) "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS) -linteractive $(SENDDATALIBS) "));
        ret_9 = System.os();
        txt = fun_290(txt, ret_9);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv.c: "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(PERL) "));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/share/omc/scripts/convert_lines.pl $< $@.tmp\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " @mv $@.tmp $@\n",
                                    "$(MAINOBJ): $(MAINFILE) "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\n",
                                    "clean:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" @rm -f "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o $(MAINOBJ)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationMakefile;

public function xsdateTime
  input Tpl.Text in_txt;
  input Util.DateTime in_a_dt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dt)
    local
      Tpl.Text txt;
      Integer i_sec;
      Integer i_min;
      Integer i_hour;
      Integer i_mday;
      Integer i_mon;
      Integer i_year;
      String ret_4;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           Util.DATETIME(year = i_year, mon = i_mon, mday = i_mday, hour = i_hour, min = i_min, sec = i_sec) )
      equation
        txt = Tpl.writeStr(txt, intString(i_year));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_0 = SimCode.twodigit(i_mon);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_1 = SimCode.twodigit(i_mday);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("T"));
        ret_2 = SimCode.twodigit(i_hour);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_3 = SimCode.twodigit(i_min);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_4 = SimCode.twodigit(i_sec);
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Z"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end xsdateTime;

public function simulationInitFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.ModelInfo i_modelInfo;
      String i_s_variableFilter;
      String i_s_outputFormat;
      String i_s_method;
      Real i_s_tolerance;
      Real i_s_stepSize;
      Real i_s_stopTime;
      Real i_s_startTime;
      Integer i_vi_numBoolParams;
      Integer i_vi_numBoolAliasVars;
      Integer i_vi_numBoolAlgVars;
      Integer i_vi_numStringParamVars;
      Integer i_vi_numStringAliasVars;
      Integer i_vi_numStringAlgVars;
      Integer i_vi_numIntParams;
      Integer i_vi_numIntAliasVars;
      Integer i_vi_numIntAlgVars;
      Integer i_vi_numParams;
      Integer i_vi_numAlgAliasVars;
      Integer i_vi_numAlgVars;
      Integer i_vi_numStateVars;
      Integer i_vi_numJacobianVars;
      list<SimCode.Function> i_functions;
      Integer i_vi_numExternalObjects;
      Integer i_vi_numResiduals;
      Integer i_vi_numOutVars;
      Integer i_vi_numInVars;
      Integer i_vi_numTimeEvents;
      Integer i_vi_numZeroCrossings;
      Integer i_vi_numHelpVars;
      Absyn.Path i_modelInfo_name;
      Integer ret_2;
      Util.DateTime ret_1;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(functions = i_functions, varInfo = SimCode.VARINFO(numHelpVars = i_vi_numHelpVars, numZeroCrossings = i_vi_numZeroCrossings, numTimeEvents = i_vi_numTimeEvents, numInVars = i_vi_numInVars, numOutVars = i_vi_numOutVars, numResiduals = i_vi_numResiduals, numExternalObjects = i_vi_numExternalObjects, numJacobianVars = i_vi_numJacobianVars, numStateVars = i_vi_numStateVars, numAlgVars = i_vi_numAlgVars, numAlgAliasVars = i_vi_numAlgAliasVars, numParams = i_vi_numParams, numIntAlgVars = i_vi_numIntAlgVars, numIntAliasVars = i_vi_numIntAliasVars, numIntParams = i_vi_numIntParams, numStringAlgVars = i_vi_numStringAlgVars, numStringAliasVars = i_vi_numStringAliasVars, numStringParamVars = i_vi_numStringParamVars, numBoolAlgVars = i_vi_numBoolAlgVars, numBoolAliasVars = i_vi_numBoolAliasVars, numBoolParams = i_vi_numBoolParams), vars = SimCode.SIMVARS(stateVars = _), name = i_modelInfo_name)), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_s_startTime, stopTime = i_s_stopTime, stepSize = i_s_stepSize, tolerance = i_s_tolerance, method = i_s_method, outputFormat = i_s_outputFormat, variableFilter = i_s_variableFilter))),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<?xml version = \"1.0\" encoding=\"UTF-8\"?>\n",
                                    "\n",
                                    "<!-- description of the model interface using an extention of the FMI standard -->\n",
                                    "<fmiModelDescription\n",
                                    "  fmiVersion                          = \"1.0\"\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelName                           = \""));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelIdentifier                     = \""
                                }, false));
        txt = underscorePath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "guid                                = \"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "\n",
                                    "generationTool                      = \"OpenModelica Compiler "
                                }, false));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationDateAndTime               = \""
                                }, false));
        ret_1 = Util.getCurrentDateTime();
        txt = xsdateTime(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "variableNamingConvention            = \"structured\"\n",
                                    "\n",
                                    "numberOfHelperVariables             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numHelpVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfHelperVariables             = \"NHELP:    number of helper variables,                         OMC\"\n",
                                    "numberOfEventIndicators             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfEventIndicators             = \"NG:       number of zero crossings,                           FMI\"\n",
                                    "numberOfTimeEvents                  = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfTimeEvents                  = \"NG_SAM:   number of zero crossings that are samples,          OMC\"\n",
                                    "\n",
                                    "numberOfInputVariables              = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfInputVariables              = \"NI:       number of inputvar on topmodel,                     OMC\"\n",
                                    "numberOfOutputVariables             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfOutputVariables             = \"NO:       number of outputvar on topmodel,                    OMC\"\n",
                                    "\n",
                                    "numberOfResidualsForInitialization  = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfResidualsForInitialization  = \"NR:       number of residuals for initialialization function, OMC\"\n",
                                    "numberOfExternalObjects             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfExternalObjects             = \"NEXT:     number of external objects,                         OMC\"\n",
                                    "numberOfFunctions                   = \""
                                }, false));
        ret_2 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfFunctions                   = \"NFUNC:    number of functions used by the simulation,         OMC\"\n",
                                    "numberOfJacobianVariables           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numJacobianVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfJacobianVariables           = \"NJACVARS: number of jacobian variables,                       OMC\"\n",
                                    "\n",
                                    "numberOfContinuousStates            = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfContinuousStates            = \"NX:       number of states,                                   FMI\"\n",
                                    "numberOfRealAlgebraicVariables      = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealAlgebraicVariables      = \"NY:       number of real variables,                           OMC\"\n",
                                    "numberOfRealAlgebraicAliasVariables = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealAlgebraicAliasVariables = \"NA:       number of alias variables,                          OMC\"\n",
                                    "numberOfRealParameters              = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealParameters              = \"NP:       number of parameters,                               OMC\"\n",
                                    "\n",
                                    "numberOfIntegerAlgebraicVariables   = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerAlgebraicVariables   = \"NYINT:    number of alg. int variables,                       OMC\"\n",
                                    "numberOfIntegerAliasVariables       = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerAliasVariables       = \"NAINT:    number of alias int variables,                      OMC\"\n",
                                    "numberOfIntegerParameters           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerParameters           = \"NPINT:    number of int parameters,                           OMC\"\n",
                                    "\n",
                                    "numberOfStringAlgebraicVariables    = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringAlgebraicVariables    = \"NYSTR:    number of alg. string variables,                    OMC\"\n",
                                    "numberOfStringAliasVariables        = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringAliasVariables        = \"NASTR:    number of alias string variables,                   OMC\"\n",
                                    "numberOfStringParameters            = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringParameters            = \"NPSTR:    number of string parameters,                        OMC\"\n",
                                    "\n",
                                    "numberOfBooleanAlgebraicVariables   = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanAlgebraicVariables   = \"NYBOOL:   number of alg. bool variables,                      OMC\"\n",
                                    "numberOfBooleanAliasVariables       = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanAliasVariables       = \"NABOOL:   number of alias bool variables,                     OMC\"\n",
                                    "numberOfBooleanParameters           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanParameters           = \"NPBOOL:   number of bool parameters,                          OMC\" >\n",
                                    "\n",
                                    "\n",
                                    "<!-- startTime, stopTime, tolerance are FMI specific, all others are OMC specific -->\n",
                                    "<DefaultExperiment\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("startTime      = \""));
        txt = Tpl.writeStr(txt, realString(i_s_startTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "stopTime       = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "stepSize       = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_stepSize));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "tolerance      = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_tolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "solver         = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_method);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "outputFormat   = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "variableFilter = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_variableFilter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" />\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<!-- variables in the model -->\n"));
        txt = ModelVariables(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</fmiModelDescription>\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end simulationInitFile;

protected function fun_294
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v) )
      equation
        txt = initVal(txt, i_v);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0.0 //default"));
      then txt;
  end matchcontinue;
end fun_294;

protected function lm_295
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_initialValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(initialValue = i_initialValue, name = i_name) :: rest )
      equation
        txt = fun_294(txt, i_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" //"));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_295(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_295(txt, rest);
      then txt;
  end matchcontinue;
end lm_295;

public function initVals
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_295(out_txt, a_varsLst);
  out_txt := Tpl.popIter(out_txt);
end initVals;

protected function fun_297
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end matchcontinue;
end fun_297;

public function initVal
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_initialValue;
      Absyn.Path i_name;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      Tpl.Text txt_1;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        ret_0 = Util.escapeModelicaStringToCString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_297(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*ENUM:"));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           i_initialValue )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("initial value of unknown type: "));
        ret_1 = ExpressionDump.printExpStr(i_initialValue);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 2262, 14), Tpl.textString(txt_1));
      then txt;
  end matchcontinue;
end initVal;

protected function fun_299
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end matchcontinue;
end fun_299;

public function initValXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_initialValue;
      Absyn.Path i_name;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      Tpl.Text txt_1;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        ret_0 = Util.escapeModelicaStringToXmlString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_299(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*ENUM:"));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           i_initialValue )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("initial value of unknown type: "));
        ret_1 = ExpressionDump.printExpStr(i_initialValue);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 2273, 14), Tpl.textString(txt_1));
      then txt;
  end matchcontinue;
end initValXml;

protected function fun_301
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define __OPENMODELICA__METAMODELICA"));
      then txt;
  end matchcontinue;
end fun_301;

protected function fun_302
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define omp_get_thread_num() 0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include <omp.h>"));
      then txt;
  end matchcontinue;
end fun_302;

public function commonHeader
  input Tpl.Text txt;

  output Tpl.Text out_txt;
protected
  Boolean ret_1;
  Boolean ret_0;
algorithm
  ret_0 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_301(txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  ret_1 := Flags.isSet(Flags.OPENMP);
  out_txt := fun_302(out_txt, ret_1);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#include \"modelica.h\"\n",
                                       "#include <stdio.h>\n",
                                       "#include <stdlib.h>\n",
                                       "#include <errno.h>"
                                   }, false));
end commonHeader;

protected function lm_304
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_304(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_304(txt, rest);
      then txt;
  end matchcontinue;
end lm_304;

protected function fun_305
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn) )
      equation
        txt = functionBody(txt, i_fn, true);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_305;

public function functionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ".h\"\n",
                                       "#define MODELICA_ASSERT(info,msg) { printInfo(stderr,info); fprintf(stderr,\"Modelica Assert: %s!\\n\", msg); }\n",
                                       "#define MODELICA_TERMINATE(msg) { fprintf(stderr,\"Modelica Terminate: %s!\\n\", msg); fflush(stderr); }\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_304(out_txt, a_literals);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := fun_305(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodies(out_txt, a_functions);
end functionsFile;

protected function lm_307
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclarationHeader(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_307(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_307(txt, rest);
      then txt;
  end matchcontinue;
end lm_307;

protected function fun_308
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn) )
      equation
        txt = functionHeader(txt, i_fn, true);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_308;

public function functionsHeaderFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;
  input list<SimCode.RecordDeclaration> a_extraRecordDecls;
  input list<String> a_includes;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_0 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__H\n"));
  out_txt := commonHeader(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_307(out_txt, a_extraRecordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := fun_308(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionHeaders(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := externalFunctionIncludes(out_txt, a_includes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "#endif\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end functionsHeaderFile;

protected function lm_310
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_310(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_310(txt, rest);
      then txt;
  end matchcontinue;
end lm_310;

protected function fun_311
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-O3"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-O0"));
      then txt;
  end matchcontinue;
end fun_311;

protected function lm_312
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_312(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_312(txt, rest);
      then txt;
  end matchcontinue;
end lm_312;

protected function fun_313
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end matchcontinue;
end fun_313;

public function functionsMakefile
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_fnCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fnCode)
    local
      Tpl.Text txt;
      String i_name;
      String i_makefileParams_senddatalibs;
      String i_makefileParams_ldflags;
      String i_makefileParams_cflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      list<String> i_makefileParams_libs;
      Boolean ret_3;
      Boolean ret_2;
      Tpl.Text l_optimizationLevel;
      Tpl.Text l_libsStr;

    case ( txt,
           SimCode.FUNCTIONCODE(makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes, cflags = i_makefileParams_cflags, ldflags = i_makefileParams_ldflags, senddatalibs = i_makefileParams_senddatalibs), name = i_name) )
      equation
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_310(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        ret_2 = Config.getRunningTestsuite();
        l_optimizationLevel = fun_311(Tpl.emptyTxt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Dynamic loading uses -O0 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL="
                                }, false));
        txt = Tpl.writeText(txt, l_optimizationLevel);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CC="));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS= -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_312(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS= -L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -lSimulationRuntimeC "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SENDDATALIBS="));
        txt = Tpl.writeStr(txt, i_makefileParams_senddatalibs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "MAINFILE="
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        ret_3 = Config.acceptMetaModelicaGrammar();
        txt = fun_313(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "\n",
                                    ".PHONY: "
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": $(MAINFILE) "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CC) $(CFLAGS) -c -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".o $(MAINFILE)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CC) $(CFLAGS) -c -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(LINK) -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o "));
        txt = Tpl.writeText(txt, l_libsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" $(CFLAGS) $(LDFLAGS) $(SENDDATALIBS) -lm\n"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv.c: "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(PERL) "));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/share/omc/scripts/convert_lines.pl $< $@.tmp\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" @mv $@.tmp $@"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionsMakefile;

protected function fun_315
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt_0 = crefStr(Tpl.emptyTxt, a_cr);
        ret_1 = System.unquoteIdentifier(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = cref(txt, a_cr);
      then txt;
  end matchcontinue;
end fun_315;

public function contextCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_315(txt, a_context, a_cr);
end contextCref;

protected function fun_317
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Absyn.Ident in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Ident a_name;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end matchcontinue;
end fun_317;

public function contextIteratorName
  input Tpl.Text txt;
  input Absyn.Ident a_name;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_317(txt, a_context, a_name);
end contextIteratorName;

public function cref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_cr);
      then txt;
  end matchcontinue;
end cref;

public function crefToCStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = subscriptsToCStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end crefToCStr;

protected function lm_321
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToCStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_321(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_321(txt, rest);
      then txt;
  end matchcontinue;
end lm_321;

public function subscriptsToCStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$lB"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("$c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_321(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$rB"));
      then txt;
  end matchcontinue;
end subscriptsToCStr;

public function subscriptToCStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end matchcontinue;
end subscriptToCStr;

public function crefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = crefStr(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end crefStr;

public function crefM
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("P"));
        txt = crefToMStr(txt, i_cr);
      then txt;
  end matchcontinue;
end crefM;

public function crefToMStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = subscriptsToMStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToMStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("P"));
        txt = crefToMStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end crefToMStr;

protected function lm_327
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToMStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_327(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_327(txt, rest);
      then txt;
  end matchcontinue;
end lm_327;

public function subscriptsToMStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("lB"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_327(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rB"));
      then txt;
  end matchcontinue;
end subscriptsToMStr;

protected function fun_329
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end matchcontinue;
end fun_329;

public function subscriptToMStr
  input Tpl.Text txt;
  input DAE.Subscript a_subscript;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDecls;
  Tpl.Text l_preExp;
algorithm
  l_preExp := Tpl.emptyTxt;
  l_varDecls := Tpl.emptyTxt;
  out_txt := fun_329(txt, a_subscript);
end subscriptToMStr;

protected function fun_331
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = arrayCrefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = arrayCrefCStr(txt, a_cr);
      then txt;
  end matchcontinue;
end fun_331;

public function contextArrayCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_331(txt, a_context, a_cr);
end contextArrayCref;

public function arrayCrefCStr
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
  out_txt := arrayCrefCStr2(out_txt, a_cr);
end arrayCrefCStr;

public function arrayCrefCStr2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = arrayCrefCStr2(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end arrayCrefCStr2;

public function arrayCrefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = arrayCrefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end arrayCrefStr;

protected function lm_336
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_336(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_336(txt, rest);
      then txt;
  end matchcontinue;
end lm_336;

public function subscriptsStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_336(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end matchcontinue;
end subscriptsStr;

public function subscriptStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end matchcontinue;
end subscriptStr;

public function expCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_arg_componentRef;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.CREF(componentRef = i_componentRef) )
      equation
        txt = cref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$DER"));
        txt = cref(txt, i_arg_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ERROR_NOT_A_CREF"));
      then txt;
  end matchcontinue;
end expCref;

public function crefFunctionName
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        ret_1 = System.stringReplace(ret_0, "_", "__");
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_2 = System.unquoteIdentifier(i_ident);
        ret_3 = System.stringReplace(ret_2, "_", "__");
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefFunctionName(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end crefFunctionName;

public function dotPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dotPath;

public function replaceDotAndUnderscore
  input Tpl.Text in_txt;
  input String in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_str)
    local
      Tpl.Text txt;
      String i_name;
      String ret_4;
      String ret_3;
      Tpl.Text l_str__underscores;
      String ret_1;
      Tpl.Text l_str__dots;

    case ( txt,
           i_name )
      equation
        ret_1 = System.stringReplace(i_name, ".", "_");
        l_str__dots = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = System.stringReplace(Tpl.textString(l_str__dots), "_", "__");
        l_str__underscores = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        ret_4 = System.unquoteIdentifier(Tpl.textString(l_str__underscores));
        txt = Tpl.writeStr(txt, ret_4);
      then txt;
  end matchcontinue;
end replaceDotAndUnderscore;

public function underscorePath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end underscorePath;

protected function lm_344
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_344(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_344(txt, rest);
      then txt;
  end matchcontinue;
end lm_344;

public function externalFunctionIncludes
  input Tpl.Text in_txt;
  input list<String> in_a_includes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_includes)
    local
      Tpl.Text txt;
      list<String> i_includes;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_includes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_344(txt, i_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif"
                                }, false));
      then txt;
  end matchcontinue;
end externalFunctionIncludes;

protected function lm_346
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = functionHeader(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_346(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_346(txt, rest);
      then txt;
  end matchcontinue;
end lm_346;

public function functionHeaders
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_346(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end functionHeaders;

protected function lm_348
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) :: rest )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_348(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_348(txt, rest);
      then txt;
  end matchcontinue;
end lm_348;

protected function lm_349
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgBoxedDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_349(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_349(txt, rest);
      then txt;
  end matchcontinue;
end lm_349;

protected function fun_350
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Variable> in_a_funArgs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_funArgs)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_funArgs;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_funArgs )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_349(txt, a_funArgs);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_350;

protected function fun_351
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_funArgsBoxedStr;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_funArgsBoxedStr, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_funArgsBoxedStr;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_funArgsBoxedStr,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype boxptr_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_funArgsBoxedStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end matchcontinue;
end fun_351;

public function functionHeader
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_fn;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      Boolean ret_14;
      Tpl.Text l_boxedHeader;
      Boolean ret_12;
      Tpl.Text l_funArgsBoxedStr;
      Tpl.Text l_funArgsStr;
      Tpl.Text l_fname;
      Boolean ret_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Boolean ret_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars)),
           a_inFunc )
      equation
        txt_0 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderNormal(txt, Tpl.textString(txt_0), i_functionArguments, i_outVars, a_inFunc, false);
        txt = Tpl.softNewLine(txt);
        txt_1 = underscorePath(Tpl.emptyTxt, i_name);
        ret_2 = SimCode.isBoxedFunction(i_fn);
        txt = functionHeaderBoxed(txt, Tpl.textString(txt_1), i_functionArguments, i_outVars, ret_2, false);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, name = i_name, funArgs = i_funArgs, outVars = i_outVars)),
           a_inFunc )
      equation
        txt_3 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderNormal(txt, Tpl.textString(txt_3), i_funArgs, i_outVars, a_inFunc, true);
        txt = Tpl.softNewLine(txt);
        txt_4 = underscorePath(Tpl.emptyTxt, i_name);
        ret_5 = SimCode.isBoxedFunction(i_fn);
        txt = functionHeaderBoxed(txt, Tpl.textString(txt_4), i_funArgs, i_outVars, ret_5, true);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = extFunDefDynamic(txt, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name, funArgs = i_funArgs, outVars = i_outVars)),
           a_inFunc )
      equation
        txt_6 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderNormal(txt, Tpl.textString(txt_6), i_funArgs, i_outVars, a_inFunc, false);
        txt = Tpl.softNewLine(txt);
        txt_7 = underscorePath(Tpl.emptyTxt, i_name);
        ret_8 = SimCode.isBoxedFunction(i_fn);
        txt = functionHeaderBoxed(txt, Tpl.textString(txt_7), i_funArgs, i_outVars, ret_8, false);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = extFunDef(txt, i_fn);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs),
           _ )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_funArgsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funArgsStr = lm_348(l_funArgsStr, i_funArgs);
        l_funArgsStr = Tpl.popIter(l_funArgsStr);
        ret_12 = Config.acceptMetaModelicaGrammar();
        l_funArgsBoxedStr = fun_350(Tpl.emptyTxt, ret_12, i_funArgs);
        ret_14 = Config.acceptMetaModelicaGrammar();
        l_boxedHeader = fun_351(Tpl.emptyTxt, ret_14, l_funArgsBoxedStr, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype_1 targ1\n",
                                    "typedef struct "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_rettype_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" targ1;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_funArgsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_boxedHeader);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionHeader;

protected function lm_353
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_353(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_353(txt, rest);
      then txt;
  end matchcontinue;
end lm_353;

protected function lm_354
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_354(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_354(txt, rest);
      then txt;
  end matchcontinue;
end lm_354;

public function recordDeclaration
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_recDecl)
    local
      Tpl.Text txt;
      list<String> i_fieldNames;
      Absyn.Path i_path;
      list<SimCode.Variable> i_variables;
      Absyn.Path i_defPath;
      Integer ret_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Integer ret_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.RECORD_DECL_FULL(defPath = i_defPath, variables = i_variables) )
      equation
        txt_0 = dotPath(Tpl.emptyTxt, i_defPath);
        txt_1 = underscorePath(Tpl.emptyTxt, i_defPath);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_353(txt_2, i_variables);
        txt_2 = Tpl.popIter(txt_2);
        ret_3 = listLength(i_variables);
        txt = recordDefinition(txt, Tpl.textString(txt_0), Tpl.textString(txt_1), Tpl.textString(txt_2), ret_3);
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = i_path, fieldNames = i_fieldNames) )
      equation
        txt_4 = dotPath(Tpl.emptyTxt, i_path);
        txt_5 = underscorePath(Tpl.emptyTxt, i_path);
        txt_6 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_6 = lm_354(txt_6, i_fieldNames);
        txt_6 = Tpl.popIter(txt_6);
        ret_7 = listLength(i_fieldNames);
        txt = recordDefinition(txt, Tpl.textString(txt_4), Tpl.textString(txt_5), Tpl.textString(txt_6), ret_7);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end recordDeclaration;

protected function lm_356
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name)) :: rest )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_356(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_356(txt, rest);
      then txt;
  end matchcontinue;
end lm_356;

public function recordDeclarationHeader
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_recDecl)
    local
      Tpl.Text txt;
      list<String> i_fieldNames;
      Absyn.Path i_path;
      Absyn.Path i_defPath;
      list<SimCode.Variable> i_variables;
      String i_name;
      Integer ret_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Integer ret_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.RECORD_DECL_FULL(name = i_name, variables = i_variables, defPath = i_defPath) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_356(txt, i_variables);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt_0 = dotPath(Tpl.emptyTxt, i_defPath);
        txt_1 = underscorePath(Tpl.emptyTxt, i_defPath);
        ret_2 = listLength(i_variables);
        txt = recordDefinitionHeader(txt, Tpl.textString(txt_0), Tpl.textString(txt_1), ret_2);
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = i_path, fieldNames = i_fieldNames) )
      equation
        txt_3 = dotPath(Tpl.emptyTxt, i_path);
        txt_4 = underscorePath(Tpl.emptyTxt, i_path);
        ret_5 = listLength(i_fieldNames);
        txt = recordDefinitionHeader(txt, Tpl.textString(txt_3), Tpl.textString(txt_4), ret_5);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end recordDeclarationHeader;

protected function fun_358
  input Tpl.Text in_txt;
  input Integer in_a_numFields;
  input String in_a_fieldNames;
  input String in_a_encName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_numFields, in_a_fieldNames, in_a_encName)
    local
      Tpl.Text txt;
      String a_fieldNames;
      String a_encName;
      Integer i_numFields;

    case ( txt,
           0,
           _,
           a_encName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char* "));
        txt = Tpl.writeStr(txt, a_encName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc__fields[1] = {\"no fileds\"};"));
      then txt;

    case ( txt,
           i_numFields,
           a_fieldNames,
           a_encName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char* "));
        txt = Tpl.writeStr(txt, a_encName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc__fields["));
        txt = Tpl.writeStr(txt, intString(i_numFields));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.writeStr(txt, a_fieldNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end matchcontinue;
end fun_358;

public function recordDefinition
  input Tpl.Text txt;
  input String a_origName;
  input String a_encName;
  input String a_fieldNames;
  input Integer a_numFields;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fieldsDescription;
algorithm
  l_fieldsDescription := fun_358(Tpl.emptyTxt, a_numFields, a_fieldNames, a_encName);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc_added 1\n"));
  out_txt := Tpl.writeText(out_txt, l_fieldsDescription);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("struct record_description "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc = {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\", /* package_record__X */\n",
                                       "\""
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_origName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("\", /* package.record_X */\n"));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc__fields\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("};"));
end recordDefinition;

public function recordDefinitionHeader
  input Tpl.Text txt;
  input String a_origName;
  input String a_encName;
  input Integer a_numFields;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("extern struct record_description "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("__desc;"));
end recordDefinitionHeader;

public function functionHeaderNormal
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input Boolean a_dynamicLoad;

  output Tpl.Text out_txt;
algorithm
  out_txt := functionHeaderImpl(txt, a_fname, a_fargs, a_outVars, a_inFunc, false, a_dynamicLoad);
end functionHeaderNormal;

protected function fun_362
  input Tpl.Text in_txt;
  input Boolean in_a_isBoxed;
  input Boolean in_a_dynamicLoad;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_fargs;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isBoxed, in_a_dynamicLoad, in_a_outVars, in_a_fargs, in_a_fname)
    local
      Tpl.Text txt;
      Boolean a_dynamicLoad;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_fargs;
      String a_fname;

    case ( txt,
           false,
           a_dynamicLoad,
           a_outVars,
           a_fargs,
           a_fname )
      equation
        txt = functionHeaderImpl(txt, a_fname, a_fargs, a_outVars, false, true, a_dynamicLoad);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define boxptr_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_362;

protected function fun_363
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fname;
  input list<SimCode.Variable> in_a_fargs;
  input list<SimCode.Variable> in_a_outVars;
  input Boolean in_a_isBoxed;
  input Boolean in_a_dynamicLoad;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fname, in_a_fargs, in_a_outVars, in_a_isBoxed, in_a_dynamicLoad)
    local
      Tpl.Text txt;
      String a_fname;
      list<SimCode.Variable> a_fargs;
      list<SimCode.Variable> a_outVars;
      Boolean a_isBoxed;
      Boolean a_dynamicLoad;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname,
           a_fargs,
           a_outVars,
           a_isBoxed,
           a_dynamicLoad )
      equation
        txt = fun_362(txt, a_isBoxed, a_dynamicLoad, a_outVars, a_fargs, a_fname);
      then txt;
  end matchcontinue;
end fun_363;

public function functionHeaderBoxed
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_isBoxed;
  input Boolean a_dynamicLoad;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_363(txt, ret_0, a_fname, a_fargs, a_outVars, a_isBoxed, a_dynamicLoad);
end functionHeaderBoxed;

protected function lm_365
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_365(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_365(txt, rest);
      then txt;
  end matchcontinue;
end lm_365;

protected function lm_366
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgBoxedDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_366(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_366(txt, rest);
      then txt;
  end matchcontinue;
end lm_366;

protected function fun_367
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input list<SimCode.Variable> in_a_fargs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed, in_a_fargs)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_fargs;

    case ( txt,
           false,
           a_fargs )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_365(txt, a_fargs);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           a_fargs )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_366(txt, a_fargs);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_367;

protected function fun_368
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxed"));
      then txt;
  end matchcontinue;
end fun_368;

protected function fun_369
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxptr"));
      then txt;
  end matchcontinue;
end fun_369;

protected function fun_370
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inFunc, in_a_fname)
    local
      Tpl.Text txt;
      String a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "DLLExport\n",
                                    "int in_"
                                }, false));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(type_description * inArgs, type_description * outVar);"));
      then txt;
  end matchcontinue;
end fun_370;

protected function fun_371
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input String in_a_fname;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed, in_a_fname, in_a_inFunc)
    local
      Tpl.Text txt;
      String a_fname;
      Boolean a_inFunc;

    case ( txt,
           false,
           a_fname,
           a_inFunc )
      equation
        txt = fun_370(txt, a_inFunc, a_fname);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_371;

protected function fun_372
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_fargsStr;
  input String in_a_fname;
  input Tpl.Text in_a_boxPtrStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_fargsStr, in_a_fname, in_a_boxPtrStr)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      String a_fname;
      Tpl.Text a_boxPtrStr;

    case ( txt,
           false,
           a_fargsStr,
           a_fname,
           a_boxPtrStr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_boxPtrStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_372;

protected function lm_373
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_boxStr;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_boxStr, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_boxStr;
      String a_fname;
      Integer x_i1;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_boxStr,
           a_fname )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targ"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_373(txt, rest, a_boxStr, a_fname);
      then txt;

    case ( txt,
           _ :: rest,
           a_boxStr,
           a_fname )
      equation
        txt = lm_373(txt, rest, a_boxStr, a_fname);
      then txt;
  end matchcontinue;
end lm_373;

protected function lm_374
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_374(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_374(txt, rest);
      then txt;
  end matchcontinue;
end lm_374;

protected function fun_375
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      list<DAE.Dimension> i_arrayDimensions;

    case ( txt,
           DAE.ET_ARRAY(arrayDimensions = i_arrayDimensions) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_374(txt, i_arrayDimensions);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_375;

protected function fun_376
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;

    case ( txt,
           false,
           a_var )
      equation
        txt = varType(txt, a_var);
      then txt;

    case ( txt,
           _,
           a_var )
      equation
        txt = varTypeBoxed(txt, a_var);
      then txt;
  end matchcontinue;
end fun_376;

protected function fun_377
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_i1;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_i1, in_a_boxed)
    local
      Tpl.Text txt;
      Integer a_i1;
      Boolean a_boxed;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;
      DAE.ExpType i_ty;
      Tpl.Text l_typeStr;
      Tpl.Text l_dimStr;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_name)),
           a_i1,
           a_boxed )
      equation
        l_dimStr = fun_375(Tpl.emptyTxt, i_ty);
        l_typeStr = fun_376(Tpl.emptyTxt, a_boxed, i_var);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targ"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeText(txt, l_dimStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_i1,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr targ"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = Tpl.writeStr(txt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_377;

protected function lm_378
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_boxed)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_boxed;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_boxed )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_377(txt, i_var, x_i1, a_boxed);
        txt = Tpl.nextIter(txt);
        txt = lm_378(txt, rest, a_boxed);
      then txt;

    case ( txt,
           _ :: rest,
           a_boxed )
      equation
        txt = lm_378(txt, rest, a_boxed);
      then txt;
  end matchcontinue;
end lm_378;

protected function fun_379
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_fargsStr;
  input Tpl.Text in_a_boxPtrStr;
  input Tpl.Text in_a_boxStr;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_fargsStr, in_a_boxPtrStr, in_a_boxStr, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      Tpl.Text a_boxPtrStr;
      Tpl.Text a_boxStr;
      String a_fname;

    case ( txt,
           false,
           a_fargsStr,
           a_boxPtrStr,
           a_boxStr,
           a_fname )
      equation
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_boxPtrStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_379;

protected function fun_380
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_inFnStr;
  input Boolean in_a_boxed;
  input Tpl.Text in_a_boxStr;
  input Tpl.Text in_a_fargsStr;
  input String in_a_fname;
  input Tpl.Text in_a_boxPtrStr;
  input Boolean in_a_dynamicLoad;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_inFnStr, in_a_boxed, in_a_boxStr, in_a_fargsStr, in_a_fname, in_a_boxPtrStr, in_a_dynamicLoad)
    local
      Tpl.Text txt;
      Tpl.Text a_inFnStr;
      Boolean a_boxed;
      Tpl.Text a_boxStr;
      Tpl.Text a_fargsStr;
      String a_fname;
      Tpl.Text a_boxPtrStr;
      Boolean a_dynamicLoad;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {},
           _,
           _,
           _,
           a_fargsStr,
           a_fname,
           a_boxPtrStr,
           a_dynamicLoad )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_372(txt, a_dynamicLoad, a_fargsStr, a_fname, a_boxPtrStr);
      then txt;

    case ( txt,
           i_outVars,
           a_inFnStr,
           a_boxed,
           a_boxStr,
           a_fargsStr,
           a_fname,
           a_boxPtrStr,
           a_dynamicLoad )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_373(txt, i_outVars, a_boxStr, a_fname);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_s\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_378(txt, i_outVars, a_boxed);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_inFnStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_379(txt, a_dynamicLoad, a_fargsStr, a_boxPtrStr, a_boxStr, a_fname);
      then txt;
  end matchcontinue;
end fun_380;

public function functionHeaderImpl
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input Boolean a_boxed;
  input Boolean a_dynamicLoad;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_inFnStr;
  Tpl.Text l_boxPtrStr;
  Tpl.Text l_boxStr;
  Tpl.Text l_fargsStr;
algorithm
  l_fargsStr := fun_367(Tpl.emptyTxt, a_boxed, a_fargs);
  l_boxStr := fun_368(Tpl.emptyTxt, a_boxed);
  l_boxPtrStr := fun_369(Tpl.emptyTxt, a_boxed);
  l_inFnStr := fun_371(Tpl.emptyTxt, a_boxed, a_fname, a_inFunc);
  out_txt := fun_380(txt, a_outVars, l_inFnStr, a_boxed, l_boxStr, l_fargsStr, a_fname, l_boxPtrStr, a_dynamicLoad);
end functionHeaderImpl;

public function funArgName
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name) )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end funArgName;

public function funArgDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end funArgDefinition;

public function funArgBoxedDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end funArgBoxedDefinition;

public function extFunDef
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.SimExtArg> i_extArgs;
      String i_language;
      String i_extName;
      Tpl.Text l_fargsStr;
      Tpl.Text l_fn__name;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extName = i_extName, language = i_language, extArgs = i_extArgs, extReturn = i_extReturn) )
      equation
        l_fn__name = extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern "));
        txt = extReturnType(txt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDef;

public function extFunDefDynamic
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.SimExtArg> i_extArgs;
      String i_language;
      String i_extName;
      Tpl.Text l_fargsStr;
      Tpl.Text l_fn__name;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extName = i_extName, language = i_language, extArgs = i_extArgs, extReturn = i_extReturn) )
      equation
        l_fn__name = extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef "));
        txt = extReturnType(txt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" (*ptrT_"));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, l_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "extern ptrT_"
                                }, false));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDefDynamic;

protected function fun_387
  input Tpl.Text in_txt;
  input String in_a_language;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_language, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           "FORTRAN 77",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 2812, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_387;

public function extFunctionName
  input Tpl.Text txt;
  input String a_name;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_387(txt, a_language, a_name);
end extFunctionName;

protected function lm_389
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_389(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_389(txt, rest);
      then txt;
  end matchcontinue;
end lm_389;

protected function lm_390
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArgF77(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_390(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_390(txt, rest);
      then txt;
  end matchcontinue;
end lm_390;

protected function fun_391
  input Tpl.Text in_txt;
  input String in_a_language;
  input list<SimCode.SimExtArg> in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_language, in_a_args)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> a_args;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_389(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           "FORTRAN 77",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_390(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 2820, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_391;

public function extFunDefArgs
  input Tpl.Text txt;
  input list<SimCode.SimExtArg> a_args;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_391(txt, a_language, a_args);
end extFunDefArgs;

public function extReturnType
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.ExpType i_type__;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           SimCode.SIMEXTARG(type_ = i_type__) )
      equation
        txt = extType(txt, i_type__, true, false);
      then txt;

    case ( txt,
           SimCode.SIMNOEXTARG() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp) )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Expression types are unsupported as return arguments "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 2829, 36), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 2830, 14), "Unsupported return argument");
      then txt;
  end matchcontinue;
end extReturnType;

protected function fun_394
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;
  input Boolean in_a_isInput;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_isInput)
    local
      Tpl.Text txt;
      Boolean a_isInput;
      DAE.ExpType i_type;
      Absyn.Path i_rname;
      DAE.ExpType i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ET_INT(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.ET_REAL(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.ET_STRING(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char*"));
      then txt;

    case ( txt,
           DAE.ET_BOOL(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.ET_ENUMERATION(path = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = i_ty),
           a_isInput )
      equation
        txt = extType(txt, i_ty, a_isInput, true);
      then txt;

    case ( txt,
           DAE.ET_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void *"));
      then txt;

    case ( txt,
           DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.ET_METATYPE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.ET_BOXED(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           i_type,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external C type "));
        ret_0 = ExpressionDump.typeString(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 2849, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_394;

protected function fun_395
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "const char*" )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const "));
      then txt;
  end matchcontinue;
end fun_395;

protected function fun_396
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;
      String str_0;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        str_0 = Tpl.textString(a_s);
        txt = fun_395(txt, str_0);
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end matchcontinue;
end fun_396;

protected function fun_397
  input Tpl.Text in_txt;
  input Boolean in_a_isInput;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isInput, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Tpl.Text a_s;

    case ( txt,
           false,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_s )
      equation
        txt = fun_396(txt, a_isArray, a_s);
      then txt;
  end matchcontinue;
end fun_397;

protected function fun_398
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;
  input Boolean in_a_isArray;
  input Boolean in_a_isInput;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_isArray, in_a_isInput, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Boolean a_isInput;
      Tpl.Text a_s;

    case ( txt,
           DAE.ET_ARRAY(ty = _),
           _,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_isInput,
           a_s )
      equation
        txt = fun_397(txt, a_isInput, a_isArray, a_s);
      then txt;
  end matchcontinue;
end fun_398;

public function extType
  input Tpl.Text txt;
  input DAE.ExpType a_type;
  input Boolean a_isInput;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_394(Tpl.emptyTxt, a_type, a_isInput);
  out_txt := fun_398(txt, a_type, a_isArray, a_isInput, l_s);
end extType;

protected function fun_400
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.ExpType i_type;
      Absyn.Path i_rname;
      DAE.ExpType i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.ET_REAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.ET_STRING() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("char"));
      then txt;

    case ( txt,
           DAE.ET_BOOL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.ET_ENUMERATION(path = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = i_ty) )
      equation
        txt = extTypeF77(txt, i_ty, true);
      then txt;

    case ( txt,
           DAE.ET_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.ET_METATYPE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.ET_BOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           i_type )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external F77 type "));
        ret_0 = ExpressionDump.typeString(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 2868, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_400;

protected function fun_401
  input Tpl.Text in_txt;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end matchcontinue;
end fun_401;

protected function fun_402
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isReference;
      Tpl.Text a_s;

    case ( txt,
           DAE.ET_ARRAY(ty = _),
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isReference,
           a_s )
      equation
        txt = fun_401(txt, a_isReference, a_s);
      then txt;
  end matchcontinue;
end fun_402;

public function extTypeF77
  input Tpl.Text txt;
  input DAE.ExpType a_type;
  input Boolean a_isReference;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_400(Tpl.emptyTxt, a_type);
  out_txt := fun_402(txt, a_type, a_isReference, l_s);
end extTypeF77;

public function extFunDefArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.ExpType i_type__;
      Boolean i_ia;
      Boolean i_ii;
      DAE.ExpType i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = i_ii, isArray = i_ia, type_ = i_t) )
      equation
        l_name = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_typeStr = extType(Tpl.emptyTxt, i_t, i_ii, i_ia);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__) )
      equation
        l_typeStr = extType(Tpl.emptyTxt, i_type__, true, false);
        txt = Tpl.writeText(txt, l_typeStr);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDefArg;

public function extFunDefArgF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.ExpType i_type__;
      DAE.ExpType i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, type_ = i_t) )
      equation
        l_name = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_typeStr = extTypeF77(Tpl.emptyTxt, i_t, true);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__) )
      equation
        txt = extTypeF77(txt, i_type__, true);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int *"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDefArgF77;

protected function fun_406
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = dotPath(txt, a_name);
      then txt;
  end matchcontinue;
end fun_406;

protected function fun_407
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = dotPath(txt, a_name);
      then txt;
  end matchcontinue;
end fun_407;

protected function fun_408
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = dotPath(txt, a_name);
      then txt;
  end matchcontinue;
end fun_408;

public function functionName
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_dotPath;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_dotPath)
    local
      Tpl.Text txt;
      Boolean a_dotPath;
      Absyn.Path i_name;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_406(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_407(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name),
           a_dotPath )
      equation
        txt = fun_408(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionName;

protected function lm_410
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = functionBody(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_410(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_410(txt, rest);
      then txt;
  end matchcontinue;
end lm_410;

public function functionBodies
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_410(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end functionBodies;

public function functionBody
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           _ )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionBody;

protected function fun_413
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_var_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;

    case ( txt,
           "modelica_metatype",
           a_var_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_413;

protected function fun_414
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;
  input SimCode.Variable in_a_var;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_var, in_a_var_name)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;
      DAE.ComponentRef a_var_name;
      String str_1;
      Tpl.Text l_typ;

    case ( txt,
           DAE.ET_METATYPE(),
           _,
           a_var_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;

    case ( txt,
           DAE.ET_BOXED(ty = _),
           _,
           a_var_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;

    case ( txt,
           _,
           a_var,
           a_var_name )
      equation
        l_typ = varType(Tpl.emptyTxt, a_var);
        str_1 = Tpl.textString(l_typ);
        txt = fun_413(txt, str_1, a_var_name);
      then txt;
  end matchcontinue;
end fun_414;

public function addRoots
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      DAE.ExpType i_ty;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_var_name)) )
      equation
        txt = fun_414(txt, i_ty, i_var, i_var_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end addRoots;

protected function fun_416
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end matchcontinue;
end fun_416;

protected function fun_417
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_outVars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_417;

protected function fun_418
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_418;

protected function lm_419
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varInits,
           a_varDecls )
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_varInits,
           a_varDecls )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_varInits) = varInit(txt, i_var, "", x_i1, a_varDecls, a_varInits);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits, a_varDecls) = lm_419(txt, rest, a_varInits, a_varDecls);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varInits,
           a_varDecls )
      equation
        (txt, a_varInits, a_varDecls) = lm_419(txt, rest, a_varInits, a_varDecls);
      then (txt, a_varInits, a_varDecls);
  end matchcontinue;
end lm_419;

protected function lm_420
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = addRoots(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_420(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_420(txt, rest);
      then txt;
  end matchcontinue;
end lm_420;

protected function lm_421
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = addRoots(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_421(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_421(txt, rest);
      then txt;
  end matchcontinue;
end lm_421;

protected function lm_422
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_varInits)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varInits;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varInits )
      then (txt, a_varInits);

    case ( txt,
           i_var :: rest,
           a_varInits )
      equation
        (txt, a_varInits) = functionArg(txt, i_var, a_varInits);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits) = lm_422(txt, rest, a_varInits);
      then (txt, a_varInits);

    case ( txt,
           _ :: rest,
           a_varInits )
      equation
        (txt, a_varInits) = lm_422(txt, rest, a_varInits);
      then (txt, a_varInits);
  end matchcontinue;
end lm_422;

protected function lm_423
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = funStatement(txt, i_stmt, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_423(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_423(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_423;

protected function lm_424
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutput(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_424(txt, rest, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           _ :: rest,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_424(txt, rest, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end matchcontinue;
end lm_424;

protected function fun_425
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function a_fn;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fn )
      equation
        txt = functionBodyBoxed(txt, a_fn);
      then txt;
  end matchcontinue;
end fun_425;

protected function lm_426
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_426(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_426(txt, rest);
      then txt;
  end matchcontinue;
end lm_426;

protected function fun_427
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_local_state_type mmc_GC_local_state = mmc_GC_save_roots_state(\"_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;
  end matchcontinue;
end fun_427;

protected function fun_428
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_addRootsInputs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_addRootsInputs)
    local
      Tpl.Text txt;
      Tpl.Text a_addRootsInputs;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_addRootsInputs )
      equation
        txt = Tpl.writeText(txt, a_addRootsInputs);
      then txt;
  end matchcontinue;
end fun_428;

protected function fun_429
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_collect(mmc_GC_local_state);"));
      then txt;
  end matchcontinue;
end fun_429;

protected function fun_430
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_430;

protected function fun_431
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_431;

protected function fun_432
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_undo_roots_state(mmc_GC_local_state);"));
      then txt;
  end matchcontinue;
end fun_432;

protected function fun_433
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_433;

protected function lm_434
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_434(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_434(txt, rest);
      then txt;
  end matchcontinue;
end lm_434;

protected function fun_435
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" out;"));
      then txt;
  end matchcontinue;
end fun_435;

protected function lm_436
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = readInVar(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_436(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_436(txt, rest);
      then txt;
  end matchcontinue;
end lm_436;

protected function fun_437
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out = "));
      then txt;
  end matchcontinue;
end fun_437;

protected function lm_438
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgName(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_438(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_438(txt, rest);
      then txt;
  end matchcontinue;
end lm_438;

protected function lm_439
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = writeOutVar(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_439(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_439(txt, rest);
      then txt;
  end matchcontinue;
end lm_439;

protected function fun_440
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_noretcall(outVar);"));
      then txt;

    case ( txt,
           i_outVars )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_439(txt, i_outVars);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_440;

protected function fun_441
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input Tpl.Text in_a_retType;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_functionArguments;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inFunc, in_a_retType, in_a_outVars, in_a_functionArguments, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_functionArguments;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_retType,
           a_outVars,
           a_functionArguments,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n",
                                    "  void* states = push_memory_states(1);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_434(txt, a_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_435(txt, a_outVars, a_retType);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_436(txt, a_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("MMC_TRY_TOP()\n"));
        txt = fun_437(txt, a_outVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_438(txt, a_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MMC_CATCH_TOP(return 1)\n"
                                }, true));
        txt = fun_440(txt, a_outVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fflush(NULL);\n",
                                    "pop_memory_states(states);\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end matchcontinue;
end fun_441;

public function functionBodyRegularFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.Function i_fn;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_functionArguments;
      list<SimCode.Variable> i_variableDeclarations;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Boolean ret_23;
      Boolean ret_22;
      Boolean ret_21;
      Boolean ret_20;
      Boolean ret_19;
      Boolean ret_18;
      Boolean ret_17;
      Tpl.Text l_boxedFn;
      Tpl.Text l_0___1;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarInits;
      Tpl.Text l_bodyPart;
      Tpl.Text l_funArgs;
      Tpl.Text l_addRootsOutputs;
      Tpl.Text l_addRootsInputs;
      Tpl.Text l_0__;
      Boolean ret_6;
      Tpl.Text l_stateVar;
      Tpl.Text l_retVar;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, outVars = i_outVars, variableDeclarations = i_variableDeclarations, functionArguments = i_functionArguments, body = i_body)),
           a_inFunc )
      equation
        System.tmpTickReset(1);
        System.tmpTickResetIndex(0, 1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_416(Tpl.emptyTxt, i_outVars, l_fname);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        (l_retVar, l_varDecls) = fun_417(Tpl.emptyTxt, i_outVars, l_varDecls, l_retType);
        ret_6 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, l_varDecls) = fun_418(Tpl.emptyTxt, ret_6, l_varDecls);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varInits, l_varDecls) = lm_419(l_0__, i_variableDeclarations, l_varInits, l_varDecls);
        l_0__ = Tpl.popIter(l_0__);
        l_addRootsInputs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_addRootsInputs = lm_420(l_addRootsInputs, i_functionArguments);
        l_addRootsInputs = Tpl.popIter(l_addRootsInputs);
        l_addRootsOutputs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_addRootsOutputs = lm_421(l_addRootsOutputs, i_outVars);
        l_addRootsOutputs = Tpl.popIter(l_addRootsOutputs);
        l_funArgs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_funArgs, l_varInits) = lm_422(l_funArgs, i_functionArguments, l_varInits);
        l_funArgs = Tpl.popIter(l_funArgs);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_423(l_bodyPart, i_body, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        l_outVarInits = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        l_outVarAssign = Tpl.emptyTxt;
        l_0___1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0___1, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls) = lm_424(l_0___1, i_outVars, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls, l_retVar);
        l_0___1 = Tpl.popIter(l_0___1);
        l_varDecls = addRootsTempArray(l_varDecls);
        ret_17 = Config.acceptMetaModelicaGrammar();
        l_boxedFn = fun_425(Tpl.emptyTxt, ret_17, i_fn);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_426(txt, i_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n",
                                    "\n",
                                    "  /* functionBodyRegularFunction: GC: save roots mark when you enter the function */\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_18 = Config.acceptMetaModelicaGrammar();
        txt = fun_427(txt, ret_18, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: GC: adding inputs as roots! */\n"));
        ret_19 = Config.acceptMetaModelicaGrammar();
        txt = fun_428(txt, ret_19, l_addRootsInputs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* functionBodyRegularFunction: GC: do garbage collection */\n"
                                }, true));
        ret_20 = Config.acceptMetaModelicaGrammar();
        txt = fun_429(txt, ret_20);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* functionBodyRegularFunction: arguments */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_funArgs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: locals */\n"));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_tailrecursive:\n",
                                    "/* functionBodyRegularFunction: out inits */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_outVarInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* functionBodyRegularFunction: state in */\n"
                                }, true));
        ret_21 = Config.acceptMetaModelicaGrammar();
        txt = fun_430(txt, ret_21, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* functionBodyRegularFunction: var inits */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: body */\n"));
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "_return:\n",
                                    "/* functionBodyRegularFunction: out var copy */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_outVarCopy);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: state out */\n"));
        ret_22 = Config.acceptMetaModelicaGrammar();
        txt = fun_431(txt, ret_22, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: out var assign */\n"));
        txt = Tpl.writeText(txt, l_outVarAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* GC: pop the mark! */\n"
                                }, true));
        ret_23 = Config.acceptMetaModelicaGrammar();
        txt = fun_432(txt, ret_23);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* functionBodyRegularFunction: return the outs */\n",
                                    "return "
                                }, false));
        txt = fun_433(txt, i_outVars, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = fun_441(txt, a_inFunc, l_retType, i_outVars, i_functionArguments, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_boxedFn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionBodyRegularFunction;

protected function fun_443
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end matchcontinue;
end fun_443;

protected function fun_444
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_outVars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = outDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_444;

protected function fun_445
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_445;

protected function lm_446
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_outputAlloc;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outputAlloc;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outputAlloc, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_outputAlloc, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_outputAlloc;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_outputAlloc,
           a_varDecls,
           _ )
      then (txt, a_outputAlloc, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_outputAlloc,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outputAlloc) = varInit(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outputAlloc);
        txt = Tpl.nextIter(txt);
        (txt, a_outputAlloc, a_varDecls) = lm_446(txt, rest, a_outputAlloc, a_varDecls, a_retVar);
      then (txt, a_outputAlloc, a_varDecls);

    case ( txt,
           _ :: rest,
           a_outputAlloc,
           a_varDecls,
           a_retVar )
      equation
        (txt, a_outputAlloc, a_varDecls) = lm_446(txt, rest, a_outputAlloc, a_varDecls, a_retVar);
      then (txt, a_outputAlloc, a_varDecls);
  end matchcontinue;
end lm_446;

protected function fun_447
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function a_fn;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fn )
      equation
        txt = functionBodyBoxed(txt, a_fn);
      then txt;
  end matchcontinue;
end fun_447;

protected function lm_448
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      DAE.ExpType i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.nextIter(txt);
        txt = lm_448(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_448(txt, rest);
      then txt;
  end matchcontinue;
end lm_448;

protected function fun_449
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;
  end matchcontinue;
end fun_449;

protected function fun_450
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end matchcontinue;
end fun_450;

protected function fun_451
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_451;

protected function fun_452
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ptrT_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=NULL;"));
      then txt;
  end matchcontinue;
end fun_452;

protected function lm_453
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      DAE.ExpType i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_453(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_453(txt, rest);
      then txt;
  end matchcontinue;
end lm_453;

protected function lm_454
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_arg as SimCode.VARIABLE(name = _)) :: rest )
      equation
        txt = readInVar(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_454(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_454(txt, rest);
      then txt;
  end matchcontinue;
end lm_454;

protected function lm_455
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.nextIter(txt);
        txt = lm_455(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_455(txt, rest);
      then txt;
  end matchcontinue;
end lm_455;

protected function lm_456
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = writeOutVar(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_456(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_456(txt, rest);
      then txt;
  end matchcontinue;
end lm_456;

protected function fun_457
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;
  input list<SimCode.Variable> in_a_funArgs;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inFunc, in_a_outVars, in_a_retType, in_a_funArgs, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      Tpl.Text a_retType;
      list<SimCode.Variable> a_funArgs;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_outVars,
           a_retType,
           a_funArgs,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n",
                                    "  void* states = push_memory_states(1);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_453(txt, a_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" out;\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_454(txt, a_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MMC_TRY_TOP()\n",
                                    "out = _"
                                }, false));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_455(txt, a_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MMC_CATCH_TOP(return 1)\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_456(txt, a_outVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "pop_memory_states(states);\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end matchcontinue;
end fun_457;

public function functionBodyExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_efn;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_fnBody;
      Boolean ret_11;
      Tpl.Text l_boxedFn;
      Tpl.Text l_0__;
      Tpl.Text l_callPart;
      Boolean ret_7;
      Tpl.Text l_stateVar;
      Tpl.Text l_outputAlloc;
      Tpl.Text l_retVar;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_efn as SimCode.EXTERNAL_FUNCTION(name = i_name, outVars = i_outVars, funArgs = i_funArgs, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language)),
           a_inFunc )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_443(Tpl.emptyTxt, i_outVars, l_fname);
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        (l_retVar, l_varDecls) = fun_444(Tpl.emptyTxt, i_outVars, l_varDecls, l_retType);
        l_outputAlloc = Tpl.emptyTxt;
        ret_7 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, l_varDecls) = fun_445(Tpl.emptyTxt, ret_7, l_varDecls);
        (l_callPart, l_preExp, l_varDecls) = extFunCall(Tpl.emptyTxt, i_efn, l_preExp, l_varDecls);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_outputAlloc, l_varDecls) = lm_446(l_0__, i_outVars, l_outputAlloc, l_varDecls, l_retVar);
        l_0__ = Tpl.popIter(l_0__);
        ret_11 = Config.acceptMetaModelicaGrammar();
        l_boxedFn = fun_447(Tpl.emptyTxt, ret_11, i_efn);
        l_fnBody = Tpl.writeText(Tpl.emptyTxt, l_retType);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING(" _"));
        l_fnBody = Tpl.writeText(l_fnBody, l_fname);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("("));
        l_fnBody = Tpl.pushIter(l_fnBody, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_fnBody = lm_448(l_fnBody, i_funArgs);
        l_fnBody = Tpl.popIter(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              ")\n",
                                              "{\n",
                                              "  /* functionBodyExternalFunction: varDecls */\n"
                                          }, true));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(2));
        l_fnBody = Tpl.writeText(l_fnBody, l_varDecls);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = fun_449(l_fnBody, false, l_stateVar);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: preExp */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_preExp);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: outputAlloc */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_outputAlloc);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: callPart */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_callPart);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = fun_450(l_fnBody, false, l_stateVar);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              "/* functionBodyExternalFunction: return */\n",
                                              "return "
                                          }, false));
        l_fnBody = fun_451(l_fnBody, i_outVars, l_retVar);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE(";\n"));
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("}"));
        txt = fun_452(txt, i_dynamicLoad, i_language, i_extName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_fnBody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_457(txt, a_inFunc, i_outVars, l_retType, i_funArgs, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_boxedFn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionBodyExternalFunction;

protected function fun_459
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function a_fn;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fn )
      equation
        txt = functionBodyBoxed(txt, a_fn);
      then txt;
  end matchcontinue;
end fun_459;

protected function lm_460
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      DAE.ExpType i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_460(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_460(txt, rest);
      then txt;
  end matchcontinue;
end lm_460;

protected function lm_461
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_structVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_structVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_structVar;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest,
           a_structVar )
      equation
        txt = Tpl.writeText(txt, a_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_461(txt, rest, a_structVar);
      then txt;

    case ( txt,
           _ :: rest,
           a_structVar )
      equation
        txt = lm_461(txt, rest, a_structVar);
      then txt;
  end matchcontinue;
end lm_461;

public function functionBodyRecordConstructor
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      Boolean ret_7;
      Tpl.Text l_boxedFn;
      Tpl.Text l_structVar;
      Tpl.Text l_structType;
      Tpl.Text l_retVar;
      Tpl.Text l_retType;
      Tpl.Text l_fname;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs)) )
      equation
        System.tmpTickReset(1);
        l_varDecls = Tpl.emptyTxt;
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_fname);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("_rettype"));
        (l_retVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), l_varDecls);
        l_structType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("struct "));
        l_structType = Tpl.writeText(l_structType, l_fname);
        (l_structVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_structType), l_varDecls);
        ret_7 = Config.acceptMetaModelicaGrammar();
        l_boxedFn = fun_459(Tpl.emptyTxt, ret_7, i_fn);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_460(txt, i_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_461(txt, i_funArgs, l_structVar);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targ1 = "));
        txt = Tpl.writeText(txt, l_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "return "
                                }, false));
        txt = Tpl.writeText(txt, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_boxedFn);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionBodyRecordConstructor;

protected function fun_463
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_functionArguments;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_outVars, in_a_functionArguments, in_a_name)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_functionArguments;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_outVars,
           a_functionArguments,
           a_name )
      equation
        txt = functionBodyBoxedImpl(txt, a_name, a_functionArguments, a_outVars);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_463;

protected function fun_464
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_funArgs;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_outVars, in_a_funArgs, in_a_name)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_funArgs;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_outVars,
           a_funArgs,
           a_name )
      equation
        txt = functionBodyBoxedImpl(txt, a_name, a_funArgs, a_outVars);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_464;

public function functionBodyBoxed
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      SimCode.Function i_fn;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars)) )
      equation
        ret_0 = SimCode.isBoxedFunction(i_fn);
        txt = fun_463(txt, ret_0, i_outVars, i_functionArguments, i_name);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name, funArgs = i_funArgs, outVars = i_outVars)) )
      equation
        ret_1 = SimCode.isBoxedFunction(i_fn);
        txt = fun_464(txt, ret_1, i_outVars, i_funArgs, i_name);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)) )
      equation
        txt = boxRecordConstructor(txt, i_fn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionBodyBoxed;

protected function fun_466
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outvars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end matchcontinue;
end fun_466;

protected function fun_467
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outvars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxed"));
      then txt;
  end matchcontinue;
end fun_467;

protected function fun_468
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retTypeBoxed;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_outvars, in_a_varDecls, in_a_retTypeBoxed)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retTypeBoxed;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retTypeBoxed )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retTypeBoxed), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_468;

protected function fun_469
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_outvars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_469;

protected function fun_470
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_470;

protected function lm_471
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varBox;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varBox;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varBox, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varBox, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varBox;
      Tpl.Text a_varDecls;
      SimCode.Variable i_arg;

    case ( txt,
           {},
           a_varBox,
           a_varDecls )
      then (txt, a_varBox, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varBox,
           a_varDecls )
      equation
        (txt, a_varDecls, a_varBox) = funArgUnbox(txt, i_arg, a_varDecls, a_varBox);
        txt = Tpl.nextIter(txt);
        (txt, a_varBox, a_varDecls) = lm_471(txt, rest, a_varBox, a_varDecls);
      then (txt, a_varBox, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varBox,
           a_varDecls )
      equation
        (txt, a_varBox, a_varDecls) = lm_471(txt, rest, a_varBox, a_varDecls);
      then (txt, a_varBox, a_varDecls);
  end matchcontinue;
end lm_471;

protected function lm_472
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varUnbox;
  input Tpl.Text in_a_retTypeBoxed;
  input Tpl.Text in_a_retVar;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_funRetVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varUnbox;
algorithm
  (out_txt, out_a_varDecls, out_a_varUnbox) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_varUnbox, in_a_retTypeBoxed, in_a_retVar, in_a_retType, in_a_funRetVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varUnbox;
      Tpl.Text a_retTypeBoxed;
      Tpl.Text a_retVar;
      Tpl.Text a_retType;
      Tpl.Text a_funRetVar;
      Integer x_i1;
      DAE.ExpType i_ty;
      Tpl.Text l_arg;

    case ( txt,
           {},
           a_varDecls,
           a_varUnbox,
           _,
           _,
           _,
           _ )
      then (txt, a_varDecls, a_varUnbox);

    case ( txt,
           SimCode.VARIABLE(ty = i_ty) :: rest,
           a_varDecls,
           a_varUnbox,
           a_retTypeBoxed,
           a_retVar,
           a_retType,
           a_funRetVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_arg = Tpl.writeText(Tpl.emptyTxt, a_funRetVar);
        l_arg = Tpl.writeTok(l_arg, Tpl.ST_STRING("."));
        l_arg = Tpl.writeText(l_arg, a_retType);
        l_arg = Tpl.writeTok(l_arg, Tpl.ST_STRING("_"));
        l_arg = Tpl.writeStr(l_arg, intString(x_i1));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retTypeBoxed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        (txt, a_varUnbox, a_varDecls) = funArgBox(txt, Tpl.textString(l_arg), i_ty, a_varUnbox, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varUnbox) = lm_472(txt, rest, a_varDecls, a_varUnbox, a_retTypeBoxed, a_retVar, a_retType, a_funRetVar);
      then (txt, a_varDecls, a_varUnbox);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_varUnbox,
           a_retTypeBoxed,
           a_retVar,
           a_retType,
           a_funRetVar )
      equation
        (txt, a_varDecls, a_varUnbox) = lm_472(txt, rest, a_varDecls, a_varUnbox, a_retTypeBoxed, a_retVar, a_retType, a_funRetVar);
      then (txt, a_varDecls, a_varUnbox);
  end matchcontinue;
end lm_472;

protected function lm_473
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgBoxedDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_473(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_473(txt, rest);
      then txt;
  end matchcontinue;
end lm_473;

protected function fun_474
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_local_state_type mmc_GC_local_state = mmc_GC_save_roots_state(\"boxptr__"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;
  end matchcontinue;
end fun_474;

protected function fun_475
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_475;

protected function fun_476
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_funRetVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outvars, in_a_funRetVar)
    local
      Tpl.Text txt;
      Tpl.Text a_funRetVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_funRetVar )
      equation
        txt = Tpl.writeText(txt, a_funRetVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;
  end matchcontinue;
end fun_476;

protected function fun_477
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_477;

protected function fun_478
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_undo_roots_state(mmc_GC_local_state);"));
      then txt;
  end matchcontinue;
end fun_478;

public function functionBodyBoxedImpl
  input Tpl.Text txt;
  input Absyn.Path a_name;
  input list<SimCode.Variable> a_funargs;
  input list<SimCode.Variable> a_outvars;

  output Tpl.Text out_txt;
protected
  Boolean ret_15;
  Boolean ret_14;
  Boolean ret_13;
  Boolean ret_12;
  Tpl.Text l_retStr;
  Tpl.Text l_args;
  Tpl.Text l_varUnbox;
  Tpl.Text l_varBox;
  Boolean ret_7;
  Tpl.Text l_stateVar;
  Tpl.Text l_funRetVar;
  Tpl.Text l_retVar;
  Tpl.Text l_varDecls;
  Tpl.Text l_retTypeBoxed;
  Tpl.Text l_retType;
  Tpl.Text l_fname;
algorithm
  System.tmpTickReset(1);
  System.tmpTickResetIndex(0, 1);
  l_fname := underscorePath(Tpl.emptyTxt, a_name);
  l_retType := fun_466(Tpl.emptyTxt, a_outvars, l_fname);
  l_retTypeBoxed := fun_467(Tpl.emptyTxt, a_outvars, l_retType);
  l_varDecls := Tpl.emptyTxt;
  (l_retVar, l_varDecls) := fun_468(Tpl.emptyTxt, a_outvars, l_varDecls, l_retTypeBoxed);
  (l_funRetVar, l_varDecls) := fun_469(Tpl.emptyTxt, a_outvars, l_varDecls, l_retType);
  ret_7 := Config.acceptMetaModelicaGrammar();
  (l_stateVar, l_varDecls) := fun_470(Tpl.emptyTxt, ret_7, l_varDecls);
  l_varBox := Tpl.emptyTxt;
  l_varUnbox := Tpl.emptyTxt;
  l_args := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_args, l_varBox, l_varDecls) := lm_471(l_args, a_funargs, l_varBox, l_varDecls);
  l_args := Tpl.popIter(l_args);
  l_retStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_retStr, l_varDecls, l_varUnbox) := lm_472(l_retStr, a_outvars, l_varDecls, l_varUnbox, l_retTypeBoxed, l_retVar, l_retType, l_funRetVar);
  l_retStr := Tpl.popIter(l_retStr);
  out_txt := Tpl.writeText(txt, l_retTypeBoxed);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" boxptr_"));
  out_txt := Tpl.writeText(out_txt, l_fname);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("("));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_473(out_txt, a_funargs);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ")\n",
                                       "{\n",
                                       "  /* GC: save roots mark when you enter the function */\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_12 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_474(out_txt, ret_12, l_fname);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := addRootsTempArray(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  ret_13 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_475(out_txt, ret_13, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_varBox);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := fun_476(out_txt, a_outvars, l_funRetVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_"));
  out_txt := Tpl.writeText(out_txt, l_fname);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("("));
  out_txt := Tpl.writeText(out_txt, l_args);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(");\n"));
  out_txt := Tpl.writeText(out_txt, l_varUnbox);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_retStr);
  out_txt := Tpl.softNewLine(out_txt);
  ret_14 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_477(out_txt, ret_14, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "/* GC: pop roots mark when you exit the function */\n"
                                   }, true));
  ret_15 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_478(out_txt, ret_15);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return "
                                   }, false));
  out_txt := Tpl.writeText(out_txt, l_retVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(";\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionBodyBoxedImpl;

protected function lm_480
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.nextIter(txt);
        txt = lm_480(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_480(txt, rest);
      then txt;
  end matchcontinue;
end lm_480;

protected function lm_481
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgBoxedDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_481(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_481(txt, rest);
      then txt;
  end matchcontinue;
end lm_481;

public function boxRecordConstructor
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      Absyn.Path i_name;
      Integer ret_4;
      Integer ret_3;
      Tpl.Text l_funArgCount;
      Tpl.Text l_funArgsStr;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs) )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_funArgsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funArgsStr = lm_480(l_funArgsStr, i_funArgs);
        l_funArgsStr = Tpl.popIter(l_funArgsStr);
        ret_3 = listLength(i_funArgs);
        ret_4 = SimCode.incrementInt(ret_3, 1);
        l_funArgCount = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype boxptr_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_481(txt, i_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return mmc_mk_box"));
        txt = Tpl.writeText(txt, l_funArgCount);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(3, &"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc, "));
        txt = Tpl.writeText(txt, l_funArgsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end boxRecordConstructor;

public function funArgUnbox
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varBox;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varBox;
algorithm
  (out_txt, out_a_varDecls, out_a_varBox) :=
  matchcontinue(in_txt, in_a_var, in_a_varDecls, in_a_varBox)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varBox;
      String i_name_1;
      DAE.ExpType i_ty;
      DAE.ComponentRef i_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(name = i_name, ty = i_ty),
           a_varDecls,
           a_varBox )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_name, SimCode.contextFunction);
        (txt, a_varBox, a_varDecls) = unboxVariable(txt, Tpl.textString(l_varName), i_ty, a_varBox, a_varDecls);
      then (txt, a_varDecls, a_varBox);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_varDecls,
           a_varBox )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then (txt, a_varDecls, a_varBox);

    case ( txt,
           _,
           a_varDecls,
           a_varBox )
      then (txt, a_varDecls, a_varBox);
  end matchcontinue;
end funArgUnbox;

protected function fun_484
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_varType;
  input String in_a_varName;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_varType, in_a_varName, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_varName;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType i_varType;
      Tpl.Text l_tmpVar;
      Tpl.Text l_ty;
      Tpl.Text l_shortType;

    case ( txt,
           DAE.ET_STRING(),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ET_METATYPE(),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ET_BOXED(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_varType as DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = _))),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = unboxRecord(txt, a_varName, i_varType, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_varType,
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        l_shortType = mmcExpTypeShort(Tpl.emptyTxt, i_varType);
        l_ty = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("modelica_"));
        l_ty = Tpl.writeText(l_ty, l_shortType);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ty), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmpVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = mmc_unbox_"));
        a_preExp = Tpl.writeText(a_preExp, l_shortType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeStr(a_preExp, a_varName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_484;

public function unboxVariable
  input Tpl.Text txt;
  input String a_varName;
  input DAE.ExpType a_varType;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_484(txt, a_varType, a_varName, a_preExp, a_varDecls);
end unboxVariable;

protected function lm_486
  input Tpl.Text in_txt;
  input list<DAE.ExpVar> in_items;
  input Tpl.Text in_a_tmpVar;
  input String in_a_recordVar;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmpVar, in_a_recordVar, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.ExpVar> rest;
      Tpl.Text a_tmpVar;
      String a_recordVar;
      Tpl.Text a_varDecls;
      Integer x_offset;
      String i_compname;
      DAE.ExpType i_tp;
      Tpl.Text l_unboxStr;
      Tpl.Text l_unboxBuf;
      Tpl.Text l_untagTmp;
      Tpl.Text l_varType;

    case ( txt,
           {},
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           DAE.COMPLEX_VAR(name = i_compname, tp = i_tp) :: rest,
           a_tmpVar,
           a_recordVar,
           a_varDecls )
      equation
        x_offset = Tpl.getIteri_i0(txt);
        l_varType = mmcExpTypeShort(Tpl.emptyTxt, i_tp);
        (l_untagTmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_metatype", a_varDecls);
        l_unboxBuf = Tpl.emptyTxt;
        (l_unboxStr, l_unboxBuf, a_varDecls) = unboxVariable(Tpl.emptyTxt, Tpl.textString(l_untagTmp), i_tp, l_unboxBuf, a_varDecls);
        txt = Tpl.writeText(txt, l_untagTmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = (MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR("));
        txt = Tpl.writeStr(txt, a_recordVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), "));
        txt = Tpl.writeStr(txt, intString(x_offset));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")));\n"));
        txt = Tpl.writeText(txt, l_unboxBuf);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_tmpVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, i_compname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_unboxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_486(txt, rest, a_tmpVar, a_recordVar, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmpVar,
           a_recordVar,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_486(txt, rest, a_tmpVar, a_recordVar, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_486;

protected function fun_487
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;
  input String in_a_recordVar;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_recordVar, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_recordVar;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.ExpVar> i_vars;
      Absyn.Path i_path;
      Tpl.Text txt_1;
      Tpl.Text l_tmpVar;

    case ( txt,
           DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = i_path), varLst = i_vars),
           a_recordVar,
           a_preExp,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("struct "));
        txt_1 = underscorePath(txt_1, i_path);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        a_preExp = Tpl.pushIter(a_preExp, Tpl.ITER_OPTIONS(2, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (a_preExp, a_varDecls) = lm_486(a_preExp, i_vars, l_tmpVar, a_recordVar, a_varDecls);
        a_preExp = Tpl.popIter(a_preExp);
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_487;

public function unboxRecord
  input Tpl.Text txt;
  input String a_recordVar;
  input DAE.ExpType a_ty;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_487(txt, a_ty, a_recordVar, a_preExp, a_varDecls);
end unboxRecord;

protected function fun_489
  input Tpl.Text in_txt;
  input Tpl.Text in_a_constructorType;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varUnbox;
  input DAE.ExpType in_a_ty;
  input String in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varUnbox;
algorithm
  (out_txt, out_a_varDecls, out_a_varUnbox) :=
  matchcontinue(in_txt, in_a_constructorType, in_a_varDecls, in_a_varUnbox, in_a_ty, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varUnbox;
      DAE.ExpType a_ty;
      String a_varName;
      Tpl.Text i_constructorType;
      Tpl.Text l_tmpVar;
      Tpl.Text l_constructor;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_varDecls,
           a_varUnbox,
           _,
           a_varName )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_varDecls, a_varUnbox);

    case ( txt,
           i_constructorType,
           a_varDecls,
           a_varUnbox,
           a_ty,
           a_varName )
      equation
        (l_constructor, a_varUnbox, a_varDecls) = mmcConstructor(Tpl.emptyTxt, a_ty, a_varName, a_varUnbox, a_varDecls);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(i_constructorType), a_varDecls);
        a_varUnbox = Tpl.writeText(a_varUnbox, l_tmpVar);
        a_varUnbox = Tpl.writeTok(a_varUnbox, Tpl.ST_STRING(" = "));
        a_varUnbox = Tpl.writeText(a_varUnbox, l_constructor);
        a_varUnbox = Tpl.writeTok(a_varUnbox, Tpl.ST_STRING(";"));
        a_varUnbox = Tpl.writeTok(a_varUnbox, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_varDecls, a_varUnbox);
  end matchcontinue;
end fun_489;

public function funArgBox
  input Tpl.Text txt;
  input String a_varName;
  input DAE.ExpType a_ty;
  input Tpl.Text a_varUnbox;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varUnbox;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_constructorType;
algorithm
  l_constructorType := mmcConstructorType(Tpl.emptyTxt, a_ty);
  (out_txt, out_a_varDecls, out_a_varUnbox) := fun_489(txt, l_constructorType, a_varDecls, a_varUnbox, a_ty, a_varName);
end funArgBox;

public function mmcConstructorType
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.ET_BOOL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.ET_REAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.ET_ENUMERATION(path = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.ET_COMPLEX(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end mmcConstructorType;

protected function lm_492
  input Tpl.Text in_txt;
  input list<DAE.ExpVar> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input String in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_varName)
    local
      Tpl.Text txt;
      list<DAE.ExpVar> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      String a_varName;
      DAE.ExpType i_tp;
      String i_name;
      Tpl.Text l_varname;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.COMPLEX_VAR(name = i_name, tp = i_tp) :: rest,
           a_varDecls,
           a_preExp,
           a_varName )
      equation
        l_varname = Tpl.writeStr(Tpl.emptyTxt, a_varName);
        l_varname = Tpl.writeTok(l_varname, Tpl.ST_STRING("."));
        l_varname = Tpl.writeStr(l_varname, i_name);
        (txt, a_preExp, a_varDecls) = funArgBox(txt, Tpl.textString(l_varname), i_tp, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_492(txt, rest, a_varDecls, a_preExp, a_varName);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_varName )
      equation
        (txt, a_varDecls, a_preExp) = lm_492(txt, rest, a_varDecls, a_preExp, a_varName);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_492;

public function mmcConstructor
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;
  input String in_a_varName;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_type, in_a_varName, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_varName;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Absyn.Path i_path;
      list<DAE.ExpVar> i_vars;
      Tpl.Text l_varsStr;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_varCount;

    case ( txt,
           DAE.ET_INT(),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_icon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ET_BOOL(),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_icon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ET_REAL(),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_rcon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ET_STRING(),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_string("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ET_ENUMERATION(path = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_icon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ET_ARRAY(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_acon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = i_path), varLst = i_vars),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        ret_1 = listLength(i_vars);
        ret_2 = SimCode.incrementInt(ret_1, 1);
        l_varCount = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_varsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varsStr, a_varDecls, a_preExp) = lm_492(l_varsStr, i_vars, a_varDecls, a_preExp, a_varName);
        l_varsStr = Tpl.popIter(l_varsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_box"));
        txt = Tpl.writeText(txt, l_varCount);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(3, &"));
        txt = underscorePath(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc, "));
        txt = Tpl.writeText(txt, l_varsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ET_COMPLEX(name = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_box("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end mmcConstructor;

protected function fun_494
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char**)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_494;

public function readInVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      DAE.ComponentRef i_cr;
      DAE.ExpType i_ty;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.VARIABLE(name = i_cr, ty = (i_ty as DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_modelica_record(&inArgs, "));
        txt_0 = contextCref(Tpl.emptyTxt, i_cr, SimCode.contextFunction);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(txt_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name, ty = (i_ty as DAE.ET_STRING())) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, "));
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_494(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end readInVar;

protected function fun_496
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_tp;
  input String in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_tp, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      String a_subvar_name;
      String a_prefix;
      DAE.ExpType i_tp;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_tp as DAE.ET_COMPLEX(name = _)),
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = readInVarRecordMembers(txt, i_tp, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           _,
           a_subvar_name,
           a_prefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&("));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_496;

protected function lm_497
  input Tpl.Text in_txt;
  input list<DAE.ExpVar> in_items;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.ExpVar> rest;
      String a_prefix;
      String i_subvar_name;
      DAE.ExpType i_tp;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           DAE.COMPLEX_VAR(tp = i_tp, name = i_subvar_name) :: rest,
           a_prefix )
      equation
        txt = fun_496(txt, i_tp, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_497(txt, rest, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_prefix )
      equation
        txt = lm_497(txt, rest, a_prefix);
      then txt;
  end matchcontinue;
end lm_497;

public function readInVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_prefix)
    local
      Tpl.Text txt;
      String a_prefix;
      list<DAE.ExpVar> i_vl;

    case ( txt,
           DAE.ET_COMPLEX(varLst = i_vl),
           a_prefix )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_497(txt, i_vl, a_prefix);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end readInVarRecordMembers;

public function writeOutVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.Variable i_var;
      DAE.ExpType i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = (i_ty as DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_modelica_record(outVar, "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, "");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_"));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(outVar, &out.targ"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end writeOutVar;

protected function fun_500
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_tp;
  input Integer in_a_index;
  input String in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_tp, in_a_index, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      String a_subvar_name;
      String a_prefix;
      DAE.ExpType i_tp;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_tp as DAE.ET_COMPLEX(name = _)),
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = expTypeRW(txt, i_tp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = writeOutVarRecordMembers(txt, i_tp, a_index, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           i_tp,
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        txt = expTypeRW(txt, i_tp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &(out.targ"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_500;

protected function lm_501
  input Tpl.Text in_txt;
  input list<DAE.ExpVar> in_items;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.ExpVar> rest;
      Integer a_index;
      String a_prefix;
      String i_subvar_name;
      DAE.ExpType i_tp;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           DAE.COMPLEX_VAR(tp = i_tp, name = i_subvar_name) :: rest,
           a_index,
           a_prefix )
      equation
        txt = fun_500(txt, i_tp, a_index, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_501(txt, rest, a_index, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_index,
           a_prefix )
      equation
        txt = lm_501(txt, rest, a_index, a_prefix);
      then txt;
  end matchcontinue;
end lm_501;

protected function fun_502
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_args)
    local
      Tpl.Text txt;
      Tpl.Text i_args;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_args )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_args);
      then txt;
  end matchcontinue;
end fun_502;

public function writeOutVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      String a_prefix;
      list<DAE.ExpVar> i_vl;
      Absyn.Path i_n;
      Tpl.Text l_args;
      Tpl.Text l_basename;

    case ( txt,
           DAE.ET_COMPLEX(varLst = i_vl, name = i_n),
           a_index,
           a_prefix )
      equation
        l_basename = underscorePath(Tpl.emptyTxt, i_n);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args = lm_501(l_args, i_vl, a_index, a_prefix);
        l_args = Tpl.popIter(l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_basename);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc"));
        txt = fun_502(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", TYPE_DESC_NONE"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end writeOutVarRecordMembers;

protected function fun_504
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "modelica_metatype" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = NULL"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_504;

protected function fun_505
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           "modelica_metatype",
           a_varName )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_505;

protected function fun_506
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Tpl.Text in_a_addRoot;
  input Tpl.Text in_a_initVar;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_typ;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outStruct, in_a_addRoot, in_a_initVar, in_a_varName, in_a_typ)
    local
      Tpl.Text txt;
      Tpl.Text a_addRoot;
      Tpl.Text a_initVar;
      Tpl.Text a_varName;
      Tpl.Text a_typ;

    case ( txt,
           "",
           a_addRoot,
           a_initVar,
           a_varName,
           a_typ )
      equation
        txt = Tpl.writeText(txt, a_typ);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_initVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_addRoot);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_506;

protected function fun_507
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Integer in_a_i;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outStruct, in_a_i, in_a_var_name)
    local
      Tpl.Text txt;
      Integer a_i;
      DAE.ComponentRef a_var_name;
      String i_outStruct;

    case ( txt,
           "",
           _,
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_outStruct,
           a_i,
           _ )
      equation
        txt = Tpl.writeStr(txt, i_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targ"));
        txt = Tpl.writeStr(txt, intString(a_i));
      then txt;
  end matchcontinue;
end fun_507;

protected function lm_508
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_508(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = lm_508(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end lm_508;

protected function fun_509
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var_value, in_a_varDecls, in_a_varInits, in_a_var_name)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_varInits,
           a_var_name )
      equation
        l_defaultValue = contextCref(Tpl.emptyTxt, a_var_name, SimCode.contextFunction);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(" = "));
        (l_defaultValue, a_varInits, a_varDecls) = daeExp(l_defaultValue, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(";"));
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_509;

protected function fun_510
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outStruct, in_a_var_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;

    case ( txt,
           "",
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           _,
           a_var_name )
      equation
        txt = extVarName(txt, a_var_name);
      then txt;
  end matchcontinue;
end fun_510;

protected function fun_511
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input DAE.ExpType in_a_var_ty;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var_value, in_a_var_name, in_a_varDecls, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_instDims, in_a_varName, in_a_var_ty, in_a_varInits)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varDecls;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      list<DAE.Exp> a_instDims;
      Tpl.Text a_varName;
      DAE.ExpType a_var_ty;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;
      Integer ret_4;
      Tpl.Text l_defaultValue1;
      Tpl.Text l_var__name;
      Tpl.Text l_defaultValue;
      Integer ret_0;

    case ( txt,
           SOME(i_exp),
           a_var_name,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_var_ty,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(a_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        l_var__name = fun_510(Tpl.emptyTxt, a_outStruct, a_var_name);
        l_defaultValue1 = Tpl.writeText(Tpl.emptyTxt, l_var__name);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(" = "));
        (l_defaultValue1, a_varInits, a_varDecls) = daeExp(l_defaultValue1, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(";"));
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_var_ty,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_4 = listLength(a_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_4));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_511;

protected function fun_512
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input DAE.ExpType in_a_var_ty;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;
  input Option<DAE.Exp> in_a_var_value;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_instDims, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varName, in_a_var_ty, in_a_varDecls, in_a_varInits, in_a_var_name, in_a_var_value)
    local
      Tpl.Text txt;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      DAE.ExpType a_var_ty;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      Option<DAE.Exp> a_var_value;
      list<DAE.Exp> i_instDims;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_509(txt, a_var_value, a_varDecls, a_varInits, a_var_name);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_instDims,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_var_ty,
           a_varDecls,
           a_varInits,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_511(txt, a_var_value, a_var_name, a_varDecls, a_i, a_outStruct, a_var, a_instDimsInit, i_instDims, a_varName, a_var_ty, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_512;

public function varInit
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ExpType i_var_ty;
      Option<DAE.Exp> i_var_value;
      list<DAE.Exp> i_instDims;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_ignore;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName_1;
      String str_5;
      Tpl.Text l_addRoot;
      String str_3;
      Tpl.Text l_initVar;
      Tpl.Text l_typ;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, value = i_var_value, ty = i_var_ty)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        l_typ = varType(Tpl.emptyTxt, i_var);
        str_3 = Tpl.textString(l_typ);
        l_initVar = fun_504(Tpl.emptyTxt, str_3);
        str_5 = Tpl.textString(l_typ);
        l_addRoot = fun_505(Tpl.emptyTxt, str_5, l_varName);
        a_varDecls = fun_506(a_varDecls, a_outStruct, l_addRoot, l_initVar, l_varName, l_typ);
        l_varName_1 = fun_507(Tpl.emptyTxt, a_outStruct, a_i, i_var_name);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_508(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varDecls, a_varInits) = fun_512(txt, i_instDims, a_i, a_outStruct, i_var, l_instDimsInit, l_varName_1, i_var_ty, a_varDecls, a_varInits, i_var_name, i_var_value);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           (i_var as SimCode.FUNCTION_PTR(name = _)),
           _,
           _,
           a_varDecls,
           a_varInits )
      equation
        l_ignore = Tpl.emptyTxt;
        (a_varDecls, l_ignore) = functionArg(a_varDecls, i_var, l_ignore);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits )
      equation
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 3421, 12), "Unknown local variable type");
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end varInit;

protected function fun_514
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_value;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Integer in_a_i;
  input String in_a_outStruct;
  input DAE.ExpType in_a_var_ty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_value, in_a_lhsVarName, in_a_varDecls, in_a_varInits, in_a_i, in_a_outStruct, in_a_var_ty)
    local
      Tpl.Text txt;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Integer a_i;
      String a_outStruct;
      DAE.ExpType a_var_ty;
      DAE.Exp i_arr;
      DAE.ComponentRef i_cr;
      Tpl.Text l_arrayExp;

    case ( txt,
           SOME(DAE.CREF(componentRef = i_cr)),
           _,
           a_varDecls,
           a_varInits,
           a_i,
           a_outStruct,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data(&"));
        txt = contextCref(txt, i_cr, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targ"));
        txt = Tpl.writeStr(txt, intString(a_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           SOME((i_arr as DAE.ARRAY(ty = _))),
           a_lhsVarName,
           a_varDecls,
           a_varInits,
           _,
           _,
           a_var_ty )
      equation
        (l_arrayExp, a_varInits, a_varDecls) = daeExp(Tpl.emptyTxt, i_arr, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data(&"));
        txt = Tpl.writeText(txt, l_arrayExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_lhsVarName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_varInits,
           _,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_514;

public function varDefaultValue
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_lhsVarName, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ExpType i_var_ty;
      Option<DAE.Exp> i_value;

    case ( txt,
           SimCode.VARIABLE(value = i_value, ty = i_var_ty),
           a_outStruct,
           a_i,
           a_lhsVarName,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = fun_514(txt, i_value, a_lhsVarName, a_varDecls, a_varInits, a_i, a_outStruct, i_var_ty);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end varDefaultValue;

protected function lm_516
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = mmcVarType(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_516(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_516(txt, rest);
      then txt;
  end matchcontinue;
end lm_516;

protected function lm_517
  input Tpl.Text in_txt;
  input list<DAE.ExpType> in_items;
  input Tpl.Text in_a_rettype;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_rettype)
    local
      Tpl.Text txt;
      list<DAE.ExpType> rest;
      Tpl.Text a_rettype;
      Integer x_i1;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_rettype )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targ"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_517(txt, rest, a_rettype);
      then txt;

    case ( txt,
           _ :: rest,
           a_rettype )
      equation
        txt = lm_517(txt, rest, a_rettype);
      then txt;
  end matchcontinue;
end lm_517;

protected function lm_518
  input Tpl.Text in_txt;
  input list<DAE.ExpType> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ExpType> rest;
      Integer x_i1;
      DAE.ExpType i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ty :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcExpTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targ"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_518(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_518(txt, rest);
      then txt;
  end matchcontinue;
end lm_518;

protected function fun_519
  input Tpl.Text in_txt;
  input list<DAE.ExpType> in_a_tys;
  input Tpl.Text in_a_rettype;
  input Tpl.Text in_a_typelist;
  input String in_a_name;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  matchcontinue(in_txt, in_a_tys, in_a_rettype, in_a_typelist, in_a_name, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_rettype;
      Tpl.Text a_typelist;
      String a_name;
      Tpl.Text a_varInit;
      list<DAE.ExpType> i_tys;

    case ( txt,
           {},
           _,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = (void(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);

    case ( txt,
           i_tys,
           a_rettype,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = ("));
        a_varInit = Tpl.writeText(a_varInit, a_rettype);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_517(txt, i_tys, a_rettype);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_s\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_518(txt, i_tys);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);
  end matchcontinue;
end fun_519;

public function functionArg
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  matchcontinue(in_txt, in_a_var, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_varInit;
      list<DAE.ExpType> i_tys;
      String i_name;
      list<SimCode.Variable> i_args;
      Tpl.Text l_rettype;
      Tpl.Text l_typelist;

    case ( txt,
           SimCode.FUNCTION_PTR(args = i_args, name = i_name, tys = i_tys),
           a_varInit )
      equation
        l_typelist = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_typelist = lm_516(l_typelist, i_args);
        l_typelist = Tpl.popIter(l_typelist);
        l_rettype = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_rettype = Tpl.writeTok(l_rettype, Tpl.ST_STRING("_rettype"));
        (txt, a_varInit) = fun_519(txt, i_tys, l_rettype, l_typelist, i_name, a_varInit);
      then (txt, a_varInit);

    case ( txt,
           _,
           a_varInit )
      then (txt, a_varInit);
  end matchcontinue;
end functionArg;

protected function fun_521
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_varCopy, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_ix, in_a_dest, in_a_varAssign, in_a_var_name, in_a_varCopy, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varCopy;
      Tpl.Text a_varDecls;
      Tpl.Text l_strVar;

    case ( txt,
           false,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_string_t", a_varDecls);
        a_varCopy = Tpl.writeText(a_varCopy, l_strVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(" = strdup("));
        a_varCopy = contextCref(a_varCopy, a_var_name, SimCode.contextFunction);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(");"));
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".targ"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = init_modelica_string("));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING_LIST({
                                                    ");\n",
                                                    "free("
                                                }, false));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           _,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".targ"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varCopy, a_varDecls);
  end matchcontinue;
end fun_521;

protected function lm_522
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_522(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = lm_522(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end lm_522;

protected function fun_523
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.ExpType in_a_var_ty;
  input DAE.ComponentRef in_a_var_name;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varAssign, out_a_varInits) :=
  matchcontinue(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_ty, in_a_var_name, in_a_ix, in_a_dest, in_a_varAssign, in_a_var, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.ExpType a_var_ty;
      DAE.ComponentRef a_var_name;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      SimCode.Variable a_var;
      Tpl.Text a_varInits;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           a_var,
           a_varInits )
      equation
        a_varInits = initRecordMembers(a_varInits, a_var);
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".targ"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_ty,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           _,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeStr(a_varInits, a_dest);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".targ"));
        a_varInits = Tpl.writeStr(a_varInits, intString(a_ix));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("copy_"));
        a_varAssign = expTypeShort(a_varAssign, a_var_ty);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_array_data(&"));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(", &"));
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".targ"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);
  end matchcontinue;
end fun_523;

public function varOutput
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_dest;
  input Integer in_a_ix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varCopy, out_a_varAssign) :=
  matchcontinue(in_txt, in_a_var, in_a_dest, in_a_ix, in_a_varDecls, in_a_varInits, in_a_varCopy, in_a_varAssign)
    local
      Tpl.Text txt;
      String a_dest;
      Integer a_ix;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varCopy;
      Tpl.Text a_varAssign;
      String i_var_name_1;
      DAE.ExpType i_var_ty;
      SimCode.Variable i_var;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_marker;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.ET_STRING(), name = i_var_name),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varAssign, a_varCopy, a_varDecls) = fun_521(txt, ret_0, a_ix, a_dest, a_varAssign, i_var_name, a_varCopy, a_varDecls);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty)),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        l_marker = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("/* varOutput varInits("));
        a_varInits = Tpl.writeText(a_varInits, l_marker);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(") */ "));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/* varOutput varAssign("));
        a_varAssign = Tpl.writeText(a_varAssign, l_marker);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(") */ "));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_522(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varAssign, a_varInits) = fun_523(txt, i_instDims, l_instDimsInit, i_var_ty, i_var_name, a_ix, a_dest, a_varAssign, i_var, a_varInits);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".targ"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = (modelica_fnptr) _"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);
  end matchcontinue;
end varOutput;

protected function lm_525
  input Tpl.Text in_txt;
  input list<DAE.ExpVar> in_items;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varName;
algorithm
  (out_txt, out_a_varName) :=
  matchcontinue(in_txt, in_items, in_a_varName)
    local
      Tpl.Text txt;
      list<DAE.ExpVar> rest;
      Tpl.Text a_varName;
      DAE.ExpVar i_v;

    case ( txt,
           {},
           a_varName )
      then (txt, a_varName);

    case ( txt,
           i_v :: rest,
           a_varName )
      equation
        (txt, a_varName) = recordMemberInit(txt, i_v, a_varName);
        txt = Tpl.nextIter(txt);
        (txt, a_varName) = lm_525(txt, rest, a_varName);
      then (txt, a_varName);

    case ( txt,
           _ :: rest,
           a_varName )
      equation
        (txt, a_varName) = lm_525(txt, rest, a_varName);
      then (txt, a_varName);
  end matchcontinue;
end lm_525;

public function initRecordMembers
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      list<DAE.ExpVar> i_ty_varLst;
      DAE.ComponentRef i_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = _), varLst = i_ty_varLst), name = i_name) )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_name, SimCode.contextFunction);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varName) = lm_525(txt, i_ty_varLst, l_varName);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end initRecordMembers;

protected function lm_527
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_527(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_527(txt, rest);
      then txt;
  end matchcontinue;
end lm_527;

protected function fun_528
  input Tpl.Text in_txt;
  input DAE.ExpVar in_a_v;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_v, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      String i_name;
      list<DAE.Dimension> i_tp_arrayDimensions;
      DAE.ExpType i_tp;
      Integer ret_2;
      Tpl.Text l_dims;
      Tpl.Text l_arrayType;

    case ( txt,
           DAE.COMPLEX_VAR(tp = (i_tp as DAE.ET_ARRAY(arrayDimensions = i_tp_arrayDimensions)), name = i_name),
           a_varName )
      equation
        l_arrayType = expType(Tpl.emptyTxt, i_tp, true);
        l_dims = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dims = lm_527(l_dims, i_tp_arrayDimensions);
        l_dims = Tpl.popIter(l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("alloc_"));
        txt = Tpl.writeText(txt, l_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        ret_2 = listLength(i_tp_arrayDimensions);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_528;

public function recordMemberInit
  input Tpl.Text txt;
  input DAE.ExpVar a_v;
  input Tpl.Text a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varName;
algorithm
  out_txt := fun_528(txt, a_v, a_varName);
  out_a_varName := a_varName;
end recordMemberInit;

public function extVarName
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := contextCref(txt, a_cr, SimCode.contextFunction);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_ext"));
end extVarName;

protected function fun_531
  input Tpl.Text in_txt;
  input String in_a_language;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Function in_a_fun;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_language, in_a_varDecls, in_a_preExp, in_a_fun)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Function a_fun;

    case ( txt,
           "C",
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallC(txt, a_fun, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           "FORTRAN 77",
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallF77(txt, a_fun, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_531;

public function extFunCall
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.Function i_fun;
      String i_language;

    case ( txt,
           (i_fun as SimCode.EXTERNAL_FUNCTION(language = i_language)),
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_531(txt, i_language, a_varDecls, a_preExp, i_fun);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCall;

protected function lm_533
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_arg, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_533(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_533(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_533;

protected function fun_534
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;

    case ( txt,
           false,
           _,
           a_extName )
      equation
        txt = Tpl.writeStr(txt, a_extName);
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ptr_"));
        txt = extFunctionName(txt, a_extName, a_language);
      then txt;
  end matchcontinue;
end fun_534;

protected function fun_535
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName, in_a_fname)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("==NULL) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE(\"dynamic external function "));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" not set!\")\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} else"));
      then txt;
  end matchcontinue;
end fun_535;

protected function lm_536
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArg(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_536(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_536(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_536;

protected function fun_537
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_537;

protected function fun_538
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extReturn, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_extReturn, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_538;

protected function lm_539
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunCallVarcopy(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_539(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_539(txt, rest);
      then txt;
  end matchcontinue;
end lm_539;

protected function fun_540
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)) )
      equation
        txt = extFunCallVarcopy(txt, i_extReturn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_540;

public function extFunCallC
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;
      Tpl.Text l_dynamicCheck;
      Tpl.Text l_fname;
      list<SimCode.SimExtArg> ret_1;
      Tpl.Text l_varDecs;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language, extReturn = i_extReturn),
           a_preExp,
           a_varDecls )
      equation
        ret_1 = List.union(i_extArgs, i_extArgs);
        l_varDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varDecs, a_varDecls) = lm_533(l_varDecs, ret_1, a_varDecls);
        l_varDecs = Tpl.popIter(l_varDecs);
        l_fname = fun_534(Tpl.emptyTxt, i_dynamicLoad, i_language, i_extName);
        l_dynamicCheck = fun_535(Tpl.emptyTxt, i_dynamicLoad, i_language, i_extName, l_fname);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_536(l_args, i_extArgs, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_537(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeText(txt, l_varDecs);
        txt = Tpl.softNewLine(txt);
        (txt, a_varDecls) = fun_538(txt, i_extReturn, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_dynamicCheck);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_539(txt, i_extArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_540(txt, i_extReturn);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCallC;

protected function lm_542
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardeclF77(txt, i_arg, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_542(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_542(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_542;

protected function lm_543
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Variable i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallBiVarF77(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_543(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_543(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_543;

protected function lm_544
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArgF77(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_544(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_544(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_544;

protected function fun_545
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_545;

protected function fun_546
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extReturn, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardeclF77(txt, i_extReturn, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_546;

protected function lm_547
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunCallVarcopyF77(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_547(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_547(txt, rest);
      then txt;
  end matchcontinue;
end lm_547;

protected function fun_548
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)) )
      equation
        txt = extFunCallVarcopyF77(txt, i_extReturn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_548;

public function extFunCallF77
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      String i_extName;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.Variable> i_biVars;
      list<SimCode.SimExtArg> i_extArgs;
      list<SimCode.SimExtArg> ret_5;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;
      Tpl.Text l_biVarDecs;
      list<SimCode.SimExtArg> ret_1;
      Tpl.Text l_varDecs;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, biVars = i_biVars, extReturn = i_extReturn, extName = i_extName),
           a_preExp,
           a_varDecls )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("/* extFunCallF77: varDecs */"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        ret_1 = List.union(i_extArgs, i_extArgs);
        l_varDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varDecs, a_varDecls) = lm_542(l_varDecs, ret_1, a_varDecls);
        l_varDecs = Tpl.popIter(l_varDecs);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("/* extFunCallF77: biVarDecs */"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("/* extFunCallF77: biVarDecs */"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        l_biVarDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_biVarDecs, a_varDecls, a_preExp) = lm_543(l_biVarDecs, i_biVars, a_varDecls, a_preExp);
        l_biVarDecs = Tpl.popIter(l_biVarDecs);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("/* extFunCallF77: args */"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("/* extFunCallF77: args */"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_544(l_args, i_extArgs, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_545(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeText(txt, l_varDecs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_biVarDecs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extFunCallF77: extReturn */\n"));
        (txt, a_varDecls) = fun_546(txt, i_extReturn, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extFunCallF77: CALL */\n"));
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_("));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "/* extFunCallF77: copy args */\n"
                                }, true));
        ret_5 = List.union(i_extArgs, i_extArgs);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_547(txt, ret_5);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extFunCallF77: copy return */\n"));
        txt = fun_548(txt, i_extReturn);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCallF77;

protected function fun_550
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_c, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      DAE.ExpType i_ty;

    case ( txt,
           DAE.ET_STRING(),
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_ty,
           a_c,
           a_varDecls )
      equation
        a_varDecls = extType(a_varDecls, i_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = extVarName(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = extType(txt, i_ty, true, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = contextCref(txt, a_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_550;

protected function fun_551
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input DAE.ExpType in_a_ty;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_oi, in_a_c, in_a_ty, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      DAE.ExpType a_ty;
      Tpl.Text a_varDecls;

    case ( txt,
           0,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_c,
           a_ty,
           a_varDecls )
      equation
        a_varDecls = extType(a_varDecls, a_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);
  end matchcontinue;
end fun_551;

public function extFunCallVardecl
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_arg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.ExpType i_ty;

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_550(txt, i_ty, i_c, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_551(txt, i_oi, i_c, i_ty, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end extFunCallVardecl;

protected function fun_553
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_default__val;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_default__val)
    local
      Tpl.Text txt;
      Tpl.Text a_default__val;

    case ( txt,
           "",
           _ )
      then txt;

    case ( txt,
           _,
           a_default__val )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = Tpl.writeText(txt, a_default__val);
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_553;

protected function fun_554
  input Tpl.Text in_txt;
  input Boolean in_a_ea_hasBinding;
  input Tpl.Text in_a_default__val;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ea_hasBinding, in_a_default__val)
    local
      Tpl.Text txt;
      Tpl.Text a_default__val;
      String str_0;

    case ( txt,
           false,
           a_default__val )
      equation
        str_0 = Tpl.textString(a_default__val);
        txt = fun_553(txt, str_0, a_default__val);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_554;

protected function fun_555
  input Tpl.Text in_txt;
  input Boolean in_a_ea_hasBinding;
  input DAE.ComponentRef in_a_c;
  input Integer in_a_oi;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ea_hasBinding, in_a_c, in_a_oi, in_a_ty)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer a_oi;
      DAE.ExpType a_ty;

    case ( txt,
           false,
           a_c,
           a_oi,
           a_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("convert_alloc_"));
        txt = expTypeArray(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_to_f77(&out.targ"));
        txt = Tpl.writeStr(txt, intString(a_oi));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = extVarName(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_555;

protected function fun_556
  input Tpl.Text in_txt;
  input Boolean in_a_ia;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;
  input Boolean in_a_ea_hasBinding;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ia, in_a_oi, in_a_c, in_a_varDecls, in_a_ea_hasBinding, in_a_ty)
    local
      Tpl.Text txt;
      Integer a_oi;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      Boolean a_ea_hasBinding;
      DAE.ExpType a_ty;
      Tpl.Text l_default__exp;
      Tpl.Text l_default__val;

    case ( txt,
           false,
           _,
           a_c,
           a_varDecls,
           a_ea_hasBinding,
           a_ty )
      equation
        l_default__val = typeDefaultValue(Tpl.emptyTxt, a_ty);
        l_default__exp = fun_554(Tpl.emptyTxt, a_ea_hasBinding, l_default__val);
        a_varDecls = extTypeF77(a_varDecls, a_ty, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeText(a_varDecls, l_default__exp);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_oi,
           a_c,
           a_varDecls,
           a_ea_hasBinding,
           a_ty )
      equation
        a_varDecls = expTypeArrayIf(a_varDecls, a_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = fun_555(txt, a_ea_hasBinding, a_c, a_oi, a_ty);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_556;

protected function fun_557
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;
  input Boolean in_a_ea_hasBinding;
  input DAE.ExpType in_a_ty;
  input Boolean in_a_ia;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_oi, in_a_c, in_a_varDecls, in_a_ea_hasBinding, in_a_ty, in_a_ia)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      Boolean a_ea_hasBinding;
      DAE.ExpType a_ty;
      Boolean a_ia;
      Integer i_oi;

    case ( txt,
           0,
           _,
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_oi,
           a_c,
           a_varDecls,
           a_ea_hasBinding,
           a_ty,
           a_ia )
      equation
        (txt, a_varDecls) = fun_556(txt, a_ia, i_oi, a_c, a_varDecls, a_ea_hasBinding, a_ty);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_557;

public function extFunCallVardeclF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_arg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Boolean i_ea_hasBinding;
      Boolean i_ia;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.ExpType i_ty;

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = true, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        a_varDecls = expTypeArrayIf(a_varDecls, i_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, i_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("convert_alloc_"));
        txt = expTypeArray(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_to_f77(&"));
        txt = contextCref(txt, i_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = i_ia, type_ = i_ty, cref = i_c, hasBinding = i_ea_hasBinding),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_557(txt, i_oi, i_c, a_varDecls, i_ea_hasBinding, i_ty, i_ia);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        a_varDecls = extTypeF77(a_varDecls, i_ty, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, i_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end extFunCallVardeclF77;

public function typeDefaultValue
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           DAE.ET_REAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0.0"));
      then txt;

    case ( txt,
           DAE.ET_BOOL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           DAE.ET_STRING() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end typeDefaultValue;

protected function fun_560
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_value, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v),
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_v, SimCode.contextFunction, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_560;

protected function lm_561
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_561(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_561(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_561;

protected function fun_562
  input Tpl.Text in_txt;
  input Tpl.Text in_a_defaultValue;
  input Tpl.Text in_a_var__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_defaultValue, in_a_var__name)
    local
      Tpl.Text txt;
      Tpl.Text a_var__name;
      Tpl.Text i_defaultValue;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           i_defaultValue,
           a_var__name )
      equation
        txt = Tpl.writeText(txt, a_var__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_562;

protected function fun_563
  input Tpl.Text in_txt;
  input Tpl.Text in_a_defaultValue;
  input Tpl.Text in_a_var__name;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_defaultValue, in_a_var__name, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_var__name;
      Tpl.Text a_type;
      Tpl.Text i_defaultValue;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           i_defaultValue,
           a_var__name,
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, i_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_var__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_563;

protected function fun_564
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.ComponentRef in_a_name;
  input Tpl.Text in_a_instDimsInit;
  input DAE.ExpType in_a_var_ty;
  input Tpl.Text in_a_var__name;
  input Tpl.Text in_a_defaultValue;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_instDims, in_a_name, in_a_instDimsInit, in_a_var_ty, in_a_var__name, in_a_defaultValue, in_a_preExp)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_name;
      Tpl.Text a_instDimsInit;
      DAE.ExpType a_var_ty;
      Tpl.Text a_var__name;
      Tpl.Text a_defaultValue;
      Tpl.Text a_preExp;
      list<DAE.Exp> i_instDims;
      Integer ret_1;
      Tpl.Text l_type;

    case ( txt,
           {},
           _,
           _,
           _,
           a_var__name,
           a_defaultValue,
           a_preExp )
      equation
        a_preExp = fun_562(a_preExp, a_defaultValue, a_var__name);
      then (txt, a_preExp);

    case ( txt,
           i_instDims,
           a_name,
           a_instDimsInit,
           a_var_ty,
           a_var__name,
           a_defaultValue,
           a_preExp )
      equation
        l_type = expTypeArray(Tpl.emptyTxt, a_var_ty);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, a_var__name);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        ret_1 = listLength(i_instDims);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_1));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_instDimsInit);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = fun_563(a_preExp, a_defaultValue, a_var__name, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("convert_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_to_f77(&"));
        a_preExp = Tpl.writeText(a_preExp, a_var__name);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = extVarName(a_preExp, a_name);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
      then (txt, a_preExp);
  end matchcontinue;
end fun_564;

public function extFunCallBiVarF77
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_var, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType i_var_ty;
      list<DAE.Exp> i_instDims;
      Option<DAE.Exp> i_value;
      SimCode.Variable i_var;
      DAE.ComponentRef i_name;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_defaultValue;
      Tpl.Text l_var__name;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name, value = i_value, instDims = i_instDims, ty = i_var_ty)),
           a_preExp,
           a_varDecls )
      equation
        l_var__name = contextCref(Tpl.emptyTxt, i_name, SimCode.contextFunction);
        a_varDecls = varType(a_varDecls, i_var);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = Tpl.writeText(a_varDecls, l_var__name);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_varDecls = varType(a_varDecls, i_var);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, i_name);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_preExp) = fun_560(Tpl.emptyTxt, i_value, a_varDecls, a_preExp);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_preExp) = lm_561(l_instDimsInit, i_instDims, a_varDecls, a_preExp);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_preExp) = fun_564(txt, i_instDims, i_name, l_instDimsInit, i_var_ty, l_var__name, l_defaultValue, a_preExp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCallBiVarF77;

protected function fun_566
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_cr;

    case ( txt,
           DAE.ET_STRING(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_scon("));
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
      then txt;
  end matchcontinue;
end fun_566;

protected function fun_567
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ExpType in_a_ty;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_ty, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ExpType a_ty;
      Tpl.Text a_cr;

    case ( txt,
           false,
           _,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_ty,
           a_cr )
      equation
        txt = fun_566(txt, a_ty, a_cr);
      then txt;
  end matchcontinue;
end fun_567;

protected function fun_568
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ExpType in_a_ty;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi, in_a_ty, in_a_c)
    local
      Tpl.Text txt;
      DAE.ExpType a_ty;
      DAE.ComponentRef a_c;
      Integer i_oi;
      Boolean ret_1;
      Tpl.Text l_cr;

    case ( txt,
           0,
           _,
           _ )
      then txt;

    case ( txt,
           i_oi,
           a_ty,
           a_c )
      equation
        l_cr = extVarName(Tpl.emptyTxt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.targ"));
        txt = Tpl.writeStr(txt, intString(i_oi));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = expTypeModelica(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_567(txt, ret_1, a_ty, l_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_568;

public function extFunCallVarcopy
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_arg)
    local
      Tpl.Text txt;
      DAE.ExpType i_ty;
      DAE.ComponentRef i_c;
      Integer i_oi;

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = i_ty, cref = i_c) )
      equation
        txt = fun_568(txt, i_oi, i_ty, i_c);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunCallVarcopy;

protected function fun_570
  input Tpl.Text in_txt;
  input Boolean in_a_ai;
  input Tpl.Text in_a_ext__name;
  input DAE.ExpType in_a_ty;
  input Tpl.Text in_a_outarg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ai, in_a_ext__name, in_a_ty, in_a_outarg)
    local
      Tpl.Text txt;
      Tpl.Text a_ext__name;
      DAE.ExpType a_ty;
      Tpl.Text a_outarg;

    case ( txt,
           false,
           a_ext__name,
           a_ty,
           a_outarg )
      equation
        txt = Tpl.writeText(txt, a_outarg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = expTypeModelica(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, a_ext__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           true,
           a_ext__name,
           a_ty,
           a_outarg )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("convert_alloc_"));
        txt = expTypeArray(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_from_f77(&"));
        txt = Tpl.writeText(txt, a_ext__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_outarg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_570;

protected function fun_571
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ExpType in_a_ty;
  input Boolean in_a_ai;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi, in_a_ty, in_a_ai, in_a_c)
    local
      Tpl.Text txt;
      DAE.ExpType a_ty;
      Boolean a_ai;
      DAE.ComponentRef a_c;
      Integer i_oi;
      Tpl.Text l_ext__name;
      Tpl.Text l_outarg;

    case ( txt,
           0,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_oi,
           a_ty,
           a_ai,
           a_c )
      equation
        l_outarg = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("out.targ"));
        l_outarg = Tpl.writeStr(l_outarg, intString(i_oi));
        l_ext__name = extVarName(Tpl.emptyTxt, a_c);
        txt = fun_570(txt, a_ai, l_ext__name, a_ty, l_outarg);
      then txt;
  end matchcontinue;
end fun_571;

public function extFunCallVarcopyF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_arg)
    local
      Tpl.Text txt;
      DAE.ExpType i_ty;
      Boolean i_ai;
      DAE.ComponentRef i_c;
      Integer i_oi;

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = i_ai, type_ = i_ty, cref = i_c) )
      equation
        txt = fun_571(txt, i_oi, i_ty, i_ai, i_c);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunCallVarcopyF77;

protected function fun_573
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_oi;

    case ( txt,
           0,
           a_c )
      equation
        txt = contextCref(txt, a_c, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_oi,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.targ"));
        txt = Tpl.writeStr(txt, intString(i_oi));
      then txt;
  end matchcontinue;
end fun_573;

protected function fun_574
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_t)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_STRING() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_574;

protected function fun_575
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_cr;

    case ( txt,
           DAE.ET_STRING(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_STRINGDATA("));
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_575;

protected function fun_576
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ExpType in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ExpType a_t;
      Tpl.Text a_cr;

    case ( txt,
           false,
           a_t,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = fun_574(txt, a_t);
      then txt;

    case ( txt,
           _,
           a_t,
           a_cr )
      equation
        txt = fun_575(txt, a_t, a_cr);
      then txt;
  end matchcontinue;
end fun_576;

protected function fun_577
  input Tpl.Text in_txt;
  input Integer in_a_outputIndex;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outputIndex, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_outputIndex;

    case ( txt,
           0,
           a_c )
      equation
        txt = contextCref(txt, a_c, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_outputIndex,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.targ"));
        txt = Tpl.writeStr(txt, intString(i_outputIndex));
      then txt;
  end matchcontinue;
end fun_577;

public function extArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extArg, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Integer i_outputIndex;
      DAE.ExpType i_type__;
      DAE.Exp i_exp;
      Boolean i_isInput;
      DAE.ExpType i_t;
      DAE.ComponentRef i_c;
      Integer i_oi;
      Tpl.Text l_dim;
      Tpl.Text l_typeStr;
      Boolean ret_3;
      Tpl.Text l_cr;
      Tpl.Text l_shortTypeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = i_oi, isArray = true, type_ = i_t, isInput = i_isInput),
           a_preExp,
           a_varDecls )
      equation
        l_name = fun_573(Tpl.emptyTxt, i_oi, i_c);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, i_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = extType(txt, i_t, i_isInput, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") data_of_"));
        txt = Tpl.writeText(txt, l_shortTypeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array(&("));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = 0, type_ = i_t),
           a_preExp,
           a_varDecls )
      equation
        l_cr = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        ret_3 = Config.acceptMetaModelicaGrammar();
        txt = fun_576(txt, ret_3, i_t, l_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = _, type_ = _),
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = extVarName(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp),
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExternalCExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, type_ = i_type__, outputIndex = i_outputIndex, exp = i_exp),
           a_preExp,
           a_varDecls )
      equation
        l_typeStr = expTypeShort(Tpl.emptyTxt, i_type__);
        l_name = fun_577(Tpl.emptyTxt, i_outputIndex, i_c);
        (l_dim, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_of_dimension_"));
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array("));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dim);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extArg;

protected function fun_579
  input Tpl.Text in_txt;
  input Integer in_a_oi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_579;

protected function fun_580
  input Tpl.Text in_txt;
  input Integer in_a_oi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_580;

public function extArgF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extArg, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType i_type__;
      DAE.Exp i_exp;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.ExpType i_t;
      Tpl.Text l_size__call;
      Tpl.Text l_dim;
      Tpl.Text l_sizeVar;
      Tpl.Text l_sizeVarName;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text l_tvar;
      Tpl.Text l_texp;
      Tpl.Text l_suffix;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isArray = true, type_ = i_t),
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data_of_"));
        txt = expTypeShort(txt, i_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array(&("));
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = i_oi, type_ = DAE.ET_INT()),
           a_preExp,
           a_varDecls )
      equation
        l_suffix = fun_579(Tpl.emptyTxt, i_oi);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int*) &"));
        txt = contextCref(txt, i_c, SimCode.contextFunction);
        txt = Tpl.writeText(txt, l_suffix);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = _, type_ = DAE.ET_STRING()),
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char*)"));
        txt = contextCref(txt, i_c, SimCode.contextFunction);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = i_oi, type_ = _),
           a_preExp,
           a_varDecls )
      equation
        l_suffix = fun_580(Tpl.emptyTxt, i_oi);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = contextCref(txt, i_c, SimCode.contextFunction);
        txt = Tpl.writeText(txt, l_suffix);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp, type_ = DAE.ET_STRING()),
           a_preExp,
           a_varDecls )
      equation
        (l_texp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt_3 = expTypeFromExpFlag(Tpl.emptyTxt, i_exp, 8);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_3), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_texp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char*)"));
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp),
           a_preExp,
           a_varDecls )
      equation
        (l_texp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt_4 = expTypeFromExpFlag(Tpl.emptyTxt, i_exp, 8);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_4), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_texp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, exp = i_exp, type_ = i_type__),
           a_preExp,
           a_varDecls )
      equation
        l_sizeVarName = tempSizeVarName(Tpl.emptyTxt, i_c, i_exp);
        (l_sizeVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "int", a_varDecls);
        (l_dim, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        l_size__call = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("size_of_dimension_"));
        l_size__call = expTypeShort(l_size__call, i_type__);
        l_size__call = Tpl.writeTok(l_size__call, Tpl.ST_STRING("_array"));
        a_preExp = Tpl.writeText(a_preExp, l_sizeVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_size__call);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = contextCref(a_preExp, i_c, SimCode.contextFunction);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_dim);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_sizeVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extArgF77;

protected function fun_582
  input Tpl.Text in_txt;
  input DAE.Exp in_a_indices;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_indices, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_integer;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           a_c )
      equation
        txt = contextCref(txt, a_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_size_"));
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("tempSizeVarName:UNHANDLED_EXPRESSION"));
      then txt;
  end matchcontinue;
end fun_582;

public function tempSizeVarName
  input Tpl.Text txt;
  input DAE.ComponentRef a_c;
  input DAE.Exp a_indices;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_582(txt, a_indices, a_c);
end tempSizeVarName;

protected function lm_584
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, SimCode.contextFunction, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_584(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_584(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_584;

public function funStatement
  input Tpl.Text in_txt;
  input SimCode.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           SimCode.ALGORITHM(statementLst = i_statementLst),
           a_varDecls )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_584(txt, i_statementLst, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED FUN STATEMENT"));
      then (txt, a_varDecls);
  end matchcontinue;
end funStatement;

protected function fun_586
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_s;

    case ( txt,
           (i_s as DAE.STMT_ASSIGN(exp1 = DAE.PATTERN(pattern = _))),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssignPattern(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_ASSIGN(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssign(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_ASSIGN_ARR(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssignArr(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_TUPLE_ASSIGN(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtTupleAssign(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_IF(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtIf(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_FOR(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtFor(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_WHILE(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtWhile(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_ASSERT(cond = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssert(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_TERMINATE(msg = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtTerminate(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_WHEN(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtWhen(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_BREAK(source = _),
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break;"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_FAILURE(body = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtFailure(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_TRY(tryBody = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtTry(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_CATCH(catchBody = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtCatch(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_THROW(source = _),
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_THROW();"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_RETURN(source = _),
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("goto _return;"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_NORETCALL(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtNoretcall(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_REINIT(var = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtReinit(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 3822, 14), "ALG_STATEMENT NYI");
      then (txt, a_varDecls);
  end matchcontinue;
end fun_586;

public function algStatement
  input Tpl.Text txt;
  input DAE.Statement a_stmt;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Absyn.Info ret_2;
  DAE.ElementSource ret_1;
  Tpl.Text l_res;
algorithm
  (l_res, out_a_varDecls) := fun_586(Tpl.emptyTxt, a_stmt, a_varDecls, a_context);
  ret_1 := Algorithm.getStatementSource(a_stmt);
  ret_2 := DAEUtil.getElementSourceFileInfo(ret_1);
  out_txt := modelicaLine(txt, ret_2);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_res);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := endModelicaLine(out_txt);
end algStatement;

protected function fun_588
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input DAE.Exp in_a_val;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_val, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      DAE.Exp a_val;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp i_idx;
      DAE.Exp i_arr;
      Tpl.Text l_val1;
      Tpl.Text l_idx1;
      Tpl.Text l_arr1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.ASUB(exp = i_arr, sub = {i_idx}),
           a_val,
           a_varDecls,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arr1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_arr, a_context, l_preExp, a_varDecls);
        (l_idx1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, a_context, l_preExp, a_varDecls);
        (l_val1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_val, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayUpdate("));
        txt = Tpl.writeText(txt, l_arr1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_idx1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_val1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_588;

protected function fun_589
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_exp1;
  input DAE.Exp in_a_val;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_exp1, in_a_val, in_a_varDecls, in_a_context, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp a_exp1;
      DAE.Exp a_val;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp a_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_varPart;
      Tpl.Text l_preExp;

    case ( txt,
           "metatype",
           _,
           a_val,
           a_varDecls,
           a_context,
           a_exp )
      equation
        (txt, a_varDecls) = fun_588(txt, a_exp, a_val, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_exp1,
           a_val,
           a_varDecls,
           a_context,
           _ )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = daeExpAsub(Tpl.emptyTxt, a_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_val, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_589;

public function algStmtAssign
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_val;
      DAE.Exp i_exp;
      DAE.Exp i_exp1;
      DAE.Exp i_e;
      Tpl.Text l_expPart2;
      Tpl.Text l_expPart1;
      String str_4;
      Tpl.Text txt_3;
      Tpl.Text l_varPart;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = DAE.CREF(componentRef = DAE.WILD()), exp = i_e),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(ty = DAE.ET_FUNCTION_REFERENCE_VAR())), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = (modelica_fnptr) "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(ty = DAE.ET_FUNCTION_REFERENCE_FUNC(builtin = _))), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = (modelica_fnptr) "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(componentRef = _)), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.ASUB(exp = _)), exp = (i_exp as i_val)),
           a_context,
           a_varDecls )
      equation
        txt_3 = expTypeFromExpShort(Tpl.emptyTxt, i_exp);
        str_4 = Tpl.textString(txt_3);
        (txt, a_varDecls) = fun_589(txt, str_4, i_exp1, i_val, a_varDecls, a_context, i_exp);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = i_exp1, exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtAssign;

protected function fun_591
  input Tpl.Text in_txt;
  input Tpl.Text in_a_ispec;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_expPart;
  input DAE.ExpType in_a_t;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ispec, in_a_varDecls, in_a_context, in_a_cr, in_a_expPart, in_a_t, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text a_expPart;
      DAE.ExpType a_t;
      Tpl.Text a_preExp;
      Tpl.Text i_ispec;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_varDecls,
           a_context,
           a_cr,
           a_expPart,
           a_t,
           a_preExp )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = copyArrayData(txt, a_t, Tpl.textString(a_expPart), a_cr, a_context);
      then (txt, a_varDecls);

    case ( txt,
           i_ispec,
           a_varDecls,
           a_context,
           a_cr,
           a_expPart,
           a_t,
           a_preExp )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        (txt, a_varDecls) = indexedAssign(txt, a_t, Tpl.textString(a_expPart), a_cr, Tpl.textString(i_ispec), a_context, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_591;

public function algStmtAssignArr
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ExpType i_t;
      DAE.ComponentRef i_cr;
      DAE.Exp i_e;
      Tpl.Text l_ispec;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_ASSIGN_ARR(exp = i_e, componentRef = i_cr, type_ = i_t),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, l_preExp, a_varDecls);
        (l_ispec, l_preExp, a_varDecls) = indexSpecFromCref(Tpl.emptyTxt, i_cr, a_context, l_preExp, a_varDecls);
        (txt, a_varDecls) = fun_591(txt, l_ispec, a_varDecls, a_context, i_cr, l_expPart, i_t, l_preExp);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtAssignArr;

protected function fun_593
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input String in_a_ispec;
  input Tpl.Text in_a_cref;
  input String in_a_exp;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_context, in_a_varDecls, in_a_ispec, in_a_cref, in_a_exp, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      String a_ispec;
      Tpl.Text a_cref;
      String a_exp;
      Tpl.Text a_type;
      Tpl.Text l_tmp;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_varDecls,
           a_ispec,
           a_cref,
           a_exp,
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("indexed_assign_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeStr(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_ispec);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_ispec,
           a_cref,
           a_exp,
           a_type )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "real_array", a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("indexed_assign_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeStr(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_ispec);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "copy_"
                                }, false));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_data_mem(&"));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_593;

public function indexedAssign
  input Tpl.Text txt;
  input DAE.ExpType a_ty;
  input String a_exp;
  input DAE.ComponentRef a_cr;
  input String a_ispec;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_cref;
  Tpl.Text l_type;
algorithm
  l_type := expTypeArray(Tpl.emptyTxt, a_ty);
  l_cref := contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
  (out_txt, out_a_varDecls) := fun_593(txt, a_context, a_varDecls, a_ispec, l_cref, a_exp, l_type);
end indexedAssign;

protected function fun_595
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_cref;
  input String in_a_exp;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cref, in_a_exp, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_cref;
      String a_exp;
      Tpl.Text a_type;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cref,
           a_exp,
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_data(&"));
        txt = Tpl.writeStr(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_cref,
           a_exp,
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_data_mem(&"));
        txt = Tpl.writeStr(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end matchcontinue;
end fun_595;

public function copyArrayData
  input Tpl.Text txt;
  input DAE.ExpType a_ty;
  input String a_exp;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_cref;
  Tpl.Text l_type;
algorithm
  l_type := expTypeArray(Tpl.emptyTxt, a_ty);
  l_cref := contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
  out_txt := fun_595(txt, a_context, l_cref, a_exp, l_type);
end copyArrayData;

protected function lm_597
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_597(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_597(txt, rest);
      then txt;
  end matchcontinue;
end lm_597;

protected function lm_598
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_retStruct;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context, in_a_retStruct)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      Tpl.Text a_retStruct;
      Integer x_i1;
      DAE.Exp i_cr;
      Tpl.Text l_rhsStr;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_cr :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_retStruct )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_rhsStr = Tpl.writeText(Tpl.emptyTxt, a_retStruct);
        l_rhsStr = Tpl.writeTok(l_rhsStr, Tpl.ST_STRING(".targ"));
        l_rhsStr = Tpl.writeStr(l_rhsStr, intString(x_i1));
        (txt, a_afterExp, a_varDecls) = writeLhsCref(txt, i_cr, Tpl.textString(l_rhsStr), a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_598(txt, rest, a_varDecls, a_afterExp, a_context, a_retStruct);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_retStruct )
      equation
        (txt, a_varDecls, a_afterExp) = lm_598(txt, rest, a_varDecls, a_afterExp, a_context, a_retStruct);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_598;

protected function lm_599
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_prefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      Tpl.Text a_prefix;
      Integer x_i1;
      DAE.Exp i_cr;
      Tpl.Text l_rhsStr;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_cr :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_prefix )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_rhsStr = Tpl.writeText(Tpl.emptyTxt, a_prefix);
        l_rhsStr = Tpl.writeTok(l_rhsStr, Tpl.ST_STRING("_targ"));
        l_rhsStr = Tpl.writeStr(l_rhsStr, intString(x_i1));
        (txt, a_afterExp, a_varDecls) = writeLhsCref(txt, i_cr, Tpl.textString(l_rhsStr), a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_599(txt, rest, a_varDecls, a_afterExp, a_context, a_prefix);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_prefix )
      equation
        (txt, a_varDecls, a_afterExp) = lm_599(txt, rest, a_varDecls, a_afterExp, a_context, a_prefix);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_599;

protected function fun_600
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "modelica_metatype" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = NULL"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_600;

protected function fun_601
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_rhsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_rhsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_rhsStr;

    case ( txt,
           "modelica_metatype",
           a_rhsStr )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = Tpl.writeText(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = Tpl.writeText(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_601;

protected function lm_602
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_prefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_prefix;
      Integer x_i1;
      DAE.Exp i_cr;
      String str_5;
      Tpl.Text l_addRoot;
      String str_3;
      Tpl.Text l_initVar;
      Tpl.Text l_typ;
      Tpl.Text l_rhsStr;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_cr :: rest,
           a_varDecls,
           a_prefix )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_rhsStr = Tpl.writeText(Tpl.emptyTxt, a_prefix);
        l_rhsStr = Tpl.writeTok(l_rhsStr, Tpl.ST_STRING("_targ"));
        l_rhsStr = Tpl.writeStr(l_rhsStr, intString(x_i1));
        l_typ = expTypeFromExpModelica(Tpl.emptyTxt, i_cr);
        str_3 = Tpl.textString(l_typ);
        l_initVar = fun_600(Tpl.emptyTxt, str_3);
        str_5 = Tpl.textString(l_typ);
        l_addRoot = fun_601(Tpl.emptyTxt, str_5, l_rhsStr);
        a_varDecls = Tpl.writeText(a_varDecls, l_typ);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = Tpl.writeText(a_varDecls, l_rhsStr);
        a_varDecls = Tpl.writeText(a_varDecls, l_initVar);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeText(a_varDecls, l_addRoot);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_602(txt, rest, a_varDecls, a_prefix);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_prefix )
      equation
        (txt, a_varDecls) = lm_602(txt, rest, a_varDecls, a_prefix);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_602;

public function algStmtTupleAssign
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      list<DAE.Exp> i_expExpLst;
      Tpl.Text l_0__;
      Integer ret_8;
      Tpl.Text l_prefix;
      Tpl.Text l_lhsCrefs;
      Tpl.Text l_retStruct;
      String ret_4;
      Tpl.Text l_marker;
      Tpl.Text l_crefs;
      Tpl.Text l_afterExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(exp = (i_exp as DAE.CALL(path = _)), expExpLst = i_expExpLst),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_afterExp = Tpl.emptyTxt;
        l_crefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_crefs = lm_597(l_crefs, i_expExpLst);
        l_crefs = Tpl.popIter(l_crefs);
        l_marker = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("("));
        l_marker = Tpl.writeText(l_marker, l_crefs);
        l_marker = Tpl.writeTok(l_marker, Tpl.ST_STRING(") = "));
        ret_4 = ExpressionDump.printExpStr(i_exp);
        l_marker = Tpl.writeStr(l_marker, ret_4);
        l_preExp = Tpl.writeTok(l_preExp, Tpl.ST_STRING("/* algStmtTupleAssign: preExp buffer created for "));
        l_preExp = Tpl.writeText(l_preExp, l_marker);
        l_preExp = Tpl.writeTok(l_preExp, Tpl.ST_STRING(" */"));
        l_preExp = Tpl.writeTok(l_preExp, Tpl.ST_NEW_LINE());
        l_afterExp = Tpl.writeTok(l_afterExp, Tpl.ST_STRING("/* algStmtTupleAssign: afterExp buffer created for "));
        l_afterExp = Tpl.writeText(l_afterExp, l_marker);
        l_afterExp = Tpl.writeTok(l_afterExp, Tpl.ST_STRING(" */"));
        l_afterExp = Tpl.writeTok(l_afterExp, Tpl.ST_NEW_LINE());
        (l_retStruct, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        l_lhsCrefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_lhsCrefs, a_varDecls, l_afterExp) = lm_598(l_lhsCrefs, i_expExpLst, a_varDecls, l_afterExp, a_context, l_retStruct);
        l_lhsCrefs = Tpl.popIter(l_lhsCrefs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* algStmtTupleAssign: preExp printout "));
        txt = Tpl.writeText(txt, l_marker);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("*/\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* algStmtTupleAssign: writeLhsCref "));
        txt = Tpl.writeText(txt, l_marker);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.writeText(txt, l_lhsCrefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* algStmtTupleAssign: afterExp printout "));
        txt = Tpl.writeText(txt, l_marker);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.writeText(txt, l_afterExp);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(exp = (i_exp as DAE.MATCHEXPRESSION(matchType = _)), expExpLst = i_expExpLst),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_afterExp = Tpl.emptyTxt;
        l_prefix = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("tmp"));
        ret_8 = System.tmpTick();
        l_prefix = Tpl.writeStr(l_prefix, intString(ret_8));
        (l_0__, l_prefix, l_preExp, a_varDecls) = daeExpMatch2(Tpl.emptyTxt, i_exp, i_expExpLst, l_prefix, a_context, l_preExp, a_varDecls);
        l_lhsCrefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_lhsCrefs, a_varDecls, l_afterExp) = lm_599(l_lhsCrefs, i_expExpLst, a_varDecls, l_afterExp, a_context, l_prefix);
        l_lhsCrefs = Tpl.popIter(l_lhsCrefs);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_602(txt, i_expExpLst, a_varDecls, l_prefix);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_lhsCrefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_afterExp);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 3989, 12), "algStmtTupleAssign failed");
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtTupleAssign;

protected function fun_604
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_lhsStr;
  input String in_a_rhsStr;
  input DAE.ExpType in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_lhsStr, in_a_rhsStr, in_a_t)
    local
      Tpl.Text txt;
      Tpl.Text a_lhsStr;
      String a_rhsStr;
      DAE.ExpType a_t;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           a_lhsStr,
           a_rhsStr,
           a_t )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data_mem(&"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_lhsStr,
           a_rhsStr,
           _ )
      equation
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_604;

protected function fun_605
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_lhsStr;
  input String in_a_rhsStr;
  input DAE.ExpType in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_lhsStr, in_a_rhsStr, in_a_t)
    local
      Tpl.Text txt;
      Tpl.Text a_lhsStr;
      String a_rhsStr;
      DAE.ExpType a_t;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           a_lhsStr,
           a_rhsStr,
           a_t )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("usub_"));
        txt = expTypeShort(txt, a_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array(&"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "copy_"
                                }, false));
        txt = expTypeShort(txt, a_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data_mem(&"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_lhsStr,
           a_rhsStr,
           _ )
      equation
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = -"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_605;

public function writeLhsCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input String in_a_rhsStr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_rhsStr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_rhsStr;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_e;
      DAE.ExpType i_t;
      DAE.Exp i_exp;
      String ret_1;
      Tpl.Text l_lhsStr;

    case ( txt,
           DAE.CREF(componentRef = DAE.WILD()),
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CREF(ty = (i_t as DAE.ET_ARRAY(ty = _)))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = fun_604(txt, a_context, l_lhsStr, a_rhsStr, i_t);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UNARY(exp = (i_e as DAE.CREF(ty = (i_t as DAE.ET_ARRAY(ty = _))))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        txt = fun_605(txt, a_context, l_lhsStr, a_rhsStr, i_t);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CREF(componentRef = _)),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UNARY(exp = (i_e as DAE.CREF(componentRef = _))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = -"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_rhsStr,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* SimCodeC.tpl template: writeLhsCref: UNHANDLED LHS\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* "));
        ret_1 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
        txt = Tpl.popBlock(txt);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end writeLhsCref;

protected function lm_607
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_607(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_607(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_607;

public function algStmtIf
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_condExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_IF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_607(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        (txt, a_varDecls) = elseExpr(txt, i_else__, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtIf;

public function algStmtFor
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Statement i_s;

    case ( txt,
           (i_s as DAE.STMT_FOR(range = DAE.RANGE(ty = _))),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStmtForRange(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_FOR(type_ = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStmtForGeneric(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtFor;

protected function lm_610
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_610(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_610(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_610;

public function algStmtForRange
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Ident i_iter;
      DAE.Exp i_rng;
      list<DAE.Statement> i_statementLst;
      Boolean i_iterIsArray;
      DAE.ExpType i_type__;
      Tpl.Text l_stmtStr;
      Tpl.Text l_identTypeShort;
      Tpl.Text l_identType;

    case ( txt,
           DAE.STMT_FOR(range = (i_rng as DAE.RANGE(ty = _)), type_ = i_type__, iterIsArray = i_iterIsArray, statementLst = i_statementLst, iter = i_iter),
           a_context,
           a_varDecls )
      equation
        l_identType = expType(Tpl.emptyTxt, i_type__, i_iterIsArray);
        l_identTypeShort = expTypeShort(Tpl.emptyTxt, i_type__);
        l_stmtStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtStr, a_varDecls) = lm_610(l_stmtStr, i_statementLst, a_varDecls, a_context);
        l_stmtStr = Tpl.popIter(l_stmtStr);
        (txt, l_stmtStr, a_varDecls) = algStmtForRange_impl(txt, i_rng, i_iter, Tpl.textString(l_identType), Tpl.textString(l_identTypeShort), l_stmtStr, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtForRange;

protected function fun_612
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_612;

protected function fun_613
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_expOption;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_expOption, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_eo;

    case ( txt,
           SOME(i_eo),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_eo, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1)"));
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_613;

protected function fun_614
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_614;

protected function fun_615
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_615;

protected function fun_616
  input Tpl.Text in_txt;
  input DAE.Exp in_a_range;
  input Absyn.Ident in_a_iterator;
  input String in_a_type;
  input String in_a_shortType;
  input Tpl.Text in_a_body;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_range, in_a_iterator, in_a_type, in_a_shortType, in_a_body, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      Absyn.Ident a_iterator;
      String a_type;
      String a_shortType;
      Tpl.Text a_body;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_range;
      Option<DAE.Exp> i_expOption;
      DAE.Exp i_exp;
      Boolean ret_11;
      Boolean ret_10;
      Tpl.Text l_stopValue;
      Tpl.Text l_stepValue;
      Tpl.Text l_startValue;
      Tpl.Text l_preExp;
      Tpl.Text l_stopVar;
      Tpl.Text l_stepVar;
      Tpl.Text l_startVar;
      Boolean ret_2;
      Tpl.Text l_stateVar;
      Tpl.Text l_iterName;

    case ( txt,
           DAE.RANGE(exp = i_exp, expOption = i_expOption, range = i_range),
           a_iterator,
           a_type,
           a_shortType,
           a_body,
           a_context,
           a_varDecls )
      equation
        l_iterName = contextIteratorName(Tpl.emptyTxt, a_iterator, a_context);
        ret_2 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, a_varDecls) = fun_612(Tpl.emptyTxt, ret_2, a_varDecls);
        (l_startVar, a_varDecls) = tempDecl(Tpl.emptyTxt, a_type, a_varDecls);
        (l_stepVar, a_varDecls) = tempDecl(Tpl.emptyTxt, a_type, a_varDecls);
        (l_stopVar, a_varDecls) = tempDecl(Tpl.emptyTxt, a_type, a_varDecls);
        l_preExp = Tpl.emptyTxt;
        (l_startValue, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        (l_stepValue, a_varDecls, l_preExp) = fun_613(Tpl.emptyTxt, i_expOption, a_varDecls, l_preExp, a_context);
        (l_stopValue, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_range, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_startVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_stepValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.writeText(txt, l_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_stopValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "if (!"
                                }, false));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ") {\n",
                                    "  omc_fileInfo info = omc_dummyFileInfo;\n",
                                    "  MODELICA_ASSERT(info, \"assertion range step != 0 failed\");\n",
                                    "} else if (!((("
                                }, false));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > 0) && ("));
        txt = Tpl.writeText(txt, l_startVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, l_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) || (("));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < 0) && ("));
        txt = Tpl.writeText(txt, l_startVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, l_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")))) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "for ("
                                }, false));
        txt = Tpl.writeText(txt, l_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; in_range_"));
        txt = Tpl.writeStr(txt, a_shortType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_startVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); "));
        txt = Tpl.writeText(txt, l_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" += "));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_10 = Config.acceptMetaModelicaGrammar();
        txt = fun_614(txt, ret_10, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_body);
        txt = Tpl.softNewLine(txt);
        ret_11 = Config.acceptMetaModelicaGrammar();
        txt = fun_615(txt, ret_11, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_616;

public function algStmtForRange_impl
  input Tpl.Text txt;
  input DAE.Exp a_range;
  input Absyn.Ident a_iterator;
  input String a_type;
  input String a_shortType;
  input Tpl.Text a_body;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_body;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_616(txt, a_range, a_iterator, a_type, a_shortType, a_body, a_context, a_varDecls);
  out_a_body := a_body;
end algStmtForRange_impl;

protected function lm_618
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_618(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_618(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_618;

public function algStmtForGeneric
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Ident i_iter;
      DAE.Exp i_range;
      list<DAE.Statement> i_statementLst;
      Boolean i_iterIsArray;
      DAE.ExpType i_type__;
      Tpl.Text l_stmtStr;
      Tpl.Text l_arrayType;
      Tpl.Text l_iterType;

    case ( txt,
           DAE.STMT_FOR(type_ = i_type__, iterIsArray = i_iterIsArray, statementLst = i_statementLst, range = i_range, iter = i_iter),
           a_context,
           a_varDecls )
      equation
        l_iterType = expType(Tpl.emptyTxt, i_type__, i_iterIsArray);
        l_arrayType = expTypeArray(Tpl.emptyTxt, i_type__);
        l_stmtStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtStr, a_varDecls) = lm_618(l_stmtStr, i_statementLst, a_varDecls, a_context);
        l_stmtStr = Tpl.popIter(l_stmtStr);
        (txt, l_stmtStr, a_varDecls) = algStmtForGeneric_impl(txt, i_range, i_iter, Tpl.textString(l_iterType), Tpl.textString(l_arrayType), i_iterIsArray, l_stmtStr, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtForGeneric;

protected function fun_620
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_620;

protected function fun_621
  input Tpl.Text in_txt;
  input Boolean in_a_iterIsArray;
  input Tpl.Text in_a_ivar;
  input String in_a_type;
  input Tpl.Text in_a_tvar;
  input Tpl.Text in_a_evar;
  input String in_a_arrayType;
  input Tpl.Text in_a_iterName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_iterIsArray, in_a_ivar, in_a_type, in_a_tvar, in_a_evar, in_a_arrayType, in_a_iterName)
    local
      Tpl.Text txt;
      Tpl.Text a_ivar;
      String a_type;
      Tpl.Text a_tvar;
      Tpl.Text a_evar;
      String a_arrayType;
      Tpl.Text a_iterName;

    case ( txt,
           false,
           _,
           _,
           a_tvar,
           a_evar,
           a_arrayType,
           a_iterName )
      equation
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = *("));
        txt = Tpl.writeStr(txt, a_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_element_addr1(&"));
        txt = Tpl.writeText(txt, a_evar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", 1, "));
        txt = Tpl.writeText(txt, a_tvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
      then txt;

    case ( txt,
           _,
           a_ivar,
           a_type,
           a_tvar,
           a_evar,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("simple_index_alloc_"));
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1(&"));
        txt = Tpl.writeText(txt, a_evar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_tvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_ivar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end matchcontinue;
end fun_621;

protected function fun_622
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_622;

protected function fun_623
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_623;

public function algStmtForGeneric_impl
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input Absyn.Ident a_iterator;
  input String a_type;
  input String a_arrayType;
  input Boolean a_iterIsArray;
  input Tpl.Text a_body;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_body;
  output Tpl.Text out_a_varDecls;
protected
  Boolean ret_9;
  Boolean ret_8;
  Tpl.Text l_stmtStuff;
  Tpl.Text l_evar;
  Tpl.Text l_preExp;
  Tpl.Text l_ivar;
  Tpl.Text l_tvar;
  Boolean ret_2;
  Tpl.Text l_stateVar;
  Tpl.Text l_iterName;
algorithm
  l_iterName := contextIteratorName(Tpl.emptyTxt, a_iterator, a_context);
  ret_2 := Config.acceptMetaModelicaGrammar();
  (l_stateVar, out_a_varDecls) := fun_620(Tpl.emptyTxt, ret_2, a_varDecls);
  (l_tvar, out_a_varDecls) := tempDecl(Tpl.emptyTxt, "int", out_a_varDecls);
  (l_ivar, out_a_varDecls) := tempDecl(Tpl.emptyTxt, a_type, out_a_varDecls);
  l_preExp := Tpl.emptyTxt;
  (l_evar, l_preExp, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_exp, a_context, l_preExp, out_a_varDecls);
  l_stmtStuff := fun_621(Tpl.emptyTxt, a_iterIsArray, l_ivar, a_type, l_tvar, l_evar, a_arrayType, l_iterName);
  out_txt := Tpl.writeText(txt, l_preExp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("{\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeStr(out_txt, a_type);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeText(out_txt, l_iterName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";\n",
                                       "\n",
                                       "for("
                                   }, false));
  out_txt := Tpl.writeText(out_txt, l_tvar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" = 1; "));
  out_txt := Tpl.writeText(out_txt, l_tvar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" <= size_of_dimension_"));
  out_txt := Tpl.writeStr(out_txt, a_arrayType);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("("));
  out_txt := Tpl.writeText(out_txt, l_evar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(", 1); ++"));
  out_txt := Tpl.writeText(out_txt, l_tvar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(") {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_8 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_622(out_txt, ret_8, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_stmtStuff);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, a_body);
  out_txt := Tpl.softNewLine(out_txt);
  ret_9 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_623(out_txt, ret_9, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("}\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
  out_a_body := a_body;
end algStmtForGeneric_impl;

protected function lm_625
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_625(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_625(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_625;

public function algStmtWhile
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_var;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_WHILE(exp = i_exp, statementLst = i_statementLst),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_var, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("while (1) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (!"));
        txt = Tpl.writeText(txt, l_var);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") break;\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_625(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtWhile;

public function algStmtAssert
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_msg;
      DAE.Exp i_cond;

    case ( txt,
           DAE.STMT_ASSERT(source = DAE.SOURCE(info = i_info), cond = i_cond, msg = i_msg),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = assertCommon(txt, i_cond, i_msg, a_context, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtAssert;

public function algStmtTerminate
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_msg;
      Tpl.Text l_msgVar;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_TERMINATE(msg = i_msg),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_msg, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE("));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtTerminate;

protected function lm_629
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varAssign, in_a_preExp, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varAssign;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Tpl.Text l_lhs;
      Tpl.Text txt_1;
      Tpl.Text l_decl;

    case ( txt,
           {},
           a_varAssign,
           a_preExp,
           _,
           a_varDecls )
      then (txt, a_varAssign, a_preExp, a_varDecls);

    case ( txt,
           i_exp :: rest,
           a_varAssign,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        txt_1 = expTypeFromExpModelica(Tpl.emptyTxt, i_exp);
        (l_decl, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        (l_lhs, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        a_varAssign = Tpl.writeText(a_varAssign, l_decl);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = Tpl.writeText(a_varAssign, l_lhs);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_lhs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_decl);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varAssign, a_preExp, a_varDecls) = lm_629(txt, rest, a_varAssign, a_preExp, a_context, a_varDecls);
      then (txt, a_varAssign, a_preExp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varAssign,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        (txt, a_varAssign, a_preExp, a_varDecls) = lm_629(txt, rest, a_varAssign, a_preExp, a_context, a_varDecls);
      then (txt, a_varAssign, a_preExp, a_varDecls);
  end matchcontinue;
end lm_629;

public function algStmtMatchcasesVarDeclsAndAssign
  input Tpl.Text txt;
  input list<DAE.Exp> a_expList;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varAssign;
  input Tpl.Text a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_preExp;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varAssign, out_a_preExp, out_a_varDecls) := lm_629(out_txt, a_expList, a_varAssign, a_preExp, a_context, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end algStmtMatchcasesVarDeclsAndAssign;

protected function lm_631
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_631(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_631(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_631;

public function algStmtFailure
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_body;
      Tpl.Text l_stmtBody;
      Tpl.Text l_tmp;

    case ( txt,
           DAE.STMT_FAILURE(body = i_body),
           a_context,
           a_varDecls )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        l_stmtBody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtBody, a_varDecls) = lm_631(l_stmtBody, i_body, a_varDecls, a_context);
        l_stmtBody = Tpl.popIter(l_stmtBody);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = 0; /* begin failure */\n",
                                    "MMC_TRY()\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_stmtBody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" = 1;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MMC_CATCH()\n",
                                    "if ("
                                }, false));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") MMC_THROW(); /* end failure */"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtFailure;

protected function lm_633
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_633(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_633(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_633;

public function algStmtTry
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_tryBody;
      Tpl.Text l_body;

    case ( txt,
           DAE.STMT_TRY(tryBody = i_tryBody),
           a_context,
           a_varDecls )
      equation
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, a_varDecls) = lm_633(l_body, i_tryBody, a_varDecls, a_context);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#error \"Using STMT_TRY: This is deprecated, and should be matched with catch anyway.\"\n",
                                    "try {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtTry;

protected function lm_635
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_635(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_635(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_635;

public function algStmtCatch
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_catchBody;
      Tpl.Text l_body;

    case ( txt,
           DAE.STMT_CATCH(catchBody = i_catchBody),
           a_context,
           a_varDecls )
      equation
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, a_varDecls) = lm_635(l_body, i_catchBody, a_varDecls, a_context);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#error \"Using STMT_CATCH: This is deprecated, and should be matched with catch anyway.\"\n",
                                    "catch (int i) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtCatch;

public function algStmtNoretcall
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_NORETCALL(exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtNoretcall;

protected function lm_638
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_638(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_638(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_638;

protected function lm_639
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_idx :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !localData->helpVars_saved["));
        txt = Tpl.writeStr(txt, intString(i_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        txt = lm_639(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_639(txt, rest);
      then txt;
  end matchcontinue;
end lm_639;

protected function fun_640
  input Tpl.Text in_txt;
  input DAE.Statement in_a_when;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_when, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<Integer> i_helpVarIndices;
      Option<DAE.Statement> i_elseWhen;
      list<DAE.Statement> i_statementLst;
      DAE.Statement i_when;
      Tpl.Text l_else;
      Tpl.Text l_statements;
      Tpl.Text l_preIf;

    case ( txt,
           (i_when as DAE.STMT_WHEN(statementLst = i_statementLst, elseWhen = i_elseWhen, helpVarIndices = i_helpVarIndices)),
           a_context,
           a_varDecls )
      equation
        (l_preIf, a_varDecls) = algStatementWhenPre(Tpl.emptyTxt, i_when, a_varDecls);
        l_statements = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_statements, a_varDecls) = lm_638(l_statements, i_statementLst, a_varDecls, a_context);
        l_statements = Tpl.popIter(l_statements);
        (l_else, a_varDecls) = algStatementWhenElse(Tpl.emptyTxt, i_elseWhen, a_varDecls);
        txt = Tpl.writeText(txt, l_preIf);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_639(txt, i_helpVarIndices);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_else);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_640;

protected function fun_641
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Statement in_a_when;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_context, in_a_when, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Statement a_when;
      Tpl.Text a_varDecls;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.SIMULATION(genDiscrete = true)),
           a_when,
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_640(txt, a_when, i_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_641;

public function algStmtWhen
  input Tpl.Text txt;
  input DAE.Statement a_when;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_641(txt, a_context, a_when, a_varDecls);
end algStmtWhen;

protected function fun_643
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_elseWhen;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_elseWhen, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Statement i_ew;

    case ( txt,
           SOME(i_ew),
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatementWhenPre(txt, i_ew, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_643;

protected function fun_644
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_when_elseWhen;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_when_elseWhen, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Statement i_ew;

    case ( txt,
           SOME(i_ew),
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatementWhenPre(txt, i_ew, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_644;

protected function fun_645
  input Tpl.Text in_txt;
  input list<Integer> in_a_helpVarIndices;
  input DAE.Exp in_a_when_exp;
  input Tpl.Text in_a_varDecls;
  input Option<DAE.Statement> in_a_when_elseWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_helpVarIndices, in_a_when_exp, in_a_varDecls, in_a_when_elseWhen)
    local
      Tpl.Text txt;
      DAE.Exp a_when_exp;
      Tpl.Text a_varDecls;
      Option<DAE.Statement> a_when_elseWhen;
      Integer i_i;
      Tpl.Text l_res;
      Tpl.Text l_preExp;
      Tpl.Text l_restPre;

    case ( txt,
           {i_i},
           a_when_exp,
           a_varDecls,
           a_when_elseWhen )
      equation
        (l_restPre, a_varDecls) = fun_644(Tpl.emptyTxt, a_when_elseWhen, a_varDecls);
        l_preExp = Tpl.emptyTxt;
        (l_res, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_when_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_res);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, l_restPre);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_645;

public function algStatementWhenPre
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Exp i_when_exp;
      Option<DAE.Statement> i_when_elseWhen;
      list<Integer> i_helpVarIndices;
      list<DAE.Exp> i_el;
      Option<DAE.Statement> i_elseWhen;
      Tpl.Text l_assignments;
      Tpl.Text l_preExp;
      Tpl.Text l_restPre;

    case ( txt,
           DAE.STMT_WHEN(exp = DAE.ARRAY(array = i_el), elseWhen = i_elseWhen, helpVarIndices = i_helpVarIndices),
           a_varDecls )
      equation
        (l_restPre, a_varDecls) = fun_643(Tpl.emptyTxt, i_elseWhen, a_varDecls);
        l_preExp = Tpl.emptyTxt;
        (l_assignments, l_preExp, a_varDecls) = algStatementWhenPreAssigns(Tpl.emptyTxt, i_el, i_helpVarIndices, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_assignments);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_restPre);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_WHEN(helpVarIndices = i_helpVarIndices, elseWhen = i_when_elseWhen, exp = i_when_exp),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_645(txt, i_helpVarIndices, i_when_exp, a_varDecls, i_when_elseWhen);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStatementWhenPre;

protected function lm_647
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, SimCode.contextSimulationDiscrete, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_647(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_647(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_647;

protected function lm_648
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_hidx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_hidx :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !localData->helpVars_saved["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        txt = lm_648(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_648(txt, rest);
      then txt;
  end matchcontinue;
end lm_648;

public function algStatementWhenElse
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_stmt;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<Integer> i_when_helpVarIndices;
      Option<DAE.Statement> i_when_elseWhen;
      list<DAE.Statement> i_when_statementLst;
      Tpl.Text l_elseCondStr;
      Tpl.Text l_else;
      Tpl.Text l_statements;

    case ( txt,
           SOME(DAE.STMT_WHEN(statementLst = i_when_statementLst, elseWhen = i_when_elseWhen, helpVarIndices = i_when_helpVarIndices)),
           a_varDecls )
      equation
        l_statements = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_statements, a_varDecls) = lm_647(l_statements, i_when_statementLst, a_varDecls);
        l_statements = Tpl.popIter(l_statements);
        (l_else, a_varDecls) = algStatementWhenElse(Tpl.emptyTxt, i_when_elseWhen, a_varDecls);
        l_elseCondStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elseCondStr = lm_648(l_elseCondStr, i_when_helpVarIndices);
        l_elseCondStr = Tpl.popIter(l_elseCondStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if ("));
        txt = Tpl.writeText(txt, l_elseCondStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_else);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStatementWhenElse;

protected function fun_650
  input Tpl.Text in_txt;
  input list<Integer> in_a_ints;
  input DAE.Exp in_a_firstExp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input list<DAE.Exp> in_a_restExps;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_ints, in_a_firstExp, in_a_varDecls, in_a_preExp, in_a_restExps)
    local
      Tpl.Text txt;
      DAE.Exp a_firstExp;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      list<DAE.Exp> a_restExps;
      Integer i_firstInt;
      list<Integer> i_restInts;
      Tpl.Text l_firstExpPart;
      Tpl.Text l_rest;

    case ( txt,
           i_firstInt :: i_restInts,
           a_firstExp,
           a_varDecls,
           a_preExp,
           a_restExps )
      equation
        (l_rest, a_preExp, a_varDecls) = algStatementWhenPreAssigns(Tpl.emptyTxt, a_restExps, i_restInts, a_preExp, a_varDecls);
        (l_firstExpPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_firstExp, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_firstInt));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_firstExpPart);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, l_rest);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_650;

public function algStatementWhenPreAssigns
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_exps;
  input list<Integer> in_a_ints;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exps, in_a_ints, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<Integer> a_ints;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_firstExp;
      list<DAE.Exp> i_restExps;

    case ( txt,
           {},
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_firstExp :: i_restExps,
           a_ints,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_650(txt, a_ints, i_firstExp, a_varDecls, a_preExp, i_restExps);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end algStatementWhenPreAssigns;

public function algStmtReinit
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_value;
      DAE.Exp i_var;
      Tpl.Text l_expPart2;
      Tpl.Text l_expPart1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_REINIT(var = i_var, value = i_value),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_var, a_context, l_preExp, a_varDecls);
        (l_expPart2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("if (sim_verbose >= LOG_EVENTS) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"reinit "));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = %f\\n\", "));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "$P$PRE"
                                }, false));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtReinit;

public function indexSpecFromCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_cr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Subscript> i_subs;

    case ( txt,
           DAE.CREF_IDENT(subscriptLst = (i_subs as _ :: _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhsIndexSpec(txt, i_subs, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end indexSpecFromCref;

protected function lm_654
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_654(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_654(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_654;

protected function lm_655
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_655(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_655(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_655;

public function elseExpr
  input Tpl.Text in_txt;
  input DAE.Else in_a_else__;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_else__, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_condExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.NOELSE(),
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           DAE.ELSEIF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_654(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        (txt, a_varDecls) = elseExpr(txt, i_else__, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.ELSE(statementLst = i_statementLst),
           a_context,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_655(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end elseExpr;

protected function fun_657
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr_componentRef, in_a_varDecls, in_a_preExp, in_a_context, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_ecr;

    case ( txt,
           false,
           _,
           a_varDecls,
           a_preExp,
           a_context,
           a_ecr )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefLhs(txt, a_ecr, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_varDecls,
           a_preExp,
           a_context,
           _ )
      equation
        txt = contextCref(txt, a_ecr_componentRef, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_657;

public function scalarLhsCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_ecr;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.ComponentRef i_cr;
      Boolean ret_0;

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.ET_FUNCTION_REFERENCE_VAR()),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*((modelica_fnptr*)&_"));
        txt = crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_IDENT(ident = _)))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        ret_0 = SimCode.crefNoSub(i_ecr_componentRef);
        (txt, a_varDecls, a_preExp) = fun_657(txt, ret_0, i_ecr_componentRef, a_varDecls, a_preExp, a_context, i_ecr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_QUAL(ident = _))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        txt = contextCref(txt, i_ecr_componentRef, a_context);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = DAE.WILD()),
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ONLY_IDENT_OR_QUAL_CREF_SUPPORTED_SLHS"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end scalarLhsCref;

public function rhsCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr, in_a_ty)
    local
      Tpl.Text txt;
      DAE.ExpType a_ty;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident),
           a_ty )
      equation
        txt = rhsCrefType(txt, a_ty);
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef),
           a_ty )
      equation
        txt = rhsCrefType(txt, a_ty);
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = rhsCref(txt, i_componentRef, a_ty);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rhsCref:ERROR"));
      then txt;
  end matchcontinue;
end rhsCref;

public function rhsCrefType
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           DAE.ET_ENUMERATION(path = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end rhsCrefType;

protected function fun_661
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(0)"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1)"));
      then txt;
  end matchcontinue;
end fun_661;

public function daeExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Exp i_e;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer) "));
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.RCONST(real = i_real),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SCONST(string = i_string),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSconst(txt, i_string, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.BCONST(bool = i_bool),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = fun_661(txt, i_bool);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CREF(componentRef = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.BINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpBinary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.UNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LBINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLbinary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LUNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLunary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.RELATION(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRelation(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.IFEXP(expCond = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpIf(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CALL(path = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCall(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ARRAY(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpArray(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.MATRIX(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMatrix(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.RANGE(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRange(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CAST(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCast(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ASUB(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpAsub(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.TSUB(exp = i_exp),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targ1"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.SIZE(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSize(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.REDUCTION(reductionInfo = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpReduction(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LIST(valList = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpList(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CONS(car = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCons(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.META_TUPLE(listExp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMetaTuple(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.META_OPTION(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMetaOption(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.METARECORDCALL(path = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMetarecordcall(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.MATCHEXPRESSION(matchType = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMatch(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.BOX(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpBox(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.UNBOX(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnbox(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.SHARED_LITERAL(index = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSharedLiteral(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown expression: "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 4513, 14), Tpl.textString(txt_0));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExp;

protected function fun_663
  input Tpl.Text in_txt;
  input DAE.ExpType in_mArg;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType ret_2;
      DAE.ExpType ret_1;
      Tpl.Text l_shortTypeStr;

    case ( txt,
           DAE.ET_ARRAY(ty = _),
           a_exp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        ret_1 = Expression.typeof(a_exp);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        ret_2 = Expression.typeof(a_exp);
        txt = extType(txt, ret_2, true, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") data_of_"));
        txt = Tpl.writeText(txt, l_shortTypeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array(&"));
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_exp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_663;

public function daeExternalCExp
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  DAE.ExpType ret_0;
algorithm
  ret_0 := Expression.typeof(a_exp);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_663(txt, ret_0, a_exp, a_context, a_preExp, a_varDecls);
end daeExternalCExp;

public function daeExpSconst
  input Tpl.Text txt;
  input String a_string;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("\""));
  ret_0 := Util.escapeModelicaStringToCString(a_string);
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpSconst;

protected function fun_666
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.ExpType in_a_t;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_context, in_a_cr, in_a_t, in_a_varDecls, in_a_preExp, in_a_exp)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      DAE.ExpType a_t;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp a_exp;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           _,
           a_varDecls,
           a_preExp,
           a_exp )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs2(txt, a_exp, i_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_cr,
           a_t,
           a_varDecls,
           a_preExp,
           _ )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRecordCrefRhs(txt, a_t, a_cr, i_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_666;

public function daeExpCrefRhs
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cr;
      DAE.ExpType i_t;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.CREF(componentRef = i_cr, ty = (i_t as DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = _))))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_666(txt, a_context, i_cr, i_t, a_varDecls, a_preExp, i_exp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.ET_FUNCTION_REFERENCE_FUNC(builtin = _)),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr)boxptr_"));
        txt = crefFunctionName(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.ET_FUNCTION_REFERENCE_VAR()),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr) _"));
        txt = crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs2(txt, i_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCrefRhs;

protected function lm_668
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_668(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_668(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_668;

protected function lm_669
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_669(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_669(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_669;

protected function fun_670
  input Tpl.Text in_txt;
  input DAE.ExpType in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr, in_a_arrName)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text a_arrName;
      list<DAE.Dimension> i_et_arrayDimensions;
      Tpl.Text txt_1;
      String ret_1;
      list<DAE.Subscript> ret_0;

    case ( txt,
           DAE.ET_ARRAY(arrayDimensions = i_et_arrayDimensions),
           _,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")["));
        ret_0 = ComponentReference.crefSubs(a_cr);
        (txt, a_preExp, a_varDecls) = threadDimSubList(txt, i_et_arrayDimensions, ret_0, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr,
           a_varDecls,
           a_preExp,
           _,
           _,
           _ )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Indexing non-array "));
        ret_1 = ExpressionDump.printExpStr(a_ecr);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 4607, 28), Tpl.textString(txt_1));
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_670;

protected function fun_671
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_dimsLenStr;
  input Tpl.Text in_a_arrName;
  input Tpl.Text in_a_arrayType;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_context, in_a_ecr, in_a_dimsLenStr, in_a_arrName, in_a_arrayType, in_a_varDecls, in_a_preExp, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_dimsLenStr;
      Tpl.Text a_arrName;
      Tpl.Text a_arrayType;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.ComponentRef a_cr;
      SimCode.Context i_context;
      DAE.ExpType ret_2;
      list<DAE.Subscript> ret_1;
      Tpl.Text l_dimsValuesStr;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           a_dimsLenStr,
           a_arrName,
           a_arrayType,
           a_varDecls,
           a_preExp,
           a_cr )
      equation
        ret_1 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_preExp) = lm_669(l_dimsValuesStr, ret_1, a_varDecls, a_preExp, i_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*"));
        txt = Tpl.writeText(txt, a_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_element_addr(&"));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_dimsLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_ecr,
           _,
           a_arrName,
           _,
           a_varDecls,
           a_preExp,
           a_cr )
      equation
        ret_2 = ComponentReference.crefLastType(a_cr);
        (txt, a_varDecls, a_preExp) = fun_670(txt, ret_2, a_ecr, a_varDecls, a_preExp, i_context, a_cr, a_arrName);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_671;

protected function fun_672
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_dimsLenStr;
  input Tpl.Text in_a_arrayType;
  input Tpl.Text in_a_arrName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr, in_a_dimsLenStr, in_a_arrayType, in_a_arrName, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_dimsLenStr;
      Tpl.Text a_arrayType;
      Tpl.Text a_arrName;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      list<DAE.Subscript> ret_1;
      Tpl.Text l_dimsValuesStr;

    case ( txt,
           "metatype_array",
           _,
           _,
           _,
           a_arrName,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        ret_1 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_preExp) = lm_668(l_dimsValuesStr, ret_1, a_varDecls, a_preExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.CREF */"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr,
           a_dimsLenStr,
           a_arrayType,
           a_arrName,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        (txt, a_varDecls, a_preExp) = fun_671(txt, a_context, a_ecr, a_dimsLenStr, a_arrName, a_arrayType, a_varDecls, a_preExp, a_cr);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_672;

protected function fun_673
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.ExpType in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      String str_9;
      Integer ret_8;
      list<DAE.Subscript> ret_7;
      Tpl.Text l_dimsLenStr;
      DAE.ComponentRef ret_5;
      list<DAE.Subscript> ret_4;
      Tpl.Text l_spec1;
      Tpl.Text l_tmp;
      Tpl.Text l_arrayType;
      Tpl.Text l_arrName;

    case ( txt,
           false,
           _,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        l_arrName = contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayType), a_varDecls);
        ret_4 = ComponentReference.crefSubs(a_cr);
        (l_spec1, a_preExp, a_varDecls) = daeExpCrefRhsIndexSpec(Tpl.emptyTxt, ret_4, a_context, a_preExp, a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("index_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_arrName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_spec1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_ecr,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_5 = ComponentReference.crefStripLastSubs(a_cr);
        l_arrName = contextCref(Tpl.emptyTxt, ret_5, a_context);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        ret_7 = ComponentReference.crefSubs(a_cr);
        ret_8 = listLength(ret_7);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_8));
        str_9 = Tpl.textString(l_arrayType);
        (txt, a_varDecls, a_preExp) = fun_672(txt, str_9, a_ecr, l_dimsLenStr, l_arrayType, l_arrName, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_673;

protected function fun_674
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           DAE.ET_ENUMERATION(path = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_674;

protected function fun_675
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.ExpType in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text l_cast;
      Boolean ret_0;

    case ( txt,
           false,
           a_ecr,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.crefSubIsScalar(a_cr);
        (txt, a_preExp, a_varDecls) = fun_673(txt, ret_0, a_ecr, a_preExp, a_varDecls, a_ty, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        l_cast = fun_674(Tpl.emptyTxt, a_ty);
        txt = Tpl.writeText(txt, l_cast);
        txt = contextCref(txt, a_cr, a_context);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_675;

protected function fun_676
  input Tpl.Text in_txt;
  input Tpl.Text in_a_box;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.ExpType in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_box, in_a_ecr, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text i_box;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_ecr,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.crefIsScalar(a_cr, a_context);
        (txt, a_preExp, a_varDecls) = fun_675(txt, ret_0, a_ecr, a_preExp, a_varDecls, a_ty, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_box,
           _,
           a_preExp,
           a_varDecls,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_box);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_676;

public function daeExpCrefRhs2
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType i_ty;
      DAE.ComponentRef i_cr;
      DAE.Exp i_ecr;
      Tpl.Text txt_1;
      String ret_1;
      Tpl.Text l_box;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = i_cr, ty = i_ty)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_box, a_preExp, a_varDecls) = daeExpCrefRhsArrayBox(Tpl.emptyTxt, i_ecr, a_context, a_preExp, a_varDecls);
        (txt, a_preExp, a_varDecls) = fun_676(txt, l_box, i_ecr, a_preExp, a_varDecls, i_ty, a_context, i_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_ecr,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("daeExpCrefRhs2: UNHANDLED EXPRESSION: "));
        ret_1 = ExpressionDump.printExpStr(i_ecr);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 4620, 11), Tpl.textString(txt_1));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCrefRhs2;

protected function fun_678
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_dim;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dim)
    local
      Tpl.Text txt;
      Integer i_size;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_ENUM(size = i_size) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeStr(txt, intString(i_size));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 4639, 22), "Non-constant dimension in simulation context");
      then txt;
  end matchcontinue;
end fun_678;

protected function lm_679
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = fun_678(txt, i_dim);
        txt = lm_679(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_679(txt, rest);
      then txt;
  end matchcontinue;
end lm_679;

protected function fun_680
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subrest;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<DAE.Dimension> in_a_dimrest;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_subrest, in_a_varDecls, in_a_preExp, in_a_context, in_a_dimrest)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Dimension> a_dimrest;
      list<DAE.Subscript> i_subrest;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_subrest,
           a_varDecls,
           a_preExp,
           a_context,
           a_dimrest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        (txt, a_preExp, a_varDecls) = threadDimSubList(txt, a_dimrest, i_subrest, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_680;

protected function fun_681
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_a_dims;
  input list<DAE.Subscript> in_a_subrest;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_sub_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_dims, in_a_subrest, in_a_varDecls, in_a_preExp, in_a_context, in_a_sub_exp)
    local
      Tpl.Text txt;
      list<DAE.Subscript> a_subrest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_sub_exp;
      list<DAE.Dimension> i_dimrest;
      Tpl.Text l_estr;

    case ( txt,
           _ :: i_dimrest,
           a_subrest,
           a_varDecls,
           a_preExp,
           a_context,
           a_sub_exp )
      equation
        (l_estr, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_sub_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(("));
        txt = Tpl.writeText(txt, l_estr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = lm_679(txt, i_dimrest);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        (txt, a_varDecls, a_preExp) = fun_680(txt, a_subrest, a_varDecls, a_preExp, a_context, i_dimrest);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 4641, 18), "Less subscripts that dimensions in indexing cref? That\'s odd!");
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_681;

protected function fun_682
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subs;
  input list<DAE.Dimension> in_a_dims;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_subs, in_a_dims, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Dimension> a_dims;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Subscript> i_subrest;
      DAE.Exp i_sub_exp;

    case ( txt,
           {},
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 4627, 22), "Empty dimensions in indexing cref?");
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.INDEX(exp = i_sub_exp) :: i_subrest,
           a_dims,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_681(txt, a_dims, i_subrest, a_varDecls, a_preExp, a_context, i_sub_exp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 4642, 14), "Non-index subscript in indexing cref? That\'s odd!");
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_682;

public function threadDimSubList
  input Tpl.Text txt;
  input list<DAE.Dimension> a_dims;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_682(txt, a_subs, a_dims, a_context, a_preExp, a_varDecls);
end threadDimSubList;

protected function fun_684
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_sub;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_sub, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;
      Tpl.Text l_tmp;
      Tpl.Text l_str;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(0), make_index_array(1, (int) "));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'S\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.WHOLEDIM(),
           a_varDecls,
           a_preExp,
           _ )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(1), (int*)0, \'W\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_integer", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = size_of_dimension_integer_array("));
        a_preExp = Tpl.writeText(a_preExp, l_expPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", 1);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(int) "));
        l_str = Tpl.writeText(l_str, l_tmp);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING(", integer_array_make_index_array(&"));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'A\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_684;

protected function lm_685
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Subscript i_sub;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_sub :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = fun_684(txt, i_sub, a_varDecls, a_preExp, a_context);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_685(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_685(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_685;

public function daeExpCrefRhsIndexSpec
  input Tpl.Text txt;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
  Tpl.Text l_idx__str;
  Integer ret_1;
  Tpl.Text l_nridx__str;
algorithm
  ret_1 := listLength(a_subs);
  l_nridx__str := Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
  l_idx__str := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_idx__str, out_a_varDecls, out_a_preExp) := lm_685(l_idx__str, a_subs, a_varDecls, a_preExp, a_context);
  l_idx__str := Tpl.popIter(l_idx__str);
  (l_tmp, out_a_varDecls) := tempDecl(Tpl.emptyTxt, "index_spec_t", out_a_varDecls);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING("create_index_spec(&"));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_tmp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(", "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_nridx__str);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(", "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_idx__str);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(");"));
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_tmp);
end daeExpCrefRhsIndexSpec;

protected function lm_687
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_687(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_687(txt, rest);
      then txt;
  end matchcontinue;
end lm_687;

protected function fun_688
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_preExp;
  input list<DAE.Dimension> in_a_dims;
  input Tpl.Text in_a_varDecls;
  input DAE.ExpType in_a_aty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_context, in_a_ecr_componentRef, in_a_preExp, in_a_dims, in_a_varDecls, in_a_aty)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_preExp;
      list<DAE.Dimension> a_dims;
      Tpl.Text a_varDecls;
      DAE.ExpType a_aty;
      Tpl.Text l_type;
      Tpl.Text l_dimsValuesStr;
      Integer ret_3;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_1;
      Tpl.Text l_tmpArr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           a_preExp,
           _,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_preExp,
           a_dims,
           a_varDecls,
           a_aty )
      equation
        txt_1 = expTypeArray(Tpl.emptyTxt, a_aty);
        (l_tmpArr, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        ret_3 = listLength(a_dims);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dimsValuesStr = lm_687(l_dimsValuesStr, a_dims);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        l_type = expTypeShort(Tpl.emptyTxt, a_aty);
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_array_create(&"));
        a_preExp = Tpl.writeText(a_preExp, l_tmpArr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", ((modelica_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("*)&("));
        a_preExp = arrayCrefCStr(a_preExp, a_ecr_componentRef);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")), "));
        a_preExp = Tpl.writeText(a_preExp, l_dimsLenStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_dimsValuesStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpArr);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_688;

public function daeExpCrefRhsArrayBox
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_ecr_componentRef;
      list<DAE.Dimension> i_dims;
      DAE.ExpType i_aty;

    case ( txt,
           DAE.CREF(ty = DAE.ET_ARRAY(ty = i_aty, arrayDimensions = i_dims), componentRef = i_ecr_componentRef),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = fun_688(txt, a_context, i_ecr_componentRef, a_preExp, i_dims, a_varDecls, i_aty);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCrefRhsArrayBox;

protected function lm_690
  input Tpl.Text in_txt;
  input list<DAE.ExpVar> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      list<DAE.ExpVar> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.ExpVar i_v;
      DAE.Exp ret_0;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_v :: rest,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.makeCrefRecordExp(a_cr, i_v);
        (txt, a_preExp, a_varDecls) = daeExp(txt, ret_0, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_690(txt, rest, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        (txt, a_varDecls, a_preExp) = lm_690(txt, rest, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_690;

public function daeExpRecordCrefRhs
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_cr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Absyn.Path i_record__path;
      list<DAE.ExpVar> i_var__lst;
      Tpl.Text l_ret__var;
      Tpl.Text l_ret__type;
      Tpl.Text l_record__type__name;
      Tpl.Text l_vars;

    case ( txt,
           DAE.ET_COMPLEX(name = i_record__path, varLst = i_var__lst),
           a_cr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_vars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_vars, a_varDecls, a_preExp) = lm_690(l_vars, i_var__lst, a_varDecls, a_preExp, a_context, a_cr);
        l_vars = Tpl.popIter(l_vars);
        l_record__type__name = underscorePath(Tpl.emptyTxt, i_record__path);
        l_ret__type = Tpl.writeText(Tpl.emptyTxt, l_record__type__name);
        l_ret__type = Tpl.writeTok(l_ret__type, Tpl.ST_STRING("_rettype"));
        (l_ret__var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ret__type), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_ret__var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = _"));
        a_preExp = Tpl.writeText(a_preExp, l_record__type__name);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_vars);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_ret__var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, l_ret__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpRecordCrefRhs;

protected function fun_692
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.ExpType in_a_t;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_a_context, in_a_cr, in_a_t, in_a_varDecls, in_a_afterExp, in_a_exp)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      DAE.ExpType a_t;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      DAE.Exp a_exp;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           _,
           a_varDecls,
           a_afterExp,
           a_exp )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpCrefLhs2(txt, a_exp, i_context, a_afterExp, a_varDecls);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_context,
           a_cr,
           a_t,
           a_varDecls,
           a_afterExp,
           _ )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpRecordCrefLhs(txt, a_t, a_cr, i_context, a_afterExp, a_varDecls);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_692;

public function daeExpCrefLhs
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cr;
      DAE.ExpType i_t;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.CREF(componentRef = i_cr, ty = (i_t as DAE.ET_COMPLEX(complexClassType = ClassInf.RECORD(path = _))))),
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_afterExp) = fun_692(txt, a_context, i_cr, i_t, a_varDecls, a_afterExp, i_exp);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.ET_FUNCTION_REFERENCE_FUNC(builtin = _)),
           _,
           a_afterExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr)boxptr_"));
        txt = crefFunctionName(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.ET_FUNCTION_REFERENCE_VAR()),
           _,
           a_afterExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr) _"));
        txt = crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpCrefLhs2(txt, i_exp, a_context, a_afterExp, a_varDecls);
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end daeExpCrefLhs;

protected function lm_694
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_afterExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_694(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_varDecls, a_afterExp) = lm_694(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_694;

protected function fun_695
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_dimsLenStr;
  input Tpl.Text in_a_arrayType;
  input Tpl.Text in_a_dimsValuesStr;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_dimsLenStr, in_a_arrayType, in_a_dimsValuesStr, in_a_arrName)
    local
      Tpl.Text txt;
      Tpl.Text a_dimsLenStr;
      Tpl.Text a_arrayType;
      Tpl.Text a_dimsValuesStr;
      Tpl.Text a_arrName;

    case ( txt,
           "metatype_array",
           _,
           _,
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.CREF */"));
      then txt;

    case ( txt,
           _,
           a_dimsLenStr,
           a_arrayType,
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*"));
        txt = Tpl.writeText(txt, a_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_element_addr(&"));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_dimsLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;
  end matchcontinue;
end fun_695;

protected function fun_696
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;
  input DAE.ExpType in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_afterExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls, in_a_ty, in_a_context, in_a_cr, in_a_ecr, in_a_afterExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.ExpType a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.Exp a_ecr;
      Tpl.Text a_afterExp;
      String str_13;
      list<DAE.Subscript> ret_12;
      Tpl.Text l_dimsValuesStr;
      Integer ret_10;
      list<DAE.Subscript> ret_9;
      Tpl.Text l_dimsLenStr;
      DAE.ComponentRef ret_7;
      String ret_6;
      list<DAE.Subscript> ret_5;
      Tpl.Text l_spec1;
      Tpl.Text l_tmp;
      Tpl.Text l_arrayType;
      Tpl.Text l_arrName;
      String ret_0;

    case ( txt,
           false,
           a_varDecls,
           a_ty,
           a_context,
           a_cr,
           a_ecr,
           a_afterExp )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 SLICE("));
        ret_0 = ExpressionDump.printExpStr(a_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_0);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") afterExp  */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        l_arrName = contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayType), a_varDecls);
        ret_5 = ComponentReference.crefSubs(a_cr);
        (l_spec1, a_afterExp, a_varDecls) = daeExpCrefLhsIndexSpec(Tpl.emptyTxt, ret_5, a_context, a_afterExp, a_varDecls);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("indexed_assign_"));
        a_afterExp = Tpl.writeText(a_afterExp, l_arrayType);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("(&"));
        a_afterExp = Tpl.writeText(a_afterExp, l_tmp);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", &"));
        a_afterExp = Tpl.writeText(a_afterExp, l_arrName);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", &"));
        a_afterExp = Tpl.writeText(a_afterExp, l_spec1);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(");"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _,
           a_varDecls,
           a_ty,
           a_context,
           a_cr,
           a_ecr,
           a_afterExp )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 SCALAR("));
        ret_6 = ExpressionDump.printExpStr(a_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_6);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") afterExp  */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        ret_7 = ComponentReference.crefStripLastSubs(a_cr);
        l_arrName = contextCref(Tpl.emptyTxt, ret_7, a_context);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        ret_9 = ComponentReference.crefSubs(a_cr);
        ret_10 = listLength(ret_9);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_10));
        ret_12 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_afterExp) = lm_694(l_dimsValuesStr, ret_12, a_varDecls, a_afterExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        str_13 = Tpl.textString(l_arrayType);
        txt = fun_695(txt, str_13, l_dimsLenStr, l_arrayType, l_dimsValuesStr, l_arrName);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_696;

protected function fun_697
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           DAE.ET_ENUMERATION(path = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_697;

protected function fun_698
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;
  input DAE.ExpType in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_afterExp;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls, in_a_ty, in_a_context, in_a_ecr, in_a_afterExp, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.ExpType a_ty;
      SimCode.Context a_context;
      DAE.Exp a_ecr;
      Tpl.Text a_afterExp;
      DAE.ComponentRef a_cr;
      Tpl.Text l_cast;
      Boolean ret_0;

    case ( txt,
           false,
           a_varDecls,
           a_ty,
           a_context,
           a_ecr,
           a_afterExp,
           a_cr )
      equation
        ret_0 = SimCode.crefSubIsScalar(a_cr);
        (txt, a_varDecls, a_afterExp) = fun_696(txt, ret_0, a_varDecls, a_ty, a_context, a_cr, a_ecr, a_afterExp);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _,
           a_varDecls,
           a_ty,
           a_context,
           _,
           a_afterExp,
           a_cr )
      equation
        l_cast = fun_697(Tpl.emptyTxt, a_ty);
        txt = Tpl.writeText(txt, l_cast);
        txt = contextCref(txt, a_cr, a_context);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_698;

protected function fun_699
  input Tpl.Text in_txt;
  input Tpl.Text in_a_box;
  input Tpl.Text in_a_varDecls;
  input DAE.ExpType in_a_ty;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_a_box, in_a_varDecls, in_a_ty, in_a_ecr, in_a_afterExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.ExpType a_ty;
      DAE.Exp a_ecr;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text i_box;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_varDecls,
           a_ty,
           a_ecr,
           a_afterExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.crefIsScalar(a_cr, a_context);
        (txt, a_varDecls, a_afterExp) = fun_698(txt, ret_0, a_varDecls, a_ty, a_context, a_ecr, a_afterExp, a_cr);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_box,
           a_varDecls,
           _,
           _,
           a_afterExp,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_box);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_699;

public function daeExpCrefLhs2
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      DAE.ExpType i_ty;
      DAE.ComponentRef i_cr;
      DAE.Exp i_ecr;
      String ret_3;
      String ret_2;
      Tpl.Text l_box;
      String ret_0;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = i_cr, ty = i_ty)),
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 begin afterExp ("));
        ret_0 = ExpressionDump.printExpStr(i_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_0);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        (l_box, a_afterExp, a_varDecls) = daeExpCrefLhsArrayBox(Tpl.emptyTxt, i_ecr, a_context, a_afterExp, a_varDecls);
        (txt, a_varDecls, a_afterExp) = fun_699(txt, l_box, a_varDecls, i_ty, i_ecr, a_afterExp, a_context, i_cr);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           i_ecr,
           _,
           a_afterExp,
           a_varDecls )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 UNHANDLED("));
        ret_2 = ExpressionDump.printExpStr(i_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_2);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") afterExp */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* SimCodeC.tpl template: daeExpCrefLhs2: UNHANDLED EXPRESSION:\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* "));
        ret_3 = ExpressionDump.printExpStr(i_ecr);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
        txt = Tpl.popBlock(txt);
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end daeExpCrefLhs2;

protected function fun_701
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_sub;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_a_sub, in_a_varDecls, in_a_afterExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;
      Tpl.Text l_tmp;
      Tpl.Text l_str;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (l_expPart, a_afterExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_afterExp, a_varDecls);
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(0), make_index_array(1, (int) "));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'S\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           DAE.WHOLEDIM(),
           a_varDecls,
           a_afterExp,
           _ )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(1), (int*)0, \'W\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (l_expPart, a_afterExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_afterExp, a_varDecls);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_integer", a_varDecls);
        a_afterExp = Tpl.writeText(a_afterExp, l_tmp);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(" = size_of_dimension_integer_array("));
        a_afterExp = Tpl.writeText(a_afterExp, l_expPart);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", 1);"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(int) "));
        l_str = Tpl.writeText(l_str, l_tmp);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING(", integer_array_make_index_array(&"));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'A\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _,
           a_varDecls,
           a_afterExp,
           _ )
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_701;

protected function lm_702
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.Subscript i_sub;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_sub :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_varDecls, a_afterExp) = fun_701(txt, i_sub, a_varDecls, a_afterExp, a_context);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_702(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_varDecls, a_afterExp) = lm_702(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_702;

public function daeExpCrefLhsIndexSpec
  input Tpl.Text txt;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_afterExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
  Tpl.Text l_idx__str;
  Integer ret_1;
  Tpl.Text l_nridx__str;
algorithm
  ret_1 := listLength(a_subs);
  l_nridx__str := Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
  l_idx__str := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_idx__str, out_a_varDecls, out_a_afterExp) := lm_702(l_idx__str, a_subs, a_varDecls, a_afterExp, a_context);
  l_idx__str := Tpl.popIter(l_idx__str);
  (l_tmp, out_a_varDecls) := tempDecl(Tpl.emptyTxt, "index_spec_t", out_a_varDecls);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING("create_index_spec(&"));
  out_a_afterExp := Tpl.writeText(out_a_afterExp, l_tmp);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING(", "));
  out_a_afterExp := Tpl.writeText(out_a_afterExp, l_nridx__str);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING(", "));
  out_a_afterExp := Tpl.writeText(out_a_afterExp, l_idx__str);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING(");"));
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_tmp);
end daeExpCrefLhsIndexSpec;

protected function lm_704
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_704(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_704(txt, rest);
      then txt;
  end matchcontinue;
end lm_704;

protected function fun_705
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_afterExp;
  input list<DAE.Dimension> in_a_dims;
  input Tpl.Text in_a_varDecls;
  input DAE.ExpType in_a_aty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_context, in_a_ecr_componentRef, in_a_afterExp, in_a_dims, in_a_varDecls, in_a_aty)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_afterExp;
      list<DAE.Dimension> a_dims;
      Tpl.Text a_varDecls;
      DAE.ExpType a_aty;
      Tpl.Text l_type;
      Tpl.Text l_dimsValuesStr;
      Integer ret_3;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_1;
      Tpl.Text l_tmpArr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           a_afterExp,
           _,
           a_varDecls,
           _ )
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_afterExp,
           a_dims,
           a_varDecls,
           a_aty )
      equation
        txt_1 = expTypeArray(Tpl.emptyTxt, a_aty);
        (l_tmpArr, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        ret_3 = listLength(a_dims);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dimsValuesStr = lm_704(l_dimsValuesStr, a_dims);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        l_type = expTypeShort(Tpl.emptyTxt, a_aty);
        a_afterExp = Tpl.writeText(a_afterExp, l_type);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("_array_create(&"));
        a_afterExp = Tpl.writeText(a_afterExp, l_tmpArr);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", ((modelica_"));
        a_afterExp = Tpl.writeText(a_afterExp, l_type);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("*)&("));
        a_afterExp = arrayCrefCStr(a_afterExp, a_ecr_componentRef);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(")), "));
        a_afterExp = Tpl.writeText(a_afterExp, l_dimsLenStr);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", "));
        a_afterExp = Tpl.writeText(a_afterExp, l_dimsValuesStr);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(");"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpArr);
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end fun_705;

public function daeExpCrefLhsArrayBox
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_ecr_componentRef;
      list<DAE.Dimension> i_dims;
      DAE.ExpType i_aty;

    case ( txt,
           DAE.CREF(ty = DAE.ET_ARRAY(ty = i_aty, arrayDimensions = i_dims), componentRef = i_ecr_componentRef),
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        (txt, a_afterExp, a_varDecls) = fun_705(txt, a_context, i_ecr_componentRef, a_afterExp, i_dims, a_varDecls, i_aty);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_afterExp,
           a_varDecls )
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end daeExpCrefLhsArrayBox;

protected function lm_707
  input Tpl.Text in_txt;
  input list<DAE.ExpVar> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      list<DAE.ExpVar> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.ExpVar i_v;
      DAE.Exp ret_0;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_v :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.makeCrefRecordExp(a_cr, i_v);
        (txt, a_afterExp, a_varDecls) = daeExp(txt, ret_0, a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_707(txt, rest, a_varDecls, a_afterExp, a_context, a_cr);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_cr )
      equation
        (txt, a_varDecls, a_afterExp) = lm_707(txt, rest, a_varDecls, a_afterExp, a_context, a_cr);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_707;

public function daeExpRecordCrefLhs
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_cr, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      Absyn.Path i_record__path;
      list<DAE.ExpVar> i_var__lst;
      Tpl.Text l_ret__var;
      Tpl.Text l_ret__type;
      Tpl.Text l_record__type__name;
      Tpl.Text l_vars;

    case ( txt,
           DAE.ET_COMPLEX(name = i_record__path, varLst = i_var__lst),
           a_cr,
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        l_vars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_vars, a_varDecls, a_afterExp) = lm_707(l_vars, i_var__lst, a_varDecls, a_afterExp, a_context, a_cr);
        l_vars = Tpl.popIter(l_vars);
        l_record__type__name = underscorePath(Tpl.emptyTxt, i_record__path);
        l_ret__type = Tpl.writeText(Tpl.emptyTxt, l_record__type__name);
        l_ret__type = Tpl.writeTok(l_ret__type, Tpl.ST_STRING("_rettype"));
        (l_ret__var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ret__type), a_varDecls);
        a_afterExp = Tpl.writeText(a_afterExp, l_ret__var);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(" = _"));
        a_afterExp = Tpl.writeText(a_afterExp, l_record__type__name);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("("));
        a_afterExp = Tpl.writeText(a_afterExp, l_vars);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(");"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_ret__var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, l_ret__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_afterExp,
           a_varDecls )
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end daeExpRecordCrefLhs;

protected function fun_709
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "modelica_string", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "modelica_metatype", a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_709;

protected function fun_710
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_tmpStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_e2, in_a_e1, in_a_tmpStr)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_tmpStr;

    case ( txt,
           false,
           a_e2,
           a_e1,
           a_tmpStr )
      equation
        txt = Tpl.writeText(txt, a_tmpStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = cat_modelica_string("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           a_e2,
           a_e1,
           a_tmpStr )
      equation
        txt = Tpl.writeText(txt, a_tmpStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = stringAppend("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_710;

protected function fun_711
  input Tpl.Text in_txt;
  input Option<Integer> in_mArg;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_e2, in_a_e1, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Integer i_i;
      Tpl.Text l_tmp;

    case ( txt,
           SOME(2),
           _,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_real", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SOME(3),
           _,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_real", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SOME(4),
           _,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_real", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" *= "));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SOME(i_i),
           _,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_int_pow("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pow("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_711;

protected function fun_712
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Exp in_a_exp2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_e2, in_a_e1, in_a_preExp, in_a_varDecls, in_a_exp2)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp a_exp2;
      Option<Integer> ret_0;

    case ( txt,
           false,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls,
           a_exp2 )
      equation
        ret_0 = Expression.realExpIntLit(a_exp2);
        (txt, a_preExp, a_varDecls) = fun_711(txt, ret_0, a_e2, a_e1, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_e1,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("sqrt("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_712;

protected function fun_713
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_INT()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_ENUMERATION(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_713;

protected function fun_714
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_INT()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_ENUMERATION(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_714;

protected function fun_715
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_INT()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_ENUMERATION(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_715;

protected function fun_716
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_INT()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_scalar"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_ENUMERATION(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_scalar"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_scalar"));
      then txt;
  end matchcontinue;
end fun_716;

protected function fun_717
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_INT()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_ENUMERATION(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;
  end matchcontinue;
end fun_717;

protected function fun_718
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_INT()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_ENUMERATION(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_718;

protected function fun_719
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_exp;
  input DAE.Exp in_a_exp2;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_operator, in_a_context, in_a_exp, in_a_exp2, in_a_e2, in_a_e1, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      DAE.Exp a_exp;
      DAE.Exp a_exp2;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType i_ty;
      Tpl.Text l_typeShort;
      Tpl.Text l_var;
      Tpl.Text l_type;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Tpl.Text l_tmpStr;

    case ( txt,
           DAE.ADD(ty = DAE.ET_STRING()),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        ret_1 = Config.acceptMetaModelicaGrammar();
        (l_tmpStr, a_varDecls) = fun_709(Tpl.emptyTxt, ret_1, a_varDecls);
        ret_2 = Config.acceptMetaModelicaGrammar();
        a_preExp = fun_710(a_preExp, ret_2, a_e2, a_e1, l_tmpStr);
        txt = Tpl.writeText(txt, l_tmpStr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ADD(ty = _),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SUB(ty = _),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL(ty = _),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV(ty = _),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" / "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW(ty = _),
           _,
           _,
           a_exp2,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        ret_3 = Expression.isHalf(a_exp2);
        (txt, a_preExp, a_varDecls) = fun_712(txt, ret_3, a_e2, a_e1, a_preExp, a_varDecls, a_exp2);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UMINUS(ty = _),
           a_context,
           a_exp,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnary(txt, a_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ADD_ARR(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_713(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("add_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SUB_ARR(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_714(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("sub_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_ARR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for MUL_ARR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV_ARR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for DIV_ARR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_715(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("mul_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_scalar(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for ADD_ARRAY_SCALAR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for SUB_SCALAR_ARRAY"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_716(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mul_"));
        txt = Tpl.writeText(txt, l_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_product(&"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_typeShort = fun_717(Tpl.emptyTxt, i_ty);
        l_type = Tpl.writeText(Tpl.emptyTxt, l_typeShort);
        l_type = Tpl.writeTok(l_type, Tpl.ST_STRING("_array"));
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("mul_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_typeShort);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_matrix_product_smart(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_718(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("div_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_scalar(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for DIV_SCALAR_ARRAY"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_ARRAY_SCALAR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_SCALAR_ARRAY"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW_ARR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_ARR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW_ARR2(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_ARR2"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_719;

public function daeExpBinary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           (i_exp as DAE.BINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        (txt, a_preExp, a_varDecls) = fun_719(txt, i_operator, a_context, i_exp, i_exp2, l_e2, l_e1, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpBinary;

protected function fun_721
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_operator, in_a_preExp, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_e;

    case ( txt,
           DAE.UMINUS(ty = _),
           a_preExp,
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(-"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.UPLUS(ty = _),
           a_preExp,
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.UMINUS_ARR(ty = DAE.ET_ARRAY(ty = DAE.ET_REAL())),
           a_preExp,
           a_e )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("usub_real_array(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_e);
      then (txt, a_preExp);

    case ( txt,
           DAE.UMINUS_ARR(ty = _),
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unary minus for non-real arrays not implemented"));
      then (txt, a_preExp);

    case ( txt,
           DAE.UPLUS_ARR(ty = _),
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UPLUS_ARR_NOT_IMPLEMENTED"));
      then (txt, a_preExp);

    case ( txt,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpUnary:ERR"));
      then (txt, a_preExp);
  end matchcontinue;
end fun_721;

public function daeExpUnary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.UNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (txt, a_preExp) = fun_721(txt, i_operator, a_preExp, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpUnary;

protected function fun_723
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.AND(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.OR(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpLbinary:ERR"));
      then txt;
  end matchcontinue;
end fun_723;

public function daeExpLbinary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           DAE.LBINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        txt = fun_723(txt, i_operator, l_e2, l_e1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpLbinary;

protected function fun_725
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_operator, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_e;

    case ( txt,
           DAE.NOT(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_725;

public function daeExpLunary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.LUNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = fun_725(txt, i_operator, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpLunary;

protected function fun_727
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.LESS(ty = DAE.ET_BOOL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.ET_STRING()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") < 0)"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.ET_INT()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.ET_REAL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.ET_ENUMERATION(path = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.ET_BOOL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.ET_STRING()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") > 0)"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.ET_INT()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.ET_REAL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.ET_ENUMERATION(path = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.ET_BOOL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.ET_STRING()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") <= 0)"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.ET_INT()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.ET_REAL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.ET_ENUMERATION(path = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.ET_BOOL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.ET_STRING()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") >= 0)"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.ET_INT()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.ET_REAL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.ET_ENUMERATION(path = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.ET_BOOL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.ET_STRING()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringEqual("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.ET_INT()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.ET_REAL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.ET_ENUMERATION(path = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.ET_BOOL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.ET_STRING()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!stringEqual("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.ET_INT()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.ET_REAL()),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.ET_ENUMERATION(path = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpRelation:ERR"));
      then txt;
  end matchcontinue;
end fun_727;

protected function fun_728
  input Tpl.Text in_txt;
  input Tpl.Text in_a_simRel;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_simRel, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Tpl.Text i_simRel;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        txt = fun_727(txt, a_rel_operator, l_e2, l_e1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_simRel,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_simRel);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_728;

public function daeExpRelation
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_rel_operator;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      DAE.Exp i_rel;
      Tpl.Text l_simRel;

    case ( txt,
           (i_rel as DAE.RELATION(exp1 = i_rel_exp1, exp2 = i_rel_exp2, operator = i_rel_operator)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_simRel, a_preExp, a_varDecls) = daeExpRelationSim(Tpl.emptyTxt, i_rel, a_context, a_preExp, a_varDecls);
        (txt, a_varDecls, a_preExp) = fun_728(txt, l_simRel, i_rel_operator, i_rel_exp2, a_varDecls, a_preExp, a_context, i_rel_exp1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpRelation;

protected function fun_730
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_rel_index, in_a_e2, in_a_e1, in_a_res, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_res;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Less,<);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",LessEq,<=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Greater,>);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",GreaterEq,>=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end matchcontinue;
end fun_730;

protected function fun_731
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Integer in_a_j;
  input Integer in_a_i;
  input Tpl.Text in_a_iterator;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_j, in_a_i, in_a_iterator, in_a_rel_index, in_a_e2, in_a_e1, in_a_res, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_j;
      Integer a_i;
      Tpl.Text a_iterator;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_res;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Less,<);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",LessEq,<=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Greater,>);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",GreaterEq,>=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end matchcontinue;
end fun_731;

protected function fun_732
  input Tpl.Text in_txt;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;
  input Integer in_a_rel_index;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_optionExpisASUB, in_a_rel_index, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Integer i_j;
      Integer i_i;
      DAE.Exp i_exp;
      Tpl.Text l_iterator;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           NONE(),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (txt, a_preExp) = fun_730(txt, a_rel_operator, a_rel_index, l_e2, l_e1, l_res, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           SOME((i_exp, i_i, i_j)),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_iterator, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (txt, a_preExp) = fun_731(txt, a_rel_operator, i_j, i_i, l_iterator, a_rel_index, l_e2, l_e1, l_res, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_732;

protected function fun_733
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_rel_index, in_a_e2, in_a_e1, in_a_res, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_res;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Less,<);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",LessEq,<=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Greater,>);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",GreaterEq,>=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end matchcontinue;
end fun_733;

protected function fun_734
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Integer in_a_j;
  input Integer in_a_i;
  input Tpl.Text in_a_iterator;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_j, in_a_i, in_a_iterator, in_a_rel_index, in_a_e2, in_a_e1, in_a_res, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_j;
      Integer a_i;
      Tpl.Text a_iterator;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_res;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Less,<);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",LessEq,<=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Greater,>);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(","));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",GreaterEq,>=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end matchcontinue;
end fun_734;

protected function fun_735
  input Tpl.Text in_txt;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;
  input Integer in_a_rel_index;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_optionExpisASUB, in_a_rel_index, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Integer i_j;
      Integer i_i;
      DAE.Exp i_exp;
      Tpl.Text l_iterator;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           NONE(),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (txt, a_preExp) = fun_733(txt, a_rel_operator, a_rel_index, l_e2, l_e1, l_res, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           SOME((i_exp, i_i, i_j)),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (l_iterator, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (txt, a_preExp) = fun_734(txt, a_rel_operator, i_j, i_i, l_iterator, a_rel_index, l_e2, l_e1, l_res, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_735;

protected function fun_736
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Integer in_a_rel_index;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_context, in_a_rel_index, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_rel_exp1, in_a_rel_optionExpisASUB)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      Option<tuple<DAE.Exp, Integer, Integer>> a_rel_optionExpisASUB;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.SIMULATION(genDiscrete = false)),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_rel_exp1,
           a_rel_optionExpisASUB )
      equation
        (txt, a_varDecls, a_preExp) = fun_732(txt, a_rel_optionExpisASUB, a_rel_index, a_rel_operator, a_rel_exp2, a_varDecls, a_preExp, i_context, a_rel_exp1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_context as SimCode.SIMULATION(genDiscrete = true)),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_rel_exp1,
           a_rel_optionExpisASUB )
      equation
        (txt, a_varDecls, a_preExp) = fun_735(txt, a_rel_optionExpisASUB, a_rel_index, a_rel_operator, a_rel_exp2, a_varDecls, a_preExp, i_context, a_rel_exp1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_736;

public function daeExpRelationSim
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Integer i_rel_index;
      DAE.Operator i_rel_operator;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      Option<tuple<DAE.Exp, Integer, Integer>> i_rel_optionExpisASUB;

    case ( txt,
           DAE.RELATION(optionExpisASUB = i_rel_optionExpisASUB, exp1 = i_rel_exp1, exp2 = i_rel_exp2, operator = i_rel_operator, index = i_rel_index),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_736(txt, a_context, i_rel_index, i_rel_operator, i_rel_exp2, a_varDecls, a_preExp, i_rel_exp1, i_rel_optionExpisASUB);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpRelationSim;

protected function fun_738
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("x"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_738;

protected function fun_739
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExpElse;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_preExpElse, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      Boolean ret_1;
      DAE.ExpType ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_exp )
      equation
        ret_0 = Expression.typeof(a_exp);
        ret_1 = Expression.isArrayType(ret_0);
        txt = fun_738(txt, ret_1);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_739;

protected function fun_740
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExpThen;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_preExpElse;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_preExpThen, in_a_exp, in_a_preExpElse)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      Tpl.Text a_preExpElse;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_exp,
           a_preExpElse )
      equation
        txt = fun_739(txt, a_preExpElse, a_exp);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_740;

protected function fun_741
  input Tpl.Text in_txt;
  input Tpl.Text in_a_eThen;
  input Tpl.Text in_a_resVarType;
  input Tpl.Text in_a_resVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eThen, in_a_resVarType, in_a_resVar)
    local
      Tpl.Text txt;
      Tpl.Text a_resVarType;
      Tpl.Text a_resVar;
      Tpl.Text i_eThen;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           i_eThen,
           a_resVarType,
           a_resVar )
      equation
        txt = Tpl.writeText(txt, a_resVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = Tpl.writeText(txt, a_resVarType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, i_eThen);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_741;

protected function fun_742
  input Tpl.Text in_txt;
  input Tpl.Text in_a_eElse;
  input Tpl.Text in_a_resVarType;
  input Tpl.Text in_a_resVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eElse, in_a_resVarType, in_a_resVar)
    local
      Tpl.Text txt;
      Tpl.Text a_resVarType;
      Tpl.Text a_resVar;
      Tpl.Text i_eElse;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           i_eElse,
           a_resVarType,
           a_resVar )
      equation
        txt = Tpl.writeText(txt, a_resVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = Tpl.writeText(txt, a_resVarType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, i_eElse);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_742;

protected function fun_743
  input Tpl.Text in_txt;
  input Tpl.Text in_a_shortIfExp;
  input Tpl.Text in_a_eElse;
  input Tpl.Text in_a_preExpElse;
  input Tpl.Text in_a_eThen;
  input Tpl.Text in_a_preExpThen;
  input Tpl.Text in_a_condExp;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_expThen;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_shortIfExp, in_a_eElse, in_a_preExpElse, in_a_eThen, in_a_preExpThen, in_a_condExp, in_a_preExp, in_a_expThen, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_eElse;
      Tpl.Text a_preExpElse;
      Tpl.Text a_eThen;
      Tpl.Text a_preExpThen;
      Tpl.Text a_condExp;
      Tpl.Text a_preExp;
      DAE.Exp a_expThen;
      Tpl.Text a_varDecls;
      Tpl.Text l_resVar;
      Tpl.Text l_resVarType;
      Tpl.Text l_condVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_eElse,
           a_preExpElse,
           a_eThen,
           a_preExpThen,
           a_condExp,
           a_preExp,
           a_expThen,
           a_varDecls )
      equation
        (l_condVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        l_resVarType = expTypeFromExpArrayIf(Tpl.emptyTxt, a_expThen);
        (l_resVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_resVarType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_condVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (modelica_boolean)"));
        a_preExp = Tpl.writeText(a_preExp, a_condExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if ("
                                          }, false));
        a_preExp = Tpl.writeText(a_preExp, l_condVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(") {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_preExpThen);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = fun_741(a_preExp, a_eThen, l_resVarType, l_resVar);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_preExpElse);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = fun_742(a_preExp, a_eElse, l_resVarType, l_resVar);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_resVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_eElse,
           _,
           a_eThen,
           _,
           a_condExp,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("?"));
        txt = Tpl.writeText(txt, a_eThen);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        txt = Tpl.writeText(txt, a_eElse);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_743;

public function daeExpIf
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      Tpl.Text l_shortIfExp;
      Tpl.Text l_eElse;
      Tpl.Text l_preExpElse;
      Tpl.Text l_eThen;
      Tpl.Text l_preExpThen;
      Tpl.Text l_condExp;

    case ( txt,
           (i_exp as DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_condExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_expCond, a_context, a_preExp, a_varDecls);
        l_preExpThen = Tpl.emptyTxt;
        (l_eThen, l_preExpThen, a_varDecls) = daeExp(Tpl.emptyTxt, i_expThen, a_context, l_preExpThen, a_varDecls);
        l_preExpElse = Tpl.emptyTxt;
        (l_eElse, l_preExpElse, a_varDecls) = daeExp(Tpl.emptyTxt, i_expElse, a_context, l_preExpElse, a_varDecls);
        l_shortIfExp = fun_740(Tpl.emptyTxt, l_preExpThen, i_exp, l_preExpElse);
        (txt, a_preExp, a_varDecls) = fun_743(txt, l_shortIfExp, l_eElse, l_preExpElse, l_eThen, l_preExpThen, l_condExp, a_preExp, i_expThen, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpIf;

protected function fun_745
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_INT()) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = DAE.ET_ENUMERATION(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_745;

protected function fun_746
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_var1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_var1)
    local
      Tpl.Text txt;
      Tpl.Text a_var1;

    case ( txt,
           false,
           a_var1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("puts("));
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_var1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("print("));
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_746;

protected function lm_747
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_dim;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_dim :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_dim, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_747(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_747(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_747;

protected function lm_748
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_array;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_array :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_array, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_748(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_748(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_748;

protected function lm_749
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_749(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_749(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_749;

protected function fun_750
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_attr_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_ty)
    local
      Tpl.Text txt;
      DAE.ExpType i_attr_ty;

    case ( txt,
           DAE.ET_NORETCALL() )
      then txt;

    case ( txt,
           i_attr_ty )
      equation
        txt = expTypeModelica(txt, i_attr_ty);
      then txt;
  end matchcontinue;
end fun_750;

protected function fun_751
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input DAE.ExpType in_a_attr_ty;
  input Tpl.Text in_a_funName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_attr_ty, in_a_funName)
    local
      Tpl.Text txt;
      DAE.ExpType a_attr_ty;
      Tpl.Text a_funName;

    case ( txt,
           false,
           _,
           a_funName )
      equation
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;

    case ( txt,
           _,
           a_attr_ty,
           _ )
      equation
        txt = fun_750(txt, a_attr_ty);
      then txt;
  end matchcontinue;
end fun_751;

protected function fun_752
  input Tpl.Text in_txt;
  input DAE.ExpType in_a_attr_ty;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_attr_ty, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           DAE.ET_NORETCALL(),
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_752;

protected function fun_753
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_funName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_funName)
    local
      Tpl.Text txt;
      Tpl.Text a_funName;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           a_funName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_FN("
                                }, false));
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_index);\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_753;

protected function fun_754
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_funName;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_funName, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_funName;
      SimCode.Context a_context;

    case ( txt,
           false,
           a_funName,
           a_context )
      equation
        txt = fun_753(txt, a_context, a_funName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_754;

protected function fun_755
  input Tpl.Text in_txt;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text i_retVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_retVar )
      equation
        txt = Tpl.writeText(txt, i_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;
  end matchcontinue;
end fun_755;

protected function fun_756
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_funName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_funName)
    local
      Tpl.Text txt;
      Tpl.Text a_funName;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           a_funName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_FN("
                                }, false));
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_index);\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_756;

protected function fun_757
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_funName;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_funName, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_funName;
      SimCode.Context a_context;

    case ( txt,
           false,
           a_funName,
           a_context )
      equation
        txt = fun_756(txt, a_context, a_funName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_757;

protected function fun_758
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_attr_builtin, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;

    case ( txt,
           false,
           a_retType,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_1"));
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_758;

protected function fun_759
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_retType;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_exp, in_a_retType, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      Tpl.Text a_retVar;
      Boolean i_attr_builtin;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = DAE.ET_NORETCALL())),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* NORETCALL */"));
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(tuple_ = false, builtin = i_attr_builtin)),
           a_retType,
           a_retVar )
      equation
        txt = fun_758(txt, i_attr_builtin, a_retType, a_retVar);
      then txt;

    case ( txt,
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_759;

public function daeExpCall
  input Tpl.Text in_txt;
  input DAE.Exp in_a_call;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_call, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ExpType i_attr_ty;
      Boolean i_attr_builtin;
      Absyn.Path i_path;
      list<String> i_tail_vars;
      list<DAE.Exp> i_expLst;
      Integer i_i;
      DAE.Exp i_s1;
      DAE.Exp i_toBeCasted;
      Integer i_index;
      DAE.Exp i_delayMax;
      DAE.Exp i_d;
      DAE.Exp i_signdig;
      DAE.Exp i_leftjust;
      DAE.Exp i_minlen;
      DAE.Exp i_format;
      DAE.Exp i_s;
      DAE.Exp i_v2;
      DAE.Exp i_v1;
      DAE.Exp i_n;
      DAE.Exp i_A;
      list<DAE.Exp> i_arrays;
      DAE.Exp i_dim;
      DAE.Exp i_call;
      list<DAE.Exp> i_dims;
      DAE.Exp i_val;
      DAE.Exp i_array;
      DAE.Exp i_e;
      DAE.Exp i_arg;
      DAE.ComponentRef i_arg_componentRef;
      DAE.Exp i_exp;
      DAE.Exp i_e3;
      DAE.ExpType i_ty;
      String i_string;
      DAE.Exp i_e2;
      DAE.Exp i_e1;
      Tpl.Text l_retVar;
      Tpl.Text l_retType;
      Tpl.Text l_funName;
      String ret_43;
      Tpl.Text l_res;
      Tpl.Text l_expPart;
      Tpl.Text l_castedVar;
      Tpl.Text l_signdigExp;
      Tpl.Text l_leftjustExp;
      Tpl.Text l_minlenExp;
      Tpl.Text l_formatExp;
      Tpl.Text l_sExp;
      Tpl.Text l_typeStr;
      Integer ret_33;
      Tpl.Text l_arrays__exp;
      Tpl.Text l_dim__exp;
      Tpl.Text txt_29;
      String ret_29;
      Integer ret_28;
      Tpl.Text l_dimsExp;
      Tpl.Text l_valExp;
      Tpl.Text txt_25;
      Tpl.Text txt_24;
      Tpl.Text l_tvar;
      Tpl.Text l_arr__tp__str;
      Tpl.Text l_expVar;
      Tpl.Text l_argStr;
      DAE.Exp ret_19;
      DAE.Exp ret_18;
      Tpl.Text l_retPre;
      Tpl.Text l_ty__str;
      Tpl.Text l_arr;
      Boolean ret_14;
      Tpl.Text txt_12;
      String ret_12;
      Tpl.Text txt_10;
      String ret_10;
      Tpl.Text txt_8;
      String ret_8;
      Tpl.Text txt_6;
      String ret_6;
      Tpl.Text l_var;
      Tpl.Text l_type;
      String ret_3;
      Tpl.Text l_var3;
      Tpl.Text l_var2;
      Tpl.Text l_var1;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION"), expLst = {i_e1, i_e2, DAE.SCONST(string = i_string)}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        ret_3 = Util.escapeModelicaStringToCString(i_string);
        l_var3 = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DIVISION("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = Tpl.writeText(txt, l_var3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = i_ty), path = Absyn.IDENT(name = "DIVISION_ARRAY_SCALAR"), expLst = {i_e1, i_e2, (i_e3 as DAE.SHARED_LITERAL(index = _))}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_745(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        (l_var1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_varDecls);
        (l_var2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_varDecls);
        (l_var3, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e3, a_context, a_preExp, a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("division_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_scalar(&"));
        a_preExp = Tpl.writeText(a_preExp, l_var1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_var3);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CALL(path = Absyn.IDENT(name = "DIVISION_ARRAY_SCALAR"))),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_6 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support "));
        ret_6 = ExpressionDump.printExpStr(i_exp);
        txt_6 = Tpl.writeStr(txt_6, ret_6);
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 5212, 11), Tpl.textString(txt_6));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$DER"));
        txt = cref(txt, i_arg_componentRef);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {i_exp}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_8 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support der("));
        ret_8 = ExpressionDump.printExpStr(i_exp);
        txt_8 = Tpl.writeStr(txt_8, ret_8);
        txt_8 = Tpl.writeTok(txt_8, Tpl.ST_STRING(")"));
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 5217, 11), Tpl.textString(txt_8));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "pre"), expLst = {i_arg}),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCallPre(txt, i_arg, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "edge"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = cref(txt, i_arg_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_arg_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "edge"), expLst = {i_exp}),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_10 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Code generation does not support edge("));
        ret_10 = ExpressionDump.printExpStr(i_exp);
        txt_10 = Tpl.writeStr(txt_10, ret_10);
        txt_10 = Tpl.writeTok(txt_10, Tpl.ST_STRING(")"));
        txt = error(txt, Tpl.sourceInfo("SimCodeC.tpl", 5223, 11), Tpl.textString(txt_10));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "change"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
         