// $Id: MOParametersDlg.cpp 10144 2011-10-18 11:42:23Z hubert.thieriot $
/**
 * This file is part of OpenModelica.
 *
 * Copyright (c) 1998-CurrentYear, Open Source Modelica Consortium (OSMC),
 * c/o Linköpings universitet, Department of Computer and Information Science,
 * SE-58183 Linköping, Sweden.
 *
 * All rights reserved.
 *
 * THIS PROGRAM IS PROVIDED UNDER THE TERMS OF GPL VERSION 3 LICENSE OR 
 * THIS OSMC PUBLIC LICENSE (OSMC-PL). 
 * ANY USE, REPRODUCTION OR DISTRIBUTION OF THIS PROGRAM CONSTITUTES RECIPIENT'S ACCEPTANCE
 * OF THE OSMC PUBLIC LICENSE OR THE GPL VERSION 3, ACCORDING TO RECIPIENTS CHOICE. 
 *
 * The OpenModelica software and the Open Source Modelica
 * Consortium (OSMC) Public License (OSMC-PL) are obtained
 * from OSMC, either from the above address,
 * from the URLs: http://www.ida.liu.se/projects/OpenModelica or  
 * http://www.openmodelica.org, and in the OpenModelica distribution. 
 * GNU version 3 is obtained from: http://www.gnu.org/copyleft/gpl.html.
 *
 * This program is distributed WITHOUT ANY WARRANTY; without
 * even the implied warranty of  MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE, EXCEPT AS EXPRESSLY SET FORTH
 * IN THE BY RECIPIENT SELECTED SUBSIDIARY LICENSE CONDITIONS OF OSMC-PL.
 *
 * See the full OSMC Public License conditions for more details.
 *
 * Main contributor 2010, Hubert Thierot, CEP - ARMINES (France)
 * Main contributor 2010, Hubert Thierot, CEP - ARMINES (France)

  @file MOParametersDlg.cpp
  @brief Comments for file documentation.
  @author Hubert Thieriot, hubert.thieriot@mines-paristech.fr
  Company : CEP - ARMINES (France)
  http://www-cep.ensmp.fr/english/
  @version
*/

#include "MOParametersDlg.h"
#include "MOTableView.h"
#include <QtGui/QScrollBar>

MOParametersDlg::MOParametersDlg(MOParameters *parameters, bool editable)
{
    this->setWindowTitle("Parameters");
    //    if(parameters->size()==0)
    //    {
    //        // simulate an accept() (doesn't work in ctor)
    //        // no need to wait for a click on OK !
    //        setResult(QDialog::Accepted);
    //        QApplication::postEvent( this, new QCloseEvent() );
    //    }




    _orgParameters = parameters;
    _localParameters = _orgParameters->clone();

    _editable = editable;


    QGridLayout *newLayout = buildLayoutFromParameters();
    this->setLayout(newLayout);

}

//QGridLayout* MOParametersDlg::buildLayoutFromParameters()
//{
//    //Adding Layout
//    QGridLayout *mainLayout = new QGridLayout(this);

//    // get groups
//    QMultiMap<QString,MOParameter*> map = _localParameters->map();
//    QStringList groups = map.uniqueKeys();


//    QStringList paramNames;
//    for(int i=0;i<_localParameters->size();i++)
//        paramNames.push_back(_localParameters->at(i)->name());


//    MOParameter* parameter;
//    MOParameterListed *paramList;
//    // create group box
//    for(int iG=0;iG<groups.size();iG++)
//    {
//        int iRow=0;
//        QGroupBox *box = new QGroupBox(groups.at(iG),this);
//        QGridLayout *boxLayout = new QGridLayout(box);
//        QPushButton* newPush;

//        for(int iP=0;iP<map.values(groups.at(iG)).size();iP++)
//        {
//            parameter = map.values(groups.at(iG)).at(iP);
//            // add setting
//            QString dispName;
//            if(parameter->name().contains("/"))
//                dispName = parameter->name().section("/",1,-1);
//            else
//                dispName = parameter->name();


//            boxLayout->addWidget(new QLabel(dispName),iRow,0);
//            boxLayout->addWidget(new QLabel(parameter->description()),iRow,3);

//            int type = parameter->getFieldValue(MOParameter::TYPE).toInt();
//            QWidget *valueWidget;
//            QVariant value = parameter->getFieldValue(MOParameter::VALUE);

//            switch(type)
//            {
//            case MOParameter::STRING :
//                valueWidget = new QLineEdit(this);
//                ((QLineEdit*)valueWidget)->setText(value.toString());
//                break;
//            case MOParameter::FILEPATH :
//                valueWidget = new QLineEdit(this);
//                ((QLineEdit*)valueWidget)->setText(value.toString());
//                // add button
//                newPush = new QPushButton("...",this);
//                newPush->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Preferred);
//                _pathsMap.insert(newPush,((QLineEdit*)valueWidget));
//                boxLayout->addWidget(newPush,iRow,2);
//                connect(newPush,SIGNAL(clicked()),this,SLOT(onSelectFileClicked()));

//                break;
//            case MOParameter::FOLDERPATH :
//                valueWidget = new QLineEdit(this);
//                ((QLineEdit*)valueWidget)->setText(value.toString());
//                //add button
//                newPush = new QPushButton("...",this);
//                newPush->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Preferred);
//                _pathsMap.insert(newPush,((QLineEdit*)valueWidget));
//                boxLayout->addWidget(newPush,iRow,2);
//                connect(newPush,SIGNAL(clicked()),this,SLOT(onSelectFolderClicked()));
//                break;
//            case MOParameter::DOUBLE :
//                valueWidget = new QDoubleSpinBox(this);
//                ((QDoubleSpinBox*)valueWidget)->setValue(value.toDouble());
//                break;
//            case MOParameter::INT :
//                valueWidget = new QSpinBox(this);
//                ((QSpinBox*)valueWidget)->setMinimum(-1);
//                ((QSpinBox*)valueWidget)->setValue(value.toInt());
//                break;
//            case MOParameter::BOOL :
//                valueWidget = new QCheckBox(this);
//                Qt::CheckState state;
//                if(value.toBool())
//                    state = Qt::Checked;
//                else
//                    state = Qt::Unchecked;
//                ((QCheckBox*)valueWidget)->setCheckState(state);
//                break;
//            case MOParameter::LIST :
//                //if is a list, param should be a MOParameterListed
//                valueWidget = new QComboBox(this);
//                paramList = dynamic_cast<MOParameterListed*>(parameter);
//                if(paramList)
//                {
//                    //adding list items in qcombobox
//                    for(int iValue = 0 ; iValue<paramList->mapList().keys().size();iValue++)
//                    {
//                        ((QComboBox*)valueWidget)->addItem(
//                                    paramList->mapList().values().at(iValue),
//                                    paramList->mapList().keys().at(iValue));
//                    }
//                    // set current index
//                    ((QComboBox*)valueWidget)->setCurrentIndex(((QComboBox*)valueWidget)->findData(value));
//                    connect(((QComboBox*)valueWidget),SIGNAL(currentIndexChanged(int)),this,SLOT(onValueChanged()));
//                }
//                break;
//            default :
//                valueWidget = new QLineEdit(this);
//                ((QLineEdit*)valueWidget)->setText(value.toString());
//                break;

//            }

//            boxLayout->addWidget(valueWidget,iRow,1);
//            valueWidget->setEnabled(_editable);


//            // store (to save data when click ok)
//            _mapValueWidgets.insert(parameter->getFieldValue(MOParameter::INDEX).toInt(),valueWidget);
//            _paramNames.push_back(parameter->name());
//            _paramTypes.push_back(type);


//            iRow++;
//        }
//        box->setLayout(boxLayout);

//        mainLayout->addWidget(box);
//    }




//    QHBoxLayout *buttonsLayout = new QHBoxLayout(this);
//    QPushButton *pushDefault = new QPushButton("Restore default",this);
//    QPushButton *pushCancel = new QPushButton("Cancel",this);
//    QPushButton *pushOk = new QPushButton("Ok",this);

//    buttonsLayout->addItem(new QSpacerItem(20, 40, QSizePolicy::Expanding, QSizePolicy::Minimum));
//    buttonsLayout->addWidget(pushDefault);
//    buttonsLayout->addWidget(pushCancel);
//    buttonsLayout->addWidget(pushOk);

//    connect(pushCancel,SIGNAL(clicked()),this,SLOT(pushedCancel()));
//    connect(pushOk,SIGNAL(clicked()),this,SLOT(pushedOk()));
//    connect(pushDefault,SIGNAL(clicked()),this,SLOT(pushedDefault()));

//    pushOk->setDefault(true);

//    QWidget *buttonsWidget = new QWidget(this);
//    buttonsWidget->setLayout(buttonsLayout);

//    mainLayout->addWidget(buttonsWidget);

//    return mainLayout;
//}



QGridLayout* MOParametersDlg::buildLayoutFromParameters()
{
    //Adding Layout
    QGridLayout *mainLayout = new QGridLayout(this);

    // get groups
    QMultiMap<QString,MOParameter*> map = _localParameters->map();
    QStringList groups = map.uniqueKeys();


    QStringList paramNames;
    for(int i=0;i<_localParameters->size();i++)
        paramNames.push_back(_localParameters->at(i)->name());

    QPushButton *newPush;
    MOParameter* parameter;
    MOParameterListed *paramList;

    // create group box
    for(int iG=0;iG<groups.size();iG++)
    {
        int iRow=0;
        QGroupBox *box = new QGroupBox(groups.at(iG),this);
        QGridLayout *boxLayout = new QGridLayout(box);

        for(int iP=0;iP<map.values(groups.at(iG)).size();iP++)
        {
            parameter = map.values(groups.at(iG)).at(iP);
            // add setting
            QString dispName;
            if(parameter->name().contains("/"))
                dispName = parameter->name().section("/",1,-1);
            else
                dispName = parameter->name();

            boxLayout->addWidget(new QLabel(parameter->description()),iRow,0);
            //boxLayout->addWidget(new QLabel(dispName),iRow,0);

            int type = parameter->getFieldValue(MOParameter::TYPE).toInt();
            QWidget *valueWidget;
            QVariant value = parameter->getFieldValue(MOParameter::VALUE);

            switch(type)
            {
            case MOParameter::STRING :
                valueWidget = new QLineEdit(this);
                ((QLineEdit*)valueWidget)->setText(value.toString());
                connect(((QLineEdit*)valueWidget),SIGNAL(textChanged(QString)),this,SLOT(onValueChanged()));
                break;
            case MOParameter::FILEPATH :
                valueWidget = new QLineEdit(this);
                ((QLineEdit*)valueWidget)->setText(value.toString());
                connect(((QLineEdit*)valueWidget),SIGNAL(textChanged(QString)),this,SLOT(onValueChanged()));
                // add button
                newPush = new QPushButton("...",this);
                newPush->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Preferred);
                _pathsMap.insert(newPush,((QLineEdit*)valueWidget));
                boxLayout->addWidget(newPush,iRow,2);
                connect(newPush,SIGNAL(clicked()),this,SLOT(onSelectFileClicked()));
                break;
            case MOParameter::FOLDERPATH :
                valueWidget = new QLineEdit(this);
                ((QLineEdit*)valueWidget)->setText(value.toString());
                connect(((QLineEdit*)valueWidget),SIGNAL(textChanged(QString)),this,SLOT(onValueChanged()));
                //add button
                newPush = new QPushButton("...",this);
                newPush->setSizePolicy(QSizePolicy::Maximum,QSizePolicy::Preferred);
                _pathsMap.insert(newPush,((QLineEdit*)valueWidget));
                boxLayout->addWidget(newPush,iRow,2);
                connect(newPush,SIGNAL(clicked()),this,SLOT(onSelectFolderClicked()));
                break;

            case MOParameter::DOUBLE :
                valueWidget = new QDoubleSpinBox(this);
                ((QDoubleSpinBox*)valueWidget)->setMinimum(parameter->getFieldValue(MOParameter::MIN).toDouble());
                ((QDoubleSpinBox*)valueWidget)->setMaximum(parameter->getFieldValue(MOParameter::MAX).toDouble());
                ((QDoubleSpinBox*)valueWidget)->setDecimals(10);
                ((QDoubleSpinBox*)valueWidget)->setValue(value.toDouble());
                connect(((QDoubleSpinBox*)valueWidget),SIGNAL(valueChanged(double)),this,SLOT(onValueChanged()));
                break;
            case MOParameter::INT :
                valueWidget = new QSpinBox(this);
                ((QSpinBox*)valueWidget)->setMinimum(parameter->getFieldValue(MOParameter::MIN).toInt());
                ((QSpinBox*)valueWidget)->setMaximum(parameter->getFieldValue(MOParameter::MAX).toInt());
                ((QSpinBox*)valueWidget)->setValue(value.toInt());
                connect(((QSpinBox*)valueWidget),SIGNAL(valueChanged(int)),this,SLOT(onValueChanged()));
                break;
            case MOParameter::BOOL :
                valueWidget = new QCheckBox(this);
                Qt::CheckState state;
                if(value.toBool())
                    state = Qt::Checked;
                else
                    state = Qt::Unchecked;
                connect(((QCheckBox*)valueWidget),SIGNAL(stateChanged(int)),this,SLOT(onValueChanged()));
                ((QCheckBox*)valueWidget)->setCheckState(state);
                break;
            case MOParameter::LIST :
                //if is a list, param should be a MOParameterListed
                valueWidget = new QComboBox(this);
                paramList = dynamic_cast<MOParameterListed*>(parameter);
                if(paramList)
                {
                    //adding list items in qcombobox
                    for(int iValue = 0 ; iValue<paramList->mapList().keys().size();iValue++)
                    {
                        ((QComboBox*)valueWidget)->addItem(
                                    paramList->mapList().values().at(iValue),
                                    paramList->mapList().keys().at(iValue));
                    }
                    // set current index
                    ((QComboBox*)valueWidget)->setCurrentIndex(((QComboBox*)valueWidget)->findData(value));
                    connect(((QComboBox*)valueWidget),SIGNAL(currentIndexChanged(int)),this,SLOT(onValueChanged()));
                }
                break;
            default :
                valueWidget = new QLineEdit(this);
                ((QLineEdit*)valueWidget)->setText(value.toString());
                 connect(((QLineEdit*)valueWidget),SIGNAL(textChanged(QString)),this,SLOT(onValueChanged()));
                break;

            }

            boxLayout->addWidget(valueWidget,iRow,1);
            valueWidget->setEnabled(_editable);

            // store (to save data when click ok)
            _mapValueWidgets.insert(parameter->getFieldValue(MOParameter::INDEX).toInt(),valueWidget);
            _paramNames.push_back(parameter->name());
            _paramTypes.push_back(type);

            iRow++;
        }
        box->setLayout(boxLayout);

        mainLayout->addWidget(box);
    }


    QHBoxLayout *buttonsLayout = new QHBoxLayout(this);


    QPushButton *pushOk = new QPushButton("Ok",this);

    buttonsLayout->addItem(new QSpacerItem(20, 40, QSizePolicy::Expanding, QSizePolicy::Minimum));

    buttonsLayout->addWidget(pushOk);
    connect(pushOk,SIGNAL(clicked()),this,SLOT(pushedOk()));

    if(_editable)
    {
        QPushButton *pushDefault = new QPushButton("Restore default",this);
        connect(pushDefault,SIGNAL(clicked()),this,SLOT(pushedDefault()));
        QPushButton *pushCancel = new QPushButton("Cancel",this);
        connect(pushCancel,SIGNAL(clicked()),this,SLOT(pushedCancel()));

        buttonsLayout->addWidget(pushDefault);
        buttonsLayout->addWidget(pushCancel);
    }

    pushOk->setDefault(true);

    QWidget *buttonsWidget = new QWidget(this);
    buttonsWidget->setLayout(buttonsLayout);

    mainLayout->addWidget(buttonsWidget);

    if(_editable)
        updateEnabled(); //update

    return mainLayout;
}

void MOParametersDlg::onValueChanged()
{

    QWidget* widgetChanged = dynamic_cast<QWidget*>(sender());

    // update value
    int index = _mapValueWidgets.key(widgetChanged,-1);
    if(index>-1)
        _localParameters->setValue(index,getValue(widgetChanged));

    // update enabled widgets
    if(widgetChanged)
        updateEnabled();
}



void MOParametersDlg::updateEnabled()
{
    MOParameter* curParam;
    QWidget* curWidget;
    for(int i=0;i<_localParameters->size();i++)
    {
        curParam = _localParameters->at(i);
           curWidget = _mapValueWidgets.value(curParam->getFieldValue(MOParameter::INDEX).toInt(),NULL);

           if(curWidget)
           {
            curWidget->setEnabled(_localParameters->shouldBeEnabled(i));
           }
        }
    }

QVariant MOParametersDlg::getValue(QWidget* curWidget)
{

    QLineEdit* lineEdit = dynamic_cast<QLineEdit*>(curWidget);
    if(lineEdit)
        return lineEdit->text();

    QDoubleSpinBox* dblspinbox = dynamic_cast<QDoubleSpinBox*>(curWidget);
    if(dblspinbox)
        return dblspinbox->value();

    QSpinBox* spinbox = dynamic_cast<QSpinBox*>(curWidget);
    if(spinbox)
        return spinbox->value();

    QCheckBox* checkbox = dynamic_cast<QCheckBox*>(curWidget);
    if(checkbox)
        return checkbox->isChecked();

    QComboBox* combo = dynamic_cast<QComboBox*>(curWidget);
    if(combo)
        return combo->itemData(combo->currentIndex());
}

void MOParametersDlg::setValue(QWidget* curWidget,QVariant value)
    {

    QLineEdit* lineEdit = dynamic_cast<QLineEdit*>(curWidget);
    if(lineEdit)
        lineEdit->setText(value.toString());

    QDoubleSpinBox* dblspinbox = dynamic_cast<QDoubleSpinBox*>(curWidget);
    if(dblspinbox)
        dblspinbox->setValue(value.toDouble());

    QSpinBox* spinbox = dynamic_cast<QSpinBox*>(curWidget);
    if(spinbox)
        spinbox->setValue(value.toInt());

    QCheckBox* checkbox = dynamic_cast<QCheckBox*>(curWidget);
    if(checkbox)
        checkbox->setChecked(value.toBool());

    QComboBox* combo = dynamic_cast<QComboBox*>(curWidget);
    if(combo)
        {
        combo->setCurrentIndex(combo->findData(value));
        }

    }


void MOParametersDlg::pushedOk()
{
    _orgParameters->cloneFromOtherVector(_localParameters);
    accept();
}

void MOParametersDlg::pushedCancel()
{
    reject();
}

void MOParametersDlg::pushedDefault()
{

    QSettings globalSettings("MO", "Settings");
    QVariant defaultValue;
    QVariant curValue;
    MOParameter* curParam;
    QWidget* curWidget;
    int curIndex;
    int iParam;


    for(int i=0;i<_mapValueWidgets.keys().size();i++)
    {
        curIndex = _mapValueWidgets.keys().at(i);
        iParam = _localParameters->findItem(curIndex,MOParameter::INDEX);
        curParam = _localParameters->at(iParam);
        curWidget = _mapValueWidgets.value(curIndex,NULL);

        // get default value
        defaultValue = curParam->getFieldValue(MOParameter::DEFAULTVALUE);

        setValue(curWidget,defaultValue);
    }
}


void MOParametersDlg::onSelectFileClicked()
        {
    QPushButton* button = dynamic_cast<QPushButton*>(sender());

    QLineEdit* line = _pathsMap.value(button,NULL);

    if(line)
    {
        QString filename = QFileDialog::getOpenFileName(this);
        if(!filename.isEmpty())
            line->setText(filename);
        }
    }

void MOParametersDlg::onSelectFolderClicked()
{
    QPushButton* button = dynamic_cast<QPushButton*>(sender());

    QLineEdit* line = _pathsMap.value(button,NULL);

    if(line)
    {
        QString filename = QFileDialog::getExistingDirectory(this);
        if(!filename.isEmpty())
            line->setText(filename);
}
}

