encapsulated package CodegenC
"
  file:        CodegenC.mo
  package:     CodegenC
  description: Generated by Susan.
  
  $Id$
"

public import Tpl;

public import SimCode;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;

protected function fun_27
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;
  input String in_a_fileNamePrefix;
  input Tpl.Text in_a_guid;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simulationSettingsOpt, in_a_fileNamePrefix, in_a_guid, in_a_simCode)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      Tpl.Text a_guid;
      SimCode.SimCode a_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix,
           a_guid,
           a_simCode )
      equation
        txt_0 = simulationInitFile(Tpl.emptyTxt, a_simCode, Tpl.textString(a_guid));
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_init.xml"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end matchcontinue;
end fun_27;

protected function fun_28
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<DAE.Exp> in_a_literals;
  input list<SimCode.Function> in_a_modelInfo_functions;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_literals, in_a_modelInfo_functions, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      list<DAE.Exp> a_literals;
      list<SimCode.Function> a_modelInfo_functions;
      String a_fileNamePrefix;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_literals,
           a_modelInfo_functions,
           a_fileNamePrefix )
      equation
        txt_0 = parModelicaKernelsFile(Tpl.emptyTxt, a_fileNamePrefix, a_modelInfo_functions, a_literals);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_kernels.cl"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end matchcontinue;
end fun_28;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<DAE.Exp> i_literals;
      list<SimCode.RecordDeclaration> i_recordDecls;
      list<SimCode.Function> i_modelInfo_functions;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Boolean ret_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text l_0__;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text l_guid;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, recordDecls = i_recordDecls, literals = i_literals, simulationSettingsOpt = i_simulationSettingsOpt)) )
      equation
        ret_1 = System.getUUIDStr();
        l_guid = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        txt_2 = simulationMakefile(Tpl.emptyTxt, i_simCode);
        txt_3 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt_4 = simulationFunctionsHeaderFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_recordDecls);
        txt_5 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING("_functions.h"));
        Tpl.textFile(txt_4, Tpl.textString(txt_5));
        txt_6 = simulationFunctionsFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_literals);
        txt_7 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_7 = Tpl.writeTok(txt_7, Tpl.ST_STRING("_functions.c"));
        Tpl.textFile(txt_6, Tpl.textString(txt_7));
        txt_8 = recordsFile(Tpl.emptyTxt, i_fileNamePrefix, i_recordDecls);
        txt_9 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_9 = Tpl.writeTok(txt_9, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_8, Tpl.textString(txt_9));
        l_0__ = fun_27(Tpl.emptyTxt, i_simulationSettingsOpt, i_fileNamePrefix, l_guid, i_simCode);
        txt_11 = simulationHeaderFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        txt_12 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("_"));
        txt_12 = Tpl.writeStr(txt_12, i_fileNamePrefix);
        txt_12 = Tpl.writeTok(txt_12, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_11, Tpl.textString(txt_12));
        txt_13 = simulationFile(Tpl.emptyTxt, i_simCode, Tpl.textString(l_guid));
        txt_14 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_14 = Tpl.writeTok(txt_14, Tpl.ST_STRING(".c"));
        Tpl.textFile(txt_13, Tpl.textString(txt_14));
        ret_15 = Config.acceptParModelicaGrammar();
        txt = fun_28(txt, ret_15, i_literals, i_modelInfo_functions, i_fileNamePrefix);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end translateModel;

protected function fun_30
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;
  input Tpl.Text in_a_filePrefix;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_mainFunction, in_a_filePrefix, in_a_functionCode)
    local
      Tpl.Text txt;
      Tpl.Text a_filePrefix;
      SimCode.FunctionCode a_functionCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_filePrefix,
           a_functionCode )
      equation
        txt_0 = functionsMakefile(Tpl.emptyTxt, a_functionCode);
        txt_1 = Tpl.writeText(Tpl.emptyTxt, a_filePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end matchcontinue;
end fun_30;

public function translateFunctions
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_functionCode)
    local
      Tpl.Text txt;
      SimCode.FunctionCode i_functionCode;
      list<DAE.Exp> i_literals;
      list<String> i_externalFunctionIncludes;
      list<SimCode.RecordDeclaration> i_extraRecordDecls;
      list<SimCode.Function> i_functions;
      Option<SimCode.Function> i_mainFunction;
      String i_name;
      Tpl.Text l_0__;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text l_filePrefix;

    case ( txt,
           (i_functionCode as SimCode.FUNCTIONCODE(name = i_name, mainFunction = i_mainFunction, functions = i_functions, extraRecordDecls = i_extraRecordDecls, externalFunctionIncludes = i_externalFunctionIncludes, literals = i_literals)) )
      equation
        l_filePrefix = Tpl.writeStr(Tpl.emptyTxt, i_name);
        txt_1 = functionsHeaderFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_mainFunction, i_functions, i_extraRecordDecls, i_externalFunctionIncludes, i_literals);
        txt_2 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_1, Tpl.textString(txt_2));
        txt_3 = functionsFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_mainFunction, i_functions);
        txt_4 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_4 = Tpl.writeTok(txt_4, Tpl.ST_STRING(".c"));
        Tpl.textFile(txt_3, Tpl.textString(txt_4));
        txt_5 = recordsFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_extraRecordDecls);
        txt_6 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_6 = Tpl.writeTok(txt_6, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_5, Tpl.textString(txt_6));
        l_0__ = fun_30(Tpl.emptyTxt, i_mainFunction, l_filePrefix, i_functionCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end translateFunctions;

protected function fun_32
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), jacobianMatrixes = i_jacobianMatrixes) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Simulation code for "));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(". */\n"));
        txt = variableDefinitions(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = variableDefinitionsJacobians(txt, i_jacobianMatrixes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_32;

public function simulationHeaderFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_32(txt, a_simCode);
end simulationHeaderFile;

protected function fun_34
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simulationSettingsOpt)
    local
      Tpl.Text txt;
      String i_settings_method;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(method = i_settings_method)) )
      equation
        txt = Tpl.writeStr(txt, i_settings_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_34;

public function simulationFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      list<SimCode.SimEqSystem> i_algorithmAndEquationAsserts;
      list<DAE.ComponentRef> i_discreteModelVars;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<SimCode.HelpVarInfo> i_helpVarInfo;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_algebraicEquations;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_residualEquations;
      list<SimCode.SimEqSystem> i_startValueEquations;
      list<SimCode.SimEqSystem> i_sampleEquations;
      list<SimCode.SampleCondition> i_sampleConditions;
      SimCode.ExtObjInfo i_extObjInfo;
      SimCode.DelayedExpression i_delayedExps;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.ModelInfo i_modelInfo;
      String i_fileNamePrefix;
      list<String> i_externalFunctionIncludes;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_4;
      list<SimCode.SimEqSystem> ret_3;
      list<SimCode.SimEqSystem> ret_2;
      list<SimCode.SimEqSystem> ret_1;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(externalFunctionIncludes = i_externalFunctionIncludes, fileNamePrefix = i_fileNamePrefix, modelInfo = i_modelInfo, allEquations = i_allEquations, jacobianMatrixes = i_jacobianMatrixes, delayedExps = i_delayedExps, extObjInfo = i_extObjInfo, sampleConditions = i_sampleConditions, sampleEquations = i_sampleEquations, startValueEquations = i_startValueEquations, residualEquations = i_residualEquations, parameterEquations = i_parameterEquations, odeEquations = i_odeEquations, simulationSettingsOpt = i_simulationSettingsOpt, algebraicEquations = i_algebraicEquations, whenClauses = i_whenClauses, helpVarInfo = i_helpVarInfo, zeroCrossings = i_zeroCrossings, discreteModelVars = i_discreteModelVars, algorithmAndEquationAsserts = i_algorithmAndEquationAsserts)),
           a_guid )
      equation
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = externalFunctionIncludes(txt, i_externalFunctionIncludes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"_"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.c\"\n",
                                    "/* dummy VARINFO and FILEINFO */\n",
                                    "const FILE_INFO dummyFILE_INFO = {\"\",-1,-1,-1,-1,1};\n",
                                    "const VAR_INFO dummyVAR_INFO = {-1,\"\",\"\",(FILE_INFO){\"\",-1,-1,-1,-1,1}};\n",
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "int measure_time_flag = 1;\n",
                                    "#else\n",
                                    "int measure_time_flag = 0;\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        ret_0 = SimCode.appendAllequations(i_jacobianMatrixes);
        ret_1 = SimCode.appendLists(i_allEquations, ret_0);
        txt = functionInitializeDataStruc(txt, i_modelInfo, i_fileNamePrefix, a_guid, ret_1, i_delayedExps);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_2 = SimCode.appendAllequations(i_jacobianMatrixes);
        ret_3 = SimCode.appendLists(i_allEquations, ret_2);
        txt = functionInitializeDataStruc2(txt, i_modelInfo, ret_3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCallExternalObjectConstructors(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCallExternalObjectDestructors(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionExtraResiduals(txt, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOutput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitSample(txt, i_sampleConditions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionSampleEquations(txt, i_sampleEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionStoreDelayed(txt, i_delayedExps);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionUpdateBoundStartValues(txt, i_startValueEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitialResidual(txt, i_residualEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionUpdateBoundParameters(txt, i_parameterEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_4 = fun_34(Tpl.emptyTxt, i_simulationSettingsOpt);
        (txt, txt_4) = functionODE(txt, i_odeEquations, txt_4);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAlgebraic(txt, i_algebraicEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionDAE(txt, i_allEquations, i_whenClauses, i_helpVarInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOnlyZeroCrossing(txt, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCheckForDiscreteChanges(txt, i_discreteModelVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAssertsforCheck(txt, i_algorithmAndEquationAsserts);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAnalyticJacobians(txt, i_jacobianMatrixes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionlinearmodel(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif\n",
                                    "\n",
                                    "/* forward the main in the simulation runtime */\n",
                                    "extern int _main_SimulationRuntime(int argc, char**argv, DATA *data);\n",
                                    "\n",
                                    "/* call the simulation runtime main from our main! */\n",
                                    "int main(int argc, char**argv)\n",
                                    "{\n",
                                    "  DATA data;\n",
                                    "  setupDataStruc(&data);\n",
                                    "  return _main_SimulationRuntime(argc, argv, &data);\n",
                                    "}\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end simulationFile;

public function simulationFileHeader
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(vars = _), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Simulation code for "));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ". */\n",
                                    "\n",
                                    "#include \"openmodelica.h\"\n",
                                    "#include \"openmodelica_func.h\"\n",
                                    "#include \"simulation_data.h\"\n",
                                    "#include \"simulation_runtime.h\"\n",
                                    "#include \"omc_error.h\"\n",
                                    "\n",
                                    "#include <assert.h>\n",
                                    "#include <string.h>\n",
                                    "\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\"\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationFileHeader;

protected function fun_37
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_delayed)
    local
      Tpl.Text txt;
      Integer i_maxDelayedIndex;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(maxDelayedIndex = i_maxDelayedIndex) )
      equation
        txt = Tpl.writeStr(txt, intString(i_maxDelayedIndex));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_37;

public function populateModelInfo
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_fileNamePrefix;
  input String in_a_guid;
  input list<SimCode.SimEqSystem> in_a_allEquations;
  input SimCode.DelayedExpression in_a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo, in_a_fileNamePrefix, in_a_guid, in_a_allEquations, in_a_delayed)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      String a_guid;
      list<SimCode.SimEqSystem> a_allEquations;
      SimCode.DelayedExpression a_delayed;
      list<SimCode.Function> i_functions;
      Integer i_varInfo_numExternalObjects;
      Integer i_varInfo_numResiduals;
      Integer i_varInfo_numInitEquations;
      Integer i_varInfo_numTimeEvents;
      Integer i_varInfo_numZeroCrossings;
      Integer i_varInfo_numStringAliasVars;
      Integer i_varInfo_numBoolAliasVars;
      Integer i_varInfo_numIntAliasVars;
      Integer i_varInfo_numAlgAliasVars;
      Integer i_varInfo_numHelpVars;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numStringParamVars;
      Integer i_varInfo_numBoolParams;
      Integer i_varInfo_numIntParams;
      Integer i_varInfo_numParams;
      Integer i_varInfo_numStringAlgVars;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numAlgVars;
      Integer i_varInfo_numStateVars;
      String i_directory;
      Absyn.Path i_name;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numAlgVars = i_varInfo_numAlgVars, numIntAlgVars = i_varInfo_numIntAlgVars, numBoolAlgVars = i_varInfo_numBoolAlgVars, numStringAlgVars = i_varInfo_numStringAlgVars, numParams = i_varInfo_numParams, numIntParams = i_varInfo_numIntParams, numBoolParams = i_varInfo_numBoolParams, numStringParamVars = i_varInfo_numStringParamVars, numInVars = i_varInfo_numInVars, numOutVars = i_varInfo_numOutVars, numHelpVars = i_varInfo_numHelpVars, numAlgAliasVars = i_varInfo_numAlgAliasVars, numIntAliasVars = i_varInfo_numIntAliasVars, numBoolAliasVars = i_varInfo_numBoolAliasVars, numStringAliasVars = i_varInfo_numStringAliasVars, numZeroCrossings = i_varInfo_numZeroCrossings, numTimeEvents = i_varInfo_numTimeEvents, numInitEquations = i_varInfo_numInitEquations, numResiduals = i_varInfo_numResiduals, numExternalObjects = i_varInfo_numExternalObjects), name = i_name, directory = i_directory, functions = i_functions),
           a_fileNamePrefix,
           a_guid,
           a_allEquations,
           a_delayed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->modelData.modelName = \""));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "data->modelData.modelFilePrefix = \""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "data->modelData.modelDir = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "data->modelData.modelGUID = \"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\";\n",
                                    "\n",
                                    "data->modelData.nStates = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesReal = 2*"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesInteger = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesBoolean = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesString = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersReal = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersInteger = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersBoolean = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersString = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInputVars = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nOutputVars = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nJacobians = 4;\n",
                                    "data->modelData.nHelpVars = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numHelpVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "data->modelData.nAliasReal = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nAliasInteger = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nAliasBoolean = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nAliasString = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "data->modelData.nZeroCrossings = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nSamples = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInitEquations = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInitEquations));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nResiduals = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nExtObjs = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nFunctions = "
                                }, false));
        ret_0 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nEquations = "
                                }, false));
        ret_1 = listLength(a_allEquations);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "data->modelData.nDelayExpressions = "
                                }, false));
        txt = fun_37(txt, a_delayed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end populateModelInfo;

public function functionInitializeDataStruc
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input String a_fileNamePrefix;
  input String a_guid;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.DelayedExpression a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "void setupDataStruc(DATA *data)\n",
                                   "{\n",
                                   "  ASSERT(data,\"Error while initialize Data\");\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := populateModelInfo(out_txt, a_modelInfo, a_fileNamePrefix, a_guid, a_allEquations, a_delayed);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitializeDataStruc;

public function functionInitializeDataStruc2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo, in_a_allEquations)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquations;
      list<SimCode.Function> i_functions;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numHelpVars = _), functions = i_functions),
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void setupDataStruc2(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = globalDataFunctionInfoArray(txt, "function_names", i_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "memcpy(data->modelData.functionNames, &funcInfo, data->modelData.nFunctions*sizeof(FUNCTION_INFO));\n",
                                    "\n"
                                }, true));
        txt = equationInfo(txt, a_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "memcpy(data->modelData.equationInfo, &equationInfo, data->modelData.nEquations*sizeof(EQUATION_INFO));\n",
                                    "\n",
                                    "data->modelData.nProfileBlocks = n_omc_equationInfo_reverse_prof_index;\n",
                                    "data->modelData.equationInfo_reverse_prof_index = (int*) malloc(data->modelData.nProfileBlocks*sizeof(int));\n",
                                    "memcpy(data->modelData.equationInfo_reverse_prof_index, omc_equationInfo_reverse_prof_index, data->modelData.nProfileBlocks*sizeof(int));\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionInitializeDataStruc2;

protected function lm_41
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_41(txt, rest);
      then txt;
  end matchcontinue;
end lm_41;

protected function lm_42
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = globalDataVarDefine(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_42(txt, rest, a_numStateVars);
      then txt;

    case ( txt,
           _ :: rest,
           a_numStateVars )
      equation
        txt = lm_42(txt, rest, a_numStateVars);
      then txt;
  end matchcontinue;
end lm_42;

protected function lm_43
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_numStateVars;
      SimCode.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = globalDataVarDefine(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_43(txt, rest, a_numStateVars);
      then txt;

    case ( txt,
           _ :: rest,
           a_numStateVars )
      equation
        txt = lm_43(txt, rest, a_numStateVars);
      then txt;
  end matchcontinue;
end lm_43;

protected function lm_44
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_44(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_44(txt, rest);
      then txt;
  end matchcontinue;
end lm_44;

protected function lm_45
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "extObjs");
        txt = Tpl.nextIter(txt);
        txt = lm_45(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_45(txt, rest);
      then txt;
  end matchcontinue;
end lm_45;

protected function lm_46
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_46(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_46(txt, rest);
      then txt;
  end matchcontinue;
end lm_46;

protected function lm_47
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_47(txt, rest);
      then txt;
  end matchcontinue;
end lm_47;

protected function lm_48
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_48(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_48(txt, rest);
      then txt;
  end matchcontinue;
end lm_48;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_49(txt, rest);
      then txt;
  end matchcontinue;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_50(txt, rest);
      then txt;
  end matchcontinue;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_51(txt, rest);
      then txt;
  end matchcontinue;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Integer x_i0;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = functionName(txt, i_fn, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_index "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_52(txt, rest);
      then txt;
  end matchcontinue;
end lm_52;

protected function fun_53
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_functions;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_extObjVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_numStateVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars, extObjVars = i_vars_extObjVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars), functions = i_functions) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#define time data->localData[0]->timeValue\n",
                                    "\n",
                                    "/* States */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_41(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* StatesDerivatives */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_42(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Algebraic Vars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_43(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Algebraic Parameter */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_44(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* External Objects */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_45(txt, i_vars_extObjVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Algebraic Integer Vars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_46(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Algebraic Integer Parameter */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_47(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Algebraic Boolean Vars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_48(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Algebraic Boolean Parameters */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_49(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Algebraic String Variables */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_50(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Algebraic String Parameter */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_51(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_functions);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_53;

public function variableDefinitions
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1000);
  out_txt := fun_53(txt, a_modelInfo);
end variableDefinitions;

protected function lm_55
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Absyn.Info i_info;
      String i_var_comment;
      DAE.ComponentRef i_var_name;
      String ret_3;
      String ret_2;
      Tpl.Text txt_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(source = DAE.SOURCE(info = (i_info as Absyn.INFO(fileName = _))), name = i_var_name, comment = i_var_comment) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt_1 = crefStr(Tpl.emptyTxt, i_var_name);
        ret_2 = System.escapedString(Tpl.textString(txt_1));
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",\""));
        ret_3 = Util.escapeModelicaStringToCString(i_var_comment);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",{"));
        txt = infoArgs(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
        txt = Tpl.nextIter(txt);
        txt = lm_55(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_55(txt, rest);
      then txt;
  end matchcontinue;
end lm_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_0__name)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_0__name;
      Integer x_i0;
      DAE.ComponentRef i_var_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(source = DAE.SOURCE(info = Absyn.INFO(fileName = _)), name = i_var_name) :: rest,
           a_0__name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest, a_0__name);
      then txt;

    case ( txt,
           _ :: rest,
           a_0__name )
      equation
        txt = lm_56(txt, rest, a_0__name);
      then txt;
  end matchcontinue;
end lm_56;

protected function fun_57
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_items;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_items, in_a_0__name)
    local
      Tpl.Text txt;
      String a_0__name;
      list<SimCode.SimVar> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_0__name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct VAR_INFO "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{-1,\"\",\"\",omc_dummyFileInfo}};"));
      then txt;

    case ( txt,
           i_items,
           a_0__name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct VAR_INFO "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_55(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_56(txt, i_items, a_0__name);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_57;

public function globalDataVarInfoArray
  input Tpl.Text txt;
  input String a_0__name;
  input list<SimCode.SimVar> a_items;
  input Integer a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_57(txt, a_items, a_0__name);
end globalDataVarInfoArray;

protected function lm_59
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;
      Absyn.Info ret_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = functionName(txt, i_fn, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",{"));
        ret_1 = SimCode.functionInfo(i_fn);
        txt = infoArgs(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
        txt = Tpl.nextIter(txt);
        txt = lm_59(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_59(txt, rest);
      then txt;
  end matchcontinue;
end lm_59;

protected function fun_60
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_items;
      Integer ret_0;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct FUNCTION_INFO funcInfo[1] = {{-1,\"\",omc_dummyFileInfo}};"));
      then txt;

    case ( txt,
           i_items )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct FUNCTION_INFO funcInfo["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_59(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end matchcontinue;
end fun_60;

public function globalDataFunctionInfoArray
  input Tpl.Text txt;
  input String a_name;
  input list<SimCode.Function> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_60(txt, a_items);
end globalDataFunctionInfoArray;

public function globalDataParDefine
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      DAE.ComponentRef i_name;
      Integer i_index;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(i_c), aliasvar = SimCode.NOALIAS(), index = i_index, name = i_name),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$START"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute.start\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].info"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$START"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute.start\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].info"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end globalDataParDefine;

public function globalDataVarDefine
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      DAE.ComponentRef i_name;
      Integer i_index;
      DAE.ComponentRef i_c;
      Integer ret_12;
      Integer ret_11;
      Integer ret_10;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      Integer ret_6;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_tmp;

    case ( txt,
           SimCode.SIMVAR(arrayCref = SOME(i_c), aliasvar = SimCode.NOALIAS(), index = i_index, name = i_name),
           a_arrayName,
           a_offset )
      equation
        ret_1 = System.tmpTick();
        l_tmp = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define _"));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->localData[i]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_2 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define _"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->localData[i]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_3 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre["));
        ret_4 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre["));
        ret_5 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$START"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_6 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute.start\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_7 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].info"));
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        ret_8 = System.tmpTick();
        l_tmp = Tpl.writeStr(Tpl.emptyTxt, intString(ret_8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->localData[i]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_9 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_9));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre["));
        ret_10 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_10));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$START"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_11 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_11));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute.start\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_12 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_12));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].info"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end globalDataVarDefine;

protected function lm_64
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer i_index;
      SimCode.AliasVariable i_aliasvar;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(aliasvar = i_aliasvar, index = i_index) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = aliasVarNameType(txt, i_aliasvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_64(txt, rest);
      then txt;
  end matchcontinue;
end lm_64;

protected function fun_65
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_items;
  input String in_a_0__type;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_items, in_a_0__type, in_a_0__name)
    local
      Tpl.Text txt;
      String a_0__type;
      String a_0__name;
      list<SimCode.SimVar> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{0,0,-1}};"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_items,
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_64(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_65;

public function globalDataAliasVarArray
  input Tpl.Text txt;
  input String a_0__type;
  input String a_0__name;
  input list<SimCode.SimVar> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_65(txt, a_items, a_0__type, a_0__name);
end globalDataAliasVarArray;

protected function lm_67
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      Integer x_index0;
      String i_name;
      list<SimCode.SimVar> i_seedVars;
      list<SimCode.JacobianColumn> i_jacColumn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_jacColumn, i_seedVars, i_name, _, _, _) :: rest )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = variableDefinitionsJacobians2(txt, x_index0, i_jacColumn, i_seedVars, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_67(txt, rest);
      then txt;
  end matchcontinue;
end lm_67;

public function variableDefinitionsJacobians
  input Tpl.Text txt;
  input list<SimCode.JacobianMatrix> a_JacobianMatrixes;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_analyticVars;
algorithm
  l_analyticVars := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_analyticVars := lm_67(l_analyticVars, a_JacobianMatrixes);
  l_analyticVars := Tpl.popIter(l_analyticVars);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("/* Jacobian Variables */\n"));
  out_txt := Tpl.writeText(out_txt, l_analyticVars);
end variableDefinitionsJacobians;

protected function lm_69
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_indexJacobian;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_indexJacobian)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_indexJacobian;
      Integer x_index0;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_indexJacobian )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = jacobianVarDefine(txt, i_var, "jacobianVarsSeed", a_indexJacobian, x_index0);
        txt = Tpl.nextIter(txt);
        txt = lm_69(txt, rest, a_indexJacobian);
      then txt;

    case ( txt,
           _ :: rest,
           a_indexJacobian )
      equation
        txt = lm_69(txt, rest, a_indexJacobian);
      then txt;
  end matchcontinue;
end lm_69;

protected function lm_70
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Integer in_a_indexJacobian;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_indexJacobian)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer a_indexJacobian;
      Integer x_index0;
      SimCode.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_indexJacobian )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = jacobianVarDefine(txt, i_var, "jacobianVars", a_indexJacobian, x_index0);
        txt = Tpl.nextIter(txt);
        txt = lm_70(txt, rest, a_indexJacobian);
      then txt;

    case ( txt,
           _ :: rest,
           a_indexJacobian )
      equation
        txt = lm_70(txt, rest, a_indexJacobian);
      then txt;
  end matchcontinue;
end lm_70;

protected function lm_71
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input Integer in_a_indexJacobian;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_indexJacobian)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      Integer a_indexJacobian;
      list<SimCode.SimVar> i_vars;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (_, i_vars, _) :: rest,
           a_indexJacobian )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_70(txt, i_vars, a_indexJacobian);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_71(txt, rest, a_indexJacobian);
      then txt;

    case ( txt,
           _ :: rest,
           a_indexJacobian )
      equation
        txt = lm_71(txt, rest, a_indexJacobian);
      then txt;
  end matchcontinue;
end lm_71;

public function variableDefinitionsJacobians2
  input Tpl.Text txt;
  input Integer a_indexJacobian;
  input list<SimCode.JacobianColumn> a_jacobianColumn;
  input list<SimCode.SimVar> a_seedVars;
  input String a_name;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_columnVarsResult;
  Tpl.Text l_seedVarsResult;
algorithm
  l_seedVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_seedVarsResult := lm_69(l_seedVarsResult, a_seedVars, a_indexJacobian);
  l_seedVarsResult := Tpl.popIter(l_seedVarsResult);
  l_columnVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                        "\n",
                                                                                        "\n"
                                                                                    }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_columnVarsResult := lm_71(l_columnVarsResult, a_jacobianColumn, a_indexJacobian);
  l_columnVarsResult := Tpl.popIter(l_columnVarsResult);
  out_txt := Tpl.writeText(txt, l_seedVarsResult);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_columnVarsResult);
end variableDefinitionsJacobians2;

protected function fun_73
  input Tpl.Text in_txt;
  input Integer in_a_index;
  input Integer in_a_index0;
  input Integer in_a_indexJac;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_index, in_a_index0, in_a_indexJac, in_a_name)
    local
      Tpl.Text txt;
      Integer a_index0;
      Integer a_indexJac;
      DAE.ComponentRef a_name;
      Integer i_index;

    case ( txt,
           -1,
           a_index0,
           a_indexJac,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo.analyticJacobians["));
        txt = Tpl.writeStr(txt, intString(a_indexJac));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].tmpVars["));
        txt = Tpl.writeStr(txt, intString(a_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo dummyVAR_INFO"));
      then txt;

    case ( txt,
           i_index,
           _,
           a_indexJac,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo.analyticJacobians["));
        txt = Tpl.writeStr(txt, intString(a_indexJac));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].resultVars["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo dummyVAR_INFO"));
      then txt;
  end matchcontinue;
end fun_73;

protected function fun_74
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input Integer in_a_index0;
  input Integer in_a_indexJac;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_index0, in_a_indexJac)
    local
      Tpl.Text txt;
      Integer a_index0;
      Integer a_indexJac;
      DAE.ComponentRef i_name;
      Integer i_index;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name, index = i_index),
           a_index0,
           a_indexJac )
      equation
        txt = fun_73(txt, i_index, a_index0, a_indexJac, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_74;

protected function fun_75
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input Integer in_a_index0;
  input Integer in_a_indexJac;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVar, in_a_index0, in_a_indexJac)
    local
      Tpl.Text txt;
      Integer a_index0;
      Integer a_indexJac;
      DAE.ComponentRef i_name;
      Integer ret_1;
      Tpl.Text l_tmp;

    case ( txt,
           SimCode.SIMVAR(aliasvar = SimCode.NOALIAS(), name = i_name),
           a_index0,
           a_indexJac )
      equation
        ret_1 = System.tmpTick();
        l_tmp = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo.analyticJacobians["));
        txt = Tpl.writeStr(txt, intString(a_indexJac));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].seedVars["));
        txt = Tpl.writeStr(txt, intString(a_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo dummyVAR_INFO"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_75;

protected function fun_76
  input Tpl.Text in_txt;
  input String in_a_array;
  input SimCode.SimVar in_a_simVar;
  input Integer in_a_indexJac;
  input Integer in_a_index0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_array, in_a_simVar, in_a_indexJac, in_a_index0)
    local
      Tpl.Text txt;
      SimCode.SimVar a_simVar;
      Integer a_indexJac;
      Integer a_index0;

    case ( txt,
           "jacobianVars",
           a_simVar,
           a_indexJac,
           a_index0 )
      equation
        txt = fun_74(txt, a_simVar, a_index0, a_indexJac);
      then txt;

    case ( txt,
           "jacobianVarsSeed",
           a_simVar,
           a_indexJac,
           a_index0 )
      equation
        txt = fun_75(txt, a_simVar, a_index0, a_indexJac);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_76;

public function jacobianVarDefine
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_array;
  input Integer a_indexJac;
  input Integer a_index0;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_76(txt, a_array, a_simVar, a_indexJac, a_index0);
end jacobianVarDefine;

public function aliasVarNameType
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_varName;

    case ( txt,
           SimCode.NOALIAS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0,0"));
      then txt;

    case ( txt,
           SimCode.ALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = cref(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",0"));
      then txt;

    case ( txt,
           SimCode.NEGATEDALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = cref(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",1"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end aliasVarNameType;

protected function lm_79
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_arg;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMVAR(initialValue = SOME(i_exp), name = i_var_name) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arg, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_arg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "restore_memory_state(mem_state);"
                                }, false));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_79(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_79(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_79;

protected function lm_80
  input Tpl.Text in_txt;
  input list<SimCode.ExtAlias> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> rest;
      DAE.ComponentRef i_var2;
      DAE.ComponentRef i_var1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var1, i_var2) :: rest )
      equation
        txt = cref(txt, i_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = cref(txt, i_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_80(txt, rest);
      then txt;
  end matchcontinue;
end lm_80;

public function functionCallExternalObjectConstructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extObjInfo)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> i_aliases;
      list<SimCode.SimVar> i_vars;
      Tpl.Text l_ctorCalls;
      Tpl.Text l_varDecls;
      Tpl.Text l_funDecls;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_vars, aliases = i_aliases) )
      equation
        l_funDecls = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_ctorCalls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_ctorCalls, l_varDecls) = lm_79(l_ctorCalls, i_vars, l_varDecls);
        l_ctorCalls = Tpl.popIter(l_ctorCalls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* Has to be performed after _init.xml file has been read */\n",
                                    "void callExternalObjectConstructors(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "state mem_state;\n",
                                    "mem_state = get_memory_state();\n",
                                    "/* data->simulationInfo.extObjs = NULL; */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_ctorCalls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_80(txt, i_aliases);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionCallExternalObjectConstructors;

protected function lm_82
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_var_name;
      Absyn.Path i_ext_fullClassName;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(varKind = BackendDAE.EXTOBJ(fullClassName = i_ext_fullClassName), name = i_var_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_ext_fullClassName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_destructor("));
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_82(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_82(txt, rest);
      then txt;
  end matchcontinue;
end lm_82;

public function functionCallExternalObjectDestructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extObjInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_extObjInfo_vars;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_extObjInfo_vars) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void callExternalObjectDestructors(DATA *data)\n",
                                    "{\n",
                                    "  if (data->simulationInfo.extObjs) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_82(txt, i_extObjInfo_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "free(data->simulationInfo.extObjs);\n",
                                    "data->simulationInfo.extObjs = 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionCallExternalObjectDestructors;

protected function lm_84
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = data->simulationInfo.inputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_84(txt, rest);
      then txt;
  end matchcontinue;
end lm_84;

public function functionInput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_inputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(inputVars = i_vars_inputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int input_function(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_84(txt, i_vars_inputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionInput;

protected function lm_86
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.outputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_86(txt, rest);
      then txt;
  end matchcontinue;
end lm_86;

public function functionOutput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(outputVars = i_vars_outputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int output_function(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_86(txt, i_vars_outputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionOutput;

protected function fun_88
  input Tpl.Text in_txt;
  input Tpl.Text in_a_timeEventCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_timeEventCode)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int i = 0; // Current index"));
      then txt;
  end matchcontinue;
end fun_88;

public function functionInitSample
  input Tpl.Text txt;
  input list<SimCode.SampleCondition> a_sampleConditions;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_timeEventCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_timeEventCode, l_varDecls) := timeEventsTpl(Tpl.emptyTxt, a_sampleConditions, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* Initializes the raw time events of the simulation using the now\n",
                                   "   calcualted parameters. */\n",
                                   "void function_sampleInit(DATA *data)\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := fun_88(out_txt, l_timeEventCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_timeEventCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitSample;

protected function lm_90
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_90(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_90(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_90;

public function functionSampleEquations
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_sampleEqns;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqs;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_tmp, l_varDecls) := lm_90(l_eqs, a_sampleEqns, l_tmp, l_varDecls);
  l_eqs := Tpl.popIter(l_eqs);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int function_updateSample(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionSampleEquations;

protected function lm_92
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_92(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_92(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_92;

protected function lm_93
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DEBUG_INFO_AL2(LOG_INIT, \"   %s(start=%f)\", "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo.name, ("));
        txt = crefType(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "$P$START"
                                }, false));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_93(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_93(txt, rest);
      then txt;
  end matchcontinue;
end lm_93;

public function functionUpdateBoundStartValues
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_startValueEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqPart, l_tmp, l_varDecls) := lm_92(l_eqPart, a_startValueEquations, l_tmp, l_varDecls);
  l_eqPart := Tpl.popIter(l_eqPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int updateBoundStartValues(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_eqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "DEBUG_INFO(LOG_INIT, \"updating start-values:\");\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_93(out_txt, a_startValueEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateBoundStartValues;

protected function fun_95
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      String ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.SCONST(string = _),
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[i++] = 0;"));
      then (txt, a_varDecls);

    case ( txt,
           i_exp,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[i++] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "DEBUG_INFO_AL2(LOG_RES_INIT, \"   residual[%d] : "
                                }, false));
        ret_2 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = %f\", i, initialResiduals[i-1]);"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_95;

protected function lm_96
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp) :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_95(txt, i_exp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_96(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_96(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_96;

public function functionInitialResidual
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_residualEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_varDecls) := lm_96(l_body, a_residualEquations, l_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int initial_residual(DATA *data, double $P$_lambda, double* initialResiduals)\n",
                                   "{\n",
                                   "  int i = 0;\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n",
                                       "DEBUG_INFO(LOG_RES_INIT, \"updating initial_residuals:\");\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialResidual;

protected function lm_98
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_ALGORITHM(statements = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq2, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_98(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_98(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_98;

protected function lm_99
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq2 as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq2, SimCode.contextInlineSolver, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_99(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_99(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_99;

protected function lm_100
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_eq2_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_eq2_exp) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq2_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_100(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_100(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_100;

protected function fun_101
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_index;
      list<SimCode.SimEqSystem> i_eq_eqs;
      SimCode.SimEqSystem i_eq_cont;
      Tpl.Text l_body;
      Tpl.Text l_prebody;
      Tpl.Text l_algs;
      Tpl.Text l_tmp;
      Tpl.Text l_varDecls;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont) )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionExtraResiduals(txt, ret_0);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eq_eqs, index = i_index) )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_tmp = Tpl.emptyTxt;
        l_algs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_algs, l_tmp, l_varDecls) = lm_98(l_algs, i_eq_eqs, l_tmp, l_varDecls);
        l_algs = Tpl.popIter(l_algs);
        l_prebody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_prebody, l_tmp, l_varDecls) = lm_99(l_prebody, i_eq_eqs, l_tmp, l_varDecls);
        l_prebody = Tpl.popIter(l_prebody);
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, l_varDecls) = lm_100(l_body, i_eq_eqs, l_varDecls);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void residualFunc"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int *n, double* xloc, double* res, int* iflag, void* userdata)\n",
                                    "{\n",
                                    "  DATA *data = ((DATA*)userdata);\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ADD_NCALL_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",1);\n",
                                    "#endif\n",
                                    "mem_state = get_memory_state();\n"
                                }, true));
        txt = Tpl.writeText(txt, l_prebody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_algs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("restore_memory_state(mem_state);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_101;

protected function lm_102
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_101(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_102(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_102(txt, rest);
      then txt;
  end matchcontinue;
end lm_102;

public function functionExtraResiduals
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_102(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionExtraResiduals;

protected function lm_104
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_104(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_104(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_104;

protected function lm_105
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_ALGORITHM(statements = _)) :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_105(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_105(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_105;

public function functionUpdateBoundParameters
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_parameterEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_divbody;
  Tpl.Text l_body;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  System.tmpTickReset(0);
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_104(l_body, a_parameterEquations, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  l_divbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_divbody, l_tmp, l_varDecls) := lm_105(l_divbody, a_parameterEquations, l_tmp, l_varDecls);
  l_divbody := Tpl.popIter(l_divbody);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int updateBoundParameters(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_divbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateBoundParameters;

protected function lm_107
  input Tpl.Text in_txt;
  input list<tuple<Integer, DAE.Exp>> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, DAE.Exp>> rest;
      Tpl.Text a_varDecls;
      Integer i_id;
      DAE.Exp i_e;
      Tpl.Text l_eRes;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_id, i_e) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_eRes, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("storeDelayedExpression(data, "));
        txt = Tpl.writeStr(txt, intString(i_id));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_eRes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", time);"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        (txt, a_varDecls) = lm_107(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_107(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_107;

protected function fun_108
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_delayed, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<tuple<Integer, DAE.Exp>> i_delayedExps;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(delayedExps = i_delayedExps),
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_107(txt, i_delayedExps, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_108;

public function functionStoreDelayed
  input Tpl.Text txt;
  input SimCode.DelayedExpression a_delayed;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_storePart;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_storePart, l_varDecls) := fun_108(Tpl.emptyTxt, a_delayed, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int function_storeDelayed(DATA *data)\n",
                                   "{\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_storePart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionStoreDelayed;

public function functionWhenReinitStatement
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_reinit, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_condition;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_msgVar;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  MODELICA_TERMINATE("));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message),
           a_varDecls )
      equation
        (txt, a_varDecls) = assertCommon(txt, i_condition, i_message, SimCode.contextSimulationDiscrete, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end functionWhenReinitStatement;

protected function lm_111
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !data->simulationInfo.helpVarsPre["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_111(txt, rest, a_helpInits, a_varDecls, a_preExp);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_111(txt, rest, a_helpInits, a_varDecls, a_preExp);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_111;

protected function fun_112
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_a_reinits;
  input Tpl.Text in_a_ifthen;
  input Tpl.Text in_a_helpIf;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_preExp;
  input Integer in_a_int;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_reinits, in_a_ifthen, in_a_helpIf, in_a_helpInits, in_a_preExp, in_a_int)
    local
      Tpl.Text txt;
      Tpl.Text a_ifthen;
      Tpl.Text a_helpIf;
      Tpl.Text a_helpInits;
      Tpl.Text a_preExp;
      Integer a_int;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_ifthen,
           a_helpIf,
           a_helpInits,
           a_preExp,
           a_int )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//For whenclause index: "));
        txt = Tpl.writeStr(txt, intString(a_int));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_helpInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, a_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_ifthen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_112;

public function genreinits
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_whenClauses;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_int;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_whenClauses, in_a_varDecls, in_a_int)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer a_int;
      list<BackendDAE.WhenOperator> i_reinits;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_ifthen;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions, reinits = i_reinits),
           a_varDecls,
           a_int )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, l_helpInits, a_varDecls, l_preExp) = lm_111(l_helpIf, i_conditions, l_helpInits, a_varDecls, l_preExp);
        l_helpIf = Tpl.popIter(l_helpIf);
        (l_ifthen, a_varDecls) = functionWhenReinitStatementThen(Tpl.emptyTxt, i_reinits, a_varDecls);
        txt = fun_112(txt, i_reinits, l_ifthen, l_helpIf, l_helpInits, l_preExp, a_int);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end genreinits;

protected function fun_114
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_reinit, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_condition;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_msgVar;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(10));
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "*needToIterate=1;"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message),
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(12));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE("));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message),
           a_varDecls )
      equation
        (txt, a_varDecls) = assertCommon(txt, i_condition, i_message, SimCode.contextSimulationDiscrete, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_114;

protected function lm_115
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      Tpl.Text a_varDecls;
      BackendDAE.WhenOperator i_reinit;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_reinit :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_114(txt, i_reinit, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_115(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_115(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_115;

public function functionWhenReinitStatementThen
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_body;
algorithm
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, out_a_varDecls) := lm_115(l_body, a_reinits, a_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.popBlock(out_txt);
end functionWhenReinitStatementThen;

protected function fun_117
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_reinit, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_val;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_varDecls,
           a_preExp )
      equation
        (l_val, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_117;

protected function lm_118
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      BackendDAE.WhenOperator i_reinit;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_reinit :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = fun_117(txt, i_reinit, a_varDecls, a_preExp);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_118(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_118(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_118;

public function functionWhenReinitStatementElse
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_body;
algorithm
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, out_a_varDecls, out_a_preExp) := lm_118(l_body, a_reinits, a_varDecls, a_preExp);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.popBlock(out_txt);
end functionWhenReinitStatementElse;

protected function lm_120
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_120(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_120(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_120;

public function functionODE_system
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input Integer a_n;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_odeEqs;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_odeEqs, l_tmp, l_varDecls) := lm_120(l_odeEqs, a_derivativEquations, l_tmp, l_varDecls);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("static void functionODE_system"));
  out_txt := Tpl.writeStr(out_txt, intString(a_n));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data,int omc_thread_number)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_odeEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionODE_system;

protected function lm_122
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Integer x_i1;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqs :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = functionODE_system(txt, i_eqs, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_122(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_122(txt, rest);
      then txt;
  end matchcontinue;
end lm_122;

protected function lm_123
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Integer x_i1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("functionODE_system"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_123(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_123(txt, rest);
      then txt;
  end matchcontinue;
end lm_123;

protected function lm_124
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls2) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls2;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls2 )
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_varDecls2, a_tmp) = equation_(txt, i_eq, SimCode.contextInlineSolver, a_varDecls2, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls2) = lm_124(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_tmp, a_varDecls2) = lm_124(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);
  end matchcontinue;
end lm_124;

protected function lm_125
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls2) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls2;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           a_tmp,
           a_varDecls2 )
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           i_eqs :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_tmp, a_varDecls2) = lm_124(txt, i_eqs, a_tmp, a_varDecls2);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls2) = lm_125(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls2 )
      equation
        (txt, a_tmp, a_varDecls2) = lm_125(txt, rest, a_tmp, a_varDecls2);
      then (txt, a_tmp, a_varDecls2);
  end matchcontinue;
end lm_125;

protected function fun_126
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_get_max_threads()"));
      then txt;

    case ( txt,
           _ )
      equation
        ret_0 = Config.noProc();
        txt = Tpl.writeStr(txt, intString(ret_0));
      then txt;
  end matchcontinue;
end fun_126;

protected function fun_127
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      equation
        ret_0 = Config.noProc();
        txt = fun_126(txt, ret_0);
      then txt;
  end matchcontinue;
end fun_127;

protected function fun_128
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dynamic"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static"));
      then txt;
  end matchcontinue;
end fun_128;

protected function fun_129
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel for private(id,th_id) schedule("));
        ret_0 = Config.noProc();
        txt = fun_128(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_129;

protected function fun_130
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_stateContPartInline;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateContPartInline, in_a_varDecls2)
    local
      Tpl.Text txt;
      Tpl.Text a_stateContPartInline;
      Tpl.Text a_varDecls2;

    case ( txt,
           "inline-euler",
           a_stateContPartInline,
           a_varDecls2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// we need to access the inline define that we compiled the simulation with\n",
                                    "// from the simulation runtime.\n",
                                    "int functionODE_inline(DATA* data, double stepSize)\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "mem_state = get_memory_state();\n",
                                    "begin_inline();\n"
                                }, true));
        txt = Tpl.writeText(txt, a_stateContPartInline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "end_inline();\n",
                                    "restore_memory_state(mem_state);\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "inline-rungekutta",
           a_stateContPartInline,
           a_varDecls2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// we need to access the inline define that we compiled the simulation with\n",
                                    "// from the simulation runtime.\n",
                                    "int functionODE_inline(DATA* data, double stepSize)\n",
                                    "{\n",
                                    "  state mem_state;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "mem_state = get_memory_state();\n",
                                    "begin_inline();\n"
                                }, true));
        txt = Tpl.writeText(txt, a_stateContPartInline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "end_inline();\n",
                                    "restore_memory_state(mem_state);\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "int functionODE_inline(DATA* data, double stepSize)\n",
                                    "{\n",
                                    "  return 0;\n",
                                    "}"
                                }, false));
      then txt;
  end matchcontinue;
end fun_130;

public function functionODE
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_derivativEquations;
  input Tpl.Text a_method;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_method;
protected
  String str_9;
  Boolean ret_8;
  Boolean ret_7;
  Tpl.Text l_stateContPartInline;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls2;
  Tpl.Text l_funcNames;
  Integer ret_2;
  Tpl.Text l_nFuncs;
  Tpl.Text l_funcs;
algorithm
  System.tmpTickReset(0);
  l_funcs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcs := lm_122(l_funcs, a_derivativEquations);
  l_funcs := Tpl.popIter(l_funcs);
  ret_2 := listLength(a_derivativEquations);
  l_nFuncs := Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
  l_funcNames := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcNames := lm_123(l_funcNames, a_derivativEquations);
  l_funcNames := Tpl.popIter(l_funcNames);
  l_varDecls2 := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_stateContPartInline := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_stateContPartInline, l_tmp, l_varDecls2) := lm_125(l_stateContPartInline, a_derivativEquations, l_tmp, l_varDecls2);
  l_stateContPartInline := Tpl.popIter(l_stateContPartInline);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_funcs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("static void (*functionODE_systems["));
  out_txt := Tpl.writeText(out_txt, l_nFuncs);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("])(DATA *, int) = {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_funcNames);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "};\n",
                                       "\n",
                                       "void function_initMemoryState()\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("push_memory_states("));
  ret_7 := Flags.isSet(Flags.OPENMP);
  out_txt := fun_127(out_txt, ret_7);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(");\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "\n",
                                       "int functionODE(DATA *data)\n",
                                       "{\n",
                                       "  int id,th_id;\n",
                                       "  state mem_state; /* We need to have separate memory pools for separate systems... */\n",
                                       "  mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_8 := Flags.isSet(Flags.OPENMP);
  out_txt := fun_129(out_txt, ret_8);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("for (id=0; id<"));
  out_txt := Tpl.writeText(out_txt, l_nFuncs);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "; id++) {\n",
                                       "  th_id = omp_get_thread_num();\n",
                                       "  functionODE_systems[id](data,th_id);\n",
                                       "}\n",
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "#include <simulation_inline_solver.h>\n",
                                       "const char *_omc_force_solver=_OMC_FORCE_SOLVER;\n",
                                       "const int inline_work_states_ndims=_OMC_SOLVER_WORK_STATES_NDIMS;\n"
                                   }, true));
  str_9 := Tpl.textString(a_method);
  out_txt := fun_130(out_txt, str_9, l_stateContPartInline, l_varDecls2);
  out_a_method := a_method;
end functionODE;

protected function lm_132
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_132(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_132(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_132;

public function functionAlgebraic
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_algebraicEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algEquations;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_algEquations := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algEquations, l_tmp, l_varDecls) := lm_132(l_algEquations, a_algebraicEquations, l_tmp, l_varDecls);
  l_algEquations := Tpl.popIter(l_algEquations);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int functionAlgebraics(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_algEquations);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAlgebraic;

protected function lm_134
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_134(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_134(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_134;

public function functionAliasEquation
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_removedEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_removedPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_removedPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_removedPart, l_tmp, l_varDecls) := lm_134(l_removedPart, a_removedEquations, l_tmp, l_varDecls);
  l_removedPart := Tpl.popIter(l_removedPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int functionAliasEquations(DATA *data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_removedPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAliasEquation;

protected function lm_136
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_136(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_136(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_136;

protected function lm_137
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = genreinits(txt, i_when, a_varDecls, x_i0);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_137(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_137(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_137;

public function functionDAE
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.HelpVarInfo> a_helpVarInfo;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_reinit;
  Tpl.Text l_eqs;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_tmp, l_varDecls) := lm_136(l_eqs, a_allEquationsPlusWhen, l_tmp, l_varDecls);
  l_eqs := Tpl.popIter(l_eqs);
  l_reinit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_reinit, l_varDecls) := lm_137(l_reinit, a_whenClauses, l_varDecls);
  l_reinit := Tpl.popIter(l_reinit);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "int functionDAE(DATA *data, int *needToIterate)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "*needToIterate = 0;\n",
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_reinit);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionDAE;

public function functionOnlyZeroCrossing
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_zeroCrossingsCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_zeroCrossingsCode, l_varDecls) := zeroCrossingsTpl2(Tpl.emptyTxt, a_zeroCrossings, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int function_onlyZeroCrossings(DATA *data, double *gout,double *t)\n",
                                   "{\n",
                                   "  state mem_state;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "mem_state = get_memory_state();\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_zeroCrossingsCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionOnlyZeroCrossing;

protected function fun_140
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_var;

    case ( txt,
           (i_var as DAE.CREF_QUAL(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") { DEBUG_INFO2(LOG_EVENTS,\"Discrete Var "));
        txt = crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");  needToIterate=1; }"));
      then txt;

    case ( txt,
           (i_var as DAE.CREF_IDENT(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") { DEBUG_INFO2(LOG_EVENTS,\"Discrete Var "));
        txt = crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");  needToIterate=1; }"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_140;

protected function lm_141
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_140(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_141(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_141(txt, rest);
      then txt;
  end matchcontinue;
end lm_141;

public function functionCheckForDiscreteChanges
  input Tpl.Text txt;
  input list<DAE.ComponentRef> a_discreteModelVars;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_changediscreteVars;
algorithm
  l_changediscreteVars := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_changediscreteVars := lm_141(l_changediscreteVars, a_discreteModelVars);
  l_changediscreteVars := Tpl.popIter(l_changediscreteVars);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "int checkForDiscreteChanges(DATA *data)\n",
                                   "{\n",
                                   "  int needToIterate = 0;\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_changediscreteVars);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return needToIterate;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionCheckForDiscreteChanges;

protected function fun_143
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      Tpl.Text txt_0;

    case ( txt,
           "modelica_real",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%g"));
      then txt;

    case ( txt,
           "modelica_integer",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%ld"));
      then txt;

    case ( txt,
           "modelica_boolean",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%d"));
      then txt;

    case ( txt,
           "modelica_string",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%s"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Do not know what printf argument to give "));
        txt_0 = crefStr(txt_0, a_cr);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 1129, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_143;

public function crefToPrintfArg
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
protected
  String str_1;
  Tpl.Text txt_0;
algorithm
  txt_0 := crefType(Tpl.emptyTxt, a_cr);
  str_1 := Tpl.textString(txt_0);
  out_txt := fun_143(txt, str_1, a_cr);
end crefToPrintfArg;

public function crefType
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Type i_identType;

    case ( txt,
           DAE.CREF_IDENT(identType = i_identType) )
      equation
        txt = expTypeModelica(txt, i_identType);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(componentRef = i_componentRef) )
      equation
        txt = crefType(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("crefType:ERROR"));
      then txt;
  end matchcontinue;
end crefType;

protected function lm_146
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_146(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_146(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_146;

public function functionAssertsforCheck
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_algAndEqAssertsEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algAndEqAssertsPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_algAndEqAssertsPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algAndEqAssertsPart, l_tmp, l_varDecls) := lm_146(l_algAndEqAssertsPart, a_algAndEqAssertsEquations, l_tmp, l_varDecls);
  l_algAndEqAssertsPart := Tpl.popIter(l_algAndEqAssertsPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* function to check assert after a step is done */\n",
                                       "int checkForAsserts(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_algAndEqAssertsPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAssertsforCheck;

public function defvars
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_item;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_item)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name) )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end defvars;

public function functionlinearmodel
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;
      list<SimCode.SimVar> i_vars_inputVars;
      list<SimCode.SimVar> i_vars_stateVars;
      Absyn.Path i_name;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numStateVars;
      Tpl.Text l_vectorY;
      Tpl.Text l_vectorU;
      Tpl.Text l_vectorX;
      Tpl.Text l_matrixD;
      Tpl.Text l_matrixC;
      Tpl.Text l_matrixB;
      Tpl.Text l_matrixA;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numInVars = i_varInfo_numInVars, numOutVars = i_varInfo_numOutVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, inputVars = i_vars_inputVars, outputVars = i_vars_outputVars), name = i_name) )
      equation
        l_matrixA = genMatrix(Tpl.emptyTxt, "A", i_varInfo_numStateVars, i_varInfo_numStateVars);
        l_matrixB = genMatrix(Tpl.emptyTxt, "B", i_varInfo_numStateVars, i_varInfo_numInVars);
        l_matrixC = genMatrix(Tpl.emptyTxt, "C", i_varInfo_numOutVars, i_varInfo_numStateVars);
        l_matrixD = genMatrix(Tpl.emptyTxt, "D", i_varInfo_numOutVars, i_varInfo_numInVars);
        l_vectorX = genVector(Tpl.emptyTxt, "x", i_varInfo_numStateVars, 0);
        l_vectorU = genVector(Tpl.emptyTxt, "u", i_varInfo_numInVars, 1);
        l_vectorY = genVector(Tpl.emptyTxt, "y", i_varInfo_numOutVars, 2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("const char *linear_model_frame =\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"model linear_"));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\n  parameter Integer n = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // states \\n  parameter Integer k = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // top-level inputs \\n  parameter Integer l = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; // top-level outputs \\n\"\n",
                                    "\"  parameter Real x0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {%s};\\n\"\n",
                                    "\"  parameter Real u0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {%s};\\n\"\n"));
        txt = Tpl.writeText(txt, l_matrixA);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixB);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixD);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorX);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorU);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorY);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"\\n  "));
        txt = getVarName(txt, i_vars_stateVars, "x", i_varInfo_numStateVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = getVarName(txt, i_vars_inputVars, "u", i_varInfo_numInVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = getVarName(txt, i_vars_outputVars, "y", i_varInfo_numOutVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\n\"\n",
                                    "\"equation\\n  der(x) = A * x + B * u;\\n  y = C * x + D * u;\\nend linear_"
                                }, false));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\\n\"\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionlinearmodel;

protected function fun_150
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;
  input Tpl.Text in_a_rest;
  input Tpl.Text in_a_arrindex;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_rest, in_a_arrindex, in_a_arrayName)
    local
      Tpl.Text txt;
      Tpl.Text a_rest;
      Tpl.Text a_arrindex;
      String a_arrayName;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name),
           a_rest,
           a_arrindex,
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefM(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, a_arrindex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n  "));
        txt = Tpl.writeText(txt, a_rest);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_150;

public function getVarName
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_simVars;
  input String in_a_arrayName;
  input Integer in_a_arraySize;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simVars, in_a_arrayName, in_a_arraySize)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_arraySize;
      SimCode.SimVar i_var;
      list<SimCode.SimVar> i_restVars;
      Integer ret_3;
      Integer ret_2;
      Tpl.Text l_arrindex;
      Tpl.Text l_rest;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: i_restVars,
           a_arrayName,
           a_arraySize )
      equation
        l_rest = getVarName(Tpl.emptyTxt, i_restVars, a_arrayName, a_arraySize);
        ret_2 = listLength(i_restVars);
        ret_3 = SimCode.decrementInt(a_arraySize, ret_2);
        l_arrindex = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        txt = fun_150(txt, i_var, l_rest, l_arrindex, a_arrayName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end getVarName;

protected function fun_152
  input Tpl.Text in_txt;
  input Integer in_a_col;
  input Integer in_a_row;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_col, in_a_row, in_a_name)
    local
      Tpl.Text txt;
      Integer a_row;
      String a_name;
      Integer i_col;

    case ( txt,
           (i_col as 0),
           a_row,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = zeros("));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");%s\\n\""));
      then txt;

    case ( txt,
           i_col,
           a_row,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = [%s];\\n\""));
      then txt;
  end matchcontinue;
end fun_152;

protected function fun_153
  input Tpl.Text in_txt;
  input Integer in_a_row;
  input String in_a_name;
  input Integer in_a_col;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_row, in_a_name, in_a_col)
    local
      Tpl.Text txt;
      String a_name;
      Integer a_col;
      Integer i_row;

    case ( txt,
           (i_row as 0),
           a_name,
           a_col )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = zeros("));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");%s\\n\""));
      then txt;

    case ( txt,
           i_row,
           a_name,
           a_col )
      equation
        txt = fun_152(txt, a_col, i_row, a_name);
      then txt;
  end matchcontinue;
end fun_153;

public function genMatrix
  input Tpl.Text txt;
  input String a_name;
  input Integer a_row;
  input Integer a_col;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_153(txt, a_row, a_name, a_col);
end genMatrix;

protected function fun_155
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("](start="));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0);\\n\""));
      then txt;
  end matchcontinue;
end fun_155;

protected function fun_156
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  input Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  input Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("](start= "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0);\\n\""));
      then txt;
  end matchcontinue;
end fun_156;

protected function fun_157
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  output Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  output Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;
  end matchcontinue;
end fun_157;

protected function fun_158
  input Tpl.Text in_txt;
  input Integer in_a_flag;
  input String in_a_name;
  input Integer in_a_numIn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_flag, in_a_name, in_a_numIn)
    local
      Tpl.Text txt;
      String a_name;
      Integer a_numIn;

    case ( txt,
           0,
           a_name,
           a_numIn )
      equation
        txt = fun_155(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           1,
           a_name,
           a_numIn )
      equation
        txt = fun_156(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           2,
           a_name,
           a_numIn )
      equation
        txt = fun_157(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_158;

public function genVector
  input Tpl.Text txt;
  input String a_name;
  input Integer a_numIn;
  input Integer a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_158(txt, a_flag, a_name, a_numIn);
end genVector;

protected function lm_160
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_160(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_160(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end lm_160;

public function functionJac
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_jacEquations;
  input list<SimCode.SimVar> a_tmpVars;
  input String a_columnLength;
  input String a_matrixName;
  input Integer a_indexJacobian;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqns__;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqns__ := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqns__, l_tmp, l_varDecls) := lm_160(l_eqns__, a_jacEquations, l_tmp, l_varDecls);
  l_eqns__ := Tpl.popIter(l_eqns__);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int functionJac"));
  out_txt := Tpl.writeStr(out_txt, a_matrixName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_column(DATA* data)\n",
                                       "{\n",
                                       "  state mem_state;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int index = "));
  out_txt := Tpl.writeStr(out_txt, intString(a_indexJacobian));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(";\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("mem_state = get_memory_state();\n"));
  out_txt := Tpl.writeText(out_txt, l_eqns__);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "int i;\n",
                                       "for(i=0;i<"
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_columnLength);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";i++){\n",
                                       "    if (DEBUG_FLAG(LOG_DEBUG)){\n",
                                       "      printf(\"col: col[%d] = %f \\n\",i,data->simulationInfo.analyticJacobians[index].resultVars[i]);\n",
                                       "    }\n",
                                       "}\n",
                                       "\n",
                                       "restore_memory_state(mem_state);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionJac;

protected function lm_162
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input Integer in_a_indexJacobian;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_indexJacobian, in_a_matrixname)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      Integer a_indexJacobian;
      String a_matrixname;
      String i_indxColumn;
      list<SimCode.SimVar> i_vars;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (i_eqs, i_vars, i_indxColumn) :: rest,
           a_indexJacobian,
           a_matrixname )
      equation
        txt = functionJac(txt, i_eqs, i_vars, i_indxColumn, a_matrixname, a_indexJacobian);
        txt = Tpl.nextIter(txt);
        txt = lm_162(txt, rest, a_indexJacobian, a_matrixname);
      then txt;

    case ( txt,
           _ :: rest,
           a_indexJacobian,
           a_matrixname )
      equation
        txt = lm_162(txt, rest, a_indexJacobian, a_matrixname);
      then txt;
  end matchcontinue;
end lm_162;

protected function lm_163
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_indxColumn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_indxColumn) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_indxColumn);
        txt = Tpl.nextIter(txt);
        txt = lm_163(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_163(txt, rest);
      then txt;
  end matchcontinue;
end lm_163;

protected function fun_164
  input Tpl.Text in_txt;
  input list<Integer> in_a_colorList;
  input Integer in_a_maxColor;
  input list<SimCode.SimVar> in_a_seedVars;
  input Integer in_a_indexJacobian;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_colorList, in_a_maxColor, in_a_seedVars, in_a_indexJacobian, in_a_jacobianColumn, in_a_matrixname)
    local
      Tpl.Text txt;
      Integer a_maxColor;
      list<SimCode.SimVar> a_seedVars;
      Integer a_indexJacobian;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      String a_matrixname;
      Integer ret_3;
      Tpl.Text l_index__;
      Tpl.Text l_indexColumn;
      Tpl.Text l_jacMats;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           a_matrixname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data, double* jac){\n",
                                    "   return 1;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_maxColor,
           a_seedVars,
           a_indexJacobian,
           a_jacobianColumn,
           a_matrixname )
      equation
        l_jacMats = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jacMats = lm_162(l_jacMats, a_jacobianColumn, a_indexJacobian, a_matrixname);
        l_jacMats = Tpl.popIter(l_jacMats);
        l_indexColumn = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexColumn = lm_163(l_indexColumn, a_jacobianColumn);
        l_indexColumn = Tpl.popIter(l_indexColumn);
        ret_3 = listLength(a_seedVars);
        l_index__ = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_jacMats);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data, double* jac){\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int index = "));
        txt = Tpl.writeStr(txt, intString(a_indexJacobian));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "int i,j,l,k,ii;\n",
                                    "for(i=0; i < "
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_maxColor));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; i++)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for (ii=0; ii < "));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; ii++)\n",
                                    "  if (data->simulationInfo.analyticJacobians[index].sparsePattern.colorCols[ii]-1 == i) data->simulationInfo.analyticJacobians[index].seedVars[ii] = 1;\n",
                                    "\n",
                                    "if (DEBUG_FLAG(LOG_DEBUG))\n",
                                    "{\n",
                                    "  printf(\"Caluculate one col:\\n\");\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(l=0;  l < "));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";l++)\n",
                                    "  DEBUG_INFO2(LOG_DEBUG,\"seed: data->simulationInfo.analyticJacobians[index].seedVars[%d]= %f\",l,data->simulationInfo.analyticJacobians[index].seedVars[l]);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "functionJac"
                                }, false));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_column(data);\n",
                                    "\n",
                                    "for(j = 0; j < "
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; j++)\n",
                                    "{\n",
                                    "  if ( data->simulationInfo.analyticJacobians[index].seedVars[j] == 1)\n",
                                    "  {\n",
                                    "    if (j==0)\n",
                                    "      ii = 0;\n",
                                    "    else\n",
                                    "      ii = data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex[j-1];\n",
                                    "    while(ii < data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex[j])\n",
                                    "    {\n",
                                    "      l  =  data->simulationInfo.analyticJacobians[index].sparsePattern.index[ii]-1;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("k  = l + j*"));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "jac[k] = data->simulationInfo.analyticJacobians[index].resultVars[l];\n",
                                    "DEBUG_INFO7(LOG_DEBUG,\"write %d. in jac[%d]-[%d,%d]=%f from col[%d]=%f\",ii,k,l,j,jac[k],l,data->simulationInfo.analyticJacobians[index].resultVars[l]);\n",
                                    "ii++;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    };\n",
                                    "  }\n",
                                    "}\n",
                                    "\n",
                                    "if (DEBUG_FLAG(LOG_DEBUG))\n",
                                    "{\n",
                                    "  INFO(\"Print jac:\");\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(l=0;  l < "));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";l++)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(k=0;  k < "));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";k++)\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"% .5e \",jac[l+k*"));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("printf(\"\\n\");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "for (ii=0; ii < "
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; ii++)\n",
                                    "  if (data->simulationInfo.analyticJacobians[index].sparsePattern.colorCols[ii]-1 == i) data->simulationInfo.analyticJacobians[index].seedVars[ii] = 0;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_164;

protected function fun_165
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input Integer in_a_indexJacobian;
  input list<SimCode.SimVar> in_a_seedVars;
  input String in_a_matrixname;
  input list<Integer> in_a_colorList;
  input Integer in_a_maxColor;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_jacobianColumn, in_a_indexJacobian, in_a_seedVars, in_a_matrixname, in_a_colorList, in_a_maxColor)
    local
      Tpl.Text txt;
      Integer a_indexJacobian;
      list<SimCode.SimVar> a_seedVars;
      String a_matrixname;
      list<Integer> a_colorList;
      Integer a_maxColor;
      list<SimCode.JacobianColumn> i_jacobianColumn;

    case ( txt,
           {},
           _,
           _,
           a_matrixname,
           _,
           _ )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int functionJac"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data, double* jac){\n",
                                    "   return 0;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_jacobianColumn,
           a_indexJacobian,
           a_seedVars,
           a_matrixname,
           a_colorList,
           a_maxColor )
      equation
        txt = fun_164(txt, a_colorList, a_maxColor, a_seedVars, a_indexJacobian, i_jacobianColumn, a_matrixname);
      then txt;
  end matchcontinue;
end fun_165;

public function generateMatrix
  input Tpl.Text txt;
  input Integer a_indexJacobian;
  input list<SimCode.JacobianColumn> a_jacobianColumn;
  input list<SimCode.SimVar> a_seedVars;
  input String a_matrixname;
  input list<list<Integer>> a_sparsepattern;
  input list<Integer> a_colorList;
  input Integer a_maxColor;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_165(txt, a_jacobianColumn, a_indexJacobian, a_seedVars, a_matrixname, a_colorList, a_maxColor);
end generateMatrix;

protected function lm_167
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      Integer x_index0;
      list<Integer> i_colorList;
      list<list<Integer>> i_sparsepattern;
      String i_name;
      list<SimCode.SimVar> i_vars;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_mat, i_vars, i_name, i_sparsepattern, i_colorList, _) :: rest )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = initialAnalyticJacobians(txt, x_index0, i_mat, i_vars, i_name, i_sparsepattern, i_colorList);
        txt = Tpl.nextIter(txt);
        txt = lm_167(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_167(txt, rest);
      then txt;
  end matchcontinue;
end lm_167;

protected function lm_168
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      Integer x_index0;
      Integer i_maxColor;
      list<Integer> i_colorList;
      list<list<Integer>> i_sparsepattern;
      String i_name;
      list<SimCode.SimVar> i_vars;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_mat, i_vars, i_name, i_sparsepattern, i_colorList, i_maxColor) :: rest )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = generateMatrix(txt, x_index0, i_mat, i_vars, i_name, i_sparsepattern, i_colorList, i_maxColor);
        txt = Tpl.nextIter(txt);
        txt = lm_168(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_168(txt, rest);
      then txt;
  end matchcontinue;
end lm_168;

public function functionAnalyticJacobians
  input Tpl.Text txt;
  input list<SimCode.JacobianMatrix> a_JacobianMatrixes;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacMats;
  Tpl.Text l_initialjacMats;
algorithm
  l_initialjacMats := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                      "\n",
                                                                                      "\n"
                                                                                  }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_initialjacMats := lm_167(l_initialjacMats, a_JacobianMatrixes);
  l_initialjacMats := Tpl.popIter(l_initialjacMats);
  l_jacMats := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                               "\n",
                                                                               "\n"
                                                                           }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_jacMats := lm_168(l_jacMats, a_JacobianMatrixes);
  l_jacMats := Tpl.popIter(l_jacMats);
  out_txt := Tpl.writeText(txt, l_initialjacMats);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_jacMats);
end functionAnalyticJacobians;

protected function fun_170
  input Tpl.Text in_txt;
  input Integer in_a_index0;
  input list<Integer> in_a_indexes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_index0, in_a_indexes)
    local
      Tpl.Text txt;
      list<Integer> a_indexes;
      Integer i_index0;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           (i_index0 as 0),
           a_indexes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex["));
        txt = Tpl.writeStr(txt, intString(i_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        ret_0 = listLength(a_indexes);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           i_index0,
           a_indexes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex["));
        txt = Tpl.writeStr(txt, intString(i_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex["));
        ret_1 = intSub(i_index0, 1);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] + "));
        ret_2 = listLength(a_indexes);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_170;

protected function lm_171
  input Tpl.Text in_txt;
  input list<list<Integer>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Integer>> rest;
      Integer x_index0;
      list<Integer> i_indexes;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_indexes :: rest )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = fun_170(txt, x_index0, i_indexes);
        txt = Tpl.nextIter(txt);
        txt = lm_171(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_171(txt, rest);
      then txt;
  end matchcontinue;
end lm_171;

protected function lm_172
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer x_index0;
      Integer i_indexes;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_indexes :: rest )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.analyticJacobians[index].sparsePattern.index["));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeStr(txt, intString(i_indexes));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.nextIter(txt);
        txt = lm_172(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_172(txt, rest);
      then txt;
  end matchcontinue;
end lm_172;

protected function lm_173
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer x_index0;
      Integer i_indexes;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_indexes :: rest )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.analyticJacobians[index].sparsePattern.colorCols["));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeStr(txt, intString(i_indexes));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.nextIter(txt);
        txt = lm_173(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_173(txt, rest);
      then txt;
  end matchcontinue;
end lm_173;

protected function lm_174
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_indxColumn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_indxColumn) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_indxColumn);
        txt = Tpl.nextIter(txt);
        txt = lm_174(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_174(txt, rest);
      then txt;
  end matchcontinue;
end lm_174;

protected function lm_175
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      list<SimCode.SimVar> i_vars;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, i_vars, _) :: rest )
      equation
        ret_0 = listLength(i_vars);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.nextIter(txt);
        txt = lm_175(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_175(txt, rest);
      then txt;
  end matchcontinue;
end lm_175;

protected function fun_176
  input Tpl.Text in_txt;
  input list<Integer> in_a_colorList;
  input Integer in_a_indexJacobian;
  input list<SimCode.SimVar> in_a_seedVars;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input list<list<Integer>> in_a_sparsepattern;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_colorList, in_a_indexJacobian, in_a_seedVars, in_a_jacobianColumn, in_a_sparsepattern, in_a_matrixname)
    local
      Tpl.Text txt;
      Integer a_indexJacobian;
      list<SimCode.SimVar> a_seedVars;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      list<list<Integer>> a_sparsepattern;
      String a_matrixname;
      list<Integer> i_colorList;
      Integer ret_11;
      Tpl.Text l_index__;
      Tpl.Text l_tmpvarsSize;
      Tpl.Text l_indexColumn;
      Integer ret_7;
      Tpl.Text l_sp__size__index_1;
      Tpl.Text l_colorArray;
      list<Integer> ret_4;
      Tpl.Text l_indexElems;
      Tpl.Text l_leadindex;
      Integer ret_1;
      Tpl.Text l_sp__size__index;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           a_matrixname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int initialAnalyticJacobian"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data){\n",
                                    "   return 1;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_colorList,
           a_indexJacobian,
           a_seedVars,
           a_jacobianColumn,
           a_sparsepattern,
           a_matrixname )
      equation
        ret_1 = List.lengthListElements(a_sparsepattern);
        l_sp__size__index = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_leadindex = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_leadindex = lm_171(l_leadindex, a_sparsepattern);
        l_leadindex = Tpl.popIter(l_leadindex);
        ret_4 = List.flatten(a_sparsepattern);
        l_indexElems = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexElems = lm_172(l_indexElems, ret_4);
        l_indexElems = Tpl.popIter(l_indexElems);
        l_colorArray = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_colorArray = lm_173(l_colorArray, i_colorList);
        l_colorArray = Tpl.popIter(l_colorArray);
        ret_7 = List.lengthListElements(a_sparsepattern);
        l_sp__size__index_1 = Tpl.writeStr(Tpl.emptyTxt, intString(ret_7));
        l_indexColumn = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexColumn = lm_174(l_indexColumn, a_jacobianColumn);
        l_indexColumn = Tpl.popIter(l_indexColumn);
        l_tmpvarsSize = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_tmpvarsSize = lm_175(l_tmpvarsSize, a_jacobianColumn);
        l_tmpvarsSize = Tpl.popIter(l_tmpvarsSize);
        ret_11 = listLength(a_seedVars);
        l_index__ = Tpl.writeStr(Tpl.emptyTxt, intString(ret_11));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int initialAnalyticJacobian"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(DATA* data){\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int index = "));
        txt = Tpl.writeStr(txt, intString(a_indexJacobian));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].jacobianName = \'"
                                }, false));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\';\n",
                                    "data->simulationInfo.analyticJacobians[index].sizeCols = "
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].sizeRows = "
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].seedVars = (modelica_real*) calloc("
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",sizeof(modelica_real));\n",
                                    "data->simulationInfo.analyticJacobians[index].resultVars = (modelica_real*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(modelica_real));\n",
                                    "data->simulationInfo.analyticJacobians[index].tmpVars = (modelica_real*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_tmpvarsSize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(modelica_real));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex = (int*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(int));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.index = (int*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_sp__size__index_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(int));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.colorCols = (int*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(int));\n",
                                    "data->simulationInfo.analyticJacobians[index].jacobian = NULL;\n",
                                    "\n",
                                    "/* write leading index */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_leadindex);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* write index */\n"));
        txt = Tpl.writeText(txt, l_indexElems);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* write color array */\n"));
        txt = Tpl.writeText(txt, l_colorArray);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end matchcontinue;
end fun_176;

protected function fun_177
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_seedVars;
  input Integer in_a_indexJacobian;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input String in_a_matrixname;
  input list<list<Integer>> in_a_sparsepattern;
  input list<Integer> in_a_colorList;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_seedVars, in_a_indexJacobian, in_a_jacobianColumn, in_a_matrixname, in_a_sparsepattern, in_a_colorList)
    local
      Tpl.Text txt;
      Integer a_indexJacobian;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      String a_matrixname;
      list<list<Integer>> a_sparsepattern;
      list<Integer> a_colorList;
      list<SimCode.SimVar> i_seedVars;

    case ( txt,
           {},
           _,
           _,
           a_matrixname,
           _,
           _ )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int initialAnalyticJacobian"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data){\n",
                                    "   return 1;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_seedVars,
           a_indexJacobian,
           a_jacobianColumn,
           a_matrixname,
           a_sparsepattern,
           a_colorList )
      equation
        txt = fun_176(txt, a_colorList, a_indexJacobian, i_seedVars, a_jacobianColumn, a_sparsepattern, a_matrixname);
      then txt;
  end matchcontinue;
end fun_177;

public function initialAnalyticJacobians
  input Tpl.Text txt;
  input Integer a_indexJacobian;
  input list<SimCode.JacobianColumn> a_jacobianColumn;
  input list<SimCode.SimVar> a_seedVars;
  input String a_matrixname;
  input list<list<Integer>> a_sparsepattern;
  input list<Integer> a_colorList;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_177(txt, a_seedVars, a_indexJacobian, a_jacobianColumn, a_matrixname, a_sparsepattern, a_colorList);
end initialAnalyticJacobians;

protected function lm_179
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
        txt = lm_179(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_179(txt, rest);
      then txt;
  end matchcontinue;
end lm_179;

public function intArr
  input Tpl.Text txt;
  input list<Integer> a_values;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_179(out_txt, a_values);
  out_txt := Tpl.popIter(out_txt);
end intArr;

protected function lm_181
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = zeroCrossingTpl2(txt, x_i0, i_relation__, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_181(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_181(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_181;

public function zeroCrossingsTpl2
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_181(out_txt, a_zeroCrossings, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end zeroCrossingsTpl2;

protected function fun_183
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_relation, in_a_index1, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_index1;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp2;
      DAE.Operator i_operator;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_op;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.RELATION(exp1 = i_exp1, operator = i_operator, exp2 = i_exp2),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextOther, l_preExp, a_varDecls);
        l_op = zeroCrossingOpFunc(Tpl.emptyTxt, i_operator);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_op);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {_, _}),
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_index1,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// UNKNOWN ZERO CROSSING for "));
        txt = Tpl.writeStr(txt, intString(a_index1));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_183;

public function zeroCrossingTpl2
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_183(txt, a_relation, a_index1, a_varDecls);
end zeroCrossingTpl2;

protected function lm_185
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls) = zeroCrossingTpl(txt, x_i0, i_relation__, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_185(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_185(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_185;

public function zeroCrossingsTpl
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_185(out_txt, a_zeroCrossings, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end zeroCrossingsTpl;

protected function fun_187
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_relation, in_a_index1, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_index1;
      Tpl.Text a_varDecls;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      DAE.Exp i_exp2;
      DAE.Operator i_operator;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_op;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.RELATION(exp1 = i_exp1, operator = i_operator, exp2 = i_exp2),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextOther, l_preExp, a_varDecls);
        l_op = zeroCrossingOpFunc(Tpl.emptyTxt, i_operator);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_op);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval}),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, l_preExp, a_varDecls);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",Sample(*t,"));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZERO CROSSING ERROR"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_187;

public function zeroCrossingTpl
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_187(txt, a_relation, a_index1, a_varDecls);
end zeroCrossingTpl;

protected function lm_189
  input Tpl.Text in_txt;
  input list<SimCode.SampleCondition> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SampleCondition> rest;
      Tpl.Text a_varDecls;
      DAE.Exp i_relation__;
      Integer i_index;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_relation__, i_index) :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = timeEventTpl(txt, i_index, i_relation__, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_189(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_189(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_189;

public function timeEventsTpl
  input Tpl.Text txt;
  input list<SimCode.SampleCondition> a_sampleConditions;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varDecls) := lm_189(out_txt, a_sampleConditions, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end timeEventsTpl;

protected function fun_191
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_relation, in_a_index1, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_index1;
      Tpl.Text a_varDecls;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      Tpl.Text l_e2;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.RELATION(exp1 = _),
           a_index1,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" Not a time event */"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval, _}),
           a_index1,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, l_preExp, a_varDecls);
        (l_e2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.rawSampleExps[i].start = "));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.rawSampleExps[i].interval = "
                                }, false));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.rawSampleExps[i++].zc_index = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_index1,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* UNKNOWN ZERO CROSSING for "));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_191;

public function timeEventTpl
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_191(txt, a_relation, a_index1, a_varDecls);
end timeEventTpl;

public function zeroCrossingOpFunc
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_op)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.LESS(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Less"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Greater"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LessEq"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("GreaterEq"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end zeroCrossingOpFunc;

protected function fun_194
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varD;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varD;
algorithm
  (out_txt, out_a_varD) :=
  matchcontinue(in_txt, in_a_eq, in_a_varD, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varD;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationSimpleAssign(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationArrayCallAssign(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationAlgorithm(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationLinear(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationNonlinear(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           (i_e as SimCode.SES_WHEN(left = _)),
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationWhen(txt, i_e, a_context, a_varD);
      then (txt, a_varD);

    case ( txt,
           _,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_varD);
  end matchcontinue;
end fun_194;

protected function fun_195
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_eqs;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqs, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_eqs, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_eqs;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_x;
      Tpl.Text l_varD;
      Tpl.Text l_tmp;
      Integer ret_1;
      Tpl.Text l_ix;

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_eqs,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls, a_eqs) = equationMixed(txt, i_e, a_context, a_varDecls, a_eqs);
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           a_eqs,
           a_varDecls,
           _ )
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           i_eq,
           a_eqs,
           a_varDecls,
           a_context )
      equation
        ret_1 = System.tmpTickIndex(10);
        l_ix = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_tmp = Tpl.emptyTxt;
        l_varD = Tpl.emptyTxt;
        (l_x, l_varD) = fun_194(Tpl.emptyTxt, i_eq, l_varD, a_context);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING_LIST({
                                        "\n",
                                        "void eqFunction_"
                                    }, false));
        a_eqs = Tpl.writeText(a_eqs, l_ix);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_LINE("(DATA *data) {\n"));
        a_eqs = Tpl.pushBlock(a_eqs, Tpl.BT_INDENT(2));
        a_eqs = Tpl.writeText(a_eqs, l_varD);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.writeText(a_eqs, l_x);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.popBlock(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING_LIST({
                                        "}\n",
                                        "\n"
                                    }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("eqFunction_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(data);"));
      then (txt, a_eqs, a_varDecls);
  end matchcontinue;
end fun_195;

protected function fun_196
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) :=
  matchcontinue(in_txt, in_a_context, in_a_eq, in_a_varDecls, in_a_eqs)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqs;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.INLINE_CONTEXT()),
           a_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_varDecls) = old_equation_(txt, a_eq, i_context, a_varDecls);
      then (txt, a_varDecls, a_eqs);

    case ( txt,
           i_context,
           a_eq,
           a_varDecls,
           a_eqs )
      equation
        (txt, a_eqs, a_varDecls) = fun_195(txt, a_eq, a_eqs, a_varDecls, i_context);
      then (txt, a_varDecls, a_eqs);
  end matchcontinue;
end fun_196;

public function equation_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_eqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) := fun_196(txt, a_context, a_eq, a_varDecls, a_eqs);
end equation_;

public function old_equation_
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationArrayCallAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationAlgorithm(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationLinear(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationNonlinear(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(left = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationWhen(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_varDecls);
  end matchcontinue;
end old_equation_;

protected function fun_199
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_tmp, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_e;
      Integer ret_6;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_1 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationArrayCallAssign(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_2 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationAlgorithm(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_3 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationLinear(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_4 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls, a_tmp) = equationMixed(txt, i_e, a_context, a_varDecls, a_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(index = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_5 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationNonlinear(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_e as SimCode.SES_WHEN(left = _)),
           a_tmp,
           a_varDecls,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"Line "));
        ret_6 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_6));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\\n\");\n"));
        (txt, a_varDecls) = equationWhen(txt, i_e, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"OK\\n\");"));
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _,
           a_tmp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION"));
      then (txt, a_tmp, a_varDecls);
  end matchcontinue;
end fun_199;

public function myequation_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
algorithm
  l_tmp := Tpl.emptyTxt;
  (out_txt, l_tmp, out_a_varDecls) := fun_199(txt, a_eq, l_tmp, a_varDecls, a_context);
end myequation_;

protected function fun_201
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_c;
  input String in_a_arr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_c, in_a_arr)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef i_c;

    case ( txt,
           (i_c as DAE.CREF_QUAL(ident = "$DER")),
           a_arr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "inline_integrate_array(size_of_dimension_real_array("
                                }, false));
        txt = Tpl.writeStr(txt, a_arr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",1),"));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_201;

public function inlineArray
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input String in_a_arr;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_arr, in_a_c)
    local
      Tpl.Text txt;
      String a_arr;
      DAE.ComponentRef a_c;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_arr,
           a_c )
      equation
        txt = fun_201(txt, a_c, a_arr);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineArray;

protected function fun_203
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           SimCode.SIMVAR(name = (i_cr as DAE.CREF_QUAL(ident = "$DER"))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inline_integrate("));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_203;

protected function lm_204
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_203(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_204(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_204(txt, rest);
      then txt;
  end matchcontinue;
end lm_204;

protected function fun_205
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_simvars;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_simvars )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_204(txt, i_simvars);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_205;

public function inlineVars
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input list<SimCode.SimVar> in_a_simvars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_simvars)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> a_simvars;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_simvars )
      equation
        txt = fun_205(txt, a_simvars);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineVars;

protected function fun_207
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(ident = "$DER")) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("inline_integrate("));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_207;

protected function lm_208
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = fun_207(txt, i_cr);
        txt = Tpl.nextIter(txt);
        txt = lm_208(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_208(txt, rest);
      then txt;
  end matchcontinue;
end lm_208;

protected function fun_209
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_a_crefs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_crefs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> i_crefs;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_crefs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_208(txt, i_crefs);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_209;

public function inlineCrefs
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input list<DAE.ComponentRef> in_a_crefs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_crefs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_crefs;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_crefs )
      equation
        txt = fun_209(txt, a_crefs);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineCrefs;

protected function fun_211
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(ident = "$DER")) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "inline_integrate("
                                }, false));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_211;

public function inlineCref
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.INLINE_CONTEXT(),
           a_cr )
      equation
        txt = fun_211(txt, a_cr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end inlineCref;

public function equationSimpleAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cref;
      SimCode.SimEqSystem i_eq;
      DAE.Exp i_exp;
      Absyn.Info ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref)),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        ret_2 = SimCode.eqInfo(i_eq);
        txt = modelicaLine(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = inlineCref(txt, a_context, i_cref);
        txt = Tpl.softNewLine(txt);
        txt = endModelicaLine(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end equationSimpleAssign;

protected function fun_214
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_eqn_exp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_eqn_componentRef;
  input Tpl.Text in_a_expPart;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_eqn_exp, in_a_context, in_a_eqn_componentRef, in_a_expPart, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_eqn_exp;
      SimCode.Context a_context;
      DAE.ComponentRef a_eqn_componentRef;
      Tpl.Text a_expPart;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text txt_1;
      String ret_1;
      Tpl.Text l_tvar;

    case ( txt,
           "boolean",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "boolean_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_boolean_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(l_tvar), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           "integer",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "integer_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_integer_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(l_tvar), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           "real",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_real_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(a_expPart), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           "string",
           _,
           a_context,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_string_array_data_mem(&"));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = inlineArray(txt, a_context, Tpl.textString(a_expPart), a_eqn_componentRef);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_eqn_exp,
           _,
           _,
           _,
           _,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("No runtime support for this sort of array call: "));
        ret_1 = ExpressionDump.printExpStr(a_eqn_exp);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 1821, 14), Tpl.textString(txt_1));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_214;

protected function fun_215
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_eqn_componentRef;
      DAE.Exp i_eqn_exp;
      DAE.Exp i_exp;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(exp = (i_eqn_exp as i_exp), componentRef = i_eqn_componentRef),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt_2 = expTypeFromExpShort(Tpl.emptyTxt, i_eqn_exp);
        str_3 = Tpl.textString(txt_2);
        (txt, a_varDecls) = fun_214(txt, str_3, i_eqn_exp, a_context, i_eqn_componentRef, l_expPart, l_preExp, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_215;

public function equationArrayCallAssign
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Absyn.Info ret_0;
algorithm
  ret_0 := SimCode.eqInfo(a_eq);
  out_txt := modelicaLine(txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  (out_txt, out_a_varDecls) := fun_215(out_txt, a_eq, a_context, a_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := endModelicaLine(out_txt);
end equationArrayCallAssign;

protected function lm_217
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_217(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_217(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_217;

public function equationAlgorithm
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statements;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = i_statements),
           a_context,
           a_varDecls )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_217(txt, i_statements, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end equationAlgorithm;

protected function fun_219
  input Tpl.Text in_txt;
  input Boolean in_a_partOfMixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_partOfMixed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_mixed"));
      then txt;
  end matchcontinue;
end fun_219;

protected function fun_220
  input Tpl.Text in_txt;
  input Boolean in_a_partOfMixed;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_partOfMixed, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_220;

protected function lm_221
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_size;
  input Tpl.Text in_a_aname;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_size, in_a_aname, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      Tpl.Text a_size;
      Tpl.Text a_aname;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_size,
           a_aname,
           a_varDecls,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("set_matrix_elt("));
        txt = Tpl.writeText(txt, a_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_221(txt, rest, a_size, a_aname, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_size,
           a_aname,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_221(txt, rest, a_size, a_aname, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_221;

protected function lm_222
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_bname;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_bname, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_bname;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_exp :: rest,
           a_bname,
           a_varDecls,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("set_vector_elt("));
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_222(txt, rest, a_bname, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_bname,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_222(txt, rest, a_bname, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_222;

protected function lm_223
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_bname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_bname)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_bname;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_bname )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_vector_elt("));
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_223(txt, rest, a_bname);
      then txt;

    case ( txt,
           _ :: rest,
           a_bname )
      equation
        txt = lm_223(txt, rest, a_bname);
      then txt;
  end matchcontinue;
end lm_223;

protected function fun_224
  input Tpl.Text in_txt;
  input Boolean in_a_partOfMixed;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_partOfMixed, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_224;

public function equationLinear
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      Integer i_index;
      Boolean i_partOfMixed;
      list<SimCode.SimVar> i_vars;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      Tpl.Text l_mixedPostfix;
      Tpl.Text l_bname;
      Tpl.Text l_aname;
      Integer ret_3;
      Tpl.Text l_size;
      Integer ret_1;
      Tpl.Text l_uid;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, partOfMixed = i_partOfMixed, index = i_index, simJac = i_simJac, beqs = i_beqs),
           a_context,
           a_varDecls )
      equation
        ret_1 = System.tmpTick();
        l_uid = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        ret_3 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_aname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("A"));
        l_aname = Tpl.writeText(l_aname, l_uid);
        l_bname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("b"));
        l_bname = Tpl.writeText(l_bname, l_uid);
        l_mixedPostfix = fun_219(Tpl.emptyTxt, i_partOfMixed);
        txt = fun_220(txt, i_partOfMixed, i_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* Linear equation system */\n",
                                    "double "
                                }, false));
        txt = Tpl.writeText(txt, l_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_7 = listLength(i_vars);
        ret_8 = listLength(i_vars);
        ret_9 = intMul(ret_7, ret_8);
        txt = Tpl.writeStr(txt, intString(ret_9));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {0};\n",
                                    "double "
                                }, false));
        txt = Tpl.writeText(txt, l_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {0};\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_221(txt, i_simJac, l_size, l_aname, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_222(txt, i_beqs, l_bname, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("solve_linear_equation_system"));
        txt = Tpl.writeText(txt, l_mixedPostfix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_uid);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_223(txt, i_vars, l_bname);
        txt = Tpl.popIter(txt);
        txt = inlineVars(txt, a_context, i_vars);
        txt = Tpl.softNewLine(txt);
        txt = fun_224(txt, i_partOfMixed, i_index);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end equationLinear;

protected function lm_226
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preDisc;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preDisc;
algorithm
  (out_txt, out_a_varDecls, out_a_preDisc) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preDisc, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preDisc;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           a_varDecls,
           a_preDisc,
           _ )
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref) :: rest,
           a_varDecls,
           a_preDisc,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_expPart, a_preDisc, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preDisc, a_varDecls);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "discrete_loc2["
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preDisc) = lm_226(txt, rest, a_varDecls, a_preDisc, a_context);
      then (txt, a_varDecls, a_preDisc);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preDisc,
           a_context )
      equation
        (txt, a_varDecls, a_preDisc) = lm_226(txt, rest, a_varDecls, a_preDisc, a_context);
      then (txt, a_varDecls, a_preDisc);
  end matchcontinue;
end lm_226;

protected function lm_227
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
        txt = lm_227(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_227(txt, rest);
      then txt;
  end matchcontinue;
end lm_227;

protected function lm_228
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
        txt = lm_228(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_228(txt, rest);
      then txt;
  end matchcontinue;
end lm_228;

protected function lm_229
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete_loc["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_229(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_229(txt, rest);
      then txt;
  end matchcontinue;
end lm_229;

protected function lm_230
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_boolean*)&"));
        txt = cref(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_230(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_230(txt, rest);
      then txt;
  end matchcontinue;
end lm_230;

public function equationMixed
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_tmp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_tmp;
algorithm
  (out_txt, out_a_varDecls, out_a_tmp) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_tmp)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_tmp;
      list<Integer> i_value__dims;
      Integer i_index;
      list<SimCode.SimEqSystem> i_discEqs;
      list<Integer> i_values;
      list<SimCode.SimVar> i_discVars;
      SimCode.SimEqSystem i_cont;
      Tpl.Text l_discLoc2;
      Tpl.Text l_preDisc;
      Integer ret_4;
      Tpl.Text l_valuesLenStr;
      Integer ret_2;
      Tpl.Text l_numDiscVarsStr;
      Tpl.Text l_contEqs;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discVars = i_discVars, values = i_values, discEqs = i_discEqs, index = i_index, value_dims = i_value__dims),
           a_context,
           a_varDecls,
           a_tmp )
      equation
        (l_contEqs, a_varDecls, a_tmp) = equation_(Tpl.emptyTxt, i_cont, a_context, a_varDecls, a_tmp);
        ret_2 = listLength(i_discVars);
        l_numDiscVarsStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        ret_4 = listLength(i_values);
        l_valuesLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        l_preDisc = Tpl.emptyTxt;
        l_discLoc2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_discLoc2, a_varDecls, l_preDisc) = lm_226(l_discLoc2, i_discEqs, a_varDecls, l_preDisc, a_context);
        l_discLoc2 = Tpl.popIter(l_discLoc2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#endif\n",
                                    "mixed_equation_system("
                                }, false));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "modelica_boolean values["
                                }, false));
        txt = Tpl.writeText(txt, l_valuesLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_227(txt, i_values);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "int value_dims["
                                }, false));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_228(txt, i_value__dims);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_229(txt, i_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_contEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_preDisc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_discLoc2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean *loc_ptrs["));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_230(txt, i_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "check_discrete_values("
                                }, false));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_valuesLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "mixed_equation_system_end("
                                }, false));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_tmp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_tmp )
      then (txt, a_varDecls, a_tmp);
  end matchcontinue;
end equationMixed;

protected function lm_232
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nls_x["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = extraPolate("));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", _"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1) /*old*/, _"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(2) /*old2*/);\n",
                                    "nls_xold["
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = _"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1) /*old*/;"));
        txt = Tpl.nextIter(txt);
        txt = lm_232(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_232(txt, rest);
      then txt;
  end matchcontinue;
end lm_232;

protected function lm_233
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = nls_x["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_233(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_233(txt, rest);
      then txt;
  end matchcontinue;
end lm_233;

protected function fun_234
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eq, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Integer i_index;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, index = i_index),
           a_context )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_TICK_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "SIM_PROF_ADD_NCALL_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",-1);\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "start_nonlinear_system("
                                }, false));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_232(txt, i_crefs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("solve_nonlinear_system(residualFunc"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", data->modelData.equationInfo[SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("], (void*)data);\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_233(txt, i_crefs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end_nonlinear_system();"));
        txt = inlineCrefs(txt, a_context, i_crefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef _OMC_MEASURE_TIME\n",
                                    "SIM_PROF_ACC_EQ(SIM_PROF_EQ_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_234;

public function equationNonlinear
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_234(txt, a_eq, a_context);
  out_a_varDecls := a_varDecls;
end equationNonlinear;

public function reverseLookupEquationNumber
  input Tpl.Text txt;
  input Integer a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("data->modelData.equationInfo[data->modelData.omc_equationInfo_reverse_prof_index[SIM_PROF_EQ_"));
  out_txt := Tpl.writeStr(out_txt, intString(a_index));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("]]"));
end reverseLookupEquationNumber;

protected function lm_237
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !data->simulationInfo.helpVarsPre["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_237(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_237(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_237;

protected function lm_238
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !data->simulationInfo.helpVarsPre["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_238(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_238(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_238;

public function equationWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_elseWhen;
      Tpl.Text l_exp;
      Tpl.Text l_preExp2;
      Tpl.Text l_helpIf;
      Tpl.Text l_helpInits;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE()),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, l_helpInits, a_varDecls, l_preExp) = lm_237(l_helpIf, i_conditions, l_helpInits, a_varDecls, l_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_helpInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp2);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("} else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq)),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_helpInits = Tpl.emptyTxt;
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, l_helpInits, a_varDecls, l_preExp) = lm_238(l_helpIf, i_conditions, l_helpInits, a_varDecls, l_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        (l_elseWhen, l_preExp, l_helpInits, a_varDecls) = equationElseWhen(Tpl.emptyTxt, i_elseWhenEq, a_context, l_preExp, l_helpInits, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_helpInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp2);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_elseWhen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end equationWhen;

protected function lm_240
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !data->simulationInfo.helpVarsPre["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_240(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_240(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_240;

protected function lm_241
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, Integer>> in_items;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_helpInits, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_helpInits, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, Integer>> rest;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer i_hidx;
      DAE.Exp i_e;
      Tpl.Text l_helpInit;

    case ( txt,
           {},
           a_helpInits,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_hidx) :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_helpInit, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        a_helpInits = Tpl.writeStr(a_helpInits, intString(i_hidx));
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING("] = "));
        a_helpInits = Tpl.writeText(a_helpInits, l_helpInit);
        a_helpInits = Tpl.writeTok(a_helpInits, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !data->simulationInfo.helpVarsPre["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_241(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_helpInits,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_helpInits, a_varDecls, a_preExp) = lm_241(txt, rest, a_helpInits, a_varDecls, a_preExp, a_context);
      then (txt, a_helpInits, a_varDecls, a_preExp);
  end matchcontinue;
end lm_241;

public function equationElseWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_helpInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_helpInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_helpInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_eq, in_a_context, in_a_preExp, in_a_helpInits, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_helpInits;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.ComponentRef i_left;
      DAE.Exp i_right;
      list<tuple<DAE.Exp, Integer>> i_conditions;
      Tpl.Text l_elseWhen;
      Tpl.Text l_exp;
      Tpl.Text l_preExp2;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE()),
           a_context,
           a_preExp,
           a_helpInits,
           a_varDecls )
      equation
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, a_helpInits, a_varDecls, a_preExp) = lm_240(l_helpIf, i_conditions, a_helpInits, a_varDecls, a_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if ("));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp2);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_preExp, a_helpInits, a_varDecls);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq)),
           a_context,
           a_preExp,
           a_helpInits,
           a_varDecls )
      equation
        l_helpIf = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_helpIf, a_helpInits, a_varDecls, a_preExp) = lm_241(l_helpIf, i_conditions, a_helpInits, a_varDecls, a_preExp, a_context);
        l_helpIf = Tpl.popIter(l_helpIf);
        l_preExp2 = Tpl.emptyTxt;
        (l_exp, l_preExp2, a_varDecls) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp2, a_varDecls);
        (l_elseWhen, a_preExp, a_helpInits, a_varDecls) = equationElseWhen(Tpl.emptyTxt, i_elseWhenEq, a_context, a_preExp, a_helpInits, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if ("));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp2);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_elseWhen);
      then (txt, a_preExp, a_helpInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_helpInits,
           a_varDecls )
      then (txt, a_preExp, a_helpInits, a_varDecls);
  end matchcontinue;
end equationElseWhen;

protected function lm_243
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_243(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_243(txt, rest);
      then txt;
  end matchcontinue;
end lm_243;

public function simulationFunctionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_functions.h\"\n",
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_243(out_txt, a_literals);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodies(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
end simulationFunctionsFile;

protected function lm_245
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_245(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_245(txt, rest);
      then txt;
  end matchcontinue;
end lm_245;

public function parModelicaKernelsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_functions.h\"\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_245(out_txt, a_literals);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodies(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "\n"
                                   }, true));
end parModelicaKernelsFile;

protected function lm_247
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclaration(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_247(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_247(txt, rest);
      then txt;
  end matchcontinue;
end lm_247;

public function recordsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.RecordDeclaration> a_recordDecls;

  output Tpl.Text out_txt;
protected
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/* Additional record code for "));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
  ret_0 := Settings.getVersionNr();
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ". */\n",
                                       "#include \"meta_modelica.h\"\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_247(out_txt, a_recordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end recordsFile;

protected function fun_249
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include <omc_ocl_interface.h>"));
      then txt;
  end matchcontinue;
end fun_249;

protected function lm_250
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclarationHeader(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_250(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_250(txt, rest);
      then txt;
  end matchcontinue;
end lm_250;

public function simulationFunctionsHeaderFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<SimCode.RecordDeclaration> a_recordDecls;

  output Tpl.Text out_txt;
protected
  Boolean ret_2;
  String ret_1;
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_0 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__H\n"));
  out_txt := commonHeader(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("#include \"simulation_runtime.h\"\n"));
  ret_2 := Config.acceptParModelicaGrammar();
  out_txt := fun_249(out_txt, ret_2);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_250(out_txt, a_recordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionHeaders(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end simulationFunctionsHeaderFile;

protected function fun_252
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end matchcontinue;
end fun_252;

protected function lm_253
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_253(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_253(txt, rest);
      then txt;
  end matchcontinue;
end lm_253;

protected function fun_254
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_254;

protected function fun_255
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end matchcontinue;
end fun_255;

protected function fun_256
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lOMOCLRuntime -lOpenCL"));
      then txt;
  end matchcontinue;
end fun_256;

protected function fun_257
  input Tpl.Text in_txt;
  input Boolean in_a_s_measureTime;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_measureTime)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_MEASURE_TIME "));
      then txt;
  end matchcontinue;
end fun_257;

protected function fun_258
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER "));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK "));
      then txt;

    case ( txt,
           "dassljac" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_JACOBIAN "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_258;

protected function fun_259
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;
      Boolean i_s_measureTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(measureTime = i_s_measureTime, method = i_s_method)) )
      equation
        txt = fun_257(txt, i_s_measureTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_258(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_259;

protected function fun_260
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_ccompiler;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_makefileParams_ccompiler)
    local
      Tpl.Text txt;
      String a_makefileParams_ccompiler;

    case ( txt,
           false,
           a_makefileParams_ccompiler )
      equation
        txt = Tpl.writeStr(txt, a_makefileParams_ccompiler);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("g++"));
      then txt;
  end matchcontinue;
end fun_260;

protected function fun_261
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_261;

protected function lm_262
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_262(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_262(txt, rest);
      then txt;
  end matchcontinue;
end lm_262;

protected function fun_263
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end matchcontinue;
end fun_263;

protected function fun_264
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end matchcontinue;
end fun_264;

protected function fun_265
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "OSX" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lf2c"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-Bstatic -lf2c -Wl,-Bdynamic"));
      then txt;
  end matchcontinue;
end fun_265;

public function simulationMakefile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      String i_makefileParams_senddatalibs;
      String i_makefileParams_ldflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      String i_makefileParams_cflags;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      String ret_14;
      Boolean ret_13;
      Boolean ret_12;
      Boolean ret_11;
      Boolean ret_10;
      Boolean ret_9;
      Boolean ret_8;
      Boolean ret_7;
      Tpl.Text l_extraCflags;
      Boolean ret_5;
      Tpl.Text l_ParModelicaLibs;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, cflags = i_makefileParams_cflags, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes, ldflags = i_makefileParams_ldflags, senddatalibs = i_makefileParams_senddatalibs), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_252(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_253(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_254(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_255(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        ret_5 = Config.acceptParModelicaGrammar();
        l_ParModelicaLibs = fun_256(Tpl.emptyTxt, ret_5);
        l_extraCflags = fun_259(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O3\n",
                                    "CC="
                                }, false));
        ret_7 = Config.acceptParModelicaGrammar();
        txt = fun_260(txt, ret_7, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_261(txt, i_sopt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CPPFLAGS=-I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" -I. "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_262(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS=-L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -lSimulationRuntimeC "));
        txt = Tpl.writeText(txt, l_ParModelicaLibs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SENDDATALIBS="));
        txt = Tpl.writeStr(txt, i_makefileParams_senddatalibs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "FILEPREFIX="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MAINFILE=$(FILEPREFIX)"));
        ret_8 = Config.acceptMetaModelicaGrammar();
        ret_9 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        ret_10 = boolOr(ret_8, ret_9);
        txt = fun_263(txt, ret_10);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "MAINOBJ=$(FILEPREFIX)"
                                }, false));
        ret_11 = Config.acceptMetaModelicaGrammar();
        ret_12 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        ret_13 = boolOr(ret_11, ret_12);
        txt = fun_264(txt, ret_13);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".o\n",
                                    "GENERATEDFILES=$(MAINFILE) $(FILEPREFIX)_functions.c $(FILEPREFIX)_functions.h $(FILEPREFIX)_records.c $(FILEPREFIX).makefile\n",
                                    "\n",
                                    ".PHONY: omc_main_target clean bundle\n",
                                    "\n",
                                    "# This is to make sure that "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_records.c is always compiled.\n",
                                    ".PHONY: $(FILEPREFIX)_records.c\n",
                                    "\n",
                                    "omc_main_target: $(MAINOBJ) $(FILEPREFIX)_records.o $(FILEPREFIX)_functions.c $(FILEPREFIX)_functions.h\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) -I. -o $(FILEPREFIX)$(EXEEXT) $(MAINOBJ) $(FILEPREFIX)_records.o $(CPPFLAGS) "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS) -linteractive $(SENDDATALIBS) "));
        ret_14 = System.os();
        txt = fun_265(txt, ret_14);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".conv.c: $(FILEPREFIX).c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(PERL) "));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/share/omc/scripts/convert_lines.pl $< $@.tmp\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "@mv $@.tmp $@\n",
                                    "\n",
                                    "clean:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "@rm -f $(FILEPREFIX)_records.o $(MAINOBJ)\n",
                                    "\n",
                                    "bundle:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("@tar -cvf $(FILEPREFIX)_Files.tar $(GENERATEDFILES)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end simulationMakefile;

public function xsdateTime
  input Tpl.Text in_txt;
  input Util.DateTime in_a_dt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dt)
    local
      Tpl.Text txt;
      Integer i_sec;
      Integer i_min;
      Integer i_hour;
      Integer i_mday;
      Integer i_mon;
      Integer i_year;
      String ret_4;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           Util.DATETIME(year = i_year, mon = i_mon, mday = i_mday, hour = i_hour, min = i_min, sec = i_sec) )
      equation
        txt = Tpl.writeStr(txt, intString(i_year));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_0 = SimCode.twodigit(i_mon);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_1 = SimCode.twodigit(i_mday);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("T"));
        ret_2 = SimCode.twodigit(i_hour);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_3 = SimCode.twodigit(i_min);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_4 = SimCode.twodigit(i_sec);
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Z"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end xsdateTime;

public function simulationInitFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.ModelInfo i_modelInfo;
      String i_s_variableFilter;
      String i_s_outputFormat;
      String i_s_method;
      Real i_s_tolerance;
      Real i_s_stepSize;
      Real i_s_stopTime;
      Real i_s_startTime;
      Integer i_vi_numBoolParams;
      Integer i_vi_numBoolAliasVars;
      Integer i_vi_numBoolAlgVars;
      Integer i_vi_numStringParamVars;
      Integer i_vi_numStringAliasVars;
      Integer i_vi_numStringAlgVars;
      Integer i_vi_numIntParams;
      Integer i_vi_numIntAliasVars;
      Integer i_vi_numIntAlgVars;
      Integer i_vi_numParams;
      Integer i_vi_numAlgAliasVars;
      Integer i_vi_numAlgVars;
      Integer i_vi_numStateVars;
      Integer i_vi_numJacobianVars;
      list<SimCode.Function> i_functions;
      Integer i_vi_numExternalObjects;
      Integer i_vi_numResiduals;
      Integer i_vi_numOutVars;
      Integer i_vi_numInVars;
      Integer i_vi_numTimeEvents;
      Integer i_vi_numZeroCrossings;
      Integer i_vi_numHelpVars;
      Absyn.Path i_modelInfo_name;
      Integer ret_2;
      Util.DateTime ret_1;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(functions = i_functions, varInfo = SimCode.VARINFO(numHelpVars = i_vi_numHelpVars, numZeroCrossings = i_vi_numZeroCrossings, numTimeEvents = i_vi_numTimeEvents, numInVars = i_vi_numInVars, numOutVars = i_vi_numOutVars, numResiduals = i_vi_numResiduals, numExternalObjects = i_vi_numExternalObjects, numJacobianVars = i_vi_numJacobianVars, numStateVars = i_vi_numStateVars, numAlgVars = i_vi_numAlgVars, numAlgAliasVars = i_vi_numAlgAliasVars, numParams = i_vi_numParams, numIntAlgVars = i_vi_numIntAlgVars, numIntAliasVars = i_vi_numIntAliasVars, numIntParams = i_vi_numIntParams, numStringAlgVars = i_vi_numStringAlgVars, numStringAliasVars = i_vi_numStringAliasVars, numStringParamVars = i_vi_numStringParamVars, numBoolAlgVars = i_vi_numBoolAlgVars, numBoolAliasVars = i_vi_numBoolAliasVars, numBoolParams = i_vi_numBoolParams), vars = SimCode.SIMVARS(stateVars = _), name = i_modelInfo_name)), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_s_startTime, stopTime = i_s_stopTime, stepSize = i_s_stepSize, tolerance = i_s_tolerance, method = i_s_method, outputFormat = i_s_outputFormat, variableFilter = i_s_variableFilter))),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<?xml version = \"1.0\" encoding=\"UTF-8\"?>\n",
                                    "\n",
                                    "<!-- description of the model interface using an extention of the FMI standard -->\n",
                                    "<fmiModelDescription\n",
                                    "  fmiVersion                          = \"1.0\"\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelName                           = \""));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelIdentifier                     = \""
                                }, false));
        txt = underscorePath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "guid                                = \"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "\n",
                                    "generationTool                      = \"OpenModelica Compiler "
                                }, false));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationDateAndTime               = \""
                                }, false));
        ret_1 = Util.getCurrentDateTime();
        txt = xsdateTime(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "variableNamingConvention            = \"structured\"\n",
                                    "\n",
                                    "numberOfHelperVariables             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numHelpVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfHelperVariables             = \"NHELP:    number of helper variables,                         OMC\"\n",
                                    "numberOfEventIndicators             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfEventIndicators             = \"NG:       number of zero crossings,                           FMI\"\n",
                                    "numberOfTimeEvents                  = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfTimeEvents                  = \"NG_SAM:   number of zero crossings that are samples,          OMC\"\n",
                                    "\n",
                                    "numberOfInputVariables              = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfInputVariables              = \"NI:       number of inputvar on topmodel,                     OMC\"\n",
                                    "numberOfOutputVariables             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfOutputVariables             = \"NO:       number of outputvar on topmodel,                    OMC\"\n",
                                    "\n",
                                    "numberOfResidualsForInitialization  = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfResidualsForInitialization  = \"NR:       number of residuals for initialialization function, OMC\"\n",
                                    "numberOfExternalObjects             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfExternalObjects             = \"NEXT:     number of external objects,                         OMC\"\n",
                                    "numberOfFunctions                   = \""
                                }, false));
        ret_2 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfFunctions                   = \"NFUNC:    number of functions used by the simulation,         OMC\"\n",
                                    "numberOfJacobianVariables           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numJacobianVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfJacobianVariables           = \"NJACVARS: number of jacobian variables,                       OMC\"\n",
                                    "\n",
                                    "numberOfContinuousStates            = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfContinuousStates            = \"NX:       number of states,                                   FMI\"\n",
                                    "numberOfRealAlgebraicVariables      = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealAlgebraicVariables      = \"NY:       number of real variables,                           OMC\"\n",
                                    "numberOfRealAlgebraicAliasVariables = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealAlgebraicAliasVariables = \"NA:       number of alias variables,                          OMC\"\n",
                                    "numberOfRealParameters              = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealParameters              = \"NP:       number of parameters,                               OMC\"\n",
                                    "\n",
                                    "numberOfIntegerAlgebraicVariables   = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerAlgebraicVariables   = \"NYINT:    number of alg. int variables,                       OMC\"\n",
                                    "numberOfIntegerAliasVariables       = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerAliasVariables       = \"NAINT:    number of alias int variables,                      OMC\"\n",
                                    "numberOfIntegerParameters           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerParameters           = \"NPINT:    number of int parameters,                           OMC\"\n",
                                    "\n",
                                    "numberOfStringAlgebraicVariables    = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringAlgebraicVariables    = \"NYSTR:    number of alg. string variables,                    OMC\"\n",
                                    "numberOfStringAliasVariables        = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringAliasVariables        = \"NASTR:    number of alias string variables,                   OMC\"\n",
                                    "numberOfStringParameters            = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringParameters            = \"NPSTR:    number of string parameters,                        OMC\"\n",
                                    "\n",
                                    "numberOfBooleanAlgebraicVariables   = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanAlgebraicVariables   = \"NYBOOL:   number of alg. bool variables,                      OMC\"\n",
                                    "numberOfBooleanAliasVariables       = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanAliasVariables       = \"NABOOL:   number of alias bool variables,                     OMC\"\n",
                                    "numberOfBooleanParameters           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanParameters           = \"NPBOOL:   number of bool parameters,                          OMC\" >\n",
                                    "\n",
                                    "\n",
                                    "<!-- startTime, stopTime, tolerance are FMI specific, all others are OMC specific -->\n",
                                    "<DefaultExperiment\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("startTime      = \""));
        txt = Tpl.writeStr(txt, realString(i_s_startTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "stopTime       = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "stepSize       = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_stepSize));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "tolerance      = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_tolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "solver         = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_method);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "outputFormat   = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "variableFilter = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_variableFilter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" />\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<!-- variables in the model -->\n"));
        txt = ModelVariables(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</fmiModelDescription>\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end simulationInitFile;

protected function fun_269
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v) )
      equation
        txt = initVal(txt, i_v);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0.0 //default"));
      then txt;
  end matchcontinue;
end fun_269;

protected function lm_270
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_initialValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(initialValue = i_initialValue, name = i_name) :: rest )
      equation
        txt = fun_269(txt, i_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" //"));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_270(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_270(txt, rest);
      then txt;
  end matchcontinue;
end lm_270;

public function initVals
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_270(out_txt, a_varsLst);
  out_txt := Tpl.popIter(out_txt);
end initVals;

protected function fun_272
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end matchcontinue;
end fun_272;

public function initVal
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_initialValue;
      Absyn.Path i_name;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      Tpl.Text txt_1;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        ret_0 = Util.escapeModelicaStringToCString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_272(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*ENUM:"));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           i_initialValue )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("initial value of unknown type: "));
        ret_1 = ExpressionDump.printExpStr(i_initialValue);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 2266, 14), Tpl.textString(txt_1));
      then txt;
  end matchcontinue;
end initVal;

protected function fun_274
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end matchcontinue;
end fun_274;

public function initValXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_initialValue;
      Absyn.Path i_name;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      Tpl.Text txt_1;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        ret_0 = Util.escapeModelicaStringToXmlString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_274(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*ENUM:"));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           i_initialValue )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("initial value of unknown type: "));
        ret_1 = ExpressionDump.printExpStr(i_initialValue);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 2277, 14), Tpl.textString(txt_1));
      then txt;
  end matchcontinue;
end initValXml;

protected function fun_276
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define __OPENMODELICA__METAMODELICA"));
      then txt;
  end matchcontinue;
end fun_276;

protected function fun_277
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"meta_modelica.h\""));
      then txt;
  end matchcontinue;
end fun_277;

protected function fun_278
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define omp_get_thread_num() 0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include <omp.h>"));
      then txt;
  end matchcontinue;
end fun_278;

public function commonHeader
  input Tpl.Text txt;

  output Tpl.Text out_txt;
protected
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  ret_0 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_276(txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  ret_1 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_277(out_txt, ret_1);
  out_txt := Tpl.softNewLine(out_txt);
  ret_2 := Flags.isSet(Flags.OPENMP);
  out_txt := fun_278(out_txt, ret_2);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#include \"modelica.h\"\n",
                                       "#include <stdio.h>\n",
                                       "#include <stdlib.h>\n",
                                       "#include <errno.h>"
                                   }, false));
end commonHeader;

protected function fun_280
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn) )
      equation
        txt = functionBody(txt, i_fn, true);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_280;

public function functionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ".h\"\n",
                                       "#include \"modelica.h\"\n",
                                       "#define MODELICA_ASSERT(info,msg) { printInfo(stderr,info); fprintf(stderr,\"Modelica Assert: %s!\\n\", msg); }\n",
                                       "#define MODELICA_TERMINATE(msg) { fprintf(stderr,\"Modelica Terminate: %s!\\n\", msg); fflush(stderr); }\n",
                                       "\n"
                                   }, true));
  out_txt := fun_280(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodies(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end functionsFile;

protected function lm_282
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclarationHeader(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_282(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_282(txt, rest);
      then txt;
  end matchcontinue;
end lm_282;

protected function fun_283
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn) )
      equation
        txt = functionHeader(txt, i_fn, true);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_283;

protected function lm_284
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_284(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_284(txt, rest);
      then txt;
  end matchcontinue;
end lm_284;

public function functionsHeaderFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;
  input list<SimCode.RecordDeclaration> a_extraRecordDecls;
  input list<String> a_includes;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_0 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__H\n"));
  out_txt := commonHeader(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_282(out_txt, a_extraRecordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := fun_283(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionHeaders(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := externalFunctionIncludes(out_txt, a_includes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_284(out_txt, a_literals);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "#endif\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end functionsHeaderFile;

protected function lm_286
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_286(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_286(txt, rest);
      then txt;
  end matchcontinue;
end lm_286;

protected function lm_287
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_287(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_287(txt, rest);
      then txt;
  end matchcontinue;
end lm_287;

protected function fun_288
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end matchcontinue;
end fun_288;

public function functionsMakefile
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_fnCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fnCode)
    local
      Tpl.Text txt;
      String i_name;
      String i_makefileParams_senddatalibs;
      String i_makefileParams_ldflags;
      String i_makefileParams_cflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      list<String> i_makefileParams_libs;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Tpl.Text l_libsStr;

    case ( txt,
           SimCode.FUNCTIONCODE(makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes, cflags = i_makefileParams_cflags, ldflags = i_makefileParams_ldflags, senddatalibs = i_makefileParams_senddatalibs), name = i_name) )
      equation
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_286(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Dynamic loading uses -O0 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O0\n",
                                    "CC="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS= -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc\" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_287(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS= -L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -lSimulationRuntimeC "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SENDDATALIBS="));
        txt = Tpl.writeStr(txt, i_makefileParams_senddatalibs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "MAINFILE="
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        ret_1 = Config.acceptMetaModelicaGrammar();
        ret_2 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        ret_3 = boolOr(ret_1, ret_2);
        txt = fun_288(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "\n",
                                    ".PHONY: "
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": $(MAINFILE) "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CC) $(CFLAGS) -c -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".o $(MAINFILE)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CC) $(CFLAGS) -c -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(LINK) -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o "));
        txt = Tpl.writeText(txt, l_libsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" $(CFLAGS) $(LDFLAGS) $(SENDDATALIBS) -lm\n"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv.c: "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(PERL) "));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/share/omc/scripts/convert_lines.pl $< $@.tmp\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" @mv $@.tmp $@"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionsMakefile;

protected function fun_290
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt_0 = crefStr(Tpl.emptyTxt, a_cr);
        ret_1 = System.unquoteIdentifier(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = cref(txt, a_cr);
      then txt;
  end matchcontinue;
end fun_290;

public function contextCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_290(txt, a_context, a_cr);
end contextCref;

protected function fun_292
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Absyn.Ident in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Ident a_name;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end matchcontinue;
end fun_292;

public function contextIteratorName
  input Tpl.Text txt;
  input Absyn.Ident a_name;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_292(txt, a_context, a_name);
end contextIteratorName;

public function cref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_cr);
      then txt;
  end matchcontinue;
end cref;

public function crefToCStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = subscriptsToCStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end crefToCStr;

protected function lm_296
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToCStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_296(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_296(txt, rest);
      then txt;
  end matchcontinue;
end lm_296;

public function subscriptsToCStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$lB"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("$c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_296(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$rB"));
      then txt;
  end matchcontinue;
end subscriptsToCStr;

public function subscriptToCStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end matchcontinue;
end subscriptToCStr;

public function crefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = crefStr(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end crefStr;

public function crefM
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("P"));
        txt = crefToMStr(txt, i_cr);
      then txt;
  end matchcontinue;
end crefM;

public function crefToMStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = subscriptsToMStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToMStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("P"));
        txt = crefToMStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end crefToMStr;

protected function lm_302
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToMStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_302(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_302(txt, rest);
      then txt;
  end matchcontinue;
end lm_302;

public function subscriptsToMStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("lB"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_302(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rB"));
      then txt;
  end matchcontinue;
end subscriptsToMStr;

protected function fun_304
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end matchcontinue;
end fun_304;

public function subscriptToMStr
  input Tpl.Text txt;
  input DAE.Subscript a_subscript;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDecls;
  Tpl.Text l_preExp;
algorithm
  l_preExp := Tpl.emptyTxt;
  l_varDecls := Tpl.emptyTxt;
  out_txt := fun_304(txt, a_subscript);
end subscriptToMStr;

protected function fun_306
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = arrayCrefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = arrayCrefCStr(txt, a_cr);
      then txt;
  end matchcontinue;
end fun_306;

public function contextArrayCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_306(txt, a_context, a_cr);
end contextArrayCref;

public function arrayCrefCStr
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
  out_txt := arrayCrefCStr2(out_txt, a_cr);
end arrayCrefCStr;

public function arrayCrefCStr2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = arrayCrefCStr2(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end arrayCrefCStr2;

public function arrayCrefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = arrayCrefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end matchcontinue;
end arrayCrefStr;

protected function lm_311
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_311(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_311(txt, rest);
      then txt;
  end matchcontinue;
end lm_311;

public function subscriptsStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_311(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end matchcontinue;
end subscriptsStr;

public function subscriptStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end matchcontinue;
end subscriptStr;

public function expCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_arg_componentRef;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.CREF(componentRef = i_componentRef) )
      equation
        txt = cref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$DER"));
        txt = cref(txt, i_arg_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ERROR_NOT_A_CREF"));
      then txt;
  end matchcontinue;
end expCref;

public function crefFunctionName
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        ret_1 = System.stringReplace(ret_0, "_", "__");
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_2 = System.unquoteIdentifier(i_ident);
        ret_3 = System.stringReplace(ret_2, "_", "__");
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefFunctionName(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end crefFunctionName;

public function dotPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dotPath;

public function replaceDotAndUnderscore
  input Tpl.Text in_txt;
  input String in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_str)
    local
      Tpl.Text txt;
      String i_name;
      String ret_4;
      String ret_3;
      Tpl.Text l_str__underscores;
      String ret_1;
      Tpl.Text l_str__dots;

    case ( txt,
           i_name )
      equation
        ret_1 = System.stringReplace(i_name, ".", "_");
        l_str__dots = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = System.stringReplace(Tpl.textString(l_str__dots), "_", "__");
        l_str__underscores = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        ret_4 = System.unquoteIdentifier(Tpl.textString(l_str__underscores));
        txt = Tpl.writeStr(txt, ret_4);
      then txt;
  end matchcontinue;
end replaceDotAndUnderscore;

public function underscorePath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end underscorePath;

protected function lm_319
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_319(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_319(txt, rest);
      then txt;
  end matchcontinue;
end lm_319;

public function externalFunctionIncludes
  input Tpl.Text in_txt;
  input list<String> in_a_includes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_includes)
    local
      Tpl.Text txt;
      list<String> i_includes;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_includes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_319(txt, i_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif"
                                }, false));
      then txt;
  end matchcontinue;
end externalFunctionIncludes;

protected function lm_321
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = functionHeader(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_321(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_321(txt, rest);
      then txt;
  end matchcontinue;
end lm_321;

public function functionHeaders
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_321(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end functionHeaders;

protected function lm_323
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) :: rest )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_323(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_323(txt, rest);
      then txt;
  end matchcontinue;
end lm_323;

protected function lm_324
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgBoxedDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_324(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_324(txt, rest);
      then txt;
  end matchcontinue;
end lm_324;

protected function fun_325
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Variable> in_a_funArgs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_funArgs)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_funArgs;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_funArgs )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_324(txt, a_funArgs);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_325;

protected function fun_326
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_funArgsBoxedStr;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_funArgsBoxedStr, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_funArgsBoxedStr;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_funArgsBoxedStr,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype boxptr_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_funArgsBoxedStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end matchcontinue;
end fun_326;

public function functionHeader
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_fn;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      Boolean ret_14;
      Tpl.Text l_boxedHeader;
      Boolean ret_12;
      Tpl.Text l_funArgsBoxedStr;
      Tpl.Text l_funArgsStr;
      Tpl.Text l_fname;
      Boolean ret_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Boolean ret_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars)),
           a_inFunc )
      equation
        txt_0 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderNormal(txt, Tpl.textString(txt_0), i_functionArguments, i_outVars, a_inFunc, false);
        txt = Tpl.softNewLine(txt);
        txt_1 = underscorePath(Tpl.emptyTxt, i_name);
        ret_2 = SimCode.isBoxedFunction(i_fn);
        txt = functionHeaderBoxed(txt, Tpl.textString(txt_1), i_functionArguments, i_outVars, ret_2, false);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, name = i_name, funArgs = i_funArgs, outVars = i_outVars)),
           a_inFunc )
      equation
        txt_3 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderNormal(txt, Tpl.textString(txt_3), i_funArgs, i_outVars, a_inFunc, true);
        txt = Tpl.softNewLine(txt);
        txt_4 = underscorePath(Tpl.emptyTxt, i_name);
        ret_5 = SimCode.isBoxedFunction(i_fn);
        txt = functionHeaderBoxed(txt, Tpl.textString(txt_4), i_funArgs, i_outVars, ret_5, true);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = extFunDefDynamic(txt, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name, funArgs = i_funArgs, outVars = i_outVars)),
           a_inFunc )
      equation
        txt_6 = underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderNormal(txt, Tpl.textString(txt_6), i_funArgs, i_outVars, a_inFunc, false);
        txt = Tpl.softNewLine(txt);
        txt_7 = underscorePath(Tpl.emptyTxt, i_name);
        ret_8 = SimCode.isBoxedFunction(i_fn);
        txt = functionHeaderBoxed(txt, Tpl.textString(txt_7), i_funArgs, i_outVars, ret_8, false);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = extFunDef(txt, i_fn);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs),
           _ )
      equation
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_funArgsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funArgsStr = lm_323(l_funArgsStr, i_funArgs);
        l_funArgsStr = Tpl.popIter(l_funArgsStr);
        ret_12 = Config.acceptMetaModelicaGrammar();
        l_funArgsBoxedStr = fun_325(Tpl.emptyTxt, ret_12, i_funArgs);
        ret_14 = Config.acceptMetaModelicaGrammar();
        l_boxedHeader = fun_326(Tpl.emptyTxt, ret_14, l_funArgsBoxedStr, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_rettype_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" c1;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_funArgsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_boxedHeader);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionHeader;

protected function lm_328
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_328(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_328(txt, rest);
      then txt;
  end matchcontinue;
end lm_328;

protected function lm_329
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_329(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_329(txt, rest);
      then txt;
  end matchcontinue;
end lm_329;

public function recordDeclaration
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_recDecl)
    local
      Tpl.Text txt;
      list<String> i_fieldNames;
      Absyn.Path i_path;
      list<SimCode.Variable> i_variables;
      Absyn.Path i_defPath;
      Integer ret_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Integer ret_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.RECORD_DECL_FULL(defPath = i_defPath, variables = i_variables) )
      equation
        txt_0 = dotPath(Tpl.emptyTxt, i_defPath);
        txt_1 = underscorePath(Tpl.emptyTxt, i_defPath);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_328(txt_2, i_variables);
        txt_2 = Tpl.popIter(txt_2);
        ret_3 = listLength(i_variables);
        txt = recordDefinition(txt, Tpl.textString(txt_0), Tpl.textString(txt_1), Tpl.textString(txt_2), ret_3);
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = i_path, fieldNames = i_fieldNames) )
      equation
        txt_4 = dotPath(Tpl.emptyTxt, i_path);
        txt_5 = underscorePath(Tpl.emptyTxt, i_path);
        txt_6 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_6 = lm_329(txt_6, i_fieldNames);
        txt_6 = Tpl.popIter(txt_6);
        ret_7 = listLength(i_fieldNames);
        txt = recordDefinition(txt, Tpl.textString(txt_4), Tpl.textString(txt_5), Tpl.textString(txt_6), ret_7);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end recordDeclaration;

protected function lm_331
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name)) :: rest )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_331(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_331(txt, rest);
      then txt;
  end matchcontinue;
end lm_331;

public function recordDeclarationHeader
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_recDecl)
    local
      Tpl.Text txt;
      list<String> i_fieldNames;
      Absyn.Path i_path;
      Absyn.Path i_defPath;
      list<SimCode.Variable> i_variables;
      String i_name;
      Integer ret_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Integer ret_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.RECORD_DECL_FULL(name = i_name, variables = i_variables, defPath = i_defPath) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_331(txt, i_variables);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt_0 = dotPath(Tpl.emptyTxt, i_defPath);
        txt_1 = underscorePath(Tpl.emptyTxt, i_defPath);
        ret_2 = listLength(i_variables);
        txt = recordDefinitionHeader(txt, Tpl.textString(txt_0), Tpl.textString(txt_1), ret_2);
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = i_path, fieldNames = i_fieldNames) )
      equation
        txt_3 = dotPath(Tpl.emptyTxt, i_path);
        txt_4 = underscorePath(Tpl.emptyTxt, i_path);
        ret_5 = listLength(i_fieldNames);
        txt = recordDefinitionHeader(txt, Tpl.textString(txt_3), Tpl.textString(txt_4), ret_5);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end recordDeclarationHeader;

protected function fun_333
  input Tpl.Text in_txt;
  input Integer in_a_numFields;
  input String in_a_fieldNames;
  input String in_a_encName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_numFields, in_a_fieldNames, in_a_encName)
    local
      Tpl.Text txt;
      String a_fieldNames;
      String a_encName;
      Integer i_numFields;

    case ( txt,
           0,
           _,
           a_encName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char* "));
        txt = Tpl.writeStr(txt, a_encName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc__fields[1] = {\"no fileds\"};"));
      then txt;

    case ( txt,
           i_numFields,
           a_fieldNames,
           a_encName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char* "));
        txt = Tpl.writeStr(txt, a_encName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc__fields["));
        txt = Tpl.writeStr(txt, intString(i_numFields));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.writeStr(txt, a_fieldNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end matchcontinue;
end fun_333;

public function recordDefinition
  input Tpl.Text txt;
  input String a_origName;
  input String a_encName;
  input String a_fieldNames;
  input Integer a_numFields;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fieldsDescription;
algorithm
  l_fieldsDescription := fun_333(Tpl.emptyTxt, a_numFields, a_fieldNames, a_encName);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc_added 1\n"));
  out_txt := Tpl.writeText(out_txt, l_fieldsDescription);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("struct record_description "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc = {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\", /* package_record__X */\n",
                                       "\""
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_origName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("\", /* package.record_X */\n"));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc__fields\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("};"));
end recordDefinition;

public function recordDefinitionHeader
  input Tpl.Text txt;
  input String a_origName;
  input String a_encName;
  input Integer a_numFields;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("extern struct record_description "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("__desc;"));
end recordDefinitionHeader;

public function functionHeaderNormal
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input Boolean a_dynamicLoad;

  output Tpl.Text out_txt;
algorithm
  out_txt := functionHeaderImpl(txt, a_fname, a_fargs, a_outVars, a_inFunc, false, a_dynamicLoad);
end functionHeaderNormal;

protected function fun_337
  input Tpl.Text in_txt;
  input Boolean in_a_isBoxed;
  input Boolean in_a_dynamicLoad;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_fargs;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isBoxed, in_a_dynamicLoad, in_a_outVars, in_a_fargs, in_a_fname)
    local
      Tpl.Text txt;
      Boolean a_dynamicLoad;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_fargs;
      String a_fname;

    case ( txt,
           false,
           a_dynamicLoad,
           a_outVars,
           a_fargs,
           a_fname )
      equation
        txt = functionHeaderImpl(txt, a_fname, a_fargs, a_outVars, false, true, a_dynamicLoad);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define boxptr_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_337;

protected function fun_338
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fname;
  input list<SimCode.Variable> in_a_fargs;
  input list<SimCode.Variable> in_a_outVars;
  input Boolean in_a_isBoxed;
  input Boolean in_a_dynamicLoad;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fname, in_a_fargs, in_a_outVars, in_a_isBoxed, in_a_dynamicLoad)
    local
      Tpl.Text txt;
      String a_fname;
      list<SimCode.Variable> a_fargs;
      list<SimCode.Variable> a_outVars;
      Boolean a_isBoxed;
      Boolean a_dynamicLoad;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname,
           a_fargs,
           a_outVars,
           a_isBoxed,
           a_dynamicLoad )
      equation
        txt = fun_337(txt, a_isBoxed, a_dynamicLoad, a_outVars, a_fargs, a_fname);
      then txt;
  end matchcontinue;
end fun_338;

public function functionHeaderBoxed
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_isBoxed;
  input Boolean a_dynamicLoad;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_338(txt, ret_0, a_fname, a_fargs, a_outVars, a_isBoxed, a_dynamicLoad);
end functionHeaderBoxed;

protected function lm_340
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_340(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_340(txt, rest);
      then txt;
  end matchcontinue;
end lm_340;

protected function lm_341
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgBoxedDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_341(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_341(txt, rest);
      then txt;
  end matchcontinue;
end lm_341;

protected function fun_342
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input list<SimCode.Variable> in_a_fargs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed, in_a_fargs)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_fargs;

    case ( txt,
           false,
           a_fargs )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_340(txt, a_fargs);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           a_fargs )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_341(txt, a_fargs);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_342;

protected function fun_343
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxed"));
      then txt;
  end matchcontinue;
end fun_343;

protected function fun_344
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxptr"));
      then txt;
  end matchcontinue;
end fun_344;

protected function fun_345
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inFunc, in_a_fname)
    local
      Tpl.Text txt;
      String a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "DLLExport\n",
                                    "int in_"
                                }, false));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(type_description * inArgs, type_description * outVar);"));
      then txt;
  end matchcontinue;
end fun_345;

protected function fun_346
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input String in_a_fname;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed, in_a_fname, in_a_inFunc)
    local
      Tpl.Text txt;
      String a_fname;
      Boolean a_inFunc;

    case ( txt,
           false,
           a_fname,
           a_inFunc )
      equation
        txt = fun_345(txt, a_inFunc, a_fname);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_346;

protected function fun_347
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_fargsStr;
  input String in_a_fname;
  input Tpl.Text in_a_boxPtrStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_fargsStr, in_a_fname, in_a_boxPtrStr)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      String a_fname;
      Tpl.Text a_boxPtrStr;

    case ( txt,
           false,
           a_fargsStr,
           a_fname,
           a_boxPtrStr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_boxPtrStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_347;

protected function lm_348
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_348(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_348(txt, rest);
      then txt;
  end matchcontinue;
end lm_348;

protected function fun_349
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_348(txt, i_dims);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_349;

protected function fun_350
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_boxed, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;

    case ( txt,
           false,
           a_var )
      equation
        txt = varType(txt, a_var);
      then txt;

    case ( txt,
           _,
           a_var )
      equation
        txt = varTypeBoxed(txt, a_var);
      then txt;
  end matchcontinue;
end fun_350;

protected function fun_351
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_i1;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_i1, in_a_boxed)
    local
      Tpl.Text txt;
      Integer a_i1;
      Boolean a_boxed;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;
      DAE.Type i_ty;
      Tpl.Text l_typeStr;
      Tpl.Text l_dimStr;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_name)),
           a_i1,
           a_boxed )
      equation
        l_dimStr = fun_349(Tpl.emptyTxt, i_ty);
        l_typeStr = fun_350(Tpl.emptyTxt, a_boxed, i_var);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeText(txt, l_dimStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_i1,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = Tpl.writeStr(txt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_351;

protected function lm_352
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_boxed)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_boxed;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_boxed )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_351(txt, i_var, x_i1, a_boxed);
        txt = Tpl.nextIter(txt);
        txt = lm_352(txt, rest, a_boxed);
      then txt;

    case ( txt,
           _ :: rest,
           a_boxed )
      equation
        txt = lm_352(txt, rest, a_boxed);
      then txt;
  end matchcontinue;
end lm_352;

protected function fun_353
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_fargsStr;
  input Tpl.Text in_a_boxPtrStr;
  input Tpl.Text in_a_boxStr;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_fargsStr, in_a_boxPtrStr, in_a_boxStr, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      Tpl.Text a_boxPtrStr;
      Tpl.Text a_boxStr;
      String a_fname;

    case ( txt,
           false,
           a_fargsStr,
           a_boxPtrStr,
           a_boxStr,
           a_fname )
      equation
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_boxPtrStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_353;

protected function fun_354
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_inFnStr;
  input Boolean in_a_boxed;
  input Tpl.Text in_a_boxStr;
  input Tpl.Text in_a_fargsStr;
  input String in_a_fname;
  input Tpl.Text in_a_boxPtrStr;
  input Boolean in_a_dynamicLoad;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_inFnStr, in_a_boxed, in_a_boxStr, in_a_fargsStr, in_a_fname, in_a_boxPtrStr, in_a_dynamicLoad)
    local
      Tpl.Text txt;
      Tpl.Text a_inFnStr;
      Boolean a_boxed;
      Tpl.Text a_boxStr;
      Tpl.Text a_fargsStr;
      String a_fname;
      Tpl.Text a_boxPtrStr;
      Boolean a_dynamicLoad;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {},
           _,
           _,
           _,
           a_fargsStr,
           a_fname,
           a_boxPtrStr,
           a_dynamicLoad )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_347(txt, a_dynamicLoad, a_fargsStr, a_fname, a_boxPtrStr);
      then txt;

    case ( txt,
           i_outVars,
           a_inFnStr,
           a_boxed,
           a_boxStr,
           a_fargsStr,
           a_fname,
           a_boxPtrStr,
           a_dynamicLoad )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_352(txt, i_outVars, a_boxed);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
        txt = Tpl.writeText(txt, a_boxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_inFnStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_353(txt, a_dynamicLoad, a_fargsStr, a_boxPtrStr, a_boxStr, a_fname);
      then txt;
  end matchcontinue;
end fun_354;

public function functionHeaderImpl
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input Boolean a_boxed;
  input Boolean a_dynamicLoad;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_inFnStr;
  Tpl.Text l_boxPtrStr;
  Tpl.Text l_boxStr;
  Tpl.Text l_fargsStr;
algorithm
  l_fargsStr := fun_342(Tpl.emptyTxt, a_boxed, a_fargs);
  l_boxStr := fun_343(Tpl.emptyTxt, a_boxed);
  l_boxPtrStr := fun_344(Tpl.emptyTxt, a_boxed);
  l_inFnStr := fun_346(Tpl.emptyTxt, a_boxed, a_fname, a_inFunc);
  out_txt := fun_354(txt, a_outVars, l_inFnStr, a_boxed, l_boxStr, l_fargsStr, a_fname, l_boxPtrStr, a_dynamicLoad);
end functionHeaderImpl;

public function funArgName
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name) )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end funArgName;

public function funArgDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end funArgDefinition;

public function funArgBoxedDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end funArgBoxedDefinition;

public function extFunDef
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.SimExtArg> i_extArgs;
      String i_language;
      String i_extName;
      Tpl.Text l_fargsStr;
      Tpl.Text l_fn__name;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extName = i_extName, language = i_language, extArgs = i_extArgs, extReturn = i_extReturn) )
      equation
        l_fn__name = extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern "));
        txt = extReturnType(txt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDef;

public function extFunDefDynamic
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.SimExtArg> i_extArgs;
      String i_language;
      String i_extName;
      Tpl.Text l_fargsStr;
      Tpl.Text l_fn__name;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extName = i_extName, language = i_language, extArgs = i_extArgs, extReturn = i_extReturn) )
      equation
        l_fn__name = extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef "));
        txt = extReturnType(txt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" (*ptrT_"));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, l_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "extern ptrT_"
                                }, false));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDefDynamic;

protected function fun_361
  input Tpl.Text in_txt;
  input String in_a_language;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_language, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           "FORTRAN 77",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 2814, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_361;

public function extFunctionName
  input Tpl.Text txt;
  input String a_name;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_361(txt, a_language, a_name);
end extFunctionName;

protected function lm_363
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_363(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_363(txt, rest);
      then txt;
  end matchcontinue;
end lm_363;

protected function lm_364
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArgF77(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_364(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_364(txt, rest);
      then txt;
  end matchcontinue;
end lm_364;

protected function fun_365
  input Tpl.Text in_txt;
  input String in_a_language;
  input list<SimCode.SimExtArg> in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_language, in_a_args)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> a_args;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_363(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           "FORTRAN 77",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_364(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 2822, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_365;

public function extFunDefArgs
  input Tpl.Text txt;
  input list<SimCode.SimExtArg> a_args;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_365(txt, a_language, a_args);
end extFunDefArgs;

public function extReturnType
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.Type i_type__;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           SimCode.SIMEXTARG(type_ = i_type__) )
      equation
        txt = extType(txt, i_type__, true, false);
      then txt;

    case ( txt,
           SimCode.SIMNOEXTARG() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp) )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Expression types are unsupported as return arguments "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 2831, 36), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 2832, 14), "Unsupported return argument");
      then txt;
  end matchcontinue;
end extReturnType;

protected function fun_368
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isInput;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_isInput)
    local
      Tpl.Text txt;
      Boolean a_isInput;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char*"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_isInput )
      equation
        txt = extType(txt, i_ty, a_isInput, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void *"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           i_type,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external C type "));
        ret_0 = ExpressionDump.typeString(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 2851, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_368;

protected function fun_369
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "const char*" )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const "));
      then txt;
  end matchcontinue;
end fun_369;

protected function fun_370
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;
      String str_0;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        str_0 = Tpl.textString(a_s);
        txt = fun_369(txt, str_0);
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end matchcontinue;
end fun_370;

protected function fun_371
  input Tpl.Text in_txt;
  input Boolean in_a_isInput;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isInput, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Tpl.Text a_s;

    case ( txt,
           false,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_s )
      equation
        txt = fun_370(txt, a_isArray, a_s);
      then txt;
  end matchcontinue;
end fun_371;

protected function fun_372
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isArray;
  input Boolean in_a_isInput;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_isArray, in_a_isInput, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Boolean a_isInput;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_isInput,
           a_s )
      equation
        txt = fun_371(txt, a_isInput, a_isArray, a_s);
      then txt;
  end matchcontinue;
end fun_372;

public function extType
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isInput;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_368(Tpl.emptyTxt, a_type, a_isInput);
  out_txt := fun_372(txt, a_type, a_isArray, a_isInput, l_s);
end extType;

protected function fun_374
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("char"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = extTypeF77(txt, i_ty, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           i_type )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external F77 type "));
        ret_0 = ExpressionDump.typeString(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 2870, 14), Tpl.textString(txt_0));
      then txt;
  end matchcontinue;
end fun_374;

protected function fun_375
  input Tpl.Text in_txt;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end matchcontinue;
end fun_375;

protected function fun_376
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isReference;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isReference,
           a_s )
      equation
        txt = fun_375(txt, a_isReference, a_s);
      then txt;
  end matchcontinue;
end fun_376;

public function extTypeF77
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isReference;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_374(Tpl.emptyTxt, a_type);
  out_txt := fun_376(txt, a_type, a_isReference, l_s);
end extTypeF77;

public function extFunDefArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Type i_type__;
      Boolean i_ia;
      Boolean i_ii;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = i_ii, isArray = i_ia, type_ = i_t) )
      equation
        l_name = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_typeStr = extType(Tpl.emptyTxt, i_t, i_ii, i_ia);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__) )
      equation
        l_typeStr = extType(Tpl.emptyTxt, i_type__, true, false);
        txt = Tpl.writeText(txt, l_typeStr);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDefArg;

public function extFunDefArgF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Type i_type__;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, type_ = i_t) )
      equation
        l_name = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_typeStr = extTypeF77(Tpl.emptyTxt, i_t, true);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__) )
      equation
        txt = extTypeF77(txt, i_type__, true);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int *"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunDefArgF77;

protected function fun_380
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = dotPath(txt, a_name);
      then txt;
  end matchcontinue;
end fun_380;

protected function fun_381
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = dotPath(txt, a_name);
      then txt;
  end matchcontinue;
end fun_381;

protected function fun_382
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = dotPath(txt, a_name);
      then txt;
  end matchcontinue;
end fun_382;

public function functionName
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_dotPath;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_dotPath)
    local
      Tpl.Text txt;
      Boolean a_dotPath;
      Absyn.Path i_name;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_380(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_381(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name),
           a_dotPath )
      equation
        txt = fun_382(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionName;

protected function lm_384
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = functionBody(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_384(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_384(txt, rest);
      then txt;
  end matchcontinue;
end lm_384;

public function functionBodies
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_384(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end functionBodies;

public function functionBody
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           _ )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionBody;

protected function fun_387
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_var_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;

    case ( txt,
           "modelica_metatype",
           a_var_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_387;

protected function fun_388
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input SimCode.Variable in_a_var;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_var, in_a_var_name)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;
      DAE.ComponentRef a_var_name;
      String str_1;
      Tpl.Text l_typ;

    case ( txt,
           DAE.T_METATYPE(ty = _),
           _,
           a_var_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _),
           _,
           a_var_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;

    case ( txt,
           _,
           a_var,
           a_var_name )
      equation
        l_typ = varType(Tpl.emptyTxt, a_var);
        str_1 = Tpl.textString(l_typ);
        txt = fun_387(txt, str_1, a_var_name);
      then txt;
  end matchcontinue;
end fun_388;

public function addRoots
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      DAE.Type i_ty;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_var_name)) )
      equation
        txt = fun_388(txt, i_ty, i_var, i_var_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end addRoots;

protected function fun_390
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end matchcontinue;
end fun_390;

protected function fun_391
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_outVars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_391;

protected function fun_392
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_392;

protected function lm_393
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varFrees;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varFrees, out_a_varInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varFrees, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varFrees;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varFrees,
           a_varInits,
           a_varDecls )
      then (txt, a_varFrees, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_varFrees,
           a_varInits,
           a_varDecls )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_varInits, a_varFrees) = varInit(txt, i_var, "", x_i1, a_varDecls, a_varInits, a_varFrees);
        txt = Tpl.nextIter(txt);
        (txt, a_varFrees, a_varInits, a_varDecls) = lm_393(txt, rest, a_varFrees, a_varInits, a_varDecls);
      then (txt, a_varFrees, a_varInits, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varFrees,
           a_varInits,
           a_varDecls )
      equation
        (txt, a_varFrees, a_varInits, a_varDecls) = lm_393(txt, rest, a_varFrees, a_varInits, a_varDecls);
      then (txt, a_varFrees, a_varInits, a_varDecls);
  end matchcontinue;
end lm_393;

protected function lm_394
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = addRoots(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_394(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_394(txt, rest);
      then txt;
  end matchcontinue;
end lm_394;

protected function lm_395
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = addRoots(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_395(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_395(txt, rest);
      then txt;
  end matchcontinue;
end lm_395;

protected function lm_396
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_varInits)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varInits;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varInits )
      then (txt, a_varInits);

    case ( txt,
           i_var :: rest,
           a_varInits )
      equation
        (txt, a_varInits) = functionArg(txt, i_var, a_varInits);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits) = lm_396(txt, rest, a_varInits);
      then (txt, a_varInits);

    case ( txt,
           _ :: rest,
           a_varInits )
      equation
        (txt, a_varInits) = lm_396(txt, rest, a_varInits);
      then (txt, a_varInits);
  end matchcontinue;
end lm_396;

protected function lm_397
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = funStatement(txt, i_stmt, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_397(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_397(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_397;

protected function lm_398
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutput(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_398(txt, rest, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           _ :: rest,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_398(txt, rest, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end matchcontinue;
end lm_398;

protected function fun_399
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function a_fn;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fn )
      equation
        txt = functionBodyBoxed(txt, a_fn);
      then txt;
  end matchcontinue;
end fun_399;

protected function lm_400
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_400(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_400(txt, rest);
      then txt;
  end matchcontinue;
end lm_400;

protected function fun_401
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_local_state_type mmc_GC_local_state = mmc_GC_save_roots_state(\"_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;
  end matchcontinue;
end fun_401;

protected function fun_402
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_addRootsInputs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_addRootsInputs)
    local
      Tpl.Text txt;
      Tpl.Text a_addRootsInputs;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_addRootsInputs )
      equation
        txt = Tpl.writeText(txt, a_addRootsInputs);
      then txt;
  end matchcontinue;
end fun_402;

protected function fun_403
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_403;

protected function fun_404
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_404;

protected function fun_405
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_undo_roots_state(mmc_GC_local_state);"));
      then txt;
  end matchcontinue;
end fun_405;

protected function fun_406
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varFrees;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_varFrees)
    local
      Tpl.Text txt;
      Tpl.Text a_varFrees;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_varFrees )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Free GPU/OpenCL CPU memory */"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_varFrees);
      then txt;
  end matchcontinue;
end fun_406;

protected function fun_407
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_407;

protected function lm_408
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_408(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_408(txt, rest);
      then txt;
  end matchcontinue;
end lm_408;

protected function fun_409
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" out;"));
      then txt;
  end matchcontinue;
end fun_409;

protected function lm_410
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = readInVar(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_410(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_410(txt, rest);
      then txt;
  end matchcontinue;
end lm_410;

protected function fun_411
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out = "));
      then txt;
  end matchcontinue;
end fun_411;

protected function lm_412
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgName(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_412(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_412(txt, rest);
      then txt;
  end matchcontinue;
end lm_412;

protected function lm_413
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = writeOutVar(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_413(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_413(txt, rest);
      then txt;
  end matchcontinue;
end lm_413;

protected function fun_414
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_noretcall(outVar);"));
      then txt;

    case ( txt,
           i_outVars )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_413(txt, i_outVars);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_414;

protected function fun_415
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input Tpl.Text in_a_retType;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_functionArguments;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inFunc, in_a_retType, in_a_outVars, in_a_functionArguments, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_functionArguments;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_retType,
           a_outVars,
           a_functionArguments,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar) {\n",
                                    "  void* states = push_memory_states(1);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_408(txt, a_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_409(txt, a_outVars, a_retType);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_410(txt, a_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("MMC_TRY_TOP()\n"));
        txt = fun_411(txt, a_outVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_412(txt, a_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MMC_CATCH_TOP(return 1)\n"
                                }, true));
        txt = fun_414(txt, a_outVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fflush(NULL);\n",
                                    "pop_memory_states(states);\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end matchcontinue;
end fun_415;

public function functionBodyRegularFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.Function i_fn;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_functionArguments;
      list<SimCode.Variable> i_variableDeclarations;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Boolean ret_24;
      Boolean ret_23;
      Boolean ret_22;
      Boolean ret_21;
      Boolean ret_20;
      Boolean ret_19;
      Boolean ret_18;
      Tpl.Text l_boxedFn;
      Tpl.Text l_0___1;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarInits;
      Tpl.Text l_bodyPart;
      Tpl.Text l_funArgs;
      Tpl.Text l_addRootsOutputs;
      Tpl.Text l_addRootsInputs;
      Tpl.Text l_0__;
      Boolean ret_7;
      Tpl.Text l_stateVar;
      Tpl.Text l_retVar;
      Tpl.Text l_varFrees;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, outVars = i_outVars, variableDeclarations = i_variableDeclarations, functionArguments = i_functionArguments, body = i_body)),
           a_inFunc )
      equation
        System.tmpTickReset(1);
        System.tmpTickResetIndex(0, 1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_390(Tpl.emptyTxt, i_outVars, l_fname);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_varFrees = Tpl.emptyTxt;
        (l_retVar, l_varDecls) = fun_391(Tpl.emptyTxt, i_outVars, l_varDecls, l_retType);
        ret_7 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, l_varDecls) = fun_392(Tpl.emptyTxt, ret_7, l_varDecls);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varFrees, l_varInits, l_varDecls) = lm_393(l_0__, i_variableDeclarations, l_varFrees, l_varInits, l_varDecls);
        l_0__ = Tpl.popIter(l_0__);
        l_addRootsInputs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_addRootsInputs = lm_394(l_addRootsInputs, i_functionArguments);
        l_addRootsInputs = Tpl.popIter(l_addRootsInputs);
        l_addRootsOutputs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_addRootsOutputs = lm_395(l_addRootsOutputs, i_outVars);
        l_addRootsOutputs = Tpl.popIter(l_addRootsOutputs);
        l_funArgs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_funArgs, l_varInits) = lm_396(l_funArgs, i_functionArguments, l_varInits);
        l_funArgs = Tpl.popIter(l_funArgs);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_397(l_bodyPart, i_body, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        l_outVarInits = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        l_outVarAssign = Tpl.emptyTxt;
        l_0___1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0___1, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls) = lm_398(l_0___1, i_outVars, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls, l_retVar);
        l_0___1 = Tpl.popIter(l_0___1);
        l_varDecls = addRootsTempArray(l_varDecls);
        ret_18 = Config.acceptMetaModelicaGrammar();
        l_boxedFn = fun_399(Tpl.emptyTxt, ret_18, i_fn);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_400(txt, i_functionArguments);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ") {\n",
                                    "  /* functionBodyRegularFunction: GC: save roots mark when you enter the function */\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_19 = Config.acceptMetaModelicaGrammar();
        txt = fun_401(txt, ret_19, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: GC: adding inputs as roots! */\n"));
        ret_20 = Config.acceptMetaModelicaGrammar();
        txt = fun_402(txt, ret_20, l_addRootsInputs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: arguments */\n"));
        txt = Tpl.writeText(txt, l_funArgs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: locals */\n"));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_tailrecursive:\n",
                                    "/* functionBodyRegularFunction: out inits */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_outVarInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: state in */\n"));
        ret_21 = Config.acceptMetaModelicaGrammar();
        txt = fun_403(txt, ret_21, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: var inits */\n"));
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: body */\n"));
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_return:\n",
                                    "/* functionBodyRegularFunction: out var copy */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_outVarCopy);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: state out */\n"));
        ret_22 = Config.acceptMetaModelicaGrammar();
        txt = fun_404(txt, ret_22, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* functionBodyRegularFunction: out var assign */\n"));
        txt = Tpl.writeText(txt, l_outVarAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* GC: pop the mark! */\n"));
        ret_23 = Config.acceptMetaModelicaGrammar();
        txt = fun_405(txt, ret_23);
        txt = Tpl.softNewLine(txt);
        ret_24 = Config.acceptParModelicaGrammar();
        txt = fun_406(txt, ret_24, l_varFrees);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* functionBodyRegularFunction: return the outs */\n",
                                    "return "
                                }, false));
        txt = fun_407(txt, i_outVars, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = fun_415(txt, a_inFunc, l_retType, i_outVars, i_functionArguments, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_boxedFn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionBodyRegularFunction;

protected function fun_417
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end matchcontinue;
end fun_417;

protected function fun_418
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_outVars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = outDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_418;

protected function fun_419
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_419;

protected function lm_420
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varFrees;
  input Tpl.Text in_a_outputAlloc;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_outputAlloc;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varFrees, out_a_outputAlloc, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varFrees, in_a_outputAlloc, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varFrees;
      Tpl.Text a_outputAlloc;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_varFrees,
           a_outputAlloc,
           a_varDecls,
           _ )
      then (txt, a_varFrees, a_outputAlloc, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_varFrees,
           a_outputAlloc,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outputAlloc, a_varFrees) = varInit(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outputAlloc, a_varFrees);
        txt = Tpl.nextIter(txt);
        (txt, a_varFrees, a_outputAlloc, a_varDecls) = lm_420(txt, rest, a_varFrees, a_outputAlloc, a_varDecls, a_retVar);
      then (txt, a_varFrees, a_outputAlloc, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varFrees,
           a_outputAlloc,
           a_varDecls,
           a_retVar )
      equation
        (txt, a_varFrees, a_outputAlloc, a_varDecls) = lm_420(txt, rest, a_varFrees, a_outputAlloc, a_varDecls, a_retVar);
      then (txt, a_varFrees, a_outputAlloc, a_varDecls);
  end matchcontinue;
end lm_420;

protected function fun_421
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function a_fn;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fn )
      equation
        txt = functionBodyBoxed(txt, a_fn);
      then txt;
  end matchcontinue;
end fun_421;

protected function lm_422
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.nextIter(txt);
        txt = lm_422(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_422(txt, rest);
      then txt;
  end matchcontinue;
end lm_422;

protected function fun_423
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;
  end matchcontinue;
end fun_423;

protected function fun_424
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end matchcontinue;
end fun_424;

protected function fun_425
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.writeText(txt, a_retVar);
      then txt;
  end matchcontinue;
end fun_425;

protected function fun_426
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ptrT_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=NULL;"));
      then txt;
  end matchcontinue;
end fun_426;

protected function lm_427
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_427(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_427(txt, rest);
      then txt;
  end matchcontinue;
end lm_427;

protected function fun_428
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" out;"));
      then txt;
  end matchcontinue;
end fun_428;

protected function lm_429
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_arg as SimCode.VARIABLE(name = _)) :: rest )
      equation
        txt = readInVar(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_429(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_429(txt, rest);
      then txt;
  end matchcontinue;
end lm_429;

protected function fun_430
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out = "));
      then txt;
  end matchcontinue;
end fun_430;

protected function lm_431
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.nextIter(txt);
        txt = lm_431(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_431(txt, rest);
      then txt;
  end matchcontinue;
end lm_431;

protected function lm_432
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = writeOutVar(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_432(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_432(txt, rest);
      then txt;
  end matchcontinue;
end lm_432;

protected function fun_433
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_noretcall(outVar);"));
      then txt;

    case ( txt,
           i_outVars )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_432(txt, i_outVars);
        txt = Tpl.popIter(txt);
      then txt;
  end matchcontinue;
end fun_433;

protected function fun_434
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input Tpl.Text in_a_retType;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_funArgs;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_inFunc, in_a_retType, in_a_outVars, in_a_funArgs, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_funArgs;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_retType,
           a_outVars,
           a_funArgs,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n",
                                    "  void* states = push_memory_states(1);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_427(txt, a_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_428(txt, a_outVars, a_retType);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_429(txt, a_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("MMC_TRY_TOP()\n"));
        txt = fun_430(txt, a_outVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_431(txt, a_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MMC_CATCH_TOP(return 1)\n"
                                }, true));
        txt = fun_433(txt, a_outVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fflush(NULL);\n",
                                    "pop_memory_states(states);\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end matchcontinue;
end fun_434;

public function functionBodyExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_efn;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_fnBody;
      Boolean ret_12;
      Tpl.Text l_boxedFn;
      Tpl.Text l_0__;
      Tpl.Text l_callPart;
      Boolean ret_8;
      Tpl.Text l_stateVar;
      Tpl.Text l_outputAlloc;
      Tpl.Text l_retVar;
      Tpl.Text l_varFrees;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_efn as SimCode.EXTERNAL_FUNCTION(name = i_name, outVars = i_outVars, funArgs = i_funArgs, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language)),
           a_inFunc )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_417(Tpl.emptyTxt, i_outVars, l_fname);
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_varFrees = Tpl.emptyTxt;
        (l_retVar, l_varDecls) = fun_418(Tpl.emptyTxt, i_outVars, l_varDecls, l_retType);
        l_outputAlloc = Tpl.emptyTxt;
        ret_8 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, l_varDecls) = fun_419(Tpl.emptyTxt, ret_8, l_varDecls);
        (l_callPart, l_preExp, l_varDecls) = extFunCall(Tpl.emptyTxt, i_efn, l_preExp, l_varDecls);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varFrees, l_outputAlloc, l_varDecls) = lm_420(l_0__, i_outVars, l_varFrees, l_outputAlloc, l_varDecls, l_retVar);
        l_0__ = Tpl.popIter(l_0__);
        ret_12 = Config.acceptMetaModelicaGrammar();
        l_boxedFn = fun_421(Tpl.emptyTxt, ret_12, i_efn);
        l_fnBody = Tpl.writeText(Tpl.emptyTxt, l_retType);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING(" _"));
        l_fnBody = Tpl.writeText(l_fnBody, l_fname);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("("));
        l_fnBody = Tpl.pushIter(l_fnBody, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_fnBody = lm_422(l_fnBody, i_funArgs);
        l_fnBody = Tpl.popIter(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              ")\n",
                                              "{\n",
                                              "  /* functionBodyExternalFunction: varDecls */\n"
                                          }, true));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(2));
        l_fnBody = Tpl.writeText(l_fnBody, l_varDecls);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = fun_423(l_fnBody, false, l_stateVar);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: preExp */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_preExp);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: outputAlloc */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_outputAlloc);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: callPart */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_callPart);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = fun_424(l_fnBody, false, l_stateVar);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              "/* functionBodyExternalFunction: return */\n",
                                              "return "
                                          }, false));
        l_fnBody = fun_425(l_fnBody, i_outVars, l_retVar);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE(";\n"));
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("}"));
        txt = fun_426(txt, i_dynamicLoad, i_language, i_extName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_fnBody);
        txt = Tpl.softNewLine(txt);
        txt = fun_434(txt, a_inFunc, l_retType, i_outVars, i_funArgs, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_boxedFn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end functionBodyExternalFunction;

protected function fun_436
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.Function a_fn;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fn )
      equation
        txt = functionBodyBoxed(txt, a_fn);
      then txt;
  end matchcontinue;
end fun_436;

protected function lm_437
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_437(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_437(txt, rest);
      then txt;
  end matchcontinue;
end lm_437;

protected function lm_438
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_structVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_structVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_structVar;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest,
           a_structVar )
      equation
        txt = Tpl.writeText(txt, a_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_438(txt, rest, a_structVar);
      then txt;

    case ( txt,
           _ :: rest,
           a_structVar )
      equation
        txt = lm_438(txt, rest, a_structVar);
      then txt;
  end matchcontinue;
end lm_438;

public function functionBodyRecordConstructor
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      Boolean ret_7;
      Tpl.Text l_boxedFn;
      Tpl.Text l_structVar;
      Tpl.Text l_structType;
      Tpl.Text l_retVar;
      Tpl.Text l_retType;
      Tpl.Text l_fname;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs)) )
      equation
        System.tmpTickReset(1);
        l_varDecls = Tpl.emptyTxt;
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_fname);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("_rettype"));
        (l_retVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), l_varDecls);
        l_structType = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("struct "));
        l_structType = Tpl.writeText(l_structType, l_fname);
        (l_structVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_structType), l_varDecls);
        ret_7 = Config.acceptMetaModelicaGrammar();
        l_boxedFn = fun_436(Tpl.emptyTxt, ret_7, i_fn);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_437(txt, i_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_438(txt, i_funArgs, l_structVar);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c1 = "));
        txt = Tpl.writeText(txt, l_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "return "
                                }, false));
        txt = Tpl.writeText(txt, l_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_boxedFn);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionBodyRecordConstructor;

protected function fun_440
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_functionArguments;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_outVars, in_a_functionArguments, in_a_name)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_functionArguments;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_outVars,
           a_functionArguments,
           a_name )
      equation
        txt = functionBodyBoxedImpl(txt, a_name, a_functionArguments, a_outVars);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_440;

protected function fun_441
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_funArgs;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_outVars, in_a_funArgs, in_a_name)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_funArgs;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_outVars,
           a_funArgs,
           a_name )
      equation
        txt = functionBodyBoxedImpl(txt, a_name, a_funArgs, a_outVars);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_441;

public function functionBodyBoxed
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      SimCode.Function i_fn;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars)) )
      equation
        ret_0 = SimCode.isBoxedFunction(i_fn);
        txt = fun_440(txt, ret_0, i_outVars, i_functionArguments, i_name);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name, funArgs = i_funArgs, outVars = i_outVars)) )
      equation
        ret_1 = SimCode.isBoxedFunction(i_fn);
        txt = fun_441(txt, ret_1, i_outVars, i_funArgs, i_name);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)) )
      equation
        txt = boxRecordConstructor(txt, i_fn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionBodyBoxed;

protected function fun_443
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outvars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype"));
      then txt;
  end matchcontinue;
end fun_443;

protected function fun_444
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outvars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxed"));
      then txt;
  end matchcontinue;
end fun_444;

protected function fun_445
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retTypeBoxed;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_outvars, in_a_varDecls, in_a_retTypeBoxed)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retTypeBoxed;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retTypeBoxed )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retTypeBoxed), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_445;

protected function fun_446
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_outvars, in_a_varDecls, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_retType;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_retType )
      equation
        (txt, a_varDecls) = tempDecl(txt, Tpl.textString(a_retType), a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_446;

protected function fun_447
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_447;

protected function lm_448
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varBox;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varBox;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varBox, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varBox, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varBox;
      Tpl.Text a_varDecls;
      SimCode.Variable i_arg;

    case ( txt,
           {},
           a_varBox,
           a_varDecls )
      then (txt, a_varBox, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varBox,
           a_varDecls )
      equation
        (txt, a_varDecls, a_varBox) = funArgUnbox(txt, i_arg, a_varDecls, a_varBox);
        txt = Tpl.nextIter(txt);
        (txt, a_varBox, a_varDecls) = lm_448(txt, rest, a_varBox, a_varDecls);
      then (txt, a_varBox, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varBox,
           a_varDecls )
      equation
        (txt, a_varBox, a_varDecls) = lm_448(txt, rest, a_varBox, a_varDecls);
      then (txt, a_varBox, a_varDecls);
  end matchcontinue;
end lm_448;

protected function lm_449
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varUnbox;
  input Tpl.Text in_a_retVar;
  input Tpl.Text in_a_funRetVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varUnbox;
algorithm
  (out_txt, out_a_varDecls, out_a_varUnbox) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_varUnbox, in_a_retVar, in_a_funRetVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varUnbox;
      Tpl.Text a_retVar;
      Tpl.Text a_funRetVar;
      Integer x_i1;
      DAE.Type i_ty;
      Tpl.Text l_arg;

    case ( txt,
           {},
           a_varDecls,
           a_varUnbox,
           _,
           _ )
      then (txt, a_varDecls, a_varUnbox);

    case ( txt,
           SimCode.VARIABLE(ty = i_ty) :: rest,
           a_varDecls,
           a_varUnbox,
           a_retVar,
           a_funRetVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_arg = Tpl.writeText(Tpl.emptyTxt, a_funRetVar);
        l_arg = Tpl.writeTok(l_arg, Tpl.ST_STRING(".c"));
        l_arg = Tpl.writeStr(l_arg, intString(x_i1));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        (txt, a_varUnbox, a_varDecls) = funArgBox(txt, Tpl.textString(l_arg), i_ty, a_varUnbox, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varUnbox) = lm_449(txt, rest, a_varDecls, a_varUnbox, a_retVar, a_funRetVar);
      then (txt, a_varDecls, a_varUnbox);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_varUnbox,
           a_retVar,
           a_funRetVar )
      equation
        (txt, a_varDecls, a_varUnbox) = lm_449(txt, rest, a_varDecls, a_varUnbox, a_retVar, a_funRetVar);
      then (txt, a_varDecls, a_varUnbox);
  end matchcontinue;
end lm_449;

protected function lm_450
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgBoxedDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_450(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_450(txt, rest);
      then txt;
  end matchcontinue;
end lm_450;

protected function fun_451
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_local_state_type mmc_GC_local_state = mmc_GC_save_roots_state(\"boxptr__"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
      then txt;
  end matchcontinue;
end fun_451;

protected function fun_452
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_452;

protected function fun_453
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outvars;
  input Tpl.Text in_a_funRetVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outvars, in_a_funRetVar)
    local
      Tpl.Text txt;
      Tpl.Text a_funRetVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_funRetVar )
      equation
        txt = Tpl.writeText(txt, a_funRetVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;
  end matchcontinue;
end fun_453;

protected function fun_454
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_454;

protected function fun_455
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_undo_roots_state(mmc_GC_local_state);"));
      then txt;
  end matchcontinue;
end fun_455;

public function functionBodyBoxedImpl
  input Tpl.Text txt;
  input Absyn.Path a_name;
  input list<SimCode.Variable> a_funargs;
  input list<SimCode.Variable> a_outvars;

  output Tpl.Text out_txt;
protected
  Boolean ret_15;
  Boolean ret_14;
  Boolean ret_13;
  Boolean ret_12;
  Tpl.Text l_retStr;
  Tpl.Text l_args;
  Tpl.Text l_varUnbox;
  Tpl.Text l_varBox;
  Boolean ret_7;
  Tpl.Text l_stateVar;
  Tpl.Text l_funRetVar;
  Tpl.Text l_retVar;
  Tpl.Text l_varDecls;
  Tpl.Text l_retTypeBoxed;
  Tpl.Text l_retType;
  Tpl.Text l_fname;
algorithm
  System.tmpTickReset(1);
  System.tmpTickResetIndex(0, 1);
  l_fname := underscorePath(Tpl.emptyTxt, a_name);
  l_retType := fun_443(Tpl.emptyTxt, a_outvars, l_fname);
  l_retTypeBoxed := fun_444(Tpl.emptyTxt, a_outvars, l_retType);
  l_varDecls := Tpl.emptyTxt;
  (l_retVar, l_varDecls) := fun_445(Tpl.emptyTxt, a_outvars, l_varDecls, l_retTypeBoxed);
  (l_funRetVar, l_varDecls) := fun_446(Tpl.emptyTxt, a_outvars, l_varDecls, l_retType);
  ret_7 := Config.acceptMetaModelicaGrammar();
  (l_stateVar, l_varDecls) := fun_447(Tpl.emptyTxt, ret_7, l_varDecls);
  l_varBox := Tpl.emptyTxt;
  l_varUnbox := Tpl.emptyTxt;
  l_args := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_args, l_varBox, l_varDecls) := lm_448(l_args, a_funargs, l_varBox, l_varDecls);
  l_args := Tpl.popIter(l_args);
  l_retStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_retStr, l_varDecls, l_varUnbox) := lm_449(l_retStr, a_outvars, l_varDecls, l_varUnbox, l_retVar, l_funRetVar);
  l_retStr := Tpl.popIter(l_retStr);
  out_txt := Tpl.writeText(txt, l_retTypeBoxed);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" boxptr_"));
  out_txt := Tpl.writeText(out_txt, l_fname);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("("));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_450(out_txt, a_funargs);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ") {\n",
                                       "  /* GC: save roots mark when you enter the function */\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_12 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_451(out_txt, ret_12, l_fname);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := addRootsTempArray(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  ret_13 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_452(out_txt, ret_13, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_varBox);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := fun_453(out_txt, a_outvars, l_funRetVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_"));
  out_txt := Tpl.writeText(out_txt, l_fname);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("("));
  out_txt := Tpl.writeText(out_txt, l_args);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(");\n"));
  out_txt := Tpl.writeText(out_txt, l_varUnbox);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_retStr);
  out_txt := Tpl.softNewLine(out_txt);
  ret_14 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_454(out_txt, ret_14, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* GC: pop roots mark when you exit the function */\n"));
  ret_15 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_455(out_txt, ret_15);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("return "));
  out_txt := Tpl.writeText(out_txt, l_retVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(";\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionBodyBoxedImpl;

protected function fun_457
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name) )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 3205, 17), "Unknown variable");
      then txt;
  end matchcontinue;
end fun_457;

protected function lm_458
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_457(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_458(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_458(txt, rest);
      then txt;
  end matchcontinue;
end lm_458;

protected function lm_459
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgBoxedDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_459(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_459(txt, rest);
      then txt;
  end matchcontinue;
end lm_459;

public function boxRecordConstructor
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> i_funArgs;
      Absyn.Path i_name;
      Integer ret_4;
      Integer ret_3;
      Tpl.Text l_funArgCount;
      Tpl.Text l_funArgsStr;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs) )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_funArgsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funArgsStr = lm_458(l_funArgsStr, i_funArgs);
        l_funArgsStr = Tpl.popIter(l_funArgsStr);
        ret_3 = listLength(i_funArgs);
        ret_4 = SimCode.incrementInt(ret_3, 1);
        l_funArgCount = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype boxptr_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_459(txt, i_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return mmc_mk_box"));
        txt = Tpl.writeText(txt, l_funArgCount);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(3, &"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc, "));
        txt = Tpl.writeText(txt, l_funArgsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end boxRecordConstructor;

public function funArgUnbox
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varBox;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varBox;
algorithm
  (out_txt, out_a_varDecls, out_a_varBox) :=
  matchcontinue(in_txt, in_a_var, in_a_varDecls, in_a_varBox)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varBox;
      String i_name_1;
      DAE.Type i_ty;
      DAE.ComponentRef i_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(name = i_name, ty = i_ty),
           a_varDecls,
           a_varBox )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_name, SimCode.contextFunction);
        (txt, a_varBox, a_varDecls) = unboxVariable(txt, Tpl.textString(l_varName), i_ty, a_varBox, a_varDecls);
      then (txt, a_varDecls, a_varBox);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_varDecls,
           a_varBox )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then (txt, a_varDecls, a_varBox);

    case ( txt,
           _,
           a_varDecls,
           a_varBox )
      then (txt, a_varDecls, a_varBox);
  end matchcontinue;
end funArgUnbox;

protected function fun_462
  input Tpl.Text in_txt;
  input DAE.Type in_a_varType;
  input String in_a_varName;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_varType, in_a_varName, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_varName;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type i_varType;
      Tpl.Text l_tmpVar;
      Tpl.Text l_ty;
      Tpl.Text l_shortType;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_METATYPE(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_METABOXED(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_varType as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _))),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = unboxRecord(txt, a_varName, i_varType, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_varType,
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        l_shortType = mmcTypeShort(Tpl.emptyTxt, i_varType);
        l_ty = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("modelica_"));
        l_ty = Tpl.writeText(l_ty, l_shortType);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ty), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmpVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = mmc_unbox_"));
        a_preExp = Tpl.writeText(a_preExp, l_shortType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeStr(a_preExp, a_varName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_462;

public function unboxVariable
  input Tpl.Text txt;
  input String a_varName;
  input DAE.Type a_varType;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_462(txt, a_varType, a_varName, a_preExp, a_varDecls);
end unboxVariable;

protected function lm_464
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_tmpVar;
  input String in_a_recordVar;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_tmpVar, in_a_recordVar, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_tmpVar;
      String a_recordVar;
      Tpl.Text a_varDecls;
      Integer x_offset;
      DAE.Ident i_compname;
      DAE.Type i_ty;
      Tpl.Text l_unboxStr;
      Tpl.Text l_unboxBuf;
      Tpl.Text l_untagTmp;
      Tpl.Text l_varType;

    case ( txt,
           {},
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           DAE.TYPES_VAR(name = i_compname, ty = i_ty) :: rest,
           a_tmpVar,
           a_recordVar,
           a_varDecls )
      equation
        x_offset = Tpl.getIteri_i0(txt);
        l_varType = mmcTypeShort(Tpl.emptyTxt, i_ty);
        (l_untagTmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_metatype", a_varDecls);
        l_unboxBuf = Tpl.emptyTxt;
        (l_unboxStr, l_unboxBuf, a_varDecls) = unboxVariable(Tpl.emptyTxt, Tpl.textString(l_untagTmp), i_ty, l_unboxBuf, a_varDecls);
        txt = Tpl.writeText(txt, l_untagTmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = (MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR("));
        txt = Tpl.writeStr(txt, a_recordVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), "));
        txt = Tpl.writeStr(txt, intString(x_offset));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")));\n"));
        txt = Tpl.writeText(txt, l_unboxBuf);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_tmpVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, i_compname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_unboxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_464(txt, rest, a_tmpVar, a_recordVar, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmpVar,
           a_recordVar,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_464(txt, rest, a_tmpVar, a_recordVar, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_464;

protected function fun_465
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input String in_a_recordVar;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_recordVar, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_recordVar;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Var> i_vars;
      Absyn.Path i_path;
      Tpl.Text txt_1;
      Tpl.Text l_tmpVar;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_path), varLst = i_vars),
           a_recordVar,
           a_preExp,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("struct "));
        txt_1 = underscorePath(txt_1, i_path);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        a_preExp = Tpl.pushIter(a_preExp, Tpl.ITER_OPTIONS(2, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (a_preExp, a_varDecls) = lm_464(a_preExp, i_vars, l_tmpVar, a_recordVar, a_varDecls);
        a_preExp = Tpl.popIter(a_preExp);
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_465;

public function unboxRecord
  input Tpl.Text txt;
  input String a_recordVar;
  input DAE.Type a_ty;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_465(txt, a_ty, a_recordVar, a_preExp, a_varDecls);
end unboxRecord;

protected function fun_467
  input Tpl.Text in_txt;
  input Tpl.Text in_a_constructorType;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varUnbox;
  input DAE.Type in_a_ty;
  input String in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varUnbox;
algorithm
  (out_txt, out_a_varDecls, out_a_varUnbox) :=
  matchcontinue(in_txt, in_a_constructorType, in_a_varDecls, in_a_varUnbox, in_a_ty, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varUnbox;
      DAE.Type a_ty;
      String a_varName;
      Tpl.Text i_constructorType;
      Tpl.Text l_tmpVar;
      Tpl.Text l_constructor;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_varDecls,
           a_varUnbox,
           _,
           a_varName )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_varDecls, a_varUnbox);

    case ( txt,
           i_constructorType,
           a_varDecls,
           a_varUnbox,
           a_ty,
           a_varName )
      equation
        (l_constructor, a_varUnbox, a_varDecls) = mmcConstructor(Tpl.emptyTxt, a_ty, a_varName, a_varUnbox, a_varDecls);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(i_constructorType), a_varDecls);
        a_varUnbox = Tpl.writeText(a_varUnbox, l_tmpVar);
        a_varUnbox = Tpl.writeTok(a_varUnbox, Tpl.ST_STRING(" = "));
        a_varUnbox = Tpl.writeText(a_varUnbox, l_constructor);
        a_varUnbox = Tpl.writeTok(a_varUnbox, Tpl.ST_STRING(";"));
        a_varUnbox = Tpl.writeTok(a_varUnbox, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_varDecls, a_varUnbox);
  end matchcontinue;
end fun_467;

public function funArgBox
  input Tpl.Text txt;
  input String a_varName;
  input DAE.Type a_ty;
  input Tpl.Text a_varUnbox;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varUnbox;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_constructorType;
algorithm
  l_constructorType := mmcConstructorType(Tpl.emptyTxt, a_ty);
  (out_txt, out_a_varDecls, out_a_varUnbox) := fun_467(txt, l_constructorType, a_varDecls, a_varUnbox, a_ty, a_varName);
end funArgBox;

public function mmcConstructorType
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end mmcConstructorType;

protected function lm_470
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input String in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_varName)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      String a_varName;
      DAE.Type i_ty;
      DAE.Ident i_name;
      Tpl.Text l_varname;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.TYPES_VAR(name = i_name, ty = i_ty) :: rest,
           a_varDecls,
           a_preExp,
           a_varName )
      equation
        l_varname = Tpl.writeStr(Tpl.emptyTxt, a_varName);
        l_varname = Tpl.writeTok(l_varname, Tpl.ST_STRING("."));
        l_varname = Tpl.writeStr(l_varname, i_name);
        (txt, a_preExp, a_varDecls) = funArgBox(txt, Tpl.textString(l_varname), i_ty, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_470(txt, rest, a_varDecls, a_preExp, a_varName);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_varName )
      equation
        (txt, a_varDecls, a_preExp) = lm_470(txt, rest, a_varDecls, a_preExp, a_varName);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_470;

public function mmcConstructor
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input String in_a_varName;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_type, in_a_varName, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_varName;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Absyn.Path i_path;
      list<DAE.Var> i_vars;
      Tpl.Text l_varsStr;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_varCount;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_icon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_icon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_rcon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_string("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_icon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_acon("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_path), varLst = i_vars),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        ret_1 = listLength(i_vars);
        ret_2 = SimCode.incrementInt(ret_1, 1);
        l_varCount = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_varsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varsStr, a_varDecls, a_preExp) = lm_470(l_varsStr, i_vars, a_varDecls, a_preExp, a_varName);
        l_varsStr = Tpl.popIter(l_varsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_box"));
        txt = Tpl.writeText(txt, l_varCount);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(3, &"));
        txt = underscorePath(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc, "));
        txt = Tpl.writeText(txt, l_varsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_COMPLEX(complexClassType = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_box("));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end mmcConstructor;

protected function fun_472
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char**)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_472;

public function readInVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      DAE.ComponentRef i_cr;
      DAE.Type i_ty;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.VARIABLE(name = i_cr, ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_modelica_record(&inArgs, "));
        txt_0 = contextCref(Tpl.emptyTxt, i_cr, SimCode.contextFunction);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(txt_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name, ty = (i_ty as DAE.T_STRING(varLst = _))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, "));
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_472(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end readInVar;

protected function fun_474
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           _,
           a_subvar_name,
           a_prefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&("));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_474;

protected function lm_475
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_prefix )
      equation
        txt = fun_474(txt, i_ty, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_475(txt, rest, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_prefix )
      equation
        txt = lm_475(txt, rest, a_prefix);
      then txt;
  end matchcontinue;
end lm_475;

public function readInVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_prefix)
    local
      Tpl.Text txt;
      String a_prefix;
      list<DAE.Var> i_vl;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl),
           a_prefix )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_475(txt, i_vl, a_prefix);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end readInVarRecordMembers;

public function writeOutVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.Variable i_var;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_modelica_record(outVar, "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, "");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_"));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(outVar, &out.c"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end writeOutVar;

protected function fun_478
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Integer in_a_index;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_index, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           i_ty,
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &(out.c"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end matchcontinue;
end fun_478;

protected function lm_479
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Integer a_index;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_index,
           a_prefix )
      equation
        txt = fun_478(txt, i_ty, a_index, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_479(txt, rest, a_index, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_index,
           a_prefix )
      equation
        txt = lm_479(txt, rest, a_index, a_prefix);
      then txt;
  end matchcontinue;
end lm_479;

protected function fun_480
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_args)
    local
      Tpl.Text txt;
      Tpl.Text i_args;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_args )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_args);
      then txt;
  end matchcontinue;
end fun_480;

public function writeOutVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      String a_prefix;
      list<DAE.Var> i_vl;
      ClassInf.State i_n;
      Tpl.Text l_args;
      Absyn.Path ret_1;
      Tpl.Text l_basename;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl, complexClassType = i_n),
           a_index,
           a_prefix )
      equation
        ret_1 = ClassInf.getStateName(i_n);
        l_basename = underscorePath(Tpl.emptyTxt, ret_1);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args = lm_479(l_args, i_vl, a_index, a_prefix);
        l_args = Tpl.popIter(l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_basename);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc"));
        txt = fun_480(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", TYPE_DESC_NONE"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end writeOutVarRecordMembers;

protected function fun_482
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "modelica_metatype" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = NULL"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_482;

protected function fun_483
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           "modelica_metatype",
           a_varName )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_483;

protected function fun_484
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Tpl.Text in_a_addRoot;
  input Tpl.Text in_a_initVar;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_typ;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outStruct, in_a_addRoot, in_a_initVar, in_a_varName, in_a_typ)
    local
      Tpl.Text txt;
      Tpl.Text a_addRoot;
      Tpl.Text a_initVar;
      Tpl.Text a_varName;
      Tpl.Text a_typ;

    case ( txt,
           "",
           a_addRoot,
           a_initVar,
           a_varName,
           a_typ )
      equation
        txt = Tpl.writeText(txt, a_typ);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeText(txt, a_initVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_addRoot);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_484;

protected function fun_485
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Integer in_a_i;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outStruct, in_a_i, in_a_var_name)
    local
      Tpl.Text txt;
      Integer a_i;
      DAE.ComponentRef a_var_name;
      String i_outStruct;

    case ( txt,
           "",
           _,
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_outStruct,
           a_i,
           _ )
      equation
        txt = Tpl.writeStr(txt, i_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c"));
        txt = Tpl.writeStr(txt, intString(a_i));
      then txt;
  end matchcontinue;
end fun_485;

protected function lm_486
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_486(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = lm_486(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end lm_486;

protected function fun_487
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var_value, in_a_varDecls, in_a_varInits, in_a_var_name)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_varInits,
           a_var_name )
      equation
        l_defaultValue = contextCref(Tpl.emptyTxt, a_var_name, SimCode.contextFunction);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(" = "));
        (l_defaultValue, a_varInits, a_varDecls) = daeExp(l_defaultValue, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(";"));
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_487;

protected function fun_488
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outStruct, in_a_var_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;

    case ( txt,
           "",
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction);
      then txt;

    case ( txt,
           _,
           a_var_name )
      equation
        txt = extVarName(txt, a_var_name);
      then txt;
  end matchcontinue;
end fun_488;

protected function fun_489
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var_value, in_a_var_name, in_a_varDecls, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_instDims, in_a_varName, in_a_var_ty, in_a_varInits)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varDecls;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      list<DAE.Exp> a_instDims;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;
      Integer ret_4;
      Tpl.Text l_defaultValue1;
      Tpl.Text l_var__name;
      Tpl.Text l_defaultValue;
      Integer ret_0;

    case ( txt,
           SOME(i_exp),
           a_var_name,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_var_ty,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(a_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        l_var__name = fun_488(Tpl.emptyTxt, a_outStruct, a_var_name);
        l_defaultValue1 = Tpl.writeText(Tpl.emptyTxt, l_var__name);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(" = "));
        (l_defaultValue1, a_varInits, a_varDecls) = daeExp(l_defaultValue1, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(";"));
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_instDims,
           a_varName,
           a_var_ty,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_4 = listLength(a_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_4));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_489;

protected function fun_490
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input DAE.ComponentRef in_a_var_name;
  input Option<DAE.Exp> in_a_var_value;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_instDims, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varName, in_a_var_ty, in_a_varDecls, in_a_varInits, in_a_var_name, in_a_var_value)
    local
      Tpl.Text txt;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.ComponentRef a_var_name;
      Option<DAE.Exp> a_var_value;
      list<DAE.Exp> i_instDims;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_487(txt, a_var_value, a_varDecls, a_varInits, a_var_name);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_instDims,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_var_ty,
           a_varDecls,
           a_varInits,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_489(txt, a_var_value, a_var_name, a_varDecls, a_i, a_outStruct, a_var, a_instDimsInit, i_instDims, a_varName, a_var_ty, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_490;

public function varInit
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varFrees;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varFrees;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varFrees) :=
  matchcontinue(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_varDecls, in_a_varInits, in_a_varFrees)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varFrees;
      DAE.Type i_var_ty;
      Option<DAE.Exp> i_var_value;
      list<DAE.Exp> i_instDims;
      SimCode.Variable i_var;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_ignore;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName_1;
      String str_5;
      Tpl.Text l_addRoot;
      String str_3;
      Tpl.Text l_initVar;
      Tpl.Text l_typ;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(parallelism = DAE.NON_PARALLEL(), name = i_var_name, instDims = i_instDims, value = i_var_value, ty = i_var_ty)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        l_typ = varType(Tpl.emptyTxt, i_var);
        str_3 = Tpl.textString(l_typ);
        l_initVar = fun_482(Tpl.emptyTxt, str_3);
        str_5 = Tpl.textString(l_typ);
        l_addRoot = fun_483(Tpl.emptyTxt, str_5, l_varName);
        a_varDecls = fun_484(a_varDecls, a_outStruct, l_addRoot, l_initVar, l_varName, l_typ);
        l_varName_1 = fun_485(Tpl.emptyTxt, a_outStruct, a_i, i_var_name);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_486(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varDecls, a_varInits) = fun_490(txt, i_instDims, a_i, a_outStruct, i_var, l_instDimsInit, l_varName_1, i_var_ty, a_varDecls, a_varInits, i_var_name, i_var_value);
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        (txt, a_varDecls, a_varInits, a_varFrees) = parVarInit(txt, i_var, a_outStruct, a_i, a_varDecls, a_varInits, a_varFrees);
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           (i_var as SimCode.FUNCTION_PTR(name = _)),
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        l_ignore = Tpl.emptyTxt;
        (a_varDecls, l_ignore) = functionArg(a_varDecls, i_var, l_ignore);
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 3420, 12), "Unknown local variable type");
      then (txt, a_varDecls, a_varInits, a_varFrees);
  end matchcontinue;
end varInit;

protected function lm_492
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_492(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = lm_492(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end lm_492;

protected function fun_493
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varFrees;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varFrees, out_a_varInits, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_instDims, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varFrees, in_a_varInits, in_a_varName, in_a_var_ty, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varFrees;
      Tpl.Text a_varInits;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_instDims;
      Tpl.Text l_defaultValue;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           a_varFrees,
           a_varInits,
           a_varName,
           a_var_ty,
           a_varDecls )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("device_"));
        a_varDecls = expTypeShort(a_varDecls, a_var_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = Tpl.writeText(a_varDecls, a_varName);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(" = ocl_device_alloc(sizeof(modelica_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("));"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varFrees = Tpl.writeTok(a_varFrees, Tpl.ST_STRING("clReleaseMemObject("));
        a_varFrees = Tpl.writeText(a_varFrees, a_varName);
        a_varFrees = Tpl.writeTok(a_varFrees, Tpl.ST_STRING(");"));
        a_varFrees = Tpl.writeTok(a_varFrees, Tpl.ST_NEW_LINE());
      then (txt, a_varFrees, a_varInits, a_varDecls);

    case ( txt,
           i_instDims,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varFrees,
           a_varInits,
           a_varName,
           a_var_ty,
           a_varDecls )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("device_"));
        a_varDecls = expTypeShort(a_varDecls, a_var_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("_array "));
        a_varDecls = Tpl.writeText(a_varDecls, a_varName);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeText(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        a_varFrees = Tpl.writeTok(a_varFrees, Tpl.ST_STRING("free_device_array(&"));
        a_varFrees = Tpl.writeText(a_varFrees, a_varName);
        a_varFrees = Tpl.writeTok(a_varFrees, Tpl.ST_STRING(");"));
        a_varFrees = Tpl.writeTok(a_varFrees, Tpl.ST_NEW_LINE());
      then (txt, a_varFrees, a_varInits, a_varDecls);
  end matchcontinue;
end fun_493;

public function parVarInit
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varFrees;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varFrees;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varFrees) :=
  matchcontinue(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_varDecls, in_a_varInits, in_a_varFrees)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varFrees;
      SimCode.Variable i_var;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(parallelism = DAE.PARGLOBAL(), name = i_var_name, instDims = i_instDims, ty = i_var_ty)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_492(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varFrees, a_varInits, a_varDecls) = fun_493(txt, i_instDims, a_i, a_outStruct, i_var, l_instDimsInit, a_varFrees, a_varInits, l_varName, i_var_ty, a_varDecls);
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           SimCode.VARIABLE(parallelism = DAE.PARLOCAL()),
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("#PARLOCAL variable type should not be allowed here. FIXME!!"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits, a_varFrees);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varFrees )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("#error Unknown parallel variable type"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits, a_varFrees);
  end matchcontinue;
end parVarInit;

protected function fun_495
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_value;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Integer in_a_i;
  input String in_a_outStruct;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_value, in_a_lhsVarName, in_a_varDecls, in_a_varInits, in_a_i, in_a_outStruct, in_a_var_ty)
    local
      Tpl.Text txt;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Integer a_i;
      String a_outStruct;
      DAE.Type a_var_ty;
      DAE.Exp i_arr;
      DAE.ComponentRef i_cr;
      Tpl.Text l_arrayExp;

    case ( txt,
           SOME(DAE.CREF(componentRef = i_cr)),
           _,
           a_varDecls,
           a_varInits,
           a_i,
           a_outStruct,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data(&"));
        txt = contextCref(txt, i_cr, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c"));
        txt = Tpl.writeStr(txt, intString(a_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           SOME((i_arr as DAE.ARRAY(ty = _))),
           a_lhsVarName,
           a_varDecls,
           a_varInits,
           _,
           _,
           a_var_ty )
      equation
        (l_arrayExp, a_varInits, a_varDecls) = daeExp(Tpl.emptyTxt, i_arr, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data(&"));
        txt = Tpl.writeText(txt, l_arrayExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_lhsVarName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_varInits,
           _,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end fun_495;

public function varDefaultValue
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_lhsVarName, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Type i_var_ty;
      Option<DAE.Exp> i_value;

    case ( txt,
           SimCode.VARIABLE(value = i_value, ty = i_var_ty),
           a_outStruct,
           a_i,
           a_lhsVarName,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = fun_495(txt, i_value, a_lhsVarName, a_varDecls, a_varInits, a_i, a_outStruct, i_var_ty);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end varDefaultValue;

protected function lm_497
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = mmcVarType(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_497(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_497(txt, rest);
      then txt;
  end matchcontinue;
end lm_497;

protected function lm_498
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      Integer x_i1;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ty :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_498(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_498(txt, rest);
      then txt;
  end matchcontinue;
end lm_498;

protected function fun_499
  input Tpl.Text in_txt;
  input list<DAE.Type> in_a_tys;
  input Tpl.Text in_a_rettype;
  input Tpl.Text in_a_typelist;
  input String in_a_name;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  matchcontinue(in_txt, in_a_tys, in_a_rettype, in_a_typelist, in_a_name, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_rettype;
      Tpl.Text a_typelist;
      String a_name;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;

    case ( txt,
           {},
           _,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = (void(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);

    case ( txt,
           i_tys,
           a_rettype,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = ("));
        a_varInit = Tpl.writeText(a_varInit, a_rettype);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_498(txt, i_tys);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);
  end matchcontinue;
end fun_499;

public function functionArg
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  matchcontinue(in_txt, in_a_var, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;
      String i_name;
      list<SimCode.Variable> i_args;
      Tpl.Text l_rettype;
      Tpl.Text l_typelist;

    case ( txt,
           SimCode.FUNCTION_PTR(args = i_args, name = i_name, tys = i_tys),
           a_varInit )
      equation
        l_typelist = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_typelist = lm_497(l_typelist, i_args);
        l_typelist = Tpl.popIter(l_typelist);
        l_rettype = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_rettype = Tpl.writeTok(l_rettype, Tpl.ST_STRING("_rettype"));
        (txt, a_varInit) = fun_499(txt, i_tys, l_rettype, l_typelist, i_name, a_varInit);
      then (txt, a_varInit);

    case ( txt,
           _,
           a_varInit )
      then (txt, a_varInit);
  end matchcontinue;
end functionArg;

protected function lm_501
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_501(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = lm_501(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end lm_501;

protected function fun_502
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varInits;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign, out_a_varCopy, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_instDims, in_a_var_ty, in_a_varInits, in_a_ix, in_a_dest, in_a_varAssign, in_a_var_name, in_a_varCopy, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      Tpl.Text a_varInits;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varCopy;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_instDims;
      Integer ret_5;
      Tpl.Text l_destTarget;
      Tpl.Text l_sz;
      Tpl.Text l_loopVar;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_strVar;

    case ( txt,
           {},
           _,
           a_varInits,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_string_t", a_varDecls);
        a_varCopy = Tpl.writeText(a_varCopy, l_strVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(" = strdup("));
        a_varCopy = contextCref(a_varCopy, a_var_name, SimCode.contextFunction);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(");"));
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = init_modelica_string("));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING_LIST({
                                                    ");\n",
                                                    "free("
                                                }, false));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           i_instDims,
           a_var_ty,
           a_varInits,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_name,
           a_varCopy,
           a_varDecls )
      equation
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_501(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (l_loopVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "long", a_varDecls);
        (l_sz, a_varDecls) = tempDecl(Tpl.emptyTxt, "long", a_varDecls);
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_string_t *", a_varDecls);
        a_varCopy = Tpl.writeText(a_varCopy, l_sz);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(" = base_array_nr_of_elements(&"));
        a_varCopy = contextCref(a_varCopy, a_var_name, SimCode.contextFunction);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(");"));
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_NEW_LINE());
        a_varCopy = Tpl.writeText(a_varCopy, l_strVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(" = (modelica_string_t*) malloc("));
        a_varCopy = Tpl.writeText(a_varCopy, l_sz);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING_LIST({
                                                "*sizeof(modelica_string_t));\n",
                                                "for ("
                                            }, false));
        a_varCopy = Tpl.writeText(a_varCopy, l_loopVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING("=0;"));
        a_varCopy = Tpl.writeText(a_varCopy, l_loopVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING("<"));
        a_varCopy = Tpl.writeText(a_varCopy, l_sz);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(";"));
        a_varCopy = Tpl.writeText(a_varCopy, l_loopVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_LINE("++) {\n"));
        a_varCopy = Tpl.pushBlock(a_varCopy, Tpl.BT_INDENT(2));
        a_varCopy = Tpl.writeText(a_varCopy, l_strVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING("["));
        a_varCopy = Tpl.writeText(a_varCopy, l_loopVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING("] = strdup(string_get(&"));
        a_varCopy = contextCref(a_varCopy, a_var_name, SimCode.contextFunction);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING(","));
        a_varCopy = Tpl.writeText(a_varCopy, l_loopVar);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_STRING("));"));
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_NEW_LINE());
        a_varCopy = Tpl.popBlock(a_varCopy);
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_LINE("}\n"));
        a_varCopy = Tpl.writeTok(a_varCopy, Tpl.ST_NEW_LINE());
        l_destTarget = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(&"));
        l_destTarget = Tpl.writeStr(l_destTarget, a_dest);
        l_destTarget = Tpl.writeTok(l_destTarget, Tpl.ST_STRING(".c"));
        l_destTarget = Tpl.writeStr(l_destTarget, intString(a_ix));
        l_destTarget = Tpl.writeTok(l_destTarget, Tpl.ST_STRING(")"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array("));
        a_varInits = Tpl.writeText(a_varInits, l_destTarget);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_5 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_5));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, l_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("for ("));
        a_varAssign = Tpl.writeText(a_varAssign, l_loopVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("=0;"));
        a_varAssign = Tpl.writeText(a_varAssign, l_loopVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("<"));
        a_varAssign = Tpl.writeText(a_varAssign, l_sz);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeText(a_varAssign, l_loopVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_LINE("++) {\n"));
        a_varAssign = Tpl.pushBlock(a_varAssign, Tpl.BT_INDENT(2));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("((modelica_string_t*) "));
        a_varAssign = Tpl.writeText(a_varAssign, l_destTarget);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("->data)["));
        a_varAssign = Tpl.writeText(a_varAssign, l_loopVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("] = init_modelica_string("));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("["));
        a_varAssign = Tpl.writeText(a_varAssign, l_loopVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING_LIST({
                                                    "]);\n",
                                                    "free("
                                                }, false));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("["));
        a_varAssign = Tpl.writeText(a_varAssign, l_loopVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("]);"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.popBlock(a_varAssign);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING_LIST({
                                                    "}\n",
                                                    "free("
                                                }, false));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);
  end matchcontinue;
end fun_502;

protected function fun_503
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_varInits;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varDecls;
  input list<DAE.Exp> in_a_instDims;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign, out_a_varCopy, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_var_ty, in_a_varInits, in_a_ix, in_a_dest, in_a_varAssign, in_a_var_name, in_a_varCopy, in_a_varDecls, in_a_instDims)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      Tpl.Text a_varInits;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_varCopy;
      Tpl.Text a_varDecls;
      list<DAE.Exp> a_instDims;

    case ( txt,
           false,
           a_var_ty,
           a_varInits,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_name,
           a_varCopy,
           a_varDecls,
           a_instDims )
      equation
        (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls) = fun_502(txt, a_instDims, a_var_ty, a_varInits, a_ix, a_dest, a_varAssign, a_var_name, a_varCopy, a_varDecls);
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           a_ix,
           a_dest,
           a_varAssign,
           a_var_name,
           a_varCopy,
           a_varDecls,
           _ )
      equation
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls);
  end matchcontinue;
end fun_503;

protected function lm_504
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_504(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varDecls, a_varInits) = lm_504(txt, rest, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end matchcontinue;
end lm_504;

protected function fun_505
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;
  input DAE.ComponentRef in_a_var_name;
  input Integer in_a_ix;
  input String in_a_dest;
  input Tpl.Text in_a_varAssign;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varAssign, out_a_varInits) :=
  matchcontinue(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_ty, in_a_var_name, in_a_ix, in_a_dest, in_a_varAssign, in_a_var, in_a_varInits)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      DAE.ComponentRef a_var_name;
      Integer a_ix;
      String a_dest;
      Tpl.Text a_varAssign;
      SimCode.Variable a_var;
      Tpl.Text a_varInits;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           a_var,
           a_varInits )
      equation
        a_varInits = initRecordMembers(a_varInits, a_var);
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_ty,
           a_var_name,
           a_ix,
           a_dest,
           a_varAssign,
           _,
           a_varInits )
      equation
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("alloc_"));
        a_varInits = expTypeShort(a_varInits, a_var_ty);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("_array(&"));
        a_varInits = Tpl.writeStr(a_varInits, a_dest);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".c"));
        a_varInits = Tpl.writeStr(a_varInits, intString(a_ix));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        ret_0 = listLength(i_instDims);
        a_varInits = Tpl.writeStr(a_varInits, intString(ret_0));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(", "));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");"));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("copy_"));
        a_varAssign = expTypeShort(a_varAssign, a_var_ty);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("_array_data(&"));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(", &"));
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varInits);
  end matchcontinue;
end fun_505;

public function varOutput
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_dest;
  input Integer in_a_ix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varCopy, out_a_varAssign) :=
  matchcontinue(in_txt, in_a_var, in_a_dest, in_a_ix, in_a_varDecls, in_a_varInits, in_a_varCopy, in_a_varAssign)
    local
      Tpl.Text txt;
      String a_dest;
      Integer a_ix;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varCopy;
      Tpl.Text a_varAssign;
      String i_var_name_1;
      SimCode.Variable i_var;
      DAE.Type i_var_ty;
      DAE.ComponentRef i_var_name;
      list<DAE.Exp> i_instDims;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_marker;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = (i_var_ty as DAE.T_STRING(varLst = _)), instDims = i_instDims, name = i_var_name),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varInits, a_varAssign, a_varCopy, a_varDecls) = fun_503(txt, ret_0, i_var_ty, a_varInits, a_ix, a_dest, a_varAssign, i_var_name, a_varCopy, a_varDecls, i_instDims);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty)),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        l_marker = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_504(l_instDimsInit, i_instDims, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_varAssign, a_varInits) = fun_505(txt, i_instDims, l_instDimsInit, i_var_ty, i_var_name, a_ix, a_dest, a_varAssign, i_var, a_varInits);
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           a_dest,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeStr(a_varAssign, a_dest);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(".c"));
        a_varAssign = Tpl.writeStr(a_varAssign, intString(a_ix));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = (modelica_fnptr) _"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varCopy,
           a_varAssign )
      then (txt, a_varDecls, a_varInits, a_varCopy, a_varAssign);
  end matchcontinue;
end varOutput;

protected function lm_507
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varName;
algorithm
  (out_txt, out_a_varName) :=
  matchcontinue(in_txt, in_items, in_a_varName)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_varName;
      DAE.Var i_v;

    case ( txt,
           {},
           a_varName )
      then (txt, a_varName);

    case ( txt,
           i_v :: rest,
           a_varName )
      equation
        (txt, a_varName) = recordMemberInit(txt, i_v, a_varName);
        txt = Tpl.nextIter(txt);
        (txt, a_varName) = lm_507(txt, rest, a_varName);
      then (txt, a_varName);

    case ( txt,
           _ :: rest,
           a_varName )
      equation
        (txt, a_varName) = lm_507(txt, rest, a_varName);
      then (txt, a_varName);
  end matchcontinue;
end lm_507;

public function initRecordMembers
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var)
    local
      Tpl.Text txt;
      list<DAE.Var> i_ty_varLst;
      DAE.ComponentRef i_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _), varLst = i_ty_varLst), name = i_name) )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_name, SimCode.contextFunction);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varName) = lm_507(txt, i_ty_varLst, l_varName);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end initRecordMembers;

protected function lm_509
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_509(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_509(txt, rest);
      then txt;
  end matchcontinue;
end lm_509;

protected function fun_510
  input Tpl.Text in_txt;
  input DAE.Var in_a_v;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_v, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      DAE.Ident i_name;
      DAE.Dimensions i_ty_dims;
      DAE.Type i_ty;
      Integer ret_2;
      Tpl.Text l_dims;
      Tpl.Text l_arrayType;

    case ( txt,
           DAE.TYPES_VAR(ty = (i_ty as DAE.T_ARRAY(dims = i_ty_dims)), name = i_name),
           a_varName )
      equation
        l_arrayType = expType(Tpl.emptyTxt, i_ty, true);
        l_dims = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dims = lm_509(l_dims, i_ty_dims);
        l_dims = Tpl.popIter(l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("alloc_"));
        txt = Tpl.writeText(txt, l_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        ret_2 = listLength(i_ty_dims);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_510;

public function recordMemberInit
  input Tpl.Text txt;
  input DAE.Var a_v;
  input Tpl.Text a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varName;
algorithm
  out_txt := fun_510(txt, a_v, a_varName);
  out_a_varName := a_varName;
end recordMemberInit;

public function extVarName
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := contextCref(txt, a_cr, SimCode.contextFunction);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_ext"));
end extVarName;

protected function fun_513
  input Tpl.Text in_txt;
  input String in_a_language;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Function in_a_fun;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_language, in_a_varDecls, in_a_preExp, in_a_fun)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Function a_fun;

    case ( txt,
           "C",
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallC(txt, a_fun, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           "FORTRAN 77",
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallF77(txt, a_fun, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_513;

public function extFunCall
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.Function i_fun;
      String i_language;

    case ( txt,
           (i_fun as SimCode.EXTERNAL_FUNCTION(language = i_language)),
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_513(txt, i_language, a_varDecls, a_preExp, i_fun);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCall;

protected function lm_515
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_arg, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_515(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_515(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_515;

protected function fun_516
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;

    case ( txt,
           false,
           _,
           a_extName )
      equation
        txt = Tpl.writeStr(txt, a_extName);
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ptr_"));
        txt = extFunctionName(txt, a_extName, a_language);
      then txt;
  end matchcontinue;
end fun_516;

protected function fun_517
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName, in_a_fname)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("==NULL) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE(\"dynamic external function "));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" not set!\")\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} else"));
      then txt;
  end matchcontinue;
end fun_517;

protected function lm_518
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArg(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_518(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_518(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_518;

protected function fun_519
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_519;

protected function fun_520
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extReturn, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_extReturn, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_520;

protected function lm_521
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunCallVarcopy(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_521(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_521(txt, rest);
      then txt;
  end matchcontinue;
end lm_521;

protected function fun_522
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)) )
      equation
        txt = extFunCallVarcopy(txt, i_extReturn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_522;

public function extFunCallC
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;
      Tpl.Text l_dynamicCheck;
      Tpl.Text l_fname;
      list<SimCode.SimExtArg> ret_1;
      Tpl.Text l_varDecs;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language, extReturn = i_extReturn),
           a_preExp,
           a_varDecls )
      equation
        ret_1 = List.union(i_extArgs, i_extArgs);
        l_varDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varDecs, a_varDecls) = lm_515(l_varDecs, ret_1, a_varDecls);
        l_varDecs = Tpl.popIter(l_varDecs);
        l_fname = fun_516(Tpl.emptyTxt, i_dynamicLoad, i_language, i_extName);
        l_dynamicCheck = fun_517(Tpl.emptyTxt, i_dynamicLoad, i_language, i_extName, l_fname);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_518(l_args, i_extArgs, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_519(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeText(txt, l_varDecs);
        txt = Tpl.softNewLine(txt);
        (txt, a_varDecls) = fun_520(txt, i_extReturn, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_dynamicCheck);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_521(txt, i_extArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_522(txt, i_extReturn);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCallC;

protected function lm_524
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardeclF77(txt, i_arg, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_524(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_524(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_524;

protected function lm_525
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Variable i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extFunCallBiVarF77(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_525(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_525(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_525;

protected function lm_526
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = extArgF77(txt, i_arg, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_526(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_526(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_526;

protected function fun_527
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_527;

protected function fun_528
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extReturn, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardeclF77(txt, i_extReturn, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_528;

protected function lm_529
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunCallVarcopyF77(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_529(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_529(txt, rest);
      then txt;
  end matchcontinue;
end lm_529;

protected function fun_530
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)) )
      equation
        txt = extFunCallVarcopyF77(txt, i_extReturn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_530;

public function extFunCallF77
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_fun, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      String i_extName;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.Variable> i_biVars;
      list<SimCode.SimExtArg> i_extArgs;
      list<SimCode.SimExtArg> ret_5;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;
      Tpl.Text l_biVarDecs;
      list<SimCode.SimExtArg> ret_1;
      Tpl.Text l_varDecs;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, biVars = i_biVars, extReturn = i_extReturn, extName = i_extName),
           a_preExp,
           a_varDecls )
      equation
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("/* extFunCallF77: varDecs */"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        ret_1 = List.union(i_extArgs, i_extArgs);
        l_varDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varDecs, a_varDecls) = lm_524(l_varDecs, ret_1, a_varDecls);
        l_varDecs = Tpl.popIter(l_varDecs);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("/* extFunCallF77: biVarDecs */"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("/* extFunCallF77: biVarDecs */"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        l_biVarDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_biVarDecs, a_varDecls, a_preExp) = lm_525(l_biVarDecs, i_biVars, a_varDecls, a_preExp);
        l_biVarDecs = Tpl.popIter(l_biVarDecs);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("/* extFunCallF77: args */"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("/* extFunCallF77: args */"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_varDecls, a_preExp) = lm_526(l_args, i_extArgs, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_527(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeText(txt, l_varDecs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_biVarDecs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extFunCallF77: extReturn */\n"));
        (txt, a_varDecls) = fun_528(txt, i_extReturn, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extFunCallF77: CALL */\n"));
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_("));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "/* extFunCallF77: copy args */\n"
                                }, true));
        ret_5 = List.union(i_extArgs, i_extArgs);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_529(txt, ret_5);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extFunCallF77: copy return */\n"));
        txt = fun_530(txt, i_extReturn);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCallF77;

protected function fun_532
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_c, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_ty,
           a_c,
           a_varDecls )
      equation
        a_varDecls = extType(a_varDecls, i_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = extVarName(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = extType(txt, i_ty, true, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = contextCref(txt, a_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_532;

protected function fun_533
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_oi, in_a_c, in_a_ty, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      DAE.Type a_ty;
      Tpl.Text a_varDecls;

    case ( txt,
           0,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_c,
           a_ty,
           a_varDecls )
      equation
        a_varDecls = extType(a_varDecls, a_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);
  end matchcontinue;
end fun_533;

public function extFunCallVardecl
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_arg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.Type i_ty;

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_532(txt, i_ty, i_c, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_533(txt, i_oi, i_c, i_ty, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end extFunCallVardecl;

protected function fun_535
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_default__val;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_default__val)
    local
      Tpl.Text txt;
      Tpl.Text a_default__val;

    case ( txt,
           "",
           _ )
      then txt;

    case ( txt,
           _,
           a_default__val )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("= "));
        txt = Tpl.writeText(txt, a_default__val);
        txt = Tpl.popBlock(txt);
      then txt;
  end matchcontinue;
end fun_535;

protected function fun_536
  input Tpl.Text in_txt;
  input Boolean in_a_ea_hasBinding;
  input Tpl.Text in_a_default__val;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ea_hasBinding, in_a_default__val)
    local
      Tpl.Text txt;
      Tpl.Text a_default__val;
      String str_0;

    case ( txt,
           false,
           a_default__val )
      equation
        str_0 = Tpl.textString(a_default__val);
        txt = fun_535(txt, str_0, a_default__val);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_536;

protected function fun_537
  input Tpl.Text in_txt;
  input Boolean in_a_ea_hasBinding;
  input DAE.ComponentRef in_a_c;
  input Integer in_a_oi;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ea_hasBinding, in_a_c, in_a_oi, in_a_ty)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer a_oi;
      DAE.Type a_ty;

    case ( txt,
           false,
           a_c,
           a_oi,
           a_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("convert_alloc_"));
        txt = expTypeArray(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_to_f77(&out.c"));
        txt = Tpl.writeStr(txt, intString(a_oi));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = extVarName(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_537;

protected function fun_538
  input Tpl.Text in_txt;
  input Boolean in_a_ia;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;
  input Boolean in_a_ea_hasBinding;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ia, in_a_oi, in_a_c, in_a_varDecls, in_a_ea_hasBinding, in_a_ty)
    local
      Tpl.Text txt;
      Integer a_oi;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      Boolean a_ea_hasBinding;
      DAE.Type a_ty;
      Tpl.Text l_default__exp;
      Tpl.Text l_default__val;

    case ( txt,
           false,
           _,
           a_c,
           a_varDecls,
           a_ea_hasBinding,
           a_ty )
      equation
        l_default__val = typeDefaultValue(Tpl.emptyTxt, a_ty);
        l_default__exp = fun_536(Tpl.emptyTxt, a_ea_hasBinding, l_default__val);
        a_varDecls = extTypeF77(a_varDecls, a_ty, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeText(a_varDecls, l_default__exp);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_oi,
           a_c,
           a_varDecls,
           a_ea_hasBinding,
           a_ty )
      equation
        a_varDecls = expTypeArrayIf(a_varDecls, a_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = fun_537(txt, a_ea_hasBinding, a_c, a_oi, a_ty);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_538;

protected function fun_539
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;
  input Boolean in_a_ea_hasBinding;
  input DAE.Type in_a_ty;
  input Boolean in_a_ia;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_oi, in_a_c, in_a_varDecls, in_a_ea_hasBinding, in_a_ty, in_a_ia)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      Boolean a_ea_hasBinding;
      DAE.Type a_ty;
      Boolean a_ia;
      Integer i_oi;

    case ( txt,
           0,
           _,
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_oi,
           a_c,
           a_varDecls,
           a_ea_hasBinding,
           a_ty,
           a_ia )
      equation
        (txt, a_varDecls) = fun_538(txt, a_ia, i_oi, a_c, a_varDecls, a_ea_hasBinding, a_ty);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_539;

public function extFunCallVardeclF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_arg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Boolean i_ea_hasBinding;
      Boolean i_ia;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.Type i_ty;

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = true, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        a_varDecls = expTypeArrayIf(a_varDecls, i_ty);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, i_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("convert_alloc_"));
        txt = expTypeArray(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_to_f77(&"));
        txt = contextCref(txt, i_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = i_ia, type_ = i_ty, cref = i_c, hasBinding = i_ea_hasBinding),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_539(txt, i_oi, i_c, a_varDecls, i_ea_hasBinding, i_ty, i_ia);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        a_varDecls = extTypeF77(a_varDecls, i_ty, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, i_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end extFunCallVardeclF77;

public function typeDefaultValue
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0.0"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end typeDefaultValue;

protected function fun_542
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_value, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v),
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_v, SimCode.contextFunction, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_542;

protected function lm_543
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_543(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_varDecls, a_preExp) = lm_543(txt, rest, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_543;

protected function fun_544
  input Tpl.Text in_txt;
  input Tpl.Text in_a_defaultValue;
  input Tpl.Text in_a_var__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_defaultValue, in_a_var__name)
    local
      Tpl.Text txt;
      Tpl.Text a_var__name;
      Tpl.Text i_defaultValue;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           i_defaultValue,
           a_var__name )
      equation
        txt = Tpl.writeText(txt, a_var__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_544;

protected function fun_545
  input Tpl.Text in_txt;
  input Tpl.Text in_a_defaultValue;
  input Tpl.Text in_a_var__name;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_defaultValue, in_a_var__name, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_var__name;
      Tpl.Text a_type;
      Tpl.Text i_defaultValue;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           i_defaultValue,
           a_var__name,
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, i_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_var__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_545;

protected function fun_546
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.ComponentRef in_a_name;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_var__name;
  input Tpl.Text in_a_defaultValue;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_instDims, in_a_name, in_a_instDimsInit, in_a_var_ty, in_a_var__name, in_a_defaultValue, in_a_preExp)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_name;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      Tpl.Text a_var__name;
      Tpl.Text a_defaultValue;
      Tpl.Text a_preExp;
      list<DAE.Exp> i_instDims;
      Integer ret_1;
      Tpl.Text l_type;

    case ( txt,
           {},
           _,
           _,
           _,
           a_var__name,
           a_defaultValue,
           a_preExp )
      equation
        a_preExp = fun_544(a_preExp, a_defaultValue, a_var__name);
      then (txt, a_preExp);

    case ( txt,
           i_instDims,
           a_name,
           a_instDimsInit,
           a_var_ty,
           a_var__name,
           a_defaultValue,
           a_preExp )
      equation
        l_type = expTypeArray(Tpl.emptyTxt, a_var_ty);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, a_var__name);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        ret_1 = listLength(i_instDims);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_1));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_instDimsInit);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = fun_545(a_preExp, a_defaultValue, a_var__name, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("convert_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_to_f77(&"));
        a_preExp = Tpl.writeText(a_preExp, a_var__name);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = extVarName(a_preExp, a_name);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
      then (txt, a_preExp);
  end matchcontinue;
end fun_546;

public function extFunCallBiVarF77
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_var, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;
      Option<DAE.Exp> i_value;
      SimCode.Variable i_var;
      DAE.ComponentRef i_name;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_defaultValue;
      Tpl.Text l_var__name;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name, value = i_value, instDims = i_instDims, ty = i_var_ty)),
           a_preExp,
           a_varDecls )
      equation
        l_var__name = contextCref(Tpl.emptyTxt, i_name, SimCode.contextFunction);
        a_varDecls = varType(a_varDecls, i_var);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = Tpl.writeText(a_varDecls, l_var__name);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_varDecls = varType(a_varDecls, i_var);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName(a_varDecls, i_name);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        (l_defaultValue, a_varDecls, a_preExp) = fun_542(Tpl.emptyTxt, i_value, a_varDecls, a_preExp);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_preExp) = lm_543(l_instDimsInit, i_instDims, a_varDecls, a_preExp);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (txt, a_preExp) = fun_546(txt, i_instDims, i_name, l_instDimsInit, i_var_ty, l_var__name, l_defaultValue, a_preExp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extFunCallBiVarF77;

protected function fun_548
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_cr;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_mk_scon("));
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
      then txt;
  end matchcontinue;
end fun_548;

protected function fun_549
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_ty, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      Tpl.Text a_cr;

    case ( txt,
           false,
           _,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_ty,
           a_cr )
      equation
        txt = fun_548(txt, a_ty, a_cr);
      then txt;
  end matchcontinue;
end fun_549;

protected function fun_550
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi, in_a_ty, in_a_c)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      DAE.ComponentRef a_c;
      Integer i_oi;
      Boolean ret_1;
      Tpl.Text l_cr;

    case ( txt,
           0,
           _,
           _ )
      then txt;

    case ( txt,
           i_oi,
           a_ty,
           a_c )
      equation
        l_cr = extVarName(Tpl.emptyTxt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.c"));
        txt = Tpl.writeStr(txt, intString(i_oi));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = expTypeModelica(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_549(txt, ret_1, a_ty, l_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_550;

public function extFunCallVarcopy
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_arg)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      DAE.ComponentRef i_c;
      Integer i_oi;

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = i_ty, cref = i_c) )
      equation
        txt = fun_550(txt, i_oi, i_ty, i_c);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunCallVarcopy;

protected function fun_552
  input Tpl.Text in_txt;
  input Boolean in_a_ai;
  input Tpl.Text in_a_ext__name;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_outarg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ai, in_a_ext__name, in_a_ty, in_a_outarg)
    local
      Tpl.Text txt;
      Tpl.Text a_ext__name;
      DAE.Type a_ty;
      Tpl.Text a_outarg;

    case ( txt,
           false,
           a_ext__name,
           a_ty,
           a_outarg )
      equation
        txt = Tpl.writeText(txt, a_outarg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = expTypeModelica(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, a_ext__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           true,
           a_ext__name,
           a_ty,
           a_outarg )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("convert_alloc_"));
        txt = expTypeArray(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_from_f77(&"));
        txt = Tpl.writeText(txt, a_ext__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_outarg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_552;

protected function fun_553
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.Type in_a_ty;
  input Boolean in_a_ai;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi, in_a_ty, in_a_ai, in_a_c)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      Boolean a_ai;
      DAE.ComponentRef a_c;
      Integer i_oi;
      Tpl.Text l_ext__name;
      Tpl.Text l_outarg;

    case ( txt,
           0,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_oi,
           a_ty,
           a_ai,
           a_c )
      equation
        l_outarg = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("out.c"));
        l_outarg = Tpl.writeStr(l_outarg, intString(i_oi));
        l_ext__name = extVarName(Tpl.emptyTxt, a_c);
        txt = fun_552(txt, a_ai, l_ext__name, a_ty, l_outarg);
      then txt;
  end matchcontinue;
end fun_553;

public function extFunCallVarcopyF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_arg)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      Boolean i_ai;
      DAE.ComponentRef i_c;
      Integer i_oi;

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = i_ai, type_ = i_ty, cref = i_c) )
      equation
        txt = fun_553(txt, i_oi, i_ty, i_ai, i_c);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end extFunCallVarcopyF77;

protected function fun_555
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_oi;

    case ( txt,
           0,
           a_c )
      equation
        txt = contextCref(txt, a_c, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_oi,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.c"));
        txt = Tpl.writeStr(txt, intString(i_oi));
      then txt;
  end matchcontinue;
end fun_555;

protected function fun_556
  input Tpl.Text in_txt;
  input DAE.Type in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_t)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_556;

protected function fun_557
  input Tpl.Text in_txt;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_cr;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_STRINGDATA("));
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_557;

protected function fun_558
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Type a_t;
      Tpl.Text a_cr;

    case ( txt,
           false,
           a_t,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = fun_556(txt, a_t);
      then txt;

    case ( txt,
           _,
           a_t,
           a_cr )
      equation
        txt = fun_557(txt, a_t, a_cr);
      then txt;
  end matchcontinue;
end fun_558;

protected function fun_559
  input Tpl.Text in_txt;
  input Integer in_a_outputIndex;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_outputIndex, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_outputIndex;

    case ( txt,
           0,
           a_c )
      equation
        txt = contextCref(txt, a_c, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_outputIndex,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.c"));
        txt = Tpl.writeStr(txt, intString(i_outputIndex));
      then txt;
  end matchcontinue;
end fun_559;

public function extArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extArg, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Integer i_outputIndex;
      DAE.Type i_type__;
      DAE.Exp i_exp;
      Boolean i_isInput;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Integer i_oi;
      Tpl.Text l_dim;
      Tpl.Text l_typeStr;
      Boolean ret_3;
      Tpl.Text l_cr;
      Tpl.Text l_shortTypeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = i_oi, isArray = true, type_ = i_t, isInput = i_isInput),
           a_preExp,
           a_varDecls )
      equation
        l_name = fun_555(Tpl.emptyTxt, i_oi, i_c);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, i_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = extType(txt, i_t, i_isInput, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") data_of_"));
        txt = Tpl.writeText(txt, l_shortTypeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array(&("));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = 0, type_ = i_t),
           a_preExp,
           a_varDecls )
      equation
        l_cr = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        ret_3 = Config.acceptMetaModelicaGrammar();
        txt = fun_558(txt, ret_3, i_t, l_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = _, type_ = _),
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = extVarName(txt, i_c);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp),
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExternalCExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, type_ = i_type__, outputIndex = i_outputIndex, exp = i_exp),
           a_preExp,
           a_varDecls )
      equation
        l_typeStr = expTypeShort(Tpl.emptyTxt, i_type__);
        l_name = fun_559(Tpl.emptyTxt, i_outputIndex, i_c);
        (l_dim, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_of_dimension_"));
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array("));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dim);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extArg;

protected function fun_561
  input Tpl.Text in_txt;
  input Integer in_a_oi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_561;

protected function fun_562
  input Tpl.Text in_txt;
  input Integer in_a_oi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_oi)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end matchcontinue;
end fun_562;

public function extArgF77
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_extArg, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type i_type__;
      DAE.Exp i_exp;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.Type i_t;
      Tpl.Text l_size__call;
      Tpl.Text l_dim;
      Tpl.Text l_sizeVar;
      Tpl.Text l_sizeVarName;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text l_tvar;
      Tpl.Text l_texp;
      Tpl.Text l_suffix;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isArray = true, type_ = i_t),
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data_of_"));
        txt = expTypeShort(txt, i_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array(&("));
        txt = extVarName(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = i_oi, type_ = DAE.T_INTEGER(varLst = _)),
           a_preExp,
           a_varDecls )
      equation
        l_suffix = fun_561(Tpl.emptyTxt, i_oi);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int*) &"));
        txt = contextCref(txt, i_c, SimCode.contextFunction);
        txt = Tpl.writeText(txt, l_suffix);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = _, type_ = DAE.T_STRING(varLst = _)),
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char*)"));
        txt = contextCref(txt, i_c, SimCode.contextFunction);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = i_oi, type_ = _),
           a_preExp,
           a_varDecls )
      equation
        l_suffix = fun_562(Tpl.emptyTxt, i_oi);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = contextCref(txt, i_c, SimCode.contextFunction);
        txt = Tpl.writeText(txt, l_suffix);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp, type_ = DAE.T_STRING(varLst = _)),
           a_preExp,
           a_varDecls )
      equation
        (l_texp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt_3 = expTypeFromExpFlag(Tpl.emptyTxt, i_exp, 8);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_3), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_texp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char*)"));
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp),
           a_preExp,
           a_varDecls )
      equation
        (l_texp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        txt_4 = expTypeFromExpFlag(Tpl.emptyTxt, i_exp, 8);
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_4), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tvar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_texp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_tvar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, exp = i_exp, type_ = i_type__),
           a_preExp,
           a_varDecls )
      equation
        l_sizeVarName = tempSizeVarName(Tpl.emptyTxt, i_c, i_exp);
        (l_sizeVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "int", a_varDecls);
        (l_dim, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
        l_size__call = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("size_of_dimension_"));
        l_size__call = expTypeShort(l_size__call, i_type__);
        l_size__call = Tpl.writeTok(l_size__call, Tpl.ST_STRING("_array"));
        a_preExp = Tpl.writeText(a_preExp, l_sizeVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, l_size__call);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = contextCref(a_preExp, i_c, SimCode.contextFunction);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_dim);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_sizeVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end extArgF77;

protected function fun_564
  input Tpl.Text in_txt;
  input DAE.Exp in_a_indices;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_indices, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_integer;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           a_c )
      equation
        txt = contextCref(txt, a_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_size_"));
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("tempSizeVarName:UNHANDLED_EXPRESSION"));
      then txt;
  end matchcontinue;
end fun_564;

public function tempSizeVarName
  input Tpl.Text txt;
  input DAE.ComponentRef a_c;
  input DAE.Exp a_indices;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_564(txt, a_indices, a_c);
end tempSizeVarName;

protected function lm_566
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, SimCode.contextFunction, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_566(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_566(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_566;

public function funStatement
  input Tpl.Text in_txt;
  input SimCode.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           SimCode.ALGORITHM(statementLst = i_statementLst),
           a_varDecls )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_566(txt, i_statementLst, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED FUN STATEMENT"));
      then (txt, a_varDecls);
  end matchcontinue;
end funStatement;

protected function fun_568
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_s;

    case ( txt,
           (i_s as DAE.STMT_ASSIGN(exp1 = DAE.PATTERN(pattern = _))),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssignPattern(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_ASSIGN(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssign(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_ASSIGN_ARR(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssignArr(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_TUPLE_ASSIGN(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtTupleAssign(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_IF(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtIf(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_FOR(type_ = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtFor(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_WHILE(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtWhile(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_ASSERT(cond = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtAssert(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_TERMINATE(msg = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtTerminate(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_WHEN(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtWhen(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_BREAK(source = _),
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break;"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_FAILURE(body = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtFailure(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_TRY(tryBody = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtTry(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_CATCH(catchBody = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtCatch(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_THROW(source = _),
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_THROW();"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_RETURN(source = _),
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("goto _return;"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_NORETCALL(exp = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtNoretcall(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_REINIT(var = _)),
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStmtReinit(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 3879, 14), "ALG_STATEMENT NYI");
      then (txt, a_varDecls);
  end matchcontinue;
end fun_568;

public function algStatement
  input Tpl.Text txt;
  input DAE.Statement a_stmt;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Absyn.Info ret_2;
  DAE.ElementSource ret_1;
  Tpl.Text l_res;
algorithm
  (l_res, out_a_varDecls) := fun_568(Tpl.emptyTxt, a_stmt, a_varDecls, a_context);
  ret_1 := Algorithm.getStatementSource(a_stmt);
  ret_2 := DAEUtil.getElementSourceFileInfo(ret_1);
  out_txt := modelicaLine(txt, ret_2);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_res);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := endModelicaLine(out_txt);
end algStatement;

protected function fun_570
  input Tpl.Text in_txt;
  input DAE.Type in_a_var_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Ident in_a_var_name;
  input Tpl.Text in_a_rec;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_var_ty, in_a_context, in_a_cr, in_a_var_name, in_a_rec)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.Ident a_var_name;
      Tpl.Text a_rec;
      DAE.Type i_var_ty;
      DAE.ComponentRef ret_3;
      Tpl.Text l_varPart;
      DAE.ComponentRef ret_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_var_ty as DAE.T_ARRAY(ty = _)),
           a_context,
           a_cr,
           a_var_name,
           a_rec )
      equation
        txt_0 = Tpl.writeText(Tpl.emptyTxt, a_rec);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING("."));
        txt_0 = Tpl.writeStr(txt_0, a_var_name);
        ret_1 = ComponentReference.appendStringCref(a_var_name, a_cr);
        txt = copyArrayData(txt, i_var_ty, Tpl.textString(txt_0), ret_1, a_context);
      then txt;

    case ( txt,
           _,
           a_context,
           a_cr,
           a_var_name,
           a_rec )
      equation
        ret_3 = ComponentReference.appendStringCref(a_var_name, a_cr);
        l_varPart = contextCref(Tpl.emptyTxt, ret_3, a_context);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_rec);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_570;

protected function lm_571
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_rec;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_a_context, in_a_cr, in_a_rec)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text a_rec;
      DAE.Ident i_var_name;
      DAE.Type i_var_ty;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_var_ty, name = i_var_name) :: rest,
           a_context,
           a_cr,
           a_rec )
      equation
        txt = fun_570(txt, i_var_ty, a_context, a_cr, i_var_name, a_rec);
        txt = Tpl.nextIter(txt);
        txt = lm_571(txt, rest, a_context, a_cr, a_rec);
      then txt;

    case ( txt,
           _ :: rest,
           a_context,
           a_cr,
           a_rec )
      equation
        txt = lm_571(txt, rest, a_context, a_cr, a_rec);
      then txt;
  end matchcontinue;
end lm_571;

protected function lm_572
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_rec;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<DAE.Exp> in_a_expLst;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_rec, in_a_varDecls, in_a_preExp, in_a_context, in_a_expLst)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_rec;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Exp> a_expLst;
      Integer x_i1;
      DAE.Ident i_var_name;
      DAE.Exp ret_1;
      Tpl.Text l_re;

    case ( txt,
           {},
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.TYPES_VAR(name = i_var_name) :: rest,
           a_rec,
           a_varDecls,
           a_preExp,
           a_context,
           a_expLst )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        ret_1 = listNth(a_expLst, x_i1);
        (l_re, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, ret_1, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_re);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_rec);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_572(txt, rest, a_rec, a_varDecls, a_preExp, a_context, a_expLst);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_rec,
           a_varDecls,
           a_preExp,
           a_context,
           a_expLst )
      equation
        (txt, a_varDecls, a_preExp) = lm_572(txt, rest, a_rec, a_varDecls, a_preExp, a_context, a_expLst);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_572;

protected function fun_573
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input DAE.Exp in_a_val;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_val, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      DAE.Exp a_val;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp i_idx;
      DAE.Exp i_arr;
      Tpl.Text l_val1;
      Tpl.Text l_idx1;
      Tpl.Text l_arr1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.ASUB(exp = i_arr, sub = {i_idx}),
           a_val,
           a_varDecls,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arr1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_arr, a_context, l_preExp, a_varDecls);
        (l_idx1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_idx, a_context, l_preExp, a_varDecls);
        (l_val1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_val, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayUpdate("));
        txt = Tpl.writeText(txt, l_arr1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_idx1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_val1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_573;

protected function fun_574
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_exp1;
  input DAE.Exp in_a_val;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_exp1, in_a_val, in_a_varDecls, in_a_context, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp a_exp1;
      DAE.Exp a_val;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp a_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_varPart;
      Tpl.Text l_preExp;

    case ( txt,
           "metatype",
           _,
           a_val,
           a_varDecls,
           a_context,
           a_exp )
      equation
        (txt, a_varDecls) = fun_573(txt, a_exp, a_val, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_exp1,
           a_val,
           a_varDecls,
           a_context,
           _ )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = daeExpAsub(Tpl.emptyTxt, a_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_val, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_574;

public function algStmtAssign
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_val;
      list<DAE.Exp> i_expLst;
      DAE.ComponentRef i_cr;
      list<DAE.Var> i_varLst;
      DAE.Exp i_exp;
      DAE.Exp i_exp1;
      DAE.Exp i_e;
      Tpl.Text l_expPart2;
      Tpl.Text l_expPart1;
      String str_5;
      Tpl.Text txt_4;
      Tpl.Text l_rec;
      Tpl.Text l_varPart;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = DAE.CREF(componentRef = DAE.WILD()), exp = i_e),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _))), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = (modelica_fnptr) "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(ty = DAE.T_FUNCTION_REFERENCE_FUNC(builtin = _))), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = (modelica_fnptr) "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = DAE.CREF(componentRef = i_cr, ty = DAE.T_COMPLEX(varLst = i_varLst, complexClassType = ClassInf.RECORD(path = _))), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_rec, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_571(txt, i_varLst, a_context, i_cr, l_rec);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = DAE.CALL(path = _, expLst = i_expLst, attr = DAE.CALL_ATTR(ty = DAE.T_COMPLEX(varLst = i_varLst, complexClassType = ClassInf.RECORD(path = _)))), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_rec, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls, l_preExp) = lm_572(txt, i_varLst, l_rec, a_varDecls, l_preExp, a_context, i_expLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Record = func;"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(componentRef = _)), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.ASUB(exp = _)), exp = (i_exp as i_val)),
           a_context,
           a_varDecls )
      equation
        txt_4 = expTypeFromExpShort(Tpl.emptyTxt, i_exp);
        str_5 = Tpl.textString(txt_4);
        (txt, a_varDecls) = fun_574(txt, str_5, i_exp1, i_val, a_varDecls, a_context, i_exp);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = i_exp1, exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtAssign;

protected function fun_576
  input Tpl.Text in_txt;
  input Tpl.Text in_a_ispec;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_expPart;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ispec, in_a_varDecls, in_a_context, in_a_cr, in_a_expPart, in_a_t, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text a_expPart;
      DAE.Type a_t;
      Tpl.Text a_preExp;
      Tpl.Text i_ispec;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_varDecls,
           a_context,
           a_cr,
           a_expPart,
           a_t,
           a_preExp )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = copyArrayData(txt, a_t, Tpl.textString(a_expPart), a_cr, a_context);
      then (txt, a_varDecls);

    case ( txt,
           i_ispec,
           a_varDecls,
           a_context,
           a_cr,
           a_expPart,
           a_t,
           a_preExp )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        (txt, a_varDecls) = indexedAssign(txt, a_t, Tpl.textString(a_expPart), a_cr, Tpl.textString(i_ispec), a_context, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_576;

public function algStmtAssignArr
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_e;
      DAE.ComponentRef i_cr;
      DAE.Exp i_exp;
      DAE.Type i_t;
      Tpl.Text l_ispec;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_ASSIGN_ARR(exp = (i_exp as DAE.RANGE(ty = _)), componentRef = i_cr, type_ = i_t),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = fillArrayFromRange(txt, i_t, i_exp, i_cr, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN_ARR(exp = i_e, componentRef = i_cr, type_ = i_t),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, l_preExp, a_varDecls);
        (l_ispec, l_preExp, a_varDecls) = indexSpecFromCref(Tpl.emptyTxt, i_cr, a_context, l_preExp, a_varDecls);
        (txt, a_varDecls) = fun_576(txt, l_ispec, a_varDecls, a_context, i_cr, l_expPart, i_t, l_preExp);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtAssignArr;

protected function fun_578
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_expOption;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_expOption, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_stepExp;

    case ( txt,
           SOME(i_stepExp),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_stepExp, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_578;

protected function fun_579
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_cr, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Option<DAE.Exp> i_expOption;
      DAE.Exp i_range;
      DAE.Exp i_exp;
      DAE.Type i_ty;
      Tpl.Text l_step;
      Tpl.Text l_stop__exp;
      Tpl.Text l_start__exp;
      Tpl.Text l_ty__str;
      Tpl.Text l_cref;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.RANGE(ty = i_ty, exp = i_exp, range = i_range, expOption = i_expOption),
           a_cr,
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_cref = contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
        l_ty__str = expTypeArray(Tpl.emptyTxt, i_ty);
        (l_start__exp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        (l_stop__exp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_range, a_context, l_preExp, a_varDecls);
        (l_step, a_varDecls, l_preExp) = fun_578(Tpl.emptyTxt, i_expOption, a_varDecls, l_preExp, a_context);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fill_"));
        txt = Tpl.writeText(txt, l_ty__str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_from_range(&"));
        txt = Tpl.writeText(txt, l_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_start__exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_step);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_stop__exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_579;

public function fillArrayFromRange
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input DAE.Exp a_exp;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_579(txt, a_exp, a_cr, a_context, a_varDecls);
end fillArrayFromRange;

protected function fun_581
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input String in_a_ispec;
  input Tpl.Text in_a_cref;
  input String in_a_exp;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_context, in_a_varDecls, in_a_ispec, in_a_cref, in_a_exp, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      String a_ispec;
      Tpl.Text a_cref;
      String a_exp;
      Tpl.Text a_type;
      Tpl.Text l_tmp;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_varDecls,
           a_ispec,
           a_cref,
           a_exp,
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("indexed_assign_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeStr(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_ispec);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           a_ispec,
           a_cref,
           a_exp,
           a_type )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "real_array", a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("indexed_assign_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeStr(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeStr(txt, a_ispec);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "copy_"
                                }, false));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_data_mem(&"));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);
  end matchcontinue;
end fun_581;

public function indexedAssign
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input String a_exp;
  input DAE.ComponentRef a_cr;
  input String a_ispec;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_cref;
  Tpl.Text l_type;
algorithm
  l_type := expTypeArray(Tpl.emptyTxt, a_ty);
  l_cref := contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
  (out_txt, out_a_varDecls) := fun_581(txt, a_context, a_varDecls, a_ispec, l_cref, a_exp, l_type);
end indexedAssign;

protected function fun_583
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_cref;
  input String in_a_exp;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_cref, in_a_exp, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_cref;
      String a_exp;
      Tpl.Text a_type;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cref,
           a_exp,
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_data(&"));
        txt = Tpl.writeStr(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_cref,
           a_exp,
           a_type )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_data_mem(&"));
        txt = Tpl.writeStr(txt, a_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end matchcontinue;
end fun_583;

public function copyArrayData
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input String a_exp;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_cref;
  Tpl.Text l_type;
algorithm
  l_type := expTypeArray(Tpl.emptyTxt, a_ty);
  l_cref := contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
  out_txt := fun_583(txt, a_context, l_cref, a_exp, l_type);
end copyArrayData;

protected function lm_585
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_e;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        ret_0 = ExpressionDump.printExpStr(i_e);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_585(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_585(txt, rest);
      then txt;
  end matchcontinue;
end lm_585;

protected function lm_586
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_retStruct;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context, in_a_retStruct)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      Tpl.Text a_retStruct;
      Integer x_i1;
      DAE.Exp i_cr;
      Tpl.Text l_rhsStr;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_cr :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_retStruct )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        l_rhsStr = Tpl.writeText(Tpl.emptyTxt, a_retStruct);
        l_rhsStr = Tpl.writeTok(l_rhsStr, Tpl.ST_STRING(".c"));
        l_rhsStr = Tpl.writeStr(l_rhsStr, intString(x_i1));
        (txt, a_afterExp, a_varDecls) = writeLhsCref(txt, i_cr, Tpl.textString(l_rhsStr), a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_586(txt, rest, a_varDecls, a_afterExp, a_context, a_retStruct);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_retStruct )
      equation
        (txt, a_varDecls, a_afterExp) = lm_586(txt, rest, a_varDecls, a_afterExp, a_context, a_retStruct);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_586;

protected function lm_587
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_startIndexOutputs;
  input Tpl.Text in_a_prefix;
  input list<DAE.Exp> in_a_expExpLst;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context, in_a_startIndexOutputs, in_a_prefix, in_a_expExpLst)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      Tpl.Text a_startIndexOutputs;
      Tpl.Text a_prefix;
      list<DAE.Exp> a_expExpLst;
      Integer x_i0;
      DAE.Exp i_cr;
      Tpl.Text l_rhsStr;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _,
           _,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_cr :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_startIndexOutputs,
           a_prefix,
           a_expExpLst )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_rhsStr = getTempDeclMatchOutputName(Tpl.emptyTxt, a_expExpLst, Tpl.textString(a_prefix), Tpl.textString(a_startIndexOutputs), x_i0);
        (txt, a_afterExp, a_varDecls) = writeLhsCref(txt, i_cr, Tpl.textString(l_rhsStr), a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_587(txt, rest, a_varDecls, a_afterExp, a_context, a_startIndexOutputs, a_prefix, a_expExpLst);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_startIndexOutputs,
           a_prefix,
           a_expExpLst )
      equation
        (txt, a_varDecls, a_afterExp) = lm_587(txt, rest, a_varDecls, a_afterExp, a_context, a_startIndexOutputs, a_prefix, a_expExpLst);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_587;

protected function lm_588
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_startIndexOutputs;
  input Tpl.Text in_a_prefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_startIndexOutputs, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_startIndexOutputs;
      Tpl.Text a_prefix;
      Integer x_i0;
      DAE.Exp i_cr;
      Tpl.Text l_decl;
      Tpl.Text l_typ;

    case ( txt,
           {},
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_cr :: rest,
           a_varDecls,
           a_startIndexOutputs,
           a_prefix )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_typ = expTypeFromExpModelica(Tpl.emptyTxt, i_cr);
        (l_decl, a_varDecls) = tempDeclMatchOutput(Tpl.emptyTxt, Tpl.textString(l_typ), Tpl.textString(a_prefix), Tpl.textString(a_startIndexOutputs), intString(x_i0), a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_588(txt, rest, a_varDecls, a_startIndexOutputs, a_prefix);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_startIndexOutputs,
           a_prefix )
      equation
        (txt, a_varDecls) = lm_588(txt, rest, a_varDecls, a_startIndexOutputs, a_prefix);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_588;

public function algStmtTupleAssign
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      list<DAE.Exp> i_expExpLst;
      Tpl.Text l_0__;
      Integer ret_11;
      Integer ret_10;
      Tpl.Text l_startIndexOutputs;
      Integer ret_8;
      Tpl.Text l_prefix;
      Tpl.Text l_lhsCrefs;
      Tpl.Text l_retStruct;
      String ret_4;
      Tpl.Text l_marker;
      Tpl.Text l_crefs;
      Tpl.Text l_afterExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(exp = (i_exp as DAE.CALL(path = _)), expExpLst = i_expExpLst),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_afterExp = Tpl.emptyTxt;
        l_crefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_crefs = lm_585(l_crefs, i_expExpLst);
        l_crefs = Tpl.popIter(l_crefs);
        l_marker = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("("));
        l_marker = Tpl.writeText(l_marker, l_crefs);
        l_marker = Tpl.writeTok(l_marker, Tpl.ST_STRING(") = "));
        ret_4 = ExpressionDump.printExpStr(i_exp);
        l_marker = Tpl.writeStr(l_marker, ret_4);
        (l_retStruct, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        l_lhsCrefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_lhsCrefs, a_varDecls, l_afterExp) = lm_586(l_lhsCrefs, i_expExpLst, a_varDecls, l_afterExp, a_context, l_retStruct);
        l_lhsCrefs = Tpl.popIter(l_lhsCrefs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* algStmtTupleAssign: preExp printout "));
        txt = Tpl.writeText(txt, l_marker);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("*/\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* algStmtTupleAssign: writeLhsCref "));
        txt = Tpl.writeText(txt, l_marker);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.writeText(txt, l_lhsCrefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* algStmtTupleAssign: afterExp printout "));
        txt = Tpl.writeText(txt, l_marker);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.writeText(txt, l_afterExp);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(exp = (i_exp as DAE.MATCHEXPRESSION(matchType = _)), expExpLst = i_expExpLst),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        l_afterExp = Tpl.emptyTxt;
        l_prefix = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("tmp"));
        ret_8 = System.tmpTick();
        l_prefix = Tpl.writeStr(l_prefix, intString(ret_8));
        ret_10 = listLength(i_expExpLst);
        ret_11 = System.tmpTickIndexReserve(1, ret_10);
        l_startIndexOutputs = Tpl.writeStr(Tpl.emptyTxt, intString(ret_11));
        (l_0__, l_prefix, l_startIndexOutputs, l_preExp, a_varDecls) = daeExpMatch2(Tpl.emptyTxt, i_exp, i_expExpLst, l_prefix, l_startIndexOutputs, a_context, l_preExp, a_varDecls);
        l_lhsCrefs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_lhsCrefs, a_varDecls, l_afterExp) = lm_587(l_lhsCrefs, i_expExpLst, a_varDecls, l_afterExp, a_context, l_startIndexOutputs, l_prefix, i_expExpLst);
        l_lhsCrefs = Tpl.popIter(l_lhsCrefs);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_588(txt, i_expExpLst, a_varDecls, l_startIndexOutputs, l_prefix);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_lhsCrefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_afterExp);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 4096, 12), "algStmtTupleAssign failed");
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtTupleAssign;

protected function fun_590
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_lhsStr;
  input String in_a_rhsStr;
  input DAE.Type in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_lhsStr, in_a_rhsStr, in_a_t)
    local
      Tpl.Text txt;
      Tpl.Text a_lhsStr;
      String a_rhsStr;
      DAE.Type a_t;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           a_lhsStr,
           a_rhsStr,
           a_t )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_"));
        txt = expTypeShort(txt, a_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data_mem(&"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_lhsStr,
           a_rhsStr,
           _ )
      equation
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_590;

protected function fun_591
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_lhsStr;
  input String in_a_rhsStr;
  input DAE.Type in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_context, in_a_lhsStr, in_a_rhsStr, in_a_t)
    local
      Tpl.Text txt;
      Tpl.Text a_lhsStr;
      String a_rhsStr;
      DAE.Type a_t;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           a_lhsStr,
           a_rhsStr,
           a_t )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("usub_"));
        txt = expTypeShort(txt, a_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array(&"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "copy_"
                                }, false));
        txt = expTypeShort(txt, a_t);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array_data_mem(&"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_lhsStr,
           a_rhsStr,
           _ )
      equation
        txt = Tpl.writeText(txt, a_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = -"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_591;

public function writeLhsCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input String in_a_rhsStr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_rhsStr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_rhsStr;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_e;
      DAE.Type i_t;
      DAE.Exp i_exp;
      String ret_1;
      Tpl.Text l_lhsStr;

    case ( txt,
           DAE.CREF(componentRef = DAE.WILD()),
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CREF(ty = (i_t as DAE.T_ARRAY(ty = _)))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = fun_590(txt, a_context, l_lhsStr, a_rhsStr, i_t);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UNARY(exp = (i_e as DAE.CREF(ty = (i_t as DAE.T_ARRAY(ty = _))))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        txt = fun_591(txt, a_context, l_lhsStr, a_rhsStr, i_t);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_exp as DAE.CREF(componentRef = _)),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UNARY(exp = (i_e as DAE.CREF(componentRef = _))),
           a_rhsStr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_lhsStr, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_lhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = -"));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_rhsStr,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* SimCodeC.tpl template: writeLhsCref: UNHANDLED LHS\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* "));
        ret_1 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_rhsStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
        txt = Tpl.popBlock(txt);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end writeLhsCref;

protected function lm_593
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_593(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_593(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_593;

public function algStmtIf
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_condExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_IF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_593(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        (txt, a_varDecls) = elseExpr(txt, i_else__, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtIf;

public function algStmtFor
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Statement i_s;

    case ( txt,
           (i_s as DAE.STMT_FOR(range = DAE.RANGE(ty = _))),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStmtForRange(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           (i_s as DAE.STMT_FOR(type_ = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStmtForGeneric(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtFor;

protected function lm_596
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_596(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_596(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_596;

public function algStmtForRange
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Ident i_iter;
      DAE.Exp i_rng;
      list<DAE.Statement> i_statementLst;
      Boolean i_iterIsArray;
      DAE.Type i_type__;
      Tpl.Text l_stmtStr;
      Tpl.Text l_identTypeShort;
      Tpl.Text l_identType;

    case ( txt,
           DAE.STMT_FOR(range = (i_rng as DAE.RANGE(ty = _)), type_ = i_type__, iterIsArray = i_iterIsArray, statementLst = i_statementLst, iter = i_iter),
           a_context,
           a_varDecls )
      equation
        l_identType = expType(Tpl.emptyTxt, i_type__, i_iterIsArray);
        l_identTypeShort = expTypeShort(Tpl.emptyTxt, i_type__);
        l_stmtStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtStr, a_varDecls) = lm_596(l_stmtStr, i_statementLst, a_varDecls, a_context);
        l_stmtStr = Tpl.popIter(l_stmtStr);
        (txt, l_stmtStr, a_varDecls) = algStmtForRange_impl(txt, i_rng, i_iter, Tpl.textString(l_identType), Tpl.textString(l_identTypeShort), l_stmtStr, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtForRange;

protected function fun_598
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_598;

protected function fun_599
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_expOption;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_expOption, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_eo;

    case ( txt,
           SOME(i_eo),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_eo, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1)"));
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_599;

protected function fun_600
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_600;

protected function fun_601
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_601;

protected function fun_602
  input Tpl.Text in_txt;
  input DAE.Exp in_a_range;
  input Absyn.Ident in_a_iterator;
  input String in_a_type;
  input String in_a_shortType;
  input Tpl.Text in_a_body;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_range, in_a_iterator, in_a_type, in_a_shortType, in_a_body, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      Absyn.Ident a_iterator;
      String a_type;
      String a_shortType;
      Tpl.Text a_body;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_range;
      Option<DAE.Exp> i_expOption;
      DAE.Exp i_exp;
      Boolean ret_11;
      Boolean ret_10;
      Tpl.Text l_stopValue;
      Tpl.Text l_stepValue;
      Tpl.Text l_startValue;
      Tpl.Text l_preExp;
      Tpl.Text l_stopVar;
      Tpl.Text l_stepVar;
      Tpl.Text l_startVar;
      Boolean ret_2;
      Tpl.Text l_stateVar;
      Tpl.Text l_iterName;

    case ( txt,
           DAE.RANGE(exp = i_exp, expOption = i_expOption, range = i_range),
           a_iterator,
           a_type,
           a_shortType,
           a_body,
           a_context,
           a_varDecls )
      equation
        l_iterName = contextIteratorName(Tpl.emptyTxt, a_iterator, a_context);
        ret_2 = Config.acceptMetaModelicaGrammar();
        (l_stateVar, a_varDecls) = fun_598(Tpl.emptyTxt, ret_2, a_varDecls);
        (l_startVar, a_varDecls) = tempDecl(Tpl.emptyTxt, a_type, a_varDecls);
        (l_stepVar, a_varDecls) = tempDecl(Tpl.emptyTxt, a_type, a_varDecls);
        (l_stopVar, a_varDecls) = tempDecl(Tpl.emptyTxt, a_type, a_varDecls);
        l_preExp = Tpl.emptyTxt;
        (l_startValue, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        (l_stepValue, a_varDecls, l_preExp) = fun_599(Tpl.emptyTxt, i_expOption, a_varDecls, l_preExp, a_context);
        (l_stopValue, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_range, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_startVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_stepValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.writeText(txt, l_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_stopValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "if (!"
                                }, false));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ") {\n",
                                    "  FILE_INFO info = omc_dummyFileInfo;\n",
                                    "  MODELICA_ASSERT(info, \"assertion range step != 0 failed\");\n",
                                    "} else if (!((("
                                }, false));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > 0) && ("));
        txt = Tpl.writeText(txt, l_startVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, l_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) || (("));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < 0) && ("));
        txt = Tpl.writeText(txt, l_startVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, l_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")))) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "for ("
                                }, false));
        txt = Tpl.writeText(txt, l_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; in_range_"));
        txt = Tpl.writeStr(txt, a_shortType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_startVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); "));
        txt = Tpl.writeText(txt, l_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" += "));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_10 = Config.acceptMetaModelicaGrammar();
        txt = fun_600(txt, ret_10, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_body);
        txt = Tpl.softNewLine(txt);
        ret_11 = Config.acceptMetaModelicaGrammar();
        txt = fun_601(txt, ret_11, l_stateVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_602;

public function algStmtForRange_impl
  input Tpl.Text txt;
  input DAE.Exp a_range;
  input Absyn.Ident a_iterator;
  input String a_type;
  input String a_shortType;
  input Tpl.Text a_body;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_body;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_602(txt, a_range, a_iterator, a_type, a_shortType, a_body, a_context, a_varDecls);
  out_a_body := a_body;
end algStmtForRange_impl;

protected function lm_604
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_604(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_604(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_604;

public function algStmtForGeneric
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Ident i_iter;
      DAE.Exp i_range;
      list<DAE.Statement> i_statementLst;
      Boolean i_iterIsArray;
      DAE.Type i_type__;
      Tpl.Text l_stmtStr;
      Tpl.Text l_arrayType;
      Tpl.Text l_iterType;

    case ( txt,
           DAE.STMT_FOR(type_ = i_type__, iterIsArray = i_iterIsArray, statementLst = i_statementLst, range = i_range, iter = i_iter),
           a_context,
           a_varDecls )
      equation
        l_iterType = expType(Tpl.emptyTxt, i_type__, i_iterIsArray);
        l_arrayType = expTypeArray(Tpl.emptyTxt, i_type__);
        l_stmtStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtStr, a_varDecls) = lm_604(l_stmtStr, i_statementLst, a_varDecls, a_context);
        l_stmtStr = Tpl.popIter(l_stmtStr);
        (txt, l_stmtStr, a_varDecls) = algStmtForGeneric_impl(txt, i_range, i_iter, Tpl.textString(l_iterType), Tpl.textString(l_arrayType), i_iterIsArray, l_stmtStr, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtForGeneric;

protected function fun_606
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "state", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_606;

protected function fun_607
  input Tpl.Text in_txt;
  input Boolean in_a_iterIsArray;
  input Tpl.Text in_a_ivar;
  input String in_a_type;
  input Tpl.Text in_a_tvar;
  input Tpl.Text in_a_evar;
  input String in_a_arrayType;
  input Tpl.Text in_a_iterName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_iterIsArray, in_a_ivar, in_a_type, in_a_tvar, in_a_evar, in_a_arrayType, in_a_iterName)
    local
      Tpl.Text txt;
      Tpl.Text a_ivar;
      String a_type;
      Tpl.Text a_tvar;
      Tpl.Text a_evar;
      String a_arrayType;
      Tpl.Text a_iterName;

    case ( txt,
           false,
           _,
           _,
           a_tvar,
           a_evar,
           a_arrayType,
           a_iterName )
      equation
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = *("));
        txt = Tpl.writeStr(txt, a_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_element_addr1(&"));
        txt = Tpl.writeText(txt, a_evar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", 1, "));
        txt = Tpl.writeText(txt, a_tvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("));"));
      then txt;

    case ( txt,
           _,
           a_ivar,
           a_type,
           a_tvar,
           a_evar,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("simple_index_alloc_"));
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1(&"));
        txt = Tpl.writeText(txt, a_evar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_tvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_ivar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end matchcontinue;
end fun_607;

protected function fun_608
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = get_memory_state();"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_608;

protected function fun_609
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stateVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_stateVar)
    local
      Tpl.Text txt;
      Tpl.Text a_stateVar;

    case ( txt,
           false,
           a_stateVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("restore_memory_state("));
        txt = Tpl.writeText(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_609;

public function algStmtForGeneric_impl
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input Absyn.Ident a_iterator;
  input String a_type;
  input String a_arrayType;
  input Boolean a_iterIsArray;
  input Tpl.Text a_body;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_body;
  output Tpl.Text out_a_varDecls;
protected
  Boolean ret_9;
  Boolean ret_8;
  Tpl.Text l_stmtStuff;
  Tpl.Text l_evar;
  Tpl.Text l_preExp;
  Tpl.Text l_ivar;
  Tpl.Text l_tvar;
  Boolean ret_2;
  Tpl.Text l_stateVar;
  Tpl.Text l_iterName;
algorithm
  l_iterName := contextIteratorName(Tpl.emptyTxt, a_iterator, a_context);
  ret_2 := Config.acceptMetaModelicaGrammar();
  (l_stateVar, out_a_varDecls) := fun_606(Tpl.emptyTxt, ret_2, a_varDecls);
  (l_tvar, out_a_varDecls) := tempDecl(Tpl.emptyTxt, "int", out_a_varDecls);
  (l_ivar, out_a_varDecls) := tempDecl(Tpl.emptyTxt, a_type, out_a_varDecls);
  l_preExp := Tpl.emptyTxt;
  (l_evar, l_preExp, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_exp, a_context, l_preExp, out_a_varDecls);
  l_stmtStuff := fun_607(Tpl.emptyTxt, a_iterIsArray, l_ivar, a_type, l_tvar, l_evar, a_arrayType, l_iterName);
  out_txt := Tpl.writeText(txt, l_preExp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("{\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeStr(out_txt, a_type);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeText(out_txt, l_iterName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ";\n",
                                       "\n",
                                       "for("
                                   }, false));
  out_txt := Tpl.writeText(out_txt, l_tvar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" = 1; "));
  out_txt := Tpl.writeText(out_txt, l_tvar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" <= size_of_dimension_"));
  out_txt := Tpl.writeStr(out_txt, a_arrayType);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("("));
  out_txt := Tpl.writeText(out_txt, l_evar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(", 1); ++"));
  out_txt := Tpl.writeText(out_txt, l_tvar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(") {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_8 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_608(out_txt, ret_8, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_stmtStuff);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, a_body);
  out_txt := Tpl.softNewLine(out_txt);
  ret_9 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_609(out_txt, ret_9, l_stateVar);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("}\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
  out_a_body := a_body;
end algStmtForGeneric_impl;

protected function lm_611
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_611(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_611(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_611;

public function algStmtWhile
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_var;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_WHILE(exp = i_exp, statementLst = i_statementLst),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_var, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("while (1) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (!"));
        txt = Tpl.writeText(txt, l_var);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") break;\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_611(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtWhile;

public function algStmtAssert
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Absyn.Info i_info;
      DAE.Exp i_msg;
      DAE.Exp i_cond;

    case ( txt,
           DAE.STMT_ASSERT(source = DAE.SOURCE(info = i_info), cond = i_cond, msg = i_msg),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = assertCommon(txt, i_cond, i_msg, a_context, a_varDecls, i_info);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtAssert;

public function algStmtTerminate
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_msg;
      Tpl.Text l_msgVar;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_TERMINATE(msg = i_msg),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_msg, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE("));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtTerminate;

protected function lm_615
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varAssign, in_a_preExp, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_varAssign;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Tpl.Text l_lhs;
      Tpl.Text txt_1;
      Tpl.Text l_decl;

    case ( txt,
           {},
           a_varAssign,
           a_preExp,
           _,
           a_varDecls )
      then (txt, a_varAssign, a_preExp, a_varDecls);

    case ( txt,
           i_exp :: rest,
           a_varAssign,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        txt_1 = expTypeFromExpModelica(Tpl.emptyTxt, i_exp);
        (l_decl, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        (l_lhs, a_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        a_varAssign = Tpl.writeText(a_varAssign, l_decl);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = Tpl.writeText(a_varAssign, l_lhs);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_lhs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_decl);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varAssign, a_preExp, a_varDecls) = lm_615(txt, rest, a_varAssign, a_preExp, a_context, a_varDecls);
      then (txt, a_varAssign, a_preExp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varAssign,
           a_preExp,
           a_context,
           a_varDecls )
      equation
        (txt, a_varAssign, a_preExp, a_varDecls) = lm_615(txt, rest, a_varAssign, a_preExp, a_context, a_varDecls);
      then (txt, a_varAssign, a_preExp, a_varDecls);
  end matchcontinue;
end lm_615;

public function algStmtMatchcasesVarDeclsAndAssign
  input Tpl.Text txt;
  input list<DAE.Exp> a_expList;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varAssign;
  input Tpl.Text a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_preExp;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_varAssign, out_a_preExp, out_a_varDecls) := lm_615(out_txt, a_expList, a_varAssign, a_preExp, a_context, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end algStmtMatchcasesVarDeclsAndAssign;

protected function lm_617
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_617(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_617(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_617;

public function algStmtFailure
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_body;
      Tpl.Text l_stmtBody;
      Tpl.Text l_tmp;

    case ( txt,
           DAE.STMT_FAILURE(body = i_body),
           a_context,
           a_varDecls )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        l_stmtBody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_stmtBody, a_varDecls) = lm_617(l_stmtBody, i_body, a_varDecls, a_context);
        l_stmtBody = Tpl.popIter(l_stmtBody);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = 0; /* begin failure */\n",
                                    "MMC_TRY()\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_stmtBody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" = 1;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MMC_CATCH()\n",
                                    "if ("
                                }, false));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") MMC_THROW(); /* end failure */"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtFailure;

protected function lm_619
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_619(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_619(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_619;

public function algStmtTry
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_tryBody;
      Tpl.Text l_body;

    case ( txt,
           DAE.STMT_TRY(tryBody = i_tryBody),
           a_context,
           a_varDecls )
      equation
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, a_varDecls) = lm_619(l_body, i_tryBody, a_varDecls, a_context);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#error \"Using STMT_TRY: This is deprecated, and should be matched with catch anyway.\"\n",
                                    "try {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtTry;

protected function lm_621
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_621(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_621(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_621;

public function algStmtCatch
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<DAE.Statement> i_catchBody;
      Tpl.Text l_body;

    case ( txt,
           DAE.STMT_CATCH(catchBody = i_catchBody),
           a_context,
           a_varDecls )
      equation
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, a_varDecls) = lm_621(l_body, i_catchBody, a_varDecls, a_context);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#error \"Using STMT_CATCH: This is deprecated, and should be matched with catch anyway.\"\n",
                                    "catch (int i) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtCatch;

public function algStmtNoretcall
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_NORETCALL(exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtNoretcall;

protected function lm_624
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_624(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_624(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_624;

protected function lm_625
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_idx :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        txt = Tpl.writeStr(txt, intString(i_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !data->simulationInfo.helpVarsPre["));
        txt = Tpl.writeStr(txt, intString(i_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        txt = lm_625(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_625(txt, rest);
      then txt;
  end matchcontinue;
end lm_625;

protected function fun_626
  input Tpl.Text in_txt;
  input DAE.Statement in_a_when;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_when, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      list<Integer> i_helpVarIndices;
      Option<DAE.Statement> i_elseWhen;
      list<DAE.Statement> i_statementLst;
      DAE.Statement i_when;
      Tpl.Text l_else;
      Tpl.Text l_statements;
      Tpl.Text l_preIf;

    case ( txt,
           (i_when as DAE.STMT_WHEN(statementLst = i_statementLst, elseWhen = i_elseWhen, helpVarIndices = i_helpVarIndices)),
           a_context,
           a_varDecls )
      equation
        (l_preIf, a_varDecls) = algStatementWhenPre(Tpl.emptyTxt, i_when, a_varDecls);
        l_statements = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_statements, a_varDecls) = lm_624(l_statements, i_statementLst, a_varDecls, a_context);
        l_statements = Tpl.popIter(l_statements);
        (l_else, a_varDecls) = algStatementWhenElse(Tpl.emptyTxt, i_elseWhen, a_varDecls);
        txt = Tpl.writeText(txt, l_preIf);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_625(txt, i_helpVarIndices);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_else);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_626;

protected function fun_627
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Statement in_a_when;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_context, in_a_when, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Statement a_when;
      Tpl.Text a_varDecls;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.SIMULATION(genDiscrete = true)),
           a_when,
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_626(txt, a_when, i_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_627;

public function algStmtWhen
  input Tpl.Text txt;
  input DAE.Statement a_when;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_627(txt, a_context, a_when, a_varDecls);
end algStmtWhen;

protected function fun_629
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_elseWhen;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_elseWhen, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Statement i_ew;

    case ( txt,
           SOME(i_ew),
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatementWhenPre(txt, i_ew, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_629;

protected function fun_630
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_when_elseWhen;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_when_elseWhen, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Statement i_ew;

    case ( txt,
           SOME(i_ew),
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatementWhenPre(txt, i_ew, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_630;

protected function fun_631
  input Tpl.Text in_txt;
  input list<Integer> in_a_helpVarIndices;
  input DAE.Exp in_a_when_exp;
  input Tpl.Text in_a_varDecls;
  input Option<DAE.Statement> in_a_when_elseWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_helpVarIndices, in_a_when_exp, in_a_varDecls, in_a_when_elseWhen)
    local
      Tpl.Text txt;
      DAE.Exp a_when_exp;
      Tpl.Text a_varDecls;
      Option<DAE.Statement> a_when_elseWhen;
      Integer i_i;
      Tpl.Text l_res;
      Tpl.Text l_preExp;
      Tpl.Text l_restPre;

    case ( txt,
           {i_i},
           a_when_exp,
           a_varDecls,
           a_when_elseWhen )
      equation
        (l_restPre, a_varDecls) = fun_630(Tpl.emptyTxt, a_when_elseWhen, a_varDecls);
        l_preExp = Tpl.emptyTxt;
        (l_res, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_when_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_res);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, l_restPre);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end matchcontinue;
end fun_631;

public function algStatementWhenPre
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Exp i_when_exp;
      Option<DAE.Statement> i_when_elseWhen;
      list<Integer> i_helpVarIndices;
      list<DAE.Exp> i_el;
      Option<DAE.Statement> i_elseWhen;
      Tpl.Text l_assignments;
      Tpl.Text l_preExp;
      Tpl.Text l_restPre;

    case ( txt,
           DAE.STMT_WHEN(exp = DAE.ARRAY(array = i_el), elseWhen = i_elseWhen, helpVarIndices = i_helpVarIndices),
           a_varDecls )
      equation
        (l_restPre, a_varDecls) = fun_629(Tpl.emptyTxt, i_elseWhen, a_varDecls);
        l_preExp = Tpl.emptyTxt;
        (l_assignments, l_preExp, a_varDecls) = algStatementWhenPreAssigns(Tpl.emptyTxt, i_el, i_helpVarIndices, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_assignments);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_restPre);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_WHEN(helpVarIndices = i_helpVarIndices, elseWhen = i_when_elseWhen, exp = i_when_exp),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_631(txt, i_helpVarIndices, i_when_exp, a_varDecls, i_when_elseWhen);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStatementWhenPre;

protected function lm_633
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, SimCode.contextSimulationDiscrete, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_633(txt, rest, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_633(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_633;

protected function lm_634
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_hidx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_hidx :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] && !data->simulationInfo.helpVarsPre["));
        txt = Tpl.writeStr(txt, intString(i_hidx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] /* edge */"));
        txt = Tpl.nextIter(txt);
        txt = lm_634(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_634(txt, rest);
      then txt;
  end matchcontinue;
end lm_634;

public function algStatementWhenElse
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_stmt;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<Integer> i_when_helpVarIndices;
      Option<DAE.Statement> i_when_elseWhen;
      list<DAE.Statement> i_when_statementLst;
      Tpl.Text l_elseCondStr;
      Tpl.Text l_else;
      Tpl.Text l_statements;

    case ( txt,
           SOME(DAE.STMT_WHEN(statementLst = i_when_statementLst, elseWhen = i_when_elseWhen, helpVarIndices = i_when_helpVarIndices)),
           a_varDecls )
      equation
        l_statements = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_statements, a_varDecls) = lm_633(l_statements, i_when_statementLst, a_varDecls);
        l_statements = Tpl.popIter(l_statements);
        (l_else, a_varDecls) = algStatementWhenElse(Tpl.emptyTxt, i_when_elseWhen, a_varDecls);
        l_elseCondStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_elseCondStr = lm_634(l_elseCondStr, i_when_helpVarIndices);
        l_elseCondStr = Tpl.popIter(l_elseCondStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if ("));
        txt = Tpl.writeText(txt, l_elseCondStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_else);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStatementWhenElse;

protected function fun_636
  input Tpl.Text in_txt;
  input list<Integer> in_a_ints;
  input DAE.Exp in_a_firstExp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input list<DAE.Exp> in_a_restExps;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_ints, in_a_firstExp, in_a_varDecls, in_a_preExp, in_a_restExps)
    local
      Tpl.Text txt;
      DAE.Exp a_firstExp;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      list<DAE.Exp> a_restExps;
      Integer i_firstInt;
      list<Integer> i_restInts;
      Tpl.Text l_firstExpPart;
      Tpl.Text l_rest;

    case ( txt,
           i_firstInt :: i_restInts,
           a_firstExp,
           a_varDecls,
           a_preExp,
           a_restExps )
      equation
        (l_rest, a_preExp, a_varDecls) = algStatementWhenPreAssigns(Tpl.emptyTxt, a_restExps, i_restInts, a_preExp, a_varDecls);
        (l_firstExpPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_firstExp, SimCode.contextSimulationDiscrete, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.helpVars["));
        txt = Tpl.writeStr(txt, intString(i_firstInt));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_firstExpPart);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, l_rest);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_636;

public function algStatementWhenPreAssigns
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_exps;
  input list<Integer> in_a_ints;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exps, in_a_ints, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<Integer> a_ints;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_firstExp;
      list<DAE.Exp> i_restExps;

    case ( txt,
           {},
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_firstExp :: i_restExps,
           a_ints,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_636(txt, a_ints, i_firstExp, a_varDecls, a_preExp, i_restExps);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end algStatementWhenPreAssigns;

public function algStmtReinit
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_value;
      DAE.Exp i_var;
      Tpl.Text l_expPart2;
      Tpl.Text l_expPart1;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_REINIT(var = i_var, value = i_value),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_var, a_context, l_preExp, a_varDecls);
        (l_expPart2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_value, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("if (DEBUG_FLAG(LOG_EVENTS)) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("printf(\"reinit "));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = %f\\n\", "));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "$P$PRE"
                                }, false));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end algStmtReinit;

public function indexSpecFromCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_cr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Subscript> i_subs;

    case ( txt,
           DAE.CREF_IDENT(subscriptLst = (i_subs as _ :: _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhsIndexSpec(txt, i_subs, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end indexSpecFromCref;

protected function lm_640
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_640(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_640(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_640;

protected function lm_641
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, a_context, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_641(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_641(txt, rest, a_varDecls, a_context);
      then (txt, a_varDecls);
  end matchcontinue;
end lm_641;

public function elseExpr
  input Tpl.Text in_txt;
  input DAE.Else in_a_else__;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_else__, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_condExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.NOELSE(),
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           DAE.ELSEIF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_640(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        (txt, a_varDecls) = elseExpr(txt, i_else__, a_context, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.ELSE(statementLst = i_statementLst),
           a_context,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_641(txt, i_statementLst, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end matchcontinue;
end elseExpr;

protected function fun_643
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr_componentRef, in_a_varDecls, in_a_preExp, in_a_context, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_ecr;

    case ( txt,
           false,
           _,
           a_varDecls,
           a_preExp,
           a_context,
           a_ecr )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefLhs(txt, a_ecr, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_varDecls,
           a_preExp,
           a_context,
           _ )
      equation
        txt = contextCref(txt, a_ecr_componentRef, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_643;

public function scalarLhsCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_ecr;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.ComponentRef i_cr;
      Boolean ret_0;

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _)),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*((modelica_fnptr*)&_"));
        txt = crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_IDENT(ident = _)))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        ret_0 = SimCode.crefNoSub(i_ecr_componentRef);
        (txt, a_varDecls, a_preExp) = fun_643(txt, ret_0, i_ecr_componentRef, a_varDecls, a_preExp, a_context, i_ecr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_QUAL(ident = _))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        txt = contextCref(txt, i_ecr_componentRef, a_context);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = DAE.WILD()),
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ONLY_IDENT_OR_QUAL_CREF_SUPPORTED_SLHS"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end scalarLhsCref;

public function rhsCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_cr, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident),
           a_ty )
      equation
        txt = rhsCrefType(txt, a_ty);
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef),
           a_ty )
      equation
        txt = rhsCrefType(txt, a_ty);
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = rhsCref(txt, i_componentRef, a_ty);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rhsCref:ERROR"));
      then txt;
  end matchcontinue;
end rhsCref;

public function rhsCrefType
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end rhsCrefType;

protected function fun_647
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(0)"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1)"));
      then txt;
  end matchcontinue;
end fun_647;

public function daeExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Exp i_e;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer) "));
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.RCONST(real = i_real),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SCONST(string = i_string),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSconst(txt, i_string, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.BCONST(bool = i_bool),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = fun_647(txt, i_bool);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CREF(componentRef = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.BINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpBinary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.UNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LBINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLbinary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LUNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLunary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.RELATION(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRelation(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.IFEXP(expCond = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpIf(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CALL(path = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCall(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ARRAY(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpArray(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.MATRIX(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMatrix(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.RANGE(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRange(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CAST(ty = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCast(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.ASUB(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpAsub(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.TSUB(exp = i_exp),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c1"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.SIZE(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSize(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.REDUCTION(reductionInfo = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpReduction(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LIST(valList = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpList(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.CONS(car = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCons(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.META_TUPLE(listExp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMetaTuple(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.META_OPTION(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMetaOption(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.METARECORDCALL(path = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMetarecordcall(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.MATCHEXPRESSION(matchType = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpMatch(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.BOX(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpBox(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.UNBOX(exp = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnbox(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.SHARED_LITERAL(index = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpSharedLiteral(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown expression: "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 4615, 14), Tpl.textString(txt_0));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExp;

protected function fun_649
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type ret_2;
      DAE.Type ret_1;
      Tpl.Text l_shortTypeStr;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_exp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        ret_1 = Expression.typeof(a_exp);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        ret_2 = Expression.typeof(a_exp);
        txt = extType(txt, ret_2, true, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") data_of_"));
        txt = Tpl.writeText(txt, l_shortTypeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array(&"));
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_exp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_649;

public function daeExternalCExp
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  DAE.Type ret_0;
algorithm
  ret_0 := Expression.typeof(a_exp);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_649(txt, ret_0, a_exp, a_context, a_preExp, a_varDecls);
end daeExternalCExp;

public function daeExpSconst
  input Tpl.Text txt;
  input String a_string;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("\""));
  ret_0 := Util.escapeModelicaStringToCString(a_string);
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpSconst;

protected function fun_652
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_context, in_a_cr, in_a_t, in_a_varDecls, in_a_preExp, in_a_exp)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      DAE.Type a_t;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp a_exp;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           _,
           a_varDecls,
           a_preExp,
           a_exp )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs2(txt, a_exp, i_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_cr,
           a_t,
           a_varDecls,
           a_preExp,
           _ )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRecordCrefRhs(txt, a_t, a_cr, i_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_652;

public function daeExpCrefRhs
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cr;
      DAE.Type i_t;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.CREF(componentRef = i_cr, ty = (i_t as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _))))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_652(txt, a_context, i_cr, i_t, a_varDecls, a_preExp, i_exp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_FUNC(builtin = _)),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr)boxptr_"));
        txt = crefFunctionName(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _)),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr) _"));
        txt = crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs2(txt, i_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCrefRhs;

protected function lm_654
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_654(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_654(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_654;

protected function lm_655
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_655(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_655(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_655;

protected function fun_656
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr, in_a_arrName)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text a_arrName;
      DAE.Dimensions i_et_dims;
      Tpl.Text txt_1;
      String ret_1;
      list<DAE.Subscript> ret_0;

    case ( txt,
           DAE.T_ARRAY(dims = i_et_dims),
           _,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&"));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")["));
        ret_0 = ComponentReference.crefSubs(a_cr);
        (txt, a_preExp, a_varDecls) = threadDimSubList(txt, i_et_dims, ret_0, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr,
           a_varDecls,
           a_preExp,
           _,
           _,
           _ )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Indexing non-array "));
        ret_1 = ExpressionDump.printExpStr(a_ecr);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 4709, 28), Tpl.textString(txt_1));
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_656;

protected function fun_657
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_dimsLenStr;
  input Tpl.Text in_a_arrName;
  input Tpl.Text in_a_arrayType;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_context, in_a_ecr, in_a_dimsLenStr, in_a_arrName, in_a_arrayType, in_a_varDecls, in_a_preExp, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_dimsLenStr;
      Tpl.Text a_arrName;
      Tpl.Text a_arrayType;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.ComponentRef a_cr;
      SimCode.Context i_context;
      DAE.Type ret_2;
      list<DAE.Subscript> ret_1;
      Tpl.Text l_dimsValuesStr;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           a_dimsLenStr,
           a_arrName,
           a_arrayType,
           a_varDecls,
           a_preExp,
           a_cr )
      equation
        ret_1 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_preExp) = lm_655(l_dimsValuesStr, ret_1, a_varDecls, a_preExp, i_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*"));
        txt = Tpl.writeText(txt, a_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_element_addr(&"));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_dimsLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_context,
           a_ecr,
           _,
           a_arrName,
           _,
           a_varDecls,
           a_preExp,
           a_cr )
      equation
        ret_2 = ComponentReference.crefLastType(a_cr);
        (txt, a_varDecls, a_preExp) = fun_656(txt, ret_2, a_ecr, a_varDecls, a_preExp, i_context, a_cr, a_arrName);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_657;

protected function fun_658
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_dimsLenStr;
  input Tpl.Text in_a_arrayType;
  input Tpl.Text in_a_arrName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr, in_a_dimsLenStr, in_a_arrayType, in_a_arrName, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_dimsLenStr;
      Tpl.Text a_arrayType;
      Tpl.Text a_arrName;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      list<DAE.Subscript> ret_1;
      Tpl.Text l_dimsValuesStr;

    case ( txt,
           "metatype_array",
           _,
           _,
           _,
           a_arrName,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        ret_1 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_preExp) = lm_654(l_dimsValuesStr, ret_1, a_varDecls, a_preExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.CREF */"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr,
           a_dimsLenStr,
           a_arrayType,
           a_arrName,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        (txt, a_varDecls, a_preExp) = fun_657(txt, a_context, a_ecr, a_dimsLenStr, a_arrName, a_arrayType, a_varDecls, a_preExp, a_cr);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_658;

protected function fun_659
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      String str_9;
      Integer ret_8;
      list<DAE.Subscript> ret_7;
      Tpl.Text l_dimsLenStr;
      DAE.ComponentRef ret_5;
      list<DAE.Subscript> ret_4;
      Tpl.Text l_spec1;
      Tpl.Text l_tmp;
      Tpl.Text l_arrayType;
      Tpl.Text l_arrName;

    case ( txt,
           false,
           _,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        l_arrName = contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayType), a_varDecls);
        ret_4 = ComponentReference.crefSubs(a_cr);
        (l_spec1, a_preExp, a_varDecls) = daeExpCrefRhsIndexSpec(Tpl.emptyTxt, ret_4, a_context, a_preExp, a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("index_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_arrayType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, l_arrName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_spec1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_ecr,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_5 = ComponentReference.crefStripLastSubs(a_cr);
        l_arrName = contextCref(Tpl.emptyTxt, ret_5, a_context);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        ret_7 = ComponentReference.crefSubs(a_cr);
        ret_8 = listLength(ret_7);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_8));
        str_9 = Tpl.textString(l_arrayType);
        (txt, a_varDecls, a_preExp) = fun_658(txt, str_9, a_ecr, l_dimsLenStr, l_arrayType, l_arrName, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_659;

protected function fun_660
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(modelica_integer)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_660;

protected function fun_661
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_ecr, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text l_cast;
      Boolean ret_0;

    case ( txt,
           false,
           a_ecr,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.crefSubIsScalar(a_cr);
        (txt, a_preExp, a_varDecls) = fun_659(txt, ret_0, a_ecr, a_preExp, a_varDecls, a_ty, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        l_cast = fun_660(Tpl.emptyTxt, a_ty);
        txt = Tpl.writeText(txt, l_cast);
        txt = contextCref(txt, a_cr, a_context);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_661;

protected function fun_662
  input Tpl.Text in_txt;
  input Tpl.Text in_a_box;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_box, in_a_ecr, in_a_preExp, in_a_varDecls, in_a_ty, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Exp a_ecr;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text i_box;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_ecr,
           a_preExp,
           a_varDecls,
           a_ty,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.crefIsScalar(a_cr, a_context);
        (txt, a_preExp, a_varDecls) = fun_661(txt, ret_0, a_ecr, a_preExp, a_varDecls, a_ty, a_context, a_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_box,
           _,
           a_preExp,
           a_varDecls,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_box);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_662;

public function daeExpCrefRhs2
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;
      DAE.ComponentRef i_cr;
      DAE.Exp i_ecr;
      Tpl.Text txt_1;
      String ret_1;
      Tpl.Text l_box;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = i_cr, ty = i_ty)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_box, a_preExp, a_varDecls) = daeExpCrefRhsArrayBox(Tpl.emptyTxt, i_ecr, a_context, a_preExp, a_varDecls);
        (txt, a_preExp, a_varDecls) = fun_662(txt, l_box, i_ecr, a_preExp, a_varDecls, i_ty, a_context, i_cr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_ecr,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("daeExpCrefRhs2: UNHANDLED EXPRESSION: "));
        ret_1 = ExpressionDump.printExpStr(i_ecr);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 4722, 11), Tpl.textString(txt_1));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCrefRhs2;

protected function fun_664
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_dim;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_dim)
    local
      Tpl.Text txt;
      Integer i_size;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_ENUM(size = i_size) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeStr(txt, intString(i_size));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 4741, 22), "Non-constant dimension in simulation context");
      then txt;
  end matchcontinue;
end fun_664;

protected function lm_665
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = fun_664(txt, i_dim);
        txt = lm_665(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_665(txt, rest);
      then txt;
  end matchcontinue;
end lm_665;

protected function fun_666
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subrest;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<DAE.Dimension> in_a_dimrest;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_subrest, in_a_varDecls, in_a_preExp, in_a_context, in_a_dimrest)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Dimension> a_dimrest;
      list<DAE.Subscript> i_subrest;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_subrest,
           a_varDecls,
           a_preExp,
           a_context,
           a_dimrest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        (txt, a_preExp, a_varDecls) = threadDimSubList(txt, a_dimrest, i_subrest, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_666;

protected function fun_667
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_a_dims;
  input list<DAE.Subscript> in_a_subrest;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_sub_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_dims, in_a_subrest, in_a_varDecls, in_a_preExp, in_a_context, in_a_sub_exp)
    local
      Tpl.Text txt;
      list<DAE.Subscript> a_subrest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_sub_exp;
      list<DAE.Dimension> i_dimrest;
      Tpl.Text l_estr;

    case ( txt,
           _ :: i_dimrest,
           a_subrest,
           a_varDecls,
           a_preExp,
           a_context,
           a_sub_exp )
      equation
        (l_estr, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_sub_exp, a_context, a_preExp, a_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(("));
        txt = Tpl.writeText(txt, l_estr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = lm_665(txt, i_dimrest);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        (txt, a_varDecls, a_preExp) = fun_666(txt, a_subrest, a_varDecls, a_preExp, a_context, i_dimrest);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 4743, 18), "Less subscripts that dimensions in indexing cref? That\'s odd!");
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_667;

protected function fun_668
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subs;
  input list<DAE.Dimension> in_a_dims;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_subs, in_a_dims, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Dimension> a_dims;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Subscript> i_subrest;
      DAE.Exp i_sub_exp;

    case ( txt,
           {},
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 4729, 22), "Empty dimensions in indexing cref?");
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.INDEX(exp = i_sub_exp) :: i_subrest,
           a_dims,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_667(txt, a_dims, i_subrest, a_varDecls, a_preExp, a_context, i_sub_exp);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 4744, 14), "Non-index subscript in indexing cref? That\'s odd!");
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_668;

public function threadDimSubList
  input Tpl.Text txt;
  input list<DAE.Dimension> a_dims;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_668(txt, a_subs, a_dims, a_context, a_preExp, a_varDecls);
end threadDimSubList;

protected function fun_670
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_sub;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_sub, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;
      Tpl.Text l_tmp;
      Tpl.Text l_str;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(0), make_index_array(1, (int) "));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'S\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.WHOLEDIM(),
           a_varDecls,
           a_preExp,
           _ )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(1), (int*)0, \'W\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_integer", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = size_of_dimension_integer_array("));
        a_preExp = Tpl.writeText(a_preExp, l_expPart);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", 1);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(int) "));
        l_str = Tpl.writeText(l_str, l_tmp);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING(", integer_array_make_index_array(&"));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'A\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_670;

protected function lm_671
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Subscript i_sub;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_sub :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = fun_670(txt, i_sub, a_varDecls, a_preExp, a_context);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_671(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = lm_671(txt, rest, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_671;

public function daeExpCrefRhsIndexSpec
  input Tpl.Text txt;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
  Tpl.Text l_idx__str;
  Integer ret_1;
  Tpl.Text l_nridx__str;
algorithm
  ret_1 := listLength(a_subs);
  l_nridx__str := Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
  l_idx__str := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_idx__str, out_a_varDecls, out_a_preExp) := lm_671(l_idx__str, a_subs, a_varDecls, a_preExp, a_context);
  l_idx__str := Tpl.popIter(l_idx__str);
  (l_tmp, out_a_varDecls) := tempDecl(Tpl.emptyTxt, "index_spec_t", out_a_varDecls);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING("create_index_spec(&"));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_tmp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(", "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_nridx__str);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(", "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_idx__str);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(");"));
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_tmp);
end daeExpCrefRhsIndexSpec;

protected function lm_673
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_673(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_673(txt, rest);
      then txt;
  end matchcontinue;
end lm_673;

protected function fun_674
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_preExp;
  input DAE.Dimensions in_a_dims;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_aty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_context, in_a_ecr_componentRef, in_a_preExp, in_a_dims, in_a_varDecls, in_a_aty)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_preExp;
      DAE.Dimensions a_dims;
      Tpl.Text a_varDecls;
      DAE.Type a_aty;
      Tpl.Text l_type;
      Tpl.Text l_dimsValuesStr;
      Integer ret_3;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_1;
      Tpl.Text l_tmpArr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           a_preExp,
           _,
           a_varDecls,
           _ )
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_preExp,
           a_dims,
           a_varDecls,
           a_aty )
      equation
        txt_1 = expTypeArray(Tpl.emptyTxt, a_aty);
        (l_tmpArr, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        ret_3 = listLength(a_dims);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dimsValuesStr = lm_673(l_dimsValuesStr, a_dims);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        l_type = expTypeShort(Tpl.emptyTxt, a_aty);
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_array_create(&"));
        a_preExp = Tpl.writeText(a_preExp, l_tmpArr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", ((modelica_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("*)&("));
        a_preExp = arrayCrefCStr(a_preExp, a_ecr_componentRef);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")), "));
        a_preExp = Tpl.writeText(a_preExp, l_dimsLenStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_dimsValuesStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpArr);
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_674;

public function daeExpCrefRhsArrayBox
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.Dimensions i_dims;
      DAE.Type i_aty;

    case ( txt,
           DAE.CREF(ty = DAE.T_ARRAY(ty = i_aty, dims = i_dims), componentRef = i_ecr_componentRef),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = fun_674(txt, a_context, i_ecr_componentRef, a_preExp, i_dims, a_varDecls, i_aty);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpCrefRhsArrayBox;

protected function lm_676
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_preExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.Var i_v;
      DAE.Exp ret_0;

    case ( txt,
           {},
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_v :: rest,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.makeCrefRecordExp(a_cr, i_v);
        (txt, a_preExp, a_varDecls) = daeExp(txt, ret_0, a_context, a_preExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_676(txt, rest, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_preExp,
           a_context,
           a_cr )
      equation
        (txt, a_varDecls, a_preExp) = lm_676(txt, rest, a_varDecls, a_preExp, a_context, a_cr);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end lm_676;

public function daeExpRecordCrefRhs
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_cr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      ClassInf.State i_record__state;
      list<DAE.Var> i_var__lst;
      Tpl.Text l_ret__var;
      Tpl.Text l_ret__type;
      Absyn.Path ret_2;
      Tpl.Text l_record__type__name;
      Tpl.Text l_vars;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_record__state, varLst = i_var__lst),
           a_cr,
           a_context,
           a_preExp,
           a_varDecls )
      equation
        l_vars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_vars, a_varDecls, a_preExp) = lm_676(l_vars, i_var__lst, a_varDecls, a_preExp, a_context, a_cr);
        l_vars = Tpl.popIter(l_vars);
        ret_2 = ClassInf.getStateName(i_record__state);
        l_record__type__name = underscorePath(Tpl.emptyTxt, ret_2);
        l_ret__type = Tpl.writeText(Tpl.emptyTxt, l_record__type__name);
        l_ret__type = Tpl.writeTok(l_ret__type, Tpl.ST_STRING("_rettype"));
        (l_ret__var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ret__type), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_ret__var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = _"));
        a_preExp = Tpl.writeText(a_preExp, l_record__type__name);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_vars);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_ret__var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c1"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpRecordCrefRhs;

protected function fun_678
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_a_context, in_a_cr, in_a_t, in_a_varDecls, in_a_afterExp, in_a_exp)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      DAE.Type a_t;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      DAE.Exp a_exp;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           _,
           a_varDecls,
           a_afterExp,
           a_exp )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpCrefLhs2(txt, a_exp, i_context, a_afterExp, a_varDecls);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_context,
           a_cr,
           a_t,
           a_varDecls,
           a_afterExp,
           _ )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpRecordCrefLhs(txt, a_t, a_cr, i_context, a_afterExp, a_varDecls);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_678;

public function daeExpCrefLhs
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cr;
      DAE.Type i_t;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.CREF(componentRef = i_cr, ty = (i_t as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _))))),
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_afterExp) = fun_678(txt, a_context, i_cr, i_t, a_varDecls, a_afterExp, i_exp);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_FUNC(builtin = _)),
           _,
           a_afterExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr)boxptr_"));
        txt = crefFunctionName(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _)),
           _,
           a_afterExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((modelica_fnptr) _"));
        txt = crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           i_exp,
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        (txt, a_afterExp, a_varDecls) = daeExpCrefLhs2(txt, i_exp, a_context, a_afterExp, a_varDecls);
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end daeExpCrefLhs;

protected function lm_680
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_afterExp, a_varDecls) = daeExp(txt, i_exp, a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_680(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_varDecls, a_afterExp) = lm_680(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_680;

protected function fun_681
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_dimsLenStr;
  input Tpl.Text in_a_arrayType;
  input Tpl.Text in_a_dimsValuesStr;
  input Tpl.Text in_a_arrName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_dimsLenStr, in_a_arrayType, in_a_dimsValuesStr, in_a_arrName)
    local
      Tpl.Text txt;
      Tpl.Text a_dimsLenStr;
      Tpl.Text a_arrayType;
      Tpl.Text a_dimsValuesStr;
      Tpl.Text a_arrName;

    case ( txt,
           "metatype_array",
           _,
           _,
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("arrayGet("));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") /* DAE.CREF */"));
      then txt;

    case ( txt,
           _,
           a_dimsLenStr,
           a_arrayType,
           a_dimsValuesStr,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*"));
        txt = Tpl.writeText(txt, a_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_element_addr(&"));
        txt = Tpl.writeText(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_dimsLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;
  end matchcontinue;
end fun_681;

protected function fun_682
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_afterExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls, in_a_ty, in_a_context, in_a_cr, in_a_ecr, in_a_afterExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.Exp a_ecr;
      Tpl.Text a_afterExp;
      String str_13;
      list<DAE.Subscript> ret_12;
      Tpl.Text l_dimsValuesStr;
      Integer ret_10;
      list<DAE.Subscript> ret_9;
      Tpl.Text l_dimsLenStr;
      DAE.ComponentRef ret_7;
      String ret_6;
      list<DAE.Subscript> ret_5;
      Tpl.Text l_spec1;
      Tpl.Text l_tmp;
      Tpl.Text l_arrayType;
      Tpl.Text l_arrName;
      String ret_0;

    case ( txt,
           false,
           a_varDecls,
           a_ty,
           a_context,
           a_cr,
           a_ecr,
           a_afterExp )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 SLICE("));
        ret_0 = ExpressionDump.printExpStr(a_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_0);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") afterExp  */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        l_arrName = contextArrayCref(Tpl.emptyTxt, a_cr, a_context);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_arrayType), a_varDecls);
        ret_5 = ComponentReference.crefSubs(a_cr);
        (l_spec1, a_afterExp, a_varDecls) = daeExpCrefLhsIndexSpec(Tpl.emptyTxt, ret_5, a_context, a_afterExp, a_varDecls);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("indexed_assign_"));
        a_afterExp = Tpl.writeText(a_afterExp, l_arrayType);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("(&"));
        a_afterExp = Tpl.writeText(a_afterExp, l_tmp);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", &"));
        a_afterExp = Tpl.writeText(a_afterExp, l_arrName);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", &"));
        a_afterExp = Tpl.writeText(a_afterExp, l_spec1);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(");"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _,
           a_varDecls,
           a_ty,
           a_context,
           a_cr,
           a_ecr,
           a_afterExp )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 SCALAR("));
        ret_6 = ExpressionDump.printExpStr(a_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_6);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") afterExp  */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        ret_7 = ComponentReference.crefStripLastSubs(a_cr);
        l_arrName = contextCref(Tpl.emptyTxt, ret_7, a_context);
        l_arrayType = expTypeArray(Tpl.emptyTxt, a_ty);
        ret_9 = ComponentReference.crefSubs(a_cr);
        ret_10 = listLength(ret_9);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_10));
        ret_12 = ComponentReference.crefSubs(a_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_varDecls, a_afterExp) = lm_680(l_dimsValuesStr, ret_12, a_varDecls, a_afterExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        str_13 = Tpl.textString(l_arrayType);
        txt = fun_681(txt, str_13, l_dimsLenStr, l_arrayType, l_dimsValuesStr, l_arrName);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_682;

protected function fun_683
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_afterExp;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls, in_a_ty, in_a_context, in_a_ecr, in_a_afterExp, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      SimCode.Context a_context;
      DAE.Exp a_ecr;
      Tpl.Text a_afterExp;
      DAE.ComponentRef a_cr;
      Boolean ret_0;

    case ( txt,
           false,
           a_varDecls,
           a_ty,
           a_context,
           a_ecr,
           a_afterExp,
           a_cr )
      equation
        ret_0 = SimCode.crefSubIsScalar(a_cr);
        (txt, a_varDecls, a_afterExp) = fun_682(txt, ret_0, a_varDecls, a_ty, a_context, a_cr, a_ecr, a_afterExp);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _,
           a_varDecls,
           _,
           a_context,
           _,
           a_afterExp,
           a_cr )
      equation
        txt = contextCref(txt, a_cr, a_context);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_683;

protected function fun_684
  input Tpl.Text in_txt;
  input Tpl.Text in_a_box;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_ty;
  input DAE.Exp in_a_ecr;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_a_box, in_a_varDecls, in_a_ty, in_a_ecr, in_a_afterExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      DAE.Type a_ty;
      DAE.Exp a_ecr;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text i_box;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_varDecls,
           a_ty,
           a_ecr,
           a_afterExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.crefIsScalar(a_cr, a_context);
        (txt, a_varDecls, a_afterExp) = fun_683(txt, ret_0, a_varDecls, a_ty, a_context, a_ecr, a_afterExp, a_cr);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_box,
           a_varDecls,
           _,
           _,
           a_afterExp,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_box);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_684;

public function daeExpCrefLhs2
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;
      DAE.ComponentRef i_cr;
      DAE.Exp i_ecr;
      String ret_3;
      String ret_2;
      Tpl.Text l_box;
      String ret_0;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = i_cr, ty = i_ty)),
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 begin afterExp ("));
        ret_0 = ExpressionDump.printExpStr(i_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_0);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        (l_box, a_afterExp, a_varDecls) = daeExpCrefLhsArrayBox(Tpl.emptyTxt, i_ecr, a_context, a_afterExp, a_varDecls);
        (txt, a_varDecls, a_afterExp) = fun_684(txt, l_box, a_varDecls, i_ty, i_ecr, a_afterExp, a_context, i_cr);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           i_ecr,
           _,
           a_afterExp,
           a_varDecls )
      equation
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("/* daeExpCrefLhs2 UNHANDLED("));
        ret_2 = ExpressionDump.printExpStr(i_ecr);
        a_afterExp = Tpl.writeStr(a_afterExp, ret_2);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(") afterExp */"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* SimCodeC.tpl template: daeExpCrefLhs2: UNHANDLED EXPRESSION:\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* "));
        ret_3 = ExpressionDump.printExpStr(i_ecr);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
        txt = Tpl.popBlock(txt);
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end daeExpCrefLhs2;

protected function fun_686
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_sub;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_a_sub, in_a_varDecls, in_a_afterExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;
      Tpl.Text l_tmp;
      Tpl.Text l_str;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (l_expPart, a_afterExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_afterExp, a_varDecls);
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(0), make_index_array(1, (int) "));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'S\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           DAE.WHOLEDIM(),
           a_varDecls,
           a_afterExp,
           _ )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(1), (int*)0, \'W\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (l_expPart, a_afterExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_afterExp, a_varDecls);
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_integer", a_varDecls);
        a_afterExp = Tpl.writeText(a_afterExp, l_tmp);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(" = size_of_dimension_integer_array("));
        a_afterExp = Tpl.writeText(a_afterExp, l_expPart);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", 1);"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("(int) "));
        l_str = Tpl.writeText(l_str, l_tmp);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING(", integer_array_make_index_array(&"));
        l_str = Tpl.writeText(l_str, l_expPart);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("), \'A\'"));
        txt = Tpl.writeText(txt, l_str);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _,
           a_varDecls,
           a_afterExp,
           _ )
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end fun_686;

protected function lm_687
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.Subscript i_sub;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_sub :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_varDecls, a_afterExp) = fun_686(txt, i_sub, a_varDecls, a_afterExp, a_context);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_687(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context )
      equation
        (txt, a_varDecls, a_afterExp) = lm_687(txt, rest, a_varDecls, a_afterExp, a_context);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_687;

public function daeExpCrefLhsIndexSpec
  input Tpl.Text txt;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_afterExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_tmp;
  Tpl.Text l_idx__str;
  Integer ret_1;
  Tpl.Text l_nridx__str;
algorithm
  ret_1 := listLength(a_subs);
  l_nridx__str := Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
  l_idx__str := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_idx__str, out_a_varDecls, out_a_afterExp) := lm_687(l_idx__str, a_subs, a_varDecls, a_afterExp, a_context);
  l_idx__str := Tpl.popIter(l_idx__str);
  (l_tmp, out_a_varDecls) := tempDecl(Tpl.emptyTxt, "index_spec_t", out_a_varDecls);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING("create_index_spec(&"));
  out_a_afterExp := Tpl.writeText(out_a_afterExp, l_tmp);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING(", "));
  out_a_afterExp := Tpl.writeText(out_a_afterExp, l_nridx__str);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING(", "));
  out_a_afterExp := Tpl.writeText(out_a_afterExp, l_idx__str);
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_STRING(");"));
  out_a_afterExp := Tpl.writeTok(out_a_afterExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_tmp);
end daeExpCrefLhsIndexSpec;

protected function lm_689
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_689(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_689(txt, rest);
      then txt;
  end matchcontinue;
end lm_689;

protected function fun_690
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_afterExp;
  input DAE.Dimensions in_a_dims;
  input Tpl.Text in_a_varDecls;
  input DAE.Type in_a_aty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_context, in_a_ecr_componentRef, in_a_afterExp, in_a_dims, in_a_varDecls, in_a_aty)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_afterExp;
      DAE.Dimensions a_dims;
      Tpl.Text a_varDecls;
      DAE.Type a_aty;
      Tpl.Text l_type;
      Tpl.Text l_dimsValuesStr;
      Integer ret_3;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_1;
      Tpl.Text l_tmpArr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           _,
           a_afterExp,
           _,
           a_varDecls,
           _ )
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_afterExp,
           a_dims,
           a_varDecls,
           a_aty )
      equation
        txt_1 = expTypeArray(Tpl.emptyTxt, a_aty);
        (l_tmpArr, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        ret_3 = listLength(a_dims);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dimsValuesStr = lm_689(l_dimsValuesStr, a_dims);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        l_type = expTypeShort(Tpl.emptyTxt, a_aty);
        a_afterExp = Tpl.writeText(a_afterExp, l_type);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("_array_create(&"));
        a_afterExp = Tpl.writeText(a_afterExp, l_tmpArr);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", ((modelica_"));
        a_afterExp = Tpl.writeText(a_afterExp, l_type);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("*)&("));
        a_afterExp = arrayCrefCStr(a_afterExp, a_ecr_componentRef);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(")), "));
        a_afterExp = Tpl.writeText(a_afterExp, l_dimsLenStr);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(", "));
        a_afterExp = Tpl.writeText(a_afterExp, l_dimsValuesStr);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(");"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpArr);
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end fun_690;

public function daeExpCrefLhsArrayBox
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ecr, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.Dimensions i_dims;
      DAE.Type i_aty;

    case ( txt,
           DAE.CREF(ty = DAE.T_ARRAY(ty = i_aty, dims = i_dims), componentRef = i_ecr_componentRef),
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        (txt, a_afterExp, a_varDecls) = fun_690(txt, a_context, i_ecr_componentRef, a_afterExp, i_dims, a_varDecls, i_aty);
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_afterExp,
           a_varDecls )
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end daeExpCrefLhsArrayBox;

protected function lm_692
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_afterExp;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_afterExp;
algorithm
  (out_txt, out_a_varDecls, out_a_afterExp) :=
  matchcontinue(in_txt, in_items, in_a_varDecls, in_a_afterExp, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_varDecls;
      Tpl.Text a_afterExp;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      DAE.Var i_v;
      DAE.Exp ret_0;

    case ( txt,
           {},
           a_varDecls,
           a_afterExp,
           _,
           _ )
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           i_v :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_cr )
      equation
        ret_0 = SimCode.makeCrefRecordExp(a_cr, i_v);
        (txt, a_afterExp, a_varDecls) = daeExp(txt, ret_0, a_context, a_afterExp, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_afterExp) = lm_692(txt, rest, a_varDecls, a_afterExp, a_context, a_cr);
      then (txt, a_varDecls, a_afterExp);

    case ( txt,
           _ :: rest,
           a_varDecls,
           a_afterExp,
           a_context,
           a_cr )
      equation
        (txt, a_varDecls, a_afterExp) = lm_692(txt, rest, a_varDecls, a_afterExp, a_context, a_cr);
      then (txt, a_varDecls, a_afterExp);
  end matchcontinue;
end lm_692;

public function daeExpRecordCrefLhs
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_cr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_afterExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_afterExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_afterExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_ty, in_a_cr, in_a_context, in_a_afterExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.Context a_context;
      Tpl.Text a_afterExp;
      Tpl.Text a_varDecls;
      ClassInf.State i_record__state;
      list<DAE.Var> i_var__lst;
      Tpl.Text l_ret__var;
      Tpl.Text l_ret__type;
      Absyn.Path ret_2;
      Tpl.Text l_record__type__name;
      Tpl.Text l_vars;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_record__state, varLst = i_var__lst),
           a_cr,
           a_context,
           a_afterExp,
           a_varDecls )
      equation
        l_vars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_vars, a_varDecls, a_afterExp) = lm_692(l_vars, i_var__lst, a_varDecls, a_afterExp, a_context, a_cr);
        l_vars = Tpl.popIter(l_vars);
        ret_2 = ClassInf.getStateName(i_record__state);
        l_record__type__name = underscorePath(Tpl.emptyTxt, ret_2);
        l_ret__type = Tpl.writeText(Tpl.emptyTxt, l_record__type__name);
        l_ret__type = Tpl.writeTok(l_ret__type, Tpl.ST_STRING("_rettype"));
        (l_ret__var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ret__type), a_varDecls);
        a_afterExp = Tpl.writeText(a_afterExp, l_ret__var);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(" = _"));
        a_afterExp = Tpl.writeText(a_afterExp, l_record__type__name);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING("("));
        a_afterExp = Tpl.writeText(a_afterExp, l_vars);
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_STRING(");"));
        a_afterExp = Tpl.writeTok(a_afterExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_ret__var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c1"));
      then (txt, a_afterExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_afterExp,
           a_varDecls )
      then (txt, a_afterExp, a_varDecls);
  end matchcontinue;
end daeExpRecordCrefLhs;

protected function fun_694
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;

    case ( txt,
           false,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "modelica_string", a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      equation
        (txt, a_varDecls) = tempDecl(txt, "modelica_metatype", a_varDecls);
      then (txt, a_varDecls);
  end matchcontinue;
end fun_694;

protected function fun_695
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_tmpStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg, in_a_e2, in_a_e1, in_a_tmpStr)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_tmpStr;

    case ( txt,
           false,
           a_e2,
           a_e1,
           a_tmpStr )
      equation
        txt = Tpl.writeText(txt, a_tmpStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = cat_modelica_string("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           a_e2,
           a_e1,
           a_tmpStr )
      equation
        txt = Tpl.writeText(txt, a_tmpStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = stringAppend("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end matchcontinue;
end fun_695;

protected function fun_696
  input Tpl.Text in_txt;
  input Option<Integer> in_mArg;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_e2, in_a_e1, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Integer i_i;
      Tpl.Text l_tmp;

    case ( txt,
           SOME(2),
           _,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_real", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SOME(3),
           _,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_real", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SOME(4),
           _,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_real", a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" *= "));
        a_preExp = Tpl.writeText(a_preExp, l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           SOME(i_i),
           _,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_int_pow("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pow("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_696;

protected function fun_697
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input DAE.Exp in_a_exp2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_mArg, in_a_e2, in_a_e1, in_a_preExp, in_a_varDecls, in_a_exp2)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp a_exp2;
      Option<Integer> ret_0;

    case ( txt,
           false,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls,
           a_exp2 )
      equation
        ret_0 = Expression.realExpIntLit(a_exp2);
        (txt, a_preExp, a_varDecls) = fun_696(txt, ret_0, a_e2, a_e1, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_e1,
           a_preExp,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("sqrt("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_697;

protected function fun_698
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_698;

protected function fun_699
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_699;

protected function fun_700
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_700;

protected function fun_701
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_scalar"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_scalar"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_scalar"));
      then txt;
  end matchcontinue;
end fun_701;

protected function fun_702
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;
  end matchcontinue;
end fun_702;

protected function fun_703
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real_array"));
      then txt;
  end matchcontinue;
end fun_703;

protected function fun_704
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_exp;
  input DAE.Exp in_a_exp2;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_operator, in_a_context, in_a_exp, in_a_exp2, in_a_e2, in_a_e1, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      DAE.Exp a_exp;
      DAE.Exp a_exp2;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;
      Tpl.Text l_typeShort;
      Tpl.Text l_var;
      Tpl.Text l_type;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Tpl.Text l_tmpStr;

    case ( txt,
           DAE.ADD(ty = DAE.T_STRING(varLst = _)),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        ret_1 = Config.acceptMetaModelicaGrammar();
        (l_tmpStr, a_varDecls) = fun_694(Tpl.emptyTxt, ret_1, a_varDecls);
        ret_2 = Config.acceptMetaModelicaGrammar();
        a_preExp = fun_695(a_preExp, ret_2, a_e2, a_e1, l_tmpStr);
        txt = Tpl.writeText(txt, l_tmpStr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ADD(ty = _),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SUB(ty = _),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL(ty = _),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV(ty = _),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" / "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW(ty = _),
           _,
           _,
           a_exp2,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        ret_3 = Expression.isHalf(a_exp2);
        (txt, a_preExp, a_varDecls) = fun_697(txt, ret_3, a_e2, a_e1, a_preExp, a_varDecls, a_exp2);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.UMINUS(ty = _),
           a_context,
           a_exp,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnary(txt, a_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ADD_ARR(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_698(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("add_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SUB_ARR(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_699(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("sub_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_ARR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for MUL_ARR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV_ARR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for DIV_ARR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_700(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("mul_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_scalar(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for ADD_ARRAY_SCALAR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for SUB_SCALAR_ARRAY"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_701(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mul_"));
        txt = Tpl.writeText(txt, l_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_product(&"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_typeShort = fun_702(Tpl.emptyTxt, i_ty);
        l_type = Tpl.writeText(Tpl.emptyTxt, l_typeShort);
        l_type = Tpl.writeTok(l_type, Tpl.ST_STRING("_array"));
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("mul_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_typeShort);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_matrix_product_smart(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = i_ty),
           _,
           _,
           _,
           a_e2,
           a_e1,
           a_preExp,
           a_varDecls )
      equation
        l_type = fun_703(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_type), a_varDecls);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("div_alloc_"));
        a_preExp = Tpl.writeText(a_preExp, l_type);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("_scalar(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", &"));
        a_preExp = Tpl.writeText(a_preExp, l_var);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for DIV_SCALAR_ARRAY"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_ARRAY_SCALAR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_SCALAR_ARRAY"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW_ARR(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_ARR"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.POW_ARR2(ty = _),
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR for POW_ARR2"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_704;

public function daeExpBinary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           (i_exp as DAE.BINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        (txt, a_preExp, a_varDecls) = fun_704(txt, i_operator, a_context, i_exp, i_exp2, l_e2, l_e1, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpBinary;

protected function fun_706
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_operator, in_a_preExp, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_e;

    case ( txt,
           DAE.UMINUS(ty = _),
           a_preExp,
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(-"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.UMINUS_ARR(ty = DAE.T_ARRAY(ty = DAE.T_REAL(varLst = _))),
           a_preExp,
           a_e )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("usub_real_array(&"));
        a_preExp = Tpl.writeText(a_preExp, a_e);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_e);
      then (txt, a_preExp);

    case ( txt,
           DAE.UMINUS_ARR(ty = _),
           a_preExp,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 5072, 34), "unary minus for non-real arrays not implemented");
      then (txt, a_preExp);

    case ( txt,
           _,
           a_preExp,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenC.tpl", 5073, 14), "daeExpUnary:ERR");
      then (txt, a_preExp);
  end matchcontinue;
end fun_706;

public function daeExpUnary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.UNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (txt, a_preExp) = fun_706(txt, i_operator, a_preExp, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpUnary;

protected function fun_708
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.AND(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.OR(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpLbinary:ERR"));
      then txt;
  end matchcontinue;
end fun_708;

public function daeExpLbinary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           DAE.LBINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        txt = fun_708(txt, i_operator, l_e2, l_e1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpLbinary;

protected function fun_710
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_operator, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_e;

    case ( txt,
           DAE.NOT(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_710;

public function daeExpLunary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.LUNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = fun_710(txt, i_operator, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpLunary;

protected function fun_712
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.LESS(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") < 0)"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") > 0)"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") <= 0)"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringCompare("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") >= 0)"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(stringEqual("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!stringEqual("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpRelation:ERR"));
      then txt;
  end matchcontinue;
end fun_712;

protected function fun_713
  input Tpl.Text in_txt;
  input Tpl.Text in_a_simRel;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_simRel, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Tpl.Text i_simRel;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        txt = fun_712(txt, a_rel_operator, l_e2, l_e1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_simRel,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_simRel);
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_713;

public function daeExpRelation
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_rel_operator;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      DAE.Exp i_rel;
      Tpl.Text l_simRel;

    case ( txt,
           (i_rel as DAE.RELATION(exp1 = i_rel_exp1, exp2 = i_rel_exp2, operator = i_rel_operator)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_simRel, a_preExp, a_varDecls) = daeExpRelationSim(Tpl.emptyTxt, i_rel, a_context, a_preExp, a_varDecls);
        (txt, a_varDecls, a_preExp) = fun_713(txt, l_simRel, i_rel_operator, i_rel_exp2, a_varDecls, a_preExp, a_context, i_rel_exp1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpRelation;

protected function fun_715
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_rel_index, in_a_e2, in_a_e1, in_a_res, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_res;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Less,<);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",LessEq,<=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Greater,>);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",GreaterEq,>=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end matchcontinue;
end fun_715;

protected function fun_716
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Integer in_a_j;
  input Integer in_a_i;
  input Tpl.Text in_a_iterator;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_j, in_a_i, in_a_iterator, in_a_rel_index, in_a_e2, in_a_e1, in_a_res, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_j;
      Integer a_i;
      Tpl.Text a_iterator;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_res;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Less,<);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",LessEq,<=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Greater,>);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("RELATIONTOZC("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",GreaterEq,>=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end matchcontinue;
end fun_716;

protected function fun_717
  input Tpl.Text in_txt;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;
  input Integer in_a_rel_index;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_optionExpisASUB, in_a_rel_index, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Integer i_j;
      Integer i_i;
      DAE.Exp i_exp;
      Tpl.Text l_iterator;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           NONE(),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (txt, a_preExp) = fun_715(txt, a_rel_operator, a_rel_index, l_e2, l_e1, l_res, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           SOME((i_exp, i_i, i_j)),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_iterator, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (txt, a_preExp) = fun_716(txt, a_rel_operator, i_j, i_i, l_iterator, a_rel_index, l_e2, l_e1, l_res, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_717;

protected function fun_718
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_rel_index, in_a_e2, in_a_e1, in_a_res, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_res;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Less,<);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",LessEq,<=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Greater,>);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",GreaterEq,>=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end matchcontinue;
end fun_718;

protected function fun_719
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Integer in_a_j;
  input Integer in_a_i;
  input Tpl.Text in_a_iterator;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_res;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_operator, in_a_j, in_a_i, in_a_iterator, in_a_rel_index, in_a_e2, in_a_e1, in_a_res, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_j;
      Integer a_i;
      Tpl.Text a_iterator;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text a_res;
      Tpl.Text a_preExp;

    case ( txt,
           DAE.LESS(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Less,<);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",LessEq,<=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATER(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",Greater,>);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_j,
           a_i,
           a_iterator,
           a_rel_index,
           a_e2,
           a_e1,
           a_res,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("SAVEZEROCROSS("));
        a_preExp = Tpl.writeText(a_preExp, a_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(","));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" + ("));
        a_preExp = Tpl.writeText(a_preExp, a_iterator);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" - "));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_i));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")/"));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_j));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",GreaterEq,>=);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end matchcontinue;
end fun_719;

protected function fun_720
  input Tpl.Text in_txt;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;
  input Integer in_a_rel_index;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_rel_optionExpisASUB, in_a_rel_index, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_context, in_a_rel_exp1)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Integer i_j;
      Integer i_i;
      DAE.Exp i_exp;
      Tpl.Text l_iterator;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           NONE(),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (txt, a_preExp) = fun_718(txt, a_rel_operator, a_rel_index, l_e2, l_e1, l_res, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           SOME((i_exp, i_i, i_j)),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_context,
           a_rel_exp1 )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_varDecls);
        (l_res, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        (l_iterator, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        (txt, a_preExp) = fun_719(txt, a_rel_operator, i_j, i_i, l_iterator, a_rel_index, l_e2, l_e1, l_res, a_preExp);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_720;

protected function fun_721
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Integer in_a_rel_index;
  input DAE.Operator in_a_rel_operator;
  input DAE.Exp in_a_rel_exp2;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input Option<tuple<DAE.Exp, Integer, Integer>> in_a_rel_optionExpisASUB;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  matchcontinue(in_txt, in_a_context, in_a_rel_index, in_a_rel_operator, in_a_rel_exp2, in_a_varDecls, in_a_preExp, in_a_rel_exp1, in_a_rel_optionExpisASUB)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      DAE.Operator a_rel_operator;
      DAE.Exp a_rel_exp2;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      Option<tuple<DAE.Exp, Integer, Integer>> a_rel_optionExpisASUB;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.SIMULATION(genDiscrete = false)),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_rel_exp1,
           a_rel_optionExpisASUB )
      equation
        (txt, a_varDecls, a_preExp) = fun_717(txt, a_rel_optionExpisASUB, a_rel_index, a_rel_operator, a_rel_exp2, a_varDecls, a_preExp, i_context, a_rel_exp1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           (i_context as SimCode.SIMULATION(genDiscrete = true)),
           a_rel_index,
           a_rel_operator,
           a_rel_exp2,
           a_varDecls,
           a_preExp,
           a_rel_exp1,
           a_rel_optionExpisASUB )
      equation
        (txt, a_varDecls, a_preExp) = fun_720(txt, a_rel_optionExpisASUB, a_rel_index, a_rel_operator, a_rel_exp2, a_varDecls, a_preExp, i_context, a_rel_exp1);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _,
           _ )
      then (txt, a_varDecls, a_preExp);
  end matchcontinue;
end fun_721;

public function daeExpRelationSim
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Integer i_rel_index;
      DAE.Operator i_rel_operator;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      Option<tuple<DAE.Exp, Integer, Integer>> i_rel_optionExpisASUB;

    case ( txt,
           DAE.RELATION(optionExpisASUB = i_rel_optionExpisASUB, exp1 = i_rel_exp1, exp2 = i_rel_exp2, operator = i_rel_operator, index = i_rel_index),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_preExp) = fun_721(txt, a_context, i_rel_index, i_rel_operator, i_rel_exp2, a_varDecls, a_preExp, i_rel_exp1, i_rel_optionExpisASUB);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpRelationSim;

protected function fun_723
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("x"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_723;

protected function fun_724
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExpElse;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_preExpElse, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      Boolean ret_1;
      DAE.Type ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_exp )
      equation
        ret_0 = Expression.typeof(a_exp);
        ret_1 = Expression.isArrayType(ret_0);
        txt = fun_723(txt, ret_1);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_724;

protected function fun_725
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExpThen;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_preExpElse;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_preExpThen, in_a_exp, in_a_preExpElse)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      Tpl.Text a_preExpElse;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_exp,
           a_preExpElse )
      equation
        txt = fun_724(txt, a_preExpElse, a_exp);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_725;

protected function fun_726
  input Tpl.Text in_txt;
  input Tpl.Text in_a_eThen;
  input Tpl.Text in_a_resVarType;
  input Tpl.Text in_a_resVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eThen, in_a_resVarType, in_a_resVar)
    local
      Tpl.Text txt;
      Tpl.Text a_resVarType;
      Tpl.Text a_resVar;
      Tpl.Text i_eThen;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           i_eThen,
           a_resVarType,
           a_resVar )
      equation
        txt = Tpl.writeText(txt, a_resVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = Tpl.writeText(txt, a_resVarType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, i_eThen);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_726;

protected function fun_727
  input Tpl.Text in_txt;
  input Tpl.Text in_a_eElse;
  input Tpl.Text in_a_resVarType;
  input Tpl.Text in_a_resVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_eElse, in_a_resVarType, in_a_resVar)
    local
      Tpl.Text txt;
      Tpl.Text a_resVarType;
      Tpl.Text a_resVar;
      Tpl.Text i_eElse;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           _ )
      then txt;

    case ( txt,
           i_eElse,
           a_resVarType,
           a_resVar )
      equation
        txt = Tpl.writeText(txt, a_resVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = Tpl.writeText(txt, a_resVarType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, i_eElse);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_727;

protected function fun_728
  input Tpl.Text in_txt;
  input Tpl.Text in_a_shortIfExp;
  input Tpl.Text in_a_eElse;
  input Tpl.Text in_a_preExpElse;
  input Tpl.Text in_a_eThen;
  input Tpl.Text in_a_preExpThen;
  input Tpl.Text in_a_condExp;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_expThen;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_shortIfExp, in_a_eElse, in_a_preExpElse, in_a_eThen, in_a_preExpThen, in_a_condExp, in_a_preExp, in_a_expThen, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_eElse;
      Tpl.Text a_preExpElse;
      Tpl.Text a_eThen;
      Tpl.Text a_preExpThen;
      Tpl.Text a_condExp;
      Tpl.Text a_preExp;
      DAE.Exp a_expThen;
      Tpl.Text a_varDecls;
      Tpl.Text l_resVar;
      Tpl.Text l_resVarType;
      Tpl.Text l_condVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_eElse,
           a_preExpElse,
           a_eThen,
           a_preExpThen,
           a_condExp,
           a_preExp,
           a_expThen,
           a_varDecls )
      equation
        (l_condVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        l_resVarType = expTypeFromExpArrayIf(Tpl.emptyTxt, a_expThen);
        (l_resVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_resVarType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_condVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (modelica_boolean)"));
        a_preExp = Tpl.writeText(a_preExp, a_condExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if ("
                                          }, false));
        a_preExp = Tpl.writeText(a_preExp, l_condVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(") {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_preExpThen);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = fun_726(a_preExp, a_eThen, l_resVarType, l_resVar);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_preExpElse);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = fun_727(a_preExp, a_eElse, l_resVarType, l_resVar);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_resVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_eElse,
           _,
           a_eThen,
           _,
           a_condExp,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("?"));
        txt = Tpl.writeText(txt, a_eThen);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        txt = Tpl.writeText(txt, a_eElse);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end fun_728;

public function daeExpIf
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  matchcontinue(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      Tpl.Text l_shortIfExp;
      Tpl.Text l_eElse;
      Tpl.Text l_preExpElse;
      Tpl.Text l_eThen;
      Tpl.Text l_preExpThen;
      Tpl.Text l_condExp;

    case ( txt,
           (i_exp as DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_condExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_expCond, a_context, a_preExp, a_varDecls);
        l_preExpThen = Tpl.emptyTxt;
        (l_eThen, l_preExpThen, a_varDecls) = daeExp(Tpl.emptyTxt, i_expThen, a_context, l_preExpThen, a_varDecls);
        l_preExpElse = Tpl.emptyTxt;
        (l_eElse, l_preExpElse, a_varDecls) = daeExp(Tpl.emptyTxt, i_expElse, a_context, l_preExpElse, a_varDecls);
        l_shortIfExp = fun_725(Tpl.emptyTxt, l_preExpThen, i_exp, l_preExpElse);
        (txt, a_preExp, a_varDecls) = fun_728(txt, l_shortIfExp, l_eElse, l_preExpElse, l_eThen, l_preExpThen, l_condExp, a_preExp, i_expThen, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end matchcontinue;
end daeExpIf;

protected function fun_730
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_ENUMERATION(index = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer_array"));
      then