encapsulated package CodegenCSharp
"
  file:        CodegenCSharp.mo
  package:     CodegenCSharp
  description: Generated by Susan.
"

public import Tpl;

public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCode;
public import HpcOmScheduler;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))) )
      equation
        txt_0 = simulationFile(Tpl.emptyTxt, i_simCode);
        txt_1 = dotPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".cs"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateModel;

protected function fun_32
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fileNamePostfix;
  input Absyn.Path in_a_modelInfo_name;
  input Tpl.Text in_a_txtCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fileNamePostfix, in_a_modelInfo_name, in_a_txtCode)
    local
      Tpl.Text txt;
      String a_fileNamePostfix;
      Absyn.Path a_modelInfo_name;
      Tpl.Text a_txtCode;
      Tpl.Text l_fileName;
      Tpl.Text l_wrappedCode;

    case ( txt,
           false,
           _,
           _,
           a_txtCode )
      equation
        txt = Tpl.writeText(txt, a_txtCode);
      then txt;

    case ( txt,
           _,
           a_fileNamePostfix,
           a_modelInfo_name,
           a_txtCode )
      equation
        l_wrappedCode = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("// Simulation code for "));
        l_wrappedCode = dotPath(l_wrappedCode, a_modelInfo_name);
        l_wrappedCode = Tpl.writeTok(l_wrappedCode, Tpl.ST_STRING_LIST({
                                                        " generated by the OpenModelica Compiler.\n",
                                                        "\n",
                                                        "using System;\n",
                                                        "using System.Collections.Generic;\n",
                                                        "using Bodylight.Solvers;\n",
                                                        "namespace Bodylight.Models"
                                                    }, false));
        l_wrappedCode = modelNameSpace(l_wrappedCode, a_modelInfo_name);
        l_wrappedCode = Tpl.softNewLine(l_wrappedCode);
        l_wrappedCode = Tpl.writeTok(l_wrappedCode, Tpl.ST_LINE("{\n"));
        l_wrappedCode = Tpl.pushBlock(l_wrappedCode, Tpl.BT_INDENT(2));
        l_wrappedCode = Tpl.writeTok(l_wrappedCode, Tpl.ST_STRING("public partial class "));
        l_wrappedCode = lastIdentOfPath(l_wrappedCode, a_modelInfo_name);
        l_wrappedCode = Tpl.writeTok(l_wrappedCode, Tpl.ST_STRING_LIST({
                                                        " : DAESystem\n",
                                                        "{\n"
                                                    }, true));
        l_wrappedCode = Tpl.pushBlock(l_wrappedCode, Tpl.BT_INDENT(2));
        l_wrappedCode = Tpl.writeText(l_wrappedCode, a_txtCode);
        l_wrappedCode = Tpl.softNewLine(l_wrappedCode);
        l_wrappedCode = Tpl.popBlock(l_wrappedCode);
        l_wrappedCode = Tpl.writeTok(l_wrappedCode, Tpl.ST_LINE("}\n"));
        l_wrappedCode = Tpl.popBlock(l_wrappedCode);
        l_wrappedCode = Tpl.writeTok(l_wrappedCode, Tpl.ST_STRING("}"));
        l_fileName = dotPath(Tpl.emptyTxt, a_modelInfo_name);
        l_fileName = Tpl.writeTok(l_fileName, Tpl.ST_STRING("_"));
        l_fileName = Tpl.writeStr(l_fileName, a_fileNamePostfix);
        l_fileName = Tpl.writeTok(l_fileName, Tpl.ST_STRING(".cs"));
        Tpl.textFile(l_wrappedCode, Tpl.textString(l_fileName));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//-----------------------------------\n",
                                    "//#include  "
                                }, false));
        txt = Tpl.writeText(txt, l_fileName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//-----------------------------------\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end fun_32;

protected function fun_33
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_txtCode;
  input String in_a_fileNamePostfix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_txtCode, in_a_fileNamePostfix)
    local
      Tpl.Text txt;
      Tpl.Text a_txtCode;
      String a_fileNamePostfix;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_txtCode,
           a_fileNamePostfix )
      equation
        ret_0 = SimCodeUtil.isModelTooBigForCSharpInOneFile(i_simCode);
        txt = fun_32(txt, ret_0, a_fileNamePostfix, i_modelInfo_name, a_txtCode);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_33;

public function wrapIntoExtraFileIfModelTooBig
  input Tpl.Text txt;
  input Tpl.Text a_txtCode;
  input String a_fileNamePostfix;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_txtCode;
algorithm
  out_txt := fun_33(txt, a_simCode, a_txtCode, a_fileNamePostfix);
  out_a_txtCode := a_txtCode;
end wrapIntoExtraFileIfModelTooBig;

protected function fun_35
  input Tpl.Text in_txt;
  input Tpl.Text in_a_fbody;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fbody)
    local
      Tpl.Text txt;
      Tpl.Text i_fbody;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//** No functions **"));
      then txt;

    case ( txt,
           i_fbody )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("#region Functions\n"));
        txt = Tpl.writeText(txt, i_fbody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#endregion"));
      then txt;
  end match;
end fun_35;

public function simulationFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> i_relations;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<list<SimCode.SimEqSystem>> i_algebraicEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      Boolean i_useSymbolicInitialization;
      list<SimCode.SimEqSystem> i_startValueEquations;
      BackendDAE.SampleLookup i_sampleLookup;
      list<SimCode.SimEqSystem> i_residualEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_inlineEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      SimCode.ExtObjInfo i_extObjInfo;
      list<DAE.Exp> i_literals;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text l_fbody;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), literals = i_literals, extObjInfo = i_extObjInfo, initialEquations = i_initialEquations, inlineEquations = i_inlineEquations, parameterEquations = i_parameterEquations, allEquations = i_allEquations, residualEquations = i_residualEquations, sampleLookup = i_sampleLookup, startValueEquations = i_startValueEquations, useSymbolicInitialization = i_useSymbolicInitialization, odeEquations = i_odeEquations, algebraicEquations = i_algebraicEquations, whenClauses = i_whenClauses, zeroCrossings = i_zeroCrossings, relations = i_relations)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Simulation code for "));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " generated by the OpenModelica Compiler.\n",
                                    "\n",
                                    "using System;\n",
                                    "using System.Collections.Generic;\n",
                                    "using Bodylight.Solvers;\n",
                                    "\n",
                                    "namespace Bodylight.Models"
                                }, false));
        txt = modelNameSpace(txt, i_modelInfo_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public partial class "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " : DAESystem\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = modelDescription(txt, i_modelInfo, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_0 = modelMetadata(Tpl.emptyTxt, i_modelInfo, i_simCode);
        txt_0 = Tpl.softNewLine(txt_0);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_NEW_LINE());
        txt_0 = sharedLiteralDefinitions(txt_0, i_literals, i_simCode);
        (txt, txt_0) = wrapIntoExtraFileIfModelTooBig(txt, txt_0, "MetaData", i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        l_fbody = simulationFunctionsBody(Tpl.emptyTxt, i_simCode);
        txt = fun_35(txt, l_fbody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCallExternalObjectConstructors(txt, i_extObjInfo, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCallExternalObjectDestructors(txt, i_extObjInfo, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_2 = functionNonlinearResiduals(Tpl.emptyTxt, i_initialEquations, SimCode.contextAlgloopInitialisation, i_simCode);
        txt_2 = Tpl.softNewLine(txt_2);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_NEW_LINE());
        txt_2 = functionNonlinearResiduals(txt_2, i_inlineEquations, SimCode.contextAlgloop, i_simCode);
        txt_2 = Tpl.softNewLine(txt_2);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_NEW_LINE());
        txt_2 = functionNonlinearResiduals(txt_2, i_parameterEquations, SimCode.contextAlgloop, i_simCode);
        txt_2 = Tpl.softNewLine(txt_2);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_NEW_LINE());
        txt_2 = functionNonlinearResiduals(txt_2, i_allEquations, SimCode.contextAlgloop, i_simCode);
        txt_2 = Tpl.softNewLine(txt_2);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_NEW_LINE());
        txt_2 = functionInitialNonLinearSystems(txt_2, i_initialEquations, i_inlineEquations, i_parameterEquations, i_allEquations, i_simCode);
        txt_2 = Tpl.softNewLine(txt_2);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_NEW_LINE());
        txt_2 = functionInitialResidual(txt_2, i_residualEquations, i_simCode);
        (txt, txt_2) = wrapIntoExtraFileIfModelTooBig(txt, txt_2, "Residuals", i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInput(txt, i_modelInfo, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOutput(txt, i_modelInfo, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitSample(txt, i_sampleLookup, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionStoreDelayed(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionUpdateBoundStartValues(txt, i_startValueEquations, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_3 = functionInitialEquations(Tpl.emptyTxt, i_useSymbolicInitialization, i_initialEquations, i_simCode);
        (txt, txt_3) = wrapIntoExtraFileIfModelTooBig(txt, txt_3, "InitialEquations", i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionUpdateBoundParameters(txt, i_parameterEquations, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_4 = functionODE(Tpl.emptyTxt, i_odeEquations, i_simCode);
        (txt, txt_4) = wrapIntoExtraFileIfModelTooBig(txt, txt_4, "FunctionODE", i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionAlgebraic(txt, i_algebraicEquations, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_5 = functionDAE(Tpl.emptyTxt, i_allEquations, i_whenClauses, i_simCode);
        (txt, txt_5) = wrapIntoExtraFileIfModelTooBig(txt, txt_5, "FunctionDAE", i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionZeroCrossing(txt, i_zeroCrossings, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionRelations(txt, i_relations, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCheckForDiscreteChanges(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationFile;

public function modelNameSpace
  input Tpl.Text in_txt;
  input Absyn.Path in_a_modelName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelName)
    local
      Tpl.Text txt;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, i_name);
        txt = modelNameSpace(txt, i_path);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = modelNameSpace(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end modelNameSpace;

public function lastIdentOfPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_modelName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelName)
    local
      Tpl.Text txt;
      String i_name;
      Absyn.Path i_path;

    case ( txt,
           Absyn.QUALIFIED(path = i_path) )
      equation
        txt = lastIdentOfPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = lastIdentOfPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end lastIdentOfPath;

protected function lm_39
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_literal :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_39(txt, rest, a_simCode);
      then txt;
  end match;
end lm_39;

public function sharedLiteralDefinitions
  input Tpl.Text txt;
  input list<DAE.Exp> a_literals;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_39(out_txt, a_literals, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end sharedLiteralDefinitions;

protected function lm_41
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_dim));
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;
  end match;
end lm_41;

protected function lm_42
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = literalExpConstArrayVal(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_42(txt, rest);
      then txt;
  end match;
end lm_42;

protected function lm_43
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_dim));
        txt = Tpl.nextIter(txt);
        txt = lm_43(txt, rest);
      then txt;
  end match;
end lm_43;

protected function lm_44
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = literalExpConstArrayVal(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_44(txt, rest);
      then txt;
  end match;
end lm_44;

protected function fun_45
  input Tpl.Text in_txt;
  input DAE.Exp in_a_lit;
  input Tpl.Text in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lit, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_name;
      DAE.Exp i_lit;
      DAE.Type i_ty;
      String i_string;
      Tpl.Text txt_15;
      String ret_15;
      list<DAE.Exp> ret_14;
      list<Integer> ret_13;
      Integer ret_12;
      list<Integer> ret_11;
      list<DAE.Exp> ret_10;
      Tpl.Text l_data;
      list<Integer> ret_8;
      Tpl.Text l_dims;
      Tpl.Text l_sty;
      Integer ret_5;
      list<Integer> ret_4;
      Tpl.Text l_arrType;
      String ret_2;
      String ret_1;
      Tpl.Text l_escstr;

    case ( txt,
           DAE.SCONST(string = i_string),
           a_name )
      equation
        ret_1 = Util.escapeModelicaStringToCString(i_string);
        l_escstr = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const string "));
        txt = Tpl.writeText(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = \""));
        ret_2 = Util.escapeModelicaStringToCString(i_string);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\";"));
      then txt;

    case ( txt,
           (i_lit as DAE.MATRIX(ty = (i_ty as DAE.T_ARRAY(ty = _)))),
           a_name )
      equation
        ret_4 = Types.getDimensionSizes(i_ty);
        ret_5 = listLength(ret_4);
        l_arrType = expTypeArray(Tpl.emptyTxt, i_ty, ret_5);
        l_sty = expTypeShort(Tpl.emptyTxt, i_ty);
        ret_8 = Types.getDimensionSizes(i_ty);
        l_dims = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dims = lm_41(l_dims, ret_8);
        l_dims = Tpl.popIter(l_dims);
        ret_10 = Expression.flattenArrayExpToList(i_lit);
        l_data = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_data = lm_42(l_data, ret_10);
        l_data = Tpl.popIter(l_data);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static "));
        txt = Tpl.writeText(txt, l_arrType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new "));
        txt = Tpl.writeText(txt, l_arrType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",-1, new "));
        txt = Tpl.writeText(txt, l_sty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[] { "));
        txt = Tpl.writeText(txt, l_data);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" });"));
      then txt;

    case ( txt,
           (i_lit as DAE.ARRAY(ty = (i_ty as DAE.T_ARRAY(ty = _)))),
           a_name )
      equation
        ret_11 = Types.getDimensionSizes(i_ty);
        ret_12 = listLength(ret_11);
        l_arrType = expTypeArray(Tpl.emptyTxt, i_ty, ret_12);
        l_sty = expTypeShort(Tpl.emptyTxt, i_ty);
        ret_13 = Types.getDimensionSizes(i_ty);
        l_dims = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dims = lm_43(l_dims, ret_13);
        l_dims = Tpl.popIter(l_dims);
        ret_14 = Expression.flattenArrayExpToList(i_lit);
        l_data = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_data = lm_44(l_data, ret_14);
        l_data = Tpl.popIter(l_data);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static "));
        txt = Tpl.writeText(txt, l_arrType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new "));
        txt = Tpl.writeText(txt, l_arrType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_dims);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",-1, new "));
        txt = Tpl.writeText(txt, l_sty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[] { "));
        txt = Tpl.writeText(txt, l_data);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" });"));
      then txt;

    case ( txt,
           i_lit,
           _ )
      equation
        txt_15 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("literalExpConst failed: "));
        ret_15 = ExpressionDump.printExpStr(i_lit);
        txt_15 = Tpl.writeStr(txt_15, ret_15);
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 187, 14), Tpl.textString(txt_15));
      then txt;
  end match;
end fun_45;

public function literalExpConst
  input Tpl.Text txt;
  input DAE.Exp a_lit;
  input Integer a_index;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_name;
algorithm
  l_name := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("_OMC_LIT"));
  l_name := Tpl.writeStr(l_name, intString(a_index));
  out_txt := fun_45(txt, a_lit, l_name);
end literalExpConst;

protected function fun_47
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end match;
end fun_47;

public function literalExpConstArrayVal
  input Tpl.Text in_txt;
  input DAE.Exp in_a_lit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lit)
    local
      Tpl.Text txt;
      DAE.Exp i_lit;
      Absyn.Path i_name;
      Integer i_index;
      Real i_real;
      Boolean i_bool;
      Integer i_integer;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_47(txt, i_bool);
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index, name = i_name) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*ENUM:"));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           DAE.SHARED_LITERAL(index = i_index) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_OMC_LIT"));
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           i_lit )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("literalExpConstArrayVal failed: "));
        ret_0 = ExpressionDump.printExpStr(i_lit);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 200, 16), Tpl.textString(txt_0));
      then txt;
  end match;
end literalExpConstArrayVal;

protected function fun_49
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Absyn.Path i_name;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RECORD_CONSTRUCTOR_NOT_IMPLEMENTED(name="));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_FUNCTION"));
      then txt;
  end match;
end fun_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = fun_49(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest, a_simCode);
      then txt;
  end match;
end lm_50;

public function simulationFunctionsBody
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.Function> i_modelInfo_functions;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions))) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_50(txt, i_modelInfo_functions, i_simCode);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationFunctionsBody;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name)) :: rest,
           a_simCode )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_var_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_52(txt, rest, a_simCode);
      then txt;
  end match;
end lm_52;

public function recordDeclaration
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_recDecl, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_variables;
      String i_name;

    case ( txt,
           SimCode.RECORD_DECL_FULL(name = i_name, variables = i_variables),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_variables, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RECORD_DECL_DEF_NOT_SUPPORTED"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_RECORD_DECL_"));
      then txt;
  end match;
end recordDeclaration;

protected function fun_54
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      SimCode.Variable i_fv;

    case ( txt,
           i_fv :: _ )
      equation
        txt = varType(txt, i_fv);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;
  end match;
end fun_54;

protected function fun_55
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_fv_name;

    case ( txt,
           SimCode.VARIABLE(name = i_fv_name) :: _,
           a_simCode )
      equation
        txt = crefStr(txt, i_fv_name, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = varInit(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest, a_simCode);
      then txt;
  end match;
end lm_56;

protected function lm_57
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      SimCode.SimCode a_simCode;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_stmt :: rest,
           a_simCode )
      equation
        txt = funStatement(txt, i_stmt, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_57(txt, rest, a_simCode);
      then txt;
  end match;
end lm_57;

protected function lm_58
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_58(txt, rest, a_simCode);
      then txt;
  end match;
end lm_58;

protected function fun_59
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_retVar;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = Tpl.writeText(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_59;

public function functionBodyRegularFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_functionArguments;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_variableDeclarations;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_bodyPart;
      Tpl.Text l_varInits;
      Tpl.Text l_retVar;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name, outVars = i_outVars, variableDeclarations = i_variableDeclarations, body = i_body, functionArguments = i_functionArguments),
           a_simCode )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_54(Tpl.emptyTxt, i_outVars);
        l_retVar = fun_55(Tpl.emptyTxt, i_outVars, a_simCode);
        l_varInits = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_varInits = lm_56(l_varInits, i_variableDeclarations, a_simCode);
        l_varInits = Tpl.popIter(l_varInits);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_bodyPart = lm_57(l_bodyPart, i_body, a_simCode);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_58(txt, i_functionArguments, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "_return:\n"
                                }, true));
        txt = fun_59(txt, i_outVars, l_retVar);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionBodyRegularFunction;

protected function fun_61
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      SimCode.Variable i_fv;

    case ( txt,
           i_fv :: _ )
      equation
        txt = varType(txt, i_fv);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;
  end match;
end fun_61;

protected function lm_62
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           _,
           a_preExp )
      then (txt, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_simCode,
           a_preExp )
      equation
        (txt, a_preExp) = extArg(txt, i_arg, a_preExp, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_62(txt, rest, a_simCode, a_preExp);
      then (txt, a_preExp);
  end match;
end lm_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest, a_simCode);
      then txt;
  end match;
end lm_63;

protected function fun_64
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
      then txt;
  end match;
end fun_64;

public function functionBodyExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_funArgs;
      String i_extName;
      list<String> i_libs;
      list<SimCode.SimExtArg> i_extArgs;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      String ret_6;
      Tpl.Text l_lib;
      Tpl.Text l_args;
      Tpl.Text l_callPart;
      Tpl.Text l_preExp;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name, outVars = i_outVars, extArgs = i_extArgs, libs = i_libs, extName = i_extName, funArgs = i_funArgs),
           a_simCode )
      equation
        System.tmpTickReset(1);
        l_fname = underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_61(Tpl.emptyTxt, i_outVars);
        l_preExp = Tpl.emptyTxt;
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, l_preExp) = lm_62(l_args, i_extArgs, a_simCode, l_preExp);
        l_args = Tpl.popIter(l_args);
        ret_6 = SimCodeUtil.hackGetFirstExternalFunctionLib(i_libs);
        l_lib = Tpl.writeStr(Tpl.emptyTxt, ret_6);
        l_callPart = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Bodylight.Solvers.ExternalLibraries."));
        l_callPart = Tpl.writeText(l_callPart, l_lib);
        l_callPart = Tpl.writeTok(l_callPart, Tpl.ST_STRING("."));
        l_callPart = Tpl.writeStr(l_callPart, i_extName);
        l_callPart = Tpl.writeTok(l_callPart, Tpl.ST_STRING("("));
        l_callPart = Tpl.writeText(l_callPart, l_args);
        l_callPart = Tpl.writeTok(l_callPart, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static "));
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_63(txt, i_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = fun_64(txt, i_outVars);
        txt = Tpl.writeText(txt, l_callPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionBodyExternalFunction;

protected function fun_66
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_oi, in_a_simCode, in_a_c)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_c;
      Integer i_oi;

    case ( txt,
           0,
           a_simCode,
           a_c )
      equation
        txt = crefStr(txt, a_c, a_simCode);
      then txt;

    case ( txt,
           i_oi,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT_SUPPORTED_out.targ"));
        txt = Tpl.writeStr(txt, intString(i_oi));
      then txt;
  end match;
end fun_66;

protected function fun_67
  input Tpl.Text in_txt;
  input Integer in_a_outputIndex;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outputIndex, in_a_simCode, in_a_c)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_c;
      Integer i_outputIndex;

    case ( txt,
           0,
           a_simCode,
           a_c )
      equation
        txt = crefStr(txt, a_c, a_simCode);
      then txt;

    case ( txt,
           i_outputIndex,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT_SUPPORTED_SIZE_out.targ"));
        txt = Tpl.writeStr(txt, intString(i_outputIndex));
      then txt;
  end match;
end fun_67;

protected function fun_68
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_exp, in_a_simCode, in_a_preExp, in_a_name)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      Tpl.Text a_name;
      DAE.Exp i_exp;
      Integer i_integer;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_name )
      equation
        txt = Tpl.writeText(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".size"));
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, a_preExp);

    case ( txt,
           i_exp,
           a_simCode,
           a_preExp,
           a_name )
      equation
        txt = Tpl.writeText(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".size("));
        (txt, a_preExp) = daeExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);
  end match;
end fun_68;

public function extArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_extArg, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      Integer i_outputIndex;
      DAE.Exp i_exp;
      DAE.ComponentRef i_c;
      Integer i_oi;
      Tpl.Text l_cr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, outputIndex = i_oi, isArray = true, type_ = _),
           a_preExp,
           a_simCode )
      equation
        l_name = fun_66(Tpl.emptyTxt, i_oi, a_simCode, i_c);
        txt = Tpl.writeText(txt, l_name);
      then (txt, a_preExp);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = 0, type_ = _),
           a_preExp,
           a_simCode )
      equation
        l_cr = crefStr(Tpl.emptyTxt, i_c, a_simCode);
        txt = Tpl.writeText(txt, l_cr);
      then (txt, a_preExp);

    case ( txt,
           SimCode.SIMEXTARG(cref = _, isInput = _, outputIndex = i_oi, type_ = _),
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT_SUPPORTED_ext"));
        txt = Tpl.writeStr(txt, intString(i_oi));
      then (txt, a_preExp);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp),
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, outputIndex = i_outputIndex, exp = i_exp),
           a_preExp,
           a_simCode )
      equation
        l_name = fun_67(Tpl.emptyTxt, i_outputIndex, a_simCode, i_c);
        (txt, a_preExp) = fun_68(txt, i_exp, a_simCode, a_preExp, l_name);
      then (txt, a_preExp);

    case ( txt,
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);
  end match;
end extArg;

protected function lm_70
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preDimsExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preDimsExp;
algorithm
  (out_txt, out_a_preDimsExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preDimsExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preDimsExp;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_preDimsExp )
      then (txt, a_preDimsExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_preDimsExp )
      equation
        (txt, a_preDimsExp) = daeExp(txt, i_exp, SimCode.contextFunction, a_preDimsExp, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_preDimsExp) = lm_70(txt, rest, a_simCode, a_preDimsExp);
      then (txt, a_preDimsExp);
  end match;
end lm_70;

protected function fun_71
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var_value, in_a_simCode, in_a_varName)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varName;
      DAE.ComponentRef i_cr;

    case ( txt,
           SOME(DAE.CREF(componentRef = i_cr)),
           a_simCode,
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".CopyFrom("));
        txt = crefStr(txt, i_cr, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_71;

protected function fun_72
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Option<DAE.Exp> in_a_var_value;
  input DAE.Type in_a_var_ty;
  input list<DAE.Exp> in_a_var_instDims;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_value, in_a_var_ty, in_a_var_instDims, in_a_simCode, in_a_var_name, in_a_var)
    local
      Tpl.Text txt;
      Option<DAE.Exp> a_var_value;
      DAE.Type a_var_ty;
      list<DAE.Exp> a_var_instDims;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      SimCode.Variable a_var;
      list<DAE.Exp> i_instDims;
      Integer ret_3;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_preDimsExp;
      Tpl.Text l_varName;

    case ( txt,
           {},
           _,
           _,
           _,
           a_simCode,
           a_var_name,
           a_var )
      equation
        txt = varType(txt, a_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, a_var_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           i_instDims,
           a_var_value,
           a_var_ty,
           a_var_instDims,
           a_simCode,
           a_var_name,
           _ )
      equation
        l_varName = crefStr(Tpl.emptyTxt, a_var_name, a_simCode);
        l_preDimsExp = Tpl.emptyTxt;
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, l_preDimsExp) = lm_70(l_instDimsInit, a_var_instDims, a_simCode, l_preDimsExp);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        txt = Tpl.writeText(txt, l_preDimsExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var "));
        txt = Tpl.writeText(txt, l_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new "));
        ret_3 = listLength(i_instDims);
        txt = expTypeArray(txt, a_var_ty, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_instDimsInit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = fun_71(txt, a_var_value, a_simCode, l_varName);
      then txt;
  end match;
end fun_72;

public function varInit
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Option<DAE.Exp> i_var_value;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_var_instDims;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;
      list<DAE.Exp> i_instDims;

    case ( txt,
           (i_var as SimCode.VARIABLE(instDims = (i_var_instDims as i_instDims), name = i_var_name, ty = i_var_ty, value = i_var_value)),
           a_simCode )
      equation
        txt = fun_72(txt, i_instDims, i_var_value, i_var_ty, i_var_instDims, a_simCode, i_var_name, i_var);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNSUPPORTED_VARIABLE_varInit"));
      then txt;
  end match;
end varInit;

public function funArgDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)),
           a_simCode )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_name, a_simCode);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("funArgDefinition_UNSUPPORTED_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNSUPPORTED_VARIABLE_funArgDefinition"));
      then txt;
  end match;
end funArgDefinition;

protected function lm_75
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_stmt :: rest,
           a_simCode )
      equation
        txt = algStatement(txt, i_stmt, SimCode.contextFunction, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_75(txt, rest, a_simCode);
      then txt;
  end match;
end lm_75;

public function funStatement
  input Tpl.Text in_txt;
  input SimCode.Statement in_a_stmt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           SimCode.ALGORITHM(statementLst = i_statementLst),
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_75(txt, i_statementLst, a_simCode);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED FUN STATEMENT"));
      then txt;
  end match;
end funStatement;

public constant Tpl.StringToken c_localRepresentationArrayDefines = Tpl.ST_STRING_LIST({
                                                                        "var X = States; var Xd = StatesDerivatives; var Y = Algebraics; var YI = AlgebraicsInt; var YB = AlgebraicsBool; \n",
                                                                        "var P = Parameters; var PI = ParametersInt; var PB = ParametersBool; var PS = ParametersString; var EO = ExternalObjects;\n",
                                                                        "var preX = PreStates; var preXd = PreStatesDerivatives; var preY = PreAlgebraics; var preYI = PreAlgebraicsInt; var preYB = PreAlgebraicsBool; \n",
                                                                        "var mathEVPre = MathEventsValuePre;\n",
                                                                        "/*TODO: HACK FOR non-time varying params*/ var preP = P; var prePI = PI; var prePB = PB;"
                                                                    }, false);

protected function fun_78
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      Integer i_varInfo_numMixedSystems;
      Integer i_varInfo_numNonLinearSystems;
      Integer i_varInfo_numLinearSystems;
      Integer i_varInfo_numStringParamVars;
      Integer i_varInfo_numBoolParams;
      Integer i_varInfo_numIntParams;
      Integer i_varInfo_numBoolAliasVars;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numIntAliasVars;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numStringAliasVars;
      Integer i_varInfo_numStringAlgVars;
      list<SimCode.Function> i_functions;
      Integer i_varInfo_numExternalObjects;
      Integer i_varInfo_numInitialResiduals;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numParams;
      Integer i_varInfo_numAlgAliasVars;
      Integer i_varInfo_numAlgVars;
      Integer i_varInfo_numStateVars;
      Integer i_varInfo_numTimeEvents;
      Integer i_varInfo_numMathEventFunctions;
      Integer i_varInfo_numRelations;
      Integer i_varInfo_numZeroCrossings;
      Integer ret_0;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = i_varInfo_numZeroCrossings, numRelations = i_varInfo_numRelations, numMathEventFunctions = i_varInfo_numMathEventFunctions, numTimeEvents = i_varInfo_numTimeEvents, numStateVars = i_varInfo_numStateVars, numAlgVars = i_varInfo_numAlgVars, numAlgAliasVars = i_varInfo_numAlgAliasVars, numParams = i_varInfo_numParams, numOutVars = i_varInfo_numOutVars, numInVars = i_varInfo_numInVars, numInitialResiduals = i_varInfo_numInitialResiduals, numExternalObjects = i_varInfo_numExternalObjects, numStringAlgVars = i_varInfo_numStringAlgVars, numStringAliasVars = i_varInfo_numStringAliasVars, numIntAlgVars = i_varInfo_numIntAlgVars, numIntAliasVars = i_varInfo_numIntAliasVars, numBoolAlgVars = i_varInfo_numBoolAlgVars, numBoolAliasVars = i_varInfo_numBoolAliasVars, numIntParams = i_varInfo_numIntParams, numBoolParams = i_varInfo_numBoolParams, numStringParamVars = i_varInfo_numStringParamVars, numLinearSystems = i_varInfo_numLinearSystems, numNonLinearSystems = i_varInfo_numNonLinearSystems, numMixedSystems = i_varInfo_numMixedSystems), vars = SimCode.SIMVARS(stateVars = _), functions = i_functions, name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#region Model description\n",
                                    "\n",
                                    "const int\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NG = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NREL = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numRelations));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NM   = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numMathEventFunctions));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NG_SAM = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NX = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NY = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NA = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", // number of alias variables\n",
                                    "NP = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NO = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NI = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NR = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInitialResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NEXT = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "//NFUNC = "
                                }, false));
        ret_0 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", // number of functions used by the simulation\n",
                                    "NYSTR = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NASTR = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", // number of alias string variables\n",
                                    "NYI = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NAI = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", // number of alias int variables\n",
                                    "NYB = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NAB = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", // number of alias bool variables\n",
                                    "NPI = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NPB = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NPSTR = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NAAll = NA+NAI+NAB+NASTR, // number of all aliases\n",
                                    "NLS   = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numLinearSystems));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NNLS  = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numNonLinearSystems));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NMIXS = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numMixedSystems));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "private class "
                                }, false));
        txt = lastIdentOfPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Metadata : DAESystemMetadata\n",
                                    "{\n",
                                    "  public override int ZeroCrossingsCount  { get { return NG; } }\n",
                                    "  public override int RelationsCount      { get { return NREL; } }\n",
                                    "  public override int MathEventsCount      { get { return NM; } }\n",
                                    "  public override int SampleTypesCount    { get { return NG_SAM; } }\n",
                                    "\n",
                                    "  public override int OutputsCount   { get { return NO; } }\n",
                                    "  public override int InputsCount    { get { return NI; } }\n",
                                    "  public override int InitialResidualsCount { get { return NR; } }\n",
                                    "  public override int ExternalObjectsCount { get { return NEXT; } }\n",
                                    "\n",
                                    "  public override int LinearSystemsCount { get { return NLS; } }\n",
                                    "  public override int NonLinearSystemsCount { get { return NNLS; } }\n",
                                    "  public override int MixedSystemsCount { get { return NMIXS; } }\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public "));
        txt = lastIdentOfPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Metadata(VarData[][] varData, AliasVarData[] aliasVarData, Dictionary<string, int> fullVarDictionary,\n",
                                    "                     Dictionary<int, double> startValues, Dictionary<int, int> startValuesInt, Dictionary<int, bool> startValuesBool,\n",
                                    "                     string[] startParameterString)\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": base(\""));
        txt = dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\", varData, aliasVarData, fullVarDictionary, startValues, startValuesInt, startValuesBool, startParameterString)\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{}\n",
                                    "\n",
                                    "public override DAESystem NewSystem()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return new "));
        txt = lastIdentOfPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("();\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "public static readonly DAESystemMetadata SystemMetadata;\n",
                                    "\n",
                                    "public "
                                }, false));
        txt = lastIdentOfPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("() : base("));
        txt = lastIdentOfPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".SystemMetadata)\n",
                                    "{}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#endregion"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_78;

public function modelDescription
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_78(txt, a_modelInfo);
end modelDescription;

protected function smf_80
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_80;

protected function smf_81
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_81;

protected function smf_82
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_82;

protected function smf_83
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_83;

protected function smf_84
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_84;

protected function smf_85
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_85;

protected function smf_86
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_86;

protected function smf_87
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_87;

protected function smf_88
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_88;

protected function smf_89
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_89;

protected function smf_90
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_90;

protected function smf_91
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_91;

protected function smf_92
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_92;

protected function smf_93
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Tpl.Text i_it;

    case ( txt,
           i_it )
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end match;
end smf_93;

public function modelMetadata
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      Integer i_varInfo_numStringParamVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      Integer i_varInfo_numBoolParams;
      list<SimCode.SimVar> i_vars_boolParamVars;
      Integer i_varInfo_numIntParams;
      list<SimCode.SimVar> i_vars_intParamVars;
      Integer i_varInfo_numParams;
      list<SimCode.SimVar> i_vars_paramVars;
      Integer i_varInfo_numStringAlgVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      Integer i_varInfo_numBoolAlgVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      Integer i_varInfo_numIntAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      Integer i_varInfo_numAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      Integer i_varInfo_numStateVars;
      list<SimCode.SimVar> i_vars_stateVars;
      Absyn.Path i_name;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numAlgVars = i_varInfo_numAlgVars, numIntAlgVars = i_varInfo_numIntAlgVars, numBoolAlgVars = i_varInfo_numBoolAlgVars, numStringAlgVars = i_varInfo_numStringAlgVars, numParams = i_varInfo_numParams, numIntParams = i_varInfo_numIntParams, numBoolParams = i_varInfo_numBoolParams, numStringParamVars = i_varInfo_numStringParamVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, stringAliasVars = i_vars_stringAliasVars), name = i_name),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static "));
        txt = lastIdentOfPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "() {\n",
                                    "  var varData = new VarData[(int)SimVarType.NonAliasTypesCnt][];\n",
                                    "  VarData[] vd;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_0 = varInfos(Tpl.emptyTxt, "State", i_vars_stateVars, i_varInfo_numStateVars, a_simCode);
        txt_1 = varInfos(Tpl.emptyTxt, "StateDer", i_vars_derivativeVars, i_varInfo_numStateVars, a_simCode);
        txt_2 = varInfos(Tpl.emptyTxt, "Algebraic", i_vars_algVars, i_varInfo_numAlgVars, a_simCode);
        txt_3 = varInfos(Tpl.emptyTxt, "AlgebraicInt", i_vars_intAlgVars, i_varInfo_numIntAlgVars, a_simCode);
        txt_4 = varInfos(Tpl.emptyTxt, "AlgebraicBool", i_vars_boolAlgVars, i_varInfo_numBoolAlgVars, a_simCode);
        txt_5 = varInfos(Tpl.emptyTxt, "AlgebraicString", i_vars_stringAlgVars, i_varInfo_numStringAlgVars, a_simCode);
        txt_6 = varInfos(Tpl.emptyTxt, "Parameter", i_vars_paramVars, i_varInfo_numParams, a_simCode);
        txt_7 = varInfos(Tpl.emptyTxt, "ParameterInt", i_vars_intParamVars, i_varInfo_numIntParams, a_simCode);
        txt_8 = varInfos(Tpl.emptyTxt, "ParameterBool", i_vars_boolParamVars, i_varInfo_numBoolParams, a_simCode);
        txt_9 = varInfos(Tpl.emptyTxt, "ParameterString", i_vars_stringParamVars, i_varInfo_numStringParamVars, a_simCode);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     "\n"
                                                                 }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_80(txt, txt_0);
        txt = smf_81(txt, txt_1);
        txt = smf_82(txt, txt_2);
        txt = smf_83(txt, txt_3);
        txt = smf_84(txt, txt_4);
        txt = smf_85(txt, txt_5);
        txt = smf_86(txt, txt_6);
        txt = smf_87(txt, txt_7);
        txt = smf_88(txt, txt_8);
        txt = smf_89(txt, txt_9);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#region *** all aliases ***\n",
                                    "var fvd = Bodylight.Solvers.SystemMetadata.SetupVariableNamesLookup(varData, NAAll);\n",
                                    "var ad = new AliasVarData[NAAll];\n"
                                }, true));
        txt_10 = aliasVarInfos(Tpl.emptyTxt, "alias Algebraic", i_vars_aliasVars, "", a_simCode);
        txt_11 = aliasVarInfos(Tpl.emptyTxt, "alias AlgebraicInt", i_vars_intAliasVars, "NA+", a_simCode);
        txt_12 = aliasVarInfos(Tpl.emptyTxt, "alias AlgebraicBool", i_vars_boolAliasVars, "NA+NAI+", a_simCode);
        txt_13 = aliasVarInfos(Tpl.emptyTxt, "alias AlgebraicString", i_vars_stringAliasVars, "NA+NAI+NAB+", a_simCode);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     "\n"
                                                                 }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_90(txt, txt_10);
        txt = smf_91(txt, txt_11);
        txt = smf_92(txt, txt_12);
        txt = smf_93(txt, txt_13);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#endregion\n",
                                    "\n",
                                    "#region *** start values ***\n",
                                    "var svs = new Dictionary<int, double>();\n",
                                    "var svsI = new Dictionary<int, int>();\n",
                                    "var svsB = new Dictionary<int, bool>();\n",
                                    "var svsS = new string[NPSTR];\n",
                                    "\n"
                                }, true));
        txt = initVals(txt, "svs", "State", i_vars_stateVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, "svs", "StateDer", i_vars_derivativeVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, "svs", "Algebraic", i_vars_algVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, "svs", "Parameter", i_vars_paramVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, "svsI", "AlgebraicInt", i_vars_intAlgVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, "svsI", "ParameterInt", i_vars_intParamVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, "svsB", "AlgebraicBool", i_vars_boolAlgVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, "svsB", "ParameterBool", i_vars_boolParamVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "// *** AlgebraicStrings not fully supported ***\n"
                                }, true));
        txt = initValsString(txt, "svsS", "ParameterString", i_vars_stringParamVars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#endregion\n",
                                    "\n",
                                    "SystemMetadata = new "
                                }, false));
        txt = lastIdentOfPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Metadata(varData, ad, fvd, svs, svsI, svsB, svsS);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end modelMetadata;

public function simVarTypeName
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind, in_a_type__)
    local
      Tpl.Text txt;
      DAE.Type a_type__;

    case ( txt,
           BackendDAE.VARIABLE(),
           a_type__ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algebraic"));
        txt = simVarTypeNamePostfix(txt, a_type__);
      then txt;

    case ( txt,
           BackendDAE.STATE(index = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("State"));
      then txt;

    case ( txt,
           BackendDAE.STATE_DER(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateDer"));
      then txt;

    case ( txt,
           BackendDAE.DUMMY_DER(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algebraic"));
      then txt;

    case ( txt,
           BackendDAE.DUMMY_STATE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algebraic"));
      then txt;

    case ( txt,
           BackendDAE.DISCRETE(),
           a_type__ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algebraic"));
        txt = simVarTypeNamePostfix(txt, a_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*d*/"));
      then txt;

    case ( txt,
           BackendDAE.PARAM(),
           a_type__ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameter"));
        txt = simVarTypeNamePostfix(txt, a_type__);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 528, 14), "Unexpected simVarTypeName varKind");
      then txt;
  end match;
end simVarTypeName;

public function simVarTypeNamePostfix
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Bool"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("String"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*Enum*/"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 543, 14), "Unknown simVarTypeNamePostfix");
      then txt;
  end match;
end simVarTypeNamePostfix;

protected function lm_97
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimVar i_sv;
      String i_comment;
      DAE.ComponentRef i_name;
      Integer i_index;
      String ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_sv as SimCode.SIMVAR(index = i_index, name = i_name, comment = i_comment)) :: rest,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("vd["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = new VarData(\""));
        txt = crefStrWithDerOnLast(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", \""));
        ret_0 = Util.escapeModelicaStringToCString(i_comment);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = noaliasSimVarInfoRest(txt, i_sv);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_97(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_97(txt, rest, a_simCode);
      then txt;
  end match;
end lm_97;

public function varInfos
  input Tpl.Text txt;
  input String a_regionName;
  input list<SimCode.SimVar> a_varsLst;
  input Integer a_varsCnt;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#region *** ("));
  out_txt := Tpl.writeStr(out_txt, intString(a_varsCnt));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(") "));
  out_txt := Tpl.writeStr(out_txt, a_regionName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       " variable data ***\n",
                                       "vd = new VarData["
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, intString(a_varsCnt));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("];\n"));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_97(out_txt, a_varsLst, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("varData[(int)SimVarType."));
  out_txt := Tpl.writeStr(out_txt, a_regionName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "] = vd;\n",
                                       "#endregion"
                                   }, false));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end varInfos;

protected function fun_99
  input Tpl.Text in_txt;
  input Boolean in_a_sv_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sv_isFixed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", SimVarAttributes.DefaultFixed"));
      then txt;
  end match;
end fun_99;

protected function fun_100
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominalValue;
  input Boolean in_a_sv_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nominalValue, in_a_sv_isFixed)
    local
      Tpl.Text txt;
      Boolean a_sv_isFixed;
      Real i_exp_real;

    case ( txt,
           SOME(DAE.RCONST(real = i_exp_real)),
           a_sv_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", new SimVarAttributes("));
        txt = Tpl.writeStr(txt, realString(i_exp_real));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", false, "));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_sv_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SOME(_),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Error-other-nominal-value-than-real-constant-not-supported"));
      then txt;

    case ( txt,
           _,
           a_sv_isFixed )
      equation
        txt = fun_99(txt, a_sv_isFixed);
      then txt;
  end match;
end fun_100;

protected function fun_101
  input Tpl.Text in_txt;
  input Boolean in_a_sv_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sv_isFixed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Fixed"));
      then txt;
  end match;
end fun_101;

protected function fun_102
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominalValue;
  input Boolean in_a_sv_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nominalValue, in_a_sv_isFixed)
    local
      Tpl.Text txt;
      Boolean a_sv_isFixed;
      Real i_exp_real;

    case ( txt,
           SOME(DAE.RCONST(real = i_exp_real)),
           a_sv_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", new SimVarAttributes("));
        txt = Tpl.writeStr(txt, realString(i_exp_real));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", true, "));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_sv_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           SOME(_),
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 570, 34), "Unexpected expression for nominal value.");
      then txt;

    case ( txt,
           _,
           a_sv_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", SimVarAttributes.DefaultUseStart"));
        txt = fun_101(txt, a_sv_isFixed);
      then txt;
  end match;
end fun_102;

protected function fun_103
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Boolean in_a_sv_isFixed;
  input Option<DAE.Exp> in_a_nominalValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_sv_isFixed, in_a_nominalValue)
    local
      Tpl.Text txt;
      Boolean a_sv_isFixed;
      Option<DAE.Exp> a_nominalValue;

    case ( txt,
           NONE(),
           a_sv_isFixed,
           a_nominalValue )
      equation
        txt = fun_100(txt, a_nominalValue, a_sv_isFixed);
      then txt;

    case ( txt,
           _,
           a_sv_isFixed,
           a_nominalValue )
      equation
        txt = fun_102(txt, a_nominalValue, a_sv_isFixed);
      then txt;
  end match;
end fun_103;

public function noaliasSimVarInfoRest
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      Boolean i_sv_isFixed;
      Option<DAE.Exp> i_nominalValue;
      Option<DAE.Exp> i_initialValue;

    case ( txt,
           SimCode.SIMVAR(initialValue = i_initialValue, nominalValue = i_nominalValue, isFixed = i_sv_isFixed) )
      equation
        txt = fun_103(txt, i_initialValue, i_sv_isFixed, i_nominalValue);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end noaliasSimVarInfoRest;

protected function fun_105
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_aliasvar;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_varName;

    case ( txt,
           SimCode.NOALIAS(),
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 589, 17), "Unexpected non-alias variable amongst aliases.");
      then txt;

    case ( txt,
           SimCode.ALIAS(varName = i_varName),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fvd[\""));
        txt = crefStrWithDerOnLast(txt, i_varName, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"]"));
      then txt;

    case ( txt,
           SimCode.NEGATEDALIAS(varName = i_varName),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-fvd[\""));
        txt = crefStrWithDerOnLast(txt, i_varName, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"]"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_105;

protected function lm_106
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_offset;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_offset, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_offset;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      SimCode.AliasVariable i_aliasvar;
      String i_comment;
      DAE.ComponentRef i_name;
      String ret_3;
      Tpl.Text l_aliasLookup;
      String ret_1;
      Tpl.Text l_strNameCmt;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, comment = i_comment, aliasvar = i_aliasvar) :: rest,
           a_offset,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_strNameCmt = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("\""));
        l_strNameCmt = crefStrWithDerOnLast(l_strNameCmt, i_name, a_simCode);
        l_strNameCmt = Tpl.writeTok(l_strNameCmt, Tpl.ST_STRING("\", \""));
        ret_1 = Util.escapeModelicaStringToCString(i_comment);
        l_strNameCmt = Tpl.writeStr(l_strNameCmt, ret_1);
        l_strNameCmt = Tpl.writeTok(l_strNameCmt, Tpl.ST_STRING("\""));
        l_aliasLookup = fun_105(Tpl.emptyTxt, i_aliasvar, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ad["));
        txt = Tpl.writeStr(txt, a_offset);
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = new AliasVarData(\""));
        txt = crefStrWithDerOnLast(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", \""));
        ret_3 = Util.escapeModelicaStringToCString(i_comment);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", "));
        txt = Tpl.writeText(txt, l_aliasLookup);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_106(txt, rest, a_offset, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_offset,
           a_simCode )
      equation
        txt = lm_106(txt, rest, a_offset, a_simCode);
      then txt;
  end match;
end lm_106;

protected function fun_107
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_varsLst;
  input String in_a_regionName;
  input String in_a_offset;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varsLst, in_a_regionName, in_a_offset, in_a_simCode)
    local
      Tpl.Text txt;
      String a_regionName;
      String a_offset;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_varsLst;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_varsLst,
           a_regionName,
           a_offset,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#region *** ("));
        ret_0 = listLength(i_varsLst);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") "));
        txt = Tpl.writeStr(txt, a_regionName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" variable infos ***\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_106(txt, i_varsLst, a_offset, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#endregion"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_107;

public function aliasVarInfos
  input Tpl.Text txt;
  input String a_regionName;
  input list<SimCode.SimVar> a_varsLst;
  input String a_offset;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_107(txt, a_varsLst, a_regionName, a_offset, a_simCode);
end aliasVarInfos;

protected function fun_109
  input Tpl.Text in_txt;
  input String in_mArg;
  input String in_a_typName;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_sv_name;
  input Integer in_a_sv_index;
  input String in_a_arrName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_typName, in_a_simCode, in_a_sv_name, in_a_sv_index, in_a_arrName)
    local
      Tpl.Text txt;
      String a_typName;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_sv_name;
      Integer a_sv_index;
      String a_arrName;
      String i_vStr;

    case ( txt,
           (i_vStr as "0"),
           _,
           a_simCode,
           a_sv_name,
           a_sv_index,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//"));
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_sv_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //"));
        txt = crefStr(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" --> zero val"));
      then txt;

    case ( txt,
           (i_vStr as "0.0"),
           _,
           a_simCode,
           a_sv_name,
           a_sv_index,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//"));
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_sv_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //"));
        txt = crefStr(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" --> zero val"));
      then txt;

    case ( txt,
           (i_vStr as "false"),
           _,
           a_simCode,
           a_sv_name,
           a_sv_index,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//"));
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_sv_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //"));
        txt = crefStr(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" --> zero val"));
      then txt;

    case ( txt,
           (i_vStr as "(0)"),
           _,
           a_simCode,
           a_sv_name,
           a_sv_index,
           a_arrName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//"));
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_sv_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //"));
        txt = crefStr(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" --> zero val"));
      then txt;

    case ( txt,
           i_vStr,
           a_typName,
           a_simCode,
           a_sv_name,
           a_sv_index,
           a_arrName )
      equation
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[(int)SimVarType."));
        txt = Tpl.writeStr(txt, a_typName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+("));
        txt = Tpl.writeStr(txt, intString(a_sv_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<<4)] = "));
        txt = Tpl.writeStr(txt, i_vStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //"));
        txt = crefStr(txt, a_sv_name, a_simCode);
      then txt;
  end match;
end fun_109;

protected function fun_110
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input String in_a_typName;
  input DAE.ComponentRef in_a_sv_name;
  input Integer in_a_sv_index;
  input String in_a_arrName;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_typName, in_a_sv_name, in_a_sv_index, in_a_arrName, in_a_simCode)
    local
      Tpl.Text txt;
      String a_typName;
      DAE.ComponentRef a_sv_name;
      Integer a_sv_index;
      String a_arrName;
      SimCode.SimCode a_simCode;
      DAE.Exp i_v;
      String str_2;
      Tpl.Text txt_1;
      Tpl.Text l_preExp;

    case ( txt,
           SOME(i_v),
           a_typName,
           a_sv_name,
           a_sv_index,
           a_arrName,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (txt_1, l_preExp) = daeExp(Tpl.emptyTxt, i_v, SimCode.contextOther, l_preExp, a_simCode);
        str_2 = Tpl.textString(txt_1);
        txt = fun_109(txt, str_2, a_typName, a_simCode, a_sv_name, a_sv_index, a_arrName);
      then txt;

    case ( txt,
           _,
           _,
           a_sv_name,
           a_sv_index,
           a_arrName,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//"));
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_sv_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = 0.0; //"));
        txt = crefStr(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" --> default val"));
      then txt;
  end match;
end fun_110;

protected function lm_111
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_typName;
  input String in_a_arrName;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_typName, in_a_arrName, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_typName;
      String a_arrName;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_sv_name;
      Integer i_sv_index;
      Option<DAE.Exp> i_initialValue;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(initialValue = i_initialValue, index = i_sv_index, name = i_sv_name) :: rest,
           a_typName,
           a_arrName,
           a_simCode )
      equation
        txt = fun_110(txt, i_initialValue, a_typName, i_sv_name, i_sv_index, a_arrName, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_111(txt, rest, a_typName, a_arrName, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_typName,
           a_arrName,
           a_simCode )
      equation
        txt = lm_111(txt, rest, a_typName, a_arrName, a_simCode);
      then txt;
  end match;
end lm_111;

protected function fun_112
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_varsLst;
  input String in_a_arrName;
  input String in_a_typName;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varsLst, in_a_arrName, in_a_typName, in_a_simCode)
    local
      Tpl.Text txt;
      String a_arrName;
      String a_typName;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_varsLst;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_varsLst,
           a_arrName,
           a_typName,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#region **** "
                                }, false));
        txt = Tpl.writeStr(txt, a_typName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" start values *****\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_111(txt, i_varsLst, a_typName, a_arrName, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#endregion"));
      then txt;
  end match;
end fun_112;

public function initVals
  input Tpl.Text txt;
  input String a_arrName;
  input String a_typName;
  input list<SimCode.SimVar> a_varsLst;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_112(txt, a_varsLst, a_arrName, a_typName, a_simCode);
end initVals;

protected function fun_114
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input DAE.ComponentRef in_a_sv_name;
  input Integer in_a_sv_index;
  input String in_a_arrName;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_sv_name, in_a_sv_index, in_a_arrName, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_sv_name;
      Integer a_sv_index;
      String a_arrName;
      SimCode.SimCode a_simCode;
      DAE.Exp i_v;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           SOME(i_v),
           a_sv_name,
           a_sv_index,
           a_arrName,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp) = daeExp(Tpl.emptyTxt, i_v, SimCode.contextOther, l_preExp, a_simCode);
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_sv_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //"));
        txt = crefStr(txt, a_sv_name, a_simCode);
      then txt;

    case ( txt,
           _,
           a_sv_name,
           a_sv_index,
           a_arrName,
           a_simCode )
      equation
        txt = Tpl.writeStr(txt, a_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_sv_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = \"\"; //"));
        txt = crefStr(txt, a_sv_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" --> default val"));
      then txt;
  end match;
end fun_114;

protected function lm_115
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input String in_a_arrName;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_arrName, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      String a_arrName;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_sv_name;
      Integer i_sv_index;
      Option<DAE.Exp> i_initialValue;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(initialValue = i_initialValue, index = i_sv_index, name = i_sv_name) :: rest,
           a_arrName,
           a_simCode )
      equation
        txt = fun_114(txt, i_initialValue, i_sv_name, i_sv_index, a_arrName, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_115(txt, rest, a_arrName, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_arrName,
           a_simCode )
      equation
        txt = lm_115(txt, rest, a_arrName, a_simCode);
      then txt;
  end match;
end lm_115;

protected function fun_116
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_a_varsLst;
  input String in_a_arrName;
  input String in_a_typName;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varsLst, in_a_arrName, in_a_typName, in_a_simCode)
    local
      Tpl.Text txt;
      String a_arrName;
      String a_typName;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_varsLst;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_varsLst,
           a_arrName,
           a_typName,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#region **** ("
                                }, false));
        ret_0 = listLength(i_varsLst);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") "));
        txt = Tpl.writeStr(txt, a_typName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" start values *****\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_115(txt, i_varsLst, a_arrName, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#endregion"));
      then txt;
  end match;
end fun_116;

public function initValsString
  input Tpl.Text txt;
  input String a_arrName;
  input String a_typName;
  input list<SimCode.SimVar> a_varsLst;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_116(txt, a_varsLst, a_arrName, a_typName, a_simCode);
end initValsString;

protected function lm_118
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_arg;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(initialValue = SOME(i_exp), name = i_var_name) :: rest,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arg, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_var_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_arg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = lm_118(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_118(txt, rest, a_simCode);
      then txt;
  end match;
end lm_118;

protected function lm_119
  input Tpl.Text in_txt;
  input list<SimCode.ExtAlias> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_var2;
      DAE.ComponentRef i_var1;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var1, i_var2) :: rest,
           a_simCode )
      equation
        txt = cref(txt, i_var1, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = cref(txt, i_var2, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_119(txt, rest, a_simCode);
      then txt;
  end match;
end lm_119;

public function functionCallExternalObjectConstructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extObjInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.ExtAlias> i_aliases;
      list<SimCode.SimVar> i_vars;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_vars, aliases = i_aliases),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("public override void FunCallExternalObjectConstructors() {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, c_localRepresentationArrayDefines);
        txt = Tpl.softNewLine(txt);
        txt = lm_118(txt, i_vars, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_119(txt, i_aliases, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionCallExternalObjectConstructors;

protected function lm_121
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_var_name;
      Absyn.Path i_ext_fullClassName;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(varKind = BackendDAE.EXTOBJ(fullClassName = i_ext_fullClassName), name = i_var_name) :: rest,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_ext_fullClassName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_destructor("));
        txt = cref(txt, i_var_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_121(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_121(txt, rest, a_simCode);
      then txt;
  end match;
end lm_121;

public function functionCallExternalObjectDestructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extObjInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_vars),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("public override void FunCallExternalObjectDestructors() {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, c_localRepresentationArrayDefines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_121(txt, i_vars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionCallExternalObjectDestructors;

protected function lm_123
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_it;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           a_simCode )
      equation
        txt = equation_(txt, i_it, SimCode.contextSimulationNonDiscrete, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_123(txt, rest, a_simCode);
      then txt;
  end match;
end lm_123;

public function functionAlgebraic
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_algebraicEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  list<SimCode.SimEqSystem> ret_0;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunAlgebraics()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("var preRels = PreRelations;\n"));
  ret_0 := List.flatten(a_algebraicEquations);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_123(out_txt, ret_0, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAlgebraic;

protected function lm_125
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = inputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_125(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_125(txt, rest, a_simCode);
      then txt;
  end match;
end lm_125;

public function functionInput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars_inputVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(inputVars = i_vars_inputVars)),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "public override void InputFun()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, c_localRepresentationArrayDefines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_125(txt, i_vars_inputVars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionInput;

protected function lm_127
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//outputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_127(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_127(txt, rest, a_simCode);
      then txt;
  end match;
end lm_127;

public function functionOutput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.SimVar> i_vars_outputVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(outputVars = i_vars_outputVars)),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "public override void OutputFun()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, c_localRepresentationArrayDefines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("// * not yet\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_127(txt, i_vars_outputVars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionOutput;

protected function lm_129
  input Tpl.Text in_txt;
  input list<tuple<Integer, DAE.Exp, DAE.Exp>> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<tuple<Integer, DAE.Exp, DAE.Exp>> rest;
      SimCode.SimCode a_simCode;
      Integer i_index;
      DAE.Exp i_interval;
      DAE.Exp i_start;
      Integer ret_3;
      Tpl.Text l_intervalE;
      Tpl.Text l_startE;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_index, i_start, i_interval) :: rest,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_startE, l_preExp) = daeExp(Tpl.emptyTxt, i_start, SimCode.contextOther, l_preExp, a_simCode);
        (l_intervalE, l_preExp) = daeExp(Tpl.emptyTxt, i_interval, SimCode.contextOther, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* $P$sample"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "SA[i++] = new OneSample("
                                }, false));
        txt = Tpl.writeText(txt, l_intervalE);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_startE);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        ret_3 = intSub(i_index, 1);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", false);"));
        txt = lm_129(txt, rest, a_simCode);
      then txt;
  end match;
end lm_129;

protected function fun_130
  input Tpl.Text in_txt;
  input BackendDAE.SampleLookup in_a_sampleLookup;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sampleLookup, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<tuple<Integer, DAE.Exp, DAE.Exp>> i_lookup;

    case ( txt,
           BackendDAE.SAMPLE_LOOKUP(lookup = i_lookup),
           a_simCode )
      equation
        txt = lm_129(txt, i_lookup, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_130;

public function functionInitSample
  input Tpl.Text txt;
  input BackendDAE.SampleLookup a_sampleLookup;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunSampleInit()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "var SA = SampleHeap.Samples;\n",
                                       "\n"
                                   }, true));
  out_txt := fun_130(out_txt, a_sampleLookup, a_simCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitSample;

protected function lm_132
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_simCode )
      equation
        txt = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_132(txt, rest, a_simCode);
      then txt;
  end match;
end lm_132;

protected function lm_133
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_when :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = genreinits(txt, i_when, x_i0, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_133(txt, rest, a_simCode);
      then txt;
  end match;
end lm_133;

public function functionDAE
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override bool FunDAE()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "var rels = Relations; var preRels = PreRelations; var relsHE = RelationsHysteresisEnabled; var relsZC = RelationsZeroCrossing;\n",
                                       "var needToIterate = false;\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_132(out_txt, a_allEquationsPlusWhen, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_133(out_txt, a_whenClauses, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return needToIterate;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionDAE;

protected function lm_135
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_cr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_cr :: rest,
           a_simCode )
      equation
        txt = cref(txt, i_cr, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = preCref(txt, i_cr, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */"));
        txt = Tpl.nextIter(txt);
        txt = lm_135(txt, rest, a_simCode);
      then txt;
  end match;
end lm_135;

public function whenConditions
  input Tpl.Text txt;
  input list<DAE.ComponentRef> a_conditions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" || ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_135(out_txt, a_conditions, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end whenConditions;

protected function fun_137
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_a_reinits;
  input SimCode.SimCode in_a_simCode;
  input list<DAE.ComponentRef> in_a_conditions;
  input Integer in_a_widx;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_reinits, in_a_simCode, in_a_conditions, in_a_widx)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<DAE.ComponentRef> a_conditions;
      Integer a_widx;
      list<BackendDAE.WhenOperator> i_reinits;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_reinits,
           a_simCode,
           a_conditions,
           a_widx )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//For whenclause index: "));
        txt = Tpl.writeStr(txt, intString(a_widx));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = whenConditions(txt, a_conditions, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = functionWhenReinitStatementThen(txt, i_reinits, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_137;

public function genreinits
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_whenClauses;
  input Integer in_a_widx;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_whenClauses, in_a_widx, in_a_simCode)
    local
      Tpl.Text txt;
      Integer a_widx;
      SimCode.SimCode a_simCode;
      list<DAE.ComponentRef> i_conditions;
      list<BackendDAE.WhenOperator> i_reinits;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(reinits = i_reinits, conditions = i_conditions),
           a_widx,
           a_simCode )
      equation
        txt = fun_137(txt, i_reinits, a_simCode, i_conditions, a_widx);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end genreinits;

protected function fun_139
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_reinit, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Absyn.Info i_info;
      DAE.Exp i_condition;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Tpl.Text l_msgVar;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_stateVar, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "needToIterate = true;"
                                }, false));
      then txt;

    case ( txt,
           BackendDAE.TERMINATE(message = i_message),
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp) = daeExp(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE("));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message),
           a_simCode )
      equation
        txt = assertCommon(txt, i_condition, i_message, i_info, SimCode.contextSimulationDiscrete, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_139;

protected function lm_140
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      SimCode.SimCode a_simCode;
      BackendDAE.WhenOperator i_reinit;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_reinit :: rest,
           a_simCode )
      equation
        txt = fun_139(txt, i_reinit, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_140(txt, rest, a_simCode);
      then txt;
  end match;
end lm_140;

public function functionWhenReinitStatementThen
  input Tpl.Text txt;
  input list<BackendDAE.WhenOperator> a_reinits;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_140(out_txt, a_reinits, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionWhenReinitStatementThen;

protected function fun_142
  input Tpl.Text in_txt;
  input Boolean in_a_isReadOnly;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReadOnly)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_142;

public function infoArgs
  input Tpl.Text in_txt;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_info)
    local
      Tpl.Text txt;
      Boolean i_isReadOnly;
      Integer i_columnNumberEnd;
      Integer i_lineNumberEnd;
      Integer i_columnNumberStart;
      Integer i_lineNumberStart;
      String i_fileName;

    case ( txt,
           Absyn.INFO(fileName = i_fileName, lineNumberStart = i_lineNumberStart, columnNumberStart = i_columnNumberStart, lineNumberEnd = i_lineNumberEnd, columnNumberEnd = i_columnNumberEnd, isReadOnly = i_isReadOnly) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_fileName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\","));
        txt = Tpl.writeStr(txt, intString(i_lineNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_columnNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_lineNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_columnNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = fun_142(txt, i_isReadOnly);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end infoArgs;

public function assertCommon
  input Tpl.Text txt;
  input DAE.Exp a_condition;
  input DAE.Exp a_message;
  input Absyn.Info a_info;
  input SimCode.Context a_context;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_msgVar;
  Tpl.Text l_condVar;
  Tpl.Text l_preExpMsg;
  Tpl.Text l_preExpCond;
algorithm
  l_preExpCond := Tpl.emptyTxt;
  l_preExpMsg := Tpl.emptyTxt;
  (l_condVar, l_preExpCond) := daeExp(Tpl.emptyTxt, a_condition, a_context, l_preExpCond, a_simCode);
  (l_msgVar, l_preExpMsg) := daeExp(Tpl.emptyTxt, a_message, a_context, l_preExpMsg, a_simCode);
  out_txt := Tpl.writeText(txt, l_preExpCond);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("if (!"));
  out_txt := Tpl.writeText(out_txt, l_condVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(") {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_preExpMsg);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("//"));
  out_txt := infoArgs(out_txt, a_info);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("throw new Exception("));
  out_txt := Tpl.writeText(out_txt, l_msgVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(");\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end assertCommon;

protected function lm_145
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.Exp i_relation__;
      String ret_2;
      Tpl.Text l_zc;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_zc, l_preExp) = zeroCrossing(Tpl.emptyTxt, i_relation__, l_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//ZC for: "));
        ret_2 = ExpressionDump.printExpStr(i_relation__);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gout["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_zc);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_145(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_145(txt, rest, a_simCode);
      then txt;
  end match;
end lm_145;

public function functionZeroCrossing
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossingLst;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunZeroCrossings(double time, double[] gout) //TODO:??time in original is *t only ... how is it called?\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("var rels = Relations; var relsHE = RelationsHysteresisEnabled; var relsZC = RelationsZeroCrossing;\n"));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_145(out_txt, a_zeroCrossingLst, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionZeroCrossing;

public function zeroCrossing
  input Tpl.Text in_txt;
  input DAE.Exp in_a_zcExp;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_zcExp, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.Exp i_idx;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      DAE.Exp i_zcExp;
      Tpl.Text txt_3;
      String ret_3;
      Tpl.Text l_indx;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           (i_zcExp as DAE.RELATION(index = -1)),
           a_preExp,
           a_simCode )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, i_zcExp, SimCode.contextZeroCross, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")?1:-1"));
      then (txt, a_preExp);

    case ( txt,
           (i_zcExp as DAE.RELATION(exp1 = i_exp1, exp2 = i_exp2)),
           a_preExp,
           a_simCode )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, a_preExp, a_simCode);
        (l_e2, a_preExp) = daeExp(Tpl.emptyTxt, i_exp2, SimCode.contextZeroCross, a_preExp, a_simCode);
        (txt, l_e1, l_e2) = zeroCrossingValue(txt, i_zcExp, l_e1, l_e2);
      then (txt, a_preExp);

    case ( txt,
           DAE.LBINARY(exp1 = DAE.CALL(path = Absyn.IDENT(name = "initial"), expLst = {}), operator = DAE.OR(ty = _), exp2 = i_exp2),
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*opt out initial()*/"));
        (txt, a_preExp) = zeroCrossing(txt, i_exp2, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.LBINARY(exp1 = DAE.LUNARY(operator = DAE.NOT(ty = _), exp = DAE.CALL(path = Absyn.IDENT(name = "initial"), expLst = {})), operator = DAE.AND(ty = _), exp2 = i_exp2),
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*opt out initial()*/"));
        (txt, a_preExp) = zeroCrossing(txt, i_exp2, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           (i_zcExp as DAE.LBINARY(exp1 = _)),
           a_preExp,
           a_simCode )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, i_zcExp, SimCode.contextZeroCross, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") ? 1:-1"));
      then (txt, a_preExp);

    case ( txt,
           (i_zcExp as DAE.LUNARY(operator = _)),
           a_preExp,
           a_simCode )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, i_zcExp, SimCode.contextZeroCross, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") ? 1:-1"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_exp1, i_idx}),
           a_preExp,
           a_simCode )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, a_preExp, a_simCode);
        (l_indx, a_preExp) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(Math.Floor("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != mathEVPre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]) ? 1:-1"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "floor"), expLst = {i_exp1, i_idx}),
           a_preExp,
           a_simCode )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, a_preExp, a_simCode);
        (l_indx, a_preExp) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(Math.Floor("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != mathEVPre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]) ? 1:-1"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "ceil"), expLst = {i_exp1, i_idx}),
           a_preExp,
           a_simCode )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, a_preExp, a_simCode);
        (l_indx, a_preExp) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(Math.Ceil("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != mathEVPre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]) ? 1:-1"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_exp1, i_exp2, i_idx}),
           a_preExp,
           a_simCode )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, a_preExp, a_simCode);
        (l_e2, a_preExp) = daeExp(Tpl.emptyTxt, i_exp2, SimCode.contextZeroCross, a_preExp, a_simCode);
        (l_indx, a_preExp) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("( (int)("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != (int)mathEVPre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ) ? 1:-1"));
      then (txt, a_preExp);

    case ( txt,
           i_zcExp,
           a_preExp,
           _ )
      equation
        txt_3 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unexpected zero crossing expression: "));
        ret_3 = ExpressionDump.printExpStr(i_zcExp);
        txt_3 = Tpl.writeStr(txt_3, ret_3);
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 965, 11), Tpl.textString(txt_3));
      then (txt, a_preExp);
  end match;
end zeroCrossing;

public function zeroCrossingOpFunc
  input Tpl.Text in_txt;
  input DAE.Operator in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.LESS(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Less"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Greater"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LessEq"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("GreaterEq"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("!!!Equal"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("!!!NEqual"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("!!!unsupported ZC operator!!!"));
      then txt;
  end match;
end zeroCrossingOpFunc;

public function functionRelations
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_relations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_relationsCode;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_relationsCode := relationsTpl(Tpl.emptyTxt, a_relations, SimCode.contextOther, a_simCode);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunUpdateRelations()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "var rels = Relations; var relsHE = RelationsHysteresisEnabled; var relsZC = RelationsZeroCrossing;\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_relationsCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionRelations;

protected function lm_150
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_simCode,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = relationTpl(txt, x_i0, i_relation__, a_context, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_150(txt, rest, a_simCode, a_context);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode,
           a_context )
      equation
        txt = lm_150(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_150;

public function relationsTpl
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_relations;
  input SimCode.Context a_context;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_150(out_txt, a_relations, a_simCode, a_context);
  out_txt := Tpl.popIter(out_txt);
end relationsTpl;

protected function fun_152
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relationExp;
  input Integer in_a_index1;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_relationExp, in_a_index1, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      Integer a_index1;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.Exp i_relationExp;
      Integer i_index;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      String ret_4;
      String ret_3;
      Tpl.Text l_e2;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           (i_relationExp as DAE.RELATION(exp1 = i_exp1, exp2 = i_exp2, index = i_index)),
           _,
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp) = daeExp(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_simCode);
        (l_e2, l_preExp) = daeExp(Tpl.emptyTxt, i_exp2, a_context, l_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//relation["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]: "));
        ret_3 = ExpressionDump.printExpStr(i_relationExp);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        (txt, l_e1, l_e2) = relationWithZeroCrossing(txt, i_relationExp, l_e1, l_e2);
      then txt;

    case ( txt,
           i_relationExp,
           a_index1,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// UNKNOWN Relation["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]:  "));
        ret_4 = ExpressionDump.printExpStr(i_relationExp);
        txt = Tpl.writeStr(txt, ret_4);
      then txt;
  end match;
end fun_152;

public function relationTpl
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relationExp;
  input SimCode.Context a_context;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_152(txt, a_relationExp, a_index1, a_context, a_simCode);
end relationTpl;

public function functionStoreDelayed
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunStoreDelayed()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionStoreDelayed;

protected function lm_155
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_it;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           a_simCode )
      equation
        txt = equation_(txt, i_it, SimCode.contextSimulationNonDiscrete, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_155(txt, rest, a_simCode);
      then txt;
  end match;
end lm_155;

protected function lm_156
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqs :: rest,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_155(txt, i_eqs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_156(txt, rest, a_simCode);
      then txt;
  end match;
end lm_156;

public function functionODE
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_stateContEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunODE()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("var preRels = PreRelations;\n"));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_156(out_txt, a_stateContEquations, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionODE;

protected function lm_158
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_saeq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_saeq as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_simCode )
      equation
        txt = equation_(txt, i_saeq, SimCode.contextOther, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_158(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_158(txt, rest, a_simCode);
      then txt;
  end match;
end lm_158;

protected function lm_159
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_cref;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//Debug.WriteLine(\"Setting variable start value: {0}(start={1})\", \""));
        txt = cref(txt, i_cref, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", "));
        txt = cref(txt, i_cref, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_159(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_159(txt, rest, a_simCode);
      then txt;
  end match;
end lm_159;

public function functionUpdateBoundStartValues
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_startValueEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void UpdateBoundStartValues()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_158(out_txt, a_startValueEquations, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "//if (sim_verbose) {\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_159(out_txt, a_startValueEquations, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("//}\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateBoundStartValues;

protected function fun_161
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.SCONST(string = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[_i++] = 0;"));
      then txt;

    case ( txt,
           i_exp,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp) = daeExpToReal(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[_i++] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_161;

protected function lm_162
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp) :: rest,
           a_simCode )
      equation
        txt = fun_161(txt, i_exp, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_162(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_162(txt, rest, a_simCode);
      then txt;
  end match;
end lm_162;

public function functionInitialResidual
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_residualEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void InitialResidual(double[] initialResiduals, double[][] startValues)\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "//  var startX = startStates; var startY = startAlgebraics; var startYB = startAlgebraicsBool; var startYI = startAlgebraicsInt;\n",
                                       "  int _i = 0;\n",
                                       "//  const double _lambda = 1.0;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_162(out_txt, a_residualEquations, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialResidual;

protected function fun_164
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem i_cont;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont),
           a_simCode,
           a_context )
      equation
        txt = functionNonlinearResidual(txt, i_cont, a_context, a_simCode);
      then txt;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = _)),
           a_simCode,
           a_context )
      equation
        txt = functionNonlinearResidual(txt, i_eq, a_context, a_simCode);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_164;

protected function lm_165
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_context )
      equation
        txt = fun_164(txt, i_eq, a_simCode, a_context);
        txt = Tpl.nextIter(txt);
        txt = lm_165(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_165;

public function functionNonlinearResiduals
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.Context a_context;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_165(out_txt, a_allEquations, a_simCode, a_context);
  out_txt := Tpl.popIter(out_txt);
end functionNonlinearResiduals;

protected function lm_167
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_cr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_cr :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_cr, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = xloc["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_167(txt, rest, a_simCode);
      then txt;
  end match;
end lm_167;

protected function fun_168
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_saeq;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_saeq, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_saeq;

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           _,
           _ )
      then txt;

    case ( txt,
           i_saeq,
           a_simCode,
           a_context )
      equation
        txt = equation_(txt, i_saeq, a_context, a_simCode);
      then txt;
  end match;
end fun_168;

protected function lm_169
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_saeq;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_saeq :: rest,
           a_simCode,
           a_context )
      equation
        txt = fun_168(txt, i_saeq, a_simCode, a_context);
        txt = Tpl.nextIter(txt);
        txt = lm_169(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_169;

protected function lm_170
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp) :: rest,
           a_simCode,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_170(txt, rest, a_simCode, a_context);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode,
           a_context )
      equation
        txt = lm_170(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_170;

public function functionNonlinearResidual
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_equ;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_equ, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> i_eqs;
      list<DAE.ComponentRef> i_crefs;
      Integer i_index;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index, crefs = i_crefs, eqs = i_eqs),
           a_context,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int ResidualFun"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int n, double[] xloc, double[] res, int iflag)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, c_localRepresentationArrayDefines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("var rels = Relations; var preRels = PreRelations; var relsHE = RelationsHysteresisEnabled; var relsZC = RelationsZeroCrossing;\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_167(txt, i_crefs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_169(txt, i_eqs, a_simCode, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_170(txt, i_eqs, a_simCode, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionNonlinearResidual;

public function functionInitialNonLinearSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_inlineEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunInitialNonLinearSystem()\n",
                                   "{\n",
                                   "  var nlss = NonLinearSystems;\n",
                                   "  NLSystem nls;\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := bodyNonLinearSystems(out_txt, a_initialEquations, a_simCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := bodyNonLinearSystems(out_txt, a_inlineEquations, a_simCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := bodyNonLinearSystems(out_txt, a_parameterEquations, a_simCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := bodyNonLinearSystems(out_txt, a_allEquations, a_simCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialNonLinearSystems;

protected function lm_173
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_simCode )
      equation
        txt = bodyInitialNonLinearSystem(txt, i_eqn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_173(txt, rest, a_simCode);
      then txt;
  end match;
end lm_173;

public function bodyNonLinearSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_equations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_173(out_txt, a_equations, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end bodyNonLinearSystems;

protected function fun_175
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominalValue;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nominalValue, in_a_i0)
    local
      Tpl.Text txt;
      Integer a_i0;
      Real i_exp_real;

    case ( txt,
           SOME(DAE.RCONST(real = i_exp_real)),
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nls.Nominals["));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeStr(txt, realString(i_exp_real));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // "));
      then txt;

    case ( txt,
           SOME(_),
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 1172, 44), "Unexpected expression for nominal value.");
      then txt;

    case ( txt,
           _,
           a_i0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//["));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] default nominal = 1.0 for "));
      then txt;
  end match;
end fun_175;

protected function smf_176
  input Tpl.Text in_txt;
  input SimCode.SimVar in_it;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_cr;
  input Integer in_a_i0;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it, in_a_simCode, in_a_cr, in_a_i0)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_cr;
      Integer a_i0;
      Option<DAE.Exp> i_nominalValue;
      Tpl.Text l_nominalAssign;

    case ( txt,
           SimCode.SIMVAR(nominalValue = i_nominalValue),
           a_simCode,
           a_cr,
           a_i0 )
      equation
        l_nominalAssign = fun_175(Tpl.emptyTxt, i_nominalValue, a_i0);
        txt = Tpl.writeText(txt, l_nominalAssign);
        txt = crefStr(txt, a_cr, a_simCode);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end smf_176;

protected function lm_177
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_cr;
      SimCode.SimVar ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_cr :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        ret_0 = SimCodeUtil.cref2simvar(i_cr, a_simCode);
        txt = smf_176(txt, ret_0, a_simCode, i_cr, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_177(txt, rest, a_simCode);
      then txt;
  end match;
end lm_177;

public function bodyInitialNonLinearSystem
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Integer i_index;
      Integer i_indexNonLinearSystem;
      list<DAE.ComponentRef> i_crefs;
      SimCode.SimEqSystem i_cont;
      Tpl.Text l_attribs;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont),
           a_simCode )
      equation
        txt = bodyInitialNonLinearSystem(txt, i_cont, a_simCode);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, indexNonLinearSystem = i_indexNonLinearSystem, index = i_index),
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_attribs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_attribs = lm_177(l_attribs, i_crefs, a_simCode);
        l_attribs = Tpl.popIter(l_attribs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nls = nlss["));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = new NLSystem(this, ResidualFun"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.writeText(txt, l_attribs);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end bodyInitialNonLinearSystem;

protected function lm_179
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_simCode )
      equation
        txt = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_179(txt, rest, a_simCode);
      then txt;
  end match;
end lm_179;

public function functionInitialEquations
  input Tpl.Text txt;
  input Boolean a_useSymbolicInitialization;
  input list<SimCode.SimEqSystem> a_initalEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("public override bool UseSymbolicInitialization { get { return "));
  out_txt := Tpl.writeStr(out_txt, Tpl.booleanString(a_useSymbolicInitialization));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "; } }\n",
                                       "public override void FunInitialEquations()\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("var rels = Relations; var relsHE = RelationsHysteresisEnabled; var relsZC = RelationsZeroCrossing;\n"));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_179(out_txt, a_initalEquations, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialEquations;

protected function lm_181
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_saeq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_saeq as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_simCode )
      equation
        txt = equation_(txt, i_saeq, SimCode.contextOther, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_181(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_181(txt, rest, a_simCode);
      then txt;
  end match;
end lm_181;

protected function lm_182
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_eq as SimCode.SES_ALGORITHM(index = _)) :: rest,
           a_simCode )
      equation
        txt = equation_(txt, i_eq, SimCode.contextOther, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_182(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_182(txt, rest, a_simCode);
      then txt;
  end match;
end lm_182;

public function functionUpdateBoundParameters
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void UpdateBoundParameters()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, c_localRepresentationArrayDefines);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_181(out_txt, a_parameterEquations, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_182(out_txt, a_parameterEquations, a_simCode);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateBoundParameters;

protected function fun_184
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_var;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_var;

    case ( txt,
           (i_var as DAE.CREF_QUAL(ident = _)),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = preCref(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = cref(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") return true;"));
      then txt;

    case ( txt,
           (i_var as DAE.CREF_IDENT(ident = _)),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = preCref(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = cref(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") return true;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_184;

protected function lm_185
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = fun_184(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_185(txt, rest, a_simCode);
      then txt;
  end match;
end lm_185;

public function functionCheckForDiscreteChanges
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<DAE.ComponentRef> i_discreteModelVars;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(discreteModelVars = i_discreteModelVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "public override bool CheckForDiscreteChanges()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, c_localRepresentationArrayDefines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//var needToIterate = false;\n",
                                    "//if change()\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_185(txt, i_discreteModelVars, i_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return false; //needToIterate;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionCheckForDiscreteChanges;

public function edgeHelpVar
  input Tpl.Text txt;
  input String a_idx;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("(/*edge(h["));
  out_txt := Tpl.writeStr(out_txt, a_idx);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("])*/H["));
  out_txt := Tpl.writeStr(out_txt, a_idx);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("]!=0.0 && preH["));
  out_txt := Tpl.writeStr(out_txt, a_idx);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("]==0.0)"));
end edgeHelpVar;

protected function fun_188
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "bool" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ?1.0:0.0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_188;

public function daeExpToReal
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
protected
  String str_1;
  Tpl.Text txt_0;
algorithm
  (out_txt, out_a_preExp) := daeExp(txt, a_exp, a_context, a_preExp, a_simCode);
  txt_0 := expTypeFromExp(Tpl.emptyTxt, a_exp);
  str_1 := Tpl.textString(txt_0);
  out_txt := fun_188(out_txt, str_1);
end daeExpToReal;

protected function fun_190
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_codeTxt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_codeTxt)
    local
      Tpl.Text txt;
      Tpl.Text a_codeTxt;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "$_start"), expLst = {DAE.CREF(componentRef = _)}),
           a_codeTxt )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//### useless start value assignment ??\n",
                                    "//"
                                }, false));
        txt = Tpl.writeText(txt, a_codeTxt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//###"));
      then txt;

    case ( txt,
           _,
           a_codeTxt )
      equation
        txt = Tpl.writeText(txt, a_codeTxt);
      then txt;
  end match;
end fun_190;

protected function lm_191
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_context )
      equation
        txt = algStatement(txt, i_stmt, a_context, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_191(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_191;

protected function lm_192
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_size;
  input Tpl.Text in_a_aname;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_size, in_a_aname, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      Tpl.Text a_size;
      Tpl.Text a_aname;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_size,
           a_aname,
           a_simCode,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp) = daeExpToReal(Tpl.emptyTxt, i_eq_exp, a_context, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeText(txt, a_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeText(txt, a_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //set_matrix_elt("));
        txt = Tpl.writeText(txt, a_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_192(txt, rest, a_size, a_aname, a_simCode, a_context);
      then txt;

    case ( txt,
           _ :: rest,
           a_size,
           a_aname,
           a_simCode,
           a_context )
      equation
        txt = lm_192(txt, rest, a_size, a_aname, a_simCode, a_context);
      then txt;
  end match;
end lm_192;

protected function lm_193
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_bname;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_bname, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_bname;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_it;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           a_bname,
           a_simCode,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp) = daeExpToReal(Tpl.emptyTxt, i_it, a_context, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //set_vector_elt("));
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_193(txt, rest, a_bname, a_simCode, a_context);
      then txt;
  end match;
end lm_193;

protected function fun_194
  input Tpl.Text in_txt;
  input Boolean in_a_partOfMixed;
  input Tpl.Text in_a_uid;
  input Tpl.Text in_a_size;
  input Tpl.Text in_a_bname;
  input Tpl.Text in_a_aname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_partOfMixed, in_a_uid, in_a_size, in_a_bname, in_a_aname)
    local
      Tpl.Text txt;
      Tpl.Text a_uid;
      Tpl.Text a_size;
      Tpl.Text a_bname;
      Tpl.Text a_aname;

    case ( txt,
           false,
           a_uid,
           a_size,
           a_bname,
           a_aname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SolveLinearSystem("));
        txt = Tpl.writeText(txt, a_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_uid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_uid,
           a_size,
           a_bname,
           a_aname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(SolveLinearSystemMixed("));
        txt = Tpl.writeText(txt, a_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_uid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != 0) found_solution = -1;"));
      then txt;
  end match;
end fun_194;

protected function lm_195
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_a_bname;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_bname, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Tpl.Text a_bname;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_bname,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; //get_vector_elt("));
        txt = Tpl.writeText(txt, a_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_195(txt, rest, a_bname, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_bname,
           a_simCode )
      equation
        txt = lm_195(txt, rest, a_bname, a_simCode);
      then txt;
  end match;
end lm_195;

protected function lm_196
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_preDisc;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preDisc;
algorithm
  (out_txt, out_a_preDisc) :=
  match(in_txt, in_items, in_a_preDisc, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_preDisc;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.Exp i_discEq_exp;
      DAE.ComponentRef i_discEq_cref;

    case ( txt,
           {},
           a_preDisc,
           _,
           _ )
      then (txt, a_preDisc);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_discEq_cref, exp = i_discEq_exp) :: rest,
           a_preDisc,
           a_context,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_discEq_cref, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        (txt, a_preDisc) = daeExp(txt, i_discEq_exp, a_context, a_preDisc, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "double discrete_loc2_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = crefToReal(txt, i_discEq_cref, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_preDisc) = lm_196(txt, rest, a_preDisc, a_context, a_simCode);
      then (txt, a_preDisc);

    case ( txt,
           _ :: rest,
           a_preDisc,
           a_context,
           a_simCode )
      equation
        (txt, a_preDisc) = lm_196(txt, rest, a_preDisc, a_context, a_simCode);
      then (txt, a_preDisc);
  end match;
end lm_196;

protected function lm_197
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double discrete_loc_"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = crefToReal(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_197(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_197(txt, rest, a_simCode);
      then txt;
  end match;
end lm_197;

protected function lm_198
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = _) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ( Math.Abs(discrete_loc_"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - discrete_loc2_"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") > 1e-12) found_solution = 0;"));
        txt = Tpl.nextIter(txt);
        txt = lm_198(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_198(txt, rest);
      then txt;
  end match;
end lm_198;

protected function lm_199
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = preCref(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != boolVar["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_199(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_199(txt, rest, a_simCode);
      then txt;
  end match;
end lm_199;

protected function lm_200
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nls_X["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_200(txt, rest, a_simCode);
      then txt;
  end match;
end lm_200;

protected function lm_201
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text txt_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("nls_X["));
        txt_0 = Tpl.writeStr(txt_0, intString(x_i0));
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING("]"));
        (txt, txt_0) = convertRealExpForCref(txt, txt_0, i_name, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_201(txt, rest, a_simCode);
      then txt;
  end match;
end lm_201;

protected function fun_202
  input Tpl.Text in_txt;
  input Option<SimCode.SimEqSystem> in_a_elseWhen;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elseWhen, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_ew;

    case ( txt,
           SOME(i_ew),
           a_simCode,
           a_context )
      equation
        txt = equationElseWhen(txt, i_ew, a_context, a_simCode);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_202;

protected function fun_203
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_a_conditions;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_conditions, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<DAE.ComponentRef> i_conditions;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_conditions,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = whenConditions(txt, i_conditions, a_simCode);
      then txt;
  end match;
end fun_203;

protected function fun_204
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_elseWhenConds;
  input Tpl.Text in_a_rightExp;
  input DAE.ComponentRef in_a_left;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;
  input list<DAE.ComponentRef> in_a_conditions;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialCall, in_a_elseWhenConds, in_a_rightExp, in_a_left, in_a_preExp, in_a_simCode, in_a_conditions)
    local
      Tpl.Text txt;
      Tpl.Text a_elseWhenConds;
      Tpl.Text a_rightExp;
      DAE.ComponentRef a_left;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      list<DAE.ComponentRef> a_conditions;

    case ( txt,
           false,
           a_elseWhenConds,
           a_rightExp,
           a_left,
           a_preExp,
           a_simCode,
           a_conditions )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("if( ! Initial) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = whenConditions(txt, a_conditions, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_left, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_rightExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, a_elseWhenConds);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           a_elseWhenConds,
           a_rightExp,
           a_left,
           a_preExp,
           a_simCode,
           a_conditions )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(Initial"));
        txt = fun_203(txt, a_conditions, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_left, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_rightExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, a_elseWhenConds);
      then txt;
  end match;
end fun_204;

public function equation_
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_left;
      list<DAE.ComponentRef> i_conditions;
      Boolean i_initialCall;
      Option<SimCode.SimEqSystem> i_elseWhen;
      DAE.Exp i_right;
      Integer i_indexNonLinearSystem;
      Integer i_index;
      list<DAE.ComponentRef> i_crefs;
      list<SimCode.SimEqSystem> i_discEqs;
      list<SimCode.SimVar> i_discVars;
      SimCode.SimEqSystem i_cont;
      Boolean i_partOfMixed;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<SimCode.SimVar> i_vars;
      list<DAE.Statement> i_statements;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_elseWhenConds;
      Tpl.Text l_rightExp;
      Integer ret_15;
      Tpl.Text l_discLoc2;
      Tpl.Text l_preDisc;
      Integer ret_12;
      Tpl.Text l_numDiscVarsStr;
      Tpl.Text l_contEqs;
      Integer ret_9;
      Tpl.Text l_bname;
      Tpl.Text l_aname;
      Integer ret_6;
      Tpl.Text l_size;
      Integer ret_4;
      Tpl.Text l_uid;
      Tpl.Text l_codeTxt;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_simCode);
        l_codeTxt = Tpl.writeText(Tpl.emptyTxt, l_preExp);
        l_codeTxt = Tpl.softNewLine(l_codeTxt);
        l_codeTxt = cref(l_codeTxt, i_cref, a_simCode);
        l_codeTxt = Tpl.writeTok(l_codeTxt, Tpl.ST_STRING(" = "));
        l_codeTxt = Tpl.writeText(l_codeTxt, l_expPart);
        l_codeTxt = Tpl.writeTok(l_codeTxt, Tpl.ST_STRING(";"));
        txt = fun_190(txt, i_exp, l_codeTxt);
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SES_ARRAY_CALL_ASSIGN"));
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = i_statements),
           a_context,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_191(txt, i_statements, a_simCode, a_context);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, simJac = i_simJac, beqs = i_beqs, partOfMixed = i_partOfMixed),
           a_context,
           a_simCode )
      equation
        ret_4 = System.tmpTick();
        l_uid = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        ret_6 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_6));
        l_aname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("A"));
        l_aname = Tpl.writeText(l_aname, l_uid);
        l_bname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("b"));
        l_bname = Tpl.writeText(l_bname, l_uid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var "));
        txt = Tpl.writeText(txt, l_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; //declare_matrix("));
        txt = Tpl.writeText(txt, l_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "var "
                                }, false));
        txt = Tpl.writeText(txt, l_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; //declare_vector("));
        txt = Tpl.writeText(txt, l_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_192(txt, i_simJac, l_size, l_aname, a_simCode, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_193(txt, i_beqs, l_bname, a_simCode, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_194(txt, i_partOfMixed, l_uid, l_size, l_bname, l_aname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_195(txt, i_vars, l_bname, a_simCode);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discVars = i_discVars, discEqs = i_discEqs),
           a_context,
           a_simCode )
      equation
        ret_9 = System.tmpTick();
        l_uid = Tpl.writeStr(Tpl.emptyTxt, intString(ret_9));
        l_contEqs = equation_(Tpl.emptyTxt, i_cont, a_context, a_simCode);
        ret_12 = listLength(i_discVars);
        l_numDiscVarsStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_12));
        l_preDisc = Tpl.emptyTxt;
        l_discLoc2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_discLoc2, l_preDisc) = lm_196(l_discLoc2, i_discEqs, l_preDisc, a_context, a_simCode);
        l_discLoc2 = Tpl.popIter(l_discLoc2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// *** mixed_equation_system("));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ") ***\n",
                                    "{ int found_solution = 0;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var boolVar = new bool["));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("];\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  do {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_197(txt, i_discVars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_contEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_preDisc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_discLoc2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "  // check_discrete_values(...);\n",
                                    "  if (found_solution == -1) { /*system of equations failed*/\n",
                                    "      found_solution = 0;\n",
                                    "  } else {\n",
                                    "      found_solution = 1;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     "else "
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_198(txt, i_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  if (found_solution == 0) { //!found_solution\n",
                                    "       if (NextMixedBoolCombination(boolVar)){\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(9));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_199(txt, i_discVars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "       }\n",
                                    "       else\n",
                                    "         throw new Exception(\"Mixed system could not be solved.\");\n",
                                    "  }\n",
                                    "}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  } while (found_solution == 0);\n",
                                    "} // *** mixed_equation_system_end("
                                }, false));
        txt = Tpl.writeText(txt, l_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") ***"));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, index = i_index, indexNonLinearSystem = i_indexNonLinearSystem),
           _,
           a_simCode )
      equation
        ret_15 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_15));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//start NLS ResidualFun"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", size="));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "{ var nls = NonLinearSystems["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]; var nls_X = nls.X;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_200(txt, i_crefs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("nls.Solve();\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_201(txt, i_crefs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} //end_nonlinear_system();"));
      then txt;

    case ( txt,
           SimCode.SES_WHEN(right = i_right, elseWhen = i_elseWhen, initialCall = i_initialCall, conditions = i_conditions, left = i_left),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_rightExp, l_preExp) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp, a_simCode);
        l_elseWhenConds = fun_202(Tpl.emptyTxt, i_elseWhen, a_simCode, a_context);
        txt = fun_204(txt, i_initialCall, l_elseWhenConds, l_rightExp, i_left, l_preExp, a_simCode, i_conditions);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 1485, 9), "UNKNOWN_equation");
      then txt;
  end match;
end equation_;

protected function fun_206
  input Tpl.Text in_txt;
  input Option<SimCode.SimEqSystem> in_a_elseWhen;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_elseWhen, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_ew;

    case ( txt,
           SOME(i_ew),
           a_simCode,
           a_context )
      equation
        txt = equationElseWhen(txt, i_ew, a_context, a_simCode);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_206;

public function equationElseWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_left;
      list<DAE.ComponentRef> i_conditions;
      Option<SimCode.SimEqSystem> i_elseWhen;
      DAE.Exp i_right;
      Tpl.Text l_elseWhenConds;
      Tpl.Text l_rightExp;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_WHEN(right = i_right, elseWhen = i_elseWhen, conditions = i_conditions, left = i_left),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_rightExp, l_preExp) = daeExp(Tpl.emptyTxt, i_right, a_context, l_preExp, a_simCode);
        l_elseWhenConds = fun_206(Tpl.emptyTxt, i_elseWhen, a_simCode, a_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if("));
        txt = whenConditions(txt, i_conditions, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_left, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_rightExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_elseWhenConds);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end equationElseWhen;

protected function smf_208
  input Tpl.Text in_txt;
  input SimCode.SimVar in_it;
  input Tpl.Text in_a_indexTxt;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_indexTxt;
algorithm
  (out_txt, out_a_indexTxt) :=
  match(in_txt, in_it, in_a_indexTxt)
    local
      Tpl.Text txt;
      Tpl.Text a_indexTxt;
      DAE.Type i_type__;
      BackendDAE.VarKind i_varKind;
      Integer i_index;

    case ( txt,
           SimCode.SIMVAR(index = i_index, varKind = i_varKind, type_ = i_type__),
           a_indexTxt )
      equation
        a_indexTxt = Tpl.writeStr(a_indexTxt, intString(i_index));
        txt = representationArrayName(txt, i_varKind, i_type__);
      then (txt, a_indexTxt);

    case ( txt,
           _,
           a_indexTxt )
      then (txt, a_indexTxt);
  end match;
end smf_208;

public function crefRepresentationArrayAndIndex
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_indexTxt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_indexTxt;
algorithm
  (out_txt, out_a_indexTxt) :=
  match(in_txt, in_a_cr, in_a_indexTxt, in_a_simCode)
    local
      Tpl.Text txt;
      Tpl.Text a_indexTxt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_cr;
      DAE.ComponentRef i_componentRef;
      SimCode.SimVar ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = "time"),
           a_indexTxt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Time"));
      then (txt, a_indexTxt);

    case ( txt,
           DAE.CREF_IDENT(ident = "$_lambda"),
           a_indexTxt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_lambda"));
      then (txt, a_indexTxt);

    case ( txt,
           DAE.CREF_QUAL(ident = "$PRE", componentRef = i_componentRef),
           a_indexTxt,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pre"));
        (txt, a_indexTxt) = crefRepresentationArrayAndIndex(txt, i_componentRef, a_indexTxt, a_simCode);
      then (txt, a_indexTxt);

    case ( txt,
           i_cr,
           a_indexTxt,
           a_simCode )
      equation
        ret_0 = SimCodeUtil.cref2simvar(i_cr, a_simCode);
        (txt, a_indexTxt) = smf_208(txt, ret_0, a_indexTxt);
      then (txt, a_indexTxt);
  end match;
end crefRepresentationArrayAndIndex;

public function representationArrayName
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind, in_a_type__)
    local
      Tpl.Text txt;
      DAE.Type a_type__;

    case ( txt,
           BackendDAE.VARIABLE(),
           a_type__ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Y"));
        txt = representationArrayNameTypePostfix(txt, a_type__);
      then txt;

    case ( txt,
           BackendDAE.STATE(index = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("X"));
      then txt;

    case ( txt,
           BackendDAE.STATE_DER(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Xd"));
      then txt;

    case ( txt,
           BackendDAE.DUMMY_DER(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Y"));
      then txt;

    case ( txt,
           BackendDAE.DUMMY_STATE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Y"));
      then txt;

    case ( txt,
           BackendDAE.DISCRETE(),
           a_type__ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Y"));
        txt = representationArrayNameTypePostfix(txt, a_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*d*/"));
      then txt;

    case ( txt,
           BackendDAE.PARAM(),
           a_type__ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("P"));
        txt = representationArrayNameTypePostfix(txt, a_type__);
      then txt;

    case ( txt,
           BackendDAE.EXTOBJ(fullClassName = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EO"));
      then txt;

    case ( txt,
           BackendDAE.CONST(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CONST_VAR_KIND"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("BAD_VARKIND"));
      then txt;
  end match;
end representationArrayName;

public function representationArrayNameTypePostfix
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("I"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("I"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("B"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("S"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("BAD_ARRAY_NAME_POSTFIX"));
      then txt;
  end match;
end representationArrayNameTypePostfix;

protected function fun_212
  input Tpl.Text in_txt;
  input Tpl.Text in_a_indexTxt;
  input Tpl.Text in_a_arrAndIdx;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_indexTxt, in_a_arrAndIdx)
    local
      Tpl.Text txt;
      Tpl.Text a_arrAndIdx;
      Tpl.Text i_indexTxt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_arrAndIdx )
      equation
        txt = Tpl.writeText(txt, a_arrAndIdx);
      then txt;

    case ( txt,
           i_indexTxt,
           a_arrAndIdx )
      equation
        txt = Tpl.writeText(txt, a_arrAndIdx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, i_indexTxt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end fun_212;

public function representationCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_inCref;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_arrAndIdx;
  Tpl.Text l_indexTxt;
algorithm
  l_indexTxt := Tpl.emptyTxt;
  (l_arrAndIdx, l_indexTxt) := crefRepresentationArrayAndIndex(Tpl.emptyTxt, a_inCref, l_indexTxt, a_simCode);
  out_txt := fun_212(txt, l_indexTxt, l_arrAndIdx);
end representationCref;

public function cref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/*"));
  out_txt := crefStr(out_txt, a_cr, a_simCode);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("*/"));
  out_txt := representationCref(out_txt, a_cr, a_simCode);
end cref;

public function preCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/*pre("));
  out_txt := crefStr(out_txt, a_cr, a_simCode);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")*/pre"));
  out_txt := representationCref(out_txt, a_cr, a_simCode);
end preCref;

public function derCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  DAE.ComponentRef ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/*derCall!!("));
  out_txt := crefStr(out_txt, a_cr, a_simCode);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")*/"));
  ret_0 := SimCodeUtil.derComponentRef(a_cr);
  out_txt := representationCref(out_txt, ret_0, a_simCode);
end derCref;

protected function fun_217
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind)
    local
      Tpl.Text txt;

    case ( txt,
           BackendDAE.STATE(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("State"));
      then txt;

    case ( txt,
           BackendDAE.STATE_DER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateDer"));
      then txt;

    case ( txt,
           BackendDAE.VARIABLE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algebraic"));
      then txt;

    case ( txt,
           BackendDAE.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Parameter"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNEXPECTED_variable_varKind_in_startCref_template"));
      then txt;
  end match;
end fun_217;

protected function fun_218
  input Tpl.Text in_txt;
  input SimCode.SimVar in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer i_sv_index;
      BackendDAE.VarKind i_varKind;
      Tpl.Text l_fviIndex;

    case ( txt,
           SimCode.SIMVAR(varKind = i_varKind, index = i_sv_index) )
      equation
        l_fviIndex = fun_217(Tpl.emptyTxt, i_varKind);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("startValues[(int)SimVarType."));
        txt = Tpl.writeText(txt, l_fviIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]["));
        txt = Tpl.writeStr(txt, intString(i_sv_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_218;

public function startCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  SimCode.SimVar ret_0;
algorithm
  ret_0 := SimCodeUtil.cref2simvar(a_cr, a_simCode);
  out_txt := fun_218(txt, ret_0);
end startCref;

protected function fun_220
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("?1.0:0.0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_220;

protected function smf_221
  input Tpl.Text in_txt;
  input SimCode.SimVar in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it)
    local
      Tpl.Text txt;
      Integer i_index;
      DAE.Type i_type__;
      BackendDAE.VarKind i_varKind;

    case ( txt,
           SimCode.SIMVAR(varKind = i_varKind, type_ = i_type__, index = i_index) )
      equation
        txt = representationArrayName(txt, i_varKind, i_type__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
        txt = fun_220(txt, i_type__);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end smf_221;

public function crefToReal
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  SimCode.SimVar ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/*(double)"));
  out_txt := crefStr(out_txt, a_cr, a_simCode);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("*/"));
  ret_0 := SimCodeUtil.cref2simvar(a_cr, a_simCode);
  out_txt := smf_221(out_txt, ret_0);
end crefToReal;

protected function fun_223
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("?1.0:0.0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_223;

public function daeExpRealConversionPostfix
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  DAE.Type ret_0;
algorithm
  ret_0 := Expression.typeof(a_exp);
  out_txt := fun_223(txt, ret_0);
end daeExpRealConversionPostfix;

protected function fun_225
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input Tpl.Text in_a_realExp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_realExp)
    local
      Tpl.Text txt;
      Tpl.Text a_realExp;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_realExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_realExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != 0.0"));
      then txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_realExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)("));
        txt = Tpl.writeText(txt, a_realExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_realExp )
      equation
        txt = Tpl.writeText(txt, a_realExp);
      then txt;
  end match;
end fun_225;

protected function smf_226
  input Tpl.Text in_txt;
  input SimCode.SimVar in_it;
  input Tpl.Text in_a_realExp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it, in_a_realExp)
    local
      Tpl.Text txt;
      Tpl.Text a_realExp;
      DAE.Type i_type__;

    case ( txt,
           SimCode.SIMVAR(type_ = i_type__),
           a_realExp )
      equation
        txt = fun_225(txt, i_type__, a_realExp);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end smf_226;

public function convertRealExpForCref
  input Tpl.Text txt;
  input Tpl.Text a_realExp;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_realExp;
protected
  SimCode.SimVar ret_0;
algorithm
  ret_0 := SimCodeUtil.cref2simvar(a_cr, a_simCode);
  out_txt := smf_226(txt, ret_0, a_realExp);
  out_a_realExp := a_realExp;
end convertRealExpForCref;

protected function fun_228
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      SimCode.SimCode a_simCode;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr,
           a_simCode )
      equation
        txt = crefStr(txt, a_cr, a_simCode);
      then txt;

    case ( txt,
           _,
           a_cr,
           a_simCode )
      equation
        txt = cref(txt, a_cr, a_simCode);
      then txt;
  end match;
end fun_228;

public function contextCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_228(txt, a_context, a_cr, a_simCode);
end contextCref;

public function crefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst),
           a_simCode )
      equation
        txt = csharpIdent(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst, a_simCode);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$der("));
        txt = crefStr(txt, i_componentRef, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$PRE", componentRef = i_componentRef),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pre("));
        txt = crefStr(txt, i_componentRef, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef),
           a_simCode )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStr(txt, i_componentRef, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefStr;

public function crefStrWithDerOnLast
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst),
           a_simCode )
      equation
        txt = csharpIdent(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst, a_simCode);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef),
           a_simCode )
      equation
        txt = crefStrWithDerOnLastIsDer(txt, i_componentRef, a_simCode);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef),
           a_simCode )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStrWithDerOnLast(txt, i_componentRef, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefStrWithDerOnLast;

public function crefStrWithDerOnLastIsDer
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = csharpIdent(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef),
           a_simCode )
      equation
        txt = crefStrWithDerOnLastIsDer(txt, i_componentRef, a_simCode);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef),
           a_simCode )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStrWithDerOnLastIsDer(txt, i_componentRef, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefStrWithDerOnLastIsDer;

public function csharpIdent
  input Tpl.Text in_txt;
  input String in_a_ident;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ident)
    local
      Tpl.Text txt;
      String i_ident;

    case ( txt,
           "string" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("@string"));
      then txt;

    case ( txt,
           "int" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("@int"));
      then txt;

    case ( txt,
           i_ident )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;
  end match;
end csharpIdent;

protected function fun_234
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_s;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.Exp i_exp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (txt, l_preExp) = daeExp(txt, i_exp, SimCode.contextFunction, l_preExp, a_simCode);
      then txt;

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (txt, l_preExp) = daeExp(txt, i_exp, SimCode.contextFunction, l_preExp, a_simCode);
      then txt;

    case ( txt,
           DAE.WHOLEDIM(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end match;
end fun_234;

protected function lm_235
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      SimCode.SimCode a_simCode;
      DAE.Subscript i_s;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_s :: rest,
           a_simCode )
      equation
        txt = fun_234(txt, i_s, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_235(txt, rest, a_simCode);
      then txt;
  end match;
end lm_235;

public function subscriptsStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_subscripts,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_235(txt, i_subscripts, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end subscriptsStr;

public function dotPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dotPath;

public function underscorePath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;
      String ret_1;
      String ret_0;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        ret_0 = System.stringReplace(i_name, "_", "__");
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        ret_1 = System.stringReplace(i_name_1, "_", "__");
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end underscorePath;

protected function lm_239
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.Statement i_it;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           a_simCode,
           a_context )
      equation
        txt = algStatement(txt, i_it, a_context, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_239(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_239;

protected function lm_240
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_context )
      equation
        txt = algStatement(txt, i_stmt, a_context, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_240(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_240;

protected function lm_241
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_context )
      equation
        txt = algStatement(txt, i_stmt, a_context, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_241(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_241;

public function algStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.Statement i_stmt;
      Absyn.Info i_info;
      DAE.Exp i_msg;
      DAE.Exp i_cond;
      DAE.Ident i_iter;
      DAE.Exp i_rng;
      Boolean i_iterIsArray;
      DAE.Type i_type__;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_componentRef_ident;
      list<DAE.Subscript> i_subs;
      DAE.Exp i_exp1;
      DAE.Exp i_exp;
      DAE.Exp i_e;
      Tpl.Text l_var;
      Tpl.Text l_stmtStr;
      Tpl.Text l_identTypeShort;
      Tpl.Text l_identType;
      Tpl.Text l_condExp;
      Tpl.Text l_spec;
      Tpl.Text l_expPart2;
      Tpl.Text l_expPart1;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = DAE.CREF(componentRef = DAE.WILD()), exp = i_e),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp) = daeExp(Tpl.emptyTxt, i_e, a_context, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart);
      then txt;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(componentRef = _)), exp = i_exp),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        (txt, l_preExp) = scalarLhsCref(txt, i_exp1, a_context, l_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = i_exp1, exp = i_exp),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart1, l_preExp) = daeExp(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_simCode);
        (l_expPart2, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.STMT_ASSIGN_ARR(componentRef = DAE.CREF_IDENT(subscriptLst = (i_subs as _ :: _), ident = i_componentRef_ident), exp = i_exp),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_simCode);
        (l_spec, l_preExp) = daeExpCrefRhsIndexSpec(Tpl.emptyTxt, i_subs, a_context, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_componentRef_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".AssignSpec("));
        txt = Tpl.writeText(txt, l_spec);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".A);"));
      then txt;

    case ( txt,
           DAE.STMT_ASSIGN_ARR(exp = i_exp, componentRef = i_componentRef),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ArrayCopy("));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".A, "));
        txt = contextCref(txt, i_componentRef, a_context, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".A);"));
      then txt;

    case ( txt,
           DAE.STMT_IF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_239(txt, i_statementLst, a_simCode, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = elseExpr(txt, i_else__, a_context, a_simCode);
      then txt;

    case ( txt,
           DAE.STMT_FOR(range = (i_rng as DAE.RANGE(ty = _)), type_ = i_type__, iterIsArray = i_iterIsArray, statementLst = i_statementLst, iter = i_iter),
           a_context,
           a_simCode )
      equation
        l_identType = expType(Tpl.emptyTxt, i_type__, i_iterIsArray);
        l_identTypeShort = expTypeShort(Tpl.emptyTxt, i_type__);
        l_stmtStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_stmtStr = lm_240(l_stmtStr, i_statementLst, a_simCode, a_context);
        l_stmtStr = Tpl.popIter(l_stmtStr);
        (txt, l_stmtStr) = algStmtForRange_impl(txt, i_rng, i_iter, Tpl.textString(l_identType), Tpl.textString(l_identTypeShort), l_stmtStr, a_context, a_simCode);
      then txt;

    case ( txt,
           DAE.STMT_FOR(type_ = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("algStmtForGeneric_NOT_IMPLEMENTED"));
      then txt;

    case ( txt,
           DAE.STMT_WHILE(exp = i_exp, statementLst = i_statementLst),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_var, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("for(;;) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (!"));
        txt = Tpl.writeText(txt, l_var);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") break;\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_241(txt, i_statementLst, a_simCode, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           DAE.STMT_TUPLE_ASSIGN(type_ = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_TUPLE_ASSIGN_NI"));
      then txt;

    case ( txt,
           DAE.STMT_ASSERT(source = DAE.SOURCE(info = i_info), cond = i_cond, msg = i_msg),
           a_context,
           a_simCode )
      equation
        txt = assertCommon(txt, i_cond, i_msg, i_info, a_context, a_simCode);
      then txt;

    case ( txt,
           DAE.STMT_TERMINATE(msg = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_TERMINATE_NI"));
      then txt;

    case ( txt,
           (i_stmt as DAE.STMT_WHEN(exp = _)),
           a_context,
           a_simCode )
      equation
        txt = algStmtWhen(txt, i_stmt, a_context, a_simCode);
      then txt;

    case ( txt,
           DAE.STMT_BREAK(source = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break; //break stmt"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           DAE.STMT_FAILURE(body = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_FAILURE_NI"));
      then txt;

    case ( txt,
           DAE.STMT_TRY(tryBody = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_TRY_NI"));
      then txt;

    case ( txt,
           DAE.STMT_CATCH(catchBody = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_CATCH_NI"));
      then txt;

    case ( txt,
           DAE.STMT_THROW(source = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_THROW_NI"));
      then txt;

    case ( txt,
           DAE.STMT_RETURN(source = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_RETURN_NI"));
      then txt;

    case ( txt,
           DAE.STMT_NORETCALL(exp = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_NORETCALL_NI"));
      then txt;

    case ( txt,
           DAE.STMT_REINIT(var = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("STMT_REINIT_NI"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT_IMPLEMENTED_ALG_STATEMENT"));
      then txt;
  end match;
end algStatement;

protected function fun_243
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_step;
  input Tpl.Text in_a_body;
  input Tpl.Text in_a_startValue;
  input Tpl.Text in_a_iterName;
  input Tpl.Text in_a_stopValue;
  input Tpl.Text in_a_stopVar;
  input String in_a_type;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_stopVar;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_stopVar, out_a_preExp) :=
  match(in_txt, in_a_step, in_a_body, in_a_startValue, in_a_iterName, in_a_stopValue, in_a_stopVar, in_a_type, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_body;
      Tpl.Text a_startValue;
      Tpl.Text a_iterName;
      Tpl.Text a_stopValue;
      Tpl.Text a_stopVar;
      String a_type;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_eo;
      Tpl.Text l_stepValue;
      Tpl.Text l_stepVar;

    case ( txt,
           SOME(i_eo),
           a_body,
           a_startValue,
           a_iterName,
           a_stopValue,
           a_stopVar,
           a_type,
           a_simCode,
           a_preExp,
           a_context )
      equation
        l_stepVar = Tpl.emptyTxt;
        (l_stepValue, a_preExp) = daeExp(Tpl.emptyTxt, i_eo, a_context, a_preExp, a_simCode);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        (txt, l_stepVar) = tempDecl(txt, a_type, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_stepValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        (txt, a_stopVar) = tempDecl(txt, a_type, a_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_stopValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "for("
                                }, false));
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";("));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > 0? "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<="));
        txt = Tpl.writeText(txt, a_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        txt = Tpl.writeText(txt, a_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<="));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" += "));
        txt = Tpl.writeText(txt, l_stepVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_stopVar, a_preExp);

    case ( txt,
           _,
           a_body,
           a_startValue,
           a_iterName,
           a_stopValue,
           a_stopVar,
           a_type,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        (txt, a_stopVar) = tempDecl(txt, a_type, a_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_stopValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "for("
                                }, false));
        txt = Tpl.writeStr(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<="));
        txt = Tpl.writeText(txt, a_stopVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; "));
        txt = Tpl.writeText(txt, a_iterName);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" += 1) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_stopVar, a_preExp);
  end match;
end fun_243;

protected function fun_244
  input Tpl.Text in_txt;
  input DAE.Exp in_a_range;
  input Absyn.Ident in_a_iterator;
  input String in_a_type;
  input Tpl.Text in_a_body;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_range, in_a_iterator, in_a_type, in_a_body, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Ident a_iterator;
      String a_type;
      Tpl.Text a_body;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Option<DAE.Exp> i_step;
      DAE.Exp i_stop;
      DAE.Exp i_start;
      Tpl.Text l_stopValue;
      Tpl.Text l_startValue;
      Tpl.Text l_preExp;
      Tpl.Text l_stopVar;
      Tpl.Text l_iterName;

    case ( txt,
           DAE.RANGE(start = i_start, stop = i_stop, step = i_step),
           a_iterator,
           a_type,
           a_body,
           a_context,
           a_simCode )
      equation
        l_iterName = Tpl.writeStr(Tpl.emptyTxt, a_iterator);
        l_stopVar = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        (l_startValue, l_preExp) = daeExp(Tpl.emptyTxt, i_start, a_context, l_preExp, a_simCode);
        (l_stopValue, l_preExp) = daeExp(Tpl.emptyTxt, i_stop, a_context, l_preExp, a_simCode);
        (txt, l_stopVar, l_preExp) = fun_243(txt, i_step, a_body, l_startValue, l_iterName, l_stopValue, l_stopVar, a_type, a_simCode, l_preExp, a_context);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_244;

public function algStmtForRange_impl
  input Tpl.Text txt;
  input DAE.Exp a_range;
  input Absyn.Ident a_iterator;
  input String a_type;
  input String a_shortType;
  input Tpl.Text a_body;
  input SimCode.Context a_context;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_body;
algorithm
  out_txt := fun_244(txt, a_range, a_iterator, a_type, a_body, a_context, a_simCode);
  out_a_body := a_body;
end algStmtForRange_impl;

protected function lm_246
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.Statement i_it;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           a_simCode,
           a_context )
      equation
        txt = algStatement(txt, i_it, a_context, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_246(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_246;

protected function lm_247
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.Statement i_it;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           a_simCode,
           a_context )
      equation
        txt = algStatement(txt, i_it, a_context, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_247(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_247;

public function elseExpr
  input Tpl.Text in_txt;
  input DAE.Else in_a_it;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      DAE.Else i_else__;
      list<DAE.Statement> i_statementLst;
      DAE.Exp i_exp;
      Tpl.Text l_condExp;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.NOELSE(),
           _,
           _ )
      then txt;

    case ( txt,
           DAE.ELSEIF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           a_context,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_condExp, l_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, l_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_246(txt, i_statementLst, a_simCode, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = elseExpr(txt, i_else__, a_context, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           DAE.ELSE(statementLst = i_statementLst),
           a_context,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_247(txt, i_statementLst, a_simCode, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end elseExpr;

protected function lm_249
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_stmt :: rest,
           a_simCode,
           a_context )
      equation
        txt = algStatement(txt, i_stmt, a_context, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_249(txt, rest, a_simCode, a_context);
      then txt;
  end match;
end lm_249;

protected function fun_250
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_a_conditions;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_conditions, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<DAE.ComponentRef> i_conditions;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_conditions,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = whenConditions(txt, i_conditions, a_simCode);
      then txt;
  end match;
end fun_250;

protected function fun_251
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;
  input Option<DAE.Statement> in_a_elseWhen;
  input Tpl.Text in_a_statements;
  input SimCode.SimCode in_a_simCode;
  input list<DAE.ComponentRef> in_a_conditions;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialCall, in_a_elseWhen, in_a_statements, in_a_simCode, in_a_conditions)
    local
      Tpl.Text txt;
      Option<DAE.Statement> a_elseWhen;
      Tpl.Text a_statements;
      SimCode.SimCode a_simCode;
      list<DAE.ComponentRef> a_conditions;

    case ( txt,
           false,
           a_elseWhen,
           a_statements,
           a_simCode,
           a_conditions )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("if( ! Initial) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = whenConditions(txt, a_conditions, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = algStatementWhenElse(txt, a_elseWhen, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           a_elseWhen,
           a_statements,
           a_simCode,
           a_conditions )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if(Initial"));
        txt = fun_250(txt, a_conditions, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = algStatementWhenElse(txt, a_elseWhen, a_simCode);
      then txt;
  end match;
end fun_251;

protected function fun_252
  input Tpl.Text in_txt;
  input DAE.Statement in_a_when;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_when, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Option<DAE.Statement> i_elseWhen;
      list<DAE.ComponentRef> i_conditions;
      Boolean i_initialCall;
      list<DAE.Statement> i_statementLst;
      Tpl.Text l_statements;

    case ( txt,
           DAE.STMT_WHEN(statementLst = i_statementLst, initialCall = i_initialCall, conditions = i_conditions, elseWhen = i_elseWhen),
           a_simCode,
           a_context )
      equation
        l_statements = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_statements = lm_249(l_statements, i_statementLst, a_simCode, a_context);
        l_statements = Tpl.popIter(l_statements);
        txt = fun_251(txt, i_initialCall, i_elseWhen, l_statements, a_simCode, i_conditions);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_252;

protected function fun_253
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Statement in_a_when;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_when, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Statement a_when;
      SimCode.SimCode a_simCode;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.SIMULATION_CONTEXT(genDiscrete = true)),
           a_when,
           a_simCode )
      equation
        txt = fun_252(txt, a_when, a_simCode, i_context);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_253;

public function algStmtWhen
  input Tpl.Text txt;
  input DAE.Statement a_when;
  input SimCode.Context a_context;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_253(txt, a_context, a_when, a_simCode);
end algStmtWhen;

protected function lm_255
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      SimCode.SimCode a_simCode;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_stmt :: rest,
           a_simCode )
      equation
        txt = algStatement(txt, i_stmt, SimCode.contextSimulationDiscrete, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_255(txt, rest, a_simCode);
      then txt;
  end match;
end lm_255;

public function algStatementWhenElse
  input Tpl.Text in_txt;
  input Option<DAE.Statement> in_a_stmt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stmt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Option<DAE.Statement> i_when_elseWhen;
      list<DAE.Statement> i_when_statementLst;
      list<DAE.ComponentRef> i_when_conditions;

    case ( txt,
           SOME(DAE.STMT_WHEN(conditions = i_when_conditions, statementLst = i_when_statementLst, elseWhen = i_when_elseWhen)),
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if ("));
        txt = whenConditions(txt, i_when_conditions, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_255(txt, i_when_statementLst, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = algStatementWhenElse(txt, i_when_elseWhen, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end algStatementWhenElse;

protected function fun_257
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_ecr_componentRef, in_a_simCode, in_a_preExp, in_a_context, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_ecr;

    case ( txt,
           false,
           _,
           a_simCode,
           a_preExp,
           a_context,
           a_ecr )
      equation
        (txt, a_preExp) = daeExpCrefRhs(txt, a_ecr, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_simCode,
           a_preExp,
           a_context,
           _ )
      equation
        txt = contextCref(txt, a_ecr_componentRef, a_context, a_simCode);
      then (txt, a_preExp);
  end match;
end fun_257;

public function scalarLhsCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.Exp i_ecr;
      DAE.ComponentRef i_ecr_componentRef;
      Boolean ret_0;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_IDENT(subscriptLst = _)))),
           a_context,
           a_preExp,
           a_simCode )
      equation
        ret_0 = SimCodeUtil.crefNoSub(i_ecr_componentRef);
        (txt, a_preExp) = fun_257(txt, ret_0, i_ecr_componentRef, a_simCode, a_preExp, a_context, i_ecr);
      then (txt, a_preExp);

    case ( txt,
           DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_QUAL(ident = _))),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = contextCref(txt, i_ecr_componentRef, a_context, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ONLY_IDENT_OR_QUAL_CREF_SUPPORTED_SLHS"));
      then (txt, a_preExp);
  end match;
end scalarLhsCref;

public function rhsCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_it;
  input DAE.Type in_a_ty;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it, in_a_ty, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident),
           a_ty,
           _ )
      equation
        txt = rhsCrefType(txt, a_ty);
        txt = replaceDollarWorkaround(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef),
           a_ty,
           a_simCode )
      equation
        txt = rhsCrefType(txt, a_ty);
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = rhsCref(txt, i_componentRef, a_ty, a_simCode);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rhsCref:ERROR"));
      then txt;
  end match;
end rhsCref;

public function rhsCrefType
  input Tpl.Text in_txt;
  input DAE.Type in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end rhsCrefType;

public function replaceDollarWorkaround
  input Tpl.Text txt;
  input String a_ident;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  ret_0 := System.stringReplace(a_ident, "$DER", "Der_");
  ret_1 := System.stringReplace(ret_0, "$", "");
  out_txt := Tpl.writeStr(txt, ret_1);
end replaceDollarWorkaround;

protected function fun_262
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end match;
end fun_262;

protected function fun_263
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_inExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_simCode, in_a_preExp, in_a_inExp)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_inExp;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           a_simCode,
           a_preExp,
           a_inExp )
      equation
        (txt, a_preExp) = daeExpCrefRhs(txt, a_inExp, i_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpRecordCrefRhs_NOT_YET"));
      then (txt, a_preExp);
  end match;
end fun_263;

public function daeExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_inExp, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      DAE.Exp i_exp;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      DAE.Operator i_operator;
      DAE.Exp i_inExp;
      DAE.ComponentRef i_componentRef;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, a_preExp);

    case ( txt,
           DAE.RCONST(real = i_real),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then (txt, a_preExp);

    case ( txt,
           DAE.SCONST(string = i_string),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = Util.escapeModelicaStringToCString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then (txt, a_preExp);

    case ( txt,
           DAE.BCONST(bool = i_bool),
           _,
           a_preExp,
           _ )
      equation
        txt = fun_262(txt, i_bool);
      then (txt, a_preExp);

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then (txt, a_preExp);

    case ( txt,
           DAE.CREF(ty = DAE.T_FUNCTION_REFERENCE_FUNC(builtin = _), componentRef = i_componentRef),
           _,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("FUNC_REF_NOT_SUPPORTED(cr="));
        txt = crefStr(txt, i_componentRef, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.CREF(ty = DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = fun_263(txt, a_context, a_simCode, a_preExp, i_inExp);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.CREF(componentRef = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpCrefRhs(txt, i_inExp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.LBINARY(operator = i_operator, exp1 = i_exp1, exp2 = i_exp2),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpBinary(txt, i_operator, i_exp1, i_exp2, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.BINARY(operator = i_operator, exp1 = i_exp1, exp2 = i_exp2),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpBinary(txt, i_operator, i_exp1, i_exp2, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.LUNARY(operator = i_operator, exp = i_exp),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpUnary(txt, i_operator, i_exp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.UNARY(operator = i_operator, exp = i_exp),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpUnary(txt, i_operator, i_exp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.RELATION(exp1 = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpRelation(txt, i_inExp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpIf(txt, i_expCond, i_expThen, i_expElse, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.CALL(path = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpCall(txt, i_inExp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.ARRAY(ty = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpArray(txt, i_inExp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.MATRIX(ty = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpMatrix(txt, i_inExp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.RANGE(ty = _),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RANGE_NOT_IMPLEMENTED"));
      then (txt, a_preExp);

    case ( txt,
           DAE.TUPLE(PR = _),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TUPLE_NOT_IMPLEMENTED"));
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.CAST(ty = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpCast(txt, i_inExp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.ASUB(exp = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpAsub(txt, i_inExp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.SIZE(exp = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpSize(txt, i_inExp, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.CODE(code = _),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CODE_NOT_IMPLEMENTED"));
      then (txt, a_preExp);

    case ( txt,
           DAE.REDUCTION(reductionInfo = _),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("REDUCTION_NOT_IMPLEMENTED"));
      then (txt, a_preExp);

    case ( txt,
           DAE.LIST(valList = _),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LIST_NOT_IMPLEMENTED"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CONS(car = _),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CONS_NOT_IMPLEMENTED"));
      then (txt, a_preExp);

    case ( txt,
           DAE.SHARED_LITERAL(index = i_index),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_OMC_LIT"));
        txt = Tpl.writeStr(txt, intString(i_index));
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_EXP"));
      then (txt, a_preExp);
  end match;
end daeExp;

protected function fun_265
  input Tpl.Text in_txt;
  input DAE.Exp in_a_dim;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_expPart;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_dim, in_a_simCode, in_a_preExp, in_a_context, in_a_expPart)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Tpl.Text a_expPart;
      DAE.Exp i_dim;
      Integer i_integer;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           _,
           a_expPart )
      equation
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".size"));
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, a_preExp);

    case ( txt,
           i_dim,
           a_simCode,
           a_preExp,
           a_context,
           a_expPart )
      equation
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".size("));
        (txt, a_preExp) = daeExp(txt, i_dim, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);
  end match;
end fun_265;

public function daeExpSize
  input Tpl.Text in_txt;
  input DAE.Exp in_a_esize;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_esize, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.Exp i_dim;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           DAE.SIZE(exp = (i_exp as DAE.CREF(componentRef = _)), sz = SOME(i_dim)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_expPart, a_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_simCode);
        (txt, a_preExp) = fun_265(txt, i_dim, a_simCode, a_preExp, a_context, l_expPart);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_X_NOT_IMPLEMENTED"));
      then (txt, a_preExp);
  end match;
end daeExpSize;

protected function lm_267
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp) = daeExp(txt, i_exp, a_context, a_preExp, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_267(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);

    case ( txt,
           _ :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp) = lm_267(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_267;

protected function fun_268
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_preExp, in_a_simCode, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      list<DAE.Subscript> ret_5;
      DAE.ComponentRef ret_4;
      list<DAE.Subscript> ret_3;
      Tpl.Text l_spec;
      DAE.ComponentRef ret_1;
      Tpl.Text l_arrName;

    case ( txt,
           false,
           a_preExp,
           a_simCode,
           a_context,
           a_cr )
      equation
        ret_1 = ComponentReference.crefStripLastSubs(a_cr);
        l_arrName = contextCref(Tpl.emptyTxt, ret_1, a_context, a_simCode);
        ret_3 = ComponentReference.crefSubs(a_cr);
        (l_spec, a_preExp) = daeExpCrefRhsIndexSpec(Tpl.emptyTxt, ret_3, a_context, a_preExp, a_simCode);
        txt = Tpl.writeText(txt, l_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".Array1Spec("));
        txt = Tpl.writeText(txt, l_spec);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           _,
           a_preExp,
           a_simCode,
           a_context,
           a_cr )
      equation
        ret_4 = ComponentReference.crefStripLastSubs(a_cr);
        l_arrName = contextCref(Tpl.emptyTxt, ret_4, a_context, a_simCode);
        txt = Tpl.writeText(txt, l_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_5 = ComponentReference.crefSubs(a_cr);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_preExp) = lm_267(txt, ret_5, a_simCode, a_preExp, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);
  end match;
end fun_268;

protected function fun_269
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_preExp, in_a_simCode, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Boolean ret_0;

    case ( txt,
           false,
           a_preExp,
           a_simCode,
           a_context,
           a_cr )
      equation
        ret_0 = SimCodeUtil.crefSubIsScalar(a_cr);
        (txt, a_preExp) = fun_268(txt, ret_0, a_preExp, a_simCode, a_context, a_cr);
      then (txt, a_preExp);

    case ( txt,
           _,
           a_preExp,
           a_simCode,
           a_context,
           a_cr )
      equation
        txt = contextCref(txt, a_cr, a_context, a_simCode);
      then (txt, a_preExp);
  end match;
end fun_269;

protected function fun_270
  input Tpl.Text in_txt;
  input Tpl.Text in_a_box;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_box, in_a_preExp, in_a_simCode, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      DAE.ComponentRef a_cr;
      Tpl.Text i_box;
      Boolean ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_preExp,
           a_simCode,
           a_context,
           a_cr )
      equation
        ret_0 = SimCodeUtil.crefIsScalar(a_cr, a_context);
        (txt, a_preExp) = fun_269(txt, ret_0, a_preExp, a_simCode, a_context, a_cr);
      then (txt, a_preExp);

    case ( txt,
           i_box,
           a_preExp,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_box);
      then (txt, a_preExp);
  end match;
end fun_270;

public function daeExpCrefRhs
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_cr;
      DAE.Exp i_ecr;
      Tpl.Text l_box;

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = i_cr)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_box, a_preExp) = daeExpCrefRhsArrayBox(Tpl.emptyTxt, i_ecr, a_context, a_preExp, a_simCode);
        (txt, a_preExp) = fun_270(txt, l_box, a_preExp, a_simCode, a_context, i_cr);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_RHS_CREF"));
      then (txt, a_preExp);
  end match;
end daeExpCrefRhs;

protected function lm_272
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_272(txt, rest);
      then txt;
  end match;
end lm_272;

protected function fun_273
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input DAE.Dimensions in_a_dims;
  input DAE.Type in_a_aty;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_preExp, in_a_simCode, in_a_ecr_componentRef, in_a_dims, in_a_aty)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_ecr_componentRef;
      DAE.Dimensions a_dims;
      DAE.Type a_aty;
      Tpl.Text l_reprArray;
      Tpl.Text l_indexTxt;
      Tpl.Text l_dimsValuesStr;
      Integer ret_2;
      Tpl.Text l_arrType;
      Tpl.Text l_tmpArr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_preExp,
           _,
           _,
           _,
           _ )
      then (txt, a_preExp);

    case ( txt,
           _,
           a_preExp,
           a_simCode,
           a_ecr_componentRef,
           a_dims,
           a_aty )
      equation
        l_tmpArr = Tpl.emptyTxt;
        ret_2 = listLength(a_dims);
        l_arrType = expTypeArray(Tpl.emptyTxt, a_aty, ret_2);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dimsValuesStr = lm_272(l_dimsValuesStr, a_dims);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        l_indexTxt = Tpl.emptyTxt;
        (l_reprArray, l_indexTxt) = crefRepresentationArrayAndIndex(Tpl.emptyTxt, a_ecr_componentRef, l_indexTxt, a_simCode);
        (a_preExp, l_tmpArr) = tempDecl(a_preExp, "var", l_tmpArr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = new "));
        a_preExp = Tpl.writeText(a_preExp, l_arrType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_dimsValuesStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(", "));
        a_preExp = Tpl.writeText(a_preExp, l_indexTxt);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("-1, /*"));
        a_preExp = crefStr(a_preExp, a_ecr_componentRef, a_simCode);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("*/"));
        a_preExp = Tpl.writeText(a_preExp, l_reprArray);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpArr);
      then (txt, a_preExp);
  end match;
end fun_273;

public function daeExpCrefRhsArrayBox
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.Dimensions i_dims;
      DAE.Type i_aty;

    case ( txt,
           DAE.CREF(ty = DAE.T_ARRAY(ty = i_aty, dims = i_dims), componentRef = i_ecr_componentRef),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = fun_273(txt, a_context, a_preExp, a_simCode, i_ecr_componentRef, i_dims, i_aty);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);
  end match;
end daeExpCrefRhsArrayBox;

protected function lm_275
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_e;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_e :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = expTypeFromExp(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        (txt, a_preExp) = daeExp(txt, i_e, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-1"));
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_275(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_275;

protected function fun_276
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_exp, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Exp> i_array;

    case ( txt,
           DAE.ARRAY(scalar = true, ty = DAE.T_INTEGER(varLst = _), array = i_array),
           a_simCode,
           a_preExp,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("new int[]{"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_preExp) = lm_275(txt, i_array, a_simCode, a_preExp, a_context);
        txt = Tpl.popIter(txt);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UKNOWN_SLICE_EXP"));
      then (txt, a_preExp);
  end match;
end fun_276;

protected function fun_277
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_sub;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_sub, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_simCode,
           a_preExp,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("new int[]{"));
        (txt, a_preExp) = daeExp(txt, i_exp, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-1}"));
      then (txt, a_preExp);

    case ( txt,
           DAE.WHOLEDIM(),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("null"));
      then (txt, a_preExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_simCode,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp) = fun_276(txt, i_exp, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);
  end match;
end fun_277;

protected function lm_278
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Subscript i_sub;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_sub :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp) = fun_277(txt, i_sub, a_simCode, a_preExp, a_context);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_278(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_278;

public function daeExpCrefRhsIndexSpec
  input Tpl.Text txt;
  input list<DAE.Subscript> a_subs;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_preExp) := lm_278(out_txt, a_subs, a_simCode, a_preExp, a_context);
  out_txt := Tpl.popIter(out_txt);
end daeExpCrefRhsIndexSpec;

protected function fun_280
  input Tpl.Text in_txt;
  input DAE.Type in_a_ecr_ty;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<DAE.Exp> in_a_subs;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_ecr_ty, in_a_preExp, in_a_context, in_a_subs, in_a_simCode, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Exp> a_subs;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_cr;
      DAE.Dimensions i_dims;
      Tpl.Text l_baseSub;
      Tpl.Text l_arrayRepr;
      Tpl.Text l_constSum;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_REAL(varLst = _), dims = i_dims),
           a_preExp,
           a_context,
           a_subs,
           a_simCode,
           a_cr )
      equation
        l_constSum = Tpl.emptyTxt;
        (l_arrayRepr, l_constSum) = crefRepresentationArrayAndIndex(Tpl.emptyTxt, a_cr, l_constSum, a_simCode);
        (l_baseSub, l_constSum, a_preExp) = asubSubsripts(Tpl.emptyTxt, i_dims, a_subs, l_constSum, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*"));
        txt = crefStr(txt, a_cr, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[]*/"));
        txt = Tpl.writeText(txt, l_arrayRepr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_constSum);
        txt = Tpl.writeText(txt, l_baseSub);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           _,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ASUB_SIMULATION_OTHER_ERROR"));
      then (txt, a_preExp);
  end match;
end fun_280;

protected function fun_281
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input DAE.Type in_a_ecr_ty;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input list<DAE.Exp> in_a_subs;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_cr, in_a_ecr_ty, in_a_simCode, in_a_preExp, in_a_subs, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      DAE.Type a_ecr_ty;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      list<DAE.Exp> a_subs;
      DAE.Exp a_ecr;
      SimCode.Context i_context;
      DAE.Exp ret_0;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           _,
           _,
           a_simCode,
           a_preExp,
           a_subs,
           a_ecr )
      equation
        ret_0 = SimCodeUtil.buildCrefExpFromAsub(a_ecr, a_subs);
        (txt, a_preExp) = daeExpCrefRhs(txt, ret_0, i_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           i_context,
           a_cr,
           a_ecr_ty,
           a_simCode,
           a_preExp,
           a_subs,
           _ )
      equation
        (txt, a_preExp) = fun_280(txt, a_ecr_ty, a_preExp, i_context, a_subs, a_simCode, a_cr);
      then (txt, a_preExp);
  end match;
end fun_281;

protected function lm_282
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_index;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_index :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp) = daeExp(txt, i_index, a_context, a_preExp, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_282(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_282;

public function daeExpAsub
  input Tpl.Text in_txt;
  input DAE.Exp in_a_aexp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_aexp, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      list<DAE.Exp> i_indexes;
      DAE.ComponentRef i_cr;
      DAE.Type i_ecr_ty;
      list<DAE.Exp> i_subs;
      DAE.Exp i_ecr;
      Integer i_j;
      Integer i_i;
      DAE.Exp i_e;

    case ( txt,
           DAE.ASUB(exp = DAE.RANGE(ty = _), sub = {_}),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ASUB_EASY_CASE"));
      then (txt, a_preExp);

    case ( txt,
           DAE.ASUB(exp = DAE.ASUB(exp = DAE.ASUB(exp = DAE.ASUB(exp = _, sub = {DAE.ICONST(integer = _)}), sub = {DAE.ICONST(integer = _)}), sub = {DAE.ICONST(integer = _)}), sub = {DAE.ICONST(integer = _)}),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ASUB_4D"));
      then (txt, a_preExp);

    case ( txt,
           DAE.ASUB(exp = DAE.ASUB(exp = DAE.ASUB(exp = _, sub = {DAE.ICONST(integer = _)}), sub = {DAE.ICONST(integer = _)}), sub = {DAE.ICONST(integer = _)}),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ASUB_3D"));
      then (txt, a_preExp);

    case ( txt,
           DAE.ASUB(exp = DAE.ASUB(exp = i_e, sub = {DAE.ICONST(integer = i_i)}), sub = {DAE.ICONST(integer = i_j)}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExp(txt, i_e, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_j));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           DAE.ASUB(exp = _, sub = {DAE.ICONST(integer = _)}),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ASUB_ARRAY"));
      then (txt, a_preExp);

    case ( txt,
           DAE.ASUB(exp = (i_ecr as DAE.CREF(componentRef = i_cr, ty = i_ecr_ty)), sub = i_subs),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = fun_281(txt, a_context, i_cr, i_ecr_ty, a_simCode, a_preExp, i_subs, i_ecr);
      then (txt, a_preExp);

    case ( txt,
           DAE.ASUB(exp = DAE.ARRAY(scalar = true), sub = {_}),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ASUB_FAST_ONE"));
      then (txt, a_preExp);

    case ( txt,
           DAE.ASUB(exp = i_e, sub = i_indexes),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExp(txt, i_e, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_preExp) = lm_282(txt, i_indexes, a_simCode, a_preExp, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("OTHER_ASUB__ERROR"));
      then (txt, a_preExp);
  end match;
end daeExpAsub;

protected function lm_284
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Dimension> rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_284(txt, rest);
      then txt;
  end match;
end lm_284;

protected function fun_285
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_a_dimsRest;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<DAE.Exp> in_a_subsRest;
  input Tpl.Text in_a_subStr;
  input Tpl.Text in_a_constSum;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_constSum;
algorithm
  (out_txt, out_a_preExp, out_a_constSum) :=
  match(in_txt, in_a_dimsRest, in_a_simCode, in_a_preExp, in_a_context, in_a_subsRest, in_a_subStr, in_a_constSum)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Exp> a_subsRest;
      Tpl.Text a_subStr;
      Tpl.Text a_constSum;
      list<DAE.Dimension> i_dimsRest;
      Tpl.Text l_ds;

    case ( txt,
           {},
           _,
           a_preExp,
           _,
           _,
           a_subStr,
           a_constSum )
      equation
        a_constSum = Tpl.writeTok(a_constSum, Tpl.ST_STRING("-1 + "));
        a_constSum = Tpl.writeText(a_constSum, a_subStr);
      then (txt, a_preExp, a_constSum);

    case ( txt,
           i_dimsRest,
           a_simCode,
           a_preExp,
           a_context,
           a_subsRest,
           a_subStr,
           a_constSum )
      equation
        l_ds = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("*")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_ds = lm_284(l_ds, i_dimsRest);
        l_ds = Tpl.popIter(l_ds);
        a_constSum = Tpl.writeTok(a_constSum, Tpl.ST_STRING("-("));
        a_constSum = Tpl.writeText(a_constSum, l_ds);
        a_constSum = Tpl.writeTok(a_constSum, Tpl.ST_STRING(")"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeText(txt, a_subStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*("));
        txt = Tpl.writeText(txt, l_ds);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        (txt, a_constSum, a_preExp) = asubSubsripts(txt, i_dimsRest, a_subsRest, a_constSum, a_context, a_preExp, a_simCode);
      then (txt, a_preExp, a_constSum);
  end match;
end fun_285;

protected function fun_286
  input Tpl.Text in_txt;
  input list<DAE.Dimension> in_a_dims;
  input list<DAE.Exp> in_a_subsRest;
  input Tpl.Text in_a_constSum;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_s;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_constSum;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_constSum, out_a_preExp) :=
  match(in_txt, in_a_dims, in_a_subsRest, in_a_constSum, in_a_simCode, in_a_preExp, in_a_context, in_a_s)
    local
      Tpl.Text txt;
      list<DAE.Exp> a_subsRest;
      Tpl.Text a_constSum;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_s;
      list<DAE.Dimension> i_dimsRest;
      Tpl.Text l_subStr;

    case ( txt,
           _ :: i_dimsRest,
           a_subsRest,
           a_constSum,
           a_simCode,
           a_preExp,
           a_context,
           a_s )
      equation
        (l_subStr, a_preExp) = daeExp(Tpl.emptyTxt, a_s, a_context, a_preExp, a_simCode);
        (txt, a_preExp, a_constSum) = fun_285(txt, i_dimsRest, a_simCode, a_preExp, a_context, a_subsRest, l_subStr, a_constSum);
      then (txt, a_constSum, a_preExp);

    case ( txt,
           _,
           _,
           a_constSum,
           _,
           a_preExp,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ERROR_asubSubsripts_not_enough_dims"));
      then (txt, a_constSum, a_preExp);
  end match;
end fun_286;

protected function fun_287
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_subs;
  input list<DAE.Dimension> in_a_dims;
  input Tpl.Text in_a_constSum;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_constSum;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_constSum, out_a_preExp) :=
  match(in_txt, in_a_subs, in_a_dims, in_a_constSum, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.Dimension> a_dims;
      Tpl.Text a_constSum;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      list<DAE.Exp> i_subsRest;
      DAE.Exp i_s;

    case ( txt,
           i_s :: i_subsRest,
           a_dims,
           a_constSum,
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_constSum, a_preExp) = fun_286(txt, a_dims, i_subsRest, a_constSum, a_simCode, a_preExp, a_context, i_s);
      then (txt, a_constSum, a_preExp);

    case ( txt,
           _,
           _,
           a_constSum,
           _,
           a_preExp,
           _ )
      then (txt, a_constSum, a_preExp);
  end match;
end fun_287;

public function asubSubsripts
  input Tpl.Text txt;
  input list<DAE.Dimension> a_dims;
  input list<DAE.Exp> a_subs;
  input Tpl.Text a_constSum;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_constSum;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_constSum, out_a_preExp) := fun_287(txt, a_subs, a_dims, a_constSum, a_context, a_preExp, a_simCode);
end asubSubsripts;

protected function lm_289
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp) = daeExp(txt, i_exp, a_context, a_preExp, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_289(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_289;

public function arrayScalarRhs
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input list<DAE.Exp> a_subs;
  input Tpl.Text a_arrName;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrName;
  output Tpl.Text out_a_preExp;
protected
  Tpl.Text l_dimsValuesStr;
  Integer ret_1;
  Tpl.Text l_arrayType;
algorithm
  ret_1 := listLength(a_subs);
  l_arrayType := expTypeArray(Tpl.emptyTxt, a_ty, ret_1);
  l_dimsValuesStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_dimsValuesStr, out_a_preExp) := lm_289(l_dimsValuesStr, a_subs, a_simCode, a_preExp, a_context);
  l_dimsValuesStr := Tpl.popIter(l_dimsValuesStr);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("(*ASR"));
  out_txt := Tpl.writeText(out_txt, l_arrayType);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_element_addr(&"));
  out_txt := Tpl.writeText(out_txt, a_arrName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(", , "));
  out_txt := Tpl.writeText(out_txt, l_dimsValuesStr);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("))"));
  out_a_arrName := a_arrName;
end arrayScalarRhs;

protected function fun_291
  input Tpl.Text in_txt;
  input DAE.Operator in_a_it;
  input SimCode.SimCode in_a_simCode;
  input DAE.Exp in_a_exp1;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it, in_a_simCode, in_a_exp1, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      DAE.Exp a_exp1;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      Tpl.Text l_boolConv;

    case ( txt,
           DAE.ADD(ty = _),
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.SUB(ty = _),
           a_simCode,
           a_exp1,
           a_e2,
           a_e1 )
      equation
        l_boolConv = daeExpRealConversionPostfix(Tpl.emptyTxt, a_exp1, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeText(txt, l_boolConv);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") - ("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeText(txt, l_boolConv);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.MUL(ty = _),
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.DIV(ty = _),
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" / "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.POW(ty = _),
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Pow("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.AND(ty = _),
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.OR(ty = _),
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR"));
      then txt;
  end match;
end fun_291;

public function daeExpBinary
  input Tpl.Text txt;
  input DAE.Operator a_it;
  input DAE.Exp a_exp1;
  input DAE.Exp a_exp2;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
protected
  Tpl.Text l_e2;
  Tpl.Text l_e1;
algorithm
  (l_e1, out_a_preExp) := daeExp(Tpl.emptyTxt, a_exp1, a_context, a_preExp, a_simCode);
  (l_e2, out_a_preExp) := daeExp(Tpl.emptyTxt, a_exp2, a_context, out_a_preExp, a_simCode);
  out_txt := fun_291(txt, a_it, a_simCode, a_exp1, l_e2, l_e1);
end daeExpBinary;

protected function fun_293
  input Tpl.Text in_txt;
  input DAE.Operator in_a_it;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_e;

    case ( txt,
           DAE.UMINUS(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(-"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NOT(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UMINUS_ARR_NOT_IMPLEMENTED"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpUnary:ERR"));
      then txt;
  end match;
end fun_293;

public function daeExpUnary
  input Tpl.Text txt;
  input DAE.Operator a_it;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
protected
  Tpl.Text l_e;
algorithm
  (l_e, out_a_preExp) := daeExp(Tpl.emptyTxt, a_exp, a_context, a_preExp, a_simCode);
  out_txt := fun_293(txt, a_it, l_e);
end daeExpUnary;

protected function fun_295
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.LESS(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpRelation:ERR"));
      then txt;
  end match;
end fun_295;

protected function fun_296
  input Tpl.Text in_txt;
  input Tpl.Text in_a_simrel;
  input DAE.Operator in_a_operator;
  input DAE.Exp in_a_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_exp1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_simrel, in_a_operator, in_a_exp2, in_a_simCode, in_a_preExp, in_a_context, in_a_exp1)
    local
      Tpl.Text txt;
      DAE.Operator a_operator;
      DAE.Exp a_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_exp1;
      Tpl.Text i_simrel;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_operator,
           a_exp2,
           a_simCode,
           a_preExp,
           a_context,
           a_exp1 )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, a_exp1, a_context, a_preExp, a_simCode);
        (l_e2, a_preExp) = daeExp(Tpl.emptyTxt, a_exp2, a_context, a_preExp, a_simCode);
        txt = fun_295(txt, a_operator, l_e2, l_e1);
      then (txt, a_preExp);

    case ( txt,
           i_simrel,
           _,
           _,
           _,
           a_preExp,
           _,
           _ )
      equation
        txt = Tpl.writeText(txt, i_simrel);
      then (txt, a_preExp);
  end match;
end fun_296;

public function daeExpRelation
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_inExp, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      DAE.Exp i_inExp;
      Tpl.Text l_simrel;

    case ( txt,
           (i_inExp as DAE.RELATION(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_simrel, a_preExp) = daeExpSimRelation(Tpl.emptyTxt, i_inExp, a_context, a_preExp, a_simCode);
        (txt, a_preExp) = fun_296(txt, l_simrel, i_operator, i_exp2, a_simCode, a_preExp, a_context, i_exp1);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);
  end match;
end daeExpRelation;

protected function fun_298
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end match;
end fun_298;

protected function fun_299
  input Tpl.Text in_txt;
  input Tpl.Text in_a_isReal;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_e2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReal, in_a_rel_index, in_a_e1, in_a_e2)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e1;
      Tpl.Text a_e2;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_rel_index,
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("relsHE["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ? ("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - (HystRelTol * Math.Abs("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") + HystAbsTol))\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":  ("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_299;

protected function fun_300
  input Tpl.Text in_txt;
  input Tpl.Text in_a_isReal;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_e2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReal, in_a_rel_index, in_a_e1, in_a_e2)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e1;
      Tpl.Text a_e2;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_rel_index,
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("relsHE["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ? ("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - (HystRelTol * Math.Abs("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") + HystAbsTol))\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":  ("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_300;

protected function fun_301
  input Tpl.Text in_txt;
  input Tpl.Text in_a_isReal;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReal, in_a_rel_index, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_rel_index,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("relsHE["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ? ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - (HystRelTol * Math.Abs("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") + HystAbsTol))\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":  ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_301;

protected function fun_302
  input Tpl.Text in_txt;
  input Tpl.Text in_a_isReal;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReal, in_a_rel_index, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_rel_index,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("relsHE["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ? ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - (HystRelTol * Math.Abs("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") + HystAbsTol))\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":  ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_302;

protected function fun_303
  input Tpl.Text in_txt;
  input Tpl.Text in_a_isReal;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_e2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReal, in_a_rel_index, in_a_e1, in_a_e2)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e1;
      Tpl.Text a_e2;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Abs("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_rel_index,
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*!!! BE AWARE !!! should not be allowed*/relsHE["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ? (Math.Abs("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") - (HystRelTol * Math.Abs("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") + HystAbsTol))\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":  Math.Abs("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_303;

protected function fun_304
  input Tpl.Text in_txt;
  input Tpl.Text in_a_isReal;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_e2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReal, in_a_rel_index, in_a_e1, in_a_e2)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e1;
      Tpl.Text a_e2;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _,
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Abs("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_rel_index,
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*!!! BE AWARE !!! should not be allowed*/relsHE["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ? (Math.Abs("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") - (HystRelTol * Math.Abs("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") + HystAbsTol))\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":  Math.Abs("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_304;

protected function fun_305
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_isReal;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_rel_index, in_a_e1, in_a_e2, in_a_isReal)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e1;
      Tpl.Text a_e2;
      Tpl.Text a_isReal;

    case ( txt,
           DAE.LESS(ty = _),
           a_rel_index,
           a_e1,
           a_e2,
           a_isReal )
      equation
        txt = fun_299(txt, a_isReal, a_rel_index, a_e1, a_e2);
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _),
           a_rel_index,
           a_e1,
           a_e2,
           a_isReal )
      equation
        txt = fun_300(txt, a_isReal, a_rel_index, a_e1, a_e2);
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _),
           a_rel_index,
           a_e1,
           a_e2,
           a_isReal )
      equation
        txt = fun_301(txt, a_isReal, a_rel_index, a_e2, a_e1);
      then txt;

    case ( txt,
           DAE.GREATER(ty = _),
           a_rel_index,
           a_e1,
           a_e2,
           a_isReal )
      equation
        txt = fun_302(txt, a_isReal, a_rel_index, a_e2, a_e1);
      then txt;

    case ( txt,
           DAE.EQUAL(ty = _),
           a_rel_index,
           a_e1,
           a_e2,
           a_isReal )
      equation
        txt = fun_303(txt, a_isReal, a_rel_index, a_e1, a_e2);
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = _),
           a_rel_index,
           a_e1,
           a_e2,
           a_isReal )
      equation
        txt = fun_304(txt, a_isReal, a_rel_index, a_e1, a_e2);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 2341, 15), "zeroCrossingValue unexpected operator");
      then txt;
  end match;
end fun_305;

protected function fun_306
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inRelationExp;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_e2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inRelationExp, in_a_e1, in_a_e2)
    local
      Tpl.Text txt;
      Tpl.Text a_e1;
      Tpl.Text a_e2;
      Integer i_rel_index;
      DAE.Operator i_operator;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      Boolean ret_5;
      Boolean ret_4;
      DAE.Type ret_3;
      Boolean ret_2;
      DAE.Type ret_1;
      Tpl.Text l_isReal;

    case ( txt,
           DAE.RELATION(exp1 = i_rel_exp1, exp2 = i_rel_exp2, operator = i_operator, index = i_rel_index),
           a_e1,
           a_e2 )
      equation
        ret_1 = Expression.typeof(i_rel_exp1);
        ret_2 = Expression.isRealType(ret_1);
        ret_3 = Expression.typeof(i_rel_exp2);
        ret_4 = Expression.isRealType(ret_3);
        ret_5 = boolOr(ret_2, ret_4);
        l_isReal = fun_298(Tpl.emptyTxt, ret_5);
        txt = fun_305(txt, i_operator, i_rel_index, a_e1, a_e2, l_isReal);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_306;

public function zeroCrossingValue
  input Tpl.Text txt;
  input DAE.Exp a_inRelationExp;
  input Tpl.Text a_e1;
  input Tpl.Text a_e2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_e1;
  output Tpl.Text out_a_e2;
algorithm
  out_txt := fun_306(txt, a_inRelationExp, a_e1, a_e2);
  out_a_e1 := a_e1;
  out_a_e2 := a_e2;
end zeroCrossingValue;

protected function fun_308
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.LESS(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
      then txt;

    case ( txt,
           DAE.GREATER(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 2354, 15), "zeroCrossingRelationOperator unexpected operator");
      then txt;
  end match;
end fun_308;

public function zeroCrossingRelationOperator
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inRelationExp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inRelationExp)
    local
      Tpl.Text txt;
      DAE.Operator i_operator;

    case ( txt,
           DAE.RELATION(operator = i_operator) )
      equation
        txt = fun_308(txt, i_operator);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end zeroCrossingRelationOperator;

public function relationWithZeroCrossing
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inRelationExp;
  input Tpl.Text in_a_e1;
  input Tpl.Text in_a_e2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_e1;
  output Tpl.Text out_a_e2;
algorithm
  (out_txt, out_a_e1, out_a_e2) :=
  match(in_txt, in_a_inRelationExp, in_a_e1, in_a_e2)
    local
      Tpl.Text txt;
      Tpl.Text a_e1;
      Tpl.Text a_e2;
      DAE.Exp i_inRelationExp;
      Integer i_index;

    case ( txt,
           (i_inRelationExp as DAE.RELATION(index = i_index)),
           a_e1,
           a_e2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("relsZC["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        (txt, a_e1, a_e2) = zeroCrossingValue(txt, i_inRelationExp, a_e1, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "rels["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = relsZC["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
        txt = zeroCrossingRelationOperator(txt, i_inRelationExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0.0;"));
      then (txt, a_e1, a_e2);

    case ( txt,
           _,
           a_e1,
           a_e2 )
      then (txt, a_e1, a_e2);
  end match;
end relationWithZeroCrossing;

protected function fun_311
  input Tpl.Text in_txt;
  input Boolean in_a_sim_genDiscrete;
  input DAE.Exp in_a_inRelationExp;
  input DAE.Exp in_a_rel_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;
  input Integer in_a_rel_index;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_sim_genDiscrete, in_a_inRelationExp, in_a_rel_exp2, in_a_simCode, in_a_preExp, in_a_context, in_a_rel_exp1, in_a_rel_index)
    local
      Tpl.Text txt;
      DAE.Exp a_inRelationExp;
      DAE.Exp a_rel_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Integer a_rel_index;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           false,
           _,
           _,
           _,
           a_preExp,
           _,
           _,
           a_rel_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("preRels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           _,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_context,
           a_rel_exp1,
           a_rel_index )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_simCode);
        (l_e2, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_simCode);
        (a_preExp, l_e1, l_e2) = relationWithZeroCrossing(a_preExp, a_inRelationExp, l_e1, l_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);
  end match;
end fun_311;

protected function fun_312
  input Tpl.Text in_txt;
  input Boolean in_a_genInitialisation;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input DAE.Exp in_a_inRelationExp;
  input Tpl.Text in_a_e1e2preExp;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_e2;
  output Tpl.Text out_a_e1;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_e2, out_a_e1, out_a_preExp) :=
  match(in_txt, in_a_genInitialisation, in_a_rel_index, in_a_e2, in_a_e1, in_a_inRelationExp, in_a_e1e2preExp, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      DAE.Exp a_inRelationExp;
      Tpl.Text a_e1e2preExp;
      Tpl.Text a_preExp;
      Tpl.Text l_res;

    case ( txt,
           false,
           a_rel_index,
           a_e2,
           a_e1,
           a_inRelationExp,
           a_e1e2preExp,
           a_preExp )
      equation
        l_res = Tpl.emptyTxt;
        (a_preExp, l_res) = tempDecl(a_preExp, "bool", l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if(IsDiscreteEvaluation) {\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1e2preExp);
        a_preExp = Tpl.softNewLine(a_preExp);
        (a_preExp, a_e1, a_e2) = relationWithZeroCrossing(a_preExp, a_inRelationExp, a_e1, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = IsContinuousEvaluation ? preRels["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] : rels["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("];\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = preRels["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("];"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_e2, a_e1, a_preExp);

    case ( txt,
           _,
           a_rel_index,
           a_e2,
           a_e1,
           a_inRelationExp,
           a_e1e2preExp,
           a_preExp )
      equation
        a_preExp = Tpl.writeText(a_preExp, a_e1e2preExp);
        (a_preExp, a_e1, a_e2) = relationWithZeroCrossing(a_preExp, a_inRelationExp, a_e1, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(IsContinuousEvaluation ? preRels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] : rels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
      then (txt, a_e2, a_e1, a_preExp);
  end match;
end fun_312;

protected function fun_313
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel;
  input DAE.Exp in_a_inRelationExp;
  input DAE.Exp in_a_rel_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input Integer in_a_rel_index;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_rel, in_a_inRelationExp, in_a_rel_exp2, in_a_simCode, in_a_preExp, in_a_rel_exp1, in_a_rel_index)
    local
      Tpl.Text txt;
      DAE.Exp a_rel;
      DAE.Exp a_inRelationExp;
      DAE.Exp a_rel_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      Integer a_rel_index;
      Boolean i_genInitialisation;
      SimCode.Context i_context;
      SimCode.Context i_sim;
      Boolean i_sim_genDiscrete;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;
      Tpl.Text l_e1e2preExp;

    case ( txt,
           (i_sim as SimCode.SIMULATION_CONTEXT(genDiscrete = i_sim_genDiscrete)),
           _,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           a_rel_index )
      equation
        (txt, a_preExp) = fun_311(txt, i_sim_genDiscrete, a_inRelationExp, a_rel_exp2, a_simCode, a_preExp, i_sim, a_rel_exp1, a_rel_index);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = i_genInitialisation)),
           _,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           a_rel_index )
      equation
        l_e1e2preExp = Tpl.emptyTxt;
        (l_e1, l_e1e2preExp) = daeExp(Tpl.emptyTxt, a_rel_exp1, i_context, l_e1e2preExp, a_simCode);
        (l_e2, l_e1e2preExp) = daeExp(Tpl.emptyTxt, a_rel_exp2, i_context, l_e1e2preExp, a_simCode);
        (txt, l_e2, l_e1, a_preExp) = fun_312(txt, i_genInitialisation, a_rel_index, l_e2, l_e1, a_inRelationExp, l_e1e2preExp, a_preExp);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ZEROCROSSINGS_CONTEXT()),
           a_rel,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           _ )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp1, i_context, a_preExp, a_simCode);
        (l_e2, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp2, i_context, a_preExp, a_simCode);
        l_res = Tpl.emptyTxt;
        (a_preExp, l_res) = tempDecl(a_preExp, "bool", l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = ("));
        (a_preExp, l_e1, l_e2) = zeroCrossingValue(a_preExp, a_rel, l_e1, l_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")"));
        a_preExp = zeroCrossingRelationOperator(a_preExp, a_inRelationExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("0.0;"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           _,
           _ )
      then (txt, a_preExp);
  end match;
end fun_313;

protected function fun_314
  input Tpl.Text in_txt;
  input Integer in_a_rel_index;
  input DAE.Exp in_a_rel;
  input DAE.Exp in_a_inRelationExp;
  input DAE.Exp in_a_rel_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_rel_index, in_a_rel, in_a_inRelationExp, in_a_rel_exp2, in_a_simCode, in_a_preExp, in_a_rel_exp1, in_a_context)
    local
      Tpl.Text txt;
      DAE.Exp a_rel;
      DAE.Exp a_inRelationExp;
      DAE.Exp a_rel_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      SimCode.Context a_context;
      Integer i_rel_index;

    case ( txt,
           -1,
           _,
           _,
           _,
           _,
           a_preExp,
           _,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_rel_index,
           a_rel,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           a_context )
      equation
        (txt, a_preExp) = fun_313(txt, a_context, a_rel, a_inRelationExp, a_rel_exp2, a_simCode, a_preExp, a_rel_exp1, i_rel_index);
      then (txt, a_preExp);
  end match;
end fun_314;

protected function fun_315
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inRelationExp;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_inRelationExp, in_a_simCode, in_a_context, in_a_preExp)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      DAE.Exp i_rel;
      Integer i_rel_index;
      String ret_0;

    case ( txt,
           (i_rel as DAE.RELATION(index = i_rel_index, exp1 = i_rel_exp1, exp2 = i_rel_exp2)),
           a_simCode,
           a_context,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("//relation["));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("]:  "));
        ret_0 = ExpressionDump.printExpStr(i_rel);
        a_preExp = Tpl.writeStr(a_preExp, ret_0);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        (txt, a_preExp) = fun_314(txt, i_rel_index, i_rel, i_rel, i_rel_exp2, a_simCode, a_preExp, i_rel_exp1, a_context);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end match;
end fun_315;

protected function fun_316
  input Tpl.Text in_txt;
  input Boolean in_a_sim_genDiscrete;
  input DAE.Exp in_a_inRelationExp;
  input DAE.Exp in_a_rel_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;
  input Integer in_a_rel_index;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_sim_genDiscrete, in_a_inRelationExp, in_a_rel_exp2, in_a_simCode, in_a_preExp, in_a_context, in_a_rel_exp1, in_a_rel_index)
    local
      Tpl.Text txt;
      DAE.Exp a_inRelationExp;
      DAE.Exp a_rel_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Integer a_rel_index;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           false,
           _,
           _,
           _,
           a_preExp,
           _,
           _,
           a_rel_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("preRels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           _,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_context,
           a_rel_exp1,
           a_rel_index )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_simCode);
        (l_e2, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_simCode);
        (a_preExp, l_e1, l_e2) = relationWithZeroCrossing(a_preExp, a_inRelationExp, l_e1, l_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);
  end match;
end fun_316;

protected function fun_317
  input Tpl.Text in_txt;
  input Boolean in_a_genInitialisation;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input DAE.Exp in_a_inRelationExp;
  input Tpl.Text in_a_e1e2preExp;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_e2;
  output Tpl.Text out_a_e1;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_e2, out_a_e1, out_a_preExp) :=
  match(in_txt, in_a_genInitialisation, in_a_rel_index, in_a_e2, in_a_e1, in_a_inRelationExp, in_a_e1e2preExp, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      DAE.Exp a_inRelationExp;
      Tpl.Text a_e1e2preExp;
      Tpl.Text a_preExp;
      Tpl.Text l_res;

    case ( txt,
           false,
           a_rel_index,
           a_e2,
           a_e1,
           a_inRelationExp,
           a_e1e2preExp,
           a_preExp )
      equation
        l_res = Tpl.emptyTxt;
        (a_preExp, l_res) = tempDecl(a_preExp, "bool", l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if(IsDiscreteEvaluation) {\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1e2preExp);
        a_preExp = Tpl.softNewLine(a_preExp);
        (a_preExp, a_e1, a_e2) = relationWithZeroCrossing(a_preExp, a_inRelationExp, a_e1, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = IsContinuousEvaluation ? preRels["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] : rels["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("];\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = preRels["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("];"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_e2, a_e1, a_preExp);

    case ( txt,
           _,
           a_rel_index,
           a_e2,
           a_e1,
           a_inRelationExp,
           a_e1e2preExp,
           a_preExp )
      equation
        a_preExp = Tpl.writeText(a_preExp, a_e1e2preExp);
        (a_preExp, a_e1, a_e2) = relationWithZeroCrossing(a_preExp, a_inRelationExp, a_e1, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(IsContinuousEvaluation ? preRels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] : rels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
      then (txt, a_e2, a_e1, a_preExp);
  end match;
end fun_317;

protected function fun_318
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel;
  input DAE.Exp in_a_inRelationExp;
  input DAE.Exp in_a_rel_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input Integer in_a_rel_index;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_rel, in_a_inRelationExp, in_a_rel_exp2, in_a_simCode, in_a_preExp, in_a_rel_exp1, in_a_rel_index)
    local
      Tpl.Text txt;
      DAE.Exp a_rel;
      DAE.Exp a_inRelationExp;
      DAE.Exp a_rel_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      Integer a_rel_index;
      Boolean i_genInitialisation;
      SimCode.Context i_context;
      SimCode.Context i_sim;
      Boolean i_sim_genDiscrete;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;
      Tpl.Text l_e1e2preExp;

    case ( txt,
           (i_sim as SimCode.SIMULATION_CONTEXT(genDiscrete = i_sim_genDiscrete)),
           _,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           a_rel_index )
      equation
        (txt, a_preExp) = fun_316(txt, i_sim_genDiscrete, a_inRelationExp, a_rel_exp2, a_simCode, a_preExp, i_sim, a_rel_exp1, a_rel_index);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = i_genInitialisation)),
           _,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           a_rel_index )
      equation
        l_e1e2preExp = Tpl.emptyTxt;
        (l_e1, l_e1e2preExp) = daeExp(Tpl.emptyTxt, a_rel_exp1, i_context, l_e1e2preExp, a_simCode);
        (l_e2, l_e1e2preExp) = daeExp(Tpl.emptyTxt, a_rel_exp2, i_context, l_e1e2preExp, a_simCode);
        (txt, l_e2, l_e1, a_preExp) = fun_317(txt, i_genInitialisation, a_rel_index, l_e2, l_e1, a_inRelationExp, l_e1e2preExp, a_preExp);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ZEROCROSSINGS_CONTEXT()),
           a_rel,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           _ )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp1, i_context, a_preExp, a_simCode);
        (l_e2, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp2, i_context, a_preExp, a_simCode);
        l_res = Tpl.emptyTxt;
        (a_preExp, l_res) = tempDecl(a_preExp, "bool", l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = ("));
        (a_preExp, l_e1, l_e2) = zeroCrossingValue(a_preExp, a_rel, l_e1, l_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")"));
        a_preExp = zeroCrossingRelationOperator(a_preExp, a_inRelationExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("0.0;"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           _,
           _ )
      then (txt, a_preExp);
  end match;
end fun_318;

protected function fun_319
  input Tpl.Text in_txt;
  input Integer in_a_rel_index;
  input DAE.Exp in_a_rel;
  input DAE.Exp in_a_inRelationExp;
  input DAE.Exp in_a_rel_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_rel_index, in_a_rel, in_a_inRelationExp, in_a_rel_exp2, in_a_simCode, in_a_preExp, in_a_rel_exp1, in_a_context)
    local
      Tpl.Text txt;
      DAE.Exp a_rel;
      DAE.Exp a_inRelationExp;
      DAE.Exp a_rel_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      SimCode.Context a_context;
      Integer i_rel_index;

    case ( txt,
           -1,
           _,
           _,
           _,
           _,
           a_preExp,
           _,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_rel_index,
           a_rel,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           a_context )
      equation
        (txt, a_preExp) = fun_318(txt, a_context, a_rel, a_inRelationExp, a_rel_exp2, a_simCode, a_preExp, a_rel_exp1, i_rel_index);
      then (txt, a_preExp);
  end match;
end fun_319;

protected function fun_320
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inRelationExp;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_inRelationExp, in_a_simCode, in_a_context, in_a_preExp)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      DAE.Exp i_rel;
      Integer i_rel_index;
      String ret_0;

    case ( txt,
           (i_rel as DAE.RELATION(index = i_rel_index, exp1 = i_rel_exp1, exp2 = i_rel_exp2)),
           a_simCode,
           a_context,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("//relation["));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("]:  "));
        ret_0 = ExpressionDump.printExpStr(i_rel);
        a_preExp = Tpl.writeStr(a_preExp, ret_0);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        (txt, a_preExp) = fun_319(txt, i_rel_index, i_rel, i_rel, i_rel_exp2, a_simCode, a_preExp, i_rel_exp1, a_context);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end match;
end fun_320;

protected function fun_321
  input Tpl.Text in_txt;
  input Boolean in_a_sim_genDiscrete;
  input DAE.Exp in_a_inRelationExp;
  input DAE.Exp in_a_rel_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel_exp1;
  input Integer in_a_rel_index;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_sim_genDiscrete, in_a_inRelationExp, in_a_rel_exp2, in_a_simCode, in_a_preExp, in_a_context, in_a_rel_exp1, in_a_rel_index)
    local
      Tpl.Text txt;
      DAE.Exp a_inRelationExp;
      DAE.Exp a_rel_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_rel_exp1;
      Integer a_rel_index;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           false,
           _,
           _,
           _,
           a_preExp,
           _,
           _,
           a_rel_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("preRels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           _,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_context,
           a_rel_exp1,
           a_rel_index )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp1, a_context, a_preExp, a_simCode);
        (l_e2, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp2, a_context, a_preExp, a_simCode);
        (a_preExp, l_e1, l_e2) = relationWithZeroCrossing(a_preExp, a_inRelationExp, l_e1, l_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);
  end match;
end fun_321;

protected function fun_322
  input Tpl.Text in_txt;
  input Boolean in_a_genInitialisation;
  input Integer in_a_rel_index;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;
  input DAE.Exp in_a_inRelationExp;
  input Tpl.Text in_a_e1e2preExp;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_e2;
  output Tpl.Text out_a_e1;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_e2, out_a_e1, out_a_preExp) :=
  match(in_txt, in_a_genInitialisation, in_a_rel_index, in_a_e2, in_a_e1, in_a_inRelationExp, in_a_e1e2preExp, in_a_preExp)
    local
      Tpl.Text txt;
      Integer a_rel_index;
      Tpl.Text a_e2;
      Tpl.Text a_e1;
      DAE.Exp a_inRelationExp;
      Tpl.Text a_e1e2preExp;
      Tpl.Text a_preExp;
      Tpl.Text l_res;

    case ( txt,
           false,
           a_rel_index,
           a_e2,
           a_e1,
           a_inRelationExp,
           a_e1e2preExp,
           a_preExp )
      equation
        l_res = Tpl.emptyTxt;
        (a_preExp, l_res) = tempDecl(a_preExp, "bool", l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if(IsDiscreteEvaluation) {\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_e1e2preExp);
        a_preExp = Tpl.softNewLine(a_preExp);
        (a_preExp, a_e1, a_e2) = relationWithZeroCrossing(a_preExp, a_inRelationExp, a_e1, a_e2);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = IsContinuousEvaluation ? preRels["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] : rels["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("];\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = preRels["));
        a_preExp = Tpl.writeStr(a_preExp, intString(a_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("];"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        a_preExp = Tpl.popBlock(a_preExp);
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_e2, a_e1, a_preExp);

    case ( txt,
           _,
           a_rel_index,
           a_e2,
           a_e1,
           a_inRelationExp,
           a_e1e2preExp,
           a_preExp )
      equation
        a_preExp = Tpl.writeText(a_preExp, a_e1e2preExp);
        (a_preExp, a_e1, a_e2) = relationWithZeroCrossing(a_preExp, a_inRelationExp, a_e1, a_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(IsContinuousEvaluation ? preRels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] : rels["));
        txt = Tpl.writeStr(txt, intString(a_rel_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
      then (txt, a_e2, a_e1, a_preExp);
  end match;
end fun_322;

protected function fun_323
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_rel;
  input DAE.Exp in_a_inRelationExp;
  input DAE.Exp in_a_rel_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input Integer in_a_rel_index;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_rel, in_a_inRelationExp, in_a_rel_exp2, in_a_simCode, in_a_preExp, in_a_rel_exp1, in_a_rel_index)
    local
      Tpl.Text txt;
      DAE.Exp a_rel;
      DAE.Exp a_inRelationExp;
      DAE.Exp a_rel_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      Integer a_rel_index;
      Boolean i_genInitialisation;
      SimCode.Context i_context;
      SimCode.Context i_sim;
      Boolean i_sim_genDiscrete;
      Tpl.Text l_res;
      Tpl.Text l_e2;
      Tpl.Text l_e1;
      Tpl.Text l_e1e2preExp;

    case ( txt,
           (i_sim as SimCode.SIMULATION_CONTEXT(genDiscrete = i_sim_genDiscrete)),
           _,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           a_rel_index )
      equation
        (txt, a_preExp) = fun_321(txt, i_sim_genDiscrete, a_inRelationExp, a_rel_exp2, a_simCode, a_preExp, i_sim, a_rel_exp1, a_rel_index);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = i_genInitialisation)),
           _,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           a_rel_index )
      equation
        l_e1e2preExp = Tpl.emptyTxt;
        (l_e1, l_e1e2preExp) = daeExp(Tpl.emptyTxt, a_rel_exp1, i_context, l_e1e2preExp, a_simCode);
        (l_e2, l_e1e2preExp) = daeExp(Tpl.emptyTxt, a_rel_exp2, i_context, l_e1e2preExp, a_simCode);
        (txt, l_e2, l_e1, a_preExp) = fun_322(txt, i_genInitialisation, a_rel_index, l_e2, l_e1, a_inRelationExp, l_e1e2preExp, a_preExp);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ZEROCROSSINGS_CONTEXT()),
           a_rel,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           _ )
      equation
        (l_e1, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp1, i_context, a_preExp, a_simCode);
        (l_e2, a_preExp) = daeExp(Tpl.emptyTxt, a_rel_exp2, i_context, a_preExp, a_simCode);
        l_res = Tpl.emptyTxt;
        (a_preExp, l_res) = tempDecl(a_preExp, "bool", l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = ("));
        (a_preExp, l_e1, l_e2) = zeroCrossingValue(a_preExp, a_rel, l_e1, l_e2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")"));
        a_preExp = zeroCrossingRelationOperator(a_preExp, a_inRelationExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("0.0;"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_preExp,
           _,
           _ )
      then (txt, a_preExp);
  end match;
end fun_323;

protected function fun_324
  input Tpl.Text in_txt;
  input Integer in_a_rel_index;
  input DAE.Exp in_a_rel;
  input DAE.Exp in_a_inRelationExp;
  input DAE.Exp in_a_rel_exp2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_rel_exp1;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_rel_index, in_a_rel, in_a_inRelationExp, in_a_rel_exp2, in_a_simCode, in_a_preExp, in_a_rel_exp1, in_a_context)
    local
      Tpl.Text txt;
      DAE.Exp a_rel;
      DAE.Exp a_inRelationExp;
      DAE.Exp a_rel_exp2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_rel_exp1;
      SimCode.Context a_context;
      Integer i_rel_index;

    case ( txt,
           -1,
           _,
           _,
           _,
           _,
           a_preExp,
           _,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_rel_index,
           a_rel,
           a_inRelationExp,
           a_rel_exp2,
           a_simCode,
           a_preExp,
           a_rel_exp1,
           a_context )
      equation
        (txt, a_preExp) = fun_323(txt, a_context, a_rel, a_inRelationExp, a_rel_exp2, a_simCode, a_preExp, a_rel_exp1, i_rel_index);
      then (txt, a_preExp);
  end match;
end fun_324;

protected function fun_325
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inRelationExp;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_inRelationExp, in_a_simCode, in_a_context, in_a_preExp)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      DAE.Exp i_rel;
      Integer i_rel_index;
      String ret_0;

    case ( txt,
           (i_rel as DAE.RELATION(index = i_rel_index, exp1 = i_rel_exp1, exp2 = i_rel_exp2)),
           a_simCode,
           a_context,
           a_preExp )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("//relation["));
        a_preExp = Tpl.writeStr(a_preExp, intString(i_rel_index));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("]:  "));
        ret_0 = ExpressionDump.printExpStr(i_rel);
        a_preExp = Tpl.writeStr(a_preExp, ret_0);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        (txt, a_preExp) = fun_324(txt, i_rel_index, i_rel, i_rel, i_rel_exp2, a_simCode, a_preExp, i_rel_exp1, a_context);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           _,
           a_preExp )
      then (txt, a_preExp);
  end match;
end fun_325;

protected function fun_326
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_inRelationExp;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_inRelationExp, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      DAE.Exp a_inRelationExp;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.SIMULATION_CONTEXT(genDiscrete = _)),
           a_inRelationExp,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = fun_315(txt, a_inRelationExp, a_simCode, i_context, a_preExp);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = _)),
           a_inRelationExp,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = fun_320(txt, a_inRelationExp, a_simCode, i_context, a_preExp);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ZEROCROSSINGS_CONTEXT()),
           a_inRelationExp,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = fun_325(txt, a_inRelationExp, a_simCode, i_context, a_preExp);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);
  end match;
end fun_326;

public function daeExpSimRelation
  input Tpl.Text txt;
  input DAE.Exp a_inRelationExp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) := fun_326(txt, a_context, a_inRelationExp, a_preExp, a_simCode);
end daeExpSimRelation;

public function daeExpIf
  input Tpl.Text txt;
  input DAE.Exp a_cond;
  input DAE.Exp a_then__;
  input DAE.Exp a_else__;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
protected
  Tpl.Text txt_6;
  Tpl.Text l_eElse;
  Tpl.Text l_preExpElse;
  Tpl.Text l_eThen;
  Tpl.Text l_preExpThen;
  Tpl.Text l_resVar;
  Tpl.Text l_condExp;
algorithm
  (l_condExp, out_a_preExp) := daeExp(Tpl.emptyTxt, a_cond, a_context, a_preExp, a_simCode);
  l_resVar := Tpl.emptyTxt;
  l_preExpThen := Tpl.emptyTxt;
  (l_eThen, l_preExpThen) := daeExp(Tpl.emptyTxt, a_then__, a_context, l_preExpThen, a_simCode);
  l_preExpElse := Tpl.emptyTxt;
  (l_eElse, l_preExpElse) := daeExp(Tpl.emptyTxt, a_else__, a_context, l_preExpElse, a_simCode);
  txt_6 := expTypeFromExpArrayIf(Tpl.emptyTxt, a_then__);
  (out_a_preExp, l_resVar) := tempDecl(out_a_preExp, Tpl.textString(txt_6), l_resVar);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING_LIST({
                                                 ";\n",
                                                 "if ("
                                             }, false));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_condExp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(") { //cond type is "));
  out_a_preExp := expTypeFromExp(out_a_preExp, a_cond);
  out_a_preExp := Tpl.softNewLine(out_a_preExp);
  out_a_preExp := Tpl.pushBlock(out_a_preExp, Tpl.BT_INDENT(2));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_preExpThen);
  out_a_preExp := Tpl.softNewLine(out_a_preExp);
  out_a_preExp := Tpl.writeText(out_a_preExp, l_resVar);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(" = "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_eThen);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_LINE(";\n"));
  out_a_preExp := Tpl.popBlock(out_a_preExp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_LINE("} else {\n"));
  out_a_preExp := Tpl.pushBlock(out_a_preExp, Tpl.BT_INDENT(2));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_preExpElse);
  out_a_preExp := Tpl.softNewLine(out_a_preExp);
  out_a_preExp := Tpl.writeText(out_a_preExp, l_resVar);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING(" = "));
  out_a_preExp := Tpl.writeText(out_a_preExp, l_eElse);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_LINE(";\n"));
  out_a_preExp := Tpl.popBlock(out_a_preExp);
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_STRING("}"));
  out_a_preExp := Tpl.writeTok(out_a_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_resVar);
end daeExpIf;

protected function fun_329
  input Tpl.Text in_txt;
  input DAE.Exp in_a_e2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_e3;
  input Tpl.Text in_a_var2;
  input Tpl.Text in_a_var1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_e2, in_a_simCode, in_a_preExp, in_a_context, in_a_e3, in_a_var2, in_a_var1)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_e3;
      Tpl.Text a_var2;
      Tpl.Text a_var1;
      Tpl.Text l_tmpVar2;
      Tpl.Text l_msg;

    case ( txt,
           DAE.RCONST(real = _),
           _,
           a_preExp,
           _,
           _,
           a_var2,
           a_var1 )
      equation
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" / "));
        txt = Tpl.writeText(txt, a_var2);
      then (txt, a_preExp);

    case ( txt,
           _,
           a_simCode,
           a_preExp,
           a_context,
           a_e3,
           a_var2,
           a_var1 )
      equation
        (l_msg, a_preExp) = daeExp(Tpl.emptyTxt, a_e3, a_context, a_preExp, a_simCode);
        l_tmpVar2 = Tpl.emptyTxt;
        (a_preExp, l_tmpVar2) = tempDecl(a_preExp, "var", l_tmpVar2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = "));
        a_preExp = Tpl.writeText(a_preExp, a_var2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("; if ("));
        a_preExp = Tpl.writeText(a_preExp, l_tmpVar2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" == 0.0) throw new DivideByZeroException("));
        a_preExp = Tpl.writeText(a_preExp, l_msg);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" / "));
        txt = Tpl.writeText(txt, l_tmpVar2);
      then (txt, a_preExp);
  end match;
end fun_329;

protected function fun_330
  input Tpl.Text in_txt;
  input DAE.Type in_a_arg_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_330;

protected function fun_331
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_inExp;
  input Tpl.Text in_a_constIndex;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_valExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_inExp, in_a_constIndex, in_a_simCode, in_a_preExp, in_a_valExp)
    local
      Tpl.Text txt;
      DAE.Exp a_inExp;
      Tpl.Text a_constIndex;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_valExp;
      SimCode.Context i_context;
      Tpl.Text txt_3;
      String ret_3;
      Tpl.Text l_preExpVal;
      Tpl.Text l_res;
      Tpl.Text l_val;

    case ( txt,
           (i_context as SimCode.SIMULATION_CONTEXT(genDiscrete = true)),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        (l_val, a_preExp) = daeExp(Tpl.emptyTxt, a_valExp, i_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int) (mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = Math.Floor("));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")))"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = true)),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        (l_val, a_preExp) = daeExp(Tpl.emptyTxt, a_valExp, i_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int) (mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = Math.Floor("));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")))"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ZEROCROSSINGS_CONTEXT()),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        (l_val, a_preExp) = daeExp(Tpl.emptyTxt, a_valExp, i_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int) (mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = Math.Floor("));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")))"));
      then (txt, a_preExp);

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = false),
           _,
           a_constIndex,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int) mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = false)),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        l_res = Tpl.emptyTxt;
        l_preExpVal = Tpl.emptyTxt;
        (l_val, l_preExpVal) = daeExp(Tpl.emptyTxt, a_valExp, i_context, l_preExpVal, a_simCode);
        (a_preExp, l_res) = tempDecl(a_preExp, "int", l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if(IsDiscreteEvaluation && !IsContinuousEvaluation) {\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_preExpVal);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (int) (mathEVPre["));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] = Math.Floor("));
        a_preExp = Tpl.writeText(a_preExp, l_val);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("));\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (int) mathEVPre["));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("];\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           a_inExp,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt_3 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unexpected context for: "));
        ret_3 = ExpressionDump.printExpStr(a_inExp);
        txt_3 = Tpl.writeStr(txt_3, ret_3);
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 2746, 16), Tpl.textString(txt_3));
      then (txt, a_preExp);
  end match;
end fun_331;

protected function fun_332
  input Tpl.Text in_txt;
  input DAE.Type in_a_attr_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_ty)
    local
      Tpl.Text txt;
      DAE.Type i_attr_ty;
      Tpl.Text txt_0;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      then txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           i_attr_ty )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unexpected return type \""));
        txt_0 = expTypeShort(txt_0, i_attr_ty);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING("\"  for floor()."));
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 2755, 18), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_332;

protected function fun_333
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_inExp;
  input Tpl.Text in_a_constIndex;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_valExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_inExp, in_a_constIndex, in_a_simCode, in_a_preExp, in_a_valExp)
    local
      Tpl.Text txt;
      DAE.Exp a_inExp;
      Tpl.Text a_constIndex;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_valExp;
      SimCode.Context i_context;
      Tpl.Text txt_3;
      String ret_3;
      Tpl.Text l_preExpVal;
      Tpl.Text l_res;
      Tpl.Text l_val;

    case ( txt,
           (i_context as SimCode.SIMULATION_CONTEXT(genDiscrete = true)),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        (l_val, a_preExp) = daeExp(Tpl.emptyTxt, a_valExp, i_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = Math.Floor("));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = true)),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        (l_val, a_preExp) = daeExp(Tpl.emptyTxt, a_valExp, i_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = Math.Floor("));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ZEROCROSSINGS_CONTEXT()),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        (l_val, a_preExp) = daeExp(Tpl.emptyTxt, a_valExp, i_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = Math.Floor("));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp);

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = false),
           _,
           a_constIndex,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = false)),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        l_res = Tpl.emptyTxt;
        l_preExpVal = Tpl.emptyTxt;
        (l_val, l_preExpVal) = daeExp(Tpl.emptyTxt, a_valExp, i_context, l_preExpVal, a_simCode);
        (a_preExp, l_res) = tempDecl(a_preExp, "double", l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if(IsDiscreteEvaluation && !IsContinuousEvaluation) {\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_preExpVal);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (mathEVPre["));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] = Math.Floor("));
        a_preExp = Tpl.writeText(a_preExp, l_val);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("));\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = mathEVPre["));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("];\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           a_inExp,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt_3 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unexpected context for: "));
        ret_3 = ExpressionDump.printExpStr(a_inExp);
        txt_3 = Tpl.writeStr(txt_3, ret_3);
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 2781, 20), Tpl.textString(txt_3));
      then (txt, a_preExp);
  end match;
end fun_333;

protected function fun_334
  input Tpl.Text in_txt;
  input DAE.Type in_a_attr_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_ty)
    local
      Tpl.Text txt;
      DAE.Type i_attr_ty;
      Tpl.Text txt_0;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      then txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           i_attr_ty )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unexpected return type \""));
        txt_0 = expTypeShort(txt_0, i_attr_ty);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING("\" for ceil()."));
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 2791, 18), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_334;

protected function fun_335
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_inExp;
  input Tpl.Text in_a_constIndex;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_valExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_inExp, in_a_constIndex, in_a_simCode, in_a_preExp, in_a_valExp)
    local
      Tpl.Text txt;
      DAE.Exp a_inExp;
      Tpl.Text a_constIndex;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_valExp;
      SimCode.Context i_context;
      Tpl.Text txt_3;
      String ret_3;
      Tpl.Text l_preExpVal;
      Tpl.Text l_res;
      Tpl.Text l_val;

    case ( txt,
           (i_context as SimCode.SIMULATION_CONTEXT(genDiscrete = true)),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        (l_val, a_preExp) = daeExp(Tpl.emptyTxt, a_valExp, i_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = Math.Ceiling("));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = true)),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        (l_val, a_preExp) = daeExp(Tpl.emptyTxt, a_valExp, i_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = Math.Ceiling("));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ZEROCROSSINGS_CONTEXT()),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        (l_val, a_preExp) = daeExp(Tpl.emptyTxt, a_valExp, i_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = Math.Ceiling("));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp);

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = false),
           _,
           a_constIndex,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = false)),
           _,
           a_constIndex,
           a_simCode,
           a_preExp,
           a_valExp )
      equation
        l_res = Tpl.emptyTxt;
        l_preExpVal = Tpl.emptyTxt;
        (l_val, l_preExpVal) = daeExp(Tpl.emptyTxt, a_valExp, i_context, l_preExpVal, a_simCode);
        (a_preExp, l_res) = tempDecl(a_preExp, "double", l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if(IsDiscreteEvaluation && !IsContinuousEvaluation) {\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_preExpVal);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (mathEVPre["));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] = Math.Ceiling("));
        a_preExp = Tpl.writeText(a_preExp, l_val);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("));\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = mathEVPre["));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("];\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           a_inExp,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt_3 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unexpected context for: "));
        ret_3 = ExpressionDump.printExpStr(a_inExp);
        txt_3 = Tpl.writeStr(txt_3, ret_3);
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 2817, 20), Tpl.textString(txt_3));
      then (txt, a_preExp);
  end match;
end fun_335;

protected function fun_336
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_inExp;
  input Tpl.Text in_a_constIndex;
  input Tpl.Text in_a_stype;
  input DAE.Exp in_a_e2;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_e1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_context, in_a_inExp, in_a_constIndex, in_a_stype, in_a_e2, in_a_simCode, in_a_preExp, in_a_e1)
    local
      Tpl.Text txt;
      DAE.Exp a_inExp;
      Tpl.Text a_constIndex;
      Tpl.Text a_stype;
      DAE.Exp a_e2;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      DAE.Exp a_e1;
      SimCode.Context i_context;
      Tpl.Text txt_4;
      String ret_4;
      Tpl.Text l_preExpVal;
      Tpl.Text l_res;
      Tpl.Text l_val2;
      Tpl.Text l_val1;

    case ( txt,
           (i_context as SimCode.SIMULATION_CONTEXT(genDiscrete = true)),
           _,
           a_constIndex,
           a_stype,
           a_e2,
           a_simCode,
           a_preExp,
           a_e1 )
      equation
        (l_val1, a_preExp) = daeExp(Tpl.emptyTxt, a_e1, i_context, a_preExp, a_simCode);
        (l_val2, a_preExp) = daeExp(Tpl.emptyTxt, a_e2, i_context, a_preExp, a_simCode);
        l_res = Tpl.emptyTxt;
        (a_preExp, l_res) = tempDecl(a_preExp, Tpl.textString(a_stype), l_res);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("{ var d = "));
        a_preExp = Tpl.writeText(a_preExp, l_val2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "  if (d = 0) throw new DivideByZeroException(\"event_div() failed at time \" + Time + \" because denominator is zero!\");\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (int) ("));
        a_preExp = Tpl.writeText(a_preExp, l_val1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              " / d);\n",
                                              "mathEVPre["
                                          }, false));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] = "));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(";\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = true)),
           _,
           a_constIndex,
           a_stype,
           a_e2,
           a_simCode,
           a_preExp,
           a_e1 )
      equation
        (l_val1, a_preExp) = daeExp(Tpl.emptyTxt, a_e1, i_context, a_preExp, a_simCode);
        (l_val2, a_preExp) = daeExp(Tpl.emptyTxt, a_e2, i_context, a_preExp, a_simCode);
        l_res = Tpl.emptyTxt;
        (a_preExp, l_res) = tempDecl(a_preExp, Tpl.textString(a_stype), l_res);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("{ var d = "));
        a_preExp = Tpl.writeText(a_preExp, l_val2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "  if (d = 0) throw new DivideByZeroException(\"event_div() failed at time \" + Time + \" because denominator is zero!\");\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (int) ("));
        a_preExp = Tpl.writeText(a_preExp, l_val1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              " / d);\n",
                                              "mathEVPre["
                                          }, false));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] = "));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(";\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ZEROCROSSINGS_CONTEXT()),
           _,
           a_constIndex,
           a_stype,
           a_e2,
           a_simCode,
           a_preExp,
           a_e1 )
      equation
        (l_val1, a_preExp) = daeExp(Tpl.emptyTxt, a_e1, i_context, a_preExp, a_simCode);
        (l_val2, a_preExp) = daeExp(Tpl.emptyTxt, a_e2, i_context, a_preExp, a_simCode);
        l_res = Tpl.emptyTxt;
        (a_preExp, l_res) = tempDecl(a_preExp, Tpl.textString(a_stype), l_res);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("{ var d = "));
        a_preExp = Tpl.writeText(a_preExp, l_val2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "  if (d = 0) throw new DivideByZeroException(\"event_div() failed at time \" + Time + \" because denominator is zero!\");\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (int) ("));
        a_preExp = Tpl.writeText(a_preExp, l_val1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              " / d);\n",
                                              "mathEVPre["
                                          }, false));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] = "));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(";\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = false),
           _,
           a_constIndex,
           a_stype,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_stype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") mathEVPre["));
        txt = Tpl.writeText(txt, a_constIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then (txt, a_preExp);

    case ( txt,
           (i_context as SimCode.ALGLOOP_CONTEXT(genInitialisation = false)),
           _,
           a_constIndex,
           a_stype,
           a_e2,
           a_simCode,
           a_preExp,
           a_e1 )
      equation
        l_res = Tpl.emptyTxt;
        l_preExpVal = Tpl.emptyTxt;
        (l_val1, l_preExpVal) = daeExp(Tpl.emptyTxt, a_e1, i_context, l_preExpVal, a_simCode);
        (l_val2, l_preExpVal) = daeExp(Tpl.emptyTxt, a_e2, i_context, l_preExpVal, a_simCode);
        (a_preExp, l_res) = tempDecl(a_preExp, Tpl.textString(a_stype), l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if(IsDiscreteEvaluation && !IsContinuousEvaluation) {\n"
                                          }, true));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_preExpVal);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("var d = "));
        a_preExp = Tpl.writeText(a_preExp, l_val2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if (d = 0) throw new DivideByZeroException(\"event_div() failed at time \" + Time + \" because denominator is zero!\");\n"
                                          }, true));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (int) ("));
        a_preExp = Tpl.writeText(a_preExp, l_val1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              " / d);\n",
                                              "mathEVPre["
                                          }, false));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("] = "));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(";\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, l_res);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = ("));
        a_preExp = Tpl.writeText(a_preExp, a_stype);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(") mathEVPre["));
        a_preExp = Tpl.writeText(a_preExp, a_constIndex);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("];\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_res);
      then (txt, a_preExp);

    case ( txt,
           _,
           a_inExp,
           _,
           _,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt_4 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unexpected context for: "));
        ret_4 = ExpressionDump.printExpStr(a_inExp);
        txt_4 = Tpl.writeStr(txt_4, ret_4);
        txt = error(txt, Tpl.sourceInfo("CodegenCSharp.tpl", 2863, 16), Tpl.textString(txt_4));
      then (txt, a_preExp);
  end match;
end fun_336;

protected function lm_337
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_it;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_it :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp) = daeExp(txt, i_it, a_context, a_preExp, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_337(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_337;

protected function lm_338
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_it;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_it :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp) = daeExp(txt, i_it, a_context, a_preExp, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_338(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_338;

protected function fun_339
  input Tpl.Text in_txt;
  input Boolean in_a_attr_builtin;
  input Tpl.Text in_a_funName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_attr_builtin, in_a_funName)
    local
      Tpl.Text txt;
      Tpl.Text a_funName;

    case ( txt,
           false,
           a_funName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* !!!TODO:."));
        txt = Tpl.writeText(txt, a_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype_1 */"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_339;

public function daeExpCall
  input Tpl.Text in_txt;
  input DAE.Exp in_a_inExp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_inExp, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      Absyn.Path i_path;
      Boolean i_attr_builtin;
      list<DAE.Exp> i_expLst;
      DAE.Exp i_valExp;
      DAE.Exp i_index;
      DAE.Exp i_inExp;
      DAE.Exp i_s1;
      DAE.Exp i_s;
      DAE.Type i_attr_ty;
      DAE.Exp i_toBeCasted;
      DAE.Type i_arg_ty;
      DAE.ComponentRef i_arg_componentRef;
      DAE.Exp i_e3;
      DAE.Exp i_e2;
      DAE.Exp i_e1;
      Tpl.Text l_funName;
      Tpl.Text l_argStr;
      Tpl.Text l_stype;
      String ret_9;
      String ret_8;
      Tpl.Text l_retType;
      String ret_6;
      Tpl.Text l_constIndex;
      String ret_4;
      Tpl.Text l_str;
      Tpl.Text l_castedVar;
      Tpl.Text l_var2;
      Tpl.Text l_var1;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "DIVISION"), expLst = {i_e1, i_e2, i_e3}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_var1, a_preExp) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_simCode);
        (l_var2, a_preExp) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_simCode);
        (txt, a_preExp) = fun_329(txt, i_e2, a_simCode, a_preExp, a_context, i_e3, l_var2, l_var1);
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_simCode )
      equation
        txt = derCref(txt, i_arg_componentRef, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "pre"), expLst = {DAE.CREF(ty = i_arg_ty, componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_simCode )
      equation
        txt = fun_330(txt, i_arg_ty);
        txt = preCref(txt, i_arg_componentRef, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_toBeCasted}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_castedVar, a_preExp) = daeExp(Tpl.emptyTxt, i_toBeCasted, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int)"));
        txt = Tpl.writeText(txt, l_castedVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "Integer"), expLst = {i_toBeCasted}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_castedVar, a_preExp) = daeExp(Tpl.emptyTxt, i_toBeCasted, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int)"));
        txt = Tpl.writeText(txt, l_castedVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "$_start"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_simCode )
      equation
        txt = startCref(txt, i_arg_componentRef, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "edge"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(/*edge*/"));
        txt = cref(txt, i_arg_componentRef, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !("));
        txt = preCref(txt, i_arg_componentRef, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "change"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}),
           _,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(/*change*/"));
        txt = cref(txt, i_arg_componentRef, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = preCref(txt, i_arg_componentRef, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "max"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Max("));
        (txt, a_preExp) = daeExp(txt, i_e1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        (txt, a_preExp) = daeExp(txt, i_e2, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "min"), expLst = {i_e1, i_e2}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Min("));
        (txt, a_preExp) = daeExp(txt, i_e1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        (txt, a_preExp) = daeExp(txt, i_e2, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "mod"), expLst = {i_e1, i_e2}, attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_var1, a_preExp) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_simCode);
        (l_var2, a_preExp) = daeExp(Tpl.emptyTxt, i_e2, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Mod_"));
        txt = expTypeShort(txt, i_attr_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "String"), expLst = {i_s, _}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_str, a_preExp) = daeExp(Tpl.emptyTxt, i_s, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").ToString()"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "abs"), expLst = {i_e1}, attr = DAE.CALL_ATTR(ty = DAE.T_INTEGER(varLst = _))),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_var1, a_preExp) = daeExp(Tpl.emptyTxt, i_e1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Abs_int("));
        txt = Tpl.writeText(txt, l_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "abs"), expLst = {i_s1}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Abs("));
        (txt, a_preExp) = daeExp(txt, i_s1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "log"), expLst = {i_s1}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Log("));
        (txt, a_preExp) = daeExp(txt, i_s1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "log10"), expLst = {i_s1}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Log10("));
        (txt, a_preExp) = daeExp(txt, i_s1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "exp"), expLst = {i_s1}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Exp("));
        (txt, a_preExp) = daeExp(txt, i_s1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sin"), expLst = {i_s1}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Sin("));
        (txt, a_preExp) = daeExp(txt, i_s1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "cos"), expLst = {i_s1}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Cos("));
        (txt, a_preExp) = daeExp(txt, i_s1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sqrt"), expLst = {i_s1}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Sqrt("));
        (txt, a_preExp) = daeExp(txt, i_s1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "tanh"), expLst = {i_s1}),
           a_context,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Tanh("));
        (txt, a_preExp) = daeExp(txt, i_s1, a_context, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "noEvent"), expLst = {i_s1}),
           _,
           a_preExp,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(/*noEvent*/"));
        (txt, a_preExp) = daeExp(txt, i_s1, SimCode.contextOther, a_preExp, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "initial"), expLst = {}),
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Initial"));
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_valExp, i_index})),
           a_context,
           a_preExp,
           a_simCode )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("//event trigger function: "));
        ret_4 = ExpressionDump.printExpStr(i_inExp);
        a_preExp = Tpl.writeStr(a_preExp, ret_4);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        (l_constIndex, a_preExp) = daeExp(Tpl.emptyTxt, i_index, a_context, a_preExp, a_simCode);
        (txt, a_preExp) = fun_331(txt, a_context, i_inExp, l_constIndex, a_simCode, a_preExp, i_valExp);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.CALL(path = Absyn.IDENT(name = "floor"), expLst = {i_valExp, i_index}, attr = DAE.CALL_ATTR(ty = i_attr_ty))),
           a_context,
           a_preExp,
           a_simCode )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("//event trigger function: "));
        ret_6 = ExpressionDump.printExpStr(i_inExp);
        a_preExp = Tpl.writeStr(a_preExp, ret_6);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        (l_constIndex, a_preExp) = daeExp(Tpl.emptyTxt, i_index, a_context, a_preExp, a_simCode);
        l_retType = fun_332(Tpl.emptyTxt, i_attr_ty);
        txt = Tpl.writeText(txt, l_retType);
        (txt, a_preExp) = fun_333(txt, a_context, i_inExp, l_constIndex, a_simCode, a_preExp, i_valExp);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.CALL(path = Absyn.IDENT(name = "ceil"), expLst = {i_valExp, i_index}, attr = DAE.CALL_ATTR(ty = i_attr_ty))),
           a_context,
           a_preExp,
           a_simCode )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("//event trigger function: "));
        ret_8 = ExpressionDump.printExpStr(i_inExp);
        a_preExp = Tpl.writeStr(a_preExp, ret_8);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        (l_constIndex, a_preExp) = daeExp(Tpl.emptyTxt, i_index, a_context, a_preExp, a_simCode);
        l_retType = fun_334(Tpl.emptyTxt, i_attr_ty);
        txt = Tpl.writeText(txt, l_retType);
        (txt, a_preExp) = fun_335(txt, a_context, i_inExp, l_constIndex, a_simCode, a_preExp, i_valExp);
      then (txt, a_preExp);

    case ( txt,
           (i_inExp as DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_e1, i_e2, i_index}, attr = DAE.CALL_ATTR(ty = i_attr_ty))),
           a_context,
           a_preExp,
           a_simCode )
      equation
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("//event trigger function: "));
        ret_9 = ExpressionDump.printExpStr(i_inExp);
        a_preExp = Tpl.writeStr(a_preExp, ret_9);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        (l_constIndex, a_preExp) = daeExp(Tpl.emptyTxt, i_index, a_context, a_preExp, a_simCode);
        l_stype = expTypeShort(Tpl.emptyTxt, i_attr_ty);
        (txt, a_preExp) = fun_336(txt, a_context, i_inExp, l_constIndex, l_stype, i_e2, a_simCode, a_preExp, i_e1);
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(tuple_ = false, ty = DAE.T_NORETCALL(source = _), builtin = i_attr_builtin), expLst = i_expLst, path = i_path),
           a_context,
           a_preExp,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_preExp) = lm_337(l_argStr, i_expLst, a_simCode, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        a_preExp = underscorePrefix(a_preExp, i_attr_builtin);
        a_preExp = underscorePath(a_preExp, i_path);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeText(a_preExp, l_argStr);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* NORETCALL */"));
      then (txt, a_preExp);

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(tuple_ = false, builtin = i_attr_builtin), expLst = i_expLst, path = i_path),
           a_context,
           a_preExp,
           a_simCode )
      equation
        l_argStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_argStr, a_preExp) = lm_338(l_argStr, i_expLst, a_simCode, a_preExp, a_context);
        l_argStr = Tpl.popIter(l_argStr);
        l_funName = underscorePath(Tpl.emptyTxt, i_path);
        txt = underscorePrefix(txt, i_attr_builtin);
        txt = Tpl.writeText(txt, l_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = fun_339(txt, i_attr_builtin, l_funName);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpCall:NOT_YT_IMPLEMENTED"));
      then (txt, a_preExp);
  end match;
end daeExpCall;

protected function lm_341
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_e;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_e :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = expTypeFromExp(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        (txt, a_preExp) = daeExp(txt, i_e, a_context, a_preExp, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_341(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_341;

protected function fun_342
  input Tpl.Text in_txt;
  input Boolean in_a_scalar;
  input DAE.Type in_a_a_ty;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input list<DAE.Exp> in_a_a_array;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_scalar, in_a_a_ty, in_a_simCode, in_a_preExp, in_a_context, in_a_a_array)
    local
      Tpl.Text txt;
      DAE.Type a_a_ty;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Exp> a_a_array;
      Integer ret_2;
      Tpl.Text l_params;
      Tpl.Text l_arrayVar;

    case ( txt,
           false,
           _,
           _,
           a_preExp,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NON_SCALAR_ARRAY_notYetImplemeted"));
      then (txt, a_preExp);

    case ( txt,
           _,
           a_a_ty,
           a_simCode,
           a_preExp,
           a_context,
           a_a_array )
      equation
        l_arrayVar = Tpl.emptyTxt;
        l_params = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_params, a_preExp) = lm_341(l_params, a_a_array, a_simCode, a_preExp, a_context);
        l_params = Tpl.popIter(l_params);
        (a_preExp, l_arrayVar) = tempDecl(a_preExp, "var", l_arrayVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = new "));
        a_preExp = expTypeArray(a_preExp, a_a_ty, 1);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        ret_2 = listLength(a_a_array);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_2));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(",-1,new[]{"));
        a_preExp = Tpl.writeText(a_preExp, l_params);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("});"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_arrayVar);
      then (txt, a_preExp);
  end match;
end fun_342;

protected function fun_343
  input Tpl.Text in_txt;
  input DAE.Exp in_mArg;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.Type i_a_ty;
      list<DAE.Exp> i_a_array;
      Boolean i_scalar;
      DAE.Exp i_cr;

    case ( txt,
           (i_cr as DAE.CREF(componentRef = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpCrefRhs(txt, i_cr, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.ARRAY(scalar = i_scalar, array = i_a_array, ty = i_a_ty),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = fun_342(txt, i_scalar, i_a_ty, a_simCode, a_preExp, a_context, i_a_array);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);
  end match;
end fun_343;

public function daeExpArray
  input Tpl.Text txt;
  input DAE.Exp a_aexp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
protected
  DAE.Exp ret_0;
algorithm
  ret_0 := SimCodeUtil.hackArrayReverseToCref(a_aexp, a_context);
  (out_txt, out_a_preExp) := fun_343(txt, ret_0, a_context, a_preExp, a_simCode);
end daeExpArray;

protected function lm_345
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_elem;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_elem :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp) = daeExp(txt, i_elem, a_context, a_preExp, a_simCode);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_345(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_345;

protected function lm_346
  input Tpl.Text in_txt;
  input list<list<DAE.Exp>> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_items, in_a_simCode, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<list<DAE.Exp>> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      list<DAE.Exp> i_row;

    case ( txt,
           {},
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);

    case ( txt,
           i_row :: rest,
           a_simCode,
           a_preExp,
           a_context )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_preExp) = lm_345(txt, i_row, a_simCode, a_preExp, a_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_preExp) = lm_346(txt, rest, a_simCode, a_preExp, a_context);
      then (txt, a_preExp);
  end match;
end lm_346;

protected function fun_347
  input Tpl.Text in_txt;
  input DAE.Exp in_mArg;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      list<DAE.Exp> i_row1;
      DAE.Type i_m_ty;
      list<list<DAE.Exp>> i_m_matrix;
      DAE.Type i_ty;
      DAE.Exp i_cr;
      Integer ret_3;
      Integer ret_2;
      Tpl.Text l_matArr;
      Tpl.Text l_tmp;

    case ( txt,
           (i_cr as DAE.CREF(componentRef = _)),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (txt, a_preExp) = daeExpCrefRhs(txt, i_cr, a_context, a_preExp, a_simCode);
      then (txt, a_preExp);

    case ( txt,
           DAE.MATRIX(matrix = {{}}, ty = i_ty),
           _,
           a_preExp,
           _ )
      equation
        l_tmp = Tpl.emptyTxt;
        (a_preExp, l_tmp) = tempDecl(a_preExp, "var", l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = new "));
        a_preExp = expTypeArray(a_preExp, i_ty, 2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(0,1);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp);

    case ( txt,
           DAE.MATRIX(matrix = {}, ty = i_ty),
           _,
           a_preExp,
           _ )
      equation
        l_tmp = Tpl.emptyTxt;
        (a_preExp, l_tmp) = tempDecl(a_preExp, "var", l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = new "));
        a_preExp = expTypeArray(a_preExp, i_ty, 2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("(0,1);"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp);

    case ( txt,
           DAE.MATRIX(matrix = (i_m_matrix as i_row1 :: _), ty = i_m_ty),
           a_context,
           a_preExp,
           a_simCode )
      equation
        l_tmp = Tpl.emptyTxt;
        l_matArr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_matArr, a_preExp) = lm_346(l_matArr, i_m_matrix, a_simCode, a_preExp, a_context);
        l_matArr = Tpl.popIter(l_matArr);
        (a_preExp, l_tmp) = tempDecl(a_preExp, "var", l_tmp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = new "));
        a_preExp = expTypeArray(a_preExp, i_m_ty, 2);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        ret_2 = listLength(i_m_matrix);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_2));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(","));
        ret_3 = listLength(i_row1);
        a_preExp = Tpl.writeStr(a_preExp, intString(ret_3));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(",-1, new[]{\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_ANCHOR(0));
        a_preExp = Tpl.writeText(a_preExp, l_matArr);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("});"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmp);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);
  end match;
end fun_347;

public function daeExpMatrix
  input Tpl.Text txt;
  input DAE.Exp a_mexp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
protected
  DAE.Exp ret_0;
algorithm
  ret_0 := SimCodeUtil.hackMatrixReverseToCref(a_mexp, a_context);
  (out_txt, out_a_preExp) := fun_347(txt, ret_0, a_context, a_preExp, a_simCode);
end daeExpMatrix;

protected function fun_349
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_expVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_expVar)
    local
      Tpl.Text txt;
      Tpl.Text a_expVar;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((int)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_expVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((double)"));
        txt = Tpl.writeText(txt, a_expVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT_IMPLEMENTED_CAST"));
      then txt;
  end match;
end fun_349;

public function daeExpCast
  input Tpl.Text in_txt;
  input DAE.Exp in_a_cexp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_preExp) :=
  match(in_txt, in_a_cexp, in_a_context, in_a_preExp, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      SimCode.SimCode a_simCode;
      DAE.Type i_ty;
      DAE.Exp i_exp;
      Tpl.Text l_expVar;

    case ( txt,
           DAE.CAST(exp = i_exp, ty = i_ty),
           a_context,
           a_preExp,
           a_simCode )
      equation
        (l_expVar, a_preExp) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_simCode);
        txt = fun_349(txt, i_ty, l_expVar);
      then (txt, a_preExp);

    case ( txt,
           _,
           _,
           a_preExp,
           _ )
      then (txt, a_preExp);
  end match;
end daeExpCast;

public function underscorePrefix
  input Tpl.Text in_txt;
  input Boolean in_a_builtin;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_builtin)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end underscorePrefix;

public function tempDecl
  input Tpl.Text txt;
  input String a_ty;
  input Tpl.Text a_newVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_newVar;
protected
  Integer ret_0;
algorithm
  out_a_newVar := Tpl.writeTok(a_newVar, Tpl.ST_STRING("_tmp"));
  ret_0 := System.tmpTick();
  out_a_newVar := Tpl.writeStr(out_a_newVar, intString(ret_0));
  out_txt := Tpl.writeStr(txt, a_ty);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeText(out_txt, out_a_newVar);
end tempDecl;

protected function fun_353
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           a_ty )
      equation
        txt = expTypeArrayIf(txt, a_ty);
      then txt;

    case ( txt,
           i_instDims,
           a_ty )
      equation
        ret_0 = listLength(i_instDims);
        txt = expTypeArray(txt, a_ty, ret_0);
      then txt;
  end match;
end fun_353;

public function varType
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_ty) )
      equation
        txt = fun_353(txt, i_instDims, i_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end varType;

public function expTypeShort
  input Tpl.Text in_txt;
  input DAE.Type in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      ClassInf.State i_complexClassType;
      DAE.Type i_ty;
      Absyn.Path ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_UNKNOWN(source = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_TYPE_NOT_SUPPORTED"));
      then txt;

    case ( txt,
           DAE.T_ANYTYPE(anyClassType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ANYTYPE_TYPE_NOT_SUPPORTED"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("object"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*struct*/"));
        ret_0 = ClassInf.getStateName(i_complexClassType);
        txt = underscorePath(txt, ret_0);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("META_TYPE_NOT_SUPPORTED"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("META_TYPE_NOT_SUPPORTED"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("FN_PTR_NOT_SUPPORTED"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeShort_ERROR"));
      then txt;
  end match;
end expTypeShort;

protected function fun_356
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isArray, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;

    case ( txt,
           false,
           a_ty )
      equation
        txt = expTypeShort(txt, a_ty);
      then txt;

    case ( txt,
           _,
           a_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expType_"));
        txt = expTypeArray(txt, a_ty, 0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_NOT_YET"));
      then txt;
  end match;
end fun_356;

public function expType
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_356(txt, a_isArray, a_ty);
end expType;

public function expTypeArray
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input Integer a_dims;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("SimArray"));
  out_txt := Tpl.writeStr(out_txt, intString(a_dims));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("<"));
  out_txt := expTypeShort(out_txt, a_ty);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(">"));
end expTypeArray;

public function expTypeArrayIf
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;
      DAE.Type i_ty;
      Integer ret_0;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty, dims = i_dims) )
      equation
        ret_0 = listLength(i_dims);
        txt = expTypeArray(txt, i_ty, ret_0);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;
  end match;
end expTypeArrayIf;

public function expTypeFromExpArrayIf
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExp(txt, a_exp);
end expTypeFromExpArrayIf;

public function expTypeFromExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      DAE.Exp i_expr;
      DAE.Exp i_exp;
      DAE.Type i_ty;
      DAE.Type i_attr_ty;
      DAE.Exp i_expThen;
      DAE.Operator i_operator;

    case ( txt,
           DAE.ICONST(integer = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.RCONST(real = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.SCONST(string = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.BCONST(bool = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.BINARY(operator = i_operator) )
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.UNARY(operator = i_operator) )
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.LBINARY(operator = i_operator) )
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.LUNARY(operator = i_operator) )
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.RELATION(exp1 = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.IFEXP(expThen = i_expThen) )
      equation
        txt = expTypeFromExp(txt, i_expThen);
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = i_attr_ty)) )
      equation
        txt = expTypeShort(txt, i_attr_ty);
      then txt;

    case ( txt,
           DAE.ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MATRIX(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.RANGE(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.CAST(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.CREF(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.CODE(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ASUB(exp = i_exp) )
      equation
        txt = expTypeFromExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.REDUCTION(expr = i_expr) )
      equation
        txt = expTypeFromExp(txt, i_expr);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeFromExp:ERROR"));
      then txt;
  end match;
end expTypeFromExp;

public function expTypeFromOp
  input Tpl.Text in_txt;
  input DAE.Operator in_a_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_it)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.ADD(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.UMINUS(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ADD_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_ARR(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_ARR2(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.LESS(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.GREATER(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.EQUAL(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.AND(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.OR(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.NOT(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeFromOp:ERROR"));
      then txt;
  end match;
end expTypeFromOp;

public function dimension
  input Tpl.Text in_txt;
  input DAE.Dimension in_a_d;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_d)
    local
      Tpl.Text txt;
      Integer i_integer;

    case ( txt,
           DAE.DIM_INTEGER(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.DIM_UNKNOWN() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("INVALID_DIMENSION"));
      then txt;
  end match;
end dimension;

public function error
  input Tpl.Text txt;
  input Absyn.Info a_srcInfo;
  input String a_errMessage;

  output Tpl.Text out_txt;
protected
  String ret_0;
algorithm
  Tpl.addSourceTemplateError(a_errMessage, a_srcInfo);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "#error "
                               }, false));
  ret_0 := Error.infoStr(a_srcInfo);
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("  "));
  out_txt := Tpl.writeStr(out_txt, a_errMessage);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end error;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "#error "
                               }, false));
  out_txt := Tpl.writeStr(out_txt, a_errMessage);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end errorMsg;

end CodegenCSharp;