encapsulated package CodegenJS
"
  file:        CodegenJS.mo
  package:     CodegenJS
  description: Generated by Susan.
"

public import Tpl;

public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCode;
public import HpcOmScheduler;
public import CodegenUtil;

public function markdownFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_fileNamePrefix)) )
      equation
        txt_0 = markdownContents(Tpl.emptyTxt, i_simCode);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".md"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end markdownFile;

public function markdownContents
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Real i_s_tolerance;
      Real i_s_stepSize;
      Real i_s_stopTime;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;
      Real ret_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = _, varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(stateVars = _), name = i_modelInfo_name), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(stopTime = i_s_stopTime, stepSize = i_s_stepSize, tolerance = i_s_tolerance)), makefileParams = SimCode.MAKEFILE_PARAMS(ccompiler = _), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "```yaml script=scriptloader\n",
                                    "- "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".js\n",
                                    "```\n",
                                    "\n",
                                    "```yaml script=dataloader\n",
                                    "xml: "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_init.xml\n",
                                    "```\n",
                                    "\n",
                                    "# OpenModelica simulation example\n",
                                    "## "
                                }, false));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_modelInfo_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "<img src=\""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".svg\" class=\"pull-right\" style=\"width:540px; background-color:#ffffff; border:2px solid gray\" />\n",
                                    "\n",
                                    "```yaml jquery=jsonForm class=\"form-horizontal\" name=frm\n",
                                    "schema:\n",
                                    "  stopTime:\n",
                                    "    type: string\n",
                                    "    title: Stop time [s]\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("default: "));
        txt = Tpl.writeStr(txt, realString(i_s_stopTime));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  intervals:\n",
                                    "    type: string\n",
                                    "    title: Output intervals\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("default: "));
        ret_2 = realDiv(i_s_stopTime, i_s_stepSize);
        txt = Tpl.writeStr(txt, realString(ret_2));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  tolerance:\n",
                                    "    type: string\n",
                                    "    title: Tolerance\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("default: "));
        txt = Tpl.writeStr(txt, realString(i_s_tolerance));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  solver:\n",
                                    "    type: string\n",
                                    "    title: Solver\n",
                                    "    enum:\n",
                                    "      - dassl\n",
                                    "      - euler\n",
                                    "      - rungekutta\n",
                                    "form:\n",
                                    "  - \"*\"\n",
                                    "params:\n",
                                    "  fieldHtmlClass: input-medium\n",
                                    "```\n",
                                    "\n",
                                    "```js\n",
                                    "$xml = $(xml)\n",
                                    "\n",
                                    "// Set the default simulation parameters\n",
                                    "defex = $xml.find(\"DefaultExperiment\")\n",
                                    "defex.attr(\"stopTime\", stopTime)\n",
                                    "defex.attr(\"stepSize\", +stopTime / intervals)\n",
                                    "defex.attr(\"tolerance\", tolerance)\n",
                                    "defex.attr(\"solver\", solver)\n",
                                    "\n",
                                    "// Set some model parameters\n",
                                    "\n",
                                    "// Write out the initialization file\n",
                                    "xmlstring = new XMLSerializer().serializeToString(xml)\n",
                                    "Module[\'FS_createDataFile\'](\'/\', \'"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_init.xml\', xmlstring, true, true)\n",
                                    "\n",
                                    "// Run the simulation!\n",
                                    "run()\n",
                                    "\n",
                                    "// delete the input file\n",
                                    "FS.unlink(\'/"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_init.xml\')\n",
                                    "```\n",
                                    "\n",
                                    "## Results\n",
                                    "\n",
                                    "```js\n",
                                    "// read the csv file with the simulation results\n",
                                    "csv = intArrayToString(FS.findObject(\""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_res.csv\").contents)\n",
                                    "x = $.csv.toArrays(csv, {onParseValue: $.csv.hooks.castToScalar})\n",
                                    "\n",
                                    "// `header` has the column names. The first is the time, and the rest\n",
                                    "// of the columns are the variables.\n",
                                    "header = x.slice(0,1)[0].slice(1)\n",
                                    "\n",
                                    "// Select graph variables with a select box based on the header values\n",
                                    "if (typeof(graphvar) == \"undefined\") graphvar = header[0];\n",
                                    "\n",
                                    "var jsonform = {\n",
                                    "  schema: {\n",
                                    "    graphvar: {\n",
                                    "      type: \"string\",\n",
                                    "      title: \"Plot variable\",\n",
                                    "      default: graphvar,\n",
                                    "      enum: header\n",
                                    "    }\n",
                                    "  },\n",
                                    "  form: [\n",
                                    "    {\n",
                                    "      key: \"graphvar\",\n",
                                    "      onChange: function (evt) {\n",
                                    "        calculate_forms();\n",
                                    "        $(\"#plotdiv\").calculate();\n",
                                    "      }\n",
                                    "    }\n",
                                    "  ]\n",
                                    "};\n",
                                    "\n",
                                    "$active_element.jsonForm(jsonform);\n",
                                    "```\n",
                                    "\n",
                                    "```js id=plotdiv\n",
                                    "idx = header.indexOf(graphvar) + 1;\n",
                                    "\n",
                                    "// pick out the column to plot\n",
                                    "series = x.slice(1).map(function(x) {return [x[0], x[idx]];});\n",
                                    "\n",
                                    "plot([series]);\n",
                                    "```\n",
                                    "\n",
                                    "## Comments\n",
                                    "\n",
                                    "This simulation model is from a [Modelica](http://modelica.org) model.\n",
                                    "Modelica is a language for simulating electrical, thermal, and\n",
                                    "mechanical, systems. [OpenModelica](http://openmodelica.org) was used\n",
                                    "to compile this model to C. Then, [Emscripten](http://emscripten.org/)\n",
                                    "was used to compile the C code to JavaScript.\n",
                                    "\n",
                                    "For more information on compiling OpenModelica to JavaScript, see\n",
                                    "[here](https://github.com/tshort/openmodelica-javascript).\n",
                                    "\n",
                                    "The user interface was created in\n",
                                    "[mdpad](http://tshort.github.io/mdpad/). See\n",
                                    "[chua.md](http://tshort.github.io/mdpad/chua.md) for the Markdown code\n",
                                    "for this page."
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end markdownContents;

end CodegenJS;