encapsulated package CodegenJava
"
  file:        CodegenJava.mo
  package:     CodegenJava
  description: Generated by Susan.
"

public import Tpl;

public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCode;
public import HpcOmScheduler;

protected function fun_31
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;
  input String in_a_fileNamePrefix;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettingsOpt, in_a_fileNamePrefix, in_a_simCode)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      SimCode.SimCode a_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix,
           a_simCode )
      equation
        txt_0 = simulationInitFile(Tpl.emptyTxt, a_simCode);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_init.txt"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end match;
end fun_31;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<DAE.Exp> i_literals;
      list<SimCode.Function> i_modelInfo_functions;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, literals = i_literals, simulationSettingsOpt = i_simulationSettingsOpt)) )
      equation
        txt_0 = simulationFile(Tpl.emptyTxt, i_simCode);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".java"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = simulationFunctionsFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_literals);
        txt_3 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("_functions.java"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt_4 = simulationMakefile(Tpl.emptyTxt, i_simCode);
        txt_5 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_4, Tpl.textString(txt_5));
        txt = fun_31(txt, i_simulationSettingsOpt, i_fileNamePrefix, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateModel;

public function translateFunctions
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_functionCode)
    local
      Tpl.Text txt;
      String i_name;
      Tpl.Text l_filePrefix;

    case ( txt,
           SimCode.FUNCTIONCODE(name = i_name) )
      equation
        l_filePrefix = Tpl.writeStr(Tpl.emptyTxt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateFunctions;

public function simulationFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.DelayedExpression i_delayedExps;
      SimCode.ExtObjInfo i_extObjInfo;
      SimCode.ModelInfo i_modelInfo;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = i_modelInfo, extObjInfo = i_extObjInfo, delayedExps = i_delayedExps)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = modelClassName(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = globalData(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = mainFunction(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = functionModelConstructor(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = functionInitializeDataStruc(txt);
        txt = Tpl.softNewLine(txt);
        txt = functionDeInitializeDataStruc(txt, i_extObjInfo);
        txt = Tpl.softNewLine(txt);
        txt = functionInput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = functionOutput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = functionDaeRes(txt);
        txt = Tpl.softNewLine(txt);
        txt = functionStoreDelayed(txt, i_delayedExps);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationFile;

public function simulationFileHeader
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), extObjInfo = SimCode.EXTOBJINFO(vars = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "package simCodeJava; // solver package name\n",
                                    "\n",
                                    "import java.io.IOException;\n",
                                    "import java.math.*;\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationFileHeader;

public function modelClassName
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(vars = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Simulation code for "));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".\n",
                                    "@SuppressWarnings(\"unused\")\n",
                                    "public class "
                                }, false));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " extends SuperModel // name of the given model\n",
                                    "{"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end modelClassName;

public function dotPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dotPath;

public function globalData
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      SimCode.ModelInfo i_modelInfo;

    case ( txt,
           (i_modelInfo as SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(stateVars = _))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("private static DATA localData = new DATA();\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//final time localData.timeValue = 0;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//final double $P$old$Ptime = localData.oldTime;\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//final double $P$current_step_size = globalData.current_stepsize;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = addGlobalInitialization(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end globalData;

protected function lm_39
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataInitialization(txt, i_var, "states");
        txt = Tpl.nextIter(txt);
        txt = lm_39(txt, rest);
      then txt;
  end match;
end lm_39;

protected function lm_40
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataInitialization(txt, i_var, "statesDerivatives");
        txt = Tpl.nextIter(txt);
        txt = lm_40(txt, rest);
      then txt;
  end match;
end lm_40;

protected function lm_41
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataInitialization(txt, i_var, "algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;
  end match;
end lm_41;

protected function lm_42
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataInitialization(txt, i_var, "parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_42(txt, rest);
      then txt;
  end match;
end lm_42;

public function addGlobalInitialization
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_39(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_40(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_41(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_42(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end addGlobalInitialization;

protected function lm_44
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "states");
        txt = Tpl.nextIter(txt);
        txt = lm_44(txt, rest);
      then txt;
  end match;
end lm_44;

protected function lm_45
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "statesDerivatives");
        txt = Tpl.nextIter(txt);
        txt = lm_45(txt, rest);
      then txt;
  end match;
end lm_45;

protected function lm_46
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_46(txt, rest);
      then txt;
  end match;
end lm_46;

protected function lm_47
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest);
      then txt;
  end match;
end lm_47;

public function addGlobalDefinition
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_44(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_45(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_46(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_47(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end addGlobalDefinition;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarReverseDefine(txt, i_var, "states");
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest);
      then txt;
  end match;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarReverseDefine(txt, i_var, "statesDerivatives");
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarReverseDefine(txt, i_var, "algebraics");
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      SimCode.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarReverseDefine(txt, i_var, "parameters");
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;
  end match;
end lm_52;

public function addVarReverseDefinition
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_49(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_50(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_51(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end addVarReverseDefinition;

protected function fun_54
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("private double "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_54;

public function globalDataInitialization
  input Tpl.Text txt;
  input SimCode.SimVar a_simVar;
  input String a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_54(txt, a_simVar);
end globalDataInitialization;

public function globalDataVarDefine
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.SIMVAR(name = i_name, index = i_index),
           a_arrayName )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = localData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end globalDataVarDefine;

public function globalDataVarReverseDefine
  input Tpl.Text in_txt;
  input SimCode.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      DAE.ComponentRef i_name;
      Integer i_index;

    case ( txt,
           SimCode.SIMVAR(index = i_index, name = i_name),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end globalDataVarReverseDefine;

public function mainFunction
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static SuperModel temp = new "));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("public static void main(String[] args) throws IOException\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("JavaSolver.solver_main(temp, localData);\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end mainFunction;

public function functionModelConstructor
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public "));
        txt = dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("()\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//localData = data;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//$Px = localData.states[0];\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//$P$DER$Px = localData.statesDerivatives[0];\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionModelConstructor;

public function functionInitializeDataStruc
  input Tpl.Text txt;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "  // Used to initialize the data structure\n",
                                   "  /*\n",
                                   "  public DATA initializeDataStruc(DATA_FLAGS flags)\n",
                                   "  {\n",
                                   "    DATA returnData = new DATA(fortran_integer, fortran_integer, fortran_integer, long, long,\n",
                                   "      fortran_integer, long, long, long, long, long);\n",
                                   "\n",
                                   "    return returnData;\n",
                                   "  }\n",
                                   "  */\n",
                                   "\n"
                               }, true));
end functionInitializeDataStruc;

public function functionDeInitializeDataStruc
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extObjInfo)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.EXTOBJINFO(vars = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  protected void finalize ()\n",
                                    "  {\n",
                                    "    System.out.println(\"memsucker %d destroyed...\\n\");\n",
                                    "  }\n",
                                    "\n",
                                    "  // used to deinitialize the data structure\n",
                                    "  public void deInitializeDataStruc(DATA data, DATA_FLAGS flags)\n",
                                    "  {\n",
                                    "    /* In java, memory deallocation is automatically handled. so no need to free the memory explicitly. */\n",
                                    "  }\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionDeInitializeDataStruc;

protected function lm_62
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = localData.inputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_62(txt, rest);
      then txt;
  end match;
end lm_62;

public function functionInput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_inputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(inputVars = i_vars_inputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  public int input_function()\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_62(txt, i_vars_inputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionInput;

protected function lm_64
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData.outputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_64(txt, rest);
      then txt;
  end match;
end lm_64;

public function functionOutput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_outputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCode.SIMVARS(outputVars = i_vars_outputVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  public int output_function()\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_64(txt, i_vars_outputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionOutput;

public function functionDaeRes
  input Tpl.Text txt;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "    @SuppressWarnings(\"null\") // To avoid  \"null\" warnings in Java\n",
                                   "  public int functionDAE_res(double t, double[] x, double[] xd, double[] delta, double ires, double rpar, double ipar)\n",
                                   "  {\n",
                                   "    int i;\n",
                                   "    double[] temp_xd = null;\n",
                                   "    double[] statesBackup;\n",
                                   "    double[] statesDerivativesBackup;\n",
                                   "    double timeBackup;\n",
                                   "\n",
                                   "    statesBackup = localData.states;\n",
                                   "    statesDerivativesBackup = localData.statesDerivatives;\n",
                                   "    timeBackup = localData.timeValue;\n",
                                   "    localData.states = x;\n",
                                   "\n",
                                   "    for (i = 0; i < localData.nStates; i++) {\n",
                                   "      temp_xd[i] = localData.statesDerivatives[i];\n",
                                   "    }\n",
                                   "\n",
                                   "    localData.statesDerivatives = temp_xd;\n",
                                   "    localData.timeValue = t;\n",
                                   "\n",
                                   "    functionODE();\n",
                                   "\n",
                                   "    /* get the difference between the temp_xd(=localData->statesDerivatives)\n",
                                   "      and xd(=statesDerivativesBackup) */\n",
                                   "    for (i = 0; i < localData.nStates; i++) {\n",
                                   "      delta[i] = localData.statesDerivatives[i] - statesDerivativesBackup[i];\n",
                                   "    }\n",
                                   "\n",
                                   "    localData.states = statesBackup;\n",
                                   "    localData.statesDerivatives = statesDerivativesBackup;\n",
                                   "    localData.timeValue = timeBackup;\n",
                                   "\n",
                                   "    return 0;\n",
                                   "  }\n",
                                   "\n"
                               }, true));
end functionDaeRes;

protected function lm_67
  input Tpl.Text in_txt;
  input list<tuple<Integer, tuple<DAE.Exp, DAE.Exp, DAE.Exp>>> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, tuple<DAE.Exp, DAE.Exp, DAE.Exp>>> rest;
      Tpl.Text a_varDecls;
      Integer i_id;
      DAE.Exp i_e;
      Tpl.Text l_eRes;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           (i_id, (i_e, _, _)) :: rest,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_eRes, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("storeDelayedExpression("));
        txt = Tpl.writeStr(txt, intString(i_id));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_eRes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        (txt, a_varDecls) = lm_67(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_67;

protected function fun_68
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_delayed, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<tuple<Integer, tuple<DAE.Exp, DAE.Exp, DAE.Exp>>> i_delayedExps;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(delayedExps = i_delayedExps),
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_67(txt, i_delayedExps, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_68;

protected function fun_69
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_delayed)
    local
      Tpl.Text txt;
      Integer i_maxDelayedIndex;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(maxDelayedIndex = i_maxDelayedIndex) )
      equation
        txt = Tpl.writeStr(txt, intString(i_maxDelayedIndex));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_69;

public function functionStoreDelayed
  input Tpl.Text txt;
  input SimCode.DelayedExpression a_delayed;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_storePart;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  (l_storePart, l_varDecls) := fun_68(Tpl.emptyTxt, a_delayed, l_varDecls);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("  /*\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(3));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("* extern int const numDelayExpressionIndex = "));
  out_txt := fun_69(out_txt, a_delayed);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(";\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  */\n",
                                       "  public int function_storeDelayed()\n",
                                       "  {\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_storePart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  }\n",
                                       "\n"
                                   }, true));
end functionStoreDelayed;

protected function lm_71
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_71(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_71;

public function functionODE
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input SimCode.ModelInfo a_modelInfo;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_odeEquations;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_odeEquations := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_odeEquations, l_varDecls) := lm_71(l_odeEquations, a_derivativEquations, l_varDecls);
  l_odeEquations := Tpl.popIter(l_odeEquations);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "    public int functionODE(DATA localData)\n",
                                   "    {\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(6));
  out_txt := addGlobalDefinition(out_txt, a_modelInfo);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_odeEquations);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := addVarReverseDefinition(out_txt, a_modelInfo);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "  return 0;\n",
                                       "}\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}// end main class\n",
                                       "\n"
                                   }, true));
end functionODE;

public function equation_
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(index = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = equationSimpleAssign(txt, i_e, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equation_;

public function equationSimpleAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end equationSimpleAssign;

protected function fun_75
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(0)"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1)"));
      then txt;
  end match;
end fun_75;

public function daeExp
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_e;
      DAE.ComponentRef i_componentRef;
      Boolean i_bool;
      Real i_real;
      Integer i_integer;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.RCONST(real = i_real),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.BCONST(bool = i_bool),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = fun_75(txt, i_bool);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = i_componentRef),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = cref(txt, i_componentRef);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.BINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpBinary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.UNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LBINARY(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLbinary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.LUNARY(operator = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpLunary(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.RELATION(exp1 = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpRelation(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_e as DAE.IFEXP(expCond = _)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = daeExpIf(txt, i_e, a_context, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_EXP"));
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExp;

protected function fun_77
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_exp;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_operator, in_a_varDecls, in_a_preExp, in_a_context, in_a_exp, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_exp;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.ADD(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SUB(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.MUL(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.DIV(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" / "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.POW(ty = _),
           a_varDecls,
           a_preExp,
           _,
           _,
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.pow("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.UMINUS(ty = _),
           a_varDecls,
           a_preExp,
           a_context,
           a_exp,
           _,
           _ )
      equation
        (txt, a_preExp, a_varDecls) = daeExpUnary(txt, a_exp, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR"));
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_77;

public function daeExpBinary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           (i_exp as DAE.BINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator)),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        (txt, a_varDecls, a_preExp) = fun_77(txt, i_operator, a_varDecls, a_preExp, a_context, i_exp, l_e2, l_e1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpBinary;

protected function fun_79
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_e;

    case ( txt,
           DAE.UMINUS(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(-"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpUnary:ERR"));
      then txt;
  end match;
end fun_79;

public function daeExpUnary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.UNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = fun_79(txt, i_operator, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpUnary;

protected function fun_81
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.AND(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.OR(ty = _),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpLbinary:ERR"));
      then txt;
  end match;
end fun_81;

public function daeExpLbinary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp2;
      DAE.Exp i_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           DAE.LBINARY(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp2, a_context, a_preExp, a_varDecls);
        txt = fun_81(txt, i_operator, l_e2, l_e1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpLbinary;

protected function fun_83
  input Tpl.Text in_txt;
  input DAE.Operator in_a_operator;
  input Tpl.Text in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_operator, in_a_e)
    local
      Tpl.Text txt;
      Tpl.Text a_e;

    case ( txt,
           DAE.NOT(ty = _),
           a_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_83;

public function daeExpLunary
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_operator;
      DAE.Exp i_exp;
      Tpl.Text l_e;

    case ( txt,
           DAE.LUNARY(exp = i_exp, operator = i_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls);
        txt = fun_83(txt, i_operator, l_e);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpLunary;

protected function fun_85
  input Tpl.Text in_txt;
  input DAE.Operator in_a_rel_operator;
  input Tpl.Text in_a_e2;
  input Tpl.Text in_a_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_rel_operator, in_a_e2, in_a_e1)
    local
      Tpl.Text txt;
      Tpl.Text a_e2;
      Tpl.Text a_e1;

    case ( txt,
           DAE.LESS(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_STRING(varLst = _)),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".equals("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.T_ENUMERATION(index = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_BOOL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_STRING(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".equals("));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_INTEGER(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.T_REAL(varLst = _)),
           a_e2,
           a_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, a_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpRelation:ERR"));
      then txt;
  end match;
end fun_85;

public function daeExpRelation
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Operator i_rel_operator;
      DAE.Exp i_rel_exp2;
      DAE.Exp i_rel_exp1;
      Tpl.Text l_e2;
      Tpl.Text l_e1;

    case ( txt,
           DAE.RELATION(exp1 = i_rel_exp1, exp2 = i_rel_exp2, operator = i_rel_operator),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_e1, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_rel_exp1, a_context, a_preExp, a_varDecls);
        (l_e2, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_rel_exp2, a_context, a_preExp, a_varDecls);
        txt = fun_85(txt, i_rel_operator, l_e2, l_e1);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpRelation;

protected function fun_87
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExpElse;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExpElse)
    local
      Tpl.Text txt;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("x"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_87;

protected function fun_88
  input Tpl.Text in_txt;
  input Tpl.Text in_a_preExpThen;
  input Tpl.Text in_a_preExpElse;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_preExpThen, in_a_preExpElse)
    local
      Tpl.Text txt;
      Tpl.Text a_preExpElse;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_preExpElse )
      equation
        txt = fun_87(txt, a_preExpElse);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_88;

protected function fun_89
  input Tpl.Text in_txt;
  input Tpl.Text in_a_shortIfExp;
  input Tpl.Text in_a_eElse;
  input Tpl.Text in_a_preExpElse;
  input Tpl.Text in_a_eThen;
  input Tpl.Text in_a_preExpThen;
  input Tpl.Text in_a_condExp;
  input Tpl.Text in_a_preExp;
  input DAE.Exp in_a_expThen;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_shortIfExp, in_a_eElse, in_a_preExpElse, in_a_eThen, in_a_preExpThen, in_a_condExp, in_a_preExp, in_a_expThen, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_eElse;
      Tpl.Text a_preExpElse;
      Tpl.Text a_eThen;
      Tpl.Text a_preExpThen;
      Tpl.Text a_condExp;
      Tpl.Text a_preExp;
      DAE.Exp a_expThen;
      Tpl.Text a_varDecls;
      Tpl.Text l_resVar;
      Tpl.Text l_resVarType;
      Tpl.Text l_condVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_eElse,
           a_preExpElse,
           a_eThen,
           a_preExpThen,
           a_condExp,
           a_preExp,
           a_expThen,
           a_varDecls )
      equation
        (l_condVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_boolean", a_varDecls);
        l_resVarType = expTypeFromExpArrayIf(Tpl.emptyTxt, a_expThen);
        (l_resVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_resVarType), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_condVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = (modelica_boolean)"));
        a_preExp = Tpl.writeText(a_preExp, a_condExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING_LIST({
                                              ";\n",
                                              "if ("
                                          }, false));
        a_preExp = Tpl.writeText(a_preExp, l_condVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(") {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_preExpThen);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_resVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = ("));
        a_preExp = Tpl.writeText(a_preExp, l_resVarType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")"));
        a_preExp = Tpl.writeText(a_preExp, a_eThen);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(";\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE("} else {\n"));
        a_preExp = Tpl.pushBlock(a_preExp, Tpl.BT_INDENT(2));
        a_preExp = Tpl.writeText(a_preExp, a_preExpElse);
        a_preExp = Tpl.softNewLine(a_preExp);
        a_preExp = Tpl.writeText(a_preExp, l_resVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = ("));
        a_preExp = Tpl.writeText(a_preExp, l_resVarType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(")"));
        a_preExp = Tpl.writeText(a_preExp, a_eElse);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_LINE(";\n"));
        a_preExp = Tpl.popBlock(a_preExp);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("}"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_resVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_eElse,
           _,
           a_eThen,
           _,
           a_condExp,
           a_preExp,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("?"));
        txt = Tpl.writeText(txt, a_eThen);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        txt = Tpl.writeText(txt, a_eElse);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_89;

public function daeExpIf
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_expElse;
      DAE.Exp i_expThen;
      DAE.Exp i_expCond;
      Tpl.Text l_shortIfExp;
      Tpl.Text l_eElse;
      Tpl.Text l_preExpElse;
      Tpl.Text l_eThen;
      Tpl.Text l_preExpThen;
      Tpl.Text l_condExp;

    case ( txt,
           DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        (l_condExp, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_expCond, a_context, a_preExp, a_varDecls);
        l_preExpThen = Tpl.emptyTxt;
        (l_eThen, l_preExpThen, a_varDecls) = daeExp(Tpl.emptyTxt, i_expThen, a_context, l_preExpThen, a_varDecls);
        l_preExpElse = Tpl.emptyTxt;
        (l_eElse, l_preExpElse, a_varDecls) = daeExp(Tpl.emptyTxt, i_expElse, a_context, l_preExpElse, a_varDecls);
        l_shortIfExp = fun_88(Tpl.emptyTxt, l_preExpThen, l_preExpElse);
        (txt, a_preExp, a_varDecls) = fun_89(txt, l_shortIfExp, l_eElse, l_preExpElse, l_eThen, l_preExpThen, l_condExp, a_preExp, i_expThen, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end daeExpIf;

public function daeExpCallBuiltinPrefix
  input Tpl.Text in_txt;
  input Boolean in_a_builtin;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_builtin)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end daeExpCallBuiltinPrefix;

public function algStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Statement i_s;

    case ( txt,
           (i_s as DAE.STMT_ASSIGN(type_ = _)),
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStmtAssign(txt, i_s, a_context, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED ALG STATEMENT"));
      then (txt, a_varDecls);
  end match;
end algStatement;

public function algStmtAssign
  input Tpl.Text in_txt;
  input DAE.Statement in_a_stmt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      DAE.Exp i_exp1;
      DAE.Exp i_e;
      Tpl.Text l_expPart2;
      Tpl.Text l_expPart1;
      Tpl.Text l_varPart;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = DAE.CREF(componentRef = DAE.WILD()), exp = i_e),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(componentRef = _)), exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_varPart, l_preExp, a_varDecls) = scalarLhsCref(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = i_exp1, exp = i_exp),
           a_context,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart1, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp1, a_context, l_preExp, a_varDecls);
        (l_expPart2, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end algStmtAssign;

protected function fun_94
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_ecr_componentRef;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_mArg, in_a_ecr_componentRef, in_a_varDecls, in_a_preExp, in_a_context, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_ecr_componentRef;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp a_ecr;

    case ( txt,
           false,
           _,
           a_varDecls,
           a_preExp,
           a_context,
           a_ecr )
      equation
        (txt, a_preExp, a_varDecls) = daeExpCrefRhs(txt, a_ecr, a_context, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_ecr_componentRef,
           a_varDecls,
           a_preExp,
           a_context,
           _ )
      equation
        txt = contextCref(txt, a_ecr_componentRef, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_94;

public function scalarLhsCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_ecr, in_a_context, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Exp i_ecr;
      DAE.ComponentRef i_ecr_componentRef;
      DAE.ComponentRef i_cr;
      Boolean ret_0;

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = DAE.T_FUNCTION_REFERENCE_VAR(functionType = _)),
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*((modelica_fnptr*)&_"));
        txt = functionName(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_ecr as DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_IDENT(ident = _)))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        ret_0 = SimCodeUtil.crefNoSub(i_ecr_componentRef);
        (txt, a_varDecls, a_preExp) = fun_94(txt, ret_0, i_ecr_componentRef, a_varDecls, a_preExp, a_context, i_ecr);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.CREF(componentRef = (i_ecr_componentRef as DAE.CREF_QUAL(ident = _))),
           a_context,
           a_preExp,
           a_varDecls )
      equation
        txt = contextCref(txt, i_ecr_componentRef, a_context);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ONLY_IDENT_OR_QUAL_CREF_SUPPORTED_SLHS"));
      then (txt, a_preExp, a_varDecls);
  end match;
end scalarLhsCref;

public function functionName
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.stringReplace(i_ident, "_", "__");
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_1 = System.stringReplace(i_ident, "_", "__");
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = functionName(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionName;

protected function fun_97
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = crefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = cref(txt, a_cr);
      then txt;
  end match;
end fun_97;

public function contextCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_97(txt, a_context, a_cr);
end contextCref;

public function cref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_cr);
      then txt;
  end match;
end cref;

protected function fun_100
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_100;

protected function fun_101
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;
      DAE.Type i_ty;
      Tpl.Text l_cast;

    case ( txt,
           DAE.CREF(componentRef = i_cr, ty = i_ty) )
      equation
        l_cast = fun_100(Tpl.emptyTxt, i_ty);
        txt = Tpl.writeText(txt, l_cast);
        txt = cref(txt, i_cr);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_101;

public function daeExpCrefRhs
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_101(txt, a_exp);
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpCrefRhs;

public function crefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = crefStr(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefStr;

protected function lm_104
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_104(txt, rest);
      then txt;
  end match;
end lm_104;

public function subscriptsStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_104(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end subscriptsStr;

protected function fun_106
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_subscript, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.WHOLEDIM(),
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_106;

public function subscriptStr
  input Tpl.Text txt;
  input DAE.Subscript a_subscript;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDecls;
  Tpl.Text l_preExp;
algorithm
  l_preExp := Tpl.emptyTxt;
  l_varDecls := Tpl.emptyTxt;
  (out_txt, l_varDecls, l_preExp) := fun_106(txt, a_subscript, l_varDecls, l_preExp);
end subscriptStr;

public function crefToCStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsToCStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefToCStr;

protected function lm_109
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToCStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_109(txt, rest);
      then txt;
  end match;
end lm_109;

public function subscriptsToCStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$lB"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("$c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_109(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$rB"));
      then txt;
  end match;
end subscriptsToCStr;

protected function fun_111
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_subscript, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      DAE.Exp i_exp;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, SimCode.contextSimulationNonDiscrete, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, i_exp, SimCode.contextSimulationNonDiscrete, a_preExp, a_varDecls);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           DAE.WHOLEDIM(),
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_varDecls,
           a_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_111;

public function subscriptToCStr
  input Tpl.Text txt;
  input DAE.Subscript a_subscript;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDecls;
  Tpl.Text l_preExp;
algorithm
  l_preExp := Tpl.emptyTxt;
  l_varDecls := Tpl.emptyTxt;
  (out_txt, l_varDecls, l_preExp) := fun_111(txt, a_subscript, l_varDecls, l_preExp);
end subscriptToCStr;

public function expTypeFromExpArrayIf
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlag(txt, a_exp, 4);
end expTypeFromExpArrayIf;

protected function fun_114
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      ClassInf.State i_complexClassType;
      Absyn.Path ret_0;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        ret_0 = ClassInf.getStateName(i_complexClassType);
        txt = underscorePath(txt, ret_0);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = expTypeShort(txt, i_ty);
      then txt;
  end match;
end fun_114;

protected function fun_115
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = fun_114(txt, i_ty);
      then txt;
  end match;
end fun_115;

protected function fun_116
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array"));
      then txt;

    case ( txt,
           i_ty )
      equation
        txt = expTypeFlag(txt, i_ty, 2);
      then txt;
  end match;
end fun_116;

protected function fun_117
  input Tpl.Text in_txt;
  input Integer in_a_flag;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;

    case ( txt,
           1,
           a_ty )
      equation
        txt = expTypeShort(txt, a_ty);
      then txt;

    case ( txt,
           2,
           a_ty )
      equation
        txt = fun_115(txt, a_ty);
      then txt;

    case ( txt,
           3,
           a_ty )
      equation
        txt = expTypeShort(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_array"));
      then txt;

    case ( txt,
           4,
           a_ty )
      equation
        txt = fun_116(txt, a_ty);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_117;

public function expTypeFlag
  input Tpl.Text txt;
  input DAE.Type a_ty;
  input Integer a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_117(txt, a_flag, a_ty);
end expTypeFlag;

public function tempDecl
  input Tpl.Text txt;
  input String a_ty;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Integer ret_1;
  Tpl.Text l_newVar;
algorithm
  l_newVar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("tmp"));
  ret_1 := System.tmpTick();
  l_newVar := Tpl.writeStr(l_newVar, intString(ret_1));
  out_a_varDecls := Tpl.writeStr(a_varDecls, a_ty);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" "));
  out_a_varDecls := Tpl.writeText(out_a_varDecls, l_newVar);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(";"));
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_newVar);
end tempDecl;

protected function fun_120
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           8 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_integer"));
      then txt;
  end match;
end fun_120;

protected function fun_121
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_real"));
      then txt;
  end match;
end fun_121;

protected function fun_122
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_string"));
      then txt;
  end match;
end fun_122;

protected function fun_123
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;
  end match;
end fun_123;

protected function fun_124
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_flag)
    local
      Tpl.Text txt;
      Integer a_flag;

    case ( txt,
           false,
           a_flag )
      equation
        txt = fun_122(txt, a_flag);
      then txt;

    case ( txt,
           _,
           a_flag )
      equation
        txt = fun_123(txt, a_flag);
      then txt;
  end match;
end fun_124;

protected function fun_125
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean"));
      then txt;
  end match;
end fun_125;

protected function fun_126
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           8 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_integer"));
      then txt;
  end match;
end fun_126;

public function expTypeFromExpFlag
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_flag)
    local
      Tpl.Text txt;
      Integer a_flag;
      DAE.Exp i_exp;
      DAE.Type i_attr_ty;
      DAE.Exp i_expThen;
      DAE.Operator i_e_operator;
      String ret_1;
      Boolean ret_0;

    case ( txt,
           DAE.ICONST(integer = _),
           a_flag )
      equation
        txt = fun_120(txt, a_flag);
      then txt;

    case ( txt,
           DAE.RCONST(real = _),
           a_flag )
      equation
        txt = fun_121(txt, a_flag);
      then txt;

    case ( txt,
           DAE.SCONST(string = _),
           a_flag )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        txt = fun_124(txt, ret_0, a_flag);
      then txt;

    case ( txt,
           DAE.BCONST(bool = _),
           a_flag )
      equation
        txt = fun_125(txt, a_flag);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(name = _),
           a_flag )
      equation
        txt = fun_126(txt, a_flag);
      then txt;

    case ( txt,
           DAE.BINARY(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlag(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.UNARY(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlag(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.LBINARY(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlag(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.LUNARY(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlag(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.RELATION(operator = i_e_operator),
           a_flag )
      equation
        txt = expTypeFromOpFlag(txt, i_e_operator, a_flag);
      then txt;

    case ( txt,
           DAE.IFEXP(expThen = i_expThen),
           a_flag )
      equation
        txt = expTypeFromExpFlag(txt, i_expThen, a_flag);
      then txt;

    case ( txt,
           DAE.CALL(attr = DAE.CALL_ATTR(ty = i_attr_ty)),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_attr_ty, a_flag);
      then txt;

    case ( txt,
           i_exp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#error \"expTypeFromExpFlag:"));
        ret_1 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end expTypeFromExpFlag;

protected function fun_128
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;
  end match;
end fun_128;

public function expTypeShort
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;
      ClassInf.State i_complexClassType;
      DAE.Type i_ty;
      Absyn.Path ret_1;
      Boolean ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        txt = fun_128(txt, ret_0);
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("complex"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = i_complexClassType) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        ret_1 = ClassInf.getStateName(i_complexClassType);
        txt = underscorePath(txt, ret_1);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fnptr"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeShort:ERROR"));
      then txt;
  end match;
end expTypeShort;

public function replaceDotAndUnderscore
  input Tpl.Text in_txt;
  input String in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_str)
    local
      Tpl.Text txt;
      String i_name;
      String ret_3;
      Tpl.Text l_str__underscores;
      String ret_1;
      Tpl.Text l_str__dots;

    case ( txt,
           i_name )
      equation
        ret_1 = System.stringReplace(i_name, ".", "_");
        l_str__dots = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = System.stringReplace(Tpl.textString(l_str__dots), "_", "__");
        l_str__underscores = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        txt = Tpl.writeText(txt, l_str__underscores);
      then txt;
  end match;
end replaceDotAndUnderscore;

public function underscorePath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end underscorePath;

protected function fun_132
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean"));
      then txt;
  end match;
end fun_132;

protected function fun_133
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean"));
      then txt;
  end match;
end fun_133;

protected function fun_134
  input Tpl.Text in_txt;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag)
    local
      Tpl.Text txt;

    case ( txt,
           1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boolean"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_boolean"));
      then txt;
  end match;
end fun_134;

public function expTypeFromOpFlag
  input Tpl.Text in_txt;
  input DAE.Operator in_a_op;
  input Integer in_a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op, in_a_flag)
    local
      Tpl.Text txt;
      Integer a_flag;
      DAE.Type i_o_ty;

    case ( txt,
           DAE.ADD(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.SUB(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.MUL(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.DIV(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.POW(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.UMINUS(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.LESS(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.GREATER(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.EQUAL(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = i_o_ty),
           a_flag )
      equation
        txt = expTypeFlag(txt, i_o_ty, a_flag);
      then txt;

    case ( txt,
           DAE.AND(ty = _),
           a_flag )
      equation
        txt = fun_132(txt, a_flag);
      then txt;

    case ( txt,
           DAE.OR(ty = _),
           a_flag )
      equation
        txt = fun_133(txt, a_flag);
      then txt;

    case ( txt,
           DAE.NOT(ty = _),
           a_flag )
      equation
        txt = fun_134(txt, a_flag);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeFromOpFlag:ERROR"));
      then txt;
  end match;
end expTypeFromOpFlag;

public function infoArgs
  input Tpl.Text in_txt;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_info)
    local
      Tpl.Text txt;
      Boolean i_isReadOnly;
      Integer i_columnNumberEnd;
      Integer i_lineNumberEnd;
      Integer i_columnNumberStart;
      Integer i_lineNumberStart;
      String i_fileName;

    case ( txt,
           Absyn.INFO(fileName = i_fileName, lineNumberStart = i_lineNumberStart, columnNumberStart = i_columnNumberStart, lineNumberEnd = i_lineNumberEnd, columnNumberEnd = i_columnNumberEnd, isReadOnly = i_isReadOnly) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_fileName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\","));
        txt = Tpl.writeStr(txt, intString(i_lineNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_columnNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_lineNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_columnNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_isReadOnly));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end infoArgs;

public function assertCommon
  input Tpl.Text txt;
  input DAE.Exp a_condition;
  input DAE.Exp a_message;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Absyn.Info a_info;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_msgVar;
  Tpl.Text l_condVar;
  Tpl.Text l_preExpMsg;
  Tpl.Text l_preExpCond;
algorithm
  l_preExpCond := Tpl.emptyTxt;
  l_preExpMsg := Tpl.emptyTxt;
  (l_condVar, l_preExpCond, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_condition, a_context, l_preExpCond, a_varDecls);
  (l_msgVar, l_preExpMsg, out_a_varDecls) := daeExp(Tpl.emptyTxt, a_message, a_context, l_preExpMsg, out_a_varDecls);
  out_txt := Tpl.writeText(txt, l_preExpCond);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("if (!"));
  out_txt := Tpl.writeText(out_txt, l_condVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(") {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_preExpMsg);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("omc_fileInfo info = {"));
  out_txt := infoArgs(out_txt, a_info);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "};\n",
                                       "MODELICA_ASSERT(info, "
                                   }, false));
  out_txt := Tpl.writeText(out_txt, l_msgVar);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(");\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end assertCommon;

public function expTypeFromExpShort
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlag(txt, a_exp, 1);
end expTypeFromExpShort;

public function expTypeFromExpModelica
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExpFlag(txt, a_exp, 2);
end expTypeFromExpModelica;

protected function fun_140
  input Tpl.Text in_txt;
  input DAE.Type in_a_varType;
  input String in_a_varName;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_varType, in_a_varName, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_varName;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      DAE.Type i_varType;
      Tpl.Text l_tmpVar;
      Tpl.Text l_ty;
      Tpl.Text l_shortType;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_METATYPE(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           DAE.T_METABOXED(ty = _),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeStr(txt, a_varName);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           (i_varType as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _))),
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        (txt, a_preExp, a_varDecls) = unboxRecord(txt, a_varName, i_varType, a_preExp, a_varDecls);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           i_varType,
           a_varName,
           a_preExp,
           a_varDecls )
      equation
        l_shortType = mmcExpTypeShort(Tpl.emptyTxt, i_varType);
        l_ty = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("modelica_"));
        l_ty = Tpl.writeText(l_ty, l_shortType);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_ty), a_varDecls);
        a_preExp = Tpl.writeText(a_preExp, l_tmpVar);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(" = mmc_unbox_"));
        a_preExp = Tpl.writeText(a_preExp, l_shortType);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING("("));
        a_preExp = Tpl.writeStr(a_preExp, a_varName);
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_STRING(");"));
        a_preExp = Tpl.writeTok(a_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_140;

public function unboxVariable
  input Tpl.Text txt;
  input String a_varName;
  input DAE.Type a_varType;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_140(txt, a_varType, a_varName, a_preExp, a_varDecls);
end unboxVariable;

protected function lm_142
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Tpl.Text in_a_tmpVar;
  input String in_a_recordVar;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmpVar, in_a_recordVar, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Tpl.Text a_tmpVar;
      String a_recordVar;
      Tpl.Text a_varDecls;
      Integer x_offset;
      DAE.Ident i_compname;
      DAE.Type i_ty;
      Tpl.Text l_unboxStr;
      Tpl.Text l_unboxBuf;
      Tpl.Text l_untagTmp;
      Tpl.Text l_varType;

    case ( txt,
           {},
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           DAE.TYPES_VAR(name = i_compname, ty = i_ty) :: rest,
           a_tmpVar,
           a_recordVar,
           a_varDecls )
      equation
        x_offset = Tpl.getIteri_i0(txt);
        l_varType = mmcExpTypeShort(Tpl.emptyTxt, i_ty);
        (l_untagTmp, a_varDecls) = tempDecl(Tpl.emptyTxt, "modelica_metatype", a_varDecls);
        l_unboxBuf = Tpl.emptyTxt;
        (l_unboxStr, l_unboxBuf, a_varDecls) = unboxVariable(Tpl.emptyTxt, Tpl.textString(l_untagTmp), i_ty, l_unboxBuf, a_varDecls);
        txt = Tpl.writeText(txt, l_untagTmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = (MMC_FETCH(MMC_OFFSET(MMC_UNTAGPTR("));
        txt = Tpl.writeStr(txt, a_recordVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), "));
        txt = Tpl.writeStr(txt, intString(x_offset));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")));\n"));
        txt = Tpl.writeText(txt, l_unboxBuf);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_tmpVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, i_compname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_unboxStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_142(txt, rest, a_tmpVar, a_recordVar, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmpVar,
           a_recordVar,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_142(txt, rest, a_tmpVar, a_recordVar, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_142;

protected function fun_143
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input String in_a_recordVar;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_recordVar, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_recordVar;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      list<DAE.Var> i_vars;
      Absyn.Path i_path;
      Tpl.Text txt_1;
      Tpl.Text l_tmpVar;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_path), varLst = i_vars),
           a_recordVar,
           a_preExp,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("struct "));
        txt_1 = underscorePath(txt_1, i_path);
        (l_tmpVar, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        a_preExp = Tpl.pushIter(a_preExp, Tpl.ITER_OPTIONS(2, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (a_preExp, a_varDecls) = lm_142(a_preExp, i_vars, l_tmpVar, a_recordVar, a_varDecls);
        a_preExp = Tpl.popIter(a_preExp);
        txt = Tpl.writeText(txt, l_tmpVar);
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           _,
           a_preExp,
           a_varDecls )
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_143;

public function unboxRecord
  input Tpl.Text txt;
  input String a_recordVar;
  input DAE.Type a_ty;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) := fun_143(txt, a_ty, a_recordVar, a_preExp, a_varDecls);
end unboxRecord;

public function mmcExpTypeShort
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("array"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fnptr"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmcExpTypeShort:ERROR"));
      then txt;
  end match;
end mmcExpTypeShort;

public function simulationFunctionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "\n"
                               }, true));
end simulationFunctionsFile;

protected function fun_147
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_147;

protected function lm_148
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_148(txt, rest);
      then txt;
  end match;
end lm_148;

protected function fun_149
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_149;

protected function fun_150
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_150;

public function simulationMakefile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs), fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_147(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_148(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_149(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_150(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "#top_dir = /c/OpenModelica/java_runtime/\n",
                                    "#simulation_dir = $(top_dir)simCodeJava/\n",
                                    "\n",
                                    "#all: copy\n",
                                    "\n",
                                    "#copy:\n",
                                    "#"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "cp TestModel.java $(simulation_dir)\n",
                                    "#"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "cp TestModel_init.txt $(top_dir)\n",
                                    "#"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(cd $(top_dir); make -f Makefile)\n",
                                    "\n",
                                    "JFLAGS = -g\n",
                                    "JC = javac\n",
                                    ".SUFFIXES: .java .class\n",
                                    ".java.class:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(JC) $(JFLAGS) $*.java\n",
                                    "\n",
                                    "top_dir = ${OPENMODELICAHOME}/\n",
                                    "cRuntime = $(top_dir)c_runtime/\n",
                                    "Jar = $(top_dir)share/java/\n",
                                    "simcodejava = $(cRuntime)java_interface/src/org/openmodelica/\n",
                                    "simulation_dir = $(top_dir)java_runtime/simCodeJava/\n",
                                    "\n",
                                    "CLASSES = \\\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("simCodeJava/"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".java\n",
                                    "#"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(simulation_dir)/JavaSolver.java \\\n",
                                    "\n",
                                    "default: all\n",
                                    "\n",
                                    "classes: $(CLASSES:.java=.class)\n",
                                    "\n",
                                    "clean:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(RM) *.class\n",
                                    "\n",
                                    "all: classes\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("java -cp .:java_runtime.jar "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationMakefile;

public function simulationInitFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      Integer i_vi_numStringAlgVars;
      Integer i_vi_numStringParamVars;
      Integer i_vi_numBoolAlgVars;
      Integer i_vi_numBoolParams;
      Integer i_vi_numIntAlgVars;
      Integer i_vi_numIntParams;
      Integer i_vi_numParams;
      Integer i_vi_numAlgVars;
      Integer i_vi_numStateVars;
      String i_s_outputFormat;
      String i_s_method;
      Real i_s_tolerance;
      Real i_s_stepSize;
      Real i_s_stopTime;
      Real i_s_startTime;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_vi_numStateVars, numAlgVars = i_vi_numAlgVars, numParams = i_vi_numParams, numIntParams = i_vi_numIntParams, numIntAlgVars = i_vi_numIntAlgVars, numBoolParams = i_vi_numBoolParams, numBoolAlgVars = i_vi_numBoolAlgVars, numStringParamVars = i_vi_numStringParamVars, numStringAlgVars = i_vi_numStringAlgVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, intAlgVars = i_vars_intAlgVars, boolParamVars = i_vars_boolParamVars, boolAlgVars = i_vars_boolAlgVars, stringParamVars = i_vars_stringParamVars, stringAlgVars = i_vars_stringAlgVars)), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_s_startTime, stopTime = i_s_stopTime, stepSize = i_s_stepSize, tolerance = i_s_tolerance, method = i_s_method, outputFormat = i_s_outputFormat))) )
      equation
        txt = Tpl.writeStr(txt, realString(i_s_startTime));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // start value\n"));
        txt = Tpl.writeStr(txt, realString(i_s_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // stop value\n"));
        txt = Tpl.writeStr(txt, realString(i_s_stepSize));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // step value\n"));
        txt = Tpl.writeStr(txt, realString(i_s_tolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " // tolerance\n",
                                    "\""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_method);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" // method\n",
                                    "\""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" // outputFormat\n"));
        txt = Tpl.writeStr(txt, intString(i_vi_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // n states\n"));
        txt = Tpl.writeStr(txt, intString(i_vi_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // n alg vars\n"));
        txt = Tpl.writeStr(txt, intString(i_vi_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" //n parameters\n"));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // n int parameters\n"));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // n int variables\n"));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // n bool parameters\n"));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // n bool variables\n"));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // n string-parameters\n"));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" // n string variables\n"));
        txt = initVals(txt, i_vars_stateVars);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_derivativeVars);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = initVals(txt, i_vars_stringAlgVars);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationInitFile;

protected function fun_153
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end match;
end fun_153;

protected function fun_154
  input Tpl.Text in_txt;
  input DAE.Exp in_a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v)
    local
      Tpl.Text txt;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = Util.escapeModelicaStringToCString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_153(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*ERROR* initial value of unknown type"));
      then txt;
  end match;
end fun_154;

protected function fun_155
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v) )
      equation
        txt = fun_154(txt, i_v);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0.0 //default"));
      then txt;
  end match;
end fun_155;

protected function lm_156
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Option<DAE.Exp> i_initialValue;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(initialValue = i_initialValue) :: rest )
      equation
        txt = fun_155(txt, i_initialValue);
        txt = Tpl.nextIter(txt);
        txt = lm_156(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_156(txt, rest);
      then txt;
  end match;
end lm_156;

public function initVals
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_varsLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_156(out_txt, a_varsLst);
  out_txt := Tpl.popIter(out_txt);
end initVals;

public function functionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
end functionsFile;

public function externalFunctionIncludes
  input Tpl.Text txt;
  input list<String> a_includes;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "\n"
                               }, true));
end externalFunctionIncludes;

end CodegenJava;