encapsulated package SimCodeDump
"
  file:        SimCodeDump.mo
  package:     SimCodeDump
  description: Generated by Susan.
"

public import Tpl;

public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCode;
public import HpcOmScheduler;
public import CodegenUtil;

public function dumpSimCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_code;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_code, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      String i_fileNamePrefix;
      SimCode.SimCode i_sc;
      Tpl.Text txt_1;
      Tpl.Text l_res;

    case ( txt,
           (i_sc as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = _)), fileNamePrefix = i_fileNamePrefix)),
           a_withOperations )
      equation
        l_res = dumpSimCodeBase(Tpl.emptyTxt, i_sc, a_withOperations);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_info.xml"));
        Tpl.textFile(l_res, Tpl.textString(txt_1));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSimCode;

public function dumpSimCodeToC
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_code;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_code, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      String i_fileNamePrefix;
      SimCode.SimCode i_sc;
      Tpl.Text txt_3;
      String ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_res;

    case ( txt,
           (i_sc as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = _)), fileNamePrefix = i_fileNamePrefix)),
           a_withOperations )
      equation
        l_res = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("data->modelData.modelDataXml.infoXMLData = \""));
        txt_1 = dumpSimCodeBase(Tpl.emptyTxt, i_sc, a_withOperations);
        ret_2 = Util.escapeModelicaStringToCString(Tpl.textString(txt_1));
        l_res = Tpl.writeStr(l_res, ret_2);
        l_res = Tpl.writeTok(l_res, Tpl.ST_STRING("\";"));
        txt_3 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("_info.c"));
        Tpl.textFile(l_res, Tpl.textString(txt_3));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSimCodeToC;

protected function lm_34
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        txt = printExpStrEscaped(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp>"));
        txt = Tpl.nextIter(txt);
        txt = lm_34(txt, rest);
      then txt;
  end match;
end lm_34;

protected function fun_35
  input Tpl.Text in_txt;
  input SimCode.Function in_a_func;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_func)
    local
      Tpl.Text txt;
      Absyn.Info i_info;
      Absyn.Path i_name;
      String ret_9;
      Tpl.Text txt_8;
      String ret_7;
      Tpl.Text txt_6;
      String ret_5;
      Tpl.Text txt_4;
      String ret_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_2 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_3 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_2));
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.KERNEL_FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_4 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_5 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_4));
        txt = Tpl.writeStr(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.PARALLEL_FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_6 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_7 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_6));
        txt = Tpl.writeStr(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_8 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_9 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_8));
        txt = Tpl.writeStr(txt, ret_9);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_35;

protected function lm_36
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_func;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_func :: rest )
      equation
        txt = fun_35(txt, i_func);
        txt = Tpl.nextIter(txt);
        txt = lm_36(txt, rest);
      then txt;
  end match;
end lm_36;

public function dumpSimCodeBase
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_code;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_code, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      list<SimCode.Function> i_mi_functions;
      list<DAE.Exp> i_literals;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.SimEqSystem> i_algorithmAndEquationAsserts;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_startValueEquations;
      list<SimCode.SimEqSystem> i_inlineEquations;
      list<SimCode.SimEqSystem> i_residualEquations;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<SimCode.SimVar> i_vars_constVars;
      list<SimCode.SimVar> i_vars_extObjVars;
      list<SimCode.SimVar> i_vars_stringAliasVars;
      list<SimCode.SimVar> i_vars_stringParamVars;
      list<SimCode.SimVar> i_vars_stringAlgVars;
      list<SimCode.SimVar> i_vars_boolParamVars;
      list<SimCode.SimVar> i_vars_intParamVars;
      list<SimCode.SimVar> i_vars_paramVars;
      list<SimCode.SimVar> i_vars_boolAliasVars;
      list<SimCode.SimVar> i_vars_intAliasVars;
      list<SimCode.SimVar> i_vars_aliasVars;
      list<SimCode.SimVar> i_vars_outputVars;
      list<SimCode.SimVar> i_vars_inputVars;
      list<SimCode.SimVar> i_vars_boolAlgVars;
      list<SimCode.SimVar> i_vars_intAlgVars;
      list<SimCode.SimVar> i_vars_algVars;
      list<SimCode.SimVar> i_vars_derivativeVars;
      list<SimCode.SimVar> i_vars_stateVars;
      Absyn.Path i_mi_name;
      list<SimCode.SimEqSystem> ret_11;
      list<SimCode.SimEqSystem> ret_10;
      list<SimCode.SimEqSystem> ret_9;
      list<SimCode.SimEqSystem> ret_8;
      list<SimCode.SimEqSystem> ret_7;
      list<SimCode.SimEqSystem> ret_6;
      list<SimCode.SimEqSystem> ret_5;
      list<SimCode.SimEqSystem> ret_4;
      list<SimCode.SimEqSystem> ret_3;
      String ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, inputVars = i_vars_inputVars, outputVars = i_vars_outputVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, extObjVars = i_vars_extObjVars, constVars = i_vars_constVars), name = i_mi_name, functions = i_mi_functions), jacobianMatrixes = i_jacobianMatrixes, residualEquations = i_residualEquations, inlineEquations = i_inlineEquations, startValueEquations = i_startValueEquations, parameterEquations = i_parameterEquations, initialEquations = i_initialEquations, algorithmAndEquationAsserts = i_algorithmAndEquationAsserts, allEquations = i_allEquations, literals = i_literals),
           a_withOperations )
      equation
        txt_1 = CodegenUtil.dotPath(Tpl.emptyTxt, i_mi_name);
        ret_2 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_1));
        l_name = Tpl.writeStr(Tpl.emptyTxt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n",
                                    "<?xml-stylesheet type=\"application/xml\" href=\"simcodedump.xsl\"?>\n",
                                    "<simcodedump model=\""
                                }, false));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "<variables>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpVars(txt, i_vars_stateVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_derivativeVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_algVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_intAlgVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_boolAlgVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_inputVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_outputVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_aliasVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_intAliasVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_boolAliasVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_paramVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_intParamVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_boolParamVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_stringAlgVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_stringParamVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_stringAliasVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_extObjVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_constVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</variables>\n",
                                    "<equations>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_3 = SimCodeUtil.collectAllJacobianEquations(i_jacobianMatrixes);
        ret_4 = listAppend(i_algorithmAndEquationAsserts, i_allEquations);
        ret_5 = listAppend(i_initialEquations, ret_4);
        ret_6 = listAppend(i_parameterEquations, ret_5);
        ret_7 = listAppend(i_startValueEquations, ret_6);
        ret_8 = listAppend(i_inlineEquations, ret_7);
        ret_9 = listAppend(i_residualEquations, ret_8);
        ret_10 = listAppend(ret_3, ret_9);
        ret_11 = SimCodeUtil.sortEqSystems(ret_10);
        txt = dumpEqs(txt, ret_11, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</equations>\n",
                                    "<literals>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_34(txt, i_literals);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</literals>\n",
                                    "<functions>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_36(txt, i_mi_functions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</functions>\n",
                                    "</simcodedump>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSimCodeBase;

protected function lm_38
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Integer x_index0;
      DAE.ComponentRef i_v_name;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_v_name) :: rest )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": "));
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_v_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.nextIter(txt);
        txt = lm_38(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_38(txt, rest);
      then txt;
  end match;
end lm_38;

public function dumpVarsShort
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_vars;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varsString;
algorithm
  l_varsString := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_varsString := lm_38(l_varsString, a_vars);
  l_varsString := Tpl.popIter(l_varsString);
  out_txt := Tpl.writeText(txt, l_varsString);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end dumpVarsShort;

protected function lm_40
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      Boolean a_withOperations;
      DAE.ElementSource i_v_source;
      SimCode.AliasVariable i_v_aliasvar;
      String i_v_comment;
      DAE.ComponentRef i_v_name;
      String ret_5;
      String ret_4;
      Tpl.Text txt_3;
      String ret_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_v_name, comment = i_v_comment, aliasvar = i_v_aliasvar, source = i_v_source) :: rest,
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<variable name=\""));
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_v_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" comment=\""));
        ret_2 = Util.escapeModelicaStringToXmlString(i_v_comment);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpAlias(txt, i_v_aliasvar);
        txt = Tpl.softNewLine(txt);
        txt = dumpElementSource(txt, i_v_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</variable>"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "<variable name=\"$PRE._"
                                }, false));
        txt_3 = CodegenUtil.crefStr(Tpl.emptyTxt, i_v_name);
        ret_4 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_3));
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" comment=\""));
        ret_5 = Util.escapeModelicaStringToXmlString(i_v_comment);
        txt = Tpl.writeStr(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpAlias(txt, i_v_aliasvar);
        txt = Tpl.softNewLine(txt);
        txt = dumpElementSource(txt, i_v_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</variable>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = lm_40(txt, rest, a_withOperations);
      then txt;

    case ( txt,
           _ :: rest,
           a_withOperations )
      equation
        txt = lm_40(txt, rest, a_withOperations);
      then txt;
  end match;
end lm_40;

public function dumpVars
  input Tpl.Text txt;
  input list<SimCode.SimVar> a_vars;
  input Boolean a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_40(txt, a_vars, a_withOperations);
end dumpVars;

public function dumpAlias
  input Tpl.Text in_txt;
  input SimCode.AliasVariable in_a_alias;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_alias)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_varName;
      String ret_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.ALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<alias>"));
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</alias>"));
      then txt;

    case ( txt,
           SimCode.NEGATEDALIAS(varName = i_varName) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<alias negated=\"true\">"));
        txt_2 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_3 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_2));
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</alias>"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAlias;

public function eqIndex
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      Integer i_index;

    case ( txt,
           SimCode.SES_RESIDUAL(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_MIXED(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_WHEN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_IFEQUATION(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("SimCodeDump.tpl", 130, 16), "dumpEqs: Unknown equation");
      then txt;
  end match;
end eqIndex;

protected function lm_44
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_stmt;
      String ret_1;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_stmt :: rest )
      equation
        ret_0 = DAEDump.ppStmtStr(i_stmt, 2);
        ret_1 = Util.escapeModelicaStringToXmlString(ret_0);
        txt = Tpl.writeStr(txt, ret_1);
        txt = lm_44(txt, rest);
      then txt;
  end match;
end lm_44;

protected function lm_45
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<var name=\""));
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_45(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_45(txt, rest);
      then txt;
  end match;
end lm_45;

protected function lm_46
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cell>"));
        txt = printExpStrEscaped(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cell>"));
        txt = Tpl.nextIter(txt);
        txt = lm_46(txt, rest);
      then txt;
  end match;
end lm_46;

protected function fun_47
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      DAE.ElementSource i_e_source;
      DAE.Exp i_e_exp;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_e_exp, source = i_e_source),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<residual>"));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</residual>\n"));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_47;

protected function lm_48
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      Boolean a_withOperations;
      SimCode.SimEqSystem i_eq;
      Integer i_i2;
      Integer i_i1;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_i1, i_i2, i_eq) :: rest,
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cell row=\""));
        txt = Tpl.writeStr(txt, intString(i_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" col=\""));
        txt = Tpl.writeStr(txt, intString(i_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fun_47(txt, i_eq, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cell>"));
        txt = lm_48(txt, rest, a_withOperations);
      then txt;
  end match;
end lm_48;

protected function lm_49
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<var name=\""));
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest);
      then txt;
  end match;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<eq index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<var name=\""));
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<discrete index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = lm_52(txt, rest);
      then txt;
  end match;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cond;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cond :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cond>"));
        txt = CodegenUtil.crefStr(txt, i_cond);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cond>"));
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;
  end match;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> in_items;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> rest;
      Boolean a_withOperations;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (_, i_eqs) :: rest,
           a_withOperations )
      equation
        txt = dumpEqs(txt, i_eqs, a_withOperations);
        txt = lm_54(txt, rest, a_withOperations);
      then txt;
  end match;
end lm_54;

protected function fun_55
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      list<SimCode.SimEqSystem> i_elsebranch;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> i_ifbranches;
      DAE.Exp i_e_right;
      DAE.ComponentRef i_e_left;
      list<DAE.ComponentRef> i_conditions;
      list<SimCode.SimVar> i_e_discVars;
      list<SimCode.SimEqSystem> i_e_discEqs;
      SimCode.SimEqSystem i_e_cont;
      list<DAE.ComponentRef> i_e_crefs;
      Integer i_indexNonLinearSystem;
      list<SimCode.SimEqSystem> i_e_eqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<DAE.Exp> i_beqs;
      list<SimCode.SimVar> i_e_vars;
      DAE.Statement i_first;
      list<DAE.Statement> i_e_statements;
      DAE.ComponentRef i_e_componentRef;
      DAE.ComponentRef i_e_cref;
      DAE.ElementSource i_e_source;
      DAE.Exp i_e_exp;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_elsebr;
      Tpl.Text l_branches;
      list<SimCode.SimEqSystem> ret_2;
      list<SimCode.SimEqSystem> ret_1;
      DAE.ElementSource ret_0;

    case ( txt,
           (i_e as SimCode.SES_RESIDUAL(exp = i_e_exp, source = i_e_source)),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<residual>"));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</residual>\n"));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = i_e_cref, exp = i_e_exp, source = i_e_source)),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <assign>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStr(txt, i_e_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = i_e_componentRef, exp = i_e_exp, source = i_e_source)),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <assign type=\"array\">\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStr(txt, i_e_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("empty algorithm"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = (i_e_statements as i_first :: _))),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <statement>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = lm_44(txt, i_e_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </statement>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_0 = Algorithm.getStatementSource(i_first);
        txt = dumpElementSource(txt, ret_0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_LINEAR(vars = i_e_vars, beqs = i_beqs, simJac = i_simJac)),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <linear>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_45(txt, i_e_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<row>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_46(txt, i_beqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</row>\n",
                                    "<matrix>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = lm_48(txt, i_simJac, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</matrix>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </linear>\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(eqs = i_e_eqs, indexNonLinearSystem = i_indexNonLinearSystem, crefs = i_e_crefs)),
           a_withOperations )
      equation
        ret_1 = SimCodeUtil.sortEqSystems(i_e_eqs);
        txt = dumpEqs(txt, ret_1, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<nonlinear indexNonlinear=\""));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_49(txt, i_e_crefs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_50(txt, i_e_eqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</nonlinear>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_MIXED(cont = i_e_cont, discEqs = i_e_discEqs, discVars = i_e_discVars)),
           a_withOperations )
      equation
        ret_2 = List.fill(i_e_cont, 1);
        txt = dumpEqs(txt, ret_2, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpEqs(txt, i_e_discEqs, a_withOperations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "<equation index=\""
                                }, false));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <mixed>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<continuous index=\""));
        txt = eqIndex(txt, i_e_cont);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_51(txt, i_e_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = lm_52(txt, i_e_discEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </mixed>\n",
                                    "</equation>"
                                }, false));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_WHEN(conditions = i_conditions, left = i_e_left, right = i_e_right, source = i_e_source)),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "<when>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_53(txt, i_conditions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStr(txt, i_e_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e_right);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</when>\n"));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_IFEQUATION(ifbranches = i_ifbranches, elsebranch = i_elsebranch, source = i_e_source)),
           a_withOperations )
      equation
        l_branches = lm_54(Tpl.emptyTxt, i_ifbranches, a_withOperations);
        l_elsebr = dumpEqs(Tpl.emptyTxt, i_elsebranch, a_withOperations);
        txt = Tpl.writeText(txt, l_branches);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_elsebr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "<ifequation /> <!-- TODO: Fix me -->\n"
                                }, true));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("SimCodeDump.tpl", 243, 16), "dumpEqs: Unknown equation");
      then txt;
  end match;
end fun_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_withOperations;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_withOperations )
      equation
        txt = fun_55(txt, i_eq, a_withOperations);
        txt = lm_56(txt, rest, a_withOperations);
      then txt;
  end match;
end lm_56;

public function dumpEqs
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_eqs;
  input Boolean a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_56(txt, a_eqs, a_withOperations);
end dumpEqs;

public function dumpWithin
  input Tpl.Text in_txt;
  input Absyn.Within in_a_w;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_w)
    local
      Tpl.Text txt;
      Absyn.Path i_path;

    case ( txt,
           Absyn.TOP() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("within ;"));
      then txt;

    case ( txt,
           Absyn.WITHIN(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("within "));
        txt = CodegenUtil.dotPath(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWithin;

protected function lm_59
  input Tpl.Text in_txt;
  input list<Absyn.Within> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Within> rest;
      Absyn.Within i_w;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_w :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<part-of>"));
        txt = dumpWithin(txt, i_w);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</part-of>"));
        txt = lm_59(txt, rest);
      then txt;
  end match;
end lm_59;

protected function lm_60
  input Tpl.Text in_txt;
  input list<Option<DAE.ComponentRef>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Option<DAE.ComponentRef>> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SOME(i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<instance>"));
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</instance>"));
        txt = lm_60(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_60(txt, rest);
      then txt;
  end match;
end lm_60;

protected function lm_61
  input Tpl.Text in_txt;
  input list<Option<tuple<DAE.ComponentRef, DAE.ComponentRef>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Option<tuple<DAE.ComponentRef, DAE.ComponentRef>>> rest;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<connect-equation />"));
        txt = lm_61(txt, rest);
      then txt;
  end match;
end lm_61;

protected function lm_62
  input Tpl.Text in_txt;
  input list<Absyn.Path> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Path> rest;
      Absyn.Path i_p;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_p :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<type>"));
        txt = CodegenUtil.dotPath(txt, i_p);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</type>"));
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;
  end match;
end lm_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<DAE.SymbolicOperation> in_items;
  input Absyn.Info in_a_s_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_s_info)
    local
      Tpl.Text txt;
      list<DAE.SymbolicOperation> rest;
      Absyn.Info a_s_info;
      DAE.SymbolicOperation i_op;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_op :: rest,
           a_s_info )
      equation
        txt = dumpOperation(txt, i_op, a_s_info);
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest, a_s_info);
      then txt;
  end match;
end lm_63;

protected function fun_64
  input Tpl.Text in_txt;
  input Boolean in_a_withOperations;
  input Absyn.Info in_a_s_info;
  input list<DAE.SymbolicOperation> in_a_s_operations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_withOperations, in_a_s_info, in_a_s_operations)
    local
      Tpl.Text txt;
      Absyn.Info a_s_info;
      list<DAE.SymbolicOperation> a_s_operations;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_s_info,
           a_s_operations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<operations>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_63(txt, a_s_operations, a_s_info);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</operations>"));
      then txt;
  end match;
end fun_64;

public function dumpElementSource
  input Tpl.Text in_txt;
  input DAE.ElementSource in_a_source;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_source, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      Absyn.Info i_s_info;
      list<DAE.SymbolicOperation> i_s_operations;
      list<Absyn.Path> i_s_typeLst;
      list<Option<tuple<DAE.ComponentRef, DAE.ComponentRef>>> i_s_connectEquationOptLst;
      list<Option<DAE.ComponentRef>> i_s_instanceOptLst;
      list<Absyn.Within> i_s_partOfLst;
      Absyn.Info i_info;

    case ( txt,
           DAE.SOURCE(info = (i_info as (i_s_info as Absyn.INFO(fileName = _))), partOfLst = i_s_partOfLst, instanceOptLst = i_s_instanceOptLst, connectEquationOptLst = i_s_connectEquationOptLst, typeLst = i_s_typeLst, operations = i_s_operations),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<source>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.softNewLine(txt);
        txt = lm_59(txt, i_s_partOfLst);
        txt = Tpl.softNewLine(txt);
        txt = lm_60(txt, i_s_instanceOptLst);
        txt = Tpl.softNewLine(txt);
        txt = lm_61(txt, i_s_connectEquationOptLst);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_62(txt, i_s_typeLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</source>\n"));
        txt = fun_64(txt, a_withOperations, i_s_info, i_s_operations);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpElementSource;

protected function lm_66
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_target;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_target :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        txt = printExpStrEscaped(txt, i_target);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp>"));
        txt = Tpl.nextIter(txt);
        txt = lm_66(txt, rest);
      then txt;
  end match;
end lm_66;

protected function lm_67
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = CodegenUtil.crefStr(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest);
      then txt;
  end match;
end lm_67;

protected function lm_68
  input Tpl.Text in_txt;
  input list<Real> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Real> rest;
      Real i_r;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_r :: rest )
      equation
        txt = Tpl.writeStr(txt, realString(i_r));
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest);
      then txt;
  end match;
end lm_68;

protected function lm_69
  input Tpl.Text in_txt;
  input list<Real> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Real> rest;
      Real i_r;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_r :: rest )
      equation
        txt = Tpl.writeStr(txt, realString(i_r));
        txt = Tpl.nextIter(txt);
        txt = lm_69(txt, rest);
      then txt;
  end match;
end lm_69;

protected function lm_70
  input Tpl.Text in_txt;
  input list<list<Real>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Real>> rest;
      list<Real> i_row;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_row :: rest )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_69(txt, i_row);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_70(txt, rest);
      then txt;
  end match;
end lm_70;

protected function lm_71
  input Tpl.Text in_txt;
  input list<Real> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Real> rest;
      Real i_r;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_r :: rest )
      equation
        txt = Tpl.writeStr(txt, realString(i_r));
        txt = Tpl.nextIter(txt);
        txt = lm_71(txt, rest);
      then txt;
  end match;
end lm_71;

protected function lm_72
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_cond;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cond :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<assertion>"));
        txt = printExpStrEscaped(txt, i_cond);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</assertion>"));
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;
  end match;
end lm_72;

protected function lm_73
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<candidate>"));
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</candidate>"));
        txt = Tpl.nextIter(txt);
        txt = lm_73(txt, rest);
      then txt;
  end match;
end lm_73;

public function dumpOperation
  input Tpl.Text in_txt;
  input DAE.SymbolicOperation in_a_op;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op, in_a_info)
    local
      Tpl.Text txt;
      Absyn.Info a_info;
      list<DAE.ComponentRef> i_op_candidates;
      DAE.ComponentRef i_op_chosen;
      DAE.Exp i_e;
      DAE.Exp i_e2;
      DAE.Exp i_e1;
      DAE.Exp i_op_after_1;
      DAE.Exp i_op_before_1;
      list<DAE.Exp> i_op_assertConds;
      DAE.Exp i_op_res;
      DAE.Exp i_op_exp2;
      DAE.Exp i_op_exp1;
      list<Real> i_rhs;
      list<list<Real>> i_jac;
      list<Real> i_result;
      list<DAE.ComponentRef> i_vars;
      DAE.Exp i_op_exp;
      DAE.ComponentRef i_op_cr;
      Integer i_op_index;
      DAE.EquationExp i_op_after;
      DAE.EquationExp i_op_before;
      list<DAE.Exp> i_substitutions;
      DAE.Exp i_source;
      DAE.EquationExp i_after;
      DAE.EquationExp i_before;
      list<DAE.Exp> ret_0;

    case ( txt,
           DAE.SIMPLIFY(before = i_before, after = i_after),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<simplify>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printEquationExpStrEscaped(txt, i_before);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</before>\n",
                                    "<after>"
                                }, false));
        txt = printEquationExpStrEscaped(txt, i_after);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</after>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</simplify>"));
      then txt;

    case ( txt,
           DAE.SUBSTITUTION(source = i_source, substitutions = i_substitutions),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<substitution>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printExpStrEscaped(txt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</before>\n"));
        ret_0 = listReverse(i_substitutions);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_66(txt, ret_0);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</substitution>"));
      then txt;

    case ( txt,
           DAE.OP_INLINE(before = i_op_before, after = i_op_after),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<inline>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printEquationExpStrEscaped(txt, i_op_before);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</before>\n",
                                    "<after>"
                                }, false));
        txt = printEquationExpStrEscaped(txt, i_op_after);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</after>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</inline>"));
      then txt;

    case ( txt,
           DAE.OP_SCALARIZE(index = i_op_index, before = i_op_before, after = i_op_after),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<scalarize index=\""));
        txt = Tpl.writeStr(txt, intString(i_op_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printEquationExpStrEscaped(txt, i_op_before);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</before>\n",
                                    "<after>"
                                }, false));
        txt = printEquationExpStrEscaped(txt, i_op_after);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</after>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</scalarize>"));
      then txt;

    case ( txt,
           DAE.SOLVED(cr = i_op_cr, exp = i_op_exp),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<solved>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStr(txt, i_op_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</solved>"));
      then txt;

    case ( txt,
           DAE.LINEAR_SOLVED(vars = i_vars, result = i_result, jac = i_jac, rhs = i_rhs),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<linear-solved>\n",
                                    "  simple equation from linear system:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_67(txt, i_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = ["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_68(txt, i_result);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "[\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_70(txt, i_jac);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  *\n",
                                    "    X\n",
                                    "  =\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_71(txt, i_rhs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</linear-solved>"));
      then txt;

    case ( txt,
           DAE.SOLVE(exp1 = i_op_exp1, exp2 = i_op_exp2, cr = i_op_cr, res = i_op_res, assertConds = i_op_assertConds),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<solve>\n",
                                    "  <old>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = printExpStrEscaped(txt, i_op_exp1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_exp2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </old>\n",
                                    "  <new>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStr(txt, i_op_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_res);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </new>\n",
                                    "  <assertions>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_72(txt, i_op_assertConds);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </assertions>\n",
                                    "</solve>"
                                }, false));
      then txt;

    case ( txt,
           DAE.OP_DIFFERENTIATE(before = i_op_before_1, cr = i_op_cr, after = i_op_after_1),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<derivative>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        txt = printExpStrEscaped(txt, i_op_before_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</exp>\n",
                                    "<with-respect-to>"
                                }, false));
        txt = CodegenUtil.crefStr(txt, i_op_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</with-respect-to>\n",
                                    "<result>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_after_1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</result>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</derivative>"));
      then txt;

    case ( txt,
           DAE.OP_RESIDUAL(e1 = i_e1, e2 = i_e2, e = i_e),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<op-residual>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = printExpStrEscaped(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</rhs>\n",
                                    "<result>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</result>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</op-residual>"));
      then txt;

    case ( txt,
           DAE.NEW_DUMMY_DER(chosen = i_op_chosen, candidates = i_op_candidates),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<dummyderivative>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<chosen>"));
        txt = CodegenUtil.crefStr(txt, i_op_chosen);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</chosen>\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_73(txt, i_op_candidates);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\'\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</dummyderivative>"));
      then txt;

    case ( txt,
           _,
           a_info )
      equation
        Tpl.addSourceTemplateError("Unknown operation", a_info);
      then txt;
  end match;
end dumpOperation;

public function dumpInfo
  input Tpl.Text in_txt;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_info)
    local
      Tpl.Text txt;
      Integer i_info_columnNumberEnd;
      Integer i_info_columnNumberStart;
      Integer i_info_lineNumberEnd;
      Integer i_info_lineNumberStart;
      String i_info_fileName;
      String ret_0;

    case ( txt,
           Absyn.INFO(fileName = i_info_fileName, lineNumberStart = i_info_lineNumberStart, lineNumberEnd = i_info_lineNumberEnd, columnNumberStart = i_info_columnNumberStart, columnNumberEnd = i_info_columnNumberEnd) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<info file=\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_info_fileName);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" lineStart=\""));
        txt = Tpl.writeStr(txt, intString(i_info_lineNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" lineEnd=\""));
        txt = Tpl.writeStr(txt, intString(i_info_lineNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" colStart=\""));
        txt = Tpl.writeStr(txt, intString(i_info_columnNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" colEnd=\""));
        txt = Tpl.writeStr(txt, intString(i_info_columnNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInfo;

public function printExpStrEscaped
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  ret_0 := ExpressionDump.printExpStr(a_exp);
  ret_1 := Util.escapeModelicaStringToXmlString(ret_0);
  out_txt := Tpl.writeStr(txt, ret_1);
end printExpStrEscaped;

public function printEquationExpStrEscaped
  input Tpl.Text in_txt;
  input DAE.EquationExp in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      DAE.Exp i_rhs;
      DAE.Exp i_lhs;
      DAE.Exp i_exp;

    case ( txt,
           DAE.PARTIAL_EQUATION(exp = i_exp) )
      equation
        txt = printExpStrEscaped(txt, i_exp);
      then txt;

    case ( txt,
           DAE.RESIDUAL_EXP(exp = i_exp) )
      equation
        txt = printExpStrEscaped(txt, i_exp);
      then txt;

    case ( txt,
           DAE.EQUALITY_EXPS(lhs = i_lhs, rhs = i_rhs) )
      equation
        txt = printExpStrEscaped(txt, i_lhs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = printExpStrEscaped(txt, i_rhs);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end printEquationExpStrEscaped;

protected function lm_78
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_stmt;
      String ret_1;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_stmt :: rest )
      equation
        ret_0 = DAEDump.ppStmtStr(i_stmt, 2);
        ret_1 = Util.escapeModelicaStringToXmlString(ret_0);
        txt = Tpl.writeStr(txt, ret_1);
        txt = lm_78(txt, rest);
      then txt;
  end match;
end lm_78;

protected function lm_79
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_cr) :: rest )
      equation
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.nextIter(txt);
        txt = lm_79(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_79(txt, rest);
      then txt;
  end match;
end lm_79;

protected function lm_80
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = printExpStrEscaped(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest);
      then txt;
  end match;
end lm_80;

protected function lm_81
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = eqIndex(txt, i_eq);
        txt = Tpl.nextIter(txt);
        txt = lm_81(txt, rest);
      then txt;
  end match;
end lm_81;

protected function lm_82
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<var name=\""));
        txt = CodegenUtil.crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_82(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_82(txt, rest);
      then txt;
  end match;
end lm_82;

protected function lm_83
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<discrete index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = lm_83(txt, rest);
      then txt;
  end match;
end lm_83;

protected function lm_84
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cond;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cond :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cond>"));
        txt = CodegenUtil.crefStr(txt, i_cond);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cond>"));
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest);
      then txt;
  end match;
end lm_84;

protected function lm_85
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> in_items;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> rest;
      Boolean a_withOperations;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (_, i_eqs) :: rest,
           a_withOperations )
      equation
        txt = dumpEqsSys(txt, i_eqs, a_withOperations);
        txt = lm_85(txt, rest, a_withOperations);
      then txt;
  end match;
end lm_85;

protected function fun_86
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      list<SimCode.SimEqSystem> i_elsebranch;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> i_ifbranches;
      DAE.Exp i_e_right;
      DAE.ComponentRef i_e_left;
      list<DAE.ComponentRef> i_conditions;
      list<SimCode.SimVar> i_e_discVars;
      list<SimCode.SimEqSystem> i_e_discEqs;
      SimCode.SimEqSystem i_e_cont;
      list<SimCode.SimEqSystem> i_e_eqs;
      list<DAE.Exp> i_beqs;
      list<SimCode.SimVar> i_e_vars;
      list<DAE.Statement> i_e_statements;
      DAE.ComponentRef i_e_componentRef;
      DAE.ComponentRef i_e_cref;
      DAE.Exp i_e_exp;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_elsebr;
      Tpl.Text l_branches;
      list<SimCode.SimEqSystem> ret_2;
      list<SimCode.SimEqSystem> ret_1;
      String ret_0;

    case ( txt,
           (i_e as SimCode.SES_RESIDUAL(exp = i_e_exp)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<residual>"));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</residual>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = i_e_cref, exp = i_e_exp)),
           _ )
      equation
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" simple_assign "));
        txt = CodegenUtil.crefStr(txt, i_e_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        ret_0 = ExpressionDump.printCrefsFromExpStr(i_e_exp);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = i_e_componentRef, exp = i_e_exp)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <assign type=\"array\">\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStr(txt, i_e_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </assign>\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("empty algorithm"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = (i_e_statements as _ :: _))),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <statement>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = lm_78(txt, i_e_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </statement>\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_LINEAR(vars = i_e_vars, beqs = i_beqs)),
           _ )
      equation
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" linear "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_79(txt, i_e_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_80(txt, i_beqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(eqs = i_e_eqs)),
           a_withOperations )
      equation
        ret_1 = SimCodeUtil.sortEqSystems(i_e_eqs);
        txt = dumpEqsSys(txt, ret_1, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" non_linear "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_81(txt, i_e_eqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_MIXED(cont = i_e_cont, discEqs = i_e_discEqs, discVars = i_e_discVars)),
           a_withOperations )
      equation
        ret_2 = List.fill(i_e_cont, 1);
        txt = dumpEqs(txt, ret_2, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpEqs(txt, i_e_discEqs, a_withOperations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "<equation index=\""
                                }, false));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <mixed>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<continuous index=\""));
        txt = eqIndex(txt, i_e_cont);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_82(txt, i_e_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = lm_83(txt, i_e_discEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </mixed>\n",
                                    "</equation>"
                                }, false));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_WHEN(conditions = i_conditions, left = i_e_left, right = i_e_right)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "<when>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_84(txt, i_conditions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStr(txt, i_e_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e_right);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</when>\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_IFEQUATION(ifbranches = i_ifbranches, elsebranch = i_elsebranch)),
           a_withOperations )
      equation
        l_branches = lm_85(Tpl.emptyTxt, i_ifbranches, a_withOperations);
        l_elsebr = dumpEqsSys(Tpl.emptyTxt, i_elsebranch, a_withOperations);
        txt = Tpl.writeText(txt, l_branches);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_elsebr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "<ifequation /> <!-- TODO: Fix me -->\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("SimCodeDump.tpl", 469, 16), "dumpEqs: Unknown equation");
      then txt;
  end match;
end fun_86;

protected function lm_87
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_withOperations;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_withOperations )
      equation
        txt = fun_86(txt, i_eq, a_withOperations);
        txt = lm_87(txt, rest, a_withOperations);
      then txt;
  end match;
end lm_87;

public function dumpEqsSys
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_eqs;
  input Boolean a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_87(txt, a_eqs, a_withOperations);
end dumpEqsSys;

end SimCodeDump;