#ifndef System__H
#define System__H
#define __OPENMODELICA__METAMODELICA
#include "meta_modelica.h"

#include "modelica.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct System_trim_rettype_s {
  modelica_metatype c1; /* outString */
} System_trim_rettype;
DLLExport
System_trim_rettype omc_System_trim(threadData_t *threadData, modelica_metatype _inString, modelica_metatype _charsToRemove);
#define boxptr_System_trim omc_System_trim

extern const char* System_trim(const char* /*_inString*/, const char* /*_charsToRemove*/);
typedef struct System_trimWhitespace_rettype_s {
  modelica_metatype c1; /* outString */
} System_trimWhitespace_rettype;
DLLExport
System_trimWhitespace_rettype omc_System_trimWhitespace(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_trimWhitespace omc_System_trimWhitespace

extern const char* System_trimWhitespace(const char* /*_inString*/);
typedef struct System_trimChar_rettype_s {
  modelica_metatype c1; /* outString */
} System_trimChar_rettype;
DLLExport
System_trimChar_rettype omc_System_trimChar(threadData_t *threadData, modelica_metatype _inString1, modelica_metatype _inString2);
#define boxptr_System_trimChar omc_System_trimChar

extern const char* System_trimChar(const char* /*_inString1*/, const char* /*_inString2*/);
typedef struct System_strcmp_rettype_s {
  modelica_integer c1; /* outInteger */
} System_strcmp_rettype;
DLLExport
System_strcmp_rettype omc_System_strcmp(threadData_t *threadData, modelica_metatype _inString1, modelica_metatype _inString2);
typedef struct System_strcmp_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
} System_strcmp_rettypeboxed;
DLLExport
System_strcmp_rettypeboxed boxptr_System_strcmp(threadData_t *threadData, modelica_metatype _inString1, modelica_metatype _inString2);

extern int System_strcmp(const char* /*_inString1*/, const char* /*_inString2*/);
typedef struct System_stringFind_rettype_s {
  modelica_integer c1; /* outInteger */
} System_stringFind_rettype;
DLLExport
System_stringFind_rettype omc_System_stringFind(threadData_t *threadData, modelica_metatype _str, modelica_metatype _searchStr);
typedef struct System_stringFind_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
} System_stringFind_rettypeboxed;
DLLExport
System_stringFind_rettypeboxed boxptr_System_stringFind(threadData_t *threadData, modelica_metatype _str, modelica_metatype _searchStr);

extern int System_stringFind(const char* /*_str*/, const char* /*_searchStr*/);
typedef struct System_stringFindString_rettype_s {
  modelica_metatype c1; /* outString */
} System_stringFindString_rettype;
DLLExport
System_stringFindString_rettype omc_System_stringFindString(threadData_t *threadData, modelica_metatype _str, modelica_metatype _searchStr);
#define boxptr_System_stringFindString omc_System_stringFindString

extern const char* System_stringFindString(const char* /*_str*/, const char* /*_searchStr*/);
typedef struct System_regex_rettype_s {
  modelica_integer c1; /* numMatches */
  modelica_metatype c2; /* strs */
} System_regex_rettype;
DLLExport
System_regex_rettype omc_System_regex(threadData_t *threadData, modelica_metatype _str, modelica_metatype _re, modelica_integer _maxMatches, modelica_boolean _extended, modelica_boolean _sensitive);
typedef struct System_regex_rettypeboxed_s {
  modelica_metatype c1; /* numMatches */
  modelica_metatype c2; /* strs */
} System_regex_rettypeboxed;
DLLExport
System_regex_rettypeboxed boxptr_System_regex(threadData_t *threadData, modelica_metatype _str, modelica_metatype _re, modelica_metatype _maxMatches, modelica_metatype _extended, modelica_metatype _sensitive);

extern modelica_metatype System_regex(const char* /*_str*/, const char* /*_re*/, int /*_maxMatches*/, int /*_extended*/, int /*_sensitive*/, int* /*_numMatches*/);
typedef struct System_strncmp_rettype_s {
  modelica_integer c1; /* outInteger */
} System_strncmp_rettype;
DLLExport
System_strncmp_rettype omc_System_strncmp(threadData_t *threadData, modelica_metatype _inString1, modelica_metatype _inString2, modelica_integer _len);
typedef struct System_strncmp_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
} System_strncmp_rettypeboxed;
DLLExport
System_strncmp_rettypeboxed boxptr_System_strncmp(threadData_t *threadData, modelica_metatype _inString1, modelica_metatype _inString2, modelica_metatype _len);

extern int System_strncmp(const char* /*_inString1*/, const char* /*_inString2*/, int /*_len*/);
typedef struct System_stringReplace_rettype_s {
  modelica_metatype c1; /* res */
} System_stringReplace_rettype;
DLLExport
System_stringReplace_rettype omc_System_stringReplace(threadData_t *threadData, modelica_metatype _str, modelica_metatype _source, modelica_metatype _target);
#define boxptr_System_stringReplace omc_System_stringReplace

extern const char* System_stringReplace(const char* /*_str*/, const char* /*_source*/, const char* /*_target*/);
typedef struct System_toupper_rettype_s {
  modelica_metatype c1; /* outString */
} System_toupper_rettype;
DLLExport
System_toupper_rettype omc_System_toupper(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_toupper omc_System_toupper

extern const char* System_toupper(const char* /*_inString*/);
typedef struct System_tolower_rettype_s {
  modelica_metatype c1; /* outString */
} System_tolower_rettype;
DLLExport
System_tolower_rettype omc_System_tolower(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_tolower omc_System_tolower

extern const char* System_tolower(const char* /*_inString*/);
typedef struct System_strtok_rettype_s {
  modelica_metatype c1; /* strings */
} System_strtok_rettype;
DLLExport
System_strtok_rettype omc_System_strtok(threadData_t *threadData, modelica_metatype _string, modelica_metatype _token);
#define boxptr_System_strtok omc_System_strtok

extern modelica_metatype System_strtok(const char* /*_string*/, const char* /*_token*/);
typedef struct System_substring_rettype_s {
  modelica_metatype c1; /* outString */
} System_substring_rettype;
DLLExport
System_substring_rettype omc_System_substring(threadData_t *threadData, modelica_metatype _inString, modelica_integer _start, modelica_integer _stop);
typedef struct System_substring_rettypeboxed_s {
  modelica_metatype c1; /* outString */
} System_substring_rettypeboxed;
DLLExport
System_substring_rettypeboxed boxptr_System_substring(threadData_t *threadData, modelica_metatype _inString, modelica_metatype _start, modelica_metatype _stop);

extern const char* System_substring(const char* /*_inString*/, int /*_start*/, int /*_stop*/);

DLLExport
void omc_System_setCCompiler(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_setCCompiler omc_System_setCCompiler

extern void SystemImpl__setCCompiler(const char* /*_inString*/);
typedef struct System_getCCompiler_rettype_s {
  modelica_metatype c1; /* outString */
} System_getCCompiler_rettype;
DLLExport
System_getCCompiler_rettype omc_System_getCCompiler(threadData_t *threadData);
#define boxptr_System_getCCompiler omc_System_getCCompiler

extern const char* System_getCCompiler();

DLLExport
void omc_System_setCFlags(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_setCFlags omc_System_setCFlags

extern void SystemImpl__setCFlags(const char* /*_inString*/);
typedef struct System_getCFlags_rettype_s {
  modelica_metatype c1; /* outString */
} System_getCFlags_rettype;
DLLExport
System_getCFlags_rettype omc_System_getCFlags(threadData_t *threadData);
#define boxptr_System_getCFlags omc_System_getCFlags

extern const char* System_getCFlags();

DLLExport
void omc_System_setCXXCompiler(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_setCXXCompiler omc_System_setCXXCompiler

extern void SystemImpl__setCXXCompiler(const char* /*_inString*/);
typedef struct System_getCXXCompiler_rettype_s {
  modelica_metatype c1; /* outString */
} System_getCXXCompiler_rettype;
DLLExport
System_getCXXCompiler_rettype omc_System_getCXXCompiler(threadData_t *threadData);
#define boxptr_System_getCXXCompiler omc_System_getCXXCompiler

extern const char* System_getCXXCompiler();

DLLExport
void omc_System_setLinker(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_setLinker omc_System_setLinker

extern void SystemImpl__setLinker(const char* /*_inString*/);
typedef struct System_getLinker_rettype_s {
  modelica_metatype c1; /* outString */
} System_getLinker_rettype;
DLLExport
System_getLinker_rettype omc_System_getLinker(threadData_t *threadData);
#define boxptr_System_getLinker omc_System_getLinker

extern const char* System_getLinker();

DLLExport
void omc_System_setLDFlags(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_setLDFlags omc_System_setLDFlags

extern void SystemImpl__setLDFlags(const char* /*_inString*/);
typedef struct System_getLDFlags_rettype_s {
  modelica_metatype c1; /* outString */
} System_getLDFlags_rettype;
DLLExport
System_getLDFlags_rettype omc_System_getLDFlags(threadData_t *threadData);
#define boxptr_System_getLDFlags omc_System_getLDFlags

extern const char* System_getLDFlags();
typedef struct System_getMakeCommand_rettype_s {
  modelica_metatype c1; /* outString */
} System_getMakeCommand_rettype;
DLLExport
System_getMakeCommand_rettype omc_System_getMakeCommand(threadData_t *threadData);
#define boxptr_System_getMakeCommand omc_System_getMakeCommand

extern const char* System_getMakeCommand();
typedef struct System_getExeExt_rettype_s {
  modelica_metatype c1; /* outString */
} System_getExeExt_rettype;
DLLExport
System_getExeExt_rettype omc_System_getExeExt(threadData_t *threadData);
#define boxptr_System_getExeExt omc_System_getExeExt

extern const char* System_getExeExt();
typedef struct System_getDllExt_rettype_s {
  modelica_metatype c1; /* outString */
} System_getDllExt_rettype;
DLLExport
System_getDllExt_rettype omc_System_getDllExt(threadData_t *threadData);
#define boxptr_System_getDllExt omc_System_getDllExt

extern const char* System_getDllExt();
typedef struct System_loadLibrary_rettype_s {
  modelica_integer c1; /* outLibHandle */
} System_loadLibrary_rettype;
DLLExport
System_loadLibrary_rettype omc_System_loadLibrary(threadData_t *threadData, modelica_metatype _inLib, modelica_boolean _inPrintDebug);
typedef struct System_loadLibrary_rettypeboxed_s {
  modelica_metatype c1; /* outLibHandle */
} System_loadLibrary_rettypeboxed;
DLLExport
System_loadLibrary_rettypeboxed boxptr_System_loadLibrary(threadData_t *threadData, modelica_metatype _inLib, modelica_metatype _inPrintDebug);

extern int System_loadLibrary(const char* /*_inLib*/, int /*_inPrintDebug*/);
typedef struct System_lookupFunction_rettype_s {
  modelica_integer c1; /* outFuncHandle */
} System_lookupFunction_rettype;
DLLExport
System_lookupFunction_rettype omc_System_lookupFunction(threadData_t *threadData, modelica_integer _inLibHandle, modelica_metatype _inFunc);
typedef struct System_lookupFunction_rettypeboxed_s {
  modelica_metatype c1; /* outFuncHandle */
} System_lookupFunction_rettypeboxed;
DLLExport
System_lookupFunction_rettypeboxed boxptr_System_lookupFunction(threadData_t *threadData, modelica_metatype _inLibHandle, modelica_metatype _inFunc);

extern int System_lookupFunction(int /*_inLibHandle*/, const char* /*_inFunc*/);

DLLExport
void omc_System_freeFunction(threadData_t *threadData, modelica_integer _inFuncHandle, modelica_boolean _inPrintDebug);

DLLExport
void boxptr_System_freeFunction(threadData_t *threadData, modelica_metatype _inFuncHandle, modelica_metatype _inPrintDebug);

extern void System_freeFunction(int /*_inFuncHandle*/, int /*_inPrintDebug*/);

DLLExport
void omc_System_freeLibrary(threadData_t *threadData, modelica_integer _inLibHandle, modelica_boolean _inPrintDebug);

DLLExport
void boxptr_System_freeLibrary(threadData_t *threadData, modelica_metatype _inLibHandle, modelica_metatype _inPrintDebug);

extern void System_freeLibrary(int /*_inLibHandle*/, int /*_inPrintDebug*/);

DLLExport
void omc_System_writeFile(threadData_t *threadData, modelica_metatype _fileNameToWrite, modelica_metatype _stringToBeWritten);
#define boxptr_System_writeFile omc_System_writeFile

extern void System_writeFile(const char* /*_fileNameToWrite*/, const char* /*_stringToBeWritten*/);

DLLExport
void omc_System_appendFile(threadData_t *threadData, modelica_metatype _file, modelica_metatype _data);
#define boxptr_System_appendFile omc_System_appendFile

extern void System_appendFile(const char* /*_file*/, const char* /*_data*/);
typedef struct System_readFile_rettype_s {
  modelica_metatype c1; /* outString */
} System_readFile_rettype;
DLLExport
System_readFile_rettype omc_System_readFile(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_readFile omc_System_readFile

extern const char* System_readFile(const char* /*_inString*/);
typedef struct System_systemCall_rettype_s {
  modelica_integer c1; /* outInteger */
} System_systemCall_rettype;
DLLExport
System_systemCall_rettype omc_System_systemCall(threadData_t *threadData, modelica_metatype _inString);
typedef struct System_systemCall_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
} System_systemCall_rettypeboxed;
DLLExport
System_systemCall_rettypeboxed boxptr_System_systemCall(threadData_t *threadData, modelica_metatype _inString);

extern int SystemImpl__systemCall(const char* /*_inString*/);
typedef struct System_systemCallParallel_rettype_s {
  modelica_metatype c1; /* outIntegers */
} System_systemCallParallel_rettype;
DLLExport
System_systemCallParallel_rettype omc_System_systemCallParallel(threadData_t *threadData, modelica_metatype _inStrings, modelica_integer _numThreads);
typedef struct System_systemCallParallel_rettypeboxed_s {
  modelica_metatype c1; /* outIntegers */
} System_systemCallParallel_rettypeboxed;
DLLExport
System_systemCallParallel_rettypeboxed boxptr_System_systemCallParallel(threadData_t *threadData, modelica_metatype _inStrings, modelica_metatype _numThreads);

extern modelica_metatype SystemImpl__systemCallParallel(modelica_metatype /*_inStrings*/, int /*_numThreads*/);
typedef struct System_spawnCall_rettype_s {
  modelica_integer c1; /* outInteger */
} System_spawnCall_rettype;
DLLExport
System_spawnCall_rettype omc_System_spawnCall(threadData_t *threadData, modelica_metatype _path, modelica_metatype _str);
typedef struct System_spawnCall_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
} System_spawnCall_rettypeboxed;
DLLExport
System_spawnCall_rettypeboxed boxptr_System_spawnCall(threadData_t *threadData, modelica_metatype _path, modelica_metatype _str);

extern int SystemImpl__spawnCall(const char* /*_path*/, const char* /*_str*/);
typedef struct System_cd_rettype_s {
  modelica_integer c1; /* outInteger */
} System_cd_rettype;
DLLExport
System_cd_rettype omc_System_cd(threadData_t *threadData, modelica_metatype _inString);
typedef struct System_cd_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
} System_cd_rettypeboxed;
DLLExport
System_cd_rettypeboxed boxptr_System_cd(threadData_t *threadData, modelica_metatype _inString);

extern int chdir(const char* /*_inString*/);
typedef struct System_createDirectory_rettype_s {
  modelica_boolean c1; /* outBool */
} System_createDirectory_rettype;
DLLExport
System_createDirectory_rettype omc_System_createDirectory(threadData_t *threadData, modelica_metatype _inString);
typedef struct System_createDirectory_rettypeboxed_s {
  modelica_metatype c1; /* outBool */
} System_createDirectory_rettypeboxed;
DLLExport
System_createDirectory_rettypeboxed boxptr_System_createDirectory(threadData_t *threadData, modelica_metatype _inString);

extern int SystemImpl__createDirectory(const char* /*_inString*/);
typedef struct System_pwd_rettype_s {
  modelica_metatype c1; /* outString */
} System_pwd_rettype;
DLLExport
System_pwd_rettype omc_System_pwd(threadData_t *threadData);
#define boxptr_System_pwd omc_System_pwd

extern const char* SystemImpl__pwd();
typedef struct System_readEnv_rettype_s {
  modelica_metatype c1; /* outString */
} System_readEnv_rettype;
DLLExport
System_readEnv_rettype omc_System_readEnv(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_readEnv omc_System_readEnv

extern const char* System_readEnv(const char* /*_inString*/);
typedef struct System_setEnv_rettype_s {
  modelica_integer c1; /* outInteger */
} System_setEnv_rettype;
DLLExport
System_setEnv_rettype omc_System_setEnv(threadData_t *threadData, modelica_metatype _varName, modelica_metatype _value, modelica_boolean _overwrite);
typedef struct System_setEnv_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
} System_setEnv_rettypeboxed;
DLLExport
System_setEnv_rettypeboxed boxptr_System_setEnv(threadData_t *threadData, modelica_metatype _varName, modelica_metatype _value, modelica_metatype _overwrite);

extern int setenv(const char* /*_varName*/, const char* /*_value*/, int /*_overwrite*/);
typedef struct System_subDirectories_rettype_s {
  modelica_metatype c1; /* outStringLst */
} System_subDirectories_rettype;
DLLExport
System_subDirectories_rettype omc_System_subDirectories(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_subDirectories omc_System_subDirectories

extern modelica_metatype System_subDirectories(const char* /*_inString*/);
typedef struct System_moFiles_rettype_s {
  modelica_metatype c1; /* outStringLst */
} System_moFiles_rettype;
DLLExport
System_moFiles_rettype omc_System_moFiles(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_moFiles omc_System_moFiles

extern modelica_metatype System_moFiles(const char* /*_inString*/);
typedef struct System_getLoadModelPath_rettype_s {
  modelica_metatype c1; /* dir */
  modelica_metatype c2; /* name */
  modelica_boolean c3; /* isDir */
} System_getLoadModelPath_rettype;
DLLExport
System_getLoadModelPath_rettype omc_System_getLoadModelPath(threadData_t *threadData, modelica_metatype _className, modelica_metatype _prios, modelica_metatype _mps);
typedef struct System_getLoadModelPath_rettypeboxed_s {
  modelica_metatype c1; /* dir */
  modelica_metatype c2; /* name */
  modelica_metatype c3; /* isDir */
} System_getLoadModelPath_rettypeboxed;
DLLExport
System_getLoadModelPath_rettypeboxed boxptr_System_getLoadModelPath(threadData_t *threadData, modelica_metatype _className, modelica_metatype _prios, modelica_metatype _mps);

extern void System_getLoadModelPath(const char* /*_className*/, modelica_metatype /*_prios*/, modelica_metatype /*_mps*/, const char** /*_dir*/, const char** /*_name*/, int* /*_isDir*/);
typedef struct System_time_rettype_s {
  modelica_real c1; /* outReal */
} System_time_rettype;
DLLExport
System_time_rettype omc_System_time(threadData_t *threadData);
typedef struct System_time_rettypeboxed_s {
  modelica_metatype c1; /* outReal */
} System_time_rettypeboxed;
DLLExport
System_time_rettypeboxed boxptr_System_time(threadData_t *threadData);

extern double SystemImpl__time();
typedef struct System_pathDelimiter_rettype_s {
  modelica_metatype c1; /* outString */
} System_pathDelimiter_rettype;
DLLExport
System_pathDelimiter_rettype omc_System_pathDelimiter(threadData_t *threadData);
#define boxptr_System_pathDelimiter omc_System_pathDelimiter

extern const char* System_pathDelimiter();
typedef struct System_groupDelimiter_rettype_s {
  modelica_metatype c1; /* outString */
} System_groupDelimiter_rettype;
DLLExport
System_groupDelimiter_rettype omc_System_groupDelimiter(threadData_t *threadData);
#define boxptr_System_groupDelimiter omc_System_groupDelimiter

extern const char* System_groupDelimiter();
typedef struct System_regularFileExists_rettype_s {
  modelica_boolean c1; /* outBool */
} System_regularFileExists_rettype;
DLLExport
System_regularFileExists_rettype omc_System_regularFileExists(threadData_t *threadData, modelica_metatype _inString);
typedef struct System_regularFileExists_rettypeboxed_s {
  modelica_metatype c1; /* outBool */
} System_regularFileExists_rettypeboxed;
DLLExport
System_regularFileExists_rettypeboxed boxptr_System_regularFileExists(threadData_t *threadData, modelica_metatype _inString);

extern int SystemImpl__regularFileExists(const char* /*_inString*/);
typedef struct System_removeFile_rettype_s {
  modelica_integer c1; /* res */
} System_removeFile_rettype;
DLLExport
System_removeFile_rettype omc_System_removeFile(threadData_t *threadData, modelica_metatype _fileName);
typedef struct System_removeFile_rettypeboxed_s {
  modelica_metatype c1; /* res */
} System_removeFile_rettypeboxed;
DLLExport
System_removeFile_rettypeboxed boxptr_System_removeFile(threadData_t *threadData, modelica_metatype _fileName);

extern int SystemImpl__removeFile(const char* /*_fileName*/);
typedef struct System_renameFile_rettype_s {
  modelica_integer c1; /* res */
} System_renameFile_rettype;
DLLExport
System_renameFile_rettype omc_System_renameFile(threadData_t *threadData, modelica_metatype _fileName1, modelica_metatype _fileName2);
typedef struct System_renameFile_rettypeboxed_s {
  modelica_metatype c1; /* res */
} System_renameFile_rettypeboxed;
DLLExport
System_renameFile_rettypeboxed boxptr_System_renameFile(threadData_t *threadData, modelica_metatype _fileName1, modelica_metatype _fileName2);

extern int rename(const char* /*_fileName1*/, const char* /*_fileName2*/);
typedef struct System_directoryExists_rettype_s {
  modelica_boolean c1; /* outBool */
} System_directoryExists_rettype;
DLLExport
System_directoryExists_rettype omc_System_directoryExists(threadData_t *threadData, modelica_metatype _inString);
typedef struct System_directoryExists_rettypeboxed_s {
  modelica_metatype c1; /* outBool */
} System_directoryExists_rettypeboxed;
DLLExport
System_directoryExists_rettypeboxed boxptr_System_directoryExists(threadData_t *threadData, modelica_metatype _inString);

extern int SystemImpl__directoryExists(const char* /*_inString*/);
typedef struct System_removeDirectory_rettype_s {
  modelica_boolean c1; /* outBool */
} System_removeDirectory_rettype;
DLLExport
System_removeDirectory_rettype omc_System_removeDirectory(threadData_t *threadData, modelica_metatype _inString);
typedef struct System_removeDirectory_rettypeboxed_s {
  modelica_metatype c1; /* outBool */
} System_removeDirectory_rettypeboxed;
DLLExport
System_removeDirectory_rettypeboxed boxptr_System_removeDirectory(threadData_t *threadData, modelica_metatype _inString);

extern int SystemImpl__removeDirectory(const char* /*_inString*/);
typedef struct System_platform_rettype_s {
  modelica_metatype c1; /* outString */
} System_platform_rettype;
DLLExport
System_platform_rettype omc_System_platform(threadData_t *threadData);
#define boxptr_System_platform omc_System_platform

extern const char* System_platform();
typedef struct System_getClassnamesForSimulation_rettype_s {
  modelica_metatype c1; /* outString */
} System_getClassnamesForSimulation_rettype;
DLLExport
System_getClassnamesForSimulation_rettype omc_System_getClassnamesForSimulation(threadData_t *threadData);
#define boxptr_System_getClassnamesForSimulation omc_System_getClassnamesForSimulation

extern const char* System_getClassnamesForSimulation();

DLLExport
void omc_System_setClassnamesForSimulation(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_setClassnamesForSimulation omc_System_setClassnamesForSimulation

extern void System_setClassnamesForSimulation(const char* /*_inString*/);
typedef struct System_getVariableValue_rettype_s {
  modelica_real c1; /* outValue */
} System_getVariableValue_rettype;
DLLExport
System_getVariableValue_rettype omc_System_getVariableValue(threadData_t *threadData, modelica_real _timeStamp, modelica_metatype _timeValues, modelica_metatype _varValues);
typedef struct System_getVariableValue_rettypeboxed_s {
  modelica_metatype c1; /* outValue */
} System_getVariableValue_rettypeboxed;
DLLExport
System_getVariableValue_rettypeboxed boxptr_System_getVariableValue(threadData_t *threadData, modelica_metatype _timeStamp, modelica_metatype _timeValues, modelica_metatype _varValues);

extern double System_getVariableValue(double /*_timeStamp*/, modelica_metatype /*_timeValues*/, modelica_metatype /*_varValues*/);
typedef struct System_getFileModificationTime_rettype_s {
  modelica_metatype c1; /* outValue */
} System_getFileModificationTime_rettype;
DLLExport
System_getFileModificationTime_rettype omc_System_getFileModificationTime(threadData_t *threadData, modelica_metatype _fileName);
#define boxptr_System_getFileModificationTime omc_System_getFileModificationTime

extern modelica_metatype System_getFileModificationTime(const char* /*_fileName*/);
typedef struct System_getCurrentTime_rettype_s {
  modelica_real c1; /* outValue */
} System_getCurrentTime_rettype;
DLLExport
System_getCurrentTime_rettype omc_System_getCurrentTime(threadData_t *threadData);
typedef struct System_getCurrentTime_rettypeboxed_s {
  modelica_metatype c1; /* outValue */
} System_getCurrentTime_rettypeboxed;
DLLExport
System_getCurrentTime_rettypeboxed boxptr_System_getCurrentTime(threadData_t *threadData);

extern double SystemImpl__getCurrentTime();
typedef struct System_getCurrentDateTime_rettype_s {
  modelica_integer c1; /* sec */
  modelica_integer c2; /* min */
  modelica_integer c3; /* hour */
  modelica_integer c4; /* mday */
  modelica_integer c5; /* mon */
  modelica_integer c6; /* year */
} System_getCurrentDateTime_rettype;
DLLExport
System_getCurrentDateTime_rettype omc_System_getCurrentDateTime(threadData_t *threadData);
typedef struct System_getCurrentDateTime_rettypeboxed_s {
  modelica_metatype c1; /* sec */
  modelica_metatype c2; /* min */
  modelica_metatype c3; /* hour */
  modelica_metatype c4; /* mday */
  modelica_metatype c5; /* mon */
  modelica_metatype c6; /* year */
} System_getCurrentDateTime_rettypeboxed;
DLLExport
System_getCurrentDateTime_rettypeboxed boxptr_System_getCurrentDateTime(threadData_t *threadData);

extern void System_getCurrentDateTime(int* /*_sec*/, int* /*_min*/, int* /*_hour*/, int* /*_mday*/, int* /*_mon*/, int* /*_year*/);
typedef struct System_getCurrentTimeStr_rettype_s {
  modelica_metatype c1; /* timeStr */
} System_getCurrentTimeStr_rettype;
DLLExport
System_getCurrentTimeStr_rettype omc_System_getCurrentTimeStr(threadData_t *threadData);
#define boxptr_System_getCurrentTimeStr omc_System_getCurrentTimeStr

extern const char* System_getCurrentTimeStr();
typedef struct System_os_rettype_s {
  modelica_metatype c1; /* str */
} System_os_rettype;
DLLExport
System_os_rettype omc_System_os(threadData_t *threadData);
#define boxptr_System_os omc_System_os

extern const char* System_os();
typedef struct System_readFileNoNumeric_rettype_s {
  modelica_metatype c1; /* outString */
} System_readFileNoNumeric_rettype;
DLLExport
System_readFileNoNumeric_rettype omc_System_readFileNoNumeric(threadData_t *threadData, modelica_metatype _inString);
#define boxptr_System_readFileNoNumeric omc_System_readFileNoNumeric

extern const char* SystemImpl__readFileNoNumeric(const char* /*_inString*/);

DLLExport
void omc_System_setHasExpandableConnectors(threadData_t *threadData, modelica_boolean _hasExpandable);

DLLExport
void boxptr_System_setHasExpandableConnectors(threadData_t *threadData, modelica_metatype _hasExpandable);

extern void System_setHasExpandableConnectors(int /*_hasExpandable*/);
typedef struct System_getHasExpandableConnectors_rettype_s {
  modelica_boolean c1; /* hasExpandable */
} System_getHasExpandableConnectors_rettype;
DLLExport
System_getHasExpandableConnectors_rettype omc_System_getHasExpandableConnectors(threadData_t *threadData);
typedef struct System_getHasExpandableConnectors_rettypeboxed_s {
  modelica_metatype c1; /* hasExpandable */
} System_getHasExpandableConnectors_rettypeboxed;
DLLExport
System_getHasExpandableConnectors_rettypeboxed boxptr_System_getHasExpandableConnectors(threadData_t *threadData);

extern int System_getHasExpandableConnectors();

DLLExport
void omc_System_setPartialInstantiation(threadData_t *threadData, modelica_boolean _isPartialInstantiation);

DLLExport
void boxptr_System_setPartialInstantiation(threadData_t *threadData, modelica_metatype _isPartialInstantiation);

extern void System_setPartialInstantiation(int /*_isPartialInstantiation*/);
typedef struct System_getPartialInstantiation_rettype_s {
  modelica_boolean c1; /* isPartialInstantiation */
} System_getPartialInstantiation_rettype;
DLLExport
System_getPartialInstantiation_rettype omc_System_getPartialInstantiation(threadData_t *threadData);
typedef struct System_getPartialInstantiation_rettypeboxed_s {
  modelica_metatype c1; /* isPartialInstantiation */
} System_getPartialInstantiation_rettypeboxed;
DLLExport
System_getPartialInstantiation_rettypeboxed boxptr_System_getPartialInstantiation(threadData_t *threadData);

extern int System_getPartialInstantiation();

DLLExport
void omc_System_setHasStreamConnectors(threadData_t *threadData, modelica_boolean _hasStream);

DLLExport
void boxptr_System_setHasStreamConnectors(threadData_t *threadData, modelica_metatype _hasStream);

extern void System_setHasStreamConnectors(int /*_hasStream*/);
typedef struct System_getHasStreamConnectors_rettype_s {
  modelica_boolean c1; /* hasStream */
} System_getHasStreamConnectors_rettype;
DLLExport
System_getHasStreamConnectors_rettype omc_System_getHasStreamConnectors(threadData_t *threadData);
typedef struct System_getHasStreamConnectors_rettypeboxed_s {
  modelica_metatype c1; /* hasStream */
} System_getHasStreamConnectors_rettypeboxed;
DLLExport
System_getHasStreamConnectors_rettypeboxed boxptr_System_getHasStreamConnectors(threadData_t *threadData);

extern int System_getHasStreamConnectors();

DLLExport
void omc_System_setUsesCardinality(threadData_t *threadData, modelica_boolean _inUses);

DLLExport
void boxptr_System_setUsesCardinality(threadData_t *threadData, modelica_metatype _inUses);

extern void System_setUsesCardinality(int /*_inUses*/);
typedef struct System_getUsesCardinality_rettype_s {
  modelica_boolean c1; /* outUses */
} System_getUsesCardinality_rettype;
DLLExport
System_getUsesCardinality_rettype omc_System_getUsesCardinality(threadData_t *threadData);
typedef struct System_getUsesCardinality_rettypeboxed_s {
  modelica_metatype c1; /* outUses */
} System_getUsesCardinality_rettypeboxed;
DLLExport
System_getUsesCardinality_rettypeboxed boxptr_System_getUsesCardinality(threadData_t *threadData);

extern int System_getUsesCardinality();

DLLExport
void omc_System_setHasInnerOuterDefinitions(threadData_t *threadData, modelica_boolean _hasInnerOuterDefinitions);

DLLExport
void boxptr_System_setHasInnerOuterDefinitions(threadData_t *threadData, modelica_metatype _hasInnerOuterDefinitions);

extern void System_setHasInnerOuterDefinitions(int /*_hasInnerOuterDefinitions*/);
typedef struct System_getHasInnerOuterDefinitions_rettype_s {
  modelica_boolean c1; /* hasInnerOuterDefinitions */
} System_getHasInnerOuterDefinitions_rettype;
DLLExport
System_getHasInnerOuterDefinitions_rettype omc_System_getHasInnerOuterDefinitions(threadData_t *threadData);
typedef struct System_getHasInnerOuterDefinitions_rettypeboxed_s {
  modelica_metatype c1; /* hasInnerOuterDefinitions */
} System_getHasInnerOuterDefinitions_rettypeboxed;
DLLExport
System_getHasInnerOuterDefinitions_rettypeboxed boxptr_System_getHasInnerOuterDefinitions(threadData_t *threadData);

extern int System_getHasInnerOuterDefinitions();
typedef struct System_tmpTick_rettype_s {
  modelica_integer c1; /* tickNo */
} System_tmpTick_rettype;
DLLExport
System_tmpTick_rettype omc_System_tmpTick(threadData_t *threadData);
typedef struct System_tmpTick_rettypeboxed_s {
  modelica_metatype c1; /* tickNo */
} System_tmpTick_rettypeboxed;
DLLExport
System_tmpTick_rettypeboxed boxptr_System_tmpTick(threadData_t *threadData);

extern int SystemImpl_tmpTick();

DLLExport
void omc_System_tmpTickReset(threadData_t *threadData, modelica_integer _start);

DLLExport
void boxptr_System_tmpTickReset(threadData_t *threadData, modelica_metatype _start);

extern void SystemImpl_tmpTickReset(int /*_start*/);
typedef struct System_parForTick_rettype_s {
  modelica_integer c1; /* loopNo */
} System_parForTick_rettype;
DLLExport
System_parForTick_rettype omc_System_parForTick(threadData_t *threadData);
typedef struct System_parForTick_rettypeboxed_s {
  modelica_metatype c1; /* loopNo */
} System_parForTick_rettypeboxed;
DLLExport
System_parForTick_rettypeboxed boxptr_System_parForTick(threadData_t *threadData);

extern int SystemImpl_parForTick();

DLLExport
void omc_System_parForTickReset(threadData_t *threadData, modelica_integer _start);

DLLExport
void boxptr_System_parForTickReset(threadData_t *threadData, modelica_metatype _start);

extern void SystemImpl_parForTickReset(int /*_start*/);
typedef struct System_tmpTickIndex_rettype_s {
  modelica_integer c1; /* tickNo */
} System_tmpTickIndex_rettype;
DLLExport
System_tmpTickIndex_rettype omc_System_tmpTickIndex(threadData_t *threadData, modelica_integer _index);
typedef struct System_tmpTickIndex_rettypeboxed_s {
  modelica_metatype c1; /* tickNo */
} System_tmpTickIndex_rettypeboxed;
DLLExport
System_tmpTickIndex_rettypeboxed boxptr_System_tmpTickIndex(threadData_t *threadData, modelica_metatype _index);

extern int SystemImpl_tmpTickIndex(int /*_index*/);
typedef struct System_tmpTickIndexReserve_rettype_s {
  modelica_integer c1; /* tickNo */
} System_tmpTickIndexReserve_rettype;
DLLExport
System_tmpTickIndexReserve_rettype omc_System_tmpTickIndexReserve(threadData_t *threadData, modelica_integer _index, modelica_integer _reserve);
typedef struct System_tmpTickIndexReserve_rettypeboxed_s {
  modelica_metatype c1; /* tickNo */
} System_tmpTickIndexReserve_rettypeboxed;
DLLExport
System_tmpTickIndexReserve_rettypeboxed boxptr_System_tmpTickIndexReserve(threadData_t *threadData, modelica_metatype _index, modelica_metatype _reserve);

extern int SystemImpl_tmpTickIndexReserve(int /*_index*/, int /*_reserve*/);

DLLExport
void omc_System_tmpTickResetIndex(threadData_t *threadData, modelica_integer _start, modelica_integer _index);

DLLExport
void boxptr_System_tmpTickResetIndex(threadData_t *threadData, modelica_metatype _start, modelica_metatype _index);

extern void SystemImpl_tmpTickResetIndex(int /*_start*/, int /*_index*/);
typedef struct System_getRTLibs_rettype_s {
  modelica_metatype c1; /* libs */
} System_getRTLibs_rettype;
DLLExport
System_getRTLibs_rettype omc_System_getRTLibs(threadData_t *threadData);
#define boxptr_System_getRTLibs omc_System_getRTLibs

extern const char* System_getRTLibs();
typedef struct System_getCorbaLibs_rettype_s {
  modelica_metatype c1; /* corbaLibs */
} System_getCorbaLibs_rettype;
DLLExport
System_getCorbaLibs_rettype omc_System_getCorbaLibs(threadData_t *threadData);
#define boxptr_System_getCorbaLibs omc_System_getCorbaLibs

extern const char* System_getCorbaLibs();
typedef struct System_getRuntimeLibs_rettype_s {
  modelica_metatype c1; /* libs */
} System_getRuntimeLibs_rettype;
DLLExport
System_getRuntimeLibs_rettype omc_System_getRuntimeLibs(threadData_t *threadData);
#define boxptr_System_getRuntimeLibs omc_System_getRuntimeLibs

extern modelica_metatype System_getRuntimeLibs();
typedef struct System_userIsRoot_rettype_s {
  modelica_boolean c1; /* isRoot */
} System_userIsRoot_rettype;
DLLExport
System_userIsRoot_rettype omc_System_userIsRoot(threadData_t *threadData);
typedef struct System_userIsRoot_rettypeboxed_s {
  modelica_metatype c1; /* isRoot */
} System_userIsRoot_rettypeboxed;
DLLExport
System_userIsRoot_rettypeboxed boxptr_System_userIsRoot(threadData_t *threadData);

extern int System_userIsRoot();
typedef struct System_configureCommandLine_rettype_s {
  modelica_metatype c1; /* cmdLine */
} System_configureCommandLine_rettype;
DLLExport
System_configureCommandLine_rettype omc_System_configureCommandLine(threadData_t *threadData);
#define boxptr_System_configureCommandLine omc_System_configureCommandLine

extern const char* System_configureCommandLine();

DLLExport
void omc_System_realtimeTick(threadData_t *threadData, modelica_integer _clockIndex);

DLLExport
void boxptr_System_realtimeTick(threadData_t *threadData, modelica_metatype _clockIndex);

extern void System_realtimeTick(int /*_clockIndex*/);
typedef struct System_realtimeTock_rettype_s {
  modelica_real c1; /* outTime */
} System_realtimeTock_rettype;
DLLExport
System_realtimeTock_rettype omc_System_realtimeTock(threadData_t *threadData, modelica_integer _clockIndex);
typedef struct System_realtimeTock_rettypeboxed_s {
  modelica_metatype c1; /* outTime */
} System_realtimeTock_rettypeboxed;
DLLExport
System_realtimeTock_rettypeboxed boxptr_System_realtimeTock(threadData_t *threadData, modelica_metatype _clockIndex);

extern double System_realtimeTock(int /*_clockIndex*/);

DLLExport
void omc_System_realtimeClear(threadData_t *threadData, modelica_integer _clockIndex);

DLLExport
void boxptr_System_realtimeClear(threadData_t *threadData, modelica_metatype _clockIndex);

extern void System_realtimeClear(int /*_clockIndex*/);
typedef struct System_realtimeNtick_rettype_s {
  modelica_integer c1; /* n */
} System_realtimeNtick_rettype;
DLLExport
System_realtimeNtick_rettype omc_System_realtimeNtick(threadData_t *threadData, modelica_integer _clockIndex);
typedef struct System_realtimeNtick_rettypeboxed_s {
  modelica_metatype c1; /* n */
} System_realtimeNtick_rettypeboxed;
DLLExport
System_realtimeNtick_rettypeboxed boxptr_System_realtimeNtick(threadData_t *threadData, modelica_metatype _clockIndex);

extern int System_realtimeNtick(int /*_clockIndex*/);

DLLExport
void omc_System_resetTimer(threadData_t *threadData);
#define boxptr_System_resetTimer omc_System_resetTimer

extern void System_resetTimer();

DLLExport
void omc_System_startTimer(threadData_t *threadData);
#define boxptr_System_startTimer omc_System_startTimer

extern void System_startTimer();

DLLExport
void omc_System_stopTimer(threadData_t *threadData);
#define boxptr_System_stopTimer omc_System_stopTimer

extern void System_stopTimer();
typedef struct System_getTimerIntervalTime_rettype_s {
  modelica_real c1; /* timerIntervalTime */
} System_getTimerIntervalTime_rettype;
DLLExport
System_getTimerIntervalTime_rettype omc_System_getTimerIntervalTime(threadData_t *threadData);
typedef struct System_getTimerIntervalTime_rettypeboxed_s {
  modelica_metatype c1; /* timerIntervalTime */
} System_getTimerIntervalTime_rettypeboxed;
DLLExport
System_getTimerIntervalTime_rettypeboxed boxptr_System_getTimerIntervalTime(threadData_t *threadData);

extern double System_getTimerIntervalTime();
typedef struct System_getTimerCummulatedTime_rettype_s {
  modelica_real c1; /* timerCummulatedTime */
} System_getTimerCummulatedTime_rettype;
DLLExport
System_getTimerCummulatedTime_rettype omc_System_getTimerCummulatedTime(threadData_t *threadData);
typedef struct System_getTimerCummulatedTime_rettypeboxed_s {
  modelica_metatype c1; /* timerCummulatedTime */
} System_getTimerCummulatedTime_rettypeboxed;
DLLExport
System_getTimerCummulatedTime_rettypeboxed boxptr_System_getTimerCummulatedTime(threadData_t *threadData);

extern double System_getTimerCummulatedTime();
typedef struct System_getTimerElapsedTime_rettype_s {
  modelica_real c1; /* timerElapsedTime */
} System_getTimerElapsedTime_rettype;
DLLExport
System_getTimerElapsedTime_rettype omc_System_getTimerElapsedTime(threadData_t *threadData);
typedef struct System_getTimerElapsedTime_rettypeboxed_s {
  modelica_metatype c1; /* timerElapsedTime */
} System_getTimerElapsedTime_rettypeboxed;
DLLExport
System_getTimerElapsedTime_rettypeboxed boxptr_System_getTimerElapsedTime(threadData_t *threadData);

extern double System_getTimerElapsedTime();
typedef struct System_getTimerStackIndex_rettype_s {
  modelica_integer c1; /* stackIndex */
} System_getTimerStackIndex_rettype;
DLLExport
System_getTimerStackIndex_rettype omc_System_getTimerStackIndex(threadData_t *threadData);
typedef struct System_getTimerStackIndex_rettypeboxed_s {
  modelica_metatype c1; /* stackIndex */
} System_getTimerStackIndex_rettypeboxed;
DLLExport
System_getTimerStackIndex_rettypeboxed boxptr_System_getTimerStackIndex(threadData_t *threadData);

extern int System_getTimerStackIndex();
typedef struct System_getUUIDStr_rettype_s {
  modelica_metatype c1; /* uuidStr */
} System_getUUIDStr_rettype;
DLLExport
System_getUUIDStr_rettype omc_System_getUUIDStr(threadData_t *threadData);
#define boxptr_System_getUUIDStr omc_System_getUUIDStr

extern const char* System_getUUIDStr();
typedef struct System_basename_rettype_s {
  modelica_metatype c1; /* base */
} System_basename_rettype;
DLLExport
System_basename_rettype omc_System_basename(threadData_t *threadData, modelica_metatype _filename);
#define boxptr_System_basename omc_System_basename

extern const char* System_basename(const char* /*_filename*/);
typedef struct System_dirname_rettype_s {
  modelica_metatype c1; /* base */
} System_dirname_rettype;
DLLExport
System_dirname_rettype omc_System_dirname(threadData_t *threadData, modelica_metatype _filename);
#define boxptr_System_dirname omc_System_dirname

extern const char* System_dirname(const char* /*_filename*/);
typedef struct System_escapedString_rettype_s {
  modelica_metatype c1; /* escapedString */
} System_escapedString_rettype;
DLLExport
System_escapedString_rettype omc_System_escapedString(threadData_t *threadData, modelica_metatype _unescapedString, modelica_boolean _unescapeNewline);
typedef struct System_escapedString_rettypeboxed_s {
  modelica_metatype c1; /* escapedString */
} System_escapedString_rettypeboxed;
DLLExport
System_escapedString_rettypeboxed boxptr_System_escapedString(threadData_t *threadData, modelica_metatype _unescapedString, modelica_metatype _unescapeNewline);

extern const char* System_escapedString(const char* /*_unescapedString*/, int /*_unescapeNewline*/);
typedef struct System_unescapedString_rettype_s {
  modelica_metatype c1; /* unescapedString */
} System_unescapedString_rettype;
DLLExport
System_unescapedString_rettype omc_System_unescapedString(threadData_t *threadData, modelica_metatype _escapedString);
#define boxptr_System_unescapedString omc_System_unescapedString

extern const char* System_unescapedString(const char* /*_escapedString*/);
typedef struct System_unescapedStringLength_rettype_s {
  modelica_integer c1; /* length */
} System_unescapedStringLength_rettype;
DLLExport
System_unescapedStringLength_rettype omc_System_unescapedStringLength(threadData_t *threadData, modelica_metatype _unescapedString);
typedef struct System_unescapedStringLength_rettypeboxed_s {
  modelica_metatype c1; /* length */
} System_unescapedStringLength_rettypeboxed;
DLLExport
System_unescapedStringLength_rettypeboxed boxptr_System_unescapedStringLength(threadData_t *threadData, modelica_metatype _unescapedString);

extern int SystemImpl__unescapedStringLength(const char* /*_unescapedString*/);
typedef struct System_unquoteIdentifier_rettype_s {
  modelica_metatype c1; /* outStr */
} System_unquoteIdentifier_rettype;
DLLExport
System_unquoteIdentifier_rettype omc_System_unquoteIdentifier(threadData_t *threadData, modelica_metatype _str);
#define boxptr_System_unquoteIdentifier omc_System_unquoteIdentifier

extern const char* System_unquoteIdentifier(const char* /*_str*/);
typedef struct System_uriToClassAndPath_rettype_s {
  modelica_metatype c1; /* scheme */
  modelica_metatype c2; /* classname */
  modelica_metatype c3; /* pathname */
} System_uriToClassAndPath_rettype;
DLLExport
System_uriToClassAndPath_rettype omc_System_uriToClassAndPath(threadData_t *threadData, modelica_metatype _uri);
#define boxptr_System_uriToClassAndPath omc_System_uriToClassAndPath

extern void System_uriToClassAndPath(const char* /*_uri*/, const char** /*_scheme*/, const char** /*_classname*/, const char** /*_pathname*/);
typedef struct System_modelicaPlatform_rettype_s {
  modelica_metatype c1; /* platform */
} System_modelicaPlatform_rettype;
DLLExport
System_modelicaPlatform_rettype omc_System_modelicaPlatform(threadData_t *threadData);
#define boxptr_System_modelicaPlatform omc_System_modelicaPlatform

extern const char* System_modelicaPlatform();
typedef struct System_openModelicaPlatform_rettype_s {
  modelica_metatype c1; /* platform */
} System_openModelicaPlatform_rettype;
DLLExport
System_openModelicaPlatform_rettype omc_System_openModelicaPlatform(threadData_t *threadData);
#define boxptr_System_openModelicaPlatform omc_System_openModelicaPlatform

extern const char* System_openModelicaPlatform();
typedef struct System_getGCStatus_rettype_s {
  modelica_integer c1; /* used */
  modelica_integer c2; /* allocated */
} System_getGCStatus_rettype;
DLLExport
System_getGCStatus_rettype omc_System_getGCStatus(threadData_t *threadData);
typedef struct System_getGCStatus_rettypeboxed_s {
  modelica_metatype c1; /* used */
  modelica_metatype c2; /* allocated */
} System_getGCStatus_rettypeboxed;
DLLExport
System_getGCStatus_rettypeboxed boxptr_System_getGCStatus(threadData_t *threadData);

extern void System_getGCStatus(int* /*_used*/, int* /*_allocated*/);
typedef struct System_dgesv_rettype_s {
  modelica_metatype c1; /* X */
  modelica_integer c2; /* info */
} System_dgesv_rettype;
DLLExport
System_dgesv_rettype omc_System_dgesv(threadData_t *threadData, modelica_metatype _A, modelica_metatype _B);
typedef struct System_dgesv_rettypeboxed_s {
  modelica_metatype c1; /* X */
  modelica_metatype c2; /* info */
} System_dgesv_rettypeboxed;
DLLExport
System_dgesv_rettypeboxed boxptr_System_dgesv(threadData_t *threadData, modelica_metatype _A, modelica_metatype _B);

extern int SystemImpl__dgesv(modelica_metatype /*_A*/, modelica_metatype /*_B*/, modelica_metatype* /*_X*/);
typedef struct System_lpsolve55_rettype_s {
  modelica_metatype c1; /* X */
  modelica_integer c2; /* info */
} System_lpsolve55_rettype;
DLLExport
System_lpsolve55_rettype omc_System_lpsolve55(threadData_t *threadData, modelica_metatype _A, modelica_metatype _B, modelica_metatype _intIndices);
typedef struct System_lpsolve55_rettypeboxed_s {
  modelica_metatype c1; /* X */
  modelica_metatype c2; /* info */
} System_lpsolve55_rettypeboxed;
DLLExport
System_lpsolve55_rettypeboxed boxptr_System_lpsolve55(threadData_t *threadData, modelica_metatype _A, modelica_metatype _B, modelica_metatype _intIndices);

extern int SystemImpl__lpsolve55(modelica_metatype /*_A*/, modelica_metatype /*_B*/, modelica_metatype /*_intIndices*/, modelica_metatype* /*_X*/);
typedef struct System_reopenStandardStream_rettype_s {
  modelica_boolean c1; /* success */
} System_reopenStandardStream_rettype;
DLLExport
System_reopenStandardStream_rettype omc_System_reopenStandardStream(threadData_t *threadData, modelica_integer __stream, modelica_metatype _filename);
typedef struct System_reopenStandardStream_rettypeboxed_s {
  modelica_metatype c1; /* success */
} System_reopenStandardStream_rettypeboxed;
DLLExport
System_reopenStandardStream_rettypeboxed boxptr_System_reopenStandardStream(threadData_t *threadData, modelica_metatype __stream, modelica_metatype _filename);

extern int SystemImpl__reopenStandardStream(int /*__stream*/, const char* /*_filename*/);
typedef struct System_iconv_rettype_s {
  modelica_metatype c1; /* result */
} System_iconv_rettype;
DLLExport
System_iconv_rettype omc_System_iconv(threadData_t *threadData, modelica_metatype _string, modelica_metatype _from, modelica_metatype _to);
#define boxptr_System_iconv omc_System_iconv

extern const char* SystemImpl__iconv(const char* /*_string*/, const char* /*_from*/, const char* /*_to*/, int);
typedef struct System_snprintff_rettype_s {
  modelica_metatype c1; /* str */
} System_snprintff_rettype;
DLLExport
System_snprintff_rettype omc_System_snprintff(threadData_t *threadData, modelica_metatype _format, modelica_integer _maxlen, modelica_real _val);
typedef struct System_snprintff_rettypeboxed_s {
  modelica_metatype c1; /* str */
} System_snprintff_rettypeboxed;
DLLExport
System_snprintff_rettypeboxed boxptr_System_snprintff(threadData_t *threadData, modelica_metatype _format, modelica_metatype _maxlen, modelica_metatype _val);

extern const char* System_snprintff(const char* /*_format*/, int /*_maxlen*/, double /*_val*/);
typedef struct System_realRand_rettype_s {
  modelica_real c1; /* r */
} System_realRand_rettype;
DLLExport
System_realRand_rettype omc_System_realRand(threadData_t *threadData);
typedef struct System_realRand_rettypeboxed_s {
  modelica_metatype c1; /* r */
} System_realRand_rettypeboxed;
DLLExport
System_realRand_rettypeboxed boxptr_System_realRand(threadData_t *threadData);

extern double SystemImpl__realRand();
typedef struct System_intRand_rettype_s {
  modelica_integer c1; /* i */
} System_intRand_rettype;
DLLExport
System_intRand_rettype omc_System_intRand(threadData_t *threadData, modelica_integer _n);
typedef struct System_intRand_rettypeboxed_s {
  modelica_metatype c1; /* i */
} System_intRand_rettypeboxed;
DLLExport
System_intRand_rettypeboxed boxptr_System_intRand(threadData_t *threadData, modelica_metatype _n);

extern int SystemImpl__intRand(int /*_n*/);

DLLExport
void omc_System_gettextInit(threadData_t *threadData, modelica_metatype _locale);
#define boxptr_System_gettextInit omc_System_gettextInit

extern void SystemImpl__gettextInit(const char* /*_locale*/);
typedef struct System_gettext_rettype_s {
  modelica_metatype c1; /* msgstr */
} System_gettext_rettype;
DLLExport
System_gettext_rettype omc_System_gettext(threadData_t *threadData, modelica_metatype _msgid);
#define boxptr_System_gettext omc_System_gettext

extern const char* SystemImpl__gettext(const char* /*_msgid*/);
typedef struct System_anyStringCode_rettype_s {
  modelica_metatype c1; /* str */
} System_anyStringCode_rettype;
DLLExport
System_anyStringCode_rettype omc_System_anyStringCode(threadData_t *threadData, modelica_metatype _any);
#define boxptr_System_anyStringCode omc_System_anyStringCode

extern const char* anyStringCode(modelica_metatype /*_any*/);
typedef struct System_numBits_rettype_s {
  modelica_integer c1; /* n */
} System_numBits_rettype;
DLLExport
System_numBits_rettype omc_System_numBits(threadData_t *threadData);
typedef struct System_numBits_rettypeboxed_s {
  modelica_metatype c1; /* n */
} System_numBits_rettypeboxed;
DLLExport
System_numBits_rettypeboxed boxptr_System_numBits(threadData_t *threadData);

extern int architecture_numbits();
typedef struct System_realpath_rettype_s {
  modelica_metatype c1; /* fullpath */
} System_realpath_rettype;
DLLExport
System_realpath_rettype omc_System_realpath(threadData_t *threadData, modelica_metatype _path);
#define boxptr_System_realpath omc_System_realpath

extern const char* System_realpath(const char* /*_path*/);
typedef struct System_getSimulationHelpText_rettype_s {
  modelica_metatype c1; /* text */
} System_getSimulationHelpText_rettype;
DLLExport
System_getSimulationHelpText_rettype omc_System_getSimulationHelpText(threadData_t *threadData, modelica_boolean _detailed);
typedef struct System_getSimulationHelpText_rettypeboxed_s {
  modelica_metatype c1; /* text */
} System_getSimulationHelpText_rettypeboxed;
DLLExport
System_getSimulationHelpText_rettypeboxed boxptr_System_getSimulationHelpText(threadData_t *threadData, modelica_metatype _detailed);

extern const char* System_getSimulationHelpText(int /*_detailed*/);
typedef struct System_getTerminalWidth_rettype_s {
  modelica_integer c1; /* width */
} System_getTerminalWidth_rettype;
DLLExport
System_getTerminalWidth_rettype omc_System_getTerminalWidth(threadData_t *threadData);
typedef struct System_getTerminalWidth_rettypeboxed_s {
  modelica_metatype c1; /* width */
} System_getTerminalWidth_rettypeboxed;
DLLExport
System_getTerminalWidth_rettypeboxed boxptr_System_getTerminalWidth(threadData_t *threadData);

extern int System_getTerminalWidth();
typedef struct System_fileIsNewerThan_rettype_s {
  modelica_boolean c1; /* result */
} System_fileIsNewerThan_rettype;
DLLExport
System_fileIsNewerThan_rettype omc_System_fileIsNewerThan(threadData_t *threadData, modelica_metatype _file1, modelica_metatype _file2);
typedef struct System_fileIsNewerThan_rettypeboxed_s {
  modelica_metatype c1; /* result */
} System_fileIsNewerThan_rettypeboxed;
DLLExport
System_fileIsNewerThan_rettypeboxed boxptr_System_fileIsNewerThan(threadData_t *threadData, modelica_metatype _file1, modelica_metatype _file2);

extern int System_fileIsNewerThan(const char* /*_file1*/, const char* /*_file2*/);
typedef struct System_numProcessors_rettype_s {
  modelica_integer c1; /* result */
} System_numProcessors_rettype;
DLLExport
System_numProcessors_rettype omc_System_numProcessors(threadData_t *threadData);
typedef struct System_numProcessors_rettypeboxed_s {
  modelica_metatype c1; /* result */
} System_numProcessors_rettypeboxed;
DLLExport
System_numProcessors_rettypeboxed boxptr_System_numProcessors(threadData_t *threadData);

extern int System_numProcessors();
typedef struct System_forkAvailable_rettype_s {
  modelica_boolean c1; /* result */
} System_forkAvailable_rettype;
DLLExport
System_forkAvailable_rettype omc_System_forkAvailable(threadData_t *threadData);
typedef struct System_forkAvailable_rettypeboxed_s {
  modelica_metatype c1; /* result */
} System_forkAvailable_rettypeboxed;
DLLExport
System_forkAvailable_rettypeboxed boxptr_System_forkAvailable(threadData_t *threadData);

extern int System_forkAvailable();
typedef struct System_forkCall_rettype_s {
  modelica_metatype c1; /* result */
} System_forkCall_rettype;
DLLExport
System_forkCall_rettype omc_System_forkCall(threadData_t *threadData, modelica_integer _numThreads, modelica_metatype _inData, modelica_fnptr func);
typedef struct System_forkCall_rettypeboxed_s {
  modelica_metatype c1; /* result */
} System_forkCall_rettypeboxed;
DLLExport
System_forkCall_rettypeboxed boxptr_System_forkCall(threadData_t *threadData, modelica_metatype _numThreads, modelica_metatype _inData, modelica_fnptr func);

extern modelica_metatype System_forkCall(int /*_numThreads*/, modelica_metatype /*_inData*/, modelica_fnptr /*_func*/);

DLLExport
void omc_System_exit(threadData_t *threadData, modelica_integer _status);

DLLExport
void boxptr_System_exit(threadData_t *threadData, modelica_metatype _status);

extern void exit(int /*_status*/);
typedef struct System_getMemorySize_rettype_s {
  modelica_real c1; /* memory */
} System_getMemorySize_rettype;
DLLExport
System_getMemorySize_rettype omc_System_getMemorySize(threadData_t *threadData);
typedef struct System_getMemorySize_rettypeboxed_s {
  modelica_metatype c1; /* memory */
} System_getMemorySize_rettypeboxed;
DLLExport
System_getMemorySize_rettypeboxed boxptr_System_getMemorySize(threadData_t *threadData);

extern double System_getMemorySize();
#ifdef __cplusplus
extern "C" {
#endif
#define architecture_numbits() (8*sizeof(void*))
#include <stdio.h>
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
}
#endif
#endif

