#ifndef TaskGraph__H
#define TaskGraph__H
#define __OPENMODELICA__METAMODELICA
#include "meta_modelica.h"

#include "modelica.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#ifdef __cplusplus
extern "C" {
#endif

extern struct record_description Absyn_Info_INFO__desc;
extern struct record_description Absyn_TimeStamp_TIMESTAMP__desc;
extern struct record_description BackendDAE_Var_VAR__desc;
extern struct record_description BackendDAE_VarKind_VARIABLE__desc;
extern struct record_description DAE_ConnectorType_NON__CONNECTOR__desc;
extern struct record_description DAE_ElementSource_SOURCE__desc;
extern struct record_description DAE_Exp_BINARY__desc;
extern struct record_description DAE_Operator_SUB__desc;
extern struct record_description DAE_Type_T__REAL__desc;
extern struct record_description DAE_VarDirection_INPUT__desc;
extern struct record_description DAE_VarParallelism_NON__PARALLEL__desc;

DLLExport
void omc_TaskGraph_buildTaskgraph(threadData_t *threadData, modelica_metatype _inBackendDAE, modelica_metatype _inComps);
#define boxptr_TaskGraph_buildTaskgraph omc_TaskGraph_buildTaskgraph


DLLExport
void omc_TaskGraph_buildInits(threadData_t *threadData, modelica_metatype _inBackendDAE);
#define boxptr_TaskGraph_buildInits omc_TaskGraph_buildInits


DLLExport
void omc_TaskGraph_buildInits2(threadData_t *threadData, modelica_metatype _inBackendDAEVarLst, modelica_integer _index);

DLLExport
void boxptr_TaskGraph_buildInits2(threadData_t *threadData, modelica_metatype _inBackendDAEVarLst, modelica_metatype _index);

DLLExport
void omc_TaskGraph_addVariables(threadData_t *threadData, modelica_metatype _inBackendDAEVarLst, modelica_integer _inInteger);

DLLExport
void boxptr_TaskGraph_addVariables(threadData_t *threadData, modelica_metatype _inBackendDAEVarLst, modelica_metatype _inInteger);

DLLExport
void omc_TaskGraph_buildBlocks(threadData_t *threadData, modelica_metatype _inBackendDAE, modelica_metatype _inComps);
#define boxptr_TaskGraph_buildBlocks omc_TaskGraph_buildBlocks


DLLExport
void omc_TaskGraph_buildEquation(threadData_t *threadData, modelica_metatype _inBackendDAE, modelica_metatype _inComp);
#define boxptr_TaskGraph_buildEquation omc_TaskGraph_buildEquation


DLLExport
void omc_TaskGraph_buildNonlinearEquations(threadData_t *threadData, modelica_metatype _inExpExpLst1, modelica_metatype _inExpExpLst2);
#define boxptr_TaskGraph_buildNonlinearEquations omc_TaskGraph_buildNonlinearEquations

typedef struct TaskGraph_buildResidualCode_rettype_s {
  modelica_metatype c1; /* outString */
} TaskGraph_buildResidualCode_rettype;
DLLExport
TaskGraph_buildResidualCode_rettype omc_TaskGraph_buildResidualCode(threadData_t *threadData, modelica_metatype _inExpExpLst1, modelica_metatype _inExpExpLst2);
#define boxptr_TaskGraph_buildResidualCode omc_TaskGraph_buildResidualCode

typedef struct TaskGraph_makeResidualReplacements_rettype_s {
  modelica_metatype c1; /* repl_1 */
} TaskGraph_makeResidualReplacements_rettype;
DLLExport
TaskGraph_makeResidualReplacements_rettype omc_TaskGraph_makeResidualReplacements(threadData_t *threadData, modelica_metatype _expl);
#define boxptr_TaskGraph_makeResidualReplacements omc_TaskGraph_makeResidualReplacements

typedef struct TaskGraph_makeResidualReplacements2_rettype_s {
  modelica_metatype c1; /* outVariableReplacements */
} TaskGraph_makeResidualReplacements2_rettype;
DLLExport
TaskGraph_makeResidualReplacements2_rettype omc_TaskGraph_makeResidualReplacements2(threadData_t *threadData, modelica_metatype _inVariableReplacements, modelica_metatype _inExpExpLst, modelica_integer _inInteger);
typedef struct TaskGraph_makeResidualReplacements2_rettypeboxed_s {
  modelica_metatype c1; /* outVariableReplacements */
} TaskGraph_makeResidualReplacements2_rettypeboxed;
DLLExport
TaskGraph_makeResidualReplacements2_rettypeboxed boxptr_TaskGraph_makeResidualReplacements2(threadData_t *threadData, modelica_metatype _inVariableReplacements, modelica_metatype _inExpExpLst, modelica_metatype _inInteger);
typedef struct TaskGraph_buildResidualCode2_rettype_s {
  modelica_metatype c1; /* outString */
} TaskGraph_buildResidualCode2_rettype;
DLLExport
TaskGraph_buildResidualCode2_rettype omc_TaskGraph_buildResidualCode2(threadData_t *threadData, modelica_metatype _inExpExpLst, modelica_integer _inInteger, modelica_metatype _inVariableReplacements);
typedef struct TaskGraph_buildResidualCode2_rettypeboxed_s {
  modelica_metatype c1; /* outString */
} TaskGraph_buildResidualCode2_rettypeboxed;
DLLExport
TaskGraph_buildResidualCode2_rettypeboxed boxptr_TaskGraph_buildResidualCode2(threadData_t *threadData, modelica_metatype _inExpExpLst, modelica_metatype _inInteger, modelica_metatype _inVariableReplacements);

DLLExport
void omc_TaskGraph_storeMultipleResults(threadData_t *threadData, modelica_metatype _inStringLst, modelica_integer _inInteger);

DLLExport
void boxptr_TaskGraph_storeMultipleResults(threadData_t *threadData, modelica_metatype _inStringLst, modelica_metatype _inInteger);

DLLExport
void omc_TaskGraph_buildNonlinearEquations2(threadData_t *threadData, modelica_integer _inInteger1, modelica_metatype _inExpExpLst2, modelica_metatype _inExpExpLst3);

DLLExport
void boxptr_TaskGraph_buildNonlinearEquations2(threadData_t *threadData, modelica_metatype _inInteger1, modelica_metatype _inExpExpLst2, modelica_metatype _inExpExpLst3);

DLLExport
void omc_TaskGraph_addEdgesFromVars(threadData_t *threadData, modelica_metatype _inExpComponentRefLst1, modelica_integer _inInteger2, modelica_integer _inInteger3);

DLLExport
void boxptr_TaskGraph_addEdgesFromVars(threadData_t *threadData, modelica_metatype _inExpComponentRefLst1, modelica_metatype _inInteger2, modelica_metatype _inInteger3);

DLLExport
void omc_TaskGraph_buildSystem(threadData_t *threadData, modelica_metatype _inBackendDAE, modelica_metatype _inComp);
#define boxptr_TaskGraph_buildSystem omc_TaskGraph_buildSystem

typedef struct TaskGraph_buildSystem2_rettype_s {
  modelica_metatype c1; /* outStringLst */
} TaskGraph_buildSystem2_rettype;
DLLExport
TaskGraph_buildSystem2_rettype omc_TaskGraph_buildSystem2(threadData_t *threadData, modelica_metatype _inBackendDAE, modelica_metatype _inEqns, modelica_metatype _inVars, modelica_integer _inInteger5);
typedef struct TaskGraph_buildSystem2_rettypeboxed_s {
  modelica_metatype c1; /* outStringLst */
} TaskGraph_buildSystem2_rettypeboxed;
DLLExport
TaskGraph_buildSystem2_rettypeboxed boxptr_TaskGraph_buildSystem2(threadData_t *threadData, modelica_metatype _inBackendDAE, modelica_metatype _inEqns, modelica_metatype _inVars, modelica_metatype _inInteger5);

DLLExport
void omc_TaskGraph_addVariable(threadData_t *threadData, modelica_metatype _inVar, modelica_integer _inInteger);

DLLExport
void boxptr_TaskGraph_addVariable(threadData_t *threadData, modelica_metatype _inVar, modelica_metatype _inInteger);

DLLExport
void omc_TaskGraph_buildAssignment(threadData_t *threadData, modelica_metatype _inComponentRef, modelica_metatype _inExp, modelica_metatype _inString);
#define boxptr_TaskGraph_buildAssignment omc_TaskGraph_buildAssignment

typedef struct TaskGraph_buildExpression_rettype_s {
  modelica_integer c1; /* outInteger */
  modelica_metatype c2; /* outString */
} TaskGraph_buildExpression_rettype;
DLLExport
TaskGraph_buildExpression_rettype omc_TaskGraph_buildExpression(threadData_t *threadData, modelica_metatype _inExp);
typedef struct TaskGraph_buildExpression_rettypeboxed_s {
  modelica_metatype c1; /* outInteger */
  modelica_metatype c2; /* outString */
} TaskGraph_buildExpression_rettypeboxed;
DLLExport
TaskGraph_buildExpression_rettypeboxed boxptr_TaskGraph_buildExpression(threadData_t *threadData, modelica_metatype _inExp);
typedef struct TaskGraph_buildCallStr_rettype_s {
  modelica_metatype c1; /* res */
} TaskGraph_buildCallStr_rettype;
DLLExport
TaskGraph_buildCallStr_rettype omc_TaskGraph_buildCallStr(threadData_t *threadData, modelica_metatype _str, modelica_integer _n);
typedef struct TaskGraph_buildCallStr_rettypeboxed_s {
  modelica_metatype c1; /* res */
} TaskGraph_buildCallStr_rettypeboxed;
DLLExport
TaskGraph_buildCallStr_rettypeboxed boxptr_TaskGraph_buildCallStr(threadData_t *threadData, modelica_metatype _str, modelica_metatype _n);

DLLExport
void omc_TaskGraph_addPredecessors(threadData_t *threadData, modelica_integer _inInteger1, modelica_metatype _inIntegerLst2, modelica_metatype _inStringLst3, modelica_integer _inInteger4);

DLLExport
void boxptr_TaskGraph_addPredecessors(threadData_t *threadData, modelica_metatype _inInteger1, modelica_metatype _inIntegerLst2, modelica_metatype _inStringLst3, modelica_metatype _inInteger4);
#ifdef __cplusplus
extern "C" {
#endif
#include "Absyn.h"
#include "BackendDAETransform.h"
#include "BackendDAEUtil.h"
#include "BackendVariable.h"
#include "ComponentReference.h"
#include "DAEUtil.h"
#include "Debug.h"
#include "Expression.h"
#include "ExpressionDump.h"
#include "ExpressionSolve.h"
#include "List.h"
#include "TaskGraph.h"
#include "TaskGraphExt.h"
#include "ValuesUtil.h"
#include "VarTransform.h"
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
}
#endif
#endif

