#ifdef __cplusplus
extern "C" {
#endif
#line 38 "/home/martin/trunk/Compiler/Util/File.mo"

#ifndef __OMC_FILE_NEW
#define __OMC_FILE_NEW
#include <stdio.h>
#include <gc.h>
static inline void* om_file_new()
{
  return GC_malloc(sizeof(FILE*));
}
#endif

#line 52 "/home/martin/trunk/Compiler/Util/File.mo"

#ifndef __OMC_FILE_FREE
#define __OMC_FILE_FREE
#include <stdio.h>
static inline void om_file_free(FILE **file)
{
  if (*file) {
    fclose(*file);
    *file = 0;
  }
  GC_free(file);
}
#endif

#line 75 "/home/martin/trunk/Compiler/Util/File.mo"

#ifndef __OMC_FILE_OPEN
#define __OMC_FILE_OPEN
#include <stdio.h>
#include <errno.h>
#include "ModelicaUtilities.h"
static inline void om_file_open(FILE **file,const char *filename,int mode)
{
  if (*file) {
    fclose(*file);
  }
  *file = fopen(filename, mode == 1 ? "rb" : "wb");
  if (0 == *file) {
    ModelicaFormatError("Failed to open file %s with mode %d: %s\n", filename, mode, strerror(errno));
  }
}
#endif

#line 98 "/home/martin/trunk/Compiler/Util/File.mo"

#ifndef __OMC_FILE_WRITE
#define __OMC_FILE_WRITE
#include <stdio.h>
#include <errno.h>
#include "ModelicaUtilities.h"
static inline void om_file_write(FILE **file,const char *data)
{
  if (!*file) {
    ModelicaError("Failed to write to file (not open)");
  }
  if (1 != fputs(data,*file)) {
    ModelicaFormatError("Failed to write to file: %s\n", strerror(errno));
  }
}
#endif

#line 125 "/home/martin/trunk/Compiler/Util/File.mo"

#ifndef __OMC_FILE_WRITE_ESCAPE
#define __OMC_FILE_WRITE_ESCAPE
#include <stdio.h>
#include <errno.h>
#include "ModelicaUtilities.h"
enum escape_t {
  C=1,
  JSON,
  XML
};
#define ERROR_WRITE() ModelicaFormatError("Failed to write to file: %s\n", strerror(errno))
static inline void om_file_write_escape(FILE **file,const char *data,enum escape_t escape)
{
  if (!*file) {
    ModelicaError("Failed to write to file (not open)\n");
  }
  switch (escape) {
  case C:
    while (*data) {
      if (*data == '\n') {
        if (fputs("\\n",*file)<0) ERROR_WRITE();
      } else if (*data == '"') {
        if (fputs("\\\"",*file)<0) ERROR_WRITE();
      } else {
        if (putc(*data,*file)<0) ERROR_WRITE();
      }
      data++;
    }
    break;
  case JSON:
    while (*data) {
      switch (*data) {
      case '\"': if (fputs("\\\"",*file)<0) ERROR_WRITE();break;
      case '\\': if (fputs("\\\\",*file)<0) ERROR_WRITE();break;
      case '\n': if (fputs("\\n",*file)<0) ERROR_WRITE();break;
      case '\b': if (fputs("\\b",*file)<0) ERROR_WRITE();break;
      case '\f': if (fputs("\\f",*file)<0) ERROR_WRITE();break;
      case '\r': if (fputs("\\r",*file)<0) ERROR_WRITE();break;
      case '\t': if (fputs("\\t",*file)<0) ERROR_WRITE();break;
      default:
        if (*data < ' ') { /* Escape other control characters */
          if (fprintf(*file, "\\u%04x",*data)<0) ERROR_WRITE();
        } else {
          if (putc(*data,*file)<0) ERROR_WRITE();
        }
      }
      data++;
    }
    break;
  case XML:
    while (*data) {
      switch (*data) {
      case '<': if (fputs("&lt;",*file)<0) ERROR_WRITE();break;
      case '>': if (fputs("&gt;",*file)<0) ERROR_WRITE();break;
      case '"': if (fputs("&#34;",*file)<0) ERROR_WRITE();break;
      case '&': if (fputs("&amp;",*file)<0) ERROR_WRITE();break;
      case '\'': if (fputs("&#39;",*file)<0) ERROR_WRITE();break;
      default:
        if (putc(*data,*file)<0) ERROR_WRITE();
      }
      data++;
    }
    break;
  default:
    ModelicaFormatError("No such escape enumeration: %d\n", escape);
  }
}
#endif

#line 204 "/home/martin/trunk/Compiler/Util/File.mo"

#ifndef __OMC_FILE_SEEK
#define __OMC_FILE_SEEK
#include <stdio.h>
#include "ModelicaUtilities.h"
enum whence_t {
  OMC_SEEK_SET=1,
  OMC_SEEK_CURRENT,
  OMC_SEEK_END
};
static inline int om_file_seek(FILE **file,int offset,enum whence_t whence)
{
  if (!*file) {
    return 0;
  }
  return 0==fseek(*file,offset,whence == OMC_SEEK_SET ? SEEK_SET : whence == OMC_SEEK_CURRENT ? OMC_SEEK_CURRENT : SEEK_END);
}
#endif
#ifdef __cplusplus
}
#endif
