encapsulated package CodegenC
"
  file:        CodegenC.mo
  package:     CodegenC
  description: Generated by Susan.
"

public import Tpl;

public import SimCodeVar;
public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import SCodeDump;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCodeMain;
public import HpcOmSimCode;
public import HpcOmMemory;
public import HpcOmScheduler;
public import CodegenUtil;

protected function fun_36
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Function> in_a_modelInfo_functions;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_modelInfo_functions, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_modelInfo_functions;
      String a_fileNamePrefix;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_modelInfo_functions,
           a_fileNamePrefix )
      equation
        txt_0 = simulationParModelicaKernelsFile(Tpl.emptyTxt, a_fileNamePrefix, a_modelInfo_functions);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_kernels.cl"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end match;
end fun_36;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      list<String> i_sc_externalFunctionIncludes;
      list<SimCode.RecordDeclaration> i_recordDecls;
      list<SimCode.Function> i_modelInfo_functions;
      list<DAE.Exp> i_literals;
      String i_fileNamePrefix;
      SimCode.SimCode i_sc;
      Boolean ret_18;
      Tpl.Text l_0__;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text l_dummy;
      String ret_1;
      Tpl.Text l_target;

    case ( txt,
           (i_sc as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, literals = i_literals, recordDecls = i_recordDecls, externalFunctionIncludes = i_sc_externalFunctionIncludes)),
           a_guid )
      equation
        ret_1 = Config.simulationCodeTarget();
        l_target = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        l_dummy = Tpl.emptyTxt;
        System.tmpTickResetIndex(0, 2);
        txt_3 = simulationMakefile(Tpl.emptyTxt, Tpl.textString(l_target), i_sc);
        txt_4 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_4 = Tpl.writeTok(txt_4, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_3, Tpl.textString(txt_4));
        txt_5 = simulationLiteralsFile(Tpl.emptyTxt, i_fileNamePrefix, i_literals);
        txt_6 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_6 = Tpl.writeTok(txt_6, Tpl.ST_STRING("_literals.h"));
        Tpl.textFile(txt_5, Tpl.textString(txt_6));
        txt_7 = simulationFunctionsHeaderFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_recordDecls);
        txt_8 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_8 = Tpl.writeTok(txt_8, Tpl.ST_STRING("_functions.h"));
        Tpl.textFile(txt_7, Tpl.textString(txt_8));
        (txt_9, l_dummy) = simulationFunctionsFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, l_dummy);
        txt_10 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_10 = Tpl.writeTok(txt_10, Tpl.ST_STRING("_functions.c"));
        Tpl.textFileConvertLines(txt_9, Tpl.textString(txt_10));
        txt_11 = externalFunctionIncludes(Tpl.emptyTxt, i_sc_externalFunctionIncludes);
        txt_12 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_12 = Tpl.writeTok(txt_12, Tpl.ST_STRING("_includes.h"));
        Tpl.textFile(txt_11, Tpl.textString(txt_12));
        txt_13 = recordsFile(Tpl.emptyTxt, i_fileNamePrefix, i_recordDecls);
        txt_14 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_14 = Tpl.writeTok(txt_14, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_13, Tpl.textString(txt_14));
        txt_15 = simulationHeaderFile(Tpl.emptyTxt, i_sc, a_guid);
        txt_16 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_16 = Tpl.writeTok(txt_16, Tpl.ST_STRING("_model.h"));
        Tpl.textFile(txt_15, Tpl.textString(txt_16));
        l_0__ = generateSimulationFiles(Tpl.emptyTxt, i_sc, a_guid, i_fileNamePrefix);
        ret_18 = Config.acceptParModelicaGrammar();
        txt = fun_36(txt, ret_18, i_modelInfo_functions, i_fileNamePrefix);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end translateModel;

protected function fun_38
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;
  input String in_a_fileNamePrefix;
  input String in_a_guid;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettingsOpt, in_a_fileNamePrefix, in_a_guid, in_a_simCode)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      String a_guid;
      SimCode.SimCode a_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix,
           a_guid,
           a_simCode )
      equation
        txt_0 = simulationInitFile(Tpl.emptyTxt, a_simCode, a_guid);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_init.xml"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end match;
end fun_38;

protected function fun_39
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix )
      equation
        txt_0 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING("_init.xml"));
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_init.c"));
        ret_2 = System.covertTextFileToCLiteral(Tpl.textString(txt_0), Tpl.textString(txt_1));
        txt = Tpl.writeStr(txt, Tpl.booleanString(ret_2));
      then txt;
  end match;
end fun_39;

public function translateInitFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      String i_fileNamePrefix;
      SimCode.SimCode i_sc;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      Boolean ret_3;
      String ret_2;
      Tpl.Text l_0___1;
      Tpl.Text l_0__;

    case ( txt,
           (i_sc as SimCode.SIMCODE(simulationSettingsOpt = i_simulationSettingsOpt, fileNamePrefix = i_fileNamePrefix)),
           a_guid )
      equation
        l_0__ = fun_38(Tpl.emptyTxt, i_simulationSettingsOpt, i_fileNamePrefix, a_guid, i_sc);
        ret_2 = Config.simCodeTarget();
        ret_3 = stringEq(ret_2, "JavaScript");
        l_0___1 = fun_39(Tpl.emptyTxt, ret_3, i_fileNamePrefix);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end translateInitFile;

protected function fun_41
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;
  input Tpl.Text in_a_filePrefix;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mainFunction, in_a_filePrefix, in_a_functionCode)
    local
      Tpl.Text txt;
      Tpl.Text a_filePrefix;
      SimCode.FunctionCode a_functionCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           NONE(),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_filePrefix,
           a_functionCode )
      equation
        txt_0 = functionsMakefile(Tpl.emptyTxt, a_functionCode);
        txt_1 = Tpl.writeText(Tpl.emptyTxt, a_filePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end match;
end fun_41;

protected function fun_42
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.Function> in_a_functions;
  input Option<SimCode.Function> in_a_mainFunction;
  input Tpl.Text in_a_filePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_functions, in_a_mainFunction, in_a_filePrefix)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      Option<SimCode.Function> a_mainFunction;
      Tpl.Text a_filePrefix;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_functions,
           a_mainFunction,
           a_filePrefix )
      equation
        txt_0 = functionsParModelicaKernelsFile(Tpl.emptyTxt, Tpl.textString(a_filePrefix), a_mainFunction, a_functions);
        txt_1 = Tpl.writeText(Tpl.emptyTxt, a_filePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_kernels.cl"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
      then txt;
  end match;
end fun_42;

public function translateFunctions
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_functionCode)
    local
      Tpl.Text txt;
      list<String> i_fc_externalFunctionIncludes;
      list<DAE.Exp> i_literals;
      list<SimCode.RecordDeclaration> i_extraRecordDecls;
      list<SimCode.Function> i_functions;
      SimCode.FunctionCode i_fc;
      Option<SimCode.Function> i_mainFunction;
      String i_name;
      Boolean ret_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text l_0__;
      Tpl.Text l_filePrefix;
      Tpl.Text l_staticPrototypes;

    case ( txt,
           (i_fc as SimCode.FUNCTIONCODE(name = i_name, mainFunction = i_mainFunction, functions = i_functions, extraRecordDecls = i_extraRecordDecls, literals = i_literals, externalFunctionIncludes = i_fc_externalFunctionIncludes)) )
      equation
        System.tmpTickResetIndex(0, 2);
        l_staticPrototypes = Tpl.emptyTxt;
        l_filePrefix = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_0__ = fun_41(Tpl.emptyTxt, i_mainFunction, l_filePrefix, i_fc);
        (txt_3, l_staticPrototypes) = functionsHeaderFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_mainFunction, i_functions, i_extraRecordDecls, l_staticPrototypes);
        txt_4 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_4 = Tpl.writeTok(txt_4, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_3, Tpl.textString(txt_4));
        (txt_5, l_staticPrototypes) = functionsFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_mainFunction, i_functions, i_literals, l_staticPrototypes);
        txt_6 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_6 = Tpl.writeTok(txt_6, Tpl.ST_STRING(".c"));
        Tpl.textFileConvertLines(txt_5, Tpl.textString(txt_6));
        txt_7 = externalFunctionIncludes(Tpl.emptyTxt, i_fc_externalFunctionIncludes);
        txt_8 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_8 = Tpl.writeTok(txt_8, Tpl.ST_STRING("_includes.h"));
        Tpl.textFile(txt_7, Tpl.textString(txt_8));
        txt_9 = recordsFile(Tpl.emptyTxt, Tpl.textString(l_filePrefix), i_extraRecordDecls);
        txt_10 = Tpl.writeText(Tpl.emptyTxt, l_filePrefix);
        txt_10 = Tpl.writeTok(txt_10, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_9, Tpl.textString(txt_10));
        ret_11 = Config.acceptParModelicaGrammar();
        txt = fun_42(txt, ret_11, i_functions, i_mainFunction, l_filePrefix);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateFunctions;

protected function fun_44
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<BackendDAE.TimeEvent> i_timeEvents;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), timeEvents = i_timeEvents) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Simulation code for "));
        txt = CodegenUtil.dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(". */\n"));
        txt = variableDefinitions(txt, i_modelInfo, i_timeEvents);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_44;

public function simulationHeaderFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_44(txt, a_simCode);
end simulationHeaderFile;

protected function fun_46
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_35;
      Tpl.Text txt_34;
      Tpl.Text txt_33;
      Tpl.Text txt_32;
      Tpl.Text txt_31;
      Tpl.Text txt_30;
      Tpl.Text txt_29;
      Tpl.Text txt_28;
      Tpl.Text txt_27;
      Tpl.Text txt_26;
      Tpl.Text txt_25;
      Tpl.Text txt_24;
      Tpl.Text txt_23;
      Tpl.Text txt_22;
      Tpl.Text txt_21;
      Tpl.Text l_mixheader;
      Tpl.Text txt_19;
      Tpl.Text txt_18;
      Tpl.Text txt_17;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_fileNamePrefix)),
           a_guid )
      equation
        txt_0 = simulationFile_exo(Tpl.emptyTxt, i_simCode, a_guid);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_01exo.c"));
        Tpl.textFileConvertLines(txt_0, Tpl.textString(txt_1));
        txt_2 = simulationFile_nls(Tpl.emptyTxt, i_simCode, a_guid);
        txt_3 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("_02nls.c"));
        Tpl.textFileConvertLines(txt_2, Tpl.textString(txt_3));
        txt_4 = simulationFile_lsy(Tpl.emptyTxt, i_simCode, a_guid);
        txt_5 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING("_03lsy.c"));
        Tpl.textFileConvertLines(txt_4, Tpl.textString(txt_5));
        txt_6 = simulationFile_set(Tpl.emptyTxt, i_simCode, a_guid);
        txt_7 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_7 = Tpl.writeTok(txt_7, Tpl.ST_STRING("_04set.c"));
        Tpl.textFileConvertLines(txt_6, Tpl.textString(txt_7));
        txt_8 = simulationFile_evt(Tpl.emptyTxt, i_simCode, a_guid);
        txt_9 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_9 = Tpl.writeTok(txt_9, Tpl.ST_STRING("_05evt.c"));
        Tpl.textFileConvertLines(txt_8, Tpl.textString(txt_9));
        txt_10 = simulationFile_inz(Tpl.emptyTxt, i_simCode, a_guid);
        txt_11 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_11 = Tpl.writeTok(txt_11, Tpl.ST_STRING("_06inz.c"));
        Tpl.textFileConvertLines(txt_10, Tpl.textString(txt_11));
        txt_12 = simulationFile_dly(Tpl.emptyTxt, i_simCode, a_guid);
        txt_13 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_13 = Tpl.writeTok(txt_13, Tpl.ST_STRING("_07dly.c"));
        Tpl.textFileConvertLines(txt_12, Tpl.textString(txt_13));
        txt_14 = simulationFile_bnd(Tpl.emptyTxt, i_simCode, a_guid);
        txt_15 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_15 = Tpl.writeTok(txt_15, Tpl.ST_STRING("_08bnd.c"));
        Tpl.textFileConvertLines(txt_14, Tpl.textString(txt_15));
        txt_16 = simulationFile_alg(Tpl.emptyTxt, i_simCode, a_guid);
        txt_17 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_17 = Tpl.writeTok(txt_17, Tpl.ST_STRING("_09alg.c"));
        Tpl.textFileConvertLines(txt_16, Tpl.textString(txt_17));
        txt_18 = simulationFile_asr(Tpl.emptyTxt, i_simCode, a_guid);
        txt_19 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_19 = Tpl.writeTok(txt_19, Tpl.ST_STRING("_10asr.c"));
        Tpl.textFileConvertLines(txt_18, Tpl.textString(txt_19));
        l_mixheader = Tpl.emptyTxt;
        (txt_21, l_mixheader) = simulationFile_mix(Tpl.emptyTxt, i_simCode, a_guid, l_mixheader);
        txt_22 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_22 = Tpl.writeTok(txt_22, Tpl.ST_STRING("_11mix.c"));
        Tpl.textFileConvertLines(txt_21, Tpl.textString(txt_22));
        txt_23 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_23 = Tpl.writeTok(txt_23, Tpl.ST_STRING("_11mix.h"));
        Tpl.textFile(l_mixheader, Tpl.textString(txt_23));
        txt_24 = simulationFile_jac(Tpl.emptyTxt, i_simCode, a_guid);
        txt_25 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_25 = Tpl.writeTok(txt_25, Tpl.ST_STRING("_12jac.c"));
        Tpl.textFileConvertLines(txt_24, Tpl.textString(txt_25));
        txt_26 = simulationFile_jac_header(Tpl.emptyTxt, i_simCode, a_guid);
        txt_27 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_27 = Tpl.writeTok(txt_27, Tpl.ST_STRING("_12jac.h"));
        Tpl.textFile(txt_26, Tpl.textString(txt_27));
        txt_28 = simulationFile_opt(Tpl.emptyTxt, i_simCode, a_guid);
        txt_29 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_29 = Tpl.writeTok(txt_29, Tpl.ST_STRING("_13opt.c"));
        Tpl.textFileConvertLines(txt_28, Tpl.textString(txt_29));
        txt_30 = simulationFile_opt_header(Tpl.emptyTxt, i_simCode, a_guid);
        txt_31 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_31 = Tpl.writeTok(txt_31, Tpl.ST_STRING("_13opt.h"));
        Tpl.textFile(txt_30, Tpl.textString(txt_31));
        txt_32 = simulationFile_lnz(Tpl.emptyTxt, i_simCode, a_guid);
        txt_33 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_33 = Tpl.writeTok(txt_33, Tpl.ST_STRING("_14lnz.c"));
        Tpl.textFileConvertLines(txt_32, Tpl.textString(txt_33));
        txt_34 = simulationFile(Tpl.emptyTxt, i_simCode, a_guid);
        txt_35 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_35 = Tpl.writeTok(txt_35, Tpl.ST_STRING(".c"));
        Tpl.textFileConvertLines(txt_34, Tpl.textString(txt_35));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_46;

public function generateSimulationFiles
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_46(txt, a_simCode, a_guid);
end generateSimulationFiles;

protected function fun_48
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.ExtObjInfo i_extObjInfo;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(extObjInfo = i_extObjInfo)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* External objects file */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionCallExternalObjectConstructors(txt, i_extObjInfo, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_1 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionCallExternalObjectDestructors(txt, i_extObjInfo, Tpl.textString(txt_1));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_48;

public function simulationFile_exo
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_48(txt, a_simCode);
end simulationFile_exo;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input Tpl.Text in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      Tpl.Text a_modelNamePrefixStr;
      list<SimCode.SimEqSystem> i_jacobianEquations;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           ({(i_jacobianEquations, _, _)}, _, _, _, _, _, _) :: rest,
           a_modelNamePrefixStr )
      equation
        txt = functionNonLinearResiduals(txt, i_jacobianEquations, Tpl.textString(a_modelNamePrefixStr));
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest, a_modelNamePrefixStr);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelNamePrefixStr )
      equation
        txt = lm_50(txt, rest, a_modelNamePrefixStr);
      then txt;
  end match;
end lm_50;

protected function fun_51
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      String i_simCode_fileNamePrefix;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      SimCode.SimCode i_simCode;
      Tpl.Text l_jacobianbody;
      Tpl.Text l_modelNamePrefixStr;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(jacobianMatrixes = i_jacobianMatrixes, fileNamePrefix = i_simCode_fileNamePrefix, initialEquations = i_initialEquations, parameterEquations = i_parameterEquations, allEquations = i_allEquations)) )
      equation
        l_modelNamePrefixStr = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        l_jacobianbody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                         "\n",
                                                                                         "\n"
                                                                                     }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jacobianbody = lm_50(l_jacobianbody, i_jacobianMatrixes, l_modelNamePrefixStr);
        l_jacobianbody = Tpl.popIter(l_jacobianbody);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Non Linear Systems */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* dummy REAL_ATTRIBUTE */\n",
                                    "const REAL_ATTRIBUTE dummyREAL_ATTRIBUTE = omc_dummyRealAttribute;\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_simCode_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_12jac.h\"\n",
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = functionNonLinearResiduals(txt, i_initialEquations, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = functionNonLinearResiduals(txt, i_parameterEquations, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = functionNonLinearResiduals(txt, i_allEquations, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_jacobianbody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitialNonLinearSystems(txt, i_initialEquations, i_parameterEquations, i_allEquations, i_jacobianMatrixes, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_51;

public function simulationFile_nls
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_51(txt, a_simCode);
end simulationFile_nls;

protected function fun_53
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      String i_simCode_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_simCode_fileNamePrefix, initialEquations = i_initialEquations, parameterEquations = i_parameterEquations, allEquations = i_allEquations, jacobianMatrixes = i_jacobianMatrixes)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Linear Systems */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeStr(txt, i_simCode_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_12jac.h\"\n",
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionSetupLinearSystems(txt, i_initialEquations, i_parameterEquations, i_allEquations, i_jacobianMatrixes, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_1 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionInitialLinearSystems(txt, i_initialEquations, i_parameterEquations, i_allEquations, i_jacobianMatrixes, Tpl.textString(txt_1));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_53;

public function simulationFile_lsy
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_53(txt, a_simCode);
end simulationFile_lsy;

protected function fun_55
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> i_stateSets;
      String i_simCode_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_simCode_fileNamePrefix, stateSets = i_stateSets)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Initial State Set */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeStr(txt, i_simCode_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_11mix.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_simCode_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_12jac.h\"\n",
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionInitialStateSets(txt, i_stateSets, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_55;

public function simulationFile_set
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_55(txt, a_simCode);
end simulationFile_set;

protected function fun_57
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> i_discreteModelVars;
      list<BackendDAE.ZeroCrossing> i_relations;
      list<SimCode.SimEqSystem> i_equationsForZeroCrossings;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<BackendDAE.TimeEvent> i_timeEvents;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(timeEvents = i_timeEvents, zeroCrossings = i_zeroCrossings, equationsForZeroCrossings = i_equationsForZeroCrossings, relations = i_relations, discreteModelVars = i_discreteModelVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Events: Sample, Zero Crossings, Relations, Discrete Changes */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionInitSample(txt, i_timeEvents, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_1 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionZeroCrossing(txt, i_zeroCrossings, i_equationsForZeroCrossings, Tpl.textString(txt_1));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_2 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionRelations(txt, i_relations, Tpl.textString(txt_2));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_3 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionCheckForDiscreteChanges(txt, i_discreteModelVars, Tpl.textString(txt_3));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_57;

public function simulationFile_evt
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_57(txt, a_simCode);
end simulationFile_evt;

protected function fun_59
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_removedInitialEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      Boolean i_useSymbolicInitialization;
      list<SimCode.SimEqSystem> i_residualEquations;
      String i_simCode_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_simCode_fileNamePrefix, residualEquations = i_residualEquations, useSymbolicInitialization = i_useSymbolicInitialization, initialEquations = i_initialEquations, removedInitialEquations = i_removedInitialEquations, parameterEquations = i_parameterEquations, allEquations = i_allEquations, jacobianMatrixes = i_jacobianMatrixes)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Initialization */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeStr(txt, i_simCode_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_11mix.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_simCode_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_12jac.h\"\n",
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionInitialResidual(txt, i_residualEquations, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt_1 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionInitialEquations(txt, i_useSymbolicInitialization, i_initialEquations, Tpl.textString(txt_1));
        txt = Tpl.softNewLine(txt);
        txt_2 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionRemovedInitialEquations(txt, i_useSymbolicInitialization, i_removedInitialEquations, Tpl.textString(txt_2));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_3 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionInitialMixedSystems(txt, i_initialEquations, i_parameterEquations, i_allEquations, i_jacobianMatrixes, Tpl.textString(txt_3));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_59;

public function simulationFile_inz
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_59(txt, a_simCode);
end simulationFile_inz;

protected function fun_61
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.DelayedExpression i_delayedExps;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(delayedExps = i_delayedExps)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Delay */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionStoreDelayed(txt, i_delayedExps, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_61;

public function simulationFile_dly
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_61(txt, a_simCode);
end simulationFile_dly;

protected function fun_63
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Equations */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_63;

public function simulationFile_eqs
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_63(txt, a_simCode);
end simulationFile_eqs;

protected function fun_65
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_maxValueEquations;
      list<SimCode.SimEqSystem> i_minValueEquations;
      list<SimCode.SimEqSystem> i_nominalValueEquations;
      list<SimCode.SimEqSystem> i_startValueEquations;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(startValueEquations = i_startValueEquations, nominalValueEquations = i_nominalValueEquations, minValueEquations = i_minValueEquations, maxValueEquations = i_maxValueEquations, parameterEquations = i_parameterEquations)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* update bound parameters and variable attributes (start, nominal, min, max) */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionUpdateBoundVariableAttributes(txt, i_startValueEquations, i_nominalValueEquations, i_minValueEquations, i_maxValueEquations, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_1 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionUpdateBoundParameters(txt, i_parameterEquations, Tpl.textString(txt_1));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_65;

public function simulationFile_bnd
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_65(txt, a_simCode);
end simulationFile_bnd;

protected function fun_67
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> i_algebraicEquations;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(algebraicEquations = i_algebraicEquations)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Algebraic */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionAlgebraic(txt, i_algebraicEquations, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_67;

public function simulationFile_alg
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_67(txt, a_simCode);
end simulationFile_alg;

protected function fun_69
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_algorithmAndEquationAsserts;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(algorithmAndEquationAsserts = i_algorithmAndEquationAsserts)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Asserts */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionAssertsforCheck(txt, i_algorithmAndEquationAsserts, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_69;

public function simulationFile_asr
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_69(txt, a_simCode);
end simulationFile_asr;

protected function fun_71
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_header;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_header;
algorithm
  (out_txt, out_a_header) :=
  match(in_txt, in_a_simCode, in_a_header)
    local
      Tpl.Text txt;
      Tpl.Text a_header;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      String i_simCode_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text l_modelNamePrefixStr;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_simCode_fileNamePrefix, initialEquations = i_initialEquations, parameterEquations = i_parameterEquations, allEquations = i_allEquations, jacobianMatrixes = i_jacobianMatrixes)),
           a_header )
      equation
        l_modelNamePrefixStr = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Mixed Systems */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeStr(txt, i_simCode_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_11mix.h\"\n"));
        (txt, a_header) = functionSetupMixedSystems(txt, i_initialEquations, i_parameterEquations, i_allEquations, i_jacobianMatrixes, a_header, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_header);

    case ( txt,
           _,
           a_header )
      then (txt, a_header);
  end match;
end fun_71;

public function simulationFile_mix
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;
  input Tpl.Text a_header;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_header;
algorithm
  (out_txt, out_a_header) := fun_71(txt, a_simCode, a_header);
end simulationFile_mix;

protected function fun_73
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_fileNamePrefix, jacobianMatrixes = i_jacobianMatrixes)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Jacobians */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_12jac.h\"\n"));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionAnalyticJacobians(txt, i_jacobianMatrixes, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_73;

public function simulationFile_jac
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_73(txt, a_simCode);
end simulationFile_jac;

protected function fun_75
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(jacobianMatrixes = i_jacobianMatrixes)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Jacobians */\n"));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = variableDefinitionsJacobians(txt, i_jacobianMatrixes, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_75;

public function simulationFile_jac_header
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_75(txt, a_simCode);
end simulationFile_jac_header;

protected function fun_77
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ClassAttributes> i_classAttributes;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text l_modelNamePrefixStr;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_fileNamePrefix, classAttributes = i_classAttributes)) )
      equation
        l_modelNamePrefixStr = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Optimization */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_12jac.h\"\n",
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = optimizationComponents(txt, i_classAttributes, i_simCode, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_77;

public function simulationFile_opt
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_77(txt, a_simCode);
end simulationFile_opt;

protected function fun_79
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      Tpl.Text l_modelNamePrefixStr;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)) )
      equation
        l_modelNamePrefixStr = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "  extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "mayer");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data, modelica_real** res, short*);\n",
                                    "int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "lagrange");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data, modelica_real** res, short *, short *);\n",
                                    "int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "pickUpBoundsForInputsInOptimization");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(DATA* data, modelica_real* min, modelica_real* max, modelica_real*nominal, modelica_boolean *useNominal, char ** name, modelica_real * start, modelica_real * startTimeOpt);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_79;

public function simulationFile_opt_header
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_79(txt, a_simCode);
end simulationFile_opt_header;

protected function fun_81
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.ModelInfo i_modelInfo;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = i_modelInfo)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Linearization */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionlinearmodel(txt, i_modelInfo, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_81;

public function simulationFile_lnz
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input String a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_81(txt, a_simCode);
end simulationFile_lnz;

protected function fun_83
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_INIT();"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "mmc_init_nogc();\n",
                                    "omc_alloc_interface = omc_alloc_interface_pooled;"
                                }, false));
      then txt;
  end match;
end fun_83;

protected function fun_84
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Boolean ret_1;
      String ret_0;

    case ( txt,
           false )
      equation
        ret_0 = Config.simCodeTarget();
        ret_1 = stringEq(ret_0, "JavaScript");
        txt = fun_83(txt, ret_1);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "mmc_init_nogc();\n",
                                    "omc_alloc_interface = omc_alloc_interface_pooled;"
                                }, false));
      then txt;
  end match;
end fun_84;

protected function fun_85
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Boolean ret_0;

    case ( txt,
           false )
      equation
        ret_0 = Flags.isSet(Flags.PARMODAUTO);
        txt = fun_84(txt, ret_0);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "mmc_init_nogc();\n",
                                    "omc_alloc_interface = omc_alloc_interface_pooled;"
                                }, false));
      then txt;
  end match;
end fun_85;

protected function fun_86
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("PM_Model_init(\""));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", &simulation_data, functionODE_systems);"));
      then txt;
  end match;
end fun_86;

protected function fun_87
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("2"));
      then txt;
  end match;
end fun_87;

protected function fun_88
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Boolean ret_0;

    case ( txt,
           false )
      equation
        ret_0 = Config.profileAll();
        txt = fun_87(txt, ret_0);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_88;

protected function fun_89
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Boolean ret_0;

    case ( txt,
           false )
      equation
        ret_0 = Config.profileSome();
        txt = fun_88(txt, ret_0);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("5"));
      then txt;
  end match;
end fun_89;

protected function fun_90
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettingsOpt)
    local
      Tpl.Text txt;
      String i_settings_method;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(method = i_settings_method)) )
      equation
        txt = Tpl.writeStr(txt, i_settings_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_90;

protected function fun_91
  input Tpl.Text in_txt;
  input Boolean in_a_useSymbolicInitialization;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_useSymbolicInitialization)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_91;

protected function fun_92
  input Tpl.Text in_txt;
  input Boolean in_a_useHomotopy;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_useHomotopy)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_92;

protected function fun_93
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("terminateHpcOmThreads();"));
      then txt;
  end match;
end fun_93;

protected function fun_94
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dump_times();"));
      then txt;
  end match;
end fun_94;

public function simulationFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.DelayedExpression i_delayedExps;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      Boolean i_useHomotopy;
      Boolean i_useSymbolicInitialization;
      String i_simCode_fileNamePrefix;
      Option<HpcOmSimCode.Schedule> i_hpcOmSchedule;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.ModelInfo i_modelInfo;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Boolean ret_13;
      Boolean ret_12;
      Tpl.Text txt_11;
      Boolean ret_10;
      Tpl.Text l_mainBody;
      Boolean ret_8;
      Tpl.Text l_pminit;
      Boolean ret_6;
      Boolean ret_5;
      Boolean ret_4;
      String ret_3;
      Boolean ret_2;
      Tpl.Text l_mainInit;
      Tpl.Text l_modelNamePrefixStr;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = (i_simCode_fileNamePrefix as i_fileNamePrefix), modelInfo = i_modelInfo, allEquations = i_allEquations, whenClauses = i_whenClauses, odeEquations = i_odeEquations, simulationSettingsOpt = i_simulationSettingsOpt, hpcOmSchedule = i_hpcOmSchedule, useSymbolicInitialization = i_useSymbolicInitialization, useHomotopy = i_useHomotopy, jacobianMatrixes = i_jacobianMatrixes, delayedExps = i_delayedExps)),
           a_guid )
      equation
        l_modelNamePrefixStr = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        ret_2 = Flags.isSet(Flags.HPCOM);
        ret_3 = Flags.getConfigString(Flags.HPCOM_CODE);
        ret_4 = stringEq(ret_3, "pthreads_spin");
        ret_5 = boolNot(ret_4);
        ret_6 = boolAnd(ret_2, ret_5);
        l_mainInit = fun_85(Tpl.emptyTxt, ret_6);
        l_mainInit = Tpl.writeTok(l_mainInit, Tpl.ST_STRING("omc_alloc_interface.init();"));
        ret_8 = Flags.isSet(Flags.PARMODAUTO);
        l_pminit = fun_86(Tpl.emptyTxt, ret_8, i_fileNamePrefix);
        l_mainBody = symbolName(Tpl.emptyTxt, Tpl.textString(l_modelNamePrefixStr), "setupDataStruc");
        l_mainBody = Tpl.writeTok(l_mainBody, Tpl.ST_LINE("(&simulation_data);\n"));
        l_mainBody = Tpl.writeText(l_mainBody, l_pminit);
        l_mainBody = Tpl.softNewLine(l_mainBody);
        l_mainBody = Tpl.writeTok(l_mainBody, Tpl.ST_STRING_LIST({
                                                  "simulation_data.threadData = threadData;\n",
                                                  "res = _main_SimulationRuntime(argc, argv, &simulation_data);"
                                              }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Main Simulation File */\n"));
        txt = simulationFileHeader(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#define prefixedName_performSimulation "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "performSimulation");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include <simulation/solver/perform_simulation.c>\n",
                                    "\n",
                                    "/* dummy VARINFO and FILEINFO */\n",
                                    "const FILE_INFO dummyFILE_INFO = omc_dummyFileInfo;\n",
                                    "const VAR_INFO dummyVAR_INFO = omc_dummyVarInfo;\n",
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "int measure_time_flag = "
                                }, false));
        ret_10 = Config.profileHtml();
        txt = fun_89(txt, ret_10);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
        txt = functionInput(txt, i_modelInfo, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOutput(txt, i_modelInfo, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionDAE(txt, i_allEquations, i_whenClauses, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt_11 = fun_90(Tpl.emptyTxt, i_simulationSettingsOpt);
        (txt, txt_11) = functionODE(txt, i_odeEquations, txt_11, i_hpcOmSchedule, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* forward the main in the simulation runtime */\n",
                                    "extern int _main_SimulationRuntime(int argc, char**argv, DATA *data);\n",
                                    "\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_simCode_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_12jac.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_simCode_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_13opt.h\"\n",
                                    "extern void "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "callExternalObjectConstructors");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern void "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "callExternalObjectDestructors");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *_data);\n",
                                    "extern void "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialNonLinearSystem");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int nNonLinearSystems, NONLINEAR_SYSTEM_DATA *data);\n",
                                    "extern void "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialLinearSystem");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int nLinearSystems, LINEAR_SYSTEM_DATA *data);\n",
                                    "extern void "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialMixedSystem");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int nMixedSystems, MIXED_SYSTEM_DATA *data);\n",
                                    "extern void "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initializeStateSets");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int nStateSets, STATE_SET_DATA* statesetData, DATA *data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionAlgebraics");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_storeDelayed");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "updateBoundVariableAttributes");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern const char* "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialResidualDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initial_residual");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data, double* initialResiduals);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionInitialEquations");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionRemovedInitialEquations");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "updateBoundParameters");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "checkForAsserts");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_ZeroCrossingsEquations");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_ZeroCrossings");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data, double* gout);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_updateRelations");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data, int evalZeroCross);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "checkForDiscreteChanges");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern const char* "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "zeroCrossingDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int i, int **out_EquationIndexes);\n",
                                    "extern const char* "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "relationDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int i);\n",
                                    "extern void "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_initSample");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianG");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianA");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianB");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianC");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianD");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacG_column");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacA_column");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacB_column");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacC_column");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacD_column");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* data);\n",
                                    "extern const char* "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "linear_model_frame");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "mayer");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data, modelica_real** res, short *);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "lagrange");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data, modelica_real** res, short *, short *);\n",
                                    "extern int "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "pickUpBoundsForInputsInOptimization");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data, modelica_real* min, modelica_real* max, modelica_real*nominal, modelica_boolean *useNominal, char ** name, modelica_real * start, modelica_real * startTimeOpt);\n",
                                    "\n",
                                    "struct OpenModelicaGeneratedFunctionCallbacks "
                                }, false));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "callback");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int (*)(DATA *, void *)) "));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "performSimulation");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "callExternalObjectConstructors");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "callExternalObjectDestructors");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialNonLinearSystem");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialLinearSystem");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialMixedSystem");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initializeStateSets");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionODE");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionAlgebraics");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionDAE");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "input_function");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "input_function_init");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "output_function");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_storeDelayed");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "updateBoundVariableAttributes");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialResidualDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initial_residual");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = fun_91(txt, i_useSymbolicInitialization);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* useSymbolicInitialization */,\n"));
        txt = fun_92(txt, i_useHomotopy);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* useHomotopy */,\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionInitialEquations");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionRemovedInitialEquations");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "updateBoundParameters");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "checkForAsserts");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_ZeroCrossingsEquations");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_ZeroCrossings");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_updateRelations");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "checkForDiscreteChanges");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "zeroCrossingDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "relationDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "function_initSample");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "INDEX_JAC_G");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "INDEX_JAC_A");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "INDEX_JAC_B");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "INDEX_JAC_C");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "INDEX_JAC_D");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianG");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianA");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianB");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianC");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "initialAnalyticJacobianD");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacG_column");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacA_column");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacB_column");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacC_column");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "functionJacD_column");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "linear_model_frame");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "mayer");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "lagrange");
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",\n"));
        txt = symbolName(txt, Tpl.textString(l_modelNamePrefixStr), "pickUpBoundsForInputsInOptimization");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "};\n",
                                    "\n"
                                }, true));
        txt = functionInitializeDataStruc(txt, i_modelInfo, i_fileNamePrefix, a_guid, i_allEquations, i_jacobianMatrixes, i_delayedExps, Tpl.textString(l_modelNamePrefixStr));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif\n",
                                    "\n",
                                    "static int rml_execution_failed()\n",
                                    "{\n",
                                    "  fflush(NULL);\n",
                                    "  fprintf(stderr, \"Execution failed!\\n\");\n",
                                    "  fflush(NULL);\n",
                                    "  return 1;\n",
                                    "}\n",
                                    "\n",
                                    "#if defined(threadData)\n",
                                    "#undef threadData\n",
                                    "#endif\n",
                                    "/* call the simulation runtime main from our main! */\n",
                                    "int main(int argc, char**argv)\n",
                                    "{\n",
                                    "  int res;\n",
                                    "  DATA simulation_data;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_mainInit);
        txt = Tpl.softNewLine(txt);
        (txt, l_mainBody) = mainTop(txt, l_mainBody, "https://trac.openmodelica.org/OpenModelica/newticket");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_12 = Flags.isSet(Flags.HPCOM);
        txt = fun_93(txt, ret_12);
        txt = Tpl.softNewLine(txt);
        ret_13 = Flags.isSet(Flags.PARMODAUTO);
        txt = fun_94(txt, ret_13);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fflush(NULL);\n",
                                    "EXIT(res);\n",
                                    "return res;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationFile;

public function mainTop
  input Tpl.Text txt;
  input Tpl.Text a_mainBody;
  input String a_url;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_mainBody;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "{\n",
                                   "  MMC_TRY_TOP()\n",
                                   "\n",
                                   "  MMC_TRY_STACK()\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, a_mainBody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "MMC_ELSE()\n",
                                       "rml_execution_failed();\n",
                                       "fprintf(stderr, \"Stack overflow detected and was not caught.\\nSend us a bug report at "
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_url);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\\n    Include the following trace:\\n\");\n",
                                       "printStacktraceMessages();\n",
                                       "fflush(NULL);\n",
                                       "return 1;\n",
                                       "MMC_CATCH_STACK()\n",
                                       "\n",
                                       "MMC_CATCH_TOP(return rml_execution_failed());\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
  out_a_mainBody := a_mainBody;
end mainTop;

public function symbolName
  input Tpl.Text txt;
  input String a_modelNamePrefix;
  input String a_symbolName;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeStr(txt, a_modelNamePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_"));
  out_txt := Tpl.writeStr(out_txt, a_symbolName);
end symbolName;

protected function fun_98
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"ParModelica/auto/om_pm_interface.hpp\""));
      then txt;
  end match;
end fun_98;

protected function fun_99
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"util/omc_spinlock.h\""));
      then txt;
  end match;
end fun_99;

protected function fun_100
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define HPCOM"));
      then txt;
  end match;
end fun_100;

public function simulationFileHeader
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      Boolean ret_4;
      Boolean ret_3;
      String ret_2;
      Boolean ret_1;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(vars = _), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Simulation code for "));
        txt = CodegenUtil.dotPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
        ret_0 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ". */\n",
                                    "\n",
                                    "#include \"openmodelica.h\"\n",
                                    "#include \"openmodelica_func.h\"\n",
                                    "#include \"simulation_data.h\"\n",
                                    "#include \"simulation/simulation_info_xml.h\"\n",
                                    "#include \"simulation/simulation_runtime.h\"\n",
                                    "#include \"util/omc_error.h\"\n",
                                    "#include \"simulation/solver/model_help.h\"\n",
                                    "#include \"simulation/solver/delay.h\"\n",
                                    "#include \"simulation/solver/linearSystem.h\"\n",
                                    "#include \"simulation/solver/nonlinearSystem.h\"\n",
                                    "#include \"simulation/solver/mixedSystem.h\"\n",
                                    "\n",
                                    "#include <assert.h>\n",
                                    "#include <string.h>\n",
                                    "\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_model.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_literals.h\"\n",
                                    "\n"
                                }, true));
        ret_1 = Flags.isSet(Flags.PARMODAUTO);
        txt = fun_98(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_2 = Flags.getConfigString(Flags.HPCOM_CODE);
        ret_3 = stringEq(ret_2, "pthreads_spin");
        txt = fun_99(txt, ret_3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_4 = Flags.isSet(Flags.HPCOM);
        txt = fun_100(txt, ret_4);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#if defined(HPCOM) && !defined(_OPENMP)\n",
                                    "  #error \"HPCOM requires OpenMP or the results are wrong\"\n",
                                    "#endif\n",
                                    "#if defined(_OPENMP)\n",
                                    "  #include <omp.h>\n",
                                    "#else\n",
                                    "  /* dummy omp defines */\n",
                                    "  #define omp_get_max_threads() 1\n",
                                    "#endif\n",
                                    "\n",
                                    "#define threadData data->threadData\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationFileHeader;

protected function fun_102
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_delayed)
    local
      Tpl.Text txt;
      Integer i_maxDelayedIndex;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(maxDelayedIndex = i_maxDelayedIndex) )
      equation
        txt = Tpl.writeStr(txt, intString(i_maxDelayedIndex));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_102;

protected function fun_103
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_fileNamePrefix;
  input String in_a_guid;
  input SimCode.DelayedExpression in_a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_fileNamePrefix, in_a_guid, in_a_delayed)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;
      String a_guid;
      SimCode.DelayedExpression a_delayed;
      Integer i_varInfo_numJacobians;
      Integer i_varInfo_numStateSets;
      Integer i_varInfo_numNonLinearSystems;
      Integer i_varInfo_numLinearSystems;
      Integer i_varInfo_numMixedSystems;
      Integer i_varInfo_numEquations;
      list<SimCode.Function> i_functions;
      Integer i_varInfo_numExternalObjects;
      Integer i_varInfo_numInitialResiduals;
      Integer i_varInfo_numInitialAlgorithms;
      Integer i_varInfo_numInitialEquations;
      Integer i_varInfo_numMathEventFunctions;
      Integer i_varInfo_numRelations;
      Integer i_varInfo_numTimeEvents;
      Integer i_varInfo_numZeroCrossings;
      Integer i_varInfo_numStringAliasVars;
      Integer i_varInfo_numBoolAliasVars;
      Integer i_varInfo_numIntAliasVars;
      Integer i_varInfo_numAlgAliasVars;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numStringParamVars;
      Integer i_varInfo_numBoolParams;
      Integer i_varInfo_numIntParams;
      Integer i_varInfo_numParams;
      Integer i_varInfo_numStringAlgVars;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numOptimizeFinalConstraints;
      Integer i_varInfo_numOptimizeConstraints;
      Integer i_varInfo_numDiscreteReal;
      Integer i_varInfo_numAlgVars;
      Integer i_varInfo_numStateVars;
      String i_directory;
      Absyn.Path i_name;
      Integer ret_0;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numAlgVars = i_varInfo_numAlgVars, numDiscreteReal = i_varInfo_numDiscreteReal, numOptimizeConstraints = i_varInfo_numOptimizeConstraints, numOptimizeFinalConstraints = i_varInfo_numOptimizeFinalConstraints, numIntAlgVars = i_varInfo_numIntAlgVars, numBoolAlgVars = i_varInfo_numBoolAlgVars, numStringAlgVars = i_varInfo_numStringAlgVars, numParams = i_varInfo_numParams, numIntParams = i_varInfo_numIntParams, numBoolParams = i_varInfo_numBoolParams, numStringParamVars = i_varInfo_numStringParamVars, numInVars = i_varInfo_numInVars, numOutVars = i_varInfo_numOutVars, numAlgAliasVars = i_varInfo_numAlgAliasVars, numIntAliasVars = i_varInfo_numIntAliasVars, numBoolAliasVars = i_varInfo_numBoolAliasVars, numStringAliasVars = i_varInfo_numStringAliasVars, numZeroCrossings = i_varInfo_numZeroCrossings, numTimeEvents = i_varInfo_numTimeEvents, numRelations = i_varInfo_numRelations, numMathEventFunctions = i_varInfo_numMathEventFunctions, numInitialEquations = i_varInfo_numInitialEquations, numInitialAlgorithms = i_varInfo_numInitialAlgorithms, numInitialResiduals = i_varInfo_numInitialResiduals, numExternalObjects = i_varInfo_numExternalObjects, numEquations = i_varInfo_numEquations, numMixedSystems = i_varInfo_numMixedSystems, numLinearSystems = i_varInfo_numLinearSystems, numNonLinearSystems = i_varInfo_numNonLinearSystems, numStateSets = i_varInfo_numStateSets, numJacobians = i_varInfo_numJacobians), name = i_name, directory = i_directory, functions = i_functions),
           a_fileNamePrefix,
           a_guid,
           a_delayed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->modelData.modelName = \""));
        txt = CodegenUtil.dotPath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "data->modelData.modelFilePrefix = \""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "data->modelData.resultFileName = NULL;\n",
                                    "data->modelData.modelDir = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "data->modelData.modelGUID = \"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\";\n",
                                    "#ifdef OPENMODELICA_XML_FROM_FILE_AT_RUNTIME\n",
                                    "data->modelData.initXMLData = NULL;\n",
                                    "data->modelData.modelDataXml.infoXMLData = NULL;\n",
                                    "#else\n",
                                    "data->modelData.initXMLData =\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_init.c\"\n",
                                    ";\n",
                                    "data->modelData.modelDataXml.infoXMLData =\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_info.c\"\n",
                                    ";\n",
                                    "#endif\n",
                                    "\n",
                                    "data->modelData.nStates = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesReal = 2*"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numDiscreteReal));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOptimizeConstraints));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOptimizeFinalConstraints));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nDiscreteReal = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numDiscreteReal));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesInteger = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesBoolean = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nVariablesString = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersReal = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersInteger = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersBoolean = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nParametersString = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInputVars = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nOutputVars = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "data->modelData.nAliasReal = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nAliasInteger = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nAliasBoolean = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nAliasString = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "data->modelData.nZeroCrossings = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nSamples = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nRelations = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numRelations));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nMathEvents = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numMathEventFunctions));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInitEquations = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInitialEquations));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInitAlgorithms = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInitialAlgorithms));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nInitResiduals = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInitialResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";    /* data->modelData.nInitEquations + data->modelData.nInitAlgorithms */\n",
                                    "data->modelData.nExtObjs = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.modelDataXml.fileName = \""
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_info.xml\";\n",
                                    "data->modelData.modelDataXml.modelInfoXmlLength = 0;\n",
                                    "data->modelData.modelDataXml.nFunctions = "
                                }, false));
        ret_0 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.modelDataXml.nProfileBlocks = 0;\n",
                                    "data->modelData.modelDataXml.nEquations = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numEquations));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nMixedSystems = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numMixedSystems));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nLinearSystems = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numLinearSystems));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nNonLinearSystems = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numNonLinearSystems));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nStateSets = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateSets));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nJacobians = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numJacobians));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nOptimizeConstraints = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOptimizeConstraints));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.nOptimizeFinalConstraints = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOptimizeFinalConstraints));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "data->modelData.nDelayExpressions = "
                                }, false));
        txt = fun_102(txt, a_delayed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_103;

public function populateModelInfo
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input String a_fileNamePrefix;
  input String a_guid;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.JacobianMatrix> a_symJacs;
  input SimCode.DelayedExpression a_delayed;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_103(txt, a_modelInfo, a_fileNamePrefix, a_guid, a_delayed);
end populateModelInfo;

public function functionInitializeDataStruc
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input String a_fileNamePrefix;
  input String a_guid;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.JacobianMatrix> a_symJacs;
  input SimCode.DelayedExpression a_delayed;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("void "));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "setupDataStruc");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n",
                                       "  assertStreamPrint(threadData,0!=data, \"Error while initialize Data\");\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("data->callback = &"));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "callback");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(";\n"));
  out_txt := populateModelInfo(out_txt, a_modelInfo, a_fileNamePrefix, a_guid, a_allEquations, a_symJacs, a_delayed);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitializeDataStruc;

public function functionSimProfDef
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Integer in_a_value;
  input Tpl.Text in_a_reverseProf;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reverseProf;
algorithm
  (out_txt, out_a_reverseProf) :=
  match(in_txt, in_a_eq, in_a_value, in_a_reverseProf)
    local
      Tpl.Text txt;
      Integer a_value;
      Tpl.Text a_reverseProf;
      Integer i_index;

    case ( txt,
           SimCode.SES_MIXED(index = i_index),
           a_value,
           a_reverseProf )
      equation
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("data->modelData.equationInfo_reverse_prof_index["));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(a_value));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("] = "));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(i_index));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING(";"));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_value));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_reverseProf);

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_value,
           a_reverseProf )
      equation
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("data->modelData.equationInfo_reverse_prof_index["));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(a_value));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("] = "));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(i_index));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING(";"));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_value));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_reverseProf);

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_value,
           a_reverseProf )
      equation
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("data->modelData.equationInfo_reverse_prof_index["));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(a_value));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING("] = "));
        a_reverseProf = Tpl.writeStr(a_reverseProf, intString(i_index));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_STRING(";"));
        a_reverseProf = Tpl.writeTok(a_reverseProf, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define SIM_PROF_EQ_"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(a_value));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_reverseProf);

    case ( txt,
           _,
           _,
           a_reverseProf )
      then (txt, a_reverseProf);
  end match;
end functionSimProfDef;

protected function lm_107
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_107(txt, rest);
      then txt;
  end match;
end lm_107;

protected function lm_108
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = globalDataVarDefine(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_108(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_108;

protected function lm_109
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = globalDataVarDefine(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_109(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_109;

protected function lm_110
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numAlgVars;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numAlgVars, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numAlgVars;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numAlgVars,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        ret_1 = intAdd(ret_0, a_numAlgVars);
        txt = globalDataVarDefine(txt, i_var, "realVars", ret_1);
        txt = Tpl.nextIter(txt);
        txt = lm_110(txt, rest, a_numAlgVars, a_numStateVars);
      then txt;
  end match;
end lm_110;

protected function lm_111
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numDiscreteReal;
  input Integer in_a_numAlgVars;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numDiscreteReal, in_a_numAlgVars, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numDiscreteReal;
      Integer a_numAlgVars;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numDiscreteReal,
           a_numAlgVars,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        ret_1 = intAdd(ret_0, a_numAlgVars);
        ret_2 = intAdd(ret_1, a_numDiscreteReal);
        txt = globalDataVarDefine(txt, i_var, "realVars", ret_2);
        txt = Tpl.nextIter(txt);
        txt = lm_111(txt, rest, a_numDiscreteReal, a_numAlgVars, a_numStateVars);
      then txt;
  end match;
end lm_111;

protected function lm_112
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numOptimizeConstraints;
  input Integer in_a_numDiscreteReal;
  input Integer in_a_numAlgVars;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numOptimizeConstraints, in_a_numDiscreteReal, in_a_numAlgVars, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numOptimizeConstraints;
      Integer a_numDiscreteReal;
      Integer a_numAlgVars;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numOptimizeConstraints,
           a_numDiscreteReal,
           a_numAlgVars,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        ret_1 = intAdd(ret_0, a_numAlgVars);
        ret_2 = intAdd(a_numDiscreteReal, a_numOptimizeConstraints);
        ret_3 = intAdd(ret_1, ret_2);
        txt = globalDataVarDefine(txt, i_var, "realVars", ret_3);
        txt = Tpl.nextIter(txt);
        txt = lm_112(txt, rest, a_numOptimizeConstraints, a_numDiscreteReal, a_numAlgVars, a_numStateVars);
      then txt;
  end match;
end lm_112;

protected function lm_113
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_113(txt, rest);
      then txt;
  end match;
end lm_113;

protected function lm_114
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "extObjs");
        txt = Tpl.nextIter(txt);
        txt = lm_114(txt, rest);
      then txt;
  end match;
end lm_114;

protected function lm_115
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_115(txt, rest);
      then txt;
  end match;
end lm_115;

protected function lm_116
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_116(txt, rest);
      then txt;
  end match;
end lm_116;

protected function lm_117
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_117(txt, rest);
      then txt;
  end match;
end lm_117;

protected function lm_118
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_118(txt, rest);
      then txt;
  end match;
end lm_118;

protected function lm_119
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataVarDefine(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_119(txt, rest);
      then txt;
  end match;
end lm_119;

protected function lm_120
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = globalDataParDefine(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_120(txt, rest);
      then txt;
  end match;
end lm_120;

protected function fun_121
  input Tpl.Text in_txt;
  input BackendDAE.TimeEvent in_a_timeEvent;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_timeEvent)
    local
      Tpl.Text txt;
      Integer i_index;
      Integer ret_0;

    case ( txt,
           BackendDAE.SAMPLE_TIME_EVENT(index = i_index) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define $P$sample"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo.samples["));
        ret_0 = intSub(i_index, 1);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_121;

protected function lm_122
  input Tpl.Text in_txt;
  input list<BackendDAE.TimeEvent> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.TimeEvent> rest;
      BackendDAE.TimeEvent i_timeEvent;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_timeEvent :: rest )
      equation
        txt = fun_121(txt, i_timeEvent);
        txt = Tpl.nextIter(txt);
        txt = lm_122(txt, rest);
      then txt;
  end match;
end lm_122;

protected function lm_123
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Integer x_i0;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = functionName(txt, i_fn, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_index "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_123(txt, rest);
      then txt;
  end match;
end lm_123;

protected function fun_124
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input list<BackendDAE.TimeEvent> in_a_timeEvents;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_timeEvents)
    local
      Tpl.Text txt;
      list<BackendDAE.TimeEvent> a_timeEvents;
      list<SimCode.Function> i_functions;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_extObjVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      Integer i_numOptimizeConstraints;
      list<SimCodeVar.SimVar> i_vars_realOptimizeFinalConstraintsVars;
      Integer i_numDiscreteReal;
      list<SimCodeVar.SimVar> i_vars_realOptimizeConstraintsVars;
      Integer i_numAlgVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_numStateVars, numAlgVars = i_numAlgVars, numDiscreteReal = i_numDiscreteReal, numOptimizeConstraints = i_numOptimizeConstraints), vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, realOptimizeConstraintsVars = i_vars_realOptimizeConstraintsVars, realOptimizeFinalConstraintsVars = i_vars_realOptimizeFinalConstraintsVars, paramVars = i_vars_paramVars, extObjVars = i_vars_extObjVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars), functions = i_functions),
           a_timeEvents )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#define time data->localData[0]->timeValue\n",
                                    "\n",
                                    "/* States */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_107(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* StatesDerivatives */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_108(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Non Discrete Real Algebraic Vars */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_109(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Discrete Real Algebraic Vars */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_110(txt, i_vars_discreteAlgVars, i_numAlgVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Nonlinear Constraints For Dyn. Optimization */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_111(txt, i_vars_realOptimizeConstraintsVars, i_numDiscreteReal, i_numAlgVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Nonlinear Final Constraints For Dyn. Optimization */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_112(txt, i_vars_realOptimizeFinalConstraintsVars, i_numOptimizeConstraints, i_numDiscreteReal, i_numAlgVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Parameter */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_113(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* External Objects */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_114(txt, i_vars_extObjVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Integer Vars */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_115(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Integer Parameter */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_116(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Boolean Vars */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_117(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic Boolean Parameters */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_118(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic String Variables */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_119(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraic String Parameter */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_120(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* sample */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_122(txt, a_timeEvents);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_123(txt, i_functions);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_124;

public function variableDefinitions
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input list<BackendDAE.TimeEvent> a_timeEvents;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1000);
  out_txt := fun_124(txt, a_modelInfo, a_timeEvents);
end variableDefinitions;

protected function lm_126
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;
      Absyn.Info ret_1;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = functionName(txt, i_fn, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",{"));
        ret_1 = SimCodeUtil.functionInfo(i_fn);
        txt = infoArgs(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}}"));
        txt = Tpl.nextIter(txt);
        txt = lm_126(txt, rest);
      then txt;
  end match;
end lm_126;

protected function fun_127
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_items;
      Integer ret_0;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct FUNCTION_INFO funcInfo[1] = {{-1,\"\",omc_dummyFileInfo}};"));
      then txt;

    case ( txt,
           i_items )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const struct FUNCTION_INFO funcInfo["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_126(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_127;

public function globalDataFunctionInfoArray
  input Tpl.Text txt;
  input String a_name;
  input list<SimCode.Function> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_127(txt, a_items);
end globalDataFunctionInfoArray;

public function globalDataParDefine
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      DAE.ComponentRef i_name;
      Integer i_index;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCodeVar.SIMVAR(arrayCref = SOME(i_c), aliasvar = SimCodeVar.NOALIAS(), index = i_index, name = i_name),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "\n",
                                    "/* "
                                }, false));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute\n",
                                    "#define $P$ATTRIBUTE$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) "));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].info\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(aliasvar = SimCodeVar.NOALIAS(), name = i_name, index = i_index),
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define _"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) "));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute\n",
                                    "#define $P$ATTRIBUTE$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].info\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end globalDataParDefine;

public function globalDataVarDefine
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      DAE.ComponentRef i_name;
      Integer i_index;
      DAE.ComponentRef i_c;
      Integer ret_14;
      Integer ret_13;
      Integer ret_12;
      Integer ret_11;
      Integer ret_10;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      Integer ret_6;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_tmp;

    case ( txt,
           SimCodeVar.SIMVAR(arrayCref = SOME(i_c), aliasvar = SimCodeVar.NOALIAS(), index = i_index, name = i_name),
           a_arrayName,
           a_offset )
      equation
        ret_1 = System.tmpTick();
        l_tmp = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "#define _"
                                }, false));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->localData[i]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_2 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre["));
        ret_3 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "\n",
                                    "/* "
                                }, false));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "#define _"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->localData[i]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_4 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre["));
        ret_5 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_6 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute\n",
                                    "#define $P$ATTRIBUTE$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_7 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].info\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_8 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].info\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(aliasvar = SimCodeVar.NOALIAS(), name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        ret_9 = System.tmpTick();
        l_tmp = Tpl.writeStr(Tpl.emptyTxt, intString(ret_9));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "#define _"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->localData[i]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_10 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_10));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre["));
        ret_11 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_11));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_12 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_12));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].attribute\n",
                                    "#define $P$ATTRIBUTE$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_13 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_13));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].info\n",
                                    "#define $P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo data->modelData."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Data["));
        ret_14 = intAdd(a_offset, i_index);
        txt = Tpl.writeStr(txt, intString(ret_14));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].info\n",
                                    "#define _$P$PRE"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) $P$PRE"));
        txt = cref(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end globalDataVarDefine;

protected function lm_131
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer i_index;
      SimCodeVar.AliasVariable i_aliasvar;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(aliasvar = i_aliasvar, index = i_index) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = aliasVarNameType(txt, i_aliasvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_131(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_131(txt, rest);
      then txt;
  end match;
end lm_131;

protected function fun_132
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_items;
  input String in_a_0__type;
  input String in_a_0__name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_items, in_a_0__type, in_a_0__name)
    local
      Tpl.Text txt;
      String a_0__type;
      String a_0__name;
      list<SimCodeVar.SimVar> i_items;
      Integer ret_0;

    case ( txt,
           {},
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[1] = {{0,0,-1}};"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_items,
           a_0__type,
           a_0__name )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_0__type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_0__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = listLength(i_items);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_131(txt, i_items);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_132;

public function globalDataAliasVarArray
  input Tpl.Text txt;
  input String a_0__type;
  input String a_0__name;
  input list<SimCodeVar.SimVar> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_132(txt, a_items, a_0__type, a_0__name);
end globalDataAliasVarArray;

protected function lm_134
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String a_modelNamePrefix;
      list<SimCodeVar.SimVar> i_diffedVars;
      list<SimCodeVar.SimVar> i_diffVars;
      String i_name;
      list<SimCodeVar.SimVar> i_seedVars;
      list<SimCode.JacobianColumn> i_jacColumn;
      Integer i_indexJacobian;
      Tpl.Text l_sparseDef;
      Tpl.Text l_varsDef;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_jacColumn, i_seedVars, i_name, (_, _, (i_diffVars, i_diffedVars)), _, _, i_indexJacobian) :: rest,
           a_modelNamePrefix )
      equation
        l_varsDef = variableDefinitionsJacobians2(Tpl.emptyTxt, i_indexJacobian, i_jacColumn, i_seedVars, i_name);
        l_sparseDef = defineSparseIndexes(Tpl.emptyTxt, i_diffVars, i_diffedVars, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = symbolName(txt, a_modelNamePrefix, "INDEX_JAC_");
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, intString(i_indexJacobian));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = symbolName(txt, a_modelNamePrefix, "functionJac");
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_column(void* data);\n",
                                    "int "
                                }, false));
        txt = symbolName(txt, a_modelNamePrefix, "initialAnalyticJacobian");
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(void* data);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(__cplusplus)\n",
                                    "}\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varsDef);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_sparseDef);
        txt = Tpl.nextIter(txt);
        txt = lm_134(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_134;

public function variableDefinitionsJacobians
  input Tpl.Text txt;
  input list<SimCode.JacobianMatrix> a_JacobianMatrixes;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_analyticVars;
algorithm
  l_analyticVars := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_analyticVars := lm_134(l_analyticVars, a_JacobianMatrixes, a_modelNamePrefix);
  l_analyticVars := Tpl.popIter(l_analyticVars);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("/* Jacobian Variables */\n"));
  out_txt := Tpl.writeText(out_txt, l_analyticVars);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end variableDefinitionsJacobians;

protected function lm_136
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_name;
  input Integer in_a_indexJacobian;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name, in_a_indexJacobian)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_name;
      Integer a_indexJacobian;
      Integer x_index0;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_name,
           a_indexJacobian )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = jacobianVarDefine(txt, i_var, "jacobianVarsSeed", a_indexJacobian, x_index0, a_name);
        txt = Tpl.nextIter(txt);
        txt = lm_136(txt, rest, a_name, a_indexJacobian);
      then txt;
  end match;
end lm_136;

protected function lm_137
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_name;
  input Integer in_a_indexJacobian;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name, in_a_indexJacobian)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_name;
      Integer a_indexJacobian;
      Integer x_index0;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_name,
           a_indexJacobian )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = jacobianVarDefine(txt, i_var, "jacobianVars", a_indexJacobian, x_index0, a_name);
        txt = Tpl.nextIter(txt);
        txt = lm_137(txt, rest, a_name, a_indexJacobian);
      then txt;
  end match;
end lm_137;

protected function lm_138
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input String in_a_name;
  input Integer in_a_indexJacobian;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name, in_a_indexJacobian)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String a_name;
      Integer a_indexJacobian;
      list<SimCodeVar.SimVar> i_vars;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (_, i_vars, _) :: rest,
           a_name,
           a_indexJacobian )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_137(txt, i_vars, a_name, a_indexJacobian);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_138(txt, rest, a_name, a_indexJacobian);
      then txt;
  end match;
end lm_138;

public function variableDefinitionsJacobians2
  input Tpl.Text txt;
  input Integer a_indexJacobian;
  input list<SimCode.JacobianColumn> a_jacobianColumn;
  input list<SimCodeVar.SimVar> a_seedVars;
  input String a_name;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_columnVarsResult;
  Tpl.Text l_seedVarsResult;
algorithm
  l_seedVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_seedVarsResult := lm_136(l_seedVarsResult, a_seedVars, a_name, a_indexJacobian);
  l_seedVarsResult := Tpl.popIter(l_seedVarsResult);
  l_columnVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                        "\n",
                                                                                        "\n"
                                                                                    }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_columnVarsResult := lm_138(l_columnVarsResult, a_jacobianColumn, a_name, a_indexJacobian);
  l_columnVarsResult := Tpl.popIter(l_columnVarsResult);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(" */\n"));
  out_txt := Tpl.writeText(out_txt, l_seedVarsResult);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_columnVarsResult);
end variableDefinitionsJacobians2;

protected function fun_140
  input Tpl.Text in_txt;
  input Integer in_a_index;
  input Integer in_a_index0;
  input Integer in_a_indexJac;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_index, in_a_index0, in_a_indexJac, in_a_name)
    local
      Tpl.Text txt;
      Integer a_index0;
      Integer a_indexJac;
      DAE.ComponentRef a_name;
      Integer i_index;

    case ( txt,
           -1,
           a_index0,
           a_indexJac,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define _"));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->simulationInfo.analyticJacobians["));
        txt = Tpl.writeStr(txt, intString(a_indexJac));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].tmpVars["));
        txt = Tpl.writeStr(txt, intString(a_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define "
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "__varInfo dummyVAR_INFO\n",
                                    "#define $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" dummyREAL_ATTRIBUTE"));
      then txt;

    case ( txt,
           i_index,
           _,
           a_indexJac,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define _"));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i) data->simulationInfo.analyticJacobians["));
        txt = Tpl.writeStr(txt, intString(a_indexJac));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].resultVars["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(0)\n",
                                    "#define "
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "__varInfo dummyVAR_INFO\n",
                                    "#define $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" dummyREAL_ATTRIBUTE"));
      then txt;
  end match;
end fun_140;

protected function fun_141
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input Integer in_a_index0;
  input Integer in_a_indexJac;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_index0, in_a_indexJac)
    local
      Tpl.Text txt;
      Integer a_index0;
      Integer a_indexJac;
      DAE.ComponentRef i_name;
      Integer i_index;

    case ( txt,
           SimCodeVar.SIMVAR(aliasvar = SimCodeVar.NOALIAS(), name = i_name, index = i_index),
           a_index0,
           a_indexJac )
      equation
        txt = fun_140(txt, i_index, a_index0, a_indexJac, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_141;

protected function fun_142
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input Integer in_a_index0;
  input Integer in_a_indexJac;
  input String in_a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_index0, in_a_indexJac, in_a_matrixName)
    local
      Tpl.Text txt;
      Integer a_index0;
      Integer a_indexJac;
      String a_matrixName;
      DAE.ComponentRef i_name;
      Integer ret_1;
      Tpl.Text l_tmp;

    case ( txt,
           SimCodeVar.SIMVAR(aliasvar = SimCodeVar.NOALIAS(), name = i_name),
           a_index0,
           a_indexJac,
           a_matrixName )
      equation
        ret_1 = System.tmpTick();
        l_tmp = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixName);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" data->simulationInfo.analyticJacobians["));
        txt = Tpl.writeStr(txt, intString(a_indexJac));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].seedVars["));
        txt = Tpl.writeStr(txt, intString(a_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "#define "
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixName);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo dummyVAR_INFO"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_142;

protected function fun_143
  input Tpl.Text in_txt;
  input String in_a_array;
  input SimCodeVar.SimVar in_a_simVar;
  input Integer in_a_indexJac;
  input Integer in_a_index0;
  input String in_a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_array, in_a_simVar, in_a_indexJac, in_a_index0, in_a_matrixName)
    local
      Tpl.Text txt;
      SimCodeVar.SimVar a_simVar;
      Integer a_indexJac;
      Integer a_index0;
      String a_matrixName;

    case ( txt,
           "jacobianVars",
           a_simVar,
           a_indexJac,
           a_index0,
           _ )
      equation
        txt = fun_141(txt, a_simVar, a_index0, a_indexJac);
      then txt;

    case ( txt,
           "jacobianVarsSeed",
           a_simVar,
           a_indexJac,
           a_index0,
           a_matrixName )
      equation
        txt = fun_142(txt, a_simVar, a_index0, a_indexJac, a_matrixName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_143;

public function jacobianVarDefine
  input Tpl.Text txt;
  input SimCodeVar.SimVar a_simVar;
  input String a_array;
  input Integer a_indexJac;
  input Integer a_index0;
  input String a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_143(txt, a_array, a_simVar, a_indexJac, a_index0, a_matrixName);
end jacobianVarDefine;

protected function lm_145
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixName)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_matrixName;
      Integer x_index0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest,
           a_matrixName )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiff "));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.nextIter(txt);
        txt = lm_145(txt, rest, a_matrixName);
      then txt;

    case ( txt,
           _ :: rest,
           a_matrixName )
      equation
        txt = lm_145(txt, rest, a_matrixName);
      then txt;
  end match;
end lm_145;

protected function lm_146
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_matrixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixName)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_matrixName;
      Integer x_index0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest,
           a_matrixName )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiffed "));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.nextIter(txt);
        txt = lm_146(txt, rest, a_matrixName);
      then txt;

    case ( txt,
           _ :: rest,
           a_matrixName )
      equation
        txt = lm_146(txt, rest, a_matrixName);
      then txt;
  end match;
end lm_146;

public function defineSparseIndexes
  input Tpl.Text txt;
  input list<SimCodeVar.SimVar> a_diffVars;
  input list<SimCodeVar.SimVar> a_diffedVars;
  input String a_matrixName;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_diffedVarsResult;
  Tpl.Text l_diffVarsResult;
algorithm
  l_diffVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_diffVarsResult := lm_145(l_diffVarsResult, a_diffVars, a_matrixName);
  l_diffVarsResult := Tpl.popIter(l_diffVarsResult);
  l_diffedVarsResult := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_diffedVarsResult := lm_146(l_diffedVarsResult, a_diffedVars, a_matrixName);
  l_diffedVarsResult := Tpl.popIter(l_diffedVarsResult);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
  out_txt := Tpl.writeStr(out_txt, a_matrixName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(" sparse indexes */\n"));
  out_txt := Tpl.writeText(out_txt, l_diffVarsResult);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_diffedVarsResult);
end defineSparseIndexes;

public function aliasVarNameType
  input Tpl.Text in_txt;
  input SimCodeVar.AliasVariable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_varName;

    case ( txt,
           SimCodeVar.NOALIAS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0,0"));
      then txt;

    case ( txt,
           SimCodeVar.ALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = cref(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",0"));
      then txt;

    case ( txt,
           SimCodeVar.NEGATEDALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = cref(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",1"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end aliasVarNameType;

protected function lm_149
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_arg;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           SimCodeVar.SIMVAR(initialValue = SOME(i_exp), name = i_var_name) :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arg, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_arg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls) = lm_149(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _ :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        (txt, a_auxFunction, a_varDecls) = lm_149(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_149;

protected function lm_150
  input Tpl.Text in_txt;
  input list<SimCode.ExtAlias> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> rest;
      DAE.ComponentRef i_var2;
      DAE.ComponentRef i_var1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var1, i_var2) :: rest )
      equation
        txt = cref(txt, i_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = cref(txt, i_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_150(txt, rest);
      then txt;
  end match;
end lm_150;

public function functionCallExternalObjectConstructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extObjInfo, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      list<SimCode.ExtAlias> i_aliases;
      list<SimCodeVar.SimVar> i_vars;
      Tpl.Text l_ctorCalls;
      Tpl.Text l_varDecls;
      Tpl.Text l_auxFunction;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_vars, aliases = i_aliases),
           a_modelNamePrefix )
      equation
        l_auxFunction = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_ctorCalls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_ctorCalls, l_auxFunction, l_varDecls) = lm_149(l_ctorCalls, i_vars, l_auxFunction, l_varDecls);
        l_ctorCalls = Tpl.popIter(l_ctorCalls);
        txt = Tpl.writeText(txt, l_auxFunction);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* Has to be performed after _init.xml file has been read */\n",
                                    "void "
                                }, false));
        txt = symbolName(txt, a_modelNamePrefix, "callExternalObjectConstructors");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* data->simulationInfo.extObjs = NULL; */\n",
                                    "infoStreamPrint(LOG_DEBUG, 0, \"call external Object Constructors\");\n"
                                }, true));
        txt = Tpl.writeText(txt, l_ctorCalls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_150(txt, i_aliases);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("infoStreamPrint(LOG_DEBUG, 0, \"call external Object Constructors finished\");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionCallExternalObjectConstructors;

protected function lm_152
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      DAE.ComponentRef i_var_name;
      Absyn.Path i_ext_fullClassName;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(varKind = BackendDAE.EXTOBJ(fullClassName = i_ext_fullClassName), name = i_var_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omc_"));
        txt = CodegenUtil.underscorePath(txt, i_ext_fullClassName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_destructor(threadData,"));
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_152(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_152(txt, rest);
      then txt;
  end match;
end lm_152;

public function functionCallExternalObjectDestructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extObjInfo, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      list<SimCodeVar.SimVar> i_extObjInfo_vars;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_extObjInfo_vars),
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = symbolName(txt, a_modelNamePrefix, "callExternalObjectDestructors");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n",
                                    "  if(data->simulationInfo.extObjs)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_152(txt, i_extObjInfo_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "free(data->simulationInfo.extObjs);\n",
                                    "data->simulationInfo.extObjs = 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionCallExternalObjectDestructors;

protected function lm_154
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = data->simulationInfo.inputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_154(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_154(txt, rest);
      then txt;
  end match;
end lm_154;

protected function lm_155
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$ATTRIBUTE"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".start = data->simulationInfo.inputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_155(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_155(txt, rest);
      then txt;
  end match;
end lm_155;

public function functionInput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      list<SimCodeVar.SimVar> i_vars_inputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(inputVars = i_vars_inputVars)),
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = symbolName(txt, a_modelNamePrefix, "input_function");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_154(txt, i_vars_inputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "int "
                                }, false));
        txt = symbolName(txt, a_modelNamePrefix, "input_function_init");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_155(txt, i_vars_inputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionInput;

protected function lm_157
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.outputVars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_157(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_157(txt, rest);
      then txt;
  end match;
end lm_157;

public function functionOutput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      list<SimCodeVar.SimVar> i_vars_outputVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(outputVars = i_vars_outputVars)),
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = symbolName(txt, a_modelNamePrefix, "output_function");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_157(txt, i_vars_outputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionOutput;

protected function fun_159
  input Tpl.Text in_txt;
  input BackendDAE.TimeEvent in_a_timeEvent;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_a_timeEvent, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      Integer i_index;
      DAE.Exp i_intervalExp;
      DAE.Exp i_startExp;
      Tpl.Text l_e2;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.SAMPLE_TIME_EVENT(startExp = i_startExp, intervalExp = i_intervalExp, index = i_index),
           a_auxFunction,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_startExp, SimCode.contextOther, l_preExp, a_varDecls, a_auxFunction);
        (l_e2, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_intervalExp, SimCode.contextOther, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* $P$sample"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "data->modelData.samplesInfo[i].index = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.samplesInfo[i].start = "
                                }, false));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->modelData.samplesInfo[i].interval = "
                                }, false));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "assertStreamPrint(threadData,data->modelData.samplesInfo[i].interval > 0.0, \"sample-interval <= 0.0\");\n",
                                    "i++;"
                                }, false));
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _,
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);
  end match;
end fun_159;

protected function lm_160
  input Tpl.Text in_txt;
  input list<BackendDAE.TimeEvent> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.TimeEvent> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      BackendDAE.TimeEvent i_timeEvent;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           i_timeEvent :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        (txt, a_auxFunction, a_varDecls) = fun_159(txt, i_timeEvent, a_auxFunction, a_varDecls);
        (txt, a_auxFunction, a_varDecls) = lm_160(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_160;

public function functionInitSample
  input Tpl.Text txt;
  input list<BackendDAE.TimeEvent> a_timeEvents;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_res;
  Tpl.Text l_body;
  Tpl.Text l_auxFunction;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_auxFunction := Tpl.emptyTxt;
  (l_body, l_auxFunction, l_varDecls) := lm_160(Tpl.emptyTxt, a_timeEvents, l_auxFunction, l_varDecls);
  l_res := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING_LIST({
                                          "/* Initializes the raw time events of the simulation using the now\n",
                                          "   calcualted parameters. */\n",
                                          "void "
                                      }, false));
  l_res := symbolName(l_res, a_modelNamePrefix, "function_initSample");
  l_res := Tpl.writeTok(l_res, Tpl.ST_STRING_LIST({
                                   "(DATA *data)\n",
                                   "{\n",
                                   "  long i=0;\n"
                               }, true));
  l_res := Tpl.pushBlock(l_res, Tpl.BT_INDENT(2));
  l_res := Tpl.writeText(l_res, l_varDecls);
  l_res := Tpl.softNewLine(l_res);
  l_res := Tpl.writeText(l_res, l_body);
  l_res := Tpl.softNewLine(l_res);
  l_res := Tpl.popBlock(l_res);
  l_res := Tpl.writeTok(l_res, Tpl.ST_STRING("}"));
  out_txt := Tpl.writeText(txt, l_auxFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_res);
end functionInitSample;

protected function lm_162
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      list<SimCode.SimEqSystem> i_jacobianEquations;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           ({(i_jacobianEquations, _, _)}, _, _, _, _, _, _) :: rest )
      equation
        txt = functionInitialMixedSystemsTemp(txt, i_jacobianEquations);
        txt = Tpl.nextIter(txt);
        txt = lm_162(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_162(txt, rest);
      then txt;
  end match;
end lm_162;

public function functionInitialMixedSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.JacobianMatrix> a_jacobianMatrixes;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacobianbody;
  Tpl.Text l_body;
  Tpl.Text l_parambody;
  Tpl.Text l_initbody;
algorithm
  l_initbody := functionInitialMixedSystemsTemp(Tpl.emptyTxt, a_initialEquations);
  l_parambody := functionInitialMixedSystemsTemp(Tpl.emptyTxt, a_parameterEquations);
  l_body := functionInitialMixedSystemsTemp(Tpl.emptyTxt, a_allEquations);
  l_jacobianbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                    "\n",
                                                                                    "\n"
                                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_jacobianbody := lm_162(l_jacobianbody, a_jacobianMatrixes);
  l_jacobianbody := Tpl.popIter(l_jacobianbody);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* funtion initialize mixed systems */\n",
                                   "void "
                               }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "initialMixedSystem");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(int nMixedSystems, MIXED_SYSTEM_DATA* mixedSystemData)\n",
                                       "{\n",
                                       "  /* initial mixed systems */\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* parameter mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* model mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* jacobians mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_jacobianbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialMixedSystems;

protected function fun_164
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn)
    local
      Tpl.Text txt;
      Integer i_index;
      Integer i_indexMixedSystem;
      list<SimCodeVar.SimVar> i_discVars;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_MIXED(discVars = i_discVars, indexMixedSystem = i_indexMixedSystem, index = i_index) )
      equation
        ret_1 = listLength(i_discVars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assertStreamPrint(NULL, nMixedSystems > "));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", \"Internal Error: nMixedSystems mismatch!\");\n",
                                    "mixedSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].equationIndex = "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "mixedSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].size = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "mixedSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].solveContinuousPart = updateContinuousPart"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "mixedSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].updateIterationExps = updateIterationExpMixedSystem"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_164;

protected function lm_165
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eqn :: rest )
      equation
        txt = fun_164(txt, i_eqn);
        txt = Tpl.nextIter(txt);
        txt = lm_165(txt, rest);
      then txt;
  end match;
end lm_165;

public function functionInitialMixedSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_165(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionInitialMixedSystemsTemp;

protected function lm_167
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_header;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_header;
algorithm
  (out_txt, out_a_header) :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_header)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_header;
      list<SimCode.SimEqSystem> i_jacobianEquations;

    case ( txt,
           {},
           _,
           a_header )
      then (txt, a_header);

    case ( txt,
           ({(i_jacobianEquations, _, _)}, _, _, _, _, _, _) :: rest,
           a_modelNamePrefixStr,
           a_header )
      equation
        (txt, a_header) = functionSetupMixedSystemsTemp(txt, i_jacobianEquations, a_header, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        (txt, a_header) = lm_167(txt, rest, a_modelNamePrefixStr, a_header);
      then (txt, a_header);

    case ( txt,
           _ :: rest,
           a_modelNamePrefixStr,
           a_header )
      equation
        (txt, a_header) = lm_167(txt, rest, a_modelNamePrefixStr, a_header);
      then (txt, a_header);
  end match;
end lm_167;

public function functionSetupMixedSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.JacobianMatrix> a_jacobianMatrixes;
  input Tpl.Text a_header;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_header;
protected
  Tpl.Text l_jacobianbody;
  Tpl.Text l_body;
  Tpl.Text l_parambody;
  Tpl.Text l_initbody;
algorithm
  (l_initbody, out_a_header) := functionSetupMixedSystemsTemp(Tpl.emptyTxt, a_initialEquations, a_header, a_modelNamePrefixStr);
  (l_parambody, out_a_header) := functionSetupMixedSystemsTemp(Tpl.emptyTxt, a_parameterEquations, out_a_header, a_modelNamePrefixStr);
  (l_body, out_a_header) := functionSetupMixedSystemsTemp(Tpl.emptyTxt, a_allEquations, out_a_header, a_modelNamePrefixStr);
  l_jacobianbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                    "\n",
                                                                                    "\n"
                                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_jacobianbody, out_a_header) := lm_167(l_jacobianbody, a_jacobianMatrixes, a_modelNamePrefixStr, out_a_header);
  l_jacobianbody := Tpl.popIter(l_jacobianbody);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("/* initial mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* parameter mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* model mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* jacobians mixed systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_jacobianbody);
end functionSetupMixedSystems;

protected function fun_169
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_cont;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cont)
    local
      Tpl.Text txt;
      Integer i_indexNonLinearSystem;
      Integer i_indexLinearSystem;

    case ( txt,
           SimCode.SES_LINEAR(indexLinearSystem = i_indexLinearSystem) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.linearSystemData["));
        txt = Tpl.writeStr(txt, intString(i_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].solved"));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(indexNonLinearSystem = i_indexNonLinearSystem) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.nonlinearSystemData["));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].solved"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_169;

protected function lm_170
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preDisc;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preDisc;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls, out_a_preDisc) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls, in_a_preDisc)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      Tpl.Text a_preDisc;
      DAE.ComponentRef i_cref;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls,
           a_preDisc )
      then (txt, a_auxFunction, a_varDecls, a_preDisc);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref) :: rest,
           a_auxFunction,
           a_varDecls,
           a_preDisc )
      equation
        (l_expPart, a_preDisc, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextSimulationDiscrete, a_preDisc, a_varDecls, a_auxFunction);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls, a_preDisc) = lm_170(txt, rest, a_auxFunction, a_varDecls, a_preDisc);
      then (txt, a_auxFunction, a_varDecls, a_preDisc);

    case ( txt,
           _ :: rest,
           a_auxFunction,
           a_varDecls,
           a_preDisc )
      equation
        (txt, a_auxFunction, a_varDecls, a_preDisc) = lm_170(txt, rest, a_auxFunction, a_varDecls, a_preDisc);
      then (txt, a_auxFunction, a_varDecls, a_preDisc);
  end match;
end lm_170;

protected function fun_171
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_header;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_header;
algorithm
  (out_txt, out_a_header) :=
  match(in_txt, in_a_eqn, in_a_modelNamePrefixStr, in_a_header)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      Tpl.Text a_header;
      Integer i_indexMixedSystem;
      Integer i_index;
      list<SimCode.SimEqSystem> i_discEqs;
      SimCode.SimEqSystem i_cont;
      Tpl.Text l_discExp;
      Tpl.Text l_auxFunction;
      Tpl.Text l_varDecls;
      Tpl.Text l_preDisc;
      Tpl.Text l_solvedContinuous;
      Tpl.Text l_contEqsIndex;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discEqs = i_discEqs, index = i_index, indexMixedSystem = i_indexMixedSystem),
           a_modelNamePrefixStr,
           a_header )
      equation
        l_contEqsIndex = CodegenUtil.equationIndex(Tpl.emptyTxt, i_cont);
        l_solvedContinuous = fun_169(Tpl.emptyTxt, i_cont);
        l_preDisc = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_auxFunction = Tpl.emptyTxt;
        l_discExp = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_discExp, l_auxFunction, l_varDecls, l_preDisc) = lm_170(l_discExp, i_discEqs, l_auxFunction, l_varDecls, l_preDisc);
        l_discExp = Tpl.popIter(l_discExp);
        a_header = Tpl.writeTok(a_header, Tpl.ST_STRING("void updateContinuousPart"));
        a_header = Tpl.writeStr(a_header, intString(i_index));
        a_header = Tpl.writeTok(a_header, Tpl.ST_STRING("(void *);"));
        a_header = Tpl.writeTok(a_header, Tpl.ST_NEW_LINE());
        a_header = Tpl.writeTok(a_header, Tpl.ST_STRING("void updateIterationExpMixedSystem"));
        a_header = Tpl.writeStr(a_header, intString(i_index));
        a_header = Tpl.writeTok(a_header, Tpl.ST_STRING("(void *);"));
        a_header = Tpl.writeTok(a_header, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_auxFunction);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void updateContinuousPart"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = symbolName(txt, a_modelNamePrefixStr, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_contEqsIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "data->simulationInfo.mixedSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].continuous_solution = "));
        txt = Tpl.writeText(txt, l_solvedContinuous);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void updateIterationExpMixedSystem"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_preDisc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_discExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_header);

    case ( txt,
           _,
           _,
           a_header )
      then (txt, a_header);
  end match;
end fun_171;

protected function lm_172
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_header;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_header;
algorithm
  (out_txt, out_a_header) :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_header)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_header;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _,
           a_header )
      then (txt, a_header);

    case ( txt,
           i_eqn :: rest,
           a_modelNamePrefixStr,
           a_header )
      equation
        (txt, a_header) = fun_171(txt, i_eqn, a_modelNamePrefixStr, a_header);
        txt = Tpl.nextIter(txt);
        (txt, a_header) = lm_172(txt, rest, a_modelNamePrefixStr, a_header);
      then (txt, a_header);
  end match;
end lm_172;

public function functionSetupMixedSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input Tpl.Text a_header;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_header;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_header) := lm_172(out_txt, a_allEquations, a_modelNamePrefixStr, a_header);
  out_txt := Tpl.popIter(out_txt);
end functionSetupMixedSystemsTemp;

protected function lm_174
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String a_modelNamePrefix;
      list<SimCode.SimEqSystem> i_jacobianEquations;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           ({(i_jacobianEquations, _, _)}, _, _, _, _, _, _) :: rest,
           a_modelNamePrefix )
      equation
        txt = functionInitialLinearSystemsTemp(txt, i_jacobianEquations, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_174(txt, rest, a_modelNamePrefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelNamePrefix )
      equation
        txt = lm_174(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_174;

public function functionInitialLinearSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.JacobianMatrix> a_jacobianMatrixes;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacobianbody;
  Tpl.Text l_body;
  Tpl.Text l_parambody;
  Tpl.Text l_initbody;
algorithm
  l_initbody := functionInitialLinearSystemsTemp(Tpl.emptyTxt, a_initialEquations, a_modelNamePrefix);
  l_parambody := functionInitialLinearSystemsTemp(Tpl.emptyTxt, a_parameterEquations, a_modelNamePrefix);
  l_body := functionInitialLinearSystemsTemp(Tpl.emptyTxt, a_allEquations, a_modelNamePrefix);
  l_jacobianbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                    "\n",
                                                                                    "\n"
                                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_jacobianbody := lm_174(l_jacobianbody, a_jacobianMatrixes, a_modelNamePrefix);
  l_jacobianbody := Tpl.popIter(l_jacobianbody);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* funtion initialize linear systems */\n",
                                   "void "
                               }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "initialLinearSystem");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(int nLinearSystems, LINEAR_SYSTEM_DATA* linearSystemData)\n",
                                       "{\n",
                                       "  /* initial linear systems */\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* parameter linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* model linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* jacobians linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_jacobianbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialLinearSystems;

protected function fun_176
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_eq_jacobianMatrix;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq_jacobianMatrix, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      String i_name;

    case ( txt,
           SOME((_, _, i_name, _, _, _, _)),
           a_modelNamePrefix )
      equation
        txt = symbolName(txt, a_modelNamePrefix, "functionJac");
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_column"));
      then txt;

    case ( txt,
           NONE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NULL"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_176;

protected function fun_177
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_eq_jacobianMatrix;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq_jacobianMatrix, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      String i_name;

    case ( txt,
           SOME((_, _, i_name, _, _, _, _)),
           a_modelNamePrefix )
      equation
        txt = symbolName(txt, a_modelNamePrefix, "initialAnalyticJacobian");
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           NONE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NULL"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_177;

protected function fun_178
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_eq_jacobianMatrix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq_jacobianMatrix)
    local
      Tpl.Text txt;
      Integer i_jacindex;

    case ( txt,
           SOME((_, _, _, _, _, _, i_jacindex)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_jacindex));
      then txt;

    case ( txt,
           NONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-1"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_178;

protected function fun_179
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_jacobianMatrix;
  input String in_a_modelNamePrefix;
  input Option<SimCode.JacobianMatrix> in_a_eq_jacobianMatrix;
  input Integer in_a_eq_index;
  input Integer in_a_eq_indexLinearSystem;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_a_eq_simJac;
  input list<SimCodeVar.SimVar> in_a_eq_vars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_jacobianMatrix, in_a_modelNamePrefix, in_a_eq_jacobianMatrix, in_a_eq_index, in_a_eq_indexLinearSystem, in_a_eq_simJac, in_a_eq_vars)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      Option<SimCode.JacobianMatrix> a_eq_jacobianMatrix;
      Integer a_eq_index;
      Integer a_eq_indexLinearSystem;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> a_eq_simJac;
      list<SimCodeVar.SimVar> a_eq_vars;
      Tpl.Text txt_9;
      Tpl.Text l_jacIndex;
      Tpl.Text l_initialJac;
      Tpl.Text l_generatedJac;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Tpl.Text l_nnz;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           NONE(),
           _,
           _,
           a_eq_index,
           a_eq_indexLinearSystem,
           a_eq_simJac,
           a_eq_vars )
      equation
        ret_1 = listLength(a_eq_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        ret_3 = listLength(a_eq_simJac);
        l_nnz = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assertStreamPrint(NULL, nLinearSystems > "));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", \"Internal Error: nLinearSystems mismatch!\");\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].equationIndex = "));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].size = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nnz = "));
        txt = Tpl.writeText(txt, l_nnz);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].method = 0;\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].setA = setLinearMatrixA"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].setb = setLinearVectorb"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].initializeStaticLSData = initializeStaticLSData"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SOME(_),
           a_modelNamePrefix,
           a_eq_jacobianMatrix,
           a_eq_index,
           a_eq_indexLinearSystem,
           a_eq_simJac,
           a_eq_vars )
      equation
        ret_4 = listLength(a_eq_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_4));
        ret_5 = listLength(a_eq_simJac);
        l_nnz = Tpl.writeStr(Tpl.emptyTxt, intString(ret_5));
        l_generatedJac = fun_176(Tpl.emptyTxt, a_eq_jacobianMatrix, a_modelNamePrefix);
        l_initialJac = fun_177(Tpl.emptyTxt, a_eq_jacobianMatrix, a_modelNamePrefix);
        l_jacIndex = fun_178(Tpl.emptyTxt, a_eq_jacobianMatrix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assertStreamPrint(NULL, nLinearSystems > "));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", \"Internal Error: indexlinearSystem mismatch!\");\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].equationIndex = "));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].size = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nnz = "));
        txt = Tpl.writeText(txt, l_nnz);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].method = 1;\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].residualFunc = residualFunc"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].analyticalJacobianColumn = "));
        txt = Tpl.writeText(txt, l_generatedJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].initialAnalyticalJacobian = "));
        txt = Tpl.writeText(txt, l_initialJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].jacobianIndex = "));
        txt = Tpl.writeText(txt, l_jacIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].setA = NULL;//setLinearMatrixA"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].setb = NULL; //setLinearVectorb"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "linearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].initializeStaticLSData = initializeStaticLSData"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           a_eq_index,
           _,
           _,
           _ )
      equation
        txt_9 = Tpl.pushBlock(Tpl.emptyTxt, Tpl.BT_INDENT(1));
        txt_9 = Tpl.writeTok(txt_9, Tpl.ST_STRING("No jacobian create for linear system "));
        txt_9 = Tpl.writeStr(txt_9, intString(a_eq_index));
        txt_9 = Tpl.writeTok(txt_9, Tpl.ST_STRING("."));
        txt_9 = Tpl.popBlock(txt_9);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 1555, 14), Tpl.textString(txt_9));
      then txt;
  end match;
end fun_179;

protected function fun_180
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      Option<SimCode.JacobianMatrix> i_eq_jacobianMatrix;
      Integer i_eq_index;
      Integer i_eq_indexLinearSystem;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_eq_simJac;
      list<SimCodeVar.SimVar> i_eq_vars;
      Option<SimCode.JacobianMatrix> i_jacobianMatrix;
      SimCode.SimEqSystem i_eq_cont;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont),
           a_modelNamePrefix )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionInitialLinearSystemsTemp(txt, ret_0, a_modelNamePrefix);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(jacobianMatrix = (i_eq_jacobianMatrix as i_jacobianMatrix), vars = i_eq_vars, simJac = i_eq_simJac, indexLinearSystem = i_eq_indexLinearSystem, index = i_eq_index),
           a_modelNamePrefix )
      equation
        txt = fun_179(txt, i_jacobianMatrix, a_modelNamePrefix, i_eq_jacobianMatrix, i_eq_index, i_eq_indexLinearSystem, i_eq_simJac, i_eq_vars);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_180;

protected function lm_181
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_modelNamePrefix )
      equation
        txt = fun_180(txt, i_eqn, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_181(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_181;

public function functionInitialLinearSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_181(out_txt, a_allEquations, a_modelNamePrefix);
  out_txt := Tpl.popIter(out_txt);
end functionInitialLinearSystemsTemp;

protected function lm_183
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String a_modelNamePrefix;
      list<SimCode.SimEqSystem> i_jacobianEquations;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           ({(i_jacobianEquations, _, _)}, _, _, _, _, _, _) :: rest,
           a_modelNamePrefix )
      equation
        txt = functionSetupLinearSystemsTemp(txt, i_jacobianEquations, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_183(txt, rest, a_modelNamePrefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelNamePrefix )
      equation
        txt = lm_183(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_183;

public function functionSetupLinearSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.JacobianMatrix> a_jacobianMatrixes;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacobianbody;
  Tpl.Text l_body;
  Tpl.Text l_parambody;
  Tpl.Text l_initbody;
algorithm
  l_initbody := functionSetupLinearSystemsTemp(Tpl.emptyTxt, a_initialEquations, a_modelNamePrefix);
  l_parambody := functionSetupLinearSystemsTemp(Tpl.emptyTxt, a_parameterEquations, a_modelNamePrefix);
  l_body := functionSetupLinearSystemsTemp(Tpl.emptyTxt, a_allEquations, a_modelNamePrefix);
  l_jacobianbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                    "\n",
                                                                                    "\n"
                                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_jacobianbody := lm_183(l_jacobianbody, a_jacobianMatrixes, a_modelNamePrefix);
  l_jacobianbody := Tpl.popIter(l_jacobianbody);
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("/* initial linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* parameter linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* model linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("/* jacobians linear systems */\n"));
  out_txt := Tpl.writeText(out_txt, l_jacobianbody);
end functionSetupLinearSystems;

protected function lm_185
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer x_i0;
      SimCodeVar.SimVar i_var;
      DAE.ComponentRef ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        ret_0 = SimCodeUtil.varName(i_var);
        txt = cref(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = xloc["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_185(txt, rest);
      then txt;
  end match;
end lm_185;

protected function lm_186
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDeclsRes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDeclsRes;
algorithm
  (out_txt, out_a_tmp, out_a_varDeclsRes) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDeclsRes)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDeclsRes;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDeclsRes )
      then (txt, a_tmp, a_varDeclsRes);

    case ( txt,
           i_eq2 :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDeclsRes )
      equation
        (txt, a_varDeclsRes, a_tmp) = functionExtraResidualsPreBody(txt, i_eq2, a_varDeclsRes, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDeclsRes) = lm_186(txt, rest, a_modelNamePrefix, a_tmp, a_varDeclsRes);
      then (txt, a_tmp, a_varDeclsRes);
  end match;
end lm_186;

protected function fun_187
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eq2_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq2_index)
    local
      Tpl.Text txt;
      Integer a_eq2_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq2_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeStr(txt, intString(a_eq2_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_187;

protected function fun_188
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eq2_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq2_index)
    local
      Tpl.Text txt;
      Integer a_eq2_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq2_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeStr(txt, intString(a_eq2_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_188;

protected function lm_189
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDeclsRes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDeclsRes;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDeclsRes) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDeclsRes)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDeclsRes;
      Integer x_i0;
      Integer i_eq2_index;
      DAE.Exp i_eq2_exp;
      Boolean ret_3;
      Boolean ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_auxFunction,
           a_varDeclsRes )
      then (txt, a_auxFunction, a_varDeclsRes);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_eq2_exp, index = i_eq2_index) :: rest,
           a_auxFunction,
           a_varDeclsRes )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDeclsRes, a_auxFunction) = daeExp(Tpl.emptyTxt, i_eq2_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDeclsRes, a_auxFunction);
        ret_2 = Config.profileAll();
        txt = fun_187(txt, ret_2, i_eq2_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        ret_3 = Config.profileAll();
        txt = fun_188(txt, ret_3, i_eq2_index);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDeclsRes) = lm_189(txt, rest, a_auxFunction, a_varDeclsRes);
      then (txt, a_auxFunction, a_varDeclsRes);

    case ( txt,
           _ :: rest,
           a_auxFunction,
           a_varDeclsRes )
      equation
        (txt, a_auxFunction, a_varDeclsRes) = lm_189(txt, rest, a_auxFunction, a_varDeclsRes);
      then (txt, a_auxFunction, a_varDeclsRes);
  end match;
end lm_189;

protected function lm_190
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;
      DAE.ComponentRef ret_3;
      DAE.ComponentRef ret_2;
      DAE.ComponentRef ret_1;
      DAE.ComponentRef ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* static ls data for "));
        ret_0 = SimCodeUtil.varName(i_var);
        txt = cref(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "linearSystemData->nominal[i] = 1.0;      /* $P$ATTRIBUTE"
                                }, false));
        ret_1 = SimCodeUtil.varName(i_var);
        txt = cref(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".nominal */\n",
                                    "linearSystemData->min[i]     = -DBL_MAX; /* $P$ATTRIBUTE"
                                }, false));
        ret_2 = SimCodeUtil.varName(i_var);
        txt = cref(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".min */\n",
                                    "linearSystemData->max[i++]   = DBL_MAX;  /* $P$ATTRIBUTE"
                                }, false));
        ret_3 = SimCodeUtil.varName(i_var);
        txt = cref(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".max */"));
        txt = Tpl.nextIter(txt);
        txt = lm_190(txt, rest);
      then txt;
  end match;
end lm_190;

protected function fun_191
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eq_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq_index)
    local
      Tpl.Text txt;
      Integer a_eq_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_191;

protected function fun_192
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eq_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq_index)
    local
      Tpl.Text txt;
      Integer a_eq_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ADD_NCALL_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").profileBlockIndex,1);"));
      then txt;
  end match;
end fun_192;

protected function fun_193
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eq_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq_index)
    local
      Tpl.Text txt;
      Integer a_eq_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_193;

protected function lm_194
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      Integer x_i0;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_eq_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("linearSystemData->setAElement("));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", linearSystemData);"));
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls) = lm_194(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _ :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        (txt, a_auxFunction, a_varDecls) = lm_194(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_194;

protected function lm_195
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls2;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls2;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls2) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls2)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls2;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls2 )
      then (txt, a_auxFunction, a_varDecls2);

    case ( txt,
           i_exp :: rest,
           a_auxFunction,
           a_varDecls2 )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls2, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls2, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("linearSystemData->b["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] =  "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls2) = lm_195(txt, rest, a_auxFunction, a_varDecls2);
      then (txt, a_auxFunction, a_varDecls2);
  end match;
end lm_195;

protected function lm_196
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;
      DAE.ComponentRef ret_3;
      DAE.ComponentRef ret_2;
      DAE.ComponentRef ret_1;
      DAE.ComponentRef ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* static ls data for "));
        ret_0 = SimCodeUtil.varName(i_var);
        txt = cref(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "linearSystemData->nominal[i] = 1.0;      /* $P$ATTRIBUTE"
                                }, false));
        ret_1 = SimCodeUtil.varName(i_var);
        txt = cref(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".nominal */\n",
                                    "linearSystemData->min[i]     = -DBL_MAX; /* $P$ATTRIBUTE"
                                }, false));
        ret_2 = SimCodeUtil.varName(i_var);
        txt = cref(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".min */\n",
                                    "linearSystemData->max[i++]   = DBL_MAX;  /* $P$ATTRIBUTE"
                                }, false));
        ret_3 = SimCodeUtil.varName(i_var);
        txt = cref(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".max */"));
        txt = Tpl.nextIter(txt);
        txt = lm_196(txt, rest);
      then txt;
  end match;
end lm_196;

protected function fun_197
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_jacobianMatrix;
  input list<DAE.Exp> in_a_eq_beqs;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_a_eq_simJac;
  input Integer in_a_eq_index;
  input String in_a_modelNamePrefix;
  input list<SimCode.SimEqSystem> in_a_eq_residual;
  input list<SimCodeVar.SimVar> in_a_eq_vars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_jacobianMatrix, in_a_eq_beqs, in_a_eq_simJac, in_a_eq_index, in_a_modelNamePrefix, in_a_eq_residual, in_a_eq_vars)
    local
      Tpl.Text txt;
      list<DAE.Exp> a_eq_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> a_eq_simJac;
      Integer a_eq_index;
      String a_modelNamePrefix;
      list<SimCode.SimEqSystem> a_eq_residual;
      list<SimCodeVar.SimVar> a_eq_vars;
      Tpl.Text l_vectorb;
      Tpl.Text l_varDecls2;
      Tpl.Text l_MatrixA;
      Tpl.Text l_varDecls;
      Boolean ret_9;
      Boolean ret_8;
      Boolean ret_7;
      Tpl.Text l_body__initializeStaticLSData;
      Tpl.Text l_body;
      Tpl.Text l_prebody;
      Tpl.Text l_xlocs;
      Tpl.Text l_tmp;
      Tpl.Text l_auxFunction;
      Tpl.Text l_varDeclsRes;

    case ( txt,
           SOME(_),
           _,
           _,
           a_eq_index,
           a_modelNamePrefix,
           a_eq_residual,
           a_eq_vars )
      equation
        l_varDeclsRes = Tpl.emptyTxt;
        l_auxFunction = Tpl.emptyTxt;
        l_tmp = Tpl.emptyTxt;
        l_xlocs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_xlocs = lm_185(l_xlocs, a_eq_vars);
        l_xlocs = Tpl.popIter(l_xlocs);
        l_prebody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_prebody, l_tmp, l_varDeclsRes) = lm_186(l_prebody, a_eq_residual, a_modelNamePrefix, l_tmp, l_varDeclsRes);
        l_prebody = Tpl.popIter(l_prebody);
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, l_auxFunction, l_varDeclsRes) = lm_189(l_body, a_eq_residual, l_auxFunction, l_varDeclsRes);
        l_body = Tpl.popIter(l_body);
        l_body__initializeStaticLSData = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__initializeStaticLSData = lm_190(l_body__initializeStaticLSData, a_eq_vars);
        l_body__initializeStaticLSData = Tpl.popIter(l_body__initializeStaticLSData);
        txt = Tpl.writeText(txt, l_auxFunction);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void residualFunc"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* dataIn, const double* xloc, double* res, const int* iflag)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) dataIn;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const int equationIndexes[2] = {1,"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.writeText(txt, l_varDeclsRes);
        txt = Tpl.softNewLine(txt);
        ret_7 = Config.profileAll();
        txt = fun_191(txt, ret_7, a_eq_index);
        txt = Tpl.softNewLine(txt);
        ret_8 = Config.profileSome();
        txt = fun_192(txt, ret_8, a_eq_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_xlocs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_prebody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        ret_9 = Config.profileAll();
        txt = fun_193(txt, ret_9, a_eq_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void initializeStaticLSData"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData, void *systemData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n",
                                    "  LINEAR_SYSTEM_DATA* linearSystemData = (LINEAR_SYSTEM_DATA*) systemData;\n",
                                    "  int i=0;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__initializeStaticLSData);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           a_eq_beqs,
           a_eq_simJac,
           a_eq_index,
           _,
           _,
           a_eq_vars )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_auxFunction = Tpl.emptyTxt;
        l_MatrixA = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_MatrixA, l_auxFunction, l_varDecls) = lm_194(l_MatrixA, a_eq_simJac, l_auxFunction, l_varDecls);
        l_MatrixA = Tpl.popIter(l_MatrixA);
        l_varDecls2 = Tpl.emptyTxt;
        l_vectorb = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_vectorb, l_auxFunction, l_varDecls2) = lm_195(l_vectorb, a_eq_beqs, l_auxFunction, l_varDecls2);
        l_vectorb = Tpl.popIter(l_vectorb);
        l_body__initializeStaticLSData = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__initializeStaticLSData = lm_196(l_body__initializeStaticLSData, a_eq_vars);
        l_body__initializeStaticLSData = Tpl.popIter(l_body__initializeStaticLSData);
        txt = Tpl.writeText(txt, l_auxFunction);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void setLinearMatrixA"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData, void *systemData)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const int equationIndexes[2] = {1,"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "DATA* data = (DATA*) inData;\n",
                                    "LINEAR_SYSTEM_DATA* linearSystemData = (LINEAR_SYSTEM_DATA*) systemData;\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_MatrixA);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void setLinearVectorb"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData, void *systemData)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const int equationIndexes[2] = {1,"));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "DATA* data = (DATA*) inData;\n",
                                    "LINEAR_SYSTEM_DATA* linearSystemData = (LINEAR_SYSTEM_DATA*) systemData;\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorb);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void initializeStaticLSData"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData, void *systemData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n",
                                    "  LINEAR_SYSTEM_DATA* linearSystemData = (LINEAR_SYSTEM_DATA*) systemData;\n",
                                    "  int i=0;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__initializeStaticLSData);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_197;

protected function fun_198
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      list<DAE.Exp> i_eq_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_eq_simJac;
      Integer i_eq_index;
      list<SimCode.SimEqSystem> i_eq_residual;
      list<SimCodeVar.SimVar> i_eq_vars;
      Option<SimCode.JacobianMatrix> i_jacobianMatrix;
      SimCode.SimEqSystem i_eq_cont;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont),
           a_modelNamePrefix )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionSetupLinearSystemsTemp(txt, ret_0, a_modelNamePrefix);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(jacobianMatrix = i_jacobianMatrix, vars = i_eq_vars, residual = i_eq_residual, index = i_eq_index, simJac = i_eq_simJac, beqs = i_eq_beqs),
           a_modelNamePrefix )
      equation
        txt = fun_197(txt, i_jacobianMatrix, i_eq_beqs, i_eq_simJac, i_eq_index, a_modelNamePrefix, i_eq_residual, i_eq_vars);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_198;

protected function lm_199
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_modelNamePrefix )
      equation
        txt = fun_198(txt, i_eqn, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_199(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_199;

public function functionSetupLinearSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_199(out_txt, a_allEquations, a_modelNamePrefix);
  out_txt := Tpl.popIter(out_txt);
end functionSetupLinearSystemsTemp;

protected function lm_201
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String a_modelNamePrefix;
      list<SimCode.SimEqSystem> i_jacobianEquations;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           ({(i_jacobianEquations, _, _)}, _, _, _, _, _, _) :: rest,
           a_modelNamePrefix )
      equation
        txt = functionInitialNonLinearSystemsTemp(txt, i_jacobianEquations, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_201(txt, rest, a_modelNamePrefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_modelNamePrefix )
      equation
        txt = lm_201(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_201;

public function functionInitialNonLinearSystems
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initialEquations;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input list<SimCode.SimEqSystem> a_allEquations;
  input list<SimCode.JacobianMatrix> a_jacobianMatrixes;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacobianbody;
  Tpl.Text l_equationbody;
  Tpl.Text l_parambody;
  Tpl.Text l_initbody;
algorithm
  l_initbody := functionInitialNonLinearSystemsTemp(Tpl.emptyTxt, a_initialEquations, a_modelNamePrefix);
  l_parambody := functionInitialNonLinearSystemsTemp(Tpl.emptyTxt, a_parameterEquations, a_modelNamePrefix);
  l_equationbody := functionInitialNonLinearSystemsTemp(Tpl.emptyTxt, a_allEquations, a_modelNamePrefix);
  l_jacobianbody := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                    "\n",
                                                                                    "\n"
                                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_jacobianbody := lm_201(l_jacobianbody, a_jacobianMatrixes, a_modelNamePrefix);
  l_jacobianbody := Tpl.popIter(l_jacobianbody);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* funtion initialize non-linear systems */\n",
                                   "void "
                               }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "initialNonLinearSystem");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(int nNonLinearSystems, NONLINEAR_SYSTEM_DATA* nonLinearSystemData)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_initbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_parambody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_equationbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_jacobianbody);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialNonLinearSystems;

protected function fun_203
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_eq_jacobianMatrix;
  input String in_a_modelPrefixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq_jacobianMatrix, in_a_modelPrefixName)
    local
      Tpl.Text txt;
      String a_modelPrefixName;
      String i_name;

    case ( txt,
           SOME((_, _, i_name, _, _, _, _)),
           a_modelPrefixName )
      equation
        txt = symbolName(txt, a_modelPrefixName, "functionJac");
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_column"));
      then txt;

    case ( txt,
           NONE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NULL"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_203;

protected function fun_204
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_eq_jacobianMatrix;
  input String in_a_modelPrefixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq_jacobianMatrix, in_a_modelPrefixName)
    local
      Tpl.Text txt;
      String a_modelPrefixName;
      String i_name;

    case ( txt,
           SOME((_, _, i_name, _, _, _, _)),
           a_modelPrefixName )
      equation
        txt = symbolName(txt, a_modelPrefixName, "initialAnalyticJacobian");
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           NONE(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NULL"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_204;

protected function fun_205
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_eq_jacobianMatrix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq_jacobianMatrix)
    local
      Tpl.Text txt;
      Integer i_jacindex;

    case ( txt,
           SOME((_, _, _, _, _, _, i_jacindex)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_jacindex));
      then txt;

    case ( txt,
           NONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-1"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_205;

protected function fun_206
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input String in_a_modelPrefixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelPrefixName)
    local
      Tpl.Text txt;
      String a_modelPrefixName;
      Integer i_eq_index;
      Integer i_eq_indexNonLinearSystem;
      list<SimCode.SimEqSystem> i_eq_eqs;
      Option<SimCode.JacobianMatrix> i_eq_jacobianMatrix;
      list<DAE.ComponentRef> i_eq_crefs;
      SimCode.SimEqSystem i_eq_cont;
      Tpl.Text l_innerEqs;
      Tpl.Text l_jacIndex;
      Tpl.Text l_initialJac;
      Tpl.Text l_generatedJac;
      Integer ret_2;
      Tpl.Text l_size;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont),
           a_modelPrefixName )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionInitialNonLinearSystemsTemp(txt, ret_0, a_modelPrefixName);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_eq_crefs, jacobianMatrix = i_eq_jacobianMatrix, eqs = i_eq_eqs, indexNonLinearSystem = i_eq_indexNonLinearSystem, index = i_eq_index),
           a_modelPrefixName )
      equation
        ret_2 = listLength(i_eq_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_generatedJac = fun_203(Tpl.emptyTxt, i_eq_jacobianMatrix, a_modelPrefixName);
        l_initialJac = fun_204(Tpl.emptyTxt, i_eq_jacobianMatrix, a_modelPrefixName);
        l_jacIndex = fun_205(Tpl.emptyTxt, i_eq_jacobianMatrix);
        l_innerEqs = functionInitialNonLinearSystemsTemp(Tpl.emptyTxt, i_eq_eqs, a_modelPrefixName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assertStreamPrint(NULL, nNonLinearSystems > "));
        txt = Tpl.writeStr(txt, intString(i_eq_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(", \"Internal Error: nNonLinearSystems mismatch!\");\n"));
        txt = Tpl.writeText(txt, l_innerEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nonLinearSystemData["));
        txt = Tpl.writeStr(txt, intString(i_eq_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].equationIndex = "));
        txt = Tpl.writeStr(txt, intString(i_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_eq_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].size = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_eq_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "].method = 0;\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_eq_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].residualFunc = residualFunc"));
        txt = Tpl.writeStr(txt, intString(i_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_eq_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].analyticalJacobianColumn = "));
        txt = Tpl.writeText(txt, l_generatedJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_eq_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].initialAnalyticalJacobian = "));
        txt = Tpl.writeText(txt, l_initialJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_eq_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].jacobianIndex = "));
        txt = Tpl.writeText(txt, l_jacIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "nonLinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_eq_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].initializeStaticNLSData = initializeStaticNLSData"));
        txt = Tpl.writeStr(txt, intString(i_eq_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_206;

protected function lm_207
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelPrefixName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelPrefixName)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelPrefixName;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_modelPrefixName )
      equation
        txt = fun_206(txt, i_eqn, a_modelPrefixName);
        txt = Tpl.nextIter(txt);
        txt = lm_207(txt, rest, a_modelPrefixName);
      then txt;
  end match;
end lm_207;

public function functionInitialNonLinearSystemsTemp
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input String a_modelPrefixName;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_207(out_txt, a_allEquations, a_modelPrefixName);
  out_txt := Tpl.popIter(out_txt);
end functionInitialNonLinearSystemsTemp;

public function functionExtraResidualsPreBody
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqs;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) :=
  match(in_txt, in_a_eq, in_a_varDecls, in_a_eqs, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqs;
      String a_modelNamePrefixStr;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           a_varDecls,
           a_eqs,
           _ )
      then (txt, a_varDecls, a_eqs);

    case ( txt,
           i_eq,
           a_varDecls,
           a_eqs,
           a_modelNamePrefixStr )
      equation
        (txt, a_varDecls, a_eqs) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_eqs, a_modelNamePrefixStr);
      then (txt, a_varDecls, a_eqs);
  end match;
end functionExtraResidualsPreBody;

public function equationNamesExtraResidualsPreBody
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           _ )
      then txt;

    case ( txt,
           i_eq,
           a_modelNamePrefixStr )
      equation
        txt = equationNames_(txt, i_eq, SimCode.contextSimulationDiscrete, a_modelNamePrefixStr);
      then txt;
  end match;
end equationNamesExtraResidualsPreBody;

protected function lm_211
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer x_i0;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = xloc["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_211(txt, rest);
      then txt;
  end match;
end lm_211;

protected function lm_212
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* static nls data for "));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "nlsData->nominal[i] = $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".nominal;\n",
                                    "nlsData->min[i]     = $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".min;\n",
                                    "nlsData->max[i++]   = $P$ATTRIBUTE"
                                }, false));
        txt = cref(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".max;"));
        txt = Tpl.nextIter(txt);
        txt = lm_212(txt, rest);
      then txt;
  end match;
end lm_212;

protected function lm_213
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq2 :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = functionExtraResidualsPreBody(txt, i_eq2, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_213(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_213;

protected function fun_214
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eq2_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq2_index)
    local
      Tpl.Text txt;
      Integer a_eq2_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq2_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeStr(txt, intString(a_eq2_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_214;

protected function fun_215
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eq2_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq2_index)
    local
      Tpl.Text txt;
      Integer a_eq2_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq2_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeStr(txt, intString(a_eq2_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_215;

protected function lm_216
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      Integer x_i0;
      Integer i_eq2_index;
      DAE.Exp i_eq2_exp;
      Boolean ret_3;
      Boolean ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_eq2_exp, index = i_eq2_index) :: rest,
           a_tmp,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls, a_tmp) = daeExp(Tpl.emptyTxt, i_eq2_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls, a_tmp);
        ret_2 = Config.profileAll();
        txt = fun_214(txt, ret_2, i_eq2_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        ret_3 = Config.profileAll();
        txt = fun_215(txt, ret_3, i_eq2_index);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_216(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_216(txt, rest, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_216;

protected function fun_217
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_217;

protected function fun_218
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ADD_NCALL_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").profileBlockIndex,1);"));
      then txt;
  end match;
end fun_218;

protected function fun_219
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_219;

protected function fun_220
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      Integer i_index;
      list<SimCode.SimEqSystem> i_eq_eqs;
      list<DAE.ComponentRef> i_crefs;
      list<SimCode.SimEqSystem> i_eqs;
      SimCode.SimEqSystem i_eq_cont;
      Boolean ret_10;
      Boolean ret_9;
      Boolean ret_8;
      Tpl.Text l_body;
      Tpl.Text l_prebody;
      Tpl.Text l_body__initializeStaticNLSData;
      Tpl.Text l_xlocs;
      Tpl.Text l_innerEqs;
      Tpl.Text l_tmp;
      Tpl.Text l_varDecls;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SimCode.SES_MIXED(cont = i_eq_cont),
           a_modelNamePrefix )
      equation
        ret_0 = List.fill(i_eq_cont, 1);
        txt = functionNonLinearResiduals(txt, ret_0, a_modelNamePrefix);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = (i_eq_eqs as i_eqs), crefs = i_crefs, index = i_index),
           a_modelNamePrefix )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_tmp = Tpl.emptyTxt;
        l_innerEqs = functionNonLinearResiduals(Tpl.emptyTxt, i_eqs, a_modelNamePrefix);
        l_xlocs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_xlocs = lm_211(l_xlocs, i_crefs);
        l_xlocs = Tpl.popIter(l_xlocs);
        l_body__initializeStaticNLSData = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_body__initializeStaticNLSData = lm_212(l_body__initializeStaticNLSData, i_crefs);
        l_body__initializeStaticNLSData = Tpl.popIter(l_body__initializeStaticNLSData);
        l_prebody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_prebody, l_tmp, l_varDecls) = lm_213(l_prebody, i_eq_eqs, a_modelNamePrefix, l_tmp, l_varDecls);
        l_prebody = Tpl.popIter(l_prebody);
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, l_tmp, l_varDecls) = lm_216(l_body, i_eq_eqs, l_tmp, l_varDecls);
        l_body = Tpl.popIter(l_body);
        txt = Tpl.writeText(txt, l_innerEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_tmp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void initializeStaticNLSData"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void *inData, void *inNlsData)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) inData;\n",
                                    "  NONLINEAR_SYSTEM_DATA* nlsData = (NONLINEAR_SYSTEM_DATA*) inNlsData;\n",
                                    "  int i=0;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_body__initializeStaticNLSData);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void residualFunc"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* dataIn, const double* xloc, double* res, const int* iflag)\n",
                                    "{\n",
                                    "  DATA* data = (DATA*) dataIn;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const int equationIndexes[2] = {1,"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        ret_8 = Config.profileAll();
        txt = fun_217(txt, ret_8, i_index);
        txt = Tpl.softNewLine(txt);
        ret_9 = Config.profileSome();
        txt = fun_218(txt, ret_9, i_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_xlocs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_prebody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        ret_10 = Config.profileAll();
        txt = fun_219(txt, ret_10, i_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_220;

protected function lm_221
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_modelNamePrefix )
      equation
        txt = fun_220(txt, i_eqn, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_221(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_221;

public function functionNonLinearResiduals
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                    "\n",
                                                                    "\n"
                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_221(out_txt, a_allEquations, a_modelNamePrefix);
  out_txt := Tpl.popIter(out_txt);
end functionNonLinearResiduals;

protected function fun_223
  input Tpl.Text in_txt;
  input SimCode.JacobianMatrix in_a_jacobianMatrix;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_jacobianMatrix, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      String i_name;

    case ( txt,
           (_, _, i_name, _, _, _, _),
           a_modelNamePrefix )
      equation
        txt = symbolName(txt, a_modelNamePrefix, "functionJac");
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_column"));
      then txt;
  end match;
end fun_223;

protected function fun_224
  input Tpl.Text in_txt;
  input SimCode.JacobianMatrix in_a_jacobianMatrix;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_jacobianMatrix, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      String i_name;

    case ( txt,
           (_, _, i_name, _, _, _, _),
           a_modelNamePrefix )
      equation
        txt = symbolName(txt, a_modelNamePrefix, "initialAnalyticJacobian");
        txt = Tpl.writeStr(txt, i_name);
      then txt;
  end match;
end fun_224;

protected function fun_225
  input Tpl.Text in_txt;
  input SimCode.JacobianMatrix in_a_jacobianMatrix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_jacobianMatrix)
    local
      Tpl.Text txt;
      Integer i_jacindex;

    case ( txt,
           (_, _, _, _, _, _, i_jacindex) )
      equation
        txt = Tpl.writeStr(txt, intString(i_jacindex));
      then txt;
  end match;
end fun_225;

protected function lm_226
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_i1)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_i1;
      Integer x_i2;
      DAE.ComponentRef i_s;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_s :: rest,
           a_i1 )
      equation
        x_i2 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("statesetData["));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].states["));
        txt = Tpl.writeStr(txt, intString(x_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = &"));
        txt = cref(txt, i_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo;"));
        txt = Tpl.nextIter(txt);
        txt = lm_226(txt, rest, a_i1);
      then txt;
  end match;
end lm_226;

protected function lm_227
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_i1)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_i1;
      Integer x_i2;
      DAE.ComponentRef i_cstate;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_cstate :: rest,
           a_i1 )
      equation
        x_i2 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("statesetData["));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].statescandidates["));
        txt = Tpl.writeStr(txt, intString(x_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = &"));
        txt = cref(txt, i_cstate);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo;"));
        txt = Tpl.nextIter(txt);
        txt = lm_227(txt, rest, a_i1);
      then txt;
  end match;
end lm_227;

protected function fun_228
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input Integer in_a_i1;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_i1, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      Integer a_i1;
      String a_modelNamePrefix;
      DAE.ComponentRef i_crA;
      Integer i_nStates;
      Integer i_nCandidates;
      list<DAE.ComponentRef> i_statescandidates;
      list<DAE.ComponentRef> i_states;
      SimCode.JacobianMatrix i_jacobianMatrix;
      Tpl.Text l_statescandidatesvars;
      Tpl.Text l_statesvars;
      Tpl.Text l_jacIndex;
      Tpl.Text l_initialJac;
      Tpl.Text l_generatedJac;

    case ( txt,
           SimCode.SES_STATESET(jacobianMatrix = i_jacobianMatrix, states = i_states, statescandidates = i_statescandidates, nCandidates = i_nCandidates, nStates = i_nStates, crA = i_crA),
           a_i1,
           a_modelNamePrefix )
      equation
        l_generatedJac = fun_223(Tpl.emptyTxt, i_jacobianMatrix, a_modelNamePrefix);
        l_initialJac = fun_224(Tpl.emptyTxt, i_jacobianMatrix, a_modelNamePrefix);
        l_jacIndex = fun_225(Tpl.emptyTxt, i_jacobianMatrix);
        l_statesvars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_statesvars = lm_226(l_statesvars, i_states, a_i1);
        l_statesvars = Tpl.popIter(l_statesvars);
        l_statescandidatesvars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_statescandidatesvars = lm_227(l_statescandidatesvars, i_statescandidates, a_i1);
        l_statescandidatesvars = Tpl.popIter(l_statescandidatesvars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("assertStreamPrint(NULL, nStateSets > "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", \"Internal Error: nStateSets mismatch!\");\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nCandidates = "));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nStates = "));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nDummyStates = "));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].states = (VAR_INFO**) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",sizeof(VAR_INFO));\n"));
        txt = Tpl.writeText(txt, l_statesvars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("statesetData["));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].statescandidates = (VAR_INFO**) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(",sizeof(VAR_INFO));\n"));
        txt = Tpl.writeText(txt, l_statescandidatesvars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("statesetData["));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].A = &"));
        txt = cref(txt, i_crA);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "__varInfo;\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].rowPivot = (modelica_integer*) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",sizeof(modelica_integer));\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].colPivot = (modelica_integer*) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",sizeof(modelica_integer));\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].J = (modelica_real*) calloc("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*("));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "),sizeof(modelica_real));\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].analyticalJacobianColumn = "));
        txt = Tpl.writeText(txt, l_generatedJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].initialAnalyticalJacobian = "));
        txt = Tpl.writeText(txt, l_initialJac);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "statesetData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].jacobianIndex = "));
        txt = Tpl.writeText(txt, l_jacIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_228;

protected function lm_229
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      String a_modelNamePrefix;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_set :: rest,
           a_modelNamePrefix )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_228(txt, i_set, x_i1, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_229(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_229;

public function functionInitialStateSets
  input Tpl.Text txt;
  input list<SimCode.StateSet> a_stateSets;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
algorithm
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                            "\n",
                                                                            "\n"
                                                                        }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_body := lm_229(l_body, a_stateSets, a_modelNamePrefix);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* funtion initialize state sets */\n",
                                   "void "
                               }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "initializeStateSets");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(int nStateSets, STATE_SET_DATA* statesetData, DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialStateSets;

protected function lm_231
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_231(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_231(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_231;

protected function lm_232
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_232(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_232(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_232;

protected function lm_233
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_233(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_233(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_233;

protected function lm_234
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(index = _)) :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextOther, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_234(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           _ :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_tmp, a_varDecls) = lm_234(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_234;

protected function lm_235
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$ATTRIBUTE"));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".min = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("infoStreamPrint(LOG_INIT, 0, \"%s(min="));
        txt = crefToPrintfArg(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")\", "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo.name, ("));
        txt = crefType(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") $P$ATTRIBUTE"));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".min);"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_235(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_235(txt, rest);
      then txt;
  end match;
end lm_235;

protected function lm_236
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$ATTRIBUTE"));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".max = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("infoStreamPrint(LOG_INIT, 0, \"%s(max="));
        txt = crefToPrintfArg(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")\", "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo.name, ("));
        txt = crefType(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") $P$ATTRIBUTE"));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".max);"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_236(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_236(txt, rest);
      then txt;
  end match;
end lm_236;

protected function lm_237
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$ATTRIBUTE"));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".nominal = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("infoStreamPrint(LOG_INIT, 0, \"%s(nominal="));
        txt = crefToPrintfArg(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")\", "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo.name, ("));
        txt = crefType(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") $P$ATTRIBUTE"));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".nominal);"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_237(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_237(txt, rest);
      then txt;
  end match;
end lm_237;

protected function lm_238
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$ATTRIBUTE"));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".start = "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("infoStreamPrint(LOG_INIT, 0, \"%s(start="));
        txt = crefToPrintfArg(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")\", "));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__varInfo.name, ("));
        txt = crefType(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")  $P$ATTRIBUTE"));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".start);"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_238(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_238(txt, rest);
      then txt;
  end match;
end lm_238;

public function functionUpdateBoundVariableAttributes
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_startValueEquations;
  input list<SimCode.SimEqSystem> a_nominalValueEquations;
  input list<SimCode.SimEqSystem> a_minValueEquations;
  input list<SimCode.SimEqSystem> a_maxValueEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_maxEqPart;
  Tpl.Text l_minEqPart;
  Tpl.Text l_nominalEqPart;
  Tpl.Text l_startEqPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_startEqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_startEqPart, l_tmp, l_varDecls) := lm_231(l_startEqPart, a_startValueEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_startEqPart := Tpl.popIter(l_startEqPart);
  l_nominalEqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_nominalEqPart, l_tmp, l_varDecls) := lm_232(l_nominalEqPart, a_nominalValueEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_nominalEqPart := Tpl.popIter(l_nominalEqPart);
  l_minEqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_minEqPart, l_tmp, l_varDecls) := lm_233(l_minEqPart, a_minValueEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_minEqPart := Tpl.popIter(l_minEqPart);
  l_maxEqPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_maxEqPart, l_tmp, l_varDecls) := lm_234(l_maxEqPart, a_maxValueEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_maxEqPart := Tpl.popIter(l_maxEqPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int "));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "updateBoundVariableAttributes");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "/* min ******************************************************** */\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_minEqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "infoStreamPrint(LOG_INIT, 1, \"updating min-values\");\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_235(out_txt, a_minValueEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "if (ACTIVE_STREAM(LOG_INIT)) messageClose(LOG_INIT);\n",
                                       "\n",
                                       "/* max ******************************************************** */\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_maxEqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "infoStreamPrint(LOG_INIT, 1, \"updating max-values\");\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_236(out_txt, a_maxValueEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "if (ACTIVE_STREAM(LOG_INIT)) messageClose(LOG_INIT);\n",
                                       "\n",
                                       "/* nominal **************************************************** */\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_nominalEqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "infoStreamPrint(LOG_INIT, 1, \"updating nominal-values\");\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_237(out_txt, a_nominalValueEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "if (ACTIVE_STREAM(LOG_INIT)) messageClose(LOG_INIT);\n",
                                       "\n",
                                       "/* start ****************************************************** */\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_startEqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "infoStreamPrint(LOG_INIT, 1, \"updating start-values\");\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_238(out_txt, a_startValueEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "if (ACTIVE_STREAM(LOG_INIT)) messageClose(LOG_INIT);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateBoundVariableAttributes;

protected function lm_240
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_240(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_240;

public function functionUpdateBoundParameters
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  System.tmpTickReset(0);
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_240(l_body, a_parameterEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int "));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "updateBoundParameters");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateBoundParameters;

protected function fun_242
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_e_index)
    local
      Tpl.Text txt;
      Integer a_e_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_e_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeStr(txt, intString(a_e_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_242;

protected function fun_243
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_e_index)
    local
      Tpl.Text txt;
      Integer a_e_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_e_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeStr(txt, intString(a_e_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_243;

protected function fun_244
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input String in_a_modelNamePrefix;
  input Integer in_a_e_index;
  input Tpl.Text in_a_eqs;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqs, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_modelNamePrefix, in_a_e_index, in_a_eqs, in_a_varDecls)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      Integer a_e_index;
      Tpl.Text a_eqs;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Boolean ret_3;
      Boolean ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.SCONST(string = _),
           _,
           _,
           a_eqs,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[i++] = 0;"));
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           i_exp,
           a_modelNamePrefix,
           a_e_index,
           a_eqs,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls, a_eqs) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls, a_eqs);
        ret_2 = Config.profileAll();
        txt = fun_242(txt, ret_2, a_e_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[i++] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        ret_3 = Config.profileAll();
        txt = fun_243(txt, ret_3, a_e_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("infoStreamPrint(LOG_RES_INIT, 0, \"[%d]: %s = %g\", i, "));
        txt = symbolName(txt, a_modelNamePrefix, "initialResidualDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(i-1), initialResiduals[i-1]);"));
      then (txt, a_eqs, a_varDecls);
  end match;
end fun_244;

public function functionInitialResidualBody
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqs;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) :=
  match(in_txt, in_a_eq, in_a_varDecls, in_a_eqs, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqs;
      String a_modelNamePrefix;
      SimCode.SimEqSystem i_eq;
      Integer i_e_index;
      DAE.Exp i_exp;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp, index = i_e_index),
           a_varDecls,
           a_eqs,
           a_modelNamePrefix )
      equation
        (txt, a_eqs, a_varDecls) = fun_244(txt, i_exp, a_modelNamePrefix, i_e_index, a_eqs, a_varDecls);
      then (txt, a_varDecls, a_eqs);

    case ( txt,
           i_eq,
           a_varDecls,
           a_eqs,
           a_modelNamePrefix )
      equation
        (txt, a_varDecls, a_eqs) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_eqs, a_modelNamePrefix);
      then (txt, a_varDecls, a_eqs);
  end match;
end functionInitialResidualBody;

protected function fun_246
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      String ret_0;

    case ( txt,
           DAE.SCONST(string = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"0\", "));
      then txt;

    case ( txt,
           i_exp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_246;

protected function lm_247
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp) :: rest )
      equation
        txt = fun_246(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_247(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_247(txt, rest);
      then txt;
  end match;
end lm_247;

protected function lm_248
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq2 :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = functionInitialResidualBody(txt, i_eq2, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_248(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_248;

protected function fun_249
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_a_residualEquations;
  input Tpl.Text in_a_resDesc;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_residualEquations, in_a_resDesc, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      Tpl.Text a_resDesc;
      String a_modelNamePrefix;

    case ( txt,
           {},
           _,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *"));
        txt = symbolName(txt, a_modelNamePrefix, "initialResidualDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int i)\n",
                                    "{\n",
                                    "  return \"empty\";\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_resDesc,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *"));
        txt = symbolName(txt, a_modelNamePrefix, "initialResidualDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int i)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *res[] = {"));
        txt = Tpl.writeText(txt, a_resDesc);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "return res[i];\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_249;

public function functionInitialResidual
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_residualEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_desc;
  Tpl.Text l_body;
  Tpl.Text l_resDesc;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_resDesc := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_resDesc := lm_247(l_resDesc, a_residualEquations);
  l_resDesc := Tpl.popIter(l_resDesc);
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_248(l_body, a_residualEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  l_desc := fun_249(Tpl.emptyTxt, a_residualEquations, l_resDesc, a_modelNamePrefix);
  out_txt := Tpl.writeText(txt, l_desc);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int "));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "initial_residual");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data, double *initialResiduals)\n",
                                       "{\n",
                                       "  const int *equationIndexes = NULL;\n",
                                       "  int i = 0;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "infoStreamPrint(LOG_RES_INIT, 1, \"updating initial residuals\");\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "if (ACTIVE_STREAM(LOG_RES_INIT)) messageClose(LOG_RES_INIT);\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialResidual;

protected function lm_251
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_eqfuncs;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqfuncs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqfuncs, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_eqfuncs, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_eqfuncs;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_eqfuncs,
           a_varDecls )
      then (txt, a_eqfuncs, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix,
           a_eqfuncs,
           a_varDecls )
      equation
        (txt, a_varDecls, a_eqfuncs) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_eqfuncs, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_eqfuncs, a_varDecls) = lm_251(txt, rest, a_modelNamePrefix, a_eqfuncs, a_varDecls);
      then (txt, a_eqfuncs, a_varDecls);
  end match;
end lm_251;

protected function lm_252
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_eqfuncs;
  input Tpl.Text in_a_eqArray;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqfuncs;
  output Tpl.Text out_a_eqArray;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqfuncs, out_a_eqArray, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_eqfuncs, in_a_eqArray, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_eqfuncs;
      Tpl.Text a_eqArray;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_eqfuncs,
           a_eqArray,
           a_varDecls )
      then (txt, a_eqfuncs, a_eqArray, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix,
           a_eqfuncs,
           a_eqArray,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_eqArray, a_eqfuncs) = equation_arrayFormat(txt, i_eq, "InitialEquations", SimCode.contextSimulationDiscrete, x_i0, a_varDecls, a_eqArray, a_eqfuncs, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_eqfuncs, a_eqArray, a_varDecls) = lm_252(txt, rest, a_modelNamePrefix, a_eqfuncs, a_eqArray, a_varDecls);
      then (txt, a_eqfuncs, a_eqArray, a_varDecls);
  end match;
end lm_252;

protected function fun_253
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_eqArray;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_eqfuncs;
  input Tpl.Text in_a_varDecls;
  input list<SimCode.SimEqSystem> in_a_initalEquations;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqArray;
  output Tpl.Text out_a_eqfuncs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqArray, out_a_eqfuncs, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_eqArray, in_a_modelNamePrefix, in_a_eqfuncs, in_a_varDecls, in_a_initalEquations)
    local
      Tpl.Text txt;
      Tpl.Text a_eqArray;
      String a_modelNamePrefix;
      Tpl.Text a_eqfuncs;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> a_initalEquations;

    case ( txt,
           false,
           a_eqArray,
           a_modelNamePrefix,
           a_eqfuncs,
           a_varDecls,
           a_initalEquations )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_eqfuncs, a_varDecls) = lm_251(txt, a_initalEquations, a_modelNamePrefix, a_eqfuncs, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_eqArray, a_eqfuncs, a_varDecls);

    case ( txt,
           _,
           a_eqArray,
           a_modelNamePrefix,
           a_eqfuncs,
           a_varDecls,
           a_initalEquations )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_eqfuncs, a_eqArray, a_varDecls) = lm_252(txt, a_initalEquations, a_modelNamePrefix, a_eqfuncs, a_eqArray, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_eqArray, a_eqfuncs, a_varDecls);
  end match;
end fun_253;

protected function fun_254
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_eqArray;
  input list<SimCode.SimEqSystem> in_a_initalEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eqArray, in_a_initalEquations)
    local
      Tpl.Text txt;
      Tpl.Text a_eqArray;
      list<SimCode.SimEqSystem> a_initalEquations;
      Integer ret_0;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eqArray,
           a_initalEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static void (*functionInitialEquations_systems["));
        ret_0 = listLength(a_initalEquations);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("])(DATA *) = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_eqArray);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_254;

protected function fun_255
  input Tpl.Text in_txt;
  input Boolean in_a_useSymbolicInitialization;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_useSymbolicInitialization)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("errorStreamPrint(LOG_INIT, 0, \"The symbolic initialization was not generated.\");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_255;

protected function fun_256
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_nrfuncs;
  input Tpl.Text in_a_fncalls;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_nrfuncs, in_a_fncalls)
    local
      Tpl.Text txt;
      Tpl.Text a_nrfuncs;
      Tpl.Text a_fncalls;

    case ( txt,
           false,
           _,
           a_fncalls )
      equation
        txt = Tpl.writeText(txt, a_fncalls);
      then txt;

    case ( txt,
           _,
           a_nrfuncs,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("PM_functionInitialEquations("));
        txt = Tpl.writeText(txt, a_nrfuncs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", data, functionInitialEquations_systems);"));
      then txt;
  end match;
end fun_256;

public function functionInitialEquations
  input Tpl.Text txt;
  input Boolean a_useSymbolicInitialization;
  input list<SimCode.SimEqSystem> a_initalEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Boolean ret_10;
  Tpl.Text l_errorMsg;
  Boolean ret_8;
  Tpl.Text l_eqArrayDecl;
  Boolean ret_6;
  Tpl.Text l_fncalls;
  Tpl.Text l_eqArray;
  Tpl.Text l_eqfuncs;
  Integer ret_2;
  Tpl.Text l_nrfuncs;
  Tpl.Text l_varDecls;
algorithm
  System.tmpTickReset(0);
  l_varDecls := Tpl.emptyTxt;
  ret_2 := listLength(a_initalEquations);
  l_nrfuncs := Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
  l_eqfuncs := Tpl.emptyTxt;
  l_eqArray := Tpl.emptyTxt;
  ret_6 := Flags.isSet(Flags.PARMODAUTO);
  (l_fncalls, l_eqArray, l_eqfuncs, l_varDecls) := fun_253(Tpl.emptyTxt, ret_6, l_eqArray, a_modelNamePrefix, l_eqfuncs, l_varDecls, a_initalEquations);
  ret_8 := Flags.isSet(Flags.PARMODAUTO);
  l_eqArrayDecl := fun_254(Tpl.emptyTxt, ret_8, l_eqArray, a_initalEquations);
  l_errorMsg := fun_255(Tpl.emptyTxt, a_useSymbolicInitialization);
  out_txt := Tpl.writeText(txt, l_eqfuncs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_eqArrayDecl);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "int "
                                   }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "functionInitialEquations");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_errorMsg);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("data->simulationInfo.discreteCall = 1;\n"));
  ret_10 := Flags.isSet(Flags.PARMODAUTO);
  out_txt := fun_256(out_txt, ret_10, l_nrfuncs, l_fncalls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "data->simulationInfo.discreteCall = 0;\n",
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialEquations;

protected function fun_258
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_e_index)
    local
      Tpl.Text txt;
      Integer a_e_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_e_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeStr(txt, intString(a_e_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_258;

protected function fun_259
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_e_index)
    local
      Tpl.Text txt;
      Integer a_e_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_e_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeStr(txt, intString(a_e_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_259;

protected function fun_260
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Integer in_a_e_index;
  input Tpl.Text in_a_eqs;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqs, out_a_varDecls) :=
  match(in_txt, in_a_exp, in_a_e_index, in_a_eqs, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_e_index;
      Tpl.Text a_eqs;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      String ret_4;
      Boolean ret_3;
      Boolean ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.SCONST(string = _),
           _,
           a_eqs,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res = 0;"));
      then (txt, a_eqs, a_varDecls);

    case ( txt,
           i_exp,
           a_e_index,
           a_eqs,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls, a_eqs) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls, a_eqs);
        ret_2 = Config.profileAll();
        txt = fun_258(txt, ret_2, a_e_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        ret_3 = Config.profileAll();
        txt = fun_259(txt, ret_3, a_e_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(fabs(res) > 1e-5)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("errorStreamPrint(LOG_INIT, 0, \"The initialization problem is inconsistent due to the following equation: 0 != %g = "));
        ret_4 = ExpressionDump.printExpStr(i_exp);
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\", res);\n",
                                    "return 1;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_eqs, a_varDecls);
  end match;
end fun_260;

public function functionRemovedInitialEquationsBody
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqs;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_varDecls, out_a_eqs) :=
  match(in_txt, in_a_eq, in_a_varDecls, in_a_eqs, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqs;
      String a_modelNamePrefix;
      SimCode.SimEqSystem i_eq;
      Integer i_e_index;
      DAE.Exp i_exp;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp, index = i_e_index),
           a_varDecls,
           a_eqs,
           _ )
      equation
        (txt, a_eqs, a_varDecls) = fun_260(txt, i_exp, i_e_index, a_eqs, a_varDecls);
      then (txt, a_varDecls, a_eqs);

    case ( txt,
           i_eq,
           a_varDecls,
           a_eqs,
           a_modelNamePrefix )
      equation
        (txt, a_varDecls, a_eqs) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_eqs, a_modelNamePrefix);
      then (txt, a_varDecls, a_eqs);
  end match;
end functionRemovedInitialEquationsBody;

protected function lm_262
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq2 :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = functionRemovedInitialEquationsBody(txt, i_eq2, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_262(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_262;

public function functionRemovedInitialEquations
  input Tpl.Text txt;
  input Boolean a_useSymbolicInitialization;
  input list<SimCode.SimEqSystem> a_removedInitalEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_body;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, l_tmp, l_varDecls) := lm_262(l_body, a_removedInitalEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int "));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "functionRemovedInitialEquations");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n",
                                       "  const int *equationIndexes = NULL;\n",
                                       "  double res = 0.0;\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_body);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionRemovedInitialEquations;

protected function lm_264
  input Tpl.Text in_txt;
  input list<tuple<Integer, tuple<DAE.Exp, DAE.Exp, DAE.Exp>>> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      list<tuple<Integer, tuple<DAE.Exp, DAE.Exp, DAE.Exp>>> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      Integer i_id;
      DAE.Exp i_delayMax;
      DAE.Exp i_d;
      DAE.Exp i_e;
      Tpl.Text l_delayExpMax;
      Tpl.Text l_delayExp;
      Tpl.Text l_eRes;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           (i_id, (i_e, i_d, i_delayMax)) :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_eRes, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_e, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls, a_auxFunction);
        (l_delayExp, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_d, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls, a_auxFunction);
        (l_delayExpMax, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_delayMax, SimCode.contextSimulationNonDiscrete, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("storeDelayedExpression(data, "));
        txt = Tpl.writeStr(txt, intString(i_id));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_eRes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", time, "));
        txt = Tpl.writeText(txt, l_delayExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_delayExpMax);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        (txt, a_auxFunction, a_varDecls) = lm_264(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_264;

protected function fun_265
  input Tpl.Text in_txt;
  input SimCode.DelayedExpression in_a_delayed;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_a_delayed, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      list<tuple<Integer, tuple<DAE.Exp, DAE.Exp, DAE.Exp>>> i_delayedExps;

    case ( txt,
           SimCode.DELAYED_EXPRESSIONS(delayedExps = i_delayedExps),
           a_auxFunction,
           a_varDecls )
      equation
        (txt, a_auxFunction, a_varDecls) = lm_264(txt, i_delayedExps, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _,
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);
  end match;
end fun_265;

public function functionStoreDelayed
  input Tpl.Text txt;
  input SimCode.DelayedExpression a_delayed;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_storePart;
  Tpl.Text l_auxFunction;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_auxFunction := Tpl.emptyTxt;
  (l_storePart, l_auxFunction, l_varDecls) := fun_265(Tpl.emptyTxt, a_delayed, l_auxFunction, l_varDecls);
  out_txt := Tpl.writeText(txt, l_auxFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int "));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "function_storeDelayed");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_storePart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("return 0;\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionStoreDelayed;

protected function lm_267
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_267(txt, rest);
      then txt;
  end match;
end lm_267;

protected function fun_268
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;
  input list<BackendDAE.WhenOperator> in_a_reinits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_a_initialCall, in_a_auxFunction, in_a_varDecls, in_a_reinits)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      list<BackendDAE.WhenOperator> a_reinits;

    case ( txt,
           true,
           a_auxFunction,
           a_varDecls,
           a_reinits )
      equation
        (txt, a_varDecls, a_auxFunction) = functionWhenReinitStatementThen(txt, true, a_reinits, a_varDecls, a_auxFunction);
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _,
           a_auxFunction,
           a_varDecls,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* nothing to do */"));
      then (txt, a_auxFunction, a_varDecls);
  end match;
end fun_268;

protected function fun_269
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_a_reinits;
  input Tpl.Text in_a_ifthen;
  input Tpl.Text in_a_helpIf;
  input Tpl.Text in_a_initial__assign;
  input Integer in_a_int;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_reinits, in_a_ifthen, in_a_helpIf, in_a_initial__assign, in_a_int)
    local
      Tpl.Text txt;
      Tpl.Text a_ifthen;
      Tpl.Text a_helpIf;
      Tpl.Text a_initial__assign;
      Integer a_int;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_ifthen,
           a_helpIf,
           a_initial__assign,
           a_int )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* for whenclause index "));
        txt = Tpl.writeStr(txt, intString(a_int));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "if(initial())\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_initial__assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else if(0"
                                }, false));
        txt = Tpl.writeText(txt, a_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_ifthen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_269;

public function genreinits
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_whenClauses;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_auxFunction;
  input Integer in_a_int;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) :=
  match(in_txt, in_a_whenClauses, in_a_varDecls, in_a_auxFunction, in_a_int)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_auxFunction;
      Integer a_int;
      Boolean i_initialCall;
      list<BackendDAE.WhenOperator> i_reinits;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_initial__assign;
      Tpl.Text l_ifthen;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions, reinits = i_reinits, initialCall = i_initialCall),
           a_varDecls,
           a_auxFunction,
           a_int )
      equation
        l_helpIf = lm_267(Tpl.emptyTxt, i_conditions);
        (l_ifthen, a_varDecls, a_auxFunction) = functionWhenReinitStatementThen(Tpl.emptyTxt, false, i_reinits, a_varDecls, a_auxFunction);
        (l_initial__assign, a_auxFunction, a_varDecls) = fun_268(Tpl.emptyTxt, i_initialCall, a_auxFunction, a_varDecls, i_reinits);
        txt = fun_269(txt, i_reinits, l_ifthen, l_helpIf, l_initial__assign, a_int);
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           _,
           a_varDecls,
           a_auxFunction,
           _ )
      then (txt, a_varDecls, a_auxFunction);
  end match;
end genreinits;

protected function fun_271
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input DAE.ComponentRef in_a_stateVar;
  input Tpl.Text in_a_val;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stateVar, in_a_val)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_stateVar;
      Tpl.Text a_val;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_stateVar,
           a_val )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_real_array_data_mem("));
        txt = Tpl.writeText(txt, a_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_stateVar,
           a_val )
      equation
        txt = cref(txt, a_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_val);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_271;

protected function fun_272
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialCall)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.needToIterate = 1;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_272;

protected function fun_273
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_expPart;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_expPart)
    local
      Tpl.Text txt;
      Tpl.Text a_expPart;

    case ( txt,
           false,
           a_expPart )
      equation
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_273;

protected function fun_274
  input Tpl.Text in_txt;
  input BackendDAE.WhenOperator in_a_reinit;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_a_reinit, in_a_initialCall, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      Boolean a_initialCall;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      DAE.Exp i_exp;
      Absyn.Info i_info;
      DAE.Exp i_level;
      DAE.Exp i_condition;
      DAE.ElementSource i_source;
      DAE.Exp i_message;
      DAE.ComponentRef i_stateVar;
      DAE.Exp i_value;
      Boolean ret_9;
      Tpl.Text l_expPart;
      list<DAE.Exp> ret_7;
      Absyn.Info ret_6;
      Tpl.Text l_msgVar;
      Tpl.Text l_needToIterate;
      DAE.Type ret_3;
      Tpl.Text l_lhs;
      Tpl.Text l_val;
      Tpl.Text l_preExp;

    case ( txt,
           BackendDAE.REINIT(value = i_value, stateVar = i_stateVar),
           a_initialCall,
           a_auxFunction,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_val, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_value, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls, a_auxFunction);
        ret_3 = ComponentReference.crefTypeConsiderSubs(i_stateVar);
        l_lhs = fun_271(Tpl.emptyTxt, ret_3, i_stateVar, l_val);
        l_needToIterate = fun_272(Tpl.emptyTxt, a_initialCall);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("infoStreamPrint(LOG_EVENTS, 0, \"reinit "));
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  = %f\", "));
        txt = Tpl.writeText(txt, l_val);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_lhs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_needToIterate);
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           BackendDAE.TERMINATE(message = i_message, source = i_source),
           _,
           a_auxFunction,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_msgVar, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_message, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("FILE_INFO info = {"));
        ret_6 = DAEUtil.getElementSourceFileInfo(i_source);
        txt = infoArgs(txt, ret_6);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "omc_terminate(info, "
                                }, false));
        txt = Tpl.writeText(txt, l_msgVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           BackendDAE.ASSERT(source = DAE.SOURCE(info = i_info), condition = i_condition, message = i_message, level = i_level),
           _,
           a_auxFunction,
           a_varDecls )
      equation
        ret_7 = List.fill(i_message, 1);
        (txt, a_varDecls, a_auxFunction) = assertCommon(txt, i_condition, ret_7, i_level, SimCode.contextSimulationDiscrete, a_varDecls, a_auxFunction, i_info);
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           BackendDAE.NORETCALL(exp = i_exp),
           _,
           a_auxFunction,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextSimulationDiscrete, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        ret_9 = Util.isCIdentifier(Tpl.textString(l_expPart));
        txt = fun_273(txt, ret_9, l_expPart);
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _,
           _,
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);
  end match;
end fun_274;

protected function lm_275
  input Tpl.Text in_txt;
  input list<BackendDAE.WhenOperator> in_items;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_initialCall, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.WhenOperator> rest;
      Boolean a_initialCall;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      BackendDAE.WhenOperator i_reinit;

    case ( txt,
           {},
           _,
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           i_reinit :: rest,
           a_initialCall,
           a_auxFunction,
           a_varDecls )
      equation
        (txt, a_auxFunction, a_varDecls) = fun_274(txt, i_reinit, a_initialCall, a_auxFunction, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls) = lm_275(txt, rest, a_initialCall, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_275;

public function functionWhenReinitStatementThen
  input Tpl.Text txt;
  input Boolean a_initialCall;
  input list<BackendDAE.WhenOperator> a_reinits;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
protected
  Tpl.Text l_body;
algorithm
  l_body := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_body, out_a_auxFunction, out_a_varDecls) := lm_275(l_body, a_reinits, a_initialCall, a_auxFunction, a_varDecls);
  l_body := Tpl.popIter(l_body);
  out_txt := Tpl.writeText(txt, l_body);
end functionWhenReinitStatementThen;

protected function lm_277
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input String in_a_modelNamePrefixStr;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_hpcOmScheduleOpt, in_a_name)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      String a_modelNamePrefixStr;
      Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;
      String a_name;
      Integer x_i0;
      list<SimCode.SimEqSystem> i_eq;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefixStr,
           a_hpcOmScheduleOpt,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system_HPCOM(txt, i_eq, a_name, x_i0, a_hpcOmScheduleOpt, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_277(txt, rest, a_modelNamePrefixStr, a_hpcOmScheduleOpt, a_name);
      then txt;
  end match;
end lm_277;

protected function lm_278
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      String a_name;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_278(txt, rest, a_name);
      then txt;
  end match;
end lm_278;

protected function fun_279
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dynamic"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static"));
      then txt;
  end match;
end fun_279;

protected function fun_280
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_name;
  input Integer in_a_nFuncs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_name, in_a_nFuncs)
    local
      Tpl.Text txt;
      String a_name;
      Integer a_nFuncs;
      Integer ret_0;

    case ( txt,
           false,
           a_name,
           a_nFuncs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(id=0; id<"));
        txt = Tpl.writeStr(txt, intString(a_nFuncs));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("; id++) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_systems[id](data);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           a_name,
           a_nFuncs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel for private(id) schedule("));
        ret_0 = Config.noProc();
        txt = fun_279(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "for(id=0; id<"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_nFuncs));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("; id++) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_systems[id](data);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_280;

protected function fun_281
  input Tpl.Text in_txt;
  input Integer in_mArg;
  input Tpl.Text in_a_varDecls;
  input list<list<SimCode.SimEqSystem>> in_a_eqs;
  input Tpl.Text in_a_funcs;
  input String in_a_name;
  input Tpl.Text in_a_loop;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_loop;
algorithm
  (out_txt, out_a_varDecls, out_a_loop) :=
  match(in_txt, in_mArg, in_a_varDecls, in_a_eqs, in_a_funcs, in_a_name, in_a_loop)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<list<SimCode.SimEqSystem>> a_eqs;
      Tpl.Text a_funcs;
      String a_name;
      Tpl.Text a_loop;
      Integer i_nFuncs;
      Boolean ret_1;
      Tpl.Text l_funcNames;

    case ( txt,
           0,
           a_varDecls,
           _,
           _,
           a_name,
           a_loop )
      equation
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("/* no "));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING(" systems */"));
      then (txt, a_varDecls, a_loop);

    case ( txt,
           1,
           a_varDecls,
           _,
           a_funcs,
           a_name,
           a_loop )
      equation
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("function"));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("_system0(data);"));
        txt = Tpl.writeText(txt, a_funcs);
      then (txt, a_varDecls, a_loop);

    case ( txt,
           i_nFuncs,
           a_varDecls,
           a_eqs,
           a_funcs,
           a_name,
           a_loop )
      equation
        l_funcNames = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funcNames = lm_278(l_funcNames, a_eqs, a_name);
        l_funcNames = Tpl.popIter(l_funcNames);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("int id;"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        ret_1 = Flags.isSet(Flags.PARMODAUTO);
        a_loop = fun_280(a_loop, ret_1, a_name, i_nFuncs);
        txt = Tpl.writeText(txt, a_funcs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static void (*function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_systems["));
        txt = Tpl.writeStr(txt, intString(i_nFuncs));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("])(DATA *) = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_funcNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then (txt, a_varDecls, a_loop);
  end match;
end fun_281;

public function functionXXX_systems_HPCOM
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_eqs;
  input String a_name;
  input Tpl.Text a_loop;
  input Tpl.Text a_varDecls;
  input Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_loop;
  output Tpl.Text out_a_varDecls;
protected
  Integer ret_1;
  Tpl.Text l_funcs;
algorithm
  l_funcs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcs := lm_277(l_funcs, a_eqs, a_modelNamePrefixStr, a_hpcOmScheduleOpt, a_name);
  l_funcs := Tpl.popIter(l_funcs);
  ret_1 := listLength(a_eqs);
  (out_txt, out_a_varDecls, out_a_loop) := fun_281(txt, ret_1, a_varDecls, a_eqs, l_funcs, a_name, a_loop);
end functionXXX_systems_HPCOM;

protected function lm_283
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.TaskList> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_type, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.TaskList> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      HpcOmSimCode.TaskList i_tasks;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_tasks :: rest,
           a_modelNamePrefixStr,
           a_type,
           a_name,
           a_derivativEquations )
      equation
        txt = functionXXX_system0_HPCOM_Level(txt, a_derivativEquations, a_name, i_tasks, Tpl.textString(a_type), a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_283(txt, rest, a_modelNamePrefixStr, a_type, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_283;

protected function lm_284
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Tpl.Text a_type;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_type )
      equation
        txt = function_HPCOM_createLockByDepTask(txt, i_task, "lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_284(txt, rest, a_type);
      then txt;
  end match;
end lm_284;

protected function lm_285
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Tpl.Text a_type;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_type )
      equation
        txt = function_HPCOM_initializeLockByDepTask(txt, i_task, "lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_285(txt, rest, a_type);
      then txt;
  end match;
end lm_285;

protected function lm_286
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      Tpl.Text a_type;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_type )
      equation
        txt = function_HPCOM_assignLockByDepTask(txt, i_task, "lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_286(txt, rest, a_type);
      then txt;
  end match;
end lm_286;

protected function lm_287
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system0_HPCOM_PThread_decl(txt, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_287(txt, rest);
      then txt;
  end match;
end lm_287;

protected function lm_288
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;
  input array<list<HpcOmSimCode.Task>> in_a_hpcOmSchedule_threadTasks;
  input Integer in_a_n;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_type, in_a_hpcOmSchedule_threadTasks, in_a_n, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> a_hpcOmSchedule_threadTasks;
      Integer a_n;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      Integer x_i0;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_modelNamePrefixStr,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_n,
           a_name,
           a_derivativEquations )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system0_HPCOM_PThread_func(txt, a_derivativEquations, a_name, a_n, a_hpcOmSchedule_threadTasks, Tpl.textString(a_type), x_i0, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_288(txt, rest, a_modelNamePrefixStr, a_type, a_hpcOmSchedule_threadTasks, a_n, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_288;

protected function lm_289
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Integer in_a_n;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_n, in_a_name)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer a_n;
      String a_name;
      Integer x_i0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_n,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system0_HPCOM_PThread_call(txt, a_name, a_n, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_289(txt, rest, a_n, a_name);
      then txt;
  end match;
end lm_289;

protected function lm_290
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system0_HPCOM_PThread_start(txt, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_290(txt, rest);
      then txt;
  end match;
end lm_290;

protected function lm_291
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_createLockByLockName(txt, intString(x_i0), "th_lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_291(txt, rest, a_type);
      then txt;
  end match;
end lm_291;

protected function lm_292
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_createLockByLockName(txt, intString(x_i0), "th_lock1", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_292(txt, rest, a_type);
      then txt;
  end match;
end lm_292;

protected function lm_293
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_initializeLockByLockName(txt, intString(x_i0), "th_lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_293(txt, rest, a_type);
      then txt;
  end match;
end lm_293;

protected function lm_294
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_initializeLockByLockName(txt, intString(x_i0), "th_lock1", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_294(txt, rest, a_type);
      then txt;
  end match;
end lm_294;

protected function lm_295
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_assignLockByLockName(txt, intString(x_i0), "th_lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_295(txt, rest, a_type);
      then txt;
  end match;
end lm_295;

protected function lm_296
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_assignLockByLockName(txt, intString(x_i0), "th_lock1", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_296(txt, rest, a_type);
      then txt;
  end match;
end lm_296;

protected function lm_297
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_type)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Tpl.Text a_type;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_type )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_releaseLockByLockName(txt, intString(x_i0), "th_lock", Tpl.textString(a_type));
        txt = Tpl.nextIter(txt);
        txt = lm_297(txt, rest, a_type);
      then txt;
  end match;
end lm_297;

protected function lm_298
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system0_HPCOM_PThread_decl(txt, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_298(txt, rest);
      then txt;
  end match;
end lm_298;

protected function lm_299
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;
  input array<list<HpcOmSimCode.Task>> in_a_hpcOmSchedule_threadTasks;
  input Integer in_a_n;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_type, in_a_hpcOmSchedule_threadTasks, in_a_n, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> a_hpcOmSchedule_threadTasks;
      Integer a_n;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      Integer x_i0;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_modelNamePrefixStr,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_n,
           a_name,
           a_derivativEquations )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system0_HPCOM_PThread_func(txt, a_derivativEquations, a_name, a_n, a_hpcOmSchedule_threadTasks, Tpl.textString(a_type), x_i0, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_299(txt, rest, a_modelNamePrefixStr, a_type, a_hpcOmSchedule_threadTasks, a_n, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_299;

protected function lm_300
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input Integer in_a_n;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_n, in_a_name)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer a_n;
      String a_name;
      Integer x_i0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_n,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system0_HPCOM_PThread_call(txt, a_name, a_n, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_300(txt, rest, a_n, a_name);
      then txt;
  end match;
end lm_300;

protected function lm_301
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system0_HPCOM_PThread_start(txt, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_301(txt, rest);
      then txt;
  end match;
end lm_301;

protected function lm_302
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_createLockByLockName(txt, intString(x_i0), "th_lock", "pthreads");
        txt = Tpl.nextIter(txt);
        txt = lm_302(txt, rest);
      then txt;
  end match;
end lm_302;

protected function lm_303
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_createLockByLockName(txt, intString(x_i0), "th_lock1", "pthreads");
        txt = Tpl.nextIter(txt);
        txt = lm_303(txt, rest);
      then txt;
  end match;
end lm_303;

protected function lm_304
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_initializeLockByLockName(txt, intString(x_i0), "th_lock", "pthreads");
        txt = Tpl.nextIter(txt);
        txt = lm_304(txt, rest);
      then txt;
  end match;
end lm_304;

protected function lm_305
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_initializeLockByLockName(txt, intString(x_i0), "th_lock1", "pthreads");
        txt = Tpl.nextIter(txt);
        txt = lm_305(txt, rest);
      then txt;
  end match;
end lm_305;

protected function lm_306
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_assignLockByLockName(txt, intString(x_i0), "th_lock", "pthreads");
        txt = Tpl.nextIter(txt);
        txt = lm_306(txt, rest);
      then txt;
  end match;
end lm_306;

protected function lm_307
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_assignLockByLockName(txt, intString(x_i0), "th_lock1", "pthreads");
        txt = Tpl.nextIter(txt);
        txt = lm_307(txt, rest);
      then txt;
  end match;
end lm_307;

protected function lm_308
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = function_HPCOM_releaseLockByLockName(txt, intString(x_i0), "th_lock", "pthreads");
        txt = Tpl.nextIter(txt);
        txt = lm_308(txt, rest);
      then txt;
  end match;
end lm_308;

protected function fun_309
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_assignLocks;
  input Tpl.Text in_a_initlocks;
  input Tpl.Text in_a_locks;
  input Integer in_a_n;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_type;
  input array<list<HpcOmSimCode.Task>> in_a_hpcOmSchedule_threadTasks;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_assignLocks, in_a_initlocks, in_a_locks, in_a_n, in_a_modelNamePrefixStr, in_a_type, in_a_hpcOmSchedule_threadTasks, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Tpl.Text a_assignLocks;
      Tpl.Text a_initlocks;
      Tpl.Text a_locks;
      Integer a_n;
      String a_modelNamePrefixStr;
      Tpl.Text a_type;
      array<list<HpcOmSimCode.Task>> a_hpcOmSchedule_threadTasks;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      list<list<HpcOmSimCode.Task>> ret_34;
      list<list<HpcOmSimCode.Task>> ret_33;
      list<list<HpcOmSimCode.Task>> ret_32;
      list<list<HpcOmSimCode.Task>> ret_31;
      list<list<HpcOmSimCode.Task>> ret_30;
      list<list<HpcOmSimCode.Task>> ret_29;
      list<list<HpcOmSimCode.Task>> ret_28;
      list<list<HpcOmSimCode.Task>> ret_27;
      list<list<HpcOmSimCode.Task>> ret_26;
      list<list<HpcOmSimCode.Task>> ret_25;
      list<list<HpcOmSimCode.Task>> ret_24;
      Integer ret_23;
      list<list<HpcOmSimCode.Task>> ret_22;
      Tpl.Text l_threadReleaseLocks;
      list<list<HpcOmSimCode.Task>> ret_20;
      Tpl.Text l_threadAssignLocks1;
      list<list<HpcOmSimCode.Task>> ret_18;
      Tpl.Text l_threadAssignLocks;
      list<list<HpcOmSimCode.Task>> ret_16;
      Tpl.Text l_threadLocksInit1;
      list<list<HpcOmSimCode.Task>> ret_14;
      Tpl.Text l_threadLocksInit;
      list<list<HpcOmSimCode.Task>> ret_12;
      Tpl.Text l_threadLocks1;
      list<list<HpcOmSimCode.Task>> ret_10;
      Tpl.Text l_threadLocks;
      list<list<HpcOmSimCode.Task>> ret_8;
      Tpl.Text l_threadStart;
      list<list<HpcOmSimCode.Task>> ret_6;
      Tpl.Text l_threadFuncCalls;
      list<list<HpcOmSimCode.Task>> ret_4;
      Tpl.Text l_threadFuncs;
      list<list<HpcOmSimCode.Task>> ret_2;
      Tpl.Text l_threadDecl;
      Tpl.Text l_taskEqs;

    case ( txt,
           "openmp",
           a_assignLocks,
           a_initlocks,
           a_locks,
           a_n,
           a_modelNamePrefixStr,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_name,
           a_derivativEquations )
      equation
        l_taskEqs = functionXXX_system0_HPCOM_Thread(Tpl.emptyTxt, a_derivativEquations, a_name, a_hpcOmSchedule_threadTasks, Tpl.textString(a_type), a_modelNamePrefixStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void terminateHpcOmThreads()\n",
                                    "{\n",
                                    "}\n",
                                    "\n",
                                    "//using type: "
                                }, false));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "static int initialized = 0;\n",
                                    "void function"
                                }, false));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(a_n));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n",
                                    "  omp_set_dynamic(0);\n",
                                    "  //create locks\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_locks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(!initialized)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_initlocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//set locks\n"
                                }, true));
        txt = Tpl.writeText(txt, a_assignLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "initialized = 1;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_taskEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "pthreads",
           a_assignLocks,
           a_initlocks,
           a_locks,
           a_n,
           a_modelNamePrefixStr,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_name,
           a_derivativEquations )
      equation
        ret_2 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadDecl = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadDecl = lm_287(l_threadDecl, ret_2);
        l_threadDecl = Tpl.popIter(l_threadDecl);
        ret_4 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadFuncs = lm_288(l_threadFuncs, ret_4, a_modelNamePrefixStr, a_type, a_hpcOmSchedule_threadTasks, a_n, a_name, a_derivativEquations);
        l_threadFuncs = Tpl.popIter(l_threadFuncs);
        ret_6 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadFuncCalls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadFuncCalls = lm_289(l_threadFuncCalls, ret_6, a_n, a_name);
        l_threadFuncCalls = Tpl.popIter(l_threadFuncCalls);
        ret_8 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadStart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadStart = lm_290(l_threadStart, ret_8);
        l_threadStart = Tpl.popIter(l_threadStart);
        ret_10 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocks = lm_291(l_threadLocks, ret_10, a_type);
        l_threadLocks = Tpl.popIter(l_threadLocks);
        ret_12 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocks1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocks1 = lm_292(l_threadLocks1, ret_12, a_type);
        l_threadLocks1 = Tpl.popIter(l_threadLocks1);
        ret_14 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocksInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocksInit = lm_293(l_threadLocksInit, ret_14, a_type);
        l_threadLocksInit = Tpl.popIter(l_threadLocksInit);
        ret_16 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocksInit1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocksInit1 = lm_294(l_threadLocksInit1, ret_16, a_type);
        l_threadLocksInit1 = Tpl.popIter(l_threadLocksInit1);
        ret_18 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadAssignLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadAssignLocks = lm_295(l_threadAssignLocks, ret_18, a_type);
        l_threadAssignLocks = Tpl.popIter(l_threadAssignLocks);
        ret_20 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadAssignLocks1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadAssignLocks1 = lm_296(l_threadAssignLocks1, ret_20, a_type);
        l_threadAssignLocks1 = Tpl.popIter(l_threadAssignLocks1);
        ret_22 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadReleaseLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadReleaseLocks = lm_297(l_threadReleaseLocks, ret_22, a_type);
        l_threadReleaseLocks = Tpl.popIter(l_threadReleaseLocks);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// number of threads: "));
        ret_23 = arrayLength(a_hpcOmSchedule_threadTasks);
        txt = Tpl.writeStr(txt, intString(ret_23));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "static int finished; //set to 1 if the hpcom-threads should be destroyed\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_threadDecl);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_locks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_threadLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadLocks1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void terminateHpcOmThreads()\n",
                                    "{\n",
                                    "  finished = 1;\n",
                                    "\n",
                                    "  //Start the threads one last time\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_threadReleaseLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_threadFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//using type: "
                                }, false));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "static int initialized = 0;\n",
                                    "void function"
                                }, false));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(a_n));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n",
                                    "  if(!initialized)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, a_initlocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadLocksInit);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadLocksInit1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//set locks\n"
                                }, true));
        txt = Tpl.writeText(txt, a_assignLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_threadAssignLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadAssignLocks1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_threadFuncCalls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("initialized = 1;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "\n",
                                    "  //Start the threads\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_threadReleaseLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//\"join\"\n"
                                }, true));
        txt = Tpl.writeText(txt, l_threadAssignLocks1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_assignLocks,
           a_initlocks,
           a_locks,
           a_n,
           a_modelNamePrefixStr,
           a_type,
           a_hpcOmSchedule_threadTasks,
           a_name,
           a_derivativEquations )
      equation
        ret_24 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadDecl = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadDecl = lm_298(l_threadDecl, ret_24);
        l_threadDecl = Tpl.popIter(l_threadDecl);
        ret_25 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadFuncs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadFuncs = lm_299(l_threadFuncs, ret_25, a_modelNamePrefixStr, a_type, a_hpcOmSchedule_threadTasks, a_n, a_name, a_derivativEquations);
        l_threadFuncs = Tpl.popIter(l_threadFuncs);
        ret_26 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadFuncCalls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadFuncCalls = lm_300(l_threadFuncCalls, ret_26, a_n, a_name);
        l_threadFuncCalls = Tpl.popIter(l_threadFuncCalls);
        ret_27 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadStart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadStart = lm_301(l_threadStart, ret_27);
        l_threadStart = Tpl.popIter(l_threadStart);
        ret_28 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocks = lm_302(l_threadLocks, ret_28);
        l_threadLocks = Tpl.popIter(l_threadLocks);
        ret_29 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocks1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocks1 = lm_303(l_threadLocks1, ret_29);
        l_threadLocks1 = Tpl.popIter(l_threadLocks1);
        ret_30 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocksInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocksInit = lm_304(l_threadLocksInit, ret_30);
        l_threadLocksInit = Tpl.popIter(l_threadLocksInit);
        ret_31 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadLocksInit1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadLocksInit1 = lm_305(l_threadLocksInit1, ret_31);
        l_threadLocksInit1 = Tpl.popIter(l_threadLocksInit1);
        ret_32 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadAssignLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadAssignLocks = lm_306(l_threadAssignLocks, ret_32);
        l_threadAssignLocks = Tpl.popIter(l_threadAssignLocks);
        ret_33 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadAssignLocks1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadAssignLocks1 = lm_307(l_threadAssignLocks1, ret_33);
        l_threadAssignLocks1 = Tpl.popIter(l_threadAssignLocks1);
        ret_34 = arrayList(a_hpcOmSchedule_threadTasks);
        l_threadReleaseLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_threadReleaseLocks = lm_308(l_threadReleaseLocks, ret_34);
        l_threadReleaseLocks = Tpl.popIter(l_threadReleaseLocks);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "static int finished; //set to 1 if the hpcom-threads should be destroyed\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_threadDecl);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_locks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_threadLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadLocks1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void terminateHpcOmThreads()\n",
                                    "{\n",
                                    "  finished = 1;\n",
                                    "\n",
                                    "  //Start the threads one last time\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_threadReleaseLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_threadFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//using type: "
                                }, false));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "static int initialized = 0;\n",
                                    "void function"
                                }, false));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(a_n));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n",
                                    "  if(!initialized)\n",
                                    "  {\n",
                                    "      finished = 0;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, a_initlocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadLocksInit);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadLocksInit1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//set locks\n"
                                }, true));
        txt = Tpl.writeText(txt, a_assignLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_threadAssignLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_threadAssignLocks1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_threadFuncCalls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("initialized = 1;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "\n",
                                    "  //Start the threads\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_threadReleaseLocks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//\"join\"\n"
                                }, true));
        txt = Tpl.writeText(txt, l_threadAssignLocks1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_309;

protected function fun_310
  input Tpl.Text in_txt;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmScheduleOpt;
  input Tpl.Text in_a_type;
  input String in_a_modelNamePrefixStr;
  input Integer in_a_n;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hpcOmScheduleOpt, in_a_type, in_a_modelNamePrefixStr, in_a_n, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Tpl.Text a_type;
      String a_modelNamePrefixStr;
      Integer a_n;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      array<list<HpcOmSimCode.Task>> i_hpcOmSchedule_threadTasks;
      list<HpcOmSimCode.Task> i_hpcOmSchedule_outgoingDepTasks;
      list<HpcOmSimCode.TaskList> i_hpcOmSchedule_tasksOfLevels;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> i_hpcOmSchedule_tasks;
      String str_6;
      Tpl.Text l_assignLocks;
      Tpl.Text l_initlocks;
      Tpl.Text l_locks;
      Integer ret_2;
      Tpl.Text l_odeEqs;
      Tpl.Text l_taskEqs;

    case ( txt,
           SOME(HpcOmSimCode.EMPTYSCHEDULE()),
           _,
           a_modelNamePrefixStr,
           a_n,
           a_name,
           a_derivativEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void terminateHpcOmThreads()\n",
                                    "{\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = functionXXX_system(txt, a_derivativEquations, a_name, a_n, a_modelNamePrefixStr);
      then txt;

    case ( txt,
           SOME(HpcOmSimCode.TASKDEPSCHEDULE(tasks = i_hpcOmSchedule_tasks)),
           a_type,
           a_modelNamePrefixStr,
           a_n,
           a_name,
           a_derivativEquations )
      equation
        l_taskEqs = functionXXX_system0_HPCOM_TaskDep(Tpl.emptyTxt, i_hpcOmSchedule_tasks, a_derivativEquations, Tpl.textString(a_type), a_name, a_modelNamePrefixStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void terminateHpcOmThreads()\n",
                                    "{\n",
                                    "}\n",
                                    "\n",
                                    "//using type: "
                                }, false));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(a_n));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_taskEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           SOME(HpcOmSimCode.LEVELSCHEDULE(tasksOfLevels = i_hpcOmSchedule_tasksOfLevels)),
           a_type,
           a_modelNamePrefixStr,
           a_n,
           a_name,
           a_derivativEquations )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_odeEqs = lm_283(l_odeEqs, i_hpcOmSchedule_tasksOfLevels, a_modelNamePrefixStr, a_type, a_name, a_derivativEquations);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void terminateHpcOmThreads()\n",
                                    "{\n",
                                    "}\n",
                                    "\n",
                                    "//using type: "
                                }, false));
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(a_n));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA *data)\n",
                                    "{\n",
                                    "  omp_set_dynamic(0);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel num_threads("));
        ret_2 = Flags.getConfigInt(Flags.NUM_PROC);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           SOME(HpcOmSimCode.THREADSCHEDULE(outgoingDepTasks = i_hpcOmSchedule_outgoingDepTasks, threadTasks = i_hpcOmSchedule_threadTasks)),
           a_type,
           a_modelNamePrefixStr,
           a_n,
           a_name,
           a_derivativEquations )
      equation
        l_locks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_locks = lm_284(l_locks, i_hpcOmSchedule_outgoingDepTasks, a_type);
        l_locks = Tpl.popIter(l_locks);
        l_initlocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_initlocks = lm_285(l_initlocks, i_hpcOmSchedule_outgoingDepTasks, a_type);
        l_initlocks = Tpl.popIter(l_initlocks);
        l_assignLocks = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_assignLocks = lm_286(l_assignLocks, i_hpcOmSchedule_outgoingDepTasks, a_type);
        l_assignLocks = Tpl.popIter(l_assignLocks);
        str_6 = Tpl.textString(a_type);
        txt = fun_309(txt, str_6, l_assignLocks, l_initlocks, l_locks, a_n, a_modelNamePrefixStr, a_type, i_hpcOmSchedule_threadTasks, a_name, a_derivativEquations);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_310;

public function functionXXX_system_HPCOM
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input Integer a_n;
  input Option<HpcOmSimCode.Schedule> a_hpcOmScheduleOpt;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
protected
  String ret_1;
  Tpl.Text l_type;
algorithm
  ret_1 := Flags.getConfigString(Flags.HPCOM_CODE);
  l_type := Tpl.writeStr(Tpl.emptyTxt, ret_1);
  out_txt := fun_310(txt, a_hpcOmScheduleOpt, l_type, a_modelNamePrefixStr, a_n, a_name, a_derivativEquations);
end functionXXX_system_HPCOM;

protected function lm_312
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input String in_a_modelNamePrefixStr;
  input String in_a_iType;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_iType, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      String a_modelNamePrefixStr;
      String a_iType;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_modelNamePrefixStr,
           a_iType,
           a_name,
           a_derivativEquations )
      equation
        txt = functionXXX_system0_HPCOM_Level0Section(txt, a_derivativEquations, a_name, i_task, a_iType, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_312(txt, rest, a_modelNamePrefixStr, a_iType, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_312;

protected function lm_313
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input String in_a_modelNamePrefixStr;
  input String in_a_iType;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_iType, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      String a_modelNamePrefixStr;
      String a_iType;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      HpcOmSimCode.Task i_task;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_task :: rest,
           a_modelNamePrefixStr,
           a_iType,
           a_name,
           a_derivativEquations )
      equation
        txt = functionXXX_system0_HPCOM_Level0(txt, a_derivativEquations, a_name, i_task, a_iType, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_313(txt, rest, a_modelNamePrefixStr, a_iType, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_313;

protected function fun_314
  input Tpl.Text in_txt;
  input HpcOmSimCode.TaskList in_a_tasksOfLevel;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;
  input String in_a_name;
  input String in_a_iType;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_tasksOfLevel, in_a_derivativEquations, in_a_name, in_a_iType, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_derivativEquations;
      String a_name;
      String a_iType;
      String a_modelNamePrefixStr;
      list<HpcOmSimCode.Task> i_tasks;
      Tpl.Text l_odeEqs;

    case ( txt,
           HpcOmSimCode.PARALLELTASKLIST(tasks = i_tasks),
           a_derivativEquations,
           a_name,
           a_iType,
           a_modelNamePrefixStr )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_odeEqs = lm_312(l_odeEqs, i_tasks, a_modelNamePrefixStr, a_iType, a_name, a_derivativEquations);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma omp sections\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "#pragma omp barrier //I\'m not sure if this is required"
                                }, false));
      then txt;

    case ( txt,
           HpcOmSimCode.SERIALTASKLIST(tasks = i_tasks),
           a_derivativEquations,
           a_name,
           a_iType,
           a_modelNamePrefixStr )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_odeEqs = lm_313(l_odeEqs, i_tasks, a_modelNamePrefixStr, a_iType, a_name, a_derivativEquations);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma omp master\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "#pragma omp barrier"
                                }, false));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_314;

public function functionXXX_system0_HPCOM_Level
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input HpcOmSimCode.TaskList a_tasksOfLevel;
  input String a_iType;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_314(txt, a_tasksOfLevel, a_derivativEquations, a_name, a_iType, a_modelNamePrefixStr);
end functionXXX_system0_HPCOM_Level;

public function functionXXX_system0_HPCOM_Level0
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input HpcOmSimCode.Task a_iTask;
  input String a_iType;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
  out_txt := function_HPCOM_Task(out_txt, a_derivativEquations, a_name, a_iTask, a_iType, a_modelNamePrefixStr);
  out_txt := Tpl.popBlock(out_txt);
end functionXXX_system0_HPCOM_Level0;

public function functionXXX_system0_HPCOM_Level0Section
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input HpcOmSimCode.Task a_iTask;
  input String a_iType;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#pragma omp section\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := function_HPCOM_Task(out_txt, a_derivativEquations, a_name, a_iTask, a_iType, a_modelNamePrefixStr);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionXXX_system0_HPCOM_Level0Section;

protected function lm_318
  input Tpl.Text in_txt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> in_items;
  input String in_a_modelNamePrefixStr;
  input String in_a_name;
  input String in_a_iType;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_name, in_a_iType, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<tuple<HpcOmSimCode.Task, list<Integer>>> rest;
      String a_modelNamePrefixStr;
      String a_name;
      String a_iType;
      list<SimCode.SimEqSystem> a_derivativEquations;
      tuple<HpcOmSimCode.Task, list<Integer>> i_t;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_t :: rest,
           a_modelNamePrefixStr,
           a_name,
           a_iType,
           a_derivativEquations )
      equation
        txt = functionXXX_system0_HPCOM_TaskDep0(txt, i_t, a_derivativEquations, a_iType, a_name, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_318(txt, rest, a_modelNamePrefixStr, a_name, a_iType, a_derivativEquations);
      then txt;
  end match;
end lm_318;

public function functionXXX_system0_HPCOM_TaskDep
  input Tpl.Text txt;
  input list<tuple<HpcOmSimCode.Task, list<Integer>>> a_tasks;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_iType;
  input String a_name;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_odeEqs;
algorithm
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_odeEqs := lm_318(l_odeEqs, a_tasks, a_modelNamePrefixStr, a_name, a_iType, a_derivativEquations);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "int t[0];\n",
                                   "#pragma omp parallel\n",
                                   "{\n",
                                   "  #pragma omp master\n",
                                   "  {\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(6));
  out_txt := Tpl.writeText(out_txt, l_odeEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  }\n",
                                       "}"
                                   }, false));
end functionXXX_system0_HPCOM_TaskDep;

protected function lm_320
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_p;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_p :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("t["));
        txt = Tpl.writeStr(txt, intString(i_p));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
        txt = Tpl.nextIter(txt);
        txt = lm_320(txt, rest);
      then txt;
  end match;
end lm_320;

protected function fun_321
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_parentDependencies;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_parentDependencies)
    local
      Tpl.Text txt;
      Tpl.Text a_parentDependencies;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_parentDependencies )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("depend(in:"));
        txt = Tpl.writeText(txt, a_parentDependencies);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_321;

public function functionXXX_system0_HPCOM_TaskDep0
  input Tpl.Text in_txt;
  input tuple<HpcOmSimCode.Task, list<Integer>> in_a_taskIn;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;
  input String in_a_iType;
  input String in_a_name;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_taskIn, in_a_derivativEquations, in_a_iType, in_a_name, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_derivativEquations;
      String a_iType;
      String a_name;
      String a_modelNamePrefixStr;
      Integer i_task_index;
      list<Integer> i_parents;
      HpcOmSimCode.Task i_task;
      Boolean ret_4;
      Integer ret_3;
      Tpl.Text l_depIn;
      Tpl.Text l_parentDependencies;
      Tpl.Text l_taskEqs;

    case ( txt,
           ((i_task as HpcOmSimCode.CALCTASK(index = i_task_index)), i_parents),
           a_derivativEquations,
           a_iType,
           a_name,
           a_modelNamePrefixStr )
      equation
        l_taskEqs = function_HPCOM_Task(Tpl.emptyTxt, a_derivativEquations, a_name, i_task, a_iType, a_modelNamePrefixStr);
        l_parentDependencies = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_parentDependencies = lm_320(l_parentDependencies, i_parents);
        l_parentDependencies = Tpl.popIter(l_parentDependencies);
        ret_3 = listLength(i_parents);
        ret_4 = intGt(ret_3, 0);
        l_depIn = fun_321(Tpl.emptyTxt, ret_4, l_parentDependencies);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp task "));
        txt = Tpl.writeText(txt, l_depIn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" depend(out:t["));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "])\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_taskEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end functionXXX_system0_HPCOM_TaskDep0;

protected function lm_323
  input Tpl.Text in_txt;
  input list<list<HpcOmSimCode.Task>> in_items;
  input String in_a_modelNamePrefixStr;
  input String in_a_iType;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_iType, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<list<HpcOmSimCode.Task>> rest;
      String a_modelNamePrefixStr;
      String a_iType;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      list<HpcOmSimCode.Task> i_tt;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_tt :: rest,
           a_modelNamePrefixStr,
           a_iType,
           a_name,
           a_derivativEquations )
      equation
        txt = functionXXX_system0_HPCOM_Thread0(txt, a_derivativEquations, a_name, i_tt, a_iType, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_323(txt, rest, a_modelNamePrefixStr, a_iType, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_323;

protected function fun_324
  input Tpl.Text in_txt;
  input String in_a_iType;
  input Tpl.Text in_a_odeEqs;
  input array<list<HpcOmSimCode.Task>> in_a_threadTasks;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_odeEqs, in_a_threadTasks)
    local
      Tpl.Text txt;
      Tpl.Text a_odeEqs;
      array<list<HpcOmSimCode.Task>> a_threadTasks;
      Integer ret_0;

    case ( txt,
           "openmp",
           a_odeEqs,
           a_threadTasks )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if (omp_get_dynamic())\n",
                                    "  omp_set_dynamic(0);\n",
                                    "#pragma omp parallel sections num_threads("
                                }, false));
        ret_0 = arrayLength(a_threadTasks);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, a_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "pthreads",
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//not implemented"));
      then txt;

    case ( txt,
           "pthreads_spin",
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//not implemented"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_324;

public function functionXXX_system0_HPCOM_Thread
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input array<list<HpcOmSimCode.Task>> a_threadTasks;
  input String a_iType;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
protected
  list<list<HpcOmSimCode.Task>> ret_1;
  Tpl.Text l_odeEqs;
algorithm
  ret_1 := arrayList(a_threadTasks);
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_odeEqs := lm_323(l_odeEqs, ret_1, a_modelNamePrefixStr, a_iType, a_name, a_derivativEquations);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  out_txt := fun_324(txt, a_iType, l_odeEqs, a_threadTasks);
end functionXXX_system0_HPCOM_Thread;

protected function lm_326
  input Tpl.Text in_txt;
  input list<HpcOmSimCode.Task> in_items;
  input String in_a_modelNamePrefixStr;
  input String in_a_iType;
  input String in_a_name;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_iType, in_a_name, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<HpcOmSimCode.Task> rest;
      String a_modelNamePrefixStr;
      String a_iType;
      String a_name;
      list<SimCode.SimEqSystem> a_derivativEquations;
      HpcOmSimCode.Task i_tt;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_tt :: rest,
           a_modelNamePrefixStr,
           a_iType,
           a_name,
           a_derivativEquations )
      equation
        txt = function_HPCOM_Task(txt, a_derivativEquations, a_name, i_tt, a_iType, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_326(txt, rest, a_modelNamePrefixStr, a_iType, a_name, a_derivativEquations);
      then txt;
  end match;
end lm_326;

protected function fun_327
  input Tpl.Text in_txt;
  input String in_a_iType;
  input Tpl.Text in_a_threadTasks;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_threadTasks)
    local
      Tpl.Text txt;
      Tpl.Text a_threadTasks;

    case ( txt,
           "openmp",
           a_threadTasks )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma omp section\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_threadTasks);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           "pthreads",
           a_threadTasks )
      equation
        txt = Tpl.writeText(txt, a_threadTasks);
      then txt;

    case ( txt,
           "pthreads_spin",
           a_threadTasks )
      equation
        txt = Tpl.writeText(txt, a_threadTasks);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_327;

public function functionXXX_system0_HPCOM_Thread0
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input list<HpcOmSimCode.Task> a_threadTaskList;
  input String a_iType;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_threadTasks;
algorithm
  l_threadTasks := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_threadTasks := lm_326(l_threadTasks, a_threadTaskList, a_modelNamePrefixStr, a_iType, a_name, a_derivativEquations);
  l_threadTasks := Tpl.popIter(l_threadTasks);
  out_txt := fun_327(txt, a_iType, l_threadTasks);
end functionXXX_system0_HPCOM_Thread0;

protected function lm_329
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input String in_a_modelNamePrefixStr;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<Integer> rest;
      String a_modelNamePrefixStr;
      list<SimCode.SimEqSystem> a_derivativEquations;
      Integer i_eq;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefixStr,
           a_derivativEquations )
      equation
        txt = equationNamesHPCOM_Thread_(txt, i_eq, a_derivativEquations, SimCode.contextSimulationNonDiscrete, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_329(txt, rest, a_modelNamePrefixStr, a_derivativEquations);
      then txt;
  end match;
end lm_329;

protected function lm_330
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input String in_a_modelNamePrefixStr;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_derivativEquations)
    local
      Tpl.Text txt;
      list<Integer> rest;
      String a_modelNamePrefixStr;
      list<SimCode.SimEqSystem> a_derivativEquations;
      Integer i_eq;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefixStr,
           a_derivativEquations )
      equation
        txt = equationNamesHPCOM_Thread_(txt, i_eq, a_derivativEquations, SimCode.contextSimulationNonDiscrete, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_330(txt, rest, a_modelNamePrefixStr, a_derivativEquations);
      then txt;
  end match;
end lm_330;

protected function fun_331
  input Tpl.Text in_txt;
  input HpcOmSimCode.Task in_a_iTask;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;
  input String in_a_iType;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iTask, in_a_derivativEquations, in_a_iType, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_derivativEquations;
      String a_iType;
      String a_modelNamePrefixStr;
      HpcOmSimCode.Task i_task;
      Integer i_task_index;
      list<Integer> i_task_eqIdc;
      Tpl.Text l_relLck;
      Tpl.Text l_assLck;
      Tpl.Text l_odeEqs;

    case ( txt,
           HpcOmSimCode.CALCTASK(eqIdc = i_task_eqIdc, index = i_task_index),
           a_derivativEquations,
           _,
           a_modelNamePrefixStr )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_odeEqs = lm_329(l_odeEqs, i_task_eqIdc, a_modelNamePrefixStr, a_derivativEquations);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Task "));
        txt = Tpl.writeStr(txt, intString(i_task_index));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_odeEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// End Task "));
        txt = Tpl.writeStr(txt, intString(i_task_index));
      then txt;

    case ( txt,
           HpcOmSimCode.CALCTASK_LEVEL(eqIdc = i_task_eqIdc),
           a_derivativEquations,
           _,
           a_modelNamePrefixStr )
      equation
        l_odeEqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_odeEqs = lm_330(l_odeEqs, i_task_eqIdc, a_modelNamePrefixStr, a_derivativEquations);
        l_odeEqs = Tpl.popIter(l_odeEqs);
        txt = Tpl.writeText(txt, l_odeEqs);
      then txt;

    case ( txt,
           (i_task as HpcOmSimCode.DEPTASK(outgoing = false)),
           _,
           a_iType,
           _ )
      equation
        l_assLck = function_HPCOM_assignLockByDepTask(Tpl.emptyTxt, i_task, "lock", a_iType);
        txt = Tpl.writeText(txt, l_assLck);
      then txt;

    case ( txt,
           (i_task as HpcOmSimCode.DEPTASK(outgoing = true)),
           _,
           a_iType,
           _ )
      equation
        l_relLck = function_HPCOM_releaseLockByDepTask(Tpl.emptyTxt, i_task, "lock", a_iType);
        txt = Tpl.writeText(txt, l_relLck);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_331;

public function function_HPCOM_Task
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input HpcOmSimCode.Task a_iTask;
  input String a_iType;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_331(txt, a_iTask, a_derivativEquations, a_iType, a_modelNamePrefixStr);
end function_HPCOM_Task;

public function function_HPCOM_getLockNameByDepTask
  input Tpl.Text in_txt;
  input HpcOmSimCode.Task in_a_depTask;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_depTask)
    local
      Tpl.Text txt;
      Integer i_targetIdx;
      Integer i_sourceIdx;

    case ( txt,
           HpcOmSimCode.DEPTASK(sourceTask = HpcOmSimCode.CALCTASK(index = i_sourceIdx), targetTask = HpcOmSimCode.CALCTASK(index = i_targetIdx)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_sourceIdx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(i_targetIdx));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("invalidLockTask"));
      then txt;
  end match;
end function_HPCOM_getLockNameByDepTask;

public function function_HPCOM_initializeLockByDepTask
  input Tpl.Text txt;
  input HpcOmSimCode.Task a_depTask;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockName;
algorithm
  l_lockName := function_HPCOM_getLockNameByDepTask(Tpl.emptyTxt, a_depTask);
  out_txt := function_HPCOM_initializeLockByLockName(txt, Tpl.textString(l_lockName), a_lockPrefix, a_iType);
end function_HPCOM_initializeLockByDepTask;

protected function fun_335
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "openmp",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_init_lock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           "pthreads",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pthread_mutex_init(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", NULL);"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pthread_spin_init(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", 0);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_335;

public function function_HPCOM_initializeLockByLockName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_335(txt, a_iType, a_lockName, a_lockPrefix);
end function_HPCOM_initializeLockByLockName;

public function function_HPCOM_createLockByDepTask
  input Tpl.Text txt;
  input HpcOmSimCode.Task a_depTask;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockName;
algorithm
  l_lockName := function_HPCOM_getLockNameByDepTask(Tpl.emptyTxt, a_depTask);
  out_txt := function_HPCOM_createLockByLockName(txt, Tpl.textString(l_lockName), a_lockPrefix, a_iType);
end function_HPCOM_createLockByDepTask;

protected function fun_338
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "openmp",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static omp_lock_t "));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           "pthreads",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static pthread_mutex_t "));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static pthread_spinlock_t "));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_338;

public function function_HPCOM_createLockByLockName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_338(txt, a_iType, a_lockName, a_lockPrefix);
end function_HPCOM_createLockByLockName;

public function function_HPCOM_assignLockByDepTask
  input Tpl.Text txt;
  input HpcOmSimCode.Task a_depTask;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockName;
algorithm
  l_lockName := function_HPCOM_getLockNameByDepTask(Tpl.emptyTxt, a_depTask);
  out_txt := function_HPCOM_assignLockByLockName(txt, Tpl.textString(l_lockName), a_lockPrefix, a_iType);
end function_HPCOM_assignLockByDepTask;

protected function fun_341
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "openmp",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_set_lock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           "pthreads",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pthread_mutex_lock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pthread_spin_lock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_341;

public function function_HPCOM_assignLockByLockName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_341(txt, a_iType, a_lockName, a_lockPrefix);
end function_HPCOM_assignLockByLockName;

public function function_HPCOM_releaseLockByDepTask
  input Tpl.Text txt;
  input HpcOmSimCode.Task a_depTask;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_lockName;
algorithm
  l_lockName := function_HPCOM_getLockNameByDepTask(Tpl.emptyTxt, a_depTask);
  out_txt := function_HPCOM_releaseLockByLockName(txt, Tpl.textString(l_lockName), a_lockPrefix, a_iType);
end function_HPCOM_releaseLockByDepTask;

protected function fun_344
  input Tpl.Text in_txt;
  input String in_a_iType;
  input String in_a_lockName;
  input String in_a_lockPrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iType, in_a_lockName, in_a_lockPrefix)
    local
      Tpl.Text txt;
      String a_lockName;
      String a_lockPrefix;

    case ( txt,
           "openmp",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omp_unset_lock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           "pthreads",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pthread_mutex_unlock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           "pthreads_spin",
           a_lockName,
           a_lockPrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("pthread_spin_unlock(&"));
        txt = Tpl.writeStr(txt, a_lockPrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_lockName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_344;

public function function_HPCOM_releaseLockByLockName
  input Tpl.Text txt;
  input String a_lockName;
  input String a_lockPrefix;
  input String a_iType;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_344(txt, a_iType, a_lockName, a_lockPrefix);
end function_HPCOM_releaseLockByLockName;

public function functionXXX_system0_HPCOM_PThread_func
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input Integer a_n;
  input array<list<HpcOmSimCode.Task>> a_threadTasks;
  input String a_iType;
  input Integer a_idx;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_relLock;
  Tpl.Text l_assLock;
  list<HpcOmSimCode.Task> ret_2;
  Integer ret_1;
  Tpl.Text l_taskEqs;
algorithm
  ret_1 := intAdd(a_idx, 1);
  ret_2 := arrayGet(a_threadTasks, ret_1);
  l_taskEqs := functionXXX_system0_HPCOM_Thread0(Tpl.emptyTxt, a_derivativEquations, a_name, ret_2, a_iType, a_modelNamePrefixStr);
  l_assLock := function_HPCOM_assignLockByLockName(Tpl.emptyTxt, intString(a_idx), "th_lock", "pthreads");
  l_relLock := function_HPCOM_releaseLockByLockName(Tpl.emptyTxt, intString(a_idx), "th_lock1", "pthreads");
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("void function"));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_system"));
  out_txt := Tpl.writeStr(out_txt, intString(a_n));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_thread_"));
  out_txt := Tpl.writeStr(out_txt, intString(a_idx));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n",
                                       "  while(1)\n",
                                       "  {\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  out_txt := Tpl.writeText(out_txt, l_assLock);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "if(finished)\n",
                                       "   return;\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_taskEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_relLock);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  }\n",
                                       "}"
                                   }, false));
end functionXXX_system0_HPCOM_PThread_func;

public function functionXXX_system0_HPCOM_PThread_call
  input Tpl.Text txt;
  input String a_name;
  input Integer a_n;
  input Integer a_idx;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("GC_pthread_create(&odeThread_"));
  out_txt := Tpl.writeStr(out_txt, intString(a_idx));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(", NULL, function"));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_system"));
  out_txt := Tpl.writeStr(out_txt, intString(a_n));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_thread_"));
  out_txt := Tpl.writeStr(out_txt, intString(a_idx));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(", data);"));
end functionXXX_system0_HPCOM_PThread_call;

public function functionXXX_system0_HPCOM_PThread_decl
  input Tpl.Text txt;
  input Integer a_idx;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("static pthread_t odeThread_"));
  out_txt := Tpl.writeStr(out_txt, intString(a_idx));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(";"));
end functionXXX_system0_HPCOM_PThread_decl;

public function functionXXX_system0_HPCOM_PThread_start
  input Tpl.Text txt;
  input Integer a_idx;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("pthread_mutex_lock(&th_unlock_"));
  out_txt := Tpl.writeStr(out_txt, intString(a_idx));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(");"));
end functionXXX_system0_HPCOM_PThread_start;

protected function fun_350
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_mArg;
  input String in_a_modelNamePrefixStr;
  input Integer in_a_idx;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_modelNamePrefixStr, in_a_idx, in_a_derivativEquations)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      Integer a_idx;
      list<SimCode.SimEqSystem> a_derivativEquations;
      SimCode.SimEqSystem ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_modelNamePrefixStr,
           a_idx,
           a_derivativEquations )
      equation
        ret_1 = HpcOmSimCodeMain.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, ret_1);
        txt = symbolName(txt, a_modelNamePrefixStr, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(data);"));
      then txt;
  end match;
end fun_350;

protected function fun_351
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_mArg;
  input String in_a_modelNamePrefixStr;
  input Integer in_a_idx;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_modelNamePrefixStr, in_a_idx, in_a_derivativEquations)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      Integer a_idx;
      list<SimCode.SimEqSystem> a_derivativEquations;
      SimCode.SimEqSystem ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_modelNamePrefixStr,
           a_idx,
           a_derivativEquations )
      equation
        ret_1 = HpcOmSimCodeMain.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, ret_1);
        txt = symbolName(txt, a_modelNamePrefixStr, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(data);"));
      then txt;
  end match;
end fun_351;

protected function fun_352
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Integer in_a_idx;
  input list<SimCode.SimEqSystem> in_a_derivativEquations;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_idx, in_a_derivativEquations, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      Integer a_idx;
      list<SimCode.SimEqSystem> a_derivativEquations;
      String a_modelNamePrefixStr;
      SimCode.SimEqSystem ret_1;
      SimCode.SimEqSystem ret_0;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true),
           a_idx,
           a_derivativEquations,
           a_modelNamePrefixStr )
      equation
        ret_0 = HpcOmSimCodeMain.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        txt = fun_350(txt, ret_0, a_modelNamePrefixStr, a_idx, a_derivativEquations);
      then txt;

    case ( txt,
           _,
           a_idx,
           a_derivativEquations,
           a_modelNamePrefixStr )
      equation
        ret_1 = HpcOmSimCodeMain.getSimCodeEqByIndex(a_derivativEquations, a_idx);
        txt = fun_351(txt, ret_1, a_modelNamePrefixStr, a_idx, a_derivativEquations);
      then txt;
  end match;
end fun_352;

public function equationNamesHPCOM_Thread_
  input Tpl.Text txt;
  input Integer a_idx;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input SimCode.Context a_context;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_352(txt, a_context, a_idx, a_derivativEquations, a_modelNamePrefixStr);
end equationNamesHPCOM_Thread_;

protected function lm_354
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefixStr;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefixStr )
      equation
        txt = equationNames_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_354(txt, rest, a_modelNamePrefixStr);
      then txt;
  end match;
end lm_354;

protected function lm_355
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefixStr;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefixStr )
      equation
        txt = equationForward_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_355(txt, rest, a_modelNamePrefixStr);
      then txt;
  end match;
end lm_355;

public function functionXXX_system
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_derivativEquations;
  input String a_name;
  input Integer a_n;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_forwardEqs;
  Tpl.Text l_odeEqs;
algorithm
  l_odeEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_odeEqs := lm_354(l_odeEqs, a_derivativEquations, a_modelNamePrefixStr);
  l_odeEqs := Tpl.popIter(l_odeEqs);
  l_forwardEqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_forwardEqs := lm_355(l_forwardEqs, a_derivativEquations, a_modelNamePrefixStr);
  l_forwardEqs := Tpl.popIter(l_forwardEqs);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "/* forwarded equations */\n"
                               }, true));
  out_txt := Tpl.writeText(out_txt, l_forwardEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "static void function"
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_system"));
  out_txt := Tpl.writeStr(out_txt, intString(a_n));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_odeEqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionXXX_system;

protected function lm_357
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input String in_a_modelNamePrefixStr;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_name)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      String a_modelNamePrefixStr;
      String a_name;
      Integer x_i0;
      list<SimCode.SimEqSystem> i_eq;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefixStr,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = functionXXX_system(txt, i_eq, a_name, x_i0, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        txt = lm_357(txt, rest, a_modelNamePrefixStr, a_name);
      then txt;
  end match;
end lm_357;

protected function lm_358
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      String a_name;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_system"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_358(txt, rest, a_name);
      then txt;
  end match;
end lm_358;

protected function fun_359
  input Tpl.Text in_txt;
  input Integer in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           0 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dynamic"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static"));
      then txt;
  end match;
end fun_359;

protected function fun_360
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;
      Integer ret_0;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#pragma omp parallel for private(id) schedule("));
        ret_0 = Config.noProc();
        txt = fun_359(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_360;

protected function fun_361
  input Tpl.Text in_txt;
  input Integer in_mArg;
  input Tpl.Text in_a_varDecls;
  input list<list<SimCode.SimEqSystem>> in_a_eqs;
  input Tpl.Text in_a_funcs;
  input String in_a_name;
  input Tpl.Text in_a_loop;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_loop;
algorithm
  (out_txt, out_a_varDecls, out_a_loop) :=
  match(in_txt, in_mArg, in_a_varDecls, in_a_eqs, in_a_funcs, in_a_name, in_a_loop)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      list<list<SimCode.SimEqSystem>> a_eqs;
      Tpl.Text a_funcs;
      String a_name;
      Tpl.Text a_loop;
      Integer i_nFuncs;
      Boolean ret_2;
      Tpl.Text l_head;
      Tpl.Text l_funcNames;

    case ( txt,
           0,
           a_varDecls,
           _,
           _,
           a_name,
           a_loop )
      equation
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("/* no "));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING(" systems */"));
      then (txt, a_varDecls, a_loop);

    case ( txt,
           1,
           a_varDecls,
           _,
           a_funcs,
           a_name,
           a_loop )
      equation
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("function"));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("_system0(data);"));
        txt = Tpl.writeText(txt, a_funcs);
      then (txt, a_varDecls, a_loop);

    case ( txt,
           i_nFuncs,
           a_varDecls,
           a_eqs,
           a_funcs,
           a_name,
           a_loop )
      equation
        l_funcNames = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funcNames = lm_358(l_funcNames, a_eqs, a_name);
        l_funcNames = Tpl.popIter(l_funcNames);
        ret_2 = Flags.isSet(Flags.PARMODAUTO);
        l_head = fun_360(Tpl.emptyTxt, ret_2);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING("int id;"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_loop = Tpl.writeText(a_loop, l_head);
        a_loop = Tpl.softNewLine(a_loop);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("for(id=0; id<"));
        a_loop = Tpl.writeStr(a_loop, intString(i_nFuncs));
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_LINE("; id++) {\n"));
        a_loop = Tpl.pushBlock(a_loop, Tpl.BT_INDENT(2));
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("function"));
        a_loop = Tpl.writeStr(a_loop, a_name);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_LINE("_systems[id](data);\n"));
        a_loop = Tpl.popBlock(a_loop);
        a_loop = Tpl.writeTok(a_loop, Tpl.ST_STRING("}"));
        txt = Tpl.writeText(txt, a_funcs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static void (*function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_systems["));
        txt = Tpl.writeStr(txt, intString(i_nFuncs));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("])(DATA *) = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_funcNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then (txt, a_varDecls, a_loop);
  end match;
end fun_361;

public function functionXXX_systems
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_eqs;
  input String a_name;
  input Tpl.Text a_loop;
  input Tpl.Text a_varDecls;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_loop;
  output Tpl.Text out_a_varDecls;
protected
  Integer ret_1;
  Tpl.Text l_funcs;
algorithm
  l_funcs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_funcs := lm_357(l_funcs, a_eqs, a_modelNamePrefixStr, a_name);
  l_funcs := Tpl.popIter(l_funcs);
  ret_1 := listLength(a_eqs);
  (out_txt, out_a_varDecls, out_a_loop) := fun_361(txt, ret_1, a_varDecls, a_eqs, l_funcs, a_name, a_loop);
end functionXXX_systems;

protected function fun_363
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_363;

protected function fun_364
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_364;

protected function fun_365
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Integer in_a_arrayIndex;
  input String in_a_name;
  input Tpl.Text in_a_forwardEqs;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_arrayEqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_forwardEqs;
  output Tpl.Text out_a_arrayEqs;
algorithm
  (out_txt, out_a_forwardEqs, out_a_arrayEqs) :=
  match(in_txt, in_a_eq, in_a_arrayIndex, in_a_name, in_a_forwardEqs, in_a_modelNamePrefixStr, in_a_arrayEqs)
    local
      Tpl.Text txt;
      Integer a_arrayIndex;
      String a_name;
      Tpl.Text a_forwardEqs;
      String a_modelNamePrefixStr;
      Tpl.Text a_arrayEqs;
      SimCode.SimEqSystem i_eq;
      Boolean ret_2;
      Boolean ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _,
           a_forwardEqs,
           _,
           a_arrayEqs )
      then (txt, a_forwardEqs, a_arrayEqs);

    case ( txt,
           i_eq,
           a_arrayIndex,
           a_name,
           a_forwardEqs,
           a_modelNamePrefixStr,
           a_arrayEqs )
      equation
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, i_eq);
        a_arrayEqs = symbolName(a_arrayEqs, a_modelNamePrefixStr, "eqFunction");
        a_arrayEqs = Tpl.writeTok(a_arrayEqs, Tpl.ST_STRING("_"));
        a_arrayEqs = Tpl.writeText(a_arrayEqs, l_ix);
        a_arrayEqs = Tpl.writeTok(a_arrayEqs, Tpl.ST_STRING(","));
        a_arrayEqs = Tpl.writeTok(a_arrayEqs, Tpl.ST_NEW_LINE());
        a_forwardEqs = Tpl.writeTok(a_forwardEqs, Tpl.ST_STRING("extern void "));
        a_forwardEqs = symbolName(a_forwardEqs, a_modelNamePrefixStr, "eqFunction");
        a_forwardEqs = Tpl.writeTok(a_forwardEqs, Tpl.ST_STRING("_"));
        a_forwardEqs = Tpl.writeText(a_forwardEqs, l_ix);
        a_forwardEqs = Tpl.writeTok(a_forwardEqs, Tpl.ST_STRING("(DATA* data);"));
        a_forwardEqs = Tpl.writeTok(a_forwardEqs, Tpl.ST_NEW_LINE());
        ret_1 = Config.profileAll();
        txt = fun_363(txt, ret_1, l_ix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_systems["));
        txt = Tpl.writeStr(txt, intString(a_arrayIndex));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("](data);\n"));
        ret_2 = Config.profileAll();
        txt = fun_364(txt, ret_2, l_ix);
      then (txt, a_forwardEqs, a_arrayEqs);
  end match;
end fun_365;

protected function fun_366
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_366;

protected function fun_367
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_367;

protected function fun_368
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Integer in_a_arrayIndex;
  input String in_a_name;
  input Tpl.Text in_a_forwardEqs;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_arrayEqs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_forwardEqs;
  output Tpl.Text out_a_arrayEqs;
algorithm
  (out_txt, out_a_forwardEqs, out_a_arrayEqs) :=
  match(in_txt, in_a_eq, in_a_arrayIndex, in_a_name, in_a_forwardEqs, in_a_modelNamePrefixStr, in_a_arrayEqs)
    local
      Tpl.Text txt;
      Integer a_arrayIndex;
      String a_name;
      Tpl.Text a_forwardEqs;
      String a_modelNamePrefixStr;
      Tpl.Text a_arrayEqs;
      SimCode.SimEqSystem i_eq;
      Boolean ret_2;
      Boolean ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _,
           a_forwardEqs,
           _,
           a_arrayEqs )
      then (txt, a_forwardEqs, a_arrayEqs);

    case ( txt,
           i_eq,
           a_arrayIndex,
           a_name,
           a_forwardEqs,
           a_modelNamePrefixStr,
           a_arrayEqs )
      equation
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, i_eq);
        a_arrayEqs = symbolName(a_arrayEqs, a_modelNamePrefixStr, "eqFunction");
        a_arrayEqs = Tpl.writeTok(a_arrayEqs, Tpl.ST_STRING("_"));
        a_arrayEqs = Tpl.writeText(a_arrayEqs, l_ix);
        a_arrayEqs = Tpl.writeTok(a_arrayEqs, Tpl.ST_STRING(","));
        a_arrayEqs = Tpl.writeTok(a_arrayEqs, Tpl.ST_NEW_LINE());
        a_forwardEqs = Tpl.writeTok(a_forwardEqs, Tpl.ST_STRING("extern void "));
        a_forwardEqs = symbolName(a_forwardEqs, a_modelNamePrefixStr, "eqFunction");
        a_forwardEqs = Tpl.writeTok(a_forwardEqs, Tpl.ST_STRING("_"));
        a_forwardEqs = Tpl.writeText(a_forwardEqs, l_ix);
        a_forwardEqs = Tpl.writeTok(a_forwardEqs, Tpl.ST_STRING("(DATA* data);"));
        a_forwardEqs = Tpl.writeTok(a_forwardEqs, Tpl.ST_NEW_LINE());
        ret_1 = Config.profileAll();
        txt = fun_366(txt, ret_1, l_ix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// "));
        txt = symbolName(txt, a_modelNamePrefixStr, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "function"
                                }, false));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_systems["));
        txt = Tpl.writeStr(txt, intString(a_arrayIndex));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("](data);\n"));
        ret_2 = Config.profileAll();
        txt = fun_367(txt, ret_2, l_ix);
      then (txt, a_forwardEqs, a_arrayEqs);
  end match;
end fun_368;

protected function fun_369
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimEqSystem in_a_eq;
  input String in_a_name;
  input Integer in_a_arrayIndex;
  input Tpl.Text in_a_arrayEqs;
  input Tpl.Text in_a_forwardEqs;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayEqs;
  output Tpl.Text out_a_forwardEqs;
algorithm
  (out_txt, out_a_arrayEqs, out_a_forwardEqs) :=
  match(in_txt, in_a_context, in_a_eq, in_a_name, in_a_arrayIndex, in_a_arrayEqs, in_a_forwardEqs, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      String a_name;
      Integer a_arrayIndex;
      Tpl.Text a_arrayEqs;
      Tpl.Text a_forwardEqs;
      String a_modelNamePrefixStr;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true),
           a_eq,
           a_name,
           a_arrayIndex,
           a_arrayEqs,
           a_forwardEqs,
           a_modelNamePrefixStr )
      equation
        (txt, a_forwardEqs, a_arrayEqs) = fun_365(txt, a_eq, a_arrayIndex, a_name, a_forwardEqs, a_modelNamePrefixStr, a_arrayEqs);
      then (txt, a_arrayEqs, a_forwardEqs);

    case ( txt,
           _,
           a_eq,
           a_name,
           a_arrayIndex,
           a_arrayEqs,
           a_forwardEqs,
           a_modelNamePrefixStr )
      equation
        (txt, a_forwardEqs, a_arrayEqs) = fun_368(txt, a_eq, a_arrayIndex, a_name, a_forwardEqs, a_modelNamePrefixStr, a_arrayEqs);
      then (txt, a_arrayEqs, a_forwardEqs);
  end match;
end fun_369;

public function equationNamesArrayFormat
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input String a_name;
  input Integer a_arrayIndex;
  input Tpl.Text a_arrayEqs;
  input Tpl.Text a_forwardEqs;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayEqs;
  output Tpl.Text out_a_forwardEqs;
algorithm
  (out_txt, out_a_arrayEqs, out_a_forwardEqs) := fun_369(txt, a_context, a_eq, a_name, a_arrayIndex, a_arrayEqs, a_forwardEqs, a_modelNamePrefixStr);
end equationNamesArrayFormat;

protected function lm_371
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_forwardEqs;
  input Tpl.Text in_a_arrayEqs;
  input String in_a_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_forwardEqs;
  output Tpl.Text out_a_arrayEqs;
algorithm
  (out_txt, out_a_forwardEqs, out_a_arrayEqs) :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_forwardEqs, in_a_arrayEqs, in_a_name)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_forwardEqs;
      Tpl.Text a_arrayEqs;
      String a_name;
      Integer x_i0;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_forwardEqs,
           a_arrayEqs,
           _ )
      then (txt, a_forwardEqs, a_arrayEqs);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefixStr,
           a_forwardEqs,
           a_arrayEqs,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_arrayEqs, a_forwardEqs) = equationNamesArrayFormat(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_name, x_i0, a_arrayEqs, a_forwardEqs, a_modelNamePrefixStr);
        txt = Tpl.nextIter(txt);
        (txt, a_forwardEqs, a_arrayEqs) = lm_371(txt, rest, a_modelNamePrefixStr, a_forwardEqs, a_arrayEqs, a_name);
      then (txt, a_forwardEqs, a_arrayEqs);
  end match;
end lm_371;

protected function fun_372
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_a_eqlstlst;
  input String in_a_name;
  input Tpl.Text in_a_fncalls;
  input Tpl.Text in_a_nrfuncs;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_fncalls;
  output Tpl.Text out_a_nrfuncs;
algorithm
  (out_txt, out_a_fncalls, out_a_nrfuncs) :=
  match(in_txt, in_a_eqlstlst, in_a_name, in_a_fncalls, in_a_nrfuncs, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      String a_name;
      Tpl.Text a_fncalls;
      Tpl.Text a_nrfuncs;
      String a_modelNamePrefixStr;
      list<SimCode.SimEqSystem> i_eqlst;
      Tpl.Text l_forwardEqs;
      Tpl.Text l_arrayEqs;
      Integer ret_0;

    case ( txt,
           {},
           a_name,
           a_fncalls,
           a_nrfuncs,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* no "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" systems */"));
      then (txt, a_fncalls, a_nrfuncs);

    case ( txt,
           {{}},
           a_name,
           a_fncalls,
           a_nrfuncs,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* no "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" systems */"));
      then (txt, a_fncalls, a_nrfuncs);

    case ( txt,
           {i_eqlst},
           a_name,
           a_fncalls,
           a_nrfuncs,
           a_modelNamePrefixStr )
      equation
        ret_0 = listLength(i_eqlst);
        a_nrfuncs = Tpl.writeStr(a_nrfuncs, intString(ret_0));
        l_arrayEqs = Tpl.emptyTxt;
        l_forwardEqs = Tpl.emptyTxt;
        a_fncalls = Tpl.pushIter(a_fncalls, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (a_fncalls, l_forwardEqs, l_arrayEqs) = lm_371(a_fncalls, i_eqlst, a_modelNamePrefixStr, l_forwardEqs, l_arrayEqs, a_name);
        a_fncalls = Tpl.popIter(a_fncalls);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* forwarded equations */\n"));
        txt = Tpl.writeText(txt, l_forwardEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "static void (*function"
                                }, false));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_systems["));
        txt = Tpl.writeText(txt, a_nrfuncs);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("])(DATA *) = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_arrayEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n"
                                }, true));
      then (txt, a_fncalls, a_nrfuncs);

    case ( txt,
           {_ :: _},
           a_name,
           a_fncalls,
           a_nrfuncs,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* TODO more than ODE list in "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" systems */"));
      then (txt, a_fncalls, a_nrfuncs);

    case ( txt,
           _,
           _,
           a_fncalls,
           a_nrfuncs,
           _ )
      then (txt, a_fncalls, a_nrfuncs);
  end match;
end fun_372;

public function functionXXX_systems_arrayFormat
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_eqlstlst;
  input String a_name;
  input Tpl.Text a_fncalls;
  input Tpl.Text a_nrfuncs;
  input Tpl.Text a_varDecls;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_fncalls;
  output Tpl.Text out_a_nrfuncs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_fncalls, out_a_nrfuncs) := fun_372(txt, a_eqlstlst, a_name, a_fncalls, a_nrfuncs, a_modelNamePrefixStr);
  out_a_varDecls := a_varDecls;
end functionXXX_systems_arrayFormat;

protected function fun_374
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_nrfuncs;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_fncalls;
  input list<list<SimCode.SimEqSystem>> in_a_derivativEquations;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_nrfuncs;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_fncalls;
algorithm
  (out_txt, out_a_nrfuncs, out_a_varDecls, out_a_fncalls) :=
  match(in_txt, in_mArg, in_a_nrfuncs, in_a_modelNamePrefix, in_a_varDecls, in_a_fncalls, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Tpl.Text a_nrfuncs;
      String a_modelNamePrefix;
      Tpl.Text a_varDecls;
      Tpl.Text a_fncalls;
      list<list<SimCode.SimEqSystem>> a_derivativEquations;

    case ( txt,
           false,
           a_nrfuncs,
           a_modelNamePrefix,
           a_varDecls,
           a_fncalls,
           a_derivativEquations )
      equation
        (txt, a_fncalls, a_varDecls) = functionXXX_systems(txt, a_derivativEquations, "ODE", a_fncalls, a_varDecls, a_modelNamePrefix);
      then (txt, a_nrfuncs, a_varDecls, a_fncalls);

    case ( txt,
           _,
           a_nrfuncs,
           a_modelNamePrefix,
           a_varDecls,
           a_fncalls,
           a_derivativEquations )
      equation
        (txt, a_fncalls, a_nrfuncs, a_varDecls) = functionXXX_systems_arrayFormat(txt, a_derivativEquations, "ODE", a_fncalls, a_nrfuncs, a_varDecls, a_modelNamePrefix);
      then (txt, a_nrfuncs, a_varDecls, a_fncalls);
  end match;
end fun_374;

protected function fun_375
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Option<HpcOmSimCode.Schedule> in_a_hpcOmSchedule;
  input Tpl.Text in_a_nrfuncs;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_fncalls;
  input list<list<SimCode.SimEqSystem>> in_a_derivativEquations;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_nrfuncs;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_fncalls;
algorithm
  (out_txt, out_a_nrfuncs, out_a_varDecls, out_a_fncalls) :=
  match(in_txt, in_mArg, in_a_hpcOmSchedule, in_a_nrfuncs, in_a_modelNamePrefix, in_a_varDecls, in_a_fncalls, in_a_derivativEquations)
    local
      Tpl.Text txt;
      Option<HpcOmSimCode.Schedule> a_hpcOmSchedule;
      Tpl.Text a_nrfuncs;
      String a_modelNamePrefix;
      Tpl.Text a_varDecls;
      Tpl.Text a_fncalls;
      list<list<SimCode.SimEqSystem>> a_derivativEquations;
      Boolean ret_0;

    case ( txt,
           false,
           _,
           a_nrfuncs,
           a_modelNamePrefix,
           a_varDecls,
           a_fncalls,
           a_derivativEquations )
      equation
        ret_0 = Flags.isSet(Flags.PARMODAUTO);
        (txt, a_nrfuncs, a_varDecls, a_fncalls) = fun_374(txt, ret_0, a_nrfuncs, a_modelNamePrefix, a_varDecls, a_fncalls, a_derivativEquations);
      then (txt, a_nrfuncs, a_varDecls, a_fncalls);

    case ( txt,
           _,
           a_hpcOmSchedule,
           a_nrfuncs,
           a_modelNamePrefix,
           a_varDecls,
           a_fncalls,
           a_derivativEquations )
      equation
        (txt, a_fncalls, a_varDecls) = functionXXX_systems_HPCOM(txt, a_derivativEquations, "ODE", a_fncalls, a_varDecls, a_hpcOmSchedule, a_modelNamePrefix);
      then (txt, a_nrfuncs, a_varDecls, a_fncalls);
  end match;
end fun_375;

protected function fun_376
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rt_tick(SIM_TIMER_FUNCTION_ODE);"));
      then txt;
  end match;
end fun_376;

protected function fun_377
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_nrfuncs;
  input Tpl.Text in_a_fncalls;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_nrfuncs, in_a_fncalls)
    local
      Tpl.Text txt;
      Tpl.Text a_nrfuncs;
      Tpl.Text a_fncalls;

    case ( txt,
           false,
           _,
           a_fncalls )
      equation
        txt = Tpl.writeText(txt, a_fncalls);
      then txt;

    case ( txt,
           _,
           a_nrfuncs,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("PM_functionODE("));
        txt = Tpl.writeText(txt, a_nrfuncs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", data, functionODE_systems);"));
      then txt;
  end match;
end fun_377;

protected function fun_378
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rt_accumulate(SIM_TIMER_FUNCTION_ODE);"));
      then txt;
  end match;
end fun_378;

public function functionODE
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_derivativEquations;
  input Tpl.Text a_method;
  input Option<HpcOmSimCode.Schedule> a_hpcOmSchedule;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_method;
protected
  Boolean ret_9;
  Boolean ret_8;
  Boolean ret_7;
  Tpl.Text l_tmp;
  Boolean ret_5;
  Tpl.Text l_systems;
  Tpl.Text l_fncalls;
  Tpl.Text l_varDecls;
  Tpl.Text l_varDecls2;
  Tpl.Text l_nrfuncs;
algorithm
  System.tmpTickReset(0);
  l_nrfuncs := Tpl.emptyTxt;
  l_varDecls2 := Tpl.emptyTxt;
  l_varDecls := Tpl.emptyTxt;
  l_fncalls := Tpl.emptyTxt;
  ret_5 := Flags.isSet(Flags.HPCOM);
  (l_systems, l_nrfuncs, l_varDecls, l_fncalls) := fun_375(Tpl.emptyTxt, ret_5, a_hpcOmSchedule, l_nrfuncs, a_modelNamePrefix, l_varDecls, l_fncalls, a_derivativEquations);
  l_tmp := Tpl.emptyTxt;
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_systems);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "int "
                                   }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "functionODE");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_7 := Config.profileFunctions();
  out_txt := fun_376(out_txt, ret_7);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_PUSH\n",
                                       "data->simulationInfo.callStatistics.functionODE++;\n",
                                       "\n",
                                       "data->simulationInfo.discreteCall = 0;\n"
                                   }, true));
  ret_8 := Flags.isSet(Flags.PARMODAUTO);
  out_txt := fun_377(out_txt, ret_8, l_nrfuncs, l_fncalls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  ret_9 := Config.profileFunctions();
  out_txt := fun_378(out_txt, ret_9);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_POP\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
  out_a_method := a_method;
end functionODE;

protected function fun_380
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_nrfuncs;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_fncalls;
  input list<list<SimCode.SimEqSystem>> in_a_algebraicEquations;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_nrfuncs;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_fncalls;
algorithm
  (out_txt, out_a_nrfuncs, out_a_varDecls, out_a_fncalls) :=
  match(in_txt, in_mArg, in_a_nrfuncs, in_a_modelNamePrefix, in_a_varDecls, in_a_fncalls, in_a_algebraicEquations)
    local
      Tpl.Text txt;
      Tpl.Text a_nrfuncs;
      String a_modelNamePrefix;
      Tpl.Text a_varDecls;
      Tpl.Text a_fncalls;
      list<list<SimCode.SimEqSystem>> a_algebraicEquations;

    case ( txt,
           false,
           a_nrfuncs,
           a_modelNamePrefix,
           a_varDecls,
           a_fncalls,
           a_algebraicEquations )
      equation
        (txt, a_fncalls, a_varDecls) = functionXXX_systems(txt, a_algebraicEquations, "Alg", a_fncalls, a_varDecls, a_modelNamePrefix);
      then (txt, a_nrfuncs, a_varDecls, a_fncalls);

    case ( txt,
           _,
           a_nrfuncs,
           a_modelNamePrefix,
           a_varDecls,
           a_fncalls,
           a_algebraicEquations )
      equation
        (txt, a_fncalls, a_nrfuncs, a_varDecls) = functionXXX_systems_arrayFormat(txt, a_algebraicEquations, "Alg", a_fncalls, a_nrfuncs, a_varDecls, a_modelNamePrefix);
      then (txt, a_nrfuncs, a_varDecls, a_fncalls);
  end match;
end fun_380;

protected function fun_381
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_nrfuncs;
  input Tpl.Text in_a_fncalls;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_nrfuncs, in_a_fncalls)
    local
      Tpl.Text txt;
      Tpl.Text a_nrfuncs;
      Tpl.Text a_fncalls;

    case ( txt,
           false,
           _,
           a_fncalls )
      equation
        txt = Tpl.writeText(txt, a_fncalls);
      then txt;

    case ( txt,
           _,
           a_nrfuncs,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("PM_functionAlg("));
        txt = Tpl.writeText(txt, a_nrfuncs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", data, functionAlg_systems);"));
      then txt;
  end match;
end fun_381;

public function functionAlgebraic
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_algebraicEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Boolean ret_5;
  Boolean ret_4;
  Tpl.Text l_systems;
  Tpl.Text l_fncalls;
  Tpl.Text l_nrfuncs;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_nrfuncs := Tpl.emptyTxt;
  l_fncalls := Tpl.emptyTxt;
  ret_4 := Flags.isSet(Flags.PARMODAUTO);
  (l_systems, l_nrfuncs, l_varDecls, l_fncalls) := fun_380(Tpl.emptyTxt, ret_4, l_nrfuncs, a_modelNamePrefix, l_varDecls, l_fncalls, a_algebraicEquations);
  out_txt := Tpl.writeText(txt, l_systems);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int "
                                   }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "functionAlgebraics");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_PUSH\n",
                                       "\n",
                                       "data->simulationInfo.discreteCall = 0;\n"
                                   }, true));
  ret_5 := Flags.isSet(Flags.PARMODAUTO);
  out_txt := fun_381(out_txt, ret_5, l_nrfuncs, l_fncalls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_POP\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAlgebraic;

protected function lm_383
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_383(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_383;

public function functionAliasEquation
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_removedEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_removedPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_removedPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_removedPart, l_tmp, l_varDecls) := lm_383(l_removedPart, a_removedEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_removedPart := Tpl.popIter(l_removedPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* for continuous time variables */\n",
                                       "int functionAliasEquations(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_PUSH\n",
                                       "\n",
                                       "data->simulationInfo.discreteCall = 0;\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_removedPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_POP\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAliasEquation;

protected function lm_385
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_eqfuncs;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqfuncs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqfuncs, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_eqfuncs, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_eqfuncs;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_eqfuncs,
           a_varDecls )
      then (txt, a_eqfuncs, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix,
           a_eqfuncs,
           a_varDecls )
      equation
        (txt, a_varDecls, a_eqfuncs) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_eqfuncs, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_eqfuncs, a_varDecls) = lm_385(txt, rest, a_modelNamePrefix, a_eqfuncs, a_varDecls);
      then (txt, a_eqfuncs, a_varDecls);
  end match;
end lm_385;

protected function lm_386
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_eqfuncs;
  input Tpl.Text in_a_eqArray;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqfuncs;
  output Tpl.Text out_a_eqArray;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqfuncs, out_a_eqArray, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_eqfuncs, in_a_eqArray, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_eqfuncs;
      Tpl.Text a_eqArray;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_eqfuncs,
           a_eqArray,
           a_varDecls )
      then (txt, a_eqfuncs, a_eqArray, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix,
           a_eqfuncs,
           a_eqArray,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_eqArray, a_eqfuncs) = equation_arrayFormat(txt, i_eq, "DAE", SimCode.contextSimulationDiscrete, x_i0, a_varDecls, a_eqArray, a_eqfuncs, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_eqfuncs, a_eqArray, a_varDecls) = lm_386(txt, rest, a_modelNamePrefix, a_eqfuncs, a_eqArray, a_varDecls);
      then (txt, a_eqfuncs, a_eqArray, a_varDecls);
  end match;
end lm_386;

protected function fun_387
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_eqArray;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_eqfuncs;
  input Tpl.Text in_a_varDecls;
  input list<SimCode.SimEqSystem> in_a_allEquationsPlusWhen;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqArray;
  output Tpl.Text out_a_eqfuncs;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqArray, out_a_eqfuncs, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_eqArray, in_a_modelNamePrefix, in_a_eqfuncs, in_a_varDecls, in_a_allEquationsPlusWhen)
    local
      Tpl.Text txt;
      Tpl.Text a_eqArray;
      String a_modelNamePrefix;
      Tpl.Text a_eqfuncs;
      Tpl.Text a_varDecls;
      list<SimCode.SimEqSystem> a_allEquationsPlusWhen;

    case ( txt,
           false,
           a_eqArray,
           a_modelNamePrefix,
           a_eqfuncs,
           a_varDecls,
           a_allEquationsPlusWhen )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_eqfuncs, a_varDecls) = lm_385(txt, a_allEquationsPlusWhen, a_modelNamePrefix, a_eqfuncs, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_eqArray, a_eqfuncs, a_varDecls);

    case ( txt,
           _,
           a_eqArray,
           a_modelNamePrefix,
           a_eqfuncs,
           a_varDecls,
           a_allEquationsPlusWhen )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_eqfuncs, a_eqArray, a_varDecls) = lm_386(txt, a_allEquationsPlusWhen, a_modelNamePrefix, a_eqfuncs, a_eqArray, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_eqArray, a_eqfuncs, a_varDecls);
  end match;
end fun_387;

protected function lm_388
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      Integer x_i0;
      SimCode.SimWhenClause i_when;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           i_when :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_auxFunction) = genreinits(txt, i_when, a_varDecls, a_auxFunction, x_i0);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls) = lm_388(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_388;

protected function fun_389
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_eqArray;
  input Tpl.Text in_a_nrfuncs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eqArray, in_a_nrfuncs)
    local
      Tpl.Text txt;
      Tpl.Text a_eqArray;
      Tpl.Text a_nrfuncs;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eqArray,
           a_nrfuncs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static void (*functionDAE_systems["));
        txt = Tpl.writeText(txt, a_nrfuncs);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("])(DATA *) = {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_eqArray);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_389;

protected function fun_390
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_nrfuncs;
  input Tpl.Text in_a_fncalls;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_nrfuncs, in_a_fncalls)
    local
      Tpl.Text txt;
      Tpl.Text a_nrfuncs;
      Tpl.Text a_fncalls;

    case ( txt,
           false,
           _,
           a_fncalls )
      equation
        txt = Tpl.writeText(txt, a_fncalls);
      then txt;

    case ( txt,
           _,
           a_nrfuncs,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("PM_functionDAE("));
        txt = Tpl.writeText(txt, a_nrfuncs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", data, functionDAE_systems);"));
      then txt;
  end match;
end fun_390;

public function functionDAE
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquationsPlusWhen;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Boolean ret_11;
  Boolean ret_10;
  Tpl.Text l_eqArrayDecl;
  Tpl.Text l_reinit;
  Boolean ret_7;
  Tpl.Text l_fncalls;
  Tpl.Text l_eqArray;
  Tpl.Text l_eqfuncs;
  Integer ret_3;
  Tpl.Text l_nrfuncs;
  Tpl.Text l_varDecls;
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  l_varDecls := Tpl.emptyTxt;
  ret_3 := listLength(a_allEquationsPlusWhen);
  l_nrfuncs := Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
  l_eqfuncs := Tpl.emptyTxt;
  l_eqArray := Tpl.emptyTxt;
  ret_7 := Flags.isSet(Flags.PARMODAUTO);
  (l_fncalls, l_eqArray, l_eqfuncs, l_varDecls) := fun_387(Tpl.emptyTxt, ret_7, l_eqArray, a_modelNamePrefix, l_eqfuncs, l_varDecls, a_allEquationsPlusWhen);
  l_reinit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_reinit, l_auxFunction, l_varDecls) := lm_388(l_reinit, a_whenClauses, l_auxFunction, l_varDecls);
  l_reinit := Tpl.popIter(l_reinit);
  ret_10 := Flags.isSet(Flags.PARMODAUTO);
  l_eqArrayDecl := fun_389(Tpl.emptyTxt, ret_10, l_eqArray, l_nrfuncs);
  out_txt := Tpl.writeText(txt, l_auxFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_eqfuncs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_eqArrayDecl);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "int "
                                   }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "functionDAE");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n",
                                       "  int equationIndexes[1] = {0};\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_PUSH\n",
                                       "\n",
                                       "data->simulationInfo.needToIterate = 0;\n",
                                       "data->simulationInfo.discreteCall = 1;\n"
                                   }, true));
  ret_11 := Flags.isSet(Flags.PARMODAUTO);
  out_txt := fun_390(out_txt, ret_11, l_nrfuncs, l_fncalls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_reinit);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_POP\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionDAE;

protected function lm_392
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_392(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_392;

protected function lm_393
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      DAE.Exp i_relation__;
      String ret_1;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = ExpressionDump.printExpStr(i_relation__);
        ret_1 = Util.escapeModelicaStringToCString(ret_0);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_393(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_393(txt, rest);
      then txt;
  end match;
end lm_393;

protected function lm_394
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_i;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = lm_394(txt, rest);
      then txt;
  end match;
end lm_394;

protected function lm_395
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Integer x_i0;
      list<Integer> i_occurEquLst;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.ZERO_CROSSING(occurEquLst = i_occurEquLst) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static const int occurEqs"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[] = {"));
        ret_0 = listLength(i_occurEquLst);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = lm_394(txt, i_occurEquLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
        txt = Tpl.nextIter(txt);
        txt = lm_395(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_395(txt, rest);
      then txt;
  end match;
end lm_395;

protected function lm_396
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = _) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("occurEqs"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_396(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_396(txt, rest);
      then txt;
  end match;
end lm_396;

protected function fun_397
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_a_zeroCrossings;
  input Tpl.Text in_a_resDesc;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_zeroCrossings, in_a_resDesc, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      Tpl.Text a_resDesc;
      String a_modelNamePrefix;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;

    case ( txt,
           {},
           _,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *"));
        txt = symbolName(txt, a_modelNamePrefix, "zeroCrossingDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int i, int **out_EquationIndexes)\n",
                                    "{\n",
                                    "  *out_EquationIndexes = NULL;\n",
                                    "  return \"empty\";\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           i_zeroCrossings,
           a_resDesc,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *"));
        txt = symbolName(txt, a_modelNamePrefix, "zeroCrossingDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int i, int **out_EquationIndexes)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static const char *res[] = {"));
        txt = Tpl.writeText(txt, a_resDesc);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("};\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_395(txt, i_zeroCrossings);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static const int *occurEqs[] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_396(txt, i_zeroCrossings);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "*out_EquationIndexes = (int*) occurEqs[i];\n",
                                    "return res[i];\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_397;

public function functionZeroCrossing
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input list<SimCode.SimEqSystem> a_equationsForZeroCrossings;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_desc;
  Tpl.Text l_resDesc;
  Tpl.Text l_zeroCrossingsCode;
  Tpl.Text l_varDecls2;
  Tpl.Text l_eqs;
  Tpl.Text l_auxFunction;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_auxFunction := Tpl.emptyTxt;
  l_eqs := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqs, l_tmp, l_varDecls) := lm_392(l_eqs, a_equationsForZeroCrossings, a_modelNamePrefix, l_tmp, l_varDecls);
  l_eqs := Tpl.popIter(l_eqs);
  l_varDecls2 := Tpl.emptyTxt;
  (l_zeroCrossingsCode, l_varDecls2, l_auxFunction) := zeroCrossingsTpl(Tpl.emptyTxt, a_zeroCrossings, l_varDecls2, l_auxFunction);
  l_resDesc := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_resDesc := lm_393(l_resDesc, a_zeroCrossings);
  l_resDesc := Tpl.popIter(l_resDesc);
  l_desc := fun_397(Tpl.emptyTxt, a_zeroCrossings, l_resDesc, a_modelNamePrefix);
  out_txt := Tpl.writeText(txt, l_desc);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "int "
                                   }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "function_ZeroCrossingsEquations");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_PUSH\n",
                                       "data->simulationInfo.callStatistics.functionZeroCrossingsEquations++;\n",
                                       "\n",
                                       "data->simulationInfo.discreteCall = 0;\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_eqs);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_POP\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "\n",
                                       "int "
                                   }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "function_ZeroCrossings");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data, double *gout)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls2);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_PUSH\n",
                                       "data->simulationInfo.callStatistics.functionZeroCrossings++;\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, l_zeroCrossingsCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_POP\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionZeroCrossing;

protected function lm_399
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_auxFunction) = zeroCrossingTpl(txt, x_i0, i_relation__, a_varDecls, a_auxFunction);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls) = lm_399(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _ :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        (txt, a_auxFunction, a_varDecls) = lm_399(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_399;

public function zeroCrossingsTpl
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zeroCrossings;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_auxFunction, out_a_varDecls) := lm_399(out_txt, a_zeroCrossings, a_auxFunction, a_varDecls);
  out_txt := Tpl.popIter(out_txt);
end zeroCrossingsTpl;

protected function fun_401
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) :=
  match(in_txt, in_a_relation, in_a_index1, in_a_varDecls, in_a_auxFunction)
    local
      Tpl.Text txt;
      Integer a_index1;
      Tpl.Text a_varDecls;
      Tpl.Text a_auxFunction;
      DAE.Exp i_exp2;
      DAE.Exp i_idx;
      DAE.Exp i_exp1;
      DAE.Exp i_exp;
      Tpl.Text txt_4;
      Tpl.Text l_e2;
      Tpl.Text l_indx;
      Tpl.Text l_e1;
      Tpl.Text l_preExp;

    case ( txt,
           (i_exp as DAE.RELATION(exp1 = _)),
           a_index1,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gout["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = ("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") ? 1 : -1;"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           (i_exp1 as DAE.LBINARY(exp1 = _)),
           a_index1,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gout["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = ("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") ? 1 : -1;"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           (i_exp1 as DAE.LUNARY(operator = _)),
           a_index1,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gout["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = ("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") ? 1 : -1;"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {_, _, _}),
           _,
           a_varDecls,
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "integer"), expLst = {i_exp1, i_idx}),
           a_index1,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        (l_indx, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gout["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (floor("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != floor(data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])) ? 1 : -1;"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "floor"), expLst = {i_exp1, i_idx}),
           a_index1,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        (l_indx, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gout["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (floor("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != floor(data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])) ? 1 : -1;"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "ceil"), expLst = {i_exp1, i_idx}),
           a_index1,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        (l_indx, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gout["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (ceil("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != ceil(data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])) ? 1 : -1;"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "div"), expLst = {i_exp1, i_exp2, i_idx}),
           a_index1,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_e1, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp1, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        (l_e2, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp2, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        (l_indx, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_idx, SimCode.contextZeroCross, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gout["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (trunc("));
        txt = Tpl.writeText(txt, l_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, l_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") != trunc(data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]/data->simulationInfo.mathEventsValuePre["));
        txt = Tpl.writeText(txt, l_indx);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1])) ? 1 : -1;"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           _,
           a_index1,
           a_varDecls,
           a_auxFunction )
      equation
        txt_4 = Tpl.pushBlock(Tpl.emptyTxt, Tpl.BT_INDENT(1));
        txt_4 = Tpl.writeTok(txt_4, Tpl.ST_STRING("UNKNOWN ZERO CROSSING for "));
        txt_4 = Tpl.writeStr(txt_4, intString(a_index1));
        txt_4 = Tpl.popBlock(txt_4);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 3240, 11), Tpl.textString(txt_4));
      then (txt, a_varDecls, a_auxFunction);
  end match;
end fun_401;

public function zeroCrossingTpl
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) := fun_401(txt, a_relation, a_index1, a_varDecls, a_auxFunction);
end zeroCrossingTpl;

protected function lm_403
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      DAE.Exp i_relation__;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = ExpressionDump.printExpStr(i_relation__);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_403(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_403(txt, rest);
      then txt;
  end match;
end lm_403;

protected function fun_404
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_a_relations;
  input Tpl.Text in_a_resDesc;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_relations, in_a_resDesc, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      Tpl.Text a_resDesc;
      String a_modelNamePrefix;

    case ( txt,
           {},
           _,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *"));
        txt = symbolName(txt, a_modelNamePrefix, "relationDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int i)\n",
                                    "{\n",
                                    "  return \"empty\";\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_resDesc,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *"));
        txt = symbolName(txt, a_modelNamePrefix, "relationDescription");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int i)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *res[] = {"));
        txt = Tpl.writeText(txt, a_resDesc);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "return res[i];\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_404;

public function functionRelations
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_relations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_desc;
  Tpl.Text l_resDesc;
  Tpl.Text l_relationsCodeElse;
  Tpl.Text l_relationsCode;
  Tpl.Text l_varDecls;
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  l_varDecls := Tpl.emptyTxt;
  (l_relationsCode, l_varDecls, l_auxFunction) := relationsTpl(Tpl.emptyTxt, a_relations, SimCode.contextZeroCross, l_varDecls, l_auxFunction);
  (l_relationsCodeElse, l_varDecls, l_auxFunction) := relationsTpl(Tpl.emptyTxt, a_relations, SimCode.contextOther, l_varDecls, l_auxFunction);
  l_resDesc := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_resDesc := lm_403(l_resDesc, a_relations);
  l_resDesc := Tpl.popIter(l_resDesc);
  l_desc := fun_404(Tpl.emptyTxt, a_relations, l_resDesc, a_modelNamePrefix);
  out_txt := Tpl.writeText(txt, l_auxFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_desc);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "int "
                                   }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "function_updateRelations");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data, int evalforZeroCross)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "TRACE_PUSH\n",
                                       "\n",
                                       "if(evalforZeroCross)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_relationsCode);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "else\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_relationsCodeElse);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "\n",
                                       "TRACE_POP\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionRelations;

protected function lm_406
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_relation__;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls,
           _ )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__) :: rest,
           a_auxFunction,
           a_varDecls,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_auxFunction) = relationTpl(txt, x_i0, i_relation__, a_context, a_varDecls, a_auxFunction);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls) = lm_406(txt, rest, a_auxFunction, a_varDecls, a_context);
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _ :: rest,
           a_auxFunction,
           a_varDecls,
           a_context )
      equation
        (txt, a_auxFunction, a_varDecls) = lm_406(txt, rest, a_auxFunction, a_varDecls, a_context);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_406;

public function relationsTpl
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_relations;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_auxFunction, out_a_varDecls) := lm_406(out_txt, a_relations, a_auxFunction, a_varDecls, a_context);
  out_txt := Tpl.popIter(out_txt);
end relationsTpl;

protected function fun_408
  input Tpl.Text in_txt;
  input DAE.Exp in_a_relation;
  input Integer in_a_index1;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) :=
  match(in_txt, in_a_relation, in_a_index1, in_a_context, in_a_varDecls, in_a_auxFunction)
    local
      Tpl.Text txt;
      Integer a_index1;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_auxFunction;
      DAE.Exp i_exp;
      Tpl.Text l_res;
      Tpl.Text l_preExp;

    case ( txt,
           (i_exp as DAE.RELATION(exp1 = _)),
           a_index1,
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_res, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.relations["));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_res);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           _,
           a_index1,
           _,
           a_varDecls,
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* UNKNOWN Relation for "));
        txt = Tpl.writeStr(txt, intString(a_index1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then (txt, a_varDecls, a_auxFunction);
  end match;
end fun_408;

public function relationTpl
  input Tpl.Text txt;
  input Integer a_index1;
  input DAE.Exp a_relation;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) := fun_408(txt, a_relation, a_index1, a_context, a_varDecls, a_auxFunction);
end relationTpl;

protected function fun_410
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_var;

    case ( txt,
           (i_var as DAE.CREF_QUAL(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("infoStreamPrint(LOG_EVENTS_V, 0, \"discrete var changed: "));
        txt = CodegenUtil.crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" from "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "needToIterate = 1;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           (i_var as DAE.CREF_IDENT(ident = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("infoStreamPrint(LOG_EVENTS_V, 0, \"discrete var changed: "));
        txt = CodegenUtil.crefStr(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" from "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" to "));
        txt = crefToPrintfArg(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", $P$PRE"));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = cref(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "needToIterate = 1;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_410;

protected function lm_411
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_410(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_411(txt, rest);
      then txt;
  end match;
end lm_411;

public function functionCheckForDiscreteChanges
  input Tpl.Text txt;
  input list<DAE.ComponentRef> a_discreteModelVars;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_changediscreteVars;
algorithm
  l_changediscreteVars := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_changediscreteVars := lm_411(l_changediscreteVars, a_discreteModelVars);
  l_changediscreteVars := Tpl.popIter(l_changediscreteVars);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("int "));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "checkForDiscreteChanges");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n",
                                       "  int needToIterate = 0;\n",
                                       "\n",
                                       "  TRACE_PUSH\n",
                                       "\n",
                                       "  infoStreamPrint(LOG_EVENTS_V, 1, \"check for discrete changes at time=%.12g\", data->localData[0]->timeValue);\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_changediscreteVars);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "if (ACTIVE_STREAM(LOG_EVENTS_V)) messageClose(LOG_EVENTS_V);\n",
                                       "\n",
                                       "TRACE_POP\n",
                                       "return needToIterate;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionCheckForDiscreteChanges;

protected function fun_413
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      Tpl.Text txt_0;

    case ( txt,
           "modelica_real",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%g"));
      then txt;

    case ( txt,
           "modelica_integer",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%ld"));
      then txt;

    case ( txt,
           "modelica_boolean",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%d"));
      then txt;

    case ( txt,
           "modelica_string",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("%s"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Do not know what printf argument to give "));
        txt_0 = CodegenUtil.crefStr(txt_0, a_cr);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 3364, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_413;

public function crefToPrintfArg
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
protected
  String str_1;
  Tpl.Text txt_0;
algorithm
  txt_0 := crefType(Tpl.emptyTxt, a_cr);
  str_1 := Tpl.textString(txt_0);
  out_txt := fun_413(txt, str_1, a_cr);
end crefToPrintfArg;

public function crefType
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Type i_identType;

    case ( txt,
           DAE.CREF_IDENT(identType = i_identType) )
      equation
        txt = expTypeModelica(txt, i_identType);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(componentRef = i_componentRef) )
      equation
        txt = crefType(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("crefType:ERROR"));
      then txt;
  end match;
end crefType;

protected function lm_416
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationDiscrete, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_416(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_416;

public function functionAssertsforCheck
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_algAndEqAssertsEquations;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algAndEqAssertsPart;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_algAndEqAssertsPart := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algAndEqAssertsPart, l_tmp, l_varDecls) := lm_416(l_algAndEqAssertsPart, a_algAndEqAssertsEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_algAndEqAssertsPart := Tpl.popIter(l_algAndEqAssertsPart);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "/* function to check assert after a step is done */\n",
                                       "int "
                                   }, false));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "checkForAsserts");
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(DATA *data)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_algAndEqAssertsPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionAssertsforCheck;

public function defvars
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_item;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_item)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) )
      equation
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end defvars;

public function functionlinearmodel
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_modelNamePrefix;
      list<SimCodeVar.SimVar> i_vars_outputVars;
      list<SimCodeVar.SimVar> i_vars_inputVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;
      Absyn.Path i_name;
      Integer i_varInfo_numOutVars;
      Integer i_varInfo_numInVars;
      Integer i_varInfo_numStateVars;
      Tpl.Text l_vectorY;
      Tpl.Text l_vectorU;
      Tpl.Text l_vectorX;
      Tpl.Text l_matrixD;
      Tpl.Text l_matrixC;
      Tpl.Text l_matrixB;
      Tpl.Text l_matrixA;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numInVars = i_varInfo_numInVars, numOutVars = i_varInfo_numOutVars), vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, inputVars = i_vars_inputVars, outputVars = i_vars_outputVars), name = i_name),
           a_modelNamePrefix )
      equation
        l_matrixA = genMatrix(Tpl.emptyTxt, "A", i_varInfo_numStateVars, i_varInfo_numStateVars);
        l_matrixB = genMatrix(Tpl.emptyTxt, "B", i_varInfo_numStateVars, i_varInfo_numInVars);
        l_matrixC = genMatrix(Tpl.emptyTxt, "C", i_varInfo_numOutVars, i_varInfo_numStateVars);
        l_matrixD = genMatrix(Tpl.emptyTxt, "D", i_varInfo_numOutVars, i_varInfo_numInVars);
        l_vectorX = genVector(Tpl.emptyTxt, "x", i_varInfo_numStateVars, 0);
        l_vectorU = genVector(Tpl.emptyTxt, "u", i_varInfo_numInVars, 1);
        l_vectorY = genVector(Tpl.emptyTxt, "y", i_varInfo_numOutVars, 2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char *"));
        txt = symbolName(txt, a_modelNamePrefix, "linear_model_frame");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return \"model linear_"));
        txt = CodegenUtil.underscorePath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\n  parameter Integer n = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // states \\n  parameter Integer k = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; // top-level inputs \\n  parameter Integer l = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; // top-level outputs \\n\"\n",
                                    "\"  parameter Real x0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = {%s};\\n\"\n",
                                    "\"  parameter Real u0["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] = {%s};\\n\"\n"));
        txt = Tpl.writeText(txt, l_matrixA);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixB);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_matrixD);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorX);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorU);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_vectorY);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"\\n  "));
        txt = getVarName(txt, i_vars_stateVars, "x", i_varInfo_numStateVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = getVarName(txt, i_vars_inputVars, "u", i_varInfo_numInVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = getVarName(txt, i_vars_outputVars, "y", i_varInfo_numOutVars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\n\"\n",
                                    "\"equation\\n  der(x) = A * x + B * u;\\n  y = C * x + D * u;\\nend linear_"
                                }, false));
        txt = CodegenUtil.underscorePath(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\\n\";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionlinearmodel;

protected function fun_420
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_var;
  input Tpl.Text in_a_rest;
  input Tpl.Text in_a_arrindex;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_rest, in_a_arrindex, in_a_arrayName)
    local
      Tpl.Text txt;
      Tpl.Text a_rest;
      Tpl.Text a_arrindex;
      String a_arrayName;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name),
           a_rest,
           a_arrindex,
           a_arrayName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefM(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, a_arrindex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n  "));
        txt = Tpl.writeText(txt, a_rest);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_420;

public function getVarName
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_simVars;
  input String in_a_arrayName;
  input Integer in_a_arraySize;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVars, in_a_arrayName, in_a_arraySize)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_arraySize;
      SimCodeVar.SimVar i_var;
      list<SimCodeVar.SimVar> i_restVars;
      Integer ret_3;
      Integer ret_2;
      Tpl.Text l_arrindex;
      Tpl.Text l_rest;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: i_restVars,
           a_arrayName,
           a_arraySize )
      equation
        l_rest = getVarName(Tpl.emptyTxt, i_restVars, a_arrayName, a_arraySize);
        ret_2 = listLength(i_restVars);
        ret_3 = SimCodeUtil.decrementInt(a_arraySize, ret_2);
        l_arrindex = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        txt = fun_420(txt, i_var, l_rest, l_arrindex, a_arrayName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end getVarName;

protected function fun_422
  input Tpl.Text in_txt;
  input Integer in_a_col;
  input Integer in_a_row;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_col, in_a_row, in_a_name)
    local
      Tpl.Text txt;
      Integer a_row;
      String a_name;
      Integer i_col;

    case ( txt,
           (i_col as 0),
           a_row,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = zeros("));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");%s\\n\""));
      then txt;

    case ( txt,
           i_col,
           a_row,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(a_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = [%s];\\n\""));
      then txt;
  end match;
end fun_422;

protected function fun_423
  input Tpl.Text in_txt;
  input Integer in_a_row;
  input String in_a_name;
  input Integer in_a_col;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_row, in_a_name, in_a_col)
    local
      Tpl.Text txt;
      String a_name;
      Integer a_col;
      Integer i_row;

    case ( txt,
           (i_row as 0),
           a_name,
           a_col )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  parameter Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = zeros("));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");%s\\n\""));
      then txt;

    case ( txt,
           i_row,
           a_name,
           a_col )
      equation
        txt = fun_422(txt, a_col, i_row, a_name);
      then txt;
  end match;
end fun_423;

public function genMatrix
  input Tpl.Text txt;
  input String a_name;
  input Integer a_row;
  input Integer a_col;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_423(txt, a_row, a_name, a_col);
end genMatrix;

protected function fun_425
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("](start="));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0);\\n\""));
      then txt;
  end match;
end fun_425;

protected function fun_426
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  input Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  input Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("](start= "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0);\\n\""));
      then txt;
  end match;
end fun_426;

protected function fun_427
  input Tpl.Text in_txt;
  input Integer in_a_numIn;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_numIn, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      Integer i_numIn;

    case ( txt,
           (i_numIn as 0),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  output Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;

    case ( txt,
           i_numIn,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"  output Real "));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_numIn));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];\\n\""));
      then txt;
  end match;
end fun_427;

protected function fun_428
  input Tpl.Text in_txt;
  input Integer in_a_flag;
  input String in_a_name;
  input Integer in_a_numIn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_flag, in_a_name, in_a_numIn)
    local
      Tpl.Text txt;
      String a_name;
      Integer a_numIn;

    case ( txt,
           0,
           a_name,
           a_numIn )
      equation
        txt = fun_425(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           1,
           a_name,
           a_numIn )
      equation
        txt = fun_426(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           2,
           a_name,
           a_numIn )
      equation
        txt = fun_427(txt, a_numIn, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_428;

public function genVector
  input Tpl.Text txt;
  input String a_name;
  input Integer a_numIn;
  input Integer a_flag;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_428(txt, a_flag, a_name, a_numIn);
end genVector;

protected function lm_430
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String a_modelNamePrefix;
      Integer i_maxColor;
      list<list<DAE.ComponentRef>> i_colorList;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> i_sparsepattern;
      String i_name;
      list<SimCodeVar.SimVar> i_vars;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_mat, i_vars, i_name, (i_sparsepattern, _, (_, _)), i_colorList, i_maxColor, _) :: rest,
           a_modelNamePrefix )
      equation
        txt = initialAnalyticJacobians(txt, i_mat, i_vars, i_name, i_sparsepattern, i_colorList, i_maxColor, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_430(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_430;

protected function lm_431
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String a_modelNamePrefix;
      String i_name;
      list<SimCodeVar.SimVar> i_vars;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_mat, i_vars, i_name, _, _, _, _) :: rest,
           a_modelNamePrefix )
      equation
        txt = generateMatrix(txt, i_mat, i_vars, i_name, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_431(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_431;

public function functionAnalyticJacobians
  input Tpl.Text txt;
  input list<SimCode.JacobianMatrix> a_JacobianMatrixes;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_jacMats;
  Tpl.Text l_initialjacMats;
algorithm
  l_initialjacMats := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_initialjacMats := lm_430(l_initialjacMats, a_JacobianMatrixes, a_modelNamePrefix);
  l_initialjacMats := Tpl.popIter(l_initialjacMats);
  l_jacMats := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_jacMats := lm_431(l_jacMats, a_JacobianMatrixes, a_modelNamePrefix);
  l_jacMats := Tpl.popIter(l_jacMats);
  out_txt := Tpl.writeText(txt, l_initialjacMats);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_jacMats);
end functionAnalyticJacobians;

protected function lm_433
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input list<DAE.ComponentRef> in_a_indexes;
  input String in_a_matrixname;
  input DAE.ComponentRef in_a_cref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_indexes, in_a_matrixname, in_a_cref)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      list<DAE.ComponentRef> a_indexes;
      String a_matrixname;
      DAE.ComponentRef a_cref;
      Integer x_index0;
      DAE.ComponentRef i_indexrow;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_indexrow :: rest,
           a_indexes,
           a_matrixname,
           a_cref )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("i = data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex["));
        txt = cref(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiff] - "));
        ret_0 = listLength(a_indexes);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.index[i+"
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_indexrow);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiffed;"));
        txt = Tpl.nextIter(txt);
        txt = lm_433(txt, rest, a_indexes, a_matrixname, a_cref);
      then txt;
  end match;
end lm_433;

public function mkSparseFunction
  input Tpl.Text in_txt;
  input String in_a_matrixname;
  input String in_a_matrixIndex;
  input DAE.ComponentRef in_a_cref;
  input list<DAE.ComponentRef> in_a_indexes;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_matrixname, in_a_matrixIndex, in_a_cref, in_a_indexes, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_matrixIndex;
      DAE.ComponentRef a_cref;
      list<DAE.ComponentRef> a_indexes;
      String a_modelNamePrefix;
      String i_matrixname;
      Tpl.Text l_indexrows;

    case ( txt,
           i_matrixname,
           a_matrixIndex,
           a_cref,
           a_indexes,
           a_modelNamePrefix )
      equation
        l_indexrows = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexrows = lm_433(l_indexrows, a_indexes, a_indexes, i_matrixname, a_cref);
        l_indexrows = Tpl.popIter(l_indexrows);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static void "));
        txt = symbolName(txt, a_modelNamePrefix, "initialAnalyticJacobian");
        txt = Tpl.writeStr(txt, i_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_matrixIndex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(DATA* data, int index)\n",
                                    "{\n",
                                    "  int i;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* write index for cref: "));
        txt = cref(txt, a_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.writeText(txt, l_indexrows);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end mkSparseFunction;

protected function lm_435
  input Tpl.Text in_txt;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> in_items;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixname)
    local
      Tpl.Text txt;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> rest;
      String a_matrixname;
      list<DAE.ComponentRef> i_indexes;
      DAE.ComponentRef i_cref;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_cref, i_indexes) :: rest,
           a_matrixname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex["));
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiff] = "));
        ret_0 = listLength(i_indexes);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_435(txt, rest, a_matrixname);
      then txt;
  end match;
end lm_435;

protected function lm_436
  input Tpl.Text in_txt;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> in_items;
  input String in_a_modelNamePrefix;
  input String in_a_matrixname;
  input Tpl.Text in_a_eachCrefParts;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eachCrefParts;
algorithm
  (out_txt, out_a_eachCrefParts) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_matrixname, in_a_eachCrefParts)
    local
      Tpl.Text txt;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> rest;
      String a_modelNamePrefix;
      String a_matrixname;
      Tpl.Text a_eachCrefParts;
      Integer x_index0;
      list<DAE.ComponentRef> i_indexes;
      DAE.ComponentRef i_cref;

    case ( txt,
           {},
           _,
           _,
           a_eachCrefParts )
      then (txt, a_eachCrefParts);

    case ( txt,
           (i_cref, i_indexes) :: rest,
           a_modelNamePrefix,
           a_matrixname,
           a_eachCrefParts )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        a_eachCrefParts = mkSparseFunction(a_eachCrefParts, a_matrixname, intString(x_index0), i_cref, i_indexes, a_modelNamePrefix);
        txt = symbolName(txt, a_modelNamePrefix, "initialAnalyticJacobian");
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(data, index);"));
        txt = Tpl.nextIter(txt);
        (txt, a_eachCrefParts) = lm_436(txt, rest, a_modelNamePrefix, a_matrixname, a_eachCrefParts);
      then (txt, a_eachCrefParts);
  end match;
end lm_436;

protected function lm_437
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_index0;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index0, in_a_matrixname)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_index0;
      String a_matrixname;
      DAE.ComponentRef i_i__index;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_i__index :: rest,
           a_index0,
           a_matrixname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.analyticJacobians[index].sparsePattern.colorCols["));
        txt = cref(txt, i_i__index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$pDER"));
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$indexdiff] = "));
        ret_0 = intAdd(a_index0, 1);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_437(txt, rest, a_index0, a_matrixname);
      then txt;
  end match;
end lm_437;

protected function lm_438
  input Tpl.Text in_txt;
  input list<list<DAE.ComponentRef>> in_items;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_matrixname)
    local
      Tpl.Text txt;
      list<list<DAE.ComponentRef>> rest;
      String a_matrixname;
      Integer x_index0;
      list<DAE.ComponentRef> i_indexes;
      Tpl.Text l_colorCol;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_indexes :: rest,
           a_matrixname )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        l_colorCol = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_colorCol = lm_437(l_colorCol, i_indexes, x_index0, a_matrixname);
        l_colorCol = Tpl.popIter(l_colorCol);
        txt = Tpl.writeText(txt, l_colorCol);
        txt = Tpl.nextIter(txt);
        txt = lm_438(txt, rest, a_matrixname);
      then txt;
  end match;
end lm_438;

protected function lm_439
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_indxColumn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_indxColumn) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_indxColumn);
        txt = Tpl.nextIter(txt);
        txt = lm_439(txt, rest);
      then txt;
  end match;
end lm_439;

protected function lm_440
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      list<SimCodeVar.SimVar> i_vars;
      Integer ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, i_vars, _) :: rest )
      equation
        ret_0 = listLength(i_vars);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.nextIter(txt);
        txt = lm_440(txt, rest);
      then txt;
  end match;
end lm_440;

protected function fun_441
  input Tpl.Text in_txt;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> in_a_sparsepattern;
  input Integer in_a_maxColor;
  input list<SimCodeVar.SimVar> in_a_seedVars;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input list<list<DAE.ComponentRef>> in_a_colorList;
  input String in_a_matrixname;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sparsepattern, in_a_maxColor, in_a_seedVars, in_a_jacobianColumn, in_a_colorList, in_a_matrixname, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      Integer a_maxColor;
      list<SimCodeVar.SimVar> a_seedVars;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      list<list<DAE.ComponentRef>> a_colorList;
      String a_matrixname;
      String a_modelNamePrefix;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> i_sparsepattern;
      Integer ret_12;
      Tpl.Text l_index__;
      Tpl.Text l_tmpvarsSize;
      Tpl.Text l_indexColumn;
      Tpl.Text l_colorArray;
      Tpl.Text l_indexElems;
      Tpl.Text l_leadindex;
      Integer ret_5;
      Tpl.Text l_sizeleadindex;
      Integer ret_3;
      list<list<DAE.ComponentRef>> ret_2;
      Tpl.Text l_sp__size__index;
      Tpl.Text l_eachCrefParts;

    case ( txt,
           {(_, {})},
           _,
           _,
           _,
           _,
           a_matrixname,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = symbolName(txt, a_modelNamePrefix, "initialAnalyticJacobian");
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* inData)\n",
                                    "{\n",
                                    "  return 1;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           i_sparsepattern,
           a_maxColor,
           a_seedVars,
           a_jacobianColumn,
           a_colorList,
           a_matrixname,
           a_modelNamePrefix )
      equation
        l_eachCrefParts = Tpl.emptyTxt;
        ret_2 = Util.splitTuple212List(i_sparsepattern);
        ret_3 = List.lengthListElements(ret_2);
        l_sp__size__index = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        ret_5 = listLength(i_sparsepattern);
        l_sizeleadindex = Tpl.writeStr(Tpl.emptyTxt, intString(ret_5));
        l_leadindex = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_leadindex = lm_435(l_leadindex, i_sparsepattern, a_matrixname);
        l_leadindex = Tpl.popIter(l_leadindex);
        l_indexElems = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_indexElems, l_eachCrefParts) = lm_436(l_indexElems, i_sparsepattern, a_modelNamePrefix, a_matrixname, l_eachCrefParts);
        l_indexElems = Tpl.popIter(l_indexElems);
        l_colorArray = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_colorArray = lm_438(l_colorArray, a_colorList, a_matrixname);
        l_colorArray = Tpl.popIter(l_colorArray);
        l_indexColumn = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexColumn = lm_439(l_indexColumn, a_jacobianColumn);
        l_indexColumn = Tpl.popIter(l_indexColumn);
        l_tmpvarsSize = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_tmpvarsSize = lm_440(l_tmpvarsSize, a_jacobianColumn);
        l_tmpvarsSize = Tpl.popIter(l_tmpvarsSize);
        ret_12 = listLength(a_seedVars);
        l_index__ = Tpl.writeStr(Tpl.emptyTxt, intString(ret_12));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_eachCrefParts);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "int "
                                }, false));
        txt = symbolName(txt, a_modelNamePrefix, "initialAnalyticJacobian");
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* inData)\n",
                                    "{\n",
                                    "  DATA* data = ((DATA*)inData);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int index = "));
        txt = symbolName(txt, a_modelNamePrefix, "INDEX_JAC_");
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n",
                                    "int i;\n",
                                    "\n",
                                    "data->simulationInfo.analyticJacobians[index].sizeCols = "
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].sizeRows = "
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].sizeTmpVars = "
                                }, false));
        txt = Tpl.writeText(txt, l_tmpvarsSize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].seedVars = (modelica_real*) calloc("
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",sizeof(modelica_real));\n",
                                    "data->simulationInfo.analyticJacobians[index].resultVars = (modelica_real*) calloc("
                                }, false));
        txt = Tpl.writeText(txt, l_indexColumn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",sizeof(modelica_real));\n",
                                    "data->simulationInfo.analyticJacobians[index].tmpVars = (modelica_real*) calloc("
                                }, false));
        txt = Tpl.writeText(txt, l_tmpvarsSize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",sizeof(modelica_real));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex = (unsigned int*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_sizeleadindex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(int));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.index = (unsigned int*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_sp__size__index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(int));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.colorCols = (unsigned int*) malloc("
                                }, false));
        txt = Tpl.writeText(txt, l_index__);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "*sizeof(int));\n",
                                    "data->simulationInfo.analyticJacobians[index].sparsePattern.maxColors = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_maxColor));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.analyticJacobians[index].jacobian = NULL;\n",
                                    "\n",
                                    "/* write column ptr of compressed sparse column*/\n"
                                }, true));
        txt = Tpl.writeText(txt, l_leadindex);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for(i=1;i<"));
        txt = Tpl.writeText(txt, l_sizeleadindex);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";++i)\n",
                                    "    data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex[i] += data->simulationInfo.analyticJacobians[index].sparsePattern.leadindex[i-1];\n",
                                    "\n",
                                    "\n",
                                    "/* call functions to write index for each cref */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_indexElems);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* write color array */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_colorArray);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_441;

protected function fun_442
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_seedVars;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input String in_a_matrixname;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> in_a_sparsepattern;
  input list<list<DAE.ComponentRef>> in_a_colorList;
  input Integer in_a_maxColor;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_seedVars, in_a_jacobianColumn, in_a_matrixname, in_a_sparsepattern, in_a_colorList, in_a_maxColor, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      String a_matrixname;
      list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> a_sparsepattern;
      list<list<DAE.ComponentRef>> a_colorList;
      Integer a_maxColor;
      String a_modelNamePrefix;
      list<SimCodeVar.SimVar> i_seedVars;

    case ( txt,
           {},
           _,
           a_matrixname,
           _,
           _,
           _,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = symbolName(txt, a_modelNamePrefix, "initialAnalyticJacobian");
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(void* inData)\n",
                                    "{\n",
                                    "  return 1;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           i_seedVars,
           a_jacobianColumn,
           a_matrixname,
           a_sparsepattern,
           a_colorList,
           a_maxColor,
           a_modelNamePrefix )
      equation
        txt = fun_441(txt, a_sparsepattern, a_maxColor, i_seedVars, a_jacobianColumn, a_colorList, a_matrixname, a_modelNamePrefix);
      then txt;
  end match;
end fun_442;

public function initialAnalyticJacobians
  input Tpl.Text txt;
  input list<SimCode.JacobianColumn> a_jacobianColumn;
  input list<SimCodeVar.SimVar> a_seedVars;
  input String a_matrixname;
  input list<tuple<DAE.ComponentRef, list<DAE.ComponentRef>>> a_sparsepattern;
  input list<list<DAE.ComponentRef>> a_colorList;
  input Integer a_maxColor;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_442(txt, a_seedVars, a_jacobianColumn, a_matrixname, a_sparsepattern, a_colorList, a_maxColor, a_modelNamePrefix);
end initialAnalyticJacobians;

protected function lm_444
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_indxColumn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_indxColumn) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_indxColumn);
        txt = lm_444(txt, rest);
      then txt;
  end match;
end lm_444;

protected function lm_445
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input String in_a_modelNamePrefix;
  input String in_a_matrixname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_matrixname)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String a_modelNamePrefix;
      String a_matrixname;
      String i_indxColumn;
      list<SimCodeVar.SimVar> i_vars;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (i_eqs, i_vars, i_indxColumn) :: rest,
           a_modelNamePrefix,
           a_matrixname )
      equation
        txt = functionJac(txt, i_eqs, i_vars, i_indxColumn, a_matrixname, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        txt = lm_445(txt, rest, a_modelNamePrefix, a_matrixname);
      then txt;
  end match;
end lm_445;

protected function lm_446
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      String i_indxColumn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_indxColumn) :: rest )
      equation
        txt = Tpl.writeStr(txt, i_indxColumn);
        txt = Tpl.nextIter(txt);
        txt = lm_446(txt, rest);
      then txt;
  end match;
end lm_446;

protected function fun_447
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_seedVars;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input String in_a_matrixname;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_seedVars, in_a_jacobianColumn, in_a_matrixname, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      String a_matrixname;
      String a_modelNamePrefix;
      Tpl.Text l_indexColumn;
      Tpl.Text l_jacMats;

    case ( txt,
           {},
           _,
           a_matrixname,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = symbolName(txt, a_modelNamePrefix, "functionJac");
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_column(void* data)\n",
                                    "{\n",
                                    "  return 0;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_jacobianColumn,
           a_matrixname,
           a_modelNamePrefix )
      equation
        l_jacMats = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jacMats = lm_445(l_jacMats, a_jacobianColumn, a_modelNamePrefix, a_matrixname);
        l_jacMats = Tpl.popIter(l_jacMats);
        l_indexColumn = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_indexColumn = lm_446(l_indexColumn, a_jacobianColumn);
        l_indexColumn = Tpl.popIter(l_indexColumn);
        txt = Tpl.writeText(txt, l_jacMats);
      then txt;
  end match;
end fun_447;

protected function fun_448
  input Tpl.Text in_txt;
  input String in_mArg;
  input list<SimCode.JacobianColumn> in_a_jacobianColumn;
  input list<SimCodeVar.SimVar> in_a_seedVars;
  input String in_a_matrixname;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_jacobianColumn, in_a_seedVars, in_a_matrixname, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> a_jacobianColumn;
      list<SimCodeVar.SimVar> a_seedVars;
      String a_matrixname;
      String a_modelNamePrefix;

    case ( txt,
           "0",
           _,
           _,
           a_matrixname,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = symbolName(txt, a_modelNamePrefix, "functionJac");
        txt = Tpl.writeStr(txt, a_matrixname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_column(void* data)\n",
                                    "{\n",
                                    "  return 0;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_jacobianColumn,
           a_seedVars,
           a_matrixname,
           a_modelNamePrefix )
      equation
        txt = fun_447(txt, a_seedVars, a_jacobianColumn, a_matrixname, a_modelNamePrefix);
      then txt;
  end match;
end fun_448;

public function generateMatrix
  input Tpl.Text txt;
  input list<SimCode.JacobianColumn> a_jacobianColumn;
  input list<SimCodeVar.SimVar> a_seedVars;
  input String a_matrixname;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  String str_1;
  Tpl.Text l_indxColumn;
algorithm
  l_indxColumn := lm_444(Tpl.emptyTxt, a_jacobianColumn);
  str_1 := Tpl.textString(l_indxColumn);
  out_txt := fun_448(txt, str_1, a_jacobianColumn, a_seedVars, a_matrixname, a_modelNamePrefix);
end generateMatrix;

protected function lm_450
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = equation_(txt, i_eq, SimCode.contextSimulationNonDiscrete, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_450(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_450;

public function functionJac
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_jacEquations;
  input list<SimCodeVar.SimVar> a_tmpVars;
  input String a_columnLength;
  input String a_matrixName;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqns__;
  Tpl.Text l_tmp;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_tmp := Tpl.emptyTxt;
  l_eqns__ := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_eqns__, l_tmp, l_varDecls) := lm_450(l_eqns__, a_jacEquations, a_modelNamePrefix, l_tmp, l_varDecls);
  l_eqns__ := Tpl.popIter(l_eqns__);
  out_txt := Tpl.writeText(txt, l_tmp);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int "));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "functionJac");
  out_txt := Tpl.writeStr(out_txt, a_matrixName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_column(void* inData)\n",
                                       "{\n",
                                       "  DATA* data = ((DATA*)inData);\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("int index = "));
  out_txt := symbolName(out_txt, a_modelNamePrefix, "INDEX_JAC_");
  out_txt := Tpl.writeStr(out_txt, a_matrixName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(";\n"));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_eqns__);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("return 0;\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionJac;

protected function lm_452
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_it));
        txt = Tpl.nextIter(txt);
        txt = lm_452(txt, rest);
      then txt;
  end match;
end lm_452;

public function intArr
  input Tpl.Text txt;
  input list<Integer> a_values;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_452(out_txt, a_values);
  out_txt := Tpl.popIter(out_txt);
end intArr;

protected function fun_454
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;
  end match;
end fun_454;

protected function lm_455
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = symbolName(txt, a_modelNamePrefix, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = CodegenUtil.equationIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(DATA*);"));
        txt = Tpl.nextIter(txt);
        txt = lm_455(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_455;

protected function fun_456
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_eqfuncs;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tempeqns;
  input Tpl.Text in_a_varD;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqfuncs;
  output Tpl.Text out_a_tempeqns;
  output Tpl.Text out_a_varD;
algorithm
  (out_txt, out_a_eqfuncs, out_a_tempeqns, out_a_varD) :=
  match(in_txt, in_a_eq, in_a_eqfuncs, in_a_modelNamePrefix, in_a_tempeqns, in_a_varD, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_eqfuncs;
      String a_modelNamePrefix;
      Tpl.Text a_tempeqns;
      Tpl.Text a_varD;
      SimCode.Context a_context;
      list<SimCode.SimEqSystem> i_e_eqs;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(index = _)),
           a_eqfuncs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationSimpleAssign(txt, i_e, a_context, a_varD, a_tempeqns);
      then (txt, a_eqfuncs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(index = _)),
           a_eqfuncs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationArrayCallAssign(txt, i_e, a_context, a_varD, a_tempeqns);
      then (txt, a_eqfuncs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_IFEQUATION(index = _)),
           a_eqfuncs,
           a_modelNamePrefix,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationIfEquationAssign(txt, i_e, a_context, a_varD, a_tempeqns, a_modelNamePrefix);
      then (txt, a_eqfuncs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(index = _)),
           a_eqfuncs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationAlgorithm(txt, i_e, a_context, a_varD, a_tempeqns);
      then (txt, a_eqfuncs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_eqfuncs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationLinear(txt, i_e, a_context, a_varD);
      then (txt, a_eqfuncs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(eqs = i_e_eqs)),
           a_eqfuncs,
           a_modelNamePrefix,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        a_tempeqns = Tpl.pushIter(a_tempeqns, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        a_tempeqns = lm_455(a_tempeqns, i_e_eqs, a_modelNamePrefix);
        a_tempeqns = Tpl.popIter(a_tempeqns);
        (txt, a_varD) = equationNonlinear(txt, i_e, a_context, a_varD, a_modelNamePrefix);
      then (txt, a_eqfuncs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_WHEN(index = _)),
           a_eqfuncs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationWhen(txt, i_e, a_context, a_varD, a_tempeqns);
      then (txt, a_eqfuncs, a_tempeqns, a_varD);

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           a_eqfuncs,
           _,
           a_tempeqns,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION SES_RESIDUAL"));
      then (txt, a_eqfuncs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_eqfuncs,
           a_modelNamePrefix,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_eqfuncs) = equationMixed(txt, i_e, a_context, a_varD, a_eqfuncs, a_modelNamePrefix);
      then (txt, a_eqfuncs, a_tempeqns, a_varD);

    case ( txt,
           _,
           a_eqfuncs,
           _,
           a_tempeqns,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION equation_"));
      then (txt, a_eqfuncs, a_tempeqns, a_varD);
  end match;
end fun_456;

protected function fun_457
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input String in_a_name;
  input SimCode.Context in_a_context;
  input Integer in_a_arrayIndex;
  input Tpl.Text in_a_eqArray;
  input Tpl.Text in_a_eqfuncs;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqArray;
  output Tpl.Text out_a_eqfuncs;
algorithm
  (out_txt, out_a_eqArray, out_a_eqfuncs) :=
  match(in_txt, in_a_eq, in_a_name, in_a_context, in_a_arrayIndex, in_a_eqArray, in_a_eqfuncs, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      String a_name;
      SimCode.Context a_context;
      Integer a_arrayIndex;
      Tpl.Text a_eqArray;
      Tpl.Text a_eqfuncs;
      String a_modelNamePrefix;
      SimCode.SimEqSystem i_eq;
      list<SimCode.SimEqSystem> ret_6;
      Tpl.Text l_x;
      Tpl.Text l_disc;
      Tpl.Text l_tempeqns;
      Tpl.Text l_varD;
      Tpl.Text l_tmp;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _,
           _,
           a_eqArray,
           a_eqfuncs,
           _ )
      then (txt, a_eqArray, a_eqfuncs);

    case ( txt,
           i_eq,
           a_name,
           a_context,
           a_arrayIndex,
           a_eqArray,
           a_eqfuncs,
           a_modelNamePrefix )
      equation
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, i_eq);
        l_tmp = Tpl.emptyTxt;
        l_varD = Tpl.emptyTxt;
        l_tempeqns = Tpl.emptyTxt;
        System.tmpTickResetIndex(0, 1);
        l_disc = fun_454(Tpl.emptyTxt, a_context);
        (l_x, a_eqfuncs, l_tempeqns, l_varD) = fun_456(Tpl.emptyTxt, i_eq, a_eqfuncs, a_modelNamePrefix, l_tempeqns, l_varD, a_context);
        a_eqArray = symbolName(a_eqArray, a_modelNamePrefix, "eqFunction");
        a_eqArray = Tpl.writeTok(a_eqArray, Tpl.ST_STRING("_"));
        a_eqArray = Tpl.writeText(a_eqArray, l_ix);
        a_eqArray = Tpl.writeTok(a_eqArray, Tpl.ST_STRING(", "));
        a_eqArray = Tpl.writeTok(a_eqArray, Tpl.ST_NEW_LINE());
        l_varD = addRootsTempArray(l_varD);
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_NEW_LINE());
        a_eqfuncs = Tpl.writeText(a_eqfuncs, l_tempeqns);
        a_eqfuncs = Tpl.softNewLine(a_eqfuncs);
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_LINE("/*\n"));
        a_eqfuncs = Tpl.pushBlock(a_eqfuncs, Tpl.BT_INDENT(1));
        ret_6 = List.fill(i_eq, 1);
        a_eqfuncs = CodegenUtil.dumpEqs(a_eqfuncs, ret_6);
        a_eqfuncs = Tpl.softNewLine(a_eqfuncs);
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_LINE("*/\n"));
        a_eqfuncs = Tpl.popBlock(a_eqfuncs);
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_STRING("void "));
        a_eqfuncs = symbolName(a_eqfuncs, a_modelNamePrefix, "eqFunction");
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_STRING("_"));
        a_eqfuncs = Tpl.writeText(a_eqfuncs, l_ix);
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_STRING_LIST({
                                                "(DATA *data)\n",
                                                "{\n"
                                            }, true));
        a_eqfuncs = Tpl.pushBlock(a_eqfuncs, Tpl.BT_INDENT(2));
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_STRING("const int equationIndexes[2] = {1,"));
        a_eqfuncs = Tpl.writeText(a_eqfuncs, l_ix);
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_STRING_LIST({
                                                "};\n",
                                                "TRACE_PUSH\n"
                                            }, true));
        a_eqfuncs = Tpl.writeText(a_eqfuncs, l_varD);
        a_eqfuncs = Tpl.softNewLine(a_eqfuncs);
        a_eqfuncs = Tpl.writeText(a_eqfuncs, l_x);
        a_eqfuncs = Tpl.softNewLine(a_eqfuncs);
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_LINE("TRACE_POP\n"));
        a_eqfuncs = Tpl.popBlock(a_eqfuncs);
        a_eqfuncs = Tpl.writeTok(a_eqfuncs, Tpl.ST_STRING("}"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// "));
        txt = symbolName(txt, a_modelNamePrefix, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(data);\n",
                                    "function"
                                }, false));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_systems["));
        txt = Tpl.writeStr(txt, intString(a_arrayIndex));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("](data);"));
      then (txt, a_eqArray, a_eqfuncs);
  end match;
end fun_457;

public function equation_arrayFormat
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input String a_name;
  input SimCode.Context a_context;
  input Integer a_arrayIndex;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_eqArray;
  input Tpl.Text a_eqfuncs;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqArray;
  output Tpl.Text out_a_eqfuncs;
algorithm
  (out_txt, out_a_eqArray, out_a_eqfuncs) := fun_457(txt, a_eq, a_name, a_context, a_arrayIndex, a_eqArray, a_eqfuncs, a_modelNamePrefix);
  out_a_varDecls := a_varDecls;
end equation_arrayFormat;

protected function fun_459
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;
  end match;
end fun_459;

protected function lm_460
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_modelNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = symbolName(txt, a_modelNamePrefix, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = CodegenUtil.equationIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(DATA*);"));
        txt = Tpl.nextIter(txt);
        txt = lm_460(txt, rest, a_modelNamePrefix);
      then txt;
  end match;
end lm_460;

protected function fun_461
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_eqs;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tempeqns;
  input Tpl.Text in_a_varD;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqs;
  output Tpl.Text out_a_tempeqns;
  output Tpl.Text out_a_varD;
algorithm
  (out_txt, out_a_eqs, out_a_tempeqns, out_a_varD) :=
  match(in_txt, in_a_eq, in_a_eqs, in_a_modelNamePrefix, in_a_tempeqns, in_a_varD, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_eqs;
      String a_modelNamePrefix;
      Tpl.Text a_tempeqns;
      Tpl.Text a_varD;
      SimCode.Context a_context;
      list<SimCode.SimEqSystem> i_e_eqs;
      SimCode.SimEqSystem i_e;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(index = _)),
           a_eqs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationSimpleAssign(txt, i_e, a_context, a_varD, a_tempeqns);
      then (txt, a_eqs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(index = _)),
           a_eqs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationArrayCallAssign(txt, i_e, a_context, a_varD, a_tempeqns);
      then (txt, a_eqs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_IFEQUATION(index = _)),
           a_eqs,
           a_modelNamePrefix,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationIfEquationAssign(txt, i_e, a_context, a_varD, a_tempeqns, a_modelNamePrefix);
      then (txt, a_eqs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(index = _)),
           a_eqs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationAlgorithm(txt, i_e, a_context, a_varD, a_tempeqns);
      then (txt, a_eqs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(index = _)),
           a_eqs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD) = equationLinear(txt, i_e, a_context, a_varD);
      then (txt, a_eqs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(eqs = i_e_eqs)),
           a_eqs,
           a_modelNamePrefix,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        a_tempeqns = Tpl.pushIter(a_tempeqns, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        a_tempeqns = lm_460(a_tempeqns, i_e_eqs, a_modelNamePrefix);
        a_tempeqns = Tpl.popIter(a_tempeqns);
        (txt, a_varD) = equationNonlinear(txt, i_e, a_context, a_varD, a_modelNamePrefix);
      then (txt, a_eqs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_WHEN(index = _)),
           a_eqs,
           _,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_tempeqns) = equationWhen(txt, i_e, a_context, a_varD, a_tempeqns);
      then (txt, a_eqs, a_tempeqns, a_varD);

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           a_eqs,
           _,
           a_tempeqns,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION SES_RESIDUAL"));
      then (txt, a_eqs, a_tempeqns, a_varD);

    case ( txt,
           (i_e as SimCode.SES_MIXED(index = _)),
           a_eqs,
           a_modelNamePrefix,
           a_tempeqns,
           a_varD,
           a_context )
      equation
        (txt, a_varD, a_eqs) = equationMixed(txt, i_e, a_context, a_varD, a_eqs, a_modelNamePrefix);
      then (txt, a_eqs, a_tempeqns, a_varD);

    case ( txt,
           _,
           a_eqs,
           _,
           a_tempeqns,
           a_varD,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED EQUATION equation_"));
      then (txt, a_eqs, a_tempeqns, a_varD);
  end match;
end fun_461;

protected function fun_462
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_462;

protected function fun_463
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_463;

protected function fun_464
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_eqs;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_eqs) :=
  match(in_txt, in_a_eq, in_a_context, in_a_eqs, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_eqs;
      String a_modelNamePrefix;
      SimCode.SimEqSystem i_eq;
      Boolean ret_8;
      Boolean ret_7;
      list<SimCode.SimEqSystem> ret_6;
      Tpl.Text l_x;
      Tpl.Text l_disc;
      Tpl.Text l_tempeqns;
      Tpl.Text l_varD;
      Tpl.Text l_tmp;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           a_eqs,
           _ )
      then (txt, a_eqs);

    case ( txt,
           i_eq,
           a_context,
           a_eqs,
           a_modelNamePrefix )
      equation
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, i_eq);
        l_tmp = Tpl.emptyTxt;
        l_varD = Tpl.emptyTxt;
        l_tempeqns = Tpl.emptyTxt;
        System.tmpTickResetIndex(0, 1);
        l_disc = fun_459(Tpl.emptyTxt, a_context);
        (l_x, a_eqs, l_tempeqns, l_varD) = fun_461(Tpl.emptyTxt, i_eq, a_eqs, a_modelNamePrefix, l_tempeqns, l_varD, a_context);
        l_varD = addRootsTempArray(l_varD);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_NEW_LINE());
        a_eqs = Tpl.writeText(a_eqs, l_tempeqns);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_LINE("/*\n"));
        a_eqs = Tpl.pushBlock(a_eqs, Tpl.BT_INDENT(1));
        ret_6 = List.fill(i_eq, 1);
        a_eqs = CodegenUtil.dumpEqs(a_eqs, ret_6);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_LINE("*/\n"));
        a_eqs = Tpl.popBlock(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING("void "));
        a_eqs = symbolName(a_eqs, a_modelNamePrefix, "eqFunction");
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING("_"));
        a_eqs = Tpl.writeText(a_eqs, l_ix);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING_LIST({
                                        "(DATA *data)\n",
                                        "{\n"
                                    }, true));
        a_eqs = Tpl.pushBlock(a_eqs, Tpl.BT_INDENT(2));
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING("const int equationIndexes[2] = {1,"));
        a_eqs = Tpl.writeText(a_eqs, l_ix);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING_LIST({
                                        "};\n",
                                        "TRACE_PUSH\n"
                                    }, true));
        a_eqs = Tpl.writeText(a_eqs, l_varD);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.writeText(a_eqs, l_x);
        a_eqs = Tpl.softNewLine(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_LINE("TRACE_POP\n"));
        a_eqs = Tpl.popBlock(a_eqs);
        a_eqs = Tpl.writeTok(a_eqs, Tpl.ST_STRING("}"));
        ret_7 = Config.profileAll();
        txt = fun_462(txt, ret_7, l_ix);
        txt = Tpl.softNewLine(txt);
        txt = symbolName(txt, a_modelNamePrefix, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(data);\n"));
        ret_8 = Config.profileAll();
        txt = fun_463(txt, ret_8, l_ix);
      then (txt, a_eqs);
  end match;
end fun_464;

public function equation_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_eqs;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqs;
algorithm
  (out_txt, out_a_eqs) := fun_464(txt, a_eq, a_context, a_eqs, a_modelNamePrefix);
  out_a_varDecls := a_varDecls;
end equation_;

protected function fun_466
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      SimCode.SimEqSystem i_eq;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _ )
      then txt;

    case ( txt,
           i_eq,
           a_modelNamePrefixStr )
      equation
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern void "));
        txt = symbolName(txt, a_modelNamePrefixStr, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(DATA* data);"));
      then txt;
  end match;
end fun_466;

protected function fun_467
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      SimCode.SimEqSystem i_eq;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _ )
      then txt;

    case ( txt,
           i_eq,
           a_modelNamePrefixStr )
      equation
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern void "));
        txt = symbolName(txt, a_modelNamePrefixStr, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(DATA* data);"));
      then txt;
  end match;
end fun_467;

protected function fun_468
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimEqSystem in_a_eq;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_eq, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      String a_modelNamePrefixStr;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true),
           a_eq,
           a_modelNamePrefixStr )
      equation
        txt = fun_466(txt, a_eq, a_modelNamePrefixStr);
      then txt;

    case ( txt,
           _,
           a_eq,
           a_modelNamePrefixStr )
      equation
        txt = fun_467(txt, a_eq, a_modelNamePrefixStr);
      then txt;
  end match;
end fun_468;

public function equationForward_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_468(txt, a_context, a_eq, a_modelNamePrefixStr);
end equationForward_;

protected function fun_470
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_470;

protected function fun_471
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_471;

protected function fun_472
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      SimCode.SimEqSystem i_eq;
      Boolean ret_2;
      Boolean ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _ )
      then txt;

    case ( txt,
           i_eq,
           a_modelNamePrefixStr )
      equation
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, i_eq);
        ret_1 = Config.profileAll();
        txt = fun_470(txt, ret_1, l_ix);
        txt = Tpl.softNewLine(txt);
        txt = symbolName(txt, a_modelNamePrefixStr, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(data);\n"));
        ret_2 = Config.profileAll();
        txt = fun_471(txt, ret_2, l_ix);
      then txt;
  end match;
end fun_472;

protected function fun_473
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_473;

protected function fun_474
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_ix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_ix)
    local
      Tpl.Text txt;
      Tpl.Text a_ix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_ix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ("));
        txt = Tpl.writeText(txt, a_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_474;

protected function fun_475
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      String a_modelNamePrefixStr;
      SimCode.SimEqSystem i_eq;
      Boolean ret_2;
      Boolean ret_1;
      Tpl.Text l_ix;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _ )
      then txt;

    case ( txt,
           i_eq,
           a_modelNamePrefixStr )
      equation
        l_ix = CodegenUtil.equationIndex(Tpl.emptyTxt, i_eq);
        ret_1 = Config.profileAll();
        txt = fun_473(txt, ret_1, l_ix);
        txt = Tpl.softNewLine(txt);
        txt = symbolName(txt, a_modelNamePrefixStr, "eqFunction");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, l_ix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("(data);\n"));
        ret_2 = Config.profileAll();
        txt = fun_474(txt, ret_2, l_ix);
      then txt;
  end match;
end fun_475;

protected function fun_476
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input SimCode.SimEqSystem in_a_eq;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_eq, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      String a_modelNamePrefixStr;

    case ( txt,
           SimCode.SIMULATION_CONTEXT(genDiscrete = true),
           a_eq,
           a_modelNamePrefixStr )
      equation
        txt = fun_472(txt, a_eq, a_modelNamePrefixStr);
      then txt;

    case ( txt,
           _,
           a_eq,
           a_modelNamePrefixStr )
      equation
        txt = fun_475(txt, a_eq, a_modelNamePrefixStr);
      then txt;
  end match;
end fun_476;

public function equationNames_
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input String a_modelNamePrefixStr;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_476(txt, a_context, a_eq, a_modelNamePrefixStr);
end equationNames_;

public function equationSimpleAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_auxFunction)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_auxFunction;
      DAE.ComponentRef i_cref;
      SimCode.SimEqSystem i_eq;
      DAE.Exp i_exp;
      Absyn.Info ret_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = DAE.CALL(path = Absyn.IDENT(name = "fail"))),
           _,
           a_varDecls,
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_THROW_INTERNAL()"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           (i_eq as SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref)),
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_auxFunction);
        ret_2 = SimCodeUtil.eqInfo(i_eq);
        txt = modelicaLine(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = endModelicaLine(txt);
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_auxFunction )
      then (txt, a_varDecls, a_auxFunction);
  end match;
end equationSimpleAssign;

protected function fun_479
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_eqn_exp;
  input DAE.ComponentRef in_a_eqn_componentRef;
  input Tpl.Text in_a_expPart;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_eqn_exp, in_a_eqn_componentRef, in_a_expPart, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_eqn_exp;
      DAE.ComponentRef a_eqn_componentRef;
      Tpl.Text a_expPart;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text txt_1;
      String ret_1;
      Tpl.Text l_tvar;

    case ( txt,
           "boolean",
           _,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "boolean_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_boolean_array_data_mem("));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           "integer",
           _,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "integer_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_integer_array_data_mem("));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           "real",
           _,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_real_array_data_mem("));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           "string",
           _,
           a_eqn_componentRef,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_string_array_data_mem("));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_eqn_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_eqn_exp,
           _,
           _,
           _,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("No runtime support for this sort of array call: "));
        ret_1 = ExpressionDump.printExpStr(a_eqn_exp);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 3940, 14), Tpl.textString(txt_1));
      then (txt, a_varDecls);
  end match;
end fun_479;

protected function fun_480
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_auxFunction)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_auxFunction;
      DAE.ComponentRef i_eqn_componentRef;
      DAE.Exp i_eqn_exp;
      DAE.Exp i_exp;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(exp = (i_eqn_exp as i_exp), componentRef = i_eqn_componentRef),
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_auxFunction);
        txt_2 = expTypeFromExpShort(Tpl.emptyTxt, i_eqn_exp);
        str_3 = Tpl.textString(txt_2);
        (txt, a_varDecls) = fun_479(txt, str_3, i_eqn_exp, i_eqn_componentRef, l_expPart, l_preExp, a_varDecls);
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_auxFunction )
      then (txt, a_varDecls, a_auxFunction);
  end match;
end fun_480;

public function equationArrayCallAssign
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
protected
  Absyn.Info ret_0;
algorithm
  ret_0 := SimCodeUtil.eqInfo(a_eq);
  out_txt := modelicaLine(txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  (out_txt, out_a_varDecls, out_a_auxFunction) := fun_480(out_txt, a_eq, a_context, a_varDecls, a_auxFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := endModelicaLine(out_txt);
end equationArrayCallAssign;

protected function lm_482
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls,
           _ )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_auxFunction,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls, a_auxFunction) = algStatement(txt, i_stmt, a_context, a_varDecls, a_auxFunction);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls) = lm_482(txt, rest, a_auxFunction, a_varDecls, a_context);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_482;

public function equationAlgorithm
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_auxFunction)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_auxFunction;
      list<DAE.Statement> i_statements;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = i_statements),
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_auxFunction, a_varDecls) = lm_482(txt, i_statements, a_auxFunction, a_varDecls, a_context);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_auxFunction )
      then (txt, a_varDecls, a_auxFunction);
  end match;
end equationAlgorithm;

protected function fun_484
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").profileBlockIndex);"));
      then txt;
  end match;
end fun_484;

protected function lm_485
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_indexLinearSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_indexLinearSystem)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_indexLinearSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest,
           a_indexLinearSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = data->simulationInfo.linearSystemData["));
        txt = Tpl.writeStr(txt, intString(a_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].x["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_485(txt, rest, a_indexLinearSystem);
      then txt;

    case ( txt,
           _ :: rest,
           a_indexLinearSystem )
      equation
        txt = lm_485(txt, rest, a_indexLinearSystem);
      then txt;
  end match;
end lm_485;

protected function fun_486
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").profileBlockIndex);"));
      then txt;
  end match;
end fun_486;

protected function fun_487
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars;
      Integer i_indexLinearSystem;
      Integer i_index;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index, indexLinearSystem = i_indexLinearSystem, vars = i_vars) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* Linear equation system */\n"));
        ret_0 = Config.profileSome();
        txt = fun_484(txt, ret_0, i_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("solve_linear_system(data, "));
        txt = Tpl.writeStr(txt, intString(i_indexLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_485(txt, i_vars, i_indexLinearSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        ret_1 = Config.profileSome();
        txt = fun_486(txt, ret_1, i_index);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_487;

public function equationLinear
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_487(txt, a_eq);
  out_a_varDecls := a_varDecls;
end equationLinear;

protected function fun_489
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").profileBlockIndex);"));
      then txt;
  end match;
end fun_489;

protected function lm_490
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_eqn_indexMixedSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_eqn_indexMixedSystem)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_eqn_indexMixedSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest,
           a_eqn_indexMixedSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.mixedSystemData["));
        txt = Tpl.writeStr(txt, intString(a_eqn_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].iterationVarsPtr["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (modelica_boolean*)&"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_490(txt, rest, a_eqn_indexMixedSystem);
      then txt;

    case ( txt,
           _ :: rest,
           a_eqn_indexMixedSystem )
      equation
        txt = lm_490(txt, rest, a_eqn_indexMixedSystem);
      then txt;
  end match;
end lm_490;

protected function lm_491
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_eqn_indexMixedSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_eqn_indexMixedSystem)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_eqn_indexMixedSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest,
           a_eqn_indexMixedSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.mixedSystemData["));
        txt = Tpl.writeStr(txt, intString(a_eqn_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].iterationPreVarsPtr["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (modelica_boolean*)&$P$PRE"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_491(txt, rest, a_eqn_indexMixedSystem);
      then txt;

    case ( txt,
           _ :: rest,
           a_eqn_indexMixedSystem )
      equation
        txt = lm_491(txt, rest, a_eqn_indexMixedSystem);
      then txt;
  end match;
end lm_491;

protected function fun_492
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").profileBlockIndex);"));
      then txt;
  end match;
end fun_492;

public function equationMixed
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_tmp;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_tmp;
algorithm
  (out_txt, out_a_varDecls, out_a_tmp) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_tmp, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_tmp;
      String a_modelNamePrefixStr;
      Integer i_indexMixedSystem;
      Integer i_eqn_indexMixedSystem;
      Integer i_index;
      list<SimCodeVar.SimVar> i_discVars;
      SimCode.SimEqSystem i_cont;
      Boolean ret_4;
      Boolean ret_3;
      Integer ret_2;
      Tpl.Text l_numDiscVarsStr;
      Tpl.Text l_contEqs;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discVars = i_discVars, index = i_index, indexMixedSystem = (i_indexMixedSystem as i_eqn_indexMixedSystem)),
           a_context,
           a_varDecls,
           a_tmp,
           a_modelNamePrefixStr )
      equation
        (l_contEqs, a_varDecls, a_tmp) = equation_(Tpl.emptyTxt, i_cont, a_context, a_varDecls, a_tmp, a_modelNamePrefixStr);
        ret_2 = listLength(i_discVars);
        l_numDiscVarsStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Continuous equation part in "));
        txt = Tpl.writeText(txt, l_contEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        ret_3 = Config.profileSome();
        txt = fun_489(txt, ret_3, i_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_490(txt, i_discVars, i_eqn_indexMixedSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_491(txt, i_discVars, i_eqn_indexMixedSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "solve_mixed_system(data, "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_indexMixedSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        ret_4 = Config.profileSome();
        txt = fun_492(txt, ret_4, i_index);
      then (txt, a_varDecls, a_tmp);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_tmp,
           _ )
      then (txt, a_varDecls, a_tmp);
  end match;
end equationMixed;

protected function lm_494
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefix;
  input Tpl.Text in_a_tmp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_tmp, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefix, in_a_tmp, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefix;
      Tpl.Text a_tmp;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           a_tmp,
           a_varDecls )
      then (txt, a_tmp, a_varDecls);

    case ( txt,
           i_eq2 :: rest,
           a_modelNamePrefix,
           a_tmp,
           a_varDecls )
      equation
        (txt, a_varDecls, a_tmp) = functionExtraResidualsPreBody(txt, i_eq2, a_varDecls, a_tmp, a_modelNamePrefix);
        txt = Tpl.nextIter(txt);
        (txt, a_tmp, a_varDecls) = lm_494(txt, rest, a_modelNamePrefix, a_tmp, a_varDecls);
      then (txt, a_tmp, a_varDecls);
  end match;
end lm_494;

protected function fun_495
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_TICK_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ").profileBlockIndex);\n",
                                    "SIM_PROF_ADD_NCALL_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").profileBlockIndex,-1);"));
      then txt;
  end match;
end fun_495;

protected function lm_496
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_indexNonLinearSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_indexNonLinearSystem)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_indexNonLinearSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_indexNonLinearSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("data->simulationInfo.nonlinearSystemData["));
        txt = Tpl.writeStr(txt, intString(a_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nlsx["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "data->simulationInfo.nonlinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nlsxOld["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = _"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(1) /*old*/;\n",
                                    "data->simulationInfo.nonlinearSystemData["
                                }, false));
        txt = Tpl.writeStr(txt, intString(a_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nlsxExtrapolation["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = extraPolate(data, _"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1) /*old*/, _"));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(2) /*old2*/);"));
        txt = Tpl.nextIter(txt);
        txt = lm_496(txt, rest, a_indexNonLinearSystem);
      then txt;
  end match;
end lm_496;

protected function lm_497
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_indexNonLinearSystem;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_indexNonLinearSystem)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_indexNonLinearSystem;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_indexNonLinearSystem )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = data->simulationInfo.nonlinearSystemData["));
        txt = Tpl.writeStr(txt, intString(a_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("].nlsx["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_497(txt, rest, a_indexNonLinearSystem);
      then txt;
  end match;
end lm_497;

protected function fun_498
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIM_PROF_ACC_EQ(modelInfoXmlGetEquation(&data->modelData.modelDataXml,"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").profileBlockIndex);"));
      then txt;
  end match;
end fun_498;

protected function fun_499
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input String in_a_modelNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_varDecls, in_a_modelNamePrefix)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      String a_modelNamePrefix;
      Integer i_index;
      Integer i_indexNonLinearSystem;
      list<SimCode.SimEqSystem> i_eqs;
      list<DAE.ComponentRef> i_crefs;
      Boolean ret_6;
      Boolean ret_5;
      Tpl.Text l_nonlinindx;
      Tpl.Text l_innerBody;
      Tpl.Text l_tmp;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, eqs = i_eqs, indexNonLinearSystem = i_indexNonLinearSystem, index = i_index),
           a_varDecls,
           a_modelNamePrefix )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_tmp = Tpl.emptyTxt;
        l_innerBody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_innerBody, l_tmp, a_varDecls) = lm_494(l_innerBody, i_eqs, a_modelNamePrefix, l_tmp, a_varDecls);
        l_innerBody = Tpl.popIter(l_innerBody);
        l_nonlinindx = Tpl.writeStr(Tpl.emptyTxt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("int retValue;\n"));
        ret_5 = Config.profileSome();
        txt = fun_495(txt, ret_5, i_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* extrapolate data */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_496(txt, i_crefs, i_indexNonLinearSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("retValue = solve_nonlinear_system(data, "));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "/* check if solution process was sucessful */\n",
                                    "if (retValue > 0){\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int indexes[2] = {1,"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "throwStreamPrintWithEquationIndexes(threadData, indexes, \"Solving non-linear system failed at time=%.15g.\\nFor more information please use -lv LOG_NLS.\", time);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "/* write solution */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_497(txt, i_crefs, i_indexNonLinearSystem);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* update inner equations */\n"));
        txt = Tpl.writeText(txt, l_innerBody);
        txt = Tpl.softNewLine(txt);
        ret_6 = Config.profileSome();
        txt = fun_498(txt, ret_6, i_index);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);
  end match;
end fun_499;

public function equationNonlinear
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input String a_modelNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) := fun_499(txt, a_eq, a_varDecls, a_modelNamePrefix);
end equationNonlinear;

protected function lm_501
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_501(txt, rest);
      then txt;
  end match;
end lm_501;

protected function fun_502
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_right;
  input DAE.ComponentRef in_a_left;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_a_initialCall, in_a_auxFunction, in_a_varDecls, in_a_context, in_a_right, in_a_left)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp a_right;
      DAE.ComponentRef a_left;
      DAE.Type ret_0;

    case ( txt,
           false,
           a_auxFunction,
           a_varDecls,
           _,
           _,
           a_left )
      equation
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _,
           a_auxFunction,
           a_varDecls,
           a_context,
           a_right,
           a_left )
      equation
        ret_0 = Expression.typeof(a_right);
        (txt, a_varDecls, a_auxFunction) = whenAssign(txt, a_left, ret_0, a_right, a_context, a_varDecls, a_auxFunction);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end fun_502;

protected function lm_503
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_503(txt, rest);
      then txt;
  end match;
end lm_503;

protected function fun_504
  input Tpl.Text in_txt;
  input Boolean in_a_initialCall;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input DAE.Exp in_a_right;
  input DAE.ComponentRef in_a_left;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_a_initialCall, in_a_auxFunction, in_a_varDecls, in_a_context, in_a_right, in_a_left)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      DAE.Exp a_right;
      DAE.ComponentRef a_left;
      DAE.Type ret_0;

    case ( txt,
           false,
           a_auxFunction,
           a_varDecls,
           _,
           _,
           a_left )
      equation
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           _,
           a_auxFunction,
           a_varDecls,
           a_context,
           a_right,
           a_left )
      equation
        ret_0 = Expression.typeof(a_right);
        (txt, a_varDecls, a_auxFunction) = whenAssign(txt, a_left, ret_0, a_right, a_context, a_varDecls, a_auxFunction);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end fun_504;

public function equationWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_auxFunction)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_auxFunction;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.Exp i_right;
      DAE.ComponentRef i_left;
      Boolean i_initialCall;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_elseWhen;
      DAE.Type ret_4;
      DAE.Type ret_3;
      Tpl.Text l_assign;
      Tpl.Text l_initial__assign;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE(), initialCall = i_initialCall),
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        l_helpIf = lm_501(Tpl.emptyTxt, i_conditions);
        (l_initial__assign, a_auxFunction, a_varDecls) = fun_502(Tpl.emptyTxt, i_initialCall, a_auxFunction, a_varDecls, a_context, i_right, i_left);
        ret_3 = Expression.typeof(i_right);
        (l_assign, a_varDecls, a_auxFunction) = whenAssign(Tpl.emptyTxt, i_left, ret_3, i_right, a_context, a_varDecls, a_auxFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(initial())\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_initial__assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else if(0"
                                }, false));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq), initialCall = i_initialCall),
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        l_helpIf = lm_503(Tpl.emptyTxt, i_conditions);
        (l_initial__assign, a_auxFunction, a_varDecls) = fun_504(Tpl.emptyTxt, i_initialCall, a_auxFunction, a_varDecls, a_context, i_right, i_left);
        ret_4 = Expression.typeof(i_right);
        (l_assign, a_varDecls, a_auxFunction) = whenAssign(Tpl.emptyTxt, i_left, ret_4, i_right, a_context, a_varDecls, a_auxFunction);
        (l_elseWhen, a_varDecls, a_auxFunction) = equationElseWhen(Tpl.emptyTxt, i_elseWhenEq, a_context, a_varDecls, a_auxFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(initial())\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_initial__assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else if(0"
                                }, false));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_elseWhen);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "else\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = $P$PRE"));
        txt = cref(txt, i_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_auxFunction )
      then (txt, a_varDecls, a_auxFunction);
  end match;
end equationWhen;

protected function lm_506
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_506(txt, rest);
      then txt;
  end match;
end lm_506;

protected function lm_507
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_e;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_e :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("|| ("));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !$P$PRE"));
        txt = cref(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* edge */)"));
        txt = Tpl.popBlock(txt);
        txt = lm_507(txt, rest);
      then txt;
  end match;
end lm_507;

public function equationElseWhen
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_auxFunction)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_auxFunction;
      SimCode.SimEqSystem i_elseWhenEq;
      DAE.Exp i_right;
      DAE.ComponentRef i_left;
      list<DAE.ComponentRef> i_conditions;
      Tpl.Text l_elseWhen;
      DAE.Type ret_3;
      DAE.Type ret_2;
      Tpl.Text l_assign;
      Tpl.Text l_helpIf;

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = NONE()),
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        l_helpIf = lm_506(Tpl.emptyTxt, i_conditions);
        ret_2 = Expression.typeof(i_right);
        (l_assign, a_varDecls, a_auxFunction) = whenAssign(Tpl.emptyTxt, i_left, ret_2, i_right, a_context, a_varDecls, a_auxFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if(0"));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           SimCode.SES_WHEN(left = i_left, right = i_right, conditions = i_conditions, elseWhen = SOME(i_elseWhenEq)),
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        l_helpIf = lm_507(Tpl.emptyTxt, i_conditions);
        ret_3 = Expression.typeof(i_right);
        (l_assign, a_varDecls, a_auxFunction) = whenAssign(Tpl.emptyTxt, i_left, ret_3, i_right, a_context, a_varDecls, a_auxFunction);
        (l_elseWhen, a_varDecls, a_auxFunction) = equationElseWhen(Tpl.emptyTxt, i_elseWhenEq, a_context, a_varDecls, a_auxFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if(0"));
        txt = Tpl.writeText(txt, l_helpIf);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_assign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_elseWhen);
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_auxFunction )
      then (txt, a_varDecls, a_auxFunction);
  end match;
end equationElseWhen;

protected function fun_509
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Exp in_a_right;
  input DAE.ComponentRef in_a_left;
  input Tpl.Text in_a_expPart;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_right, in_a_left, in_a_expPart, in_a_preExp, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.Exp a_right;
      DAE.ComponentRef a_left;
      Tpl.Text a_expPart;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text txt_1;
      String ret_1;
      Tpl.Text l_tvar;

    case ( txt,
           "boolean",
           _,
           a_left,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "boolean_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_boolean_array_data_mem("));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           "integer",
           _,
           a_left,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        (l_tvar, a_varDecls) = tempDecl(Tpl.emptyTxt, "integer_array", a_varDecls);
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_integer_array_data_mem("));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           "real",
           _,
           a_left,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_real_array_data_mem("));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           "string",
           _,
           a_left,
           a_expPart,
           a_preExp,
           a_varDecls )
      equation
        txt = Tpl.writeText(txt, a_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("copy_string_array_data_mem("));
        txt = Tpl.writeText(txt, a_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_right,
           a_left,
           _,
           _,
           a_varDecls )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("No runtime support for this sort of array call: "));
        txt_1 = cref(txt_1, a_left);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(" = "));
        ret_1 = ExpressionDump.printExpStr(a_right);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4145, 13), Tpl.textString(txt_1));
      then (txt, a_varDecls);
  end match;
end fun_509;

protected function fun_510
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_left;
  input DAE.Exp in_a_right;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) :=
  match(in_txt, in_a_ty, in_a_left, in_a_right, in_a_context, in_a_varDecls, in_a_auxFunction)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_left;
      DAE.Exp a_right;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_auxFunction;
      Tpl.Text l_exp;
      String str_3;
      Tpl.Text txt_2;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_left,
           a_right,
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, a_right, a_context, l_preExp, a_varDecls, a_auxFunction);
        txt_2 = expTypeFromExpShort(Tpl.emptyTxt, a_right);
        str_3 = Tpl.textString(txt_2);
        (txt, a_varDecls) = fun_509(txt, str_3, a_right, a_left, l_expPart, l_preExp, a_varDecls);
      then (txt, a_varDecls, a_auxFunction);

    case ( txt,
           _,
           a_left,
           a_right,
           a_context,
           a_varDecls,
           a_auxFunction )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_exp, l_preExp, a_varDecls, a_auxFunction) = daeExp(Tpl.emptyTxt, a_right, a_context, l_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, a_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls, a_auxFunction);
  end match;
end fun_510;

public function whenAssign
  input Tpl.Text txt;
  input DAE.ComponentRef a_left;
  input DAE.Type a_ty;
  input DAE.Exp a_right;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_auxFunction) := fun_510(txt, a_ty, a_left, a_right, a_context, a_varDecls, a_auxFunction);
end whenAssign;

protected function lm_512
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_eqnsDecls;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqnsDecls;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqnsDecls, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_eqnsDecls, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_eqnsDecls;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eqn;
      Tpl.Text l_eqnStr;

    case ( txt,
           {},
           _,
           a_eqnsDecls,
           a_varDecls,
           _ )
      then (txt, a_eqnsDecls, a_varDecls);

    case ( txt,
           i_eqn :: rest,
           a_modelNamePrefixStr,
           a_eqnsDecls,
           a_varDecls,
           a_context )
      equation
        (l_eqnStr, a_varDecls, a_eqnsDecls) = equation_(Tpl.emptyTxt, i_eqn, a_context, a_varDecls, a_eqnsDecls, a_modelNamePrefixStr);
        txt = Tpl.writeText(txt, l_eqnStr);
        txt = Tpl.nextIter(txt);
        (txt, a_eqnsDecls, a_varDecls) = lm_512(txt, rest, a_modelNamePrefixStr, a_eqnsDecls, a_varDecls, a_context);
      then (txt, a_eqnsDecls, a_varDecls);
  end match;
end lm_512;

protected function fun_513
  input Tpl.Text in_txt;
  input Integer in_a_index0;
  input Tpl.Text in_a_condition;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_index0, in_a_condition)
    local
      Tpl.Text txt;
      Tpl.Text a_condition;

    case ( txt,
           0,
           a_condition )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if("));
        txt = Tpl.writeText(txt, a_condition);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_condition )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("else if("));
        txt = Tpl.writeText(txt, a_condition);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_513;

protected function lm_514
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_eqnsDecls;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqnsDecls;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_eqnsDecls, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_eqnsDecls, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_eqnsDecls;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      Integer x_index0;
      list<SimCode.SimEqSystem> i_eqns;
      DAE.Exp i_e;
      Tpl.Text l_conditionline;
      Tpl.Text l_ifequations;
      Tpl.Text l_condition;

    case ( txt,
           {},
           _,
           a_eqnsDecls,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_eqnsDecls, a_varDecls, a_preExp);

    case ( txt,
           (i_e, i_eqns) :: rest,
           a_modelNamePrefixStr,
           a_eqnsDecls,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        (l_condition, a_preExp, a_varDecls, a_eqnsDecls) = daeExp(Tpl.emptyTxt, i_e, a_context, a_preExp, a_varDecls, a_eqnsDecls);
        l_ifequations = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_ifequations, a_eqnsDecls, a_varDecls) = lm_512(l_ifequations, i_eqns, a_modelNamePrefixStr, a_eqnsDecls, a_varDecls, a_context);
        l_ifequations = Tpl.popIter(l_ifequations);
        l_conditionline = fun_513(Tpl.emptyTxt, x_index0, l_condition);
        txt = Tpl.writeText(txt, l_conditionline);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_ifequations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        (txt, a_eqnsDecls, a_varDecls, a_preExp) = lm_514(txt, rest, a_modelNamePrefixStr, a_eqnsDecls, a_varDecls, a_preExp, a_context);
      then (txt, a_eqnsDecls, a_varDecls, a_preExp);
  end match;
end lm_514;

protected function lm_515
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_modelNamePrefixStr;
  input Tpl.Text in_a_eqnsDecls;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_eqnsDecls;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_eqnsDecls, out_a_varDecls) :=
  match(in_txt, in_items, in_a_modelNamePrefixStr, in_a_eqnsDecls, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_modelNamePrefixStr;
      Tpl.Text a_eqnsDecls;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eqn;
      Tpl.Text l_eqnStr;

    case ( txt,
           {},
           _,
           a_eqnsDecls,
           a_varDecls,
           _ )
      then (txt, a_eqnsDecls, a_varDecls);

    case ( txt,
           i_eqn :: rest,
           a_modelNamePrefixStr,
           a_eqnsDecls,
           a_varDecls,
           a_context )
      equation
        (l_eqnStr, a_varDecls, a_eqnsDecls) = equation_(Tpl.emptyTxt, i_eqn, a_context, a_varDecls, a_eqnsDecls, a_modelNamePrefixStr);
        txt = Tpl.writeText(txt, l_eqnStr);
        txt = Tpl.nextIter(txt);
        (txt, a_eqnsDecls, a_varDecls) = lm_515(txt, rest, a_modelNamePrefixStr, a_eqnsDecls, a_varDecls, a_context);
      then (txt, a_eqnsDecls, a_varDecls);
  end match;
end lm_515;

public function equationIfEquationAssign
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_eqnsDecls;
  input String in_a_modelNamePrefixStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_eqnsDecls;
algorithm
  (out_txt, out_a_varDecls, out_a_eqnsDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_varDecls, in_a_eqnsDecls, in_a_modelNamePrefixStr)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_eqnsDecls;
      String a_modelNamePrefixStr;
      list<SimCode.SimEqSystem> i_elsebranch;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> i_ifbranches;
      Tpl.Text l_elseequations;
      Tpl.Text l_IfEquation;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_IFEQUATION(ifbranches = i_ifbranches, elsebranch = i_elsebranch),
           a_context,
           a_varDecls,
           a_eqnsDecls,
           a_modelNamePrefixStr )
      equation
        l_preExp = Tpl.emptyTxt;
        l_IfEquation = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_IfEquation, a_eqnsDecls, a_varDecls, l_preExp) = lm_514(l_IfEquation, i_ifbranches, a_modelNamePrefixStr, a_eqnsDecls, a_varDecls, l_preExp, a_context);
        l_IfEquation = Tpl.popIter(l_IfEquation);
        l_elseequations = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_elseequations, a_eqnsDecls, a_varDecls) = lm_515(l_elseequations, i_elsebranch, a_modelNamePrefixStr, a_eqnsDecls, a_varDecls, a_context);
        l_elseequations = Tpl.popIter(l_elseequations);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_IfEquation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "else\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_elseequations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then (txt, a_varDecls, a_eqnsDecls);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_eqnsDecls,
           _ )
      then (txt, a_varDecls, a_eqnsDecls);
  end match;
end equationIfEquationAssign;

protected function fun_517
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Exp in_a_literal;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_literal)
    local
      Tpl.Text txt;
      DAE.Exp a_literal;
      String ret_1;
      String ret_0;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_literal )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        ret_0 = ExpressionDump.printExpStr(a_literal);
        ret_1 = Util.escapeModelicaStringToCString(ret_0);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_517;

protected function lm_518
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_preLit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preLit;
algorithm
  (out_txt, out_a_preLit) :=
  match(in_txt, in_items, in_a_preLit)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_preLit;
      Integer x_i0;
      DAE.Exp i_literal;
      Boolean ret_0;

    case ( txt,
           {},
           a_preLit )
      then (txt, a_preLit);

    case ( txt,
           i_literal :: rest,
           a_preLit )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        ret_0 = Config.typeinfo();
        txt = fun_517(txt, ret_0, i_literal);
        (txt, a_preLit) = literalExpConst(txt, i_literal, x_i0, a_preLit);
        txt = Tpl.nextIter(txt);
        (txt, a_preLit) = lm_518(txt, rest, a_preLit);
      then (txt, a_preLit);
  end match;
end lm_518;

public function simulationLiteralsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<DAE.Exp> a_literals;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_res;
  Tpl.Text l_preLit;
algorithm
  l_preLit := Tpl.emptyTxt;
  l_res := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_res, l_preLit) := lm_518(l_res, a_literals, l_preLit);
  l_res := Tpl.popIter(l_res);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#ifdef __cplusplus\n",
                                   "extern \"C\" {\n",
                                   "#endif\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.writeText(out_txt, l_preLit);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_res);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif"
                                   }, false));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end simulationLiteralsFile;

public function simulationFunctionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input Tpl.Text a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_functions.h\"\n",
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n",
                                       "\n",
                                       "#include \""
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_literals.h\"\n",
                                       "#include \""
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_includes.h\"\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, a_staticPrototypes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := functionBodies(out_txt, a_functions, true);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif"
                                   }, false));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_a_staticPrototypes := a_staticPrototypes;
end simulationFunctionsFile;

public function simulationParModelicaKernelsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickResetIndex(0, 20);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#include <ParModelica/explicit/openclrt/OCLRuntimeUtil.cl>\n",
                                   "\n",
                                   "// ParModelica Parallel Function headers.\n"
                               }, true));
  out_txt := functionHeadersParModelica(out_txt, a_filePrefix, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "// Headers finish here.\n",
                                       "\n"
                                   }, true));
  out_txt := functionBodiesParModelica(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "\n"
                                   }, true));
end simulationParModelicaKernelsFile;

protected function fun_522
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn) )
      equation
        txt = functionBodyParModelica(txt, i_fn, true);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_522;

public function functionsParModelicaKernelsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickResetIndex(0, 20);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "#include <ParModelica/explicit/openclrt/OCLRuntimeUtil.cl>\n",
                                   "\n",
                                   "// ParModelica Parallel Function headers.\n"
                               }, true));
  out_txt := functionHeadersParModelica(out_txt, a_filePrefix, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "// Headers finish here.\n",
                                       "\n"
                                   }, true));
  out_txt := fun_522(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodiesParModelica(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "\n"
                                   }, true));
end functionsParModelicaKernelsFile;

protected function lm_524
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclaration(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_524(txt, rest);
      then txt;
  end match;
end lm_524;

public function recordsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.RecordDeclaration> a_recordDecls;

  output Tpl.Text out_txt;
protected
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("/* Additional record code for "));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" generated by the OpenModelica Compiler "));
  ret_0 := Settings.getVersionNr();
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ". */\n",
                                       "#include \"meta/meta_modelica.h\"\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                        "\n",
                                                                        "\n"
                                                                    }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_524(out_txt, a_recordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end recordsFile;

protected function lm_526
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclarationHeader(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_526(txt, rest);
      then txt;
  end match;
end lm_526;

public function simulationFunctionsHeaderFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;
  input list<SimCode.RecordDeclaration> a_recordDecls;

  output Tpl.Text out_txt;
protected
  String ret_2;
  String ret_1;
  Tpl.Text l_staticPrototypes;
algorithm
  l_staticPrototypes := Tpl.emptyTxt;
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_2 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_2);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__H\n"));
  out_txt := commonHeader(out_txt, a_filePrefix);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#include \"simulation/simulation_runtime.h\"\n",
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                        "\n",
                                                                        "\n"
                                                                    }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_526(out_txt, a_recordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  (out_txt, l_staticPrototypes) := functionHeaders(out_txt, a_functions, true, l_staticPrototypes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_staticPrototypes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "#endif"
                                   }, false));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end simulationFunctionsHeaderFile;

public function functionHeadersParModelica
  input Tpl.Text txt;
  input String a_filePrefix;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_0 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "//#include \"helper.cl\"\n",
                                       "\n"
                                   }, true));
  out_txt := parallelFunctionHeadersImpl(out_txt, a_functions);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end functionHeadersParModelica;

protected function fun_529
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_529;

protected function lm_530
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_530(txt, rest);
      then txt;
  end match;
end lm_530;

protected function fun_531
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_531;

protected function fun_532
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_532;

protected function fun_533
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("OMOCLRuntime.lib OpenCL.lib"));
      then txt;
  end match;
end fun_533;

protected function fun_534
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "dassljac" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_JACOBIAN "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_534;

protected function fun_535
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(method = i_s_method)) )
      equation
        txt = fun_534(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_535;

protected function fun_536
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/openmp"));
      then txt;
  end match;
end fun_536;

protected function fun_537
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Boolean ret_7;
      Tpl.Text l_extraCflags;
      Boolean ret_5;
      Tpl.Text l_ParModelicaExpLibs;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, omhome = i_makefileParams_omhome), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_529(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_530(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_531(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_532(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        ret_5 = Config.acceptParModelicaGrammar();
        l_ParModelicaExpLibs = fun_533(Tpl.emptyTxt, ret_5);
        l_extraCflags = fun_535(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O0 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=\n",
                                    "MODELICAUSERCFLAGS=\n",
                                    "CC=cl\n",
                                    "CXX=cl\n",
                                    "EXEEXT=.exe\n",
                                    "DLLEXT=.dll\n",
                                    "\n",
                                    "# /Od - Optimization disabled\n",
                                    "# /EHa enable C++ EH (w/ SEH exceptions)\n",
                                    "# /fp:except - consider floating-point exceptions when generating code\n",
                                    "# /arch:SSE2 - enable use of instructions available with SSE2 enabled CPUs\n",
                                    "# /I - Include Directories\n",
                                    "# /DNOMINMAX - Define NOMINMAX (does what it says)\n",
                                    "# /TP - Use C++ Compiler\n",
                                    "CFLAGS=/Od /ZI /EHa /fp:except /I\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/c\" /I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/msvc/\" /I. /DNOMINMAX /TP /DNO_INTERACTIVE_DEPENDENCY /DOPENMODELICA_XML_FROM_FILE_AT_RUNTIME "));
        ret_7 = Flags.isSet(Flags.HPCOM);
        txt = fun_536(txt, ret_7);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "# /ZI enable Edit and Continue debug info\n",
                                    "CDFLAGS = /ZI\n",
                                    "\n",
                                    "# /MD - link with MSVCRT.LIB\n",
                                    "# /link - [linker options and libraries]\n",
                                    "# /LIBPATH: - Directories where libs can be found\n",
                                    "LDFLAGS=/MD /link /NODEFAULTLIB:libcmt /STACK:0x2000000 /pdb:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".pdb\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/msvc/\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/msvc/release/\" "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " f2c.lib initialization.lib libexpat.lib math-support.lib meta.lib results.lib simulation.lib solver.lib sundials_kinsol.lib sundials_nvecserial.lib util.lib lapack_win32_MT.lib lis.lib  gc-lib.lib user32.lib pthreadVC2.lib\n",
                                    "\n",
                                    "# /MDd link with MSVCRTD.LIB debug lib\n",
                                    "# lib names should not be appended with a d just switch to lib/omc/msvc/debug\n",
                                    "\n",
                                    "\n",
                                    "FILEPREFIX="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MAINFILE=$(FILEPREFIX).c\n",
                                    "MAINOBJ=$(FILEPREFIX).obj\n",
                                    "CFILES="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c \\\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_01exo.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_02nls.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_03lsy.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_04set.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_05evt.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_06inz.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_07dly.c \\\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_08bnd.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_09alg.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_10asr.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_11mix.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_12jac.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_13opt.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_14lnz.c\n",
                                    "OFILES=$(CFILES:.c=.obj)\n",
                                    "GENERATEDFILES=$(MAINFILE) $(FILEPREFIX)_functions.h $(FILEPREFIX).makefile $(CFILES)\n",
                                    "\n",
                                    ".PHONY: $(FILEPREFIX)$(EXEEXT)\n",
                                    "\n",
                                    "# This is to make sure that "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_*.c are always compiled.\n",
                                    ".PHONY: $(CFILES)\n",
                                    "\n",
                                    "$(FILEPREFIX)$(EXEEXT): $(MAINFILE) $(FILEPREFIX)_functions.h $(CFILES)\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(CXX) /Fe$(FILEPREFIX)$(EXEEXT) $(MAINFILE) $(CFILES) $(CFLAGS) $(LDFLAGS)\n",
                                    "\n",
                                    "clean:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rm -f *.obj *.lib *.exp *.c *.h *.xml *.libs *.log *.makefile *.pdb *.idb *.exe"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_537;

protected function fun_538
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_538;

protected function lm_539
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_539(txt, rest);
      then txt;
  end match;
end lm_539;

protected function fun_540
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_540;

protected function fun_541
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_541;

protected function fun_542
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lOMOCLRuntime -lOpenCL"));
      then txt;
  end match;
end fun_542;

protected function fun_543
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lom_pm_autort -L. -ltbb"));
      then txt;
  end match;
end fun_543;

protected function fun_544
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "dassljac" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_JACOBIAN "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_544;

protected function fun_545
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(method = i_s_method)) )
      equation
        txt = fun_544(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_545;

protected function fun_546
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_ccompiler;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_makefileParams_ccompiler)
    local
      Tpl.Text txt;
      String a_makefileParams_ccompiler;

    case ( txt,
           false,
           a_makefileParams_ccompiler )
      equation
        txt = Tpl.writeStr(txt, a_makefileParams_ccompiler);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("g++"));
      then txt;
  end match;
end fun_546;

protected function fun_547
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-O0 -g"));
      then txt;
  end match;
end fun_547;

protected function fun_548
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_548;

protected function fun_549
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_omhome;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_makefileParams_omhome)
    local
      Tpl.Text txt;
      String a_makefileParams_omhome;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_makefileParams_omhome )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("OMC_EMCC_PRE_JS="));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/emcc/pre.js"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_549;

protected function lm_550
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_550(txt, rest);
      then txt;
  end match;
end lm_550;

protected function fun_551
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -DOMC_EMCC"));
      then txt;
  end match;
end fun_551;

protected function fun_552
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("--stack,0x2000000,"));
      then txt;
  end match;
end fun_552;

protected function fun_553
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_runtimelibs;
  input String in_a_makefileParams_ldflags;
  input Tpl.Text in_a_ParModelicaAutoLibs;
  input Tpl.Text in_a_ParModelicaExpLibs;
  input String in_a_makefileParams_platform;
  input String in_a_makefileParams_omhome;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_makefileParams_runtimelibs, in_a_makefileParams_ldflags, in_a_ParModelicaAutoLibs, in_a_ParModelicaExpLibs, in_a_makefileParams_platform, in_a_makefileParams_omhome)
    local
      Tpl.Text txt;
      String a_makefileParams_runtimelibs;
      String a_makefileParams_ldflags;
      Tpl.Text a_ParModelicaAutoLibs;
      Tpl.Text a_ParModelicaExpLibs;
      String a_makefileParams_platform;
      String a_makefileParams_omhome;
      Boolean ret_0;

    case ( txt,
           false,
           a_makefileParams_runtimelibs,
           a_makefileParams_ldflags,
           a_ParModelicaAutoLibs,
           a_ParModelicaExpLibs,
           a_makefileParams_platform,
           a_makefileParams_omhome )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -L\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib\" -Wl,"));
        ret_0 = stringEq(a_makefileParams_platform, "win32");
        txt = fun_552(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-rpath,\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -Wl,-rpath,\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib\" "));
        txt = Tpl.writeText(txt, a_ParModelicaExpLibs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_ParModelicaAutoLibs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_makefileParams_ldflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_makefileParams_runtimelibs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           a_makefileParams_omhome )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\'"));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/emcc\' -lblas -llapack -lexpat -lSimulationRuntimeC -lf2c -s TOTAL_MEMORY=805306368 -s OUTLINING_LIMIT=20000 --pre-js $(OMC_EMCC_PRE_JS)"));
      then txt;
  end match;
end fun_553;

protected function fun_554
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rm -f "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
      then txt;
  end match;
end fun_554;

protected function fun_555
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ln -s "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_node.js "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
      then txt;
  end match;
end fun_555;

protected function fun_556
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("chmod +x "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_node.js"));
      then txt;
  end match;
end fun_556;

protected function fun_557
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      String i_makefileParams_runtimelibs;
      String i_makefileParams_ldflags;
      String i_makefileParams_platform;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      String i_makefileParams_cflags;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Boolean ret_24;
      String ret_23;
      Boolean ret_22;
      String ret_21;
      Boolean ret_20;
      String ret_19;
      Boolean ret_18;
      String ret_17;
      Boolean ret_16;
      String ret_15;
      Boolean ret_14;
      String ret_13;
      Boolean ret_12;
      Boolean ret_11;
      Boolean ret_10;
      Boolean ret_9;
      Tpl.Text l_extraCflags;
      Boolean ret_7;
      Tpl.Text l_ParModelicaAutoLibs;
      Boolean ret_5;
      Tpl.Text l_ParModelicaExpLibs;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, cflags = i_makefileParams_cflags, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes, platform = i_makefileParams_platform, ldflags = i_makefileParams_ldflags, runtimelibs = i_makefileParams_runtimelibs), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix) )
      equation
        l_dirExtra = fun_538(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_539(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_540(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_541(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        ret_5 = Config.acceptParModelicaGrammar();
        l_ParModelicaExpLibs = fun_542(Tpl.emptyTxt, ret_5);
        ret_7 = Flags.isSet(Flags.PARMODAUTO);
        l_ParModelicaAutoLibs = fun_543(Tpl.emptyTxt, ret_7);
        l_extraCflags = fun_545(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "CC="
                                }, false));
        ret_9 = Config.acceptParModelicaGrammar();
        txt = fun_546(txt, ret_9, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DEBUG_FLAGS="));
        ret_10 = Config.acceptMetaModelicaGrammar();
        ret_11 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        ret_12 = boolOr(ret_10, ret_11);
        txt = fun_547(txt, ret_12);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) $(DEBUG_FLAGS) "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_548(txt, i_sopt);
        txt = Tpl.softNewLine(txt);
        ret_13 = Config.simCodeTarget();
        ret_14 = stringEq(ret_13, "JavaScript");
        txt = fun_549(txt, ret_14, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CPPFLAGS="));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_550(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/c\" -I. -DOPENMODELICA_XML_FROM_FILE_AT_RUNTIME"));
        ret_15 = Config.simCodeTarget();
        ret_16 = stringEq(ret_15, "JavaScript");
        txt = fun_551(txt, ret_16);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS="));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        ret_17 = Config.simCodeTarget();
        ret_18 = stringEq(ret_17, "JavaScript");
        txt = fun_553(txt, ret_18, i_makefileParams_runtimelibs, i_makefileParams_ldflags, l_ParModelicaAutoLibs, l_ParModelicaExpLibs, i_makefileParams_platform, i_makefileParams_omhome);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MAINFILE="));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "MAINOBJ="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".o\n",
                                    "CFILES="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c \\\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_01exo.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_02nls.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_03lsy.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_04set.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_05evt.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_06inz.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_07dly.c \\\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_08bnd.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_09alg.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_10asr.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_11mix.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_12jac.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_13opt.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_14lnz.c\n",
                                    "OFILES=$(CFILES:.c=.o)\n",
                                    "GENERATEDFILES=$(MAINFILE) "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".makefile "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_literals.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h $(CFILES)\n",
                                    "\n",
                                    ".PHONY: omc_main_target clean bundle\n",
                                    "\n",
                                    "# This is to make sure that "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_*.c are always compiled.\n",
                                    ".PHONY: $(CFILES)\n",
                                    "\n",
                                    "omc_main_target: $(MAINOBJ) "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_literals.h $(OFILES)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CC) -I. -o "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(EXEEXT) $(MAINOBJ) $(OFILES) $(CPPFLAGS) "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" $(CFLAGS) $(LDFLAGS)\n"));
        ret_19 = Config.simCodeTarget();
        ret_20 = stringEq(ret_19, "JavaScript");
        txt = fun_554(txt, ret_20, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        ret_21 = Config.simCodeTarget();
        ret_22 = stringEq(ret_21, "JavaScript");
        txt = fun_555(txt, ret_22, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        ret_23 = Config.simCodeTarget();
        ret_24 = stringEq(ret_23, "JavaScript");
        txt = fun_556(txt, ret_24, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("clean:\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("@rm -f "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_records.o $(MAINOBJ)\n",
                                    "\n",
                                    "bundle:\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("@tar -cvf "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_Files.tar $(GENERATEDFILES)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_557;

public function simulationMakefile
  input Tpl.Text in_txt;
  input String in_a_target;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_target, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      String i_target;
      Tpl.Text txt_0;

    case ( txt,
           "msvc",
           a_simCode )
      equation
        txt = fun_537(txt, a_simCode);
      then txt;

    case ( txt,
           "gcc",
           a_simCode )
      equation
        txt = fun_557(txt, a_simCode);
      then txt;

    case ( txt,
           i_target,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Target "));
        txt_0 = Tpl.writeStr(txt_0, i_target);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING(" is not handled!"));
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4467, 9), Tpl.textString(txt_0));
      then txt;
  end match;
end simulationMakefile;

public function xsdateTime
  input Tpl.Text in_txt;
  input Util.DateTime in_a_dt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dt)
    local
      Tpl.Text txt;
      Integer i_sec;
      Integer i_min;
      Integer i_hour;
      Integer i_mday;
      Integer i_mon;
      Integer i_year;
      String ret_4;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           Util.DATETIME(year = i_year, mon = i_mon, mday = i_mday, hour = i_hour, min = i_min, sec = i_sec) )
      equation
        txt = Tpl.writeStr(txt, intString(i_year));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_0 = SimCodeUtil.twodigit(i_mon);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_1 = SimCodeUtil.twodigit(i_mday);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("T"));
        ret_2 = SimCodeUtil.twodigit(i_hour);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_3 = SimCodeUtil.twodigit(i_min);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_4 = SimCodeUtil.twodigit(i_sec);
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Z"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end xsdateTime;

public function simulationInitFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.ModelInfo i_modelInfo;
      String i_s_variableFilter;
      String i_s_outputFormat;
      String i_s_method;
      Real i_s_tolerance;
      Real i_s_stepSize;
      Real i_s_stopTime;
      Real i_s_startTime;
      Integer i_vi_numBoolParams;
      Integer i_vi_numBoolAliasVars;
      Integer i_vi_numBoolAlgVars;
      Integer i_vi_numStringParamVars;
      Integer i_vi_numStringAliasVars;
      Integer i_vi_numStringAlgVars;
      Integer i_vi_numIntParams;
      Integer i_vi_numIntAliasVars;
      Integer i_vi_numIntAlgVars;
      Integer i_vi_numParams;
      Integer i_vi_numAlgAliasVars;
      Integer i_vi_numOptimizeFinalConstraints;
      Integer i_vi_numOptimizeConstraints;
      Integer i_vi_numDiscreteReal;
      Integer i_vi_numAlgVars;
      Integer i_vi_numStateVars;
      list<SimCode.Function> i_functions;
      Integer i_vi_numExternalObjects;
      Integer i_vi_numInitialResiduals;
      Integer i_vi_numOutVars;
      Integer i_vi_numInVars;
      Integer i_vi_numTimeEvents;
      Integer i_vi_numZeroCrossings;
      String i_modelInfo_description;
      String i_makefileParams_omhome;
      Absyn.Path i_modelInfo_name;
      Integer ret_10;
      Integer ret_9;
      Integer ret_8;
      Integer ret_7;
      Util.DateTime ret_6;
      String ret_5;
      String ret_4;
      String ret_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(functions = i_functions, varInfo = SimCode.VARINFO(numZeroCrossings = i_vi_numZeroCrossings, numTimeEvents = i_vi_numTimeEvents, numInVars = i_vi_numInVars, numOutVars = i_vi_numOutVars, numInitialResiduals = i_vi_numInitialResiduals, numExternalObjects = i_vi_numExternalObjects, numStateVars = i_vi_numStateVars, numAlgVars = i_vi_numAlgVars, numDiscreteReal = i_vi_numDiscreteReal, numOptimizeConstraints = i_vi_numOptimizeConstraints, numOptimizeFinalConstraints = i_vi_numOptimizeFinalConstraints, numAlgAliasVars = i_vi_numAlgAliasVars, numParams = i_vi_numParams, numIntAlgVars = i_vi_numIntAlgVars, numIntAliasVars = i_vi_numIntAliasVars, numIntParams = i_vi_numIntParams, numStringAlgVars = i_vi_numStringAlgVars, numStringAliasVars = i_vi_numStringAliasVars, numStringParamVars = i_vi_numStringParamVars, numBoolAlgVars = i_vi_numBoolAlgVars, numBoolAliasVars = i_vi_numBoolAliasVars, numBoolParams = i_vi_numBoolParams), vars = SimCodeVar.SIMVARS(stateVars = _), name = i_modelInfo_name, description = i_modelInfo_description)), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_s_startTime, stopTime = i_s_stopTime, stepSize = i_s_stepSize, tolerance = i_s_tolerance, method = i_s_method, outputFormat = i_s_outputFormat, variableFilter = i_s_variableFilter)), makefileParams = SimCode.MAKEFILE_PARAMS(omhome = i_makefileParams_omhome)),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<?xml version = \"1.0\" encoding=\"UTF-8\"?>\n",
                                    "\n",
                                    "<!-- description of the model interface using an extention of the FMI standard -->\n",
                                    "<fmiModelDescription\n",
                                    "  fmiVersion                          = \"1.0\"\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelName                           = \""));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_modelInfo_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelIdentifier                     = \""
                                }, false));
        txt_2 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_modelInfo_name);
        ret_3 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_2));
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "OPENMODELICAHOME                    = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "guid                                = \"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "\n",
                                    "description                         = \""
                                }, false));
        ret_4 = Util.escapeModelicaStringToXmlString(i_modelInfo_description);
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationTool                      = \"OpenModelica Compiler "
                                }, false));
        ret_5 = Settings.getVersionNr();
        txt = Tpl.writeStr(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationDateAndTime               = \""
                                }, false));
        ret_6 = Util.getCurrentDateTime();
        txt = xsdateTime(txt, ret_6);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "\n",
                                    "variableNamingConvention            = \"structured\"\n",
                                    "\n",
                                    "numberOfEventIndicators             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfEventIndicators             = \"NG:       number of zero crossings,                           FMI\"\n",
                                    "numberOfTimeEvents                  = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numTimeEvents));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfTimeEvents                  = \"NG_SAM:   number of zero crossings that are samples,          OMC\"\n",
                                    "\n",
                                    "numberOfInputVariables              = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfInputVariables              = \"NI:       number of inputvar on topmodel,                     OMC\"\n",
                                    "numberOfOutputVariables             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfOutputVariables             = \"NO:       number of outputvar on topmodel,                    OMC\"\n",
                                    "\n",
                                    "numberOfResidualsForInitialization  = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numInitialResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfResidualsForInitialization  = \"NR:       number of residuals for initialialization function, OMC\"\n",
                                    "numberOfExternalObjects             = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfExternalObjects             = \"NEXT:     number of external objects,                         OMC\"\n",
                                    "numberOfFunctions                   = \""
                                }, false));
        ret_7 = listLength(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfFunctions                   = \"NFUNC:    number of functions used by the simulation,         OMC\"\n",
                                    "\n",
                                    "numberOfContinuousStates            = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfContinuousStates            = \"NX:       number of states,                                   FMI\"\n",
                                    "numberOfRealAlgebraicVariables      = \""
                                }, false));
        ret_8 = intAdd(i_vi_numOptimizeConstraints, i_vi_numOptimizeFinalConstraints);
        ret_9 = intAdd(i_vi_numDiscreteReal, ret_8);
        ret_10 = intAdd(i_vi_numAlgVars, ret_9);
        txt = Tpl.writeStr(txt, intString(ret_10));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealAlgebraicVariables      = \"NY:       number of real variables,                           OMC\"\n",
                                    "numberOfRealAlgebraicAliasVariables = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numAlgAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealAlgebraicAliasVariables = \"NA:       number of alias variables,                          OMC\"\n",
                                    "numberOfRealParameters              = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfRealParameters              = \"NP:       number of parameters,                               OMC\"\n",
                                    "\n",
                                    "numberOfIntegerAlgebraicVariables   = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerAlgebraicVariables   = \"NYINT:    number of alg. int variables,                       OMC\"\n",
                                    "numberOfIntegerAliasVariables       = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerAliasVariables       = \"NAINT:    number of alias int variables,                      OMC\"\n",
                                    "numberOfIntegerParameters           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numIntParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfIntegerParameters           = \"NPINT:    number of int parameters,                           OMC\"\n",
                                    "\n",
                                    "numberOfStringAlgebraicVariables    = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringAlgebraicVariables    = \"NYSTR:    number of alg. string variables,                    OMC\"\n",
                                    "numberOfStringAliasVariables        = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringAliasVariables        = \"NASTR:    number of alias string variables,                   OMC\"\n",
                                    "numberOfStringParameters            = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfStringParameters            = \"NPSTR:    number of string parameters,                        OMC\"\n",
                                    "\n",
                                    "numberOfBooleanAlgebraicVariables   = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanAlgebraicVariables   = \"NYBOOL:   number of alg. bool variables,                      OMC\"\n",
                                    "numberOfBooleanAliasVariables       = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolAliasVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanAliasVariables       = \"NABOOL:   number of alias bool variables,                     OMC\"\n",
                                    "numberOfBooleanParameters           = \""
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_vi_numBoolParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"  cmt_numberOfBooleanParameters           = \"NPBOOL:   number of bool parameters,                          OMC\" >\n",
                                    "\n",
                                    "\n",
                                    "<!-- startTime, stopTime, tolerance are FMI specific, all others are OMC specific -->\n",
                                    "<DefaultExperiment\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("startTime      = \""));
        txt = Tpl.writeStr(txt, realString(i_s_startTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "stopTime       = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "stepSize       = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_stepSize));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "tolerance      = \""
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_s_tolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "solver         = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_method);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "outputFormat   = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "variableFilter = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_s_variableFilter);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" />\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<!-- variables in the model -->\n"));
        txt = ModelVariables(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</fmiModelDescription>\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationInitFile;

protected function fun_561
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define __OPENMODELICA__METAMODELICA"));
      then txt;
  end match;
end fun_561;

protected function fun_562
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"meta/meta_modelica.h\""));
      then txt;
  end match;
end fun_562;

protected function fun_563
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_filePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_filePrefix)
    local
      Tpl.Text txt;
      String a_filePrefix;
      Integer ret_0;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_filePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include <ParModelica/explicit/openclrt/omc_ocl_interface.h>\n",
                                    "/* the OpenCL Kernels file name needed in libOMOCLRuntime.a */\n",
                                    "const char* omc_ocl_kernels_source = \""
                                }, false));
        txt = Tpl.writeStr(txt, a_filePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_kernels.cl\";\n",
                                    "/* the OpenCL program. Made global to avoid repeated builds */\n",
                                    "extern cl_program omc_ocl_program;\n",
                                    "/* The default OpenCL device. If not set (=0) show the selection option.*/\n",
                                    "unsigned int default_ocl_device = "
                                }, false));
        ret_0 = Config.getDefaultOpenCLDevice();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_563;

public function commonHeader
  input Tpl.Text txt;
  input String a_filePrefix;

  output Tpl.Text out_txt;
protected
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  ret_0 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_561(txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  ret_1 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_562(out_txt, ret_1);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#include \"util/modelica.h\"\n",
                                       "#include <stdio.h>\n",
                                       "#include <stdlib.h>\n",
                                       "#include <errno.h>\n"
                                   }, true));
  ret_2 := Config.acceptParModelicaGrammar();
  out_txt := fun_563(out_txt, ret_2, a_filePrefix);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end commonHeader;

protected function lm_565
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_preLit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preLit;
algorithm
  (out_txt, out_a_preLit) :=
  match(in_txt, in_items, in_a_preLit)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_preLit;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {},
           a_preLit )
      then (txt, a_preLit);

    case ( txt,
           i_literal :: rest,
           a_preLit )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_preLit) = literalExpConst(txt, i_literal, x_i0, a_preLit);
        txt = Tpl.nextIter(txt);
        (txt, a_preLit) = lm_565(txt, rest, a_preLit);
      then (txt, a_preLit);
  end match;
end lm_565;

protected function fun_566
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;

    case ( txt,
           NONE() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void (*omc_assert)(threadData_t*,FILE_INFO info,const char *msg,...) __attribute__ ((noreturn)) = omc_assert_function;\n",
                                    "void (*omc_assert_warning)(FILE_INFO info,const char *msg,...) = omc_assert_warning_function;\n",
                                    "void (*omc_terminate)(FILE_INFO info,const char *msg,...) = omc_terminate_function;\n",
                                    "void (*omc_throw)(threadData_t*) __attribute__ ((noreturn)) = omc_throw_function;"
                                }, false));
      then txt;
  end match;
end fun_566;

protected function fun_567
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_mainFunction)
    local
      Tpl.Text txt;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn) )
      equation
        txt = functionBody(txt, i_fn, true, false);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_567;

public function functionsFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;
  input Tpl.Text a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
protected
  Tpl.Text l_literalsRes;
  Tpl.Text l_preLit;
algorithm
  l_preLit := Tpl.emptyTxt;
  l_literalsRes := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_literalsRes, l_preLit) := lm_565(l_literalsRes, a_literals, l_preLit);
  l_literalsRes := Tpl.popIter(l_literalsRes);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#include \""));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(".h\"\n"));
  out_txt := Tpl.writeText(out_txt, l_preLit);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeText(out_txt, l_literalsRes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#include \"util/modelica.h\"\n",
                                       "\n",
                                       "#include \""
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_filePrefix);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "_includes.h\"\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.writeText(out_txt, a_staticPrototypes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := fun_566(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := fun_567(out_txt, a_mainFunction);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := functionBodies(out_txt, a_functions, false);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_a_staticPrototypes := a_staticPrototypes;
end functionsFile;

protected function lm_569
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_rd :: rest )
      equation
        txt = recordDeclarationHeader(txt, i_rd);
        txt = Tpl.nextIter(txt);
        txt = lm_569(txt, rest);
      then txt;
  end match;
end lm_569;

protected function fun_570
  input Tpl.Text in_txt;
  input Option<SimCode.Function> in_a_mainFunction;
  input Tpl.Text in_a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  (out_txt, out_a_staticPrototypes) :=
  match(in_txt, in_a_mainFunction, in_a_staticPrototypes)
    local
      Tpl.Text txt;
      Tpl.Text a_staticPrototypes;
      SimCode.Function i_fn;

    case ( txt,
           SOME(i_fn),
           a_staticPrototypes )
      equation
        (txt, a_staticPrototypes) = functionHeader(txt, i_fn, true, false, a_staticPrototypes);
      then (txt, a_staticPrototypes);

    case ( txt,
           _,
           a_staticPrototypes )
      then (txt, a_staticPrototypes);
  end match;
end fun_570;

public function functionsHeaderFile
  input Tpl.Text txt;
  input String a_filePrefix;
  input Option<SimCode.Function> a_mainFunction;
  input list<SimCode.Function> a_functions;
  input list<SimCode.RecordDeclaration> a_extraRecordDecls;
  input Tpl.Text a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
protected
  String ret_1;
  String ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#ifndef "));
  ret_0 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "__H\n",
                                       "#define "
                                   }, false));
  ret_1 := System.stringReplace(a_filePrefix, ".", "_");
  out_txt := Tpl.writeStr(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__H\n"));
  out_txt := commonHeader(out_txt, a_filePrefix);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "#ifdef __cplusplus\n",
                                       "extern \"C\" {\n",
                                       "#endif\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_569(out_txt, a_extraRecordDecls);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  (out_txt, out_a_staticPrototypes) := fun_570(out_txt, a_mainFunction, a_staticPrototypes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  (out_txt, out_a_staticPrototypes) := functionHeaders(out_txt, a_functions, false, out_a_staticPrototypes);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "#ifdef __cplusplus\n",
                                       "}\n",
                                       "#endif\n",
                                       "#endif"
                                   }, false));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end functionsHeaderFile;

protected function lm_572
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_572(txt, rest);
      then txt;
  end match;
end lm_572;

protected function fun_573
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lOMOCLRuntime -lOpenCL"));
      then txt;
  end match;
end fun_573;

protected function fun_574
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_ccompiler;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_makefileParams_ccompiler)
    local
      Tpl.Text txt;
      String a_makefileParams_ccompiler;

    case ( txt,
           false,
           a_makefileParams_ccompiler )
      equation
        txt = Tpl.writeStr(txt, a_makefileParams_ccompiler);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("g++"));
      then txt;
  end match;
end fun_574;

protected function fun_575
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -g"));
      then txt;
  end match;
end fun_575;

protected function lm_576
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_576(txt, rest);
      then txt;
  end match;
end lm_576;

public function functionsMakefile
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_fnCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fnCode)
    local
      Tpl.Text txt;
      String i_name;
      String i_makefileParams_runtimelibs;
      String i_makefileParams_ldflags;
      String i_makefileParams_cflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      list<String> i_makefileParams_libs;
      Boolean ret_6;
      Boolean ret_5;
      Boolean ret_4;
      Boolean ret_3;
      Boolean ret_2;
      Tpl.Text l_ParModelicaExpLibs;
      Tpl.Text l_libsStr;

    case ( txt,
           SimCode.FUNCTIONCODE(makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes, cflags = i_makefileParams_cflags, ldflags = i_makefileParams_ldflags, runtimelibs = i_makefileParams_runtimelibs), name = i_name) )
      equation
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_572(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        ret_2 = Config.acceptParModelicaGrammar();
        l_ParModelicaExpLibs = fun_573(Tpl.emptyTxt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Dynamic loading uses -O0 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O0\n",
                                    "CC="
                                }, false));
        ret_3 = Config.acceptParModelicaGrammar();
        txt = fun_574(txt, ret_3, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DEBUG_FLAGS="));
        ret_4 = Config.acceptMetaModelicaGrammar();
        ret_5 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        ret_6 = boolOr(ret_4, ret_5);
        txt = fun_575(txt, ret_6);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS= -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/c\" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_576(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(DEBUG_FLAGS) "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS= -L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -Wl,-rpath,\'"));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\' "));
        txt = Tpl.writeText(txt, l_ParModelicaExpLibs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_runtimelibs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "MAINFILE="
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "\n",
                                    ".PHONY: "
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": $(MAINFILE) "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".h "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CC) $(CFLAGS) -c -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".o $(MAINFILE)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CC) $(CFLAGS) -c -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(LINK) -o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.o "));
        txt = Tpl.writeText(txt, l_libsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS) -lm"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end functionsMakefile;

protected function lm_578
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_auxFunction, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_auxFunction,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls, a_auxFunction) = daeDimensionExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls, a_preExp) = lm_578(txt, rest, a_auxFunction, a_varDecls, a_preExp, a_context);
      then (txt, a_auxFunction, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_auxFunction,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_auxFunction, a_varDecls, a_preExp) = lm_578(txt, rest, a_auxFunction, a_varDecls, a_preExp, a_context);
      then (txt, a_auxFunction, a_varDecls, a_preExp);
  end match;
end lm_578;

protected function fun_579
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_auxFunction;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_cr, in_a_auxFunction, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      SimCode.Context a_context;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      DAE.ComponentRef i_cr;
      ClassInf.State i_record__state;
      String ret_12;
      Tpl.Text txt_11;
      list<DAE.Subscript> ret_10;
      Tpl.Text l_dimsValuesStr;
      Integer ret_8;
      list<DAE.Subscript> ret_7;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_5;
      Tpl.Text l_recPtr;
      Absyn.Path ret_3;
      Tpl.Text l_rec__name;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(identType = DAE.T_ARRAY(ty = DAE.T_COMPLEX(complexClassType = i_record__state)), ident = i_ident, componentRef = i_componentRef)),
           a_auxFunction,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        ret_3 = ClassInf.getStateName(i_record__state);
        l_rec__name = CodegenUtil.underscorePath(Tpl.emptyTxt, ret_3);
        txt_5 = Tpl.writeText(Tpl.emptyTxt, l_rec__name);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING("*"));
        (l_recPtr, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_5), l_varDecls);
        ret_7 = ComponentReference.crefSubs(i_cr);
        ret_8 = listLength(ret_7);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_8));
        ret_10 = ComponentReference.crefSubs(i_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_auxFunction, l_varDecls, l_preExp) = lm_578(l_dimsValuesStr, ret_10, a_auxFunction, l_varDecls, l_preExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(("));
        txt = Tpl.writeText(txt, l_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*)(generic_array_element_addr(&_"));
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", sizeof("));
        txt = Tpl.writeText(txt, l_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), "));
        txt = Tpl.writeText(txt, l_dimsLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")))->"));
        (txt, a_auxFunction) = contextCref(txt, i_componentRef, a_context, a_auxFunction);
      then (txt, a_auxFunction);

    case ( txt,
           i_cr,
           a_auxFunction,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt_11 = CodegenUtil.crefStr(Tpl.emptyTxt, i_cr);
        ret_12 = System.unquoteIdentifier(Tpl.textString(txt_11));
        txt = Tpl.writeStr(txt, ret_12);
      then (txt, a_auxFunction);
  end match;
end fun_579;

protected function lm_580
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_auxFunction, a_varDecls, a_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           a_auxFunction,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_preExp, a_varDecls, a_auxFunction) = daeDimensionExp(txt, i_exp, a_context, a_preExp, a_varDecls, a_auxFunction);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls, a_preExp) = lm_580(txt, rest, a_auxFunction, a_varDecls, a_preExp, a_context);
      then (txt, a_auxFunction, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_auxFunction,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_auxFunction, a_varDecls, a_preExp) = lm_580(txt, rest, a_auxFunction, a_varDecls, a_preExp, a_context);
      then (txt, a_auxFunction, a_varDecls, a_preExp);
  end match;
end lm_580;

protected function fun_581
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_auxFunction;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_cr, in_a_auxFunction, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      SimCode.Context a_context;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      DAE.ComponentRef i_cr;
      ClassInf.State i_record__state;
      String ret_12;
      Tpl.Text txt_11;
      list<DAE.Subscript> ret_10;
      Tpl.Text l_dimsValuesStr;
      Integer ret_8;
      list<DAE.Subscript> ret_7;
      Tpl.Text l_dimsLenStr;
      Tpl.Text txt_5;
      Tpl.Text l_recPtr;
      Absyn.Path ret_3;
      Tpl.Text l_rec__name;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           (i_cr as DAE.CREF_QUAL(identType = DAE.T_ARRAY(ty = DAE.T_COMPLEX(complexClassType = i_record__state)), ident = i_ident, componentRef = i_componentRef)),
           a_auxFunction,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        ret_3 = ClassInf.getStateName(i_record__state);
        l_rec__name = CodegenUtil.underscorePath(Tpl.emptyTxt, ret_3);
        txt_5 = Tpl.writeText(Tpl.emptyTxt, l_rec__name);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING("*"));
        (l_recPtr, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_5), l_varDecls);
        ret_7 = ComponentReference.crefSubs(i_cr);
        ret_8 = listLength(ret_7);
        l_dimsLenStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_8));
        ret_10 = ComponentReference.crefSubs(i_cr);
        l_dimsValuesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_dimsValuesStr, a_auxFunction, l_varDecls, l_preExp) = lm_580(l_dimsValuesStr, ret_10, a_auxFunction, l_varDecls, l_preExp, a_context);
        l_dimsValuesStr = Tpl.popIter(l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(("));
        txt = Tpl.writeText(txt, l_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*)(generic_array_element_addr(&_"));
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", sizeof("));
        txt = Tpl.writeText(txt, l_rec__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), "));
        txt = Tpl.writeText(txt, l_dimsLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, l_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")))->"));
        (txt, a_auxFunction) = contextCref(txt, i_componentRef, a_context, a_auxFunction);
      then (txt, a_auxFunction);

    case ( txt,
           i_cr,
           a_auxFunction,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt_11 = CodegenUtil.crefStr(Tpl.emptyTxt, i_cr);
        ret_12 = System.unquoteIdentifier(Tpl.textString(txt_11));
        txt = Tpl.writeStr(txt, ret_12);
      then (txt, a_auxFunction);
  end match;
end fun_581;

protected function fun_582
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_context, in_a_cr, in_a_auxFunction)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      Tpl.Text a_auxFunction;
      SimCode.Context i_context;

    case ( txt,
           (i_context as SimCode.FUNCTION_CONTEXT()),
           a_cr,
           a_auxFunction )
      equation
        (txt, a_auxFunction) = fun_579(txt, a_cr, a_auxFunction, i_context);
      then (txt, a_auxFunction);

    case ( txt,
           (i_context as SimCode.PARALLEL_FUNCTION_CONTEXT()),
           a_cr,
           a_auxFunction )
      equation
        (txt, a_auxFunction) = fun_581(txt, a_cr, a_auxFunction, i_context);
      then (txt, a_auxFunction);

    case ( txt,
           _,
           a_cr,
           a_auxFunction )
      equation
        txt = cref(txt, a_cr);
      then (txt, a_auxFunction);
  end match;
end fun_582;

public function contextCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;
  input Tpl.Text a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) := fun_582(txt, a_context, a_cr, a_auxFunction);
end contextCref;

protected function fun_584
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Absyn.Ident in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Ident a_name;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           SimCode.PARALLEL_FUNCTION_CONTEXT(),
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = Tpl.writeStr(txt, a_name);
      then txt;
  end match;
end fun_584;

public function contextIteratorName
  input Tpl.Text txt;
  input Absyn.Ident a_name;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_584(txt, a_context, a_name);
end contextIteratorName;

public function cref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = CodegenUtil.crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_cr);
      then txt;
  end match;
end cref;

public function crefToCStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = subscriptsToCStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = crefToCStr(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.WILD() )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefToCStr;

protected function lm_588
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToCStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_588(txt, rest);
      then txt;
  end match;
end lm_588;

public function subscriptsToCStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$lB"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("$c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_588(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$rB"));
      then txt;
  end match;
end subscriptsToCStr;

protected function fun_590
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Integer i_i;
      Tpl.Text l_index;
      Tpl.Text l_auxFunction;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;

    case ( txt,
           DAE.ICONST(integer = i_i) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_i) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           i_exp )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        l_auxFunction = Tpl.emptyTxt;
        (l_index, l_preExp, l_varDecls, l_auxFunction) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, l_varDecls, l_auxFunction);
        txt = Tpl.writeText(txt, l_index);
      then txt;
  end match;
end fun_590;

public function subscriptToCStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Integer i_i;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = i_exp) )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown slice "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4756, 29), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           DAE.INDEX(exp = i_exp) )
      equation
        txt = fun_590(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4769, 14), "UNKNOWN_SUBSCRIPT");
      then txt;
  end match;
end subscriptToCStr;

public function crefM
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           (i_cr as DAE.CREF_IDENT(ident = "xloc")) )
      equation
        txt = CodegenUtil.crefStr(txt, i_cr);
      then txt;

    case ( txt,
           DAE.CREF_IDENT(ident = "time") )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("time"));
      then txt;

    case ( txt,
           i_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("P"));
        txt = crefToMStr(txt, i_cr);
      then txt;
  end match;
end crefM;

public function crefToMStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = subscriptsToMStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToMStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("P"));
        txt = crefToMStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefToMStr;

protected function lm_594
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptToMStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_594(txt, rest);
      then txt;
  end match;
end lm_594;

public function subscriptsToMStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("lB"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("c")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_594(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rB"));
      then txt;
  end match;
end subscriptsToMStr;

protected function fun_596
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Integer i_i;
      Tpl.Text l_auxFunction;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;

    case ( txt,
           DAE.ICONST(integer = i_i) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_i) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           i_exp )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        l_auxFunction = Tpl.emptyTxt;
        (txt, l_preExp, l_varDecls, l_auxFunction) = daeExp(txt, i_exp, SimCode.contextOther, l_preExp, l_varDecls, l_auxFunction);
      then txt;
  end match;
end fun_596;

public function subscriptToMStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Integer i_i;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.SLICE(exp = i_exp) )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown slice "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4800, 29), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           DAE.INDEX(exp = i_exp) )
      equation
        txt = fun_596(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4812, 14), "UNKNOWN_SUBSCRIPT");
      then txt;
  end match;
end subscriptToMStr;

protected function fun_598
  input Tpl.Text in_txt;
  input Tpl.Text in_a_lhs;
  input DAE.Exp in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lhs, in_a_e)
    local
      Tpl.Text txt;
      DAE.Exp a_e;
      Tpl.Text i_lhs;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_e )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Got empty statement from writeLhsCref("));
        ret_0 = ExpressionDump.printExpStr(a_e);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING(")"));
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4823, 62), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           i_lhs,
           _ )
      equation
        txt = Tpl.writeText(txt, i_lhs);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_598;

protected function fun_599
  input Tpl.Text in_txt;
  input Tpl.Text in_a_lhs;
  input DAE.Exp in_a_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_lhs, in_a_e)
    local
      Tpl.Text txt;
      DAE.Exp a_e;
      Tpl.Text i_lhs;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_e )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Got empty statement from writeLhsCref("));
        ret_0 = ExpressionDump.printExpStr(a_e);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING(")"));
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 4831, 62), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           i_lhs,
           _ )
      equation
        txt = Tpl.writeText(txt, i_lhs);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_599;

protected function fun_600
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_cr;
  input DAE.Exp in_a_e;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varCopy;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_varCopy, out_a_auxFunction) :=
  match(in_txt, in_a_ty, in_a_cr, in_a_e, in_a_context, in_a_varDecls, in_a_varCopy, in_a_auxFunction)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;
      DAE.Exp a_e;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      Tpl.Text a_varCopy;
      Tpl.Text a_auxFunction;
      DAE.Type i_ty;
      Tpl.Text txt_3;
      Tpl.Text l_lhs;
      Tpl.Text l_var;
      Tpl.Text l_varCopyAfter;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           a_e,
           a_context,
           a_varDecls,
           a_varCopy,
           a_auxFunction )
      equation
        l_varCopyAfter = Tpl.emptyTxt;
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, "base_array_t", a_varDecls);
        (l_lhs, l_varCopyAfter, a_varDecls, a_auxFunction) = writeLhsCref(Tpl.emptyTxt, a_e, Tpl.textString(l_var), a_context, l_varCopyAfter, a_varDecls, a_auxFunction);
        a_varCopy = fun_598(a_varCopy, l_lhs, a_e);
        a_varCopy = Tpl.writeText(a_varCopy, l_varCopyAfter);
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_varDecls, a_varCopy, a_auxFunction);

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _))),
           _,
           a_e,
           a_context,
           a_varDecls,
           a_varCopy,
           a_auxFunction )
      equation
        l_varCopyAfter = Tpl.emptyTxt;
        txt_3 = expTypeArrayIf(Tpl.emptyTxt, i_ty);
        (l_var, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_3), a_varDecls);
        (l_lhs, l_varCopyAfter, a_varDecls, a_auxFunction) = writeLhsCref(Tpl.emptyTxt, a_e, Tpl.textString(l_var), a_context, l_varCopyAfter, a_varDecls, a_auxFunction);
        a_varCopy = fun_599(a_varCopy, l_lhs, a_e);
        a_varCopy = Tpl.writeText(a_varCopy, l_varCopyAfter);
        txt = Tpl.writeText(txt, l_var);
      then (txt, a_varDecls, a_varCopy, a_auxFunction);

    case ( txt,
           _,
           a_cr,
           _,
           a_context,
           a_varDecls,
           a_varCopy,
           a_auxFunction )
      equation
        (txt, a_auxFunction) = contextCref(txt, a_cr, a_context, a_auxFunction);
      then (txt, a_varDecls, a_varCopy, a_auxFunction);
  end match;
end fun_600;

public function contextArrayReferenceCrefAndCopy
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input DAE.Exp a_e;
  input DAE.Type a_ty;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varCopy;
  input Tpl.Text a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_varDecls, out_a_varCopy, out_a_auxFunction) := fun_600(txt, a_ty, a_cr, a_e, a_context, a_varDecls, a_varCopy, a_auxFunction);
end contextArrayReferenceCrefAndCopy;

protected function fun_602
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_cr;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = arrayCrefStr(txt, a_cr);
      then txt;

    case ( txt,
           SimCode.PARALLEL_FUNCTION_CONTEXT(),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = arrayCrefStr(txt, a_cr);
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = arrayCrefCStr(txt, a_cr);
      then txt;
  end match;
end fun_602;

public function contextArrayCref
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_602(txt, a_context, a_cr);
end contextArrayCref;

public function arrayCrefCStr
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
  out_txt := arrayCrefCStr2(out_txt, a_cr);
end arrayCrefCStr;

public function arrayCrefCStr2
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsToCStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P"));
        txt = arrayCrefCStr2(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end arrayCrefCStr2;

public function arrayCrefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("._"));
        txt = arrayCrefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end arrayCrefStr;

public function expCref
  input Tpl.Text in_txt;
  input DAE.Exp in_a_ecr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ecr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_arg_componentRef;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.CREF(componentRef = i_componentRef) )
      equation
        txt = cref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {DAE.CREF(componentRef = i_arg_componentRef)}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$P$DER"));
        txt = cref(txt, i_arg_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ERROR_NOT_A_CREF"));
      then txt;
  end match;
end expCref;

public function crefFunctionName
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Ident i_ident;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        ret_1 = System.stringReplace(ret_0, "_", "__");
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef) )
      equation
        ret_2 = System.unquoteIdentifier(i_ident);
        ret_3 = System.stringReplace(ret_2, "_", "__");
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = crefFunctionName(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end crefFunctionName;

protected function lm_609
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_609(txt, rest);
      then txt;
  end match;
end lm_609;

public function externalFunctionIncludes
  input Tpl.Text in_txt;
  input list<String> in_a_includes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_includes)
    local
      Tpl.Text txt;
      list<String> i_includes;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_includes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_609(txt, i_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end externalFunctionIncludes;

protected function lm_611
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input Tpl.Text in_a_staticPrototypes;
  input Boolean in_a_isSimulation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  (out_txt, out_a_staticPrototypes) :=
  match(in_txt, in_items, in_a_staticPrototypes, in_a_isSimulation)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Tpl.Text a_staticPrototypes;
      Boolean a_isSimulation;
      SimCode.Function i_fn;

    case ( txt,
           {},
           a_staticPrototypes,
           _ )
      then (txt, a_staticPrototypes);

    case ( txt,
           i_fn :: rest,
           a_staticPrototypes,
           a_isSimulation )
      equation
        (txt, a_staticPrototypes) = functionHeader(txt, i_fn, false, a_isSimulation, a_staticPrototypes);
        txt = Tpl.nextIter(txt);
        (txt, a_staticPrototypes) = lm_611(txt, rest, a_staticPrototypes, a_isSimulation);
      then (txt, a_staticPrototypes);
  end match;
end lm_611;

public function functionHeaders
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input Boolean a_isSimulation;
  input Tpl.Text a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_staticPrototypes) := lm_611(out_txt, a_functions, a_staticPrototypes, a_isSimulation);
  out_txt := Tpl.popIter(out_txt);
end functionHeaders;

protected function lm_613
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = parallelFunctionHeader(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_613(txt, rest);
      then txt;
  end match;
end lm_613;

public function parallelFunctionHeadersImpl
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_613(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end parallelFunctionHeadersImpl;

protected function lm_615
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = lm_615(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_615(txt, rest);
      then txt;
  end match;
end lm_615;

protected function fun_616
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_visibility)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PUBLIC() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLExport"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_616;

public function functionHeader
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input Boolean in_a_isSimulation;
  input Tpl.Text in_a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  (out_txt, out_a_staticPrototypes) :=
  match(in_txt, in_a_fn, in_a_inFunc, in_a_isSimulation, in_a_staticPrototypes)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      Boolean a_isSimulation;
      Tpl.Text a_staticPrototypes;
      list<SimCode.Variable> i_funArgs;
      SimCode.Function i_fn;
      SCode.Visibility i_visibility;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      Tpl.Text l_funArgsStr;
      Tpl.Text l_fname;
      Boolean ret_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Boolean ret_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars, visibility = i_visibility)),
           a_inFunc,
           a_isSimulation,
           a_staticPrototypes )
      equation
        txt_0 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_staticPrototypes) = functionHeaderNormal(txt, Tpl.textString(txt_0), i_functionArguments, i_outVars, a_inFunc, i_visibility, false, a_isSimulation, a_staticPrototypes);
        txt = Tpl.softNewLine(txt);
        txt_1 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        ret_2 = SimCodeUtil.isBoxedFunction(i_fn);
        (txt, a_staticPrototypes) = functionHeaderBoxed(txt, Tpl.textString(txt_1), i_functionArguments, i_outVars, ret_2, i_visibility, false, a_isSimulation, a_staticPrototypes);
      then (txt, a_staticPrototypes);

    case ( txt,
           SimCode.KERNEL_FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars),
           _,
           _,
           a_staticPrototypes )
      equation
        txt_3 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderKernelFunctionInterface(txt, Tpl.textString(txt_3), i_functionArguments, i_outVars);
      then (txt, a_staticPrototypes);

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, name = i_name, funArgs = i_funArgs, outVars = i_outVars, visibility = i_visibility)),
           a_inFunc,
           a_isSimulation,
           a_staticPrototypes )
      equation
        txt_4 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_staticPrototypes) = functionHeaderNormal(txt, Tpl.textString(txt_4), i_funArgs, i_outVars, a_inFunc, i_visibility, true, a_isSimulation, a_staticPrototypes);
        txt = Tpl.softNewLine(txt);
        txt_5 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        ret_6 = SimCodeUtil.isBoxedFunction(i_fn);
        (txt, a_staticPrototypes) = functionHeaderBoxed(txt, Tpl.textString(txt_5), i_funArgs, i_outVars, ret_6, i_visibility, true, a_isSimulation, a_staticPrototypes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = extFunDefDynamic(txt, i_fn);
      then (txt, a_staticPrototypes);

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name, funArgs = i_funArgs, outVars = i_outVars, visibility = i_visibility)),
           a_inFunc,
           a_isSimulation,
           a_staticPrototypes )
      equation
        txt_7 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_staticPrototypes) = functionHeaderNormal(txt, Tpl.textString(txt_7), i_funArgs, i_outVars, a_inFunc, i_visibility, false, a_isSimulation, a_staticPrototypes);
        txt = Tpl.softNewLine(txt);
        txt_8 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        ret_9 = SimCodeUtil.isBoxedFunction(i_fn);
        (txt, a_staticPrototypes) = functionHeaderBoxed(txt, Tpl.textString(txt_8), i_funArgs, i_outVars, ret_9, i_visibility, false, a_isSimulation, a_staticPrototypes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = extFunDef(txt, i_fn);
      then (txt, a_staticPrototypes);

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs, visibility = i_visibility),
           _,
           a_isSimulation,
           a_staticPrototypes )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        l_funArgsStr = lm_615(Tpl.emptyTxt, i_funArgs);
        txt = fun_616(txt, i_visibility);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" omc_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData"));
        txt = Tpl.writeText(txt, l_funArgsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "); /* record head */\n",
                                    "\n"
                                }, true));
        (txt, a_staticPrototypes) = functionHeaderBoxed(txt, Tpl.textString(l_fname), i_funArgs, SimCode.boxedRecordOutVars, false, i_visibility, false, a_isSimulation, a_staticPrototypes);
      then (txt, a_staticPrototypes);

    case ( txt,
           _,
           _,
           _,
           a_staticPrototypes )
      then (txt, a_staticPrototypes);
  end match;
end functionHeader;

public function parallelFunctionHeader
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.PARALLEL_FUNCTION(name = i_name, functionArguments = i_functionArguments, outVars = i_outVars),
           a_inFunc )
      equation
        txt_0 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = functionHeaderParallelImpl(txt, Tpl.textString(txt_0), i_functionArguments, i_outVars, a_inFunc, false);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end parallelFunctionHeader;

protected function lm_619
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_619(txt, rest);
      then txt;
  end match;
end lm_619;

protected function lm_620
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      String a_fname;
      Integer x_i1;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_fname )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype_"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_620(txt, rest, a_fname);
      then txt;
  end match;
end lm_620;

protected function lm_621
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_621(txt, rest);
      then txt;
  end match;
end lm_621;

protected function fun_622
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_621(txt, i_dims);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_622;

protected function fun_623
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;

    case ( txt,
           false,
           a_var )
      equation
        txt = varType(txt, a_var);
      then txt;

    case ( txt,
           _,
           a_var )
      equation
        txt = varTypeBoxed(txt, a_var);
      then txt;
  end match;
end fun_623;

protected function fun_624
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_i1;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_i1, in_a_boxed)
    local
      Tpl.Text txt;
      Integer a_i1;
      Boolean a_boxed;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;
      DAE.Type i_ty;
      Tpl.Text l_typeStr;
      Tpl.Text l_dimStr;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_name)),
           a_i1,
           a_boxed )
      equation
        l_dimStr = fun_622(Tpl.emptyTxt, i_ty);
        l_typeStr = fun_623(Tpl.emptyTxt, a_boxed, i_var);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeText(txt, l_dimStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_i1,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = Tpl.writeStr(txt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_624;

protected function lm_625
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_boxed)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_boxed;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_boxed )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_624(txt, i_var, x_i1, a_boxed);
        txt = Tpl.nextIter(txt);
        txt = lm_625(txt, rest, a_boxed);
      then txt;
  end match;
end lm_625;

protected function fun_626
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fargsStr;
  input Boolean in_a_boxed;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fargsStr, in_a_boxed, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      Boolean a_boxed;
      String a_fname;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_outVars,
           a_fargsStr,
           a_boxed,
           a_fname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_620(txt, i_outVars, a_fname);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype_s\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_625(txt, i_outVars, a_boxed);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype omc_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end fun_626;

public function functionHeaderParallelImpl
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input Boolean a_boxed;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fargsStr;
algorithm
  l_fargsStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_fargsStr := lm_619(l_fargsStr, a_fargs);
  l_fargsStr := Tpl.popIter(l_fargsStr);
  out_txt := fun_626(txt, a_outVars, l_fargsStr, a_boxed, a_fname);
end functionHeaderParallelImpl;

protected function lm_628
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"_"));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_628(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_628(txt, rest);
      then txt;
  end match;
end lm_628;

protected function lm_629
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.nextIter(txt);
        txt = lm_629(txt, rest);
      then txt;
  end match;
end lm_629;

public function recordDeclaration
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_recDecl)
    local
      Tpl.Text txt;
      list<String> i_fieldNames;
      Absyn.Path i_path;
      list<SimCode.Variable> i_variables;
      Absyn.Path i_defPath;
      Integer ret_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Integer ret_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.RECORD_DECL_FULL(defPath = i_defPath, variables = i_variables) )
      equation
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_defPath);
        txt_1 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_defPath);
        txt_2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_628(txt_2, i_variables);
        txt_2 = Tpl.popIter(txt_2);
        ret_3 = listLength(i_variables);
        txt = recordDefinition(txt, Tpl.textString(txt_0), Tpl.textString(txt_1), Tpl.textString(txt_2), ret_3);
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = i_path, fieldNames = i_fieldNames) )
      equation
        txt_4 = CodegenUtil.dotPath(Tpl.emptyTxt, i_path);
        txt_5 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_path);
        txt_6 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_6 = lm_629(txt_6, i_fieldNames);
        txt_6 = Tpl.popIter(txt_6);
        ret_7 = listLength(i_fieldNames);
        txt = recordDefinition(txt, Tpl.textString(txt_4), Tpl.textString(txt_5), Tpl.textString(txt_6), ret_7);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end recordDeclaration;

protected function lm_631
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name)) :: rest )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" _"));
        txt = CodegenUtil.crefStr(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_631(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_631(txt, rest);
      then txt;
  end match;
end lm_631;

protected function fun_632
  input Tpl.Text in_txt;
  input Option<String> in_a_aliasName;
  input list<SimCode.Variable> in_a_r_variables;
  input String in_a_r_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasName, in_a_r_variables, in_a_r_name)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_r_variables;
      String a_r_name;
      String i_str;

    case ( txt,
           SOME(i_str),
           _,
           a_r_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef "));
        txt = Tpl.writeStr(txt, i_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_r_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           a_r_variables,
           a_r_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeStr(txt, a_r_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_631(txt, a_r_variables);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, a_r_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_632;

public function recordDeclarationHeader
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_recDecl)
    local
      Tpl.Text txt;
      list<String> i_fieldNames;
      Absyn.Path i_path;
      list<SimCode.Variable> i_variables;
      Absyn.Path i_defPath;
      String i_name;
      list<SimCode.Variable> i_r_variables;
      String i_r_name;
      Option<String> i_aliasName;
      Integer ret_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Integer ret_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.RECORD_DECL_FULL(aliasName = i_aliasName, name = (i_name as i_r_name), variables = (i_variables as i_r_variables), defPath = i_defPath) )
      equation
        txt = fun_632(txt, i_aliasName, i_r_variables, i_r_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef base_array_t "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_array;\n"));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_defPath);
        txt_1 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_defPath);
        ret_2 = listLength(i_variables);
        txt = recordDefinitionHeader(txt, Tpl.textString(txt_0), Tpl.textString(txt_1), ret_2);
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = i_path, fieldNames = i_fieldNames) )
      equation
        txt_3 = CodegenUtil.dotPath(Tpl.emptyTxt, i_path);
        txt_4 = CodegenUtil.underscorePath(Tpl.emptyTxt, i_path);
        ret_5 = listLength(i_fieldNames);
        txt = recordDefinitionHeader(txt, Tpl.textString(txt_3), Tpl.textString(txt_4), ret_5);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end recordDeclarationHeader;

protected function fun_634
  input Tpl.Text in_txt;
  input Integer in_a_numFields;
  input String in_a_fieldNames;
  input String in_a_encName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_numFields, in_a_fieldNames, in_a_encName)
    local
      Tpl.Text txt;
      String a_fieldNames;
      String a_encName;
      Integer i_numFields;

    case ( txt,
           0,
           _,
           a_encName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char* "));
        txt = Tpl.writeStr(txt, a_encName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc__fields[1] = {\"no fields\"};"));
      then txt;

    case ( txt,
           i_numFields,
           a_fieldNames,
           a_encName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char* "));
        txt = Tpl.writeStr(txt, a_encName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc__fields["));
        txt = Tpl.writeStr(txt, intString(i_numFields));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = {"));
        txt = Tpl.writeStr(txt, a_fieldNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end match;
end fun_634;

public function recordDefinition
  input Tpl.Text txt;
  input String a_origName;
  input String a_encName;
  input String a_fieldNames;
  input Integer a_numFields;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fieldsDescription;
algorithm
  l_fieldsDescription := fun_634(Tpl.emptyTxt, a_numFields, a_fieldNames, a_encName);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc_added 1\n"));
  out_txt := Tpl.writeText(out_txt, l_fieldsDescription);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("struct record_description "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc = {\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\", /* package_record__X */\n",
                                       "\""
                                   }, false));
  out_txt := Tpl.writeStr(out_txt, a_origName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("\", /* package.record_X */\n"));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("__desc__fields\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("};"));
end recordDefinition;

public function recordDefinitionHeader
  input Tpl.Text txt;
  input String a_origName;
  input String a_encName;
  input Integer a_numFields;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("extern struct record_description "));
  out_txt := Tpl.writeStr(out_txt, a_encName);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("__desc;"));
end recordDefinitionHeader;

public function functionHeaderNormal
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input SCode.Visibility a_visibility;
  input Boolean a_dynLoad;
  input Boolean a_isSimulation;
  input Tpl.Text a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  (out_txt, out_a_staticPrototypes) := functionHeaderImpl(txt, a_fname, a_fargs, a_outVars, a_inFunc, false, a_visibility, a_dynLoad, a_isSimulation, a_staticPrototypes);
end functionHeaderNormal;

protected function fun_638
  input Tpl.Text in_txt;
  input Boolean in_a_isBoxed;
  input Tpl.Text in_a_staticPrototypes;
  input Boolean in_a_isSimulation;
  input Boolean in_a_dynLoad;
  input SCode.Visibility in_a_visibility;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_fargs;
  input String in_a_fname;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  (out_txt, out_a_staticPrototypes) :=
  match(in_txt, in_a_isBoxed, in_a_staticPrototypes, in_a_isSimulation, in_a_dynLoad, in_a_visibility, in_a_outVars, in_a_fargs, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_staticPrototypes;
      Boolean a_isSimulation;
      Boolean a_dynLoad;
      SCode.Visibility a_visibility;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_fargs;
      String a_fname;

    case ( txt,
           false,
           a_staticPrototypes,
           a_isSimulation,
           a_dynLoad,
           a_visibility,
           a_outVars,
           a_fargs,
           a_fname )
      equation
        (txt, a_staticPrototypes) = functionHeaderImpl(txt, a_fname, a_fargs, a_outVars, false, true, a_visibility, a_dynLoad, a_isSimulation, a_staticPrototypes);
      then (txt, a_staticPrototypes);

    case ( txt,
           _,
           a_staticPrototypes,
           _,
           _,
           _,
           _,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define boxptr_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" omc_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_staticPrototypes);
  end match;
end fun_638;

protected function fun_639
  input Tpl.Text in_txt;
  input Boolean in_a_isSimulation;
  input Tpl.Text in_a_boxvar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isSimulation, in_a_boxvar)
    local
      Tpl.Text txt;
      Tpl.Text a_boxvar;

    case ( txt,
           false,
           a_boxvar )
      equation
        txt = Tpl.writeText(txt, a_boxvar);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_639;

protected function fun_640
  input Tpl.Text in_txt;
  input Boolean in_a_isSimulation;
  input Tpl.Text in_a_boxvar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isSimulation, in_a_boxvar)
    local
      Tpl.Text txt;
      Tpl.Text a_boxvar;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_boxvar )
      equation
        txt = Tpl.writeText(txt, a_boxvar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* boxvar early */"));
      then txt;
  end match;
end fun_640;

protected function fun_641
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;
  input Tpl.Text in_a_boxvar;
  input Boolean in_a_isSimulation;
  input Tpl.Text in_a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  (out_txt, out_a_staticPrototypes) :=
  match(in_txt, in_a_visibility, in_a_boxvar, in_a_isSimulation, in_a_staticPrototypes)
    local
      Tpl.Text txt;
      Tpl.Text a_boxvar;
      Boolean a_isSimulation;
      Tpl.Text a_staticPrototypes;

    case ( txt,
           SCode.PROTECTED(),
           a_boxvar,
           a_isSimulation,
           a_staticPrototypes )
      equation
        a_staticPrototypes = fun_639(a_staticPrototypes, a_isSimulation, a_boxvar);
        txt = fun_640(txt, a_isSimulation, a_boxvar);
      then (txt, a_staticPrototypes);

    case ( txt,
           _,
           a_boxvar,
           _,
           a_staticPrototypes )
      equation
        txt = Tpl.writeText(txt, a_boxvar);
      then (txt, a_staticPrototypes);
  end match;
end fun_641;

public function functionHeaderBoxed
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_isBoxed;
  input SCode.Visibility a_visibility;
  input Boolean a_dynLoad;
  input Boolean a_isSimulation;
  input Tpl.Text a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
protected
  Tpl.Text l_boxvar;
algorithm
  l_boxvar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("static const MMC_DEFSTRUCTLIT(boxvar_lit_"));
  l_boxvar := Tpl.writeStr(l_boxvar, a_fname);
  l_boxvar := Tpl.writeTok(l_boxvar, Tpl.ST_STRING(",2,0) {boxptr_"));
  l_boxvar := Tpl.writeStr(l_boxvar, a_fname);
  l_boxvar := Tpl.writeTok(l_boxvar, Tpl.ST_STRING_LIST({
                                         ",0}};\n",
                                         "#define boxvar_"
                                     }, false));
  l_boxvar := Tpl.writeStr(l_boxvar, a_fname);
  l_boxvar := Tpl.writeTok(l_boxvar, Tpl.ST_STRING(" MMC_REFSTRUCTLIT(boxvar_lit_"));
  l_boxvar := Tpl.writeStr(l_boxvar, a_fname);
  l_boxvar := Tpl.writeTok(l_boxvar, Tpl.ST_STRING(")"));
  l_boxvar := Tpl.writeTok(l_boxvar, Tpl.ST_NEW_LINE());
  (out_txt, out_a_staticPrototypes) := fun_638(txt, a_isBoxed, a_staticPrototypes, a_isSimulation, a_dynLoad, a_visibility, a_outVars, a_fargs, a_fname);
  out_txt := Tpl.softNewLine(out_txt);
  (out_txt, out_a_staticPrototypes) := fun_641(out_txt, a_visibility, l_boxvar, a_isSimulation, out_a_staticPrototypes);
end functionHeaderBoxed;

protected function fun_643
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fname)
    local
      Tpl.Text txt;
      String a_fname;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "DLLExport\n",
                                    "int in_"
                                }, false));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(type_description * inArgs, type_description * outVar);"));
      then txt;
  end match;
end fun_643;

protected function fun_644
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_prototype;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_prototype)
    local
      Tpl.Text txt;
      Tpl.Text a_prototype;

    case ( txt,
           false,
           a_prototype )
      equation
        txt = Tpl.writeText(txt, a_prototype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_644;

protected function fun_645
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_prototype;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_prototype)
    local
      Tpl.Text txt;
      Tpl.Text a_prototype;

    case ( txt,
           false,
           a_prototype )
      equation
        txt = Tpl.writeText(txt, a_prototype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_645;

protected function fun_646
  input Tpl.Text in_txt;
  input Boolean in_a_isSimulation;
  input Tpl.Text in_a_inFnStr;
  input Tpl.Text in_a_prototype;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  (out_txt, out_a_staticPrototypes) :=
  match(in_txt, in_a_isSimulation, in_a_inFnStr, in_a_prototype, in_a_dynamicLoad, in_a_staticPrototypes)
    local
      Tpl.Text txt;
      Tpl.Text a_inFnStr;
      Tpl.Text a_prototype;
      Boolean a_dynamicLoad;
      Tpl.Text a_staticPrototypes;

    case ( txt,
           false,
           a_inFnStr,
           a_prototype,
           a_dynamicLoad,
           a_staticPrototypes )
      equation
        a_staticPrototypes = fun_644(a_staticPrototypes, a_dynamicLoad, a_prototype);
        txt = Tpl.writeText(txt, a_inFnStr);
      then (txt, a_staticPrototypes);

    case ( txt,
           _,
           _,
           a_prototype,
           a_dynamicLoad,
           a_staticPrototypes )
      equation
        txt = fun_645(txt, a_dynamicLoad, a_prototype);
      then (txt, a_staticPrototypes);
  end match;
end fun_646;

protected function fun_647
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_prototype;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_prototype)
    local
      Tpl.Text txt;
      Tpl.Text a_prototype;

    case ( txt,
           false,
           a_prototype )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLExport"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_prototype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_647;

protected function fun_648
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;
  input Tpl.Text in_a_inFnStr;
  input Tpl.Text in_a_prototype;
  input Boolean in_a_dynamicLoad;
  input Tpl.Text in_a_staticPrototypes;
  input Boolean in_a_isSimulation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
algorithm
  (out_txt, out_a_staticPrototypes) :=
  match(in_txt, in_a_visibility, in_a_inFnStr, in_a_prototype, in_a_dynamicLoad, in_a_staticPrototypes, in_a_isSimulation)
    local
      Tpl.Text txt;
      Tpl.Text a_inFnStr;
      Tpl.Text a_prototype;
      Boolean a_dynamicLoad;
      Tpl.Text a_staticPrototypes;
      Boolean a_isSimulation;

    case ( txt,
           SCode.PROTECTED(),
           a_inFnStr,
           a_prototype,
           a_dynamicLoad,
           a_staticPrototypes,
           a_isSimulation )
      equation
        (txt, a_staticPrototypes) = fun_646(txt, a_isSimulation, a_inFnStr, a_prototype, a_dynamicLoad, a_staticPrototypes);
      then (txt, a_staticPrototypes);

    case ( txt,
           _,
           a_inFnStr,
           a_prototype,
           a_dynamicLoad,
           a_staticPrototypes,
           _ )
      equation
        txt = Tpl.writeText(txt, a_inFnStr);
        txt = Tpl.softNewLine(txt);
        txt = fun_647(txt, a_dynamicLoad, a_prototype);
      then (txt, a_staticPrototypes);
  end match;
end fun_648;

public function functionHeaderImpl
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_inFunc;
  input Boolean a_boxed;
  input SCode.Visibility a_visibility;
  input Boolean a_dynamicLoad;
  input Boolean a_isSimulation;
  input Tpl.Text a_staticPrototypes;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_staticPrototypes;
protected
  Boolean ret_2;
  Tpl.Text l_inFnStr;
  Tpl.Text l_prototype;
algorithm
  l_prototype := functionPrototype(Tpl.emptyTxt, a_fname, a_fargs, a_outVars, a_boxed, a_visibility, a_isSimulation);
  ret_2 := boolAnd(a_boxed, a_inFunc);
  l_inFnStr := fun_643(Tpl.emptyTxt, ret_2, a_fname);
  (out_txt, out_a_staticPrototypes) := fun_648(txt, a_visibility, l_inFnStr, l_prototype, a_dynamicLoad, a_staticPrototypes, a_isSimulation);
end functionHeaderImpl;

protected function fun_650
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_visibility)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PROTECTED() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("static "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_650;

protected function fun_651
  input Tpl.Text in_txt;
  input Boolean in_a_isSimulation;
  input SCode.Visibility in_a_visibility;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isSimulation, in_a_visibility)
    local
      Tpl.Text txt;
      SCode.Visibility a_visibility;

    case ( txt,
           false,
           a_visibility )
      equation
        txt = fun_650(txt, a_visibility);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_651;

protected function lm_652
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgDefinition(txt, i_var);
        txt = lm_652(txt, rest);
      then txt;
  end match;
end lm_652;

protected function lm_653
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgBoxedDefinition(txt, i_var);
        txt = lm_653(txt, rest);
      then txt;
  end match;
end lm_653;

protected function fun_654
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input list<SimCode.Variable> in_a_fargs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed, in_a_fargs)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_fargs;

    case ( txt,
           false,
           a_fargs )
      equation
        txt = lm_652(txt, a_fargs);
      then txt;

    case ( txt,
           _,
           a_fargs )
      equation
        txt = lm_653(txt, a_fargs);
      then txt;
  end match;
end fun_654;

protected function fun_655
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;

    case ( txt,
           false,
           a_var )
      equation
        txt = varType(txt, a_var);
      then txt;

    case ( txt,
           _,
           a_var )
      equation
        txt = varTypeBoxed(txt, a_var);
      then txt;
  end match;
end fun_655;

protected function fun_656
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_boxed)
    local
      Tpl.Text txt;
      Boolean a_boxed;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_boxed )
      equation
        txt = fun_655(txt, a_boxed, i_var);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_656;

protected function fun_657
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_boxed)
    local
      Tpl.Text txt;
      Boolean a_boxed;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           i_var :: _,
           a_boxed )
      equation
        txt = fun_656(txt, i_var, a_boxed);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_657;

protected function fun_658
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omc"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boxptr"));
      then txt;
  end match;
end fun_658;

protected function fun_659
  input Tpl.Text in_txt;
  input Boolean in_a_boxed;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_boxed, in_a_var)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;

    case ( txt,
           false,
           a_var )
      equation
        txt = varType(txt, a_var);
      then txt;

    case ( txt,
           _,
           a_var )
      equation
        txt = varTypeBoxed(txt, a_var);
      then txt;
  end match;
end fun_659;

protected function fun_660
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_boxed)
    local
      Tpl.Text txt;
      Boolean a_boxed;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_boxed )
      equation
        txt = fun_659(txt, a_boxed, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" *out"));
        txt = funArgName(txt, i_var);
      then txt;

    case ( txt,
           (i_var as SimCode.FUNCTION_PTR(name = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr *out"));
        txt = funArgName(txt, i_var);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_660;

protected function lm_661
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_boxed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_boxed)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_boxed;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_boxed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = fun_660(txt, i_var, a_boxed);
        txt = lm_661(txt, rest, a_boxed);
      then txt;
  end match;
end lm_661;

protected function fun_662
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_outarg;
  input Boolean in_a_boxed;
  input Tpl.Text in_a_fargsStr;
  input String in_a_fname;
  input Tpl.Text in_a_boxPtrStr;
  input Tpl.Text in_a_static;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_outarg, in_a_boxed, in_a_fargsStr, in_a_fname, in_a_boxPtrStr, in_a_static)
    local
      Tpl.Text txt;
      Tpl.Text a_outarg;
      Boolean a_boxed;
      Tpl.Text a_fargsStr;
      String a_fname;
      Tpl.Text a_boxPtrStr;
      Tpl.Text a_static;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> ret_1;
      Tpl.Text l_outargs;

    case ( txt,
           {},
           _,
           _,
           a_fargsStr,
           a_fname,
           a_boxPtrStr,
           a_static )
      equation
        txt = Tpl.writeText(txt, a_static);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_boxPtrStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData"));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           i_outVars,
           a_outarg,
           a_boxed,
           a_fargsStr,
           a_fname,
           a_boxPtrStr,
           a_static )
      equation
        ret_1 = List.rest(i_outVars);
        l_outargs = lm_661(Tpl.emptyTxt, ret_1, a_boxed);
        txt = Tpl.writeText(txt, a_static);
        txt = Tpl.writeText(txt, a_outarg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_boxPtrStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData"));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeText(txt, l_outargs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_662;

public function functionPrototype
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;
  input Boolean a_boxed;
  input SCode.Visibility a_visibility;
  input Boolean a_isSimulation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_boxPtrStr;
  Tpl.Text l_outarg;
  Tpl.Text l_fargsStr;
  Tpl.Text l_static;
algorithm
  l_static := fun_651(Tpl.emptyTxt, a_isSimulation, a_visibility);
  l_fargsStr := fun_654(Tpl.emptyTxt, a_boxed, a_fargs);
  l_outarg := fun_657(Tpl.emptyTxt, a_outVars, a_boxed);
  l_boxPtrStr := fun_658(Tpl.emptyTxt, a_boxed);
  out_txt := fun_662(txt, a_outVars, l_outarg, a_boxed, l_fargsStr, a_fname, l_boxPtrStr, l_static);
end functionPrototype;

protected function lm_664
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinitionKernelFunctionInterface(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_664(txt, rest);
      then txt;
  end match;
end lm_664;

protected function lm_665
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      DAE.Dimension i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = dimension(txt, i_dim);
        txt = Tpl.nextIter(txt);
        txt = lm_665(txt, rest);
      then txt;
  end match;
end lm_665;

protected function fun_666
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty)
    local
      Tpl.Text txt;
      DAE.Dimensions i_dims;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_665(txt, i_dims);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_666;

protected function fun_667
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_i1)
    local
      Tpl.Text txt;
      Integer a_i1;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;
      DAE.Type i_ty;
      Tpl.Text l_typeStr;
      Tpl.Text l_dimStr;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = i_ty, name = i_name)),
           a_i1 )
      equation
        l_dimStr = fun_666(Tpl.emptyTxt, i_ty);
        l_typeStr = varType(Tpl.emptyTxt, i_var);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeText(txt, l_dimStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_i1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr c"));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; /* "));
        txt = Tpl.writeStr(txt, i_name_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_667;

protected function lm_668
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_667(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_668(txt, rest);
      then txt;
  end match;
end lm_668;

protected function fun_669
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fargsStr;
  input String in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fargsStr, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStr;
      String a_fname;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           {},
           a_fargsStr,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void _"
                                }, false));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData, "));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           i_outVars,
           a_fargsStr,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_rettype_s {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_668(txt, i_outVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_rettype;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype omc_"));
        txt = Tpl.writeStr(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(threadData_t *threadData, "));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;
  end match;
end fun_669;

public function functionHeaderKernelFunctionInterface
  input Tpl.Text txt;
  input String a_fname;
  input list<SimCode.Variable> a_fargs;
  input list<SimCode.Variable> a_outVars;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fargsStr;
algorithm
  l_fargsStr := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_fargsStr := lm_664(l_fargsStr, a_fargs);
  l_fargsStr := Tpl.popIter(l_fargsStr);
  out_txt := fun_669(txt, a_outVars, l_fargsStr, a_fname);
end functionHeaderKernelFunctionInterface;

protected function fun_671
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_var, in_a_auxFunction)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name),
           a_auxFunction )
      equation
        (txt, a_auxFunction) = contextCref(txt, i_name, SimCode.contextFunction, a_auxFunction);
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, i_name_1);
      then (txt, a_auxFunction);

    case ( txt,
           _,
           a_auxFunction )
      then (txt, a_auxFunction);
  end match;
end fun_671;

public function funArgName
  input Tpl.Text txt;
  input SimCode.Variable a_var;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  (out_txt, l_auxFunction) := fun_671(txt, a_var, l_auxFunction);
end funArgName;

protected function fun_673
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_var, in_a_auxFunction)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)),
           a_auxFunction )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        (txt, a_auxFunction) = contextCref(txt, i_name, SimCode.contextFunction, a_auxFunction);
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr _"));
        txt = Tpl.writeStr(txt, i_name_1);
      then (txt, a_auxFunction);

    case ( txt,
           _,
           a_auxFunction )
      then (txt, a_auxFunction);
  end match;
end fun_673;

public function funArgDefinition
  input Tpl.Text txt;
  input SimCode.Variable a_var;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  (out_txt, l_auxFunction) := fun_673(txt, a_var, l_auxFunction);
end funArgDefinition;

protected function fun_675
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_var, in_a_auxFunction)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = DAE.T_ARRAY(ty = _), parallelism = DAE.PARGLOBAL(), name = i_name)),
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("device_"));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        (txt, a_auxFunction) = contextCref(txt, i_name, SimCode.contextFunction, a_auxFunction);
      then (txt, a_auxFunction);

    case ( txt,
           (i_var as SimCode.VARIABLE(ty = DAE.T_ARRAY(ty = _), parallelism = DAE.PARLOCAL(), name = i_name)),
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("device_local_"));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        (txt, a_auxFunction) = contextCref(txt, i_name, SimCode.contextFunction, a_auxFunction);
      then (txt, a_auxFunction);

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)),
           a_auxFunction )
      equation
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        (txt, a_auxFunction) = contextCref(txt, i_name, SimCode.contextFunction, a_auxFunction);
      then (txt, a_auxFunction);

    case ( txt,
           _,
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Invalid function argument to Kernel function Interface."));
      then (txt, a_auxFunction);
  end match;
end fun_675;

public function funArgDefinitionKernelFunctionInterface
  input Tpl.Text txt;
  input SimCode.Variable a_var;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  (out_txt, l_auxFunction) := fun_675(txt, a_var, l_auxFunction);
end funArgDefinitionKernelFunctionInterface;

protected function fun_677
  input Tpl.Text in_txt;
  input DAE.VarParallelism in_a_parallelism;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_parallelism, in_a_varName, in_a_var_ty)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;

    case ( txt,
           DAE.PARGLOBAL(),
           a_varName,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* data_"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    __global modelica_integer* info_"));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           DAE.PARLOCAL(),
           a_varName,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* data_"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    __global modelica_integer* info_"));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_677;

protected function fun_678
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.VarParallelism in_a_parallelism;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_parallelism, in_a_varName, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.VarParallelism a_parallelism;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;

    case ( txt,
           {},
           _,
           a_varName,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           a_parallelism,
           a_varName,
           a_var_ty )
      equation
        txt = fun_677(txt, a_parallelism, a_varName, a_var_ty);
      then txt;
  end match;
end fun_678;

protected function fun_679
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_var, in_a_auxFunction)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      DAE.VarParallelism i_parallelism;
      list<DAE.Exp> i_instDims;
      DAE.Type i_var_ty;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = (i_var_ty as DAE.T_ARRAY(ty = _)), parallelism = DAE.PARGLOBAL(), name = i_var_name),
           a_auxFunction )
      equation
        (l_varName, a_auxFunction) = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction, a_auxFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_"));
        txt = expTypeShort(txt, i_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* data_"));
        txt = Tpl.writeText(txt, l_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    __global modelica_integer* info_"));
        txt = Tpl.writeText(txt, l_varName);
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.VARIABLE(ty = (i_var_ty as DAE.T_ARRAY(ty = _)), parallelism = DAE.PARLOCAL(), name = i_var_name),
           a_auxFunction )
      equation
        (l_varName, a_auxFunction) = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction, a_auxFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__local modelica_"));
        txt = expTypeShort(txt, i_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* data_"));
        txt = Tpl.writeText(txt, l_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    __local modelica_integer* info_"));
        txt = Tpl.writeText(txt, l_varName);
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty, parallelism = i_parallelism),
           a_auxFunction )
      equation
        (l_varName, a_auxFunction) = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction, a_auxFunction);
        txt = fun_678(txt, i_instDims, i_parallelism, l_varName, i_var_ty);
      then (txt, a_auxFunction);

    case ( txt,
           _,
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#error Unknown variable type in as function argument funArgDefinitionKernelFunctionBody"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_auxFunction);
  end match;
end fun_679;

public function funArgDefinitionKernelFunctionBody
  input Tpl.Text txt;
  input SimCode.Variable a_var;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  (out_txt, l_auxFunction) := fun_679(txt, a_var, l_auxFunction);
end funArgDefinitionKernelFunctionBody;

protected function fun_681
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_parArgList;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_parArgList;
algorithm
  (out_txt, out_a_parArgList) :=
  match(in_txt, in_a_instDims, in_a_varName, in_a_var_ty, in_a_parArgList)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_parArgList;

    case ( txt,
           {},
           a_varName,
           a_var_ty,
           a_parArgList )
      equation
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    modelica_"));
        a_parArgList = expTypeShort(a_parArgList, a_var_ty);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(" "));
        a_parArgList = Tpl.writeText(a_parArgList, a_varName);
      then (txt, a_parArgList);

    case ( txt,
           _,
           a_varName,
           a_var_ty,
           a_parArgList )
      equation
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    __global modelica_"));
        a_parArgList = expTypeShort(a_parArgList, a_var_ty);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("* data_"));
        a_parArgList = Tpl.writeText(a_parArgList, a_varName);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    __global modelica_integer* info_"));
        a_parArgList = Tpl.writeText(a_parArgList, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_parArgList);
  end match;
end fun_681;

protected function fun_682
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_parArgList;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_parArgList;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_parArgList, out_a_auxFunction) :=
  match(in_txt, in_a_var, in_a_parArgList, in_a_auxFunction)
    local
      Tpl.Text txt;
      Tpl.Text a_parArgList;
      Tpl.Text a_auxFunction;
      list<DAE.Exp> i_instDims;
      DAE.Type i_var_ty;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = (i_var_ty as DAE.T_ARRAY(ty = _)), name = i_var_name),
           a_parArgList,
           a_auxFunction )
      equation
        (l_varName, a_auxFunction) = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction, a_auxFunction);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    __global modelica_"));
        a_parArgList = expTypeShort(a_parArgList, i_var_ty);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("* data_"));
        a_parArgList = Tpl.writeText(a_parArgList, l_varName);
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING(","));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("    __global modelica_integer* info_"));
        a_parArgList = Tpl.writeText(a_parArgList, l_varName);
      then (txt, a_parArgList, a_auxFunction);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty),
           a_parArgList,
           a_auxFunction )
      equation
        (l_varName, a_auxFunction) = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction, a_auxFunction);
        (txt, a_parArgList) = fun_681(txt, i_instDims, l_varName, i_var_ty, a_parArgList);
      then (txt, a_parArgList, a_auxFunction);

    case ( txt,
           _,
           a_parArgList,
           a_auxFunction )
      equation
        a_parArgList = Tpl.pushBlock(a_parArgList, Tpl.BT_INDENT(4));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_STRING("#error Unknown variable type in as function argument funArgDefinitionKernelFunctionBody2"));
        a_parArgList = Tpl.writeTok(a_parArgList, Tpl.ST_NEW_LINE());
        a_parArgList = Tpl.popBlock(a_parArgList);
      then (txt, a_parArgList, a_auxFunction);
  end match;
end fun_682;

public function funArgDefinitionKernelFunctionBody2
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input Tpl.Text a_parArgList;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_parArgList;
protected
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  (out_txt, out_a_parArgList, l_auxFunction) := fun_682(txt, a_var, a_parArgList, l_auxFunction);
end funArgDefinitionKernelFunctionBody2;

protected function fun_684
  input Tpl.Text in_txt;
  input DAE.Type in_a_cref_identType;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cref_identType, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)),
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_integer* data_"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_integer* info_"));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_REAL(varLst = _)),
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_real* data_"));
        txt = Tpl.writeText(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__global modelica_integer* info_"));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Template error in parFunArgDefinitionFromLooptupleVar"));
      then txt;
  end match;
end fun_684;

protected function fun_685
  input Tpl.Text in_txt;
  input DAE.Type in_a_cref_identType;
  input Tpl.Text in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cref_identType, in_a_varName)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_integer "));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_varName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_real "));
        txt = Tpl.writeText(txt, a_varName);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Tempalte error in parFunArgDefinitionFromLooptupleVar"));
      then txt;
  end match;
end fun_685;

public function parFunArgDefinitionFromLooptupleVar
  input Tpl.Text in_txt;
  input tuple<DAE.ComponentRef, Absyn.Info> in_a_tupleVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_tupleVar)
    local
      Tpl.Text txt;
      DAE.Type i_cref_identType;
      DAE.ComponentRef i_cref;
      Tpl.Text l_varName;

    case ( txt,
           ((i_cref as DAE.CREF_IDENT(identType = (i_cref_identType as DAE.T_ARRAY(ty = _)))), _) )
      equation
        l_varName = contextArrayCref(Tpl.emptyTxt, i_cref, SimCode.contextParallelFunction);
        txt = fun_684(txt, i_cref_identType, l_varName);
      then txt;

    case ( txt,
           ((i_cref as DAE.CREF_IDENT(identType = i_cref_identType)), _) )
      equation
        l_varName = contextArrayCref(Tpl.emptyTxt, i_cref, SimCode.contextParallelFunction);
        txt = fun_685(txt, i_cref_identType, l_varName);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end parFunArgDefinitionFromLooptupleVar;

protected function fun_687
  input Tpl.Text in_txt;
  input DAE.Type in_a_cref_identType;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_reconstructedArrs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstructedArrs;
algorithm
  (out_txt, out_a_reconstructedArrs) :=
  match(in_txt, in_a_cref_identType, in_a_varName, in_a_reconstructedArrs)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      Tpl.Text a_reconstructedArrs;

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_INTEGER(varLst = _)),
           a_varName,
           a_reconstructedArrs )
      equation
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("integer_array "));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".data = data_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".ndims = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("[0]; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".dim_size = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(" + 1; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs);

    case ( txt,
           DAE.T_ARRAY(ty = DAE.T_REAL(varLst = _)),
           a_varName,
           a_reconstructedArrs )
      equation
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("real_array "));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".data = data_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".ndims = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("[0]; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".dim_size = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(" + 1; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs);

    case ( txt,
           _,
           _,
           a_reconstructedArrs )
      equation
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("#wiered variable in kerenl reconstruction of arrays"));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs);
  end match;
end fun_687;

public function reconstructKernelArraysFromLooptupleVars
  input Tpl.Text in_txt;
  input tuple<DAE.ComponentRef, Absyn.Info> in_a_tupleVar;
  input Tpl.Text in_a_reconstructedArrs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstructedArrs;
algorithm
  (out_txt, out_a_reconstructedArrs) :=
  match(in_txt, in_a_tupleVar, in_a_reconstructedArrs)
    local
      Tpl.Text txt;
      Tpl.Text a_reconstructedArrs;
      DAE.Type i_cref_identType;
      DAE.ComponentRef i_cref;
      Tpl.Text l_varName;

    case ( txt,
           ((i_cref as DAE.CREF_IDENT(identType = (i_cref_identType as DAE.T_ARRAY(ty = _)))), _),
           a_reconstructedArrs )
      equation
        l_varName = contextArrayCref(Tpl.emptyTxt, i_cref, SimCode.contextParallelFunction);
        (txt, a_reconstructedArrs) = fun_687(txt, i_cref_identType, l_varName, a_reconstructedArrs);
      then (txt, a_reconstructedArrs);

    case ( txt,
           _,
           a_reconstructedArrs )
      then (txt, a_reconstructedArrs);
  end match;
end reconstructKernelArraysFromLooptupleVars;

protected function fun_689
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_varName;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_reconstructedArrs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstructedArrs;
algorithm
  (out_txt, out_a_reconstructedArrs) :=
  match(in_txt, in_a_instDims, in_a_varName, in_a_var_ty, in_a_reconstructedArrs)
    local
      Tpl.Text txt;
      Tpl.Text a_varName;
      DAE.Type a_var_ty;
      Tpl.Text a_reconstructedArrs;

    case ( txt,
           {},
           _,
           _,
           a_reconstructedArrs )
      then (txt, a_reconstructedArrs);

    case ( txt,
           _,
           a_varName,
           a_var_ty,
           a_reconstructedArrs )
      equation
        a_reconstructedArrs = expTypeShort(a_reconstructedArrs, a_var_ty);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("_array "));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".data = data_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".ndims = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("[0]; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".dim_size = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, a_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(" + 1; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_reconstructedArrs);
  end match;
end fun_689;

protected function fun_690
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_reconstructedArrs;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstructedArrs;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_reconstructedArrs, out_a_auxFunction) :=
  match(in_txt, in_a_var, in_a_reconstructedArrs, in_a_auxFunction)
    local
      Tpl.Text txt;
      Tpl.Text a_reconstructedArrs;
      Tpl.Text a_auxFunction;
      list<DAE.Exp> i_instDims;
      DAE.Type i_var_ty;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_varName;

    case ( txt,
           SimCode.VARIABLE(ty = (i_var_ty as DAE.T_ARRAY(ty = _)), parallelism = DAE.PARGLOBAL(), name = i_var_name),
           a_reconstructedArrs,
           a_auxFunction )
      equation
        (l_varName, a_auxFunction) = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction, a_auxFunction);
        a_reconstructedArrs = expTypeShort(a_reconstructedArrs, i_var_ty);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("_array "));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".data = data_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".ndims = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("[0]; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".dim_size = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(" + 1; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs, a_auxFunction);

    case ( txt,
           SimCode.VARIABLE(ty = (i_var_ty as DAE.T_ARRAY(ty = _)), parallelism = DAE.PARLOCAL(), name = i_var_name),
           a_reconstructedArrs,
           a_auxFunction )
      equation
        (l_varName, a_auxFunction) = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction, a_auxFunction);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("local_"));
        a_reconstructedArrs = expTypeShort(a_reconstructedArrs, i_var_ty);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("_array "));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".data = data_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".ndims = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("[0]; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(".dim_size = info_"));
        a_reconstructedArrs = Tpl.writeText(a_reconstructedArrs, l_varName);
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING(" + 1; "));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs, a_auxFunction);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, ty = i_var_ty),
           a_reconstructedArrs,
           a_auxFunction )
      equation
        (l_varName, a_auxFunction) = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextParallelFunction, a_auxFunction);
        (txt, a_reconstructedArrs) = fun_689(txt, i_instDims, l_varName, i_var_ty, a_reconstructedArrs);
      then (txt, a_reconstructedArrs, a_auxFunction);

    case ( txt,
           _,
           a_reconstructedArrs,
           a_auxFunction )
      equation
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_STRING("#wiered variable in kerenl reconstruction of arrays"));
        a_reconstructedArrs = Tpl.writeTok(a_reconstructedArrs, Tpl.ST_NEW_LINE());
      then (txt, a_reconstructedArrs, a_auxFunction);
  end match;
end fun_690;

public function reconstructKernelArrays
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input Tpl.Text a_reconstructedArrs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_reconstructedArrs;
protected
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  (out_txt, out_a_reconstructedArrs, l_auxFunction) := fun_690(txt, a_var, a_reconstructedArrs, l_auxFunction);
end reconstructKernelArrays;

protected function fun_692
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_var, in_a_auxFunction)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      String i_name_1;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCode.VARIABLE(name = i_name),
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype "));
        (txt, a_auxFunction) = contextCref(txt, i_name, SimCode.contextFunction, a_auxFunction);
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr _"));
        txt = Tpl.writeStr(txt, i_name_1);
      then (txt, a_auxFunction);

    case ( txt,
           _,
           a_auxFunction )
      then (txt, a_auxFunction);
  end match;
end fun_692;

public function funArgBoxedDefinition
  input Tpl.Text txt;
  input SimCode.Variable a_var;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  (out_txt, l_auxFunction) := fun_692(txt, a_var, l_auxFunction);
end funArgBoxedDefinition;

protected function lm_694
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_i;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        txt = Tpl.writeStr(txt, i_i);
        txt = Tpl.nextIter(txt);
        txt = lm_694(txt, rest);
      then txt;
  end match;
end lm_694;

protected function fun_695
  input Tpl.Text in_txt;
  input list<String> in_a_includes;
  input Tpl.Text in_a_fargsStrEscaped;
  input Tpl.Text in_a_fargsStr;
  input Tpl.Text in_a_fn__name;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_includes, in_a_fargsStrEscaped, in_a_fargsStr, in_a_fn__name, in_a_extReturn)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStrEscaped;
      Tpl.Text a_fargsStr;
      Tpl.Text a_fn__name;
      SimCode.SimExtArg a_extReturn;

    case ( txt,
           {},
           _,
           a_fargsStr,
           a_fn__name,
           a_extReturn )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern "));
        txt = extReturnType(txt, a_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_fargsStrEscaped,
           _,
           a_fn__name,
           a_extReturn )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*\n",
                                    " * The function has annotation(Include=...>)\n",
                                    " * the external function definition should be present\n",
                                    " * in one of these files and have this prototype:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* extern "));
        txt = extReturnType(txt, a_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStrEscaped);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "*/"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_695;

public function extFunDef
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;
      list<String> i_includes;
      list<SimCode.SimExtArg> i_extArgs;
      String i_language;
      String i_extName;
      Tpl.Text l_includesStr;
      Tpl.Text l_fargsStrEscaped;
      Tpl.Text l_fargsStr;
      Tpl.Text l_fn__name;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extName = i_extName, language = i_language, extArgs = i_extArgs, includes = i_includes, extReturn = i_extReturn) )
      equation
        l_fn__name = extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        l_fargsStrEscaped = CodegenUtil.escapeCComments(Tpl.emptyTxt, Tpl.textString(l_fargsStr));
        l_includesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_includesStr = lm_694(l_includesStr, i_includes);
        l_includesStr = Tpl.popIter(l_includesStr);
        txt = fun_695(txt, i_includes, l_fargsStrEscaped, l_fargsStr, l_fn__name, i_extReturn);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDef;

public function extFunDefDynamic
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_extReturn;
      list<SimCode.SimExtArg> i_extArgs;
      String i_language;
      String i_extName;
      Tpl.Text l_fargsStr;
      Tpl.Text l_fn__name;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extName = i_extName, language = i_language, extArgs = i_extArgs, extReturn = i_extReturn) )
      equation
        l_fn__name = extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef "));
        txt = extReturnType(txt, i_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" (*ptrT_"));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, l_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "extern ptrT_"
                                }, false));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = Tpl.writeText(txt, l_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDefDynamic;

protected function fun_698
  input Tpl.Text in_txt;
  input String in_a_language;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_language, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           "FORTRAN 77",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5377, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_698;

public function extFunctionName
  input Tpl.Text txt;
  input String a_name;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_698(txt, a_language, a_name);
end extFunctionName;

protected function lm_700
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_700(txt, rest);
      then txt;
  end match;
end lm_700;

protected function lm_701
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArgF77(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_701(txt, rest);
      then txt;
  end match;
end lm_701;

protected function fun_702
  input Tpl.Text in_txt;
  input String in_a_language;
  input list<SimCode.SimExtArg> in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_language, in_a_args)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> a_args;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_700(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           "FORTRAN 77",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_701(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5385, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_702;

public function extFunDefArgs
  input Tpl.Text txt;
  input list<SimCode.SimExtArg> a_args;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_702(txt, a_language, a_args);
end extFunDefArgs;

public function extReturnType
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.Type i_type__;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           SimCode.SIMEXTARG(type_ = i_type__) )
      equation
        txt = extType(txt, i_type__, true, false);
      then txt;

    case ( txt,
           SimCode.SIMNOEXTARG() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp) )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Expression types are unsupported as return arguments "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5394, 36), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5395, 14), "Unsupported return argument");
      then txt;
  end match;
end extReturnType;

protected function fun_705
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isInput;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isInput)
    local
      Tpl.Text txt;
      Boolean a_isInput;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char*"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_isInput )
      equation
        txt = extType(txt, i_ty, a_isInput, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void *"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)),
           _ )
      equation
        txt = CodegenUtil.underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr"));
      then txt;

    case ( txt,
           i_type,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external C type "));
        ret_0 = Types.unparseType(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5418, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_705;

protected function fun_706
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "const char*" )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const "));
      then txt;
  end match;
end fun_706;

protected function fun_707
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;
      String str_0;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        str_0 = Tpl.textString(a_s);
        txt = fun_706(txt, str_0);
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end match;
end fun_707;

protected function fun_708
  input Tpl.Text in_txt;
  input Boolean in_a_isInput;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isInput, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Tpl.Text a_s;

    case ( txt,
           false,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_s )
      equation
        txt = fun_707(txt, a_isArray, a_s);
      then txt;
  end match;
end fun_708;

protected function fun_709
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isArray;
  input Boolean in_a_isInput;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isArray, in_a_isInput, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Boolean a_isInput;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_isInput,
           a_s )
      equation
        txt = fun_708(txt, a_isInput, a_isArray, a_s);
      then txt;
  end match;
end fun_709;

public function extType
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isInput;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_705(Tpl.emptyTxt, a_type, a_isInput);
  out_txt := fun_709(txt, a_type, a_isArray, a_isInput, l_s);
end extType;

protected function fun_711
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("char"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = extTypeF77(txt, i_ty, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)) )
      equation
        txt = CodegenUtil.underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void*"));
      then txt;

    case ( txt,
           i_type )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external F77 type "));
        ret_0 = Types.unparseType(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenC.tpl", 5437, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_711;

protected function fun_712
  input Tpl.Text in_txt;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end match;
end fun_712;

protected function fun_713
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isReference;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isReference, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isReference;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isReference,
           a_s )
      equation
        txt = fun_712(txt, a_isReference, a_s);
      then txt;
  end match;
end fun_713;

public function extTypeF77
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isReference;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_711(Tpl.emptyTxt, a_type);
  out_txt := fun_713(txt, a_type, a_isReference, l_s);
end extTypeF77;

protected function fun_715
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_extArg, in_a_auxFunction)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      DAE.Type i_type__;
      Boolean i_ia;
      Boolean i_ii;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = i_ii, isArray = i_ia, type_ = i_t),
           a_auxFunction )
      equation
        (l_name, a_auxFunction) = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction, a_auxFunction);
        l_typeStr = extType(Tpl.emptyTxt, i_t, i_ii, i_ia);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__),
           a_auxFunction )
      equation
        l_typeStr = extType(Tpl.emptyTxt, i_type__, true, false);
        txt = Tpl.writeText(txt, l_typeStr);
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _),
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then (txt, a_auxFunction);

    case ( txt,
           _,
           a_auxFunction )
      then (txt, a_auxFunction);
  end match;
end fun_715;

public function extFunDefArg
  input Tpl.Text txt;
  input SimCode.SimExtArg a_extArg;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  (out_txt, l_auxFunction) := fun_715(txt, a_extArg, l_auxFunction);
end extFunDefArg;

protected function fun_717
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_a_extArg, in_a_auxFunction)
    local
      Tpl.Text txt;
      Tpl.Text a_auxFunction;
      DAE.Type i_type__;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, type_ = i_t),
           a_auxFunction )
      equation
        (l_name, a_auxFunction) = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction, a_auxFunction);
        l_typeStr = extTypeF77(Tpl.emptyTxt, i_t, true);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__),
           a_auxFunction )
      equation
        txt = extTypeF77(txt, i_type__, true);
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _),
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int *"));
      then (txt, a_auxFunction);

    case ( txt,
           _,
           a_auxFunction )
      then (txt, a_auxFunction);
  end match;
end fun_717;

public function extFunDefArgF77
  input Tpl.Text txt;
  input SimCode.SimExtArg a_extArg;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_auxFunction;
algorithm
  l_auxFunction := Tpl.emptyTxt;
  (out_txt, l_auxFunction) := fun_717(txt, a_extArg, l_auxFunction);
end extFunDefArgF77;

protected function fun_719
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = CodegenUtil.underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = CodegenUtil.dotPath(txt, a_name);
      then txt;
  end match;
end fun_719;

protected function fun_720
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = CodegenUtil.underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = CodegenUtil.dotPath(txt, a_name);
      then txt;
  end match;
end fun_720;

protected function fun_721
  input Tpl.Text in_txt;
  input Boolean in_a_dotPath;
  input Absyn.Path in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dotPath, in_a_name)
    local
      Tpl.Text txt;
      Absyn.Path a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = CodegenUtil.underscorePath(txt, a_name);
      then txt;

    case ( txt,
           _,
           a_name )
      equation
        txt = CodegenUtil.dotPath(txt, a_name);
      then txt;
  end match;
end fun_721;

public function functionName
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_dotPath;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_dotPath)
    local
      Tpl.Text txt;
      Boolean a_dotPath;
      Absyn.Path i_name;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_719(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name),
           a_dotPath )
      equation
        txt = fun_720(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name),
           a_dotPath )
      equation
        txt = fun_721(txt, a_dotPath, i_name);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionName;

protected function lm_723
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input Boolean in_a_isSimulation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_isSimulation)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Boolean a_isSimulation;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_isSimulation )
      equation
        txt = functionBody(txt, i_fn, false, a_isSimulation);
        txt = Tpl.nextIter(txt);
        txt = lm_723(txt, rest, a_isSimulation);
      then txt;
  end match;
end lm_723;

public function functionBodies
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input Boolean a_isSimulation;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_723(out_txt, a_functions, a_isSimulation);
  out_txt := Tpl.popIter(out_txt);
end functionBodies;

protected function lm_725
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = functionBodyParModelica(txt, i_fn, false);
        txt = Tpl.nextIter(txt);
        txt = lm_725(txt, rest);
      then txt;
  end match;
end lm_725;

public function functionBodiesParModelica
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_725(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end functionBodiesParModelica;

public function functionBody
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input Boolean in_a_isSimulation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc, in_a_isSimulation)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      Boolean a_isSimulation;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_inFunc,
           a_isSimulation )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc, a_isSimulation);
      then txt;

    case ( txt,
           (i_fn as SimCode.KERNEL_FUNCTION(name = _)),
           a_inFunc,
           _ )
      equation
        txt = functionBodyKernelFunctionInterface(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_inFunc,
           a_isSimulation )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc, a_isSimulation);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           _,
           a_isSimulation )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn, a_isSimulation);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionBody;

public function functionBodyParModelica
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = extractParforBodies(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.KERNEL_FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyKernelFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           (i_fn as SimCode.PARALLEL_FUNCTION(name = _)),
           a_inFunc )
      equation
        txt = functionBodyParallelFunction(txt, i_fn, a_inFunc);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionBodyParModelica;

protected function lm_729
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        (txt, a_varDecls, a_auxFunction) = extractParFors(txt, i_stmt, a_varDecls, a_auxFunction);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls) = lm_729(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_729;

protected function fun_730
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Statement> i_body;
      Tpl.Text l_bodyPart;
      Tpl.Text l_auxFunction;
      Tpl.Text l_varDecls;

    case ( txt,
           SimCode.FUNCTION(body = i_body) )
      equation
        System.tmpTickReset(1);
        System.tmpTickResetIndex(0, 1);
        l_varDecls = Tpl.emptyTxt;
        l_auxFunction = Tpl.emptyTxt;
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_auxFunction, l_varDecls) = lm_729(l_bodyPart, i_body, l_auxFunction, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        txt = Tpl.writeText(txt, l_auxFunction);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bodyPart);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_730;

public function extractParforBodies
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input Boolean a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_730(txt, a_fn);
end extractParforBodies;

protected function lm_732
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varFrees;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varFrees, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varFrees, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varFrees;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_auxFunction,
           a_varFrees,
           a_varInits,
           a_varDecls )
      then (txt, a_auxFunction, a_varFrees, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_auxFunction,
           a_varFrees,
           a_varInits,
           a_varDecls )
      equation
        (txt, a_varDecls, a_varInits, a_varFrees, a_auxFunction) = varInit(txt, i_var, "", a_varDecls, a_varInits, a_varFrees, a_auxFunction);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varFrees, a_varInits, a_varDecls) = lm_732(txt, rest, a_auxFunction, a_varFrees, a_varInits, a_varDecls);
      then (txt, a_auxFunction, a_varFrees, a_varInits, a_varDecls);
  end match;
end lm_732;

protected function lm_733
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           a_auxFunction,
           a_varDecls )
      then (txt, a_auxFunction, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_auxFunction,
           a_varDecls )
      equation
        (txt, a_varDecls, a_auxFunction) = funStatement(txt, i_stmt, a_varDecls, a_auxFunction);
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction, a_varDecls) = lm_733(txt, rest, a_auxFunction, a_varDecls);
      then (txt, a_auxFunction, a_varDecls);
  end match;
end lm_733;

protected function lm_734
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_outVarAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
algorithm
  (out_txt, out_a_outVarAssign) :=
  match(in_txt, in_items, in_a_outVarAssign)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_outVarAssign;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_outVarAssign )
      then (txt, a_outVarAssign);

    case ( txt,
           i_var :: rest,
           a_outVarAssign )
      equation
        (txt, a_outVarAssign) = varOutput(txt, i_var, a_outVarAssign);
        (txt, a_outVarAssign) = lm_734(txt, rest, a_outVarAssign);
      then (txt, a_outVarAssign);
  end match;
end lm_734;

protected function lm_735
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_auxFunction;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
algorithm
  (out_txt, out_a_auxFunction) :=
  match(in_txt, in_items, in_a_auxFunction)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_auxFunction;
      DAE.ComponentRef i_var_name;
      Absyn.Path i_path__ext;

    case ( txt,
           {},
           a_auxFunction )
      then (txt, a_auxFunction);

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = i_path__ext)), name = i_var_name) :: rest,
           a_auxFunction )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("omc_"));
        txt = CodegenUtil.underscorePath(txt, i_path__ext);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_destructor(threadData,"));
        (txt, a_auxFunction) = contextCref(txt, i_var_name, SimCode.contextFunction, a_auxFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunction) = lm_735(txt, rest, a_auxFunction);
      then (txt, a_auxFunction);

    case ( txt,
           _ :: rest,
           a_auxFunction )
      equation
        (txt, a_auxFunction) = lm_735(txt, rest, a_auxFunction);
      then (txt, a_auxFunction);
  end match;
end lm_735;

protected function fun_736
  input Tpl.Text in_txt;
  input SCode.Visibility in_a_visibility;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_visibility)
    local
      Tpl.Text txt;

    case ( txt,
           SCode.PUBLIC() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLExport"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_736;

protected function fun_737
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_varFrees;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varFrees)
    local
      Tpl.Text txt;
      Tpl.Text a_varFrees;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_varFrees )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* Free GPU/OpenCL CPU memory */"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_varFrees);
      then txt;
  end match;
end fun_737;

protected function fun_738
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      SimCode.Variable i_v;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return;"));
      then txt;

    case ( txt,
           i_v :: _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = funArgName(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_738;

protected function fun_739
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input list<SimCode.Variable> in_a_outVars;
  input list<SimCode.Variable> in_a_functionArguments;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_fname;
algorithm
  (out_txt, out_a_fname) :=
  match(in_txt, in_a_inFunc, in_a_outVars, in_a_functionArguments, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      list<SimCode.Variable> a_functionArguments;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           a_fname )
      then (txt, a_fname);

    case ( txt,
           _,
           a_outVars,
           a_functionArguments,
           a_fname )
      equation
        (txt, a_fname) = generateInFunc(txt, a_fname, a_functionArguments, a_outVars);
      then (txt, a_fname);
  end match;
end fun_739;

public function functionBodyRegularFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input Boolean in_a_isSimulation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc, in_a_isSimulation)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      Boolean a_isSimulation;
      list<SimCode.Variable> i_functionArguments;
      SCode.Visibility i_visibility;
      SimCode.Function i_fn;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_variableDeclarations;
      Absyn.Path i_name;
      Boolean ret_15;
      Tpl.Text l_boxedFn;
      Tpl.Text l_freeConstructedExternalObjects;
      list<SimCode.Variable> ret_12;
      Tpl.Text l_0___1;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarInits;
      Tpl.Text l_bodyPart;
      Tpl.Text l_0__;
      Tpl.Text l_auxFunction_1;
      Tpl.Text l_varFrees;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_fname;
      Tpl.Text l_auxFunction;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, variableDeclarations = i_variableDeclarations, body = i_body, outVars = i_outVars, visibility = i_visibility, functionArguments = i_functionArguments)),
           a_inFunc,
           a_isSimulation )
      equation
        l_auxFunction = Tpl.emptyTxt;
        System.tmpTickReset(1);
        System.tmpTickResetIndex(0, 1);
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_varFrees = Tpl.emptyTxt;
        l_auxFunction_1 = Tpl.emptyTxt;
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_auxFunction_1, l_varFrees, l_varInits, l_varDecls) = lm_732(l_0__, i_variableDeclarations, l_auxFunction_1, l_varFrees, l_varInits, l_varDecls);
        l_0__ = Tpl.popIter(l_0__);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_auxFunction_1, l_varDecls) = lm_733(l_bodyPart, i_body, l_auxFunction_1, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        l_outVarInits = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        l_outVarAssign = Tpl.emptyTxt;
        ret_12 = List.restOrEmpty(i_outVars);
        (l_0___1, l_outVarAssign) = lm_734(Tpl.emptyTxt, ret_12, l_outVarAssign);
        l_freeConstructedExternalObjects = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_freeConstructedExternalObjects, l_auxFunction_1) = lm_735(l_freeConstructedExternalObjects, i_variableDeclarations, l_auxFunction_1);
        l_freeConstructedExternalObjects = Tpl.popIter(l_freeConstructedExternalObjects);
        l_varDecls = addRootsTempArray(l_varDecls);
        l_boxedFn = functionBodyBoxed(Tpl.emptyTxt, i_fn, a_isSimulation);
        txt = Tpl.writeText(txt, l_auxFunction_1);
        txt = Tpl.softNewLine(txt);
        txt = fun_736(txt, i_visibility);
        txt = Tpl.softNewLine(txt);
        txt = functionPrototype(txt, Tpl.textString(l_fname), i_functionArguments, i_outVars, false, i_visibility, a_isSimulation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_tailrecursive: OMC_LABEL_UNUSED\n",
                                    "TRACE_PUSH\n"
                                }, true));
        txt = Tpl.writeText(txt, l_outVarInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_return: OMC_LABEL_UNUSED\n"));
        txt = Tpl.writeText(txt, l_outVarCopy);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_outVarAssign);
        txt = Tpl.softNewLine(txt);
        ret_15 = Config.acceptParModelicaGrammar();
        txt = fun_737(txt, ret_15, l_varFrees);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_freeConstructedExternalObjects);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("TRACE_POP\n"));
        txt = fun_738(txt, i_outVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        (txt, l_fname) = fun_739(txt, a_inFunc, i_outVars, i_functionArguments, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_boxedFn);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionBodyRegularFunction;

protected function fun_741
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (!mmc_GC_state) mmc_GC_init();"));
      then txt;
  end match;
end fun_741;

protected function lm_742
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_742(txt, rest);
      then txt;
  end match;
end lm_742;

protected function lm_743
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = funArgDefinition(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_743(txt, rest);
      then txt;
  end match;
end lm_743;

protected function lm_744
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = readInVar(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_744(txt, rest);
      then txt;
  end match;
end lm_744;

protected function fun_745
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      SimCode.Variable i_v;

    case ( txt,
           i_v :: _ )
      equation
        txt = funArgName(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_745;

protected function lm_746
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = funArgName(txt, i_var);
        txt = lm_746(txt, rest);
      then txt;
  end match;
end lm_746;

protected function lm_747
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &"));
        txt = funArgName(txt, i_var);
        txt = lm_747(txt, rest);
      then txt;
  end match;
end lm_747;

protected function fun_748
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;
      SimCode.Variable i_first;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_noretcall(outVar);"));
      then txt;

    case ( txt,
           i_first :: _ )
      equation
        txt = writeOutVar(txt, i_first);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_748;

protected function lm_749
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = writeOutVar(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_749(txt, rest);
      then txt;
  end match;
end lm_749;

protected function fun_750
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("terminateHpcOmThreads();"));
      then txt;
  end match;
end fun_750;

public function generateInFunc
  input Tpl.Text txt;
  input Tpl.Text a_fname;
  input list<SimCode.Variable> a_functionArguments;
  input list<SimCode.Variable> a_outVars;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_fname;
protected
  Boolean ret_4;
  Tpl.Text txt_3;
  list<SimCode.Variable> ret_2;
  list<SimCode.Variable> ret_1;
  Boolean ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "DLLExport\n",
                                   "int in_"
                               }, false));
  out_txt := Tpl.writeText(out_txt, a_fname);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "(type_description * inArgs, type_description * outVar)\n",
                                       "{\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_0 := Config.acceptMetaModelicaGrammar();
  out_txt := fun_741(out_txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_742(out_txt, a_functionArguments);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_743(out_txt, a_outVars);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_744(out_txt, a_functionArguments);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "MMC_INIT();\n",
                                       "MMC_TRY_TOP()\n"
                                   }, true));
  out_txt := fun_745(out_txt, a_outVars);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("omc_"));
  out_txt := Tpl.writeText(out_txt, a_fname);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("(threadData"));
  out_txt := lm_746(out_txt, a_functionArguments);
  ret_1 := List.restOrEmpty(a_outVars);
  out_txt := lm_747(out_txt, ret_1);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       ");\n",
                                       "MMC_CATCH_TOP(return 1)\n"
                                   }, true));
  out_txt := fun_748(out_txt, a_outVars);
  out_txt := Tpl.softNewLine(out_txt);
  ret_2 := List.restOrEmpty(a_outVars);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_749(out_txt, ret_2);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "fflush(NULL);\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "#ifdef GENERATE_MAIN_EXECUTABLE\n",
                                       "static int rml_execution_failed()\n",
                                       "{\n",
                                       "  fflush(NULL);\n",
                                       "  fprintf(stderr, \"Execution failed!\\n\");\n",
                                       "  fflush(NULL);\n",
                                       "  return 1;\n",
                                       "}\n",
                                       "\n",
                                       "int main(int argc, char **argv) {\n",
                                       "  MMC_INIT();\n",
                                       "  {\n",
                                       "  void *lst = mmc_mk_nil();\n",
                                       "  int i = 0;\n",
                                       "\n",
                                       "  for (i=argc-1; i>0; i--) {\n",
                                       "    lst = mmc_mk_cons(mmc_mk_scon(argv[i]), lst);\n",
                                       "  }\n",
                                       "\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  txt_3 := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("omc_"));
  txt_3 := Tpl.writeText(txt_3, a_fname);
  txt_3 := Tpl.writeTok(txt_3, Tpl.ST_STRING("(threadData, lst);"));
  (out_txt, txt_3) := mainTop(out_txt, txt_3, "https://trac.openmodelica.org/OpenModelica/newticket");
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "\n"
                                   }, true));
  ret_4 := Flags.isSet(Flags.HPCOM);
  out_txt := fun_750(out_txt, ret_4);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "fflush(NULL);\n",
                                       "EXIT(0);\n",
                                       "return 0;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "}\n",
                                       "#endif"
                                   }, false));
  out_a_fname := a_fname;
end generateInFunc;

protected function lm_752
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Tpl.Text in_a_auxFunction;
  input Tpl.Text in_a_varFrees;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunction;
  output Tpl.Text out_a_varFrees;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_auxFunction, out_a_varFrees, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_auxFunction, in_a_varFrees, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Tpl.Text a_auxFunction;
      Tpl.Text a_varFrees;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      SimCode.Variable i_var;

    case ( txt,
           {},
           a_auxFunction,
        