encapsulated package CodegenCpp
"
  file:        CodegenCpp.mo
  package:     CodegenCpp
  description: Generated by Susan.
"

public import Tpl;

public import SimCodeVar;
public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import SCodeDump;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCodeMain;
public import HpcOmSimCode;
public import HpcOmMemory;
public import HpcOmScheduler;
public import CodegenUtil;

protected function lm_36
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_eqs, _, _) :: rest,
           a_simCode )
      equation
        txt = algloopfiles(txt, i_eqs, a_simCode, SimCode.contextAlgloopJacobian, false);
        txt = Tpl.nextIter(txt);
        txt = lm_36(txt, rest, a_simCode);
      then txt;
  end match;
end lm_36;

protected function lm_37
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      SimCode.SimCode a_simCode;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_mat, _, _, _, _, _, _) :: rest,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_36(txt, i_mat, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_37(txt, rest, a_simCode);
      then txt;
  end match;
end lm_37;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      list<String> i_externalFunctionIncludes;
      list<DAE.Exp> i_literals;
      list<SimCode.Function> i_modelInfo_functions;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_47;
      Tpl.Text txt_46;
      Tpl.Text txt_45;
      Tpl.Text txt_44;
      list<SimCode.SimEqSystem> ret_43;
      list<SimCode.SimEqSystem> ret_42;
      Tpl.Text l_alg;
      Tpl.Text l_jac;
      Tpl.Text txt_39;
      Tpl.Text txt_38;
      Tpl.Text txt_37;
      Tpl.Text txt_36;
      Tpl.Text txt_35;
      Tpl.Text txt_34;
      Tpl.Text txt_33;
      Tpl.Text txt_32;
      Tpl.Text txt_31;
      Tpl.Text txt_30;
      Tpl.Text txt_29;
      Tpl.Text txt_28;
      Tpl.Text txt_27;
      Tpl.Text txt_26;
      Tpl.Text txt_25;
      Tpl.Text txt_24;
      Tpl.Text txt_23;
      Tpl.Text txt_22;
      Tpl.Text txt_21;
      Tpl.Text txt_20;
      Tpl.Text txt_19;
      Tpl.Text txt_18;
      Tpl.Text txt_17;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text l_target;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, literals = i_literals, externalFunctionIncludes = i_externalFunctionIncludes, jacobianMatrixes = i_jacobianMatrixes, allEquations = i_allEquations, initialEquations = i_initialEquations)),
           a_useFlatArrayNotation )
      equation
        ret_1 = Config.simulationCodeTarget();
        l_target = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        txt_2 = simulationMainFile(Tpl.emptyTxt, i_simCode);
        txt_3 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_3 = Tpl.writeStr(txt_3, i_fileNamePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("Main.cpp"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        txt_4 = simulationHeaderFile(Tpl.emptyTxt, i_simCode, "", "", true, false);
        txt_5 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_5 = Tpl.writeStr(txt_5, i_fileNamePrefix);
        txt_5 = Tpl.writeTok(txt_5, Tpl.ST_STRING(".h"));
        Tpl.textFile(txt_4, Tpl.textString(txt_5));
        txt_6 = simulationCppFile(Tpl.emptyTxt, i_simCode, false);
        txt_7 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_7 = Tpl.writeStr(txt_7, i_fileNamePrefix);
        txt_7 = Tpl.writeTok(txt_7, Tpl.ST_STRING(".cpp"));
        Tpl.textFile(txt_6, Tpl.textString(txt_7));
        txt_8 = simulationFunctionsHeaderFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals, false);
        txt_9 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_9 = Tpl.writeStr(txt_9, i_fileNamePrefix);
        txt_9 = Tpl.writeTok(txt_9, Tpl.ST_STRING("Functions.h"));
        Tpl.textFile(txt_8, Tpl.textString(txt_9));
        txt_10 = simulationFunctionsFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals, i_externalFunctionIncludes, false);
        txt_11 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_11 = Tpl.writeStr(txt_11, i_fileNamePrefix);
        txt_11 = Tpl.writeTok(txt_11, Tpl.ST_STRING("Functions.cpp"));
        Tpl.textFile(txt_10, Tpl.textString(txt_11));
        txt_12 = simulationTypesHeaderFile(Tpl.emptyTxt, i_simCode, i_modelInfo_functions, i_literals, a_useFlatArrayNotation);
        txt_13 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_13 = Tpl.writeStr(txt_13, i_fileNamePrefix);
        txt_13 = Tpl.writeTok(txt_13, Tpl.ST_STRING("Types.h"));
        Tpl.textFile(txt_12, Tpl.textString(txt_13));
        txt_14 = simulationMakefile(Tpl.emptyTxt, Tpl.textString(l_target), i_simCode, "", "", "", "", false);
        txt_15 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_15 = Tpl.writeTok(txt_15, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_14, Tpl.textString(txt_15));
        txt_16 = simulationInitHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_17 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_17 = Tpl.writeStr(txt_17, i_fileNamePrefix);
        txt_17 = Tpl.writeTok(txt_17, Tpl.ST_STRING("Initialize.h"));
        Tpl.textFile(txt_16, Tpl.textString(txt_17));
        txt_18 = simulationInitCppFile(Tpl.emptyTxt, i_simCode, false);
        txt_19 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_19 = Tpl.writeStr(txt_19, i_fileNamePrefix);
        txt_19 = Tpl.writeTok(txt_19, Tpl.ST_STRING("Initialize.cpp"));
        Tpl.textFile(txt_18, Tpl.textString(txt_19));
        txt_20 = simulationJacobianHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_21 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_21 = Tpl.writeStr(txt_21, i_fileNamePrefix);
        txt_21 = Tpl.writeTok(txt_21, Tpl.ST_STRING("Jacobian.h"));
        Tpl.textFile(txt_20, Tpl.textString(txt_21));
        txt_22 = simulationJacobianCppFile(Tpl.emptyTxt, i_simCode, false);
        txt_23 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_23 = Tpl.writeStr(txt_23, i_fileNamePrefix);
        txt_23 = Tpl.writeTok(txt_23, Tpl.ST_STRING("Jacobian.cpp"));
        Tpl.textFile(txt_22, Tpl.textString(txt_23));
        txt_24 = simulationStateSelectionCppFile(Tpl.emptyTxt, i_simCode, false);
        txt_25 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_25 = Tpl.writeStr(txt_25, i_fileNamePrefix);
        txt_25 = Tpl.writeTok(txt_25, Tpl.ST_STRING("StateSelection.cpp"));
        Tpl.textFile(txt_24, Tpl.textString(txt_25));
        txt_26 = simulationStateSelectionHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_27 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_27 = Tpl.writeStr(txt_27, i_fileNamePrefix);
        txt_27 = Tpl.writeTok(txt_27, Tpl.ST_STRING("StateSelection.h"));
        Tpl.textFile(txt_26, Tpl.textString(txt_27));
        txt_28 = simulationExtensionHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_29 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_29 = Tpl.writeStr(txt_29, i_fileNamePrefix);
        txt_29 = Tpl.writeTok(txt_29, Tpl.ST_STRING("Extension.h"));
        Tpl.textFile(txt_28, Tpl.textString(txt_29));
        txt_30 = simulationExtensionCppFile(Tpl.emptyTxt, i_simCode);
        txt_31 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_31 = Tpl.writeStr(txt_31, i_fileNamePrefix);
        txt_31 = Tpl.writeTok(txt_31, Tpl.ST_STRING("Extension.cpp"));
        Tpl.textFile(txt_30, Tpl.textString(txt_31));
        txt_32 = simulationWriteOutputHeaderFile(Tpl.emptyTxt, i_simCode);
        txt_33 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_33 = Tpl.writeStr(txt_33, i_fileNamePrefix);
        txt_33 = Tpl.writeTok(txt_33, Tpl.ST_STRING("WriteOutput.h"));
        Tpl.textFile(txt_32, Tpl.textString(txt_33));
        txt_34 = simulationWriteOutputCppFile(Tpl.emptyTxt, i_simCode, false);
        txt_35 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_35 = Tpl.writeStr(txt_35, i_fileNamePrefix);
        txt_35 = Tpl.writeTok(txt_35, Tpl.ST_STRING("WriteOutput.cpp"));
        Tpl.textFile(txt_34, Tpl.textString(txt_35));
        txt_36 = simulationFactoryFile(Tpl.emptyTxt, i_simCode);
        txt_37 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_37 = Tpl.writeStr(txt_37, i_fileNamePrefix);
        txt_37 = Tpl.writeTok(txt_37, Tpl.ST_STRING("FactoryExport.cpp"));
        Tpl.textFile(txt_36, Tpl.textString(txt_37));
        txt_38 = simulationMainRunScript(Tpl.emptyTxt, i_simCode);
        txt_39 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_39 = simulationMainRunScriptSuffix(txt_39, i_simCode);
        Tpl.textFile(txt_38, Tpl.textString(txt_39));
        l_jac = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jac = lm_37(l_jac, i_jacobianMatrixes, i_simCode);
        l_jac = Tpl.popIter(l_jac);
        ret_42 = listAppend(i_allEquations, i_initialEquations);
        l_alg = algloopfiles(Tpl.emptyTxt, ret_42, i_simCode, SimCode.contextAlgloop, false);
        ret_43 = listAppend(i_allEquations, i_initialEquations);
        txt_44 = algloopMainfile(Tpl.emptyTxt, ret_43, i_simCode, SimCode.contextAlgloop);
        txt_45 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_45 = Tpl.writeStr(txt_45, i_fileNamePrefix);
        txt_45 = Tpl.writeTok(txt_45, Tpl.ST_STRING("AlgLoopMain.cpp"));
        Tpl.textFile(txt_44, Tpl.textString(txt_45));
        txt_46 = calcHelperMainfile(Tpl.emptyTxt, i_simCode);
        txt_47 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OMCpp"));
        txt_47 = Tpl.writeStr(txt_47, i_fileNamePrefix);
        txt_47 = Tpl.writeTok(txt_47, Tpl.ST_STRING("CalcHelperMain.cpp"));
        Tpl.textFile(txt_46, Tpl.textString(txt_47));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end translateModel;

public function translateFunctions
  input Tpl.Text in_txt;
  input SimCode.FunctionCode in_a_functionCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_functionCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.FUNCTIONCODE(name = _) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end translateFunctions;

public function simulationHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_additionalIncludes;
  input String in_a_additionalProtectedMembers;
  input Boolean in_a_useDefaultMemberVariables;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_additionalIncludes, in_a_additionalProtectedMembers, in_a_useDefaultMemberVariables, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      String a_additionalIncludes;
      String a_additionalProtectedMembers;
      Boolean a_useDefaultMemberVariables;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)),
           a_additionalIncludes,
           a_additionalProtectedMembers,
           a_useDefaultMemberVariables,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateHeaderIncludeString(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeStr(txt, a_additionalIncludes);
        txt = Tpl.softNewLine(txt);
        txt = generateClassDeclarationCode(txt, i_simCode, a_additionalProtectedMembers, a_useDefaultMemberVariables, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end simulationHeaderFile;

protected function lm_41
  input Tpl.Text in_txt;
  input list<list<SimCodeVar.SimVar>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCodeVar.SimVar>> rest;
      Integer x_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_idx = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void initializeParameterVars_"));
        txt = Tpl.writeStr(txt, intString(x_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("();"));
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;
  end match;
end lm_41;

protected function lm_42
  input Tpl.Text in_txt;
  input list<list<SimCodeVar.SimVar>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCodeVar.SimVar>> rest;
      Integer x_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_idx = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void initializeIntParameterVars_"));
        txt = Tpl.writeStr(txt, intString(x_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("();"));
        txt = Tpl.nextIter(txt);
        txt = lm_42(txt, rest);
      then txt;
  end match;
end lm_42;

protected function lm_43
  input Tpl.Text in_txt;
  input list<list<SimCodeVar.SimVar>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCodeVar.SimVar>> rest;
      Integer x_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_idx = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void initializeBoolParameterVars_"));
        txt = Tpl.writeStr(txt, intString(x_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("();"));
        txt = Tpl.nextIter(txt);
        txt = lm_43(txt, rest);
      then txt;
  end match;
end lm_43;

protected function fun_44
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Tpl.Text in_a_initeqs;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_initeqs, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      Tpl.Text a_initeqs;
      String a_fileNamePrefix;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      Absyn.Path i_modelInfo_name;
      list<list<SimCodeVar.SimVar>> ret_2;
      list<list<SimCodeVar.SimVar>> ret_1;
      list<list<SimCodeVar.SimVar>> ret_0;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars), name = i_modelInfo_name),
           a_initeqs,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "\n",
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code to initialize the Modelica system\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "\n",
                                    "class "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Initialize: virtual public "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "   public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData);\n",
                                    "virtual ~"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize();\n",
                                    "virtual bool initial();\n",
                                    "virtual void setInitial(bool);\n",
                                    "virtual void initialize();\n",
                                    "virtual  void initEquations();\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" private:\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_initeqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void initializeAlgVars();\n",
                                    "void initializeDiscreteAlgVars();\n",
                                    "void initializeIntAlgVars();\n",
                                    "void initializeBoolAlgVars();\n",
                                    "void initializeAliasVars();\n",
                                    "void initializeIntAliasVars();\n",
                                    "void initializeBoolAliasVars();\n",
                                    "\n"
                                }, true));
        ret_0 = List.partition(i_vars_paramVars, 100);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_41(txt, ret_0);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        ret_1 = List.partition(i_vars_intParamVars, 100);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_42(txt, ret_1);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        ret_2 = List.partition(i_vars_boolParamVars, 100);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_43(txt, ret_2);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "void initializeParameterVars();\n",
                                    "void initializeIntParameterVars();\n",
                                    "void initializeBoolParameterVars();\n",
                                    "void initializeStateVars();\n",
                                    "void initializeDerVars();\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_44;

public function simulationInitHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      SimCode.ModelInfo i_modelInfo;
      list<SimCode.SimEqSystem> i_initialEquations;
      Tpl.Text l_initeqs;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = _))), fileNamePrefix = i_fileNamePrefix, initialEquations = i_initialEquations) )
      equation
        (l_initeqs, _) = generateEquationMemberFuncDecls(Tpl.emptyTxt, i_initialEquations, Tpl.strTokText(Tpl.ST_STRING("initEquation")));
        txt = fun_44(txt, i_modelInfo, l_initeqs, i_fileNamePrefix);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationInitHeaderFile;

protected function lm_46
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_eqs, _, _) :: rest,
           a_simCode )
      equation
        txt = algloopfilesInclude(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_46(txt, rest, a_simCode);
      then txt;
  end match;
end lm_46;

protected function lm_47
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      SimCode.SimCode a_simCode;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_mat, _, _, _, _, _, _) :: rest,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_46(txt, i_mat, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest, a_simCode);
      then txt;
  end match;
end lm_47;

protected function lm_48
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_eqs, _, _) :: rest,
           a_simCode )
      equation
        txt = generatefriendAlgloops(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_48(txt, rest, a_simCode);
      then txt;
  end match;
end lm_48;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      SimCode.SimCode a_simCode;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_mat, _, _, _, _, _, _) :: rest,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_48(txt, i_mat, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest, a_simCode);
      then txt;
  end match;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_name, _, _, _, _) :: rest )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void initialAnalytic"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian();\n",
                                    "void calc"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "JacobianColumn();\n",
                                    "void get"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian(SparseMatrix& matrix);\n",
                                    "/*needed for colored Jacs*/"
                                }, false));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, _, i_name, _, _, _, _) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  private:\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SparseMatrix _"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "jacobian;\n",
                                    "ublas::vector<double> _"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "jac_y;\n",
                                    "ublas::vector<double> _"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "jac_tmp;\n",
                                    "ublas::vector<double> _"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("jac_x;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  public:\n",
                                    "   /*needed for colored Jacs*/\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int  _"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_sizeCols;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int  _"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_sizeRows;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int* _"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_sparsePattern_leadindex;\n",
                                    "int  _"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_sizeof_sparsePattern_leadindex;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int* _"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_sparsePattern_index;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int  _"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_sizeof_sparsePattern_index;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int* _"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_sparsePattern_colorCols;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int  _"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_sizeof_sparsePattern_colorCols;\n",
                                    "int  _"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_sparsePattern_maxColors;\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.JacobianColumn> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianColumn> rest;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_eqs, _, _) :: rest,
           a_simCode )
      equation
        txt = generateAlgloopsolverVariables(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest, a_simCode);
      then txt;
  end match;
end lm_52;

protected function lm_53
  input Tpl.Text in_txt;
  input list<SimCode.JacobianMatrix> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.JacobianMatrix> rest;
      SimCode.SimCode a_simCode;
      list<SimCode.JacobianColumn> i_mat;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_mat, _, _, _, _, _, _) :: rest,
           a_simCode )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_mat, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest, a_simCode);
      then txt;
  end match;
end lm_53;

public function simulationJacobianHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      String i_fileNamePrefix;
      Tpl.Text txt_2;
      Tpl.Text l_jacobianvars;
      Tpl.Text l_jacobianfunctions;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix, jacobianMatrixes = i_jacobianMatrixes)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" #pragma once\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_47(txt, i_jacobianMatrixes, i_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code to initialize the Modelica system\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "class "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Jacobian: virtual public  "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_49(txt, i_jacobianMatrixes, i_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" public:\n"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData);\n",
                                    "virtual ~"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Jacobian();\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " protected:\n",
                                    "  void initialize();\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        l_jacobianfunctions = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jacobianfunctions = lm_50(l_jacobianfunctions, i_jacobianMatrixes);
        l_jacobianfunctions = Tpl.popIter(l_jacobianfunctions);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_jacobianfunctions);
        txt = Tpl.popBlock(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        l_jacobianvars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_jacobianvars = lm_51(l_jacobianvars, i_jacobianMatrixes);
        l_jacobianvars = Tpl.popIter(l_jacobianvars);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_jacobianvars);
        txt = Tpl.popBlock(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" //workaround for jacobian variables\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = variableDefinitionsJacobians(txt, i_jacobianMatrixes, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_53(txt, i_jacobianMatrixes, i_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*testmaessig aus der Cruntime*/\n",
                                    "\n"
                                }, true));
        txt_2 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = functionAnalyticJacobiansHeader(txt, i_jacobianMatrixes, Tpl.textString(txt_2));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationJacobianHeaderFile;

public function simulationStateSelectionHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "\n",
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code to initialize the Modelica system\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "class "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateSelection: virtual public  "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection(IGlobalSettings* globalSettings, boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory, boost::shared_ptr<ISimData> simData);\n",
                                    "virtual ~"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection();\n",
                                    "int getDimStateSets() const;\n",
                                    "int getDimStates(unsigned int index) const;\n",
                                    "int getDimCanditates(unsigned int index) const ;\n",
                                    "int getDimDummyStates(unsigned int index) const ;\n",
                                    "void getStates(unsigned int index,double* z);\n",
                                    "void setStates(unsigned int index,const double* z);\n",
                                    "void getStateCanditates(unsigned int index,double* z);\n",
                                    "bool getAMatrix(unsigned int index, DynArrayDim2<int>& A);\n",
                                    "void setAMatrix(unsigned int index, DynArrayDim2<int>& A);\n",
                                    "bool getAMatrix(unsigned int index, DynArrayDim1<int>& A);\n",
                                    "void setAMatrix(unsigned int index, DynArrayDim1<int>& A);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected:\n",
                                    "  void initialize();\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationStateSelectionHeaderFile;

protected function fun_56
  input Tpl.Text in_txt;
  input String in_a_settings_outputFormat;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_settings_outputFormat)
    local
      Tpl.Text txt;

    case ( txt,
           "mat" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MatFileWriter"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TextFileWriter"));
      then txt;
  end match;
end fun_56;

protected function fun_57
  input Tpl.Text in_txt;
  input String in_a_settings_outputFormat;
  input Tpl.Text in_a_n;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_settings_outputFormat, in_a_n)
    local
      Tpl.Text txt;
      Tpl.Text a_n;

    case ( txt,
           "csv",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _,
           a_n )
      equation
        txt = Tpl.writeText(txt, a_n);
      then txt;
  end match;
end fun_57;

public function simulationWriteOutputHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;
      String i_settings_outputFormat;
      SimCode.ModelInfo i_modelInfo;
      Tpl.Text l_numparams;
      Tpl.Text l_outputtype;
      Tpl.Text l_n;

    case ( txt,
           SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix) )
      equation
        l_n = numProtectedParamVars(Tpl.emptyTxt, i_modelInfo);
        l_outputtype = fun_56(Tpl.emptyTxt, i_settings_outputFormat);
        l_numparams = fun_57(Tpl.emptyTxt, i_settings_outputFormat, l_n);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" #pragma once\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "typedef HistoryImpl<"
                                }, false));
        txt = Tpl.writeText(txt, l_outputtype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = numProtectedAlgvars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numProtectedAliasvars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = numStatevars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = numDerivativevars(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",0,"));
        txt = Tpl.writeText(txt, l_numparams);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "> HistoryImplType;\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code to write simulation file\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "\n",
                                    "\n",
                                    "class "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WriteOutput: virtual public  "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData);\n",
                                    "virtual ~"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput();\n",
                                    "/// Output routine (to be called by the solver after every successful integration step)\n",
                                    "virtual void writeOutput(const IWriteOutput::OUTPUT command = IWriteOutput::UNDEF_OUTPUT);\n",
                                    "virtual IHistory* getHistory();\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected:\n",
                                    "     void initialize();\n",
                                    "\n",
                                    "private:\n",
                                    "     void writeAlgVarsValues(HistoryImplType::value_type_v *v);\n",
                                    "     void writeDiscreteAlgVarsValues(HistoryImplType::value_type_v *v);\n",
                                    "     void writeIntAlgVarsValues(HistoryImplType::value_type_v *v);\n",
                                    "     void writeBoolAlgVarsValues(HistoryImplType::value_type_v *v);\n",
                                    "     void writeAliasVarsValues(HistoryImplType::value_type_v *v);\n",
                                    "     void writeIntAliasVarsValues(HistoryImplType::value_type_v *v);\n",
                                    "     void writeBoolAliasVarsValues(HistoryImplType::value_type_v *v);\n",
                                    "     void writeStateValues(HistoryImplType::value_type_v *v, HistoryImplType::value_type_dv *v2);\n",
                                    "\n",
                                    "     void writeAlgVarsResultNames(vector<string>& names);\n",
                                    "     void writeDiscreteAlgVarsResultNames(vector<string>& names);\n",
                                    "     void writeIntAlgVarsResultNames(vector<string>& names);\n",
                                    "     void writeBoolAlgVarsResultNames(vector<string>& names);\n",
                                    "     void writeAliasVarsResultNames(vector<string>& names);\n",
                                    "     void writeIntAliasVarsResultNames(vector<string>& names);\n",
                                    "     void writeBoolAliasVarsResultNames(vector<string>& names);\n",
                                    "     void writeStateVarsResultNames(vector<string>& names);\n",
                                    "     void writeDerivativeVarsResultNames(vector<string>& names);\n",
                                    "     void writeParametertNames(vector<string>& names);\n",
                                    "     void writeIntParameterNames(vector<string>& names);\n",
                                    "     void writeBoolParameterNames(vector<string>& names);\n",
                                    "\n",
                                    "\n",
                                    "     void writeAlgVarsResultDescription(vector<string>& names);\n",
                                    "     void writeDiscreteAlgVarsResultDescription(vector<string>& names);\n",
                                    "     void writeIntAlgVarsResultDescription(vector<string>& names);\n",
                                    "     void writeBoolAlgVarsResultDescription(vector<string>& names);\n",
                                    "     void writeAliasVarsResultDescription(vector<string>& names);\n",
                                    "     void writeIntAliasVarsResultDescription(vector<string>& names);\n",
                                    "     void writeBoolAliasVarsResultDescription(vector<string>& names);\n",
                                    "     void writeStateVarsResultDescription(vector<string>& names);\n",
                                    "     void writeDerivativeVarsResultDescription(vector<string>& names);\n",
                                    "     void writeParameterDescription(vector<string>& names);\n",
                                    "     void writeIntParameterDescription(vector<string>& names);\n",
                                    "     void writeBoolParameterDescription(vector<string>& names);\n",
                                    "\n",
                                    "     HistoryImplType* _historyImpl;\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationWriteOutputHeaderFile;

public function simulationExtensionHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " #pragma once\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Initialize.h\"\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection.h\"\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "class "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Extension: public ISystemInitialization, public IMixedSystem,public IWriteOutput, public IStateSelection, public "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WriteOutput, public "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Initialize, public "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Jacobian,public "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection\n",
                                    "{\n",
                                    "  public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension(IGlobalSettings* globalSettings, boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory, boost::shared_ptr<ISimData> simData);\n",
                                    "virtual ~"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension();\n",
                                    "\n",
                                    "///Intialization methods from ISystemInitialization\n",
                                    "virtual bool initial();\n",
                                    "virtual void setInitial(bool);\n",
                                    "virtual void initialize();\n",
                                    "virtual void initEquations();\n",
                                    "\n",
                                    "///Write simulation results methods from IWriteOutput\n",
                                    "/// Output routine (to be called by the solver after every successful integration step)\n",
                                    "virtual void writeOutput(const IWriteOutput::OUTPUT command = IWriteOutput::UNDEF_OUTPUT);\n",
                                    "virtual IHistory* getHistory();\n",
                                    "/// Provide Jacobian\n",
                                    "virtual void getJacobian(SparseMatrix& matrix);\n",
                                    "virtual void getStateSetJacobian(unsigned int index,SparseMatrix& matrix);\n",
                                    "/// Called to handle all events occured at same time\n",
                                    "virtual bool handleSystemEvents(bool* events);\n",
                                    "//Saves all variables before an event is handled, is needed for the pre, edge and change operator\n",
                                    "virtual void saveAll();\n",
                                    "\n",
                                    "//StateSelction methods\n",
                                    "virtual int getDimStateSets() const;\n",
                                    "virtual int getDimStates(unsigned int index) const;\n",
                                    "virtual int getDimCanditates(unsigned int index) const ;\n",
                                    "virtual int getDimDummyStates(unsigned int index) const ;\n",
                                    "virtual void getStates(unsigned int index,double* z);\n",
                                    "virtual void setStates(unsigned int index,const double* z);\n",
                                    "virtual void getStateCanditates(unsigned int index,double* z);\n",
                                    "virtual bool getAMatrix(unsigned int index,DynArrayDim2<int>& A);\n",
                                    "virtual void setAMatrix(unsigned int index, DynArrayDim2<int>& A);\n",
                                    "virtual bool getAMatrix(unsigned int index,DynArrayDim1<int>& A);\n",
                                    "virtual void setAMatrix(unsigned int index,DynArrayDim1<int>& A);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*colored jacobians*/\n",
                                    "  virtual void getA_sparsePattern_leadindex(int* A_sparsePattern_leadindex, int size);\n",
                                    "virtual int  getA_sizeof_sparsePattern_leadindex();\n",
                                    "  virtual void getA_sparsePattern_index(int* A_sparsePattern_index, int size);\n",
                                    "virtual int  getA_sizeof_sparsePattern_index();\n",
                                    "  virtual void getA_sparsePattern_colorCols(int* A_sparsePattern_colorCols, int size);\n",
                                    "virtual int  getA_sizeof_sparsePattern_colorCols();\n",
                                    "  virtual int  getA_sparsePattern_maxColors();\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationExtensionHeaderFile;

public function simulationFactoryFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* #include <Core/Modelica.h>\n",
                                    "#include <Core/ModelicaDefine.h>\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension.h\" */\n",
                                    "\n",
                                    "\n",
                                    "#if defined(__TRICORE__)  || defined(__vxworks)\n",
                                    "\n",
                                    "extern \"C\" IMixedSystem* create"
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(IGlobalSettings* globalSettings, boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactor, boost::shared_ptr<ISimData> simData)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return new "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Extension(globalSettings, nonlinsolverfactor, simData);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "#else\n",
                                    "\n",
                                    "using boost::extensions::factory;\n",
                                    " BOOST_EXTENSION_TYPE_MAP_FUNCTION {\n",
                                    "  types.get<std::map<std::string, factory<IMixedSystem,IGlobalSettings*,boost::shared_ptr<IAlgLoopSolverFactory>,boost::shared_ptr<ISimData> > > >()\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("[\""));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"].set<"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension>();\n",
                                    "}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#endif"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationFactoryFile;

public function simulationInitCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      String i_fileNamePrefix;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix, allEquations = i_allEquations, initialEquations = i_initialEquations)),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* #include <Core/Modelica.h>\n",
                                    "#include <Core/ModelicaDefine.h>\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize.h\" */\n",
                                    "\n"
                                }, true));
        ret_0 = listAppend(i_allEquations, i_initialEquations);
        txt = algloopfilesInclude(txt, ret_0, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Initialize::"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize(IGlobalSettings* globalSettings, boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory, boost::shared_ptr<ISimData> simData)\n",
                                    ": "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(globalSettings, nonlinsolverfactory, simData)\n",
                                    "{\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Initialize::~"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize()\n",
                                    "{\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = GetIntialStatus(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = SetIntialStatus(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = init(txt, i_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationInitCppFile;

public function simulationJacobianCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix, jacobianMatrixes = i_jacobianMatrixes)),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " /* #include <Core/Modelica.h>\n",
                                    " #include <Core/ModelicaDefine.h>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Jacobian.h\" */\n"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Jacobian::"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData)\n",
                                    ": "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(globalSettings,nonlinsolverfactory,simData)\n",
                                    ",_A_sparsePattern_leadindex(NULL)\n",
                                    ",_A_sparsePattern_index(NULL)\n",
                                    ",_A_sparsePattern_colorCols(NULL)\n",
                                    "{\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Jacobian::~"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian()\n",
                                    " {\n",
                                    " if(_A_sparsePattern_leadindex)\n",
                                    "   delete []  _A_sparsePattern_leadindex;\n",
                                    " if(_A_sparsePattern_index)\n",
                                    "   delete []  _A_sparsePattern_index;\n",
                                    " if(_A_sparsePattern_colorCols)\n",
                                    "   delete []  _A_sparsePattern_colorCols;\n",
                                    "\n",
                                    " }\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = functionAnalyticJacobians(txt, i_jacobianMatrixes, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "//testmaessig aus der cruntime\n",
                                    "/* Jacobians */\n",
                                    "\n"
                                }, true));
        txt_0 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = functionAnalyticJacobians2(txt, i_jacobianMatrixes, Tpl.textString(txt_0));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationJacobianCppFile;

public function simulationStateSelectionCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      list<SimCode.StateSet> i_stateSets;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix, stateSets = i_stateSets)),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* #include <Core/Modelica.h>\n",
                                    "#include <Core/ModelicaDefine.h>\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection.h\" */\n"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateSelection::"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData)\n",
                                    ": "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(globalSettings,nonlinsolverfactory,simData)\n",
                                    "{\n",
                                    "}\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StateSelection::~"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection()\n",
                                    "{\n",
                                    "}\n"
                                }, true));
        txt = functionDimStateSets(txt, i_stateSets, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = functionStateSets(txt, i_stateSets, i_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationStateSelectionCppFile;

public function simulationWriteOutputCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), fileNamePrefix = i_fileNamePrefix)),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* #include <Core/Modelica.h>\n",
                                    "#include <Core/ModelicaDefine.h>\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput.h\" */\n",
                                    "\n"
                                }, true));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WriteOutput::"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData)\n",
                                    ": "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(globalSettings,nonlinsolverfactory,simData)\n",
                                    "{\n",
                                    "   _historyImpl = new HistoryImplType(*globalSettings);\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WriteOutput::~"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput()\n",
                                    "{\n",
                                    "     delete _historyImpl;\n",
                                    "}\n",
                                    "IHistory* "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput::getHistory()\n",
                                    "{\n",
                                    "    return _historyImpl;\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput::initialize()\n",
                                    "{\n",
                                    "   _historyImpl->init();\n",
                                    "\n",
                                    "   map<unsigned int,string> var_ouputs_idx;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = outputIndices(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_historyImpl->setOutputs(var_ouputs_idx);\n",
                                    "_historyImpl->clear();\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = writeoutput(txt, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationWriteOutputCppFile;

protected function fun_65
  input Tpl.Text in_txt;
  input SimCode.JacobianMatrix in_a_jacobianMatrix;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_jacobianMatrix, in_a_i1)
    local
      Tpl.Text txt;
      Integer a_i1;
      String i_name;

    case ( txt,
           (_, _, i_name, _, _, _, _),
           a_i1 )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("get"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian(matrix);\n",
                                    "break;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_65;

protected function fun_66
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_i1)
    local
      Tpl.Text txt;
      Integer a_i1;
      SimCode.JacobianMatrix i_jacobianMatrix;

    case ( txt,
           SimCode.SES_STATESET(jacobianMatrix = i_jacobianMatrix),
           a_i1 )
      equation
        txt = fun_65(txt, i_jacobianMatrix, a_i1);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_66;

protected function lm_67
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_set :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_66(txt, i_set, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest);
      then txt;
  end match;
end lm_67;

public function simulationExtensionCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> i_stateSets;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_classname;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), fileNamePrefix = i_fileNamePrefix, stateSets = i_stateSets) )
      equation
        l_classname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* #include <Core/Modelica.h>\n",
                                    "#include <Core/ModelicaDefine.h>\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Extension.h\" */\n"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Extension::"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData)\n",
                                    ": "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(globalSettings,nonlinsolverfactory,simData)\n",
                                    ", "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput(globalSettings,nonlinsolverfactory,simData)\n",
                                    ", "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize(globalSettings,nonlinsolverfactory,simData)\n",
                                    ", "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian(globalSettings,nonlinsolverfactory,simData)\n",
                                    ", "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection(globalSettings,nonlinsolverfactory,simData)\n",
                                    "\n",
                                    "\n",
                                    "{\n",
                                    "}\n"
                                }, true));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Extension::~"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension()\n",
                                    "{\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::initial()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Initialize::initial();\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::setInitial(bool value)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Initialize::setInitial(value);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::initialize()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("WriteOutput::initialize();\n"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Initialize::initialize();\n"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian::initialize();\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian::initializeColoredJacobianA();\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getJacobian(SparseMatrix& matrix)\n",
                                    "{\n",
                                    "        getAJacobian(matrix);\n",
                                    "\n",
                                    "}\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getStateSetJacobian(unsigned int index,SparseMatrix& matrix)\n",
                                    "{\n",
                                    "\n",
                                    "   switch (index)\n",
                                    "    {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_67(txt, i_stateSets);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    default:\n",
                                    "     throw std::invalid_argument(\"Not supported statset index\");\n",
                                    "   }\n",
                                    "}\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::handleSystemEvents(bool* events)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("::handleSystemEvents(events);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::saveAll()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("::saveAll();\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::initEquations()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Initialize::initEquations();\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::writeOutput(const IWriteOutput::OUTPUT command )\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("WriteOutput::writeOutput(command);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "IHistory* "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getHistory( )\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return    "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("WriteOutput::getHistory();\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getDimStateSets() const\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return    "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::getDimStateSets();\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getDimStates(unsigned int index) const\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return    "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::getDimStates(index);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getDimCanditates(unsigned int index) const\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return    "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::getDimCanditates(index);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getDimDummyStates(unsigned int index) const\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return    "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::getDimDummyStates(index);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getStates(unsigned int index,double* z)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::getStates(index,z);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::setStates(unsigned int index,const double* z)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::setStates(index,z);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getStateCanditates(unsigned int index,double* z)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::getStateCanditates(index,z);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getAMatrix(unsigned int index,DynArrayDim2<int> & A)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::getAMatrix(index,A);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::setAMatrix(unsigned int index,DynArrayDim2<int> & A)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::setAMatrix(index,A);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getAMatrix(unsigned int index,DynArrayDim1<int> & A)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::getAMatrix(index,A);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::setAMatrix(unsigned int index,DynArrayDim1<int> & A)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::setAMatrix(index,A);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "/*needed for colored jacobians*/\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getA_sparsePattern_leadindex(int* A_sparsePattern_leadindex, int size)\n",
                                    "{\n",
                                    " memcpy(A_sparsePattern_leadindex, _A_sparsePattern_leadindex, size * sizeof(int));\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getA_sparsePattern_index(int* A_sparsePattern_index, int size)\n",
                                    "{\n",
                                    " memcpy(A_sparsePattern_index, _A_sparsePattern_index, size * sizeof(int));\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getA_sparsePattern_colorCols(int* A_sparsePattern_colorCols, int size)\n",
                                    "{\n",
                                    " memcpy(A_sparsePattern_colorCols, _A_sparsePattern_colorCols, size * sizeof(int));\n",
                                    "}\n",
                                    "\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getA_sparsePattern_maxColors()\n",
                                    "{\n",
                                    " return _A_sparsePattern_maxColors;\n",
                                    "}\n",
                                    "\n",
                                    "/*********************************************************************************************/\n",
                                    "\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getA_sizeof_sparsePattern_colorCols()\n",
                                    "{\n",
                                    " return _A_sizeof_sparsePattern_colorCols;\n",
                                    "}\n",
                                    "\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getA_sizeof_sparsePattern_leadindex()\n",
                                    "{\n",
                                    " return _A_sizeof_sparsePattern_leadindex ;\n",
                                    "}\n",
                                    "\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension::getA_sizeof_sparsePattern_index()\n",
                                    "{\n",
                                    " return _A_sizeof_sparsePattern_index;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationExtensionCppFile;

protected function fun_69
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_i1)
    local
      Tpl.Text txt;
      Integer a_i1;
      Integer i_nStates;

    case ( txt,
           SimCode.SES_STATESET(nStates = i_nStates),
           a_i1 )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_69;

protected function lm_70
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_set :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_69(txt, i_set, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_70(txt, rest);
      then txt;
  end match;
end lm_70;

protected function fun_71
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_i1)
    local
      Tpl.Text txt;
      Integer a_i1;
      Integer i_nCandidates;

    case ( txt,
           SimCode.SES_STATESET(nCandidates = i_nCandidates),
           a_i1 )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return  "));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_71;

protected function lm_72
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_set :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_71(txt, i_set, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;
  end match;
end lm_72;

protected function fun_73
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_i1)
    local
      Tpl.Text txt;
      Integer a_i1;
      Integer i_nStates;
      Integer i_nCandidates;

    case ( txt,
           SimCode.SES_STATESET(nCandidates = i_nCandidates, nStates = i_nStates),
           a_i1 )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = Tpl.writeStr(txt, intString(i_nCandidates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeStr(txt, intString(i_nStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_73;

protected function lm_74
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_set :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_73(txt, i_set, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_74(txt, rest);
      then txt;
  end match;
end lm_74;

protected function fun_75
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_a_stateSets;
  input Tpl.Text in_a_classname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stateSets, in_a_classname)
    local
      Tpl.Text txt;
      Tpl.Text a_classname;
      list<SimCode.StateSet> i_stateSets;
      Integer ret_0;

    case ( txt,
           {},
           a_classname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getDimStateSets() const\n",
                                    "{\n",
                                    "   return 0;\n",
                                    "}\n",
                                    "int "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getDimStates(unsigned int index) const\n",
                                    "{\n",
                                    " return 0;\n",
                                    "}\n",
                                    "int "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getDimCanditates(unsigned int index) const\n",
                                    "{\n",
                                    "   return 0;\n",
                                    "}\n",
                                    "int "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getDimDummyStates(unsigned int index) const\n",
                                    "{\n",
                                    "  return 0;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           i_stateSets,
           a_classname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getDimStateSets() const\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        ret_0 = listLength(i_stateSets);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "int "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getDimStates(unsigned int index) const\n",
                                    "{\n",
                                    "   switch (index)\n",
                                    "   {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_70(txt, i_stateSets);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   default:\n",
                                    "    throw std::invalid_argument(\"Not supported statset index\");\n",
                                    "  }\n",
                                    "\n",
                                    "}\n",
                                    "int "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getDimCanditates(unsigned int index) const\n",
                                    "{\n",
                                    "   switch (index)\n",
                                    "   {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_72(txt, i_stateSets);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   default:\n",
                                    "    throw std::invalid_argument(\"Not supported statset index\");\n",
                                    "  }\n",
                                    "\n",
                                    "}\n",
                                    "int "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getDimDummyStates(unsigned int index) const\n",
                                    "{\n",
                                    "\n",
                                    " switch (index)\n",
                                    "   {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_74(txt, i_stateSets);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  default:\n",
                                    "    throw std::invalid_argument(\"Not supported statset index\");\n",
                                    "  }\n",
                                    "\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_75;

protected function fun_76
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> i_stateSets;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_classname;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), stateSets = i_stateSets) )
      equation
        l_classname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_75(txt, i_stateSets, l_classname);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_76;

public function functionDimStateSets
  input Tpl.Text txt;
  input list<SimCode.StateSet> a_stateSets;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_76(txt, a_simCode);
end functionDimStateSets;

protected function lm_78
  input Tpl.Text in_txt;
  input list<list<DAE.Subscript>> in_items;
  input Boolean in_a_useFlatArrayNotationSource;
  input String in_a_sourceArrayName;
  input Boolean in_a_useFlatArrayNotationTarget;
  input String in_a_targetArrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotationSource, in_a_sourceArrayName, in_a_useFlatArrayNotationTarget, in_a_targetArrayName)
    local
      Tpl.Text txt;
      list<list<DAE.Subscript>> rest;
      Boolean a_useFlatArrayNotationSource;
      String a_sourceArrayName;
      Boolean a_useFlatArrayNotationTarget;
      String a_targetArrayName;
      list<DAE.Subscript> i_ai;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_ai :: rest,
           a_useFlatArrayNotationSource,
           a_sourceArrayName,
           a_useFlatArrayNotationTarget,
           a_targetArrayName )
      equation
        txt = Tpl.writeStr(txt, a_targetArrayName);
        txt = subscriptsToCStr(txt, i_ai, a_useFlatArrayNotationTarget);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeStr(txt, a_sourceArrayName);
        txt = subscriptsToCStr(txt, i_ai, a_useFlatArrayNotationSource);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest, a_useFlatArrayNotationSource, a_sourceArrayName, a_useFlatArrayNotationTarget, a_targetArrayName);
      then txt;
  end match;
end lm_78;

protected function fun_79
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_useFlatArrayNotationSource;
  input Boolean in_a_useFlatArrayNotationTarget;
  input list<String> in_a_num;
  input DAE.ComponentRef in_a_sourceOrTargetArrayCref;
  input String in_a_sourceArrayName;
  input String in_a_targetArrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotationSource, in_a_useFlatArrayNotationTarget, in_a_num, in_a_sourceOrTargetArrayCref, in_a_sourceArrayName, in_a_targetArrayName)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotationSource;
      Boolean a_useFlatArrayNotationTarget;
      list<String> a_num;
      DAE.ComponentRef a_sourceOrTargetArrayCref;
      String a_sourceArrayName;
      String a_targetArrayName;
      list<list<DAE.Subscript>> ret_0;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           a_sourceArrayName,
           a_targetArrayName )
      equation
        txt = Tpl.writeStr(txt, a_targetArrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".assign("));
        txt = Tpl.writeStr(txt, a_sourceArrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotationSource,
           a_useFlatArrayNotationTarget,
           a_num,
           a_sourceOrTargetArrayCref,
           a_sourceArrayName,
           a_targetArrayName )
      equation
        ret_0 = HpcOmMemory.getSubscriptListOfArrayCref(a_sourceOrTargetArrayCref, a_num);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_78(txt, ret_0, a_useFlatArrayNotationSource, a_sourceArrayName, a_useFlatArrayNotationTarget, a_targetArrayName);
        txt = Tpl.popIter(txt);
      then txt;
  end match;
end fun_79;

protected function fun_80
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_mArg;
  input DAE.ComponentRef in_a_sourceOrTargetArrayCref;
  input String in_a_sourceArrayName;
  input String in_a_targetArrayName;
  input Boolean in_a_useFlatArrayNotationSource;
  input Boolean in_a_useFlatArrayNotationTarget;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_sourceOrTargetArrayCref, in_a_sourceArrayName, in_a_targetArrayName, in_a_useFlatArrayNotationSource, in_a_useFlatArrayNotationTarget)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_sourceOrTargetArrayCref;
      String a_sourceArrayName;
      String a_targetArrayName;
      Boolean a_useFlatArrayNotationSource;
      Boolean a_useFlatArrayNotationTarget;
      list<String> i_num;
      Boolean ret_0;

    case ( txt,
           SimCodeVar.SIMVAR(numArrayElement = i_num),
           a_sourceOrTargetArrayCref,
           a_sourceArrayName,
           a_targetArrayName,
           a_useFlatArrayNotationSource,
           a_useFlatArrayNotationTarget )
      equation
        ret_0 = boolOr(a_useFlatArrayNotationSource, a_useFlatArrayNotationTarget);
        txt = fun_79(txt, ret_0, a_useFlatArrayNotationSource, a_useFlatArrayNotationTarget, i_num, a_sourceOrTargetArrayCref, a_sourceArrayName, a_targetArrayName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_80;

public function createAssignArray
  input Tpl.Text txt;
  input DAE.ComponentRef a_sourceOrTargetArrayCref;
  input String a_sourceArrayName;
  input String a_targetArrayName;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotationSource;
  input Boolean a_useFlatArrayNotationTarget;

  output Tpl.Text out_txt;
protected
  SimCodeVar.SimVar ret_0;
algorithm
  ret_0 := SimCodeUtil.cref2simvar(a_sourceOrTargetArrayCref, a_simCode);
  out_txt := fun_80(txt, ret_0, a_sourceOrTargetArrayCref, a_sourceArrayName, a_targetArrayName, a_useFlatArrayNotationSource, a_useFlatArrayNotationTarget);
end createAssignArray;

protected function fun_82
  input Tpl.Text in_txt;
  input Integer in_a_nStates;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_arrayname1;
  input DAE.ComponentRef in_a_crA;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nStates, in_a_useFlatArrayNotation, in_a_simCode, in_a_arrayname1, in_a_crA, in_a_i1)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_arrayname1;
      DAE.ComponentRef a_crA;
      Integer a_i1;

    case ( txt,
           1,
           a_useFlatArrayNotation,
           a_simCode,
           a_arrayname1,
           a_crA,
           a_i1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(15));
        txt = createAssignArray(txt, a_crA, Tpl.textString(a_arrayname1), "A", a_simCode, a_useFlatArrayNotation, false);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return true;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("            "));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_82;

protected function fun_83
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input SimCode.SimCode in_a_simCode;
  input Integer in_a_i1;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_simCode, in_a_i1, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Integer a_i1;
      Boolean a_useFlatArrayNotation;
      Integer i_nStates;
      DAE.ComponentRef i_crA;
      Tpl.Text l_arrayname1;

    case ( txt,
           SimCode.SES_STATESET(crA = i_crA, nStates = i_nStates),
           a_simCode,
           a_i1,
           a_useFlatArrayNotation )
      equation
        l_arrayname1 = arraycref(Tpl.emptyTxt, i_crA, a_useFlatArrayNotation);
        txt = fun_82(txt, i_nStates, a_useFlatArrayNotation, a_simCode, l_arrayname1, i_crA, a_i1);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_83;

protected function lm_84
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_set :: rest,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_83(txt, i_set, a_simCode, x_i1, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest, a_simCode, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_84;

protected function fun_85
  input Tpl.Text in_txt;
  input Integer in_a_nStates;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_arrayname1;
  input DAE.ComponentRef in_a_crA;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nStates, in_a_useFlatArrayNotation, in_a_simCode, in_a_arrayname1, in_a_crA, in_a_i1)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_arrayname1;
      DAE.ComponentRef a_crA;
      Integer a_i1;

    case ( txt,
           1,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_arrayname1,
           a_crA,
           a_i1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(15));
        txt = createAssignArray(txt, a_crA, Tpl.textString(a_arrayname1), "A", a_simCode, a_useFlatArrayNotation, false);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return true;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("            "));
      then txt;
  end match;
end fun_85;

protected function fun_86
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input SimCode.SimCode in_a_simCode;
  input Integer in_a_i1;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_simCode, in_a_i1, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Integer a_i1;
      Boolean a_useFlatArrayNotation;
      Integer i_nStates;
      DAE.ComponentRef i_crA;
      Tpl.Text l_arrayname1;

    case ( txt,
           SimCode.SES_STATESET(crA = i_crA, nStates = i_nStates),
           a_simCode,
           a_i1,
           a_useFlatArrayNotation )
      equation
        l_arrayname1 = arraycref(Tpl.emptyTxt, i_crA, a_useFlatArrayNotation);
        txt = fun_85(txt, i_nStates, a_useFlatArrayNotation, a_simCode, l_arrayname1, i_crA, a_i1);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_86;

protected function lm_87
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_set :: rest,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_86(txt, i_set, a_simCode, x_i1, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_87(txt, rest, a_simCode, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_87;

protected function fun_88
  input Tpl.Text in_txt;
  input Integer in_a_nStates;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_arrayname1;
  input DAE.ComponentRef in_a_crA;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nStates, in_a_useFlatArrayNotation, in_a_simCode, in_a_arrayname1, in_a_crA, in_a_i1)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_arrayname1;
      DAE.ComponentRef a_crA;
      Integer a_i1;

    case ( txt,
           1,
           a_useFlatArrayNotation,
           a_simCode,
           a_arrayname1,
           a_crA,
           a_i1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(15));
        txt = createAssignArray(txt, a_crA, "A", Tpl.textString(a_arrayname1), a_simCode, false, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("break;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("            "));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_88;

protected function fun_89
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input SimCode.SimCode in_a_simCode;
  input Integer in_a_i1;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_simCode, in_a_i1, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Integer a_i1;
      Boolean a_useFlatArrayNotation;
      Integer i_nStates;
      DAE.ComponentRef i_crA;
      Tpl.Text l_arrayname1;

    case ( txt,
           SimCode.SES_STATESET(crA = i_crA, nStates = i_nStates),
           a_simCode,
           a_i1,
           a_useFlatArrayNotation )
      equation
        l_arrayname1 = arraycref(Tpl.emptyTxt, i_crA, a_useFlatArrayNotation);
        txt = fun_88(txt, i_nStates, a_useFlatArrayNotation, a_simCode, l_arrayname1, i_crA, a_i1);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_89;

protected function lm_90
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_set :: rest,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_89(txt, i_set, a_simCode, x_i1, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_90(txt, rest, a_simCode, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_90;

protected function fun_91
  input Tpl.Text in_txt;
  input Integer in_a_nStates;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_arrayname1;
  input DAE.ComponentRef in_a_crA;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nStates, in_a_useFlatArrayNotation, in_a_simCode, in_a_arrayname1, in_a_crA, in_a_i1)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_arrayname1;
      DAE.ComponentRef a_crA;
      Integer a_i1;

    case ( txt,
           1,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_arrayname1,
           a_crA,
           a_i1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(15));
        txt = createAssignArray(txt, a_crA, "A", Tpl.textString(a_arrayname1), a_simCode, false, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("break;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("            "));
      then txt;
  end match;
end fun_91;

protected function fun_92
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input SimCode.SimCode in_a_simCode;
  input Integer in_a_i1;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_set, in_a_simCode, in_a_i1, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Integer a_i1;
      Boolean a_useFlatArrayNotation;
      Integer i_nStates;
      DAE.ComponentRef i_crA;
      Tpl.Text l_arrayname1;

    case ( txt,
           SimCode.SES_STATESET(crA = i_crA, nStates = i_nStates),
           a_simCode,
           a_i1,
           a_useFlatArrayNotation )
      equation
        l_arrayname1 = arraycref(Tpl.emptyTxt, i_crA, a_useFlatArrayNotation);
        txt = fun_91(txt, i_nStates, a_useFlatArrayNotation, a_simCode, l_arrayname1, i_crA, a_i1);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_92;

protected function lm_93
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_set :: rest,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = fun_92(txt, i_set, a_simCode, x_i1, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_93(txt, rest, a_simCode, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_93;

protected function lm_94
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.SimCode a_simCode;
      Integer x_i2;
      DAE.ComponentRef i_s;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           i_s :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_simCode )
      equation
        x_i2 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("z["));
        txt = Tpl.writeStr(txt, intString(x_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        (txt, a_varDeclsCref) = cref1(txt, i_s, a_simCode, SimCode.contextOther, a_varDeclsCref, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_94(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_94;

protected function fun_95
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.SimCode in_a_simCode;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_a_set, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_simCode, in_a_i1)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.SimCode a_simCode;
      Integer a_i1;
      list<DAE.ComponentRef> i_states;

    case ( txt,
           SimCode.SES_STATESET(states = i_states),
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_simCode,
           a_i1 )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDeclsCref) = lm_94(txt, i_states, a_useFlatArrayNotation, a_varDeclsCref, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break;"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDeclsCref);

    case ( txt,
           _,
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);
  end match;
end fun_95;

protected function lm_96
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.SimCode a_simCode;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           i_set :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_simCode )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDeclsCref) = fun_95(txt, i_set, a_useFlatArrayNotation, a_varDeclsCref, a_simCode, x_i1);
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_96(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_96;

protected function lm_97
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.SimCode a_simCode;
      Integer x_i2;
      DAE.ComponentRef i_s;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           i_s :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_simCode )
      equation
        x_i2 = Tpl.getIteri_i0(txt);
        (txt, a_varDeclsCref) = cref1(txt, i_s, a_simCode, SimCode.contextOther, a_varDeclsCref, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = z["));
        txt = Tpl.writeStr(txt, intString(x_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_97(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_97;

protected function fun_98
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.SimCode in_a_simCode;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_a_set, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_simCode, in_a_i1)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.SimCode a_simCode;
      Integer a_i1;
      list<DAE.ComponentRef> i_states;

    case ( txt,
           SimCode.SES_STATESET(states = i_states),
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_simCode,
           a_i1 )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDeclsCref) = lm_97(txt, i_states, a_useFlatArrayNotation, a_varDeclsCref, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break;"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDeclsCref);

    case ( txt,
           _,
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);
  end match;
end fun_98;

protected function lm_99
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.SimCode a_simCode;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           i_set :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_simCode )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDeclsCref) = fun_98(txt, i_set, a_useFlatArrayNotation, a_varDeclsCref, a_simCode, x_i1);
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_99(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_99;

protected function lm_100
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.SimCode a_simCode;
      Integer x_i2;
      DAE.ComponentRef i_cstate;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           i_cstate :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_simCode )
      equation
        x_i2 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("z["));
        txt = Tpl.writeStr(txt, intString(x_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        (txt, a_varDeclsCref) = cref1(txt, i_cstate, a_simCode, SimCode.contextOther, a_varDeclsCref, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_100(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_100;

protected function fun_101
  input Tpl.Text in_txt;
  input SimCode.StateSet in_a_set;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.SimCode in_a_simCode;
  input Integer in_a_i1;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_a_set, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_simCode, in_a_i1)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.SimCode a_simCode;
      Integer a_i1;
      list<DAE.ComponentRef> i_statescandidates;

    case ( txt,
           SimCode.SES_STATESET(statescandidates = i_statescandidates),
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_simCode,
           a_i1 )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(a_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDeclsCref) = lm_100(txt, i_statescandidates, a_useFlatArrayNotation, a_varDeclsCref, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break;"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDeclsCref);

    case ( txt,
           _,
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);
  end match;
end fun_101;

protected function lm_102
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.StateSet> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.SimCode a_simCode;
      Integer x_i1;
      SimCode.StateSet i_set;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           i_set :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_simCode )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDeclsCref) = fun_101(txt, i_set, a_useFlatArrayNotation, a_varDeclsCref, a_simCode, x_i1);
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_102(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_102;

protected function fun_103
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_getAMatrix2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_getAMatrix2)
    local
      Tpl.Text txt;
      Tpl.Text a_getAMatrix2;

    case ( txt,
           "",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return false;"));
      then txt;

    case ( txt,
           _,
           a_getAMatrix2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " switch (index)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_getAMatrix2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   default:\n",
                                    "    throw std::invalid_argument(\"Not supported statset index\");\n",
                                    "  }"
                                }, false));
      then txt;
  end match;
end fun_103;

protected function fun_104
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_getAMatrix1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_getAMatrix1)
    local
      Tpl.Text txt;
      Tpl.Text a_getAMatrix1;

    case ( txt,
           "",
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return false;"));
      then txt;

    case ( txt,
           _,
           a_getAMatrix1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "switch (index)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, a_getAMatrix1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " default:\n",
                                    " throw std::invalid_argument(\"Not supported statset index\");\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
      then txt;
  end match;
end fun_104;

protected function fun_105
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_setAMatrix2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_setAMatrix2)
    local
      Tpl.Text txt;
      Tpl.Text a_setAMatrix2;

    case ( txt,
           "",
           _ )
      then txt;

    case ( txt,
           _,
           a_setAMatrix2 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " switch (index)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_setAMatrix2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   default:\n",
                                    "    throw std::invalid_argument(\"Not supported statset index\");\n",
                                    "}"
                                }, false));
      then txt;
  end match;
end fun_105;

protected function fun_106
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_setAMatrix1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_setAMatrix1)
    local
      Tpl.Text txt;
      Tpl.Text a_setAMatrix1;

    case ( txt,
           "",
           _ )
      then txt;

    case ( txt,
           _,
           a_setAMatrix1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "switch (index)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, a_setAMatrix1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " default:\n",
                                    " throw std::invalid_argument(\"Not supported statset index\");\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" }"));
      then txt;
  end match;
end fun_106;

protected function fun_107
  input Tpl.Text in_txt;
  input list<SimCode.StateSet> in_a_stateSets;
  input Tpl.Text in_a_setAMatrix1;
  input Tpl.Text in_a_setAMatrix2;
  input Tpl.Text in_a_getAMatrix1;
  input Tpl.Text in_a_getAMatrix2;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_classname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_stateSets, in_a_setAMatrix1, in_a_setAMatrix2, in_a_getAMatrix1, in_a_getAMatrix2, in_a_useFlatArrayNotation, in_a_simCode, in_a_classname)
    local
      Tpl.Text txt;
      Tpl.Text a_setAMatrix1;
      Tpl.Text a_setAMatrix2;
      Tpl.Text a_getAMatrix1;
      Tpl.Text a_getAMatrix2;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_classname;
      list<SimCode.StateSet> i_stateSets;
      String str_4;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_varDeclsCref;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _,
           a_classname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void  "));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getStates(unsigned int index,double* z)\n",
                                    "{\n",
                                    "\n",
                                    "\n",
                                    "}\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::setStates(unsigned int index,const double* z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getStateCanditates(unsigned int index,double* z)\n",
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "bool  "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getAMatrix(unsigned int index,DynArrayDim2<int> & A)\n",
                                    "{\n",
                                    "\n",
                                    "   return false;\n",
                                    "}\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool  "));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::getAMatrix(unsigned int index,DynArrayDim1<int> & A)\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "\n",
                                    "  return false;\n",
                                    "}\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::setAMatrix(unsigned int index,DynArrayDim2<int>& A)\n",
                                    "{\n",
                                    "\n",
                                    "}\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void  "));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("StateSelection::setAMatrix(unsigned int index,DynArrayDim1<int>& A)\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "\n",
                                    "}\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::initialize()\n",
                                    "{\n",
                                    "\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           i_stateSets,
           a_setAMatrix1,
           a_setAMatrix2,
           a_getAMatrix1,
           a_getAMatrix2,
           a_useFlatArrayNotation,
           a_simCode,
           a_classname )
      equation
        l_varDeclsCref = Tpl.emptyTxt;
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void  "));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getStates(unsigned int index,double* z)\n",
                                    " {\n",
                                    "  switch (index)\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDeclsCref) = lm_96(txt, i_stateSets, a_useFlatArrayNotation, l_varDeclsCref, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   default:\n",
                                    "     throw std::invalid_argument(\"Not supported statset index\");\n",
                                    "  }\n",
                                    "\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void  "));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::setStates(unsigned int index,const double* z)\n",
                                    "{\n",
                                    " switch (index)\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDeclsCref) = lm_99(txt, i_stateSets, a_useFlatArrayNotation, l_varDeclsCref, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " default:\n",
                                    "   throw std::invalid_argument(\"Not supported statset index\");\n",
                                    " }\n",
                                    "\n",
                                    "}\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getStateCanditates(unsigned int index,double* z)\n",
                                    "{\n",
                                    "\n",
                                    " switch (index)\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDeclsCref) = lm_102(txt, i_stateSets, a_useFlatArrayNotation, l_varDeclsCref, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " default:\n",
                                    "   throw std::invalid_argument(\"Not supported statset index\");\n",
                                    " }\n",
                                    "\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "bool  "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getAMatrix(unsigned int index,DynArrayDim2<int> & A)\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        str_1 = Tpl.textString(a_getAMatrix2);
        txt = fun_103(txt, str_1, a_getAMatrix2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "bool  "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::getAMatrix(unsigned int index,DynArrayDim1<int> & A)\n",
                                    " {\n"
                                }, true));
        str_2 = Tpl.textString(a_getAMatrix1);
        txt = fun_104(txt, str_2, a_getAMatrix1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::setAMatrix(unsigned int index,DynArrayDim2<int> & A)\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        str_3 = Tpl.textString(a_setAMatrix2);
        txt = fun_105(txt, str_3, a_setAMatrix2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_classname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection::setAMatrix(unsigned int index,DynArrayDim1<int> & A)\n",
                                    " {\n"
                                }, true));
        str_4 = Tpl.textString(a_setAMatrix1);
        txt = fun_106(txt, str_4, a_setAMatrix1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_107;

protected function fun_108
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      list<SimCode.StateSet> i_stateSets;
      Tpl.Text l_classname;
      Tpl.Text l_setAMatrix2;
      Tpl.Text l_setAMatrix1;
      Tpl.Text l_getAMatrix2;
      Tpl.Text l_getAMatrix1;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), stateSets = i_stateSets)),
           a_useFlatArrayNotation )
      equation
        l_getAMatrix1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_getAMatrix1 = lm_84(l_getAMatrix1, i_stateSets, i_simCode, a_useFlatArrayNotation);
        l_getAMatrix1 = Tpl.popIter(l_getAMatrix1);
        l_getAMatrix2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_getAMatrix2 = lm_87(l_getAMatrix2, i_stateSets, i_simCode, a_useFlatArrayNotation);
        l_getAMatrix2 = Tpl.popIter(l_getAMatrix2);
        l_setAMatrix1 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_setAMatrix1 = lm_90(l_setAMatrix1, i_stateSets, i_simCode, a_useFlatArrayNotation);
        l_setAMatrix1 = Tpl.popIter(l_setAMatrix1);
        l_setAMatrix2 = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_setAMatrix2 = lm_93(l_setAMatrix2, i_stateSets, i_simCode, a_useFlatArrayNotation);
        l_setAMatrix2 = Tpl.popIter(l_setAMatrix2);
        l_classname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_107(txt, i_stateSets, l_setAMatrix1, l_setAMatrix2, l_getAMatrix1, l_getAMatrix2, a_useFlatArrayNotation, i_simCode, l_classname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_108;

public function functionStateSets
  input Tpl.Text txt;
  input list<SimCode.StateSet> a_stateSets;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_108(txt, a_simCode, a_useFlatArrayNotation);
end functionStateSets;

public function crefType
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      DAE.Type i_identType;

    case ( txt,
           DAE.CREF_IDENT(identType = i_identType) )
      equation
        txt = expTypeFlag(txt, i_identType, 6);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(componentRef = i_componentRef) )
      equation
        txt = crefType(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("crefType:ERROR"));
      then txt;
  end match;
end crefType;

protected function fun_111
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_settings_outputFormat;
      SimCode.SimCode i_simCode;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      String i_makefileParams_compileDir;
      String i_settings_method;
      Real i_settings_tolerance;
      Integer i_settings_numberOfIntervals;
      Real i_settings_stepSize;
      Real i_settings_stopTime;
      Real i_settings_startTime;
      Boolean ret_9;
      String ret_8;
      Tpl.Text l_home;
      Tpl.Text l_moLib;
      Tpl.Text l_solver;
      Tpl.Text l_tol;
      Tpl.Text l_intervals;
      Tpl.Text l_stepsize;
      Tpl.Text l_end;
      Tpl.Text l_start;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(compileDir = i_makefileParams_compileDir, omhome = i_makefileParams_omhome), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_settings_startTime, stopTime = i_settings_stopTime, stepSize = i_settings_stepSize, numberOfIntervals = i_settings_numberOfIntervals, tolerance = i_settings_tolerance, method = i_settings_method, outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix)) )
      equation
        l_start = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_startTime));
        l_end = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stopTime));
        l_stepsize = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stepSize));
        l_intervals = Tpl.writeStr(Tpl.emptyTxt, intString(i_settings_numberOfIntervals));
        l_tol = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_tolerance));
        l_solver = Tpl.writeStr(Tpl.emptyTxt, i_settings_method);
        l_moLib = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_compileDir);
        l_home = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#!/bin/sh\n",
                                    "exec ./OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Main -s "));
        txt = Tpl.writeText(txt, l_start);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -e "));
        txt = Tpl.writeText(txt, l_end);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -f "));
        txt = Tpl.writeText(txt, l_stepsize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -v "));
        txt = Tpl.writeText(txt, l_intervals);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -y "));
        txt = Tpl.writeText(txt, l_tol);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -i "));
        txt = Tpl.writeText(txt, l_solver);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -r "));
        ret_8 = Config.simulationCodeTarget();
        txt = simulationLibDir(txt, ret_8, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -m "));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -R "));
        ret_9 = Config.getRunningTestsuite();
        txt = simulationResults(txt, ret_9, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -o "));
        txt = Tpl.writeStr(txt, i_settings_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $*"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_111;

protected function fun_112
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_settings_outputFormat;
      SimCode.SimCode i_simCode;
      String i_fileNamePrefix;
      String i_makefileParams_omhome;
      String i_makefileParams_compileDir;
      String i_settings_method;
      Real i_settings_tolerance;
      Integer i_settings_numberOfIntervals;
      Real i_settings_stepSize;
      Real i_settings_stopTime;
      Real i_settings_startTime;
      Boolean ret_9;
      String ret_8;
      Tpl.Text l_home;
      Tpl.Text l_moLib;
      Tpl.Text l_solver;
      Tpl.Text l_tol;
      Tpl.Text l_intervals;
      Tpl.Text l_stepsize;
      Tpl.Text l_end;
      Tpl.Text l_start;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(compileDir = i_makefileParams_compileDir, omhome = i_makefileParams_omhome), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_settings_startTime, stopTime = i_settings_stopTime, stepSize = i_settings_stepSize, numberOfIntervals = i_settings_numberOfIntervals, tolerance = i_settings_tolerance, method = i_settings_method, outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix)) )
      equation
        l_start = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_startTime));
        l_end = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stopTime));
        l_stepsize = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stepSize));
        l_intervals = Tpl.writeStr(Tpl.emptyTxt, intString(i_settings_numberOfIntervals));
        l_tol = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_tolerance));
        l_solver = Tpl.writeStr(Tpl.emptyTxt, i_settings_method);
        l_moLib = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_compileDir);
        l_home = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#!/bin/sh\n",
                                    "exec ./OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Main -s "));
        txt = Tpl.writeText(txt, l_start);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -e "));
        txt = Tpl.writeText(txt, l_end);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -f "));
        txt = Tpl.writeText(txt, l_stepsize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -v "));
        txt = Tpl.writeText(txt, l_intervals);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -y "));
        txt = Tpl.writeText(txt, l_tol);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -i "));
        txt = Tpl.writeText(txt, l_solver);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -r "));
        ret_8 = Config.simulationCodeTarget();
        txt = simulationLibDir(txt, ret_8, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -m "));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -R "));
        ret_9 = Config.getRunningTestsuite();
        txt = simulationResults(txt, ret_9, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -o "));
        txt = Tpl.writeStr(txt, i_settings_outputFormat);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $*"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_112;

protected function lm_113
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_path;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_path :: rest )
      equation
        txt = Tpl.writeStr(txt, i_path);
        txt = Tpl.nextIter(txt);
        txt = lm_113(txt, rest);
      then txt;
  end match;
end lm_113;

protected function fun_114
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_settings_outputFormat;
      String i_fileNamePrefix;
      list<String> i_makefileParams_libPaths;
      SimCode.SimCode i_simCode;
      String i_makefileParams_omhome;
      String i_makefileParams_compileDir;
      String i_settings_method;
      Real i_settings_tolerance;
      Integer i_settings_numberOfIntervals;
      Real i_settings_stepSize;
      Real i_settings_stopTime;
      Real i_settings_startTime;
      Boolean ret_12;
      String ret_11;
      Tpl.Text l_libPaths;
      String ret_9;
      Tpl.Text l_libFolder;
      Tpl.Text l_home;
      Tpl.Text l_moLib;
      Tpl.Text l_solver;
      Tpl.Text l_tol;
      Tpl.Text l_intervals;
      Tpl.Text l_stepsize;
      Tpl.Text l_end;
      Tpl.Text l_start;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(compileDir = i_makefileParams_compileDir, omhome = i_makefileParams_omhome, libPaths = i_makefileParams_libPaths), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_settings_startTime, stopTime = i_settings_stopTime, stepSize = i_settings_stepSize, numberOfIntervals = i_settings_numberOfIntervals, tolerance = i_settings_tolerance, method = i_settings_method, outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix)) )
      equation
        l_start = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_startTime));
        l_end = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stopTime));
        l_stepsize = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stepSize));
        l_intervals = Tpl.writeStr(Tpl.emptyTxt, intString(i_settings_numberOfIntervals));
        l_tol = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_tolerance));
        l_solver = Tpl.writeStr(Tpl.emptyTxt, i_settings_method);
        l_moLib = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_compileDir);
        l_home = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_omhome);
        ret_9 = Config.simulationCodeTarget();
        l_libFolder = simulationLibDir(Tpl.emptyTxt, ret_9, i_simCode);
        l_libPaths = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(";")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libPaths = lm_113(l_libPaths, i_makefileParams_libPaths);
        l_libPaths = Tpl.popIter(l_libPaths);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "@echo off\n",
                                    "REM ::export PATH="
                                }, false));
        txt = Tpl.writeText(txt, l_libFolder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":$PATH REPLACE C: with /C/\n",
                                    "SET PATH="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/bin;"));
        txt = Tpl.writeText(txt, l_libFolder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, l_libPaths);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";%PATH%\n"));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Main.exe -s "));
        txt = Tpl.writeText(txt, l_start);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -e "));
        txt = Tpl.writeText(txt, l_end);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -f "));
        txt = Tpl.writeText(txt, l_stepsize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -v "));
        txt = Tpl.writeText(txt, l_intervals);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -y "));
        txt = Tpl.writeText(txt, l_tol);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -i "));
        txt = Tpl.writeText(txt, l_solver);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -r "));
        ret_11 = Config.simulationCodeTarget();
        txt = simulationLibDir(txt, ret_11, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -m "));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -R "));
        ret_12 = Config.getRunningTestsuite();
        txt = simulationResults(txt, ret_12, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -o "));
        txt = Tpl.writeStr(txt, i_settings_outputFormat);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_114;

protected function lm_115
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_path;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_path :: rest )
      equation
        txt = Tpl.writeStr(txt, i_path);
        txt = Tpl.nextIter(txt);
        txt = lm_115(txt, rest);
      then txt;
  end match;
end lm_115;

protected function fun_116
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_settings_outputFormat;
      String i_fileNamePrefix;
      list<String> i_makefileParams_libPaths;
      SimCode.SimCode i_simCode;
      String i_makefileParams_omhome;
      String i_makefileParams_compileDir;
      String i_settings_method;
      Real i_settings_tolerance;
      Integer i_settings_numberOfIntervals;
      Real i_settings_stepSize;
      Real i_settings_stopTime;
      Real i_settings_startTime;
      Boolean ret_12;
      String ret_11;
      Tpl.Text l_libPaths;
      String ret_9;
      Tpl.Text l_libFolder;
      Tpl.Text l_home;
      Tpl.Text l_moLib;
      Tpl.Text l_solver;
      Tpl.Text l_tol;
      Tpl.Text l_intervals;
      Tpl.Text l_stepsize;
      Tpl.Text l_end;
      Tpl.Text l_start;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(compileDir = i_makefileParams_compileDir, omhome = i_makefileParams_omhome, libPaths = i_makefileParams_libPaths), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(startTime = i_settings_startTime, stopTime = i_settings_stopTime, stepSize = i_settings_stepSize, numberOfIntervals = i_settings_numberOfIntervals, tolerance = i_settings_tolerance, method = i_settings_method, outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix)) )
      equation
        l_start = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_startTime));
        l_end = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stopTime));
        l_stepsize = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_stepSize));
        l_intervals = Tpl.writeStr(Tpl.emptyTxt, intString(i_settings_numberOfIntervals));
        l_tol = Tpl.writeStr(Tpl.emptyTxt, realString(i_settings_tolerance));
        l_solver = Tpl.writeStr(Tpl.emptyTxt, i_settings_method);
        l_moLib = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_compileDir);
        l_home = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_omhome);
        ret_9 = Config.simulationCodeTarget();
        l_libFolder = simulationLibDir(Tpl.emptyTxt, ret_9, i_simCode);
        l_libPaths = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(";")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libPaths = lm_115(l_libPaths, i_makefileParams_libPaths);
        l_libPaths = Tpl.popIter(l_libPaths);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "@echo off\n",
                                    "REM ::export PATH="
                                }, false));
        txt = Tpl.writeText(txt, l_libFolder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":$PATH REPLACE C: with /C/\n",
                                    "SET PATH="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/bin;"));
        txt = Tpl.writeText(txt, l_libFolder);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, l_libPaths);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";%PATH%\n"));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Main.exe -s "));
        txt = Tpl.writeText(txt, l_start);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -e "));
        txt = Tpl.writeText(txt, l_end);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -f "));
        txt = Tpl.writeText(txt, l_stepsize);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -v "));
        txt = Tpl.writeText(txt, l_intervals);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -y "));
        txt = Tpl.writeText(txt, l_tol);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -i "));
        txt = Tpl.writeText(txt, l_solver);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -r "));
        ret_11 = Config.simulationCodeTarget();
        txt = simulationLibDir(txt, ret_11, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -m "));
        txt = Tpl.writeText(txt, l_moLib);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -R "));
        ret_12 = Config.getRunningTestsuite();
        txt = simulationResults(txt, ret_12, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -o "));
        txt = Tpl.writeStr(txt, i_settings_outputFormat);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_116;

protected function fun_117
  input Tpl.Text in_txt;
  input String in_a_makefileParams_platform;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_makefileParams_platform, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;

    case ( txt,
           "linux64",
           a_simCode )
      equation
        txt = fun_111(txt, a_simCode);
      then txt;

    case ( txt,
           "linux32",
           a_simCode )
      equation
        txt = fun_112(txt, a_simCode);
      then txt;

    case ( txt,
           "win32",
           a_simCode )
      equation
        txt = fun_114(txt, a_simCode);
      then txt;

    case ( txt,
           "win64",
           a_simCode )
      equation
        txt = fun_116(txt, a_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_117;

public function simulationMainRunScript
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      String i_makefileParams_platform;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(makefileParams = SimCode.MAKEFILE_PARAMS(platform = i_makefileParams_platform))) )
      equation
        txt = fun_117(txt, i_makefileParams_platform, i_simCode);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationMainRunScript;

protected function fun_119
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_makefileParams_omhome;

    case ( txt,
           SimCode.SIMCODE(makefileParams = SimCode.MAKEFILE_PARAMS(omhome = i_makefileParams_omhome)) )
      equation
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/msvc"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_119;

protected function fun_120
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_makefileParams_omhome;

    case ( txt,
           SimCode.SIMCODE(makefileParams = SimCode.MAKEFILE_PARAMS(omhome = i_makefileParams_omhome)) )
      equation
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_120;

public function simulationLibDir
  input Tpl.Text in_txt;
  input String in_a_target;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_target, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;

    case ( txt,
           "msvc",
           a_simCode )
      equation
        txt = fun_119(txt, a_simCode);
      then txt;

    case ( txt,
           _,
           a_simCode )
      equation
        txt = fun_120(txt, a_simCode);
      then txt;
  end match;
end simulationLibDir;

protected function fun_122
  input Tpl.Text in_txt;
  input Boolean in_a_test;
  input String in_a_makefileParams_compileDir;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_test, in_a_makefileParams_compileDir)
    local
      Tpl.Text txt;
      String a_makefileParams_compileDir;

    case ( txt,
           false,
           a_makefileParams_compileDir )
      equation
        txt = Tpl.writeStr(txt, a_makefileParams_compileDir);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_122;

protected function fun_123
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_test;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_test)
    local
      Tpl.Text txt;
      Boolean a_test;
      String i_settings_outputFormat;
      String i_fileNamePrefix;
      String i_makefileParams_compileDir;
      Tpl.Text l_results;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(compileDir = i_makefileParams_compileDir), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(outputFormat = i_settings_outputFormat)), fileNamePrefix = i_fileNamePrefix),
           a_test )
      equation
        l_results = fun_122(Tpl.emptyTxt, a_test, i_makefileParams_compileDir);
        txt = Tpl.writeText(txt, l_results);
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_res."));
        txt = Tpl.writeStr(txt, i_settings_outputFormat);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_123;

public function simulationResults
  input Tpl.Text txt;
  input Boolean a_test;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_123(txt, a_simCode, a_test);
end simulationResults;

protected function fun_125
  input Tpl.Text in_txt;
  input String in_a_params_platform;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_params_platform)
    local
      Tpl.Text txt;

    case ( txt,
           "win32" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".bat"));
      then txt;

    case ( txt,
           "win64" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".bat"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".sh"));
      then txt;
  end match;
end fun_125;

public function simulationMainRunScriptSuffix
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_params_platform;

    case ( txt,
           SimCode.SIMCODE(makefileParams = SimCode.MAKEFILE_PARAMS(platform = i_params_platform)) )
      equation
        txt = fun_125(txt, i_params_platform);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationMainRunScriptSuffix;

protected function fun_127
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "none" )
      then txt;

    case ( txt,
           "all_perf" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"Core/Utils/extension/measure_time_papi.hpp\""));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"Core/Utils/extension/measure_time_rdtsc.hpp\""));
      then txt;
  end match;
end fun_127;

protected function fun_128
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "none" )
      then txt;

    case ( txt,
           "all_perf" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MeasureTimePAPI::initialize();"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MeasureTimeRDTSC::initialize();"));
      then txt;
  end match;
end fun_128;

protected function fun_129
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MeasureTime::getInstance()->writeToJson();\n",
                                    "//MeasureTimeRDTSC::deinitialize();"
                                }, false));
      then txt;
  end match;
end fun_129;

public function simulationMainFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      String i_makefileParams_dllext;
      String i_fileNamePrefix;
      Boolean ret_4;
      Boolean ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), makefileParams = SimCode.MAKEFILE_PARAMS(dllext = i_makefileParams_dllext), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifndef BOOST_ALL_DYN_LINK\n",
                                    "  #define BOOST_ALL_DYN_LINK\n",
                                    "#endif\n",
                                    "#include <Core/Modelica.h>\n",
                                    "#include <Core/ModelicaDefine.h>\n",
                                    "#include <SimCoreFactory/Policies/FactoryConfig.h>\n",
                                    "#include <SimController/ISimController.h>\n"
                                }, true));
        ret_0 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        txt = fun_127(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#if defined(_MSC_VER) || defined(__MINGW32__)\n",
                                    "#include <tchar.h>\n",
                                    "int _tmain(int argc, const _TCHAR* argv[])\n",
                                    "#else\n",
                                    "int main(int argc, const char* argv[])\n",
                                    "#endif\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        ret_1 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        txt = fun_128(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "try\n",
                                    "{\n",
                                    "      boost::shared_ptr<OMCFactory>  _factory =  boost::shared_ptr<OMCFactory>(new OMCFactory());\n",
                                    "      //SimController to start simulation\n",
                                    "\n",
                                    "      std::pair<boost::shared_ptr<ISimController>,SimSettings> simulation =  _factory->createSimulation(argc,argv);\n",
                                    "\n",
                                    "      //create Modelica system\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("std::pair<boost::shared_ptr<IMixedSystem>,boost::shared_ptr<ISimData> > system = simulation.first->LoadSystem(\"OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\",\""));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\");\n",
                                    "\n",
                                    "simulation.first->Start(system.first,simulation.second,\""
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\");\n",
                                    "\n"
                                }, true));
        ret_2 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        ret_3 = stringEq(ret_2, "none");
        ret_4 = boolNot(ret_3);
        txt = fun_129(txt, ret_4);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "return 0;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "catch(std::exception& ex)\n",
                                    "{\n",
                                    "    std::string error = ex.what();\n",
                                    "    std::cerr << \"Simulation stopped: \"<<  error ;\n",
                                    "    return 1;\n",
                                    "}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationMainFile;

public function calcHelperMainfile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), fileNamePrefix = i_fileNamePrefix) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Helper file that includes all generated calculation files, except the alg loops.\n",
                                    "* This file is generated by the OpenModelica Compiler and produced to speed-up the compile time.\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "\n",
                                    "#include <Core/Modelica.h>\n",
                                    "#include <Core/ModelicaDefine.h>\n",
                                    "\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Types.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension.cpp\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "FactoryExport.cpp\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Functions.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Functions.cpp\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize.cpp\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian.cpp\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection.cpp\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WriteOutput.cpp\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end calcHelperMainfile;

public function algloopHeaderFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)),
           a_eq,
           a_context,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateAlgloopHeaderInlcudeString(txt, i_simCode, a_context);
        txt = Tpl.softNewLine(txt);
        txt = generateAlgloopClassDeclarationCode(txt, i_simCode, a_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end algloopHeaderFile;

protected function lm_133
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConstImpl(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_133(txt, rest);
      then txt;
  end match;
end lm_133;

protected function fun_134
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Function> in_a_functions;
  input list<String> in_a_includes;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_functions, in_a_includes, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      list<String> a_includes;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      list<DAE.Exp> i_literals;
      String i_fileNamePrefix;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), fileNamePrefix = i_fileNamePrefix, literals = i_literals)),
           a_functions,
           a_includes,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* #include <Core/Modelica.h>\n",
                                    "#include <Core/ModelicaDefine.h>\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Functions.h\" */\n",
                                    "\n"
                                }, true));
        txt = externalFunctionIncludes(txt, a_includes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    " Functions::Functions(double& simTime,double* z,double* zDot,bool& initial,bool& terminate)\n",
                                    " :_simTime(simTime)\n",
                                    " ,__z(z)\n",
                                    " ,__zDot(zDot)\n",
                                    " ,_initial(initial)\n",
                                    " ,_terminate(terminate)\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_133(txt, i_literals);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " initialize();\n",
                                    " }\n",
                                    "\n",
                                    " Functions::~Functions()\n",
                                    " {\n",
                                    " }\n",
                                    "  void Functions::Assert(bool cond,string msg)\n",
                                    "  {\n",
                                    "      if(!cond)\n",
                                    "          throw std::runtime_error(msg);\n",
                                    "  }\n",
                                    "\n",
                                    "void Functions::initialize()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = initParams1(txt, a_functions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = functionBodies(txt, a_functions, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_134;

public function simulationFunctionsFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;
  input list<String> a_includes;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_134(txt, a_simCode, a_functions, a_includes, a_useFlatArrayNotation);
end simulationFunctionsFile;

protected function lm_136
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_136(txt, rest);
      then txt;
  end match;
end lm_136;

public function externalFunctionIncludes
  input Tpl.Text in_txt;
  input list<String> in_a_includes;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_includes)
    local
      Tpl.Text txt;
      list<String> i_includes;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_includes )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_136(txt, i_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif"
                                }, false));
      then txt;
  end match;
end externalFunctionIncludes;

protected function fun_138
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Function> in_a_functions;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_functions, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _))),
           a_functions,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "\n",
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation data types generated by the OpenModelica Compiler.\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "//external c functions\n",
                                    "extern \"C\" {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = externfunctionHeaderDefinition(txt, a_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = functionHeaderBodies1(txt, a_functions, i_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_138;

public function simulationTypesHeaderFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_138(txt, a_simCode, a_functions, a_useFlatArrayNotation);
end simulationTypesHeaderFile;

protected function lm_140
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Integer x_i0;
      DAE.Exp i_literal;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_literal :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = literalExpConst(txt, i_literal, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_140(txt, rest);
      then txt;
  end match;
end lm_140;

protected function fun_141
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Function> in_a_functions;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_functions, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      Boolean a_useFlatArrayNotation;
      list<DAE.Exp> i_literals;
      SimCode.SimCode i_simCode;
      String i_fileNamePrefix;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), fileNamePrefix = i_fileNamePrefix, literals = i_literals)),
           a_functions,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "\n",
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code for FunctionCall functions generated by the OpenModelica Compiler.\n",
                                    "*\n",
                                    "*****************************************************************************/\n",
                                    "//external c functions\n",
                                    "extern \"C\" {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = externfunctionHeaderDefinition(txt, a_functions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Types.h\"\n",
                                    "\n",
                                    "class Functions\n",
                                    "   {\n",
                                    "    public:\n",
                                    "      Functions(double& simTime,double* z,double* zDot,bool& initial,bool& terminate);\n",
                                    "     ~Functions();\n",
                                    "     //Modelica functions\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = functionHeaderBodies2(txt, a_functions, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void Assert(bool cond,string msg);\n",
                                    "\n",
                                    "//Literals\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_140(txt, i_literals);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   private:\n",
                                    "   void initialize();\n",
                                    "\n",
                                    "     //Function return variables\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = functionHeaderBodies3(txt, a_functions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "double& _simTime;\n",
                                    "bool& _terminate;\n",
                                    "bool& _initial;\n",
                                    "double* __z;\n",
                                    "double* __zDot;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("   // function paramter variables\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = allocateParams1(txt, a_functions, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "};"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_141;

public function simulationFunctionsHeaderFile
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input list<SimCode.Function> a_functions;
  input list<DAE.Exp> a_literals;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_141(txt, a_simCode, a_functions, a_useFlatArrayNotation);
end simulationFunctionsHeaderFile;

protected function lm_143
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = allocateParams2(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_143(txt, rest, a_simCode);
      then txt;
  end match;
end lm_143;

public function allocateParams1
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_params;
algorithm
  l_params := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_params := lm_143(l_params, a_functions, a_simCode);
  l_params := Tpl.popIter(l_params);
  out_txt := Tpl.writeText(txt, l_params);
end allocateParams1;

protected function lm_145
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = paramInit(txt, i_var, "", x_i1, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_145(txt, rest, a_simCode);
      then txt;
  end match;
end lm_145;

public function allocateParams2
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_variableDeclarations;
      Tpl.Text l_params;

    case ( txt,
           SimCode.FUNCTION(variableDeclarations = i_variableDeclarations),
           a_simCode )
      equation
        l_params = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_params = lm_145(l_params, i_variableDeclarations, a_simCode);
        l_params = Tpl.popIter(l_params);
        txt = Tpl.writeText(txt, l_params);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end allocateParams2;

protected function fun_147
  input Tpl.Text in_txt;
  input DAE.VarKind in_a_kind;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_kind, in_a_simCode, in_a_varInits, in_a_varDecls, in_a_i, in_a_var)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer a_i;
      SimCode.Variable a_var;

    case ( txt,
           DAE.PARAM(),
           a_simCode,
           a_varInits,
           a_varDecls,
           a_i,
           a_var )
      equation
        (txt, a_varDecls, a_varInits) = varInit(txt, a_var, "", a_i, a_varDecls, a_varInits, a_simCode, false);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           a_varDecls,
           _,
           _ )
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_147;

protected function fun_148
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_var, in_a_simCode, in_a_varInits, in_a_varDecls, in_a_i)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer a_i;
      SimCode.Variable i_var;
      DAE.VarKind i_kind;

    case ( txt,
           (i_var as SimCode.VARIABLE(kind = i_kind)),
           a_simCode,
           a_varInits,
           a_varDecls,
           a_i )
      equation
        (txt, a_varInits, a_varDecls) = fun_147(txt, i_kind, a_simCode, a_varInits, a_varDecls, a_i, i_var);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           a_varDecls,
           _ )
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_148;

public function paramInit
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input String a_outStruct;
  input Integer a_i;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_dump;
  Tpl.Text l_varInits;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_varInits := Tpl.emptyTxt;
  (l_dump, l_varInits, l_varDecls) := fun_148(Tpl.emptyTxt, a_var, a_simCode, l_varInits, l_varDecls, a_i);
  out_txt := Tpl.writeText(txt, l_varDecls);
end paramInit;

protected function lm_150
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = initParams2(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_150(txt, rest, a_simCode);
      then txt;
  end match;
end lm_150;

public function initParams1
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_params;
algorithm
  l_params := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_params := lm_150(l_params, a_functions, a_simCode);
  l_params := Tpl.popIter(l_params);
  out_txt := Tpl.writeText(txt, l_params);
end initParams1;

protected function lm_152
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = paramInit2(txt, i_var, "", x_i1, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_152(txt, rest, a_simCode);
      then txt;
  end match;
end lm_152;

public function initParams2
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_variableDeclarations;
      Tpl.Text l_params;

    case ( txt,
           SimCode.FUNCTION(variableDeclarations = i_variableDeclarations),
           a_simCode )
      equation
        l_params = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_params = lm_152(l_params, i_variableDeclarations, a_simCode);
        l_params = Tpl.popIter(l_params);
        txt = Tpl.writeText(txt, l_params);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initParams2;

protected function fun_154
  input Tpl.Text in_txt;
  input DAE.VarKind in_a_kind;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_kind, in_a_simCode, in_a_varInits, in_a_varDecls, in_a_i, in_a_var)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer a_i;
      SimCode.Variable a_var;

    case ( txt,
           DAE.PARAM(),
           a_simCode,
           a_varInits,
           a_varDecls,
           a_i,
           a_var )
      equation
        (txt, a_varDecls, a_varInits) = varInit(txt, a_var, "", a_i, a_varDecls, a_varInits, a_simCode, false);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           a_varDecls,
           _,
           _ )
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_154;

protected function fun_155
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_var, in_a_simCode, in_a_varInits, in_a_varDecls, in_a_i)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer a_i;
      SimCode.Variable i_var;
      DAE.VarKind i_kind;

    case ( txt,
           (i_var as SimCode.VARIABLE(kind = i_kind)),
           a_simCode,
           a_varInits,
           a_varDecls,
           a_i )
      equation
        (txt, a_varInits, a_varDecls) = fun_154(txt, i_kind, a_simCode, a_varInits, a_varDecls, a_i, i_var);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           a_varDecls,
           _ )
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_155;

public function paramInit2
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input String a_outStruct;
  input Integer a_i;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_dump;
  Tpl.Text l_varInits;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_varInits := Tpl.emptyTxt;
  (l_dump, l_varInits, l_varDecls) := fun_155(Tpl.emptyTxt, a_var, a_simCode, l_varInits, l_varDecls, a_i);
  out_txt := Tpl.writeText(txt, l_varInits);
end paramInit2;

protected function fun_157
  input Tpl.Text in_txt;
  input DAE.VarKind in_a_kind;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_kind, in_a_simCode, in_a_varInits, in_a_varDecls, in_a_i, in_a_var)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer a_i;
      SimCode.Variable a_var;

    case ( txt,
           DAE.VARIABLE(),
           a_simCode,
           a_varInits,
           a_varDecls,
           a_i,
           a_var )
      equation
        (txt, a_varDecls, a_varInits) = varInit(txt, a_var, "", a_i, a_varDecls, a_varInits, a_simCode, true);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           DAE.DISCRETE(),
           a_simCode,
           a_varInits,
           a_varDecls,
           a_i,
           a_var )
      equation
        (txt, a_varDecls, a_varInits) = varInit(txt, a_var, "", a_i, a_varDecls, a_varInits, a_simCode, true);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           a_varDecls,
           _,
           _ )
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_157;

protected function fun_158
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input Integer in_a_i;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_var, in_a_simCode, in_a_varInits, in_a_varDecls, in_a_i)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer a_i;
      SimCode.Variable i_var;
      DAE.VarKind i_kind;

    case ( txt,
           (i_var as SimCode.VARIABLE(kind = i_kind)),
           a_simCode,
           a_varInits,
           a_varDecls,
           a_i )
      equation
        (txt, a_varInits, a_varDecls) = fun_157(txt, i_kind, a_simCode, a_varInits, a_varDecls, a_i, i_var);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           a_varDecls,
           _ )
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_158;

public function notparamInit
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input String a_outStruct;
  input Integer a_i;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varInits;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
protected
  Tpl.Text l_dump;
algorithm
  (l_dump, out_a_varInits, out_a_varDecls) := fun_158(Tpl.emptyTxt, a_var, a_simCode, a_varInits, a_varDecls, a_i);
  out_txt := txt;
end notparamInit;

public function simulationMainDLLib
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_makefileParams_platform;

    case ( txt,
           SimCode.SIMCODE(makefileParams = SimCode.MAKEFILE_PARAMS(platform = i_makefileParams_platform)) )
      equation
        txt = simulationMainDLLib2(txt, i_makefileParams_platform);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationMainDLLib;

public function simulationMainDLLib2
  input Tpl.Text in_txt;
  input String in_a_platform;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_platform)
    local
      Tpl.Text txt;

    case ( txt,
           "linux64" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"-ldl\""));
      then txt;

    case ( txt,
           "linux32" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"-ldl\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end simulationMainDLLib2;

protected function fun_162
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_162;

protected function lm_163
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_163(txt, rest);
      then txt;
  end match;
end lm_163;

protected function fun_164
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_164;

protected function fun_165
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_165;

protected function fun_166
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lOMOCLRuntime -lOpenCL"));
      then txt;
  end match;
end fun_166;

protected function fun_167
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "dassljac" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_JACOBIAN "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_167;

protected function fun_168
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(method = i_s_method)) )
      equation
        txt = fun_167(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_168;

protected function lm_169
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = lm_169(txt, rest);
      then txt;
  end match;
end lm_169;

protected function lm_170
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = lm_170(txt, rest);
      then txt;
  end match;
end lm_170;

protected function fun_171
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end match;
end fun_171;

protected function fun_172
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_additionalCFlags__MSVC;
  input Tpl.Text in_a_timeMeasureLink;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_timeMeasureLink;
algorithm
  (out_txt, out_a_timeMeasureLink) :=
  match(in_txt, in_a_simCode, in_a_additionalCFlags__MSVC, in_a_timeMeasureLink)
    local
      Tpl.Text txt;
      String a_additionalCFlags__MSVC;
      Tpl.Text a_timeMeasureLink;
      String i_fileNamePrefix;
      list<String> i_makefileParams_includes;
      String i_makefileParams_omhome;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Boolean ret_7;
      Tpl.Text l_extraCflags;
      Boolean ret_5;
      Tpl.Text l_ParModelicaLibs;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, omhome = i_makefileParams_omhome, includes = i_makefileParams_includes), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix),
           a_additionalCFlags__MSVC,
           a_timeMeasureLink )
      equation
        l_dirExtra = fun_162(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_163(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_164(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_165(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        ret_5 = Config.acceptParModelicaGrammar();
        l_ParModelicaLibs = fun_166(Tpl.emptyTxt, ret_5);
        a_timeMeasureLink = Tpl.writeTok(a_timeMeasureLink, Tpl.ST_STRING("OMCppExtensionUtilities.lib"));
        l_extraCflags = fun_168(Tpl.emptyTxt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=\n",
                                    "MODELICAUSERCFLAGS=\n",
                                    "CXX=cl\n",
                                    "EXEEXT=.exe\n",
                                    "DLLEXT=.dll\n",
                                    "include "
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc/cpp/ModelicaConfig.inc\n",
                                    "# /Od - Optimization disabled\n",
                                    "# /EHa enable C++ EH (w/ SEH exceptions)\n",
                                    "# /fp:except - consider floating-point exceptions when generating code\n",
                                    "# /arch:SSE2 - enable use of instructions available with SSE2 enabled CPUs\n",
                                    "# /I - Include Directories\n",
                                    "# /DNOMINMAX - Define NOMINMAX (does what it says)\n",
                                    "# /TP - Use C++ Compiler\n",
                                    "!IF \"$(PCH_FILE)\" == \"\"\n",
                                    "CFLAGS=  $(SYSTEM_CFLAGS) /I\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/Core/\" /I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/\" /I. "));
        txt = lm_169(txt, i_makefileParams_includes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  /I\"$(BOOST_INCLUDE)\" /I\"$(SUITESPARSE_INCLUDE)\" /DNOMINMAX /TP /DNO_INTERACTIVE_DEPENDENCY "));
        txt = Tpl.writeStr(txt, a_additionalCFlags__MSVC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "!ELSE\n",
                                    "CFLAGS=  $(SYSTEM_CFLAGS) /I\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/Core/\" /I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/\" /I. "));
        txt = lm_170(txt, i_makefileParams_includes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  /I\"$(BOOST_INCLUDE)\" /I\"$(SUITESPARSE_INCLUDE)\" /DNOMINMAX /TP /DNO_INTERACTIVE_DEPENDENCY  /Fp"));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/Core/$(PCH_FILE)  /YuCore/$(H_FILE) "));
        txt = Tpl.writeStr(txt, a_additionalCFlags__MSVC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "!ENDIF\n",
                                    "CPPFLAGS =\n",
                                    "# /ZI enable Edit and Continue debug info\n",
                                    "CDFLAGS = /ZI\n",
                                    "\n",
                                    "# /MD - link with MSVCRT.LIB\n",
                                    "# /link - [linker options and libraries]\n",
                                    "# /LIBPATH: - Directories where libs can be found\n",
                                    "#LDFLAGS=/MDd   /link /DLL /NOENTRY /LIBPATH:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/msvc\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/bin\" /LIBPATH:\"$(BOOST_LIBS)\" OMCppSystem.lib OMCppMath.lib\n",
                                    "#LDSYTEMFLAGS=/MD /Debug  /link /DLL /NOENTRY /LIBPATH:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/msvc\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/bin\" /LIBPATH:\"$(BOOST_LIBS)\" OMCppSystem.lib OMCppModelicaUtilities.lib  OMCppMath.lib   OMCppOMCFactory.lib\n",
                                    "LDSYTEMFLAGS=  /link /DLL /NOENTRY /LIBPATH:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/msvc\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/bin\" /LIBPATH:\"$(BOOST_LIBS)\" OMCppSystem.lib OMCppModelicaUtilities.lib  OMCppMath.lib   OMCppOMCFactory.lib "));
        txt = Tpl.writeText(txt, a_timeMeasureLink);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#LDMAINFLAGS=/MD /Debug  /link /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/msvc\" OMCppOMCFactory.lib  /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/bin\" /LIBPATH:\"$(BOOST_LIBS)\"\n",
                                    "LDMAINFLAGS=/link /LIBPATH:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp/msvc\" OMCppOMCFactory.lib "));
        txt = Tpl.writeText(txt, a_timeMeasureLink);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/bin\" /LIBPATH:\"$(BOOST_LIBS)\"\n",
                                    "# /MDd link with MSVCRTD.LIB debug lib\n",
                                    "# lib names should not be appended with a d just switch to lib/omc/cpp\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "FILEPREFIX="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("FUNCTIONFILE=OMCpp"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Functions.cpp\n",
                                    "INITFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize.cpp\n",
                                    "FACTORYFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "FactoryExport.cpp\n",
                                    "EXTENSIONFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension.cpp\n",
                                    "JACOBIANFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Jacobian.cpp\n",
                                    "STATESELECTIONFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "StateSelection.cpp\n",
                                    "WRITEOUTPUTFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput.cpp\n",
                                    "SYSTEMFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        ret_7 = Config.acceptMetaModelicaGrammar();
        txt = fun_171(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".cpp\n",
                                    "MAINFILE = OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Main.cpp\n",
                                    "MAINOBJ=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Main$(EXEEXT)\n",
                                    "SYSTEMOBJ=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(DLLEXT)\n",
                                    "\n",
                                    "CALCHELPERMAINFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "CalcHelperMain.cpp\n",
                                    "ALGLOOPMAINFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "AlgLoopMain.cpp\n",
                                    "GENERATEDFILES=$(MAINFILE) $(FUNCTIONFILE) $(ALGLOOPMAINFILE)\n",
                                    "\n",
                                    "$(MODELICA_SYSTEM_LIB)$(DLLEXT):\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX)  /Fe$(SYSTEMOBJ) $(SYSTEMFILE) $(CALCHELPERMAINFILE) $(ALGLOOPMAINFILE) $(CFLAGS) $(LDSYTEMFLAGS) "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) $(CPPFLAGS) /Fe$(MAINOBJ)  $(MAINFILE)   $(CFLAGS) $(LDMAINFLAGS)"));
        txt = Tpl.popBlock(txt);
      then (txt, a_timeMeasureLink);

    case ( txt,
           _,
           _,
           a_timeMeasureLink )
      then (txt, a_timeMeasureLink);
  end match;
end fun_172;

protected function fun_173
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_173;

protected function lm_174
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_174(txt, rest);
      then txt;
  end match;
end lm_174;

protected function fun_175
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_175;

protected function fun_176
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_176;

protected function fun_177
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(startTime = _)) )
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_177;

protected function fun_178
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -g"));
      then txt;
  end match;
end fun_178;

protected function fun_179
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_omHome;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_omHome)
    local
      Tpl.Text txt;
      Tpl.Text a_omHome;

    case ( txt,
           "all_perf",
           a_omHome )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-rpath,\""));
        txt = Tpl.writeText(txt, a_omHome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp\" -lOMCppExtensionUtilities -lOMCppExtensionUtilities_papi -lpapi"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_omHome )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-rpath,\""));
        txt = Tpl.writeText(txt, a_omHome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp\" -lOMCppExtensionUtilities"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_179;

protected function fun_180
  input Tpl.Text in_txt;
  input Boolean in_a_compileForMPI;
  input String in_a_makefileParams_ccompiler;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_compileForMPI, in_a_makefileParams_ccompiler)
    local
      Tpl.Text txt;
      String a_makefileParams_ccompiler;

    case ( txt,
           false,
           a_makefileParams_ccompiler )
      equation
        txt = Tpl.writeStr(txt, a_makefileParams_ccompiler);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mpicc"));
      then txt;
  end match;
end fun_180;

protected function fun_181
  input Tpl.Text in_txt;
  input Boolean in_a_compileForMPI;
  input String in_a_makefileParams_cxxcompiler;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_compileForMPI, in_a_makefileParams_cxxcompiler)
    local
      Tpl.Text txt;
      String a_makefileParams_cxxcompiler;

    case ( txt,
           false,
           a_makefileParams_cxxcompiler )
      equation
        txt = Tpl.writeStr(txt, a_makefileParams_cxxcompiler);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mpicxx"));
      then txt;
  end match;
end fun_181;

protected function fun_182
  input Tpl.Text in_txt;
  input Boolean in_a_compileForMPI;
  input String in_a_makefileParams_cxxcompiler;
  input String in_a_makefileParams_ccompiler;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_compileForMPI, in_a_makefileParams_cxxcompiler, in_a_makefileParams_ccompiler)
    local
      Tpl.Text txt;
      String a_makefileParams_cxxcompiler;
      String a_makefileParams_ccompiler;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_makefileParams_cxxcompiler,
           a_makefileParams_ccompiler )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("OMPI_MPICC="));
        txt = Tpl.writeStr(txt, a_makefileParams_ccompiler);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("OMPI_MPICXX="));
        txt = Tpl.writeStr(txt, a_makefileParams_cxxcompiler);
      then txt;
  end match;
end fun_182;

protected function lm_183
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = lm_183(txt, rest);
      then txt;
  end match;
end lm_183;

protected function lm_184
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_184(txt, rest);
      then txt;
  end match;
end lm_184;

protected function fun_185
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_185;

protected function fun_186
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".conv"));
      then txt;
  end match;
end fun_186;

protected function fun_187
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("chmod +x "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".sh\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ln -s "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".sh "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
      then txt;
  end match;
end fun_187;

protected function fun_188
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_additionalLinkerFlags__GCC;
  input String in_a_additionalCFlags__GCC;
  input Boolean in_a_compileForMPI;
  input Tpl.Text in_a_timeMeasureLink;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_timeMeasureLink;
algorithm
  (out_txt, out_a_timeMeasureLink) :=
  match(in_txt, in_a_simCode, in_a_additionalLinkerFlags__GCC, in_a_additionalCFlags__GCC, in_a_compileForMPI, in_a_timeMeasureLink)
    local
      Tpl.Text txt;
      String a_additionalLinkerFlags__GCC;
      String a_additionalCFlags__GCC;
      Boolean a_compileForMPI;
      Tpl.Text a_timeMeasureLink;
      String i_makefileParams_platform;
      Absyn.Path i_modelInfo_name;
      String i_fileNamePrefix;
      list<String> i_makefileParams_includes;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      String i_makefileParams_omhome;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Boolean ret_14;
      Boolean ret_13;
      Boolean ret_12;
      Tpl.Text l_MPIEnvVars;
      Tpl.Text l_CXX;
      Tpl.Text l_CC;
      String ret_8;
      Tpl.Text l_omHome;
      Boolean ret_6;
      Tpl.Text l_extraCflags;
      Tpl.Text l_0__extraCflags;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory, name = i_modelInfo_name), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, omhome = i_makefileParams_omhome, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, includes = i_makefileParams_includes, platform = i_makefileParams_platform), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix),
           a_additionalLinkerFlags__GCC,
           a_additionalCFlags__GCC,
           a_compileForMPI,
           a_timeMeasureLink )
      equation
        l_dirExtra = fun_173(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_174(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_175(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_176(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_0__extraCflags = fun_177(Tpl.emptyTxt, i_sopt);
        l_extraCflags = Tpl.writeText(Tpl.emptyTxt, l_0__extraCflags);
        ret_6 = Flags.isSet(Flags.GEN_DEBUG_SYMBOLS);
        l_extraCflags = fun_178(l_extraCflags, ret_6);
        l_omHome = Tpl.writeStr(Tpl.emptyTxt, i_makefileParams_omhome);
        ret_8 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        a_timeMeasureLink = fun_179(a_timeMeasureLink, ret_8, l_omHome);
        l_CC = fun_180(Tpl.emptyTxt, a_compileForMPI, i_makefileParams_ccompiler);
        l_CXX = fun_181(Tpl.emptyTxt, a_compileForMPI, i_makefileParams_cxxcompiler);
        l_MPIEnvVars = fun_182(Tpl.emptyTxt, a_compileForMPI, i_makefileParams_cxxcompiler, i_makefileParams_ccompiler);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "OMHOME="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("include "));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc/cpp/ModelicaConfig.inc\n",
                                    "include "
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/include/omc/cpp/ModelicaLibraryConfig.inc\n",
                                    "# Simulations use -O0 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O0\n",
                                    "CC="
                                }, false));
        txt = Tpl.writeText(txt, l_CC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeText(txt, l_CXX);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_MPIEnvVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) -Winvalid-pch $(SYSTEM_CFLAGS) -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/Core\" -I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/cpp/\"   -I. "));
        txt = lm_183(txt, i_makefileParams_includes);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -I\"$(BOOST_INCLUDE)\" -I\"$(SUITESPARSE_INCLUDE)\" "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_184(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_185(txt, i_sopt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_additionalCFlags__GCC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDSYTEMFLAGS=-L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp\" $(BASE_LIB)  -lOMCppOMCFactory -lOMCppSystem -lOMCppModelicaUtilities -lOMCppMath "));
        txt = Tpl.writeText(txt, a_timeMeasureLink);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " -L\"$(BOOST_LIBS)\"  $(BOOST_SYSTEM_LIB) $(BOOST_FILESYSTEM_LIB) $(BOOST_PROGRAM_OPTIONS_LIB) $(BOOST_LOG_LIB) $(BOOST_THREAD_LIB) $(LINUX_LIB_DL)\n",
                                    "LDMAINFLAGS=-L\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/cpp\" -L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/bin\" -lOMCppOMCFactory "));
        txt = Tpl.writeText(txt, a_timeMeasureLink);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -L\"$(BOOST_LIBS)\" $(BOOST_SYSTEM_LIB) $(BOOST_FILESYSTEM_LIB) $(BOOST_PROGRAM_OPTIONS_LIB) $(LINUX_LIB_DL) "));
        txt = Tpl.writeStr(txt, a_additionalLinkerFlags__GCC);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "CPPFLAGS = $(CFLAGS)\n",
                                    "SYSTEMFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        ret_12 = Config.acceptMetaModelicaGrammar();
        txt = fun_186(txt, ret_12);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".cpp\n",
                                    "MAINFILE = OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Main.cpp\n",
                                    "MAINOBJ=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Main$(EXEEXT)\n",
                                    "SYSTEMOBJ=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(DLLEXT)\n",
                                    "\n",
                                    "CALCHELPERMAINFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "CalcHelperMain.cpp\n",
                                    "ALGLOOPSMAINFILE=OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "AlgLoopMain.cpp\n",
                                    "\n",
                                    "CPPFILES=$(SYSTEMFILE) $(CALCHELPERMAINFILE) $(ALGLOOPSMAINFILE)\n",
                                    "OFILES=$(CPPFILES:.cpp=.o)\n",
                                    "\n",
                                    ".PHONY: "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " $(CPPFILES)\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(": $(MAINFILE) $(OFILES)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) -shared -I. -o $(SYSTEMOBJ) $(OFILES) $(CPPFLAGS)  "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  $(LDSYTEMFLAGS)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(CXX) $(CPPFLAGS) -I. -o $(MAINOBJ) $(MAINFILE) $(LDMAINFLAGS)\n",
                                    "\n"
                                }, true));
        ret_13 = stringEq(i_makefileParams_platform, "win32");
        ret_14 = boolNot(ret_13);
        txt = fun_187(txt, ret_14, i_fileNamePrefix);
      then (txt, a_timeMeasureLink);

    case ( txt,
           _,
           _,
           _,
           _,
           a_timeMeasureLink )
      then (txt, a_timeMeasureLink);
  end match;
end fun_188;

protected function fun_189
  input Tpl.Text in_txt;
  input String in_a_target;
  input String in_a_additionalLinkerFlags__GCC;
  input String in_a_additionalCFlags__GCC;
  input Boolean in_a_compileForMPI;
  input String in_a_additionalCFlags__MSVC;
  input Tpl.Text in_a_timeMeasureLink;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_timeMeasureLink;
algorithm
  (out_txt, out_a_timeMeasureLink) :=
  match(in_txt, in_a_target, in_a_additionalLinkerFlags__GCC, in_a_additionalCFlags__GCC, in_a_compileForMPI, in_a_additionalCFlags__MSVC, in_a_timeMeasureLink, in_a_simCode)
    local
      Tpl.Text txt;
      String a_additionalLinkerFlags__GCC;
      String a_additionalCFlags__GCC;
      Boolean a_compileForMPI;
      String a_additionalCFlags__MSVC;
      Tpl.Text a_timeMeasureLink;
      SimCode.SimCode a_simCode;

    case ( txt,
           "msvc",
           _,
           _,
           _,
           a_additionalCFlags__MSVC,
           a_timeMeasureLink,
           a_simCode )
      equation
        (txt, a_timeMeasureLink) = fun_172(txt, a_simCode, a_additionalCFlags__MSVC, a_timeMeasureLink);
      then (txt, a_timeMeasureLink);

    case ( txt,
           "gcc",
           a_additionalLinkerFlags__GCC,
           a_additionalCFlags__GCC,
           a_compileForMPI,
           _,
           a_timeMeasureLink,
           a_simCode )
      equation
        (txt, a_timeMeasureLink) = fun_188(txt, a_simCode, a_additionalLinkerFlags__GCC, a_additionalCFlags__GCC, a_compileForMPI, a_timeMeasureLink);
      then (txt, a_timeMeasureLink);

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           a_timeMeasureLink,
           _ )
      then (txt, a_timeMeasureLink);
  end match;
end fun_189;

public function simulationMakefile
  input Tpl.Text txt;
  input String a_target;
  input SimCode.SimCode a_simCode;
  input String a_additionalLinkerFlags__GCC;
  input String a_additionalLinkerFlags__MSVC;
  input String a_additionalCFlags__GCC;
  input String a_additionalCFlags__MSVC;
  input Boolean a_compileForMPI;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_timeMeasureLink;
algorithm
  l_timeMeasureLink := Tpl.emptyTxt;
  (out_txt, l_timeMeasureLink) := fun_189(txt, a_target, a_additionalLinkerFlags__GCC, a_additionalCFlags__GCC, a_compileForMPI, a_additionalCFlags__MSVC, l_timeMeasureLink, a_simCode);
end simulationMakefile;

protected function fun_191
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_allEquations)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimResidues="));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_191;

protected function fun_192
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Absyn.Path in_a_modelInfo_name;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_modelInfo_name, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path a_modelInfo_name;
      SimCode.SimCode a_simCode;
      Integer ret_1;
      Tpl.Text l_numOfEqs;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_modelInfo_name,
           a_simCode )
      equation
        ret_1 = SimCodeUtil.getMaxSimEqSystemIndex(a_simCode);
        l_numOfEqs = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("measureTimeProfileBlocksArray = std::vector<MeasureTimeData>("));
        txt = Tpl.writeText(txt, l_numOfEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MeasureTime::addResultContentBlock(\""
                                }, false));
        txt = dotPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\",\"profileBlocks\",&measureTimeProfileBlocksArray);\n",
                                    "measureTimeFunctionsArray = std::vector<MeasureTimeData>(3); //1 evaluateODE ; 2 evaluateAll; 3 writeOutput\n",
                                    "MeasureTime::addResultContentBlock(\""
                                }, false));
        txt = dotPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\",\"functions\",&measureTimeFunctionsArray);\n",
                                    "measuredProfileBlockStartValues = MeasureTime::getZeroValues();\n",
                                    "measuredProfileBlockEndValues = MeasureTime::getZeroValues();\n",
                                    "measuredFunctionStartValues = MeasureTime::getZeroValues();\n",
                                    "measuredFunctionEndValues = MeasureTime::getZeroValues();\n",
                                    "\n",
                                    "for(int i = 0; i < "
                                }, false));
        txt = Tpl.writeText(txt, l_numOfEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; i++)\n",
                                    "{\n",
                                    "    ostringstream ss;\n",
                                    "    ss << i;\n",
                                    "    measureTimeProfileBlocksArray[i] = MeasureTimeData(ss.str());\n",
                                    "}\n",
                                    "\n",
                                    "measureTimeFunctionsArray[0] = MeasureTimeData(\"evaluateODE\");\n",
                                    "measureTimeFunctionsArray[1] = MeasureTimeData(\"evaluateAll\");\n",
                                    "measureTimeFunctionsArray[2] = MeasureTimeData(\"writeOutput\");"
                                }, false));
      then txt;
  end match;
end fun_192;

public function simulationCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<String> i_modelInfo_labels;
      SimCode.ModelInfo i_modelInfo;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<BackendDAE.TimeEvent> i_timeEvents;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      list<DAE.ComponentRef> i_discreteModelVars;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.SimCode i_simCode;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      list<SimCode.SimEqSystem> ret_7;
      list<SimCode.SimEqSystem> ret_6;
      list<SimCode.SimEqSystem> ret_5;
      Boolean ret_4;
      Boolean ret_3;
      String ret_2;
      Boolean ret_1;
      Tpl.Text l_className;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name, labels = i_modelInfo_labels)), fileNamePrefix = i_fileNamePrefix, allEquations = i_allEquations, discreteModelVars = i_discreteModelVars, zeroCrossings = i_zeroCrossings, initialEquations = i_initialEquations, timeEvents = i_timeEvents, whenClauses = i_whenClauses)),
           a_useFlatArrayNotation )
      equation
        l_className = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#include <Core/Modelica.h>\n",
                                    "#include <Core/ModelicaDefine.h>\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Functions.h\"\n",
                                    "#if defined(__TRICORE__) || defined(__vxworks)\n",
                                    "#include <DataExchange/SimDouble.h>\n",
                                    "#endif\n",
                                    "\n",
                                    "/* Constructor */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = Tpl.writeText(txt, l_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactory,boost::shared_ptr<ISimData> simData)\n",
                                    "    :SystemDefaultImplementation(globalSettings)\n",
                                    "    ,_algLoopSolverFactory(nonlinsolverfactory)\n",
                                    "    ,_simData(simData)\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = simulationInitFile(txt, i_simCode, false);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "{\n",
                                    "    //Number of equations\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = dimension1(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimZeroFunc= "));
        txt = zerocrosslength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_dimTimeEvent = "
                                }, false));
        txt = timeeventlength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "//Number of residues\n"
                                }, true));
        ret_1 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_191(txt, ret_1, i_allEquations);
        txt = Tpl.softNewLine(txt);
        ret_2 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        ret_3 = stringEq(ret_2, "none");
        ret_4 = boolNot(ret_3);
        txt = fun_192(txt, ret_4, i_modelInfo_name, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//DAE\'s are not supported yet, Index reduction is enabled\n",
                                    "_dimAE = 0; // algebraic equations\n",
                                    "//Initialize the state vector\n",
                                    "SystemDefaultImplementation::initialize();\n",
                                    "//Instantiate auxiliary object for event handling functionality\n",
                                    "//_event_handling.getCondition =  boost::bind(&"
                                }, false));
        txt = Tpl.writeText(txt, l_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getCondition, this, _1);\n",
                                    "\n",
                                    "//Todo: reindex all arrays removed  // arrayReindex(modelInfo,useFlatArrayNotation)\n",
                                    "\n",
                                    "_functions = new Functions(_simTime,__z,__zDot,_initial,_terminate);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "/* Destructor */\n"
                                }, true));
        txt = Tpl.writeText(txt, l_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = Tpl.writeText(txt, l_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    "{\n",
                                    "    if(_functions != NULL)\n",
                                    "        delete _functions;\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Update(txt, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = DefaultImplementationCode(txt, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = checkForDiscreteEvents(txt, i_discreteModelVars, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = giveZeroFunc1(txt, i_zeroCrossings, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = setConditions(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = geConditions(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = isConsistent(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_5 = listAppend(i_allEquations, i_initialEquations);
        txt = generateStepCompleted(txt, ret_5, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_6 = listAppend(i_allEquations, i_initialEquations);
        txt = generateStepStarted(txt, ret_6, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = generatehandleTimeEvent(txt, i_timeEvents, i_simCode);
        txt = Tpl.softNewLine(txt);
        ret_7 = listAppend(i_allEquations, i_initialEquations);
        txt = generateDimTimeEvent(txt, ret_7, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = generateTimeEvent(txt, i_timeEvents, i_simCode, true);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = isODE(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = DimZeroFunc(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = getCondition(txt, i_zeroCrossings, i_whenClauses, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = handleSystemEvents(txt, i_zeroCrossings, i_whenClauses, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = saveall(txt, i_modelInfo, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = initPrevars(txt, i_modelInfo, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = savediscreteVars(txt, i_modelInfo, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = LabeledDAE(txt, i_modelInfo_labels, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = giveVariables(txt, i_modelInfo, a_useFlatArrayNotation, i_simCode);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end simulationCppFile;

protected function fun_194
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_filename;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_filename)
    local
      Tpl.Text txt;
      Tpl.Text a_filename;

    case ( txt,
           SimCode.ALGLOOP_CONTEXT(genInitialisation = false, genJacobian = true),
           a_filename )
      equation
        txt = Tpl.writeText(txt, a_filename);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Jacobian"));
      then txt;

    case ( txt,
           _,
           a_filename )
      equation
        txt = Tpl.writeText(txt, a_filename);
      then txt;
  end match;
end fun_194;

protected function fun_195
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;

    case ( txt,
           SimCode.ALGLOOP_CONTEXT(genInitialisation = false, genJacobian = true),
           a_modelname )
      equation
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Jacobian"));
      then txt;

    case ( txt,
           _,
           a_modelname )
      equation
        txt = Tpl.writeText(txt, a_modelname);
      then txt;
  end match;
end fun_195;

protected function fun_196
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"Math/ArrayOperations.h\""));
      then txt;
  end match;
end fun_196;

protected function fun_197
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",__A(0)\n",
                                    " ,__Asparse(0)"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_197;

protected function fun_198
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(__Asparse != 0)\n",
                                    "    delete __Asparse;\n",
                                    "\n",
                                    " if(__A != 0)\n",
                                    "    delete __A;"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_198;

protected function fun_199
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode a_simCode;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq,
           a_simCode )
      equation
        txt = algloopResiduals(txt, a_simCode, a_eq);
      then txt;
  end match;
end fun_199;

protected function fun_200
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"Math/ArrayOperations.h\""));
      then txt;
  end match;
end fun_200;

protected function fun_201
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",__A(0)\n",
                                    " ,__Asparse(0)"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_201;

protected function fun_202
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(__Asparse != 0)\n",
                                    "    delete __Asparse;\n",
                                    "\n",
                                    " if(__A != 0)\n",
                                    "    delete __A;"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_202;

protected function fun_203
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode a_simCode;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eq,
           a_simCode )
      equation
        txt = algloopResiduals(txt, a_simCode, a_eq);
      then txt;
  end match;
end fun_203;

protected function fun_204
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_systemname;
  input Tpl.Text in_a_modelname;
  input Tpl.Text in_a_modelfilename;
  input Tpl.Text in_a_filename;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_context, in_a_simCode, in_a_varDecls, in_a_useFlatArrayNotation, in_a_systemname, in_a_modelname, in_a_modelfilename, in_a_filename, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_systemname;
      Tpl.Text a_modelname;
      Tpl.Text a_modelfilename;
      Tpl.Text a_filename;
      String a_fileNamePrefix;
      SimCode.SimEqSystem i_eq;
      Integer i_index;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_context,
           a_simCode,
           a_varDecls,
           a_useFlatArrayNotation,
           a_systemname,
           a_modelname,
           a_modelfilename,
           a_filename,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " /* #include <Core/Modelica.h>\n",
                                    " #include <Core/ModelicaDefine.h>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"OMCpp"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeText(txt, a_filename);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeText(txt, a_modelfilename);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\" */\n"));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_196(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_systemname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("* system, double* z,double* zDot,bool* conditions, EventHandling& event_handling )\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":AlgLoopDefaultImplementation()\n",
                                    ",_system(system)\n",
                                    ",__z(z)\n",
                                    ",__zDot(zDot)\n"
                                }, true));
        txt = fun_197(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//"
                                }, false));
        txt = alocateLinearSystemConstructor(txt, i_eq, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",_conditions(conditions)\n",
                                    ",_event_handling(event_handling)\n",
                                    ",_useSparseFormat(false)\n",
                                    ",_functions(system->_functions)\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        (txt, a_varDecls) = initAlgloopDimension(txt, i_eq, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    " {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fun_198(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getUseSparseFormat()\n",
                                    "{\n",
                                    "   return _useSparseFormat;\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setUseSparseFormat(bool value)\n",
                                    "{\n",
                                    "   _useSparseFormat = value;\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = algloopRHSCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        ret_1 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_199(txt, ret_1, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initAlgloop(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = initAlgloopTemplate(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = queryDensity(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = updateAlgloop(txt, a_simCode, i_eq, a_context);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopNonLinear(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopLinear(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = AlgloopDefaultImplementationCode(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = getAMatrixCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = isLinearCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = isLinearTearingCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_context,
           a_simCode,
           a_varDecls,
           a_useFlatArrayNotation,
           a_systemname,
           a_modelname,
           a_modelfilename,
           a_filename,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " /* #include <Core/Modelica.h>\n",
                                    " #include <Core/ModelicaDefine.h>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"OMCpp"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Extension.h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeText(txt, a_filename);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".h\"\n",
                                    "#include \"OMCpp"
                                }, false));
        txt = Tpl.writeText(txt, a_modelfilename);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".h\" */\n"));
        ret_2 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_200(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_systemname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("* system, double* z,double* zDot,bool* conditions, EventHandling& event_handling )\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ":AlgLoopDefaultImplementation()\n",
                                    ",_system(system)\n",
                                    ",__z(z)\n",
                                    ",__zDot(zDot)\n"
                                }, true));
        txt = fun_201(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//"
                                }, false));
        txt = alocateLinearSystemConstructor(txt, i_eq, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",_conditions(conditions)\n",
                                    ",_event_handling(event_handling)\n",
                                    ",_useSparseFormat(false)\n",
                                    ",_functions(system->_functions)\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        (txt, a_varDecls) = initAlgloopDimension(txt, i_eq, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::~"));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "()\n",
                                    " {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fun_202(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getUseSparseFormat()\n",
                                    "{\n",
                                    "   return _useSparseFormat;\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setUseSparseFormat(bool value)\n",
                                    "{\n",
                                    "   _useSparseFormat = value;\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = algloopRHSCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        ret_3 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_203(txt, ret_3, i_eq, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = initAlgloop(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = initAlgloopTemplate(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = queryDensity(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = updateAlgloop(txt, a_simCode, i_eq, a_context);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopNonLinear(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = upateAlgloopLinear(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = AlgloopDefaultImplementationCode(txt, a_simCode, i_eq, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = getAMatrixCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = isLinearCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = isLinearTearingCode(txt, a_simCode, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           _,
           _,
           _,
           _,
           _,
           _ )
      then (txt, a_varDecls);
  end match;
end fun_204;

public function algloopCppFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      String i_fileNamePrefix;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_systemname;
      Tpl.Text l_iniAlgloopParamas;
      Tpl.Text l_constructorParams;
      Tpl.Text l_arrayInit;
      Tpl.Text l_varDecls;
      Tpl.Text l_modelfilename;
      Tpl.Text l_filename;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), fileNamePrefix = i_fileNamePrefix)),
           a_eq,
           a_context,
           a_useFlatArrayNotation )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_filename = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        l_modelfilename = fun_194(Tpl.emptyTxt, a_context, l_filename);
        l_varDecls = Tpl.emptyTxt;
        l_arrayInit = Tpl.emptyTxt;
        l_constructorParams = ConstructorParamAlgloop(Tpl.emptyTxt, i_modelInfo, a_useFlatArrayNotation);
        (l_iniAlgloopParamas, l_arrayInit) = InitAlgloopParams(Tpl.emptyTxt, i_modelInfo, l_arrayInit, a_useFlatArrayNotation);
        l_systemname = fun_195(Tpl.emptyTxt, a_context, l_modelname);
        (txt, l_varDecls) = fun_204(txt, a_eq, a_context, i_simCode, l_varDecls, a_useFlatArrayNotation, l_systemname, l_modelname, l_modelfilename, l_filename, i_fileNamePrefix);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end algloopCppFile;

protected function fun_206
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      Integer i_index;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("float "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::queryDensity()\n",
                                    "{\n",
                                    "  return -1.;\n",
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(simJac = i_simJac, index = i_index),
           a_modelname )
      equation
        ret_1 = listLength(i_simJac);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("float "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::queryDensity()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return 100.*"));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("./_dimAEq/_dimAEq;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_206;

protected function fun_207
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eqn)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eqn;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_eqn )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_206(txt, a_eqn, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_207;

public function queryDensity
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input SimCode.SimEqSystem a_eqn;
  input SimCode.Context a_context;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_207(txt, a_simCode, a_eqn);
end queryDensity;

protected function fun_209
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluate()\n",
                                    "{\n",
                                    "   if(_useSparseFormat)\n",
                                    "   {\n",
                                    "     if(__Asparse == 0)\n",
                                    "     {\n",
                                    "       //sometimes initialize was not called before\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = alocateLinearSystem(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "     }\n",
                                    "     evaluate(__Asparse);\n",
                                    "   }\n",
                                    "   else\n",
                                    "   {\n",
                                    "     if(__A == 0)\n",
                                    "     {\n",
                                    "       //sometimes initialize was not called before\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = alocateLinearSystem(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "     }\n",
                                    "     evaluate(__A);\n",
                                    "   }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_209;

protected function fun_210
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eqn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eqn)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eqn;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_eqn )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_209(txt, a_eqn, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_210;

public function updateAlgloop
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input SimCode.SimEqSystem a_eqn;
  input SimCode.Context a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_210(txt, a_simCode, a_eqn);
end updateAlgloop;

protected function lm_212
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_context, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq2;

    case ( txt,
           {},
           _,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq2 :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_context,
           a_varDecls )
      equation
        (txt, a_varDecls) = functionExtraResidualsPreBody(txt, i_eq2, a_varDecls, a_context, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_212(txt, rest, a_useFlatArrayNotation, a_simCode, a_context, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_212;

protected function lm_213
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_eq2_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_eq2_exp) :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq2_exp, a_context, l_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__xd["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_213(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_213(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_213;

protected function fun_214
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" template <typename T>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::evaluate(T *__A)"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::evaluate()"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_214;

protected function fun_215
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input Tpl.Text in_a_modelname;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelname, in_a_useFlatArrayNotation, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eq;
      list<SimCode.SimEqSystem> i_eq_eqs;
      Tpl.Text l_body;
      Tpl.Text l_prebody;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(eqs = i_eq_eqs)),
           a_modelname,
           a_useFlatArrayNotation,
           a_simCode,
           a_context )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_prebody = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_prebody, l_varDecls) = lm_212(l_prebody, i_eq_eqs, a_useFlatArrayNotation, a_simCode, a_context, l_varDecls);
        l_prebody = Tpl.popIter(l_prebody);
        l_body = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_body, l_varDecls) = lm_213(l_body, i_eq_eqs, a_useFlatArrayNotation, a_simCode, l_varDecls, a_context);
        l_body = Tpl.popIter(l_body);
        txt = fun_214(txt, i_eq, a_modelname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "\n",
                                    "//prebody\n"
                                }, true));
        txt = Tpl.writeText(txt, l_prebody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//body\n"));
        txt = Tpl.writeText(txt, l_body);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_215;

public function upateAlgloopNonLinear
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eqn;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eqn, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eqn;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eqn,
           a_context,
           a_useFlatArrayNotation )
      equation
        System.tmpTickReset(0);
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_215(txt, a_eqn, l_modelname, a_useFlatArrayNotation, i_simCode, a_context);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end upateAlgloopNonLinear;

public function functionExtraResidualsPreBody
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_eq, in_a_varDecls, in_a_context, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           a_varDecls,
           _,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_eq,
           a_varDecls,
           a_context,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        (txt, a_varDecls) = equation_(txt, i_eq, a_context, a_varDecls, a_simCode, a_useFlatArrayNotation);
      then (txt, a_varDecls);
  end match;
end functionExtraResidualsPreBody;

protected function lm_218
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq_exp, a_context, l_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*__A)("));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1,"));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1)="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_218(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_218(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_218;

protected function lm_219
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_exp :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__b("));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_219(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_219;

protected function fun_220
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input Tpl.Text in_a_modelname;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_modelname, in_a_useFlatArrayNotation, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Integer i_index;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<SimCodeVar.SimVar> i_vars;
      Tpl.Text l_bvector;
      Tpl.Text l_Amatrix;
      Tpl.Text l_varDecls;
      Tpl.Text l_bname;
      Tpl.Text l_aname;
      Integer ret_3;
      Tpl.Text l_size;
      Integer ret_1;
      Tpl.Text l_uid;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, simJac = i_simJac, beqs = i_beqs, index = i_index),
           a_modelname,
           a_useFlatArrayNotation,
           a_simCode,
           a_context )
      equation
        ret_1 = System.tmpTick();
        l_uid = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        ret_3 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        l_aname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("A"));
        l_aname = Tpl.writeText(l_aname, l_uid);
        l_bname = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("b"));
        l_bname = Tpl.writeText(l_bname, l_uid);
        l_varDecls = Tpl.emptyTxt;
        l_Amatrix = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_Amatrix, l_varDecls) = lm_218(l_Amatrix, i_simJac, a_useFlatArrayNotation, a_simCode, l_varDecls, a_context);
        l_Amatrix = Tpl.popIter(l_Amatrix);
        l_bvector = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bvector, l_varDecls) = lm_219(l_bvector, i_beqs, a_useFlatArrayNotation, a_simCode, l_varDecls, a_context);
        l_bvector = Tpl.popIter(l_bvector);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "template <typename T>\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::evaluate(T* __A)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_Amatrix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bvector);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_220;

public function upateAlgloopLinear
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eqn;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eqn, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eqn;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eqn,
           a_context,
           a_useFlatArrayNotation )
      equation
        System.tmpTickReset(0);
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_220(txt, a_eqn, l_modelname, a_useFlatArrayNotation, i_simCode, a_context);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end upateAlgloopLinear;

protected function lm_222
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionBody(txt, i_fn, false, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_222(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_222;

public function functionBodies
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_222(out_txt, a_functions, a_useFlatArrayNotation, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionBodies;

protected function fun_224
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_useFlatArrayNotation, in_a_simCode, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_useFlatArrayNotation,
           a_simCode,
           _ )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_224;

protected function fun_225
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_inFunc, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_inFunc,
           a_fn )
      equation
        txt = fun_224(txt, a_fn, a_useFlatArrayNotation, a_simCode, a_inFunc);
      then txt;
  end match;
end fun_225;

protected function fun_226
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_useFlatArrayNotation, in_a_simCode, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_useFlatArrayNotation,
           a_simCode,
           _ )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_226;

protected function fun_227
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_inFunc, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_inFunc,
           a_fn )
      equation
        txt = fun_226(txt, a_fn, a_useFlatArrayNotation, a_simCode, a_inFunc);
      then txt;
  end match;
end fun_227;

protected function fun_228
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_useFlatArrayNotation, in_a_simCode, in_a_inFunc)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyRegularFunction(txt, i_fn, a_inFunc, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode,
           a_inFunc )
      equation
        txt = functionBodyExternalFunction(txt, i_fn, a_inFunc, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_useFlatArrayNotation,
           a_simCode,
           _ )
      equation
        txt = functionBodyRecordConstructor(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_228;

protected function fun_229
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_inFunc;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_inFunc, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Boolean a_inFunc;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_inFunc,
           a_fn )
      equation
        txt = fun_228(txt, a_fn, a_useFlatArrayNotation, a_simCode, a_inFunc);
      then txt;
  end match;
end fun_229;

public function functionBody
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name)),
           a_inFunc,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_1 = Tpl.textString(l_fname);
        txt = fun_225(txt, str_1, a_useFlatArrayNotation, a_simCode, a_inFunc, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name)),
           a_inFunc,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_2 = Tpl.textString(l_fname);
        txt = fun_227(txt, str_2, a_useFlatArrayNotation, a_simCode, a_inFunc, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name)),
           a_inFunc,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_3 = Tpl.textString(l_fname);
        txt = fun_229(txt, str_3, a_useFlatArrayNotation, a_simCode, a_inFunc, i_fn);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end functionBody;

protected function lm_231
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = extFunDef(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_231(txt, rest);
      then txt;
  end match;
end lm_231;

public function externfunctionHeaderDefinition
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_231(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end externfunctionHeaderDefinition;

protected function lm_233
  input Tpl.Text in_txt;
  input list<SimCode.RecordDeclaration> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.RecordDeclaration> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.RecordDeclaration i_rd;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_rd :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = recordDeclarationHeader(txt, i_rd, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_233(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_233;

protected function lm_234
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderBody1(txt, i_fn, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_234(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_234;

protected function fun_235
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Function> in_a_functions;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_functions, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.Function> a_functions;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      list<SimCode.RecordDeclaration> i_recordDecls;
      Tpl.Text l_rettypedecls;
      Tpl.Text l_recorddecls;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), recordDecls = i_recordDecls)),
           a_functions,
           a_useFlatArrayNotation )
      equation
        l_recorddecls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_recorddecls = lm_233(l_recorddecls, i_recordDecls, a_useFlatArrayNotation, i_simCode);
        l_recorddecls = Tpl.popIter(l_recorddecls);
        l_rettypedecls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_rettypedecls = lm_234(l_rettypedecls, a_functions, a_useFlatArrayNotation, i_simCode);
        l_rettypedecls = Tpl.popIter(l_rettypedecls);
        txt = Tpl.writeText(txt, l_recorddecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_rettypedecls);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_235;

public function functionHeaderBodies1
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_235(txt, a_simCode, a_functions, a_useFlatArrayNotation);
end functionHeaderBodies1;

protected function fun_237
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           _,
           a_simCode )
      equation
        txt = functionHeaderExternFunction(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_237;

protected function fun_238
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_fn )
      equation
        txt = fun_237(txt, a_fn, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end fun_238;

protected function fun_239
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           _,
           a_simCode )
      equation
        txt = functionHeaderExternFunction(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_239;

protected function fun_240
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_fn )
      equation
        txt = fun_239(txt, a_fn, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end fun_240;

protected function fun_241
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           _,
           a_simCode )
      equation
        txt = functionHeaderExternFunction(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction1(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_241;

protected function fun_242
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_fn )
      equation
        txt = fun_241(txt, a_fn, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end fun_242;

public function functionHeaderBody1
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name)),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_1 = Tpl.textString(l_fname);
        txt = fun_238(txt, str_1, a_useFlatArrayNotation, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name)),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_2 = Tpl.textString(l_fname);
        txt = fun_240(txt, str_2, a_useFlatArrayNotation, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name)),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_3 = Tpl.textString(l_fname);
        txt = fun_242(txt, str_3, a_useFlatArrayNotation, a_simCode, i_fn);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionHeaderBody1;

protected function lm_244
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderBody2(txt, i_fn, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_244(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_244;

public function functionHeaderBodies2
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_244(out_txt, a_functions, a_useFlatArrayNotation, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionHeaderBodies2;

protected function fun_246
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRecordConstruct(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_246;

protected function fun_247
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_fn )
      equation
        txt = fun_246(txt, a_fn, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end fun_247;

protected function fun_248
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRecordConstruct(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_248;

protected function fun_249
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_fn )
      equation
        txt = fun_248(txt, a_fn, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end fun_249;

protected function fun_250
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRegularFunction2(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = _)),
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = functionHeaderRecordConstruct(txt, i_fn, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_250;

protected function fun_251
  input Tpl.Text in_txt;
  input String in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_fn )
      equation
        txt = fun_250(txt, a_fn, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end fun_251;

public function functionHeaderBody2
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name)),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_1 = Tpl.textString(l_fname);
        txt = fun_247(txt, str_1, a_useFlatArrayNotation, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name)),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_2 = Tpl.textString(l_fname);
        txt = fun_249(txt, str_2, a_useFlatArrayNotation, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name)),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_3 = Tpl.textString(l_fname);
        txt = fun_251(txt, str_3, a_useFlatArrayNotation, a_simCode, i_fn);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionHeaderBody2;

protected function lm_253
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_fn :: rest,
           a_simCode )
      equation
        txt = functionHeaderBody3(txt, i_fn, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_253(txt, rest, a_simCode);
      then txt;
  end match;
end lm_253;

public function functionHeaderBodies3
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_253(out_txt, a_functions, a_simCode);
  out_txt := Tpl.popIter(out_txt);
end functionHeaderBodies3;

protected function fun_255
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_255;

protected function fun_256
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_255(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_256;

protected function fun_257
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_257;

protected function fun_258
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_257(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_258;

protected function fun_259
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = _)),
           a_simCode )
      equation
        txt = functionHeaderRegularFunction3(txt, i_fn, a_simCode);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = _),
           _ )
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_259;

protected function fun_260
  input Tpl.Text in_txt;
  input String in_mArg;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_Scripting_regexBool",
           _,
           _ )
      then txt;

    case ( txt,
           "Modelica_Utilities_Files_loadResource",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_directoryExists",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_uriToFilename",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_Internal_stat",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_realpath",
           _,
           _ )
      then txt;

    case ( txt,
           "OpenModelica_Scripting_regex",
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_simCode,
           a_fn )
      equation
        txt = fun_259(txt, a_fn, a_simCode);
      then txt;
  end match;
end fun_260;

public function functionHeaderBody3
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Function i_fn;
      Absyn.Path i_name;
      String str_3;
      String str_2;
      String str_1;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name)),
           a_simCode )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_1 = Tpl.textString(l_fname);
        txt = fun_256(txt, str_1, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.EXTERNAL_FUNCTION(name = i_name)),
           a_simCode )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_2 = Tpl.textString(l_fname);
        txt = fun_258(txt, str_2, a_simCode, i_fn);
      then txt;

    case ( txt,
           (i_fn as SimCode.RECORD_CONSTRUCTOR(name = i_name)),
           a_simCode )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        str_3 = Tpl.textString(l_fname);
        txt = fun_260(txt, str_3, a_simCode, i_fn);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionHeaderBody3;

protected function lm_262
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_i;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_i :: rest )
      equation
        txt = Tpl.writeStr(txt, i_i);
        txt = Tpl.nextIter(txt);
        txt = lm_262(txt, rest);
      then txt;
  end match;
end lm_262;

protected function fun_263
  input Tpl.Text in_txt;
  input list<String> in_a_includes;
  input Tpl.Text in_a_fargsStrEscaped;
  input Tpl.Text in_a_fn__name;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_fargsStr;
  input String in_a_extName;
  input SimCode.SimExtArg in_a_return;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_includes, in_a_fargsStrEscaped, in_a_fn__name, in_a_extReturn, in_a_fargsStr, in_a_extName, in_a_return)
    local
      Tpl.Text txt;
      Tpl.Text a_fargsStrEscaped;
      Tpl.Text a_fn__name;
      SimCode.SimExtArg a_extReturn;
      Tpl.Text a_fargsStr;
      String a_extName;
      SimCode.SimExtArg a_return;

    case ( txt,
           {},
           _,
           _,
           _,
           a_fargsStr,
           a_extName,
           a_return )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern "));
        txt = extReturnType(txt, a_return);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");/*extern c*/"));
      then txt;

    case ( txt,
           _,
           a_fargsStrEscaped,
           a_fn__name,
           a_extReturn,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*\n",
                                    " * The function has annotation(Include=...>)\n",
                                    " * the external function definition should be present\n",
                                    " * in one of these files and have this prototype:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("* extern "));
        txt = extReturnType(txt, a_extReturn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_fn__name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, a_fargsStrEscaped);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "*/"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_263;

protected function fun_264
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimExtArg in_a_return;
  input Tpl.Text in_a_fargsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_return, in_a_fargsStr)
    local
      Tpl.Text txt;
      SimCode.SimExtArg a_return;
      Tpl.Text a_fargsStr;
      SimCode.SimExtArg i_extReturn;
      String i_language;
      String i_extName;
      list<String> i_includes;
      Tpl.Text l_fn__name;
      Tpl.Text l_includesStr;
      Tpl.Text l_fargsStrEscaped;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(includes = i_includes, extName = i_extName, language = i_language, extReturn = i_extReturn),
           a_return,
           a_fargsStr )
      equation
        l_fargsStrEscaped = CodegenUtil.escapeCComments(Tpl.emptyTxt, Tpl.textString(a_fargsStr));
        l_includesStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_includesStr = lm_262(l_includesStr, i_includes);
        l_includesStr = Tpl.popIter(l_includesStr);
        l_fn__name = extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        txt = fun_263(txt, i_includes, l_fargsStrEscaped, l_fn__name, i_extReturn, a_fargsStr, i_extName, a_return);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_264;

protected function fun_265
  input Tpl.Text in_txt;
  input String in_a_extName;
  input SimCode.SimExtArg in_a_return;
  input Tpl.Text in_a_fargsStr;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extName, in_a_return, in_a_fargsStr, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg a_return;
      Tpl.Text a_fargsStr;
      SimCode.Function a_fn;

    case ( txt,
           "OpenModelica_regex",
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_return,
           a_fargsStr,
           a_fn )
      equation
        txt = fun_264(txt, a_fn, a_return, a_fargsStr);
      then txt;
  end match;
end fun_265;

public function extFunDef
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      SimCode.SimExtArg i_return;
      SimCode.Function i_func;
      String i_extName;
      String i_language;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_fargsStr;

    case ( txt,
           (i_func as SimCode.EXTERNAL_FUNCTION(extReturn = i_return, extArgs = i_extArgs, language = i_language, extName = i_extName)) )
      equation
        l_fargsStr = extFunDefArgs(Tpl.emptyTxt, i_extArgs, i_language);
        txt = fun_265(txt, i_extName, i_return, l_fargsStr, i_func);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDef;

protected function fun_267
  input Tpl.Text in_txt;
  input String in_a_language;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_language, in_a_name)
    local
      Tpl.Text txt;
      String a_name;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_name )
      equation
        txt = Tpl.writeStr(txt, a_name);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 2377, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_267;

public function extFunctionName
  input Tpl.Text txt;
  input String a_name;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_267(txt, a_language, a_name);
end extFunctionName;

protected function lm_269
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = extFunDefArg(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_269(txt, rest);
      then txt;
  end match;
end lm_269;

protected function fun_270
  input Tpl.Text in_txt;
  input String in_a_language;
  input list<SimCode.SimExtArg> in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_language, in_a_args)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> a_args;
      String i_language;
      Tpl.Text txt_0;

    case ( txt,
           "C",
           a_args )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_269(txt, a_args);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           i_language,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unsupport external language: "));
        txt_0 = Tpl.writeStr(txt_0, i_language);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 2384, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_270;

public function extFunDefArgs
  input Tpl.Text txt;
  input list<SimCode.SimExtArg> a_args;
  input String a_language;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_270(txt, a_language, a_args);
end extFunDefArgs;

public function extFunDefArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Type i_type__;
      Boolean i_ia;
      Boolean i_ii;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = i_ii, isArray = i_ia, type_ = i_t) )
      equation
        l_name = contextCref2(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_typeStr = extType2(Tpl.emptyTxt, i_t, i_ii, i_ia);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*"));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__) )
      equation
        l_typeStr = extType2(Tpl.emptyTxt, i_type__, true, false);
        txt = Tpl.writeText(txt, l_typeStr);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end extFunDefArg;

protected function fun_273
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isInput;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isInput)
    local
      Tpl.Text txt;
      Boolean a_isInput;
      DAE.Type i_type;
      Absyn.Path i_rname;
      DAE.Type i_ty;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const char*"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_isInput )
      equation
        txt = extType2(txt, i_ty, a_isInput, true);
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = _)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void *"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = i_rname)),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = CodegenUtil.underscorePath(txt, i_rname);
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_metatype"));
      then txt;

    case ( txt,
           i_type,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Unknown external C type "));
        ret_0 = Types.unparseType(i_type);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 2426, 14), Tpl.textString(txt_0));
      then txt;
  end match;
end fun_273;

protected function fun_274
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "const char*" )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*const*/ "));
      then txt;
  end match;
end fun_274;

protected function fun_275
  input Tpl.Text in_txt;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Tpl.Text a_s;
      String str_0;

    case ( txt,
           false,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_s )
      equation
        str_0 = Tpl.textString(a_s);
        txt = fun_274(txt, str_0);
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;
  end match;
end fun_275;

protected function fun_276
  input Tpl.Text in_txt;
  input Boolean in_a_isInput;
  input Boolean in_a_isArray;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isInput, in_a_isArray, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Tpl.Text a_s;

    case ( txt,
           false,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_s )
      equation
        txt = fun_275(txt, a_isArray, a_s);
      then txt;
  end match;
end fun_276;

protected function fun_277
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Boolean in_a_isArray;
  input Boolean in_a_isInput;
  input Tpl.Text in_a_s;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_isArray, in_a_isInput, in_a_s)
    local
      Tpl.Text txt;
      Boolean a_isArray;
      Boolean a_isInput;
      Tpl.Text a_s;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           _,
           _,
           a_s )
      equation
        txt = Tpl.writeText(txt, a_s);
      then txt;

    case ( txt,
           _,
           a_isArray,
           a_isInput,
           a_s )
      equation
        txt = fun_276(txt, a_isInput, a_isArray, a_s);
      then txt;
  end match;
end fun_277;

public function extType2
  input Tpl.Text txt;
  input DAE.Type a_type;
  input Boolean a_isInput;
  input Boolean a_isArray;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_s;
algorithm
  l_s := fun_273(Tpl.emptyTxt, a_type, a_isInput);
  out_txt := fun_277(txt, a_type, a_isArray, a_isInput, l_s);
end extType2;

public function extReturnType
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      DAE.Type i_type__;
      Tpl.Text txt_0;
      String ret_0;

    case ( txt,
           SimCode.SIMEXTARG(type_ = i_type__) )
      equation
        txt = extType2(txt, i_type__, true, false);
      then txt;

    case ( txt,
           SimCode.SIMNOEXTARG() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp) )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("Expression types are unsupported as return arguments "));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt_0 = Tpl.writeStr(txt_0, ret_0);
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 2436, 36), Tpl.textString(txt_0));
      then txt;

    case ( txt,
           _ )
      equation
        txt = error(txt, Tpl.sourceInfo("CodegenCpp.tpl", 2437, 14), "Unsupported return argument");
      then txt;
  end match;
end extReturnType;

protected function lm_280
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_280(txt, rest, a_simCode);
      then txt;
  end match;
end lm_280;

protected function lm_281
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i0;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = tupplearrayassign(txt, i_var, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_281(txt, rest);
      then txt;
  end match;
end lm_281;

public function functionHeaderRegularFunction1
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      list<SimCode.Variable> i_vars;
      SimCode.Variable i_var;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(outVars = {i_var}, name = i_name),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /*default return type*/\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef "));
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "RetType /* functionHeaderRegularFunction1 */;\n",
                                    "typedef "
                                }, false));
        txt = funReturnDefinition2(txt, i_var, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RefRetType /* functionHeaderRegularFunction1 */;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.FUNCTION(outVars = (i_vars as _ :: _), name = i_name),
           a_simCode,
           _ )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /*tuple return type*/\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Type/*RecordTypeTest*/\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef boost::tuple< "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_280(txt, i_vars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " > TUPLE_ARRAY;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type& operator=(const "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Type& A)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     " "
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_281(txt, i_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return *this;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "TUPLE_ARRAY data;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type/*RecordTypeTest*/ "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType /* functionHeaderRegularFunction1 */;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name),
           _,
           _ )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType /* functionHeaderRegularFunction1 */;"));
      then txt;

    case ( txt,
           SimCode.PARALLEL_FUNCTION(name = i_name),
           _,
           _ )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//PARALLEL_FUNCTION\n",
                                    "//typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType out of functionHeaderRegularFunction1;"));
      then txt;

    case ( txt,
           SimCode.KERNEL_FUNCTION(name = i_name),
           _,
           _ )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//KERNEL_FUNCTION\n",
                                    "//typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType out of functionHeaderRegularFunction1;"));
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name),
           _,
           _ )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//EXTERNAL_FUNCTION\n",
                                    "//typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType out of functionHeaderRegularFunction1;"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionHeaderRegularFunction1;

protected function fun_283
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;

    case ( txt,
           {},
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("boost::get<"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">(data)= boost::get<"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">(A.data);"));
      then txt;

    case ( txt,
           _,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(boost::get<"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">(data)).assign(boost::get<"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">(A.data));"));
      then txt;
  end match;
end fun_283;

public function tupplearrayassign
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims),
           a_index )
      equation
        txt = fun_283(txt, i_instDims, a_index);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end tupplearrayassign;

protected function lm_285
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) :: rest,
           a_simCode )
      equation
        txt = varType1(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_285(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_285(txt, rest, a_simCode);
      then txt;
  end match;
end lm_285;

protected function fun_286
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_funArgs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funArgs)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_286;

protected function fun_287
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_funArgs;
      Absyn.Path i_name;
      Tpl.Text l_funArgsStr;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs),
           a_simCode )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        l_funArgsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_funArgsStr = lm_285(l_funArgsStr, i_funArgs, a_simCode);
        l_funArgsStr = Tpl.popIter(l_funArgsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void /*RecordTypetest*/ "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_funArgsStr);
        txt = fun_286(txt, i_funArgs);
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type &output );"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_287;

public function functionHeaderRecordConstruct
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_287(txt, a_fn, a_simCode);
end functionHeaderRecordConstruct;

protected function lm_289
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_simCode )
      equation
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_289(txt, rest, a_simCode);
      then txt;
  end match;
end lm_289;

protected function lm_290
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i0;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = tupplearrayassign(txt, i_var, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_290(txt, rest);
      then txt;
  end match;
end lm_290;

public function functionHeaderExternFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_outVars;
      SimCode.Variable i_var;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(outVars = {i_var}, name = i_name),
           a_simCode )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef  "));
        txt = funReturnDefinition1(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType /* functionHeaderExternFunction */;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(outVars = (i_outVars as _ :: _), name = i_name),
           a_simCode )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /*tuple return type*/\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Type\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef boost::tuple< "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_289(txt, i_outVars, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " > TUPLE_ARRAY;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type& operator=(const "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Type& A)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                     "\n",
                                                                     " "
                                                                 }, false)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_290(txt, i_outVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return *this;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "TUPLE_ARRAY data;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type/*RecordTypeTest*/ "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType /* functionHeaderExternFunction */;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.FUNCTION(outVars = _ :: _, name = i_name),
           _ )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//FUNCTION\n",
                                    "//typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType out of functionHeaderExternFunction;"));
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name),
           _ )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//RECORD_CONSTRUCTOR\n",
                                    "//typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType out of functionHeaderExternFunction;"));
      then txt;

    case ( txt,
           SimCode.PARALLEL_FUNCTION(name = i_name),
           _ )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//PARALLEL_FUNCTION\n",
                                    "//typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType out of functionHeaderExternFunction;"));
      then txt;

    case ( txt,
           SimCode.KERNEL_FUNCTION(name = i_name),
           _ )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//KERNEL_FUNCTION\n",
                                    "//typedef "
                                }, false));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Type "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType out of functionHeaderExternFunction;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end functionHeaderExternFunction;

protected function lm_292
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = recordDeclarationHeaderArrayAllocate(txt, i_var, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_292(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = lm_292(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_292;

protected function lm_293
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_var_name;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name)) :: rest,
           a_simCode )
      equation
        txt = varType3(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_293(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_293(txt, rest, a_simCode);
      then txt;
  end match;
end lm_293;

public function recordDeclarationHeader
  input Tpl.Text in_txt;
  input SimCode.RecordDeclaration in_a_recDecl;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_recDecl, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      list<SimCode.Variable> i_variables;
      String i_name;

    case ( txt,
           SimCode.RECORD_DECL_FULL(name = i_name, variables = i_variables),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("struct "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Type\n",
                                    "{\n",
                                    "   //Constructor allocates arrays\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Type()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_292(txt, i_variables, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" */\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "//Public  Members\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_293(txt, i_variables, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;

    case ( txt,
           SimCode.RECORD_DECL_DEF(path = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RECORD DECL DEF"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end recordDeclarationHeader;

protected function lm_295
  input Tpl.Text in_txt;
  input DAE.Dimensions in_items;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_context)
    local
      Tpl.Text txt;
      DAE.Dimensions rest;
      SimCode.Context a_context;
      DAE.Dimension i_exp;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_exp :: rest,
           a_context )
      equation
        txt = dimension(txt, i_exp, a_context);
        txt = Tpl.nextIter(txt);
        txt = lm_295(txt, rest, a_context);
      then txt;
  end match;
end lm_295;

protected function fun_296
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_v;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      DAE.ComponentRef i_name;
      DAE.Dimensions i_ty_dims;
      Tpl.Text l_arrayname;
      Tpl.Text l_instDimsInit;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_ARRAY(dims = i_ty_dims), name = i_name),
           a_context )
      equation
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("][")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_instDimsInit = lm_295(l_instDimsInit, i_ty_dims, a_context);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        l_arrayname = crefStr(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_arrayname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".resize((boost::extents["));
        txt = Tpl.writeText(txt, l_instDimsInit);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]));\n"));
        txt = Tpl.writeText(txt, l_arrayname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".reindex(1);"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_296;

public function recordDeclarationHeaderArrayAllocate
  input Tpl.Text txt;
  input SimCode.Variable a_v;
  input SimCode.SimCode a_simCode;
  input SimCode.Context a_context;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_296(txt, a_v, a_context);
end recordDeclarationHeaderArrayAllocate;

protected function lm_298
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)) :: rest,
           a_simCode )
      equation
        txt = varType1(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = crefStr(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_298(txt, rest, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_simCode )
      equation
        txt = lm_298(txt, rest, a_simCode);
      then txt;
  end match;
end lm_298;

protected function fun_299
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_funArgs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funArgs)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_299;

protected function lm_300
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      DAE.ComponentRef i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(output."));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") = ("));
        txt = crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_300(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_300(txt, rest);
      then txt;
  end match;
end lm_300;

protected function fun_301
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> i_funArgs;
      Absyn.Path i_name;
      Tpl.Text l_structVar;
      Tpl.Text l_structType;
      Tpl.Text l_retVar;
      Tpl.Text l_retType;
      Tpl.Text l_fname;
      Tpl.Text l_varDecls;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, funArgs = i_funArgs),
           a_simCode )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        l_retType = Tpl.writeText(Tpl.emptyTxt, l_fname);
        l_retType = Tpl.writeTok(l_retType, Tpl.ST_STRING("Type"));
        (l_retVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_retType), l_varDecls);
        l_structType = Tpl.writeText(Tpl.emptyTxt, l_fname);
        l_structType = Tpl.writeTok(l_structType, Tpl.ST_STRING("Type"));
        (l_structVar, l_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(l_structType), l_varDecls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void /*"));
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/ Functions::"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_298(txt, i_funArgs, a_simCode);
        txt = Tpl.popIter(txt);
        txt = fun_299(txt, i_funArgs);
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "& output )\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_300(txt, i_funArgs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//output = "));
        txt = Tpl.writeText(txt, l_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//return "));
        txt = Tpl.writeText(txt, l_structVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_301;

public function functionBodyRecordConstructor
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_301(txt, a_fn, a_simCode);
end functionBodyRecordConstructor;

protected function fun_303
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Integer in_a_exp_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_exp_index)
    local
      Tpl.Text txt;
      Integer a_exp_index;

    case ( txt,
           SimCode.FUNCTION_CONTEXT(),
           a_exp_index )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_OMC_LIT"));
        txt = Tpl.writeStr(txt, intString(a_exp_index));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_exp_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions->_OMC_LIT"));
        txt = Tpl.writeStr(txt, intString(a_exp_index));
      then txt;
  end match;
end fun_303;

protected function fun_304
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Integer i_exp_index;

    case ( txt,
           DAE.SHARED_LITERAL(index = i_exp_index),
           a_context )
      equation
        txt = fun_303(txt, a_context, i_exp_index);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_304;

public function daeExpSharedLiteral
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_304(txt, a_exp, a_context);
  out_a_preExp := a_preExp;
  out_a_varDecls := a_varDecls;
end daeExpSharedLiteral;

protected function lm_306
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_306(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_306;

protected function lm_307
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_307(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_307;

protected function fun_308
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_functionArguments;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_functionArguments)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_308;

protected function lm_309
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_309(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_309;

protected function fun_310
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_funArgs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funArgs)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_310;

protected function lm_311
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_311(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_311;

public function functionHeaderRegularFunction2
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      list<SimCode.Variable> i_funArgs;
      list<SimCode.Variable> i_functionArguments;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(outVars = {}, name = i_name, functionArguments = i_functionArguments),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_306(txt, i_functionArguments, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.FUNCTION(outVars = _, name = i_name, functionArguments = i_functionArguments),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("      /* functionHeaderRegularFunction2 */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void /*"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType*/ "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_307(txt, i_functionArguments, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = fun_308(txt, i_functionArguments);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType& output);"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(outVars = _ :: _, name = i_name, funArgs = i_funArgs),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("     /* functionHeaderRegularFunction2 */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void /*"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType*/ "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_309(txt, i_funArgs, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = fun_310(txt, i_funArgs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType& output);"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(outVars = {}, name = i_name, funArgs = i_funArgs),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_311(txt, i_funArgs, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionHeaderRegularFunction2;

protected function fun_313
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(outVars = {}) )
      then txt;

    case ( txt,
           SimCode.FUNCTION(outVars = _, name = i_name) )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("      /* functionHeaderRegularFunction3 */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(outVars = _ :: _, name = i_name) )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("       /* functionHeaderRegularFunction3 */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType _"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_313;

public function functionHeaderRegularFunction3
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_313(txt, a_fn);
end functionHeaderRegularFunction3;

protected function fun_315
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType "));
      then txt;
  end match;
end fun_315;

protected function lm_316
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varInits, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _,
           a_varInits,
           a_varDecls )
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varInits,
           a_varDecls )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_varInits) = notparamInit(txt, i_var, "", x_i1, a_varDecls, a_varInits, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varInits, a_varDecls) = lm_316(txt, rest, a_useFlatArrayNotation, a_simCode, a_varInits, a_varDecls);
      then (txt, a_varInits, a_varDecls);
  end match;
end lm_316;

protected function lm_317
  input Tpl.Text in_txt;
  input list<SimCode.Statement> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.Statement> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Statement i_stmt;

    case ( txt,
           {},
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = funStatement(txt, i_stmt, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_317(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_317;

protected function lm_318
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      SimCode.Function a_fn;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutput(txt, a_fn, i_var, x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_318(txt, rest, a_useFlatArrayNotation, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end lm_318;

protected function lm_319
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      SimCode.Function a_fn;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutputTuple(txt, a_fn, i_var, x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_319(txt, rest, a_useFlatArrayNotation, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end lm_319;

protected function fun_320
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_a_outVars, in_a_useFlatArrayNotation, in_a_simCode, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      SimCode.Function a_fn;
      list<SimCode.Variable> i_outVars;

    case ( txt,
           (i_outVars as {_}),
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_318(txt, i_outVars, a_useFlatArrayNotation, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
        txt = Tpl.popIter(txt);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_outVars,
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_319(txt, i_outVars, a_useFlatArrayNotation, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
        txt = Tpl.popIter(txt);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end fun_320;

protected function lm_321
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_321(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_321;

protected function fun_322
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_322;

protected function fun_323
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_functionArguments;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_functionArguments, in_a_outVars)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_outVars )
      equation
        txt = fun_322(txt, a_outVars);
      then txt;
  end match;
end fun_323;

protected function fun_324
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& output"));
      then txt;
  end match;
end fun_324;

protected function fun_325
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*output = _"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";*/"));
      then txt;
  end match;
end fun_325;

protected function lm_326
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = funArgDefinition2(txt, i_var, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_326(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_326;

protected function fun_327
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" out;"));
      then txt;
  end match;
end fun_327;

protected function fun_328
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input Tpl.Text in_a_retType;
  input list<SimCode.Variable> in_a_outVars;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Variable> in_a_functionArguments;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inFunc, in_a_retType, in_a_outVars, in_a_useFlatArrayNotation, in_a_simCode, in_a_functionArguments, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;
      list<SimCode.Variable> a_outVars;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> a_functionArguments;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_retType,
           a_outVars,
           a_useFlatArrayNotation,
           a_simCode,
           a_functionArguments,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_326(txt, a_functionArguments, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_327(txt, a_outVars, a_retType);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//MMC_TRY_TOP()\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_328;

public function functionBodyRegularFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      list<SimCode.Variable> i_functionArguments;
      SimCode.Function i_fn;
      list<SimCode.Statement> i_body;
      list<SimCode.Variable> i_variableDeclarations;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_0___1;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarInits;
      Tpl.Text l_bodyPart;
      Tpl.Text l_0__;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_fn as SimCode.FUNCTION(name = i_name, outVars = i_outVars, variableDeclarations = i_variableDeclarations, body = i_body, functionArguments = i_functionArguments)),
           a_inFunc,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_315(Tpl.emptyTxt, i_outVars, l_fname);
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_varInits, l_varDecls) = lm_316(l_0__, i_variableDeclarations, a_useFlatArrayNotation, a_simCode, l_varInits, l_varDecls);
        l_0__ = Tpl.popIter(l_0__);
        l_bodyPart = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bodyPart, l_varDecls) = lm_317(l_bodyPart, i_body, a_useFlatArrayNotation, a_simCode, l_varDecls);
        l_bodyPart = Tpl.popIter(l_bodyPart);
        l_outVarInits = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        l_outVarAssign = Tpl.emptyTxt;
        (l_0___1, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls) = fun_320(Tpl.emptyTxt, i_outVars, a_useFlatArrayNotation, a_simCode, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls, i_fn);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "//if outvars missing\n",
                                    "void /*"
                                }, false));
        txt = Tpl.writeText(txt, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/ Functions::"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_321(txt, i_functionArguments, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = fun_323(txt, i_functionArguments, i_outVars);
        txt = fun_324(txt, i_outVars, l_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " )\n",
                                    "{\n",
                                    "  //functionBodyRegularFunction\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//outvars\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_outVarInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_varInits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  do\n",
                                    "  {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_bodyPart);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  while(false);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_outVarAssign);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = fun_325(txt, i_outVars, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = fun_328(txt, a_inFunc, l_retType, i_outVars, a_useFlatArrayNotation, a_simCode, i_functionArguments, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end functionBodyRegularFunction;

protected function fun_330
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void"));
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RetType"));
      then txt;
  end match;
end fun_330;

protected function fun_331
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars, in_a_fname)
    local
      Tpl.Text txt;
      Tpl.Text a_fname;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeText(txt, a_fname);
      then txt;
  end match;
end fun_331;

protected function fun_332
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outputAssign;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outputAssign;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_outputAssign, out_a_inputAssign, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_outVars, in_a_useFlatArrayNotation, in_a_simCode, in_a_outputAssign, in_a_inputAssign, in_a_varDecls, in_a_preExp, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outputAssign;
      Tpl.Text a_inputAssign;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Function a_fn;

    case ( txt,
           {_},
           a_useFlatArrayNotation,
           a_simCode,
           a_outputAssign,
           a_inputAssign,
           a_varDecls,
           a_preExp,
           a_fn )
      equation
        (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign) = extFunCall(txt, a_fn, a_preExp, a_varDecls, a_inputAssign, a_outputAssign, a_simCode, a_useFlatArrayNotation, false);
      then (txt, a_outputAssign, a_inputAssign, a_varDecls, a_preExp);

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_outputAssign,
           a_inputAssign,
           a_varDecls,
           a_preExp,
           a_fn )
      equation
        (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign) = extFunCall(txt, a_fn, a_preExp, a_varDecls, a_inputAssign, a_outputAssign, a_simCode, a_useFlatArrayNotation, true);
      then (txt, a_outputAssign, a_inputAssign, a_varDecls, a_preExp);
  end match;
end fun_332;

protected function lm_333
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_outVarInits, in_a_varDecls, in_a_retVar)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_retVar;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarInits,
           a_varDecls,
           a_retVar )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits) = notparamInit(txt, i_var, Tpl.textString(a_retVar), x_i1, a_varDecls, a_outVarInits, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarInits, a_varDecls) = lm_333(txt, rest, a_useFlatArrayNotation, a_simCode, a_outVarInits, a_varDecls, a_retVar);
      then (txt, a_outVarInits, a_varDecls);
  end match;
end lm_333;

protected function lm_334
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      SimCode.Function a_fn;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           _ )
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutputTuple(txt, a_fn, i_var, x_i1, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_334(txt, rest, a_useFlatArrayNotation, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end lm_334;

protected function fun_335
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign;
  input Tpl.Text in_a_outVarCopy;
  input Tpl.Text in_a_outVarInits;
  input Tpl.Text in_a_varDecls;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign;
  output Tpl.Text out_a_outVarCopy;
  output Tpl.Text out_a_outVarInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_outVarAssign, out_a_outVarCopy, out_a_outVarInits, out_a_varDecls) :=
  match(in_txt, in_a_outVars, in_a_useFlatArrayNotation, in_a_simCode, in_a_outVarAssign, in_a_outVarCopy, in_a_outVarInits, in_a_varDecls, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign;
      Tpl.Text a_outVarCopy;
      Tpl.Text a_outVarInits;
      Tpl.Text a_varDecls;
      SimCode.Function a_fn;
      list<SimCode.Variable> i_outVars;
      SimCode.Variable i_var;
      list<SimCode.Variable> ret_0;

    case ( txt,
           {i_var},
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        (txt, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign) = varOutput(txt, a_fn, i_var, 0, a_varDecls, a_outVarInits, a_outVarCopy, a_outVarAssign, a_simCode, a_useFlatArrayNotation);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);

    case ( txt,
           i_outVars,
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarAssign,
           a_outVarCopy,
           a_outVarInits,
           a_varDecls,
           a_fn )
      equation
        ret_0 = List.restOrEmpty(i_outVars);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls) = lm_334(txt, ret_0, a_useFlatArrayNotation, a_simCode, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls, a_fn);
        txt = Tpl.popIter(txt);
      then (txt, a_outVarAssign, a_outVarCopy, a_outVarInits, a_varDecls);
  end match;
end fun_335;

protected function lm_336
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign1;
  input Tpl.Text in_a_outVarCopy1;
  input Tpl.Text in_a_outVarInits1;
  input Tpl.Text in_a_varDecls1;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign1;
  output Tpl.Text out_a_outVarCopy1;
  output Tpl.Text out_a_outVarInits1;
  output Tpl.Text out_a_varDecls1;
algorithm
  (out_txt, out_a_outVarAssign1, out_a_outVarCopy1, out_a_outVarInits1, out_a_varDecls1) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_outVarAssign1, in_a_outVarCopy1, in_a_outVarInits1, in_a_varDecls1, in_a_fn)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign1;
      Tpl.Text a_outVarCopy1;
      Tpl.Text a_outVarInits1;
      Tpl.Text a_varDecls1;
      SimCode.Function a_fn;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _,
           a_outVarAssign1,
           a_outVarCopy1,
           a_outVarInits1,
           a_varDecls1,
           _ )
      then (txt, a_outVarAssign1, a_outVarCopy1, a_outVarInits1, a_varDecls1);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarAssign1,
           a_outVarCopy1,
           a_outVarInits1,
           a_varDecls1,
           a_fn )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        (txt, a_varDecls1, a_outVarInits1, a_outVarCopy1, a_outVarAssign1) = varOutputTuple(txt, a_fn, i_var, x_i1, a_varDecls1, a_outVarInits1, a_outVarCopy1, a_outVarAssign1, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_outVarAssign1, a_outVarCopy1, a_outVarInits1, a_varDecls1) = lm_336(txt, rest, a_useFlatArrayNotation, a_simCode, a_outVarAssign1, a_outVarCopy1, a_outVarInits1, a_varDecls1, a_fn);
      then (txt, a_outVarAssign1, a_outVarCopy1, a_outVarInits1, a_varDecls1);
  end match;
end lm_336;

protected function fun_337
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outVarAssign1;
  input Tpl.Text in_a_outVarCopy1;
  input Tpl.Text in_a_outVarInits1;
  input Tpl.Text in_a_varDecls1;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outVarAssign1;
  output Tpl.Text out_a_outVarCopy1;
  output Tpl.Text out_a_outVarInits1;
  output Tpl.Text out_a_varDecls1;
algorithm
  (out_txt, out_a_outVarAssign1, out_a_outVarCopy1, out_a_outVarInits1, out_a_varDecls1) :=
  match(in_txt, in_a_outVars, in_a_useFlatArrayNotation, in_a_simCode, in_a_outVarAssign1, in_a_outVarCopy1, in_a_outVarInits1, in_a_varDecls1, in_a_fn)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outVarAssign1;
      Tpl.Text a_outVarCopy1;
      Tpl.Text a_outVarInits1;
      Tpl.Text a_varDecls1;
      SimCode.Function a_fn;
      list<SimCode.Variable> i_outVars;
      list<SimCode.Variable> ret_0;

    case ( txt,
           {_},
           _,
           _,
           a_outVarAssign1,
           a_outVarCopy1,
           a_outVarInits1,
           a_varDecls1,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then (txt, a_outVarAssign1, a_outVarCopy1, a_outVarInits1, a_varDecls1);

    case ( txt,
           i_outVars,
           a_useFlatArrayNotation,
           a_simCode,
           a_outVarAssign1,
           a_outVarCopy1,
           a_outVarInits1,
           a_varDecls1,
           a_fn )
      equation
        ret_0 = List.restOrEmpty(i_outVars);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_outVarAssign1, a_outVarCopy1, a_outVarInits1, a_varDecls1) = lm_336(txt, ret_0, a_useFlatArrayNotation, a_simCode, a_outVarAssign1, a_outVarCopy1, a_outVarInits1, a_varDecls1, a_fn);
        txt = Tpl.popIter(txt);
      then (txt, a_outVarAssign1, a_outVarCopy1, a_outVarInits1, a_varDecls1);
  end match;
end fun_337;

protected function fun_338
  input Tpl.Text in_txt;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text i_retVar;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_retVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output = "));
        txt = Tpl.writeText(txt, i_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_338;

protected function fun_339
  input Tpl.Text in_txt;
  input Boolean in_a_iI;
  input Tpl.Text in_a_outVarAssign1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_iI, in_a_outVarAssign1)
    local
      Tpl.Text txt;
      Tpl.Text a_outVarAssign1;

    case ( txt,
           false,
           a_outVarAssign1 )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_outVarAssign1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_339;

protected function fun_340
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_outVarAssign1;
  input Boolean in_a_iI;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_outVarAssign1, in_a_iI)
    local
      Tpl.Text txt;
      Tpl.Text a_outVarAssign1;
      Boolean a_iI;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_outVarAssign1,
           a_iI )
      equation
        txt = fun_339(txt, a_iI, a_outVarAssign1);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_340;

protected function fun_341
  input Tpl.Text in_txt;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_outVarAssign1;
  input Boolean in_a_iI;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_t, in_a_outVarAssign1, in_a_iI)
    local
      Tpl.Text txt;
      Tpl.Text a_outVarAssign1;
      Boolean a_iI;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty),
           a_outVarAssign1,
           a_iI )
      equation
        txt = fun_340(txt, i_ty, a_outVarAssign1, a_iI);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_341;

protected function fun_342
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_outVarAssign1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg, in_a_outVarAssign1)
    local
      Tpl.Text txt;
      Tpl.Text a_outVarAssign1;
      Boolean i_iI;
      DAE.Type i_t;

    case ( txt,
           SimCode.SIMEXTARG(cref = _, isInput = i_iI, outputIndex = _, isArray = true, type_ = i_t),
           a_outVarAssign1 )
      equation
        txt = fun_341(txt, i_t, a_outVarAssign1, i_iI);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_342;

protected function lm_343
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_outVarAssign1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_outVarAssign1)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_outVarAssign1;
      SimCode.SimExtArg i_extArg;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_extArg :: rest,
           a_outVarAssign1 )
      equation
        txt = fun_342(txt, i_extArg, a_outVarAssign1);
        txt = lm_343(txt, rest, a_outVarAssign1);
      then txt;
  end match;
end lm_343;

protected function fun_344
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_outVarAssign1;
  input list<SimCode.SimExtArg> in_a_extArgs;
  input Tpl.Text in_a_retVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_outVarAssign1, in_a_extArgs, in_a_retVar)
    local
      Tpl.Text txt;
      Tpl.Text a_outVarAssign1;
      list<SimCode.SimExtArg> a_extArgs;
      Tpl.Text a_retVar;

    case ( txt,
           "",
           _,
           _,
           a_retVar )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = fun_338(txt, a_retVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  "));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_outVarAssign1,
           a_extArgs,
           _ )
      equation
        txt = lm_343(txt, a_extArgs, a_outVarAssign1);
      then txt;
  end match;
end fun_344;

protected function lm_345
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = funArgDefinition(txt, i_var, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_345(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_345;

protected function fun_346
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_346;

protected function fun_347
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_a_funArgs;
  input list<SimCode.Variable> in_a_outVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_funArgs, in_a_outVars)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _,
           a_outVars )
      equation
        txt = fun_346(txt, a_outVars);
      then txt;
  end match;
end fun_347;

protected function fun_348
  input Tpl.Text in_txt;
  input Tpl.Text in_a_retVar;
  input Tpl.Text in_a_retType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_retVar, in_a_retType)
    local
      Tpl.Text txt;
      Tpl.Text a_retType;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_retType )
      equation
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("& output"));
      then txt;
  end match;
end fun_348;

protected function fun_349
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ptrT_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ptr_"));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=NULL;"));
      then txt;
  end match;
end fun_349;

protected function lm_350
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name) :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_350(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = lm_350(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_350;

protected function lm_351
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.Variable i_arg;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (i_arg as SimCode.VARIABLE(name = _)) :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = readInVar(txt, i_arg, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_351(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = lm_351(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_351;

protected function lm_352
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name) :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_352(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = lm_352(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_352;

protected function lm_353
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      Integer x_i1;
      SimCode.Variable i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)) :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = writeOutVar(txt, i_var, x_i1);
        txt = Tpl.nextIter(txt);
        txt = lm_353(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_353(txt, rest);
      then txt;
  end match;
end lm_353;

protected function fun_354
  input Tpl.Text in_txt;
  input Boolean in_a_inFunc;
  input list<SimCode.Variable> in_a_outVars;
  input Tpl.Text in_a_retType;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.Variable> in_a_funArgs;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_inFunc, in_a_outVars, in_a_retType, in_a_useFlatArrayNotation, in_a_simCode, in_a_funArgs, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.Variable> a_outVars;
      Tpl.Text a_retType;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      list<SimCode.Variable> a_funArgs;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_outVars,
           a_retType,
           a_useFlatArrayNotation,
           a_simCode,
           a_funArgs,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int in_"));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(type_description * inArgs, type_description * outVar)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_350(txt, a_funArgs, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_retType);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" out;\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_351(txt, a_funArgs, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MMC_TRY_TOP()\n",
                                    "out = _"
                                }, false));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_352(txt, a_funArgs, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "MMC_CATCH_TOP(return 1)\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_353(txt, a_outVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("return 0;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;
  end match;
end fun_354;

public function functionBodyExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input Boolean in_a_inFunc;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn, in_a_inFunc, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_inFunc;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      list<SimCode.Variable> i_funArgs;
      list<SimCode.SimExtArg> i_extArgs;
      SimCode.Function i_efn;
      list<SimCode.Variable> i_outVars;
      Absyn.Path i_name;
      Tpl.Text l_fnBody;
      String str_19;
      Tpl.Text l_functionBodyExternalFunctionreturn;
      Tpl.Text l_0___2;
      Tpl.Text l_outVarAssign1;
      Tpl.Text l_outVarCopy1;
      Tpl.Text l_outVarInits1;
      Tpl.Text l_varDecls1;
      Tpl.Text l_0___1;
      Tpl.Text l_outVarCopy;
      Tpl.Text l_outVarAssign;
      Tpl.Text l_0__;
      Tpl.Text l_callPart;
      Tpl.Text l_outVarInits;
      Tpl.Text l_retVar;
      Tpl.Text l_outputAssign;
      Tpl.Text l_inputAssign;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;
      Tpl.Text l_retType;
      Tpl.Text l_fname;

    case ( txt,
           (i_efn as SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, name = i_name, outVars = i_outVars, funArgs = i_funArgs, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language)),
           a_inFunc,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        l_retType = fun_330(Tpl.emptyTxt, i_outVars, l_fname);
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_inputAssign = Tpl.emptyTxt;
        l_outputAssign = Tpl.emptyTxt;
        l_retVar = fun_331(Tpl.emptyTxt, i_outVars, l_fname);
        l_outVarInits = Tpl.emptyTxt;
        (l_callPart, l_outputAssign, l_inputAssign, l_varDecls, l_preExp) = fun_332(Tpl.emptyTxt, i_outVars, a_useFlatArrayNotation, a_simCode, l_outputAssign, l_inputAssign, l_varDecls, l_preExp, i_efn);
        l_0__ = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, SOME(Tpl.ST_STRING("")), NONE(), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_0__, l_outVarInits, l_varDecls) = lm_333(l_0__, i_outVars, a_useFlatArrayNotation, a_simCode, l_outVarInits, l_varDecls, l_retVar);
        l_0__ = Tpl.popIter(l_0__);
        l_outVarAssign = Tpl.emptyTxt;
        l_outVarCopy = Tpl.emptyTxt;
        (l_0___1, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls) = fun_335(Tpl.emptyTxt, i_outVars, a_useFlatArrayNotation, a_simCode, l_outVarAssign, l_outVarCopy, l_outVarInits, l_varDecls, i_efn);
        l_varDecls1 = Tpl.emptyTxt;
        l_outVarInits1 = Tpl.emptyTxt;
        l_outVarCopy1 = Tpl.emptyTxt;
        l_outVarAssign1 = Tpl.emptyTxt;
        (l_0___2, l_outVarAssign1, l_outVarCopy1, l_outVarInits1, l_varDecls1) = fun_337(Tpl.emptyTxt, i_outVars, a_useFlatArrayNotation, a_simCode, l_outVarAssign1, l_outVarCopy1, l_outVarInits1, l_varDecls1, i_efn);
        str_19 = Tpl.textString(l_outVarAssign1);
        l_functionBodyExternalFunctionreturn = fun_344(Tpl.emptyTxt, str_19, l_outVarAssign1, i_extArgs, l_retVar);
        l_fnBody = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("void /*"));
        l_fnBody = Tpl.writeText(l_fnBody, l_retType);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("*/ Functions::"));
        l_fnBody = Tpl.writeText(l_fnBody, l_fname);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("("));
        l_fnBody = Tpl.pushIter(l_fnBody, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_fnBody = lm_345(l_fnBody, i_funArgs, a_useFlatArrayNotation, a_simCode);
        l_fnBody = Tpl.popIter(l_fnBody);
        l_fnBody = fun_347(l_fnBody, i_funArgs, i_outVars);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING(" "));
        l_fnBody = fun_348(l_fnBody, l_retVar, l_retType);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              ")/*function2*/\n",
                                              "{\n",
                                              "  /* functionBodyExternalFunction: varDecls */\n"
                                          }, true));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(2));
        l_fnBody = Tpl.writeText(l_fnBody, l_varDecls);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: preExp */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_preExp);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.writeText(l_fnBody, l_inputAssign);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("  /* functionBodyExternalFunction: outputAlloc */\n"));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(2));
        l_fnBody = Tpl.writeText(l_fnBody, l_outVarInits);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_LINE("/* functionBodyExternalFunction: callPart */\n"));
        l_fnBody = Tpl.writeText(l_fnBody, l_callPart);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.writeText(l_fnBody, l_outputAssign);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING_LIST({
                                              "/*testout1*/\n",
                                              "\n",
                                              "\n",
                                              "\n",
                                              "/*testout ende*/\n",
                                              "   /* functionBodyExternalFunction: return */\n"
                                          }, true));
        l_fnBody = Tpl.pushBlock(l_fnBody, Tpl.BT_INDENT(2));
        l_fnBody = Tpl.writeText(l_fnBody, l_functionBodyExternalFunctionreturn);
        l_fnBody = Tpl.softNewLine(l_fnBody);
        l_fnBody = Tpl.popBlock(l_fnBody);
        l_fnBody = Tpl.writeTok(l_fnBody, Tpl.ST_STRING("}"));
        txt = fun_349(txt, i_dynamicLoad, i_language, i_extName);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_fnBody);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = fun_354(txt, a_inFunc, i_outVars, l_retType, a_useFlatArrayNotation, a_simCode, i_funArgs, l_fname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end functionBodyExternalFunction;

public function writeOutVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_index)
    local
      Tpl.Text txt;
      Integer a_index;
      SimCode.Variable i_var;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_modelica_record(outVar, "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, "");
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("write_"));
        txt = varType(txt, i_var);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(outVar, &out.targTest8"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end writeOutVar;

protected function fun_357
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Integer in_a_index;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_index, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = writeOutVarRecordMembers(txt, i_ty, a_index, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           i_ty,
           a_index,
           a_subvar_name,
           a_prefix )
      equation
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", &(out.targTest7"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_357;

protected function lm_358
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      Integer a_index;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_index,
           a_prefix )
      equation
        txt = fun_357(txt, i_ty, a_index, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_358(txt, rest, a_index, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_index,
           a_prefix )
      equation
        txt = lm_358(txt, rest, a_index, a_prefix);
      then txt;
  end match;
end lm_358;

protected function fun_359
  input Tpl.Text in_txt;
  input Tpl.Text in_a_args;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_args)
    local
      Tpl.Text txt;
      Tpl.Text i_args;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}) )
      then txt;

    case ( txt,
           i_args )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_args);
      then txt;
  end match;
end fun_359;

public function writeOutVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input Integer in_a_index;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_index, in_a_prefix)
    local
      Tpl.Text txt;
      Integer a_index;
      String a_prefix;
      list<DAE.Var> i_vl;
      ClassInf.State i_n;
      Tpl.Text l_args;
      Absyn.Path ret_1;
      Tpl.Text l_basename;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl, complexClassType = i_n),
           a_index,
           a_prefix )
      equation
        ret_1 = ClassInf.getStateName(i_n);
        l_basename = CodegenUtil.underscorePath(Tpl.emptyTxt, ret_1);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_args = lm_358(l_args, i_vl, a_index, a_prefix);
        l_args = Tpl.popIter(l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = Tpl.writeText(txt, l_basename);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__desc"));
        txt = fun_359(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", TYPE_DESC_NONE"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end writeOutVarRecordMembers;

public function expTypeRW
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_INT"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_REAL"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_STRING"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_BOOL"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_INT"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = i_ty) )
      equation
        txt = expTypeRW(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ARRAY"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_RECORD"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_MMC"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TYPE_DESC_MMC"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end expTypeRW;

protected function fun_362
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(char**)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_362;

public function readInVar
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      DAE.ComponentRef i_name;
      DAE.ComponentRef i_cr;
      DAE.Type i_ty;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.VARIABLE(name = i_cr, ty = (i_ty as DAE.T_COMPLEX(complexClassType = ClassInf.RECORD(path = _)))),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_modelica_record(&inArgs, "));
        txt_0 = contextCref(Tpl.emptyTxt, i_cr, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(txt_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(name = i_name, ty = (i_ty as DAE.T_STRING(varLst = _))),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, "));
        ret_1 = Config.acceptMetaModelicaGrammar();
        txt = fun_362(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty, name = i_name),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (read_"));
        txt = expTypeArrayIf(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(&inArgs, &"));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")) return 1;"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end readInVar;

protected function fun_364
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.Ident in_a_subvar_name;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ty, in_a_subvar_name, in_a_prefix)
    local
      Tpl.Text txt;
      DAE.Ident a_subvar_name;
      String a_prefix;
      DAE.Type i_ty;
      Tpl.Text l_newPrefix;

    case ( txt,
           (i_ty as DAE.T_COMPLEX(complexClassType = _)),
           a_subvar_name,
           a_prefix )
      equation
        l_newPrefix = Tpl.writeStr(Tpl.emptyTxt, a_prefix);
        l_newPrefix = Tpl.writeTok(l_newPrefix, Tpl.ST_STRING("."));
        l_newPrefix = Tpl.writeStr(l_newPrefix, a_subvar_name);
        txt = readInVarRecordMembers(txt, i_ty, Tpl.textString(l_newPrefix));
      then txt;

    case ( txt,
           _,
           a_subvar_name,
           a_prefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&("));
        txt = Tpl.writeStr(txt, a_prefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_subvar_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_364;

protected function lm_365
  input Tpl.Text in_txt;
  input list<DAE.Var> in_items;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_prefix)
    local
      Tpl.Text txt;
      list<DAE.Var> rest;
      String a_prefix;
      DAE.Ident i_subvar_name;
      DAE.Type i_ty;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           DAE.TYPES_VAR(ty = i_ty, name = i_subvar_name) :: rest,
           a_prefix )
      equation
        txt = fun_364(txt, i_ty, i_subvar_name, a_prefix);
        txt = Tpl.nextIter(txt);
        txt = lm_365(txt, rest, a_prefix);
      then txt;

    case ( txt,
           _ :: rest,
           a_prefix )
      equation
        txt = lm_365(txt, rest, a_prefix);
      then txt;
  end match;
end lm_365;

public function readInVarRecordMembers
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;
  input String in_a_prefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type, in_a_prefix)
    local
      Tpl.Text txt;
      String a_prefix;
      list<DAE.Var> i_vl;

    case ( txt,
           DAE.T_COMPLEX(varLst = i_vl),
           a_prefix )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_365(txt, i_vl, a_prefix);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end readInVarRecordMembers;

public function outDecl
  input Tpl.Text txt;
  input String a_ty;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
protected
  Tpl.Text l_newVar;
algorithm
  l_newVar := Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("out"));
  out_a_varDecls := Tpl.writeStr(a_varDecls, a_ty);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(" "));
  out_a_varDecls := Tpl.writeText(out_a_varDecls, l_newVar);
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_STRING(";"));
  out_a_varDecls := Tpl.writeTok(out_a_varDecls, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, l_newVar);
end outDecl;

protected function fun_368
  input Tpl.Text in_txt;
  input String in_a_language;
  input Boolean in_a_useTuple;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outputAssign;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Function in_a_fun;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outputAssign;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_outputAssign, out_a_inputAssign, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_language, in_a_useTuple, in_a_useFlatArrayNotation, in_a_simCode, in_a_outputAssign, in_a_inputAssign, in_a_varDecls, in_a_preExp, in_a_fun)
    local
      Tpl.Text txt;
      Boolean a_useTuple;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outputAssign;
      Tpl.Text a_inputAssign;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Function a_fun;

    case ( txt,
           "C",
           a_useTuple,
           a_useFlatArrayNotation,
           a_simCode,
           a_outputAssign,
           a_inputAssign,
           a_varDecls,
           a_preExp,
           a_fun )
      equation
        (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign) = extFunCallC(txt, a_fun, a_preExp, a_varDecls, a_inputAssign, a_outputAssign, a_simCode, a_useFlatArrayNotation, a_useTuple);
      then (txt, a_outputAssign, a_inputAssign, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           _,
           a_outputAssign,
           a_inputAssign,
           a_varDecls,
           a_preExp,
           _ )
      then (txt, a_outputAssign, a_inputAssign, a_varDecls, a_preExp);
  end match;
end fun_368;

public function extFunCall
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_outputAssign;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_useTuple;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_outputAssign;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls, out_a_inputAssign, out_a_outputAssign) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls, in_a_inputAssign, in_a_outputAssign, in_a_simCode, in_a_useFlatArrayNotation, in_a_useTuple)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text a_inputAssign;
      Tpl.Text a_outputAssign;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Boolean a_useTuple;
      SimCode.Function i_fun;
      String i_language;

    case ( txt,
           (i_fun as SimCode.EXTERNAL_FUNCTION(language = i_language)),
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           a_simCode,
           a_useFlatArrayNotation,
           a_useTuple )
      equation
        (txt, a_outputAssign, a_inputAssign, a_varDecls, a_preExp) = fun_368(txt, i_language, a_useTuple, a_useFlatArrayNotation, a_simCode, a_outputAssign, a_inputAssign, a_varDecls, a_preExp, i_fun);
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           _,
           _,
           _ )
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);
  end match;
end extFunCall;

protected function lm_370
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_arg :: rest,
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_arg, a_varDecls);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_370(txt, rest, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_370;

protected function fun_371
  input Tpl.Text in_txt;
  input Boolean in_a_dynamicLoad;
  input String in_a_language;
  input String in_a_extName;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dynamicLoad, in_a_language, in_a_extName, in_a_fname)
    local
      Tpl.Text txt;
      String a_language;
      String a_extName;
      Tpl.Text a_fname;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_language,
           a_extName,
           a_fname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, a_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("==NULL) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MODELICA_TERMINATE(\"dynamic external function "));
        txt = extFunctionName(txt, a_extName, a_language);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" not set!\")\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} else"));
      then txt;
  end match;
end fun_371;

protected function lm_372
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_outputAssign;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_outputAssign;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_outputAssign, out_a_inputAssign, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_outputAssign, in_a_inputAssign, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_outputAssign;
      Tpl.Text a_inputAssign;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           _,
           _,
           a_outputAssign,
           a_inputAssign,
           a_varDecls,
           a_preExp )
      then (txt, a_outputAssign, a_inputAssign, a_varDecls, a_preExp);

    case ( txt,
           i_arg :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_outputAssign,
           a_inputAssign,
           a_varDecls,
           a_preExp )
      equation
        (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign) = extArg(txt, i_arg, a_preExp, a_varDecls, a_inputAssign, a_outputAssign, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_outputAssign, a_inputAssign, a_varDecls, a_preExp) = lm_372(txt, rest, a_useFlatArrayNotation, a_simCode, a_outputAssign, a_inputAssign, a_varDecls, a_preExp);
      then (txt, a_outputAssign, a_inputAssign, a_varDecls, a_preExp);
  end match;
end lm_372;

protected function fun_373
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_c;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c) )
      equation
        txt = extVarName2(txt, i_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_373;

protected function fun_374
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_extReturn, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_varDecls )
      equation
        (txt, a_varDecls) = extFunCallVardecl(txt, i_extReturn, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end fun_374;

protected function lm_375
  input Tpl.Text in_txt;
  input list<SimCode.SimExtArg> in_items;
  input Boolean in_a_useTuple;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useTuple, in_a_fname)
    local
      Tpl.Text txt;
      list<SimCode.SimExtArg> rest;
      Boolean a_useTuple;
      Tpl.Text a_fname;
      SimCode.SimExtArg i_arg;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_arg :: rest,
           a_useTuple,
           a_fname )
      equation
        txt = extFunCallVarcopy(txt, i_arg, Tpl.textString(a_fname), a_useTuple);
        txt = Tpl.nextIter(txt);
        txt = lm_375(txt, rest, a_useTuple, a_fname);
      then txt;
  end match;
end lm_375;

protected function fun_376
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extReturn;
  input Boolean in_a_useTuple;
  input Tpl.Text in_a_fname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extReturn, in_a_useTuple, in_a_fname)
    local
      Tpl.Text txt;
      Boolean a_useTuple;
      Tpl.Text a_fname;
      SimCode.SimExtArg i_extReturn;

    case ( txt,
           (i_extReturn as SimCode.SIMEXTARG(cref = _)),
           a_useTuple,
           a_fname )
      equation
        txt = extFunCallVarcopy(txt, i_extReturn, Tpl.textString(a_fname), a_useTuple);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_376;

public function extFunCallC
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fun;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_outputAssign;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_useTuple;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_outputAssign;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls, out_a_inputAssign, out_a_outputAssign) :=
  match(in_txt, in_a_fun, in_a_preExp, in_a_varDecls, in_a_inputAssign, in_a_outputAssign, in_a_simCode, in_a_useFlatArrayNotation, in_a_useTuple)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text a_inputAssign;
      Tpl.Text a_outputAssign;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Boolean a_useTuple;
      SimCode.SimExtArg i_extReturn;
      String i_language;
      String i_extName;
      Boolean i_dynamicLoad;
      Absyn.Path i_name;
      list<SimCode.SimExtArg> i_extArgs;
      Tpl.Text l_returnAssign;
      Tpl.Text l_args;
      Tpl.Text l_dynamicCheck;
      Tpl.Text l_fname;
      list<SimCode.SimExtArg> ret_1;
      Tpl.Text l_varDecs;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(extArgs = i_extArgs, name = i_name, dynamicLoad = i_dynamicLoad, extName = i_extName, language = i_language, extReturn = i_extReturn),
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           a_simCode,
           a_useFlatArrayNotation,
           a_useTuple )
      equation
        ret_1 = List.union(i_extArgs, i_extArgs);
        l_varDecs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_varDecs, a_varDecls) = lm_370(l_varDecs, ret_1, a_varDecls);
        l_varDecs = Tpl.popIter(l_varDecs);
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        l_dynamicCheck = fun_371(Tpl.emptyTxt, i_dynamicLoad, i_language, i_extName, l_fname);
        l_args = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_args, a_outputAssign, a_inputAssign, a_varDecls, a_preExp) = lm_372(l_args, i_extArgs, a_useFlatArrayNotation, a_simCode, a_outputAssign, a_inputAssign, a_varDecls, a_preExp);
        l_args = Tpl.popIter(l_args);
        l_returnAssign = fun_373(Tpl.emptyTxt, i_extReturn);
        txt = Tpl.writeText(txt, l_varDecs);
        txt = Tpl.softNewLine(txt);
        (txt, a_varDecls) = fun_374(txt, i_extReturn, a_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_dynamicCheck);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_returnAssign);
        txt = Tpl.writeStr(txt, i_extName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_args);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_375(txt, i_extArgs, a_useTuple, l_fname);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = fun_376(txt, i_extReturn, a_useTuple, l_fname);
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           _,
           _,
           _ )
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);
  end match;
end extFunCallC;

protected function fun_378
  input Tpl.Text in_txt;
  input Boolean in_a_useTuple;
  input Tpl.Text in_a_cr;
  input String in_a_fnName;
  input Integer in_a_oi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_useTuple, in_a_cr, in_a_fnName, in_a_oi)
    local
      Tpl.Text txt;
      Tpl.Text a_cr;
      String a_fnName;
      Integer a_oi;
      Tpl.Text l_assginEnd;
      Integer ret_1;
      Tpl.Text l_assginBegin;

    case ( txt,
           true,
           a_cr,
           a_fnName,
           a_oi )
      equation
        l_assginBegin = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("boost::get<"));
        ret_1 = intAdd(-1, a_oi);
        l_assginBegin = Tpl.writeStr(l_assginBegin, intString(ret_1));
        l_assginBegin = Tpl.writeTok(l_assginBegin, Tpl.ST_STRING(">("));
        l_assginEnd = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING(")"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_assginBegin);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*_"));
        txt = Tpl.writeStr(txt, a_fnName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".data*/output.data"));
        txt = Tpl.writeText(txt, l_assginEnd);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_cr,
           a_fnName,
           _ )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fnName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ;"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_378;

protected function fun_379
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input String in_a_fnName;
  input Boolean in_a_useTuple;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_oi, in_a_fnName, in_a_useTuple, in_a_c)
    local
      Tpl.Text txt;
      String a_fnName;
      Boolean a_useTuple;
      DAE.ComponentRef a_c;
      Integer i_oi;
      Tpl.Text l_cr;

    case ( txt,
           0,
           _,
           _,
           a_c )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*testarg"));
        txt = extVarName2(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*/"));
      then txt;

    case ( txt,
           i_oi,
           a_fnName,
           a_useTuple,
           a_c )
      equation
        l_cr = extVarName2(Tpl.emptyTxt, a_c);
        txt = fun_378(txt, a_useTuple, l_cr, a_fnName, i_oi);
      then txt;
  end match;
end fun_379;

public function extFunCallVarcopy
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input String in_a_fnName;
  input Boolean in_a_useTuple;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg, in_a_fnName, in_a_useTuple)
    local
      Tpl.Text txt;
      String a_fnName;
      Boolean a_useTuple;
      DAE.ComponentRef i_c;
      Integer i_oi;

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = _, cref = i_c),
           a_fnName,
           a_useTuple )
      equation
        txt = fun_379(txt, i_oi, a_fnName, a_useTuple, i_c);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end extFunCallVarcopy;

protected function fun_381
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input String in_a_fnName;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_oi, in_a_fnName, in_a_c)
    local
      Tpl.Text txt;
      String a_fnName;
      DAE.ComponentRef a_c;
      Integer i_oi;
      Tpl.Text l_assginEnd;
      Integer ret_2;
      Tpl.Text l_assginBegin;
      Tpl.Text l_cr;

    case ( txt,
           0,
           _,
           _ )
      then txt;

    case ( txt,
           i_oi,
           a_fnName,
           a_c )
      equation
        l_cr = extVarName2(Tpl.emptyTxt, a_c);
        l_assginBegin = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("boost::get<"));
        ret_2 = intAdd(-1, i_oi);
        l_assginBegin = Tpl.writeStr(l_assginBegin, intString(ret_2));
        l_assginBegin = Tpl.writeTok(l_assginBegin, Tpl.ST_STRING(">("));
        l_assginEnd = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING(")"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_assginBegin);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, a_fnName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".data"));
        txt = Tpl.writeText(txt, l_assginEnd);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ;"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_381;

public function extFunCallVarcopyTuple
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input String in_a_fnName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_arg, in_a_fnName)
    local
      Tpl.Text txt;
      String a_fnName;
      DAE.ComponentRef i_c;
      Integer i_oi;

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = _, cref = i_c),
           a_fnName )
      equation
        txt = fun_381(txt, i_oi, a_fnName, i_c);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end extFunCallVarcopyTuple;

public function expTypeModelica
  input Tpl.Text txt;
  input DAE.Type a_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFlag(txt, a_ty, 2);
end expTypeModelica;

protected function fun_384
  input Tpl.Text in_txt;
  input DAE.Type in_a_t;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_t)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c_str()"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end match;
end fun_384;

protected function fun_385
  input Tpl.Text in_txt;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      Tpl.Text a_cr;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_cr )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MMC_STRINGDATA("));
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ext"));
      then txt;
  end match;
end fun_385;

protected function fun_386
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_t, in_a_cr)
    local
      Tpl.Text txt;
      DAE.Type a_t;
      Tpl.Text a_cr;

    case ( txt,
           false,
           a_t,
           a_cr )
      equation
        txt = Tpl.writeText(txt, a_cr);
        txt = fun_384(txt, a_t);
      then txt;

    case ( txt,
           _,
           a_t,
           a_cr )
      equation
        txt = fun_385(txt, a_t, a_cr);
      then txt;
  end match;
end fun_386;

protected function fun_387
  input Tpl.Text in_txt;
  input Integer in_a_outputIndex;
  input DAE.ComponentRef in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outputIndex, in_a_c)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Integer i_outputIndex;

    case ( txt,
           0,
           a_c )
      equation
        txt = contextCref2(txt, a_c, SimCode.contextFunction);
      then txt;

    case ( txt,
           i_outputIndex,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("out.targTest4"));
        txt = Tpl.writeStr(txt, intString(i_outputIndex));
      then txt;
  end match;
end fun_387;

public function extArg
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_outputAssign;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_outputAssign;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls, out_a_inputAssign, out_a_outputAssign) :=
  match(in_txt, in_a_extArg, in_a_preExp, in_a_varDecls, in_a_inputAssign, in_a_outputAssign, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      Tpl.Text a_inputAssign;
      Tpl.Text a_outputAssign;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Integer i_outputIndex;
      DAE.Type i_type__;
      DAE.Exp i_exp;
      SimCode.SimExtArg i_extArg;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_dim;
      Tpl.Text l_typeStr;
      Boolean ret_4;
      Tpl.Text l_cr;
      Tpl.Text l_boolCast;
      Tpl.Text l_shortTypeStr;
      Tpl.Text l_name;

    case ( txt,
           (i_extArg as SimCode.SIMEXTARG(cref = i_c, outputIndex = _, isArray = true, type_ = i_t)),
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           _,
           _ )
      equation
        l_name = contextCref2(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, i_t);
        (l_boolCast, a_preExp, a_varDecls, a_inputAssign, a_outputAssign) = extCBoolCast(Tpl.emptyTxt, i_extArg, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);
        txt = Tpl.writeText(txt, l_boolCast);
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = 0, type_ = i_t),
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           _,
           _ )
      equation
        l_cr = contextCref2(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        ret_4 = Config.acceptMetaModelicaGrammar();
        txt = fun_386(txt, ret_4, i_t, l_cr);
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, outputIndex = _, type_ = _),
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
        txt = extVarName2(txt, i_c);
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);

    case ( txt,
           SimCode.SIMEXTARGEXP(exp = i_exp),
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        (txt, a_preExp, a_varDecls) = daeExternalCExp(txt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = i_c, type_ = i_type__, outputIndex = i_outputIndex, exp = i_exp),
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_typeStr = expTypeShort(Tpl.emptyTxt, i_type__);
        l_name = fun_387(Tpl.emptyTxt, i_outputIndex, i_c);
        (l_dim, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextFunction, a_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".getDims()["));
        txt = Tpl.writeText(txt, l_dim);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - 1]"));
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);

    case ( txt,
           _,
           a_preExp,
           a_varDecls,
           a_inputAssign,
           a_outputAssign,
           _,
           _ )
      then (txt, a_preExp, a_varDecls, a_inputAssign, a_outputAssign);
  end match;
end extArg;

protected function lm_389
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_dim;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dim :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_dim));
        txt = Tpl.nextIter(txt);
        txt = lm_389(txt, rest);
      then txt;
  end match;
end lm_389;

protected function fun_390
  input Tpl.Text in_txt;
  input Boolean in_a_iI;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_outputAssign;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_tmp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_outputAssign;
  output Tpl.Text out_a_tmp;
algorithm
  (out_txt, out_a_inputAssign, out_a_outputAssign, out_a_tmp) :=
  match(in_txt, in_a_iI, in_a_inputAssign, in_a_outputAssign, in_a_c, in_a_tmp)
    local
      Tpl.Text txt;
      Tpl.Text a_inputAssign;
      Tpl.Text a_outputAssign;
      DAE.ComponentRef a_c;
      Tpl.Text a_tmp;

    case ( txt,
           false,
           a_inputAssign,
           a_outputAssign,
           a_c,
           a_tmp )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".getData()\n"));
        (txt, a_tmp, a_outputAssign) = outputAssignTest(txt, a_c, SimCode.contextFunction, a_tmp, a_outputAssign);
        txt = Tpl.popBlock(txt);
      then (txt, a_inputAssign, a_outputAssign, a_tmp);

    case ( txt,
           _,
           a_inputAssign,
           a_outputAssign,
           a_c,
           a_tmp )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".getData()\n"));
        (txt, a_tmp, a_inputAssign) = inputAssignTest(txt, a_c, SimCode.contextFunction, a_tmp, a_inputAssign);
        txt = Tpl.popBlock(txt);
      then (txt, a_inputAssign, a_outputAssign, a_tmp);
  end match;
end fun_390;

protected function fun_391
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_name;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_outputAssign;
  input DAE.ComponentRef in_a_c;
  input Boolean in_a_iI;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_dimsStr;
  input Tpl.Text in_a_dimStr;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_outputAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_inputAssign, out_a_outputAssign, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_name, in_a_t, in_a_inputAssign, in_a_outputAssign, in_a_c, in_a_iI, in_a_varDecls, in_a_dimsStr, in_a_dimStr)
    local
      Tpl.Text txt;
      Tpl.Text a_name;
      DAE.Type a_t;
      Tpl.Text a_inputAssign;
      Tpl.Text a_outputAssign;
      DAE.ComponentRef a_c;
      Boolean a_iI;
      Tpl.Text a_varDecls;
      Tpl.Text a_dimsStr;
      Tpl.Text a_dimStr;
      Tpl.Text txt_1;
      Tpl.Text l_tmp;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _,
           _,
           a_inputAssign,
           a_outputAssign,
           a_c,
           a_iI,
           a_varDecls,
           a_dimsStr,
           a_dimStr )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("StatArrayDim"));
        txt_1 = Tpl.writeText(txt_1, a_dimStr);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("<int, "));
        txt_1 = Tpl.writeText(txt_1, a_dimsStr);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(" > "));
        (l_tmp, a_varDecls) = tempDecl(Tpl.emptyTxt, Tpl.textString(txt_1), a_varDecls);
        (txt, a_inputAssign, a_outputAssign, l_tmp) = fun_390(txt, a_iI, a_inputAssign, a_outputAssign, a_c, l_tmp);
      then (txt, a_inputAssign, a_outputAssign, a_varDecls);

    case ( txt,
           _,
           a_name,
           a_t,
           a_inputAssign,
           a_outputAssign,
           _,
           a_iI,
           a_varDecls,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = extType2(txt, a_t, a_iI, true);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = Tpl.writeText(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".getData() "));
      then (txt, a_inputAssign, a_outputAssign, a_varDecls);
  end match;
end fun_391;

protected function fun_392
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input Tpl.Text in_a_name;
  input DAE.Type in_a_t;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_outputAssign;
  input DAE.ComponentRef in_a_c;
  input Boolean in_a_iI;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_outputAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_inputAssign, out_a_outputAssign, out_a_varDecls) :=
  match(in_txt, in_a_type__, in_a_name, in_a_t, in_a_inputAssign, in_a_outputAssign, in_a_c, in_a_iI, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_name;
      DAE.Type a_t;
      Tpl.Text a_inputAssign;
      Tpl.Text a_outputAssign;
      DAE.ComponentRef a_c;
      Boolean a_iI;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;
      DAE.Dimensions i_dims;
      Integer ret_3;
      Tpl.Text l_dimStr;
      list<Integer> ret_1;
      Tpl.Text l_dimsStr;

    case ( txt,
           DAE.T_ARRAY(dims = i_dims, ty = i_ty),
           a_name,
           a_t,
           a_inputAssign,
           a_outputAssign,
           a_c,
           a_iI,
           a_varDecls )
      equation
        ret_1 = Expression.dimensionsList(i_dims);
        l_dimsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_dimsStr = lm_389(l_dimsStr, ret_1);
        l_dimsStr = Tpl.popIter(l_dimsStr);
        ret_3 = listLength(i_dims);
        l_dimStr = Tpl.writeStr(Tpl.emptyTxt, intString(ret_3));
        (txt, a_inputAssign, a_outputAssign, a_varDecls) = fun_391(txt, i_ty, a_name, a_t, a_inputAssign, a_outputAssign, a_c, a_iI, a_varDecls, l_dimsStr, l_dimStr);
      then (txt, a_inputAssign, a_outputAssign, a_varDecls);

    case ( txt,
           _,
           _,
           _,
           a_inputAssign,
           a_outputAssign,
           _,
           _,
           a_varDecls )
      then (txt, a_inputAssign, a_outputAssign, a_varDecls);
  end match;
end fun_392;

protected function fun_393
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_inputAssign;
  input Tpl.Text in_a_outputAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_outputAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_inputAssign, out_a_outputAssign) :=
  match(in_txt, in_a_extArg, in_a_varDecls, in_a_inputAssign, in_a_outputAssign)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_inputAssign;
      Tpl.Text a_outputAssign;
      DAE.Type i_t;
      Boolean i_iI;
      DAE.Type i_type__;
      DAE.ComponentRef i_c;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = i_iI, outputIndex = _, isArray = true, type_ = (i_type__ as i_t)),
           a_varDecls,
           a_inputAssign,
           a_outputAssign )
      equation
        l_name = contextCref2(Tpl.emptyTxt, i_c, SimCode.contextFunction);
        (txt, a_inputAssign, a_outputAssign, a_varDecls) = fun_392(txt, i_type__, l_name, i_t, a_inputAssign, a_outputAssign, i_c, i_iI, a_varDecls);
      then (txt, a_varDecls, a_inputAssign, a_outputAssign);

    case ( txt,
           _,
           a_varDecls,
           a_inputAssign,
           a_outputAssign )
      then (txt, a_varDecls, a_inputAssign, a_outputAssign);
  end match;
end fun_393;

public function extCBoolCast
  input Tpl.Text txt;
  input SimCode.SimExtArg a_extArg;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_inputAssign;
  input Tpl.Text a_outputAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_inputAssign;
  output Tpl.Text out_a_outputAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_inputAssign, out_a_outputAssign) := fun_393(txt, a_extArg, a_varDecls, a_inputAssign, a_outputAssign);
  out_a_preExp := a_preExp;
end extCBoolCast;

public function inputAssignTest
  input Tpl.Text txt;
  input DAE.ComponentRef a_cref;
  input SimCode.Context a_context;
  input Tpl.Text a_tmp;
  input Tpl.Text a_inputAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_inputAssign;
algorithm
  out_a_inputAssign := Tpl.writeTok(a_inputAssign, Tpl.ST_STRING("convertBoolToInt("));
  out_a_inputAssign := contextCref2(out_a_inputAssign, a_cref, a_context);
  out_a_inputAssign := Tpl.writeTok(out_a_inputAssign, Tpl.ST_STRING(", "));
  out_a_inputAssign := Tpl.writeText(out_a_inputAssign, a_tmp);
  out_a_inputAssign := Tpl.writeTok(out_a_inputAssign, Tpl.ST_STRING("); "));
  out_txt := txt;
  out_a_tmp := a_tmp;
end inputAssignTest;

public function outputAssignTest
  input Tpl.Text txt;
  input DAE.ComponentRef a_cref;
  input SimCode.Context a_context;
  input Tpl.Text a_tmp;
  input Tpl.Text a_outputAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_tmp;
  output Tpl.Text out_a_outputAssign;
algorithm
  out_a_outputAssign := Tpl.writeTok(a_outputAssign, Tpl.ST_STRING("convertIntToBool("));
  out_a_outputAssign := Tpl.writeText(out_a_outputAssign, a_tmp);
  out_a_outputAssign := Tpl.writeTok(out_a_outputAssign, Tpl.ST_STRING(","));
  out_a_outputAssign := contextCref2(out_a_outputAssign, a_cref, a_context);
  out_a_outputAssign := Tpl.writeTok(out_a_outputAssign, Tpl.ST_STRING("); "));
  out_txt := txt;
  out_a_tmp := a_tmp;
end outputAssignTest;

protected function fun_397
  input Tpl.Text in_txt;
  input DAE.Type in_mArg;
  input DAE.Exp in_a_exp;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_preExp;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_preExp, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_exp, in_a_context, in_a_preExp, in_a_varDecls, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      DAE.Exp a_exp;
      SimCode.Context a_context;
      Tpl.Text a_preExp;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      DAE.Type ret_1;
      Tpl.Text l_shortTypeStr;

    case ( txt,
           DAE.T_ARRAY(ty = _),
           a_exp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        ret_1 = Expression.typeof(a_exp);
        l_shortTypeStr = expTypeShort(Tpl.emptyTxt, ret_1);
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(").data()"));
      then (txt, a_preExp, a_varDecls);

    case ( txt,
           _,
           a_exp,
           a_context,
           a_preExp,
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        (txt, a_preExp, a_varDecls) = daeExp(txt, a_exp, a_context, a_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
      then (txt, a_preExp, a_varDecls);
  end match;
end fun_397;

public function daeExternalCExp
  input Tpl.Text txt;
  input DAE.Exp a_exp;
  input SimCode.Context a_context;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  DAE.Type ret_0;
algorithm
  ret_0 := Expression.typeof(a_exp);
  (out_txt, out_a_preExp, out_a_varDecls) := fun_397(txt, ret_0, a_exp, a_context, a_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
end daeExternalCExp;

protected function fun_399
  input Tpl.Text in_txt;
  input DAE.Type in_a_ty;
  input DAE.ComponentRef in_a_c;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_ty, in_a_c, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      Tpl.Text a_varDecls;
      DAE.Type i_ty;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_ty,
           a_c,
           a_varDecls )
      equation
        a_varDecls = extType2(a_varDecls, i_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName2(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        txt = extVarName2(txt, a_c);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = ("));
        txt = extType2(txt, i_ty, true, false);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = contextCref2(txt, a_c, SimCode.contextFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, a_varDecls);
  end match;
end fun_399;

protected function fun_400
  input Tpl.Text in_txt;
  input Integer in_a_oi;
  input DAE.ComponentRef in_a_c;
  input DAE.Type in_a_ty;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_oi, in_a_c, in_a_ty, in_a_varDecls)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_c;
      DAE.Type a_ty;
      Tpl.Text a_varDecls;

    case ( txt,
           0,
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_c,
           a_ty,
           a_varDecls )
      equation
        a_varDecls = extType2(a_varDecls, a_ty, true, false);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
        a_varDecls = extVarName2(a_varDecls, a_c);
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(";"));
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_NEW_LINE());
        a_varDecls = Tpl.writeTok(a_varDecls, Tpl.ST_STRING(" "));
      then (txt, a_varDecls);
  end match;
end fun_400;

public function extFunCallVardecl
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_arg;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_arg, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Integer i_oi;
      DAE.ComponentRef i_c;
      DAE.Type i_ty;

    case ( txt,
           SimCode.SIMEXTARG(isInput = true, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_399(txt, i_ty, i_c, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           SimCode.SIMEXTARG(outputIndex = i_oi, isArray = false, type_ = i_ty, cref = i_c),
           a_varDecls )
      equation
        (txt, a_varDecls) = fun_400(txt, i_oi, i_c, i_ty, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls )
      then (txt, a_varDecls);
  end match;
end extFunCallVardecl;

protected function fun_402
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name, in_a_fname, in_a_varAssign, in_a_varDecls)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      Tpl.Text a_varDecls;
      Tpl.Text l_strVar;

    case ( txt,
           false,
           _,
           _,
           _,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "string", a_varDecls);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("//_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING_LIST({
                                                    ";\n",
                                                    "output = "
                                                }, false));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
      then (txt, a_varAssign, a_varDecls);

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("output /*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" */= "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varDecls);
  end match;
end fun_402;

protected function fun_403
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varAssign) :=
  match(in_txt, in_a_instDims, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name, in_a_fname, in_a_varAssign)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;

    case ( txt,
           {},
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("output /*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign);

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ output.assign("));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign);
  end match;
end fun_403;

protected function fun_404
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInits;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign, out_a_varDecls) :=
  match(in_txt, in_a_var, in_a_varInits, in_a_useFlatArrayNotation, in_a_simCode, in_a_fname, in_a_varAssign, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varInits;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_marker;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_STRING(varLst = _), name = i_var_name),
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varAssign, a_varDecls) = fun_402(txt, ret_0, a_useFlatArrayNotation, a_simCode, i_var_name, a_fname, a_varAssign, a_varDecls);
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims),
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        l_marker = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("/* varOutput varInits("));
        a_varInits = Tpl.writeText(a_varInits, l_marker);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(") */ "));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (txt, a_varAssign) = fun_403(txt, i_instDims, a_useFlatArrayNotation, a_simCode, i_var_name, a_fname, a_varAssign);
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           SimCode.FUNCTION_PTR(name = _),
           a_varInits,
           _,
           _,
           _,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("ToDo: Function Ptr assign"));
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           _,
           a_varInits,
           _,
           _,
           _,
           a_varAssign,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("irgendwas"));
      then (txt, a_varInits, a_varAssign, a_varDecls);
  end match;
end fun_404;

protected function fun_405
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name, in_a_fname, in_a_varAssign, in_a_varDecls)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      Tpl.Text a_varDecls;
      Tpl.Text l_strVar;

    case ( txt,
           false,
           _,
           _,
           _,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "string", a_varDecls);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("//_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" = "));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING_LIST({
                                                    ";\n",
                                                    "output = "
                                                }, false));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
      then (txt, a_varAssign, a_varDecls);

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("output /*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(" */= "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varDecls);
  end match;
end fun_405;

protected function fun_406
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varAssign) :=
  match(in_txt, in_a_instDims, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name, in_a_fname, in_a_varAssign)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;

    case ( txt,
           {},
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("output /*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign);

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ output.assign("));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(");"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign);
  end match;
end fun_406;

protected function fun_407
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInits;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign, out_a_varDecls) :=
  match(in_txt, in_a_var, in_a_varInits, in_a_useFlatArrayNotation, in_a_simCode, in_a_fname, in_a_varAssign, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_varInits;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      Tpl.Text a_varDecls;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_marker;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_STRING(varLst = _), name = i_var_name),
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varAssign, a_varDecls) = fun_405(txt, ret_0, a_useFlatArrayNotation, a_simCode, i_var_name, a_fname, a_varAssign, a_varDecls);
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims),
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        l_marker = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("/* varOutput varInits("));
        a_varInits = Tpl.writeText(a_varInits, l_marker);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(") */ "));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        (txt, a_varAssign) = fun_406(txt, i_instDims, a_useFlatArrayNotation, a_simCode, i_var_name, a_fname, a_varAssign);
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           SimCode.FUNCTION_PTR(name = _),
           a_varInits,
           _,
           _,
           _,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("ToDo: Function Ptr assign"));
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           _,
           a_varInits,
           _,
           _,
           _,
           a_varAssign,
           a_varDecls )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("irgendwas"));
      then (txt, a_varInits, a_varAssign, a_varDecls);
  end match;
end fun_407;

protected function fun_408
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varAssign) :=
  match(in_txt, in_a_fn, in_a_var, in_a_varDecls, in_a_varInits, in_a_varAssign, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_var,
           a_varDecls,
           a_varInits,
           a_varAssign,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_varInits, a_varAssign, a_varDecls) = fun_404(txt, a_var, a_varInits, a_useFlatArrayNotation, a_simCode, l_fname, a_varAssign, a_varDecls);
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name),
           a_var,
           a_varDecls,
           a_varInits,
           a_varAssign,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_varInits, a_varAssign, a_varDecls) = fun_407(txt, a_var, a_varInits, a_useFlatArrayNotation, a_simCode, l_fname, a_varAssign, a_varDecls);
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varAssign,
           _,
           _ )
      then (txt, a_varDecls, a_varInits, a_varAssign);
  end match;
end fun_408;

public function varOutput
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input SimCode.Variable a_var;
  input Integer a_ix;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varInits;
  input Tpl.Text a_varCopy;
  input Tpl.Text a_varAssign;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varAssign) := fun_408(txt, a_fn, a_var, a_varDecls, a_varInits, a_varAssign, a_simCode, a_useFlatArrayNotation);
  out_a_varCopy := a_varCopy;
end varOutput;

protected function fun_410
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name, in_a_fname, in_a_varAssign, in_a_varDecls)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      Tpl.Text a_varDecls;
      Tpl.Text l_strVar;

    case ( txt,
           false,
           _,
           _,
           _,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "string", a_varDecls);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ output = "));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
      then (txt, a_varAssign, a_varDecls);

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ output= "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varDecls);
  end match;
end fun_410;

protected function lm_411
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_411(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_411;

protected function fun_412
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varInits;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_assginBegin;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_varInits, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name, in_a_fname, in_a_assginBegin, in_a_varAssign)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varInits;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_fname;
      Tpl.Text a_assginBegin;
      Tpl.Text a_varAssign;

    case ( txt,
           {},
           _,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_assginBegin,
           a_varAssign )
      equation
        a_varAssign = Tpl.pushBlock(a_varAssign, Tpl.BT_INDENT(1));
        a_varAssign = Tpl.writeText(a_varAssign, a_assginBegin);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("(/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/output.data) = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.popBlock(a_varAssign);
      then (txt, a_varInits, a_varAssign);

    case ( txt,
           _,
           a_instDimsInit,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_assginBegin,
           a_varAssign )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_assginBegin);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("(/*_"));
        a_varInits = Tpl.writeText(a_varInits, a_fname);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("*/output.data).setDims("));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_LINE(");//todo setDims not for stat arrays\n"));
        a_varInits = Tpl.pushBlock(a_varInits, Tpl.BT_INDENT(4));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.popBlock(a_varInits);
        a_varAssign = Tpl.writeText(a_varAssign, a_assginBegin);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("(/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/output.data)="));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign);
  end match;
end fun_412;

protected function fun_413
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_ix;
  input Tpl.Text in_a_varInits;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign, out_a_varDecls) :=
  match(in_txt, in_a_var, in_a_ix, in_a_varInits, in_a_useFlatArrayNotation, in_a_simCode, in_a_fname, in_a_varAssign, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_ix;
      Tpl.Text a_varInits;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      Tpl.Text a_varDecls;
      String i_var_name_1;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_assginBegin;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_marker;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_STRING(varLst = _), name = i_var_name),
           _,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varAssign, a_varDecls) = fun_410(txt, ret_0, a_useFlatArrayNotation, a_simCode, i_var_name, a_fname, a_varAssign, a_varDecls);
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims),
           a_ix,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        l_marker = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("/* varOutputTuple varInits("));
        a_varInits = Tpl.writeText(a_varInits, l_marker);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(") */ "));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("// varOutput varAssign("));
        a_varAssign = Tpl.writeText(a_varAssign, l_marker);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(") "));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_411(l_instDimsInit, i_instDims, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        l_assginBegin = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("boost::get<"));
        l_assginBegin = Tpl.writeStr(l_assginBegin, intString(a_ix));
        l_assginBegin = Tpl.writeTok(l_assginBegin, Tpl.ST_STRING(">"));
        (txt, a_varInits, a_varAssign) = fun_412(txt, i_instDims, l_instDimsInit, a_varInits, a_useFlatArrayNotation, a_simCode, i_var_name, a_fname, l_assginBegin, a_varAssign);
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           _,
           a_varInits,
           _,
           _,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ output = (modelica_fnptr) _"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           _,
           _,
           _,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*iregendwas*/"));
      then (txt, a_varInits, a_varAssign, a_varDecls);
  end match;
end fun_413;

protected function fun_414
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varAssign, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name, in_a_fname, in_a_varAssign, in_a_varDecls)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      Tpl.Text a_varDecls;
      Tpl.Text l_strVar;

    case ( txt,
           false,
           _,
           _,
           _,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        (l_strVar, a_varDecls) = tempDecl(Tpl.emptyTxt, "string", a_varDecls);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ output = "));
        a_varAssign = Tpl.writeText(a_varAssign, l_strVar);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
      then (txt, a_varAssign, a_varDecls);

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ output= "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varAssign, a_varDecls);
  end match;
end fun_414;

protected function lm_415
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_415(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_415;

protected function fun_416
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varInits;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_assginBegin;
  input Tpl.Text in_a_varAssign;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign) :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_varInits, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name, in_a_fname, in_a_assginBegin, in_a_varAssign)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varInits;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Tpl.Text a_fname;
      Tpl.Text a_assginBegin;
      Tpl.Text a_varAssign;

    case ( txt,
           {},
           _,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_assginBegin,
           a_varAssign )
      equation
        a_varAssign = Tpl.pushBlock(a_varAssign, Tpl.BT_INDENT(1));
        a_varAssign = Tpl.writeText(a_varAssign, a_assginBegin);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("(/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/output.data) = "));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.popBlock(a_varAssign);
      then (txt, a_varInits, a_varAssign);

    case ( txt,
           _,
           a_instDimsInit,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_fname,
           a_assginBegin,
           a_varAssign )
      equation
        a_varInits = Tpl.writeText(a_varInits, a_assginBegin);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("(/*_"));
        a_varInits = Tpl.writeText(a_varInits, a_fname);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("*/output.data).setDims("));
        a_varInits = Tpl.writeText(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_LINE(");//todo setDims not for stat arrays\n"));
        a_varInits = Tpl.pushBlock(a_varInits, Tpl.BT_INDENT(4));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.popBlock(a_varInits);
        a_varAssign = Tpl.writeText(a_varAssign, a_assginBegin);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("(/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/output.data)="));
        a_varAssign = contextCref(a_varAssign, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign);
  end match;
end fun_416;

protected function fun_417
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Integer in_a_ix;
  input Tpl.Text in_a_varInits;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_fname;
  input Tpl.Text in_a_varAssign;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varAssign, out_a_varDecls) :=
  match(in_txt, in_a_var, in_a_ix, in_a_varInits, in_a_useFlatArrayNotation, in_a_simCode, in_a_fname, in_a_varAssign, in_a_varDecls)
    local
      Tpl.Text txt;
      Integer a_ix;
      Tpl.Text a_varInits;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_fname;
      Tpl.Text a_varAssign;
      Tpl.Text a_varDecls;
      String i_var_name_1;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_assginBegin;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_marker;
      Boolean ret_0;

    case ( txt,
           SimCode.VARIABLE(ty = DAE.T_STRING(varLst = _), name = i_var_name),
           _,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        ret_0 = Config.acceptMetaModelicaGrammar();
        (txt, a_varAssign, a_varDecls) = fun_414(txt, ret_0, a_useFlatArrayNotation, a_simCode, i_var_name, a_fname, a_varAssign, a_varDecls);
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           SimCode.VARIABLE(name = i_var_name, instDims = i_instDims),
           a_ix,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        l_marker = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING("/* varOutputTuple varInits("));
        a_varInits = Tpl.writeText(a_varInits, l_marker);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(") */ "));
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_NEW_LINE());
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("// varOutput varAssign("));
        a_varAssign = Tpl.writeText(a_varAssign, l_marker);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(") "));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_415(l_instDimsInit, i_instDims, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        l_assginBegin = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("boost::get<"));
        l_assginBegin = Tpl.writeStr(l_assginBegin, intString(a_ix));
        l_assginBegin = Tpl.writeTok(l_assginBegin, Tpl.ST_STRING(">"));
        (txt, a_varInits, a_varAssign) = fun_416(txt, i_instDims, l_instDimsInit, a_varInits, a_useFlatArrayNotation, a_simCode, i_var_name, a_fname, l_assginBegin, a_varAssign);
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_var_name_1),
           _,
           a_varInits,
           _,
           _,
           a_fname,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*_"));
        a_varAssign = Tpl.writeText(a_varAssign, a_fname);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("*/ output = (modelica_fnptr) _"));
        a_varAssign = Tpl.writeStr(a_varAssign, i_var_name_1);
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING(";"));
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_NEW_LINE());
      then (txt, a_varInits, a_varAssign, a_varDecls);

    case ( txt,
           _,
           _,
           a_varInits,
           _,
           _,
           _,
           a_varAssign,
           a_varDecls )
      equation
        a_varAssign = Tpl.writeTok(a_varAssign, Tpl.ST_STRING("/*iregendwas*/"));
      then (txt, a_varInits, a_varAssign, a_varDecls);
  end match;
end fun_417;

protected function fun_418
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;
  input SimCode.Variable in_a_var;
  input Integer in_a_ix;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varAssign;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varAssign) :=
  match(in_txt, in_a_fn, in_a_var, in_a_ix, in_a_varDecls, in_a_varInits, in_a_varAssign, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.Variable a_var;
      Integer a_ix;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Tpl.Text a_varAssign;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Absyn.Path i_name;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.FUNCTION(name = i_name),
           a_var,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varAssign,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_varInits, a_varAssign, a_varDecls) = fun_413(txt, a_var, a_ix, a_varInits, a_useFlatArrayNotation, a_simCode, l_fname, a_varAssign, a_varDecls);
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name),
           a_var,
           a_ix,
           a_varDecls,
           a_varInits,
           a_varAssign,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_fname = CodegenUtil.underscorePath(Tpl.emptyTxt, i_name);
        (txt, a_varInits, a_varAssign, a_varDecls) = fun_417(txt, a_var, a_ix, a_varInits, a_useFlatArrayNotation, a_simCode, l_fname, a_varAssign, a_varDecls);
      then (txt, a_varDecls, a_varInits, a_varAssign);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_varAssign,
           _,
           _ )
      then (txt, a_varDecls, a_varInits, a_varAssign);
  end match;
end fun_418;

public function varOutputTuple
  input Tpl.Text txt;
  input SimCode.Function a_fn;
  input SimCode.Variable a_var;
  input Integer a_ix;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varInits;
  input Tpl.Text a_varCopy;
  input Tpl.Text a_varAssign;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varCopy;
  output Tpl.Text out_a_varAssign;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits, out_a_varAssign) := fun_418(txt, a_fn, a_var, a_ix, a_varDecls, a_varInits, a_varAssign, a_simCode, a_useFlatArrayNotation);
  out_a_varCopy := a_varCopy;
end varOutputTuple;

protected function lm_420
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_420(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_420;

protected function fun_421
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "modelica_metatype" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = NULL"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_421;

protected function fun_422
  input Tpl.Text in_txt;
  input String in_mArg;
  input String in_a_varName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName)
    local
      Tpl.Text txt;
      String a_varName;

    case ( txt,
           "modelica_metatype",
           a_varName )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmc_GC_add_root(&"));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", mmc_GC_local_state, \""));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_422;

protected function lm_423
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = testDaeDimensionExp(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_423(txt, rest);
      then txt;
  end match;
end lm_423;

protected function lm_424
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_424(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_424;

protected function fun_425
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_addRoot;
  input Tpl.Text in_a_initVar;
  input String in_a_varName;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_ty, in_a_addRoot, in_a_initVar, in_a_varName, in_a_type)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      Tpl.Text a_addRoot;
      Tpl.Text a_initVar;
      String a_varName;
      Tpl.Text a_type;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           a_addRoot,
           a_initVar,
           a_varName,
           a_type )
      equation
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeText(txt, a_initVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_addRoot);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_ty,
           _,
           _,
           a_varName,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StatArrayDim"));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, a_instDimsInit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_425;

protected function fun_426
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;
  input Tpl.Text in_a_addRoot;
  input Tpl.Text in_a_initVar;
  input String in_a_varName;
  input Tpl.Text in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_ty, in_a_addRoot, in_a_initVar, in_a_varName, in_a_type)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      Tpl.Text a_addRoot;
      Tpl.Text a_initVar;
      String a_varName;
      Tpl.Text a_type;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_addRoot,
           a_initVar,
           a_varName,
           a_type )
      equation
        txt = Tpl.writeText(txt, a_type);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeText(txt, a_initVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeText(txt, a_addRoot);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           i_instDims,
           a_var_ty,
           _,
           _,
           a_varName,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DynArrayDim"));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
        txt = Tpl.writeStr(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;
  end match;
end fun_426;

protected function fun_427
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_arrayexpression2;
  input Tpl.Text in_a_arrayexpression1;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_mArg, in_a_arrayexpression2, in_a_arrayexpression1, in_a_varDecls)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayexpression2;
      Tpl.Text a_arrayexpression1;
      Tpl.Text a_varDecls;

    case ( txt,
           "",
           _,
           a_arrayexpression1,
           a_varDecls )
      equation
        a_varDecls = Tpl.writeText(a_varDecls, a_arrayexpression1);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_arrayexpression2,
           _,
           a_varDecls )
      equation
        a_varDecls = Tpl.writeText(a_varDecls, a_arrayexpression2);
      then (txt, a_varDecls);
  end match;
end fun_427;

protected function fun_428
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input String in_a_varName;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_varInits, in_a_varName)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      String a_varName;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;
      SimCode.Variable i_var;
      String str_9;
      Tpl.Text l_arrayexpression2;
      Tpl.Text l_arrayexpression1;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_testinstDimsInit;
      String str_4;
      Tpl.Text l_addRoot;
      String str_2;
      Tpl.Text l_initVar;
      Tpl.Text l_type;

    case ( txt,
           (i_var as SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty)),
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_varInits,
           a_varName )
      equation
        l_type = varType(Tpl.emptyTxt, i_var);
        str_2 = Tpl.textString(l_type);
        l_initVar = fun_421(Tpl.emptyTxt, str_2);
        str_4 = Tpl.textString(l_type);
        l_addRoot = fun_422(Tpl.emptyTxt, str_4, a_varName);
        l_testinstDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_testinstDimsInit = lm_423(l_testinstDimsInit, i_instDims);
        l_testinstDimsInit = Tpl.popIter(l_testinstDimsInit);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_424(l_instDimsInit, i_instDims, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        l_arrayexpression1 = fun_425(Tpl.emptyTxt, i_instDims, l_instDimsInit, i_var_ty, l_addRoot, l_initVar, a_varName, l_type);
        l_arrayexpression2 = fun_426(Tpl.emptyTxt, i_instDims, i_var_ty, l_addRoot, l_initVar, a_varName, l_type);
        str_9 = Tpl.textString(l_testinstDimsInit);
        (txt, a_varDecls) = fun_427(txt, str_9, l_arrayexpression2, l_arrayexpression1, a_varDecls);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_428;

public function varDeclForVarInit
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input String a_varName;
  input list<DAE.Exp> a_instDims;
  input Tpl.Text a_varDecls;
  input Tpl.Text a_varInits;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
protected
  Tpl.Text l_instDimsInit;
algorithm
  l_instDimsInit := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_instDimsInit, out_a_varDecls, out_a_varInits) := lm_420(l_instDimsInit, a_instDims, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
  l_instDimsInit := Tpl.popIter(l_instDimsInit);
  (out_txt, out_a_varDecls, out_a_varInits) := fun_428(txt, a_var, a_useFlatArrayNotation, a_simCode, out_a_varDecls, out_a_varInits, a_varName);
end varDeclForVarInit;

protected function lm_430
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_430(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_430;

protected function fun_431
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var_value, in_a_varDecls, in_a_varInits, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_varDecls,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name )
      equation
        l_defaultValue = contextCref(Tpl.emptyTxt, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(" = "));
        (l_defaultValue, a_varInits, a_varDecls) = daeExp(l_defaultValue, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode, a_useFlatArrayNotation);
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_STRING(";"));
        l_defaultValue = Tpl.writeTok(l_defaultValue, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           a_varDecls,
           a_varInits,
           _,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_431;

protected function lm_432
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = testDaeDimensionExp(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_432(txt, rest);
      then txt;
  end match;
end lm_432;

protected function fun_433
  input Tpl.Text in_txt;
  input String in_a_outStruct;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_outStruct, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;

    case ( txt,
           "",
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name )
      equation
        txt = contextCref(txt, a_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name )
      equation
        txt = extVarName(txt, a_var_name, a_simCode, a_useFlatArrayNotation);
      then txt;
  end match;
end fun_433;

protected function fun_434
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_var_value;
  input DAE.ComponentRef in_a_var_name;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varInits;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varName;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varInits, out_a_varDecls) :=
  match(in_txt, in_a_var_value, in_a_var_name, in_a_useFlatArrayNotation, in_a_simCode, in_a_varInits, in_a_varDecls, in_a_varName, in_a_i, in_a_outStruct, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_name;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varInits;
      Tpl.Text a_varDecls;
      Tpl.Text a_varName;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      DAE.Exp i_exp;
      Tpl.Text l_defaultValue1;
      Tpl.Text l_var__name;
      Tpl.Text l_defaultValue;

    case ( txt,
           SOME(i_exp),
           a_var_name,
           a_useFlatArrayNotation,
           a_simCode,
           a_varInits,
           a_varDecls,
           a_varName,
           a_i,
           a_outStruct,
           a_var )
      equation
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits, a_simCode, a_useFlatArrayNotation);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
        l_var__name = fun_433(Tpl.emptyTxt, a_outStruct, a_useFlatArrayNotation, a_simCode, a_var_name);
        l_defaultValue1 = Tpl.writeText(Tpl.emptyTxt, l_var__name);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(".assign("));
        (l_defaultValue1, a_varInits, a_varDecls) = daeExp(l_defaultValue1, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode, a_useFlatArrayNotation);
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_STRING(");"));
        l_defaultValue1 = Tpl.writeTok(l_defaultValue1, Tpl.ST_NEW_LINE());
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue1);
      then (txt, a_varInits, a_varDecls);

    case ( txt,
           _,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_varInits,
           a_varDecls,
           a_varName,
           a_i,
           a_outStruct,
           a_var )
      equation
        (l_defaultValue, a_varDecls, a_varInits) = varDefaultValue(Tpl.emptyTxt, a_var, a_outStruct, a_i, Tpl.textString(a_varName), a_varDecls, a_varInits, a_simCode, a_useFlatArrayNotation);
        a_varInits = Tpl.writeText(a_varInits, l_defaultValue);
      then (txt, a_varInits, a_varDecls);
  end match;
end fun_434;

protected function fun_435
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Integer in_a_i;
  input String in_a_outStruct;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_instDimsInit;
  input Tpl.Text in_a_varName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input DAE.ComponentRef in_a_var_name;
  input Option<DAE.Exp> in_a_var_value;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_instDims, in_a_i, in_a_outStruct, in_a_var, in_a_instDimsInit, in_a_varName, in_a_varDecls, in_a_varInits, in_a_useFlatArrayNotation, in_a_simCode, in_a_var_name, in_a_var_value)
    local
      Tpl.Text txt;
      Integer a_i;
      String a_outStruct;
      SimCode.Variable a_var;
      Tpl.Text a_instDimsInit;
      Tpl.Text a_varName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.ComponentRef a_var_name;
      Option<DAE.Exp> a_var_value;
      list<DAE.Exp> i_instDims;
      Tpl.Text l_temp;
      Tpl.Text l_testinstDimsInit;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_var_value )
      equation
        (txt, a_varDecls, a_varInits) = fun_431(txt, a_var_value, a_varDecls, a_varInits, a_useFlatArrayNotation, a_simCode, a_var_name);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_instDims,
           a_i,
           a_outStruct,
           a_var,
           a_instDimsInit,
           a_varName,
           a_varDecls,
           a_varInits,
           a_useFlatArrayNotation,
           a_simCode,
           a_var_name,
           a_var_value )
      equation
        l_testinstDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_testinstDimsInit = lm_432(l_testinstDimsInit, i_instDims);
        l_testinstDimsInit = Tpl.popIter(l_testinstDimsInit);
        (l_temp, l_testinstDimsInit, a_varInits) = setDims(Tpl.emptyTxt, l_testinstDimsInit, Tpl.textString(a_varName), a_varInits, Tpl.textString(a_instDimsInit));
        (txt, a_varInits, a_varDecls) = fun_434(txt, a_var_value, a_var_name, a_useFlatArrayNotation, a_simCode, a_varInits, a_varDecls, a_varName, a_i, a_outStruct, a_var);
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_435;

public function varInit
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_varDecls, in_a_varInits, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Option<DAE.Exp> i_var_value;
      SimCode.Variable i_var;
      list<DAE.Exp> i_instDims;
      DAE.ComponentRef i_var_name;
      Tpl.Text l_ignore;
      Tpl.Text l_0__;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_varName;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_var_name, instDims = i_instDims, value = i_var_value)),
           a_outStruct,
           a_i,
           a_varDecls,
           a_varInits,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_varName = contextCref(Tpl.emptyTxt, i_var_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, a_varDecls, a_varInits) = lm_430(l_instDimsInit, i_instDims, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        (l_0__, a_varDecls, a_varInits) = varDeclForVarInit(Tpl.emptyTxt, i_var, Tpl.textString(l_varName), i_instDims, a_varDecls, a_varInits, a_simCode, a_useFlatArrayNotation);
        (txt, a_varDecls, a_varInits) = fun_435(txt, i_instDims, a_i, a_outStruct, i_var, l_instDimsInit, l_varName, a_varDecls, a_varInits, a_useFlatArrayNotation, a_simCode, i_var_name, i_var_value);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           (i_var as SimCode.FUNCTION_PTR(name = _)),
           _,
           _,
           a_varDecls,
           a_varInits,
           _,
           _ )
      equation
        l_ignore = Tpl.emptyTxt;
        (a_varDecls, l_ignore) = functionArg(a_varDecls, i_var, l_ignore);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end varInit;

protected function fun_437
  input Tpl.Text in_txt;
  input String in_mArg;
  input String in_a_varName;
  input Tpl.Text in_a_varInits;
  input String in_a_instDimsInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varInits) :=
  match(in_txt, in_mArg, in_a_varName, in_a_varInits, in_a_instDimsInit)
    local
      Tpl.Text txt;
      String a_varName;
      Tpl.Text a_varInits;
      String a_instDimsInit;

    case ( txt,
           "",
           _,
           a_varInits,
           _ )
      then (txt, a_varInits);

    case ( txt,
           _,
           a_varName,
           a_varInits,
           a_instDimsInit )
      equation
        a_varInits = Tpl.writeStr(a_varInits, a_varName);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(".setDims("));
        a_varInits = Tpl.writeStr(a_varInits, a_instDimsInit);
        a_varInits = Tpl.writeTok(a_varInits, Tpl.ST_STRING(");/*setDims 1*/"));
      then (txt, a_varInits);
  end match;
end fun_437;

public function setDims
  input Tpl.Text txt;
  input Tpl.Text a_testinstDimsInit;
  input String a_varName;
  input Tpl.Text a_varInits;
  input String a_instDimsInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_testinstDimsInit;
  output Tpl.Text out_a_varInits;
protected
  String str_0;
algorithm
  str_0 := Tpl.textString(a_testinstDimsInit);
  (out_txt, out_a_varInits) := fun_437(txt, str_0, a_varName, a_varInits, a_instDimsInit);
  out_a_testinstDimsInit := a_testinstDimsInit;
end setDims;

protected function lm_439
  input Tpl.Text in_txt;
  input list<SimCode.Variable> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Variable> rest;
      SimCode.Variable i_arg;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_arg :: rest )
      equation
        txt = mmcVarType(txt, i_arg);
        txt = Tpl.nextIter(txt);
        txt = lm_439(txt, rest);
      then txt;
  end match;
end lm_439;

protected function lm_440
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;
  input Tpl.Text in_a_rettype;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_rettype)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      Tpl.Text a_rettype;
      Integer x_i1;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_rettype )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targTest2"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.nextIter(txt);
        txt = lm_440(txt, rest, a_rettype);
      then txt;
  end match;
end lm_440;

protected function lm_441
  input Tpl.Text in_txt;
  input list<DAE.Type> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Type> rest;
      Integer x_i1;
      DAE.Type i_ty;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_ty :: rest )
      equation
        x_i1 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcTypeShort(txt, i_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" targTest1"));
        txt = Tpl.writeStr(txt, intString(x_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_441(txt, rest);
      then txt;
  end match;
end lm_441;

protected function fun_442
  input Tpl.Text in_txt;
  input list<DAE.Type> in_a_tys;
  input Tpl.Text in_a_rettype;
  input Tpl.Text in_a_typelist;
  input String in_a_name;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  match(in_txt, in_a_tys, in_a_rettype, in_a_typelist, in_a_name, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_rettype;
      Tpl.Text a_typelist;
      String a_name;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;

    case ( txt,
           {},
           _,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = (void(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);

    case ( txt,
           i_tys,
           a_rettype,
           a_typelist,
           a_name,
           a_varInit )
      equation
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("_"));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(" = ("));
        a_varInit = Tpl.writeText(a_varInit, a_rettype);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING("(*)("));
        a_varInit = Tpl.writeText(a_varInit, a_typelist);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(")) "));
        a_varInit = Tpl.writeStr(a_varInit, a_name);
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_STRING(";"));
        a_varInit = Tpl.writeTok(a_varInit, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_440(txt, i_tys, a_rettype);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("typedef struct "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_s\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_441(txt, i_tys);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} "));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, a_rettype);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*_"));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")("));
        txt = Tpl.writeText(txt, a_typelist);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varInit);
  end match;
end fun_442;

public function functionArg
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input Tpl.Text in_a_varInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varInit;
algorithm
  (out_txt, out_a_varInit) :=
  match(in_txt, in_a_var, in_a_varInit)
    local
      Tpl.Text txt;
      Tpl.Text a_varInit;
      list<DAE.Type> i_tys;
      String i_name;
      list<SimCode.Variable> i_args;
      Tpl.Text l_rettype;
      Tpl.Text l_typelist;

    case ( txt,
           SimCode.FUNCTION_PTR(args = i_args, name = i_name, tys = i_tys),
           a_varInit )
      equation
        l_typelist = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_typelist = lm_439(l_typelist, i_args);
        l_typelist = Tpl.popIter(l_typelist);
        l_rettype = Tpl.writeStr(Tpl.emptyTxt, i_name);
        l_rettype = Tpl.writeTok(l_rettype, Tpl.ST_STRING("RetType /* functionArg */"));
        (txt, a_varInit) = fun_442(txt, i_tys, l_rettype, l_typelist, i_name, a_varInit);
      then (txt, a_varInit);

    case ( txt,
           _,
           a_varInit )
      then (txt, a_varInit);
  end match;
end functionArg;

public function mmcVarType
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_ty;

    case ( txt,
           SimCode.VARIABLE(ty = i_ty) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_"));
        txt = mmcTypeShort(txt, i_ty);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end mmcVarType;

public function mmcTypeShort
  input Tpl.Text in_txt;
  input DAE.Type in_a_type;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.T_INTEGER(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("real"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("integer"));
      then txt;

    case ( txt,
           DAE.T_ARRAY(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("array"));
      then txt;

    case ( txt,
           DAE.T_METATYPE(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_METABOXED(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("metatype"));
      then txt;

    case ( txt,
           DAE.T_FUNCTION_REFERENCE_VAR(functionType = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fnptr"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mmcTypeShort:ERROR"));
      then txt;
  end match;
end mmcTypeShort;

public function extVarName
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := contextCref(txt, a_cr, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_ext"));
end extVarName;

public function extVarName2
  input Tpl.Text txt;
  input DAE.ComponentRef a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt := contextCref2(txt, a_cr, SimCode.contextFunction);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_ext"));
end extVarName2;

protected function fun_448
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_value;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input Integer in_a_i;
  input String in_a_outStruct;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_value, in_a_lhsVarName, in_a_varDecls, in_a_varInits, in_a_i, in_a_outStruct, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      Integer a_i;
      String a_outStruct;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.Exp i_arr;
      DAE.ComponentRef i_cr;
      Tpl.Text l_arrayExp;

    case ( txt,
           SOME(DAE.CREF(componentRef = i_cr)),
           _,
           a_varDecls,
           a_varInits,
           a_i,
           a_outStruct,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = contextCref(txt, i_cr, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" =  "));
        txt = Tpl.writeStr(txt, a_outStruct);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".targTest9"));
        txt = Tpl.writeStr(txt, intString(a_i));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           SOME((i_arr as DAE.ARRAY(ty = _))),
           a_lhsVarName,
           a_varDecls,
           a_varInits,
           _,
           _,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        (l_arrayExp, a_varInits, a_varDecls) = daeExp(Tpl.emptyTxt, i_arr, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeStr(txt, a_lhsVarName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_arrayExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           a_varDecls,
           a_varInits,
           _,
           _,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end fun_448;

public function varDefaultValue
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input String in_a_outStruct;
  input Integer in_a_i;
  input String in_a_lhsVarName;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_a_var, in_a_outStruct, in_a_i, in_a_lhsVarName, in_a_varDecls, in_a_varInits, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      String a_outStruct;
      Integer a_i;
      String a_lhsVarName;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      Option<DAE.Exp> i_value;

    case ( txt,
           SimCode.VARIABLE(value = i_value),
           a_outStruct,
           a_i,
           a_lhsVarName,
           a_varDecls,
           a_varInits,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        (txt, a_varDecls, a_varInits) = fun_448(txt, i_value, a_lhsVarName, a_varDecls, a_varInits, a_i, a_outStruct, a_useFlatArrayNotation, a_simCode);
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           _,
           _,
           _,
           _,
           a_varDecls,
           a_varInits,
           _,
           _ )
      then (txt, a_varDecls, a_varInits);
  end match;
end varDefaultValue;

public function funArgDefinition
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        txt = varType1(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /*test1*/"));
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end funArgDefinition;

public function funArgDefinition2
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      String i_name_1;
      DAE.ComponentRef i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = i_name)),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        txt = varType3(txt, i_var, a_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = contextCref(txt, i_name, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name_1),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end funArgDefinition2;

public function funExtArgDefinition
  input Tpl.Text in_txt;
  input SimCode.SimExtArg in_a_extArg;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extArg, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      DAE.Type i_type__;
      DAE.Type i_t;
      DAE.ComponentRef i_c;
      Tpl.Text l_typeStr;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMEXTARG(cref = i_c, isInput = _, isArray = _, type_ = i_t),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_name = contextCref(Tpl.emptyTxt, i_c, SimCode.contextFunction, a_simCode, a_useFlatArrayNotation);
        l_typeStr = expTypeFlag(Tpl.emptyTxt, i_t, 5);
        txt = Tpl.writeText(txt, l_typeStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_name);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGEXP(type_ = i_type__),
           _,
           _ )
      equation
        l_typeStr = expTypeFlag(Tpl.emptyTxt, i_type__, 5);
        txt = Tpl.writeText(txt, l_typeStr);
      then txt;

    case ( txt,
           SimCode.SIMEXTARGSIZE(cref = _),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("size_t"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end funExtArgDefinition;

public function funReturnDefinition1
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      String i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_simCode )
      equation
        txt = varType3(txt, i_var, a_simCode);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end funReturnDefinition1;

public function funReturnDefinition2
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      String i_name;
      SimCode.Variable i_var;

    case ( txt,
           (i_var as SimCode.VARIABLE(name = _)),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        txt = varType2(txt, i_var, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           SimCode.FUNCTION_PTR(name = i_name),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelica_fnptr "));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end funReturnDefinition2;

protected function fun_455
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeArrayIf(txt, a_var_ty);
      then txt;

    case ( txt,
           _,
           a_var_ty )
      equation
        txt = expTypeArray(txt, a_var_ty);
      then txt;
  end match;
end fun_455;

public function varType
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty) )
      equation
        txt = fun_455(txt, i_instDims, i_var_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end varType;

protected function fun_457
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_ty;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_ty, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_ty;
      DAE.Type a_var_ty;

    case ( txt,
           {},
           _,
           a_var_ty )
      equation
        txt = expTypeFlag(txt, a_var_ty, 8);
      then txt;

    case ( txt,
           _,
           a_ty,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("BaseArray<"));
        txt = expTypeShort(txt, a_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">&"));
      then txt;
  end match;
end fun_457;

protected function fun_458
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_ty;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = (i_ty as i_var_ty)) )
      equation
        txt = fun_457(txt, i_instDims, i_ty, i_var_ty);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_458;

public function varType1
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_458(txt, a_var);
end varType1;

protected function lm_460
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = daeDimensionExp(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_460(txt, rest);
      then txt;
  end match;
end lm_460;

protected function lm_461
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_varInits;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_varInits;
algorithm
  (out_txt, out_a_varDecls, out_a_varInits) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_varInits)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_varInits;
      DAE.Exp i_exp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           a_varInits )
      then (txt, a_varDecls, a_varInits);

    case ( txt,
           i_exp :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_varInits )
      equation
        (txt, a_varInits, a_varDecls) = daeExp(txt, i_exp, SimCode.contextFunction, a_varInits, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_varInits) = lm_461(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_varInits);
      then (txt, a_varDecls, a_varInits);
  end match;
end lm_461;

protected function fun_462
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_ty)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_var_ty )
      equation
        txt = expTypeFlag(txt, a_var_ty, 5);
      then txt;

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StatArrayDim"));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_instDimsInit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">& "));
      then txt;
  end match;
end fun_462;

protected function fun_463
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeFlag(txt, a_var_ty, 5);
      then txt;

    case ( txt,
           i_instDims,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DynArrayDim"));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(">&"));
      then txt;
  end match;
end fun_463;

protected function fun_464
  input Tpl.Text in_txt;
  input String in_mArg;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;
  input list<DAE.Exp> in_a_instDims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_instDimsInit, in_a_var_ty, in_a_instDims)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      list<DAE.Exp> a_instDims;

    case ( txt,
           "",
           a_instDimsInit,
           a_var_ty,
           a_instDims )
      equation
        txt = fun_462(txt, a_instDims, a_instDimsInit, a_var_ty);
      then txt;

    case ( txt,
           _,
           _,
           a_var_ty,
           a_instDims )
      equation
        txt = fun_463(txt, a_instDims, a_var_ty);
      then txt;
  end match;
end fun_464;

public function varType2
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;
      String str_4;
      Tpl.Text l_instDimsInit;
      Tpl.Text l_DimsTest;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_DimsTest = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_DimsTest = lm_460(l_DimsTest, i_instDims);
        l_DimsTest = Tpl.popIter(l_DimsTest);
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_instDimsInit, l_varDecls, l_varInits) = lm_461(l_instDimsInit, i_instDims, a_useFlatArrayNotation, a_simCode, l_varDecls, l_varInits);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        str_4 = Tpl.textString(l_DimsTest);
        txt = fun_464(txt, str_4, l_instDimsInit, i_var_ty, i_instDims);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end varType2;

protected function lm_466
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = testDaeDimensionExp(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_466(txt, rest);
      then txt;
  end match;
end lm_466;

protected function lm_467
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = daeDimensionExp(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_467(txt, rest);
      then txt;
  end match;
end lm_467;

protected function fun_468
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input Tpl.Text in_a_instDimsInit;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_instDimsInit, in_a_var_ty)
    local
      Tpl.Text txt;
      Tpl.Text a_instDimsInit;
      DAE.Type a_var_ty;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           _,
           a_var_ty )
      equation
        txt = expTypeFlag(txt, a_var_ty, 6);
      then txt;

    case ( txt,
           i_instDims,
           a_instDimsInit,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StatArrayDim"));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("< "));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, a_instDimsInit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
      then txt;
  end match;
end fun_468;

protected function fun_469
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_a_instDims;
  input DAE.Type in_a_var_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_instDims, in_a_var_ty)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      list<DAE.Exp> i_instDims;
      Integer ret_0;

    case ( txt,
           {},
           a_var_ty )
      equation
        txt = expTypeFlag(txt, a_var_ty, 6);
      then txt;

    case ( txt,
           i_instDims,
           a_var_ty )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DynArrayDim"));
        ret_0 = listLength(i_instDims);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<"));
        txt = expTypeShort(txt, a_var_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("> "));
      then txt;
  end match;
end fun_469;

protected function fun_470
  input Tpl.Text in_txt;
  input String in_mArg;
  input DAE.Type in_a_var_ty;
  input list<DAE.Exp> in_a_instDims;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_var_ty, in_a_instDims)
    local
      Tpl.Text txt;
      DAE.Type a_var_ty;
      list<DAE.Exp> a_instDims;
      Tpl.Text l_instDimsInit;

    case ( txt,
           "",
           a_var_ty,
           a_instDims )
      equation
        l_instDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_instDimsInit = lm_467(l_instDimsInit, a_instDims);
        l_instDimsInit = Tpl.popIter(l_instDimsInit);
        txt = fun_468(txt, a_instDims, l_instDimsInit, a_var_ty);
      then txt;

    case ( txt,
           _,
           a_var_ty,
           a_instDims )
      equation
        txt = fun_469(txt, a_instDims, a_var_ty);
      then txt;
  end match;
end fun_470;

protected function fun_471
  input Tpl.Text in_txt;
  input SimCode.Variable in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.Type i_var_ty;
      list<DAE.Exp> i_instDims;
      String str_3;
      Tpl.Text l_testinstDimsInit;
      Tpl.Text l_varInits;
      Tpl.Text l_varDecls;

    case ( txt,
           SimCode.VARIABLE(instDims = i_instDims, ty = i_var_ty) )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_varInits = Tpl.emptyTxt;
        l_testinstDimsInit = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING("")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_testinstDimsInit = lm_466(l_testinstDimsInit, i_instDims);
        l_testinstDimsInit = Tpl.popIter(l_testinstDimsInit);
        str_3 = Tpl.textString(l_testinstDimsInit);
        txt = fun_470(txt, str_3, i_var_ty, i_instDims);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_471;

public function varType3
  input Tpl.Text txt;
  input SimCode.Variable a_var;
  input SimCode.SimCode a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_471(txt, a_var);
end varType3;

protected function lm_473
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      DAE.Statement i_stmt;

    case ( txt,
           {},
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_stmt :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = algStatement(txt, i_stmt, SimCode.contextFunction, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_473(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_473;

public function funStatement
  input Tpl.Text in_txt;
  input SimCode.Statement in_a_stmt;
  input Tpl.Text in_a_varDecls;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_a_stmt, in_a_varDecls, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Tpl.Text a_varDecls;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      list<DAE.Statement> i_statementLst;

    case ( txt,
           SimCode.ALGORITHM(statementLst = i_statementLst),
           a_varDecls,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDecls) = lm_473(txt, i_statementLst, a_useFlatArrayNotation, a_simCode, a_varDecls);
        txt = Tpl.popIter(txt);
      then (txt, a_varDecls);

    case ( txt,
           _,
           a_varDecls,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT IMPLEMENTED FUN STATEMENT"));
      then (txt, a_varDecls);
  end match;
end funStatement;

protected function lm_475
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls, _) = equation_function_call(txt, i_eq, SimCode.contextOther, a_varDecls, a_simCode, Tpl.strTokText(Tpl.ST_STRING("initEquation")));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_475(txt, rest, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_475;

public function init
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.ModelInfo i_modelInfo;
      SimCode.DelayedExpression i_delayedExps;
      list<SimCode.SimEqSystem> i_allEquations;
      Absyn.Path i_modelInfo_name;
      SimCode.ExtObjInfo i_extObjInfo;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_startValueEquations;
      list<SimCode.SimEqSystem> ret_7;
      Tpl.Text l_initextvars;
      Tpl.Text l_initialequations;
      Tpl.Text l_initALgloopSolvers;
      Tpl.Text l_initEventHandling;
      Tpl.Text l_initZeroCrossings;
      Tpl.Text l_initFunctions;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), startValueEquations = i_startValueEquations, zeroCrossings = i_zeroCrossings, odeEquations = i_odeEquations, initialEquations = i_initialEquations, extObjInfo = i_extObjInfo, allEquations = i_allEquations, delayedExps = i_delayedExps)),
           a_useFlatArrayNotation )
      equation
        System.tmpTickReset(0);
        l_varDecls = Tpl.emptyTxt;
        (l_initFunctions, l_varDecls) = functionInitial(Tpl.emptyTxt, i_startValueEquations, l_varDecls, i_simCode, a_useFlatArrayNotation);
        (l_initZeroCrossings, l_varDecls) = functionOnlyZeroCrossing(Tpl.emptyTxt, i_zeroCrossings, l_varDecls, i_simCode);
        l_initEventHandling = eventHandlingInit(Tpl.emptyTxt, i_simCode);
        l_initALgloopSolvers = initAlgloopsolvers(Tpl.emptyTxt, i_odeEquations, i_simCode);
        l_initialequations = functionInitialEquations(Tpl.emptyTxt, i_initialEquations, i_simCode, a_useFlatArrayNotation);
        l_initextvars = functionCallExternalObjectConstructors(Tpl.emptyTxt, i_extObjInfo, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize::initialize()\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        ret_7 = listAppend(i_allEquations, i_initialEquations);
        txt = generateAlgloopsolvers(txt, ret_7, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_simTime = 0.0;\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeText(txt, l_initextvars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " initializeAlgVars();\n",
                                    " initializeDiscreteAlgVars();\n",
                                    " initializeIntAlgVars();\n",
                                    " initializeBoolAlgVars();\n",
                                    " initializeAliasVars();\n",
                                    " initializeIntAliasVars();\n",
                                    " initializeBoolAliasVars();\n",
                                    " initializeParameterVars();\n",
                                    " initializeIntParameterVars();\n",
                                    " initializeBoolParameterVars();\n",
                                    " initializeStateVars();\n",
                                    " initializeDerVars();\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_initFunctions);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//_event_handling.initialize(this,"));
        txt = helpvarlength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",boost::bind(&"));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("::initPreVars, this, _1,_2));\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_event_handling.initialize(this,"));
        txt = helpvarlength(txt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_initEventHandling);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " initEquations();\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_initALgloopSolvers);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  for(int i=0;i<_dimZeroFunc;i++)\n",
                                    "  {\n",
                                    "     getCondition(i);\n",
                                    "  }\n",
                                    "//initialAnalyticJacobian();\n",
                                    "saveAll();\n",
                                    "\n"
                                }, true));
        txt = functionInitDelay(txt, i_delayedExps, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "  }\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize::initEquations()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDecls) = lm_475(txt, i_initialEquations, i_simCode, l_varDecls);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, l_initialequations);
        txt = Tpl.softNewLine(txt);
        txt = init2(txt, i_simCode, i_modelInfo, a_useFlatArrayNotation);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end init;

protected function fun_477
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      Absyn.Path i_modelInfo_name;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;
      Tpl.Text txt_27;
      Tpl.Text l_init12;
      Tpl.Text txt_25;
      Tpl.Text l_init11;
      Tpl.Text txt_23;
      Tpl.Text l_init10;
      Tpl.Text l_init9;
      Tpl.Text l_init8;
      Tpl.Text l_init7;
      Tpl.Text l_init6;
      Tpl.Text l_init5;
      Tpl.Text l_init4;
      Tpl.Text l_init3;
      Tpl.Text l_init2;
      Tpl.Text l_init1;
      Tpl.Text l_varDecls13;
      Tpl.Text l_varDecls12;
      Tpl.Text l_varDecls11;
      Tpl.Text l_varDecls10;
      Tpl.Text l_varDecls9;
      Tpl.Text l_varDecls8;
      Tpl.Text l_varDecls7;
      Tpl.Text l_varDecls6;
      Tpl.Text l_varDecls5;
      Tpl.Text l_varDecls4;
      Tpl.Text l_varDecls3;
      Tpl.Text l_varDecls2;
      Tpl.Text l_varDecls1;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars), name = i_modelInfo_name),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_varDecls1 = Tpl.emptyTxt;
        l_varDecls2 = Tpl.emptyTxt;
        l_varDecls3 = Tpl.emptyTxt;
        l_varDecls4 = Tpl.emptyTxt;
        l_varDecls5 = Tpl.emptyTxt;
        l_varDecls6 = Tpl.emptyTxt;
        l_varDecls7 = Tpl.emptyTxt;
        l_varDecls8 = Tpl.emptyTxt;
        l_varDecls9 = Tpl.emptyTxt;
        l_varDecls10 = Tpl.emptyTxt;
        l_varDecls11 = Tpl.emptyTxt;
        l_varDecls12 = Tpl.emptyTxt;
        l_varDecls13 = Tpl.emptyTxt;
        (l_init1, l_varDecls1, _) = initValst(Tpl.emptyTxt, l_varDecls1, Tpl.strTokText(Tpl.ST_STRING("Real")), i_vars_stateVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        (l_init2, l_varDecls2, _) = initValst(Tpl.emptyTxt, l_varDecls2, Tpl.strTokText(Tpl.ST_STRING("Real")), i_vars_derivativeVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        (l_init3, l_varDecls3, _) = initValst(Tpl.emptyTxt, l_varDecls3, Tpl.strTokText(Tpl.ST_STRING("Real")), i_vars_algVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        (l_init4, l_varDecls4, _) = initValst(Tpl.emptyTxt, l_varDecls4, Tpl.strTokText(Tpl.ST_STRING("Real")), i_vars_discreteAlgVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        (l_init5, l_varDecls5, _) = initValst(Tpl.emptyTxt, l_varDecls5, Tpl.strTokText(Tpl.ST_STRING("Int")), i_vars_intAlgVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        (l_init6, l_varDecls6, _) = initValst(Tpl.emptyTxt, l_varDecls6, Tpl.strTokText(Tpl.ST_STRING("Bool")), i_vars_boolAlgVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        (l_init7, l_varDecls7, _) = initAliasValst(Tpl.emptyTxt, l_varDecls7, Tpl.strTokText(Tpl.ST_STRING("Real")), i_vars_aliasVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        (l_init8, l_varDecls8, _) = initAliasValst(Tpl.emptyTxt, l_varDecls8, Tpl.strTokText(Tpl.ST_STRING("Int")), i_vars_intAliasVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        (l_init9, l_varDecls9, _) = initValst(Tpl.emptyTxt, l_varDecls9, Tpl.strTokText(Tpl.ST_STRING("Bool")), i_vars_boolAliasVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        txt_23 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_23 = Tpl.writeTok(txt_23, Tpl.ST_STRING("Initialize::initializeParameterVars"));
        (l_init10, l_varDecls10, _, txt_23) = initValstWithSplit(Tpl.emptyTxt, l_varDecls10, Tpl.strTokText(Tpl.ST_STRING("Real")), txt_23, i_vars_paramVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        txt_25 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_25 = Tpl.writeTok(txt_25, Tpl.ST_STRING("Initialize::initializeIntParameterVars"));
        (l_init11, l_varDecls11, _, txt_25) = initValstWithSplit(Tpl.emptyTxt, l_varDecls11, Tpl.strTokText(Tpl.ST_STRING("Int")), txt_25, i_vars_intParamVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        txt_27 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_27 = Tpl.writeTok(txt_27, Tpl.ST_STRING("Initialize::initializeBoolParameterVars"));
        (l_init12, l_varDecls12, _, txt_27) = initValstWithSplit(Tpl.emptyTxt, l_varDecls12, Tpl.strTokText(Tpl.ST_STRING("Bool")), txt_27, i_vars_boolParamVars, a_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize::initializeStateVars()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_varDecls1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_init1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize::initializeDerVars()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_varDecls2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_init2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize::initializeAlgVars()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_varDecls3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_init3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize::initializeDiscreteAlgVars()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_varDecls4);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_init4);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize::initializeIntAlgVars()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeText(txt, l_varDecls5);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_init5);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Initialize::initializeBoolAlgVars()\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_varDecls6);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_init6);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Initialize::initializeAliasVars()\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_varDecls7);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_init7);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Initialize::initializeIntAliasVars()\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_varDecls8);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_init8);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" }\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Initialize::initializeBoolAliasVars()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls9);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_init9);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_init10);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_init11);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_init12);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_477;

public function init2
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input SimCode.ModelInfo a_modelInfo;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_477(txt, a_modelInfo, a_simCode, a_useFlatArrayNotation);
end init2;

protected function lm_479
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      DAE.ComponentRef i_var_name;
      DAE.Exp i_exp;
      Tpl.Text l_arg;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls )
      then (txt, a_varDecls);

    case ( txt,
           SimCodeVar.SIMVAR(initialValue = SOME(i_exp), name = i_var_name) :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_arg, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, SimCode.contextOther, l_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_var_name, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, l_arg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_479(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls )
      equation
        (txt, a_varDecls) = lm_479(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls);
      then (txt, a_varDecls);
  end match;
end lm_479;

protected function lm_480
  input Tpl.Text in_txt;
  input list<SimCode.ExtAlias> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCode.ExtAlias> rest;
      Boolean a_useFlatArrayNotation;
      DAE.ComponentRef i_var2;
      DAE.ComponentRef i_var1;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var1, i_var2) :: rest,
           a_useFlatArrayNotation )
      equation
        txt = cref(txt, i_var1, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = cref(txt, i_var2, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_480(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_480;

public function functionCallExternalObjectConstructors
  input Tpl.Text in_txt;
  input SimCode.ExtObjInfo in_a_extObjInfo;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_extObjInfo, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      list<SimCode.ExtAlias> i_aliases;
      list<SimCodeVar.SimVar> i_vars;
      Tpl.Text l_ctorCalls;
      Tpl.Text l_varDecls;
      Tpl.Text l_funDecls;

    case ( txt,
           SimCode.EXTOBJINFO(vars = i_vars, aliases = i_aliases),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_funDecls = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_ctorCalls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_ctorCalls, l_varDecls) = lm_479(l_ctorCalls, i_vars, a_useFlatArrayNotation, a_simCode, l_varDecls);
        l_ctorCalls = Tpl.popIter(l_ctorCalls);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_ctorCalls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_480(txt, i_aliases, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end functionCallExternalObjectConstructors;

protected function lm_482
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        (txt, _, _) = equation_function_create_single_func(txt, i_eq, SimCode.contextOther, a_simCode, Tpl.strTokText(Tpl.ST_STRING("initEquation")), Tpl.strTokText(Tpl.ST_STRING("Initialize")), a_useFlatArrayNotation, true, true);
        txt = Tpl.nextIter(txt);
        txt = lm_482(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_482;

public function functionInitialEquations
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_initalEquations;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_equation__func__calls;
algorithm
  l_equation__func__calls := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_equation__func__calls := lm_482(l_equation__func__calls, a_initalEquations, a_useFlatArrayNotation, a_simCode);
  l_equation__func__calls := Tpl.popIter(l_equation__func__calls);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeText(out_txt, l_equation__func__calls);
  out_txt := Tpl.popBlock(out_txt);
end functionInitialEquations;

protected function fun_484
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_useFlatArrayNotation, in_a_context, in_a_simCode, in_a_modelname)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_useFlatArrayNotation,
           a_context,
           a_simCode,
           a_modelname )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::initialize()\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = initAlgloopEquation(txt, i_eq, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "AlgLoopDefaultImplementation::initialize();\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "   // Update the equations once before start of simulation\n",
                                    "   evaluate();\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           _,
           _,
           _,
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::initialize()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = alocateLinearSystem(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("if(_useSparseFormat)\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("::initialize(__Asparse);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "else\n",
                                    "{\n",
                                    "  fill_array(*__A,0.0);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("::initialize(__A);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_484;

public function initAlgloop
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eq,
           a_context,
           a_useFlatArrayNotation )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_484(txt, a_eq, a_useFlatArrayNotation, a_context, i_simCode, l_modelname);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end initAlgloop;

protected function fun_486
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_useFlatArrayNotation, in_a_context, in_a_simCode, in_a_modelname)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_useFlatArrayNotation,
           a_context,
           a_simCode,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  template <typename T>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::initialize(T *__A)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = initAlgloopEquation(txt, i_eq, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Update the equations once before start of simulation\n",
                                    "evaluate();\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_486;

public function initAlgloopTemplate
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eq,
           a_context,
           a_useFlatArrayNotation )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_486(txt, a_eq, a_useFlatArrayNotation, a_context, i_simCode, l_modelname);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end initAlgloopTemplate;

protected function fun_488
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("memcpy(A_matrix,__A->getData(),_dimAEq*_dimAEq*sizeof(double));"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_488;

protected function fun_489
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("A_matrix->build(*__Asparse);"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_489;

protected function fun_490
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getSystemMatrix(double* A_matrix)\n",
                                    "{\n",
                                    "\n",
                                    " }\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getSystemMatrix(sparse_matrix* A_matrix)\n",
                                    "{\n",
                                    "\n",
                                    " }"
                                }, false));
      then txt;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getSystemMatrix(double* A_matrix)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = fun_488(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getSystemMatrix(sparse_matrix* A_matrix)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(5));
        txt = fun_489(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_490;

public function getAMatrixCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;
      Tpl.Text l_modelname;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        txt = fun_490(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end getAMatrixCode;

protected function fun_492
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("   memcpy(residuals,__b.getData(),sizeof(double)* _dimAEq);"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  AlgLoopDefaultImplementation::getRHS(residuals);"));
      then txt;
  end match;
end fun_492;

protected function fun_493
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("   memcpy(residuals,__b.getData(),sizeof(double)* _dimAEq);"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  AlgLoopDefaultImplementation::getRHS(residuals);"));
      then txt;
  end match;
end fun_493;

protected function fun_494
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* residuals)\n",
                                    "  {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = fun_492(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
      then txt;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* residuals)\n",
                                    "  {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = fun_493(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  }"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_494;

public function algloopRHSCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;
      Tpl.Text l_modelname;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        txt = fun_494(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end algloopRHSCode;

protected function fun_496
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_cont;
      Integer i_index;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           _,
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS()\n",
                                    "{\n",
                                    "  return _dimAEq;\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* vars)\n",
                                    "{\n",
                                    "    ublas::matrix<double> A=toMatrix(_dimAEq,_dimAEq,__A->data());\n",
                                    "    double* doubleUnknowns = new double[_dimAEq];\n",
                                    "    getReal(doubleUnknowns);\n",
                                    "    ublas::vector<double> x=toVector(_dimAEq,doubleUnknowns);\n",
                                    "    ublas::vector<double> b=toVector(_dimAEq,__b.data());\n",
                                    "    b=ublas::prod(ublas::trans(A),x)-b;\n",
                                    "    if(vars) std::copy(b.data().begin(), b.data().end(), vars);\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           _,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::giveDimRHS()\n",
                                    "{\n",
                                    "  return _dimAEq;\n",
                                    "\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* vars)\n",
                                    "{\n",
                                    "      AlgLoopDefaultImplementation:::getRHS(vars)\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont),
           a_simCode,
           _ )
      equation
        txt = algloopResiduals(txt, a_simCode, i_cont);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_496;

public function algloopResiduals
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_496(txt, a_eq, i_simCode, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end algloopResiduals;

protected function fun_498
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Integer i_index;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isLinear()\n",
                                    "{\n",
                                    "       return false;\n",
                                    " }"
                                }, false));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isLinear()\n",
                                    "{\n",
                                    "     return true;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_498;

public function isLinearCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;
      Tpl.Text l_modelname;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        txt = fun_498(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end isLinearCode;

protected function fun_500
  input Tpl.Text in_txt;
  input Boolean in_a_linearTearing;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_linearTearing)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end match;
end fun_500;

protected function fun_501
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;
      Integer i_index;
      Boolean i_linearTearing;
      Tpl.Text l_lineartearing;

    case ( txt,
           SimCode.SES_NONLINEAR(linearTearing = i_linearTearing, index = i_index),
           a_modelname )
      equation
        l_lineartearing = fun_500(Tpl.emptyTxt, i_linearTearing);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isLinearTearing()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("return "));
        txt = Tpl.writeText(txt, l_lineartearing);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" }"));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_modelname )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isLinearTearing()\n",
                                    "{\n",
                                    "     return false;\n",
                                    "}"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_501;

public function isLinearTearingCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_preExp;
      Tpl.Text l_varDecls;
      Tpl.Text l_modelname;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name)),
           a_eq )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_varDecls = Tpl.emptyTxt;
        l_preExp = Tpl.emptyTxt;
        txt = fun_501(txt, a_eq, l_modelname);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end isLinearTearingCode;

protected function lm_503
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           i_name :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_namestr, a_varDeclsCref) = cref1(Tpl.emptyTxt, i_name, a_simCode, a_context, a_varDeclsCref, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__xd["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_503(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_503;

protected function lm_504
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer i_col;
      Integer i_row;
      DAE.Exp i_eq_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_eq_exp, a_context, l_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(*__A)("));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1,"));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+1)="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_504(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_504(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_504;

protected function lm_505
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      Integer x_i0;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;
      Tpl.Text l_preExp;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_exp :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_preExp = Tpl.emptyTxt;
        (l_expPart, l_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, l_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__b("));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")="));
        txt = Tpl.writeText(txt, l_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_505(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_505;

protected function fun_506
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_a_eq, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<DAE.ComponentRef> i_crefs;
      Tpl.Text l_bvector;
      Tpl.Text l_Amatrix;
      Tpl.Text l_varDecls;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDeclsCref) = lm_503(txt, i_crefs, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDeclsCref);

    case ( txt,
           SimCode.SES_LINEAR(simJac = i_simJac, beqs = i_beqs),
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        l_varDecls = Tpl.emptyTxt;
        l_Amatrix = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_Amatrix, l_varDecls) = lm_504(l_Amatrix, i_simJac, a_useFlatArrayNotation, a_simCode, l_varDecls, a_context);
        l_Amatrix = Tpl.popIter(l_Amatrix);
        l_bvector = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_bvector, l_varDecls) = lm_505(l_bvector, i_beqs, a_useFlatArrayNotation, a_simCode, l_varDecls, a_context);
        l_bvector = Tpl.popIter(l_bvector);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_Amatrix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_bvector);
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDeclsCref);

    case ( txt,
           _,
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);
  end match;
end fun_506;

public function initAlgloopEquation
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.SimCode a_simCode;
  input SimCode.Context a_context;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDeclsCref;
algorithm
  l_varDeclsCref := Tpl.emptyTxt;
  (out_txt, l_varDeclsCref) := fun_506(txt, a_eq, a_useFlatArrayNotation, l_varDeclsCref, a_context, a_simCode);
end initAlgloopEquation;

protected function lm_508
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           i_name :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_namestr, a_varDeclsCref) = cref1(Tpl.emptyTxt, i_name, a_simCode, a_context, a_varDeclsCref, a_useFlatArrayNotation);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_508(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_508;

protected function lm_509
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ="));
        (txt, a_varDeclsCref) = cref1(txt, i_name, a_simCode, a_context, a_varDeclsCref, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_509(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
      then (txt, a_varDeclsCref);

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        (txt, a_varDeclsCref) = lm_509(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_509;

protected function fun_510
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_a_eq, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      list<SimCodeVar.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDeclsCref) = lm_508(txt, i_crefs, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDeclsCref);

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars),
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDeclsCref) = lm_509(txt, i_vars, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDeclsCref);

    case ( txt,
           _,
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);
  end match;
end fun_510;

public function giveAlgloopvars
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.SimCode a_simCode;
  input SimCode.Context a_context;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDeclsCref;
algorithm
  l_varDeclsCref := Tpl.emptyTxt;
  (out_txt, l_varDeclsCref) := fun_510(txt, a_eq, a_useFlatArrayNotation, l_varDeclsCref, a_context, a_simCode);
end giveAlgloopvars;

protected function lm_512
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_context, in_a_simCode, in_a_varDecls, in_a_preExp)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _,
           _,
           _,
           a_varDecls,
           a_preExp )
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           i_name :: rest,
           a_useFlatArrayNotation,
           a_context,
           a_simCode,
           a_varDecls,
           a_preExp )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_namestr, a_preExp, a_varDecls) = giveAlgloopNominalvars2(Tpl.emptyTxt, i_name, a_preExp, a_varDecls, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls, a_preExp) = lm_512(txt, rest, a_useFlatArrayNotation, a_context, a_simCode, a_varDecls, a_preExp);
      then (txt, a_varDecls, a_preExp);
  end match;
end lm_512;

protected function lm_513
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDecls, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _,
           a_varDecls,
           _,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest,
           a_useFlatArrayNotation,
           a_varDecls,
           a_context,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] ="));
        (txt, a_varDecls) = cref1(txt, i_name, a_simCode, a_context, a_varDecls, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_513(txt, rest, a_useFlatArrayNotation, a_varDecls, a_context, a_simCode);
      then (txt, a_varDecls);

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_varDecls,
           a_context,
           a_simCode )
      equation
        (txt, a_varDecls) = lm_513(txt, rest, a_useFlatArrayNotation, a_varDecls, a_context, a_simCode);
      then (txt, a_varDecls);
  end match;
end lm_513;

public function giveAlgloopNominalvars
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      list<SimCodeVar.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Tpl.Text l_nominalVars;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_simCode,
           a_context,
           a_useFlatArrayNotation )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_nominalVars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_nominalVars, l_varDecls, l_preExp) = lm_512(l_nominalVars, i_crefs, a_useFlatArrayNotation, a_context, a_simCode, l_varDecls, l_preExp);
        l_nominalVars = Tpl.popIter(l_nominalVars);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_nominalVars);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars),
           a_simCode,
           a_context,
           a_useFlatArrayNotation )
      equation
        l_varDecls = Tpl.emptyTxt;
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDecls) = lm_513(txt, i_vars, a_useFlatArrayNotation, l_varDecls, a_context, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end giveAlgloopNominalvars;

protected function fun_515
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_var;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_a_var, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      DAE.Exp i_exp;
      Tpl.Text l_expPart;

    case ( txt,
           SimCodeVar.SIMVAR(nominalValue = SOME(i_exp)),
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (l_expPart, a_preExp, a_varDecls) = daeExp(Tpl.emptyTxt, i_exp, a_context, a_preExp, a_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.writeText(txt, l_expPart);
      then (txt, a_varDecls, a_preExp);

    case ( txt,
           _,
           _,
           _,
           a_varDecls,
           a_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1.0"));
      then (txt, a_varDecls, a_preExp);
  end match;
end fun_515;

protected function smf_516
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_it;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_it, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_preExp, in_a_context)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      SimCode.Context a_context;
      SimCodeVar.SimVar i_var;

    case ( txt,
           i_var,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_preExp,
           a_context )
      equation
        (txt, a_varDecls, a_preExp) = fun_515(txt, i_var, a_useFlatArrayNotation, a_simCode, a_varDecls, a_preExp, a_context);
      then (txt, a_varDecls, a_preExp);
  end match;
end smf_516;

public function giveAlgloopNominalvars2
  input Tpl.Text txt;
  input DAE.ComponentRef a_inCref;
  input Tpl.Text a_preExp;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input SimCode.Context a_context;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_preExp;
  output Tpl.Text out_a_varDecls;
protected
  SimCodeVar.SimVar ret_0;
algorithm
  ret_0 := SimCodeUtil.cref2simvar(a_inCref, a_simCode);
  (out_txt, out_a_varDecls, out_a_preExp) := smf_516(txt, ret_0, a_useFlatArrayNotation, a_simCode, a_varDecls, a_preExp, a_context);
end giveAlgloopNominalvars2;

protected function lm_518
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_eq :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = writeAlgloopvars2(txt, i_eq, a_context, a_varDecls, a_simCode, a_useFlatArrayNotation);
        (txt, a_varDecls) = lm_518(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_518;

protected function lm_519
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_varDecls;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  (out_txt, out_a_varDecls) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode, in_a_varDecls, in_a_context)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Tpl.Text a_varDecls;
      SimCode.Context a_context;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           _,
           a_varDecls,
           _ )
      then (txt, a_varDecls);

    case ( txt,
           i_eqs :: rest,
           a_useFlatArrayNotation,
           a_simCode,
           a_varDecls,
           a_context )
      equation
        (txt, a_varDecls) = lm_518(txt, i_eqs, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
        txt = Tpl.nextIter(txt);
        (txt, a_varDecls) = lm_519(txt, rest, a_useFlatArrayNotation, a_simCode, a_varDecls, a_context);
      then (txt, a_varDecls);
  end match;
end lm_519;

public function writeAlgloopvars
  input Tpl.Text txt;
  input list<list<SimCode.SimEqSystem>> a_continousEquations;
  input list<SimCode.SimEqSystem> a_discreteEquations;
  input list<SimCode.SimWhenClause> a_whenClauses;
  input list<SimCode.SimEqSystem> a_parameterEquations;
  input SimCode.SimCode a_simCode;
  input SimCode.Context a_context;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_algloopsolver;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_algloopsolver := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (l_algloopsolver, l_varDecls) := lm_519(l_algloopsolver, a_continousEquations, a_useFlatArrayNotation, a_simCode, l_varDecls, a_context);
  l_algloopsolver := Tpl.popIter(l_algloopsolver);
  out_txt := Tpl.writeText(txt, l_algloopsolver);
end writeAlgloopvars;

protected function lm_521
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_index;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_index;
      Boolean a_useFlatArrayNotation;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_name :: rest,
           a_index,
           a_useFlatArrayNotation )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        l_namestr = cref(Tpl.emptyTxt, i_name, a_useFlatArrayNotation);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = algloopvars"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_521(txt, rest, a_index, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_521;

protected function lm_522
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Tpl.Text in_a_algloopid;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_algloopid, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Tpl.Text a_algloopid;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _,
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest,
           a_algloopid,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDeclsCref) = cref1(txt, i_name, a_simCode, a_context, a_varDeclsCref, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = algloopvars"));
        txt = Tpl.writeText(txt, a_algloopid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_522(txt, rest, a_algloopid, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
      then (txt, a_varDeclsCref);

    case ( txt,
           _ :: rest,
           a_algloopid,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        (txt, a_varDeclsCref) = lm_522(txt, rest, a_algloopid, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_522;

protected function fun_523
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_context, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      list<SimCodeVar.SimVar> i_vars;
      Integer i_index;
      list<DAE.ComponentRef> i_crefs;
      Tpl.Text l_varDeclsCref;
      Tpl.Text l_algloopid;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs, index = i_index),
           _,
           _,
           a_useFlatArrayNotation )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double algloopvars"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getReal(algloopvars"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_521(txt, i_crefs, i_index, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, index = i_index),
           a_context,
           a_simCode,
           a_useFlatArrayNotation )
      equation
        ret_2 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        l_algloopid = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        l_varDeclsCref = Tpl.emptyTxt;
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double algloopvars"));
        txt = Tpl.writeText(txt, l_algloopid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getReal(algloopvars"));
        txt = Tpl.writeText(txt, l_algloopid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",NULL,NULL);\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_varDeclsCref) = lm_522(txt, i_vars, l_algloopid, a_useFlatArrayNotation, l_varDeclsCref, a_context, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_523;

public function writeAlgloopvars2
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.Context a_context;
  input Tpl.Text a_varDecls;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_523(txt, a_eq, a_context, a_simCode, a_useFlatArrayNotation);
  out_a_varDecls := a_varDecls;
end writeAlgloopvars2;

protected function lm_525
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;
      Tpl.Text l_namestr;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           i_name :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (l_namestr, a_varDeclsCref) = cref1(Tpl.emptyTxt, i_name, a_simCode, a_context, a_varDeclsCref, a_useFlatArrayNotation);
        txt = Tpl.writeText(txt, l_namestr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  = vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_525(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_525;

protected function lm_526
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      DAE.ComponentRef i_name;

    case ( txt,
           {},
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        (txt, a_varDeclsCref) = cref1(txt, i_name, a_simCode, a_context, a_varDeclsCref, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=vars["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        (txt, a_varDeclsCref) = lm_526(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
      then (txt, a_varDeclsCref);

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        (txt, a_varDeclsCref) = lm_526(txt, rest, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
      then (txt, a_varDeclsCref);
  end match;
end lm_526;

protected function fun_527
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_varDeclsCref;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDeclsCref;
algorithm
  (out_txt, out_a_varDeclsCref) :=
  match(in_txt, in_a_eq, in_a_useFlatArrayNotation, in_a_varDeclsCref, in_a_context, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_varDeclsCref;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      list<SimCodeVar.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs),
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDeclsCref) = lm_525(txt, i_crefs, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.popBlock(txt);
      then (txt, a_varDeclsCref);

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars),
           a_useFlatArrayNotation,
           a_varDeclsCref,
           a_context,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_varDeclsCref) = lm_526(txt, i_vars, a_useFlatArrayNotation, a_varDeclsCref, a_context, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then (txt, a_varDeclsCref);

    case ( txt,
           _,
           _,
           a_varDeclsCref,
           _,
           _ )
      then (txt, a_varDeclsCref);
  end match;
end fun_527;

public function setAlgloopvars
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input SimCode.SimCode a_simCode;
  input SimCode.Context a_context;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varDeclsCref;
algorithm
  l_varDeclsCref := Tpl.emptyTxt;
  (out_txt, l_varDeclsCref) := fun_527(txt, a_eq, a_useFlatArrayNotation, l_varDeclsCref, a_context, a_simCode);
end setAlgloopvars;

protected function fun_529
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars;
      list<DAE.ComponentRef> i_crefs;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_NONLINEAR(crefs = i_crefs) )
      equation
        ret_1 = listLength(i_crefs);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  // Number of unknowns equations\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimAEq = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "_constraintType = IAlgLoop::REAL;\n",
                                    "__xd.resize("
                                }, false));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_xd_init.resize("));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        ret_2 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  // Number of unknowns/equations according to type (0: double, 1: int, 2: bool)\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_dimAEq = "));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "fill_array(__b,0.0);"
                                }, false));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_529;

public function initAlgloopDimension
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input Tpl.Text a_varDecls;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_varDecls;
algorithm
  out_txt := fun_529(txt, a_eq);
  out_a_varDecls := a_varDecls;
end initAlgloopDimension;

public function alocateLinearSystem
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        ret_1 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " if(_useSparseFormat)\n",
                                    "   __Asparse = new sparse_inserter;\n",
                                    " else\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("__A = new StatArrayDim2<double,"));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ,true>(); //boost::multi_array<double,2>(boost::extents["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("],boost::fortran_storage_order());"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end alocateLinearSystem;

protected function fun_532
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        ret_1 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",__b(boost::extents["));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_532;

public function alocateLinearSystemConstructor
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_532(txt, a_eq);
end alocateLinearSystemConstructor;

public function Update
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<SimCode.SimEqSystem> i_equationsForZeroCrossings;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      SimCode.SimCode i_simCode;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<SimCode.SimEqSystem> i_allEquations;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(allEquations = i_allEquations, whenClauses = i_whenClauses, odeEquations = i_odeEquations, equationsForZeroCrossings = i_equationsForZeroCrossings)),
           a_useFlatArrayNotation )
      equation
        txt = equationFunctions(txt, i_allEquations, i_whenClauses, i_simCode, SimCode.contextSimulationDiscrete, a_useFlatArrayNotation, false);
        txt = Tpl.softNewLine(txt);
        txt = createEvaluateAll(txt, i_allEquations, i_whenClauses, i_simCode, SimCode.contextOther, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = createEvaluate(txt, i_odeEquations, i_whenClauses, i_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = createEvaluateZeroFuncs(txt, i_equationsForZeroCrossings, i_simCode, SimCode.contextOther);
        txt = Tpl.softNewLine(txt);
        txt = createEvaluateConditions(txt, i_allEquations, i_whenClauses, i_simCode, SimCode.contextOther, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end Update;

protected function lm_535
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input String in_a_className;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_className)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      String a_className;
      Integer x_i0;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_className )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equations_array["));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = &"));
        txt = Tpl.writeStr(txt, a_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("::evaluate_"));
        txt = CodegenUtil.equationIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_535(txt, rest, a_className);
      then txt;
  end match;
end lm_535;

public function InitializeEquationsArray
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_a_allEquations;
  input String in_a_className;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_allEquations, in_a_className)
    local
      Tpl.Text txt;
      String a_className;
      SimCode.SimEqSystem i_feq;
      list<SimCode.SimEqSystem> i_allEquations;
      Tpl.Text l_equation__inits;

    case ( txt,
           (i_allEquations as i_feq :: _),
           a_className )
      equation
        l_equation__inits = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_equation__inits = lm_535(l_equation__inits, i_allEquations, a_className);
        l_equation__inits = Tpl.popIter(l_equation__inits);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = Tpl.writeStr(txt, a_className);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::initialize_equations_array() {\n",
                                    "  /*! Index of the first equation. We use this to calculate the offset of an equation in the\n",
                                    "    equation array given the index of the equation.*/\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("first_equation_index = "));
        txt = CodegenUtil.equationIndex(txt, i_feq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_equation__inits);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end InitializeEquationsArray;

protected function fun_537
  input Tpl.Text in_txt;
  input String in_a_settings_outputFormat;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_settings_outputFormat)
    local
      Tpl.Text txt;

    case ( txt,
           "mat" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "writeParametertNames(paramnames);\n",
                                    "writeIntParameterNames(paramnames);\n",
                                    "writeBoolParameterNames(paramnames);\n",
                                    "writeAlgVarsResultDescription(vardescs);\n",
                                    "writeDiscreteAlgVarsResultDescription(vardescs);\n",
                                    "writeIntAlgVarsResultDescription(vardescs);\n",
                                    "writeBoolAlgVarsResultDescription(vardescs);\n",
                                    "writeAliasVarsResultDescription(vardescs);\n",
                                    "writeIntAliasVarsResultDescription(vardescs);\n",
                                    "writeBoolAliasVarsResultDescription(vardescs);\n",
                                    "writeStateVarsResultDescription(vardescs);\n",
                                    "writeDerivativeVarsResultDescription(vardescs);\n",
                                    "writeParameterDescription(paramdecs);\n",
                                    "writeIntParameterDescription(paramdecs);\n",
                                    "writeBoolParameterDescription(paramdecs);"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_537;

protected function fun_538
  input Tpl.Text in_txt;
  input String in_a_settings_outputFormat;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_settings_outputFormat, in_a_useFlatArrayNotation, in_a_simCode, in_a_modelInfo)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.ModelInfo a_modelInfo;

    case ( txt,
           "mat",
           a_useFlatArrayNotation,
           a_simCode,
           a_modelInfo )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  HistoryImplType::value_type_p params;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = writeoutputparams(txt, a_modelInfo, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" HistoryImplType::value_type_p params;"));
      then txt;
  end match;
end fun_538;

protected function smf_539
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode )
      equation
        txt = writeoutputAlgloopsolvers(txt, i_eq, a_simCode);
      then txt;
  end match;
end smf_539;

protected function lm_540
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqs :: rest,
           a_simCode )
      equation
        txt = smf_539(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_540(txt, rest, a_simCode);
      then txt;
  end match;
end lm_540;

protected function lm_541
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = writeoutput3(txt, i_eqn, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_541(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_541;

protected function fun_542
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_allEquations)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _,
           _,
           _ )
      equation
        txt = generateMeasureTimeEndCode(txt, "measuredFunctionStartValues", "measuredFunctionEndValues", "measureTimeFunctionsArray[2]");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "//_historyImpl->write(v,v2,_simTime);\n",
                                    "_historyImpl->addContainerToWriteQueue(container);"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("HistoryImplType::value_type_r v3;\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_540(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double residues [] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_541(txt, a_allEquations, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "for(int i=0;i<"
                                }, false));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";i++) v3(i) = residues[i];\n",
                                    "\n"
                                }, true));
        txt = generateMeasureTimeEndCode(txt, "measuredFunctionStartValues", "measuredFunctionEndValues", "measureTimeFunctionsArray[2]");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "_historyImpl->write(v,v2,v3,_simTime);"
                                }, false));
      then txt;
  end match;
end fun_542;

public function writeoutput
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.SimCode i_simCode;
      String i_settings_outputFormat;
      Absyn.Path i_modelInfo_name;
      SimCode.ModelInfo i_modelInfo;
      Tpl.Text txt_2;
      Boolean ret_1;
      Tpl.Text l_numParamvars;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), simulationSettingsOpt = SOME(SimCode.SIMULATION_SETTINGS(outputFormat = i_settings_outputFormat)), allEquations = i_allEquations)),
           a_useFlatArrayNotation )
      equation
        l_numParamvars = numProtectedParamVars(Tpl.emptyTxt, i_modelInfo);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void "));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "WriteOutput::writeOutput(const IWriteOutput::OUTPUT command)\n",
                                    "{\n",
                                    " //Write head line\n",
                                    " if (command & IWriteOutput::HEAD_LINE)\n",
                                    " {\n",
                                    "   vector<string> varsnames;\n",
                                    "   vector<string> vardescs;\n",
                                    "   vector<string> paramnames;\n",
                                    "   vector<string> paramdecs;\n",
                                    "   writeAlgVarsResultNames(varsnames);\n",
                                    "   writeDiscreteAlgVarsResultNames(varsnames);\n",
                                    "   writeIntAlgVarsResultNames(varsnames);\n",
                                    "   writeBoolAlgVarsResultNames(varsnames);\n",
                                    "   writeAliasVarsResultNames(varsnames);\n",
                                    "   writeIntAliasVarsResultNames(varsnames);\n",
                                    "   writeBoolAliasVarsResultNames(varsnames);\n",
                                    "   writeStateVarsResultNames(varsnames);\n",
                                    "   writeDerivativeVarsResultNames(varsnames);\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = fun_537(txt, i_settings_outputFormat);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_historyImpl->write(varsnames,vardescs,paramnames,paramdecs);\n"));
        txt = fun_538(txt, i_settings_outputFormat, a_useFlatArrayNotation, i_simCode, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" _historyImpl->write(params,_global_settings->getStartTime(),_global_settings->getEndTime());\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    " //Write the current values\n",
                                    " else\n",
                                    " {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = generateMeasureTimeStartCode(txt, "measuredFunctionStartValues");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/* HistoryImplType::value_type_v v;\n",
                                    "HistoryImplType::value_type_dv v2; */\n",
                                    "\n",
                                    "boost::tuple<HistoryImplType::value_type_v*, HistoryImplType::value_type_dv*, double> *container = _historyImpl->getFreeContainer();\n",
                                    "HistoryImplType::value_type_v *v = container->get<0>();\n",
                                    "HistoryImplType::value_type_dv *v2 = container->get<1>();\n",
                                    "container->get<2>() = _simTime;\n",
                                    "\n",
                                    "writeAlgVarsValues(v);\n",
                                    "writeDiscreteAlgVarsValues(v);\n",
                                    "writeIntAlgVarsValues(v);\n",
                                    "writeBoolAlgVarsValues(v);\n",
                                    "writeAliasVarsValues(v);\n",
                                    "writeIntAliasVarsValues(v);\n",
                                    "writeBoolAliasVarsValues(v);\n",
                                    "writeStateValues(v,v2);\n",
                                    "\n"
                                }, true));
        ret_1 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_542(txt, ret_1, a_useFlatArrayNotation, i_simCode, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "}\n"
                                }, true));
        txt_2 = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_STRING("WriteOutput"));
        txt = generateWriteOutputFunctionsForVars(txt, i_modelInfo, i_simCode, Tpl.textString(txt_2), a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = writeoutput1(txt, i_modelInfo);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end writeoutput;

protected function fun_544
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double* doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->getDimRHS()];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getRHS(doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end fun_544;

protected function fun_545
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double* doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->getDimRHS()];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getRHS(doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end fun_545;

protected function fun_546
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_num;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_num)
    local
      Tpl.Text txt;
      Tpl.Text a_num;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)),
           a_num )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double* doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double[_algLoop"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "->getDimRHS()];\n",
                                    "_algLoop"
                                }, false));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("->getRHS(doubleResiduals"));
        txt = Tpl.writeText(txt, a_num);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;
  end match;
end fun_546;

public function writeoutputAlgloopsolvers
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Integer i_index;
      Tpl.Text l_num;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_544(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_545(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(index = i_index),
           a_simCode )
      equation
        l_num = Tpl.writeStr(Tpl.emptyTxt, intString(i_index));
        txt = fun_546(txt, a_simCode, l_num);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end writeoutputAlgloopsolvers;

protected function lm_548
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_e_index)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_e_index;
      Integer x_myindex2;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_e_index )
      equation
        x_myindex2 = Tpl.getIteri_i0(txt);
        txt = writeoutput4(txt, a_e_index, x_myindex2);
        txt = Tpl.nextIter(txt);
        txt = lm_548(txt, rest, a_e_index);
      then txt;
  end match;
end lm_548;

protected function lm_549
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_e_index)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Integer a_e_index;
      Integer x_myindex2;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_e_index )
      equation
        x_myindex2 = Tpl.getIteri_i0(txt);
        txt = writeoutput4(txt, a_e_index, x_myindex2);
        txt = Tpl.nextIter(txt);
        txt = lm_549(txt, rest, a_e_index);
      then txt;
  end match;
end lm_549;

public function writeoutput3
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eqn;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eqn, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Boolean a_useFlatArrayNotation;
      SimCode.SimEqSystem i_cont;
      list<SimCode.SimEqSystem> i_eqs;
      Integer i_e_index;
      list<SimCodeVar.SimVar> i_vars;
      DAE.ComponentRef i_cref;
      Tpl.Text l_varDeclsCref;

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        l_varDeclsCref = Tpl.emptyTxt;
        (txt, l_varDeclsCref) = cref1(txt, i_cref, a_simCode, SimCode.contextOther, l_varDeclsCref, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = _),
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(index = _),
           _,
           _ )
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, index = i_e_index),
           _,
           _ )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_548(txt, i_vars, i_e_index);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(eqs = i_eqs, index = i_e_index),
           _,
           _ )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_549(txt, i_eqs, i_e_index);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont),
           a_simCode,
           a_useFlatArrayNotation )
      equation
        txt = writeoutput3(txt, i_cont, a_simCode, a_useFlatArrayNotation);
      then txt;

    case ( txt,
           SimCode.SES_WHEN(index = _),
           _,
           _ )
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end writeoutput3;

public function writeoutput4
  input Tpl.Text txt;
  input Integer a_index;
  input Integer a_myindex2;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("*(doubleResiduals"));
  out_txt := Tpl.writeStr(out_txt, intString(a_index));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("+"));
  out_txt := Tpl.writeStr(out_txt, intString(a_myindex2));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(")"));
end writeoutput4;

public function generateHeaderIncludeString
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Absyn.Path i_modelInfo_name;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(vars = _), allEquations = i_allEquations, initialEquations = i_initialEquations)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#if defined(__TRICORE__) || defined(__vxworks)\n",
                                    "#define BOOST_EXTENSION_SYSTEM_DECL\n",
                                    "#define BOOST_EXTENSION_EVENTHANDLING_DECL\n",
                                    "#else\n",
                                    "#define BOOST_EXTENSION_SYSTEM_DECL BOOST_EXTENSION_IMPORT_DECL\n",
                                    "#define BOOST_EXTENSION_EVENTHANDLING_DECL BOOST_EXTENSION_IMPORT_DECL\n",
                                    "#endif\n",
                                    "#include \"System/EventHandling.h\"\n",
                                    "#include \"System/SystemDefaultImplementation.h\"\n",
                                    "#include \"Core/Utils/extension/measure_time.hpp\"\n",
                                    "\n",
                                    "//Forward declaration to speed-up the compilation process\n",
                                    "class Functions;\n",
                                    "\n"
                                }, true));
        ret_0 = listAppend(i_allEquations, i_initialEquations);
        txt = algloopForwardDeclaration(txt, ret_0, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/*****************************************************************************\n",
                                    "*\n",
                                    "* Simulation code for "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " generated by the OpenModelica Compiler.\n",
                                    "* System class "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " implements the Interface IMixedSystem\n",
                                    "*\n",
                                    "*****************************************************************************/"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateHeaderIncludeString;

protected function fun_553
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;

    case ( txt,
           SimCode.ALGLOOP_CONTEXT(genInitialisation = false, genJacobian = true),
           a_modelname )
      equation
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Jacobian"));
      then txt;

    case ( txt,
           _,
           a_modelname )
      equation
        txt = Tpl.writeText(txt, a_modelname);
      then txt;
  end match;
end fun_553;

public function generateAlgloopHeaderInlcudeString
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.Context in_a_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_context)
    local
      Tpl.Text txt;
      SimCode.Context a_context;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_systemname;
      Tpl.Text l_modelname;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name), extObjInfo = SimCode.EXTOBJINFO(vars = _)),
           a_context )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_systemname = fun_553(Tpl.emptyTxt, a_context, l_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "#pragma once\n",
                                    "#if defined(__TRICORE__)\n",
                                    "#define BOOST_EXTENSION_ALGLOOPDEFAULTIMPL_DECL\n",
                                    "#define BOOST_EXTENSION_EVENTHANDLING_DECL\n",
                                    "#else\n",
                                    "#define BOOST_EXTENSION_ALGLOOPDEFAULTIMPL_DECL BOOST_EXTENSION_IMPORT_DECL\n",
                                    "#define BOOST_EXTENSION_EVENTHANDLING_DECL BOOST_EXTENSION_IMPORT_DECL\n",
                                    "#endif\n",
                                    "#include \"System/AlgLoopDefaultImplementation.h\"\n",
                                    "\n",
                                    "class EventHandling;\n",
                                    "class "
                                }, false));
        txt = Tpl.writeText(txt, l_systemname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "class Functions;"
                                }, false));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end generateAlgloopHeaderInlcudeString;

protected function lm_555
  input Tpl.Text in_txt;
  input list<list<SimCodeVar.SimVar>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCodeVar.SimVar>> rest;
      Integer x_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_idx = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void getReal_"));
        txt = Tpl.writeStr(txt, intString(x_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(double* z);\n",
                                    "void setReal_"
                                }, false));
        txt = Tpl.writeStr(txt, intString(x_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(const double* z);"));
        txt = Tpl.nextIter(txt);
        txt = lm_555(txt, rest);
      then txt;
  end match;
end lm_555;

protected function lm_556
  input Tpl.Text in_txt;
  input list<list<SimCodeVar.SimVar>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<SimCodeVar.SimVar>> rest;
      Integer x_idx;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_idx = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void getInteger_"));
        txt = Tpl.writeStr(txt, intString(x_idx));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int* z);"));
        txt = Tpl.nextIter(txt);
        txt = lm_556(txt, rest);
      then txt;
  end match;
end lm_556;

protected function fun_557
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", public IReduceDAE"));
      then txt;
  end match;
end fun_557;

protected function fun_558
  input Tpl.Text in_txt;
  input Boolean in_a_useDefaultMemberVariables;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_useDefaultMemberVariables, in_a_useFlatArrayNotation, in_a_modelInfo)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.ModelInfo a_modelInfo;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_modelInfo )
      equation
        txt = MemberVariable(txt, a_modelInfo, a_useFlatArrayNotation);
      then txt;
  end match;
end fun_558;

protected function fun_559
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "std::vector<MeasureTimeData> measureTimeProfileBlocksArray;\n",
                                    "std::vector<MeasureTimeData> measureTimeFunctionsArray;\n",
                                    "MeasureTimeValues *measuredProfileBlockStartValues, *measuredProfileBlockEndValues, *measuredFunctionStartValues, *measuredFunctionEndValues;"
                                }, false));
      then txt;
  end match;
end fun_559;

protected function fun_560
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_additionalProtectedMembers;
  input Tpl.Text in_a_memberfuncs;
  input Tpl.Text in_a_algloopsolver;
  input Tpl.Text in_a_conditionvariables;
  input Boolean in_a_useFlatArrayNotation;
  input Boolean in_a_useDefaultMemberVariables;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_friendclasses;
  input Absyn.Path in_a_modelInfo_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_additionalProtectedMembers, in_a_memberfuncs, in_a_algloopsolver, in_a_conditionvariables, in_a_useFlatArrayNotation, in_a_useDefaultMemberVariables, in_a_simCode, in_a_friendclasses, in_a_modelInfo_name)
    local
      Tpl.Text txt;
      String a_additionalProtectedMembers;
      Tpl.Text a_memberfuncs;
      Tpl.Text a_algloopsolver;
      Tpl.Text a_conditionvariables;
      Boolean a_useFlatArrayNotation;
      Boolean a_useDefaultMemberVariables;
      SimCode.SimCode a_simCode;
      Tpl.Text a_friendclasses;
      Absyn.Path a_modelInfo_name;
      SimCode.ModelInfo i_modelInfo;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      Boolean ret_11;
      Boolean ret_10;
      String ret_9;
      Boolean ret_8;
      list<list<SimCodeVar.SimVar>> ret_7;
      list<SimCodeVar.SimVar> ret_6;
      list<SimCodeVar.SimVar> ret_5;
      Tpl.Text l_getintvars;
      list<list<SimCodeVar.SimVar>> ret_3;
      list<SimCodeVar.SimVar> ret_2;
      list<SimCodeVar.SimVar> ret_1;
      Tpl.Text l_getrealvars;

    case ( txt,
           (i_modelInfo as SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars))),
           a_additionalProtectedMembers,
           a_memberfuncs,
           a_algloopsolver,
           a_conditionvariables,
           a_useFlatArrayNotation,
           a_useDefaultMemberVariables,
           a_simCode,
           a_friendclasses,
           a_modelInfo_name )
      equation
        ret_1 = listAppend(i_vars_algVars, i_vars_discreteAlgVars);
        ret_2 = listAppend(ret_1, i_vars_paramVars);
        ret_3 = List.partition(ret_2, 100);
        l_getrealvars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_getrealvars = lm_555(l_getrealvars, ret_3);
        l_getrealvars = Tpl.popIter(l_getrealvars);
        ret_5 = listAppend(i_vars_intAlgVars, i_vars_intParamVars);
        ret_6 = listAppend(ret_5, i_vars_intAliasVars);
        ret_7 = List.partition(ret_6, 100);
        l_getintvars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_getintvars = lm_556(l_getintvars, ret_7);
        l_getintvars = Tpl.popIter(l_getintvars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = lastIdentOfPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": public IContinuous, public IEvent, public IStepEvent, public ITime, public ISystemProperties "));
        ret_8 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_557(txt, ret_8);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", public SystemDefaultImplementation\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, a_friendclasses);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("public:\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = lastIdentOfPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(IGlobalSettings* globalSettings,boost::shared_ptr<IAlgLoopSolverFactory> nonlinsolverfactor,boost::shared_ptr<ISimData>);\n",
                                    "\n",
                                    "virtual ~"
                                }, false));
        txt = lastIdentOfPath(txt, a_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = generateMethodDeclarationCode(txt, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "virtual  bool getCondition(unsigned int index);\n",
                                    "virtual void initPreVars(unordered_map<string,unsigned int>&,unordered_map<string,unsigned int>&);\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected:\n",
                                    "    //Methods:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_getrealvars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_getintvars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "bool isConsistent();\n",
                                    "//Called to handle all  events occured at same time\n",
                                    "bool handleSystemEvents( bool* events);\n",
                                    "//Saves all variables before an event is handled, is needed for the pre, edge and change operator\n",
                                    "void saveAll();\n",
                                    "void getJacobian(SparseMatrix& matrix);\n",
                                    "\n",
                                    "//Variables:\n",
                                    "EventHandling _event_handling;\n",
                                    "\n"
                                }, true));
        txt = fun_558(txt, a_useDefaultMemberVariables, a_useFlatArrayNotation, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, a_conditionvariables);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Functions* _functions;\n",
                                    "\n",
                                    "\n",
                                    "boost::shared_ptr<IAlgLoopSolverFactory> _algLoopSolverFactory;    ///< Factory that provides an appropriate solver\n"
                                }, true));
        txt = Tpl.writeText(txt, a_algloopsolver);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "boost::shared_ptr<ISimData> _simData;\n",
                                    "\n"
                                }, true));
        ret_9 = Flags.getConfigString(Flags.PROFILING_LEVEL);
        ret_10 = stringEq(ret_9, "none");
        ret_11 = boolNot(ret_10);
        txt = fun_559(txt, ret_11);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, a_memberfuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeStr(txt, a_additionalProtectedMembers);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" };"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_560;

public function generateClassDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_additionalProtectedMembers;
  input Boolean in_a_useDefaultMemberVariables;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_additionalProtectedMembers, in_a_useDefaultMemberVariables, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      String a_additionalProtectedMembers;
      Boolean a_useDefaultMemberVariables;
      Boolean a_useFlatArrayNotation;
      Absyn.Path i_modelInfo_name;
      SimCode.ModelInfo i_modelInfo;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      SimCode.SimCode i_simCode;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      Tpl.Text l_conditionvariables;
      Tpl.Text l_memberfuncs;
      list<SimCode.SimEqSystem> ret_3;
      Tpl.Text l_algloopsolver;
      list<SimCode.SimEqSystem> ret_1;
      Tpl.Text l_friendclasses;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), allEquations = i_allEquations, initialEquations = i_initialEquations, zeroCrossings = i_zeroCrossings)),
           a_additionalProtectedMembers,
           a_useDefaultMemberVariables,
           a_useFlatArrayNotation )
      equation
        ret_1 = listAppend(i_allEquations, i_initialEquations);
        l_friendclasses = generatefriendAlgloops(Tpl.emptyTxt, ret_1, i_simCode);
        ret_3 = listAppend(i_allEquations, i_initialEquations);
        l_algloopsolver = generateAlgloopsolverVariables(Tpl.emptyTxt, ret_3, i_simCode);
        (l_memberfuncs, _) = generateEquationMemberFuncDecls(Tpl.emptyTxt, i_allEquations, Tpl.strTokText(Tpl.ST_STRING("evaluate")));
        l_conditionvariables = conditionvariable(Tpl.emptyTxt, i_zeroCrossings, i_simCode);
        txt = fun_560(txt, i_modelInfo, a_additionalProtectedMembers, l_memberfuncs, l_algloopsolver, l_conditionvariables, a_useFlatArrayNotation, a_useDefaultMemberVariables, i_simCode, l_friendclasses, i_modelInfo_name);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end generateClassDeclarationCode;

protected function lm_562
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_method;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_method;
algorithm
  (out_txt, out_a_method) :=
  match(in_txt, in_items, in_a_method)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_method;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_method )
      then (txt, a_method);

    case ( txt,
           i_eq :: rest,
           a_method )
      equation
        (txt, a_method) = generateEquationMemberFuncDecls2(txt, i_eq, a_method);
        txt = Tpl.nextIter(txt);
        (txt, a_method) = lm_562(txt, rest, a_method);
      then (txt, a_method);
  end match;
end lm_562;

public function generateEquationMemberFuncDecls
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_a_allEquations;
  input Tpl.Text in_a_method;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_method;
algorithm
  (out_txt, out_a_method) :=
  match(in_txt, in_a_allEquations, in_a_method)
    local
      Tpl.Text txt;
      Tpl.Text a_method;
      list<SimCode.SimEqSystem> i_allEquations;
      Tpl.Text l_equation__func__decls;

    case ( txt,
           i_allEquations,
           a_method )
      equation
        l_equation__func__decls = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_equation__func__decls, a_method) = lm_562(l_equation__func__decls, i_allEquations, a_method);
        l_equation__func__decls = Tpl.popIter(l_equation__func__decls);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*! Index of the first equation. We use this to calculate the offset of an equation in the\n",
                                    "   equation array given the index of the equation.*/\n",
                                    " int first_equation_index;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_equation__func__decls);
        txt = Tpl.popBlock(txt);
      then (txt, a_method);
  end match;
end generateEquationMemberFuncDecls;

protected function fun_564
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_method)
    local
      Tpl.Text txt;
      Tpl.Text a_method;
      SimCode.SimEqSystem i_eq;
      SimCode.SimEqSystem i_e;
      SimCode.SimEqSystem i_e_cont;

    case ( txt,
           (i_e as SimCode.SES_MIXED(cont = i_e_cont)),
           a_method )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*! Equations*/\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_method);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = CodegenUtil.equationIndex(txt, i_e_cont);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "void "
                                }, false));
        txt = Tpl.writeText(txt, a_method);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = CodegenUtil.equationIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("();"));
      then txt;

    case ( txt,
           i_eq,
           a_method )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/*! Equations*/\n",
                                    "FORCE_INLINE inline void "
                                }, false));
        txt = Tpl.writeText(txt, a_method);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = CodegenUtil.equationIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("();"));
      then txt;
  end match;
end fun_564;

public function generateEquationMemberFuncDecls2
  input Tpl.Text txt;
  input SimCode.SimEqSystem a_eq;
  input Tpl.Text a_method;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_method;
algorithm
  out_txt := fun_564(txt, a_eq, a_method);
  out_a_method := a_method;
end generateEquationMemberFuncDecls2;

protected function fun_566
  input Tpl.Text in_txt;
  input SimCode.Context in_a_context;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_context, in_a_modelname)
    local
      Tpl.Text txt;
      Tpl.Text a_modelname;

    case ( txt,
           SimCode.ALGLOOP_CONTEXT(genInitialisation = false, genJacobian = true),
           a_modelname )
      equation
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Jacobian"));
      then txt;

    case ( txt,
           _,
           a_modelname )
      equation
        txt = Tpl.writeText(txt, a_modelname);
      then txt;
  end match;
end fun_566;

protected function fun_567
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "template <typename T>\n",
                                    "void evaluate(T* __A);"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_567;

protected function fun_568
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        ret_1 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StatArrayDim2<double,"));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",true>* __A; //dense\n",
                                    "//b vector\n",
                                    "StatArrayDim1<double,"
                                }, false));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > __b;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_568;

protected function fun_569
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SES_LINEAR(index = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "template <typename T>\n",
                                    "void evaluate(T* __A);"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_569;

protected function fun_570
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars;
      Integer ret_1;
      Tpl.Text l_size;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars) )
      equation
        ret_1 = listLength(i_vars);
        l_size = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("StatArrayDim2<double,"));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",true>* __A; //dense\n",
                                    "//b vector\n",
                                    "StatArrayDim1<double,"
                                }, false));
        txt = Tpl.writeText(txt, l_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > __b;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_570;

protected function fun_571
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_systemname;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_simCode, in_a_systemname, in_a_modelname)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text a_systemname;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_simCode,
           a_systemname,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ": public IAlgLoop, public AlgLoopDefaultImplementation\n",
                                    "{\n",
                                    "public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("( "));
        txt = Tpl.writeText(txt, a_systemname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "* system\n",
                                    "                                  ,double* z,double* zDot, bool* conditions\n",
                                    "                                 ,EventHandling& event_handling\n",
                                    "                                );\n",
                                    "virtual ~"
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateAlgloopMethodDeclarationCode(txt, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "bool getUseSparseFormat();\n",
                                    "void setUseSparseFormat(bool value);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  float queryDensity();\n",
                                    "\n",
                                    "protected:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = fun_567(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "private:\n",
                                    "  Functions* _functions;\n",
                                    "\n",
                                    "  //states\n",
                                    "  double* __z;\n",
                                    "  //state derivatives\n",
                                    "  double* __zDot;\n",
                                    "  // A matrix\n",
                                    "  //boost::multi_array<double,2> *__A; //dense\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fun_568(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "sparse_inserter *__Asparse; //sparse\n",
                                    "\n",
                                    "//b vector\n",
                                    "//boost::multi_array<double,1> __b;\n",
                                    "bool* _conditions;\n",
                                    "\n",
                                    "EventHandling& _event_handling;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_systemname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "* _system;\n",
                                    "\n",
                                    "bool _useSparseFormat;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" };"));
      then txt;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_simCode,
           a_systemname,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("class "));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ": public IAlgLoop, public AlgLoopDefaultImplementation\n",
                                    "{\n",
                                    "public:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("( "));
        txt = Tpl.writeText(txt, a_systemname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "* system\n",
                                    "                                  ,double* z,double* zDot, bool* conditions\n",
                                    "                                 ,EventHandling& event_handling\n",
                                    "                                );\n",
                                    "virtual ~"
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "();\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = generateAlgloopMethodDeclarationCode(txt, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "bool getUseSparseFormat();\n",
                                    "void setUseSparseFormat(bool value);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  float queryDensity();\n",
                                    "\n",
                                    "protected:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = fun_569(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "private:\n",
                                    "  Functions* _functions;\n",
                                    "\n",
                                    "  //states\n",
                                    "  double* __z;\n",
                                    "  //state derivatives\n",
                                    "  double* __zDot;\n",
                                    "  // A matrix\n",
                                    "  //boost::multi_array<double,2> *__A; //dense\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fun_570(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "sparse_inserter *__Asparse; //sparse\n",
                                    "\n",
                                    "//b vector\n",
                                    "//boost::multi_array<double,1> __b;\n",
                                    "bool* _conditions;\n",
                                    "\n",
                                    "EventHandling& _event_handling;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, a_systemname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "* _system;\n",
                                    "\n",
                                    "bool _useSparseFormat;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" };"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_571;

public function generateAlgloopClassDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      SimCode.ModelInfo i_modelInfo;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_constructorParams;
      Tpl.Text l_algvars;
      Tpl.Text l_systemname;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)))),
           a_eq,
           a_context,
           a_useFlatArrayNotation )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        l_systemname = fun_566(Tpl.emptyTxt, a_context, l_modelname);
        l_algvars = MemberVariableAlgloop(Tpl.emptyTxt, i_modelInfo, a_useFlatArrayNotation);
        l_constructorParams = ConstructorParamAlgloop(Tpl.emptyTxt, i_modelInfo, a_useFlatArrayNotation);
        txt = fun_571(txt, a_eq, i_simCode, l_systemname, l_modelname);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end generateAlgloopClassDeclarationCode;

protected function smf_573
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_it;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_it, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           i_eq,
           a_simCode )
      equation
        txt = writeoutputAlgloopsolvers(txt, i_eq, a_simCode);
      then txt;
  end match;
end smf_573;

protected function lm_574
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqs;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eqs :: rest,
           a_simCode )
      equation
        txt = smf_573(txt, i_eqs, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_574(txt, rest, a_simCode);
      then txt;
  end match;
end lm_574;

protected function lm_575
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      SimCode.SimEqSystem i_eqn;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eqn :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = writeoutput3(txt, i_eqn, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_575(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_575;

protected function fun_576
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;
  input list<SimCode.SimEqSystem> in_a_allEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_useFlatArrayNotation, in_a_simCode, in_a_allEquations)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      list<SimCode.SimEqSystem> a_allEquations;

    case ( txt,
           false,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    SystemDefaultImplementation::getRHS(f);"));
      then txt;

    case ( txt,
           _,
           a_useFlatArrayNotation,
           a_simCode,
           a_allEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if(index == IContinuous::ALL_RESIDUES)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_574(txt, a_allEquations, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double residues [] = {"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_575(txt, a_allEquations, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "for(int i=0;i<"
                                }, false));
        txt = numResidues(txt, a_allEquations);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";i++) *(f+i) = residues[i];\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "else SystemDefaultImplementation::getRHS(f);"
                                }, false));
      then txt;
  end match;
end fun_576;

public function DefaultImplementationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<SimCode.SimEqSystem> i_allEquations;
      SimCode.SimCode i_simCode;
      list<SimCodeVar.SimVar> i_states;
      Absyn.Path i_modelInfo_name;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = i_states), name = i_modelInfo_name), allEquations = i_allEquations)),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  // Release instance\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::destroy()\n",
                                    "{\n",
                                    "    delete this;\n",
                                    "}\n",
                                    "\n",
                                    "// Set current integration time\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setTime(const double& t)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::setTime(t);\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimContinuousStates() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimContinuousStates());\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimBoolean() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimBoolean());\n",
                                    "}\n",
                                    "\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimInteger() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimInteger());\n",
                                    "}\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimReal() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimReal());\n",
                                    "}\n",
                                    "\n",
                                    "// Provide number (dimension) of variables according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimString() const\n",
                                    "{\n",
                                    "    return(SystemDefaultImplementation::getDimString());\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "// Provide number (dimension) of right hand sides (equations and/or residuals) according to the index\n",
                                    "int "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS() const\n",
                                    "{\n",
                                    "     return(SystemDefaultImplementation::getDimRHS());\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getContinuousStates(double* z)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::getContinuousStates(z);\n",
                                    "}\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getNominalStates(double* z)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = getNominalStateValues(txt, i_states, i_simCode, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "// Set variables with given index to the system\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setContinuousStates(const double* z)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::setContinuousStates(z);\n",
                                    "}\n",
                                    "\n",
                                    "// Provide the right hand side (according to the index)\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getRHS(double* f)\n",
                                    "{\n"
                                }, true));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_576(txt, ret_0, a_useFlatArrayNotation, i_simCode, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setRHS(const double* f)\n",
                                    "{\n",
                                    "    SystemDefaultImplementation::setRHS(f);\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isStepEvent()\n",
                                    "{\n",
                                    "    throw std::runtime_error(\"isStepEvent is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setTerminal(bool terminal)\n",
                                    "{\n",
                                    "   _terminal=terminal;\n",
                                    "}\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::terminal()\n",
                                    "{\n",
                                    "   return _terminal;\n",
                                    "}\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isAlgebraic()\n",
                                    "{\n",
                                    "  return false; // Indexreduction is enabled\n",
                                    "}\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "bool "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::provideSymbolicJacobian()\n",
                                    "{\n",
                                    "  throw std::runtime_error(\"provideSymbolicJacobian is not yet implemented\");\n",
                                    "}\n",
                                    "\n",
                                    "void "
                                }, false));
        txt = lastIdentOfPath(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::handleEvent(const bool* events)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = handleEvent(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end DefaultImplementationCode;

protected function fun_578
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominalValue;
  input Integer in_a_i0;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nominalValue, in_a_i0, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      Integer a_i0;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      DAE.Exp i_val;
      Tpl.Text l_value;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           SOME(i_val),
           a_i0,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        (l_value, l_preExp, l_varDecls) = daeExp(Tpl.emptyTxt, i_val, SimCode.contextOther, l_preExp, l_varDecls, a_simCode, a_useFlatArrayNotation);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeText(txt, l_varDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("z["));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]="));
        txt = Tpl.writeText(txt, l_value);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_i0,
           _,
           _ )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("z["));
        txt = Tpl.writeStr(txt, intString(a_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]=1.0;"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_578;

protected function lm_579
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_simCode)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode a_simCode;
      Integer x_i0;
      Option<DAE.Exp> i_nominalValue;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(nominalValue = i_nominalValue) :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = fun_578(txt, i_nominalValue, x_i0, a_useFlatArrayNotation, a_simCode);
        txt = Tpl.nextIter(txt);
        txt = lm_579(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;

    case ( txt,
           _ :: rest,
           a_useFlatArrayNotation,
           a_simCode )
      equation
        txt = lm_579(txt, rest, a_useFlatArrayNotation, a_simCode);
      then txt;
  end match;
end lm_579;

public function getNominalStateValues
  input Tpl.Text txt;
  input list<SimCodeVar.SimVar> a_stateVars;
  input SimCode.SimCode a_simCode;
  input Boolean a_useFlatArrayNotation;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_nominalVars;
algorithm
  l_nominalVars := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_nominalVars := lm_579(l_nominalVars, a_stateVars, a_useFlatArrayNotation, a_simCode);
  l_nominalVars := Tpl.popIter(l_nominalVars);
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeText(out_txt, l_nominalVars);
  out_txt := Tpl.popBlock(out_txt);
end getNominalStateValues;

protected function fun_581
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_useFlatArrayNotation;
  input SimCode.Context in_a_context;
  input SimCode.SimCode in_a_simCode;
  input Tpl.Text in_a_modelname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_useFlatArrayNotation, in_a_context, in_a_simCode, in_a_modelname)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      SimCode.Context a_context;
      SimCode.SimCode a_simCode;
      Tpl.Text a_modelname;
      SimCode.SimEqSystem i_eq;
      Integer i_index;

    case ( txt,
           (i_eq as SimCode.SES_LINEAR(index = i_index)),
           a_useFlatArrayNotation,
           a_context,
           a_simCode,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/// Provide number (dimension) of variables according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimReal() const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimReal());\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of residuals according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS( ) const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimRHS());\n",
                                    "};\n",
                                    "\n",
                                    "bool  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isConsistent( )\n",
                                    "{\n",
                                    "    return _system->isConsistent();\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getReal(double* vars)\n",
                                    "{\n",
                                    "\n",
                                    "    AlgLoopDefaultImplementation::getReal(vars);\n",
                                    "    //workaroud until names of algloop vars are replaced in simcode\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = giveAlgloopvars(txt, i_eq, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "/// Provide nominal variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getNominalReal(double* vars)\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = giveAlgloopNominalvars(txt, i_eq, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Set variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setReal(const double* vars)\n",
                                    "{\n",
                                    "\n",
                                    "    //workaround until names of algloop vars are replaced in simcode\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = setAlgloopvars(txt, i_eq, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("AlgLoopDefaultImplementation::setReal(vars);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Set stream for output\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setOutput(std::ostream* outputStream)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::setOutput(outputStream);\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           (i_eq as SimCode.SES_NONLINEAR(index = i_index)),
           a_useFlatArrayNotation,
           a_context,
           a_simCode,
           a_modelname )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/// Provide number (dimension) of variables according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimReal() const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimReal());\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide number (dimension) of residuals according to data type\n",
                                    "int  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getDimRHS( ) const\n",
                                    "{\n",
                                    "    return(AlgLoopDefaultImplementation::getDimRHS());\n",
                                    "};\n",
                                    "\n",
                                    "bool  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::isConsistent( )\n",
                                    "{\n",
                                    "    return _system->isConsistent();\n",
                                    "};\n",
                                    "\n",
                                    "/// Provide variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getReal(double* vars)\n",
                                    "{\n",
                                    "\n",
                                    "    AlgLoopDefaultImplementation::getReal(vars);\n",
                                    "    //workaroud until names of algloop vars are replaced in simcode\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = giveAlgloopvars(txt, i_eq, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "/// Provide nominal variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::getNominalReal(double* vars)\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(7));
        txt = giveAlgloopNominalvars(txt, i_eq, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Set variables with given index to the system\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setReal(const double* vars)\n",
                                    "{\n",
                                    "\n",
                                    "    //workaround until names of algloop vars are replaced in simcode\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = setAlgloopvars(txt, i_eq, a_simCode, a_context, a_useFlatArrayNotation);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("AlgLoopDefaultImplementation::setReal(vars);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "/// Set stream for output\n",
                                    "void  "
                                }, false));
        txt = Tpl.writeText(txt, a_modelname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Algloop"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "::setOutput(std::ostream* outputStream)\n",
                                    "{\n",
                                    "    AlgLoopDefaultImplementation::setOutput(outputStream);\n",
                                    "};"
                                }, false));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_581;

public function AlgloopDefaultImplementationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input SimCode.SimEqSystem in_a_eq;
  input SimCode.Context in_a_context;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_eq, in_a_context, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      SimCode.SimEqSystem a_eq;
      SimCode.Context a_context;
      Boolean a_useFlatArrayNotation;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_modelname;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))),
           a_eq,
           a_context,
           a_useFlatArrayNotation )
      equation
        l_modelname = lastIdentOfPath(Tpl.emptyTxt, i_modelInfo_name);
        txt = fun_581(txt, a_eq, a_useFlatArrayNotation, a_context, i_simCode, l_modelname);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end AlgloopDefaultImplementationCode;

protected function fun_583
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Returns labels for a labeled DAE\n",
                                    "virtual label_list_type getLabels();\n",
                                    "// Sets all algebraic and state varibales for current time\n",
                                    "virtual void setVariables(const ublas::vector<double>& variables, const ublas::vector<double>& variables2);"
                                }, false));
      then txt;
  end match;
end fun_583;

public function generateMethodDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/// Releases the Modelica System\n",
                                    "virtual void destroy();\n",
                                    "/// Provide number (dimension) of variables according to the index\n",
                                    "virtual int getDimContinuousStates() const;\n",
                                    "/// Provide number (dimension) of boolean variables\n",
                                    "virtual int getDimBoolean() const;\n",
                                    "/// Provide number (dimension) of integer variables\n",
                                    "virtual int getDimInteger() const;\n",
                                    "/// Provide number (dimension) of real variables\n",
                                    "virtual int getDimReal() const ;\n",
                                    "/// Provide number (dimension) of string variables\n",
                                    "virtual int getDimString() const ;\n",
                                    "/// Provide number (dimension) of right hand sides (equations and/or residuals) according to the index\n",
                                    "virtual int getDimRHS()const;\n",
                                    "\n",
                                    "//Resets all time events\n",
                                    "\n",
                                    "// Provide variables with given index to the system\n",
                                    "virtual void getContinuousStates(double* z);\n",
                                    "virtual void getNominalStates(double* z);\n",
                                    "// Set variables with given index to the system\n",
                                    "virtual void setContinuousStates(const double* z);\n",
                                    "\n",
                                    "// Update transfer behavior of the system of equations according to command given by solver\n",
                                    "virtual bool evaluateAll(const UPDATETYPE command = IContinuous::UNDEF_UPDATE);\n",
                                    "virtual void evaluateODE(const UPDATETYPE command = IContinuous::UNDEF_UPDATE);\n",
                                    "virtual void evaluateZeroFuncs(const UPDATETYPE command = IContinuous::UNDEF_UPDATE);\n",
                                    "virtual bool evaluateConditions(const UPDATETYPE command);\n",
                                    "\n",
                                    "// Provide the right hand side (according to the index)\n",
                                    "virtual void getRHS(double* f);\n",
                                    "\n",
                                    "virtual void setRHS(const double* f);\n",
                                    "\n",
                                    "//Provide number (dimension) of zero functions\n",
                                    "virtual int getDimZeroFunc();\n",
                                    "//Provides current values of root/zero functions\n",
                                    "virtual void getZeroFunc(double* f);\n",
                                    "virtual void setConditions(bool* c);\n",
                                    "virtual void getConditions(bool* c);\n",
                                    "\n",
                                    "\n",
                                    "\n",
                                    "//Called to handle an event\n",
                                    "virtual void handleEvent(const bool* events);\n",
                                    "//Checks if a discrete variable has changed and triggers an event\n",
                                    "virtual bool checkForDiscreteEvents();\n",
                                    "virtual bool isStepEvent();\n",
                                    "//sets the terminal status\n",
                                    "virtual void setTerminal(bool);\n",
                                    "//returns the terminal status\n",
                                    "virtual bool terminal();\n",
                                    "\n",
                                    "virtual void saveDiscreteVars();\n",
                                    "// M is regular\n",
                                    "virtual bool isODE();\n",
                                    "// M is singular\n",
                                    "virtual bool isAlgebraic();\n",
                                    "\n",
                                    "\n",
                                    "virtual int getDimTimeEvent() const;\n",
                                    "//gibt die Time events (Startzeit und Frequenz) zuruck\n",
                                    "virtual void getTimeEvent(time_event_type& time_events);\n",
                                    "//Wird vom Solver zur Behandlung der Time events aufgerufen (wenn zero_sign[i] = 0  kein time event,zero_sign[i] = n  Anzahl von vorgekommen time events )\n",
                                    "virtual void handleTimeEvent(int* time_events);\n",
                                    "/// Set current integration time\n",
                                    "virtual void setTime(const double& time);\n",
                                    "\n",
                                    "// System is able to provide the Jacobian symbolically\n",
                                    "virtual bool provideSymbolicJacobian();\n",
                                    "\n",
                                    "virtual bool stepCompleted(double time);\n",
                                    "\n",
                                    "virtual bool stepStarted(double time);\n",
                                    "\n"
                                }, true));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_583(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/// Provide boolean variables\n",
                                    "virtual void getBoolean(bool* z);\n",
                                    "/// Provide integer variables\n",
                                    "virtual void getInteger(int* z);\n",
                                    "/// Provide real variables\n",
                                    "virtual void getReal(double* z);\n",
                                    "/// Provide real variables\n",
                                    "virtual void getString(std::string* z);\n",
                                    "/// Provide boolean variables\n",
                                    "virtual void setBoolean(const bool* z);\n",
                                    "/// Provide integer variables\n",
                                    "virtual void setInteger(const int* z);\n",
                                    "/// Provide real variables\n",
                                    "virtual void setReal(const double* z);\n",
                                    "/// Provide real variables\n",
                                    "virtual void setString(const std::string* z);\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateMethodDeclarationCode;

protected function fun_585
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/// Provide dimensions of residuals for linear equation systems\n",
                                    "virtual int giveDimResiduals(int index);\n",
                                    "/// Provide the residuals for linear equation systems\n",
                                    "virtual void giveResiduals(double* vars);"
                                }, false));
      then txt;
  end match;
end fun_585;

public function generateAlgloopMethodDeclarationCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      Boolean ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    /// Provide number (dimension) of variables according to data type\n",
                                    "    virtual int getDimReal() const;\n",
                                    "    /// Provide number (dimension) of residuals according to data type\n",
                                    "    virtual int getDimRHS() const;\n",
                                    "     /// (Re-) initialize the system of equations\n",
                                    "    virtual void initialize();\n",
                                    "\n",
                                    "    template <typename T>\n",
                                    "    void initialize(T *__A);\n",
                                    "\n",
                                    "    /// Provide variables with given index to the system\n",
                                    "    virtual void getReal(double* vars);\n",
                                    "     /// Provide variables with given index to the system\n",
                                    "    virtual void getNominalReal(double* vars);\n",
                                    "    /// Set variables with given index to the system\n",
                                    "    virtual void setReal(const double* vars);\n",
                                    "    /// Update transfer behavior of the system of equations according to command given by solver\n",
                                    "    virtual void evaluate();\n",
                                    "    /// Provide the right hand side (according to the index)\n",
                                    "    virtual void getRHS(double* vars);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        ret_0 = Flags.isSet(Flags.WRITE_TO_BUFFER);
        txt = fun_585(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/// Output routine (to be called by the solver after every successful integration step)\n",
                                    "virtual void getSystemMatrix(double* A_matrix);\n",
                                    "virtual void getSystemMatrix(sparse_matrix* A_matrix);\n",
                                    "virtual bool isLinear();\n",
                                    "virtual bool isLinearTearing();\n",
                                    "virtual bool isConsistent();\n",
                                    "/// Set stream for output\n",
                                    "virtual void setOutput(std::ostream* outputStream);\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateAlgloopMethodDeclarationCode;

protected function lm_587
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine2(txt, i_var, "algebraics", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_587(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_587;

protected function lm_588
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine2(txt, i_var, "algebraics", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_588(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_588;

protected function lm_589
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine2(txt, i_var, "parameters", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_589(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_589;

protected function lm_590
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine2(txt, i_var, "aliasVars", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_590(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_590;

protected function lm_591
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.algebraics", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_591(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_591;

protected function lm_592
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.parameters", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_592(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_592;

protected function lm_593
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "int", i_var, "intVariables.AliasVars", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_593(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_593;

protected function lm_594
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "bool", i_var, "boolVariables.algebraics", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_594(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_594;

protected function lm_595
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "bool", i_var, "boolVariables.parameters", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_595(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_595;

protected function lm_596
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "bool ", i_var, "boolVariables.AliasVars", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_596(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_596;

protected function lm_597
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.algebraics", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_597(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_597;

protected function lm_598
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.parameters", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_598(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_598;

protected function lm_599
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "string", i_var, "stringVariables.AliasVars", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_599(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_599;

protected function lm_600
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefine(txt, "void*", i_var, "extObjVars", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_600(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_600;

public function MemberVariable
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<SimCodeVar.SimVar> i_vars_extObjVars;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, extObjVars = i_vars_extObjVars)),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_587(txt, i_vars_algVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_588(txt, i_vars_discreteAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_589(txt, i_vars_paramVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_590(txt, i_vars_aliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_591(txt, i_vars_intAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_592(txt, i_vars_intParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_593(txt, i_vars_intAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_594(txt, i_vars_boolAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_595(txt, i_vars_boolParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_596(txt, i_vars_boolAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_597(txt, i_vars_stringAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_598(txt, i_vars_stringParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_599(txt, i_vars_stringAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_600(txt, i_vars_extObjVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end MemberVariable;

public function VariableAliasDefinition
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      Integer i_index;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCodeVar.SIMVAR(varKind = BackendDAE.STATE(index = _), name = i_name, index = i_index),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" __z["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(varKind = BackendDAE.STATE_DER(), name = i_name, index = i_index),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = cref(txt, i_name, a_useFlatArrayNotation);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" __zDot["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end VariableAliasDefinition;

protected function lm_603
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "algebraics", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_603(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_603;

protected function fun_604
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_604;

protected function lm_605
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "algebraics", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_605(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_605;

protected function fun_606
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_discreteAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_discreteAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_606;

protected function lm_607
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "parameters", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_607(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_607;

protected function fun_608
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_608;

protected function lm_609
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "aliasVars", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_609(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_609;

protected function fun_610
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_610;

protected function lm_611
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.algebraics", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_611(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_611;

protected function fun_612
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_612;

protected function lm_613
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.parameters", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_613(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_613;

protected function fun_614
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_614;

protected function lm_615
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.AliasVars", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_615(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_615;

protected function fun_616
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_616;

protected function lm_617
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.algebraics", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_617(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_617;

protected function fun_618
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_618;

protected function lm_619
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.parameters", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_619(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_619;

protected function fun_620
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_620;

protected function lm_621
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "bool ", i_var, "boolVariables.AliasVars", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_621(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_621;

protected function fun_622
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_622;

protected function lm_623
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.algebraics", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_623(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_623;

protected function fun_624
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_624;

protected function lm_625
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.parameters", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_625(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_625;

protected function fun_626
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_626;

protected function lm_627
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.AliasVars", "", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_627(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_627;

protected function fun_628
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_628;

public function MemberVariableAlgloop
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_603(txt, i_vars_algVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_604(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_605(txt, i_vars_discreteAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_606(txt, i_vars_discreteAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_607(txt, i_vars_paramVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_608(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_609(txt, i_vars_aliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_610(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_611(txt, i_vars_intAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_612(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_613(txt, i_vars_intParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_614(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_615(txt, i_vars_intAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_616(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_617(txt, i_vars_boolAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_618(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_619(txt, i_vars_boolParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_620(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_621(txt, i_vars_boolAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_622(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_623(txt, i_vars_stringAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_624(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_625(txt, i_vars_stringParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_626(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(";\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_627(txt, i_vars_stringAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_628(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end MemberVariableAlgloop;

protected function lm_630
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "algebraics", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_630(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_630;

protected function fun_631
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_631;

protected function lm_632
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "algebraics", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_632(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_632;

protected function fun_633
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_discreteAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_discreteAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_633;

protected function lm_634
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "parameters", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_634(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_634;

protected function fun_635
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_635;

protected function lm_636
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference2(txt, i_var, "aliasVars", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_636(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_636;

protected function fun_637
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_637;

protected function lm_638
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.algebraics", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_638(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_638;

protected function fun_639
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_639;

protected function lm_640
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.parameters", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_640(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_640;

protected function fun_641
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_641;

protected function lm_642
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "int", i_var, "intVariables.AliasVars", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_642(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_642;

protected function fun_643
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_643;

protected function lm_644
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.algebraics", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_644(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_644;

protected function fun_645
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_645;

protected function lm_646
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "bool", i_var, "boolVariables.parameters", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_646(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_646;

protected function fun_647
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_647;

protected function lm_648
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "bool ", i_var, "boolVariables.AliasVars", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_648(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_648;

protected function fun_649
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_649;

protected function lm_650
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.algebraics", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_650(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_650;

protected function fun_651
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_651;

protected function lm_652
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.parameters", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_652(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_652;

protected function fun_653
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_653;

protected function lm_654
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = MemberVariableDefineReference(txt, "string", i_var, "stringVariables.AliasVars", "_", a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_654(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_654;

protected function fun_655
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_655;

public function ConstructorParamAlgloop
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_630(txt, i_vars_algVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_631(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_632(txt, i_vars_discreteAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_633(txt, i_vars_discreteAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_634(txt, i_vars_paramVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_635(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_636(txt, i_vars_aliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_637(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_638(txt, i_vars_intAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_639(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_640(txt, i_vars_intParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_641(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_642(txt, i_vars_intAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_643(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_644(txt, i_vars_boolAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_645(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_646(txt, i_vars_boolParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_647(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_648(txt, i_vars_boolAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_649(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_650(txt, i_vars_stringAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_651(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_652(txt, i_vars_stringParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_653(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_654(txt, i_vars_stringAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_655(txt, i_vars_stringAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end ConstructorParamAlgloop;

protected function lm_657
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_657(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_657;

protected function fun_658
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_658;

protected function lm_659
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_659(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_659;

protected function fun_660
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_discreteAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_discreteAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_660;

protected function lm_661
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_661(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_661;

protected function fun_662
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_662;

protected function lm_663
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_663(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_663;

protected function fun_664
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_664;

protected function lm_665
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_665(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_665;

protected function fun_666
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_666;

protected function lm_667
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_667(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_667;

protected function fun_668
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_668;

protected function lm_669
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_669(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_669;

protected function fun_670
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_670;

protected function lm_671
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_671(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_671;

protected function fun_672
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_672;

protected function lm_673
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_673(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_673;

protected function fun_674
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_674;

protected function lm_675
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_675(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_675;

protected function fun_676
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_676;

protected function lm_677
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_677(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_677;

protected function fun_678
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_678;

protected function lm_679
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_679(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_679;

protected function fun_680
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_680;

protected function lm_681
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation )
      equation
        txt = CallAlgloopParam(txt, i_var, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        txt = lm_681(txt, rest, a_useFlatArrayNotation);
      then txt;
  end match;
end lm_681;

protected function fun_682
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_682;

public function CallAlgloopParams
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Boolean a_useFlatArrayNotation;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)),
           a_useFlatArrayNotation )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_657(txt, i_vars_algVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_658(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_659(txt, i_vars_discreteAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_660(txt, i_vars_discreteAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_661(txt, i_vars_paramVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_662(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_663(txt, i_vars_aliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_664(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_665(txt, i_vars_intAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_666(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_667(txt, i_vars_intParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_668(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_669(txt, i_vars_intAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_670(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_671(txt, i_vars_boolAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_672(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_673(txt, i_vars_boolParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_674(txt, i_vars_boolParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_675(txt, i_vars_boolAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_676(txt, i_vars_boolAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_677(txt, i_vars_stringAlgVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_678(txt, i_vars_stringAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_679(txt, i_vars_stringParamVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_680(txt, i_vars_stringParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_681(txt, i_vars_stringAliasVars, a_useFlatArrayNotation);
        txt = Tpl.popIter(txt);
        txt = fun_682(txt, i_vars_stringAliasVars);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end CallAlgloopParams;

protected function lm_684
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "algebraics", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_684(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_684;

protected function fun_685
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_685;

protected function lm_686
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "algebraics", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_686(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_686;

protected function fun_687
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_discreteAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_discreteAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_687;

protected function lm_688
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "parameters", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_688(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_688;

protected function fun_689
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_689;

protected function lm_690
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "aliasVars", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_690(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_690;

protected function fun_691
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_aliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_aliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_691;

protected function lm_692
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intVariables.algebraics", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_692(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_692;

protected function fun_693
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_693;

protected function lm_694
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intVariables.parameters", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_694(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_694;

protected function fun_695
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_695;

protected function lm_696
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "intVariables.AliasVars", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_696(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_696;

protected function fun_697
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_intAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_intAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_697;

protected function lm_698
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolVariables.algebraics", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_698(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_698;

protected function fun_699
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_699;

protected function lm_700
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolVariables.parameters", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_700(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_700;

protected function fun_701
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_701;

protected function lm_702
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "boolVariables.AliasVars", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_702(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_702;

protected function fun_703
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_boolAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_boolAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_703;

protected function fun_704
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_704;

protected function lm_705
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringVariables.algebraics", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_705(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_705;

protected function fun_706
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringAlgVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAlgVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_706;

protected function lm_707
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringVariables.parameters", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_707(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_707;

protected function fun_708
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringParamVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringParamVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_708;

protected function lm_709
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_useFlatArrayNotation;
  input Tpl.Text in_a_arrayInit;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_items, in_a_useFlatArrayNotation, in_a_arrayInit)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_useFlatArrayNotation;
      Tpl.Text a_arrayInit;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           a_arrayInit )
      then (txt, a_arrayInit);

    case ( txt,
           i_var :: rest,
           a_useFlatArrayNotation,
           a_arrayInit )
      equation
        (txt, a_arrayInit) = InitAlgloopParam(txt, i_var, "stringVariables.AliasVars", a_arrayInit, a_useFlatArrayNotation);
        txt = Tpl.nextIter(txt);
        (txt, a_arrayInit) = lm_709(txt, rest, a_useFlatArrayNotation, a_arrayInit);
      then (txt, a_arrayInit);
  end match;
end lm_709;

protected function fun_710
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_a_vars_stringAliasVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_vars_stringAliasVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
      then txt;
  end match;
end fun_710;

public function InitAlgloopParams
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input Tpl.Text in_a_arrayInit;
  input Boolean in_a_useFlatArrayNotation;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_arrayInit;
algorithm
  (out_txt, out_a_arrayInit) :=
  match(in_txt, in_a_modelInfo, in_a_arrayInit, in_a_useFlatArrayNotation)
    local
      Tpl.Text txt;
      Tpl.Text a_arrayInit;
      Boolean a_useFlatArrayNotation;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)),
           a_arrayInit,
           a_useFlatArrayNotation )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  /* vars.algVars */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_684(txt, i_vars_algVars, a_useFlatArrayNotation, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_685(txt, i_vars_algVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* vars.discreteAlgVars */\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_686(txt, i_vars_discreteAlgVars, a_useFlatArrayNotation, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_687(txt, i_vars_discreteAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.paramVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_688(txt, i_vars_paramVars, a_useFlatArrayNotation, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_689(txt, i_vars_paramVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.aliasVars */\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_690(txt, i_vars_aliasVars, a_useFlatArrayNotation, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_691(txt, i_vars_aliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/* vars.intAlgVars */\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_692(txt, i_vars_intAlgVars, a_useFlatArrayNotation, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_693(txt, i_vars_intAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.intParamVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_694(txt, i_vars_intParamVars, a_useFlatArrayNotation, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_695(txt, i_vars_intParamVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.intAliasVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_696(txt, i_vars_intAliasVars, a_useFlatArrayNotation, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_697(txt, i_vars_intAliasVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.boolAlgVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayInit) = lm_698(txt, i_vars_boolAlgVars, a_useFlatArrayNotation, a_arrayInit);
        txt = Tpl.popIter(txt);
        txt = fun_699(txt, i_vars_boolAlgVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" /* vars.boolParamVars */\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, a_arrayI