encapsulated package CodegenFMU
"
  file:        CodegenFMU.mo
  package:     CodegenFMU
  description: Generated by Susan.
"

public import Tpl;

public import SimCodeVar;
public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import SCodeDump;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCodeMain;
public import HpcOmSimCode;
public import HpcOmMemory;
public import HpcOmScheduler;
public import CodegenUtil;
public import CodegenC;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_FMUVersion;
      SimCode.SimCode i_sc;
      list<String> i_sc_externalFunctionIncludes;
      list<SimCode.RecordDeclaration> i_recordDecls;
      list<SimCode.Function> i_modelInfo_functions;
      list<DAE.Exp> i_literals;
      String i_fileNamePrefix;
      Tpl.Text txt_30;
      Tpl.Text txt_29;
      Tpl.Text txt_28;
      Tpl.Text txt_27;
      Tpl.Text txt_26;
      Tpl.Text txt_25;
      Tpl.Text txt_24;
      Boolean ret_23;
      Tpl.Text txt_22;
      Tpl.Text txt_21;
      Tpl.Text l_x;
      Tpl.Text txt_19;
      Tpl.Text txt_18;
      Tpl.Text l_0__;
      Tpl.Text txt_16;
      Tpl.Text txt_15;
      Tpl.Text txt_14;
      Tpl.Text txt_13;
      Tpl.Text txt_12;
      Tpl.Text txt_11;
      Tpl.Text txt_10;
      Tpl.Text txt_9;
      Tpl.Text txt_8;
      Tpl.Text txt_7;
      Tpl.Text txt_6;
      Tpl.Text txt_5;
      Tpl.Text l_dummy;
      String ret_3;
      Tpl.Text l_target;
      String ret_1;
      Tpl.Text l_guid;

    case ( txt,
           (i_sc as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(functions = i_modelInfo_functions), fileNamePrefix = i_fileNamePrefix, literals = i_literals, recordDecls = i_recordDecls, externalFunctionIncludes = i_sc_externalFunctionIncludes)),
           a_FMUVersion )
      equation
        ret_1 = System.getUUIDStr();
        l_guid = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = Config.simulationCodeTarget();
        l_target = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        l_dummy = Tpl.emptyTxt;
        txt_5 = CodegenC.simulationLiteralsFile(Tpl.emptyTxt, i_fileNamePrefix, i_literals);
        txt_6 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_6 = Tpl.writeTok(txt_6, Tpl.ST_STRING("_literals.h"));
        Tpl.textFile(txt_5, Tpl.textString(txt_6));
        txt_7 = CodegenC.simulationFunctionsHeaderFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, i_recordDecls);
        txt_8 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_8 = Tpl.writeTok(txt_8, Tpl.ST_STRING("_functions.h"));
        Tpl.textFile(txt_7, Tpl.textString(txt_8));
        (txt_9, l_dummy) = CodegenC.simulationFunctionsFile(Tpl.emptyTxt, i_fileNamePrefix, i_modelInfo_functions, l_dummy);
        txt_10 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_10 = Tpl.writeTok(txt_10, Tpl.ST_STRING("_functions.c"));
        Tpl.textFile(txt_9, Tpl.textString(txt_10));
        txt_11 = CodegenC.externalFunctionIncludes(Tpl.emptyTxt, i_sc_externalFunctionIncludes);
        txt_12 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_12 = Tpl.writeTok(txt_12, Tpl.ST_STRING("_includes.h"));
        Tpl.textFile(txt_11, Tpl.textString(txt_12));
        txt_13 = CodegenC.recordsFile(Tpl.emptyTxt, i_fileNamePrefix, i_recordDecls);
        txt_14 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_14 = Tpl.writeTok(txt_14, Tpl.ST_STRING("_records.c"));
        Tpl.textFile(txt_13, Tpl.textString(txt_14));
        txt_15 = CodegenC.simulationHeaderFile(Tpl.emptyTxt, i_sc, Tpl.textString(l_guid));
        txt_16 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_16 = Tpl.writeTok(txt_16, Tpl.ST_STRING("_model.h"));
        Tpl.textFile(txt_15, Tpl.textString(txt_16));
        l_0__ = CodegenC.generateSimulationFiles(Tpl.emptyTxt, i_sc, Tpl.textString(l_guid), i_fileNamePrefix);
        txt_18 = CodegenC.simulationInitFile(Tpl.emptyTxt, i_sc, Tpl.textString(l_guid));
        txt_19 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_19 = Tpl.writeTok(txt_19, Tpl.ST_STRING("_init.xml"));
        Tpl.textFile(txt_18, Tpl.textString(txt_19));
        txt_21 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_21 = Tpl.writeTok(txt_21, Tpl.ST_STRING("_init.xml"));
        txt_22 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_22 = Tpl.writeTok(txt_22, Tpl.ST_STRING("_init.c"));
        ret_23 = System.covertTextFileToCLiteral(Tpl.textString(txt_21), Tpl.textString(txt_22));
        l_x = Tpl.writeStr(Tpl.emptyTxt, Tpl.booleanString(ret_23));
        txt_24 = fmumodel_identifierFile(Tpl.emptyTxt, i_sc, Tpl.textString(l_guid), a_FMUVersion);
        txt_25 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_25 = Tpl.writeTok(txt_25, Tpl.ST_STRING("_FMU.c"));
        Tpl.textFile(txt_24, Tpl.textString(txt_25));
        txt_26 = fmuModelDescriptionFile(Tpl.emptyTxt, i_sc, Tpl.textString(l_guid), a_FMUVersion);
        Tpl.textFile(txt_26, "modelDescription.xml");
        txt_27 = fmudeffile(Tpl.emptyTxt, i_sc, a_FMUVersion);
        txt_28 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_28 = Tpl.writeTok(txt_28, Tpl.ST_STRING(".def"));
        Tpl.textFile(txt_27, Tpl.textString(txt_28));
        txt_29 = fmuMakefile(Tpl.emptyTxt, Tpl.textString(l_target), i_sc, a_FMUVersion);
        txt_30 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_30 = Tpl.writeTok(txt_30, Tpl.ST_STRING("_FMU.makefile"));
        Tpl.textFile(txt_29, Tpl.textString(txt_30));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end translateModel;

protected function fun_38
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_guid;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_guid, in_a_simCode)
    local
      Tpl.Text txt;
      String a_guid;
      SimCode.SimCode a_simCode;

    case ( txt,
           false,
           a_guid,
           a_simCode )
      equation
        txt = fmiModelDescription(txt, a_simCode, a_guid);
      then txt;

    case ( txt,
           _,
           a_guid,
           a_simCode )
      equation
        txt = fmi2ModelDescription(txt, a_simCode, a_guid);
      then txt;
  end match;
end fun_38;

public function fmuModelDescriptionFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_guid;
      String a_FMUVersion;
      SimCode.SimCode i_simCode;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)),
           a_guid,
           a_FMUVersion )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"));
        ret_0 = stringEq(a_FMUVersion, "2.0");
        txt = fun_38(txt, ret_0, a_guid, i_simCode);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fmuModelDescriptionFile;

public function fmi2ModelDescription
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      list<SimCode.JacobianMatrix> i_jacobianMatrixes;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      SimCode.ModelInfo i_modelInfo;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = i_modelInfo, simulationSettingsOpt = i_simulationSettingsOpt, jacobianMatrixes = i_jacobianMatrixes)),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fmiModelDescription\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fmi2ModelDescriptionAttributes(txt, i_simCode, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = ModelExchange(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = TypeDefinitions(txt, i_modelInfo, "2.0");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<LogCategories>\n",
                                    "  <Category name=\"logEvents\" />\n",
                                    "  <Category name=\"logSingularLinearSystems\" />\n",
                                    "  <Category name=\"logNonlinearSystems\" />\n",
                                    "  <Category name=\"logDynamicStateSelection\" />\n",
                                    "  <Category name=\"logStatusWarning\" />\n",
                                    "  <Category name=\"logStatusDiscard\" />\n",
                                    "  <Category name=\"logStatusError\" />\n",
                                    "  <Category name=\"logStatusFatal\" />\n",
                                    "  <Category name=\"logStatusPending\" />\n",
                                    "  <Category name=\"logAll\" />\n",
                                    "  <Category name=\"logFmi2Call\" />\n",
                                    "</LogCategories>\n"
                                }, true));
        txt = DefaultExperiment(txt, i_simulationSettingsOpt);
        txt = Tpl.softNewLine(txt);
        txt = ModelVariables(txt, i_modelInfo, "2.0");
        txt = Tpl.softNewLine(txt);
        txt = ModelStructure(txt, i_simCode, i_jacobianMatrixes);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fmiModelDescription>"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmi2ModelDescription;

public function fmi2ModelDescriptionAttributes
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      Integer i_vi_numZeroCrossings;
      String i_modelInfo_description;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_numberOfEventIndicators;
      Tpl.Text l_variableNamingConvention;
      Util.DateTime ret_6;
      Tpl.Text l_generationDateAndTime;
      String ret_4;
      Tpl.Text l_generationTool;
      Tpl.Text l_description;
      Tpl.Text l_modelName;
      Tpl.Text l_fmiVersion;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = i_vi_numZeroCrossings), vars = SimCodeVar.SIMVARS(stateVars = _), name = i_modelInfo_name, description = i_modelInfo_description)),
           a_guid )
      equation
        l_fmiVersion = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("2.0"));
        l_modelName = CodegenUtil.dotPath(Tpl.emptyTxt, i_modelInfo_name);
        l_description = Tpl.writeStr(Tpl.emptyTxt, i_modelInfo_description);
        l_generationTool = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OpenModelica Compiler "));
        ret_4 = Settings.getVersionNr();
        l_generationTool = Tpl.writeStr(l_generationTool, ret_4);
        ret_6 = Util.getCurrentDateTime();
        l_generationDateAndTime = xsdateTime(Tpl.emptyTxt, ret_6);
        l_variableNamingConvention = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("structured"));
        l_numberOfEventIndicators = Tpl.writeStr(Tpl.emptyTxt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmiVersion=\""));
        txt = Tpl.writeText(txt, l_fmiVersion);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelName=\""
                                }, false));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "guid=\"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "description=\""
                                }, false));
        txt = Tpl.writeText(txt, l_description);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationTool=\""
                                }, false));
        txt = Tpl.writeText(txt, l_generationTool);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationDateAndTime=\""
                                }, false));
        txt = Tpl.writeText(txt, l_generationDateAndTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "variableNamingConvention=\""
                                }, false));
        txt = Tpl.writeText(txt, l_variableNamingConvention);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "numberOfEventIndicators=\""
                                }, false));
        txt = Tpl.writeText(txt, l_numberOfEventIndicators);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmi2ModelDescriptionAttributes;

public function ModelExchange
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode i_simCode;
      Tpl.Text l_modelIdentifier;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = _)) )
      equation
        l_modelIdentifier = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<ModelExchange\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("modelIdentifier=\""));
        txt = Tpl.writeText(txt, l_modelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</ModelExchange>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ModelExchange;

protected function fun_43
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;
      String ret_0;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("description=\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_comment);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_43;

public function ScalarVariableAttribute2
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      Option<DAE.Exp> i_initialValue;
      Boolean i_isValueChangeable;
      SimCodeVar.Causality i_causality;
      BackendDAE.VarKind i_varKind;
      String i_comment;
      String ret_7;
      Tpl.Text txt_6;
      Tpl.Text l_initial;
      Tpl.Text l_caus;
      Tpl.Text l_variability;
      Tpl.Text l_description;
      Integer ret_1;
      Tpl.Text l_valueReference;

    case ( txt,
           SimCodeVar.SIMVAR(comment = i_comment, varKind = i_varKind, causality = i_causality, isValueChangeable = i_isValueChangeable, initialValue = i_initialValue, name = i_name) )
      equation
        ret_1 = System.tmpTick();
        l_valueReference = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_description = fun_43(Tpl.emptyTxt, i_comment);
        l_variability = getVariability2(Tpl.emptyTxt, i_varKind);
        l_caus = getCausality2(Tpl.emptyTxt, i_causality, i_varKind, i_isValueChangeable);
        l_initial = hasStartValue(Tpl.emptyTxt, i_varKind, i_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("name=\""));
        txt_6 = CodegenUtil.crefStrNoUnderscore(Tpl.emptyTxt, i_name);
        ret_7 = System.stringReplace(Tpl.textString(txt_6), "$", "_D_");
        txt = Tpl.writeStr(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "valueReference=\""
                                }, false));
        txt = Tpl.writeText(txt, l_valueReference);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"\n"));
        txt = Tpl.writeText(txt, l_description);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("variability=\""));
        txt = Tpl.writeText(txt, l_variability);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "causality=\""
                                }, false));
        txt = Tpl.writeText(txt, l_caus);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "initial=\""
                                }, false));
        txt = Tpl.writeText(txt, l_initial);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableAttribute2;

public function getVariability2
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind)
    local
      Tpl.Text txt;

    case ( txt,
           BackendDAE.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete"));
      then txt;

    case ( txt,
           BackendDAE.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fixed"));
      then txt;

    case ( txt,
           BackendDAE.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("continuous"));
      then txt;
  end match;
end getVariability2;

public function getCausality2
  input Tpl.Text in_txt;
  input SimCodeVar.Causality in_a_c;
  input BackendDAE.VarKind in_a_varKind;
  input Boolean in_a_isValueChangeable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c, in_a_varKind, in_a_isValueChangeable)
    local
      Tpl.Text txt;
      BackendDAE.VarKind a_varKind;
      Boolean a_isValueChangeable;

    case ( txt,
           SimCodeVar.NONECAUS(),
           a_varKind,
           a_isValueChangeable )
      equation
        txt = getCausality2Helper(txt, a_varKind, a_isValueChangeable);
      then txt;

    case ( txt,
           SimCodeVar.INTERNAL(),
           a_varKind,
           a_isValueChangeable )
      equation
        txt = getCausality2Helper(txt, a_varKind, a_isValueChangeable);
      then txt;

    case ( txt,
           SimCodeVar.OUTPUT(),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output"));
      then txt;

    case ( txt,
           SimCodeVar.INPUT(),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("local"));
      then txt;
  end match;
end getCausality2;

protected function fun_47
  input Tpl.Text in_txt;
  input Boolean in_a_isValueChangeable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_isValueChangeable)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("calculatedParameter"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter"));
      then txt;
  end match;
end fun_47;

public function getCausality2Helper
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;
  input Boolean in_a_isValueChangeable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind, in_a_isValueChangeable)
    local
      Tpl.Text txt;
      Boolean a_isValueChangeable;

    case ( txt,
           BackendDAE.PARAM(),
           a_isValueChangeable )
      equation
        txt = fun_47(txt, a_isValueChangeable);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("local"));
      then txt;
  end match;
end getCausality2Helper;

protected function fun_49
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;

    case ( txt,
           SOME(_) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("exact"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("calculated"));
      then txt;
  end match;
end fun_49;

public function hasStartValue
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind, in_a_initialValue)
    local
      Tpl.Text txt;
      Option<DAE.Exp> a_initialValue;

    case ( txt,
           BackendDAE.STATE_DER(),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("calculated"));
      then txt;

    case ( txt,
           _,
           a_initialValue )
      equation
        txt = fun_49(txt, a_initialValue);
      then txt;
  end match;
end hasStartValue;

protected function fun_51
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input list<SimCodeVar.SimVar> in_a_stateVars;
  input Option<DAE.Exp> in_a_initialValue;
  input BackendDAE.VarKind in_a_varKind;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_stateVars, in_a_initialValue, in_a_varKind, in_a_index)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> a_stateVars;
      Option<DAE.Exp> a_initialValue;
      BackendDAE.VarKind a_varKind;
      Integer a_index;
      Absyn.Path i_path;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           _,
           a_initialValue,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Integer"));
        txt = ScalarVariableTypeCommonAttribute2(txt, a_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_stateVars,
           a_initialValue,
           a_varKind,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Real"));
        txt = RealVariableTypeCommonAttribute2(txt, a_stateVars, a_initialValue, a_varKind, a_index);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           _,
           a_initialValue,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Boolean"));
        txt = ScalarVariableTypeCommonAttribute2(txt, a_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           _,
           a_initialValue,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<String"));
        txt = StringVariableTypeCommonAttribute2(txt, a_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(path = i_path),
           _,
           a_initialValue,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Enumeration declaredType=\""));
        ret_0 = Absyn.pathString2NoLeadingDot(i_path, ".");
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = ScalarVariableTypeCommonAttribute2(txt, a_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKOWN_TYPE"));
      then txt;
  end match;
end fun_51;

public function ScalarVariableType2
  input Tpl.Text txt;
  input list<SimCodeVar.SimVar> a_stateVars;
  input DAE.Type a_type__;
  input String a_unit;
  input String a_displayUnit;
  input Option<DAE.Exp> a_initialValue;
  input BackendDAE.VarKind a_varKind;
  input Integer a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_51(txt, a_type__, a_stateVars, a_initialValue, a_varKind, a_index);
end ScalarVariableType2;

public function StartString2
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.ICONST(integer = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.RCONST(real = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.SCONST(string = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.BCONST(bool = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.ENUM_LITERAL(name = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end StartString2;

public function ScalarVariableTypeCommonAttribute2
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = StartString2(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableTypeCommonAttribute2;

protected function fun_55
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = StartString2(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_55;

protected function fun_56
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;
  input list<SimCodeVar.SimVar> in_a_stateVars;
  input Option<DAE.Exp> in_a_initialValue;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind, in_a_stateVars, in_a_initialValue, in_a_index)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> a_stateVars;
      Option<DAE.Exp> a_initialValue;
      Integer a_index;
      Integer ret_0;

    case ( txt,
           BackendDAE.STATE_DER(),
           a_stateVars,
           _,
           a_index )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("derivative=\""));
        ret_0 = SimCodeUtil.getStateSimVarIndexFromIndex(a_stateVars, a_index);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           a_initialValue,
           _ )
      equation
        txt = fun_55(txt, a_initialValue);
      then txt;
  end match;
end fun_56;

public function RealVariableTypeCommonAttribute2
  input Tpl.Text txt;
  input list<SimCodeVar.SimVar> a_stateVars;
  input Option<DAE.Exp> a_initialValue;
  input BackendDAE.VarKind a_varKind;
  input Integer a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_56(txt, a_varKind, a_stateVars, a_initialValue, a_index);
end RealVariableTypeCommonAttribute2;

public function StringVariableTypeCommonAttribute2
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start="));
        txt = initVal(txt, i_exp);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end StringVariableTypeCommonAttribute2;

public function fmiModelDescription
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      SimCode.ModelInfo i_modelInfo;
      SimCode.SimCode i_simCode;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = i_modelInfo, simulationSettingsOpt = i_simulationSettingsOpt)),
           a_guid )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<fmiModelDescription\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fmiModelDescriptionAttributes(txt, i_simCode, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = TypeDefinitions(txt, i_modelInfo, "1.0");
        txt = Tpl.softNewLine(txt);
        txt = DefaultExperiment(txt, i_simulationSettingsOpt);
        txt = Tpl.softNewLine(txt);
        txt = ModelVariables(txt, i_modelInfo, "1.0");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</fmiModelDescription>"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmiModelDescription;

protected function fun_60
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCodeVar.SimVar> in_a_listStates;
  input Integer in_a_vi_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_listStates, in_a_vi_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> a_listStates;
      Integer a_vi_numStateVars;

    case ( txt,
           false,
           _,
           a_vi_numStateVars )
      equation
        txt = Tpl.writeStr(txt, intString(a_vi_numStateVars));
      then txt;

    case ( txt,
           _,
           a_listStates,
           _ )
      equation
        txt = statesnumwithDummy(txt, a_listStates);
      then txt;
  end match;
end fun_60;

public function fmiModelDescriptionAttributes
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid)
    local
      Tpl.Text txt;
      String a_guid;
      Integer i_vi_numZeroCrossings;
      list<SimCodeVar.SimVar> i_listStates;
      Integer i_vi_numStateVars;
      String i_modelInfo_description;
      SimCode.SimCode i_simCode;
      Absyn.Path i_modelInfo_name;
      Tpl.Text l_numberOfEventIndicators;
      Boolean ret_10;
      Tpl.Text l_numberOfContinuousStates;
      Tpl.Text l_variableNamingConvention;
      Util.DateTime ret_7;
      Tpl.Text l_generationDateAndTime;
      String ret_5;
      Tpl.Text l_generationTool;
      Tpl.Text l_description;
      Tpl.Text l_modelIdentifier;
      Tpl.Text l_modelName;
      Tpl.Text l_fmiVersion;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_vi_numStateVars, numZeroCrossings = i_vi_numZeroCrossings), vars = SimCodeVar.SIMVARS(stateVars = i_listStates), name = i_modelInfo_name, description = i_modelInfo_description))),
           a_guid )
      equation
        l_fmiVersion = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("1.0"));
        l_modelName = CodegenUtil.dotPath(Tpl.emptyTxt, i_modelInfo_name);
        l_modelIdentifier = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        l_description = Tpl.writeStr(Tpl.emptyTxt, i_modelInfo_description);
        l_generationTool = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("OpenModelica Compiler "));
        ret_5 = Settings.getVersionNr();
        l_generationTool = Tpl.writeStr(l_generationTool, ret_5);
        ret_7 = Util.getCurrentDateTime();
        l_generationDateAndTime = xsdateTime(Tpl.emptyTxt, ret_7);
        l_variableNamingConvention = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("structured"));
        ret_10 = intEq(i_vi_numStateVars, 1);
        l_numberOfContinuousStates = fun_60(Tpl.emptyTxt, ret_10, i_listStates, i_vi_numStateVars);
        l_numberOfEventIndicators = Tpl.writeStr(Tpl.emptyTxt, intString(i_vi_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmiVersion=\""));
        txt = Tpl.writeText(txt, l_fmiVersion);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelName=\""
                                }, false));
        txt = Tpl.writeText(txt, l_modelName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "modelIdentifier=\""
                                }, false));
        txt = Tpl.writeText(txt, l_modelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "guid=\"{"
                                }, false));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "description=\""
                                }, false));
        txt = Tpl.writeText(txt, l_description);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationTool=\""
                                }, false));
        txt = Tpl.writeText(txt, l_generationTool);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "generationDateAndTime=\""
                                }, false));
        txt = Tpl.writeText(txt, l_generationDateAndTime);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "variableNamingConvention=\""
                                }, false));
        txt = Tpl.writeText(txt, l_variableNamingConvention);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "numberOfContinuousStates=\""
                                }, false));
        txt = Tpl.writeText(txt, l_numberOfContinuousStates);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "numberOfEventIndicators=\""
                                }, false));
        txt = Tpl.writeText(txt, l_numberOfEventIndicators);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmiModelDescriptionAttributes;

protected function fun_62
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;
  end match;
end fun_62;

protected function fun_63
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_62(txt, ret_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_63;

protected function lm_64
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = fun_63(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest);
      then txt;
  end match;
end lm_64;

public function statesnumwithDummy
  input Tpl.Text txt;
  input list<SimCodeVar.SimVar> a_vars;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_64(out_txt, a_vars);
  out_txt := Tpl.popIter(out_txt);
end statesnumwithDummy;

public function xsdateTime
  input Tpl.Text in_txt;
  input Util.DateTime in_a_dt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dt)
    local
      Tpl.Text txt;
      Integer i_sec;
      Integer i_min;
      Integer i_hour;
      Integer i_mday;
      Integer i_mon;
      Integer i_year;
      String ret_4;
      String ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           Util.DATETIME(year = i_year, mon = i_mon, mday = i_mday, hour = i_hour, min = i_min, sec = i_sec) )
      equation
        txt = Tpl.writeStr(txt, intString(i_year));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_0 = SimCodeUtil.twodigit(i_mon);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        ret_1 = SimCodeUtil.twodigit(i_mday);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("T"));
        ret_2 = SimCodeUtil.twodigit(i_hour);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_3 = SimCodeUtil.twodigit(i_min);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(":"));
        ret_4 = SimCodeUtil.twodigit(i_sec);
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Z"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end xsdateTime;

public function UnitDefinitions
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<UnitDefinitions>\n",
                                    "</UnitDefinitions>"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end UnitDefinitions;

protected function lm_68
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion )
      equation
        txt = TypeDefinition(txt, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest, a_FMUVersion);
      then txt;
  end match;
end lm_68;

public function TypeDefinitions
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_FMUVersion;
      SimCodeVar.SimVars i_vars;
      list<SimCodeVar.SimVar> ret_0;

    case ( txt,
           SimCode.MODELINFO(vars = (i_vars as SimCodeVar.SIMVARS(stateVars = _))),
           a_FMUVersion )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<TypeDefinitions>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_0 = SimCodeUtil.getEnumerationTypes(i_vars);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_68(txt, ret_0, a_FMUVersion);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</TypeDefinitions>"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end TypeDefinitions;

public function TypeDefinition
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_FMUVersion;
      DAE.Type i_type__;

    case ( txt,
           SimCodeVar.SIMVAR(type_ = i_type__),
           a_FMUVersion )
      equation
        txt = TypeDefinitionType(txt, i_type__, a_FMUVersion);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end TypeDefinition;

protected function lm_71
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Item name=\""));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_71(txt, rest);
      then txt;
  end match;
end lm_71;

protected function lm_72
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      Integer x_i0;
      String i_name;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_name :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Item name=\""));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" value=\""));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;
  end match;
end lm_72;

protected function fun_73
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<String> in_a_names;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_names, in_a_path)
    local
      Tpl.Text txt;
      list<String> a_names;
      Absyn.Path a_path;
      String ret_1;
      String ret_0;

    case ( txt,
           false,
           a_names,
           a_path )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Type name=\""));
        ret_0 = Absyn.pathString2NoLeadingDot(a_path, ".");
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <EnumerationType>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_71(txt, a_names);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </EnumerationType>\n",
                                    "</Type>"
                                }, false));
      then txt;

    case ( txt,
           _,
           a_names,
           a_path )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<SimpleType name=\""));
        ret_1 = Absyn.pathString2NoLeadingDot(a_path, ".");
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "  <Enumeration>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_72(txt, a_names);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </Enumeration>\n",
                                    "</SimpleType>"
                                }, false));
      then txt;
  end match;
end fun_73;

public function TypeDefinitionType
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_FMUVersion;
      list<String> i_names;
      Absyn.Path i_path;
      Boolean ret_0;

    case ( txt,
           DAE.T_ENUMERATION(path = i_path, names = i_names),
           a_FMUVersion )
      equation
        ret_0 = stringEq(a_FMUVersion, "2.0");
        txt = fun_73(txt, ret_0, i_names, i_path);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end TypeDefinitionType;

public function DefaultExperiment
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettingsOpt)
    local
      Tpl.Text txt;
      SimCode.SimulationSettings i_v;

    case ( txt,
           SOME(i_v) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<DefaultExperiment "));
        txt = DefaultExperimentAttribute(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end DefaultExperiment;

public function DefaultExperimentAttribute
  input Tpl.Text in_txt;
  input SimCode.SimulationSettings in_a_simulationSettings;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettings)
    local
      Tpl.Text txt;
      Real i_tolerance;
      Real i_stopTime;
      Real i_startTime;

    case ( txt,
           SimCode.SIMULATION_SETTINGS(startTime = i_startTime, stopTime = i_stopTime, tolerance = i_tolerance) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("startTime=\""));
        txt = Tpl.writeStr(txt, realString(i_startTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" stopTime=\""));
        txt = Tpl.writeStr(txt, realString(i_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" tolerance=\""));
        txt = Tpl.writeStr(txt, realString(i_tolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end DefaultExperimentAttribute;

public function VendorAnnotations
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<VendorAnnotations>\n",
                                    "</VendorAnnotations>"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end VendorAnnotations;

protected function lm_78
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_78;

protected function lm_79
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_79(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_79;

protected function lm_80
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_80;

protected function lm_81
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_81(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_81;

protected function lm_82
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_82(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_82;

protected function lm_83
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_83(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_83;

protected function lm_84
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_84;

protected function lm_85
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_85(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_85;

protected function lm_86
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_86;

protected function lm_87
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_87(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_87;

protected function lm_88
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_88(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_88;

protected function lm_89
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_89(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_89;

protected function lm_90
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_90(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_90;

protected function lm_91
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_91(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_91;

protected function lm_92
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input String in_a_FMUVersion;
  input list<SimCodeVar.SimVar> in_a_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_FMUVersion, in_a_stateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      String a_FMUVersion;
      list<SimCodeVar.SimVar> a_stateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_FMUVersion,
           a_stateVars )
      equation
        txt = ScalarVariable(txt, a_stateVars, i_var, a_FMUVersion);
        txt = Tpl.nextIter(txt);
        txt = lm_92(txt, rest, a_FMUVersion, a_stateVars);
      then txt;
  end match;
end lm_92;

public function ModelVariables
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_FMUVersion;
      SimCode.ModelInfo i_modelInfo;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_stateVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;

    case ( txt,
           (i_modelInfo as SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = (i_vars_stateVars as i_stateVars), derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars))),
           a_FMUVersion )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<ModelVariables>\n"));
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_78(txt, i_vars_stateVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_79(txt, i_vars_derivativeVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_80(txt, i_vars_algVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_81(txt, i_vars_discreteAlgVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_82(txt, i_vars_paramVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_83(txt, i_vars_aliasVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_84(txt, i_vars_intAlgVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_85(txt, i_vars_intParamVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_86(txt, i_vars_intAliasVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_87(txt, i_vars_boolAlgVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_88(txt, i_vars_boolParamVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_89(txt, i_vars_boolAliasVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_90(txt, i_vars_stringAlgVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_91(txt, i_vars_stringParamVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_92(txt, i_vars_stringAliasVars, a_FMUVersion, i_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = externalFunctions(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</ModelVariables>"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end ModelVariables;

protected function fun_94
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;
  input BackendDAE.VarKind in_a_varKind;
  input list<SimCodeVar.SimVar> in_a_stateVars;
  input Boolean in_a_isFixed;
  input Option<DAE.Exp> in_a_initialValue;
  input String in_a_displayUnit;
  input String in_a_unit;
  input DAE.Type in_a_type__;
  input SimCodeVar.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index, in_a_varKind, in_a_stateVars, in_a_isFixed, in_a_initialValue, in_a_displayUnit, in_a_unit, in_a_type__, in_a_simVar)
    local
      Tpl.Text txt;
      Integer a_index;
      BackendDAE.VarKind a_varKind;
      list<SimCodeVar.SimVar> a_stateVars;
      Boolean a_isFixed;
      Option<DAE.Exp> a_initialValue;
      String a_displayUnit;
      String a_unit;
      DAE.Type a_type__;
      SimCodeVar.SimVar a_simVar;
      Integer ret_0;

    case ( txt,
           false,
           _,
           _,
           _,
           a_isFixed,
           a_initialValue,
           a_displayUnit,
           a_unit,
           a_type__,
           a_simVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<ScalarVariable\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = ScalarVariableAttribute(txt, a_simVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = ScalarVariableType(txt, a_type__, a_unit, a_displayUnit, a_initialValue, a_isFixed);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</ScalarVariable>"));
      then txt;

    case ( txt,
           _,
           a_index,
           a_varKind,
           a_stateVars,
           _,
           a_initialValue,
           a_displayUnit,
           a_unit,
           a_type__,
           a_simVar )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<!-- Index of variable = \""));
        ret_0 = SimCodeUtil.getVariableIndex(a_simVar);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" -->\n",
                                    "<ScalarVariable\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = ScalarVariableAttribute2(txt, a_simVar);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = ScalarVariableType2(txt, a_stateVars, a_type__, a_unit, a_displayUnit, a_initialValue, a_varKind, a_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</ScalarVariable>"));
      then txt;
  end match;
end fun_94;

protected function fun_95
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;
  input BackendDAE.VarKind in_a_varKind;
  input list<SimCodeVar.SimVar> in_a_stateVars;
  input Boolean in_a_isFixed;
  input Option<DAE.Exp> in_a_initialValue;
  input String in_a_displayUnit;
  input String in_a_unit;
  input DAE.Type in_a_type__;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index, in_a_varKind, in_a_stateVars, in_a_isFixed, in_a_initialValue, in_a_displayUnit, in_a_unit, in_a_type__, in_a_simVar, in_a_FMUVersion)
    local
      Tpl.Text txt;
      Integer a_index;
      BackendDAE.VarKind a_varKind;
      list<SimCodeVar.SimVar> a_stateVars;
      Boolean a_isFixed;
      Option<DAE.Exp> a_initialValue;
      String a_displayUnit;
      String a_unit;
      DAE.Type a_type__;
      SimCodeVar.SimVar a_simVar;
      String a_FMUVersion;
      Boolean ret_0;

    case ( txt,
           false,
           a_index,
           a_varKind,
           a_stateVars,
           a_isFixed,
           a_initialValue,
           a_displayUnit,
           a_unit,
           a_type__,
           a_simVar,
           a_FMUVersion )
      equation
        ret_0 = stringEq(a_FMUVersion, "2.0");
        txt = fun_94(txt, ret_0, a_index, a_varKind, a_stateVars, a_isFixed, a_initialValue, a_displayUnit, a_unit, a_type__, a_simVar);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_95;

protected function fun_96
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_index;
  input BackendDAE.VarKind in_a_varKind;
  input list<SimCodeVar.SimVar> in_a_stateVars;
  input Boolean in_a_isFixed;
  input Option<DAE.Exp> in_a_initialValue;
  input String in_a_displayUnit;
  input String in_a_unit;
  input DAE.Type in_a_type__;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_FMUVersion;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_index, in_a_varKind, in_a_stateVars, in_a_isFixed, in_a_initialValue, in_a_displayUnit, in_a_unit, in_a_type__, in_a_simVar, in_a_FMUVersion, in_a_name)
    local
      Tpl.Text txt;
      Integer a_index;
      BackendDAE.VarKind a_varKind;
      list<SimCodeVar.SimVar> a_stateVars;
      Boolean a_isFixed;
      Option<DAE.Exp> a_initialValue;
      String a_displayUnit;
      String a_unit;
      DAE.Type a_type__;
      SimCodeVar.SimVar a_simVar;
      String a_FMUVersion;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_index,
           a_varKind,
           a_stateVars,
           a_isFixed,
           a_initialValue,
           a_displayUnit,
           a_unit,
           a_type__,
           a_simVar,
           a_FMUVersion,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_95(txt, ret_1, a_index, a_varKind, a_stateVars, a_isFixed, a_initialValue, a_displayUnit, a_unit, a_type__, a_simVar, a_FMUVersion);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_96;

protected function fun_97
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input list<SimCodeVar.SimVar> in_a_stateVars;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_stateVars, in_a_FMUVersion)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> a_stateVars;
      String a_FMUVersion;
      Integer i_index;
      BackendDAE.VarKind i_varKind;
      Boolean i_isFixed;
      Option<DAE.Exp> i_initialValue;
      String i_displayUnit;
      String i_unit;
      DAE.Type i_type__;
      SimCodeVar.SimVar i_simVar;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simVar as SimCodeVar.SIMVAR(name = i_name, type_ = i_type__, unit = i_unit, displayUnit = i_displayUnit, initialValue = i_initialValue, isFixed = i_isFixed, varKind = i_varKind, index = i_index)),
           a_stateVars,
           a_FMUVersion )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_96(txt, ret_1, i_index, i_varKind, a_stateVars, i_isFixed, i_initialValue, i_displayUnit, i_unit, i_type__, i_simVar, a_FMUVersion, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_97;

public function ScalarVariable
  input Tpl.Text txt;
  input list<SimCodeVar.SimVar> a_stateVars;
  input SimCodeVar.SimVar a_simVar;
  input String a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_97(txt, a_simVar, a_stateVars, a_FMUVersion);
end ScalarVariable;

protected function fun_99
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;
      String ret_0;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("description=\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_comment);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_99;

public function ScalarVariableAttribute
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      SimCodeVar.Causality i_causality;
      SimCodeVar.AliasVariable i_aliasvar;
      String i_comment;
      BackendDAE.VarKind i_varKind;
      String ret_7;
      Tpl.Text txt_6;
      Tpl.Text l_caus;
      Tpl.Text l_alias;
      Tpl.Text l_description;
      Tpl.Text l_variability;
      Integer ret_1;
      Tpl.Text l_valueReference;

    case ( txt,
           SimCodeVar.SIMVAR(varKind = i_varKind, comment = i_comment, aliasvar = i_aliasvar, causality = i_causality, name = i_name) )
      equation
        ret_1 = System.tmpTick();
        l_valueReference = Tpl.writeStr(Tpl.emptyTxt, intString(ret_1));
        l_variability = getVariability(Tpl.emptyTxt, i_varKind);
        l_description = fun_99(Tpl.emptyTxt, i_comment);
        l_alias = getAliasVar(Tpl.emptyTxt, i_aliasvar);
        l_caus = getCausality(Tpl.emptyTxt, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("name=\""));
        txt_6 = CodegenUtil.crefStrNoUnderscore(Tpl.emptyTxt, i_name);
        ret_7 = System.stringReplace(Tpl.textString(txt_6), "$", "_D_");
        txt = Tpl.writeStr(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "valueReference=\""
                                }, false));
        txt = Tpl.writeText(txt, l_valueReference);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\"\n"));
        txt = Tpl.writeText(txt, l_description);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("variability=\""));
        txt = Tpl.writeText(txt, l_variability);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "causality=\""
                                }, false));
        txt = Tpl.writeText(txt, l_caus);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "alias=\""
                                }, false));
        txt = Tpl.writeText(txt, l_alias);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableAttribute;

public function getCausality
  input Tpl.Text in_txt;
  input SimCodeVar.Causality in_a_c;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_c)
    local
      Tpl.Text txt;

    case ( txt,
           SimCodeVar.NONECAUS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("none"));
      then txt;

    case ( txt,
           SimCodeVar.INTERNAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("internal"));
      then txt;

    case ( txt,
           SimCodeVar.OUTPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output"));
      then txt;

    case ( txt,
           SimCodeVar.INPUT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getCausality;

public function getVariability
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind)
    local
      Tpl.Text txt;

    case ( txt,
           BackendDAE.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete"));
      then txt;

    case ( txt,
           BackendDAE.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter"));
      then txt;

    case ( txt,
           BackendDAE.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("continuous"));
      then txt;
  end match;
end getVariability;

public function getAliasVar
  input Tpl.Text in_txt;
  input SimCodeVar.AliasVariable in_a_aliasvar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar)
    local
      Tpl.Text txt;

    case ( txt,
           SimCodeVar.NOALIAS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("noAlias"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("noAlias"));
      then txt;
  end match;
end getAliasVar;

protected function fun_104
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input Option<DAE.Exp> in_a_initialValue;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_initialValue, in_a_isFixed)
    local
      Tpl.Text txt;
      Option<DAE.Exp> a_initialValue;
      Boolean a_isFixed;
      Absyn.Path i_path;
      String ret_0;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Integer"));
        txt = ScalarVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Real"));
        txt = ScalarVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Boolean"));
        txt = ScalarVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<String"));
        txt = StringVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(path = i_path),
           a_initialValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Enumeration declaredType=\""));
        ret_0 = Absyn.pathString2NoLeadingDot(i_path, ".");
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = ScalarVariableTypeCommonAttribute(txt, a_initialValue, a_isFixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/>"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKOWN_TYPE"));
      then txt;
  end match;
end fun_104;

public function ScalarVariableType
  input Tpl.Text txt;
  input DAE.Type a_type__;
  input String a_unit;
  input String a_displayUnit;
  input Option<DAE.Exp> a_initialValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_104(txt, a_type__, a_initialValue, a_isFixed);
end ScalarVariableType;

public function StartString
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp, in_a_isFixed)
    local
      Tpl.Text txt;
      Boolean a_isFixed;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.ICONST(integer = _)),
           a_isFixed )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" fixed=\""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.RCONST(real = _)),
           a_isFixed )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" fixed=\""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.SCONST(string = _)),
           a_isFixed )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" fixed=\""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.BCONST(bool = _)),
           a_isFixed )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" fixed=\""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.ENUM_LITERAL(name = _)),
           a_isFixed )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = CodegenUtil.initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" fixed=\""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end StartString;

public function ScalarVariableTypeCommonAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_isFixed)
    local
      Tpl.Text txt;
      Boolean a_isFixed;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_isFixed )
      equation
        txt = StartString(txt, i_exp, a_isFixed);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end ScalarVariableTypeCommonAttribute;

public function StringVariableTypeCommonAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_isFixed)
    local
      Tpl.Text txt;
      Boolean a_isFixed;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp),
           a_isFixed )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start="));
        txt = initVal(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" fixed=\""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end StringVariableTypeCommonAttribute;

protected function fun_109
  input Tpl.Text in_txt;
  input String in_a_unit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_unit)
    local
      Tpl.Text txt;
      String i_unit;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_unit )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unit=\""));
        txt = Tpl.writeStr(txt, i_unit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_109;

protected function fun_110
  input Tpl.Text in_txt;
  input String in_a_displayUnit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_displayUnit)
    local
      Tpl.Text txt;
      String i_displayUnit;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_displayUnit )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("displayUnit=\""));
        txt = Tpl.writeStr(txt, i_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_110;

public function ScalarVariableTypeRealAttribute
  input Tpl.Text txt;
  input String a_unit;
  input String a_displayUnit;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_displayUnit__;
  Tpl.Text l_unit__;
algorithm
  l_unit__ := fun_109(Tpl.emptyTxt, a_unit);
  l_displayUnit__ := fun_110(Tpl.emptyTxt, a_displayUnit);
  out_txt := Tpl.writeText(txt, l_unit__);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeText(out_txt, l_displayUnit__);
end ScalarVariableTypeRealAttribute;

protected function lm_112
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = externalFunction(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_112(txt, rest);
      then txt;
  end match;
end lm_112;

public function externalFunctions
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_functions;

    case ( txt,
           SimCode.MODELINFO(functions = i_functions) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_112(txt, i_functions);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end externalFunctions;

public function externalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      String i_language;
      String i_extName;
      Integer ret_1;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, extName = i_extName, language = i_language) )
      equation
        l_fname = CodegenC.extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<ExternalFunction\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("name=\""));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"\n",
                                    "valueReference=\""
                                }, false));
        ret_1 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end externalFunction;

public function ModelStructure
  input Tpl.Text txt;
  input SimCode.SimCode a_simCode;
  input list<SimCode.JacobianMatrix> a_jacobianMatrixes;

  output Tpl.Text out_txt;
protected
  SimCode.FmiModelStructure ret_0;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_LINE("<ModelStructure>\n"));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  ret_0 := SimCodeUtil.getFMIModelStructure(a_simCode, a_jacobianMatrixes);
  out_txt := ModelStructureHelper(out_txt, ret_0);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("</ModelStructure>"));
end ModelStructure;

public function ModelStructureHelper
  input Tpl.Text in_txt;
  input SimCode.FmiModelStructure in_a_fmiModelStructure;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelStructure)
    local
      Tpl.Text txt;
      SimCode.FmiInitialUnknowns i_fmiInitialUnknowns;
      SimCode.FmiDerivatives i_fmiDerivatives;
      SimCode.FmiOutputs i_fmiOutputs;

    case ( txt,
           SimCode.FMIMODELSTRUCTURE(fmiOutputs = i_fmiOutputs, fmiDerivatives = i_fmiDerivatives, fmiInitialUnknowns = i_fmiInitialUnknowns) )
      equation
        txt = ModelStructureOutputs(txt, i_fmiOutputs);
        txt = Tpl.softNewLine(txt);
        txt = ModelStructureDerivatives(txt, i_fmiDerivatives);
        txt = Tpl.softNewLine(txt);
        txt = ModelStructureInitialUnknowns(txt, i_fmiInitialUnknowns);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ModelStructureHelper;

public function ModelStructureOutputs
  input Tpl.Text in_txt;
  input SimCode.FmiOutputs in_a_fmiOutputs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiOutputs)
    local
      Tpl.Text txt;
      list<SimCode.FmiUnknown> i_fmiUnknownsList;

    case ( txt,
           SimCode.FMIOUTPUTS(fmiUnknownsList = i_fmiUnknownsList) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<Outputs>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = ModelStructureUnknowns(txt, i_fmiUnknownsList);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</Outputs>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ModelStructureOutputs;

public function ModelStructureDerivatives
  input Tpl.Text in_txt;
  input SimCode.FmiDerivatives in_a_fmiDerivatives;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiDerivatives)
    local
      Tpl.Text txt;
      list<SimCode.FmiUnknown> i_fmiUnknownsList;

    case ( txt,
           SimCode.FMIDERIVATIVES(fmiUnknownsList = i_fmiUnknownsList) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<Derivatives>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = ModelStructureUnknowns(txt, i_fmiUnknownsList);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</Derivatives>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ModelStructureDerivatives;

public function ModelStructureInitialUnknowns
  input Tpl.Text in_txt;
  input SimCode.FmiInitialUnknowns in_a_fmiInitialUnknowns;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiInitialUnknowns)
    local
      Tpl.Text txt;
      list<SimCode.FmiUnknown> i_fmiUnknownsList;

    case ( txt,
           SimCode.FMIINITIALUNKNOWNS(fmiUnknownsList = i_fmiUnknownsList) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<InitialUnknowns>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = ModelStructureUnknowns(txt, i_fmiUnknownsList);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</InitialUnknowns>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ModelStructureInitialUnknowns;

protected function lm_120
  input Tpl.Text in_txt;
  input list<SimCode.FmiUnknown> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.FmiUnknown> rest;
      SimCode.FmiUnknown i_fmiUnknown;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiUnknown :: rest )
      equation
        txt = FmiUnknownAttributes(txt, i_fmiUnknown);
        txt = Tpl.nextIter(txt);
        txt = lm_120(txt, rest);
      then txt;
  end match;
end lm_120;

public function ModelStructureUnknowns
  input Tpl.Text txt;
  input list<SimCode.FmiUnknown> a_fmiUnknownsList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_120(out_txt, a_fmiUnknownsList);
  out_txt := Tpl.popIter(out_txt);
end ModelStructureUnknowns;

public function FmiUnknownAttributes
  input Tpl.Text in_txt;
  input SimCode.FmiUnknown in_a_fmiUnknown;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiUnknown)
    local
      Tpl.Text txt;
      list<String> i_dependenciesKind;
      list<Integer> i_dependencies;
      Integer i_index;

    case ( txt,
           SimCode.FMIUNKNOWN(index = i_index, dependencies = i_dependencies, dependenciesKind = i_dependenciesKind) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Unknown index=\""));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = FmiUnknownDependencies(txt, i_dependencies);
        txt = FmiUnknownDependenciesKind(txt, i_dependenciesKind);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" />"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end FmiUnknownAttributes;

protected function lm_123
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_dependency;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dependency :: rest )
      equation
        txt = Tpl.writeStr(txt, intString(i_dependency));
        txt = Tpl.nextIter(txt);
        txt = lm_123(txt, rest);
      then txt;
  end match;
end lm_123;

protected function fun_124
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<Integer> in_a_dependencies;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_dependencies)
    local
      Tpl.Text txt;
      list<Integer> a_dependencies;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_dependencies )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dependencies=\""));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_123(txt, a_dependencies);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_124;

public function FmiUnknownDependencies
  input Tpl.Text txt;
  input list<Integer> a_dependencies;

  output Tpl.Text out_txt;
protected
  Boolean ret_1;
  Integer ret_0;
algorithm
  ret_0 := listLength(a_dependencies);
  ret_1 := intGt(ret_0, 0);
  out_txt := fun_124(txt, ret_1, a_dependencies);
end FmiUnknownDependencies;

protected function lm_126
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_dependencyKind;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_dependencyKind :: rest )
      equation
        txt = Tpl.writeStr(txt, i_dependencyKind);
        txt = Tpl.nextIter(txt);
        txt = lm_126(txt, rest);
      then txt;
  end match;
end lm_126;

protected function fun_127
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<String> in_a_dependenciesKind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_dependenciesKind)
    local
      Tpl.Text txt;
      list<String> a_dependenciesKind;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_dependenciesKind )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dependenciesKind=\""));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_126(txt, a_dependenciesKind);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_127;

public function FmiUnknownDependenciesKind
  input Tpl.Text txt;
  input list<String> a_dependenciesKind;

  output Tpl.Text out_txt;
protected
  Boolean ret_1;
  Integer ret_0;
algorithm
  ret_0 := listLength(a_dependenciesKind);
  ret_1 := intGt(ret_0, 0);
  out_txt := fun_127(txt, ret_1, a_dependenciesKind);
end FmiUnknownDependenciesKind;

protected function fun_129
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"fmu1_model_interface.h\""));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#include \"fmu2_model_interface.h\""));
      then txt;
  end match;
end fun_129;

protected function fun_130
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void eventUpdate(ModelInstance* comp, fmiEventInfo* eventInfo);\n",
                                    "fmiReal getReal(ModelInstance* comp, const fmiValueReference vr);\n",
                                    "fmiStatus setReal(ModelInstance* comp, const fmiValueReference vr, const fmiReal value);\n",
                                    "fmiInteger getInteger(ModelInstance* comp, const fmiValueReference vr);\n",
                                    "fmiStatus setInteger(ModelInstance* comp, const fmiValueReference vr, const fmiInteger value);\n",
                                    "fmiBoolean getBoolean(ModelInstance* comp, const fmiValueReference vr);\n",
                                    "fmiStatus setBoolean(ModelInstance* comp, const fmiValueReference vr, const fmiBoolean value);\n",
                                    "fmiString getString(ModelInstance* comp, const fmiValueReference vr);\n",
                                    "fmiStatus setExternalFunction(ModelInstance* c, const fmiValueReference vr, const void* value);"
                                }, false));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "void eventUpdate(ModelInstance* comp, fmi2EventInfo* eventInfo);\n",
                                    "fmi2Real getReal(ModelInstance* comp, const fmi2ValueReference vr);\n",
                                    "fmi2Status setReal(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Real value);\n",
                                    "fmi2Integer getInteger(ModelInstance* comp, const fmi2ValueReference vr);\n",
                                    "fmi2Status setInteger(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Integer value);\n",
                                    "fmi2Boolean getBoolean(ModelInstance* comp, const fmi2ValueReference vr);\n",
                                    "fmi2Status setBoolean(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Boolean value);\n",
                                    "fmi2String getString(ModelInstance* comp, const fmi2ValueReference vr);\n",
                                    "fmi2Status setExternalFunction(ModelInstance* c, const fmi2ValueReference vr, const void* value);"
                                }, false));
      then txt;
  end match;
end fun_130;

protected function fun_131
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define fmu1_model_interface_setupDataStruc "));
        txt_0 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, a_simCode);
        txt = CodegenC.symbolName(txt, Tpl.textString(txt_0), "setupDataStruc");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  #include \"fmu1_model_interface.c\""));
      then txt;

    case ( txt,
           _,
           a_simCode )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define fmu2_model_interface_setupDataStruc "));
        txt_1 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, a_simCode);
        txt = CodegenC.symbolName(txt, Tpl.textString(txt_1), "setupDataStruc");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  #include \"fmu2_model_interface.c\""));
      then txt;
  end match;
end fun_131;

protected function fun_132
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input SimCode.ModelInfo in_a_modelInfo;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_modelInfo, in_a_simCode)
    local
      Tpl.Text txt;
      SimCode.ModelInfo a_modelInfo;
      SimCode.SimCode a_simCode;

    case ( txt,
           false,
           a_modelInfo,
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = eventUpdateFunction(txt, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = getRealFunction(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setRealFunction(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = getIntegerFunction(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setIntegerFunction(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = getBooleanFunction(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setBooleanFunction(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = getStringFunction(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setExternalFunction(txt, a_modelInfo);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_modelInfo,
           a_simCode )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = eventUpdateFunction2(txt, a_simCode);
        txt = Tpl.softNewLine(txt);
        txt = getRealFunction2(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setRealFunction2(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = getIntegerFunction2(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setIntegerFunction2(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = getBooleanFunction2(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setBooleanFunction2(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = getStringFunction2(txt, a_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setExternalFunction2(txt, a_modelInfo);
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_132;

public function fmumodel_identifierFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_guid;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_guid, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_guid;
      String a_FMUVersion;
      SimCode.ModelInfo i_modelInfo;
      String i_fileNamePrefix;
      SimCode.SimCode i_simCode;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(fileNamePrefix = i_fileNamePrefix, modelInfo = i_modelInfo)),
           a_guid,
           a_FMUVersion )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "// define class name and unique id\n",
                                    "#define MODEL_IDENTIFIER "
                                }, false));
        txt = CodegenUtil.modelNamePrefix(txt, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define MODEL_GUID \"{"));
        txt = Tpl.writeStr(txt, a_guid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\"\n",
                                    "\n",
                                    "// include fmu header files, typedefs and macros\n",
                                    "#include <stdio.h>\n",
                                    "#include <string.h>\n",
                                    "#include <assert.h>\n",
                                    "#include \"openmodelica.h\"\n",
                                    "#include \"openmodelica_func.h\"\n",
                                    "#include \"simulation_data.h\"\n",
                                    "#include \"util/omc_error.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\"\n",
                                    "#include \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_literals.h\"\n",
                                    "#include \"simulation/solver/initialization/initialization.h\"\n",
                                    "#include \"simulation/solver/events.h\"\n"
                                }, true));
        ret_0 = stringEq(a_FMUVersion, "2.0");
        txt = fun_129(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "extern \"C\" {\n",
                                    "#endif\n",
                                    "\n",
                                    "void setStartValues(ModelInstance *comp);\n",
                                    "void setDefaultStartValues(ModelInstance *comp);\n"
                                }, true));
        ret_1 = stringEq(a_FMUVersion, "2.0");
        txt = fun_130(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = ModelDefineData(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "// implementation of the Model Exchange functions\n"
                                }, true));
        ret_2 = stringEq(a_FMUVersion, "2.0");
        txt = fun_131(txt, ret_2, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = setDefaultStartValues(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = setStartValues(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        ret_3 = stringEq(a_FMUVersion, "2.0");
        txt = fun_132(txt, ret_3, i_modelInfo, i_simCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "#ifdef __cplusplus\n",
                                    "}\n",
                                    "#endif\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fmumodel_identifierFile;

protected function fun_134
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<SimCodeVar.SimVar> in_a_listStates;
  input Integer in_a_varInfo_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_listStates, in_a_varInfo_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> a_listStates;
      Integer a_varInfo_numStateVars;

    case ( txt,
           false,
           _,
           a_varInfo_numStateVars )
      equation
        txt = Tpl.writeStr(txt, intString(a_varInfo_numStateVars));
      then txt;

    case ( txt,
           _,
           a_listStates,
           _ )
      equation
        txt = statesnumwithDummy(txt, a_listStates);
      then txt;
  end match;
end fun_134;

protected function lm_135
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_135(txt, rest);
      then txt;
  end match;
end lm_135;

protected function lm_136
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_136(txt, rest);
      then txt;
  end match;
end lm_136;

protected function lm_137
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_137(txt, rest);
      then txt;
  end match;
end lm_137;

protected function lm_138
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_138(txt, rest);
      then txt;
  end match;
end lm_138;

protected function lm_139
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_139(txt, rest);
      then txt;
  end match;
end lm_139;

protected function lm_140
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_140(txt, rest);
      then txt;
  end match;
end lm_140;

protected function lm_141
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_141(txt, rest);
      then txt;
  end match;
end lm_141;

protected function lm_142
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_142(txt, rest);
      then txt;
  end match;
end lm_142;

protected function lm_143
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_143(txt, rest);
      then txt;
  end match;
end lm_143;

protected function lm_144
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_144(txt, rest);
      then txt;
  end match;
end lm_144;

protected function lm_145
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_145(txt, rest);
      then txt;
  end match;
end lm_145;

protected function lm_146
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_146(txt, rest);
      then txt;
  end match;
end lm_146;

protected function lm_147
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_147(txt, rest);
      then txt;
  end match;
end lm_147;

protected function lm_148
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_148(txt, rest);
      then txt;
  end match;
end lm_148;

protected function lm_149
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = DefineVariables(txt, i_var);
        txt = Tpl.nextIter(txt);
        txt = lm_149(txt, rest);
      then txt;
  end match;
end lm_149;

protected function fun_150
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_150;

protected function lm_151
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_150(txt, ret_1, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_151(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_151(txt, rest);
      then txt;
  end match;
end lm_151;

protected function fun_152
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_name)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_name;

    case ( txt,
           false,
           a_name )
      equation
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_152;

protected function lm_153
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) :: rest )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_152(txt, ret_1, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_153(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_153(txt, rest);
      then txt;
  end match;
end lm_153;

protected function lm_154
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = defineExternalFunction(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_154(txt, rest);
      then txt;
  end match;
end lm_154;

public function ModelDefineData
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;
      list<SimCode.Function> i_functions;
      Integer i_varInfo_numZeroCrossings;
      list<SimCodeVar.SimVar> i_listStates;
      Integer i_varInfo_numBoolAliasVars;
      Integer i_varInfo_numBoolParams;
      Integer i_varInfo_numBoolAlgVars;
      Integer i_varInfo_numStringAliasVars;
      Integer i_varInfo_numStringParamVars;
      Integer i_varInfo_numStringAlgVars;
      Integer i_varInfo_numIntAliasVars;
      Integer i_varInfo_numIntParams;
      Integer i_varInfo_numIntAlgVars;
      Integer i_varInfo_numAlgAliasVars;
      Integer i_varInfo_numParams;
      Integer i_varInfo_numAlgVars;
      Integer i_varInfo_numDiscreteReal;
      Integer i_varInfo_numStateVars;
      Integer ret_16;
      Boolean ret_15;
      Integer ret_14;
      Integer ret_13;
      Tpl.Text l_numberOfBooleans;
      Integer ret_11;
      Integer ret_10;
      Tpl.Text l_numberOfStrings;
      Integer ret_8;
      Integer ret_7;
      Tpl.Text l_numberOfIntegers;
      Integer ret_5;
      Integer ret_4;
      Integer ret_3;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_numberOfReals;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_varInfo_numStateVars, numDiscreteReal = i_varInfo_numDiscreteReal, numAlgVars = i_varInfo_numAlgVars, numParams = i_varInfo_numParams, numAlgAliasVars = i_varInfo_numAlgAliasVars, numIntAlgVars = i_varInfo_numIntAlgVars, numIntParams = i_varInfo_numIntParams, numIntAliasVars = i_varInfo_numIntAliasVars, numStringAlgVars = i_varInfo_numStringAlgVars, numStringParamVars = i_varInfo_numStringParamVars, numStringAliasVars = i_varInfo_numStringAliasVars, numBoolAlgVars = i_varInfo_numBoolAlgVars, numBoolParams = i_varInfo_numBoolParams, numBoolAliasVars = i_varInfo_numBoolAliasVars, numZeroCrossings = i_varInfo_numZeroCrossings), vars = SimCodeVar.SIMVARS(stateVars = (i_vars_stateVars as i_listStates), derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars, intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars, boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars), functions = i_functions) )
      equation
        ret_1 = intMul(i_varInfo_numStateVars, 2);
        ret_2 = intAdd(i_varInfo_numParams, i_varInfo_numAlgAliasVars);
        ret_3 = intAdd(i_varInfo_numAlgVars, ret_2);
        ret_4 = intAdd(i_varInfo_numDiscreteReal, ret_3);
        ret_5 = intAdd(ret_1, ret_4);
        l_numberOfReals = Tpl.writeStr(Tpl.emptyTxt, intString(ret_5));
        ret_7 = intAdd(i_varInfo_numIntParams, i_varInfo_numIntAliasVars);
        ret_8 = intAdd(i_varInfo_numIntAlgVars, ret_7);
        l_numberOfIntegers = Tpl.writeStr(Tpl.emptyTxt, intString(ret_8));
        ret_10 = intAdd(i_varInfo_numStringParamVars, i_varInfo_numStringAliasVars);
        ret_11 = intAdd(i_varInfo_numStringAlgVars, ret_10);
        l_numberOfStrings = Tpl.writeStr(Tpl.emptyTxt, intString(ret_11));
        ret_13 = intAdd(i_varInfo_numBoolParams, i_varInfo_numBoolAliasVars);
        ret_14 = intAdd(i_varInfo_numBoolAlgVars, ret_13);
        l_numberOfBooleans = Tpl.writeStr(Tpl.emptyTxt, intString(ret_14));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// define model size\n",
                                    "#define NUMBER_OF_STATES "
                                }, false));
        ret_15 = intEq(i_varInfo_numStateVars, 1);
        txt = fun_134(txt, ret_15, i_listStates, i_varInfo_numStateVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_EVENT_INDICATORS "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numZeroCrossings));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_REALS "));
        txt = Tpl.writeText(txt, l_numberOfReals);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_INTEGERS "));
        txt = Tpl.writeText(txt, l_numberOfIntegers);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_STRINGS "));
        txt = Tpl.writeText(txt, l_numberOfStrings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_BOOLEANS "));
        txt = Tpl.writeText(txt, l_numberOfBooleans);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define NUMBER_OF_EXTERNALFUNCTIONS "));
        ret_16 = SimCodeUtil.countDynamicExternalFunctions(i_functions);
        txt = Tpl.writeStr(txt, intString(ret_16));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "// define variable data for model\n"
                                }, true));
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_135(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_136(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_137(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_138(txt, i_vars_discreteAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_139(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_140(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_141(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_142(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_143(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_144(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_145(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_146(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_147(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_148(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_149(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "// define initial state vector as vector of value references\n",
                                    "#define STATES { "
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_151(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "#define STATESDERIVATIVES { "
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_153(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " }\n",
                                    "\n"
                                }, true));
        System.tmpTickReset(0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_154(txt, i_functions);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ModelDefineData;

public function dervativeNameCStyle
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der_"));
        txt = CodegenUtil.crefStr(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dervativeNameCStyle;

protected function fun_157
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_157;

protected function fun_158
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_description;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_description, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_description;
      DAE.ComponentRef a_name;
      Integer ret_0;

    case ( txt,
           false,
           a_description,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define "));
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ "));
        ret_0 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, a_description);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_158;

protected function fun_159
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_description;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_description, in_a_name)
    local
      Tpl.Text txt;
      Tpl.Text a_description;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_description,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_158(txt, ret_1, a_description, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_159;

public function DefineVariables
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      String i_comment;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_description;

    case ( txt,
           SimCodeVar.SIMVAR(comment = i_comment, name = i_name) )
      equation
        l_description = fun_157(Tpl.emptyTxt, i_comment);
        txt_1 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_2 = stringEq(Tpl.textString(txt_1), "$dummy");
        txt = fun_159(txt, ret_2, l_description, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end DefineVariables;

public function defineExternalFunction
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      String i_language;
      String i_extName;
      Integer ret_1;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, extName = i_extName, language = i_language) )
      equation
        l_fname = CodegenC.extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#define $P"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        ret_1 = System.tmpTick();
        txt = Tpl.writeStr(txt, intString(ret_1));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end defineExternalFunction;

protected function lm_162
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_162(txt, rest);
      then txt;
  end match;
end lm_162;

protected function lm_163
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = initValsDefault(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_163(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_163;

protected function lm_164
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = initValsDefault(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_164(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_164;

protected function lm_165
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numAlgVars;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numAlgVars, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numAlgVars;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numAlgVars,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        ret_1 = intAdd(ret_0, a_numAlgVars);
        txt = initValsDefault(txt, i_var, "realVars", ret_1);
        txt = Tpl.nextIter(txt);
        txt = lm_165(txt, rest, a_numAlgVars, a_numStateVars);
      then txt;
  end match;
end lm_165;

protected function lm_166
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_166(txt, rest);
      then txt;
  end match;
end lm_166;

protected function lm_167
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_167(txt, rest);
      then txt;
  end match;
end lm_167;

protected function lm_168
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initValsDefault(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_168(txt, rest);
      then txt;
  end match;
end lm_168;

protected function lm_169
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_169(txt, rest);
      then txt;
  end match;
end lm_169;

protected function lm_170
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_170(txt, rest);
      then txt;
  end match;
end lm_170;

protected function lm_171
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_171(txt, rest);
      then txt;
  end match;
end lm_171;

protected function lm_172
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParamsDefault(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_172(txt, rest);
      then txt;
  end match;
end lm_172;

public function setDefaultStartValues
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      Integer i_numAlgVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_numStateVars, numAlgVars = i_numAlgVars), vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Set values for all variables that define a start value\n",
                                    "void setDefaultStartValues(ModelInstance *comp) {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_162(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_163(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_164(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_165(txt, i_vars_discreteAlgVars, i_numAlgVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_166(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_167(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_168(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_169(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_170(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_171(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_172(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setDefaultStartValues;

protected function lm_174
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_174(txt, rest);
      then txt;
  end match;
end lm_174;

protected function lm_175
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = initVals(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_175(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_175;

protected function lm_176
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = initVals(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_176(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_176;

protected function lm_177
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numAlgVars;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numAlgVars, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numAlgVars;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numAlgVars,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        ret_1 = intAdd(ret_0, a_numAlgVars);
        txt = initVals(txt, i_var, "realVars", ret_1);
        txt = Tpl.nextIter(txt);
        txt = lm_177(txt, rest, a_numAlgVars, a_numStateVars);
      then txt;
  end match;
end lm_177;

protected function lm_178
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_178(txt, rest);
      then txt;
  end match;
end lm_178;

protected function lm_179
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_179(txt, rest);
      then txt;
  end match;
end lm_179;

protected function lm_180
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initVals(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_180(txt, rest);
      then txt;
  end match;
end lm_180;

protected function lm_181
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_181(txt, rest);
      then txt;
  end match;
end lm_181;

protected function lm_182
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_182(txt, rest);
      then txt;
  end match;
end lm_182;

protected function lm_183
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_183(txt, rest);
      then txt;
  end match;
end lm_183;

protected function lm_184
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = initParams(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_184(txt, rest);
      then txt;
  end match;
end lm_184;

public function setStartValues
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      Integer i_numAlgVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numStateVars = i_numStateVars, numAlgVars = i_numAlgVars), vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, stringAlgVars = i_vars_stringAlgVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringParamVars = i_vars_stringParamVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Set values for all variables that define a start value\n",
                                    "void setStartValues(ModelInstance *comp) {\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_174(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_175(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_176(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_177(txt, i_vars_discreteAlgVars, i_numAlgVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_178(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_179(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_180(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_181(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_182(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_183(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_184(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setStartValues;

protected function lm_186
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      DAE.ComponentRef i_cref;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (sim_verbose) { printf(\"Setting variable start value: %s(start=%f)\\n\", \""));
        txt = CodegenC.cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", "));
        txt = CodegenC.cref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("); }"));
        txt = Tpl.nextIter(txt);
        txt = lm_186(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_186(txt, rest);
      then txt;
  end match;
end lm_186;

public function initializeFunction
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_allEquations;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_eqPart;
  Tpl.Text l_varDecls;
algorithm
  l_varDecls := Tpl.emptyTxt;
  l_eqPart := Tpl.emptyTxt;
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "// Used to set the first time event, if any.\n",
                                   "void initialize(ModelInstance* comp, fmiEventInfo* eventInfo) {\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.writeText(out_txt, l_varDecls);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(out_txt, l_eqPart);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_186(out_txt, a_allEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end initializeFunction;

protected function fun_188
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      Integer ret_2;
      Integer ret_1;
      Tpl.Text l_str;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        ret_1 = intAdd(a_index, a_offset);
        l_str = Tpl.writeStr(l_str, intString(ret_1));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" =  comp->fmuData->localData[0]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_2 = intAdd(a_index, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_188;

protected function fun_189
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_188(txt, ret_1, a_offset, a_index, a_arrayName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_189;

public function initVals
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_var;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      Integer i_index;
      DAE.ComponentRef i_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "$dummy");
        txt = fun_189(txt, ret_1, a_offset, i_index, a_arrayName, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end initVals;

public function initParams
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_var;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      Tpl.Text l_str;

    case ( txt,
           SimCodeVar.SIMVAR(index = i_index),
           a_arrayName )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        l_str = Tpl.writeStr(l_str, intString(i_index));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = Tpl.writeText(txt, l_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = comp->fmuData->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initParams;

protected function fun_192
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input Tpl.Text in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_str)
    local
      Tpl.Text txt;
      Tpl.Text a_str;

    case ( txt,
           DAE.T_INTEGER(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_REAL(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_ENUMERATION(index = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_BOOL(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = 0;"));
      then txt;

    case ( txt,
           DAE.T_STRING(varLst = _),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = \"\";"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKOWN_TYPE"));
      then txt;
  end match;
end fun_192;

protected function fun_193
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input DAE.Type in_a_type__;
  input Tpl.Text in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_type__, in_a_str)
    local
      Tpl.Text txt;
      DAE.Type a_type__;
      Tpl.Text a_str;
      DAE.Exp i_v;

    case ( txt,
           SOME((i_v as DAE.ICONST(integer = _))),
           _,
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SOME((i_v as DAE.RCONST(real = _))),
           _,
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SOME((i_v as DAE.SCONST(string = _))),
           _,
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SOME((i_v as DAE.BCONST(bool = _))),
           _,
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SOME((i_v as DAE.ENUM_LITERAL(name = _))),
           _,
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           a_type__,
           a_str )
      equation
        txt = fun_192(txt, a_type__, a_str);
      then txt;
  end match;
end fun_193;

public function initValsDefault
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_var;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      DAE.Type i_type__;
      Option<DAE.Exp> i_initialValue;
      Integer i_index;
      Integer ret_1;
      Tpl.Text l_str;

    case ( txt,
           SimCodeVar.SIMVAR(index = i_index, type_ = i_type__, initialValue = i_initialValue),
           a_arrayName,
           a_offset )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        ret_1 = intAdd(i_index, a_offset);
        l_str = Tpl.writeStr(l_str, intString(ret_1));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = fun_193(txt, i_initialValue, i_type__, l_str);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end initValsDefault;

protected function fun_195
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;
  input Tpl.Text in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue, in_a_str)
    local
      Tpl.Text txt;
      Tpl.Text a_str;
      DAE.Exp i_v;

    case ( txt,
           SOME(i_v),
           a_str )
      equation
        txt = Tpl.writeText(txt, a_str);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = initVal(txt, i_v);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_195;

public function initParamsDefault
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_var;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Option<DAE.Exp> i_initialValue;
      Integer i_index;
      Tpl.Text l_str;

    case ( txt,
           SimCodeVar.SIMVAR(index = i_index, initialValue = i_initialValue),
           a_arrayName )
      equation
        l_str = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("comp->fmuData->modelData."));
        l_str = Tpl.writeStr(l_str, a_arrayName);
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("Data["));
        l_str = Tpl.writeStr(l_str, intString(i_index));
        l_str = Tpl.writeTok(l_str, Tpl.ST_STRING("].attribute.start"));
        txt = fun_195(txt, i_initialValue, l_str);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end initParamsDefault;

protected function fun_197
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1"));
      then txt;
  end match;
end fun_197;

public function initVal
  input Tpl.Text in_txt;
  input DAE.Exp in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_197(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*ERROR* initial value of unknown type"));
      then txt;
  end match;
end initVal;

public function eventUpdateFunction
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Used to set the next time event, if any.\n",
                                    "void eventUpdate(ModelInstance* comp, fmiEventInfo* eventInfo) {\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end eventUpdateFunction;

protected function lm_200
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_200(txt, rest);
      then txt;
  end match;
end lm_200;

protected function lm_201
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = SwitchVars(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_201(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_201;

protected function lm_202
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = SwitchVars(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_202(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_202;

protected function lm_203
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numAlgVars;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numAlgVars, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numAlgVars;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numAlgVars,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        ret_1 = intAdd(ret_0, a_numAlgVars);
        txt = SwitchVars(txt, i_var, "realVars", ret_1);
        txt = Tpl.nextIter(txt);
        txt = lm_203(txt, rest, a_numAlgVars, a_numStateVars);
      then txt;
  end match;
end lm_203;

protected function lm_204
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_204(txt, rest);
      then txt;
  end match;
end lm_204;

protected function lm_205
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "Real", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_205(txt, rest);
      then txt;
  end match;
end lm_205;

public function getRealFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      Integer i_numAlgVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars), varInfo = SimCode.VARINFO(numStateVars = i_numStateVars, numAlgVars = i_numAlgVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiReal getReal(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_200(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_201(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_202(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_203(txt, i_vars_discreteAlgVars, i_numAlgVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_204(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_205(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getRealFunction;

protected function lm_207
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_207(txt, rest);
      then txt;
  end match;
end lm_207;

protected function lm_208
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = SwitchVarsSet(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_208(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_208;

protected function lm_209
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = SwitchVarsSet(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_209(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_209;

protected function lm_210
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numAlgVars;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numAlgVars, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numAlgVars;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numAlgVars,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        ret_1 = intAdd(ret_0, a_numAlgVars);
        txt = SwitchVarsSet(txt, i_var, "realVars", ret_1);
        txt = Tpl.nextIter(txt);
        txt = lm_210(txt, rest, a_numAlgVars, a_numStateVars);
      then txt;
  end match;
end lm_210;

protected function lm_211
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_211(txt, rest);
      then txt;
  end match;
end lm_211;

protected function lm_212
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "Real", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_212(txt, rest);
      then txt;
  end match;
end lm_212;

public function setRealFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      Integer i_numAlgVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars), varInfo = SimCode.VARINFO(numStateVars = i_numStateVars, numAlgVars = i_numAlgVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiStatus setReal(ModelInstance* comp, const fmiValueReference vr, const fmiReal value) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_207(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_208(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_209(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_210(txt, i_vars_discreteAlgVars, i_numAlgVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_211(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_212(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmiError;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmiOK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setRealFunction;

protected function lm_214
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_214(txt, rest);
      then txt;
  end match;
end lm_214;

protected function lm_215
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_215(txt, rest);
      then txt;
  end match;
end lm_215;

protected function lm_216
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "Integer", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_216(txt, rest);
      then txt;
  end match;
end lm_216;

public function getIntegerFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiInteger getInteger(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_214(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_215(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_216(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getIntegerFunction;

protected function lm_218
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_218(txt, rest);
      then txt;
  end match;
end lm_218;

protected function lm_219
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_219(txt, rest);
      then txt;
  end match;
end lm_219;

protected function lm_220
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "Integer", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_220(txt, rest);
      then txt;
  end match;
end lm_220;

public function setIntegerFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiStatus setInteger(ModelInstance* comp, const fmiValueReference vr, const fmiInteger value) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_218(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_219(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_220(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmiError;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmiOK;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setIntegerFunction;

protected function lm_222
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_222(txt, rest);
      then txt;
  end match;
end lm_222;

protected function lm_223
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_223(txt, rest);
      then txt;
  end match;
end lm_223;

protected function lm_224
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "Boolean", "!");
        txt = Tpl.nextIter(txt);
        txt = lm_224(txt, rest);
      then txt;
  end match;
end lm_224;

public function getBooleanFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiBoolean getBoolean(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_222(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_223(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_224(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getBooleanFunction;

protected function lm_226
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_226(txt, rest);
      then txt;
  end match;
end lm_226;

protected function lm_227
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_227(txt, rest);
      then txt;
  end match;
end lm_227;

protected function lm_228
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "Boolean", "!");
        txt = Tpl.nextIter(txt);
        txt = lm_228(txt, rest);
      then txt;
  end match;
end lm_228;

public function setBooleanFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiStatus setBoolean(ModelInstance* comp, const fmiValueReference vr, const fmiBoolean value) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_226(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_227(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_228(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmiError;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmiOK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setBooleanFunction;

protected function lm_230
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_230(txt, rest);
      then txt;
  end match;
end lm_230;

protected function lm_231
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_231(txt, rest);
      then txt;
  end match;
end lm_231;

protected function lm_232
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "string", "");
        txt = Tpl.nextIter(txt);
        txt = lm_232(txt, rest);
      then txt;
  end match;
end lm_232;

public function getStringFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiString getString(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_230(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_231(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_232(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getStringFunction;

protected function lm_234
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_234(txt, rest);
      then txt;
  end match;
end lm_234;

protected function lm_235
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_235(txt, rest);
      then txt;
  end match;
end lm_235;

protected function lm_236
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "String", "");
        txt = Tpl.nextIter(txt);
        txt = lm_236(txt, rest);
      then txt;
  end match;
end lm_236;

public function setStringFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiString getString(ModelInstance* comp, const fmiValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_234(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_235(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_236(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setStringFunction;

public function setExternalFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_functions;
      Tpl.Text l_externalFuncs;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = _), functions = i_functions) )
      equation
        l_externalFuncs = setExternalFunctionsSwitch(Tpl.emptyTxt, i_functions);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmiStatus setExternalFunction(ModelInstance* c, const fmiValueReference vr, const void* value){\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_externalFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmiError;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmiOK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setExternalFunction;

public function eventUpdateFunction2
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.SIMCODE(modelInfo = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// Used to set the next time event, if any.\n",
                                    "void eventUpdate(ModelInstance* comp, fmi2EventInfo* eventInfo) {\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end eventUpdateFunction2;

protected function lm_240
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_240(txt, rest);
      then txt;
  end match;
end lm_240;

protected function lm_241
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = SwitchVars(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_241(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_241;

protected function lm_242
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = SwitchVars(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_242(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_242;

protected function lm_243
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numAlgVars;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numAlgVars, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numAlgVars;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numAlgVars,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        ret_1 = intAdd(ret_0, a_numAlgVars);
        txt = SwitchVars(txt, i_var, "realVars", ret_1);
        txt = Tpl.nextIter(txt);
        txt = lm_243(txt, rest, a_numAlgVars, a_numStateVars);
      then txt;
  end match;
end lm_243;

protected function lm_244
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_244(txt, rest);
      then txt;
  end match;
end lm_244;

protected function lm_245
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "Real", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_245(txt, rest);
      then txt;
  end match;
end lm_245;

public function getRealFunction2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      Integer i_numAlgVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars), varInfo = SimCode.VARINFO(numStateVars = i_numStateVars, numAlgVars = i_numAlgVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2Real getReal(ModelInstance* comp, const fmi2ValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_240(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_241(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_242(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_243(txt, i_vars_discreteAlgVars, i_numAlgVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_244(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_245(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getRealFunction2;

protected function lm_247
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "realVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_247(txt, rest);
      then txt;
  end match;
end lm_247;

protected function lm_248
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        txt = SwitchVarsSet(txt, i_var, "realVars", a_numStateVars);
        txt = Tpl.nextIter(txt);
        txt = lm_248(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_248;

protected function lm_249
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        txt = SwitchVarsSet(txt, i_var, "realVars", ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_249(txt, rest, a_numStateVars);
      then txt;
  end match;
end lm_249;

protected function lm_250
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_numAlgVars;
  input Integer in_a_numStateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_numAlgVars, in_a_numStateVars)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_numAlgVars;
      Integer a_numStateVars;
      SimCodeVar.SimVar i_var;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_numAlgVars,
           a_numStateVars )
      equation
        ret_0 = intMul(2, a_numStateVars);
        ret_1 = intAdd(ret_0, a_numAlgVars);
        txt = SwitchVarsSet(txt, i_var, "realVars", ret_1);
        txt = Tpl.nextIter(txt);
        txt = lm_250(txt, rest, a_numAlgVars, a_numStateVars);
      then txt;
  end match;
end lm_250;

protected function lm_251
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "realParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_251(txt, rest);
      then txt;
  end match;
end lm_251;

protected function lm_252
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "Real", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_252(txt, rest);
      then txt;
  end match;
end lm_252;

public function setRealFunction2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      Integer i_numAlgVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      Integer i_numStateVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, paramVars = i_vars_paramVars, aliasVars = i_vars_aliasVars), varInfo = SimCode.VARINFO(numStateVars = i_numStateVars, numAlgVars = i_numAlgVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2Status setReal(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Real value) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_247(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_248(txt, i_vars_derivativeVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_249(txt, i_vars_algVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_250(txt, i_vars_discreteAlgVars, i_numAlgVars, i_numStateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_251(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_252(txt, i_vars_aliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmi2Error;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmi2OK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setRealFunction2;

protected function lm_254
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_254(txt, rest);
      then txt;
  end match;
end lm_254;

protected function lm_255
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_255(txt, rest);
      then txt;
  end match;
end lm_255;

protected function lm_256
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "Integer", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_256(txt, rest);
      then txt;
  end match;
end lm_256;

public function getIntegerFunction2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2Integer getInteger(ModelInstance* comp, const fmi2ValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_254(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_255(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_256(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getIntegerFunction2;

protected function lm_258
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "integerVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_258(txt, rest);
      then txt;
  end match;
end lm_258;

protected function lm_259
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "integerParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_259(txt, rest);
      then txt;
  end match;
end lm_259;

protected function lm_260
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "Integer", "-");
        txt = Tpl.nextIter(txt);
        txt = lm_260(txt, rest);
      then txt;
  end match;
end lm_260;

public function setIntegerFunction2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(intAlgVars = i_vars_intAlgVars, intParamVars = i_vars_intParamVars, intAliasVars = i_vars_intAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2Status setInteger(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Integer value) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_258(txt, i_vars_intAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_259(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_260(txt, i_vars_intAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmi2Error;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmi2OK;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setIntegerFunction2;

protected function lm_262
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_262(txt, rest);
      then txt;
  end match;
end lm_262;

protected function lm_263
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_263(txt, rest);
      then txt;
  end match;
end lm_263;

protected function lm_264
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "Boolean", "!");
        txt = Tpl.nextIter(txt);
        txt = lm_264(txt, rest);
      then txt;
  end match;
end lm_264;

public function getBooleanFunction2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2Boolean getBoolean(ModelInstance* comp, const fmi2ValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_262(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_263(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_264(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getBooleanFunction2;

protected function lm_266
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "booleanVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_266(txt, rest);
      then txt;
  end match;
end lm_266;

protected function lm_267
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "booleanParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_267(txt, rest);
      then txt;
  end match;
end lm_267;

protected function lm_268
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "Boolean", "!");
        txt = Tpl.nextIter(txt);
        txt = lm_268(txt, rest);
      then txt;
  end match;
end lm_268;

public function setBooleanFunction2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(boolAlgVars = i_vars_boolAlgVars, boolParamVars = i_vars_boolParamVars, boolAliasVars = i_vars_boolAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2Status setBoolean(ModelInstance* comp, const fmi2ValueReference vr, const fmi2Boolean value) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_266(txt, i_vars_boolAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_267(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_268(txt, i_vars_boolAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmi2Error;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmi2OK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setBooleanFunction2;

protected function lm_270
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVars(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_270(txt, rest);
      then txt;
  end match;
end lm_270;

protected function lm_271
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParameters(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_271(txt, rest);
      then txt;
  end match;
end lm_271;

protected function lm_272
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVars(txt, i_var, "string", "");
        txt = Tpl.nextIter(txt);
        txt = lm_272(txt, rest);
      then txt;
  end match;
end lm_272;

public function getStringFunction2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2String getString(ModelInstance* comp, const fmi2ValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_270(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_271(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_272(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getStringFunction2;

protected function lm_274
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchVarsSet(txt, i_var, "stringVars", 0);
        txt = Tpl.nextIter(txt);
        txt = lm_274(txt, rest);
      then txt;
  end match;
end lm_274;

protected function lm_275
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchParametersSet(txt, i_var, "stringParameter");
        txt = Tpl.nextIter(txt);
        txt = lm_275(txt, rest);
      then txt;
  end match;
end lm_275;

protected function lm_276
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_var :: rest )
      equation
        txt = SwitchAliasVarsSet(txt, i_var, "String", "");
        txt = Tpl.nextIter(txt);
        txt = lm_276(txt, rest);
      then txt;
  end match;
end lm_276;

public function setStringFunction2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2String getString(ModelInstance* comp, const fmi2ValueReference vr) {\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_274(txt, i_vars_stringAlgVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_275(txt, i_vars_stringParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_276(txt, i_vars_stringAliasVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return 0;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setStringFunction2;

public function setExternalFunction2
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCode.Function> i_functions;
      Tpl.Text l_externalFuncs;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = _), functions = i_functions) )
      equation
        l_externalFuncs = setExternalFunctionsSwitch(Tpl.emptyTxt, i_functions);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2Status setExternalFunction(ModelInstance* c, const fmi2ValueReference vr, const void* value){\n",
                                    "  switch (vr) {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeText(txt, l_externalFuncs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "default:\n",
                                    "    return fmi2Error;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  }\n",
                                    "  return fmi2OK;\n",
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setExternalFunction2;

protected function lm_279
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_fn;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fn :: rest )
      equation
        txt = setExternalFunctionSwitch(txt, i_fn);
        txt = Tpl.nextIter(txt);
        txt = lm_279(txt, rest);
      then txt;
  end match;
end lm_279;

public function setExternalFunctionsSwitch
  input Tpl.Text txt;
  input list<SimCode.Function> a_functions;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_279(out_txt, a_functions);
  out_txt := Tpl.popIter(out_txt);
end setExternalFunctionsSwitch;

public function setExternalFunctionSwitch
  input Tpl.Text in_txt;
  input SimCode.Function in_a_fn;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fn)
    local
      Tpl.Text txt;
      String i_language;
      String i_extName;
      Tpl.Text l_fname;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(dynamicLoad = true, extName = i_extName, language = i_language) )
      equation
        l_fname = CodegenC.extFunctionName(Tpl.emptyTxt, i_extName, i_language);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case $P"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : ptr_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=(ptrT_"));
        txt = Tpl.writeText(txt, l_fname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")value; break;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end setExternalFunctionSwitch;

protected function fun_282
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_282;

protected function fun_283
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Integer ret_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ : return comp->fmuData->localData[0]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = intAdd(a_index, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_283;

protected function fun_284
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_283(txt, ret_1, a_offset, a_index, a_arrayName, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_284;

public function SwitchVars
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      Integer i_index;
      DAE.ComponentRef i_name;
      String i_comment;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_description;

    case ( txt,
           SimCodeVar.SIMVAR(comment = i_comment, name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        l_description = fun_282(Tpl.emptyTxt, i_comment);
        txt_1 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_2 = stringEq(Tpl.textString(txt_1), "$dummy");
        txt = fun_284(txt, ret_2, a_offset, i_index, a_arrayName, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end SwitchVars;

protected function fun_286
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_286;

public function SwitchParameters
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      DAE.ComponentRef i_name;
      String i_comment;
      Tpl.Text l_description;

    case ( txt,
           SimCodeVar.SIMVAR(comment = i_comment, name = i_name, index = i_index),
           a_arrayName )
      equation
        l_description = fun_286(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ : return comp->fmuData->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; break;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end SwitchParameters;

protected function fun_288
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_288;

protected function fun_289
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_varName;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_varName;
      String a_arrayName;
      Tpl.Text a_crefName;

    case ( txt,
           false,
           a_varName,
           a_arrayName,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return get"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(comp, "));
        txt = CodegenC.cref(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_); break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return comp->fmuData->localData[0]->timeValue; break;"));
      then txt;
  end match;
end fun_289;

protected function fun_290
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_varName;
  input String in_a_arrayName;
  input String in_a_negate;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_arrayName, in_a_negate, in_a_crefName)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_varName;
      String a_arrayName;
      String a_negate;
      Tpl.Text a_crefName;

    case ( txt,
           false,
           a_varName,
           a_arrayName,
           a_negate,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return ("));
        txt = Tpl.writeStr(txt, a_negate);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" get"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(comp, "));
        txt = CodegenC.cref(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_)); break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return comp->fmuData->localData[0]->timeValue; break;"));
      then txt;
  end match;
end fun_290;

protected function fun_291
  input Tpl.Text in_txt;
  input SimCodeVar.AliasVariable in_a_aliasvar;
  input String in_a_negate;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar, in_a_negate, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      String a_negate;
      String a_arrayName;
      Tpl.Text a_crefName;
      DAE.ComponentRef i_varName;
      Boolean ret_3;
      Tpl.Text txt_2;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.ALIAS(varName = i_varName),
           _,
           a_arrayName,
           a_crefName )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_1 = stringEq(Tpl.textString(txt_0), "time");
        txt = fun_289(txt, ret_1, i_varName, a_arrayName, a_crefName);
      then txt;

    case ( txt,
           SimCodeVar.NEGATEDALIAS(varName = i_varName),
           a_negate,
           a_arrayName,
           a_crefName )
      equation
        txt_2 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_3 = stringEq(Tpl.textString(txt_2), "time");
        txt = fun_290(txt, ret_3, i_varName, a_arrayName, a_negate, a_crefName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_291;

public function SwitchAliasVars
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_arrayName;
  input String in_a_negate;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_negate)
    local
      Tpl.Text txt;
      String a_arrayName;
      String a_negate;
      SimCodeVar.AliasVariable i_aliasvar;
      DAE.ComponentRef i_name;
      String i_comment;
      Tpl.Text l_crefName;
      Tpl.Text l_description;

    case ( txt,
           SimCodeVar.SIMVAR(comment = i_comment, name = i_name, aliasvar = i_aliasvar),
           a_arrayName,
           a_negate )
      equation
        l_description = fun_288(Tpl.emptyTxt, i_comment);
        l_crefName = CodegenC.cref(Tpl.emptyTxt, i_name);
        l_crefName = Tpl.writeTok(l_crefName, Tpl.ST_STRING("_"));
        txt = fun_291(txt, i_aliasvar, a_negate, a_arrayName, l_crefName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end SwitchAliasVars;

protected function fun_293
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_293;

protected function fun_294
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Integer ret_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = CodegenC.cref(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ : comp->fmuData->localData[0]->"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        ret_0 = intAdd(a_index, a_offset);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]=value; break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_294;

protected function fun_295
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_offset;
  input Integer in_a_index;
  input String in_a_arrayName;
  input DAE.ComponentRef in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_offset, in_a_index, in_a_arrayName, in_a_name)
    local
      Tpl.Text txt;
      Integer a_offset;
      Integer a_index;
      String a_arrayName;
      DAE.ComponentRef a_name;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           false,
           a_offset,
           a_index,
           a_arrayName,
           a_name )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, a_name);
        ret_1 = stringEq(Tpl.textString(txt_0), "der($dummy)");
        txt = fun_294(txt, ret_1, a_offset, a_index, a_arrayName, a_name);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_295;

public function SwitchVarsSet
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_arrayName;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_offset)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer a_offset;
      Integer i_index;
      DAE.ComponentRef i_name;
      String i_comment;
      Boolean ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_description;

    case ( txt,
           SimCodeVar.SIMVAR(comment = i_comment, name = i_name, index = i_index),
           a_arrayName,
           a_offset )
      equation
        l_description = fun_293(Tpl.emptyTxt, i_comment);
        txt_1 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_2 = stringEq(Tpl.textString(txt_1), "$dummy");
        txt = fun_295(txt, ret_2, a_offset, i_index, a_arrayName, i_name);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end SwitchVarsSet;

protected function fun_297
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_297;

public function SwitchParametersSet
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_arrayName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName)
    local
      Tpl.Text txt;
      String a_arrayName;
      Integer i_index;
      DAE.ComponentRef i_name;
      String i_comment;
      Tpl.Text l_description;

    case ( txt,
           SimCodeVar.SIMVAR(comment = i_comment, name = i_name, index = i_index),
           a_arrayName )
      equation
        l_description = fun_297(Tpl.emptyTxt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = CodegenC.cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_ : comp->fmuData->simulationInfo."));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]=value; break;"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end SwitchParametersSet;

protected function fun_299
  input Tpl.Text in_txt;
  input String in_a_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comment)
    local
      Tpl.Text txt;
      String i_comment;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_299;

protected function fun_300
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_varName;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_varName, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_varName;
      String a_arrayName;
      Tpl.Text a_crefName;

    case ( txt,
           false,
           a_varName,
           a_arrayName,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return set"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(comp, "));
        txt = CodegenC.cref(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_, value); break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_300;

protected function fun_301
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_negate;
  input DAE.ComponentRef in_a_varName;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_negate, in_a_varName, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      String a_negate;
      DAE.ComponentRef a_varName;
      String a_arrayName;
      Tpl.Text a_crefName;

    case ( txt,
           false,
           a_negate,
           a_varName,
           a_arrayName,
           a_crefName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeText(txt, a_crefName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : return set"));
        txt = Tpl.writeStr(txt, a_arrayName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(comp, "));
        txt = CodegenC.cref(txt, a_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_, ("));
        txt = Tpl.writeStr(txt, a_negate);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" value)); break;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_301;

protected function fun_302
  input Tpl.Text in_txt;
  input SimCodeVar.AliasVariable in_a_aliasvar;
  input String in_a_negate;
  input String in_a_arrayName;
  input Tpl.Text in_a_crefName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar, in_a_negate, in_a_arrayName, in_a_crefName)
    local
      Tpl.Text txt;
      String a_negate;
      String a_arrayName;
      Tpl.Text a_crefName;
      DAE.ComponentRef i_varName;
      Boolean ret_3;
      Tpl.Text txt_2;
      Boolean ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.ALIAS(varName = i_varName),
           _,
           a_arrayName,
           a_crefName )
      equation
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_1 = stringEq(Tpl.textString(txt_0), "time");
        txt = fun_300(txt, ret_1, i_varName, a_arrayName, a_crefName);
      then txt;

    case ( txt,
           SimCodeVar.NEGATEDALIAS(varName = i_varName),
           a_negate,
           a_arrayName,
           a_crefName )
      equation
        txt_2 = CodegenUtil.crefStr(Tpl.emptyTxt, i_varName);
        ret_3 = stringEq(Tpl.textString(txt_2), "time");
        txt = fun_301(txt, ret_3, a_negate, i_varName, a_arrayName, a_crefName);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_302;

public function SwitchAliasVarsSet
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;
  input String in_a_arrayName;
  input String in_a_negate;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar, in_a_arrayName, in_a_negate)
    local
      Tpl.Text txt;
      String a_arrayName;
      String a_negate;
      SimCodeVar.AliasVariable i_aliasvar;
      DAE.ComponentRef i_name;
      String i_comment;
      Tpl.Text l_crefName;
      Tpl.Text l_description;

    case ( txt,
           SimCodeVar.SIMVAR(comment = i_comment, name = i_name, aliasvar = i_aliasvar),
           a_arrayName,
           a_negate )
      equation
        l_description = fun_299(Tpl.emptyTxt, i_comment);
        l_crefName = CodegenC.cref(Tpl.emptyTxt, i_name);
        l_crefName = Tpl.writeTok(l_crefName, Tpl.ST_STRING("_"));
        txt = fun_302(txt, i_aliasvar, a_negate, a_arrayName, l_crefName);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end SwitchAliasVarsSet;

protected function fun_304
  input Tpl.Text in_txt;
  input String in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           "OSX" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-lf2c -llis"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-Wl,-Bstatic -lf2c -Wl,-Bdynamic -llis"));
      then txt;
  end match;
end fun_304;

protected function fun_305
  input Tpl.Text in_txt;
  input String in_a_platform;
  input String in_a_omhome;
  input Tpl.Text in_a_fmudirname;
  input String in_a_libsPos2;
  input String in_a_libsPos1;
  input String in_a_dirExtra;
  input String in_a_modelNamePrefix;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_platform, in_a_omhome, in_a_fmudirname, in_a_libsPos2, in_a_libsPos1, in_a_dirExtra, in_a_modelNamePrefix, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      String a_omhome;
      Tpl.Text a_fmudirname;
      String a_libsPos2;
      String a_libsPos1;
      String a_dirExtra;
      String a_modelNamePrefix;
      String a_fileNamePrefix;
      String i_platform;
      String ret_0;

    case ( txt,
           (i_platform as "win32"),
           a_omhome,
           a_fmudirname,
           a_libsPos2,
           a_libsPos1,
           a_dirExtra,
           a_modelNamePrefix,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU: $(MAINOBJ) "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_literals.h $(OFILES)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) -shared -I. -o "));
        txt = Tpl.writeStr(txt, a_modelNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) $(MAINOBJ) $(OFILES) $(CPPFLAGS) "));
        txt = Tpl.writeStr(txt, a_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " $(CFLAGS) $(LDFLAGS) -Wl,-Bstatic -lf2c -Wl,-Bdynamic -llis -Wl,--kill-at\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mkdir.exe -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mkdir.exe -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/binaries\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mkdir.exe -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mkdir.exe -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/sources\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("dlltool -d "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def --dllname "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) --output-lib "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".lib --kill-at\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".lib "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp $(GENERATEDFILES) modelDescription.xml "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/sources/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp modelDescription.xml "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/modelDescription.xml\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp "));
        txt = Tpl.writeStr(txt, a_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/bin/libexpat.dll "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp "));
        txt = Tpl.writeStr(txt, a_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/bin/pthreadGC2.dll "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp "));
        txt = Tpl.writeStr(txt, a_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/bin/libgfortran-3.dll "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/binaries/"));
        txt = Tpl.writeStr(txt, i_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cd "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&& rm -f ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".fmu&& zip -r ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".fmu *\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rm -rf "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rm -f "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".so "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_*.o"));
      then txt;

    case ( txt,
           _,
           _,
           a_fmudirname,
           a_libsPos2,
           a_libsPos1,
           a_dirExtra,
           a_modelNamePrefix,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU: $(MAINOBJ) "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_literals.h $(OFILES)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(CXX) -shared -I. -o "));
        txt = Tpl.writeStr(txt, a_modelNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) $(MAINOBJ) $(OFILES) $(CPPFLAGS) "));
        txt = Tpl.writeStr(txt, a_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" $(CFLAGS) $(LDFLAGS) "));
        ret_0 = System.os();
        txt = fun_304(txt, ret_0);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mkdir -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mkdir -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/binaries\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mkdir -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/binaries/$(PLATFORM)\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("mkdir -p "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/sources\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$(DLLEXT) "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/binaries/$(PLATFORM)/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.libs "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/binaries/$(PLATFORM)/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp $(GENERATEDFILES) modelDescription.xml "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/sources/\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cp modelDescription.xml "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("/modelDescription.xml\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("cd "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; rm -f ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".fmu && zip -r ../"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(".fmu *\n"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rm -rf "));
        txt = Tpl.writeText(txt, a_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\t"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rm -f "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".def "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".o "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".so "));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_*.o\n",
                                    "\n"
                                }, true));
      then txt;
  end match;
end fun_305;

public function getPlatformString2
  input Tpl.Text txt;
  input String a_modelNamePrefix;
  input String a_platform;
  input String a_fileNamePrefix;
  input String a_dirExtra;
  input String a_libsPos1;
  input String a_libsPos2;
  input String a_omhome;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_fmudirname;
algorithm
  l_fmudirname := Tpl.writeStr(Tpl.emptyTxt, a_fileNamePrefix);
  l_fmudirname := Tpl.writeTok(l_fmudirname, Tpl.ST_STRING(".fmutmp"));
  out_txt := fun_305(txt, a_platform, a_omhome, l_fmudirname, a_libsPos2, a_libsPos1, a_dirExtra, a_modelNamePrefix, a_fileNamePrefix);
end getPlatformString2;

protected function fun_307
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_307;

protected function lm_308
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_308(txt, rest);
      then txt;
  end match;
end lm_308;

protected function fun_309
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_309;

protected function fun_310
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_310;

protected function fun_311
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_311;

protected function fun_312
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(method = i_s_method)) )
      equation
        txt = fun_311(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_312;

protected function fun_313
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_omhome;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_makefileParams_omhome)
    local
      Tpl.Text txt;
      String a_makefileParams_omhome;

    case ( txt,
           false,
           a_makefileParams_omhome )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/I\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/c/fmi1\""));
      then txt;

    case ( txt,
           _,
           a_makefileParams_omhome )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/I\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/c/fmi2\""));
      then txt;
  end match;
end fun_313;

protected function fun_314
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_FMUVersion;
      String i_makefileParams_omhome;
      String i_makefileParams_platform;
      SimCode.SimCode i_simCode;
      Option<SimCode.SimulationSettings> i_sopt;
      String i_fileNamePrefix;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      String ret_9;
      Boolean ret_8;
      Tpl.Text txt_7;
      Tpl.Text l_compilecmds;
      Tpl.Text l_extraCflags;
      Tpl.Text l_fmudirname;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, platform = i_makefileParams_platform, omhome = i_makefileParams_omhome), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix)),
           a_FMUVersion )
      equation
        l_dirExtra = fun_307(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_308(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_309(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_310(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_fmudirname = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        l_fmudirname = Tpl.writeTok(l_fmudirname, Tpl.ST_STRING(".fmutmp"));
        l_extraCflags = fun_312(Tpl.emptyTxt, i_sopt);
        txt_7 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        l_compilecmds = getPlatformString2(Tpl.emptyTxt, Tpl.textString(txt_7), i_makefileParams_platform, i_fileNamePrefix, Tpl.textString(l_dirExtra), Tpl.textString(l_libsPos1), Tpl.textString(l_libsPos2), i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulations use -O3 by default\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=\n",
                                    "MODELICAUSERCFLAGS=\n",
                                    "CXX=cl\n",
                                    "EXEEXT=.exe\n",
                                    "DLLEXT=.dll\n",
                                    "FMUEXT=.fmu\n",
                                    "PLATLINUX = linux32\n",
                                    "PLATWIN32 = win32\n",
                                    "\n",
                                    "# /Od - Optimization disabled\n",
                                    "# /EHa enable C++ EH (w/ SEH exceptions)\n",
                                    "# /fp:except - consider floating-point exceptions when generating code\n",
                                    "# /arch:SSE2 - enable use of instructions available with SSE2 enabled CPUs\n",
                                    "# /I - Include Directories\n",
                                    "# /DNOMINMAX - Define NOMINMAX (does what it says)\n",
                                    "# /TP - Use C++ Compiler\n",
                                    "CFLAGS=/Od /ZI /EHa /fp:except /I\""
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/c\" "));
        ret_8 = stringEq(a_FMUVersion, "2.0");
        txt = fun_313(txt, ret_8, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " /I. /DNOMINMAX /TP /DNO_INTERACTIVE_DEPENDENCY\n",
                                    "\n",
                                    "# /ZI enable Edit and Continue debug info\n",
                                    "CDFLAGS = /ZI\n",
                                    "\n",
                                    "# /MD - link with MSVCRT.LIB\n",
                                    "# /link - [linker options and libraries]\n",
                                    "# /LIBPATH: - Directories where libs can be found\n",
                                    "LDFLAGS=/MD /link /dll /debug /pdb:\""
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".pdb\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/msvc/\" /LIBPATH:\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc/msvc/release/\" "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_libsPos2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " f2c.lib initialization.lib libexpat.lib math-support.lib meta.lib ModelicaExternalC.lib results.lib simulation.lib solver.lib sundials_kinsol.lib sundials_nvecserial.lib util.lib lapack_win32_MT.lib\n",
                                    "\n",
                                    "# /MDd link with MSVCRTD.LIB debug lib\n",
                                    "# lib names should not be appended with a d just switch to lib/omc/msvc/debug\n",
                                    "\n",
                                    "\n",
                                    "FILEPREFIX="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "MAINFILE=$(FILEPREFIX).c\n",
                                    "MAINOBJ=$(FILEPREFIX).obj\n",
                                    "CFILES="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c \\\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_01exo.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_02nls.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_03lsy.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_04set.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_05evt.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_06inz.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_07dly.c \\\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_08bnd.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_09alg.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_10asr.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_11mix.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_12jac.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_13opt.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_14lnz.c\n",
                                    "OFILES=$(CFILES:.c=.obj)\n",
                                    "GENERATEDFILES=$(MAINFILE) "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.makefile "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_literals.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_11mix.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_12jac.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_13opt.h $(CFILES)\n",
                                    "\n",
                                    "$(FILEPREFIX)$(FMUEXT): $(FILEPREFIX)$(DLLEXT) modelDescription.xml\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if not exist "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\binaries\\$(PLATWIN32) mkdir "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "if not exist "
                                }, false));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources mkdir "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\sources\n",
                                    "\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".dll "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".lib "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".pdb "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_model.h "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_model.h\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_FMU.c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_info.c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_init.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_init.c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.c\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_functions.h\n",
                                    "copy "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_records.c "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\sources\\"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_records.c\n",
                                    "copy modelDescription.xml "
                                }, false));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\modelDescription.xml\n",
                                    "copy "
                                }, false));
        ret_9 = System.stringReplace(i_makefileParams_omhome, "/", "\\");
        txt = Tpl.writeStr(txt, ret_9);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\\lib\\omc\\libexec\\gnuplot\\binary\\libexpat-1.dll "));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\\binaries\\$(PLATWIN32)\n",
                                    "cd "
                                }, false));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"$(MINGW)\\bin\\zip.exe\" -r ../"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ".fmu *\n",
                                    "cd ..\n",
                                    "rmdir /S /Q "
                                }, false));
        txt = Tpl.writeText(txt, l_fmudirname);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "$(FILEPREFIX)$(DLLEXT): $(MAINOBJ) $(CFILES)\n",
                                    "    $(CXX) /Fe$(FILEPREFIX)$(DLLEXT) $(MAINFILE) $(FILEPREFIX)_FMU.c $(CFILES) $(CFLAGS) $(LDFLAGS)"
                                }, false));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_314;

protected function fun_315
  input Tpl.Text in_txt;
  input String in_a_modelInfo_directory;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo_directory)
    local
      Tpl.Text txt;
      String i_modelInfo_directory;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_modelInfo_directory )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-L\""));
        txt = Tpl.writeStr(txt, i_modelInfo_directory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_315;

protected function lm_316
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_lib;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_lib :: rest )
      equation
        txt = Tpl.writeStr(txt, i_lib);
        txt = Tpl.nextIter(txt);
        txt = lm_316(txt, rest);
      then txt;
  end match;
end lm_316;

protected function fun_317
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_317;

protected function fun_318
  input Tpl.Text in_txt;
  input Tpl.Text in_a_dirExtra;
  input Tpl.Text in_a_libsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dirExtra, in_a_libsStr)
    local
      Tpl.Text txt;
      Tpl.Text a_libsStr;

    case ( txt,
           Tpl.MEM_TEXT(tokens = {}),
           _ )
      then txt;

    case ( txt,
           _,
           a_libsStr )
      equation
        txt = Tpl.writeText(txt, a_libsStr);
      then txt;
  end match;
end fun_318;

protected function fun_319
  input Tpl.Text in_txt;
  input String in_a_s_method;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_method)
    local
      Tpl.Text txt;

    case ( txt,
           "inline-euler" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_EULER"));
      then txt;

    case ( txt,
           "inline-rungekutta" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-D_OMC_INLINE_RK"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_319;

protected function fun_320
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_method;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(method = i_s_method)) )
      equation
        txt = fun_319(txt, i_s_method);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_320;

protected function fun_321
  input Tpl.Text in_txt;
  input String in_a_makefileParams_platform;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_makefileParams_platform)
    local
      Tpl.Text txt;
      String i_makefileParams_platform;

    case ( txt,
           "linux-i686" )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("linux32"));
      then txt;

    case ( txt,
           i_makefileParams_platform )
      equation
        txt = Tpl.writeStr(txt, i_makefileParams_platform);
      then txt;
  end match;
end fun_321;

protected function fun_322
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_sopt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_sopt)
    local
      Tpl.Text txt;
      String i_s_cflags;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(cflags = i_s_cflags)) )
      equation
        txt = Tpl.writeStr(txt, i_s_cflags);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_322;

protected function fun_323
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_makefileParams_omhome;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_makefileParams_omhome)
    local
      Tpl.Text txt;
      String a_makefileParams_omhome;

    case ( txt,
           false,
           a_makefileParams_omhome )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-I\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/c/fmi1\""));
      then txt;

    case ( txt,
           _,
           a_makefileParams_omhome )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-I\""));
        txt = Tpl.writeStr(txt, a_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/c/fmi2\""));
      then txt;
  end match;
end fun_323;

protected function lm_324
  input Tpl.Text in_txt;
  input list<String> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<String> rest;
      String i_it;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      equation
        txt = Tpl.writeStr(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_324(txt, rest);
      then txt;
  end match;
end lm_324;

protected function fun_325
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_FMUVersion;
      String i_makefileParams_runtimelibs;
      String i_makefileParams_ldflags;
      list<String> i_makefileParams_includes;
      String i_makefileParams_cflags;
      String i_makefileParams_dllext;
      String i_makefileParams_exeext;
      String i_makefileParams_linker;
      String i_makefileParams_cxxcompiler;
      String i_makefileParams_ccompiler;
      String i_makefileParams_omhome;
      String i_fileNamePrefix;
      String i_makefileParams_platform;
      SimCode.SimCode i_simCode;
      Option<SimCode.SimulationSettings> i_sopt;
      list<String> i_makefileParams_libs;
      String i_modelInfo_directory;
      Boolean ret_8;
      Tpl.Text l_platformstr;
      Tpl.Text txt_6;
      Tpl.Text l_compilecmds;
      Tpl.Text l_extraCflags;
      Tpl.Text l_libsPos2;
      Tpl.Text l_libsPos1;
      Tpl.Text l_libsStr;
      Tpl.Text l_dirExtra;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(directory = i_modelInfo_directory), makefileParams = SimCode.MAKEFILE_PARAMS(libs = i_makefileParams_libs, platform = i_makefileParams_platform, omhome = i_makefileParams_omhome, ccompiler = i_makefileParams_ccompiler, cxxcompiler = i_makefileParams_cxxcompiler, linker = i_makefileParams_linker, exeext = i_makefileParams_exeext, dllext = i_makefileParams_dllext, cflags = i_makefileParams_cflags, includes = i_makefileParams_includes, ldflags = i_makefileParams_ldflags, runtimelibs = i_makefileParams_runtimelibs), simulationSettingsOpt = i_sopt, fileNamePrefix = i_fileNamePrefix)),
           a_FMUVersion )
      equation
        l_dirExtra = fun_315(Tpl.emptyTxt, i_modelInfo_directory);
        l_libsStr = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_libsStr = lm_316(l_libsStr, i_makefileParams_libs);
        l_libsStr = Tpl.popIter(l_libsStr);
        l_libsPos1 = fun_317(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_libsPos2 = fun_318(Tpl.emptyTxt, l_dirExtra, l_libsStr);
        l_extraCflags = fun_320(Tpl.emptyTxt, i_sopt);
        txt_6 = CodegenUtil.modelNamePrefix(Tpl.emptyTxt, i_simCode);
        l_compilecmds = getPlatformString2(Tpl.emptyTxt, Tpl.textString(txt_6), i_makefileParams_platform, i_fileNamePrefix, Tpl.textString(l_dirExtra), Tpl.textString(l_libsPos1), Tpl.textString(l_libsPos2), i_makefileParams_omhome);
        l_platformstr = fun_321(Tpl.emptyTxt, i_makefileParams_platform);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "# Makefile generated by OpenModelica\n",
                                    "\n",
                                    "# Simulation of the fmu with dymola does not work\n",
                                    "# with inline-small-functions\n",
                                    "SIM_OR_DYNLOAD_OPT_LEVEL=-O #-O2  -fno-inline-small-functions\n",
                                    "CC="
                                }, false));
        txt = Tpl.writeStr(txt, i_makefileParams_ccompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CXX="));
        txt = Tpl.writeStr(txt, i_makefileParams_cxxcompiler);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LINK="));
        txt = Tpl.writeStr(txt, i_makefileParams_linker);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("EXEEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_exeext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("DLLEXT="));
        txt = Tpl.writeStr(txt, i_makefileParams_dllext);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS_BASED_ON_INIT_FILE="));
        txt = Tpl.writeText(txt, l_extraCflags);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("PLATFORM = "));
        txt = Tpl.writeText(txt, l_platformstr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("PLAT34 = "));
        txt = Tpl.writeStr(txt, i_makefileParams_platform);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CFLAGS=$(CFLAGS_BASED_ON_INIT_FILE) "));
        txt = Tpl.writeStr(txt, i_makefileParams_cflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = fun_322(txt, i_sopt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CPPFLAGS=-I\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/include/omc/c\" "));
        ret_8 = stringEq(a_FMUVersion, "2.0");
        txt = fun_323(txt, ret_8, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -I. "));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_324(txt, i_makefileParams_includes);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LDFLAGS=-L\""));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\" -Wl,-rpath,\'"));
        txt = Tpl.writeStr(txt, i_makefileParams_omhome);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/lib/omc\' -lSimulationRuntimeC -linteractive "));
        txt = Tpl.writeStr(txt, i_makefileParams_ldflags);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_makefileParams_runtimelibs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeText(txt, l_dirExtra);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "PERL=perl\n",
                                    "MAINFILE="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_FMU.c\n",
                                    "MAINOBJ="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_FMU.o\n",
                                    "CFILES="
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(".c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_records.c \\\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_01exo.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_02nls.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_03lsy.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_04set.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_05evt.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_06inz.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_07dly.c \\\n"));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_08bnd.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_09alg.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_10asr.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_11mix.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_12jac.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_13opt.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_14lnz.c\n",
                                    "OFILES=$(CFILES:.c=.o)\n",
                                    "GENERATEDFILES=$(MAINFILE) "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU.makefile "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_literals.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_model.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_includes.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_functions.h  "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_11mix.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_12jac.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_13opt.h "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_init.c "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info.c $(CFILES) "));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_FMU.libs\n",
                                    "\n",
                                    "# This is to make sure that "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_*.c are always compiled.\n",
                                    ".PHONY: $(CFILES)\n",
                                    "\n",
                                    "PHONY: "
                                }, false));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_FMU\n"));
        txt = Tpl.writeText(txt, l_compilecmds);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_325;

public function fmuMakefile
  input Tpl.Text in_txt;
  input String in_a_target;
  input SimCode.SimCode in_a_simCode;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_target, in_a_simCode, in_a_FMUVersion)
    local
      Tpl.Text txt;
      SimCode.SimCode a_simCode;
      String a_FMUVersion;
      String i_target;
      Tpl.Text txt_0;

    case ( txt,
           "msvc",
           a_simCode,
           a_FMUVersion )
      equation
        txt = fun_314(txt, a_simCode, a_FMUVersion);
      then txt;

    case ( txt,
           "gcc",
           a_simCode,
           a_FMUVersion )
      equation
        txt = fun_325(txt, a_simCode, a_FMUVersion);
      then txt;

    case ( txt,
           i_target,
           _,
           _ )
      equation
        txt_0 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("target "));
        txt_0 = Tpl.writeStr(txt_0, i_target);
        txt_0 = Tpl.writeTok(txt_0, Tpl.ST_STRING(" is not handled!"));
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("CodegenFMU.tpl", 1739, 9), Tpl.textString(txt_0));
      then txt;
  end match;
end fmuMakefile;

protected function fun_327
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fileNamePrefix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fileNamePrefix)
    local
      Tpl.Text txt;
      String a_fileNamePrefix;

    case ( txt,
           false,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("EXPORTS\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiCompletedIntegratorStep @1\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiEventUpdate @2\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiFreeModelInstance @3\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetBoolean @4\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetContinuousStates @5\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetDerivatives @6\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetEventIndicators @7\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetInteger @8\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetModelTypesPlatform @9\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetNominalContinuousStates @10\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetReal @11\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetStateValueReferences @12\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetString @13\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetVersion @14\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiInitialize @15\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiInstantiateModel @16\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetBoolean @17\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetContinuousStates @18\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetDebugLogging @19\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetExternalFunction @20\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetInteger @21\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetReal @22\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetString @23\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetTime @24\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_fmiTerminate @25"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           a_fileNamePrefix )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "EXPORTS\n",
                                    "  ;***************************************************\n",
                                    "  ;Common Functions\n",
                                    "  ;****************************************************\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetTypesPlatform @1\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetVersion @2\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetDebugLogging @3\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiInstantiate @4\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiFreeInstance @5\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetupExperiment @6\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiEnterInitializationMode @7\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiExitInitializationMode @8\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiTerminate @9\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiReset @10\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetReal @11\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetInteger @12\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetBoolean @13\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetString @14\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetReal @15\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetInteger @16\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetBoolean @17\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetString @18\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetFMUstate @19\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetFMUstate @20\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiFreeFMUstate @21\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSerializedFMUstateSize @22\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSerializeFMUstate @23\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiDeSerializeFMUstate @24\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_fmiGetDirectionalDerivative @25\n",
                                    ";***************************************************\n",
                                    ";Functions for FMI for Model Exchange\n",
                                    ";****************************************************\n"
                                }, true));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiEnterEventMode @26\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiNewDiscreteStates @27\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiEnterContinuousTimeMode @28\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiCompletedIntegratorStep @29\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetTime @30\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiSetContinuousStates @31\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetDerivatives @32\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetEventIndicators @33\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_fmiGetContinuousStates @34\n"));
        txt = Tpl.writeStr(txt, a_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_fmiGetNominalsOfContinuousStates @35"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_327;

public function fmudeffile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input String in_a_FMUVersion;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_FMUVersion)
    local
      Tpl.Text txt;
      String a_FMUVersion;
      String i_fileNamePrefix;
      Boolean ret_0;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = _), makefileParams = SimCode.MAKEFILE_PARAMS(ccompiler = _), simulationSettingsOpt = _, fileNamePrefix = i_fileNamePrefix),
           a_FMUVersion )
      equation
        ret_0 = stringEq(a_FMUVersion, "2.0");
        txt = fun_327(txt, ret_0, i_fileNamePrefix);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fmudeffile;

protected function fun_329
  input Tpl.Text in_txt;
  input FMI.Info in_a_fmiInfo;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiInfo, in_a_fmi)
    local
      Tpl.Text txt;
      FMI.FmiImport a_fmi;

    case ( txt,
           FMI.INFO(fmiVersion = "1.0", fmiType = 0),
           a_fmi )
      equation
        txt = importFMU1ModelExchange(txt, a_fmi);
      then txt;

    case ( txt,
           FMI.INFO(fmiVersion = "1.0", fmiType = 1),
           a_fmi )
      equation
        txt = importFMU1CoSimulationStandAlone(txt, a_fmi);
      then txt;

    case ( txt,
           FMI.INFO(fmiVersion = "2.0", fmiType = 1),
           a_fmi )
      equation
        txt = importFMU2ModelExchange(txt, a_fmi);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_329;

public function importFMUModelica
  input Tpl.Text in_txt;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmi)
    local
      Tpl.Text txt;
      FMI.FmiImport i_fmi;
      FMI.Info i_fmiInfo;

    case ( txt,
           (i_fmi as FMI.FMIIMPORT(fmiInfo = i_fmiInfo)) )
      equation
        txt = fun_329(txt, i_fmiInfo, i_fmi);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end importFMUModelica;

protected function fun_331
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fmiInfo_fmiDescription;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiDescription)
    local
      Tpl.Text txt;
      String a_fmiInfo_fmiDescription;

    case ( txt,
           false,
           a_fmiInfo_fmiDescription )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \""));
        txt = Tpl.writeStr(txt, a_fmiInfo_fmiDescription);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_331;

protected function fun_332
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesReturnNames;

    case ( txt,
           false,
           a_realInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_realInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_332;

protected function fun_333
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesReturnNames;

    case ( txt,
           false,
           a_integerInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_integerInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_333;

protected function fun_334
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesReturnNames;

    case ( txt,
           false,
           a_booleanInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_booleanInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_334;

protected function fun_335
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringInputVariablesReturnNames;

    case ( txt,
           false,
           a_stringInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_stringInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_335;

protected function fun_336
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  fmi_x := fmi1Functions.fmi1GetContinuousStates(fmi1me, numberOfContinuousStates, flowParamsStart);"));
      then txt;
  end match;
end fun_336;

protected function fun_337
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesNames;
  input Tpl.Text in_a_realInputVariablesVRs;
  input Tpl.Text in_a_realInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesNames, in_a_realInputVariablesVRs, in_a_realInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesNames;
      Tpl.Text a_realInputVariablesVRs;
      Tpl.Text a_realInputVariablesReturnNames;

    case ( txt,
           false,
           a_realInputVariablesNames,
           a_realInputVariablesVRs,
           a_realInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetReal(fmi1me, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_337;

protected function fun_338
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesNames;
  input Tpl.Text in_a_integerInputVariablesVRs;
  input Tpl.Text in_a_integerInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesNames, in_a_integerInputVariablesVRs, in_a_integerInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesNames;
      Tpl.Text a_integerInputVariablesVRs;
      Tpl.Text a_integerInputVariablesReturnNames;

    case ( txt,
           false,
           a_integerInputVariablesNames,
           a_integerInputVariablesVRs,
           a_integerInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetInteger(fmi1me, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_338;

protected function fun_339
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesNames;
  input Tpl.Text in_a_booleanInputVariablesVRs;
  input Tpl.Text in_a_booleanInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesNames, in_a_booleanInputVariablesVRs, in_a_booleanInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesNames;
      Tpl.Text a_booleanInputVariablesVRs;
      Tpl.Text a_booleanInputVariablesReturnNames;

    case ( txt,
           false,
           a_booleanInputVariablesNames,
           a_booleanInputVariablesVRs,
           a_booleanInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetBoolean(fmi1me, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_339;

protected function fun_340
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringStartVariablesNames;
  input Tpl.Text in_a_stringInputVariablesVRs;
  input Tpl.Text in_a_stringInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringStartVariablesNames, in_a_stringInputVariablesVRs, in_a_stringInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringStartVariablesNames;
      Tpl.Text a_stringInputVariablesVRs;
      Tpl.Text a_stringInputVariablesReturnNames;

    case ( txt,
           false,
           a_stringStartVariablesNames,
           a_stringInputVariablesVRs,
           a_stringInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetString(fmi1me, {"));
        txt = Tpl.writeText(txt, a_stringInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_stringStartVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_340;

protected function fun_341
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realOutputVariablesVRs;
  input Tpl.Text in_a_realOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realOutputVariablesVRs, in_a_realOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realOutputVariablesVRs;
      Tpl.Text a_realOutputVariablesNames;

    case ( txt,
           false,
           a_realOutputVariablesVRs,
           a_realOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetReal(fmi1me, {"));
        txt = Tpl.writeText(txt, a_realOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_341;

protected function fun_342
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerOutputVariablesVRs;
  input Tpl.Text in_a_integerOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerOutputVariablesVRs, in_a_integerOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerOutputVariablesVRs;
      Tpl.Text a_integerOutputVariablesNames;

    case ( txt,
           false,
           a_integerOutputVariablesVRs,
           a_integerOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetInteger(fmi1me, {"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_342;

protected function fun_343
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanOutputVariablesVRs;
  input Tpl.Text in_a_booleanOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanOutputVariablesVRs, in_a_booleanOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanOutputVariablesVRs;
      Tpl.Text a_booleanOutputVariablesNames;

    case ( txt,
           false,
           a_booleanOutputVariablesVRs,
           a_booleanOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetBoolean(fmi1me, {"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_343;

protected function fun_344
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringOutputVariablesVRs;
  input Tpl.Text in_a_stringOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringOutputVariablesVRs, in_a_stringOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringOutputVariablesVRs;
      Tpl.Text a_stringOutputVariablesNames;

    case ( txt,
           false,
           a_stringOutputVariablesVRs,
           a_stringOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetString(fmi1me, {"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_344;

protected function lm_345
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_eventIndicator;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eventIndicator :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("change(fmi_z_positive["));
        txt = Tpl.writeStr(txt, intString(i_eventIndicator));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
        txt = Tpl.nextIter(txt);
        txt = lm_345(txt, rest);
      then txt;
  end match;
end lm_345;

protected function fun_346
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<Integer> in_a_fmiInfo_fmiNumberOfEventIndicators;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiNumberOfEventIndicators)
    local
      Tpl.Text txt;
      list<Integer> a_fmiInfo_fmiNumberOfEventIndicators;

    case ( txt,
           false,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  when {not initial(), triggerDSSEvent > flowStatesInputs, nextEventTime < time} then"));
      then txt;

    case ( txt,
           _,
           a_fmiInfo_fmiNumberOfEventIndicators )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when {("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" or ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_345(txt, a_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") and not initial(),triggerDSSEvent > flowStatesInputs, nextEventTime < time} then"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_346;

protected function lm_347
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_continuousStates;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_continuousStates :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit(fmi_x["));
        txt = Tpl.writeStr(txt, intString(i_continuousStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("], fmi_x_new["));
        txt = Tpl.writeStr(txt, intString(i_continuousStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]);"));
        txt = Tpl.nextIter(txt);
        txt = lm_347(txt, rest);
      then txt;
  end match;
end lm_347;

protected function fun_348
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<Integer> in_a_fmiInfo_fmiNumberOfContinuousStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiNumberOfContinuousStates)
    local
      Tpl.Text txt;
      list<Integer> a_fmiInfo_fmiNumberOfContinuousStates;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fmiInfo_fmiNumberOfContinuousStates )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    if newStatesAvailable then\n",
                                    "      fmi_x_new := fmi1Functions.fmi1GetContinuousStates(fmi1me, numberOfContinuousStates, flowStatesInputs);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_347(txt, a_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    end if;"));
      then txt;
  end match;
end fun_348;

protected function fun_349
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_349;

protected function fun_350
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_350;

protected function fun_351
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_351;

protected function fun_352
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_352;

protected function fun_353
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_353;

protected function fun_354
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_354;

protected function fun_355
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_355;

protected function fun_356
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_356;

protected function fun_357
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_357;

protected function fun_358
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_358;

protected function fun_359
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_359;

protected function fun_360
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_360;

protected function fun_361
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_361;

protected function fun_362
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_362;

protected function fun_363
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_363;

protected function fun_364
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_364;

protected function fun_365
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_365;

protected function fun_366
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_366;

public function importFMU1ModelExchange
  input Tpl.Text in_txt;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmi)
    local
      Tpl.Text txt;
      String i_platform;
      Real i_fmiExperimentAnnotation_fmiExperimentTolerance;
      Real i_fmiExperimentAnnotation_fmiExperimentStopTime;
      Real i_fmiExperimentAnnotation_fmiExperimentStartTime;
      list<Integer> i_fmiInfo_fmiNumberOfEventIndicators;
      list<Integer> i_fmiInfo_fmiNumberOfContinuousStates;
      Boolean i_generateOutputConnectors;
      Boolean i_generateInputConnectors;
      Boolean i_fmiDebugOutput;
      Integer i_fmiLogLevel;
      String i_fmuWorkingDirectory;
      list<FMI.TypeDefinitions> i_fmiTypeDefinitionsList;
      String i_fmiInfo_fmiDescription;
      FMI.Info i_fmiInfo;
      String i_fmiInfo_fmiModelIdentifier;
      list<FMI.ModelVariables> i_fmiModelVariablesList;
      String ret_68;
      Boolean ret_67;
      Boolean ret_66;
      Boolean ret_65;
      Boolean ret_64;
      Boolean ret_63;
      Boolean ret_62;
      Boolean ret_61;
      Boolean ret_60;
      Boolean ret_59;
      Boolean ret_58;
      Boolean ret_57;
      Boolean ret_56;
      Boolean ret_55;
      Boolean ret_54;
      Boolean ret_53;
      Boolean ret_52;
      Boolean ret_51;
      Boolean ret_50;
      Boolean ret_49;
      Integer ret_48;
      Boolean ret_47;
      Integer ret_46;
      Boolean ret_45;
      Boolean ret_44;
      Boolean ret_43;
      Boolean ret_42;
      Boolean ret_41;
      Boolean ret_40;
      Boolean ret_39;
      Boolean ret_38;
      Boolean ret_37;
      Boolean ret_36;
      Boolean ret_35;
      Boolean ret_34;
      Boolean ret_33;
      Boolean ret_32;
      Boolean ret_31;
      Boolean ret_30;
      Boolean ret_29;
      Integer ret_28;
      Boolean ret_27;
      Boolean ret_26;
      Boolean ret_25;
      Boolean ret_24;
      Integer ret_23;
      Integer ret_22;
      Boolean ret_21;
      String ret_20;
      Tpl.Text l_stringOutputVariablesNames;
      Tpl.Text l_stringOutputVariablesVRs;
      Tpl.Text l_booleanOutputVariablesNames;
      Tpl.Text l_booleanOutputVariablesVRs;
      Tpl.Text l_integerOutputVariablesNames;
      Tpl.Text l_integerOutputVariablesVRs;
      Tpl.Text l_realOutputVariablesNames;
      Tpl.Text l_realOutputVariablesVRs;
      Tpl.Text l_stringInputVariablesReturnNames;
      Tpl.Text l_stringStartVariablesNames;
      Tpl.Text l_stringInputVariablesVRs;
      Tpl.Text l_booleanInputVariablesReturnNames;
      Tpl.Text l_booleanInputVariablesNames;
      Tpl.Text l_booleanInputVariablesVRs;
      Tpl.Text l_integerInputVariablesReturnNames;
      Tpl.Text l_integerInputVariablesNames;
      Tpl.Text l_integerInputVariablesVRs;
      Tpl.Text l_realInputVariablesReturnNames;
      Tpl.Text l_realInputVariablesNames;
      Tpl.Text l_realInputVariablesVRs;

    case ( txt,
           FMI.FMIIMPORT(fmiInfo = (i_fmiInfo as FMI.INFO(fmiModelIdentifier = i_fmiInfo_fmiModelIdentifier, fmiDescription = i_fmiInfo_fmiDescription, fmiNumberOfContinuousStates = i_fmiInfo_fmiNumberOfContinuousStates, fmiNumberOfEventIndicators = i_fmiInfo_fmiNumberOfEventIndicators)), fmiExperimentAnnotation = FMI.EXPERIMENTANNOTATION(fmiExperimentStartTime = i_fmiExperimentAnnotation_fmiExperimentStartTime, fmiExperimentStopTime = i_fmiExperimentAnnotation_fmiExperimentStopTime, fmiExperimentTolerance = i_fmiExperimentAnnotation_fmiExperimentTolerance), fmiModelVariablesList = i_fmiModelVariablesList, fmiTypeDefinitionsList = i_fmiTypeDefinitionsList, fmuWorkingDirectory = i_fmuWorkingDirectory, fmiLogLevel = i_fmiLogLevel, fmiDebugOutput = i_fmiDebugOutput, generateInputConnectors = i_generateInputConnectors, generateOutputConnectors = i_generateOutputConnectors, platform = i_platform) )
      equation
        l_realInputVariablesVRs = dumpInputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesNames = dumpInputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesReturnNames = dumpInputRealVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesVRs = dumpInputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesNames = dumpInputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesReturnNames = dumpInputIntegerVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesVRs = dumpInputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesNames = dumpInputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesReturnNames = dumpInputBooleanVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesVRs = dumpInputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringStartVariablesNames = dumpInputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesReturnNames = dumpInputStringVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesVRs = dumpOutputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesNames = dumpOutputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesVRs = dumpOutputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesNames = dumpOutputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesVRs = dumpOutputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesNames = dumpOutputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesVRs = dumpOutputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesNames = dumpOutputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model "));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_20 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_20);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU"));
        ret_21 = stringEq(i_fmiInfo_fmiDescription, "");
        txt = fun_331(txt, ret_21, i_fmiInfo_fmiDescription);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpFMITypeDefinitions(txt, i_fmiTypeDefinitionsList);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant String fmuWorkingDir = \""));
        txt = Tpl.writeStr(txt, i_fmuWorkingDirectory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "parameter Integer logLevel = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_fmiLogLevel));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"log level used during the loading of FMU\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "parameter Boolean debugLogging = "
                                }, false));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_fmiDebugOutput));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"enables the FMU simulation logging\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "FMI1ModelExchange fmi1me = FMI1ModelExchange(logLevel, fmuWorkingDir, \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\", debugLogging);\n"));
        txt = dumpFMIModelVariablesList(txt, i_fmiModelVariablesList, i_fmiTypeDefinitionsList, i_generateInputConnectors, i_generateOutputConnectors);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant Integer numberOfContinuousStates = "));
        ret_22 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.writeStr(txt, intString(ret_22));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "Real fmi_x[numberOfContinuousStates] \"States\";\n",
                                    "Real fmi_x_new[numberOfContinuousStates] \"New States\";\n",
                                    "constant Integer numberOfEventIndicators = "
                                }, false));
        ret_23 = listLength(i_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.writeStr(txt, intString(ret_23));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "Real fmi_z[numberOfEventIndicators] \"Events Indicators\";\n",
                                    "Boolean fmi_z_positive[numberOfEventIndicators];\n",
                                    "Real flowTime;\n",
                                    "parameter Real flowParamsStart(fixed=false);\n"
                                }, true));
        ret_24 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_332(txt, ret_24, l_realInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_25 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_333(txt, ret_25, l_integerInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_26 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_334(txt, ret_26, l_booleanInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_27 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_335(txt, ret_27, l_stringInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Real flowStatesInputs;\n",
                                    "Boolean callEventUpdate;\n",
                                    "constant Boolean intermediateResults = false;\n",
                                    "Boolean newStatesAvailable;\n",
                                    "Real triggerDSSEvent;\n",
                                    "Real nextEventTime;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "initial algorithm\n",
                                    "  flowParamsStart := 0;\n"
                                }, true));
        ret_28 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        ret_29 = intGt(ret_28, 0);
        txt = fun_336(txt, ret_29);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "equation\n",
                                    "  flowTime = fmi1Functions.fmi1SetTime(fmi1me, time);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_30 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_337(txt, ret_30, l_realInputVariablesNames, l_realInputVariablesVRs, l_realInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_31 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_338(txt, ret_31, l_integerInputVariablesNames, l_integerInputVariablesVRs, l_integerInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_32 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_339(txt, ret_32, l_booleanInputVariablesNames, l_booleanInputVariablesVRs, l_booleanInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_33 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_340(txt, ret_33, l_stringStartVariablesNames, l_stringInputVariablesVRs, l_stringInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "flowStatesInputs = fmi1Functions.fmi1SetContinuousStates(fmi1me, fmi_x, flowParamsStart + flowTime);\n",
                                    "der(fmi_x) = fmi1Functions.fmi1GetDerivatives(fmi1me, numberOfContinuousStates, flowStatesInputs);\n",
                                    "fmi_z  = fmi1Functions.fmi1GetEventIndicators(fmi1me, numberOfEventIndicators, flowStatesInputs);\n",
                                    "for i in 1:size(fmi_z,1) loop\n",
                                    "  fmi_z_positive[i] = if not terminal() then fmi_z[i] > 0 else pre(fmi_z_positive[i]);\n",
                                    "end for;\n",
                                    "callEventUpdate = fmi1Functions.fmi1CompletedIntegratorStep(fmi1me, flowStatesInputs);\n",
                                    "triggerDSSEvent = noEvent(if callEventUpdate then flowStatesInputs+1.0 else flowStatesInputs-1.0);\n",
                                    "nextEventTime = fmi1Functions.fmi1nextEventTime(fmi1me, flowStatesInputs);\n"
                                }, true));
        ret_34 = stringEq(Tpl.textString(l_realOutputVariablesNames), "");
        ret_35 = stringEq(Tpl.textString(l_realOutputVariablesVRs), "");
        ret_36 = boolAnd(ret_34, ret_35);
        txt = fun_341(txt, ret_36, l_realOutputVariablesVRs, l_realOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_37 = stringEq(Tpl.textString(l_integerOutputVariablesNames), "");
        ret_38 = stringEq(Tpl.textString(l_integerOutputVariablesVRs), "");
        ret_39 = boolAnd(ret_37, ret_38);
        txt = fun_342(txt, ret_39, l_integerOutputVariablesVRs, l_integerOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_40 = stringEq(Tpl.textString(l_booleanOutputVariablesNames), "");
        ret_41 = stringEq(Tpl.textString(l_booleanOutputVariablesVRs), "");
        ret_42 = boolAnd(ret_40, ret_41);
        txt = fun_343(txt, ret_42, l_booleanOutputVariablesVRs, l_booleanOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_43 = stringEq(Tpl.textString(l_stringOutputVariablesNames), "");
        ret_44 = stringEq(Tpl.textString(l_stringOutputVariablesVRs), "");
        ret_45 = boolAnd(ret_43, ret_44);
        txt = fun_344(txt, ret_45, l_stringOutputVariablesVRs, l_stringOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        txt = dumpOutputGetEnumerationVariables(txt, i_fmiModelVariablesList, i_fmiTypeDefinitionsList, "fmi1Functions.fmi1GetInteger", "fmi1me");
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("algorithm\n"));
        ret_46 = listLength(i_fmiInfo_fmiNumberOfEventIndicators);
        ret_47 = intGt(ret_46, 0);
        txt = fun_346(txt, ret_47, i_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    (newStatesAvailable) := fmi1Functions.fmi1EventUpdate(fmi1me, intermediateResults, flowStatesInputs);\n"));
        ret_48 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        ret_49 = intGt(ret_48, 0);
        txt = fun_348(txt, ret_49, i_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  end when;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation(experiment(StartTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStartTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", StopTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", Tolerance="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentTolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "));\n",
                                    "annotation (Icon(graphics={\n",
                                    "    Rectangle(\n",
                                    "      extent={{-100,100},{100,-100}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      fillColor={240,240,240},\n",
                                    "      fillPattern=FillPattern.Solid,\n",
                                    "      lineThickness=0.5),\n",
                                    "    Text(\n",
                                    "      extent={{-100,40},{100,0}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"%name\"),\n",
                                    "    Text(\n",
                                    "      extent={{-100,-50},{100,-90}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"V1.0\")}));\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected\n",
                                    "  class FMI1ModelExchange\n",
                                    "    extends ExternalObject;\n",
                                    "      function constructor\n",
                                    "        input Integer logLevel;\n",
                                    "        input String workingDirectory;\n",
                                    "        input String instanceName;\n",
                                    "        input Boolean debugLogging;\n",
                                    "        output FMI1ModelExchange fmi1me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1me = FMI1ModelExchangeConstructor_OMC(logLevel, workingDirectory, instanceName, debugLogging) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_50 = stringEq(i_platform, "win32");
        txt = fun_349(txt, ret_50);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end constructor;\n",
                                    "\n",
                                    "      function destructor\n",
                                    "        input FMI1ModelExchange fmi1me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" FMI1ModelExchangeDestructor_OMC(fmi1me) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_51 = stringEq(i_platform, "win32");
        txt = fun_350(txt, ret_51);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end destructor;\n",
                                    "  end FMI1ModelExchange;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpFMITypeDefinitionsMappingFunctions(txt, i_fmiTypeDefinitionsList);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = dumpFMITypeDefinitionsArrayMappingFunctions(txt, i_fmiTypeDefinitionsList);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "package fmi1Functions\n",
                                    "  function fmi1SetTime\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real inTime;\n",
                                    "    output Real status;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" status = fmi1SetTime_OMC(fmi1me, inTime) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_52 = stringEq(i_platform, "win32");
        txt = fun_351(txt, ret_52);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetTime;\n",
                                    "\n",
                                    "  function fmi1GetContinuousStates\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Integer numberOfContinuousStates;\n",
                                    "    input Real inFlowParams;\n",
                                    "    output Real fmi_x[numberOfContinuousStates];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetContinuousStates_OMC(fmi1me, numberOfContinuousStates, inFlowParams, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_53 = stringEq(i_platform, "win32");
        txt = fun_352(txt, ret_53);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetContinuousStates;\n",
                                    "\n",
                                    "  function fmi1SetContinuousStates\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real fmi_x[:];\n",
                                    "    input Real inFlowParams;\n",
                                    "    output Real outFlowStates;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outFlowStates = fmi1SetContinuousStates_OMC(fmi1me, size(fmi_x, 1), inFlowParams, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_54 = stringEq(i_platform, "win32");
        txt = fun_353(txt, ret_54);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetContinuousStates;\n",
                                    "\n",
                                    "  function fmi1GetDerivatives\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Integer numberOfContinuousStates;\n",
                                    "    input Real inFlowStates;\n",
                                    "    output Real fmi_x[numberOfContinuousStates];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetDerivatives_OMC(fmi1me, numberOfContinuousStates, inFlowStates, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_55 = stringEq(i_platform, "win32");
        txt = fun_354(txt, ret_55);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetDerivatives;\n",
                                    "\n",
                                    "  function fmi1GetEventIndicators\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Integer numberOfEventIndicators;\n",
                                    "    input Real inFlowStates;\n",
                                    "    output Real fmi_z[numberOfEventIndicators];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetEventIndicators_OMC(fmi1me, numberOfEventIndicators, inFlowStates, fmi_z) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_56 = stringEq(i_platform, "win32");
        txt = fun_355(txt, ret_56);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetEventIndicators;\n",
                                    "\n",
                                    "  function fmi1GetReal\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real realValuesReferences[:];\n",
                                    "    input Real inFlowStatesInput;\n",
                                    "    output Real realValues[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetReal_OMC(fmi1me, size(realValuesReferences, 1), realValuesReferences, inFlowStatesInput, realValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_57 = stringEq(i_platform, "win32");
        txt = fun_356(txt, ret_57);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetReal;\n",
                                    "\n",
                                    "  function fmi1SetReal\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real realValuesReferences[:];\n",
                                    "    input Real realValues[size(realValuesReferences, 1)];\n",
                                    "    output Real out_Values[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetReal_OMC(fmi1me, size(realValuesReferences, 1), realValuesReferences, realValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_58 = stringEq(i_platform, "win32");
        txt = fun_357(txt, ret_58);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetReal;\n",
                                    "\n",
                                    "  function fmi1GetInteger\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real integerValuesReferences[:];\n",
                                    "    input Real inFlowStatesInput;\n",
                                    "    output Integer integerValues[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetInteger_OMC(fmi1me, size(integerValuesReferences, 1), integerValuesReferences, inFlowStatesInput, integerValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_59 = stringEq(i_platform, "win32");
        txt = fun_358(txt, ret_59);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetInteger;\n",
                                    "\n",
                                    "  function fmi1SetInteger\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real integerValuesReferences[:];\n",
                                    "    input Integer integerValues[size(integerValuesReferences, 1)];\n",
                                    "    output Real out_Values[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetInteger_OMC(fmi1me, size(integerValuesReferences, 1), integerValuesReferences, integerValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_60 = stringEq(i_platform, "win32");
        txt = fun_359(txt, ret_60);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetInteger;\n",
                                    "\n",
                                    "  function fmi1GetBoolean\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real booleanValuesReferences[:];\n",
                                    "    input Real inFlowStatesInput;\n",
                                    "    output Boolean booleanValues[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetBoolean_OMC(fmi1me, size(booleanValuesReferences, 1), booleanValuesReferences, inFlowStatesInput, booleanValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_61 = stringEq(i_platform, "win32");
        txt = fun_360(txt, ret_61);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetBoolean;\n",
                                    "\n",
                                    "  function fmi1SetBoolean\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real booleanValuesReferences[:];\n",
                                    "    input Boolean booleanValues[size(booleanValuesReferences, 1)];\n",
                                    "    output Real out_Values[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetBoolean_OMC(fmi1me, size(booleanValuesReferences, 1), booleanValuesReferences, booleanValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_62 = stringEq(i_platform, "win32");
        txt = fun_361(txt, ret_62);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetBoolean;\n",
                                    "\n",
                                    "  function fmi1GetString\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real stringValuesReferences[:];\n",
                                    "    input Real inFlowStatesInput;\n",
                                    "    output String stringValues[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetString_OMC(fmi1me, size(stringValuesReferences, 1), stringValuesReferences, inFlowStatesInput, stringValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_63 = stringEq(i_platform, "win32");
        txt = fun_362(txt, ret_63);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetString;\n",
                                    "\n",
                                    "  function fmi1SetString\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real stringValuesReferences[:];\n",
                                    "    input String stringValues[size(stringValuesReferences, 1)];\n",
                                    "    output Real out_Values[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetString_OMC(fmi1me, size(stringValuesReferences, 1), stringValuesReferences, stringValues, out_Values, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_64 = stringEq(i_platform, "win32");
        txt = fun_363(txt, ret_64);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetString;\n",
                                    "\n",
                                    "  function fmi1EventUpdate\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Boolean intermediateResults;\n",
                                    "    input Real inFlowStates;\n",
                                    "    output Boolean outNewStatesAvailable;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outNewStatesAvailable = fmi1EventUpdate_OMC(fmi1me, intermediateResults, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_65 = stringEq(i_platform, "win32");
        txt = fun_364(txt, ret_65);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1EventUpdate;\n",
                                    "\n",
                                    "  function fmi1nextEventTime\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real inFlowStates;\n",
                                    "    output Real outNewnextTime;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outNewnextTime = fmi1nextEventTime_OMC(fmi1me, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_66 = stringEq(i_platform, "win32");
        txt = fun_365(txt, ret_66);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1nextEventTime;\n",
                                    "\n",
                                    "  function fmi1CompletedIntegratorStep\n",
                                    "    input FMI1ModelExchange fmi1me;\n",
                                    "    input Real inFlowStates;\n",
                                    "    output Boolean outCallEventUpdate;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outCallEventUpdate = fmi1CompletedIntegratorStep_OMC(fmi1me, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_67 = stringEq(i_platform, "win32");
        txt = fun_366(txt, ret_67);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1CompletedIntegratorStep;\n",
                                    "end fmi1Functions;\n",
                                    "\n",
                                    "package fmiStatus\n",
                                    "  constant Integer fmiOK=0;\n",
                                    "  constant Integer fmiWarning=1;\n",
                                    "  constant Integer fmiDiscard=2;\n",
                                    "  constant Integer fmiError=3;\n",
                                    "  constant Integer fmiFatal=4;\n",
                                    "  constant Integer fmiPending=5;\n",
                                    "end fmiStatus;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_68 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_68);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end importFMU1ModelExchange;

protected function fun_368
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fmiInfo_fmiDescription;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiDescription)
    local
      Tpl.Text txt;
      String a_fmiInfo_fmiDescription;

    case ( txt,
           false,
           a_fmiInfo_fmiDescription )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \""));
        txt = Tpl.writeStr(txt, a_fmiInfo_fmiDescription);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_368;

protected function fun_369
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesReturnNames;

    case ( txt,
           false,
           a_realInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_realInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_369;

protected function fun_370
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesReturnNames;

    case ( txt,
           false,
           a_integerInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_integerInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_370;

protected function fun_371
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesReturnNames;

    case ( txt,
           false,
           a_booleanInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_booleanInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_371;

protected function fun_372
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringInputVariablesReturnNames;

    case ( txt,
           false,
           a_stringInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_stringInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_372;

protected function fun_373
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesNames;
  input Tpl.Text in_a_realInputVariablesVRs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesNames, in_a_realInputVariablesVRs)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesNames;
      Tpl.Text a_realInputVariablesVRs;

    case ( txt,
           false,
           a_realInputVariablesNames,
           a_realInputVariablesVRs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi2Functions.fmi2SetReal(fmi2me, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_373;

protected function fun_374
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesNames;
  input Tpl.Text in_a_integerInputVariablesVRs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesNames, in_a_integerInputVariablesVRs)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesNames;
      Tpl.Text a_integerInputVariablesVRs;

    case ( txt,
           false,
           a_integerInputVariablesNames,
           a_integerInputVariablesVRs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi2Functions.fmi2SetInteger(fmi2me, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_374;

protected function fun_375
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesNames;
  input Tpl.Text in_a_booleanInputVariablesVRs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesNames, in_a_booleanInputVariablesVRs)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesNames;
      Tpl.Text a_booleanInputVariablesVRs;

    case ( txt,
           false,
           a_booleanInputVariablesNames,
           a_booleanInputVariablesVRs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi2Functions.fmi2SetBoolean(fmi2me, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_375;

protected function fun_376
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringStartVariablesNames;
  input Tpl.Text in_a_stringInputVariablesVRs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringStartVariablesNames, in_a_stringInputVariablesVRs)
    local
      Tpl.Text txt;
      Tpl.Text a_stringStartVariablesNames;
      Tpl.Text a_stringInputVariablesVRs;

    case ( txt,
           false,
           a_stringStartVariablesNames,
           a_stringInputVariablesVRs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi2Functions.fmi2SetString(fmi2me, {"));
        txt = Tpl.writeText(txt, a_stringInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_stringStartVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_376;

protected function fun_377
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesNames;
  input Tpl.Text in_a_realInputVariablesVRs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesNames, in_a_realInputVariablesVRs)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesNames;
      Tpl.Text a_realInputVariablesVRs;

    case ( txt,
           false,
           a_realInputVariablesNames,
           a_realInputVariablesVRs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi2Functions.fmi2SetReal(fmi2me, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_377;

protected function fun_378
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesNames;
  input Tpl.Text in_a_integerInputVariablesVRs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesNames, in_a_integerInputVariablesVRs)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesNames;
      Tpl.Text a_integerInputVariablesVRs;

    case ( txt,
           false,
           a_integerInputVariablesNames,
           a_integerInputVariablesVRs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi2Functions.fmi2SetInteger(fmi2me, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_378;

protected function fun_379
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesNames;
  input Tpl.Text in_a_booleanInputVariablesVRs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesNames, in_a_booleanInputVariablesVRs)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesNames;
      Tpl.Text a_booleanInputVariablesVRs;

    case ( txt,
           false,
           a_booleanInputVariablesNames,
           a_booleanInputVariablesVRs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi2Functions.fmi2SetBoolean(fmi2me, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_379;

protected function fun_380
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringStartVariablesNames;
  input Tpl.Text in_a_stringInputVariablesVRs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringStartVariablesNames, in_a_stringInputVariablesVRs)
    local
      Tpl.Text txt;
      Tpl.Text a_stringStartVariablesNames;
      Tpl.Text a_stringInputVariablesVRs;

    case ( txt,
           false,
           a_stringStartVariablesNames,
           a_stringInputVariablesVRs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi2Functions.fmi2SetString(fmi2me, {"));
        txt = Tpl.writeText(txt, a_stringInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_stringStartVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_380;

protected function fun_381
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realOutputVariablesVRs;
  input Tpl.Text in_a_realOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realOutputVariablesVRs, in_a_realOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realOutputVariablesVRs;
      Tpl.Text a_realOutputVariablesNames;

    case ( txt,
           false,
           a_realOutputVariablesVRs,
           a_realOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2GetReal(fmi2me, {"));
        txt = Tpl.writeText(txt, a_realOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_381;

protected function fun_382
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerOutputVariablesVRs;
  input Tpl.Text in_a_integerOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerOutputVariablesVRs, in_a_integerOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerOutputVariablesVRs;
      Tpl.Text a_integerOutputVariablesNames;

    case ( txt,
           false,
           a_integerOutputVariablesVRs,
           a_integerOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2GetInteger(fmi2me, {"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_382;

protected function fun_383
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanOutputVariablesVRs;
  input Tpl.Text in_a_booleanOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanOutputVariablesVRs, in_a_booleanOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanOutputVariablesVRs;
      Tpl.Text a_booleanOutputVariablesNames;

    case ( txt,
           false,
           a_booleanOutputVariablesVRs,
           a_booleanOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2GetBoolean(fmi2me, {"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_383;

protected function fun_384
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringOutputVariablesVRs;
  input Tpl.Text in_a_stringOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringOutputVariablesVRs, in_a_stringOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringOutputVariablesVRs;
      Tpl.Text a_stringOutputVariablesNames;

    case ( txt,
           false,
           a_stringOutputVariablesVRs,
           a_stringOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi2Functions.fmi2GetString(fmi2me, {"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_384;

protected function lm_385
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_eventIndicator;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eventIndicator :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("change(fmi_z_positive["));
        txt = Tpl.writeStr(txt, intString(i_eventIndicator));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("])"));
        txt = Tpl.nextIter(txt);
        txt = lm_385(txt, rest);
      then txt;
  end match;
end lm_385;

protected function fun_386
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<Integer> in_a_fmiInfo_fmiNumberOfEventIndicators;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiNumberOfEventIndicators)
    local
      Tpl.Text txt;
      list<Integer> a_fmiInfo_fmiNumberOfEventIndicators;

    case ( txt,
           false,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  when {not initial(), triggerDSSEvent > flowStatesInputs, nextEventTime < time} then"));
      then txt;

    case ( txt,
           _,
           a_fmiInfo_fmiNumberOfEventIndicators )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when {("));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" or ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_385(txt, a_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") and not initial(),triggerDSSEvent > flowStatesInputs, nextEventTime < time} then"));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end fun_386;

protected function lm_387
  input Tpl.Text in_txt;
  input list<Integer> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer i_continuousStates;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_continuousStates :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("reinit(fmi_x["));
        txt = Tpl.writeStr(txt, intString(i_continuousStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("], fmi_x_new["));
        txt = Tpl.writeStr(txt, intString(i_continuousStates));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]);"));
        txt = Tpl.nextIter(txt);
        txt = lm_387(txt, rest);
      then txt;
  end match;
end lm_387;

protected function fun_388
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input list<Integer> in_a_fmiInfo_fmiNumberOfContinuousStates;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiNumberOfContinuousStates)
    local
      Tpl.Text txt;
      list<Integer> a_fmiInfo_fmiNumberOfContinuousStates;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_fmiInfo_fmiNumberOfContinuousStates )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    if newStatesAvailable then\n",
                                    "      fmi_x_new := fmi2Functions.fmi2GetContinuousStates(fmi2me, numberOfContinuousStates, flowStatesInputs);\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_387(txt, a_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("    end if;"));
      then txt;
  end match;
end fun_388;

protected function fun_389
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_389;

protected function fun_390
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_390;

protected function fun_391
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_391;

protected function fun_392
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_392;

protected function fun_393
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_393;

protected function fun_394
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_394;

protected function fun_395
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_395;

protected function fun_396
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_396;

protected function fun_397
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_397;

protected function fun_398
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_398;

protected function fun_399
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_399;

protected function fun_400
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_400;

protected function fun_401
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_401;

protected function fun_402
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_402;

protected function fun_403
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_403;

protected function fun_404
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_404;

protected function fun_405
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_405;

protected function fun_406
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_406;

protected function fun_407
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_407;

protected function fun_408
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_408;

public function importFMU2ModelExchange
  input Tpl.Text in_txt;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmi)
    local
      Tpl.Text txt;
      String i_platform;
      Real i_fmiExperimentAnnotation_fmiExperimentTolerance;
      Real i_fmiExperimentAnnotation_fmiExperimentStopTime;
      Real i_fmiExperimentAnnotation_fmiExperimentStartTime;
      list<Integer> i_fmiInfo_fmiNumberOfEventIndicators;
      list<Integer> i_fmiInfo_fmiNumberOfContinuousStates;
      Boolean i_generateOutputConnectors;
      Boolean i_generateInputConnectors;
      list<FMI.TypeDefinitions> i_fmiTypeDefinitionsList;
      Boolean i_fmiDebugOutput;
      Integer i_fmiLogLevel;
      String i_fmuWorkingDirectory;
      String i_fmuFileName;
      String i_fmiInfo_fmiDescription;
      FMI.Info i_fmiInfo;
      String i_fmiInfo_fmiModelIdentifier;
      list<FMI.ModelVariables> i_fmiModelVariablesList;
      String ret_72;
      Boolean ret_71;
      Boolean ret_70;
      Boolean ret_69;
      Boolean ret_68;
      Boolean ret_67;
      Boolean ret_66;
      Boolean ret_65;
      Boolean ret_64;
      Boolean ret_63;
      Boolean ret_62;
      Boolean ret_61;
      Boolean ret_60;
      Boolean ret_59;
      Boolean ret_58;
      Boolean ret_57;
      Boolean ret_56;
      Boolean ret_55;
      Boolean ret_54;
      Boolean ret_53;
      Boolean ret_52;
      Boolean ret_51;
      Integer ret_50;
      Boolean ret_49;
      Integer ret_48;
      Boolean ret_47;
      Boolean ret_46;
      Boolean ret_45;
      Boolean ret_44;
      Boolean ret_43;
      Boolean ret_42;
      Boolean ret_41;
      Boolean ret_40;
      Boolean ret_39;
      Boolean ret_38;
      Boolean ret_37;
      Boolean ret_36;
      Boolean ret_35;
      Boolean ret_34;
      Boolean ret_33;
      Boolean ret_32;
      Boolean ret_31;
      Boolean ret_30;
      Boolean ret_29;
      Boolean ret_28;
      Boolean ret_27;
      Boolean ret_26;
      Boolean ret_25;
      Boolean ret_24;
      Integer ret_23;
      Integer ret_22;
      Boolean ret_21;
      String ret_20;
      Tpl.Text l_stringOutputVariablesNames;
      Tpl.Text l_stringOutputVariablesVRs;
      Tpl.Text l_booleanOutputVariablesNames;
      Tpl.Text l_booleanOutputVariablesVRs;
      Tpl.Text l_integerOutputVariablesNames;
      Tpl.Text l_integerOutputVariablesVRs;
      Tpl.Text l_realOutputVariablesNames;
      Tpl.Text l_realOutputVariablesVRs;
      Tpl.Text l_stringInputVariablesReturnNames;
      Tpl.Text l_stringStartVariablesNames;
      Tpl.Text l_stringInputVariablesVRs;
      Tpl.Text l_booleanInputVariablesReturnNames;
      Tpl.Text l_booleanInputVariablesNames;
      Tpl.Text l_booleanInputVariablesVRs;
      Tpl.Text l_integerInputVariablesReturnNames;
      Tpl.Text l_integerInputVariablesNames;
      Tpl.Text l_integerInputVariablesVRs;
      Tpl.Text l_realInputVariablesReturnNames;
      Tpl.Text l_realInputVariablesNames;
      Tpl.Text l_realInputVariablesVRs;

    case ( txt,
           FMI.FMIIMPORT(fmiInfo = (i_fmiInfo as FMI.INFO(fmiModelIdentifier = i_fmiInfo_fmiModelIdentifier, fmiDescription = i_fmiInfo_fmiDescription, fmiNumberOfContinuousStates = i_fmiInfo_fmiNumberOfContinuousStates, fmiNumberOfEventIndicators = i_fmiInfo_fmiNumberOfEventIndicators)), fmiExperimentAnnotation = FMI.EXPERIMENTANNOTATION(fmiExperimentStartTime = i_fmiExperimentAnnotation_fmiExperimentStartTime, fmiExperimentStopTime = i_fmiExperimentAnnotation_fmiExperimentStopTime, fmiExperimentTolerance = i_fmiExperimentAnnotation_fmiExperimentTolerance), fmiModelVariablesList = i_fmiModelVariablesList, fmuFileName = i_fmuFileName, fmuWorkingDirectory = i_fmuWorkingDirectory, fmiLogLevel = i_fmiLogLevel, fmiDebugOutput = i_fmiDebugOutput, fmiTypeDefinitionsList = i_fmiTypeDefinitionsList, generateInputConnectors = i_generateInputConnectors, generateOutputConnectors = i_generateOutputConnectors, platform = i_platform) )
      equation
        l_realInputVariablesVRs = dumpInputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesNames = dumpInputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesReturnNames = dumpInputRealVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesVRs = dumpInputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesNames = dumpInputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesReturnNames = dumpInputIntegerVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesVRs = dumpInputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesNames = dumpInputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesReturnNames = dumpInputBooleanVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesVRs = dumpInputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringStartVariablesNames = dumpInputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesReturnNames = dumpInputStringVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesVRs = dumpOutputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesNames = dumpOutputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesVRs = dumpOutputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesNames = dumpOutputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesVRs = dumpOutputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesNames = dumpOutputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesVRs = dumpOutputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesNames = dumpOutputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model "));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_20 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_20);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU"));
        ret_21 = stringEq(i_fmiInfo_fmiDescription, "");
        txt = fun_368(txt, ret_21, i_fmiInfo_fmiDescription);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant String fmuFile = \""));
        txt = Tpl.writeStr(txt, i_fmuFileName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "constant String fmuWorkingDir = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmuWorkingDirectory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "parameter Integer logLevel = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_fmiLogLevel));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"log level used during the loading of FMU\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "parameter Boolean debugLogging = "
                                }, false));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_fmiDebugOutput));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"enables the FMU simulation logging\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "FMI2ModelExchange fmi2me;\n"
                                }, true));
        txt = dumpFMIModelVariablesList(txt, i_fmiModelVariablesList, i_fmiTypeDefinitionsList, i_generateInputConnectors, i_generateOutputConnectors);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant Integer numberOfContinuousStates = "));
        ret_22 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.writeStr(txt, intString(ret_22));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "Real fmi_x[numberOfContinuousStates] \"States\";\n",
                                    "Real fmi_x_new[numberOfContinuousStates] \"New States\";\n",
                                    "constant Integer numberOfEventIndicators = "
                                }, false));
        ret_23 = listLength(i_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.writeStr(txt, intString(ret_23));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "Real fmi_z[numberOfEventIndicators] \"Events Indicators\";\n",
                                    "Boolean fmi_z_positive[numberOfEventIndicators];\n",
                                    "Real flowTime;\n",
                                    "parameter Real flowParamsStart(fixed=false);\n"
                                }, true));
        ret_24 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_369(txt, ret_24, l_realInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_25 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_370(txt, ret_25, l_integerInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_26 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_371(txt, ret_26, l_booleanInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_27 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_372(txt, ret_27, l_stringInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "Real flowStatesInputs;\n",
                                    "Boolean callEventUpdate;\n",
                                    "Boolean newStatesAvailable;\n",
                                    "Real triggerDSSEvent;\n",
                                    "Real nextEventTime;\n",
                                    "Boolean initantiateOnce(start=true, fixed=false) \"Variable to instantiate the model only once\";\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "algorithm\n",
                                    "  when initial() then\n",
                                    "    if initantiateOnce then\n",
                                    "      initantiateOnce := false;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi2me := FMI2ModelExchange(logLevel, fmuWorkingDir, \""));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\", debugLogging);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end if;\n",
                                    "  end when;\n",
                                    "  flowTime := fmi2Functions.fmi2SetTime(fmi2me, time);\n",
                                    "initial algorithm\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_28 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_373(txt, ret_28, l_realInputVariablesNames, l_realInputVariablesVRs);
        txt = Tpl.softNewLine(txt);
        ret_29 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_374(txt, ret_29, l_integerInputVariablesNames, l_integerInputVariablesVRs);
        txt = Tpl.softNewLine(txt);
        ret_30 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_375(txt, ret_30, l_booleanInputVariablesNames, l_booleanInputVariablesVRs);
        txt = Tpl.softNewLine(txt);
        ret_31 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_376(txt, ret_31, l_stringStartVariablesNames, l_stringInputVariablesVRs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "fmi2Functions.fmi2EnterInitialization(fmi2me);\n",
                                    "fmi_x := fmi2Functions.fmi2GetContinuousStates(fmi2me, numberOfContinuousStates, flowTime);\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "algorithm\n",
                                    "  when not initial() then\n",
                                    "    fmi2Functions.fmi2Functions.fmi2ExitInitialization(fmi2me);\n",
                                    "  end when;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_32 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_377(txt, ret_32, l_realInputVariablesNames, l_realInputVariablesVRs);
        txt = Tpl.softNewLine(txt);
        ret_33 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_378(txt, ret_33, l_integerInputVariablesNames, l_integerInputVariablesVRs);
        txt = Tpl.softNewLine(txt);
        ret_34 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_379(txt, ret_34, l_booleanInputVariablesNames, l_booleanInputVariablesVRs);
        txt = Tpl.softNewLine(txt);
        ret_35 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_380(txt, ret_35, l_stringStartVariablesNames, l_stringInputVariablesVRs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("flowStatesInputs := fmi2Functions.fmi2SetContinuousStates(fmi2me, fmi_x, flowParamsStart + flowTime);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "equation\n",
                                    "  der(fmi_x) = fmi2Functions.fmi2GetDerivatives(fmi2me, numberOfContinuousStates, flowStatesInputs);\n",
                                    "  fmi_z  = fmi2Functions.fmi2GetEventIndicators(fmi2me, numberOfEventIndicators, flowStatesInputs);\n",
                                    "  for i in 1:size(fmi_z,1) loop\n",
                                    "    fmi_z_positive[i] = if not terminal() then fmi_z[i] > 0 else pre(fmi_z_positive[i]);\n",
                                    "  end for;\n",
                                    "\n",
                                    "  triggerDSSEvent = noEvent(if callEventUpdate then flowStatesInputs+1.0 else flowStatesInputs-1.0);\n",
                                    "  nextEventTime = fmi2Functions.fmi2nextEventTime(fmi2me, flowStatesInputs);\n",
                                    "equation\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_36 = stringEq(Tpl.textString(l_realOutputVariablesNames), "");
        ret_37 = stringEq(Tpl.textString(l_realOutputVariablesVRs), "");
        ret_38 = boolAnd(ret_36, ret_37);
        txt = fun_381(txt, ret_38, l_realOutputVariablesVRs, l_realOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_39 = stringEq(Tpl.textString(l_integerOutputVariablesNames), "");
        ret_40 = stringEq(Tpl.textString(l_integerOutputVariablesVRs), "");
        ret_41 = boolAnd(ret_39, ret_40);
        txt = fun_382(txt, ret_41, l_integerOutputVariablesVRs, l_integerOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_42 = stringEq(Tpl.textString(l_booleanOutputVariablesNames), "");
        ret_43 = stringEq(Tpl.textString(l_booleanOutputVariablesVRs), "");
        ret_44 = boolAnd(ret_42, ret_43);
        txt = fun_383(txt, ret_44, l_booleanOutputVariablesVRs, l_booleanOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_45 = stringEq(Tpl.textString(l_stringOutputVariablesNames), "");
        ret_46 = stringEq(Tpl.textString(l_stringOutputVariablesVRs), "");
        ret_47 = boolAnd(ret_45, ret_46);
        txt = fun_384(txt, ret_47, l_stringOutputVariablesVRs, l_stringOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " callEventUpdate = fmi2Functions.fmi2CompletedIntegratorStep(fmi2me, flowStatesInputs + flowTime);\n",
                                    "algorithm\n"
                                }, true));
        ret_48 = listLength(i_fmiInfo_fmiNumberOfEventIndicators);
        ret_49 = intGt(ret_48, 0);
        txt = fun_386(txt, ret_49, i_fmiInfo_fmiNumberOfEventIndicators);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("    (newStatesAvailable) := fmi2Functions.fmi2EventUpdate(fmi2me, flowStatesInputs);\n"));
        ret_50 = listLength(i_fmiInfo_fmiNumberOfContinuousStates);
        ret_51 = intGt(ret_50, 0);
        txt = fun_388(txt, ret_51, i_fmiInfo_fmiNumberOfContinuousStates);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  end when;\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation(experiment(StartTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStartTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", StopTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", Tolerance="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentTolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "));\n",
                                    "annotation (Icon(graphics={\n",
                                    "    Rectangle(\n",
                                    "      extent={{-100,100},{100,-100}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      fillColor={240,240,240},\n",
                                    "      fillPattern=FillPattern.Solid,\n",
                                    "      lineThickness=0.5),\n",
                                    "    Text(\n",
                                    "      extent={{-100,40},{100,0}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"%name\"),\n",
                                    "    Text(\n",
                                    "      extent={{-100,-50},{100,-90}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"V2.0\")}));\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected\n",
                                    "  class FMI2ModelExchange\n",
                                    "    extends ExternalObject;\n",
                                    "      function constructor\n",
                                    "        input Integer logLevel;\n",
                                    "        input String workingDirectory;\n",
                                    "        input String instanceName;\n",
                                    "        input Boolean debugLogging;\n",
                                    "        output FMI2ModelExchange fmi2me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2me = FMI2ModelExchangeConstructor_OMC(logLevel, workingDirectory, instanceName, debugLogging) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_52 = stringEq(i_platform, "win32");
        txt = fun_389(txt, ret_52);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end constructor;\n",
                                    "\n",
                                    "      function destructor\n",
                                    "        input FMI2ModelExchange fmi2me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" FMI2ModelExchangeDestructor_OMC(fmi2me) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_53 = stringEq(i_platform, "win32");
        txt = fun_390(txt, ret_53);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end destructor;\n",
                                    "  end FMI2ModelExchange;\n",
                                    "\n",
                                    "  package fmi2Functions\n",
                                    "    function fmi2SetTime\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real inTime;\n",
                                    "      output Real status;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" status = fmi2SetTime_OMC(fmi2me, inTime) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_54 = stringEq(i_platform, "win32");
        txt = fun_391(txt, ret_54);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetTime;\n",
                                    "\n",
                                    "    function fmi2EnterInitialization\n",
                                    "      input FMI2ModelExchange fmi2me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2EnterInitializationModel_OMC(fmi2me) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_55 = stringEq(i_platform, "win32");
        txt = fun_392(txt, ret_55);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2EnterInitialization;\n",
                                    "\n",
                                    "    function fmi2ExitInitialization\n",
                                    "      input FMI2ModelExchange fmi2me;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2ExitInitializationModel_OMC(fmi2me) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_56 = stringEq(i_platform, "win32");
        txt = fun_393(txt, ret_56);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2ExitInitialization;\n",
                                    "\n",
                                    "    function fmi2GetContinuousStates\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Integer numberOfContinuousStates;\n",
                                    "      input Real inFlowParams;\n",
                                    "      output Real fmi_x[numberOfContinuousStates];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetContinuousStates_OMC(fmi2me, numberOfContinuousStates, inFlowParams, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_57 = stringEq(i_platform, "win32");
        txt = fun_394(txt, ret_57);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetContinuousStates;\n",
                                    "\n",
                                    "    function fmi2SetContinuousStates\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real fmi_x[:];\n",
                                    "      input Real inFlowParams;\n",
                                    "      output Real outFlowStates;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outFlowStates = fmi2SetContinuousStates_OMC(fmi2me, size(fmi_x, 1), inFlowParams, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_58 = stringEq(i_platform, "win32");
        txt = fun_395(txt, ret_58);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetContinuousStates;\n",
                                    "\n",
                                    "    function fmi2GetDerivatives\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Integer numberOfContinuousStates;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Real fmi_x[numberOfContinuousStates];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetDerivatives_OMC(fmi2me, numberOfContinuousStates, inFlowStates, fmi_x) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_59 = stringEq(i_platform, "win32");
        txt = fun_396(txt, ret_59);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetDerivatives;\n",
                                    "\n",
                                    "    function fmi2GetEventIndicators\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Integer numberOfEventIndicators;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Real fmi_z[numberOfEventIndicators];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetEventIndicators_OMC(fmi2me, numberOfEventIndicators, inFlowStates, fmi_z) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_60 = stringEq(i_platform, "win32");
        txt = fun_397(txt, ret_60);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetEventIndicators;\n",
                                    "\n",
                                    "    function fmi2GetReal\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real realValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Real realValues[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetReal_OMC(fmi2me, size(realValuesReferences, 1), realValuesReferences, inFlowStatesInput, realValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_61 = stringEq(i_platform, "win32");
        txt = fun_398(txt, ret_61);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetReal;\n",
                                    "\n",
                                    "    function fmi2SetReal\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real realValuesReferences[:];\n",
                                    "      input Real realValues[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2SetReal_OMC(fmi2me, size(realValuesReferences, 1), realValuesReferences, realValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_62 = stringEq(i_platform, "win32");
        txt = fun_399(txt, ret_62);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetReal;\n",
                                    "\n",
                                    "    function fmi2GetInteger\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real integerValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Integer integerValues[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetInteger_OMC(fmi2me, size(integerValuesReferences, 1), integerValuesReferences, inFlowStatesInput, integerValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_63 = stringEq(i_platform, "win32");
        txt = fun_400(txt, ret_63);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetInteger;\n",
                                    "\n",
                                    "    function fmi2SetInteger\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real integerValuesReferences[:];\n",
                                    "      input Integer integerValues[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2SetInteger_OMC(fmi2me, size(integerValuesReferences, 1), integerValuesReferences, integerValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_64 = stringEq(i_platform, "win32");
        txt = fun_401(txt, ret_64);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetInteger;\n",
                                    "\n",
                                    "    function fmi2GetBoolean\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real booleanValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output Boolean booleanValues[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetBoolean_OMC(fmi2me, size(booleanValuesReferences, 1), booleanValuesReferences, inFlowStatesInput, booleanValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_65 = stringEq(i_platform, "win32");
        txt = fun_402(txt, ret_65);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetBoolean;\n",
                                    "\n",
                                    "    function fmi2SetBoolean\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real booleanValuesReferences[:];\n",
                                    "      input Boolean booleanValues[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2SetBoolean_OMC(fmi2me, size(booleanValuesReferences, 1), booleanValuesReferences, booleanValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_66 = stringEq(i_platform, "win32");
        txt = fun_403(txt, ret_66);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetBoolean;\n",
                                    "\n",
                                    "    function fmi2GetString\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real stringValuesReferences[:];\n",
                                    "      input Real inFlowStatesInput;\n",
                                    "      output String stringValues[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2GetString_OMC(fmi2me, size(stringValuesReferences, 1), stringValuesReferences, inFlowStatesInput, stringValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_67 = stringEq(i_platform, "win32");
        txt = fun_404(txt, ret_67);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2GetString;\n",
                                    "\n",
                                    "    function fmi2SetString\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real stringValuesReferences[:];\n",
                                    "      input String stringValues[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi2SetString_OMC(fmi2me, size(stringValuesReferences, 1), stringValuesReferences, stringValues, 1) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_68 = stringEq(i_platform, "win32");
        txt = fun_405(txt, ret_68);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2SetString;\n",
                                    "\n",
                                    "    function fmi2EventUpdate\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Boolean outNewStatesAvailable;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outNewStatesAvailable = fmi2EventUpdate_OMC(fmi2me, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_69 = stringEq(i_platform, "win32");
        txt = fun_406(txt, ret_69);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2EventUpdate;\n",
                                    "\n",
                                    "    function fmi2nextEventTime\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Real outNewnextTime;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outNewnextTime = fmi2nextEventTime_OMC(fmi2me, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_70 = stringEq(i_platform, "win32");
        txt = fun_407(txt, ret_70);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2nextEventTime;\n",
                                    "\n",
                                    "    function fmi2CompletedIntegratorStep\n",
                                    "      input FMI2ModelExchange fmi2me;\n",
                                    "      input Real inFlowStates;\n",
                                    "      output Boolean outCallEventUpdate;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(6));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outCallEventUpdate = fmi2CompletedIntegratorStep_OMC(fmi2me, inFlowStates) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_71 = stringEq(i_platform, "win32");
        txt = fun_408(txt, ret_71);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "    end fmi2CompletedIntegratorStep;\n",
                                    "  end fmi2Functions;\n",
                                    "\n",
                                    "  package fmiStatus\n",
                                    "    constant Integer fmiOK=0;\n",
                                    "    constant Integer fmiWarning=1;\n",
                                    "    constant Integer fmiDiscard=2;\n",
                                    "    constant Integer fmiError=3;\n",
                                    "    constant Integer fmiFatal=4;\n",
                                    "    constant Integer fmiPending=5;\n",
                                    "  end fmiStatus;\n",
                                    "end "
                                }, false));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_72 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_72);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end importFMU2ModelExchange;

protected function fun_410
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_fmiInfo_fmiDescription;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_fmiInfo_fmiDescription)
    local
      Tpl.Text txt;
      String a_fmiInfo_fmiDescription;

    case ( txt,
           false,
           a_fmiInfo_fmiDescription )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \""));
        txt = Tpl.writeStr(txt, a_fmiInfo_fmiDescription);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_410;

protected function fun_411
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesReturnNames;

    case ( txt,
           false,
           a_realInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_realInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_411;

protected function fun_412
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesReturnNames;

    case ( txt,
           false,
           a_integerInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_integerInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_412;

protected function fun_413
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesReturnNames;

    case ( txt,
           false,
           a_booleanInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_booleanInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_413;

protected function fun_414
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringInputVariablesReturnNames;

    case ( txt,
           false,
           a_stringInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = Tpl.writeText(txt, a_stringInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_414;

protected function fun_415
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realInputVariablesNames;
  input Tpl.Text in_a_realInputVariablesVRs;
  input Tpl.Text in_a_realInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realInputVariablesNames, in_a_realInputVariablesVRs, in_a_realInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realInputVariablesNames;
      Tpl.Text a_realInputVariablesVRs;
      Tpl.Text a_realInputVariablesReturnNames;

    case ( txt,
           false,
           a_realInputVariablesNames,
           a_realInputVariablesVRs,
           a_realInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetReal(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_realInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_415;

protected function fun_416
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerInputVariablesNames;
  input Tpl.Text in_a_integerInputVariablesVRs;
  input Tpl.Text in_a_integerInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerInputVariablesNames, in_a_integerInputVariablesVRs, in_a_integerInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerInputVariablesNames;
      Tpl.Text a_integerInputVariablesVRs;
      Tpl.Text a_integerInputVariablesReturnNames;

    case ( txt,
           false,
           a_integerInputVariablesNames,
           a_integerInputVariablesVRs,
           a_integerInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetInteger(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_integerInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_416;

protected function fun_417
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanInputVariablesNames;
  input Tpl.Text in_a_booleanInputVariablesVRs;
  input Tpl.Text in_a_booleanInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanInputVariablesNames, in_a_booleanInputVariablesVRs, in_a_booleanInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanInputVariablesNames;
      Tpl.Text a_booleanInputVariablesVRs;
      Tpl.Text a_booleanInputVariablesReturnNames;

    case ( txt,
           false,
           a_booleanInputVariablesNames,
           a_booleanInputVariablesVRs,
           a_booleanInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetBoolean(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_booleanInputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_417;

protected function fun_418
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringStartVariablesNames;
  input Tpl.Text in_a_stringInputVariablesVRs;
  input Tpl.Text in_a_stringInputVariablesReturnNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringStartVariablesNames, in_a_stringInputVariablesVRs, in_a_stringInputVariablesReturnNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringStartVariablesNames;
      Tpl.Text a_stringInputVariablesVRs;
      Tpl.Text a_stringInputVariablesReturnNames;

    case ( txt,
           false,
           a_stringStartVariablesNames,
           a_stringInputVariablesVRs,
           a_stringInputVariablesReturnNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringInputVariablesReturnNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1SetString(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_stringInputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, {"));
        txt = Tpl.writeText(txt, a_stringStartVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("});"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_418;

protected function fun_419
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_realOutputVariablesVRs;
  input Tpl.Text in_a_realOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_realOutputVariablesVRs, in_a_realOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_realOutputVariablesVRs;
      Tpl.Text a_realOutputVariablesNames;

    case ( txt,
           false,
           a_realOutputVariablesVRs,
           a_realOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_realOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetReal(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_realOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowControl);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_419;

protected function fun_420
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_integerOutputVariablesVRs;
  input Tpl.Text in_a_integerOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_integerOutputVariablesVRs, in_a_integerOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_integerOutputVariablesVRs;
      Tpl.Text a_integerOutputVariablesNames;

    case ( txt,
           false,
           a_integerOutputVariablesVRs,
           a_integerOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetInteger(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_integerOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowControl);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_420;

protected function fun_421
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_booleanOutputVariablesVRs;
  input Tpl.Text in_a_booleanOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_booleanOutputVariablesVRs, in_a_booleanOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_booleanOutputVariablesVRs;
      Tpl.Text a_booleanOutputVariablesNames;

    case ( txt,
           false,
           a_booleanOutputVariablesVRs,
           a_booleanOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetBoolean(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_booleanOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowControl);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_421;

protected function fun_422
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Tpl.Text in_a_stringOutputVariablesVRs;
  input Tpl.Text in_a_stringOutputVariablesNames;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_stringOutputVariablesVRs, in_a_stringOutputVariablesNames)
    local
      Tpl.Text txt;
      Tpl.Text a_stringOutputVariablesVRs;
      Tpl.Text a_stringOutputVariablesNames;

    case ( txt,
           false,
           a_stringOutputVariablesVRs,
           a_stringOutputVariablesNames )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesNames);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = fmi1Functions.fmi1GetString(fmi1cs, {"));
        txt = Tpl.writeText(txt, a_stringOutputVariablesVRs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowControl);"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_422;

protected function fun_423
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_423;

protected function fun_424
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_424;

protected function fun_425
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_425;

protected function fun_426
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_426;

protected function fun_427
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_427;

protected function fun_428
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_428;

protected function fun_429
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_429;

protected function fun_430
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_430;

protected function fun_431
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_431;

protected function fun_432
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_432;

protected function fun_433
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", \"shlwapi\""));
      then txt;
  end match;
end fun_433;

public function importFMU1CoSimulationStandAlone
  input Tpl.Text in_txt;
  input FMI.FmiImport in_a_fmi;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmi)
    local
      Tpl.Text txt;
      String i_platform;
      Real i_fmiExperimentAnnotation_fmiExperimentTolerance;
      Boolean i_generateOutputConnectors;
      Boolean i_generateInputConnectors;
      Real i_fmiExperimentAnnotation_fmiExperimentStopTime;
      Real i_fmiExperimentAnnotation_fmiExperimentStartTime;
      Boolean i_fmiDebugOutput;
      Integer i_fmiLogLevel;
      String i_fmuWorkingDirectory;
      list<FMI.TypeDefinitions> i_fmiTypeDefinitionsList;
      String i_fmiInfo_fmiDescription;
      FMI.Info i_fmiInfo;
      String i_fmiInfo_fmiModelIdentifier;
      list<FMI.ModelVariables> i_fmiModelVariablesList;
      String ret_53;
      Boolean ret_52;
      Boolean ret_51;
      Boolean ret_50;
      Boolean ret_49;
      Boolean ret_48;
      Boolean ret_47;
      Boolean ret_46;
      Boolean ret_45;
      Boolean ret_44;
      Boolean ret_43;
      Boolean ret_42;
      Boolean ret_41;
      Boolean ret_40;
      Boolean ret_39;
      Boolean ret_38;
      Boolean ret_37;
      Boolean ret_36;
      Boolean ret_35;
      Boolean ret_34;
      Boolean ret_33;
      Boolean ret_32;
      Boolean ret_31;
      Boolean ret_30;
      Boolean ret_29;
      Boolean ret_28;
      Boolean ret_27;
      Boolean ret_26;
      Boolean ret_25;
      Boolean ret_24;
      Boolean ret_23;
      Boolean ret_22;
      Boolean ret_21;
      String ret_20;
      Tpl.Text l_stringOutputVariablesNames;
      Tpl.Text l_stringOutputVariablesVRs;
      Tpl.Text l_booleanOutputVariablesNames;
      Tpl.Text l_booleanOutputVariablesVRs;
      Tpl.Text l_integerOutputVariablesNames;
      Tpl.Text l_integerOutputVariablesVRs;
      Tpl.Text l_realOutputVariablesNames;
      Tpl.Text l_realOutputVariablesVRs;
      Tpl.Text l_stringInputVariablesReturnNames;
      Tpl.Text l_stringStartVariablesNames;
      Tpl.Text l_stringInputVariablesVRs;
      Tpl.Text l_booleanInputVariablesReturnNames;
      Tpl.Text l_booleanInputVariablesNames;
      Tpl.Text l_booleanInputVariablesVRs;
      Tpl.Text l_integerInputVariablesReturnNames;
      Tpl.Text l_integerInputVariablesNames;
      Tpl.Text l_integerInputVariablesVRs;
      Tpl.Text l_realInputVariablesReturnNames;
      Tpl.Text l_realInputVariablesNames;
      Tpl.Text l_realInputVariablesVRs;

    case ( txt,
           FMI.FMIIMPORT(fmiInfo = (i_fmiInfo as FMI.INFO(fmiModelIdentifier = i_fmiInfo_fmiModelIdentifier, fmiDescription = i_fmiInfo_fmiDescription)), fmiExperimentAnnotation = FMI.EXPERIMENTANNOTATION(fmiExperimentStartTime = i_fmiExperimentAnnotation_fmiExperimentStartTime, fmiExperimentStopTime = i_fmiExperimentAnnotation_fmiExperimentStopTime, fmiExperimentTolerance = i_fmiExperimentAnnotation_fmiExperimentTolerance), fmiModelVariablesList = i_fmiModelVariablesList, fmiTypeDefinitionsList = i_fmiTypeDefinitionsList, fmuWorkingDirectory = i_fmuWorkingDirectory, fmiLogLevel = i_fmiLogLevel, fmiDebugOutput = i_fmiDebugOutput, generateInputConnectors = i_generateInputConnectors, generateOutputConnectors = i_generateOutputConnectors, platform = i_platform) )
      equation
        l_realInputVariablesVRs = dumpInputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesNames = dumpInputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realInputVariablesReturnNames = dumpInputRealVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesVRs = dumpInputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesNames = dumpInputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerInputVariablesReturnNames = dumpInputIntegerVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesVRs = dumpInputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesNames = dumpInputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanInputVariablesReturnNames = dumpInputBooleanVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesVRs = dumpInputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringStartVariablesNames = dumpInputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringInputVariablesReturnNames = dumpInputStringVariablesReturnNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesVRs = dumpOutputRealVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_realOutputVariablesNames = dumpOutputRealVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesVRs = dumpOutputIntegerVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_integerOutputVariablesNames = dumpOutputIntegerVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesVRs = dumpOutputBooleanVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_booleanOutputVariablesNames = dumpOutputBooleanVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesVRs = dumpOutputStringVariablesVRs(Tpl.emptyTxt, i_fmiModelVariablesList);
        l_stringOutputVariablesNames = dumpOutputStringVariablesNames(Tpl.emptyTxt, i_fmiModelVariablesList);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model "));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_20 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_20);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU"));
        ret_21 = stringEq(i_fmiInfo_fmiDescription, "");
        txt = fun_410(txt, ret_21, i_fmiInfo_fmiDescription);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpFMITypeDefinitions(txt, i_fmiTypeDefinitionsList);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant String fmuLocation = \"file://"));
        txt = Tpl.writeStr(txt, i_fmuWorkingDirectory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "/resources\";\n",
                                    "constant String fmuWorkingDir = \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmuWorkingDirectory);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "parameter Integer logLevel = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_fmiLogLevel));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"log level used during the loading of FMU\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "parameter Boolean debugLogging = "
                                }, false));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_fmiDebugOutput));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"enables the FMU simulation logging\" annotation (Dialog(tab=\"FMI\", group=\"Enable logging\"));\n",
                                    "constant String mimeType = \"\";\n",
                                    "constant Real timeout = 0.0;\n",
                                    "constant Boolean visible = false;\n",
                                    "constant Boolean interactive = false;\n",
                                    "parameter Real StartTime = "
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStartTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"start time used to initialize the slave\" annotation (Dialog(tab=\"FMI\", group=\"Step time\"));\n",
                                    "parameter Real StopTime = "
                                }, false));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " \"stop time used to initialize the slave\" annotation (Dialog(tab=\"FMI\", group=\"Step time\"));\n",
                                    "parameter Real communicationStepSize = (StopTime-StartTime)/500 \"step size used by fmiDoStep\" annotation (Dialog(tab=\"FMI\", group=\"Step time\"));\n",
                                    "constant Boolean stopTimeDefined = false;\n",
                                    "FMI1CoSimulation fmi1cs = FMI1CoSimulation(logLevel, fmuWorkingDir, \""
                                }, false));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\", debugLogging, fmuLocation, mimeType, timeout, visible, interactive, StartTime, stopTimeDefined, StopTime);\n"));
        txt = dumpFMIModelVariablesList(txt, i_fmiModelVariablesList, i_fmiTypeDefinitionsList, i_generateInputConnectors, i_generateOutputConnectors);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("Real flowControl;\n"));
        ret_22 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_411(txt, ret_22, l_realInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_23 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_412(txt, ret_23, l_integerInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_24 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_413(txt, ret_24, l_booleanInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_25 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_414(txt, ret_25, l_stringInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("equation\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_26 = stringEq(Tpl.textString(l_realInputVariablesVRs), "");
        txt = fun_415(txt, ret_26, l_realInputVariablesNames, l_realInputVariablesVRs, l_realInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_27 = stringEq(Tpl.textString(l_integerInputVariablesVRs), "");
        txt = fun_416(txt, ret_27, l_integerInputVariablesNames, l_integerInputVariablesVRs, l_integerInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_28 = stringEq(Tpl.textString(l_booleanInputVariablesVRs), "");
        txt = fun_417(txt, ret_28, l_booleanInputVariablesNames, l_booleanInputVariablesVRs, l_booleanInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        ret_29 = stringEq(Tpl.textString(l_stringInputVariablesVRs), "");
        txt = fun_418(txt, ret_29, l_stringStartVariablesNames, l_stringInputVariablesVRs, l_stringInputVariablesReturnNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("flowControl = fmi1Functions.fmi1DoStep(fmi1cs, time, communicationStepSize, true);\n"));
        ret_30 = stringEq(Tpl.textString(l_realOutputVariablesNames), "");
        ret_31 = stringEq(Tpl.textString(l_realOutputVariablesVRs), "");
        ret_32 = boolAnd(ret_30, ret_31);
        txt = fun_419(txt, ret_32, l_realOutputVariablesVRs, l_realOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_33 = stringEq(Tpl.textString(l_integerOutputVariablesNames), "");
        ret_34 = stringEq(Tpl.textString(l_integerOutputVariablesVRs), "");
        ret_35 = boolAnd(ret_33, ret_34);
        txt = fun_420(txt, ret_35, l_integerOutputVariablesVRs, l_integerOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_36 = stringEq(Tpl.textString(l_booleanOutputVariablesNames), "");
        ret_37 = stringEq(Tpl.textString(l_booleanOutputVariablesVRs), "");
        ret_38 = boolAnd(ret_36, ret_37);
        txt = fun_421(txt, ret_38, l_booleanOutputVariablesVRs, l_booleanOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        ret_39 = stringEq(Tpl.textString(l_stringOutputVariablesNames), "");
        ret_40 = stringEq(Tpl.textString(l_stringOutputVariablesVRs), "");
        ret_41 = boolAnd(ret_39, ret_40);
        txt = fun_422(txt, ret_41, l_stringOutputVariablesVRs, l_stringOutputVariablesNames);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation(experiment(StartTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStartTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", StopTime="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentStopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", Tolerance="));
        txt = Tpl.writeStr(txt, realString(i_fmiExperimentAnnotation_fmiExperimentTolerance));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "));\n",
                                    "annotation (Icon(graphics={\n",
                                    "    Rectangle(\n",
                                    "      extent={{-100,100},{100,-100}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      fillColor={240,240,240},\n",
                                    "      fillPattern=FillPattern.Solid,\n",
                                    "      lineThickness=0.5),\n",
                                    "    Text(\n",
                                    "      extent={{-100,40},{100,0}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"%name\"),\n",
                                    "    Text(\n",
                                    "      extent={{-100,-50},{100,-90}},\n",
                                    "      lineColor={0,0,0},\n",
                                    "      textString=\"V1.0\")}));\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected\n",
                                    "  class FMI1CoSimulation\n",
                                    "    extends ExternalObject;\n",
                                    "      function constructor\n",
                                    "        input Integer fmiLogLevel;\n",
                                    "        input String workingDirectory;\n",
                                    "        input String instanceName;\n",
                                    "        input Boolean debugLogging;\n",
                                    "        input String fmuLocation;\n",
                                    "        input String mimeType;\n",
                                    "        input Real timeOut;\n",
                                    "        input Boolean visible;\n",
                                    "        input Boolean interactive;\n",
                                    "        input Real tStart;\n",
                                    "        input Boolean stopTimeDefined;\n",
                                    "        input Real tStop;\n",
                                    "        output FMI1CoSimulation fmi1cs;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1cs = FMI1CoSimulationConstructor_OMC(fmiLogLevel, workingDirectory, instanceName, debugLogging, fmuLocation, mimeType, timeOut, visible, interactive, tStart, stopTimeDefined, tStop) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_42 = stringEq(i_platform, "win32");
        txt = fun_423(txt, ret_42);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end constructor;\n",
                                    "\n",
                                    "      function destructor\n",
                                    "        input FMI1CoSimulation fmi1cs;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(8));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" FMI1CoSimulationDestructor_OMC(fmi1cs) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_43 = stringEq(i_platform, "win32");
        txt = fun_424(txt, ret_43);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "      end destructor;\n",
                                    "  end FMI1CoSimulation;\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpFMITypeDefinitionsMappingFunctions(txt, i_fmiTypeDefinitionsList);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = dumpFMITypeDefinitionsArrayMappingFunctions(txt, i_fmiTypeDefinitionsList);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "package fmi1Functions\n",
                                    "  function fmi1DoStep\n",
                                    "    input FMI1CoSimulation fmi1cs;\n",
                                    "    input Real currentCommunicationPoint;\n",
                                    "    input Real communicationStepSize;\n",
                                    "    input Boolean newStep;\n",
                                    "    output Real outFlowControl;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" outFlowControl = fmi1DoStep_OMC(fmi1cs, currentCommunicationPoint, communicationStepSize, newStep) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_44 = stringEq(i_platform, "win32");
        txt = fun_425(txt, ret_44);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1DoStep;\n",
                                    "\n",
                                    "  function fmi1GetReal\n",
                                    "    input FMI1CoSimulation fmi1cs;\n",
                                    "    input Real realValuesReferences[:];\n",
                                    "    input Real inFlowStatesInput;\n",
                                    "    output Real realValues[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetReal_OMC(fmi1cs, size(realValuesReferences, 1), realValuesReferences, inFlowStatesInput, realValues, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_45 = stringEq(i_platform, "win32");
        txt = fun_426(txt, ret_45);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetReal;\n",
                                    "\n",
                                    "  function fmi1SetReal\n",
                                    "    input FMI1CoSimulation fmi1cs;\n",
                                    "    input Real realValuesReferences[:];\n",
                                    "    input Real realValues[size(realValuesReferences, 1)];\n",
                                    "    output Real out_Values[size(realValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetReal_OMC(fmi1cs, size(realValuesReferences, 1), realValuesReferences, realValues, out_Values, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_46 = stringEq(i_platform, "win32");
        txt = fun_427(txt, ret_46);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetReal;\n",
                                    "\n",
                                    "  function fmi1GetInteger\n",
                                    "    input FMI1CoSimulation fmi1cs;\n",
                                    "    input Real integerValuesReferences[:];\n",
                                    "    input Real inFlowStatesInput;\n",
                                    "    output Integer integerValues[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetInteger_OMC(fmi1cs, size(integerValuesReferences, 1), integerValuesReferences, inFlowStatesInput, integerValues, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_47 = stringEq(i_platform, "win32");
        txt = fun_428(txt, ret_47);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetInteger;\n",
                                    "\n",
                                    "  function fmi1SetInteger\n",
                                    "    input FMI1CoSimulation fmi1cs;\n",
                                    "    input Real integerValuesReferences[:];\n",
                                    "    input Integer integerValues[size(integerValuesReferences, 1)];\n",
                                    "    output Real out_Values[size(integerValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetInteger_OMC(fmi1cs, size(integerValuesReferences, 1), integerValuesReferences, integerValues, out_Values, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_48 = stringEq(i_platform, "win32");
        txt = fun_429(txt, ret_48);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetInteger;\n",
                                    "\n",
                                    "  function fmi1GetBoolean\n",
                                    "    input FMI1CoSimulation fmi1cs;\n",
                                    "    input Real booleanValuesReferences[:];\n",
                                    "    input Real inFlowStatesInput;\n",
                                    "    output Boolean booleanValues[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetBoolean_OMC(fmi1cs, size(booleanValuesReferences, 1), booleanValuesReferences, inFlowStatesInput, booleanValues, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_49 = stringEq(i_platform, "win32");
        txt = fun_430(txt, ret_49);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetBoolean;\n",
                                    "\n",
                                    "  function fmi1SetBoolean\n",
                                    "    input FMI1CoSimulation fmi1cs;\n",
                                    "    input Real booleanValuesReferences[:];\n",
                                    "    input Boolean booleanValues[size(booleanValuesReferences, 1)];\n",
                                    "    output Real out_Values[size(booleanValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetBoolean_OMC(fmi1cs, size(booleanValuesReferences, 1), booleanValuesReferences, booleanValues, out_Values, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_50 = stringEq(i_platform, "win32");
        txt = fun_431(txt, ret_50);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetBoolean;\n",
                                    "\n",
                                    "  function fmi1GetString\n",
                                    "    input FMI1CoSimulation fmi1cs;\n",
                                    "    input Real stringValuesReferences[:];\n",
                                    "    input Real inFlowStatesInput;\n",
                                    "    output String stringValues[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1GetString_OMC(fmi1cs, size(stringValuesReferences, 1), stringValuesReferences, inFlowStatesInput, stringValues, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_51 = stringEq(i_platform, "win32");
        txt = fun_432(txt, ret_51);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1GetString;\n",
                                    "\n",
                                    "  function fmi1SetString\n",
                                    "    input FMI1CoSimulation fmi1cs;\n",
                                    "    input Real stringValuesReferences[:];\n",
                                    "    input String stringValues[size(stringValuesReferences, 1)];\n",
                                    "    output Real out_Values[size(stringValuesReferences, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("external \"C\" fmi1SetString_OMC(fmi1cs, size(stringValuesReferences, 1), stringValuesReferences, stringValues, out_Values, 2) annotation(Library = {\"OpenModelicaFMIRuntimeC\", \"fmilib\""));
        ret_52 = stringEq(i_platform, "win32");
        txt = fun_433(txt, ret_52);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("});\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end fmi1SetString;\n",
                                    "end fmi1Functions;\n",
                                    "\n",
                                    "package fmiStatus\n",
                                    "  constant Integer fmiOK=0;\n",
                                    "  constant Integer fmiWarning=1;\n",
                                    "  constant Integer fmiDiscard=2;\n",
                                    "  constant Integer fmiError=3;\n",
                                    "  constant Integer fmiFatal=4;\n",
                                    "  constant Integer fmiPending=5;\n",
                                    "end fmiStatus;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = Tpl.writeStr(txt, i_fmiInfo_fmiModelIdentifier);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        ret_53 = FMI.getFMIType(i_fmiInfo);
        txt = Tpl.writeStr(txt, ret_53);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_FMU;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end importFMU1CoSimulationStandAlone;

protected function lm_435
  input Tpl.Text in_txt;
  input list<FMI.TypeDefinitions> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.TypeDefinitions> rest;
      FMI.TypeDefinitions i_fmiTypeDefinition;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiTypeDefinition :: rest )
      equation
        txt = dumpFMITypeDefinition(txt, i_fmiTypeDefinition);
        txt = Tpl.nextIter(txt);
        txt = lm_435(txt, rest);
      then txt;
  end match;
end lm_435;

public function dumpFMITypeDefinitions
  input Tpl.Text txt;
  input list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_435(out_txt, a_fmiTypeDefinitionsList);
  out_txt := Tpl.popIter(out_txt);
end dumpFMITypeDefinitions;

public function dumpFMITypeDefinition
  input Tpl.Text in_txt;
  input FMI.TypeDefinitions in_a_fmiTypeDefinition;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiTypeDefinition)
    local
      Tpl.Text txt;
      list<FMI.EnumerationItem> i_items;
      String i_name;

    case ( txt,
           FMI.ENUMERATIONTYPE(name = i_name, items = i_items) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("type "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" = enumeration(\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpFMITypeDefinitionsItems(txt, i_items);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFMITypeDefinition;

protected function lm_438
  input Tpl.Text in_txt;
  input list<FMI.EnumerationItem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.EnumerationItem> rest;
      FMI.EnumerationItem i_item;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_item :: rest )
      equation
        txt = dumpFMITypeDefinitionsItem(txt, i_item);
        txt = Tpl.nextIter(txt);
        txt = lm_438(txt, rest);
      then txt;
  end match;
end lm_438;

public function dumpFMITypeDefinitionsItems
  input Tpl.Text txt;
  input list<FMI.EnumerationItem> a_items;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_438(out_txt, a_items);
  out_txt := Tpl.popIter(out_txt);
end dumpFMITypeDefinitionsItems;

public function dumpFMITypeDefinitionsItem
  input Tpl.Text in_txt;
  input FMI.EnumerationItem in_a_item;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_item)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.ENUMERATIONITEM(name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFMITypeDefinitionsItem;

protected function lm_441
  input Tpl.Text in_txt;
  input list<FMI.TypeDefinitions> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.TypeDefinitions> rest;
      FMI.TypeDefinitions i_fmiTypeDefinition;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiTypeDefinition :: rest )
      equation
        txt = dumpFMITypeDefinitionMappingFunction(txt, i_fmiTypeDefinition);
        txt = Tpl.nextIter(txt);
        txt = lm_441(txt, rest);
      then txt;
  end match;
end lm_441;

public function dumpFMITypeDefinitionsMappingFunctions
  input Tpl.Text txt;
  input list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_441(out_txt, a_fmiTypeDefinitionsList);
  out_txt := Tpl.popIter(out_txt);
end dumpFMITypeDefinitionsMappingFunctions;

protected function lm_443
  input Tpl.Text in_txt;
  input list<FMI.EnumerationItem> in_items;
  input String in_a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_name)
    local
      Tpl.Text txt;
      list<FMI.EnumerationItem> rest;
      String a_name;
      Integer x_i0;
      FMI.EnumerationItem i_item;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_item :: rest,
           a_name )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = dumpFMITypeDefinitionMappingFunctionItems(txt, i_item, a_name, x_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_443(txt, rest, a_name);
      then txt;
  end match;
end lm_443;

protected function fun_444
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end if;"));
      then txt;
  end match;
end fun_444;

public function dumpFMITypeDefinitionMappingFunction
  input Tpl.Text in_txt;
  input FMI.TypeDefinitions in_a_fmiTypeDefinition;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiTypeDefinition)
    local
      Tpl.Text txt;
      list<FMI.EnumerationItem> i_items;
      String i_name;
      Boolean ret_1;
      Integer ret_0;

    case ( txt,
           FMI.ENUMERATIONTYPE(name = i_name, items = i_items) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function map_"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_from_integer\n",
                                    "  input Integer i;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" outType;\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("algorithm\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_443(txt, i_items, i_name);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        ret_0 = listLength(i_items);
        ret_1 = intGt(ret_0, 1);
        txt = fun_444(txt, ret_1);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end map_"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_from_integer;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFMITypeDefinitionMappingFunction;

protected function fun_446
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_name;
  input String in_a_typeName;
  input Integer in_a_i;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_name, in_a_typeName, in_a_i)
    local
      Tpl.Text txt;
      String a_name;
      String a_typeName;
      Integer a_i;

    case ( txt,
           false,
           a_name,
           a_typeName,
           a_i )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elseif i == "));
        txt = Tpl.writeStr(txt, intString(a_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then outType := "));
        txt = Tpl.writeStr(txt, a_typeName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           a_name,
           a_typeName,
           a_i )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if i == "));
        txt = Tpl.writeStr(txt, intString(a_i));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" then outType := "));
        txt = Tpl.writeStr(txt, a_typeName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = Tpl.writeStr(txt, a_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end match;
end fun_446;

public function dumpFMITypeDefinitionMappingFunctionItems
  input Tpl.Text in_txt;
  input FMI.EnumerationItem in_a_item;
  input String in_a_typeName;
  input Integer in_a_i;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_item, in_a_typeName, in_a_i)
    local
      Tpl.Text txt;
      String a_typeName;
      Integer a_i;
      String i_name;
      Boolean ret_0;

    case ( txt,
           FMI.ENUMERATIONITEM(name = i_name),
           a_typeName,
           a_i )
      equation
        ret_0 = intEq(a_i, 1);
        txt = fun_446(txt, ret_0, i_name, a_typeName, a_i);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpFMITypeDefinitionMappingFunctionItems;

protected function lm_448
  input Tpl.Text in_txt;
  input list<FMI.TypeDefinitions> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.TypeDefinitions> rest;
      FMI.TypeDefinitions i_fmiTypeDefinition;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiTypeDefinition :: rest )
      equation
        txt = dumpFMITypeDefinitionsArrayMappingFunction(txt, i_fmiTypeDefinition);
        txt = Tpl.nextIter(txt);
        txt = lm_448(txt, rest);
      then txt;
  end match;
end lm_448;

public function dumpFMITypeDefinitionsArrayMappingFunctions
  input Tpl.Text txt;
  input list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_448(out_txt, a_fmiTypeDefinitionsList);
  out_txt := Tpl.popIter(out_txt);
end dumpFMITypeDefinitionsArrayMappingFunctions;

public function dumpFMITypeDefinitionsArrayMappingFunction
  input Tpl.Text in_txt;
  input FMI.TypeDefinitions in_a_fmiTypeDefinition;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiTypeDefinition)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.ENUMERATIONTYPE(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("function map_"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "_from_integers\n",
                                    "  input Integer fromInt[size(fromInt, 1)];\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output "));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" toEnum[size(fromInt, 1)];\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "protected\n",
                                    "  Integer n = size(fromInt, 1);\n",
                                    "algorithm\n",
                                    "  for i in 1:n loop\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("toEnum[i] := map_"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("_from_integer(fromInt[i]);\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  end for;\n",
                                    "end map_"
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_from_integers;"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpFMITypeDefinitionsArrayMappingFunction;

protected function lm_451
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;
  input Boolean in_a_generateOutputConnectors;
  input Boolean in_a_generateInputConnectors;
  input list<FMI.TypeDefinitions> in_a_fmiTypeDefinitionsList;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_generateOutputConnectors, in_a_generateInputConnectors, in_a_fmiTypeDefinitionsList)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      Boolean a_generateOutputConnectors;
      Boolean a_generateInputConnectors;
      list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest,
           a_generateOutputConnectors,
           a_generateInputConnectors,
           a_fmiTypeDefinitionsList )
      equation
        txt = dumpFMIModelVariable(txt, i_fmiModelVariable, a_fmiTypeDefinitionsList, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.nextIter(txt);
        txt = lm_451(txt, rest, a_generateOutputConnectors, a_generateInputConnectors, a_fmiTypeDefinitionsList);
      then txt;
  end match;
end lm_451;

public function dumpFMIModelVariablesList
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;
  input list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;
  input Boolean a_generateInputConnectors;
  input Boolean a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_451(out_txt, a_fmiModelVariablesList, a_generateOutputConnectors, a_generateInputConnectors, a_fmiTypeDefinitionsList);
  out_txt := Tpl.popIter(out_txt);
end dumpFMIModelVariablesList;

public function dumpFMIModelVariable
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;
  input list<FMI.TypeDefinitions> in_a_fmiTypeDefinitionsList;
  input Boolean in_a_generateInputConnectors;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable, in_a_fmiTypeDefinitionsList, in_a_generateInputConnectors, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;
      Boolean a_generateInputConnectors;
      Boolean a_generateOutputConnectors;
      String i_startValue_3;
      Boolean i_startValue_2;
      Integer i_startValue_1;
      Integer i_y2Placement;
      Integer i_y1Placement;
      Integer i_x2Placement;
      Integer i_x1Placement;
      String i_description;
      Boolean i_isFixed;
      Real i_startValue;
      Boolean i_hasStartValue;
      String i_name;
      String i_baseType;
      String i_causality;
      String i_variability;

    case ( txt,
           FMI.REALVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           _,
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIRealModelVariableStartValue(txt, i_hasStartValue, i_startValue, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue_1, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           _,
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIIntegerModelVariableStartValue(txt, i_hasStartValue, i_startValue_1, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue_2, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           _,
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIBooleanModelVariableStartValue(txt, i_hasStartValue, i_startValue_2, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           FMI.STRINGVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue_3, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           _,
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIStringModelVariableStartValue(txt, i_hasStartValue, i_startValue_3, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           FMI.ENUMERATIONVARIABLE(variability = i_variability, causality = i_causality, baseType = i_baseType, name = i_name, hasStartValue = i_hasStartValue, startValue = i_startValue_1, isFixed = i_isFixed, description = i_description, x1Placement = i_x1Placement, x2Placement = i_x2Placement, y1Placement = i_y1Placement, y2Placement = i_y2Placement),
           a_fmiTypeDefinitionsList,
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        txt = dumpFMIModelVariableVariability(txt, i_variability);
        txt = dumpFMIModelVariableCausalityAndBaseType(txt, i_causality, i_baseType, a_generateInputConnectors, a_generateOutputConnectors);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, i_name);
        txt = dumpFMIEnumerationModelVariableStartValue(txt, a_fmiTypeDefinitionsList, i_baseType, i_hasStartValue, i_startValue_1, i_isFixed);
        txt = dumpFMIModelVariableDescription(txt, i_description);
        txt = dumpFMIModelVariablePlacementAnnotation(txt, i_x1Placement, i_x2Placement, i_y1Placement, i_y2Placement, a_generateInputConnectors, a_generateOutputConnectors, i_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpFMIModelVariable;

protected function fun_454
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_variability;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_variability)
    local
      Tpl.Text txt;
      String a_variability;

    case ( txt,
           false,
           a_variability )
      equation
        txt = Tpl.writeStr(txt, a_variability);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_454;

public function dumpFMIModelVariableVariability
  input Tpl.Text txt;
  input String a_variability;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_variability, "");
  out_txt := fun_454(txt, ret_0, a_variability);
end dumpFMIModelVariableVariability;

protected function fun_456
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;

    case ( txt,
           false,
           a_baseType,
           a_causality )
      equation
        txt = Tpl.writeStr(txt, a_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
        txt = Tpl.writeStr(txt, a_baseType);
      then txt;

    case ( txt,
           _,
           a_baseType,
           _ )
      equation
        txt = Tpl.writeStr(txt, a_baseType);
      then txt;
  end match;
end fun_456;

protected function fun_457
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;
      Boolean ret_0;

    case ( txt,
           false,
           a_baseType,
           a_causality )
      equation
        ret_0 = stringEq(a_causality, "");
        txt = fun_456(txt, ret_0, a_baseType, a_causality);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.BooleanOutput"));
      then txt;
  end match;
end fun_457;

protected function fun_458
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;
      Boolean a_generateOutputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_baseType,
           a_causality,
           a_generateOutputConnectors )
      equation
        ret_0 = stringEq(a_causality, "output");
        ret_1 = stringEq(a_baseType, "Boolean");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateOutputConnectors, ret_2);
        txt = fun_457(txt, ret_3, a_baseType, a_causality);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.IntegerOutput"));
      then txt;
  end match;
end fun_458;

protected function fun_459
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;
      Boolean a_generateOutputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_baseType,
           a_causality,
           a_generateOutputConnectors )
      equation
        ret_0 = stringEq(a_causality, "output");
        ret_1 = stringEq(a_baseType, "Integer");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateOutputConnectors, ret_2);
        txt = fun_458(txt, ret_3, a_baseType, a_causality, a_generateOutputConnectors);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.RealOutput"));
      then txt;
  end match;
end fun_459;

protected function fun_460
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_baseType;
  input String in_a_causality;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_baseType, in_a_causality, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      String a_baseType;
      String a_causality;
      Boolean a_generateOutputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_baseType,
           a_causality,
           a_generateOutputConnectors )
      equation
        ret_0 = stringEq(a_causality, "output");
        ret_1 = stringEq(a_baseType, "Real");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateOutputConnectors, ret_2);
        txt = fun_459(txt, ret_3, a_baseType, a_causality, a_generateOutputConnectors);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.BooleanInput"));
      then txt;
  end match;
end fun_460;

protected function fun_461
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Boolean in_a_generateOutputConnectors;
  input String in_a_baseType;
  input String in_a_causality;
  input Boolean in_a_generateInputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_generateOutputConnectors, in_a_baseType, in_a_causality, in_a_generateInputConnectors)
    local
      Tpl.Text txt;
      Boolean a_generateOutputConnectors;
      String a_baseType;
      String a_causality;
      Boolean a_generateInputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_generateOutputConnectors,
           a_baseType,
           a_causality,
           a_generateInputConnectors )
      equation
        ret_0 = stringEq(a_causality, "input");
        ret_1 = stringEq(a_baseType, "Boolean");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateInputConnectors, ret_2);
        txt = fun_460(txt, ret_3, a_baseType, a_causality, a_generateOutputConnectors);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.IntegerInput"));
      then txt;
  end match;
end fun_461;

protected function fun_462
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_causality;
  input String in_a_baseType;
  input Boolean in_a_generateInputConnectors;
  input Boolean in_a_generateOutputConnectors;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_causality, in_a_baseType, in_a_generateInputConnectors, in_a_generateOutputConnectors)
    local
      Tpl.Text txt;
      String a_causality;
      String a_baseType;
      Boolean a_generateInputConnectors;
      Boolean a_generateOutputConnectors;
      Boolean ret_3;
      Boolean ret_2;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_causality,
           a_baseType,
           a_generateInputConnectors,
           a_generateOutputConnectors )
      equation
        ret_0 = stringEq(a_causality, "input");
        ret_1 = stringEq(a_baseType, "Integer");
        ret_2 = boolAnd(ret_0, ret_1);
        ret_3 = boolAnd(a_generateInputConnectors, ret_2);
        txt = fun_461(txt, ret_3, a_generateOutputConnectors, a_baseType, a_causality, a_generateInputConnectors);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Modelica.Blocks.Interfaces.RealInput"));
      then txt;
  end match;
end fun_462;

public function dumpFMIModelVariableCausalityAndBaseType
  input Tpl.Text txt;
  input String a_causality;
  input String a_baseType;
  input Boolean a_generateInputConnectors;
  input Boolean a_generateOutputConnectors;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_causality, "input");
  ret_1 := stringEq(a_baseType, "Real");
  ret_2 := boolAnd(ret_0, ret_1);
  ret_3 := boolAnd(a_generateInputConnectors, ret_2);
  out_txt := fun_462(txt, ret_3, a_causality, a_baseType, a_generateInputConnectors, a_generateOutputConnectors);
end dumpFMIModelVariableCausalityAndBaseType;

protected function fun_464
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_causality;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_causality)
    local
      Tpl.Text txt;
      String a_causality;

    case ( txt,
           false,
           a_causality )
      equation
        txt = Tpl.writeStr(txt, a_causality);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" "));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_464;

public function dumpFMIModelVariableCausality
  input Tpl.Text txt;
  input String a_causality;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_causality, "");
  out_txt := fun_464(txt, ret_0, a_causality);
end dumpFMIModelVariableCausality;

protected function fun_466
  input Tpl.Text in_txt;
  input Boolean in_a_hasStartValue;
  input Real in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hasStartValue, in_a_startValue)
    local
      Tpl.Text txt;
      Real a_startValue;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_startValue )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(start="));
        txt = Tpl.writeStr(txt, realString(a_startValue));
      then txt;
  end match;
end fun_466;

protected function fun_467
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",fixed=true"));
      then txt;
  end match;
end fun_467;

protected function fun_468
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(fixed=true"));
      then txt;
  end match;
end fun_468;

protected function fun_469
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_469;

public function dumpFMIRealModelVariableStartValue
  input Tpl.Text txt;
  input Boolean a_hasStartValue;
  input Real a_startValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  out_txt := fun_466(txt, a_hasStartValue, a_startValue);
  ret_0 := boolAnd(a_hasStartValue, a_isFixed);
  out_txt := fun_467(out_txt, ret_0);
  ret_1 := boolNot(a_hasStartValue);
  ret_2 := boolAnd(ret_1, a_isFixed);
  out_txt := fun_468(out_txt, ret_2);
  ret_3 := boolOr(a_hasStartValue, a_isFixed);
  out_txt := fun_469(out_txt, ret_3);
end dumpFMIRealModelVariableStartValue;

protected function fun_471
  input Tpl.Text in_txt;
  input Boolean in_a_hasStartValue;
  input Integer in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hasStartValue, in_a_startValue)
    local
      Tpl.Text txt;
      Integer a_startValue;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_startValue )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(start="));
        txt = Tpl.writeStr(txt, intString(a_startValue));
      then txt;
  end match;
end fun_471;

protected function fun_472
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",fixed=true"));
      then txt;
  end match;
end fun_472;

protected function fun_473
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(fixed=true"));
      then txt;
  end match;
end fun_473;

protected function fun_474
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_474;

public function dumpFMIIntegerModelVariableStartValue
  input Tpl.Text txt;
  input Boolean a_hasStartValue;
  input Integer a_startValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  out_txt := fun_471(txt, a_hasStartValue, a_startValue);
  ret_0 := boolAnd(a_hasStartValue, a_isFixed);
  out_txt := fun_472(out_txt, ret_0);
  ret_1 := boolNot(a_hasStartValue);
  ret_2 := boolAnd(ret_1, a_isFixed);
  out_txt := fun_473(out_txt, ret_2);
  ret_3 := boolOr(a_hasStartValue, a_isFixed);
  out_txt := fun_474(out_txt, ret_3);
end dumpFMIIntegerModelVariableStartValue;

protected function fun_476
  input Tpl.Text in_txt;
  input Boolean in_a_hasStartValue;
  input Boolean in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hasStartValue, in_a_startValue)
    local
      Tpl.Text txt;
      Boolean a_startValue;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_startValue )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(start="));
        txt = Tpl.writeStr(txt, Tpl.booleanString(a_startValue));
      then txt;
  end match;
end fun_476;

protected function fun_477
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",fixed=true"));
      then txt;
  end match;
end fun_477;

protected function fun_478
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(fixed=true"));
      then txt;
  end match;
end fun_478;

protected function fun_479
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_479;

public function dumpFMIBooleanModelVariableStartValue
  input Tpl.Text txt;
  input Boolean a_hasStartValue;
  input Boolean a_startValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  out_txt := fun_476(txt, a_hasStartValue, a_startValue);
  ret_0 := boolAnd(a_hasStartValue, a_isFixed);
  out_txt := fun_477(out_txt, ret_0);
  ret_1 := boolNot(a_hasStartValue);
  ret_2 := boolAnd(ret_1, a_isFixed);
  out_txt := fun_478(out_txt, ret_2);
  ret_3 := boolOr(a_hasStartValue, a_isFixed);
  out_txt := fun_479(out_txt, ret_3);
end dumpFMIBooleanModelVariableStartValue;

protected function fun_481
  input Tpl.Text in_txt;
  input Boolean in_a_hasStartValue;
  input String in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hasStartValue, in_a_startValue)
    local
      Tpl.Text txt;
      String a_startValue;

    case ( txt,
           false,
           _ )
      then txt;

    case ( txt,
           _,
           a_startValue )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(start=\""));
        txt = Tpl.writeStr(txt, a_startValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;
  end match;
end fun_481;

protected function fun_482
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",fixed=true"));
      then txt;
  end match;
end fun_482;

protected function fun_483
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(fixed=true"));
      then txt;
  end match;
end fun_483;

protected function fun_484
  input Tpl.Text in_txt;
  input Boolean in_mArg;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_484;

public function dumpFMIStringModelVariableStartValue
  input Tpl.Text txt;
  input Boolean a_hasStartValue;
  input String a_startValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
protected
  Boolean ret_3;
  Boolean ret_2;
  Boolean ret_1;
  Boolean ret_0;
algorithm
  out_txt := fun_481(txt, a_hasStartValue, a_startValue);
  ret_0 := boolAnd(a_hasStartValue, a_isFixed);
  out_txt := fun_482(out_txt, ret_0);
  ret_1 := boolNot(a_hasStartValue);
  ret_2 := boolAnd(ret_1, a_isFixed);
  out_txt := fun_483(out_txt, ret_2);
  ret_3 := boolOr(a_hasStartValue, a_isFixed);
  out_txt := fun_484(out_txt, ret_3);
end dumpFMIStringModelVariableStartValue;

protected function fun_486
  input Tpl.Text in_txt;
  input Boolean in_a_hasStartValue;
  input list<FMI.TypeDefinitions> in_a_fmiTypeDefinitionsList;
  input String in_a_baseType;
  input Integer in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_hasStartValue, in_a_fmiTypeDefinitionsList, in_a_baseType, in_a_startValue)
    local
      Tpl.Text txt;
      list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;
      String a_baseType;
      Integer a_startValue;
      String ret_0;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_fmiTypeDefinitionsList,
           a_baseType,
           a_startValue )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = map_"));
        ret_0 = FMI.getEnumerationTypeFromTypes(a_fmiTypeDefinitionsList, a_baseType);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_from_integer("));
        txt = Tpl.writeStr(txt, intString(a_startValue));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;
  end match;
end fun_486;

public function dumpFMIEnumerationModelVariableStartValue
  input Tpl.Text txt;
  input list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;
  input String a_baseType;
  input Boolean a_hasStartValue;
  input Integer a_startValue;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_486(txt, a_hasStartValue, a_fmiTypeDefinitionsList, a_baseType, a_startValue);
end dumpFMIEnumerationModelVariableStartValue;

protected function fun_488
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input String in_a_description;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_description)
    local
      Tpl.Text txt;
      String a_description;

    case ( txt,
           false,
           a_description )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" \""));
        txt = Tpl.writeStr(txt, a_description);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_488;

public function dumpFMIModelVariableDescription
  input Tpl.Text txt;
  input String a_description;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_description, "");
  out_txt := fun_488(txt, ret_0, a_description);
end dumpFMIModelVariableDescription;

protected function fun_490
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_y2Placement;
  input Integer in_a_x2Placement;
  input Integer in_a_y1Placement;
  input Integer in_a_x1Placement;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_y2Placement, in_a_x2Placement, in_a_y1Placement, in_a_x1Placement)
    local
      Tpl.Text txt;
      Integer a_y2Placement;
      Integer a_x2Placement;
      Integer a_y1Placement;
      Integer a_x1Placement;

    case ( txt,
           false,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_y2Placement,
           a_x2Placement,
           a_y1Placement,
           a_x1Placement )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" annotation(Placement(transformation(extent={{"));
        txt = Tpl.writeStr(txt, intString(a_x1Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_y1Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("},{"));
        txt = Tpl.writeStr(txt, intString(a_x2Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_y2Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}})))"));
      then txt;
  end match;
end fun_490;

protected function fun_491
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_x1Placement;
  input Integer in_a_x2Placement;
  input Integer in_a_y1Placement;
  input Integer in_a_y2Placement;
  input Boolean in_a_generateOutputConnectors;
  input String in_a_causality;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_x1Placement, in_a_x2Placement, in_a_y1Placement, in_a_y2Placement, in_a_generateOutputConnectors, in_a_causality)
    local
      Tpl.Text txt;
      Integer a_x1Placement;
      Integer a_x2Placement;
      Integer a_y1Placement;
      Integer a_y2Placement;
      Boolean a_generateOutputConnectors;
      String a_causality;
      Boolean ret_1;
      Boolean ret_0;

    case ( txt,
           false,
           a_x1Placement,
           a_x2Placement,
           a_y1Placement,
           a_y2Placement,
           a_generateOutputConnectors,
           a_causality )
      equation
        ret_0 = stringEq(a_causality, "output");
        ret_1 = boolAnd(a_generateOutputConnectors, ret_0);
        txt = fun_490(txt, ret_1, a_y2Placement, a_x2Placement, a_y1Placement, a_x1Placement);
      then txt;

    case ( txt,
           _,
           a_x1Placement,
           a_x2Placement,
           a_y1Placement,
           a_y2Placement,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" annotation(Placement(transformation(extent={{"));
        txt = Tpl.writeStr(txt, intString(a_x1Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_y1Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("},{"));
        txt = Tpl.writeStr(txt, intString(a_x2Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(a_y2Placement));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}})))"));
      then txt;
  end match;
end fun_491;

public function dumpFMIModelVariablePlacementAnnotation
  input Tpl.Text txt;
  input Integer a_x1Placement;
  input Integer a_x2Placement;
  input Integer a_y1Placement;
  input Integer a_y2Placement;
  input Boolean a_generateInputConnectors;
  input Boolean a_generateOutputConnectors;
  input String a_causality;

  output Tpl.Text out_txt;
protected
  Boolean ret_1;
  Boolean ret_0;
algorithm
  ret_0 := stringEq(a_causality, "input");
  ret_1 := boolAnd(a_generateInputConnectors, ret_0);
  out_txt := fun_491(txt, ret_1, a_x1Placement, a_x2Placement, a_y1Placement, a_y2Placement, a_generateOutputConnectors, a_causality);
end dumpFMIModelVariablePlacementAnnotation;

protected function lm_493
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputRealVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_493(txt, rest);
      then txt;
  end match;
end lm_493;

public function dumpInputRealVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_493(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputRealVariablesVRs;

public function dumpInputRealVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.REALVARIABLE(causality = "input", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputRealVariableVR;

protected function lm_496
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputRealVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_496(txt, rest);
      then txt;
  end match;
end lm_496;

public function dumpInputRealVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_496(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputRealVariablesNames;

public function dumpInputRealVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.REALVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputRealVariableName;

protected function lm_499
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputRealVariableReturnName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_499(txt, rest);
      then txt;
  end match;
end lm_499;

public function dumpInputRealVariablesReturnNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_499(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputRealVariablesReturnNames;

public function dumpInputRealVariableReturnName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.REALVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi_input_"));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputRealVariableReturnName;

protected function lm_502
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputIntegerVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_502(txt, rest);
      then txt;
  end match;
end lm_502;

public function dumpInputIntegerVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_502(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputIntegerVariablesVRs;

public function dumpInputIntegerVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.INTEGERVARIABLE(causality = "input", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputIntegerVariableVR;

protected function lm_505
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputIntegerVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_505(txt, rest);
      then txt;
  end match;
end lm_505;

public function dumpInputIntegerVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_505(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputIntegerVariablesNames;

public function dumpInputIntegerVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.INTEGERVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputIntegerVariableName;

protected function lm_508
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputIntegerVariableReturnName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_508(txt, rest);
      then txt;
  end match;
end lm_508;

public function dumpInputIntegerVariablesReturnNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_508(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputIntegerVariablesReturnNames;

public function dumpInputIntegerVariableReturnName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.INTEGERVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi_input_"));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputIntegerVariableReturnName;

protected function lm_511
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputBooleanVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_511(txt, rest);
      then txt;
  end match;
end lm_511;

public function dumpInputBooleanVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_511(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputBooleanVariablesVRs;

public function dumpInputBooleanVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.BOOLEANVARIABLE(causality = "input", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputBooleanVariableVR;

protected function lm_514
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputBooleanVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_514(txt, rest);
      then txt;
  end match;
end lm_514;

public function dumpInputBooleanVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_514(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputBooleanVariablesNames;

public function dumpInputBooleanVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.BOOLEANVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputBooleanVariableName;

protected function lm_517
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputBooleanVariableReturnName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_517(txt, rest);
      then txt;
  end match;
end lm_517;

public function dumpInputBooleanVariablesReturnNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_517(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputBooleanVariablesReturnNames;

public function dumpInputBooleanVariableReturnName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.BOOLEANVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi_input_"));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputBooleanVariableReturnName;

protected function lm_520
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputStringVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_520(txt, rest);
      then txt;
  end match;
end lm_520;

public function dumpInputStringVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_520(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputStringVariablesVRs;

public function dumpInputStringVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.STRINGVARIABLE(causality = "input", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputStringVariableVR;

protected function lm_523
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputStringVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_523(txt, rest);
      then txt;
  end match;
end lm_523;

public function dumpInputStringVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_523(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputStringVariablesNames;

public function dumpInputStringVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.STRINGVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputStringVariableName;

protected function lm_526
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpInputStringVariableReturnName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_526(txt, rest);
      then txt;
  end match;
end lm_526;

public function dumpInputStringVariablesReturnNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_526(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpInputStringVariablesReturnNames;

public function dumpInputStringVariableReturnName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.STRINGVARIABLE(causality = "input", name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("fmi_input_"));
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInputStringVariableReturnName;

protected function lm_529
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputRealVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_529(txt, rest);
      then txt;
  end match;
end lm_529;

public function dumpOutputRealVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_529(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputRealVariablesVRs;

public function dumpOutputRealVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.REALVARIABLE(variability = "", causality = "", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           FMI.REALVARIABLE(variability = "", causality = "output", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputRealVariableVR;

protected function lm_532
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputRealVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_532(txt, rest);
      then txt;
  end match;
end lm_532;

public function dumpOutputRealVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_532(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputRealVariablesNames;

public function dumpOutputRealVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.REALVARIABLE(variability = "", causality = "", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           FMI.REALVARIABLE(variability = "", causality = "output", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputRealVariableName;

protected function lm_535
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputIntegerVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_535(txt, rest);
      then txt;
  end match;
end lm_535;

public function dumpOutputIntegerVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_535(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputIntegerVariablesVRs;

public function dumpOutputIntegerVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = "", causality = "", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = "", causality = "output", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputIntegerVariableVR;

protected function lm_538
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputIntegerVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_538(txt, rest);
      then txt;
  end match;
end lm_538;

public function dumpOutputIntegerVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_538(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputIntegerVariablesNames;

public function dumpOutputIntegerVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = "", causality = "", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           FMI.INTEGERVARIABLE(variability = "", causality = "output", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputIntegerVariableName;

protected function lm_541
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputBooleanVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_541(txt, rest);
      then txt;
  end match;
end lm_541;

public function dumpOutputBooleanVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_541(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputBooleanVariablesVRs;

public function dumpOutputBooleanVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = "", causality = "", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = "", causality = "output", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputBooleanVariableVR;

protected function lm_544
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputBooleanVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_544(txt, rest);
      then txt;
  end match;
end lm_544;

public function dumpOutputBooleanVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_544(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputBooleanVariablesNames;

public function dumpOutputBooleanVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = "", causality = "", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           FMI.BOOLEANVARIABLE(variability = "", causality = "output", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputBooleanVariableName;

protected function lm_547
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputStringVariableVR(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_547(txt, rest);
      then txt;
  end match;
end lm_547;

public function dumpOutputStringVariablesVRs
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_547(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputStringVariablesVRs;

public function dumpOutputStringVariableVR
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      Real i_valueReference;

    case ( txt,
           FMI.STRINGVARIABLE(variability = "", causality = "", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           FMI.STRINGVARIABLE(variability = "", causality = "output", valueReference = i_valueReference) )
      equation
        txt = Tpl.writeStr(txt, realString(i_valueReference));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputStringVariableVR;

protected function lm_550
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest )
      equation
        txt = dumpOutputStringVariableName(txt, i_fmiModelVariable);
        txt = Tpl.nextIter(txt);
        txt = lm_550(txt, rest);
      then txt;
  end match;
end lm_550;

public function dumpOutputStringVariablesNames
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_550(out_txt, a_fmiModelVariablesList);
  out_txt := Tpl.popIter(out_txt);
end dumpOutputStringVariablesNames;

public function dumpOutputStringVariableName
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable)
    local
      Tpl.Text txt;
      String i_name;

    case ( txt,
           FMI.STRINGVARIABLE(variability = "", causality = "", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           FMI.STRINGVARIABLE(variability = "", causality = "output", name = i_name) )
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpOutputStringVariableName;

protected function lm_553
  input Tpl.Text in_txt;
  input list<FMI.ModelVariables> in_items;
  input String in_a_fmiType;
  input String in_a_fmiGetFunction;
  input list<FMI.TypeDefinitions> in_a_fmiTypeDefinitionsList;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_fmiType, in_a_fmiGetFunction, in_a_fmiTypeDefinitionsList)
    local
      Tpl.Text txt;
      list<FMI.ModelVariables> rest;
      String a_fmiType;
      String a_fmiGetFunction;
      list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;
      FMI.ModelVariables i_fmiModelVariable;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_fmiModelVariable :: rest,
           a_fmiType,
           a_fmiGetFunction,
           a_fmiTypeDefinitionsList )
      equation
        txt = dumpOutputGetEnumerationVariable(txt, i_fmiModelVariable, a_fmiTypeDefinitionsList, a_fmiGetFunction, a_fmiType);
        txt = lm_553(txt, rest, a_fmiType, a_fmiGetFunction, a_fmiTypeDefinitionsList);
      then txt;
  end match;
end lm_553;

public function dumpOutputGetEnumerationVariables
  input Tpl.Text txt;
  input list<FMI.ModelVariables> a_fmiModelVariablesList;
  input list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;
  input String a_fmiGetFunction;
  input String a_fmiType;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_553(txt, a_fmiModelVariablesList, a_fmiType, a_fmiGetFunction, a_fmiTypeDefinitionsList);
end dumpOutputGetEnumerationVariables;

public function dumpOutputGetEnumerationVariable
  input Tpl.Text in_txt;
  input FMI.ModelVariables in_a_fmiModelVariable;
  input list<FMI.TypeDefinitions> in_a_fmiTypeDefinitionsList;
  input String in_a_fmiGetFunction;
  input String in_a_fmiType;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_fmiModelVariable, in_a_fmiTypeDefinitionsList, in_a_fmiGetFunction, in_a_fmiType)
    local
      Tpl.Text txt;
      list<FMI.TypeDefinitions> a_fmiTypeDefinitionsList;
      String a_fmiGetFunction;
      String a_fmiType;
      Real i_valueReference;
      String i_baseType;
      String i_name;
      String ret_1;
      String ret_0;

    case ( txt,
           FMI.ENUMERATIONVARIABLE(variability = "", causality = "", name = i_name, baseType = i_baseType, valueReference = i_valueReference),
           a_fmiTypeDefinitionsList,
           a_fmiGetFunction,
           a_fmiType )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = map_"));
        ret_0 = FMI.getEnumerationTypeFromTypes(a_fmiTypeDefinitionsList, i_baseType);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_from_integers("));
        txt = Tpl.writeStr(txt, a_fmiGetFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, a_fmiType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", {"));
        txt = Tpl.writeStr(txt, realString(i_valueReference));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs));"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           FMI.ENUMERATIONVARIABLE(variability = "", causality = "output", name = i_name, baseType = i_baseType, valueReference = i_valueReference),
           a_fmiTypeDefinitionsList,
           a_fmiGetFunction,
           a_fmiType )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("} = map_"));
        ret_1 = FMI.getEnumerationTypeFromTypes(a_fmiTypeDefinitionsList, i_baseType);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_from_integers("));
        txt = Tpl.writeStr(txt, a_fmiGetFunction);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeStr(txt, a_fmiType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", {"));
        txt = Tpl.writeStr(txt, realString(i_valueReference));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}, flowStatesInputs));"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end dumpOutputGetEnumerationVariable;

annotation(__OpenModelica_Interface="backend");
end CodegenFMU;