encapsulated package CodegenQSS
"
  file:        CodegenQSS.mo
  package:     CodegenQSS
  description: Generated by Susan.
"

public import Tpl;

public import SimCodeVar;
public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import SCodeDump;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCodeMain;
public import HpcOmSimCode;
public import HpcOmMemory;
public import HpcOmScheduler;
public import CodegenUtil;
public import CodegenC;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_qssInfo)
    local
      Tpl.Text txt;
      BackendQSS.QSSinfo a_qssInfo;
      SimCode.ModelInfo i_modelInfo;
      SimCode.SimCode i_simCode;
      Tpl.Text txt_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = _)))),
           a_qssInfo )
      equation
        txt_0 = generateQsmModel(Tpl.emptyTxt, i_simCode, a_qssInfo);
        txt_1 = getName(Tpl.emptyTxt, i_modelInfo);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".mo"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt_2 = getName(Tpl.emptyTxt, i_modelInfo);
        txt_3 = generateMakefile(Tpl.emptyTxt, Tpl.textString(txt_2));
        txt_4 = getName(Tpl.emptyTxt, i_modelInfo);
        txt_4 = Tpl.writeTok(txt_4, Tpl.ST_STRING(".makefile"));
        Tpl.textFile(txt_3, Tpl.textString(txt_4));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end translateModel;

protected function lm_38
  input Tpl.Text in_txt;
  input list<list<SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_externalFuncs;
  input Tpl.Text in_a_funDecls;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_externalFuncs;
  output Tpl.Text out_a_funDecls;
algorithm
  (out_txt, out_a_externalFuncs, out_a_funDecls) :=
  match(in_txt, in_items, in_a_externalFuncs, in_a_funDecls, in_a_qssInfo)
    local
      Tpl.Text txt;
      list<list<SimCode.SimEqSystem>> rest;
      Tpl.Text a_externalFuncs;
      Tpl.Text a_funDecls;
      BackendQSS.QSSinfo a_qssInfo;
      list<SimCode.SimEqSystem> i_eq;
      list<DAE.ComponentRef> ret_3;
      list<DAE.ComponentRef> ret_2;
      list<DAE.ComponentRef> ret_1;
      list<list<Integer>> ret_0;

    case ( txt,
           {},
           a_externalFuncs,
           a_funDecls,
           _ )
      then (txt, a_externalFuncs, a_funDecls);

    case ( txt,
           i_eq :: rest,
           a_externalFuncs,
           a_funDecls,
           a_qssInfo )
      equation
        ret_0 = BackendQSS.getStateIndexList(a_qssInfo);
        ret_1 = BackendQSS.getStates(a_qssInfo);
        ret_2 = BackendQSS.getDisc(a_qssInfo);
        ret_3 = BackendQSS.getAlgs(a_qssInfo);
        (txt, a_funDecls, a_externalFuncs) = generateOdeEqs(txt, i_eq, ret_0, ret_1, ret_2, ret_3, a_funDecls, a_externalFuncs);
        txt = Tpl.nextIter(txt);
        (txt, a_externalFuncs, a_funDecls) = lm_38(txt, rest, a_externalFuncs, a_funDecls, a_qssInfo);
      then (txt, a_externalFuncs, a_funDecls);
  end match;
end lm_38;

public function generateQsmModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;
  input BackendQSS.QSSinfo in_a_qssInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode, in_a_qssInfo)
    local
      Tpl.Text txt;
      BackendQSS.QSSinfo a_qssInfo;
      list<SimCode.SimWhenClause> i_whenClauses;
      list<BackendDAE.ZeroCrossing> i_zeroCrossings;
      Option<SimCode.SimulationSettings> i_simulationSettingsOpt;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      SimCode.ModelInfo i_modelInfo;
      Integer ret_13;
      list<DAE.Exp> ret_12;
      BackendDAE.EquationArray ret_11;
      list<DAE.ComponentRef> ret_10;
      list<DAE.ComponentRef> ret_9;
      list<DAE.ComponentRef> ret_8;
      Integer ret_7;
      list<DAE.ComponentRef> ret_6;
      list<DAE.ComponentRef> ret_5;
      list<DAE.ComponentRef> ret_4;
      Tpl.Text txt_3;
      Tpl.Text l_eqs;
      Tpl.Text l_externalFuncs;
      Tpl.Text l_funDecls;

    case ( txt,
           SimCode.SIMCODE(modelInfo = i_modelInfo, odeEquations = i_odeEquations, parameterEquations = i_parameterEquations, simulationSettingsOpt = i_simulationSettingsOpt, zeroCrossings = i_zeroCrossings, whenClauses = i_whenClauses),
           a_qssInfo )
      equation
        l_funDecls = Tpl.emptyTxt;
        l_externalFuncs = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING_LIST({
                                                         "#include <gsl/gsl_math.h>\n",
                                                         "#include <gsl/gsl_blas.h>\n",
                                                         "#include <gsl/gsl_vector.h>\n",
                                                         "#include <gsl/gsl_matrix.h>\n",
                                                         "#include <gsl/gsl_linalg.h>\n",
                                                         "#include \""
                                                     }, false));
        l_externalFuncs = getName(l_externalFuncs, i_modelInfo);
        l_externalFuncs = Tpl.writeTok(l_externalFuncs, Tpl.ST_LINE("_parameters.h\" // Parameters\n"));
        l_eqs = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (l_eqs, l_externalFuncs, l_funDecls) = lm_38(l_eqs, i_odeEquations, l_externalFuncs, l_funDecls, a_qssInfo);
        l_eqs = Tpl.popIter(l_eqs);
        txt_3 = getName(Tpl.emptyTxt, i_modelInfo);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("_external_functions.c"));
        Tpl.textFile(l_externalFuncs, Tpl.textString(txt_3));
        ret_4 = BackendQSS.getStates(a_qssInfo);
        ret_5 = BackendQSS.getDisc(a_qssInfo);
        ret_6 = BackendQSS.getAlgs(a_qssInfo);
        txt = generateModelInfo(txt, i_modelInfo, ret_4, ret_5, ret_6, i_parameterEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_funDecls);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = generateAnnotation(txt, i_simulationSettingsOpt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Equations */\n",
                                    "equation\n"
                                }, true));
        txt = Tpl.writeText(txt, l_eqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "algorithm\n",
                                    "/* Discontinuities("
                                }, false));
        ret_7 = listLength(i_zeroCrossings);
        txt = Tpl.writeStr(txt, intString(ret_7));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") */\n"));
        ret_8 = BackendQSS.getStates(a_qssInfo);
        ret_9 = BackendQSS.getDisc(a_qssInfo);
        ret_10 = BackendQSS.getAlgs(a_qssInfo);
        ret_11 = BackendQSS.getEqs(a_qssInfo);
        ret_12 = BackendQSS.getZCExps(a_qssInfo);
        ret_13 = BackendQSS.getZCOffset(a_qssInfo);
        txt = generateDiscont(txt, i_zeroCrossings, ret_8, ret_9, ret_10, i_whenClauses, ret_11, 0, ret_12, ret_13);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end "));
        txt = getName(txt, i_modelInfo);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end generateQsmModel;

public function getName
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      Absyn.Path i_name;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.MODELINFO(name = i_name) )
      equation
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_1 = System.stringReplace(Tpl.textString(txt_0), ".", "_");
        txt = Tpl.writeStr(txt, ret_1);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end getName;

public function generateModelInfo
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input list<DAE.ComponentRef> in_a_states;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_algs;
  input list<SimCode.SimEqSystem> in_a_parameterEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_states, in_a_disc, in_a_algs, in_a_parameterEquations)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_states;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_algs;
      list<SimCode.SimEqSystem> a_parameterEquations;
      SimCode.ModelInfo i_modelInfo;

    case ( txt,
           (i_modelInfo as SimCode.MODELINFO(varInfo = SimCode.VARINFO(numZeroCrossings = _))),
           a_states,
           a_disc,
           a_algs,
           a_parameterEquations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("model "));
        txt = getName(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = generateInitFunction(txt, i_modelInfo, a_states, a_disc, a_algs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Parameters */\n"
                                }, true));
        txt = generateParameters(txt, i_modelInfo, a_parameterEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end generateModelInfo;

public function OptionInitial
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_initialValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_initialValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(DAE.BCONST(bool = true)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("1.0"));
      then txt;

    case ( txt,
           SOME(DAE.BCONST(bool = false)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0.0"));
      then txt;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = CodegenUtil.initValXml(txt, i_exp);
      then txt;

    case ( txt,
           NONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("0.0"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end OptionInitial;

protected function fun_43
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      Option<DAE.Exp> i_initialValue;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name, initialValue = i_initialValue) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" (start = "));
        txt = OptionInitial(txt, i_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_43;

public function InitStateVariable
  input Tpl.Text txt;
  input SimCodeVar.SimVar a_simVar;
  input list<DAE.ComponentRef> a_vars;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_43(txt, a_simVar);
end InitStateVariable;

protected function fun_45
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_simVar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simVar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Real "));
        txt = CodegenUtil.crefStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_45;

public function InitAlgVariable
  input Tpl.Text txt;
  input SimCodeVar.SimVar a_simVar;
  input list<DAE.ComponentRef> a_vars;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_45(txt, a_simVar);
end InitAlgVariable;

public function InitDiscVariable
  input Tpl.Text txt;
  input DAE.ComponentRef a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("0.0"));
end InitDiscVariable;

public function generateVarDefinition
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_var;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_var)
    local
      Tpl.Text txt;
      Option<DAE.Exp> i_initialValue;
      DAE.ComponentRef i_name;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name, initialValue = i_initialValue) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter Real "));
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = System.stringReplace(Tpl.textString(txt_0), ".", "_");
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = OptionInitial(txt, i_initialValue);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateVarDefinition;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = generateVarDefinition(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_49(txt, rest);
      then txt;
  end match;
end lm_49;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = generateVarDefinition(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;
  end match;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = generateVarDefinition(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input SimCodeVar.SimVars in_a_vars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_vars)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCodeVar.SimVars a_vars;
      SimCode.SimEqSystem i_eq;
      String ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_vars )
      equation
        ret_0 = BackendQSS.generateExtraParams(i_eq, a_vars);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest, a_vars);
      then txt;
  end match;
end lm_52;

public function generateParameters
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input list<SimCode.SimEqSystem> in_a_parameterEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_parameterEquations)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> a_parameterEquations;
      SimCodeVar.SimVars i_vars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      SimCode.ModelInfo i_modelInfo;
      Tpl.Text txt_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_modelInfo as SimCode.MODELINFO(vars = (i_vars as SimCodeVar.SIMVARS(paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars)))),
           a_parameterEquations )
      equation
        txt_0 = generateHeader(Tpl.emptyTxt, i_modelInfo, a_parameterEquations);
        txt_1 = getName(Tpl.emptyTxt, i_modelInfo);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_parameters.h"));
        Tpl.textFile(txt_0, Tpl.textString(txt_1));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_49(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_50(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_51(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, a_parameterEquations, i_vars);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end generateParameters;

protected function lm_54
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input list<DAE.ComponentRef> in_a_states;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_states)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      list<DAE.ComponentRef> a_states;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_states )
      equation
        txt = InitStateVariable(txt, i_var, a_states);
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest, a_states);
      then txt;
  end match;
end lm_54;

protected function lm_55
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input list<DAE.ComponentRef> in_a_algs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_algs)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      list<DAE.ComponentRef> a_algs;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_algs )
      equation
        txt = InitAlgVariable(txt, i_var, a_algs);
        txt = Tpl.nextIter(txt);
        txt = lm_55(txt, rest, a_algs);
      then txt;
  end match;
end lm_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input list<DAE.ComponentRef> in_a_algs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_algs)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      list<DAE.ComponentRef> a_algs;
      SimCodeVar.SimVar i_var;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_var :: rest,
           a_algs )
      equation
        txt = InitAlgVariable(txt, i_var, a_algs);
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest, a_algs);
      then txt;
  end match;
end lm_56;

public function generateInitFunction
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;
  input list<DAE.ComponentRef> in_a_states;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_algs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo, in_a_states, in_a_disc, in_a_algs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_states;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_algs;
      SimCodeVar.SimVars i_vars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;
      String ret_3;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           SimCode.MODELINFO(vars = (i_vars as SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars))),
           a_states,
           a_disc,
           a_algs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* States */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_54(txt, i_vars_stateVars, a_states);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Algebraics */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_55(txt, i_vars_algVars, a_algs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Discrete Algebraics */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_56(txt, i_vars_discreteAlgVars, a_algs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Discretes */\n",
                                    "discrete Real d["
                                }, false));
        ret_0 = listLength(a_disc);
        txt = Tpl.writeStr(txt, intString(ret_0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "](start=dinit());\n",
                                    "\n",
                                    "function boolToReal\n",
                                    "  input Boolean b;\n",
                                    "  output Real r;\n",
                                    "algorithm\n",
                                    "  r:=if b then 1.0 else 0.0;\n",
                                    "end boolToReal;\n",
                                    "\n",
                                    "function dinit\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output Real d["));
        ret_1 = listLength(a_disc);
        txt = Tpl.writeStr(txt, intString(ret_1));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("];\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("algorithm\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_2 = listLength(a_disc);
        ret_3 = BackendQSS.generateDInit(a_disc, i_vars, 0, ret_2, 1);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end dinit;"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end generateInitFunction;

public function generateAnnotation
  input Tpl.Text in_txt;
  input Option<SimCode.SimulationSettings> in_a_simulationSettingsOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simulationSettingsOpt)
    local
      Tpl.Text txt;
      Real i_s_stopTime;
      Real i_s_startTime;

    case ( txt,
           SOME(SimCode.SIMULATION_SETTINGS(startTime = i_s_startTime, stopTime = i_s_stopTime)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("annotation(experiment(StartTime = "));
        txt = Tpl.writeStr(txt, realString(i_s_startTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", StopTime = "));
        txt = Tpl.writeStr(txt, realString(i_s_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", Tolerance = 1e-3, AbsTolerance = 1e-3, Solver = LIQSS2, StepSize = "));
        txt = Tpl.writeStr(txt, realString(i_s_stopTime));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/500));"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end generateAnnotation;

protected function lm_59
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_externalFuncs;
  input Tpl.Text in_a_funDecls;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_externalFuncs;
  output Tpl.Text out_a_funDecls;
algorithm
  (out_txt, out_a_externalFuncs, out_a_funDecls) :=
  match(in_txt, in_items, in_a_externalFuncs, in_a_funDecls, in_a_algs, in_a_disc, in_a_states)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_externalFuncs;
      Tpl.Text a_funDecls;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           a_externalFuncs,
           a_funDecls,
           _,
           _,
           _ )
      then (txt, a_externalFuncs, a_funDecls);

    case ( txt,
           i_eq :: rest,
           a_externalFuncs,
           a_funDecls,
           a_algs,
           a_disc,
           a_states )
      equation
        (txt, a_funDecls, a_externalFuncs) = generateOdeEq(txt, i_eq, a_states, a_disc, a_algs, a_funDecls, a_externalFuncs);
        txt = Tpl.nextIter(txt);
        (txt, a_externalFuncs, a_funDecls) = lm_59(txt, rest, a_externalFuncs, a_funDecls, a_algs, a_disc, a_states);
      then (txt, a_externalFuncs, a_funDecls);
  end match;
end lm_59;

public function generateOdeEqs
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_odeEquations;
  input list<list<Integer>> a_indexs;
  input list<DAE.ComponentRef> a_states;
  input list<DAE.ComponentRef> a_disc;
  input list<DAE.ComponentRef> a_algs;
  input Tpl.Text a_funDecls;
  input Tpl.Text a_externalFuncs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_funDecls;
  output Tpl.Text out_a_externalFuncs;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (out_txt, out_a_externalFuncs, out_a_funDecls) := lm_59(out_txt, a_odeEquations, a_externalFuncs, a_funDecls, a_algs, a_disc, a_states);
  out_txt := Tpl.popIter(out_txt);
end generateOdeEqs;

protected function fun_61
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_v;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v, in_a_algs, in_a_disc, in_a_states)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      DAE.ComponentRef i_name;
      String ret_0;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name),
           a_algs,
           a_disc,
           a_states )
      equation
        ret_0 = BackendQSS.replaceCref(i_name, a_states, a_disc, a_algs);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_61;

protected function lm_62
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_algs, in_a_disc, in_a_states)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      SimCodeVar.SimVar i_v;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_v :: rest,
           a_algs,
           a_disc,
           a_states )
      equation
        txt = fun_61(txt, i_v, a_algs, a_disc, a_states);
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest, a_algs, a_disc, a_states);
      then txt;
  end match;
end lm_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_algs, in_a_disc, in_a_states)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      DAE.ComponentRef i_cref;
      String ret_0;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_cref :: rest,
           a_algs,
           a_disc,
           a_states )
      equation
        ret_0 = BackendQSS.replaceCref(i_cref, a_states, a_disc, a_algs);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest, a_algs, a_disc, a_states);
      then txt;
  end match;
end lm_63;

protected function lm_64
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("input Real i"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_64(txt, rest);
      then txt;
  end match;
end lm_64;

protected function lm_65
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("output Real o"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_65(txt, rest);
      then txt;
  end match;
end lm_65;

public function generateOdeEq
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_odeEquation;
  input list<DAE.ComponentRef> in_a_states;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_algs;
  input Tpl.Text in_a_funDecls;
  input Tpl.Text in_a_externalFuncs;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_funDecls;
  output Tpl.Text out_a_externalFuncs;
algorithm
  (out_txt, out_a_funDecls, out_a_externalFuncs) :=
  match(in_txt, in_a_odeEquation, in_a_states, in_a_disc, in_a_algs, in_a_funDecls, in_a_externalFuncs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_states;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_algs;
      Tpl.Text a_funDecls;
      Tpl.Text a_externalFuncs;
      Integer i_index;
      SimCode.SimEqSystem i_e;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<DAE.Exp> i_beqs;
      list<SimCodeVar.SimVar> i_vars;
      DAE.Exp i_exp;
      DAE.ComponentRef i_cref;
      list<DAE.ComponentRef> ret_7;
      list<DAE.ComponentRef> ret_6;
      Tpl.Text l_in__vars;
      Tpl.Text l_out__vars;
      String ret_3;
      DAE.Exp ret_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref, exp = i_exp),
           a_states,
           a_disc,
           a_algs,
           a_funDecls,
           a_externalFuncs )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_cref);
        ret_1 = System.stringReplace(Tpl.textString(txt_0), ".", "_");
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        ret_2 = BackendQSS.replaceVars(i_exp, a_states, a_disc, a_algs);
        ret_3 = ExpressionDump.printExpStr(ret_2);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.popBlock(txt);
      then (txt, a_funDecls, a_externalFuncs);

    case ( txt,
           (i_e as SimCode.SES_LINEAR(vars = i_vars, index = i_index, beqs = i_beqs, simJac = i_simJac)),
           a_states,
           a_disc,
           a_algs,
           a_funDecls,
           a_externalFuncs )
      equation
        l_out__vars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_out__vars = lm_62(l_out__vars, i_vars, a_algs, a_disc, a_states);
        l_out__vars = Tpl.popIter(l_out__vars);
        ret_6 = BackendQSS.getRHSVars(i_beqs, i_vars, i_simJac, a_states, a_disc, a_algs);
        l_in__vars = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_in__vars = lm_63(l_in__vars, ret_6, a_algs, a_disc, a_states);
        l_in__vars = Tpl.popIter(l_in__vars);
        a_externalFuncs = generateLinear(a_externalFuncs, i_e, a_states, a_disc, a_algs);
        a_funDecls = Tpl.writeTok(a_funDecls, Tpl.ST_NEW_LINE());
        a_funDecls = Tpl.pushBlock(a_funDecls, Tpl.BT_INDENT(2));
        a_funDecls = Tpl.writeTok(a_funDecls, Tpl.ST_STRING("function fsolve"));
        a_funDecls = Tpl.writeStr(a_funDecls, intString(i_index));
        a_funDecls = Tpl.softNewLine(a_funDecls);
        a_funDecls = Tpl.pushBlock(a_funDecls, Tpl.BT_INDENT(2));
        ret_7 = BackendQSS.getRHSVars(i_beqs, i_vars, i_simJac, a_states, a_disc, a_algs);
        a_funDecls = Tpl.pushIter(a_funDecls, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        a_funDecls = lm_64(a_funDecls, ret_7);
        a_funDecls = Tpl.popIter(a_funDecls);
        a_funDecls = Tpl.softNewLine(a_funDecls);
        a_funDecls = Tpl.pushIter(a_funDecls, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        a_funDecls = lm_65(a_funDecls, i_vars);
        a_funDecls = Tpl.popIter(a_funDecls);
        a_funDecls = Tpl.softNewLine(a_funDecls);
        a_funDecls = Tpl.popBlock(a_funDecls);
        a_funDecls = Tpl.writeTok(a_funDecls, Tpl.ST_STRING_LIST({
                                                  "external \"C\" ;\n",
                                                  "end fsolve"
                                              }, false));
        a_funDecls = Tpl.writeStr(a_funDecls, intString(i_index));
        a_funDecls = Tpl.writeTok(a_funDecls, Tpl.ST_STRING_LIST({
                                                  ";\n",
                                                  "\n"
                                              }, true));
        a_funDecls = Tpl.popBlock(a_funDecls);
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_out__vars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")=fsolve"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, l_in__vars);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.popBlock(txt);
      then (txt, a_funDecls, a_externalFuncs);

    case ( txt,
           SimCode.SES_RESIDUAL(index = _),
           _,
           _,
           _,
           a_funDecls,
           a_externalFuncs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  /* Residual */"));
      then (txt, a_funDecls, a_externalFuncs);

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = _),
           _,
           _,
           _,
           a_funDecls,
           a_externalFuncs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  /* Array */"));
      then (txt, a_funDecls, a_externalFuncs);

    case ( txt,
           SimCode.SES_NONLINEAR(index = _),
           _,
           _,
           _,
           a_funDecls,
           a_externalFuncs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  /* Non linear */"));
      then (txt, a_funDecls, a_externalFuncs);

    case ( txt,
           SimCode.SES_MIXED(index = _),
           _,
           _,
           _,
           a_funDecls,
           a_externalFuncs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  /* Mixed */"));
      then (txt, a_funDecls, a_externalFuncs);

    case ( txt,
           SimCode.SES_WHEN(index = _),
           _,
           _,
           _,
           a_funDecls,
           a_externalFuncs )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("  /* When */"));
      then (txt, a_funDecls, a_externalFuncs);

    case ( txt,
           SimCode.SES_ALGORITHM(index = _),
           _,
           _,
           _,
           a_funDecls,
           a_externalFuncs )
      then (txt, a_funDecls, a_externalFuncs);

    case ( txt,
           _,
           _,
           _,
           _,
           a_funDecls,
           a_externalFuncs )
      then (txt, a_funDecls, a_externalFuncs);
  end match;
end generateOdeEq;

protected function lm_67
  input Tpl.Text in_txt;
  input list<BackendDAE.ZeroCrossing> in_items;
  input Integer in_a_offset;
  input list<DAE.Exp> in_a_zc__exps;
  input BackendDAE.EquationArray in_a_eqs;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_offset, in_a_zc__exps, in_a_eqs, in_a_algs, in_a_disc, in_a_states)
    local
      Tpl.Text txt;
      list<BackendDAE.ZeroCrossing> rest;
      Integer a_offset;
      list<DAE.Exp> a_zc__exps;
      BackendDAE.EquationArray a_eqs;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      BackendDAE.ZeroCrossing i_zc;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_zc :: rest,
           a_offset,
           a_zc__exps,
           a_eqs,
           a_algs,
           a_disc,
           a_states )
      equation
        txt = generateOneZC(txt, i_zc, a_states, a_disc, a_algs, a_eqs, a_zc__exps, a_offset);
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest, a_offset, a_zc__exps, a_eqs, a_algs, a_disc, a_states);
      then txt;
  end match;
end lm_67;

public function generateZC
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zcs;
  input list<DAE.ComponentRef> a_states;
  input list<DAE.ComponentRef> a_disc;
  input list<DAE.ComponentRef> a_algs;
  input BackendDAE.EquationArray a_eqs;
  input list<DAE.Exp> a_zc__exps;
  input Integer a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_67(out_txt, a_zcs, a_offset, a_zc__exps, a_eqs, a_algs, a_disc, a_states);
  out_txt := Tpl.popIter(out_txt);
end generateZC;

public function generateAssigment
  input Tpl.Text txt;
  input BackendDAE.EqSystem a_eq;
  input list<DAE.ComponentRef> a_states;
  input list<DAE.ComponentRef> a_disc;
  input list<DAE.ComponentRef> a_algs;

  output Tpl.Text out_txt;
algorithm
  out_txt := txt;
end generateAssigment;

public function generateOneZC
  input Tpl.Text in_txt;
  input BackendDAE.ZeroCrossing in_a_zc;
  input list<DAE.ComponentRef> in_a_states;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_algs;
  input BackendDAE.EquationArray in_a_eqs;
  input list<DAE.Exp> in_a_zc__exps;
  input Integer in_a_offset;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_zc, in_a_states, in_a_disc, in_a_algs, in_a_eqs, in_a_zc__exps, in_a_offset)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_states;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_algs;
      BackendDAE.EquationArray a_eqs;
      list<DAE.Exp> a_zc__exps;
      Integer a_offset;
      list<Integer> i_occurEquLst;
      DAE.Exp i_relation__;
      String ret_6;
      String ret_5;
      DAE.Exp ret_4;
      DAE.Exp ret_3;
      String ret_2;
      String ret_1;
      DAE.Exp ret_0;

    case ( txt,
           BackendDAE.ZERO_CROSSING(relation_ = i_relation__, occurEquLst = i_occurEquLst),
           a_states,
           a_disc,
           a_algs,
           a_eqs,
           a_zc__exps,
           a_offset )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("when "));
        ret_0 = BackendQSS.replaceVars(i_relation__, a_states, a_disc, a_algs);
        ret_1 = ExpressionDump.printExpStr(ret_0);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        ret_2 = BackendQSS.generateHandler(a_eqs, i_occurEquLst, a_states, a_disc, a_algs, i_relation__, true, a_zc__exps, a_offset);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("elsewhen "));
        ret_3 = BackendQSS.negate(i_relation__);
        ret_4 = BackendQSS.replaceVars(ret_3, a_states, a_disc, a_algs);
        ret_5 = ExpressionDump.printExpStr(ret_4);
        txt = Tpl.writeStr(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        ret_6 = BackendQSS.generateHandler(a_eqs, i_occurEquLst, a_states, a_disc, a_algs, i_relation__, false, a_zc__exps, a_offset);
        txt = Tpl.writeStr(txt, ret_6);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*  NOT MATCHED ZC */"));
      then txt;
  end match;
end generateOneZC;

public function generateWhen
  input Tpl.Text in_txt;
  input SimCode.SimWhenClause in_a_when;
  input list<DAE.ComponentRef> in_a_states;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_algs;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_when, in_a_states, in_a_disc, in_a_algs, in_a_index)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_states;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_algs;
      Integer a_index;
      DAE.Exp i_right;
      DAE.ComponentRef i_left;
      list<DAE.ComponentRef> i_conditions;
      String ret_6;
      DAE.Exp ret_5;
      String ret_4;
      String ret_3;
      DAE.Exp ret_2;
      String ret_1;
      Tpl.Text l_extraCode;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions, initialCall = _, whenEq = SOME(BackendDAE.WHEN_EQ(left = i_left, right = i_right, elsewhenPart = NONE()))),
           a_states,
           a_disc,
           a_algs,
           a_index )
      equation
        l_extraCode = Tpl.emptyTxt;
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* When "));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "when "
                                }, false));
        (txt, l_extraCode) = generateCond(txt, i_conditions, a_states, a_disc, a_algs, l_extraCode, a_index);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        ret_1 = BackendQSS.replaceCref(i_left, a_states, a_disc, a_algs);
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" := "));
        ret_2 = BackendQSS.replaceVars(i_right, a_states, a_disc, a_algs);
        ret_3 = ExpressionDump.printExpStr(ret_2);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, l_extraCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(conditions = i_conditions, initialCall = _, whenEq = SOME(BackendDAE.WHEN_EQ(left = i_left, right = i_right, elsewhenPart = SOME(_)))),
           a_states,
           a_disc,
           a_algs,
           a_index )
      equation
        l_extraCode = Tpl.emptyTxt;
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* When "));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " */\n",
                                    "when "
                                }, false));
        (txt, l_extraCode) = generateCond(txt, i_conditions, a_states, a_disc, a_algs, l_extraCode, a_index);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_4 = BackendQSS.replaceCref(i_left, a_states, a_disc, a_algs);
        txt = Tpl.writeStr(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" := "));
        ret_5 = BackendQSS.replaceVars(i_right, a_states, a_disc, a_algs);
        ret_6 = ExpressionDump.printExpStr(ret_5);
        txt = Tpl.writeStr(txt, ret_6);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.writeText(txt, l_extraCode);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*  NOT MATCHED WHEN */"));
      then txt;
  end match;
end generateWhen;

protected function fun_72
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_a_conds;
  input list<DAE.ComponentRef> in_a_states;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_algs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_conds, in_a_states, in_a_disc, in_a_algs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_states;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_algs;
      DAE.ComponentRef i_e;
      String ret_0;

    case ( txt,
           {i_e},
           a_states,
           a_disc,
           a_algs )
      equation
        ret_0 = BackendQSS.replaceCref(i_e, a_states, a_disc, a_algs);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > 0.5"));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_72;

public function generateCond
  input Tpl.Text txt;
  input list<DAE.ComponentRef> a_conds;
  input list<DAE.ComponentRef> a_states;
  input list<DAE.ComponentRef> a_disc;
  input list<DAE.ComponentRef> a_algs;
  input Tpl.Text a_extraCode;
  input Integer a_index;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_extraCode;
algorithm
  out_txt := fun_72(txt, a_conds, a_states, a_disc, a_algs);
  out_a_extraCode := a_extraCode;
end generateCond;

protected function lm_74
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_algs, in_a_disc, in_a_states)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      SimCode.SimWhenClause i_w;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_w :: rest,
           a_algs,
           a_disc,
           a_states )
      equation
        txt = generateWhen(txt, i_w, a_states, a_disc, a_algs, 0);
        txt = Tpl.nextIter(txt);
        txt = lm_74(txt, rest, a_algs, a_disc, a_states);
      then txt;
  end match;
end lm_74;

protected function lm_75
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;
  input Integer in_a_nSamples;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_nSamples, in_a_algs, in_a_disc, in_a_states)
    local
      Tpl.Text txt;
      list<SimCode.SimWhenClause> rest;
      Integer a_nSamples;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      Integer x_i0;
      SimCode.SimWhenClause i_w;
      Integer ret_2;
      Integer ret_1;
      Integer ret_0;

    case ( txt,
           {},
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_w :: rest,
           a_nSamples,
           a_algs,
           a_disc,
           a_states )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        ret_0 = listLength(a_disc);
        ret_1 = intSub(ret_0, a_nSamples);
        ret_2 = intAdd(x_i0, ret_1);
        txt = generateWhen(txt, i_w, a_states, a_disc, a_algs, ret_2);
        txt = Tpl.nextIter(txt);
        txt = lm_75(txt, rest, a_nSamples, a_algs, a_disc, a_states);
      then txt;
  end match;
end lm_75;

public function generateDiscont
  input Tpl.Text txt;
  input list<BackendDAE.ZeroCrossing> a_zcs;
  input list<DAE.ComponentRef> a_states;
  input list<DAE.ComponentRef> a_disc;
  input list<DAE.ComponentRef> a_algs;
  input list<SimCode.SimWhenClause> a_whens;
  input BackendDAE.EquationArray a_eqs;
  input Integer a_nSamples;
  input list<DAE.Exp> a_zc__exps;
  input Integer a_offset;

  output Tpl.Text out_txt;
protected
  list<SimCode.SimWhenClause> ret_1;
  list<SimCode.SimWhenClause> ret_0;
algorithm
  out_txt := generateZC(txt, a_zcs, a_states, a_disc, a_algs, a_eqs, a_zc__exps, a_offset);
  out_txt := Tpl.softNewLine(out_txt);
  ret_0 := BackendQSS.simpleWhens(a_whens);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_74(out_txt, ret_0, a_algs, a_disc, a_states);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  ret_1 := BackendQSS.sampleWhens(a_whens);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_75(out_txt, ret_1, a_nSamples, a_algs, a_disc, a_states);
  out_txt := Tpl.popIter(out_txt);
end generateDiscont;

protected function lm_77
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_index;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_a_simJac;
  input list<SimCodeVar.SimVar> in_a_vars;
  input list<DAE.Exp> in_a_beqs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index, in_a_algs, in_a_disc, in_a_states, in_a_simJac, in_a_vars, in_a_beqs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_index;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> a_simJac;
      list<SimCodeVar.SimVar> a_vars;
      list<DAE.Exp> a_beqs;
      DAE.ComponentRef i_v;
      Integer ret_2;
      list<DAE.ComponentRef> ret_1;
      Tpl.Text l_i;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_v :: rest,
           a_index,
           a_algs,
           a_disc,
           a_states,
           a_simJac,
           a_vars,
           a_beqs )
      equation
        ret_1 = BackendQSS.getRHSVars(a_beqs, a_vars, a_simJac, a_states, a_disc, a_algs);
        ret_2 = List.position(i_v, ret_1);
        l_i = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double old_i"));
        txt = Tpl.writeText(txt, l_i);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=-1;"));
        txt = Tpl.nextIter(txt);
        txt = lm_77(txt, rest, a_index, a_algs, a_disc, a_states, a_simJac, a_vars, a_beqs);
      then txt;
  end match;
end lm_77;

protected function lm_78
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double i"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest);
      then txt;
  end match;
end lm_78;

protected function lm_79
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer x_i0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = _) :: rest )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double *o"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.nextIter(txt);
        txt = lm_79(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_79(txt, rest);
      then txt;
  end match;
end lm_79;

protected function lm_80
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;
  input Integer in_a_index;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_a_simJac;
  input list<SimCodeVar.SimVar> in_a_vars;
  input list<DAE.Exp> in_a_beqs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index, in_a_algs, in_a_disc, in_a_states, in_a_simJac, in_a_vars, in_a_beqs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      Integer a_index;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> a_simJac;
      list<SimCodeVar.SimVar> a_vars;
      list<DAE.Exp> a_beqs;
      DAE.ComponentRef i_v;
      Integer ret_2;
      list<DAE.ComponentRef> ret_1;
      Tpl.Text l_i;

    case ( txt,
           {},
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_v :: rest,
           a_index,
           a_algs,
           a_disc,
           a_states,
           a_simJac,
           a_vars,
           a_beqs )
      equation
        ret_1 = BackendQSS.getRHSVars(a_beqs, a_vars, a_simJac, a_states, a_disc, a_algs);
        ret_2 = List.position(i_v, ret_1);
        l_i = Tpl.writeStr(Tpl.emptyTxt, intString(ret_2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (old_i"));
        txt = Tpl.writeText(txt, l_i);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("!=i"));
        txt = Tpl.writeText(txt, l_i);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ") {\n",
                                    "    invert_matrix=1;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("old_i"));
        txt = Tpl.writeText(txt, l_i);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("=i"));
        txt = Tpl.writeText(txt, l_i);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest, a_index, a_algs, a_disc, a_states, a_simJac, a_vars, a_beqs);
      then txt;
  end match;
end lm_80;

protected function lm_81
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_a_auxFunctionIgnore;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_a_simJac;
  input list<SimCodeVar.SimVar> in_a_vars;
  input list<DAE.Exp> in_a_beqs;
  input Integer in_a_index;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunctionIgnore;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_auxFunctionIgnore, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_auxFunctionIgnore, in_a_varDecls, in_a_preExp, in_a_algs, in_a_disc, in_a_states, in_a_simJac, in_a_vars, in_a_beqs, in_a_index)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      Tpl.Text a_auxFunctionIgnore;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> a_simJac;
      list<SimCodeVar.SimVar> a_vars;
      list<DAE.Exp> a_beqs;
      Integer a_index;
      Integer x_i0;
      DAE.Exp i_exp;
      String ret_3;
      Tpl.Text txt_2;
      DAE.Exp ret_1;
      list<DAE.ComponentRef> ret_0;

    case ( txt,
           {},
           a_auxFunctionIgnore,
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then (txt, a_auxFunctionIgnore, a_varDecls, a_preExp);

    case ( txt,
           i_exp :: rest,
           a_auxFunctionIgnore,
           a_varDecls,
           a_preExp,
           a_algs,
           a_disc,
           a_states,
           a_simJac,
           a_vars,
           a_beqs,
           a_index )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gsl_vector_set(b"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = BackendQSS.getRHSVars(a_beqs, a_vars, a_simJac, a_states, a_disc, a_algs);
        ret_1 = BackendQSS.replaceVarsInputs(i_exp, ret_0);
        (txt_2, a_preExp, a_varDecls, a_auxFunctionIgnore) = CodegenC.daeExp(Tpl.emptyTxt, ret_1, SimCode.contextOther, a_preExp, a_varDecls, a_auxFunctionIgnore);
        ret_3 = System.stringReplace(Tpl.textString(txt_2), "$P", "");
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunctionIgnore, a_varDecls, a_preExp) = lm_81(txt, rest, a_auxFunctionIgnore, a_varDecls, a_preExp, a_algs, a_disc, a_states, a_simJac, a_vars, a_beqs, a_index);
      then (txt, a_auxFunctionIgnore, a_varDecls, a_preExp);
  end match;
end lm_81;

protected function lm_82
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_a_auxFunctionIgnore;
  input Tpl.Text in_a_varDecls;
  input Tpl.Text in_a_preExp;
  input list<DAE.ComponentRef> in_a_algs;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_states;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_a_simJac;
  input list<SimCodeVar.SimVar> in_a_vars;
  input list<DAE.Exp> in_a_beqs;
  input Integer in_a_index;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_auxFunctionIgnore;
  output Tpl.Text out_a_varDecls;
  output Tpl.Text out_a_preExp;
algorithm
  (out_txt, out_a_auxFunctionIgnore, out_a_varDecls, out_a_preExp) :=
  match(in_txt, in_items, in_a_auxFunctionIgnore, in_a_varDecls, in_a_preExp, in_a_algs, in_a_disc, in_a_states, in_a_simJac, in_a_vars, in_a_beqs, in_a_index)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      Tpl.Text a_auxFunctionIgnore;
      Tpl.Text a_varDecls;
      Tpl.Text a_preExp;
      list<DAE.ComponentRef> a_algs;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_states;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> a_simJac;
      list<SimCodeVar.SimVar> a_vars;
      list<DAE.Exp> a_beqs;
      Integer a_index;
      DAE.Exp i_eq_exp;
      Integer i_col;
      Integer i_row;
      String ret_3;
      Tpl.Text txt_2;
      DAE.Exp ret_1;
      list<DAE.ComponentRef> ret_0;

    case ( txt,
           {},
           a_auxFunctionIgnore,
           a_varDecls,
           a_preExp,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      then (txt, a_auxFunctionIgnore, a_varDecls, a_preExp);

    case ( txt,
           (i_row, i_col, SimCode.SES_RESIDUAL(exp = i_eq_exp)) :: rest,
           a_auxFunctionIgnore,
           a_varDecls,
           a_preExp,
           a_algs,
           a_disc,
           a_states,
           a_simJac,
           a_vars,
           a_beqs,
           a_index )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gsl_matrix_set(A"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        ret_0 = BackendQSS.getRHSVars(a_beqs, a_vars, a_simJac, a_states, a_disc, a_algs);
        ret_1 = BackendQSS.replaceVarsInputs(i_eq_exp, ret_0);
        (txt_2, a_preExp, a_varDecls, a_auxFunctionIgnore) = CodegenC.daeExp(Tpl.emptyTxt, ret_1, SimCode.contextOther, a_preExp, a_varDecls, a_auxFunctionIgnore);
        ret_3 = System.stringReplace(Tpl.textString(txt_2), "$P", "");
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        (txt, a_auxFunctionIgnore, a_varDecls, a_preExp) = lm_82(txt, rest, a_auxFunctionIgnore, a_varDecls, a_preExp, a_algs, a_disc, a_states, a_simJac, a_vars, a_beqs, a_index);
      then (txt, a_auxFunctionIgnore, a_varDecls, a_preExp);

    case ( txt,
           _ :: rest,
           a_auxFunctionIgnore,
           a_varDecls,
           a_preExp,
           a_algs,
           a_disc,
           a_states,
           a_simJac,
           a_vars,
           a_beqs,
           a_index )
      equation
        (txt, a_auxFunctionIgnore, a_varDecls, a_preExp) = lm_82(txt, rest, a_auxFunctionIgnore, a_varDecls, a_preExp, a_algs, a_disc, a_states, a_simJac, a_vars, a_beqs, a_index);
      then (txt, a_auxFunctionIgnore, a_varDecls, a_preExp);
  end match;
end lm_82;

protected function lm_83
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Integer in_a_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_index)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer a_index;
      Integer x_i0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           _ :: rest,
           a_index )
      equation
        x_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*o"));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = gsl_vector_get(x"));
        txt = Tpl.writeStr(txt, intString(a_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(x_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_83(txt, rest, a_index);
      then txt;
  end match;
end lm_83;

public function generateLinear
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input list<DAE.ComponentRef> in_a_states;
  input list<DAE.ComponentRef> in_a_disc;
  input list<DAE.ComponentRef> in_a_algs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_states, in_a_disc, in_a_algs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> a_states;
      list<DAE.ComponentRef> a_disc;
      list<DAE.ComponentRef> a_algs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<SimCodeVar.SimVar> i_vars;
      list<DAE.Exp> i_beqs;
      Integer i_index;
      list<DAE.ComponentRef> ret_6;
      Integer ret_5;
      list<DAE.ComponentRef> ret_4;
      list<DAE.ComponentRef> ret_3;
      Tpl.Text l_auxFunctionIgnore;
      Tpl.Text l_varDecls;
      Tpl.Text l_preExp;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index, beqs = i_beqs, vars = i_vars, simJac = i_simJac),
           a_states,
           a_disc,
           a_algs )
      equation
        l_preExp = Tpl.emptyTxt;
        l_varDecls = Tpl.emptyTxt;
        l_auxFunctionIgnore = Tpl.emptyTxt;
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "gsl_matrix *A"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",*invA"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "gsl_vector *b"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",*x"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "gsl_permutation *p"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "int init"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" = 0;\n"));
        ret_3 = BackendQSS.getDiscRHSVars(i_beqs, i_vars, i_simJac, a_states, a_disc, a_algs);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_77(txt, ret_3, i_index, a_algs, a_disc, a_states, i_simJac, i_vars, i_beqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "void fsolve"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        ret_4 = BackendQSS.getRHSVars(i_beqs, i_vars, i_simJac, a_states, a_disc, a_algs);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_78(txt, ret_4);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_79(txt, i_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ")\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("const int DIM = "));
        ret_5 = listLength(i_beqs);
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "int invert_matrix = 0;\n",
                                    "int signum;\n",
                                    "\n",
                                    "invert_matrix = 0;\n",
                                    "\n"
                                }, true));
        ret_6 = BackendQSS.getDiscRHSVars(i_beqs, i_vars, i_simJac, a_states, a_disc, a_algs);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_80(txt, ret_6, i_index, a_algs, a_disc, a_states, i_simJac, i_vars, i_beqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "if (!init"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ") {\n",
                                    "  /* Alloc space */\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("A"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = gsl_matrix_alloc(DIM, DIM);\n",
                                    "invA"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = gsl_matrix_alloc(DIM, DIM);\n",
                                    "b"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = gsl_vector_alloc(DIM);\n",
                                    "x"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = gsl_vector_alloc(DIM);\n",
                                    "p"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " = gsl_permutation_alloc(DIM);\n",
                                    "init"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "=1;\n",
                                    "invert_matrix=1;\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "/* Fill B */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_auxFunctionIgnore, l_varDecls, l_preExp) = lm_81(txt, i_beqs, l_auxFunctionIgnore, l_varDecls, l_preExp, a_algs, a_disc, a_states, i_simJac, i_vars, i_beqs, i_index);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "/* Invert matrix if necesary */\n",
                                    "if (invert_matrix)\n",
                                    "{\n",
                                    "  /* Fill A */\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gsl_matrix_set_zero(A"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, l_auxFunctionIgnore, l_varDecls, l_preExp) = lm_82(txt, i_simJac, l_auxFunctionIgnore, l_varDecls, l_preExp, a_algs, a_disc, a_states, i_simJac, i_vars, i_beqs, i_index);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("gsl_linalg_LU_decomp(A"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", p"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ", &signum);\n",
                                    "gsl_linalg_LU_invert(A"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", p"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ,invA"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n",
                                    "/* Copmute x=inv(A)*b */\n",
                                    "gsl_blas_dgemv(CblasNoTrans,1.0,invA"
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",b"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",0.0,x"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "/* Get x values out */\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_83(txt, i_vars, i_index);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end generateLinear;

protected function fun_85
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern double "));
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = System.stringReplace(Tpl.textString(txt_0), ".", "_");
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_85;

protected function lm_86
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = fun_85(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest);
      then txt;
  end match;
end lm_86;

protected function fun_87
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern double "));
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = System.stringReplace(Tpl.textString(txt_0), ".", "_");
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_87;

protected function lm_88
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = fun_87(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_88(txt, rest);
      then txt;
  end match;
end lm_88;

protected function fun_89
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_v;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_name;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_name) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("extern double "));
        txt_0 = CodegenUtil.crefStr(Tpl.emptyTxt, i_name);
        ret_1 = System.stringReplace(Tpl.textString(txt_0), ".", "_");
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_89;

protected function lm_90
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      SimCodeVar.SimVar i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = fun_89(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_90(txt, rest);
      then txt;
  end match;
end lm_90;

protected function fun_91
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_a_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_modelInfo)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;

    case ( txt,
           SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars)) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_86(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_88(txt, i_vars_intParamVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_90(txt, i_vars_boolParamVars);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_91;

public function generateHeader
  input Tpl.Text txt;
  input SimCode.ModelInfo a_modelInfo;
  input list<SimCode.SimEqSystem> a_parameterEquations;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_91(txt, a_modelInfo);
end generateHeader;

public function generateMakefile
  input Tpl.Text txt;
  input String a_name;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING("all: "));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(".mo "));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_parameters.h "));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("_external_functions.c\n"));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\t"));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("mo2qsm ./"));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(".mo\n"));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\t"));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("qssmg  ./"));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE(".qsm $(QSSPATH)\n"));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\t"));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("make\n"));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\t"));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("./"));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\t"));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("echo \"set terminal wxt persist; set grid; plot \\\""));
  out_txt := Tpl.writeStr(out_txt, a_name);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("_x0.dat\\\" with lines \" | gnuplot"));
end generateMakefile;

annotation(__OpenModelica_Interface="backend");
end CodegenQSS;