encapsulated package CodegenUtil
"
  file:        CodegenUtil.mo
  package:     CodegenUtil
  description: Generated by Susan.
"

public import Tpl;

public import SimCodeVar;
public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import SCodeDump;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCodeMain;
public import HpcOmSimCode;
public import HpcOmMemory;
public import HpcOmScheduler;

public function replaceDotAndUnderscore
  input Tpl.Text in_txt;
  input String in_a_str;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_str)
    local
      Tpl.Text txt;
      String i_name;
      String ret_4;
      String ret_3;
      Tpl.Text l_str__underscores;
      String ret_1;
      Tpl.Text l_str__dots;

    case ( txt,
           i_name )
      equation
        ret_1 = System.stringReplace(i_name, ".", "_");
        l_str__dots = Tpl.writeStr(Tpl.emptyTxt, ret_1);
        ret_3 = System.stringReplace(Tpl.textString(l_str__dots), "_", "__");
        l_str__underscores = Tpl.writeStr(Tpl.emptyTxt, ret_3);
        ret_4 = System.unquoteIdentifier(Tpl.textString(l_str__underscores));
        txt = Tpl.writeStr(txt, ret_4);
      then txt;
  end match;
end replaceDotAndUnderscore;

public function underscorePath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = replaceDotAndUnderscore(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end underscorePath;

public function modelNamePrefix
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_simCode)
    local
      Tpl.Text txt;
      String i_fileNamePrefix;
      String ret_0;

    case ( txt,
           SimCode.SIMCODE(fileNamePrefix = i_fileNamePrefix) )
      equation
        ret_0 = System.stringReplace(i_fileNamePrefix, ".", "_");
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end modelNamePrefix;

public function crefStr
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        ret_0 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_0);
        txt = subscriptsStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = crefStr(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        ret_1 = System.unquoteIdentifier(i_ident);
        txt = Tpl.writeStr(txt, ret_1);
        txt = subscriptsStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("._"));
        txt = crefStr(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefStr;

public function crefStrNoUnderscore
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_a_cr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_cr)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_componentRef;
      list<DAE.Subscript> i_subscriptLst;
      DAE.Ident i_ident;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = "$DER", componentRef = i_componentRef) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("der("));
        txt = crefStrNoUnderscore(txt, i_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, subscriptLst = i_subscriptLst, componentRef = i_componentRef) )
      equation
        txt = Tpl.writeStr(txt, i_ident);
        txt = subscriptsStr(txt, i_subscriptLst);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = crefStrNoUnderscore(txt, i_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT_OR_QUAL"));
      then txt;
  end match;
end crefStrNoUnderscore;

protected function lm_40
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Subscript> rest;
      DAE.Subscript i_s;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_s :: rest )
      equation
        txt = subscriptStr(txt, i_s);
        txt = Tpl.nextIter(txt);
        txt = lm_40(txt, rest);
      then txt;
  end match;
end lm_40;

public function subscriptsStr
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_a_subscripts;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscripts)
    local
      Tpl.Text txt;
      list<DAE.Subscript> i_subscripts;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscripts )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_40(txt, i_subscripts);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end match;
end subscriptsStr;

public function subscriptStr
  input Tpl.Text in_txt;
  input DAE.Subscript in_a_subscript;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_subscript)
    local
      Tpl.Text txt;
      Absyn.Path i_n;
      Integer i_i;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.INDEX(exp = DAE.ENUM_LITERAL(name = i_n)) )
      equation
        txt = dotPath(txt, i_n);
      then txt;

    case ( txt,
           DAE.SLICE(exp = DAE.ICONST(integer = i_i)) )
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
      then txt;

    case ( txt,
           DAE.WHOLEDIM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("WHOLEDIM"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_SUBSCRIPT"));
      then txt;
  end match;
end subscriptStr;

public function escapeCComments
  input Tpl.Text txt;
  input String a_stringWithCComments;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  ret_0 := System.stringReplace(a_stringWithCComments, "/*", "(*");
  ret_1 := System.stringReplace(ret_0, "*/", "*)");
  out_txt := Tpl.writeStr(txt, ret_1);
end escapeCComments;

protected function fun_44
  input Tpl.Text in_txt;
  input Boolean in_a_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("false"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("true"));
      then txt;
  end match;
end fun_44;

public function initValXml
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;
      Integer i_index;
      Boolean i_bool;
      String i_string;
      Real i_real;
      Integer i_integer;
      Tpl.Text txt_1;
      String ret_1;
      String ret_0;

    case ( txt,
           DAE.ICONST(integer = i_integer) )
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then txt;

    case ( txt,
           DAE.RCONST(real = i_real) )
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then txt;

    case ( txt,
           DAE.SCONST(string = i_string) )
      equation
        ret_0 = Util.escapeModelicaStringToXmlString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           DAE.BCONST(bool = i_bool) )
      equation
        txt = fun_44(txt, i_bool);
      then txt;

    case ( txt,
           DAE.ENUM_LITERAL(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           i_exp )
      equation
        txt_1 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("initial value of unknown type: "));
        ret_1 = ExpressionDump.printExpStr(i_exp);
        txt_1 = Tpl.writeStr(txt_1, ret_1);
        txt = error(txt, Tpl.sourceInfo("CodegenUtil.tpl", 152, 14), Tpl.textString(txt_1));
      then txt;
  end match;
end initValXml;

public function getVariablity
  input Tpl.Text in_txt;
  input BackendDAE.VarKind in_a_varKind;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_varKind)
    local
      Tpl.Text txt;

    case ( txt,
           BackendDAE.DISCRETE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("discrete"));
      then txt;

    case ( txt,
           BackendDAE.PARAM() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parameter"));
      then txt;

    case ( txt,
           BackendDAE.CONST() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("constant"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("continuous"));
      then txt;
  end match;
end getVariablity;

public function getAliasVar
  input Tpl.Text in_txt;
  input SimCodeVar.AliasVariable in_a_aliasvar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_aliasvar)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_varName;

    case ( txt,
           SimCodeVar.NOALIAS() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"noAlias\""));
      then txt;

    case ( txt,
           SimCodeVar.ALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"alias\" aliasVariable=\""));
        txt = crefStrNoUnderscore(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           SimCodeVar.NEGATEDALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"negatedAlias\" aliasVariable=\""));
        txt = crefStrNoUnderscore(txt, i_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"noAlias\""));
      then txt;
  end match;
end getAliasVar;

protected function fun_48
  input Tpl.Text in_txt;
  input DAE.Type in_a_type__;
  input String in_a_unit;
  input String in_a_displayUnit;
  input Option<DAE.Exp> in_a_minValue;
  input Option<DAE.Exp> in_a_maxValue;
  input Option<DAE.Exp> in_a_startValue;
  input Option<DAE.Exp> in_a_nominalValue;
  input Boolean in_a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_type__, in_a_unit, in_a_displayUnit, in_a_minValue, in_a_maxValue, in_a_startValue, in_a_nominalValue, in_a_isFixed)
    local
      Tpl.Text txt;
      String a_unit;
      String a_displayUnit;
      Option<DAE.Exp> a_minValue;
      Option<DAE.Exp> a_maxValue;
      Option<DAE.Exp> a_startValue;
      Option<DAE.Exp> a_nominalValue;
      Boolean a_isFixed;
      Absyn.Path i_ci_path;
      DAE.Type i_type__;
      Tpl.Text txt_2;
      String ret_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           (i_type__ as DAE.T_INTEGER(varLst = _)),
           a_unit,
           a_displayUnit,
           a_minValue,
           a_maxValue,
           a_startValue,
           _,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Integer "));
        txt = ScalarVariableTypeStartAttribute(txt, a_startValue, i_type__);
        txt = ScalarVariableTypeFixedAttribute(txt, a_isFixed);
        txt = ScalarVariableTypeIntegerMinAttribute(txt, a_minValue);
        txt = ScalarVariableTypeIntegerMaxAttribute(txt, a_maxValue);
        txt = ScalarVariableTypeUnitAttribute(txt, a_unit);
        txt = ScalarVariableTypeDisplayUnitAttribute(txt, a_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" />"));
      then txt;

    case ( txt,
           (i_type__ as DAE.T_REAL(varLst = _)),
           a_unit,
           a_displayUnit,
           a_minValue,
           a_maxValue,
           a_startValue,
           a_nominalValue,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Real "));
        txt = ScalarVariableTypeStartAttribute(txt, a_startValue, i_type__);
        txt = ScalarVariableTypeFixedAttribute(txt, a_isFixed);
        txt = ScalarVariableTypeNominalAttribute(txt, a_nominalValue);
        txt = ScalarVariableTypeRealMinAttribute(txt, a_minValue);
        txt = ScalarVariableTypeRealMaxAttribute(txt, a_maxValue);
        txt = ScalarVariableTypeUnitAttribute(txt, a_unit);
        txt = ScalarVariableTypeDisplayUnitAttribute(txt, a_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" />"));
      then txt;

    case ( txt,
           (i_type__ as DAE.T_BOOL(varLst = _)),
           a_unit,
           a_displayUnit,
           _,
           _,
           a_startValue,
           _,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Boolean "));
        txt = ScalarVariableTypeStartAttribute(txt, a_startValue, i_type__);
        txt = ScalarVariableTypeFixedAttribute(txt, a_isFixed);
        txt = ScalarVariableTypeUnitAttribute(txt, a_unit);
        txt = ScalarVariableTypeDisplayUnitAttribute(txt, a_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" />"));
      then txt;

    case ( txt,
           (i_type__ as DAE.T_STRING(varLst = _)),
           a_unit,
           a_displayUnit,
           _,
           _,
           a_startValue,
           _,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<String "));
        txt = ScalarVariableTypeStartAttribute(txt, a_startValue, i_type__);
        txt = ScalarVariableTypeFixedAttribute(txt, a_isFixed);
        txt = ScalarVariableTypeUnitAttribute(txt, a_unit);
        txt = ScalarVariableTypeDisplayUnitAttribute(txt, a_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" />"));
      then txt;

    case ( txt,
           (i_type__ as DAE.T_ENUMERATION(index = _)),
           a_unit,
           a_displayUnit,
           _,
           _,
           a_startValue,
           _,
           a_isFixed )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<Integer "));
        txt = ScalarVariableTypeStartAttribute(txt, a_startValue, i_type__);
        txt = ScalarVariableTypeFixedAttribute(txt, a_isFixed);
        txt = ScalarVariableTypeUnitAttribute(txt, a_unit);
        txt = ScalarVariableTypeDisplayUnitAttribute(txt, a_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" />"));
      then txt;

    case ( txt,
           DAE.T_COMPLEX(complexClassType = ClassInf.EXTERNAL_OBJ(path = i_ci_path)),
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<ExternalObject path=\""));
        txt_0 = dotPath(Tpl.emptyTxt, i_ci_path);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
      then txt;

    case ( txt,
           i_type__,
           _,
           _,
           _,
           _,
           _,
           _,
           _ )
      equation
        txt_2 = Tpl.writeTok(Tpl.emptyTxt, Tpl.ST_STRING("ScalarVariableType: "));
        ret_2 = Types.unparseType(i_type__);
        txt_2 = Tpl.writeStr(txt_2, ret_2);
        txt = error(txt, Tpl.sourceInfo("CodegenUtil.tpl", 191, 16), Tpl.textString(txt_2));
      then txt;
  end match;
end fun_48;

public function ScalarVariableType
  input Tpl.Text txt;
  input String a_unit;
  input String a_displayUnit;
  input Option<DAE.Exp> a_minValue;
  input Option<DAE.Exp> a_maxValue;
  input Option<DAE.Exp> a_startValue;
  input Option<DAE.Exp> a_nominalValue;
  input Boolean a_isFixed;
  input DAE.Type a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_48(txt, a_type__, a_unit, a_displayUnit, a_minValue, a_maxValue, a_startValue, a_nominalValue, a_isFixed);
end ScalarVariableType;

public function StartString
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.ICONST(integer = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.RCONST(real = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.SCONST(string = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.BCONST(bool = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.ENUM_LITERAL(name = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("start=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end StartString;

protected function fun_51
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_startValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_startValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("useStart=\"true\""));
        txt = StartString(txt, i_exp);
      then txt;

    case ( txt,
           NONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("useStart=\"false\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_51;

public function ScalarVariableTypeStartAttribute
  input Tpl.Text txt;
  input Option<DAE.Exp> a_startValue;
  input DAE.Type a_type__;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_51(txt, a_startValue);
end ScalarVariableTypeStartAttribute;

public function ScalarVariableTypeFixedAttribute
  input Tpl.Text txt;
  input Boolean a_isFixed;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("fixed=\""));
  out_txt := Tpl.writeStr(out_txt, Tpl.booleanString(a_isFixed));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.popBlock(out_txt);
end ScalarVariableTypeFixedAttribute;

public function NominalString
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.ICONST(integer = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nominal=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.RCONST(real = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nominal=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.SCONST(string = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nominal=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.BCONST(bool = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("nominal=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end NominalString;

public function ScalarVariableTypeNominalAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_nominalValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_nominalValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("useNominal=\"true\""));
        txt = NominalString(txt, i_exp);
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           NONE() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" useNominal=\"false\""));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableTypeNominalAttribute;

public function ScalarVariableTypeUnitAttribute
  input Tpl.Text in_txt;
  input String in_a_unit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_unit)
    local
      Tpl.Text txt;
      String i_unit;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_unit )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unit=\""));
        txt = Tpl.writeStr(txt, i_unit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end ScalarVariableTypeUnitAttribute;

public function ScalarVariableTypeDisplayUnitAttribute
  input Tpl.Text in_txt;
  input String in_a_displayUnit;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_displayUnit)
    local
      Tpl.Text txt;
      String i_displayUnit;

    case ( txt,
           "" )
      then txt;

    case ( txt,
           i_displayUnit )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("displayUnit=\""));
        txt = Tpl.writeStr(txt, i_displayUnit);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;
  end match;
end ScalarVariableTypeDisplayUnitAttribute;

public function MinString
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.ICONST(integer = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.RCONST(real = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.SCONST(string = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.BCONST(bool = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.ENUM_LITERAL(name = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("min=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end MinString;

public function ScalarVariableTypeIntegerMinAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_minValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_minValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = MinString(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableTypeIntegerMinAttribute;

public function MaxString
  input Tpl.Text in_txt;
  input DAE.Exp in_a_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_exp)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           (i_exp as DAE.ICONST(integer = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("max=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.RCONST(real = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("max=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.SCONST(string = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("max=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.BCONST(bool = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("max=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           (i_exp as DAE.ENUM_LITERAL(name = _)) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("max=\""));
        txt = initValXml(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end MaxString;

public function ScalarVariableTypeIntegerMaxAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_maxValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_maxValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = MaxString(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableTypeIntegerMaxAttribute;

public function ScalarVariableTypeRealMinAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_minValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_minValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = MinString(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableTypeRealMinAttribute;

public function ScalarVariableTypeRealMaxAttribute
  input Tpl.Text in_txt;
  input Option<DAE.Exp> in_a_maxValue;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_maxValue)
    local
      Tpl.Text txt;
      DAE.Exp i_exp;

    case ( txt,
           SOME(i_exp) )
      equation
        txt = MaxString(txt, i_exp);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end ScalarVariableTypeRealMaxAttribute;

public function equationIndex
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      Integer i_index;

    case ( txt,
           SimCode.SES_RESIDUAL(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_IFEQUATION(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_MIXED(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_WHEN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end equationIndex;

protected function lm_65
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_stmt;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_stmt :: rest )
      equation
        ret_0 = DAEDump.ppStmtStr(i_stmt, 2);
        txt = escapeCComments(txt, ret_0);
        txt = lm_65(txt, rest);
      then txt;
  end match;
end lm_65;

protected function lm_66
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<var>"));
        txt = crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</var>"));
        txt = Tpl.nextIter(txt);
        txt = lm_66(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_66(txt, rest);
      then txt;
  end match;
end lm_66;

protected function lm_67
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cell>"));
        ret_0 = ExpressionDump.printExpStr(i_exp);
        txt = escapeCComments(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cell>"));
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest);
      then txt;
  end match;
end lm_67;

protected function fun_68
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      DAE.Exp i_e_exp;
      String ret_0;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_e_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<residual>"));
        ret_0 = ExpressionDump.printExpStr(i_e_exp);
        txt = escapeCComments(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</residual>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_68;

protected function lm_69
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      SimCode.SimEqSystem i_eq;
      Integer i_i2;
      Integer i_i1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_i1, i_i2, i_eq) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cell row=\""));
        txt = Tpl.writeStr(txt, intString(i_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" col=\""));
        txt = Tpl.writeStr(txt, intString(i_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fun_68(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cell>"));
        txt = lm_69(txt, rest);
      then txt;
  end match;
end lm_69;

protected function lm_70
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = crefStr(txt, i_cr);
        txt = Tpl.nextIter(txt);
        txt = lm_70(txt, rest);
      then txt;
  end match;
end lm_70;

protected function lm_71
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = equationIndex(txt, i_eq);
        txt = Tpl.nextIter(txt);
        txt = lm_71(txt, rest);
      then txt;
  end match;
end lm_71;

protected function lm_72
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<var>"));
        txt = crefStr(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</var>"));
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_72(txt, rest);
      then txt;
  end match;
end lm_72;

protected function lm_73
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<discrete index=\""));
        txt = equationIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = lm_73(txt, rest);
      then txt;
  end match;
end lm_73;

protected function lm_74
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cond;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cond :: rest )
      equation
        txt = crefStr(txt, i_cond);
        txt = Tpl.nextIter(txt);
        txt = lm_74(txt, rest);
      then txt;
  end match;
end lm_74;

protected function lm_75
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> rest;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (_, i_eqs) :: rest )
      equation
        txt = dumpEqs(txt, i_eqs);
        txt = lm_75(txt, rest);
      then txt;
  end match;
end lm_75;

protected function fun_76
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_elsebranch;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> i_ifbranches;
      DAE.Exp i_e_right;
      DAE.ComponentRef i_e_left;
      list<DAE.ComponentRef> i_conditions;
      list<SimCodeVar.SimVar> i_e_discVars;
      list<SimCode.SimEqSystem> i_e_discEqs;
      SimCode.SimEqSystem i_e_cont;
      list<SimCode.SimEqSystem> i_e_eqs;
      list<DAE.ComponentRef> i_e_crefs;
      Integer i_indexNonLinearSystem;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<DAE.Exp> i_beqs;
      list<SimCodeVar.SimVar> i_e_vars;
      list<DAE.Statement> i_e_statements;
      DAE.ComponentRef i_e_componentRef;
      DAE.ComponentRef i_e_cref;
      DAE.Exp i_e_exp;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_elsebr;
      Tpl.Text l_branches;
      String ret_4;
      list<SimCode.SimEqSystem> ret_3;
      String ret_2;
      String ret_1;
      String ret_0;

    case ( txt,
           (i_e as SimCode.SES_RESIDUAL(exp = i_e_exp)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: RESIDUAL\n",
                                    "\n"
                                }, true));
        ret_0 = ExpressionDump.printExpStr(i_e_exp);
        txt = escapeCComments(txt, ret_0);
      then txt;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = i_e_cref, exp = i_e_exp)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("type: SIMPLE_ASSIGN\n"));
        txt = crefStr(txt, i_e_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        ret_1 = ExpressionDump.printExpStr(i_e_exp);
        txt = escapeCComments(txt, ret_1);
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = i_e_componentRef, exp = i_e_exp)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: ARRAY_CALL_ASSIGN\n",
                                    "\n"
                                }, true));
        txt = crefStr(txt, i_e_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        ret_2 = ExpressionDump.printExpStr(i_e_exp);
        txt = escapeCComments(txt, ret_2);
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("empty algorithm"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = (i_e_statements as _ :: _))) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: ALGORITHM\n",
                                    "\n"
                                }, true));
        txt = lm_65(txt, i_e_statements);
      then txt;

    case ( txt,
           (i_e as SimCode.SES_LINEAR(vars = i_e_vars, beqs = i_beqs, simJac = i_simJac)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: LINEAR\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_66(txt, i_e_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<row>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_67(txt, i_beqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</row>\n",
                                    "<matrix>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = lm_69(txt, i_simJac);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</matrix>"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(indexNonLinearSystem = i_indexNonLinearSystem, crefs = i_e_crefs, eqs = i_e_eqs)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("indexNonlinear: "));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: NONLINEAR\n",
                                    "\n",
                                    "vars: {"
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_70(txt, i_e_crefs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "eqns: {"
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_71(txt, i_e_eqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_MIXED(cont = i_e_cont, discEqs = i_e_discEqs, discVars = i_e_discVars)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: MIXED\n",
                                    "\n"
                                }, true));
        ret_3 = List.fill(i_e_cont, 1);
        txt = dumpEqs(txt, ret_3);
        txt = Tpl.softNewLine(txt);
        txt = dumpEqs(txt, i_e_discEqs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "\n",
                                    "<mixed>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<continuous index=\""));
        txt = equationIndex(txt, i_e_cont);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_72(txt, i_e_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = lm_73(txt, i_e_discEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</mixed>"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_WHEN(conditions = i_conditions, left = i_e_left, right = i_e_right)) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: WHEN\n",
                                    "\n",
                                    "when {"
                                }, false));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_74(txt, i_conditions);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("} then\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = crefStr(txt, i_e_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        ret_4 = ExpressionDump.printExpStr(i_e_right);
        txt = escapeCComments(txt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("end when;"));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_IFEQUATION(ifbranches = i_ifbranches, elsebranch = i_elsebranch)) )
      equation
        l_branches = lm_75(Tpl.emptyTxt, i_ifbranches);
        l_elsebr = dumpEqs(Tpl.emptyTxt, i_elsebranch);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation index: "));
        txt = equationIndex(txt, i_e);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "type: IFEQUATION\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_branches);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_elsebr);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("unknown equation"));
      then txt;
  end match;
end fun_76;

protected function lm_77
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = fun_76(txt, i_eq);
        txt = lm_77(txt, rest);
      then txt;
  end match;
end lm_77;

public function dumpEqs
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_eqs;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_77(txt, a_eqs);
end dumpEqs;

public function dotPath
  input Tpl.Text in_txt;
  input Absyn.Path in_a_path;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_path)
    local
      Tpl.Text txt;
      String i_name_1;
      Absyn.Path i_path;
      Absyn.Ident i_name;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name_1) )
      equation
        txt = Tpl.writeStr(txt, i_name_1);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      equation
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dotPath;

public function error
  input Tpl.Text txt;
  input Absyn.Info a_srcInfo;
  input String a_errMessage;

  output Tpl.Text out_txt;
protected
  String ret_0;
algorithm
  Tpl.addSourceTemplateError(a_errMessage, a_srcInfo);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "#error \""
                               }, false));
  ret_0 := Error.infoStr(a_srcInfo);
  out_txt := Tpl.writeStr(out_txt, ret_0);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeStr(out_txt, a_errMessage);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end error;

public function errorMsg
  input Tpl.Text txt;
  input String a_errMessage;

  output Tpl.Text out_txt;
algorithm
  Tpl.addTemplateError(a_errMessage);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "\n",
                                   "#error \""
                               }, false));
  out_txt := Tpl.writeStr(out_txt, a_errMessage);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("\""));
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end errorMsg;

annotation(__OpenModelica_Interface="backend");
end CodegenUtil;