encapsulated package GraphvizDump
"
  file:        GraphvizDump.mo
  package:     GraphvizDump
  description: Generated by Susan.
"

public import Tpl;

public import ExpressionDump;
public import BackendDAE;
public import BackendVariable;
public import BackendEquation;
public import BackendDump;
public import DAE;
public import CodegenUtil;

public function dumpBackendDAE
  input Tpl.Text in_txt;
  input BackendDAE.BackendDAE in_a_backendDAE;
  input String in_a_suffix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_backendDAE, in_a_suffix)
    local
      Tpl.Text txt;
      String a_suffix;
      String i_info_fileNamePrefix;
      BackendDAE.BackendDAE i_dae;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text l_0___1;
      Tpl.Text l_0__;

    case ( txt,
           (i_dae as BackendDAE.DAE(shared = BackendDAE.SHARED(info = BackendDAE.EXTRA_INFO(fileNamePrefix = i_info_fileNamePrefix)))),
           a_suffix )
      equation
        l_0__ = dumpIncidenceMatrix(Tpl.emptyTxt, i_dae, a_suffix);
        txt_2 = dumpMatching(Tpl.emptyTxt, i_dae, a_suffix);
        txt_3 = Tpl.writeStr(Tpl.emptyTxt, i_info_fileNamePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("_"));
        txt_3 = Tpl.writeStr(txt_3, a_suffix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("_matching.dot"));
        Tpl.textFile(txt_2, Tpl.textString(txt_3));
        l_0___1 = Tpl.emptyTxt;
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpBackendDAE;

public function dumpIncidenceMatrix
  input Tpl.Text in_txt;
  input BackendDAE.BackendDAE in_a_backendDAE;
  input String in_a_suffix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_backendDAE, in_a_suffix)
    local
      Tpl.Text txt;
      String a_suffix;
      String i_info_fileNamePrefix;
      BackendDAE.BackendDAE i_dae;
      Tpl.Text txt_2;
      Tpl.Text txt_1;
      Tpl.Text l_0__;

    case ( txt,
           (i_dae as BackendDAE.DAE(shared = BackendDAE.SHARED(info = BackendDAE.EXTRA_INFO(fileNamePrefix = i_info_fileNamePrefix)))),
           a_suffix )
      equation
        txt_1 = dumpDependence(Tpl.emptyTxt, i_dae, a_suffix);
        txt_2 = Tpl.writeStr(Tpl.emptyTxt, i_info_fileNamePrefix);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_STRING("_"));
        txt_2 = Tpl.writeStr(txt_2, a_suffix);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_STRING("_dependence.dot"));
        Tpl.textFile(txt_1, Tpl.textString(txt_2));
        l_0__ = Tpl.emptyTxt;
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpIncidenceMatrix;

protected function fun_11
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_var_varName;
  input Integer in_a_varID;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_var_varName, in_a_varID, in_a_clusterID)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_varName;
      Integer a_varID;
      Integer a_clusterID;

    case ( txt,
           false,
           a_var_varName,
           a_varID,
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [label=\""));
        txt = CodegenUtil.crefStr(txt, a_var_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", shape=\"box\"]"));
      then txt;

    case ( txt,
           _,
           a_var_varName,
           a_varID,
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [label=\"der("));
        txt = CodegenUtil.crefStr(txt, a_var_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")\", shape=\"box\"]"));
      then txt;
  end match;
end fun_11;

protected function lm_12
  input Tpl.Text in_txt;
  input list<BackendDAE.Var> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> rest;
      Integer a_clusterID;
      Integer x_varID;
      DAE.ComponentRef i_var_varName;
      BackendDAE.Var i_var;
      Boolean ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as BackendDAE.VAR(varName = i_var_varName)) :: rest,
           a_clusterID )
      equation
        x_varID = Tpl.getIteri_i0(txt);
        ret_0 = BackendVariable.isStateVar(i_var);
        txt = fun_11(txt, ret_0, i_var_varName, x_varID, a_clusterID);
        txt = Tpl.nextIter(txt);
        txt = lm_12(txt, rest, a_clusterID);
      then txt;

    case ( txt,
           _ :: rest,
           a_clusterID )
      equation
        txt = lm_12(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_12;

protected function lm_13
  input Tpl.Text in_txt;
  input list<BackendDAE.Equation> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<BackendDAE.Equation> rest;
      Integer a_clusterID;
      Integer x_eqID;
      BackendDAE.Equation i_eq;
      String ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_clusterID )
      equation
        x_eqID = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("eq"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_eqID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [label=\""));
        ret_0 = BackendDump.equationString(i_eq);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", shape=\"box\"]"));
        txt = Tpl.nextIter(txt);
        txt = lm_13(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_13;

protected function lm_14
  input Tpl.Text in_txt;
  input BackendDAE.EqSystems in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      BackendDAE.EqSystems rest;
      Integer x_clusterID;
      Option<BackendDAE.IncidenceMatrix> i_eqSystem_m;
      BackendDAE.EquationArray i_eqSystem_orderedEqs;
      BackendDAE.Variables i_eqSystem_orderedVars;
      list<BackendDAE.Equation> ret_3;
      Tpl.Text l_eqDeclaration;
      list<BackendDAE.Var> ret_1;
      Tpl.Text l_varDeclaration;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.EQSYSTEM(orderedVars = i_eqSystem_orderedVars, orderedEqs = i_eqSystem_orderedEqs, m = i_eqSystem_m) :: rest )
      equation
        x_clusterID = Tpl.getIteri_i0(txt);
        ret_1 = BackendVariable.varList(i_eqSystem_orderedVars);
        l_varDeclaration = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_varDeclaration = lm_12(l_varDeclaration, ret_1, x_clusterID);
        l_varDeclaration = Tpl.popIter(l_varDeclaration);
        ret_3 = BackendEquation.equationList(i_eqSystem_orderedEqs);
        l_eqDeclaration = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eqDeclaration = lm_13(l_eqDeclaration, ret_3, x_clusterID);
        l_eqDeclaration = Tpl.popIter(l_eqDeclaration);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("subgraph cluster_"));
        txt = Tpl.writeStr(txt, intString(x_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("label = \"system #"));
        txt = Tpl.writeStr(txt, intString(x_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "color=white\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varDeclaration);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_eqDeclaration);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = dumpDependence2(txt, x_clusterID, i_eqSystem_m);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_14(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_14(txt, rest);
      then txt;
  end match;
end lm_14;

public function dumpDependence
  input Tpl.Text in_txt;
  input BackendDAE.BackendDAE in_a_backendDAE;
  input String in_a_suffix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_backendDAE, in_a_suffix)
    local
      Tpl.Text txt;
      String a_suffix;
      String i_info_fileNamePrefix;
      BackendDAE.EqSystems i_eqs;
      Tpl.Text l_systems;

    case ( txt,
           BackendDAE.DAE(eqs = i_eqs, shared = BackendDAE.SHARED(info = BackendDAE.EXTRA_INFO(fileNamePrefix = i_info_fileNamePrefix))),
           a_suffix )
      equation
        l_systems = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                    "\n",
                                                                                    "\n"
                                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_systems = lm_14(l_systems, i_eqs);
        l_systems = Tpl.popIter(l_systems);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("digraph G {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("label=\""));
        txt = Tpl.writeStr(txt, i_info_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ["));
        txt = Tpl.writeStr(txt, a_suffix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " - dependence]\";\n",
                                    "rankdir=LR;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_systems);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpDependence;

protected function fun_16
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eqID;
  input BackendDAE.IncidenceMatrixElementEntry in_a_varID;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eqID, in_a_varID, in_a_clusterID)
    local
      Tpl.Text txt;
      Integer a_eqID;
      BackendDAE.IncidenceMatrixElementEntry a_varID;
      Integer a_clusterID;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eqID,
           a_varID,
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -> eq"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_eqID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [style=\"dashed\", arrowhead=\"none\"];"));
      then txt;
  end match;
end fun_16;

protected function lm_17
  input Tpl.Text in_txt;
  input list<BackendDAE.IncidenceMatrixElementEntry> in_items;
  input Integer in_a_eqID;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_eqID, in_a_clusterID)
    local
      Tpl.Text txt;
      list<BackendDAE.IncidenceMatrixElementEntry> rest;
      Integer a_eqID;
      Integer a_clusterID;
      BackendDAE.IncidenceMatrixElementEntry i_varID;
      Boolean ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_varID :: rest,
           a_eqID,
           a_clusterID )
      equation
        ret_0 = intGt(i_varID, 0);
        txt = fun_16(txt, ret_0, a_eqID, i_varID, a_clusterID);
        txt = Tpl.nextIter(txt);
        txt = lm_17(txt, rest, a_eqID, a_clusterID);
      then txt;
  end match;
end lm_17;

protected function lm_18
  input Tpl.Text in_txt;
  input list<list<BackendDAE.IncidenceMatrixElementEntry>> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<list<BackendDAE.IncidenceMatrixElementEntry>> rest;
      Integer a_clusterID;
      Integer x_eqID;
      list<BackendDAE.IncidenceMatrixElementEntry> i_varList;
      Tpl.Text l_foo;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_varList :: rest,
           a_clusterID )
      equation
        x_eqID = Tpl.getIteri_i0(txt);
        l_foo = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_foo = lm_17(l_foo, i_varList, x_eqID, a_clusterID);
        l_foo = Tpl.popIter(l_foo);
        txt = Tpl.writeText(txt, l_foo);
        txt = Tpl.nextIter(txt);
        txt = lm_18(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_18;

protected function fun_19
  input Tpl.Text in_txt;
  input Option<BackendDAE.IncidenceMatrix> in_a_m;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_m, in_a_clusterID)
    local
      Tpl.Text txt;
      Integer a_clusterID;
      BackendDAE.IncidenceMatrix i_incMatrix;
      list<list<BackendDAE.IncidenceMatrixElementEntry>> ret_1;
      Tpl.Text l_incNodes;

    case ( txt,
           SOME(i_incMatrix),
           a_clusterID )
      equation
        ret_1 = arrayList(i_incMatrix);
        l_incNodes = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_incNodes = lm_18(l_incNodes, ret_1, a_clusterID);
        l_incNodes = Tpl.popIter(l_incNodes);
        txt = Tpl.writeText(txt, l_incNodes);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// no incidence matrix"));
      then txt;
  end match;
end fun_19;

public function dumpDependence2
  input Tpl.Text txt;
  input Integer a_clusterID;
  input Option<BackendDAE.IncidenceMatrix> a_m;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_19(txt, a_m, a_clusterID);
end dumpDependence2;

protected function fun_21
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input DAE.ComponentRef in_a_var_varName;
  input Integer in_a_varID;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_var_varName, in_a_varID, in_a_clusterID)
    local
      Tpl.Text txt;
      DAE.ComponentRef a_var_varName;
      Integer a_varID;
      Integer a_clusterID;

    case ( txt,
           false,
           a_var_varName,
           a_varID,
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [label=\""));
        txt = CodegenUtil.crefStr(txt, a_var_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", shape=\"box\"]"));
      then txt;

    case ( txt,
           _,
           a_var_varName,
           a_varID,
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [label=\"der("));
        txt = CodegenUtil.crefStr(txt, a_var_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")\", shape=\"box\"]"));
      then txt;
  end match;
end fun_21;

protected function lm_22
  input Tpl.Text in_txt;
  input list<BackendDAE.Var> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> rest;
      Integer a_clusterID;
      Integer x_varID;
      DAE.ComponentRef i_var_varName;
      BackendDAE.Var i_var;
      Boolean ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_var as BackendDAE.VAR(varName = i_var_varName)) :: rest,
           a_clusterID )
      equation
        x_varID = Tpl.getIteri_i0(txt);
        ret_0 = BackendVariable.isStateVar(i_var);
        txt = fun_21(txt, ret_0, i_var_varName, x_varID, a_clusterID);
        txt = Tpl.nextIter(txt);
        txt = lm_22(txt, rest, a_clusterID);
      then txt;

    case ( txt,
           _ :: rest,
           a_clusterID )
      equation
        txt = lm_22(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_22;

protected function lm_23
  input Tpl.Text in_txt;
  input list<BackendDAE.Equation> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<BackendDAE.Equation> rest;
      Integer a_clusterID;
      Integer x_eqID;
      BackendDAE.Equation i_eq;
      String ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_clusterID )
      equation
        x_eqID = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("eq"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_eqID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [label=\""));
        ret_0 = BackendDump.equationString(i_eq);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", shape=\"box\"]"));
        txt = Tpl.nextIter(txt);
        txt = lm_23(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_23;

protected function lm_24
  input Tpl.Text in_txt;
  input BackendDAE.EqSystems in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      BackendDAE.EqSystems rest;
      Integer x_clusterID;
      Option<BackendDAE.IncidenceMatrix> i_eqSystem_m;
      BackendDAE.Matching i_eqSystem_matching;
      BackendDAE.EquationArray i_eqSystem_orderedEqs;
      BackendDAE.Variables i_eqSystem_orderedVars;
      list<BackendDAE.Equation> ret_3;
      Tpl.Text l_eqDeclaration;
      list<BackendDAE.Var> ret_1;
      Tpl.Text l_varDeclaration;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.EQSYSTEM(orderedVars = i_eqSystem_orderedVars, orderedEqs = i_eqSystem_orderedEqs, matching = i_eqSystem_matching, m = i_eqSystem_m) :: rest )
      equation
        x_clusterID = Tpl.getIteri_i0(txt);
        ret_1 = BackendVariable.varList(i_eqSystem_orderedVars);
        l_varDeclaration = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_varDeclaration = lm_22(l_varDeclaration, ret_1, x_clusterID);
        l_varDeclaration = Tpl.popIter(l_varDeclaration);
        ret_3 = BackendEquation.equationList(i_eqSystem_orderedEqs);
        l_eqDeclaration = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eqDeclaration = lm_23(l_eqDeclaration, ret_3, x_clusterID);
        l_eqDeclaration = Tpl.popIter(l_eqDeclaration);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("subgraph cluster_"));
        txt = Tpl.writeStr(txt, intString(x_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("label = \"system #"));
        txt = Tpl.writeStr(txt, intString(x_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "color=white\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varDeclaration);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, l_eqDeclaration);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = connections(txt, x_clusterID, i_eqSystem_matching, i_eqSystem_m);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_24(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_24(txt, rest);
      then txt;
  end match;
end lm_24;

public function dumpMatching
  input Tpl.Text in_txt;
  input BackendDAE.BackendDAE in_a_backendDAE;
  input String in_a_suffix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_backendDAE, in_a_suffix)
    local
      Tpl.Text txt;
      String a_suffix;
      String i_info_fileNamePrefix;
      BackendDAE.EqSystems i_eqs;
      Tpl.Text l_systems;

    case ( txt,
           BackendDAE.DAE(eqs = i_eqs, shared = BackendDAE.SHARED(info = BackendDAE.EXTRA_INFO(fileNamePrefix = i_info_fileNamePrefix))),
           a_suffix )
      equation
        l_systems = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                    "\n",
                                                                                    "\n"
                                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_systems = lm_24(l_systems, i_eqs);
        l_systems = Tpl.popIter(l_systems);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("digraph G {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("label=\""));
        txt = Tpl.writeStr(txt, i_info_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ["));
        txt = Tpl.writeStr(txt, a_suffix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " - matching]\";\n",
                                    "rankdir=LR;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_systems);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpMatching;

protected function fun_26
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eqID;
  input BackendDAE.IncidenceMatrixElementEntry in_a_varID;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eqID, in_a_varID, in_a_clusterID)
    local
      Tpl.Text txt;
      Integer a_eqID;
      BackendDAE.IncidenceMatrixElementEntry a_varID;
      Integer a_clusterID;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eqID,
           a_varID,
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -> eq"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_eqID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [style=\"dashed\", arrowhead=\"none\"];"));
      then txt;
  end match;
end fun_26;

protected function fun_27
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eqID;
  input Integer in_a_clusterID;
  input BackendDAE.IncidenceMatrixElementEntry in_a_varID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eqID, in_a_clusterID, in_a_varID)
    local
      Tpl.Text txt;
      Integer a_eqID;
      Integer a_clusterID;
      BackendDAE.IncidenceMatrixElementEntry a_varID;
      Boolean ret_0;

    case ( txt,
           false,
           a_eqID,
           a_clusterID,
           a_varID )
      equation
        ret_0 = intGt(a_varID, 0);
        txt = fun_26(txt, ret_0, a_eqID, a_varID, a_clusterID);
      then txt;

    case ( txt,
           _,
           a_eqID,
           a_clusterID,
           a_varID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -> eq"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_eqID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [style=\"bold\", arrowhead=\"none\"];"));
      then txt;
  end match;
end fun_27;

protected function lm_28
  input Tpl.Text in_txt;
  input list<BackendDAE.IncidenceMatrixElementEntry> in_items;
  input Integer in_a_clusterID;
  input Integer in_a_eqID;
  input array<Integer> in_a_ass2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID, in_a_eqID, in_a_ass2)
    local
      Tpl.Text txt;
      list<BackendDAE.IncidenceMatrixElementEntry> rest;
      Integer a_clusterID;
      Integer a_eqID;
      array<Integer> a_ass2;
      BackendDAE.IncidenceMatrixElementEntry i_varID;
      Boolean ret_2;
      Integer ret_1;
      list<Integer> ret_0;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           i_varID :: rest,
           a_clusterID,
           a_eqID,
           a_ass2 )
      equation
        ret_0 = arrayList(a_ass2);
        ret_1 = listGet(ret_0, a_eqID);
        ret_2 = intEq(ret_1, i_varID);
        txt = fun_27(txt, ret_2, a_eqID, a_clusterID, i_varID);
        txt = Tpl.nextIter(txt);
        txt = lm_28(txt, rest, a_clusterID, a_eqID, a_ass2);
      then txt;
  end match;
end lm_28;

protected function lm_29
  input Tpl.Text in_txt;
  input list<list<BackendDAE.IncidenceMatrixElementEntry>> in_items;
  input Integer in_a_clusterID;
  input array<Integer> in_a_ass2;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID, in_a_ass2)
    local
      Tpl.Text txt;
      list<list<BackendDAE.IncidenceMatrixElementEntry>> rest;
      Integer a_clusterID;
      array<Integer> a_ass2;
      Integer x_eqID;
      list<BackendDAE.IncidenceMatrixElementEntry> i_varList;
      Tpl.Text l_foo;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_varList :: rest,
           a_clusterID,
           a_ass2 )
      equation
        x_eqID = Tpl.getIteri_i0(txt);
        l_foo = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_foo = lm_28(l_foo, i_varList, a_clusterID, x_eqID, a_ass2);
        l_foo = Tpl.popIter(l_foo);
        txt = Tpl.writeText(txt, l_foo);
        txt = Tpl.nextIter(txt);
        txt = lm_29(txt, rest, a_clusterID, a_ass2);
      then txt;
  end match;
end lm_29;

protected function fun_30
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eqID;
  input BackendDAE.IncidenceMatrixElementEntry in_a_varID;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eqID, in_a_varID, in_a_clusterID)
    local
      Tpl.Text txt;
      Integer a_eqID;
      BackendDAE.IncidenceMatrixElementEntry a_varID;
      Integer a_clusterID;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eqID,
           a_varID,
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -> eq"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_eqID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [style=\"dashed\", arrowhead=\"none\"];"));
      then txt;
  end match;
end fun_30;

protected function lm_31
  input Tpl.Text in_txt;
  input list<BackendDAE.IncidenceMatrixElementEntry> in_items;
  input Integer in_a_eqID;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_eqID, in_a_clusterID)
    local
      Tpl.Text txt;
      list<BackendDAE.IncidenceMatrixElementEntry> rest;
      Integer a_eqID;
      Integer a_clusterID;
      BackendDAE.IncidenceMatrixElementEntry i_varID;
      Boolean ret_0;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_varID :: rest,
           a_eqID,
           a_clusterID )
      equation
        ret_0 = intGt(i_varID, 0);
        txt = fun_30(txt, ret_0, a_eqID, i_varID, a_clusterID);
        txt = Tpl.nextIter(txt);
        txt = lm_31(txt, rest, a_eqID, a_clusterID);
      then txt;
  end match;
end lm_31;

protected function lm_32
  input Tpl.Text in_txt;
  input list<list<BackendDAE.IncidenceMatrixElementEntry>> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<list<BackendDAE.IncidenceMatrixElementEntry>> rest;
      Integer a_clusterID;
      Integer x_eqID;
      list<BackendDAE.IncidenceMatrixElementEntry> i_varList;
      Tpl.Text l_foo;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_varList :: rest,
           a_clusterID )
      equation
        x_eqID = Tpl.getIteri_i0(txt);
        l_foo = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_foo = lm_31(l_foo, i_varList, x_eqID, a_clusterID);
        l_foo = Tpl.popIter(l_foo);
        txt = Tpl.writeText(txt, l_foo);
        txt = Tpl.nextIter(txt);
        txt = lm_32(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_32;

protected function fun_33
  input Tpl.Text in_txt;
  input BackendDAE.Matching in_a_matching;
  input Integer in_a_clusterID;
  input BackendDAE.IncidenceMatrix in_a_incMatrix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_matching, in_a_clusterID, in_a_incMatrix)
    local
      Tpl.Text txt;
      Integer a_clusterID;
      BackendDAE.IncidenceMatrix a_incMatrix;
      array<Integer> i_ass2;
      list<list<BackendDAE.IncidenceMatrixElementEntry>> ret_2;
      list<list<BackendDAE.IncidenceMatrixElementEntry>> ret_1;
      Tpl.Text l_incNodes;

    case ( txt,
           BackendDAE.MATCHING(ass2 = i_ass2),
           a_clusterID,
           a_incMatrix )
      equation
        ret_1 = arrayList(a_incMatrix);
        l_incNodes = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_incNodes = lm_29(l_incNodes, ret_1, a_clusterID, i_ass2);
        l_incNodes = Tpl.popIter(l_incNodes);
        txt = Tpl.writeText(txt, l_incNodes);
      then txt;

    case ( txt,
           _,
           a_clusterID,
           a_incMatrix )
      equation
        ret_2 = arrayList(a_incMatrix);
        l_incNodes = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_incNodes = lm_32(l_incNodes, ret_2, a_clusterID);
        l_incNodes = Tpl.popIter(l_incNodes);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("// no matching\n"));
        txt = Tpl.writeText(txt, l_incNodes);
      then txt;
  end match;
end fun_33;

protected function fun_34
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_eqID;
  input Integer in_a_varID;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_eqID, in_a_varID, in_a_clusterID)
    local
      Tpl.Text txt;
      Integer a_eqID;
      Integer a_varID;
      Integer a_clusterID;

    case ( txt,
           false,
           _,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_eqID,
           a_varID,
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" -> eq"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(a_eqID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [style=\"bold\", arrowhead=\"none\"];"));
      then txt;
  end match;
end fun_34;

protected function lm_35
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer a_clusterID;
      Integer x_eqID;
      Integer i_varID;
      Boolean ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_varID :: rest,
           a_clusterID )
      equation
        x_eqID = Tpl.getIteri_i0(txt);
        ret_0 = intGt(i_varID, 0);
        txt = fun_34(txt, ret_0, x_eqID, i_varID, a_clusterID);
        txt = Tpl.nextIter(txt);
        txt = lm_35(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_35;

protected function fun_36
  input Tpl.Text in_txt;
  input BackendDAE.Matching in_a_matching;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_matching, in_a_clusterID)
    local
      Tpl.Text txt;
      Integer a_clusterID;
      array<Integer> i_ass2;
      list<Integer> ret_1;
      Tpl.Text l_matchedNodes;

    case ( txt,
           BackendDAE.MATCHING(ass2 = i_ass2),
           a_clusterID )
      equation
        ret_1 = arrayList(i_ass2);
        l_matchedNodes = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_matchedNodes = lm_35(l_matchedNodes, ret_1, a_clusterID);
        l_matchedNodes = Tpl.popIter(l_matchedNodes);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("// no incidence matrix\n"));
        txt = Tpl.writeText(txt, l_matchedNodes);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "// no incidence matrix\n",
                                    "// no matching"
                                }, false));
      then txt;
  end match;
end fun_36;

protected function fun_37
  input Tpl.Text in_txt;
  input Option<BackendDAE.IncidenceMatrix> in_a_m;
  input Integer in_a_clusterID;
  input BackendDAE.Matching in_a_matching;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_m, in_a_clusterID, in_a_matching)
    local
      Tpl.Text txt;
      Integer a_clusterID;
      BackendDAE.Matching a_matching;
      BackendDAE.IncidenceMatrix i_incMatrix;

    case ( txt,
           SOME(i_incMatrix),
           a_clusterID,
           a_matching )
      equation
        txt = fun_33(txt, a_matching, a_clusterID, i_incMatrix);
      then txt;

    case ( txt,
           _,
           a_clusterID,
           a_matching )
      equation
        txt = fun_36(txt, a_matching, a_clusterID);
      then txt;
  end match;
end fun_37;

public function connections
  input Tpl.Text txt;
  input Integer a_clusterID;
  input BackendDAE.Matching a_matching;
  input Option<BackendDAE.IncidenceMatrix> a_m;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_37(txt, a_m, a_clusterID, a_matching);
end connections;

protected function lm_39
  input Tpl.Text in_txt;
  input list<BackendDAE.Var> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<BackendDAE.Var> rest;
      Integer a_clusterID;
      Integer x_varID;
      DAE.ComponentRef i_var_varName;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           BackendDAE.VAR(varName = i_var_varName) :: rest,
           a_clusterID )
      equation
        x_varID = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_varID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [label=\""));
        txt = CodegenUtil.crefStr(txt, i_var_varName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", shape=\"box\"]"));
        txt = Tpl.nextIter(txt);
        txt = lm_39(txt, rest, a_clusterID);
      then txt;

    case ( txt,
           _ :: rest,
           a_clusterID )
      equation
        txt = lm_39(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_39;

protected function lm_40
  input Tpl.Text in_txt;
  input list<BackendDAE.Equation> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<BackendDAE.Equation> rest;
      Integer a_clusterID;
      Integer x_eqID;
      BackendDAE.Equation i_eq;
      String ret_0;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_clusterID )
      equation
        x_eqID = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("eq"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(x_eqID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" [label=\""));
        ret_0 = BackendDump.equationString(i_eq);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", shape=\"box\"]"));
        txt = Tpl.nextIter(txt);
        txt = lm_40(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_40;

protected function lm_41
  input Tpl.Text in_txt;
  input BackendDAE.EqSystems in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      BackendDAE.EqSystems rest;
      Integer x_clusterID;
      BackendDAE.Matching i_eqSystem_matching;
      BackendDAE.EquationArray i_eqSystem_orderedEqs;
      BackendDAE.Variables i_eqSystem_orderedVars;
      list<BackendDAE.Equation> ret_3;
      Tpl.Text l_eqDeclaration;
      list<BackendDAE.Var> ret_1;
      Tpl.Text l_varDeclaration;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           BackendDAE.EQSYSTEM(orderedVars = i_eqSystem_orderedVars, orderedEqs = i_eqSystem_orderedEqs, matching = i_eqSystem_matching) :: rest )
      equation
        x_clusterID = Tpl.getIteri_i0(txt);
        ret_1 = BackendVariable.varList(i_eqSystem_orderedVars);
        l_varDeclaration = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_varDeclaration = lm_39(l_varDeclaration, ret_1, x_clusterID);
        l_varDeclaration = Tpl.popIter(l_varDeclaration);
        ret_3 = BackendEquation.equationList(i_eqSystem_orderedEqs);
        l_eqDeclaration = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_eqDeclaration = lm_40(l_eqDeclaration, ret_3, x_clusterID);
        l_eqDeclaration = Tpl.popIter(l_eqDeclaration);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("subgraph cluster_"));
        txt = Tpl.writeStr(txt, intString(x_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(" {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("label = \"system #"));
        txt = Tpl.writeStr(txt, intString(x_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\";\n",
                                    "color=white\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_varDeclaration);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = dumpStrongComponent(txt, x_clusterID, i_eqSystem_matching);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_41(txt, rest);
      then txt;
  end match;
end lm_41;

public function dumpSorting
  input Tpl.Text in_txt;
  input BackendDAE.BackendDAE in_a_backendDAE;
  input String in_a_suffix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_backendDAE, in_a_suffix)
    local
      Tpl.Text txt;
      String a_suffix;
      String i_info_fileNamePrefix;
      BackendDAE.EqSystems i_eqs;
      Tpl.Text l_systems;

    case ( txt,
           BackendDAE.DAE(eqs = i_eqs, shared = BackendDAE.SHARED(info = BackendDAE.EXTRA_INFO(fileNamePrefix = i_info_fileNamePrefix))),
           a_suffix )
      equation
        l_systems = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_STRING_LIST({
                                                                                    "\n",
                                                                                    "\n"
                                                                                }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_systems = lm_41(l_systems, i_eqs);
        l_systems = Tpl.popIter(l_systems);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("digraph G {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("label=\""));
        txt = Tpl.writeStr(txt, i_info_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ["));
        txt = Tpl.writeStr(txt, a_suffix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " - sorting]\";\n",
                                    "rankdir=LR;\n",
                                    "\n"
                                }, true));
        txt = Tpl.writeText(txt, l_systems);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSorting;

protected function lm_43
  input Tpl.Text in_txt;
  input list<Integer> in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      list<Integer> rest;
      Integer a_clusterID;
      Integer i_v;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_v :: rest,
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(i_v));
        txt = Tpl.nextIter(txt);
        txt = lm_43(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_43;

protected function fun_44
  input Tpl.Text in_txt;
  input BackendDAE.StrongComponent in_a_comp;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_comp, in_a_clusterID)
    local
      Tpl.Text txt;
      Integer a_clusterID;
      list<Integer> i_c_vars;
      Integer i_c_var;
      Tpl.Text l_foo;

    case ( txt,
           BackendDAE.SINGLEEQUATION(var = i_c_var),
           a_clusterID )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var"));
        txt = Tpl.writeStr(txt, intString(a_clusterID));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = Tpl.writeStr(txt, intString(i_c_var));
      then txt;

    case ( txt,
           BackendDAE.EQUATIONSYSTEM(vars = i_c_vars),
           a_clusterID )
      equation
        l_foo = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" <-> ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_foo = lm_43(l_foo, i_c_vars, a_clusterID);
        l_foo = Tpl.popIter(l_foo);
        txt = Tpl.writeText(txt, l_foo);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("asd"));
      then txt;
  end match;
end fun_44;

protected function lm_45
  input Tpl.Text in_txt;
  input BackendDAE.StrongComponents in_items;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_clusterID)
    local
      Tpl.Text txt;
      BackendDAE.StrongComponents rest;
      Integer a_clusterID;
      BackendDAE.StrongComponent i_comp;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_comp :: rest,
           a_clusterID )
      equation
        txt = fun_44(txt, i_comp, a_clusterID);
        txt = Tpl.nextIter(txt);
        txt = lm_45(txt, rest, a_clusterID);
      then txt;
  end match;
end lm_45;

protected function fun_46
  input Tpl.Text in_txt;
  input BackendDAE.Matching in_a_matching;
  input Integer in_a_clusterID;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_matching, in_a_clusterID)
    local
      Tpl.Text txt;
      Integer a_clusterID;
      BackendDAE.StrongComponents i_comps;
      Tpl.Text l_cmpNodes;

    case ( txt,
           BackendDAE.MATCHING(comps = i_comps),
           a_clusterID )
      equation
        l_cmpNodes = Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(1, NONE(), SOME(Tpl.ST_STRING(" -> ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_cmpNodes = lm_45(l_cmpNodes, i_comps, a_clusterID);
        l_cmpNodes = Tpl.popIter(l_cmpNodes);
        txt = Tpl.writeText(txt, l_cmpNodes);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_46;

public function dumpStrongComponent
  input Tpl.Text txt;
  input Integer a_clusterID;
  input BackendDAE.Matching a_matching;

  output Tpl.Text out_txt;
algorithm
  out_txt := fun_46(txt, a_matching, a_clusterID);
end dumpStrongComponent;

annotation(__OpenModelica_Interface="backend");
end GraphvizDump;