encapsulated package SimCodeDump
"
  file:        SimCodeDump.mo
  package:     SimCodeDump
  description: Generated by Susan.
"

public import Tpl;

public import SimCodeVar;
public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import SCodeDump;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCodeMain;
public import HpcOmSimCode;
public import HpcOmMemory;
public import HpcOmScheduler;
public import CodegenUtil;
public import DAEDumpTpl;
public import SCodeDumpTpl;

public function dumpSimCode
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_code;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_code, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      String i_fileNamePrefix;
      SimCode.SimCode i_sc;
      Tpl.Text txt_1;
      Tpl.Text l_res;

    case ( txt,
           (i_sc as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = _)), fileNamePrefix = i_fileNamePrefix)),
           a_withOperations )
      equation
        l_res = dumpSimCodeBase(Tpl.emptyTxt, i_sc, a_withOperations);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_info.xml"));
        Tpl.textFile(l_res, Tpl.textString(txt_1));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSimCode;

public function dumpSimCodeToC
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_code;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_code, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      String i_fileNamePrefix;
      SimCode.SimCode i_sc;
      Boolean ret_4;
      Tpl.Text txt_3;
      Tpl.Text txt_2;
      Tpl.Text l_0___1;
      Tpl.Text l_0__;

    case ( txt,
           (i_sc as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = _)), fileNamePrefix = i_fileNamePrefix)),
           a_withOperations )
      equation
        l_0__ = dumpSimCode(Tpl.emptyTxt, i_sc, a_withOperations);
        txt_2 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_2 = Tpl.writeTok(txt_2, Tpl.ST_STRING("_info.xml"));
        txt_3 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_3 = Tpl.writeTok(txt_3, Tpl.ST_STRING("_info.c"));
        ret_4 = System.covertTextFileToCLiteral(Tpl.textString(txt_2), Tpl.textString(txt_3));
        l_0___1 = Tpl.writeStr(Tpl.emptyTxt, Tpl.booleanString(ret_4));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSimCodeToC;

protected function lm_40
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        txt = printExpStrEscaped(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp>"));
        txt = Tpl.nextIter(txt);
        txt = lm_40(txt, rest);
      then txt;
  end match;
end lm_40;

protected function fun_41
  input Tpl.Text in_txt;
  input SimCode.Function in_a_func;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_func)
    local
      Tpl.Text txt;
      Absyn.Info i_info;
      Absyn.Path i_name;
      String ret_9;
      Tpl.Text txt_8;
      String ret_7;
      Tpl.Text txt_6;
      String ret_5;
      Tpl.Text txt_4;
      String ret_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_2 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_3 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_2));
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.KERNEL_FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_4 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_5 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_4));
        txt = Tpl.writeStr(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.PARALLEL_FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_6 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_7 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_6));
        txt = Tpl.writeStr(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_8 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_9 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_8));
        txt = Tpl.writeStr(txt, ret_9);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_41;

protected function lm_42
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_func;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_func :: rest )
      equation
        txt = fun_41(txt, i_func);
        txt = Tpl.nextIter(txt);
        txt = lm_42(txt, rest);
      then txt;
  end match;
end lm_42;

public function dumpSimCodeBase
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_code;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_code, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      list<SimCode.Function> i_mi_functions;
      list<DAE.Exp> i_literals;
      list<SimCode.SimEqSystem> i_jacobianEquations;
      list<SimCode.SimEqSystem> i_algorithmAndEquationAsserts;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_maxValueEquations;
      list<SimCode.SimEqSystem> i_minValueEquations;
      list<SimCode.SimEqSystem> i_nominalValueEquations;
      list<SimCode.SimEqSystem> i_startValueEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.SimEqSystem> i_residualEquations;
      list<SimCode.SimEqSystem> i_removedInitialEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      list<SimCodeVar.SimVar> i_vars_jacobianVars;
      list<SimCodeVar.SimVar> i_vars_constVars;
      list<SimCodeVar.SimVar> i_vars_extObjVars;
      list<SimCodeVar.SimVar> i_vars_stringAliasVars;
      list<SimCodeVar.SimVar> i_vars_stringParamVars;
      list<SimCodeVar.SimVar> i_vars_stringAlgVars;
      list<SimCodeVar.SimVar> i_vars_boolParamVars;
      list<SimCodeVar.SimVar> i_vars_intParamVars;
      list<SimCodeVar.SimVar> i_vars_paramVars;
      list<SimCodeVar.SimVar> i_vars_boolAliasVars;
      list<SimCodeVar.SimVar> i_vars_intAliasVars;
      list<SimCodeVar.SimVar> i_vars_aliasVars;
      list<SimCodeVar.SimVar> i_vars_outputVars;
      list<SimCodeVar.SimVar> i_vars_inputVars;
      list<SimCodeVar.SimVar> i_vars_boolAlgVars;
      list<SimCodeVar.SimVar> i_vars_intAlgVars;
      list<SimCodeVar.SimVar> i_vars_discreteAlgVars;
      list<SimCodeVar.SimVar> i_vars_algVars;
      list<SimCodeVar.SimVar> i_vars_derivativeVars;
      list<SimCodeVar.SimVar> i_vars_stateVars;
      Absyn.Path i_mi_name;
      Integer ret_25;
      Integer ret_24;
      list<SimCode.SimEqSystem> ret_23;
      list<SimCode.SimEqSystem> ret_22;
      Integer ret_21;
      list<SimCode.SimEqSystem> ret_20;
      Integer ret_19;
      list<SimCode.SimEqSystem> ret_18;
      Integer ret_17;
      list<SimCode.SimEqSystem> ret_16;
      Integer ret_15;
      list<SimCode.SimEqSystem> ret_14;
      Integer ret_13;
      list<SimCode.SimEqSystem> ret_12;
      Integer ret_11;
      list<SimCode.SimEqSystem> ret_10;
      Integer ret_9;
      list<SimCode.SimEqSystem> ret_8;
      Integer ret_7;
      list<SimCode.SimEqSystem> ret_6;
      Integer ret_5;
      list<SimCode.SimEqSystem> ret_4;
      Integer ret_3;
      String ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, discreteAlgVars = i_vars_discreteAlgVars, intAlgVars = i_vars_intAlgVars, boolAlgVars = i_vars_boolAlgVars, inputVars = i_vars_inputVars, outputVars = i_vars_outputVars, aliasVars = i_vars_aliasVars, intAliasVars = i_vars_intAliasVars, boolAliasVars = i_vars_boolAliasVars, paramVars = i_vars_paramVars, intParamVars = i_vars_intParamVars, boolParamVars = i_vars_boolParamVars, stringAlgVars = i_vars_stringAlgVars, stringParamVars = i_vars_stringParamVars, stringAliasVars = i_vars_stringAliasVars, extObjVars = i_vars_extObjVars, constVars = i_vars_constVars, jacobianVars = i_vars_jacobianVars), name = i_mi_name, functions = i_mi_functions), initialEquations = i_initialEquations, removedInitialEquations = i_removedInitialEquations, residualEquations = i_residualEquations, allEquations = i_allEquations, startValueEquations = i_startValueEquations, nominalValueEquations = i_nominalValueEquations, minValueEquations = i_minValueEquations, maxValueEquations = i_maxValueEquations, parameterEquations = i_parameterEquations, algorithmAndEquationAsserts = i_algorithmAndEquationAsserts, jacobianEquations = i_jacobianEquations, literals = i_literals),
           a_withOperations )
      equation
        txt_1 = CodegenUtil.dotPath(Tpl.emptyTxt, i_mi_name);
        ret_2 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_1));
        l_name = Tpl.writeStr(Tpl.emptyTxt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n",
                                    "<?xml-stylesheet type=\"application/xml\" href=\"simcodedump.xsl\"?>\n",
                                    "<simcodedump model=\""
                                }, false));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "<variables>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpVars(txt, i_vars_stateVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_derivativeVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_algVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_discreteAlgVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_intAlgVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_boolAlgVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_inputVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_outputVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_aliasVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_intAliasVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_boolAliasVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_paramVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_intParamVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_boolParamVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_stringAlgVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_stringParamVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_stringAliasVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_extObjVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_constVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpVars(txt, i_vars_jacobianVars, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</variables>\n",
                                    "<initial-equations size=\""
                                }, false));
        ret_3 = listLength(i_initialEquations);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_4 = SimCodeUtil.sortEqSystems(i_initialEquations);
        txt = dumpEqs(txt, ret_4, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</initial-equations>\n",
                                    "<removed-initial-equations size=\""
                                }, false));
        ret_5 = listLength(i_removedInitialEquations);
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_6 = SimCodeUtil.sortEqSystems(i_removedInitialEquations);
        txt = dumpEqs(txt, ret_6, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</removed-initial-equations>\n",
                                    "<residual-equations size=\""
                                }, false));
        ret_7 = listLength(i_residualEquations);
        txt = Tpl.writeStr(txt, intString(ret_7));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_8 = SimCodeUtil.sortEqSystems(i_residualEquations);
        txt = dumpEqs(txt, ret_8, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</residual-equations>\n",
                                    "<equations size=\""
                                }, false));
        ret_9 = listLength(i_allEquations);
        txt = Tpl.writeStr(txt, intString(ret_9));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_10 = SimCodeUtil.sortEqSystems(i_allEquations);
        txt = dumpEqs(txt, ret_10, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</equations>\n",
                                    "<start-equations size=\""
                                }, false));
        ret_11 = listLength(i_startValueEquations);
        txt = Tpl.writeStr(txt, intString(ret_11));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_12 = SimCodeUtil.sortEqSystems(i_startValueEquations);
        txt = dumpEqs(txt, ret_12, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</start-equations>\n",
                                    "<nominal-equations size=\""
                                }, false));
        ret_13 = listLength(i_nominalValueEquations);
        txt = Tpl.writeStr(txt, intString(ret_13));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_14 = SimCodeUtil.sortEqSystems(i_nominalValueEquations);
        txt = dumpEqs(txt, ret_14, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</nominal-equations>\n",
                                    "<min-equations size=\""
                                }, false));
        ret_15 = listLength(i_minValueEquations);
        txt = Tpl.writeStr(txt, intString(ret_15));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_16 = SimCodeUtil.sortEqSystems(i_minValueEquations);
        txt = dumpEqs(txt, ret_16, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</min-equations>\n",
                                    "<max-equations size=\""
                                }, false));
        ret_17 = listLength(i_maxValueEquations);
        txt = Tpl.writeStr(txt, intString(ret_17));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_18 = SimCodeUtil.sortEqSystems(i_maxValueEquations);
        txt = dumpEqs(txt, ret_18, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</max-equations>\n",
                                    "<parameter-equations size=\""
                                }, false));
        ret_19 = listLength(i_parameterEquations);
        txt = Tpl.writeStr(txt, intString(ret_19));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_20 = SimCodeUtil.sortEqSystems(i_parameterEquations);
        txt = dumpEqs(txt, ret_20, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</parameter-equations>\n",
                                    "<assertions size=\""
                                }, false));
        ret_21 = listLength(i_algorithmAndEquationAsserts);
        txt = Tpl.writeStr(txt, intString(ret_21));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_22 = SimCodeUtil.sortEqSystems(i_algorithmAndEquationAsserts);
        txt = dumpEqs(txt, ret_22, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</assertions>\n",
                                    "<jacobian-equations>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_23 = SimCodeUtil.sortEqSystems(i_jacobianEquations);
        txt = dumpEqs(txt, ret_23, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</jacobian-equations>\n",
                                    "<literals size=\""
                                }, false));
        ret_24 = listLength(i_literals);
        txt = Tpl.writeStr(txt, intString(ret_24));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_40(txt, i_literals);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</literals>\n",
                                    "<functions size=\""
                                }, false));
        ret_25 = listLength(i_mi_functions);
        txt = Tpl.writeStr(txt, intString(ret_25));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_42(txt, i_mi_functions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</functions>\n",
                                    "</simcodedump>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpSimCodeBase;

protected function lm_44
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Integer x_index0;
      DAE.ComponentRef i_v_name;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_v_name) :: rest )
      equation
        x_index0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeStr(txt, intString(x_index0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(": "));
        txt_0 = CodegenUtil.crefStrNoUnderscore(Tpl.emptyTxt, i_v_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.nextIter(txt);
        txt = lm_44(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_44(txt, rest);
      then txt;
  end match;
end lm_44;

public function dumpVarsShort
  input Tpl.Text txt;
  input list<SimCodeVar.SimVar> a_vars;

  output Tpl.Text out_txt;
protected
  Tpl.Text l_varsString;
algorithm
  l_varsString := Tpl.pushIter(Tpl.emptyTxt, Tpl.ITER_OPTIONS(0, SOME(Tpl.ST_STRING("")), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  l_varsString := lm_44(l_varsString, a_vars);
  l_varsString := Tpl.popIter(l_varsString);
  out_txt := Tpl.writeText(txt, l_varsString);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_NEW_LINE());
end dumpVarsShort;

protected function fun_46
  input Tpl.Text in_txt;
  input SimCodeVar.SimVar in_a_v;
  input Boolean in_a_withOperations;
  input DAE.ElementSource in_a_v_source;
  input SimCodeVar.AliasVariable in_a_v_aliasvar;
  input Tpl.Text in_a_variability;
  input String in_a_v_comment;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_v, in_a_withOperations, in_a_v_source, in_a_v_aliasvar, in_a_variability, in_a_v_comment)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      DAE.ElementSource a_v_source;
      SimCodeVar.AliasVariable a_v_aliasvar;
      Tpl.Text a_variability;
      String a_v_comment;
      DAE.Type i_type__;
      Boolean i_isFixed;
      Option<DAE.Exp> i_nominalValue;
      Option<DAE.Exp> i_initialValue;
      Option<DAE.Exp> i_maxValue;
      Option<DAE.Exp> i_minValue;
      String i_displayUnit;
      String i_unit;
      Boolean i_isDiscrete;
      DAE.ComponentRef i_c;
      String ret_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.SIMVAR(arrayCref = SOME(i_c), isDiscrete = i_isDiscrete, unit = i_unit, displayUnit = i_displayUnit, minValue = i_minValue, maxValue = i_maxValue, initialValue = i_initialValue, nominalValue = i_nominalValue, isFixed = i_isFixed, type_ = i_type__),
           a_withOperations,
           a_v_source,
           a_v_aliasvar,
           a_variability,
           a_v_comment )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<variable name=\""));
        txt_0 = CodegenUtil.crefStrNoUnderscore(Tpl.emptyTxt, i_c);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" comment=\""));
        ret_2 = Util.escapeModelicaStringToXmlString(a_v_comment);
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" variability = \""));
        txt = Tpl.writeText(txt, a_variability);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" isDiscrete = \""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_isDiscrete));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = CodegenUtil.ScalarVariableType(txt, i_unit, i_displayUnit, i_minValue, i_maxValue, i_initialValue, i_nominalValue, i_isFixed, i_type__);
        txt = Tpl.softNewLine(txt);
        txt = dumpAlias(txt, a_v_aliasvar);
        txt = Tpl.softNewLine(txt);
        txt = dumpElementSource(txt, a_v_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</variable>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_46;

protected function lm_47
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      Boolean a_withOperations;
      DAE.Type i_type__;
      Boolean i_isFixed;
      Option<DAE.Exp> i_nominalValue;
      Option<DAE.Exp> i_initialValue;
      Option<DAE.Exp> i_maxValue;
      Option<DAE.Exp> i_minValue;
      String i_displayUnit;
      String i_unit;
      Boolean i_isDiscrete;
      DAE.ComponentRef i_v_name;
      DAE.ElementSource i_v_source;
      SimCodeVar.AliasVariable i_v_aliasvar;
      String i_v_comment;
      SimCodeVar.SimVar i_v;
      BackendDAE.VarKind i_varKind;
      String ret_6;
      String ret_5;
      Tpl.Text txt_4;
      String ret_3;
      String ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_variability;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           (i_v as SimCodeVar.SIMVAR(varKind = i_varKind, comment = i_v_comment, aliasvar = i_v_aliasvar, source = i_v_source, name = i_v_name, isDiscrete = i_isDiscrete, unit = i_unit, displayUnit = i_displayUnit, minValue = i_minValue, maxValue = i_maxValue, initialValue = i_initialValue, nominalValue = i_nominalValue, isFixed = i_isFixed, type_ = i_type__)) :: rest,
           a_withOperations )
      equation
        l_variability = CodegenUtil.getVariablity(Tpl.emptyTxt, i_varKind);
        txt = fun_46(txt, i_v, a_withOperations, i_v_source, i_v_aliasvar, l_variability, i_v_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<variable name=\""));
        txt_1 = CodegenUtil.crefStrNoUnderscore(Tpl.emptyTxt, i_v_name);
        ret_2 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_1));
        txt = Tpl.writeStr(txt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" comment=\""));
        ret_3 = Util.escapeModelicaStringToXmlString(i_v_comment);
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" variability = \""));
        txt = Tpl.writeText(txt, l_variability);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" isDiscrete = \""));
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_isDiscrete));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = CodegenUtil.ScalarVariableType(txt, i_unit, i_displayUnit, i_minValue, i_maxValue, i_initialValue, i_nominalValue, i_isFixed, i_type__);
        txt = Tpl.softNewLine(txt);
        txt = dumpAlias(txt, i_v_aliasvar);
        txt = Tpl.softNewLine(txt);
        txt = dumpElementSource(txt, i_v_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</variable>"));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "<variable name=\"$PRE."
                                }, false));
        txt_4 = CodegenUtil.crefStrNoUnderscore(Tpl.emptyTxt, i_v_name);
        ret_5 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_4));
        txt = Tpl.writeStr(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" comment=\""));
        ret_6 = Util.escapeModelicaStringToXmlString(i_v_comment);
        txt = Tpl.writeStr(txt, ret_6);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" variability = \""));
        txt = Tpl.writeText(txt, l_variability);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" isDiscrete = \"true\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = CodegenUtil.ScalarVariableType(txt, i_unit, i_displayUnit, i_minValue, i_maxValue, i_initialValue, i_nominalValue, i_isFixed, i_type__);
        txt = Tpl.softNewLine(txt);
        txt = dumpAlias(txt, i_v_aliasvar);
        txt = Tpl.softNewLine(txt);
        txt = dumpElementSource(txt, i_v_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</variable>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = lm_47(txt, rest, a_withOperations);
      then txt;

    case ( txt,
           _ :: rest,
           a_withOperations )
      equation
        txt = lm_47(txt, rest, a_withOperations);
      then txt;
  end match;
end lm_47;

public function dumpVars
  input Tpl.Text txt;
  input list<SimCodeVar.SimVar> a_vars;
  input Boolean a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_47(txt, a_vars, a_withOperations);
end dumpVars;

public function dumpAlias
  input Tpl.Text in_txt;
  input SimCodeVar.AliasVariable in_a_alias;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_alias)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_varName;
      String ret_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCodeVar.ALIAS(varName = i_varName) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<alias>"));
        txt_0 = CodegenUtil.crefStrNoUnderscore(Tpl.emptyTxt, i_varName);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</alias>"));
      then txt;

    case ( txt,
           SimCodeVar.NEGATEDALIAS(varName = i_varName) )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<alias negated=\"true\">"));
        txt_2 = CodegenUtil.crefStrNoUnderscore(Tpl.emptyTxt, i_varName);
        ret_3 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_2));
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</alias>"));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpAlias;

public function eqIndex
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      Integer i_index;

    case ( txt,
           SimCode.SES_RESIDUAL(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_MIXED(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_WHEN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_IFEQUATION(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("SimCodeDump.tpl", 167, 16), "dumpEqs: Unknown equation");
      then txt;
  end match;
end eqIndex;

protected function fun_51
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_parent;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_parent)
    local
      Tpl.Text txt;
      Integer a_parent;

    case ( txt,
           false,
           a_parent )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parent=\""));
        txt = Tpl.writeStr(txt, intString(a_parent));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_51;

public function hasParent
  input Tpl.Text txt;
  input Integer a_parent;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := intEq(a_parent, 0);
  out_txt := fun_51(txt, ret_0, a_parent);
end hasParent;

protected function lm_53
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<depends name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;
  end match;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_stmt;
      String ret_1;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_stmt :: rest )
      equation
        ret_0 = DAEDump.ppStmtStr(i_stmt, 2);
        ret_1 = Util.escapeModelicaStringToXmlString(ret_0);
        txt = Tpl.writeStr(txt, ret_1);
        txt = lm_54(txt, rest);
      then txt;
  end match;
end lm_54;

protected function fun_55
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_e_jacobianMatrix;
  input Boolean in_a_withOperations;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_e_jacobianMatrix, in_a_withOperations, in_a_e_index)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      Integer a_e_index;
      list<SimCode.SimEqSystem> i_eqns;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SOME(({(i_eqns, _, _)}, _, _, _, _, _, _)),
           a_withOperations,
           a_e_index )
      equation
        ret_0 = SimCodeUtil.sortEqSystems(i_eqns);
        txt = dumpEqs(txt, ret_0, a_e_index, a_withOperations);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_56(txt, rest);
      then txt;
  end match;
end lm_56;

protected function lm_57
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cell>"));
        txt = printExpStrEscaped(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cell>"));
        txt = Tpl.nextIter(txt);
        txt = lm_57(txt, rest);
      then txt;
  end match;
end lm_57;

protected function fun_58
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      DAE.Exp i_e_exp;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_e_exp) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<residual>"));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</residual>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_58;

protected function lm_59
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      SimCode.SimEqSystem i_eq;
      Integer i_i2;
      Integer i_i1;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_i1, i_i2, i_eq) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cell row=\""));
        txt = Tpl.writeStr(txt, intString(i_i1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" col=\""));
        txt = Tpl.writeStr(txt, intString(i_i2));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = fun_58(txt, i_eq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cell>"));
        txt = lm_59(txt, rest);
      then txt;
  end match;
end lm_59;

protected function lm_60
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<eq index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_60(txt, rest);
      then txt;
  end match;
end lm_60;

protected function lm_61
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<eq index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_61(txt, rest);
      then txt;
  end match;
end lm_61;

protected function fun_62
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_e_jacobianMatrix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_e_jacobianMatrix)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_eqns;

    case ( txt,
           SOME(({(i_eqns, _, _)}, _, _, _, _, _, _)) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_61(txt, i_eqns);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<DAE.ElementSource> in_items;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations)
    local
      Tpl.Text txt;
      list<DAE.ElementSource> rest;
      Boolean a_withOperations;
      DAE.ElementSource i_source;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_source :: rest,
           a_withOperations )
      equation
        txt = dumpElementSource(txt, i_source, a_withOperations);
        txt = lm_63(txt, rest, a_withOperations);
      then txt;
  end match;
end lm_63;

protected function fun_64
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_e_jacobianMatrix;
  input Boolean in_a_withOperations;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_e_jacobianMatrix, in_a_withOperations, in_a_e_index)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      Integer a_e_index;
      list<SimCode.SimEqSystem> i_eqns;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SOME(({(i_eqns, _, _)}, _, _, _, _, _, _)),
           a_withOperations,
           a_e_index )
      equation
        ret_0 = SimCodeUtil.sortEqSystems(i_eqns);
        txt = dumpEqs(txt, ret_0, a_e_index, a_withOperations);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_64;

protected function lm_65
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_65(txt, rest);
      then txt;
  end match;
end lm_65;

protected function lm_66
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<eq index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_66(txt, rest);
      then txt;
  end match;
end lm_66;

protected function lm_67
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_67(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_67(txt, rest);
      then txt;
  end match;
end lm_67;

protected function lm_68
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<discrete index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = lm_68(txt, rest);
      then txt;
  end match;
end lm_68;

protected function lm_69
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cond;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cond :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cond>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cond);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cond>"));
        txt = Tpl.nextIter(txt);
        txt = lm_69(txt, rest);
      then txt;
  end match;
end lm_69;

protected function lm_70
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> in_items;
  input Boolean in_a_withOperations;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations, in_a_e_index)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> rest;
      Boolean a_withOperations;
      Integer a_e_index;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (_, i_eqs) :: rest,
           a_withOperations,
           a_e_index )
      equation
        txt = dumpEqs(txt, i_eqs, a_e_index, a_withOperations);
        txt = lm_70(txt, rest, a_withOperations, a_e_index);
      then txt;
  end match;
end lm_70;

protected function fun_71
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_withOperations;
  input Integer in_a_parent;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_withOperations, in_a_parent)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      Integer a_parent;
      list<SimCode.SimEqSystem> i_elsebranch;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> i_ifbranches;
      DAE.Exp i_e_right;
      DAE.ComponentRef i_e_left;
      list<DAE.ComponentRef> i_conditions;
      list<SimCodeVar.SimVar> i_e_discVars;
      list<SimCode.SimEqSystem> i_e_discEqs;
      SimCode.SimEqSystem i_e_cont;
      list<DAE.ComponentRef> i_e_crefs;
      Integer i_indexNonLinearSystem;
      list<SimCode.SimEqSystem> i_e_eqs;
      list<DAE.ElementSource> i_e_sources;
      list<DAE.Exp> i_beqs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      list<SimCodeVar.SimVar> i_e_vars;
      Option<SimCode.JacobianMatrix> i_e_jacobianMatrix;
      Integer i_e_index;
      list<SimCode.SimEqSystem> i_e_residual;
      DAE.Statement i_first;
      list<DAE.Statement> i_e_statements;
      DAE.ComponentRef i_e_componentRef;
      DAE.ComponentRef i_e_cref;
      DAE.ElementSource i_e_source;
      DAE.Exp i_e_exp;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_elsebr;
      Tpl.Text l_branches;
      list<SimCode.SimEqSystem> ret_6;
      list<SimCode.SimEqSystem> ret_5;
      Integer ret_4;
      Integer ret_3;
      list<SimCode.SimEqSystem> ret_2;
      DAE.ElementSource ret_1;
      list<DAE.ComponentRef> ret_0;

    case ( txt,
           (i_e as SimCode.SES_RESIDUAL(exp = i_e_exp, source = i_e_source)),
           a_withOperations,
           a_parent )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<residual>"));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</residual>\n"));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(cref = i_e_cref, exp = i_e_exp, source = i_e_source)),
           a_withOperations,
           a_parent )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "  <assign>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_e_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        ret_0 = Expression.extractUniqueCrefsFromExp(i_e_exp);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_53(txt, ret_0);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<rhs>"));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = i_e_componentRef, exp = i_e_exp, source = i_e_source)),
           a_withOperations,
           a_parent )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "  <assign type=\"array\">\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_e_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" />\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </assign>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("empty algorithm"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = (i_e_statements as i_first :: _))),
           a_withOperations,
           a_parent )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "  <statement>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = lm_54(txt, i_e_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </statement>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_1 = Algorithm.getStatementSource(i_first);
        txt = dumpElementSource(txt, ret_1, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_LINEAR(residual = i_e_residual, index = i_e_index, jacobianMatrix = i_e_jacobianMatrix, vars = i_e_vars, simJac = i_simJac, beqs = i_beqs, sources = i_e_sources)),
           a_withOperations,
           a_parent )
      equation
        ret_2 = SimCodeUtil.sortEqSystems(i_e_residual);
        txt = dumpEqs(txt, ret_2, i_e_index, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = fun_55(txt, i_e_jacobianMatrix, a_withOperations, i_e_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<linear size=\""));
        ret_3 = listLength(i_e_vars);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" nnz=\""));
        ret_4 = listLength(i_simJac);
        txt = Tpl.writeStr(txt, intString(ret_4));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_56(txt, i_e_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<row>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_57(txt, i_beqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</row>\n",
                                    "<matrix>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = lm_59(txt, i_simJac);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</matrix>\n",
                                    "<residuals>\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_60(txt, i_e_residual);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</residuals>\n",
                                    "<jacobian>\n"
                                }, true));
        txt = fun_62(txt, i_e_jacobianMatrix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</jacobian>\n"));
        txt = lm_63(txt, i_e_sources, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</linear>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(eqs = i_e_eqs, index = i_e_index, jacobianMatrix = i_e_jacobianMatrix, indexNonLinearSystem = i_indexNonLinearSystem, crefs = i_e_crefs)),
           a_withOperations,
           a_parent )
      equation
        ret_5 = SimCodeUtil.sortEqSystems(i_e_eqs);
        txt = dumpEqs(txt, ret_5, i_e_index, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = fun_64(txt, i_e_jacobianMatrix, a_withOperations, i_e_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<nonlinear indexNonlinear=\""));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_65(txt, i_e_crefs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_66(txt, i_e_eqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</nonlinear>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_MIXED(cont = i_e_cont, index = i_e_index, discEqs = i_e_discEqs, discVars = i_e_discVars)),
           a_withOperations,
           a_parent )
      equation
        ret_6 = List.fill(i_e_cont, 1);
        txt = dumpEqs(txt, ret_6, i_e_index, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpEqs(txt, i_e_discEqs, i_e_index, a_withOperations);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "<equation index=\""
                                }, false));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "  <mixed>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<continuous index=\""));
        txt = eqIndex(txt, i_e_cont);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_67(txt, i_e_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = lm_68(txt, i_e_discEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </mixed>\n",
                                    "</equation>"
                                }, false));
      then txt;

    case ( txt,
           (i_e as SimCode.SES_WHEN(conditions = i_conditions, left = i_e_left, right = i_e_right, source = i_e_source)),
           a_withOperations,
           a_parent )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "  <when>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_69(txt, i_conditions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_e_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" />\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e_right);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("  </when>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_IFEQUATION(ifbranches = i_ifbranches, index = i_e_index, elsebranch = i_elsebranch, source = i_e_source)),
           a_withOperations,
           a_parent )
      equation
        l_branches = lm_70(Tpl.emptyTxt, i_ifbranches, a_withOperations, i_e_index);
        l_elsebr = dumpEqs(Tpl.emptyTxt, i_elsebranch, i_e_index, a_withOperations);
        txt = Tpl.writeText(txt, l_branches);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_elsebr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "<ifequation /> <!-- TODO: Fix me -->\n"
                                }, true));
        txt = dumpElementSource(txt, i_e_source, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("SimCodeDump.tpl", 291, 16), "dumpEqs: Unknown equation");
      then txt;
  end match;
end fun_71;

protected function lm_72
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_withOperations;
  input Integer in_a_parent;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations, in_a_parent)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_withOperations;
      Integer a_parent;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_withOperations,
           a_parent )
      equation
        txt = fun_71(txt, i_eq, a_withOperations, a_parent);
        txt = lm_72(txt, rest, a_withOperations, a_parent);
      then txt;
  end match;
end lm_72;

public function dumpEqs
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_eqs;
  input Integer a_parent;
  input Boolean a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_72(txt, a_eqs, a_withOperations, a_parent);
end dumpEqs;

public function dumpWithin
  input Tpl.Text in_txt;
  input Absyn.Within in_a_w;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_w)
    local
      Tpl.Text txt;
      Absyn.Path i_path;

    case ( txt,
           Absyn.TOP() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("within ;"));
      then txt;

    case ( txt,
           Absyn.WITHIN(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("within "));
        txt = CodegenUtil.dotPath(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWithin;

protected function lm_75
  input Tpl.Text in_txt;
  input list<Absyn.Within> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Within> rest;
      Absyn.Within i_w;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_w :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<part-of>"));
        txt = dumpWithin(txt, i_w);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</part-of>"));
        txt = lm_75(txt, rest);
      then txt;
  end match;
end lm_75;

protected function fun_76
  input Tpl.Text in_txt;
  input Option<DAE.ComponentRef> in_a_s_instanceOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_instanceOpt)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           SOME(i_cr) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<instance>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</instance>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_76;

protected function lm_77
  input Tpl.Text in_txt;
  input list<Option<tuple<DAE.ComponentRef, DAE.ComponentRef>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Option<tuple<DAE.ComponentRef, DAE.ComponentRef>>> rest;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<connect-equation />"));
        txt = lm_77(txt, rest);
      then txt;
  end match;
end lm_77;

protected function lm_78
  input Tpl.Text in_txt;
  input list<Absyn.Path> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Path> rest;
      Absyn.Path i_p;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_p :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<type>"));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_p);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</type>"));
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest);
      then txt;
  end match;
end lm_78;

protected function lm_79
  input Tpl.Text in_txt;
  input list<DAE.SymbolicOperation> in_items;
  input Absyn.Info in_a_s_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_s_info)
    local
      Tpl.Text txt;
      list<DAE.SymbolicOperation> rest;
      Absyn.Info a_s_info;
      DAE.SymbolicOperation i_op;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_op :: rest,
           a_s_info )
      equation
        txt = dumpOperation(txt, i_op, a_s_info);
        txt = Tpl.nextIter(txt);
        txt = lm_79(txt, rest, a_s_info);
      then txt;
  end match;
end lm_79;

protected function fun_80
  input Tpl.Text in_txt;
  input Boolean in_a_withOperations;
  input Absyn.Info in_a_s_info;
  input list<DAE.SymbolicOperation> in_a_s_operations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_withOperations, in_a_s_info, in_a_s_operations)
    local
      Tpl.Text txt;
      Absyn.Info a_s_info;
      list<DAE.SymbolicOperation> a_s_operations;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_s_info,
           a_s_operations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<operations>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_79(txt, a_s_operations, a_s_info);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</operations>"));
      then txt;
  end match;
end fun_80;

public function dumpElementSource
  input Tpl.Text in_txt;
  input DAE.ElementSource in_a_source;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_source, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      Absyn.Info i_s_info;
      list<DAE.SymbolicOperation> i_s_operations;
      list<Absyn.Path> i_s_typeLst;
      list<Option<tuple<DAE.ComponentRef, DAE.ComponentRef>>> i_s_connectEquationOptLst;
      Option<DAE.ComponentRef> i_s_instanceOpt;
      list<Absyn.Within> i_s_partOfLst;
      Absyn.Info i_info;

    case ( txt,
           DAE.SOURCE(info = (i_info as (i_s_info as Absyn.INFO(fileName = _))), partOfLst = i_s_partOfLst, instanceOpt = i_s_instanceOpt, connectEquationOptLst = i_s_connectEquationOptLst, typeLst = i_s_typeLst, operations = i_s_operations),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<source>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.softNewLine(txt);
        txt = lm_75(txt, i_s_partOfLst);
        txt = Tpl.softNewLine(txt);
        txt = fun_76(txt, i_s_instanceOpt);
        txt = Tpl.softNewLine(txt);
        txt = lm_77(txt, i_s_connectEquationOptLst);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_78(txt, i_s_typeLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</source>\n"));
        txt = fun_80(txt, a_withOperations, i_s_info, i_s_operations);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpElementSource;

protected function fun_82
  input Tpl.Text in_txt;
  input Option<DAE.Element> in_a_dae;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dae)
    local
      Tpl.Text txt;
      DAE.Element i_dae;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SOME(i_dae) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<flattened>"));
        txt_0 = DAEDumpTpl.dumpEquationElement(Tpl.emptyTxt, i_dae);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</flattened>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_82;

protected function lm_83
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_target;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_target :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        txt = printExpStrEscaped(txt, i_target);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp>"));
        txt = Tpl.nextIter(txt);
        txt = lm_83(txt, rest);
      then txt;
  end match;
end lm_83;

protected function lm_84
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest);
      then txt;
  end match;
end lm_84;

protected function lm_85
  input Tpl.Text in_txt;
  input list<Real> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Real> rest;
      Real i_r;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_r :: rest )
      equation
        txt = Tpl.writeStr(txt, realString(i_r));
        txt = Tpl.nextIter(txt);
        txt = lm_85(txt, rest);
      then txt;
  end match;
end lm_85;

protected function lm_86
  input Tpl.Text in_txt;
  input list<Real> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Real> rest;
      Real i_r;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_r :: rest )
      equation
        txt = Tpl.writeStr(txt, realString(i_r));
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest);
      then txt;
  end match;
end lm_86;

protected function lm_87
  input Tpl.Text in_txt;
  input list<list<Real>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Real>> rest;
      list<Real> i_row;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_row :: rest )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_86(txt, i_row);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_87(txt, rest);
      then txt;
  end match;
end lm_87;

protected function lm_88
  input Tpl.Text in_txt;
  input list<Real> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Real> rest;
      Real i_r;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_r :: rest )
      equation
        txt = Tpl.writeStr(txt, realString(i_r));
        txt = Tpl.nextIter(txt);
        txt = lm_88(txt, rest);
      then txt;
  end match;
end lm_88;

protected function lm_89
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_cond;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cond :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<assertion>"));
        txt = printExpStrEscaped(txt, i_cond);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</assertion>"));
        txt = Tpl.nextIter(txt);
        txt = lm_89(txt, rest);
      then txt;
  end match;
end lm_89;

protected function lm_90
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<candidate>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</candidate>"));
        txt = Tpl.nextIter(txt);
        txt = lm_90(txt, rest);
      then txt;
  end match;
end lm_90;

public function dumpOperation
  input Tpl.Text in_txt;
  input DAE.SymbolicOperation in_a_op;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op, in_a_info)
    local
      Tpl.Text txt;
      Absyn.Info a_info;
      list<DAE.ComponentRef> i_op_candidates;
      DAE.ComponentRef i_op_chosen;
      DAE.Exp i_e;
      DAE.Exp i_e2;
      DAE.Exp i_e1;
      DAE.Exp i_op_after_1;
      DAE.Exp i_op_before_1;
      list<DAE.Exp> i_op_assertConds;
      DAE.Exp i_op_res;
      DAE.Exp i_op_exp2;
      DAE.Exp i_op_exp1;
      list<Real> i_rhs;
      list<list<Real>> i_jac;
      list<Real> i_result;
      list<DAE.ComponentRef> i_vars;
      DAE.Exp i_op_exp;
      DAE.ComponentRef i_op_cr;
      Integer i_op_index;
      DAE.EquationExp i_op_after;
      DAE.EquationExp i_op_before;
      list<DAE.Exp> i_substitutions;
      DAE.Exp i_source;
      DAE.EquationExp i_after;
      DAE.EquationExp i_before;
      Option<DAE.Element> i_dae;
      SCode.EEquation i_scode;
      list<DAE.Exp> ret_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           DAE.FLATTEN(scode = i_scode, dae = i_dae),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<flattening>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<original>"));
        txt_0 = SCodeDumpTpl.dumpEEquation(Tpl.emptyTxt, i_scode, SCodeDump.defaultOptions);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</original>\n"));
        txt = fun_82(txt, i_dae);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</flattening>"));
      then txt;

    case ( txt,
           DAE.SIMPLIFY(before = i_before, after = i_after),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<simplify>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printEquationExpStrEscaped(txt, i_before);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</before>\n",
                                    "<after>"
                                }, false));
        txt = printEquationExpStrEscaped(txt, i_after);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</after>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</simplify>"));
      then txt;

    case ( txt,
           DAE.SUBSTITUTION(source = i_source, substitutions = i_substitutions),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<substitution>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printExpStrEscaped(txt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</before>\n"));
        ret_2 = listReverse(i_substitutions);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_83(txt, ret_2);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</substitution>"));
      then txt;

    case ( txt,
           DAE.OP_INLINE(before = i_op_before, after = i_op_after),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<inline>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printEquationExpStrEscaped(txt, i_op_before);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</before>\n",
                                    "<after>"
                                }, false));
        txt = printEquationExpStrEscaped(txt, i_op_after);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</after>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</inline>"));
      then txt;

    case ( txt,
           DAE.OP_SCALARIZE(index = i_op_index, before = i_op_before, after = i_op_after),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<scalarize index=\""));
        txt = Tpl.writeStr(txt, intString(i_op_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printEquationExpStrEscaped(txt, i_op_before);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</before>\n",
                                    "<after>"
                                }, false));
        txt = printEquationExpStrEscaped(txt, i_op_after);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</after>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</scalarize>"));
      then txt;

    case ( txt,
           DAE.SOLVED(cr = i_op_cr, exp = i_op_exp),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<solved>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_op_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</solved>"));
      then txt;

    case ( txt,
           DAE.LINEAR_SOLVED(vars = i_vars, result = i_result, jac = i_jac, rhs = i_rhs),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<linear-solved>\n",
                                    "  simple equation from linear system:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_84(txt, i_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = ["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_85(txt, i_result);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "[\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_87(txt, i_jac);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  *\n",
                                    "    X\n",
                                    "  =\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_88(txt, i_rhs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</linear-solved>"));
      then txt;

    case ( txt,
           DAE.SOLVE(exp1 = i_op_exp1, exp2 = i_op_exp2, cr = i_op_cr, res = i_op_res, assertConds = i_op_assertConds),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<solve>\n",
                                    "  <old>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = printExpStrEscaped(txt, i_op_exp1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_exp2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </old>\n",
                                    "  <new>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_op_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_res);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </new>\n",
                                    "  <assertions>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_89(txt, i_op_assertConds);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </assertions>\n",
                                    "</solve>"
                                }, false));
      then txt;

    case ( txt,
           DAE.OP_DIFFERENTIATE(before = i_op_before_1, cr = i_op_cr, after = i_op_after_1),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<derivative>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        txt = printExpStrEscaped(txt, i_op_before_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</exp>\n",
                                    "<with-respect-to>"
                                }, false));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_op_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</with-respect-to>\n",
                                    "<result>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_after_1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</result>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</derivative>"));
      then txt;

    case ( txt,
           DAE.OP_RESIDUAL(e1 = i_e1, e2 = i_e2, e = i_e),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<op-residual>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = printExpStrEscaped(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</rhs>\n",
                                    "<result>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</result>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</op-residual>"));
      then txt;

    case ( txt,
           DAE.NEW_DUMMY_DER(chosen = i_op_chosen, candidates = i_op_candidates),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<dummyderivative>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<chosen>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_op_chosen);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</chosen>\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_90(txt, i_op_candidates);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</dummyderivative>"));
      then txt;

    case ( txt,
           _,
           a_info )
      equation
        Tpl.addSourceTemplateError("Unknown operation", a_info);
      then txt;
  end match;
end dumpOperation;

public function dumpInfo
  input Tpl.Text in_txt;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_info)
    local
      Tpl.Text txt;
      Integer i_info_columnNumberEnd;
      Integer i_info_columnNumberStart;
      Integer i_info_lineNumberEnd;
      Integer i_info_lineNumberStart;
      String i_info_fileName;
      String ret_0;

    case ( txt,
           Absyn.INFO(fileName = i_info_fileName, lineNumberStart = i_info_lineNumberStart, lineNumberEnd = i_info_lineNumberEnd, columnNumberStart = i_info_columnNumberStart, columnNumberEnd = i_info_columnNumberEnd) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<info file=\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_info_fileName);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" lineStart=\""));
        txt = Tpl.writeStr(txt, intString(i_info_lineNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" lineEnd=\""));
        txt = Tpl.writeStr(txt, intString(i_info_lineNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" colStart=\""));
        txt = Tpl.writeStr(txt, intString(i_info_columnNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" colEnd=\""));
        txt = Tpl.writeStr(txt, intString(i_info_columnNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInfo;

public function printExpStrEscaped
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  ret_0 := ExpressionDump.printExpStr(a_exp);
  ret_1 := Util.escapeModelicaStringToXmlString(ret_0);
  out_txt := Tpl.writeStr(txt, ret_1);
end printExpStrEscaped;

public function printEquationExpStrEscaped
  input Tpl.Text in_txt;
  input DAE.EquationExp in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      DAE.Exp i_rhs;
      DAE.Exp i_lhs;
      DAE.Exp i_exp;

    case ( txt,
           DAE.PARTIAL_EQUATION(exp = i_exp) )
      equation
        txt = printExpStrEscaped(txt, i_exp);
      then txt;

    case ( txt,
           DAE.RESIDUAL_EXP(exp = i_exp) )
      equation
        txt = printExpStrEscaped(txt, i_exp);
      then txt;

    case ( txt,
           DAE.EQUALITY_EXPS(lhs = i_lhs, rhs = i_rhs) )
      equation
        txt = printExpStrEscaped(txt, i_lhs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = printExpStrEscaped(txt, i_rhs);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end printEquationExpStrEscaped;

annotation(__OpenModelica_Interface="backend");
end SimCodeDump;