encapsulated package TaskSystemDump
"
  file:        TaskSystemDump.mo
  package:     TaskSystemDump
  description: Generated by Susan.
"

public import Tpl;

public import SimCodeVar;
public import SimCode;
public import SimCodeUtil;
public import BackendDAE;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import SCode;
public import SCodeDump;
public import Util;
public import List;
public import ComponentReference;
public import Expression;
public import ExpressionDump;
public import Config;
public import Flags;
public import Settings;
public import Patternm;
public import Error;
public import Values;
public import ValuesUtil;
public import BackendQSS;
public import BackendVariable;
public import DAEDump;
public import Algorithm;
public import DAEUtil;
public import Types;
public import FMI;
public import HpcOmSimCodeMain;
public import HpcOmSimCode;
public import HpcOmMemory;
public import HpcOmScheduler;
public import CodegenUtil;
public import DAEDumpTpl;
public import SCodeDumpTpl;

public function dumpTaskSystem
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_code;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_code, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      String i_fileNamePrefix;
      SimCode.SimCode i_sc;
      Tpl.Text txt_1;
      Tpl.Text l_res;

    case ( txt,
           (i_sc as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = _)), fileNamePrefix = i_fileNamePrefix)),
           a_withOperations )
      equation
        l_res = tasksystemdump_dispatch(Tpl.emptyTxt, i_sc, a_withOperations);
        txt_1 = Tpl.writeStr(Tpl.emptyTxt, i_fileNamePrefix);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING("_tasks.xml"));
        Tpl.textFile(l_res, Tpl.textString(txt_1));
        txt = Tpl.writeStr(txt, i_fileNamePrefix);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_info"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpTaskSystem;

protected function lm_39
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_exp;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_exp :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        txt = printExpStrEscaped(txt, i_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp>"));
        txt = Tpl.nextIter(txt);
        txt = lm_39(txt, rest);
      then txt;
  end match;
end lm_39;

protected function fun_40
  input Tpl.Text in_txt;
  input SimCode.Function in_a_func;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_func)
    local
      Tpl.Text txt;
      Absyn.Info i_info;
      Absyn.Path i_name;
      String ret_9;
      Tpl.Text txt_8;
      String ret_7;
      Tpl.Text txt_6;
      String ret_5;
      Tpl.Text txt_4;
      String ret_3;
      Tpl.Text txt_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SimCode.FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.EXTERNAL_FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_2 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_3 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_2));
        txt = Tpl.writeStr(txt, ret_3);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.KERNEL_FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_4 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_5 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_4));
        txt = Tpl.writeStr(txt, ret_5);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.PARALLEL_FUNCTION(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_6 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_7 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_6));
        txt = Tpl.writeStr(txt, ret_7);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           SimCode.RECORD_CONSTRUCTOR(name = i_name, info = i_info) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<function name=\""));
        txt_8 = CodegenUtil.dotPath(Tpl.emptyTxt, i_name);
        ret_9 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_8));
        txt = Tpl.writeStr(txt, ret_9);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\">"));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</function>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_40;

protected function lm_41
  input Tpl.Text in_txt;
  input list<SimCode.Function> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.Function> rest;
      SimCode.Function i_func;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_func :: rest )
      equation
        txt = fun_40(txt, i_func);
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;
  end match;
end lm_41;

public function tasksystemdump_dispatch
  input Tpl.Text in_txt;
  input SimCode.SimCode in_a_code;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_code, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      list<SimCode.Function> i_mi_functions;
      list<DAE.Exp> i_literals;
      list<SimCode.SimEqSystem> i_jacobianEquations;
      list<SimCode.SimEqSystem> i_algorithmAndEquationAsserts;
      list<SimCode.SimEqSystem> i_parameterEquations;
      list<SimCode.SimEqSystem> i_maxValueEquations;
      list<SimCode.SimEqSystem> i_minValueEquations;
      list<SimCode.SimEqSystem> i_nominalValueEquations;
      list<SimCode.SimEqSystem> i_startValueEquations;
      list<SimCode.SimEqSystem> i_residualEquations;
      list<list<SimCode.SimEqSystem>> i_algebraicEquations;
      list<list<SimCode.SimEqSystem>> i_odeEquations;
      list<SimCode.SimEqSystem> i_allEquations;
      list<SimCode.SimEqSystem> i_initialEquations;
      Absyn.Path i_mi_name;
      Integer ret_31;
      Integer ret_30;
      list<SimCode.SimEqSystem> ret_29;
      list<SimCode.SimEqSystem> ret_28;
      Integer ret_27;
      list<SimCode.SimEqSystem> ret_26;
      Integer ret_25;
      list<SimCode.SimEqSystem> ret_24;
      Integer ret_23;
      list<SimCode.SimEqSystem> ret_22;
      Integer ret_21;
      list<SimCode.SimEqSystem> ret_20;
      Integer ret_19;
      list<SimCode.SimEqSystem> ret_18;
      Integer ret_17;
      list<SimCode.SimEqSystem> ret_16;
      Integer ret_15;
      list<SimCode.SimEqSystem> ret_14;
      list<SimCode.SimEqSystem> ret_13;
      Integer ret_12;
      list<SimCode.SimEqSystem> ret_11;
      list<SimCode.SimEqSystem> ret_10;
      list<SimCode.SimEqSystem> ret_9;
      Integer ret_8;
      list<SimCode.SimEqSystem> ret_7;
      list<SimCode.SimEqSystem> ret_6;
      Integer ret_5;
      list<SimCode.SimEqSystem> ret_4;
      Integer ret_3;
      String ret_2;
      Tpl.Text txt_1;
      Tpl.Text l_name;

    case ( txt,
           SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(vars = SimCodeVar.SIMVARS(stateVars = _), name = i_mi_name, functions = i_mi_functions), initialEquations = i_initialEquations, allEquations = i_allEquations, odeEquations = i_odeEquations, algebraicEquations = i_algebraicEquations, residualEquations = i_residualEquations, startValueEquations = i_startValueEquations, nominalValueEquations = i_nominalValueEquations, minValueEquations = i_minValueEquations, maxValueEquations = i_maxValueEquations, parameterEquations = i_parameterEquations, algorithmAndEquationAsserts = i_algorithmAndEquationAsserts, jacobianEquations = i_jacobianEquations, literals = i_literals),
           a_withOperations )
      equation
        txt_1 = CodegenUtil.dotPath(Tpl.emptyTxt, i_mi_name);
        ret_2 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_1));
        l_name = Tpl.writeStr(Tpl.emptyTxt, ret_2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n",
                                    "<?xml-stylesheet type=\"application/xml\" href=\"tasksystemdump.xsl\"?>\n",
                                    "<tasksystemdump model=\""
                                }, false));
        txt = Tpl.writeText(txt, l_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\">\n",
                                    "<initial-equations size=\""
                                }, false));
        ret_3 = listLength(i_initialEquations);
        txt = Tpl.writeStr(txt, intString(ret_3));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_4 = SimCodeUtil.sortEqSystems(i_initialEquations);
        txt = dumpEqs(txt, ret_4, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</initial-equations>\n",
                                    "<dae-equations size=\""
                                }, false));
        ret_5 = listLength(i_allEquations);
        txt = Tpl.writeStr(txt, intString(ret_5));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_6 = SimCodeUtil.sortEqSystems(i_allEquations);
        txt = dumpEqs(txt, ret_6, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</dae-equations>\n",
                                    "<ode-equations size=\""
                                }, false));
        ret_7 = listGet(i_odeEquations, 1);
        ret_8 = listLength(ret_7);
        txt = Tpl.writeStr(txt, intString(ret_8));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_9 = listGet(i_odeEquations, 1);
        ret_10 = SimCodeUtil.sortEqSystems(ret_9);
        txt = dumpEqs(txt, ret_10, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</ode-equations>\n",
                                    "<alg-equations size=\""
                                }, false));
        ret_11 = listGet(i_algebraicEquations, 1);
        ret_12 = listLength(ret_11);
        txt = Tpl.writeStr(txt, intString(ret_12));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_13 = listGet(i_algebraicEquations, 1);
        ret_14 = SimCodeUtil.sortEqSystems(ret_13);
        txt = dumpEqs(txt, ret_14, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</alg-equations>\n",
                                    "<residual-equations size=\""
                                }, false));
        ret_15 = listLength(i_residualEquations);
        txt = Tpl.writeStr(txt, intString(ret_15));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_16 = SimCodeUtil.sortEqSystems(i_residualEquations);
        txt = dumpEqs(txt, ret_16, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</residual-equations>\n",
                                    "<start-equations size=\""
                                }, false));
        ret_17 = listLength(i_startValueEquations);
        txt = Tpl.writeStr(txt, intString(ret_17));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_18 = SimCodeUtil.sortEqSystems(i_startValueEquations);
        txt = dumpEqs(txt, ret_18, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</start-equations>\n",
                                    "<nominal-equations size=\""
                                }, false));
        ret_19 = listLength(i_nominalValueEquations);
        txt = Tpl.writeStr(txt, intString(ret_19));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_20 = SimCodeUtil.sortEqSystems(i_nominalValueEquations);
        txt = dumpEqs(txt, ret_20, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</nominal-equations>\n",
                                    "<min-equations size=\""
                                }, false));
        ret_21 = listLength(i_minValueEquations);
        txt = Tpl.writeStr(txt, intString(ret_21));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_22 = SimCodeUtil.sortEqSystems(i_minValueEquations);
        txt = dumpEqs(txt, ret_22, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</min-equations>\n",
                                    "<max-equations size=\""
                                }, false));
        ret_23 = listLength(i_maxValueEquations);
        txt = Tpl.writeStr(txt, intString(ret_23));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_24 = SimCodeUtil.sortEqSystems(i_maxValueEquations);
        txt = dumpEqs(txt, ret_24, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</max-equations>\n",
                                    "<parameter-equations size=\""
                                }, false));
        ret_25 = listLength(i_parameterEquations);
        txt = Tpl.writeStr(txt, intString(ret_25));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_26 = SimCodeUtil.sortEqSystems(i_parameterEquations);
        txt = dumpEqs(txt, ret_26, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</parameter-equations>\n",
                                    "<assertions size=\""
                                }, false));
        ret_27 = listLength(i_algorithmAndEquationAsserts);
        txt = Tpl.writeStr(txt, intString(ret_27));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_28 = SimCodeUtil.sortEqSystems(i_algorithmAndEquationAsserts);
        txt = dumpEqs(txt, ret_28, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</assertions>\n",
                                    "<jacobian-equations>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        ret_29 = SimCodeUtil.sortEqSystems(i_jacobianEquations);
        txt = dumpEqs(txt, ret_29, 0, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</jacobian-equations>\n",
                                    "<literals size=\""
                                }, false));
        ret_30 = listLength(i_literals);
        txt = Tpl.writeStr(txt, intString(ret_30));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_39(txt, i_literals);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</literals>\n",
                                    "<functions size=\""
                                }, false));
        ret_31 = listLength(i_mi_functions);
        txt = Tpl.writeStr(txt, intString(ret_31));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_41(txt, i_mi_functions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</functions>\n",
                                    "</tasksystemdump>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end tasksystemdump_dispatch;

public function eqIndex
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      Integer i_index;

    case ( txt,
           SimCode.SES_RESIDUAL(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ARRAY_CALL_ASSIGN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_MIXED(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_WHEN(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           SimCode.SES_IFEQUATION(index = i_index) )
      equation
        txt = Tpl.writeStr(txt, intString(i_index));
      then txt;

    case ( txt,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("TaskSystemDump.tpl", 91, 16), "dumpEqs: Unknown equation");
      then txt;
  end match;
end eqIndex;

protected function fun_44
  input Tpl.Text in_txt;
  input Boolean in_mArg;
  input Integer in_a_parent;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_mArg, in_a_parent)
    local
      Tpl.Text txt;
      Integer a_parent;

    case ( txt,
           false,
           a_parent )
      equation
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("parent=\""));
        txt = Tpl.writeStr(txt, intString(a_parent));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = Tpl.popBlock(txt);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end fun_44;

public function hasParent
  input Tpl.Text txt;
  input Integer a_parent;

  output Tpl.Text out_txt;
protected
  Boolean ret_0;
algorithm
  ret_0 := intEq(a_parent, 0);
  out_txt := fun_44(txt, ret_0, a_parent);
end hasParent;

protected function lm_46
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Statement> rest;
      DAE.Statement i_stmt;
      String ret_1;
      String ret_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_stmt :: rest )
      equation
        ret_0 = DAEDump.ppStmtStr(i_stmt, 2);
        ret_1 = Util.escapeModelicaStringToXmlString(ret_0);
        txt = Tpl.writeStr(txt, ret_1);
        txt = lm_46(txt, rest);
      then txt;
  end match;
end lm_46;

protected function lm_47
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_47(txt, rest);
      then txt;
  end match;
end lm_47;

protected function lm_48
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_depends;
  input Tpl.Text in_a_defines;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_depends;
  output Tpl.Text out_a_defines;
algorithm
  (out_txt, out_a_depends, out_a_defines) :=
  match(in_txt, in_items, in_a_depends, in_a_defines)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_depends;
      Tpl.Text a_defines;
      SimCode.SimEqSystem i_reseq;

    case ( txt,
           {},
           a_depends,
           a_defines )
      then (txt, a_depends, a_defines);

    case ( txt,
           i_reseq :: rest,
           a_depends,
           a_defines )
      equation
        (txt, a_defines, a_depends) = eqDefinesDepends(txt, i_reseq, a_defines, a_depends);
        (txt, a_depends, a_defines) = lm_48(txt, rest, a_depends, a_defines);
      then (txt, a_depends, a_defines);
  end match;
end lm_48;

protected function lm_49
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_depends;
  input Tpl.Text in_a_defines;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_depends;
  output Tpl.Text out_a_defines;
algorithm
  (out_txt, out_a_depends, out_a_defines) :=
  match(in_txt, in_items, in_a_depends, in_a_defines)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_depends;
      Tpl.Text a_defines;
      SimCode.SimEqSystem i_jeq;

    case ( txt,
           {},
           a_depends,
           a_defines )
      then (txt, a_depends, a_defines);

    case ( txt,
           i_jeq :: rest,
           a_depends,
           a_defines )
      equation
        (txt, a_defines, a_depends) = eqDefinesDepends(txt, i_jeq, a_defines, a_depends);
        (txt, a_depends, a_defines) = lm_49(txt, rest, a_depends, a_defines);
      then (txt, a_depends, a_defines);
  end match;
end lm_49;

protected function fun_50
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_e_jacobianMatrix;
  input Tpl.Text in_a_depends;
  input Tpl.Text in_a_defines;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_depends;
  output Tpl.Text out_a_defines;
algorithm
  (out_txt, out_a_depends, out_a_defines) :=
  match(in_txt, in_a_e_jacobianMatrix, in_a_depends, in_a_defines)
    local
      Tpl.Text txt;
      Tpl.Text a_depends;
      Tpl.Text a_defines;
      list<SimCode.SimEqSystem> i_eqns;
      list<SimCode.SimEqSystem> ret_1;
      Tpl.Text l_0__;

    case ( txt,
           SOME(({(i_eqns, _, _)}, _, _, _, _, _, _)),
           a_depends,
           a_defines )
      equation
        ret_1 = SimCodeUtil.sortEqSystems(i_eqns);
        (l_0__, a_depends, a_defines) = lm_49(Tpl.emptyTxt, ret_1, a_depends, a_defines);
      then (txt, a_depends, a_defines);

    case ( txt,
           _,
           a_depends,
           a_defines )
      then (txt, a_depends, a_defines);
  end match;
end fun_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<eq index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;
  end match;
end lm_51;

protected function lm_52
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<eq index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_52(txt, rest);
      then txt;
  end match;
end lm_52;

protected function fun_53
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_e_jacobianMatrix;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_e_jacobianMatrix)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> i_eqns;

    case ( txt,
           SOME(({(i_eqns, _, _)}, _, _, _, _, _, _)) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_52(txt, i_eqns);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest);
      then txt;
  end match;
end lm_54;

protected function lm_55
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_depends;
  input Tpl.Text in_a_defines;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_depends;
  output Tpl.Text out_a_defines;
algorithm
  (out_txt, out_a_depends, out_a_defines) :=
  match(in_txt, in_items, in_a_depends, in_a_defines)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_depends;
      Tpl.Text a_defines;
      SimCode.SimEqSystem i_nleq;

    case ( txt,
           {},
           a_depends,
           a_defines )
      then (txt, a_depends, a_defines);

    case ( txt,
           i_nleq :: rest,
           a_depends,
           a_defines )
      equation
        (txt, a_defines, a_depends) = eqDefinesDepends(txt, i_nleq, a_defines, a_depends);
        (txt, a_depends, a_defines) = lm_55(txt, rest, a_depends, a_defines);
      then (txt, a_depends, a_defines);
  end match;
end lm_55;

protected function lm_56
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_a_depends;
  input Tpl.Text in_a_defines;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_depends;
  output Tpl.Text out_a_defines;
algorithm
  (out_txt, out_a_depends, out_a_defines) :=
  match(in_txt, in_items, in_a_depends, in_a_defines)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Tpl.Text a_depends;
      Tpl.Text a_defines;
      SimCode.SimEqSystem i_jeq;

    case ( txt,
           {},
           a_depends,
           a_defines )
      then (txt, a_depends, a_defines);

    case ( txt,
           i_jeq :: rest,
           a_depends,
           a_defines )
      equation
        (txt, a_defines, a_depends) = eqDefinesDepends(txt, i_jeq, a_defines, a_depends);
        (txt, a_depends, a_defines) = lm_56(txt, rest, a_depends, a_defines);
      then (txt, a_depends, a_defines);
  end match;
end lm_56;

protected function fun_57
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_e_jacobianMatrix;
  input Tpl.Text in_a_depends;
  input Tpl.Text in_a_defines;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_depends;
  output Tpl.Text out_a_defines;
algorithm
  (out_txt, out_a_depends, out_a_defines) :=
  match(in_txt, in_a_e_jacobianMatrix, in_a_depends, in_a_defines)
    local
      Tpl.Text txt;
      Tpl.Text a_depends;
      Tpl.Text a_defines;
      list<SimCode.SimEqSystem> i_eqns;
      list<SimCode.SimEqSystem> ret_1;
      Tpl.Text l_0__;

    case ( txt,
           SOME(({(i_eqns, _, _)}, _, _, _, _, _, _)),
           a_depends,
           a_defines )
      equation
        ret_1 = SimCodeUtil.sortEqSystems(i_eqns);
        (l_0__, a_depends, a_defines) = lm_56(Tpl.emptyTxt, ret_1, a_depends, a_defines);
      then (txt, a_depends, a_defines);

    case ( txt,
           _,
           a_depends,
           a_defines )
      then (txt, a_depends, a_defines);
  end match;
end fun_57;

protected function fun_58
  input Tpl.Text in_txt;
  input Option<SimCode.JacobianMatrix> in_a_e_jacobianMatrix;
  input Boolean in_a_withOperations;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_e_jacobianMatrix, in_a_withOperations, in_a_e_index)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      Integer a_e_index;
      list<SimCode.SimEqSystem> i_eqns;
      list<SimCode.SimEqSystem> ret_0;

    case ( txt,
           SOME(({(i_eqns, _, _)}, _, _, _, _, _, _)),
           a_withOperations,
           a_e_index )
      equation
        ret_0 = SimCodeUtil.sortEqSystems(i_eqns);
        txt = dumpEqs(txt, ret_0, a_e_index, a_withOperations);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end match;
end fun_58;

protected function lm_59
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<eq index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_59(txt, rest);
      then txt;
  end match;
end lm_59;

protected function lm_60
  input Tpl.Text in_txt;
  input list<SimCodeVar.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCodeVar.SimVar> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCodeVar.SIMVAR(name = i_cr) :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_60(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = lm_60(txt, rest);
      then txt;
  end match;
end lm_60;

protected function lm_61
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_eq :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<discrete index=\""));
        txt = eqIndex(txt, i_eq);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = lm_61(txt, rest);
      then txt;
  end match;
end lm_61;

protected function lm_62
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cond;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cond :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<cond>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cond);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</cond>"));
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;
  end match;
end lm_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<depends name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest);
      then txt;
  end match;
end lm_63;

protected function lm_64
  input Tpl.Text in_txt;
  input list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> in_items;
  input Boolean in_a_withOperations;
  input Integer in_a_e_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations, in_a_e_index)
    local
      Tpl.Text txt;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> rest;
      Boolean a_withOperations;
      Integer a_e_index;
      list<SimCode.SimEqSystem> i_eqs;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           (_, i_eqs) :: rest,
           a_withOperations,
           a_e_index )
      equation
        txt = dumpEqs(txt, i_eqs, a_e_index, a_withOperations);
        txt = lm_64(txt, rest, a_withOperations, a_e_index);
      then txt;
  end match;
end lm_64;

protected function fun_65
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Boolean in_a_withOperations;
  input Integer in_a_parent;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq, in_a_withOperations, in_a_parent)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      Integer a_parent;
      list<SimCode.SimEqSystem> i_elsebranch;
      list<tuple<DAE.Exp, list<SimCode.SimEqSystem>>> i_ifbranches;
      DAE.Exp i_e_right;
      DAE.ComponentRef i_e_left;
      list<DAE.ComponentRef> i_conditions;
      SimCode.SimEqSystem i_e_cont;
      list<SimCodeVar.SimVar> i_e_discVars;
      list<SimCode.SimEqSystem> i_e_discEqs;
      Integer i_indexNonLinearSystem;
      Integer i_e_index;
      list<SimCode.SimEqSystem> i_e_eqs;
      list<DAE.ComponentRef> i_e_crefs;
      list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
      Option<SimCode.JacobianMatrix> i_e_jacobianMatrix;
      list<SimCode.SimEqSystem> i_e_residual;
      list<SimCodeVar.SimVar> i_e_vars;
      list<DAE.Statement> i_e_statements;
      DAE.ComponentRef i_e_componentRef;
      DAE.Exp i_e_exp;
      SimCode.SimEqSystem i_e;
      Tpl.Text l_elsebr;
      Tpl.Text l_branches;
      list<DAE.ComponentRef> ret_13;
      list<SimCode.SimEqSystem> ret_12;
      Integer ret_11;
      Integer ret_10;
      list<SimCode.SimEqSystem> ret_9;
      Integer ret_8;
      Integer ret_7;
      Tpl.Text l_0___1;
      list<SimCode.SimEqSystem> ret_5;
      tuple<list<DAE.ComponentRef>, list<DAE.ComponentRef>> ret_4;
      Tpl.Text l_uniqcrefs;
      Tpl.Text l_0__;
      Tpl.Text l_depends;
      Tpl.Text l_defines;

    case ( txt,
           (i_e as SimCode.SES_RESIDUAL(exp = i_e_exp)),
           _,
           a_parent )
      equation
        l_defines = Tpl.emptyTxt;
        l_depends = Tpl.emptyTxt;
        (l_0__, l_defines, l_depends) = eqDefinesDepends(Tpl.emptyTxt, i_e, l_defines, l_depends);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "  <residual>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_defines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_depends);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<rhs>"));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </residual>\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_SIMPLE_ASSIGN(exp = i_e_exp)),
           _,
           a_parent )
      equation
        l_defines = Tpl.emptyTxt;
        l_depends = Tpl.emptyTxt;
        (l_0__, l_defines, l_depends) = eqDefinesDepends(Tpl.emptyTxt, i_e, l_defines, l_depends);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "  <assign>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_defines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_depends);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<rhs>"));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </assign>\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ARRAY_CALL_ASSIGN(componentRef = i_e_componentRef, exp = i_e_exp)),
           _,
           a_parent )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "  <assign type=\"array\">\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_e_componentRef);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\" />\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </assign>\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           SimCode.SES_ALGORITHM(statements = {}),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("empty algorithm"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_ALGORITHM(statements = (i_e_statements as _ :: _))),
           _,
           a_parent )
      equation
        ret_4 = Expression.extractUniqueCrefsFromStatmentS(i_e_statements);
        l_uniqcrefs = getdependcies(Tpl.emptyTxt, ret_4);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "  <statement>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeText(txt, l_uniqcrefs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<stmt>\n"));
        txt = lm_46(txt, i_e_statements);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</stmt>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </statement>\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_LINEAR(vars = i_e_vars, residual = i_e_residual, jacobianMatrix = i_e_jacobianMatrix, simJac = i_simJac)),
           _,
           a_parent )
      equation
        l_defines = Tpl.emptyTxt;
        l_depends = Tpl.emptyTxt;
        l_defines = Tpl.pushIter(l_defines, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_defines = lm_47(l_defines, i_e_vars);
        l_defines = Tpl.popIter(l_defines);
        ret_5 = SimCodeUtil.sortEqSystems(i_e_residual);
        (l_0__, l_depends, l_defines) = lm_48(Tpl.emptyTxt, ret_5, l_depends, l_defines);
        (l_0___1, l_depends, l_defines) = fun_50(Tpl.emptyTxt, i_e_jacobianMatrix, l_depends, l_defines);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<linear size=\""));
        ret_7 = listLength(i_e_vars);
        txt = Tpl.writeStr(txt, intString(ret_7));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" nnz=\""));
        ret_8 = listLength(i_simJac);
        txt = Tpl.writeStr(txt, intString(ret_8));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_defines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_depends);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<residuals>\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_51(txt, i_e_residual);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</residuals>\n",
                                    "<jacobian>\n"
                                }, true));
        txt = fun_53(txt, i_e_jacobianMatrix);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</jacobian>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</linear>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_NONLINEAR(crefs = i_e_crefs, eqs = i_e_eqs, jacobianMatrix = i_e_jacobianMatrix, index = i_e_index, indexNonLinearSystem = i_indexNonLinearSystem)),
           a_withOperations,
           a_parent )
      equation
        l_defines = Tpl.emptyTxt;
        l_depends = Tpl.emptyTxt;
        l_defines = Tpl.pushIter(l_defines, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        l_defines = lm_54(l_defines, i_e_crefs);
        l_defines = Tpl.popIter(l_defines);
        ret_9 = SimCodeUtil.sortEqSystems(i_e_eqs);
        (l_0__, l_depends, l_defines) = lm_55(Tpl.emptyTxt, ret_9, l_depends, l_defines);
        (l_0___1, l_depends, l_defines) = fun_57(Tpl.emptyTxt, i_e_jacobianMatrix, l_depends, l_defines);
        txt = fun_58(txt, i_e_jacobianMatrix, a_withOperations, i_e_index);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<nonlinear indexNonlinear=\""));
        txt = Tpl.writeStr(txt, intString(i_indexNonLinearSystem));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, l_defines);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_depends);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_59(txt, i_e_eqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</nonlinear>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_MIXED(discEqs = i_e_discEqs, discVars = i_e_discVars, cont = i_e_cont, index = i_e_index)),
           a_withOperations,
           a_parent )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<mixed size=\""));
        ret_10 = listLength(i_e_discEqs);
        ret_11 = intAdd(ret_10, 1);
        txt = Tpl.writeStr(txt, intString(ret_11));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_60(txt, i_e_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = lm_61(txt, i_e_discEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<continuous index=\""));
        txt = eqIndex(txt, i_e_cont);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</mixed>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</equation>"));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        ret_12 = List.fill(i_e_cont, 1);
        txt = dumpEqs(txt, ret_12, i_e_index, a_withOperations);
        txt = Tpl.softNewLine(txt);
        txt = dumpEqs(txt, i_e_discEqs, i_e_index, a_withOperations);
      then txt;

    case ( txt,
           (i_e as SimCode.SES_WHEN(conditions = i_conditions, left = i_e_left, right = i_e_right)),
           _,
           a_parent )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "<when>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_62(txt, i_conditions);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_e_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\" />\n"));
        ret_13 = Expression.extractUniqueCrefsFromExpDerPreStart(i_e_right);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_63(txt, ret_13);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<rhs>"));
        txt = printExpStrEscaped(txt, i_e_right);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</when>\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           (i_e as SimCode.SES_IFEQUATION(ifbranches = i_ifbranches, index = i_e_index, elsebranch = i_elsebranch)),
           a_withOperations,
           a_parent )
      equation
        l_branches = lm_64(Tpl.emptyTxt, i_ifbranches, a_withOperations, i_e_index);
        l_elsebr = dumpEqs(Tpl.emptyTxt, i_elsebranch, i_e_index, a_withOperations);
        txt = Tpl.writeText(txt, l_branches);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, l_elsebr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<equation index=\""));
        txt = eqIndex(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        txt = hasParent(txt, a_parent);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ">\n",
                                    "<ifequation /> <!-- TODO: Fix me -->\n",
                                    "</equation>"
                                }, false));
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = CodegenUtil.error(txt, Tpl.sourceInfo("TaskSystemDump.tpl", 232, 16), "dumpEqs: Unknown equation");
      then txt;
  end match;
end fun_65;

protected function lm_66
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Boolean in_a_withOperations;
  input Integer in_a_parent;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_withOperations, in_a_parent)
    local
      Tpl.Text txt;
      list<SimCode.SimEqSystem> rest;
      Boolean a_withOperations;
      Integer a_parent;
      SimCode.SimEqSystem i_eq;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_eq :: rest,
           a_withOperations,
           a_parent )
      equation
        txt = fun_65(txt, i_eq, a_withOperations, a_parent);
        txt = lm_66(txt, rest, a_withOperations, a_parent);
      then txt;
  end match;
end lm_66;

public function dumpEqs
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> a_eqs;
  input Integer a_parent;
  input Boolean a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt := lm_66(txt, a_eqs, a_withOperations, a_parent);
end dumpEqs;

protected function lm_68
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<defines name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest);
      then txt;
  end match;
end lm_68;

protected function lm_69
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<depends name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_69(txt, rest);
      then txt;
  end match;
end lm_69;

public function getdependcies
  input Tpl.Text in_txt;
  input tuple<list<DAE.ComponentRef>, list<DAE.ComponentRef>> in_a_ocrefs;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_ocrefs)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> i_orhscrefs;
      list<DAE.ComponentRef> i_olhscrefs;

    case ( txt,
           (i_olhscrefs, i_orhscrefs) )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_68(txt, i_olhscrefs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_69(txt, i_orhscrefs);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Error Printing dependenices"));
      then txt;
  end match;
end getdependcies;

protected function lm_71
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<depends name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
        txt = Tpl.nextIter(txt);
        txt = lm_71(txt, rest);
      then txt;
  end match;
end lm_71;

protected function lm_72
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<depends name=\""));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" />"));
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;
  end match;
end lm_72;

public function eqDefinesDepends
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_a_eq;
  input Tpl.Text in_a_defines;
  input Tpl.Text in_a_depends;

  output Tpl.Text out_txt;
  output Tpl.Text out_a_defines;
  output Tpl.Text out_a_depends;
algorithm
  (out_txt, out_a_defines, out_a_depends) :=
  match(in_txt, in_a_eq, in_a_defines, in_a_depends)
    local
      Tpl.Text txt;
      Tpl.Text a_defines;
      Tpl.Text a_depends;
      DAE.ComponentRef i_e_cref;
      DAE.Exp i_e_exp;
      list<DAE.ComponentRef> ret_1;
      list<DAE.ComponentRef> ret_0;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_e_exp),
           a_defines,
           a_depends )
      equation
        ret_0 = Expression.extractUniqueCrefsFromExpDerPreStart(i_e_exp);
        a_depends = Tpl.pushIter(a_depends, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        a_depends = lm_71(a_depends, ret_0);
        a_depends = Tpl.popIter(a_depends);
      then (txt, a_defines, a_depends);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_e_cref, exp = i_e_exp),
           a_defines,
           a_depends )
      equation
        a_defines = Tpl.writeTok(a_defines, Tpl.ST_STRING("<defines name=\""));
        a_defines = CodegenUtil.crefStrNoUnderscore(a_defines, i_e_cref);
        a_defines = Tpl.writeTok(a_defines, Tpl.ST_STRING("\"/>"));
        a_defines = Tpl.writeTok(a_defines, Tpl.ST_NEW_LINE());
        ret_1 = Expression.extractUniqueCrefsFromExpDerPreStart(i_e_exp);
        a_depends = Tpl.pushIter(a_depends, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        a_depends = lm_72(a_depends, ret_1);
        a_depends = Tpl.popIter(a_depends);
      then (txt, a_defines, a_depends);

    case ( txt,
           _,
           a_defines,
           a_depends )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Unrecognized Equation in eqDefinesDepends"));
      then (txt, a_defines, a_depends);
  end match;
end eqDefinesDepends;

public function dumpWithin
  input Tpl.Text in_txt;
  input Absyn.Within in_a_w;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_w)
    local
      Tpl.Text txt;
      Absyn.Path i_path;

    case ( txt,
           Absyn.TOP() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("within ;"));
      then txt;

    case ( txt,
           Absyn.WITHIN(path = i_path) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("within "));
        txt = CodegenUtil.dotPath(txt, i_path);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpWithin;

protected function lm_75
  input Tpl.Text in_txt;
  input list<Absyn.Within> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Within> rest;
      Absyn.Within i_w;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_w :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<part-of>"));
        txt = dumpWithin(txt, i_w);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</part-of>"));
        txt = lm_75(txt, rest);
      then txt;
  end match;
end lm_75;

protected function fun_76
  input Tpl.Text in_txt;
  input Option<DAE.ComponentRef> in_a_s_instanceOpt;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_s_instanceOpt)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cr;

    case ( txt,
           SOME(i_cr) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<instance>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</instance>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_76;

protected function lm_77
  input Tpl.Text in_txt;
  input list<Option<tuple<DAE.ComponentRef, DAE.ComponentRef>>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Option<tuple<DAE.ComponentRef, DAE.ComponentRef>>> rest;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           _ :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<connect-equation />"));
        txt = lm_77(txt, rest);
      then txt;
  end match;
end lm_77;

protected function lm_78
  input Tpl.Text in_txt;
  input list<Absyn.Path> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Absyn.Path> rest;
      Absyn.Path i_p;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_p :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<type>"));
        txt_0 = CodegenUtil.dotPath(Tpl.emptyTxt, i_p);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</type>"));
        txt = Tpl.nextIter(txt);
        txt = lm_78(txt, rest);
      then txt;
  end match;
end lm_78;

protected function lm_79
  input Tpl.Text in_txt;
  input list<DAE.SymbolicOperation> in_items;
  input Absyn.Info in_a_s_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items, in_a_s_info)
    local
      Tpl.Text txt;
      list<DAE.SymbolicOperation> rest;
      Absyn.Info a_s_info;
      DAE.SymbolicOperation i_op;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_op :: rest,
           a_s_info )
      equation
        txt = dumpOperation(txt, i_op, a_s_info);
        txt = Tpl.nextIter(txt);
        txt = lm_79(txt, rest, a_s_info);
      then txt;
  end match;
end lm_79;

protected function fun_80
  input Tpl.Text in_txt;
  input Boolean in_a_withOperations;
  input Absyn.Info in_a_s_info;
  input list<DAE.SymbolicOperation> in_a_s_operations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_withOperations, in_a_s_info, in_a_s_operations)
    local
      Tpl.Text txt;
      Absyn.Info a_s_info;
      list<DAE.SymbolicOperation> a_s_operations;

    case ( txt,
           false,
           _,
           _ )
      then txt;

    case ( txt,
           _,
           a_s_info,
           a_s_operations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<operations>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_79(txt, a_s_operations, a_s_info);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</operations>"));
      then txt;
  end match;
end fun_80;

public function dumpElementSource
  input Tpl.Text in_txt;
  input DAE.ElementSource in_a_source;
  input Boolean in_a_withOperations;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_source, in_a_withOperations)
    local
      Tpl.Text txt;
      Boolean a_withOperations;
      Absyn.Info i_s_info;
      list<DAE.SymbolicOperation> i_s_operations;
      list<Absyn.Path> i_s_typeLst;
      list<Option<tuple<DAE.ComponentRef, DAE.ComponentRef>>> i_s_connectEquationOptLst;
      Option<DAE.ComponentRef> i_s_instanceOpt;
      list<Absyn.Within> i_s_partOfLst;
      Absyn.Info i_info;

    case ( txt,
           DAE.SOURCE(info = (i_info as (i_s_info as Absyn.INFO(fileName = _))), partOfLst = i_s_partOfLst, instanceOpt = i_s_instanceOpt, connectEquationOptLst = i_s_connectEquationOptLst, typeLst = i_s_typeLst, operations = i_s_operations),
           a_withOperations )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<source>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = dumpInfo(txt, i_info);
        txt = Tpl.softNewLine(txt);
        txt = lm_75(txt, i_s_partOfLst);
        txt = Tpl.softNewLine(txt);
        txt = fun_76(txt, i_s_instanceOpt);
        txt = Tpl.softNewLine(txt);
        txt = lm_77(txt, i_s_connectEquationOptLst);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_78(txt, i_s_typeLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</source>\n"));
        txt = fun_80(txt, a_withOperations, i_s_info, i_s_operations);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end match;
end dumpElementSource;

protected function fun_82
  input Tpl.Text in_txt;
  input Option<DAE.Element> in_a_dae;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_dae)
    local
      Tpl.Text txt;
      DAE.Element i_dae;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           SOME(i_dae) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<flattened>"));
        txt_0 = DAEDumpTpl.dumpEquationElement(Tpl.emptyTxt, i_dae);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</flattened>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end fun_82;

protected function lm_83
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_target;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_target :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        txt = printExpStrEscaped(txt, i_target);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</exp>"));
        txt = Tpl.nextIter(txt);
        txt = lm_83(txt, rest);
      then txt;
  end match;
end lm_83;

protected function lm_84
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_v;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_v :: rest )
      equation
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_v);
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest);
      then txt;
  end match;
end lm_84;

protected function lm_85
  input Tpl.Text in_txt;
  input list<Real> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Real> rest;
      Real i_r;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_r :: rest )
      equation
        txt = Tpl.writeStr(txt, realString(i_r));
        txt = Tpl.nextIter(txt);
        txt = lm_85(txt, rest);
      then txt;
  end match;
end lm_85;

protected function lm_86
  input Tpl.Text in_txt;
  input list<Real> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Real> rest;
      Real i_r;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_r :: rest )
      equation
        txt = Tpl.writeStr(txt, realString(i_r));
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest);
      then txt;
  end match;
end lm_86;

protected function lm_87
  input Tpl.Text in_txt;
  input list<list<Real>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<list<Real>> rest;
      list<Real> i_row;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_row :: rest )
      equation
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_86(txt, i_row);
        txt = Tpl.popIter(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_87(txt, rest);
      then txt;
  end match;
end lm_87;

protected function lm_88
  input Tpl.Text in_txt;
  input list<Real> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<Real> rest;
      Real i_r;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_r :: rest )
      equation
        txt = Tpl.writeStr(txt, realString(i_r));
        txt = Tpl.nextIter(txt);
        txt = lm_88(txt, rest);
      then txt;
  end match;
end lm_88;

protected function lm_89
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.Exp> rest;
      DAE.Exp i_cond;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cond :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<assertion>"));
        txt = printExpStrEscaped(txt, i_cond);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</assertion>"));
        txt = Tpl.nextIter(txt);
        txt = lm_89(txt, rest);
      then txt;
  end match;
end lm_89;

protected function lm_90
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_items)
    local
      Tpl.Text txt;
      list<DAE.ComponentRef> rest;
      DAE.ComponentRef i_cr;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_cr :: rest )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<candidate>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</candidate>"));
        txt = Tpl.nextIter(txt);
        txt = lm_90(txt, rest);
      then txt;
  end match;
end lm_90;

public function dumpOperation
  input Tpl.Text in_txt;
  input DAE.SymbolicOperation in_a_op;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_op, in_a_info)
    local
      Tpl.Text txt;
      Absyn.Info a_info;
      list<DAE.ComponentRef> i_op_candidates;
      DAE.ComponentRef i_op_chosen;
      DAE.Exp i_e;
      DAE.Exp i_e2;
      DAE.Exp i_e1;
      DAE.Exp i_op_after_1;
      DAE.Exp i_op_before_1;
      list<DAE.Exp> i_op_assertConds;
      DAE.Exp i_op_res;
      DAE.Exp i_op_exp2;
      DAE.Exp i_op_exp1;
      list<Real> i_rhs;
      list<list<Real>> i_jac;
      list<Real> i_result;
      list<DAE.ComponentRef> i_vars;
      DAE.Exp i_op_exp;
      DAE.ComponentRef i_op_cr;
      Integer i_op_index;
      DAE.EquationExp i_op_after;
      DAE.EquationExp i_op_before;
      list<DAE.Exp> i_substitutions;
      DAE.Exp i_source;
      DAE.EquationExp i_after;
      DAE.EquationExp i_before;
      Option<DAE.Element> i_dae;
      SCode.EEquation i_scode;
      list<DAE.Exp> ret_2;
      String ret_1;
      Tpl.Text txt_0;

    case ( txt,
           DAE.FLATTEN(scode = i_scode, dae = i_dae),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<flattening>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<original>"));
        txt_0 = SCodeDumpTpl.dumpEEquation(Tpl.emptyTxt, i_scode, SCodeDump.defaultOptions);
        ret_1 = Util.escapeModelicaStringToXmlString(Tpl.textString(txt_0));
        txt = Tpl.writeStr(txt, ret_1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</original>\n"));
        txt = fun_82(txt, i_dae);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</flattening>"));
      then txt;

    case ( txt,
           DAE.SIMPLIFY(before = i_before, after = i_after),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<simplify>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printEquationExpStrEscaped(txt, i_before);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</before>\n",
                                    "<after>"
                                }, false));
        txt = printEquationExpStrEscaped(txt, i_after);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</after>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</simplify>"));
      then txt;

    case ( txt,
           DAE.SUBSTITUTION(source = i_source, substitutions = i_substitutions),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<substitution>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printExpStrEscaped(txt, i_source);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</before>\n"));
        ret_2 = listReverse(i_substitutions);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_83(txt, ret_2);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</substitution>"));
      then txt;

    case ( txt,
           DAE.OP_INLINE(before = i_op_before, after = i_op_after),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<inline>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printEquationExpStrEscaped(txt, i_op_before);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</before>\n",
                                    "<after>"
                                }, false));
        txt = printEquationExpStrEscaped(txt, i_op_after);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</after>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</inline>"));
      then txt;

    case ( txt,
           DAE.OP_SCALARIZE(index = i_op_index, before = i_op_before, after = i_op_after),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<scalarize index=\""));
        txt = Tpl.writeStr(txt, intString(i_op_index));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("\">\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<before>"));
        txt = printEquationExpStrEscaped(txt, i_op_before);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</before>\n",
                                    "<after>"
                                }, false));
        txt = printEquationExpStrEscaped(txt, i_op_after);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</after>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</scalarize>"));
      then txt;

    case ( txt,
           DAE.SOLVED(cr = i_op_cr, exp = i_op_exp),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<solved>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_op_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_exp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</solved>"));
      then txt;

    case ( txt,
           DAE.LINEAR_SOLVED(vars = i_vars, result = i_result, jac = i_jac, rhs = i_rhs),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<linear-solved>\n",
                                    "  simple equation from linear system:\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_84(txt, i_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = ["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_85(txt, i_result);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "]\n",
                                    "[\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_87(txt, i_jac);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  *\n",
                                    "    X\n",
                                    "  =\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_STRING(" ; ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_88(txt, i_rhs);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("]\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</linear-solved>"));
      then txt;

    case ( txt,
           DAE.SOLVE(exp1 = i_op_exp1, exp2 = i_op_exp2, cr = i_op_cr, res = i_op_res, assertConds = i_op_assertConds),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "<solve>\n",
                                    "  <old>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = printExpStrEscaped(txt, i_op_exp1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_exp2);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </old>\n",
                                    "  <new>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_op_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_res);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</rhs>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </new>\n",
                                    "  <assertions>\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_89(txt, i_op_assertConds);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  </assertions>\n",
                                    "</solve>"
                                }, false));
      then txt;

    case ( txt,
           DAE.OP_DIFFERENTIATE(before = i_op_before_1, cr = i_op_cr, after = i_op_after_1),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<derivative>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<exp>"));
        txt = printExpStrEscaped(txt, i_op_before_1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</exp>\n",
                                    "<with-respect-to>"
                                }, false));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_op_cr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</with-respect-to>\n",
                                    "<result>"
                                }, false));
        txt = printExpStrEscaped(txt, i_op_after_1);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</result>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</derivative>"));
      then txt;

    case ( txt,
           DAE.OP_RESIDUAL(e1 = i_e1, e2 = i_e2, e = i_e),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<op-residual>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<lhs>"));
        txt = printExpStrEscaped(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</lhs>\n",
                                    "<rhs>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "</rhs>\n",
                                    "<result>"
                                }, false));
        txt = printExpStrEscaped(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</result>\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</op-residual>"));
      then txt;

    case ( txt,
           DAE.NEW_DUMMY_DER(chosen = i_op_chosen, candidates = i_op_candidates),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("<dummyderivative>\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<chosen>"));
        txt = CodegenUtil.crefStrNoUnderscore(txt, i_op_chosen);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("</chosen>\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE(), SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_90(txt, i_op_candidates);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("</dummyderivative>"));
      then txt;

    case ( txt,
           _,
           a_info )
      equation
        Tpl.addSourceTemplateError("Unknown operation", a_info);
      then txt;
  end match;
end dumpOperation;

public function dumpInfo
  input Tpl.Text in_txt;
  input Absyn.Info in_a_info;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_info)
    local
      Tpl.Text txt;
      Integer i_info_columnNumberEnd;
      Integer i_info_columnNumberStart;
      Integer i_info_lineNumberEnd;
      Integer i_info_lineNumberStart;
      String i_info_fileName;
      String ret_0;

    case ( txt,
           Absyn.INFO(fileName = i_info_fileName, lineNumberStart = i_info_lineNumberStart, lineNumberEnd = i_info_lineNumberEnd, columnNumberStart = i_info_columnNumberStart, columnNumberEnd = i_info_columnNumberEnd) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("<info file=\""));
        ret_0 = Util.escapeModelicaStringToXmlString(i_info_fileName);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" lineStart=\""));
        txt = Tpl.writeStr(txt, intString(i_info_lineNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" lineEnd=\""));
        txt = Tpl.writeStr(txt, intString(i_info_lineNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" colStart=\""));
        txt = Tpl.writeStr(txt, intString(i_info_columnNumberStart));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\" colEnd=\""));
        txt = Tpl.writeStr(txt, intString(i_info_columnNumberEnd));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"/>"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end dumpInfo;

public function printExpStrEscaped
  input Tpl.Text txt;
  input DAE.Exp a_exp;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  ret_0 := ExpressionDump.printExpStr(a_exp);
  ret_1 := Util.escapeModelicaStringToXmlString(ret_0);
  out_txt := Tpl.writeStr(txt, ret_1);
end printExpStrEscaped;

public function printEquationExpStrEscaped
  input Tpl.Text in_txt;
  input DAE.EquationExp in_a_eq;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  match(in_txt, in_a_eq)
    local
      Tpl.Text txt;
      DAE.Exp i_rhs;
      DAE.Exp i_lhs;
      DAE.Exp i_exp;

    case ( txt,
           DAE.PARTIAL_EQUATION(exp = i_exp) )
      equation
        txt = printExpStrEscaped(txt, i_exp);
      then txt;

    case ( txt,
           DAE.RESIDUAL_EXP(exp = i_exp) )
      equation
        txt = printExpStrEscaped(txt, i_exp);
      then txt;

    case ( txt,
           DAE.EQUALITY_EXPS(lhs = i_lhs, rhs = i_rhs) )
      equation
        txt = printExpStrEscaped(txt, i_lhs);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = printExpStrEscaped(txt, i_rhs);
      then txt;

    case ( txt,
           _ )
      then txt;
  end match;
end printEquationExpStrEscaped;

annotation(__OpenModelica_Interface="backend");
end TaskSystemDump;