// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; comment-column: 35; -*-

//-----------------------------------------------------------------------------
// eoParticleBestInit.h
// (c) OPAC 2007
/*
    Contact: paradiseo-help@lists.gforge.inria.fr
 */
//-----------------------------------------------------------------------------

#ifndef _EOPARTICLEBESTINIT_H
#define _EOPARTICLEBESTINIT_H

//-----------------------------------------------------------------------------
#include <eoFunctor.h>
//-----------------------------------------------------------------------------

/**
 * Abstract class for particle best position initialization.
 */

template < class POT > class eoParticleBestInit:public eoUF < POT &, void >
{
public:

    /** Apply the initialization to a whole given population */
    virtual void apply (eoPop < POT > &_pop)
    {
        for (unsigned i = 0; i < _pop.size (); i++)
        {
            operator  ()(_pop[i]);
        }

    }

};

/**
 * Initializes the best positions of a particle as its current positions and set the
 * particle best fitness.
 */
template < class POT > class eoFirstIsBestInit:public eoParticleBestInit <POT>
{

public:

    /** Default CTor */
    eoFirstIsBestInit (){}

    void operator  () (POT & _po1)
    {
        for (unsigned i = 0; i < _po1.size (); i++)
            _po1.bestPositions[i] = _po1[i];

        // set the fitness
        _po1.best(_po1.fitness());
    }

};

#endif /*_EOPARTICLEBESTINIT_H */


