/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;

public class PlotPNGImage {
    protected File _file = null;
    protected File _directory = null;
    public PlotBox plot = new Plot();
    protected static boolean _test = false;

    public PlotPNGImage(String[] args) {
        this.plot.setBackground(new Color(0xE5E5E5));
        try {
            this._parseArgs(args);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CmdLineArgException cmdLineArgException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file = new File("omc_tmp_plot.png");
        try {
            FileOutputStream fout = new FileOutputStream(file);
            this.plot.exportPNG(fout);
            fout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        new PlotPNGImage(args);
    }

    protected int _parseArgs(String[] args) throws CmdLineArgException, FileNotFoundException, IOException {
        int i = 0;
        String title = "Ptolemy plot";
        int width = 500;
        int height = 300;
        while (args != null && i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("-height")) {
                if (i > args.length - 1) {
                    throw new CmdLineArgException(this._usage());
                }
                height = Integer.valueOf(args[i++]);
                continue;
            }
            if (arg.equals("-help")) {
                System.out.println(this._usage());
                System.exit(0);
                continue;
            }
            if (arg.equals("-test")) {
                _test = true;
                continue;
            }
            if (arg.equals("-version")) {
                System.out.println("Version 5.5, Build $Id: PlotApplication.java,v 1.61 2005/04/25 22:49:27 cxh Exp $");
                System.exit(0);
                continue;
            }
            if (arg.equals("-width")) {
                if (i > args.length - 1) {
                    throw new CmdLineArgException("-width requires an integer argument");
                }
                width = Integer.valueOf(args[i++]);
                continue;
            }
            if (arg.equals("")) continue;
            if (arg.equals("-")) {
                URL base = new URL("file", null, "standard input");
                this._read(base, System.in);
                continue;
            }
            if (!arg.startsWith("-")) {
                InputStream instream;
                URL base;
                try {
                    URL inurl;
                    base = inurl = new URL(null, arg);
                    instream = inurl.openStream();
                }
                catch (MalformedURLException ex) {
                    File file = new File(arg);
                    instream = new FileInputStream(file);
                    this._file = new File(file.getAbsolutePath());
                    title = this._file.getName();
                    this._directory = this._file.getParentFile();
                    base = new URL("file", null, this._directory.getAbsolutePath());
                }
                this._read(base, instream);
                continue;
            }
            throw new CmdLineArgException("Unrecognized option: " + arg);
        }
        int argumentsRead = i;
        return argumentsRead;
    }

    protected String _usage() {
        String[][] commandOptions = new String[][]{{"-height", "<pixels>"}, {"-width", "<pixels>"}};
        String[] commandFlags = new String[]{"-help", "-test", "-version", "-"};
        String result = "Usage: ptplot [ options ] [file ...]\n\nOptions that take values:\n";
        int i = 0;
        while (i < commandOptions.length) {
            result = String.valueOf(result) + " " + commandOptions[i][0] + " " + commandOptions[i][1] + "\n";
            ++i;
        }
        result = String.valueOf(result) + "\nBoolean flags:\n";
        i = 0;
        while (i < commandFlags.length) {
            result = String.valueOf(result) + " " + commandFlags[i];
            ++i;
        }
        return result;
    }

    protected void _read(URL base, InputStream in) throws IOException {
        this.plot.read(in);
    }
}

