/* $ANTLR 2.7.4: "walker.g" -> "AntlrNotebookTreeParser.cpp"$ */
#include "AntlrNotebookTreeParser.hpp"
#include <antlr/Token.hpp>
#include <antlr/AST.hpp>
#include <antlr/NoViableAltException.hpp>
#include <antlr/MismatchedTokenException.hpp>
#include <antlr/SemanticException.hpp>
#include <antlr/BitSet.hpp>
AntlrNotebookTreeParser::AntlrNotebookTreeParser()
	: ANTLR_USE_NAMESPACE(antlr)TreeParser() {
}

void AntlrNotebookTreeParser::document(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	Cell *ws, Factory *f
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST document_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	
	//This is in NotebookTreeParser.cpp
	factory = f;
	workspace = ws;
	
	
	// AF
	imagePartOfText = false;
	
	
	result_t result(output);// = new result_t; //??
	
	
	try {      // for error handling
		expr(_t,result);
		_t = _retTree;
		
		//cout << (*result).first.str() << endl;
		
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

void AntlrNotebookTreeParser::expr(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	result_t &result
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST expr_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	
	string val;
	string attr;
	
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case MODULENAME:
		case LIST:
		case NOTEBOOK:
		case CELL:
		case TEXTDATA:
		case CELLGROUPDATA:
		case GRAYLEVEL:
		case RGBCOLOR:
		case FILENAME:
		case STYLEBOX:
		case BOXDATA:
		case BUTTONBOX:
		case FORMBOX:
		case ROWBOX:
		case SUPERSCRBOX:
		case SUBSCRBOX:
		case SUBSUPERSCRIPTBOX:
		case UNDERSCRIPTBOX:
		case OVERSCRIPTBOX:
		case UNDEROVERSCRIPTBOX:
		case FRACTIONBOX:
		case SQRTBOX:
		case RADICALBOX:
		case DIREXTEDINFINITY:
		case NOT_MATH_OLEDATE:
		case GRAPHICSDATA:
		case LISTBODY:
		{
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == MODULENAME)) {
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp1_AST_in = _t;
					match(_t,MODULENAME);
					_t = _t->getNextSibling();
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp2_AST_in = _t;
					match(_t,THICK);
					_t = _t->getNextSibling();
				}
				else {
					goto _loop4;
				}
				
			}
			_loop4:;
			} // ( ... )*
			exprheader(_t,result);
			_t = _retTree;
			
			
			break;
		}
		case VALUERIGHT:
		case VALUELEFT:
		case VALUECENTER:
		case TRUE_:
		case FALSE_:
		case AUTOMATIC:
		case TRADITIONALFORM:
		case STANDARDFORM:
		case INPUTFORM:
		case OUTPUTFORM:
		case NULLSYM:
		case NONESYM:
		case NUMBER:
		case QSTRING:
		{
			val=value(_t);
			_t = _retTree;
			
			result.first << val;
			
			break;
		}
		case FONTSLANT:
		case FONTSIZE:
		case FONTCOLOR:
		case FONTWEIGHT:
		case FONTFAMILY:
		case FONTVARIATIONS:
		case TEXTALIGNMENT:
		case TEXTJUSTIFICATION:
		case INITIALIZATIONCELL:
		case FORMATTYPE_TOKEN:
		case PAGEWIDTH:
		case ACTIVE_TOKEN:
		case BUTTONFUNCTION:
		case BUTTONDATA:
		case BUTTONEVALUATOR:
		case BUTTONSTYLE:
		case CHARACHTERENCODING:
		case SCREENRECTANGLE:
		case AUTOGENERATEDPACKAGE:
		case CELLTAGS:
		case CELLFRAME:
		case CELLGENERATED:
		case SHOWCELLBRACKET:
		case EDITABLE:
		case WINDOWSIZE:
		case WINDOWMARGINS:
		case WINDOWFRAME:
		case WINDOWELEMENTS:
		case WINDOWTITLE:
		case WINDOWTOOLBARS:
		case WINDOWMOVEABLE:
		case WINDOWFLOATING:
		case WINDOWCLICKSELECT:
		case STYLEDEFINITIONS:
		case FRONTENDVERSION:
		case IMAGESIZE:
		case IMAGEMARGINS:
		case IMAGEREGION:
		case IMAGERANGECACHE:
		case IMAGECACHE:
		case CELLAUTOOVRT:
		case MAGNIFICATION:
		case BACKGROUND:
		case GENERATEDCELL:
		{
			attr=attribute(_t);
			_t = _retTree;
			
			result.first << attr;
			
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

void AntlrNotebookTreeParser::exprheader(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	result_t &result
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST exprheader_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	ANTLR_USE_NAMESPACE(antlr)RefAST style = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST opengroup = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST closegroup = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST sbstyle = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST type = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST data = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST infinitytype = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST red = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST green = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST blue = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	rules_t rules;
	
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case NOTEBOOK:
		{
			
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t6 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp3_AST_in = _t;
			match(_t,NOTEBOOK);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop8;
				}
				
			}
			_loop8:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop10;
				}
				
			}
			_loop10:;
			} // ( ... )*
			_t = __t6;
			_t = _t->getNextSibling();
			
			
			break;
		}
		case LIST:
		{
			
			ostringstream listoutput;
			result_t list(listoutput);
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t11 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp4_AST_in = _t;
			match(_t,LIST);
			_t = _t->getFirstChild();
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					listelement(_t,list);
					_t = _retTree;
				}
				else {
					goto _loop13;
				}
				
			}
			_loop13:;
			} // ( ... )*
			_t = __t11;
			_t = _t->getNextSibling();
			
						//2005-11-09 AF, Added a function for adding/removeing some
						//chars/symbols from the text
			string str = StripString::stripNBString( list.first.str() );
			
						result.first << str << endl;
			
			break;
		}
		case LISTBODY:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t14 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp5_AST_in = _t;
			match(_t,LISTBODY);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			_t = __t14;
			_t = _t->getNextSibling();
			
			
			break;
		}
		case CELL:
		{
			
				    ostringstream contentoutput;
			result_t content(contentoutput);
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t15 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp6_AST_in = _t;
			match(_t,CELL);
			_t = _t->getFirstChild();
			expr(_t,content);
			_t = _retTree;
			{
			if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
				_t = ASTNULL;
			switch ( _t->getType()) {
			case QSTRING:
			{
				style = _t;
				match(_t,QSTRING);
				_t = _t->getNextSibling();
				break;
			}
			case 3:
			case RULE:
			case RULEDELAYED:
			{
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
			}
			}
			}
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop18;
				}
				
			}
			_loop18:;
			} // ( ... )*
			_t = __t15;
			_t = _t->getNextSibling();
			
						//2005-11-09 AF, Added a function for adding/removeing some
						//chars/symbols from the text
			string cnt = StripString::stripNBString( content.first.str() );
			
			if(style)
			{
							QString qcnt(cnt.c_str());
				            	
							string s1 = style->getText();
							s1.assign(s1, 1, s1.length()-2);
			
							QString cellstyle(s1.c_str());
							
							// 2005-11-09 AF,	
							// if the cellstyle is "Graphics" a new cell shouldn't always be added, sometimes
							// a image should be added in the existing cell
							if( cellstyle == "Graphics" )
							{
								// TODO: DEBUG code, remove when doing release
								/*
								if( imagePartOfText )
								{
									result.first << "IMAGE" << endl;
								}
								else
								{
									Cell *text = factory->createCell("Text", workspace);
									text->setText("IMAGE CELL");
									text->setStyle("Text");
									
									workspace->addChild(text);
								}
								*/
							}
							else
							{	
								Cell *text = factory->createCell(cellstyle, workspace);
				                
								//RULES
								//Rules from content.
								for(rules_t::iterator i=content.second.begin();i!=content.second.end();++i)
								{
									//AF text->setStyle(QString((*i).first.c_str()), QString((*i).second.c_str()));
									//text->addRule(new Rule(QString((*i).first.c_str()), QString((*i).second.c_str())));
								}
				                
								//Rules from tag.
								for(rules_t::iterator j = rules.begin(); j != rules.end(); j++)
								{
									//AF text->setStyle(QString((*j).first.c_str()), QString((*j).second.c_str()));
									text->addRule(new Rule(QString((*j).first.c_str()), QString((*j).second.c_str())));
								}
				                
								//STYLE
								// 2005-11-08 AF, ndrat ordningen s att setText grs fre setStyle
								text->setText( qcnt );
								//text->setStyle( cellstyle );
				                
								workspace->addChild(text);
							}
			}
			else
			{   //This is really ugly, but it works most of the time. 
			//This is only happening when a Cell does not have a style. It seems 
			//to happen only with cells inside textdata-expressions. 
			result.first << cnt;
			}
			
			break;
		}
		case CELLGROUPDATA:
		{
			
			//CellGroup *group = new CellGroup(workspace->doc());
			//CellGroup *parent = workspace;
			Cell *group = factory->createCell("cellgroup", workspace);
			Cell *parent = workspace;
			workspace = group;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t19 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp7_AST_in = _t;
			match(_t,CELLGROUPDATA);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{
			if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
				_t = ASTNULL;
			switch ( _t->getType()) {
			case CELLGROUPOPEN:
			{
				opengroup = _t;
				match(_t,CELLGROUPOPEN);
				_t = _t->getNextSibling();
				break;
			}
			case CELLGROUPCLOSED:
			{
				closegroup = _t;
				match(_t,CELLGROUPCLOSED);
				_t = _t->getNextSibling();
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
			}
			}
			}
			_t = __t19;
			_t = _t->getNextSibling();
			
				if( opengroup )
							group->setClosed( false );
						else if( closegroup )
							group->setClosed( true );
					
								
			workspace = parent;
			workspace->addChild(group);
			
			break;
		}
		case STYLEBOX:
		{
			
				    ostringstream sboutput;
			result_t sbcontent(sboutput);
			rules_t stylerules;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t21 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp8_AST_in = _t;
			match(_t,STYLEBOX);
			_t = _t->getFirstChild();
			expr(_t,sbcontent);
			_t = _retTree;
			{
			if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
				_t = ASTNULL;
			switch ( _t->getType()) {
			case QSTRING:
			{
				sbstyle = _t;
				match(_t,QSTRING);
				_t = _t->getNextSibling();
				break;
			}
			case RULE:
			case RULEDELAYED:
			{
				{ // ( ... )+
				int _cnt24=0;
				for (;;) {
					if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
						_t = ASTNULL;
					if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
						rule(_t,stylerules);
						_t = _retTree;
					}
					else {
						if ( _cnt24>=1 ) { goto _loop24; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);}
					}
					
					_cnt24++;
				}
				_loop24:;
				}  // ( ... )+
				break;
			}
			case 3:
			{
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
			}
			}
			}
			_t = __t21;
			_t = _t->getNextSibling();
			
			if(sbstyle)
			{
			//What happends if a style is added here?
			}
			else
			{   
			rules_t::iterator i = stylerules.begin();
			for(; i != stylerules.end();++i)
			{
			//cout << "STYLERULES: " << (*i).first << "->" << (*i).second << endl;
			result.second.push_back(*i);
			}
			}
			
			//2005-11-09 AF, Added a function for adding/removeing some
						//chars/symbols from the text
			string str = StripString::stripNBString( sbcontent.first.str() );
			
			// 2005-12-06 AF, Apply the rules to the text
			str = StripString::applyRulesToText( str, stylerules );
			
			result.first << str; //sbcontent.first.str();
			
			break;
		}
		case TEXTDATA:
		{
			
						imagePartOfText = true;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t25 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp9_AST_in = _t;
			match(_t,TEXTDATA);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop27;
				}
				
			}
			_loop27:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop29;
				}
				
			}
			_loop29:;
			} // ( ... )*
			_t = __t25;
			_t = _t->getNextSibling();
			
			imagePartOfText = false;
			
			break;
		}
		case SUPERSCRBOX:
		{
			
			ostringstream baseoutput;
			ostringstream expoutput;
			result_t base(baseoutput);
			result_t exp(expoutput);
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t30 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp10_AST_in = _t;
			match(_t,SUPERSCRBOX);
			_t = _t->getFirstChild();
			expr(_t,base);
			_t = _retTree;
			expr(_t,exp);
			_t = _retTree;
			_t = __t30;
			_t = _t->getNextSibling();
			
			result.first << base.first.str() << "<sup>" << exp.first.str() << "</sup>";
			
			rules_t::iterator i = base.second.begin();
			for(; i != base.second.end(); ++i)
			{
			result.second.push_back((*i));               
			}
			rules_t::iterator j = exp.second.begin();
			for(; j != exp.second.end(); ++j)
			{
			result.second.push_back((*j));               
			}
			
			break;
		}
		case SUBSCRBOX:
		{
			
						ostringstream baseoutputSub;
			ostringstream expoutputSub;
			result_t baseSub(baseoutputSub);
			result_t expSub(expoutputSub);
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t31 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp11_AST_in = _t;
			match(_t,SUBSCRBOX);
			_t = _t->getFirstChild();
			expr(_t,baseSub);
			_t = _retTree;
			expr(_t,expSub);
			_t = _retTree;
			_t = __t31;
			_t = _t->getNextSibling();
			
						result.first << baseSub.first.str() << "<sub>" << expSub.first.str() << "</sub>";
			
			rules_t::iterator i = baseSub.second.begin();
			for(; i != baseSub.second.end(); ++i)
			{
			result.second.push_back((*i));               
			}
			rules_t::iterator j = expSub.second.begin();
			for(; j != expSub.second.end(); ++j)
			{
			result.second.push_back((*j));               
			}
			
			break;
		}
		case BUTTONBOX:
		{
			
			//Translates all buttons into hyperlinks.
			ostringstream btoutput;
			result_t buttonTitle(btoutput);
			rules_t buttonRules;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t32 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp12_AST_in = _t;
			match(_t,BUTTONBOX);
			_t = _t->getFirstChild();
			expr(_t,buttonTitle);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop34;
				}
				
			}
			_loop34:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,buttonRules);
					_t = _retTree;
				}
				else {
					goto _loop36;
				}
				
			}
			_loop36:;
			} // ( ... )*
			_t = __t32;
			_t = _t->getNextSibling();
			
			string filename;
			//Check rules. Look for ButtonData ->Filename and ButtonStyle=Hyperlink
			rules_t::iterator i = buttonRules.begin();
			for(; i != buttonRules.end();++i)
			{
			if((*i).first == "ButtonData")
			{
			//cout << "BUTTONBOX RULES: " << (*i).first << "->" 
			//     << (*i).second << endl;
			filename = (*i).second;
			}
			//result.second.push_back(*i);
			}
			
			result.first << "<a href=\"" << filename << "\">" 
			<< buttonTitle.first.str() << "</a>";
			
			break;
		}
		case FILENAME:
		{
			
				    ostringstream diroutput;
				    ostringstream filenameoutput;
			result_t dir(diroutput);
			result_t filename(filenameoutput);
			rules_t filenameRules;
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t37 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp13_AST_in = _t;
			match(_t,FILENAME);
			_t = _t->getFirstChild();
			expr(_t,dir);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,filename);
					_t = _retTree;
				}
				else {
					goto _loop39;
				}
				
			}
			_loop39:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,filenameRules);
					_t = _retTree;
				}
				else {
					goto _loop41;
				}
				
			}
			_loop41:;
			} // ( ... )*
			_t = __t37;
			_t = _t->getNextSibling();
			
			//Delete strange newline in directory string.
			string d = dir.first.str();
			d.assign(d, 0, d.length()-1);
			
			result.first << d << "/" << filename.first.str();
			
			break;
		}
		case GRAPHICSDATA:
		{
			
					
			ANTLR_USE_NAMESPACE(antlr)RefAST __t42 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp14_AST_in = _t;
			match(_t,GRAPHICSDATA);
			_t = _t->getFirstChild();
			type = _t;
			match(_t,QSTRING);
			_t = _t->getNextSibling();
			data = _t;
			match(_t,QSTRING);
			_t = _t->getNextSibling();
			_t = __t42;
			_t = _t->getNextSibling();
			
					
			break;
		}
		case DIREXTEDINFINITY:
		{
			
				
			ANTLR_USE_NAMESPACE(antlr)RefAST __t43 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp15_AST_in = _t;
			match(_t,DIREXTEDINFINITY);
			_t = _t->getFirstChild();
			infinitytype = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			_t = __t43;
			_t = _t->getNextSibling();
			
				
			break;
		}
		case BOXDATA:
		{
			
						ostringstream boxdataoutput;
			result_t boxdata(boxdataoutput);
					
			ANTLR_USE_NAMESPACE(antlr)RefAST __t44 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp16_AST_in = _t;
			match(_t,BOXDATA);
			_t = _t->getFirstChild();
			expr(_t,boxdata);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop46;
				}
				
			}
			_loop46:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop48;
				}
				
			}
			_loop48:;
			} // ( ... )*
			_t = __t44;
			_t = _t->getNextSibling();
			
						result.first << StripString::stripSimulationData(boxdata.first.str());
					
			break;
		}
		case RGBCOLOR:
		{
			
					
			ANTLR_USE_NAMESPACE(antlr)RefAST __t49 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp17_AST_in = _t;
			match(_t,RGBCOLOR);
			_t = _t->getFirstChild();
			red = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			green = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			blue = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			_t = __t49;
			_t = _t->getNextSibling();
			
						if( red && green && blue )
							result.first << red->getText() << ":" << green->getText() << ":" << blue->getText();
						else
							result.first << "7777:3333:2222";
					
			break;
		}
		case ROWBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t50 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp18_AST_in = _t;
			match(_t,ROWBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop52;
				}
				
			}
			_loop52:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop54;
				}
				
			}
			_loop54:;
			} // ( ... )*
			_t = __t50;
			_t = _t->getNextSibling();
			break;
		}
		case FORMBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t55 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp19_AST_in = _t;
			match(_t,FORMBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop57;
				}
				
			}
			_loop57:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop59;
				}
				
			}
			_loop59:;
			} // ( ... )*
			_t = __t55;
			_t = _t->getNextSibling();
			break;
		}
		case SUBSUPERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t60 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp20_AST_in = _t;
			match(_t,SUBSUPERSCRIPTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop62;
				}
				
			}
			_loop62:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop64;
				}
				
			}
			_loop64:;
			} // ( ... )*
			_t = __t60;
			_t = _t->getNextSibling();
			break;
		}
		case UNDERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t65 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp21_AST_in = _t;
			match(_t,UNDERSCRIPTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop67;
				}
				
			}
			_loop67:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop69;
				}
				
			}
			_loop69:;
			} // ( ... )*
			_t = __t65;
			_t = _t->getNextSibling();
			break;
		}
		case OVERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t70 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp22_AST_in = _t;
			match(_t,OVERSCRIPTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop72;
				}
				
			}
			_loop72:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop74;
				}
				
			}
			_loop74:;
			} // ( ... )*
			_t = __t70;
			_t = _t->getNextSibling();
			break;
		}
		case UNDEROVERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t75 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp23_AST_in = _t;
			match(_t,UNDEROVERSCRIPTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop77;
				}
				
			}
			_loop77:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop79;
				}
				
			}
			_loop79:;
			} // ( ... )*
			_t = __t75;
			_t = _t->getNextSibling();
			break;
		}
		case FRACTIONBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t80 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp24_AST_in = _t;
			match(_t,FRACTIONBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop82;
				}
				
			}
			_loop82:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop84;
				}
				
			}
			_loop84:;
			} // ( ... )*
			_t = __t80;
			_t = _t->getNextSibling();
			break;
		}
		case SQRTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t85 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp25_AST_in = _t;
			match(_t,SQRTBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop87;
				}
				
			}
			_loop87:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop89;
				}
				
			}
			_loop89:;
			} // ( ... )*
			_t = __t85;
			_t = _t->getNextSibling();
			break;
		}
		case RADICALBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t90 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp26_AST_in = _t;
			match(_t,RADICALBOX);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop92;
				}
				
			}
			_loop92:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop94;
				}
				
			}
			_loop94:;
			} // ( ... )*
			_t = __t90;
			_t = _t->getNextSibling();
			break;
		}
		case GRAYLEVEL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t95 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp27_AST_in = _t;
			match(_t,GRAYLEVEL);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop97;
				}
				
			}
			_loop97:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop99;
				}
				
			}
			_loop99:;
			} // ( ... )*
			_t = __t95;
			_t = _t->getNextSibling();
			break;
		}
		case NOT_MATH_OLEDATE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t100 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp28_AST_in = _t;
			match(_t,NOT_MATH_OLEDATE);
			_t = _t->getFirstChild();
			expr(_t,result);
			_t = _retTree;
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_tokenSet_0.member(_t->getType()))) {
					expr(_t,result);
					_t = _retTree;
				}
				else {
					goto _loop102;
				}
				
			}
			_loop102:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
					_t = ASTNULL;
				if ((_t->getType() == RULE || _t->getType() == RULEDELAYED)) {
					rule(_t,rules);
					_t = _retTree;
				}
				else {
					goto _loop104;
				}
				
			}
			_loop104:;
			} // ( ... )*
			_t = __t100;
			_t = _t->getNextSibling();
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

string  AntlrNotebookTreeParser::value(ANTLR_USE_NAMESPACE(antlr)RefAST _t) {
	string value;
	ANTLR_USE_NAMESPACE(antlr)RefAST value_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	ANTLR_USE_NAMESPACE(antlr)RefAST str = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST num = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST tr = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fl = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST rightval = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST leftval = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST centerval = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST tradform = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST stdform = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST inputform = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST outputform = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST automatic = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST none = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST nullsym = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case QSTRING:
		{
			str = _t;
			match(_t,QSTRING);
			_t = _t->getNextSibling();
			
			//Move this to TextCell.
			
			//Delete quotes
			value = str->getText();
			value.assign(value, 1, value.length()-2);            
			
			break;
		}
		case NUMBER:
		{
			num = _t;
			match(_t,NUMBER);
			_t = _t->getNextSibling();
			
			value = string(num->getText());   
			
			break;
		}
		case TRUE_:
		{
			tr = _t;
			match(_t,TRUE_);
			_t = _t->getNextSibling();
			
			value = string(tr->getText()); 
			
			break;
		}
		case FALSE_:
		{
			fl = _t;
			match(_t,FALSE_);
			_t = _t->getNextSibling();
			
			value =string(fl->getText());
			
			break;
		}
		case VALUERIGHT:
		{
			rightval = _t;
			match(_t,VALUERIGHT);
			_t = _t->getNextSibling();
			
			value = string(rightval->getText()); 
			
			break;
		}
		case VALUELEFT:
		{
			leftval = _t;
			match(_t,VALUELEFT);
			_t = _t->getNextSibling();
			
			value = string(leftval->getText()); 
			
			break;
		}
		case VALUECENTER:
		{
			centerval = _t;
			match(_t,VALUECENTER);
			_t = _t->getNextSibling();
			
			value = string(centerval->getText());
			
			break;
		}
		case TRADITIONALFORM:
		{
			tradform = _t;
			match(_t,TRADITIONALFORM);
			_t = _t->getNextSibling();
			
			//value = string(tradform->getText()); 
			
			break;
		}
		case STANDARDFORM:
		{
			stdform = _t;
			match(_t,STANDARDFORM);
			_t = _t->getNextSibling();
			
			//value = string(stdform->getText()); 
			
			break;
		}
		case INPUTFORM:
		{
			inputform = _t;
			match(_t,INPUTFORM);
			_t = _t->getNextSibling();
			
			//value = string(inputform->getText()); 
			
			break;
		}
		case OUTPUTFORM:
		{
			outputform = _t;
			match(_t,OUTPUTFORM);
			_t = _t->getNextSibling();
			
			//value = string(outputform->getText()); 
			
			break;
		}
		case AUTOMATIC:
		{
			automatic = _t;
			match(_t,AUTOMATIC);
			_t = _t->getNextSibling();
			
			//value = string(automatic->getText()); 
			
			break;
		}
		case NONESYM:
		{
			none = _t;
			match(_t,NONESYM);
			_t = _t->getNextSibling();
			
			//value = string(none->getText()); 
			
			break;
		}
		case NULLSYM:
		{
			nullsym = _t;
			match(_t,NULLSYM);
			_t = _t->getNextSibling();
			
			value = string(nullsym->getText());
			
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
	return value;
}

string  AntlrNotebookTreeParser::attribute(ANTLR_USE_NAMESPACE(antlr)RefAST _t) {
	string value;
	ANTLR_USE_NAMESPACE(antlr)RefAST attribute_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontslant = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontsize = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontcolor = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontweight = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontfamily = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST fontvariations = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST textalignment = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST textjustification = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST initializationcell = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST formattype = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST pagewidth = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST activetoken = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST buttonfunction = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST buttondata = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST buttonevaluator = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST buttonstyle = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST characterencoding = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST screenrectangle = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST autogeneratedpackage = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST celltags = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellframe = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellgenerated = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellshowbracket = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST editable = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST background = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowsize = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowmargins = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowframe = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowelements = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowtitle = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowtoolbars = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowmoveable = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowfloating = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST windowclickselect = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST styledefinitions = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST frontendversion = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST magnification = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST generatedCell = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST cellautoovrt = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imagesize = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imagemargins = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imageregion = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imagerangecache = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST imagecache = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case FONTSLANT:
		{
			fontslant = _t;
			match(_t,FONTSLANT);
			_t = _t->getNextSibling();
			
			value = string(fontslant->getText());
			
			break;
		}
		case FONTSIZE:
		{
			fontsize = _t;
			match(_t,FONTSIZE);
			_t = _t->getNextSibling();
			
			value = string(fontsize->getText());
			
			break;
		}
		case FONTCOLOR:
		{
			fontcolor = _t;
			match(_t,FONTCOLOR);
			_t = _t->getNextSibling();
			
			value = string(fontcolor->getText());
			
			break;
		}
		case FONTWEIGHT:
		{
			fontweight = _t;
			match(_t,FONTWEIGHT);
			_t = _t->getNextSibling();
			
			value = string(fontweight->getText());
			
			break;
		}
		case FONTFAMILY:
		{
			fontfamily = _t;
			match(_t,FONTFAMILY);
			_t = _t->getNextSibling();
			
			value = string(fontfamily->getText());
			
			break;
		}
		case FONTVARIATIONS:
		{
			fontvariations = _t;
			match(_t,FONTVARIATIONS);
			_t = _t->getNextSibling();
			
			value = string(fontvariations->getText());
			
			break;
		}
		case TEXTALIGNMENT:
		{
			textalignment = _t;
			match(_t,TEXTALIGNMENT);
			_t = _t->getNextSibling();
			
			value = string(textalignment->getText());
			
			break;
		}
		case TEXTJUSTIFICATION:
		{
			textjustification = _t;
			match(_t,TEXTJUSTIFICATION);
			_t = _t->getNextSibling();
			
			value = string(textjustification->getText());
			
			break;
		}
		case INITIALIZATIONCELL:
		{
			initializationcell = _t;
			match(_t,INITIALIZATIONCELL);
			_t = _t->getNextSibling();
			
			value = string(initializationcell->getText());
			
			break;
		}
		case FORMATTYPE_TOKEN:
		{
			formattype = _t;
			match(_t,FORMATTYPE_TOKEN);
			_t = _t->getNextSibling();
			
			value = string(formattype->getText());
			
			break;
		}
		case PAGEWIDTH:
		{
			pagewidth = _t;
			match(_t,PAGEWIDTH);
			_t = _t->getNextSibling();
			
			value = string(pagewidth->getText());
			
			break;
		}
		case ACTIVE_TOKEN:
		{
			activetoken = _t;
			match(_t,ACTIVE_TOKEN);
			_t = _t->getNextSibling();
			
			value = string(activetoken->getText());
			
			break;
		}
		case BUTTONFUNCTION:
		{
			buttonfunction = _t;
			match(_t,BUTTONFUNCTION);
			_t = _t->getNextSibling();
			
			value = string(buttonfunction->getText());
			
			break;
		}
		case BUTTONDATA:
		{
			buttondata = _t;
			match(_t,BUTTONDATA);
			_t = _t->getNextSibling();
			
			value = string(buttondata->getText());
			
			break;
		}
		case BUTTONEVALUATOR:
		{
			buttonevaluator = _t;
			match(_t,BUTTONEVALUATOR);
			_t = _t->getNextSibling();
			
			value = string(buttonevaluator->getText());
			
			break;
		}
		case BUTTONSTYLE:
		{
			buttonstyle = _t;
			match(_t,BUTTONSTYLE);
			_t = _t->getNextSibling();
			
			value = string(buttonstyle->getText());
			
			break;
		}
		case CHARACHTERENCODING:
		{
			characterencoding = _t;
			match(_t,CHARACHTERENCODING);
			_t = _t->getNextSibling();
			
			value = string(characterencoding->getText());
			
			break;
		}
		case SCREENRECTANGLE:
		{
			screenrectangle = _t;
			match(_t,SCREENRECTANGLE);
			_t = _t->getNextSibling();
			
			value = string(screenrectangle->getText());
			
			break;
		}
		case AUTOGENERATEDPACKAGE:
		{
			autogeneratedpackage = _t;
			match(_t,AUTOGENERATEDPACKAGE);
			_t = _t->getNextSibling();
			
			value = string(autogeneratedpackage->getText());
			
			break;
		}
		case CELLTAGS:
		{
			celltags = _t;
			match(_t,CELLTAGS);
			_t = _t->getNextSibling();
			
			value = string(celltags->getText());
			
			break;
		}
		case CELLFRAME:
		{
			cellframe = _t;
			match(_t,CELLFRAME);
			_t = _t->getNextSibling();
			
			value = string(cellframe->getText());
			
			break;
		}
		case CELLGENERATED:
		{
			cellgenerated = _t;
			match(_t,CELLGENERATED);
			_t = _t->getNextSibling();
			
			value = string(cellgenerated->getText());
			
			break;
		}
		case SHOWCELLBRACKET:
		{
			cellshowbracket = _t;
			match(_t,SHOWCELLBRACKET);
			_t = _t->getNextSibling();
			
			value = string(cellshowbracket->getText());
			
			break;
		}
		case EDITABLE:
		{
			editable = _t;
			match(_t,EDITABLE);
			_t = _t->getNextSibling();
			
			value = string(editable->getText());
			
			break;
		}
		case BACKGROUND:
		{
			background = _t;
			match(_t,BACKGROUND);
			_t = _t->getNextSibling();
			
			value = string(background->getText());
			
			break;
		}
		case WINDOWSIZE:
		{
			windowsize = _t;
			match(_t,WINDOWSIZE);
			_t = _t->getNextSibling();
			
			value = string(windowsize->getText());
			
			break;
		}
		case WINDOWMARGINS:
		{
			windowmargins = _t;
			match(_t,WINDOWMARGINS);
			_t = _t->getNextSibling();
			
			value = string(windowmargins->getText());
			
			break;
		}
		case WINDOWFRAME:
		{
			windowframe = _t;
			match(_t,WINDOWFRAME);
			_t = _t->getNextSibling();
			
			value = string(windowframe->getText());
			
			break;
		}
		case WINDOWELEMENTS:
		{
			windowelements = _t;
			match(_t,WINDOWELEMENTS);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWTITLE:
		{
			windowtitle = _t;
			match(_t,WINDOWTITLE);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWTOOLBARS:
		{
			windowtoolbars = _t;
			match(_t,WINDOWTOOLBARS);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWMOVEABLE:
		{
			windowmoveable = _t;
			match(_t,WINDOWMOVEABLE);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWFLOATING:
		{
			windowfloating = _t;
			match(_t,WINDOWFLOATING);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case WINDOWCLICKSELECT:
		{
			windowclickselect = _t;
			match(_t,WINDOWCLICKSELECT);
			_t = _t->getNextSibling();
			
			//value = string(attr->getText());
			
			break;
		}
		case STYLEDEFINITIONS:
		{
			styledefinitions = _t;
			match(_t,STYLEDEFINITIONS);
			_t = _t->getNextSibling();
			
			value = string(styledefinitions->getText());
			
			break;
		}
		case FRONTENDVERSION:
		{
			frontendversion = _t;
			match(_t,FRONTENDVERSION);
			_t = _t->getNextSibling();
			
			value = string(frontendversion->getText());
			
			break;
		}
		case MAGNIFICATION:
		{
			magnification = _t;
			match(_t,MAGNIFICATION);
			_t = _t->getNextSibling();
			
			value = string(magnification->getText());
			
			break;
		}
		case GENERATEDCELL:
		{
			generatedCell = _t;
			match(_t,GENERATEDCELL);
			_t = _t->getNextSibling();
			
			value = string(generatedCell->getText());
			
			break;
		}
		case CELLAUTOOVRT:
		{
			cellautoovrt = _t;
			match(_t,CELLAUTOOVRT);
			_t = _t->getNextSibling();
			
			value = string(cellautoovrt->getText());
			
			break;
		}
		case IMAGESIZE:
		{
			imagesize = _t;
			match(_t,IMAGESIZE);
			_t = _t->getNextSibling();
			
			value = string(imagesize->getText());
			
			break;
		}
		case IMAGEMARGINS:
		{
			imagemargins = _t;
			match(_t,IMAGEMARGINS);
			_t = _t->getNextSibling();
			
			value = string(imagemargins->getText());
			
			break;
		}
		case IMAGEREGION:
		{
			imageregion = _t;
			match(_t,IMAGEREGION);
			_t = _t->getNextSibling();
			
			value = string(imageregion->getText());
			
			break;
		}
		case IMAGERANGECACHE:
		{
			imagerangecache = _t;
			match(_t,IMAGERANGECACHE);
			_t = _t->getNextSibling();
			
			value = string(imagerangecache->getText());
			
			break;
		}
		case IMAGECACHE:
		{
			imagecache = _t;
			match(_t,IMAGECACHE);
			_t = _t->getNextSibling();
			
			value = string(imagecache->getText());
			
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
	return value;
}

void AntlrNotebookTreeParser::rule(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	rules_t &rules
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST rule_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	
	ostringstream attoutput;
	ostringstream valoutput;
	result_t attribute(attoutput);
	result_t value(valoutput);
	
	
	try {      // for error handling
		if (_t == ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = ASTNULL;
		switch ( _t->getType()) {
		case RULE:
		{
			
			
			
			ANTLR_USE_NAMESPACE(antlr)RefAST __t107 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp29_AST_in = _t;
			match(_t,RULE);
			_t = _t->getFirstChild();
			expr(_t,attribute);
			_t = _retTree;
			expr(_t,value);
			_t = _retTree;
			_t = __t107;
			_t = _t->getNextSibling();
			
			//rules.push_back(Rule(attribute.first.str(), value.first.str()));
			rules.push_back(rule_t(attribute.first.str(), value.first.str()));
			
			break;
		}
		case RULEDELAYED:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST __t108 = _t;
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp30_AST_in = _t;
			match(_t,RULEDELAYED);
			_t = _t->getFirstChild();
			expr(_t,attribute);
			_t = _retTree;
			expr(_t,value);
			_t = _retTree;
			_t = __t108;
			_t = _t->getNextSibling();
			
			//rules.push_back(Rule(attribute.first.str(), value.first.str()));
			rules.push_back(rule_t(attribute.first.str(), value.first.str()));
			
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(_t);
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

void AntlrNotebookTreeParser::listelement(ANTLR_USE_NAMESPACE(antlr)RefAST _t,
	result_t &list
) {
	ANTLR_USE_NAMESPACE(antlr)RefAST listelement_AST_in = (_t == ASTNULL) ? ANTLR_USE_NAMESPACE(antlr)nullAST : _t;
	
	ostringstream resoutput;
	result_t result(resoutput);
	
	
	try {      // for error handling
		expr(_t,result);
		_t = _retTree;
		
		list.first << result.first.str();
		
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		if ( _t != ANTLR_USE_NAMESPACE(antlr)nullAST )
			_t = _t->getNextSibling();
	}
	_retTree = _t;
}

void AntlrNotebookTreeParser::initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& )
{
}
const char* AntlrNotebookTreeParser::tokenNames[] = {
	"<0>",
	"EOF",
	"<2>",
	"NULL_TREE_LOOKAHEAD",
	"\"FrontEnd\"",
	"\"List\"",
	"\"Notebook\"",
	"\"Cell\"",
	"\"TextData\"",
	"\"CellGroupData\"",
	"\"Rule\"",
	"\"RuleDelayed\"",
	"\"GrayLevel\"",
	"\"RGBColor\"",
	"\"FileName\"",
	"\"StyleBox\"",
	"\"BoxData\"",
	"\"ButtonBox\"",
	"\"FormBox\"",
	"\"RowBox\"",
	"\"GridBox\"",
	"\"SuperscriptBox\"",
	"\"SubscriptBox\"",
	"\"SubsuperscriptBox\"",
	"\"UnderscriptBox\"",
	"\"OverscriptBox\"",
	"\"UnderoverscriptBox\"",
	"\"FractionBox\"",
	"\"SqrtBox\"",
	"\"RadicalBox\"",
	"\"DirectedInfinity\"",
	"\"StartModelEditor\"",
	"\"OLEData\"",
	"\"FontSlant\"",
	"\"FontSize\"",
	"\"FontColor\"",
	"\"FontWeight\"",
	"\"FontFamily\"",
	"\"FontVariations\"",
	"\"TextAlignment\"",
	"\"TextJustification\"",
	"\"InitializationCell\"",
	"\"FormatType\"",
	"\"PageWidth\"",
	"\"Active\"",
	"\"ButtonFunction\"",
	"\"ButtonData\"",
	"\"ButtonEvaluator\"",
	"\"ButtonStyle\"",
	"\"CharacterEncoding\"",
	"\"ScreenRectangle\"",
	"\"AutoGeneratedPackage\"",
	"\"CellTags\"",
	"\"CellFrame\"",
	"\"GeneratedCell\"",
	"\"ShowCellBracket\"",
	"\"Editable\"",
	"\"Background\"",
	"\"WindowSize\"",
	"\"WindowMargins\"",
	"\"WindowFrame\"",
	"\"WindowElements\"",
	"\"WindowTitle\"",
	"\"WindowToolbars\"",
	"\"WindowMoveable\"",
	"\"WindowFloating\"",
	"\"WindowClickSelect\"",
	"\"StyleDefinitions\"",
	"\"FrontEndVersion\"",
	"\"Open\"",
	"\"Closed\"",
	"\"Right\"",
	"\"Left\"",
	"\"Center\"",
	"\"True\"",
	"\"False\"",
	"\"Automatic\"",
	"\"TraditionalForm\"",
	"\"StandardForm\"",
	"\"InputForm\"",
	"\"OutputForm\"",
	"\"Null\"",
	"\"None\"",
	"\"GraphicsData\"",
	"\"ImageSize\"",
	"\"ImageMargins\"",
	"\"ImageRegion\"",
	"\"ImageRangeCache\"",
	"\"ImageCache\"",
	"\"GenerateCell\"",
	"\"CellAutoOverwrite\"",
	"\"Magnification\"",
	"\"ParentDirectory\"",
	"RBRACK",
	"LBRACK",
	"RCURLY",
	"LCURLY",
	"COMMA",
	"THICK",
	"COMMENTSTART",
	"COMMENTEND",
	"NUMBER",
	"ID",
	"EXP",
	"DIGIT",
	"QSTRING",
	"WHITESPACE",
	"COMMENT",
	"LISTBODY",
	"BACKGROUND",
	"GENERATEDCELL",
	0
};

const unsigned long AntlrNotebookTreeParser::_tokenSet_0_data_[] = { 2146431984UL, 4261412863UL, 234880927UL, 29216UL, 0UL, 0UL, 0UL, 0UL };
// "FrontEnd" "List" "Notebook" "Cell" "TextData" "CellGroupData" "GrayLevel" 
// "RGBColor" "FileName" "StyleBox" "BoxData" "ButtonBox" "FormBox" "RowBox" 
// "SuperscriptBox" "SubscriptBox" "SubsuperscriptBox" "UnderscriptBox" 
// "OverscriptBox" "UnderoverscriptBox" "FractionBox" "SqrtBox" "RadicalBox" 
// "DirectedInfinity" "OLEData" "FontSlant" "FontSize" "FontColor" "FontWeight" 
// "FontFamily" "FontVariations" "TextAlignment" "TextJustification" "InitializationCell" 
// "FormatType" "PageWidth" "Active" "ButtonFunction" "ButtonData" "ButtonEvaluator" 
// "ButtonStyle" "CharacterEncoding" "ScreenRectangle" "AutoGeneratedPackage" 
// "CellTags" "CellFrame" "GeneratedCell" "ShowCellBracket" "Editable" 
// "WindowSize" "WindowMargins" "WindowFrame" "WindowElements" "WindowTitle" 
// "WindowToolbars" "WindowMoveable" "WindowFloating" "WindowClickSelect" 
// "StyleDefinitions" "FrontEndVersion" "Right" "Left" "Center" "True" 
// "False" "Automatic" "TraditionalForm" "StandardForm" "InputForm" "OutputForm" 
// "Null" "None" "GraphicsData" "ImageSize" "ImageMargins" "ImageRegion" 
// "ImageRangeCache" "ImageCache" "CellAutoOverwrite" "Magnification" NUMBER 
// QSTRING LISTBODY BACKGROUND GENERATEDCELL 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookTreeParser::_tokenSet_0(_tokenSet_0_data_,8);


