package Icons "Icon definitions"
   annotation (preferedView="info",Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,-100.},{80.,50.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{-100.,50.},{-80.,70.},{100.,70.},{80.,50.},{-100.,50.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{100.,70.},{100.,-80.},{80.,-100.},{80.,50.},{100.,70.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Text(extent={{-120.,135.},{120.,70.}},textString="%name",fillColor={255,0,0}),Text(extent={{-90.,40.},{70.,10.}},textString="Library",fillColor={160,160,160},fillPattern=FillPattern.Solid),Rectangle(extent={{-100.,-100.},{80.,50.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{-100.,50.},{-80.,70.},{100.,70.},{80.,50.},{-100.,50.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{100.,70.},{100.,-80.},{80.,-100.},{80.,50.},{100.,70.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Text(extent={{-90.,40.},{70.,10.}},textString="Library",fillColor={160,160,160},fillPattern=FillPattern.Solid),Polygon(points={{-64.,-20.},{-50.,-4.},{50.,-4.},{36.,-20.},{-64.,-20.},{-64.,-20.}},lineColor={0,0,0},fillColor={192,192,192},fillPattern=FillPattern.Solid),Rectangle(extent={{-64.,-20.},{36.,-84.}},lineColor={0,0,0},fillColor={192,192,192},fillPattern=FillPattern.Solid),Text(extent={{-60.,-24.},{32.,-38.}},textString="Library",fillColor={128,128,128},fillPattern=FillPattern.Solid),Polygon(points={{50.,-4.},{50.,-70.},{36.,-84.},{36.,-20.},{50.,-4.}},lineColor={0,0,0},fillColor={192,192,192},fillPattern=FillPattern.Solid)}),Documentation(info="<html>
 <p>
 This package contains definitions for the graphical layout of
 components which may be used in different libraries.
 The icons can be utilized by inheriting them in the desired class
 using \"extends\".
 </p>
 <dl>
 <dt><b>Main Author:</b>
 <dd><a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
     Deutsches Zentrum fuer Luft und Raumfahrt e.V. (DLR)<br>
     Oberpfaffenhofen<br>
     Postfach 1116<br>
     D-82230 Wessling<br>
     email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A><br>
 </dl>
 
 <p>
 Copyright &copy; 1998-2005, Modelica Association and DLR.
 </p>
 <p>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> 
 <a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
 </p><br>
 </HTML>
 ",revisions="<html>
 <ul>
 <li><i>October 21, 2002</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>
        and <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
        Added new icons <b>Function</b>, <b>Enumerations</b> and <b>Record</b>.</li>
 <li><i>June 6, 2000</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Replaced <b>model</b> keyword by <b>package</b> if the main
        usage is for inheriting from a package.<br>
        New icons <b>GearIcon</b> and <b>MotorIcon</b>.</li>
 <li><i>Sept. 18, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Renaming package Icon to Icons.
        Model Advanced removed (icon not accepted on the Modelica meeting).
        New model Library2, which is the Library icon with enough place
        to add library specific elements in the icon. Icon also used in diagram
        level for models Info, TranslationalSensor, RotationalSensor.</li>
 <li><i>July 15, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Model Caution renamed to Advanced, model Sensor renamed to
        TranslationalSensor, new model RotationalSensor.</li>
 <li><i>June 30, 1999</i>
        by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
        Realized a first version.</li>
 </ul>
 <br>
 </html>"));
   partial model Info "Icon for an information class"
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,80.},{80.,-90.}},lineColor={0,0,255}),Polygon(points={{-100.,80.},{-90.,90.},{90.,90.},{80.,80.},{-100.,80.}},fillColor={0,0,255},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{80.,-90.},{90.,-80.},{90.,90.},{80.,80.},{80.,-90.}},fillColor={0,0,255},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Text(extent={{-80.,70.},{60.,-70.}},textString="Info",fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,80.},{80.,-90.}},lineColor={0,0,255}),Polygon(points={{-100.,80.},{-90.,90.},{90.,90.},{80.,80.},{-100.,80.}},fillColor={0,0,255},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{80.,-90.},{90.,-80.},{90.,90.},{80.,80.},{80.,-90.}},fillColor={0,0,255},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Text(extent={{-80.,70.},{60.,-70.}},textString="Info",fillColor={0,0,255})}));
   end Info;
   partial package Library "Icon for library"
      annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,-100.},{80.,50.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{-100.,50.},{-80.,70.},{100.,70.},{80.,50.},{-100.,50.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{100.,70.},{100.,-80.},{80.,-100.},{80.,50.},{100.,70.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Text(extent={{-85.,35.},{65.,-85.}},textString="Library",fillColor={0,0,255}),Text(extent={{-120.,122.},{120.,73.}},textString="%name",fillColor={255,0,0})}));
   end Library;
   partial package Library2 "Icon for library where additional icon elements shall be added"
      annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,-100.},{80.,50.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{-100.,50.},{-80.,70.},{100.,70.},{80.,50.},{-100.,50.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{100.,70.},{100.,-80.},{80.,-100.},{80.,50.},{100.,70.}},fillColor={235,235,235},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Text(extent={{-120.,125.},{120.,70.}},textString="%name",fillColor={255,0,0}),Text(extent={{-90.,40.},{70.,10.}},textString="Library",fillColor={160,160,160},fillPattern=FillPattern.Solid)}));
   end Library2;
   partial model Example "Icon for an example model"
      annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,-100.},{80.,50.}},fillColor={255,255,255},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{-100.,50.},{-80.,70.},{100.,70.},{80.,50.},{-100.,50.}},fillColor={255,255,255},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Polygon(points={{100.,70.},{100.,-80.},{80.,-100.},{80.,50.},{100.,70.}},fillColor={255,255,255},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Text(extent={{-96.,3.},{77.,-49.}},textString="Example",fillColor={0,0,255}),Text(extent={{-120.,132.},{120.,73.}},textString="%name",fillColor={255,0,0})}));
   end Example;
   partial function Function "Icon for a function"
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-140.,162.},{136.,102.}},textString="%name",fillColor={0,0,255}),Ellipse(extent={{-100.,100.},{100.,-100.}},lineColor={255,127,0},fillColor={255,255,255},fillPattern=FillPattern.Solid),Text(extent={{-100.,100.},{100.,-100.}},fillColor={255,127,0},textString="f")}));
   end Function;
   partial record Record "Icon for a record"
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,50.},{100.,-100.}},fillColor={255,255,127},fillPattern=FillPattern.Solid,lineColor={0,0,255}),Text(extent={{-127.,115.},{127.,55.}},textString="%name",fillColor={0,0,255}),Line(points={{-100.,-50.},{100.,-50.}},color={0,0,0}),Line(points={{-100.,0.},{100.,0.}},color={0,0,0}),Line(points={{0.,50.},{0.,-100.}},color={0,0,0})}));
   end Record;
   partial function Enumeration "Icon for an enumeration"
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-138.,164.},{138.,104.}},textString="%name",fillColor={0,0,255}),Ellipse(extent={{-100.,100.},{100.,-100.}},lineColor={255,0,127},fillColor={255,255,255},fillPattern=FillPattern.Solid),Text(extent={{-100.,100.},{100.,-100.}},fillColor={255,0,127},textString="e")}));
   end Enumeration;
   type TypeReal "Icon for a Real type"
      extends Real;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,0},fillColor={192,192,192},fillPattern=FillPattern.Solid),Text(extent={{-94.,94.},{94.,-94.}},fillColor={0,0,0},textString="R")}));
   end TypeReal;
   type TypeInteger "Icon for an Integer type"
      extends Integer;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,0},fillColor={192,192,192},fillPattern=FillPattern.Solid),Text(extent={{-94.,94.},{94.,-94.}},fillColor={0,0,0},textString="I")}));
   end TypeInteger;
   type TypeBoolean "Icon for a Boolean type"
      extends Boolean;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,0},fillColor={192,192,192},fillPattern=FillPattern.Solid),Text(extent={{-94.,94.},{94.,-94.}},fillColor={0,0,0},textString="B")}));
   end TypeBoolean;
   type TypeString "Icon for a String type"
      extends String;
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,0},fillColor={192,192,192},fillPattern=FillPattern.Solid),Text(extent={{-94.,94.},{94.,-94.}},fillColor={0,0,0},textString="S")}));
   end TypeString;
   partial model TranslationalSensor "Icon representing translational measurement device"
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-70.,-60.},{70.,20.}},lineColor={0,0,0},fillColor={255,255,255},fillPattern=FillPattern.Solid),Polygon(points={{0.,-40.},{-10.,-16.},{10.,-16.},{0.,-40.}},lineColor={0,0,0},fillColor={0,0,0},fillPattern=FillPattern.Solid),Line(points={{0.,0.},{0.,-16.}},color={0,0,0}),Line(points={{-70.,0.},{0.,0.}},color={0,0,0}),Line(points={{-50.,-40.},{-50.,-60.}},color={0,0,0}),Line(points={{-30.,-40.},{-30.,-60.}},color={0,0,0}),Line(points={{-10.,-40.},{-10.,-60.}},color={0,0,0}),Line(points={{10.,-40.},{10.,-60.}},color={0,0,0}),Line(points={{30.,-40.},{30.,-60.}},color={0,0,0}),Line(points={{50.,-40.},{50.,-60.}},color={0,0,0})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-70.,-60.},{70.,20.}},lineColor={0,0,0},fillColor={255,255,255},fillPattern=FillPattern.Solid),Polygon(points={{0.,-40.},{-10.,-16.},{10.,-16.},{0.,-40.}},lineColor={0,0,0},fillColor={0,0,0},fillPattern=FillPattern.Solid),Line(points={{0.,0.},{0.,-16.}},color={0,0,0}),Line(points={{-70.,0.},{0.,0.}},color={0,0,0}),Line(points={{-50.,-40.},{-50.,-60.}},color={0,0,0}),Line(points={{-30.,-40.},{-30.,-60.}},color={0,0,0}),Line(points={{-10.,-40.},{-10.,-60.}},color={0,0,0}),Line(points={{10.,-40.},{10.,-60.}},color={0,0,0}),Line(points={{30.,-40.},{30.,-60.}},color={0,0,0}),Line(points={{50.,-40.},{50.,-60.}},color={0,0,0})}));
   end TranslationalSensor;
   partial model RotationalSensor "Icon representing rotational measurement device"
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Ellipse(extent={{-70.,70.},{70.,-70.}},lineColor={0,0,0},fillColor={255,255,255},fillPattern=FillPattern.Solid),Line(points={{0.,70.},{0.,40.}},color={0,0,0}),Line(points={{22.9,32.8},{40.2,57.3}},color={0,0,0}),Line(points={{-22.9,32.8},{-40.2,57.3}},color={0,0,0}),Line(points={{37.6,13.7},{65.8,23.9}},color={0,0,0}),Line(points={{-37.6,13.7},{-65.8,23.9}},color={0,0,0}),Line(points={{0.,0.},{9.02,28.6}},color={0,0,0}),Polygon(points={{-0.48,31.6},{18.,26.},{18.,57.2},{-0.48,31.6}},lineColor={0,0,0},fillColor={0,0,0},fillPattern=FillPattern.Solid),Ellipse(extent={{-5.,5.},{5.,-5.}},lineColor={0,0,0},fillColor={0,0,0},fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Ellipse(extent={{-70.,70.},{70.,-70.}},lineColor={0,0,0},fillColor={255,255,255},fillPattern=FillPattern.Solid),Line(points={{0.,70.},{0.,40.}},color={0,0,0}),Line(points={{22.9,32.8},{40.2,57.3}},color={0,0,0}),Line(points={{-22.9,32.8},{-40.2,57.3}},color={0,0,0}),Line(points={{37.6,13.7},{65.8,23.9}},color={0,0,0}),Line(points={{-37.6,13.7},{-65.8,23.9}},color={0,0,0}),Line(points={{0.,0.},{9.02,28.6}},color={0,0,0}),Polygon(points={{-0.48,31.6},{18.,26.},{18.,57.2},{-0.48,31.6}},lineColor={0,0,0},fillColor={0,0,0},fillPattern=FillPattern.Solid),Ellipse(extent={{-5.,5.},{5.,-5.}},lineColor={0,0,0},fillColor={0,0,0},fillPattern=FillPattern.Solid)}));
   end RotationalSensor;
   partial model GearIcon "Icon for gearbox"
      annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-90.,10.},{-60.,-10.}},fillColor={192,192,192},lineColor={0,0,0},pattern=LinePattern.None,fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{-60.,10.},{-60.,20.},{-40.,40.},{-40.,-40.},{-60.,-20.},{-60.,10.}},lineColor={0,0,0},fillColor={128,128,128},pattern=LinePattern.None,fillPattern=FillPattern.HorizontalCylinder),Rectangle(extent={{-40.,60.},{40.,-60.}},lineColor={0,0,0},pattern=LinePattern.None,lineThickness=0.25,fillColor={192,192,192},fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{60.,20.},{40.,40.},{40.,-40.},{60.,-20.},{60.,20.}},lineColor={128,128,128},fillColor={128,128,128},fillPattern=FillPattern.Solid),Rectangle(extent={{60.,10.},{90.,-10.}},fillColor={192,192,192},lineColor={0,0,0},pattern=LinePattern.None,fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{-60.,-90.},{-50.,-90.},{-20.,-30.},{20.,-30.},{48.,-90.},{60.,-90.},{60.,-100.},{-60.,-100.},{-60.,-90.}},lineColor={0,0,0},fillColor={0,0,0},fillPattern=FillPattern.Solid)}));
   end GearIcon;
   partial model MotorIcon "Icon for electrical motor"
      annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,50.},{30.,-50.}},lineColor={0,0,0},fillColor={255,0,0},pattern=LinePattern.None,fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{-100.,-90.},{-90.,-90.},{-60.,-20.},{-10.,-20.},{20.,-90.},{30.,-90.},{30.,-100.},{-100.,-100.},{-100.,-90.}},lineColor={0,0,0},fillColor={0,0,0},fillPattern=FillPattern.Solid),Rectangle(extent={{30.,10.},{90.,-10.}},fillColor={192,192,192},lineColor={0,0,0},pattern=LinePattern.None,fillPattern=FillPattern.HorizontalCylinder)}));
   end MotorIcon;
end Icons;