/* $ANTLR 2.7.4: "lexer.g" -> "AntlrNotebookLexer.cpp"$ */
#include "AntlrNotebookLexer.hpp"
#include <antlr/CharBuffer.hpp>
#include <antlr/TokenStreamException.hpp>
#include <antlr/TokenStreamIOException.hpp>
#include <antlr/TokenStreamRecognitionException.hpp>
#include <antlr/CharStreamException.hpp>
#include <antlr/CharStreamIOException.hpp>
#include <antlr/NoViableAltForCharException.hpp>

AntlrNotebookLexer::AntlrNotebookLexer(ANTLR_USE_NAMESPACE(std)istream& in)
	: ANTLR_USE_NAMESPACE(antlr)CharScanner(new ANTLR_USE_NAMESPACE(antlr)CharBuffer(in),true)
{
	initLiterals();
}

AntlrNotebookLexer::AntlrNotebookLexer(ANTLR_USE_NAMESPACE(antlr)InputBuffer& ib)
	: ANTLR_USE_NAMESPACE(antlr)CharScanner(ib,true)
{
	initLiterals();
}

AntlrNotebookLexer::AntlrNotebookLexer(const ANTLR_USE_NAMESPACE(antlr)LexerSharedInputState& state)
	: ANTLR_USE_NAMESPACE(antlr)CharScanner(state,true)
{
	initLiterals();
}

void AntlrNotebookLexer::initLiterals()
{
	literals["Active"] = 44;
	literals["Magnification"] = 91;
	literals["CellAutoOverwrite"] = 90;
	literals["WindowMoveable"] = 64;
	literals["ParentDirectory"] = 92;
	literals["List"] = 5;
	literals["FrontEndVersion"] = 68;
	literals["SqrtBox"] = 28;
	literals["TextJustification"] = 40;
	literals["Editable"] = 56;
	literals["TextData"] = 8;
	literals["FontVariations"] = 38;
	literals["Center"] = 73;
	literals["ButtonBox"] = 17;
	literals["WindowTitle"] = 62;
	literals["BoxData"] = 16;
	literals["WindowElements"] = 61;
	literals["FontFamily"] = 37;
	literals["ShowCellBracket"] = 55;
	literals["FormBox"] = 18;
	literals["ImageSize"] = 84;
	literals["OutputForm"] = 80;
	literals["Null"] = 81;
	literals["ScreenRectangle"] = 50;
	literals["ImageMargins"] = 85;
	literals["Open"] = 69;
	literals["RowBox"] = 19;
	literals["WindowFrame"] = 60;
	literals["ButtonEvaluator"] = 47;
	literals["FrontEnd"] = 4;
	literals["CellFrame"] = 53;
	literals["StartModelEditor"] = 31;
	literals["ImageCache"] = 88;
	literals["False"] = 75;
	literals["CellTags"] = 52;
	literals["ButtonStyle"] = 48;
	literals["UnderscriptBox"] = 24;
	literals["ButtonFunction"] = 45;
	literals["SuperscriptBox"] = 21;
	literals["RGBColor"] = 13;
	literals["WindowToolbars"] = 63;
	literals["None"] = 82;
	literals["Closed"] = 70;
	literals["DirectedInfinity"] = 30;
	literals["Background"] = 57;
	literals["FileName"] = 14;
	literals["SubscriptBox"] = 22;
	literals["TraditionalForm"] = 77;
	literals["Right"] = 71;
	literals["ButtonData"] = 46;
	literals["StandardForm"] = 78;
	literals["ImageRangeCache"] = 87;
	literals["FontSlant"] = 33;
	literals["WindowMargins"] = 59;
	literals["ImageRegion"] = 86;
	literals["GeneratedCell"] = 54;
	literals["WindowClickSelect"] = 66;
	literals["WindowSize"] = 58;
	literals["GridBox"] = 20;
	literals["GenerateCell"] = 89;
	literals["GrayLevel"] = 12;
	literals["Notebook"] = 6;
	literals["Rule"] = 10;
	literals["PageWidth"] = 43;
	literals["UnderoverscriptBox"] = 26;
	literals["StyleDefinitions"] = 67;
	literals["FontColor"] = 35;
	literals["OLEData"] = 32;
	literals["FormatType"] = 42;
	literals["AutoGeneratedPackage"] = 51;
	literals["Left"] = 72;
	literals["GraphicsData"] = 83;
	literals["TextAlignment"] = 39;
	literals["RuleDelayed"] = 11;
	literals["InitializationCell"] = 41;
	literals["FractionBox"] = 27;
	literals["CellGroupData"] = 9;
	literals["SubsuperscriptBox"] = 23;
	literals["Automatic"] = 76;
	literals["FontSize"] = 34;
	literals["WindowFloating"] = 65;
	literals["StyleBox"] = 15;
	literals["OverscriptBox"] = 25;
	literals["RadicalBox"] = 29;
	literals["Cell"] = 7;
	literals["True"] = 74;
	literals["InputForm"] = 79;
	literals["FontWeight"] = 36;
	literals["CharacterEncoding"] = 49;
}

ANTLR_USE_NAMESPACE(antlr)RefToken AntlrNotebookLexer::nextToken()
{
	ANTLR_USE_NAMESPACE(antlr)RefToken theRetToken;
	for (;;) {
		ANTLR_USE_NAMESPACE(antlr)RefToken theRetToken;
		int _ttype = ANTLR_USE_NAMESPACE(antlr)Token::INVALID_TYPE;
		resetText();
		try {   // for lexical and char stream error handling
			switch ( LA(1)) {
			case 0x5d /* ']' */ :
			{
				mRBRACK(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x5b /* '[' */ :
			{
				mLBRACK(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x7d /* '}' */ :
			{
				mRCURLY(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x7b /* '{' */ :
			{
				mLCURLY(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x2c /* ',' */ :
			{
				mCOMMA(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x60 /* '`' */ :
			{
				mTHICK(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x2a /* '*' */ :
			{
				mCOMMENTEND(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x2d /* '-' */ :
			case 0x30 /* '0' */ :
			case 0x31 /* '1' */ :
			case 0x32 /* '2' */ :
			case 0x33 /* '3' */ :
			case 0x34 /* '4' */ :
			case 0x35 /* '5' */ :
			case 0x36 /* '6' */ :
			case 0x37 /* '7' */ :
			case 0x38 /* '8' */ :
			case 0x39 /* '9' */ :
			{
				mNUMBER(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x41 /* 'A' */ :
			case 0x42 /* 'B' */ :
			case 0x43 /* 'C' */ :
			case 0x44 /* 'D' */ :
			case 0x45 /* 'E' */ :
			case 0x46 /* 'F' */ :
			case 0x47 /* 'G' */ :
			case 0x48 /* 'H' */ :
			case 0x49 /* 'I' */ :
			case 0x4a /* 'J' */ :
			case 0x4b /* 'K' */ :
			case 0x4c /* 'L' */ :
			case 0x4d /* 'M' */ :
			case 0x4e /* 'N' */ :
			case 0x4f /* 'O' */ :
			case 0x50 /* 'P' */ :
			case 0x51 /* 'Q' */ :
			case 0x52 /* 'R' */ :
			case 0x53 /* 'S' */ :
			case 0x54 /* 'T' */ :
			case 0x55 /* 'U' */ :
			case 0x56 /* 'V' */ :
			case 0x57 /* 'W' */ :
			case 0x58 /* 'X' */ :
			case 0x59 /* 'Y' */ :
			case 0x5a /* 'Z' */ :
			case 0x61 /* 'a' */ :
			case 0x62 /* 'b' */ :
			case 0x63 /* 'c' */ :
			case 0x64 /* 'd' */ :
			case 0x65 /* 'e' */ :
			case 0x66 /* 'f' */ :
			case 0x67 /* 'g' */ :
			case 0x68 /* 'h' */ :
			case 0x69 /* 'i' */ :
			case 0x6a /* 'j' */ :
			case 0x6b /* 'k' */ :
			case 0x6c /* 'l' */ :
			case 0x6d /* 'm' */ :
			case 0x6e /* 'n' */ :
			case 0x6f /* 'o' */ :
			case 0x70 /* 'p' */ :
			case 0x71 /* 'q' */ :
			case 0x72 /* 'r' */ :
			case 0x73 /* 's' */ :
			case 0x74 /* 't' */ :
			case 0x75 /* 'u' */ :
			case 0x76 /* 'v' */ :
			case 0x77 /* 'w' */ :
			case 0x78 /* 'x' */ :
			case 0x79 /* 'y' */ :
			case 0x7a /* 'z' */ :
			{
				mID(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x22 /* '"' */ :
			{
				mQSTRING(true);
				theRetToken=_returnToken;
				break;
			}
			case 0x9 /* '\t' */ :
			case 0xa /* '\n' */ :
			case 0xd /* '\r' */ :
			case 0x20 /* ' ' */ :
			{
				mWHITESPACE(true);
				theRetToken=_returnToken;
				break;
			}
			default:
				if ((LA(1) == 0x28 /* '(' */ ) && (LA(2) == 0x2a /* '*' */ ) && ((LA(3) >= 0x0 /* '\0' */  && LA(3) <= 0x7f))) {
					mCOMMENT(true);
					theRetToken=_returnToken;
				}
				else if ((LA(1) == 0x28 /* '(' */ ) && (LA(2) == 0x2a /* '*' */ ) && (true)) {
					mCOMMENTSTART(true);
					theRetToken=_returnToken;
				}
			else {
				if (LA(1)==EOF_CHAR)
				{
					uponEOF();
					_returnToken = makeToken(ANTLR_USE_NAMESPACE(antlr)Token::EOF_TYPE);
				}
				else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());}
			}
			}
			if ( !_returnToken )
				goto tryAgain; // found SKIP token

			_ttype = _returnToken->getType();
			_ttype = testLiteralsTable(_ttype);
			_returnToken->setType(_ttype);
			return _returnToken;
		}
		catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& e) {
			{
				reportError(e);
				consume();
			}
		}
		catch (ANTLR_USE_NAMESPACE(antlr)CharStreamIOException& csie) {
			throw ANTLR_USE_NAMESPACE(antlr)TokenStreamIOException(csie.io);
		}
		catch (ANTLR_USE_NAMESPACE(antlr)CharStreamException& cse) {
			throw ANTLR_USE_NAMESPACE(antlr)TokenStreamException(cse.getMessage());
		}
tryAgain:;
	}
}

void AntlrNotebookLexer::mRBRACK(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = RBRACK;
	int _saveIndex;
	
	try {      // for error handling
		match(']');
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mLBRACK(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = LBRACK;
	int _saveIndex;
	
	try {      // for error handling
		match('[');
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mRCURLY(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = RCURLY;
	int _saveIndex;
	
	try {      // for error handling
		match('}');
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mLCURLY(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = LCURLY;
	int _saveIndex;
	
	try {      // for error handling
		match('{');
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mCOMMA(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = COMMA;
	int _saveIndex;
	
	try {      // for error handling
		match(',');
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mTHICK(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = THICK;
	int _saveIndex;
	
	try {      // for error handling
		match('`');
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_1);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mCOMMENTSTART(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = COMMENTSTART;
	int _saveIndex;
	
	try {      // for error handling
		match("(*");
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_2);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mCOMMENTEND(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = COMMENTEND;
	int _saveIndex;
	
	try {      // for error handling
		match("*)");
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mNUMBER(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = NUMBER;
	int _saveIndex;
	
	try {      // for error handling
		{
		switch ( LA(1)) {
		case 0x2d /* '-' */ :
		{
			match('-');
			break;
		}
		case 0x30 /* '0' */ :
		case 0x31 /* '1' */ :
		case 0x32 /* '2' */ :
		case 0x33 /* '3' */ :
		case 0x34 /* '4' */ :
		case 0x35 /* '5' */ :
		case 0x36 /* '6' */ :
		case 0x37 /* '7' */ :
		case 0x38 /* '8' */ :
		case 0x39 /* '9' */ :
		{
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
		}
		}
		}
		{ // ( ... )+
		int _cnt12=0;
		for (;;) {
			if (((LA(1) >= 0x30 /* '0' */  && LA(1) <= 0x39 /* '9' */ ))) {
				mDIGIT(false);
			}
			else {
				if ( _cnt12>=1 ) { goto _loop12; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());}
			}
			
			_cnt12++;
		}
		_loop12:;
		}  // ( ... )+
		{
		if ((LA(1) == 0x2e /* '.' */ )) {
			match('.');
			{ // ( ... )+
			int _cnt15=0;
			for (;;) {
				if (((LA(1) >= 0x30 /* '0' */  && LA(1) <= 0x39 /* '9' */ ))) {
					mDIGIT(false);
				}
				else {
					if ( _cnt15>=1 ) { goto _loop15; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());}
				}
				
				_cnt15++;
			}
			_loop15:;
			}  // ( ... )+
		}
		else {
		}
		
		}
		{
		if ((LA(1) == 0x45 /* 'E' */  || LA(1) == 0x60 /* '`' */  || LA(1) == 0x65 /* 'e' */ )) {
			mEXP(false);
		}
		else {
		}
		
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mDIGIT(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = DIGIT;
	int _saveIndex;
	
	try {      // for error handling
		matchRange('0','9');
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_3);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mEXP(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = EXP;
	int _saveIndex;
	
	try {      // for error handling
		switch ( LA(1)) {
		case 0x45 /* 'E' */ :
		case 0x65 /* 'e' */ :
		{
			{
			switch ( LA(1)) {
			case 0x65 /* 'e' */ :
			{
				match('e');
				break;
			}
			case 0x45 /* 'E' */ :
			{
				match('E');
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
			}
			}
			}
			mNUMBER(false);
			break;
		}
		case 0x60 /* '`' */ :
		{
			{
			mTHICK(false);
			{
			if ((LA(1) == 0x60 /* '`' */ )) {
				mTHICK(false);
			}
			else {
			}
			
			}
			{
			if ((_tokenSet_4.member(LA(1)))) {
				mNUMBER(false);
			}
			else {
			}
			
			}
			}
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mID(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = ID;
	int _saveIndex;
	
	try {      // for error handling
		{ // ( ... )+
		int _cnt19=0;
		for (;;) {
			switch ( LA(1)) {
			case 0x61 /* 'a' */ :
			case 0x62 /* 'b' */ :
			case 0x63 /* 'c' */ :
			case 0x64 /* 'd' */ :
			case 0x65 /* 'e' */ :
			case 0x66 /* 'f' */ :
			case 0x67 /* 'g' */ :
			case 0x68 /* 'h' */ :
			case 0x69 /* 'i' */ :
			case 0x6a /* 'j' */ :
			case 0x6b /* 'k' */ :
			case 0x6c /* 'l' */ :
			case 0x6d /* 'm' */ :
			case 0x6e /* 'n' */ :
			case 0x6f /* 'o' */ :
			case 0x70 /* 'p' */ :
			case 0x71 /* 'q' */ :
			case 0x72 /* 'r' */ :
			case 0x73 /* 's' */ :
			case 0x74 /* 't' */ :
			case 0x75 /* 'u' */ :
			case 0x76 /* 'v' */ :
			case 0x77 /* 'w' */ :
			case 0x78 /* 'x' */ :
			case 0x79 /* 'y' */ :
			case 0x7a /* 'z' */ :
			{
				matchRange('a','z');
				break;
			}
			case 0x41 /* 'A' */ :
			case 0x42 /* 'B' */ :
			case 0x43 /* 'C' */ :
			case 0x44 /* 'D' */ :
			case 0x45 /* 'E' */ :
			case 0x46 /* 'F' */ :
			case 0x47 /* 'G' */ :
			case 0x48 /* 'H' */ :
			case 0x49 /* 'I' */ :
			case 0x4a /* 'J' */ :
			case 0x4b /* 'K' */ :
			case 0x4c /* 'L' */ :
			case 0x4d /* 'M' */ :
			case 0x4e /* 'N' */ :
			case 0x4f /* 'O' */ :
			case 0x50 /* 'P' */ :
			case 0x51 /* 'Q' */ :
			case 0x52 /* 'R' */ :
			case 0x53 /* 'S' */ :
			case 0x54 /* 'T' */ :
			case 0x55 /* 'U' */ :
			case 0x56 /* 'V' */ :
			case 0x57 /* 'W' */ :
			case 0x58 /* 'X' */ :
			case 0x59 /* 'Y' */ :
			case 0x5a /* 'Z' */ :
			{
				matchRange('A','Z');
				break;
			}
			default:
			{
				if ( _cnt19>=1 ) { goto _loop19; } else {throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());}
			}
			}
			_cnt19++;
		}
		_loop19:;
		}  // ( ... )+
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mQSTRING(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = QSTRING;
	int _saveIndex;
	
	try {      // for error handling
		match('"');
		{ // ( ... )*
		for (;;) {
			switch ( LA(1)) {
			case 0xa /* '\n' */ :
			case 0xd /* '\r' */ :
			{
				{
				switch ( LA(1)) {
				case 0xd /* '\r' */ :
				{
					match('\r');
					break;
				}
				case 0xa /* '\n' */ :
				{
					match('\n');
					break;
				}
				default:
				{
					throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
				}
				}
				}
				newline();
				break;
			}
			case 0x0 /* '\0' */ :
			case 0x1 /* '\1' */ :
			case 0x2 /* '\2' */ :
			case 0x3 /* '\3' */ :
			case 0x4 /* '\4' */ :
			case 0x5 /* '\5' */ :
			case 0x6 /* '\6' */ :
			case 0x7 /* '\7' */ :
			case 0x8 /* '\10' */ :
			case 0x9 /* '\t' */ :
			case 0xb /* '\13' */ :
			case 0xc /* '\14' */ :
			case 0xe /* '\16' */ :
			case 0xf /* '\17' */ :
			case 0x10 /* '\20' */ :
			case 0x11 /* '\21' */ :
			case 0x12 /* '\22' */ :
			case 0x13 /* '\23' */ :
			case 0x14 /* '\24' */ :
			case 0x15 /* '\25' */ :
			case 0x16 /* '\26' */ :
			case 0x17 /* '\27' */ :
			case 0x18 /* '\30' */ :
			case 0x19 /* '\31' */ :
			case 0x1a /* '\32' */ :
			case 0x1b /* '\33' */ :
			case 0x1c /* '\34' */ :
			case 0x1d /* '\35' */ :
			case 0x1e /* '\36' */ :
			case 0x1f /* '\37' */ :
			case 0x20 /* ' ' */ :
			case 0x21 /* '!' */ :
			case 0x23 /* '#' */ :
			case 0x24 /* '$' */ :
			case 0x25 /* '%' */ :
			case 0x26 /* '&' */ :
			case 0x27 /* '\'' */ :
			case 0x28 /* '(' */ :
			case 0x29 /* ')' */ :
			case 0x2a /* '*' */ :
			case 0x2b /* '+' */ :
			case 0x2c /* ',' */ :
			case 0x2d /* '-' */ :
			case 0x2e /* '.' */ :
			case 0x2f /* '/' */ :
			case 0x30 /* '0' */ :
			case 0x31 /* '1' */ :
			case 0x32 /* '2' */ :
			case 0x33 /* '3' */ :
			case 0x34 /* '4' */ :
			case 0x35 /* '5' */ :
			case 0x36 /* '6' */ :
			case 0x37 /* '7' */ :
			case 0x38 /* '8' */ :
			case 0x39 /* '9' */ :
			case 0x3a /* ':' */ :
			case 0x3b /* ';' */ :
			case 0x3c /* '<' */ :
			case 0x3d /* '=' */ :
			case 0x3e /* '>' */ :
			case 0x3f /* '?' */ :
			case 0x40 /* '@' */ :
			case 0x41 /* 'A' */ :
			case 0x42 /* 'B' */ :
			case 0x43 /* 'C' */ :
			case 0x44 /* 'D' */ :
			case 0x45 /* 'E' */ :
			case 0x46 /* 'F' */ :
			case 0x47 /* 'G' */ :
			case 0x48 /* 'H' */ :
			case 0x49 /* 'I' */ :
			case 0x4a /* 'J' */ :
			case 0x4b /* 'K' */ :
			case 0x4c /* 'L' */ :
			case 0x4d /* 'M' */ :
			case 0x4e /* 'N' */ :
			case 0x4f /* 'O' */ :
			case 0x50 /* 'P' */ :
			case 0x51 /* 'Q' */ :
			case 0x52 /* 'R' */ :
			case 0x53 /* 'S' */ :
			case 0x54 /* 'T' */ :
			case 0x55 /* 'U' */ :
			case 0x56 /* 'V' */ :
			case 0x57 /* 'W' */ :
			case 0x58 /* 'X' */ :
			case 0x59 /* 'Y' */ :
			case 0x5a /* 'Z' */ :
			case 0x5b /* '[' */ :
			case 0x5d /* ']' */ :
			case 0x5e /* '^' */ :
			case 0x5f /* '_' */ :
			case 0x60 /* '`' */ :
			case 0x61 /* 'a' */ :
			case 0x62 /* 'b' */ :
			case 0x63 /* 'c' */ :
			case 0x64 /* 'd' */ :
			case 0x65 /* 'e' */ :
			case 0x66 /* 'f' */ :
			case 0x67 /* 'g' */ :
			case 0x68 /* 'h' */ :
			case 0x69 /* 'i' */ :
			case 0x6a /* 'j' */ :
			case 0x6b /* 'k' */ :
			case 0x6c /* 'l' */ :
			case 0x6d /* 'm' */ :
			case 0x6e /* 'n' */ :
			case 0x6f /* 'o' */ :
			case 0x70 /* 'p' */ :
			case 0x71 /* 'q' */ :
			case 0x72 /* 'r' */ :
			case 0x73 /* 's' */ :
			case 0x74 /* 't' */ :
			case 0x75 /* 'u' */ :
			case 0x76 /* 'v' */ :
			case 0x77 /* 'w' */ :
			case 0x78 /* 'x' */ :
			case 0x79 /* 'y' */ :
			case 0x7a /* 'z' */ :
			case 0x7b /* '{' */ :
			case 0x7c /* '|' */ :
			case 0x7d /* '}' */ :
			case 0x7e /* '~' */ :
			case 0x7f:
			{
				{
				match(_tokenSet_5);
				}
				break;
			}
			default:
				if ((LA(1) == 0x5c /* '\\' */ ) && (LA(2) == 0x22 /* '"' */ ) && ((LA(3) >= 0x0 /* '\0' */  && LA(3) <= 0x7f))) {
					match('\\');
					match('"');
				}
				else if (((LA(1) == 0x5c /* '\\' */ ) && ((LA(2) >= 0x0 /* '\0' */  && LA(2) <= 0x7f)) && (true))&&(LA(2) != '"')) {
					match('\\');
				}
			else {
				goto _loop30;
			}
			}
		}
		_loop30:;
		} // ( ... )*
		match('"');
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mWHITESPACE(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = WHITESPACE;
	int _saveIndex;
	
	try {      // for error handling
		{
		switch ( LA(1)) {
		case 0x20 /* ' ' */ :
		{
			match(' ');
			break;
		}
		case 0x9 /* '\t' */ :
		{
			match('\t');
			break;
		}
		case 0xa /* '\n' */ :
		case 0xd /* '\r' */ :
		{
			{
			if ((LA(1) == 0xd /* '\r' */ ) && (LA(2) == 0xa /* '\n' */ )) {
				match("\r\n");
			}
			else if ((LA(1) == 0xd /* '\r' */ ) && (true)) {
				match('\r');
			}
			else if ((LA(1) == 0xa /* '\n' */ )) {
				match('\n');
			}
			else {
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
			}
			
			}
			newline();
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
		}
		}
		}
		_ttype = ANTLR_USE_NAMESPACE(antlr)Token::SKIP;
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}

void AntlrNotebookLexer::mCOMMENT(bool _createToken) {
	int _ttype; ANTLR_USE_NAMESPACE(antlr)RefToken _token; int _begin=text.length();
	_ttype = COMMENT;
	int _saveIndex;
	
	try {      // for error handling
		mCOMMENTSTART(false);
		{ // ( ... )*
		for (;;) {
			switch ( LA(1)) {
			case 0xa /* '\n' */ :
			case 0xd /* '\r' */ :
			{
				{
				switch ( LA(1)) {
				case 0xd /* '\r' */ :
				{
					match('\r');
					break;
				}
				case 0xa /* '\n' */ :
				{
					match('\n');
					break;
				}
				default:
				{
					throw ANTLR_USE_NAMESPACE(antlr)NoViableAltForCharException(LA(1), getFilename(), getLine(), getColumn());
				}
				}
				}
				newline();
				break;
			}
			case 0x0 /* '\0' */ :
			case 0x1 /* '\1' */ :
			case 0x2 /* '\2' */ :
			case 0x3 /* '\3' */ :
			case 0x4 /* '\4' */ :
			case 0x5 /* '\5' */ :
			case 0x6 /* '\6' */ :
			case 0x7 /* '\7' */ :
			case 0x8 /* '\10' */ :
			case 0x9 /* '\t' */ :
			case 0xb /* '\13' */ :
			case 0xc /* '\14' */ :
			case 0xe /* '\16' */ :
			case 0xf /* '\17' */ :
			case 0x10 /* '\20' */ :
			case 0x11 /* '\21' */ :
			case 0x12 /* '\22' */ :
			case 0x13 /* '\23' */ :
			case 0x14 /* '\24' */ :
			case 0x15 /* '\25' */ :
			case 0x16 /* '\26' */ :
			case 0x17 /* '\27' */ :
			case 0x18 /* '\30' */ :
			case 0x19 /* '\31' */ :
			case 0x1a /* '\32' */ :
			case 0x1b /* '\33' */ :
			case 0x1c /* '\34' */ :
			case 0x1d /* '\35' */ :
			case 0x1e /* '\36' */ :
			case 0x1f /* '\37' */ :
			case 0x20 /* ' ' */ :
			case 0x21 /* '!' */ :
			case 0x22 /* '"' */ :
			case 0x23 /* '#' */ :
			case 0x24 /* '$' */ :
			case 0x25 /* '%' */ :
			case 0x26 /* '&' */ :
			case 0x27 /* '\'' */ :
			case 0x28 /* '(' */ :
			case 0x29 /* ')' */ :
			case 0x2b /* '+' */ :
			case 0x2c /* ',' */ :
			case 0x2d /* '-' */ :
			case 0x2e /* '.' */ :
			case 0x2f /* '/' */ :
			case 0x30 /* '0' */ :
			case 0x31 /* '1' */ :
			case 0x32 /* '2' */ :
			case 0x33 /* '3' */ :
			case 0x34 /* '4' */ :
			case 0x35 /* '5' */ :
			case 0x36 /* '6' */ :
			case 0x37 /* '7' */ :
			case 0x38 /* '8' */ :
			case 0x39 /* '9' */ :
			case 0x3a /* ':' */ :
			case 0x3b /* ';' */ :
			case 0x3c /* '<' */ :
			case 0x3d /* '=' */ :
			case 0x3e /* '>' */ :
			case 0x3f /* '?' */ :
			case 0x40 /* '@' */ :
			case 0x41 /* 'A' */ :
			case 0x42 /* 'B' */ :
			case 0x43 /* 'C' */ :
			case 0x44 /* 'D' */ :
			case 0x45 /* 'E' */ :
			case 0x46 /* 'F' */ :
			case 0x47 /* 'G' */ :
			case 0x48 /* 'H' */ :
			case 0x49 /* 'I' */ :
			case 0x4a /* 'J' */ :
			case 0x4b /* 'K' */ :
			case 0x4c /* 'L' */ :
			case 0x4d /* 'M' */ :
			case 0x4e /* 'N' */ :
			case 0x4f /* 'O' */ :
			case 0x50 /* 'P' */ :
			case 0x51 /* 'Q' */ :
			case 0x52 /* 'R' */ :
			case 0x53 /* 'S' */ :
			case 0x54 /* 'T' */ :
			case 0x55 /* 'U' */ :
			case 0x56 /* 'V' */ :
			case 0x57 /* 'W' */ :
			case 0x58 /* 'X' */ :
			case 0x59 /* 'Y' */ :
			case 0x5a /* 'Z' */ :
			case 0x5b /* '[' */ :
			case 0x5c /* '\\' */ :
			case 0x5d /* ']' */ :
			case 0x5e /* '^' */ :
			case 0x5f /* '_' */ :
			case 0x60 /* '`' */ :
			case 0x61 /* 'a' */ :
			case 0x62 /* 'b' */ :
			case 0x63 /* 'c' */ :
			case 0x64 /* 'd' */ :
			case 0x65 /* 'e' */ :
			case 0x66 /* 'f' */ :
			case 0x67 /* 'g' */ :
			case 0x68 /* 'h' */ :
			case 0x69 /* 'i' */ :
			case 0x6a /* 'j' */ :
			case 0x6b /* 'k' */ :
			case 0x6c /* 'l' */ :
			case 0x6d /* 'm' */ :
			case 0x6e /* 'n' */ :
			case 0x6f /* 'o' */ :
			case 0x70 /* 'p' */ :
			case 0x71 /* 'q' */ :
			case 0x72 /* 'r' */ :
			case 0x73 /* 's' */ :
			case 0x74 /* 't' */ :
			case 0x75 /* 'u' */ :
			case 0x76 /* 'v' */ :
			case 0x77 /* 'w' */ :
			case 0x78 /* 'x' */ :
			case 0x79 /* 'y' */ :
			case 0x7a /* 'z' */ :
			case 0x7b /* '{' */ :
			case 0x7c /* '|' */ :
			case 0x7d /* '}' */ :
			case 0x7e /* '~' */ :
			case 0x7f:
			{
				{
				match(_tokenSet_6);
				}
				break;
			}
			default:
				if (((LA(1) == 0x2a /* '*' */ ) && ((LA(2) >= 0x0 /* '\0' */  && LA(2) <= 0x7f)) && ((LA(3) >= 0x0 /* '\0' */  && LA(3) <= 0x7f)))&&(LA(2) != ')')) {
					match('*');
				}
			else {
				goto _loop38;
			}
			}
		}
		_loop38:;
		} // ( ... )*
		mCOMMENTEND(false);
		_ttype = ANTLR_USE_NAMESPACE(antlr)Token::SKIP;
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	if ( _createToken && _token==ANTLR_USE_NAMESPACE(antlr)nullToken && _ttype!=ANTLR_USE_NAMESPACE(antlr)Token::SKIP ) {
	   _token = makeToken(_ttype);
	   _token->setText(text.substr(_begin, text.length()-_begin));
	}
	_returnToken = _token;
	_saveIndex=0;
}


const unsigned long AntlrNotebookLexer::_tokenSet_0_data_[] = { 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookLexer::_tokenSet_0(_tokenSet_0_data_,6);
const unsigned long AntlrNotebookLexer::_tokenSet_1_data_[] = { 0UL, 67051520UL, 0UL, 1UL, 0UL, 0UL, 0UL, 0UL };
// - 0 1 2 3 4 5 6 7 8 9 ` 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookLexer::_tokenSet_1(_tokenSet_1_data_,8);
const unsigned long AntlrNotebookLexer::_tokenSet_2_data_[] = { 4294967295UL, 4294967295UL, 4294967295UL, 4294967295UL, 0UL, 0UL, 0UL, 0UL };
// 0x0 0x1 0x2 0x3 0x4 0x5 0x6 0x7 0x8 0x9 0xa 0xb 0xc 0xd 0xe 0xf 0x10 
// 0x11 0x12 0x13 0x14 0x15 0x16 0x17 0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 
// 0x1f   ! " # $ % & \' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > 
// ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \\ ] ^ _ ` 
// a b c d e f g h i j k 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookLexer::_tokenSet_2(_tokenSet_2_data_,8);
const unsigned long AntlrNotebookLexer::_tokenSet_3_data_[] = { 0UL, 67059712UL, 32UL, 33UL, 0UL, 0UL, 0UL, 0UL };
// . 0 1 2 3 4 5 6 7 8 9 E ` e 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookLexer::_tokenSet_3(_tokenSet_3_data_,8);
const unsigned long AntlrNotebookLexer::_tokenSet_4_data_[] = { 0UL, 67051520UL, 0UL, 0UL, 0UL, 0UL };
// - 0 1 2 3 4 5 6 7 8 9 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookLexer::_tokenSet_4(_tokenSet_4_data_,6);
const unsigned long AntlrNotebookLexer::_tokenSet_5_data_[] = { 4294958079UL, 4294967291UL, 4026531839UL, 4294967295UL, 0UL, 0UL, 0UL, 0UL };
// 0x0 0x1 0x2 0x3 0x4 0x5 0x6 0x7 0x8 0x9 0xb 0xc 0xe 0xf 0x10 0x11 0x12 
// 0x13 0x14 0x15 0x16 0x17 0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 0x1f   ! 
// # $ % & \' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D 
// E F G H I J K L M N O P Q R S T U V W X Y Z [ ] ^ _ ` a b c d e f g 
// h i j k 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookLexer::_tokenSet_5(_tokenSet_5_data_,8);
const unsigned long AntlrNotebookLexer::_tokenSet_6_data_[] = { 4294958079UL, 4294966271UL, 4294967295UL, 4294967295UL, 0UL, 0UL, 0UL, 0UL };
// 0x0 0x1 0x2 0x3 0x4 0x5 0x6 0x7 0x8 0x9 0xb 0xc 0xe 0xf 0x10 0x11 0x12 
// 0x13 0x14 0x15 0x16 0x17 0x18 0x19 0x1a 0x1b 0x1c 0x1d 0x1e 0x1f   ! 
// " # $ % & \' ( ) + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D 
// E F G H I J K L M N O P Q R S T U V W X Y Z [ \\ ] ^ _ ` a b c d e f 
// g h i j k 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookLexer::_tokenSet_6(_tokenSet_6_data_,8);

