encapsulated model NandGate "CMOS NAND Gate (see Tietze/Schenk, page 157)"
   import Modelica.Electrical.Analog.Basic;
   import Modelica.Electrical.Analog.Sources;
   import Modelica.Electrical.Analog.Examples.Utilities;
   import Modelica.Icons;
   extends Icons.Example;
   annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Documentation(info="<html>
 <p>
 The nand gate is a basic CMOS building block. It consists of four CMOS transistors.
 The output voltage Nand.y.v is low if and only if the two input voltages at Nand.x1.v and Nand.x2.v
 are both high. In this way the nand functionality is realized.
 <p>
 The simulation end time should be set to 1e-7. Please plot the input voltages Nand.x1.v,
 d Nand.x2.v, and the output voltage Nand.y.v.
 <p>
 <dl>
 <dt>
 <b>Reference:</b>
 <dd>
 Tietze, U.; Schenk, Ch.: Halbleiter-Schaltungstechnik. Springer-Verlag Berlin Heidelberg NewYork 1980, p. 157
 <p>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
   Sources.TrapezoidVoltage VIN1(V=3.5,startTime=1/50000000,rising=1/1000000000,width=19/1000000000,falling=1.e-9,period=1/25000000) annotation (Placement(transformation(x=-70.,y=20.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=-70.,y=20.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Sources.TrapezoidVoltage VIN2(V=3.5,startTime=1/100000000,rising=1/1000000000,width=19/1000000000,falling=1.e-9,period=1/25000000) annotation (Placement(transformation(x=-70.,y=-30.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=-70.,y=-30.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Sources.RampVoltage VDD(V=5,duration=1/1000000000) annotation (Placement(transformation(x=50.,y=70.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=50.,y=70.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Basic.Ground Gnd1 annotation (Placement(transformation(x=50.,y=48.,scale=0.05,aspectRatio=1.),iconTransformation(x=50.,y=48.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd4 annotation (Placement(transformation(x=-70.,y=0.,scale=0.05,aspectRatio=1.),iconTransformation(x=-70.,y=0.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd5 annotation (Placement(transformation(x=-70.,y=-50.,scale=0.05,aspectRatio=1.),iconTransformation(x=-70.,y=-50.,scale=0.05,aspectRatio=1.)));
   Utilities.Nand Nand annotation (Placement(transformation(x=0.,y=5.,scale=0.4,aspectRatio=1.25),iconTransformation(x=0.,y=5.,scale=0.4,aspectRatio=1.25)));
   
equation
   connect(VDD.n, Gnd1.p) annotation (Line(points={{50.,60.},{50.,53.}},color={0,0,255}));
   connect(VIN1.n, Gnd4.p) annotation (Line(points={{-70.,10.},{-70.,5.}},color={0,0,255}));
   connect(VIN2.n, Gnd5.p) annotation (Line(points={{-70.,-40.},{-70.,-45.}},color={0,0,255}));
   connect(Nand.Vdd, VDD.p) annotation (Line(points={{0.,55.},{0.,90.},{50.,90.},{50.,80.}},color={0,0,255}));
   connect(VIN1.p, Nand.x1) annotation (Line(points={{-70.,30.},{-40.,30.}},color={0,0,255}));
   connect(VIN2.p, Nand.x2) annotation (Line(points={{-70.,-20.},{-40.,-20.}},color={0,0,255}));
end NandGate;