# Tests for the HistogramMLApplication
#
# @Author: Christopher Hylands, Edward A. Lee
#
# @Version: $Id: HistogramMLApplication.tcl,v 1.6 2005/02/28 19:48:15 cxh Exp $
#
# @Copyright (c) 1998-2005 The Regents of the University of California.
# All rights reserved.
#
# Permission is hereby granted, without written agreement and without
# license or royalty fees, to use, copy, modify, and distribute this
# software and its documentation for any purpose, provided that the
# above copyright notice and the following two paragraphs appear in all
# copies of this software.
#
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
# FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
# ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
# THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
# PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
# CALIFORNIA HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
# ENHANCEMENTS, OR MODIFICATIONS.
#
# 						PT_COPYRIGHT_VERSION_2
# 						COPYRIGHTENDKEY
#######################################################################

# Load up the test definitions.
if {[string compare test [info procs test]] == 1} then {
    source testDefs.tcl
} {}

if {[info procs jdkCapture] == "" } then {
    source [file join $PTII util testsuite jdktools.tcl]
}

# Uncomment this to get a full report, or set in your Tcl shell window.
# set VERBOSE 1

########################################
#### histogramFiles
# Create two test files histogramfile1 histogramfile2
#
proc histogramFiles {} {
    global histogramfile1 histogramfile2 tcl_platform
    if { $tcl_platform(host_platform) == "windows"} {
	set histogramfile1 histogramfile1.plt
	set histogramfile2 histogramfile2.plt
    } else {
	set histogramfile1 /tmp/histogramfile1.plt
	set histogramfile2 /tmp/histogramfile2.plt
    }

    set fd [open $histogramfile1 w]
    puts $fd "TitleText: Sample histogram\n"
    puts $fd "XLabel: values\n"
    puts $fd "YLabel: count\n"
    puts $fd "YRange: 0.0,100.0\n"
    puts $fd "BarGraph: 0.5,0.15\n"
    puts $fd "BinWidth: 1.0\n"
    puts $fd "BinOffset: 0.5\n"
    puts $fd "DataSet: first\n"
    puts $fd "5.0\n"
    puts $fd "4.9999013042806855\n"
    puts $fd "4.99960522101908\n"
    close $fd

    #set fd [open $histogramfile2 w]
    #puts $fd "0 1\n		1 2\nmove:2 2.5\n 3 1"
    #close $fd
}
histogramFiles

########################################
#### histogramTest
# Pass arguments to Histogram, run it, write the output to
# a variable, sleep, dispose of the Histogram, then return the results
# 
#
proc histogramTest { args } {
    global defaultPlotMLHeader
    set jargs [java::new {String[]} [llength $args] $args ]
    set histogram [java::new ptolemy.plot.plotml.HistogramMLApplication $jargs]
    set stream [java::new java.io.ByteArrayOutputStream]
    set printStream [java::new \
	    {java.io.PrintStream java.io.OutputStream} $stream]
    set plotFrame [java::cast ptolemy.plot.PlotFrame $histogram ]
    set plot [java::field $plotFrame plot]
    $plot write $printStream "Usually, the DTD would go here"
    $printStream flush
    set results [$stream toString]
    set thread [java::call Thread currentThread ]
    # sleep 10 seconds
    $thread sleep 10000
    $histogram dispose
    # This hack is necessary because of problems with crnl under windows
    regsub -all [java::call System getProperty "line.separator"] \
                $results "\n" results2
    return $results2
}


test Histogram-1.1 {Get the sample output} {
    global histogramfile1 histogramfile2
    histogramTest
} {<?xml version="1.0" standalone="no"?>
<!DOCTYPE plot SYSTEM "Usually, the DTD would go here">
<plot>
<!-- Ptolemy plot, version 3.1, PlotML format. -->
<title>Sample histogram</title>
<xLabel>values</xLabel>
<yLabel>count</yLabel>
<barGraph width="0.5" offset="0.15"/>
<bin width="1.0 offset="0.5">
<dataset>
<p y="5.0"/
<p y="4.9999013042806855"/
<p y="4.99960522101908"/
<p y="4.999111761904045"/
<p y="4.9984209464165"/
<p y="4.997532801828658"/
<p y="4.996447363202946"/
<p y="4.995164673390623"/
<p y="4.993684783030087"/
<p y="4.992007750544875"/
<p y="4.990133642141358"/
<p y="4.9880625318061265"/
<p y="4.98579450130307"/
<p y="4.983329640170149"/
<p y="4.980668045715863"/
<p y="4.9778098230154"/
<p y="4.9747550849065005"/
<p y="4.971503951984994"/
<p y="4.968056552600042"/
<p y="4.964413022849069"/
<p y="4.9605735065723895"/
<p y="4.956538155347533"/
<p y="4.952307128483256"/
<p y="4.947880593013255"/
<p y="4.943258723689571"/
<p y="4.938441702975689"/
<p y="4.9334297210393405"/
<p y="4.9282229757449905"/
<p y="4.922821672646027"/
<p y="4.917226024976649"/
<p y="4.911436253643443"/
<p y="4.90545258721667"/
<p y="4.899275261921234"/
<p y="4.892904521627361"/
<p y="4.886340617840967"/
<p y="4.879583809693737"/
<p y="4.872634363932885"/
<p y="4.865492554910633"/
<p y="4.85815866457337"/
<p y="4.850632982450529"/
<p y="4.842915805643155"/
<p y="4.835007438812175"/
<p y="4.82690819416637"/
<p y="4.818618391450048"/
<p y="4.8101383579304295"/
<p y="4.801468428384715"/
<p y="4.792608945086879"/
<p y="4.783560257794153"/
<p y="4.774322723733214"/
<p y="4.764896707586094"/
<p y="4.755282581475767"/
<p y="4.745480724951473"/
<p y="4.735491524973721"/
<p y="4.725315375899024"/
<p y="4.714952679464322"/
<p y="4.704403844771127"/
<p y="4.69366928826937"/
<p y="4.682749433740962"/
<p y="4.67164471228306"/
<p y="4.660355562291055"/
<p y="4.648882429441257"/
<p y="4.637225766673306"/
<p y="4.6253860341722906"/
<p y="4.613363699350574"/
<p y="4.601159236829352"/
<p y="4.588773128419906"/
<p y="4.576205863104588"/
<p y="4.563457937017514"/
<p y="4.550529853424978"/
<p y="4.537422122705585"/
<p y="4.524135262330098"/
<p y="4.5106697968410145"/
<p y="4.497026257831855"/
<p y="4.483205183926179"/
<p y="4.469207120756319"/
<p y="4.455032620941839"/
<p y="4.440682244067723"/
<p y="4.426156556662276"/
<p y="4.4114561321747665"/
<p y="4.3965815509527815"/
<p y="4.381533400219318"/
<p y="4.3663122740496005"/
<p y="4.350918773347629"/
<p y="4.33535350582245"/
<p y="4.319617085964176"/
<p y="4.303710135019719"/
<p y="4.287633280968262"/
<p y="4.271387158496475"/
<p y="4.25497240897346"/
<p y="4.238389680425416"/
<p y="4.221639627510076"/
<p y="4.204722911490846"/
<p y="4.1876402002107085"/
<p y="4.170392168065856"/
<p y="4.152979495979063"/
<p y="4.1354028713728095"/
<p y="4.117662988142137"/
<p y="4.0997605466272615"/
<p y="4.081696253585919"/
<p y="4.06347082216547"/
<p y="4.045084971874737"/
<p y="4.026539428555609"/
<p y="4.007834924354383"/
<p y="3.9889721976928554"/
<p y="3.9699519932391762"/
<p y="3.950775061878452"/
<p y="3.9314421606830945"/
<p y="3.9119540528829404"/
<p y="3.8923115078351174"/
<p y="3.87251530099367"/
<p y="3.8525662138789456"/
<p y="3.8324650340467494"/
<p y="3.8122125550572394"/
<p y="3.7918095764436095"/
<p y="3.7712569036805195"/
<p y="3.7505553481522975"/
<p y="3.7297057271209106"/
<p y="3.708708863693696"/
<p y="3.6875655867908694"/
<p y="3.6662767311128004"/
<p y="3.644843137107058"/
<p y="3.6232656509352337"/
<p y="3.601545124439535"/
<p y="3.579682415109156"/
<p y="3.557678386046427"/
<p y="3.5355339059327378"/
<p y="3.513249848994246"/
<p y="3.4908270949673637"/
<p y="3.4682665290640244"/
<p y="3.4455690419367424"/
<p y="3.4227355296434436"/
<p y="3.3997668936120955"/
<p y="3.3766640406051223"/
<p y="3.353427882683601"/
<p y="3.3300593371712583"/
<p y="3.3065593266182596"/
<p y="3.282928778764782"/
<p y="3.2591686265043935"/
<p y="3.235279807847222"/
<p y="3.211263265882922"/
<p y="3.1871199487434487"/
<p y="3.1628508095656227"/
<p y="3.1384568064535023"/
<p y="3.1139389024405624"/
<p y="3.0892980654516715"/
<p y="3.064535268264883"/
<p y="3.039651488473027"/
<p y="3.0146477084451235"/
<p y="2.9895249152875945"/
<p y="2.9642841008052963"/
<p y="2.938926261462366"/
<p y="2.913452398342881"/
<p y="2.887863517111338"/
<p y="2.8621606279729543"/
<p y="2.8363447456337827"/
<p y="2.8104168892606527"/
<p y="2.7843780824409405"/
<p y="2.7582293531421516"/
<p y="2.731971733671345"/
<p y="2.7056062606343794"/
<p y="2.6791339748949827"/
<p y="2.6525559215336707"/
<p y="2.6258731498064787"/
<p y="2.599086713103547"/
<p y="2.572197668907533"/
<p y="2.545207078751857"/
<p y="2.5181160081788034"/
<p y="2.4909255266974544"/
<p y="2.4636367077414576"/
<p y="2.436250628626661"/
<p y="2.408768370508577"/
<p y="2.3811910183396954"/
<p y="2.353519660826663"/
<p y="2.3257553903872923"/
<p y="2.2978993031074397"/
<p y="2.269952498697734"/
<p y="2.2419160804501623"/
<p y="2.2137911551945075"/
<p y="2.185578833254664"/
<p y="2.157280228404795"/
<p y="2.1288964578253635"/
<p y="2.100428642059031"/
<p y="2.071877904966421"/
<p y="2.0432453736817453"/
<p y="2.0145321785683135"/
<p y="1.9857394531739039"/
<p y="1.9568683341860127"/
<p y="1.9279199613869822"/
<p y="1.8988954776090057"/
<p y="1.8697960286890019"/
<p y="1.8406227634233894"/
<p y="1.8113768335227287"/
<p y="1.7820593935662536"/
<p y="1.7526716009562948"/
<p y="1.7232146158725858"/
<p y="1.6936896012264575"/
<p y="1.6640977226149334"/
<p y="1.6344401482747135"/
<p y="1.604718049036047"/
<p y="1.5749325982765234"/
<p y="1.5450849718747373"/
<p y="1.5151763481638696"/
<p y="1.4852079078851743"/
<p y="1.4551808341413597"/
<p y="1.4250963123498808"/
<p y="1.3949555301961465"/
<p y="1.3647596775866269"/
<p y="1.3345099466018784"/
<p y="1.3042075314494839"/
<p y="1.2738536284169109"/
<p y="1.2434494358242736"/
<p y="1.2129961539770369"/
<p y="1.1824949851186237"/
<p y="1.1519471333829532"/
<p y="1.1213538047469058"/
<p y="1.0907162069827134"/
<p y="1.0600355496102738"/
<p y="1.0293130438494067"/
<p y="0.9985499025720361"/
<p y="0.9677473402543009"/
<p y="0.9369065729286226"/
<p y="0.9060288181356869"/
<p y="0.8751152948763802"/
<p y="0.844167223563669"/
<p y="0.8131858259744186"/
<p y="0.7821723252011547"/
<p y="0.7511279456037854"/
<p y="0.7200539127612616"/
<p y="0.688951453423191"/
<p y="0.6578217954614128"/
<p y="0.6266661678215213"/
<p y="0.5954858004743485"/
<p y="0.564281924367408"/
<p y="0.5330557713763"/
<p y="0.5018085742560745"/
<p y="0.4705415665925714"/
<p y="0.4392559827537166"/
<p y="0.40795305784078817"/
<p y="0.37663402763966375"/
<p y="0.34530012857203"/
<p y="0.31395259764656763"/
<p y="0.282592672410122"/
<p y="0.251221590898848"/
<p y="0.21984059158932448"/
<p y="0.18845091334967234"/
<p y="0.157053795390642"/
<p y="0.12565047721668765"/
<p y="0.09424219857704087"/
<p y="0.06283019941676388"/
<p y="0.03141571982779533"/
<p y="3.061616997868383E-16"/
<p y="-0.031415719827794716"/
<p y="-0.06283019941676327"/
<p y="-0.09424219857704139"/
<p y="-0.12565047721668704"/
<p y="-0.1570537953906414"/
<p y="-0.18845091334967287"/
<p y="-0.21984059158932384"/
<p y="-0.2512215908988474"/
<p y="-0.2825926724101225"/
<p y="-0.3139525976465659"/
<p y="-0.3453001285720283"/
<p y="-0.37663402763966425"/
<p y="-0.40795305784078756"/
<p y="-0.43925598275371597"/
<p y="-0.4705415665925719"/
<p y="-0.501808574256074"/
<p y="-0.5330557713762993"/
<p y="-0.5642819243674084"/
<p y="-0.5954858004743478"/
<p y="-0.6266661678215207"/
<p y="-0.6578217954614123"/
<p y="-0.6889514534231902"/
<p y="-0.7200539127612611"/
<p y="-0.7511279456037857"/
<p y="-0.7821723252011541"/
<p y="-0.8131858259744179"/
<p y="-0.8441672235636695"/
<p y="-0.8751152948763796"/
<p y="-0.9060288181356864"/
<p y="-0.936906572928623"/
<p y="-0.9677473402543003"/
<p y="-0.9985499025720345"/
<p y="-1.0293130438494074"/
<p y="-1.060035549610273"/
<p y="-1.0907162069827128"/
<p y="-1.1213538047469063"/
<p y="-1.1519471333829525"/
<p y="-1.1824949851186233"/
<p y="-1.212996153977037"/
<p y="-1.2434494358242731"/
<p y="-1.2738536284169102"/
<p y="-1.3042075314494843"/
<p y="-1.3345099466018766"/
<p y="-1.3647596775866264"/
<p y="-1.3949555301961467"/
<p y="-1.4250963123498803"/
<p y="-1.455180834141359"/
<p y="-1.485207907885175"/
<p y="-1.5151763481638691"/
<p y="-1.5450849718747368"/
<p y="-1.5749325982765239"/
<p y="-1.6047180490360466"/
<p y="-1.6344401482747117"/
<p y="-1.6640977226149327"/
<p y="-1.6936896012264568"/
<p y="-1.7232146158725854"/
<p y="-1.7526716009562953"/
<p y="-1.7820593935662532"/
<p y="-1.8113768335227283"/
<p y="-1.8406227634233898"/
<p y="-1.8697960286890014"/
<p y="-1.898895477609005"/
<p y="-1.9279199613869824"/
<p y="-1.956868334186011"/
<p y="-1.9857394531739034"/
<p y="-2.014532178568314"/
<p y="-2.043245373681745"/
<p y="-2.0718779049664207"/
<p y="-2.1004286420590317"/
<p y="-2.1288964578253635"/
<p y="-2.157280228404794"/
<p y="-2.1855788332546635"/
<p y="-2.213791155194507"/
<p y="-2.2419160804501606"/
<p y="-2.2699524986977337"/
<p y="-2.297899303107439"/
<p y="-2.325755390387292"/
<p y="-2.3535196608266613"/
<p y="-2.3811910183396963"/
<p y="-2.408768370508575"/
<p y="-2.4362506286266608"/
<p y="-2.4636367077414594"/
<p y="-2.4909255266974535"/
<p y="-2.518116008178804"/
<p y="-2.5452070787518566"/
<p y="-2.5721976689075325"/
<p y="-2.599086713103546"/
<p y="-2.625873149806479"/
<p y="-2.6525559215336694"/
<p y="-2.6791339748949823"/
<p y="-2.705606260634379"/
<p y="-2.731971733671345"/
<p y="-2.758229353142151"/
<p y="-2.7843780824409405"/
<p y="-2.8104168892606536"/
<p y="-2.8363447456337814"/
<p y="-2.862160627972955"/
<p y="-2.887863517111337"/
<p y="-2.9134523983428795"/
<p y="-2.938926261462365"/
<p y="-2.9642841008052963"/
<p y="-2.9895249152875927"/
<p y="-3.014647708445124"/
<p y="-3.0396514884730275"/
<p y="-3.064535268264881"/
<p y="-3.089298065451673"/
<p y="-3.1139389024405615"/
<p y="-3.138456806453502"/
<p y="-3.1628508095656223"/
<p y="-3.1871199487434487"/
<p y="-3.2112632658829203"/
<p y="-3.2352798078472222"/
<p y="-3.2591686265043944"/
<p y="-3.2829287787647816"/
<p y="-3.3065593266182605"/
<p y="-3.330059337171258"/
<p y="-3.3534278826836"/
<p y="-3.376664040605122"/
<p y="-3.399766893612096"/
<p y="-3.422735529643442"/
<p y="-3.445569041936743"/
<p y="-3.468266529064024"/
<p y="-3.4908270949673623"/
<p y="-3.513249848994247"/
<p y="-3.5355339059327373"/
<p y="-3.557678386046427"/
<p y="-3.579682415109156"/
<p y="-3.601545124439535"/
<p y="-3.6232656509352323"/
<p y="-3.6448431371070584"/
<p y="-3.666276731112799"/
<p y="-3.687565586790869"/
<p y="-3.708708863693696"/
<p y="-3.7297057271209106"/
<p y="-3.7505553481522975"/
<p y="-3.7712569036805195"/
<p y="-3.79180957644361"/
<p y="-3.812212555057238"/
<p y="-3.83246503404675"/
<p y="-3.8525662138789456"/
<p y="-3.8725153009936686"/
<p y="-3.8923115078351165"/
<p y="-3.9119540528829404"/
<p y="-3.9314421606830936"/
<p y="-3.950775061878452"/
<p y="-3.969951993239177"/
<p y="-3.9889721976928545"/
<p y="-4.007834924354384"/
<p y="-4.026539428555609"/
<p y="-4.045084971874736"/
<p y="-4.06347082216547"/
<p y="-4.081696253585919"/
<p y="-4.099760546627261"/
<p y="-4.117662988142137"/
<p y="-4.135402871372809"/
<p y="-4.1529794959790625"/
<p y="-4.170392168065857"/
<p y="-4.1876402002107085"/
<p y="-4.204722911490845"/
<p y="-4.221639627510076"/
<p y="-4.238389680425416"/
<p y="-4.254972408973458"/
<p y="-4.271387158496476"/
<p y="-4.287633280968261"/
<p y="-4.303710135019718"/
<p y="-4.319617085964177"/
<p y="-4.33535350582245"/
<p y="-4.350918773347629"/
<p y="-4.3663122740496005"/
<p y="-4.381533400219318"/
<p y="-4.396581550952781"/
<p y="-4.4114561321747665"/
<p y="-4.426156556662276"/
<p y="-4.440682244067722"/
<p y="-4.455032620941839"/
<p y="-4.469207120756319"/
<p y="-4.483205183926179"/
<p y="-4.497026257831855"/
<p y="-4.5106697968410145"/
<p y="-4.5241352623300966"/
<p y="-4.537422122705585"/
<p y="-4.550529853424978"/
<p y="-4.563457937017514"/
<p y="-4.576205863104588"/
<p y="-4.588773128419906"/
<p y="-4.601159236829351"/
<p y="-4.613363699350574"/
<p y="-4.6253860341722906"/
<p y="-4.637225766673306"/
<p y="-4.648882429441257"/
<p y="-4.660355562291055"/
<p y="-4.67164471228306"/
<p y="-4.682749433740962"/
<p y="-4.69366928826937"/
<p y="-4.704403844771127"/
<p y="-4.714952679464322"/
<p y="-4.725315375899023"/
<p y="-4.735491524973721"/
<p y="-4.745480724951474"/
<p y="-4.755282581475767"/
<p y="-4.764896707586094"/
<p y="-4.774322723733214"/
<p y="-4.783560257794153"/
<p y="-4.792608945086879"/
<p y="-4.801468428384715"/
<p y="-4.810138357930429"/
<p y="-4.818618391450048"/
<p y="-4.82690819416637"/
<p y="-4.835007438812175"/
<p y="-4.842915805643155"/
<p y="-4.850632982450529"/
<p y="-4.85815866457337"/
<p y="-4.865492554910633"/
<p y="-4.872634363932886"/
<p y="-4.879583809693736"/
<p y="-4.886340617840967"/
<p y="-4.892904521627361"/
<p y="-4.899275261921234"/
<p y="-4.90545258721667"/
<p y="-4.911436253643443"/
<p y="-4.917226024976649"/
<p y="-4.922821672646027"/
<p y="-4.9282229757449905"/
<p y="-4.9334297210393405"/
<p y="-4.938441702975688"/
<p y="-4.94325872368957"/
<p y="-4.947880593013255"/
<p y="-4.952307128483256"/
<p y="-4.956538155347533"/
<p y="-4.960573506572389"/
<p y="-4.964413022849068"/
<p y="-4.968056552600042"/
<p y="-4.971503951984994"/
<p y="-4.9747550849065005"/
<p y="-4.9778098230154"/
<p y="-4.980668045715863"/
<p y="-4.983329640170149"/
<p y="-4.98579450130307"/
<p y="-4.9880625318061265"/
<p y="-4.990133642141358"/
<p y="-4.992007750544875"/
<p y="-4.993684783030087"/
<p y="-4.995164673390623"/
<p y="-4.996447363202946"/
<p y="-4.997532801828658"/
<p y="-4.9984209464165"/
<p y="-4.999111761904045"/
<p y="-4.99960522101908"/
<p y="-4.9999013042806855"/
<p y="-5.0"/
<p y="-4.9999013042806855"/
<p y="-4.99960522101908"/
<p y="-4.999111761904045"/
<p y="-4.9984209464165"/
<p y="-4.997532801828658"/
<p y="-4.996447363202946"/
<p y="-4.995164673390623"/
<p y="-4.993684783030087"/
<p y="-4.992007750544875"/
<p y="-4.990133642141358"/
<p y="-4.9880625318061265"/
<p y="-4.98579450130307"/
<p y="-4.983329640170149"/
<p y="-4.980668045715863"/
<p y="-4.9778098230154"/
<p y="-4.9747550849065005"/
<p y="-4.971503951984994"/
<p y="-4.968056552600042"/
<p y="-4.964413022849069"/
<p y="-4.9605735065723895"/
<p y="-4.956538155347533"/
<p y="-4.952307128483256"/
<p y="-4.947880593013255"/
<p y="-4.94325872368957"/
<p y="-4.938441702975689"/
<p y="-4.9334297210393405"/
<p y="-4.9282229757449905"/
<p y="-4.922821672646027"/
<p y="-4.917226024976649"/
<p y="-4.911436253643443"/
<p y="-4.90545258721667"/
<p y="-4.899275261921234"/
<p y="-4.892904521627361"/
<p y="-4.886340617840967"/
<p y="-4.879583809693737"/
<p y="-4.872634363932885"/
<p y="-4.865492554910633"/
<p y="-4.85815866457337"/
<p y="-4.850632982450529"/
<p y="-4.842915805643156"/
<p y="-4.835007438812175"/
<p y="-4.82690819416637"/
<p y="-4.818618391450048"/
<p y="-4.8101383579304295"/
<p y="-4.801468428384715"/
<p y="-4.792608945086879"/
<p y="-4.783560257794153"/
<p y="-4.774322723733214"/
<p y="-4.764896707586094"/
<p y="-4.755282581475768"/
<p y="-4.745480724951473"/
<p y="-4.735491524973722"/
<p y="-4.725315375899025"/
<p y="-4.714952679464322"/
<p y="-4.704403844771127"/
<p y="-4.693669288269371"/
<p y="-4.682749433740962"/
<p y="-4.671644712283061"/
<p y="-4.6603555622910555"/
<p y="-4.648882429441257"/
<p y="-4.637225766673306"/
<p y="-4.6253860341722906"/
<p y="-4.6133636993505736"/
<p y="-4.601159236829353"/
<p y="-4.5887731284199065"/
<p y="-4.576205863104587"/
<p y="-4.563457937017514"/
<p y="-4.550529853424978"/
<p y="-4.537422122705585"/
<p y="-4.524135262330097"/
<p y="-4.5106697968410145"/
<p y="-4.4970262578318545"/
<p y="-4.48320518392618"/
<p y="-4.4692071207563195"/
<p y="-4.455032620941839"/
<p y="-4.440682244067723"/
<p y="-4.426156556662276"/
<p y="-4.4114561321747665"/
<p y="-4.3965815509527815"/
<p y="-4.381533400219318"/
<p y="-4.3663122740496005"/
<p y="-4.350918773347629"/
<p y="-4.335353505822451"/
<p y="-4.319617085964177"/
<p y="-4.303710135019719"/
<p y="-4.2876332809682625"/
<p y="-4.271387158496475"/
<p y="-4.254972408973459"/
<p y="-4.238389680425417"/
<p y="-4.221639627510075"/
<p y="-4.204722911490846"/
<p y="-4.1876402002107085"/
<p y="-4.170392168065856"/
<p y="-4.152979495979063"/
<p y="-4.13540287137281"/
<p y="-4.117662988142136"/
<p y="-4.099760546627262"/
<p y="-4.08169625358592"/
<p y="-4.063470822165469"/
<p y="-4.045084971874737"/
<p y="-4.02653942855561"/
<p y="-4.007834924354383"/
<p y="-3.988972197692855"/
<p y="-3.969951993239178"/
<p y="-3.9507750618784514"/
<p y="-3.931442160683095"/
<p y="-3.9119540528829413"/
<p y="-3.892311507835118"/
<p y="-3.87251530099367"/
<p y="-3.852566213878946"/
<p y="-3.8324650340467494"/
<p y="-3.8122125550572394"/
<p y="-3.7918095764436104"/
<p y="-3.771256903680519"/
<p y="-3.7505553481522984"/
<p y="-3.729705727120911"/
<p y="-3.7087088636936967"/
<p y="-3.6875655867908694"/
<p y="-3.6662767311128004"/
<p y="-3.644843137107058"/
<p y="-3.623265650935233"/
<p y="-3.6015451244395353"/
<p y="-3.5796824151091555"/
<p y="-3.557678386046428"/
<p y="-3.5355339059327386"/
<p y="-3.5132498489942465"/
<p y="-3.4908270949673637"/
<p y="-3.468266529064026"/
<p y="-3.4455690419367424"/
<p y="-3.422735529643443"/
<p y="-3.3997668936120973"/
<p y="-3.3766640406051214"/
<p y="-3.353427882683601"/
<p y="-3.3300593371712583"/
<p y="-3.3065593266182596"/
<p y="-3.282928778764782"/
<p y="-3.259168626504395"/
<p y="-3.2352798078472214"/
<p y="-3.2112632658829234"/
<p y="-3.1871199487434474"/
<p y="-3.162850809565623"/
<p y="-3.1384568064535046"/
<p y="-3.113938902440563"/
<p y="-3.0892980654516737"/
<p y="-3.0645352682648825"/
<p y="-3.0396514884730284"/
<p y="-3.014647708445123"/
<p y="-2.9895249152875953"/
<p y="-2.964284100805295"/
<p y="-2.9389262614623664"/
<p y="-2.9134523983428826"/
<p y="-2.887863517111338"/
<p y="-2.862160627972953"/
<p y="-2.836344745633782"/
<p y="-2.8104168892606545"/
<p y="-2.784378082440943"/
<p y="-2.758229353142152"/
<p y="-2.7319717336713447"/
<p y="-2.7056062606343794"/
<p y="-2.6791339748949854"/
<p y="-2.6525559215336703"/
<p y="-2.6258731498064805"/
<p y="-2.599086713103551"/
<p y="-2.57219766890753"/
<p y="-2.5452070787518553"/
<p y="-2.518116008178805"/
<p y="-2.4909255266974566"/
<p y="-2.4636367077414585"/
<p y="-2.4362506286266634"/
<p y="-2.4087683705085765"/
<p y="-2.381191018339697"/
<p y="-2.353519660826662"/
<p y="-2.325755390387293"/
<p y="-2.297899303107442"/
<p y="-2.2699524986977346"/
<p y="-2.2419160804501597"/
<p y="-2.213791155194508"/
<p y="-2.1855788332546666"/
<p y="-2.1572802284047947"/
<p y="-2.128896457825365"/
<p y="-2.1004286420590343"/
<p y="-2.071877904966422"/
<p y="-2.043245373681744"/
<p y="-2.014532178568314"/
<p y="-1.9857394531739057"/
<p y="-1.9568683341860122"/
<p y="-1.9279199613869846"/
<p y="-1.8988954776090052"/
<p y="-1.8697960286890036"/
<p y="-1.8406227634233892"/
<p y="-1.8113768335227292"/
<p y="-1.7820593935662563"/
<p y="-1.7526716009562995"/
<p y="-1.7232146158725834"/
<p y="-1.6936896012264568"/
<p y="-1.664097722614935"/
<p y="-1.6344401482747117"/
<p y="-1.6047180490360489"/
<p y="-1.5749325982765272"/
<p y="-1.5450849718747377"/
<p y="-1.5151763481638683"/
<p y="-1.485207907885175"/
<p y="-1.4551808341413612"/
<p y="-1.4250963123498848"/
<p y="-1.394955530196148"/
<p y="-1.3647596775866255"/
<p y="-1.3345099466018788"/
<p y="-1.3042075314494834"/
<p y="-1.2738536284169117"/
<p y="-1.2434494358242765"/
<p y="-1.2129961539770415"/
<p y="-1.182494985118621"/
<p y="-1.1519471333829525"/
<p y="-1.1213538047469076"/
<p y="-1.0907162069827119"/
<p y="-1.0600355496102742"/
<p y="-1.0293130438494096"/
<p y="-0.9985499025720356"/
<p y="-0.9677473402542993"/
<p y="-0.9369065729286231"/
<p y="-0.9060288181356888"/
<p y="-0.8751152948763841"/
<p y="-0.8441672235636708"/
<p y="-0.8131858259744169"/
<p y="-0.7821723252011552"/
<p y="-0.7511279456037836"/
<p y="-0.7200539127612613"/
<p y="-0.6889514534231926"/
<p y="-0.6578217954614167"/
<p y="-0.6266661678215186"/
<p y="-0.595485800474348"/
<p y="-0.5642819243674096"/
<p y="-0.5330557713763028"/
<p y="-0.5018085742560752"/
<p y="-0.4705415665925743"/
<p y="-0.439255982753716"/
<p y="-0.4079530578407855"/
<p y="-0.37663402763966325"/
<p y="-0.34530012857203063"/
<p y="-0.31395259764657046"/
<p y="-0.2825926724101237"/
<p y="-0.2512215908988464"/
<p y="-0.21984059158932506"/
<p y="-0.1884509133496752"/
<p y="-0.1570537953906415"/
<p y="-0.12565047721668937"/
<p y="-0.09424219857704481"/
<p y="-0.06283019941676005"/
<p y="-0.03141571982779372"/
<p y="-9.184850993605148E-16"/
<p y="0.031415719827791885"/
<p y="0.06283019941676266"/
<p y="0.09424219857703853"/
<p y="0.12565047721668754"/
<p y="0.15705379539063966"/
<p y="0.18845091334967337"/
<p y="0.21984059158932323"/
<p y="0.25122159089884455"/
<p y="0.28259267241012187"/
<p y="0.3139525976465686"/
<p y="0.34530012857202874"/
<p y="0.3766340276396615"/
<p y="0.40795305784078806"/
<p y="0.43925598275371425"/
<p y="0.470541566592568"/
<p y="0.5018085742560734"/
<p y="0.5330557713763009"/
<p y="0.5642819243674079"/
<p y="0.5954858004743462"/
<p y="0.6266661678215212"/
<p y="0.6578217954614106"/
<p y="0.6889514534231909"/
<p y="0.7200539127612593"/
<p y="0.7511279456037863"/
<p y="0.7821723252011534"/
<p y="0.8131858259744151"/
<p y="0.8441672235636646"/
<p y="0.8751152948763823"/
<p y="0.9060288181356869"/
<p y="0.9369065729286213"/
<p y="0.967747340254302"/
<p y="0.9985499025720337"/
<p y="1.0293130438494034"/
<p y="1.0600355496102725"/
<p y="1.0907162069827145"/
<p y="1.1213538047469056"/
<p y="1.1519471333829507"/
<p y="1.1824949851186193"/
<p y="1.2129961539770355"/
<p y="1.2434494358242747"/
<p y="1.2738536284169097"/
<p y="1.3042075314494859"/
<p y="1.3345099466018773"/
<p y="1.3647596775866235"/
<p y="1.394955530196142"/
<p y="1.425096312349883"/
<p y="1.4551808341413597"/
<p y="1.4852079078851732"/
<p y="1.5151763481638667"/
<p y="1.5450849718747361"/
<p y="1.5749325982765212"/
<p y="1.604718049036047"/
<p y="1.6344401482747142"/
<p y="1.6640977226149334"/
<p y="1.6936896012264553"/
<p y="1.7232146158725816"/
<p y="1.7526716009562937"/
<p y="1.7820593935662545"/
<p y="1.8113768335227276"/
<p y="1.8406227634233872"/
<p y="1.8697960286890019"/
<p y="1.8988954776090035"/
<p y="1.9279199613869789"/
<p y="1.9568683341860147"/
<p y="1.9857394531739037"/
<p y="2.014532178568312"/
<p y="2.043245373681742"/
<p y="2.07187790496642"/
<p y="2.100428642059029"/
<p y="2.128896457825363"/
<p y="2.157280228404793"/
<p y="2.185578833254665"/
<p y="2.213791155194506"/
<p y="2.2419160804501583"/
<p y="2.2699524986977333"/
<p y="2.2978993031074406"/
<p y="2.3257553903872914"/
<p y="2.3535196608266604"/
<p y="2.3811910183396954"/
<p y="2.4087683705085747"/
<p y="2.4362506286266585"/
<p y="2.4636367077414607"/
<p y="2.4909255266974553"/
<p y="2.5181160081788034"/
<p y="2.5452070787518544"/
<p y="2.572197668907532"/
<p y="2.5990867131035458"/
<p y="2.6258731498064787"/
<p y="2.6525559215336685"/
<p y="2.6791339748949836"/
<p y="2.7056062606343785"/
<p y="2.731971733671343"/
<p y="2.758229353142151"/
<p y="2.7843780824409414"/
<p y="2.8104168892606527"/
<p y="2.836344745633781"/
<p y="2.862160627972955"/
<p y="2.8878635171113363"/
<p y="2.9134523983428773"/
<p y="2.9389262614623646"/
<p y="2.964284100805297"/
<p y="2.989524915287594"/
<p y="3.0146477084451218"/
<p y="3.039651488473027"/
<p y="3.0645352682648808"/
<p y="3.089298065451672"/
<p y="3.113938902440561"/
<p y="3.1384568064535037"/
<p y="3.1628508095656214"/
<p y="3.1871199487434465"/
<p y="3.211263265882918"/
<p y="3.235279807847223"/
<p y="3.259168626504394"/
<p y="3.2829287787647807"/
<p y="3.3065593266182596"/
<p y="3.3300593371712575"/
<p y="3.3534278826835977"/
<p y="3.376664040605122"/
<p y="3.3997668936120973"/
<p y="3.422735529643443"/
<p y="3.4455690419367406"/
<p y="3.4682665290640218"/
<p y="3.490827094967362"/
<p y="3.5132498489942465"/
<p y="3.535533905932737"/
<p y="3.557678386046428"/
<p y="3.5796824151091555"/
<p y="3.601545124439533"/
<p y="3.62326565093523"/
<p y="3.6448431371070593"/
<p y="3.666276731112801"/
<p y="3.6875655867908685"/
<p y="3.708708863693694"/
<p y="3.72970572712091"/
<p y="3.7505553481522957"/
<p y="3.771256903680519"/
<p y="3.7918095764436104"/
<p y="3.8122125550572394"/
<p y="3.832465034046748"/
<p y="3.8525662138789443"/
<p y="3.872515300993668"/
<p y="3.892311507835118"/
<p y="3.91195405288294"/
<p y="3.931442160683093"/
<p y="3.9507750618784514"/
<p y="3.9699519932391754"/
<p y="3.9889721976928527"/
<p y="4.007834924354385"/
<p y="4.02653942855561"/
<p y="4.045084971874736"/
<p y="4.063470822165468"/
<p y="4.081696253585919"/
<p y="4.099760546627261"/
<p y="4.117662988142137"/
<p y="4.135402871372808"/
<p y="4.152979495979063"/
<p y="4.170392168065855"/
<p y="4.187640200210707"/
<p y="4.204722911490845"/
<p y="4.221639627510076"/
<p y="4.238389680425416"/
<p y="4.254972408973458"/
<p y="4.271387158496475"/
<p y="4.287633280968261"/
<p y="4.303710135019717"/
<p y="4.319617085964175"/
<p y="4.335353505822451"/
<p y="4.350918773347628"/
<p y="4.3663122740496"/
<p y="4.381533400219318"/
<p y="4.39658155095278"/
<p y="4.4114561321747665"/
<p y="4.426156556662275"/
<p y="4.440682244067723"/
<p y="4.455032620941839"/
<p y="4.469207120756318"/
<p y="4.483205183926177"/
<p y="4.497026257831856"/
<p y="4.5106697968410145"/
<p y="4.5241352623300966"/
<p y="4.537422122705585"/
<p y="4.550529853424978"/
<p y="4.563457937017513"/
<p y="4.576205863104588"/
<p y="4.5887731284199065"/
<p y="4.601159236829352"/
<p y="4.6133636993505736"/
<p y="4.625386034172289"/
<p y="4.637225766673306"/
<p y="4.648882429441257"/
<p y="4.660355562291054"/
<p y="4.671644712283061"/
<p y="4.682749433740962"/
<p y="4.693669288269369"/
<p y="4.704403844771125"/
<p y="4.714952679464323"/
<p y="4.725315375899024"/
<p y="4.735491524973721"/
<p y="4.745480724951472"/
<p y="4.755282581475767"/
<p y="4.764896707586093"/
<p y="4.774322723733214"/
<p y="4.783560257794153"/
<p y="4.792608945086879"/
<p y="4.801468428384715"/
<p y="4.810138357930429"/
<p y="4.818618391450048"/
<p y="4.82690819416637"/
<p y="4.835007438812175"/
<p y="4.8429158056431545"/
<p y="4.850632982450529"/
<p y="4.858158664573369"/
<p y="4.865492554910632"/
<p y="4.872634363932886"/
<p y="4.879583809693737"/
<p y="4.8863406178409665"/
<p y="4.89290452162736"/
<p y="4.899275261921234"/
<p y="4.90545258721667"/
<p y="4.911436253643443"/
<p y="4.917226024976649"/
<p y="4.922821672646027"/
<p y="4.92822297574499"/
<p y="4.93342972103934"/
<p y="4.938441702975688"/
<p y="4.943258723689571"/
<p y="4.947880593013255"/
<p y="4.952307128483256"/
<p y="4.956538155347533"/
<p y="4.960573506572389"/
<p y="4.964413022849068"/
<p y="4.968056552600043"/
<p y="4.971503951984994"/
<p y="4.9747550849065005"/
<p y="4.9778098230154"/
<p y="4.980668045715863"/
<p y="4.983329640170149"/
<p y="4.98579450130307"/
<p y="4.9880625318061265"/
<p y="4.990133642141358"/
<p y="4.992007750544875"/
<p y="4.993684783030087"/
<p y="4.995164673390623"/
<p y="4.996447363202946"/
<p y="4.997532801828658"/
<p y="4.9984209464165"/
<p y="4.999111761904045"/
<p y="4.99960522101908"/
<p y="4.9999013042806855"/
<p y="5.0"/
</dataset>
<dataset>
<p y="-1.9877108038047462"/
<p y="3.191865850778699"/
<p y="2.799791445902315"/
<p y="-1.7469519184077518"/
<p y="-3.3564648168133706"/
<p y="4.105138159337988"/
<p y="1.0798329202382204"/
<p y="4.545616467580375"/
<p y="2.0174816683744226"/
<p y="-2.792587724111036"/
<p y="-0.7248226953619765"/
<p y="2.3052444524295836"/
<p y="0.5577286294041519"/
<p y="-3.9052949439215636"/
<p y="-0.5073516130268487"/
<p y="0.9951211312448782"/
<p y="-1.7055936103498128"/
<p y="2.1915398933267767"/
<p y="-1.0671464295975386"/
<p y="1.1428941380876498"/
<p y="2.8693770666515643"/
<p y="-4.802048084424052"/
<p y="-3.9288243276259784"/
<p y="-1.5157144211670017"/
<p y="3.2839513431659118"/
<p y="4.655173619690581"/
<p y="-1.6608979964030723"/
<p y="-2.428347723387426"/
<p y="-0.025524409563873363"/
<p y="0.6574034315146058"/
<p y="0.7983395036994256"/
<p y="-0.22377957915744506"/
<p y="-4.043367415733727"/
<p y="3.057137870396037"/
<p y="-2.6697704480725113"/
<p y="3.939932913722801"/
<p y="-0.2191290607081875"/
<p y="2.9492981034023558"/
<p y="-2.1966319335297877"/
<p y="-2.93650649896846"/
<p y="-0.3706067006790317"/
<p y="1.4543886866809288"/
<p y="3.0107473418558293"/
<p y="-1.3409728739895685"/
<p y="1.9139076793287524"/
<p y="3.2281685743671282"/
<p y="-3.238670352948999"/
<p y="-0.49199597366235537"/
<p y="4.578763542663653"/
<p y="-4.248917612190749"/
<p y="-3.756924941018908"/
<p y="4.408974361227617"/
<p y="-4.056371851743769"/
<p y="-0.2740215258305492"/
<p y="-0.8766760209460012"/
<p y="-0.7246057679140874"/
<p y="0.06389045375905766"/
<p y="-3.488416065865313"/
<p y="-1.9350361288060416"/
<p y="-4.296042312661648"/
<p y="-3.8301877001392004"/
<p y="0.877514867680377"/
<p y="-3.656521888451717"/
<p y="4.649544858971964"/
<p y="2.2394683199243577"/
<p y="-0.666396015187698"/
<p y="2.0249969956987135"/
<p y="-3.0930816663909724"/
<p y="4.0237538513973465"/
<p y="-4.41747222052422"/
<p y="2.114006801770798"/
<p y="-2.3368952953208555"/
<p y="-3.006910280810484"/
<p y="-3.6942967146854713"/
<p y="-1.7040865966470218"/
<p y="-3.6145019648505494"/
<p y="-3.7745053574194865"/
<p y="-4.328860354694772"/
<p y="-4.247747492662654"/
<p y="-4.407970874321365"/
<p y="3.1456476727175975"/
<p y="-2.688041984039986"/
<p y="-4.188541250509241"/
<p y="-4.28743504595117"/
<p y="2.6064467050098408"/
<p y="0.6834228960040223"/
<p y="-4.877249040091897"/
<p y="-0.6240761839851805"/
<p y="4.624778358906884"/
<p y="1.3410783413292187"/
<p y="4.137346298271257"/
<p y="-0.40239171576821686"/
<p y="-0.2616379208265549"/
<p y="4.1644422668942305"/
<p y="-2.703593635465719"/
<p y="3.8430615249201985"/
<p y="3.8584787496830213"/
<p y="-4.643569667435408"/
<p y="-1.2929762902026165"/
<p y="4.337748033051671"/
<p y="-3.8465970425973506"/
<p y="1.0941209630697681"/
<p y="-1.6460168763876815"/
<p y="1.1268738404236451"/
<p y="3.723832077087101"/
<p y="-2.4506422258543727"/
<p y="3.5018343064398945"/
<p y="1.8541353572559451"/
<p y="2.740781305548982"/
<p y="2.0309227250197015"/
<p y="2.6869915249928322"/
<p y="-2.3331860996625498"/
<p y="-1.9931214773684305"/
<p y="0.4811315514067358"/
<p y="-2.9552134698111123"/
<p y="4.940199813375086"/
<p y="-1.9948196125963937"/
<p y="-0.4101424313200477"/
<p y="4.965571102118215"/
<p y="2.847089872000841"/
<p y="1.3562431661231535"/
<p y="4.915448725112787"/
<p y="1.9218822502732635"/
<p y="4.540190797861044"/
<p y="-0.892651275460743"/
<p y="2.0228284813132555"/
<p y="-0.5952986363499404"/
<p y="-0.868539978128938"/
<p y="-3.919881705698103"/
<p y="1.6366818829337806"/
<p y="-4.889331973404798"/
<p y="0.7321995262219811"/
<p y="-1.5808490955433498"/
<p y="4.536877931325753"/
<p y="2.2559901717113027"/
<p y="0.606257592314603"/
<p y="2.862000524468085"/
<p y="2.799051896541508"/
<p y="-3.085768841362968"/
<p y="1.6933825979376262"/
<p y="1.84456963245667"/
<p y="3.2374648769847454"/
<p y="-2.9729503497680385"/
<p y="2.0580691264405964"/
<p y="4.238516096760613"/
<p y="-1.6200872018125798"/
<p y="0.20443070960282395"/
<p y="0.823024572637296"/
<p y="0.9951643027914443"/
<p y="4.760659614906851"/
<p y="4.369836192646666"/
<p y="-4.02459380571959"/
<p y="-4.441394636628467"/
<p y="3.5288897399060204"/
<p y="1.42339268736296"/
<p y="-0.07187763031131755"/
<p y="4.542895192537619"/
<p y="4.798528951786039"/
<p y="4.782296399711109"/
<p y="2.7096965087831233"/
<p y="-2.837426857378753"/
<p y="-3.8379517446163414"/
<p y="3.2233246577408146"/
<p y="2.9104566310200433"/
<p y="0.32765477575022217"/
<p y="-4.708882253604589"/
<p y="-0.34595269937397166"/
<p y="4.462144575034671"/
<p y="-0.7450692615200065"/
<p y="0.32248679096679034"/
<p y="2.57326504810783"/
<p y="-4.830693402515415"/
<p y="-1.8236249690796025"/
<p y="-3.503235862346453"/
<p y="0.7765825867598064"/
<p y="-4.547637580026471"/
<p y="-4.226501435728672"/
<p y="2.450207674204771"/
<p y="-3.90694075824378"/
<p y="-4.799262606506851"/
<p y="2.483663524328792"/
<p y="1.7361650365246897"/
<p y="0.6312480968931586"/
<p y="-0.048319029963837856"/
<p y="2.8297613746108885"/
<p y="3.8644247969517096"/
<p y="0.0228668107953256"/
<p y="1.8001897987973798"/
<p y="1.242508724811886"/
<p y="3.4043108982409542"/
<p y="-2.219553981532041"/
<p y="-4.061983041342744"/
<p y="3.5952727176117225"/
<p y="4.0905003264820525"/
<p y="3.4051358979489734"/
<p y="2.1991033800861164"/
<p y="-2.590148249784965"/
<p y="3.2137588379236366"/
<p y="2.3522441624699812"/
<p y="0.8467332306509388"/
<p y="-4.395671576780225"/
<p y="-1.4507379834331546"/
<p y="-0.4854183130066483"/
<p y="1.1624118646204078"/
<p y="2.9592107838242674"/
<p y="0.22038444591411377"/
<p y="4.307519897615634"/
<p y="-0.727877375065761"/
<p y="4.862918630623286"/
<p y="-4.311061668789456"/
<p y="2.444713748993008"/
<p y="-4.895141584386165"/
<p y="-3.2146346112341737"/
<p y="-3.983183744542255"/
<p y="0.9156056936240686"/
<p y="4.129954853072293"/
<p y="3.271613943238508"/
<p y="0.5335913955812712"/
<p y="2.778428188215295"/
<p y="4.766449154450301"/
<p y="3.192664345272222"/
<p y="1.8429034444262715"/
<p y="4.4312955302162464"/
<p y="3.785880581357219"/
<p y="-3.8499372781760446"/
<p y="-4.136590704902304"/
<p y="4.540858692336991"/
<p y="-1.1614099983522639"/
<p y="-1.7697312444047633"/
<p y="-2.0955442603340115"/
<p y="0.5604942867085763"/
<p y="-3.1971024038554385"/
<p y="-0.03662585382695838"/
<p y="-0.2778645831002704"/
<p y="0.6743484181231878"/
<p y="1.8364113933020363"/
<p y="0.8294061239662369"/
<p y="-3.2019258786087654"/
<p y="0.746082001133189"/
<p y="3.76878152494157"/
<p y="2.953422801053435"/
<p y="-2.3819441937731787"/
<p y="3.216836984778947"/
<p y="-4.307182500797482"/
<p y="3.219753733655743"/
<p y="4.649412816792523"/
<p y="-0.20746813760199778"/
<p y="2.7725742552593067"/
<p y="4.170516881092043"/
<p y="-2.479608317218106"/
<p y="-1.2177791597234302"/
<p y="-2.4786315977761375"/
<p y="2.710798875498547"/
<p y="-1.3912477870721949"/
<p y="2.564676289063569"/
<p y="-0.26937496653863224"/
<p y="4.5725019300976975"/
<p y="0.5858345099876408"/
<p y="0.8927454266988235"/
<p y="0.5902168799448129"/
<p y="1.1729424317862769"/
<p y="-2.6887976817018613"/
<p y="0.9930476510137032"/
<p y="-1.3419072478323257"/
<p y="3.642195737388027"/
<p y="-2.047503478499808"/
<p y="-2.5792464737536402"/
<p y="-2.8221035422493945"/
<p y="-2.061060752342716"/
<p y="3.8723285317926663"/
<p y="-2.5120259399035993"/
<p y="4.126238356572085"/
<p y="-4.826997998588938"/
<p y="4.908131985905493"/
<p y="-2.884666969583647"/
<p y="4.466098455837525"/
<p y="-0.5823502896420072"/
<p y="-3.835597998768727"/
<p y="-4.174066004564701"/
<p y="1.7611689542064486"/
<p y="3.8525071932978996"/
<p y="3.063604160150014"/
<p y="3.6856382718941667"/
<p y="1.8740750641233213"/
<p y="4.708911346947019"/
<p y="1.5015547001033518"/
<p y="-4.62193379108567"/
<p y="4.5457383759389"/
<p y="-0.23970670834381558"/
<p y="-1.4833704810674462"/
<p y="-4.388223040241509"/
<p y="3.2840498461731187"/
<p y="-0.8084548717619526"/
<p y="2.0956519031191583"/
<p y="0.14445230579610868"/
<p y="0.9586673638717631"/
<p y="-4.266616985207516"/
<p y="4.936058421989001"/
<p y="0.9517860833311529"/
<p y="3.314053196822446"/
<p y="2.269778640737351"/
<p y="3.8583466588344297"/
<p y="-0.9890272982105479"/
<p y="3.876701339784173"/
<p y="-2.415012015873781"/
<p y="-0.7321441913412166"/
<p y="0.5050504838368486"/
<p y="-2.2207279214065165"/
<p y="4.3290778525750095"/
<p y="-0.5453714994574499"/
<p y="2.9331899886531074"/
<p y="3.9503775865024533"/
<p y="-2.9182360822012487"/
<p y="-2.06864651704993"/
<p y="3.0709707168950793"/
<p y="0.5972915587428576"/
<p y="-3.3258519095748715"/
<p y="1.6367730001538225"/
<p y="2.278904358012346"/
<p y="-4.775348224171697"/
<p y="-2.09670861918232"/
<p y="-4.536342587235671"/
<p y="-1.054647131088442"/
<p y="1.4150142671928831"/
<p y="-3.344872611022982"/
<p y="-2.080449996145457"/
<p y="-1.7345578010327611"/
<p y="1.779912913980625"/
<p y="4.477606364098396"/
<p y="1.5561581976293581"/
<p y="-3.429626918248181"/
<p y="3.221097856935751"/
<p y="-0.21468961206060833"/
<p y="3.228457956910045"/
<p y="1.838980788733724"/
<p y="-4.8339795396931615"/
<p y="-4.577899603231268"/
<p y="-3.9024279490784117"/
<p y="1.3681094212184188"/
<p y="3.941621146036743"/
<p y="4.808356687989903"/
<p y="-2.2085154387484653"/
<p y="0.07836069161893455"/
<p y="2.427364374070412"/
<p y="2.03644033731715"/
<p y="-2.342939794269676"/
<p y="0.3428562595170135"/
<p y="-0.35736181208594076"/
<p y="-2.300377312452395"/
<p y="4.004732849788706"/
<p y="-0.5227759079176408"/
<p y="3.076033441125409"/
<p y="4.822659421273363"/
<p y="-1.8909090304849787"/
<p y="3.4728506023333274"/
<p y="-1.83919423694884"/
<p y="0.1552627007042675"/
<p y="-3.530827693744362"/
<p y="-2.3656743582062543"/
<p y="3.8292636051602607"/
<p y="1.949699659251607"/
<p y="-4.786711423039577"/
<p y="0.17268857107394098"/
<p y="-1.8742338221699004"/
<p y="-1.1790823384155846"/
<p y="-3.4983064298132427"/
<p y="4.350807646746295"/
<p y="-2.3422221875748264"/
<p y="0.06653289722151357"/
<p y="4.0814654690653125"/
<p y="1.5344774220221646"/
<p y="-2.364743872877495"/
<p y="1.718507665334272"/
<p y="4.183302017004852"/
<p y="1.4948263835802544"/
<p y="2.8667808884133903"/
<p y="-0.8635139073035871"/
<p y="1.6575012111193992"/
<p y="0.7054853830039365"/
<p y="-3.0811127988327947"/
<p y="3.6360509538708303"/
<p y="0.06615060798461503"/
<p y="-2.0350395068251848"/
<p y="4.801010126981957"/
<p y="-4.218506668890335"/
<p y="-2.262496290858503"/
<p y="4.149693869830228"/
<p y="-3.3392406443296574"/
<p y="-3.9605282340866244"/
<p y="0.14946675946968924"/
<p y="2.3560764023256207"/
<p y="-0.5249210018595178"/
<p y="-3.066714010213346"/
<p y="1.3454214572386007"/
<p y="4.252945794780429"/
<p y="1.6473886379966682"/
<p y="2.9417463431162947"/
<p y="2.5217180612524395"/
<p y="-4.762299680333285"/
<p y="-3.7485744166945034"/
<p y="3.100252680126248"/
<p y="3.141058668789336"/
<p y="0.18293379361942996"/
<p y="-0.9867242156039246"/
<p y="-2.880198272695246"/
<p y="4.5431179403174475"/
<p y="4.500880193676149"/
<p y="-2.3715748078969465"/
<p y="-3.2114361552374158"/
<p y="4.812049549723611"/
<p y="-3.7569676455510335"/
<p y="-3.2745275642959726"/
<p y="0.6246579119055315"/
<p y="-3.868383602760911"/
<p y="1.0167848994077575"/
<p y="1.6812600889935325"/
<p y="-2.560024771354522"/
<p y="-0.40691637973381045"/
<p y="-4.85386915445957"/
<p y="-2.6810824507013997"/
<p y="3.431386029106246"/
<p y="4.702759261098873"/
<p y="-0.6354828866571314"/
<p y="3.774221142066976"/
<p y="-2.1783690386612173"/
<p y="-1.966350644950551"/
<p y="3.3992967753682244"/
<p y="1.572015579609543"/
<p y="2.7214505011673626"/
<p y="-1.0182741219592053"/
<p y="4.103070499942284"/
<p y="-2.7798791646986465"/
<p y="0.04611785947812841"/
<p y="0.9859368800879187"/
<p y="-2.526891696003398"/
<p y="4.8110672180572145"/
<p y="-3.7648466512466303"/
<p y="-0.9144060434369106"/
<p y="0.15648269167917483"/
<p y="4.374826296887692"/
<p y="2.1372766096472713"/
<p y="-1.3402249357571385"/
<p y="-4.927726836626105"/
<p y="4.676924807506646"/
<p y="3.854123378703923"/
<p y="-4.137151100728525"/
<p y="1.9509320165453463"/
<p y="2.478531751365667"/
<p y="4.480168700442844"/
<p y="-4.0239960026023756"/
<p y="-2.842567412064312"/
<p y="-3.98662815665166"/
<p y="3.234572990367827"/
<p y="3.516997692750385"/
<p y="-3.9235992202907433"/
<p y="4.810016993981419"/
<p y="1.665308619104323"/
<p y="1.3921645729049246"/
<p y="4.273272285031046"/
<p y="-4.440459160370523"/
<p y="-1.203093075405972"/
<p y="2.7605940259368005"/
<p y="-0.30169337598102075"/
<p y="-0.3704103515111328"/
<p y="-4.246172729463699"/
<p y="2.516653344651967"/
<p y="-3.130321865391611"/
<p y="-0.9169338705633798"/
<p y="9.717299190912243E-4"/
<p y="4.369031172111068"/
<p y="2.457003758250041"/
<p y="3.0754636894747946"/
<p y="4.74680884781433"/
<p y="-4.555958351222561"/
<p y="2.7899616021517106"/
<p y="3.6157062432379696"/
<p y="-4.80638893209977"/
<p y="3.28272970664033"/
<p y="4.622364571734954"/
<p y="-0.12905739046886033"/
<p y="2.649652097541"/
<p y="0.8494548166375706"/
<p y="3.010905421506177"/
<p y="-3.4861484324114644"/
<p y="-1.4210943543898615"/
<p y="1.5072527544866912"/
<p y="3.2027637837198046"/
<p y="1.4147894512689732"/
<p y="0.19675708069457531"/
<p y="-4.7449080955742104"/
<p y="-4.0016188122200225"/
<p y="-3.6973054324999985"/
<p y="2.9494320259904665"/
<p y="1.6717178462641886"/
<p y="-4.203304212171929"/
<p y="-4.1628678268082675"/
<p y="-0.30626188393304155"/
<p y="2.071276349583993"/
<p y="3.7456012523923015"/
<p y="-1.5940038098861455"/
<p y="1.9828352395593143"/
<p y="-3.5721850402803854"/
<p y="4.367432349824192"/
<p y="-2.552541391404236"/
<p y="0.45059520504069894"/
<p y="-0.1779108121670534"/
<p y="-0.14220845377955182"/
<p y="-3.8955792345511773"/
<p y="-2.6867699144920634"/
<p y="3.4145640667810397"/
<p y="-0.9739818411899792"/
<p y="-4.3161923258769495"/
<p y="2.5187303032026414"/
<p y="1.5448233287163857"/
<p y="-3.2373922085172313"/
<p y="-3.322319642362385"/
<p y="2.3001625209747756"/
<p y="3.480502254170334"/
<p y="1.312515038309673"/
<p y="-3.819193633158978"/
<p y="1.220223720247617"/
<p y="1.6630281045464166"/
<p y="1.9059487089468004"/
<p y="1.389662453561467"/
<p y="0.8434949523253197"/
<p y="2.414799413046599"/
<p y="-0.6506280131854183"/
<p y="2.0340612227266117"/
<p y="-1.839930495212423"/
<p y="-3.616695751740644"/
<p y="-0.3524586381668291"/
<p y="-1.2961209396238118"/
<p y="-3.085495716832971"/
<p y="-1.479490062386243"/
<p y="4.721197573838328"/
<p y="4.497851582859942"/
<p y="4.080212717167026"/
<p y="3.5932105628968127"/
<p y="-3.8626266423206723"/
<p y="1.3071823279584374"/
<p y="1.2899613199058582"/
<p y="-2.4213322184541264"/
<p y="-2.91337980982304"/
<p y="-1.7683668072751138"/
<p y="2.053668737922499"/
<p y="4.023240219583986"/
<p y="-0.13380707805932346"/
<p y="-0.030146117629746172"/
<p y="2.3489365467923466"/
<p y="-2.1844897597921173"/
<p y="0.2782551306599128"/
<p y="1.8055903664082962"/
<p y="-1.451427719864137"/
<p y="-1.3651345471512433"/
<p y="-2.989972489119971"/
<p y="0.4784338550200262"/
<p y="1.3355287987962647"/
<p y="-3.6935266589923357"/
<p y="-4.198913610865096"/
<p y="1.863544659169163"/
<p y="3.0027797717204407"/
<p y="-1.7600541314882543"/
<p y="0.8544473244639015"/
<p y="-4.754159690244655"/
<p y="-4.348836330028734"/
<p y="-1.4449218700604471"/
<p y="-2.4938638957948145"/
<p y="-2.3179615819117902"/
<p y="4.813021369281978"/
<p y="4.84318056345816"/
<p y="4.051042362112952"/
<p y="1.145933776063293"/
<p y="-2.743504433493552"/
<p y="-1.2189643648182944"/
<p y="2.0300204844038188"/
<p y="1.261367302405116"/
<p y="2.5657551539044885"/
<p y="4.099256860109099"/
<p y="2.8234084359135894"/
<p y="4.902785352321617"/
<p y="-0.10785965106462658"/
<p y="-1.1624705579280503"/
<p y="-2.694176166023902"/
<p y="-1.1444417291980158"/
<p y="-1.4985461592600502"/
<p y="4.327395351256795"/
<p y="3.2620238394252876"/
<p y="-4.4179047014956065"/
<p y="3.060005769132877"/
<p y="-3.8144403662761706"/
<p y="-0.5396369451578771"/
<p y="1.599575417479877"/
<p y="1.8996065473747255"/
<p y="4.230737105340076"/
<p y="2.647183000709825"/
<p y="3.877538939892043"/
<p y="1.0970639076472946"/
<p y="2.3898116158164644"/
<p y="3.0461642182559636"/
<p y="-4.377746511828626"/
<p y="-1.271582537632563"/
<p y="4.247163846978387"/
<p y="-3.7827365804600053"/
<p y="-2.689517986913902"/
<p y="1.8848281118595889"/
<p y="1.0309695665020593"/
<p y="2.6477547801730372"/
<p y="1.0369986448922566"/
<p y="-2.1235511911657614"/
<p y="-4.808164089357918"/
<p y="2.210697781028027"/
<p y="4.880882865120116"/
<p y="-2.067317214490182"/
<p y="2.2073586089087307"/
<p y="3.3367040715543173"/
<p y="-2.5038559366662474"/
<p y="2.3473880416674673"/
<p y="-1.5316038395321394"/
<p y="-3.2583324114325296"/
<p y="-0.27506770366519895"/
<p y="1.245828906811612"/
<p y="-3.5431225859348956"/
<p y="3.2798414210987765"/
<p y="-2.2518769568047245"/
<p y="0.1358210761220091"/
<p y="3.154286090942474"/
<p y="-2.4962145450527284"/
<p y="-2.7086090104949676"/
<p y="3.5267483789470244"/
<p y="0.5532521111773523"/
<p y="-0.5764439012759155"/
<p y="-0.8200950604867661"/
<p y="-0.7097116813016626"/
<p y="2.9357905058059366"/
<p y="-3.0925664740698986"/
<p y="-2.4164828509301683"/
<p y="0.13625904371743935"/
<p y="0.40608857137456855"/
<p y="-0.4696734332157213"/
<p y="-1.6477979282706756"/
<p y="-2.5669912847970155"/
<p y="0.3771912518171536"/
<p y="-1.537807672567216"/
<p y="-4.20367886765564"/
<p y="2.9181161749927877"/
<p y="3.924170571138365"/
<p y="-4.838658464102542"/
<p y="-4.7262954873228145"/
<p y="1.022389476335757"/
<p y="4.661154960579051"/
<p y="1.3156761633413243"/
<p y="-2.2475551416863935"/
<p y="-0.08314451021638014"/
<p y="0.20754011080568535"/
<p y="0.97904144624935"/
<p y="4.367939002962482"/
<p y="2.9656036928991147"/
<p y="-0.5372296211841849"/
<p y="-0.22138490094481522"/
<p y="-2.4445119825287964"/
<p y="0.5726116341585534"/
<p y="2.228533835844189"/
<p y="-3.74066021058024"/
<p y="2.0912397234179094"/
<p y="-0.06231422471164372"/
<p y="-3.4033798511156688"/
<p y="0.523992005839629"/
<p y="-2.634393237003594"/
<p y="3.7114844504624607"/
<p y="-0.963377771167993"/
<p y="-3.6725020484369786"/
<p y="4.123383888647226"/
<p y="2.6914202765421997"/
<p y="3.358121392360241"/
<p y="-2.071093310649521"/
<p y="3.906485942511983"/
<p y="-1.780895687666849"/
<p y="-3.045652681067196"/
<p y="-4.957197791539366"/
<p y="3.45266051450211"/
<p y="-3.3233585172477174"/
<p y="4.284764399403883"/
<p y="2.450615418316314"/
<p y="-2.4202901382715467"/
<p y="4.9161146248520655"/
<p y="1.2959273701405056"/
<p y="3.7278628026115896"/
<p y="3.3409114216089666"/
<p y="1.4653049327877907"/
<p y="-2.529513119959951"/
<p y="-1.7070816738371306"/
<p y="-0.5267439857753553"/
<p y="-4.217473511854218"/
<p y="3.11910775935935"/
<p y="-1.086530339336862"/
<p y="-4.995658983815709"/
<p y="-2.2393509411407884"/
<p y="4.908047059316468"/
<p y="-0.8681211543519289"/
<p y="-0.7981365547184609"/
<p y="-4.564986334144667"/
<p y="0.5843264502692067"/
<p y="4.708674226980406"/
<p y="0.9705174967740771"/
<p y="-1.209060655190343"/
<p y="-3.1632429052451485"/
<p y="-0.5174617856114505"/
<p y="3.4612850044254095"/
<p y="0.08000107236462028"/
<p y="2.257664232060738"/
<p y="-1.2042694310006152"/
<p y="-2.0444983191185138"/
<p y="-2.749069325362342"/
<p y="-4.661821295132121"/
<p y="3.022723763939789"/
<p y="-4.407015353850331"/
<p y="-2.4898618839639033"/
<p y="4.4543102354078545"/
<p y="1.6668352994693683"/
<p y="-1.385875838849012"/
<p y="-3.553045613273701"/
<p y="3.721713965135539"/
<p y="3.0235428688679242"/
<p y="-1.420533564333779"/
<p y="-3.5799393300863267"/
<p y="-2.164255361566685"/
<p y="3.900346686658059"/
<p y="-1.033820680652214"/
<p y="1.9869830318059716"/
<p y="4.578838352757851"/
<p y="1.6127552380370256"/
<p y="1.635375935768307"/
<p y="4.357174402977014"/
<p y="-4.950596969108987"/
<p y="3.979793361577306"/
<p y="4.304963923070883"/
<p y="-3.465688772092854"/
<p y="-1.7678588534865645"/
<p y="-0.7677697712801743"/
<p y="0.5738644073867611"/
<p y="-4.4399107240646805"/
<p y="4.578803972112887"/
<p y="4.37010244237066"/
<p y="3.728864906055101"/
<p y="2.526003374775227"/
<p y="4.196324110870783"/
<p y="2.136298110525498"/
<p y="-3.8620956950030982"/
<p y="-0.9290233748646015"/
<p y="0.5397655458974455"/
<p y="-3.2573140446287905"/
<p y="-3.3951170415654506"/
<p y="-4.6608835705170275"/
<p y="2.3295947286018484"/
<p y="0.20075047460465623"/
<p y="0.5352537414825544"/
<p y="-1.9521025431128303"/
<p y="-2.4474462239687176"/
<p y="2.5831936902950154"/
<p y="2.0002394341036"/
<p y="1.6305204840520835"/
<p y="-3.343445317407141"/
<p y="-3.5814464059735296"/
<p y="3.4798105236229304"/
<p y="0.13708540741054787"/
<p y="-1.8737497122300062"/
<p y="-4.699958806772413"/
<p y="-1.4955914455746724"/
<p y="2.281687943793745"/
<p y="-4.820930400937177"/
<p y="-4.046224294144846"/
<p y="0.17399069748222473"/
<p y="3.9296089627443607"/
<p y="3.7011109494153995"/
<p y="0.27119595982905054"/
<p y="2.569140171375583"/
<p y="-0.912248945811573"/
<p y="4.035411800936409"/
<p y="-2.5626620103117914"/
<p y="-2.9304062290910036"/
<p y="3.525069568862973"/
<p y="-4.3570710594370565"/
<p y="-1.8772578850892154"/
<p y="2.7153844207364823"/
<p y="-4.149892780599508"/
<p y="-0.5540555490263319"/
<p y="1.0288236919345461"/
<p y="-3.8115648007438487"/
<p y="2.123475764506683"/
<p y="-0.5986221664684157"/
<p y="-4.734486692333029"/
<p y="-1.944863671565622"/
<p y="1.1743464475354113"/
<p y="1.0418052108108133"/
<p y="4.3828301255730935"/
<p y="-4.206880462957939"/
<p y="0.6756078424170111"/
<p y="-1.9019639294716484"/
<p y="-4.233383320433674"/
<p y="2.7842373986639153"/
<p y="-3.174728217403967"/
<p y="-3.5218666798244893"/
<p y="3.0991378127327867"/
<p y="0.2254643404812109"/
<p y="-3.434145301871432"/
<p y="4.937672987359829"/
<p y="-1.6096023752423703"/
<p y="3.171676156370042"/
<p y="3.890190285183012"/
<p y="2.702323537116335"/
<p y="-4.985278264655262"/
<p y="-3.0340233599056097"/
<p y="4.356088065789766"/
<p y="0.3447213645539282"/
<p y="0.30949456321704627"/
<p y="-4.342808655260942"/
<p y="0.6416713614057823"/
<p y="-4.435079340717801"/
<p y="-1.2574154515301608"/
<p y="0.47756235767788624"/
<p y="-1.9668026402180585"/
<p y="1.5417970633167961"/
<p y="-3.7761058191551045"/
<p y="0.6820146922552386"/
<p y="-1.9926093853113902"/
<p y="-2.3789634959863304"/
<p y="-1.3905268955879038"/
<p y="-2.46118000262649"/
<p y="-3.884486434877188"/
<p y="4.189320549615793"/
<p y="-0.2207969654093178"/
<p y="-0.010516607202001538"/
<p y="-0.9376580173607518"/
<p y="-2.0365143075810686"/
<p y="-3.0857043920736995"/
<p y="-0.893014289091477"/
<p y="-2.6280154799941124"/
<p y="0.019835352687059604"/
<p y="-1.5489120763225883"/
<p y="3.189951219952759"/
<p y="-1.6658412146675392"/
<p y="-2.9051108073867757"/
<p y="-3.0281274865584473"/
<p y="-2.8238980985607998"/
<p y="-3.4499065127997266"/
<p y="-1.8687126174148547"/
<p y="2.0514946510872303"/
<p y="1.028749710331656"/
<p y="1.2467644918983654"/
<p y="1.2515086490351521"/
<p y="-3.5239714873043058"/
<p y="0.9158529656769074"/
<p y="0.37253116357856886"/
<p y="-1.5789587588516554"/
<p y="1.0838306223021954"/
<p y="0.9522706083400445"/
<p y="3.142571375265403"/
<p y="1.0107736326738728"/
<p y="1.1794984676263418"/
<p y="-2.435186657684728"/
<p y="0.6057561462390311"/
<p y="-1.9226037091465686"/
<p y="-0.6205197391079693"/
<p y="3.298553030071801"/
<p y="4.342175807396801"/
<p y="-2.907010156799259"/
<p y="2.1140728781547447"/
<p y="-3.3799296260575327"/
<p y="4.316821852561189"/
<p y="-1.9754093850790744"/
<p y="4.219246449609777"/
<p y="1.0482647931311462"/
<p y="2.5436128245179326"/
<p y="2.6149679642743218"/
<p y="-2.749821112566473"/
<p y="3.221013877024383"/
<p y="-4.501591875592144"/
<p y="1.3348510648276326"/
<p y="2.481869588622696"/
<p y="-4.4132218947838195"/
<p y="2.7587390901456494"/
<p y="-2.681240573110845"/
<p y="0.8823733984001123"/
<p y="0.026957726081924704"/
<p y="4.499058648934488"/
<p y="1.6954395571937733"/
<p y="0.033717490696927754"/
<p y="-1.9457865834504942"/
<p y="1.2619015603172201"/
<p y="0.43937644654491237"/
<p y="-1.131055913659591"/
<p y="1.810303560124228"/
<p y="-3.680247777953606"/
<p y="4.109129018314201"/
<p y="3.5348505434289574"/
<p y="-4.505595123864858"/
<p y="-3.5356900802750935"/
<p y="-1.404801270095406"/
<p y="-3.8629103144663803"/
<p y="4.175896518605008"/
<p y="3.8415031358303366"/
<p y="-0.19556415478337996"/
<p y="-0.180951159029485"/
<p y="2.629041530356365"/
<p y="0.4700670916606766"/
<p y="1.4999980343458317"/
<p y="-2.380731856327505"/
<p y="0.8771271303750483"/
<p y="-0.3599438321240118"/
<p y="-0.8139071333657739"/
<p y="-1.9723894254394212"/
<p y="1.256031771772463"/
<p y="-1.973907369368868"/
<p y="3.6316862333695568"/
<p y="-0.8533525729269051"/
<p y="2.91152767217996"/
<p y="-3.2979494290964895"/
<p y="-0.21331805810793902"/
<p y="0.572470148242731"/
<p y="2.1329225900544255"/
<p y="4.645580417128274"/
<p y="0.02131834464539928"/
<p y="-4.83456352021075"/
<p y="4.986484912415905"/
<p y="-0.11606526496897285"/
<p y="-0.9608542440820713"/
<p y="-3.4492759863826636"/
<p y="-2.07107303357122"/
<p y="-4.8135642999836525"/
<p y="1.0618402263030635"/
<p y="1.9238226146632016"/
<p y="-3.6739635132193826"/
<p y="-1.1759081091525783"/
<p y="-4.336957319369504"/
<p y="0.5829225407362824"/
<p y="4.660753891982813"/
<p y="-1.1950689317978913"/
<p y="-3.7948325202683653"/
<p y="-0.9235312776189009"/
<p y="-4.1079296736626745"/
<p y="-3.0846214978162823"/
<p y="-4.212297403488913"/
<p y="0.808739734390219"/
<p y="4.168861998107182"/
<p y="-0.3533519542113588"/
<p y="1.5581181765814893"/
<p y="-3.6592827169139888"/
<p y="-2.50812381095614"/
<p y="3.3284450441872746"/
<p y="-1.4556445535308415"/
<p y="0.4092596901824752"/
<p y="-3.317048180562867"/
<p y="-2.9500827962495113"/
<p y="1.8813975269559489"/
<p y="-0.8457183653998808"/
<p y="1.2731851093046318"/
<p y="0.6081537001240687"/
<p y="-1.6596282124260053"/
<p y="-3.5810978255929324"/
<p y="-1.5959591815579435"/
<p y="4.999731869549699"/
<p y="-4.863704790567828"/
<p y="4.507909233741067"/
<p y="-4.62947675584707"/
<p y="4.080766913192612"/
<p y="-1.212606137426727"/
<p y="-1.1166397226431082"/
<p y="-1.7955807228441492"/
<p y="3.6726753533868735"/
<p y="-4.340173215060192"/
<p y="-1.8132013370956912"/
<p y="3.3307410968038305"/
<p y="4.004293971463289"/
<p y="0.3904337135657796"/
<p y="1.6859188710125235"/
<p y="-0.21162375394874555"/
<p y="3.021066266417286"/
<p y="4.183275865290746"/
<p y="-0.13025883673923921"/
<p y="0.680839390605037"/
<p y="-2.742980908053305"/
<p y="3.5941376773566827"/
<p y="2.3225559374408355"/
<p y="-3.1349828142414515"/
<p y="-0.33152485033140344"/
<p y="1.9442435629258874"/
<p y="3.8192385718714075"/
<p y="4.8929961067942145"/
<p y="-1.6905095211635244"/
<p y="3.428277597423257"/
<p y="0.9262408448115593"/
<p y="-0.14649017772761752"/
<p y="2.1876259422645656"/
<p y="1.6079575887687465"/
<p y="1.2021965687083194"/
<p y="3.073039960848835"/
<p y="2.7237958130770625"/
<p y="-1.1771205242520355"/
<p y="-1.9111273736579868"/
<p y="-0.80344517155023"/
<p y="-4.104552996369972"/
</dataset>
<dataset>
<p y="-0.42192979220963533"/
<p y="1.2282913894256755"/
<p y="0.1438346236615055"/
<p y="-0.4222861556457015"/
<p y="-0.1531961793134705"/
<p y="1.1768906812191724"/
<p y="1.2341365542924017"/
<p y="0.9288589849757674"/
<p y="2.8190923574192865"/
<p y="-1.8738075218636192"/
<p y="-1.6514105137826833"/
<p y="-2.036982769634914"/
<p y="3.4763731061184835"/
<p y="2.9171433857869884"/
<p y="-2.314670357486776"/
<p y="0.8405048253194112"/
<p y="1.5468069594039242"/
<p y="-5.8166147624307"/
<p y="0.3154703320059633"/
<p y="-1.0388904428806138"/
<p y="0.2509174750692383"/
<p y="-3.9284125712969566"/
<p y="0.6364802040782078"/
<p y="2.2030379313830237"/
<p y="-0.2783316007922131"/
<p y="2.4382599150409985"/
<p y="0.8736268861258758"/
<p y="-4.0572223553399995"/
<p y="-0.3401406027179385"/
<p y="3.231653921448184"/
<p y="0.025034487579376142"/
<p y="3.1594111933960605"/
<p y="-1.0286121967804378"/
<p y="0.34922941096008614"/
<p y="1.9289390185946034"/
<p y="1.8711699868085792"/
<p y="-0.22595348975138563"/
<p y="-0.5943106641974654"/
<p y="1.3905493570638519"/
<p y="3.8309189543537894"/
<p y="0.7874244219960553"/
<p y="0.52897572269655"/
<p y="0.4307236680928169"/
<p y="-0.9558733386460309"/
<p y="0.8282449769126108"/
<p y="0.8200855034519762"/
<p y="1.559072912822583"/
<p y="2.4700627777463606"/
<p y="-4.444011721150167"/
<p y="0.962951550508662"/
<p y="0.9020975768867888"/
<p y="2.1808733419443045"/
<p y="-4.236371832351474"/
<p y="-0.39011636952579065"/
<p y="-3.676561193598901"/
<p y="1.8891464331495114"/
<p y="-1.0218111940348387"/
<p y="-0.5320807291183521"/
<p y="0.8830720361677321"/
<p y="-0.5394524171249958"/
<p y="-0.8130167053188131"/
<p y="0.9558203874401408"/
<p y="-2.0381834682667783"/
<p y="1.9401153888315075"/
<p y="-0.8636919884164342"/
<p y="1.5090887691004609"/
<p y="-2.012210793072078"/
<p y="-0.28936283313222433"/
<p y="-1.9677557632206324"/
<p y="1.0545992189907718"/
<p y="-1.264377398621248"/
<p y="-3.7024432403845853"/
<p y="1.4305256928507408"/
<p y="3.738994655509198"/
<p y="-1.950973040395398"/
<p y="0.6288546167547283"/
<p y="0.7402612120289038"/
<p y="-0.9581344253868521"/
<p y="4.193075234013549"/
<p y="-0.22912005749002073"/
<p y="1.0219416492465039"/
<p y="0.6012824324793441"/
<p y="0.6086426107045825"/
<p y="0.5574631685454067"/
<p y="2.738073346817743"/
<p y="-2.7853733580968654"/
<p y="2.690180870211216"/
<p y="0.8627332973671274"/
<p y="1.6687442971883226"/
<p y="2.116760251998308"/
<p y="-0.988076506579241"/
<p y="3.717850536504938"/
<p y="0.3426837108566621"/
<p y="1.813647330093043"/
<p y="1.9532265470171248"/
<p y="1.8066071120766454"/
<p y="-2.0759488730796853"/
<p y="-1.1224813363796342"/
<p y="0.2044103204100198"/
<p y="-0.6673361751003067"/
<p y="-2.6660394053803027"/
<p y="-1.161818442480204"/
<p y="-1.5247474211069207"/
<p y="1.5359016200073734"/
<p y="3.4855111431137646"/
<p y="-0.531650975667331"/
<p y="0.539966698572631"/
<p y="-0.3410857773647859"/
<p y="-1.8252890469658305"/
<p y="-1.1806509868954027"/
<p y="2.3567086953601684"/
<p y="0.285522412813953"/
<p y="3.376784993244804"/
<p y="-1.1363130871823104"/
<p y="-3.6419303381407593"/
<p y="-1.3391031861015592"/
<p y="1.6543752298048462"/
<p y="0.9044342103810049"/
<p y="-1.0178245056225952"/
<p y="0.24546050472941058"/
<p y="-1.3802194651410211"/
<p y="-0.04251852575921371"/
<p y="0.6260677641946536"/
<p y="2.1478697579919133"/
<p y="-0.5095409834966108"/
<p y="-0.69034924663881"/
<p y="2.235429833625046"/
<p y="-1.281415218901489"/
<p y="-4.703279438796516"/
<p y="-0.8937361413174635"/
<p y="1.0642297648532002"/
<p y="1.221482444328919"/
<p y="-1.3463786085948515"/
<p y="0.27934615291686044"/
<p y="0.44069579868163394"/
<p y="-4.960345809424787"/
<p y="-0.8866884384318338"/
<p y="1.3296974726023456"/
<p y="2.606140709663546"/
<p y="-1.7464351776674252"/
<p y="0.7588166034518883"/
<p y="3.2916078780737297"/
<p y="0.840842371943854"/
<p y="-0.41950142309990995"/
<p y="-2.225841819530515"/
<p y="0.929768372670587"/
<p y="4.805233997384465"/
<p y="-1.8994937484515657"/
<p y="-0.4683732583710451"/
<p y="-1.584548335649178"/
<p y="0.24324195862354264"/
<p y="-2.3960641351123635"/
<p y="0.5961541904403171"/
<p y="-3.766625988006139"/
<p y="4.80082152238733"/
<p y="1.617964599231798"/
<p y="-0.1563777716230556"/
<p y="-1.5552244417156236"/
<p y="2.310856961187929"/
<p y="-1.2720942112910394"/
<p y="-2.95794384321969"/
<p y="-3.1166335326536294"/
<p y="-1.3193706477476275"/
<p y="0.7805487447855398"/
<p y="-3.8055977457848478"/
<p y="0.8801868144814565"/
<p y="-1.2911890041038574"/
<p y="-1.555855920486066"/
<p y="1.8845076273372283"/
<p y="1.251505792364235"/
<p y="-1.058911372308297"/
<p y="-0.10200243585887886"/
<p y="-1.149131511745772"/
<p y="0.7152717629039513"/
<p y="0.390801662480226"/
<p y="1.4014650768471915"/
<p y="-0.8527721901098059"/
<p y="-1.0508719245433675"/
<p y="-1.7171406916909224"/
<p y="-4.826835744683166"/
<p y="1.46602568920214"/
<p y="-1.443754539300907"/
<p y="0.32732899181101116"/
<p y="-0.7852409429629834"/
<p y="-0.7111576629500812"/
<p y="-3.1571561021017214"/
<p y="1.4163275659413432"/
<p y="-1.293203854613083"/
<p y="2.009082605909594"/
<p y="1.6022076784028985"/
<p y="-0.28797219216663295"/
<p y="0.29588916602658794"/
<p y="-0.32231563701884897"/
<p y="-1.5332123879780057"/
<p y="0.14652074413134492"/
<p y="3.5673540244496604"/
<p y="1.861034104868732"/
<p y="-3.2304007811738504"/
<p y="2.5448507895655506"/
<p y="-0.9701775999837283"/
<p y="0.2582276928321808"/
<p y="-1.2382714531812777"/
<p y="-2.013620449151309"/
<p y="-2.072712053535698"/
<p y="1.0888919077800039"/
<p y="-2.320193345259177"/
<p y="-2.299394274405836"/
<p y="-4.384772650039984"/
<p y="-5.305678935992811"/
<p y="2.2688160588728175"/
<p y="1.3335845423874937"/
<p y="1.2049978703258226"/
<p y="-1.39362725270181"/
<p y="1.4620812589899344"/
<p y="1.0469341677808228"/
<p y="1.251758617550048"/
<p y="1.3153978197524827"/
<p y="-2.4777132579376473"/
<p y="5.364930745678874"/
<p y="1.4073582828650126"/
<p y="3.646737554438551"/
<p y="0.012691808371514603"/
<p y="-0.9171086136222375"/
<p y="0.21509539188925758"/
<p y="-1.8625656181562504"/
<p y="0.26158878294560933"/
<p y="-1.5583438438577308"/
<p y="1.1703818933933128"/
<p y="-3.704004951816396"/
<p y="0.7141122366118318"/
<p y="0.6402722979191169"/
<p y="3.2074589246675633"/
<p y="1.9070478356622746"/
<p y="1.0138068674790932"/
<p y="-0.32319581936252545"/
<p y="-2.3761371816987364"/
<p y="1.2075419635534201"/
<p y="-0.9941491901984983"/
<p y="-0.9946436779017385"/
<p y="0.24611953992849192"/
<p y="1.0639175139138244"/
<p y="-5.096685939317557"/
<p y="0.992939978664027"/
<p y="0.9203051683363491"/
<p y="-0.5863981638824222"/
<p y="0.2377426176474289"/
<p y="1.2634526223417166"/
<p y="2.6695409443577582"/
<p y="1.8458606321692448"/
<p y="2.463327747914459"/
<p y="-2.830778962945178"/
<p y="-2.3226288780865847"/
<p y="0.21692841603562626"/
<p y="-2.0794008739228134"/
<p y="0.8722243054343175"/
<p y="0.9338679719029432"/
<p y="-1.2226157040887942"/
<p y="-2.180617845074191"/
<p y="-2.934598200445459"/
<p y="1.615299943284555"/
<p y="-2.937457808692585"/
<p y="0.5014286052341713"/
<p y="-3.7222115093010752"/
<p y="-0.19965096279934214"/
<p y="0.45249416540751636"/
<p y="1.3741942879382407"/
<p y="-0.12570905946946986"/
<p y="4.929951207890067"/
<p y="-0.5998149850722958"/
<p y="0.9538539208768515"/
<p y="-0.1666247722595713"/
<p y="1.4197234039681135"/
<p y="-2.4851702037958376"/
<p y="-0.1285301764365782"/
<p y="0.7951799130669203"/
<p y="-5.823073505902122"/
<p y="5.761711253738962"/
<p y="3.296246186511128"/
<p y="2.0069825002876183"/
<p y="0.01365537925687324"/
<p y="-4.235088893227969"/
<p y="-4.194959880534872"/
<p y="2.614903707979214"/
<p y="1.526829032895322"/
<p y="1.1676607767887939"/
<p y="-1.6254285242724675"/
<p y="1.3742906976536473"/
<p y="1.4689956842977856"/
<p y="0.7806981839631786"/
<p y="0.04038752682134367"/
<p y="0.45738911905059604"/
<p y="-1.5664554752124542"/
<p y="0.5331177473387937"/
<p y="1.6635776479979731"/
<p y="0.876603308595453"/
<p y="-1.9587398342550058"/
<p y="-0.5681680994386669"/
<p y="-3.2045792504933686"/
<p y="0.10226397049641862"/
<p y="0.9612112761155983"/
<p y="2.7899283971856472"/
<p y="-0.7073203356997267"/
<p y="0.16280340097053522"/
<p y="3.483235451712346"/
<p y="3.8094997158238506"/
<p y="-0.9467377508069195"/
<p y="1.846831024064176"/
<p y="0.5043511903197648"/
<p y="-0.9964350540681396"/
<p y="0.3355416540374092"/
<p y="-0.23783681996671371"/
<p y="0.6523060830567324"/
<p y="-1.1955180149691285"/
<p y="3.948125103458566"/
<p y="-1.9637784735040356"/
<p y="-1.2283314970543469"/
<p y="0.12828354974109465"/
<p y="-0.37340419664663493"/
<p y="0.5153460436069451"/
<p y="0.22297777082672737"/
<p y="2.711119558457082"/
<p y="2.0846141671932816"/
<p y="0.43818411306509725"/
<p y="0.1344815785013897"/
<p y="2.5748959733264387"/
<p y="0.5222115430972833"/
<p y="0.8238363700364225"/
<p y="1.2590834849654582"/
<p y="-3.4739538606279714"/
<p y="-2.031004001112446"/
<p y="0.757325070032979"/
<p y="-2.7396501658608883"/
<p y="1.0170814357707518"/
<p y="2.5440402963633066"/
<p y="-0.7287918362104943"/
<p y="-0.10150478340879893"/
<p y="-0.2460964091459169"/
<p y="-3.5764881357158136"/
<p y="1.0285361727871478"/
<p y="-0.44382018362272624"/
<p y="0.7254321128776483"/
<p y="3.973666057033134"/
<p y="-2.4595562800609168"/
<p y="3.2794740870376597"/
<p y="0.23326895255597704"/
<p y="-0.650700270445336"/
<p y="-2.723905826178996"/
<p y="-3.026776187223928"/
<p y="0.4779127616617813"/
<p y="-3.2085591054146696"/
<p y="-3.82473712194165"/
<p y="0.8906218162170444"/
<p y="-0.42521220381642655"/
<p y="-0.1350184177140199"/
<p y="2.1716586782335594"/
<p y="0.5785470250151661"/
<p y="0.7013193711848008"/
<p y="-1.670990757932266"/
<p y="-3.677498709531244"/
<p y="-0.6105338876128359"/
<p y="-1.6577625405687226"/
<p y="-0.09451052412005913"/
<p y="-1.7381372245963367"/
<p y="-3.3108606128687152"/
<p y="1.558593218602774"/
<p y="-0.41696969985068183"/
<p y="-0.5376328667302931"/
<p y="2.8470094756487927"/
<p y="0.016203519972643243"/
<p y="1.4054816944796906"/
<p y="0.6330210496416208"/
<p y="4.059986298537559"/
<p y="-2.523773492650556"/
<p y="0.8830880488010684"/
<p y="1.1894270766645756"/
<p y="2.210576685769337"/
<p y="0.2691453673211554"/
<p y="-0.7478594041385783"/
<p y="0.9099186658294318"/
<p y="-1.4097154896996267"/
<p y="-0.9590320650029484"/
<p y="-0.4536599762039081"/
<p y="2.3266581878265136"/
<p y="-0.6301293880906892"/
<p y="-0.9627118723199358"/
<p y="3.829627572242109"/
<p y="-0.5336753636780055"/
<p y="-3.1935464280992303"/
<p y="0.8915038079937121"/
<p y="0.14272219067430877"/
<p y="-0.8513372530059826"/
<p y="-1.5682589091125236"/
<p y="-1.149402663329099"/
<p y="4.198178997967914"/
<p y="0.41279059960057446"/
<p y="2.5051877293352645"/
<p y="-2.285757379273558"/
<p y="-3.746167797761572"/
<p y="0.5361695480493834"/
<p y="-1.7201678465296255"/
<p y="-0.9476075903848462"/
<p y="-2.0764583399427923"/
<p y="-2.487001047358628"/
<p y="-1.7192028796800385"/
<p y="1.4124663157703348"/
<p y="-4.234438611513368"/
<p y="0.4373890872269399"/
<p y="-3.1135455911812095"/
<p y="-0.6313428962173998"/
<p y="4.425881716087308"/
<p y="1.4205145798032979"/
<p y="2.4314418263764996"/
<p y="-1.7970000045394128"/
<p y="-0.14272329441746243"/
<p y="-1.7814219506140798"/
<p y="-0.5835181239824364"/
<p y="-0.3763382340783203"/
<p y="-4.615890466742678"/
<p y="2.308025365634009"/
<p y="-4.900431945894853"/
<p y="0.24514627267444009"/
<p y="3.6876603657765896"/
<p y="-0.10868219344659077"/
<p y="-2.2712666507435375"/
<p y="1.133675766236045"/
<p y="0.10761133663530636"/
<p y="1.642391896865026"/
<p y="1.44861483342228"/
<p y="-2.3148001701962504"/
<p y="-2.618805939119676"/
<p y="-3.308737360530226"/
<p y="-2.715970620420281"/
<p y="1.3189618812271193"/
<p y="-1.507961495521793"/
<p y="1.129026031899949"/
<p y="-2.883399153151763"/
<p y="0.5107953895643462"/
<p y="0.3476139999909602"/
<p y="-0.585957833063182"/
<p y="-0.16860795326674916"/
<p y="-2.21421769700113"/
<p y="-0.11917334900017951"/
<p y="1.206105043877924"/
<p y="-2.1988755521273853"/
<p y="-0.9028930965052042"/
<p y="-1.3759910769611905"/
<p y="-1.1039038563848524"/
<p y="1.0623279396662293"/
<p y="-0.4631186811021732"/
<p y="-1.9611885611875028"/
<p y="-2.810867798495149"/
<p y="0.48261440177770704"/
<p y="2.6376852815052576"/
<p y="-0.43757229609363035"/
<p y="1.6939263014804842"/
<p y="-2.7635919517019873"/
<p y="0.38820502093900394"/
<p y="-2.547000616167606"/
<p y="-3.7541628942877354"/
<p y="2.2367660767317563"/
<p y="-0.830715068466018"/
<p y="-0.005414731682581678"/
<p y="1.3976898685014674"/
<p y="0.9438800396385296"/
<p y="-1.3103249104405732"/
<p y="1.8198674417278826"/
<p y="0.7168668007292615"/
<p y="1.7034557087945252"/
<p y="0.6307578151158177"/
<p y="1.3200028138278086"/
<p y="0.34525653057316946"/
<p y="2.670549541235567"/
<p y="2.3115070239015654"/
<p y="0.7796616229837272"/
<p y="-0.22313755654125392"/
<p y="-3.128674008576484"/
<p y="-0.8013173328892339"/
<p y="-0.7796634233839157"/
<p y="0.6216895221414724"/
<p y="-0.31609152882644853"/
<p y="4.43693654503493"/
<p y="-2.7052040162315083"/
<p y="2.382745788982535"/
<p y="0.31726366976227466"/
<p y="-1.2663627899843561"/
<p y="-2.2240226447390605"/
<p y="-0.729134815447991"/
<p y="-4.00842660263715"/
<p y="-0.6701883109684222"/
<p y="3.338260840204603"/
<p y="-1.0515317699109037"/
<p y="1.887019788609464"/
<p y="-5.079400037224385"/
<p y="0.6437431851914318"/
<p y="0.023376130308740445"/
<p y="1.6252270406380803E-4"/
<p y="-2.3090861492910166"/
<p y="-1.6397460810047857"/
<p y="0.19029452759880133"/
<p y="4.154864696535042"/
<p y="0.20993008207672223"/
<p y="-1.2438639710104833"/
<p y="0.01460416251344233"/
<p y="2.347766732264558"/
<p y="0.8000392410570051"/
<p y="0.9950602525415089"/
<p y="-0.723413859453554"/
<p y="-1.2511901488140877"/
<p y="-1.1994565396799268"/
<p y="-0.04719813382286341"/
<p y="1.6183081621474062"/
<p y="1.0729785352636994"/
<p y="1.3396902676367044"/
<p y="-2.7581733001112863"/
<p y="4.03179767867398"/
<p y="1.10932833028127"/
<p y="0.9248973644533914"/
<p y="2.1811093077157175"/
<p y="-2.638153665167442"/
<p y="-0.9569151787385305"/
<p y="-1.4807269803246998"/
<p y="2.354895532293969"/
<p y="-3.033056757955116"/
<p y="-2.4250483669371174"/
<p y="-1.7815050106919448"/
<p y="-0.9587159033632507"/
<p y="1.8709116679838367"/
<p y="-3.617845479900121"/
<p y="4.157935338700571"/
<p y="0.7723158412037215"/
<p y="-1.8186964231185438"/
<p y="2.0447162049188363"/
<p y="-1.2322328778385094"/
<p y="1.9761673750373576"/
<p y="-2.4181801332277018"/
<p y="-0.5259390406076111"/
<p y="-1.2059337443897185"/
<p y="0.7472153870060378"/
<p y="-0.8747356489394547"/
<p y="-2.0645633710230307"/
<p y="-0.9155006111272684"/
<p y="2.6900443923047224"/
<p y="-0.7012110436463149"/
<p y="-0.7424599432362063"/
<p y="-0.6828145799624684"/
<p y="1.1429202036729882"/
<p y="3.8987009596973903"/
<p y="3.40487989084156"/
<p y="-0.7298279663448419"/
<p y="1.019394927916091"/
<p y="-2.926967664539025"/
<p y="-2.8483422523458164"/
<p y="1.1041413150547748"/
<p y="2.6592074293318086"/
<p y="1.4023999338168422"/
<p y="1.2922332647149557"/
<p y="2.29046816892887"/
<p y="-2.405451148513124"/
<p y="-2.588239416034352"/
<p y="0.2590942065243094"/
<p y="1.1753744380312334"/
<p y="-1.6292394426242798"/
<p y="-1.3133867984147467"/
<p y="1.21652940979049"/
<p y="-1.1085096124247171"/
<p y="-1.9849845380641502"/
<p y="1.1546336475883423"/
<p y="0.6015372935854866"/
<p y="2.6466139488579463"/
<p y="0.19559818362169082"/
<p y="1.1118671188816587"/
<p y="0.7331659350043169"/
<p y="-0.41479114644662335"/
<p y="1.0730685668584532"/
<p y="1.5913337273551473"/
<p y="-2.212369374467226"/
<p y="4.619091066419271"/
<p y="4.283457638162882"/
<p y="-0.7097953698362657"/
<p y="-2.026273979972235"/
<p y="-2.246203162946737"/
<p y="0.7688336968406244"/
<p y="-0.24299799538560327"/
<p y="1.221332732088951"/
<p y="-1.037532008408867"/
<p y="0.265627381412655"/
<p y="-0.2789269946864341"/
<p y="-0.24332453464991524"/
<p y="-0.879604651056694"/
<p y="1.584413869168804"/
<p y="0.6107719613750131"/
<p y="-0.9822960097345185"/
<p y="-1.4568431672294053"/
<p y="2.0987836852983808"/
<p y="4.3073135034580465"/
<p y="3.3813515261424745"/
<p y="0.4533407969363763"/
<p y="0.7764350800356945"/
<p y="-2.0472422784917805"/
<p y="0.9803195076714702"/
<p y="1.0867377839260595"/
<p y="1.1447685782967005"/
<p y="-3.497387284719751"/
<p y="1.1229722630255374"/
<p y="0.8295516108469965"/
<p y="1.108645581090574"/
<p y="0.7330623046152882"/
<p y="-1.7587903064071844"/
<p y="1.0842847940036529"/
<p y="2.9115226279974378"/
<p y="1.3476605301798694"/
<p y="-0.3125281233278502"/
<p y="2.838844387034521"/
<p y="0.17975277280274465"/
<p y="-1.2582599615045276"/
<p y="2.4297186241171715"/
<p y="2.5845891453349905"/
<p y="1.9376396290291498"/
<p y="2.783813425113087"/
<p y="1.0252150187107687"/
<p y="-0.7232058549606764"/
<p y="2.052735242504877"/
<p y="1.8079155624666607"/
<p y="2.423796119235053"/
<p y="-2.0594491630164744"/
<p y="4.399519287941927"/
<p y="-1.4133988025500528"/
<p y="-1.9193088783639616"/
<p y="5.984960307381329"/
<p y="0.17452215313336764"/
<p y="-4.276083586684159"/
<p y="2.7824333191774233"/
<p y="0.8337542166045901"/
<p y="2.7831573508419014"/
<p y="-1.3049430653055638"/
<p y="-1.499535924442659"/
<p y="-3.0577400626986107"/
<p y="0.8277894542287989"/
<p y="2.5209893383566184"/
<p y="-1.585587252140324"/
<p y="-1.2261830729067125"/
<p y="-2.9612279495517444"/
<p y="-2.953080611683581"/
<p y="0.3856603556917258"/
<p y="-2.929526760417941"/
<p y="-1.7670778578208954"/
<p y="1.705520267804006"/
<p y="1.0522233229392517"/
<p y="0.07850350324522058"/
<p y="1.7988945872660906"/
<p y="-0.0464486076557987"/
<p y="-0.2145042186518992"/
<p y="-1.8552082134293157"/
<p y="-2.126398309439148"/
<p y="1.2452681579185705"/
<p y="-2.7522208539963673"/
<p y="3.563741534005647"/
<p y="-1.2054477484625465"/
<p y="-2.8521790813508674"/
<p y="-1.62255782320303"/
<p y="0.25722709309330577"/
<p y="2.0098172609282363"/
<p y="-0.24229462793898926"/
<p y="0.6856937213600448"/
<p y="-0.4482473666192404"/
<p y="-1.617272621665141"/
<p y="0.12769506766361288"/
<p y="-2.8074503166567157"/
<p y="0.8745650081743467"/
<p y="0.42331056070105066"/
<p y="0.8292732305311201"/
<p y="-1.793020634330691"/
<p y="1.3854746260723019"/
<p y="-2.9152245127659064"/
<p y="0.5018374838963751"/
<p y="-1.3997851928398861"/
<p y="0.41663822236455983"/
<p y="-2.7327432436713543"/
<p y="-1.6422872833443474"/
<p y="2.9430551313253934"/
<p y="-0.7484393126051638"/
<p y="1.3840371625468981"/
<p y="3.2799116057331577"/
<p y="2.897330834336944"/
<p y="0.38265471948297114"/
<p y="3.8118669762399966"/
<p y="-2.118836174243371"/
<p y="2.664107452204703"/
<p y="-0.21626050999614396"/
<p y="1.4128370293953407"/
<p y="-1.0075043737583103"/
<p y="-1.9916496363908598"/
<p y="2.0728512608306895"/
<p y="-1.048835163157255"/
<p y="0.715810892394314"/
<p y="1.335308706500199"/
<p y="-3.5550154585921794"/
<p y="-0.7725205795780514"/
<p y="-2.982028028149059"/
<p y="-2.7858346377156047"/
<p y="-0.5718227886470688"/
<p y="-0.8983973387875829"/
<p y="0.870186180920351"/
<p y="0.7028203264259921"/
<p y="-0.08995768237983745"/
<p y="-0.19976724693359657"/
<p y="0.3238399076852797"/
<p y="2.546356726743302"/
<p y="-1.0913815050005893"/
<p y="2.5346900973444355"/
<p y="0.46896916843827563"/
<p y="2.2888182185278043"/
<p y="2.239351591277711"/
<p y="0.6396420601503094"/
<p y="-3.5143542211794445"/
<p y="0.36081668484262736"/
<p y="-1.237682077325765"/
<p y="1.4180064113239488"/
<p y="-1.233214966298094"/
<p y="-0.3940783542168105"/
<p y="1.7649084701361297"/
<p y="-5.210210376693949"/
<p y="2.631473390872881"/
<p y="-0.4866029670921914"/
<p y="-0.5454883098214217"/
<p y="-0.41320445466230704"/
<p y="-2.4086864577255915"/
<p y="-0.36427888306519146"/
<p y="-0.3090758561544319"/
<p y="-0.856559045532368"/
<p y="-2.9945977583089047"/
<p y="0.8990862617599736"/
<p y="-1.1754910521736144"/
<p y="-2.527083455504349"/
<p y="-0.7574099839026327"/
<p y="-4.320972771596547"/
<p y="0.7118986432515726"/
<p y="1.9643468785657574"/
<p y="2.9103152266579357"/
<p y="-1.331779504511598"/
<p y="0.3853314511535216"/
<p y="-1.6595796538191885"/
<p y="-2.7985984984359407"/
<p y="-1.2299184743435843"/
<p y="-1.5123386925164914"/
<p y="2.253906749904524"/
<p y="0.8369946254563022"/
<p y="2.339046223764979"/
<p y="-0.9370038671931636"/
<p y="-0.49972770062816296"/
<p y="-0.8082873326972373"/
<p y="1.3613054268725637"/
<p y="-4.003041378612815"/
<p y="2.795312914133453"/
<p y="2.186544084508779"/
<p y="1.947737783603042"/
<p y="3.6885541457471334"/
<p y="0.9381075369032212"/
<p y="0.7526942606698995"/
<p y="0.8523311563532888"/
<p y="0.6196330414183809"/
<p y="-1.2030971517507765"/
<p y="-3.1254771717652843"/
<p y="-0.14198859055740742"/
<p y="-1.0891260404533474"/
<p y="-0.07000984560159643"/
<p y="-0.9272189570798204"/
<p y="1.6988090907078723"/
<p y="-1.0663674578454518"/
<p y="-1.2728997833938804"/
<p y="1.1741616319951353"/
<p y="-3.2237011429883093"/
<p y="-0.30383448326775697"/
<p y="-1.4316986492854857"/
<p y="0.20696783970860896"/
<p y="-1.3231216989168997"/
<p y="2.1217328708527363"/
<p y="-1.7280532238592317"/
<p y="-1.1051676656138594"/
<p y="-0.2936997421771277"/
<p y="-0.8118498506128882"/
<p y="2.189249308637747"/
<p y="0.42577247878579993"/
<p y="0.6339210298870912"/
<p y="2.86001857082211"/
<p y="-2.242573717734836"/
<p y="1.179788905696775"/
<p y="-1.3705412271356834"/
<p y="2.8439711273037362"/
<p y="0.7072191254224552"/
<p y="0.15841401933163493"/
<p y="2.064190358509517"/
<p y="-0.9507833986696804"/
<p y="0.15890669979662217"/
<p y="4.303060827820003"/
<p y="-1.2646050319366124"/
<p y="4.439206266292913"/
<p y="0.6363377311913269"/
<p y="1.1662483872244191"/
<p y="-1.5117717707681495"/
<p y="5.8664422666919664"/
<p y="-0.4658432609121299"/
<p y="2.2675814046657607"/
<p y="-3.1879781617562086"/
<p y="2.4672182023652454"/
<p y="-1.4873635759728225"/
<p y="3.7104518698409015"/
<p y="0.5404081816120705"/
<p y="0.8568261735132321"/
<p y="-0.3491321572862816"/
<p y="-2.1787124788306063"/
<p y="-1.124857813041259"/
<p y="1.7026545885549875"/
<p y="-1.7637440820719994"/
<p y="2.4350424483352144"/
<p y="1.2003539862470343"/
<p y="0.660317163788645"/
<p y="-0.4243403356295516"/
<p y="1.0457645726929246"/
<p y="0.5885627858812301"/
<p y="-3.4672272813894884"/
<p y="0.11026628860115474"/
<p y="3.036314727030216"/
<p y="-3.184330567368323"/
<p y="-0.6915695900399762"/
<p y="-0.099981323998373"/
<p y="1.0215605569346837"/
<p y="1.7785848400846977"/
<p y="1.6169197449831447"/
<p y="3.8338256858841753"/
<p y="-0.9499063966836193"/
<p y="-1.884761949719255"/
<p y="-0.2726228542398799"/
<p y="-0.3543303497512587"/
<p y="0.49799230350451873"/
<p y="2.181131868139463"/
<p y="2.059130041327376"/
<p y="1.467675786662645"/
<p y="-2.052523983548817"/
<p y="0.8910428696897793"/
<p y="-4.622920438967795"/
<p y="-0.043505789745846866"/
<p y="0.22842231395020776"/
<p y="-1.0774038080946597"/
<p y="0.8154580587809033"/
<p y="-0.6975865626886681"/
<p y="5.207442453109037"/
<p y="-3.2390796710231253"/
<p y="-0.6330437012230693"/
<p y="1.4392826250874038"/
<p y="-2.656543153393005"/
<p y="3.6050493782601216"/
<p y="0.042744262818547894"/
<p y="1.5224878393617332"/
<p y="1.2679612269705423"/
<p y="1.7313967552056146"/
<p y="2.254198445516219"/
<p y="-1.554500110705383"/
<p y="-0.8416132130152022"/
<p y="1.3686285361824997"/
<p y="-0.7206326247524406"/
<p y="-0.8757241588158186"/
<p y="0.7322025139714197"/
<p y="-0.7378391759783631"/
<p y="1.6621520544312667"/
<p y="0.24562283475110566"/
<p y="-0.3116486720607885"/
<p y="-0.37948210571115243"/
<p y="-0.30814809679134425"/
<p y="1.8687955999623587"/
<p y="0.7204983438536828"/
<p y="1.7623217278417445"/
<p y="-0.41325829832780453"/
<p y="-1.262449268141447"/
<p y="-0.8154181820683117"/
<p y="0.8253809350961839"/
<p y="-3.569768941215968"/
<p y="-2.9020990476370434"/
<p y="0.6991394049241109"/
<p y="-0.6313968157294584"/
<p y="-1.7681375935609924"/
<p y="-1.6347954497997819"/
<p y="-0.7877499191324349"/
<p y="-0.5415213625032912"/
<p y="-1.2993321245343357"/
<p y="3.6224596691925606"/
<p y="-1.103955688598107"/
<p y="2.8441541615986"/
<p y="1.956861870241002"/
<p y="0.07149858714522402"/
<p y="-2.236186790736065"/
<p y="0.8118823246321049"/
<p y="-2.0105270602638097"/
<p y="1.80911708870972"/
<p y="-0.5213202275531256"/
<p y="1.4922405223099182"/
<p y="1.4230332013801348"/
<p y="-0.391502653777493"/
<p y="-2.3614489590868657"/
<p y="0.49209656136067237"/
<p y="0.7036802037598424"/
<p y="-3.0135040975848857"/
<p y="-0.7956325793073658"/
<p y="-2.25897451416989"/
<p y="3.658225592064961"/
<p y="-0.45829938124522424"/
<p y="0.18179009991111153"/
<p y="-0.23384168677734904"/
<p y="-1.5119705117846771"/
<p y="2.1352502472633845"/
<p y="-0.5797416787298357"/
<p y="-1.9233961426897062"/
<p y="0.29159687568160736"/
<p y="-2.1486452139916117"/
<p y="-5.859021329902268"/
<p y="0.4450175562692349"/
<p y="0.5066951548874211"/
<p y="-1.0526655656544013"/
<p y="1.1495124902913694"/
<p y="-2.8418497779707077"/
<p y="4.015702028593146"/
<p y="-0.25060675046280295"/
<p y="0.46471867726985394"/
<p y="-0.4768818093666325"/
<p y="2.8530844265632505"/
<p y="-3.6469019788346095"/
<p y="0.49587731688330267"/
<p y="-3.0978201436548374"/
<p y="2.055604713724766"/
<p y="0.8852640832559961"/
<p y="0.22520940611824963"/
<p y="-3.470477392997989"/
<p y="2.9991146689269925"/
<p y="4.052569107432223"/
<p y="1.281433868591729"/
<p y="-2.676486466327466"/
<p y="-1.784926828453049"/
<p y="-0.9721635963071332"/
<p y="0.9215210102128368"/
<p y="1.5204439911773475"/
<p y="1.6189689090642352"/
<p y="2.719325014597037"/
<p y="-0.8212759665434572"/
<p y="1.5913113756050552"/
<p y="-0.679814252403842"/
<p y="1.331596254095195"/
<p y="1.2008147701814793"/
<p y="-1.5528623948561628"/
<p y="-0.20470803967914872"/
<p y="-2.681553373360634"/
<p y="1.842865168212939"/
<p y="0.2623894647356427"/
<p y="4.450050634115584"/
<p y="0.0680372584049726"/
<p y="-1.3124978693928597"/
<p y="1.5114587067591583"/
<p y="-0.022866749353735488"/
<p y="-2.2058372795342236"/
<p y="0.40055348033557353"/
<p y="-0.7137026551871144"/
<p y="-2.2631833931087213"/
<p y="-0.8560247349955906"/
<p y="1.4448784687691667"/
<p y="1.6849341569286476"/
<p y="-2.057673675554518"/
<p y="-0.49460957314697435"/
<p y="1.8643272461097757"/
<p y="-1.785598566894081"/
<p y="-1.0687946989582089"/
<p y="-0.9054780403105006"/
<p y="-3.027230524091633"/
<p y="-3.733539504717435"/
<p y="-0.40073001568563227"/
<p y="-0.25123379396850337"/
<p y="-1.6527848475127012"/
<p y="0.5785274921626787"/
<p y="0.511504192908182"/
<p y="4.075156811845789"/
<p y="-1.2257533067253645"/
<p y="-2.68514840252569"/
<p y="-1.346791197135049"/
<p y="-1.638957833519461"/
<p y="-1.3205639611741722"/
<p y="1.9282785633803576"/
<p y="0.6819484665693976"/
<p y="-3.5885487657780692"/
<p y="2.510952623408573"/
<p y="-1.425555831551703"/
<p y="-0.24587170836307295"/
<p y="-0.2386318175410709"/
<p y="1.7450578596442852"/
<p y="3.457923728832094"/
<p y="-0.8911758425530169"/
<p y="-0.5604648983701896"/
<p y="1.8000549973153113"/
<p y="-1.4075875000718379"/
<p y="-1.1089777533561147"/
<p y="-2.9883322352797714"/
<p y="0.7315309072428813"/
<p y="-1.0143892815807367"/
<p y="-2.8924911942775466"/
</dataset>
</plot>
}

test Histogram-2.1 {Read in an old format file} {
    global histogramfile1
    histogramTest $histogramfile1
} {<?xml version="1.0" standalone="no"?>
<!DOCTYPE plot SYSTEM "Usually, the DTD would go here">
<plot>
<!-- Ptolemy plot, version 3.1, PlotML format. -->
<title>Sample histogram</title>
<xLabel>values</xLabel>
<yLabel>count</yLabel>
<yRange min="0.0" max="100.0"/>
<barGraph width="0.5" offset="0.15"/>
<bin width="1.0 offset="0.5">
<dataset name="first">
<p y="5.0"/
<p y="4.9999013042806855"/
<p y="4.99960522101908"/
</dataset>
</plot>
}

test Histogram-3.1 {Read in an old format file} {
    global histogramfile1
    jdkCapture {histogramTest -help} results
    set results
} {}
