model HeatingNPN_OrGate "Heating NPN Or Gate"
   extends Modelica.Icons.Example;
   constant Real CapVal=0;
   annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Text(extent={{-100.,100.},{-6.,72.}},textString="Heating NPN Nand Gate",fillColor={0,0,255})}));
   Modelica.Thermal.HeatTransfer.HeatCapacitor HeatCapacitor1(C=0.1) annotation (Placement(transformation(x=76.,y=-84.,scale=0.1,aspectRatio=1.,rotation=180),iconTransformation(x=76.,y=-84.,scale=0.1,aspectRatio=1.,rotation=180)));
   Modelica.Thermal.HeatTransfer.ThermalConductor TC1(G=0.01) annotation (Placement(transformation(x=90.,y=-50.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=90.,y=-50.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Thermal.HeatTransfer.ThermalConductor TC2(G=0.01) annotation (Placement(transformation(x=60.,y=-50.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=60.,y=-50.,scale=0.1,aspectRatio=1.,rotation=270)));
   annotation (Documentation(info="<HTML>
 <P>
 The heating NPN nand gate shows a heat flow always if a transistor is leading.
 </P>
 <P>
 Simulate until T=200 s.
 </P>
 <P>
 Plot in separate windows:<br> <br>
 V1.v and V2.v and C2.v <br>
 HeatCapacitor1.port.T and T1.heatPort.T and T2.heatPort.T<br>
 T1.heatPort.Q_flow and T2.heatPort.Q_flow<br>
 </P>
 <p><b>Release Notes:</b></p>
 <ul>
 <li><i>Mai 6, 2004   </i>
        by Christoph Clauss<br> realized<br>
        </li>
 </ul>
 </HTML>
 "),experiment(StopTime=200));
   Modelica.Electrical.Analog.Sources.RampVoltage V(V=6,duration=5) annotation (Placement(transformation(x=90.,y=38.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=90.,y=38.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Electrical.Analog.Sources.TrapezoidVoltage V1(V=6,startTime=55,rising=5,width=15,falling=5,period=50,nperiod=10) annotation (Placement(transformation(x=-90.,y=18.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=-90.,y=18.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Electrical.Analog.Sources.TrapezoidVoltage V2(V=6,startTime=65,rising=5,width=15,falling=5,period=50,nperiod=10) annotation (Placement(transformation(x=-50.,y=-42.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=-50.,y=-42.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Electrical.Analog.Basic.Resistor R1(R=1800) annotation (Placement(transformation(x=-80.,y=58.,scale=0.1,aspectRatio=1.),iconTransformation(x=-80.,y=58.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Resistor R2(R=1800) annotation (Placement(transformation(x=-26.,y=-12.,scale=0.1,aspectRatio=1.),iconTransformation(x=-26.,y=-12.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Resistor RI(R=40) annotation (Placement(transformation(x=70.,y=68.,scale=0.1,aspectRatio=1.),iconTransformation(x=70.,y=68.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Ground Gnd annotation (Placement(transformation(x=90.,y=10.,scale=0.1,aspectRatio=1.),iconTransformation(x=90.,y=10.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Ground Gnd1 annotation (Placement(transformation(x=-90.,y=-12.,scale=0.1,aspectRatio=1.),iconTransformation(x=-90.,y=-12.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Ground Gnd2 annotation (Placement(transformation(x=-50.,y=-72.,scale=0.1,aspectRatio=1.),iconTransformation(x=-50.,y=-72.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Ground Gnd3 annotation (Placement(transformation(x=0.,y=26.,scale=0.1,aspectRatio=1.),iconTransformation(x=0.,y=26.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Ground Gnd4 annotation (Placement(transformation(x=40.,y=-42.,scale=0.1,aspectRatio=1.),iconTransformation(x=40.,y=-42.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Capacitor C1(C=CapVal) annotation (Placement(transformation(x=-70.,y=38.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=-70.,y=38.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Electrical.Analog.Basic.Capacitor C2(C=CapVal) annotation (Placement(transformation(x=60.,y=42.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=60.,y=42.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Electrical.Analog.Basic.Capacitor C3(C=CapVal) annotation (Placement(transformation(x=-16.,y=-40.,scale=0.1,aspectRatio=1.,rotation=270),iconTransformation(x=-16.,y=-40.,scale=0.1,aspectRatio=1.,rotation=270)));
   Modelica.Electrical.Analog.Basic.Ground Gnd5 annotation (Placement(transformation(x=-16.,y=-66.,scale=0.1,aspectRatio=1.),iconTransformation(x=-16.,y=-66.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Ground Gnd6 annotation (Placement(transformation(x=60.,y=16.,scale=0.1,aspectRatio=1.),iconTransformation(x=60.,y=16.,scale=0.1,aspectRatio=1.)));
   Modelica.Electrical.Analog.Basic.Ground Gnd7 annotation (Placement(transformation(x=-70.,y=12.,scale=0.1,aspectRatio=1.),iconTransformation(x=-70.,y=12.,scale=0.1,aspectRatio=1.)));
   Semiconductors.HeatingNPN T1(Bf=100,Br=1,Is=1.e-14,Vak=0,Tauf=0,Taur=0,Ccs=CapVal,Cje=CapVal,Cjc=CapVal,Phie=1,Me=0.5,Phic=1,Mc=0.5,Gbc=1.e-12,Gbe=1.e-12,EMax=40) annotation (Placement(transformation(x=-10.,y=58.,scale=0.1,aspectRatio=1.),iconTransformation(x=-10.,y=58.,scale=0.1,aspectRatio=1.)));
   Semiconductors.HeatingNPN T2(Bf=100,Br=1,Is=1.e-14,Vak=0,Tauf=0,Taur=0,Ccs=CapVal,Cje=CapVal,Cjc=CapVal,Phie=1,Me=0.5,Phic=1,Mc=0.5,Gbc=1.e-12,Gbe=1.e-12,EMax=40) annotation (Placement(transformation(x=30.,y=-12.,scale=0.1,aspectRatio=1.),iconTransformation(x=30.,y=-12.,scale=0.1,aspectRatio=1.)));
   
equation
   connect(Gnd1.p, V1.n) annotation (Line(points={{-90.,-2.},{-90.,8.}},color={0,0,255}));
   connect(V1.p, R1.p) annotation (Line(points={{-90.,28.},{-90.,58.}},color={0,0,255}));
   connect(RI.n, V.p) annotation (Line(points={{80.,68.},{90.,68.},{90.,48.}},color={0,0,255}));
   connect(Gnd.p, V.n) annotation (Line(points={{90.,20.},{90.,28.}},color={0,0,255}));
   connect(V2.p, R2.p) annotation (Line(points={{-50.,-32.},{-50.,-12.},{-36.,-12.}},color={0,0,255}));
   connect(Gnd2.p, V2.n) annotation (Line(points={{-50.,-62.},{-50.,-52.}},color={0,0,255}));
   connect(Gnd7.p, C1.n) annotation (Line(points={{-70.,22.},{-70.,28.}},color={0,0,255}));
   connect(C2.p, RI.p) annotation (Line(points={{60.,52.},{60.,68.}},color={0,0,255}));
   connect(Gnd6.p, C2.n) annotation (Line(points={{60.,26.},{60.,32.}},color={0,0,255}));
   connect(C3.p, R2.n) annotation (Line(points={{-16.,-30.},{-16.,-21.},{-16.,-21.},{-16.,-12.}},color={0,0,255}));
   connect(C1.p, R1.n) annotation (Line(points={{-70.,48.},{-70.,58.}},color={0,0,255}));
   connect(Gnd5.p, C3.n) annotation (Line(points={{-16.,-56.},{-16.,-53.},{-16.,-50.},{-16.,-50.}},color={0,0,255}));
   connect(T1.B, R1.n) annotation (Line(points={{-20.,58.},{-70.,58.}},color={0,0,255}));
   connect(T1.E, Gnd3.p) annotation (Line(points={{0.,53.},{0.,36.}},color={0,0,255}));
   connect(RI.p, T1.C) annotation (Line(points={{60.,68.},{30.,68.},{30.,63.},{0.,63.}},color={0,0,255}));
   connect(T2.B, R2.n) annotation (Line(points={{20.,-12.},{-16.,-12.}},color={0,0,255}));
   connect(T2.E, Gnd4.p) annotation (Line(points={{40.,-17.},{40.,-32.}},color={0,0,255}));
   connect(T2.C, RI.p) annotation (Line(points={{40.,-7.},{40.,68.},{60.,68.}},color={0,0,255}));
   connect(TC1.port_b, HeatCapacitor1.port) annotation (Line(points={{90.,-61.},{84.,-61.},{84.,-74.},{76.,-74.}},color={191,0,0}));
   connect(TC2.port_b, HeatCapacitor1.port) annotation (Line(points={{60.,-61.},{68.,-61.},{68.,-74.},{76.,-74.}},color={191,0,0}));
   connect(TC2.port_a, T2.heatPort) annotation (Line(points={{60.,-39.},{60.,-22.},{30.,-22.}},color={191,0,0}));
   connect(TC1.port_a, T1.heatPort) annotation (Line(points={{90.,-39.},{90.,2.},{-10.,2.},{-10.,48.}},color={191,0,0}));
end HeatingNPN_OrGate;