/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import ptolemy.gui.CloseListener;

public class ComponentDialog
extends JDialog {
    public Component contents;
    protected String _buttonPressed = "";
    private static String[] _buttons;
    private static String[] _defaultButtons;
    private boolean _doneHandleClosing = false;
    private JOptionPane _optionPane;
    private JTextArea _messageArea;

    static {
        _defaultButtons = new String[]{"OK", "Cancel"};
    }

    public ComponentDialog(Frame owner, String title, Component component) {
        this(owner, title, component, null, null);
    }

    public ComponentDialog(Frame owner, String title, Component component, String[] buttons) {
        this(owner, title, component, buttons, null);
    }

    public ComponentDialog(Frame owner, String title, Component component, String[] buttons, String message) {
        super(owner, title, true);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (message != null) {
            this._messageArea = new JTextArea(message);
            this._messageArea.setFont(new Font("SansSerif", 0, 12));
            this._messageArea.setEditable(false);
            this._messageArea.setLineWrap(true);
            this._messageArea.setWrapStyleWord(true);
            this._messageArea.setBackground(this.getContentPane().getBackground());
            this._messageArea.setAlignmentX(0.0f);
            panel.add(this._messageArea);
            panel.add(Box.createRigidArea(new Dimension(0, 10)));
        }
        panel.add(component);
        this.contents = component;
        _buttons = buttons != null ? buttons : _defaultButtons;
        this._optionPane = new JOptionPane(panel, 3, 0, null, _buttons, _buttons[0]);
        this._optionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (ComponentDialog.this.isVisible() && e.getSource() == ComponentDialog.this._optionPane && (prop.equals("value") || prop.equals("inputValue"))) {
                    Object value = ComponentDialog.this._optionPane.getValue();
                    if (value == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    ComponentDialog.this._optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    if (value instanceof String) {
                        ComponentDialog.this._buttonPressed = (String)value;
                    }
                    ComponentDialog.this.setVisible(false);
                    ComponentDialog.this._handleClosing();
                }
            }
        });
        this.getContentPane().add(this._optionPane);
        this.pack();
        this.setResizable(false);
        if (owner != null) {
            this.setLocationRelativeTo(owner);
        } else {
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.setLocation((tk.getScreenSize().width - this.getSize().width) / 2, (tk.getScreenSize().height - this.getSize().height) / 2);
        }
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ComponentDialog.this._handleClosing();
            }
        });
        this.setVisible(true);
    }

    public String buttonPressed() {
        return this._buttonPressed;
    }

    public void setMessage(String message) {
        if (this._messageArea != null) {
            this._messageArea.setText(message);
        }
    }

    protected void _handleClosing() {
        if (this.contents instanceof CloseListener && !this._doneHandleClosing) {
            this._doneHandleClosing = true;
            ((CloseListener)((Object)this.contents)).windowClosed(this, this._buttonPressed);
        }
    }
}

