/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.demo;

import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplet;

public class PlotFourierSeries
extends PlotApplet {
    public String getAppletInfo() {
        return "PlotFourierSeries 1.1: Demo of PlotApplet.\nBy: Edward A. Lee\n ($Id: PlotFourierSeries.java,v 1.42 2005/04/25 22:48:54 cxh Exp $)";
    }

    public void init() {
        super.init();
        Plot plot = (Plot)this.plot();
        plot.setTitle("Fourier Series Approximation to a Square Wave");
        plot.setXRange(0.0, 400.0);
        plot.setMarksStyle("none");
        plot.addLegend(0, "ideal");
        plot.addLegend(1, "1 sinusoid");
        int j = 2;
        while (j <= 10) {
            plot.addLegend(j, String.valueOf(j) + " sinusoids");
            ++j;
        }
        boolean first = true;
        plot.addPoint(0, 0.0, 0.0, false);
        int i = 0;
        while (i <= 400) {
            double approximation = 0.0;
            int j2 = 1;
            while (j2 <= 10) {
                double sig = 4.0 * Math.sin((double)i * 2.0 * Math.PI * (double)(2 * j2 - 1) / 400.0) / (Math.PI * (double)(2 * j2 - 1));
                plot.addPoint(j2, i, approximation += sig, !first);
                ++j2;
            }
            first = false;
            if (i <= 200) {
                plot.addPoint(0, i, 1.0, true);
            }
            if (i >= 200) {
                plot.addPoint(0, i, -1.0, true);
            }
            ++i;
        }
        plot.addPoint(0, 400.0, 0.0, true);
    }
}

