#!/bin/bash

# modify variables to point to the actual location of your files
OPENMODELICAROOT=/home/william/openModelica/om-trunk/trunk
# OPENMODELICAROOT=/home/william/openModelica/OPENMODELICA_1_4_2
MICOHOME=/home/william/openModelica/mico-2.3.12
MICOVER=2.3.12

# modify to create different releases of the package
PACKAGENAME=openmodelica-1.4
VERSION=1.4.3
RELEASE=1
MYARCH=i386

# change to match your distribution
# fedora = Fedora Core
# suse = OpenSuse
MYDISTRO=fedora

# set to 1 to create a nightly build
nightlyBuild=1

# backup old .rpmmacros files
if [ -f ~/.rpmmacros ]; then
  mv ~/.rpmmacros ~/.rpmmacros.old
fi
cp resources/SPECS/rpmmacros ~/.rpmmacros
sed -i -e s/_VERSION_/"${VERSION}"/ ~/.rpmmacros
sed -i -e s/_DEVSUFFIX_/"${DEVSUFFIX}"/ ~/.rpmmacros

# set names
if [ $nightlyBuild == 1 ]; then
  PACKAGENAME=${PACKAGENAME}-dev
  DEVSUFFIX=-dev
else
  DEVSUFFIX=''
fi

# create the /tmp/openmodelica directory for the package
rm -rf /tmp/openmodelica/BUILD
rm -rf /tmp/openmodelica/RPMS
mkdir -p /tmp/openmodelica/BUILD
mkdir -p /tmp/openmodelica/RPMS

# /usr/bin directory
mkdir -p /tmp/openmodelica/BUILD/usr/bin
cp resources/script/* /tmp/openmodelica/BUILD/usr/bin
for fileName in "/tmp/openmodelica/BUILD/usr/bin/"* ; do
  sed -i -e s/_PACKAGENAME_/"${PACKAGENAME}"/ ${fileName}
  sed -i -e s/_VERSION_/"${VERSION}"/ ${fileName}
  sed -i -e s/_RELEASE_/"${RELEASE}"/ ${fileName}
  if [ ! -f "${fileName}${DEVSUFFIX}" ]; then
    mv ${fileName} "${fileName}${DEVSUFFIX}"
  fi ;
done

# /usr/lib directory
mkdir -p /tmp/openmodelica/BUILD/usr/lib/mico-${PACKAGENAME}
cp -P ${MICOHOME}/lib/libmico*.so /tmp/openmodelica/BUILD/usr/lib/mico-${PACKAGENAME}
chmod 644 /tmp/openmodelica/BUILD/usr/lib/mico-${PACKAGENAME}/libmico*.so
strip /tmp/openmodelica/BUILD/usr/lib/mico-${PACKAGENAME}/libmico*.so
cd /tmp/openmodelica/BUILD/usr/lib/mico-${PACKAGENAME}
ln -sf libmico${MICOVER}.so libmico.so
cd $OLDPWD

# /usr/share/applications
mkdir -p /tmp/openmodelica/BUILD/usr/share/applications
cp resources/menuitem/*.desktop /tmp/openmodelica/BUILD/usr/share/applications
for fileName in "/tmp/openmodelica/BUILD/usr/share/applications/"* ; do
  sed -i -e s/_VERSION_/"${VERSION}"/ ${fileName}
  sed -i -e s/_DEVSUFFIX_/"${DEVSUFFIX}"/ ${fileName}
done
if [ ! -z ${DEVSUFFIX} ]; then
  mv /tmp/openmodelica/BUILD/usr/share/applications/omnotebook.desktop \
    /tmp/openmodelica/BUILD/usr/share/applications/omnotebook${DEVSUFFIX}.desktop
  mv /tmp/openmodelica/BUILD/usr/share/applications/omshell.desktop \
    /tmp/openmodelica/BUILD/usr/share/applications/omshell${DEVSUFFIX}.desktop
fi

# /usr/share/icons
mkdir -p /tmp/openmodelica/BUILD/usr/share/icons
cp resources/menuitem/*.xpm /tmp/openmodelica/BUILD/usr/share/icons
if [ ! -z ${DEVSUFFIX} ]; then
  mv /tmp/openmodelica/BUILD/usr/share/icons/OMNotebook_icon.xpm \
    /tmp/openmodelica/BUILD/usr/share/icons/OMNotebook${DEVSUFFIX}_icon.xpm
  mv /tmp/openmodelica/BUILD/usr/share/icons/OMShell_icon.xpm \
    /tmp/openmodelica/BUILD/usr/share/icons/OMShell${DEVSUFFIX}_icon.xpm
fi

# /usr/share/man
mkdir -p /tmp/openmodelica/BUILD/usr/share/man/man1
cp resources/man/* /tmp/openmodelica/BUILD/usr/share/man/man1
for fileName in "/tmp/openmodelica/BUILD/usr/bin/"* ; do
  sed -i -e s/_DEVSUFFIX_/"${DEVSUFFIX}"/ ${fileName} ;
done
if [ ! -z ${DEVSUFFIX} ]; then
  mv /tmp/openmodelica/BUILD/usr/share/man/man1/omc.1 \
    /tmp/openmodelica/BUILD/usr/share/man/man1/omc${DEVSUFFIX}.1
  mv /tmp/openmodelica/BUILD/usr/share/man/man1/OMShell.1 \
    /tmp/openmodelica/BUILD/usr/share/man/man1/OMShell${DEVSUFFIX}.1
  mv /tmp/openmodelica/BUILD/usr/share/man/man1/OMNotebook.1 \
    /tmp/openmodelica/BUILD/usr/share/man/man1/OMNotebook${DEVSUFFIX}.1
fi
gzip --best /tmp/openmodelica/BUILD/usr/share/man/man1/*

# /usr/share/openmodelica
mkdir -p /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}
# omc
cp -r ${OPENMODELICAROOT}/build/* /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}
rm -f /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}/bin/*.bat
chmod 755 /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}/bin/doPlot
strip /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}/bin/omc
cp ${OPENMODELICAROOT}/OMNotebook/OMNotebookQT4/*.xml \
  /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}/bin

# OMShell
cp ${OPENMODELICAROOT}/OMShell/OMShell \
  /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}/bin
strip /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}/bin/OMShell

# OMNotebook
cp ${OPENMODELICAROOT}/OMNotebook/OMNotebookQT4/OMNotebook \
  /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}/bin
strip /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}/bin/OMNotebook

# remove .svn stuff
find /tmp/openmodelica/BUILD/usr/share/ -name '.svn' -type d -print | xargs rm -rf

# Modelica library
cp -r resources/modelica-2.2 /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}
cp -r resources/drmodelica /tmp/openmodelica/BUILD/usr/share/${PACKAGENAME}

# SPEC file
case $MYDISTRO in
  fedora) cp resources/SPECS/openmodelica.spec.fedora openmodelica.spec;;
  suse)   cp resources/SPECS/openmodelica.spec.suse openmodelica.spec;;
esac
sed -i -e s/_PACKAGENAME_/"${PACKAGENAME}"/ openmodelica.spec
sed -i -e s/_VERSION_/"${VERSION}"/ openmodelica.spec
sed -i -e s/_RELEASE_/"${RELEASE}"/ openmodelica.spec

# build the package and check it
rpmbuild -bb openmodelica.spec
if [ -f ~/.rpmmacros.old ]; then
  mv ~/.rpmmacros.old ~/.rpmmacros
fi

mkdir -p packages
mv `find /tmp/openmodelica/RPMS/* -name *.rpm` packages
rm openmodelica.spec
rpmlint packages/*.rpm