model Nand "CMOS NAND Gate (see Tietze/Schenk, page 157)"
   annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-50.,70.},{50.,-70.}},lineColor={0,0,0},fillColor={192,192,192},fillPattern=FillPattern.Solid),Ellipse(extent={{50.,5.},{60.,-5.}},lineColor={0,0,0},pattern=LinePattern.None),Text(extent={{-16.,50.},{14.,20.}},textString="&",fillColor={0,0,0}),Line(points={{60.,0.},{100.,0.}},color={0,0,255}),Line(points={{0.,70.},{0.,100.}},color={0,0,255}),Line(points={{-50.,50.},{-100.,50.}},color={0,0,255}),Line(points={{-50.,-50.},{-100.,-50.}},color={0,0,255}),Ellipse(extent={{50.,5.},{60.,-5.}},lineColor={0,0,0}),Text(extent={{-100.,34.},{-90.,24.}},textString="x1",fillColor={0,0,255}),Text(extent={{-100.,-65.},{-90.,-75.}},textString="x2",fillColor={0,0,255}),Text(extent={{90.,-15.},{100.,-25.}},textString="y",fillColor={0,0,255})}),Documentation(info="<html>
 <p>
 The nand gate is a basic CMOS building block. It consists of four CMOS transistors.
 <p>
 <dl>
 <dt>
 <b>Reference:</b>
 <dd>
 Tietze, U.; Schenk, Ch.: Halbleiter-Schaltungstechnik. Springer-Verlag Berlin Heidelberg NewYork 1980, p. 157
 <p>
 
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 
 <p>
 <dt>
 <b>Version:</b>
 <dd>
 $Id: Nand.mo,v 1.5 2003/10/31 11:12:06 SvenErik Exp $<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})));
   Semiconductors.PMOS TP1(W=6.5e-6,L=3.1e-6,Beta=0.0000105,Vt=-1,K2=0.41,K5=0.8385,dW=-2.5e-6,dL=-2.1e-6) annotation (Placement(transformation(x=20.,y=70.,scale=0.1,aspectRatio=1.),iconTransformation(x=20.,y=70.,scale=0.1,aspectRatio=1.)));
   Semiconductors.PMOS TP2(W=6.5e-6,L=3.1e-6,Beta=0.0000105,Vt=-1,K2=0.41,K5=0.8385,dW=-2.5e-6,dL=-2.1e-6) annotation (Placement(transformation(x=-30.,y=55.,scale=0.1,aspectRatio=1.),iconTransformation(x=-30.,y=55.,scale=0.1,aspectRatio=1.)));
   Semiconductors.NMOS TN1(W=6.5e-6,L=3.1e-6,Beta=0.000041,Vt=0.8,K2=1.144,K5=0.7311,dW=-2.5e-6,dL=-1.5e-6) annotation (Placement(transformation(x=20.,y=25.,scale=0.1,aspectRatio=1.),iconTransformation(x=20.,y=25.,scale=0.1,aspectRatio=1.)));
   Semiconductors.NMOS TN2(W=6.5e-6,L=3.1e-6,Beta=0.000041,Vt=0.8,K2=1.144,K5=0.7311,dW=-2.5e-6,dL=-1.5e-6) annotation (Placement(transformation(x=20.,y=-15.,scale=0.1,aspectRatio=1.),iconTransformation(x=20.,y=-15.,scale=0.1,aspectRatio=1.)));
   Basic.Capacitor C4(C=4.e-14) annotation (Placement(transformation(x=60.,y=30.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=60.,y=30.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Basic.Capacitor C7(C=4.e-14) annotation (Placement(transformation(x=55.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=55.,y=-50.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Basic.Ground Gnd annotation (Placement(transformation(x=45.,y=-20.,scale=0.05,aspectRatio=1.),iconTransformation(x=45.,y=-20.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd2 annotation (Placement(transformation(x=60.,y=5.,scale=0.05,aspectRatio=1.),iconTransformation(x=60.,y=5.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd3 annotation (Placement(transformation(x=55.,y=-75.,scale=0.05,aspectRatio=1.),iconTransformation(x=55.,y=-75.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd6 annotation (Placement(transformation(x=-10.,y=35.,scale=0.05,aspectRatio=1.),iconTransformation(x=-10.,y=35.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd7 annotation (Placement(transformation(x=45.,y=20.,scale=0.05,aspectRatio=1.),iconTransformation(x=45.,y=20.,scale=0.05,aspectRatio=1.)));
   Basic.Ground Gnd8 annotation (Placement(transformation(x=45.,y=65.,scale=0.05,aspectRatio=1.),iconTransformation(x=45.,y=65.,scale=0.05,aspectRatio=1.)));
   Interfaces.Pin x1 annotation (Placement(transformation(x=-100.,y=50.,scale=0.1,aspectRatio=1.),iconTransformation(x=-100.,y=50.,scale=0.1,aspectRatio=1.)));
   Interfaces.Pin x2 annotation (Placement(transformation(x=-100.,y=-50.,scale=0.1,aspectRatio=1.),iconTransformation(x=-100.,y=-50.,scale=0.1,aspectRatio=1.)));
   Interfaces.Pin Vdd annotation (Placement(transformation(x=0.,y=100.,scale=0.1,aspectRatio=1.),iconTransformation(x=0.,y=100.,scale=0.1,aspectRatio=1.)));
   Interfaces.Pin y annotation (Placement(transformation(x=100.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=100.,y=0.,scale=0.1,aspectRatio=1.)));
   
equation
   connect(TN1.S, TN2.D) annotation (Line(points={{30.,20.},{30.,-10.}},color={0,0,255}));
   connect(TN2.B, Gnd.p) annotation (Line(points={{30.,-15.},{38.,-15.},{38.,-15.},{45.,-15.}},color={0,0,255}));
   connect(TN2.D, C7.p) annotation (Line(points={{30.,-10.},{55.,-10.},{55.,-40.}},color={0,0,255}));
   connect(TN2.S, Gnd.p) annotation (Line(points={{30.,-20.},{38.,-20.},{38.,-15.},{45.,-15.}},color={0,0,255}));
   connect(TP1.S, TN1.D) annotation (Line(points={{30.,65.},{30.,30.}},color={0,0,255}));
   connect(TP1.G, TN1.G) annotation (Line(points={{10.,65.},{10.,20.}},color={0,0,255}));
   connect(C4.n, Gnd2.p) annotation (Line(points={{60.,20.},{60.,10.}},color={0,0,255}));
   connect(C7.n, Gnd3.p) annotation (Line(points={{55.,-60.},{55.,-70.}},color={0,0,255}));
   connect(TP2.B, Gnd6.p) annotation (Line(points={{-20.,55.},{-10.,55.},{-10.,40.}},color={0,0,255}));
   connect(TN1.B, Gnd7.p) annotation (Line(points={{30.,25.},{45.,25.}},color={0,0,255}));
   connect(TP1.B, Gnd8.p) annotation (Line(points={{30.,70.},{45.,70.}},color={0,0,255}));
   connect(TP2.G, x1) annotation (Line(points={{-40.,50.},{-100.,50.}},color={0,0,255}));
   connect(TP2.G, TN2.G) annotation (Line(points={{-40.,50.},{-40.,-20.},{10.,-20.}},color={0,0,255}));
   connect(TN1.G, x2) annotation (Line(points={{10.,20.},{-70.,20.},{-70.,-50.},{-100.,-50.}},color={0,0,255}));
   connect(TP2.S, TN1.D) annotation (Line(points={{-20.,50.},{30.,50.},{30.,30.}},color={0,0,255}));
   connect(TN1.D, C4.p) annotation (Line(points={{30.,30.},{30.,50.},{60.,50.},{60.,40.}},color={0,0,255}));
   connect(Vdd, TP1.D) annotation (Line(points={{0.,100.},{0.,80.},{30.,80.},{30.,75.}},color={0,0,255}));
   connect(TP2.D, Vdd) annotation (Line(points={{-20.,60.},{-20.,80.},{0.,80.},{0.,100.}},color={0,0,255}));
   connect(C4.p, y) annotation (Line(points={{60.,40.},{60.,50.},{80.,50.},{80.,0.},{100.,0.}},color={0,0,255}));
end Nand;