/* $ANTLR 2.7.4: "parser.g" -> "AntlrNotebookParser.cpp"$ */
#include "AntlrNotebookParser.hpp"
#include <antlr/NoViableAltException.hpp>
#include <antlr/SemanticException.hpp>
#include <antlr/ASTFactory.hpp>
AntlrNotebookParser::AntlrNotebookParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,k)
{
}

AntlrNotebookParser::AntlrNotebookParser(ANTLR_USE_NAMESPACE(antlr)TokenBuffer& tokenBuf)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(tokenBuf,2)
{
}

AntlrNotebookParser::AntlrNotebookParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer, int k)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,k)
{
}

AntlrNotebookParser::AntlrNotebookParser(ANTLR_USE_NAMESPACE(antlr)TokenStream& lexer)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(lexer,2)
{
}

AntlrNotebookParser::AntlrNotebookParser(const ANTLR_USE_NAMESPACE(antlr)ParserSharedInputState& state)
: ANTLR_USE_NAMESPACE(antlr)LLkParser(state,2)
{
}

void AntlrNotebookParser::document() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST document_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		expr();
		astFactory->addASTChild( currentAST, returnAST );
		document_AST = currentAST.root;
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_0);
	}
	returnAST = document_AST;
}

void AntlrNotebookParser::expr() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST expr_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case MODULENAME:
		case LIST:
		case LIST_SMALL:
		case NOTEBOOK:
		case CELL:
		case TEXTDATA:
		case CELLGROUPDATA:
		case GRAYLEVEL:
		case RGBCOLOR:
		case FILENAME:
		case STYLEBOX:
		case STYLEDATA:
		case BOXDATA:
		case BUTTONBOX:
		case FORMBOX:
		case ROWBOX:
		case GRIDBOX:
		case TAGBOX:
		case COUNTERBOX:
		case ADJUSTMENTBOX:
		case SUPERSCRBOX:
		case SUBSCRBOX:
		case SUBSUPERSCRIPTBOX:
		case UNDERSCRIPTBOX:
		case OVERSCRIPTBOX:
		case UNDEROVERSCRIPTBOX:
		case FRACTIONBOX:
		case SQRTBOX:
		case RADICALBOX:
		case INTERPRETATIONBOX:
		case ANNOTATION:
		case EQUAL:
		case DIAGRAM:
		case ICON:
		case POLYGON:
		case ELLIPSE:
		case LINE:
		case DIREXTEDINFINITY:
		case NOT_MATH_STARTMODELEDITOR:
		case NOT_MATH_OLEDATE:
		case GRAPHICSDATA:
		case PARENTDIRECTORY:
		{
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == MODULENAME)) {
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp1_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
					tmp1_AST = astFactory->create(LT(1));
					astFactory->addASTChild(currentAST, tmp1_AST);
					match(MODULENAME);
					ANTLR_USE_NAMESPACE(antlr)RefAST tmp2_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
					tmp2_AST = astFactory->create(LT(1));
					astFactory->addASTChild(currentAST, tmp2_AST);
					match(THICK);
				}
				else {
					goto _loop4;
				}
				
			}
			_loop4:;
			} // ( ... )*
			exprheader();
			astFactory->addASTChild( currentAST, returnAST );
			expr_AST = currentAST.root;
			break;
		}
		case VALUERIGHT:
		case VALUELEFT:
		case VALUECENTER:
		case VALUESMALLER:
		case INHERITED:
		case PAPERWIDTH:
		case WINDOWWIDTH:
		case TRUE_:
		case FALSE_:
		case AUTOMATIC:
		case TRADITIONALFORM:
		case STANDARDFORM:
		case INPUTFORM:
		case OUTPUTFORM:
		case DEFAULTINPUTFORMATTYPE:
		case NULLSYM:
		case NONESYM:
		case ALLSYM:
		case NUMBER:
		case QSTRING:
		{
			value();
			astFactory->addASTChild( currentAST, returnAST );
			expr_AST = currentAST.root;
			break;
		}
		case FONTSLANT:
		case FONTSIZE:
		case FONTCOLOR:
		case FONTWEIGHT:
		case FONTFAMILY:
		case FONTVARIATIONS:
		case TEXTALIGNMENT:
		case TEXTJUSTIFICATION:
		case INITIALIZATIONCELL:
		case FORMATTYPE_TOKEN:
		case PAGEWIDTH:
		case PAGEHEADERS:
		case PAGEHEADERLINES:
		case PAGEFOOTERS:
		case PAGEFOOTERLINES:
		case PAGEBREAKBELOW:
		case PAGEBREAKWITHIN:
		case BOXMARGINS:
		case BOXBASELINESHIFT:
		case LINESPACING:
		case HYPHENATION:
		case ACTIVE_TOKEN:
		case VISIBLE_TOKEN:
		case EVALUATABLE:
		case BUTTONFUNCTION:
		case BUTTONDATA:
		case BUTTONEVALUATOR:
		case BUTTONSTYLE:
		case CHARACHTERENCODING:
		case SHOWSTRINGCHARACTERS:
		case SCREENRECTANGLE:
		case AUTOGENERATEDPACKAGE:
		case AUTOITALICWORDS:
		case INPUTAUTOREPLACEMENTS:
		case SCRIPTMINSIZE:
		case STYLEMEMULISTING:
		case COUNTERINCREMENTS:
		case COUNTERASSIGNMENTS:
		case PRIVATEEVALOPTIONS:
		case GROUPPAGEBREAKWITHIN:
		case DEFAULTFORMATTYPE:
		case NUMBERMARKS:
		case LINEBREAKADJUSTMENTS:
		case VISIOLINEFORMAT:
		case VISIOFILLFORMAT:
		case EXTENT:
		case NAMEPOSITION:
		case CELLTAGS:
		case CELLFRAME:
		case CELLFRAMECOLOR:
		case CELLFRAMELABELS:
		case CELLFRAMEMARGINS:
		case CELLFRAMELABELMARGINS:
		case CELLLABRLMARGINS:
		case CELLLABELPOSITIONING:
		case CELLMARGINS:
		case CELLDINGBAT:
		case CELLHORIZONTALSCROLL:
		case CELLOPEN:
		case CELLGENERATED:
		case SHOWCELLBRACKET:
		case SHOWCELLLABEL:
		case CELLBRACKETOPT:
		case EDITABLE:
		case BACKGROUNT:
		case CELLGROUPINGRULES:
		case WINDOWSIZE:
		case WINDOWMARGINS:
		case WINDOWFRAME:
		case WINDOWELEMENTS:
		case WINDOWTITLE:
		case WINDOWTOOLBARS:
		case WINDOWMOVEABLE:
		case WINDOWFLOATING:
		case WINDOWCLICKSELECT:
		case STYLEDEFINITIONS:
		case FRONTENDVERSION:
		case SCREENSTYLEENV:
		case PRINTINGSTYLEENV:
		case PRINTINGOPTIONS:
		case PRINTINGCOPIES:
		case PRINTINGPAGERANGE:
		case PRIVATEFONTOPTIONS:
		case IMAGESIZE:
		case IMAGEMARGINS:
		case IMAGEREGION:
		case IMAGERANGECACHE:
		case IMAGECACHE:
		case NOT_MATH_MODELEDITOR:
		case CELLAUTOOVRT:
		case MAGNIFICATION:
		case GENERATEDCELL:
		{
			attribute();
			astFactory->addASTChild( currentAST, returnAST );
			expr_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_1);
	}
	returnAST = expr_AST;
}

void AntlrNotebookParser::exprheader() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST exprheader_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case NOTEBOOK:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp3_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp3_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp3_AST);
			match(NOTEBOOK);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop7;
				}
				
			}
			_loop7:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case LIST:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp7_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp7_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp7_AST);
			match(LIST);
			match(LBRACK);
			{ // ( ... )*
			for (;;) {
				if ((_tokenSet_2.member(LA(1)))) {
					listbody();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop9;
				}
				
			}
			_loop9:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					listbody();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop11;
				}
				
			}
			_loop11:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case LIST_SMALL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp11_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp11_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp11_AST);
			match(LIST_SMALL);
			match(LBRACK);
			{ // ( ... )*
			for (;;) {
				if ((_tokenSet_2.member(LA(1)))) {
					listbody();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop13;
				}
				
			}
			_loop13:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_2.member(LA(2)))) {
					match(COMMA);
					listbody();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop15;
				}
				
			}
			_loop15:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop17;
				}
				
			}
			_loop17:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case CELL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp16_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp16_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp16_AST);
			match(CELL);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{
			if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
				match(COMMA);
				expr();
				astFactory->addASTChild( currentAST, returnAST );
			}
			else if ((LA(1) == RBRACK || LA(1) == COMMA) && (_tokenSet_1.member(LA(2)))) {
			}
			else {
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
			}
			
			}
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop20;
				}
				
			}
			_loop20:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case CELLGROUPDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp21_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp21_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp21_AST);
			match(CELLGROUPDATA);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{
			match(COMMA);
			{
			switch ( LA(1)) {
			case CELLGROUPOPEN:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp24_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				tmp24_AST = astFactory->create(LT(1));
				astFactory->addASTChild(currentAST, tmp24_AST);
				match(CELLGROUPOPEN);
				break;
			}
			case CELLGROUPCLOSED:
			{
				ANTLR_USE_NAMESPACE(antlr)RefAST tmp25_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
				tmp25_AST = astFactory->create(LT(1));
				astFactory->addASTChild(currentAST, tmp25_AST);
				match(CELLGROUPCLOSED);
				break;
			}
			default:
			{
				throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
			}
			}
			}
			}
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case TEXTDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp27_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp27_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp27_AST);
			match(TEXTDATA);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop24;
				}
				
			}
			_loop24:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop26;
				}
				
			}
			_loop26:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case STYLEBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp32_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp32_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp32_AST);
			match(STYLEBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop28;
				}
				
			}
			_loop28:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop30;
				}
				
			}
			_loop30:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case STYLEDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp37_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp37_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp37_AST);
			match(STYLEDATA);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop32;
				}
				
			}
			_loop32:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop34;
				}
				
			}
			_loop34:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case SUPERSCRBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp42_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp42_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp42_AST);
			match(SUPERSCRBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			match(COMMA);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case SUBSCRBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp46_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp46_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp46_AST);
			match(SUBSCRBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			match(COMMA);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case SUBSUPERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp50_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp50_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp50_AST);
			match(SUBSUPERSCRIPTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop36;
				}
				
			}
			_loop36:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop38;
				}
				
			}
			_loop38:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case UNDERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp55_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp55_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp55_AST);
			match(UNDERSCRIPTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop40;
				}
				
			}
			_loop40:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop42;
				}
				
			}
			_loop42:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case OVERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp60_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp60_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp60_AST);
			match(OVERSCRIPTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop44;
				}
				
			}
			_loop44:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop46;
				}
				
			}
			_loop46:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case UNDEROVERSCRIPTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp65_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp65_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp65_AST);
			match(UNDEROVERSCRIPTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop48;
				}
				
			}
			_loop48:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop50;
				}
				
			}
			_loop50:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case FRACTIONBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp70_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp70_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp70_AST);
			match(FRACTIONBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop52;
				}
				
			}
			_loop52:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop54;
				}
				
			}
			_loop54:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case SQRTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp75_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp75_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp75_AST);
			match(SQRTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop56;
				}
				
			}
			_loop56:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop58;
				}
				
			}
			_loop58:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case RADICALBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp80_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp80_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp80_AST);
			match(RADICALBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop60;
				}
				
			}
			_loop60:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop62;
				}
				
			}
			_loop62:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case ROWBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp85_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp85_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp85_AST);
			match(ROWBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop64;
				}
				
			}
			_loop64:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop66;
				}
				
			}
			_loop66:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case GRIDBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp90_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp90_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp90_AST);
			match(GRIDBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop68;
				}
				
			}
			_loop68:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop70;
				}
				
			}
			_loop70:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case FORMBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp95_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp95_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp95_AST);
			match(FORMBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop72;
				}
				
			}
			_loop72:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop74;
				}
				
			}
			_loop74:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case TAGBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp100_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp100_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp100_AST);
			match(TAGBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop76;
				}
				
			}
			_loop76:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop78;
				}
				
			}
			_loop78:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case COUNTERBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp105_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp105_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp105_AST);
			match(COUNTERBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop80;
				}
				
			}
			_loop80:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop82;
				}
				
			}
			_loop82:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case ADJUSTMENTBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp110_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp110_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp110_AST);
			match(ADJUSTMENTBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop84;
				}
				
			}
			_loop84:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop86;
				}
				
			}
			_loop86:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case BUTTONBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp115_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp115_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp115_AST);
			match(BUTTONBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop88;
				}
				
			}
			_loop88:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop90;
				}
				
			}
			_loop90:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case INTERPRETATIONBOX:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp120_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp120_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp120_AST);
			match(INTERPRETATIONBOX);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			match(COMMA);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case ANNOTATION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp124_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp124_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp124_AST);
			match(ANNOTATION);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop92;
				}
				
			}
			_loop92:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop94;
				}
				
			}
			_loop94:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case EQUAL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp129_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp129_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp129_AST);
			match(EQUAL);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop96;
				}
				
			}
			_loop96:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop98;
				}
				
			}
			_loop98:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case DIAGRAM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp134_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp134_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp134_AST);
			match(DIAGRAM);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop100;
				}
				
			}
			_loop100:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop102;
				}
				
			}
			_loop102:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case ICON:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp139_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp139_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp139_AST);
			match(ICON);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop104;
				}
				
			}
			_loop104:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop106;
				}
				
			}
			_loop106:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case POLYGON:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp144_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp144_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp144_AST);
			match(POLYGON);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop108;
				}
				
			}
			_loop108:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop110;
				}
				
			}
			_loop110:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case ELLIPSE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp149_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp149_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp149_AST);
			match(ELLIPSE);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop112;
				}
				
			}
			_loop112:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop114;
				}
				
			}
			_loop114:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case LINE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp154_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp154_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp154_AST);
			match(LINE);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop116;
				}
				
			}
			_loop116:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop118;
				}
				
			}
			_loop118:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case GRAYLEVEL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp159_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp159_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp159_AST);
			match(GRAYLEVEL);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop120;
				}
				
			}
			_loop120:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop122;
				}
				
			}
			_loop122:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case NOT_MATH_OLEDATE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp164_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp164_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp164_AST);
			match(NOT_MATH_OLEDATE);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop124;
				}
				
			}
			_loop124:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop126;
				}
				
			}
			_loop126:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case RGBCOLOR:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp169_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp169_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp169_AST);
			match(RGBCOLOR);
			match(LBRACK);
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp171_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp171_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp171_AST);
			match(NUMBER);
			match(COMMA);
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp173_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp173_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp173_AST);
			match(NUMBER);
			match(COMMA);
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp175_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp175_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp175_AST);
			match(NUMBER);
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case FILENAME:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp177_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp177_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp177_AST);
			match(FILENAME);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop128;
				}
				
			}
			_loop128:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop130;
				}
				
			}
			_loop130:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case BOXDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp182_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp182_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp182_AST);
			match(BOXDATA);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA) && (_tokenSet_3.member(LA(2)))) {
					match(COMMA);
					expr();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop132;
				}
				
			}
			_loop132:;
			} // ( ... )*
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
					astFactory->addASTChild( currentAST, returnAST );
				}
				else {
					goto _loop134;
				}
				
			}
			_loop134:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case GRAPHICSDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp187_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp187_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp187_AST);
			match(GRAPHICSDATA);
			match(LBRACK);
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp189_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp189_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp189_AST);
			match(QSTRING);
			match(COMMA);
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp191_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp191_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp191_AST);
			match(QSTRING);
			{ // ( ... )*
			for (;;) {
				if ((LA(1) == COMMA)) {
					match(COMMA);
					rule();
				}
				else {
					goto _loop136;
				}
				
			}
			_loop136:;
			} // ( ... )*
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case DIREXTEDINFINITY:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp194_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp194_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp194_AST);
			match(DIREXTEDINFINITY);
			match(LBRACK);
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp196_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp196_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp196_AST);
			match(NUMBER);
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case NOT_MATH_STARTMODELEDITOR:
		{
			match(NOT_MATH_STARTMODELEDITOR);
			match(LBRACK);
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		case PARENTDIRECTORY:
		{
			match(PARENTDIRECTORY);
			match(LBRACK);
			match(RBRACK);
			exprheader_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_1);
	}
	returnAST = exprheader_AST;
}

void AntlrNotebookParser::value() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST value_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case QSTRING:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp204_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp204_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp204_AST);
			match(QSTRING);
			value_AST = currentAST.root;
			break;
		}
		case NUMBER:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp205_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp205_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp205_AST);
			match(NUMBER);
			value_AST = currentAST.root;
			break;
		}
		case TRUE_:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp206_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp206_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp206_AST);
			match(TRUE_);
			value_AST = currentAST.root;
			break;
		}
		case FALSE_:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp207_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp207_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp207_AST);
			match(FALSE_);
			value_AST = currentAST.root;
			break;
		}
		case VALUERIGHT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp208_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp208_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp208_AST);
			match(VALUERIGHT);
			value_AST = currentAST.root;
			break;
		}
		case VALUELEFT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp209_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp209_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp209_AST);
			match(VALUELEFT);
			value_AST = currentAST.root;
			break;
		}
		case VALUECENTER:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp210_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp210_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp210_AST);
			match(VALUECENTER);
			value_AST = currentAST.root;
			break;
		}
		case VALUESMALLER:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp211_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp211_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp211_AST);
			match(VALUESMALLER);
			value_AST = currentAST.root;
			break;
		}
		case INHERITED:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp212_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp212_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp212_AST);
			match(INHERITED);
			value_AST = currentAST.root;
			break;
		}
		case PAPERWIDTH:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp213_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp213_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp213_AST);
			match(PAPERWIDTH);
			value_AST = currentAST.root;
			break;
		}
		case WINDOWWIDTH:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp214_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp214_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp214_AST);
			match(WINDOWWIDTH);
			value_AST = currentAST.root;
			break;
		}
		case TRADITIONALFORM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp215_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp215_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp215_AST);
			match(TRADITIONALFORM);
			value_AST = currentAST.root;
			break;
		}
		case STANDARDFORM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp216_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp216_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp216_AST);
			match(STANDARDFORM);
			value_AST = currentAST.root;
			break;
		}
		case INPUTFORM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp217_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp217_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp217_AST);
			match(INPUTFORM);
			value_AST = currentAST.root;
			break;
		}
		case OUTPUTFORM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp218_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp218_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp218_AST);
			match(OUTPUTFORM);
			value_AST = currentAST.root;
			break;
		}
		case DEFAULTINPUTFORMATTYPE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp219_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp219_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp219_AST);
			match(DEFAULTINPUTFORMATTYPE);
			value_AST = currentAST.root;
			break;
		}
		case AUTOMATIC:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp220_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp220_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp220_AST);
			match(AUTOMATIC);
			value_AST = currentAST.root;
			break;
		}
		case NONESYM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp221_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp221_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp221_AST);
			match(NONESYM);
			value_AST = currentAST.root;
			break;
		}
		case NULLSYM:
		{
			match(NULLSYM);
			value_AST = currentAST.root;
			break;
		}
		case ALLSYM:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp223_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp223_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp223_AST);
			match(ALLSYM);
			value_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_1);
	}
	returnAST = value_AST;
}

void AntlrNotebookParser::attribute() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST attribute_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case FONTSLANT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp224_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp224_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp224_AST);
			match(FONTSLANT);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTSIZE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp225_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp225_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp225_AST);
			match(FONTSIZE);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTCOLOR:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp226_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp226_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp226_AST);
			match(FONTCOLOR);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTWEIGHT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp227_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp227_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp227_AST);
			match(FONTWEIGHT);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTFAMILY:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp228_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp228_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp228_AST);
			match(FONTFAMILY);
			attribute_AST = currentAST.root;
			break;
		}
		case FONTVARIATIONS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp229_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp229_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp229_AST);
			match(FONTVARIATIONS);
			attribute_AST = currentAST.root;
			break;
		}
		case TEXTALIGNMENT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp230_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp230_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp230_AST);
			match(TEXTALIGNMENT);
			attribute_AST = currentAST.root;
			break;
		}
		case TEXTJUSTIFICATION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp231_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp231_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp231_AST);
			match(TEXTJUSTIFICATION);
			attribute_AST = currentAST.root;
			break;
		}
		case INITIALIZATIONCELL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp232_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp232_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp232_AST);
			match(INITIALIZATIONCELL);
			attribute_AST = currentAST.root;
			break;
		}
		case FORMATTYPE_TOKEN:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp233_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp233_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp233_AST);
			match(FORMATTYPE_TOKEN);
			attribute_AST = currentAST.root;
			break;
		}
		case PAGEWIDTH:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp234_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp234_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp234_AST);
			match(PAGEWIDTH);
			attribute_AST = currentAST.root;
			break;
		}
		case PAGEHEADERS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp235_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp235_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp235_AST);
			match(PAGEHEADERS);
			attribute_AST = currentAST.root;
			break;
		}
		case PAGEHEADERLINES:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp236_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp236_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp236_AST);
			match(PAGEHEADERLINES);
			attribute_AST = currentAST.root;
			break;
		}
		case PAGEFOOTERS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp237_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp237_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp237_AST);
			match(PAGEFOOTERS);
			attribute_AST = currentAST.root;
			break;
		}
		case PAGEFOOTERLINES:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp238_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp238_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp238_AST);
			match(PAGEFOOTERLINES);
			attribute_AST = currentAST.root;
			break;
		}
		case PAGEBREAKBELOW:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp239_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp239_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp239_AST);
			match(PAGEBREAKBELOW);
			attribute_AST = currentAST.root;
			break;
		}
		case PAGEBREAKWITHIN:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp240_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp240_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp240_AST);
			match(PAGEBREAKWITHIN);
			attribute_AST = currentAST.root;
			break;
		}
		case BOXMARGINS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp241_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp241_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp241_AST);
			match(BOXMARGINS);
			attribute_AST = currentAST.root;
			break;
		}
		case BOXBASELINESHIFT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp242_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp242_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp242_AST);
			match(BOXBASELINESHIFT);
			attribute_AST = currentAST.root;
			break;
		}
		case LINESPACING:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp243_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp243_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp243_AST);
			match(LINESPACING);
			attribute_AST = currentAST.root;
			break;
		}
		case HYPHENATION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp244_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp244_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp244_AST);
			match(HYPHENATION);
			attribute_AST = currentAST.root;
			break;
		}
		case ACTIVE_TOKEN:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp245_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp245_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp245_AST);
			match(ACTIVE_TOKEN);
			attribute_AST = currentAST.root;
			break;
		}
		case VISIBLE_TOKEN:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp246_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp246_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp246_AST);
			match(VISIBLE_TOKEN);
			attribute_AST = currentAST.root;
			break;
		}
		case EVALUATABLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp247_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp247_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp247_AST);
			match(EVALUATABLE);
			attribute_AST = currentAST.root;
			break;
		}
		case BUTTONFUNCTION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp248_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp248_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp248_AST);
			match(BUTTONFUNCTION);
			attribute_AST = currentAST.root;
			break;
		}
		case BUTTONDATA:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp249_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp249_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp249_AST);
			match(BUTTONDATA);
			attribute_AST = currentAST.root;
			break;
		}
		case BUTTONEVALUATOR:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp250_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp250_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp250_AST);
			match(BUTTONEVALUATOR);
			attribute_AST = currentAST.root;
			break;
		}
		case BUTTONSTYLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp251_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp251_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp251_AST);
			match(BUTTONSTYLE);
			attribute_AST = currentAST.root;
			break;
		}
		case CHARACHTERENCODING:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp252_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp252_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp252_AST);
			match(CHARACHTERENCODING);
			attribute_AST = currentAST.root;
			break;
		}
		case SHOWSTRINGCHARACTERS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp253_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp253_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp253_AST);
			match(SHOWSTRINGCHARACTERS);
			attribute_AST = currentAST.root;
			break;
		}
		case SCREENRECTANGLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp254_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp254_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp254_AST);
			match(SCREENRECTANGLE);
			attribute_AST = currentAST.root;
			break;
		}
		case AUTOGENERATEDPACKAGE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp255_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp255_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp255_AST);
			match(AUTOGENERATEDPACKAGE);
			attribute_AST = currentAST.root;
			break;
		}
		case AUTOITALICWORDS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp256_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp256_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp256_AST);
			match(AUTOITALICWORDS);
			attribute_AST = currentAST.root;
			break;
		}
		case INPUTAUTOREPLACEMENTS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp257_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp257_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp257_AST);
			match(INPUTAUTOREPLACEMENTS);
			attribute_AST = currentAST.root;
			break;
		}
		case SCRIPTMINSIZE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp258_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp258_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp258_AST);
			match(SCRIPTMINSIZE);
			attribute_AST = currentAST.root;
			break;
		}
		case STYLEMEMULISTING:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp259_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp259_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp259_AST);
			match(STYLEMEMULISTING);
			attribute_AST = currentAST.root;
			break;
		}
		case COUNTERINCREMENTS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp260_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp260_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp260_AST);
			match(COUNTERINCREMENTS);
			attribute_AST = currentAST.root;
			break;
		}
		case COUNTERASSIGNMENTS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp261_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp261_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp261_AST);
			match(COUNTERASSIGNMENTS);
			attribute_AST = currentAST.root;
			break;
		}
		case PRIVATEEVALOPTIONS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp262_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp262_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp262_AST);
			match(PRIVATEEVALOPTIONS);
			attribute_AST = currentAST.root;
			break;
		}
		case GROUPPAGEBREAKWITHIN:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp263_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp263_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp263_AST);
			match(GROUPPAGEBREAKWITHIN);
			attribute_AST = currentAST.root;
			break;
		}
		case DEFAULTFORMATTYPE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp264_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp264_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp264_AST);
			match(DEFAULTFORMATTYPE);
			attribute_AST = currentAST.root;
			break;
		}
		case NUMBERMARKS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp265_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp265_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp265_AST);
			match(NUMBERMARKS);
			attribute_AST = currentAST.root;
			break;
		}
		case LINEBREAKADJUSTMENTS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp266_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp266_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp266_AST);
			match(LINEBREAKADJUSTMENTS);
			attribute_AST = currentAST.root;
			break;
		}
		case VISIOLINEFORMAT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp267_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp267_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp267_AST);
			match(VISIOLINEFORMAT);
			attribute_AST = currentAST.root;
			break;
		}
		case VISIOFILLFORMAT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp268_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp268_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp268_AST);
			match(VISIOFILLFORMAT);
			attribute_AST = currentAST.root;
			break;
		}
		case EXTENT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp269_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp269_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp269_AST);
			match(EXTENT);
			attribute_AST = currentAST.root;
			break;
		}
		case NAMEPOSITION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp270_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp270_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp270_AST);
			match(NAMEPOSITION);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLTAGS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp271_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp271_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp271_AST);
			match(CELLTAGS);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLFRAME:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp272_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp272_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp272_AST);
			match(CELLFRAME);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLFRAMECOLOR:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp273_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp273_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp273_AST);
			match(CELLFRAMECOLOR);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLFRAMELABELS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp274_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp274_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp274_AST);
			match(CELLFRAMELABELS);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLFRAMEMARGINS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp275_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp275_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp275_AST);
			match(CELLFRAMEMARGINS);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLFRAMELABELMARGINS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp276_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp276_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp276_AST);
			match(CELLFRAMELABELMARGINS);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLLABRLMARGINS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp277_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp277_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp277_AST);
			match(CELLLABRLMARGINS);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLLABELPOSITIONING:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp278_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp278_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp278_AST);
			match(CELLLABELPOSITIONING);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLMARGINS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp279_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp279_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp279_AST);
			match(CELLMARGINS);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLDINGBAT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp280_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp280_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp280_AST);
			match(CELLDINGBAT);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLHORIZONTALSCROLL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp281_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp281_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp281_AST);
			match(CELLHORIZONTALSCROLL);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLOPEN:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp282_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp282_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp282_AST);
			match(CELLOPEN);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLGENERATED:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp283_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp283_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp283_AST);
			match(CELLGENERATED);
			attribute_AST = currentAST.root;
			break;
		}
		case SHOWCELLBRACKET:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp284_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp284_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp284_AST);
			match(SHOWCELLBRACKET);
			attribute_AST = currentAST.root;
			break;
		}
		case SHOWCELLLABEL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp285_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp285_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp285_AST);
			match(SHOWCELLLABEL);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLBRACKETOPT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp286_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp286_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp286_AST);
			match(CELLBRACKETOPT);
			attribute_AST = currentAST.root;
			break;
		}
		case EDITABLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp287_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp287_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp287_AST);
			match(EDITABLE);
			attribute_AST = currentAST.root;
			break;
		}
		case BACKGROUNT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp288_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp288_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp288_AST);
			match(BACKGROUNT);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLGROUPINGRULES:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp289_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp289_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp289_AST);
			match(CELLGROUPINGRULES);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWSIZE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp290_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp290_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp290_AST);
			match(WINDOWSIZE);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWMARGINS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp291_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp291_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp291_AST);
			match(WINDOWMARGINS);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWFRAME:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp292_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp292_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp292_AST);
			match(WINDOWFRAME);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWELEMENTS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp293_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp293_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp293_AST);
			match(WINDOWELEMENTS);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWTITLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp294_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp294_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp294_AST);
			match(WINDOWTITLE);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWTOOLBARS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp295_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp295_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp295_AST);
			match(WINDOWTOOLBARS);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWMOVEABLE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp296_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp296_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp296_AST);
			match(WINDOWMOVEABLE);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWFLOATING:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp297_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp297_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp297_AST);
			match(WINDOWFLOATING);
			attribute_AST = currentAST.root;
			break;
		}
		case WINDOWCLICKSELECT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp298_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp298_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp298_AST);
			match(WINDOWCLICKSELECT);
			attribute_AST = currentAST.root;
			break;
		}
		case STYLEDEFINITIONS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp299_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp299_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp299_AST);
			match(STYLEDEFINITIONS);
			attribute_AST = currentAST.root;
			break;
		}
		case FRONTENDVERSION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp300_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp300_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp300_AST);
			match(FRONTENDVERSION);
			attribute_AST = currentAST.root;
			break;
		}
		case SCREENSTYLEENV:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp301_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp301_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp301_AST);
			match(SCREENSTYLEENV);
			attribute_AST = currentAST.root;
			break;
		}
		case PRINTINGSTYLEENV:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp302_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp302_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp302_AST);
			match(PRINTINGSTYLEENV);
			attribute_AST = currentAST.root;
			break;
		}
		case PRINTINGOPTIONS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp303_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp303_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp303_AST);
			match(PRINTINGOPTIONS);
			attribute_AST = currentAST.root;
			break;
		}
		case PRINTINGCOPIES:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp304_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp304_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp304_AST);
			match(PRINTINGCOPIES);
			attribute_AST = currentAST.root;
			break;
		}
		case PRINTINGPAGERANGE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp305_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp305_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp305_AST);
			match(PRINTINGPAGERANGE);
			attribute_AST = currentAST.root;
			break;
		}
		case PRIVATEFONTOPTIONS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp306_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp306_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp306_AST);
			match(PRIVATEFONTOPTIONS);
			attribute_AST = currentAST.root;
			break;
		}
		case MAGNIFICATION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp307_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp307_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp307_AST);
			match(MAGNIFICATION);
			attribute_AST = currentAST.root;
			break;
		}
		case GENERATEDCELL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp308_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp308_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp308_AST);
			match(GENERATEDCELL);
			attribute_AST = currentAST.root;
			break;
		}
		case CELLAUTOOVRT:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp309_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp309_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp309_AST);
			match(CELLAUTOOVRT);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGESIZE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp310_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp310_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp310_AST);
			match(IMAGESIZE);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGEMARGINS:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp311_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp311_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp311_AST);
			match(IMAGEMARGINS);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGEREGION:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp312_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp312_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp312_AST);
			match(IMAGEREGION);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGERANGECACHE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp313_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp313_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp313_AST);
			match(IMAGERANGECACHE);
			attribute_AST = currentAST.root;
			break;
		}
		case IMAGECACHE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp314_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp314_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp314_AST);
			match(IMAGECACHE);
			attribute_AST = currentAST.root;
			break;
		}
		case NOT_MATH_MODELEDITOR:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp315_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp315_AST = astFactory->create(LT(1));
			astFactory->addASTChild(currentAST, tmp315_AST);
			match(NOT_MATH_MODELEDITOR);
			attribute_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_1);
	}
	returnAST = attribute_AST;
}

void AntlrNotebookParser::rule() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST rule_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		switch ( LA(1)) {
		case RULE:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp316_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp316_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp316_AST);
			match(RULE);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{
			match(COMMA);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			}
			match(RBRACK);
			rule_AST = currentAST.root;
			break;
		}
		case RULE_SMALL:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp320_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp320_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp320_AST);
			match(RULE_SMALL);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{
			match(COMMA);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			}
			match(RBRACK);
			rule_AST = currentAST.root;
			break;
		}
		case RULEDELAYED:
		{
			ANTLR_USE_NAMESPACE(antlr)RefAST tmp324_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
			tmp324_AST = astFactory->create(LT(1));
			astFactory->makeASTRoot(currentAST, tmp324_AST);
			match(RULEDELAYED);
			match(LBRACK);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			{
			match(COMMA);
			expr();
			astFactory->addASTChild( currentAST, returnAST );
			}
			match(RBRACK);
			rule_AST = currentAST.root;
			break;
		}
		default:
		{
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		}
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_4);
	}
	returnAST = rule_AST;
}

void AntlrNotebookParser::listbody() {
	returnAST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	ANTLR_USE_NAMESPACE(antlr)ASTPair currentAST;
	ANTLR_USE_NAMESPACE(antlr)RefAST listbody_AST = ANTLR_USE_NAMESPACE(antlr)nullAST;
	
	try {      // for error handling
		{
		if ((_tokenSet_3.member(LA(1)))) {
			expr();
			astFactory->addASTChild( currentAST, returnAST );
		}
		else if (((LA(1) >= RULE && LA(1) <= RULEDELAYED))) {
			rule();
			astFactory->addASTChild( currentAST, returnAST );
		}
		else {
			throw ANTLR_USE_NAMESPACE(antlr)NoViableAltException(LT(1), getFilename());
		}
		
		}
		listbody_AST = currentAST.root;
	}
	catch (ANTLR_USE_NAMESPACE(antlr)RecognitionException& ex) {
		reportError(ex);
		consume();
		consumeUntil(_tokenSet_4);
	}
	returnAST = listbody_AST;
}

void AntlrNotebookParser::initializeASTFactory( ANTLR_USE_NAMESPACE(antlr)ASTFactory& factory )
{
	factory.setMaxNodeType(176);
}
const char* AntlrNotebookParser::tokenNames[] = {
	"<0>",
	"EOF",
	"<2>",
	"NULL_TREE_LOOKAHEAD",
	"\"FrontEnd\"",
	"\"List\"",
	"\"list\"",
	"\"Notebook\"",
	"\"Cell\"",
	"\"TextData\"",
	"\"CellGroupData\"",
	"\"Rule\"",
	"\"rule\"",
	"\"RuleDelayed\"",
	"\"GrayLevel\"",
	"\"RGBColor\"",
	"\"FileName\"",
	"\"StyleBox\"",
	"\"StyleData\"",
	"\"BoxData\"",
	"\"ButtonBox\"",
	"\"FormBox\"",
	"\"RowBox\"",
	"\"GridBox\"",
	"\"TagBox\"",
	"\"CounterBox\"",
	"\"AdjustmentBox\"",
	"\"SuperscriptBox\"",
	"\"SubscriptBox\"",
	"\"SubsuperscriptBox\"",
	"\"UnderscriptBox\"",
	"\"OverscriptBox\"",
	"\"UnderoverscriptBox\"",
	"\"FractionBox\"",
	"\"SqrtBox\"",
	"\"RadicalBox\"",
	"\"InterpretationBox\"",
	"\"Annotation\"",
	"\"Equal\"",
	"\"Diagram\"",
	"\"Icon\"",
	"\"Polygon\"",
	"\"Ellipse\"",
	"\"Line\"",
	"\"DirectedInfinity\"",
	"\"StartModelEditor\"",
	"\"OLEData\"",
	"\"FontSlant\"",
	"\"FontSize\"",
	"\"FontColor\"",
	"\"FontWeight\"",
	"\"FontFamily\"",
	"\"FontVariations\"",
	"\"TextAlignment\"",
	"\"TextJustification\"",
	"\"InitializationCell\"",
	"\"FormatType\"",
	"\"PageWidth\"",
	"\"PageHeaders\"",
	"\"PageHeaderLines\"",
	"\"PageFooters\"",
	"\"PageFooterLines\"",
	"\"PageBreakBelow\"",
	"\"PageBreakWithin\"",
	"\"BoxMargins\"",
	"\"BoxBaselineShift\"",
	"\"LineSpacing\"",
	"\"Hyphenation\"",
	"\"Active\"",
	"\"Visible\"",
	"\"Evaluatable\"",
	"\"ButtonFunction\"",
	"\"ButtonData\"",
	"\"ButtonEvaluator\"",
	"\"ButtonStyle\"",
	"\"CharacterEncoding\"",
	"\"ShowStringCharacters\"",
	"\"ScreenRectangle\"",
	"\"AutoGeneratedPackage\"",
	"\"AutoItalicWords\"",
	"\"InputAutoReplacements\"",
	"\"ScriptMinSize\"",
	"\"StyleMenuListing\"",
	"\"CounterIncrements\"",
	"\"CounterAssignments\"",
	"\"PrivateEvaluationOptions\"",
	"\"GroupPageBreakWithin\"",
	"\"DefaultFormatType\"",
	"\"NumberMarks\"",
	"\"LinebreakAdjustments\"",
	"\"VisioLineFormat\"",
	"\"VisioFillFormat\"",
	"\"Extent\"",
	"\"NamePosition\"",
	"\"CellTags\"",
	"\"CellFrame\"",
	"\"CellFrameColor\"",
	"\"CellFrameLabels\"",
	"\"CellFrameMargins\"",
	"\"CellFrameLabelMargins\"",
	"\"CellLabelMargins\"",
	"\"CellLabelPositioning\"",
	"\"CellMargins\"",
	"\"CellDingbat\"",
	"\"CellHorizontalScrolling\"",
	"\"CellOpen\"",
	"\"GeneratedCell\"",
	"\"ShowCellBracket\"",
	"\"ShowCellLabel\"",
	"\"CellBracketOptions\"",
	"\"Editable\"",
	"\"Background\"",
	"\"CellGroupingRules\"",
	"\"WindowSize\"",
	"\"WindowMargins\"",
	"\"WindowFrame\"",
	"\"WindowElements\"",
	"\"WindowTitle\"",
	"\"WindowToolbars\"",
	"\"WindowMoveable\"",
	"\"WindowFloating\"",
	"\"WindowClickSelect\"",
	"\"StyleDefinitions\"",
	"\"FrontEndVersion\"",
	"\"ScreenStyleEnvironment\"",
	"\"PrintingStyleEnvironment\"",
	"\"PrintingOptions\"",
	"\"PrintingCopies\"",
	"\"PrintingPageRange\"",
	"\"PrivateFontOptions\"",
	"\"Open\"",
	"\"Closed\"",
	"\"Right\"",
	"\"Left\"",
	"\"Center\"",
	"\"Smaller\"",
	"\"Inherited\"",
	"\"PaperWidth\"",
	"\"WindowWidth\"",
	"\"True\"",
	"\"False\"",
	"\"Automatic\"",
	"\"TraditionalForm\"",
	"\"StandardForm\"",
	"\"InputForm\"",
	"\"OutputForm\"",
	"\"DefaultInputFormatType\"",
	"\"Null\"",
	"\"None\"",
	"\"All\"",
	"\"GraphicsData\"",
	"\"ImageSize\"",
	"\"ImageMargins\"",
	"\"ImageRegion\"",
	"\"ImageRangeCache\"",
	"\"ImageCache\"",
	"\"ModelEditor\"",
	"\"GenerateCell\"",
	"\"CellAutoOverwrite\"",
	"\"Magnification\"",
	"\"ParentDirectory\"",
	"RBRACK",
	"LBRACK",
	"RCURLY",
	"LCURLY",
	"COMMA",
	"THICK",
	"COMMENTSTART",
	"COMMENTEND",
	"NUMBER",
	"ID",
	"EXP",
	"DIGIT",
	"QSTRING",
	"WHITESPACE",
	"COMMENT",
	"GENERATEDCELL",
	0
};

const unsigned long AntlrNotebookParser::_tokenSet_0_data_[] = { 2UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// EOF 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_0(_tokenSet_0_data_,6);
const unsigned long AntlrNotebookParser::_tokenSet_1_data_[] = { 4294967282UL, 4294967295UL, 4294967295UL, 4294967295UL, 3758096371UL, 74275UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// EOF "FrontEnd" "List" "list" "Notebook" "Cell" "TextData" "CellGroupData" 
// "Rule" "rule" "RuleDelayed" "GrayLevel" "RGBColor" "FileName" "StyleBox" 
// "StyleData" "BoxData" "ButtonBox" "FormBox" "RowBox" "GridBox" "TagBox" 
// "CounterBox" "AdjustmentBox" "SuperscriptBox" "SubscriptBox" "SubsuperscriptBox" 
// "UnderscriptBox" "OverscriptBox" "UnderoverscriptBox" "FractionBox" 
// "SqrtBox" "RadicalBox" "InterpretationBox" "Annotation" "Equal" "Diagram" 
// "Icon" "Polygon" "Ellipse" "Line" "DirectedInfinity" "StartModelEditor" 
// "OLEData" "FontSlant" "FontSize" "FontColor" "FontWeight" "FontFamily" 
// "FontVariations" "TextAlignment" "TextJustification" "InitializationCell" 
// "FormatType" "PageWidth" "PageHeaders" "PageHeaderLines" "PageFooters" 
// "PageFooterLines" "PageBreakBelow" "PageBreakWithin" "BoxMargins" "BoxBaselineShift" 
// "LineSpacing" "Hyphenation" "Active" "Visible" "Evaluatable" "ButtonFunction" 
// "ButtonData" "ButtonEvaluator" "ButtonStyle" "CharacterEncoding" "ShowStringCharacters" 
// "ScreenRectangle" "AutoGeneratedPackage" "AutoItalicWords" "InputAutoReplacements" 
// "ScriptMinSize" "StyleMenuListing" "CounterIncrements" "CounterAssignments" 
// "PrivateEvaluationOptions" "GroupPageBreakWithin" "DefaultFormatType" 
// "NumberMarks" "LinebreakAdjustments" "VisioLineFormat" "VisioFillFormat" 
// "Extent" "NamePosition" "CellTags" "CellFrame" "CellFrameColor" "CellFrameLabels" 
// "CellFrameMargins" "CellFrameLabelMargins" "CellLabelMargins" "CellLabelPositioning" 
// "CellMargins" "CellDingbat" "CellHorizontalScrolling" "CellOpen" "GeneratedCell" 
// "ShowCellBracket" "ShowCellLabel" "CellBracketOptions" "Editable" "Background" 
// "CellGroupingRules" "WindowSize" "WindowMargins" "WindowFrame" "WindowElements" 
// "WindowTitle" "WindowToolbars" "WindowMoveable" "WindowFloating" "WindowClickSelect" 
// "StyleDefinitions" "FrontEndVersion" "ScreenStyleEnvironment" "PrintingStyleEnvironment" 
// "PrintingOptions" "PrintingCopies" "PrintingPageRange" "PrivateFontOptions" 
// "Right" "Left" "Center" "Smaller" "Inherited" "PaperWidth" "WindowWidth" 
// "True" "False" "Automatic" "TraditionalForm" "StandardForm" "InputForm" 
// "OutputForm" "DefaultInputFormatType" "Null" "None" "All" "GraphicsData" 
// "ImageSize" "ImageMargins" "ImageRegion" "ImageRangeCache" "ImageCache" 
// "ModelEditor" "CellAutoOverwrite" "Magnification" "ParentDirectory" 
// RBRACK COMMA NUMBER QSTRING GENERATEDCELL 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_1(_tokenSet_1_data_,12);
const unsigned long AntlrNotebookParser::_tokenSet_2_data_[] = { 4294967280UL, 4294967295UL, 4294967295UL, 4294967295UL, 3758096371UL, 74241UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// "FrontEnd" "List" "list" "Notebook" "Cell" "TextData" "CellGroupData" 
// "Rule" "rule" "RuleDelayed" "GrayLevel" "RGBColor" "FileName" "StyleBox" 
// "StyleData" "BoxData" "ButtonBox" "FormBox" "RowBox" "GridBox" "TagBox" 
// "CounterBox" "AdjustmentBox" "SuperscriptBox" "SubscriptBox" "SubsuperscriptBox" 
// "UnderscriptBox" "OverscriptBox" "UnderoverscriptBox" "FractionBox" 
// "SqrtBox" "RadicalBox" "InterpretationBox" "Annotation" "Equal" "Diagram" 
// "Icon" "Polygon" "Ellipse" "Line" "DirectedInfinity" "StartModelEditor" 
// "OLEData" "FontSlant" "FontSize" "FontColor" "FontWeight" "FontFamily" 
// "FontVariations" "TextAlignment" "TextJustification" "InitializationCell" 
// "FormatType" "PageWidth" "PageHeaders" "PageHeaderLines" "PageFooters" 
// "PageFooterLines" "PageBreakBelow" "PageBreakWithin" "BoxMargins" "BoxBaselineShift" 
// "LineSpacing" "Hyphenation" "Active" "Visible" "Evaluatable" "ButtonFunction" 
// "ButtonData" "ButtonEvaluator" "ButtonStyle" "CharacterEncoding" "ShowStringCharacters" 
// "ScreenRectangle" "AutoGeneratedPackage" "AutoItalicWords" "InputAutoReplacements" 
// "ScriptMinSize" "StyleMenuListing" "CounterIncrements" "CounterAssignments" 
// "PrivateEvaluationOptions" "GroupPageBreakWithin" "DefaultFormatType" 
// "NumberMarks" "LinebreakAdjustments" "VisioLineFormat" "VisioFillFormat" 
// "Extent" "NamePosition" "CellTags" "CellFrame" "CellFrameColor" "CellFrameLabels" 
// "CellFrameMargins" "CellFrameLabelMargins" "CellLabelMargins" "CellLabelPositioning" 
// "CellMargins" "CellDingbat" "CellHorizontalScrolling" "CellOpen" "GeneratedCell" 
// "ShowCellBracket" "ShowCellLabel" "CellBracketOptions" "Editable" "Background" 
// "CellGroupingRules" "WindowSize" "WindowMargins" "WindowFrame" "WindowElements" 
// "WindowTitle" "WindowToolbars" "WindowMoveable" "WindowFloating" "WindowClickSelect" 
// "StyleDefinitions" "FrontEndVersion" "ScreenStyleEnvironment" "PrintingStyleEnvironment" 
// "PrintingOptions" "PrintingCopies" "PrintingPageRange" "PrivateFontOptions" 
// "Right" "Left" "Center" "Smaller" "Inherited" "PaperWidth" "WindowWidth" 
// "True" "False" "Automatic" "TraditionalForm" "StandardForm" "InputForm" 
// "OutputForm" "DefaultInputFormatType" "Null" "None" "All" "GraphicsData" 
// "ImageSize" "ImageMargins" "ImageRegion" "ImageRangeCache" "ImageCache" 
// "ModelEditor" "CellAutoOverwrite" "Magnification" "ParentDirectory" 
// NUMBER QSTRING GENERATEDCELL 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_2(_tokenSet_2_data_,12);
const unsigned long AntlrNotebookParser::_tokenSet_3_data_[] = { 4294952944UL, 4294967295UL, 4294967295UL, 4294967295UL, 3758096371UL, 74241UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// "FrontEnd" "List" "list" "Notebook" "Cell" "TextData" "CellGroupData" 
// "GrayLevel" "RGBColor" "FileName" "StyleBox" "StyleData" "BoxData" "ButtonBox" 
// "FormBox" "RowBox" "GridBox" "TagBox" "CounterBox" "AdjustmentBox" "SuperscriptBox" 
// "SubscriptBox" "SubsuperscriptBox" "UnderscriptBox" "OverscriptBox" 
// "UnderoverscriptBox" "FractionBox" "SqrtBox" "RadicalBox" "InterpretationBox" 
// "Annotation" "Equal" "Diagram" "Icon" "Polygon" "Ellipse" "Line" "DirectedInfinity" 
// "StartModelEditor" "OLEData" "FontSlant" "FontSize" "FontColor" "FontWeight" 
// "FontFamily" "FontVariations" "TextAlignment" "TextJustification" "InitializationCell" 
// "FormatType" "PageWidth" "PageHeaders" "PageHeaderLines" "PageFooters" 
// "PageFooterLines" "PageBreakBelow" "PageBreakWithin" "BoxMargins" "BoxBaselineShift" 
// "LineSpacing" "Hyphenation" "Active" "Visible" "Evaluatable" "ButtonFunction" 
// "ButtonData" "ButtonEvaluator" "ButtonStyle" "CharacterEncoding" "ShowStringCharacters" 
// "ScreenRectangle" "AutoGeneratedPackage" "AutoItalicWords" "InputAutoReplacements" 
// "ScriptMinSize" "StyleMenuListing" "CounterIncrements" "CounterAssignments" 
// "PrivateEvaluationOptions" "GroupPageBreakWithin" "DefaultFormatType" 
// "NumberMarks" "LinebreakAdjustments" "VisioLineFormat" "VisioFillFormat" 
// "Extent" "NamePosition" "CellTags" "CellFrame" "CellFrameColor" "CellFrameLabels" 
// "CellFrameMargins" "CellFrameLabelMargins" "CellLabelMargins" "CellLabelPositioning" 
// "CellMargins" "CellDingbat" "CellHorizontalScrolling" "CellOpen" "GeneratedCell" 
// "ShowCellBracket" "ShowCellLabel" "CellBracketOptions" "Editable" "Background" 
// "CellGroupingRules" "WindowSize" "WindowMargins" "WindowFrame" "WindowElements" 
// "WindowTitle" "WindowToolbars" "WindowMoveable" "WindowFloating" "WindowClickSelect" 
// "StyleDefinitions" "FrontEndVersion" "ScreenStyleEnvironment" "PrintingStyleEnvironment" 
// "PrintingOptions" "PrintingCopies" "PrintingPageRange" "PrivateFontOptions" 
// "Right" "Left" "Center" "Smaller" "Inherited" "PaperWidth" "WindowWidth" 
// "True" "False" "Automatic" "TraditionalForm" "StandardForm" "InputForm" 
// "OutputForm" "DefaultInputFormatType" "Null" "None" "All" "GraphicsData" 
// "ImageSize" "ImageMargins" "ImageRegion" "ImageRangeCache" "ImageCache" 
// "ModelEditor" "CellAutoOverwrite" "Magnification" "ParentDirectory" 
// NUMBER QSTRING GENERATEDCELL 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_3(_tokenSet_3_data_,12);
const unsigned long AntlrNotebookParser::_tokenSet_4_data_[] = { 4294967280UL, 4294967295UL, 4294967295UL, 4294967295UL, 3758096371UL, 74275UL, 0UL, 0UL, 0UL, 0UL, 0UL, 0UL };
// "FrontEnd" "List" "list" "Notebook" "Cell" "TextData" "CellGroupData" 
// "Rule" "rule" "RuleDelayed" "GrayLevel" "RGBColor" "FileName" "StyleBox" 
// "StyleData" "BoxData" "ButtonBox" "FormBox" "RowBox" "GridBox" "TagBox" 
// "CounterBox" "AdjustmentBox" "SuperscriptBox" "SubscriptBox" "SubsuperscriptBox" 
// "UnderscriptBox" "OverscriptBox" "UnderoverscriptBox" "FractionBox" 
// "SqrtBox" "RadicalBox" "InterpretationBox" "Annotation" "Equal" "Diagram" 
// "Icon" "Polygon" "Ellipse" "Line" "DirectedInfinity" "StartModelEditor" 
// "OLEData" "FontSlant" "FontSize" "FontColor" "FontWeight" "FontFamily" 
// "FontVariations" "TextAlignment" "TextJustification" "InitializationCell" 
// "FormatType" "PageWidth" "PageHeaders" "PageHeaderLines" "PageFooters" 
// "PageFooterLines" "PageBreakBelow" "PageBreakWithin" "BoxMargins" "BoxBaselineShift" 
// "LineSpacing" "Hyphenation" "Active" "Visible" "Evaluatable" "ButtonFunction" 
// "ButtonData" "ButtonEvaluator" "ButtonStyle" "CharacterEncoding" "ShowStringCharacters" 
// "ScreenRectangle" "AutoGeneratedPackage" "AutoItalicWords" "InputAutoReplacements" 
// "ScriptMinSize" "StyleMenuListing" "CounterIncrements" "CounterAssignments" 
// "PrivateEvaluationOptions" "GroupPageBreakWithin" "DefaultFormatType" 
// "NumberMarks" "LinebreakAdjustments" "VisioLineFormat" "VisioFillFormat" 
// "Extent" "NamePosition" "CellTags" "CellFrame" "CellFrameColor" "CellFrameLabels" 
// "CellFrameMargins" "CellFrameLabelMargins" "CellLabelMargins" "CellLabelPositioning" 
// "CellMargins" "CellDingbat" "CellHorizontalScrolling" "CellOpen" "GeneratedCell" 
// "ShowCellBracket" "ShowCellLabel" "CellBracketOptions" "Editable" "Background" 
// "CellGroupingRules" "WindowSize" "WindowMargins" "WindowFrame" "WindowElements" 
// "WindowTitle" "WindowToolbars" "WindowMoveable" "WindowFloating" "WindowClickSelect" 
// "StyleDefinitions" "FrontEndVersion" "ScreenStyleEnvironment" "PrintingStyleEnvironment" 
// "PrintingOptions" "PrintingCopies" "PrintingPageRange" "PrivateFontOptions" 
// "Right" "Left" "Center" "Smaller" "Inherited" "PaperWidth" "WindowWidth" 
// "True" "False" "Automatic" "TraditionalForm" "StandardForm" "InputForm" 
// "OutputForm" "DefaultInputFormatType" "Null" "None" "All" "GraphicsData" 
// "ImageSize" "ImageMargins" "ImageRegion" "ImageRangeCache" "ImageCache" 
// "ModelEditor" "CellAutoOverwrite" "Magnification" "ParentDirectory" 
// RBRACK COMMA NUMBER QSTRING GENERATEDCELL 
const ANTLR_USE_NAMESPACE(antlr)BitSet AntlrNotebookParser::_tokenSet_4(_tokenSet_4_data_,12);


