/*!  \file parser.g
* \author Ingemar Axelsson
* \brief Describes a grammar for notebooks.
* 
* This file contains a grammar describing a part of the notebook file 
* format. The parser mostly builds a ast. This ast is traversed by the 
* treeparser \see walker.g. 
*
* The parser has a lookahead of 2. This should be sufficient.
*
* \todo Check the grammar. It is certainly not completley correct, see
*  the mathematica documentation to find rules and attributes that is not
*  taken care of. This must be done eventually
*
* \todo It must be easy to make extensions to the grammar. Therefore a
*  correct grammar should be used. But I do not have time to verify that
*  it is completly correct. I stop when it works for most of the files.
*/


header "pre_include_hpp"{

}

header "post_include_hpp"{

}

options
{
    language="Cpp";     //Generate C++ languages.
    genHashLines=false; //Do not generate hashlines.
}

class AntlrNotebookParser extends Parser;
options
{
    k=2;
    importVocab = notebookgrammar;
    buildAST=true;
}

document      
    :   expr
    ;

expr
    : (MODULENAME THICK)* exprheader
    | value
    | attribute
    ;

exprheader
    : NOTEBOOK^      LBRACK! expr (COMMA! rule)* RBRACK!
    | LIST^          LBRACK! listbody (COMMA! listbody)* RBRACK!
    | CELL^          LBRACK! expr (COMMA! expr)? (COMMA! rule)* RBRACK!
    | CELLGROUPDATA^ LBRACK! expr (COMMA! (CELLGROUPOPEN|CELLGROUPCLOSED)) RBRACK!
    
    | TEXTDATA^      LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | STYLEBOX^      LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | SUPERSCRBOX^   LBRACK! expr COMMA! expr RBRACK! 
    | SUBSUPERSCRIPTBOX^ LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | UNDERSCRIPTBOX^ LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | OVERSCRIPTBOX^ LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | UNDEROVERSCRIPTBOX^ LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | FRACTIONBOX^   LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | SQRTBOX^       LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | RADICALBOX^    LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | BOXDATA^       LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | ROWBOX^        LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | FORMBOX^       LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | BUTTONBOX^     LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | GRAYLEVEL^     LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | RGBCOLOR^      LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | FILENAME^      LBRACK! expr (COMMA! expr)* (COMMA! rule)* RBRACK!
    | PARENTDIRECTORY! LBRACK! RBRACK!
    | GRAPHICSDATA! LBRACK! QSTRING! COMMA! QSTRING! (COMMA! rule!)* RBRACK!
    ;

listbody
    : (expr|rule)
    ;

rule
    : RULE^          LBRACK! expr (COMMA! expr)  RBRACK!
    | RULEDELAYED^   LBRACK! expr (COMMA! expr)  RBRACK!
    ;

value 
    : QSTRING
    | NUMBER
    | TRUE_
    | FALSE_
    | VALUERIGHT
    | VALUELEFT
    | TRADITIONALFORM
    | STANDARDFORM
    | INPUTFORM
    | OUTPUTFORM
    | AUTOMATIC
    | NONESYM
    | NULLSYM!
    ;

attribute
    :   FONTSLANT       
    |   FONTSIZE        
    |   FONTCOLOR       
    |   FONTWEIGHT      
    |   FONTFAMILY      
    |   FONTVARIATIONS  
    |   TEXTALIGNMENT   
    |   TEXTJUSTIFICATION
    |   INITIALIZATIONCELL
    |   BUTTONDATA      
    |   BUTTONSTYLE     
    |   CHARACHTERENCODING
    |   SCREENRECTANGLE 
    |   AUTOGENERATEDPACKAGE
    |   CELLTAGS
    |   CELLFRAME
    |   EDITABLE     
    |   BACKGROUNT   
    |   WINDOWSIZE     
    |   WINDOWMARGINS  
    |   WINDOWFRAME    
    |   WINDOWELEMENTS 
    |   WINDOWTITLE    
    |   WINDOWTOOLBARS 
    |   WINDOWMOVEABLE 
    |   WINDOWFLOATING 
    |   WINDOWCLICKSELECT
    |   STYLEDEFINITIONS
    |   FRONTENDVERSION 
    |   MAGNIFICATION
    |   GENERATEDCELL
    |   CELLAUTOOVRT
    |   IMAGESIZE
    |   IMAGEMARGINS     
    |   IMAGEREGION      
    |   IMAGERANGECACHE 
    |   IMAGECACHE      
    ;
