// Simulation code for RightHeartStarling generated by the OpenModelica Compiler.

using System;
using Physiome.Solvers;
namespace Physiome.Models
{
  public class RightHeartStarling : DAESystem
  {
  
    const int
      NHELP = 0, NG = 1,
      NX = 1, NY = 8, NP = 6,
      NO = 0, NI = 0, NR = 10,
      NEXT = 0, NYSTR = 0, NPSTR = 0;
      
    public override string ModelName  { get { return "RightHeartStarling"; }}
    public override int HelpVarsCount      { get { return NHELP; } }
    public override int ZeroCrossingsCount { get { return NG; } }
    public override int StatesCount        { get { return NX; } }
    public override int AlgebraicsCount    { get { return NY; } }
    public override int ParametersCount    { get { return NP; } }
    
    public override int OutputsCount   { get { return NO; } }
    public override int InputsCount    { get { return NI; } }
    public override int ResidualsCount { get { return NR; } }
    //public int ExternalObjectsCount { get { return NEXT; } }
    public override int MaximumOrder { get { return 5; } }
    public override int StringVarsCount { get { return NYSTR; } }
    public override int StringParametersCount { get { return NPSTR; } }
    
    public double volume { get { return states[0]; } set { states[0] = value; }}
    public double Der_volume { get { return statesDerivatives[0]; } set { statesDerivatives[0] = value; }}

    public double bloodFlow { get { return algebraics[0]; } set { algebraics[0] = value; }}
    public double Pre_bloodFlow { get { return savedAlgebraics[0]; } set { savedAlgebraics[0] = value; }}
    public double EDV { get { return algebraics[1]; } set { algebraics[1] = value; }}
    public double Pre_EDV { get { return savedAlgebraics[1]; } set { savedAlgebraics[1] = value; }}
    public double ESV { get { return algebraics[2]; } set { algebraics[2] = value; }}
    public double Pre_ESV { get { return savedAlgebraics[2]; } set { savedAlgebraics[2] = value; }}
    public double inflow { get { return algebraics[3]; } set { algebraics[3] = value; }}
    public double Pre_inflow { get { return savedAlgebraics[3]; } set { savedAlgebraics[3] = value; }}
    public double outflow { get { return algebraics[4]; } set { algebraics[4] = value; }}
    public double Pre_outflow { get { return savedAlgebraics[4]; } set { savedAlgebraics[4] = value; }}
    public double delta { get { return algebraics[5]; } set { algebraics[5] = value; }}
    public double Pre_delta { get { return savedAlgebraics[5]; } set { savedAlgebraics[5] = value; }}
    public double ventricleSteadyStateVolume { get { return algebraics[6]; } set { algebraics[6] = value; }}
    public double Pre_ventricleSteadyStateVolume { get { return savedAlgebraics[6]; } set { savedAlgebraics[6] = value; }}
    public double Pi { get { return algebraics[7]; } set { algebraics[7] = value; }}
    public double Pre_Pi { get { return savedAlgebraics[7]; } set { savedAlgebraics[7] = value; }}
    public double K { get { return parameters[0]; } set { parameters[0] = value; }}
    public double HR { get { return parameters[1]; } set { parameters[1] = value; }}
    public double PericardiumPressure { get { return parameters[2]; } set { parameters[2] = value; }}
    public double stiffnes { get { return parameters[3]; } set { parameters[3] = value; }}
    public double contractility { get { return parameters[4]; } set { parameters[4] = value; }}
    public double Po { get { return parameters[5]; } set { parameters[5] = value; }}
    
    private static readonly SimVarInfo[] VariableInfosStatic = new[] {
        new SimVarInfo( "volume", "average ventricle volume", SimVarType.State, 0, false),
        
        new SimVarInfo( "der(volume)", "average ventricle volume", SimVarType.StateDer, 0, false),
        
        new SimVarInfo( "bloodFlow", "", SimVarType.Algebraic, 0, false),
        new SimVarInfo( "EDV", "end diastolic volume", SimVarType.Algebraic, 1, false),
        new SimVarInfo( "ESV", "end systolic volume", SimVarType.Algebraic, 2, false),
        new SimVarInfo( "inflow", "", SimVarType.Algebraic, 3, false),
        new SimVarInfo( "outflow", "", SimVarType.Algebraic, 4, false),
        new SimVarInfo( "delta", "", SimVarType.Algebraic, 5, false),
        new SimVarInfo( "ventricleSteadyStateVolume", "", SimVarType.Algebraic, 6, false),
        new SimVarInfo( "Pi", "atrium pressure", SimVarType.Algebraic, 7, false),
        
        new SimVarInfo( "K", "time adaptation coeficient of average ventricle blood volume", SimVarType.Parameter, 0, true),
        new SimVarInfo( "HR", "heart rate", SimVarType.Parameter, 1, true),
        new SimVarInfo( "PericardiumPressure", "", SimVarType.Parameter, 2, true),
        new SimVarInfo( "stiffnes", "", SimVarType.Parameter, 3, true),
        new SimVarInfo( "contractility", "", SimVarType.Parameter, 4, true),
        new SimVarInfo( "Po", "artery pressure", SimVarType.Parameter, 5, true)
    };
    public override SimVarInfo[] VariableInfos { get { return VariableInfosStatic; } }
    
    private static readonly bool[] InitialFixedStatic = new bool[NX + NX + NY + NP] {
        //states
        true /* volume */,
        //derivatives
        true /* der(volume) */,
        //algebraics
        false /* bloodFlow */,
        false /* EDV */,
        false /* ESV */,
        false /* inflow */,
        false /* outflow */,
        false /* delta */,
        false /* ventricleSteadyStateVolume */,
        false /* Pi */,
        //parameters
        true /* K */,
        true /* HR */,
        true /* PericardiumPressure */,
        true /* stiffnes */,
        true /* contractility */,
        true /* Po */
    };
    public override bool[] InitialFixed { get { return InitialFixedStatic; } }
    
    public RightHeartStarling() {
        CreateData();
    }
    
    

    /* for continuous time variables */
    public override void FunDAEOutput()
    {
      bloodFlow = (HR * (EDV - ESV));
      // RELATION( delta < 0.0 ) macro expansion
      bool _tmp1 = delta < 0.0; if (!_tmp1 && isInUpdate && (delta <= 0.0)) { SwapOldVars(); double res1 = delta - 0.0;  SwapOldVars12(); _tmp1 = res1 <= (delta - 0.0); SwapOldVars2(); }
      double _tmp2;
      if (_tmp1) {
        _tmp2 = bloodFlow;
      } else {
        _tmp2 = (bloodFlow + delta);
      }
      inflow = _tmp2;
      outflow = (delta - inflow);
      Pi = time;
    }

    /* for discrete time variables */
    public override void FunDAEOutput2()
    {
      Pi = time;
    }

    public override void InputFun()
    {
    }

    public override void OutputFun()
    {
      /* not yet
      */
    }

    public override void FunZeroCrossing(double time, double[] x, double[] xd, double[] gout)
    {
      var timeBackup = this.time;
      this.time = time;
    
      FunODE();
      FunDAEOutput();
    
      {var _zen = zeroCrossingEnabled[0]; //ZEROCROSSING(0, Less(delta, 0.0));
      gout[0] = (_zen != 0) ? _zen * (delta-0.0) : 1.0; }
      
      this.time = timeBackup;
    }

    public override void FunHandleZeroCrossing(int index)
    {
      switch(index) {
        case 0:
          Pre_inflow = inflow; //save()
          break;
        default:
           break;
      }
    }

    public override void FunUpdateDependents()
    {
      //inUpdate=initial()?0:1;
      isInUpdate = ! isInit;
    
      ESV = (0.080251025206847 * (Math.Pow(((9.0 + Po) - PericardiumPressure), 2.0) * Math.Pow((1.0 / contractility), 2.0)));
      EDV = (62.0173672946042 * (Math.Pow((time - PericardiumPressure), 0.5) * Math.Pow((1.0 / stiffnes), 0.5)));
      ventricleSteadyStateVolume = ((EDV / 2.0) + (ESV / 2.0));
      delta = ((ventricleSteadyStateVolume - volume) * K);
      Der_volume = (delta / 60.0);
      bloodFlow = (HR * (EDV - ESV));
      // RELATION( delta < 0.0 ) macro expansion
      bool _tmp1 = delta < 0.0; if (!_tmp1 && isInUpdate && (delta <= 0.0)) { SwapOldVars(); double res1 = delta - 0.0;  SwapOldVars12(); _tmp1 = res1 <= (delta - 0.0); SwapOldVars2(); }
      double _tmp2;
      if (_tmp1) {
        _tmp2 = bloodFlow;
      } else {
        _tmp2 = (bloodFlow + delta);
      }
      inflow = _tmp2;
      outflow = (delta - inflow);
      
      isInUpdate = false;
    }

    public override void FunUpdateDepend()
    {
      isInUpdate = ! isInit;
    
      ESV = (0.080251025206847 * (Math.Pow(((9.0 + Po) - PericardiumPressure), 2.0) * Math.Pow((1.0 / contractility), 2.0)));
      EDV = (62.0173672946042 * (Math.Pow((time - PericardiumPressure), 0.5) * Math.Pow((1.0 / stiffnes), 0.5)));
      ventricleSteadyStateVolume = ((EDV / 2.0) + (ESV / 2.0));
      delta = ((ventricleSteadyStateVolume - volume) * K);
      Der_volume = (delta / 60.0);
      bloodFlow = (HR * (EDV - ESV));
      // RELATION( delta < 0.0 ) macro expansion
      bool _tmp1 = delta < 0.0; if (!_tmp1 && isInUpdate && (delta <= 0.0)) { SwapOldVars(); double res1 = delta - 0.0;  SwapOldVars12(); _tmp1 = res1 <= (delta - 0.0); SwapOldVars2(); }
      double _tmp2;
      if (_tmp1) {
        _tmp2 = bloodFlow;
      } else {
        _tmp2 = (bloodFlow + delta);
      }
      inflow = _tmp2;
      outflow = (delta - inflow);
      
      isInUpdate = false;
    }

    public override void FunOnlyZeroCrossings(double time, double[] gout) //TODO:??time in original is *t only ... how is it called?
    {
      {var _zen = zeroCrossingEnabled[0]; //ZEROCROSSING(0, Less(delta, 0.0));
      gout[0] = (_zen != 0) ? _zen * (delta-0.0) : 1.0; }
    }

    public override void FunStoreDelayed()
    {
    }

    public override void FunWhen(int i)
    {
      switch(i) {
        default:
          break;
      }
    }

    public override void FunODE()
    {
      ESV = (0.080251025206847 * (Math.Pow(((9.0 + Po) - PericardiumPressure), 2.0) * Math.Pow((1.0 / contractility), 2.0)));
      EDV = (62.0173672946042 * (Math.Pow((time - PericardiumPressure), 0.5) * Math.Pow((1.0 / stiffnes), 0.5)));
      ventricleSteadyStateVolume = ((EDV / 2.0) + (ESV / 2.0));
      delta = ((ventricleSteadyStateVolume - volume) * K);
      Der_volume = (delta / 60.0);
    }

    public override void InitialFun()
    {
      
      //if (sim_verbose) {
      //}
    }

    public override void InitialResidual()
    {
      int _i = 0;
    
      initialResiduals[_i++] = (bloodFlow - (HR * (EDV - ESV)));
      initialResiduals[_i++] = (EDV - (62.0173672946042 * (Math.Pow((time - PericardiumPressure), 0.5) * Math.Pow((1.0 / stiffnes), 0.5))));
      initialResiduals[_i++] = (ESV - (0.080251025206847 * (Math.Pow(((9.0 + Po) - PericardiumPressure), 2.0) * Math.Pow((1.0 / contractility), 2.0))));
      initialResiduals[_i++] = (ventricleSteadyStateVolume - ((EDV / 2.0) + (ESV / 2.0)));
      initialResiduals[_i++] = (delta - ((ventricleSteadyStateVolume - volume) * K));
      initialResiduals[_i++] = ((inflow + outflow) - delta);
      // RELATION( delta < 0.0 ) macro expansion
      bool _tmp1 = delta < 0.0; if (!_tmp1 && isInUpdate && (delta <= 0.0)) { SwapOldVars(); double res1 = delta - 0.0;  SwapOldVars12(); _tmp1 = res1 <= (delta - 0.0); SwapOldVars2(); }
      double _tmp2;
      if (_tmp1) {
        _tmp2 = bloodFlow;
      } else {
        _tmp2 = (bloodFlow + delta);
      }
      initialResiduals[_i++] = (inflow - _tmp2);
      initialResiduals[_i++] = (Der_volume - (delta / 60.0));
      initialResiduals[_i++] = (Pi - time);
      initialResiduals[_i++] = (volume - 95.7);
    }


    public override void BoundParameters()
    {
    }

    public override bool CheckForDiscreteVarChanges()
    {
      //var needToIterate = false;
    
      //edge(helpVars[i])
      
      //TODO: changeDiscreteVar(i) and to get the i from ComponentRef
      //if change()
      
      var _hvs = helpVars;
      var _shvs = savedHelpVars;
      for (int i = 0; i < _hvs.Length; i++) {
        //change(helpVars[i]) ?? TODO: not sure if it can be only 1.0 or 0.0
        if (_hvs[i] != _shvs[i])
          return true; //needToIterate=true;
      }
      
      return false; //needToIterate;
    }

  }
}