package SimCodeCSharp

protected constant Tpl.Text emptyTxt = Tpl.MEM_TEXT({}, {});

public import Tpl;

public import SimCode;
public import DAELow;
public import System;
public import Absyn;
public import DAE;
public import ClassInf;
public import Util;
public import Exp;

public function translateModel
  input Tpl.Text in_txt;
  input SimCode.SimCode in_i_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           (i_simCode as SimCode.SIMCODE(modelInfo = SimCode.MODELINFO(name = i_modelInfo_name))) )
      local
        String i_modelInfo_name;
        SimCode.SimCode i_simCode;
        Tpl.Text txt_1;
        Tpl.Text i_csFileContent;
      equation
        i_csFileContent = csFile(emptyTxt, i_simCode);
        txt_1 = Tpl.writeStr(emptyTxt, i_modelInfo_name);
        txt_1 = Tpl.writeTok(txt_1, Tpl.ST_STRING(".cs"));
        Tpl.textFile(i_csFileContent, Tpl.textString(txt_1));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end translateModel;

public function csFile
  input Tpl.Text in_txt;
  input SimCode.SimCode in_i_simCode;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_simCode)
    local
      Tpl.Text txt;

    case ( txt,
           (i_sc as SimCode.SIMCODE(modelInfo = (i_modelInfo as SimCode.MODELINFO(name = i_modelInfo_name)), nonStateContEquations = i_nonStateContEquations, removedEquations = i_removedEquations, nonStateDiscEquations = i_nonStateDiscEquations, zeroCrossings = i_zeroCrossings, zeroCrossingsNeedSave = i_zeroCrossingsNeedSave, allEquations = i_allEquations, helpVarInfo = (i_sc_helpVarInfo as i_helpVarInfo), whenClauses = i_whenClauses, stateContEquations = i_stateContEquations, initialEquations = i_initialEquations, residualEquations = i_residualEquations, parameterEquations = i_parameterEquations, discreteModelVars = i_sc_discreteModelVars)) )
      local
        list<DAE.ComponentRef> i_sc_discreteModelVars;
        list<SimCode.SimEqSystem> i_parameterEquations;
        list<SimCode.SimEqSystem> i_residualEquations;
        list<SimCode.SimEqSystem> i_initialEquations;
        list<SimCode.SimEqSystem> i_stateContEquations;
        list<SimCode.SimWhenClause> i_whenClauses;
        list<SimCode.HelpVarInfo> i_helpVarInfo;
        list<SimCode.HelpVarInfo> i_sc_helpVarInfo;
        list<SimCode.SimEqSystem> i_allEquations;
        list<list<SimCode.SimVar>> i_zeroCrossingsNeedSave;
        list<DAELow.ZeroCrossing> i_zeroCrossings;
        list<SimCode.SimEqSystem> i_nonStateDiscEquations;
        list<SimCode.SimEqSystem> i_removedEquations;
        list<SimCode.SimEqSystem> i_nonStateContEquations;
        String i_modelInfo_name;
        SimCode.ModelInfo i_modelInfo;
        SimCode.SimCode i_sc;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// Simulation code for "));
        txt = Tpl.writeStr(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " generated by the OpenModelica Compiler.\n",
                                    "\n",
                                    "using System;\n",
                                    "using Bodylight.Solvers;\n",
                                    "namespace Bodylight.Models\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public partial class "));
        txt = Tpl.writeStr(txt, i_modelInfo_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    " : DAESystem\n",
                                    "{\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = modelDataMembers(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionDaeOutput(txt, i_nonStateContEquations, i_removedEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionDaeOutput2(txt, i_nonStateDiscEquations, i_removedEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOutput(txt, i_modelInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionZeroCrossing(txt, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionHandleZeroCrossing(txt, i_zeroCrossingsNeedSave);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionUpdateDependents(txt, i_allEquations, i_helpVarInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionUpdateDepend(txt, i_allEquations, i_helpVarInfo);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOnlyZeroCrossing(txt, i_zeroCrossings);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionStoreDelayed(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionWhen(txt, i_whenClauses);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionOde(txt, i_stateContEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitial(txt, i_initialEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionInitialResidual(txt, i_residualEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionExtraResudials(txt, i_allEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionBoundParameters(txt, i_parameterEquations);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = functionCheckForDiscreteVarChanges(txt, i_sc_helpVarInfo, i_sc_discreteModelVars);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end csFile;

protected function lm_12
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, index = i_index) :: rest )
      local
        list<SimCode.SimVar> rest;
        Integer i_index;
        DAE.ComponentRef i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public double "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" { get { return states["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; } set { states["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = value; }}"));
        txt = Tpl.nextIter(txt);
        txt = lm_12(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_12(txt, rest);
      then txt;
  end matchcontinue;
end lm_12;

protected function lm_13
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, index = i_index) :: rest )
      local
        list<SimCode.SimVar> rest;
        Integer i_index;
        DAE.ComponentRef i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public double "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" { get { return statesDerivatives["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; } set { statesDerivatives["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = value; }}"));
        txt = Tpl.nextIter(txt);
        txt = lm_13(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_13(txt, rest);
      then txt;
  end matchcontinue;
end lm_13;

protected function lm_14
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, index = i_index) :: rest )
      local
        list<SimCode.SimVar> rest;
        Integer i_index;
        DAE.ComponentRef i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public double "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" { get { return algebraics["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; } set { algebraics["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "] = value; }}\n",
                                    "public double Pre_"
                                }, false));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" { get { return savedAlgebraics["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; } set { savedAlgebraics["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = value; }}"));
        txt = Tpl.nextIter(txt);
        txt = lm_14(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_14(txt, rest);
      then txt;
  end matchcontinue;
end lm_14;

protected function lm_15
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, index = i_index) :: rest )
      local
        list<SimCode.SimVar> rest;
        Integer i_index;
        DAE.ComponentRef i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public double "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" { get { return parameters["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; } set { parameters["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = value; }}"));
        txt = Tpl.nextIter(txt);
        txt = lm_15(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_15(txt, rest);
      then txt;
  end matchcontinue;
end lm_15;

protected function lm_16
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, comment = i_comment, index = i_index) :: rest )
      local
        list<SimCode.SimVar> rest;
        Integer i_index;
        String i_comment;
        DAE.ComponentRef i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("new SimVarInfo( \""));
        txt = crefSubscript(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", SimVarType.State, "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", false)"));
        txt = Tpl.nextIter(txt);
        txt = lm_16(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_16(txt, rest);
      then txt;
  end matchcontinue;
end lm_16;

protected function lm_17
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, comment = i_comment, index = i_index) :: rest )
      local
        list<SimCode.SimVar> rest;
        Integer i_index;
        String i_comment;
        DAE.ComponentRef i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("new SimVarInfo( \""));
        txt = crefSubscript(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", SimVarType.StateDer, "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", false)"));
        txt = Tpl.nextIter(txt);
        txt = lm_17(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_17(txt, rest);
      then txt;
  end matchcontinue;
end lm_17;

protected function lm_18
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, comment = i_comment, index = i_index) :: rest )
      local
        list<SimCode.SimVar> rest;
        Integer i_index;
        String i_comment;
        DAE.ComponentRef i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("new SimVarInfo( \""));
        txt = crefSubscript(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", SimVarType.Algebraic, "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", false)"));
        txt = Tpl.nextIter(txt);
        txt = lm_18(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_18(txt, rest);
      then txt;
  end matchcontinue;
end lm_18;

protected function lm_19
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name, comment = i_comment, index = i_index) :: rest )
      local
        list<SimCode.SimVar> rest;
        Integer i_index;
        String i_comment;
        DAE.ComponentRef i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("new SimVarInfo( \""));
        txt = crefSubscript(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", \""));
        txt = Tpl.writeStr(txt, i_comment);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", SimVarType.Parameter, "));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", true)"));
        txt = Tpl.nextIter(txt);
        txt = lm_19(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_19(txt, rest);
      then txt;
  end matchcontinue;
end lm_19;

protected function smf_20
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.Text i_it;
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_20;

protected function smf_21
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.Text i_it;
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_21;

protected function smf_22
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.Text i_it;
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_22;

protected function smf_23
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.Text i_it;
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_23;

protected function fun_24
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_i_vars_stateVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_vars_stateVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_vars_stateVars )
      local
        list<SimCode.SimVar> i_vars_stateVars;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//states\n"));
        txt = initFixed(txt, i_vars_stateVars);
      then txt;
  end matchcontinue;
end fun_24;

protected function fun_25
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_i_vars_derivativeVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_vars_derivativeVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_vars_derivativeVars )
      local
        list<SimCode.SimVar> i_vars_derivativeVars;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//derivatives\n"));
        txt = initFixed(txt, i_vars_derivativeVars);
      then txt;
  end matchcontinue;
end fun_25;

protected function fun_26
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_i_vars_algVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_vars_algVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_vars_algVars )
      local
        list<SimCode.SimVar> i_vars_algVars;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//algebraics\n"));
        txt = initFixed(txt, i_vars_algVars);
      then txt;
  end matchcontinue;
end fun_26;

protected function fun_27
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_i_vars_paramVars;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_vars_paramVars)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_vars_paramVars )
      local
        list<SimCode.SimVar> i_vars_paramVars;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("//parameters\n"));
        txt = initFixed(txt, i_vars_paramVars);
      then txt;
  end matchcontinue;
end fun_27;

protected function smf_28
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.Text i_it;
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_28;

protected function smf_29
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.Text i_it;
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_29;

protected function smf_30
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.Text i_it;
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_30;

protected function smf_31
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.Text i_it;
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_31;

public function modelDataMembers
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_i_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_modelInfo)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numHelpVars = i_varInfo_numHelpVars, numZeroCrossings = i_varInfo_numZeroCrossings, numStateVars = i_varInfo_numStateVars, numAlgVars = i_varInfo_numAlgVars, numParams = i_varInfo_numParams, numOutVars = i_varInfo_numOutVars, numInVars = i_varInfo_numInVars, numResiduals = i_varInfo_numResiduals, numExternalObjects = i_varInfo_numExternalObjects, numStringAlgVars = i_varInfo_numStringAlgVars, numStringParamVars = i_varInfo_numStringParamVars), vars = SimCode.SIMVARS(stateVars = i_vars_stateVars, derivativeVars = i_vars_derivativeVars, algVars = i_vars_algVars, paramVars = i_vars_paramVars), name = i_name) )
      local
        String i_name;
        list<SimCode.SimVar> i_vars_paramVars;
        list<SimCode.SimVar> i_vars_algVars;
        list<SimCode.SimVar> i_vars_derivativeVars;
        list<SimCode.SimVar> i_vars_stateVars;
        Integer i_varInfo_numStringParamVars;
        Integer i_varInfo_numStringAlgVars;
        Integer i_varInfo_numExternalObjects;
        Integer i_varInfo_numResiduals;
        Integer i_varInfo_numInVars;
        Integer i_varInfo_numOutVars;
        Integer i_varInfo_numParams;
        Integer i_varInfo_numAlgVars;
        Integer i_varInfo_numStateVars;
        Integer i_varInfo_numZeroCrossings;
        Integer i_varInfo_numHelpVars;
        Tpl.Text txt_7;
        Tpl.Text txt_6;
        Tpl.Text txt_5;
        Tpl.Text txt_4;
        Tpl.Text txt_3;
        Tpl.Text txt_2;
        Tpl.Text txt_1;
        Tpl.Text txt_0;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("const int\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NHELP = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numHelpVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", NG = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numZeroCrossings));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NX = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStateVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", NY = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", NP = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numParams));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NO = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numOutVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", NI = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numInVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", NR = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numResiduals));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ",\n",
                                    "NEXT = "
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numExternalObjects));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", NYSTR = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringAlgVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", NPSTR = "));
        txt = Tpl.writeStr(txt, intString(i_varInfo_numStringParamVars));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("public override string ModelName  { get { return \""));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\"; }}\n",
                                    "public override int HelpVarsCount      { get { return NHELP; } }\n",
                                    "public override int ZeroCrossingsCount { get { return NG; } }\n",
                                    "public override int StatesCount        { get { return NX; } }\n",
                                    "public override int AlgebraicsCount    { get { return NY; } }\n",
                                    "public override int ParametersCount    { get { return NP; } }\n",
                                    "\n",
                                    "public override int OutputsCount   { get { return NO; } }\n",
                                    "public override int InputsCount    { get { return NI; } }\n",
                                    "public override int ResidualsCount { get { return NR; } }\n",
                                    "//public int ExternalObjectsCount { get { return NEXT; } }\n",
                                    "public override int MaximumOrder { get { return 5; } }\n",
                                    "public override int StringVarsCount { get { return NYSTR; } }\n",
                                    "public override int StringParametersCount { get { return NPSTR; } }\n",
                                    "\n"
                                }, true));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_12(txt, i_vars_stateVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_13(txt, i_vars_derivativeVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_NEW_LINE());
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_14(txt, i_vars_algVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_15(txt, i_vars_paramVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "\n",
                                    "private static readonly SimVarInfo[] VariableInfosStatic = new[] {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt_0 = Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_0 = lm_16(txt_0, i_vars_stateVars);
        txt_0 = Tpl.popIter(txt_0);
        txt_1 = Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_1 = lm_17(txt_1, i_vars_derivativeVars);
        txt_1 = Tpl.popIter(txt_1);
        txt_2 = Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_2 = lm_18(txt_2, i_vars_algVars);
        txt_2 = Tpl.popIter(txt_2);
        txt_3 = Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt_3 = lm_19(txt_3, i_vars_paramVars);
        txt_3 = Tpl.popIter(txt_3);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_STRING_LIST({
                                                                   ",\n",
                                                                   "\n"
                                                               }, true)), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_20(txt, txt_0);
        txt = smf_21(txt, txt_1);
        txt = smf_22(txt, txt_2);
        txt = smf_23(txt, txt_3);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "public override SimVarInfo[] VariableInfos { get { return VariableInfosStatic; } }\n",
                                    "\n",
                                    "private static readonly bool[] InitialFixedStatic = new bool[NX + NX + NY + NP] {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt_4 = fun_24(emptyTxt, i_vars_stateVars);
        txt_5 = fun_25(emptyTxt, i_vars_derivativeVars);
        txt_6 = fun_26(emptyTxt, i_vars_algVars);
        txt_7 = fun_27(emptyTxt, i_vars_paramVars);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = smf_28(txt, txt_4);
        txt = smf_29(txt, txt_5);
        txt = smf_30(txt, txt_6);
        txt = smf_31(txt, txt_7);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "};\n",
                                    "public override bool[] InitialFixed { get { return InitialFixedStatic; } }\n",
                                    "\n",
                                    "public "
                                }, false));
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "() {\n",
                                    "    CreateData();\n",
                                    "}\n",
                                    "\n",
                                    "\n"
                                }, true));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end modelDataMembers;

protected function lm_33
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(isFixed = i_isFixed, name = i_name) :: rest )
      local
        list<SimCode.SimVar> rest;
        DAE.ComponentRef i_name;
        Boolean i_isFixed;
      equation
        txt = Tpl.writeStr(txt, Tpl.booleanString(i_isFixed));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" /* "));
        txt = crefSubscript(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" */"));
        txt = Tpl.nextIter(txt);
        txt = lm_33(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_33(txt, rest);
      then txt;
  end matchcontinue;
end lm_33;

public function initFixed
  input Tpl.Text txt;
  input list<SimCode.SimVar> i_simVarLst;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_33(out_txt, i_simVarLst);
  out_txt := Tpl.popIter(out_txt);
end initFixed;

protected function lm_35
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        SimCode.SimEqSystem i_it;
      equation
        txt = equation_(txt, i_it, SimCode.contextSimulationNonDiscrete);
        txt = Tpl.nextIter(txt);
        txt = lm_35(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_35(txt, rest);
      then txt;
  end matchcontinue;
end lm_35;

protected function lm_36
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        SimCode.SimEqSystem i_it;
      equation
        txt = equation_(txt, i_it, SimCode.contextSimulationNonDiscrete);
        txt = Tpl.nextIter(txt);
        txt = lm_36(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_36(txt, rest);
      then txt;
  end matchcontinue;
end lm_36;

public function functionDaeOutput
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> i_nonStateContEquations;
  input list<SimCode.SimEqSystem> i_removedEquations;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* for continuous time variables */\n",
                                   "public override void FunDAEOutput()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_35(out_txt, i_nonStateContEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_36(out_txt, i_removedEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionDaeOutput;

protected function lm_38
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        SimCode.SimEqSystem i_it;
      equation
        txt = equation_(txt, i_it, SimCode.contextSimulationDiscrete);
        txt = Tpl.nextIter(txt);
        txt = lm_38(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_38(txt, rest);
      then txt;
  end matchcontinue;
end lm_38;

protected function lm_39
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        SimCode.SimEqSystem i_it;
      equation
        txt = equation_(txt, i_it, SimCode.contextSimulationDiscrete);
        txt = Tpl.nextIter(txt);
        txt = lm_39(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_39(txt, rest);
      then txt;
  end matchcontinue;
end lm_39;

public function functionDaeOutput2
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> i_nonStateDiscEquations;
  input list<SimCode.SimEqSystem> i_removedEquations;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "/* for discrete time variables */\n",
                                   "public override void FunDAEOutput2()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_38(out_txt, i_nonStateDiscEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_39(out_txt, i_removedEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionDaeOutput2;

protected function lm_41
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      local
        list<SimCode.SimVar> rest;
        DAE.ComponentRef i_name;
        Integer i_i0;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = inputVars["));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("];"));
        txt = Tpl.nextIter(txt);
        txt = lm_41(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_41(txt, rest);
      then txt;
  end matchcontinue;
end lm_41;

public function functionInput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_i_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_modelInfo)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numHelpVars = _), vars = SimCode.SIMVARS(inputVars = i_vars_inputVars)) )
      local
        list<SimCode.SimVar> i_vars_inputVars;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "public override void InputFun()\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_41(txt, i_vars_inputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionInput;

protected function lm_43
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      local
        list<SimCode.SimVar> rest;
        DAE.ComponentRef i_name;
        Integer i_i0;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("outputVars["));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_43(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_43(txt, rest);
      then txt;
  end matchcontinue;
end lm_43;

public function functionOutput
  input Tpl.Text in_txt;
  input SimCode.ModelInfo in_i_modelInfo;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_modelInfo)
    local
      Tpl.Text txt;

    case ( txt,
           SimCode.MODELINFO(varInfo = SimCode.VARINFO(numHelpVars = _), vars = SimCode.SIMVARS(outputVars = i_vars_outputVars)) )
      local
        list<SimCode.SimVar> i_vars_outputVars;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "public override void OutputFun()\n",
                                    "{\n",
                                    "  /* not yet\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_43(txt, i_vars_outputVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("*/\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionOutput;

protected function lm_45
  input Tpl.Text in_txt;
  input list<DAELow.ZeroCrossing> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           DAELow.ZERO_CROSSING(relation_ = i_relation__) :: rest )
      local
        list<DAELow.ZeroCrossing> rest;
        DAE.Exp i_relation__;
        Integer i_i0;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        txt = zeroCrossing(txt, i_relation__, i_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_45(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<DAELow.ZeroCrossing> rest;
      equation
        txt = lm_45(txt, rest);
      then txt;
  end matchcontinue;
end lm_45;

public function functionZeroCrossing
  input Tpl.Text txt;
  input list<DAELow.ZeroCrossing> i_zeroCrossingLst;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunZeroCrossing(double time, double[] x, double[] xd, double[] gout)\n",
                                   "{\n",
                                   "  var timeBackup = this.time;\n",
                                   "  this.time = time;\n",
                                   "\n",
                                   "  FunODE();\n",
                                   "  FunDAEOutput();\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_45(out_txt, i_zeroCrossingLst);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "this.time = timeBackup;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionZeroCrossing;

protected function lm_47
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      local
        list<SimCode.SimVar> rest;
        DAE.ComponentRef i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre_"));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //save()"));
        txt = Tpl.nextIter(txt);
        txt = lm_47(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_47(txt, rest);
      then txt;
  end matchcontinue;
end lm_47;

protected function lm_48
  input Tpl.Text in_txt;
  input list<list<SimCode.SimVar>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_vars :: rest )
      local
        list<list<SimCode.SimVar>> rest;
        list<SimCode.SimVar> i_vars;
        Integer i_i0;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_47(txt, i_vars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break;"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_48(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<list<SimCode.SimVar>> rest;
      equation
        txt = lm_48(txt, rest);
      then txt;
  end matchcontinue;
end lm_48;

public function functionHandleZeroCrossing
  input Tpl.Text txt;
  input list<list<SimCode.SimVar>> i_zeroCrossingsNeedSave;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunHandleZeroCrossing(int index)\n",
                                   "{\n",
                                   "  switch(index) {\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_48(out_txt, i_zeroCrossingsNeedSave);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "default:\n",
                                       "   break;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  }\n",
                                       "}"
                                   }, false));
end functionHandleZeroCrossing;

protected function lm_50
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        SimCode.SimEqSystem i_it;
      equation
        txt = equation_(txt, i_it, SimCode.contextSimulationDiscrete);
        txt = Tpl.nextIter(txt);
        txt = lm_50(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_50(txt, rest);
      then txt;
  end matchcontinue;
end lm_50;

protected function lm_51
  input Tpl.Text in_txt;
  input list<SimCode.HelpVarInfo> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_in1, i_exp, _) :: rest )
      local
        list<SimCode.HelpVarInfo> rest;
        DAE.Exp i_exp;
        Integer i_in1;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_exp, SimCode.contextSimulationDiscrete, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("helpVars["));
        txt = Tpl.writeStr(txt, intString(i_in1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ? 1.0 : 0.0;"));
        txt = Tpl.nextIter(txt);
        txt = lm_51(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.HelpVarInfo> rest;
      equation
        txt = lm_51(txt, rest);
      then txt;
  end matchcontinue;
end lm_51;

public function functionUpdateDependents
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> i_allEquations;
  input list<SimCode.HelpVarInfo> i_helpVarInfoLst;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunUpdateDependents()\n",
                                   "{\n",
                                   "  //inUpdate=initial()?0:1;\n",
                                   "  isInUpdate = ! isInit;\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_50(out_txt, i_allEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_51(out_txt, i_helpVarInfoLst);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "isInUpdate = false;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateDependents;

protected function lm_53
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        SimCode.SimEqSystem i_it;
      equation
        txt = equation_(txt, i_it, SimCode.contextSimulationDiscrete);
        txt = Tpl.nextIter(txt);
        txt = lm_53(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_53(txt, rest);
      then txt;
  end matchcontinue;
end lm_53;

protected function lm_54
  input Tpl.Text in_txt;
  input list<SimCode.HelpVarInfo> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_in1, i_exp, _) :: rest )
      local
        list<SimCode.HelpVarInfo> rest;
        DAE.Exp i_exp;
        Integer i_in1;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_exp, SimCode.contextSimulationDiscrete, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("helpVars["));
        txt = Tpl.writeStr(txt, intString(i_in1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" ? 1.0 : 0.0;"));
        txt = Tpl.nextIter(txt);
        txt = lm_54(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.HelpVarInfo> rest;
      equation
        txt = lm_54(txt, rest);
      then txt;
  end matchcontinue;
end lm_54;

public function functionUpdateDepend
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> i_allEquations;
  input list<SimCode.HelpVarInfo> i_helpVarInfoLst;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunUpdateDepend()\n",
                                   "{\n",
                                   "  isInUpdate = ! isInit;\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_53(out_txt, i_allEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_54(out_txt, i_helpVarInfoLst);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "isInUpdate = false;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionUpdateDepend;

protected function lm_56
  input Tpl.Text in_txt;
  input list<DAELow.ZeroCrossing> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           DAELow.ZERO_CROSSING(relation_ = i_relation__) :: rest )
      local
        list<DAELow.ZeroCrossing> rest;
        DAE.Exp i_relation__;
        Integer i_i0;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        txt = zeroCrossing(txt, i_relation__, i_i0);
        txt = Tpl.nextIter(txt);
        txt = lm_56(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<DAELow.ZeroCrossing> rest;
      equation
        txt = lm_56(txt, rest);
      then txt;
  end matchcontinue;
end lm_56;

public function functionOnlyZeroCrossing
  input Tpl.Text txt;
  input list<DAELow.ZeroCrossing> i_zeroCrossingLst;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunOnlyZeroCrossings(double time, double[] gout) //TODO:??time in original is *t only ... how is it called?\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_56(out_txt, i_zeroCrossingLst);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionOnlyZeroCrossing;

protected function fun_58
  input Tpl.Text in_txt;
  input DAE.Operator in_i_operator;
  input Tpl.Text in_i_e2;
  input Tpl.Text in_i_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_operator, in_i_e2, in_i_e1)
    local
      Tpl.Text txt;
      Tpl.Text i_e2;
      Tpl.Text i_e1;

    case ( txt,
           DAE.LESS(ty = _),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeText(txt, i_e2);
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeText(txt, i_e2);
      then txt;

    case ( txt,
           DAE.GREATER(ty = _),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeText(txt, i_e1);
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("-"));
        txt = Tpl.writeText(txt, i_e1);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_58;

public function zeroCrossing
  input Tpl.Text in_txt;
  input DAE.Exp in_i_it;
  input Integer in_i_index;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it, in_i_index)
    local
      Tpl.Text txt;
      Integer i_index;

    case ( txt,
           DAE.RELATION(exp1 = i_exp1, exp2 = i_exp2, operator = i_operator),
           i_index )
      local
        DAE.Operator i_operator;
        DAE.Exp i_exp2;
        DAE.Exp i_exp1;
        Tpl.Text i_e2;
        Tpl.Text i_e1;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_e1, i_preExp) = daeExp(emptyTxt, i_exp1, SimCode.contextOther, i_preExp);
        (i_e2, i_preExp) = daeExp(emptyTxt, i_exp2, SimCode.contextOther, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var _zen = zeroCrossingEnabled["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; //ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = zeroCrossingOpFunc(txt, i_operator);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "));\n",
                                    "gout["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (_zen != 0) ? _zen * ("));
        txt = fun_58(txt, i_operator, i_e2, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") : 1.0; }"));
      then txt;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "sample"), expLst = {i_start, i_interval}),
           i_index )
      local
        DAE.Exp i_interval;
        DAE.Exp i_start;
        Tpl.Text i_eInterval;
        Tpl.Text i_eStart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_eStart, i_preExp) = daeExp(emptyTxt, i_start, SimCode.contextOther, i_preExp);
        (i_eInterval, i_preExp) = daeExp(emptyTxt, i_interval, SimCode.contextOther, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("{"));
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var _zen = zeroCrossingEnabled["));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; //ZEROCROSSING("));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", Sample(*t, "));
        txt = Tpl.writeText(txt, i_eStart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_eInterval);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "));\n",
                                    "gout["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = (_zen != 0) ? _zen * Sample(time, "));
        txt = Tpl.writeText(txt, i_eStart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_eInterval);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") : 1.0; }"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ZERO_CROSSING_ERROR"));
      then txt;
  end matchcontinue;
end zeroCrossing;

public function zeroCrossingOpFunc
  input Tpl.Text in_txt;
  input DAE.Operator in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.LESS(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Less"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Greater"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LessEq"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("GreaterEq"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end zeroCrossingOpFunc;

public function functionStoreDelayed
  input Tpl.Text txt;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunStoreDelayed()\n",
                                   "{\n",
                                   "}"
                               }, false));
end functionStoreDelayed;

protected function lm_62
  input Tpl.Text in_txt;
  input list<DAELow.ReinitStatement> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           DAELow.REINIT(value = i_value, stateVar = i_stateVar) :: rest )
      local
        list<DAELow.ReinitStatement> rest;
        DAE.ComponentRef i_stateVar;
        DAE.Exp i_value;
        Tpl.Text i_valueExp;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_valueExp, i_preExp) = daeExp(emptyTxt, i_value, SimCode.contextSimulationDiscrete, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_stateVar);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_valueExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_62(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<DAELow.ReinitStatement> rest;
      equation
        txt = lm_62(txt, rest);
      then txt;
  end matchcontinue;
end lm_62;

protected function lm_63
  input Tpl.Text in_txt;
  input list<SimCode.SimWhenClause> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIM_WHEN_CLAUSE(whenEq = i_whenEq, reinits = i_reinits) :: rest )
      local
        list<SimCode.SimWhenClause> rest;
        list<DAELow.ReinitStatement> i_reinits;
        Option<DAELow.WhenEquation> i_whenEq;
        Integer i_i0;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("case "));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(":\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = functionWhen_caseEquation(txt, i_whenEq);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_62(txt, i_reinits);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("break;"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.nextIter(txt);
        txt = lm_63(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimWhenClause> rest;
      equation
        txt = lm_63(txt, rest);
      then txt;
  end matchcontinue;
end lm_63;

public function functionWhen
  input Tpl.Text txt;
  input list<SimCode.SimWhenClause> i_whenClauses;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunWhen(int i)\n",
                                   "{\n",
                                   "  switch(i) {\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(4));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_63(out_txt, i_whenClauses);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "default:\n",
                                       "  break;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "  }\n",
                                       "}"
                                   }, false));
end functionWhen;

public function functionWhen_caseEquation
  input Tpl.Text in_txt;
  input Option<DAELow.WhenEquation> in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           SOME((i_weq as DAELow.WHEN_EQ(right = i_weq_right, left = i_weq_left))) )
      local
        DAE.ComponentRef i_weq_left;
        DAE.Exp i_weq_right;
        DAELow.WhenEquation i_weq;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_weq_right, SimCode.contextSimulationDiscrete, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre_"));
        txt = cref(txt, i_weq_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = cref(txt, i_weq_left);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("; //save()\n"));
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = cref(txt, i_weq_left);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end functionWhen_caseEquation;

protected function lm_66
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        SimCode.SimEqSystem i_it;
      equation
        txt = equation_(txt, i_it, SimCode.contextOther);
        txt = Tpl.nextIter(txt);
        txt = lm_66(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_66(txt, rest);
      then txt;
  end matchcontinue;
end lm_66;

public function functionOde
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> i_stateContEquations;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void FunODE()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_66(out_txt, i_stateContEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionOde;

protected function lm_68
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (it as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        SimCode.SimEqSystem it;
      equation
        txt = equation_(txt, it, SimCode.contextOther);
        txt = Tpl.nextIter(txt);
        txt = lm_68(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_68(txt, rest);
      then txt;
  end matchcontinue;
end lm_68;

protected function lm_69
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref) :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        DAE.Exp i_cref;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("//Debug.WriteLine(\"Setting variable start value: {0}(start={1})\", \""));
        txt = expCref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\", "));
        txt = expCref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_69(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_69(txt, rest);
      then txt;
  end matchcontinue;
end lm_69;

public function functionInitial
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> i_initialEquations;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void InitialFun()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_68(out_txt, i_initialEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "//if (sim_verbose) {\n"
                                   }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_69(out_txt, i_initialEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_LINE("//}\n"));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitial;

protected function fun_71
  input Tpl.Text in_txt;
  input DAE.Exp in_i_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_exp)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.SCONST(string = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[_i++] = 0;"));
      then txt;

    case ( txt,
           i_exp )
      local
        DAE.Exp i_exp;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_exp, SimCode.contextSimulationNonDiscrete, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("initialResiduals[_i++] = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;
  end matchcontinue;
end fun_71;

protected function lm_72
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp) :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        DAE.Exp i_exp;
      equation
        txt = fun_71(txt, i_exp);
        txt = Tpl.nextIter(txt);
        txt = lm_72(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_72(txt, rest);
      then txt;
  end matchcontinue;
end lm_72;

public function functionInitialResidual
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> i_residualEquations;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void InitialResidual()\n",
                                   "{\n",
                                   "  int _i = 0;\n",
                                   "\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_72(out_txt, i_residualEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionInitialResidual;

protected function lm_74
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_RESIDUAL(exp = i_exp) :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        DAE.Exp i_exp;
        Integer i_i0;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_exp, SimCode.contextSimulationDiscrete, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("res["));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        txt = lm_74(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_74(txt, rest);
      then txt;
  end matchcontinue;
end lm_74;

protected function lm_75
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SES_NONLINEAR(index = i_index, eqs = i_eqs) :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        list<SimCode.SimEqSystem> i_eqs;
        Integer i_index;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("void ResidualFun"));
        txt = Tpl.writeStr(txt, intString(i_index));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "(int n, double[] xloc, double[] res, int iflag)\n",
                                    "{\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(3));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_74(txt, i_eqs);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
        txt = Tpl.nextIter(txt);
        txt = lm_75(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_75(txt, rest);
      then txt;
  end matchcontinue;
end lm_75;

public function functionExtraResudials
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> i_allEquations;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_75(out_txt, i_allEquations);
  out_txt := Tpl.popIter(out_txt);
end functionExtraResudials;

protected function lm_77
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (it as SimCode.SES_SIMPLE_ASSIGN(cref = _)) :: rest )
      local
        list<SimCode.SimEqSystem> rest;
        SimCode.SimEqSystem it;
      equation
        txt = equation_(txt, it, SimCode.contextOther);
        txt = Tpl.nextIter(txt);
        txt = lm_77(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        txt = lm_77(txt, rest);
      then txt;
  end matchcontinue;
end lm_77;

public function functionBoundParameters
  input Tpl.Text txt;
  input list<SimCode.SimEqSystem> i_parameterEquations;

  output Tpl.Text out_txt;
algorithm
  System.tmpTickReset(1);
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override void BoundParameters()\n",
                                   "{\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_77(out_txt, i_parameterEquations);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionBoundParameters;

protected function fun_79
  input Tpl.Text in_txt;
  input Integer in_i_id2;
  input Integer in_i_id1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_id2, in_i_id1)
    local
      Tpl.Text txt;
      Integer i_id1;

    case ( txt,
           -1,
           _ )
      then txt;

    case ( txt,
           i_id2,
           i_id1 )
      local
        Integer i_id2;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (helpVars["));
        txt = Tpl.writeStr(txt, intString(i_id1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]!=0.0 && savedHelpVars["));
        txt = Tpl.writeStr(txt, intString(i_id1));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]==0.0) EventQueue.Add("));
        txt = Tpl.writeStr(txt, intString(i_id2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + NG);"));
      then txt;
  end matchcontinue;
end fun_79;

protected function lm_80
  input Tpl.Text in_txt;
  input list<SimCode.HelpVarInfo> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           (i_id1, i_exp, i_id2) :: rest )
      local
        list<SimCode.HelpVarInfo> rest;
        Integer i_id2;
        DAE.Exp i_exp;
        Integer i_id1;
      equation
        txt = fun_79(txt, i_id2, i_id1);
        txt = Tpl.nextIter(txt);
        txt = lm_80(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.HelpVarInfo> rest;
      equation
        txt = lm_80(txt, rest);
      then txt;
  end matchcontinue;
end lm_80;

protected function lm_81
  input Tpl.Text in_txt;
  input list<DAE.ComponentRef> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      local
        list<DAE.ComponentRef> rest;
        DAE.ComponentRef i_it;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (Pre_"));
        txt = cref(txt, i_it);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = cref(txt, i_it);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") return true; /*needToIterate = true; */"));
        txt = Tpl.nextIter(txt);
        txt = lm_81(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<DAE.ComponentRef> rest;
      equation
        txt = lm_81(txt, rest);
      then txt;
  end matchcontinue;
end lm_81;

public function functionCheckForDiscreteVarChanges
  input Tpl.Text txt;
  input list<SimCode.HelpVarInfo> i_helpVarInfoLst;
  input list<DAE.ComponentRef> i_discreteModelVars;

  output Tpl.Text out_txt;
algorithm
  out_txt := Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                   "public override bool CheckForDiscreteVarChanges()\n",
                                   "{\n",
                                   "  //var needToIterate = false;\n",
                                   "\n",
                                   "  //edge(helpVars[i])\n"
                               }, true));
  out_txt := Tpl.pushBlock(out_txt, Tpl.BT_INDENT(2));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_80(out_txt, i_helpVarInfoLst);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "//TODO: changeDiscreteVar(i) and to get the i from ComponentRef\n",
                                       "//if change()\n"
                                   }, true));
  out_txt := Tpl.pushIter(out_txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_txt := lm_81(out_txt, i_discreteModelVars);
  out_txt := Tpl.popIter(out_txt);
  out_txt := Tpl.softNewLine(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING_LIST({
                                       "\n",
                                       "var _hvs = helpVars;\n",
                                       "var _shvs = savedHelpVars;\n",
                                       "for (int i = 0; i < _hvs.Length; i++) {\n",
                                       "  //change(helpVars[i]) ?? TODO: not sure if it can be only 1.0 or 0.0\n",
                                       "  if (_hvs[i] != _shvs[i])\n",
                                       "    return true; //needToIterate=true;\n",
                                       "}\n",
                                       "\n",
                                       "return false; //needToIterate;\n"
                                   }, true));
  out_txt := Tpl.popBlock(out_txt);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("}"));
end functionCheckForDiscreteVarChanges;

protected function lm_83
  input Tpl.Text in_txt;
  input list<tuple<Integer, Integer, SimCode.SimEqSystem>> in_items;
  input Tpl.Text in_i_size;
  input Tpl.Text in_i_aname;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_i_size, in_i_aname, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_size;
      Tpl.Text i_aname;
      SimCode.Context i_context;

    case ( txt,
           {},
           _,
           _,
           _ )
      then txt;

    case ( txt,
           (i_row, i_col, (i_eq as SimCode.SES_RESIDUAL(exp = i_eq_exp))) :: rest,
           i_size,
           i_aname,
           i_context )
      local
        list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
        DAE.Exp i_eq_exp;
        SimCode.SimEqSystem i_eq;
        Integer i_col;
        Integer i_row;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_eq_exp, i_context, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.writeText(txt, i_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("+"));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeText(txt, i_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //set_matrix_elt("));
        txt = Tpl.writeText(txt, i_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_row));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_col));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_83(txt, rest, i_size, i_aname, i_context);
      then txt;

    case ( txt,
           _ :: rest,
           i_size,
           i_aname,
           i_context )
      local
        list<tuple<Integer, Integer, SimCode.SimEqSystem>> rest;
      equation
        txt = lm_83(txt, rest, i_size, i_aname, i_context);
      then txt;
  end matchcontinue;
end lm_83;

protected function lm_84
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_i_bname;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_i_bname, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_bname;
      SimCode.Context i_context;

    case ( txt,
           {},
           _,
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           i_bname,
           i_context )
      local
        list<DAE.Exp> rest;
        DAE.Exp i_it;
        Integer i_i0;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_it, i_context, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.writeText(txt, i_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("; //set_vector_elt("));
        txt = Tpl.writeText(txt, i_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_84(txt, rest, i_bname, i_context);
      then txt;

    case ( txt,
           _ :: rest,
           i_bname,
           i_context )
      local
        list<DAE.Exp> rest;
      equation
        txt = lm_84(txt, rest, i_bname, i_context);
      then txt;
  end matchcontinue;
end lm_84;

protected function fun_85
  input Tpl.Text in_txt;
  input Boolean in_i_partOfMixed;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_partOfMixed)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Mixed"));
      then txt;
  end matchcontinue;
end fun_85;

protected function lm_86
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;
  input Tpl.Text in_i_bname;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_i_bname)
    local
      Tpl.Text txt;
      Tpl.Text i_bname;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest,
           i_bname )
      local
        list<SimCode.SimVar> rest;
        DAE.ComponentRef i_name;
        Integer i_i0;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        txt = cref(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; //get_vector_elt("));
        txt = Tpl.writeText(txt, i_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(");"));
        txt = Tpl.nextIter(txt);
        txt = lm_86(txt, rest, i_bname);
      then txt;

    case ( txt,
           _ :: rest,
           i_bname )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_86(txt, rest, i_bname);
      then txt;
  end matchcontinue;
end lm_86;

protected function lm_87
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_items;
  input Tpl.Text in_i_preDisc;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preDisc;
algorithm
  (out_txt, out_i_preDisc) :=
  matchcontinue(in_txt, in_items, in_i_preDisc, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_preDisc;
      SimCode.Context i_context;

    case ( txt,
           {},
           i_preDisc,
           _ )
      then (txt, i_preDisc);

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(cref = i_cref, exp = i_exp) :: rest,
           i_preDisc,
           i_context )
      local
        list<SimCode.SimEqSystem> rest;
        DAE.Exp i_exp;
        DAE.Exp i_cref;
        Integer i_i0;
      equation
        i_i0 = Tpl.getIteri_i0(txt);
        txt = expCref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        (txt, i_preDisc) = daeExp(txt, i_exp, i_context, i_preDisc);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "discrete_loc2["
                                }, false));
        txt = Tpl.writeStr(txt, intString(i_i0));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = expCref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
        txt = Tpl.nextIter(txt);
        (txt, i_preDisc) = lm_87(txt, rest, i_preDisc, i_context);
      then (txt, i_preDisc);

    case ( txt,
           _ :: rest,
           i_preDisc,
           i_context )
      local
        list<SimCode.SimEqSystem> rest;
      equation
        (txt, i_preDisc) = lm_87(txt, rest, i_preDisc, i_context);
      then (txt, i_preDisc);
  end matchcontinue;
end lm_87;

protected function fun_88
  input Tpl.Text in_txt;
  input list<SimCode.SimEqSystem> in_i_discEqs;
  input Tpl.Text in_i_numDiscVarsStr;
  input Tpl.Text in_i_preDisc;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preDisc;
algorithm
  (out_txt, out_i_preDisc) :=
  matchcontinue(in_txt, in_i_discEqs, in_i_numDiscVarsStr, in_i_preDisc, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_numDiscVarsStr;
      Tpl.Text i_preDisc;
      SimCode.Context i_context;

    case ( txt,
           {(i_discEq as SimCode.SES_SIMPLE_ASSIGN(cref = i_discEq_cref, exp = i_discEq_exp))},
           _,
           i_preDisc,
           i_context )
      local
        DAE.Exp i_discEq_exp;
        DAE.Exp i_discEq_cref;
        SimCode.SimEqSystem i_discEq;
      equation
        txt = expCref(txt, i_discEq_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        (txt, i_preDisc) = daeExp(txt, i_discEq_exp, i_context, i_preDisc);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ";\n",
                                    "double discrete_loc2_0 = "
                                }, false));
        txt = expCref(txt, i_discEq_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then (txt, i_preDisc);

    case ( txt,
           i_discEqs,
           i_numDiscVarsStr,
           i_preDisc,
           i_context )
      local
        list<SimCode.SimEqSystem> i_discEqs;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var discrete_loc2 = new double["));
        txt = Tpl.writeText(txt, i_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("];\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (txt, i_preDisc) = lm_87(txt, i_discEqs, i_preDisc, i_context);
        txt = Tpl.popIter(txt);
      then (txt, i_preDisc);
  end matchcontinue;
end fun_88;

protected function lm_89
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SimCode.SIMVAR(name = i_name) :: rest )
      local
        list<SimCode.SimVar> rest;
        DAE.ComponentRef i_name;
      equation
        txt = cref(txt, i_name);
        txt = Tpl.nextIter(txt);
        txt = lm_89(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<SimCode.SimVar> rest;
      equation
        txt = lm_89(txt, rest);
      then txt;
  end matchcontinue;
end lm_89;

protected function fun_90
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_i_discVars;
  input Tpl.Text in_i_numDiscVarsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_discVars, in_i_numDiscVarsStr)
    local
      Tpl.Text txt;
      Tpl.Text i_numDiscVarsStr;

    case ( txt,
           {(i_var as SimCode.SIMVAR(name = i_var_name))},
           _ )
      local
        DAE.ComponentRef i_var_name;
        SimCode.SimVar i_var;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double discrete_loc_0 = "));
        txt = cref(txt, i_var_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           i_discVars,
           i_numDiscVarsStr )
      local
        list<SimCode.SimVar> i_discVars;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var discrete_loc = new double["));
        txt = Tpl.writeText(txt, i_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("] {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_LINE(",\n")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_89(txt, i_discVars);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("};"));
      then txt;
  end matchcontinue;
end fun_90;

protected function fun_91
  input Tpl.Text in_txt;
  input list<SimCode.SimVar> in_i_discVars;
  input Tpl.Text in_i_numDiscVarsStr;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_discVars, in_i_numDiscVarsStr)
    local
      Tpl.Text txt;
      Tpl.Text i_numDiscVarsStr;

    case ( txt,
           {SimCode.SIMVAR(name = _)},
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "if ( Math.Abs(discrete_loc_0 - discrete_loc2_0) > 1e-12) {\n",
                                    "    found_solution = 0;\n",
                                    "}"
                                }, false));
      then txt;

    case ( txt,
           i_discVars,
           i_numDiscVarsStr )
      local
        list<SimCode.SimVar> i_discVars;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("for (int i=0; i < "));
        txt = Tpl.writeText(txt, i_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "; i++) {\n",
                                    "    if ( Math.Abs(discrete_loc[i] - discrete_loc2[i]) > 1e-12) {\n",
                                    "        found_solution = 0;\n",
                                    "    }\n",
                                    "}"
                                }, false));
      then txt;
  end matchcontinue;
end fun_91;

public function equation_
  input Tpl.Text in_txt;
  input SimCode.SimEqSystem in_i_eq;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_eq, in_i_context)
    local
      Tpl.Text txt;
      SimCode.Context i_context;

    case ( txt,
           SimCode.SES_SIMPLE_ASSIGN(exp = i_exp, cref = i_cref),
           i_context )
      local
        DAE.Exp i_cref;
        DAE.Exp i_exp;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_exp, i_context, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = expCref(txt, i_cref);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           SimCode.SES_LINEAR(vars = i_vars, simJac = i_simJac, beqs = i_beqs, partOfMixed = i_partOfMixed),
           i_context )
      local
        Boolean i_partOfMixed;
        list<DAE.Exp> i_beqs;
        list<tuple<Integer, Integer, SimCode.SimEqSystem>> i_simJac;
        list<SimCode.SimVar> i_vars;
        Tpl.Text i_bname;
        Tpl.Text i_aname;
        Integer ret_3;
        Tpl.Text i_size;
        Integer ret_1;
        Tpl.Text i_uid;
      equation
        ret_1 = System.tmpTick();
        i_uid = Tpl.writeStr(emptyTxt, intString(ret_1));
        ret_3 = listLength(i_vars);
        i_size = Tpl.writeStr(emptyTxt, intString(ret_3));
        i_aname = Tpl.writeTok(emptyTxt, Tpl.ST_STRING("A"));
        i_aname = Tpl.writeText(i_aname, i_uid);
        i_bname = Tpl.writeTok(emptyTxt, Tpl.ST_STRING("b"));
        i_bname = Tpl.writeText(i_bname, i_uid);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("var "));
        txt = Tpl.writeText(txt, i_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double["));
        txt = Tpl.writeText(txt, i_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("*"));
        txt = Tpl.writeText(txt, i_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; //declare_matrix("));
        txt = Tpl.writeText(txt, i_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "var "
                                }, false));
        txt = Tpl.writeText(txt, i_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = new double["));
        txt = Tpl.writeText(txt, i_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]; //declare_vector("));
        txt = Tpl.writeText(txt, i_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_size);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_83(txt, i_simJac, i_size, i_aname, i_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_84(txt, i_beqs, i_bname, i_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SolveLinearSystem"));
        txt = fun_85(txt, i_partOfMixed);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_aname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_bname);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_size);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_uid);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(");\n"));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_86(txt, i_vars, i_bname);
        txt = Tpl.popIter(txt);
      then txt;

    case ( txt,
           SimCode.SES_MIXED(cont = i_cont, discVars = i_discVars, values = i_values, discEqs = i_discEqs),
           i_context )
      local
        list<SimCode.SimEqSystem> i_discEqs;
        list<String> i_values;
        list<SimCode.SimVar> i_discVars;
        SimCode.SimEqSystem i_cont;
        Tpl.Text i_discLoc2;
        Tpl.Text i_preDisc;
        Integer ret_4;
        Tpl.Text i_valuesLenStr;
        Integer ret_2;
        Tpl.Text i_numDiscVarsStr;
        Tpl.Text i_contEqs;
      equation
        i_contEqs = equation_(emptyTxt, i_cont, i_context);
        ret_2 = listLength(i_discVars);
        i_numDiscVarsStr = Tpl.writeStr(emptyTxt, intString(ret_2));
        ret_4 = listLength(i_values);
        i_valuesLenStr = Tpl.writeStr(emptyTxt, intString(ret_4));
        i_preDisc = emptyTxt;
        (i_discLoc2, i_preDisc) = fun_88(emptyTxt, i_discEqs, i_numDiscVarsStr, i_preDisc, i_context);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// *** mixed_equation_system("));
        txt = Tpl.writeText(txt, i_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ") ***\n",
                                    "{ int found_solution = 0;\n",
                                    "  int cur_value_indx = 0;\n",
                                    "  do {\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = fun_90(txt, i_discVars, i_numDiscVarsStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeText(txt, i_contEqs);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.writeText(txt, i_preDisc);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, i_discLoc2);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("{\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("// check_discrete_values("));
        txt = Tpl.writeText(txt, i_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_valuesLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ");\n",
                                    "if (found_solution == -1) { /*system of equations failed*/\n",
                                    "    found_solution = 0;\n",
                                    "} else {\n",
                                    "    found_solution = 1;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = fun_91(txt, i_discVars, i_numDiscVarsStr);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "}\n",
                                    "if (found_solution == 0) { //!found_solution\n",
                                    "    cur_value_indx++;\n"
                                }, true));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(4));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if (cur_value_indx > "));
        txt = Tpl.writeText(txt, i_valuesLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, i_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    ") {\n",
                                    "    found_solution = -1; //?? failed ??\n",
                                    "}\n"
                                }, true));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING_LIST({
                                    "  } while (found_solution == 0);\n",
                                    "} // *** mixed_equation_system_end("
                                }, false));
        txt = Tpl.writeText(txt, i_numDiscVarsStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") ***"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("equation_NOT_YET_IMPLEMENTED"));
      then txt;
  end matchcontinue;
end equation_;

public function cref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident) )
      local
        DAE.Ident i_ident;
      equation
        txt = replaceDollarWorkaround(txt, i_ident);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT"));
      then txt;
  end matchcontinue;
end cref;

public function crefSubscript
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident, subscriptLst = i_subscriptLst) )
      local
        list<DAE.Subscript> i_subscriptLst;
        DAE.Ident i_ident;
      equation
        txt = replaceDollarWorkaround(txt, i_ident);
        txt = subscripts(txt, i_subscriptLst);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CREF_NOT_IDENT"));
      then txt;
  end matchcontinue;
end crefSubscript;

protected function lm_95
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_it :: rest )
      local
        list<DAE.Subscript> rest;
        DAE.Subscript i_it;
      equation
        txt = subscript(txt, i_it);
        txt = Tpl.nextIter(txt);
        txt = lm_95(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<DAE.Subscript> rest;
      equation
        txt = lm_95(txt, rest);
      then txt;
  end matchcontinue;
end lm_95;

public function subscripts
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_i_subscriptsLst;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_subscriptsLst)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           i_subscriptsLst )
      local
        list<DAE.Subscript> i_subscriptsLst;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("["));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_STRING(",")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_95(txt, i_subscriptsLst);
        txt = Tpl.popIter(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("]"));
      then txt;
  end matchcontinue;
end subscripts;

public function subscript
  input Tpl.Text in_txt;
  input DAE.Subscript in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.INDEX(exp = DAE.ICONST(integer = i_exp_integer)) )
      local
        Integer i_exp_integer;
      equation
        txt = Tpl.writeStr(txt, intString(i_exp_integer));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SUBSCRIPT_NOT_CONSTANT"));
      then txt;
  end matchcontinue;
end subscript;

public function expCref
  input Tpl.Text in_txt;
  input DAE.Exp in_i_cref;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_cref)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.CREF(componentRef = i_componentRef) )
      local
        DAE.ComponentRef i_componentRef;
      equation
        txt = cref(txt, i_componentRef);
      then txt;

    case ( txt,
           DAE.CALL(path = Absyn.IDENT(name = "der"), expLst = {(i_arg as DAE.CREF(componentRef = i_arg_componentRef))}) )
      local
        DAE.ComponentRef i_arg_componentRef;
        DAE.Exp i_arg;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("$DER$"));
        txt = cref(txt, i_arg_componentRef);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ERROR_NOT_A_CREF"));
      then txt;
  end matchcontinue;
end expCref;

public function dotPath
  input Tpl.Text in_txt;
  input Absyn.Path in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      local
        Absyn.Path i_path;
        Absyn.Ident i_name;
      equation
        txt = Tpl.writeStr(txt, i_name);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name) )
      local
        Absyn.Ident i_name;
      equation
        txt = Tpl.writeStr(txt, i_name);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      local
        Absyn.Path i_path;
      equation
        txt = dotPath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end dotPath;

public function underscorePath
  input Tpl.Text in_txt;
  input Absyn.Path in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           Absyn.QUALIFIED(name = i_name, path = i_path) )
      local
        Absyn.Path i_path;
        Absyn.Ident i_name;
        String ret_0;
      equation
        ret_0 = System.stringReplace(i_name, "_", "__");
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           Absyn.IDENT(name = i_name) )
      local
        Absyn.Ident i_name;
        String ret_0;
      equation
        ret_0 = System.stringReplace(i_name, "_", "__");
        txt = Tpl.writeStr(txt, ret_0);
      then txt;

    case ( txt,
           Absyn.FULLYQUALIFIED(path = i_path) )
      local
        Absyn.Path i_path;
      equation
        txt = underscorePath(txt, i_path);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end underscorePath;

protected function lm_101
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_i_context)
    local
      Tpl.Text txt;
      SimCode.Context i_context;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           i_context )
      local
        list<DAE.Statement> rest;
        DAE.Statement i_it;
      equation
        txt = algStatement(txt, i_it, i_context);
        txt = Tpl.nextIter(txt);
        txt = lm_101(txt, rest, i_context);
      then txt;

    case ( txt,
           _ :: rest,
           i_context )
      local
        list<DAE.Statement> rest;
      equation
        txt = lm_101(txt, rest, i_context);
      then txt;
  end matchcontinue;
end lm_101;

public function algStatement
  input Tpl.Text in_txt;
  input DAE.Statement in_i_it;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it, in_i_context)
    local
      Tpl.Text txt;
      SimCode.Context i_context;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = DAE.CREF(componentRef = DAE.WILD()), exp = i_e),
           i_context )
      local
        DAE.Exp i_e;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_e, i_context, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, i_expPart);
      then txt;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = (i_exp1 as DAE.CREF(componentRef = _)), exp = i_exp),
           i_context )
      local
        DAE.Exp i_exp;
        DAE.Exp i_exp1;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_exp, i_context, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        (txt, i_preExp) = scalarLhsCref(txt, i_exp1, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.STMT_ASSIGN(exp1 = i_exp1, exp = i_exp),
           i_context )
      local
        DAE.Exp i_exp;
        DAE.Exp i_exp1;
        Tpl.Text i_expPart2;
        Tpl.Text i_expPart1;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart1, i_preExp) = daeExp(emptyTxt, i_exp1, i_context, i_preExp);
        (i_expPart2, i_preExp) = daeExp(emptyTxt, i_exp, i_context, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeText(txt, i_expPart1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" = "));
        txt = Tpl.writeText(txt, i_expPart2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(";"));
      then txt;

    case ( txt,
           DAE.STMT_IF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           i_context )
      local
        DAE.Else i_else__;
        list<DAE.Statement> i_statementLst;
        DAE.Exp i_exp;
        Tpl.Text i_condExp;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_condExp, i_preExp) = daeExp(emptyTxt, i_exp, i_context, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, i_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(") {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_101(txt, i_statementLst, i_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = elseExpr(txt, i_else__, i_context);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NOT_IMPLEMENTED_ALG_STATEMENT"));
      then txt;
  end matchcontinue;
end algStatement;

protected function lm_103
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_i_context)
    local
      Tpl.Text txt;
      SimCode.Context i_context;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           i_context )
      local
        list<DAE.Statement> rest;
        DAE.Statement i_it;
      equation
        txt = algStatement(txt, i_it, i_context);
        txt = Tpl.nextIter(txt);
        txt = lm_103(txt, rest, i_context);
      then txt;

    case ( txt,
           _ :: rest,
           i_context )
      local
        list<DAE.Statement> rest;
      equation
        txt = lm_103(txt, rest, i_context);
      then txt;
  end matchcontinue;
end lm_103;

protected function lm_104
  input Tpl.Text in_txt;
  input list<DAE.Statement> in_items;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items, in_i_context)
    local
      Tpl.Text txt;
      SimCode.Context i_context;

    case ( txt,
           {},
           _ )
      then txt;

    case ( txt,
           i_it :: rest,
           i_context )
      local
        list<DAE.Statement> rest;
        DAE.Statement i_it;
      equation
        txt = algStatement(txt, i_it, i_context);
        txt = Tpl.nextIter(txt);
        txt = lm_104(txt, rest, i_context);
      then txt;

    case ( txt,
           _ :: rest,
           i_context )
      local
        list<DAE.Statement> rest;
      equation
        txt = lm_104(txt, rest, i_context);
      then txt;
  end matchcontinue;
end lm_104;

public function elseExpr
  input Tpl.Text in_txt;
  input DAE.Else in_i_it;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it, in_i_context)
    local
      Tpl.Text txt;
      SimCode.Context i_context;

    case ( txt,
           DAE.NOELSE(),
           _ )
      then txt;

    case ( txt,
           DAE.ELSEIF(exp = i_exp, statementLst = i_statementLst, else_ = i_else__),
           i_context )
      local
        DAE.Else i_else__;
        list<DAE.Statement> i_statementLst;
        DAE.Exp i_exp;
        Tpl.Text i_condExp;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_condExp, i_preExp) = daeExp(emptyTxt, i_exp, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("if ("));
        txt = Tpl.writeText(txt, i_condExp);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(")) {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_103(txt, i_statementLst, i_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("}\n"));
        txt = elseExpr(txt, i_else__, i_context);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           DAE.ELSE(statementLst = i_statementLst),
           i_context )
      local
        list<DAE.Statement> i_statementLst;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("else {\n"));
        txt = Tpl.pushBlock(txt, Tpl.BT_INDENT(2));
        txt = Tpl.pushIter(txt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_NEW_LINE()), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        txt = lm_104(txt, i_statementLst, i_context);
        txt = Tpl.popIter(txt);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.popBlock(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("}"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end elseExpr;

protected function fun_106
  input Tpl.Text in_txt;
  input list<Integer> in_i_ints;
  input list<DAE.Exp> in_i_restExps;
  input DAE.Exp in_i_firstExp;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_ints, in_i_restExps, in_i_firstExp)
    local
      Tpl.Text txt;
      list<DAE.Exp> i_restExps;
      DAE.Exp i_firstExp;

    case ( txt,
           i_firstInt :: i_restInts,
           i_restExps,
           i_firstExp )
      local
        list<Integer> i_restInts;
        Integer i_firstInt;
        Tpl.Text i_expPart;
        Tpl.Text i_preExp;
      equation
        i_preExp = emptyTxt;
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_firstExp, SimCode.contextSimulationDiscrete, i_preExp);
        txt = Tpl.writeText(txt, i_preExp);
        txt = Tpl.softNewLine(txt);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("localData->helpVars["));
        txt = Tpl.writeStr(txt, intString(i_firstInt));
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("] = "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_LINE(";\n"));
        txt = foo(txt, i_restExps, i_restInts);
      then txt;

    case ( txt,
           _,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_106;

public function foo
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_i_exps;
  input list<Integer> in_i_ints;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_exps, in_i_ints)
    local
      Tpl.Text txt;
      list<Integer> i_ints;

    case ( txt,
           i_firstExp :: i_restExps,
           i_ints )
      local
        list<DAE.Exp> i_restExps;
        DAE.Exp i_firstExp;
      equation
        txt = fun_106(txt, i_ints, i_restExps, i_firstExp);
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end foo;

protected function fun_108
  input Tpl.Text in_txt;
  input Boolean in_it;
  input DAE.ComponentRef in_i_cref_componentRef;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;
  input DAE.Exp in_i_cref;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_it, in_i_cref_componentRef, in_i_preExp, in_i_context, in_i_cref)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cref_componentRef;
      Tpl.Text i_preExp;
      SimCode.Context i_context;
      DAE.Exp i_cref;

    case ( txt,
           false,
           _,
           i_preExp,
           i_context,
           i_cref )
      equation
        (txt, i_preExp) = daeExpCrefRhs(txt, i_cref, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           _,
           i_cref_componentRef,
           i_preExp,
           _,
           _ )
      equation
        txt = cref(txt, i_cref_componentRef);
      then (txt, i_preExp);
  end matchcontinue;
end fun_108;

public function scalarLhsCref
  input Tpl.Text in_txt;
  input DAE.Exp in_i_cref;
  input SimCode.Context in_i_context;
  input Tpl.Text in_i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_i_cref, in_i_context, in_i_preExp)
    local
      Tpl.Text txt;
      SimCode.Context i_context;
      Tpl.Text i_preExp;

    case ( txt,
           (i_cref as DAE.CREF(componentRef = (i_cref_componentRef as DAE.CREF_IDENT(subscriptLst = i_subs)))),
           i_context,
           i_preExp )
      local
        list<DAE.Subscript> i_subs;
        DAE.ComponentRef i_cref_componentRef;
        DAE.Exp i_cref;
        Boolean ret_0;
      equation
        ret_0 = SimCode.crefNoSub(i_cref_componentRef);
        (txt, i_preExp) = fun_108(txt, ret_0, i_cref_componentRef, i_preExp, i_context, i_cref);
      then (txt, i_preExp);

    case ( txt,
           _,
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ONLY IDENT SUPPORTED"));
      then (txt, i_preExp);
  end matchcontinue;
end scalarLhsCref;

public function rhsCref
  input Tpl.Text in_txt;
  input DAE.ComponentRef in_i_it;
  input DAE.ExpType in_i_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it, in_i_ty)
    local
      Tpl.Text txt;
      DAE.ExpType i_ty;

    case ( txt,
           DAE.CREF_IDENT(ident = i_ident),
           i_ty )
      local
        DAE.Ident i_ident;
      equation
        txt = rhsCrefType(txt, i_ty);
        txt = replaceDollarWorkaround(txt, i_ident);
      then txt;

    case ( txt,
           DAE.CREF_QUAL(ident = i_ident, componentRef = i_componentRef),
           i_ty )
      local
        DAE.ComponentRef i_componentRef;
        DAE.Ident i_ident;
      equation
        txt = rhsCrefType(txt, i_ty);
        txt = Tpl.writeStr(txt, i_ident);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("."));
        txt = rhsCref(txt, i_componentRef, i_ty);
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("rhsCref:ERROR"));
      then txt;
  end matchcontinue;
end rhsCref;

public function rhsCrefType
  input Tpl.Text in_txt;
  input DAE.ExpType in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end rhsCrefType;

public function replaceDollarWorkaround
  input Tpl.Text txt;
  input String i_ident;

  output Tpl.Text out_txt;
protected
  String ret_1;
  String ret_0;
algorithm
  ret_0 := System.stringReplace(i_ident, "$DER", "Der_");
  ret_1 := System.stringReplace(ret_0, "$", "");
  out_txt := Tpl.writeStr(txt, ret_1);
end replaceDollarWorkaround;

protected function fun_113
  input Tpl.Text in_txt;
  input Boolean in_i_bool;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_bool)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(0)"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1)"));
      then txt;
  end matchcontinue;
end fun_113;

public function daeExp
  input Tpl.Text in_txt;
  input DAE.Exp in_i_exp;
  input SimCode.Context in_i_context;
  input Tpl.Text in_i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_i_exp, in_i_context, in_i_preExp)
    local
      Tpl.Text txt;
      SimCode.Context i_context;
      Tpl.Text i_preExp;

    case ( txt,
           DAE.ICONST(integer = i_integer),
           _,
           i_preExp )
      local
        Integer i_integer;
      equation
        txt = Tpl.writeStr(txt, intString(i_integer));
      then (txt, i_preExp);

    case ( txt,
           DAE.RCONST(real = i_real),
           _,
           i_preExp )
      local
        Real i_real;
      equation
        txt = Tpl.writeStr(txt, realString(i_real));
      then (txt, i_preExp);

    case ( txt,
           DAE.SCONST(string = i_string),
           _,
           i_preExp )
      local
        String i_string;
        String ret_0;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
        ret_0 = Util.escapeModelicaStringToCString(i_string);
        txt = Tpl.writeStr(txt, ret_0);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\""));
      then (txt, i_preExp);

    case ( txt,
           DAE.BCONST(bool = i_bool),
           _,
           i_preExp )
      local
        Boolean i_bool;
      equation
        txt = fun_113(txt, i_bool);
      then (txt, i_preExp);

    case ( txt,
           (i_exp as DAE.CREF(componentRef = _)),
           i_context,
           i_preExp )
      local
        DAE.Exp i_exp;
      equation
        (txt, i_preExp) = daeExpCrefRhs(txt, i_exp, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           DAE.LBINARY(operator = i_operator, exp1 = i_exp1, exp2 = i_exp2),
           i_context,
           i_preExp )
      local
        DAE.Exp i_exp2;
        DAE.Exp i_exp1;
        DAE.Operator i_operator;
      equation
        (txt, i_preExp) = daeExpBinary(txt, i_operator, i_exp1, i_exp2, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           DAE.BINARY(operator = i_operator, exp1 = i_exp1, exp2 = i_exp2),
           i_context,
           i_preExp )
      local
        DAE.Exp i_exp2;
        DAE.Exp i_exp1;
        DAE.Operator i_operator;
      equation
        (txt, i_preExp) = daeExpBinary(txt, i_operator, i_exp1, i_exp2, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           DAE.LUNARY(operator = i_operator, exp = i_exp),
           i_context,
           i_preExp )
      local
        DAE.Exp i_exp;
        DAE.Operator i_operator;
      equation
        (txt, i_preExp) = daeExpUnary(txt, i_operator, i_exp, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           DAE.UNARY(operator = i_operator, exp = i_exp),
           i_context,
           i_preExp )
      local
        DAE.Exp i_exp;
        DAE.Operator i_operator;
      equation
        (txt, i_preExp) = daeExpUnary(txt, i_operator, i_exp, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           DAE.RELATION(operator = i_operator, exp1 = i_exp1, exp2 = i_exp2),
           i_context,
           i_preExp )
      local
        DAE.Exp i_exp2;
        DAE.Exp i_exp1;
        DAE.Operator i_operator;
      equation
        (txt, i_preExp) = daeExpRelation(txt, i_operator, i_exp1, i_exp2, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           DAE.IFEXP(expCond = i_expCond, expThen = i_expThen, expElse = i_expElse),
           i_context,
           i_preExp )
      local
        DAE.Exp i_expElse;
        DAE.Exp i_expThen;
        DAE.Exp i_expCond;
      equation
        (txt, i_preExp) = daeExpIf(txt, i_expCond, i_expThen, i_expElse, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           (i_exp as DAE.CALL(path = _)),
           i_context,
           i_preExp )
      local
        DAE.Exp i_exp;
      equation
        (txt, i_preExp) = daeExpCall(txt, i_exp, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           DAE.ARRAY(ty = i_ty, scalar = i_scalar, array = i_array),
           i_context,
           i_preExp )
      local
        list<DAE.Exp> i_array;
        Boolean i_scalar;
        DAE.ExpType i_ty;
      equation
        (txt, i_preExp) = daeExpArray(txt, i_ty, i_scalar, i_array, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           DAE.MATRIX(ty = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("MATRIX_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.RANGE(ty = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("RANGE_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.TUPLE(PR = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("TUPLE_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.CAST(ty = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CAST_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.ASUB(exp = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("ASUB_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.SIZE(exp = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("SIZE_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.CODE(code = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CODE_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.REDUCTION(path = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("REDUCTION_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.END(),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("END_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.VALUEBLOCK(ty = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("VALUEBLOCK_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.LIST(ty = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("LIST_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           DAE.CONS(ty = _),
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("CONS_NOT_IMPLEMENTED"));
      then (txt, i_preExp);

    case ( txt,
           _,
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN_EXP"));
      then (txt, i_preExp);
  end matchcontinue;
end daeExp;

protected function lm_115
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_items, in_i_preExp, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      SimCode.Context i_context;

    case ( txt,
           {},
           i_preExp,
           _ )
      then (txt, i_preExp);

    case ( txt,
           DAE.INDEX(exp = i_exp) :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Subscript> rest;
        DAE.Exp i_exp;
      equation
        (txt, i_preExp) = daeExp(txt, i_exp, i_context, i_preExp);
        txt = Tpl.nextIter(txt);
        (txt, i_preExp) = lm_115(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);

    case ( txt,
           _ :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Subscript> rest;
      equation
        (txt, i_preExp) = lm_115(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);
  end matchcontinue;
end lm_115;

protected function fun_116
  input Tpl.Text in_txt;
  input Boolean in_it;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;
  input list<DAE.Subscript> in_i_subs;
  input DAE.ExpType in_i_cref_ty;
  input DAE.ComponentRef in_i_cref_componentRef;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_it, in_i_preExp, in_i_context, in_i_subs, in_i_cref_ty, in_i_cref_componentRef)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      SimCode.Context i_context;
      list<DAE.Subscript> i_subs;
      DAE.ExpType i_cref_ty;
      DAE.ComponentRef i_cref_componentRef;

    case ( txt,
           false,
           i_preExp,
           i_context,
           i_subs,
           i_cref_ty,
           i_cref_componentRef )
      local
        Tpl.Text i_tmp;
        Tpl.Text i_spec1;
        Tpl.Text i_arrayType;
        Tpl.Text i_arrName;
      equation
        i_arrName = cref(emptyTxt, i_cref_componentRef);
        i_arrayType = expTypeArray(emptyTxt, i_cref_ty);
        (i_spec1, i_preExp) = daeExpCrefRhsIndexSpec(emptyTxt, i_subs, i_context, i_preExp);
        i_tmp = emptyTxt;
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING("!!!TODO: "));
        (i_preExp, i_tmp) = tempDecl(i_preExp, Tpl.textString(i_arrayType), i_tmp);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(" = index_alloc_"));
        i_preExp = Tpl.writeText(i_preExp, i_arrayType);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING("(&"));
        i_preExp = Tpl.writeText(i_preExp, i_arrName);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(", &"));
        i_preExp = Tpl.writeText(i_preExp, i_spec1);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(", &"));
        i_preExp = Tpl.writeText(i_preExp, i_tmp);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(");"));
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, i_tmp);
      then (txt, i_preExp);

    case ( txt,
           _,
           i_preExp,
           i_context,
           i_subs,
           i_cref_ty,
           i_cref_componentRef )
      local
        Tpl.Text i_dimsValuesStr;
        Integer ret_3;
        Tpl.Text i_dimsLenStr;
        Tpl.Text i_arrayType;
        Tpl.Text i_arrName;
      equation
        i_arrName = cref(emptyTxt, i_cref_componentRef);
        i_arrayType = expTypeArray(emptyTxt, i_cref_ty);
        ret_3 = listLength(i_subs);
        i_dimsLenStr = Tpl.writeStr(emptyTxt, intString(ret_3));
        i_dimsValuesStr = Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (i_dimsValuesStr, i_preExp) = lm_115(i_dimsValuesStr, i_subs, i_preExp, i_context);
        i_dimsValuesStr = Tpl.popIter(i_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("!!!TODO:(*"));
        txt = Tpl.writeText(txt, i_arrayType);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_element_addr(&"));
        txt = Tpl.writeText(txt, i_arrName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_dimsLenStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_dimsValuesStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then (txt, i_preExp);
  end matchcontinue;
end fun_116;

protected function fun_117
  input Tpl.Text in_txt;
  input DAE.ExpType in_i_cref_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_cref_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_117;

protected function fun_118
  input Tpl.Text in_txt;
  input Boolean in_it;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;
  input list<DAE.Subscript> in_i_subs;
  input DAE.ExpType in_i_cref_ty;
  input DAE.ComponentRef in_i_cref_componentRef;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_it, in_i_preExp, in_i_context, in_i_subs, in_i_cref_ty, in_i_cref_componentRef)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      SimCode.Context i_context;
      list<DAE.Subscript> i_subs;
      DAE.ExpType i_cref_ty;
      DAE.ComponentRef i_cref_componentRef;

    case ( txt,
           false,
           i_preExp,
           i_context,
           i_subs,
           i_cref_ty,
           i_cref_componentRef )
      local
        Boolean ret_0;
      equation
        ret_0 = SimCode.crefSubIsScalar(i_cref_componentRef);
        (txt, i_preExp) = fun_116(txt, ret_0, i_preExp, i_context, i_subs, i_cref_ty, i_cref_componentRef);
      then (txt, i_preExp);

    case ( txt,
           _,
           i_preExp,
           _,
           _,
           i_cref_ty,
           i_cref_componentRef )
      equation
        txt = fun_117(txt, i_cref_ty);
        txt = cref(txt, i_cref_componentRef);
      then (txt, i_preExp);
  end matchcontinue;
end fun_118;

protected function fun_119
  input Tpl.Text in_txt;
  input String in_it;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;
  input list<DAE.Subscript> in_i_subs;
  input DAE.ExpType in_i_cref_ty;
  input DAE.ComponentRef in_i_cref_componentRef;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_it, in_i_preExp, in_i_context, in_i_subs, in_i_cref_ty, in_i_cref_componentRef)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      SimCode.Context i_context;
      list<DAE.Subscript> i_subs;
      DAE.ExpType i_cref_ty;
      DAE.ComponentRef i_cref_componentRef;

    case ( txt,
           "",
           i_preExp,
           i_context,
           i_subs,
           i_cref_ty,
           i_cref_componentRef )
      local
        Boolean ret_0;
      equation
        ret_0 = SimCode.crefNoSub(i_cref_componentRef);
        (txt, i_preExp) = fun_118(txt, ret_0, i_preExp, i_context, i_subs, i_cref_ty, i_cref_componentRef);
      then (txt, i_preExp);

    case ( txt,
           str_1,
           i_preExp,
           _,
           _,
           _,
           _ )
      local
        String str_1;
      equation
        txt = Tpl.writeStr(txt, str_1);
      then (txt, i_preExp);
  end matchcontinue;
end fun_119;

public function daeExpCrefRhs
  input Tpl.Text in_txt;
  input DAE.Exp in_i_exp;
  input SimCode.Context in_i_context;
  input Tpl.Text in_i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_i_exp, in_i_context, in_i_preExp)
    local
      Tpl.Text txt;
      SimCode.Context i_context;
      Tpl.Text i_preExp;

    case ( txt,
           (i_cref as DAE.CREF(componentRef = (i_cref_componentRef as DAE.CREF_IDENT(subscriptLst = i_subs)), ty = i_cref_ty)),
           i_context,
           i_preExp )
      local
        DAE.ExpType i_cref_ty;
        list<DAE.Subscript> i_subs;
        DAE.ComponentRef i_cref_componentRef;
        DAE.Exp i_cref;
        String str_1;
        Tpl.Text txt_0;
      equation
        (txt_0, i_preExp) = daeExpCrefRhsArrayBox(emptyTxt, i_cref, i_context, i_preExp);
        str_1 = Tpl.textString(txt_0);
        (txt, i_preExp) = fun_119(txt, str_1, i_preExp, i_context, i_subs, i_cref_ty, i_cref_componentRef);
      then (txt, i_preExp);

    case ( txt,
           _,
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UNKNOWN RHS CREF: ONLY IDENT SUPPORTED"));
      then (txt, i_preExp);
  end matchcontinue;
end daeExpCrefRhs;

protected function fun_121
  input Tpl.Text in_txt;
  input DAE.Subscript in_i_it;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_i_it, in_i_preExp, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      SimCode.Context i_context;

    case ( txt,
           DAE.INDEX(exp = i_exp),
           i_preExp,
           i_context )
      local
        DAE.Exp i_exp;
        Tpl.Text i_expPart;
      equation
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_exp, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1), make_index_array(1, "));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), \'S\'"));
      then (txt, i_preExp);

    case ( txt,
           DAE.WHOLEDIM(),
           i_preExp,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(1), (0), \'W\'"));
      then (txt, i_preExp);

    case ( txt,
           DAE.SLICE(exp = i_exp),
           i_preExp,
           i_context )
      local
        DAE.Exp i_exp;
        Tpl.Text i_tmp;
        Tpl.Text i_expPart;
      equation
        (i_expPart, i_preExp) = daeExp(emptyTxt, i_exp, i_context, i_preExp);
        i_tmp = emptyTxt;
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING("!!!TODO:"));
        (i_preExp, i_tmp) = tempDecl(i_preExp, "int", i_tmp);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(" = size_of_dimension_integer_array("));
        i_preExp = Tpl.writeText(i_preExp, i_expPart);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(", 1);"));
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, i_tmp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", integer_array_make_index_array(&"));
        txt = Tpl.writeText(txt, i_expPart);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("), \'A\'"));
      then (txt, i_preExp);

    case ( txt,
           _,
           i_preExp,
           _ )
      then (txt, i_preExp);
  end matchcontinue;
end fun_121;

protected function lm_122
  input Tpl.Text in_txt;
  input list<DAE.Subscript> in_items;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_items, in_i_preExp, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      SimCode.Context i_context;

    case ( txt,
           {},
           i_preExp,
           _ )
      then (txt, i_preExp);

    case ( txt,
           i_it :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Subscript> rest;
        DAE.Subscript i_it;
      equation
        (txt, i_preExp) = fun_121(txt, i_it, i_preExp, i_context);
        txt = Tpl.nextIter(txt);
        (txt, i_preExp) = lm_122(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);

    case ( txt,
           _ :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Subscript> rest;
      equation
        (txt, i_preExp) = lm_122(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);
  end matchcontinue;
end lm_122;

public function daeExpCrefRhsIndexSpec
  input Tpl.Text txt;
  input list<DAE.Subscript> i_subs;
  input SimCode.Context i_context;
  input Tpl.Text i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
protected
  Tpl.Text i_tmp;
  Tpl.Text i_idx__str;
  Integer ret_1;
  Tpl.Text i_nridx__str;
algorithm
  ret_1 := listLength(i_subs);
  i_nridx__str := Tpl.writeStr(emptyTxt, intString(ret_1));
  i_idx__str := Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (i_idx__str, out_i_preExp) := lm_122(i_idx__str, i_subs, i_preExp, i_context);
  i_idx__str := Tpl.popIter(i_idx__str);
  i_tmp := emptyTxt;
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("!!!TODO:"));
  (out_i_preExp, i_tmp) := tempDecl(out_i_preExp, "index_spec_t", i_tmp);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" = create_index_spec(&"));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_tmp);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(", "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_nridx__str);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(", "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_idx__str);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(");"));
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, i_tmp);
end daeExpCrefRhsIndexSpec;

protected function lm_124
  input Tpl.Text in_txt;
  input list<Option<Integer>> in_items;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_items)
    local
      Tpl.Text txt;

    case ( txt,
           {} )
      then txt;

    case ( txt,
           SOME(i_i) :: rest )
      local
        list<Option<Integer>> rest;
        Integer i_i;
      equation
        txt = Tpl.writeStr(txt, intString(i_i));
        txt = Tpl.nextIter(txt);
        txt = lm_124(txt, rest);
      then txt;

    case ( txt,
           _ :: rest )
      local
        list<Option<Integer>> rest;
      equation
        txt = lm_124(txt, rest);
      then txt;
  end matchcontinue;
end lm_124;

protected function fun_125
  input Tpl.Text in_txt;
  input SimCode.Context in_i_context;
  input DAE.ComponentRef in_i_cref_componentRef;
  input DAE.ExpType in_i_aty;
  input Tpl.Text in_i_preExp;
  input list<Option<Integer>> in_i_dims;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_i_context, in_i_cref_componentRef, in_i_aty, in_i_preExp, in_i_dims)
    local
      Tpl.Text txt;
      DAE.ComponentRef i_cref_componentRef;
      DAE.ExpType i_aty;
      Tpl.Text i_preExp;
      list<Option<Integer>> i_dims;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           i_cref_componentRef,
           i_aty,
           i_preExp,
           i_dims )
      local
        Tpl.Text txt_4;
        Tpl.Text i_dimsValuesStr;
        Integer ret_2;
        Tpl.Text i_dimsLenStr;
        Tpl.Text i_tmpArr;
      equation
        i_tmpArr = emptyTxt;
        ret_2 = listLength(i_dims);
        i_dimsLenStr = Tpl.writeStr(emptyTxt, intString(ret_2));
        i_dimsValuesStr = Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        i_dimsValuesStr = lm_124(i_dimsValuesStr, i_dims);
        i_dimsValuesStr = Tpl.popIter(i_dimsValuesStr);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING("!!!TODO:"));
        txt_4 = expTypeArray(emptyTxt, i_aty);
        (i_preExp, i_tmpArr) = tempDecl(i_preExp, Tpl.textString(txt_4), i_tmpArr);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(" = "));
        i_preExp = expShortType(i_preExp, i_aty);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING("_array_create(&"));
        i_preExp = Tpl.writeText(i_preExp, i_tmpArr);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(", &"));
        i_preExp = cref(i_preExp, i_cref_componentRef);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(", "));
        i_preExp = Tpl.writeText(i_preExp, i_dimsLenStr);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(", "));
        i_preExp = Tpl.writeText(i_preExp, i_dimsValuesStr);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(");"));
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeText(txt, i_tmpArr);
      then (txt, i_preExp);

    case ( txt,
           _,
           _,
           _,
           i_preExp,
           _ )
      then (txt, i_preExp);
  end matchcontinue;
end fun_125;

public function daeExpCrefRhsArrayBox
  input Tpl.Text in_txt;
  input DAE.Exp in_i_exp;
  input SimCode.Context in_i_context;
  input Tpl.Text in_i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_i_exp, in_i_context, in_i_preExp)
    local
      Tpl.Text txt;
      SimCode.Context i_context;
      Tpl.Text i_preExp;

    case ( txt,
           (i_cref as DAE.CREF(ty = DAE.ET_ARRAY(ty = i_aty, arrayDimensions = i_dims), componentRef = i_cref_componentRef)),
           i_context,
           i_preExp )
      local
        DAE.ComponentRef i_cref_componentRef;
        list<Option<Integer>> i_dims;
        DAE.ExpType i_aty;
        DAE.Exp i_cref;
      equation
        (txt, i_preExp) = fun_125(txt, i_context, i_cref_componentRef, i_aty, i_preExp, i_dims);
      then (txt, i_preExp);

    case ( txt,
           _,
           _,
           i_preExp )
      then (txt, i_preExp);
  end matchcontinue;
end daeExpCrefRhsArrayBox;

protected function fun_127
  input Tpl.Text in_txt;
  input DAE.Operator in_i_it;
  input Tpl.Text in_i_e2;
  input Tpl.Text in_i_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it, in_i_e2, in_i_e1)
    local
      Tpl.Text txt;
      Tpl.Text i_e2;
      Tpl.Text i_e1;

    case ( txt,
           DAE.ADD(ty = _),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" + "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.SUB(ty = _),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" - "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.MUL(ty = _),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" * "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.DIV(ty = _),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" / "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.POW(ty = _),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Pow("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(", "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.AND(),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.OR(),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpBinary:ERR"));
      then txt;
  end matchcontinue;
end fun_127;

public function daeExpBinary
  input Tpl.Text txt;
  input DAE.Operator i_it;
  input DAE.Exp i_exp1;
  input DAE.Exp i_exp2;
  input SimCode.Context i_context;
  input Tpl.Text i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
protected
  Tpl.Text i_e2;
  Tpl.Text i_e1;
algorithm
  (i_e1, out_i_preExp) := daeExp(emptyTxt, i_exp1, i_context, i_preExp);
  (i_e2, out_i_preExp) := daeExp(emptyTxt, i_exp2, i_context, out_i_preExp);
  out_txt := fun_127(txt, i_it, i_e2, i_e1);
end daeExpBinary;

protected function fun_129
  input Tpl.Text in_txt;
  input DAE.Operator in_i_it;
  input Tpl.Text in_i_e;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it, in_i_e)
    local
      Tpl.Text txt;
      Tpl.Text i_e;

    case ( txt,
           DAE.UMINUS(ty = _),
           i_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(-"));
        txt = Tpl.writeText(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.UPLUS(ty = _),
           i_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NOT(),
           i_e )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UMINUS_ARR_NOT_IMPLEMENTED"));
      then txt;

    case ( txt,
           DAE.UPLUS_ARR(ty = _),
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("UPLUS_ARR_NOT_IMPLEMENTED"));
      then txt;

    case ( txt,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpUnary:ERR"));
      then txt;
  end matchcontinue;
end fun_129;

public function daeExpUnary
  input Tpl.Text txt;
  input DAE.Operator i_it;
  input DAE.Exp i_exp;
  input SimCode.Context i_context;
  input Tpl.Text i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
protected
  Tpl.Text i_e;
algorithm
  (i_e, out_i_preExp) := daeExp(emptyTxt, i_exp, i_context, i_preExp);
  out_txt := fun_129(txt, i_it, i_e);
end daeExpUnary;

protected function fun_131
  input Tpl.Text in_txt;
  input DAE.Operator in_i_op;
  input Tpl.Text in_i_e2;
  input Tpl.Text in_i_e1;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_op, in_i_e2, in_i_e1)
    local
      Tpl.Text txt;
      Tpl.Text i_e2;
      Tpl.Text i_e1;

    case ( txt,
           DAE.LESS(ty = DAE.ET_BOOL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.ET_STRING()),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.ET_INT()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESS(ty = DAE.ET_REAL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" < "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.ET_BOOL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.ET_STRING()),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.ET_INT()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATER(ty = DAE.ET_REAL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" > "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.ET_BOOL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(!"));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.ET_STRING()),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.ET_INT()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = DAE.ET_REAL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" <= "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.ET_BOOL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" || !"));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.ET_STRING()),
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_LINE("# string comparison not supported\n"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.ET_INT()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = DAE.ET_REAL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" >= "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.ET_BOOL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.ET_STRING()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.ET_INT()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.EQUAL(ty = DAE.ET_REAL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" == "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.ET_BOOL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("((!"));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(") || ("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" && !"));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("))"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.ET_STRING()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.ET_INT()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = DAE.ET_REAL()),
           i_e2,
           i_e1 )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_e1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" != "));
        txt = Tpl.writeText(txt, i_e2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then txt;

    case ( txt,
           _,
           _,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpRelation:ERR"));
      then txt;
  end matchcontinue;
end fun_131;

protected function fun_132
  input Tpl.Text in_txt;
  input String in_it;
  input Tpl.Text in_i_e2;
  input Tpl.Text in_i_e1;
  input DAE.Operator in_i_op;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it, in_i_e2, in_i_e1, in_i_op)
    local
      Tpl.Text txt;
      Tpl.Text i_e2;
      Tpl.Text i_e1;
      DAE.Operator i_op;

    case ( txt,
           "",
           i_e2,
           i_e1,
           i_op )
      equation
        txt = fun_131(txt, i_op, i_e2, i_e1);
      then txt;

    case ( txt,
           str_3,
           _,
           _,
           _ )
      local
        String str_3;
      equation
        txt = Tpl.writeStr(txt, str_3);
      then txt;
  end matchcontinue;
end fun_132;

public function daeExpRelation
  input Tpl.Text txt;
  input DAE.Operator i_op;
  input DAE.Exp i_exp1;
  input DAE.Exp i_exp2;
  input SimCode.Context i_context;
  input Tpl.Text i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
protected
  String str_3;
  Tpl.Text txt_2;
  Tpl.Text i_e2;
  Tpl.Text i_e1;
algorithm
  (i_e1, out_i_preExp) := daeExp(emptyTxt, i_exp1, i_context, i_preExp);
  (i_e2, out_i_preExp) := daeExp(emptyTxt, i_exp2, i_context, out_i_preExp);
  (txt_2, i_e1, i_e2, out_i_preExp) := daeExpSimRelation(emptyTxt, i_context, i_op, i_e1, i_e2, out_i_preExp);
  str_3 := Tpl.textString(txt_2);
  out_txt := fun_132(txt, str_3, i_e2, i_e1, i_op);
end daeExpRelation;

protected function fun_134
  input Tpl.Text in_txt;
  input DAE.Operator in_i_op;
  input Tpl.Text in_i_preExp;
  input Tpl.Text in_i_e2;
  input Tpl.Text in_i_e1;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
  output Tpl.Text out_i_e2;
  output Tpl.Text out_i_e1;
algorithm
  (out_txt, out_i_preExp, out_i_e2, out_i_e1) :=
  matchcontinue(in_txt, in_i_op, in_i_preExp, in_i_e2, in_i_e1)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      Tpl.Text i_e2;
      Tpl.Text i_e1;

    case ( txt,
           DAE.LESS(ty = _),
           i_preExp,
           i_e2,
           i_e1 )
      equation
        (txt, i_e1, i_e2, i_preExp) = SimRelationSimple(txt, i_e1, i_e2, " <", i_preExp);
      then (txt, i_preExp, i_e2, i_e1);

    case ( txt,
           DAE.LESSEQ(ty = _),
           i_preExp,
           i_e2,
           i_e1 )
      equation
        (txt, i_e1, i_e2, i_preExp) = SimRelationEqual(txt, i_e1, i_e2, " <", i_preExp);
      then (txt, i_preExp, i_e2, i_e1);

    case ( txt,
           DAE.GREATER(ty = _),
           i_preExp,
           i_e2,
           i_e1 )
      equation
        (txt, i_e1, i_e2, i_preExp) = SimRelationSimple(txt, i_e1, i_e2, " >", i_preExp);
      then (txt, i_preExp, i_e2, i_e1);

    case ( txt,
           DAE.GREATEREQ(ty = _),
           i_preExp,
           i_e2,
           i_e1 )
      equation
        (txt, i_e1, i_e2, i_preExp) = SimRelationEqual(txt, i_e1, i_e2, " >", i_preExp);
      then (txt, i_preExp, i_e2, i_e1);

    case ( txt,
           _,
           i_preExp,
           i_e2,
           i_e1 )
      then (txt, i_preExp, i_e2, i_e1);
  end matchcontinue;
end fun_134;

public function daeExpSimRelation
  input Tpl.Text in_txt;
  input SimCode.Context in_i_it;
  input DAE.Operator in_i_op;
  input Tpl.Text in_i_e1;
  input Tpl.Text in_i_e2;
  input Tpl.Text in_i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_e1;
  output Tpl.Text out_i_e2;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_e1, out_i_e2, out_i_preExp) :=
  matchcontinue(in_txt, in_i_it, in_i_op, in_i_e1, in_i_e2, in_i_preExp)
    local
      Tpl.Text txt;
      DAE.Operator i_op;
      Tpl.Text i_e1;
      Tpl.Text i_e2;
      Tpl.Text i_preExp;

    case ( txt,
           SimCode.SIMULATION(genDiscrete = _),
           i_op,
           i_e1,
           i_e2,
           i_preExp )
      equation
        (txt, i_preExp, i_e2, i_e1) = fun_134(txt, i_op, i_preExp, i_e2, i_e1);
      then (txt, i_e1, i_e2, i_preExp);

    case ( txt,
           _,
           _,
           i_e1,
           i_e2,
           i_preExp )
      then (txt, i_e1, i_e2, i_preExp);
  end matchcontinue;
end daeExpSimRelation;

public function SimRelationSimple
  input Tpl.Text txt;
  input Tpl.Text i_e1;
  input Tpl.Text i_e2;
  input String i_op;
  input Tpl.Text i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_e1;
  output Tpl.Text out_i_e2;
  output Tpl.Text out_i_preExp;
protected
  Tpl.Text i_res;
algorithm
  i_res := emptyTxt;
  out_i_preExp := Tpl.writeTok(i_preExp, Tpl.ST_STRING("// RELATION( "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeStr(out_i_preExp, i_op);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_LINE(" ) macro expansion\n"));
  (out_i_preExp, i_res) := tempDecl(out_i_preExp, "bool", i_res);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" = "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeStr(out_i_preExp, i_op);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("; if (!"));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_res);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" && isInUpdate && ("));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeStr(out_i_preExp, i_op);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("= "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(")) { SwapOldVars(); double res1 = "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" - "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(";  SwapOldVars12(); "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_res);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" = res1"));
  out_i_preExp := Tpl.writeStr(out_i_preExp, i_op);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("= ("));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" - "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("); SwapOldVars2(); }"));
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, i_res);
  out_i_e1 := i_e1;
  out_i_e2 := i_e2;
end SimRelationSimple;

public function SimRelationEqual
  input Tpl.Text txt;
  input Tpl.Text i_e1;
  input Tpl.Text i_e2;
  input String i_op;
  input Tpl.Text i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_e1;
  output Tpl.Text out_i_e2;
  output Tpl.Text out_i_preExp;
protected
  Tpl.Text i_res;
algorithm
  i_res := emptyTxt;
  out_i_preExp := Tpl.writeTok(i_preExp, Tpl.ST_STRING("// RELATION( "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeStr(out_i_preExp, i_op);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("= "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_LINE(" ) macro expansion\n"));
  (out_i_preExp, i_res) := tempDecl(out_i_preExp, "bool", i_res);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(";  if (isInUpdate) { "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_res);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" = "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeStr(out_i_preExp, i_op);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(";  if(!"));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_res);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" && ("));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeStr(out_i_preExp, i_op);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("= "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(")) {  SwapOldVars(); double res1 = "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" - "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(";  SwapOldVars12(); "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_res);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" = res1"));
  out_i_preExp := Tpl.writeStr(out_i_preExp, i_op);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("= ("));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" - "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("); SwapOldVars2(); }  } else "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_res);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" = "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e1);
  out_i_preExp := Tpl.writeStr(out_i_preExp, i_op);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("= "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_e2);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(";"));
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, i_res);
  out_i_e1 := i_e1;
  out_i_e2 := i_e2;
end SimRelationEqual;

public function daeExpIf
  input Tpl.Text txt;
  input DAE.Exp i_cond;
  input DAE.Exp i_then__;
  input DAE.Exp i_else__;
  input SimCode.Context i_context;
  input Tpl.Text i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
protected
  Tpl.Text txt_6;
  Tpl.Text i_eElse;
  Tpl.Text i_preExpElse;
  Tpl.Text i_eThen;
  Tpl.Text i_preExpThen;
  Tpl.Text i_resVar;
  Tpl.Text i_condExp;
algorithm
  (i_condExp, out_i_preExp) := daeExp(emptyTxt, i_cond, i_context, i_preExp);
  i_resVar := emptyTxt;
  i_preExpThen := emptyTxt;
  (i_eThen, i_preExpThen) := daeExp(emptyTxt, i_then__, i_context, i_preExpThen);
  i_preExpElse := emptyTxt;
  (i_eElse, i_preExpElse) := daeExp(emptyTxt, i_else__, i_context, i_preExpElse);
  txt_6 := expTypeFromExpArrayIf(emptyTxt, i_then__);
  (out_i_preExp, i_resVar) := tempDecl(out_i_preExp, Tpl.textString(txt_6), i_resVar);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING_LIST({
                                                 ";\n",
                                                 "if ("
                                             }, false));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_condExp);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(") { //cond type is "));
  out_i_preExp := expTypeFromExp(out_i_preExp, i_cond);
  out_i_preExp := Tpl.softNewLine(out_i_preExp);
  out_i_preExp := Tpl.pushBlock(out_i_preExp, Tpl.BT_INDENT(2));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_preExpThen);
  out_i_preExp := Tpl.softNewLine(out_i_preExp);
  out_i_preExp := Tpl.writeText(out_i_preExp, i_resVar);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" = "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_eThen);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_LINE(";\n"));
  out_i_preExp := Tpl.popBlock(out_i_preExp);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_LINE("} else {\n"));
  out_i_preExp := Tpl.pushBlock(out_i_preExp, Tpl.BT_INDENT(2));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_preExpElse);
  out_i_preExp := Tpl.softNewLine(out_i_preExp);
  out_i_preExp := Tpl.writeText(out_i_preExp, i_resVar);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" = "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_eElse);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_LINE(";\n"));
  out_i_preExp := Tpl.popBlock(out_i_preExp);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("}"));
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, i_resVar);
end daeExpIf;

protected function fun_139
  input Tpl.Text in_txt;
  input DAE.Exp in_i_e2;
  input Tpl.Text in_i_msg;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;
  input Tpl.Text in_i_var1;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_i_e2, in_i_msg, in_i_preExp, in_i_context, in_i_var1)
    local
      Tpl.Text txt;
      Tpl.Text i_msg;
      Tpl.Text i_preExp;
      SimCode.Context i_context;
      Tpl.Text i_var1;

    case ( txt,
           (i_e2 as DAE.RCONST(real = _)),
           _,
           i_preExp,
           i_context,
           i_var1 )
      local
        DAE.Exp i_e2;
      equation
        txt = Tpl.writeText(txt, i_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        (txt, i_preExp) = daeExp(txt, i_e2, i_context, i_preExp);
      then (txt, i_preExp);

    case ( txt,
           i_e2,
           i_msg,
           i_preExp,
           i_context,
           i_var1 )
      local
        DAE.Exp i_e2;
        Tpl.Text i_var2;
      equation
        (i_var2, i_preExp) = daeExp(emptyTxt, i_e2, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("!=0.0 ? "));
        txt = Tpl.writeText(txt, i_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/"));
        txt = Tpl.writeText(txt, i_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(" : DivBy0("));
        txt = Tpl.writeText(txt, i_var1);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        txt = Tpl.writeText(txt, i_var2);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(",\""));
        txt = Tpl.writeText(txt, i_msg);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("\"))"));
      then (txt, i_preExp);
  end matchcontinue;
end fun_139;

protected function fun_140
  input Tpl.Text in_txt;
  input DAE.ExpType in_i_arg_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_arg_ty)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("(int)"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_140;

protected function lm_141
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_items, in_i_preExp, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      SimCode.Context i_context;

    case ( txt,
           {},
           i_preExp,
           _ )
      then (txt, i_preExp);

    case ( txt,
           i_it :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Exp> rest;
        DAE.Exp i_it;
      equation
        (txt, i_preExp) = daeExp(txt, i_it, i_context, i_preExp);
        txt = Tpl.nextIter(txt);
        (txt, i_preExp) = lm_141(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);

    case ( txt,
           _ :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Exp> rest;
      equation
        (txt, i_preExp) = lm_141(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);
  end matchcontinue;
end lm_141;

protected function lm_142
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_items, in_i_preExp, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      SimCode.Context i_context;

    case ( txt,
           {},
           i_preExp,
           _ )
      then (txt, i_preExp);

    case ( txt,
           i_it :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Exp> rest;
        DAE.Exp i_it;
      equation
        (txt, i_preExp) = daeExp(txt, i_it, i_context, i_preExp);
        txt = Tpl.nextIter(txt);
        (txt, i_preExp) = lm_142(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);

    case ( txt,
           _ :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Exp> rest;
      equation
        (txt, i_preExp) = lm_142(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);
  end matchcontinue;
end lm_142;

protected function fun_143
  input Tpl.Text in_txt;
  input Boolean in_i_builtin;
  input Tpl.Text in_i_funName;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_builtin, in_i_funName)
    local
      Tpl.Text txt;
      Tpl.Text i_funName;

    case ( txt,
           false,
           i_funName )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* !!!TODO:."));
        txt = Tpl.writeText(txt, i_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_rettype_1 */"));
      then txt;

    case ( txt,
           _,
           _ )
      then txt;
  end matchcontinue;
end fun_143;

public function daeExpCall
  input Tpl.Text in_txt;
  input DAE.Exp in_i_it;
  input SimCode.Context in_i_context;
  input Tpl.Text in_i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_i_it, in_i_context, in_i_preExp)
    local
      Tpl.Text txt;
      SimCode.Context i_context;
      Tpl.Text i_preExp;

    case ( txt,
           DAE.CALL(tuple_ = false, builtin = true, path = Absyn.IDENT(name = "DIVISION"), expLst = {i_e1, i_e2, DAE.SCONST(string = i_string)}),
           i_context,
           i_preExp )
      local
        String i_string;
        DAE.Exp i_e2;
        DAE.Exp i_e1;
        String ret_2;
        Tpl.Text i_msg;
        Tpl.Text i_var1;
      equation
        (i_var1, i_preExp) = daeExp(emptyTxt, i_e1, i_context, i_preExp);
        ret_2 = Util.escapeModelicaStringToCString(i_string);
        i_msg = Tpl.writeStr(emptyTxt, ret_2);
        (txt, i_preExp) = fun_139(txt, i_e2, i_msg, i_preExp, i_context, i_var1);
      then (txt, i_preExp);

    case ( txt,
           DAE.CALL(tuple_ = false, builtin = true, path = Absyn.IDENT(name = "pre"), expLst = {(i_arg as DAE.CREF(ty = i_arg_ty, componentRef = i_arg_componentRef))}),
           _,
           i_preExp )
      local
        DAE.ComponentRef i_arg_componentRef;
        DAE.ExpType i_arg_ty;
        DAE.Exp i_arg;
      equation
        txt = fun_140(txt, i_arg_ty);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Pre_"));
        txt = cref(txt, i_arg_componentRef);
      then (txt, i_preExp);

    case ( txt,
           DAE.CALL(tuple_ = false, builtin = true, path = Absyn.IDENT(name = "min"), expLst = {i_e1, i_e2}),
           i_context,
           i_preExp )
      local
        DAE.Exp i_e2;
        DAE.Exp i_e1;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Min("));
        (txt, i_preExp) = daeExp(txt, i_e1, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        (txt, i_preExp) = daeExp(txt, i_e2, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, i_preExp);

    case ( txt,
           DAE.CALL(tuple_ = false, builtin = true, path = Absyn.IDENT(name = "max"), expLst = {i_e1, i_e2}),
           i_context,
           i_preExp )
      local
        DAE.Exp i_e2;
        DAE.Exp i_e1;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Max("));
        (txt, i_preExp) = daeExp(txt, i_e1, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(","));
        (txt, i_preExp) = daeExp(txt, i_e2, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, i_preExp);

    case ( txt,
           DAE.CALL(tuple_ = false, builtin = true, path = Absyn.IDENT(name = "log"), expLst = {i_s1}),
           i_context,
           i_preExp )
      local
        DAE.Exp i_s1;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Log("));
        (txt, i_preExp) = daeExp(txt, i_s1, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, i_preExp);

    case ( txt,
           DAE.CALL(tuple_ = false, builtin = true, path = Absyn.IDENT(name = "exp"), expLst = {i_s1}),
           i_context,
           i_preExp )
      local
        DAE.Exp i_s1;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Exp("));
        (txt, i_preExp) = daeExp(txt, i_s1, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, i_preExp);

    case ( txt,
           DAE.CALL(tuple_ = false, builtin = true, path = Absyn.IDENT(name = "sin"), expLst = {i_s1}),
           i_context,
           i_preExp )
      local
        DAE.Exp i_s1;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("Math.Sin("));
        (txt, i_preExp) = daeExp(txt, i_s1, i_context, i_preExp);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
      then (txt, i_preExp);

    case ( txt,
           DAE.CALL(tuple_ = false, ty = DAE.ET_NORETCALL(), expLst = i_expLst, builtin = i_builtin, path = i_path),
           i_context,
           i_preExp )
      local
        Absyn.Path i_path;
        Boolean i_builtin;
        list<DAE.Exp> i_expLst;
        Tpl.Text i_argStr;
      equation
        i_argStr = Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (i_argStr, i_preExp) = lm_141(i_argStr, i_expLst, i_preExp, i_context);
        i_argStr = Tpl.popIter(i_argStr);
        i_preExp = underscorePrefix(i_preExp, i_builtin);
        i_preExp = underscorePath(i_preExp, i_path);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING("("));
        i_preExp = Tpl.writeText(i_preExp, i_argStr);
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_STRING(");"));
        i_preExp = Tpl.writeTok(i_preExp, Tpl.ST_NEW_LINE());
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/* NORETCALL */"));
      then (txt, i_preExp);

    case ( txt,
           DAE.CALL(tuple_ = false, expLst = i_expLst, path = i_path, builtin = i_builtin),
           i_context,
           i_preExp )
      local
        Boolean i_builtin;
        Absyn.Path i_path;
        list<DAE.Exp> i_expLst;
        Tpl.Text i_funName;
        Tpl.Text i_argStr;
      equation
        i_argStr = Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
        (i_argStr, i_preExp) = lm_142(i_argStr, i_expLst, i_preExp, i_context);
        i_argStr = Tpl.popIter(i_argStr);
        i_funName = underscorePath(emptyTxt, i_path);
        txt = underscorePrefix(txt, i_builtin);
        txt = Tpl.writeText(txt, i_funName);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = Tpl.writeText(txt, i_argStr);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        txt = fun_143(txt, i_builtin, i_funName);
      then (txt, i_preExp);

    case ( txt,
           _,
           _,
           i_preExp )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("daeExpCall:NOT_YET_IMPLEMENTED"));
      then (txt, i_preExp);
  end matchcontinue;
end daeExpCall;

protected function fun_145
  input Tpl.Text in_txt;
  input Boolean in_i_scalar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_scalar)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("NON_SCALAR_ARRAY_notYetImplemeted"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end fun_145;

protected function fun_146
  input Tpl.Text in_txt;
  input Boolean in_i_scalar;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_scalar)
    local
      Tpl.Text txt;

    case ( txt,
           false )
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("&"));
      then txt;
  end matchcontinue;
end fun_146;

protected function lm_147
  input Tpl.Text in_txt;
  input list<DAE.Exp> in_items;
  input Tpl.Text in_i_preExp;
  input SimCode.Context in_i_context;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
algorithm
  (out_txt, out_i_preExp) :=
  matchcontinue(in_txt, in_items, in_i_preExp, in_i_context)
    local
      Tpl.Text txt;
      Tpl.Text i_preExp;
      SimCode.Context i_context;

    case ( txt,
           {},
           i_preExp,
           _ )
      then (txt, i_preExp);

    case ( txt,
           i_e :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Exp> rest;
        DAE.Exp i_e;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("("));
        txt = expTypeFromExp(txt, i_e);
        txt = Tpl.writeTok(txt, Tpl.ST_STRING(")"));
        (txt, i_preExp) = daeExp(txt, i_e, i_context, i_preExp);
        txt = Tpl.nextIter(txt);
        (txt, i_preExp) = lm_147(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);

    case ( txt,
           _ :: rest,
           i_preExp,
           i_context )
      local
        list<DAE.Exp> rest;
      equation
        (txt, i_preExp) = lm_147(txt, rest, i_preExp, i_context);
      then (txt, i_preExp);
  end matchcontinue;
end lm_147;

protected function smf_148
  input Tpl.Text in_txt;
  input Tpl.StringToken in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.StringToken i_it;
      equation
        txt = Tpl.writeTok(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_148;

protected function smf_149
  input Tpl.Text in_txt;
  input Tpl.Text in_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_it)
    local
      Tpl.Text txt;

    case ( txt,
           i_it )
      local
        Tpl.Text i_it;
      equation
        txt = Tpl.writeText(txt, i_it);
        txt = Tpl.nextIter(txt);
      then txt;
  end matchcontinue;
end smf_149;

public function daeExpArray
  input Tpl.Text txt;
  input DAE.ExpType i_ty;
  input Boolean i_scalar;
  input list<DAE.Exp> i_array;
  input SimCode.Context i_context;
  input Tpl.Text i_preExp;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_preExp;
protected
  Tpl.Text i_params;
  Tpl.Text i_scalarRef;
  Tpl.Text i_scalarPrefix;
  Tpl.Text i_arrayVar;
  Tpl.Text i_arrayTypeStr;
algorithm
  i_arrayTypeStr := expTypeArray(emptyTxt, i_ty);
  i_arrayVar := emptyTxt;
  i_scalarPrefix := fun_145(emptyTxt, i_scalar);
  i_scalarRef := fun_146(emptyTxt, i_scalar);
  i_params := Tpl.pushIter(emptyTxt, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  (i_params, out_i_preExp) := lm_147(i_params, i_array, i_preExp, i_context);
  i_params := Tpl.popIter(i_params);
  out_i_preExp := Tpl.writeText(out_i_preExp, i_scalarPrefix);
  (out_i_preExp, i_arrayVar) := tempDecl(out_i_preExp, Tpl.textString(i_arrayTypeStr), i_arrayVar);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" = new "));
  out_i_preExp := Tpl.writeText(out_i_preExp, i_arrayTypeStr);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING("{ "));
  out_i_preExp := Tpl.pushIter(out_i_preExp, Tpl.ITER_OPTIONS(0, NONE, SOME(Tpl.ST_STRING(", ")), 0, 0, Tpl.ST_NEW_LINE(), 0, Tpl.ST_NEW_LINE()));
  out_i_preExp := smf_148(out_i_preExp, Tpl.ST_STRING("0.0"));
  out_i_preExp := smf_149(out_i_preExp, i_params);
  out_i_preExp := Tpl.popIter(out_i_preExp);
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_STRING(" };"));
  out_i_preExp := Tpl.writeTok(out_i_preExp, Tpl.ST_NEW_LINE());
  out_txt := Tpl.writeText(txt, i_arrayVar);
end daeExpArray;

public function underscorePrefix
  input Tpl.Text in_txt;
  input Boolean in_i_builtin;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_builtin)
    local
      Tpl.Text txt;

    case ( txt,
           true )
      then txt;

    case ( txt,
           false )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("_"));
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end underscorePrefix;

public function tempDecl
  input Tpl.Text txt;
  input String i_ty;
  input Tpl.Text i_newVar;

  output Tpl.Text out_txt;
  output Tpl.Text out_i_newVar;
protected
  Integer ret_0;
algorithm
  out_i_newVar := Tpl.writeTok(i_newVar, Tpl.ST_STRING("_tmp"));
  ret_0 := System.tmpTick();
  out_i_newVar := Tpl.writeStr(out_i_newVar, intString(ret_0));
  out_txt := Tpl.writeStr(txt, i_ty);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING(" "));
  out_txt := Tpl.writeText(out_txt, out_i_newVar);
end tempDecl;

public function expShortType
  input Tpl.Text in_txt;
  input DAE.ExpType in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ET_INT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.ET_REAL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.ET_STRING() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.ET_BOOL() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.ET_OTHER() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("#complex#"));
      then txt;

    case ( txt,
           DAE.ET_ARRAY(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ET_COMPLEX(name = i_name) )
      local
        Absyn.Path i_name;
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("/*struct*/"));
        txt = underscorePath(txt, i_name);
      then txt;

    case ( txt,
           _ )
      then txt;
  end matchcontinue;
end expShortType;

public function expTypeArray
  input Tpl.Text txt;
  input DAE.ExpType i_ty;

  output Tpl.Text out_txt;
algorithm
  out_txt := expShortType(txt, i_ty);
  out_txt := Tpl.writeTok(out_txt, Tpl.ST_STRING("[]"));
end expTypeArray;

public function expTypeFromExpArrayIf
  input Tpl.Text txt;
  input DAE.Exp i_exp;

  output Tpl.Text out_txt;
algorithm
  out_txt := expTypeFromExp(txt, i_exp);
end expTypeFromExpArrayIf;

public function expTypeFromExp
  input Tpl.Text in_txt;
  input DAE.Exp in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ICONST(integer = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("int"));
      then txt;

    case ( txt,
           DAE.RCONST(real = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("double"));
      then txt;

    case ( txt,
           DAE.SCONST(string = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("string"));
      then txt;

    case ( txt,
           DAE.BCONST(bool = _) )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.BINARY(operator = i_operator) )
      local
        DAE.Operator i_operator;
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.UNARY(operator = i_operator) )
      local
        DAE.Operator i_operator;
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.LBINARY(operator = i_operator) )
      local
        DAE.Operator i_operator;
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.LUNARY(operator = i_operator) )
      local
        DAE.Operator i_operator;
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.RELATION(operator = i_operator) )
      local
        DAE.Operator i_operator;
      equation
        txt = expTypeFromOp(txt, i_operator);
      then txt;

    case ( txt,
           DAE.IFEXP(expThen = i_expThen) )
      local
        DAE.Exp i_expThen;
      equation
        txt = expTypeFromExp(txt, i_expThen);
      then txt;

    case ( txt,
           DAE.CALL(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ARRAY(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MATRIX(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.RANGE(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.CAST(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.CREF(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.CODE(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ASUB(exp = i_exp) )
      local
        DAE.Exp i_exp;
      equation
        txt = expTypeFromExp(txt, i_exp);
      then txt;

    case ( txt,
           DAE.REDUCTION(expr = i_expr) )
      local
        DAE.Exp i_expr;
      equation
        txt = expTypeFromExp(txt, i_expr);
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeFromExp:ERROR"));
      then txt;
  end matchcontinue;
end expTypeFromExp;

public function expTypeFromOp
  input Tpl.Text in_txt;
  input DAE.Operator in_i_it;

  output Tpl.Text out_txt;
algorithm
  out_txt :=
  matchcontinue(in_txt, in_i_it)
    local
      Tpl.Text txt;

    case ( txt,
           DAE.ADD(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.UMINUS(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.UPLUS(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.UMINUS_ARR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.UPLUS_ARR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ADD_ARR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB_ARR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_ARR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV_ARR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_SCALAR_ARRAY(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_ARRAY_SCALAR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ADD_SCALAR_ARRAY(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.ADD_ARRAY_SCALAR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB_SCALAR_ARRAY(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.SUB_ARRAY_SCALAR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_SCALAR_PRODUCT(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.MUL_MATRIX_PRODUCT(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV_ARRAY_SCALAR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.DIV_SCALAR_ARRAY(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_ARRAY_SCALAR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_SCALAR_ARRAY(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_ARR(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.POW_ARR2(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.LESS(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.LESSEQ(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.GREATER(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.GREATEREQ(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.EQUAL(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.NEQUAL(ty = i_ty) )
      local
        DAE.ExpType i_ty;
      equation
        txt = expShortType(txt, i_ty);
      then txt;

    case ( txt,
           DAE.AND() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.OR() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           DAE.NOT() )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("bool"));
      then txt;

    case ( txt,
           _ )
      equation
        txt = Tpl.writeTok(txt, Tpl.ST_STRING("expTypeFromOp:ERROR"));
      then txt;
  end matchcontinue;
end expTypeFromOp;

end SimCodeCSharp;