// This file defines templates for transforming Modelica code to C# code.

spackage SimCodeCSharp

typeview "SimCodeTV.mo"

// SECTION: SIMULATION TARGET, ROOT TEMPLATE

template translateModel(SimCode simCode) ::=
  match simCode
  case SIMCODE(modelInfo = MODELINFO(__)) then
    let csFileContent = csFile(simCode)
    let()= textFile(csFileContent, '<%modelInfo.name%>.cs')
    "" // empty result of the top-level template .., only side effects
end translateModel;


// SECTION: SIMULATION TARGET, C# FILE SPECIFIC TEMPLATES

template csFile(SimCode simCode) ::=
match simCode
case sc as SIMCODE(modelInfo = MODELINFO(__)) then
<<
// Simulation code for <%modelInfo.name%> generated by the OpenModelica Compiler.

using System;
using Bodylight.Solvers;
namespace Bodylight.Models
{
  public partial class <%modelInfo.name%> : DAESystem
  {
         
    <%modelDataMembers(modelInfo)%>

    <%functionDaeOutput(nonStateContEquations, removedEquations)%>

    <%functionDaeOutput2(nonStateDiscEquations, removedEquations)%>

    <%functionInput(modelInfo)%>

    <%functionOutput(modelInfo)%>

    <%functionZeroCrossing(zeroCrossings)%>

    <%functionHandleZeroCrossing(zeroCrossingsNeedSave)%>

    <%functionUpdateDependents(allEquations, helpVarInfo)%>
    
    <%functionUpdateDepend(allEquations, helpVarInfo)%>

    <%functionOnlyZeroCrossing(zeroCrossings)%>

    <%functionStoreDelayed()%>
    
    <%functionWhen(whenClauses)%>

    <%functionOde(stateContEquations)%>

    <%functionInitial(initialEquations)%>

    <%functionInitialResidual(residualEquations)%>
    
    <%functionExtraResudials(allEquations)%>
    
    <%functionBoundParameters(parameterEquations)%>

    <%functionCheckForDiscreteVarChanges(sc.helpVarInfo, sc.discreteModelVars)%>
    
  }
}
>>
end csFile;

template modelDataMembers(ModelInfo modelInfo) ::=
match modelInfo
case MODELINFO(varInfo = VARINFO(__), vars = SIMVARS(__)) then
<<
const int 
  NHELP = <%varInfo.numHelpVars%>, NG = <%varInfo.numZeroCrossings%>,
  NX = <%varInfo.numStateVars%>, NY = <%varInfo.numAlgVars%>, NP = <%varInfo.numParams%>,
  NO = <%varInfo.numOutVars%>, NI = <%varInfo.numInVars%>, NR = <%varInfo.numResiduals%>,
  NEXT = <%varInfo.numExternalObjects%>, NYSTR = <%varInfo.numStringAlgVars%>, NPSTR = <%varInfo.numStringParamVars%>;

public override string ModelName  { get { return "<%name%>"; }}
public override int HelpVarsCount      { get { return NHELP; } }
public override int ZeroCrossingsCount { get { return NG; } }
public override int StatesCount        { get { return NX; } }
public override int AlgebraicsCount    { get { return NY; } }
public override int ParametersCount    { get { return NP; } }
        
public override int OutputsCount   { get { return NO; } }
public override int InputsCount    { get { return NI; } }
public override int ResidualsCount { get { return NR; } }
//public int ExternalObjectsCount { get { return NEXT; } }        
public override int MaximumOrder { get { return 5; } }
public override int StringVarsCount { get { return NYSTR; } }
public override int StringParametersCount { get { return NPSTR; } }

<%vars.stateVars |> SIMVAR(__) => <<
public double <%cref(name)%> { get { return states[<%index%>]; } set { states[<%index%>] = value; }}
>> ;separator="\n"%>
<%vars.derivativeVars |> SIMVAR(__) => <<
public double <%cref(name)%> { get { return statesDerivatives[<%index%>]; } set { statesDerivatives[<%index%>] = value; }}
>> ;separator="\n"%>
  
<%vars.algVars |> SIMVAR(__) => <<
public double <%cref(name)%> { get { return algebraics[<%index%>]; } set { algebraics[<%index%>] = value; }}
public double Pre_<%cref(name)%> { get { return savedAlgebraics[<%index%>]; } set { savedAlgebraics[<%index%>] = value; }}
>> ;separator="\n"%>
<%vars.paramVars |> SIMVAR(__) => <<
public double <%cref(name)%> { get { return parameters[<%index%>]; } set { parameters[<%index%>] = value; }}
>> ;separator="\n"%>

private static readonly SimVarInfo[] VariableInfosStatic = new[] {
	<%{  
		(vars.stateVars |> SIMVAR(__) => <<
		new SimVarInfo( "<%crefSubscript(name)%>", "<%comment%>", SimVarType.State, <%index%>, false)
		>> ;separator=",\n"),
		(vars.derivativeVars |> SIMVAR(__) => <<
		new SimVarInfo( "<%crefSubscript(name)%>", "<%comment%>", SimVarType.StateDer, <%index%>, false)
		>> ;separator=",\n"),
		(vars.algVars |> SIMVAR(__) => <<
		new SimVarInfo( "<%crefSubscript(name)%>", "<%comment%>", SimVarType.Algebraic, <%index%>, false)
		>> ;separator=",\n"),
		(vars.paramVars |> SIMVAR(__) => <<
		new SimVarInfo( "<%crefSubscript(name)%>", "<%comment%>", SimVarType.Parameter, <%index%>, true)
		>> ;separator=",\n")
	} ;separator=",\n\n"%>
};
public override SimVarInfo[] VariableInfos { get { return VariableInfosStatic; } }

private static readonly bool[] InitialFixedStatic = new bool[NX + NX + NY + NP] {
    <%{ (if vars.stateVars      then "//states\n" + initFixed(vars.stateVars)),
        (if vars.derivativeVars then "//derivatives\n" + initFixed(vars.derivativeVars)),
        (if vars.algVars        then "//algebraics\n" + initFixed(vars.algVars)), 
        (if vars.paramVars      then "//parameters\n" + initFixed(vars.paramVars))
      } ;separator=",\n"%>
};
public override bool[] InitialFixed { get { return InitialFixedStatic; } }

public <%name%>() {
    CreateData();
}

<%/*
    //a kind of SimulationVarInfo list will be created here
    //and statically promoted to interface/override implementation
	<%utilStaticStringArray("StateNames", vars.stateVars)%>
	<%utilStaticStringArray("DerivativeNames", vars.derivativeVars)%>
	<%utilStaticStringArray("AlgvarsNames", vars.algVars)%>
	<%utilStaticStringArray("InputNames", vars.inputVars)%>
	<%utilStaticStringArray("OutputNames", vars.outputVars)%>
	<%utilStaticStringArray("ParamNames", vars.paramVars)%>
	<%utilStaticStringArray("StringAlgNames", vars.stringAlgVars)%>
	<%utilStaticStringArray("StringParamNames", vars.stringParamVars)%>
	
	<%utilStaticStringArrayComment("StateComments", vars.stateVars)%>
	<%utilStaticStringArrayComment("DerivativeComments", vars.derivativeVars)%>
	<%utilStaticStringArrayComment("algvars_comments", vars.algVars)%>
	<%utilStaticStringArrayComment("input_comments", vars.inputVars)%>
	<%utilStaticStringArrayComment("output_comments", vars.outputVars)%>
	<%utilStaticStringArrayComment("param_comments", vars.paramVars)%>
	<%utilStaticStringArrayComment("string_alg_comments", vars.stringAlgVars)%>
	<%utilStaticStringArrayComment("string_param_comments", vars.stringParamVars)%>
*/%>

>>
end modelDataMembers;

template initFixed(list<SimVar> simVarLst) ::=
  (simVarLst |> SIMVAR(__) => '<%isFixed%> /* <%crefSubscript(name)%> */' ;separator=",\n")
end initFixed;

template functionDaeOutput(list<SimEqSystem> nonStateContEquations,
                  list<SimEqSystem> removedEquations) ::=
let()= System.tmpTickReset(1)
<<
/* for continuous time variables */
public override void FunDAEOutput()
{
  <%nonStateContEquations |> it => equation_(it,contextSimulationNonDiscrete) ;separator="\n"%>
  <%removedEquations      |> it => equation_(it,contextSimulationNonDiscrete) ;separator="\n"%>
}
>>
end functionDaeOutput;

template functionDaeOutput2(list<SimEqSystem> nonStateDiscEquations,
                   list<SimEqSystem> removedEquations) ::=
let()= System.tmpTickReset(1)
<<
/* for discrete time variables */
public override void FunDAEOutput2()
{
  <%nonStateDiscEquations |> it => equation_(it,contextSimulationDiscrete) ;separator="\n"%>
  <%removedEquations      |> it => equation_(it,contextSimulationDiscrete) ;separator="\n"%>
}
>>
end functionDaeOutput2;

template functionInput(ModelInfo modelInfo) ::=
match modelInfo
case MODELINFO(varInfo = VARINFO(__), vars = SIMVARS(__)) then
<<
public override void InputFun()
{
  <%vars.inputVars |> SIMVAR(__) indexedby i0 => 
  <<
  <%cref(name)%> = inputVars[<%i0%>];
  >> ;separator="\n"%>
}
>>
end functionInput;

template functionOutput(ModelInfo modelInfo) ::=
match modelInfo
case MODELINFO(varInfo = VARINFO(__), vars = SIMVARS(__)) then
<<
public override void OutputFun()
{
  /* not yet
  <%vars.outputVars |> SIMVAR(__) indexedby i0 =>
  <<
  outputVars[<%i0%>] = <%cref(name)%>;
  >> ;separator="\n"%>
  */
}
>>
end functionOutput;

template functionZeroCrossing(list<ZeroCrossing> zeroCrossingLst) ::=
let()= System.tmpTickReset(1)
<<
public override void FunZeroCrossing(double time, double[] x, double[] xd, double[] gout)
{
  var timeBackup = this.time;
  this.time = time;

  FunODE();
  FunDAEOutput();
  
  <%zeroCrossingLst |> ZERO_CROSSING(__) indexedby i0 => zeroCrossing(relation_, i0) ;separator="\n"%>  

  this.time = timeBackup;
}
>>
end functionZeroCrossing;

// This function should only save in cases. The rest is done in
// function_updateDependents.
template functionHandleZeroCrossing(list<list<SimVar>> zeroCrossingsNeedSave) ::=
<<
public override void FunHandleZeroCrossing(int index)
{  
  switch(index) {
    <%zeroCrossingsNeedSave |> vars indexedby i0 =>
    <<
    case <%i0%>:
      <%vars |> SIMVAR(__) => 'Pre_<%cref(name)%> = <%cref(name)%>; //save()' ;separator="\n"%>
      break;
    >> ;separator="\n"%>
    default:
       break;
  }
}
>>
end functionHandleZeroCrossing;

template functionUpdateDependents(list<SimEqSystem> allEquations, list<HelpVarInfo> helpVarInfoLst) ::=
let()= System.tmpTickReset(1)
<<
public override void FunUpdateDependents()
{
  //inUpdate=initial()?0:1;
  isInUpdate = ! isInit;

  <%allEquations |> it => equation_(it, contextSimulationDiscrete) ;separator="\n"%>
  <%helpVarInfoLst |> (in1, exp, _)  =>
      let &preExp = buffer ""
      let expPart = daeExp(exp, contextSimulationDiscrete, &preExp)
      <<
      <%preExp%>
      helpVars[<%in1%>] = <%expPart%> ? 1.0 : 0.0;<%/*???TODO: ? 1.0 : 0.0;*/%>
      >>
  ;separator="\n"%>

  isInUpdate = false;
}
>>
end functionUpdateDependents;

// All when equations should go in here too according to Willi
// And something about if-eqs being sorted ans not just added to end
template functionUpdateDepend(list<SimEqSystem> allEquations, list<HelpVarInfo> helpVarInfoLst) ::=
let()= System.tmpTickReset(1)
<<
public override void FunUpdateDepend()
{
  isInUpdate = ! isInit;
  
  <%allEquations |> it => equation_(it, contextSimulationDiscrete) ;separator="\n"%>
  <%helpVarInfoLst |> (in1, exp, _)  =>
      let &preExp = buffer ""
      let expPart = daeExp(exp, contextSimulationDiscrete, &preExp)
      <<
      <%preExp%>
      helpVars[<%in1%>] = <%expPart%> ? 1.0 : 0.0;<%/*???TODO: ? 1.0 : 0.0;*/%>
      >>
  ;separator="\n"%>

  isInUpdate = false;
}
>>
end functionUpdateDepend;

template functionOnlyZeroCrossing(list<ZeroCrossing> zeroCrossingLst) ::=
let()= System.tmpTickReset(1)
<<
public override void FunOnlyZeroCrossings(double time, double[] gout) //TODO:??time in original is *t only ... how is it called?
{
  <%zeroCrossingLst |> ZERO_CROSSING(__) indexedby i0 => zeroCrossing(relation_, i0) ;separator="\n"%>  
}
>>
end functionOnlyZeroCrossing;

template zeroCrossing(Exp it, Integer index) ::=
  match it
  case RELATION(__) then
    let &preExp = buffer ""
    let e1 = daeExp(exp1, contextOther, &preExp)
    let e2 = daeExp(exp2, contextOther, &preExp)
    <<
    {<%preExp%>var _zen = zeroCrossingEnabled[<%index%>]; //ZEROCROSSING(<%index%>, <%zeroCrossingOpFunc(operator)%>(<%e1%>, <%e2%>));
    gout[<%index%>] = (_zen != 0) ? _zen * (<%match operator
                                           case LESS(__)
                                           case LESSEQ(__)    then '<%e1%>-<%e2%>'
                                           case GREATER(__)
                                           case GREATEREQ(__) then '<%e2%>-<%e1%>'
                                          %>) : 1.0; }
    >>    
  case CALL(path=IDENT(name="sample"), expLst={start, interval}) then
    let &preExp = buffer ""
    let eStart = daeExp(start, contextOther, &preExp)
    let eInterval = daeExp(interval, contextOther, &preExp)
    <<
    {<%preExp%>var _zen = zeroCrossingEnabled[<%index%>]; //ZEROCROSSING(<%index%>, Sample(*t, <%eStart%>, <%eInterval%>));
    gout[<%index%>] = (_zen != 0) ? _zen * Sample(time, <%eStart%>, <%eInterval%>) : 1.0; }
    >> 
  case _ then
    <<
    ZERO_CROSSING_ERROR
    >>
end zeroCrossing;

template zeroCrossingOpFunc(Operator it) ::=
  match it
  case LESS(__)      then "Less"
  case GREATER(__)   then "Greater"
  case LESSEQ(__)    then "LessEq"
  case GREATEREQ(__) then "GreaterEq"
end zeroCrossingOpFunc;

// New runtime function. What should it do?
template functionStoreDelayed() ::=
let()= System.tmpTickReset(1)
<<
public override void FunStoreDelayed()
{  
}
>>
end functionStoreDelayed;

template functionWhen(list<SimWhenClause> whenClauses) ::=
let()= System.tmpTickReset(1)
<<
public override void FunWhen(int i)
{
  switch(i) {
    <%whenClauses |> SIM_WHEN_CLAUSE(__) indexedby i0 =>
    <<
    case <%i0%>:
      <%functionWhen_caseEquation(whenEq)%>
      <%reinits |> REINIT(__)  =>
        let &preExp = buffer ""
        let valueExp = daeExp(value, contextSimulationDiscrete, &preExp)
      <<
      <%preExp%>
      <%cref(stateVar)%> = <%valueExp%>;
      >> ;separator="\n"%>
      break;
    >> ;separator="\n"%>
    default:
      break;
  }
}
>>
end functionWhen;

template functionWhen_caseEquation(Option<WhenEquation> it) ::=
match it
case SOME(weq as WHEN_EQ(__)) then
let &preExp = buffer ""
let expPart = daeExp(weq.right, contextSimulationDiscrete, &preExp)
<<
Pre_<%cref(weq.left)%> = <%cref(weq.left)%>; //save()
<%preExp%>
<%cref(weq.left)%> = <%expPart%>;
>>
end functionWhen_caseEquation;

template functionOde(list<SimEqSystem> stateContEquations) ::=
let()= System.tmpTickReset(1)
<<
public override void FunODE()
{
  <%stateContEquations |> it => equation_(it, contextOther) ;separator="\n"%>
}
>>
end functionOde;

//TODO:??there is st more in the trunk
template functionInitial(list<SimEqSystem> initialEquations) ::=
let()= System.tmpTickReset(1)
<<
public override void InitialFun()
{
  <%initialEquations |> SES_SIMPLE_ASSIGN(__) => equation_(it, contextOther) ;separator="\n"%>

  //if (sim_verbose) {
    <%initialEquations |> SES_SIMPLE_ASSIGN(__) =>
    <<
    //Debug.WriteLine("Setting variable start value: {0}(start={1})", "<%expCref(cref)%>", <%expCref(cref)%>);
    >> ;separator="\n"%>
  //}
}
>>
end functionInitial;

template functionInitialResidual(list<SimEqSystem> residualEquations) ::=
let()= System.tmpTickReset(1)
<<
public override void InitialResidual()
{
  int _i = 0;

  <%residualEquations |> SES_RESIDUAL(__)  =>
    match exp case DAE.SCONST(__) then
      'initialResiduals[_i++] = 0;'
    else
      let &preExp = buffer ""
      let expPart = daeExp(exp, contextSimulationNonDiscrete, &preExp) // ??contextOther
      <<
      <%preExp%>
      initialResiduals[_i++] = <%expPart%>;
      >>
  ;separator="\n"%>
}
>>
end functionInitialResidual;

template functionExtraResudials(list<SimEqSystem> allEquations) ::=
let()= System.tmpTickReset(1)
(allEquations |> SES_NONLINEAR(__) =>
<<
void ResidualFun<%index%>(int n, double[] xloc, double[] res, int iflag)
{
   <%eqs |> SES_RESIDUAL(__) indexedby i0 =>
     let &preExp = buffer ""
     let expPart = daeExp(exp, contextSimulationDiscrete, &preExp)
   <<
   <%preExp%>
   res[<%i0%>] = <%expPart%>;
   >> ;separator="\n"%>
}
>> ;separator="\n")
end functionExtraResudials;

template functionBoundParameters(list<SimEqSystem> parameterEquations) ::=
let()= System.tmpTickReset(1)
<<
public override void BoundParameters()
{
  <%parameterEquations |> SES_SIMPLE_ASSIGN(__)  => equation_(it, contextOther) ;separator="\n"%>
}
>>
end functionBoundParameters;

// TODO: Is the -1 thing really correct? It seems to work.
template functionCheckForDiscreteVarChanges(list<HelpVarInfo> helpVarInfoLst,
                                   list<ComponentRef> discreteModelVars) ::=
<<
public override bool CheckForDiscreteVarChanges()
{
  //var needToIterate = false;

  //edge(helpVars[i])
  <% helpVarInfoLst |> (id1, exp, id2) => match id2 case -1 then ""
     else
       'if (helpVars[<%id1%>]!=0.0 && savedHelpVars[<%id1%>]==0.0) EventQueue.Add(<%id2%> + NG);'
    ;separator="\n" %>

  //TODO: changeDiscreteVar(i) and to get the i from ComponentRef
  //if change()
  <%discreteModelVars |> it =>
  <<
  if (Pre_<%cref(it)%> != <%cref(it)%>) return true; /*needToIterate = true; */
  >> ;separator="\n"%>
  
  var _hvs = helpVars;
  var _shvs = savedHelpVars;
  for (int i = 0; i < _hvs.Length; i++) {
    //change(helpVars[i]) ?? TODO: not sure if it can be only 1.0 or 0.0
    if (_hvs[i] != _shvs[i])
      return true; //needToIterate=true;
  }

  return false; //needToIterate;
}
>>
end functionCheckForDiscreteVarChanges;


// Residual equations are not handled here
template equation_(SimEqSystem eq, Context context) ::=
match eq
case SES_SIMPLE_ASSIGN(__) then
  let &preExp = buffer ""
  let expPart = daeExp(exp, context, &preExp)
  <<
  <%preExp%>
  <%expCref(cref)%> = <%expPart%>;
  >>
case SES_LINEAR(__) then
  let uid = System.tmpTick()
  let size = listLength(vars)
  let aname = 'A<%uid%>'
  let bname = 'b<%uid%>'
  <<
  var <%aname%> = new double[<%size%>*<%size%>]; //declare_matrix(<%aname%>, <%size%>, <%size%>);
  var <%bname%> = new double[<%size%>]; //declare_vector(<%bname%>, <%size%>);
  <%simJac |> (row, col, eq as SES_RESIDUAL(__)) =>
     let &preExp = buffer ""
     let expPart = daeExp(eq.exp, context, &preExp)
     '<%preExp%><%aname%>[<%row%>+<%col%>*<%size%>] = <%expPart%>; //set_matrix_elt(<%aname%>, <%row%>, <%col%>, <%size%>, <%expPart%>);'
  ;separator="\n"%>
  <%beqs|> it indexedby i0 =>
     let &preExp = buffer ""
     let expPart = daeExp(it, context, &preExp)
     '<%preExp%><%bname%>[<%i0%>] = <%expPart%>; //set_vector_elt(<%bname%>, <%i0%>, <%expPart%>);'
  ;separator="\n"%>
  SolveLinearSystem<%if partOfMixed then "Mixed"%>(<%aname%>, <%bname%>, <%size%>, <%uid%>);
  <%vars |> SIMVAR(__) indexedby i0 => '<%cref(name)%> = <%bname%>[<%i0%>]; //get_vector_elt(<%bname%>, <%i0%>);' ;separator="\n"%>
  >>
case SES_MIXED(__) then
  let contEqs = equation_(cont, context)
  let numDiscVarsStr = listLength(discVars) 
  let valuesLenStr = listLength(values)
  let &preDisc = buffer "" /*BUFD*/
  let discLoc2 = 
  	match discEqs
    case { discEq as SES_SIMPLE_ASSIGN(__) } then
      <<
      <%expCref(discEq.cref)%> = <%daeExp(discEq.exp, context, preDisc /*BUFC*/)%>;
      double discrete_loc2_0 = <%expCref(discEq.cref)%>;
      >>
  	case discEqs then
      <<
      var discrete_loc2 = new double[<%numDiscVarsStr%>];
      <%discEqs |> SES_SIMPLE_ASSIGN(__) indexedby i0 =>
        <<
        <%expCref(cref)%> = <%daeExp(exp, context, preDisc /*BUFC*/)%>;
        discrete_loc2[<%i0%>] = <%expCref(cref)%>;
        >>
        ;separator="\n"%>
      >>
  <<
  // *** mixed_equation_system(<%numDiscVarsStr%>) ***
  { int found_solution = 0;
    int cur_value_indx = 0;
    do {
	  <% match discVars
	    case { var as SIMVAR(__) } then
	      <<
	      double discrete_loc_0 = <%cref(var.name)%>;
          >>
	    case discVars then
	      <<
	      var discrete_loc = new double[<%numDiscVarsStr%>] {
	        <%discVars |> SIMVAR(__) => cref(name) ;separator=",\n"%>
	      };
	      >>
	  %>
	  {
	    <%contEqs%>
	  }
	  <%preDisc%>
	  <%discLoc2%>
	  {
	    // check_discrete_values(<%numDiscVarsStr%>, <%valuesLenStr%>);
	    if (found_solution == -1) { /*system of equations failed*/
            found_solution = 0;
        } else {
            found_solution = 1;
            <% match discVars
	    	  case { SIMVAR(__) } then
	    	    <<
	    	    if ( Math.Abs(discrete_loc_0 - discrete_loc2_0) > 1e-12) {
                    found_solution = 0;
                }
                >>
              case discVars then
                <<
                for (int i=0; i < <%numDiscVarsStr%>; i++) {
	                if ( Math.Abs(discrete_loc[i] - discrete_loc2[i]) > 1e-12) {
	                    found_solution = 0;
	                }
	            }
	            >>
	        %>
        }
        if (found_solution == 0) { //!found_solution
            cur_value_indx++;
            if (cur_value_indx > <%valuesLenStr%>/<%numDiscVarsStr%>) {
                found_solution = -1; //?? failed ??
            }             
        }
	  }
    } while (found_solution == 0);
  } // *** mixed_equation_system_end(<%numDiscVarsStr%>) ***
  >>

case _ then
  <<
  equation_NOT_YET_IMPLEMENTED
  >>
end equation_;

// SECTION: SIMULATION TARGET, FUNCTIONS FILE SPECIFIC TEMPLATES
// not yet implemented

// SECTION: GENERAL TEMPLATES, COMPONENT REFERENCES

template cref(ComponentRef it) ::=
  match it
  case CREF_IDENT(__) then replaceDollarWorkaround(ident)
  case _ then "CREF_NOT_IDENT"
end cref;

template crefSubscript(ComponentRef it) ::=
  match it
  case CREF_IDENT(__) then replaceDollarWorkaround(ident) + subscripts(subscriptLst)
  case _ then "CREF_NOT_IDENT"
end crefSubscript;

template subscripts(list<Subscript> subscriptsLst) ::=
  if subscriptsLst then '[<%subscriptsLst |> it => subscript(it) ;separator=","%>]'
end subscripts;

template subscript(Subscript it) ::=
  match it
  case INDEX(exp = ICONST(__)) then exp.integer
  case _ then "SUBSCRIPT_NOT_CONSTANT"
end subscript;

template expCref(DAE.Exp cref)
::=
  match cref
  case CREF(__) then '<%cref(componentRef)%>'
  case CALL(path = IDENT(name = "der"), expLst = {arg as CREF(__)}) then
    '$DER$<%cref(arg.componentRef)%>'
  else "ERROR_NOT_A_CREF"
end expCref;


// SECTION: GENERAL TEMPLATES, PATHS

template dotPath(Path it) ::=
  match it
  case QUALIFIED(__)      then '<%name%>.<%dotPath(path)%>'
  case IDENT(__)          then name
  case FULLYQUALIFIED(__) then dotPath(path)
end dotPath;

template underscorePath(Path it) ::=
  match it
  case QUALIFIED(__)      then '<%System.stringReplace(name, "_", "__")%>_<%underscorePath(path)%>'
  case IDENT(__)          then System.stringReplace(name, "_", "__")
  case FULLYQUALIFIED(__) then underscorePath(path)
end underscorePath;


// SECTION: GENERAL TEMPLATES, FUNCTION GENERATION
// not yet implemented



// Codegen.generateStatement
template algStatement(DAE.Statement it, Context context) ::=
  match it
  case STMT_ASSIGN(exp1 = CREF(componentRef = WILD(__)), exp = e) then
    let &preExp = buffer "" 
    let expPart = daeExp(e, context, &preExp)
    <<
    <%preExp%>
    <%expPart%>
    >>    
  case STMT_ASSIGN(exp1 = CREF(__)) then
    let &preExp = buffer ""
    let expPart = daeExp(exp, context, &preExp)
    <<
    <%preExp%>
    <%scalarLhsCref(exp1, context, &preExp)%> = <%expPart%>;
    >>
  case STMT_ASSIGN(__) then
    let &preExp = buffer ""
    let expPart1 = daeExp(exp1, context, &preExp)
    let expPart2 = daeExp(exp, context, &preExp)
    <<
    <%preExp%>
    <%expPart1%> = <%expPart2%>;
    >>
  case STMT_IF(__) then
    let &preExp = buffer ""
    let condExp = daeExp(exp, context, &preExp)
    <<
    <%preExp%>
    if (<%condExp%>) {
      <%statementLst |> it => algStatement(it, context) ;separator="\n"%>
    }
    <%elseExpr(else_, context)%>
    >>
  case _ then "NOT_IMPLEMENTED_ALG_STATEMENT"
 /*
  case STMT_FOR(exp = rng as RANGE(__)) then
    <<
    {
      <%expTypeA(type_, boolean)%> 
        _r1 = <%daeExp(rng.exp,isSimulationCode)%>,
        _r2 = <%match rng.expOption case SOME(eo) then daeExp(eo,isSimulationCode) else "(1)"%>,
        _r3 = <%daeExp(rng.range,isSimulationCode)%>,
        <%ident%>;

      for (<%ident%> = _r1; in_range_<%expShortType(type_)%>(<%ident%>, _r1, _r3); <%ident%> += _r2) {
        <%statementLst |> it => algStatement(it) ;separator="\n" /* ??CONTEXT(codeContext,expContext,IN_FOR_LOOP(loopContext)*/ %>        
      }
    } /*end for*/
    >>
  */
end algStatement;

template elseExpr(DAE.Else it, Context context) ::= 
  match it
  case NOELSE(__) then ""
  case ELSEIF(__) then
    let &preExp = buffer ""
    let condExp = daeExp(exp, context, &preExp)
    <<
    else {
    <%preExp%>
    if (<%condExp%>)) {
      <%statementLst |> it => algStatement(it, context) ;separator="\n"%>
    }
    <%elseExpr(else_, context)%>
    }
    >>
  case ELSE(__) then
    <<
    else {
      <%statementLst |> it => algStatement(it, context) ;separator="\n"%>
    }
    >>
end elseExpr;
    
//try this
/*
template foo(list<Exp> exps, list<Integer> ints, Text &varDecls) ::=
  match exps case (firstExp :: restExps) then
  match ints case (firstInt :: restInts) then
    let &preExp = buffer ""
    let expPart = daeExp(firstExp, contextSimulationDiscrete, &preExp, &varDecls) 
    <<
    <%preExp%>
    localData->helpVars[<%firstInt%>] = <%expPart%>;
    <%foo(restExps, restInts, &preExp, &varDecls)%>
    >>
end foo;
*/

template foo(list<Exp> exps, list<Integer> ints) ::=
  match exps case (firstExp :: restExps) then
  match ints case (firstInt :: restInts) then
    let &preExp = buffer ""
    let expPart = daeExp(firstExp, contextSimulationDiscrete, &preExp)
    <<
    <%preExp%>
    localData->helpVars[<%firstInt%>] = <%expPart%>;
    <%foo(restExps, restInts)%>
    >>

end foo;

template scalarLhsCref(Exp cref, Context context, Text &preExp) ::=
match cref
case cref as CREF(componentRef=CREF_IDENT(subscriptLst=subs)) then
  if crefNoSub(cref.componentRef) then
    cref(cref.componentRef)
  else
    daeExpCrefRhs(cref, context, &preExp)
case _ then
  "ONLY IDENT SUPPORTED"
end scalarLhsCref;

/*
template scalarLhsCref(ComponentRef it) ::=
  match it
  case CREF_IDENT(__) then replaceDollarWorkaround(ident)
  case CREF_QUAL(__)  then '<%ident%>.<%scalarLhsCref(componentRef)%>'
end scalarLhsCref;
*/

//TODO: this wrong for qualified integers !
template rhsCref(ComponentRef it, ExpType ty) ::=
  match it
  case CREF_IDENT(__) then '<%rhsCrefType(ty)%><%replaceDollarWorkaround(ident)%>'
  case CREF_QUAL(__)  then '<%rhsCrefType(ty)%><%ident%>.<%rhsCref(componentRef,ty)%>'
  case _          then "rhsCref:ERROR"
end rhsCref;

template rhsCrefType(ExpType it) ::=
  match it
  case ET_INT(__) then "(int)"
  case _      then ""
end rhsCrefType;


template replaceDollarWorkaround(String ident) ::=
  stringReplace(
    stringReplace(ident,"$DER","Der_"), 
    "$", "")
end replaceDollarWorkaround;

// SECTION: GENERAL TEMPLATES, EXPRESSIONS
  
template daeExp(Exp exp, Context context, Text &preExp) ::=
  match exp
  case ICONST(__)     then integer
  case RCONST(__)     then real
  case SCONST(__)     then '"<%Util.escapeModelicaStringToCString(string)%>"'
  case BCONST(__)     then if bool then "(1)" else "(0)"
  case CREF(__)       then daeExpCrefRhs(it, context, &preExp)
  case LBINARY(__)
  case BINARY(__)     then daeExpBinary(operator, exp1, exp2, context, &preExp)
  case LUNARY(__)
  case UNARY(__)      then daeExpUnary(operator, exp, context, &preExp)
  case RELATION(__)   then daeExpRelation(operator, exp1, exp2, context, &preExp)
  case IFEXP(__)      then daeExpIf(expCond, expThen, expElse, context, &preExp)
  case CALL(__)       then daeExpCall(exp, context, &preExp)
  // PARTEVALFUNCTION
  case ARRAY(__)      then daeExpArray(ty, scalar, array, context, &preExp)
  case MATRIX(__)     then "MATRIX_NOT_IMPLEMENTED"
  case RANGE(__)      then "RANGE_NOT_IMPLEMENTED"
  case TUPLE(__)      then "TUPLE_NOT_IMPLEMENTED"
  case CAST(__)       then "CAST_NOT_IMPLEMENTED"
  case ASUB(__)       then "ASUB_NOT_IMPLEMENTED"
  case SIZE(__)       then "SIZE_NOT_IMPLEMENTED"
  case CODE(__)       then "CODE_NOT_IMPLEMENTED"
  case REDUCTION(__)  then "REDUCTION_NOT_IMPLEMENTED"
  case END(__)        then "END_NOT_IMPLEMENTED"
  case VALUEBLOCK(__) then "VALUEBLOCK_NOT_IMPLEMENTED"
  case LIST(__)       then "LIST_NOT_IMPLEMENTED"
  case CONS(__)       then "CONS_NOT_IMPLEMENTED"
  // META_TUPLE
  // META_OPTION
  // METARECORDCALL
  case _          then "UNKNOWN_EXP"
end daeExp;
  
template daeExpCrefRhs(Exp exp, Context context, Text &preExp) ::=
match exp
case cref as CREF(componentRef=CREF_IDENT(subscriptLst=subs)) then
  if daeExpCrefRhsArrayBox(exp, context, &preExp) then
    it
  else if crefNoSub(cref.componentRef) then
    <<
    <%match cref.ty case ET_INT(__) then "(int)"
    %><%cref(cref.componentRef)%>
    >>
  else if crefSubIsScalar(cref.componentRef) then
    // The array subscript results in a scalar
    let arrName = cref(cref.componentRef)
    let arrayType = expTypeArray(cref.ty)
    let dimsLenStr = listLength(subs)
    let dimsValuesStr = (subs |> INDEX(__) => daeExp(exp, context, &preExp) ;separator=", ")
    <<
    !!!TODO:(*<%arrayType%>_element_addr(&<%arrName%>, <%dimsLenStr%>, <%dimsValuesStr%>))
    >>
  else
    // The array subscript denotes a slice
    let arrName = cref(cref.componentRef)
    let arrayType = expTypeArray(cref.ty)
    let spec1 = daeExpCrefRhsIndexSpec(subs, context, &preExp)
    let &tmp = buffer ""
    let &preExp += '!!!TODO: <%tempDecl(arrayType, tmp)%> = index_alloc_<%arrayType%>(&<%arrName%>, &<%spec1%>, &<%tmp%>);<%\n%>'
    tmp
case _ then
  "UNKNOWN RHS CREF: ONLY IDENT SUPPORTED"
end daeExpCrefRhs;

template daeExpCrefRhsIndexSpec(list<Subscript> subs, Context context, Text &preExp) ::=
let nridx_str = listLength(subs)
let idx_str = (subs |> it =>
               match it
               case INDEX(__) then
                 let expPart = daeExp(exp, context, &preExp)
                 <<
                 (1), make_index_array(1, <%expPart%>), 'S'
                 >>
               case WHOLEDIM(__) then
                 <<
                 (1), (0), 'W'
                 >>
               case SLICE(__) then
                 let expPart = daeExp(exp, context, &preExp)
                 let &tmp = buffer ""
                 let &preExp += '!!!TODO:<%tempDecl("int", tmp)%> = size_of_dimension_integer_array(<%expPart%>, 1);<%\n%>'
                 <<
                 <%tmp%>, integer_array_make_index_array(&<%expPart%>), 'A'
                 >>
             ;separator=", ")
let &tmp = buffer "" 
let &preExp += '!!!TODO:<%tempDecl("index_spec_t", tmp)%> = create_index_spec(&<%tmp%>, <%nridx_str%>, <%idx_str%>);<%\n%>'
tmp
end daeExpCrefRhsIndexSpec;


template daeExpCrefRhsArrayBox(Exp exp, Context context, Text &preExp) ::=
match exp
case cref as CREF(ty=ET_ARRAY(ty=aty,arrayDimensions=dims)) then
  match context case SIMULATION(__) then
    // For context simulation array variables must be boxed into a real_array
    // object since they are represented only in a double array.
    let &tmpArr = buffer ""
    let dimsLenStr = listLength(dims)
    let dimsValuesStr = (dims |> SOME(i) => i ;separator=", ")
    let &preExp += '!!!TODO:<%tempDecl(expTypeArray(aty), tmpArr)%> = <%expShortType(aty)%>_array_create(&<%tmpArr%>, &<%cref(cref.componentRef)%>, <%dimsLenStr%>, <%dimsValuesStr%>);<%\n%>'
    tmpArr
end daeExpCrefRhsArrayBox;


template daeExpBinary(Operator it, Exp exp1, Exp exp2, Context context, Text &preExp) ::=
  let e1 = daeExp(exp1, context, &preExp)
  let e2 = daeExp(exp2, context, &preExp)
  match it
  case ADD(__) then '(<%e1%> + <%e2%>)'
  case SUB(__) then '(<%e1%> - <%e2%>)'
  case MUL(__) then '(<%e1%> * <%e2%>)'
  case DIV(__) then '(<%e1%> / <%e2%>)'
  case POW(__) then 'Math.Pow(<%e1%>, <%e2%>)'
  case AND(__) then '(<%e1%> && <%e2%>)'
  case OR(__)  then '(<%e1%> || <%e2%>)'
  case _   then "daeExpBinary:ERR"
end daeExpBinary;


template daeExpUnary(Operator it, Exp exp, Context context, Text &preExp) ::=
  let e = daeExp(exp, context, &preExp)
  match it
  case UMINUS(__)     then '(-<%e%>)'
  case UPLUS(__)      then '(<%e%>)'
  case NOT(__)        then '(!<%e%>)'
  case UMINUS_ARR(__) then "UMINUS_ARR_NOT_IMPLEMENTED"
  case UPLUS_ARR(__)  then "UPLUS_ARR_NOT_IMPLEMENTED"
  case _          then "daeExpUnary:ERR"

end daeExpUnary;


template daeExpRelation(Operator op, Exp exp1, Exp exp2, Context context, Text &preExp) ::=
  let e1 = daeExp(exp1, context, &preExp)
  let e2 = daeExp(exp2, context, &preExp)
  if  daeExpSimRelation(context, op, e1, e2, &preExp) then 
    it
  else //non-SIMULATION context or precise equality 
    match op
    case LESS(ty = ET_BOOL(__))        then '(!<%e1%> && <%e2%>)'
    case LESS(ty = ET_STRING(__))      then "# string comparison not supported\n"
    case LESS(ty = ET_INT(__))
    case LESS(ty = ET_REAL(__))        then '(<%e1%> < <%e2%>)'
    case GREATER(ty = ET_BOOL(__))     then '(<%e1%> && !<%e2%>)'
    case GREATER(ty = ET_STRING(__))   then "# string comparison not supported\n"
    case GREATER(ty = ET_INT(__))
    case GREATER(ty = ET_REAL(__))     then '(<%e1%> > <%e2%>)'
    case LESSEQ(ty = ET_BOOL(__))      then '(!<%e1%> || <%e2%>)'
    case LESSEQ(ty = ET_STRING(__))    then "# string comparison not supported\n"
    case LESSEQ(ty = ET_INT(__))
    case LESSEQ(ty = ET_REAL(__))      then '(<%e1%> <= <%e2%>)'
    case GREATEREQ(ty = ET_BOOL(__))   then '(<%e1%> || !<%e2%>)'
    case GREATEREQ(ty = ET_STRING(__)) then "# string comparison not supported\n"
    case GREATEREQ(ty = ET_INT(__))
    case GREATEREQ(ty = ET_REAL(__))   then '(<%e1%> >= <%e2%>)'
    case EQUAL(ty = ET_BOOL(__))       then '((!<%e1%> && !<%e2%>) || (<%e1%> && <%e2%>))'
    case EQUAL(ty = ET_STRING(__))
    case EQUAL(ty = ET_INT(__))
    case EQUAL(ty = ET_REAL(__))       then '(<%e1%> == <%e2%>)'
    case NEQUAL(ty = ET_BOOL(__))      then '((!<%e1%> && <%e2%>) || (<%e1%> && !<%e2%>))'
    case NEQUAL(ty = ET_STRING(__))
    case NEQUAL(ty = ET_INT(__))
    case NEQUAL(ty = ET_REAL(__))      then '(<%e1%> != <%e2%>)'
    case _                         then "daeExpRelation:ERR"
end daeExpRelation;


template daeExpSimRelation(Context it, Operator op, Text e1, Text e2, Text &preExp) ::=
	match it
	case SIMULATION(__) then 
	   match op
	   case LESS(__)      then SimRelationSimple(e1, e2, " <", &preExp)
	   case LESSEQ(__)    then SimRelationEqual(e1, e2, " <", &preExp)
	   case GREATER(__)   then SimRelationSimple(e1, e2, " >", &preExp)
	   case GREATEREQ(__) then SimRelationEqual(e1, e2, " >", &preExp)
	   end match
end daeExpSimRelation;


template SimRelationSimple(Text e1, Text e2, String op, Text &preExp) ::=
  let &res = buffer ""    
  let &preExp += 
    <<
    // RELATION( <%e1%><%op%> <%e2%> ) macro expansion
    <%tempDecl("bool", res)%> = <%e1%><%op%> <%e2%>; if (!<%res%> && isInUpdate && (<%e1%><%op%>= <%e2%>)) { SwapOldVars(); double res1 = <%e1%> - <%e2%>;  SwapOldVars12(); <%res%> = res1<%op%>= (<%e1%> - <%e2%>); SwapOldVars2(); }<%\n%>
    >>
  res 
end SimRelationSimple;


template SimRelationEqual(Text e1, Text e2, String op, Text &preExp) ::=
  let &res = buffer ""    
  let &preExp += 
    <<
    // RELATION( <%e1%><%op%>= <%e2%> ) macro expansion
    <%tempDecl("bool", res)%>;  if (isInUpdate) { <%res%> = <%e1%><%op%> <%e2%>;  if(!<%res%> && (<%e1%><%op%>= <%e2%>)) {  SwapOldVars(); double res1 = <%e1%> - <%e2%>;  SwapOldVars12(); <%res%> = res1<%op%>= (<%e1%> - <%e2%>); SwapOldVars2(); }  } else <%res%> = <%e1%><%op%>= <%e2%>;<%\n%>
    >>
  res
end SimRelationEqual;


template daeExpIf(Exp cond, Exp then_, Exp else_, Context context, Text &preExp) ::=
  let condExp = daeExp(cond, context, &preExp)
  let &resVar = buffer ""
  let &preExpThen = buffer ""
  let eThen = daeExp(then_, context, &preExpThen)
  let &preExpElse = buffer ""
  let eElse = daeExp(else_, context, &preExpElse)
  let &preExp +=  
  <<
  <%tempDecl(expTypeFromExpArrayIf(then_), resVar)%>;
  if (<%condExp%><%/*if expTypeFromExp(cond) is "bool" then " != 0.0"*/%>) { //cond type is <%expTypeFromExp(cond)%>
    <%preExpThen%>
    <%resVar%> = <%eThen%>;
  } else {
    <%preExpElse%>
    <%resVar%> = <%eElse%>;
  }<%\n%>
  >>
  resVar

/*<<
(<%daeExp(cond, context, &preExp)
  %> ? <%daeExp(then_, context, &preExp)%> : <%daeExp(else_, context, &preExp)%>)
>>*/
end daeExpIf;


template daeExpCall(Exp it, Context context, Text &preExp) ::=
  match it
  // special builtins
  case CALL(tuple_=false, builtin=true,
            path=IDENT(name="DIVISION"),
            expLst={e1, e2, DAE.SCONST(string=string)}) then
    let var1 = daeExp(e1, context, &preExp)
    let msg = Util.escapeModelicaStringToCString(string)
    match e2 
    case RCONST(__) then 
     	//match rr case 0.0 then 'DivBy0(<%var1%>,0.0,"<%msg%>")'
     	//else 
     	'<%var1%>/<%daeExp(e2, context, &preExp)%>'
    case _ then
     	let var2 = daeExp(e2, context, &preExp)
    	'(<%var2%>!=0.0 ? <%var1%>/<%var2%> : DivBy0(<%var1%>,<%var2%>,"<%msg%>"))' 
    end match 
    
  
  case CALL(tuple_=false, builtin=true,
            path=IDENT(name="pre"), expLst={arg as CREF(__)}) then
    //let retType = expType(arg.ty)
    <<
    <%match arg.ty case ET_INT(__) then "(int)"
    %>Pre_<%cref(arg.componentRef)%>
    >>
  
  case CALL(tuple_=false, builtin=true,
            path=IDENT(name="min"), expLst={e1,e2}) then
    'Math.Min(<%daeExp(e1, context, &preExp)%>,<%daeExp(e2, context, &preExp)%>)'
  
  case CALL(tuple_=false, builtin=true,
            path=IDENT(name="max"), expLst={e1,e2}) then
    'Math.Max(<%daeExp(e1, context, &preExp)%>,<%daeExp(e2, context, &preExp)%>)'
  
  case CALL(tuple_=false, builtin=true,
            path=IDENT(name="log"), expLst={s1}) then
    'Math.Log(<%daeExp(s1, context, &preExp)%>)'
  
  case CALL(tuple_=false, builtin=true,
            path=IDENT(name="exp"), expLst={s1}) then
    'Math.Exp(<%daeExp(s1, context, &preExp)%>)'
  
  case CALL(tuple_=false, builtin=true,
            path=IDENT(name="sin"), expLst={s1}) then
    'Math.Sin(<%daeExp(s1, context, &preExp)%>)'
  
    
  // TODO: add more special builtins (Codegen.generateBuiltinFunction)
  // no return calls
  case CALL(tuple_=false, ty=ET_NORETCALL(__)) then
    let argStr = (expLst |> it => daeExp(it, context, &preExp) ;separator=", ")
    let &preExp += '<%underscorePrefix(builtin)%><%underscorePath(path)%>(<%argStr%>);<%\n%>'
    <<
    /* NORETCALL */
    >>
  // non tuple calls (single return value)
  case CALL(tuple_=false) then
    let argStr = (expLst |> it => daeExp(it, context, &preExp) ;separator=", ")
    let funName = underscorePath(path)
    <<
    <%underscorePrefix(builtin)
    %><%funName%>(<%argStr%>)<%if not builtin then '/* !!!TODO:.<%funName%>_rettype_1 */'%>
    >>
  case _ then "daeExpCall:NOT_YET_IMPLEMENTED"
end daeExpCall;


template daeExpArray(ExpType ty, Boolean scalar, list<Exp> array, Context context, Text &preExp) ::=
  let arrayTypeStr = expTypeArray(ty)
  let &arrayVar = buffer "" //tempDecl(arrayTypeStr, &varDecls /*BUFC*/)
  let scalarPrefix = if scalar then "" else "NON_SCALAR_ARRAY_notYetImplemeted"
  let scalarRef = if scalar then "&" else ""
  let params = '<%array |> e => '(<%expTypeFromExp(e)%>)<%daeExp(e, context, &preExp)%>' ;separator=", "%>'
  let &preExp += '<%scalarPrefix%><%tempDecl(arrayTypeStr,arrayVar)%> = new <%arrayTypeStr%>{ <% {"0.0",params} ;separator=", "%> };<%\n%>'
  arrayVar
end daeExpArray;


template underscorePrefix(Boolean builtin) ::=
  match builtin
  case true then ""
  case false then "_"
end underscorePrefix;

// SECTION: GENERAL TEMPLATES, TEMPORARY VARIABLES

//newVar parameter is assumed to be empty or it can hold an identifier prefix
template tempDecl(String ty, Text &newVar) ::=
  let &newVar += '_tmp<%System.tmpTick()%>'
  <<
  <%ty%> <%newVar%>
  >>
end tempDecl;
  


// SECTION: GENERAL TEMPLATES, TYPES

// TODO: Check with Codegen
template expShortType(DAE.ExpType it) ::=
  match it
  case ET_INT(__)    then "int"
  case ET_REAL(__)   then "double"
  case ET_STRING(__) then "string"
  case ET_BOOL(__)   then "bool"
  case ET_OTHER(__)  then "#complex#"
  case ET_ARRAY(__) then expShortType(ty)   
  case ET_COMPLEX(__) then '/*struct*/<%underscorePath(name)%>'  
end expShortType;


template expTypeArray(DAE.ExpType ty) ::=
<<
<%expShortType(ty)%>[]
>>
end expTypeArray;


template expTypeFromExpArrayIf(Exp exp) ::=
  expTypeFromExp(exp)
end expTypeFromExpArrayIf;


template expTypeFromExp(Exp it) ::=
  match it
  case ICONST(__)    then "int"
  case RCONST(__)    then "double"
  case SCONST(__)    then "string"
  case BCONST(__)    then "bool"
  case BINARY(__)
  case UNARY(__)
  case LBINARY(__)
  case LUNARY(__)
  case RELATION(__)   then expTypeFromOp(operator)
  case IFEXP(__)      then expTypeFromExp(expThen)
  case CALL(__)       then expShortType(ty)
  case ARRAY(__)
  case MATRIX(__)
  case RANGE(__)
  case CAST(__)
  case CREF(__)
  case CODE(__)       then expShortType(ty)
  case ASUB(__)       then expTypeFromExp(exp)
  case REDUCTION(__)  then expTypeFromExp(expr)
  case _          then "expTypeFromExp:ERROR"
end expTypeFromExp;


template expTypeFromOp(Operator it) ::=
  match it
  case ADD(__)
  case SUB(__)
  case MUL(__)
  case DIV(__)
  case POW(__)
  case UMINUS(__)
  case UPLUS(__)
  case UMINUS_ARR(__)
  case UPLUS_ARR(__)
  case ADD_ARR(__)
  case SUB_ARR(__)
  case MUL_ARR(__)
  case DIV_ARR(__)
  case MUL_SCALAR_ARRAY(__)
  case MUL_ARRAY_SCALAR(__)
  case ADD_SCALAR_ARRAY(__)
  case ADD_ARRAY_SCALAR(__)
  case SUB_SCALAR_ARRAY(__)
  case SUB_ARRAY_SCALAR(__)
  case MUL_SCALAR_PRODUCT(__)
  case MUL_MATRIX_PRODUCT(__)
  case DIV_ARRAY_SCALAR(__)
  case DIV_SCALAR_ARRAY(__)
  case POW_ARRAY_SCALAR(__)
  case POW_SCALAR_ARRAY(__)
  case POW_ARR(__)
  case POW_ARR2(__)
  case LESS(__)
  case LESSEQ(__)
  case GREATER(__)
  case GREATEREQ(__)
  case EQUAL(__)
  case NEQUAL(__)       then  expShortType(ty)
  case AND(__)
  case OR(__)
  case NOT(__) then "bool"
  case _ then "expTypeFromOp:ERROR"
end expTypeFromOp;


/*
// TODO: Check with Codegen
template expType(DAE.ExpType it) ::=
  match it
  case ET_INT(__)    then "int"
  case ET_REAL(__)   then "double"
  case ET_BOOL(__)   then "bool"
  case ET_STRING(__) then "string"
  case ET_COMPLEX(complexClassType = EXTERNAL_OBJ(__))  then "#complex external obj#" 
  case ET_OTHER(__)  then "#OTHER type#"
  case ET_LIST(__)
  case ET_METATUPLE(__)
  case ET_METAOPTION(__)
  case ET_UNIONTYPE(__)
  case ET_POLYMORPHIC(__) then "#metamodelica_type#"
  case ET_ARRAY(__) then
    match ty
    case ET_INT(__)    then "int[]"
    case ET_REAL(__)   then "double[]"
    case ET_STRING(__) then "string[]"
    case ET_BOOL(__)   then "bool[]"
    end match
end expType;

// TODO: Check with Codegen (expTypeStr)
template expTypeA(DAE.ExpType it, Boolean isArray) ::=
  match it
  case ET_COMPLEX(__)     then expShortType(it) // i.e. 'struct <%name%>'  
  case ET_LIST(__)
  case ET_METATUPLE(__)
  case ET_METAOPTION(__)
  case ET_UNIONTYPE(__)
  case ET_POLYMORPHIC(__) then "#metamodelica_type#"
end expTypeA;
*/


end SimCodeCSharp;
// vim: filetype=susan sw=2 sts=2
