package ObsoleteModelica3 "Library that contains components from Modelica Standard Library 2.2.2 that have been removed from version 3.0"
  annotation(uses(Modelica(version = "3.1")), Documentation(info = "<html>
<p>
This package contains models and blocks from the Modelica Standard Library
version 2.2.2 that are no longer available in version 3.0.
The conversion script for version 3.0 changes references in existing
user models automatically to the models and blocks of package
ObsoleteModelica3. The user should <b>manually</b> replace all
references to ObsoleteModelica3 in his/her models to the models
that are recommended in the documentation of the respective model.
</p>

<p>
In most cases, this means that a model with the name
\"ObsoleteModelica3.XXX\" should be renamed to \"Modelica.XXX\" (version 3.0)
and then a manual adaptation is needed. For example, a reference to
ObsoleteModelica3.Mechanics.MultiBody.Sensors.AbsoluteSensor
should be replaced by
Modelica.Mechanics.MultiBody.Sensors.AbsoluteSensor (version 3.0).
Since the design of the component has changed (e.g., several
optional connectors, and no longer one connector where all signals
are packed together), this requires some changes at the place where
the model is used (besides the renaming of the underlying class).
</p>

<p>
The models in ObsoleteModelica3 are either not according to the Modelica Language
version 3.0 and higher, or the model was changed to get a better design.
In all cases, an automatic conversion to the new implementation
was not feasible, since too complicated.
</p>

<p>
In order to easily detect obsolete models and blocks, all of them are specially
marked in the icon layer with a red box.
</p>

<p>
Copyright &copy; 2007-2009, Modelica Association.
</p>
<p>
<i>This Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b>
<a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense2\">here</a>.</i>
</p>

</html>"));
  package Blocks "Library of basic input/output control blocks (continuous, discrete, logical, table blocks)"
    package Interfaces "Library of connectors and partial models for input/output blocks"
      connector RealSignal = Real "Real port (both input/output possible)" annotation(__Dymola_obsolete = "Connector is not valid according to Modelica 3, since input/output prefixes are missing. When using this connector, it is not possible to check for balanced models.", Documentation(info = "<html>
<p>
Connector with one signal of type Real (no icon, no input/output prefix).
</p>
</html>"));
      connector BooleanSignal = Boolean "Boolean port (both input/output possible)" annotation(__Dymola_obsolete = "Connector is not valid according to Modelica 3, since input/output prefixes are missing. When using this connector, it is not possible to check for balanced models.", Documentation(info = "<html>
<p>
Connector with one signal of type Boolean (no icon, no input/output prefix).
</p>
</html>"));
      connector IntegerSignal = Integer "Integer port (both input/output possible)" annotation(__Dymola_obsolete = "Connector is not valid according to Modelica 3, since input/output prefixes are missing. When using this connector, it is not possible to check for balanced models.", Documentation(info = "<html>
<p>
Connector with one signal of type Icon (no icon, no input/output prefix).
</p>
</html>"));
      package Adaptors "Obsolete package with components to send signals to a bus or receive signals from a bus (only for backward compatibility)"
        model AdaptorReal "Completely obsolete adaptor between 'old' and 'new' Real signal connectors (only for backward compatibility)"
          extends ObsoleteModelica3.Icons.ObsoleteBlock;
          ObsoleteModelica3.Blocks.Interfaces.RealSignal newReal "Connector of Modelica version 2.1" annotation(Hide = true, Placement(transformation(extent = {{100, -10},{120,10}}, rotation = 0)));
          RealPort oldReal(final n = 1) "Connector of Modelica version 1.6" annotation(Placement(transformation(extent = {{ -120, -10},{ -100,10}}, rotation = 0)));
          annotation(structurallyIncomplete, __Dymola_obsolete = "Model is not balanced, so equation check will not work. This model is no longer needed", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -100,40},{100, -40}}, lineColor = {0,0,255}, fillColor = {255,255,255}, fillPattern = FillPattern.Solid),Text(extent = {{ -144,96},{144,46}}, lineColor = {0,0,0}, textString = ""),Text(extent = {{ -88,22},{88, -24}}, lineColor = {0,0,255}, textString = "adaptor"),Text(extent = {{ -216, -58},{36, -80}}, lineColor = {0,0,0}, textString = "port.signal")}), Documentation(info = "<html>
<p>
Completely obsolete adaptor between the Real signal connector
of version 1.6 and version &ge; 2.1 of the Modelica Standard Library.
This block is only provided for backward compatibility.
</p>
</html>
"));
        protected 
          connector RealPort "Connector with signals of type Real"
            parameter Integer n = 1 "Dimension of signal vector" annotation(Hide = true);
            replaceable type SignalType = Real "type of signal";
            SignalType signal[n] "Real signals" annotation(Hide = true);
          end RealPort;

        equation 
          newReal = oldReal.signal[1];
        end AdaptorReal;
        model AdaptorBoolean "Completely obsolete adaptor between 'old' and 'new' Boolean signal connectors (only for backward compatibility)"
          extends ObsoleteModelica3.Icons.ObsoleteBlock;
          ObsoleteModelica3.Blocks.Interfaces.BooleanSignal newBoolean "Connector of Modelica version 2.1" annotation(Hide = true, Placement(transformation(extent = {{100, -10},{120,10}}, rotation = 0)));
          BooleanPort oldBoolean(final n = 1) "Connector of Modelica version 1.6" annotation(Placement(transformation(extent = {{ -120, -10},{ -100,10}}, rotation = 0)));
          annotation(structurallyIncomplete, __Dymola_obsolete = "Model is not balanced, so equation check will not work. This model is no longer needed", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -100,40},{100, -40}}, lineColor = {255,0,255}, fillColor = {255,255,255}, fillPattern = FillPattern.Solid),Text(extent = {{ -144,96},{144,46}}, lineColor = {0,0,0}, textString = ""),Text(extent = {{ -88,22},{88, -24}}, lineColor = {255,0,255}, textString = "adaptor"),Text(extent = {{ -216, -58},{36, -80}}, lineColor = {0,0,0}, textString = "port.signal")}), Documentation(info = "<html>
<p>
Completely obsolete adaptor between the Real signal connector
of version 1.6 and version &ge; 2.1 of the Modelica Standard Library.
This block is only provided for backward compatibility.
</p>
</html>
"));
        protected 
          connector BooleanPort "Connector with signals of type Boolean"
            parameter Integer n = 1 "Dimension of signal vector" annotation(Hide = true);
            replaceable type SignalType = Boolean "type of signal";
            SignalType signal[n] "Boolean signals" annotation(Hide = true);
          end BooleanPort;

        equation 
          newBoolean = oldBoolean.signal[1];
        end AdaptorBoolean;
        model AdaptorInteger "Completely obsolete adaptor between 'old' and 'new' Integer signal connectors (only for backward compatibility)"
          extends ObsoleteModelica3.Icons.ObsoleteBlock;
          ObsoleteModelica3.Blocks.Interfaces.IntegerSignal newInteger "Connector of Modelica version 2.1" annotation(Hide = true, Placement(transformation(extent = {{100, -10},{120,10}}, rotation = 0)));
          IntegerPort oldInteger(final n = 1) "Connector of Modelica version 1.6" annotation(Placement(transformation(extent = {{ -120, -10},{ -100,10}}, rotation = 0)));
          annotation(structurallyIncomplete, __Dymola_obsolete = "Model is not balanced, so equation check will not work. This model is no longer needed", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -100,40},{100, -40}}, lineColor = {255,127,0}, fillColor = {255,255,255}, fillPattern = FillPattern.Solid),Text(extent = {{ -144,96},{144,46}}, lineColor = {0,0,0}, textString = ""),Text(extent = {{ -88,22},{88, -24}}, lineColor = {255,127,0}, textString = "adaptor"),Text(extent = {{ -216, -58},{36, -80}}, lineColor = {0,0,0}, textString = "port.signal")}), Documentation(info = "<html>
<p>
Completely obsolete adaptor between the Real signal connector
of version 1.6 and version &ge; 2.1 of the Modelica Standard Library.
This block is only provided for backward compatibility.
</p>
</html>
"));
        protected 
          connector IntegerPort "Connector with signals of type Integer"
            parameter Integer n = 1 "Dimension of signal vector" annotation(Hide = true);
            replaceable type SignalType = Integer "type of signal";
            SignalType signal[n] "Integer signals" annotation(Hide = true);
          end IntegerPort;

        equation 
          newInteger = oldInteger.signal[1];
        end AdaptorInteger;
      end Adaptors;
    end Interfaces;
    package Math "Library of mathematical functions as input/output blocks"
      package UnitConversions "Conversion blocks to convert between SI and non-SI unit signals"
        block ConvertAllUnits "Obsolete block. Use one of Modelica.Blocks.Math.UnitConversions.XXX instead"
          replaceable block ConversionBlock = Modelica.Blocks.Interfaces.PartialConversionBlock "Conversion block" annotation(choicesAllMatching = true, Documentation(info = "<html>
<p>
Internal replaceable block that is used to construct the
\"pull down menu\" of the available unit conversions.
</p>
</html>"));
          extends ConversionBlock;
          extends ObsoleteModelica3.Icons.ObsoleteBlock;
          annotation(__Dymola_obsolete = "Model is not according to Modelica Language 3.0 since replaceable base class present. " + "Use instead one of Modelica.Blocks.Math.UnitConversions.XXX", defaultComponentName = "convert", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Line(points = {{ -90,0},{30,0}}, color = {191,0,0}),Polygon(points = {{90,0},{30,20},{30, -20},{90,0}}, lineColor = {191,0,0}, fillColor = {191,0,0}, fillPattern = FillPattern.Solid)}), Documentation(info = "<html>
<p>This block implements the Modelica.SIunits.Conversions functions as a fixed causality block to
simplify their use. The block contains a replaceable block class <b>ConversionBlock</b> that can be
changed to be any of the blocks defined in Modelica.Blocks.Math.UnitConversions, and more generally, any
blocks that extend from Modelica.Blocks.Interfaces.PartialConversionBlock.
</p>

<p
The desired conversion can be selected in the parameter menu
(the selected units are then displayed in the icon):</p>
</p>

<p>
<img src=\"../Modelica/Images/Blocks/ConvertAllUnits.png\">
</p>

</html>"));
        end ConvertAllUnits;
      end UnitConversions;
      block TwoInputs "Obsolete block. Use instead Modelica.Blocks.Math.InverseBlockConstraints"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        extends ObsoleteModelica3.Icons.ObsoleteBlock;
        annotation(structurallyIncomplete, __Dymola_obsolete = "Model is not balanced, i.e., not according to Modelica Language 3.0. Use instead Modelica.Blocks.Math.InverseBlockConstraints", Window(x = 0.15, y = 0.21, width = 0.6, height = 0.6), Documentation(info = "<HTML>
<p>
This block is used to enable asignment of values to variables preliminary
defined as outputs (e.g. useful for inverse model generation).
</p>

</HTML>
"), Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {2,2}), graphics = {Text(extent = {{ -95,50},{95, -50}}, lineColor = {0,0,127}, textString = "=")}));
        Modelica.Blocks.Interfaces.RealInput u1 "Connector of first Real input signal" annotation(layer = "icon", Placement(transformation(extent = {{ -139.742, -19.0044},{ -100,20}}, rotation = 0)));
        Modelica.Blocks.Interfaces.RealInput u2 "Connector of second Real input signal (u1=u2)" annotation(layer = "icon", Placement(transformation(origin = {120,0}, extent = {{ -20, -20},{20,20}}, rotation = 180)));

      equation 
        u1 = u2;
      end TwoInputs;
      block TwoOutputs "Obsolete block. Use instead Modelica.Blocks.Math.InverseBlockConstraints"
        extends Modelica.Blocks.Interfaces.BlockIcon;
        extends ObsoleteModelica3.Icons.ObsoleteBlock;
        annotation(structurallyIncomplete, __Dymola_obsolete = "Model is not balanced, i.e., not according to Modelica Language 3.0. Use instead Modelica.Blocks.Math.InverseBlockConstraints", Window(x = 0.21, y = 0.28, width = 0.6, height = 0.6), Documentation(info = "
<HTML>
<p>
This block is used to enable calculation of values preliminary defined as inputs.
(e.g. useful for inverse model generation).
</p>

</HTML>
"), Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {2,2}), graphics = {Text(extent = {{ -95,50},{95, -50}}, lineColor = {0,0,127}, textString = "=")}));
        output Modelica.Blocks.Interfaces.RealOutput y1 "Connector of first Real output signal" annotation(Placement(transformation(extent = {{100, -10},{120,10}}, rotation = 0)));
        output Modelica.Blocks.Interfaces.RealOutput y2 "Connector of second Real output signal (y1=y2)" annotation(Placement(transformation(origin = { -110.366, -0.90289}, extent = {{ -10.0005, -10},{10.0005,10}}, rotation = 180)));

      equation 
        y1 = y2;
      end TwoOutputs;
    end Math;
  end Blocks;
  package Electrical "Library of electrical models (analog, digital, machines, multi-phase)"
    package Analog "Library for analog electrical models"
      package Basic "Basic electrical components such as resistor, capacitor, transformer"
        model HeatingResistor "Obsolete model. Use Modelica.Electrical.Analog.Basic.HeatingResistor instead"
          extends Modelica.Electrical.Analog.Interfaces.OnePort;
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          parameter Modelica.SIunits.Resistance R_ref = 1 "Resistance at temperature T_ref";
          parameter Modelica.SIunits.Temperature T_ref = 300 "Reference temperature";
          parameter Real alpha(unit = "1/K") = 0 "Temperature coefficient of resistance";
          Modelica.SIunits.Resistance R "Resistance = R_ref*(1 + alpha*(heatPort.T - T_ref));";
          annotation(__Dymola_obsolete = "Model equations depend on cardinality(..) which will become obsolete in the Modelica language. Use instead Modelica.Electrical.Analog.Basic.HeatingResistor", Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Line(points = {{ -110,20},{ -85,20}}, color = {160,160,164}),Polygon(points = {{ -95,23},{ -85,20},{ -95,17},{ -95,23}}, lineColor = {160,160,164}, fillColor = {160,160,164}, fillPattern = FillPattern.Solid),Line(points = {{90,20},{115,20}}, color = {160,160,164}),Line(points = {{ -125,0},{ -115,0}}, color = {160,160,164}),Line(points = {{ -120, -5},{ -120,5}}, color = {160,160,164}),Text(extent = {{ -110,25},{ -90,45}}, lineColor = {160,160,164}, textString = "i"),Polygon(points = {{105,23},{115,20},{105,17},{105,23}}, lineColor = {160,160,164}, fillColor = {160,160,164}, fillPattern = FillPattern.Solid),Line(points = {{115,0},{125,0}}, color = {160,160,164}),Text(extent = {{90,45},{110,25}}, lineColor = {160,160,164}, textString = "i"),Rectangle(extent = {{ -70,30},{70, -30}}),Line(points = {{ -96,0},{ -70,0}}),Line(points = {{70,0},{96,0}}),Line(points = {{0, -30},{0, -90}}, color = {191,0,0}),Line(points = {{ -52, -50},{48,50}}, color = {0,0,255}),Polygon(points = {{40,52},{50,42},{54,56},{40,52}}, lineColor = {0,0,255}, fillColor = {0,0,255}, fillPattern = FillPattern.Solid)}), Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Text(extent = {{ -142,60},{143,118}}, textString = "%name"),Line(points = {{ -90,0},{ -70,0}}),Line(points = {{70,0},{90,0}}),Rectangle(extent = {{ -70,30},{70, -30}}, lineColor = {0,0,255}, fillColor = {255,255,255}, fillPattern = FillPattern.Solid),Line(points = {{0, -30},{0, -91}}, color = {191,0,0}),Line(points = {{ -52, -50},{48,50}}, color = {0,0,255}),Polygon(points = {{40,52},{50,42},{54,56},{40,52}}, lineColor = {0,0,255}, fillColor = {0,0,255}, fillPattern = FillPattern.Solid)}), Documentation(info = "<HTML>
<p>This is a model for an electrical resistor where the generated heat
is dissipated to the environment via connector <b>heatPort</b> and where
the resistance R is temperature dependent according to the following
equation:</p>
<pre>    R = R_ref*(1 + alpha*(heatPort.T - T_ref))
</pre>
<p><b>alpha</b> is the <b>temperature coefficient of resistance</b>, which
is often abbreviated as <b>TCR</b>. In resistor catalogues, it is usually
defined as <b>X [ppm/K]</b> (parts per million, similarly to per centage)
meaning <b>X*1.e-6 [1/K]</b>. Resistors are available for 1 .. 7000 ppm/K,
i.e., alpha = 1e-6 .. 7e-3 1/K;</p>
<p>When connector <b>heatPort</b> is <b>not</b> connected, the temperature
dependent behaviour is switched off by setting heatPort.T = T_ref.
Additionally, the equation <tt>heatPort.Q_flow = 0</tt> is implicitly present
due to a special rule in Modelica that flow variables of not connected
connectors are set to zero.</p>
</HTML>
", revisions = "<html>
<ul>
<li><i>  </i>
       </li>
<li><i> 2002   </i>
       by Anton Haumer<br> initially implemented<br>
       </li>
</ul>
</html>"));
          Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPort annotation(Placement(transformation(origin = {0, -100}, extent = {{10, -10},{ -10,10}}, rotation = 270)));

        equation 
          v = R * i;
          if cardinality(heatPort) > 0 then
            R = R_ref * (1 + alpha * (heatPort.T - T_ref));
            heatPort.Q_flow =  -v * i;

          else
            R = R_ref;
            heatPort.T = T_ref;

          end if;
        end HeatingResistor;
      end Basic;
    end Analog;
  end Electrical;
  package Icons "Library of icons"
    partial block ObsoleteBlock "Icon for an obsolete block (use only for this case)"
      annotation(__Dymola_obsolete = "Only used to mark an obsolete block. Do not use otherwise.", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -102,102},{102, -102}}, lineColor = {255,0,0}, pattern = LinePattern.Dash, lineThickness = 0.5)}), Documentation(info = "<html>
<p>
This partial block is intended to provide a <u>default icon
for an obsolete block</u> that will be removed from the
corresponding library in a future release.
<p>
</html>"));
    end ObsoleteBlock;
    partial model ObsoleteModel "Icon for an obsolete model (use only for this case)"
      annotation(__Dymola_obsolete = "Only used to mark an obsolete model. Do not use otherwise.", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -102,102},{102, -102}}, lineColor = {255,0,0}, pattern = LinePattern.Dash, lineThickness = 0.5)}), Documentation(info = "<html>
<p>
This partial model is intended to provide a <u>default icon
for an obsolete model</u> that will be removed from the
corresponding library in a future release.
<p>
</html>"));
    end ObsoleteModel;
    partial class Enumeration "Obsolete class (icon for an enumeration emulated by a package). Use a real enumeration instead"
      annotation(__Dymola_obsolete = "Icon for an emulated enumeration. Emulated enumerations are no longer used (only real enumerations)", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Text(extent = {{ -138,164},{138,104}}, textString = "%name"),Ellipse(extent = {{ -100,100},{100, -100}}, lineColor = {255,0,127}, fillColor = {255,255,255}, fillPattern = FillPattern.Solid),Text(extent = {{ -100,100},{100, -100}}, lineColor = {255,0,127}, textString = "e")}), Documentation(info = "<html>
<p>
This icon is designed for an <b>enumeration</b>
(that is emulated by a package).
</p>
</html>"));
    end Enumeration;
  end Icons;
  package Mechanics "Library of 1-dim. and 3-dim. mechanical components (multi-body, rotational, translational)"
    package MultiBody "Library to model 3-dimensional mechanical systems"
      package Forces "Components that exert forces and/or torques between frames"
        model WorldForceAndTorque "Obsolete model. Use instead Modelica.Mechanics.MultiBody.Forces.WorldForceAndTorque"
          import SI = Modelica.SIunits;
          import Modelica.Mechanics.MultiBody.Types;
          extends Modelica.Mechanics.MultiBody.Interfaces.PartialOneFrame_b;
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.Blocks.Interfaces.RealInput load[6] "[1:6] = x-, y-, z-coordinates of force and x-, y-, z-coordiantes of torque resolved in world frame" annotation(Placement(transformation(extent = {{ -140, -20},{ -100,20}}, rotation = 0)));
          parameter Boolean animation = true "= true, if animation shall be enabled";
          parameter Real N_to_m(unit = "N/m") = world.defaultN_to_m " Force arrow scaling (length = force/N_to_m)" annotation(Dialog(group = "if animation = true", enable = animation));
          parameter Real Nm_to_m(unit = "N.m/m") = world.defaultNm_to_m " Torque arrow scaling (length = torque/Nm_to_m)" annotation(Dialog(group = "if animation = true", enable = animation));
          input SI.Diameter forceDiameter = world.defaultArrowDiameter " Diameter of force arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input SI.Diameter torqueDiameter = forceDiameter " Diameter of torque arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.Color forceColor = Modelica.Mechanics.MultiBody.Types.Defaults.ForceColor " Color of force arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.Color torqueColor = Modelica.Mechanics.MultiBody.Types.Defaults.TorqueColor " Color of torque arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient "Reflection of ambient light (= 0: light is completely absorbed)" annotation(Dialog(group = "if animation = true", enable = animation));
          annotation(__Dymola_obsolete = "Based on a packed result signal which is not a good design. Use instead Modelica.Mechanics.MultiBody.Forces.WorldForceAndTorque", preferedView = "info", Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Polygon(points = {{ -100,10},{50,10},{50,31},{97,0},{50, -31},{50, -10},{ -100, -10},{ -100,10}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{ -100,11},{ -94,24},{ -86,39},{ -74,59},{ -65,71},{ -52,83},{ -35,92},{ -22,95},{ -8,95},{7,91},{19,84},{32,76},{44,66},{52,58},{58,51}}, color = {0,0,0}, thickness = 0.5),Polygon(points = {{97,18},{72,77},{38,42},{97,18}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid)}), Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Text(extent = {{ -74,62},{44,24}}, lineColor = {192,192,192}, textString = "world"),Polygon(points = {{ -100,10},{50,10},{50,31},{94,0},{50, -31},{50, -10},{ -100, -10},{ -100,10}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{ -137, -47},{148, -108}}, textString = "%name"),Line(points = {{ -98,14},{ -92,27},{ -84,42},{ -72,62},{ -63,74},{ -50,86},{ -33,95},{ -20,98},{ -6,98},{9,94},{21,87},{34,79},{46,69},{54,61},{60,54}}, color = {0,0,0}, thickness = 0.5),Polygon(points = {{99,21},{74,80},{40,45},{99,21}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid)}), Documentation(info = "<HTML>
<p>
The <b>6</b> signals of the <b>load</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>force</b> and as
the x-, y-, and z-coordinates of a <b>torque</b> resolved in the
<b>world frame</b> and acting at the frame connector to which this
component is attached. The input signals are mapped to the force
and torque in the following way:
</p>
<pre>
   force  = load[1:3]
   torque = load[4:6]
</pre>
<p>
The force and torque are by default visualized as an arrow (force)
and as a double arrow (torque) acting at the connector to which
they are connected. The diameters
and colors of the arrows are fixed and can be defined via
parameters <b>forceDiameter</b>, <b>torqueDiameter</b>,
<b>forceColor</b> and <b>torqueColor</b>. The arrows
point in the directions defined by the
inPort.signal signals. The lengths of the arrows are proportional
to the length of the force and torque vectors, respectively, using parameters
<b>N_to_m</b> and <b>Nm_to_m</b> as scaling factors. For example, if N_to_m = 100 N/m,
then a force of 350 N is displayed as an arrow of length 3.5 m.
</p>
<p>
An example how to use this model is given in the
following figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/WorldForceAndTorque1.png\">
</p>
<p>
This leads to the following animation
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/WorldForceAndTorque2.png\">
</p>
</HTML>
"));
          annotation(Coordsys(extent = [ -100, -100;100,100], grid = [1,1], component = [20,20]), Window(x = 0.18, y = 0.01, width = 0.8, height = 0.82), Documentation(info = "
An external force element exerts the inport signal
as negative force on the connector frame (the force vector
is resolved in the world frame).
"), Icon(Text(extent = [ -132,99;128,39], string = "%name"), Polygon(points = [ -100,10;49,10;49,31;100,0;49, -31;49, -10; -100, -10; -100,10], style(color = 0, gradient = 0, fillColor = 0, fillPattern = 1))), Diagram(Polygon(points = [ -90,10;40,10;40,31;91,0;40, -31;40, -10; -90, -10; -90,10], style(color = 0, gradient = 0, fillColor = 0, fillPattern = 1))));
        protected 
          SI.Position f_in_m[3] = frame_b.f / N_to_m "Force mapped from N to m for animation";
          SI.Position t_in_m[3] = frame_b.t / Nm_to_m "Torque mapped from Nm to m for animation";
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.Arrow forceArrow(diameter = forceDiameter, color = forceColor, specularCoefficient = specularCoefficient, R = frame_b.R, r = frame_b.r_0, r_tail = f_in_m, r_head =  -f_in_m) if world.enableAnimation and animation;
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.DoubleArrow torqueArrow(diameter = torqueDiameter, color = torqueColor, specularCoefficient = specularCoefficient, R = frame_b.R, r = frame_b.r_0, r_tail = t_in_m, r_head =  -t_in_m) if world.enableAnimation and animation;

        equation 
          frame_b.f =  -Modelica.Mechanics.MultiBody.Frames.resolve2(frame_b.R, load[1:3]);
          frame_b.t =  -Modelica.Mechanics.MultiBody.Frames.resolve2(frame_b.R, load[4:6]);
        end WorldForceAndTorque;
        model FrameForceAndTorque "Obsolete model. Use instead Modelica.Mechanics.MultiBody.Forces.ForceAndTorque"
          import SI = Modelica.SIunits;
          import Modelica.Mechanics.MultiBody.Types;
          extends Modelica.Mechanics.MultiBody.Interfaces.PartialOneFrame_b;
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.Mechanics.MultiBody.Interfaces.Frame_resolve frame_resolve "If connected, the input signals are resolved in this frame" annotation(Placement(transformation(origin = {0,100}, extent = {{16, -16},{ -16,16}}, rotation = 270)));
          Modelica.Blocks.Interfaces.RealInput load[6] "[1:6] = x-, y-, z-coordinates of force and x-, y-, z-coordiantes of torque resolved in frame_b or frame_resolved (if connected)" annotation(Placement(transformation(extent = {{ -140, -20},{ -100,20}}, rotation = 0)));
          parameter Boolean animation = true "= true, if animation shall be enabled";
          parameter Real N_to_m(unit = "N/m") = world.defaultN_to_m " Force arrow scaling (length = force/N_to_m)" annotation(Dialog(group = "if animation = true", enable = animation));
          parameter Real Nm_to_m(unit = "N.m/m") = world.defaultNm_to_m " Torque arrow scaling (length = torque/Nm_to_m)" annotation(Dialog(group = "if animation = true", enable = animation));
          input SI.Diameter forceDiameter = world.defaultArrowDiameter " Diameter of force arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input SI.Diameter torqueDiameter = forceDiameter " Diameter of torque arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.Color forceColor = Modelica.Mechanics.MultiBody.Types.Defaults.ForceColor " Color of force arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.Color torqueColor = Modelica.Mechanics.MultiBody.Types.Defaults.TorqueColor " Color of torque arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient "Reflection of ambient light (= 0: light is completely absorbed)" annotation(Dialog(group = "if animation = true", enable = animation));
          annotation(__Dymola_obsolete = "Based on a packed result signal which is not a good design. Use instead Modelica.Mechanics.MultiBody.Forces.ForceAndTorque", preferedView = "info", Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Polygon(points = {{ -100,10},{50,10},{50,31},{97,0},{50, -31},{50, -10},{ -100, -10},{ -100,10}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{ -100,11},{ -94,24},{ -86,39},{ -74,59},{ -65,71},{ -52,83},{ -35,92},{ -22,95},{ -8,95},{7,91},{19,84},{32,76},{44,66},{52,58},{58,51}}, color = {0,0,0}),Polygon(points = {{97,18},{72,77},{38,42},{97,18}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{0,97},{0,10}}, color = {95,95,95}, pattern = LinePattern.Dot)}), Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Text(extent = {{ -74,62},{44,24}}, lineColor = {192,192,192}, textString = "resolve"),Polygon(points = {{ -100,10},{50,10},{50,31},{94,0},{50, -31},{50, -10},{ -100, -10},{ -100,10}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{ -137, -47},{148, -108}}, textString = "%name"),Line(points = {{ -100,10},{ -92,26},{ -84,42},{ -76,52},{ -60,68},{ -46,76},{ -31,82},{ -17,85},{ -2,87},{14,86},{26,82},{37,75},{46,69},{54,61},{60,54}}, color = {0,0,0}),Polygon(points = {{99,21},{74,80},{40,45},{99,21}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{0,95},{0,10}}, color = {95,95,95}, pattern = LinePattern.Dot)}), Documentation(info = "<HTML>
<p>
The <b>6</b> signals of the <b>load</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>force</b> and as
the x-, y-, and z-coordinates of a <b>torque</b> acting at the frame
connector to which this component is attached. If connector
<b>frame_resolve</b> is <b>not</b> connected, the force and torque coordinates
are with respect to <b>frame_b</b>. If connector
<b>frame_resolve</b> is connected, the force and torque coordinates
are with respect to <b>frame_resolve</b>. In this case the
force and torque in connector frame_resolve are set to zero,
i.e., this connector is solely used to provide the information
of the coordinate system, in which the force coordinates
are defined. The input signals are mapped to the force
and torque in the following way:
</p>
<pre>
   force  = load[1:3]
   torque = load[4:6]
</pre>
<p>
The force and torque are by default visualized as an arrow (force)
and as a double arrow (torque) acting at the connector to which
they are connected. The diameters
and colors of the arrows are fixed and can be defined via
parameters <b>forceDiameter</b>, <b>torqueDiameter</b>,
<b>forceColor</b> and <b>torqueColor</b>. The arrows
point in the directions defined by the
inPort.signal signals. The lengths of the arrows are proportional
to the length of the force and torque vectors, respectively, using parameters
<b>N_to_m</b> and <b>Nm_to_m</b> as scaling factors. For example,
if N_to_m = 100 N/m,
then a force of 350 N is displayed as an arrow of length 3.5 m.
</p>
<p>
An example how to use this model is given in the
following figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/FrameForceAndTorque1.png\">
</p>
<p>
This leads to the following animation
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/FrameForceAndTorque2.png\">
</p>
</HTML>
"));
          annotation(Coordsys(extent = [ -100, -100;100,100], grid = [1,1], component = [20,20]), Window(x = 0.18, y = 0.01, width = 0.8, height = 0.82), Documentation(info = "
An external force element exerts the inport signal
as negative force on the connector frame (the force vector
is resolved in the world frame).
"), Icon(Text(extent = [ -132,99;128,39], string = "%name"), Polygon(points = [ -100,10;49,10;49,31;100,0;49, -31;49, -10; -100, -10; -100,10], style(color = 0, gradient = 0, fillColor = 0, fillPattern = 1))), Diagram(Polygon(points = [ -90,10;40,10;40,31;91,0;40, -31;40, -10; -90, -10; -90,10], style(color = 0, gradient = 0, fillColor = 0, fillPattern = 1))));
        protected 
          SI.Position f_in_m[3] = frame_b.f / N_to_m "Force mapped from N to m for animation";
          SI.Position t_in_m[3] = frame_b.t / Nm_to_m "Torque mapped from Nm to m for animation";
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.Arrow forceArrow(diameter = forceDiameter, color = forceColor, specularCoefficient = specularCoefficient, R = frame_b.R, r = frame_b.r_0, r_tail = f_in_m, r_head =  -f_in_m) if world.enableAnimation and animation;
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.DoubleArrow torqueArrow(diameter = torqueDiameter, color = torqueColor, specularCoefficient = specularCoefficient, R = frame_b.R, r = frame_b.r_0, r_tail = t_in_m, r_head =  -t_in_m) if world.enableAnimation and animation;

        equation 
          if cardinality(frame_resolve) == 0 then
            frame_b.f =  -load[1:3];
            frame_b.t =  -load[4:6];
            frame_resolve.r_0 = zeros(3);
            frame_resolve.R = Modelica.Mechanics.MultiBody.Frames.nullRotation();

          else
            frame_b.f =  -Modelica.Mechanics.MultiBody.Frames.resolveRelative(load[1:3], frame_resolve.R, frame_b.R);
            frame_b.t =  -Modelica.Mechanics.MultiBody.Frames.resolveRelative(load[4:6], frame_resolve.R, frame_b.R);
            frame_resolve.f = zeros(3);
            frame_resolve.t = zeros(3);

          end if;
        end FrameForceAndTorque;
        model ForceAndTorque "Obsolete model. Use instead Modelica.Mechanics.MultiBody.Forces.ForceAndTorque"
          import SI = Modelica.SIunits;
          import Modelica.Mechanics.MultiBody.Types;
          extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.Mechanics.MultiBody.Interfaces.Frame_resolve frame_resolve "If connected, the input signals are resolved in this frame" annotation(Placement(transformation(origin = {40,100}, extent = {{ -16, -16},{16,16}}, rotation = 90)));
          Modelica.Blocks.Interfaces.RealInput load[6] "[1:6] = x-, y-, z-coordinates of force and x-, y-, z-coordiantes of torque resolved in frame_b or frame_resolved (if connected)" annotation(Placement(transformation(origin = { -60,120}, extent = {{ -20, -20},{20,20}}, rotation = 270)));
          parameter Boolean animation = true "= true, if animation shall be enabled";
          parameter Real N_to_m(unit = "N/m") = world.defaultN_to_m " Force arrow scaling (length = force/N_to_m)" annotation(Dialog(group = "if animation = true", enable = animation));
          parameter Real Nm_to_m(unit = "N.m/m") = world.defaultNm_to_m " Torque arrow scaling (length = torque/Nm_to_m)" annotation(Dialog(group = "if animation = true", enable = animation));
          input SI.Diameter forceDiameter = world.defaultArrowDiameter " Diameter of force arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input SI.Diameter torqueDiameter = forceDiameter " Diameter of torque arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input SI.Diameter connectionLineDiameter = forceDiameter " Diameter of line connecting frame_a and frame_b" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.Color forceColor = Modelica.Mechanics.MultiBody.Types.Defaults.ForceColor " Color of force arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.Color torqueColor = Modelica.Mechanics.MultiBody.Types.Defaults.TorqueColor " Color of torque arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.Color connectionLineColor = Modelica.Mechanics.MultiBody.Types.Defaults.SensorColor " Color of line connecting frame_a and frame_b" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient "Reflection of ambient light (= 0: light is completely absorbed)" annotation(Dialog(group = "if animation = true", enable = animation));
          SI.Position r_0[3] "Position vector from origin of frame_a to origin of frame_b resolved in world frame";
          SI.Force f_b_0[3] "frame_b.f resoved in world frame";
          SI.Torque t_b_0[3] "frame_b.t resoved in world frame";
          annotation(__Dymola_obsolete = "Based on a packed result signal which is not a good design. Use instead Modelica.Mechanics.MultiBody.Forces.ForceAndTorque", preferedView = "info", Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -98,99},{99, -98}}, lineColor = {255,255,255}, fillColor = {255,255,255}, fillPattern = FillPattern.Solid),Text(extent = {{ -59,55},{72,30}}, lineColor = {192,192,192}, textString = "resolve"),Text(extent = {{ -136, -52},{149, -113}}, textString = "%name"),Polygon(points = {{100,21},{84,55},{69,39},{100,21}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{40,100},{40,0}}, color = {95,95,95}, pattern = LinePattern.Dot),Polygon(points = {{ -95,1},{ -64,11},{ -64, -10},{ -95,1}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Polygon(points = {{ -100,20},{ -86,53},{ -70,42},{ -100,20}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{ -60,100},{40,100}}, color = {95,95,95}, pattern = LinePattern.Dot),Polygon(points = {{94,0},{65,12},{65, -11},{94,0}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{ -64,0},{ -20,0}}, color = {0,0,0}),Line(points = {{20,0},{65,0}}, color = {0,0,0}),Line(points = {{ -79,47},{ -70,61},{ -59,72},{ -45,81},{ -32,84},{ -20,85}}, color = {0,0,0}),Line(points = {{76,47},{66,60},{55,69},{49,74},{41,80},{31,84},{20,85}}, color = {0,0,0})}), Documentation(info = "<HTML>
<p>
The <b>6</b> signals of the <b>load</b> connector are interpreted
as the x-, y- and z-coordinates of a <b>force</b> and as
the x-, y-, and z-coordinates of a <b>torque</b> acting at the frame
connector to which frame_b of this component is attached. If connector
<b>frame_resolve</b> is <b>not</b> connected, the force and torque coordinates
are with respect to <b>frame_b</b>. If connector
<b>frame_resolve</b> is connected, the force and torque coordinates
are with respect to <b>frame_resolve</b>. In this case the
force and torque in connector frame_resolve are set to zero,
i.e., this connector is solely used to provide the information
of the coordinate system, in which the force/torque coordinates
are defined. The input signals are mapped to the force
and torque in the following way:
</p>
<pre>
   force  = load[1:3]
   torque = load[4:6]
</pre>
<p>
Additionally, a force and torque acts on frame_a in such a way that
the force and torque balance between frame_a and frame_b is fulfilled.
</p>
<p>
An example how to use this model is given in the
following figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/ForceAndTorque1.png\">
</p>
<p>
This leads to the following animation (the yellow cylinder
characterizes the line between frame_a and frame_b of the
ForceAndTorque component, i.e., the force and torque acts with
negative sign
also on the opposite side of this cylinder, but for
clarity this is not shown in the animation):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Forces/ForceAndTorque2.png\">
</p>
</HTML>
"));
          annotation(Coordsys(extent = [ -100, -100;100,100], grid = [1,1], component = [20,20]), Window(x = 0.18, y = 0.01, width = 0.8, height = 0.82), Documentation(info = "
An external force element exerts the inport signal
as negative force on the connector frame (the force vector
is resolved in the world frame).
"), Icon(Text(extent = [ -132,99;128,39], string = "%name"), Polygon(points = [ -100,10;49,10;49,31;100,0;49, -31;49, -10; -100, -10; -100,10], style(color = 0, gradient = 0, fillColor = 0, fillPattern = 1))), Diagram(Polygon(points = [ -90,10;40,10;40,31;91,0;40, -31;40, -10; -90, -10; -90,10], style(color = 0, gradient = 0, fillColor = 0, fillPattern = 1))));
        protected 
          SI.Position f_in_m[3] = frame_b.f / N_to_m "Force mapped from N to m for animation";
          SI.Position t_in_m[3] = frame_b.t / Nm_to_m "Torque mapped from Nm to m for animation";
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.Arrow forceArrow(diameter = forceDiameter, color = forceColor, specularCoefficient = specularCoefficient, R = frame_b.R, r = frame_b.r_0, r_tail = f_in_m, r_head =  -f_in_m) if world.enableAnimation and animation;
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.DoubleArrow torqueArrow(diameter = torqueDiameter, color = torqueColor, specularCoefficient = specularCoefficient, R = frame_b.R, r = frame_b.r_0, r_tail = t_in_m, r_head =  -t_in_m) if world.enableAnimation and animation;
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape connectionLine(shapeType = "cylinder", lengthDirection = r_0, widthDirection = {0,1,0}, length = Modelica.Math.Vectors.length(r_0), width = connectionLineDiameter, height = connectionLineDiameter, color = connectionLineColor, specularCoefficient = specularCoefficient, r = frame_a.r_0) if world.enableAnimation and animation;

        equation 
          if cardinality(frame_resolve) == 0 then
            frame_b.f =  -load[1:3];
            frame_b.t =  -load[4:6];
            f_b_0 = Modelica.Mechanics.MultiBody.Frames.resolve1(frame_b.R, frame_b.f);
            t_b_0 = Modelica.Mechanics.MultiBody.Frames.resolve1(frame_b.R, frame_b.t);
            frame_resolve.r_0 = zeros(3);
            frame_resolve.R = Modelica.Mechanics.MultiBody.Frames.nullRotation();

          else
            f_b_0 =  -Modelica.Mechanics.MultiBody.Frames.resolve1(frame_resolve.R, load[1:3]);
            t_b_0 =  -Modelica.Mechanics.MultiBody.Frames.resolve1(frame_resolve.R, load[4:6]);
            frame_b.f = Modelica.Mechanics.MultiBody.Frames.resolve2(frame_b.R, f_b_0);
            frame_b.t = Modelica.Mechanics.MultiBody.Frames.resolve2(frame_b.R, t_b_0);
            frame_resolve.f = zeros(3);
            frame_resolve.t = zeros(3);

          end if;
          r_0 = frame_b.r_0 - frame_a.r_0;
          zeros(3) = frame_a.f + Modelica.Mechanics.MultiBody.Frames.resolve2(frame_a.R, f_b_0);
          zeros(3) = frame_a.t + Modelica.Mechanics.MultiBody.Frames.resolve2(frame_a.R, t_b_0 + cross(r_0, f_b_0));
        end ForceAndTorque;
      end Forces;
      package Interfaces "Connectors and partial models for 3-dim. mechanical components"
        partial model PartialCutForceSensor "Obsolete model. Use instead instead a model from Modelica.Mechanics.MultiBody.Sensors"
          extends Modelica.Icons.RotationalSensor;
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.Mechanics.MultiBody.Interfaces.Frame_a frame_a "Coordinate system with one cut-force and cut-torque" annotation(Placement(transformation(extent = {{ -116, -16},{ -84,16}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_b "Coordinate system with one cut-force and cut-torque" annotation(Placement(transformation(extent = {{84, -16},{116,16}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Interfaces.Frame_resolve frame_resolve "If connected, the output signals are resolved in this frame (cut-force/-torque are set to zero)" annotation(Placement(transformation(origin = {80, -100}, extent = {{ -16, -16},{16,16}}, rotation = 270)));
          annotation(Window(x = 0.37, y = 0.02, width = 0.6, height = 0.65), __Dymola_obsolete = "Model equations depend on cardinality(..) which will become obsolete in the Modelica language. Use instead a model from Modelica.Mechanics.MultiBody.Sensors", Documentation(info = "
<HTML>
<p>
This is a base class for 3-dim. mechanical components with two frames
and one output port in order to measure the cut-force and/or
cut-torque acting between the two frames and
to provide the measured signals as output for further processing
with the blocks of package Modelica.Blocks.
</p>
</HTML>
"), Icon(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Line(points = {{ -70,0},{ -101,0}}, color = {0,0,0}),Line(points = {{70,0},{100,0}}, color = {0,0,0}),Line(points = {{ -80, -100},{ -80,0}}, color = {0,0,127}),Text(extent = {{ -132,76},{129,124}}, textString = "%name", lineColor = {0,0,255}),Text(extent = {{ -118,55},{ -82,30}}, lineColor = {128,128,128}, textString = "a"),Text(extent = {{83,55},{119,30}}, lineColor = {128,128,128}, textString = "b"),Text(extent = {{ -31, -72},{100, -97}}, lineColor = {192,192,192}, textString = "resolve"),Line(points = {{80,0},{80, -100}}, color = {95,95,95}, pattern = LinePattern.Dot)}), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Line(points = {{ -70,0},{ -100,0}}, color = {0,0,0}),Line(points = {{70,0},{100,0}}, color = {0,0,0}),Line(points = {{ -80, -100},{ -80,0}}, color = {0,0,127}),Line(points = {{80,0},{80, -100}}, color = {95,95,95}, pattern = LinePattern.Dot)}));
        protected 
          outer Modelica.Mechanics.MultiBody.World world;

        equation 
          defineBranch(frame_a.R, frame_b.R);
          assert(cardinality(frame_a) > 0, "Connector frame_a of cut-force/-torque sensor object is not connected");
          assert(cardinality(frame_b) > 0, "Connector frame_b of cut-force/-torque sensor object is not connected");
          frame_a.r_0 = frame_b.r_0;
          frame_a.R = frame_b.R;
          zeros(3) = frame_a.f + frame_b.f;
          zeros(3) = frame_a.t + frame_b.t;
          if cardinality(frame_resolve) == 1 then
            frame_resolve.f = zeros(3);
            frame_resolve.t = zeros(3);

          else
            frame_resolve.r_0 = zeros(3);
            frame_resolve.R = Modelica.Mechanics.MultiBody.Frames.nullRotation();

          end if;
        end PartialCutForceSensor;
      end Interfaces;
      package Joints
        package Internal
          model RevoluteWithLengthConstraint "Obsolete model. Use instead Modelica.Mechanics.MultiBody.Joints.Internal.RevoluteWithLengthConstraint"
            import SI = Modelica.SIunits;
            import Cv = Modelica.SIunits.Conversions;
            extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
            extends ObsoleteModelica3.Icons.ObsoleteModel;
            Modelica.Mechanics.Rotational.Interfaces.Flange_a axis "1-dim. rotational flange that drives the joint" annotation(Placement(transformation(extent = {{10,90},{ -10,110}}, rotation = 0)));
            Modelica.Mechanics.Rotational.Interfaces.Flange_b bearing "1-dim. rotational flange of the drive bearing" annotation(Placement(transformation(extent = {{ -50,90},{ -70,110}}, rotation = 0)));
            Modelica.Blocks.Interfaces.RealInput position_a[3] "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint" annotation(Placement(transformation(extent = {{ -140, -80},{ -100, -40}}, rotation = 0)));
            Modelica.Blocks.Interfaces.RealInput position_b[3] "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint" annotation(Placement(transformation(extent = {{140, -80},{100, -40}}, rotation = 0)));
            parameter Boolean animation = true "= true, if animation shall be enabled";
            parameter SI.Position lengthConstraint = 1 "Fixed length of length constraint";
            parameter Modelica.Mechanics.MultiBody.Types.Axis n = {0,0,1} "Axis of rotation resolved in frame_a (= same as in frame_b)" annotation(Evaluate = true);
            parameter Cv.NonSIunits.Angle_deg phi_offset = 0 "Relative angle offset (angle = phi + from_deg(phi_offset))";
            parameter Cv.NonSIunits.Angle_deg phi_guess = 0 "Select the configuration such that at initial time |phi - from_deg(phi_guess)|is minimal";
            parameter SI.Distance cylinderLength = world.defaultJointLength "Length of cylinder representing the joint axis" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
            parameter SI.Distance cylinderDiameter = world.defaultJointWidth "Diameter of cylinder representing the joint axis" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
            input Modelica.Mechanics.MultiBody.Types.Color cylinderColor = Modelica.Mechanics.MultiBody.Types.Defaults.JointColor "Color of cylinder representing the joint axis" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
            input Modelica.Mechanics.MultiBody.Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient "Reflection of ambient light (= 0: light is completely absorbed)" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
            parameter Boolean axisTorqueBalance = true "= true, if torque balance of flange axis with the frame_b connector (axis.tau = -e*frame_b.t) shall be defined. Otherwise this equation has to be provided outside of this joint" annotation(Dialog(tab = "Advanced"));
            final parameter Boolean positiveBranch(fixed = false) "Based on phi_guess, selection of one of the two solutions of the non-linear constraint equation";
            final parameter Real e[3](each final unit = "1") = Modelica.Math.Vectors.normalize(n) "Unit vector in direction of rotation axis, resolved in frame_a";
            SI.Angle phi "Rotation angle of revolute joint";
            Modelica.Mechanics.MultiBody.Frames.Orientation R_rel "Relative orientation object from frame_a to frame_b";
            SI.Angle angle "= phi + from_deg(phi_offset) (relative rotation angle between frame_a and frame_b)";
            SI.Torque tau "= axis.tau (driving torque in the axis)";
            annotation(structurallyIncomplete, preferedView = "info", __Dymola_obsolete = "Obsolete model that is not balanced. Use instead Modelica.Mechanics.MultiBody.Joints.Internal.RevoluteWithLengthConstraint", Window(x = 0.05, y = 0.09, width = 0.65, height = 0.69), Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Rectangle(extent = {{ -30,10},{10, -10}}, lineColor = {0,0,0}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -100, -60},{ -30,60}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192,192,192}),Rectangle(extent = {{30, -60},{100,60}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192,192,192}),Text(extent = {{ -139, -168},{137, -111}}, textString = "%name"),Rectangle(extent = {{ -100,60},{ -30, -60}}, lineColor = {0,0,0}),Rectangle(extent = {{30,60},{100, -60}}, lineColor = {0,0,0}),Text(extent = {{ -142, -108},{147, -69}}, lineColor = {0,0,0}, textString = "n=%n"),Line(points = {{ -60,60},{ -60,90}}, color = {0,0,0}),Line(points = {{ -20,70},{ -60,70}}, color = {0,0,0}),Line(points = {{ -20,80},{ -20,60}}, color = {0,0,0}),Line(points = {{20,80},{20,60}}, color = {0,0,0}),Line(points = {{20,70},{41,70}}, color = {0,0,0}),Polygon(points = {{ -9,30},{10,30},{30,50},{ -29,50},{ -9,30}}, lineColor = {0,0,0}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Polygon(points = {{10,30},{30,50},{30, -51},{10, -31},{10,30}}, lineColor = {0,0,0}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -10,90},{10,50}}, lineColor = {0,0,0}, fillPattern = FillPattern.VerticalCylinder, fillColor = {192,192,192})}), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Rectangle(extent = {{ -100, -60},{ -30,60}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192,192,192}),Rectangle(extent = {{ -30,10},{10, -10}}, lineColor = {0,0,0}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Rectangle(extent = {{30, -60},{100,60}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192,192,192}),Line(points = {{ -60,60},{ -60,96}}, color = {0,0,0}),Line(points = {{ -20,70},{ -60,70}}, color = {0,0,0}),Line(points = {{ -20,80},{ -20,60}}, color = {0,0,0}),Line(points = {{20,80},{20,60}}, color = {0,0,0}),Line(points = {{20,70},{41,70}}, color = {0,0,0}),Polygon(points = {{ -9,30},{10,30},{30,50},{ -29,50},{ -9,30}}, lineColor = {0,0,0}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Polygon(points = {{10,30},{30,50},{30, -51},{10, -31},{10,30}}, lineColor = {0,0,0}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -10,50},{10,100}}, lineColor = {0,0,0}, fillPattern = FillPattern.VerticalCylinder, fillColor = {192,192,192})}), Documentation(info = "<HTML>
<p>
Joint where frame_b rotates around axis n which is fixed in frame_a.
The two frames coincide when \"phi + phi_offset = 0\", where
\"phi_offset\" is a parameter with a zero default
and \"phi\" is the rotation angle.
</p>
<p>
This variant of the revolute joint is designed to work together
with a length constraint in a kinematic loop. This means that the
angle of the revolute joint, phi, is computed such that the
length constraint is fulfilled.
</p>
<p>
<b>Usually, this joint should not be used by a user of the MultiBody
library. It is only provided to built-up the Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXYZ
joints.</b>
</p>
</HTML>
"));
          protected 
            SI.Position r_a[3] = position_a "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint";
            SI.Position r_b[3] = position_b "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint";
            Real e_r_a "Projection of r_a on e";
            Real e_r_b "Projection of r_b on e";
            Real A "Coefficient A of equation: A*cos(phi) + B*sin(phi) + C = 0";
            Real B "Coefficient B of equation: A*cos(phi) + B*sin(phi) + C = 0";
            Real C "Coefficient C of equation: A*cos(phi) + B*sin(phi) + C = 0";
            Real k1 "Constant of quadratic equation";
            Real k2 "Constant of quadratic equation";
            Real k1a(start = 1);
            Real k1b;
            Real kcos_angle "= k1*cos(angle)";
            Real ksin_angle "= k1*sin(angle)";
            Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape cylinder(shapeType = "cylinder", color = cylinderColor, specularCoefficient = specularCoefficient, length = cylinderLength, width = cylinderDiameter, height = cylinderDiameter, lengthDirection = e, widthDirection = {0,1,0}, r_shape =  -e * cylinderLength / 2, r = frame_a.r_0, R = frame_a.R) if world.enableAnimation and animation;
            function selectBranch "Determine branch which is closest to initial angle=0"
              import Modelica.Math.*;
              input SI.Length L "Length of length constraint";
              input Real e[3](each final unit = "1") "Unit vector along axis of rotation, resolved in frame_a (= same in frame_b)";
              input SI.Angle angle_guess "Select the configuration such that at initial time |angle-angle_guess|is minimal (angle=0: frame_a and frame_b coincide)";
              input SI.Position r_a[3] "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint";
              input SI.Position r_b[3] "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint";
              output Boolean positiveBranch "Branch of the initial solution";
            protected 
              Real e_r_a "Projection of r_a on e";
              Real e_r_b "Projection of r_b on e";
              Real A "Coefficient A of equation: A*cos(phi) + B*sin(phi) + C = 0";
              Real B "Coefficient B of equation: A*cos(phi) + B*sin(phi) + C = 0";
              Real C "Coefficient C of equation: A*cos(phi) + B*sin(phi) + C = 0";
              Real k1 "Constant of quadratic equation";
              Real k2 "Constant of quadratic equation";
              Real kcos1 "k1*cos(angle1)";
              Real ksin1 "k1*sin(angle1)";
              Real kcos2 "k2*cos(angle2)";
              Real ksin2 "k2*sin(angle2)";
              SI.Angle angle1 "solution 1 of nonlinear equation";
              SI.Angle angle2 "solution 2 of nonlinear equation";
            algorithm 
              e_r_a:=e * r_a;
              e_r_b:=e * r_b;
              A:= -2 * (r_b * r_a - e_r_b * e_r_a);
              B:=2 * r_b * cross(e, r_a);
              C:=r_a * r_a + r_b * r_b - L * L - 2 * e_r_b * e_r_a;
              k1:=A * A + B * B;
              k2:=sqrt(k1 - C * C);
              kcos1:= -A * C + B * k2;
              ksin1:= -B * C - A * k2;
              angle1:=atan2(ksin1, kcos1);
              kcos2:= -A * C - B * k2;
              ksin2:= -B * C + A * k2;
              angle2:=atan2(ksin2, kcos2);
              if abs(angle1 - angle_guess) <= abs(angle2 - angle_guess) then 
                            positiveBranch:=true;

              else               positiveBranch:=false;

              end if;
            end selectBranch;

          initial equation 
            positiveBranch = selectBranch(lengthConstraint, e, Cv.from_deg(phi_offset + phi_guess), r_a, r_b);

          equation 
            Connections.branch(frame_a.R, frame_b.R);
            axis.tau = tau;
            axis.phi = phi;
            bearing.phi = 0;
            angle = Cv.from_deg(phi_offset) + phi;
            frame_b.r_0 = frame_a.r_0;
            R_rel = Modelica.Mechanics.MultiBody.Frames.planarRotation(e, angle, der(angle));
            frame_b.R = Modelica.Mechanics.MultiBody.Frames.absoluteRotation(frame_a.R, R_rel);
            zeros(3) = frame_a.f + Modelica.Mechanics.MultiBody.Frames.resolve1(R_rel, frame_b.f);
            zeros(3) = frame_a.t + Modelica.Mechanics.MultiBody.Frames.resolve1(R_rel, frame_b.t);
if axisTorqueBalance then
                          tau =  -e * frame_b.t;
            end if;
            e_r_a = e * r_a;
            e_r_b = e * r_b;
            A =  -2 * (r_b * r_a - e_r_b * e_r_a);
            B = 2 * r_b * cross(e, r_a);
            C = r_a * r_a + r_b * r_b - lengthConstraint * lengthConstraint - 2 * e_r_b * e_r_a;
            k1 = A * A + B * B;
            k1a = k1 - C * C;
            assert(k1a > 1e-10, "
Singular position of loop (either no or two analytic solutions;
the mechanism has lost one-degree-of freedom in this position).
Try first to use another Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXXX component.
In most cases it is best that the joints outside of the JointXXX
component are revolute and NOT prismatic joints. If this also
lead to singular positions, it could be that this kinematic loop
cannot be solved analytically. In this case you have to build
up the loop with basic joints (NO aggregation JointXXX components)
and rely on dynamic state selection, i.e., during simulation
the states will be dynamically selected in such a way that in no
position a degree of freedom is lost.
");
            k1b = Modelica.Mechanics.MultiBody.Frames.Internal.maxWithoutEvent(k1a, 1e-12);
            k2 = sqrt(k1b);
            kcos_angle =  -A * C + (if positiveBranch then B else  -B) * k2;
            ksin_angle =  -B * C + (if positiveBranch then  -A else A) * k2;
            angle = Modelica.Math.atan2(ksin_angle, kcos_angle);
          end RevoluteWithLengthConstraint;
          model PrismaticWithLengthConstraint "Obsolete model. Use instead Modelica.Mechanics.MultiBody.Joints.Internal.PrismaticWithLengthConstraint"
            import SI = Modelica.SIunits;
            import Cv = Modelica.SIunits.Conversions;
            extends Modelica.Mechanics.MultiBody.Interfaces.PartialTwoFrames;
            extends ObsoleteModelica3.Icons.ObsoleteModel;
            Modelica.Mechanics.Translational.Interfaces.Flange_a axis "1-dim. translational flange that drives the joint" annotation(Placement(transformation(extent = {{70,80},{90,60}}, rotation = 0)));
            Modelica.Mechanics.Translational.Interfaces.Flange_b bearing "1-dim. translational flange of the drive bearing" annotation(Placement(transformation(extent = {{ -30,80},{ -50,60}}, rotation = 0)));
            Modelica.Blocks.Interfaces.RealInput position_a[3] "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint" annotation(Placement(transformation(extent = {{ -140, -80},{ -100, -40}}, rotation = 0)));
            Modelica.Blocks.Interfaces.RealInput position_b[3] "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint" annotation(Placement(transformation(extent = {{140, -80},{100, -40}}, rotation = 0)));
            parameter Boolean animation = true "= true, if animation shall be enabled";
            parameter SI.Position length = 1 "Fixed length of length constraint";
            parameter Modelica.Mechanics.MultiBody.Types.Axis n = {1,0,0} "Axis of translation resolved in frame_a (= same as in frame_b)" annotation(Evaluate = true);
            parameter SI.Position s_offset = 0 "Relative distance offset (distance between frame_a and frame_b = s(t) + s_offset)";
            parameter SI.Position s_guess = 0 "Select the configuration such that at initial time |s(t0)-s_guess|is minimal";
            parameter Modelica.Mechanics.MultiBody.Types.Axis boxWidthDirection = {0,1,0} "Vector in width direction of box, resolved in frame_a" annotation(Evaluate = true, Dialog(tab = "Animation", group = "if animation = true", enable = animation));
            parameter SI.Distance boxWidth = world.defaultJointWidth "Width of prismatic joint box" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
            parameter SI.Distance boxHeight = boxWidth "Height of prismatic joint box" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
            input Modelica.Mechanics.MultiBody.Types.Color boxColor = Modelica.Mechanics.MultiBody.Types.Defaults.JointColor "Color of prismatic joint box" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
            input Modelica.Mechanics.MultiBody.Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient "Reflection of ambient light (= 0: light is completely absorbed)" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
            parameter Boolean axisForceBalance = true "= true, if force balance of flange axis with the frame_b connector (axis.f = -e*frame_b.f) shall be defined. Otherwise this equation has to be provided outside of this joint" annotation(Dialog(tab = "Advanced"));
            final parameter Boolean positiveBranch(fixed = false) "Selection of one of the two solutions of the non-linear constraint equation";
            final parameter Real e[3](each final unit = "1") = Modelica.Math.Vectors.normalize(n) "Unit vector in direction of translation axis, resolved in frame_a";
            SI.Position s "Relative distance between frame_a and frame_b along axis n = s + s_offset)";
            SI.Position distance "Relative distance between frame_a and frame_b along axis n";
            SI.Position r_rel_a[3] "Position vector from frame_a to frame_b resolved in frame_a";
            SI.Force f "= axis.f (driving force in the axis)";
            annotation(structurallyIncomplete, preferedView = "info", __Dymola_obsolete = "Obsolete model that is not balanced. Use instead Modelica.Mechanics.MultiBody.Joints.Internal.PrismaticWithLengthConstraint", Window(x = 0.05, y = 0.09, width = 0.65, height = 0.69), Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Rectangle(extent = {{ -30, -40},{100,30}}, lineColor = {0,0,255}, pattern = LinePattern.None, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -30,40},{100, -40}}, lineColor = {0,0,0}),Rectangle(extent = {{ -100, -60},{ -30,50}}, lineColor = {0,0,255}, pattern = LinePattern.None, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -100,50},{ -30,60}}, lineColor = {0,0,255}, pattern = LinePattern.None, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -30,30},{100,40}}, lineColor = {0,0,255}, pattern = LinePattern.None, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{ -136, -170},{140, -113}}, textString = "%name"),Rectangle(extent = {{ -100,60},{ -30, -60}}, lineColor = {0,0,0}),Line(points = {{100, -40},{100, -60}}),Rectangle(extent = {{100,40},{90,80}}, lineColor = {0,0,0}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Text(extent = {{ -136, -116},{153, -77}}, lineColor = {0,0,0}, textString = "n=%n")}), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Line(points = {{ -30, -50},{ -30,50}}, color = {0,0,0}),Line(points = {{0, -67},{90, -67}}, color = {128,128,128}),Text(extent = {{31, -68},{68, -81}}, lineColor = {128,128,128}, textString = "s"),Line(points = {{ -100, -67},{0, -67}}, color = {128,128,128}),Polygon(points = {{ -39, -64},{ -29, -67},{ -39, -70},{ -39, -64}}, lineColor = {128,128,128}, fillColor = {128,128,128}, fillPattern = FillPattern.Solid),Text(extent = {{ -77, -70},{ -43, -85}}, lineColor = {128,128,128}, textString = "s_offset"),Line(points = {{ -100, -71},{ -100, -51}}, color = {128,128,128}),Line(points = {{ -30, -73},{ -30, -33}}, color = {128,128,128}),Line(points = {{100, -70},{100, -30}}, color = {128,128,128}),Polygon(points = {{90, -64},{100, -67},{90, -70},{90, -64}}, lineColor = {128,128,128}, fillColor = {128,128,128}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -100,50},{ -30,60}}, lineColor = {0,0,255}, pattern = LinePattern.None, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -100, -60},{ -30,50}}, lineColor = {0,0,255}, pattern = LinePattern.None, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -30,40},{100, -40}}, lineColor = {0,0,0}),Rectangle(extent = {{ -30, -40},{100,30}}, lineColor = {0,0,255}, pattern = LinePattern.None, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -30,30},{100,40}}, lineColor = {0,0,255}, pattern = LinePattern.None, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -100,60},{ -30, -60}}, lineColor = {0,0,0}),Line(points = {{100, -40},{100, -60}}),Text(extent = {{42,91},{57,76}}, textString = "f"),Line(points = {{40,75},{70,75}}, color = {0,0,255}),Polygon(points = {{ -21,78},{ -31,75},{ -21,72},{ -21,78}}, lineColor = {0,0,255}, fillColor = {0,0,255}, fillPattern = FillPattern.Solid),Line(points = {{ -8,75},{ -31,75}}, color = {0,0,255}),Text(extent = {{ -21,90},{ -6,75}}, textString = "f"),Polygon(points = {{60,78},{70,75},{60,72},{60,78}}, lineColor = {0,0,255}, fillColor = {0,0,255}, fillPattern = FillPattern.Solid),Line(points = {{ -30,64},{70,64}}, color = {128,128,128}),Polygon(points = {{60,67},{70,64},{60,61},{60,67}}, lineColor = {128,128,128}, fillColor = {128,128,128}, fillPattern = FillPattern.Solid),Text(extent = {{0,63},{37,50}}, lineColor = {128,128,128}, textString = "s"),Rectangle(extent = {{100,40},{90,80}}, lineColor = {0,0,0}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid)}), Documentation(info = "<HTML>
<p>
Joint where frame_b is translated along axis n which is fixed in frame_a.
The two frames coincide when \"s + s_offset = 0\", where
\"s_offset\" is a parameter with a zero default
and \"s\" is the relative distance.
</p>
<p>
This variant of the prismatic joint is designed to work together
with a length constraint in a kinematic loop. This means that the
relative distance \"s\" of the joint is computed such that the
length constraint is fulfilled.
</p>
<p>
<b>Usually, this joint should not be used by a user of the MultiBody
library. It is only provided to built-up the Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXYZ
joints.</b>
</p>
</HTML>
"));
          protected 
            SI.Position r_a[3] = position_a "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of revolute joint";
            SI.Position r_b[3] = position_b "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of revolute joint";
            Modelica.SIunits.Position rbra[3] "= rb - ra";
            Real B "Coefficient B of equation: s*s + B*s + C = 0";
            Real C "Coefficient C of equation: s*s + B*s + C = 0";
            Real k1 "Constant of quadratic equation solution";
            Real k2 "Constant of quadratic equation solution";
            Real k1a(start = 1);
            Real k1b;
            Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape box(shapeType = "box", color = boxColor, specularCoefficient = specularCoefficient, length = if noEvent(abs(s + s_offset) > 1e-06) then s + s_offset else 1e-06, width = boxWidth, height = boxHeight, lengthDirection = e, widthDirection = boxWidthDirection, r = frame_a.r_0, R = frame_a.R) if world.enableAnimation and animation;
            function selectBranch "Determine branch which is closest to initial angle=0"
              import Modelica.Math.*;
              input SI.Length L "Length of length constraint";
              input Real e[3](each final unit = "1") "Unit vector along axis of translation, resolved in frame_a (= same in frame_b)";
              input SI.Position d_guess "Select the configuration such that at initial time |d-d_guess|is minimal (d: distance between origin of frame_a and origin of frame_b)";
              input SI.Position r_a[3] "Position vector from frame_a to frame_a side of length constraint, resolved in frame_a of prismatic joint";
              input SI.Position r_b[3] "Position vector from frame_b to frame_b side of length constraint, resolved in frame_b of prismatic joint";
              output Boolean positiveBranch "Branch of the initial solution";
            protected 
              Modelica.SIunits.Position rbra[3] "= rb - ra";
              Real B "Coefficient B of equation: d*d + B*d + C = 0";
              Real C "Coefficient C of equation: d*d + B*d + C = 0";
              Real k1 "Constant of quadratic equation solution";
              Real k2 "Constant of quadratic equation solution";
              Real d1 "solution 1 of quadratic equation";
              Real d2 "solution 2 of quadratic equation";
            algorithm 
              rbra:=r_b - r_a;
              B:=2 * e * rbra;
              C:=rbra * rbra - L * L;
              k1:=B / 2;
              k2:=sqrt(k1 * k1 - C);
              d1:= -k1 + k2;
              d2:= -k1 - k2;
              if abs(d1 - d_guess) <= abs(d2 - d_guess) then 
                            positiveBranch:=true;

              else               positiveBranch:=false;

              end if;
            end selectBranch;

          initial equation 
            positiveBranch = selectBranch(length, e, s_offset + s_guess, r_a, r_b);

          equation 
            Connections.branch(frame_a.R, frame_b.R);
            axis.f = f;
            axis.s = s;
            bearing.s = 0;
            distance = s_offset + s;
            r_rel_a = e * distance;
            frame_b.r_0 = frame_a.r_0 + Modelica.Mechanics.MultiBody.Frames.resolve1(frame_a.R, r_rel_a);
            frame_b.R = frame_a.R;
            zeros(3) = frame_a.f + frame_b.f;
            zeros(3) = frame_a.t + frame_b.t + cross(r_rel_a, frame_b.f);
if axisForceBalance then
                          f =  -e * frame_b.f;
            end if;
            rbra = r_b - r_a;
            B = 2 * e * rbra;
            C = rbra * rbra - length * length;
            k1 = B / 2;
            k1a = k1 * k1 - C;
            assert(noEvent(k1a > 1e-10), "
Singular position of loop (either no or two analytic solutions;
the mechanism has lost one-degree-of freedom in this position).
Try first to use another Modelica.Mechanics.MultiBody.Joints.Assemblies.JointXXX component.
If this also lead to singular positions, it could be that this
kinematic loop cannot be solved analytically with a fixed state
selection. In this case you have to build up the loop with
basic joints (NO aggregation JointXXX components) and rely on
dynamic state selection, i.e., during simulation the states will
be dynamically selected in such a way that in no position a
degree of freedom is lost.
");
            k1b = Modelica.Mechanics.MultiBody.Frames.Internal.maxWithoutEvent(k1a, 1e-12);
            k2 = sqrt(k1b);
            distance =  -k1 + (if positiveBranch then k2 else  -k2);
          end PrismaticWithLengthConstraint;
        end Internal;
      end Joints;
      package Sensors "Sensors to measure variables"
        model AbsoluteSensor "Obsolete model. Use instead Modelica.Mechanics.MultiBody.Sensors.AbsoluteSensor"
          import SI = Modelica.SIunits;
          import Modelica.Mechanics.MultiBody.Frames;
          import Modelica.Mechanics.MultiBody.Types;
          extends Modelica.Mechanics.MultiBody.Interfaces.PartialAbsoluteSensor(final n_out = 3 * ((if get_r_abs then 1 else 0) + (if get_v_abs then 1 else 0) + (if get_a_abs then 1 else 0) + (if get_angles then 1 else 0) + (if get_w_abs then 1 else 0) + (if get_z_abs then 1 else 0)));
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.Mechanics.MultiBody.Interfaces.Frame_resolve frame_resolve "If connected, the output signals are resolved in this frame" annotation(Placement(transformation(origin = {0,100}, extent = {{ -16, -16},{16,16}}, rotation = 270)));
          parameter Boolean animation = true "= true, if animation shall be enabled (show arrow)";
          parameter Boolean resolveInFrame_a = false "= true, if vectors are resolved in frame_a, otherwise in the world frame (if connector frame_resolve is connected, vectors are resolved in frame_resolve)";
          parameter Boolean get_r_abs = true "= true, to measure the position vector from the origin of the world frame to the origin of frame_a in [m]";
          parameter Boolean get_v_abs = false "= true, to measure the absolute velocity of the origin of frame_a in [m/s]";
          parameter Boolean get_a_abs = false "= true, to measure the absolute acceleration of the origin of frame_a in [m/s^2]";
          parameter Boolean get_angles = false "= true, to measure the 3 rotation angles to rotate the world frame into frame_a along the axes defined in 'sequence' below in [rad]";
          parameter Boolean get_w_abs = false "= true, to measure the absolute angular velocity of frame_a in [rad/s]";
          parameter Boolean get_z_abs = false "= true, to measure the absolute angular acceleration to frame_a in [rad/s^2]";
          parameter Types.RotationSequence sequence(min = {1,1,1}, max = {3,3,3}) = {1,2,3} " Angles are returned to rotate world frame around axes sequence[1], sequence[2] and finally sequence[3] into frame_a" annotation(Evaluate = true, Dialog(group = "if get_angles = true", enable = get_angles));
          parameter SI.Angle guessAngle1 = 0 " Select angles[1] such that abs(angles[1] - guessAngle1) is a minimum" annotation(Dialog(group = "if get_angles = true", enable = get_angles));
          input SI.Diameter arrowDiameter = world.defaultArrowDiameter " Diameter of arrow from world frame to frame_a" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
          input Types.Color arrowColor = Modelica.Mechanics.MultiBody.Types.Defaults.SensorColor " Color of arrow from world frame to frame_a" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
          input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient "Reflection of ambient light (= 0: light is completely absorbed)" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
          annotation(__Dymola_obsolete = "Based on a packed result signal which is not a good design. Use instead Modelica.Mechanics.MultiBody.Sensors.AbsoluteSensor", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Text(extent = {{19,109},{150,84}}, lineColor = {192,192,192}, textString = "resolve"),Line(points = {{ -84,0},{ -84,84},{0,84},{0,100}}, color = {95,95,95}, pattern = LinePattern.Dot),Text(extent = {{ -132,52},{ -96,27}}, lineColor = {128,128,128}, textString = "a")}), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Line(points = {{ -84,0},{ -84,82},{0,82},{0,98}}, color = {95,95,95}, pattern = LinePattern.Dot)}), Documentation(info = "<HTML>
<p>
Absolute kinematic quantities of frame_a are
computed and provided at the output signal connector <b>y</b>
in packed format in the order
</p>
<ol>
<li> absolute position vector (= r_abs)</li>
<li> absolute velocity vectory (= v_abs)</li>
<li> absolute acceleration vector (= a_abs)</li>
<li> 3 angles to rotate the world frame into frame_a (= angles)</li>
<li> absolute angular velocity vector (= w_abs)</li>
<li> absolute angular acceleration vector (= z_abs)</li>
</ol>
<p>
For example, if parameters <b>get_v</b> and <b>get_w</b>
are <b>true</b> and all other get_XXX parameters are <b>false</b>, then
y contains 6 elements:
</p>
<pre>
 y[1:3] = absolute velocity
 y[4:6] = absolute angular velocity
</pre>
<p>
In the following figure the animation of an AbsoluteSensor
component is shown. The light blue coordinate system is
frame_a and the yellow arrow is the animated sensor.
</p>
<p align=\"center\">
<IMG SRC=\"../Modelica/Images/MultiBody/Sensors/AbsoluteSensor.png\">
</p>
<p>
If <b>frame_resolve</b> is connected to another frame, then the
provided absolute kinematic vectors are resolved in this frame.
If <b>frame_resolve</b> is <b>not</b> connected then the
coordinate system in which the relative quantities are
resolved is defined by parameter <b>resolveInFrame_a</b>.
If this parameter is <b>true</b>, then the
provided kinematic vectors are resolved in frame_a of this
component. Otherwise, the kinematic vectors are resolved in
the world frame. For example, if frame_resolve is not
connected and if resolveInFrame_a = <b>false</b>, and
get_v = <b>true</b>, then
</p>
<pre>
  y = <b>der</b>(frame_a.r) // resolved in world frame
</pre>
<p>
is returned, i.e., the derivative of the distance frame_a.r_0
from the origin of the world frame to the origin of frame_a,
resolved in the world frame.
</p>
<p>
Note, the cut-force and the cut-torque in frame_resolve are
always zero, whether frame_resolve is connected or not.
</p>
<p>
If <b>get_angles</b> = <b>true</b>, the 3 angles to rotate the world
frame into frame_a along the axes defined by parameter <b>sequence</b>
are returned. For example, if sequence = {3,1,2} then the world frame is
rotated around angles[1] along the z-axis, afterwards it is rotated
around angles[2] along the x-axis, and finally it is rotated around
angles[3] along the y-axis and is then identical to frame_a.
The 3 angles are returned in the range
</p>
<pre>
    -<font face=\"Symbol\">p</font> &lt;= angles[i] &lt;= <font face=\"Symbol\">p</font>
</pre>
<p>
There are <b>two solutions</b> for \"angles[1]\" in this range.
Via parameter <b>guessAngle1</b> (default = 0) the
returned solution is selected such that |angles[1] - guessAngle1| is
minimal. The transformation matrix between the world frame and
frame_a may be in a singular configuration with respect to \"sequence\", i.e.,
there is an infinite number of angle values leading to the same
transformation matrix. In this case, the returned solution is
selected by setting angles[1] = guessAngle1. Then angles[2]
and angles[3] can be uniquely determined in the above range.
</p>
<p>
Note, that parameter <b>sequence</b> has the restriction that
only values 1,2,3 can be used and that sequence[1] &ne; sequence[2]
and sequence[2] &ne; sequence[3]. Often used values are:
</p>
<pre>
  sequence = <b>{1,2,3}</b>  // Cardan angle sequence
           = <b>{3,1,3}</b>  // Euler angle sequence
           = <b>{3,2,1}</b>  // Tait-Bryan angle sequence
</pre>
<p>
Exact definition of the returned quantities:
</p>
<ol>
<li>r_abs is vector frame_a.r_0, resolved according to table below.</li>
<li>v_abs is vector <b>der</b>(frame_a.r_0), resolved according to table below.</li>
<li>a_abs is vector <b>der</b>(<b>der</b>(frame_a.r_0)), resolved according to
            table below.</li>
<li>angles is a vector of 3 angles such that
    frame_a.R = Frames.axesRotations(sequence, angles).</li>
<li>w_abs is vector Modelica.Mechanics.MultiBody.Frames.angularVelocity1(frame_a.R, <b>der</b>(frame_a.R)),
            resolved according to table below.</li>
<li>z_abs is vector <b>der</b>(w_abs) (= derivative of absolute angular
            velocity of frame_a with respect to the world frame,
            resolved according to table below).</li>
</ol>
<table border=1 cellspacing=0 cellpadding=2>
  <tr><th><b><i>frame_resolve is</i></b></th>
      <th><b><i>resolveInFrame_a =</i></b></th>
      <th><b><i>vector is resolved in</i></b></th>
  </tr>
  <tr><td valign=\"top\">connected</td>
      <td valign=\"top\">true</td>
      <td valign=\"top\"><b>frame_resolve</b></td>
  </tr>
  <tr><td valign=\"top\">connected</td>
      <td valign=\"top\">false</td>
      <td valign=\"top\"><b>frame_resolve</b></td>
  </tr>
  <tr><td valign=\"top\">not connected</td>
      <td valign=\"top\">true</td>
      <td valign=\"top\"><b>frame_a</b></td>
  </tr>
  <tr><td valign=\"top\">not connected</td>
      <td valign=\"top\">false</td>
      <td valign=\"top\"><b>world frame</b></td>
  </tr>
</table><br>
</HTML>
"));
        protected 
          SI.Position r_abs[3] "Dummy or position vector from origin of the world frame to origin of frame_a (resolved in frame_resolve, frame_a or world frame)";
          SI.Velocity v_abs[3] "Dummy or velocity of origin of frame_a with respect to origin of world frame (resolved in frame_resolve, frame_a or world frame)";
          SI.Acceleration a_abs[3] "Dummy or acceleration of origin of frame_a with respect to origin of word frame (resolved in frame_resolve, frame_a or world frame)";
          SI.Angle angles[3] "Dummy or angles to rotate world frame into frame_a via 'sequence'";
          SI.AngularVelocity w_abs[3] "Dummy or angular velocity of frame_a with respect to world frame (resolved in frame_resolve, frame_a or world frame)";
          SI.AngularAcceleration z_abs[3] "Dummy or angular acceleration of frame_a with respect to world frame (resolved in frame_resolve, frame_a or world frame)";
          SI.Velocity v_abs_0[3] "Dummy or absolute velocity of origin of frame_a resolved in world frame";
          SI.AngularVelocity w_abs_0[3] "Dummy or absolute angular velocity of frame_a resolved in world frame";
          parameter Integer i1 = 1;
          parameter Integer i2 = if get_r_abs then i1 + 3 else i1;
          parameter Integer i3 = if get_v_abs then i2 + 3 else i2;
          parameter Integer i4 = if get_a_abs then i3 + 3 else i3;
          parameter Integer i5 = if get_angles then i4 + 3 else i4;
          parameter Integer i6 = if get_w_abs then i5 + 3 else i5;
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.Arrow arrow(r_head = frame_a.r_0, diameter = arrowDiameter, specularCoefficient = specularCoefficient, color = arrowColor) if world.enableAnimation and animation;

        equation 
          if get_angles then
            angles = Frames.axesRotationsAngles(frame_a.R, sequence, guessAngle1);

          else
            angles = zeros(3);

          end if;
          if cardinality(frame_resolve) == 1 then
            frame_resolve.f = zeros(3);
            frame_resolve.t = zeros(3);
            if get_r_abs then
              r_abs = Frames.resolve2(frame_resolve.R, frame_a.r_0);

            else
              r_abs = zeros(3);

            end if;
            if get_v_abs or get_a_abs then
              v_abs_0 = der(frame_a.r_0);
              v_abs = Frames.resolve2(frame_resolve.R, v_abs_0);

            else
              v_abs_0 = zeros(3);
              v_abs = zeros(3);

            end if;
            if get_a_abs then
              a_abs = Frames.resolve2(frame_resolve.R, der(v_abs_0));

            else
              a_abs = zeros(3);

            end if;
            if get_w_abs or get_z_abs then
              w_abs_0 = Modelica.Mechanics.MultiBody.Frames.angularVelocity1(frame_a.R);
              w_abs = Frames.resolve2(frame_resolve.R, w_abs_0);

            else
              w_abs_0 = zeros(3);
              w_abs = zeros(3);

            end if;
            if get_z_abs then
              z_abs = Frames.resolve2(frame_resolve.R, der(w_abs_0));

            else
              z_abs = zeros(3);

            end if;

          else
            frame_resolve.r_0 = zeros(3);
            frame_resolve.R = Frames.nullRotation();
            if get_r_abs then
              if resolveInFrame_a then
                r_abs = Modelica.Mechanics.MultiBody.Frames.resolve2(frame_a.R, frame_a.r_0);

              else
                r_abs = frame_a.r_0;

              end if;

            else
              r_abs = zeros(3);

            end if;
            if get_v_abs or get_a_abs then
              v_abs_0 = der(frame_a.r_0);
              if resolveInFrame_a then
                v_abs = Modelica.Mechanics.MultiBody.Frames.resolve2(frame_a.R, v_abs_0);

              else
                v_abs = v_abs_0;

              end if;

            else
              v_abs_0 = zeros(3);
              v_abs = zeros(3);

            end if;
            if get_a_abs then
              if resolveInFrame_a then
                a_abs = Modelica.Mechanics.MultiBody.Frames.resolve2(frame_a.R, der(v_abs_0));

              else
                a_abs = der(v_abs_0);

              end if;

            else
              a_abs = zeros(3);

            end if;
            w_abs_0 = zeros(3);
            if get_w_abs or get_z_abs then
              if resolveInFrame_a then
                w_abs = Modelica.Mechanics.MultiBody.Frames.angularVelocity2(frame_a.R);

              else
                w_abs = Modelica.Mechanics.MultiBody.Frames.angularVelocity1(frame_a.R);

              end if;

            else
              w_abs = zeros(3);

            end if;
            if get_z_abs then
              z_abs = der(w_abs);

            else
              z_abs = zeros(3);

            end if;

          end if;
          frame_a.f = zeros(3);
          frame_a.t = zeros(3);
if get_r_abs then
                      y[i1:i1 + 2] = r_abs;
          end if;
if get_v_abs then
                      y[i2:i2 + 2] = v_abs;
          end if;
if get_a_abs then
                      y[i3:i3 + 2] = a_abs;
          end if;
if get_angles then
                      y[i4:i4 + 2] = angles;
          end if;
if get_w_abs then
                      y[i5:i5 + 2] = w_abs;
          end if;
if get_z_abs then
                      y[i6:i6 + 2] = z_abs;
          end if;
        end AbsoluteSensor;
        model RelativeSensor "Obsolete model. Use instead Modelica.Mechanics.MultiBody.Sensors.RelativeSensor"
          import SI = Modelica.SIunits;
          import Modelica.Mechanics.MultiBody.Frames;
          import Modelica.Mechanics.MultiBody.Types;
          extends Modelica.Mechanics.MultiBody.Interfaces.PartialRelativeSensor(final n_out = 3 * ((if get_r_rel then 1 else 0) + (if get_v_rel then 1 else 0) + (if get_a_rel then 1 else 0) + (if get_angles then 1 else 0) + (if get_w_rel then 1 else 0) + (if get_z_rel then 1 else 0)));
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.Mechanics.MultiBody.Interfaces.Frame_resolve frame_resolve "If connected, the output signals are resolved in this frame" annotation(Placement(transformation(origin = { -60, -100}, extent = {{ -16, -16},{16,16}}, rotation = 270)));
          parameter Boolean animation = true "= true, if animation shall be enabled (show arrow)";
          parameter Boolean resolveInFrame_a = true "= true, if relative vectors from frame_a to frame_b are resolved before differentiation in frame_a, otherwise in frame_b. If frame_resolve is connected, the vector and its derivatives are resolved in frame_resolve";
          parameter Boolean get_r_rel = true "= true, to measure the relative position vector from the origin of frame_a to the origin of frame_b in [m]";
          parameter Boolean get_v_rel = false "= true, to measure the relative velocity of the origin of frame_b with respect to frame_a in [m/s]";
          parameter Boolean get_a_rel = false "= true, to measure the relative acceleration of the origin of frame_b with respect to frame_a in [m/s^2]";
          parameter Boolean get_angles = false "= true, to measure the 3 rotation angles to rotate frame_a into frame_b along the axes defined in 'sequence' below in [rad]";
          parameter Boolean get_w_rel = false "= true, to measure the relative angular velocity of frame_b with respect to frame_a in [rad/s]";
          parameter Boolean get_z_rel = false "= true, to measure the relative angular acceleration of frame_b with respect to frame_a in [rad/s^2]";
          parameter Types.RotationSequence sequence(min = {1,1,1}, max = {3,3,3}) = {1,2,3} " Angles are returned to rotate frame_a around axes sequence[1], sequence[2] and finally sequence[3] into frame_b" annotation(Evaluate = true, Dialog(group = "if get_angles = true", enable = get_angles));
          parameter SI.Angle guessAngle1 = 0 " Select angles[1] such that abs(angles[1] - guessAngle1) is a minimum" annotation(Dialog(group = "if get_angles = true", enable = get_angles));
          input SI.Diameter arrowDiameter = world.defaultArrowDiameter " Diameter of relative arrow from frame_a to frame_b" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
          input Types.Color arrowColor = Modelica.Mechanics.MultiBody.Types.Defaults.SensorColor " Color of relative arrow from frame_a to frame_b" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
          input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient "Reflection of ambient light (= 0: light is completely absorbed)" annotation(Dialog(tab = "Animation", group = "if animation = true", enable = animation));
          SI.Position r_rel[3] "Dummy or relative position vector (resolved in frame_a, frame_b or frame_resolve)";
          SI.Velocity v_rel[3] "Dummy or relative velocity vector (resolved in frame_a, frame_b or frame_resolve";
          SI.Acceleration a_rel[3] "Dummy or relative acceleration vector (resolved in frame_a, frame_b or frame_resolve";
          SI.Angle angles[3] "Dummy or angles to rotate frame_a into frame_b via 'sequence'";
          SI.AngularVelocity w_rel[3] "Dummy or relative angular velocity vector (resolved in frame_a, frame_b or frame_resolve";
          SI.AngularAcceleration z_rel[3] "Dummy or relative angular acceleration vector (resolved in frame_a, frame_b or frame_resolve";
          Frames.Orientation R_rel "Dummy or relative orientation object from frame_a to frame_b";
        protected 
          SI.Position r_rel_ab[3] "Dummy or relative position vector resolved in frame_a or frame_b";
          SI.Velocity der_r_rel_ab[3] "Dummy or derivative of relative position vector (resolved in frame_a, frame_b or frame_resolve)";
          SI.AngularVelocity w_rel_ab[3] "Dummy or angular velocity of frame_b with respect to frame_a (resolved in frame_a or frame_b)";
          Frames.Orientation R_resolve "Dummy or relative orientation of frame_a or frame_b with respect to frame_resolve";
          parameter Integer i1 = 1;
          parameter Integer i2 = if get_r_rel then i1 + 3 else i1;
          parameter Integer i3 = if get_v_rel then i2 + 3 else i2;
          parameter Integer i4 = if get_a_rel then i3 + 3 else i3;
          parameter Integer i5 = if get_angles then i4 + 3 else i4;
          parameter Integer i6 = if get_w_rel then i5 + 3 else i5;
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.Arrow arrow(r = frame_a.r_0, r_head = frame_b.r_0 - frame_a.r_0, diameter = arrowDiameter, color = arrowColor, specularCoefficient) if world.enableAnimation and animation;
          annotation(__Dymola_obsolete = "Based on a packed result signal which is not a good design. Use instead Modelica.Mechanics.MultiBody.Sensors.RelativeSensor", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Line(points = {{ -60, -94},{ -60, -76},{0, -76},{0, -76}}, color = {95,95,95}, pattern = LinePattern.Dot),Text(extent = {{ -157, -49},{ -26, -74}}, lineColor = {192,192,192}, pattern = LinePattern.Dot, textString = "resolve")}), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Line(points = {{ -60, -98},{ -60, -76},{0, -76},{0, -76}}, color = {95,95,95}, pattern = LinePattern.Dot)}), Documentation(info = "<HTML>
<p>
Relative kinematic quantities between frame_a and frame_b are
determined and provided at the output signal connector <b>y</b>
in packed format in the order
</p>
<ol>
<li> relative position vector (= r_rel)</li>
<li> relative velocity vectory (= v_rel)</li>
<li> relative acceleration vector (= a_rel))</li>
<li> 3 angles to rotate frame_a into frame_b (= angles)</li>
<li> relative angular velocity vector (= w_rel)</li>
<li> relative angular acceleration vector (= z_rel)</li>
</ol>
<p>
For example, if parameters <b>get_v_rel</b> and <b>get_w_rel</b>
are <b>true</b> and all other get_XXX parameters are <b>false</b>, then
y contains 6 elements:
</p>
<pre>
 y = relative velocity
 y = relative angular velocity
</pre>
<p>
In the following figure the animation of a RelativeSensor
component is shown. The light blue coordinate system is
frame_a, the dark blue coordinate system is frame_b, and
the yellow arrow is the animated sensor.
</p>
<p align=\"center\">
<IMG SRC=\"../Modelica/Images/MultiBody/Sensors/RelativeSensor.png\">
</p>
<p>
If parameter <b>resolveInFrame_a</b> = <b>true</b>, then the
provided relative kinematic vectors of frame_b with respect to
frame_a are resolved before differentiation in frame_a. If this
parameter is <b>false</b>, the relative kinematic vectors are
resolved before differentiation in frame_b.
If <b>frame_resolve</b> is connected to another frame, then the
kinematic vector as defined above and/or its required derivatives
are resolved in frame_resolve. Note, derivatives
of relative kinematic quantities are always performed with
respect to frame_a (<b>resolveInFrame_a</b> = <b>true</b>)
or with respect to frame_b (<b>resolveInFrame_a</b> = <b>false</b>).
The resulting vector is then resolved in frame_resolve, if this
connector is connected.
</p>
<p>
For example, if frame_resolve is not
connected and if resolveInFrame_a = <b>false</b>, and
get_v = <b>true</b>, then
</p>
<pre>
  y = v_rel
    = <b>der</b>(r_rel)
</pre>
is returned (r_rel = resolve2(frame_b.R, frame_b.r_0 - frame_a.r0)), i.e.,
the derivative of the relative distance from frame_a to frame_b,
resolved in frame_b. If frame_resolve is connected, then
</p>
<pre>
  y = v_rel
    = resolve2(frame_resolve.R, <b>der</b>(r_rel))
</pre>
<p>
is returned, i.e., the previous relative velocity vector is
additionally resolved in frame_resolve.
</p>
<p>
Note, the cut-force and the cut-torque in frame_resolve are
always zero, whether frame_resolve is connected or not.
</p>
<p>
If <b>get_angles</b> = <b>true</b>, the 3 angles to rotate frame_a
into frame_b along the axes defined by parameter <b>sequence</b>
are returned. For example, if sequence = {3,1,2} then frame_a is
rotated around angles[1] along the z-axis, afterwards it is rotated
around angles[2] along the x-axis, and finally it is rotated around
angles[3] along the y-axis and is then identical to frame_b.
The 3 angles are returned in the range
</p>
<pre>
    -<font face=\"Symbol\">p</font> &lt;= angles[i] &lt;= <font face=\"Symbol\">p</font>
</pre>
<p>
There are <b>two solutions</b> for \"angles[1]\" in this range.
Via parameter <b>guessAngle1</b> (default = 0) the
returned solution is selected such that |angles[1] - guessAngle1| is
minimal. The relative transformation matrix between frame_a and
frame_b may be in a singular configuration with respect to \"sequence\", i.e.,
there is an infinite number of angle values leading to the same relative
transformation matrix. In this case, the returned solution is
selected by setting angles[1] = guessAngle1. Then angles[2]
and angles[3] can be uniquely determined in the above range.
</p>
<p>
Note, that parameter <b>sequence</b> has the restriction that
only values 1,2,3 can be used and that sequence[1] &ne; sequence[2]
and sequence[2] &ne; sequence[3]. Often used values are:
</p>
<pre>
  sequence = <b>{1,2,3}</b>  // Cardan angle sequence
           = <b>{3,1,3}</b>  // Euler angle sequence
           = <b>{3,2,1}</b>  // Tait-Bryan angle sequence
</pre>
<p>
Exact definition of the returned quantities
(r_rel_ab, R_rel_ab, w_rel_ab are defined below the enumeration):
</p>
<ol>
<li>r_rel is vector r_rel_ab, resolved according to table below.</li>
<li>v_rel is vector <b>der</b>(r_rel_ab), resolved according to table below.</li>
<li>a_rel is vector <b>der</b>(<b>der</b>(r_rel_ab)), resolved according to
            table below.</li>
<li>angles is a vector of 3 angles such that
    R_rel_ab = Frames.axesRotations(sequence, angles).</li>
<li>w_rel is vector w_rel_ab, resolved according to table below.</li>
<li>z_rel is vector <b>der</b>(w_rel_ab), resolved according to table below.</li>
</ol>
<p>
using the auxiliary quantities
</p>
<ol>
<li> r_rel_ab is vector frame_b.r_0 - frame_a.r_0, resolved either in frame_a or
     frame_b according to parameter resolveInFrame_a.</li>
<li> R_rel_ab is orientation object Frames.relativeRotation(frame_a.R, frame_b.R).</li>
<li> w_rel_ab is vector Frames.angularVelocity1(R_rel_ab, der(R_rel_ab)), resolved either
     in frame_a or frame_b according to parameter resolveInFrame_a.</li>
</ol>
<p>
and resolved in the following frame
</p>
<table border=1 cellspacing=0 cellpadding=2>
  <tr><th><b><i>frame_resolve is</i></b></th>
      <th><b><i>resolveInFrame_a =</i></b></th>
      <th><b><i>vector is resolved in</i></b></th>
  </tr>
  <tr><td valign=\"top\">connected</td>
      <td valign=\"top\">true</td>
      <td valign=\"top\"><b>frame_resolve</b></td>
  </tr>
  <tr><td valign=\"top\">connected</td>
      <td valign=\"top\">false</td>
      <td valign=\"top\"><b>frame_resolve</b></td>
  </tr>
  <tr><td valign=\"top\">not connected</td>
      <td valign=\"top\">true</td>
      <td valign=\"top\"><b>frame_a</b></td>
  </tr>
  <tr><td valign=\"top\">not connected</td>
      <td valign=\"top\">false</td>
      <td valign=\"top\"><b>frame_b</b></td>
  </tr>
</table><br>
</HTML>"));

        equation 
          if get_angles or get_w_rel or get_z_rel then
            R_rel = Modelica.Mechanics.MultiBody.Frames.relativeRotation(frame_a.R, frame_b.R);

          else
            R_rel = Modelica.Mechanics.MultiBody.Frames.nullRotation();

          end if;
          if get_angles then
            angles = Frames.axesRotationsAngles(R_rel, sequence, guessAngle1);

          else
            angles = zeros(3);

          end if;
          if cardinality(frame_resolve) == 1 then
            frame_resolve.f = zeros(3);
            frame_resolve.t = zeros(3);
            if resolveInFrame_a then
              R_resolve = Frames.relativeRotation(frame_a.R, frame_resolve.R);

            else
              R_resolve = Frames.relativeRotation(frame_b.R, frame_resolve.R);

            end if;
            if get_r_rel or get_v_rel or get_a_rel then
              if resolveInFrame_a then
                r_rel_ab = Frames.resolve2(frame_a.R, frame_b.r_0 - frame_a.r_0);

              else
                r_rel_ab = Frames.resolve2(frame_b.R, frame_b.r_0 - frame_a.r_0);

              end if;
              r_rel = Frames.resolve2(R_resolve, r_rel_ab);

            else
              r_rel_ab = zeros(3);
              r_rel = zeros(3);

            end if;
            if get_v_rel or get_a_rel then
              der_r_rel_ab = der(r_rel_ab);

            else
              der_r_rel_ab = zeros(3);

            end if;
            if get_v_rel then
              v_rel = Frames.resolve2(R_resolve, der_r_rel_ab);

            else
              v_rel = zeros(3);

            end if;
            if get_a_rel then
              a_rel = Frames.resolve2(R_resolve, der(der_r_rel_ab));

            else
              a_rel = zeros(3);

            end if;
            if get_w_rel or get_z_rel then
              if resolveInFrame_a then
                w_rel_ab = Modelica.Mechanics.MultiBody.Frames.angularVelocity1(R_rel);

              else
                w_rel_ab = Modelica.Mechanics.MultiBody.Frames.angularVelocity2(R_rel);

              end if;
              w_rel = Frames.resolve2(R_resolve, w_rel_ab);

            else
              w_rel = zeros(3);
              w_rel_ab = zeros(3);

            end if;
            if get_z_rel then
              z_rel = Frames.resolve2(R_resolve, der(w_rel_ab));

            else
              z_rel = zeros(3);

            end if;

          else
            frame_resolve.r_0 = zeros(3);
            frame_resolve.R = Frames.nullRotation();
            R_resolve = Frames.nullRotation();
            r_rel_ab = zeros(3);
            der_r_rel_ab = zeros(3);
            w_rel_ab = zeros(3);
            if get_r_rel or get_v_rel or get_a_rel then
              if resolveInFrame_a then
                r_rel = Frames.resolve2(frame_a.R, frame_b.r_0 - frame_a.r_0);

              else
                r_rel = Frames.resolve2(frame_b.R, frame_b.r_0 - frame_a.r_0);

              end if;

            else
              r_rel = zeros(3);

            end if;
            if get_v_rel or get_a_rel then
              v_rel = der(r_rel);

            else
              v_rel = zeros(3);

            end if;
            if get_a_rel then
              a_rel = der(v_rel);

            else
              a_rel = zeros(3);

            end if;
            if get_w_rel or get_z_rel then
              if resolveInFrame_a then
                w_rel = Frames.angularVelocity1(R_rel);

              else
                w_rel = Frames.angularVelocity2(R_rel);

              end if;

            else
              w_rel = zeros(3);

            end if;
            if get_z_rel then
              z_rel = der(w_rel);

            else
              z_rel = zeros(3);

            end if;

          end if;
          frame_a.f = zeros(3);
          frame_a.t = zeros(3);
          frame_b.f = zeros(3);
          frame_b.t = zeros(3);
if get_r_rel then
                      y[i1:i1 + 2] = r_rel;
          end if;
if get_v_rel then
                      y[i2:i2 + 2] = v_rel;
          end if;
if get_a_rel then
                      y[i3:i3 + 2] = a_rel;
          end if;
if get_angles then
                      y[i4:i4 + 2] = angles;
          end if;
if get_w_rel then
                      y[i5:i5 + 2] = w_rel;
          end if;
if get_z_rel then
                      y[i6:i6 + 2] = z_rel;
          end if;
        end RelativeSensor;
        model CutForceAndTorque "Obsolete model. Use instead Modelica.Mechanics.MultiBody.Sensors.CutForceAndTorque"
          import SI = Modelica.SIunits;
          import Modelica.Mechanics.MultiBody.Types;
          extends ObsoleteModelica3.Mechanics.MultiBody.Interfaces.PartialCutForceSensor;
          Modelica.Blocks.Interfaces.RealOutput load[6] "Cut force and cut torque resolved in frame_a/frame_b or in frame_resolved, if connected" annotation(Placement(transformation(origin = { -80, -110}, extent = {{10, -10},{ -10,10}}, rotation = 90)));
          parameter Boolean animation = true "= true, if animation shall be enabled (show force and torque arrow)";
          parameter Boolean positiveSign = true "= true, if force and torque with positive sign is returned (= frame_a.f/.t), otherwise with negative sign (= frame_b.f/.t)";
          parameter Boolean resolveInFrame_a = true "= true, if force and torque are resolved in frame_a/frame_b, otherwise in the world frame (if connector frame_resolve is connected, the force/torque is resolved in frame_resolve)";
          input Real N_to_m(unit = "N/m") = 1000 " Force arrow scaling (length = force/N_to_m)" annotation(Dialog(group = "if animation = true", enable = animation));
          input Real Nm_to_m(unit = "N.m/m") = 1000 " Torque arrow scaling (length = torque/Nm_to_m)" annotation(Dialog(group = "if animation = true", enable = animation));
          input SI.Diameter forceDiameter = world.defaultArrowDiameter " Diameter of force arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input SI.Diameter torqueDiameter = forceDiameter " Diameter of torque arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.Color forceColor = Modelica.Mechanics.MultiBody.Types.Defaults.ForceColor " Color of force arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.Color torqueColor = Modelica.Mechanics.MultiBody.Types.Defaults.TorqueColor " Color of torque arrow" annotation(Dialog(group = "if animation = true", enable = animation));
          input Types.SpecularCoefficient specularCoefficient = world.defaultSpecularCoefficient "Reflection of ambient light (= 0: light is completely absorbed)" annotation(Dialog(group = "if animation = true", enable = animation));
          SI.Force force[3] "Cut force resolved in frame_a/frame_b or in frame_resolved, if connected";
          SI.Torque torque[3] "Cut torque resolved in frame_a/frame_b or in frame_resolved, if connected";
          annotation(__Dymola_obsolete = "Based on a packed result signal which is not a good design. Use instead Modelica.Mechanics.MultiBody.Sensors.CutForceAndTorque", preferedView = "info", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), Documentation(info = "<HTML>
<p>
The cut-force and cut-torque acting at the component to which frame_b is
connected are determined and provided at the output signal connector
<b>load</b>:
</p>
<pre>
  load[1:3] = frame_a.f;
  load[4:6] = frame_a.t;
</pre>
<p>
If parameter <b>positiveSign</b> =
<b>false</b>, the negative cut-force and negative
cut-torque is provided (= frame_b.f and frame_b.t).
If <b>frame_resolve</b> is connected to another frame, then the
cut-force and cut-torque are resolved in frame_resolve.
If <b>frame_resolve</b> is <b>not</b> connected then the
coordinate system in which the cut-force and cut-torque is resolved
is defined by parameter <b>resolveInFrame_a</b>.
If this parameter is <b>true</b>, then the
cut-force and cut-torque is resolved in frame_a, otherwise it is
resolved in the world frame.
</p>
<p>
In the following figure the animation of a CutForceAndTorque
sensor is shown. The dark blue coordinate system is frame_b,
and the green arrows are the cut force and the cut torque,
respectively, acting at frame_b and
with negative sign at frame_a.
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Sensors/CutForceAndTorque.png\">
</p>
</HTML>"));
        protected 
          outer Modelica.Mechanics.MultiBody.World world;
          parameter Integer csign = if positiveSign then  +1 else  -1;
          SI.Position f_in_m[3] = (frame_a.f * csign) / N_to_m "Force mapped from N to m for animation";
          SI.Position t_in_m[3] = (frame_a.t * csign) / Nm_to_m "Torque mapped from Nm to m for animation";
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.Arrow forceArrow(diameter = forceDiameter, color = forceColor, specularCoefficient = specularCoefficient, R = frame_b.R, r = frame_b.r_0, r_tail = f_in_m, r_head =  -f_in_m) if world.enableAnimation and animation;
          Modelica.Mechanics.MultiBody.Visualizers.Advanced.DoubleArrow torqueArrow(diameter = torqueDiameter, color = torqueColor, specularCoefficient = specularCoefficient, R = frame_b.R, r = frame_b.r_0, r_tail = t_in_m, r_head =  -t_in_m) if world.enableAnimation and animation;

        equation 
          if cardinality(frame_resolve) == 1 then
            force = Modelica.Mechanics.MultiBody.Frames.resolve2(frame_resolve.R, Modelica.Mechanics.MultiBody.Frames.resolve1(frame_a.R, frame_a.f)) * csign;
            torque = Modelica.Mechanics.MultiBody.Frames.resolve2(frame_resolve.R, Modelica.Mechanics.MultiBody.Frames.resolve1(frame_a.R, frame_a.t)) * csign;

          elseif resolveInFrame_a then
            force = frame_a.f * csign;
            torque = frame_a.t * csign;


          else
            force = Modelica.Mechanics.MultiBody.Frames.resolve1(frame_a.R, frame_a.f) * csign;
            torque = Modelica.Mechanics.MultiBody.Frames.resolve1(frame_a.R, frame_a.t) * csign;

          end if;
          load[1:3] = force;
          load[4:6] = torque;
        end CutForceAndTorque;
      end Sensors;
      package Types "Constants and types with choices, especially to build menus"
        type AngularVelocity_degs = Modelica.Icons.TypeReal(final quantity = "AngularVelocity", final unit = "deg/s") "Obsolete type. Use Modelica.SIunits.AngularVelocity instead with an appropriate displayUnit" annotation(__Dymola_obsolete = "Non SI-units should no longer be used. Use Modelica.SIunits.AngularVelocity instead with an appropriate displayUnit");
        type AngularAcceleration_degs2 = Modelica.Icons.TypeReal(final quantity = "AngularAcceleration", final unit = "deg/s2") "Obsolete type. Use Modelica.SIunits.AngularAcceleration instead with an appropriate displayUnit" annotation(__Dymola_obsolete = "Non SI-units should no longer be used. Use Modelica.SIunits.AngularAcceleration instead with an appropriate displayUnit");
        package Init "Obsolete type. This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu"
          annotation(__Dymola_obsolete = "This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu", Documentation(info = "<html>

</html>"));
          extends ObsoleteModelica3.Icons.Enumeration;
          constant Integer Free = 1;
          constant Integer PositionVelocity = 2;
          constant Integer SteadyState = 3;
          constant Integer Position = 4;
          constant Integer Velocity = 5;
          constant Integer VelocityAcceleration = 6;
          constant Integer PositionVelocityAcceleration = 7;
          type Temp "Obsolete type. This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu"
            extends Modelica.Icons.TypeInteger;
            annotation(__Dymola_obsolete = "This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu", choices(choice = Modelica.Mechanics.MultiBody.Types.Init.Free "free (no initialization)", choice = Modelica.Mechanics.MultiBody.Types.Init.PositionVelocity "initialize generalized position and velocity variables", choice = Modelica.Mechanics.MultiBody.Types.Init.SteadyState "initialize in steady state (velocity and acceleration are zero)", choice = Modelica.Mechanics.MultiBody.Types.Init.Position "initialize only generalized position variable(s)", choice = Modelica.Mechanics.MultiBody.Types.Init.Velocity "initialize only generalized velocity variable(s)", choice = Modelica.Mechanics.MultiBody.Types.Init.VelocityAcceleration "initialize generalized velocity and acceleration variables", choice = Modelica.Mechanics.MultiBody.Types.Init.PositionVelocityAcceleration "initialize generalized position, velocity and acceleration variables"), Documentation(info = "<html>

<table border=1 cellspacing=0 cellpadding=2>
<tr><th><b>Types.Init.</b></th><th><b>Meaning</b></th></tr>
<tr><td valign=\"top\">Free</td>
    <td valign=\"top\">No initialization</td></tr>

<tr><td valign=\"top\">PositionVelocity</td>
    <td valign=\"top\">Initialize generalized position and velocity variables</td></tr>

<tr><td valign=\"top\">SteadyState</td>
    <td valign=\"top\">Initialize in steady state (velocity and acceleration are zero)</td></tr>

<tr><td valign=\"top\">Position </td>
    <td valign=\"top\">Initialize only generalized position variable(s)</td></tr>

<tr><td valign=\"top\">Velocity</td>
    <td valign=\"top\">Initialize only generalized velocity variable(s)</td></tr>

<tr><td valign=\"top\">VelocityAcceleration</td>
    <td valign=\"top\">Initialize generalized velocity and acceleration variables</td></tr>

<tr><td valign=\"top\">PositionVelocityAcceleration</td>
    <td valign=\"top\">Initialize generalized position, velocity and acceleration variables</td></tr>

</table>

</html>"));
          end Temp;
        end Init;
      end Types;
    end MultiBody;
    package Rotational "Library to model 1-dimensional, rotational mechanical systems"
      package Interfaces "Connectors and partial models for 1D rotational mechanical components"
        partial model Rigid "Base class for the rigid connection of two rotational 1D flanges"
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.SIunits.Angle phi "Absolute rotation angle of component (= flange_a.phi = flange_b.phi)";
          Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(extent = {{ -110, -10},{ -90,10}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Interfaces.Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(extent = {{90, -10},{110,10}}, rotation = 0)));
          annotation(Documentation(info = "<html>
<p>
This is a 1D rotational component with two rigidly connected flanges,
i.e., flange_a.phi = flange_b.phi. It is used e.g. to built up components
with inertia.
</p>

</HTML>
"), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {2,2}), graphics), Window(x = 0.18, y = 0.3, width = 0.61, height = 0.66));

        equation 
          flange_a.phi = phi;
          flange_b.phi = phi;
        end Rigid;
        partial model Bearing "Obsolete model. Use one of Modelica.Mechanics.Rotational.Interfaces.PartialXXX instead"
          extends Modelica.Mechanics.Rotational.Interfaces.PartialTwoFlanges;
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.SIunits.Torque tau_support;
          Modelica.Mechanics.Rotational.Interfaces.Flange_a bearing "Flange of bearing" annotation(Placement(transformation(extent = {{ -10, -110},{10, -90}}, rotation = 0)));
          annotation(__Dymola_obsolete = "The Rotational library has now a new improved design with optional support connectors. Use Modelica.Mechanics.Rotational.Interfaces.PartialXXX instead.", Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -20, -80},{20, -120}}, lineColor = {192,192,192}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid)}), Icon(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -20, -80},{20, -120}}, lineColor = {192,192,192}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid)}), Documentation(info = "<html>
<p>
This is a 1D rotational component with two flanges and an additional bearing flange.
It is a superclass for the two components TwoFlangesAndBearing and TwoFlangesAndBearingH.</p>

</HTML>
"));
        end Bearing;
        partial model TwoFlangesAndBearing "Obsolete model. Use one of Modelica.Mechanics.Rotational.Interfaces.PartialXXX instead"
          extends ObsoleteModelica3.Mechanics.Rotational.Interfaces.Bearing;
          Modelica.SIunits.Angle phi_a;
          Modelica.SIunits.Angle phi_b;
          annotation(__Dymola_obsolete = "The Rotational library has now a new improved design with optional support connectors. Use Modelica.Mechanics.Rotational.Interfaces.PartialXXX instead.", Documentation(info = "<html>
<p>
This is a 1D rotational component with two flanges and an additional bearing flange.
It is used e.g. to build up equation-based parts of a drive train.</p>

</HTML>
"));

        equation 
          if cardinality(bearing) == 0 then
            bearing.phi = 0;

          else
            bearing.tau = tau_support;

          end if;
          0 = flange_a.tau + flange_b.tau + tau_support;
          phi_a = flange_a.phi - bearing.phi;
          phi_b = flange_b.phi - bearing.phi;
        end TwoFlangesAndBearing;
        partial model TwoFlangesAndBearingH "Obsolete model. Use one of Modelica.Mechanics.Rotational.Interfaces.PartialXXX instead"
          extends ObsoleteModelica3.Mechanics.Rotational.Interfaces.Bearing;
          Adapter adapter(bearingConnected = cardinality(bearing) > 1) annotation(Placement(transformation(origin = {0, -60}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        protected 
          encapsulated model Adapter
            import Modelica;
            import ObsoleteModelica3;
            import TwoFlanges = Modelica.Mechanics.Rotational.Interfaces.PartialTwoFlanges;
            extends Modelica.Mechanics.Rotational.Interfaces.PartialTwoFlanges;
            extends ObsoleteModelica3.Icons.ObsoleteModel;
            parameter Boolean bearingConnected;
            annotation(Icon(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -90,10},{90, -10}}, lineColor = {192,192,192}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Text(extent = {{ -150,60},{150,20}}, textString = "%name", lineColor = {0,0,255})}));

          equation 
            flange_a.phi = flange_b.phi;
            if bearingConnected then
              0 = flange_a.tau + flange_b.tau;

            else
              0 = flange_a.phi;

            end if;
          end Adapter;

        equation 
          tau_support =  -adapter.flange_b.tau;
          connect(adapter.flange_a,bearing) annotation(Line(points = {{ -6.12323e-16, -70},{0, -70},{0, -100}}, color = {0,0,0}));
          annotation(__Dymola_obsolete = "The Rotational library has now a new improved design with optional support connectors. Use Modelica.Mechanics.Rotational.Interfaces.PartialXXX instead.", Documentation(info = "<html>
<p>
This is a 1D rotational component with two flanges and an additional bearing flange.
It is used e.g. to build up parts of a drive train consisting
of several base components.</p>

</HTML>
"));
        end TwoFlangesAndBearingH;
        partial model PartialSpeedDependentTorque "Partial model of a torque acting at the flange (accelerates the flange)"
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.SIunits.AngularVelocity w = der(flange.phi) "Angular velocity at flange";
          Modelica.SIunits.Torque tau = flange.tau "accelerating torque acting at flange";
          Modelica.Mechanics.Rotational.Interfaces.Flange_b flange "Flange on which torque is acting" annotation(Placement(transformation(extent = {{110, -10},{90,10}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Interfaces.Flange_a bearing "Bearing at which the reaction torque (i.e., -flange.tau) is acting" annotation(Placement(transformation(extent = {{ -10, -130},{10, -110}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -96,96},{96, -96}}, lineColor = {255,255,255}, fillColor = {255,255,255}, fillPattern = FillPattern.Solid),Line(points = {{ -30, -70},{30, -70}}, color = {0,0,0}),Line(points = {{ -30, -90},{ -10, -70}}, color = {0,0,0}),Line(points = {{ -10, -90},{10, -70}}, color = {0,0,0}),Rectangle(extent = {{ -20, -100},{20, -140}}, lineColor = {192,192,192}, fillColor = {192,192,192}, fillPattern = FillPattern.Solid),Line(points = {{10, -90},{30, -70}}, color = {0,0,0}),Line(points = {{0, -70},{0, -110}}, color = {0,0,0}),Line(points = {{ -92,0},{ -76,36},{ -54,62},{ -30,80},{ -14,88},{10,92},{26,90},{46,80},{64,62}}, color = {0,0,0}),Text(extent = {{ -150,140},{150,100}}, lineColor = {0,0,255}, textString = "%name"),Polygon(points = {{94,16},{80,74},{50,52},{94,16}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid)}), Documentation(info = "<HTML>
<p>
Partial model of torque dependent on speed that accelerates the flange.
</p>
</HTML>"));

        equation 
          if cardinality(bearing) == 0 then
            bearing.phi = 0;

          else
            bearing.tau =  -flange.tau;

          end if;
        end PartialSpeedDependentTorque;
        partial model AbsoluteSensor "Obsolete model. Use Modelica.Mechanics.Rotational.Interfaces.PartialAbsoluteSensor instead and define a meaningful name for the output signal"
          extends Modelica.Icons.RotationalSensor;
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a "(left) flange to be measured (flange axis directed INTO cut plane)" annotation(Placement(transformation(extent = {{ -110, -10},{ -90,10}}, rotation = 0)));
          Modelica.Blocks.Interfaces.RealOutput y "Sensor signal" annotation(Placement(transformation(extent = {{100, -10},{120,10}}, rotation = 0)));
          annotation(Window(x = 0.39, y = 0.05, width = 0.6, height = 0.6), __Dymola_obsolete = "Use Modelica.Mechanics.Rotational.Interfaces.PartialAbsoluteSensor instead and define a meaningful name for the output signal.", Documentation(info = "<html>
<p>
This is the base class of a 1D rotational component with one flange and one
output signal y in order to measure an absolute kinematic quantity in the flange
and to provide the measured signal as output signal for further processing
with the blocks of package Modelica.Blocks.
</p>

</HTML>
"), Icon(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Line(points = {{ -70,0},{ -90,0}}, color = {0,0,0}),Line(points = {{70,0},{100,0}}, color = {0,0,127}),Text(extent = {{150,80},{ -150,120}}, textString = "%name", lineColor = {0,0,255})}), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Line(points = {{ -70,0},{ -90,0}}, color = {0,0,0}),Line(points = {{70,0},{100,0}}, color = {0,0,255})}));
        end AbsoluteSensor;
        partial model RelativeSensor "Obsolete model. Use Modelica.Mechanics.Rotational.Interfaces.PartialRelativbeSensor instead and define a meaningful name for the output signal"
          extends Modelica.Icons.RotationalSensor;
          extends ObsoleteModelica3.Icons.ObsoleteModel;
          Modelica.Mechanics.Rotational.Interfaces.Flange_a flange_a "(left) driving flange (flange axis directed INTO cut plane)" annotation(Placement(transformation(extent = {{ -110, -10},{ -90,10}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Interfaces.Flange_b flange_b "(right) driven flange (flange axis directed OUT OF cut plane)" annotation(Placement(transformation(extent = {{90, -10},{110,10}}, rotation = 0)));
          Modelica.Blocks.Interfaces.RealOutput y "Sensor signal" annotation(Placement(transformation(origin = {0, -110}, extent = {{10, -10},{ -10,10}}, rotation = 90)));
          annotation(Window(x = 0.37, y = 0.02, width = 0.6, height = 0.65), __Dymola_obsolete = "Use Modelica.Mechanics.Rotational.Interfaces.PartialRelativeSensor instead and define a meaningful name for the output signal.", Documentation(info = "<html>
<p>
This is a base class for 1D rotational components with two rigidly connected
flanges and one output signal y in order to measure relative kinematic quantities
between the two flanges or the cut-torque in the flange and
to provide the measured signal as output signal for further processing
with the blocks of package Modelica.Blocks.
</p>

</HTML>
"), Icon(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Line(points = {{ -70,0},{ -90,0}}, color = {0,0,0}),Line(points = {{70,0},{90,0}}, color = {0,0,0}),Line(points = {{0, -100},{0, -70}}, color = {0,0,127}),Text(extent = {{ -150,70},{150,110}}, textString = "%name", lineColor = {0,0,255})}), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Line(points = {{ -70,0},{ -90,0}}, color = {0,0,0}),Line(points = {{70,0},{90,0}}, color = {0,0,0}),Line(points = {{0, -100},{0, -70}}, color = {0,0,255})}));
        end RelativeSensor;
      end Interfaces;
      package Types "Constants and types with choices, especially to build menus"
        extends Modelica.Icons.Library;
        annotation(preferedView = "info", Documentation(info = "<HTML>
<p>
In this package <b>types</b> and <b>constants</b> are defined that are used
in library Modelica.Blocks. The types have additional annotation choices
definitions that define the menus to be built up in the graphical
user interface when the type is used as parameter in a declaration.
</p>
</HTML>"));
        package Init "Obsolete type. This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu"
          extends ObsoleteModelica3.Icons.Enumeration;
          constant Integer NoInit = 1 "no initialization (phi_start, w_start are guess values)";
          constant Integer SteadyState = 2 "steady state initialization (der(phi)=der(w)=0)";
          constant Integer InitialState = 3 "initialization with phi_start, w_start";
          constant Integer InitialAngle = 4 "initialization with phi_start";
          constant Integer InitialSpeed = 5 "initialization with w_start";
          constant Integer InitialAcceleration = 6 "initialization with a_start";
          constant Integer InitialAngleAcceleration = 7 "initialization with phi_start, a_start";
          constant Integer InitialSpeedAcceleration = 8 "initialization with w_start, a_start";
          constant Integer InitialAngleSpeedAcceleration = 9 "initialization with phi_start, w_start, a_start";
          type Temp "Obsolete type. This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu"
            extends Modelica.Icons.TypeInteger(min = 1, max = 9);
            annotation(__Dymola_obsolete = "This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu", Evaluate = true, choices(choice = Modelica.Mechanics.Rotational.Types.Init.NoInit "no initialization (phi_start, w_start are guess values)", choice = Modelica.Mechanics.Rotational.Types.Init.SteadyState "steady state initialization (der(phi)=der(w)=0)", choice = Modelica.Mechanics.Rotational.Types.Init.InitialState "initialization with phi_start, w_start", choice = Modelica.Mechanics.Rotational.Types.Init.InitialAngle "initialization with phi_start", choice = Modelica.Mechanics.Rotational.Types.Init.InitialSpeed "initialization with w_start", choice = Modelica.Mechanics.Rotational.Types.Init.InitialAcceleration "initialization with a_start", choice = Modelica.Mechanics.Rotational.Types.Init.InitialAngleAcceleration "initialization with phi_start, a_start", choice = Modelica.Mechanics.Rotational.Types.Init.InitialSpeedAcceleration "initialization with w_start, a_start", choice = Modelica.Mechanics.Rotational.Types.Init.InitialAngleSpeedAcceleration "initialization with phi_start, w_start, a_start"));
          end Temp;
          annotation(Documentation(info = "<html>
<p>
Type <b>Init</b> defines initialization of absolute rotational
quantities.
</p>

</html>"));
        end Init;
        package InitRel "Obsolete type. This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu"
          extends ObsoleteModelica3.Icons.Enumeration;
          constant Integer NoInit = 1 "no initialization (phi_rel_start, w_rel_start are guess values)";
          constant Integer SteadyState = 2 "steady state initialization (der(phi_rel)=der(w_rel)=0)";
          constant Integer InitialState = 3 "initialization with phi_rel_start, w_rel_start";
          constant Integer InitialAngle = 4 "initialization with phi_rel_start";
          constant Integer InitialSpeed = 5 "initialization with w_rel_start";
          type Temp "Obsolete type. This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu"
            extends Modelica.Icons.TypeInteger(min = 1, max = 5);
            annotation(__Dymola_obsolete = "This is an emulated enumeration for initialization. Initialization is now defined with start/fixed values and appropriate support in the parameter menu", Evaluate = true, choices(choice = Modelica.Mechanics.Rotational.Types.Init.NoInit "no initialization (phi_rel_start, w_rel_start are guess values)", choice = Modelica.Mechanics.Rotational.Types.Init.SteadyState "steady state initialization (der(phi)=der(w)=0)", choice = Modelica.Mechanics.Rotational.Types.Init.InitialState "initialization with phi_rel_start, w_rel_start", choice = Modelica.Mechanics.Rotational.Types.Init.InitialAngle "initialization with phi_rel_start", choice = Modelica.Mechanics.Rotational.Types.Init.InitialSpeed "initialization with w_rel_start"));
          end Temp;
          annotation(Documentation(info = "<html>
<p>
Type <b>Init</b> defines initialization of relative rotational
quantities.
</p>

</html>"));
        end InitRel;
      end Types;
      model GearEfficiency "Obsolete model. Use Modelica.Mechanics.Rotational.Components.LossyGear instead"
        extends ObsoleteModelica3.Mechanics.Rotational.Interfaces.TwoFlangesAndBearing;
        extends ObsoleteModelica3.Icons.ObsoleteModel;
        parameter Real eta(min = Modelica.Constants.small, max = 1) = 1 "Efficiency";
        Modelica.SIunits.Angle phi;
        Modelica.SIunits.Power power_a "Energy flowing into flange_a (= power)";
        Boolean driving_a "True, if energy is flowing INTO and not out of flange flange_a";
        annotation(__Dymola_obsolete = "This model can get stuck due when the torque direction varies, use Modelica.Mechanics.Rotational.Components.LossyGear instead.", Window(x = 0.23, y = 0.06, width = 0.69, height = 0.62), Icon(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Text(extent = {{ -150,100},{150,60}}, textString = "%name", lineColor = {0,0,255}),Rectangle(extent = {{ -100,20},{100, -20}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192,192,192}),Line(points = {{ -30, -40},{30, -40}}, color = {0,0,0}),Line(points = {{0, -40},{0, -90}}, color = {0,0,0}),Polygon(points = {{ -30, -20},{60, -20},{60, -80},{70, -80},{50, -100},{30, -80},{40, -80},{40, -30},{ -30, -30},{ -30, -20},{ -30, -20}}, lineColor = {0,0,0}, fillColor = {255,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{ -150,60},{150,20}}, lineColor = {0,0,0}, textString = "eta=%eta"),Line(points = {{30, -50},{20, -60}}, color = {0,0,0}),Line(points = {{30, -40},{10, -60}}, color = {0,0,0}),Line(points = {{20, -40},{0, -60}}, color = {0,0,0}),Line(points = {{10, -40},{ -10, -60}}, color = {0,0,0}),Line(points = {{0, -40},{ -20, -60}}, color = {0,0,0}),Line(points = {{ -10, -40},{ -30, -60}}, color = {0,0,0}),Line(points = {{ -20, -40},{ -30, -50}}, color = {0,0,0})}), Documentation(info = "<html>
<p>
THIS COMPONENT IS <b>OBSOLETE</b> and should <b>no longer be used</b>. It is only
kept for <b>backward compatibility</b> purposes. Use model
Modelica.Mechanics.Rotational.LossyGear instead which implements
gear efficiency in a much more reliable way.
</p>
<p>
This component consists of two rigidly connected flanges flange_a and flange_b without
inertia where an <b>efficency</b> coefficient <b>eta</b> reduces the driven
torque as function of the driving torque depending on the direction
of the energy flow, i.e., energy is always lost. This can be seen as a
simple model of the Coulomb friction acting between the teeth of a
gearbox.
</p>
<p>
Note, that most gearbox manufacturers provide tables of the
efficiency of a gearbox as function of the angular velocity
(efficiency becomes zero, if the angular velocity is zero).
However, such a table is practically useless for simulation purposes,
because in gearboxes always two types of friction is present:
(1) Friction in the <b>bearings</b> and (2) friction between
the teeth of the gear. (1) leads to a velocity dependent, additive
loss-torque, whereas (2) leads to a torque-dependent reduction of the
driving torque. The gearbox manufacturers measure both effects
together and determine the gear efficiency from it, although for
simulation purposes the two effects need to be separated.
Assume for example that only constant bearing friction, i.e.,
bearingTorque=const., is present, i.e.,
</p>
<pre>
   (1)  loadTorque = motorTorque - sign(w)*bearingTorque
</pre>
<p>
Gearbox manufacturers use the loss-formula
</p>
<pre>
   (2)  loadTorque = eta*motorTorque
</pre>
<p>
Comparing (1) and (2) gives a formulat for the efficiency eta:
</p>
<pre>
   eta = (1 - sign(w)*bearingTorque/motorTorque)
</pre>
<p>
When the motorTorque becomes smaller as the bearingTorque,
(2) is useless, because the efficiency is zero. To summarize,
be careful to determine the gear <b>efficiency</b> of this element
from tables of the gear manufacturers.
</p>

</HTML>
"), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Rectangle(extent = {{ -96,20},{96, -21}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192,192,192}),Line(points = {{ -30, -40},{30, -40}}, color = {0,0,0}),Line(points = {{0,60},{0,40}}, color = {0,0,0}),Line(points = {{ -30,40},{29,40}}, color = {0,0,0}),Line(points = {{0, -40},{0, -90}}, color = {0,0,0}),Polygon(points = {{ -30, -20},{60, -20},{60, -80},{70, -80},{50, -100},{30, -80},{40, -80},{40, -30},{ -30, -30},{ -30, -20},{ -30, -20}}, lineColor = {0,0,0}, fillColor = {255,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{16,83},{84,70}}, lineColor = {128,128,128}, textString = "rotation axis"),Polygon(points = {{12,76},{ -8,81},{ -8,71},{12,76}}, lineColor = {128,128,128}, fillColor = {128,128,128}, fillPattern = FillPattern.Solid),Line(points = {{ -78,76},{ -7,76}}, color = {128,128,128}),Line(points = {{30, -50},{20, -60}}, color = {0,0,0}),Line(points = {{30, -40},{10, -60}}, color = {0,0,0}),Line(points = {{20, -40},{0, -60}}, color = {0,0,0}),Line(points = {{10, -40},{ -10, -60}}, color = {0,0,0}),Line(points = {{0, -40},{ -20, -60}}, color = {0,0,0}),Line(points = {{ -10, -40},{ -30, -60}}, color = {0,0,0}),Line(points = {{ -20, -40},{ -30, -50}}, color = {0,0,0})}));

      equation 
        phi = phi_a;
        phi = phi_b;
        power_a = flange_a.tau * der(phi);
        driving_a = power_a >= 0;
        flange_b.tau =  -(if driving_a then eta * flange_a.tau else flange_a.tau / eta);
      end GearEfficiency;
      model Gear "Obsolete model. Use Modelica.Mechanics.Rotational.Components.Gearbox instead"
        extends ObsoleteModelica3.Mechanics.Rotational.Interfaces.TwoFlangesAndBearingH;
        parameter Real ratio = 1 "transmission ratio (flange_a.phi/flange_b.phi)";
        parameter Real eta(min = Modelica.Constants.small, max = 1) = 1 "Gear efficiency";
        parameter Real friction_pos[:,2] = [0,1] "[w,tau] positive sliding friction characteristic (w>=0)";
        parameter Real peak(final min = 1) = 1 "peak*friction_pos[1,2] = maximum friction torque at zero velocity";
        parameter Real c(final unit = "N.m/rad", final min = Modelica.Constants.small) = 100000.0 "Gear elasticity (spring constant)";
        parameter Real d(final unit = "N.m.s/rad", final min = 0) = 0 "(relative) gear damping";
        parameter Modelica.SIunits.Angle b(final min = 0) = 0 "Total backlash";
        annotation(__Dymola_obsolete = "This model can get stuck due when the torque direction varies, use Modelica.Mechanics.Rotational.Components.Gearbox instead.", Documentation(info = "<html>
<p>
This component models the essential effects of a gearbox, in particular
gear <b>efficiency</b> due to friction between the teeth, <b>bearing friction</b>,
gear <b>elasticity</b> and <b>damping</b>, <b>backlash</b>.
The inertia of the gear wheels is not modeled. If necessary, inertia
has to be taken into account by connecting components of model Inertia
to the left and/or the right flange.
</p>

</HTML>
"), Icon(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -40,60},{40, -60}}, lineColor = {0,0,0}, pattern = LinePattern.Solid, lineThickness = 0.25, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192,192,192}),Polygon(points = {{ -60, -80},{ -46, -80},{ -20, -20},{20, -20},{46, -80},{60, -80},{60, -90},{ -60, -90},{ -60, -80}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Rectangle(extent = {{ -100,10},{ -60, -10}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192,192,192}),Rectangle(extent = {{60,10},{100, -10}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {192,192,192}),Polygon(points = {{ -60,10},{ -60,20},{ -40,40},{ -40, -40},{ -60, -20},{ -60,10}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {128,128,128}),Polygon(points = {{60,20},{40,40},{40, -40},{60, -20},{60,20}}, lineColor = {128,128,128}, fillColor = {128,128,128}, fillPattern = FillPattern.Solid),Text(extent = {{ -150,110},{150,70}}, textString = "%name=%ratio", lineColor = {0,0,255}),Text(extent = {{ -150, -160},{150, -120}}, lineColor = {0,0,0}, textString = "c=%c")}), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics = {Text(extent = {{2,29},{46,22}}, lineColor = {128,128,128}, textString = "rotation axis"),Polygon(points = {{4,25},{ -4,27},{ -4,23},{4,25}}, lineColor = {128,128,128}, fillColor = {128,128,128}, fillPattern = FillPattern.Solid),Line(points = {{ -36,25},{ -3,25}}, color = {128,128,128})}));
        Modelica.Mechanics.Rotational.Components.IdealGear gearRatio(final ratio = ratio) annotation(Placement(transformation(extent = {{ -70, -10},{ -50,10}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.Rotational.GearEfficiency gearEfficiency(final eta = eta) annotation(Placement(transformation(extent = {{ -30, -10},{ -10,10}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.ElastoBacklash elastoBacklash(final b = b, final c = c, final phi_rel0 = 0, final d = d) annotation(Placement(transformation(extent = {{50, -10},{70,10}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.BearingFriction bearingFriction(final tau_pos = friction_pos, final peak = peak) annotation(Placement(transformation(extent = {{10, -10},{30,10}}, rotation = 0)));

      equation 
        connect(flange_a,gearRatio.flange_a) annotation(Line(points = {{ -100,0},{ -70,0}}, color = {0,0,0}));
        connect(gearRatio.flange_b,gearEfficiency.flange_a) annotation(Line(points = {{ -50,0},{ -30,0}}, color = {0,0,0}));
        connect(gearEfficiency.flange_b,bearingFriction.flange_a) annotation(Line(points = {{ -10,0},{10,0}}, color = {0,0,0}));
        connect(bearingFriction.flange_b,elastoBacklash.flange_a) annotation(Line(points = {{30,0},{50,0}}, color = {0,0,0}));
        connect(elastoBacklash.flange_b,flange_b) annotation(Line(points = {{70,0},{100,0}}, color = {0,0,0}));
        connect(gearEfficiency.bearing,adapter.flange_b) annotation(Line(points = {{ -20, -10},{ -20, -40},{6.12323e-16, -40},{6.12323e-16, -50}}, color = {0,0,0}));
        connect(bearingFriction.support,adapter.flange_b) annotation(Line(points = {{20, -10},{20, -40},{6.12323e-16, -40},{6.12323e-16, -50}}, color = {0,0,0}, smooth = Smooth.None));
        connect(gearRatio.support,adapter.flange_b) annotation(Line(points = {{ -60, -10},{ -60, -40},{6.12323e-16, -40},{6.12323e-16, -50}}, color = {0,0,0}, smooth = Smooth.None));
      end Gear;
    end Rotational;
  end Mechanics;
end ObsoleteModelica3;
package ModelicaTest "Library to test components of library Modelica "
  annotation(version = "1.1", versionDate = "2007-10-19", uses(Modelica(version = "3.1")), Documentation(info = "<html>
<p>
This library provides models and functions to test components of
<b>package Modelica</b> (the Modelica Standard Library).
</p>

<p>
Further development of this library should be performed in the following
way:
</p>

<ul>
<li> Functions that are added to this library to test functions of the
     Modelica Standard Library, should be called in \"ModelicaTest.testAllFunctions()\".
     The idea is that all test functions are called, when calling
     \"testAllFunctions()\".</li>

<li> Models that are added to this library should have the annotation
     (with an appropriate StopTime):
     <pre>
         <b>annotation</b>(experiment(StopTime=1.1)); </pre>
     This gives the tool vendors the possibility to automatically identify
     the models that shall be simulated and, e.g., that shall be used in an automatic
     regression test.</li>
</ul>

<p>
Copyright &copy; 1998-2007, Modelica Association.
</p>
<p>
<i>This Modelica package is <b>free</b> software; it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b>
<a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense\">here</a>.</i>
</p>
</html>"), conversion(from(version = "1.0", script = "ConvertFromModelicaTest_1.0.mos")));
  function testAllFunctions "Runs all test cases for functions"
    import Modelica.Utilities.Streams.print;
    input String logFile = "ModelicaTestLog.txt" "Filename where the log of all functions is stored";
    output Boolean ok;
  protected 
    Boolean result;
    String file;
  algorithm 
    file:=Modelica.Utilities.Files.fullPathName(logFile);
    print("... testAllFunctions(..) is logged in " + file);
    if file <> "" then 
        Modelica.Utilities.Files.removeFile(file);

    else 
    end if;
    print("--- Test functions of Modelica library", logFile);
    result:=ModelicaTest.Math.Polynomials(logFile);
    result:=ModelicaTest.Math.Matrices(logFile);
    result:=ModelicaTest.Utilities.testAll(logFile);
    ok:=true;
  end testAllFunctions;
  package Fluid "Test cases for the Modelica.Fluid library"
    import SI = Modelica.SIunits;
    package TestComponents "Models to test components of the library"
      extends Modelica.Icons.Library;
      annotation(classOrder = {"TestTanks","*"});
      package Vessels "Test Vessel models"
        model TestVolume
          extends Modelica.Icons.Example;
          Modelica.Fluid.Vessels.ClosedVolume Volume(redeclare package Medium = Modelica.Media.Water.StandardWater, V = 1, use_T_start = false, h_start = 3000000.0, nPorts = 2, energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyState, massDynamics = Modelica.Fluid.Types.Dynamics.SteadyState, portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.0254),Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.0254)}) annotation(Placement(transformation(extent = {{ -40,14},{ -20,34}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_h FlowSource(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow = 1, h = 3000000.0) annotation(Placement(transformation(extent = {{ -82,0},{ -62,20}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 101325, T = system.T_ambient) annotation(Placement(transformation(extent = {{60,0},{40,20}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveLinear Valve(redeclare package Medium = Modelica.Media.Water.StandardWater, dp_nominal = 10000, m_flow_nominal = 0.1) annotation(Placement(transformation(extent = {{2,0},{22,20}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5));
          Modelica.Blocks.Sources.Step Step1(startTime = 1, height =  -0.5, offset = 1) annotation(Placement(transformation(extent = {{ -40,48},{ -20,68}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));

        equation 
          connect(Valve.port_b,Sink.ports[1]) annotation(Line(points = {{22,10},{40,10}}, color = {0,127,255}));
          connect(Step1.y,Valve.opening) annotation(Line(points = {{ -19,58},{12,58},{12,18}}, color = {0,0,127}));
          connect(FlowSource.ports[1],Volume.ports[1]) annotation(Line(points = {{ -62,10},{ -32,10},{ -32,14}}, color = {0,127,255}, smooth = Smooth.None));
          connect(Volume.ports[2],Valve.port_a) annotation(Line(points = {{ -28,14},{ -28,10},{2,10}}, color = {0,127,255}, smooth = Smooth.None));
        end TestVolume;
        model TestTankWithTopPorts
          extends Modelica.Icons.Example;
          import Modelica.Fluid;
          Modelica.Fluid.Examples.AST_BatchPlant.BaseClasses.TankWithTopPorts tank(nTopPorts = 2, height = 10, V0 = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, level_start = 1, nPorts = 4, portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.01, height = 9),Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.01, height = 6),Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.01, height = 4),Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.01, height = 2)}, crossArea = 0.2) annotation(Placement(transformation(extent = {{ -40,40},{0,80}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_T massFlowRate[2](each nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, each m_flow = 0.75) annotation(Placement(transformation(extent = {{ -82,70},{ -62,90}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5000, Tolerance = 1e-05), experimentSetupOutput(equdistant = false));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Fluid.Sources.FixedBoundary Boundary_fixed(redeclare package Medium = Modelica.Media.Water.StandardWater, p = system.p_ambient, T = system.T_ambient, nPorts = 4) annotation(Placement(transformation(extent = {{100, -90},{80, -70}}, rotation = 0)));
          Modelica.Fluid.Sensors.MassFlowRate mFlow_9m(redeclare package Medium = Modelica.Media.Water.StandardWater) "Mass flow rate out of the port at a lever of 9 m" annotation(Placement(transformation(extent = {{20,30},{40,50}}, rotation = 0)));
          Modelica.Fluid.Sensors.MassFlowRate mFlow_6m(redeclare package Medium = Modelica.Media.Water.StandardWater) "Mass flow rate out of the port at a lever of 6 m" annotation(Placement(transformation(extent = {{20, -10},{40,10}}, rotation = 0)));
          Modelica.Fluid.Sensors.MassFlowRate mFlow_4m(redeclare package Medium = Modelica.Media.Water.StandardWater) "Mass flow rate out of the port at a lever of 4 m" annotation(Placement(transformation(extent = {{20, -50},{40, -30}}, rotation = 0)));
          Modelica.Fluid.Sensors.MassFlowRate mFlow_2m(redeclare package Medium = Modelica.Media.Water.StandardWater) "Mass flow rate out of the port at a lever of 2 m" annotation(Placement(transformation(extent = {{20, -90},{40, -70}}, rotation = 0)));

        equation 
          connect(massFlowRate.ports[1],tank.topPorts) annotation(Line(points = {{ -62,80},{ -40,80},{ -40,81},{ -20,81}}, color = {0,127,255}, smooth = Smooth.None));
          connect(tank.ports[1],mFlow_9m.port_a) annotation(Line(points = {{ -23,39},{ -0.5,39},{ -0.5,40},{20,40}}, color = {0,0,255}, smooth = Smooth.None));
          connect(mFlow_9m.port_b,Boundary_fixed.ports[1]) annotation(Line(points = {{40,40},{60,40},{60, -77},{80, -77}}, color = {0,127,255}, smooth = Smooth.None));
          connect(tank.ports[2],mFlow_6m.port_a) annotation(Line(points = {{ -21,39},{0,39},{0,0},{20,0}}, color = {0,0,255}, smooth = Smooth.None));
          connect(mFlow_6m.port_b,Boundary_fixed.ports[2]) annotation(Line(points = {{40,0},{60,0},{60, -79},{80, -79}}, color = {0,127,255}, smooth = Smooth.None));
          connect(tank.ports[3],mFlow_4m.port_a) annotation(Line(points = {{ -19,39},{0,39},{0, -40},{20, -40}}, color = {0,0,255}, smooth = Smooth.None));
          connect(mFlow_4m.port_b,Boundary_fixed.ports[3]) annotation(Line(points = {{40, -40},{60, -40},{60, -81},{80, -81}}, color = {0,127,255}, smooth = Smooth.None));
          connect(tank.ports[4],mFlow_2m.port_a) annotation(Line(points = {{ -17,39},{0,39},{0, -80},{20, -80}}, color = {0,0,255}, smooth = Smooth.None));
          connect(mFlow_2m.port_b,Boundary_fixed.ports[4]) annotation(Line(points = {{40, -80},{60, -80},{60, -83},{80, -83}}, color = {0,127,255}, smooth = Smooth.None));
        end TestTankWithTopPorts;
        model TestSimpleTank "Test a tank running empty and being filled through a top inlet with less water than could flow through the bottom outlet"
          import Modelica.SIunits.Conversions.from_bar;
          extends Modelica.Icons.Example;
          Modelica.Fluid.Vessels.OpenTank tank(redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater, height = 1, nPorts = 2, portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.1, height = 0),Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.1, height = 1)}, crossArea = 1, level_start = 0) annotation(Placement(transformation(extent = {{0,0},{40,40}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{70,70},{90,90}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT ambient_fixed(redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater, p = system.p_ambient, T = system.T_ambient, nPorts = 1) annotation(Placement(transformation(extent = {{ -40, -70},{ -20, -50}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe(redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater, length = 1, height_ab =  -1, diameter = 0.1) annotation(Placement(transformation(origin = {20, -30}, extent = {{10, -10},{ -10,10}}, rotation = 90)));
          Modelica.Fluid.Sources.MassFlowSource_T flowSource(nPorts = 1, redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater, m_flow = 20, T = system.T_ambient, use_m_flow_in = true) annotation(Placement(transformation(extent = {{ -40,30},{ -20,50}}, rotation = 0)));
          Modelica.Blocks.Sources.TimeTable timeTable(table = [0,0;10,0;10,40;20,40;20,10;50,10;50,0;60,0;60,20;70,20;80,55;80,0;100,0]) annotation(Placement(transformation(extent = {{ -80,40},{ -60,60}})));

        equation 
          connect(pipe.port_a,tank.ports[1]) annotation(Line(points = {{20, -20},{20,0},{16,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(flowSource.ports[1],tank.ports[2]) annotation(Line(points = {{ -20,40},{0,40},{0,0},{24,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(ambient_fixed.ports[1],pipe.port_b) annotation(Line(points = {{ -20, -60},{20, -60},{20, -40}}, color = {0,127,255}, smooth = Smooth.None));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 100), experimentSetupOutput);
          connect(flowSource.m_flow_in,timeTable.y) annotation(Line(points = {{ -40,48},{ -50,48},{ -50,50},{ -59,50}}, color = {0,0,127}, smooth = Smooth.None));
        end TestSimpleTank;
        model TestMixingVolumesPressureStates "Test case where in one of the mixing volumes a pressure state appears"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          package Medium = Modelica.Media.Water.StandardWater;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10));
          Modelica.Fluid.Vessels.ClosedVolume mixingVolume1(V = 0.001, redeclare package Medium = Medium, p_start = system.p_ambient, use_T_start = true, T_start = system.T_ambient, nPorts = 2, energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, massDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, use_portsData = false) annotation(Placement(transformation(extent = {{ -30,38},{ -10,58}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_h flowSource2(nPorts = 1, m_flow = 1, h = 200000.0, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -100,30},{ -80,50}}, rotation = 0)));
          Modelica.Fluid.Vessels.ClosedVolume mixingVolume2(V = 0.001, p_start = system.p_ambient, use_T_start = false, h_start = 100000.0, redeclare package Medium = Medium, nPorts = 2, use_portsData = false) annotation(Placement(transformation(extent = {{10,38},{30,58}}, rotation = 0)));
          Modelica.Fluid.Sensors.Temperature Tmix_in(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -50,70},{ -30,90}}, rotation = 0)));
          Modelica.Fluid.Sensors.Temperature Tmix_out(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{30,68},{50,88}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph sink2(nPorts = 1, redeclare package Medium = Medium, h = Medium.h_default, p = 101325) annotation(Placement(transformation(extent = {{100,30},{80,50}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Fluid.Pipes.BaseClasses.WallFriction.TestWallFrictionAndGravity simpleGenericOrifice2(redeclare package Medium = Medium, diameter = 0.2, length = 1, redeclare package WallFriction = Modelica.Fluid.Pipes.BaseClasses.WallFriction.Laminar) annotation(Placement(transformation(extent = {{50,30},{70,50}}, rotation = 0)));
          Modelica.Fluid.Pipes.BaseClasses.WallFriction.TestWallFrictionAndGravity simpleGenericOrifice1(redeclare package Medium = Medium, diameter = 0.2, length = 1, redeclare package WallFriction = Modelica.Fluid.Pipes.BaseClasses.WallFriction.Laminar) annotation(Placement(transformation(extent = {{ -70,30},{ -50,50}}, rotation = 0)));

        equation 
          connect(simpleGenericOrifice2.port_b,sink2.ports[1]) annotation(Line(points = {{70,40},{80,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(flowSource2.ports[1],simpleGenericOrifice1.port_a) annotation(Line(points = {{ -80,40},{ -70,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(simpleGenericOrifice1.port_b,Tmix_in.port) annotation(Line(points = {{ -50,40},{ -40,40},{ -40,70}}, color = {0,127,255}, smooth = Smooth.None));
          connect(Tmix_out.port,simpleGenericOrifice2.port_a) annotation(Line(points = {{40,68},{40,40},{50,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(simpleGenericOrifice1.port_b,mixingVolume1.ports[1]) annotation(Line(points = {{ -50,40},{ -36,40},{ -36,38},{ -22,38}}, color = {0,127,255}, smooth = Smooth.None));
          connect(mixingVolume1.ports[2],mixingVolume2.ports[2]) annotation(Line(points = {{ -18,38},{ -18,34},{22,34},{22,38}}, color = {0,127,255}, smooth = Smooth.None));
          connect(mixingVolume2.ports[1],simpleGenericOrifice2.port_a) annotation(Line(points = {{18,38},{34,38},{34,40},{50,40}}, color = {0,127,255}, smooth = Smooth.None));
        end TestMixingVolumesPressureStates;
        model TestMixingVolumes
          extends Modelica.Icons.Example;
          package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10));
          Modelica.Fluid.Vessels.ClosedVolume mixingVolume1(V = 0.001, use_T_start = false, h_start = 100000.0, redeclare package Medium = Medium, nPorts = 3, use_portsData = false) annotation(Placement(transformation(extent = {{ -30,40},{ -10,60}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_h flowSource2(nPorts = 1, m_flow = 1, h = 200000.0, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -98,24},{ -78,44}}, rotation = 0)));
          Modelica.Fluid.Vessels.ClosedVolume mixingVolume2(V = 0.001, use_T_start = false, h_start = 100000.0, redeclare package Medium = Medium, nPorts = 3, use_portsData = false) annotation(Placement(transformation(extent = {{10,40},{30,60}}, rotation = 0)));
          Modelica.Fluid.Sensors.Temperature Tmix_in(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -60,50},{ -40,70}}, rotation = 0)));
          Modelica.Fluid.Sensors.Temperature Tmix_out(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{40,50},{60,70}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph sink2(nPorts = 1, redeclare package Medium = Medium, h = Medium.h_default, p = 101325) annotation(Placement(transformation(extent = {{100,30},{80,50}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));

        equation 
          connect(flowSource2.ports[1],mixingVolume1.ports[2]) annotation(Line(points = {{ -78,34},{ -52,34},{ -20,34},{ -20,40}}, color = {0,127,255}));
          connect(mixingVolume2.ports[2],sink2.ports[1]) annotation(Line(points = {{20,40},{20,40},{80,40}}, color = {0,127,255}));
          connect(Tmix_in.port,mixingVolume1.ports[1]) annotation(Line(points = {{ -50,50},{ -50,36},{ -22,36},{ -22,40},{ -22.6667,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(Tmix_out.port,mixingVolume2.ports[1]) annotation(Line(points = {{50,50},{50,40},{17.3333,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(mixingVolume1.ports[3],mixingVolume2.ports[3]) annotation(Line(points = {{ -17.3333,40},{ -17.3333,36},{22.6667,36},{22.6667,40}}, color = {0,127,255}, smooth = Smooth.None));
        end TestMixingVolumes;
        model TestInitialization
          extends Modelica.Icons.Example;
          package Medium = Modelica.Media.Air.SimpleAir;
          Modelica.Fluid.Sources.Boundary_pT sou1(nPorts = 1, redeclare package Medium = Medium, p = 101330, T = 293.15) annotation(Placement(transformation(extent = {{ -90,10},{ -70,30}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT sin1(nPorts = 1, redeclare package Medium = Medium, p = 101320, T = 293.15) annotation(Placement(transformation(extent = {{90,10},{70,30}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe1(redeclare package Medium = Medium, length = 1, diameter = 0.25) annotation(Placement(transformation(extent = {{ -50,10},{ -30,30}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe2(redeclare package Medium = Medium, length = 1, diameter = 0.25) annotation(Placement(transformation(extent = {{30,10},{50,30}}, rotation = 0)));
          Modelica.Fluid.Vessels.ClosedVolume vol1(redeclare package Medium = Medium, V = 0.1, nPorts = 2, portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.25),Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.25)}) annotation(Placement(transformation(extent = {{ -10,20},{10,40}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}})));

        equation 
          connect(sou1.ports[1],pipe1.port_a) annotation(Line(points = {{ -70,20},{ -50,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe1.port_b,vol1.ports[1]) annotation(Line(points = {{ -30,20},{ -2,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(vol1.ports[2],pipe2.port_a) annotation(Line(points = {{2,20},{30,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe2.port_b,sin1.ports[1]) annotation(Line(points = {{50,20},{70,20}}, color = {0,127,255}, smooth = Smooth.None));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics = {Text(extent = {{ -100, -8},{100, -14}}, lineColor = {0,0,255}, textString = "Problem: Medium SimpleAir missing stateSelect.prefer on pressure p (see Ticket #63)"),Text(extent = {{ -100, -28},{100, -34}}, lineColor = {0,0,255}, textString = "This leads to the bad state m without start value and results in a division by zero"),Text(extent = {{ -100, -46},{100, -52}}, lineColor = {0,0,255}, textString = "Work-around: Use Medium MoistAir.")}), experiment(StopTime = 1));
        end TestInitialization;
      end Vessels;
      package Valves "Test Valve models"
        model TestValveVaporizing "Test case for vaporizing fluid valve"
          extends Modelica.Icons.Example;
          Modelica.Fluid.Sources.Boundary_pT SourceP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 200000, T(displayUnit = "degC") = 373.15) annotation(Placement(transformation(extent = {{ -76, -22},{ -56, -2}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveVaporizing V1(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, CvData = Modelica.Fluid.Types.CvTypes.Av, Av = 0.00024, dp_nominal = 100000, rho_nominal = 1000) annotation(Placement(transformation(extent = {{ -26, -22},{ -6, -2}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_p_in = true, p = 100000, T = 293.15) annotation(Placement(transformation(extent = {{46, -22},{26, -2}}, rotation = 0)));
          Modelica.Blocks.Sources.Constant Opening(k = 1) annotation(Placement(transformation(extent = {{ -78,22},{ -58,42}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64,60},{84,80}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp downstreamPressure(offset = 200000.0, duration = 0.6, startTime = 0.2, height =  -150000.0) annotation(Placement(transformation(extent = {{14,20},{34,40}})));

        equation 
          connect(V1.port_b,SinkP1.ports[1]) annotation(Line(points = {{ -6, -12},{26, -12}}));
          connect(Opening.y,V1.opening) annotation(Line(points = {{ -57,32},{ -16,32},{ -16, -3}}, color = {0,0,255}));
          connect(SourceP1.ports[1],V1.port_a) annotation(Line(points = {{ -56, -12},{ -26, -12}}, color = {0,127,255}));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment);
          connect(downstreamPressure.y,SinkP1.p_in) annotation(Line(points = {{35,30},{60,30},{60, -6},{48, -6}}, color = {0,0,127}, smooth = Smooth.None));
        end TestValveVaporizing;
        model TestValvesReverse "Test case for valves with reverse and zero flow"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          package Medium = Modelica.Media.Water.StandardWater;
          Modelica.Fluid.Sources.Boundary_pT SourceP1(T = system.T_ambient, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, nPorts = 2, p = 1000000) annotation(Placement(transformation(extent = {{ -100,26},{ -80,46}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SourceP2(T = system.T_ambient, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, nPorts = 2, p = 800000) annotation(Placement(transformation(extent = {{ -100, -50},{ -80, -30}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP1(nPorts = 1, T = system.T_ambient, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, p = 100000) annotation(Placement(transformation(extent = {{82, -4},{62,16}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V1(dp_nominal = 900000.0, m_flow_nominal = 1.5, redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, Av = 0.1) annotation(Placement(transformation(extent = {{ -50,58},{ -30,78}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V2(dp_nominal = 500000.0, m_flow_nominal = 1.2, redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, Av = 0.1) annotation(Placement(transformation(extent = {{ -38,26},{ -18,46}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V3(dp_nominal = 300000.0, m_flow_nominal = 1.1, redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint) annotation(Placement(transformation(extent = {{ -38, -38},{ -18, -18}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V4(dp_nominal = 800000.0, m_flow_nominal = 1.3, redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint) annotation(Placement(transformation(extent = {{ -40, -78},{ -20, -58}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V5(dp_nominal = 400000.0, m_flow_nominal = 2, redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint) annotation(Placement(transformation(extent = {{30, -4},{50,16}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 4, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Fluid.Sources.Boundary_pT SinkP2(nPorts = 1, T = system.T_ambient, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, p = 100000) annotation(Placement(transformation(extent = {{4,58},{ -16,78}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP3(nPorts = 1, T = system.T_ambient, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, p = 100000) annotation(Placement(transformation(extent = {{26, -78},{6, -58}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp CloseLoad(duration = 1, offset = 1, startTime = 1, height =  -0.99) annotation(Placement(transformation(extent = {{8,26},{28,46}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp OpenRelief(duration = 2, height = 1, offset = 0, startTime = 1) annotation(Placement(transformation(extent = {{ -92,70},{ -72,90}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp CloseValves(duration = 2, offset = 1, startTime = 1, height =  -1) annotation(Placement(transformation(extent = {{ -96, -12},{ -76,8}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{60,68},{80,88}}, rotation = 0)));

        equation 
          connect(V1.port_b,SinkP2.ports[1]) annotation(Line(points = {{ -30,68},{ -16,68}}));
          connect(V4.port_b,SinkP3.ports[1]) annotation(Line(points = {{ -20, -68},{6, -68}}));
          connect(SourceP1.ports[1],V1.port_a) annotation(Line(points = {{ -80,38},{ -68,38},{ -68,68},{ -50,68}}, color = {0,127,255}));
          connect(SourceP1.ports[2],V2.port_a) annotation(Line(points = {{ -80,34},{ -59,34},{ -59,36},{ -38,36}}, color = {0,127,255}));
          connect(V2.port_b,V5.port_a) annotation(Line(points = {{ -18,36},{5,36},{5,6},{30,6}}, color = {0,127,255}));
          connect(V3.port_b,V5.port_a) annotation(Line(points = {{ -18, -28},{6, -28},{6,6},{30,6}}, color = {0,127,255}));
          connect(SourceP2.ports[2],V4.port_a) annotation(Line(points = {{ -80, -42},{ -60, -42},{ -60, -68},{ -40, -68}}, color = {0,127,255}));
          connect(SourceP2.ports[1],V3.port_a) annotation(Line(points = {{ -80, -38},{ -60, -38},{ -60, -28},{ -38, -28}}, color = {0,127,255}));
          connect(OpenRelief.y,V1.opening) annotation(Line(points = {{ -71,80},{ -40,80},{ -40,76}}, color = {0,0,127}));
          connect(OpenRelief.y,V4.opening) annotation(Line(points = {{ -71,80},{ -64,80},{ -64, -52},{ -30, -52},{ -30, -60}}, color = {0,0,127}));
          connect(CloseValves.y,V2.opening) annotation(Line(points = {{ -75, -2},{ -46, -2},{ -46,54},{ -28,54},{ -28,44}}, color = {0,0,127}));
          connect(CloseValves.y,V3.opening) annotation(Line(points = {{ -75, -2},{ -28, -2},{ -28, -20}}, color = {0,0,127}));
          connect(CloseLoad.y,V5.opening) annotation(Line(points = {{29,36},{40,36},{40,14}}, color = {0,0,127}));
          connect(V5.port_b,SinkP1.ports[1]) annotation(Line(points = {{50,6},{62,6}}, color = {0,127,255}));
        end TestValvesReverse;
        model TestValveLinear "Test case for linear valve"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          Modelica.Fluid.Sources.Boundary_pT SourceP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 200000, T(displayUnit = "degC") = 298.15) annotation(Placement(transformation(extent = {{ -76, -22},{ -56, -2}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveLinear V1(redeclare package Medium = Modelica.Media.Water.StandardWater, dp_nominal = 100000, m_flow_nominal = 2) annotation(Placement(transformation(extent = {{ -26, -22},{ -6, -2}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_p_in = true, p = 100000, T = 293.15) annotation(Placement(transformation(extent = {{46, -22},{26, -2}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp Opening(height = 1, duration = 0.5, offset = 0, startTime = 0.5) annotation(Placement(transformation(extent = {{ -78,22},{ -58,42}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64,60},{84,80}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp downstreamPressure(duration = 0.6, height = 100000.0, offset = 100000.0, startTime = 2.2) annotation(Placement(transformation(extent = {{14,20},{34,40}})));

        equation 
          connect(V1.port_b,SinkP1.ports[1]) annotation(Line(points = {{ -6, -12},{26, -12}}));
          connect(SourceP1.ports[1],V1.port_a) annotation(Line(points = {{ -56, -12},{ -26, -12}}, color = {0,127,255}));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 3));
          connect(downstreamPressure.y,SinkP1.p_in) annotation(Line(points = {{35,30},{60,30},{60, -6},{48, -6}}, color = {0,0,127}, smooth = Smooth.None));
          connect(Opening.y,V1.opening) annotation(Line(points = {{ -57,32},{ -16,32},{ -16, -3}}, color = {0,0,127}, smooth = Smooth.None));
        end TestValveLinear;
        model TestValveIncompressible "Test case with different valve characteristics"
          extends Modelica.Icons.Example;
          package Medium = Modelica.Media.Water.StandardWater;
          Modelica.Fluid.Sources.Boundary_pT SourceP1(nPorts = 1, p = 1000000.0, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient) annotation(Placement(transformation(extent = {{ -100,30},{ -80,50}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V1(rho_nominal = 1000, dp_nominal = 900000.0, m_flow_nominal = 1.5, redeclare package Medium = Modelica.Media.Water.StandardWater, CvData = Modelica.Fluid.Types.CvTypes.Cv, Cv = 10) annotation(Placement(transformation(extent = {{ -50,30},{ -30,50}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 4, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Fluid.Sources.Boundary_pT SinkP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{22,30},{2,50}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp Opening(duration = 2, height = 1, offset = 0, startTime = 1) annotation(Placement(transformation(extent = {{ -92,74},{ -72,94}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SourceP2(nPorts = 1, p = 1000000.0, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient) annotation(Placement(transformation(extent = {{ -100, -10},{ -80,10}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V2(rho_nominal = 1000, dp_nominal = 900000.0, m_flow_nominal = 1.5, redeclare package Medium = Modelica.Media.Water.StandardWater, CvData = Modelica.Fluid.Types.CvTypes.Cv, Cv = 10, redeclare function valveCharacteristic = Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.equalPercentage) annotation(Placement(transformation(extent = {{ -50, -10},{ -30,10}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP2(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{22, -10},{2,10}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SourceP3(nPorts = 1, p = 1000000.0, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient) annotation(Placement(transformation(extent = {{ -100, -50},{ -80, -30}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V3(rho_nominal = 1000, dp_nominal = 900000.0, m_flow_nominal = 1.5, redeclare package Medium = Modelica.Media.Water.StandardWater, CvData = Modelica.Fluid.Types.CvTypes.Cv, Cv = 10, redeclare function valveCharacteristic = Modelica.Fluid.Valves.BaseClasses.ValveCharacteristics.equalPercentage(rangeability = 10)) annotation(Placement(transformation(extent = {{ -50, -50},{ -30, -30}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP3(nPorts = 1, p = 100000.0, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient) annotation(Placement(transformation(extent = {{22, -50},{2, -30}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{58,72},{78,92}}, rotation = 0)));

        equation 
          connect(V1.port_b,SinkP1.ports[1]) annotation(Line(points = {{ -30,40},{2,40}}));
          connect(Opening.y,V1.opening) annotation(Line(points = {{ -71,84},{ -40,84},{ -40,48}}, color = {0,0,255}));
          connect(SourceP1.ports[1],V1.port_a) annotation(Line(points = {{ -80,40},{ -50,40}}, color = {0,127,255}));
          connect(Opening.y,V2.opening) annotation(Line(points = {{ -71,84},{ -64,84},{ -64,20},{ -40,20},{ -40,8}}, color = {0,0,127}));
          connect(Opening.y,V3.opening) annotation(Line(points = {{ -71,84},{ -64,84},{ -64, -22},{ -40, -22},{ -40, -32}}, color = {0,0,127}));
          connect(SourceP2.ports[1],V2.port_a) annotation(Line(points = {{ -80,0},{ -50,0}}, color = {0,127,255}));
          connect(V2.port_b,SinkP2.ports[1]) annotation(Line(points = {{ -30,0},{2,0}}, color = {0,127,255}));
          connect(SourceP3.ports[1],V3.port_a) annotation(Line(points = {{ -80, -40},{ -50, -40}}, color = {0,127,255}));
          connect(V3.port_b,SinkP3.ports[1]) annotation(Line(points = {{ -30, -40},{2, -40}}, color = {0,127,255}));
        end TestValveIncompressible;
        model TestValveDiscrete "Test case for discrete valve"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          Modelica.Fluid.Sources.Boundary_pT SourceP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 200000, T(displayUnit = "degC") = 298.15) annotation(Placement(transformation(extent = {{ -76, -22},{ -56, -2}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveDiscrete V1(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 2, dp_nominal = 100000) annotation(Placement(transformation(extent = {{ -26, -22},{ -6, -2}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_p_in = true, p = 100000, T = 293.15) annotation(Placement(transformation(extent = {{46, -22},{26, -2}}, rotation = 0)));
          Modelica.Blocks.Sources.BooleanStep Opening(startTime = 0.5) annotation(Placement(transformation(extent = {{ -78,22},{ -58,42}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64,60},{84,80}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp downstreamPressure(duration = 0.6, height = 100000.0, offset = 100000.0, startTime = 2.2) annotation(Placement(transformation(extent = {{14,20},{34,40}})));

        equation 
          connect(V1.port_b,SinkP1.ports[1]) annotation(Line(points = {{ -6, -12},{26, -12}}));
          connect(SourceP1.ports[1],V1.port_a) annotation(Line(points = {{ -56, -12},{ -26, -12}}, color = {0,127,255}));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 3));
          connect(downstreamPressure.y,SinkP1.p_in) annotation(Line(points = {{35,30},{60,30},{60, -6},{48, -6}}, color = {0,0,127}, smooth = Smooth.None));
          connect(Opening.y,V1.open) annotation(Line(points = {{ -57,32},{ -16,32},{ -16, -4}}, color = {255,0,255}, smooth = Smooth.None));
        end TestValveDiscrete;
        model TestValveCompressible "Test case for incompressible fluid valve"
          extends Modelica.Icons.Example;
          Modelica.Fluid.Sources.Boundary_pT SourceP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 1000000, T(displayUnit = "degC") = 673.15) annotation(Placement(transformation(extent = {{ -76, -22},{ -56, -2}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveCompressible V1(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, CvData = Modelica.Fluid.Types.CvTypes.Av, Av = 0.00024, dp_nominal = 500000, rho_nominal = 3, p_nominal = 1000000) annotation(Placement(transformation(extent = {{ -26, -22},{ -6, -2}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_p_in = true, p = 100000, T = 673.15) annotation(Placement(transformation(extent = {{46, -22},{26, -2}}, rotation = 0)));
          Modelica.Blocks.Sources.Constant Opening(k = 1) annotation(Placement(transformation(extent = {{ -78,22},{ -58,42}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64,60},{84,80}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine downstreamPressure(amplitude = 500000.0, freqHz = 1, offset = 600000.0, phase = 2.2165681500328) annotation(Placement(transformation(extent = {{14,20},{34,40}})));

        equation 
          connect(V1.port_b,SinkP1.ports[1]) annotation(Line(points = {{ -6, -12},{26, -12}}));
          connect(Opening.y,V1.opening) annotation(Line(points = {{ -57,32},{ -16,32},{ -16, -4}}, color = {0,0,255}));
          connect(SourceP1.ports[1],V1.port_a) annotation(Line(points = {{ -56, -12},{ -26, -12}}, color = {0,127,255}));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment);
          connect(downstreamPressure.y,SinkP1.p_in) annotation(Line(points = {{35,30},{60,30},{60, -6},{48, -6}}, color = {0,0,127}, smooth = Smooth.None));
        end TestValveCompressible;
        model TestValveCoefficients "Test case to compare different choices of flow coefficient"
          extends Modelica.Icons.Example;
          Modelica.Fluid.Sources.Boundary_pT SourceP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 200000) annotation(Placement(transformation(extent = {{ -94,18},{ -74,38}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V1(rho_nominal = 1000, redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, CvData = Modelica.Fluid.Types.CvTypes.Av, Av = 0.00024, dp_nominal = 100000) annotation(Placement(transformation(extent = {{ -44,18},{ -24,38}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{28,18},{8,38}}, rotation = 0)));
          Modelica.Blocks.Sources.Constant Opening(k = 1) annotation(Placement(transformation(extent = {{ -96,62},{ -76,82}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64,60},{84,80}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SourceP2(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 200000) annotation(Placement(transformation(extent = {{ -94, -18},{ -74,2}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V2(rho_nominal = 1000, redeclare package Medium = Modelica.Media.Water.StandardWater, CvData = Modelica.Fluid.Types.CvTypes.Kv, m_flow_nominal = 1, Kv = 9, dp_nominal = 100000) annotation(Placement(transformation(extent = {{ -44, -18},{ -24,2}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP2(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{28, -18},{8,2}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SourceP3(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 200000) annotation(Placement(transformation(extent = {{ -94, -56},{ -74, -36}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V3(rho_nominal = 1000, redeclare package Medium = Modelica.Media.Water.StandardWater, CvData = Modelica.Fluid.Types.CvTypes.Cv, Cv = 10, m_flow_nominal = 1, dp_nominal = 100000) annotation(Placement(transformation(extent = {{ -44, -56},{ -24, -36}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP3(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{28, -56},{8, -36}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SourceP4(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 200000) annotation(Placement(transformation(extent = {{ -94, -88},{ -74, -68}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V4(rho_nominal = 1000, redeclare package Medium = Modelica.Media.Water.StandardWater, Cv = 10, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 100000, m_flow_nominal = 2.4) annotation(Placement(transformation(extent = {{ -44, -88},{ -24, -68}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT SinkP4(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{28, -88},{8, -68}}, rotation = 0)));

        equation 
          connect(V1.port_b,SinkP1.ports[1]) annotation(Line(points = {{ -24,28},{8,28}}));
          connect(Opening.y,V1.opening) annotation(Line(points = {{ -75,72},{ -34,72},{ -34,36}}, color = {0,0,255}));
          connect(SourceP1.ports[1],V1.port_a) annotation(Line(points = {{ -74,28},{ -44,28}}, color = {0,127,255}));
          connect(V2.port_b,SinkP2.ports[1]) annotation(Line(points = {{ -24, -8},{8, -8}}));
          connect(SourceP2.ports[1],V2.port_a) annotation(Line(points = {{ -74, -8},{ -44, -8}}, color = {0,127,255}));
          connect(V3.port_b,SinkP3.ports[1]) annotation(Line(points = {{ -24, -46},{8, -46}}));
          connect(SourceP3.ports[1],V3.port_a) annotation(Line(points = {{ -74, -46},{ -44, -46}}, color = {0,127,255}));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics));
          connect(V2.opening,Opening.y) annotation(Line(points = {{ -34,0},{ -34,8},{ -62,8},{ -62,72},{ -75,72}}, color = {0,0,127}, smooth = Smooth.None));
          connect(V3.opening,Opening.y) annotation(Line(points = {{ -34, -38},{ -34, -26},{ -62, -26},{ -62,72},{ -75,72}}, color = {0,0,127}, smooth = Smooth.None));
          connect(V4.port_b,SinkP4.ports[1]) annotation(Line(points = {{ -24, -78},{8, -78}}));
          connect(SourceP4.ports[1],V4.port_a) annotation(Line(points = {{ -74, -78},{ -44, -78}}, color = {0,127,255}));
          connect(V4.opening,Opening.y) annotation(Line(points = {{ -34, -70},{ -34, -58},{ -62, -58},{ -62,72},{ -75,72}}, color = {0,0,127}, smooth = Smooth.None));
        end TestValveCoefficients;
      end Valves;
      package Utilities "Test Utility models"
        model TestRegStep "Test regStep function"
          extends Modelica.Icons.Example;
          import Modelica.Fluid.Utilities.*;
          parameter Real x_small = 0.5;
          Real x = time - 0.6;
          Real yRegStep = Modelica.Fluid.Utilities.regStep(x, 1, 0.5, x_small);
          Real yRegStep_der;
          annotation(experiment(StopTime = 1.3), experimentSetupOutput);

        equation 
          yRegStep_der = der(yRegStep);
        end TestRegStep;
        model TestRegSquare2Derivatives "Test whether regSquare2 can be differentiated"
          extends Modelica.Icons.Example;
          parameter Real x_small = 0.1;
          parameter Real k1a = 1;
          parameter Real k1b = 0.2;
          parameter Real k2a = 2;
          parameter Real k2b = 0.2;
          Real x;
          Real y;
          Real yd;
          Real ydd;
          Real k1;
          Real k2;
          Real y2;
          Real y2d;
          Real y2dd;
          annotation(experiment(StopTime = 2, NumberOfIntervals = 5000), experimentSetupOutput);

        equation 
          x = time - 1;
          k1 = k1a + k1b * time;
          k2 = k2a + k2b * time;
          y = Modelica.Fluid.Utilities.regSquare2(x, x_small, k1, k2);
          yd = der(y);
          ydd = der(yd);
          y2 = Modelica.Fluid.Utilities.regSquare2(x, x_small, k1, k2, true, 0.02);
          y2d = der(y2);
          y2dd = der(y2d);
        end TestRegSquare2Derivatives;
        model TestRegRootDerivative "Demonstrate that regRoot cannot be differentiated in a typical pressure drop equation (model fails during simulation)"
          extends Modelica.Icons.Example;
          parameter Real x_small = 0.01;
          Real x;
          Real y;
          Real yd;
          Real k1;
          Real k2;
          annotation(experiment(StopTime = 2, NumberOfIntervals = 5000), experimentSetupOutput, Documentation(info = "<html>
<p>
This test model demonstrates that the regRoot(..) function cannot
be differentiated, if multiplied with a discontinuous factor as it
is usual for pressure drop components where upstream properties
are used. In such a case, the regRoot2(..) function should be used.
In order to test this behaviour, change the line \"yd=0\" to \"yd = der(y)\".
</p>
</html>"));

        equation 
          x = time - 1;
          k1 = 1 + 0.1 * time;
          k2 = 2 + 0.2 * time;
          y = (if x >= 0 then k1 else k2) * Modelica.Fluid.Utilities.regRoot(x, x_small);
          yd = 0 "model does not translate if y=0 is replaced by y=der(y)";
        end TestRegRootDerivative;
        model TestRegRoot2Derivatives "Test whether regRoot2 can be differentiated"
          extends Modelica.Icons.Example;
          parameter Real x_small = 0.01;
          parameter Real k1a = 1;
          parameter Real k1b = 0.2;
          parameter Real k2a = 2;
          parameter Real k2b = 0.2;
          Real x;
          Real y;
          Real yd;
          Real ydd;
          Real k1;
          Real k2;
          Real y2;
          Real y2d;
          Real y2dd;
          annotation(experiment(StopTime = 2, NumberOfIntervals = 5000), experimentSetupOutput);

        equation 
          x = time - 1;
          k1 = k1a + k1b * time;
          k2 = k2a + k2b * time;
          y = Modelica.Fluid.Utilities.regRoot2(x, x_small, k1, k2);
          yd = der(y);
          ydd = der(yd);
          y2 = Modelica.Fluid.Utilities.regRoot2(x, x_small, k1, k2, true, 10);
          y2d = der(y2);
          y2dd = der(y2d);
        end TestRegRoot2Derivatives;
        model TestRegFunctions
          extends Modelica.Icons.Example;
          import Modelica.Fluid.Utilities.*;
          parameter Real delta = 0.01;
          Real x = time + 1e-09;
          Real sqrtx = sqrt(x);
          Real sqrtx_a = regRoot(x, delta);
          Real x2 = x * x;
          Real x2_a = regSquare(x, delta);
          Real x3 = x * x * x;
          Real x3_a = regPow(x, 3, delta);
          Real sqrtxerr = (sqrtx_a - sqrtx) / sqrtx;
          Real x2err = (x2_a - x2) / x2;
          Real x3err = (x3_a - x3) / x3;
        end TestRegFunctions;
      end Utilities;
      package Sources "Test Source models"
        model TestSources "Test model for models in source package"
          import Modelica.Fluid;
          package Medium = Modelica.Media.Air.MoistAir(extraPropertiesNames = {"CO2"});
          Modelica.Fluid.Sources.Boundary_pT boundary(redeclare package Medium = Medium, nPorts = 1, use_C_in = true, use_p_in = true) annotation(Placement(transformation(extent = {{ -50,40},{ -30,60}})));
          Modelica.Fluid.Sources.Boundary_ph boundary1(redeclare package Medium = Medium, nPorts = 1, use_p_in = true, use_X_in = false, use_C_in = true) annotation(Placement(transformation(extent = {{ -50,0},{ -30,20}})));
          Modelica.Fluid.Sources.MassFlowSource_T boundary2(redeclare package Medium = Medium, use_C_in = true, nPorts = 1, m_flow = 0.1) annotation(Placement(transformation(extent = {{ -50, -50},{ -30, -30}})));
          Modelica.Fluid.Sources.MassFlowSource_h boundary3(redeclare package Medium = Medium, use_C_in = true, nPorts = 1, m_flow = 0.1) annotation(Placement(transformation(extent = {{ -50, -90},{ -30, -70}})));
          Modelica.Fluid.Sources.FixedBoundary boundary4(redeclare package Medium = Medium, nPorts = 1) annotation(Placement(transformation(extent = {{80,40},{60,60}})));
          Modelica.Fluid.Sources.Boundary_pT boundary5(redeclare package Medium = Medium, nPorts = 1) annotation(Placement(transformation(extent = {{80,0},{60,20}})));
          Modelica.Fluid.Sources.Boundary_ph boundary6(nPorts = 2, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{96, -70},{76, -50}})));
          Modelica.Fluid.Pipes.StaticPipe pipe(length = 1, diameter = 0.25, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -20,40},{0,60}})));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 2));
          Modelica.Fluid.Pipes.StaticPipe pipe1(length = 1, diameter = 0.25, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{0,0},{20,20}})));
          Modelica.Fluid.Pipes.StaticPipe pipe2(length = 1, diameter = 0.25, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{0, -50},{20, -30}})));
          Modelica.Fluid.Pipes.StaticPipe pipe3(length = 1, diameter = 0.25, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{0, -90},{20, -70}})));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{60,70},{80,90}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp C(duration = 1, height = 0.001519) "substance concentration, raising to 1000 PPM CO2" annotation(Placement(transformation(extent = {{ -100,40},{ -80,60}})));
          Modelica.Blocks.Sources.Ramp P(duration = 2, height =  -100, offset = 101325 + 50) "Pressure" annotation(Placement(transformation(extent = {{ -100,0},{ -80,20}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{0,70},{20,90}})));
          Modelica.Fluid.Sensors.TraceSubstancesTwoPort traceSubstance1(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{22,40},{42,60}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance2(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -22,14},{ -2,34}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance3(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{26, -26},{46, -6}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance4(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -20, -74},{0, -54}})));
          Modelica.Fluid.Fittings.TeeJunctionIdeal junction(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{26, -50},{46, -30}}, rotation = 0)));

        equation 
          connect(boundary.ports[1],pipe.port_a) annotation(Line(points = {{ -30,50},{ -20,50}}, color = {0,127,255}, smooth = Smooth.None));
          connect(boundary1.ports[1],pipe1.port_a) annotation(Line(points = {{ -30,10},{0,10}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe1.port_b,boundary5.ports[1]) annotation(Line(points = {{20,10},{60,10}}, color = {0,127,255}, smooth = Smooth.None));
          connect(boundary2.ports[1],pipe2.port_a) annotation(Line(points = {{ -30, -40},{0, -40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(boundary3.ports[1],pipe3.port_a) annotation(Line(points = {{ -30, -80},{0, -80}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe3.port_b,boundary6.ports[2]) annotation(Line(points = {{20, -80},{46, -80},{46, -62},{76, -62}}, color = {0,127,255}, smooth = Smooth.None));
          connect(C.y,boundary.C_in[1]) annotation(Line(points = {{ -79,50},{ -70,50},{ -70,42},{ -52,42}}, color = {0,0,127}, smooth = Smooth.None));
          connect(P.y,boundary1.p_in) annotation(Line(points = {{ -79,10},{ -72,10},{ -72,18},{ -52,18}}, color = {0,0,127}, smooth = Smooth.None));
          connect(P.y,boundary.p_in) annotation(Line(points = {{ -79,10},{ -72,10},{ -72,58},{ -52,58}}, color = {0,0,127}, smooth = Smooth.None));
          connect(C.y,boundary1.C_in[1]) annotation(Line(points = {{ -79,50},{ -70,50},{ -70,2},{ -52,2}}, color = {0,0,127}, smooth = Smooth.None));
          connect(pipe.port_b,traceSubstance1.port_a) annotation(Line(points = {{0,50},{22,50}}, color = {0,127,255}, smooth = Smooth.None));
          connect(traceSubstance1.port_b,boundary4.ports[1]) annotation(Line(points = {{42,50},{60,50}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe3.port_a,traceSubstance4.port) annotation(Line(points = {{0, -80},{ -6, -80},{ -6, -74},{ -10, -74}}, color = {0,127,255}, smooth = Smooth.None));
          connect(traceSubstance.port,pipe.port_b) annotation(Line(points = {{10,70},{6,70},{6,50},{0,50}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe1.port_a,traceSubstance2.port) annotation(Line(points = {{0,10},{ -6,10},{ -6,14},{ -12,14}}, color = {0,127,255}, smooth = Smooth.None));
          connect(C.y,boundary2.C_in[1]) annotation(Line(points = {{ -79,50},{ -64,50},{ -64, -48},{ -50, -48}}, color = {0,0,127}, smooth = Smooth.None));
          connect(C.y,boundary3.C_in[1]) annotation(Line(points = {{ -79,50},{ -64,50},{ -64, -88},{ -50, -88}}, color = {0,0,127}, smooth = Smooth.None));
          connect(pipe2.port_b,junction.port_1) annotation(Line(points = {{20, -40},{26, -40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(junction.port_3,traceSubstance3.port) annotation(Line(points = {{36, -30},{36, -26}}, color = {0,127,255}, smooth = Smooth.None));
          connect(junction.port_2,boundary6.ports[1]) annotation(Line(points = {{46, -40},{52, -40},{52, -58},{76, -58}}, color = {0,127,255}, smooth = Smooth.None));
        end TestSources;
      end Sources;
      package Sensors "Test Sensor models"
        model TestTraceSubstances
          import Modelica.Fluid;
          replaceable package Medium = Modelica.Media.Air.MoistAir(extraPropertiesNames = {"CO2"});
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 2, Tolerance = 1e-06));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph boundary_prescriberho_1(nPorts = 1, p = system.p_ambient, use_p_in = false, use_h_in = false, use_C_in = true, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -40,10},{ -20,30}}, rotation = 0)));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -10,20},{10,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph boundary_prescriberho_2(nPorts = 1, p = system.p_ambient, use_h_in = false, use_C_in = true, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -40, -30},{ -20, -10}}, rotation = 0)));
          Modelica.Fluid.Sensors.TraceSubstancesTwoPort traceSubstance1(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -10, -30},{10, -10}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp C(duration = 1, height = 0.001519) "substance concentration, raising to 1000 PPM CO2" annotation(Placement(transformation(extent = {{ -80, -10},{ -60,10}})));

        equation 
          connect(boundary_prescriberho_1.ports[1],traceSubstance.port) annotation(Line(points = {{ -20,20},{0,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(boundary_prescriberho_2.ports[1],traceSubstance1.port_a) annotation(Line(points = {{ -20, -20},{ -10, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(C.y,boundary_prescriberho_1.C_in[1]) annotation(Line(points = {{ -59,0},{ -50,0},{ -50,12},{ -42,12}}, color = {0,0,127}, smooth = Smooth.None));
          connect(C.y,boundary_prescriberho_2.C_in[1]) annotation(Line(points = {{ -59,0},{ -50,0},{ -50, -28},{ -42, -28}}, color = {0,0,127}, smooth = Smooth.None));
        end TestTraceSubstances;
        model TestTemperatureSensor "Test and compare case for the difference between using one port with
   and without explicit junction model and two port sensor for fluid temperature meassuring"
          import Modelica.Fluid;
          Modelica.Fluid.Sensors.Temperature Temperature(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -20,40},{0,60}}, rotation = 0)));
          Modelica.Fluid.Sensors.TemperatureTwoPort temperatureTwoPort(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Fluid.Vessels.OpenTank openTankCold2(nPorts = 1, level_start = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, height = 2, crossArea = 2, portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.05)}) annotation(Placement(transformation(extent = {{20,0},{40,20}}, rotation = 0)));
          Modelica.Fluid.Vessels.OpenTank openTankCold1(nPorts = 1, level_start = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, height = 2, crossArea = 2, portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.05)}) annotation(Placement(transformation(extent = {{20,60},{40,80}}, rotation = 0)));
          Modelica.Fluid.Vessels.OpenTank openTankHot1(nPorts = 1, level_start = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, height = 2, crossArea = 2, T_start = SI.Conversions.from_degC(80), portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.05)}) annotation(Placement(transformation(extent = {{60,40},{80,60}}, rotation = 0)));
          Modelica.Fluid.Vessels.OpenTank openTankHot2(nPorts = 1, level_start = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, height = 2, crossArea = 2, T_start = SI.Conversions.from_degC(80), portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.05)}) annotation(Placement(transformation(extent = {{60, -20},{80,0}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_T massFlowRate1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_m_flow_in = true, T = SI.Conversions.from_degC(50)) annotation(Placement(transformation(extent = {{ -60,30},{ -40,50}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_T massFlowRate2(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_m_flow_in = true, T = SI.Conversions.from_degC(50)) annotation(Placement(transformation(extent = {{ -60, -20},{ -40,0}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), Documentation(info = "<html>
<p align = justify>In that test model the behaviour of one port temperature sensors with and without explicit junction models and two port temperature sensor are compared. Therefor each sensor is connected to two tanks with different temperatures and a flow source with changing flow direction.<p>
<p align = justify>With Modelica.Fluid stream connectors, all three sensors show the same expected result.</p>
</html>"));
          Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{ -100,10},{ -80,30}}, rotation = 0)));
          Modelica.Fluid.Sensors.Temperature TemperatureJunction(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -20, -80},{0, -60}}, rotation = 0)));
          Modelica.Fluid.Vessels.OpenTank openTankCold3(nPorts = 1, level_start = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, height = 2, crossArea = 2, portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.05)}) annotation(Placement(transformation(extent = {{20, -60},{40, -40}}, rotation = 0)));
          Modelica.Fluid.Vessels.OpenTank openTankHot3(nPorts = 1, level_start = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, height = 2, crossArea = 2, T_start = SI.Conversions.from_degC(80), portsData = {Modelica.Fluid.Vessels.BaseClasses.VesselPortsData(diameter = 0.05)}) annotation(Placement(transformation(extent = {{60, -80},{80, -60}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_T massFlowRate3(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_m_flow_in = true, T = SI.Conversions.from_degC(50)) annotation(Placement(transformation(extent = {{ -60, -90},{ -40, -70}}, rotation = 0)));
          Modelica.Fluid.Fittings.TeeJunctionIdeal junctionIdeal(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{20, -90},{40, -70}}, rotation = 0)));

        equation 
          connect(massFlowRate2.ports[1],temperatureTwoPort.port_a) annotation(Line(points = {{ -40, -10},{ -20, -10}}, color = {0,127,255}, smooth = Smooth.None));
          connect(massFlowRate1.ports[1],Temperature.port) annotation(Line(points = {{ -40,40},{ -10,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(sine.y,massFlowRate1.m_flow_in) annotation(Line(points = {{ -79,20},{ -70,20},{ -70,48},{ -60,48}}, color = {0,0,127}, smooth = Smooth.None));
          connect(sine.y,massFlowRate2.m_flow_in) annotation(Line(points = {{ -79,20},{ -70,20},{ -70, -2},{ -60, -2}}, color = {0,0,127}, smooth = Smooth.None));
          connect(massFlowRate3.ports[1],TemperatureJunction.port) annotation(Line(points = {{ -40, -80},{ -10, -80}}, color = {0,127,255}, smooth = Smooth.None));
          connect(sine.y,massFlowRate3.m_flow_in) annotation(Line(points = {{ -79,20},{ -70,20},{ -70, -72},{ -60, -72}}, color = {0,0,127}, smooth = Smooth.None));
          connect(TemperatureJunction.port,junctionIdeal.port_1) annotation(Line(points = {{ -10, -80},{20, -80}}, color = {0,127,255}, smooth = Smooth.None));
          connect(temperatureTwoPort.port_b,openTankCold2.ports[1]) annotation(Line(points = {{0, -10},{0, -6},{30, -6},{30,0}}, color = {0,127,255}));
          connect(Temperature.port,openTankCold1.ports[1]) annotation(Line(points = {{ -10,40},{6,40},{6,56},{30,56},{30,60}}, color = {0,127,255}));
          connect(Temperature.port,openTankHot1.ports[1]) annotation(Line(points = {{ -10,40},{30,40},{30,40},{70,40}}, color = {0,127,255}));
          connect(temperatureTwoPort.port_b,openTankHot2.ports[1]) annotation(Line(points = {{0, -10},{34, -10},{34, -20},{70, -20}}, color = {0,127,255}));
          connect(junctionIdeal.port_3,openTankCold3.ports[1]) annotation(Line(points = {{30, -70},{30, -65},{30, -60},{30, -60}}, color = {0,127,255}));
          connect(junctionIdeal.port_2,openTankHot3.ports[1]) annotation(Line(points = {{40, -80},{55.5, -80},{55.5, -80},{70, -80}}, color = {0,127,255}));
        end TestTemperatureSensor;
        model TestSpecificEntropy
          import Modelica.Fluid;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(Tolerance = 1e-06), experimentSetupOutput);
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph boundary_prescriberho_1(nPorts = 1, use_h_in = true, redeclare package Medium = Modelica.Media.Water.StandardWater, p = system.p_ambient) annotation(Placement(transformation(extent = {{ -40,10},{ -20,30}}, rotation = 0)));
          Modelica.Fluid.Sensors.SpecificEntropy specificEntropy(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -10,20},{10,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph boundary_prescriberho_2(nPorts = 1, use_h_in = true, redeclare package Medium = Modelica.Media.Water.StandardWater, p = system.p_ambient) annotation(Placement(transformation(extent = {{ -40, -30},{ -20, -10}}, rotation = 0)));
          Modelica.Fluid.Sensors.SpecificEntropyTwoPort specificEntropy1(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -10, -30},{10, -10}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine1(amplitude = 1600000.0, offset = 1800000.0) annotation(Placement(transformation(extent = {{ -80, -10},{ -60,10}}, rotation = 0)));

        equation 
          connect(boundary_prescriberho_1.ports[1],specificEntropy.port) annotation(Line(points = {{ -20,20},{0,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(sine1.y,boundary_prescriberho_1.h_in) annotation(Line(points = {{ -59,0},{ -52,0},{ -52,24},{ -42,24}}, color = {0,0,127}, smooth = Smooth.None));
          connect(sine1.y,boundary_prescriberho_2.h_in) annotation(Line(points = {{ -59,0},{ -52,0},{ -52, -16},{ -42, -16}}, color = {0,0,127}, smooth = Smooth.None));
          connect(boundary_prescriberho_2.ports[1],specificEntropy1.port_a) annotation(Line(points = {{ -20, -20},{ -10, -20}}, color = {0,127,255}, smooth = Smooth.None));
        end TestSpecificEntropy;
        model TestSpecificEnthalpy
          import Modelica.Fluid;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(Tolerance = 1e-06), experimentSetupOutput);
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph boundary_prescriberho_1(nPorts = 1, use_h_in = true, redeclare package Medium = Modelica.Media.Water.StandardWater, p = system.p_ambient) annotation(Placement(transformation(extent = {{ -40,10},{ -20,30}}, rotation = 0)));
          Modelica.Fluid.Sensors.SpecificEnthalpy specificEnthalpy(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -10,20},{10,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph boundary_prescriberho_2(nPorts = 1, use_h_in = true, redeclare package Medium = Modelica.Media.Water.StandardWater, p = system.p_ambient) annotation(Placement(transformation(extent = {{ -40, -30},{ -20, -10}}, rotation = 0)));
          Modelica.Fluid.Sensors.SpecificEnthalpyTwoPort specificEnthalpy1(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -10, -30},{10, -10}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine1(amplitude = 1600000.0, offset = 1800000.0) annotation(Placement(transformation(extent = {{ -80, -10},{ -60,10}}, rotation = 0)));

        equation 
          connect(boundary_prescriberho_1.ports[1],specificEnthalpy.port) annotation(Line(points = {{ -20,20},{0,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(sine1.y,boundary_prescriberho_1.h_in) annotation(Line(points = {{ -59,0},{ -52,0},{ -52,24},{ -42,24}}, color = {0,0,127}, smooth = Smooth.None));
          connect(sine1.y,boundary_prescriberho_2.h_in) annotation(Line(points = {{ -59,0},{ -52,0},{ -52, -16},{ -42, -16}}, color = {0,0,127}, smooth = Smooth.None));
          connect(boundary_prescriberho_2.ports[1],specificEnthalpy1.port_a) annotation(Line(points = {{ -20, -20},{ -10, -20}}, color = {0,127,255}, smooth = Smooth.None));
        end TestSpecificEnthalpy;
        model TestPressure
          import Modelica.Fluid;
          Modelica.Fluid.Sensors.Pressure pressure1(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -20,0},{0,20}}, rotation = 0)));
          Modelica.Fluid.Fittings.SimpleGenericOrifice simpleGenericOrifice(redeclare package Medium = Modelica.Media.Water.StandardWater, zeta = 2, diameter = 0.1) annotation(Placement(transformation(extent = {{20, -10},{40,10}}, rotation = 0)));
          Modelica.Fluid.Sensors.RelativePressure relativePressure(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{20,34},{40,54}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{ -100,0},{ -80,20}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_T massFlowRate1(nPorts = 1, use_m_flow_in = true, T = SI.Conversions.from_degC(50), redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -60,0},{ -40,20}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(Tolerance = 1e-06), experimentSetupOutput);
          Modelica.Fluid.Sources.Boundary_ph boundary_fixed(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = system.p_ambient, h = 3000000.0) annotation(Placement(transformation(extent = {{100, -10},{80,10}}, rotation = 0)));
          Modelica.Fluid.Sensors.Pressure pressure2(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{50,0},{70,20}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));

        equation 
          connect(sine.y,massFlowRate1.m_flow_in) annotation(Line(points = {{ -79,10},{ -70,10},{ -70,18},{ -60,18}}, color = {0,0,127}, smooth = Smooth.None));
          connect(massFlowRate1.ports[1],pressure1.port) annotation(Line(points = {{ -40,10},{ -26,10},{ -26,0},{ -10,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pressure1.port,simpleGenericOrifice.port_a) annotation(Line(points = {{ -10,0},{20,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(simpleGenericOrifice.port_a,relativePressure.port_a) annotation(Line(points = {{20,0},{20,44},{20,44}}, color = {0,127,255}, smooth = Smooth.None));
          connect(relativePressure.port_b,simpleGenericOrifice.port_b) annotation(Line(points = {{40,44},{40,23},{40,23},{40,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pressure2.port,boundary_fixed.ports[1]) annotation(Line(points = {{60,0},{80,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(simpleGenericOrifice.port_b,pressure2.port) annotation(Line(points = {{40,0},{60,0}}, color = {0,127,255}, smooth = Smooth.None));
        end TestPressure;
        model TestOnePortSensors2
          import Modelica.Fluid;
          package Medium = Modelica.Media.Water.StandardWater;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 15, Algorithm = "Euler"), experimentSetupOutput);
          Modelica.Fluid.Vessels.ClosedVolume MixingVolume1(V = 0.001, use_T_start = false, redeclare package Medium = Medium, h_start = 100000.0, nPorts = 2, use_portsData = false) annotation(Placement(transformation(extent = {{ -34,30},{ -14,50}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_h FlowSource2(nPorts = 1, m_flow = 1, h = 200000.0, redeclare package Medium = Medium, use_m_flow_in = true) annotation(Placement(transformation(extent = {{ -68,30},{ -48,50}}, rotation = 0)));
          Modelica.Fluid.Vessels.ClosedVolume MixingVolume2(V = 0.001, use_T_start = false, redeclare package Medium = Medium, h_start = 150000.0, nPorts = 2, use_portsData = false) annotation(Placement(transformation(extent = {{36,30},{56,50}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph Sink2(nPorts = 1, redeclare package Medium = Medium, p = 101325, h = 50000.0) annotation(Placement(transformation(extent = {{100,30},{80,50}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp ramp(height = 2, offset =  -1, duration = 10) annotation(Placement(transformation(extent = {{ -100,30},{ -80,50}}, rotation = 0)));
          Modelica.Fluid.Vessels.ClosedVolume MixingVolume3(V = 0.001, use_T_start = false, redeclare package Medium = Medium, h_start = 100000.0, nPorts = 2, use_portsData = false) annotation(Placement(transformation(extent = {{ -34, -30},{ -14, -10}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_h FlowSource1(nPorts = 1, m_flow = 1, h = 200000.0, redeclare package Medium = Medium, use_m_flow_in = true) annotation(Placement(transformation(extent = {{ -68, -30},{ -48, -10}}, rotation = 0)));
          Modelica.Fluid.Vessels.ClosedVolume MixingVolume4(V = 0.001, use_T_start = false, redeclare package Medium = Medium, h_start = 150000.0, nPorts = 2, use_portsData = false) annotation(Placement(transformation(extent = {{36, -30},{56, -10}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph Sink1(nPorts = 1, redeclare package Medium = Medium, p = 101325, h = 50000.0) annotation(Placement(transformation(extent = {{100, -30},{80, -10}}, rotation = 0)));
          Modelica.Fluid.Sensors.TemperatureTwoPort Tmix2(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{0, -30},{20, -10}}, rotation = 0)));

        equation 
          connect(ramp.y,FlowSource2.m_flow_in) annotation(Line(points = {{ -79,40},{ -74,40},{ -74,48},{ -68,48}}, color = {0,0,127}, smooth = Smooth.None));
          connect(ramp.y,FlowSource1.m_flow_in) annotation(Line(points = {{ -79,40},{ -76,40},{ -76, -12},{ -68, -12}}, color = {0,0,127}, smooth = Smooth.None));
          connect(FlowSource2.ports[1],MixingVolume1.ports[1]) annotation(Line(points = {{ -48,40},{ -36,40},{ -36,30},{ -26,30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(MixingVolume1.ports[2],MixingVolume2.ports[2]) annotation(Line(points = {{ -22,30},{ -5,30},{ -5,32},{12,32},{12,30},{48,30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(MixingVolume2.ports[1],Sink2.ports[1]) annotation(Line(points = {{44,30},{61,30},{61,40},{80,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(FlowSource1.ports[1],MixingVolume3.ports[1]) annotation(Line(points = {{ -48, -20},{ -36, -20},{ -36, -30},{ -26, -30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(MixingVolume3.ports[2],Tmix2.port_a) annotation(Line(points = {{ -22, -30},{ -12, -30},{ -12, -20},{0, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(Tmix2.port_b,MixingVolume4.ports[2]) annotation(Line(points = {{20, -20},{32, -20},{32, -30},{48, -30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(MixingVolume4.ports[1],Sink1.ports[1]) annotation(Line(points = {{44, -30},{61, -30},{61, -20},{80, -20}}, color = {0,127,255}, smooth = Smooth.None));
        end TestOnePortSensors2;
        model TestOnePortSensors1
          import Modelica.Fluid;
          package Medium = Modelica.Media.Water.StandardWater;
          parameter Real diameter_a = 0.1;
          parameter Real diameter_b = 0.2;
          parameter Real A_rel = (diameter_a / diameter_b) ^ 2;
          parameter Real zeta = (1 - A_rel) ^ 2;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 25, Algorithm = "Dassl"), experimentSetupOutput);
          Modelica.Fluid.Vessels.ClosedVolume volume1(V = 0.001, use_T_start = false, redeclare package Medium = Medium, h_start = 100000.0, nPorts = 2, energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, massDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, use_portsData = false, p_start = 101325) annotation(Placement(transformation(extent = {{ -30,30},{ -10,50}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_h FlowSource2(nPorts = 1, m_flow = 1, h = 200000.0, redeclare package Medium = Medium, use_m_flow_in = true) annotation(Placement(transformation(extent = {{ -68,30},{ -48,50}}, rotation = 0)));
          Modelica.Fluid.Sensors.Temperature Tmix1(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{0,60},{20,80}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph sink1(nPorts = 1, redeclare package Medium = Medium, h = 50000.0, p = 101325) annotation(Placement(transformation(extent = {{100,30},{80,50}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp ramp(height = 2, duration = 20, offset =  -1) annotation(Placement(transformation(extent = {{ -100,30},{ -80,50}}, rotation = 0)));
          Modelica.Fluid.Vessels.ClosedVolume volume2(V = 0.001, use_T_start = false, redeclare package Medium = Medium, h_start = 100000.0, nPorts = 2, energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, massDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, use_portsData = false, p_start = 101325) annotation(Placement(transformation(extent = {{ -32, -30},{ -12, -10}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_h FlowSource1(nPorts = 1, m_flow = 1, h = 200000.0, redeclare package Medium = Medium, use_m_flow_in = true) annotation(Placement(transformation(extent = {{ -68, -30},{ -48, -10}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph sink2(nPorts = 1, redeclare package Medium = Medium, h = 50000.0, p = 101325) annotation(Placement(transformation(extent = {{100, -30},{80, -10}}, rotation = 0)));
          Modelica.Fluid.Sensors.TemperatureTwoPort Tmix2(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{0, -30},{20, -10}}, rotation = 0)));
          Modelica.Fluid.Fittings.SimpleGenericOrifice orifice1(redeclare package Medium = Medium, diameter = diameter_a, zeta = zeta) annotation(Placement(transformation(extent = {{40,30},{60,50}}, rotation = 0)));
          Modelica.Fluid.Fittings.SimpleGenericOrifice orifice2(redeclare package Medium = Medium, zeta = zeta, diameter = diameter_a) annotation(Placement(transformation(extent = {{40, -30},{60, -10}}, rotation = 0)));

        equation 
          connect(ramp.y,FlowSource2.m_flow_in) annotation(Line(points = {{ -79,40},{ -74,40},{ -74,48},{ -68,48}}, color = {0,0,127}, smooth = Smooth.None));
          connect(ramp.y,FlowSource1.m_flow_in) annotation(Line(points = {{ -79,40},{ -76,40},{ -76, -12},{ -68, -12}}, color = {0,0,127}, smooth = Smooth.None));
          connect(orifice1.port_b,sink1.ports[1]) annotation(Line(points = {{60,40},{80,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(orifice2.port_a,Tmix2.port_b) annotation(Line(points = {{40, -20},{20, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(orifice2.port_b,sink2.ports[1]) annotation(Line(points = {{60, -20},{80, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(Tmix1.port,orifice1.port_a) annotation(Line(points = {{10,60},{10,40},{40,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(FlowSource2.ports[1],volume1.ports[1]) annotation(Line(points = {{ -48,40},{ -34,40},{ -34,30},{ -22,30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(volume1.ports[2],orifice1.port_a) annotation(Line(points = {{ -18,30},{10,30},{10,40},{40,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(FlowSource1.ports[1],volume2.ports[1]) annotation(Line(points = {{ -48, -20},{ -35, -20},{ -35, -30},{ -24, -30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(volume2.ports[2],Tmix2.port_a) annotation(Line(points = {{ -20, -30},{ -11, -30},{ -11, -20},{0, -20}}, color = {0,127,255}, smooth = Smooth.None));
        end TestOnePortSensors1;
        model TestFlowRate
          import Modelica.Fluid;
          Modelica.Fluid.Fittings.SimpleGenericOrifice simpleGenericOrifice(redeclare package Medium = Modelica.Media.Water.StandardWater, zeta = 2, diameter = 0.1) annotation(Placement(transformation(extent = {{ -20, -10},{0,10}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{ -100,0},{ -80,20}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_T massFlowRate1(nPorts = 1, use_m_flow_in = true, T = SI.Conversions.from_degC(50), redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -60,0},{ -40,20}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(Tolerance = 1e-06), experimentSetupOutput);
          Modelica.Fluid.Sources.Boundary_ph boundary_fixed(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = system.p_ambient, h = 3000000.0) annotation(Placement(transformation(extent = {{100, -10},{80,10}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Fluid.Sensors.MassFlowRate massFlowRate(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{10, -10},{30,10}}, rotation = 0)));
          Modelica.Fluid.Sensors.VolumeFlowRate volumeFlowRate(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{50, -10},{70,10}}, rotation = 0)));

        equation 
          connect(sine.y,massFlowRate1.m_flow_in) annotation(Line(points = {{ -79,10},{ -70,10},{ -70,18},{ -60,18}}, color = {0,0,127}, smooth = Smooth.None));
          connect(massFlowRate1.ports[1],simpleGenericOrifice.port_a) annotation(Line(points = {{ -40,10},{ -32,10},{ -32,0},{ -20,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(volumeFlowRate.port_b,boundary_fixed.ports[1]) annotation(Line(points = {{70,0},{80,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(massFlowRate.port_b,volumeFlowRate.port_a) annotation(Line(points = {{30,0},{50,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(simpleGenericOrifice.port_b,massFlowRate.port_a) annotation(Line(points = {{0,0},{10,0}}, color = {0,127,255}, smooth = Smooth.None));
        end TestFlowRate;
        model TestDensity
          import Modelica.Fluid;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(Tolerance = 1e-06), experimentSetupOutput);
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
          Modelica.Fluid.Sensors.DensityTwoPort density2_1(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -20, -30},{0, -10}}, rotation = 0)));
          Modelica.Fluid.Fittings.SimpleGenericOrifice simpleGenericOrifice1(redeclare package Medium = Modelica.Media.Water.StandardWater, zeta = 2, diameter = 0.1) annotation(Placement(transformation(extent = {{20, -30},{40, -10}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine1 annotation(Placement(transformation(extent = {{ -100, -20},{ -80,0}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_h massFlowRate2(nPorts = 1, use_m_flow_in = true, redeclare package Medium = Modelica.Media.Water.StandardWater, h = 3200000.0) annotation(Placement(transformation(extent = {{ -60, -20},{ -40,0}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph boundary_fixed1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = system.p_ambient, h = 3000000.0) annotation(Placement(transformation(extent = {{100, -30},{80, -10}}, rotation = 0)));
          Modelica.Fluid.Sensors.DensityTwoPort density2_2(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{50, -30},{70, -10}}, rotation = 0)));
          Modelica.Fluid.Sensors.Density density1_1(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{ -20,50},{0,70}}, rotation = 0)));
          Modelica.Fluid.Fittings.SimpleGenericOrifice simpleGenericOrifice(redeclare package Medium = Modelica.Media.Water.StandardWater, zeta = 2, diameter = 0.1) annotation(Placement(transformation(extent = {{20,40},{40,60}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{ -100,50},{ -80,70}}, rotation = 0)));
          Modelica.Fluid.Sources.MassFlowSource_h massFlowRate1(nPorts = 1, use_m_flow_in = true, redeclare package Medium = Modelica.Media.Water.StandardWater, h = 3200000.0) annotation(Placement(transformation(extent = {{ -60,50},{ -40,70}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_ph boundary_fixed(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = system.p_ambient, h = 3000000.0) annotation(Placement(transformation(extent = {{100,40},{80,60}}, rotation = 0)));
          Modelica.Fluid.Sensors.Density density1_2(redeclare package Medium = Modelica.Media.Water.StandardWater) annotation(Placement(transformation(extent = {{50,50},{70,70}}, rotation = 0)));

        equation 
          connect(sine1.y,massFlowRate2.m_flow_in) annotation(Line(points = {{ -79, -10},{ -70, -10},{ -70, -2},{ -60, -2}}, color = {0,0,127}, smooth = Smooth.None));
          connect(massFlowRate2.ports[1],density2_1.port_a) annotation(Line(points = {{ -40, -10},{ -30, -10},{ -30, -20},{ -20, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(density2_1.port_b,simpleGenericOrifice1.port_a) annotation(Line(points = {{0, -20},{20, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(simpleGenericOrifice1.port_b,density2_2.port_a) annotation(Line(points = {{40, -20},{50, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(density2_2.port_b,boundary_fixed1.ports[1]) annotation(Line(points = {{70, -20},{80, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(sine.y,massFlowRate1.m_flow_in) annotation(Line(points = {{ -79,60},{ -70,60},{ -70,68},{ -60,68}}, color = {0,0,127}, smooth = Smooth.None));
          connect(massFlowRate1.ports[1],density1_1.port) annotation(Line(points = {{ -40,60},{ -26,60},{ -26,50},{ -10,50}}, color = {0,127,255}, smooth = Smooth.None));
          connect(density1_1.port,simpleGenericOrifice.port_a) annotation(Line(points = {{ -10,50},{20,50}}, color = {0,127,255}, smooth = Smooth.None));
          connect(density1_2.port,boundary_fixed.ports[1]) annotation(Line(points = {{60,50},{80,50}}, color = {0,127,255}, smooth = Smooth.None));
          connect(simpleGenericOrifice.port_b,density1_2.port) annotation(Line(points = {{40,50},{60,50}}, color = {0,127,255}, smooth = Smooth.None));
        end TestDensity;
      end Sensors;
      package Pipes "Test Pipe models"
        model StaticPipe
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          replaceable package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater;
          Modelica.Fluid.Pipes.StaticPipe pipe1(redeclare package Medium = Medium, length = 10, diameter = 0.0254, p_a_start = 500000, p_b_start = 100000) annotation(Placement(transformation(extent = {{ -10,0},{10,20}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10, NumberOfIntervals = 10000), Documentation(info = "<html>
Test of the StaticPipe model.
</html>"));
          Modelica.Fluid.Sources.Boundary_pT sink(nPorts = 1, redeclare package Medium = Medium, p = 200000, T = 300) annotation(Placement(transformation(extent = {{56,4},{44,16}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
          Modelica.Blocks.Sources.TimeTable p_table(table = [0,100000.0;10,300000.0]) annotation(Placement(transformation(extent = {{ -90,20},{ -70,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT source(redeclare package Medium = Medium, p = system.p_ambient, T = system.T_ambient, use_p_in = true, nPorts = 1) annotation(Placement(transformation(extent = {{ -56,4},{ -44,16}}, rotation = 0)));

        equation 
          connect(pipe1.port_b,sink.ports[1]) annotation(Line(points = {{10,10},{44,10}}, color = {0,127,255}, smooth = Smooth.None));
          connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -44,10},{ -10,10}}, color = {0,127,255}, smooth = Smooth.None));
          connect(p_table.y,source.p_in) annotation(Line(points = {{ -69,30},{ -62,30},{ -62,14.8},{ -57.2,14.8}}, color = {0,0,127}, smooth = Smooth.None));
        end StaticPipe;
        model DynamicPipeWithNominalLaminarFlow "Test NominalLaminarFlow model subject to varying nNodes and nParallel"
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics));
          Modelica.Fluid.Pipes.DynamicPipe pipeN10(nParallel = 1, length = 100, redeclare package Medium = Modelica.Media.Water.StandardWater, use_T_start = false, h_start = 3000000.0, m_flow_start = 1, diameter = 0.3, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.NominalLaminarFlow(dp_nominal = 100000, m_flow_nominal = 1), nNodes = 10, p_a_start = 200000, p_b_start = 100000) annotation(Placement(transformation(extent = {{ -10,30},{10,50}})));
          inner Modelica.Fluid.System system(energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, massDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, momentumDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial) annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}})));
          Modelica.Fluid.Sources.MassFlowSource_h boundary(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow = 1, h = 3000000.0) annotation(Placement(transformation(extent = {{ -70,30},{ -50,50}})));
          Modelica.Fluid.Sources.FixedBoundary boundary1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 100000) annotation(Placement(transformation(extent = {{70,30},{50,50}})));
          Modelica.Fluid.Pipes.DynamicPipe pipeN20(nParallel = 1, length = 100, redeclare package Medium = Modelica.Media.Water.StandardWater, use_T_start = false, h_start = 3000000.0, m_flow_start = 1, diameter = 0.3, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.NominalLaminarFlow(dp_nominal = 100000, m_flow_nominal = 1), p_a_start = 200000, p_b_start = 100000, nNodes = 20) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}})));
          Modelica.Fluid.Sources.MassFlowSource_h boundary2(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow = 1, h = 3000000.0) annotation(Placement(transformation(extent = {{ -70, -10},{ -50,10}})));
          Modelica.Fluid.Sources.FixedBoundary boundary3(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 100000) annotation(Placement(transformation(extent = {{70, -10},{50,10}})));
          Modelica.Fluid.Pipes.DynamicPipe pipeN10nParallel10(length = 100, redeclare package Medium = Modelica.Media.Water.StandardWater, use_T_start = false, h_start = 3000000.0, m_flow_start = 1, diameter = 0.3, nNodes = 10, nParallel = 10, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.NominalLaminarFlow(dp_nominal = 100000, m_flow_nominal = 10), p_a_start = 200000, p_b_start = 100000) annotation(Placement(transformation(extent = {{ -10, -50},{10, -30}})));
          Modelica.Fluid.Sources.MassFlowSource_h boundary4(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, h = 3000000.0, m_flow = 10) annotation(Placement(transformation(extent = {{ -70, -50},{ -50, -30}})));
          Modelica.Fluid.Sources.FixedBoundary boundary5(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 100000) annotation(Placement(transformation(extent = {{70, -50},{50, -30}})));

        equation 
          assert(abs(pipeN10.port_a.p - pipeN20.port_a.p) < 1, "!!!Incorrect pressure for modified nNodes!!!");
          assert(abs(pipeN10.port_a.p - pipeN10nParallel10.port_a.p) < 1, "!!!Incorrect pressure for nParallel>1!!!");
          connect(boundary.ports[1],pipeN10.port_a) annotation(Line(points = {{ -50,40},{ -10,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipeN10.port_b,boundary1.ports[1]) annotation(Line(points = {{10,40},{50,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(boundary2.ports[1],pipeN20.port_a) annotation(Line(points = {{ -50,0},{ -10,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipeN20.port_b,boundary3.ports[1]) annotation(Line(points = {{10,0},{50,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(boundary4.ports[1],pipeN10nParallel10.port_a) annotation(Line(points = {{ -50, -40},{ -10, -40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipeN10nParallel10.port_b,boundary5.ports[1]) annotation(Line(points = {{10, -40},{50, -40}}, color = {0,127,255}, smooth = Smooth.None));
        end DynamicPipeWithNominalLaminarFlow;
        model DynamicPipesWithTraceSubstances
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          replaceable package Medium = Modelica.Media.Air.DryAirNasa(extraPropertiesNames = {"CO2","VOC"});
          Modelica.Fluid.Pipes.DynamicPipe pipe2(redeclare package Medium = Medium, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, length = 2, modelStructure = Modelica.Fluid.Types.ModelStructure.a_v_b, use_HeatTransfer = true, redeclare model HeatTransfer = Modelica.Fluid.Pipes.BaseClasses.HeatTransfer.ConstantFlowHeatTransfer(alpha0 = 500), p_a_start = 100000, p_b_start = 100000, T_start = 280) annotation(Placement(transformation(extent = {{ -30,68},{ -10,88}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 20, Tolerance = 1e-05), experimentSetupOutput, Documentation(info = "<html>
Test of different dynamic pipe models with trace substances.
</html>"));
          Modelica.Fluid.Sources.Boundary_pT boundary2(nPorts = 1, redeclare package Medium = Medium, use_p_in = true, use_T_in = false, p = 100000, T = 300, C = {0.0015,5e-05}) annotation(Placement(transformation(extent = {{70,54},{50,74}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe3(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000, T_start = 340, modelStructure = Modelica.Fluid.Types.ModelStructure.a_v_b, p_a_start = 100000) annotation(Placement(transformation(extent = {{20,54},{40,74}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe1(redeclare package Medium = Medium, use_T_start = true, T_start = 300, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000.0, length = 0.4, modelStructure = Modelica.Fluid.Types.ModelStructure.a_v_b, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -82,54},{ -62,74}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT boundary1(nPorts = 1, T = 280, redeclare package Medium = Medium, p = 150000.0) annotation(Placement(transformation(extent = {{ -108,54},{ -88,74}}, rotation = 0)));
          annotation(extent = [ -90, -86; -70, -66]);
          annotation(points = [ -22,42; -2,42; -2,32;7.8,32], style(color = 69, rgbcolor = {0,127,255}));
          Modelica.Blocks.Sources.Ramp ramp(offset = 100000.0, startTime = 5, duration = 0, height = 100000.0) annotation(Placement(transformation(extent = {{90,64},{78,76}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe4(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000, T_start = 360, modelStructure = Modelica.Fluid.Types.ModelStructure.a_v_b, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -30,38},{ -10,58}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{72, -94},{92, -74}}, rotation = 0)));
          Modelica.Fluid.Fittings.TeeJunctionVolume junction1(redeclare package Medium = Medium, V = 0.0001, p_start = 100000, T_start = 300) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}}, rotation = 90, origin = { -42,64})));
          Modelica.Fluid.Fittings.TeeJunctionVolume junction2(redeclare package Medium = Medium, V = 1e-05, p_start = 100000, T_start = 300) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}}, rotation =  -90, origin = {2,64})));
          Modelica.Thermal.HeatTransfer.Sources.FixedHeatFlow[pipe2.n] heat(each Q_flow = 200, each alpha = 10000, each T_ref = 350) annotation(Placement(transformation(extent = {{ -54,80},{ -34,100}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe5(redeclare package Medium = Medium, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, length = 2, use_HeatTransfer = true, p_a_start = 100000, p_b_start = 100000, T_start = 280, redeclare model HeatTransfer = Modelica.Fluid.Pipes.BaseClasses.HeatTransfer.ConstantFlowHeatTransfer(alpha0 = 500)) annotation(Placement(transformation(extent = {{ -30,10},{ -10,30}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT boundary4(nPorts = 1, redeclare package Medium = Medium, use_p_in = true, use_T_in = false, p = 100000, T = 300, C = {0.0015,5e-05}) annotation(Placement(transformation(extent = {{68, -2},{48,18}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe6(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000, T_start = 340, modelStructure = Modelica.Fluid.Types.ModelStructure.av_b, p_a_start = 100000) annotation(Placement(transformation(extent = {{14, -2},{34,18}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe7(redeclare package Medium = Medium, use_T_start = true, T_start = 300, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000.0, length = 0.4, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -74, -2},{ -54,18}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT boundary3(nPorts = 1, redeclare package Medium = Medium, p = 150000, T = 280) annotation(Placement(transformation(extent = {{ -108, -2},{ -88,18}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp ramp1(offset = 100000.0, startTime = 5, duration = 0, height = 100000.0) annotation(Placement(transformation(extent = {{96,8},{84,20}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe8(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, T_start = 360, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000.0, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -30, -12},{ -10,8}}, rotation = 0)));
          Modelica.Thermal.HeatTransfer.Sources.FixedHeatFlow[pipe2.n] heat1(each Q_flow = 200, each alpha = 10000, each T_ref = 350) annotation(Placement(transformation(extent = {{ -72,22},{ -52,42}}, rotation = 0)));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance3(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -98,22},{ -78,42}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance1(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -90,80},{ -70,100}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance2(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{32,80},{52,100}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance4(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{2,22},{22,42}})));
          Modelica.Fluid.Fittings.MultiPort multiPort(redeclare package Medium = Medium, nPorts_b = 2) annotation(Placement(transformation(extent = {{ -46, -2},{ -38,18}})));

        equation 
          connect(boundary1.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,64},{ -82,64}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe3.port_b,boundary2.ports[1]) annotation(Line(points = {{40,64},{50,64}}, color = {0,127,255}, thickness = 0.5));
          connect(heat.port,pipe2.heatPorts) annotation(Line(points = {{ -34,90},{ -19.9,90},{ -19.9,83.2}}, color = {191,0,0}, thickness = 0.5));
          connect(ramp1.y,boundary4.p_in) annotation(Line(points = {{83.4,14},{76.7,14},{76.7,16},{70,16}}, color = {0,0,127}, thickness = 0.5));
          connect(boundary3.ports[1],pipe7.port_a) annotation(Line(points = {{ -88,8},{ -74,8}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe5.port_b,pipe6.port_a) annotation(Line(points = {{ -10,20},{2,20},{2,8},{14,8}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe8.port_b,pipe6.port_a) annotation(Line(points = {{ -10, -2},{2, -2},{2,8},{14,8}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe6.port_b,boundary4.ports[1]) annotation(Line(points = {{34,8},{48,8}}, color = {0,127,255}, thickness = 0.5));
          connect(heat1.port,pipe5.heatPorts) annotation(Line(points = {{ -52,32},{ -19.9,32},{ -19.9,25.2}}, color = {191,0,0}, thickness = 0.5));
          connect(boundary2.p_in,ramp.y) annotation(Line(points = {{72,72},{74.7,72},{74.7,70},{77.4,70}}, color = {0,0,127}, thickness = 0.5));
          connect(junction2.port_3,pipe3.port_a) annotation(Line(points = {{12,64},{20,64}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(pipe2.port_b,junction2.port_1) annotation(Line(points = {{ -10,78},{2,78},{2,74}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(pipe4.port_b,junction2.port_2) annotation(Line(points = {{ -10,48},{2,48},{2,54}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(pipe1.port_b,junction1.port_3) annotation(Line(points = {{ -62,64},{ -52,64}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(junction1.port_1,pipe4.port_a) annotation(Line(points = {{ -42,54},{ -42,48},{ -30,48}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(junction1.port_2,pipe2.port_a) annotation(Line(points = {{ -42,74},{ -42,78},{ -30,78}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(traceSubstance1.port,pipe1.port_b) annotation(Line(points = {{ -80,80},{ -60,80},{ -60,64},{ -62,64}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe7.port_a,traceSubstance3.port) annotation(Line(points = {{ -74,8},{ -80,8},{ -80,22},{ -88,22}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe3.port_b,traceSubstance2.port) annotation(Line(points = {{40,64},{42,64},{42,80}}, color = {0,127,255}, smooth = Smooth.None));
          connect(traceSubstance4.port,pipe6.port_a) annotation(Line(points = {{12,22},{12,8},{14,8}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe7.port_b,multiPort.port_a) annotation(Line(points = {{ -54,8},{ -46,8}}, color = {0,127,255}, smooth = Smooth.None));
          connect(multiPort.ports_b[1],pipe5.port_a) annotation(Line(points = {{ -38,10},{ -32,10},{ -32,20},{ -30,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(multiPort.ports_b[2],pipe8.port_a) annotation(Line(points = {{ -38,6},{ -38,8},{ -32,8},{ -32, -2},{ -30, -2}}, color = {0,127,255}, smooth = Smooth.None));
        end DynamicPipesWithTraceSubstances;
        model DynamicPipesAndFittings
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          replaceable package Medium = Modelica.Media.Water.StandardWater;
          Modelica.Fluid.Pipes.DynamicPipe pipe2(redeclare package Medium = Medium, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, length = 2, redeclare model HeatTransfer = Modelica.Fluid.Pipes.BaseClasses.HeatTransfer.ConstantFlowHeatTransfer(alpha0 = 500), modelStructure = Modelica.Fluid.Types.ModelStructure.a_v_b, use_HeatTransfer = true, p_a_start = 100000, p_b_start = 100000, T_start = 280) annotation(Placement(transformation(extent = {{ -30,68},{ -10,88}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 20, Tolerance = 1e-05), experimentSetupOutput, Documentation(info = "<html>
Test of different dynamic pipe models. The first system uses explicit junctions, in the third system some of the pipe models are replaced by non-symmetric components.
</html>"));
          Modelica.Fluid.Sources.Boundary_pT boundary2(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = 300, use_p_in = true, use_T_in = false) annotation(Placement(transformation(extent = {{70,54},{50,74}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe3(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000, T_start = 340, modelStructure = Modelica.Fluid.Types.ModelStructure.a_v_b, p_a_start = 100000) annotation(Placement(transformation(extent = {{20,54},{40,74}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe1(redeclare package Medium = Medium, use_T_start = true, T_start = 300, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000.0, length = 0.4, modelStructure = Modelica.Fluid.Types.ModelStructure.a_v_b, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -82,54},{ -62,74}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT boundary1(nPorts = 1, T = 280, redeclare package Medium = Medium, p = 150000.0) annotation(Placement(transformation(extent = {{ -108,54},{ -88,74}}, rotation = 0)));
          annotation(extent = [ -90, -86; -70, -66]);
          annotation(points = [ -22,42; -2,42; -2,32;7.8,32], style(color = 69, rgbcolor = {0,127,255}));
          Modelica.Blocks.Sources.Ramp ramp(offset = 100000.0, startTime = 5, duration = 0, height = 100000.0) annotation(Placement(transformation(extent = {{90,64},{78,76}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe4(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000, T_start = 360, modelStructure = Modelica.Fluid.Types.ModelStructure.a_v_b, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -30,38},{ -10,58}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{72, -94},{92, -74}}, rotation = 0)));
          Modelica.Fluid.Fittings.TeeJunctionVolume junction1(redeclare package Medium = Medium, V = 0.0001, p_start = 100000, T_start = 300) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}}, rotation = 90, origin = { -42,64})));
          Modelica.Fluid.Fittings.TeeJunctionVolume junction2(redeclare package Medium = Medium, V = 1e-05, p_start = 100000, T_start = 300) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}}, rotation =  -90, origin = {2,64})));
          Modelica.Thermal.HeatTransfer.Sources.FixedHeatFlow[pipe2.n] heat(each Q_flow = 200, each alpha = 10000, each T_ref = 350) annotation(Placement(transformation(extent = {{ -54,80},{ -34,100}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe5(redeclare package Medium = Medium, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, length = 2, redeclare model HeatTransfer = Modelica.Fluid.Pipes.BaseClasses.HeatTransfer.LocalPipeFlowHeatTransfer, use_HeatTransfer = true, p_a_start = 100000, p_b_start = 100000, T_start = 280) annotation(Placement(transformation(extent = {{ -30,10},{ -10,30}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT boundary4(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = 300, use_p_in = true, use_T_in = false) annotation(Placement(transformation(extent = {{68, -2},{48,18}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe6(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000, T_start = 340, modelStructure = Modelica.Fluid.Types.ModelStructure.av_b, p_a_start = 100000) annotation(Placement(transformation(extent = {{14, -2},{34,18}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe7(redeclare package Medium = Medium, use_T_start = true, T_start = 300, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000.0, length = 0.4, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -74, -2},{ -54,18}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT boundary3(nPorts = 1, redeclare package Medium = Medium, p = 150000, T = 280) annotation(Placement(transformation(extent = {{ -108, -2},{ -88,18}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp ramp1(offset = 100000.0, startTime = 5, duration = 0, height = 100000.0) annotation(Placement(transformation(extent = {{96,8},{84,20}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe8(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, T_start = 360, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000.0, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -30, -12},{ -10,8}}, rotation = 0)));
          Modelica.Thermal.HeatTransfer.Sources.FixedHeatFlow[pipe2.n] heat1(each Q_flow = 200, each alpha = 10000, each T_ref = 350) annotation(Placement(transformation(extent = {{ -72,22},{ -52,42}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe9(redeclare package Medium = Medium, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, length = 2, redeclare model HeatTransfer = Modelica.Fluid.Pipes.BaseClasses.HeatTransfer.ConstantFlowHeatTransfer(alpha0 = 500), use_HeatTransfer = true, p_a_start = 100000, p_b_start = 100000, T_start = 280) annotation(Placement(transformation(extent = {{ -29, -50},{ -9, -30}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT boundary5(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = 300, use_p_in = true, use_T_in = false) annotation(Placement(transformation(extent = {{70, -62},{50, -42}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe10(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, nNodes = 5, modelStructure = Modelica.Fluid.Types.ModelStructure.av_b, m_flow_start = 0.1, p_b_start = 100000, T_start = 340, p_a_start = 100000) annotation(Placement(transformation(extent = {{14, -62},{34, -42}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe11(redeclare package Medium = Medium, use_T_start = true, diameter = 0.01, nNodes = 5, modelStructure = Modelica.Fluid.Types.ModelStructure.a_vb, m_flow_start = 0.1, length = 0.4, p_b_start = 100000, T_start = 300, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -74, -62},{ -54, -42}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT boundary6(nPorts = 1, redeclare package Medium = Medium, p = 150000, T = 280) annotation(Placement(transformation(extent = {{ -110, -62},{ -90, -42}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp ramp2(offset = 100000.0, startTime = 5, duration = 0, height = 100000.0) annotation(Placement(transformation(extent = {{96, -52},{84, -40}}, rotation = 0)));
          Modelica.Fluid.Pipes.DynamicPipe pipe12(redeclare package Medium = Medium, length = 1, use_T_start = true, diameter = 0.01, nNodes = 5, m_flow_start = 0.1, p_b_start = 100000, T_start = 360, p_a_start = 100000) annotation(Placement(transformation(extent = {{ -29, -72},{ -9, -52}}, rotation = 0)));
          Modelica.Thermal.HeatTransfer.Sources.FixedHeatFlow[pipe2.n] heat2(each Q_flow = 200, each alpha = 10000, each T_ref = 350) annotation(Placement(transformation(extent = {{ -72, -38},{ -52, -18}}, rotation = 0)));
          Modelica.Fluid.Fittings.MultiPort muliPort11(nPorts_b = 2, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -50, -62},{ -42, -42}})));
          Modelica.Fluid.Fittings.MultiPort multiPort10(nPorts_b = 2, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{10, -62},{2, -42}})));

        equation 
          connect(boundary1.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,64},{ -82,64}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe3.port_b,boundary2.ports[1]) annotation(Line(points = {{40,64},{50,64}}, color = {0,127,255}, thickness = 0.5));
          connect(heat.port,pipe2.heatPorts) annotation(Line(points = {{ -34,90},{ -19.9,90},{ -19.9,83.2}}, color = {191,0,0}, thickness = 0.5));
          connect(ramp1.y,boundary4.p_in) annotation(Line(points = {{83.4,14},{76.7,14},{76.7,16},{70,16}}, color = {0,0,127}, thickness = 0.5));
          connect(boundary3.ports[1],pipe7.port_a) annotation(Line(points = {{ -88,8},{ -74,8}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe7.port_b,pipe5.port_a) annotation(Line(points = {{ -54,8},{ -42,8},{ -42,20},{ -30,20}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe7.port_b,pipe8.port_a) annotation(Line(points = {{ -54,8},{ -42,8},{ -42, -2},{ -30, -2}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe5.port_b,pipe6.port_a) annotation(Line(points = {{ -10,20},{2,20},{2,8},{14,8}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe8.port_b,pipe6.port_a) annotation(Line(points = {{ -10, -2},{2, -2},{2,8},{14,8}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe6.port_b,boundary4.ports[1]) annotation(Line(points = {{34,8},{48,8}}, color = {0,127,255}, thickness = 0.5));
          connect(heat1.port,pipe5.heatPorts) annotation(Line(points = {{ -52,32},{ -19.9,32},{ -19.9,25.2}}, color = {191,0,0}, thickness = 0.5));
          connect(boundary2.p_in,ramp.y) annotation(Line(points = {{72,72},{74.7,72},{74.7,70},{77.4,70}}, color = {0,0,127}, thickness = 0.5));
          connect(ramp2.y,boundary5.p_in) annotation(Line(points = {{83.4, -46},{77.7, -46},{77.7, -44},{72, -44}}, color = {0,0,127}, thickness = 0.5));
          connect(boundary6.ports[1],pipe11.port_a) annotation(Line(points = {{ -90, -52},{ -74, -52}}, color = {0,127,255}, thickness = 0.5));
          connect(pipe10.port_b,boundary5.ports[1]) annotation(Line(points = {{34, -52},{50, -52}}, color = {0,127,255}, thickness = 0.5));
          connect(heat2.port,pipe9.heatPorts) annotation(Line(points = {{ -52, -28},{ -18.9, -28},{ -18.9, -34.8}}, color = {191,0,0}, thickness = 0.5));
          connect(pipe11.port_b,muliPort11.port_a) annotation(Line(points = {{ -54, -52},{ -50, -52}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(muliPort11.ports_b[2],pipe12.port_a) annotation(Line(points = {{ -42, -54},{ -40, -54},{ -40, -62},{ -29, -62}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(muliPort11.ports_b[1],pipe9.port_a) annotation(Line(points = {{ -42, -50},{ -40, -50},{ -40, -40},{ -29, -40}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(multiPort10.port_a,pipe10.port_a) annotation(Line(points = {{10, -52},{14, -52}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(pipe9.port_b,multiPort10.ports_b[1]) annotation(Line(points = {{ -9, -40},{0, -40},{0, -50},{2, -50}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(pipe12.port_b,multiPort10.ports_b[2]) annotation(Line(points = {{ -9, -62},{0, -62},{0, -54},{2, -54}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(junction2.port_3,pipe3.port_a) annotation(Line(points = {{12,64},{20,64}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(pipe2.port_b,junction2.port_1) annotation(Line(points = {{ -10,78},{2,78},{2,74}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(pipe4.port_b,junction2.port_2) annotation(Line(points = {{ -10,48},{2,48},{2,54}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(pipe1.port_b,junction1.port_3) annotation(Line(points = {{ -62,64},{ -52,64}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(junction1.port_1,pipe4.port_a) annotation(Line(points = {{ -42,54},{ -42,48},{ -30,48}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
          connect(junction1.port_2,pipe2.port_a) annotation(Line(points = {{ -42,74},{ -42,78},{ -30,78}}, color = {0,127,255}, thickness = 0.5, smooth = Smooth.None));
        end DynamicPipesAndFittings;
      end Pipes;
      package Machines "Test Machine models"
        model TestWaterPumpVariableSpeed "Test pump with variable speed (starting from zero)"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Blocks.Sources.Ramp N_pump(startTime = 1, duration = 5, height = 1500, offset = 0) annotation(Placement(transformation(extent = {{ -100,62},{ -80,82}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, use_p_in = false, p = 100000) annotation(Placement(transformation(extent = {{34,26},{14,46}}, rotation = 0)));
          Modelica.Fluid.Machines.PrescribedPump pump(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_start = 1, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.001,0.0015}, head_nominal = {100,50,0}), N_nominal = 1500, use_N_in = true, p_a_start = 100000, p_b_start = 700000) annotation(Placement(transformation(extent = {{ -66,20},{ -34,50}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp valveOpening(height =  -1, duration = 1, offset = 1, startTime = 8) annotation(Placement(transformation(extent = {{ -40,64},{ -20,84}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible Valve(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 1000000) annotation(Placement(transformation(extent = {{ -16,26},{2,46}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64, -4},{84,16}}, rotation = 0)));

        equation 
          connect(Valve.port_b,Sink.ports[1]) annotation(Line(points = {{2,36},{14,36}}, color = {0,127,255}));
          connect(Valve.port_a,pump.port_b) annotation(Line(points = {{ -16,36},{ -26,36},{ -26,35},{ -34,35}}, color = {0,127,255}));
          connect(pump.port_a,Source.ports[1]) annotation(Line(points = {{ -66,35},{ -70,35},{ -70,30},{ -80,30}}, color = {0,127,255}));
          connect(N_pump.y,pump.N_in) annotation(Line(points = {{ -79,72},{ -50,72},{ -50,50}}, color = {0,0,127}, smooth = Smooth.None));
          connect(valveOpening.y,Valve.opening) annotation(Line(points = {{ -19,74},{ -7,74},{ -7,44}}, color = {0,0,127}, smooth = Smooth.None));
        end TestWaterPumpVariableSpeed;
        model TestWaterPumpRecirculation "Test pump with variable speed and recirculating flow"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Blocks.Sources.Ramp N_pump(startTime = 1, height = 1500, offset = 0, duration = 1) annotation(Placement(transformation(extent = {{ -100, -8},{ -80,12}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, T = system.T_ambient, p = 100000, redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater) annotation(Placement(transformation(extent = {{ -100, -38},{ -80, -18}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, T = system.T_ambient, use_p_in = false, p = 100000, redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater) annotation(Placement(transformation(extent = {{62, -30},{42, -10}}, rotation = 0)));
          Modelica.Fluid.Machines.PrescribedPump pump(m_flow_start = 1, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.001,0.0015}, head_nominal = {100,50,0}), N_nominal = 1500, use_N_in = true, V = 0.1 / 1000, redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater, p_a_start = 100000, p_b_start = 700000, energyDynamics = Modelica.Fluid.Types.Dynamics.DynamicFreeInitial, massDynamics = Modelica.Fluid.Types.Dynamics.DynamicFreeInitial) annotation(Placement(transformation(extent = {{ -46, -40},{ -14, -10}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{80,60},{100,80}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible V1(CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, dp_nominal = 800000, redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater) annotation(Placement(transformation(extent = {{ -28,6},{ -50,26}})));
          Modelica.Fluid.Valves.ValveIncompressible V2(CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, dp_nominal = 800000, redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater) annotation(Placement(transformation(extent = {{0, -30},{22, -10}})));
          Modelica.Blocks.Sources.Ramp V1_Opening(duration = 1, height =  -1, offset = 1, startTime = 5) annotation(Placement(transformation(extent = {{ -100,40},{ -80,60}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp V2_Opening(offset = 0, height = 1, duration = 1, startTime = 3) annotation(Placement(transformation(extent = {{ -100,70},{ -80,90}}, rotation = 0)));

        equation 
          connect(pump.port_a,Source.ports[1]) annotation(Line(points = {{ -46, -25},{ -46, -25},{ -80, -28}}, color = {0,127,255}));
          connect(N_pump.y,pump.N_in) annotation(Line(points = {{ -79,2},{ -30,2},{ -30, -10}}, color = {0,0,127}, smooth = Smooth.None));
          connect(pump.port_b,V1.port_a) annotation(Line(points = {{ -14, -25},{ -20,14},{ -20,16},{ -28,16}}, color = {0,127,255}, smooth = Smooth.None));
          connect(V1.port_b,pump.port_a) annotation(Line(points = {{ -50,16},{ -60,16},{ -60, -25},{ -46, -25}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pump.port_b,V2.port_a) annotation(Line(points = {{ -14, -25},{ -10.2, -25},{ -10.2, -20},{0, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(V2.port_b,Sink.ports[1]) annotation(Line(points = {{22, -20},{42, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(V1_Opening.y,V1.opening) annotation(Line(points = {{ -79,50},{ -39,50},{ -39,24}}, color = {0,0,127}, smooth = Smooth.None));
          connect(V2_Opening.y,V2.opening) annotation(Line(points = {{ -79,80},{11,80},{11, -12}}, color = {0,0,127}, smooth = Smooth.None));
        end TestWaterPumpRecirculation;
        model TestWaterPumpPowerCharacteristic "Test pump with power consumption characteristic"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 100000.0, T = system.T_ambient) annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 500000.0, T = system.T_ambient, use_p_in = true) annotation(Placement(transformation(extent = {{34,26},{14,46}}, rotation = 0)));
          Modelica.Fluid.Machines.PrescribedPump pump(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_start = 1, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.001,0.0015}, head_nominal = {100,50,0}), use_powerCharacteristic = true, redeclare function powerCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticPower(V_flow_nominal = {0,0.001,0.0015}, W_nominal = {550,650,800}), V = 0.1 / 1000, N_nominal = 1500, energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, massDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, p_a_start = 100000, p_b_start = 700000) annotation(Placement(transformation(extent = {{ -66,20},{ -34,50}}, rotation = 0)));
          Modelica.Blocks.Sources.Constant valveOpening(k = 1) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible Valve(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 20000) annotation(Placement(transformation(extent = {{ -16,26},{2,46}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp downstreamPressure(startTime = 1, duration = 5, offset = 100000.0, height = 1000000.0) annotation(Placement(transformation(extent = {{4,74},{24,94}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64, -4},{84,16}}, rotation = 0)));

        equation 
          connect(Valve.port_b,Sink.ports[1]) annotation(Line(points = {{2,36},{14,36}}, color = {0,127,255}));
          connect(Valve.port_a,pump.port_b) annotation(Line(points = {{ -16,36},{ -26,36},{ -26,35},{ -34,35}}, color = {0,127,255}));
          connect(pump.port_a,Source.ports[1]) annotation(Line(points = {{ -66,35},{ -70,35},{ -70,30},{ -80,30}}, color = {0,127,255}));
          connect(downstreamPressure.y,Sink.p_in) annotation(Line(points = {{25,84},{58,84},{58,44},{36,44}}, color = {0,0,127}));
          annotation(experiment(StopTime = 10), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
          connect(valveOpening.y,Valve.opening) annotation(Line(points = {{ -39,70},{ -7,70},{ -7,44}}, color = {0,0,127}, smooth = Smooth.None));
        end TestWaterPumpPowerCharacteristic;
        model TestWaterPumpNPSH "Test PumpNPSH"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 100000.0, T = system.T_ambient) annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 500000.0, T = system.T_ambient, use_p_in = true) annotation(Placement(transformation(extent = {{34,26},{14,46}}, rotation = 0)));
          Modelica.Fluid.Machines.PrescribedPump pump(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_start = 1, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.001,0.0015}, head_nominal = {100,50,0}), N_nominal = 1500, p_a_start = 100000, p_b_start = 700000, show_NPSHa = true) annotation(Placement(transformation(extent = {{ -66,20},{ -34,50}}, rotation = 0)));
          Modelica.Blocks.Sources.Constant valveOpening(k = 1) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible Valve(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 20000) annotation(Placement(transformation(extent = {{ -16,26},{2,46}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp downstreamPressure(startTime = 1, duration = 5, offset = 100000.0, height = 1000000.0) annotation(Placement(transformation(extent = {{4,74},{24,94}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64, -4},{84,16}}, rotation = 0)));

        equation 
          connect(Valve.port_b,Sink.ports[1]) annotation(Line(points = {{2,36},{14,36}}, color = {0,127,255}));
          connect(Valve.port_a,pump.port_b) annotation(Line(points = {{ -16,36},{ -26,36},{ -26,35},{ -34,35}}, color = {0,127,255}));
          connect(pump.port_a,Source.ports[1]) annotation(Line(points = {{ -66,35},{ -70,35},{ -70,30},{ -80,30}}, color = {0,127,255}));
          connect(downstreamPressure.y,Sink.p_in) annotation(Line(points = {{25,84},{58,84},{58,44},{36,44}}, color = {0,0,127}));
          connect(valveOpening.y,Valve.opening) annotation(Line(points = {{ -39,70},{ -7,70},{ -7,44}}, color = {0,0,127}, smooth = Smooth.None));
        end TestWaterPumpNPSH;
        model TestWaterPumpDefaultLV "Test pump with default options an linear valve"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 100000.0, T = system.T_ambient) annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 500000.0, T = system.T_ambient, use_p_in = true) annotation(Placement(transformation(extent = {{34,26},{14,46}}, rotation = 0)));
          Modelica.Fluid.Machines.PrescribedPump pump(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_start = 1, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.001,0.0015}, head_nominal = {100,50,0}), N_nominal = 1500, p_a_start = 100000, p_b_start = 700000) annotation(Placement(transformation(extent = {{ -66,20},{ -34,50}}, rotation = 0)));
          Modelica.Blocks.Sources.Constant valveOpening(k = 1) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveLinear Valve(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, dp_nominal = 20000) annotation(Placement(transformation(extent = {{ -16,26},{2,46}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp downstreamPressure(startTime = 1, duration = 5, offset = 100000.0, height = 1000000.0) annotation(Placement(transformation(extent = {{4,74},{24,94}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64, -4},{84,16}}, rotation = 0)));

        equation 
          connect(Valve.port_b,Sink.ports[1]) annotation(Line(points = {{2,36},{14,36}}, color = {0,127,255}));
          connect(Valve.port_a,pump.port_b) annotation(Line(points = {{ -16,36},{ -26,36},{ -26,35},{ -34,35}}, color = {0,127,255}));
          connect(pump.port_a,Source.ports[1]) annotation(Line(points = {{ -66,35},{ -70,35},{ -70,30},{ -80,30}}, color = {0,127,255}));
          connect(downstreamPressure.y,Sink.p_in) annotation(Line(points = {{25,84},{58,84},{58,44},{36,44}}, color = {0,0,127}));
          connect(valveOpening.y,Valve.opening) annotation(Line(points = {{ -39,70},{ -7,70},{ -7,44}}, color = {0,0,127}, smooth = Smooth.None));
        end TestWaterPumpDefaultLV;
        model TestWaterPumpDefault "Test pump with default options"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 100000.0, T = system.T_ambient) annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 500000.0, T = system.T_ambient, use_p_in = true) annotation(Placement(transformation(extent = {{34,26},{14,46}}, rotation = 0)));
          Modelica.Fluid.Machines.PrescribedPump pump(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_start = 1, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.001,0.0015}, head_nominal = {100,50,0}), N_nominal = 1500, p_a_start = 100000, p_b_start = 700000) annotation(Placement(transformation(extent = {{ -66,20},{ -34,50}}, rotation = 0)));
          Modelica.Blocks.Sources.Constant valveOpening(k = 1) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible Valve(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 20000) annotation(Placement(transformation(extent = {{ -16,26},{2,46}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp downstreamPressure(startTime = 1, duration = 5, offset = 100000.0, height = 1000000.0) annotation(Placement(transformation(extent = {{4,74},{24,94}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{64, -4},{84,16}}, rotation = 0)));

        equation 
          connect(Valve.port_b,Sink.ports[1]) annotation(Line(points = {{2,36},{14,36}}, color = {0,127,255}));
          connect(Valve.port_a,pump.port_b) annotation(Line(points = {{ -16,36},{ -26,36},{ -26,35},{ -34,35}}, color = {0,127,255}));
          connect(pump.port_a,Source.ports[1]) annotation(Line(points = {{ -66,35},{ -70,35},{ -70,30},{ -80,30}}, color = {0,127,255}));
          connect(downstreamPressure.y,Sink.p_in) annotation(Line(points = {{25,84},{58,84},{58,44},{36,44}}, color = {0,0,127}));
          connect(valveOpening.y,Valve.opening) annotation(Line(points = {{ -39,70},{ -7,70},{ -7,44}}, color = {0,0,127}, smooth = Smooth.None));
        end TestWaterPumpDefault;
        model TestWaterPumpDCMotorHeatTransfer "Test pump with dc motor (startup transient)"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 8, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{ -50, -60},{ -30, -40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, use_p_in = false, p = 100000) annotation(Placement(transformation(extent = {{80,0},{60,20}}, rotation = 0)));
          Modelica.Fluid.Machines.Pump pump(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_start = 1, N_nominal = 1500, use_HeatTransfer = true, use_powerCharacteristic = true, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.001,0.0015}, head_nominal = {100,50,0}), redeclare function powerCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticPower(V_flow_nominal = {0,0.001,0.0015}, W_nominal = {550,650,800}), p_a_start = 100000, p_b_start = 100000) annotation(Placement(transformation(extent = {{ -10, -5},{20,25}}, rotation = 0)));
          Modelica.Blocks.Sources.Step valveOpening(offset = 1, startTime = 5, height =  -1) annotation(Placement(transformation(extent = {{70,40},{50,60}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible Valve(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 1000000) annotation(Placement(transformation(extent = {{31,0},{49,20}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{50, -70},{70, -50}}, rotation = 0)));
          Modelica.Electrical.Machines.BasicMachines.DCMachines.DC_PermanentMagnet motor(La = 0.001, Jr = 0.1, inertiaRotor(w(fixed = true, displayUnit = "1/min", start = 0.10471975511966)), VaNominal = 400, wNominal(displayUnit = "1/min") = 157.07963267949, Ra = 10, IaNominal = 10) annotation(Placement(transformation(extent = {{ -54,28},{ -30,52}})));
          Modelica.Electrical.Analog.Sources.StepVoltage stepVoltage(startTime = 1, offset = 0.1, V = 400) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}}, rotation =  -90, origin = { -80,40})));
          Modelica.Electrical.Analog.Basic.Ground ground annotation(Placement(transformation(extent = {{ -90,2},{ -70,24}})));
          Modelica.Thermal.HeatTransfer.Components.HeatCapacitor housing(C = 460 * 1) annotation(Placement(transformation(extent = {{ -1, -20},{19, -40}})));

        equation 
          connect(Valve.port_b,Sink.ports[1]) annotation(Line(points = {{49,10},{60,10}}, color = {0,127,255}));
          connect(Valve.port_a,pump.port_b) annotation(Line(points = {{31,10},{20,10}}, color = {0,127,255}));
          connect(pump.port_a,Source.ports[1]) annotation(Line(points = {{ -10,10},{ -20,10},{ -20, -50},{ -30, -50}}, color = {0,127,255}));
          connect(valveOpening.y,Valve.opening) annotation(Line(points = {{49,50},{40,50},{40,18}}, color = {0,0,127}, smooth = Smooth.None));
          connect(motor.pin_ap,stepVoltage.p) annotation(Line(points = {{ -34.8,52},{ -34,52},{ -34,60},{ -80,60},{ -80,50}}, color = {0,0,255}, smooth = Smooth.None));
          connect(stepVoltage.n,motor.pin_an) annotation(Line(points = {{ -80,30},{ -62,30},{ -62,52},{ -49.2,52}}, color = {0,0,255}, smooth = Smooth.None));
          connect(stepVoltage.n,ground.p) annotation(Line(points = {{ -80,30},{ -80,24}}, color = {0,0,255}, smooth = Smooth.None));
          connect(pump.heatPort,housing.port) annotation(Line(points = {{11,1},{20,1},{20, -20},{9, -20}}, color = {191,0,0}, smooth = Smooth.None));
          connect(pump.shaft,motor.flange) annotation(Line(points = {{5,25},{5,40},{ -30,40}}, color = {0,0,0}, smooth = Smooth.None));
        end TestWaterPumpDCMotorHeatTransfer;
        model TestWaterPumpDCMotor "Test pump with dc motor (startup transient)"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 8, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{ -50, -60},{ -30, -40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, use_p_in = false, p = 100000) annotation(Placement(transformation(extent = {{80,0},{60,20}}, rotation = 0)));
          Modelica.Fluid.Machines.Pump pump(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_start = 1, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.001,0.0015}, head_nominal = {100,50,0}), N_nominal = 1500, p_a_start = 100000, p_b_start = 700000) annotation(Placement(transformation(extent = {{ -10, -5},{20,25}}, rotation = 0)));
          Modelica.Blocks.Sources.Step valveOpening(height =  -0.5, offset = 1, startTime = 5) annotation(Placement(transformation(extent = {{70,40},{50,60}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible Valve(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 1, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 1000000) annotation(Placement(transformation(extent = {{31,0},{49,20}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{50, -70},{70, -50}}, rotation = 0)));
          Modelica.Electrical.Machines.BasicMachines.DCMachines.DC_PermanentMagnet motor(La = 0.001, Jr = 0.1, inertiaRotor(w(fixed = true, displayUnit = "1/min", start = 0.10471975511966)), VaNominal = 400, wNominal(displayUnit = "1/min") = 157.07963267949, IaNominal = 10, Ra = 10) annotation(Placement(transformation(extent = {{ -54,28},{ -30,52}})));
          Modelica.Electrical.Analog.Sources.StepVoltage stepVoltage(startTime = 1, offset = 0.1, V = 400) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}}, rotation =  -90, origin = { -80,40})));
          Modelica.Electrical.Analog.Basic.Ground ground annotation(Placement(transformation(extent = {{ -90,2},{ -70,24}})));

        equation 
          connect(Valve.port_b,Sink.ports[1]) annotation(Line(points = {{49,10},{60,10}}, color = {0,127,255}));
          connect(Valve.port_a,pump.port_b) annotation(Line(points = {{31,10},{20,10}}, color = {0,127,255}));
          connect(pump.port_a,Source.ports[1]) annotation(Line(points = {{ -10,10},{ -20,10},{ -20, -50},{ -30, -50}}, color = {0,127,255}));
          connect(valveOpening.y,Valve.opening) annotation(Line(points = {{49,50},{40,50},{40,18}}, color = {0,0,127}, smooth = Smooth.None));
          connect(motor.pin_ap,stepVoltage.p) annotation(Line(points = {{ -34.8,52},{ -34,52},{ -34,60},{ -80,60},{ -80,50}}, color = {0,0,255}, smooth = Smooth.None));
          connect(stepVoltage.n,motor.pin_an) annotation(Line(points = {{ -80,30},{ -62,30},{ -62,52},{ -49.2,52}}, color = {0,0,255}, smooth = Smooth.None));
          connect(stepVoltage.n,ground.p) annotation(Line(points = {{ -80,30},{ -80,24}}, color = {0,0,255}, smooth = Smooth.None));
          connect(pump.shaft,motor.flange) annotation(Line(points = {{5,25},{5,40},{ -30,40}}, color = {0,0,0}, smooth = Smooth.None));
        end TestWaterPumpDCMotor;
        model TestWaterPumpCheckValve "Test pump with check valve behaviour"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 3, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Blocks.Sources.Ramp N_pump(startTime = 1, duration = 1, offset = 1500, height =  -1500) annotation(Placement(transformation(extent = {{ -80,0},{ -60,20}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{ -80, -40},{ -60, -20}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT Sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, use_p_in = false, p = 500000) annotation(Placement(transformation(extent = {{60, -40},{40, -20}}, rotation = 0)));
          Modelica.Fluid.Machines.PrescribedPump pump(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_start = 1, redeclare function flowCharacteristic = Modelica.Fluid.Machines.BaseClasses.PumpCharacteristics.quadraticFlow(V_flow_nominal = {0,0.001,0.0015}, head_nominal = {100,50,0}), N_nominal = 1500, checkValve = true, V = 0.1 / 1000, use_N_in = true, energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, massDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, p_a_start = 100000, p_b_start = 700000) annotation(Placement(transformation(extent = {{ -40, -40},{ -20, -20}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{80,60},{100,80}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible valve(redeclare package Medium = Modelica.Media.Water.StandardWater, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, dp_nominal = 800000) annotation(Placement(transformation(extent = {{0, -40},{22, -20}})));
          Modelica.Blocks.Sources.Constant valveOpening(k = 1) annotation(Placement(transformation(extent = {{ -38,32},{ -18,52}}, rotation = 0)));

        equation 
          connect(pump.port_a,Source.ports[1]) annotation(Line(points = {{ -40, -30},{ -60, -30}}, color = {0,127,255}));
          connect(N_pump.y,pump.N_in) annotation(Line(points = {{ -59,10},{ -30,10},{ -30, -20}}, color = {0,0,127}, smooth = Smooth.None));
          connect(pump.port_b,valve.port_a) annotation(Line(points = {{ -20, -30},{0, -30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(valve.port_b,Sink.ports[1]) annotation(Line(points = {{22, -30},{40, -30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(valveOpening.y,valve.opening) annotation(Line(points = {{ -17,42},{11,42},{11, -22}}, color = {0,0,127}, smooth = Smooth.None));
        end TestWaterPumpCheckValve;
        model TestSweptVolume "Enclosed medium with fixed quantity in an adiabatic volume with varying size"
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5));
          Modelica.Fluid.Machines.SweptVolume sweptVolume(nPorts = 1, redeclare package Medium = Modelica.Media.Air.DryAirNasa, clearance(displayUnit = "l") = 1e-05, use_portsData = false, pistonCrossArea(displayUnit = "cm2") = 0.001) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}}, rotation = 90, origin = {10,10})));
          Modelica.Mechanics.Translational.Components.Mass mass(m = 1, s(start = 0.5, fixed = true)) annotation(Placement(transformation(extent = {{ -10,0},{ -30,20}})));
          Modelica.Fluid.Sources.Boundary_pT boundary(nPorts = 1, redeclare package Medium = Modelica.Media.Air.DryAirNasa, use_p_in = true, p = 200000) annotation(Placement(transformation(extent = {{60,0},{40,20}})));
          Modelica.Blocks.Sources.Trapezoid trapezoid(offset = 100000.0, amplitude = 100000.0, rising = 0.5, falling = 0.5, period = 2, startTime = 1) annotation(Placement(transformation(extent = {{40,40},{60,60}})));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}})));
          Modelica.Mechanics.Translational.Components.Fixed fixed(s0 = 2) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}}, rotation = 270, origin = { -70,10})));
          Modelica.Mechanics.Translational.Components.SpringDamper springDamper(c = 100, d = 1, s_rel0 = 1.5) annotation(Placement(transformation(extent = {{ -40,0},{ -60,20}})));

        equation 
          connect(sweptVolume.ports[1],boundary.ports[1]) annotation(Line(points = {{20,10},{40,10}}, color = {0,127,255}, smooth = Smooth.None));
          connect(boundary.p_in,trapezoid.y) annotation(Line(points = {{62,18},{80,18},{80,50},{61,50}}, color = {0,0,127}, smooth = Smooth.None));
          connect(mass.flange_a,sweptVolume.flange) annotation(Line(points = {{ -10,10},{0,10}}, color = {0,127,0}, smooth = Smooth.None));
          connect(mass.flange_b,springDamper.flange_a) annotation(Line(points = {{ -30,10},{ -40,10}}, color = {0,127,0}, smooth = Smooth.None));
          connect(springDamper.flange_b,fixed.flange) annotation(Line(points = {{ -60,10},{ -70,10}}, color = {0,127,0}, smooth = Smooth.None));
        end TestSweptVolume;
        model TestControlledPump "Test controlled pump"
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 7, Tolerance = 1e-06), Documentation(info = ""));
          Modelica.Blocks.Sources.Sine massFlowRate(amplitude = 0.5, offset = 1, freqHz = 1 / 7) annotation(Placement(transformation(extent = {{ -70,60},{ -50,80}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{ -90,20},{ -70,40}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, use_p_in = true, p = 200000) annotation(Placement(transformation(extent = {{50,20},{30,40}}, rotation = 0)));
          Modelica.Fluid.Machines.ControlledPump pump(redeclare package Medium = Modelica.Media.Water.StandardWater, use_m_flow_set = true, m_flow_nominal = 1, p_a_nominal = 100000, p_b_nominal = 1000000) annotation(Placement(transformation(extent = {{ -50,20},{ -30,40}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{70, -90},{90, -70}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible valve(redeclare package Medium = Modelica.Media.Water.StandardWater, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, dp_nominal = 200000) annotation(Placement(transformation(extent = {{ -10,20},{10,40}})));
          Modelica.Blocks.Sources.Ramp valveOpening(duration = 1, startTime = 3, height =  -0.5, offset = 1) annotation(Placement(transformation(extent = {{30,60},{10,80}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine pressure1(amplitude = 500000.0, freqHz = 1 / 7, offset = 1000000.0) annotation(Placement(transformation(extent = {{ -70, -40},{ -50, -20}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT source1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, p = 100000) annotation(Placement(transformation(extent = {{ -90, -80},{ -70, -60}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT sink1(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, T = system.T_ambient, use_p_in = true, p = 200000) annotation(Placement(transformation(extent = {{50, -80},{30, -60}}, rotation = 0)));
          Modelica.Fluid.Machines.ControlledPump pump1(redeclare package Medium = Modelica.Media.Water.StandardWater, control_m_flow = false, use_m_flow_set = false, use_p_set = true, m_flow_nominal = 1, p_a_nominal = 100000, p_b_nominal = 1000000) annotation(Placement(transformation(extent = {{ -50, -80},{ -30, -60}}, rotation = 0)));
          Modelica.Fluid.Valves.ValveIncompressible valve1(redeclare package Medium = Modelica.Media.Water.StandardWater, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, dp_nominal = 200000) annotation(Placement(transformation(extent = {{ -10, -80},{10, -60}})));
          Modelica.Blocks.Sources.Ramp valveOpening1(duration = 1, startTime = 3, height =  -0.5, offset = 1) annotation(Placement(transformation(extent = {{30, -40},{10, -20}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp sinkPressure(duration = 1, startTime = 5, height =  -700000.0, offset = 800000.0) annotation(Placement(transformation(extent = {{90,60},{70,80}}, rotation = 0)));

        equation 
          connect(pump.port_a,source.ports[1]) annotation(Line(points = {{ -50,30},{ -70,30}}, color = {0,127,255}));
          connect(pump.port_b,valve.port_a) annotation(Line(points = {{ -30,30},{ -10,30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(valve.port_b,sink.ports[1]) annotation(Line(points = {{10,30},{30,30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(valveOpening.y,valve.opening) annotation(Line(points = {{9,70},{0,70},{0,38}}, color = {0,0,127}, smooth = Smooth.None));
          connect(massFlowRate.y,pump.m_flow_set) annotation(Line(points = {{ -49,70},{ -45,70},{ -45,38.2}}, color = {0,0,127}, smooth = Smooth.None));
          connect(pump1.port_a,source1.ports[1]) annotation(Line(points = {{ -50, -70},{ -70, -70}}, color = {0,127,255}));
          connect(pump1.port_b,valve1.port_a) annotation(Line(points = {{ -30, -70},{ -10, -70}}, color = {0,127,255}, smooth = Smooth.None));
          connect(valve1.port_b,sink1.ports[1]) annotation(Line(points = {{10, -70},{30, -70}}, color = {0,127,255}, smooth = Smooth.None));
          connect(valveOpening1.y,valve1.opening) annotation(Line(points = {{9, -30},{0, -30},{0, -62}}, color = {0,0,127}, smooth = Smooth.None));
          connect(pressure1.y,pump1.p_set) annotation(Line(points = {{ -49, -30},{ -35, -30},{ -35, -61.8}}, color = {0,0,127}, smooth = Smooth.None));
          connect(sinkPressure.y,sink.p_in) annotation(Line(points = {{69,70},{60,70},{60,38},{52,38}}, color = {0,0,127}, smooth = Smooth.None));
          connect(sinkPressure.y,sink1.p_in) annotation(Line(points = {{69,70},{60,70},{60, -62},{52, -62}}, color = {0,0,127}, smooth = Smooth.None));
        end TestControlledPump;
      end Machines;
      package Fittings "Test Fitting models"
        model TestWallFriction
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          replaceable package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater extends Modelica.Media.Interfaces.PartialMedium "Medium in all components" annotation(choicesAllMatching = true);
          parameter Modelica.SIunits.Length roughness = 2.5e-05;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10, NumberOfIntervals = 10000), experimentSetupOutput, Documentation(info = "<html>
<p>
5 different wall friction models are compared.
</p>

<p>
pipe1 and pipe2 should be identical to pipe3 and pipe4 for
pipe1.WallFriction = WallFriction.QuadraticTurbulent (since the same equations).
</p>

<p>
pipe1 and pipe2 should be identical to pressureLossPipe for
pipe1.WallFriction = WallFriction.Detailed (since the same equations).
</p>
</html>"));
          Modelica.Fluid.Sources.Boundary_pT ambient_a(redeclare package Medium = Medium, p = system.p_ambient, T = system.T_ambient, use_p_in = true, nPorts = 4) annotation(Placement(transformation(extent = {{ -38,40},{ -18,60}}, rotation = 0)));
          Modelica.Blocks.Sources.TimeTable p_table(table = [0,99999.0;10,100001.0]) annotation(Placement(transformation(extent = {{ -80,40},{ -60,60}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT ambient_p1(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = Modelica.SIunits.Conversions.from_degC(80)) annotation(Placement(transformation(extent = {{62,40},{42,60}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT ambient_p2(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = Modelica.SIunits.Conversions.from_degC(80)) annotation(Placement(transformation(extent = {{60,10},{40,30}}, rotation = 0)));
          Modelica.Fluid.Pipes.BaseClasses.WallFriction.TestWallFrictionAndGravity pipe1(length = 1, diameter = 0.1, redeclare package Medium = Medium, roughness = roughness, port_a(m_flow(start =  -0.6)), redeclare package WallFriction = Modelica.Fluid.Pipes.BaseClasses.WallFriction.Detailed, dp_small = 0.1, show_Re = true) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
          Modelica.Fluid.Pipes.BaseClasses.WallFriction.TestWallFrictionAndGravity pipe2(length = 1, diameter = 0.1, redeclare package Medium = Medium, roughness = roughness, redeclare package WallFriction = Modelica.Fluid.Pipes.BaseClasses.WallFriction.Detailed(from_dp = false, show_Re = true), port_a(m_flow(start =  -0.6))) annotation(Placement(transformation(extent = {{0,10},{20,30}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT ambient_p3(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = Modelica.SIunits.Conversions.from_degC(80)) annotation(Placement(transformation(extent = {{60, -20},{40,0}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT ambient_p4(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = Modelica.SIunits.Conversions.from_degC(80)) annotation(Placement(transformation(extent = {{60, -50},{40, -30}}, rotation = 0)));
          Modelica.Fluid.Fittings.BaseClasses.QuadraticTurbulent.TestWallFriction pipe3(length = 1, diameter = 0.1, redeclare package Medium = Medium, roughness = roughness, dp_small = 0.1) annotation(Placement(transformation(extent = {{0, -20},{20,0}}, rotation = 0)));
          Modelica.Fluid.Fittings.BaseClasses.QuadraticTurbulent.TestWallFriction pipe4(length = 1, diameter = 0.1, from_dp = false, redeclare package Medium = Medium, roughness = roughness) annotation(Placement(transformation(extent = {{0, -50},{20, -30}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{68,74},{88,94}}, rotation = 0)));

        equation 
          connect(p_table.y,ambient_a.p_in) annotation(Line(points = {{ -59,50},{ -52,50},{ -52,58},{ -40,58}}, color = {0,0,127}));
          connect(ambient_a.ports[1],pipe1.port_a) annotation(Line(points = {{ -18,53},{ -9,53},{ -9,50},{0,50}}, color = {0,127,255}));
          connect(pipe1.port_b,ambient_p1.ports[1]) annotation(Line(points = {{20,50},{42,50}}, color = {0,127,255}));
          connect(pipe2.port_b,ambient_p2.ports[1]) annotation(Line(points = {{20,20},{40,20}}, color = {0,127,255}));
          connect(ambient_a.ports[2],pipe2.port_a) annotation(Line(points = {{ -18,51},{ -12,51},{ -12,20},{0,20}}, color = {0,127,255}));
          connect(pipe3.port_b,ambient_p3.ports[1]) annotation(Line(points = {{20, -10},{40, -10}}, color = {0,127,255}));
          connect(pipe4.port_b,ambient_p4.ports[1]) annotation(Line(points = {{20, -40},{40, -40}}, color = {0,127,255}));
          connect(ambient_a.ports[3],pipe3.port_a) annotation(Line(points = {{ -18,49},{ -12,49},{ -12, -10},{0, -10}}, color = {0,127,255}));
          connect(ambient_a.ports[4],pipe4.port_a) annotation(Line(points = {{ -18,47},{ -12,47},{ -12, -40},{0, -40}}, color = {0,127,255}));
        end TestWallFriction;
        model TestSuddenExpansion "Test of sudden expansion models, with correct and wrong usage"
          extends Modelica.Icons.Example;
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), Documentation(info = "<html>
<p>
This example shows the use of a sudden expansion / contraction model, which is connected to two boundary conditions prescribing static pressure. Notice that the prescribed static pressure on the right boundary is higher than on the left one. Still, the fluid flows from left to right.
</p>
<p>
The reason for this is that the boundary conditions model infinite reservoirs with an infinite diameter and thus zero flow velocity. The sudden expansion model does however have two ends with finite diameters, and, as explained in the <a href=\"Modelica://Modelica.Fluid.UsersGuide.Overview\">Overview</a> of the Users' Guide, the momentum balance is not fulfilled exactly for this type of connections. Using a simple <code>connect()</code>-statement, the difference of the kinetic terms is neglected, which is not reasonable in the present model: At the left boundary condition it is zero, and on the left side of the sudden expansion it has a non-zero value. It is not reasonable to neglect it in the shown model, because there is little friction and therefore these kinetic effects dominate. Consequently, only modelling these effects explicitly leads to the correct results.
</p>
<p>
To do so, two additional sudden expansions / contractions are included in the model. The diameter is set to <code>inf</code> close to the boundaries and the proper values close to the original model. These additional components now introduce <i>exact</i> momentum balances and the results are as expected.
</p>
</html>"));
          Modelica.Fluid.Sources.Boundary_pT leftBoundary1(redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, nPorts = 1, p = 100000) annotation(Placement(transformation(extent = {{ -80,20},{ -60,40}})));
          Modelica.Fluid.Sources.Boundary_pT rightBoundary1(redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, nPorts = 1, p = 110000) annotation(Placement(transformation(extent = {{80,20},{60,40}})));
          Modelica.Fluid.Fittings.AbruptAdaptor suddenExpansion1(diameter_a = 0.1, diameter_b = 0.2, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase) annotation(Placement(transformation(extent = {{ -12,20},{8,40}})));
          Modelica.Fluid.Sources.Boundary_pT leftBoundary2(redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, nPorts = 1, p = 100000) annotation(Placement(transformation(extent = {{ -90, -40},{ -70, -20}})));
          Modelica.Fluid.Sources.Boundary_pT rightBoundary2(redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, nPorts = 1, p = 110000) annotation(Placement(transformation(extent = {{90, -40},{70, -20}})));
          Modelica.Fluid.Fittings.AbruptAdaptor suddenExpansion2(diameter_a = 0.1, diameter_b = 0.2, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase) annotation(Placement(transformation(extent = {{ -10, -40},{10, -20}})));
          Modelica.Fluid.Fittings.AbruptAdaptor leftAdapter(diameter_a = 0.1, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, diameter_b = Modelica.Constants.inf) annotation(Placement(transformation(extent = {{ -40, -40},{ -60, -20}})));
          Modelica.Fluid.Fittings.AbruptAdaptor rightAdapter(redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, diameter_a = 0.2, diameter_b = Modelica.Constants.inf) annotation(Placement(transformation(extent = {{40, -40},{60, -20}})));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}})));

        equation 
          connect(leftBoundary1.ports[1],suddenExpansion1.port_a) annotation(Line(points = {{ -60,30},{ -12,30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(suddenExpansion1.port_b,rightBoundary1.ports[1]) annotation(Line(points = {{8,30},{60,30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(leftAdapter.port_b,leftBoundary2.ports[1]) annotation(Line(points = {{ -60, -30},{ -70, -30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(leftAdapter.port_a,suddenExpansion2.port_a) annotation(Line(points = {{ -40, -30},{ -10, -30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(suddenExpansion2.port_b,rightAdapter.port_a) annotation(Line(points = {{10, -30},{40, -30}}, color = {0,127,255}, smooth = Smooth.None));
          connect(rightAdapter.port_b,rightBoundary2.ports[1]) annotation(Line(points = {{60, -30},{70, -30}}, color = {0,127,255}, smooth = Smooth.None));
        end TestSuddenExpansion;
        model TestSimpleGenericOrifice
          extends Modelica.Icons.Example;
          parameter Real diameter_a = 0.1;
          parameter Real diameter_b = 0.2;
          parameter Real A_rel = (diameter_a / diameter_b) ^ 2;
          parameter Real zeta = (1 - A_rel) ^ 2;
          replaceable package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater extends Modelica.Media.Interfaces.PartialMedium "Medium in all components" annotation(choicesAllMatching = true);
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10, NumberOfIntervals = 10000), experimentSetupOutput, Documentation(info = "<html>
</html>"));
          Modelica.Fluid.Sources.Boundary_pT ambient_a(redeclare package Medium = Medium, p = system.p_ambient, T = system.T_ambient, use_p_in = true, nPorts = 2) annotation(Placement(transformation(extent = {{ -40,40},{ -20,60}}, rotation = 0)));
          Modelica.Blocks.Sources.TimeTable p_table(table = [0,99990.0;10,100010.0]) annotation(Placement(transformation(extent = {{ -80,40},{ -60,60}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT ambient_p1(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = Modelica.SIunits.Conversions.from_degC(80)) annotation(Placement(transformation(extent = {{60,40},{40,60}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT ambient_p2(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = Modelica.SIunits.Conversions.from_degC(80)) annotation(Placement(transformation(extent = {{60,10},{40,30}}, rotation = 0)));
          Modelica.Fluid.Fittings.SimpleGenericOrifice expansion1(redeclare package Medium = Medium, zeta = zeta, diameter = diameter_a) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
          Modelica.Fluid.Fittings.SimpleGenericOrifice expansion2(redeclare package Medium = Medium, from_dp = false, zeta = zeta, diameter = diameter_a) annotation(Placement(transformation(extent = {{0,10},{20,30}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -82, -90},{ -62, -70}}, rotation = 0)));

        equation 
          connect(p_table.y,ambient_a.p_in) annotation(Line(points = {{ -59,50},{ -52,50},{ -52,58},{ -42,58}}, color = {0,0,127}));
          connect(ambient_a.ports[1],expansion1.port_a) annotation(Line(points = {{ -20,52},{ -10,52},{ -10,50},{0,50}}, color = {0,127,255}));
          connect(expansion1.port_b,ambient_p1.ports[1]) annotation(Line(points = {{20,50},{40,50}}, color = {0,127,255}));
          connect(expansion2.port_b,ambient_p2.ports[1]) annotation(Line(points = {{20,20},{40,20}}, color = {0,127,255}));
          connect(expansion2.port_a,ambient_a.ports[2]) annotation(Line(points = {{0,20},{ -10,20},{ -10,48},{ -20,48}}, color = {0,127,255}));
        end TestSimpleGenericOrifice;
        model TestSharpEdgedOrifice
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          replaceable package Medium = Modelica.Media.IdealGases.SingleGases.O2 extends Modelica.Media.Interfaces.PartialMedium "Medium in all components" annotation(choicesAllMatching = true);
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10, NumberOfIntervals = 10000), experimentSetupOutput, Documentation(info = "<html>
</html>"));
          Modelica.Fluid.Sources.Boundary_pT ambient_p(redeclare package Medium = Medium, p = system.p_ambient, T = system.T_ambient, use_p_in = true, nPorts = 2) annotation(Placement(transformation(extent = {{ -40,40},{ -20,60}}, rotation = 0)));
          Modelica.Blocks.Sources.TimeTable p_table(table = [0,10000.0;10,200000.0]) annotation(Placement(transformation(extent = {{ -80,40},{ -60,60}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT ambient_p1(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = Modelica.SIunits.Conversions.from_degC(80)) annotation(Placement(transformation(extent = {{60,40},{40,60}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT ambient_p2(nPorts = 1, redeclare package Medium = Medium, p = 100000.0, T = Modelica.SIunits.Conversions.from_degC(80)) annotation(Placement(transformation(extent = {{60,10},{40,30}}, rotation = 0)));
          Modelica.Fluid.Fittings.SharpEdgedOrifice orifice1(redeclare package Medium = Medium, diameter = 0.1, alpha = 50, leastDiameter = 0.02, length = 0.005, show_Re = true) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
          Modelica.Fluid.Fittings.SharpEdgedOrifice orifice2(redeclare package Medium = Medium, diameter = 0.1, alpha = 50, from_dp = false, leastDiameter = 0.02, length = 0.005) annotation(Placement(transformation(extent = {{0,10},{20,30}}, rotation = 0)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{60, -68},{80, -48}}, rotation = 0)));

        equation 
          connect(p_table.y,ambient_p.p_in) annotation(Line(points = {{ -59,50},{ -52,50},{ -52,58},{ -42,58}}, color = {0,0,127}));
          connect(ambient_p.ports[1],orifice1.port_a) annotation(Line(points = {{ -20,52},{ -10,52},{ -10,50},{0,50}}, color = {0,127,255}));
          connect(orifice1.port_b,ambient_p1.ports[1]) annotation(Line(points = {{20,50},{40,50}}, color = {0,127,255}));
          connect(ambient_p.ports[2],orifice2.port_a) annotation(Line(points = {{ -20,48},{ -12,48},{ -12,20},{0,20}}, color = {0,127,255}));
          connect(orifice2.port_b,ambient_p2.ports[1]) annotation(Line(points = {{20,20},{40,20}}, color = {0,127,255}));
        end TestSharpEdgedOrifice;
        model TestPressureLossDerivatives "Test that PressureLoss components can be differentiated"
          import Modelica.Fluid.Fittings.BaseClasses.QuadraticTurbulent;
          extends Modelica.Icons.Example;
          parameter SI.Diameter diameter_a = 0.1 "Inner diameter of pipe at port_a";
          parameter SI.Diameter diameter_b = 0.2 "Inner diameter of pipe at port_b";
          parameter QuadraticTurbulent.LossFactorData data = QuadraticTurbulent.LossFactorData.suddenExpansion(diameter_a, diameter_b) "Loss factors for both flow directions";
          parameter SI.Pressure dp_small = 0.1;
          SI.Density rho_a;
          SI.Density rho_b;
          SI.DynamicViscosity mu_a;
          SI.DynamicViscosity mu_b;
          SI.Pressure dp;
          SI.MassFlowRate m_flow1;
          SI.MassFlowRate m_flow2;
          Real der_m_flow1;
        protected 
          constant Real t2p = 1 "dummy unit constant";
          constant Real t2d = 1 "dummy unit constant";
          constant Real d2mu = 1 "dummy unit constant";
          annotation(experiment(StopTime = 3), experimentSetupOutput, Documentation(info = "<html>

</html>"));

        equation 
          dp = t2p * time - 1;
          rho_a = 0.1 + t2d * time;
          rho_b = 0.2 + 0.5 * t2d * time;
          mu_a = 0.1 * d2mu * rho_a;
          mu_b = 0.4 * d2mu * rho_b;
          m_flow1 = QuadraticTurbulent.massFlowRate_dp(dp, rho_a, rho_b, data, dp_small);
          m_flow2 = QuadraticTurbulent.massFlowRate_dp_and_Re(dp, rho_a, rho_b, mu_a, mu_b, data);
          der_m_flow1 = der(m_flow1);
        end TestPressureLossDerivatives;
        model TestMultiPortTraceSubstances "Test model for multiport and volumes with trace substances."
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          package Medium = Modelica.Media.Air.MoistAir(extraPropertiesNames = {"CO2"});
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics));
          Modelica.Fluid.Sources.Boundary_pT source2(redeclare package Medium = Medium, X = Medium.X_default, nPorts = 3, p = 100000, T = 278.15) annotation(Placement(transformation(origin = {90, -20}, extent = {{ -10, -10},{10,10}}, rotation = 180)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT source1(T = system.T_ambient, use_p_in = true, redeclare package Medium = Medium, use_C_in = true, use_X_in = true, nPorts = 3, p = 500000) annotation(Placement(transformation(extent = {{ -68, -28},{ -48, -8}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp P(duration = 1, height =  -40, offset = 100000.0 + 20) annotation(Placement(transformation(extent = {{ -100,24},{ -80,44}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp C(duration = 1, height = 0.001519) "substance concentration, raising to 1000 PPM CO2" annotation(Placement(transformation(extent = {{ -100, -60},{ -80, -40}})));
          Modelica.Blocks.Sources.Constant X(k = 0.02) annotation(Placement(transformation(extent = {{ -100, -8},{ -80,12}})));
          Modelica.Blocks.Sources.RealExpression X2(y = 1 - X.y) "Concentration of X[2]" annotation(Placement(transformation(extent = {{ -100, -32},{ -80, -12}})));
          Modelica.Fluid.Vessels.ClosedVolume volume1(redeclare package Medium = Medium, nPorts = 3, C_start = {0.0001}, use_portsData = false, V = 1) annotation(Placement(transformation(extent = {{12,20},{32,40}})));
          Modelica.Fluid.Vessels.ClosedVolume volume2(redeclare package Medium = Medium, nPorts = 3, C_start = {0.0001}, use_portsData = false, V = 1) annotation(Placement(transformation(extent = {{12, -20},{32,0}})));
          Modelica.Fluid.Vessels.ClosedVolume volume3(redeclare package Medium = Medium, V = 1, nPorts = 3, C_start = {0.0001}, use_portsData = false) annotation(Placement(transformation(extent = {{12, -80},{32, -60}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance1(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{36,24},{56,44}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance2(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{34, -16},{54,4}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance3(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{36, -76},{56, -56}})));
          Modelica.Fluid.Pipes.StaticPipe pipe1(diameter = 0.1, redeclare package Medium = Medium, length = 1) annotation(Placement(transformation(extent = {{50,10},{70,30}})));
          Modelica.Fluid.Pipes.StaticPipe pipe2(diameter = 0.1, redeclare package Medium = Medium, length = 1) annotation(Placement(transformation(extent = {{50, -30},{70, -10}})));
          Modelica.Fluid.Pipes.StaticPipe pipe3(diameter = 0.1, redeclare package Medium = Medium, length = 1, nParallel = 1) annotation(Placement(transformation(extent = {{52, -90},{72, -70}})));
          Modelica.Fluid.Fittings.MultiPort multiPort(nPorts_b = 2, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -36, -10},{ -28,10}}, rotation = 0)));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -54,18},{ -34,38}})));
          Modelica.Fluid.Pipes.StaticPipe pipe4(diameter = 0.1, redeclare package Medium = Medium, length = 1) annotation(Placement(transformation(extent = {{ -16,10},{4,30}})));
          Modelica.Fluid.Pipes.StaticPipe pipe5(diameter = 0.1, redeclare package Medium = Medium, length = 1) annotation(Placement(transformation(extent = {{ -16, -30},{4, -10}})));
          Modelica.Fluid.Pipes.StaticPipe pipe6(diameter = 0.1, redeclare package Medium = Medium, length = 1, nParallel = 1) annotation(Placement(transformation(extent = {{ -16, -90},{4, -70}})));

        equation 
          connect(P.y,source1.p_in) annotation(Line(points = {{ -79,34},{ -74,34},{ -74, -10},{ -70, -10}}, color = {0,0,127}));
          connect(C.y,source1.C_in[1]) annotation(Line(points = {{ -79, -50},{ -76, -50},{ -76, -26},{ -70, -26}}, color = {0,0,127}, smooth = Smooth.None));
          connect(X.y,source1.X_in[1]) annotation(Line(points = {{ -79,2},{ -76,2},{ -76, -22},{ -70, -22}}, color = {0,0,127}, smooth = Smooth.None));
          connect(X2.y,source1.X_in[2]) annotation(Line(points = {{ -79, -22},{ -70, -22}}, color = {0,0,127}, smooth = Smooth.None));
          connect(volume1.ports[3],traceSubstance1.port) annotation(Line(points = {{24.6667,20},{34,20},{34,24},{46,24}}, color = {0,127,255}, smooth = Smooth.None));
          connect(volume2.ports[3],traceSubstance2.port) annotation(Line(points = {{24.6667, -20},{34, -20},{34, -16},{44, -16}}, color = {0,127,255}, smooth = Smooth.None));
          connect(volume3.ports[3],traceSubstance3.port) annotation(Line(points = {{24.6667, -80},{25, -80},{25, -76},{46, -76}}, color = {0,127,255}, smooth = Smooth.None));
          connect(volume1.ports[2],pipe1.port_a) annotation(Line(points = {{22,20},{50,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(volume2.ports[2],pipe2.port_a) annotation(Line(points = {{22, -20},{50, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(volume3.ports[2],pipe3.port_a) annotation(Line(points = {{22, -80},{52, -80}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe1.port_b,source2.ports[1]) annotation(Line(points = {{70,20},{70, -6},{80, -6},{80, -22.6667}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe2.port_b,source2.ports[2]) annotation(Line(points = {{70, -20},{80, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe3.port_b,source2.ports[3]) annotation(Line(points = {{72, -80},{76, -80},{76, -17.3333},{80, -17.3333}}, color = {0,127,255}, smooth = Smooth.None));
          connect(source1.ports[2],traceSubstance.port) annotation(Line(points = {{ -48, -18},{ -44, -18},{ -44,18}}, color = {0,127,255}, smooth = Smooth.None));
          connect(source1.ports[1],multiPort.port_a) annotation(Line(points = {{ -48, -15.3333},{ -44, -15.3333},{ -44,0},{ -36,0}}, color = {0,127,255}, smooth = Smooth.None));
          connect(source1.ports[3],pipe6.port_a) annotation(Line(points = {{ -48, -20.6667},{ -32, -20.6667},{ -32, -80},{ -16, -80}}, color = {0,127,255}, smooth = Smooth.None));
          connect(multiPort.ports_b[1],pipe4.port_a) annotation(Line(points = {{ -28,2},{ -22,2},{ -22,20},{ -16,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(multiPort.ports_b[2],pipe5.port_a) annotation(Line(points = {{ -28, -2},{ -22, -2},{ -22, -20},{ -16, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe4.port_b,volume1.ports[1]) annotation(Line(points = {{4,20},{19.3333,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe5.port_b,volume2.ports[1]) annotation(Line(points = {{4, -20},{19.3333, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe6.port_b,volume3.ports[1]) annotation(Line(points = {{4, -80},{19.3333, -80}}, color = {0,127,255}, smooth = Smooth.None));
        end TestMultiPortTraceSubstances;
        model TestMultiPort
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          Modelica.Fluid.Fittings.MultiPort multiPort(nPorts_b = 2, redeclare package Medium = Modelica.Media.Air.MoistAir) annotation(Placement(transformation(extent = {{ -28, -30},{ -20, -10}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics));
          Modelica.Fluid.Sources.Boundary_pT source2(nPorts = 1, T = 278.15, p = 500000.0, redeclare package Medium = Modelica.Media.Air.MoistAir) annotation(Placement(transformation(origin = {80, -20}, extent = {{ -10, -10},{10,10}}, rotation = 180)));
          Modelica.Fluid.Sources.Boundary_pT source3(nPorts = 1, T = 283.15, p = 200000.0, redeclare package Medium = Modelica.Media.Air.MoistAir) annotation(Placement(transformation(origin = {10,70}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT source1(nPorts = 1, T = system.T_ambient, use_p_in = true, redeclare package Medium = Modelica.Media.Air.MoistAir, p = 500000) annotation(Placement(transformation(extent = {{ -60, -30},{ -40, -10}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp ramp(duration = 1, height =  -650000.0, offset = 700000.0) annotation(Placement(transformation(extent = {{ -10, -10},{10,10}}, rotation = 270, origin = { -80,10})));
          Modelica.Fluid.Pipes.StaticPipe pipe1(length = 1, diameter = 0.1, redeclare package Medium = Modelica.Media.Air.MoistAir) annotation(Placement(transformation(extent = {{40, -30},{60, -10}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe2(length = 1, diameter = 0.1, redeclare package Medium = Modelica.Media.Air.MoistAir) annotation(Placement(transformation(origin = {10,24}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

        equation 
          connect(ramp.y,source1.p_in) annotation(Line(points = {{ -80, -1},{ -80, -1},{ -80, -12},{ -62, -12}}, color = {0,0,127}));
          connect(pipe1.port_b,source2.ports[1]) annotation(Line(points = {{60, -20},{70, -20}}, color = {0,127,255}));
          connect(pipe2.port_b,source3.ports[1]) annotation(Line(points = {{10,34},{10,47},{10,60}}, color = {0,127,255}));
          connect(multiPort.ports_b[1],pipe2.port_a) annotation(Line(points = {{ -20, -18},{10, -18},{10,14}}, color = {0,127,255}, smooth = Smooth.None));
          connect(multiPort.ports_b[2],pipe1.port_a) annotation(Line(points = {{ -20, -22},{35, -22},{35, -20},{40, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(source1.ports[1],multiPort.port_a) annotation(Line(points = {{ -40, -20},{ -28, -20}}, color = {0,127,255}, smooth = Smooth.None));
        end TestMultiPort;
        model TestJunctionVolume
          extends Modelica.Icons.Example;
          Modelica.Fluid.Fittings.TeeJunctionVolume junction(redeclare package Medium = Modelica.Media.Air.DryAirNasa, V = 2e-05, energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, massDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial, p_start = 100000) annotation(Placement(transformation(extent = {{20, -30},{40, -10}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
          Modelica.Fluid.Sources.Boundary_pT source2(nPorts = 1, T = 278.15, p = 500000.0, redeclare package Medium = Modelica.Media.Air.DryAirNasa) annotation(Placement(transformation(origin = {90, -20}, extent = {{ -10, -10},{10,10}}, rotation = 180)));
          Modelica.Fluid.Sources.Boundary_pT source3(nPorts = 1, T = 283.15, p = 200000.0, redeclare package Medium = Modelica.Media.Air.DryAirNasa) annotation(Placement(transformation(origin = {30,70}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT source1(nPorts = 1, p = 500000.0, redeclare package Medium = Modelica.Media.Air.DryAirNasa, T = system.T_ambient, use_p_in = true) annotation(Placement(transformation(extent = {{ -40, -30},{ -20, -10}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp ramp(duration = 1, height =  -650000.0, offset = 700000.0) annotation(Placement(transformation(extent = {{ -90, -24},{ -70, -4}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe(redeclare package Medium = Modelica.Media.Air.DryAirNasa, length = 1, diameter = 0.1) annotation(Placement(transformation(extent = {{ -12, -30},{8, -10}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe1(redeclare package Medium = Modelica.Media.Air.DryAirNasa, length = 1, diameter = 0.1) annotation(Placement(transformation(extent = {{50, -30},{70, -10}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe2(redeclare package Medium = Modelica.Media.Air.DryAirNasa, length = 1, diameter = 0.1) annotation(Placement(transformation(origin = {30,24}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

        equation 
          connect(ramp.y,source1.p_in) annotation(Line(points = {{ -69, -14},{ -55.5, -14},{ -55.5, -12},{ -42, -12}}, color = {0,0,127}));
          connect(source1.ports[1],pipe.port_a) annotation(Line(points = {{ -20, -20},{ -12, -20}}, color = {0,127,255}));
          connect(pipe.port_b,junction.port_1) annotation(Line(points = {{8, -20},{20, -20}}, color = {0,127,255}));
          connect(pipe1.port_b,source2.ports[1]) annotation(Line(points = {{70, -20},{80, -20}}, color = {0,127,255}));
          connect(junction.port_2,pipe1.port_a) annotation(Line(points = {{40, -20},{50, -20}}, color = {0,127,255}));
          connect(pipe2.port_b,source3.ports[1]) annotation(Line(points = {{30,34},{30,47},{30,60},{30,60}}, color = {0,127,255}));
          connect(pipe2.port_a,junction.port_3) annotation(Line(points = {{30,14},{30, -10}}, color = {0,127,255}));
        end TestJunctionVolume;
        model TestJunctionTraceSubstances
          import Modelica.Fluid;
          extends Modelica.Icons.Example;
          package Medium = Modelica.Media.Air.MoistAir(extraPropertiesNames = {"CO2"});
          Modelica.Fluid.Fittings.TeeJunctionIdeal junction(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{0, -30},{20, -10}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics));
          Modelica.Fluid.Sources.Boundary_pT source2(nPorts = 1, T = 278.15, redeclare package Medium = Medium, p = 100000, X = Medium.X_default) annotation(Placement(transformation(origin = {90, -20}, extent = {{ -10, -10},{10,10}}, rotation = 180)));
          Modelica.Fluid.Sources.Boundary_pT source3(nPorts = 1, T = 283.15, redeclare package Medium = Medium, p = 100000, X = Medium.X_default) annotation(Placement(transformation(origin = { -30,70}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT source1(T = system.T_ambient, use_p_in = true, redeclare package Medium = Medium, use_C_in = true, use_X_in = true, nPorts = 1, p = 500000) annotation(Placement(transformation(extent = {{ -68, -28},{ -48, -8}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp ramp(duration = 1, height =  -40, offset = 100000.0 + 20) annotation(Placement(transformation(extent = {{ -100,24},{ -80,44}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe1(length = 1, diameter = 0.1, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -24, -30},{ -4, -10}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe2(length = 1, diameter = 0.1, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{56, -30},{76, -10}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe3(length = 1, diameter = 0.1, redeclare package Medium = Medium) annotation(Placement(transformation(origin = { -30,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
          Modelica.Fluid.Fittings.TeeJunctionVolume junction1(redeclare package Medium = Medium, V = 0.1, C_start = {0.0001}, massDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, X_start = Medium.X_default) annotation(Placement(transformation(extent = {{30, -30},{50, -10}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT source4(nPorts = 1, T = 283.15, redeclare package Medium = Medium, p = 100000, X = Medium.X_default) annotation(Placement(transformation(origin = {10,70}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
          Modelica.Fluid.Pipes.StaticPipe pipe4(length = 1, diameter = 0.1, redeclare package Medium = Medium) annotation(Placement(transformation(origin = {10,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
          Modelica.Fluid.Sources.Boundary_pT source5(nPorts = 1, T = 283.15, redeclare package Medium = Medium, p = 100000, X = Medium.X_default) annotation(Placement(transformation(origin = {40,70}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
          Modelica.Fluid.Pipes.StaticPipe pipe5(length = 1, diameter = 0.1, redeclare package Medium = Medium) annotation(Placement(transformation(origin = {40,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance2(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{56,4},{76,24}})));
          Modelica.Fluid.Sensors.TraceSubstances traceSubstance(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -70,16},{ -50,36}})));
          Modelica.Blocks.Sources.Ramp C(duration = 1, height = 0.001519) "substance concentration, raising to 1000 PPM CO2" annotation(Placement(transformation(extent = {{ -100, -60},{ -80, -40}})));
          Modelica.Blocks.Sources.Constant X(k = 0.02) annotation(Placement(transformation(extent = {{ -100, -8},{ -80,12}})));
          Modelica.Blocks.Sources.RealExpression X2(y = 1 - X.y) "Concentration of X[2]" annotation(Placement(transformation(extent = {{ -100, -32},{ -80, -12}})));
          Modelica.Fluid.Fittings.MultiPort multiPort(redeclare package Medium = Medium, nPorts_b = 2) annotation(Placement(transformation(extent = {{ -42, -28},{ -34, -8}})));

        equation 
          connect(ramp.y,source1.p_in) annotation(Line(points = {{ -79,34},{ -74,34},{ -74, -10},{ -70, -10}}, color = {0,0,127}));
          connect(pipe1.port_b,junction.port_1) annotation(Line(points = {{ -4, -20},{0, -20}}, color = {0,127,255}));
          connect(pipe2.port_b,source2.ports[1]) annotation(Line(points = {{76, -20},{76, -20},{80, -20}}, color = {0,127,255}));
          connect(junction.port_2,junction1.port_1) annotation(Line(points = {{20, -20},{30, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(junction1.port_2,pipe2.port_a) annotation(Line(points = {{50, -20},{56, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe3.port_b,source3.ports[1]) annotation(Line(points = {{ -30,40},{ -30,60}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe4.port_a,junction.port_3) annotation(Line(points = {{10,20},{10, -10}}, color = {0,127,255}, smooth = Smooth.None));
          connect(source4.ports[1],pipe4.port_b) annotation(Line(points = {{10,60},{10,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(source5.ports[1],pipe5.port_b) annotation(Line(points = {{40,60},{40,40}}, color = {0,127,255}, smooth = Smooth.None));
          connect(pipe5.port_a,junction1.port_3) annotation(Line(points = {{40,20},{40, -10}}, color = {0,127,255}, smooth = Smooth.None));
          connect(traceSubstance.port,pipe1.port_a) annotation(Line(points = {{ -60,16},{ -28,16},{ -28, -20},{ -24, -20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(C.y,source1.C_in[1]) annotation(Line(points = {{ -79, -50},{ -76, -50},{ -76, -26},{ -70, -26}}, color = {0,0,127}, smooth = Smooth.None));
          connect(pipe2.port_a,traceSubstance2.port) annotation(Line(points = {{56, -20},{54, -20},{54,4},{66,4}}, color = {0,127,255}, smooth = Smooth.None));
          connect(X.y,source1.X_in[1]) annotation(Line(points = {{ -79,2},{ -76,2},{ -76, -22},{ -70, -22}}, color = {0,0,127}, smooth = Smooth.None));
          connect(X2.y,source1.X_in[2]) annotation(Line(points = {{ -79, -22},{ -70, -22}}, color = {0,0,127}, smooth = Smooth.None));
          connect(source1.ports[1],multiPort.port_a) annotation(Line(points = {{ -48, -18},{ -42, -18}}, color = {0,127,255}, smooth = Smooth.None));
          connect(multiPort.ports_b[1],pipe3.port_a) annotation(Line(points = {{ -34, -16},{ -30, -16},{ -30,20}}, color = {0,127,255}, smooth = Smooth.None));
          connect(multiPort.ports_b[2],pipe1.port_a) annotation(Line(points = {{ -34, -20},{ -24, -20}}, color = {0,127,255}, smooth = Smooth.None));
        end TestJunctionTraceSubstances;
        model TestJunctionIdeal
          extends Modelica.Icons.Example;
          Modelica.Fluid.Fittings.TeeJunctionIdeal junction(redeclare package Medium = Modelica.Media.Air.DryAirNasa) annotation(Placement(transformation(extent = {{20, -30},{40, -10}}, rotation = 0)));
          annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
          Modelica.Fluid.Sources.Boundary_pT source2(nPorts = 1, T = 278.15, p = 500000.0, redeclare package Medium = Modelica.Media.Air.DryAirNasa) annotation(Placement(transformation(origin = {90, -20}, extent = {{ -10, -10},{10,10}}, rotation = 180)));
          Modelica.Fluid.Sources.Boundary_pT source3(nPorts = 1, T = 283.15, p = 200000.0, redeclare package Medium = Modelica.Media.Air.DryAirNasa) annotation(Placement(transformation(origin = {30,70}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
          inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}}, rotation = 0)));
          Modelica.Fluid.Sources.Boundary_pT source1(nPorts = 1, p = 500000.0, redeclare package Medium = Modelica.Media.Air.DryAirNasa, T = system.T_ambient, use_p_in = true) annotation(Placement(transformation(extent = {{ -40, -30},{ -20, -10}}, rotation = 0)));
          Modelica.Blocks.Sources.Ramp ramp(duration = 1, height =  -650000.0, offset = 700000.0) annotation(Placement(transformation(extent = {{ -90, -24},{ -70, -4}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe1(redeclare package Medium = Modelica.Media.Air.DryAirNasa, length = 1, diameter = 0.1) annotation(Placement(transformation(extent = {{ -12, -30},{8, -10}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe2(redeclare package Medium = Modelica.Media.Air.DryAirNasa, length = 1, diameter = 0.1) annotation(Placement(transformation(extent = {{50, -30},{70, -10}}, rotation = 0)));
          Modelica.Fluid.Pipes.StaticPipe pipe3(redeclare package Medium = Modelica.Media.Air.DryAirNasa, length = 1, diameter = 0.1) annotation(Placement(transformation(origin = {30,24}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

        equation 
          connect(ramp.y,source1.p_in) annotation(Line(points = {{ -69, -14},{ -55.5, -14},{ -55.5, -12},{ -42, -12}}, color = {0,0,127}));
          connect(source1.ports[1],pipe1.port_a) annotation(Line(points = {{ -20, -20},{ -12, -20}}, color = {0,127,255}));
          connect(pipe1.port_b,junction.port_1) annotation(Line(points = {{8, -20},{20, -20}}, color = {0,127,255}));
          connect(pipe2.port_b,source2.ports[1]) annotation(Line(points = {{70, -20},{80, -20}}, color = {0,127,255}));
          connect(junction.port_2,pipe2.port_a) annotation(Line(points = {{40, -20},{50, -20}}, color = {0,127,255}));
          connect(pipe3.port_b,source3.ports[1]) annotation(Line(points = {{30,34},{30,47},{30,60},{30,60}}, color = {0,127,255}));
          connect(pipe3.port_a,junction.port_3) annotation(Line(points = {{30,14},{30, -10}}, color = {0,127,255}));
        end TestJunctionIdeal;
      end Fittings;
    end TestComponents;
    package TestOverdeterminedInitial "Contains test cases to test overdetermined systems of initial equations"
      model DynamicPipeLumpedPressureInitialization "Steady-state initialization of a dynamic pipe using lumped pressure states"
        Modelica.Fluid.Sources.FixedBoundary source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_T = false, p = 10000000, h = 2000000.0) annotation(Placement(transformation(extent = {{ -80, -10},{ -60,10}})));
        Modelica.Fluid.Pipes.DynamicPipe pipe(redeclare package Medium = Modelica.Media.Water.StandardWater, h_start = 2000000.0, diameter = 0.05, length = 200, use_T_start = false, useLumpedPressure = true, nNodes = 5, p_a_start = 10000000, p_b_start = 9900000, modelStructure = Modelica.Fluid.Types.ModelStructure.a_vb) annotation(Placement(transformation(extent = {{ -40, -10},{ -20,10}})));
        Modelica.Fluid.Valves.ValveCompressible valve(redeclare package Medium = Modelica.Media.Water.StandardWater, Av = 0.001, dp_nominal = 10000000, m_flow_nominal = 10) annotation(Placement(transformation(extent = {{0, -10},{20,10}})));
        Modelica.Fluid.Sources.FixedBoundary sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, p = 9500000) annotation(Placement(transformation(extent = {{60, -10},{40,10}})));
        Modelica.Blocks.Sources.Ramp ramp(offset = 1, duration = 0.1, height =  -0.5, startTime = 2) annotation(Placement(transformation(extent = {{46,30},{26,50}})));
        inner Modelica.Fluid.System system(energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial) annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}})));
        discrete Modelica.SIunits.MassFlowRate m_flow_initial;

      equation 
        when time > 0.1 then
                  m_flow_initial = valve.port_a.m_flow;
        
        end when;
if pipe.energyDynamics >= Modelica.Fluid.Types.Dynamics.SteadyStateInitial and pipe.massDynamics >= Modelica.Fluid.Types.Dynamics.SteadyStateInitial then
                  when time > 1 then
                      assert(abs(valve.port_a.m_flow - m_flow_initial) < 0.001, "!!!THE SIMULATION DID NOT START IN STEADY-STATE!!!");
          
          end when;
        end if;
        connect(source.ports[1],pipe.port_a) annotation(Line(points = {{ -60,0},{ -40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(pipe.port_b,valve.port_a) annotation(Line(points = {{ -20,0},{0,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(valve.port_b,sink.ports[1]) annotation(Line(points = {{20,0},{40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(ramp.y,valve.opening) annotation(Line(points = {{25,40},{10,40},{10,8}}, color = {0,0,127}, smooth = Smooth.None));
        annotation(Documentation(info = "<html>
All pressure states of the pipe are lumped into one.
The steady-state initial conditions become overdetermined as they are now specified nNodes times for the same pressure state.
The initial equations are consistent however and a tool shall reduce them appropriately.
</html>"), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics = {Text(extent = {{ -100, -20},{100, -40}}, lineColor = {0,0,255}, textString = "Problem: pipe.medium.p[1:5] are equal and have initial equations der(medium.p)=zeros(5);"),Text(extent = {{ -76, -40},{80, -58}}, lineColor = {0,0,255}, textString = "A translator should remove consistently overdetermined initial equations.")}), experiment(StopTime = 4), experimentSetupOutput);
      end DynamicPipeLumpedPressureInitialization;
      model DynamicPipeInitialValues "Initialization of a dynamic pipe with fixed initial values and without adaptation of modelStructure to boundaries"
        Modelica.Fluid.Sources.FixedBoundary source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_T = false, h = 2000000.0, p = 10000000) annotation(Placement(transformation(extent = {{ -80, -10},{ -60,10}})));
        Modelica.Fluid.Pipes.DynamicPipe pipe(redeclare package Medium = Modelica.Media.Water.StandardWater, h_start = 2000000.0, diameter = 0.05, length = 200, use_T_start = false, nNodes = 5, modelStructure = Modelica.Fluid.Types.ModelStructure.av_vb, p_a_start = 10000000, p_b_start = 9900000) annotation(Placement(transformation(extent = {{ -40, -10},{ -20,10}})));
        Modelica.Fluid.Valves.ValveCompressible valve(redeclare package Medium = Modelica.Media.Water.StandardWater, Av = 0.001, dp_nominal = 10000000, m_flow_nominal = 10) annotation(Placement(transformation(extent = {{0, -10},{20,10}})));
        Modelica.Fluid.Sources.FixedBoundary sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, p = 9500000) annotation(Placement(transformation(extent = {{60, -10},{40,10}})));
        Modelica.Blocks.Sources.Ramp ramp(offset = 1, duration = 0.1, height =  -0.5, startTime = 2) annotation(Placement(transformation(extent = {{46,30},{26,50}})));
        inner Modelica.Fluid.System system(energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial) annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}})));
        discrete Modelica.SIunits.MassFlowRate m_flow_initial;

      equation 
        when time > 0.1 then
                  m_flow_initial = valve.port_a.m_flow;
        
        end when;
if pipe.energyDynamics >= Modelica.Fluid.Types.Dynamics.SteadyStateInitial and pipe.massDynamics >= Modelica.Fluid.Types.Dynamics.SteadyStateInitial then
                  when time > 1 then
                      assert(abs(valve.port_a.m_flow - m_flow_initial) < 0.001, "!!!THE SIMULATION DID NOT START IN STEADY-STATE!!!");
          
          end when;
        end if;
        connect(source.ports[1],pipe.port_a) annotation(Line(points = {{ -60,0},{ -40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(pipe.port_b,valve.port_a) annotation(Line(points = {{ -20,0},{0,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(valve.port_b,sink.ports[1]) annotation(Line(points = {{20,0},{40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(ramp.y,valve.opening) annotation(Line(points = {{25,40},{10,40},{10,8}}, color = {0,0,127}, smooth = Smooth.None));
        annotation(Documentation(info = "<html>
The initial values are overdetermined as the first pipe segment is directly connected to a source with fixed pressure.
The initial equations are consistent however and a tool shall reduce them appropriately.
</html>"), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics = {Text(extent = {{ -100, -20},{100, -40}}, lineColor = {0,0,255}, textString = "Problem: pipe.medium[1].p is equal to source.p and  has a consistent initial value  of 100 bar;"),Text(extent = {{ -76, -36},{76, -54}}, lineColor = {0,0,255}, textString = "A translator should remove consistently overdetermined initial equations."),Text(extent = {{ -100, -64},{90, -84}}, lineColor = {0,0,255}, textString = "Work-around 2: change system.energyDynamics from FixedInitial to DynamicFreeInitial"),Text(extent = {{ -100, -54},{42, -74}}, lineColor = {0,0,255}, textString = "Work-around 1: change pipe.modelStructure from av_vb to a_vb")}), experiment(StopTime = 4), experimentSetupOutput);
      end DynamicPipeInitialValues;
    end TestOverdeterminedInitial;
    package TestCriticalCases "Collection of test cases which might be critical for the solvers"
      model IdealMixing1 "Test properties of ideal mixing"
        package Medium = Modelica.Media.IdealGases.MixtureGases.FlueGasSixComponents;
        Modelica.Fluid.Pipes.StaticPipe pipeFriction1(length = 1, diameter = 0.2, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -32, -40},{ -12, -20}}, rotation = 0)));
        Modelica.Fluid.Pipes.StaticPipe pipeFriction2(length = 1, diameter = 0.2, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{12, -40},{32, -20}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 10), experimentSetupOutput);
        Modelica.Fluid.Pipes.StaticPipe pipeFriction3(length = 1, diameter = 0.2, redeclare package Medium = Medium) annotation(Placement(transformation(origin = {0,0}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Fluid.Sources.Boundary_pT boundary1(nPorts = 1, use_p_in = true, use_T_in = true, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -68, -40},{ -48, -20}}, rotation = 0)));
        Modelica.Fluid.Sources.Boundary_pT boundary2(nPorts = 1, use_p_in = false, use_T_in = false, p = 101000, T = 320, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{66, -40},{46, -20}}, rotation = 0)));
        Modelica.Fluid.Sources.Boundary_pT boundary3(nPorts = 1, use_p_in = true, use_T_in = false, T = 340, redeclare package Medium = Medium) annotation(Placement(transformation(origin = {0,30}, extent = {{ -10,10},{10, -10}}, rotation = 270)));
        Modelica.Blocks.Sources.Sine sine1(amplitude = 5000.0, freqHz = 2, offset = 100000.0, phase = 0.013962634015955) annotation(Placement(transformation(extent = {{ -100, -20},{ -80,0}}, rotation = 0)));
        Modelica.Blocks.Sources.Sine sine2(amplitude = 10, freqHz = 1, phase = 0.0017453292519943, offset = 300) annotation(Placement(transformation(extent = {{ -100, -58},{ -80, -38}}, rotation = 0)));
        Modelica.Blocks.Sources.Sine sine3(amplitude = 5000.0, freqHz = 2, offset = 100000.0) annotation(Placement(transformation(origin = {0,70}, extent = {{10, -10},{ -10,10}}, rotation = 90)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -88,60},{ -68,80}}, rotation = 0)));
        Modelica.Fluid.Sensors.Temperature temperature(redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -10, -60},{10, -80}}, rotation = 0)));

      equation 
        connect(pipeFriction1.port_b,pipeFriction2.port_a) annotation(Line(points = {{ -12, -30},{12, -30}}, color = {0,127,255}, smooth = Smooth.None));
        connect(pipeFriction3.port_a,pipeFriction1.port_b) annotation(Line(points = {{ -6.12323e-16, -10},{0, -10},{0, -30},{ -12, -30}}, color = {0,127,255}, smooth = Smooth.None));
        connect(boundary1.ports[1],pipeFriction1.port_a) annotation(Line(points = {{ -48, -30},{ -32, -30}}, color = {0,127,255}, smooth = Smooth.None));
        connect(boundary2.ports[1],pipeFriction2.port_b) annotation(Line(points = {{46, -30},{32, -30}}, color = {0,127,255}, smooth = Smooth.None));
        connect(boundary3.ports[1],pipeFriction3.port_b) annotation(Line(points = {{ -1.9984e-15,20},{ -1.9984e-15,10},{6.12323e-16,10}}, color = {0,127,255}, smooth = Smooth.None));
        connect(sine1.y,boundary1.p_in) annotation(Line(points = {{ -79, -10},{ -76, -10},{ -76, -22},{ -70, -22}}, color = {0,0,127}, smooth = Smooth.None));
        connect(sine2.y,boundary1.T_in) annotation(Line(points = {{ -79, -48},{ -76, -48},{ -76, -26},{ -70, -26}}, color = {0,0,127}, smooth = Smooth.None));
        connect(sine3.y,boundary3.p_in) annotation(Line(points = {{ -6.73556e-16,59},{ -6.73556e-16,50.5},{ -8,50.5},{ -8,42}}, color = {0,0,127}, smooth = Smooth.None));
        connect(temperature.port,pipeFriction3.port_a) annotation(Line(points = {{0, -60},{0, -10},{ -6.12323e-16, -10}}, color = {0,127,255}, smooth = Smooth.None));
      end IdealMixing1;
      model DynamicPipeClosingValve "This test demonstrates the importance of smooth regularization of fluid properties for reversing flow.
 A DynamicPipe model with switching port densities and viscosities would generate lots of events as the valve closes at time 2."
        annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 3));
        Modelica.Fluid.Sources.FixedBoundary source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 200000) annotation(Placement(transformation(extent = {{ -80, -10},{ -60,10}})));
        Modelica.Fluid.Pipes.DynamicPipe pipe(redeclare package Medium = Modelica.Media.Water.StandardWater, length = 1, diameter = 0.32, use_T_start = false, p_a_start = 200000, p_b_start = 200000) annotation(Placement(transformation(extent = {{ -40, -10},{ -20,10}})));
        Modelica.Fluid.Valves.ValveIncompressible valve(redeclare package Medium = Modelica.Media.Water.StandardWater, m_flow_nominal = 10, Av = 0.001, dp_nominal = 100000) annotation(Placement(transformation(extent = {{0, -10},{20,10}})));
        Modelica.Fluid.Sources.FixedBoundary sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, p = 100000) annotation(Placement(transformation(extent = {{60, -10},{40,10}})));
        Modelica.Blocks.Sources.Ramp ramp(height =  -1, offset = 1, duration = 1, startTime = 1) annotation(Placement(transformation(extent = {{46,30},{26,50}})));
        inner Modelica.Fluid.System system(energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial) annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}})));

      equation 
        connect(source.ports[1],pipe.port_a) annotation(Line(points = {{ -60,0},{ -40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(pipe.port_b,valve.port_a) annotation(Line(points = {{ -20,0},{0,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(valve.port_b,sink.ports[1]) annotation(Line(points = {{20,0},{40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(ramp.y,valve.opening) annotation(Line(points = {{25,40},{10,40},{10,8}}, color = {0,0,127}, smooth = Smooth.None));
      end DynamicPipeClosingValve;
      model DynamicPipeInitialization "Steady-state initialization of a dynamic pipe"
        Modelica.Fluid.Sources.FixedBoundary source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_T = false, p = 10000000, h = 2000000.0) annotation(Placement(transformation(extent = {{ -80, -10},{ -60,10}})));
        Modelica.Fluid.Pipes.DynamicPipe pipe(redeclare package Medium = Modelica.Media.Water.StandardWater, nNodes = 5, h_start = 2000000.0, diameter = 0.05, length = 200, use_T_start = false, p_a_start = 10000000, p_b_start = 9900000, modelStructure = Modelica.Fluid.Types.ModelStructure.a_vb) annotation(Placement(transformation(extent = {{ -40, -10},{ -20,10}})));
        Modelica.Fluid.Valves.ValveCompressible valve(redeclare package Medium = Modelica.Media.Water.StandardWater, Av = 0.001, dp_nominal = 10000000, m_flow_nominal = 10) annotation(Placement(transformation(extent = {{0, -10},{20,10}})));
        Modelica.Fluid.Sources.FixedBoundary sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, p = 9500000) annotation(Placement(transformation(extent = {{60, -10},{40,10}})));
        Modelica.Blocks.Sources.Ramp ramp(offset = 1, duration = 0.1, height =  -0.5, startTime = 2) annotation(Placement(transformation(extent = {{46,30},{26,50}})));
        inner Modelica.Fluid.System system(energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial) annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}})));
        discrete Modelica.SIunits.MassFlowRate m_flow_initial;

      equation 
        when time > 0.1 then
                  m_flow_initial = valve.port_a.m_flow;
        
        end when;
if pipe.energyDynamics >= Modelica.Fluid.Types.Dynamics.SteadyStateInitial and pipe.massDynamics >= Modelica.Fluid.Types.Dynamics.SteadyStateInitial then
                  when time > 1 then
                      assert(abs(valve.port_a.m_flow - m_flow_initial) < 0.001, "!!!THE SIMULATION DID NOT START IN STEADY-STATE!!!");
          
          end when;
        end if;
        connect(source.ports[1],pipe.port_a) annotation(Line(points = {{ -60,0},{ -40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(pipe.port_b,valve.port_a) annotation(Line(points = {{ -20,0},{0,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(valve.port_b,sink.ports[1]) annotation(Line(points = {{20,0},{40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(ramp.y,valve.opening) annotation(Line(points = {{25,40},{10,40},{10,8}}, color = {0,0,127}, smooth = Smooth.None));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 4), experimentSetupOutput, Documentation(info = "<html>
The simulation shall start in steady-state (see system.energyDynamics on the Assumptions tab).
This requires the solution of an equation system with complex non-linear expressions for the
pipe wall friction and compressible valve characteristics. A ValveCompressible defined with Modelica.Fluid.Utilities.regRoot2 for the treatment of flow reversal
(cf. Modelica.Fluid Stream beta3) leads to wrong initial values. It works with Modelica.Fluid.Utilities.regRoot and a smooth(0, ...) expression for flow reversal.
<p>
The steady-state initial values are observed by an assertion.
</p>
</html>"));
      end DynamicPipeInitialization;
      model BranchingPipes1
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 200000, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, p_b_start = 100000, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow, p_a_start = 200000, T_start = 300) annotation(Placement(transformation(extent = {{ -72, -4},{ -52,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, rho_nominal = 1000, dp_nominal = 200000) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve2(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, rho_nominal = 1000, dp_nominal = 200000) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(redeclare package Medium = Medium, nPorts = 2, p = 100000, T = 300) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow, p_a_start = 200000, p_b_start = 100000, T_start = 300) annotation(Placement(transformation(extent = {{ -40,36},{ -20,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow, p_a_start = 200000, p_b_start = 100000, T_start = 300) annotation(Placement(transformation(extent = {{ -40, -50},{ -20, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;1,0;100,0]) annotation(Placement(transformation(extent = {{ -20,70},{0,90}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,1;2,1;2,0;100,0]) annotation(Placement(transformation(extent = {{ -20, -10},{0,10}}, rotation = 0)));
        inner Modelica.Fluid.System system(energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, massDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial) annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -72,6}}, color = {0,127,255}));
        connect(valve2.port_b,sink.ports[2]) annotation(Line(points = {{28, -40},{46, -40},{46, -15.2},{62, -15.2}}, color = {0,127,255}));
        connect(valve1.port_b,sink.ports[1]) annotation(Line(points = {{30,46},{46,46},{46, -12.8},{62, -12.8}}, color = {0,127,255}));
        connect(pipe3.port_b,valve2.port_a) annotation(Line(points = {{ -20, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valve1.port_a) annotation(Line(points = {{ -20,46},{10,46}}, color = {0,127,255}));
        connect(pipe2.port_a,pipe1.port_b) annotation(Line(points = {{ -40,46},{ -46,46},{ -46,6},{ -52,6}}, color = {0,127,255}));
        connect(pipe1.port_b,pipe3.port_a) annotation(Line(points = {{ -52,6},{ -46,6},{ -46, -40},{ -40, -40}}, color = {0,127,255}));
        connect(valveOpening1.y,valve1.opening) annotation(Line(points = {{1,80},{20,80},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valve2.opening) annotation(Line(points = {{1,0},{18,0},{18, -32}}, color = {0,0,127}));
      end BranchingPipes1;
      model BranchingPipes2
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 10, diameter = 0.0254, p_a_start = 500000.0, p_b_start = 500000.0) annotation(Placement(transformation(extent = {{ -72, -4},{ -52,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 1000) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 1000) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(redeclare package Medium = Medium, nPorts = 2, p = 100000, T = 300) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 10, diameter = 0.0254, p_a_start = 500000.0, p_b_start = 500000.0) annotation(Placement(transformation(extent = {{ -40,36},{ -20,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 10, diameter = 0.0254, p_a_start = 500000.0, p_b_start = 500000.0) annotation(Placement(transformation(extent = {{ -40, -50},{ -20, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,0;1,0;1,1;100,1]) annotation(Placement(transformation(extent = {{ -20,70},{0,90}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,0;2,0;2,1;100,1]) annotation(Placement(transformation(extent = {{ -20, -10},{0,10}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -72,6}}, color = {0,127,255}));
        connect(valveIncompressible1.port_b,sink.ports[2]) annotation(Line(points = {{28, -40},{46, -40},{46, -15.2},{62, -15.2}}, color = {0,127,255}));
        connect(valveIncompressible.port_b,sink.ports[1]) annotation(Line(points = {{30,46},{46,46},{46, -12.8},{62, -12.8}}, color = {0,127,255}));
        connect(pipe3.port_b,valveIncompressible1.port_a) annotation(Line(points = {{ -20, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valveIncompressible.port_a) annotation(Line(points = {{ -20,46},{10,46}}, color = {0,127,255}));
        connect(pipe2.port_a,pipe1.port_b) annotation(Line(points = {{ -40,46},{ -46,46},{ -46,6},{ -52,6}}, color = {0,127,255}));
        connect(pipe1.port_b,pipe3.port_a) annotation(Line(points = {{ -52,6},{ -46,6},{ -46, -40},{ -40, -40}}, color = {0,127,255}));
        connect(valveOpening1.y,valveIncompressible.opening) annotation(Line(points = {{1,80},{20,80},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valveIncompressible1.opening) annotation(Line(points = {{1,0},{18,0},{18, -32}}, color = {0,0,127}));
      end BranchingPipes2;
      model BranchingPipes3
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, p_a_start = 500000.0, p_b_start = 500000.0, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 10, diameter = 0.0254) annotation(Placement(transformation(extent = {{ -80, -4},{ -60,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 1000) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 1000) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(redeclare package Medium = Medium, nPorts = 2, p = 100000, T = 300) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, p_a_start = 500000.0, p_b_start = 500000.0, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 10, diameter = 0.0254) annotation(Placement(transformation(extent = {{ -40,36},{ -20,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, p_a_start = 500000.0, p_b_start = 500000.0, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 10, diameter = 0.0254) annotation(Placement(transformation(extent = {{ -40, -50},{ -20, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,0;1,0;1,1;100,1]) annotation(Placement(transformation(extent = {{ -20,70},{0,90}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,0;2,0;2,1;100,1]) annotation(Placement(transformation(extent = {{ -20, -10},{0,10}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
        Modelica.Fluid.Fittings.TeeJunctionIdeal splitter(redeclare package Medium = Medium) annotation(Placement(transformation(origin = { -43,6}, extent = {{ -6, -7},{6,7}}, rotation = 90)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -80,6}}, color = {0,127,255}));
        connect(valveIncompressible1.port_b,sink.ports[2]) annotation(Line(points = {{28, -40},{46, -40},{46, -15.2},{62, -15.2}}, color = {0,127,255}));
        connect(valveIncompressible.port_b,sink.ports[1]) annotation(Line(points = {{30,46},{46,46},{46, -12.8},{62, -12.8}}, color = {0,127,255}));
        connect(pipe3.port_b,valveIncompressible1.port_a) annotation(Line(points = {{ -20, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valveIncompressible.port_a) annotation(Line(points = {{ -20,46},{10,46}}, color = {0,127,255}));
        connect(valveOpening1.y,valveIncompressible.opening) annotation(Line(points = {{1,80},{20,80},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valveIncompressible1.opening) annotation(Line(points = {{1,0},{18,0},{18, -32}}, color = {0,0,127}));
        connect(pipe1.port_b,splitter.port_3) annotation(Line(points = {{ -60,6},{ -55,6},{ -55,6},{ -50,6}}, color = {0,127,255}));
        connect(pipe2.port_a,splitter.port_2) annotation(Line(points = {{ -40,46},{ -43,46},{ -43,12}}, color = {0,127,255}));
        connect(splitter.port_1,pipe3.port_a) annotation(Line(points = {{ -43,0},{ -43, -40.3},{ -40, -40.3},{ -40, -40}}, color = {0,127,255}));
      end BranchingPipes3;
      model BranchingPipes4
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow, p_a_start = 500000, p_b_start = 500000) annotation(Placement(transformation(extent = {{ -80, -4},{ -60,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 1000) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 1000) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Uses dynamic splitter. Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes. The simulation fails at t=0 due to lack of initialization of the splitter state variables.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(redeclare package Medium = Medium, nPorts = 2, p = 100000, T = 300) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow, p_a_start = 500000, p_b_start = 500000) annotation(Placement(transformation(extent = {{ -40,36},{ -20,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow, p_a_start = 500000, p_b_start = 500000) annotation(Placement(transformation(extent = {{ -40, -50},{ -20, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,0;1,0;1,1;100,1]) annotation(Placement(transformation(extent = {{ -20,70},{0,90}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,0;2,0;2,1;100,1]) annotation(Placement(transformation(extent = {{ -20, -10},{0,10}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
        Modelica.Fluid.Fittings.TeeJunctionVolume splitter(redeclare package Medium = Medium, V = 0.0002, energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, massDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, p_start = 500000) annotation(Placement(transformation(origin = { -43,6}, extent = {{ -6, -7},{6,7}}, rotation = 90)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -80,6}}, color = {0,127,255}));
        connect(valveIncompressible1.port_b,sink.ports[2]) annotation(Line(points = {{28, -40},{46, -40},{46, -15.2},{62, -15.2}}, color = {0,127,255}));
        connect(valveIncompressible.port_b,sink.ports[1]) annotation(Line(points = {{30,46},{46,46},{46, -12.8},{62, -12.8}}, color = {0,127,255}));
        connect(pipe3.port_b,valveIncompressible1.port_a) annotation(Line(points = {{ -20, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valveIncompressible.port_a) annotation(Line(points = {{ -20,46},{10,46}}, color = {0,127,255}));
        connect(valveOpening1.y,valveIncompressible.opening) annotation(Line(points = {{1,80},{20,80},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valveIncompressible1.opening) annotation(Line(points = {{1,0},{18,0},{18, -32}}, color = {0,0,127}));
        connect(pipe1.port_b,splitter.port_3) annotation(Line(points = {{ -60,6},{ -55,6},{ -55,6},{ -50,6}}, color = {0,127,255}));
        connect(pipe2.port_a,splitter.port_2) annotation(Line(points = {{ -40,46},{ -43,46},{ -43,12}}, color = {0,127,255}));
        connect(splitter.port_1,pipe3.port_a) annotation(Line(points = {{ -43,0},{ -43, -40.3},{ -40, -40.3},{ -40, -40}}, color = {0,127,255}));
      end BranchingPipes4;
      model SeriesPipes1
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000, T = 300) annotation(Placement(transformation(extent = {{ -100, -6},{ -88,6}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(use_T_start = true, length = 10, diameter = 0.025, redeclare package Medium = Medium, p_a_start = 500000, p_b_start = 500000) annotation(Placement(transformation(extent = {{ -76, -10},{ -56,10}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible(CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, rho_nominal = 1000, redeclare package Medium = Medium, dp_nominal = 400000) annotation(Placement(transformation(extent = {{52, -10},{72,10}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with the valve open. At t=1, the valve is closed, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(nPorts = 1, redeclare package Medium = Medium, p = 100000, T = 300) annotation(Placement(transformation(extent = {{94, -6},{82,6}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(use_T_start = true, length = 10, diameter = 0.025, redeclare package Medium = Medium, p_a_start = 500000, p_b_start = 500000) annotation(Placement(transformation(extent = {{ -14, -10},{6,10}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;1,0;100,0]) annotation(Placement(transformation(extent = {{ -20,70},{0,90}}, rotation = 0)));
        inner Modelica.Fluid.System system(energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial) annotation(Placement(transformation(extent = {{ -90,70},{ -70,90}}, rotation = 0)));
        Modelica.Fluid.Fittings.SimpleGenericOrifice simpleGenericOrifice(zeta = 0.4, diameter = 0.025, redeclare package Medium = Medium) annotation(Placement(transformation(extent = {{ -46, -10},{ -26,10}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(use_T_start = true, length = 10, diameter = 0.025, redeclare package Medium = Medium, p_a_start = 500000, p_b_start = 500000) annotation(Placement(transformation(extent = {{16, -10},{36,10}}, rotation = 0)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,0},{ -76,0}}, color = {0,127,255}));
        connect(valveIncompressible.port_b,sink.ports[1]) annotation(Line(points = {{72,0},{82,0}}, color = {0,127,255}));
        connect(valveOpening1.y,valveIncompressible.opening) annotation(Line(points = {{1,80},{62,80},{62,8}}, color = {0,0,127}));
        connect(pipe1.port_b,simpleGenericOrifice.port_a) annotation(Line(points = {{ -56,0},{ -46,0}}, color = {0,127,255}));
        connect(pipe2.port_a,simpleGenericOrifice.port_b) annotation(Line(points = {{ -14,0},{ -26,0}}, color = {0,127,255}));
        connect(pipe2.port_b,pipe3.port_a) annotation(Line(points = {{6,0},{16,0}}, color = {0,127,255}));
        connect(pipe3.port_b,valveIncompressible.port_a) annotation(Line(points = {{36,0},{52,0}}, color = {0,127,255}));
      end SeriesPipes1;
      model SeriesPipes12
        extends SeriesPipes1(system(energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyStateInitial));

      equation 
        annotation(Documentation(info = "<html>
Same as SeriesPipes1, but with steady-state initial conditions. Equal start attributes
for pressures. Initialization fails.
</html>"));
      end SeriesPipes12;
      model SeriesPipes13
        extends SeriesPipes1(pipe2(p_a_start = 495000, p_b_start = 495000), pipe3(p_a_start = 490000, p_b_start = 490000));

      equation 
        annotation(Documentation(info = "<html>
Same as SeriesPipes1, but with steady-state initial conditions. Start attributes for
pressure in order to get positive flow rates. Initialization succeeds, then the simulation
fails for zero flow rate.
</html>"), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
      end SeriesPipes13;
      model BranchingPipes12
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, p_a_start = 500000.0, use_T_start = true, length = 10, diameter = 0.0254, p_b_start = 495000.0, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow) annotation(Placement(transformation(extent = {{ -78, -4},{ -58,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 1000) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 1000) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(redeclare package Medium = Medium, nPorts = 2, p = 100000, T = 300) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow) annotation(Placement(transformation(extent = {{ -40,36},{ -20,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow) annotation(Placement(transformation(extent = {{ -40, -50},{ -20, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;1,0;100,0]) annotation(Placement(transformation(extent = {{ -20,70},{0,90}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,1;2,1;2,0;100,0]) annotation(Placement(transformation(extent = {{ -20, -10},{0,10}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -78,6}}, color = {0,127,255}));
        connect(valveIncompressible1.port_b,sink.ports[2]) annotation(Line(points = {{28, -40},{46, -40},{46, -15.2},{62, -15.2}}, color = {0,127,255}));
        connect(valveIncompressible.port_b,sink.ports[1]) annotation(Line(points = {{30,46},{46,46},{46, -12.8},{62, -12.8}}, color = {0,127,255}));
        connect(pipe3.port_b,valveIncompressible1.port_a) annotation(Line(points = {{ -20, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valveIncompressible.port_a) annotation(Line(points = {{ -20,46},{10,46}}, color = {0,127,255}));
        connect(pipe2.port_a,pipe1.port_b) annotation(Line(points = {{ -40,46},{ -46,46},{ -46,6},{ -58,6}}, color = {0,127,255}));
        connect(pipe1.port_b,pipe3.port_a) annotation(Line(points = {{ -58,6},{ -46,6},{ -46, -40},{ -40, -40}}, color = {0,127,255}));
        connect(valveOpening1.y,valveIncompressible.opening) annotation(Line(points = {{1,80},{20,80},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valveIncompressible1.opening) annotation(Line(points = {{1,0},{18,0},{18, -32}}, color = {0,0,127}));
      end BranchingPipes12;
      model BranchingPipes13
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, p_a_start = 500000.0, use_T_start = true, length = 10, diameter = 0.0254, p_b_start = 495000.0, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow) annotation(Placement(transformation(extent = {{ -78, -4},{ -58,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, rho_nominal = 5, dp_nominal = 400000) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, rho_nominal = 5, dp_nominal = 400000) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(redeclare package Medium = Medium, nPorts = 2, p = 100000, T = 300) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow) annotation(Placement(transformation(extent = {{ -34,36},{ -14,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow) annotation(Placement(transformation(extent = {{ -30, -50},{ -10, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;1,0;100,0]) annotation(Placement(transformation(extent = {{ -20,70},{0,90}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,1;2,1;2,0.001;100,0]) annotation(Placement(transformation(extent = {{ -20, -10},{0,10}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
        Modelica.Fluid.Fittings.TeeJunctionIdeal junctionIdeal(redeclare package Medium = Medium) annotation(Placement(transformation(origin = { -38,6}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -78,6}}, color = {0,127,255}));
        connect(valveIncompressible1.port_b,sink.ports[2]) annotation(Line(points = {{28, -40},{46, -40},{46, -15.2},{62, -15.2}}, color = {0,127,255}));
        connect(valveIncompressible.port_b,sink.ports[1]) annotation(Line(points = {{30,46},{46,46},{46, -12.8},{62, -12.8}}, color = {0,127,255}));
        connect(pipe3.port_b,valveIncompressible1.port_a) annotation(Line(points = {{ -10, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valveIncompressible.port_a) annotation(Line(points = {{ -14,46},{10,46}}, color = {0,127,255}));
        connect(valveOpening1.y,valveIncompressible.opening) annotation(Line(points = {{1,80},{20,80},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valveIncompressible1.opening) annotation(Line(points = {{1,0},{18,0},{18, -32}}, color = {0,0,127}));
        connect(pipe1.port_b,junctionIdeal.port_3) annotation(Line(points = {{ -58,6},{ -53,6},{ -53,6},{ -48,6}}, color = {0,127,255}));
        connect(pipe2.port_a,junctionIdeal.port_2) annotation(Line(points = {{ -34,46},{ -38,46},{ -38,16}}, color = {0,127,255}));
        connect(junctionIdeal.port_1,pipe3.port_a) annotation(Line(points = {{ -38, -4},{ -38, -40},{ -30, -40}}, color = {0,127,255}));
      end BranchingPipes13;
      model BranchingPipes14
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, p_a_start = 500000.0, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 10, diameter = 0.0254, p_b_start = 495000.0) annotation(Placement(transformation(extent = {{ -78, -4},{ -58,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve2(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(redeclare package Medium = Medium, nPorts = 2, p = 100000, T = 300) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -34,36},{ -14,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow, length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -30, -50},{ -10, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;2,0.01;100,0.01]) annotation(Placement(transformation(extent = {{ -20,72},{0,92}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,1;3,1;4,0.01;100,0.01]) annotation(Placement(transformation(extent = {{ -20, -10},{0,10}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
        Modelica.Fluid.Fittings.TeeJunctionVolume junctionIdeal(redeclare package Medium = Medium, V = 0.001, energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, massDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, p_start = 500000, T_start = 300) annotation(Placement(transformation(origin = { -38,6}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -78,6}}, color = {0,127,255}));
        connect(valve2.port_b,sink.ports[2]) annotation(Line(points = {{28, -40},{46, -40},{46, -15.2},{62, -15.2}}, color = {0,127,255}));
        connect(valve1.port_b,sink.ports[1]) annotation(Line(points = {{30,46},{46,46},{46, -12.8},{62, -12.8}}, color = {0,127,255}));
        connect(pipe3.port_b,valve2.port_a) annotation(Line(points = {{ -10, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valve1.port_a) annotation(Line(points = {{ -14,46},{10,46}}, color = {0,127,255}));
        connect(valveOpening1.y,valve1.opening) annotation(Line(points = {{1,82},{20,82},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valve2.opening) annotation(Line(points = {{1,0},{18,0},{18, -32}}, color = {0,0,127}));
        connect(pipe1.port_b,junctionIdeal.port_3) annotation(Line(points = {{ -58,6},{ -48,6},{ -48,6}}, color = {0,127,255}));
        connect(pipe2.port_a,junctionIdeal.port_2) annotation(Line(points = {{ -34,46},{ -38,46},{ -38,16}}, color = {0,127,255}));
        connect(junctionIdeal.port_1,pipe3.port_a) annotation(Line(points = {{ -38, -4},{ -38, -40},{ -30, -40}}, color = {0,127,255}));
      end BranchingPipes14;
      model BranchingPipes15
        replaceable package Medium = Modelica.Media.Air.DryAirNasa;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_a_start = 500000, p_b_start = 495000) annotation(Placement(transformation(extent = {{ -78, -4},{ -58,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve2(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(redeclare package Medium = Medium, nPorts = 2, p = 100000, T = 300) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -34,36},{ -14,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -30, -50},{ -10, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;2,0.001;100,0.001]) annotation(Placement(transformation(extent = {{ -20,72},{0,92}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,1;3,1;4,0.001;100,0.001]) annotation(Placement(transformation(extent = {{ -20, -10},{0,10}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
        Modelica.Fluid.Fittings.TeeJunctionVolume junctionIdeal(redeclare package Medium = Medium, V = 0.001, energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, massDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, p_start = 500000, T_start = 300) annotation(Placement(transformation(origin = { -38,6}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -78,6}}, color = {0,127,255}));
        connect(valve2.port_b,sink.ports[2]) annotation(Line(points = {{28, -40},{46, -40},{46, -15.2},{62, -15.2}}, color = {0,127,255}));
        connect(valve1.port_b,sink.ports[1]) annotation(Line(points = {{30,46},{46,46},{46, -12.8},{62, -12.8}}, color = {0,127,255}));
        connect(pipe3.port_b,valve2.port_a) annotation(Line(points = {{ -10, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valve1.port_a) annotation(Line(points = {{ -14,46},{10,46}}, color = {0,127,255}));
        connect(valveOpening1.y,valve1.opening) annotation(Line(points = {{1,82},{20,82},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valve2.opening) annotation(Line(points = {{1,0},{18,0},{18, -32}}, color = {0,0,127}));
        connect(pipe1.port_b,junctionIdeal.port_3) annotation(Line(points = {{ -58,6},{ -48,6},{ -48,6}}, color = {0,127,255}));
        connect(pipe2.port_a,junctionIdeal.port_2) annotation(Line(points = {{ -34,46},{ -38,46},{ -38,16}}, color = {0,127,255}));
        connect(junctionIdeal.port_1,pipe3.port_a) annotation(Line(points = {{ -38, -4},{ -38, -40},{ -30, -40}}, color = {0,127,255}));
      end BranchingPipes15;
      model BranchingPipes16
        replaceable package Medium = Modelica.Media.Air.DryAirNasa;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, p_a_start = 500000.0, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_b_start = 495000.0) annotation(Placement(transformation(extent = {{ -78, -4},{ -58,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve2(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(redeclare package Medium = Medium, nPorts = 2, p = 100000, T = 300) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -34,36},{ -14,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -30, -50},{ -10, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;2,0;100,0]) annotation(Placement(transformation(extent = {{ -20,72},{0,92}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,1;3,1;4,0;100,0]) annotation(Placement(transformation(extent = {{ -20, -12},{0,8}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
        Modelica.Fluid.Fittings.TeeJunctionVolume junctionIdeal(redeclare package Medium = Medium, V = 0.001, energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, massDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, p_start = 500000, T_start = 300) annotation(Placement(transformation(origin = { -38,6}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -78,6}}, color = {0,127,255}));
        connect(valve2.port_b,sink.ports[2]) annotation(Line(points = {{28, -40},{46, -40},{46, -15.2},{62, -15.2}}, color = {0,127,255}));
        connect(valve1.port_b,sink.ports[1]) annotation(Line(points = {{30,46},{46,46},{46, -12.8},{62, -12.8}}, color = {0,127,255}));
        connect(pipe3.port_b,valve2.port_a) annotation(Line(points = {{ -10, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valve1.port_a) annotation(Line(points = {{ -14,46},{10,46}}, color = {0,127,255}));
        connect(valveOpening1.y,valve1.opening) annotation(Line(points = {{1,82},{20,82},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valve2.opening) annotation(Line(points = {{1, -2},{18, -2},{18, -32}}, color = {0,0,127}));
        connect(pipe1.port_b,junctionIdeal.port_3) annotation(Line(points = {{ -58,6},{ -48,6},{ -48,6}}, color = {0,127,255}));
        connect(pipe2.port_a,junctionIdeal.port_2) annotation(Line(points = {{ -34,46},{ -38,46},{ -38,16}}, color = {0,127,255}));
        connect(junctionIdeal.port_1,pipe3.port_a) annotation(Line(points = {{ -38, -4},{ -38, -40},{ -30, -40}}, color = {0,127,255}));
      end BranchingPipes16;
      model BranchingPipes17
        replaceable package Medium = Modelica.Media.Air.DryAirNasa;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, p_a_start = 500000.0, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_b_start = 495000.0) annotation(Placement(transformation(extent = {{ -78, -4},{ -58,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5, dp(start = 10)) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve2(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5, Tolerance = 1e-07), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(nPorts = 1, redeclare package Medium = Medium, T = 300, p = 100000.0) annotation(Placement(transformation(extent = {{94, -18},{82, -6}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -34,36},{ -14,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -30, -50},{ -10, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;2,0;100,0]) annotation(Placement(transformation(extent = {{ -20,72},{0,92}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,1;3,1;4,0;100,0]) annotation(Placement(transformation(extent = {{ -18, -12},{2,8}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
        Modelica.Fluid.Fittings.TeeJunctionVolume junctionIdeal(redeclare package Medium = Medium, V = 0.001, energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, massDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, p_start = 500000, T_start = 300) annotation(Placement(transformation(origin = { -40,6}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Fluid.Fittings.TeeJunctionVolume junctionVolume(redeclare package Medium = Medium, V = 0.001) annotation(Placement(transformation(origin = {56, -12}, extent = {{ -10,10},{10, -10}}, rotation = 90)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -78,6}}, color = {0,127,255}));
        connect(pipe3.port_b,valve2.port_a) annotation(Line(points = {{ -10, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valve1.port_a) annotation(Line(points = {{ -14,46},{10,46}}, color = {0,127,255}));
        connect(valveOpening1.y,valve1.opening) annotation(Line(points = {{1,82},{20,82},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valve2.opening) annotation(Line(points = {{3, -2},{18, -2},{18, -32}}, color = {0,0,127}));
        connect(pipe1.port_b,junctionIdeal.port_3) annotation(Line(points = {{ -58,6},{ -50,6},{ -50,6}}, color = {0,127,255}));
        connect(pipe2.port_a,junctionIdeal.port_2) annotation(Line(points = {{ -34,46},{ -40,46},{ -40,16}}, color = {0,127,255}));
        connect(junctionIdeal.port_1,pipe3.port_a) annotation(Line(points = {{ -40, -4},{ -40, -40},{ -30, -40}}, color = {0,127,255}));
        connect(junctionVolume.port_3,sink.ports[1]) annotation(Line(points = {{66, -12},{82, -12}}, color = {0,127,255}));
        connect(valve2.port_b,junctionVolume.port_1) annotation(Line(points = {{28, -40},{56, -40},{56, -22}}, color = {0,127,255}));
        connect(valve1.port_b,junctionVolume.port_2) annotation(Line(points = {{30,46},{56,46},{56, -2}}, color = {0,127,255}));
      end BranchingPipes17;
      model BranchingPipes18
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, p_a_start = 500000.0, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_b_start = 495000.0) annotation(Placement(transformation(extent = {{ -78, -4},{ -58,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5) annotation(Placement(transformation(extent = {{10,36},{30,56}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valve2(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, dp_nominal = 400000.0, m_flow_nominal = 1, rho_nominal = 5) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(nPorts = 1, redeclare package Medium = Medium, T = 300, p = 100000.0) annotation(Placement(transformation(extent = {{94, -18},{82, -6}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe2(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -34,36},{ -14,56}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.TurbulentPipeFlow(dp_small = 10), length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0) annotation(Placement(transformation(extent = {{ -30, -50},{ -10, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;2,0;100,0]) annotation(Placement(transformation(extent = {{ -20,72},{0,92}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,1;3,1;4,0;100,0]) annotation(Placement(transformation(extent = {{ -18, -12},{2,8}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
        Modelica.Fluid.Fittings.TeeJunctionVolume junctionIdeal(redeclare package Medium = Medium, V = 0.001, energyDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, massDynamics = Modelica.Fluid.Types.Dynamics.FixedInitial, p_start = 500000, T_start = 300) annotation(Placement(transformation(origin = { -40,6}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Fluid.Fittings.TeeJunctionVolume junctionVolume(redeclare package Medium = Medium, V = 0.001) annotation(Placement(transformation(origin = {56, -12}, extent = {{ -10,10},{10, -10}}, rotation = 90)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -78,6}}, color = {0,127,255}));
        connect(pipe3.port_b,valve2.port_a) annotation(Line(points = {{ -10, -40},{8, -40}}, color = {0,127,255}));
        connect(pipe2.port_b,valve1.port_a) annotation(Line(points = {{ -14,46},{10,46}}, color = {0,127,255}));
        connect(valveOpening1.y,valve1.opening) annotation(Line(points = {{1,82},{20,82},{20,54}}, color = {0,0,127}));
        connect(valveOpening2.y,valve2.opening) annotation(Line(points = {{3, -2},{18, -2},{18, -32}}, color = {0,0,127}));
        connect(pipe1.port_b,junctionIdeal.port_3) annotation(Line(points = {{ -58,6},{ -54,6},{ -54,6},{ -50,6}}, color = {0,127,255}));
        connect(pipe2.port_a,junctionIdeal.port_2) annotation(Line(points = {{ -34,46},{ -40,46},{ -40,16}}, color = {0,127,255}));
        connect(junctionIdeal.port_1,pipe3.port_a) annotation(Line(points = {{ -40, -4},{ -40, -40},{ -30, -40}}, color = {0,127,255}));
        connect(junctionVolume.port_3,sink.ports[1]) annotation(Line(points = {{66, -12},{82, -12}}, color = {0,127,255}));
        connect(valve2.port_b,junctionVolume.port_1) annotation(Line(points = {{28, -40},{56, -40},{56, -22}}, color = {0,127,255}));
        connect(valve1.port_b,junctionVolume.port_2) annotation(Line(points = {{30,46},{56,46},{56, -2}}, color = {0,127,255}));
      end BranchingPipes18;
      model BranchingPipes131
        replaceable package Medium = Modelica.Media.Water.StandardWater;
        Modelica.Fluid.Sources.Boundary_pT source(nPorts = 1, redeclare package Medium = Medium, p = 500000.0, T = 300) annotation(Placement(transformation(extent = {{ -100,0},{ -88,12}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe1(redeclare package Medium = Medium, p_a_start = 500000.0, use_T_start = true, length = 10, diameter = 0.0254, p_b_start = 495000.0, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow) annotation(Placement(transformation(extent = {{ -78, -4},{ -58,16}}, rotation = 0)));
        Modelica.Fluid.Valves.ValveIncompressible valveIncompressible1(redeclare package Medium = Medium, CvData = Modelica.Fluid.Types.CvTypes.OpPoint, m_flow_nominal = 1, rho_nominal = 5, dp(start = 400000), dp_nominal = 400000) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 5), experimentSetupOutput(equdistant = false), Documentation(info = "<html>
Simulation starts with both valves open. At t=1, valve 1 closes; at t=2 valve 2 closes, and the simulation fails.
</html>"));
        Modelica.Fluid.Sources.Boundary_pT sink(nPorts = 1, redeclare package Medium = Medium, T = 300, p = 100000.0) annotation(Placement(transformation(extent = {{74, -20},{62, -8}}, rotation = 0)));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe3(redeclare package Medium = Medium, use_T_start = true, length = 10, diameter = 0.0254, p_a_start = 495000.0, p_b_start = 490000.0, redeclare model FlowModel = Modelica.Fluid.Pipes.BaseClasses.FlowModels.DetailedPipeFlow) annotation(Placement(transformation(extent = {{ -30, -50},{ -10, -30}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening1(offset = 0, table = [0,1;1,1;1,0;100,0]) annotation(Placement(transformation(extent = {{ -20,70},{0,90}}, rotation = 0)));
        Modelica.Blocks.Sources.TimeTable valveOpening2(offset = 0, table = [0,1;2,1;2.01,1e-06;100,0]) annotation(Placement(transformation(extent = {{ -20, -8},{0,12}}, rotation = 0)));
        inner Modelica.Fluid.System system annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));

      equation 
        connect(source.ports[1],pipe1.port_a) annotation(Line(points = {{ -88,6},{ -78,6}}, color = {0,127,255}));
        connect(valveIncompressible1.port_b,sink.ports[1]) annotation(Line(points = {{28, -40},{46, -40},{46, -14},{62, -14}}, color = {0,127,255}));
        connect(pipe3.port_b,valveIncompressible1.port_a) annotation(Line(points = {{ -10, -40},{8, -40}}, color = {0,127,255}));
        connect(valveOpening2.y,valveIncompressible1.opening) annotation(Line(points = {{1,2},{18,2},{18, -32}}, color = {0,0,127}));
        connect(pipe1.port_b,pipe3.port_a) annotation(Line(points = {{ -58,6},{ -44,6},{ -44, -40},{ -30, -40}}, color = {0,127,255}));
      end BranchingPipes131;
      model LumpedPipeInitialization "Steady-state initialization of a lumped pipe"
        annotation(Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 4), experimentSetupOutput);
        Modelica.Fluid.Sources.FixedBoundary source(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWater, use_T = false, p = 10000000, h = 2000000.0) annotation(Placement(transformation(extent = {{ -80, -10},{ -60,10}})));
        ModelicaTest.Fluid.BaseClasses.LumpedPipe pipe(redeclare package Medium = Modelica.Media.Water.StandardWater, h_start = 2000000.0, diameter = 0.05, length = 200, use_T_start = false, p_a_start = 10000000, p_b_start = 9900000) annotation(Placement(transformation(extent = {{ -40, -10},{ -20,10}})));
        Modelica.Fluid.Valves.ValveCompressible valve(redeclare package Medium = Modelica.Media.Water.StandardWater, Av = 0.001, dp_nominal = 10000000, m_flow_nominal = 10) annotation(Placement(transformation(extent = {{0, -10},{20,10}})));
        Modelica.Fluid.Sources.FixedBoundary sink(nPorts = 1, redeclare package Medium = Modelica.Media.Water.StandardWaterOnePhase, p = 9500000) annotation(Placement(transformation(extent = {{60, -10},{40,10}})));
        Modelica.Blocks.Sources.Ramp ramp(offset = 1, duration = 0.1, height =  -0.5, startTime = 2) annotation(Placement(transformation(extent = {{46,30},{26,50}})));
        inner Modelica.Fluid.System system(energyDynamics = Modelica.Fluid.Types.Dynamics.SteadyState) annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}})));
        discrete Modelica.SIunits.MassFlowRate m_flow_initial;

      equation 
        when time > 0.1 then
                  m_flow_initial = valve.port_a.m_flow;
        
        end when;
if pipe.energyDynamics >= Modelica.Fluid.Types.Dynamics.SteadyStateInitial and pipe.massDynamics >= Modelica.Fluid.Types.Dynamics.SteadyStateInitial then
                  when time > 1 then
                      assert(abs(valve.port_a.m_flow - m_flow_initial) < 0.001, "!!!THE SIMULATION DID NOT START IN STEADY-STATE!!!");
          
          end when;
        end if;
        connect(source.ports[1],pipe.port_a) annotation(Line(points = {{ -60,0},{ -40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(pipe.port_b,valve.port_a) annotation(Line(points = {{ -20,0},{0,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(valve.port_b,sink.ports[1]) annotation(Line(points = {{20,0},{40,0}}, color = {0,127,255}, smooth = Smooth.None));
        connect(ramp.y,valve.opening) annotation(Line(points = {{25,40},{10,40},{10,8}}, color = {0,0,127}, smooth = Smooth.None));
      end LumpedPipeInitialization;
    end TestCriticalCases;
    package BaseClasses "Specific models used for testing"
      extends Modelica.Fluid.Icons.BaseClassLibrary;
      model GenericStaticHead "Models two ports at different heights"
        extends Modelica.Fluid.Interfaces.PartialTwoPortTransport;
        parameter SI.Length height_ab "Height(port_b) - Height(port_a)" annotation(Dialog(group = "Static head"));
        replaceable model PressureLoss = Modelica.Fluid.Pipes.BaseClasses.FlowModels.NominalLaminarFlow extends Modelica.Fluid.Interfaces.PartialDistributedFlow "Pressure loss model" annotation(Dialog(group = "Pressure loss"), choicesAllMatching = true);
        PressureLoss pressureLoss(redeclare final package Medium = Medium, final n = 2, states = {state_a,state_b}, vs = {port_a.m_flow / Medium.density(pressureLoss.states[1]) / pressureLoss.crossAreas[1], -port_b.m_flow / Medium.density(pressureLoss.states[2]) / pressureLoss.crossAreas[2]}, final momentumDynamics = Modelica.Fluid.Types.Dynamics.SteadyState, final allowFlowReversal = allowFlowReversal, dheights = {height_ab}, dp_nominal = 1, m_flow_nominal = 1, m_flow_start = m_flow_start, p_a_start = system.p_start + 0.5 * dp_start, p_b_start = system.p_start - 0.5 * dp_start, nParallel = 1, pathLengths = {0}, crossAreas = fill(Modelica.Constants.pi / 4 * 0.0254 ^ 2, 2), dimensions = fill(0.0254, 2), roughnesses = fill(2.5e-05, 2));

      equation 
        m_flow = pressureLoss.m_flows[1];
        port_a.h_outflow = inStream(port_b.h_outflow) + system.g * height_ab;
        port_b.h_outflow = inStream(port_a.h_outflow) - system.g * height_ab;
        annotation(defaultComponentName = "staticHead", Icon(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Rectangle(extent = {{ -100,60},{100, -60}}, lineColor = {0,0,0}, fillPattern = FillPattern.HorizontalCylinder, fillColor = {0,127,255})}), Documentation(info = "<html>
<p>
This component is intended for early designs and later replacement by more detailed models.
It describes the static head due to the height difference between its two ports.
</p>
<p>
Per default a small regularization with a linear pressure loss of 1Pa per 1kg/s is configured.
The regularization can be changed for the PressureLoss model.
</p>
</html>", revisions = "<html>
<ul>
<li><i>8 Dec 2008</i>
    by Ruediger Franke:<br>
       Introduce small nominal pressure loss for regularization</li>
<li><i>31 Oct 2007</i>
    by <a href=\"mailto:jonas@modelon.se\">Jonas Eborn</a>:<br>
       Changed to flow-direction dependent density</li>
<li><i>2 Nov 2005</i>
    by <a href=\"mailto:francesco.casella@polimi.it\">Francesco Casella</a>:<br>
       Added to Modelica.Fluid</li>
</ul>
</html>"));
      end GenericStaticHead;
      model LumpedPipe "Example for a composite pipe model"
        extends Modelica.Fluid.Pipes.BaseClasses.PartialStraightPipe;
        parameter Modelica.Fluid.Types.Dynamics energyDynamics = system.energyDynamics "Formulation of energy balance" annotation(Evaluate = true, Dialog(tab = "Assumptions", group = "Dynamics"));
        parameter Modelica.Fluid.Types.Dynamics massDynamics = system.massDynamics "Formulation of mass balance" annotation(Evaluate = true, Dialog(tab = "Assumptions", group = "Dynamics"));
        parameter Medium.AbsolutePressure p_a_start = system.p_start "Start value of pressure at port a" annotation(Dialog(tab = "Initialization"));
        parameter Medium.AbsolutePressure p_b_start = p_a_start "Start value of pressure at port b" annotation(Dialog(tab = "Initialization"));
        parameter Boolean use_T_start = true "Use T_start if true, otherwise h_start" annotation(Evaluate = true, Dialog(tab = "Initialization"));
        parameter Medium.Temperature T_start = if use_T_start then system.T_start else Medium.temperature_phX((p_a_start + p_b_start) / 2, h_start, X_start) "Start value of temperature" annotation(Evaluate = true, Dialog(tab = "Initialization", enable = use_T_start));
        parameter Medium.SpecificEnthalpy h_start = if use_T_start then Medium.specificEnthalpy_pTX((p_a_start + p_b_start) / 2, T_start, X_start) else Medium.h_default "Start value of specific enthalpy" annotation(Evaluate = true, Dialog(tab = "Initialization", enable = not use_T_start));
        parameter Medium.MassFraction X_start[Medium.nX] = Medium.X_default "Start value of mass fractions m_i/m" annotation(Dialog(tab = "Initialization", enable = Medium.nXi > 0));
        parameter Medium.ExtraProperty C_start[Medium.nC](quantity = Medium.extraPropertiesNames) = fill(0, Medium.nC) "Start value of trace substances" annotation(Dialog(tab = "Initialization", enable = Medium.nC > 0));
        parameter Medium.MassFlowRate m_flow_start = system.m_flow_start "Start value for mass flow rate" annotation(Evaluate = true, Dialog(tab = "Initialization"));
        parameter Boolean use_HeatTransfer = false "= true to use the HeatTransfer model" annotation(Dialog(tab = "Assumptions", group = "Heat transfer"));
        replaceable model HeatTransfer = Modelica.Fluid.Vessels.BaseClasses.HeatTransfer.IdealHeatTransfer extends Modelica.Fluid.Vessels.BaseClasses.HeatTransfer.PartialVesselHeatTransfer "Wall heat transfer" annotation(Dialog(tab = "Assumptions", group = "Heat transfer", enable = use_HeatTransfer), choicesAllMatching = true);
        Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a heatPort if use_HeatTransfer annotation(Placement(transformation(extent = {{ -10,44},{10,64}}, rotation = 0), iconTransformation(extent = {{ -10,35},{10,55}})));
        Modelica.Fluid.Pipes.StaticPipe staticPipe1(redeclare package Medium = Medium, allowFlowReversal = allowFlowReversal, nParallel = nParallel, length = length / 2, roughness = roughness, diameter = diameter, perimeter = perimeter, crossArea = crossArea, height_ab = height_ab / 2, m_flow_start = m_flow_start, redeclare final model FlowModel = FlowModel) annotation(Placement(transformation(extent = {{ -60, -10},{ -40,10}}, rotation = 0)));
        Modelica.Fluid.Vessels.ClosedVolume volume(redeclare package Medium = Medium, redeclare model HeatTransfer = HeatTransfer, heatTransfer(surfaceAreas = {perimeter * length}), energyDynamics = energyDynamics, massDynamics = massDynamics, p_start = (p_a_start + p_b_start) / 2, use_T_start = use_T_start, T_start = T_start, h_start = h_start, X_start = X_start, C_start = C_start, V = V, nPorts = 2, use_portsData = false, use_HeatTransfer = use_HeatTransfer) annotation(Placement(transformation(extent = {{ -10,10},{10,30}}, rotation = 0)));
        Modelica.Fluid.Pipes.StaticPipe staticPipe2(redeclare package Medium = Medium, allowFlowReversal = allowFlowReversal, nParallel = nParallel, length = length / 2, roughness = roughness, diameter = diameter, perimeter = perimeter, crossArea = crossArea, height_ab = height_ab / 2, m_flow_start = m_flow_start, redeclare final model FlowModel = FlowModel) annotation(Placement(transformation(extent = {{40, -10},{60,10}}, rotation = 0)));

      equation 
        connect(staticPipe1.port_a,port_a) annotation(Line(points = {{ -60,0},{ -80,0},{ -100,0}}, color = {0,127,255}));
        connect(staticPipe2.port_b,port_b) annotation(Line(points = {{60,0},{80,0},{100,0}}, color = {0,127,255}));
        annotation(defaultComponentName = "pipe", Icon(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Ellipse(extent = {{ -10,10},{10, -10}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid)}), Documentation(info = "<html>
<p>
Simple pipe model consisting of one volume,
wall friction (with different friction correlations)
and gravity effect. This model is mostly used to demonstrate how
to build up more detailed models from the basic components.
Note, if the \"heatPort\" is not connected, then the pipe
is totally insulated (= no thermal flow from the fluid to the
pipe wall/environment).
</p>
</html>"), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics));
        connect(staticPipe1.port_b,volume.ports[1]) annotation(Line(points = {{ -40,0},{ -2,0},{ -2,10}}, color = {0,127,255}, smooth = Smooth.None));
        connect(staticPipe2.port_a,volume.ports[2]) annotation(Line(points = {{40,0},{2,0},{2,10}}, color = {0,127,255}, smooth = Smooth.None));
        connect(heatPort,volume.heatPort) annotation(Line(points = {{0,54},{0,40},{ -20,40},{ -20,20},{ -10,20}}, color = {191,0,0}, smooth = Smooth.None));
      end LumpedPipe;
    end BaseClasses;
  end Fluid;
  package Utilities "Test functions for Modelica.Utilities"
    function Strings "Test functions of Modelica.Utilities.Strings"
      import Modelica.Utilities.Streams;
      import Modelica.Utilities.Strings;
      import Modelica.Utilities.Types;
      input String logFile = "ModelicaTestLog.txt" "Filename where the log is stored";
      output Boolean ok;
    protected 
      Integer i;
      Integer j;
      Real r;
      String s;
      Boolean b;
      String svec[2];
      Types.TokenValue token;
    algorithm 
      Streams.print("... Test of Modelica.Utilities.Strings", logFile);
      i:=Strings.length("hello, world");
      assert(i == 12, "Strings.length failed");
      s:=Strings.substring("12345678", 3);
      assert(s == "3", "Strings.Advanced.substring 1 failed");
      s:=Strings.substring("12345678", 3, 5);
      assert(s == "345", "Strings.Advanced.substring 2 failed");
      s:=Strings.repeat(3, "12");
      assert(s == "121212", "Strings.Advanced.repeat failed");
      i:=Strings.compare("abc", "ABC", caseSensitive = false);
      assert(i == Modelica.Utilities.Types.Compare.Equal, "Strings.Advanced.compare 1 failed");
      i:=Strings.compare("abc", "zef");
      assert(i == Modelica.Utilities.Types.Compare.Less, "Strings.Advanced.compare 2 failed");
      b:=Strings.isEqual("abc", "ABC");
      assert(not b, "Strings.Advanced.isEqual 1 failed");
      b:=Strings.isEqual("abc", "ABC", caseSensitive = false);
      assert(b, "Strings.Advanced.isEqual 2 failed");
      i:=Strings.count("line1 line2 line1 line2", "line2");
      assert(i == 2, "Strings.Advanced.count failed");
      i:=Strings.find("x line x line x", "line");
      assert(i == 3, "Strings.Advanced.find failed");
      i:=Strings.findLast("x line x line x", "line");
      assert(i == 10, "Strings.Advanced.findLast failed");
      s:=Strings.replace("x line x line x", "line", "LINE");
      assert(s == "x LINE x LINE x", "Strings.Advanced.replace failed");
      svec:=Strings.sort({"zxy","abc"});
      assert(svec[1] == "abc" and svec[2] == "zxy", "Strings.Advanced.sort failed");
      i:=Strings.Advanced.skipWhiteSpace("  abc ", 1);
      assert(i == 3, "Strings.Advanced.skipWhiteSpace failed");
      i:=Strings.Advanced.skipLineComments(" // xx", 1);
      assert(i == 7, "Strings.Advanced.skipLineComments 1 failed");
      i:=Strings.Advanced.skipLineComments(" // xx", 1);
      assert(i == 7, "Strings.Advanced.skipLineComments 1 failed");
      (i,r):=Strings.Advanced.scanReal("  -123.47e-2", 1);
      assert(i == 13 and r ==  -1.2347, "Strings.Advanced.scanReal 1 failed");
      (i,r):=Strings.Advanced.scanReal("  123 ", 1, unsigned = true);
      assert(i == 6 and r == 123, "Strings.Advanced.scanReal 2 failed");
      (i,j):=Strings.Advanced.scanInteger("  -123", 1);
      assert(i == 7 and j ==  -123, "Strings.Advanced.scanInteger 1 failed");
      (i,j):=Strings.Advanced.scanInteger("  123", 1, unsigned = true);
      assert(i == 6 and j == 123, "Strings.Advanced.scanInteger 2 failed");
      (i,s):=Strings.Advanced.scanString(" \"string text\" x=3", 1);
      assert(i == 15 and s == "string text", "Strings.Advanced.scanString failed");
      (i,s):=Strings.Advanced.scanIdentifier(" x_12=2;", 1);
      assert(i == 6 and s == "x_12", "Strings.Advanced.scanIdentifier failed");
      (token,i):=Strings.scanToken("  -123.47e-2", 1);
      assert(i == 13 and token.tokenType == Types.TokenType.RealToken and token.real ==  -1.2347, "String.scanToken 1 failed");
      (token,i):=Strings.scanToken("  -123", 1);
      assert(i == 7 and token.tokenType == Types.TokenType.IntegerToken and token.integer ==  -123, "String.scanToken 2 failed");
      (token,i):=Strings.scanToken("  123", 1, unsigned = true);
      assert(i == 6 and token.tokenType == Types.TokenType.IntegerToken and token.integer == 123, "String.scanToken 3 failed");
      (token,i):=Strings.scanToken("  true x", 1);
      assert(i == 7 and token.tokenType == Types.TokenType.BooleanToken and token.boolean, "String.scanToken 4 failed");
      (token,i):=Strings.scanToken("  false x", 1);
      assert(i == 8 and token.tokenType == Types.TokenType.BooleanToken and not token.boolean, "String.scanToken 5 failed");
      (token,i):=Strings.scanToken(" \"string text\" x=3", 1);
      assert(i == 15 and token.tokenType == Types.TokenType.StringToken and token.string == "string text", "String.scanToken 6 failed");
      (token,i):=Strings.scanToken(" x_12=2;", 1);
      assert(i == 6 and token.tokenType == Types.TokenType.IdentifierToken and token.string == "x_12", "String.scanToken 7 failed");
      (token,i):=Strings.scanToken("  abc = 3;   ", 11);
      assert(i == 14 and token.tokenType == Types.TokenType.NoToken, "String.scanToken 8 failed");
      (r,i):=Strings.scanReal("  123 ", 1, unsigned = true);
      assert(i == 6 and r == 123, "String.scanRequiredReal 2 failed");
      (j,i):=Strings.scanInteger("  -123", 1);
      assert(i == 7 and j ==  -123, "String.scanRequiredInteger 1 failed");
      (j,i):=Strings.scanInteger("  123", 1, unsigned = true);
      assert(i == 6 and j == 123, "String.scanRequiredInteger 2 failed");
      (b,i):=Strings.scanBoolean("  true x", 1);
      assert(i == 7 and b, "String.scanRequiredBoolean 1 failed");
      (b,i):=Strings.scanBoolean("  false x", 1);
      assert(i == 8 and not b, "String.scanRequiredBoolean 2 failed");
      (s,i):=Strings.scanString(" \"string text\" x=3", 1);
      assert(i == 15 and s == "string text", "String.scanRequiredString failed");
      (s,i):=Strings.scanIdentifier(" x_12=2;", 1);
      assert(i == 6 and s == "x_12", "String.scanRequiredIdentifier failed");
      (s,i):=Strings.scanDelimiter("  &,", 1, {"&",","});
      assert(i == 4 and s == "&", "String.scanRequiredDelimiter 1 failed");
      (s,i):=Strings.scanDelimiter("  /*,", 1, {"&","/*"});
      assert(i == 5 and s == "/*", "String.scanRequiredDelimiter 2 failed");
      Strings.scanNoToken("  abc = 3;   ", 11);
      ok:=true;
    end Strings;
    function Streams "Test functions of Modelica.Utilities.Streams"
      import Modelica.Utilities.Streams;
      import Modelica.Utilities.Files;
      input String logFile = "ModelicaTestLog.txt" "Filename where the log is stored";
      output Boolean ok;
    protected 
      String file = "#testStreams.txt";
      String line1 = "this is line 1";
      String line2 = "this is line 2";
      String line3 = "this is line 3";
      String lines[3];
      String rline;
      Integer nLines;
      Boolean eof;
    algorithm 
      Streams.print("... Test of Modelica.Utilities.Streams", logFile);
      Files.remove(file);
      Streams.print(line1, file);
      Streams.print(line2, file);
      Streams.print(line3, file);
      Streams.close(file);
      lines:=Streams.readFile(file);
      assert(lines[1] == line1 and lines[2] == line2 and lines[3] == line3, "Streams.readFile failed");
      nLines:=Streams.countLines(file);
      assert(nLines == 3, "Streams.countLines failed");
      (rline,eof):=Streams.readLine(file, 1);
      assert(rline == line1 and not eof, "Streams.readLine 1 failed");
      (rline,eof):=Streams.readLine(file, 2);
      assert(rline == line2 and not eof, "Streams.readLine 2 failed");
      (rline,eof):=Streams.readLine(file, 3);
      assert(rline == line3 and not eof, "Streams.readLine 3 failed");
      (rline,eof):=Streams.readLine(file, 4);
      assert(rline == "" and eof, "Streams.readLine 4 failed");
      Files.remove(file);
      ok:=true;
    end Streams;
    function Internal "Test functions of Modelica.Utilities.Internal"
      import Modelica.Utilities.Internal.FileSystem;
      import Modelica.Utilities.System;
      import Modelica.Utilities.Types;
      import Modelica.Utilities.Streams;
      input String logFile = "ModelicaTestLog.txt" "Filename where the log is stored";
      output Boolean ok;
    protected 
      String dir1;
      String dir2;
      String dir3;
      String dir4;
      String env;
      Boolean exist;
      Modelica.Utilities.Types.FileType fileType;
    algorithm 
      Streams.print("... Test of Modelica.Utilities.Internal.FileSystem and .System", logFile);
      dir1:=System.getWorkDirectory();
      dir2:=dir1 + "/#ModelicaTest";
      fileType:=FileSystem.stat(dir2);
      if fileType > Types.FileType.NoFile then 
            FileSystem.rmdir(dir2);

      else 
      end if;
      FileSystem.mkdir(dir2);
      fileType:=FileSystem.stat(dir2);
      assert(fileType == Types.FileType.Directory, "FileSystem.mkdir/stat failed");
      Streams.print("dir2 = " + dir2);
      System.setWorkDirectory(dir2);
      Streams.print(".. 1");
      dir3:=System.getWorkDirectory();
      Streams.print(".. 2");
      assert(dir2 == dir3, "System.xxxWorkDirectory failed\n" + "set dir = " + dir1 + "\n" + "get dir = " + dir3 + "\n");
      Streams.print(".. 3");
      System.setWorkDirectory("..");
      Streams.print(".. 4");
      dir4:=dir1 + "/#ModelicaTest2";
      Streams.print(".. 5");
      FileSystem.rename(dir2, dir4);
      Streams.print(".. 6");
      FileSystem.rmdir(dir4);
      System.setEnvironmentVariable("#ModelicaTest", "/dir1/dir2/dir3", convertFromSlash = true);
      (env,exist):=System.getEnvironmentVariable("#ModelicaTest", convertToSlash = true);
      assert(exist, "System.getEnvironmentVariable 1 failed");
      assert(env == "/dir1/dir2/dir3", "System.getEnvironmentVariable 2 failed\n" + "env = " + env);
      ok:=true;
    end Internal;
    function Files "Test functions of Modelica.Utilities.Files"
      import Modelica.Utilities.Files;
      import Modelica.Utilities.Streams;
      input String logFile = "ModelicaTestLog.txt" "Filename where the log is stored";
      output Boolean ok;
    protected 
      String directory;
      String name;
      String extension;
    algorithm 
      Streams.print("... Test of Modelica.Utilities.Files", logFile);
      (directory,name,extension):=Files.splitPathName("E:/test1/test2.save.txt");
      assert(directory == "E:/test1/" and name == "test2.save" and extension == ".txt", "Files.splitPathName 1 failed");
      (directory,name,extension):=Files.splitPathName("E:/test1/test2");
      assert(directory == "E:/test1/" and name == "test2" and extension == "", "Files.splitPathName 2 failed");
      ok:=true;
    end Files;
    function testAll "Test functions of Modelica.Utilities"
      input String logFile = "ModelicaTestLog.txt" "Filename where the log is stored";
      output Boolean ok;
    protected 
      Boolean result;
    algorithm 
      result:=ModelicaTest.Utilities.Strings(logFile);
      result:=ModelicaTest.Utilities.Streams(logFile);
      result:=ModelicaTest.Utilities.Files(logFile);
      ok:=true;
    end testAll;
  end Utilities;
  package Translational
    model AllComponents
      Modelica.Mechanics.Translational.Components.Mass slidingMass annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Rod rod annotation(Placement(transformation(extent = {{ -28,60},{ -8,80}}, rotation = 0)));
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));
      Modelica.Mechanics.Translational.Components.Spring spring annotation(Placement(transformation(extent = {{0,60},{20,80}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Damper damper(d = 10) annotation(Placement(transformation(extent = {{26,60},{46,80}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass1 annotation(Placement(transformation(extent = {{54,60},{74,80}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.SpringDamper springDamper annotation(Placement(transformation(extent = {{ -30,20},{ -10,40}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass2 annotation(Placement(transformation(extent = {{0,20},{20,40}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.ElastoGap elastoGap annotation(Placement(transformation(extent = {{30,20},{50,40}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass3 annotation(Placement(transformation(extent = {{60,20},{80,40}}, rotation = 0)));
      Modelica.Mechanics.Translational.Sources.Position position annotation(Placement(transformation(extent = {{ -68, -20},{ -48,0}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{ -100, -20},{ -80,0}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass4 annotation(Placement(transformation(extent = {{ -40, -20},{ -20,0}}, rotation = 0)));
      Modelica.Mechanics.Translational.Sources.Speed position1 annotation(Placement(transformation(extent = {{ -68, -60},{ -48, -40}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine1 annotation(Placement(transformation(extent = {{ -100, -60},{ -80, -40}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass5 annotation(Placement(transformation(extent = {{ -40, -60},{ -20, -40}}, rotation = 0)));
      Modelica.Mechanics.Translational.Sources.Accelerate position2 annotation(Placement(transformation(extent = {{ -68, -100},{ -48, -80}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine2 annotation(Placement(transformation(extent = {{ -100, -100},{ -80, -80}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass6 annotation(Placement(transformation(extent = {{ -40, -100},{ -20, -80}}, rotation = 0)));
      Modelica.Mechanics.Translational.Sources.Move position3 annotation(Placement(transformation(extent = {{32, -20},{52,0}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine3[3] annotation(Placement(transformation(extent = {{0, -20},{20,0}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass7 annotation(Placement(transformation(extent = {{60, -20},{80,0}}, rotation = 0)));
      Modelica.Mechanics.Translational.Sources.Force force annotation(Placement(transformation(extent = {{ -70,20},{ -50,40}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.RelativeStates relativeStates annotation(Placement(transformation(extent = {{ -2,82},{18,102}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine4 annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));

    equation 
      connect(slidingMass.flange_b,rod.flange_a) annotation(Line(points = {{ -40,70},{ -28,70}}, color = {0,127,0}, smooth = Smooth.None));
      connect(rod.flange_b,spring.flange_a) annotation(Line(points = {{ -8,70},{0,70}}, color = {0,127,0}, smooth = Smooth.None));
      connect(spring.flange_b,damper.flange_a) annotation(Line(points = {{20,70},{26,70}}, color = {0,127,0}, smooth = Smooth.None));
      connect(damper.flange_b,slidingMass1.flange_a) annotation(Line(points = {{46,70},{54,70}}, color = {0,127,0}, smooth = Smooth.None));
      connect(slidingMass.flange_b,springDamper.flange_a) annotation(Line(points = {{ -40,70},{ -40,30},{ -30,30}}, color = {0,127,0}, smooth = Smooth.None));
      connect(springDamper.flange_b,slidingMass2.flange_a) annotation(Line(points = {{ -10,30},{0,30}}, color = {0,127,0}, smooth = Smooth.None));
      connect(slidingMass2.flange_b,elastoGap.flange_a) annotation(Line(points = {{20,30},{30,30}}, color = {0,127,0}, smooth = Smooth.None));
      connect(elastoGap.flange_b,slidingMass3.flange_a) annotation(Line(points = {{50,30},{60,30}}, color = {0,127,0}, smooth = Smooth.None));
      connect(sine.y,position.s_ref) annotation(Line(points = {{ -79, -10},{ -70, -10}}, color = {0,0,127}, smooth = Smooth.None));
      connect(position.flange,slidingMass4.flange_a) annotation(Line(points = {{ -48, -10},{ -40, -10}}, color = {0,127,0}, smooth = Smooth.None));
      connect(position1.flange,slidingMass5.flange_a) annotation(Line(points = {{ -48, -50},{ -40, -50}}, color = {0,127,0}, smooth = Smooth.None));
      connect(position2.flange,slidingMass6.flange_a) annotation(Line(points = {{ -48, -90},{ -40, -90}}, color = {0,127,0}, smooth = Smooth.None));
      connect(position3.flange,slidingMass7.flange_a) annotation(Line(points = {{52, -10},{60, -10}}, color = {0,127,0}, smooth = Smooth.None));
      connect(sine1.y,position1.v_ref) annotation(Line(points = {{ -79, -50},{ -70, -50}}, color = {0,0,127}, smooth = Smooth.None));
      connect(sine2.y,position2.a_ref) annotation(Line(points = {{ -79, -90},{ -70, -90}}, color = {0,0,127}, smooth = Smooth.None));
      connect(sine3.y,position3.u) annotation(Line(points = {{21, -10},{30, -10}}, color = {0,0,127}, smooth = Smooth.None));
      connect(force.flange,springDamper.flange_a) annotation(Line(points = {{ -50,30},{ -30,30}}, color = {0,127,0}, smooth = Smooth.None));
      connect(slidingMass.flange_b,relativeStates.flange_a) annotation(Line(points = {{ -40,70},{ -34,70},{ -34,92},{ -2,92}}, color = {0,127,0}, smooth = Smooth.None));
      connect(relativeStates.flange_b,damper.flange_a) annotation(Line(points = {{18,92},{26,92},{26,70}}, color = {0,127,0}, smooth = Smooth.None));
      connect(sine4.y,force.f) annotation(Line(points = {{ -79,30},{ -72,30}}, color = {0,0,127}, smooth = Smooth.None));
    end AllComponents;
  end Translational;
  package Rotational "Test models for Modelica.Mechanics.Rotational"
    package ForUsersGuide "Models used as screenshot for the users guide"
      model SimpleDriveTrain
        Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{ -80,0},{ -60,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque torque(useSupport = true) annotation(Placement(transformation(extent = {{ -44,0},{ -24,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Fixed fixed annotation(Placement(transformation(extent = {{ -44, -20},{ -24,0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J1(J = 0.2) annotation(Placement(transformation(extent = {{ -10,0},{10,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.IdealGear gear(ratio = 5, useSupport = true) annotation(Placement(transformation(extent = {{20,0},{40,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J2(J = 5) annotation(Placement(transformation(extent = {{52,0},{72,20}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));

      equation 
        connect(sine.y,torque.tau) annotation(Line(points = {{ -59,10},{ -46,10}}, color = {0,0,127}, smooth = Smooth.None));
        connect(torque.support,fixed.flange) annotation(Line(points = {{ -34,0},{ -34, -10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(torque.flange,J1.flange_a) annotation(Line(points = {{ -24,10},{ -10,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(gear.flange_b,J2.flange_a) annotation(Line(points = {{40,10},{52,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(fixed.flange,gear.support) annotation(Line(points = {{ -34, -10},{30, -10},{30,0}}, color = {0,0,0}, smooth = Smooth.None));
        connect(J1.flange_b,gear.flange_a) annotation(Line(points = {{10,10},{20,10}}, color = {0,0,0}, smooth = Smooth.None));
      end SimpleDriveTrain;
      model ConnectionPossibilities
        Modelica.Mechanics.Rotational.Components.Inertia inertia1 annotation(Placement(transformation(extent = {{ -60,40},{ -40,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia2 annotation(Placement(transformation(extent = {{ -20,40},{0,60}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 2), experimentSetupOutput);
        Modelica.Mechanics.Rotational.Components.Inertia inertia3 annotation(Placement(transformation(extent = {{ -60, -20},{ -40,0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia4 annotation(Placement(transformation(extent = {{30, -20},{50,0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring1(c = 10000.0) annotation(Placement(transformation(extent = {{ -30, -20},{ -10,0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring2(c = 10000.0) annotation(Placement(transformation(extent = {{0, -20},{20,0}}, rotation = 0)));
        annotation(Diagram, experiment(StopTime = 1.1));

      equation 
        connect(inertia1.flange_b,inertia2.flange_a) annotation(Line(points = {{ -40,50},{ -20,50}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia3.flange_b,spring1.flange_a) annotation(Line(points = {{ -40, -10},{ -30, -10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring1.flange_b,spring2.flange_a) annotation(Line(points = {{ -10, -10},{0, -10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring2.flange_b,inertia4.flange_a) annotation(Line(points = {{20, -10},{30, -10}}, color = {0,0,0}, smooth = Smooth.None));
      end ConnectionPossibilities;
      model SupportTorque1
        Modelica.Blocks.Sources.Sine sine2 annotation(Placement(transformation(extent = {{ -80,0},{ -60,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque torque2(useSupport = true) annotation(Placement(transformation(extent = {{ -44,0},{ -24,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Fixed fixed1 annotation(Placement(transformation(extent = {{ -44, -20},{ -24,0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia3(J = 1) annotation(Placement(transformation(extent = {{ -14,0},{6,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.IdealGear idealGear2(ratio = 1, useSupport = true) annotation(Placement(transformation(extent = {{16,0},{36,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia4(J = 1) annotation(Placement(transformation(extent = {{74,0},{94,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.BearingFriction bearingFriction1(useSupport = true) annotation(Placement(transformation(extent = {{46,0},{66,20}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));
        annotation(Diagram, experiment(StopTime = 2), experimentSetupOutput);

      equation 
        connect(sine2.y,torque2.tau) annotation(Line(points = {{ -59,10},{ -46,10}}, color = {0,0,127}, smooth = Smooth.None));
        connect(torque2.support,fixed1.flange) annotation(Line(points = {{ -34,0},{ -34, -10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(torque2.flange,inertia3.flange_a) annotation(Line(points = {{ -24,10},{ -14,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(fixed1.flange,idealGear2.support) annotation(Line(points = {{ -34, -10},{26, -10},{26,0}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia3.flange_b,idealGear2.flange_a) annotation(Line(points = {{6,10},{16,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(idealGear2.flange_b,bearingFriction1.flange_a) annotation(Line(points = {{36,10},{46,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(bearingFriction1.flange_b,inertia4.flange_a) annotation(Line(points = {{66,10},{74,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(fixed1.flange,bearingFriction1.support) annotation(Line(points = {{ -34, -10},{56, -10},{56,0}}, color = {0,0,0}, smooth = Smooth.None));
      end SupportTorque1;
      model Directions
        Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque torque(useSupport = true) annotation(Placement(transformation(extent = {{ -44,60},{ -24,80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J1(J = 0.2) annotation(Placement(transformation(extent = {{ -10,60},{10,80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.IdealGear gear(ratio = 5, useSupport = true) annotation(Placement(transformation(extent = {{20,60},{40,80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J2(J = 5) annotation(Placement(transformation(extent = {{52,60},{72,80}}, rotation = 0)));
        Modelica.Blocks.Sources.Sine sine1 annotation(Placement(transformation(extent = {{ -80,10},{ -60,30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque torque1(useSupport = true) annotation(Placement(transformation(extent = {{ -44,10},{ -24,30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J3(J = 0.2) annotation(Placement(transformation(extent = {{ -10,10},{10,30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.IdealGear gear1(ratio = 1 / 5, useSupport = true) annotation(Placement(transformation(extent = {{40,10},{20,30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J4(J = 5) annotation(Placement(transformation(extent = {{52,10},{72,30}}, rotation = 0)));
        Modelica.Blocks.Sources.Sine sine2 annotation(Placement(transformation(extent = {{ -80, -50},{ -60, -30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque torque2(useSupport = true) annotation(Placement(transformation(extent = {{ -44, -50},{ -24, -30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J5(J = 0.2) annotation(Placement(transformation(extent = {{ -10, -50},{10, -30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.IdealGear gear2(ratio = 1 / 5, useSupport = true) annotation(Placement(transformation(extent = {{40, -50},{20, -30}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J6(J = 5) annotation(Placement(transformation(extent = {{72, -50},{52, -30}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Polygon(points = {{ -23,97},{ -13,94},{ -23,91},{ -23,97}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{ -23,94},{ -53,94}}, color = {0,0,0}),Text(extent = {{ -18,98},{72,90}}, lineColor = {0,0,0}, textString = "(positive) axis of rotation")}), experiment(StopTime = 2), experimentSetupOutput);
        Modelica.Mechanics.Rotational.Components.Fixed fixed1 annotation(Placement(transformation(extent = {{ -10,42},{10,62}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Fixed fixed2 annotation(Placement(transformation(extent = {{ -10, -6},{10,14}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Fixed fixed3 annotation(Placement(transformation(extent = {{ -10, -66},{10, -46}}, rotation = 0)));

      equation 
        connect(sine.y,torque.tau) annotation(Line(points = {{ -59,70},{ -46,70}}, color = {0,0,127}, smooth = Smooth.None));
        connect(torque.flange,J1.flange_a) annotation(Line(points = {{ -24,70},{ -10,70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(gear.flange_b,J2.flange_a) annotation(Line(points = {{40,70},{52,70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(J1.flange_b,gear.flange_a) annotation(Line(points = {{10,70},{20,70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(sine1.y,torque1.tau) annotation(Line(points = {{ -59,20},{ -46,20}}, color = {0,0,127}, smooth = Smooth.None));
        connect(torque1.flange,J3.flange_a) annotation(Line(points = {{ -24,20},{ -10,20}}, color = {0,0,0}, smooth = Smooth.None));
        connect(J3.flange_b,gear1.flange_b) annotation(Line(points = {{10,20},{20,20}}, color = {0,0,0}, smooth = Smooth.None));
        connect(gear1.flange_a,J4.flange_a) annotation(Line(points = {{40,20},{52,20}}, color = {0,0,0}, smooth = Smooth.None));
        connect(sine2.y,torque2.tau) annotation(Line(points = {{ -59, -40},{ -46, -40}}, color = {0,0,127}, smooth = Smooth.None));
        connect(torque2.flange,J5.flange_a) annotation(Line(points = {{ -24, -40},{ -10, -40}}, color = {0,0,0}, smooth = Smooth.None));
        connect(J5.flange_b,gear2.flange_b) annotation(Line(points = {{10, -40},{20, -40}}, color = {0,0,0}, smooth = Smooth.None));
        connect(gear2.flange_a,J6.flange_b) annotation(Line(points = {{40, -40},{52, -40}}, color = {0,0,0}, smooth = Smooth.None));
        connect(torque.support,fixed1.flange) annotation(Line(points = {{ -34,60},{ -34,52},{0,52}}, color = {0,0,0}, smooth = Smooth.None));
        connect(fixed1.flange,gear.support) annotation(Line(points = {{0,52},{30,52},{30,60}}, color = {0,0,0}, smooth = Smooth.None));
        connect(torque1.support,fixed2.flange) annotation(Line(points = {{ -34,10},{ -34,4},{0,4}}, color = {0,0,0}, smooth = Smooth.None));
        connect(fixed2.flange,gear1.support) annotation(Line(points = {{0,4},{30,4},{30,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(torque2.support,fixed3.flange) annotation(Line(points = {{ -34, -50},{ -34, -56},{0, -56}}, color = {0,0,0}, smooth = Smooth.None));
        connect(fixed3.flange,gear2.support) annotation(Line(points = {{0, -56},{30, -56},{30, -50}}, color = {0,0,0}, smooth = Smooth.None));
      end Directions;
      model Directions2
        Modelica.Mechanics.Rotational.Components.Inertia J2(J = 5) annotation(Placement(transformation(extent = {{ -60,55},{ -40,75}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics = {Text(extent = {{ -28,94},{62,86}}, lineColor = {0,0,0}, textString = "(positive) axis of rotation"),Line(points = {{ -61,65},{ -80,65}}, color = {0,0,0}),Polygon(points = {{ -68,67},{ -61,65},{ -68,63},{ -68,67}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{ -57,69},{ -91,73}}, lineColor = {0,0,0}, textString = "J2.flange_a.tau"),Line(points = {{ -42,45},{ -61,45}}, color = {0,0,0}),Polygon(points = {{ -49,47},{ -42,45},{ -49,43},{ -49,47}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{ -33,38},{ -67,42}}, lineColor = {0,0,0}, textString = "J2.w"),Line(points = {{ -9,65},{ -28,65}}, color = {0,0,0}),Polygon(points = {{ -16,67},{ -9,65},{ -16,63},{ -16,67}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{ -5,69},{ -39,73}}, lineColor = {0,0,0}, textString = "J4.flange_a.tau"),Line(points = {{10,45},{ -9,45}}, color = {0,0,0}),Polygon(points = {{3,47},{10,45},{3,43},{3,47}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{19,38},{ -15,42}}, lineColor = {0,0,0}, textString = "J4.w"),Line(points = {{44,65},{25,65}}, color = {0,0,0}),Polygon(points = {{37,67},{44,65},{37,63},{37,67}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{48,69},{14,73}}, lineColor = {0,0,0}, textString = "J6.flange_b.tau"),Line(points = {{63,45},{44,45}}, color = {0,0,0}),Polygon(points = {{56,47},{63,45},{56,43},{56,47}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{72,38},{38,42}}, lineColor = {0,0,0}, textString = "J6.w"),Line(points = {{ -32,90},{ -62,90}}, color = {0,0,0}),Polygon(points = {{ -32,93},{ -22,90},{ -32,87},{ -32,93}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Text(extent = {{ -19,24},{71,16}}, lineColor = {0,0,0}, textString = "(positive) axis of rotation"),Line(points = {{ -23,20},{ -53,20}}, color = {0,0,0}),Polygon(points = {{ -23,23},{ -13,20},{ -23,17},{ -23,23}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Polygon(points = {{ -47, -47},{ -54, -49},{ -47, -51},{ -47, -47}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{ -52, -49},{ -33, -49}}, color = {0,0,0}),Line(points = {{31.5, -79.5},{31.5, -60.5}}, color = {0,0,0}),Polygon(points = {{29.5, -75.5},{31.5, -82.5},{33.5, -75.5},{29.5, -75.5}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid)}), experiment(StopTime = 2));
        Modelica.Mechanics.Rotational.Components.Inertia J4(J = 5) annotation(Placement(transformation(extent = {{ -8,55},{12,75}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J6(J = 5) annotation(Placement(transformation(extent = {{65,55},{45,75}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia1 annotation(Placement(transformation(extent = {{ -30, -10},{ -10,10}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque torque1(useSupport = true) annotation(Placement(transformation(extent = {{ -60, -10},{ -40,10}}, rotation = 0)));
        Modelica.Blocks.Sources.Sine sine1 annotation(Placement(transformation(extent = {{ -90, -10},{ -70,10}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia2 annotation(Placement(transformation(extent = {{10, -10},{30,10}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Sources.Torque torque2(useSupport = true) annotation(Placement(transformation(extent = {{60, -10},{40,10}}, rotation = 0)));
        Modelica.Blocks.Sources.Sine sine2 annotation(Placement(transformation(extent = {{90, -10},{70,10}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia3 annotation(Placement(transformation(extent = {{ -80, -100},{ -60, -80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia4 annotation(Placement(transformation(extent = {{ -6, -64},{ -26, -44}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.IdealPlanetary idealPlanetary1 annotation(Placement(transformation(extent = {{ -50, -100},{ -30, -80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.IdealPlanetary idealPlanetary2 annotation(Placement(transformation(extent = {{60, -100},{80, -80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia5 annotation(Placement(transformation(extent = {{0, -100},{20, -80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia6 annotation(Placement(transformation(origin = {40, -50}, extent = {{ -10,10},{10, -10}}, rotation = 90)));
        Modelica.Mechanics.Rotational.Components.Fixed fixed1 annotation(Placement(transformation(extent = {{ -60, -27},{ -40, -7}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Fixed fixed2 annotation(Placement(transformation(extent = {{40, -24},{60, -4}}, rotation = 0)));

      equation 
        connect(torque1.flange,inertia1.flange_a) annotation(Line(points = {{ -40,0},{ -30,0}}, color = {0,0,0}, smooth = Smooth.None));
        connect(sine1.y,torque1.tau) annotation(Line(points = {{ -69,0},{ -62,0}}, color = {0,0,127}, smooth = Smooth.None));
        connect(torque2.flange,inertia2.flange_b) annotation(Line(points = {{40,0},{30,0}}, color = {0,0,0}, smooth = Smooth.None));
        connect(sine2.y,torque2.tau) annotation(Line(points = {{69,0},{62,0}}, color = {0,0,127}, smooth = Smooth.None));
        connect(idealPlanetary1.sun,inertia3.flange_b) annotation(Line(points = {{ -50, -90},{ -60, -90}}, color = {0,0,0}, smooth = Smooth.None));
        connect(idealPlanetary1.carrier,inertia4.flange_b) annotation(Line(points = {{ -50, -86},{ -56, -86},{ -56, -54},{ -26, -54}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia5.flange_b,idealPlanetary2.sun) annotation(Line(points = {{20, -90},{60, -90}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia6.flange_a,idealPlanetary2.carrier) annotation(Line(points = {{40, -60},{40, -86},{60, -86}}, color = {0,0,0}, smooth = Smooth.None));
        connect(torque1.support,fixed1.flange) annotation(Line(points = {{ -50, -10},{ -50, -17}}, color = {0,0,0}, smooth = Smooth.None));
        connect(fixed2.flange,torque2.support) annotation(Line(points = {{50, -14},{50, -10}}, color = {0,0,0}, smooth = Smooth.None));
      end Directions2;
      model Directions3
        Modelica.Mechanics.Rotational.Components.Inertia J1(J = 1) annotation(Placement(transformation(extent = {{ -80,40},{ -60,60}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics = {Line(points = {{ -60,33},{ -79,33}}, color = {0,0,0}),Polygon(points = {{ -67,35},{ -60,33},{ -67,31},{ -67,35}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Polygon(points = {{ -32,35},{ -39,33},{ -32,31},{ -32,35}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{ -16,33},{ -35,33}}, color = {0,0,0}),Text(extent = {{ -10,60},{14,40}}, lineColor = {0,0,0}, textString = "="),Line(points = {{40,33},{21,33}}, color = {0,0,0}),Polygon(points = {{33,35},{40,33},{33,31},{33,35}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid),Line(points = {{80,27},{61,27}}, color = {0,0,0}),Polygon(points = {{73,29},{80,27},{73,25},{73,29}}, lineColor = {0,0,0}, fillColor = {0,0,0}, fillPattern = FillPattern.Solid)}), experiment(StopTime = 2));
        Modelica.Mechanics.Rotational.Components.Inertia J2(J = 1) annotation(Placement(transformation(extent = {{ -20,40},{ -40,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J3(J = 1) annotation(Placement(transformation(extent = {{20,40},{40,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia J4(J = 1) annotation(Placement(transformation(extent = {{60,40},{80,60}}, rotation = 0)));

      equation 
        connect(J1.flange_b,J2.flange_b) annotation(Line(points = {{ -60,50},{ -40,50}}, color = {0,0,0}, smooth = Smooth.None));
        connect(J3.flange_b,J4.flange_b) annotation(Line(points = {{40,50},{50,50},{50,34},{86,34},{86,50},{80,50}}, color = {0,0,0}, smooth = Smooth.None));
      end Directions3;
    end ForUsersGuide;
    package InitializationConversion
      model Inertia
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));
        Modelica.Mechanics.Rotational.Components.Inertia inertia1(phi(start = 0.0174532925199433), w(start = 2)) annotation(Placement(transformation(extent = {{ -86,40},{ -66,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia2(stateSelect = StateSelect.default, a(fixed = true), phi(fixed = false, start = 0.0174532925199433), w(fixed = true, start = 2)) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia3(stateSelect = StateSelect.prefer, a(fixed = false), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{40,40},{60,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia4(stateSelect = StateSelect.always, a(fixed = false), phi(fixed = true, start =  -0.0174532925199433), w(fixed = false, start =  -2)) annotation(Placement(transformation(extent = {{80,40},{100,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia5(stateSelect = StateSelect.avoid, a(fixed = false), phi(fixed = false, start = 0.383972435438752), w(fixed = true, start = 33)) annotation(Placement(transformation(extent = {{ -86,0},{ -66,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia6(a(fixed = true, start = 44), phi(fixed = false), w(fixed = false)) annotation(Placement(transformation(extent = {{ -14,0},{6,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia7(a(fixed = true, start = 3), phi(fixed = true, start = 0.0174532925199433), w(fixed = false, start = 2)) annotation(Placement(transformation(extent = {{22,0},{42,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia8(a(fixed = true), phi(fixed = false), w(fixed = true)) annotation(Placement(transformation(extent = {{ -84, -40},{ -64, -20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia9(a(fixed = true, start = 33), phi(fixed = true, start = 0.191986217719376), w(fixed = true, start = 22)) annotation(Placement(transformation(extent = {{20, -40},{40, -20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring(c = 10000) annotation(Placement(transformation(extent = {{ -28,40},{ -8,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Fixed fixed annotation(Placement(transformation(extent = {{ -50,40},{ -30,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring1(c = 10000) annotation(Placement(transformation(extent = {{50,0},{70,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia7a(a(start = 3), phi(start = 0.0174532925199433), w(start = 2)) annotation(Placement(transformation(extent = {{80,0},{100,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring2(c = 10000) annotation(Placement(transformation(extent = {{ -40,0},{ -20,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Fixed fixed1 annotation(Placement(transformation(extent = {{ -60,0},{ -40,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring3(c = 10000) annotation(Placement(transformation(extent = {{ -52, -40},{ -32, -20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia8a annotation(Placement(transformation(extent = {{ -26, -40},{ -6, -20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring4(c = 10000) annotation(Placement(transformation(extent = {{52, -40},{72, -20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia9a(a(start = 33), phi(start = 0.191986217719376), w(start = 22)) annotation(Placement(transformation(extent = {{80, -40},{100, -20}}, rotation = 0)));

      equation 
        connect(spring.flange_b,inertia2.flange_a) annotation(Line(points = {{ -8,50},{0,50}}, color = {0,0,0}, smooth = Smooth.None));
        connect(fixed.flange,spring.flange_a) annotation(Line(points = {{ -40,50},{ -28,50}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia7.flange_b,spring1.flange_a) annotation(Line(points = {{42,10},{50,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring1.flange_b,inertia7a.flange_a) annotation(Line(points = {{70,10},{80,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring2.flange_b,inertia6.flange_a) annotation(Line(points = {{ -20,10},{ -14,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(fixed1.flange,spring2.flange_a) annotation(Line(points = {{ -50,10},{ -40,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia8.flange_b,spring3.flange_a) annotation(Line(points = {{ -64, -30},{ -52, -30}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring3.flange_b,inertia8a.flange_a) annotation(Line(points = {{ -32, -30},{ -26, -30}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia9.flange_b,spring4.flange_a) annotation(Line(points = {{40, -30},{52, -30}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring4.flange_b,inertia9a.flange_a) annotation(Line(points = {{72, -30},{80, -30}}, color = {0,0,0}, smooth = Smooth.None));
      end Inertia;
      model SpringDamper
        Modelica.Mechanics.Rotational.Components.SpringDamper springDamper1(c = 10000.0, d = 10, phi_rel(start = 1), w_rel(start = 2)) annotation(Placement(transformation(extent = {{ -70,60},{ -50,80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Fixed fixed annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));
        Modelica.Mechanics.Rotational.Components.Inertia inertia1 annotation(Placement(transformation(extent = {{ -40,60},{ -20,80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia2 annotation(Placement(transformation(extent = {{ -40,20},{ -20,40}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.SpringDamper springDamper2(c = 10000.0, d = 10, stateSelect = StateSelect.prefer, a_rel(fixed = true), phi_rel(fixed = false, start =  -1), w_rel(fixed = true, start =  -2)) annotation(Placement(transformation(extent = {{ -70,20},{ -50,40}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.SpringDamper springDamper3(c = 10000.0, d = 10, stateSelect = StateSelect.always, a_rel(fixed = false), phi_rel(fixed = true, start = 1), w_rel(fixed = true, start = 2)) annotation(Placement(transformation(extent = {{ -70, -20},{ -50,0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia3 annotation(Placement(transformation(extent = {{ -40, -20},{ -20,0}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.SpringDamper springDamper4(c = 10000.0, d = 10, stateSelect = StateSelect.avoid, a_rel(fixed = false), phi_rel(fixed = true), w_rel(fixed = false)) annotation(Placement(transformation(extent = {{ -70, -60},{ -50, -40}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia4 annotation(Placement(transformation(extent = {{ -40, -60},{ -20, -40}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.SpringDamper springDamper5(c = 10000.0, d = 10, stateSelect = StateSelect.never, a_rel(fixed = false), phi_rel(fixed = false), w_rel(fixed = true, start = 3)) annotation(Placement(transformation(extent = {{ -70, -100},{ -50, -80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia5 annotation(Placement(transformation(extent = {{ -40, -100},{ -20, -80}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia6 annotation(Placement(transformation(extent = {{20,40},{40,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring(c = 10000.0) annotation(Placement(transformation(extent = {{48,40},{68,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Inertia inertia7 annotation(Placement(transformation(extent = {{74,40},{94,60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.RelativeStates relativeStates annotation(Placement(transformation(extent = {{48,20},{68,40}}, rotation = 0)));

      equation 
        connect(springDamper1.flange_a,fixed.flange) annotation(Line(points = {{ -70,70},{ -90,70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(springDamper1.flange_b,inertia1.flange_a) annotation(Line(points = {{ -50,70},{ -40,70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia2.flange_a,springDamper2.flange_b) annotation(Line(points = {{ -40,30},{ -50,30}}, color = {0,0,0}, smooth = Smooth.None));
        connect(springDamper2.flange_a,fixed.flange) annotation(Line(points = {{ -70,30},{ -80,30},{ -80,70},{ -90,70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia3.flange_a,springDamper3.flange_b) annotation(Line(points = {{ -40, -10},{ -50, -10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(springDamper3.flange_a,fixed.flange) annotation(Line(points = {{ -70, -10},{ -80, -10},{ -80,70},{ -90,70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia4.flange_a,springDamper4.flange_b) annotation(Line(points = {{ -40, -50},{ -50, -50}}, color = {0,0,0}, smooth = Smooth.None));
        connect(springDamper4.flange_a,fixed.flange) annotation(Line(points = {{ -70, -50},{ -80, -50},{ -80,70},{ -90,70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia5.flange_a,springDamper5.flange_b) annotation(Line(points = {{ -40, -90},{ -50, -90}}, color = {0,0,0}, smooth = Smooth.None));
        connect(springDamper5.flange_a,fixed.flange) annotation(Line(points = {{ -70, -90},{ -80, -90},{ -80,70},{ -90,70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(inertia6.flange_b,spring.flange_a) annotation(Line(points = {{40,50},{48,50}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring.flange_b,inertia7.flange_a) annotation(Line(points = {{68,50},{74,50}}, color = {0,0,0}, smooth = Smooth.None));
        connect(relativeStates.flange_b,spring.flange_b) annotation(Line(points = {{68,30},{68,50}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring.flange_a,relativeStates.flange_a) annotation(Line(points = {{48,50},{48,30},{48,30}}, color = {0,0,0}, smooth = Smooth.None));
      end SpringDamper;
    end InitializationConversion;
    model TestSpeed
      Modelica.Mechanics.Rotational.Sources.Speed speed1(f_crit = 5, useSupport = false) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia1 annotation(Placement(transformation(extent = {{20,60},{40,80}}, rotation = 0)));
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));
      Modelica.Mechanics.Rotational.Sources.Speed speed2(f_crit = 5, exact = true, useSupport = false) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia2 annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine2 annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
      Modelica.Blocks.Sources.Step step(startTime = 0.5) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
      Modelica.Mechanics.Translational.Sources.Speed speed3(f_crit = 5, s(start = 1)) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass mass1(m = 2) annotation(Placement(transformation(extent = {{20, -20},{40,0}}, rotation = 0)));
      Modelica.Blocks.Sources.Step step1(startTime = 0.5) annotation(Placement(transformation(extent = {{ -60, -20},{ -40,0}}, rotation = 0)));
      Modelica.Mechanics.Translational.Sources.Speed speed4(exact = true, s(start = 1)) annotation(Placement(transformation(extent = {{ -20, -60},{0, -40}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass mass2(m = 2) annotation(Placement(transformation(extent = {{20, -60},{40, -40}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine4 annotation(Placement(transformation(extent = {{ -60, -60},{ -40, -40}}, rotation = 0)));

    equation 
      connect(speed1.flange,inertia1.flange_a) annotation(Line(points = {{0,70},{20,70}}, color = {0,0,0}));
      connect(speed2.flange,inertia2.flange_a) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}));
      connect(sine2.y,speed2.w_ref) annotation(Line(points = {{ -39,30},{ -22,30}}, color = {0,0,127}));
      connect(step.y,speed1.w_ref) annotation(Line(points = {{ -39,70},{ -22,70}}, color = {0,0,127}));
      connect(speed3.flange,mass1.flange_a) annotation(Line(points = {{0, -10},{20, -10}}, color = {0,127,0}));
      connect(step1.y,speed3.v_ref) annotation(Line(points = {{ -39, -10},{ -22, -10}}, color = {0,0,127}));
      connect(speed4.flange,mass2.flange_a) annotation(Line(points = {{0, -50},{20, -50}}, color = {0,127,0}));
      connect(sine4.y,speed4.v_ref) annotation(Line(points = {{ -39, -50},{ -22, -50}}, color = {0,0,127}));
    end TestSpeed;
    model TestMove
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));
      Modelica.Mechanics.MultiBody.Parts.Body Body1(I_33 = 2) annotation(Placement(transformation(extent = {{66,36},{86,56}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Joints.Revolute ActuatedRevolute1(useAxisFlange = true) annotation(Placement(transformation(extent = {{32,0},{52,20}}, rotation = 0)));
      inner Modelica.Mechanics.MultiBody.World world(g = 0) annotation(Placement(transformation(extent = {{0,0},{20,20}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Move move(useSupport = false) annotation(Placement(transformation(extent = {{20,40},{40,60}}, rotation = 0)));
      Modelica.Blocks.Routing.Multiplex3 Multiplex3_1 annotation(Placement(transformation(extent = {{ -56,40},{ -36,60}}, rotation = 0)));
      Modelica.Blocks.Sources.Constant Constant1 annotation(Placement(transformation(extent = {{ -100,16},{ -80,36}}, rotation = 0)));
      Modelica.Blocks.Sources.Constant Constant2(k = 0) annotation(Placement(transformation(extent = {{ -100,70},{ -80,90}}, rotation = 0)));
      Modelica.Mechanics.Translational.Sources.Move move1 annotation(Placement(transformation(extent = {{ -20, -40},{0, -20}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass(m = 2) annotation(Placement(transformation(extent = {{20, -40},{40, -20}}, rotation = 0)));

    equation 
      connect(ActuatedRevolute1.frame_b,Body1.frame_a) annotation(Line(points = {{52,10},{62,10},{62,46},{66,46}}, color = {0,0,0}, thickness = 0.5));
      connect(world.frame_b,ActuatedRevolute1.frame_a) annotation(Line(points = {{20,10},{32,10}}, color = {0,0,0}, thickness = 0.5));
      connect(move.flange,ActuatedRevolute1.axis) annotation(Line(points = {{40,50},{42,50},{42,20}}, color = {0,0,0}));
      connect(Multiplex3_1.y,move.u) annotation(Line(points = {{ -35,50},{18,50}}, color = {0,0,127}));
      connect(Constant1.y,Multiplex3_1.u3[1]) annotation(Line(points = {{ -79,26},{ -74,26},{ -74,43},{ -58,43}}, color = {0,0,127}));
      connect(Constant2.y,Multiplex3_1.u1[1]) annotation(Line(points = {{ -79,80},{ -74,80},{ -74,57},{ -58,57}}, color = {0,0,127}));
      connect(Constant2.y,Multiplex3_1.u2[1]) annotation(Line(points = {{ -79,80},{ -74,80},{ -74,50},{ -58,50}}, color = {0,0,127}));
      connect(Multiplex3_1.y,move1.u) annotation(Line(points = {{ -35,50},{ -28,50},{ -28, -30},{ -22, -30}}, color = {0,0,127}));
      connect(move1.flange,slidingMass.flange_a) annotation(Line(points = {{0, -30},{20, -30}}, color = {0,127,0}));
    end TestMove;
    model AllComponents
      Modelica.Mechanics.Rotational.Components.Inertia inertia(J = 3) annotation(Placement(transformation(extent = {{ -60,40},{ -40,60}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.IdealGear idealGear(ratio = 3, useSupport = true) annotation(Placement(transformation(extent = {{ -30,40},{ -10,60}}, rotation = 0)));
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -140, -200},{200,100}}, initialScale = 0.1), graphics), experiment(StopTime = 0.9));
      Modelica.Mechanics.Rotational.Components.IdealPlanetary idealPlanetary(ratio = 3) annotation(Placement(transformation(extent = {{4,40},{24,60}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed annotation(Placement(transformation(extent = {{ -30,10},{ -10,30}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia1(J = 2) annotation(Placement(transformation(extent = {{ -30,80},{ -10,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia2(J = 4) annotation(Placement(transformation(extent = {{60,40},{80,60}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Spring spring(c = 10000.0) annotation(Placement(transformation(extent = {{32,40},{52,60}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Damper damper(d = 10) annotation(Placement(transformation(extent = {{32,58},{52,78}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.SpringDamper springDamper(c = 10000.0, d = 10, phi_rel0 = 1.74532925199433e-05) annotation(Placement(transformation(extent = {{ -58,80},{ -38,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia3(J = 2, phi(start = 0.0174532925199433), w(start = 2)) annotation(Placement(transformation(extent = {{ -92,80},{ -72,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.ElastoBacklash elastoBacklash(b = 1.74532925199433e-07, c = 10000.0, d = 20) annotation(Placement(transformation(extent = {{10,80},{30,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia4(J = 2) annotation(Placement(transformation(extent = {{40,80},{60,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.BearingFriction bearingFriction(tau_pos = [0,2], peak = 1.1, useSupport = true) annotation(Placement(transformation(extent = {{64,80},{84,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Clutch clutch(mue_pos = [0,1], peak = 1.1, cgeo = 1.2, fn_max = 1.3) annotation(Placement(transformation(extent = {{ -86,60},{ -66,40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia5(J = 3) annotation(Placement(transformation(extent = {{ -116,40},{ -96,60}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{ -104,10},{ -84,30}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Brake brake(useSupport = true) annotation(Placement(transformation(extent = {{100,40},{120,60}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine1 annotation(Placement(transformation(origin = {110,90}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
      Modelica.Mechanics.Rotational.Components.LossyGear lossyGear(useSupport = true) annotation(Placement(transformation(extent = {{ -120,80},{ -100,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia6(J = 2, a(fixed = false), phi(fixed = true, start = 0.0174532925199433), w(fixed = true, start = 2)) annotation(Placement(transformation(extent = {{ -150,80},{ -130,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Gearbox gear2_1(ratio = 2, lossTable = [0,0.9,1,0,0], c = 10000.0, d = 10, b = 1.74532925199433e-07, useSupport = true) annotation(Placement(transformation(extent = {{ -80, -40},{ -60, -20}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia7(J = 3) annotation(Placement(transformation(extent = {{ -110, -40},{ -90, -20}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia8(J = 3) annotation(Placement(transformation(extent = {{ -48, -40},{ -28, -20}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Position position(useSupport = true) annotation(Placement(transformation(extent = {{48, -10},{68,10}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed1 annotation(Placement(transformation(extent = {{ -80, -60},{ -60, -40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed2 annotation(Placement(transformation(extent = {{48, -30},{68, -10}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia9(J = 3) annotation(Placement(transformation(extent = {{80, -10},{100,10}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine2 annotation(Placement(transformation(extent = {{18, -10},{38,10}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine3 annotation(Placement(transformation(extent = {{20, -60},{40, -40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia10(J = 3) annotation(Placement(transformation(extent = {{80, -60},{100, -40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed3 annotation(Placement(transformation(extent = {{50, -80},{70, -60}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Speed speed(useSupport = true) annotation(Placement(transformation(extent = {{50, -60},{70, -40}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine4 annotation(Placement(transformation(extent = {{20, -120},{40, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia11(J = 3) annotation(Placement(transformation(extent = {{80, -120},{100, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed4 annotation(Placement(transformation(extent = {{50, -140},{70, -120}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Accelerate accelerate(useSupport = true) annotation(Placement(transformation(extent = {{50, -120},{70, -100}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine5[3](each amplitude = 2) annotation(Placement(transformation(extent = {{20, -180},{40, -160}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia12(J = 3) annotation(Placement(transformation(extent = {{80, -180},{100, -160}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed5 annotation(Placement(transformation(extent = {{50, -200},{70, -180}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Move move(useSupport = true) annotation(Placement(transformation(extent = {{50, -180},{70, -160}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Torque torque(useSupport = true) annotation(Placement(transformation(extent = {{160,40},{140,60}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine6 annotation(Placement(transformation(extent = {{192,40},{172,60}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Torque2 torque2_1 annotation(Placement(transformation(extent = {{112, -60},{132, -40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia13(J = 3) annotation(Placement(transformation(extent = {{140, -60},{160, -40}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine7 annotation(Placement(transformation(extent = {{94, -34},{114, -14}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.LinearSpeedDependentTorque linearSpeedDependentTorque(tau_nominal = 10, w_nominal = 10, useSupport = true) annotation(Placement(transformation(extent = {{ -142, -40},{ -122, -20}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque quadraticSpeedDependentTorque(tau_nominal = 100, w_nominal = 1, useSupport = true) annotation(Placement(transformation(extent = {{6, -40},{ -16, -20}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.ConstantTorque constantTorque(tau_constant = 11, useSupport = true) annotation(Placement(transformation(extent = {{ -120, -100},{ -100, -80}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia14(J = 3) annotation(Placement(transformation(extent = {{ -84, -120},{ -64, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStep(stepTorque = 22, offsetTorque = 11, startTime = 1, useSupport = true) annotation(Placement(transformation(extent = {{ -120, -140},{ -100, -120}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed6 annotation(Placement(transformation(extent = {{ -120, -162},{ -100, -142}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.ConstantSpeed constantSpeed(w_fixed = 11, useSupport = true) annotation(Placement(transformation(extent = {{ -60, -140},{ -40, -120}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia15(J = 3) annotation(Placement(transformation(extent = {{ -30, -140},{ -10, -120}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.RelativeStates relativeStates annotation(Placement(transformation(extent = {{ -60, -80},{ -40, -60}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sensors.AngleSensor angleSensor annotation(Placement(transformation(extent = {{118, -120},{138, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor annotation(Placement(transformation(extent = {{118, -96},{138, -76}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sensors.AccSensor accSensor annotation(Placement(transformation(extent = {{118, -146},{138, -126}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sensors.RelAngleSensor relAngleSensor annotation(Placement(transformation(extent = {{152, -20},{172,0}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sensors.RelSpeedSensor relSpeedSensor annotation(Placement(transformation(extent = {{166, -88},{186, -68}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sensors.RelAccSensor relAccSensor annotation(Placement(transformation(extent = {{160, -130},{180, -110}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sensors.TorqueSensor torqueSensor annotation(Placement(transformation(extent = {{ -26, -170},{ -6, -150}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sensors.PowerSensor powerSensor annotation(Placement(transformation(extent = {{ -58, -170},{ -38, -150}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia16(J = 3) annotation(Placement(transformation(extent = {{ -88, -170},{ -68, -150}}, rotation = 0)));

    equation 
      connect(inertia.flange_b,idealGear.flange_a) annotation(Line(points = {{ -40,50},{ -30,50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealGear.flange_b,idealPlanetary.sun) annotation(Line(points = {{ -10,50},{4,50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealGear.support,fixed.flange) annotation(Line(points = {{ -20,40},{ -20,20}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealPlanetary.carrier,inertia1.flange_b) annotation(Line(points = {{4,54},{ -2,54},{ -2,90},{ -10,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealPlanetary.ring,spring.flange_a) annotation(Line(points = {{24,50},{32,50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(spring.flange_b,inertia2.flange_a) annotation(Line(points = {{52,50},{60,50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealPlanetary.ring,damper.flange_a) annotation(Line(points = {{24,50},{28,50},{28,68},{32,68}}, color = {0,0,0}, smooth = Smooth.None));
      connect(damper.flange_b,inertia2.flange_a) annotation(Line(points = {{52,68},{60,68},{60,50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(springDamper.flange_b,inertia1.flange_a) annotation(Line(points = {{ -38,90},{ -30,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia3.flange_b,springDamper.flange_a) annotation(Line(points = {{ -72,90},{ -58,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia1.flange_b,elastoBacklash.flange_a) annotation(Line(points = {{ -10,90},{10,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(elastoBacklash.flange_b,inertia4.flange_a) annotation(Line(points = {{30,90},{40,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia4.flange_b,bearingFriction.flange_a) annotation(Line(points = {{60,90},{64,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed.flange,bearingFriction.support) annotation(Line(points = {{ -20,20},{92,20},{92,74},{74,74},{74,80}}, color = {0,0,0}, smooth = Smooth.None));
      connect(clutch.flange_b,inertia.flange_a) annotation(Line(points = {{ -66,50},{ -60,50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia5.flange_b,clutch.flange_a) annotation(Line(points = {{ -96,50},{ -86,50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine.y,clutch.f_normalized) annotation(Line(points = {{ -83,20},{ -76,20},{ -76,39}}, color = {0,0,127}, smooth = Smooth.None));
      connect(inertia2.flange_b,brake.flange_a) annotation(Line(points = {{80,50},{100,50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine1.y,brake.f_normalized) annotation(Line(points = {{110,79},{110,61}}, color = {0,0,127}, smooth = Smooth.None));
      connect(fixed.flange,brake.support) annotation(Line(points = {{ -20,20},{110,20},{110,40}}, color = {0,0,0}, smooth = Smooth.None));
      connect(lossyGear.flange_b,inertia3.flange_a) annotation(Line(points = {{ -100,90},{ -92,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia6.flange_b,lossyGear.flange_a) annotation(Line(points = {{ -130,90},{ -120,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(lossyGear.support,fixed.flange) annotation(Line(points = {{ -110,80},{ -112,80},{ -112,64},{ -130,64},{ -130, -6},{ -44, -6},{ -44,20},{ -20,20}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia7.flange_b,gear2_1.flange_a) annotation(Line(points = {{ -90, -30},{ -80, -30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(gear2_1.flange_b,inertia8.flange_a) annotation(Line(points = {{ -60, -30},{ -48, -30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed1.flange,gear2_1.support) annotation(Line(points = {{ -70, -50},{ -70, -40}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed2.flange,position.support) annotation(Line(points = {{58, -20},{58, -10}}, color = {0,0,0}, smooth = Smooth.None));
      connect(position.flange,inertia9.flange_a) annotation(Line(points = {{68,0},{80,0}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine2.y,position.phi_ref) annotation(Line(points = {{39,0},{46,0}}, color = {0,0,127}, smooth = Smooth.None));
      connect(sine3.y,speed.w_ref) annotation(Line(points = {{41, -50},{48, -50}}, color = {0,0,127}, smooth = Smooth.None));
      connect(speed.flange,inertia10.flange_a) annotation(Line(points = {{70, -50},{80, -50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(speed.support,fixed3.flange) annotation(Line(points = {{60, -60},{60, -70}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine4.y,accelerate.a_ref) annotation(Line(points = {{41, -110},{48, -110}}, color = {0,0,127}, smooth = Smooth.None));
      connect(accelerate.flange,inertia11.flange_a) annotation(Line(points = {{70, -110},{80, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(accelerate.support,fixed4.flange) annotation(Line(points = {{60, -120},{60, -130}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine5.y,move.u) annotation(Line(points = {{41, -170},{48, -170}}, color = {0,0,127}, smooth = Smooth.None));
      connect(move.flange,inertia12.flange_a) annotation(Line(points = {{70, -170},{80, -170}}, color = {0,0,0}, smooth = Smooth.None));
      connect(move.support,fixed5.flange) annotation(Line(points = {{60, -180},{60, -190}}, color = {0,0,0}, smooth = Smooth.None));
      connect(brake.flange_b,torque.flange) annotation(Line(points = {{120,50},{140,50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed.flange,torque.support) annotation(Line(points = {{ -20,20},{150,20},{150,40}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine6.y,torque.tau) annotation(Line(points = {{171,50},{164.5,50},{164.5,50},{162,50}}, color = {0,0,127}, smooth = Smooth.None));
      connect(torque2_1.flange_a,inertia10.flange_b) annotation(Line(points = {{112, -50},{100, -50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(torque2_1.flange_b,inertia13.flange_a) annotation(Line(points = {{132, -50},{140, -50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine7.y,torque2_1.tau) annotation(Line(points = {{115, -24},{122, -24},{122, -46}}, color = {0,0,127}, smooth = Smooth.None));
      connect(linearSpeedDependentTorque.flange,inertia7.flange_a) annotation(Line(points = {{ -122, -30},{ -110, -30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(linearSpeedDependentTorque.support,fixed1.flange) annotation(Line(points = {{ -132, -42},{ -132, -50},{ -70, -50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(quadraticSpeedDependentTorque.flange,inertia8.flange_b) annotation(Line(points = {{ -16, -30},{ -28, -30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed1.flange,quadraticSpeedDependentTorque.support) annotation(Line(points = {{ -70, -50},{ -5, -50},{ -5, -42}}, color = {0,0,0}, smooth = Smooth.None));
      connect(constantTorque.flange,inertia14.flange_a) annotation(Line(points = {{ -100, -90},{ -92, -90},{ -92, -110},{ -84, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(torqueStep.flange,inertia14.flange_a) annotation(Line(points = {{ -100, -130},{ -84, -130},{ -84, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed6.flange,torqueStep.support) annotation(Line(points = {{ -110, -152},{ -110, -142}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed6.flange,constantTorque.support) annotation(Line(points = {{ -110, -152},{ -130, -152},{ -130, -102},{ -110, -102}}, color = {0,0,0}, smooth = Smooth.None));
      connect(torqueStep.support,constantSpeed.support) annotation(Line(points = {{ -110, -142},{ -50, -142}}, color = {0,0,0}, smooth = Smooth.None));
      connect(constantSpeed.flange,inertia15.flange_a) annotation(Line(points = {{ -40, -130},{ -30, -130}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia8.flange_b,relativeStates.flange_b) annotation(Line(points = {{ -28, -30},{ -30, -30},{ -30, -70},{ -40, -70}}, color = {0,0,0}, smooth = Smooth.None));
      connect(relativeStates.flange_a,inertia7.flange_b) annotation(Line(points = {{ -60, -70},{ -90, -70},{ -90, -30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia11.flange_b,angleSensor.flange) annotation(Line(points = {{100, -110},{118, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia11.flange_b,speedSensor.flange) annotation(Line(points = {{100, -110},{104, -110},{104, -86},{118, -86}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia11.flange_b,accSensor.flange) annotation(Line(points = {{100, -110},{104, -110},{104, -136},{118, -136}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia9.flange_b,relAngleSensor.flange_a) annotation(Line(points = {{100,0},{132,0},{132, -10},{152, -10}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia13.flange_b,relAngleSensor.flange_b) annotation(Line(points = {{160, -50},{186, -50},{186, -10},{172, -10}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia13.flange_b,relSpeedSensor.flange_a) annotation(Line(points = {{160, -50},{160, -78},{166, -78}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia12.flange_b,relSpeedSensor.flange_b) annotation(Line(points = {{100, -170},{198, -170},{198, -78},{186, -78}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia13.flange_b,relAccSensor.flange_a) annotation(Line(points = {{160, -50},{160, -120}}, color = {0,0,0}, smooth = Smooth.None));
      connect(relAccSensor.flange_b,inertia12.flange_b) annotation(Line(points = {{180, -120},{188, -120},{188, -170},{100, -170}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia15.flange_b,torqueSensor.flange_b) annotation(Line(points = {{ -10, -130},{8, -130},{8, -162},{ -6, -162},{ -6, -160}}, color = {0,0,0}, smooth = Smooth.None));
      connect(torqueSensor.flange_a,powerSensor.flange_b) annotation(Line(points = {{ -26, -160},{ -38, -160}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia16.flange_b,powerSensor.flange_a) annotation(Line(points = {{ -68, -160},{ -58, -160}}, color = {0,0,0}, smooth = Smooth.None));
    end AllComponents;
    model TestBearingConversion "Test, whether conversion of bearing to support is correctly performed"
      Modelica.Mechanics.Rotational.Components.IdealGear idealGear(useSupport = false) annotation(Placement(transformation(extent = {{ -60,140},{ -40,160}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia annotation(Placement(transformation(extent = {{ -90,140},{ -70,160}}, rotation = 0)));
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -300},{300,200}}, initialScale = 0.1), graphics), experiment(StopTime = 0.5), experimentSetupOutput);
      Modelica.Mechanics.Rotational.Components.IdealGear idealGear1(useSupport = true) annotation(Placement(transformation(extent = {{ -28,140},{ -8,160}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.BearingFriction bearingFriction(useSupport = true) annotation(Placement(transformation(extent = {{0,140},{20,160}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia1 annotation(Placement(transformation(extent = {{ -90,90},{ -70,110}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.BearingFriction bearingFriction1(useSupport = false) annotation(Placement(transformation(extent = {{ -60,90},{ -40,110}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed annotation(Placement(transformation(extent = {{ -28,124},{ -8,144}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Brake brake(useSupport = true) annotation(Placement(transformation(extent = {{ -60,30},{ -40,50}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{ -90,60},{ -70,80}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia2 annotation(Placement(transformation(extent = {{ -90,30},{ -70,50}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Brake brake1(useSupport = false) annotation(Placement(transformation(extent = {{16,30},{36,50}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia3 annotation(Placement(transformation(extent = {{ -20,30},{0,50}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed1 annotation(Placement(transformation(extent = {{ -60,10},{ -40,30}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.LossyGear lossyGear(useSupport = false) annotation(Placement(transformation(extent = {{4,90},{24,110}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia4 annotation(Placement(transformation(extent = {{ -24,90},{ -4,110}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia5 annotation(Placement(transformation(extent = {{34,90},{54,110}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.LossyGear lossyGear1(useSupport = true) annotation(Placement(transformation(extent = {{102,90},{122,110}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia6 annotation(Placement(transformation(extent = {{74,90},{94,110}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia7 annotation(Placement(transformation(extent = {{132,90},{152,110}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed2 annotation(Placement(transformation(extent = {{102,72},{122,92}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Gearbox gear2_1(useSupport = false) annotation(Placement(transformation(extent = {{76,30},{96,50}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia8 annotation(Placement(transformation(extent = {{50,30},{70,50}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia9 annotation(Placement(transformation(extent = {{104,30},{124,50}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Position position(useSupport = false) annotation(Placement(transformation(extent = {{ -60, -28},{ -40, -8}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine1 annotation(Placement(transformation(extent = {{ -96, -28},{ -76, -8}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia12 annotation(Placement(transformation(extent = {{ -30, -28},{ -10, -8}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Position position1(useSupport = true) annotation(Placement(transformation(extent = {{ -60, -58},{ -40, -38}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia13 annotation(Placement(transformation(extent = {{ -30, -58},{ -10, -38}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed4 annotation(Placement(transformation(extent = {{ -60, -76},{ -40, -56}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Gearbox gear2_2(useSupport = true) annotation(Placement(transformation(extent = {{66,142},{86,162}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia10 annotation(Placement(transformation(extent = {{40,142},{60,162}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia11 annotation(Placement(transformation(extent = {{94,142},{114,162}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed3 annotation(Placement(transformation(extent = {{66,124},{86,144}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Speed position2(useSupport = false) annotation(Placement(transformation(extent = {{40, -30},{60, -10}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine2 annotation(Placement(transformation(extent = {{4, -30},{24, -10}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia14 annotation(Placement(transformation(extent = {{70, -30},{90, -10}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Speed position3(useSupport = true) annotation(Placement(transformation(extent = {{40, -60},{60, -40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia15 annotation(Placement(transformation(extent = {{70, -60},{90, -40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed5 annotation(Placement(transformation(extent = {{40, -78},{60, -58}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Accelerate position4(useSupport = false) annotation(Placement(transformation(extent = {{146, -30},{166, -10}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine3 annotation(Placement(transformation(extent = {{110, -30},{130, -10}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia16 annotation(Placement(transformation(extent = {{176, -30},{196, -10}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Accelerate position5(useSupport = true) annotation(Placement(transformation(extent = {{146, -60},{166, -40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia17 annotation(Placement(transformation(extent = {{176, -60},{196, -40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed6 annotation(Placement(transformation(extent = {{146, -78},{166, -58}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Move position6(useSupport = false) annotation(Placement(transformation(extent = {{ -60, -120},{ -40, -100}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine4[3] annotation(Placement(transformation(extent = {{ -96, -120},{ -76, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia18 annotation(Placement(transformation(extent = {{ -30, -120},{ -10, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Move position7(useSupport = true) annotation(Placement(transformation(extent = {{ -60, -150},{ -40, -130}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia19 annotation(Placement(transformation(extent = {{ -30, -150},{ -10, -130}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed8 annotation(Placement(transformation(extent = {{ -60, -168},{ -40, -148}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine5 annotation(Placement(transformation(extent = {{24, -120},{44, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Torque torque(useSupport = false) annotation(Placement(transformation(extent = {{60, -120},{80, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.LinearSpeedDependentTorque linearSpeedDependentTorque(tau_nominal = 1, w_nominal = 1, useSupport = false) annotation(Placement(transformation(extent = {{60, -154},{80, -134}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque quadraticSpeedDependentTorque(tau_nominal = 1, w_nominal = 1, useSupport = false) annotation(Placement(transformation(extent = {{58, -190},{78, -170}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.ConstantTorque constantTorque(tau_constant = 1, useSupport = false) annotation(Placement(transformation(extent = {{60, -224},{80, -204}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStep(useSupport = false) annotation(Placement(transformation(extent = {{60, -260},{80, -240}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia20 annotation(Placement(transformation(extent = {{98, -120},{118, -100}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine6 annotation(Placement(transformation(extent = {{140, -120},{160, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Torque torque1(useSupport = true) annotation(Placement(transformation(extent = {{176, -120},{196, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.LinearSpeedDependentTorque linearSpeedDependentTorque1(tau_nominal = 1, w_nominal = 1, useSupport = true) annotation(Placement(transformation(extent = {{176, -154},{196, -134}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.QuadraticSpeedDependentTorque quadraticSpeedDependentTorque1(tau_nominal = 1, w_nominal = 1, useSupport = true) annotation(Placement(transformation(extent = {{174, -190},{194, -170}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.ConstantTorque constantTorque1(tau_constant = 1, useSupport = true) annotation(Placement(transformation(extent = {{176, -224},{196, -204}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.TorqueStep torqueStep1(useSupport = true) annotation(Placement(transformation(extent = {{176, -260},{196, -240}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia21 annotation(Placement(transformation(extent = {{214, -120},{234, -100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed7 annotation(Placement(transformation(extent = {{220, -280},{240, -260}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.IdealGearR2T idealGearR2T(useSupportR = false, useSupportT = false) annotation(Placement(transformation(extent = {{220,140},{240,160}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia22 annotation(Placement(transformation(extent = {{184,140},{204,160}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass annotation(Placement(transformation(extent = {{260,140},{280,160}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.IdealGearR2T idealGearR2T1(useSupportR = true, useSupportT = true) annotation(Placement(transformation(extent = {{216,100},{236,120}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia23 annotation(Placement(transformation(extent = {{180,100},{200,120}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Mass slidingMass1 annotation(Placement(transformation(extent = {{256,100},{276,120}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Fixed fixed9 annotation(Placement(transformation(extent = {{210,82},{230,102}}, rotation = 0)));
      Modelica.Mechanics.Translational.Components.Fixed fixed10 annotation(Placement(transformation(extent = {{232,82},{252,102}}, rotation = 0)));

    equation 
      connect(inertia.flange_b,idealGear.flange_a) annotation(Line(points = {{ -70,150},{ -60,150}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealGear.flange_b,idealGear1.flange_a) annotation(Line(points = {{ -40,150},{ -28,150}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealGear1.flange_b,bearingFriction.flange_a) annotation(Line(points = {{ -8,150},{0,150}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia1.flange_b,bearingFriction1.flange_a) annotation(Line(points = {{ -70,100},{ -60,100}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealGear1.support,fixed.flange) annotation(Line(points = {{ -18,140},{ -18,134}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed.flange,bearingFriction.support) annotation(Line(points = {{ -18,134},{10,134},{10,140}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine.y,brake.f_normalized) annotation(Line(points = {{ -69,70},{ -50,70},{ -50,51}}, color = {0,0,127}, smooth = Smooth.None));
      connect(inertia2.flange_b,brake.flange_a) annotation(Line(points = {{ -70,40},{ -60,40}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia3.flange_b,brake1.flange_a) annotation(Line(points = {{0,40},{16,40}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine.y,brake1.f_normalized) annotation(Line(points = {{ -69,70},{26,70},{26,51}}, color = {0,0,127}, smooth = Smooth.None));
      connect(brake.support,fixed1.flange) annotation(Line(points = {{ -50,30},{ -50,20}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia4.flange_b,lossyGear.flange_a) annotation(Line(points = {{ -4,100},{4,100}}, color = {0,0,0}, smooth = Smooth.None));
      connect(lossyGear.flange_b,inertia5.flange_a) annotation(Line(points = {{24,100},{34,100}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia6.flange_b,lossyGear1.flange_a) annotation(Line(points = {{94,100},{102,100}}, color = {0,0,0}, smooth = Smooth.None));
      connect(lossyGear1.flange_b,inertia7.flange_a) annotation(Line(points = {{122,100},{132,100}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed2.flange,lossyGear1.support) annotation(Line(points = {{112,82},{112,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia8.flange_b,gear2_1.flange_a) annotation(Line(points = {{70,40},{76,40}}, color = {0,0,0}, smooth = Smooth.None));
      connect(gear2_1.flange_b,inertia9.flange_a) annotation(Line(points = {{96,40},{104,40}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine1.y,position.phi_ref) annotation(Line(points = {{ -75, -18},{ -62, -18}}, color = {0,0,127}, smooth = Smooth.None));
      connect(position.flange,inertia12.flange_a) annotation(Line(points = {{ -40, -18},{ -30, -18}}, color = {0,0,0}, smooth = Smooth.None));
      connect(position1.flange,inertia13.flange_a) annotation(Line(points = {{ -40, -48},{ -30, -48}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine1.y,position1.phi_ref) annotation(Line(points = {{ -75, -18},{ -70, -18},{ -70, -48},{ -62, -48}}, color = {0,0,127}, smooth = Smooth.None));
      connect(position1.support,fixed4.flange) annotation(Line(points = {{ -50, -58},{ -50, -66}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia10.flange_b,gear2_2.flange_a) annotation(Line(points = {{60,152},{66,152}}, color = {0,0,0}, smooth = Smooth.None));
      connect(gear2_2.flange_b,inertia11.flange_a) annotation(Line(points = {{86,152},{94,152}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed3.flange,gear2_2.support) annotation(Line(points = {{76,134},{76,142}}, color = {0,0,0}, smooth = Smooth.None));
      connect(position2.flange,inertia14.flange_a) annotation(Line(points = {{60, -20},{70, -20}}, color = {0,0,0}, smooth = Smooth.None));
      connect(position3.flange,inertia15.flange_a) annotation(Line(points = {{60, -50},{70, -50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(position3.support,fixed5.flange) annotation(Line(points = {{50, -60},{50, -68}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine2.y,position2.w_ref) annotation(Line(points = {{25, -20},{38, -20}}, color = {0,0,127}, smooth = Smooth.None));
      connect(sine2.y,position3.w_ref) annotation(Line(points = {{25, -20},{30, -20},{30, -50},{38, -50}}, color = {0,0,127}, smooth = Smooth.None));
      connect(position4.flange,inertia16.flange_a) annotation(Line(points = {{166, -20},{176, -20}}, color = {0,0,0}, smooth = Smooth.None));
      connect(position5.flange,inertia17.flange_a) annotation(Line(points = {{166, -50},{176, -50}}, color = {0,0,0}, smooth = Smooth.None));
      connect(position5.support,fixed6.flange) annotation(Line(points = {{156, -60},{156, -68}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine3.y,position4.a_ref) annotation(Line(points = {{131, -20},{144, -20}}, color = {0,0,127}, smooth = Smooth.None));
      connect(sine3.y,position5.a_ref) annotation(Line(points = {{131, -20},{136, -20},{136, -50},{144, -50}}, color = {0,0,127}, smooth = Smooth.None));
      connect(position6.flange,inertia18.flange_a) annotation(Line(points = {{ -40, -110},{ -30, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(position7.flange,inertia19.flange_a) annotation(Line(points = {{ -40, -140},{ -30, -140}}, color = {0,0,0}, smooth = Smooth.None));
      connect(position7.support,fixed8.flange) annotation(Line(points = {{ -50, -150},{ -50, -158}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine4.y,position6.u) annotation(Line(points = {{ -75, -110},{ -62, -110}}, color = {0,0,127}, smooth = Smooth.None));
      connect(sine4.y,position7.u) annotation(Line(points = {{ -75, -110},{ -72, -110},{ -72, -140},{ -62, -140}}, color = {0,0,127}, smooth = Smooth.None));
      connect(sine5.y,torque.tau) annotation(Line(points = {{45, -110},{50.5, -110},{50.5, -110},{58, -110}}, color = {0,0,127}, smooth = Smooth.None));
      connect(torque.flange,inertia20.flange_a) annotation(Line(points = {{80, -110},{98, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(linearSpeedDependentTorque.flange,inertia20.flange_a) annotation(Line(points = {{80, -144},{92, -144},{92, -110},{98, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(quadraticSpeedDependentTorque.flange,inertia20.flange_a) annotation(Line(points = {{78, -180},{92, -180},{92, -110},{98, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(constantTorque.flange,inertia20.flange_a) annotation(Line(points = {{80, -214},{92, -214},{92, -110},{98, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(torqueStep.flange,inertia20.flange_a) annotation(Line(points = {{80, -250},{92, -250},{92, -110},{98, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine6.y,torque1.tau) annotation(Line(points = {{161, -110},{174, -110}}, color = {0,0,127}, smooth = Smooth.None));
      connect(torque1.flange,inertia21.flange_a) annotation(Line(points = {{196, -110},{214, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(linearSpeedDependentTorque1.flange,inertia21.flange_a) annotation(Line(points = {{196, -144},{208, -144},{208, -110},{214, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(quadraticSpeedDependentTorque1.flange,inertia21.flange_a) annotation(Line(points = {{194, -180},{208, -180},{208, -110},{214, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(constantTorque1.flange,inertia21.flange_a) annotation(Line(points = {{196, -214},{208, -214},{208, -110},{214, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(torqueStep1.flange,inertia21.flange_a) annotation(Line(points = {{196, -250},{208, -250},{208, -110},{214, -110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(torqueStep1.support,fixed7.flange) annotation(Line(points = {{186, -260},{186, -270},{230, -270}}, color = {0,0,0}, smooth = Smooth.None));
      connect(constantTorque1.support,fixed7.flange) annotation(Line(points = {{186, -224},{208, -224},{208, -228},{230, -228},{230, -270}}, color = {0,0,0}, smooth = Smooth.None));
      connect(quadraticSpeedDependentTorque1.support,fixed7.flange) annotation(Line(points = {{184, -190},{230, -190},{230, -270}}, color = {0,0,0}, smooth = Smooth.None));
      connect(linearSpeedDependentTorque1.support,fixed7.flange) annotation(Line(points = {{186, -154},{230, -154},{230, -270}}, color = {0,0,0}, smooth = Smooth.None));
      connect(torque1.support,fixed7.flange) annotation(Line(points = {{186, -120},{186, -126},{230, -126},{230, -270}}, color = {0,0,0}, smooth = Smooth.None));
      connect(inertia22.flange_b,idealGearR2T.flangeR) annotation(Line(points = {{204,150},{220,150}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealGearR2T.flangeT,slidingMass.flange_a) annotation(Line(points = {{240,150},{260,150}}, color = {0,127,0}, smooth = Smooth.None));
      connect(inertia23.flange_b,idealGearR2T1.flangeR) annotation(Line(points = {{200,110},{216,110}}, color = {0,0,0}, smooth = Smooth.None));
      connect(idealGearR2T1.flangeT,slidingMass1.flange_a) annotation(Line(points = {{236,110},{256,110}}, color = {0,127,0}, smooth = Smooth.None));
      connect(idealGearR2T1.supportR,fixed9.flange) annotation(Line(points = {{216,100},{216,96},{220,96},{220,92}}, color = {0,0,0}, smooth = Smooth.None));
      connect(fixed10.flange,idealGearR2T1.supportT) annotation(Line(points = {{242,92},{242,100},{236,100}}, color = {0,127,0}, smooth = Smooth.None));
    end TestBearingConversion;
    model TestFriction "Test friction elements"
      Modelica.Mechanics.Rotational.Components.Inertia inertia annotation(Placement(transformation(extent = {{ -8,80},{12,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.BearingFriction bearingFriction(useSupport = false) annotation(Placement(transformation(extent = {{22,80},{42,100}}, rotation = 0)));
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));
      Modelica.Mechanics.Rotational.Sources.Torque torque(useSupport = false) annotation(Placement(transformation(extent = {{ -40,80},{ -20,100}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine(amplitude = 10) annotation(Placement(transformation(extent = {{ -80,80},{ -60,100}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia1 annotation(Placement(transformation(extent = {{ -8,20},{12,40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Torque torque1(useSupport = false) annotation(Placement(transformation(extent = {{ -40,20},{ -20,40}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine1(amplitude = 10) annotation(Placement(transformation(extent = {{ -80,20},{ -60,40}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Brake brake(useSupport = false) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
      Modelica.Blocks.Sources.Step step(height = 100, startTime = 0.5) annotation(Placement(transformation(extent = {{ -18,50},{2,70}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia2 annotation(Placement(transformation(extent = {{ -8, -40},{12, -20}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Torque torque2(useSupport = false) annotation(Placement(transformation(extent = {{ -40, -40},{ -20, -20}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine2(amplitude = 10) annotation(Placement(transformation(extent = {{ -80, -40},{ -60, -20}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Clutch clutch annotation(Placement(transformation(extent = {{24, -40},{44, -20}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia3 annotation(Placement(transformation(extent = {{58, -40},{78, -20}}, rotation = 0)));
      Modelica.Blocks.Sources.Step step1(height = 100, startTime = 0.5) annotation(Placement(transformation(extent = {{ -12, -10},{8,10}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia4 annotation(Placement(transformation(extent = {{ -6, -100},{14, -80}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Sources.Torque torque3(useSupport = false) annotation(Placement(transformation(extent = {{ -38, -100},{ -18, -80}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine3(amplitude = 10) annotation(Placement(transformation(extent = {{ -78, -100},{ -58, -80}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.Inertia inertia5 annotation(Placement(transformation(extent = {{60, -100},{80, -80}}, rotation = 0)));
      Modelica.Blocks.Sources.Step step2(height = 100, startTime = 0.5) annotation(Placement(transformation(extent = {{ -10, -70},{10, -50}}, rotation = 0)));
      Modelica.Mechanics.Rotational.Components.OneWayClutch oneWayClutch annotation(Placement(transformation(extent = {{46, -100},{26, -80}}, rotation = 0)));

    equation 
      connect(inertia.flange_b,bearingFriction.flange_a) annotation(Line(points = {{12,90},{22,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(torque.flange,inertia.flange_a) annotation(Line(points = {{ -20,90},{ -8,90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine.y,torque.tau) annotation(Line(points = {{ -59,90},{ -42,90}}, color = {0,0,127}, smooth = Smooth.None));
      connect(torque1.flange,inertia1.flange_a) annotation(Line(points = {{ -20,30},{ -8,30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine1.y,torque1.tau) annotation(Line(points = {{ -59,30},{ -42,30}}, color = {0,0,127}, smooth = Smooth.None));
      connect(inertia1.flange_b,brake.flange_a) annotation(Line(points = {{12,30},{20,30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(step.y,brake.f_normalized) annotation(Line(points = {{3,60},{30,60},{30,41}}, color = {0,0,127}, smooth = Smooth.None));
      connect(torque2.flange,inertia2.flange_a) annotation(Line(points = {{ -20, -30},{ -8, -30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine2.y,torque2.tau) annotation(Line(points = {{ -59, -30},{ -42, -30}}, color = {0,0,127}, smooth = Smooth.None));
      connect(inertia2.flange_b,clutch.flange_a) annotation(Line(points = {{12, -30},{24, -30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(clutch.flange_b,inertia3.flange_a) annotation(Line(points = {{44, -30},{58, -30}}, color = {0,0,0}, smooth = Smooth.None));
      connect(step1.y,clutch.f_normalized) annotation(Line(points = {{9,0},{34,0},{34, -19}}, color = {0,0,127}, smooth = Smooth.None));
      connect(torque3.flange,inertia4.flange_a) annotation(Line(points = {{ -18, -90},{ -6, -90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(sine3.y,torque3.tau) annotation(Line(points = {{ -57, -90},{ -40, -90}}, color = {0,0,127}, smooth = Smooth.None));
      connect(step2.y,oneWayClutch.f_normalized) annotation(Line(points = {{11, -60},{36, -60},{36, -79}}, color = {0,0,127}, smooth = Smooth.None));
      connect(oneWayClutch.flange_b,inertia4.flange_b) annotation(Line(points = {{26, -90},{14, -90}}, color = {0,0,0}, smooth = Smooth.None));
      connect(oneWayClutch.flange_a,inertia5.flange_a) annotation(Line(points = {{46, -90},{60, -90}}, color = {0,0,0}, smooth = Smooth.None));
    end TestFriction;
  end Rotational;
  package MultiBody "Test models for Modelica.Mechanics.MultiBody"
    encapsulated model SphericalDoublePendulum "Double pendulum with two spherical joints and two bodies"
      import ObsoleteModelica3;
      import Modelica;
      import Modelica.Mechanics.MultiBody;
      extends Modelica.Icons.Example;
      annotation(experiment(StopTime = 3), Window(x = 0.29, y = 0, width = 0.71, height = 0.85), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {2,2}), graphics), Documentation(info = "<html>
<p>
This example demonstrates that by using joint and body
elements animation is automatically available. Also the revolute
joints are animated. Note, that animation of every component
can be switched of by setting the first parameter <b>animation</b>
to <b>false</b> or by setting <b>enableAnimation</b> in the <b>world</b>
object to <b>false</b> to switch off animation of all components.
</p>

<p align=\"center\">
<IMG SRC=\"../Images/Examples/Elementary/DoublePendulum.png\"
ALT=\"model Examples.Elementary.DoublePendulum\">
</p>

</HTML>"), uses);
      inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -88,0},{ -68,20}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Parts.BodyBox boxBody1(width = 0.06, r = {0.4,0.0, -0.3}) annotation(Placement(transformation(extent = {{ -10,0},{10,20}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Parts.BodyBox boxBody2(width = 0.06, r = {0.3, -0.4,0}) annotation(Placement(transformation(extent = {{74,0},{94,20}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Joints.Spherical Spherical1(enforceStates = true, useQuaternions = false, angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false, w_rel_a_start = {0.0523598775598299,0.0349065850398866,0.0174532925199433}) annotation(Placement(transformation(extent = {{ -52,0},{ -32,20}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Joints.Spherical Spherical2(enforceStates = true, useQuaternions = false, angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false) annotation(Placement(transformation(extent = {{32,0},{52,20}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Parts.BodyBox boxBody3(width = 0.06, r = {0.4,0.0, -0.3}) annotation(Placement(transformation(extent = {{ -10, -40},{10, -20}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Parts.BodyBox boxBody4(width = 0.06, r = {0.3, -0.4,0}) annotation(Placement(transformation(extent = {{76, -40},{96, -20}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Joints.Spherical Spherical3(enforceStates = true, angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false, w_rel_a_start = {0.0523598775598299,0.0349065850398866,0.0174532925199433}) annotation(Placement(transformation(extent = {{ -52, -40},{ -32, -20}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Joints.Spherical Spherical4(enforceStates = true, angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false) annotation(Placement(transformation(extent = {{32, -40},{52, -20}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Parts.BodyBox boxBody5(width = 0.06, r = {0.4,0.0, -0.3}, useQuaternions = true) annotation(Placement(transformation(extent = {{ -10, -80},{10, -60}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Parts.BodyBox boxBody6(width = 0.06, r = {0.3, -0.4,0}, useQuaternions = true) annotation(Placement(transformation(extent = {{74, -80},{94, -60}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Joints.Spherical Spherical5(angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false, w_rel_a_start = {0.0523598775598299,0.0349065850398866,0.0174532925199433}) annotation(Placement(transformation(extent = {{ -52, -80},{ -32, -60}}, rotation = 0)));
      Modelica.Mechanics.MultiBody.Joints.Spherical Spherical6(angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false) annotation(Placement(transformation(extent = {{32, -80},{52, -60}}, rotation = 0)));

    equation 
      connect(boxBody1.frame_b,Spherical2.frame_a) annotation(Line(points = {{10,10},{32,10}}, color = {0,0,0}, thickness = 0.5));
      connect(Spherical2.frame_b,boxBody2.frame_a) annotation(Line(points = {{52,10},{74,10}}, color = {0,0,0}, thickness = 0.5));
      connect(world.frame_b,Spherical1.frame_a) annotation(Line(points = {{ -68,10},{ -52,10}}, color = {0,0,0}, thickness = 0.5));
      connect(Spherical1.frame_b,boxBody1.frame_a) annotation(Line(points = {{ -32,10},{ -10,10}}, color = {0,0,0}, thickness = 0.5));
      connect(boxBody3.frame_b,Spherical4.frame_a) annotation(Line(points = {{10, -30},{32, -30}}, color = {0,0,0}, thickness = 0.5));
      connect(Spherical4.frame_b,boxBody4.frame_a) annotation(Line(points = {{52, -30},{76, -30}}, color = {0,0,0}, thickness = 0.5));
      connect(Spherical3.frame_b,boxBody3.frame_a) annotation(Line(points = {{ -32, -30},{ -10, -30}}, color = {0,0,0}, thickness = 0.5));
      connect(world.frame_b,Spherical3.frame_a) annotation(Line(points = {{ -68,10},{ -60,10},{ -60, -30},{ -52, -30}}, color = {0,0,0}, thickness = 0.5));
      connect(boxBody5.frame_b,Spherical6.frame_a) annotation(Line(points = {{10, -70},{32, -70}}, color = {0,0,0}, thickness = 0.5));
      connect(Spherical6.frame_b,boxBody6.frame_a) annotation(Line(points = {{52, -70},{74, -70}}, color = {0,0,0}, thickness = 0.5));
      connect(Spherical5.frame_b,boxBody5.frame_a) annotation(Line(points = {{ -32, -70},{ -10, -70}}, color = {0,0,0}, thickness = 0.5));
      connect(Spherical5.frame_a,world.frame_b) annotation(Line(points = {{ -52, -70},{ -60, -70},{ -60,10},{ -68,10}}, color = {0,0,0}, thickness = 0.5));
    end SphericalDoublePendulum;
    package FourbarVariants "Test joints and assembly joints with four bar loop"
      model SphericalAndUniversal "One kinematic loop with four bars (with Spherical and Universal joint)"
        import SI = Modelica.SIunits;
        extends Modelica.Icons.Example;
        output SI.Angle j1_phi "angle of revolute joint j1";
        output SI.Position j2_s "distance of prismatic joint j2";
        output SI.AngularVelocity j1_w "axis speed of revolute joint j1";
        output SI.Velocity j2_v "axis velocity of prismatic joint j2";
        annotation(experiment(StopTime = 5), Documentation(info = "<html>
<p>
This is a second version of the \"four-bar\" mechanism, see figure:
</p>
<p align=\"center\">
<IMG SRC=\"../Images/MultiBody/Examples/Loops/Fourbar2.png\" ALT=\"model Examples.Loops.Fourbar2\">
</p>
<p>
In this case
the three revolute joints on the left top-side and the two revolute
joints on the right top side have been replaced by the joint <b>UniversalSpherical</b>
that is a rod connecting a spherical and a universal joint. This joint is defined
by <b>1 constraint</b> stating that the distance between the two spherical joints is
constant. Using this joint in a kinematic loop reduces the sizes of
non-linear algebraic equations. For this loop, only one non-linear
algebraic system of equations of order 1 remains.
</p>
<p>
At the UniversalSpherical joint an additional frame_ia fixed to the rod
is present where components can be attached to the connecting rod. In this
example just a coordinate system is attached to visualize frame_ia (coordinate
system on the right in blue color).
</p>
<p>
Another feature is that the length of the connecting rod can be
automatically calculated during <b>initialization</b>. In order to do this,
another initialization condition has to be given. In this example, the
initial value of the distance of the prismatic joint j2 has been fixed
(via the \"Initialization\" menu) and the rod length of joint
\"UniversalSpherical\" is computed during initialization since parameter
<b>computeLength</b> = <b>true</b> is set in the joint parameter
menu. The main advantage is that during initialization no non-linear
system of equation is solved and therefore initialization always works.
To be precise, the following trivial non-linear equation is actually solved
for rodLength:
</p>
<pre>
   rodLength*rodLength = f(angle of revolute joint, distance of prismatic joint)
</pre>
</html>"), Diagram(graphics));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80, -80},{ -60, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute j1(n = {1,0,0}, stateSelect = StateSelect.always, a(fixed = false), phi(fixed = true), w(fixed = true, start = 5.23598775598299)) annotation(Placement(transformation(extent = {{ -54, -40},{ -34, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Prismatic j2(n = {1,0,0}, boxWidth = 0.05, s_offset =  -0.2) annotation(Placement(transformation(extent = {{12, -80},{32, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b1(r = {0,0.5,0.1}, diameter = 0.05) annotation(Placement(transformation(origin = { -30,0}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b2(r = {0,0.2,0}, diameter = 0.05) annotation(Placement(transformation(origin = {50, -50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation b3(r = {1.2,0,0}, animation = false) annotation(Placement(transformation(extent = {{ -32, -80},{ -12, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Spherical spherical(animation = false) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation FixedTranslation1(r = {1, -0.3, -0.1}, animation = false) annotation(Placement(transformation(extent = {{12,20},{32,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Universal Universal1(n_b = {0,1,0}, n_a = {0,0,1}) annotation(Placement(transformation(extent = {{44,20},{64,40}}, rotation = 0)));

      equation 
        j1_phi = j1.phi;
        j2_s = j2.s;
        j1_w = j1.w;
        j2_v = j2.v;
        connect(j2.frame_b,b2.frame_a) annotation(Line(points = {{32, -70},{50, -70},{50, -60}}, color = {0,0,0}, thickness = 0.5));
        connect(j1.frame_b,b1.frame_a) annotation(Line(points = {{ -34, -30},{ -30, -30},{ -30, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(j1.frame_a,world.frame_b) annotation(Line(points = {{ -54, -30},{ -60, -30},{ -60, -70}}, color = {0,0,0}, thickness = 0.5));
        connect(b3.frame_a,world.frame_b) annotation(Line(points = {{ -32, -70},{ -60, -70}}, color = {0,0,0}, thickness = 0.5));
        connect(b3.frame_b,j2.frame_a) annotation(Line(points = {{ -12, -70},{12, -70}}, color = {0,0,0}, thickness = 0.5));
        connect(b1.frame_b,spherical.frame_a) annotation(Line(points = {{ -30,10},{ -30,30},{ -20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(spherical.frame_b,FixedTranslation1.frame_a) annotation(Line(points = {{0,30},{12,30}}, color = {0,0,0}, thickness = 0.5));
        connect(FixedTranslation1.frame_b,Universal1.frame_a) annotation(Line(points = {{32,30},{44,30}}, color = {0,0,0}, thickness = 0.5));
        connect(b2.frame_b,Universal1.frame_b) annotation(Line(points = {{50, -40},{50, -2},{80, -2},{80,30},{64,30}}, color = {0,0,0}, thickness = 0.5));
      end SphericalAndUniversal;
      encapsulated model SphericalSpherical "One kinematic loop with four bars (with SphericalSpherical joint)"
        import ObsoleteModelica3;
        import Modelica;
        import Modelica.Mechanics.MultiBody;
        import SI = Modelica.SIunits;
        extends Modelica.Icons.Example;
        output SI.Angle j1_phi "angle of revolute joint j1";
        output SI.Position j2_s "distance of prismatic joint j2";
        output SI.AngularVelocity j1_w "axis speed of revolute joint j1";
        output SI.Velocity j2_v "axis velocity of prismatic joint j2";
        annotation(experiment(StopTime = 5), Documentation(info = "<html>
<p>
This is a third version of the \"four-bar\" mechanism. In this case
the three revolute joints on the left top-side and the two revolute
joints on the right top side have been replaced by the joint <b>SphericalSpherical</b>
that is a rod with two spherical joints on each side. This joint is defined
by <b>1 constraint</b> stating that the distance between the two spherical joints is
constant. Using this joint in a kinematic loop reduces the sizes of
non-linear algebraic equations. For this loop, only one non-linear
algebraic system of equations of order 1 remains.
</p>
<p>
The SphericalSpherical joint may be massless or may have a point mass in
the middle of the rod to approximate in an convenient way the rod
mass properties.
</p>
<p>
Another nice feature is that the <b>length</b> of the connecting rod can be
automatically calculated during <b>initialization</b>. In order to do this,
another initialization condition has to be given. In this example, the
initial value of the distance of the prismatic joint j2 has been fixed
(via the \"Initialization\" menu) and the length parameter of joint
\"SphericalSpherical\" is computed during initialization since parameter
<b>computeLength</b> = <b>true</b> is set in the joint parameter
menu (this sets \"fixed=false\" on parameter \"length\").
</p>
</html>
"), Diagram(graphics));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80, -80},{ -60, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute j1(n = {1,0,0}, stateSelect = StateSelect.always, a(fixed = false), phi(fixed = true), w(fixed = true, start = 5.23598775598299)) annotation(Placement(transformation(extent = {{ -54, -40},{ -34, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Prismatic j2(n = {1,0,0}, a(fixed = false), s(fixed = true), v(fixed = false), s_offset =  -0.2) annotation(Placement(transformation(extent = {{12, -80},{32, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b1(r = {0,0.5,0.1}, diameter = 0.05) annotation(Placement(transformation(origin = { -30,0}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b2(r = {0,0.2,0}, diameter = 0.05) annotation(Placement(transformation(origin = {50, -50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Joints.SphericalSpherical sphericalSpherical(computeRodLength = true, m = 1) annotation(Placement(transformation(extent = {{0,20},{ -20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation b3(r = {1.2,0,0}, animation = false) annotation(Placement(transformation(extent = {{ -32, -80},{ -12, -60}}, rotation = 0)));

      equation 
        connect(j2.frame_b,b2.frame_a) annotation(Line(points = {{32, -70},{50, -70},{50, -60}}));
        connect(j1.frame_b,b1.frame_a) annotation(Line(points = {{ -34, -30},{ -30, -30},{ -30, -10}}));
        connect(j1.frame_a,world.frame_b) annotation(Line(points = {{ -54, -30},{ -60, -30},{ -60, -70}}));
        connect(b1.frame_b,sphericalSpherical.frame_b) annotation(Line(points = {{ -30,10},{ -30,30},{ -20,30}}));
        connect(sphericalSpherical.frame_a,b2.frame_b) annotation(Line(points = {{0,30},{50,30},{50, -40}}));
        j1_phi = j1.phi;
        j2_s = j2.s;
        j1_w = j1.w;
        j2_v = j2.v;
        connect(b3.frame_a,world.frame_b) annotation(Line(points = {{ -32, -70},{ -60, -70}}));
        connect(b3.frame_b,j2.frame_a) annotation(Line(points = {{ -12, -70},{12, -70}}));
      end SphericalSpherical;
      encapsulated model UniversalSpherical "One kinematic loop with four bars (with UniversalSpherical joint)"
        import ObsoleteModelica3;
        import Modelica;
        import Modelica.Mechanics.MultiBody;
        import SI = Modelica.SIunits;
        extends Modelica.Icons.Example;
        output SI.Angle j1_phi "angle of revolute joint j1";
        output SI.Position j2_s "distance of prismatic joint j2";
        output SI.AngularVelocity j1_w "axis speed of revolute joint j1";
        output SI.Velocity j2_v "axis velocity of prismatic joint j2";
        annotation(experiment(StopTime = 5), Documentation(info = "<html>
<p>
This is a fourth version of the \"four-bar\" mechanism. In this case
the three revolute joints on the left top-side and the two revolute
joints on the right top side have been replaced by the joint <b>UniversalSpherical</b>
that is a rod with a spherical and a universal joint on two sides. This joint is defined
by <b>1 constraint</b> stating that the distance between the two spherical joints is
constant. Using this joint in a kinematic loop reduces the sizes of
non-linear algebraic equations. For this loop, only one non-linear
algebraic system of equations of order 1 remains.
</p>
<p>
The essential difference to joint SphericalSpherical is that the
orientation of the rod can be computed by removing one degree of freedom
of one of the spherical joints (i.e., replacing it by a universal joint).
Usually, the eigenrotation of the connecting rod is of no technical
interest and by this approximation it is constrained to move in a
somewhat arbitrary way. This allows to have an additional connector,
<b>frame_ia</b>, to be fixed on the rod, where other objects can be attached.
In this example, the coordinate system of frame_ia is visualized.
</p>
<p>
Another nice feature is that the <b>length</b> of the connecting rod can be
automatically calculated during <b>initialization</b>. In order to do this,
another initialization condition has to be given. In this example, the
initial value of the distance of the prismatic joint j2 has been fixed
(via the \"Initialization\" menu) and the length parameter of joint
\"UniversalSpherical\" is computed during initialization since parameter
<b>computeLength</b> = <b>true</b> is set in the joint parameter
menu (this sets \"fixed=false\" on parameter \"length\").
</p>
</html>"), Diagram(graphics));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80, -80},{ -60, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute j1(n = {1,0,0}, stateSelect = StateSelect.always, a(fixed = false), phi(fixed = true), w(fixed = true, start = 5.23598775598299)) annotation(Placement(transformation(extent = {{ -54, -40},{ -34, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Prismatic j2(n = {1,0,0}, boxWidth = 0.01, a(fixed = false), s(fixed = false), v(fixed = false), s_offset =  -0.2) annotation(Placement(transformation(extent = {{12, -80},{32, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b1(r = {0,0.5,0.1}, diameter = 0.05) annotation(Placement(transformation(origin = { -30,0}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b2(r = {0,0.2,0}, diameter = 0.05) annotation(Placement(transformation(origin = {50, -50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Joints.UniversalSpherical universalSpherical(rRod_ia = { -1,0.3,0.1}, n1_a = {0,1,0.1}) annotation(Placement(transformation(extent = {{0,20},{ -20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation b3(animation = false, r = {1,0,0}) annotation(Placement(transformation(extent = {{ -32, -80},{ -12, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame fixedFrame4 annotation(Placement(transformation(origin = { -10,70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

      equation 
        j1_phi = j1.phi;
        j2_s = j2.s;
        j1_w = j1.w;
        j2_v = j2.v;
        connect(j2.frame_b,b2.frame_a) annotation(Line(points = {{32, -70},{50, -70},{50, -60}}));
        connect(j1.frame_b,b1.frame_a) annotation(Line(points = {{ -34, -30},{ -30, -30},{ -30, -10}}));
        connect(j1.frame_a,world.frame_b) annotation(Line(points = {{ -54, -30},{ -60, -30},{ -60, -70}}));
        connect(b1.frame_b,universalSpherical.frame_b) annotation(Line(points = {{ -30,10},{ -30,30},{ -20,30}}));
        connect(universalSpherical.frame_a,b2.frame_b) annotation(Line(points = {{0,30},{50,30},{50, -40}}));
        connect(b3.frame_a,world.frame_b) annotation(Line(points = {{ -32, -70},{ -60, -70}}));
        connect(b3.frame_b,j2.frame_a) annotation(Line(points = {{ -12, -70},{12, -70}}));
        connect(fixedFrame4.frame_a,universalSpherical.frame_ia) annotation(Line(points = {{ -10,60},{ -10,50},{ -6,50},{ -6,40}}, color = {0,0,0}));
      end UniversalSpherical;
      encapsulated model UniversalSpherical_2 "One kinematic loop with four bars (with UniversalSpherical joint)"
        import ObsoleteModelica3;
        import Modelica;
        import Modelica.Mechanics.MultiBody;
        import SI = Modelica.SIunits;
        extends Modelica.Icons.Example;
        output SI.Angle j1_phi "angle of revolute joint j1";
        output SI.Position j2_s "distance of prismatic joint j2";
        output SI.AngularVelocity j1_w "axis speed of revolute joint j1";
        output SI.Velocity j2_v "axis velocity of prismatic joint j2";
        annotation(experiment(StopTime = 5), Documentation(info = "<html>
<p>
This is a fourth version of the \"four-bar\" mechanism. In this case
the three revolute joints on the left top-side and the two revolute
joints on the right top side have been replaced by the joint <b>UniversalSpherical</b>
that is a rod with a spherical and a universal joint on two sides. This joint is defined
by <b>1 constraint</b> stating that the distance between the two spherical joints is
constant. Using this joint in a kinematic loop reduces the sizes of
non-linear algebraic equations. For this loop, only one non-linear
algebraic system of equations of order 1 remains.
</p>
<p>
The essential difference to joint SphericalSpherical is that the
orientation of the rod can be computed by removing one degree of freedom
of one of the spherical joints (i.e., replacing it by a universal joint).
Usually, the eigenrotation of the connecting rod is of no technical
interest and by this approximation it is constrained to move in a
somewhat arbitrary way. This allows to have an additional connector,
<b>frame_ia</b>, to be fixed on the rod, where other objects can be attached.
In this example, the coordinate system of frame_ia is visualized.
</p>
<p>
Another nice feature is that the <b>length</b> of the connecting rod can be
automatically calculated during <b>initialization</b>. In order to do this,
another initialization condition has to be given. In this example, the
initial value of the distance of the prismatic joint j2 has been fixed
(via the \"Initialization\" menu) and the length parameter of joint
\"UniversalSpherical\" is computed during initialization since parameter
<b>computeLength</b> = <b>true</b> is set in the joint parameter
menu (this sets \"fixed=false\" on parameter \"length\").
</p>
</html>"), Diagram(graphics));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80, -80},{ -60, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute j1(n = {1,0,0}, stateSelect = StateSelect.always, a(fixed = false), phi(fixed = true), w(fixed = true, start = 5.23598775598299)) annotation(Placement(transformation(extent = {{ -54, -40},{ -34, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Prismatic j2(n = {1,0,0}, boxWidth = 0.01, a(fixed = false), s(fixed = false), v(fixed = false), s_offset =  -0.2) annotation(Placement(transformation(extent = {{12, -80},{32, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b1(r = {0,0.5,0.1}, diameter = 0.05) annotation(Placement(transformation(origin = { -30,0}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b2(r = {0,0.2,0}, diameter = 0.05) annotation(Placement(transformation(origin = {50, -50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Joints.UniversalSpherical universalSpherical(n1_a = {0,1,0.1}, rRod_ia = {{ -1,0.3,0.1} * { -1,0.3,0.1},0,0}, rRod_a(start = { -1,0.3,0.1})) annotation(Placement(transformation(extent = {{0,20},{ -20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation b3(animation = false, r = {1,0,0}) annotation(Placement(transformation(extent = {{ -32, -80},{ -12, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame fixedFrame4 annotation(Placement(transformation(origin = { -10,70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

      equation 
        j1_phi = j1.phi;
        j2_s = j2.s;
        j1_w = j1.w;
        j2_v = j2.v;
        connect(j2.frame_b,b2.frame_a) annotation(Line(points = {{32, -70},{50, -70},{50, -60}}));
        connect(j1.frame_b,b1.frame_a) annotation(Line(points = {{ -34, -30},{ -30, -30},{ -30, -10}}));
        connect(j1.frame_a,world.frame_b) annotation(Line(points = {{ -54, -30},{ -60, -30},{ -60, -70}}));
        connect(b1.frame_b,universalSpherical.frame_b) annotation(Line(points = {{ -30,10},{ -30,30},{ -20,30}}));
        connect(universalSpherical.frame_a,b2.frame_b) annotation(Line(points = {{0,30},{50,30},{50, -40}}));
        connect(b3.frame_a,world.frame_b) annotation(Line(points = {{ -32, -70},{ -60, -70}}));
        connect(b3.frame_b,j2.frame_a) annotation(Line(points = {{ -12, -70},{12, -70}}));
        connect(fixedFrame4.frame_a,universalSpherical.frame_ia) annotation(Line(points = {{ -10,60},{ -10,50},{ -6,50},{ -6,40}}, color = {0,0,0}));
      end UniversalSpherical_2;
      encapsulated model JointUSR "One kinematic loop with four bars (using JointUSR joint)"
        import ObsoleteModelica3;
        import Modelica;
        import Modelica.Mechanics.MultiBody;
        import SI = Modelica.SIunits;
        extends Modelica.Icons.Example;
        output SI.Angle j1_phi "angle of revolute joint j1";
        output SI.Position j2_s "distance of prismatic joint j2";
        output SI.AngularVelocity j1_w "axis speed of revolute joint j1";
        output SI.Velocity j2_v "axis velocity of prismatic joint j2";
        annotation(experiment(StopTime = 2), Documentation(info = "<html>
<p>
This is a fourth version of the \"four-bar\" mechanism. In this case
the three revolute joints on the left top-side and the two revolute
joints on the right top side have been replaced by the joint <b>UniversalSpherical</b>
that is a rod with a spherical and a universal joint on two sides. This joint is defined
by <b>1 constraint</b> stating that the distance between the two spherical joints is
constant. Using this joint in a kinematic loop reduces the sizes of
non-linear algebraic equations. For this loop, only one non-linear
algebraic system of equations of order 1 remains.
</p>
<p>
The essential difference to joint SphericalSpherical is that the
orientation of the rod can be computed by removing one degree of freedom
of one of the spherical joints (i.e., replacing it by a universal joint).
Usually, the eigenrotation of the connecting rod is of no technical
interest and by this approximation it is constrained to move in a
somewhat arbitrary way. This allows to have an additional connector,
<b>frame_ia</b>, to be fixed on the rod, where other objects can be attached.
In this example, the coordinate system of frame_ia is visualized.
</p>
<p>
Another nice feature is that the <b>length</b> of the connecting rod can be
automatically calculated during <b>initialization</b>. In order to do this,
another initialization condition has to be given. In this example, the
initial value of the distance of the prismatic joint j2 has been fixed
(via the \"Initialization\" menu) and the length parameter of joint
\"UniversalSpherical\" is computed during initialization since parameter
<b>computeLength</b> = <b>true</b> is set in the joint parameter
menu (this sets \"fixed=false\" on parameter \"length\").
</p>
</html>"), Diagram(coordinateSystem(preserveAspectRatio = true, extent = {{ -100, -100},{100,100}}), graphics), experimentSetupOutput);
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80, -80},{ -60, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Prismatic j2(n = {1,0,0}, stateSelect = StateSelect.always, a(fixed = false), s(fixed = true), v(fixed = true, start =  -0.4), s_offset =  -0.2) annotation(Placement(transformation(extent = {{12, -80},{32, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b2(r = {0,0.2,0}, diameter = 0.05) annotation(Placement(transformation(origin = {50, -50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation b3(animation = false, r = {1.2,0,0}) annotation(Placement(transformation(extent = {{ -32, -80},{ -12, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame fixedFrame annotation(Placement(transformation(origin = { -6,50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUSR jointUSR(n1_a = {0,1,0}, n_b = {1,0,0}, rRod2_ib = {0,0.5,0.1}, checkTotalPower = true, rRod1_ia = { -1,0.3, -0.1}) annotation(Placement(transformation(extent = {{0,0},{ -20,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body Body1(m = 1, I_11 = 0.1, I_22 = 0.1, I_33 = 0.1, r_CM = {0.01,0,0}) annotation(Placement(transformation(extent = {{ -74,40},{ -54,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body Body2(m = 1, I_11 = 0.1, I_22 = 0.1, I_33 = 0.1, r_CM = jointUSR.eRod1_ia / 2) annotation(Placement(transformation(extent = {{20,40},{40,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body Body3(m = 1, I_11 = 0.1, I_22 = 0.1, I_33 = 0.1) annotation(Placement(transformation(extent = {{ -38,68},{ -18,88}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Damper damper(d = 0.1) annotation(Placement(transformation(origin = { -64,12}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

      equation 
        j1_phi = jointUSR.revolute.phi;
        j2_s = j2.s;
        j1_w = der(jointUSR.revolute.phi);
        j2_v = j2.v;
        connect(j2.frame_b,b2.frame_a) annotation(Line(points = {{32, -70},{50, -70},{50, -60}}));
        connect(b3.frame_a,world.frame_b) annotation(Line(points = {{ -32, -70},{ -60, -70}}));
        connect(b3.frame_b,j2.frame_a) annotation(Line(points = {{ -12, -70},{12, -70}}));
        connect(world.frame_b,jointUSR.frame_b) annotation(Line(points = {{ -60, -70},{ -50, -70},{ -50,10},{ -20,10}}));
        connect(jointUSR.frame_a,b2.frame_b) annotation(Line(points = {{0,10},{50,10},{50, -40}}));
        connect(jointUSR.frame_ia,fixedFrame.frame_a) annotation(Line(points = {{ -2,20},{ -4,32},{ -6,32},{ -6,40}}));
        connect(jointUSR.frame_ia,Body2.frame_a) annotation(Line(points = {{ -2,20},{ -4,32},{10,32},{10,50},{20,50}}));
        connect(jointUSR.frame_ib,Body1.frame_a) annotation(Line(points = {{ -18,20},{ -18,30},{ -80,30},{ -80,50},{ -74,50}}));
        connect(Body3.frame_a,jointUSR.frame_im) annotation(Line(points = {{ -38,78},{ -48,78},{ -48,34},{ -10,34},{ -10,20}}, color = {0,0,0}));
        connect(damper.flange_b,jointUSR.axis) annotation(Line(points = {{ -64,22},{ -36,22},{ -36,18},{ -20,18}}, color = {0,0,0}));
        connect(jointUSR.bearing,damper.flange_a) annotation(Line(points = {{ -20,14},{ -54,14},{ -54,2},{ -64,2}}, color = {0,0,0}));
      end JointUSR;
      encapsulated model JointSSR "One kinematic loop with four bars (using JointSSR joint)"
        import ObsoleteModelica3;
        import Modelica;
        import Modelica.Mechanics.MultiBody;
        import SI = Modelica.SIunits;
        extends Modelica.Icons.Example;
        parameter Modelica.SIunits.Distance L = Modelica.Math.Vectors.length({ -1,0.3,0.1});
        output SI.Angle j1_phi "angle of revolute joint j1";
        output SI.Position j2_s "distance of prismatic joint j2";
        output SI.AngularVelocity j1_w "axis speed of revolute joint j1";
        output SI.Velocity j2_v "axis velocity of prismatic joint j2";
        annotation(experiment(StopTime = 1.1), Documentation(info = "<html>
<p>
This is a fourth version of the \"four-bar\" mechanism. In this case
the three revolute joints on the left top-side and the two revolute
joints on the right top side have been replaced by the joint <b>UniversalSpherical</b>
that is a rod with a spherical and a universal joint on two sides. This joint is defined
by <b>1 constraint</b> stating that the distance between the two spherical joints is
constant. Using this joint in a kinematic loop reduces the sizes of
non-linear algebraic equations. For this loop, only one non-linear
algebraic system of equations of order 1 remains.
</p>
<p>
The essential difference to joint SphericalSpherical is that the
orientation of the rod can be computed by removing one degree of freedom
of one of the spherical joints (i.e., replacing it by a universal joint).
Usually, the eigenrotation of the connecting rod is of no technical
interest and by this approximation it is constrained to move in a
somewhat arbitrary way. This allows to have an additional connector,
<b>frame_ia</b>, to be fixed on the rod, where other objects can be attached.
In this example, the coordinate system of frame_ia is visualized.
</p>
<p>
Another nice feature is that the <b>length</b> of the connecting rod can be
automatically calculated during <b>initialization</b>. In order to do this,
another initialization condition has to be given. In this example, the
initial value of the distance of the prismatic joint j2 has been fixed
(via the \"Initialization\" menu) and the length parameter of joint
\"UniversalSpherical\" is computed during initialization since parameter
<b>computeLength</b> = <b>true</b> is set in the joint parameter
menu (this sets \"fixed=false\" on parameter \"length\").
</p>
</html>"), Diagram(graphics));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80, -80},{ -60, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Prismatic j2(n = {1,0,0}, stateSelect = StateSelect.always, a(fixed = false), s(fixed = true), v(fixed = true, start =  -0.2), s_offset =  -0.2) annotation(Placement(transformation(extent = {{12, -80},{32, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder b2(r = {0,0.2,0}, diameter = 0.05) annotation(Placement(transformation(origin = {50, -50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation b3(animation = false, r = {1.2,0,0}) annotation(Placement(transformation(extent = {{ -32, -80},{ -12, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointSSR jointSSR(n_b = {1,0,0}, rRod2_ib = {0,0.5,0.1}, rod1Length = L, checkTotalPower = true, rod1Mass = 0.1) annotation(Placement(transformation(extent = {{ -2,0},{ -22,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame FixedFrame1 annotation(Placement(transformation(extent = {{ -40,60},{ -60,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body Body1(r_CM = jointSSR.rRod2_ib / 2, m = 0.1) annotation(Placement(transformation(extent = {{ -30,30},{ -50,50}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body Body2(m = 0.1) annotation(Placement(transformation(extent = {{20,30},{40,50}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Damper damper(d = 0.5) annotation(Placement(transformation(origin = { -62,16}, extent = {{ -10, -10},{10,10}}, rotation = 90)));

      equation 
        j1_phi = jointSSR.revolute.phi;
        j2_s = j2.s;
        j1_w = der(jointSSR.revolute.phi);
        j2_v = j2.v;
        connect(j2.frame_b,b2.frame_a) annotation(Line(points = {{32, -70},{50, -70},{50, -60}}));
        connect(b3.frame_a,world.frame_b) annotation(Line(points = {{ -32, -70},{ -60, -70}}));
        connect(b3.frame_b,j2.frame_a) annotation(Line(points = {{ -12, -70},{12, -70}}));
        connect(world.frame_b,jointSSR.frame_b) annotation(Line(points = {{ -60, -70},{ -50, -70},{ -50,10},{ -22,10}}));
        connect(jointSSR.frame_a,b2.frame_b) annotation(Line(points = {{ -2,10},{50,10},{50, -40}}));
        connect(FixedFrame1.frame_a,jointSSR.frame_ib) annotation(Line(points = {{ -40,70},{ -20,70},{ -20,20}}, color = {0,0,0}));
        connect(Body1.frame_a,jointSSR.frame_ib) annotation(Line(points = {{ -30,40},{ -20,40},{ -20,20}}, color = {0,0,0}));
        connect(Body2.frame_a,jointSSR.frame_im) annotation(Line(points = {{20,40},{ -12,40},{ -12,20}}, color = {0,0,0}));
        connect(jointSSR.axis,damper.flange_b) annotation(Line(points = {{ -22,18},{ -42,18},{ -42,26},{ -62,26}}, color = {0,0,0}));
        connect(jointSSR.bearing,damper.flange_a) annotation(Line(points = {{ -22,14},{ -52,14},{ -52,6},{ -62,6}}, color = {0,0,0}));
      end JointSSR;
      encapsulated model JointUSP "One kinematic loop with four bars (using JointUSP joint)"
        import ObsoleteModelica3;
        import Modelica;
        import Modelica.Mechanics.MultiBody;
        import SI = Modelica.SIunits;
        extends Modelica.Icons.Example;
        output SI.Angle revolute_phi "angle of revolute joint j1";
        output SI.Position prismatic_s "distance of prismatic joint j2";
        output SI.AngularVelocity revolute_w "axis speed of revolute joint j1";
        output SI.Velocity prismatic_v "axis velocity of prismatic joint j2";
        annotation(experiment(StopTime = 5), Documentation(info = ""), Diagram(graphics));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80, -80},{ -60, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute revolute(n = {1,0,0}, stateSelect = StateSelect.always, a(fixed = false), phi(fixed = true), w(fixed = true, start = 5.23598775598299)) annotation(Placement(transformation(extent = {{ -54, -40},{ -34, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder body1(r = {0,0.5,0.1}, diameter = 0.05) annotation(Placement(transformation(origin = { -30,0}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder body3(r = {0,0.2,0}, diameter = 0.05) annotation(Placement(transformation(origin = {50,70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation ground_rod(animation = false, r = {1.2,0,0}) annotation(Placement(transformation(extent = {{ -32, -80},{ -12, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUSP jointUSP(rRod2_ib = {0,0.2,0}, n1_a = {0,0, -1}, n_b = { -1,0,0}, rod1Diameter = 0.04, boxWidth = 0.05, rRod1_ia = {1, -0.3,0.1}) annotation(Placement(transformation(extent = {{0,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder body2(r = {1, -0.3,0.1}, diameter = 0.05) annotation(Placement(transformation(extent = {{8,60},{28,80}}, rotation = 0)));
        Modelica.Mechanics.Translational.Components.Damper damper(d = 50) annotation(Placement(transformation(origin = {52,30}, extent = {{10, -10},{ -10,10}}, rotation = 270)));

      equation 
        revolute_phi = revolute.phi;
        prismatic_s = jointUSP.prismatic.s;
        revolute_w = revolute.w;
        prismatic_v = der(jointUSP.prismatic.s);
        connect(revolute.frame_b,body1.frame_a) annotation(Line(points = {{ -34, -30},{ -30, -30},{ -30, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(revolute.frame_a,world.frame_b) annotation(Line(points = {{ -54, -30},{ -60, -30},{ -60, -70}}, color = {0,0,0}, thickness = 0.5));
        connect(ground_rod.frame_a,world.frame_b) annotation(Line(points = {{ -32, -70},{ -60, -70}}, color = {0,0,0}, thickness = 0.5));
        connect(body1.frame_b,jointUSP.frame_a) annotation(Line(points = {{ -30,10},{ -30,30},{0,30}}, color = {0,0,0}, thickness = 0.5));
        connect(ground_rod.frame_b,jointUSP.frame_b) annotation(Line(points = {{ -12, -70},{30, -70},{30,30},{20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(jointUSP.frame_ib,body3.frame_a) annotation(Line(points = {{18,40},{18,48},{50,48},{50,60}}, color = {0,0,0}, thickness = 0.5));
        connect(jointUSP.frame_ia,body2.frame_a) annotation(Line(points = {{2,40},{2,70},{8,70}}, color = {0,0,0}, thickness = 0.5));
        connect(jointUSP.bearing,damper.flange_a) annotation(Line(points = {{20,34},{38,34},{38,10},{52,10},{52,20}}, color = {0,191,0}));
        connect(jointUSP.axis,damper.flange_b) annotation(Line(points = {{20,38},{38,38},{38,44},{52,44},{52,40}}, color = {0,191,0}));
      end JointUSP;
    end FourbarVariants;
    package Frames "Test functions of package Frames"
      extends Modelica.Icons.Library;
      model AngularVelocity "Test angular velocity functions"
        import SI = Modelica.SIunits;
        import Modelica.Mechanics.MultiBody.Frames.*;
        extends Modelica.Icons.Example;
        Modelica.Mechanics.MultiBody.Frames.Orientation R = body.frame_a.R;
        SI.AngularVelocity wa[3] = angularVelocity2(R);
        SI.AngularVelocity w1[3] = resolve1(R, wa);
        SI.AngularVelocity w2[3] = angularVelocity1(R);
        SI.AngularVelocity w_err[3] = w2 - w1;
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation bar2(r = {0.8,0,0}, animation = false) annotation(Placement(transformation(extent = {{0,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Spring spring1(width = 0.1, coilWidth = 0.005, numberOfWindings = 5, c = 20, s_unstretched = 0) annotation(Placement(transformation(origin = { -24,6}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Parts.BodyShape body(m = 1, I_11 = 1, I_22 = 1, I_33 = 1, r = {0.4,0,0}, r_CM = {0.2,0,0}, width = 0.05, angles_start = {0.174532925199433,0.174532925199433,0.174532925199433}, a_0(fixed = false), angles_fixed = true, r_0(fixed = true, start = {0.2, -0.5,0.1}), v_0(fixed = true), w_0_fixed = true, z_0_fixed = false) annotation(Placement(transformation(extent = {{0, -40},{20, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Spring spring2(c = 20, s_unstretched = 0, width = 0.1, coilWidth = 0.005, numberOfWindings = 5) annotation(Placement(transformation(origin = {42,6}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Forces.WorldTorque FrameTorque1(resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_b) annotation(Placement(transformation(extent = {{58, -42},{38, -22}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = {10,0,0}) annotation(Placement(transformation(extent = {{94, -42},{74, -22}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(bar2.frame_a,world.frame_b) annotation(Line(points = {{0,30},{ -40,30}}, color = {0,0,0}, thickness = 0.5));
        connect(spring1.frame_b,body.frame_a) annotation(Line(points = {{ -24, -4},{ -24, -30},{0, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(spring2.frame_b,body.frame_b) annotation(Line(points = {{42, -4},{20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(bar2.frame_b,spring2.frame_a) annotation(Line(points = {{20,30},{42,30},{42,16}}, color = {0,0,0}, thickness = 0.5));
        connect(spring1.frame_a,world.frame_b) annotation(Line(points = {{ -24,16},{ -24,30},{ -40,30}}, color = {0,0,0}, thickness = 0.5));
        annotation(Diagram(graphics));
        connect(FrameTorque1.frame_b,body.frame_b) annotation(Line(points = {{38, -32},{30, -32},{30, -30},{20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(Constant1.y,FrameTorque1.torque) annotation(Line(points = {{73, -32},{60, -32}}, color = {0,0,255}));
      end AngularVelocity;
    end Frames;
    package Forces
      model DifferentiationOfForces
        extends Modelica.Icons.Example;
        inner Modelica.Mechanics.MultiBody.World world(gravityType = Modelica.Mechanics.MultiBody.Types.GravityTypes.UniformGravity) annotation(Placement(transformation(extent = {{ -80,0},{ -60,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute rev(n = {0,0,1}, a(fixed = false), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{ -40,0},{ -20,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox body(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,0},{20,20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.FrameForceAndTorque frameForceAndTorque annotation(Placement(transformation(extent = {{ -40, -40},{ -20, -20}}, rotation = 0)));
        Modelica.Blocks.Sources.Sine sine[6] annotation(Placement(transformation(extent = {{ -80, -40},{ -60, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.CutForce cutForce annotation(Placement(transformation(extent = {{0, -40},{20, -20}}, rotation = 0)));
        Modelica.Blocks.Continuous.Der der1[3] annotation(Placement(transformation(extent = {{20, -70},{40, -50}}, rotation = 0)));
        Modelica.Blocks.Continuous.Der der2[3] annotation(Placement(transformation(extent = {{54, -70},{74, -50}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,rev.frame_a) annotation(Line(points = {{ -60,10},{ -40,10}}, color = {95,95,95}, thickness = 0.5));
        connect(body.frame_a,rev.frame_b) annotation(Line(points = {{0,10},{ -20,10}}, color = {95,95,95}, thickness = 0.5));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        connect(sine.y,frameForceAndTorque.load) annotation(Line(points = {{ -59, -30},{ -42, -30}}, color = {0,0,127}));
        connect(frameForceAndTorque.frame_b,cutForce.frame_a) annotation(Line(points = {{ -20, -30},{0, -30}}, color = {95,95,95}, thickness = 0.5));
        connect(cutForce.frame_b,body.frame_b) annotation(Line(points = {{20, -30},{30, -30},{30,10},{20,10}}, color = {95,95,95}, thickness = 0.5));
        connect(cutForce.force,der1.u) annotation(Line(points = {{2, -41},{2, -60},{18, -60}}, color = {0,0,127}));
        connect(frameForceAndTorque.frame_resolve,body.frame_a) annotation(Line(points = {{ -30, -20},{ -30, -14},{ -12, -14},{ -12,10},{0,10}}, color = {95,95,95}, pattern = LinePattern.Dot));
        connect(der1.y,der2.u) annotation(Line(points = {{41, -60},{52, -60}}, color = {0,0,127}));
      end DifferentiationOfForces;
      model Force
        extends Modelica.Icons.Example;
        import Modelica.Mechanics.MultiBody.*;
        inner World world annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Joints.Revolute Revolute1(n = {0,1,0}) annotation(Placement(transformation(origin = { -20,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics));
        Parts.BodyCylinder body1(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = {0,500,0}) annotation(Placement(transformation(origin = {50,90}, extent = {{ -10,10},{10, -10}}, rotation = 270)));
        Parts.Fixed fixed1(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -90,0},{ -70,20}}, rotation = 0)));
        Parts.BodyCylinder body2(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -30},{20, -10}}, rotation = 0)));
        Parts.Fixed fixed3(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -88, -70},{ -68, -50}}, rotation = 0)));
        Parts.FixedRotation fixedRotation(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{ -8, -90},{12, -70}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Force force1(N_to_m = 600, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b) annotation(Placement(transformation(extent = {{62,40},{42,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Force force2(N_to_m = 600, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve) annotation(Placement(transformation(extent = {{60, -10},{40, -30}}, rotation = 0)));
        Joints.Revolute Revolute2(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -40}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Constant Constant2[3](k = {0,500,0}) annotation(Placement(transformation(origin = {70, -70}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Joints.Revolute Revolute3 annotation(Placement(transformation(extent = {{ -52,0},{ -32,20}}, rotation = 0)));
        Joints.Revolute Revolute4 annotation(Placement(transformation(extent = {{ -62, -70},{ -42, -50}}, rotation = 0)));
        Parts.Fixed fixed2(animation = false, r = {1.5,0.25,0}) annotation(Placement(transformation(extent = {{100,40},{80,60}}, rotation = 0)));
        Parts.Fixed fixed4(animation = false, r = {1.5, -0.25,0}) annotation(Placement(transformation(extent = {{100, -30},{80, -10}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(force1.frame_b,body1.frame_b) annotation(Line(points = {{42,50},{20,50}}));
        connect(Revolute1.frame_b,body1.frame_a) annotation(Line(points = {{ -20,40},{ -20,50},{0,50}}));
        connect(Revolute2.frame_b,body2.frame_a) annotation(Line(points = {{ -20, -30},{ -20, -20},{0, -20}}));
        connect(force2.frame_b,body2.frame_b) annotation(Line(points = {{40, -20},{20, -20}}));
        connect(Revolute3.frame_a,fixed1.frame_b) annotation(Line(points = {{ -52,10},{ -70,10}}));
        connect(Revolute3.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -32,10},{ -20,10},{ -20,20}}));
        connect(fixedRotation.frame_b,force2.frame_resolve) annotation(Line(points = {{12, -80},{46, -80},{46, -30}}));
        connect(fixed3.frame_b,Revolute4.frame_a) annotation(Line(points = {{ -68, -60},{ -62, -60}}));
        connect(Revolute4.frame_b,Revolute2.frame_a) annotation(Line(points = {{ -42, -60},{ -20, -60},{ -20, -50}}));
        connect(fixed3.frame_b,fixedRotation.frame_a) annotation(Line(points = {{ -68, -60},{ -64, -60},{ -64, -80},{ -8, -80}}));
        connect(Constant1.y,force1.force) annotation(Line(points = {{50,79},{50,72},{58,72},{58,62}}, color = {0,0,255}));
        connect(Constant2.y,force2.force) annotation(Line(points = {{70, -59},{70, -42},{56, -42},{56, -32}}, color = {0,0,255}));
        connect(force1.frame_a,fixed2.frame_b) annotation(Line(points = {{62,50},{71.5,50},{71.5,50},{80,50}}, color = {0,0,0}, thickness = 0.5));
        connect(fixed4.frame_b,force2.frame_a) annotation(Line(points = {{80, -20},{70, -20},{70, -20},{60, -20}}, color = {0,0,0}, thickness = 0.5));
      end Force;
      model Force2
        extends Modelica.Icons.Example;
        import Modelica.Mechanics.MultiBody.*;
        inner World world annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Joints.Revolute Revolute1(n = {0,1,0}) annotation(Placement(transformation(origin = { -20,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Parts.BodyCylinder body1(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = {0,500,0}) annotation(Placement(transformation(origin = {50,90}, extent = {{ -10,10},{10, -10}}, rotation = 270)));
        Parts.Fixed fixed1(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -90,0},{ -70,20}}, rotation = 0)));
        Parts.BodyCylinder body2(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -30},{20, -10}}, rotation = 0)));
        Parts.Fixed fixed3(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -88, -70},{ -68, -50}}, rotation = 0)));
        Parts.FixedRotation fixedRotation(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{ -8, -90},{12, -70}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Force force1(N_to_m = 600, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b) annotation(Placement(transformation(extent = {{62,40},{42,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Force force2(N_to_m = 600, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve) annotation(Placement(transformation(extent = {{60, -10},{40, -30}}, rotation = 0)));
        Joints.Revolute Revolute2(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -40}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Constant Constant2[3](k = {0,500,0}) annotation(Placement(transformation(origin = {70, -70}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Joints.Revolute Revolute3 annotation(Placement(transformation(extent = {{ -52,0},{ -32,20}}, rotation = 0)));
        Joints.Revolute Revolute4 annotation(Placement(transformation(extent = {{ -62, -70},{ -42, -50}}, rotation = 0)));
        Parts.Fixed fixed2(animation = false, r = {1.5,0.25,0}) annotation(Placement(transformation(extent = {{100,40},{80,60}}, rotation = 0)));
        Parts.Fixed fixed4(animation = false, r = {1.5, -0.25,0}) annotation(Placement(transformation(extent = {{100, -30},{80, -10}}, rotation = 0)));
        Joints.Revolute Revolute5(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -180}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Parts.BodyCylinder body3(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -170},{20, -150}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant3[6](k = {0,500,0,0,0,0}) annotation(Placement(transformation(origin = {50, -120}, extent = {{ -10,10},{10, -10}}, rotation = 270)));
        Parts.Fixed fixed5(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -90, -210},{ -70, -190}}, rotation = 0)));
        Parts.BodyCylinder body4(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -240},{20, -220}}, rotation = 0)));
        Parts.Fixed fixed6(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -88, -280},{ -68, -260}}, rotation = 0)));
        Parts.FixedRotation fixedRotation1(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{ -8, -300},{12, -280}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.ForceAndTorque force3(N_to_m = 600) annotation(Placement(transformation(extent = {{62, -170},{42, -150}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.ForceAndTorque force4(N_to_m = 600) annotation(Placement(transformation(extent = {{60, -220},{40, -240}}, rotation = 0)));
        Joints.Revolute Revolute6(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -250}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Constant Constant4[6](k = {0,500,0,0,0,0}) annotation(Placement(transformation(origin = {70, -280}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Joints.Revolute Revolute7 annotation(Placement(transformation(extent = {{ -52, -210},{ -32, -190}}, rotation = 0)));
        Joints.Revolute Revolute8 annotation(Placement(transformation(extent = {{ -62, -280},{ -42, -260}}, rotation = 0)));
        Parts.Fixed fixed7(animation = false, r = {1.5,0.25,0}) annotation(Placement(transformation(extent = {{100, -170},{80, -150}}, rotation = 0)));
        Parts.Fixed fixed8(animation = false, r = {1.5, -0.25,0}) annotation(Placement(transformation(extent = {{100, -240},{80, -220}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(force1.frame_b,body1.frame_b) annotation(Line(points = {{42,50},{20,50}}));
        connect(Revolute1.frame_b,body1.frame_a) annotation(Line(points = {{ -20,40},{ -20,50},{0,50}}));
        connect(Revolute2.frame_b,body2.frame_a) annotation(Line(points = {{ -20, -30},{ -20, -20},{0, -20}}));
        connect(force2.frame_b,body2.frame_b) annotation(Line(points = {{40, -20},{20, -20}}));
        connect(Revolute3.frame_a,fixed1.frame_b) annotation(Line(points = {{ -52,10},{ -70,10}}));
        connect(Revolute3.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -32,10},{ -20,10},{ -20,20}}));
        connect(fixedRotation.frame_b,force2.frame_resolve) annotation(Line(points = {{12, -80},{46, -80},{46, -30}}));
        connect(fixed3.frame_b,Revolute4.frame_a) annotation(Line(points = {{ -68, -60},{ -62, -60}}));
        connect(Revolute4.frame_b,Revolute2.frame_a) annotation(Line(points = {{ -42, -60},{ -20, -60},{ -20, -50}}));
        connect(fixed3.frame_b,fixedRotation.frame_a) annotation(Line(points = {{ -68, -60},{ -64, -60},{ -64, -80},{ -8, -80}}));
        connect(Constant1.y,force1.force) annotation(Line(points = {{50,79},{50,72},{58,72},{58,62}}, color = {0,0,255}));
        connect(Constant2.y,force2.force) annotation(Line(points = {{70, -59},{70, -42},{56, -42},{56, -32}}, color = {0,0,255}));
        connect(force1.frame_a,fixed2.frame_b) annotation(Line(points = {{62,50},{71.5,50},{71.5,50},{80,50}}, color = {0,0,0}, thickness = 0.5));
        connect(fixed4.frame_b,force2.frame_a) annotation(Line(points = {{80, -20},{70, -20},{70, -20},{60, -20}}, color = {0,0,0}, thickness = 0.5));
        connect(force3.frame_b,body3.frame_b) annotation(Line(points = {{42, -160},{20, -160}}));
        connect(Revolute5.frame_b,body3.frame_a) annotation(Line(points = {{ -20, -170},{ -20, -160},{0, -160}}));
        connect(Revolute6.frame_b,body4.frame_a) annotation(Line(points = {{ -20, -240},{ -20, -230},{0, -230}}));
        connect(force4.frame_b,body4.frame_b) annotation(Line(points = {{40, -230},{20, -230}}));
        connect(Revolute7.frame_a,fixed5.frame_b) annotation(Line(points = {{ -52, -200},{ -70, -200}}));
        connect(Revolute7.frame_b,Revolute5.frame_a) annotation(Line(points = {{ -32, -200},{ -20, -200},{ -20, -190}}));
        connect(fixedRotation1.frame_b,force4.frame_resolve) annotation(Line(points = {{12, -290},{46, -290},{46, -240}}));
        connect(fixed6.frame_b,Revolute8.frame_a) annotation(Line(points = {{ -68, -270},{ -62, -270}}));
        connect(Revolute8.frame_b,Revolute6.frame_a) annotation(Line(points = {{ -42, -270},{ -20, -270},{ -20, -260}}));
        connect(fixed6.frame_b,fixedRotation1.frame_a) annotation(Line(points = {{ -68, -270},{ -64, -270},{ -64, -290},{ -8, -290}}));
        connect(Constant3.y,force3.load) annotation(Line(points = {{50, -131},{50, -138},{58, -138},{58, -148}}, color = {0,0,255}));
        connect(Constant4.y,force4.load) annotation(Line(points = {{70, -269},{70, -252},{56, -252},{56, -242}}, color = {0,0,255}));
        connect(force3.frame_a,fixed7.frame_b) annotation(Line(points = {{62, -160},{71.5, -160},{71.5, -160},{80, -160}}, color = {0,0,0}, thickness = 0.5));
        connect(fixed8.frame_b,force4.frame_a) annotation(Line(points = {{80, -230},{70, -230},{70, -230},{60, -230}}, color = {0,0,0}, thickness = 0.5));
      end Force2;
      model ForcesAndTorques
        extends Modelica.Icons.Example;
        import Modelica.Mechanics.MultiBody.*;
        inner World world annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Joints.Revolute Revolute1(n = {0,1,0}) annotation(Placement(transformation(origin = { -20,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics));
        Parts.BodyCylinder body1(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[6](k = {0,500,0, -100,100,0}) annotation(Placement(transformation(origin = {50,90}, extent = {{ -10,10},{10, -10}}, rotation = 270)));
        Parts.Fixed fixed1(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -90,0},{ -70,20}}, rotation = 0)));
        Parts.BodyCylinder body2(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -30},{20, -10}}, rotation = 0)));
        Parts.Fixed fixed3(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -88, -70},{ -68, -50}}, rotation = 0)));
        Parts.FixedRotation fixedRotation(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{ -8, -90},{12, -70}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.ForceAndTorque forceAndTorque1(Nm_to_m = 120, N_to_m = 600) annotation(Placement(transformation(extent = {{62,40},{42,60}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.ForceAndTorque forceAndTorque2(Nm_to_m = 120, N_to_m = 600) annotation(Placement(transformation(extent = {{60, -10},{40, -30}}, rotation = 0)));
        Joints.Revolute Revolute2(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -40}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Constant Constant2[6](k = {0,500,0, -100,100,0}) annotation(Placement(transformation(origin = {70, -70}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Joints.Revolute Revolute3 annotation(Placement(transformation(extent = {{ -52,0},{ -32,20}}, rotation = 0)));
        Joints.Revolute Revolute4 annotation(Placement(transformation(extent = {{ -62, -70},{ -42, -50}}, rotation = 0)));
        Parts.Fixed fixed2(animation = false, r = {1.5,0.25,0}) annotation(Placement(transformation(extent = {{100,40},{80,60}}, rotation = 0)));
        Parts.Fixed fixed4(animation = false, r = {1.5, -0.25,0}) annotation(Placement(transformation(extent = {{100, -30},{80, -10}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(forceAndTorque1.frame_b,body1.frame_b) annotation(Line(points = {{42,50},{20,50}}));
        connect(Revolute1.frame_b,body1.frame_a) annotation(Line(points = {{ -20,40},{ -20,50},{0,50}}));
        connect(Revolute2.frame_b,body2.frame_a) annotation(Line(points = {{ -20, -30},{ -20, -20},{0, -20}}));
        connect(forceAndTorque2.frame_b,body2.frame_b) annotation(Line(points = {{40, -20},{20, -20}}));
        connect(Revolute3.frame_a,fixed1.frame_b) annotation(Line(points = {{ -52,10},{ -70,10}}));
        connect(Revolute3.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -32,10},{ -20,10},{ -20,20}}));
        connect(fixedRotation.frame_b,forceAndTorque2.frame_resolve) annotation(Line(points = {{12, -80},{46, -80},{46, -30}}));
        connect(fixed3.frame_b,Revolute4.frame_a) annotation(Line(points = {{ -68, -60},{ -62, -60}}));
        connect(Revolute4.frame_b,Revolute2.frame_a) annotation(Line(points = {{ -42, -60},{ -20, -60},{ -20, -50}}));
        connect(fixed3.frame_b,fixedRotation.frame_a) annotation(Line(points = {{ -68, -60},{ -64, -60},{ -64, -80},{ -8, -80}}));
        connect(Constant1.y,forceAndTorque1.load) annotation(Line(points = {{50,79},{50,72},{58,72},{58,62}}, color = {0,0,255}));
        connect(Constant2.y,forceAndTorque2.load) annotation(Line(points = {{70, -59},{70, -42},{56, -42},{56, -32}}, color = {0,0,255}));
        connect(forceAndTorque1.frame_a,fixed2.frame_b) annotation(Line(points = {{62,50},{71.5,50},{71.5,50},{80,50}}, color = {0,0,0}, thickness = 0.5));
        connect(fixed4.frame_b,forceAndTorque2.frame_a) annotation(Line(points = {{80, -20},{70, -20},{70, -20},{60, -20}}, color = {0,0,0}, thickness = 0.5));
      end ForcesAndTorques;
      model ForceWithTwoMasses
        extends Modelica.Icons.Example;
        annotation(experiment(StopTime = 3), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute revolute annotation(Placement(transformation(extent = {{ -40,20},{ -20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox BodyBox1(r = {0.7,0,0}) annotation(Placement(transformation(extent = {{0,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation FixedTranslation1(r = {0, -0.9,0}, width = 0.01, animation = false) annotation(Placement(transformation(origin = { -60, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Forces.LineForceWithTwoMasses force(L_a = 0.3, L_b = 0.3, m_a = 1, m_b = 1) annotation(Placement(transformation(extent = {{ -20, -20},{0, -40}}, rotation = 0)));
        annotation(Diagram);
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation FixedTranslation2(width = 0.01, animation = false, r = {0,0.1,0}) annotation(Placement(transformation(origin = { -60,50}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Modelica.Mechanics.Translational.Components.Damper damper(d = 10) annotation(Placement(transformation(extent = {{ -20, -80},{0, -60}}, rotation = 0)));

      equation 
        connect(BodyBox1.frame_a,revolute.frame_b) annotation(Line(points = {{0,30},{ -20,30}}));
        connect(force.frame_a,FixedTranslation1.frame_b) annotation(Line(points = {{ -20, -30},{ -60, -30},{ -60, -20}}));
        connect(force.frame_b,BodyBox1.frame_b) annotation(Line(points = {{0, -30},{40, -30},{40,30},{20,30}}));
        connect(world.frame_b,FixedTranslation2.frame_a) annotation(Line(points = {{ -80,30},{ -60,30},{ -60,40}}));
        connect(FixedTranslation2.frame_b,revolute.frame_a) annotation(Line(points = {{ -60,60},{ -60,70},{ -46,70},{ -46,30},{ -40,30}}));
        connect(world.frame_b,FixedTranslation1.frame_a) annotation(Line(points = {{ -80,30},{ -60,30},{ -60,0}}));
        connect(force.flange_a,damper.flange_a) annotation(Line(points = {{ -16, -41},{ -16, -54},{ -20, -54},{ -20, -70}}, color = {0,191,0}));
        connect(force.flange_b,damper.flange_b) annotation(Line(points = {{ -4, -41},{ -4, -54},{0, -54},{0, -70}}, color = {0,191,0}));
      end ForceWithTwoMasses;
      model FrameForces
        extends Modelica.Icons.Example;
        import Modelica.Mechanics.MultiBody.*;
        inner World world annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}}, rotation = 0)));
        Joints.Revolute Revolute1 annotation(Placement(transformation(extent = {{ -40,40},{ -20,60}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Parts.BodyCylinder BodyCylinder1(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = {0,500,0}) annotation(Placement(transformation(extent = {{100,40},{80,60}}, rotation = 0)));
        Parts.Fixed fixed1(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -80,40},{ -60,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.WorldForce frameForce1(N_to_m = 600, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_b) annotation(Placement(transformation(extent = {{60,40},{40,60}}, rotation = 0)));
        Joints.Revolute Revolute2 annotation(Placement(transformation(extent = {{ -40,0},{ -20,20}}, rotation = 0)));
        Parts.BodyCylinder BodyCylinder2(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,0},{20,20}}, rotation = 0)));
        Parts.Fixed fixed2(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -80,0},{ -60,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.WorldForce frameForce2(N_to_m = 600, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_resolve) annotation(Placement(transformation(extent = {{60,0},{40,20}}, rotation = 0)));
        Parts.FixedRotation FixedRotation1(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{ -40, -40},{ -20, -20}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(BodyCylinder1.frame_a,Revolute1.frame_b) annotation(Line(points = {{0,50},{ -20,50}}));
        connect(fixed1.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -60,50},{ -40,50}}));
        connect(frameForce1.frame_b,BodyCylinder1.frame_b) annotation(Line(points = {{40,50},{20,50}}));
        connect(Constant1.y,frameForce1.force) annotation(Line(points = {{79,50},{62,50}}, color = {0,0,255}));
        connect(BodyCylinder2.frame_a,Revolute2.frame_b) annotation(Line(points = {{0,10},{ -20,10}}));
        connect(fixed2.frame_b,Revolute2.frame_a) annotation(Line(points = {{ -60,10},{ -40,10}}));
        connect(frameForce2.frame_b,BodyCylinder2.frame_b) annotation(Line(points = {{40,10},{20,10}}));
        connect(fixed2.frame_b,FixedRotation1.frame_a) annotation(Line(points = {{ -60,10},{ -52,10},{ -52, -30},{ -40, -30}}));
        connect(FixedRotation1.frame_b,frameForce2.frame_resolve) annotation(Line(points = {{ -20, -30},{50, -30},{50,0}}));
        connect(Constant1.y,frameForce2.force) annotation(Line(points = {{79,50},{72,50},{72,10},{62,10}}, color = {0,0,255}));
      end FrameForces;
      model FrameForcesAndTorques
        extends Modelica.Icons.Example;
        import Modelica.Mechanics.MultiBody.*;
        inner World world annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}}, rotation = 0)));
        Joints.Revolute Revolute1(n = {0,1,0}) annotation(Placement(transformation(origin = { -20,50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Parts.BodyCylinder body1(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,60},{20,80}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[6](k = {0,500,0, -100,100,0}) annotation(Placement(transformation(extent = {{100,60},{80,80}}, rotation = 0)));
        Parts.Fixed fixed1(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -80,20},{ -60,40}}, rotation = 0)));
        Parts.BodyCylinder body2(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -30},{20, -10}}, rotation = 0)));
        Parts.Fixed fixed2(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -88, -70},{ -68, -50}}, rotation = 0)));
        Parts.FixedRotation FixedRotation1(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{ -8, -90},{12, -70}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.FrameForceAndTorque frameTorque1(Nm_to_m = 120, N_to_m = 600) annotation(Placement(transformation(extent = {{60,60},{40,80}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.FrameForceAndTorque frameTorque2(Nm_to_m = 120, N_to_m = 600) annotation(Placement(transformation(extent = {{60, -10},{40, -30}}, rotation = 0)));
        Joints.Revolute Revolute2(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -40}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Constant Constant2[6](k = {0,500,0, -100,100,0}) annotation(Placement(transformation(extent = {{100, -30},{80, -10}}, rotation = 0)));
        Joints.Revolute Revolute3 annotation(Placement(transformation(extent = {{ -52,20},{ -32,40}}, rotation = 0)));
        Joints.Revolute Revolute4 annotation(Placement(transformation(extent = {{ -62, -70},{ -42, -50}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(frameTorque1.frame_b,body1.frame_b) annotation(Line(points = {{40,70},{20,70}}));
        connect(Constant1.y,frameTorque1.load) annotation(Line(points = {{79,70},{62,70}}, color = {0,0,255}));
        connect(Revolute1.frame_b,body1.frame_a) annotation(Line(points = {{ -20,60},{ -20,70},{0,70}}));
        connect(Revolute2.frame_b,body2.frame_a) annotation(Line(points = {{ -20, -30},{ -20, -20},{0, -20}}));
        connect(frameTorque2.frame_b,body2.frame_b) annotation(Line(points = {{40, -20},{20, -20}}));
        connect(Constant2.y,frameTorque2.load) annotation(Line(points = {{79, -20},{62, -20}}, color = {0,0,255}));
        connect(Revolute3.frame_a,fixed1.frame_b) annotation(Line(points = {{ -52,30},{ -60,30}}));
        connect(Revolute3.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -32,30},{ -20,30},{ -20,40}}));
        connect(FixedRotation1.frame_b,frameTorque2.frame_resolve) annotation(Line(points = {{12, -80},{50, -80},{50, -30}}));
        connect(fixed2.frame_b,Revolute4.frame_a) annotation(Line(points = {{ -68, -60},{ -62, -60}}));
        connect(Revolute4.frame_b,Revolute2.frame_a) annotation(Line(points = {{ -42, -60},{ -20, -60},{ -20, -50}}));
        connect(fixed2.frame_b,FixedRotation1.frame_a) annotation(Line(points = {{ -68, -60},{ -64, -60},{ -64, -80},{ -8, -80}}));
      end FrameForcesAndTorques;
      model FrameTorques
        import Modelica.Mechanics.MultiBody.*;
        extends Modelica.Icons.Example;
        inner World world annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}}, rotation = 0)));
        Joints.Revolute Revolute1(n = {0,1,0}) annotation(Placement(transformation(origin = { -30,50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Parts.BodyCylinder body1(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,80},{20,100}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = {0,100,0}) annotation(Placement(transformation(extent = {{100,80},{80,100}}, rotation = 0)));
        Parts.Fixed fixed1(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -80,20},{ -60,40}}, rotation = 0)));
        Parts.BodyCylinder body2(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,0},{20,20}}, rotation = 0)));
        Parts.Fixed fixed2(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -80, -40},{ -60, -20}}, rotation = 0)));
        Parts.FixedRotation FixedRotation1(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{0, -60},{20, -40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.WorldTorque frameTorque1(Nm_to_m = 120, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_b) annotation(Placement(transformation(extent = {{60,80},{40,100}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.WorldTorque frameTorque2(Nm_to_m = 120, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameB.frame_resolve) annotation(Placement(transformation(extent = {{60,20},{40,0}}, rotation = 0)));
        Joints.Revolute Revolute2(n = {0,1,0}) annotation(Placement(transformation(origin = { -30, -10}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Constant Constant2[3](k = {0,100,0}) annotation(Placement(transformation(extent = {{100,0},{80,20}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(fixed2.frame_b,FixedRotation1.frame_a) annotation(Line(points = {{ -60, -30},{ -52, -30},{ -52, -50},{0, -50}}));
        connect(frameTorque1.frame_b,body1.frame_b) annotation(Line(points = {{40,90},{20,90}}));
        connect(fixed1.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -60,30},{ -30,30},{ -30,40}}));
        connect(Revolute1.frame_b,body1.frame_a) annotation(Line(points = {{ -30,60},{ -30,90},{0,90}}));
        connect(fixed2.frame_b,Revolute2.frame_a) annotation(Line(points = {{ -60, -30},{ -30, -30},{ -30, -20}}));
        connect(Revolute2.frame_b,body2.frame_a) annotation(Line(points = {{ -30,0},{ -30,10},{0,10}}));
        connect(frameTorque2.frame_b,body2.frame_b) annotation(Line(points = {{40,10},{20,10}}));
        connect(FixedRotation1.frame_b,frameTorque2.frame_resolve) annotation(Line(points = {{20, -50},{50, -50},{50,0}}));
        connect(Constant1.y,frameTorque1.torque) annotation(Line(points = {{79,90},{62,90}}, color = {0,0,127}, smooth = Smooth.None));
        connect(Constant2.y,frameTorque2.torque) annotation(Line(points = {{79,10},{62,10}}, color = {0,0,127}, smooth = Smooth.None));
      end FrameTorques;
      model LineForceWithTwoMasses "Example to demonstrate how to construct force elements with masses"
        import SI = Modelica.SIunits;
        extends Modelica.Icons.Example;
        parameter Modelica.SIunits.Mass m = 1 "Mass of point masses";
        SI.Force rod_f_diff[3] = rod1.frame_b.f - rod3.frame_b.f "Difference of cut-forces in rod1 and rod3";
        SI.Force body_f_diff[3] = bodyBox1.frame_b.f - bodyBox2.frame_b.f "Difference of cut-forces in bodyBox1 and bodyBox2";
        annotation(experiment(StopTime = 3), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics), Documentation(info = "<html>
<p>
With this example it is demonstrated how to use the Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUPS
joint to build up a force element with masses and inertias (note, Modelica.Mechanics.MultiBody.Forces.LineForceWithMass
is a default line force element with a point mass to approximate the mass properties of the
component):
</p>
<p align=\"center\">
<IMG SRC=\"../Images/Examples/Elementary/ForceWithMasses.png\"
ALT=\"model Examples.Elementary.ForceWithMasses\">
</p>
<p>
A JointUPS consists of
a universal, prismatic and spherical joint aggregation that approximates
a real force component, such as a hydraulic cylinder. At frame frame_ia at the
universal joint and at frame frame_ib at the spherical joint, bodies can be
attached describing the mass properties of the component. Between the 1-dimensional
mechanical translational flanges \"axis\" and \"bearing\" a one-dimensional
force law can be attached, e.g., from the Modelica.Mechanics.Translational or
the HyLib package (= library of hydraulic components). In this example, just
a linear damper is connected here.
</p>
</html>"));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute revolute1 annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox1(r = {0.7,0,0}) annotation(Placement(transformation(extent = {{20,60},{40,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod1(r = {0, -0.9,0}, width = 0.01, animation = false) annotation(Placement(transformation(origin = { -40,54}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUPS jointUPS(nAxis_ia = {0.7,1.2,0}, animation = true) annotation(Placement(transformation(extent = {{0,50},{20,30}}, rotation = 0)));
        annotation(Diagram);
        Modelica.Mechanics.MultiBody.Parts.Body body1(r_CM = 0.2 * jointUPS.eAxis_ia, cylinderDiameter = 0.05, animation = true, m = m, I_11 = 0, I_22 = 0, I_33 = 0) annotation(Placement(transformation(extent = {{ -14,14},{ -34,34}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body2(r_CM =  -0.2 * jointUPS.eAxis_ia, cylinderDiameter = 0.05, animation = true, m = m, I_11 = 0, I_22 = 0, I_33 = 0) annotation(Placement(transformation(extent = {{32,14},{52,34}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod2(r = {0,0.3,0}, width = 0.01, animation = false) annotation(Placement(transformation(origin = { -40,84}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Modelica.Mechanics.Translational.Components.Damper damper1(d = 3) annotation(Placement(transformation(extent = {{0,24},{20,4}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute revolute2 annotation(Placement(transformation(extent = {{ -20, -40},{0, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox2(r = {0.7,0,0}) annotation(Placement(transformation(extent = {{20, -40},{40, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod3(width = 0.01, r = {0, -0.9,0.3}, animation = false) annotation(Placement(transformation(origin = { -40, -46}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation rod4(width = 0.01, r = {0,0.3,0.3}, animation = false) annotation(Placement(transformation(origin = { -40, -16}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Modelica.Mechanics.Translational.Components.Damper damper2(d = 3) annotation(Placement(transformation(extent = {{0, -76},{20, -96}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.LineForceWithTwoMasses lineForceWithTwoMasses(L_a = 0.2, L_b = 0.2, cylinderLength_a = 0.2, cylinderLength_b = 1.2, massDiameterFaction = 2.2, m_a = m, m_b = m) annotation(Placement(transformation(extent = {{0, -50},{20, -70}}, rotation = 0)));

      equation 
        connect(jointUPS.bearing,damper1.flange_a) annotation(Line(points = {{6,30},{6,20},{0,20},{0,14}}, color = {0,191,0}));
        connect(jointUPS.axis,damper1.flange_b) annotation(Line(points = {{14,30},{14,20},{20,20},{20,14}}, color = {0,191,0}));
        connect(jointUPS.frame_ib,body2.frame_a) annotation(Line(points = {{18,30},{18,24},{32,24}}, color = {0,0,0}, thickness = 0.5));
        connect(world.frame_b,rod2.frame_a) annotation(Line(points = {{ -60,70},{ -40,70},{ -40,74}}, color = {0,0,0}, thickness = 0.5));
        connect(world.frame_b,rod1.frame_a) annotation(Line(points = {{ -60,70},{ -40,70},{ -40,64}}, color = {0,0,0}, thickness = 0.5));
        connect(rod2.frame_b,revolute1.frame_a) annotation(Line(points = {{ -40,94},{ -40,98},{ -28,98},{ -28,70},{ -20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(revolute1.frame_b,bodyBox1.frame_a) annotation(Line(points = {{0,70},{20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(bodyBox1.frame_b,jointUPS.frame_b) annotation(Line(points = {{40,70},{46,70},{46,40},{20,40}}, color = {0,0,0}, thickness = 0.5));
        connect(body1.frame_a,jointUPS.frame_ia) annotation(Line(points = {{ -14,24},{2,24},{2,30}}, color = {0,0,0}, thickness = 0.5));
        connect(rod1.frame_b,jointUPS.frame_a) annotation(Line(points = {{ -40,44},{ -40,40},{0,40}}, color = {0,0,0}, thickness = 0.5));
        connect(rod4.frame_b,revolute2.frame_a) annotation(Line(points = {{ -40, -6},{ -40, -2},{ -28, -2},{ -28, -30},{ -20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(revolute2.frame_b,bodyBox2.frame_a) annotation(Line(points = {{0, -30},{20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(world.frame_b,rod4.frame_a) annotation(Line(points = {{ -60,70},{ -52,70},{ -52, -32},{ -40, -32},{ -40, -26}}, color = {0,0,0}, thickness = 0.5));
        connect(rod3.frame_a,rod4.frame_a) annotation(Line(points = {{ -40, -36},{ -40, -26}}, color = {0,0,0}, thickness = 0.5));
        connect(lineForceWithTwoMasses.frame_a,rod3.frame_b) annotation(Line(points = {{0, -60},{ -40, -60},{ -40, -56}}, color = {0,0,0}, thickness = 0.5));
        connect(lineForceWithTwoMasses.frame_b,bodyBox2.frame_b) annotation(Line(points = {{20, -60},{54, -60},{54, -30},{40, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(lineForceWithTwoMasses.flange_b,damper2.flange_b) annotation(Line(points = {{16, -71},{20, -71},{20, -86}}, color = {0,191,0}));
        connect(lineForceWithTwoMasses.flange_a,damper2.flange_a) annotation(Line(points = {{4, -71},{0, -71},{0, -86}}, color = {0,191,0}));
      end LineForceWithTwoMasses;
      model Torque
        extends Modelica.Icons.Example;
        import Modelica.Mechanics.MultiBody.*;
        inner World world annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Joints.Revolute Revolute1(n = {0,1,0}) annotation(Placement(transformation(origin = { -20,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics));
        Parts.BodyCylinder body1(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = { -100,100,0}) annotation(Placement(transformation(origin = {50,90}, extent = {{ -10,10},{10, -10}}, rotation = 270)));
        Parts.Fixed fixed1(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -90,0},{ -70,20}}, rotation = 0)));
        Parts.BodyCylinder body2(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -30},{20, -10}}, rotation = 0)));
        Parts.Fixed fixed3(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -88, -70},{ -68, -50}}, rotation = 0)));
        Parts.FixedRotation fixedRotation(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{ -8, -90},{12, -70}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Torque torque1(Nm_to_m = 120, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b) annotation(Placement(transformation(extent = {{62,40},{42,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Torque torque2(Nm_to_m = 120, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve) annotation(Placement(transformation(extent = {{60, -10},{40, -30}}, rotation = 0)));
        Joints.Revolute Revolute2(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -40}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Constant Constant2[3](k = { -100,100,0}) annotation(Placement(transformation(origin = {70, -70}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Joints.Revolute Revolute3 annotation(Placement(transformation(extent = {{ -52,0},{ -32,20}}, rotation = 0)));
        Joints.Revolute Revolute4 annotation(Placement(transformation(extent = {{ -62, -70},{ -42, -50}}, rotation = 0)));
        Parts.Fixed fixed2(animation = false, r = {1.5,0.25,0}) annotation(Placement(transformation(extent = {{100,40},{80,60}}, rotation = 0)));
        Parts.Fixed fixed4(animation = false, r = {1.5, -0.25,0}) annotation(Placement(transformation(extent = {{100, -30},{80, -10}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(torque1.frame_b,body1.frame_b) annotation(Line(points = {{42,50},{20,50}}));
        connect(Revolute1.frame_b,body1.frame_a) annotation(Line(points = {{ -20,40},{ -20,50},{0,50}}));
        connect(Revolute2.frame_b,body2.frame_a) annotation(Line(points = {{ -20, -30},{ -20, -20},{0, -20}}));
        connect(torque2.frame_b,body2.frame_b) annotation(Line(points = {{40, -20},{20, -20}}));
        connect(Revolute3.frame_a,fixed1.frame_b) annotation(Line(points = {{ -52,10},{ -70,10}}));
        connect(Revolute3.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -32,10},{ -20,10},{ -20,20}}));
        connect(fixedRotation.frame_b,torque2.frame_resolve) annotation(Line(points = {{12, -80},{46, -80},{46, -30}}));
        connect(fixed3.frame_b,Revolute4.frame_a) annotation(Line(points = {{ -68, -60},{ -62, -60}}));
        connect(Revolute4.frame_b,Revolute2.frame_a) annotation(Line(points = {{ -42, -60},{ -20, -60},{ -20, -50}}));
        connect(fixed3.frame_b,fixedRotation.frame_a) annotation(Line(points = {{ -68, -60},{ -64, -60},{ -64, -80},{ -8, -80}}));
        connect(Constant1.y,torque1.torque) annotation(Line(points = {{50,79},{50,72},{58,72},{58,62}}, color = {0,0,255}));
        connect(Constant2.y,torque2.torque) annotation(Line(points = {{70, -59},{70, -42},{56, -42},{56, -32}}, color = {0,0,255}));
        connect(torque1.frame_a,fixed2.frame_b) annotation(Line(points = {{62,50},{80,50}}, color = {0,0,0}, thickness = 0.5));
        connect(fixed4.frame_b,torque2.frame_a) annotation(Line(points = {{80, -20},{60, -20}}, color = {0,0,0}, thickness = 0.5));
      end Torque;
      model Torque2
        extends Modelica.Icons.Example;
        import Modelica.Mechanics.MultiBody.*;
        inner World world annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Joints.Revolute Revolute1(n = {0,1,0}) annotation(Placement(transformation(origin = { -20,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -300},{100,100}}, grid = {1,1}), graphics));
        Parts.BodyCylinder body1(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = { -100,100,0}) annotation(Placement(transformation(origin = {50,90}, extent = {{ -10,10},{10, -10}}, rotation = 270)));
        Parts.Fixed fixed1(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -90,0},{ -70,20}}, rotation = 0)));
        Parts.BodyCylinder body2(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -30},{20, -10}}, rotation = 0)));
        Parts.Fixed fixed3(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -88, -70},{ -68, -50}}, rotation = 0)));
        Parts.FixedRotation fixedRotation(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{ -8, -90},{12, -70}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Torque torque1(Nm_to_m = 120, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b) annotation(Placement(transformation(extent = {{62,40},{42,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Torque torque2(Nm_to_m = 120, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve) annotation(Placement(transformation(extent = {{60, -10},{40, -30}}, rotation = 0)));
        Joints.Revolute Revolute2(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -40}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Constant Constant2[3](k = { -100,100,0}) annotation(Placement(transformation(origin = {70, -70}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Joints.Revolute Revolute3 annotation(Placement(transformation(extent = {{ -52,0},{ -32,20}}, rotation = 0)));
        Joints.Revolute Revolute4 annotation(Placement(transformation(extent = {{ -62, -70},{ -42, -50}}, rotation = 0)));
        Parts.Fixed fixed2(animation = false, r = {1.5,0.25,0}) annotation(Placement(transformation(extent = {{100,40},{80,60}}, rotation = 0)));
        Parts.Fixed fixed4(animation = false, r = {1.5, -0.25,0}) annotation(Placement(transformation(extent = {{100, -30},{80, -10}}, rotation = 0)));
        Joints.Revolute Revolute5(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -160}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Parts.BodyCylinder body3(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -150},{20, -130}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant3[6](k = {0,0,0, -100,100,0}) annotation(Placement(transformation(origin = {50, -100}, extent = {{ -10,10},{10, -10}}, rotation = 270)));
        Parts.Fixed fixed5(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -90, -190},{ -70, -170}}, rotation = 0)));
        Parts.BodyCylinder body4(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -220},{20, -200}}, rotation = 0)));
        Parts.Fixed fixed6(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -88, -260},{ -68, -240}}, rotation = 0)));
        Parts.FixedRotation fixedRotation1(n = {0,0,1}, angle = 45) annotation(Placement(transformation(extent = {{ -8, -280},{12, -260}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.ForceAndTorque torque3(Nm_to_m = 120) annotation(Placement(transformation(extent = {{62, -150},{42, -130}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.ForceAndTorque torque4(Nm_to_m = 120) annotation(Placement(transformation(extent = {{60, -200},{40, -220}}, rotation = 0)));
        Joints.Revolute Revolute6(n = {0,1,0}) annotation(Placement(transformation(origin = { -20, -230}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Constant Constant4[6](k = {0,0,0, -100,100,0}) annotation(Placement(transformation(origin = {70, -260}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Joints.Revolute Revolute7 annotation(Placement(transformation(extent = {{ -52, -190},{ -32, -170}}, rotation = 0)));
        Joints.Revolute Revolute8 annotation(Placement(transformation(extent = {{ -62, -260},{ -42, -240}}, rotation = 0)));
        Parts.Fixed fixed7(animation = false, r = {1.5,0.25,0}) annotation(Placement(transformation(extent = {{100, -150},{80, -130}}, rotation = 0)));
        Parts.Fixed fixed8(animation = false, r = {1.5, -0.25,0}) annotation(Placement(transformation(extent = {{100, -220},{80, -200}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(torque1.frame_b,body1.frame_b) annotation(Line(points = {{42,50},{20,50}}));
        connect(Revolute1.frame_b,body1.frame_a) annotation(Line(points = {{ -20,40},{ -20,50},{0,50}}));
        connect(Revolute2.frame_b,body2.frame_a) annotation(Line(points = {{ -20, -30},{ -20, -20},{0, -20}}));
        connect(torque2.frame_b,body2.frame_b) annotation(Line(points = {{40, -20},{20, -20}}));
        connect(Revolute3.frame_a,fixed1.frame_b) annotation(Line(points = {{ -52,10},{ -70,10}}));
        connect(Revolute3.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -32,10},{ -20,10},{ -20,20}}));
        connect(fixedRotation.frame_b,torque2.frame_resolve) annotation(Line(points = {{12, -80},{46, -80},{46, -30}}));
        connect(fixed3.frame_b,Revolute4.frame_a) annotation(Line(points = {{ -68, -60},{ -62, -60}}));
        connect(Revolute4.frame_b,Revolute2.frame_a) annotation(Line(points = {{ -42, -60},{ -20, -60},{ -20, -50}}));
        connect(fixed3.frame_b,fixedRotation.frame_a) annotation(Line(points = {{ -68, -60},{ -64, -60},{ -64, -80},{ -8, -80}}));
        connect(Constant1.y,torque1.torque) annotation(Line(points = {{50,79},{50,72},{58,72},{58,62}}, color = {0,0,255}));
        connect(Constant2.y,torque2.torque) annotation(Line(points = {{70, -59},{70, -42},{56, -42},{56, -32}}, color = {0,0,255}));
        connect(torque1.frame_a,fixed2.frame_b) annotation(Line(points = {{62,50},{80,50}}, color = {0,0,0}, thickness = 0.5));
        connect(fixed4.frame_b,torque2.frame_a) annotation(Line(points = {{80, -20},{60, -20}}, color = {0,0,0}, thickness = 0.5));
        connect(torque3.frame_b,body3.frame_b) annotation(Line(points = {{42, -140},{20, -140}}));
        connect(Revolute5.frame_b,body3.frame_a) annotation(Line(points = {{ -20, -150},{ -20, -140},{0, -140}}));
        connect(Revolute6.frame_b,body4.frame_a) annotation(Line(points = {{ -20, -220},{ -20, -210},{0, -210}}));
        connect(torque4.frame_b,body4.frame_b) annotation(Line(points = {{40, -210},{20, -210}}));
        connect(Revolute7.frame_a,fixed5.frame_b) annotation(Line(points = {{ -52, -180},{ -70, -180}}));
        connect(Revolute7.frame_b,Revolute5.frame_a) annotation(Line(points = {{ -32, -180},{ -20, -180},{ -20, -170}}));
        connect(fixedRotation1.frame_b,torque4.frame_resolve) annotation(Line(points = {{12, -270},{46, -270},{46, -220}}));
        connect(fixed6.frame_b,Revolute8.frame_a) annotation(Line(points = {{ -68, -250},{ -62, -250}}));
        connect(Revolute8.frame_b,Revolute6.frame_a) annotation(Line(points = {{ -42, -250},{ -20, -250},{ -20, -240}}));
        connect(fixed6.frame_b,fixedRotation1.frame_a) annotation(Line(points = {{ -68, -250},{ -64, -250},{ -64, -270},{ -8, -270}}));
        connect(Constant3.y,torque3.load) annotation(Line(points = {{50, -111},{50, -118},{58, -118},{58, -128}}, color = {0,0,255}));
        connect(Constant4.y,torque4.load) annotation(Line(points = {{70, -249},{70, -232},{56, -232},{56, -222}}, color = {0,0,255}));
        connect(torque3.frame_a,fixed7.frame_b) annotation(Line(points = {{62, -140},{80, -140}}, color = {0,0,0}, thickness = 0.5));
        connect(fixed8.frame_b,torque4.frame_a) annotation(Line(points = {{80, -210},{60, -210}}, color = {0,0,0}, thickness = 0.5));
      end Torque2;
      model WorldForces
        extends Modelica.Icons.Example;
        import Modelica.Mechanics.MultiBody.*;
        inner World world annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
        Joints.Revolute Revolute1 annotation(Placement(transformation(extent = {{ -40,60},{ -20,80}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Parts.BodyCylinder BodyCylinder1(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,60},{20,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.WorldForce worldForce(N_to_m = 600) annotation(Placement(transformation(extent = {{60,60},{40,80}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = {0,500,0}) annotation(Placement(transformation(extent = {{100,60},{80,80}}, rotation = 0)));
        Parts.Fixed fixed2(r = {0, -0.5,0}) annotation(Placement(transformation(extent = {{ -80, -20},{ -60,0}}, rotation = 0)));
        Joints.Revolute Revolute2(n = {0,1,0}) annotation(Placement(transformation(origin = { -30,10}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Parts.BodyCylinder BodyCylinder2(r = {1,0,0}) annotation(Placement(transformation(extent = {{0,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.WorldTorque worldTorque1(Nm_to_m = 200) annotation(Placement(transformation(extent = {{60,20},{40,40}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant2[3](k = {100,100,100}) annotation(Placement(transformation(extent = {{100,20},{80,40}}, rotation = 0)));
        Parts.Fixed fixed1(r = {0,0.5,0}) annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Joints.Revolute Revolute3 annotation(Placement(transformation(extent = {{ -50, -100},{ -30, -80}}, rotation = 0)));
        Parts.BodyCylinder BodyCylinder3(r = {1,0,0}) annotation(Placement(transformation(extent = {{0, -60},{20, -40}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant4[6](k = {0,500,0,100,100,100}) annotation(Placement(transformation(extent = {{100, -60},{80, -40}}, rotation = 0)));
        Parts.Fixed fixed3(r = {0, -1,0}) annotation(Placement(transformation(extent = {{ -80, -100},{ -60, -80}}, rotation = 0)));
        Joints.Revolute Revolute4(n = {0,1,0}) annotation(Placement(transformation(origin = { -10, -70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.WorldForceAndTorque ForceTorque(N_to_m = 600, Nm_to_m = 200) annotation(Placement(transformation(extent = {{60, -60},{40, -40}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(BodyCylinder1.frame_a,Revolute1.frame_b) annotation(Line(points = {{0,70},{ -20,70}}));
        connect(worldForce.frame_b,BodyCylinder1.frame_b) annotation(Line(points = {{40,70},{20,70}}));
        connect(fixed2.frame_b,Revolute2.frame_a) annotation(Line(points = {{ -60, -10},{ -30, -10},{ -30,0}}));
        connect(BodyCylinder2.frame_a,Revolute2.frame_b) annotation(Line(points = {{0,30},{ -30,30},{ -30,20}}));
        connect(worldTorque1.frame_b,BodyCylinder2.frame_b) annotation(Line(points = {{40,30},{20,30}}));
        connect(fixed1.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -60,70},{ -40,70}}));
        connect(fixed3.frame_b,Revolute3.frame_a) annotation(Line(points = {{ -60, -90},{ -50, -90}}));
        connect(Revolute3.frame_b,Revolute4.frame_a) annotation(Line(points = {{ -30, -90},{ -10, -90},{ -10, -80}}));
        connect(ForceTorque.frame_b,BodyCylinder3.frame_b) annotation(Line(points = {{40, -50},{20, -50}}));
        connect(Revolute4.frame_b,BodyCylinder3.frame_a) annotation(Line(points = {{ -10, -60},{ -10, -50},{0, -50}}));
        connect(Constant4.y,ForceTorque.load) annotation(Line(points = {{79, -50},{62, -50}}, color = {0,0,127}, smooth = Smooth.None));
        connect(Constant1.y,worldForce.force) annotation(Line(points = {{79,70},{62,70}}, color = {0,0,127}, smooth = Smooth.None));
        connect(Constant2.y,worldTorque1.torque) annotation(Line(points = {{79,30},{62,30}}, color = {0,0,127}, smooth = Smooth.None));
      end WorldForces;
    end Forces;
    package Joints "Test MultiBody.Joints"
      model Revolute
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow axis(length = 0.5, color = {0,0,0}, diameter = 0.02, n = {0,0,1}) annotation(Placement(transformation(extent = {{10,60},{30,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute revolute(n = {0,0,1}, cylinderDiameter = 1 / 15, a(fixed = false), phi(fixed = true, start = 0.785398163397448), w(fixed = true)) annotation(Placement(transformation(extent = {{ -22,20},{ -2,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body(animation = false) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a(color_x = {0,128,255}) annotation(Placement(transformation(origin = { -30, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a1(color_x = {0,0,200}) annotation(Placement(transformation(origin = {10, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,revolute.frame_a) annotation(Line(points = {{ -40,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(revolute.frame_b,body.frame_a) annotation(Line(points = {{ -2,30},{20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(revolute.frame_b,axis.frame_a) annotation(Line(points = {{ -2,30},{4,30},{4,70},{10,70}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a.frame_a,revolute.frame_a) annotation(Line(points = {{ -30,0},{ -30,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a1.frame_a,revolute.frame_b) annotation(Line(points = {{10,0},{12,0},{12,30},{ -2,30}}, color = {0,0,0}, thickness = 0.5));
      end Revolute;
      model RevoluteInitialization
        inner Modelica.Mechanics.MultiBody.World world(gravityType = Modelica.Mechanics.MultiBody.Types.GravityTypes.UniformGravity) annotation(Placement(transformation(extent = {{ -80,0},{ -60,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute rev(n = {0,0,1}, useAxisFlange = true, a(fixed = true), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{ -40,0},{ -20,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Damper damper(d = 0.1) annotation(Placement(transformation(extent = {{ -40,40},{ -20,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyShape body(r = {1,0,0}, r_CM = {0.5,0,0}, m = 1) annotation(Placement(transformation(extent = {{0,0},{20,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed fixed(r = {1,0.2,0}, width = 0.02) annotation(Placement(transformation(origin = {50,70}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Forces.Spring spring(s_unstretched = 0.1, c(fixed = false) = 100) annotation(Placement(transformation(origin = {50,30}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,rev.frame_a) annotation(Line(points = {{ -60,10},{ -40,10}}, color = {0,0,0}, thickness = 0.5));
        connect(damper.flange_b,rev.axis) annotation(Line(points = {{ -20,50},{ -16,50},{ -16,26},{ -30,26},{ -30,20}}, color = {0,0,0}));
        connect(rev.support,damper.flange_a) annotation(Line(points = {{ -36,20},{ -36,26},{ -48,26},{ -48,50},{ -40,50}}, color = {0,0,0}));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        connect(rev.frame_b,body.frame_a) annotation(Line(points = {{ -20,10},{0,10}}, color = {0,0,0}, thickness = 0.5));
        connect(fixed.frame_b,spring.frame_a) annotation(Line(points = {{50,60},{50,40}}, color = {0,0,0}, thickness = 0.5));
        connect(body.frame_b,spring.frame_b) annotation(Line(points = {{20,10},{50,10},{50,20}}, color = {0,0,0}, thickness = 0.5));
      end RevoluteInitialization;
      model Prismatic
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(graphics));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow axis(length = 0.5, color = {0,0,0}, diameter = 0.02, n = {1,1,0}) annotation(Placement(transformation(extent = {{10,60},{30,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Prismatic prismatic(n = {1,1,0}, a(fixed = false), s(fixed = true, start = 0.3), v(fixed = true)) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body(animation = false) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a(color_x = {0,128,255}) annotation(Placement(transformation(origin = { -30, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a1(color_x = {0,0,200}) annotation(Placement(transformation(origin = {10, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,prismatic.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(prismatic.frame_b,body.frame_a) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(prismatic.frame_b,axis.frame_a) annotation(Line(points = {{0,30},{4,30},{4,70},{10,70}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a.frame_a,prismatic.frame_a) annotation(Line(points = {{ -30,0},{ -30,30},{ -20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a1.frame_a,prismatic.frame_b) annotation(Line(points = {{10,0},{12,0},{12,30},{0,30}}, color = {0,0,0}, thickness = 0.5));
      end Prismatic;
      model Cylindrical
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow axis(length = 0.5, color = {0,0,0}, diameter = 0.02, n = {0,0,1}) annotation(Placement(transformation(extent = {{10,60},{30,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Cylindrical cylindrical(n = {0,0,1}, cylinderDiameter = 1 / 15, a(fixed = false), phi(fixed = true, start = 0.785398163397448), s(fixed = true, start = 0.3), v(fixed = true), w(fixed = true), wd(fixed = false)) annotation(Placement(transformation(extent = {{ -22,20},{ -2,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body(animation = false) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a(color_x = {0,128,255}) annotation(Placement(transformation(origin = { -30, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a1(color_x = {0,0,200}) annotation(Placement(transformation(origin = {10, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,cylindrical.frame_a) annotation(Line(points = {{ -40,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(cylindrical.frame_b,body.frame_a) annotation(Line(points = {{ -2,30},{20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(cylindrical.frame_b,axis.frame_a) annotation(Line(points = {{ -2,30},{4,30},{4,70},{10,70}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a.frame_a,cylindrical.frame_a) annotation(Line(points = {{ -30,0},{ -30,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a1.frame_a,cylindrical.frame_b) annotation(Line(points = {{10,0},{12,0},{12,30},{ -2,30}}, color = {0,0,0}, thickness = 0.5));
      end Cylindrical;
      model Universal
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(graphics));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow axis2(length = 0.5, color = {0,0,0}, diameter = 0.02, n = {0,1,0}, animation = false) annotation(Placement(transformation(extent = {{10,60},{30,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Universal universal(n_a = {0,0,1}, cylinderDiameter = 1 / 15, cylinderLength = 0.2, a_a(fixed = false), a_b(fixed = false), phi_a(fixed = true, start = 1.5707963267949), phi_b(fixed = true, start = 0.785398163397448), w_a(fixed = true), w_b(fixed = true)) annotation(Placement(transformation(extent = {{ -24,20},{ -4,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body(animation = false) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a(color_x = {0,128,255}) annotation(Placement(transformation(origin = { -30, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a1(color_x = {0,0,200}) annotation(Placement(transformation(origin = {10, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow axis1(length = 0.5, color = {0,0,0}, diameter = 0.02, n = {0,0,1}, animation = false) annotation(Placement(transformation(extent = {{ -34,60},{ -14,80}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,universal.frame_a) annotation(Line(points = {{ -40,30},{ -24,30}}, color = {0,0,0}, thickness = 0.5));
        connect(universal.frame_b,body.frame_a) annotation(Line(points = {{ -4,30},{20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(universal.frame_b,axis2.frame_a) annotation(Line(points = {{ -4,30},{4,30},{4,70},{10,70}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a.frame_a,universal.frame_a) annotation(Line(points = {{ -30,0},{ -30,30},{ -24,30}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a1.frame_a,universal.frame_b) annotation(Line(points = {{10,0},{12,0},{12,30},{ -4,30}}, color = {0,0,0}, thickness = 0.5));
        connect(universal.frame_a,axis1.frame_a) annotation(Line(points = {{ -24,30},{ -24,30},{ -24,56},{ -48,56},{ -48,70},{ -34,70}}, color = {0,0,0}, thickness = 0.5));
      end Universal;
      model Planar
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow axis2(length = 0.5, color = {0,0,0}, diameter = 0.02, n = {0,1,0}) annotation(Placement(transformation(extent = {{10,60},{30,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Planar planar(n = {0,1,0}, n_x = {0,0,1}, cylinderLength = 1 / 10, cylinderDiameter = 1 / 15, boxWidth = 0.4 * planar.cylinderDiameter, a_x(fixed = false), a_y(fixed = false), phi(fixed = true, start = 0.785398163397448), s_x(fixed = true, start = 0.5), s_y(fixed = true, start = 0.5), v_x(fixed = true), v_y(fixed = true), w(fixed = true), wd(fixed = false)) annotation(Placement(transformation(extent = {{ -22,20},{ -2,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body(animation = false) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a(color_x = {0,128,255}) annotation(Placement(transformation(origin = { -30, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a1(color_x = {0,0,200}) annotation(Placement(transformation(origin = {10, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow axis1(length = 0.5, color = {0,0,0}, diameter = 0.02, n = {0,0,1}, r_tail = {0,0,0.5}) annotation(Placement(transformation(extent = {{ -34,60},{ -14,80}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,planar.frame_a) annotation(Line(points = {{ -40,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(planar.frame_b,body.frame_a) annotation(Line(points = {{ -2,30},{20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(planar.frame_b,axis2.frame_a) annotation(Line(points = {{ -2,30},{4,30},{4,70},{10,70}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a.frame_a,planar.frame_a) annotation(Line(points = {{ -30,0},{ -30,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a1.frame_a,planar.frame_b) annotation(Line(points = {{10,0},{12,0},{12,30},{ -2,30}}, color = {0,0,0}, thickness = 0.5));
        connect(planar.frame_a,axis1.frame_a) annotation(Line(points = {{ -22,30},{ -24,30},{ -24,56},{ -48,56},{ -48,70},{ -34,70}}, color = {0,0,0}, thickness = 0.5));
      end Planar;
      model Spherical
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(graphics));
        Modelica.Mechanics.MultiBody.Joints.Spherical spherical(angles_start = {0.785398163397448,0.785398163397448,0.785398163397448}, angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false) annotation(Placement(transformation(extent = {{ -22,20},{ -2,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body(animation = false) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a(color_x = {0,128,255}) annotation(Placement(transformation(origin = { -30, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a1(color_x = {0,0,200}) annotation(Placement(transformation(origin = {10, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,spherical.frame_a) annotation(Line(points = {{ -40,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(spherical.frame_b,body.frame_a) annotation(Line(points = {{ -2,30},{20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a.frame_a,spherical.frame_a) annotation(Line(points = {{ -30,0},{ -30,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a1.frame_a,spherical.frame_b) annotation(Line(points = {{10,0},{12,0},{12,30},{ -2,30}}, color = {0,0,0}, thickness = 0.5));
      end Spherical;
      model FreeMotion
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Joints.FreeMotion freeMotion(angles_start = {0.785398163397448,0.785398163397448,0.785398163397448}, a_rel_a(fixed = false), angles_fixed = true, r_rel_a(fixed = true, start = {0.5,0.4,0}), v_rel_a(fixed = true), w_rel_a_fixed = true, z_rel_a_fixed = false) annotation(Placement(transformation(extent = {{ -22,20},{ -2,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body(animation = false) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a(color_x = {0,128,255}) annotation(Placement(transformation(origin = { -30, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a1(color_x = {0,0,200}) annotation(Placement(transformation(origin = {10, -10}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,freeMotion.frame_a) annotation(Line(points = {{ -40,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(freeMotion.frame_b,body.frame_a) annotation(Line(points = {{ -2,30},{20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a.frame_a,freeMotion.frame_a) annotation(Line(points = {{ -30,0},{ -30,30},{ -22,30}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a1.frame_a,freeMotion.frame_b) annotation(Line(points = {{10,0},{12,0},{12,30},{ -2,30}}, color = {0,0,0}, thickness = 0.5));
      end FreeMotion;
      model SphericalSpherical
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.SphericalSpherical sphericalSpherical(rodLength = {1,0.2,0} * {1,0.2,0}, m = 1) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        annotation(Diagram(graphics));
        Modelica.Mechanics.MultiBody.Joints.Prismatic Prismatic1(animation = false) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed1(r = {1,0.2,0}, animation = false) annotation(Placement(transformation(extent = {{80,20},{60,40}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,sphericalSpherical.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {0,0,0}));
        connect(sphericalSpherical.frame_b,Prismatic1.frame_a) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}));
        connect(Prismatic1.frame_b,Fixed1.frame_b) annotation(Line(points = {{40,30},{60,30}}, color = {0,0,0}));
      end SphericalSpherical;
      model JointUSP
        parameter Real d = 0.015;
        parameter Real rRod1_ia[3] = {1,0.3,0};
        parameter Real rRod2_ib[3] = { -0.5,0.2,0};
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed1(animation = false, r = {1.7,0.1,0}) annotation(Placement(transformation(extent = {{40,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUSP jointUSP(rRod1_ia = rRod1_ia, rRod2_ib = rRod2_ib) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n1_a(length = 0.5, color = {0,0,200}, n = {0,0,1}, diameter = d) annotation(Placement(transformation(extent = {{ -46,60},{ -26,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n2_ia(length = 0.5, n = jointUSP.e2_ia, diameter = d, color = {0,128,0}) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod1(diameter = d, r_tail = {0, -0.1,0}, n = rRod1_ia, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod1_ia)) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod2(diameter = d, r_tail = {0, -0.1,0}, n = rRod2_ib, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod2_ib)) annotation(Placement(transformation(extent = {{40, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow prism(diameter = d, r_tail = {0, -0.1,0}, n = { -1,0,0}, color = {255,0,0}, length = 0.2) annotation(Placement(transformation(extent = {{0, -60},{ -20, -40}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,jointUSP.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {0,0,0}));
        connect(jointUSP.frame_b,Fixed1.frame_b) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}));
        connect(jointUSP.frame_a,n1_a.frame_a) annotation(Line(points = {{ -20,30},{ -32,30},{ -32,54},{ -50,54},{ -50,70},{ -46,70}}, color = {0,0,0}));
        connect(n2_ia.frame_a,jointUSP.frame_ia) annotation(Line(points = {{ -20,70},{ -24,70},{ -24,46},{ -18,46},{ -18,40}}, color = {0,0,0}));
        connect(jointUSP.frame_ia,rRod1.frame_a) annotation(Line(points = {{ -18,40},{ -26,40},{ -26, -10},{ -20, -10}}, color = {0,0,0}));
        connect(rRod2.frame_a,jointUSP.frame_ib) annotation(Line(points = {{40, -10},{56, -10},{56,58},{ -2,58},{ -2,40}}, color = {0,0,0}));
        connect(prism.frame_a,jointUSP.frame_b) annotation(Line(points = {{0, -50},{10, -50},{10,30},{0,30}}, color = {0,0,0}));
      end JointUSP;
      model JointUPS
        parameter Real d = 0.015;
        parameter Real rRod1_ia[3] = {1,0.3,0};
        parameter Real rRod2_ib[3] = { -0.5,0.2,0};
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed1(animation = false, r = {1.7,0.1,0}) annotation(Placement(transformation(extent = {{40,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUPS jointUPS(nAxis_ia = rRod1_ia) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n1_a(length = 0.5, color = {0,0,200}, n = {0,0,1}, diameter = d) annotation(Placement(transformation(extent = {{ -46,60},{ -26,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n2_ia(length = 0.5, n = jointUPS.e2_ia, diameter = d, color = {0,128,0}) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod1(diameter = d, r_tail = {0, -0.1,0}, n = rRod1_ia, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod1_ia)) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,jointUPS.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {0,0,0}));
        connect(jointUPS.frame_b,Fixed1.frame_b) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}));
        connect(jointUPS.frame_a,n1_a.frame_a) annotation(Line(points = {{ -20,30},{ -32,30},{ -32,54},{ -50,54},{ -50,70},{ -46,70}}, color = {0,0,0}));
        connect(n2_ia.frame_a,jointUPS.frame_ia) annotation(Line(points = {{ -20,70},{ -24,70},{ -24,46},{ -18,46},{ -18,40}}, color = {0,0,0}));
        connect(jointUPS.frame_ia,rRod1.frame_a) annotation(Line(points = {{ -18,40},{ -26,40},{ -26, -10},{ -20, -10}}, color = {0,0,0}));
      end JointUPS;
      model JointSSR
        parameter Real d = 0.015;
        parameter Real rRod1_ia[3] = {1,0.3,0};
        parameter Real L = Modelica.Math.Vectors.length(rRod1_ia);
        parameter Real rRod2_ib[3] = { -0.5,0.2,0};
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed1(animation = false, r = {1.5,0.1,0}) annotation(Placement(transformation(extent = {{40,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointSSR jointSSR(rRod2_ib = rRod2_ib, rod1Mass = 1, rod1Length = L, revoluteDiameter = 0.05) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod2(diameter = d, n = rRod2_ib, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod2_ib), r_tail = {0.05,0.1,0}) annotation(Placement(transformation(extent = {{40, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow prism(diameter = d, color = {255,0,0}, length = 0.3, n = {0,0,1}) annotation(Placement(transformation(extent = {{0, -60},{ -20, -40}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,jointSSR.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {0,0,0}));
        connect(jointSSR.frame_b,Fixed1.frame_b) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}));
        connect(rRod2.frame_a,jointSSR.frame_ib) annotation(Line(points = {{40, -10},{56, -10},{56,58},{ -2,58},{ -2,40}}, color = {0,0,0}));
        connect(prism.frame_a,jointSSR.frame_b) annotation(Line(points = {{0, -50},{10, -50},{10,30},{0,30}}, color = {0,0,0}));
      end JointSSR;
      model JointUSR
        parameter Real d = 0.015;
        parameter Real rRod1_ia[3] = {1,0.3,0};
        parameter Real rRod2_ib[3] = { -0.5,0.2,0};
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed1(animation = false, r = {1.5,0.1,0}) annotation(Placement(transformation(extent = {{40,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointUSR jointUSR(rRod1_ia = rRod1_ia, rRod2_ib = rRod2_ib) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n1_a(length = 0.5, color = {0,0,200}, n = {0,0,1}, diameter = d) annotation(Placement(transformation(extent = {{ -46,60},{ -26,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n2_ia(length = 0.5, n = jointUSR.e2_ia, diameter = d, color = {0,128,0}) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod1(diameter = d, r_tail = {0, -0.1,0}, n = rRod1_ia, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod1_ia)) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod2(diameter = d, r_tail = {0, -0.1,0}, n = rRod2_ib, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod2_ib)) annotation(Placement(transformation(extent = {{40, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow prism(diameter = d, color = {255,0,0}, n = {0,0,1}, length = 0.3) annotation(Placement(transformation(extent = {{0, -60},{ -20, -40}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,jointUSR.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {0,0,0}));
        connect(jointUSR.frame_b,Fixed1.frame_b) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}));
        connect(jointUSR.frame_a,n1_a.frame_a) annotation(Line(points = {{ -20,30},{ -32,30},{ -32,54},{ -50,54},{ -50,70},{ -46,70}}, color = {0,0,0}));
        connect(n2_ia.frame_a,jointUSR.frame_ia) annotation(Line(points = {{ -20,70},{ -24,70},{ -24,46},{ -18,46},{ -18,40}}, color = {0,0,0}));
        connect(jointUSR.frame_ia,rRod1.frame_a) annotation(Line(points = {{ -18,40},{ -26,40},{ -26, -10},{ -20, -10}}, color = {0,0,0}));
        connect(rRod2.frame_a,jointUSR.frame_ib) annotation(Line(points = {{40, -10},{56, -10},{56,58},{ -2,58},{ -2,40}}, color = {0,0,0}));
        connect(prism.frame_a,jointUSR.frame_b) annotation(Line(points = {{0, -50},{10, -50},{10,30},{0,30}}, color = {0,0,0}));
      end JointUSR;
      model JointRRR
        parameter Real d = 0.015;
        parameter Real rRod1_ia[3] = {1,0.3,0};
        parameter Real rRod2_ib[3] = { -0.5,0.2,0};
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(graphics));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed1(animation = false, r = {1.5,0.1,0}) annotation(Placement(transformation(extent = {{40,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointRRR jointRRR(rRod1_ia = rRod1_ia, rRod2_ib = rRod2_ib) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n1_a(n = {0,0,1}, diameter = d, length = 0.4, color = {255,0,0}) annotation(Placement(transformation(extent = {{ -46,60},{ -26,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod1(diameter = d, r_tail = {0, -0.1,0}, n = rRod1_ia, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod1_ia)) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod2(diameter = d, r_tail = {0, -0.1,0}, n = rRod2_ib, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod2_ib)) annotation(Placement(transformation(extent = {{40, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow prism(diameter = d, n = {0,0,1}, length = 0.4, color = {255,0,0}) annotation(Placement(transformation(extent = {{0, -60},{ -20, -40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n1_a1(n = {0,0,1}, diameter = d, length = 0.4, color = {255,0,0}) annotation(Placement(transformation(extent = {{ -10,66},{10,86}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,jointRRR.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {0,0,0}));
        connect(jointRRR.frame_b,Fixed1.frame_b) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}));
        connect(jointRRR.frame_a,n1_a.frame_a) annotation(Line(points = {{ -20,30},{ -32,30},{ -32,54},{ -50,54},{ -50,70},{ -46,70}}, color = {0,0,0}));
        connect(jointRRR.frame_ia,rRod1.frame_a) annotation(Line(points = {{ -18,40},{ -26,40},{ -26, -10},{ -20, -10}}, color = {0,0,0}));
        connect(rRod2.frame_a,jointRRR.frame_ib) annotation(Line(points = {{40, -10},{56, -10},{56,58},{ -2,58},{ -2,40}}, color = {0,0,0}));
        connect(prism.frame_a,jointRRR.frame_b) annotation(Line(points = {{0, -50},{10, -50},{10,30},{0,30}}, color = {0,0,0}));
        connect(n1_a1.frame_a,jointRRR.frame_im) annotation(Line(points = {{ -10,76},{ -10,76},{ -10,40}}, color = {0,0,0}, thickness = 0.5));
      end JointRRR;
      model JointRRP
        parameter Real d = 0.015;
        parameter Real rRod1_ia[3] = {1,0.3,0};
        parameter Real rRod2_ib[3] = { -0.5,0.2,0};
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(graphics));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed1(animation = false, r = {1.7,0.1,0}) annotation(Placement(transformation(extent = {{40,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointRRP jointRRP(rRod1_ia = rRod1_ia, rRod2_ib = rRod2_ib) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n1_a(n = {0,0,1}, diameter = d, length = 0.4, color = {255,0,0}) annotation(Placement(transformation(extent = {{ -46,60},{ -26,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow n2_ia(diameter = d, n = jointRRP.e_im, length = 0.4, color = {255,0,0}) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod1(diameter = d, r_tail = {0, -0.1,0}, n = rRod1_ia, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod1_ia)) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod2(diameter = d, r_tail = {0, -0.1,0}, n = rRod2_ib, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod2_ib)) annotation(Placement(transformation(extent = {{40, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow prism(diameter = d, r_tail = {0, -0.1,0}, n = { -1,0,0}, color = {255,0,0}, length = 0.4) annotation(Placement(transformation(extent = {{0, -60},{ -20, -40}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,jointRRP.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {0,0,0}));
        connect(jointRRP.frame_b,Fixed1.frame_b) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}));
        connect(jointRRP.frame_a,n1_a.frame_a) annotation(Line(points = {{ -20,30},{ -32,30},{ -32,54},{ -50,54},{ -50,70},{ -46,70}}, color = {0,0,0}));
        connect(jointRRP.frame_ia,rRod1.frame_a) annotation(Line(points = {{ -18,40},{ -26,40},{ -26, -10},{ -20, -10}}, color = {0,0,0}));
        connect(rRod2.frame_a,jointRRP.frame_ib) annotation(Line(points = {{40, -10},{56, -10},{56,58},{ -2,58},{ -2,40}}, color = {0,0,0}));
        connect(prism.frame_a,jointRRP.frame_b) annotation(Line(points = {{0, -50},{10, -50},{10,30},{0,30}}, color = {0,0,0}));
        connect(jointRRP.frame_im,n2_ia.frame_a) annotation(Line(points = {{ -10,40},{ -10,55.5},{ -20,55.5},{ -20,70}}, color = {0,0,0}, thickness = 0.5));
      end JointRRP;
      model JointSSP
        parameter Real d = 0.015;
        parameter Real rRod1_ia[3] = {1,0.3,0};
        parameter Real L = Modelica.Math.Vectors.length(rRod1_ia);
        parameter Real rRod2_ib[3] = { -0.52,0.2,0};
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        annotation(Diagram(graphics));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed1(animation = false, r = {1.5,0.1,0}) annotation(Placement(transformation(extent = {{40,20},{20,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Assemblies.JointSSP jointSSP(rRod2_ib = rRod2_ib, rod1Mass = 1, rod1Length = L, n_b = {0,0,1}, s_guess =  -10) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow rRod2(diameter = d, n = rRod2_ib, color = {0,0,0}, length = Modelica.Math.Vectors.length(rRod2_ib), r_tail = {0.05,0.1,0}) annotation(Placement(transformation(extent = {{40, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow prism(diameter = d, color = {255,0,0}, length = 0.3, n = {0,0,1}) annotation(Placement(transformation(extent = {{0, -60},{ -20, -40}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,jointSSP.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {0,0,0}));
        connect(jointSSP.frame_b,Fixed1.frame_b) annotation(Line(points = {{0,30},{20,30}}, color = {0,0,0}));
        connect(rRod2.frame_a,jointSSP.frame_ib) annotation(Line(points = {{40, -10},{56, -10},{56,58},{ -2,58},{ -2,40}}, color = {0,0,0}));
        connect(prism.frame_a,jointSSP.frame_b) annotation(Line(points = {{0, -50},{10, -50},{10,30},{0,30}}, color = {0,0,0}));
      end JointSSP;
    end Joints;
    package Parts "Test MultiBody.Parts"
      model FixedTranslation
        import SI = Modelica.SIunits;
        import Modelica.Mechanics.MultiBody.*;
        extends Modelica.Icons.Example;
        parameter SI.Length length = 0.5 "Length of axes of frames";
        parameter SI.Diameter diameter = length / 30 "Diameter of frame axes";
        annotation(experiment(StopTime = 1), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {1,1}), graphics));
        Modelica.Mechanics.MultiBody.Frames.Orientation R;
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation fixedTranslation(r = {1,0.5,0}) annotation(Placement(transformation(extent = {{ -40,40},{ -20,60}}, rotation = 0)));
        Visualizers.FixedFrame frameT1(length = length, diameter = diameter) annotation(Placement(transformation(extent = {{ -60,60},{ -80,80}}, rotation = 0)));
        Visualizers.FixedFrame frameT2(length = length, diameter = diameter) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed fixed1(animation = false) annotation(Placement(transformation(extent = {{ -80,20},{ -60,40}}, rotation = 0)));
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, gravityType = 0) annotation(Placement(transformation(extent = {{20,0},{40,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedArrow arrow(n = {1,0.5,0}, color = {0,0,255}, r_tail = {0.03,0.1,0}, length = 1.05, diameter = 0.02) annotation(Placement(transformation(extent = {{ -40,20},{ -20,40}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        R = Modelica.Mechanics.MultiBody.Frames.nullRotation();
        connect(frameT1.frame_a,fixedTranslation.frame_a) annotation(Line(points = {{ -60,70},{ -50,70},{ -50,50},{ -40,50}}));
        connect(fixed1.frame_b,fixedTranslation.frame_a) annotation(Line(points = {{ -60,30},{ -50,30},{ -50,50},{ -40,50}}));
        connect(fixedTranslation.frame_b,frameT2.frame_a) annotation(Line(points = {{ -20,50},{0,50}}));
        connect(arrow.frame_a,fixed1.frame_b) annotation(Line(points = {{ -40,30},{ -60,30}}, color = {0,0,0}, thickness = 0.5));
      end FixedTranslation;
      encapsulated model BodyShape "Simple spring/damper/mass system"
        import Modelica.Icons;
        import Modelica.Mechanics.MultiBody;
        import Modelica.Mechanics.Rotational;
        import Modelica;
        extends Icons.Example;
        parameter Boolean animation = true "= true, if animation shall be enabled";
        annotation(experiment(StopTime = 10), Window(x = 0.29, y = 0, width = 0.71, height = 0.85), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {2,2}), graphics), Documentation(info = "<html>
<p>
This is the same example as \"FreeBody\". The only difference
is that with the <b>FreeMotion</b> joint explicitly 6 degrees of
freedom are introduced. The advantage is that <b>no non-linear system
of equations</b> occurs any more, because the FreeMotion joint is
described by a set of <b>non-redundant</b> variables. The disadvantage is
that there is an orientation for which this description is singular
(see description of FreeMotion joint). In technical systems it is
often possible to use the FreeMotion joint such that the singularity
</p>
</html>"));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -60,40},{ -40,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation bar2(r = {0.8,0,0}, animation = false) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Spring spring1(width = 0.1, coilWidth = 0.005, numberOfWindings = 5, c = 20, s_unstretched = 0) annotation(Placement(transformation(origin = { -24,26}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Parts.BodyShape body(m = 1, I_11 = 1, I_22 = 1, I_33 = 1, r = {0.4,0,0}, r_CM = {0.2,0,0}, width = 0.05) annotation(Placement(transformation(extent = {{0, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Forces.Spring spring2(c = 20, s_unstretched = 0, width = 0.1, coilWidth = 0.005, numberOfWindings = 5) annotation(Placement(transformation(origin = {42,26}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Joints.FreeMotion freeMotion(arrowDiameter = 0.04, r_rel_a(start = {0.2, -0.5,0.1})) annotation(Placement(transformation(extent = {{ -30, -40},{ -10, -20}}, rotation = 0)));

      equation 
        connect(bar2.frame_a,world.frame_b) annotation(Line(points = {{0,50},{ -40,50}}, color = {0,0,0}, thickness = 0.5));
        connect(spring1.frame_b,body.frame_a) annotation(Line(points = {{ -24,16},{ -24, -10},{0, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(spring2.frame_b,body.frame_b) annotation(Line(points = {{42,16},{20, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(bar2.frame_b,spring2.frame_a) annotation(Line(points = {{20,50},{42,50},{42,36}}, color = {0,0,0}, thickness = 0.5));
        connect(spring1.frame_a,world.frame_b) annotation(Line(points = {{ -24,36},{ -24,50},{ -40,50}}, color = {0,0,0}, thickness = 0.5));
        connect(world.frame_b,freeMotion.frame_a) annotation(Line(points = {{ -40,50},{ -34,50},{ -34, -30},{ -30, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(freeMotion.frame_b,body.frame_a) annotation(Line(points = {{ -10, -30},{ -6, -30},{ -6, -10},{0, -10}}, color = {0,0,0}, thickness = 0.5));
      end BodyShape;
      model PointMass "Test Modelica.Mechanics.MultiBody.Parts.PointMass"
        extends Modelica.Icons.Example;
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation fixedTranslation(r = {1,0,0}) annotation(Placement(transformation(extent = {{20,20},{40,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));
        Modelica.Mechanics.MultiBody.Parts.PointMass pointMass(m = 5) annotation(Placement(transformation(extent = {{60,20},{80,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute rev(a(fixed = false), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        annotation(experiment(StopTime = 1));

      equation 
        connect(fixedTranslation.frame_b,pointMass.frame_a) annotation(Line(points = {{40,30},{70,30}}, color = {95,95,95}, thickness = 0.5));
        connect(world.frame_b,rev.frame_a) annotation(Line(points = {{ -40,30},{ -20,30}}, color = {95,95,95}, thickness = 0.5));
        connect(rev.frame_b,fixedTranslation.frame_a) annotation(Line(points = {{0,30},{20,30}}, color = {95,95,95}, thickness = 0.5));
      end PointMass;
      model Bodies
        import SI = Modelica.SIunits;
        extends Modelica.Icons.Example;
        Modelica.Mechanics.MultiBody.Parts.Body body2(m = 1, I_11 = 1, I_22 = 1, I_33 = 1, r_0(start = {0.8,0.2,0})) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyShape bodyShape(m = 1, I_11 = 1, I_22 = 1, I_33 = 1, r_CM = {0.3,0,0}, r = {0.6,0,0}, width = 0.05) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox BodyBox1(r = {1,0,0}) annotation(Placement(transformation(extent = {{ -20, -60},{0, -40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder bodyCylinder(r = {1,0,0}, innerDiameter = bodyCylinder.diameter / 2) annotation(Placement(transformation(extent = {{ -20, -100},{0, -80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed3(animation = false, r = {0, -0.3,0}) annotation(Placement(transformation(extent = {{ -80, -20},{ -60,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed4(animation = false, r = {0, -0.6,0}) annotation(Placement(transformation(extent = {{ -80, -60},{ -60, -40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed5(animation = false, r = {0, -0.8,0}) annotation(Placement(transformation(extent = {{ -80, -100},{ -60, -80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body1(m = 1, I_11 = 1, I_22 = 1, I_33 = 1, r_CM = {0.3,0,0}, r_0(start = {0.8,0.2,0})) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed1(animation = false, r = {0,0.2,0}) annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed Fixed2(animation = false, r = {0,0,0}) annotation(Placement(transformation(extent = {{ -80,20},{ -60,40}}, rotation = 0)));
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{40,0},{60,20}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        connect(Fixed3.frame_b,bodyShape.frame_a) annotation(Line(points = {{ -60, -10},{ -20, -10}}));
        connect(Fixed4.frame_b,BodyBox1.frame_a) annotation(Line(points = {{ -60, -50},{ -20, -50}}));
        connect(Fixed5.frame_b,bodyCylinder.frame_a) annotation(Line(points = {{ -60, -90},{ -20, -90}}));
        connect(Fixed1.frame_b,body1.frame_a) annotation(Line(points = {{ -60,70},{ -20,70}}));
        connect(Fixed2.frame_b,body2.frame_a) annotation(Line(points = {{ -60,30},{ -20,30}}));
      end Bodies;
      package Rotor1D
        model Rotor1D_1
          annotation(Diagram(graphics), experiment(StopTime = 5, Tolerance = 1e-08));
          inner Modelica.Mechanics.MultiBody.World world(driveTrainMechanics3D = true) annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Joints.Spherical spherical1(angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false) annotation(Placement(transformation(extent = {{ -70,20},{ -50,40}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.BodyCylinder bodyCylinder1(r = {0.25,0,0}, diameter = 0.05) annotation(Placement(transformation(extent = {{ -44,20},{ -24,40}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.FixedRotation fixedRotation1(angle = 45, n = {0,1,0}) annotation(Placement(transformation(extent = {{ -16,20},{4,40}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Joints.Revolute revolute(n = {1,0,0}, a(fixed = false), phi(fixed = true), w(fixed = true, start = 8.72664625997165)) annotation(Placement(transformation(extent = {{14,20},{34,40}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.FixedTranslation fixedTranslation(r = { -0.1,0,0}) annotation(Placement(transformation(extent = {{42,20},{62,40}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.BodyCylinder bodyCylinder2(diameter = 0.1, r = {0.2,0,0}) annotation(Placement(transformation(extent = {{70,20},{90,40}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Fixed fixed annotation(Placement(transformation(extent = {{ -100, -40},{ -80, -20}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Joints.Spherical spherical2(angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false) annotation(Placement(transformation(extent = {{ -70, -40},{ -50, -20}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.BodyCylinder bodyCylinder3(r = {0.25,0,0}, diameter = 0.05, color = {0,128,0}) annotation(Placement(transformation(extent = {{ -44, -40},{ -24, -20}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.FixedRotation fixedRotation2(n = {0,1,0}, angle = 45) annotation(Placement(transformation(extent = {{ -16, -40},{4, -20}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.FixedTranslation fixedTranslation1(r = { -0.1,0,0}) annotation(Placement(transformation(extent = {{24, -40},{44, -20}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.BodyCylinder bodyCylinder4(diameter = 0.1, r = {0.2,0,0}, color = {0,128,0}) annotation(Placement(transformation(extent = {{56, -40},{76, -20}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D(J = bodyCylinder4.I[1,1], n = {1,0,0}, a(fixed = false), phi(fixed = true), w(fixed = true, start = 8.72664625997165)) annotation(Placement(transformation(extent = {{28, -70},{48, -50}}, rotation = 0)));

        equation 
          connect(world.frame_b,spherical1.frame_a) annotation(Line(points = {{ -80,30},{ -70,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(spherical1.frame_b,bodyCylinder1.frame_a) annotation(Line(points = {{ -50,30},{ -44,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(bodyCylinder1.frame_b,fixedRotation1.frame_a) annotation(Line(points = {{ -24,30},{ -16,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(fixedRotation1.frame_b,revolute.frame_a) annotation(Line(points = {{4,30},{14,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(revolute.frame_b,fixedTranslation.frame_a) annotation(Line(points = {{34,30},{42,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(fixedTranslation.frame_b,bodyCylinder2.frame_a) annotation(Line(points = {{62,30},{70,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(spherical2.frame_b,bodyCylinder3.frame_a) annotation(Line(points = {{ -50, -30},{ -44, -30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(bodyCylinder3.frame_b,fixedRotation2.frame_a) annotation(Line(points = {{ -24, -30},{ -16, -30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(fixed.frame_b,spherical2.frame_a) annotation(Line(points = {{ -80, -30},{ -70, -30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(fixedTranslation1.frame_b,bodyCylinder4.frame_a) annotation(Line(points = {{44, -30},{56, -30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(fixedRotation2.frame_b,fixedTranslation1.frame_a) annotation(Line(points = {{4, -30},{24, -30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(rotor1D.frame_a,fixedRotation2.frame_b) annotation(Line(points = {{38, -70},{38, -76},{10, -76},{10, -30},{4, -30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        end Rotor1D_1;
        model Rotor1D_2
          Modelica.Mechanics.MultiBody.Parts.BodyShape bodyCylinder(r = {0.5,0,0}, m = 0, I_11 = 2, I_22 = 0, I_33 = 0, shapeType = "cylinder", width = 0.1, animateSphere = false, r_shape = {0.1,0,0}) annotation(Placement(transformation(extent = {{ -12,20},{8,40}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Joints.Revolute revolute(n = {1,0,0}, a(fixed = false), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{ -46,20},{ -26,40}}, rotation = 0)));
          inner Modelica.Mechanics.MultiBody.World world(g = 0, driveTrainMechanics3D = true) annotation(Placement(transformation(extent = {{ -80,20},{ -60,40}}, rotation = 0)));
          annotation(Diagram(graphics), experiment(StopTime = 1.1));
          Modelica.Mechanics.MultiBody.Forces.Torque torque(resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve) annotation(Placement(transformation(extent = {{ -12,50},{8,70}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine[3](amplitude = {1,0,0}) annotation(Placement(transformation(extent = {{ -100,80},{ -80,100}}, rotation = 0)));
          inner Modelica.Mechanics.MultiBody.Parts.Fixed fixed annotation(Placement(transformation(extent = {{ -82, -70},{ -62, -50}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D(J = 2) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Sources.Torque torque1(useSupport = true) annotation(Placement(transformation(extent = {{ -52, -20},{ -32,0}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Mounting1D mounting1D annotation(Placement(transformation(extent = {{ -66, -40},{ -46, -20}}, rotation = 0)));

        equation 
          connect(world.frame_b,revolute.frame_a) annotation(Line(points = {{ -60,30},{ -46,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(revolute.frame_b,bodyCylinder.frame_a) annotation(Line(points = {{ -26,30},{ -12,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(torque.frame_b,bodyCylinder.frame_b) annotation(Line(points = {{8,60},{18,60},{18,30},{8,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(torque.frame_resolve,world.frame_b) annotation(Line(points = {{2,70},{2,84},{ -50,84},{ -50,30},{ -60,30}}, color = {95,95,95}, pattern = LinePattern.Dot, smooth = Smooth.None));
          connect(torque.frame_a,world.frame_b) annotation(Line(points = {{ -12,60},{ -50,60},{ -50,30},{ -60,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(sine.y,torque.torque) annotation(Line(points = {{ -79,90},{ -8,90},{ -8,72}}, color = {0,0,127}, smooth = Smooth.None));
          connect(fixed.frame_b,rotor1D.frame_a) annotation(Line(points = {{ -62, -60},{ -10, -60},{ -10, -20}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(torque1.flange,rotor1D.flange_a) annotation(Line(points = {{ -32, -10},{ -20, -10}}, color = {0,0,0}, smooth = Smooth.None));
          connect(mounting1D.flange_b,torque1.support) annotation(Line(points = {{ -46, -30},{ -42, -30},{ -42, -20}}, color = {0,0,0}, smooth = Smooth.None));
          connect(mounting1D.frame_a,fixed.frame_b) annotation(Line(points = {{ -56, -40},{ -56, -60},{ -62, -60}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(sine[1].y,torque1.tau) annotation(Line(points = {{ -79,90},{ -70,90},{ -70,60},{ -92,60},{ -92, -10},{ -54, -10}}, color = {0,0,127}, smooth = Smooth.None));
        end Rotor1D_2;
        model Rotor1D_3
          Modelica.Mechanics.MultiBody.Parts.BodyShape bodyCylinder(r = {0.5,0,0}, m = 0, I_11 = 2, I_22 = 0, I_33 = 0, shapeType = "cylinder", width = 0.1, animateSphere = false, r_shape = {0.1,0,0}) annotation(Placement(transformation(extent = {{50,0},{70,20}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Joints.Revolute revolute(n = {1,0,0}, a(fixed = false), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{16,0},{36,20}}, rotation = 0)));
          inner Modelica.Mechanics.MultiBody.World world(g = 0, driveTrainMechanics3D = true) annotation(Placement(transformation(extent = {{ -84,0},{ -64,20}}, rotation = 0)));
          annotation(Diagram(graphics), experiment(StopTime = 1.1));
          Modelica.Mechanics.MultiBody.Forces.Torque torque(resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_resolve) annotation(Placement(transformation(extent = {{50,30},{70,50}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine1[3](amplitude = {1,0,0}) annotation(Placement(transformation(extent = {{16,60},{36,80}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D(J = 2) annotation(Placement(transformation(extent = {{50, -46},{70, -26}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Sources.Torque torque1(useSupport = true) annotation(Placement(transformation(extent = {{18, -46},{38, -26}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Mounting1D mounting1D annotation(Placement(transformation(extent = {{4, -66},{24, -46}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Joints.Revolute r1(n = {0,1,0}, useAxisFlange = true) annotation(Placement(transformation(extent = {{ -32,0},{ -12,20}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Sources.Position position1(useSupport = true) annotation(Placement(transformation(extent = {{ -46,50},{ -26,70}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine2(amplitude = 2) annotation(Placement(transformation(extent = {{ -100,50},{ -80,70}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Mounting1D mounting1D1 annotation(Placement(transformation(extent = {{ -60,24},{ -40,44}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Joints.Revolute r2(n = {0,1,0}, useAxisFlange = true) annotation(Placement(transformation(extent = {{ -38, -90},{ -18, -70}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Sources.Position position2(useSupport = true) annotation(Placement(transformation(extent = {{ -52, -40},{ -32, -20}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Mounting1D mounting1D2 annotation(Placement(transformation(extent = {{ -66, -66},{ -46, -46}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Fixed fixed annotation(Placement(transformation(extent = {{ -86, -90},{ -66, -70}}, rotation = 0)));

        equation 
          connect(revolute.frame_b,bodyCylinder.frame_a) annotation(Line(points = {{36,10},{50,10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(torque.frame_b,bodyCylinder.frame_b) annotation(Line(points = {{70,40},{80,40},{80,10},{70,10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(sine1.y,torque.torque) annotation(Line(points = {{37,70},{54,70},{54,52}}, color = {0,0,127}, smooth = Smooth.None));
          connect(torque1.flange,rotor1D.flange_a) annotation(Line(points = {{38, -36},{50, -36}}, color = {0,0,0}, smooth = Smooth.None));
          connect(mounting1D.flange_b,torque1.support) annotation(Line(points = {{24, -56},{28, -56},{28, -46}}, color = {0,0,0}, smooth = Smooth.None));
          connect(r1.frame_a,world.frame_b) annotation(Line(points = {{ -32,10},{ -64,10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(position1.flange,r1.axis) annotation(Line(points = {{ -26,60},{ -22,60},{ -22,20}}, color = {0,0,0}, smooth = Smooth.None));
          connect(position1.support,mounting1D1.flange_b) annotation(Line(points = {{ -36,50},{ -36,34},{ -40,34}}, color = {0,0,0}, smooth = Smooth.None));
          connect(mounting1D1.frame_a,world.frame_b) annotation(Line(points = {{ -50,24},{ -50,10},{ -64,10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(sine2.y,position1.phi_ref) annotation(Line(points = {{ -79,60},{ -48,60}}, color = {0,0,127}, smooth = Smooth.None));
          connect(r1.frame_b,revolute.frame_a) annotation(Line(points = {{ -12,10},{16,10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(torque.frame_resolve,revolute.frame_a) annotation(Line(points = {{64,50},{8,50},{8,10},{16,10}}, color = {95,95,95}, pattern = LinePattern.Dot, smooth = Smooth.None));
          connect(torque.frame_a,revolute.frame_a) annotation(Line(points = {{50,40},{8,40},{8,10},{16,10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(position2.flange,r2.axis) annotation(Line(points = {{ -32, -30},{ -28, -30},{ -28, -70}}, color = {0,0,0}, smooth = Smooth.None));
          connect(position2.support,mounting1D2.flange_b) annotation(Line(points = {{ -42, -40},{ -42, -56},{ -46, -56}}, color = {0,0,0}, smooth = Smooth.None));
          connect(fixed.frame_b,r2.frame_a) annotation(Line(points = {{ -66, -80},{ -38, -80}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(fixed.frame_b,mounting1D2.frame_a) annotation(Line(points = {{ -66, -80},{ -56, -80},{ -56, -66}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(sine2.y,position2.phi_ref) annotation(Line(points = {{ -79,60},{ -70,60},{ -70,36},{ -92,36},{ -92, -30},{ -54, -30}}, color = {0,0,127}, smooth = Smooth.None));
          connect(r2.frame_b,rotor1D.frame_a) annotation(Line(points = {{ -18, -80},{60, -80},{60, -46}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(r2.frame_b,mounting1D.frame_a) annotation(Line(points = {{ -18, -80},{14, -80},{14, -66}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(sine1[1].y,torque1.tau) annotation(Line(points = {{37,70},{92,70},{92, -20},{0, -20},{0, -36},{16, -36}}, color = {0,0,127}, smooth = Smooth.None));
        end Rotor1D_3;
        model GearConstraint
          Modelica.Mechanics.MultiBody.Joints.GearConstraint gearConstraint(ratio = 10) annotation(Placement(transformation(extent = {{34,40},{54,60}}, rotation = 0)));
          inner Modelica.Mechanics.MultiBody.World world(g = 0, driveTrainMechanics3D = true) annotation(Placement(transformation(extent = {{ -62,10},{ -42,30}}, rotation = 0)));
          annotation(Diagram(graphics), experiment(StopTime = 5), experimentSetupOutput);
          Modelica.Mechanics.MultiBody.Parts.BodyCylinder cyl1(diameter = 0.1, color = {0,128,0}, r = {0.4,0,0}) annotation(Placement(transformation(extent = {{2,40},{22,60}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.BodyCylinder cyl2(r = {0.4,0,0}, diameter = 0.2) annotation(Placement(transformation(extent = {{70,40},{90,60}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Forces.Torque torque1(resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameAB.frame_b) annotation(Placement(transformation(extent = {{ -26,40},{ -6,60}}, rotation = 0)));
          Modelica.Blocks.Sources.Sine sine[3](amplitude = {2,0,0}) annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Fixed fixed annotation(Placement(transformation(extent = {{ -48, -90},{ -28, -70}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Components.Inertia inertia1(J = cyl1.I[1,1], a(fixed = false), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{ -20, -40},{0, -20}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Components.IdealGear idealGear(ratio = 10, useSupport = true) annotation(Placement(transformation(extent = {{12, -40},{32, -20}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Components.Inertia inertia2(J = cyl2.I[1,1]) annotation(Placement(transformation(extent = {{44, -40},{64, -20}}, rotation = 0)));
          Modelica.Mechanics.Rotational.Sources.Torque torque2(useSupport = true) annotation(Placement(transformation(extent = {{ -48, -40},{ -28, -20}}, rotation = 0)));
          Modelica.Mechanics.MultiBody.Parts.Mounting1D mounting1D annotation(Placement(transformation(extent = {{ -20, -70},{0, -50}}, rotation = 0)));

        equation 
          connect(world.frame_b,gearConstraint.bearing) annotation(Line(points = {{ -42,20},{44,20},{44,40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(cyl1.frame_b,gearConstraint.frame_a) annotation(Line(points = {{22,50},{34,50}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(gearConstraint.frame_b,cyl2.frame_a) annotation(Line(points = {{54,50},{70,50}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(torque1.frame_b,cyl1.frame_a) annotation(Line(points = {{ -6,50},{2,50}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(torque1.frame_a,world.frame_b) annotation(Line(points = {{ -26,50},{ -36,50},{ -36,20},{ -42,20}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
          connect(sine.y,torque1.torque) annotation(Line(points = {{ -79,70},{ -22,70},{ -22,62}}, color = {0,0,127}, smooth = Smooth.None));
          connect(inertia1.flange_b,idealGear.flange_a) annotation(Line(points = {{0, -30},{12, -30}}, color = {0,0,0}, smooth = Smooth.None));
          connect(idealGear.flange_b,inertia2.flange_a) annotation(Line(points = {{32, -30},{44, -30}}, color = {0,0,0}, smooth = Smooth.None));
          connect(torque2.flange,inertia1.flange_a) annotation(Line(points = {{ -28, -30},{ -20, -30}}, color = {0,0,0}, smooth = Smooth.None));
          connect(sine[1].y,torque2.tau) annotation(Line(points = {{ -79,70},{ -72,70},{ -72, -30},{ -50, -30}}, color = {0,0,127}, smooth = Smooth.None));
          connect(mounting1D.flange_b,idealGear.support) annotation(Line(points = {{0, -60},{22, -60},{22, -40}}, color = {0,0,0}, smooth = Smooth.None));
          connect(mounting1D.flange_b,torque2.support) annotation(Line(points = {{0, -60},{4, -60},{4, -48},{ -38, -48},{ -38, -40}}, color = {0,0,0}, smooth = Smooth.None));
          connect(fixed.frame_b,mounting1D.frame_a) annotation(Line(points = {{ -28, -80},{ -10, -80},{ -10, -70}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        end GearConstraint;
      end Rotor1D;
    end Parts;
    package Sensors "Test MultiBody.Sensors"
      encapsulated model AbsoluteSensor "Simple pendulum with one revolute joint and one body"
        import Modelica;
        import Modelica.Mechanics.MultiBody;
        import ObsoleteModelica3;
        extends Modelica.Icons.Example;
        annotation(experiment(StopTime = 5), Window(x = 0.29, y = 0, width = 0.71, height = 0.85), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {2,2}), graphics), Documentation(info = ""));
        inner Modelica.Mechanics.MultiBody.World world(gravityType = Modelica.Mechanics.MultiBody.Types.GravityTypes.UniformGravity) annotation(Placement(transformation(extent = {{ -80,0},{ -60,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute rev(n = {0,0,1}, useAxisFlange = true, a(fixed = false), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{ -40,0},{ -20,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Damper damper(d = 0.1) annotation(Placement(transformation(extent = {{ -40,40},{ -20,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox box(r = {1,0,0}, animation = false) annotation(Placement(transformation(extent = {{0,0},{20,20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.AbsoluteSensor sensor_frame_a1(resolveInFrame_a = true, get_r_abs = true, get_v_abs = true, get_a_abs = true, get_w_abs = true, get_z_abs = true, get_angles = true) annotation(Placement(transformation(extent = {{40,22},{60,42}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.AbsoluteSensor sensor_world1(get_r_abs = true, get_v_abs = true, get_a_abs = true, get_w_abs = true, get_z_abs = true, resolveInFrame_a = false, get_angles = true) annotation(Placement(transformation(extent = {{40, -20},{60,0}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.AbsoluteSensor sensor_frame_a2(get_r_abs = true, get_v_abs = true, get_a_abs = true, get_w_abs = true, get_z_abs = true, resolveInFrame_a = false, get_angles = true) annotation(Placement(transformation(extent = {{40,60},{60,80}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.AbsoluteSensor sensor_world2(get_r_abs = true, get_v_abs = true, get_a_abs = true, get_w_abs = true, get_z_abs = true, resolveInFrame_a = true, get_angles = true) annotation(Placement(transformation(extent = {{40, -40},{60, -60}}, rotation = 0)));
        Modelica.Blocks.Math.Add err1[18](each k2 =  -1) annotation(Placement(transformation(extent = {{80,40},{100,60}}, rotation = 0)));
        Modelica.Blocks.Math.Add err2[18](each k2 =  -1) annotation(Placement(transformation(extent = {{80, -40},{100, -20}}, rotation = 0)));

      equation 
        connect(world.frame_b,rev.frame_a) annotation(Line(points = {{ -60,10},{ -40,10}}, color = {0,0,0}, thickness = 0.5));
        connect(damper.flange_b,rev.axis) annotation(Line(points = {{ -20,50},{ -16,50},{ -16,26},{ -30,26},{ -30,20}}, color = {0,0,0}));
        connect(rev.support,damper.flange_a) annotation(Line(points = {{ -36,20},{ -36,26},{ -48,26},{ -48,50},{ -40,50}}, color = {0,0,0}));
        connect(rev.frame_b,box.frame_a) annotation(Line(points = {{ -20,10},{0,10}}, color = {0,0,0}, thickness = 0.5));
        connect(box.frame_b,sensor_frame_a1.frame_a) annotation(Line(points = {{20,10},{30,10},{30,32},{40,32}}, color = {0,0,0}, thickness = 0.5));
        connect(box.frame_b,sensor_world1.frame_a) annotation(Line(points = {{20,10},{30,10},{30, -10},{40, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(box.frame_b,sensor_frame_a2.frame_a) annotation(Line(points = {{20,10},{30,10},{30,70},{40,70}}, color = {0,0,0}, thickness = 0.5));
        connect(box.frame_b,sensor_world2.frame_a) annotation(Line(points = {{20,10},{30,10},{30, -50},{40, -50}}, color = {0,0,0}, thickness = 0.5));
        connect(sensor_frame_a2.y,err1.u1) annotation(Line(points = {{61,70},{68,70},{68,56},{78,56}}, color = {0,0,255}));
        connect(sensor_frame_a1.y,err1.u2) annotation(Line(points = {{61,32},{68,32},{68,44},{78,44}}, color = {0,0,255}));
        connect(sensor_world1.y,err2.u1) annotation(Line(points = {{61, -10},{68, -10},{68, -24},{78, -24}}, color = {0,0,255}));
        connect(sensor_world2.y,err2.u2) annotation(Line(points = {{61, -50},{70, -50},{70, -36},{78, -36}}, color = {0,0,255}));
        connect(sensor_world2.frame_resolve,world.frame_b) annotation(Line(points = {{50, -60},{50, -76},{ -48, -76},{ -48,10},{ -60,10}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(sensor_frame_a2.frame_resolve,rev.frame_b) annotation(Line(points = {{50,80},{50,80},{50,94},{ -12,94},{ -12,10},{ -20,10}}, color = {0,0,0}, pattern = LinePattern.Dot));
      end AbsoluteSensor;
      model AbsoluteSensor2
        extends Modelica.Icons.Example;
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = true, animateGravity = true) annotation(Placement(transformation(extent = {{ -80, -20},{ -60,0}}, rotation = 0)));
        annotation(Diagram(graphics), experiment(StopTime = 1.1));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.AbsoluteSensor freeMotion annotation(Placement(transformation(extent = {{0, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation fixedRotation(r = {0.5,0.5,0.1}, rotationType = Modelica.Mechanics.MultiBody.Types.RotationTypes.PlanarRotationSequence, angles = {45,45,45}, animation = false) annotation(Placement(transformation(extent = {{ -40, -20},{ -20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_a(color_x = {0,128,255}) annotation(Placement(transformation(origin = { -10, -50}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,fixedRotation.frame_a) annotation(Line(points = {{ -60, -10},{ -40, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(fixedRotation.frame_b,freeMotion.frame_a) annotation(Line(points = {{ -20, -10},{0, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_a.frame_a,freeMotion.frame_a) annotation(Line(points = {{ -10, -40},{ -10, -10},{0, -10}}, color = {0,0,0}, thickness = 0.5));
      end AbsoluteSensor2;
      model RelativeSensor
        import Modelica.Mechanics.MultiBody.*;
        extends Modelica.Icons.Example;
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
        Joints.Revolute revolute(a(fixed = false), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{ -68,20},{ -48,40}}, rotation = 0)));
        Parts.BodyBox BodyBox1(r = {0.7,0,0}) annotation(Placement(transformation(extent = {{ -40,20},{ -20,40}}, rotation = 0)));
        annotation(Diagram(graphics), experiment(StopTime = 2));
        Parts.Fixed fixed(r = { -0.9,0,0.3}) annotation(Placement(transformation(extent = {{ -100, -40},{ -80, -20}}, rotation = 0)));
        Joints.Revolute revolute1(a(fixed = false), phi(fixed = true, start = 0.785398163397448), w(fixed = true)) annotation(Placement(transformation(extent = {{ -68, -40},{ -48, -20}}, rotation = 0)));
        Parts.BodyBox BodyBox2(r = {0.7,0,0}) annotation(Placement(transformation(extent = {{ -40, -40},{ -20, -20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.RelativeSensor relative_a1(resolveInFrame_a = true, get_r_rel = true, get_v_rel = true, get_a_rel = true, get_w_rel = true, get_z_rel = true, get_angles = true) annotation(Placement(transformation(origin = {28,10}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.RelativeSensor relative_a2(resolveInFrame_a = true, get_r_rel = true, get_v_rel = true, get_a_rel = true, get_w_rel = true, get_z_rel = true, get_angles = true) annotation(Placement(transformation(origin = {50, -10}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Math.Add err1[18](each k2 =  -1) annotation(Placement(transformation(extent = {{80,0},{100,20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.RelativeSensor relative_b2(get_r_rel = true, get_v_rel = true, get_a_rel = true, get_w_rel = true, get_z_rel = true, resolveInFrame_a = false, get_angles = true) annotation(Placement(transformation(origin = { -2,50}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.RelativeSensor relative_b1(get_r_rel = true, get_v_rel = true, get_a_rel = true, get_w_rel = true, get_z_rel = true, resolveInFrame_a = false, get_angles = true) annotation(Placement(transformation(origin = {16,70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Math.Add err2[18](each k2 =  -1) annotation(Placement(transformation(extent = {{52,50},{72,70}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.RelativeSensor relative_c(get_angles = true, sequence = {3,2,1}) annotation(Placement(transformation(origin = { -70,70}, extent = {{ -10,10},{10, -10}}, rotation = 90)));

      equation 
        connect(BodyBox1.frame_a,revolute.frame_b) annotation(Line(points = {{ -40,30},{ -48,30}}));
        connect(revolute.frame_a,world.frame_b) annotation(Line(points = {{ -68,30},{ -80,30}}));
        connect(BodyBox2.frame_a,revolute1.frame_b) annotation(Line(points = {{ -40, -30},{ -48, -30}}));
        connect(revolute1.frame_a,fixed.frame_b) annotation(Line(points = {{ -68, -30},{ -80, -30}}));
        connect(BodyBox1.frame_b,relative_a2.frame_b) annotation(Line(points = {{ -20,30},{50,30},{50,0}}, color = {0,0,0}, thickness = 0.5));
        connect(BodyBox2.frame_b,relative_a2.frame_a) annotation(Line(points = {{ -20, -30},{50, -30},{50, -20}}, color = {0,0,0}, thickness = 0.5));
        connect(BodyBox1.frame_b,relative_a1.frame_b) annotation(Line(points = {{ -20,30},{28,30},{28,20}}, color = {0,0,0}, thickness = 0.5));
        connect(BodyBox2.frame_b,relative_a1.frame_a) annotation(Line(points = {{ -20, -30},{28, -30},{28,0}}, color = {0,0,0}, thickness = 0.5));
        connect(relative_a2.frame_resolve,revolute1.frame_b) annotation(Line(points = {{60, -16},{60, -52},{ -44, -52},{ -44, -30},{ -48, -30}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(relative_a1.y,err1.u1) annotation(Line(points = {{39,10},{54,10},{54,16},{78,16}}, color = {0,0,255}));
        connect(relative_a2.y,err1.u2) annotation(Line(points = {{61, -10},{68, -10},{68,4},{78,4}}, color = {0,0,255}));
        connect(relative_b2.frame_a,BodyBox2.frame_b) annotation(Line(points = {{ -2,40},{ -2, -30},{ -20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(relative_b1.frame_a,BodyBox2.frame_b) annotation(Line(points = {{16,60},{16, -30},{ -20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(relative_b1.y,err2.u1) annotation(Line(points = {{27,70},{38,70},{38,66},{50,66}}, color = {0,0,255}));
        connect(relative_b2.y,err2.u2) annotation(Line(points = {{9,50},{28,50},{28,54},{50,54}}, color = {0,0,255}));
        connect(relative_b2.frame_b,BodyBox1.frame_b) annotation(Line(points = {{ -2,60},{ -2,68},{ -20,68},{ -20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(relative_b1.frame_b,BodyBox1.frame_b) annotation(Line(points = {{16,80},{16,92},{ -20,92},{ -20,30}}, color = {0,0,0}, thickness = 0.5));
        connect(relative_b2.frame_resolve,BodyBox1.frame_a) annotation(Line(points = {{8,44},{ -32,44},{ -32,56},{ -44,56},{ -44,30},{ -40,30}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(world.frame_b,relative_c.frame_a) annotation(Line(points = {{ -80,30},{ -70,30},{ -70,60}}, color = {0,0,0}, thickness = 0.5));
        connect(revolute.frame_b,relative_c.frame_b) annotation(Line(points = {{ -48,30},{ -46,30},{ -46,94},{ -70,94},{ -70,80}}, color = {0,0,0}, thickness = 0.5));
      end RelativeSensor;
      model Distance "Test Sensors.Distance"
        extends Modelica.Icons.Example;
        annotation(experiment(StopTime = 5), Window(x = 0.29, y = 0, width = 0.71, height = 0.85), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}, grid = {2,2}), graphics), Documentation(info = ""));
        inner Modelica.Mechanics.MultiBody.World world(gravityType = Modelica.Mechanics.MultiBody.Types.GravityTypes.UniformGravity) annotation(Placement(transformation(extent = {{ -60,0},{ -40,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute rev(n = {0,0,1}, useAxisFlange = true, a(fixed = false), phi(fixed = true), w(fixed = true)) annotation(Placement(transformation(extent = {{ -20,0},{0,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Damper damper(d = 0.1) annotation(Placement(transformation(extent = {{ -20,40},{0,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed fixed(r = {0, -1,0}) annotation(Placement(transformation(origin = { -50, -70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Sensors.Distance Distance1 annotation(Placement(transformation(extent = {{ -20, -60},{0, -40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox BodyBox1(r = {0.5,0,0}) annotation(Placement(transformation(extent = {{20,0},{40,20}}, rotation = 0)));
        Modelica.Blocks.Continuous.Der Der1 annotation(Placement(transformation(extent = {{0, -100},{20, -80}}, rotation = 0)));
        Modelica.Blocks.Continuous.Der Der2 annotation(Placement(transformation(extent = {{40, -100},{60, -80}}, rotation = 0)));

      equation 
        connect(world.frame_b,rev.frame_a) annotation(Line(points = {{ -40,10},{ -20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(damper.flange_b,rev.axis) annotation(Line(points = {{0,50},{4,50},{4,26},{ -10,26},{ -10,20}}, color = {0,0,0}));
        connect(rev.support,damper.flange_a) annotation(Line(points = {{ -16,20},{ -16,26},{ -28,26},{ -28,50},{ -20,50}}, color = {0,0,0}));
        connect(rev.frame_b,BodyBox1.frame_a) annotation(Line(points = {{0,10},{20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(Distance1.frame_b,BodyBox1.frame_b) annotation(Line(points = {{0, -50},{60, -50},{60,10},{40,10}}, color = {0,0,0}, thickness = 0.5));
        connect(Distance1.frame_a,fixed.frame_b) annotation(Line(points = {{ -20, -50},{ -50, -50},{ -50, -60}}, color = {0,0,0}, thickness = 0.5));
        connect(Der1.y,Der2.u) annotation(Line(points = {{21, -90},{38, -90}}, color = {0,0,255}));
        connect(Distance1.distance,Der1.u) annotation(Line(points = {{ -10, -61},{ -10, -90},{ -2, -90}}, color = {0,0,127}, smooth = Smooth.None));
      end Distance;
      model Distance2 "Test Modelica.Mechanics.MultiBody.Sensors.Distance"
        extends Modelica.Icons.Example;
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80,0},{ -60,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute Revolute1(a(fixed = false), phi(fixed = true, start = 0.523598775598299), w(fixed = true)) annotation(Placement(transformation(extent = {{ -40,0},{ -20,20}}, rotation = 0)));
        annotation(Diagram(graphics), experiment(StopTime = 0.5, NumberOfIntervals = 50000, Tolerance = 1e-10));
        Modelica.Mechanics.MultiBody.Parts.BodyBox BodyBox1(r = {1,0,0}, width = 0.08) annotation(Placement(transformation(extent = {{0,0},{20,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Fixed fixed(r = {1,0,0}) annotation(Placement(transformation(origin = {70,50}, extent = {{ -10, -10},{10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Sensors.Distance distance1 annotation(Placement(transformation(extent = {{40,0},{60,20}}, rotation = 0)));
        Modelica.Blocks.Continuous.Der Der1 annotation(Placement(transformation(extent = {{60, -24},{80, -4}}, rotation = 0)));
        Modelica.Blocks.Logical.LessEqualThreshold LessEqualThreshold1 annotation(Placement(transformation(extent = {{60, -50},{80, -30}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.Distance distance2 annotation(Placement(transformation(extent = {{ -40,30},{ -20,50}}, rotation = 0)));

      equation 
        connect(world.frame_b,Revolute1.frame_a) annotation(Line(points = {{ -60,10},{ -40,10}}, color = {0,0,0}, thickness = 0.5));
        connect(Revolute1.frame_b,BodyBox1.frame_a) annotation(Line(points = {{ -20,10},{0,10}}, color = {0,0,0}, thickness = 0.5));
        connect(BodyBox1.frame_b,distance1.frame_a) annotation(Line(points = {{20,10},{40,10}}, color = {0,0,0}, thickness = 0.5));
        connect(distance1.frame_b,fixed.frame_b) annotation(Line(points = {{60,10},{70,10},{70,40}}, color = {0,0,0}, thickness = 0.5));
        connect(distance1.distance,Der1.u) annotation(Line(points = {{50, -1},{50, -14},{58, -14}}, color = {0,0,127}));
        connect(distance1.distance,LessEqualThreshold1.u) annotation(Line(points = {{50, -1},{50, -40},{58, -40}}, color = {0,0,127}));
        connect(Revolute1.frame_a,distance2.frame_a) annotation(Line(points = {{ -40,10},{ -46,10},{ -46,40},{ -40,40}}, color = {0,0,0}, thickness = 0.5));
        connect(Revolute1.frame_b,distance2.frame_b) annotation(Line(points = {{ -20,10},{ -10,10},{ -10,40},{ -20,40}}, color = {0,0,0}, thickness = 0.5));
      end Distance2;
      model CutForce
        extends Modelica.Icons.Example;
        annotation(experiment(StopTime = 1.1));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -100,0},{ -80,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.CutForce cutForce1a(N_to_m = 10) annotation(Placement(transformation(extent = {{ -20,20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate1a(r = {0, -1,0}) annotation(Placement(transformation(origin = {30,10}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body1a annotation(Placement(transformation(extent = {{60,0},{80,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.CutForce cutForce2a(positiveSign = false, N_to_m = 10, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameA.world) annotation(Placement(transformation(extent = {{ -20, -40},{0, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate2a(r = {0, -1,0}) annotation(Placement(transformation(origin = {30, -30}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body2a annotation(Placement(transformation(extent = {{60, -40},{80, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate1a(n = {0,0,1}, angle = 90, r = {0,0, -0.2}) annotation(Placement(transformation(extent = {{ -60,0},{ -40,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate2a(n = {0,0,1}, angle = 90, r = {0,0,0.2}) annotation(Placement(transformation(extent = {{ -60, -40},{ -40, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.CutForce cutForce1b(N_to_m = 10, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameA.frame_resolve) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate1b(r = {0, -1,0}) annotation(Placement(transformation(origin = {30,70}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body1b annotation(Placement(transformation(extent = {{60,60},{80,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate1b(n = {0,0,1}, angle = 90, r = {0,0, -0.6}) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
        Modelica.Blocks.Math.Add err1[3](each k2 =  -1) annotation(Placement(transformation(extent = {{10,30},{30,50}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.CutForce cutForce2b(positiveSign = false, N_to_m = 10, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameA.frame_resolve) annotation(Placement(transformation(extent = {{ -20, -80},{0, -100}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate2b(r = {0, -1,0}) annotation(Placement(transformation(origin = {30, -90}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body2b annotation(Placement(transformation(extent = {{60, -100},{80, -80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate2b(n = {0,0,1}, angle = 90, r = {0,0,0.6}) annotation(Placement(transformation(extent = {{ -60, -100},{ -40, -80}}, rotation = 0)));
        Modelica.Blocks.Math.Add err2[3](each k2 =  -1) annotation(Placement(transformation(extent = {{8, -72},{28, -52}}, rotation = 0)));

      equation 
        annotation(Diagram(graphics));
        connect(world.frame_b,rotate1a.frame_a) annotation(Line(points = {{ -80,10},{ -60,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate1a.frame_b,cutForce1a.frame_a) annotation(Line(points = {{ -40,10},{ -20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2a.frame_b,cutForce2a.frame_a) annotation(Line(points = {{ -40, -30},{ -20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2a.frame_a,world.frame_b) annotation(Line(points = {{ -60, -30},{ -70, -30},{ -70,10},{ -80,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate1b.frame_b,cutForce1b.frame_a) annotation(Line(points = {{ -40,70},{ -20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce1b.frame_resolve,rotate1b.frame_b) annotation(Line(points = {{ -2,60},{ -20,60},{ -20,46},{ -40,46},{ -40,70}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(cutForce1b.force,err1.u1) annotation(Line(points = {{ -18,59},{ -18,46},{8,46}}, color = {0,0,255}));
        connect(cutForce1a.force,err1.u2) annotation(Line(points = {{ -18,21},{ -18,34},{8,34}}, color = {0,0,255}));
        connect(world.frame_b,rotate1b.frame_a) annotation(Line(points = {{ -80,10},{ -70,10},{ -70,70},{ -60,70}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2b.frame_b,cutForce2b.frame_a) annotation(Line(points = {{ -40, -90},{ -20, -90}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2b.frame_a,world.frame_b) annotation(Line(points = {{ -60, -90},{ -70, -90},{ -70,10},{ -80,10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce2a.force,err2.u1) annotation(Line(points = {{ -18, -41},{ -18, -56},{6, -56}}, color = {0,0,255}));
        connect(cutForce2b.force,err2.u2) annotation(Line(points = {{ -18, -79},{ -18, -68},{6, -68}}, color = {0,0,255}));
        connect(cutForce2b.frame_resolve,world.frame_b) annotation(Line(points = {{ -2, -80},{ -2, -58},{ -74, -58},{ -74,10},{ -80,10}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(cutForce1b.frame_b,translate1b.frame_a) annotation(Line(points = {{0,70},{20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(translate1b.frame_b,body1b.frame_a) annotation(Line(points = {{40,70},{60,70}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce1a.frame_b,translate1a.frame_a) annotation(Line(points = {{0,10},{10,10},{10,10},{20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(translate1a.frame_b,body1a.frame_a) annotation(Line(points = {{40,10},{50,10},{50,10},{60,10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce2a.frame_b,translate2a.frame_a) annotation(Line(points = {{0, -30},{20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(translate2a.frame_b,body2a.frame_a) annotation(Line(points = {{40, -30},{60, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce2b.frame_b,translate2b.frame_a) annotation(Line(points = {{0, -90},{20, -90}}, color = {0,0,0}, thickness = 0.5));
        connect(translate2b.frame_b,body2b.frame_a) annotation(Line(points = {{40, -90},{60, -90}}, color = {0,0,0}, thickness = 0.5));
      end CutForce;
      model CutForce2
        extends Modelica.Icons.Example;
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -80, -20},{ -60,0}}, rotation = 0)));
        annotation(Diagram(graphics));
        Modelica.Mechanics.MultiBody.Sensors.CutForce cutForce annotation(Placement(transformation(extent = {{0, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation fixedRotation(r = {0.5,0.5,0.1}, rotationType = Modelica.Mechanics.MultiBody.Types.RotationTypes.PlanarRotationSequence, animation = false) annotation(Placement(transformation(extent = {{ -40, -20},{ -20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_b(color_x = {0,0,200}) annotation(Placement(transformation(origin = {50,30}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Forces.WorldForce WorldForce1(animation = false) annotation(Placement(transformation(extent = {{60, -20},{40,0}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = {500,0,0}) annotation(Placement(transformation(extent = {{100, -20},{80,0}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,fixedRotation.frame_a) annotation(Line(points = {{ -60, -10},{ -40, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(Constant1.y,WorldForce1.force) annotation(Line(points = {{79, -10},{62, -10}}, color = {0,0,255}));
        connect(fixedRotation.frame_b,cutForce.frame_a) annotation(Line(points = {{ -20, -10},{0, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce.frame_b,WorldForce1.frame_b) annotation(Line(points = {{20, -10},{40, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_b.frame_a,cutForce.frame_b) annotation(Line(points = {{50,20},{50,14},{28,14},{28, -10},{20, -10}}, color = {0,0,0}, thickness = 0.5));
      end CutForce2;
      model CutTorque
        extends Modelica.Icons.Example;
        annotation(experiment(StopTime = 1.1));
        inner Modelica.Mechanics.MultiBody.World world(n = {0,0, -1}) annotation(Placement(transformation(extent = {{ -100,0},{ -80,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.CutTorque cutTorque1a(Nm_to_m = 10) annotation(Placement(transformation(extent = {{ -20,20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate1a(r = {0, -1,0}) annotation(Placement(transformation(origin = {30,10}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body1a annotation(Placement(transformation(extent = {{60,0},{80,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.CutTorque cutTorque2a(positiveSign = false, Nm_to_m = 10, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameA.world) annotation(Placement(transformation(extent = {{ -20, -40},{0, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate2a(r = {0, -1,0}) annotation(Placement(transformation(origin = {30, -30}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body2a annotation(Placement(transformation(extent = {{60, -40},{80, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate1a(n = {0,0,1}, angle = 90, r = {0,0, -0.2}) annotation(Placement(transformation(extent = {{ -60,0},{ -40,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate2a(n = {0,0,1}, angle = 90, r = {0,0,0.2}) annotation(Placement(transformation(extent = {{ -60, -40},{ -40, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.CutTorque cutTorque1b(Nm_to_m = 10, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameA.frame_resolve) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate1b(r = {0, -1,0}) annotation(Placement(transformation(origin = {30,70}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body1b annotation(Placement(transformation(extent = {{60,60},{80,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate1b(n = {0,0,1}, angle = 90, r = {0,0, -0.6}) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
        Modelica.Blocks.Math.Add err1[3](each k2 =  -1) annotation(Placement(transformation(extent = {{10,30},{30,50}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Sensors.CutTorque cutTorque2b(positiveSign = false, Nm_to_m = 10, resolveInFrame = Modelica.Mechanics.MultiBody.Types.ResolveInFrameA.frame_resolve) annotation(Placement(transformation(extent = {{ -20, -80},{0, -100}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate2b(r = {0, -1,0}) annotation(Placement(transformation(origin = {30, -90}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body2b annotation(Placement(transformation(extent = {{60, -100},{80, -80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate2b(n = {0,0,1}, angle = 90, r = {0,0,0.6}) annotation(Placement(transformation(extent = {{ -60, -100},{ -40, -80}}, rotation = 0)));
        Modelica.Blocks.Math.Add err2[3](each k2 =  -1) annotation(Placement(transformation(extent = {{8, -72},{28, -52}}, rotation = 0)));

      equation 
        annotation(Diagram(graphics));
        connect(world.frame_b,rotate1a.frame_a) annotation(Line(points = {{ -80,10},{ -60,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate1a.frame_b,cutTorque1a.frame_a) annotation(Line(points = {{ -40,10},{ -20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2a.frame_b,cutTorque2a.frame_a) annotation(Line(points = {{ -40, -30},{ -20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2a.frame_a,world.frame_b) annotation(Line(points = {{ -60, -30},{ -70, -30},{ -70,10},{ -80,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate1b.frame_b,cutTorque1b.frame_a) annotation(Line(points = {{ -40,70},{ -20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(cutTorque1b.frame_resolve,rotate1b.frame_b) annotation(Line(points = {{ -2,60},{ -20,60},{ -20,46},{ -40,46},{ -40,70}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(cutTorque1b.torque,err1.u1) annotation(Line(points = {{ -18,59},{ -18,46},{8,46}}, color = {0,0,255}));
        connect(cutTorque1a.torque,err1.u2) annotation(Line(points = {{ -18,21},{ -18,34},{8,34}}, color = {0,0,255}));
        connect(world.frame_b,rotate1b.frame_a) annotation(Line(points = {{ -80,10},{ -70,10},{ -70,70},{ -60,70}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2b.frame_b,cutTorque2b.frame_a) annotation(Line(points = {{ -40, -90},{ -20, -90}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2b.frame_a,world.frame_b) annotation(Line(points = {{ -60, -90},{ -70, -90},{ -70,10},{ -80,10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutTorque2a.torque,err2.u1) annotation(Line(points = {{ -18, -41},{ -18, -56},{6, -56}}, color = {0,0,255}));
        connect(cutTorque2b.torque,err2.u2) annotation(Line(points = {{ -18, -79},{ -18, -68},{6, -68}}, color = {0,0,255}));
        connect(cutTorque2b.frame_resolve,world.frame_b) annotation(Line(points = {{ -2, -80},{ -2, -58},{ -74, -58},{ -74,10},{ -80,10}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(cutTorque1b.frame_b,translate1b.frame_a) annotation(Line(points = {{0,70},{20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(translate1b.frame_b,body1b.frame_a) annotation(Line(points = {{40,70},{60,70}}, color = {0,0,0}, thickness = 0.5));
        connect(cutTorque1a.frame_b,translate1a.frame_a) annotation(Line(points = {{0,10},{10,10},{10,10},{20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(translate1a.frame_b,body1a.frame_a) annotation(Line(points = {{40,10},{50,10},{50,10},{60,10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutTorque2a.frame_b,translate2a.frame_a) annotation(Line(points = {{0, -30},{20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(translate2a.frame_b,body2a.frame_a) annotation(Line(points = {{40, -30},{60, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(cutTorque2b.frame_b,translate2b.frame_a) annotation(Line(points = {{0, -90},{20, -90}}, color = {0,0,0}, thickness = 0.5));
        connect(translate2b.frame_b,body2b.frame_a) annotation(Line(points = {{40, -90},{60, -90}}, color = {0,0,0}, thickness = 0.5));
      end CutTorque;
      model CutTorque2
        extends Modelica.Icons.Example;
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -80, -20},{ -60,0}}, rotation = 0)));
        annotation(Diagram(graphics));
        Modelica.Mechanics.MultiBody.Sensors.CutTorque cutTorque annotation(Placement(transformation(extent = {{0, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation fixedRotation(r = {0.5,0.5,0.1}, rotationType = Modelica.Mechanics.MultiBody.Types.RotationTypes.PlanarRotationSequence, animation = false) annotation(Placement(transformation(extent = {{ -40, -20},{ -20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_b(color_x = {0,0,200}) annotation(Placement(transformation(origin = {50,30}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        Modelica.Mechanics.MultiBody.Forces.WorldTorque worldTorque(animation = false) annotation(Placement(transformation(extent = {{60, -20},{40,0}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[3](k = {500,0,0}) annotation(Placement(transformation(extent = {{100, -20},{80,0}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,fixedRotation.frame_a) annotation(Line(points = {{ -60, -10},{ -40, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(Constant1.y,worldTorque.torque) annotation(Line(points = {{79, -10},{62, -10}}, color = {0,0,255}));
        connect(fixedRotation.frame_b,cutTorque.frame_a) annotation(Line(points = {{ -20, -10},{0, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutTorque.frame_b,worldTorque.frame_b) annotation(Line(points = {{20, -10},{40, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_b.frame_a,cutTorque.frame_b) annotation(Line(points = {{50,20},{50,14},{28,14},{28, -10},{20, -10}}, color = {0,0,0}, thickness = 0.5));
      end CutTorque2;
      model CutForceAndTorque1
        extends Modelica.Icons.Example;
        annotation(experiment(StopTime = 1.1));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -100,0},{ -80,20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.CutForceAndTorque cutForce1a(N_to_m = 10, Nm_to_m = 10) annotation(Placement(transformation(extent = {{ -20,20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate1a(r = {0, -1,0}) annotation(Placement(transformation(origin = {30,10}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body1a annotation(Placement(transformation(extent = {{60,0},{80,20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.CutForceAndTorque cutForce2a(positiveSign = false, resolveInFrame_a = false, N_to_m = 10, Nm_to_m = 10) annotation(Placement(transformation(extent = {{ -20, -40},{0, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate2a(r = {0, -1,0}) annotation(Placement(transformation(origin = {30, -30}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body2a annotation(Placement(transformation(extent = {{60, -40},{80, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate1a(n = {0,0,1}, angle = 90, r = {0,0, -0.2}) annotation(Placement(transformation(extent = {{ -60,0},{ -40,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate2a(n = {0,0,1}, angle = 90, r = {0,0,0.2}) annotation(Placement(transformation(extent = {{ -60, -40},{ -40, -20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.CutForceAndTorque cutForce1b(N_to_m = 10, Nm_to_m = 10) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate1b(r = {0, -1,0}) annotation(Placement(transformation(origin = {30,70}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body1b annotation(Placement(transformation(extent = {{60,60},{80,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate1b(n = {0,0,1}, angle = 90, r = {0,0, -0.6}) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
        Modelica.Blocks.Math.Add err1[6](each k2 =  -1) annotation(Placement(transformation(extent = {{10,30},{30,50}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.CutForceAndTorque cutForce2b(positiveSign = false, resolveInFrame_a = false, N_to_m = 10, Nm_to_m = 10) annotation(Placement(transformation(extent = {{ -20, -80},{0, -100}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate2b(r = {0, -1,0}) annotation(Placement(transformation(origin = {30, -90}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body2b annotation(Placement(transformation(extent = {{60, -100},{80, -80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate2b(n = {0,0,1}, angle = 90, r = {0,0,0.6}) annotation(Placement(transformation(extent = {{ -60, -100},{ -40, -80}}, rotation = 0)));
        Modelica.Blocks.Math.Add err2[6](each k2 =  -1) annotation(Placement(transformation(extent = {{8, -72},{28, -52}}, rotation = 0)));

      equation 
        annotation(Diagram(graphics));
        connect(world.frame_b,rotate1a.frame_a) annotation(Line(points = {{ -80,10},{ -60,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate1a.frame_b,cutForce1a.frame_a) annotation(Line(points = {{ -40,10},{ -20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2a.frame_b,cutForce2a.frame_a) annotation(Line(points = {{ -40, -30},{ -20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2a.frame_a,world.frame_b) annotation(Line(points = {{ -60, -30},{ -70, -30},{ -70,10},{ -80,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate1b.frame_b,cutForce1b.frame_a) annotation(Line(points = {{ -40,70},{ -20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce1b.frame_resolve,rotate1b.frame_b) annotation(Line(points = {{ -2,60},{ -20,60},{ -20,46},{ -40,46},{ -40,70}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(cutForce1b.load,err1.u1) annotation(Line(points = {{ -18,59},{ -18,46},{8,46}}, color = {0,0,255}));
        connect(cutForce1a.load,err1.u2) annotation(Line(points = {{ -18,21},{ -18,34},{8,34}}, color = {0,0,255}));
        connect(world.frame_b,rotate1b.frame_a) annotation(Line(points = {{ -80,10},{ -70,10},{ -70,70},{ -60,70}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2b.frame_b,cutForce2b.frame_a) annotation(Line(points = {{ -40, -90},{ -20, -90}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2b.frame_a,world.frame_b) annotation(Line(points = {{ -60, -90},{ -70, -90},{ -70,10},{ -80,10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce2a.load,err2.u1) annotation(Line(points = {{ -18, -41},{ -18, -56},{6, -56}}, color = {0,0,255}));
        connect(cutForce2b.load,err2.u2) annotation(Line(points = {{ -18, -79},{ -18, -68},{6, -68}}, color = {0,0,255}));
        connect(cutForce2b.frame_resolve,world.frame_b) annotation(Line(points = {{ -2, -80},{ -2, -58},{ -74, -58},{ -74,10},{ -80,10}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(cutForce1b.frame_b,translate1b.frame_a) annotation(Line(points = {{0,70},{20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(translate1b.frame_b,body1b.frame_a) annotation(Line(points = {{40,70},{60,70}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce1a.frame_b,translate1a.frame_a) annotation(Line(points = {{0,10},{10,10},{10,10},{20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(translate1a.frame_b,body1a.frame_a) annotation(Line(points = {{40,10},{50,10},{50,10},{60,10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce2a.frame_b,translate2a.frame_a) annotation(Line(points = {{0, -30},{20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(translate2a.frame_b,body2a.frame_a) annotation(Line(points = {{40, -30},{60, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce2b.frame_b,translate2b.frame_a) annotation(Line(points = {{0, -90},{20, -90}}, color = {0,0,0}, thickness = 0.5));
        connect(translate2b.frame_b,body2b.frame_a) annotation(Line(points = {{40, -90},{60, -90}}, color = {0,0,0}, thickness = 0.5));
      end CutForceAndTorque1;
      model CutForceAndTorque2
        extends Modelica.Icons.Example;
        annotation(experiment(StopTime = 1.1));
        inner Modelica.Mechanics.MultiBody.World world(n = {0,0, -1}) annotation(Placement(transformation(extent = {{ -100,0},{ -80,20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.CutForceAndTorque cutForce1a(N_to_m = 10, Nm_to_m = 10) annotation(Placement(transformation(extent = {{ -20,20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate1a(r = {0, -1,0}) annotation(Placement(transformation(origin = {30,10}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body1a annotation(Placement(transformation(extent = {{60,0},{80,20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.CutForceAndTorque cutForce2a(positiveSign = false, resolveInFrame_a = false, N_to_m = 10, Nm_to_m = 10) annotation(Placement(transformation(extent = {{ -20, -40},{0, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate2a(r = {0, -1,0}) annotation(Placement(transformation(origin = {30, -30}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body2a annotation(Placement(transformation(extent = {{60, -40},{80, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate1a(n = {0,0,1}, angle = 90, r = {0,0, -0.2}) annotation(Placement(transformation(extent = {{ -60,0},{ -40,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate2a(n = {0,0,1}, angle = 90, r = {0,0,0.2}) annotation(Placement(transformation(extent = {{ -60, -40},{ -40, -20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.CutForceAndTorque cutForce1b(N_to_m = 10, Nm_to_m = 10) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate1b(r = {0, -1,0}) annotation(Placement(transformation(origin = {30,70}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body1b annotation(Placement(transformation(extent = {{60,60},{80,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate1b(n = {0,0,1}, angle = 90, r = {0,0, -0.6}) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
        Modelica.Blocks.Math.Add err1[6](each k2 =  -1) annotation(Placement(transformation(extent = {{10,30},{30,50}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.CutForceAndTorque cutForce2b(positiveSign = false, resolveInFrame_a = false, N_to_m = 10, Nm_to_m = 10) annotation(Placement(transformation(extent = {{ -20, -80},{0, -100}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedTranslation translate2b(r = {0, -1,0}) annotation(Placement(transformation(origin = {30, -90}, extent = {{10, -10},{ -10,10}}, rotation = 180)));
        Modelica.Mechanics.MultiBody.Parts.Body body2b annotation(Placement(transformation(extent = {{60, -100},{80, -80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation rotate2b(n = {0,0,1}, angle = 90, r = {0,0,0.6}) annotation(Placement(transformation(extent = {{ -60, -100},{ -40, -80}}, rotation = 0)));
        Modelica.Blocks.Math.Add err2[6](each k2 =  -1) annotation(Placement(transformation(extent = {{8, -72},{28, -52}}, rotation = 0)));

      equation 
        annotation(Diagram(graphics));
        connect(world.frame_b,rotate1a.frame_a) annotation(Line(points = {{ -80,10},{ -60,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate1a.frame_b,cutForce1a.frame_a) annotation(Line(points = {{ -40,10},{ -20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2a.frame_b,cutForce2a.frame_a) annotation(Line(points = {{ -40, -30},{ -20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2a.frame_a,world.frame_b) annotation(Line(points = {{ -60, -30},{ -70, -30},{ -70,10},{ -80,10}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate1b.frame_b,cutForce1b.frame_a) annotation(Line(points = {{ -40,70},{ -20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce1b.frame_resolve,rotate1b.frame_b) annotation(Line(points = {{ -2,60},{ -20,60},{ -20,46},{ -40,46},{ -40,70}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(cutForce1b.load,err1.u1) annotation(Line(points = {{ -18,59},{ -18,46},{8,46}}, color = {0,0,255}));
        connect(cutForce1a.load,err1.u2) annotation(Line(points = {{ -18,21},{ -18,34},{8,34}}, color = {0,0,255}));
        connect(world.frame_b,rotate1b.frame_a) annotation(Line(points = {{ -80,10},{ -70,10},{ -70,70},{ -60,70}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2b.frame_b,cutForce2b.frame_a) annotation(Line(points = {{ -40, -90},{ -20, -90}}, color = {0,0,0}, thickness = 0.5));
        connect(rotate2b.frame_a,world.frame_b) annotation(Line(points = {{ -60, -90},{ -70, -90},{ -70,10},{ -80,10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce2a.load,err2.u1) annotation(Line(points = {{ -18, -41},{ -18, -56},{6, -56}}, color = {0,0,255}));
        connect(cutForce2b.load,err2.u2) annotation(Line(points = {{ -18, -79},{ -18, -68},{6, -68}}, color = {0,0,255}));
        connect(cutForce2b.frame_resolve,world.frame_b) annotation(Line(points = {{ -2, -80},{ -2, -58},{ -74, -58},{ -74,10},{ -80,10}}, color = {0,0,0}, pattern = LinePattern.Dot));
        connect(cutForce1b.frame_b,translate1b.frame_a) annotation(Line(points = {{0,70},{20,70}}, color = {0,0,0}, thickness = 0.5));
        connect(translate1b.frame_b,body1b.frame_a) annotation(Line(points = {{40,70},{60,70}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce1a.frame_b,translate1a.frame_a) annotation(Line(points = {{0,10},{10,10},{10,10},{20,10}}, color = {0,0,0}, thickness = 0.5));
        connect(translate1a.frame_b,body1a.frame_a) annotation(Line(points = {{40,10},{50,10},{50,10},{60,10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce2a.frame_b,translate2a.frame_a) annotation(Line(points = {{0, -30},{20, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(translate2a.frame_b,body2a.frame_a) annotation(Line(points = {{40, -30},{60, -30}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForce2b.frame_b,translate2b.frame_a) annotation(Line(points = {{0, -90},{20, -90}}, color = {0,0,0}, thickness = 0.5));
        connect(translate2b.frame_b,body2b.frame_a) annotation(Line(points = {{40, -90},{60, -90}}, color = {0,0,0}, thickness = 0.5));
      end CutForceAndTorque2;
      model CutForceAndTorque3
        extends Modelica.Icons.Example;
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{ -80, -20},{ -60,0}}, rotation = 0)));
        annotation(Diagram(graphics), experiment(StopTime = 1.1), experimentSetupOutput);
        ObsoleteModelica3.Mechanics.MultiBody.Sensors.CutForceAndTorque cutForceAndTorque annotation(Placement(transformation(extent = {{0, -20},{20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.FixedRotation fixedRotation(r = {0.5,0.5,0.1}, rotationType = Modelica.Mechanics.MultiBody.Types.RotationTypes.PlanarRotationSequence, animation = false) annotation(Placement(transformation(extent = {{ -40, -20},{ -20,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedFrame frame_b(color_x = {0,0,200}) annotation(Placement(transformation(origin = {50,30}, extent = {{10, -10},{ -10,10}}, rotation = 270)));
        ObsoleteModelica3.Mechanics.MultiBody.Forces.WorldForceAndTorque worldForceAndTorque(animation = false) annotation(Placement(transformation(extent = {{60, -20},{40,0}}, rotation = 0)));
        Modelica.Blocks.Sources.Constant Constant1[6](k = {500,0,0,450, -250,0}) annotation(Placement(transformation(extent = {{100, -20},{80,0}}, rotation = 0)));
        annotation(experiment(StopTime = 1.1));

      equation 
        connect(world.frame_b,fixedRotation.frame_a) annotation(Line(points = {{ -60, -10},{ -40, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(fixedRotation.frame_b,cutForceAndTorque.frame_a) annotation(Line(points = {{ -20, -10},{0, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(cutForceAndTorque.frame_b,worldForceAndTorque.frame_b) annotation(Line(points = {{20, -10},{40, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(frame_b.frame_a,cutForceAndTorque.frame_b) annotation(Line(points = {{50,20},{50,14},{28,14},{28, -10},{20, -10}}, color = {0,0,0}, thickness = 0.5));
        connect(Constant1.y,worldForceAndTorque.load) annotation(Line(points = {{79, -10},{62, -10}}, color = {0,0,127}, smooth = Smooth.None));
      end CutForceAndTorque3;
    end Sensors;
    package Visualizers "Test MultiBody.Visualizers"
      encapsulated model Shapes "Test and show models Visualizers.FixedShape"
        import Modelica.Icons;
        import Modelica.Mechanics.MultiBody;
        import Modelica.Mechanics.MultiBody.Visualizers;
        import Modelica;
        extends Icons.Example;
        Modelica.Mechanics.MultiBody.Parts.Fixed fixed(animation = false) annotation(Placement(transformation(extent = {{ -100,40},{ -80,60}}, rotation = 0)));
        annotation(experiment(StopTime = 1), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Visualizers.FixedShape box(widthDirection = {1,0,0}, r_shape = {0,0,0}, lengthDirection = {0.5,1, -0.5}, length = 0.12, width = 0.08, height = 0.08, color = {155,155,155}, shapeType = "box") annotation(Placement(transformation(origin = { -60,70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedShape sphere(r_shape = {0.2,0,0}, lengthDirection = {0.5,1, -0.5}, length = 0.1, widthDirection = { -0.5,1,0}, width = 0.1, height = 0.1, color = {155,155,155}, shapeType = "sphere") annotation(Placement(transformation(origin = { -30,70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedShape cylinder(widthDirection = {1,0,0}, length = 0.1, width = 0.1, height = 0.1, r_shape = {0.4,0,0}, lengthDirection = {0.5,1, -0.5}, extra = 5, color = {155,155,155}, shapeType = "cylinder") annotation(Placement(transformation(origin = { -4,70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedShape pipe(widthDirection = {1,0,0}, length = 0.1, width = 0.1, height = 0.1, r_shape = {0.8,0,0}, lengthDirection = {0.5,1, -0.5}, extra = 0.7, shapeType = "pipe", color = {155,155,155}) annotation(Placement(transformation(origin = {42,70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedShape beam(widthDirection = {1,0,0}, length = 0.1, width = 0.1, height = 0.1, r_shape = {0, -0.2,0}, lengthDirection = {0.5,1, -0.5}, extra = 0, shapeType = "beam", color = {155,155,155}) annotation(Placement(transformation(origin = { -60,10}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
      protected 
        Modelica.Mechanics.MultiBody.Interfaces.Frame_b frame_b1 annotation(Placement(transformation(extent = {{ -61, -11},{ -59, -9}}, rotation = 0)));
      public 
        Modelica.Mechanics.MultiBody.Visualizers.FixedShape gearwheel(widthDirection = {1,0,0}, width = 0.1, height = 0.1, r_shape = {0.2, -0.2,0}, extra = 20, length = 0.04, lengthDirection = {0.5,1, -2}, shapeType = "gearwheel", color = {155,155,155}) annotation(Placement(transformation(origin = { -32,10}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedShape spring(widthDirection = {1,0,0}, length = 0.1, width = 0.1, height = 0.02, r_shape = {0.4, -0.2,0}, extra = 4, lengthDirection = {0.5,1, -0.5}, shapeType = "spring", color = {155,155,155}) annotation(Placement(transformation(origin = { -2,10}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Mechanics.MultiBody.Visualizers.FixedShape cone(widthDirection = {1,0,0}, length = 0.1, width = 0.1, height = 0.1, r_shape = {0.6,0,0}, lengthDirection = {0.5,1, -0.5}, extra = 0.5, shapeType = "cone", color = {155,155,155}) annotation(Placement(transformation(origin = {20,70}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, animateGravity = false) annotation(Placement(transformation(extent = {{40,0},{60,20}}, rotation = 0)));

      equation 
        connect(fixed.frame_b,box.frame_a) annotation(Line(points = {{ -80,50},{ -60,50},{ -60,60}}));
        connect(fixed.frame_b,sphere.frame_a) annotation(Line(points = {{ -80,50},{ -30,50},{ -30,60}}));
        connect(fixed.frame_b,cylinder.frame_a) annotation(Line(points = {{ -80,50},{ -4,50},{ -4,60}}));
        connect(fixed.frame_b,pipe.frame_a) annotation(Line(points = {{ -80,50},{42,50},{42,60}}));
        connect(fixed.frame_b,frame_b1) annotation(Line(points = {{ -80,50},{ -74,50},{ -74, -10},{ -60, -10}}));
        connect(beam.frame_a,frame_b1) annotation(Line(points = {{ -60,0},{ -60, -10}}));
        connect(frame_b1,gearwheel.frame_a) annotation(Line(points = {{ -60, -10},{ -32, -10},{ -32,0}}));
        connect(frame_b1,spring.frame_a) annotation(Line(points = {{ -60, -10},{ -2, -10},{ -2,0}}));
        connect(fixed.frame_b,cone.frame_a) annotation(Line(points = {{ -80,50},{20,50},{20,60}}));
      end Shapes;
      encapsulated model Arrow "Test and show models Visualizers.FixedShape"
        import Modelica.Icons;
        import Modelica.Mechanics.MultiBody;
        import Modelica.Mechanics.MultiBody.Visualizers;
        import Modelica;
        extends Icons.Example;
        annotation(experiment(StopTime = 1), Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics));
        Modelica.Mechanics.MultiBody.Parts.Fixed fixed3(animation = false, r = {0.2, -0.6,0}) annotation(Placement(transformation(origin = { -30, -10}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Visualizers.SignalArrow arrow(diameter = 0.02) annotation(Placement(transformation(origin = { -30,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        Modelica.Blocks.Sources.Sine sine[3](amplitude = {0.1,0.05,0.8}, freqHz = {2,1,2}, each offset = 0.2) annotation(Placement(transformation(extent = {{12,20},{ -8,40}}, rotation = 0)));
        Visualizers.FixedArrow fixedArrow(length = 0.3, color = {0,0,255}) annotation(Placement(transformation(origin = { -70,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
        inner Modelica.Mechanics.MultiBody.World world(animateWorld = false, gravityType = 0) annotation(Placement(transformation(extent = {{ -100, -40},{ -80, -20}}, rotation = 0)));

      equation 
        connect(arrow.frame_a,fixed3.frame_b) annotation(Line(points = {{ -30,20},{ -30,0}}));
        connect(fixedArrow.frame_a,fixed3.frame_b) annotation(Line(points = {{ -70,20},{ -70,0},{ -30,0}}));
        connect(sine.y,arrow.r_head) annotation(Line(points = {{ -9,30},{ -18,30}}, color = {0,0,127}, smooth = Smooth.None));
      end Arrow;
    end Visualizers;
    package InitializationConversion "Test conversion of the initialization"
      model Rotor1D
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D1 annotation(Placement(transformation(extent = {{ -70,40},{ -50,60}}, rotation = 0)));
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -100,20},{ -80,40}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1), experimentSetupOutput);
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D2(stateSelect = StateSelect.prefer, a(fixed = false), phi(fixed = true, start = 1.5707963267949), w(fixed = true, start = 1.74532925199433)) annotation(Placement(transformation(extent = {{ -40,40},{ -20,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D3(stateSelect = StateSelect.prefer, a(fixed = false), phi(fixed = true), w(fixed = false)) annotation(Placement(transformation(extent = {{ -10,40},{10,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D4(stateSelect = StateSelect.prefer, a(fixed = false), phi(fixed = false), w(fixed = true)) annotation(Placement(transformation(extent = {{20,40},{40,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D5(stateSelect = StateSelect.prefer, a(fixed = true), phi(fixed = false), w(fixed = true)) annotation(Placement(transformation(extent = {{ -60,0},{ -40,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D6(stateSelect = StateSelect.prefer, a(fixed = false), phi(fixed = false), w(fixed = true)) annotation(Placement(transformation(extent = {{ -8,0},{12,20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring(c = 10000.0) annotation(Placement(transformation(extent = {{ -34,0},{ -14,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D7(a(start = 0.0523598775598299, fixed = true), stateSelect = StateSelect.prefer, phi(fixed = false, start = 0.0174532925199433), w(fixed = true, start = 0.0349065850398866)) annotation(Placement(transformation(extent = {{ -60, -40},{ -40, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D8(stateSelect = StateSelect.prefer, a(fixed = false), phi(fixed = false), w(fixed = true)) annotation(Placement(transformation(extent = {{ -8, -40},{12, -20}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring1(c = 10000.0) annotation(Placement(transformation(extent = {{ -34, -40},{ -14, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D9(a(start = 0.0523598775598299, fixed = true), phi(fixed = true, start = 0.0174532925199433), w(fixed = true, start = 0.0349065850398866)) annotation(Placement(transformation(extent = {{ -60, -80},{ -40, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Rotor1D rotor1D10(stateSelect = StateSelect.prefer, a(fixed = false), phi(fixed = false), w(fixed = true)) annotation(Placement(transformation(extent = {{ -8, -80},{12, -60}}, rotation = 0)));
        Modelica.Mechanics.Rotational.Components.Spring spring2(c = 10000.0) annotation(Placement(transformation(extent = {{ -34, -80},{ -14, -60}}, rotation = 0)));

      equation 
        connect(world.frame_b,rotor1D1.frame_a) annotation(Line(points = {{ -80,30},{ -60,30},{ -60,40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(world.frame_b,rotor1D2.frame_a) annotation(Line(points = {{ -80,30},{ -30,30},{ -30,40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(world.frame_b,rotor1D3.frame_a) annotation(Line(points = {{ -80,30},{0,30},{0,40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(world.frame_b,rotor1D4.frame_a) annotation(Line(points = {{ -80,30},{30,30},{30,40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(world.frame_b,rotor1D5.frame_a) annotation(Line(points = {{ -80,30},{ -74,30},{ -74, -8},{ -50, -8},{ -50,0}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(rotor1D5.frame_a,rotor1D6.frame_a) annotation(Line(points = {{ -50,0},{ -50, -8},{2, -8},{2,0}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(spring.flange_a,rotor1D5.flange_b) annotation(Line(points = {{ -34,10},{ -40,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring.flange_b,rotor1D6.flange_a) annotation(Line(points = {{ -14,10},{ -8,10}}, color = {0,0,0}, smooth = Smooth.None));
        connect(world.frame_b,rotor1D7.frame_a) annotation(Line(points = {{ -80,30},{ -74,30},{ -74, -48},{ -50, -48},{ -50, -40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(rotor1D7.frame_a,rotor1D8.frame_a) annotation(Line(points = {{ -50, -40},{ -50, -48},{2, -48},{2, -40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(spring1.flange_a,rotor1D7.flange_b) annotation(Line(points = {{ -34, -30},{ -40, -30}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring1.flange_b,rotor1D8.flange_a) annotation(Line(points = {{ -14, -30},{ -8, -30}}, color = {0,0,0}, smooth = Smooth.None));
        connect(world.frame_b,rotor1D9.frame_a) annotation(Line(points = {{ -80,30},{ -74,30},{ -74, -88},{ -50, -88},{ -50, -80}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(rotor1D9.frame_a,rotor1D10.frame_a) annotation(Line(points = {{ -50, -80},{ -50, -88},{2, -88},{2, -80}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(spring2.flange_a,rotor1D9.flange_b) annotation(Line(points = {{ -34, -70},{ -40, -70}}, color = {0,0,0}, smooth = Smooth.None));
        connect(spring2.flange_b,rotor1D10.flange_a) annotation(Line(points = {{ -14, -70},{ -8, -70}}, color = {0,0,0}, smooth = Smooth.None));
      end Rotor1D;
      model Joints
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute revolute(a(start = 0.174532925199433, fixed = false), stateSelect = StateSelect.always, phi(fixed = true, start = 0.785398163397448), w(fixed = true, start = 0.174532925199433)) annotation(Placement(transformation(extent = {{ -48,60},{ -28,80}}, rotation = 0)));
        annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 0.2), experimentSetupOutput);
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox(r = {1,0,0}) annotation(Placement(transformation(extent = {{ -20,60},{0,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Revolute actuatedRevolute(a(start =  -0.174532925199433, fixed = false), stateSelect = StateSelect.always, phi(fixed = true, start = 0.523598775598299), w(fixed = false, start =  -0.174532925199433)) annotation(Placement(transformation(extent = {{8,60},{28,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox1(r = {1,0,0}) annotation(Placement(transformation(extent = {{36,60},{56,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Prismatic prismatic(stateSelect = StateSelect.always, a(fixed = false, start = 1), s(fixed = true, start = 1), v(fixed = true, start = 1), s_offset = 0.1) annotation(Placement(transformation(extent = {{ -48,20},{ -28,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox2(r = {1,0,0}) annotation(Placement(transformation(extent = {{ -20,20},{0,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Prismatic actuatedPrismatic(stateSelect = StateSelect.always, a(fixed = false, start = 0.6), s(fixed = false, start = 0.2), v(fixed = true, start = 0.4)) annotation(Placement(transformation(extent = {{8,20},{28,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Cylindrical cylindrical(stateSelect = StateSelect.always, a(fixed = false, start = 4), phi(fixed = true, start = 1.0471975511966), s(fixed = true, start = 1), v(fixed = true, start = 3), w(fixed = true, start = 0.0349065850398866), wd(fixed = false, start = 0.0872664625997165)) annotation(Placement(transformation(extent = {{ -50, -20},{ -30,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox3(r = {1,0,0}) annotation(Placement(transformation(extent = {{40,20},{60,40}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox4(r = {1,0,0}) annotation(Placement(transformation(extent = {{ -20, -20},{0,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Universal universal(a_a(start = 0.523598775598299, fixed = false), a_b(start =  -0.523598775598299, fixed = false), stateSelect = StateSelect.always, phi_a(fixed = true, start =  -0.174532925199433), phi_b(fixed = true, start = 0.174532925199433), w_a(fixed = false, start = 0.349065850398866), w_b(fixed = false, start =  -0.349065850398866)) annotation(Placement(transformation(extent = {{8, -20},{28,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox5(r = {1,0,0}) annotation(Placement(transformation(extent = {{38, -20},{58,0}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Planar planar(stateSelect = StateSelect.always, a_x(fixed = false, start = 2), a_y(fixed = false, start = 1), phi(fixed = true, start = 0.0523598775598299), s_x(fixed = true, start = 1), s_y(fixed = true, start = 2), v_x(fixed = true, start = 1), v_y(fixed = true, start = 2), w(fixed = true, start = 0.0174532925199433), wd(fixed = false, start = 0.0349065850398866)) annotation(Placement(transformation(extent = {{ -52, -50},{ -32, -30}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox6(r = {1,0,0}) annotation(Placement(transformation(extent = {{ -20, -50},{0, -30}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Spherical spherical(sequence_start = {3,1,3}, angles_start = {0.349065850398866, -0.523598775598299,0.698131700797732}, angles_fixed = true, w_rel_a_fixed = true, z_rel_a_fixed = false, w_rel_a_start = {0.0174532925199433,0.0349065850398866,0.0523598775598299}, z_rel_a_start = {0.0349065850398866,0.0523598775598299,0.0698131700797732}) annotation(Placement(transformation(extent = {{8, -50},{28, -30}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox7(r = {1,0,0}) annotation(Placement(transformation(extent = {{38, -50},{58, -30}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox bodyBox8(r = {1,0,0}) annotation(Placement(transformation(extent = {{ -20, -80},{0, -60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.FreeMotion freeMotion(angles_start = {0.349065850398866,0.523598775598299,0.698131700797732}, a_rel_a(fixed = false), angles_fixed = true, r_rel_a(fixed = true, start = {1,1,1}), v_rel_a(fixed = true), w_rel_a_fixed = true, z_rel_a_fixed = false) annotation(Placement(transformation(extent = {{ -56, -80},{ -36, -60}}, rotation = 0)));

      equation 
        connect(world.frame_b,revolute.frame_a) annotation(Line(points = {{ -60,70},{ -48,70}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(revolute.frame_b,bodyBox.frame_a) annotation(Line(points = {{ -28,70},{ -20,70}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(bodyBox.frame_b,actuatedRevolute.frame_a) annotation(Line(points = {{0,70},{8,70}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(actuatedRevolute.frame_b,bodyBox1.frame_a) annotation(Line(points = {{28,70},{36,70}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(bodyBox1.frame_b,prismatic.frame_a) annotation(Line(points = {{56,70},{66,70},{66,46},{ -54,46},{ -54,30},{ -48,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(prismatic.frame_b,bodyBox2.frame_a) annotation(Line(points = {{ -28,30},{ -20,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(bodyBox2.frame_b,actuatedPrismatic.frame_a) annotation(Line(points = {{0,30},{8,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(actuatedPrismatic.frame_b,bodyBox3.frame_a) annotation(Line(points = {{28,30},{40,30}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(bodyBox3.frame_b,cylindrical.frame_a) annotation(Line(points = {{60,30},{74,30},{74,8},{ -60,8},{ -60, -10},{ -50, -10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(cylindrical.frame_b,bodyBox4.frame_a) annotation(Line(points = {{ -30, -10},{ -20, -10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(bodyBox4.frame_b,universal.frame_a) annotation(Line(points = {{0, -10},{8, -10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(universal.frame_b,bodyBox5.frame_a) annotation(Line(points = {{28, -10},{38, -10}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(bodyBox5.frame_b,planar.frame_a) annotation(Line(points = {{58, -10},{72, -10},{72, -26},{ -60, -26},{ -60, -40},{ -52, -40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(planar.frame_b,bodyBox6.frame_a) annotation(Line(points = {{ -32, -40},{ -20, -40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(bodyBox6.frame_b,spherical.frame_a) annotation(Line(points = {{0, -40},{8, -40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(spherical.frame_b,bodyBox7.frame_a) annotation(Line(points = {{28, -40},{38, -40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(freeMotion.frame_a,bodyBox7.frame_b) annotation(Line(points = {{ -56, -70},{ -60, -70},{ -60, -54},{70, -54},{70, -40},{58, -40}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
        connect(freeMotion.frame_b,bodyBox8.frame_a) annotation(Line(points = {{ -36, -70},{ -20, -70}}, color = {95,95,95}, thickness = 0.5, smooth = Smooth.None));
      end Joints;
      model Bodies
        inner Modelica.Mechanics.MultiBody.World world annotation(Placement(transformation(extent = {{ -80,60},{ -60,80}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.Body body(sequence_start = {3,2,1}, angles_start = {0.349065850398866,0.523598775598299,0.698131700797732}, a_0(fixed = false, start = {2,2,2}), angles_fixed = true, r_0(fixed = true, start = {1,2,3}), v_0(fixed = true, start = {1,2,3}), w_0_fixed = true, z_0_fixed = false, w_0_start = {0.0698131700797732,0.0523598775598299,0.0349065850398866}, z_0_start = {0.0523598775598299,0.0698131700797732,0.0523598775598299}) annotation(Placement(transformation(extent = {{ -42,40},{ -22,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.PointMass pointMass(m = 2, a_0(fixed = false, start = {5,4,3}), r_0(fixed = true, start = {1,2,3}), v_0(fixed = true, start = {2,3,4})) annotation(Placement(transformation(extent = {{ -2, -2},{18,18}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyShape body1(sequence_start = {3,2,1}, angles_start = {0.349065850398866,0.523598775598299,0.698131700797732}, a_0(fixed = false, start = {2,2,2}), angles_fixed = true, r_0(fixed = true, start = {1,2,3}), v_0(fixed = true, start = {1,2,3}), w_0_fixed = true, z_0_fixed = false, w_0_start = {0.0698131700797732,0.0523598775598299,0.0349065850398866}, z_0_start = {0.0523598775598299,0.0698131700797732,0.0523598775598299}) annotation(Placement(transformation(extent = {{0,40},{20,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyBox body2(sequence_start = {3,2,1}, angles_start = {0.349065850398866,0.523598775598299,0.698131700797732}, a_0(fixed = false, start = {2,2,2}), angles_fixed = true, r_0(fixed = true, start = {1,2,3}), v_0(fixed = true, start = {1,2,3}), w_0_fixed = true, z_0_fixed = false, w_0_start = {0.0698131700797732,0.0523598775598299,0.0349065850398866}, z_0_start = {0.0523598775598299,0.0698131700797732,0.0523598775598299}) annotation(Placement(transformation(extent = {{42,40},{62,60}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Parts.BodyCylinder body3(sequence_start = {3,2,1}, angles_start = {0.349065850398866,0.523598775598299,0.698131700797732}, a_0(fixed = false, start = {2,2,2}), angles_fixed = true, r_0(fixed = true, start = {1,2,3}), v_0(fixed = true, start = {1,2,3}), w_0_fixed = true, z_0_fixed = false, w_0_start = {0.0698131700797732,0.0523598775598299,0.0349065850398866}, z_0_start = {0.0523598775598299,0.0698131700797732,0.0523598775598299}) annotation(Placement(transformation(extent = {{ -44,0},{ -24,20}}, rotation = 0)));
        annotation(experiment(StopTime = 0.2), experimentSetupOutput);
      end Bodies;
      partial model Internal "Check whether Advanced/axisTorqueBalance,axisForceBalance parameter is correctely converted"
        ObsoleteModelica3.Mechanics.MultiBody.Joints.Internal.RevoluteWithLengthConstraint revoluteWithLengthConstraint1 annotation(Placement(transformation(extent = {{ -60,38},{ -40,58}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Joints.Internal.PrismaticWithLengthConstraint prismaticWithLengthConstraint1 annotation(Placement(transformation(extent = {{2,38},{22,58}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Joints.Internal.RevoluteWithLengthConstraint revoluteWithLengthConstraint2 annotation(Placement(transformation(extent = {{ -58,0},{ -38,20}}, rotation = 0)));
        ObsoleteModelica3.Mechanics.MultiBody.Joints.Internal.PrismaticWithLengthConstraint prismaticWithLengthConstraint2 annotation(Placement(transformation(extent = {{4,0},{24,20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Internal.RevoluteWithLengthConstraint revoluteWithLengthConstraint3 annotation(Placement(transformation(extent = {{ -58, -40},{ -38, -20}}, rotation = 0)));
        Modelica.Mechanics.MultiBody.Joints.Internal.PrismaticWithLengthConstraint prismaticWithLengthConstraint3 annotation(Placement(transformation(extent = {{4, -40},{24, -20}}, rotation = 0)));
        annotation(Diagram(graphics));
      end Internal;
    end InitializationConversion;
  end MultiBody;
  package Media
    package TestAllProperties
      model PartialMediumFunctions
        import SI = Modelica.SIunits;
        replaceable package Medium = Modelica.Media.Interfaces.PartialMedium "Medium model";
        parameter Real eps_h_is = 1e-10;
        Medium.ThermodynamicState state = Medium.setState_pTX(Medium.reference_p, Medium.reference_T, Medium.reference_X);
        Medium.DynamicViscosity eta = Medium.dynamicViscosity(state);
        Medium.ThermalConductivity lambda = Medium.thermalConductivity(state);
        Medium.PrandtlNumber Pr = Medium.prandtlNumber(state);
        Medium.AbsolutePressure p = Medium.pressure(state);
        Medium.Temperature T = Medium.temperature(state);
        Medium.Density d = Medium.density(state);
        Medium.SpecificEnthalpy h = Medium.specificEnthalpy(state);
        Medium.SpecificEnergy u = Medium.specificInternalEnergy(state);
        Medium.SpecificEntropy s = Medium.specificEntropy(state);
        Medium.SpecificEnergy g = Medium.specificGibbsEnergy(state);
        Medium.SpecificEnergy f = Medium.specificHelmholtzEnergy(state);
        Medium.SpecificHeatCapacity cp = Medium.specificHeatCapacityCp(state);
        Medium.SpecificHeatCapacity cp2 = Medium.heatCapacity_cp(state);
        Medium.SpecificHeatCapacity cv = Medium.specificHeatCapacityCv(state);
        Medium.SpecificHeatCapacity cv2 = Medium.heatCapacity_cv(state);
        Medium.SpecificEnthalpy h_is = Medium.isentropicEnthalpy(2 * Medium.reference_p, state);
        Medium.VelocityOfSound a = Medium.velocityOfSound(state);
        Medium.IsobaricExpansionCoefficient beta = Medium.isobaricExpansionCoefficient(state);
        Medium.IsobaricExpansionCoefficient beta2 = Medium.beta(state);
        SI.IsothermalCompressibility kappa = Medium.isothermalCompressibility(state);
        SI.IsothermalCompressibility kappa2 = Medium.kappa(state);
        Medium.DerDensityByPressure ddpT = Medium.density_derp_T(state);
        Medium.DerDensityByTemperature ddTp = Medium.density_derT_p(state);
        Medium.Density dddX[Medium.nX] = Medium.density_derX(state);
        Medium.MolarMass MM = Medium.molarMass(state);
        Medium.SpecificEnthalpy h2 = Medium.specificEnthalpy_pTX(Medium.reference_p, Medium.reference_T, Medium.reference_X);
        Medium.Density d2 = Medium.density_pTX(Medium.reference_p, Medium.reference_T, Medium.reference_X);
        Medium.ThermodynamicState state2 = Medium.setState_phX(Medium.reference_p, h, Medium.reference_X);
        Medium.ThermodynamicState state3 = Medium.setState_psX(Medium.reference_p, s, Medium.reference_X);
        Medium.ThermodynamicState state4 = if Medium.singleState then state else Medium.setState_dTX(d, T, Medium.reference_X);
        Medium.ThermodynamicState state5 = Medium.setSmoothState(0.1, state, state2, 0.001);
        Medium.BaseProperties medium(preferredMediumStates = true, p(start = Medium.reference_p), T(start = Medium.reference_T), X(start = Medium.reference_X));
        Real err_T = abs(medium.T - T);
        Real err_d = abs(medium.d - d);
        Real err_u = abs(medium.u - u);
        Medium.ThermodynamicState state_h_is = Medium.setState_phX(2 * Medium.reference_p, h_is, Medium.reference_X);
        Medium.SpecificEntropy s_is = Medium.specificEntropy(state_h_is);
        Real err_h_is = abs(s - s_is);
        constant Real eps = 1e-10;

      equation 
        medium.p = p;
        medium.h = h;
        medium.Xi = Medium.reference_X[1:Medium.nXi];
        when terminal() then
                  assert(err_T <= eps, "Error: abs(medium.T - T) > eps");
        
        end when;
        when terminal() then
                  assert(err_d <= eps, "Error: abs(medium.d - d) > eps");
        
        end when;
        when terminal() then
                  assert(err_u <= eps, "Error: abs(medium.u - u) > eps");
        
        end when;
        assert(err_h_is <= eps_h_is, "Error: entropy not constant for isentropicEnthalpy");
      end PartialMediumFunctions;
      model DryAirNasa
        extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.Air.DryAirNasa, eps_h_is = 0.1);
        annotation(experiment(StopTime = 0.1), experimentSetupOutput);
      end DryAirNasa;
      model LinearColdWater
        extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.CompressibleLiquids.LinearColdWater);
        annotation(experiment(StopTime = 0.1), experimentSetupOutput);
      end LinearColdWater;
      model LinearWater_pT_Ambient
        extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.CompressibleLiquids.LinearWater_pT_Ambient);
        annotation(experiment(StopTime = 0.1), experimentSetupOutput);
      end LinearWater_pT_Ambient;
      model CO2
        extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.IdealGases.SingleGases.CO2, eps_h_is = 0.2);
        annotation(experiment(StopTime = 0.1), experimentSetupOutput);
      end CO2;
      model FlueGasSixComponents
        extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.IdealGases.MixtureGases.FlueGasSixComponents);
        annotation(experiment(StopTime = 0.1), experimentSetupOutput);
      end FlueGasSixComponents;
      model ConstantPropertyLiquidWater
        extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.Water.ConstantPropertyLiquidWater);
        annotation(experiment(StopTime = 0.1), experimentSetupOutput);
      end ConstantPropertyLiquidWater;
      model SimpleAir
        extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.Air.SimpleAir);
        annotation(experiment(StopTime = 0.1), experimentSetupOutput);
      end SimpleAir;
      package IncompleteMedia
        model MoistAir
          extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.Air.MoistAir);
        end MoistAir;
        model Glycol47
          extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.Incompressible.Examples.Glycol47);
        end Glycol47;
        model WaterIF97_pT
          extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.Water.WaterIF97_pT);
        end WaterIF97_pT;
        model WaterIF97_ph
          extends PartialMediumFunctions(redeclare package Medium = Modelica.Media.Water.WaterIF97_ph);
        end WaterIF97_ph;
      end IncompleteMedia;
    end TestAllProperties;
  end Media;
  package Math "Test models for Modelica.Math"
    function Polynomials "Test functions of Modelica.Media.Incompressible.TableBased.Polynomials_Temp"
      import Modelica.Utilities.Streams;
      import Poly = Modelica.Media.Incompressible.TableBased.Polynomials_Temp;
      input String logFile = "ModelicaTestLog.txt" "Filename where the log is stored";
      output Boolean ok;
    protected 
      Real p1[4] = { -2, -3, -4, -1};
      Real p2[5];
      Real p3[4];
      Real p4[4];
      Real r;
      Real r1;
      Real r2;
      Real u[7] = {0,1,2,3,4,5,6};
      Real y[7];
    algorithm 
      Streams.print("... Test of Modelica.Media.Incompressible.TableBased.Polynomials_Temp", logFile);
      r:=Poly.evaluate(p1,  -3);
      assert(r == 38, "Polynomials.evaluate failed");
      p2:=Poly.integral(p1);
      assert(p2[1] ==  -0.5 and p2[2] ==  -1 and p2[3] ==  -2 and p2[4] ==  -1 and p2[5] == 0, "Polynomials.integral failed");
      p3:=Poly.derivative(p2);
      assert(p3[1] == p1[1] and p3[2] == p1[2] and p3[3] == p1[3] and p3[4] == p1[4], "Polynomials.derivative failed");
      r1:=Poly.derivativeValue(p2,  -3);
      r2:=Poly.evaluate(p3,  -3);
      assert(r1 == r2, "Polynomials.derivativeValue failed");
      r:=Poly.integralValue(p1, 2, 1);
      assert(r ==  -21.5, "Polynomials.integralValue failed");
      for i in 1:size(u, 1) loop
              y[i]:=Poly.evaluate(p1, u[i]) + 0.01 * i;

      end for;
      p4:=Poly.fitting(u, y, 3);
      assert(abs(p4[1] - p1[1]) <= 1e-08 and abs(p4[2] - p1[2]) <= 1e-08 and abs(p4[3] - p1[3]) <= 0.1 and abs(p4[4] - p1[4]) <= 0.1, "Polynomials.fitting failed");
      ok:=true;
    end Polynomials;
    function Matrices "Test functions of Modelica.Math.Matrices"
      import Modelica.Utilities.Streams;
      input String logFile = "ModelicaTestLog.txt" "Filename where the log is stored";
      output Boolean ok;
    protected 
      Real A1[2,3] = [1,2,3;4,5,6];
      Real A2[2,3] = [1,0,0;4,0,0];
      Real b[2] = {0, -2};
      Real A3[2,3] = [1,2,3;4,5,6];
      Real a3[2] = {0, -2};
      Real B3[1,3] = [4,3,0];
      Real b3[1] = {2};
      Real A4[2,4] = [1,2,3,4;4,5,6,7];
      Real a4[2] = {0, -2};
      Real B4[1,4] = [4,3,0, -1];
      Real b4[1] = {2};
      Real x1[3];
      Real x2[3];
      Real x3[3];
      Real e3[1] = B3 * x3 - b3;
    algorithm 
      Streams.print("... Test of Modelica.Math.Matrices", logFile);
      x1:=Modelica.Math.Matrices.leastSquares(A1, b);
      x2:=Modelica.Math.Matrices.leastSquares(A2, b);
      x3:=Modelica.Math.Matrices.equalityLeastSquares(A3, a3, B3, b3);
      ok:=true;
    end Matrices;
  end Math;
  package Blocks "Test models for Modelica.Blocks"
    model Continuous
      Modelica.Blocks.Continuous.Integrator integrator annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
      Modelica.Blocks.Continuous.LimIntegrator limIntegrator annotation(Placement(transformation(extent = {{ -60,20},{ -40,40}}, rotation = 0)));
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -200},{100,100}}), graphics), experiment(StopTime = 1.1));
      Modelica.Blocks.Continuous.Derivative derivative annotation(Placement(transformation(extent = {{ -60, -20},{ -40,0}}, rotation = 0)));
      Modelica.Blocks.Continuous.FirstOrder firstOrder annotation(Placement(transformation(extent = {{ -60, -60},{ -40, -40}}, rotation = 0)));
      Modelica.Blocks.Continuous.SecondOrder secondOrder annotation(Placement(transformation(extent = {{ -60, -100},{ -40, -80}}, rotation = 0)));
      Modelica.Blocks.Continuous.PI pI annotation(Placement(transformation(extent = {{ -60, -140},{ -40, -120}}, rotation = 0)));
      Modelica.Blocks.Continuous.PID pID annotation(Placement(transformation(extent = {{ -60, -180},{ -40, -160}}, rotation = 0)));
      Modelica.Blocks.Continuous.LimPID limPID annotation(Placement(transformation(extent = {{40,60},{60,80}}, rotation = 0)));
      Modelica.Blocks.Continuous.TransferFunction transferFunction(a = {1,1}, b = {1}) annotation(Placement(transformation(extent = {{40, -20},{60,0}}, rotation = 0)));
      Modelica.Blocks.Continuous.StateSpace stateSpace(A = [1,0;0,1], B = [1;1], C = [1,1]) annotation(Placement(transformation(extent = {{40, -60},{60, -40}}, rotation = 0)));
      Modelica.Blocks.Continuous.LowpassButterworth lowpassButterworth annotation(Placement(transformation(extent = {{40, -100},{60, -80}}, rotation = 0)));
      Modelica.Blocks.Continuous.CriticalDamping criticalDamping(normalized = false) annotation(Placement(transformation(extent = {{40, -140},{60, -120}}, rotation = 0)));
      Modelica.Blocks.Sources.Ramp ramp(offset = 0.5, startTime = 0.5) annotation(Placement(transformation(extent = {{ -100,60},{ -80,80}}, rotation = 0)));
      Modelica.Blocks.Sources.Ramp ramp1(offset = 0.5, startTime = 0.5) annotation(Placement(transformation(extent = {{0,60},{20,80}}, rotation = 0)));
      Modelica.Blocks.Sources.Constant const(k = 1.5) annotation(Placement(transformation(origin = {50,30}, extent = {{ -10, -10},{10,10}}, rotation = 90)));
      Modelica.Blocks.Continuous.Der der1 annotation(Placement(transformation(extent = {{40, -180},{60, -160}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine annotation(Placement(transformation(extent = {{0, -180},{20, -160}}, rotation = 0)));

    equation 
      connect(ramp.y,integrator.u) annotation(Line(points = {{ -79,70},{ -62,70}}, color = {0,0,127}));
      connect(ramp.y,limIntegrator.u) annotation(Line(points = {{ -79,70},{ -72,70},{ -72,30},{ -62,30}}, color = {0,0,127}));
      connect(ramp.y,derivative.u) annotation(Line(points = {{ -79,70},{ -72,70},{ -72, -10},{ -62, -10}}, color = {0,0,127}));
      connect(ramp.y,firstOrder.u) annotation(Line(points = {{ -79,70},{ -72,70},{ -72, -50},{ -62, -50}}, color = {0,0,127}));
      connect(ramp.y,secondOrder.u) annotation(Line(points = {{ -79,70},{ -72,70},{ -72, -90},{ -62, -90}}, color = {0,0,127}));
      connect(ramp.y,pI.u) annotation(Line(points = {{ -79,70},{ -72,70},{ -72, -130},{ -62, -130}}, color = {0,0,127}));
      connect(ramp.y,pID.u) annotation(Line(points = {{ -79,70},{ -72,70},{ -72, -170},{ -62, -170}}, color = {0,0,127}));
      connect(ramp1.y,limPID.u_s) annotation(Line(points = {{21,70},{38,70}}, color = {0,0,127}));
      connect(ramp1.y,transferFunction.u) annotation(Line(points = {{21,70},{28,70},{28, -10},{38, -10}}, color = {0,0,127}));
      connect(ramp1.y,stateSpace.u[1]) annotation(Line(points = {{21,70},{28,70},{28, -50},{38, -50}}, color = {0,0,127}));
      connect(ramp1.y,lowpassButterworth.u) annotation(Line(points = {{21,70},{28,70},{28, -90},{38, -90}}, color = {0,0,127}));
      connect(ramp1.y,criticalDamping.u) annotation(Line(points = {{21,70},{28,70},{28, -130},{38, -130}}, color = {0,0,127}));
      connect(const.y,limPID.u_m) annotation(Line(points = {{50,41},{50,58}}, color = {0,0,127}));
      connect(sine.y,der1.u) annotation(Line(points = {{21, -170},{38, -170}}, color = {0,0,127}, smooth = Smooth.None));
    end Continuous;
    model Continuous_SteadyState
      extends ModelicaTest.Blocks.Continuous(derivative(initType = Modelica.Blocks.Types.Init.SteadyState), firstOrder(initType = Modelica.Blocks.Types.Init.SteadyState), secondOrder(initType = Modelica.Blocks.Types.Init.SteadyState), transferFunction(initType = Modelica.Blocks.Types.Init.SteadyState, a = {1,1}, b = {1}), stateSpace(initType = Modelica.Blocks.Types.Init.SteadyState, A = [1,0;0,1], B = [1;1], C = [1,1]), lowpassButterworth(initType = Modelica.Blocks.Types.Init.SteadyState), criticalDamping(initType = Modelica.Blocks.Types.Init.SteadyState, normalized = false));
      annotation(experiment(StopTime = 1.1));
    end Continuous_SteadyState;
    model Continuous_InitialState
      extends ModelicaTest.Blocks.Continuous(integrator(initType = Modelica.Blocks.Types.Init.InitialState), limIntegrator(initType = Modelica.Blocks.Types.Init.InitialState), derivative(initType = Modelica.Blocks.Types.Init.InitialState), firstOrder(initType = Modelica.Blocks.Types.Init.InitialState), secondOrder(initType = Modelica.Blocks.Types.Init.InitialState), pI(initType = Modelica.Blocks.Types.Init.InitialState), pID(initType = Modelica.Blocks.Types.Init.InitialState), limPID(initType = Modelica.Blocks.Types.Init.InitialState), transferFunction(initType = Modelica.Blocks.Types.Init.InitialState, a = {1,1}, b = {1}), stateSpace(initType = Modelica.Blocks.Types.Init.InitialState, A = [1,0;0,1], B = [1;1], C = [1,1]), lowpassButterworth(initType = Modelica.Blocks.Types.Init.InitialState), criticalDamping(initType = Modelica.Blocks.Types.Init.InitialState, normalized = false));
      annotation(experiment(StopTime = 1.1));
    end Continuous_InitialState;
    model Continuous_InitialOutput
      extends ModelicaTest.Blocks.Continuous(integrator(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 2), limIntegrator(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 0.5), derivative(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 2), firstOrder(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 2), secondOrder(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 2), pI(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 2), pID(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 2), limPID(initType = Modelica.Blocks.Types.Init.InitialOutput, yMax = 3, y_start = 2), transferFunction(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 2, a = {1,1}, b = {1}), stateSpace(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = {2}, A = [1,0;0,1], B = [1;1], C = [1,1]), lowpassButterworth(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 2), criticalDamping(initType = Modelica.Blocks.Types.Init.InitialOutput, y_start = 2, normalized = false));
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -200},{100,100}}), graphics), experiment(StopTime = 1.1));
    end Continuous_InitialOutput;
    model Limiters
      Modelica.Blocks.Nonlinear.Limiter limiter(limitsAtInit = false) annotation(Placement(transformation(extent = {{ -20,40},{0,60}}, rotation = 0)));
      Modelica.Blocks.Nonlinear.VariableLimiter variableLimiter(limitsAtInit = false) annotation(Placement(transformation(extent = {{ -20,0},{0,20}}, rotation = 0)));
      Modelica.Blocks.Nonlinear.DeadZone deadZone(deadZoneAtInit = false) annotation(Placement(transformation(extent = {{ -20, -40},{0, -20}}, rotation = 0)));
      Modelica.Blocks.Sources.Sine sine(amplitude = 2) annotation(Placement(transformation(extent = {{ -60,40},{ -40,60}}, rotation = 0)));
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 1.1));
      Modelica.Blocks.Sources.Constant const annotation(Placement(transformation(extent = {{ -80,16},{ -60,36}}, rotation = 0)));
      Modelica.Blocks.Sources.Constant const1(k =  -1) annotation(Placement(transformation(extent = {{ -80, -26},{ -60, -6}}, rotation = 0)));

    equation 
      connect(sine.y,limiter.u) annotation(Line(points = {{ -39,50},{ -22,50}}, color = {0,0,127}));
      connect(const.y,variableLimiter.limit1) annotation(Line(points = {{ -59,26},{ -42,26},{ -42,18},{ -22,18}}, color = {0,0,127}));
      connect(const1.y,variableLimiter.limit2) annotation(Line(points = {{ -59, -16},{ -40, -16},{ -40,2},{ -22,2}}, color = {0,0,127}));
      connect(sine.y,variableLimiter.u) annotation(Line(points = {{ -39,50},{ -32,50},{ -32,10},{ -22,10}}, color = {0,0,127}));
      connect(sine.y,deadZone.u) annotation(Line(points = {{ -39,50},{ -32,50},{ -32, -30},{ -22, -30}}, color = {0,0,127}));
    end Limiters;
    model KinematicPTP
      Modelica.Blocks.Sources.KinematicPTP kinematicPTP1a(qd_max = {3}, qdd_max = {4}, startTime = 0.5, deltaq = {1}) annotation(Placement(transformation(extent = {{ -60,60},{ -40,80}}, rotation = 0)));
      Modelica.Blocks.Continuous.Integrator integrator annotation(Placement(transformation(extent = {{ -20,60},{2,80}}, rotation = 0)));
      annotation(Diagram(coordinateSystem(preserveAspectRatio = false, extent = {{ -100, -100},{100,100}}), graphics), experiment(StopTime = 3));
      Modelica.Blocks.Continuous.Integrator integrator1(y_start = 1) annotation(Placement(transformation(extent = {{20,60},{42,80}}, rotation = 0)));
      Modelica.Blocks.Sources.KinematicPTP kinematicPTP2a(qd_max = {3}, qdd_max = {4}, startTime = 0.5, deltaq = {4}) annotation(Placement(transformation(extent = {{ -60, -20},{ -40,0}}, rotation = 0)));
      Modelica.Blocks.Continuous.Integrator integrator2 annotation(Placement(transformation(extent = {{ -20, -20},{2,0}}, rotation = 0)));
      Modelica.Blocks.Continuous.Integrator integrator3(y_start = 1) annotation(Placement(transformation(extent = {{20, -20},{42,0}}, rotation = 0)));

    equation 
      connect(kinematicPTP1a.y[1],integrator.u) annotation(Line(points = {{ -39,70},{ -22.2,70}}, color = {0,0,127}));
      connect(integrator.y,integrator1.u) annotation(Line(points = {{3.1,70},{17.8,70}}, color = {0,0,127}));
      connect(kinematicPTP2a.y[1],integrator2.u) annotation(Line(points = {{ -39, -10},{ -22.2, -10}}, color = {0,0,127}));
      connect(integrator2.y,integrator3.u) annotation(Line(points = {{3.1, -10},{17.8, -10}}, color = {0,0,127}));
    end KinematicPTP;
  end Blocks;
end ModelicaTest;
package ModelicaReference "Modelica Reference"
  annotation(__Dymola_DocumentationClass = true, versionBuild = "$Rev: 3044 $", versionDate = "$Date:: 2009-10-08 09:31:41 +0200 #$", Documentation(info = "<html>
<p>
This package is a reference to Modelica keywords and Modelica builtin
operators and is based on the
<a href=\"http://www.modelica.org/documents/ModelicaSpec30.pdf\">Modelica Language Specification version 3.0</a> from Sept. 2007.


<dl>
<dt><b>Main Author:</b></dt>
<dd><a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian.Schweiger</a><br>
    Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
    Institut f&uuml;r Robotik und Mechatronik<br>
    Postfach 11 16<br>
    D-82230 Wessling<br>
    Germany<br>
    email: <A HREF=\"mailto:Christian.Schweiger@dlr.de\">Christian.Schweiger@dlr.de</A><br></dd>
</dl>

<p>
<b>Copyright &copy; 2003-2004, 2008 Modelica Association and DLR.</b>
</p>
<p>
<i>The <b>ModelicaReference</b> package is <b>free</b> software;
it can be redistributed and/or modified
under the terms of the <b>Modelica license</b>, see the license conditions
and the accompanying <b>disclaimer</b>
<a href=\"Modelica://Modelica.UsersGuide.ModelicaLicense2\">here</a>.</i>
</p><br>
</html>", revisions = "<html>

<ul>
<li><i>Jan. 2, 2008</i>
    by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
    Adapted to Modelica language version 3.0</li>

<li><i>Sept. 30, 2004</i>
    by <a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a>:<br>
    Moved the content of \"Functions\" into \"Operators\" and updated
    \"Operators\" according to Modelica 2.1</li>

<li><i>July 10, 2003</i>
     by <a href=\"http://www.robotic.dlr.de/Christian.Schweiger/\">Christian Schweiger</a>:<br>
     Implemented.</li>
</ul>
</html>"));
  package Annotations "Annotations"
    class choices "choices"
      annotation(Documentation(info = "<html>
<p>
Define graphical layout of choices in a parameter menu
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>replaceable model</b> MyResistor=Resistor
  <b>annotation</b>(choices(
              choice(redeclare MyResistor=lib2.Resistor(a={2}) \"...\"),
              choice(redeclare MyResistor=lib2.Resistor2 \"...\")));

<b>replaceable</b> Resistor Load(R=2) constrainedby TwoPin
  <b>annotation</b>(choices(
              choice(redeclare lib2.Resistor Load(a={2}) \"...\"),
              choice(redeclare Capacitor Load(L=3) \"...\")));

<b>replaceable</b> FrictionFunction a(func=exp) constrainedby Friction
  <b>annotation</b>(choices(
             choice(redeclare ConstantFriction a(c=1) \"...\"),
             choice(redeclare TableFriction a(table=\"...\") \"...\"),
             choice(redeclare FunctionFriction a(func=exp) \"...\"))));

<b>type</b> KindOfController=Integer(min=1,max=3)
   <b>annotation</b>(choices(
                choice=1 \"P\",
                choice=2 \"PI\",
                choice=3 \"PID\"));

<b>model</b> A
  KindOfController x;
<b>end</b> A;
A a(x=3 \"PID\");
</pre>



<h4><font color=\"#008000\">Description</font></h4>

<p>
A declaration can have an annotation \"choices\" containing modifiers on choice, where each of them indicates a suitable redeclaration or modifications of the element.
This is a hint for users of the model, and can also be used by the user interface to suggest reasonable redeclaration, where the string comments on the choice declaration can be used as textual explanations of the choices.  The annotation is not restricted to replaceable elements but can also be applied to non-replaceable elements, enumeration types, and simple variables.
</p>

</html>"));
    end choices;
    class defaultComponentName "defaultComponentName"
      annotation(Documentation(info = "<html>
<p>
Default name when dragging component
</p>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>\"(\" defaultComponentName \"=\" STRING \")\"
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
When creating a component of the given class, the recommended component name is the
giving string.
</p>

</html>"));
    end defaultComponentName;
    class defaultComponentPrefixes "defaultComponentPrefixes"
      annotation(Documentation(info = "<html>
<p>
Default prefixes when dragging component
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>annotation</b>(defaultComponentPrefixes=\"inner\",
           defaultComponentName=\"world\")
</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>\"(\" defaultComponentPrefixes \"=\" STRING \")\"
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
The following prefixes may be included in the string prefixes: inner, outer, replaceable, constant, parameter, discrete. In combination with defaultComponentName it can be used to make it easy for users to create inner components matching the outer declarations.
</p>

</html>"));
    end defaultComponentPrefixes;
    class derivative "derivative"
      annotation(Documentation(info = "<html>
<p>
Define derivative of function
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>function</b> foo0 <b>annotation</b>(derivative=foo1); <b>end</b> foo0;
<b>function</b> foo1 <b>annotation</b>(derivative(order=2)=foo2); <b>end</b> foo1;
<b>function</b> foo2 <b>end</b> foo2;
</pre>



<h4><font color=\"#008000\">Description</font></h4>

<p>
Derivatives of functions can be declared explicitly using the derivative annotation, whereas a function can be defined as a partial derivative of another function using the der-operator in a short function definition.
</p>

<p>
A function declaration can have an annotation derivative specifying the derivative function. This can influence simulation time and accuracy and can be applied to both functions written in Modelica and to external functions. A derivative annotation can state that it is only valid under certain restrictions on the input arguments. These restrictions are defined using the following optional attributes: order (only a restriction if order &gt; 1, the default for order is 1), noDerivative, and zeroDerivative. The given derivative-function can only be used to compute the derivative of a function call if these restrictions are satisfied. There may be multiple restrictions on the derivative, in which case they must all be satisfied. The restrictions also imply that some derivatives of some inputs are excluded from the call of the derivative (since they are not necessary). A function may supply multiple derivative functions subject to different restrictions.
</p>

<p>
The inputs to the derivative function of order 1 are constructed as follows:
</p>

<ul>
<li> First are all inputs to the original function, and after all them we will
     in order append one derivative for each input containing reals.<br>&nbsp;</li>
<li> The outputs are constructed by starting with an empty list and then in
     order appending one derivative for each output containing reals.<br>&nbsp;</li>
<li> If the Modelica function call is a nth derivative (n>=1), i.e., this
     function call has been derived from an (n-1)th derivative, an
     annotation(order=n+1)=?,  specifies the (n+1)th derivative, and the
     (n+1)th derivative call is constructed as follows:<br>&nbsp;</li>
<li> The input arguments are appended with the (n+1)th derivative,
     which are constructed in order from the nth order derivatives.<br>&nbsp;</li>
<li> The output arguments are similar to the output argument for the
     nth derivative, but each output is one higher in derivative order.</li>
</ul>

<p>
Example: Given the declarations
</p>

<pre> function foo0
   ...
   input Real x;
   input Boolean linear;
   input ...;
   output Real y;
   ...
   annotation(derivative=foo1);
 end foo0;

 function foo1
   ...
   input Real x;
   input Boolean linear;
   input ...;
   input Real der_x;
   ...
   output Real der_y;
   ...
   annotation(derivative(order=2)=foo2);
 end foo1;

 function foo2
   ...
   input Real x;
   input Boolean linear;
   input ...;
   input Real der_x;
   ...;
   input Real der_2_x;
   ...
   output Real der_2_y;
   ...
</pre>

<p>
the equation
</p>

<pre>(...,y(t),...)=foo0(...,x(t),b,...);
</pre>

<p>
implies that:
<p>

<pre>(...,d y(t)/dt,...)=foo1(...,x(t),b,..., ...,d x(t)/dt,...);
(...,d^2 y(t)/dt^2,...)=foo2(...,x(t),b,...,d x(t)/dt,..., ...,d^2 x(t)/dt^2,...);
</pre>

<p>
An input or output to the function may be any simple type (Real, Boolean, Integer, String and enumeration types) or a record, provided the record does not contain both reals and non-reals predefined types. The function must have at least one input containing reals. The output list of the derivative function may not be empty.
</p>

<ul>
<li> zeroDerivative=input_var1<br>
    The derivative function is only valid if input_var1 is independent
    of the variables the function call is  differentiated with respect to
    (i.e., that the derivative of input_var1 is \"zero\").
    The derivative of input_var1 is excluded from the argument list of the derivative-function.
    Assume that function f takes a matrix and a scalar. Since the matrix argument is
    usually a parameter expression it is then useful to define the function
    as follows (the additional derivative = f_general_der is optional and
    can be used when the derivative of the matrix is non-zero).
<pre>function f \"Simple table lookup\"
  input Real x;
  input Real y[:, 2];
  output Real z;
  annotation(derivative(zeroDerivative=y) = f_der,
             derivative=f_general_der);
algorithm
  ...
end f;

function f_der \"Derivative of simple table lookup\"
  input Real x;
  input Real y[:, 2];
  input Real x_der;
  output Real z_der;
algorithm
  ...
end f_der;

function f_general_der \"Derivative of table lookup taking into account varying tables\"
  input Real x;
  input Real y[:, 2];
  input Real x_der;
  input Real y_der[:, 2];
  output Real z_der;
algorithm
  ...
end f_general_der;

</pre></li>

<li> noDerivative(input_var2 = f(input_var1, ...) )<br>
    The derivative function is only valid if the input argument input_var2
    is computed as f(input_var1, ...). The derivative of input_var2
    is excluded from the argument list of the derivative-function.
    Assume that function fg is defined as a composition f(x, g(x)).
    When differentiating f it is useful to give the derivative under the
    assumption that the second argument is defined in this way:
<pre>function fg
  input Real x;
  output Real z;
algorithm
   z := f(x, g(x));
end fg;

function f
  input Real x;
  input Real y;
  output Real z;
  annotation(derivative(noDerivative(y = g(x))) = f_der);
algorithm
  ...
end f;

function f_der
  input Real x;
  input Real x_der;
  input Real y;
  output Real z_der;
algorithm
  ...
end f_der;
</pre>
This is useful if g represents the major computational effort of fg).</li>
</ul>

</html>"));
    end derivative;
    class Dialog "Dialog"
      annotation(Documentation(info = "<html>
<p>
Define graphical layout of parameter menu
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>model</b> BodyShape
  ...
  <b>parameter</b> Boolean animation = true;
  <b>parameter</b> Modelica.SIunits.Length length \"Length of shape\"
     <b>annotation</b>(Dialog(enable = animation, tab = \"Animation\",
                        group = \"Shape definition\"));
  ...
<b>end</b> BodyShape;
</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>(Dialog(enable = parameter-expression, tab = \"tab\", group = \"group\"))
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
Defines the placement of the component or class parameter in a parameter dialog with optional tab and group specification. If enable is false, the input field may be disabled [and no input can be given]. \"Dialog\" is defined as:
</p>

<pre>   <b>record</b> Dialog
     <b>parameter</b> String  tab    = \"General\";
     <b>parameter</b> String  group  = \"Parameters\";
     <b>parameter</b> Boolean enable = <b>true</b>;
   <b>end Dialog;
</pre>

<p>
A parameter dialog is a sequence of tabs with a sequence of groups inside them.
</p>

</html>"));
    end Dialog;
    class Documentation "Documentation"
      annotation(Documentation(info = "<html>
<p>
Annotations for documentation
</p>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>documentation_annotation:
   <b>annotation</b>\"(\" Documentation \"(\" \"info\" \"=\" STRING
                            [\",\" \"revisions\" \"=\" STRING ] \")\" \")\"
</pre>

<h4><font color=\"#008000\">Description</font></h4>
<P>
The \"Documentation\" annotation can contain the \"info\" annotation giving a textual description, the \"revisions\" annotation giving a list of revisions and other annotations defined by a tool [The \"revisions\" documentation may be omitted in printed documentation]. How the tool interprets the information in \"Documentation\" is unspecified. Within a string of the \"Documentation\" annotation, the tags &lt;HTML&gt; and &lt;/HTML&gt; or &lt;html&gt; and &lt;/html&gt; define optionally begin and end of content that is HTML encoded. Links to Modelica classes may be defined with the HTML link command using scheme \"Modelica\", e.g.,
</p>

<pre>    &lt;a href=\"Modelica://MultiBody.Tutorial\"&gt;MultiBody.Tutorial&lt;/a&gt;
</pre>

<p>
Together with scheme \"Modelica\" the (URI)  fragment specifiers #diagram, #info, #text, #icon may be used to reference different layers. Example:
</p>

<pre>   &lt;a href=\"Modelica://MultiBody.Joints.Revolute#info\"&gt;Revolute&lt;/a&gt;
</pre>

</html>"));
    end Documentation;
    annotation(Documentation(info = "<html>
<p>
In this package annotations are described.
Annotations are intended for storing extra information about a model, such as graphics, documentation or versioning. A Modelica tool is free to define and use other annotations, in addition to those defined here. The only requirement is that any tool shall save files with all annotations from this chapter and all vendor-specific annotations intact. To ensure this, annotations must be represented with constructs according to the Modelica grammar. The Modelica language specification defines the semantic meaning if a tool implements any of these annotations.
</p>

</html>"));
    class DynamicSelect "DynamicSelect"
      annotation(Documentation(info = "<html>
<p>
Define schematic animation of diagram layer
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<blockquote>
<p>
The level of a tank is animated by a rectangle expanding in vertical direction and its color depending on a variable overflow:
</p>

<pre><b>annotation</b>(
  Icon(graphics={Rectangle(
    extent=<b>DynamicSelect</b>({{0,0},{20,20}},{{0,0},{20,level}}),
    fillColor=<b>DynamicSelect</b>({0,0,255},
                            <b>if</b> overflow <b>then</b> {255,0,0} <b>else</b> {0,0,255}))}
);
</pre></blockquote>


<h4><font color=\"#008000\">Description</font></h4>

<p>
Any value (coordinates, color, text, etc.) in graphical annotations can be dependent on class variables using the DynamicSelect expression. DynamicSelect has the syntax of a function call with two arguments, where the first argument specifies the value of the editing state and the second argument the value of the non-editing state. The first argument must be a literal expression
and this value is used for the annotation when editing and/or browsing the diagram layer.
The second argument may contain references to variables to enable a dynamic behavior
and the actual value is used for the annotation for schematic animation
of the diagram layer, e.g., after a simulation.
</p>

</html>"));
    end DynamicSelect;
    class Evaluate "Evaluate"
      annotation(Documentation(info = "<html>
<p>
Annotation for code generation (evaluate parameter value)
</p>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>\"(\" Evaluate \"=\" ( <b>false</b> | <b>true</b> ) \")
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
Has only an effect for a declaration with the prefix parameter.
</p>

<p>
If Evaluate = true, the model developer proposes to utilize the value for the symbolic processing. In that case, it is not possible to change the parameter value after symbolic pre-processing.
</p>

<p>
If Evaluate = false, the model developer proposes to not utilize the value of the corresponding parameter for the symbolic processing.
</p<

<p>
Evaluate is for example used for axis of rotation parameters in the Modelica.Mechanics.MultiBody library in order to improve the efficiency of the generated code
</p>

</html>"));
    end Evaluate;
    class experiment "experiment"
      annotation(Documentation(info = "<html>
<p>
Define default experiment parameters
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>annotation</b>(experiment(StartTime=0, StopTime=5, Tolerance=1e-6))
</pre>


<h4><font color=\"#008000\">Syntax</font></h4>

<pre>experiment_annotation:
   <b>annotation</b>\"(\" \"experiment\" \"(\" [experimentOption] {, experimentOption}] \")\"

experimentOption:
   StartTime  \"=\" [\"+\" | \"-\"] UNSIGNED_NUMBER |
   StopTime   \"=\" [\"+\" | \"-\"] UNSIGNED_NUMBER |
   Tolerance  \"=\" UNSIGNED_NUMBER
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
The experiment annotation defines the default start time (StartTime) in [s], the default stop time (StopTime) in [s], and the default relative integration tolerance (Tolerance) for simulation experiments to be carried out with the model or block at hand.
</p>

</html>"));
    end experiment;
    class HideResult "HideResult"
      annotation(Documentation(info = "<html>
<p>
Annotation for code generation (hide result)
</p>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>\"(\" HideResult \"=\" ( <b>false</b> | <b>true</b> ) \")
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
HideResult = true defines that the model developer proposes to not show the simulator results of the corresponding component [e.g., it will not be possible to plot this variable].
</p>

<p>
HideResult = false defines that the developer proposes to show the corresponding component [if a variable is declared in a protected section, a tool might not include it in a simulation result. By setting HideResult = false, the modeler would like to have the variable in the simulation result, even if in the protected section].
</p>

<p>
HideResult is for example used in the connectors of the Modelica.StateGraph library to not show variables to the modeler that are of no interest to him and would confuse him.
</p>

</html>"));
    end HideResult;
    class Inline "Inline"
      annotation(Documentation(info = "<html>
<p>
Annotation for code generation (inline function body)
</p>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>\"(\" Inline \"=\" ( <b>false</b> | <b>true</b> ) \")
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
Has only an effect within a function declaration.
</p>

<p>
If \"Inline = true\", the model developer proposes to inline the function.
This means, that the body of the function is included at all places where the function is called.
</p>

<p>
If \"Inline = false\", the model developer proposes to not inline the function.
</p>

<p>
Inline = true is for example used in Modelica.Mechanics.MultiBody.Frames and in functions of Modelica.Media to have no overhead for function calls such as resolving a vector in a different coordinate system and at the same time the function can be analytically differentiated, e.g., for index reduction needed for mechanical systems.
</p>

</html>"));
    end Inline;
    class LateInline "LateInline"
      annotation(Documentation(info = "<html>
<p>
Annotation for code generation (inline function body after symbolic processing)
</p>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>\"(\" LateInline \"=\" ( <b>false</b> | <b>true</b> ) \")
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
Has only an effect within a function declaration.
</p>

<p>
If \"LateInline = true\", the model developer proposes to inline the function after all symbolic transformations have been performed, but before common subexpression elimination takes place.
</p>

<p>
If \"LateInline = false\", the model developer proposes to not inline the function after symbolic transformations have been performed.
</p>

<p>
This annotation is for example used in Modelica.Media.Water.IF97_Utilities.T_props_ph to provide in combination with common subexpression elimination the automatic caching of function calls. Furthermore, it is used in order that a tool is able to propagate specific enthalpy over connectors in the Modelica_Fluid library.
</p>

</html>"));
    end LateInline;
    class missingInnerMessage "missingInnerMessage"
      annotation(Documentation(info = "<html>
<p>
Warning message, if inner declaration is missing
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>model</b> World
  <b>annotation</b>(defaultComponentName     = \"world\",
             defaultComponentPrefixes = \"inner replaceable\",
             missingInnerMessage      = \"The World object is missing\");
  ...
<b>end</b> World;
</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>\"(\" missingInnerMessage \"=\" STRING \")\"
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
When an outer component of the class does not have a corresponding inner component, the string message may be used as a diagnostic message.
</p>

</html>"));
    end missingInnerMessage;
    class PreferredView "preferredView"
      annotation(Documentation(info = "<html>
<p>
Define default view when selecting class
</p>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>preferred view_annotation:
   <b>annotation</b>\"(\" preferredView \"=\" (\"info\" | \"diagram\" | \"text\") \")\"
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
The preferredView annotation defines the default view when selecting the class. info means info layer, i.e., the documentation of the class, diagram means diagram layer and text means the Modelica text layer.
</p>

</html>"));
    end PreferredView;
    class smoothOrder "smoothOrder"
      annotation(Documentation(info = "<html>
<p>
Define differentiability of function body
</p>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>\"(\" smoothOrder \"=\" UNSIGNED_INTEGER \")\"
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
This annotation has only an effect within a function declaration.
</p>

<p>
smoothOrder defines the minimum number of differentations of the function, in order that all of the differentiated outputs are continuous provided all input arguments and their derivatives up to order smoothOrder are continuous.
</p>

<p>
This means that the function is at least C<sup>smoothOrder</sup>. smoothOrder = 1 means that the function can be differentiated at least once in order that all output arguments are still continuous, provided the input arguments are continuous. If a tool needs the derivative of a function, e.g., for index reduction or to compute an analytic Jacobian, the function can be differentiated analytically at least smoothOrder times.
</p>

</html>"));
    end smoothOrder;
    class version "version"
      annotation(Documentation(info = "<html>
<p>
Define version information of package
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>package</b> Modelica
  <b>annotation</b>(version=\"2.1\",
             conversion(noneFromVersion=\"2.1 Beta 1\",
                        from(version=\"1.5\",
                             script=\"convertFromModelica1_5.mos\")));
  ...
<b>end</b> Modelica;

<b>model</b> A
  <b>annotation</b>(version=\"1.0\",
     uses(Modelica(version=\"1.5\")));
  ...
<b>end</b> A;

<b>model</b> B
  <b>annotation</b>(uses(Modelica(version=\"2.1 Beta 1\")));
  ...
<b>end</b> B;
</pre>

<p>
In this example the model A uses an older version of the Modelica library and can be upgraded using the given script, and model B uses an older version of the Modelica library but no changes are required when upgrading.
</p>



<h4><font color=\"#008000\">Description</font></h4>

<p>
Version numbers are of the forms:
</p>

<ul>
<li> Main release versions:
     <pre>\"\"\" UNSIGNED_INTEGER { \".\" UNSIGNED_INTEGER } \"\"\"</pre>
     Example: <code>\"2.1\"</code><br>&nbsp;</li>

<li> Pre-release versions:
     <pre>\"\"\" UNSIGNED_INTEGER { \".\" UNSIGNED_INTEGER } \" \" {S-CHAR} \"\"\"</pre>
     Example: <code>\"2.1 Beta 1\"</code><br>&nbsp;</li>

<li> Un-ordered versions:
     <pre> \"\"\" NON-DIGIT {S-CHAR} \"\"\" </pre>
     Example: <code>\"Test 1\"</code></li>
</ul>

<p>
The main release versions are ordered using the hierarchical numerical names, and follow the corresponding pre-release versions. The pre-release versions of the same main release version are internally ordered alphabetically.
</p>

<p>
In a top-level class, the version number and the dependency to earlier versions of this class are defined using one or more of the following annotations:
</p>

<ul>
<li> <code>version = CURRENT-VERSION-NUMBER</code><br>
     Defines the version number of the model or package.
     All classes within this top-level class have this version number.<br>&nbsp;</li>

<li> <code>conversion ( noneFromVersion = VERSION-NUMBER)</code><br>
     Defines that user models using the VERSION-NUMBER can be upgraded to
     the CURRENT-VERSION-NUMBER of the current class without any changes.<br>&nbsp;</li>

<li> <code>conversion ( from (version = VERSION-NUMBER, script = \"?\") ) </code><br>
     Defines that user models using the VERSION-NUMBER can be upgraded to
     the CURRENT-VERSION-NUMBER of the current class by applying the given
     script. The semantics of the conversion script is not defined.<br>&nbsp;</li>

<li> <code>uses(IDENT (version = VERSION-NUMBER) )</code><br>
     Defines that classes within this top-level class uses version
     VERSION-NUMBER of classes within the top-level class IDENT.
     The annotations uses and conversion may contain several different sub-entries.<li>
</ul>

<p>
A top-level class, IDENT, with version VERSION-NUMBER can be stored in one
of the following ways in a directory given in the MODELICAPATH:
</p>

<ul>
<li> The file IDENT \".mo\"<br>
     Example: Modelica.mo</li>
<li> The file IDENT \" \" VERSION-NUMBER \".mo\"<br>
     Example: Modelica 2.1.mo</li>
<li> The directory IDENT<br>
     Example: Modelica</li>
<li> The directory IDENT \" \" VERSION-NUMBER<br>
     Example: Modelica 2.1</li>
</ul>

<p>
This allows a tool to access multiple versions of the same package.
</p>

</html>"));
    end version;
    class unassignedMessage "unassignedMessage"
      annotation(Documentation(info = "<html>
<p>
Error message, if variable is not assigned
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>connector</b> Frame \"Frame of a mechanical system\"
    ...
  <b>flow</b> Modelica.SIunits.Force f[3] <b>annotation</b>(unassignedMessage =
\"All Forces cannot be uniquely calculated. The reason could be that the
mechanism contains a planar loop or that joints constrain the same motion.
For planar loops, use in one revolute joint per loop the option
PlanarCutJoint=true in the Advanced menu.
\");
<b>end</b> Frame;
</pre>


<h4><font color=\"#008000\">Syntax</font></h4>

<pre>   <b>annotation</b>\"(\" unassignedMessage \"=\" STRING \")\"
</pre>


<h4><font color=\"#008000\">Description</font></h4>

<p>
When the variable to which this annotation is attached in the declaration cannot be computed due to the structure of the equations, the string message can be used as a diagnostic message. When using BLT partitioning, this means if a variable \"a\" or one of its aliases \"b = a\", \"b = -a\", cannot be assigned, the message is displayed. This annotation is used to provide library specific error messages.
</p>

</html>"));
    end unassignedMessage;
  end Annotations;
  package Classes "Classes (model, function, ...)"
    class Block "block"
      annotation(Documentation(info = "<html>
<p>
Define specialized class <i>block</i>
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>block</b> Integrator
  <b>input</b> Real u;
  <b>output</b> Real y;
<b>protected</b>
  Real x;
<b>equation
  der</b>(x) = u;
  y = x;
<b>end</b> Integrator;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>   [ <B>encapsulated</B> ][ <B>partial </B>] <B>block</B>
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment</PRE>

<p>See Modelica Language Specification for further details.</p>

<h4><font color=\"#008000\">Description</font></h4>
<P>
A block class is the same as a model class
with the restriction that each connector component of a block must
have prefixes input and/or output for all connector variables.
The purpose is to model input/output blocks of block diagrams.
Due to the restrictions on input and output prefixes,
connections between blocks are only possible according
to block diagram semantic.
</P>
</html>"));
    end Block;
    class Class "class"
      annotation(Documentation(info = "<html>
<p>
Define class
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>class</b> MyTable
  <b>extends</b> ExternalObject;
  <b>function</b> constructor
     ...
  <b>end</b> constructor;

  <b>function</b> destructor
     ...
  <b>end</b> destructor;
<b>end</b> MyTable;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>
<PRE>   [ <B>encapsulated</B> ][ <B>partial </B>] <B>class</B>
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment</PRE>

<p>See Modelica Language Specification for further details.</p>

<h4><font color=\"#008000\">Description</font></h4>

<p>
The keyword class is used to define general classes (without any restrictions).
It is identical to the keyword model.
In most cases, it is recommended to use specialized classes as <b>block</b>,
<b>connector</b>, <b>model</b>, <b>package</b>, <b>record</b>, <b>function</b>or <b>type</b>.
\"class\" should only be used to define ExternalObjects.
</p>
</html>"));
    end Class;
    class Connector "connector"
      annotation(Documentation(info = "<html>
<p>
Define specialized class <i>connector</i>
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>connector</b> flange
  Modelica.SIunits.Angle phi;
  <b>flow</b> Modelica.SIunits.Torque tau;
<b>end</b> flange;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>
<PRE>   [ <B>encapsulated</B> ][ <B>partial </B>] <B>connector</B>
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment</PRE>

<p>See Modelica Language Specification for further details.</p>

<h4><font color=\"#008000\">Description</font></h4>
<P>The keyword connector is used to define connectors, which are used
in connect statements. In connectors, no equations are allowed in the
definition or in any of its components.
With respect to \"class\", it is enhanced to allow connect(..) to components
of connector classes.
</P>
</html>"));
    end Connector;
    class Function "function"
      annotation(Documentation(info = "<html>
<p>
Define specialized class <i>function</i>
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>function</b> si
  <b>input</b> Real x;
  <b>output</b> Real y;
<b>algorithm</b>
  y = <b>if abs</b>(x) &lt; Modelica.Constants.eps <b>then</b> 1 <b>else</b> Modelica.Math.sin(x)/x;
<b>end</b> si;</pre>

<p align=\"center\"><img src=\"../Images/function.png\" width=\"400\" height=\"280\" alt=\"Simulation result\"></p>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>   [ <B>encapsulated</B> ][ <B>partial </B>] <B>function</B>
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment</PRE>

<p>See Modelica Language Specification for further details.</p>

<h4><font color=\"#008000\">Description</font></h4>

<P>The keyword function is used to define functions as known from programming
languages. Each part of a function interface must
either have causality equal to input or output. A function may not be used in connections.
In functions, no equations or initial algorithm and at most
one algorithm clause are allowed. Calling a function requires
either an algorithm clause or an external function interface.</p>

<p>
The syntax and semantics of a function have many similarities to those of the block
specialized class. A function has many of the properties of a general class,
e.g., being able to inherit other functions, or to redeclare or modify
elements of a function declaration.
</p>

<p>
Modelica functions have the following restrictions compared to a
general Modelica class:
</p>

<ul>
<li> Each input formal parameter of the function must be
     prefixed by the keyword input, and each result formal parameter
     by the keyword output. All public variables are formal parameters.</li>

<li> Input formal parameters are read-only after being bound to the
     actual arguments or default values, i.e., they may not be assigned
     values in the body of the function.</li>

<li> A function may not be used in connections, may have no equations,
     may have no initial algorithm, and can have at most one algorithm
     section, which, if present, is the body of the function.</li>

<li> A function may have zero or one external function interface, which,
     if present, is the external definition of the function. </li>

<li> For a function to be called in a simulation model, it must have
     either an algorithm section or an external function interface as
     its body, and it may not be partial.</li>

<li> A function cannot contain calls to the Modelica built-in operators
     der, initial, terminal, sample, pre, edge, change, reinit, delay,
     cardinality, to the operators of the built-in package Connections,
     and is not allowed to contain when-statements.</li>

<li> The dimension sizes not declared with (:) of each array result or
     array local variable [i.e., a non-input components] of a function must
     be either given by the input formal parameters, or given by constant
     or parameter expressions, or by expressions containing combinations
     of those</li>

<li> The local variables of a function are not automatically initialized to
     the implicit default values of the data type [(e.g., 0.0 for Real)
     for performance reasons. It is the responsibility of the user to
     provide explicit defaults or to define the values of such variables
     before they are referenced.]</li>

<li> Components of a function will inside the function behave as though
     they had discrete-time variability.</li>
</ul>

<p>
Modelica functions have the following enhancements compared to a general Modelica class:
</p>

<ul>
<li> A function may be called using the conventional positional calling syntax
     for passing arguments.</li>

<li> A function can be recursive.</li>

<li> A formal parameter or local variable may be initialized
     through an assignment (:=) of a default value in its declaration.
     Initialization through an equation is not possible.</li>

<li> A function is dynamically instantiated when it is called rather than
     being statically instantiated by an instance declaration,
     which is the case for other kinds of classes. </li>

<li> A function may have an external function interface specifier as its body.</li>

<li> A function may have a return statement in its algorithm section body.</li>

<li> A function allows dimension sizes declared with (:) to be resized
     for non-input array variables (so the actual dimension need not to be known when
     the function is translated).</li>.
</ul>


</html>"));
    end Function;
    class Model "model"
      annotation(Documentation(info = "<html>
<p>
Define specialized class <i>model</i>
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>model</b> SlidingMass
  <b>parameter</b> Modelica.SIunits.Mass m=1;
  <b>parameter</b> Modelica.SIunits.Force f=1;
  Modelica.SIunits.Position s;
  Modelica.SIunits.Velocity v;
  Modelica.SIunits.Acceleration a;
<b>equation</b>
  <b>der</b>(s) = v;
  <b>der</b>(v) = a;
  m*a = f;
<b>end</b> SlidingMass;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>
<PRE>   [ <B>encapsulated</B> ][ <B>partial </B>] <B>model</B>
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment</PRE>

<p>See Modelica Language Specification for further details.</p>

<h4><font color=\"#008000\">Description</font></h4>
<P>
The keyword model is identical to the keyword class, i.e.,
no restrictions and no enhancements.
</P>
</html>"));
    end Model;
    class Package "package"
      annotation(Documentation(info = "<html>
<p>
Define specialized class <i>package</i>
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>package</b> Library
  <b>constant</b> Real k = 0.1;

  <b>type</b> X = Real(min=0);

  <b>model</b> A
    ...
  <b>end</b> A;

  <b>model</b> B
    ...
  <b>end</b> B;
<b>end</b> Library;</pre>


<h4><font color=\"#008000\">Syntax</font></h4>
<PRE>   [ <B>encapsulated</B> ][ <B>partial </B>] <B>package</B>
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment</PRE>

<p>See Modelica Language Specification for further details.</p>

<h4><font color=\"#008000\">Description</font></h4>
<P>May only contain declarations of classes and constants.
   Enhanced to allow import of elements of packages.</P>

</html>"));
    end Package;
    class Record "record"
      annotation(Documentation(info = "<html>
<p>
Define specialized class <i>record</i>
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre>  <b>record</b> States
    Modelica.SIunits.Position s;
    Modelica.SIunits.Velocity v;
  <b>end</b> States;

  <b>record</b> System
    <b>parameter</b> Modelica.SIunits.Mass m=1;
    <b>parameter</b> Modelica.SIunits.Force f=1;
    Modelica.SIunits.Acceleration a;
    States states;
  <b>end</b> System;

  <b>model</b> SlidingMass
    System sys;
  <b>equation</b>
    <b>der</b>(sys.states.s) = sys.states.v;
    <b>der</b>(sys.states.v) = sys.a;
    sys.m*sys.a = sys.f;
  <b>end</b> SlidingMass;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>
<PRE>   [ <B>encapsulated</B> ][ <B>partial </B>] <B>record</B>
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment</PRE>

<p>See Modelica Language Specification for further details.</p>

<h4><font color=\"#008000\">Description</font></h4>

<p>
The keyword record is used to define records which are generally used in
order to group variables. Only public sections are allowed in the definition
or in any of its components (i.e., equation, algorithm, initial equation,
initial algorithm and protected sections are not allowed). May not be used in
connections. The elements of a record may not have prefixes input, output, inner, outer,
or flow.  Enhanced with implicitly available record constructor function.
Additionally, record components can be used as component references in
expressions and in the left hand side of assignments, subject to
normal type compatibility rules.
</p>

</html>"));
    end Record;
    class Type "type"
      annotation(Documentation(info = "<html>
<p>
Define specialized class <i>type</i>
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>type</b> R0Plus = Real(min=0);</pre>

<h4><font color=\"#008000\">Syntax</font></h4>
<PRE>   [ <B>encapsulated</B> ][ <B>partial </B>] <B>type</B>
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment</PRE>

<p>See Modelica Language Specification for further details.</p>

<h4><font color=\"#008000\">Description</font></h4>
<p>The keyword type is used to define types, which may only be extensions to the predefined types, enumerations, array of type, or classes extending from type.
Enhanced to extend from predefined types [No other specialized class has this property].
</p>

</html>"));
    end Type;
    annotation(Documentation(info = "<html>
<p>
In this package specialized kinds of classes (earlier known as restricted classes) are
described. They have the properties of a general class, apart from restrictions.
Moreover, they have additional properties called enhancements.
</p>

</html>"));
  end Classes;
  package Operators "Operators (+, der, size, ...)"
    class ElementaryOperators "Elementary operators (+, >, or, ..)"
      annotation(Documentation(info = "<html>
<p>
Elementary operators are overloaded and operate on variables
of type Real, Integer, Boolean, and String, as well as on scalars
or arrays.
</p>
<h4><font color=\"#008000\">Syntax</font></h4>

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td colspan=\"3\"><b>Arithmethic Operators (operate on Real, Integer scalars or arrays)</b></td>
  <tr><td><i>Operators</i></td>
      <td><i>Example</i></td>
      <td><i>Description</i></tr></td>
      </tr>
  <tr><td>+, -, .+, .-</td>
      <td>a + b<br>
          a .+ b</td>
      <td>addition and subtraction; element-wise on arrays</td></tr>

  <tr><td>*</td>
      <td>a * b</td>
      <td>multiplication;<br>
          scalar*array: element-wise multiplication<br>
          vector*vector: element-wise multiplication (result: scalar)<br>
          matrix*matrix: matrix product <br>
          vector*matrix: row-matrix*matrix (result: vector)<br>
          matrix*vector: matrix*column-matrix (result: vector)</td></tr>
  <tr><td>/</td>
      <td>a / b</td>
      <td>division of two scalars or an array by a scalar;<br>
          division of an array by a scalar is defined element-wise.<br>
          The result is always of real type. In order to get integer <br>
          division with truncation use the function div.</td></tr>

  <tr><td>^</td>
      <td>a^b</td>
      <td>scalar power or integer power of a square matrix</td></tr>

  <tr><td>.*, ./, .^</td>
      <td>a .* b</td>
      <td>element-wise multiplication, division and exponentation of
          scalars and arrays</td></tr>

  <tr><td>=</td>
      <td>a * b = c + d</td>
      <td>equal operator of an equation; element-wise on arrays</td></tr>
  <tr><td>:=</td>
      <td>a := c + d</td>
      <td>assignment operator; element-wise on arrays</td></tr>
</table>

&nbsp;

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td colspan=\"3\"><b>Relational Operators (operate on Real, Integer, Boolean, String scalars)</b></td>
  <tr><td><i>Operators</i></td>
      <td><i>Example</i></td>
      <td><i>Description</i></tr></td>
      </tr>
  <tr><td>==</td>
      <td>a == b</td>
      <td>equal; for strings: identical characters</td></tr>
  <tr><td>&lt;&gt;</td>
      <td>a &lt;&gt; b</td>
      <td>not equal; for strings: a is lexicographically less than b</td></tr>
  <tr><td>&lt;</td>
      <td>a &lt; b</td>
      <td>less than</td></tr>
  <tr><td>&lt;=</td>
      <td>a &lt;= b</td>
      <td>less than or equal</td></tr>
  <tr><td>&gt;</td>
      <td>a &gt; b</td>
      <td>greater than</td></tr>
  <tr><td>&gt;=</td>
      <td>a &gt;= b</td>
      <td>greater than or equal</td></tr>
</table>

&nbsp;

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td colspan=\"3\"><b>Boolean Operators (operate on scalars or element-wise on arrays)</b></td>
  <tr><td><i>Operators</i></td>
      <td><i>Example</i></td>
      <td><i>Description</i></tr></td>
      </tr>
  <tr><td><b>and</b></td>
      <td>a <b>and</b> b</td>
      <td>logical and</td></tr>
  <tr><td><b>or</b></td>
      <td>a <b>or</b> b</td>
      <td>logical or</td></tr>
  <tr><td><b>not</b></td>
      <td><b>not</b> a</td>
      <td>logical not</td></tr>
</table>

&nbsp;

<table border=1 cellspacing=0 cellpadding=2>
  <tr><td colspan=\"3\"><b>Other Operators</b></td>
  <tr><td><i>Operators</i></td>
      <td><i>Example</i></td>
      <td><i>Description</i></tr></td>
      </tr>
  <tr><td>[..]</td>
      <td>[1,2;3,4]</td>
      <td>Matrix constructor; \",\" separates rows, \";\" separates columns</td></tr>
  <tr><td>{..}</td>
      <td>{{1,2}, {3,4}}</td>
      <td>Array constructor; every {..} adds one dimension</td></tr>
  <tr><td>\"...\"</td>
      <td>\"string value\"<br>
          \"string \"value\"\"</td>
      <td>String literal (\" is used inside a string for \")</td></tr>
  <tr><td>+</td>
      <td>\"abc\" + \"def\"</td>
      <td>Concatenation of string scalars or arrays</td></tr>
</table>

<p><span >Operator
precedence determines the order
of evaluation of operators in an expression. An operator with higher
precedence
is evaluated before an operator with lower precedence in the same
expression.</span></p>
<p><span >The
following table presents all
the expression operators in order of precedence from highest to lowest.
All operators are binary except exponentiation, the postfix
operators and
those shown as unary together with <i>expr</i>, the
conditional operator, the
array construction operator {} and concatenation operator [ ], and the
array
range constructor which is either binary or ternary</span><span
 >. Operators with the same precedence occur at
the same line of the
table: </span></p>

<table border=\"1\" cellpadding=\"0\" cellspacing=\"0\">
  <tbody>
    <tr>
      <td valign=\"top\" width=\"180\">
      <p><i>Operator Group</i></p>
      </td>
      <td valign=\"top\">
      <p><i>Operator Syntax</i></p>
      </td>
      <td valign=\"top\">
      <p><i><span>Examples</span></i></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span
 >postfix array index operator</span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span>[]</span></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span>arr[index]</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span>postfix access operator</span></p>
      </td>
      <td valign=\"top\">
      <p><span1 class=\"CODE\"><span>. </span></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span>a.b</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span>postfix function call</span></p>
      </td>
      <td valign=\"top\">
      <p><i><span>funcName</span></i><span
 >(<i>function-arguments</i>)</span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span>sin(4.36)</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span>array construct/concat</span></p>
      </td>
      <td

 valign=\"top\">
      {<i>expressions</i>}<br>
      [<i>expressions</i>]<br>
      [<i>expressions</i>; <i>expressions</i>...]
      </td>
      <td

 valign=\"top\">
      <p><span
 class=\"CODE\"><span
 >{2,3}&nbsp; [5,6]</span></span></p>
      <p><span
 class=\"CODE\"><span
 >[2,3; 7,8]</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span>exponentiation</span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span>^</span></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span>2^3</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p>
<span>multiplicative and<br> array elementwise multiplicative</span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span>*</span></span><span class=\"CODE\"><span
  >&nbsp;&nbsp;/&nbsp;
.*&nbsp;&nbsp; ./</span></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span>2*3&nbsp;&nbsp; 2/3<br>
[1,2;3,4].*[2,3;5,6]</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p>additive and<br> array elementwise additive</p>
      </td>
      <td valign=\"top\">
      <p><spanclass=\"CODE\"><span>+</span></span><span class=\"CODE\"><span>&nbsp;&nbsp;-</span></span><span
 class=\"CODE\"><span>&nbsp;&nbsp;+</span></span><i><span>expr</span></i><span >&nbsp;
      </span><span class=\"CODE\"><span
  >-</span></span><i><span
 >expr<br>
      </span></i><span >.+&nbsp;
.</span><span class=\"CODE\"><span
  >-</span></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span>a+b</span></span><span>,</span><span class=\"CODE\"><span>&nbsp;
a-b, +a, -a</span></span></p>
      <p><span class=\"CODE\"><span
 >[1,2;3,4].+[2,3;5,6]</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span >relational</span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >&lt;</span></span><span
 class=\"CODE\"><span
 >&nbsp;&nbsp;&lt;=</span></span><span
 class=\"CODE\"><span
 >&nbsp;&nbsp;&gt;</span></span><span
 class=\"CODE\"><span
 >&nbsp;&nbsp;&gt;=</span></span><span
 class=\"CODE\"><span
 >&nbsp;&nbsp;==</span></span><span
 class=\"CODE\"><span
 >&nbsp;&nbsp;&lt;&gt;</span></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >a&lt;b</span></span><span
 >,</span><span class=\"CODE\"><span
  >&nbsp;
a&lt;=b, a&gt;b, ...</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span
 class=\"CODE\"><span
 >...</span></span></p>
      </td>
      <td valign=\"top\">
      <p><span
 >&nbsp;</span></p>
      </td>
      <td valign=\"top\">
      <p><span
 >&nbsp;</span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span >unary negation</span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >not</span></span><span
 class=\"CODE\"><span
 >&nbsp;</span></span><i><span
 >expr</span></i></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >not b1</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span >logical and</span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >and</span></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >b1 and b2</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span >logical or</span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >or</span></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >b1 or&nbsp; b2</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span >array range</span></p>
      </td>
      <td valign=\"top\">
      <p><i><span >expr</span></i><span >&nbsp;
      </span><span class=\"CODE\"><span
  >:</span></span><span
 >&nbsp; <i>expr</i>&nbsp; </span><span
 class=\"CODE\"><span
 >:</span></span><span >&nbsp;
      <i>expr</i></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >1:5</span></span><span
 >,</span><span class=\"CODE\"><span
  >
start:step:stop</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span >conditional</span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >if</span></span><span
 >&nbsp;&nbsp;<i>expr</i>&nbsp;
      </span><span class=\"CODE\"><span
  >then</span></span><span
 >&nbsp;&nbsp;<i>expr</i>&nbsp;
      </span><span class=\"CODE\"><span
  >else</span></span><span
 >&nbsp;&nbsp;<i>expr</i></span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >if b then 3 else x</span></span></p>
      </td>
    </tr>
    <tr>
      <td valign=\"top\">
      <p><span >named argument</span></p>
      </td>
      <td valign=\"top\">
      <p><i>ident&nbsp;</i><span class=\"CODE\">=</span><span >&nbsp;
      <i>expr</i>&nbsp; </span></p>
      </td>
      <td valign=\"top\">
      <p><span class=\"CODE\"><span
 >x = 2.26</span></span></p>
      </td>
    </tr>
  </tbody>
</table>
<p><span >The
conditional operator may also include
elseif-clauses. Equality </span><span class=\"CODE\"><span
  >=</span></span><span
 > and assignment </span><span
 class=\"CODE\"><span
 >:=</span></span><span
 > are not expression operators since they are
allowed only in
equations and in assignment statements respectively. All binary
expression
operators are left associative.</span></p>

<p><span >
Note, the unary minus and plus in Modelica
is slightly different than in Mathematica (Mathematica is a registered trademark
of Wolfram Research Inc.) and in MATLAB (MATLAB is a registered trademark of MathWorks Inc.),
since the following expressions are illegal (whereas in
Mathematica and in MATLAB these are valid expressions):
</p>

<pre>  2*-2   // = -4 in Mathematica/MATLAB; is illegal in Modelica
  --2    // =  2 in Mathematica/MATLAB; is illegal in Modelica
  ++2    // =  2 in Mathematica/MATLAB; is illegal in Modelica
  2--2   // =  4 in Mathematica/MATLAB; is illegal in Modelica
</pre>

</html>"));
    end ElementaryOperators;
    annotation(Documentation(info = "<html>
<p>
In this chapter <b>operators</b> of Modelica are documented.
Elementary operators, such as \"+\" or \"-\" are overloaded and
operate on scalar and array variables. Other operators
have the same syntax as a
<a href=\"Modelica://ModelicaReference.Classes.Function\">Modelica function</a>
call. However, they do not behave as a Modelica function,
either because the result depends not only on the input arguments but
also on the status of the simulation (such as \"pre(..)\"), or
the function operates on input arguments of different types
(such as \"String(..)\"). Neither of these \"functions\"
can be defined with a \"standard\" Modelica function and are
therefore builtin operators of the Modelica language
(with exception of the basic mathematical functions,
sin, cos, tan, asin, acos, atan, atan2, sinh, cosh, tanh, exp,
log, log10 that are provided for convenience as built-in functions).
</p>
</html>"));
    class Abs "abs"
      annotation(Documentation(info = "<html>
<p>
Absolute value of Real or Integer variable.
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>abs</b>(v)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Is expanded into &quot;noEvent(<B>if </B>v &ge; 0
<B>then</B> v <B>else</B> -v)&quot;. Argument v
needs to be an Integer or Real expression. </P>
<h4><font color=\"#008000\">Examples</font></h4>
<pre>
  <b>abs</b>({-3, 0, 3})
 = {3, 0, 3}</pre>
</html>"));
    end Abs;
    class Acos "acos"
      annotation(Documentation(info = "<html>
<p>
Trigonometric inverse cosine function
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>acos</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>

<p>Returns the inverse of cos of u, with -1 &le; u &le; +1.
Argument u needs to be an Integer or Real expression.</p>

<p>
The acos function can also be accessed as Modelica.Math.acos.
</p

<p>
<img src=\"../Images/acos.png\">
</p>



<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>acos</b>(0)
 = 1.5707963267949</pre>
</html>"));
    end Acos;
    class Asin "asin"
      annotation(Documentation(info = "<html>
<p>
Trigonometric inverse sine function
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>asin</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>

<p>Returns the inverse of sin of u, with -1 &le; u &le; +1.
Argument u needs to be an Integer or Real expression.</p>

<p>
The asin function can also be accessed as Modelica.Math.asin.
</p

<p>
<img src=\"../Images/asin.png\">
</p>



<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>asin</b>(0)
 = 0.0</pre>
</html>"));
    end Asin;
    class Assert "assert"
      annotation(Documentation(info = "<html>
<p>
Trigger error and print error message if assertion condition is not fulfilled
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>assert</b>(condition, message, level = AssertionLevel.error)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>The boolean expression <i>condition</i> shall be true for successful model evaluations.
Otherwise, an error occurs using the string expression <i>message</i>
as error message.</p>
<P>If the condition of an assert statement is true, message is not
evaluated and the procedure call is ignored. If the condition
evaluates to false different actions are taken depending on the level input:
</p>

<ul>
<li> level = AssertionLevel.error:<br>
     The current evaluation is aborted. The simulation may
     continue with another evaluation [e.g., with a shorter step-size,
     or by changing the values of iteration variables].
     If the simulation is aborted, message indicates the cause of the
     error. Failed assertions takes precedence over successful
     termination, such that if the model first triggers the
     end of successful analysis by reaching the stop-time
     or explicitly with terminate(), but the evaluation with
     terminal()=true triggers an assert, the analysis failed. </li>
<li> level = AssertionLevel.warning:<br>
     The current evaluation is not aborted. message indicates
     the cause of the warning [It is recommended to report the
     warning only once when the condition becomes false, and it is
     reported that the condition is no longer violated when the
     condition returns to true. The assert(..) statement shall
     have no influence on the behavior of the model.
     For example, by evaluating the condition and reporting the
     message only after accepted integrator steps. condition
     needs to be implicitly treated with noEvent(..) since
     otherwise events might be triggered that can lead to slightly
     changed simulation results].</li>
</ul>

<p>
The AssertionLevel.error case can be used to avoid evaluating a model outside its limits of validity; for instance, a function to compute the saturated liquid temperature cannot be called with a pressure lower than the triple point value.
The AssertionLevel.warning case can be used when the boundary of validity is not hard: for instance, a fluid property model based on a polynomial interpolation curve might give accurate results between temperatures of 250 K and 400 K, but still give reasonable results in the range 200 K and 500 K. When the temperature gets out of the smaller interval, but still stays in the largest one, the user should be warned, but the simulation should continue without any further action. The corresponding code would be
</p>
<pre>  <b>assert</b>(T &gt; 250 and T &lt; 400, \"Medium model outside full accuracy range\",
         AssertionLevel.warning);
  <b>assert</b>(T &gt; 200 and T &lt; 500, \"Medium model outside feasible region\");
</pre>

<h4><font color=\"#008000\">Examples</font></h4>
<pre>  <b>parameter</b> Real upperLimit=2;
  <b>parameter</b> Real lowerLimit=-2;
<b>equation</b>
  <b>assert</b>(upperLimit > lowerLimit, \"upperLimit must be greater than lowerLimit.\");
</pre>
</html>"));
    end Assert;
    class Atan "atan"
      annotation(Documentation(info = "<html>
<p>
Trigonometric inverse tangent function
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>atan</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>

<p>Returns the inverse of tan of u, with -&infin; &lt; u &lt; &infin;.
Argument u needs to be an Integer or Real expression.</p>

<p>
The atan function can also be accessed as Modelica.Math.atan.
</p

<p>
<img src=\"../Images/atan.png\">
</p>



<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>atan</b>(1)
 = 0.785398163397448</pre>
</html>"));
    end Atan;
    class Atan2 "atan2"
      annotation(Documentation(info = "<html>
<p>
Four quadrant inverse tangent
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>atan2</b>(u1,u2)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>

<p>
Returns y = atan2(u1,u2) such that tan(y) = u1/u2 and
y is in the range -pi &lt; y &le; pi. u2 may be zero, provided
u1 is not zero. Usually u1, u2 is provided in such a form that
u1 = sin(y) and u2 = cos(y).
Arguments u1 and u2 need to be Integer or Real expressions.
</p>

<p>
The atan2 function can also be accessed as Modelica.Math.atan2.
</p

<p>
<img src=\"../Images/atan2.png\">
</p>



<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>atan2</b>(1,0)
 = 1.5707963267949</pre>
</html>"));
    end Atan2;
    class Cardinality "cardinality"
      annotation(Documentation(info = "<html>
<p>
Number of connectors in connection.
This is a deprecated operator. It should  no longer be used, since it will be removed in one of the next Modelica releases.
</p>

<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>cardinality</b>(c)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the number of (inside and outside) occurrences
of connector instance c in a connect statement as an Integer number.</p>
<p><i>[The cardinality operator allows the definition of connection dependent equations in a model.]</i></p>

<p>
Instead of the cardinality(..) operator, often conditional
connectors can be used, that are enabled/disabled via Boolean
parameters.
</p>

<h4><font color=\"#008000\">Examples</font></h4>
<PRE><B>connector</B> Pin
  Real      v;
  <B>flow</B> Real i;
<B>end</B> Pin;
<B>model</B> Resistor
   <B>Pin</B> p, n;
<B>equation</B>
   // Handle cases if pins are not connected
      <B>if cardinality</B>(p) == 0 <B>and cardinality</B>(n) == 0 <B>then</B>
         p.v = 0;
         n.v = 0;
      <B>elseif cardinality</B>(p) == 0 <B>then</B>
         p.i = 0;
      <B>elseif cardinality</B>(n) == 0 <B>then</B>
         n.i = 0;
      <B>end if</B>;
   // Equations of resistor
      ...
<B>end</B> Resistor;</PRE>
</html>"));
    end Cardinality;
    class Ceil "ceil"
      annotation(Documentation(info = "<html>
<p>
Round a Real number towards plus infinity
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>ceil</b>(x)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the smallest integer not less than <tt>x</tt>.
Result and argument shall have type Real.
<i>[Note, outside of a when clause state events are
triggered when the return value changes discontinuously.]</i></p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>ceil</b>({-3.14, 3.14})
 = {-3.0, 4.0}</pre>
</html>"));
    end Ceil;
    class Change "change"
      annotation(Documentation(info = "<html>
<p>
Indicate discrete variable changing
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>change</b>(v)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Is expanded into &quot;(v&lt;&gt;pre(v))&quot;.
The same restrictions as for the pre() operator apply.</P>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>model</b> BothEdges
  Boolean u;
  Integer i;
<b>equation</b>
  u = Modelica.Math.sin(<b>time</b>) &gt; 0.5;
  <b>when</b> <b>change</b>(u) <b>then</b>
    i = <b>pre</b>(i) + 1;
  <b>end when</b>;
<b>end</b> BothEdges;</pre>
<p align=\"center\"><img src=\"../Images/change.png\" width=\"400\" height=\"280\" alt=\"Simulation result\"></p>
</html>"));
    end Change;
    class Cos "cos"
      annotation(Documentation(info = "<html>
<p>
Trigonometric cosine function
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>cos</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the cosine of u, with -&infin; &lt; u &lt; &infin;
Argument u needs to be an Integer or Real expression.</p>

<p>
The cosine function can also be accessed as Modelica.Math.cos.
</p>

<p>
<img src=\"../Images/cos.png\">
</p>

<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>cos</b>(3.14159265358979)
 = -1.0</pre>
</html>"));
    end Cos;
    class Cosh "cosh"
      annotation(Documentation(info = "<html>
<p>
Hyberbolic cosine function
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>cosh</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the cosh of u, with -&infin; &lt; u &lt; &infin;.
Argument u needs to be an Integer or Real expression.</p>

<p>
The cosh function can also be accessed as Modelica.Math.cosh.
</p

<p>
<img src=\"../Images/cosh.png\">
</p>



<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>cosh</b>(1)
  = 1.54308063481524</pre>
</html>"));
    end Cosh;
    class Cross "cross"
      annotation(Documentation(info = "<html>
<p>
Return cross product of two vectors
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>cross</b>(x, y)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns the cross product of the 3-vectors x and y, i.e.
</p>
<blockquote><pre>
<b>cross</b>(x,y) = <b>vector</b>( [ x[2]*y[3]-x[3]*y[2];
                       x[3]*y[1]-x[1]*y[3];
                       x[1]*y[2]-x[2]*y[1] ] );
</pre></blockquote>
</html>"));
    end Cross;
    class Delay "delay"
      annotation(Documentation(info = "<html>
<p>
Delay expression
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>delay</b>(expr, delayTime, delayMax)
<b>delay</b>(expr, delayTime)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Returns <TT>\"expr(time - delayTime)\"</TT> for <TT>time &gt; time.start + delayTime</TT>
and <TT>\"expr(time.start)\"</TT> for <TT>time &le; time.start + delayTime</TT>. The
arguments, i.e., <tt>expr</tt>, <tt>delayTime</tt> and <tt>delayMax</tt>, need to be subtypes of Real.
<TT>delayMax</TT> needs to be additionally a parameter expression. The following relation
shall hold: <TT>0 &le; delayTime &le; delayMax</tt>, otherwise an error occurs. If
<tt>delayMax</tt> is not supplied in the argument list, <tt>delayTime</tt> need to be a
parameter expression.</P>
<p><i>[The <b>delay</b> operator allows a numerical sound implementation
by interpolating in the (internal) integrator polynomials, as well as a
more simple realization by interpolating linearly in a buffer containing
past values of expression expr. Without further information, the complete
time history of the delayed signals need to be stored, because the delay
time may change during simulation. To avoid excessive storage requirements
and to enhance efficiency, the maximum allowed delay time has to be given
via delayMax. This gives an upper bound on the values of the delayed
signals which have to be stored. For realtime simulation where fixed step
size integrators are used, this information is sufficient to allocate the
necessary storage for the internal buffer before the simulation starts.
For variable step size integrators, the buffer size is dynamic during
integration. In principal, a delay operator could break algebraic loops.
For simplicity, this is not supported because the minimum delay time has
to be give as additional argument to be fixed at compile time. Furthermore,
the maximum step size of the integrator is limited by this minimum delay
time in order to avoid extrapolation in the delay buffer.]</i></p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>model</b> Delay
  Real x;
  Real y;
<b>equation
  der</b>(x) = 2;
  y = <b>delay</b>(x, 1);
<b>end</b> Delay;</pre>
<p align=\"center\"><img src=\"../Images/delay.png\" width=\"400\" height=\"280\" alt=\"Simulation result\"></p>
</html>"));
    end Delay;
    class Der "der"
      annotation(Documentation(info = "<html>
<p>
Time derivative of expression or<br>
partial derivative of function
</p>

<h4><font color=\"#008000\">Syntax</font></h4>

<blockquote><pre><b>der</b>(expr) or
IDENT \"=\" <b>der</b> \"(\" name \",\" IDENT { \",\" IDENT } \")\" comment</pre>
</blockquote>

<h4><font color=\"#008000\">Description</font></h4>
<p>
The first form is the time derivative of expression expr.
If the expression expr is a scalar it needs to be a subtype of Real. The expression and all its subexpressions must be differentiable. If expr is an array, the operator is applied to all elements of the array. For Real parameters and
constants the result is a zero scalar or array of the same size as the
variable.</p>

<p>
The second form is the partial derivative of a function
and may only be used as declarations of functions.
The semantics is that a function [and only a function] can be specified in this form, defining that it is the partial derivative of the function to the right of the equal sign (looked up in the same way as a short class definition - the looked up name must be a function), and partially differentiated with respect to each IDENT in order (starting from the first one). The IDENT must be Real inputs to the function.
The comment allows a user to comment the function (in the info-layer and as one-line description, and as icon).
</p>


<h4><font color=\"#008000\">Examples</font></h4>

<blockquote>
<pre>  Real x, xdot1, xdot2;
<b>equation</b>
  xdot1 = <b>der</b>(x);
  xdot2 = <b>der</b>(x*sin(x));
</pre>
</blockquote>

<p>
The specific enthalphy can be computed from a Gibbs-function as follows:
</p>

<blockquote>
<pre><b>function</b> Gibbs
  <b>input</b> Real p,T;
  <b>output</b> Real g;
<b>algorithm</b>
  ...
<b>end</b> Gibbs;

<b>function</b> Gibbs_T=<b>der</b>(Gibbs, T);

<b>function</b> specificEnthalpy
  <b>input</b> Real p,T;
  <b>output</b> Real h;
<b>algorithm</b>
  h:=Gibbs(p,T)-T*Gibbs_T(p,T);
<b>end</b> specificEnthalpy;
</pre>
</blockquote>
</html>"));
    end Der;
    class Diagonal "diagonal"
      annotation(Documentation(info = "<html>
<p>
Returns a diagonal matrix
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>diagonal</b>(v)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns a square matrix with the elements of vector v
on the diagonal and all other elements zero.
</p>
</html>"));
    end Diagonal;
    class Div "div"
      annotation(Documentation(info = "<html>
<p>
Integer part of division of two Real numbers
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>div</b>(x, y)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Returns the algebraic quotient <TT>x/y</TT> with any
fractional part discarded (also known as truncation
toward zero). <I>[Note: this is defined for / in C99;
in C89 the result for negative numbers is
implementation-defined, so the standard function
<TT>div()</TT> must be used.]</I> Result and arguments
shall have type Real or Integer. If either of the
arguments is Real the result is Real otherwise Integer.</P>

<p><i>[Note, outside of a when clause state events are triggered
when the return value changes discontinuously.]</i></p>

<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>div</b>(13,6)
 = 2</pre>
</html>"));
    end Div;
    class Edge "edge"
      annotation(Documentation(info = "<html>
<p>
Indicate rising edge
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>edge</b>(b)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Is expanded into &quot;(b <B>and not pre</B>(b))&quot;
for Boolean variable b. The same restrictions as for the
<B>pre</B> operator apply (e.g., not to be used in function
classes).</P>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>model</b> RisingEdge
  Boolean u;
  Integer i;
<b>equation</b>
  u = Modelica.Math.sin(<b>time</b>) &gt; 0.5;
  <b>when</b> <b>edge</b>(u) <b>then</b>
    i = <b>pre</b>(i) + 1;
  <b>end when</b>;
<b>end</b> RisingEdge;</pre>
<p align=\"center\"><img src=\"../Images/edge.png\" width=\"400\" height=\"280\" alt=\"Simulation result\"></p>
</html>"));
    end Edge;
    class Exp "exp"
      annotation(Documentation(info = "<html>
<p>
Exponential, base e.
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>exp</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the base e exponential of u, with -&infin; &lt; u &lt; &infin;
Argument u needs to be an Integer or Real expression.</p>

<p>
The exponential function can also be accessed as Modelica.Math.exp.
</p>

<p>
<img src=\"../Images/exp.png\">
</p>

<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>exp</b>(1)
 = 2.71828182845905</pre>
</html>"));
    end Exp;
    class Fill "fill"
      annotation(Documentation(info = "<html>
<p>
Return a Real, Integer, Boolean or String array with all elements equal
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>fill</b>(s, n1, n2, n3, ...)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns the n1 x n2 x n3 x ... array with all elements equal
to scalar or array expression s (ni >= 0). The returned
array has the same type as s. Recursive definition:
<p>
<blockquote><pre>
fill(s,n1,n2,n3, ...) = fill(fill(s,n2,n3, ...), n1);
fill(s,n) = {s,s,..., s}
</pre></blockquote>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
Real    mr[2,2] = fill(-1,2,2);  // = [-1,-1;-1,-1]
Boolean vb[3]   = fill(true,3);  // = {true, true, true}
</pre></blockquote>
</html>"));
    end Fill;
    class Floor "floor"
      annotation(Documentation(info = "<html>
<p>
Round Real number towards minus infinity
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>floor</b>(x)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the largest integer not greater than <tt>x</tt>.
Result and argument shall have type Real. <i>[Note, outside
of a when clause state events are triggered when the return
value changes discontinuously.]</i></p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>floor</b>({-3.14, 3.14})
 = {-4.0, 3.0}</pre>
</html>"));
    end Floor;
    class Identity "identity"
      annotation(Documentation(info = "<html>
<p>
Returns the identity matrix of the desired size
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>identity</b>(n)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns the n x n Integer identity matrix, with ones
on the diagonal and zeros at the other places.
</p>
</html>"));
    end Identity;
    class Initial "initial"
      annotation(Documentation(info = "<html>
<p>
True during initialization
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>initial</b>()</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns <b>true</b> during the initialization phase and <b>false</b> otherwise.</p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre>  Boolean off;
  Real x;
<b>equation</b>
  off = x &lt; -2 or <b>initial</b>();</pre>
</html>"));
    end Initial;
    class IntegerUpperCase "Integer"
      annotation(Documentation(info = "<html>
<p>
Returns ordinal number of enumeration
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>Integer</b>(E.e1)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns the ordinal number of the enumeration value E.enumvalue, where Integer(E.e1)=1, Integer(E.en)= size(E), for an enumeration type E=enumeration(e1, ...,  en).</p>

<h4><font color=\"#008000\">Examples</font></h4>
<pre>  <b>type</b> Size = enumeration(small, medium, large, xlarge);
  <b>Integer</b>(Size.large) = 3</pre>


</html>"));
    end IntegerUpperCase;
    class IntegerLowerCase "integer"
      annotation(Documentation(info = "<html>
<p>
Round Real number towards minus infinity
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>integer</b>(x)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the largest integer not greater than <tt>x</tt>.
The argument shall have type Real. The result has type Integer.</p>
<p><i>[Note, outside of a when clause state events are triggered
when the return value changes discontinuously.]</i></p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>integer</b>({-3.14, 3.14})
 = {-4, 3}</pre>
</html>"));
    end IntegerLowerCase;
    class IsPresent "isPresent"
      annotation(Documentation(info = "<html>
<p>
Returns true if the formal input or output argument of a function is present
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>isPresent</b>(ident)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns true if the formal input or output argument ident is present
as an actual argument of the function call. If the argument is not
present, isPresent(ident) may return false <i>[but may also return
true e.g., for implementations that always compute all results]</i>.
isPresent() should be used for optimisation only and should not
influence the results of outputs that are present in the output
list. It can only be used in functions.
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote>
<pre>
<b>function</b> eigenValues \"Compute eigenvalues and eigenvectors\"
  <b>input</b>  Real A[:, size(A, 1)];
  <b>output</b> Real eigenvalues[size(A, 1), 2];
  <b>output</b> Real eigenvectors[size(A,1), size(A,2)];
<b>algorithm</b>
  // compute eigen values
  <b>if</b> <b>isPresent</b>(eigenvectors) <b>then</b>
     // compute eigen vectors
  <b>end</b> <b>if</b>;
<b>end</b> eigenValues;
        eval = eigenValues(A);  // compute only eigenvalues
(eval, evec) = eigenValues(A);  // compute eigenvalues and eigenvectors
</pre>
</blockquote>
</html>"));
    end IsPresent;
    class Linspace "linspace"
      annotation(Documentation(info = "<html>
<p>
Return Real vector with equally spaced elements
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>linspace</b>(x1, x2, n)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns a Real vector with n equally spaced elements,
such that
</p>
<blockquote><pre>
v[i] = x1 + (x2-x1)*(i-1)/(n-1) for 1 &le; i &le; n.
</pre></blockquote>
<p>
It is required that n &ge; 2. The arguments x1 and x2 shall
be Real or Integer scalar expressions.
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
Real v[:] = linspace(1,7,4);  // = {1, 3, 5, 7}
</pre></blockquote>
</html>"));
    end Linspace;
    class Log "log"
      annotation(Documentation(info = "<html>
<p>
Natural (base e) logarithm
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>log</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the base e logarithm of u, with u &gt; 0.
Argument u needs to be an Integer or Real expression.</p>

<p>
The natural logarithm can also be accessed as Modelica.Math.log.
</p>

<p>
<img src=\"../Images/log.png\">
</p>

<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>log</b>(1)
 = 0</pre>
</html>"));
    end Log;
    class Log10 "log10"
      annotation(Documentation(info = "<html>
<p>
Base 10 logarithm
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>log10</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the base 10 logarithm of u, with u &gt; 0.
Argument u needs to be an Integer or Real expression.</p>

<p>
The base 10 logarithm can also be accessed as Modelica.Math.log10.
</p>

<p>
<img src=\"../Images/log10.png\">
</p>

<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>log10</b>(1)
 = 0</pre>
</html>"));
    end Log10;
    class Matrix "matrix"
      annotation(Documentation(info = "<html>
<p>
Returns the first two dimensions of an array as matrix
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>matrix</b>(A)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns <b>promote</b>(A,2), if A is a scalar or vector and
otherwise returns the elements of the first two dimensions
as a matrix. <b>size</b>(A,i) = 1 is required for
2 &lt; i &le; <b>ndims</b>(A).
</p>
<p>
Function <b>promote</b>(A,n) fills dimensions of size 1
from the right to array A upto dimension n, where
\"n &gt; <b>ndims</b>(A)\" is required. Let
C = <b>promote</b>(A,n), with nA = <b>ndims</b>(A),
then
</p>
<blockquote><pre>
<b>ndims</b>(C) = n,
<b>size</b>(C,j) = <b>size</b>(A,j) for 1 &le; j &le; nA,
<b>size</b>(C,j) = 1 for nA+1 &le; j &le; n,
C[i_1, ..., i_nA, 1, ..., 1] = A[i_1, ..., i_nA].
</pre></blockquote>
</html>"));
    end Matrix;
    class Max "max"
      annotation(Documentation(info = "<html>
<p>
Returns the largest element
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre>
<b>max</b>(A)
<b>max</b>(x,y)
<b>max</b>(e(i, ..., j) <b>for</b> i <b>in</b> u, ..., j <b>in</b> v)
</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
The first form returns the largest element of array expression A.
</p>
<p>
The second form returns the largest element of the scalars x and y.
</p>
<p>
The third form is a reduction expression and
returns the largest value of the
scalar expression e(i, ..., j) evaluated for all
combinations of i in u, ..., j in v
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
<b>max</b>(i^2 <b>for</b> i <b>in</b> {3,7,6})  // = 49
</pre></blockquote>
</html>"));
    end Max;
    class Min "min"
      annotation(Documentation(info = "<html>
<p>
Returns the smallest element
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre>
<b>min</b>(A)
<b>min</b>(x,y)
<b>min</b>(e(i, ..., j) <b>for</b> i <b>in</b> u, ..., j <b>in</b> v)
</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
The first form returns the smallest element of array expression A.
</p>
<p>
The second form returns the smallest element of the scalars x and y.
</p>
<p>
The third form is a reduction expression and
returns the smallest value of the
scalar expression e(i, ..., j) evaluated for all
combinations of i in u, ..., j in v
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
<b>min</b>(i^2 <b>for</b> i <b>in</b> {3,7,6})  // = 9
</pre></blockquote>
</html>"));
    end Min;
    class Mod "mod"
      annotation(Documentation(info = "<html>
<p>
Integer modulus of a division of two Real numbers
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>mod</b>(x, y)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Returns the integer modulus of <TT>x/y</TT>, i.e., mod(x, y) = x - floor(x/y)*y.
Result and arguments shall have type Real or Integer. If either of the
arguments is Real the result is Real otherwise Integer. <I>[Note, outside of
a when clause state events are triggered when the return value changes
discontinuously.]</I></P>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>mod</b>(3,1.4)
 = 0.2
<b>mod</b>(-3,1.4)
 = 1.2
<b>mod</b>(3,-1.4)
 = -1.2</pre>
</html>"));
    end Mod;
    class Ndims "ndims"
      annotation(Documentation(info = "<html>
<p>
Return number of array dimensions
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>ndims</b>(A)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns the number of dimensions k of array expression
A, with k >= 0.
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
Real A[8,4,5];
Integer n = ndims(A);  // = 3
</pre></blockquote>
</html>"));
    end Ndims;
    class NoEvent "noEvent"
      annotation(Documentation(info = "<html>
<p>
Turn off event triggering
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>noEvent</b>(expr)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Real elementary relations within expr are taken literally, i.e., no state or time event is triggered.</p>
<h4>smooth vs. noEvent</h4>
<p>The noEvent operator implies that real elementary expressions are taken
literally instead of generating crossing functions. The smooth operator
should be used instead of noEvent, in order to avoid events for efficiency
reasons. A tool is free to not generate events for expressions inside smooth.
However, smooth does not guarantee that no events will be generated, and thus
it can be necessary to use noEvent inside smooth. <I>[Note that smooth does
not guarantee a smooth output if any of the occurring variables change
discontinuously.]</i></p>
<p><i>[Example:</i></p>
<PRE>  Real x, y, z;
<B>equation</B>
  x = <B>if</B> time&lt;1 <B>then</B> 2 <B>else</B> time-2;
  z = smooth(0, <B>if</B> time&lt;0 <B>then</B> 0 <B>else</B> time);
  y = smooth(1, noEvent(<B>if</B> x&lt;0 <B>then</B> 0 <B>else</B> sqrt(x)*x));
  // noEvent is necessary.</PRE>
<p><i>]</i></p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre>der(h)=<B>if noEvent</B>(h&gt;0) <B>then</B> -c*sqrt(h) <B>else</B> 0;</pre>
</html>"));
    end NoEvent;
    class Ones "ones"
      annotation(Documentation(info = "<html>
<p>
Returns an array with \"1\" elements
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>ones</b>(n1, n2, n3, ...)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Return the n1 x n2 x n3 x ... Integer array with all
elements equal to one (ni >=0 ).
</p>
</html>"));
    end Ones;
    class OuterProduct "outerProduct"
      annotation(Documentation(info = "<html>
<p>
Returns the outer product of two vectors
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>outerProduct</b>(v1,v2)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns the outer product of vectors v1 and v2 <br>
(= matrix(v)*transpose( matrix(v) ) ).
</p>
</html>"));
    end OuterProduct;
    class Pre "pre"
      annotation(Documentation(info = "<html>
<p>
Refer to left limit
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>pre</b>(y)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Returns the &quot;left limit&quot; y(t<SUP>pre</SUP>)
of variable y(t) at a time instant t. At an event instant,
y(t<SUP>pre</SUP>) is the value of y after the last event
iteration at time instant t. The
<B>pre</B> operator can be applied if the following three
conditions are fulfilled simultaneously:</p>
<ul>
  <li>variable y is a subtype of a simple type</li>
  <li>y is a discrete-time expression</li>
  <li>the operator is <B>not</B> applied in a <B>function</B> class</li>
</ul>
<p>The first value of <B>pre</B>(y) is
determined in the initialization phase.</P>
<P>A new event is triggered if at least for one variable v
&quot;<B>pre</B>(v) &lt;&gt; v&quot; after the active model
equations are evaluated at an event instant. In this case
the model is at once reevaluated. This evaluation sequence
is called &quot;<I>event iteration</I>&quot;. The integration
is restarted, if for all v used in <B>pre</B>-operators the
following condition holds: &quot;<B>pre</B>(v) == v&quot;.</P>
<p><I>[If v and <B>pre</B>(v) are only used in when clauses,
the translator might mask event iteration for variable v since
v cannot change during event iteration. It is a &quot;quality
of implementation&quot; to find the minimal loops for event
iteration, i.e., not all parts of the model need to be
reevaluated.</i></p>
<p><i>The language allows mixed algebraic systems of equations
where the unknown variables are of type Real, Integer, Boolean,
or an enumeration. These systems of equations can be solved by
a global fix point iteration scheme, similarly to the event
iteration, by fixing the Boolean,  Integer, and/or enumeration
unknowns during one iteration. Again, it is a quality of
implementation to solve these systems more efficiently, e.g.,
by applying the fix point iteration scheme to a subset of the
model equations.]</I></p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>model</b> Hysteresis
  Real u;
  Boolean y;
<b>equation</b>
  u = Modelica.Math.sin(<b>time</b>);
  y = u &gt; 0.5 or <b>pre</b>(y) and u &gt;= -0.5;
<b>end</b> Hysteresis;</pre>
<p align=\"center\"><img src=\"../Images/pre.png\" width=\"400\" height=\"280\" alt=\"Simulation result\"></p>
</html>"));
    end Pre;
    class Product "product"
      annotation(Documentation(info = "<html>
<p>
Returns the scalar product
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre>
<b>product</b>(A)
<b>product</b>(e(i, ..., j) <b>for</b> i <b>in</b> u, ..., j <b>in</b> v)
</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
The first form returns the scalar product of all the elements of
array expression A:<br>
A[1,...,1]*A[2,...,1]*....*A[end,...,1]*A[end,...,end]
</p>
<p>
The second form is a reduction expression and
returns the product of the expression e(i, ..., j) evaluated for all combinations of i in u, ..., j in v:
</p>
<blockquote><pre>
e(u[1],...,v[1]) * e(u[2],...,v[1]) * ... *
e(u[end],...,v[1]) * ... * e(u[end],...,v[end])
</pre></blockquote>
<p>
The type of <b>product</b>(e(i, ..., j) <b>for</b> i <b>in</b>
u, ..., j <b>in</b> v) is the same as the type of e(i,...j).
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
{<b>product</b>(j <b>for</b> j <b>in</b> 1:i) <b>for</b> i <b>in</b> 0:4} // = {1,1,2,6,24}
</pre></blockquote>
</html>"));
    end Product;
    class Reinit "reinit"
      annotation(Documentation(info = "<html>
<p>
Reinitialize state variable
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>reinit</b>(x, expr)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Reinitializes state variable x with expr at an event
instant. Argument x need to be</p>
<ul>
  <li>a subtype of Real and</li>
  <li>the <B>der</B>-operator need to be applied to it.</li>
</ul>
<p>expr need to be an Integer or Real expression. The
reinit operator can only be applied once for the same
variable x. It can only be applied in the body of a
when-clause.</P>
<p>The <B>reinit</B> operator does not break the single
assignment rule, because <B>reinit</B>(x, expr) makes
the previously known state variable x unknown and
introduces the equation &quot;x = expr&quot;.</p>
<p><I>[If a higher index system is present, i.e.
constraints between state variables, some state variables
need to be redefined to non-state variables. If possible,
non-state variables should be chosen in such a way that
states with an applied <B>reinit</B> operator are not
utilized. If this is not possible, an error occurs,
because the reinit operator is applied on a non-state variable.]</i></P>
<PRE>Bouncing ball:
    <B>der</B>(h) = v;
    <B>der</B>(v) = -g;
    <B>when</B> h &lt; 0 <B>then</B>
      <B>reinit</B>(v, -e*v);
    <B>end when</B>;</PRE>
</html>"));
    end Reinit;
    class Rem "rem"
      annotation(Documentation(info = "<html>
<p>
Integer remainder of the division of two Real numbers
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>rem</b>(x, y)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Returns the integer remainder of <TT>x/y</TT>,
such that <TT>div(x,y) * y + rem(x, y) = x</TT>.
Result and arguments shall have type Real or
Integer. If either of the arguments is Real the
result is Real otherwise Integer. <I>[Note, outside
of a when clause state events are triggered when
the return value changes discontinuously.]</I></P>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>rem</b>(3,1.4)
 = 0.2
<b>rem</b>(-3,1.4)
 = -0.2
<b>rem</b>(3,-1.4)
 = 0.2</pre>
</html>"));
    end Rem;
    class Sample "sample"
      annotation(Documentation(info = "<html>
<p>
Trigger time events
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>sample</b>(start, interval)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>Returns true and triggers time events at time instants
<TT>&quot;start + i*interval&quot; (i=0, 1, ...)</TT>.
During continuous integration the operator returns always
false. The starting time &quot;start&quot; and the sample
interval &quot;interval&quot; need to be parameter
expressions and need to be a subtype of Real or Integer.
</P>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>model</b> Sampling
  Integer i;
<b>equation</b>
  <b>when</b> <b>sample</b>(1, 0.1) <b>then</b>
    i = <b>pre</b>(i) + 1;
  <b>end when</b>;
<b>end</b> Sampling;</pre>
<p align=\"center\"><img src=\"../Images/sample.png\" width=\"400\" height=\"280\" alt=\"Simulation result\"></p>
</html>"));
    end Sample;
    class Scalar "scalar"
      annotation(Documentation(info = "<html>
<p>
Returns a one-element array as scalar
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>scalar</b>(A)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns the single element of array A.
<b>size</b>(A,i) = 1 is required for 1 &le; i &le; <b>ndims</b>(A).
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
Real A[1,1,1] = {{{3}}};
Real e = scalar(A);  // = 3
</pre></blockquote>
</html>"));
    end Scalar;
    class SemiLinear "semiLinear"
      annotation(Documentation(info = "<html>
<p>
Returns \"if x >= 0 then positiveSlope*x else negativeSlope*x\" and handle x=0 in a meaningful way
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>semiLinear</b>(x, positiveSlope, negativeSlope)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns \"if x >= 0 then positiveSlope*x else negativeSlope*x\".
In some situations, equations with the semiLinear function
become underdetermined if the first argument (x) becomes
zero, i.e., there are an infinite number of solutions.
It is recommended that the following rules are used to
transform the equations during the translation phase in
order to select one meaningful solution in such cases:
</p>
<p>
<b>Rule 1</b>: The equations
</p>
<blockquote>
<pre>
y = <b>semiLinear</b>(x, sa, s1);
y = <b>semiLinear</b>(x, s1, s2);
y = <b>semiLinear</b>(x, s2, s3);
   ...
y = <b>semiLinear</b>(x, sN, sb);
</pre>
</blockquote>
<p>
may be replaced by
</p>
<blockquote>
<pre>
s1 = <b>if</b> x >= 0 <b>then</b> sa <b>else</b> sb
s2 = s1;
s3 = s2;
   ...
sN = sN-1;
y = <b>semiLinear</b>(x, sa, sb);
</pre>
</blockquote>
<p>
<b>Rule 2</b>: The equations
</p>
<blockquote>
<pre>
x = 0;
y = 0;
y = <b>semiLinear</b>(x, sa, sb);
</pre>
</blockquote>
<p>
may be replaced by
</p>
<blockquote>
<pre>
x = 0
y = 0;
sa = sb;
</pre>
</blockquote>
<p>
<i> [For symbolic transformations, the following property is
useful (this follows from the definition):</i>
</p>
<blockquote>
<pre>
<b>semiLinear</b>(m_flow, port_h, h);
</pre>
</blockquote>
<p>
is identical to
</p>
<blockquote><pre>
-<b>semiLinear</b>(-m_flow, h, port_h);
</pre></blockquote>
<p>
<i> The semiLinear function is designed to handle reversing
flow in fluid systems, such as</i>
</p>
<blockquote><pre>
H_flow = <b>semiLinear</b>(m_flow, port.h, h);
</pre></blockquote>
<p>
<i> i.e., the enthalpy flow rate H _flow is computed from the mass flow
rate m_flow and the upstream specific enthalpy depending on the
flow direction.]</i>
</p>
</html>"));
    end SemiLinear;
    class Sign "sign"
      annotation(Documentation(info = "<html>
<p>
Signum function of a Real or Integer number
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>sign</b>(v)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Is expanded into &quot;noEvent(<b>if</b> v &gt; 0 <b>then</b> 1 <b>else
if</b> v &lt; 0 <b>then</b> -1 <b>else</b> 0)&quot;. Argument v
needs to be an Integer or Real expression. <i>[Note, outside of a
when clause state events are triggered.]</i></p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>sign</b>({-3, 0, 3})
 = {-1, 0, 1}</pre>
</html>"));
    end Sign;
    class Sin "sin"
      annotation(Documentation(info = "<html>
<p>
Trigonometric sine function
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>sin</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the sine of u, with -&infin; &lt; u &lt; &infin;.
Argument u needs to be an Integer or Real expression.</p>

<p>
The sine function can also be accessed as Modelica.Math.sin.
</p

<p>
<img src=\"../Images/sin.png\">
</p>



<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>sin</b>(3.14159265358979)
 = 0.0</pre>
</html>"));
    end Sin;
    class Sinh "sinh"
      annotation(Documentation(info = "<html>
<p>
Hyberbolic sine function
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>sinh</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the sinh of u, with -&infin; &lt; u &lt; &infin;.
Argument u needs to be an Integer or Real expression.</p>

<p>
The sinh function can also be accessed as Modelica.Math.sinh.
</p

<p>
<img src=\"../Images/sinh.png\">
</p>



<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>sinh</b>(1)
  = 1.1752011936438</pre>
</html>"));
    end Sinh;
    class Size "size"
      annotation(Documentation(info = "<html>
<p>
Returns dimensions of an array
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre>
   <b>size</b>(A,i)
   <b>size</b>(A)
</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
The first form returns the size of dimension i of array expression A
where i shall be &gt; 0 and &le; <b>ndims</b>(A).
</p>
<p>
The second form returns a vector of length <b>ndims</b>(A)
containing the dimension sizes of A.
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
Real A[8,4,5];
Integer n3   = size(A,3);  // = 5
Integer n[:] = size(A);    // = {8,4,5}
</pre></blockquote>
</html>"));
    end Size;
    class Skew "skew"
      annotation(Documentation(info = "<html>
<p>
Returns the skew matrix that is associated with a vector
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>skew</b>(x)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns the 3 x 3 skew symmetric matrix associated with a
3-vector, i.e.,
</p>
<blockquote><pre>
<b>cross</b>(x,y) = <b>skew</b>(x)*y;
<b>skew</b>(x) = [ 0   , -x[3],  x[2];
            x[3],  0   , -x[1];
           -x[2],  x[1],  0   ];
</pre></blockquote>
</html>"));
    end Skew;
    class Smooth "smooth"
      annotation(Documentation(info = "<html>
<p>
Indicate smoothness of expression
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>smooth</b>(p, expr)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>If p&gt;=0 <B>smooth</B>(p, expr) returns expr and states
that expr is p times continuously differentiable, i.e.: expr
is continuous in all real variables appearing in the expression
and all partial derivatives with respect to all appearing real
variables <B>exist</B> and are continuous up to order p.</p>
<p>The only allowed types for expr in smooth are: real expressions,
arrays of allowed expressions, and records containing only
components of allowed expressions.</P>
<h4>smooth vs. noEvent</h4>
<p>The noEvent operator implies that real elementary expressions are taken
literally instead of generating crossing functions. The smooth operator
should be used instead of noEvent, in order to avoid events for efficiency
reasons. A tool is free to not generate events for expressions inside smooth.
However, smooth does not guarantee that no events will be generated, and thus
it can be necessary to use noEvent inside smooth. <I>[Note that smooth does
not guarantee a smooth output if any of the occurring variables change
discontinuously.]</I></p>
<h4><font color=\"#008000\">Examples</font></h4>
<PRE>  Real x, y, z;
<B>equation</B>
  x = <B>if</B> time&lt;1 <B>then</B> 2 <B>else</B> time-2;
  z = smooth(0, <B>if</B> time&lt;0 <B>then</B> 0 <B>else</B> time);
  y = smooth(1, noEvent(<B>if</B> x&lt;0 <B>then</B> 0 <B>else</B> sqrt(x)*x));
  // noEvent is necessary.</PRE>
</html>"));
    end Smooth;
    class Sqrt "sqrt"
      annotation(Documentation(info = "<html>
<p>
Square root
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>sqrt</b>(v)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the square root of v if v&gt;=0, otherwise an error occurs.
Argument v needs to be an Integer or Real expression.</p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>sqrt</b>(9)
 = 3.0</pre>
</html>"));
    end Sqrt;
    class string "String"
      annotation(Documentation(info = "<html>
<p>
Convert a scalar Real, Integer or Boolean expression to a String representation
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote>
<pre>
<b>String</b>(b_expr, minimumLength=0, leftJustified=true)
<b>String</b>(i_expr, minimumLength=0, leftJustified=true)
<b>String</b>(r_expr, significantDigits=6, minimumLength=0, leftJustified=true)
<b>String</b>(r_expr, format)
<b>String</b>(e_expr, minimumLength=0, leftJustified=true)
</pre>
</blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
The arguments have the following meaning
(the default values of the optional arguments are shown in the left column):
</p>
<table border=1 cellspacing=0 cellpadding=2>
<tr>
  <td> Boolean b_expr</td>
  <td> Boolean expression</td></tr>
<tr>
  <td> Integer i_expr</td>
  <td> Integer expression</td></tr>
<tr>
  <td> Real r_expr</td>
  <td> Real expression</td></tr>
<tr>
  <td> type e_expr = enumeration(..)</td>
  <td> Enumeration expression</td></tr>
<tr>
  <td> Integer minimumLength = 0 </td>
  <td> Minimum length of the resulting string. If necessary, <br>
       the blank character is used to fill up unused space.</td></tr>
<tr>
  <td> Boolean leftJustified = <b>true</b> </td>
  <td> if <b>true</b>, the converted result is left justified;<br>
       if <b>false</b>, it is right justified in the string.</td></tr>
<tr>
  <td> Integer significantDigits = 6 </td>
  <td> defines the number of significant digits in the result string<br>
       (e.g., \"12.3456\", \"0.0123456\", \"12345600\", \"1.23456E-10\")</td></tr>
<tr>
  <td> String format </td>
  <td> defines the string formating according to ANSI-C without \"%\" and \"*\" character<br>
       (e.g., \".6g\", \"14.5e\", \"+6f\"). In particular:<br>
&nbsp;&nbsp;&nbsp;&nbsp;
format = \"[&lt;flags&gt;] [&lt;width&gt;] [.&lt;precision&gt;] &lt;conversion&gt;\"<br>
with
<table>
<tr>
  <td>&lt;flags&gt;</td>
  <td> zero, one or more of<br>
       \"-\": left adjustment of the converted number<br>
       \"+\": number will always be printed with a sign<br>
       \"0\": padding to the field width with leading zeros</td></tr>
<tr>
  <td>&lt;width&gt;</td>
  <td> Minimum field width. The converted number will be printed in a field at<br>
       least this wide and wider if necessary. If the converted number has <br>
       fewer characters it will be padded on the left (or the right depending<br>
       on &lt;flags&gt;) with blanks or 0 (depending on &lt;flags&gt;).</td></tr>
<tr>
  <td>&lt;precision&gt;</td>
  <td> The number of digits to be printed after the decimal point for <br>
       e, E, or f conversions, or the number of significant digits for <br>
       g or G conversions.</td></tr>
<tr>
  <td> &lt;conversion&gt;</td>
  <td> = \"e\": Exponential notation using a  lower case e<br>
       = \"E\": Exponential notation using an upper case E<br>
       = \"f\": Fixed point notation<br>
       = \"g\": Either \"e\" or \"f\"<br>
       = \"G\": Same as \"g\", but with upper case E</td></tr></table>
</table>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote>
<pre>
String(2.0)   // = \"2.0\"
String(true)  // = \"true\"
String(123, minimumLength=6, leftJustified=false)  // = \"   123\"
</pre>
</blockquote>
</html>"));
    end string;
    class Sum "sum"
      annotation(Documentation(info = "<html>
<p>
Returns the scalar sum
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre>
<b>sum</b>(A)
<b>sum</b>(e(i, ..., j) <b>for</b> i <b>in</b> u, ..., j <b>in</b> v)
</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
The first form returns the scalar sum of all the elements of
array expression A:<br>
A[1,...,1]+A[2,...,1]+....+A[end,...,1]+A[end,...,end]
</p>
<p>
The second form is a reduction expression and
returns the sum of the expression e(i, ..., j) evaluated for all combinations of i in u, ..., j in v:
</p>
<blockquote><pre>
e(u[1],...,v[1]) + e(u[2],...,v[1]) + ... +
e(u[end],...,v[1]) + ... + e(u[end],...,v[end])
</pre></blockquote>
<p>
The type of <b>sum</b>(e(i, ..., j) <b>for</b> i <b>in</b>
u, ..., j <b>in</b> v) is the same as the type of e(i,...j).
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
<b>sum</b>(i <b>for</b> i <b>in</b> 1:10)  // Gives  1+2+...+10=55
   // Read it as: compute the sum of i for i in the range 1 to 10.
</pre></blockquote>
</html>"));
    end Sum;
    class Symmetric "symmetric"
      annotation(Documentation(info = "<html>
<p>
Returns a symmetric matrix
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>symmetric</b>(A)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns a matrix where the diagonal elements and the
elements above the diagonal are identical to the
corresponding elements of matrix A and where the
elements below the diagonal are set equal to the elements
above the diagonal of A, i.e.,
<p>
<blockquote><pre>
B := <b>symmetric</b>(A)
     -> B[i,j] := A[i,j], <b>if</b> i &le; j,
        B[i,j] := A[j,i], <b>if</b> i &gt; j.
</pre></blockquote>
</html>"));
    end Symmetric;
    class Tan "tan"
      annotation(Documentation(info = "<html>
<p>
Trigonometric tangent function
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>tan</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the tangent of u, with -&infin; &lt; u &lt; &infin;
(if u is a multiple of (2n-1)*pi/2, y = tan(u) is +/- infinity).
Argument u needs to be an Integer or Real expression.</p>

<p>
The tangent function can also be accessed as Modelica.Math.tan.
</p

<p>
<img src=\"../Images/tan.png\">
</p>

<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>tan</b>(3.14159265358979)
 = 0.0
</pre>
</html>"));
    end Tan;
    class Tanh "tanh"
      annotation(Documentation(info = "<html>
<p>
Hyberbolic tangent function
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>tanh</b>(u)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns the tanh of u, with -&infin; &lt; u &lt; &infin;.
Argument u needs to be an Integer or Real expression.</p>

<p>
The tanh function can also be accessed as Modelica.Math.tanh.
</p

<p>
<img src=\"../Images/tanh.png\">
</p>



<h4><font color=\"#008000\">Examples</font></h4>
<pre><b>tanh</b>(1)
  = 0.761594155955765</pre>
</html>"));
    end Tanh;
    class Terminal "terminal"
      annotation(Documentation(info = "<html>
<p>
True after successful analysis
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>terminal</b>()</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>Returns <b>true</b> at the end of a successful analysis.</p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre>  Boolean a, b;
<b>equation</b>
  a = <b>change</b>(b) or <b>terminal</b>();</pre>
</html>"));
    end Terminal;
    class Terminate "terminate"
      annotation(Documentation(info = "<html>
<p>
Successfully terminate current analysis
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>terminate</b>(message)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<P>The terminate function successfully terminates the analysis
which was carried out. The function has a string argument
indicating the reason for the success. <I>[The intention is to
give more complex stopping criteria than a fixed point in time.]</I></P>
<h4><font color=\"#008000\">Examples</font></h4>
<pre><B>model</B> ThrowingBall
  Real x(start=0);
  Real y(start=1);
<B>equation</B>
  <b>der</b>(x)= ... ;
  <b>der</b>(y)= ... ;
<B>algorithm</B>
  <B>when</B> y &lt; 0 <B>then</B>
    <b>terminate</b>(\"The ball touches the ground\");
  <B>end when;
end</B> ThrowingBall;</pre>
</html>"));
    end Terminate;
    class Transpose "transpose"
      annotation(Documentation(info = "<html>
<p>
Transpose of a matrix or permutation of the first two dimensions of an array
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>transpose</b>(A)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Permutes the first two dimensions of array A.
It is an error, if array A does not have at least
2 dimensions.
</p>
</html>"));
    end Transpose;
    class Vector "vector"
      annotation(Documentation(info = "<html>
<p>
Returns an array with one non-singleton dimension as vector
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>vector</b>(A)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns a 1-vector, if A is a scalar and otherwise returns a vector containing all the elements of the array, provided there is at
most one dimension size > 1.
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<blockquote><pre>
Real A[1,2,1] = {{{3},{4}}};
Real v[2] = vector(A);  // = {3,4}
</pre></blockquote>
</html>"));
    end Vector;
    class Zeros "zeros"
      annotation(Documentation(info = "<html>
<p>
Returns a zero array.
</p>
<h4><font color=\"#008000\">Syntax</font></h4>
<blockquote><pre><b>zeros</b>(n1, n2, n3, ...)</pre></blockquote>
<h4><font color=\"#008000\">Description</font></h4>
<p>
Returns the n1 x n2 x n3 x ... Integer array with all
elements equal to zero (ni >= 0).
</p>
</html>"));
    end Zeros;
  end Operators;
  class BalancedModel "balanced model"
    annotation(Documentation(info = "<html>
<p>
The basic concept to count unknowns and equations.
</p>

<p>
Restrictions for model and block classes are present, in order that missing
or too many equations can be detected and localized by a Modelica
translator before using the respective model or block class.
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre>   <b>partial model</b> BaseCorrelation
     <b>input</b> Real x;
     Real y;
   <b>end</b> BaseCorrelation;

   <b>model</b> SpecialCorrelation // correct in Modelica 2.2 and 3.0
      <b>extends</b> BaseCorrelation(x=2);
   <b>equation</b>
       y=2/x;
   <b>end</b> SpecialCorrelation;

   <b>model</b> UseCorrelation // correct according to Modelica 2.2
                        // not valid according to Modelica 3.0
      <b>replaceable model</b> Correlation=BaseCorrelation;
      Correlation correlation;
   <b>equation</b>
      correlation.y=time;
   <b>end</b> UseCorrelation;

   <b>model</b> Broken // after redeclaration, there is 1 equation too much in Modelica 2.2
      UseCorrelation example(redeclare Correlation=SpecialCorrelation);
   <b>end</b> Broken;
</pre>

<p>
In this case one can argue that both UseCorrelation (adding an acausal equation) and SpecialCorrelation (adding a default to an input) are correct, but still when combined they lead to a model with too many equations - and it is not possible to determine which model is incorrect without strict rules.
In Modelica 2.2, model Broken will work with some models. However, by just redeclaring it to model SpecialCorrelation, an error will occur and it will be very difficult in a larger model to figure out the source of this error.
In Modelica 3.0, model UseCorrelation is no longer allowed and the translator will give an error. In fact, it is guaranteed that a redeclaration cannot lead to an unbalanced model any more.
</p>


<h4><font color=\"#008000\">Description</font></h4>

<p>
The restrictions below apply after flattening \" i.e., inherited components are included \" possibly modified.
</p>

<p>
<b>Definition 1: Local Number of Unknowns</b>
</p>

<p>
The local number of unknowns of a model or block class is the sum based on the components:
</p>

<ul>
<li> For each declared component of specialized class type (Real, Integer, String, Boolean, enumeration and arrays of those, etc.) or record, not declared as outer, it is the \"number of unknown variables\" inside it (i.e., excluding parameters and constants and counting the elements after expanding all records and arrays to a set of scalars of primitive types). </li>

<li> Each declared component  of specialized class type or record declared as outer is ignored [i.e., all variables inside the component are treated as known].</li>

<li> For each declared component of specialized class connector component, it is the \"number of unknown variables\" inside it (i.e., excluding parameters and constants and counting the elements after expanding all records and arrays to a set of scalars of primitive types).</li>

<li> For each declared component of specialized class block or model, it is the \"sum of the number of inputs and flow variables\" in the (top level) public connector components of these components (and counting the elements after expanding all records and arrays to a set of scalars of primitive types).</li>
</ul>


<p>
<b>Definition 2: Local Equation Size </b>
</p>

<p>
The local equation size of a model or block class is the sum of the following numbers:
</p>

<ul>
<li>The number of equations defined locally (i.e., not in any model or block component), including binding equations, and equations generated from connect-equations. This includes the proper count for when-clauses, and algorithms, and is also used for the flat Hybrid DAE formulation.</li>

<li> The number of input and flow-variables present in each (top-level) public connector component. [This represents
the number of connection equations that will be provided when the class is used.]</li>

<li> The number of (top level) public input variables that neither are connectors nor have binding equations [i.e., top-level inputs are treated as known variables. This represents the number of binding equations that will be provided when the class is used.].
[To clarify top-level inputs without binding equation (for non-inherited inputs binding equation is identical to declaration equation, but binding equations also include the case where another model extends M and has a modifier on \"u\" giving the value):
<pre>  model M
    input Real u;
    input Real u2=2;
  end M;
</pre>
Here \"u\" and \"u2\" are top-level inputs and not connectors. The variable u2 has a binding equation, but u does not have a binding equation. In the equation count, it is assumed that an equation for u is supplied when using the model.]</li>
</ul>

<p>
<b>Definition 3: Locally Balanced</b>
</p>

<p>
A model or block class is \"locally balanced\" if the \"local number of unknowns\" is identical to the \"local equation size\" for all legal values of constants and parameters [respecting final bindings and min/max-restrictions. A tool shall verify the \"locally balanced\" property for the actual values of parameters and constants in the simulation model. It is a quality of implementation  for a tool to verify this property in general, due to arrays of (locally) undefined sizes, conditional declarations, for loops, etc.].
</p>


<p>
<b>Definition 4: Globally Balanced</b>
</p>

<p>
Similarly as locally balanced, but including all unknowns and equations from all components. The global number of unknowns is computed by expanding all unknowns (i.e., excluding parameters and constants) into a set of scalars of primitive types. This should match the global equation size defined as:
</p>

<ul>
<li> The number of equations defined (included in any model or block component), including equations generated from connect-equations.</li>
<li>The number of input and flow-variables present in each (top-level) public connector component.</li>
<li> The number of (top level) public input variables that neither are connectors nor have binding equations [i.e., top-level inputs are treated as known variables].</li>
</ul>

<p>
The following restrictions hold:
</p>

<ul>
<li>In a non-partial model or block, all non-connector inputs of model or block components must have binding equations. [E.g., if the model contains a component, firstOrder (of specialized class model) and firstOrder has  \"input Real u\" then there must be a binding equation for firstOrder.u.] </li>
<li>A component declared with the inner or outer prefix shall not be of a class having top-level public connectors containing inputs.</li>
<li>Modifiers for components shall only contain redeclarations of replaceable elements and binding equations for parameters, constants (that do not yet have binding equations), inputs and variables having a default binding equation.</li>
<li>All non-partial model and block classes must be locally balanced [this means that the local number of unknowns equals the local equation size].</li>
</ul>

<p>
Based on these restrictions, the following strong guarantee can be given for simulation models and blocks:
</p>


<p>
<b>Proposition 1: All simulation models and blocks are globally balanced.</b><br>
[Therefore the number of unknowns equal to the number of equations of a simulation model or block, provided that every used non-partial model or block class is locally balanced.]
</p>

<pre>Example 1:

connector Pin
   Real v;
   flow Real i;
end Pin;

model Capacitor
   parameter Real C;
   Pin  p, n;
   Real u;
equation
   0 = p.i + n.i;
   u = p.v - n.v;
   C*der(u) = p.i;
end Capacitor;
</pre>

<p>
Model Capacitor is a locally balanced model according to the following analysis:
</p>

<pre>Locally unknown variables: p.i, p.v, n.i, n.v, u
Local equations:  0 = p.i + n.i;
                  u = p.v - n.v;
                  C*der(u) = p.i;
                  and 2 equations corresponding to the
                  2 flow-variables p.i and n.i.
</pre>

<p>
These are 5 equations in 5 unknowns (locally balanced model). A more detailed analysis would reveal that this is structurally non-singular, i.e., that the hybrid DAE will not contain a singularity independent of actual values.
If the equation \"u = p.v - n.v\" would be missing in the Capacitor model, there would be 4 equations in 5 unknowns and the model would be locally unbalanced and thus simulation models in which this model is used would be usually  structurally singular and  thus not solvable.
If the equation \"u = p.v - n.v\" would be replaced by the equation \"u = 0\" and the equation C*der(u) = p.i would be replaced by the equation \"C*der(u) = 0\", there would be 5 equations in 5 unknowns (locally balanced), but the equations would be singular, regardless of how the equations corresponding to the flow-variables are constructed because the information that \"u\" is constant is given twice in a slightly different form.
</p>

<pre>Example 2:

connector Pin
   Real v;
   flow Real i;
end Pin;

partial model TwoPin
   Pin p,n;
end TwoPin;

model Capacitor
   parameter Real C;
   extends TwoPin;
   Real u;
equation
   0 = p.i + n.i;
   u = p.v \" n.v;
   C*der(u) = p.i;
end Capacitor;

model Circuit
   extends TwoPin;
   replaceable TwoPin t;
   Capacitor c(C=12);
equation
   connect(p, t.p);
   connect(t.n, c.p);
   connect(c.n, n);
end Circuit;
</pre>

<p>
Since t is partial we cannot check whether this is a globally balanced model, but we can check that Circuit is locally balanced.
Counting on  model Circuit results in the following balance sheet:
</p>

<pre>Locally unknown variables (8): p.i, p.v, n.i, n.v, and 2 flow variables for t (t.p.i, t.n.i)
                                                   and 2 flow variable for c (c.p.i, c.n.i).
Local equations:     p.v = t.p.v;
                       0 = p.i - t.p.i;
                   c.p.v = load.n.v;
                       0 = c.p.i+load.n.i;
                     n.v = c.n.v;
                       0 = n.i - c.n.i;
                    and 2 equation corresponding to the
                    flow variables p.i, n.i
</pre>

<p>
In total we have 8 scalar unknowns and 8 scalar equations, i.e., a locally balanced model (and this feature holds for any models used for the replaceable component \"t\").
Some more analysis reveals that this local set of equations and unknowns is structurally non-singular. However, this does not provide any guarantees for the global set of equations, and specific combinations of models that are \"locally non-singular\" may lead to a globally non-singular model.]
</p>

<pre>Example 3:

import SI = Modelica.SIunits;
partial model BaseProperties
   \"Interface of medium model for all type of media\"
   parameter Boolean preferredMediumStates=false;
   constant  Integer nXi \"Number of independent mass fractions\";
   InputAbsolutePressure     p;
   InputSpecificEnthalpy     h;
   InputMassFraction         Xi[nXi];
   SI.Temperature            T;
   SI.Density                d;
   SI.SpecificInternalEnergy u;

   connector InputAbsolutePressure = input SI.AbsolutePressure;
   connector InputSpecificEnthalpy = input SI.SpecificEnthalpy;
   connector InputMassFraction = input SI.MassFraction;
end BaseProperties;
</pre>

<p>
The use of connector here is a special design pattern. The variables p, h, Xi are marked as input to get correct equation count. Since they are connectors they should neither be given binding equations in derived classes nor when using the model. The design pattern is to give textual equations for them (as below); using connect-statements for these connectors would be possible (and would work) but is not part of the design.
This partial model defines that T,d,u can be computed from the medium model, provided p,h,Xi are given. Every medium with one or multiple substances and one or multiple phases, including incompressible media, has the property that T,d,u can be computed from p,h,Xi. A particular medium may have different \"independent variables\" from which all other intrinsic thermodynamic variables can be recursively computed. For example, a simple air model could be defined as:
</p>

<pre>model SimpleAir \"Medium model of simple air. Independent variables: p,T\"
   extends BaseProperties(nXi = 0,
        p(stateSelect = if preferredMediumStates then StateSelect.prefer
                                   else StateSelect.default),
        T(stateSelect = if preferredMediumStates then StateSelect.prefer
                                   else StateSelect.default));
   constant SI.SpecificHeatCapacity R  = 287;
   constant SI.SpecificHeatCapacity cp = 1005.45;
   constant SI.Temperature          T0 = 298.15
equation
   d = p/(R*T);
   h = cp*(T-T0);
   u = h \" p/d;
end SimpleAir;
</pre>

<p>
The local number of unknowns in model SimpleAir (after flattening) is:
</p>

<ul>
<li> 3 (T, d, u: variables defined in BaseProperties and inherited in SimpleAir), plus</li>
<li> 2+nXi (p, h, Xi: variables inside connectors defined in BaseProperties and inherited in SimpleAir)
resulting in 5+nXi unknowns.</li>
</ul>

<p>
The local equation size is:
</p>

<ul>
<li> 3 (equations defined in SimpleAir), plus</li>
<li> 2+nXi (input variables in the connectors inherited from BaseProperties)</li>
</ul>

<p>
Therefore, the model is locally balanced.
The generic medium model BaseProperties is used as a replaceable model in different components, like a dynamic volume or a fixed boundary condition:
</p>

<pre>import SI = Modelica.SIunits
connector FluidPort
  replaceable model Medium = BaseProperties;

  SI.AbsolutePressure  p;
  flow SI.MassFlowRate m_flow;

  SI.SpecificEnthalpy      h;
  flow SI.EnthalpyFlowRate H_flow;

  SI.MassFraction       Xi     [Medium.nXi] \"Independent mixture mass fractions\";
  flow SI.MassFlowRate mXi_flow[Medium.nXi] \"Independent subst. mass flow rates\";
end FluidPort;

model DynamicVolume
   parameter SI.Volume V;
   replaceable model Medium = BaseProperties;
   FluidPort port(redeclare model Medium = Medium);
   Medium    medium(preferredMediumStates=true); // No modifier for p,h,Xi
   SI.InternalEnergy U;
   SI.Mass           M;
   SI.Mass           MXi[medium.nXi];
equation
   U   = medium.u*M;
   M   = medium.d*V;
   MXi = medium.Xi*M;
   der(U)   = port.H_flow;   // Energy balance
   der(M)   = port.m_flow;   // Mass balance
   der(MXi) = port.mXi_flow; // Substance mass balance

// Equations binding to medium (inputs)
   medium.p  = port.p;
   medium.h  = port.h;
   medium.Xi = port.Xi;
end DynamicVolume;
</pre>

<p>
The local number of unknowns of DynamicVolume is:
</p>

<ul>
<li> 4+2*nXi (inside the port connector), plus</li>
<li> 2+nXi (variables U, M and MXi), plus </li>
<li> 2+nXi (the input variables in the connectors of the medium model)
</ul>

<p>
resulting in 8+4*nXi unknowns; the local equation size is
</p>

<ul>
<li> 6+3*nXi from the equation section, plus</li>
<li> 2+nXi flow variables in the port connector.</li>
</ul>

<p>
Therefore, DynamicVolume is a locally balanced model.
Note, when the DynamicVolume is used and the Medium model is redeclared to \"SimpleAir\", then a tool will try to select p,T as states, since these variables have StateSelect.prefer in the SimpleAir model (this means that the default states U,M are derived quantities). If this state selection is performed, all intrinsic medium variables are computed from medium.p and medium.T, although p and h are the input arguments to the medium model. This demonstrates that in Modelica input/output does not define the computational causality. Instead, it defines that equations have to be provided here for p,h,Xi, in order that the equation count is correct. The actual computational causality can be different as it is demonstrated with the SimpleAir model.
</p>

<pre>model FixedBoundary_pTX
   parameter SI.AbsolutePressure p \"Predefined boundary pressure\";
   parameter SI.Temperature      T \"Predefined boundary temperature\";
   parameter SI.MassFraction     Xi[medium.nXi]
                                   \"Predefined boundary mass fraction\";
   replaceable model Medium = BaseProperties;
   FluidPort port(redeclare model Medium = Medium);
   Medium medium;
equation
   port.p        = p;
   port.H_flow   = semiLinear(port.m_flow, port.h , medium.h);
   port.MXi_flow = semiLinear(port.m_flow, port.Xi, medium.Xi);

// Equations binding to medium (note: T is not an input).
   medium.p  = p;
   medium.T  = T;
   medium.Xi = Xi;
end FixedBoundary_pTX;
</pre>

<p>
The number of local variables in FixedBoundary_pTX is:
</p>

<ul>
<li> 4+2*nXi (inside the port connector), plus</li>
<li> 2+nXi (the input variables in the connectors of the medium model)</li>
</ul>

<p>
resulting in 6+3*nXi unknowns, while the local equation size is
</p>

<ul>
<li> 4+2*nXi from the equation section, plus</li>
<li> 2+nXi flow variables in the port connector.</li>
</ul>

<p>
Therefore, FixedBoundary_pTX is a locally balanced model. The predefined boundary variables p and Xi are provided via equations to the input arguments medium.p and medium.Xi, in addition there is an equation for T in the same way \" even though T is not an input. Depending on the flow direction, either the specific enthalpy in the port (port.h) or h is used to compute the enthalpy flow rate H_flow. \"h\" is provided as binding equation to the medium. With the equation \"medium.T = T\", the specific enthalpy \"h\" of the reservoir is indirectly computed via the medium equations. Again, this demonstrates, that an \"input\" just defines the number of equations have to be provided, but that it not necessarily defines the computational causality.
</p>

</html>"));
  end BalancedModel;
  class Connect "connect"
    annotation(Documentation(info = "<html>
<p>
Connect objects
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>model</b> Integrate
  Modelica.Blocks.Sources.Step step;
  Modelica.Blocks.Continuous.Integrator integrator;
<b>equation</b>
  connect(step.outPort, integrator.inPort);
<b>end</b> Integrate;</pre>

<p>Example of array use:</p>

<pre><B>connector</B> InPort = <B>input</B> Real;

<B>connector</B> OutPort = <B>output</B> Real;

<B>block</B> MatrixGain
  <B>input</B> InPort u[size(A,1)];
  <B>output</B> OutPort y[size(A,2)]
  <B>parameter</B> Real A[:,:]=[1];
<B>equation</B>
  y=A*u;
<B>end</B> MatrixGain;


  sin sinSource[5];
  MatrixGain gain(A=5*identity(5));
  MatrixGain gain2(A=ones(5,2));
  OutPort x[2];
<B>equation</B>
  <B>connect</B>(sinSource.y, gain.u); // Legal
  <B>connect</B>(gain.y, gain2.u);     // Legal
  <B>connect</B>(gain2.y, x);          // Legal</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>equation_clause :
  [ <B>initial</B> ] <B>equation</B> { equation \";\" | annotation  \";\" }

equation :
  ( simple_expression \"=\" expression
    | conditional_equation_e
    | for_clause_e
    | connect_clause
    | when_clause_e
    | IDENT function_call )
  comment

connect_clause :
  <B>connect</B> \"(\" component_reference \",\" component_reference \")\"</PRE>

<h4><font color=\"#008000\">Description</font></h4>

<P>Connections between objects are introduced by the <B>connect</B>
statement in the equation part of a class. The <B>connect</B>
construct takes two references to connectors, each of which is
either of the following forms:</P>

<UL>
  <LI>c1.c2. ... .cn, where c1 is a connector of the class, n&ge;1
      and ci+1 is a connector element of ci for i=1:(n-1).</LI>
  <LI>m.c, where m is a non-connector element in the class and c is
      a connector element of m.</LI>
</UL>

<P>There may optionally be array subscripts on any of the components;
the array subscripts shall be parameter expressions. If the connect
construct references array of connectors, the array dimensions must
match, and each corresponding pair of elements from the arrays is
connected as a pair of scalar connectors.</P>

<P>The two main tasks are to:</P>

<UL>
  <LI>Build connection sets from <B>connect </B>statements.</LI>
  <LI>Generate equations for the complete model.</LI>
</UL>

<P>Definitions:</P>

<ul>
  <li>Connection sets<br>
      A connection set is a set of variables connected by means of
      connect clauses. A connection set shall contain either only flow
      variables or only non-flow variables.</li>
  <li>Inside and outside connectors<br>
      In an element instance M, each connector element of M is called
      an outside connector with respect to M. All other connector elements
      that are hierarchically inside M, but not in one of the outside
      connectors of M, is called an inside connector with respect to M.<br>
      <i>[Example: in connect(a,b.c) 'a' is an outside connector and 'b.c'
      is an inside connector, unless 'b' is a connector.]</i></li>
</ul>
</html>"));
  end Connect;
  class Encapsulated "encapsulated"
    annotation(Documentation(info = "<html>
<p>
Break lookup in hierarchy
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>encapsulated model</b> Test
  <b>import</b> Modelica.Mechanics.Rotational;

  Rotational.Components.Inertia inertia; // lookup successful
  Modelica.Mechanics.Translational.SlidingMass slidingMass; // lookup fails
<b>equation</b>
  ...
<b>end</b> Test;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>class_definition :
   [ <B>encapsulated</B> ]
   [ <B>partial</B> ]
   ( <B>class</B> | <B>model</B> | <B>record</B> | <B>block</B> | <B>connector</B> | <B>type</B> |
     <B>package</B> | <b>function</B> )
   IDENT class_specifier</PRE>

<h4><font color=\"#008000\">Description</font></h4>

<p>When an element, equation or algorithm is instantiated, any name is
looked up sequentially in each member of the ordered set of parents
until a match is found or a parent is encapsulated. In the latter case
the lookup stops except for the predefined types, functions and
operators defined in this specification. For these cases the lookup
continues in the global scope, where they are defined. <i>[E.g., abs is
searched upwards in the hierarchy as usual. If an encapsulated boundary
is reached, abs is searched in the global scope instead. The operator
abs cannot be redefined in the global scope, because an existing class
cannot be redefined at the same level.]</i></p>
</html>"));
  end Encapsulated;
  class Extends "extends"
    annotation(Documentation(info = "<html>
<p>
Inheritance from base class
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<PRE><B>class</B> A
  <B>parameter</B> Real a, b;
<B>end</B> A;

<B>class</b> B
  <B>extends</b> A(b=2);
<B>end</B> B;

<B>class</b> C
  <B>extends</b> B(a=1);
<B>end</B> C;</PRE>

<p>From the example above we get the following instantiated
class:</P>

<PRE><B>class</b> Cinstance
  <B>parameter</b> Real a=1;
  <B>parameter</b> Real b=2;
<B>end</b> Cinstance;</PRE>

<p>The ordering of the merging rules ensures that, given
classes A and B defined above,</P>

<PRE><B>class</b> C2
  B bcomp(b=3);
<B>end</B> C2;</PRE>

<p>yields an instance with <TT>bcomp.b=3</TT>, which overrides <TT>b=2</TT>.</P>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>class_definition :
   [ <B>encapsulated</B> ]
   [ <B>partial</b> ]
   ( <B>class</b> | <B>model</b> | <B>record</b> | <B>block</b> | <B>connector</b> | <B>type</b> |
     <B>package</B> | <b>function</b> )
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment

composition  :
   element_list
   { <B>public</b> element_list |
     <B>protected</b> element_list |
     equation_clause |
     algorithm_clause
   }
   [ <B>external</b> [ language_specification ]
              [ external_function_call ] [ annotation \";\" ]
              [ annotation  \";\" ] ]

element_list :
   { element \";\" | annotation  \";\" }

element :
   import_clause |
   extends_clause |
   [ <B>final</B> ]
   [ <B>inner</B> | <B>outer</B> ]
   ( ( class_definition | component_clause) |
     <B>replaceable</B> ( class_definition | component_clause)
        [constraining_clause comment])

extends_clause :
   <B>extends</b> name [ class_modification ]</PRE>

<h4><font color=\"#008000\">Description</font></h4>

<P>The name of the base class is looked up in the partially
instantiated parent of the extends clause. The found base
class is instantiated with a new environment and the
partially instantiated parent of the extends clause. The new
environment is the result of merging</P>

<OL>
  <LI>arguments of all parent environments that match names in the instantiated base class</LI>
  <LI>the optional class modification of the extends clause</LI>
</OL>

<P>in that order.</P>

<P>The elements of the instantiated base class become elements
of the instantiated parent class.</P>

<P>The declaration elements of the instantiated base class shall either</P>

<UL>
  <LI>not already exist in the partially instantiated parent class
      <I>[i.e., have different names]</I>.</LI>
  <LI>be exactly identical to any element of the instantiated parent
      class with the same name and the same level of protection
      (<B>public</B> or <B>protected</B>) and same contents. In this
      case, one of the elements is ignored (since they are identical
      it does not matter which one).</LI>
</UL>

<P>Otherwise the model is incorrect.</P>

<P>Equations of the instantiated base class that are syntactically
equivalent to equations in the instantiated parent class are discarded.
<I>[Note: equations that are mathematically equivalent but not
syntactically equivalent are not discarded, hence yield an
overdetermined system of equations.]</I></P>


<p><span>Since
specialized classes of different
kinds have different properties,
only specialized classes that are \"in some sense
compatible\" to
each other can be derived from each other via inheritance. The
following table
shows which kind of specialized class can be used in an extends clauses
of
another kind of specialized class:</span></p>

<table
 style=\"border: medium none ; margin-left: 23.4pt; border-collapse: collapse;\"
 border=\"1\" cellpadding=\"0\" cellspacing=\"0\">
  <tbody>
    <tr style=\"page-break-inside: avoid; height: 15pt;\">
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"110\">
      <p style=\"text-indent: 0pt;\"><span
>&nbsp;</span></p>
      </td>
      <td colspan=\"7\"
 nowrap=\"nowrap\" valign=\"top\" width=\"418\">
      <p
><b><span
>Base Class</span></b></p>
      </td>
    </tr>
    <tr style=\"page-break-inside: avoid; height: 15pt;\">
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"110\">
      <p style=\"text-indent: 0pt;\"><b><span
>Derived Class</span></b></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"66\">
      <p>
<span>package</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p><span
>function</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"40\">
      <p><span
>type</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p><span
>record</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"72\">
      <p><span
>connector</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"52\">
      <p><span
>block</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"60\">
      <p><span
>model</span></p>
      </td>
    </tr>
    <tr style=\"page-break-inside: avoid;\">
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"110\">
      <p style=\"text-indent: 0pt;\"><span
>package</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"66\">
      <p><span
>yes</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p><span
>&nbsp;</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"40\">
      <p><span
>&nbsp;</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p><span
>&nbsp;</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"72\">
      <p><span
>&nbsp;</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"52\">
      <p><span
>&nbsp;</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"60\">
      <p><span
>&nbsp;</span></p>
      </td>
    </tr>
    <tr style=\"page-break-inside: avoid;\">
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"110\">
      <p style=\"text-indent: 0pt;\"><span
>function</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"66\">
      <p><span
>&nbsp;</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>yes</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"40\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"72\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"52\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"60\">
      <p
><span
>&nbsp;</span></p>
      </td>
    </tr>
    <tr style=\"page-break-inside: avoid;\">
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"110\">
      <p style=\"text-indent: 0pt;\"><span
>type</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"66\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"40\">
      <p
><span
>yes</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"72\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"52\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"60\">
      <p
><span
>&nbsp;</span></p>
      </td>
    </tr>
    <tr style=\"page-break-inside: avoid;\">
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"110\">
      <p style=\"text-indent: 0pt;\"><span
>record</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"66\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"40\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>yes</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"72\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"52\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"60\">
      <p
><span
>&nbsp;</span></p>
      </td>
    </tr>
    <tr style=\"page-break-inside: avoid;\">
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"110\">
      <p style=\"text-indent: 0pt;\"><span
>connector</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"66\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"40\">
      <p
><span
>yes</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>yes</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"72\">
      <p
><span
>&nbsp;yes</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"52\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"60\">
      <p
><span
>&nbsp;</span></p>
      </td>
    </tr>
    <tr style=\"page-break-inside: avoid;\">
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"110\">
      <p style=\"text-indent: 0pt;\"><span
>block</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"66\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"40\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>yes</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"72\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"52\">
      <p
><span
>yes</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"60\">
      <p
><span
>&nbsp;</span></p>
      </td>
    </tr>
    <tr style=\"page-break-inside: avoid;\">
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"110\">
      <p style=\"text-indent: 0pt;\"><span
>model</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"66\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"40\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"64\">
      <p
><span
>yes</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"72\">
      <p
><span
>&nbsp;</span></p>
      </td>
      <td
 nowrap=\"nowrap\" valign=\"top\" width=\"52\">
      <p
><span
>yes</span></p>
      </td>
      <td

 nowrap=\"nowrap\" valign=\"top\" width=\"60\">
      <p
><span
>yes</span></p>
      </td>
    </tr>
  </tbody>
</table>
<p><span>The
specialized classes </span><span class=\"CODE\"><span
 style=\"font-size: 9.5pt;\">package</span></span><span
>, </span><span class=\"CODE\"><span
 style=\"font-size: 9.5pt;\">function</span></span><span
>, </span><span class=\"CODE\"><span
 style=\"font-size: 9.5pt;\">type</span></span><span
> and record can only be derived from their own
kind [<i>(e.g., a
package can only be base class for packages. All other kinds of classes
can use
the import statement to use the contents of a package)</i>]<i>.</i></span></p>


</html>"));
  end Extends;
  class Flow "flow"
    annotation(Documentation(info = "<html>
<p>
Declare flow (through) variable, which have to sum up to zero in connections
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>connector</b> Pin
  Modelica.SIunits.Voltage v;
  <b>flow</b> Modelica.SIunits.Current i;
<b>end</b> Pin;

<b>model</b> A
  Pin p;
<b>end</b> A;

<b>model</b> Composition
  A a;
  A b;
  A c;
<b>equation
  connect</b>(a.p, b.p);
  <b>connect</b>(a.p, c.p);
<b>end</b> Composition;</pre>

<p>From the connect statements in model Composition, the following connect equations are derived:</p>

<pre>a.p.v = b.p.v;
a.p.v = c.p.v;
a.p.i + b.p.i + c.p.i = 0;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>class_definition :
   [ <B>encapsulated</B> ]
   [ <B>partial</b> ]
   ( <B>class</b> | <B>model</b> | <B>record</b> | <B>block</b> | <B>connector</b> | <B>type</b> |
     <B>package</B> | <b>function</b> )
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment

base_prefix :
   type_prefix

composition  :
   element_list
   { <B>public</b> element_list |
     <B>protected</b> element_list |
     equation_clause |
     algorithm_clause
   }
   [ <B>external</b> [ language_specification ]
              [ external_function_call ] [ annotation \";\" ]
              [ annotation  \";\" ] ]

element_list :
   { element \";\" | annotation  \";\" }

element :
   import_clause |
   extends_clause |
   [ <B>final</B> ]
   [ <B>inner</B> | <B>outer</B> ]
   ( ( class_definition | component_clause) |
     <B>replaceable</B> ( class_definition | component_clause)
        [constraining_clause comment])

component_clause:
   type_prefix type_specifier [ array_subscripts ] component_list

type_prefix :
   [ <B>flow</b> ]
   [ <B>discrete</B> | <B>parameter</b> | <B>constant</b> ] [ <B>input</b> | <B>output</b> ]</PRE>

<h4><font color=\"#008000\">Description</font></h4>

<p>The flow prefix is used in order to generate equations for through variables, which sum up to zero in connections,
whereas variables without the flow prefix are identical in a connection.</p>
</html>"));
  end Flow;
  class For "for"
    annotation(Documentation(info = "<html>
<p>
Repeat equations or statements a specific number of times
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<p>
<b>for</b> clauses are mostly used in algorithm sections, such as
</p>
<pre>
    <b>parameter</b> Integer np=10;
    Real p[np], x, y;
  <b>algorithm</b>
     y := p[1];
     <b>for</b> i <b>in</b> 2:np <b>loop</b>   // i shall not be declared
        y := y*x + p[i];
     <b>end for</b>;
</pre>
<p>
Other forms of the <b>for</b> condition:
</p>
<pre>
    <b>for</b> i <b>in</b> 1:10 <b>loop</b>            // i takes the values 1,2,3,...,10
    <b>for</b> r <b>in</b> 1.0 : 1.5 : 5.5 <b>loop</b> // r takes the values 1.0, 2.5, 4.0, 5.5
    <b>for</b> i <b>in</b> {1,3,6,7} <b>loop</b>       // i takes the values 1, 3, 6, 7
</pre>
<p>
In equation sections, <b>for</b> clauses are expanded at translation time
in order that symbolic transformations can be applied. Typically, a
<b>for</b> clause in an equation section is used on component arrays,
e.g., to connect elements of an array of components together:
</p>
<pre>
    <b>parameter</b> Integer nR=10 \"Number of resistances\";
    Modelica.Electrical.Analog.Basic.Resistor R[nR];
  <b>equation</b>
     <b>for</b> i <b>in</b> 1:nR-1 <b>loop</b>
        <b>connect</b>(R[i].p R[i+1].n);   // 9 connect equations
     <b>end for</b>;
</pre>
<h4><font color=\"#008000\">Syntax</font></h4>
<p>
In equation sections:
</p>
<pre>
  <b>for</b> for_indices <b>loop</b>
     { equation \";\" }
  <b>end for</b>;
  for_indices : for_index {\",\" for_index}
  for_index   : IDENT [ in expression ]
</pre>
<p>
In algorithm sections:
</p>
<pre>
  <b>for</b> for_indices <b>loop</b>
     { algorithm \";\" }
  <b>end for</b>;
  for_indices : for_index {\",\" for_index}
  for_index   : IDENT [ in expression ]
</pre>
<h4><font color=\"#008000\">Description</font></h4>
<p>A clause</p>
<pre>    <b>for</b> IDENT <b>in</b> expression <b>loop</b></pre>
<p>is one example of a for clause.</p>
<p>The expression of a for clause shall be a vector expression. It is
evaluated once for each for clause, and is evaluated in the scope
immediately enclosing the for clause. In an equation section,
the expression of a for clause shall be a parameter expression (in order
that the for clause can be expanded into equations during translation).
The loop-variable is in scope inside the loop-construct and shall not be assigned
to.</p>
<p><i>[Example:</i></p>
<p><i>The loop-variable may hide other variables as in the following example.
Using another name for the loop-variable
is, however, strongly recommended.</i></p>
<pre>    <b>constant</b> Integer j=4;
    Real x[j];
  <b>equation</b>
    <b>for</b> j <b>in</b> 1:j <b>loop</b> // The loop-variable j takes the values 1,2,3,4
      x[j]=j; // Uses the loop-variable j
    <b>end for</b>;</pre>
<p><i>]</i></p>
<h4>Several iterators</h4>
<p>The notation with several iterators is a shorthand notation for nested for-clauses (or reduction-expressions). For
for-clauses it can be expanded into the usual form by replacing each \",\" by <tt>'loop for'</tt> and adding extra <tt>'end
for'</tt>. For reduction-expressions it can be expanded into the usual form by replacing each ',' by <tt>') for'</tt> and
prepending the reduction-expression with <tt>'function-name('</tt>.</p>
<p><i>[Example:</i></p>
<pre>    Real x[4,3];
  <b>equation</b>
    <b>for</b> j, i in 1:2 <b>loop</b>
      // The loop-variable j takes the values 1,2,3,4 (due to use)
      // The loop-variable i takes the values 1,2 (given range)
      x[j,i]=j+i;
    <b>end for</b>;</pre>
<p><i>]</i></p>
</html>"));
  end For;
  class If "if"
    annotation(Documentation(info = "<html>
<p>
Declare equations or execute statements conditionally
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<h4>If clause</h4>

<pre>    <b>parameter</b> Boolean linear=true;
    <b>parameter</b> Boolean quadratic=false;
    Real x, y;
  <b>equation</b>
    <b>if</b> linear <b>then</b>
      y = x + 1;
    <b>elseif</b> quadratic <b>then</b>
      y = x^2 + x + 1;
    <b>else</b>
      y = Modelica.Math.sin(x) + 1;
    <b>end if</b>;</pre>

<h4>If expression</h4>
<PRE>  Integer i;
  Integer sign_of_i=<B>if</B> i&lt;0 <B>then</B> -1 <B>else if</B> i==0 <B>then</B> 0 <B>else</B> 1;</PRE>
<h4><font color=\"#008000\">Syntax</font></h4>
<p>
In equation sections:
</p>
<PRE>   <B>if</B> expression <B>then</B>
     { equation \";\" }
   { <B>elseif </B>expression <B>then</B>
     { equation \";\" }
   }
   [ <B>else</B>
     { equation \";\" }
   ]
   <B>end if</B></pre>
<p>
In algorithm sections:
</p>
<pre>   <B>if</B> expression <B>then</B>
     { algorithm \";\" }
   { <B>elseif </B>expression <B>then</B>
     { algorithm \";\" }
   }
   [ <B>else</B>
     { algorithm \";\" }
   ]
   <B>end if</B></PRE>
<h4><font color=\"#008000\">Description</font></h4>
<h4>If clause</h4>
<P>
The expression of an <B>if</B> and <B>elseif</B>-clause must be scalar boolean expression.
One <B>if</B>-clause, and zero or more <B>elseif</B>-clauses, and an optional <B>else</B>-clause
together form a list of branches. One or zero of the bodies of these <B>if</B>-, <B>elseif</B>-
and <B>else</B>-clauses is selected, by evaluating the conditions of the <B>if</B>- and
<B>elseif</B>-clauses sequentially until a condition that evaluates to true is found. If none of
the conditions evaluate to true the body of the <B>else</B>-clause is selected (if an
<B>else</B>-clause exists, otherwise no body is selected). In an algorithm section, the selected
body is then executed. In an equation section, the equations in the body are seen as equations
that must be satisfied. The bodies that are not selected have no effect on that model evaluation.
</P>
<P>
If clauses in <B>equation </B>sections which do not have exclusively parameter expressions as
switching conditions shall have an <B>else</B> clause and each branch shall have the <I>same
number</I> of <I>equations</I>. <I>[If this condition is violated, the single assignment rule
would not hold, because the number of equations may change during simulation although the number
of unknowns remains the same].</I>
</P>

<h4>If expression</h4>

<P>An expression</P>
<pre>   <B>if</B> expression1 <B>then</B> expression2 <B>else</B> expression3</pre>
<P>is one example of if-expression. First expression1, which must be boolean expression,
is evaluated. If expression1 is true expression2 is evaluated and is the value of the
if-expression, else expression3 is evaluated and is the value of the if-expression.
The two expressions, expression2 and expression3, must be type compatible and give the
type of the if-expression. If-expressions with <B>elseif</B> are defined by replacing
<B>elseif</B> by <B>else if</B>.<I>[Note: elseif is added for symmetry with if-clauses.]</I>
</P>
</html>"));
  end If;
  class Import "import"
    annotation(Documentation(info = "<html>
<p>
Import classes
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>class</b> Lookup
  <b>import</b> SI = Modelica.SIunits; // #1
  <b>import</b> Modelica.Math.*; // #2
  <b>import</b> Modelica.Mechanics.Rotational; // #3

  SI.Torque torque; // due to #1 (Modelica.SIunits.Torque)
  Rotational.Components.Inertia inertia; // due to #3 (Modelica.Mechanics.Rotational.Components.Inertia)
<b>equation</b>
  torque = sin(<b>time</b>); // due to #2 (Modelica.Math.sin)
  ...
<b>end</b> Lookup;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>class_definition :
   [ <B>encapsulated</B> ]
   [ <B>partial</b> ]
   ( <B>class</b> | <B>model</b> | <B>record</b> | <B>block</b> | <B>connector</b> | <B>type</b> |
     <B>package</B> | <b>function</b> )
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment

composition  :
   element_list
   { <B>public</b> element_list |
     <B>protected</b> element_list |
     equation_clause |
     algorithm_clause
   }
   [ <B>external</b> [ language_specification ]
              [ external_function_call ] [ annotation \";\" ]
              [ annotation  \";\" ] ]

element_list :
   { element \";\" | annotation  \";\" }

element :
   import_clause |
   extends_clause |
   [ <B>final</B> ]
   [ <B>inner</B> | <B>outer</B> ]
   ( ( class_definition | component_clause) |
     <B>replaceable</B> ( class_definition | component_clause)
        [constraining_clause comment])

import_clause :
   <B>import</B> ( IDENT \"=\" name | name [\".\" \"*\"] ) comment</PRE>
<h4><font color=\"#008000\">Description</font></h4>

<p>Using import statements extends the static name lookup to additional import names.
The generated import names are:</p>

<ul>
  <li><tt>C</tt> for <tt><b>import</b> A.B.C;</tt></li>
  <li><tt>D</tt> for <tt><b>import</b> D = A.B.C;</tt></li>
  <li><tt>C</tt> and all other classes in B for <tt><b>import</b> A.B.*;</tt></li>
</ul>
</html>"));
  end Import;
  class Input "input"
    annotation(Documentation(info = "<html>
<p>
Define causality and/or block diagram connection semantic
(depending on context)
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>connector</b> RealInput = <b>input</b> Real;
<b>connector</b> RealOutput = <b>output</b> Real;

<b>block</b> Integrator
  RealInput  u;
  RealOutput y;
<b>protected</b>
  Real x;
<b>equation</b>
  <b>der</b>(x) = u;
  y = x;
<b>end</b> Integrator;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>class_definition :
   [ <B>encapsulated</B> ]
   [ <B>partial</b> ]
   ( <B>class</b> | <B>model</b> | <B>record</b> | <B>block</b> | <B>connector</b> | <B>type</b> |
     <B>package</B> | <b>function</b> )
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment

base_prefix :
   type_prefix

composition  :
   element_list
   { <B>public</b> element_list |
     <B>protected</b> element_list |
     equation_clause |
     algorithm_clause
   }
   [ <B>external</b> [ language_specification ]
              [ external_function_call ] [ annotation \";\" ]
              [ annotation  \";\" ] ]

element_list :
   { element \";\" | annotation  \";\" }

element :
   import_clause |
   extends_clause |
   [ <B>final</B> ]
   [ <B>inner</B> | <B>outer</B> ]
   ( ( class_definition | component_clause) |
     <B>replaceable</B> ( class_definition | component_clause)
        [constraining_clause comment])

component_clause:
   type_prefix type_specifier [ array_subscripts ] component_list

type_prefix :
   [ <B>flow</b> ]
   [ <B>discrete</B> | <B>parameter</b> | <B>constant</b> ] [ <B>input</b> | <B>output</b> ]</PRE>

<h4><font color=\"#008000\">Description</font></h4>

<p>
The prefixes <b>input</b> and <b>output</b> have a slightly different semantic meaning depending on the context where they are used:
</p>

<ul>
<li> In functions, these prefixes define the computational causality of the
     function body, i.e., given the variables declared as input,
     the variables declared as output are computed in the function body<br>&nbsp;</li>.

<li> In simulation models and blocks (i.e., on the top level of a model or
     block that shall be simulated), these prefixes define the interaction
     with the environment where the simulation model or block is used.
     Especially, the input prefix defines that values for such a variable
     have to be provided from the simulation environment and the output
     prefix defines that the values of the corresponding variable
     can be directly utilized in the simulation environment.<br>&nbsp;</li>

<li> In component models and blocks, the input prefix defines that a
     binding equation has to be provided for the corresponding variable
     when the component is utilized in order to guarantee a locally
     balanced model (i.e., the number of local equations is identical
     to the local number of unknowns). Example:
<pre>  <b>block</b> FirstOrder
     <b>input</b> Real u;
       ...
  <b>end</b> FirstOrder;

  <b>model</b> UseFirstOrder
     FirstOrder firstOrder(u=time); // binding equation for u
      ...
  <b>end</b> UseFirstOrder;
</pre>
     The output prefix does not have a particular effect in a model
     or block component and is ignored.<br>&nbsp;</li>

<li> In connectors, prefixes input and output define that the
     corresponding connectors can only be connected according
     to block diagram semantics (e.g., a connector with an output
     variable can only be connected to a connector where the
     corresponding variable is declared as input). There is the
     restriction that connectors which have at least one variable
     declared as input must be externally connected
     (in order to get a locally balanced model, where the number
     of local unknowns is identical to the number of unknown equations).
     Together with the block diagram semantics rule this means,
     that such connectors must be connected exactly once externally.<br>&nbsp;</li>

<li> In records, prefixes input and output are not allowed,
     since otherwise a record could not be, e.g., passed as input
     argument to a function.</li>
</ul>

</html>"));
  end Input;
  class Output "output"
    annotation(Documentation(info = "<html>
<p>
Define causality and/or block diagram connection semantic
(depending on context)
</p>

<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>connector</b> RealInput = <b>input</b> Real;
<b>connector</b> RealOutput = <b>output</b> Real;

<b>block</b> Integrator
  RealInput  u;
  RealOutput y;
<b>protected</b>
  Real x;
<b>equation</b>
  <b>der</b>(x) = u;
  y = x;
<b>end</b> Integrator;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>class_definition :
   [ <B>encapsulated</B> ]
   [ <B>partial</b> ]
   ( <B>class</b> | <B>model</b> | <B>record</b> | <B>block</b> | <B>connector</b> | <B>type</b> |
     <B>package</B> | <b>function</b> )
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment

base_prefix :
   type_prefix

composition  :
   element_list
   { <B>public</b> element_list |
     <B>protected</b> element_list |
     equation_clause |
     algorithm_clause
   }
   [ <B>external</b> [ language_specification ]
              [ external_function_call ] [ annotation \";\" ]
              [ annotation  \";\" ] ]

element_list :
   { element \";\" | annotation  \";\" }

element :
   import_clause |
   extends_clause |
   [ <B>final</B> ]
   [ <B>inner</B> | <B>outer</B> ]
   ( ( class_definition | component_clause) |
     <B>replaceable</B> ( class_definition | component_clause)
        [constraining_clause comment])

component_clause:
   type_prefix type_specifier [ array_subscripts ] component_list

type_prefix :
   [ <B>flow</b> ]
   [ <B>discrete</B> | <B>parameter</b> | <B>constant</b> ] [ <B>input</b> | <B>output</b> ]</PRE>

<h4><font color=\"#008000\">Description</font></h4>

<p>
The prefixes <b>input</b> and <b>output</b> have a slightly different semantic meaning depending on the context where they are used:
</p>

<ul>
<li> In functions, these prefixes define the computational causality of the
     function body, i.e., given the variables declared as input,
     the variables declared as output are computed in the function body<br>&nbsp;</li>.

<li> In simulation models and blocks (i.e., on the top level of a model or
     block that shall be simulated), these prefixes define the interaction
     with the environment where the simulation model or block is used.
     Especially, the input prefix defines that values for such a variable
     have to be provided from the simulation environment and the output
     prefix defines that the values of the corresponding variable
     can be directly utilized in the simulation environment.<br>&nbsp;</li>

<li> In component models and blocks, the input prefix defines that a
     binding equation has to be provided for the corresponding variable
     when the component is utilized in order to guarantee a locally
     balanced model (i.e., the number of local equations is identical
     to the local number of unknowns). Example:
<pre>  <b>block</b> FirstOrder
     <b>input</b> Real u;
       ...
  <b>end</b> FirstOrder;

  <b>model</b> UseFirstOrder
     FirstOrder firstOrder(u=time); // binding equation for u
      ...
  <b>end</b> UseFirstOrder;
</pre>
     The output prefix does not have a particular effect in a model
     or block component and is ignored.<br>&nbsp;</li>

<li> In connectors, prefixes input and output define that the
     corresponding connectors can only be connected according
     to block diagram semantics (e.g., a connector with an output
     variable can only be connected to a connector where the
     corresponding variable is declared as input). There is the
     restriction that connectors which have at least one variable
     declared as input must be externally connected
     (in order to get a locally balanced model, where the number
     of local unknowns is identical to the number of unknown equations).
     Together with the block diagram semantics rule this means,
     that such connectors must be connected exactly once externally.<br>&nbsp;</li>

<li> In records, prefixes input and output are not allowed,
     since otherwise a record could not be, e.g., passed as input
     argument to a function.</li>
</ul>

</html>"));
  end Output;
  class Partial "partial"
    annotation(Documentation(info = "<html>
<p>
Prohibit instantiation of components of the class
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<pre><b>partial block</b> BaseBlock
  <b>input</b> Real u;
  <b>output</b> Real y;
<b>protected</b>
  Real x;
<b>equation</b>
  x = y;
<b>end</b> BaseBlock;

<b>block</b> Integrator
  <b>extends</b> BaseBlock;
<b>equation
  der</b>(x) = u;
<b>end</b> Integrator;

<b>block</b> Gain
  <b>extends</b> BaseBlock;
  <b>parameter</b> k = 1;
<b>equation</b>
  x = k*u;
<b>end</b> Gain;

<b>model</b> Composition
  BaseBlock block1; // Illegal
  Integrator block2; // Legal
  Gain block3; // Legal
<b>end</b> Composition;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>class_definition :
   [ <B>encapsulated</B> ]
   [ <B>partial</b> ]
   ( <B>class</b> | <B>model</b> | <B>record</b> | <B>block</b> | <B>connector</b> | <B>type</b> |
     <B>package</B> | <b>function</b> )
   IDENT class_specifier

class_specifier :
   string_comment composition <B>end</B> IDENT
   | \"=\" base_prefix name [ array_subscripts ] [ class_modification ] comment
   | \"=\" <B>enumeration</B> \"(\" ( [enum_list] | \":\" ) \")\" comment</PRE>

</html>"));
  end Partial;
  class Time "time"
    annotation(Documentation(info = "<html>
<p>
Built-in variable time
</p>
<h4><font color=\"#008000\">Examples</font></h4>

<PRE><B>encapsulated model</B> SineSource
  <B>import</B> Modelica.Math.sin;
  <B>connector</B> OutPort=<B>output</B> Real;
  OutPort y=sin(time); // Uses the built-in variable time.
<B>end</B> SineSource;</PRE>

<h4><font color=\"#008000\">Syntax</font></h4>

<pre><b>time</b></pre>

<h4><font color=\"#008000\">Description</font></h4>

<P>All declared variables are functions of the independent
variable <B>time</B>. Time is a built-in variable available
in all classes, which is treated as an input variable. It
is implicitly defined as:</P>

<PRE><B>input</B> Real time (<B>final</B> quantity = \"Time\",
                 <B>final</B> unit     = \"s\");</PRE>

<P>The value of the <B>start</B> attribute of time is set to
the time instant at which the simulation is started.</P>

</html>"));
  end Time;
  class When "when"
    annotation(Documentation(info = "<html>
<p>
Activate equations or statements when condition becomes true
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<PRE> <B>equation
   when</B> x &gt; 2 <B>then</B>
     y3 = 2*x +y1+y2; // Order of y1 and y3 equations does not matter
     y1 = sin(x);
   <B>end when</B>;
   y2 = sin(y1);</PRE>

<h4><font color=\"#008000\">Syntax</font></h4>

<p>
In equation sections:
</p>

<PRE>  <B>when</B> expression <B>then</B>
    { equation \";\" }
  { <B>elsewhen</B> expression <B>then</B>
    { equation \";\" } }
  <B>end when</B></PRE>

<p>
In algorithm sections:
</p>
<PRE>  <B>when</B> expression <B>then</B>
    { algorithm \";\" }
  { <B>elsewhen</B> expression <B>then</B>
    { algorithm \";\" } }
  <B>end when</B></PRE>

<h4><font color=\"#008000\">Description</font></h4>

<P>The expression of a when clause shall be a discrete-time Boolean scalar
or vector expression. The equations and algorithm statements within a when
clause are activated when the scalar or any one of the elements of the vector
expression becomes true. When-clauses in equation sections are allowed, provided
the equations within the when-clause have one of the following forms:</P>

<UL>
  <LI>v = expr;</LI>
  <LI> (out1, out2, out3, ...) = function_call(in1, in2, ...);</LI>
  <LI>operators <B>assert</B>(), <B>terminate</B>(), <B>reinit</B>()</LI>
  <LI><B>For</B> and <B>if</B>-clause if the equations within the <B>for</B> and <B>if</B>-clauses satisfy these requirements.</LI>
  <LI>In an equation section, the different branches of when/elsewhen must have the same set of component references on the left-hand side.</LI>
  <LI>In an equation section, the branches of an if-then-else clause inside when-clauses must have the same set of component references on the left-hand side, unless the if-then-else have exclusively parameter expressions as switching conditions.</LI>
</UL>

<P>A when clause shall not be used within a function class.</P>

<P><I>[Example:</i></P>

<P><i>Algorithms are activated when x becomes &gt; 2:</I></P>

<PRE>   <B>when</B> x &gt; 2 <B>then</B>
     y1 := sin(x);
     y3 := 2*x + y1 + y2;
   <B>end when</B>;</PRE>

<P><I>Algorithms are activated when either x becomes &gt; 2 or sample(0,2) becomes true or x becomes less than 5:</I></P>

<PRE>   <B>when</B> {x &gt; 2, sample(0,2), x &lt; 5} <B>then</B>
     y1 := sin(x);
     y3 := 2*x + y1 + y2;
   <B>end when</B>;</PRE>

<P><I>For when in equation sections the order between the equations does not matter, e.g.,</I></P>
<PRE> <B>equation
   when</B> x &gt; 2 <B>then</B>
     y3 = 2*x +y1+y2; // Order of y1 and y3 equations does not matter
     y1 = sin(x);
   <B>end when</B>;
   y2 = sin(y1);</PRE>

<P><I>The needed restrictions on equations within a when-clause becomes apparent with the following example:</I></P>

<PRE>   Real x, y;
<B>equation</B>
   x + y = 5;
   <B>when</B> condition <B>then</B>
      2*x + y = 7;         // error: not valid Modelica
   <B>end when</B>;</PRE>


<P><I>When the equations of the when-clause are not activated it is not clear which
variable to hold constant, either x or y. A corrected version of this example is:</I></P>

<PRE>   Real x, y;
<B>equation</B>
   x + y = 5;
   <B>when</B> condition <B>then</B>
      y = 7 - 2*x;        // fine
   <B>end when</B>;</PRE>

<P><I>Here, variable y is held constant when the when-clause is de-activated and x
is computed from the first equation using the value of y from the previous event instant.</i></P>

<P><i>For when in algorithm sections the order is significant and it is advisable to have only
one assignment within the when-clause and instead use several algorithms having when-clauses
with identical conditions, e.g.,</I></P>

<PRE> <B>algorithm</B>
   <B>when</B> x &gt; 2 <B>then</B>
     y1 := sin(x);
   <B>end when</B>;
 <B>equation</B>
   y2 = sin(y1);
 <B>algorithm</B>
   <B>when</B> x &gt; 2 <B>then</B>
     y3 := 2*x + y1 + y2;
   <B>end when</B>;</PRE>

<P><I>Merging the when-clauses can lead to less efficient code and different models
with different behaviour depending on the order of the assignment to y1 and y3 in the algorithm.]</I></P>

<P>A when clause</P>

<PRE> <B>algorithm
   when</B> {x&gt;1, <B>..., </B>y&gt;p} <B>then
     ...
   elsewhen</B> x &gt; y.start <B>then
     ...
   end when</B>;</PRE>

<P>is equivalent to the following special if-clause, where Boolean b1[N]
and Boolean b2 are necessary because the <B>edge</B>() operator can only
be applied to variables</P>

<PRE>   Boolean b1[N](start={x.start&gt;1,<B> ..., </B>y.start&gt;p});
   Boolean b2(start=x.start&gt;y.start);
 <B>algorithm</B>
   b1:={x&gt;1, ..., y&gt;p};
   b2:=x&gt;y.start;

   <B>if edge</B>(b1[1]) <B>or edge</B>(b1[2]) <B>or ... edge</B>(b1[N]) <B>then
     ...
   elseif edge</B>(b2) <B>then
     ...
   end if</B>;</PRE>

<P>with &quot;<B>edge</B>(A)= A <B>and not pre</B>(A)&quot; and the additional
guarantee, that the algorithms within this special if clause are only evaluated
at event instants.</P>

<P>A when-clause</P>

<PRE> <B>equation
   when</B> x&gt;2 <B>then</B>
     v1 = expr1 ;
     v2 = expr2 ;
   <B>end when</B>;</PRE>

<P>is equivalent to the following special if-expressions</P>

<PRE>   Boolean b(start=x.start&gt;2);
 <B>equation</B>
   b  = x&gt;2;
   v1 = <B>if edge</B>(b) <B>then</B> expr1 <B>else pre</B>(v1);
   v2 = <B>if edge</B>(b) <B>then</B> expr2 <B>else pre</B>(v2);</PRE>

<P>The start-values of the introduced boolean variables are defined by
the taking the start-value of the when-condition, as above where p is a
parameter variable. The start-values of the special functions
<B>initial</B>, <B>terminal</B>, and <B>sample</B> is false.</P>

<P>When clauses cannot be nested.</P>

<P><I>[Example:</i></P>

<P><i>The following when clause is invalid:</I></P>

<PRE>   <B>when</B> x &gt; 2 <B>then
     when</B> y1 &gt; 3 <B>then</B>
       y2 = sin(x);
     <B>end when</B>;
   <B>end when</B>;</PRE>

<P><I>]</I></P>
</html>"));
  end When;
  class While "while"
    annotation(Documentation(info = "<html>
<p>
Repeat statements as long as a condition is fulfilled
</p>
<h4><font color=\"#008000\">Examples</font></h4>
<pre>    Integer i;
  <b>algorithm</b>
    i := 1;
    <b>while</b> i &lt; 10 <b>loop</b>
      i := i + 1;
      <b>...
    end while</b>;</pre>

<h4><font color=\"#008000\">Syntax</font></h4>

<PRE>  <B>while</B> expression <B>loop</B>
    { algorithm \";\" }
  <B>end while</B></PRE>

<h4><font color=\"#008000\">Description</font></h4>

<P>The expression of a while clause shall be a scalar boolean expression.
The while-clause corresponds to while-statements in programming languages,
and is formally defined as follows</P>

<OL>
  <LI>The expression of the while clause is evaluated.</LI>
  <LI>If the expression of the while-clause is false, the execution
      continues after the while-clause.</LI>
  <LI>If the expression of the while-clause is true, the entire body of
      the while clause is executed (except if a break statement or return
      statement is executed), and then execution proceeds at step 1.</LI>
</OL>

</html>"));
  end While;
end ModelicaReference;
package ModelicaServices "Models and functions used in the Modelica Standard Library requiring a tool specific implementation"
  package UsersGuide "Users Guide"
    annotation(__Dymola_DocumentationClass = true);
    class ReleaseNotes "Release notes"
      annotation(Documentation(info = "<html>
<h4>Version 1.0, 2009-06-21</h4>

<p>
First version of the ModelicaServices library.
</p>

</html>
"));
    end ReleaseNotes;
    class ModelicaLicense2 "Modelica License 2"
      annotation(Documentation(info = "<html>

<p>All files in this directory (ModelicaServices) and in all
subdirectories are licensed by the <b><u>Modelica Association</u></b> under the
<b><u>Modelica License 2</u></b>.</p>

<p style=\"margin-left: 40px;\"><b>Licensor:</b><br>
Modelica Association<br>
(Ideella F&ouml;reningar 822003-8858 in Link&ouml;ping) <br>
c/o PELAB, IDA, Link&ouml;pings Universitet <br>
S-58183 Link&ouml;ping <br>
Sweden<br>
email: Board@Modelica.org<br>
web&nbsp; : http://www.Modelica.org</p>
<p style=\"margin-left: 40px;\"><b>Copyright notices of the files:</b></p>
<div style=\"margin-left: 40px;\">Copyright &copy; 1998-2009,
DLR, Dynasim.<br>
</div>
<br>
</p>

<p> <a href=\"#1.%20The%20Modelica%20License%202%7Coutline\">The
Modelica License 2</a><br>
<a href=\"#2.%20Frequently%20Asked%20Questions%7Coutline\">Frequently
Asked Questions</a><br>
<br>
</p>

<hr>
<h4><a name=\"1. The Modelica License 2|outline\"></a>The Modelica License 2</h4>

<p>
<b>Preamble.</b> The goal of this license is that Modelica related
model libraries, software, images, documents, data files etc. can be
used freely in the original or a modified form, in open source and in
commercial environments (as long as the license conditions below are
fulfilled, in particular sections 2c) and 2d). The Original Work is
provided free of charge and the use is completely at your own risk.
Developers of free Modelica packages are encouraged to utilize this
license for their work.</p>

<p>
The Modelica License applies to any Original Work that contains the
following licensing notice adjacent to the copyright notice(s) for
this Original Work:</p>
<p><b>Licensed
by the Modelica Association under the Modelica License 2</b></p>

<p><b>1. Definitions.</b></p>
<ol>
 <li>&ldquo;License&rdquo; is this Modelica License.</li>

 <li>
 &ldquo;Original Work&rdquo; is any work of authorship, including
 software, images, documents, data files, that contains the above
 licensing notice or that is packed together with a licensing notice
 referencing it.</li>

 <li>
 &ldquo;Licensor&rdquo; is the provider of the Original Work who has
 placed this licensing notice adjacent to the copyright notice(s) for
 the Original Work. The Original Work is either directly provided by
 the owner of the Original Work, or by a licensee of the owner.</li>

 <li>
 &ldquo;Derivative Work&rdquo; is any modification of the Original
 Work which represents, as a whole, an original work of authorship.
 For the matter of clarity and as examples: </li>

 <ol>
  <li>
  Derivative Work shall not include work that remains separable from
  the Original Work, as well as merely extracting a part of the
  Original Work without modifying it.</li>

  <li>
  Derivative Work shall not include (a) fixing of errors and/or (b)
  adding vendor specific Modelica annotations and/or (c) using a
  subset of the classes of a Modelica package, and/or (d) using a
  different representation, e.g., a binary representation.</li>

  <li>
  Derivative Work shall include classes that are copied from the
  Original Work where declarations, equations or the documentation
  are modified.</li>

  <li>
  Derivative Work shall include executables to simulate the models
  that are generated by a Modelica translator based on the Original
  Work (of a Modelica package).</li>
 </ol>

 <li>
 &ldquo;Modified Work&rdquo; is any modification of the Original Work
 with the following exceptions: (a) fixing of errors and/or (b)
 adding vendor specific Modelica annotations and/or (c) using a
 subset of the classes of a Modelica package, and/or (d) using a
 different representation, e.g., a binary representation.</li>

 <li>
 &quot;Source Code&quot; means the preferred form of the Original
 Work for making modifications to it and all available documentation
 describing how to modify the Original Work.</li>

 <li>
 &ldquo;You&rdquo; means an individual or a legal entity exercising
 rights under, and complying with all of the terms of, this License.</li>

 <li>
 &ldquo;Modelica package&rdquo; means any Modelica library that is
 defined with the<br>&ldquo;<FONT FACE=\"Courier New, monospace\"><FONT SIZE=2 STYLE=\"font-size: 9pt\"><b>package</b></FONT></FONT><FONT FACE=\"Courier New, monospace\"><FONT SIZE=2 STYLE=\"font-size: 9pt\">
 &lt;Name&gt; ... </FONT></FONT><FONT FACE=\"Courier New, monospace\"><FONT SIZE=2 STYLE=\"font-size: 9pt\"><b>end</b></FONT></FONT><FONT FACE=\"Courier New, monospace\"><FONT SIZE=2 STYLE=\"font-size: 9pt\">
 &lt;Name&gt;;</FONT></FONT>&ldquo; Modelica language element.</li>
</ol>

<p>
<b>2. Grant of Copyright License.</b> Licensor grants You a
worldwide, royalty-free, non-exclusive, sublicensable license, for
the duration of the copyright, to do the following:</p>

<ol>
 <li><p>
 To reproduce the Original Work in copies, either alone or as part of
 a collection.</li></p>
 <li><p>
 To create Derivative Works according to Section 1d) of this License.</li></p>
 <li><p>
 To distribute or communicate to the public copies of the <u>Original
 Work</u> or a <u>Derivative Work</u> under <u>this License</u>. No
 fee, neither as a copyright-license fee, nor as a selling fee for
 the copy as such may be charged under this License. Furthermore, a
 verbatim copy of this License must be included in any copy of the
 Original Work or a Derivative Work under this License.<br>      For
 the matter of clarity, it is permitted A) to distribute or
 communicate such copies as part of a (possible commercial)
 collection where other parts are provided under different licenses
 and a license fee is charged for the other parts only and B) to
 charge for mere printing and shipping costs.</li></p>
 <li><p>
 To distribute or communicate to the public copies of a <u>Derivative
 Work</u>, alternatively to Section 2c), under <u>any other license</u>
 of your choice, especially also under a license for
 commercial/proprietary software, as long as You comply with Sections
 3, 4 and 8 below. <br>      For the matter of clarity, no
 restrictions regarding fees, either as to a copyright-license fee or
 as to a selling fee for the copy as such apply.</li></p>
 <li><p>
 To perform the Original Work publicly.</li></p>
 <li><p>
 To display the Original Work publicly.</li></p>
</ol>

<p>
<b>3. Acceptance.</b> Any use of the Original Work or a
Derivative Work, or any action according to either Section 2a) to 2f)
above constitutes Your acceptance of this License.</p>

<p>
<b>4. Designation of Derivative Works and of Modified Works.
</b>The identifying designation of Derivative Work and of Modified
Work must be different to the corresponding identifying designation
of the Original Work. This means especially that the (root-level)
name of a Modelica package under this license must be changed if the
package is modified (besides fixing of errors, adding vendor specific
Modelica annotations, using a subset of the classes of a Modelica
package, or using another representation, e.g. a binary
representation).</p>

<p>
<b>5. Grant of Patent License.</b>
Licensor grants You a worldwide, royalty-free, non-exclusive, sublicensable license,
under patent claims owned by the Licensor or licensed to the Licensor by
the owners of the Original Work that are embodied in the Original Work
as furnished by the Licensor, for the duration of the patents,
to make, use, sell, offer for sale, have made, and import the Original Work
and Derivative Works under the conditions as given in Section 2.
For the matter of clarity, the license regarding Derivative Works covers
patent claims to the extent as they are embodied in the Original Work only.</p>

<p>
<b>6. Provision of Source Code.</b> Licensor agrees to provide
You with a copy of the Source Code of the Original Work but reserves
the right to decide freely on the manner of how the Original Work is
provided.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;For the matter of clarity, Licensor might provide only a binary
representation of the Original Work. In that case, You may (a) either
reproduce the Source Code from the binary representation if this is
possible (e.g., by performing a copy of an encrypted Modelica
package, if encryption allows the copy operation) or (b) request the
Source Code from the Licensor who will provide it to You.</p>

<p>
<b>7. Exclusions from License Grant.</b> Neither the names of
Licensor, nor the names of any contributors to the Original Work, nor
any of their trademarks or service marks, may be used to endorse or
promote products derived from this Original Work without express
prior permission of the Licensor. Except as otherwise expressly
stated in this License and in particular in Sections 2 and 5, nothing
in this License grants any license to Licensor&rsquo;s trademarks,
copyrights, patents, trade secrets or any other intellectual
property, and no patent license is granted to make, use, sell, offer
for sale, have made, or import embodiments of any patent claims.<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;No license is granted to the trademarks of
Licensor even if such trademarks are included in the Original Work,
except as expressly stated in this License. Nothing in this License
shall be interpreted to prohibit Licensor from licensing under terms
different from this License any Original Work that Licensor otherwise
would have a right to license.</p>

<p>
<b>8. Attribution Rights.</b> You must retain in the Source
Code of the Original Work and of any Derivative Works that You
create, all author, copyright, patent, or trademark notices, as well
as any descriptive text identified therein as an &quot;Attribution
Notice&quot;. The same applies to the licensing notice of this
License in the Original Work. For the matter of clarity, &ldquo;author
notice&rdquo; means the notice that identifies the original
author(s). <br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;You must cause the Source Code for any Derivative
Works that You create to carry a prominent Attribution Notice
reasonably calculated to inform recipients that You have modified the
Original Work. <br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In case the Original Work or Derivative Work is not provided in
Source Code, the Attribution Notices shall be appropriately
displayed, e.g., in the documentation of the Derivative Work.</p>

<p><b>9. Disclaimer
of Warranty. <br></b><u><b>The Original Work is provided under this
License on an &quot;as is&quot; basis and without warranty, either
express or implied, including, without limitation, the warranties of
non-infringement, merchantability or fitness for a particular
purpose. The entire risk as to the quality of the Original Work is
with You.</b></u><b> </b>This disclaimer of warranty constitutes an
essential part of this License. No license to the Original Work is
granted by this License except under this disclaimer.</p>

<p>
<b>10. Limitation of Liability.</b> Under no circumstances and
under no legal theory, whether in tort (including negligence),
contract, or otherwise, shall the Licensor, the owner or a licensee
of the Original Work be liable to anyone for any direct, indirect,
general, special, incidental, or consequential damages of any
character arising as a result of this License or the use of the
Original Work including, without limitation, damages for loss of
goodwill, work stoppage, computer failure or malfunction, or any and
all other commercial damages or losses. This limitation of liability
shall not apply to the extent applicable law prohibits such
limitation.</p>

<p>
<b>11. Termination.</b> This License conditions your rights to
undertake the activities listed in Section 2 and 5, including your
right to create Derivative Works based upon the Original Work, and
doing so without observing these terms and conditions is prohibited
by copyright law and international treaty. Nothing in this License is
intended to affect copyright exceptions and limitations. This License
shall terminate immediately and You may no longer exercise any of the
rights granted to You by this License upon your failure to observe
the conditions of this license.</p>

<p>
<b>12. Termination for Patent Action.</b> This License shall
terminate automatically and You may no longer exercise any of the
rights granted to You by this License as of the date You commence an
action, including a cross-claim or counterclaim, against Licensor,
any owners of the Original Work or any licensee alleging that the
Original Work infringes a patent. This termination provision shall
not apply for an action alleging patent infringement through
combinations of the Original Work under combination with other
software or hardware.</p>

<p>
<b>13. Jurisdiction.</b> Any action or suit relating to this
License may be brought only in the courts of a jurisdiction wherein
the Licensor resides and under the laws of that jurisdiction
excluding its conflict-of-law provisions. The application of the
United Nations Convention on Contracts for the International Sale of
Goods is expressly excluded. Any use of the Original Work outside the
scope of this License or after its termination shall be subject to
the requirements and penalties of copyright or patent law in the
appropriate jurisdiction. This section shall survive the termination
of this License.</p>

<p>
<b>14. Attorneys&rsquo; Fees.</b> In any action to enforce the
terms of this License or seeking damages relating thereto, the
prevailing party shall be entitled to recover its costs and expenses,
including, without limitation, reasonable attorneys' fees and costs
incurred in connection with such action, including any appeal of such
action. This section shall survive the termination of this License.</p>

<p>
<b>15. Miscellaneous.</b>
</p>
<ol>
 <li>If any
 provision of this License is held to be unenforceable, such
 provision shall be reformed only to the extent necessary to make it
 enforceable.</li>

 <li>No verbal
 ancillary agreements have been made. Changes and additions to this
 License must appear in writing to be valid. This also applies to
 changing the clause pertaining to written form.</li>

 <li>You may use the
 Original Work in all ways not otherwise restricted or conditioned by
 this License or by law, and Licensor promises not to interfere with
 or be responsible for such uses by You.</li>
</ol>

<p>
<br>
</p>

<hr>

<h4><a name=\"2. Frequently Asked Questions|outline\"></a>
Frequently Asked Questions</h4>
<p>This
section contains questions/answer to users and/or distributors of
Modelica packages and/or documents under Modelica License 2. Note,
the answers to the questions below are not a legal interpretation of
the Modelica License 2. In case of a conflict, the language of the
license shall prevail.</p>

<p><br>
</p>

<p><FONT COLOR=\"#008000\"><FONT SIZE=3><b>Using
or Distributing a Modelica </b></FONT></FONT><FONT COLOR=\"#008000\"><FONT SIZE=3><u><b>Package</b></u></FONT></FONT><FONT COLOR=\"#008000\"><FONT SIZE=3><b>
under the Modelica License 2</b></FONT></FONT></p>

<p><b>What are the main
differences to the previous version of the Modelica License?</b></p>
<ol>
 <li><p>
 Modelica License 1 is unclear whether the licensed Modelica package
 can be distributed under a different license. Version 2 explicitly
 allows that &ldquo;Derivative Work&rdquo; can be distributed under
 any license of Your choice, see examples in Section 1d) as to what
 qualifies as Derivative Work (so, version 2 is clearer).</p>
 <li><p>
 If You modify a Modelica package under Modelica License 2 (besides
 fixing of errors, adding vendor specific Modelica annotations, using
 a subset of the classes of a Modelica package, or using another
 representation, e.g., a binary representation), you must rename the
 root-level name of the package for your distribution. In version 1
 you could keep the name (so, version 2 is more restrictive). The
 reason of this restriction is to reduce the risk that Modelica
 packages are available that have identical names, but different
 functionality.</p>
 <li><p>
 Modelica License 1 states that &ldquo;It is not allowed to charge a
 fee for the original version or a modified version of the software,
 besides a reasonable fee for distribution and support<SPAN LANG=\"en-GB\">&ldquo;.
 Version 2 has a </SPAN>similar intention for all Original Work under
 <u>Modelica License 2</u> (to remain free of charge and open source)
 but states this more clearly as &ldquo;No fee, neither as a
 copyright-license fee, nor as a selling fee for the copy as such may
 be charged&rdquo;. Contrary to version 1, Modelica License 2 has no
 restrictions on fees for Derivative Work that is provided under a
 different license (so, version 2 is clearer and has fewer
 restrictions).</p>
 <li><p>
 Modelica License 2 introduces several useful provisions for the
 licensee (articles 5, 6, 12), and for the licensor (articles 7, 12,
 13, 14) that have no counter part in version 1.</p>
 <li><p>
 Modelica License 2 can be applied to all type of work, including
 documents, images and data files, contrary to version 1 that was
 dedicated for software only (so, version 2 is more general).</p>
</ol>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) as part of my commercial
Modelica modeling and simulation environment?</b></p>
<p>Yes,
according to Section 2c). However, you are not allowed to charge a
fee for this part of your environment. Of course, you can charge for
your part of the environment.
</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different
license?</b></p>
<p>No.
The license of an unmodified Modelica package cannot be changed
according to Sections 2c) and 2d). This means that you cannot <u>sell</u>
copies of it, any distribution has to be free of charge.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different license
when I first encrypt the package?</b></p>
<p>No.
Merely encrypting a package does not qualify for Derivative Work and
therefore the encrypted package has to stay under Modelica License 2.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) under a different license
when I first add classes to the package?</b></p>
<p>No.
The package itself remains unmodified, i.e., it is Original Work, and
therefore the license for this part must remain under Modelica
License 2. The newly added classes can be, however, under a different
license.
</p>

<p><b>Can
I copy a class out of a Modelica package (under Modelica License 2)
and include it </b><u><b>unmodified</b></u><b> in a Modelica package
under a </b><u><b>commercial/proprietary license</b></u><b>?</b></p>
<p>No,
according to article 2c). However, you can include model, block,
function, package, record and connector classes in your Modelica
package under <u>Modelica License 2</u>. This means that your
Modelica package could be under a commercial/proprietary license, but
one or more classes of it are under Modelica License 2.<br>Note, a
&ldquo;type&rdquo; class (e.g., type Angle = Real(unit=&rdquo;rad&rdquo;))
can be copied and included unmodified under a commercial/proprietary
license (for details, see the next question).</p>

<p><b>Can
I copy a type class or </b><u><b>part</b></u><b> of a model, block,
function, record, connector class, out of a Modelica package (under
Modelica License 2) and include it modified or unmodified in a
Modelica package under a </b><u><b>commercial/proprietary</b></u><b>
license</b></p>
<p>Yes,
according to article 2d), since this will in the end usually qualify
as Derivative Work. The reasoning is the following: A type class or
part of another class (e.g., an equation, a declaration, part of a
class description) cannot be utilized &ldquo;by its own&rdquo;. In
order to make this &ldquo;usable&rdquo;, you have to add additional
code in order that the class can be utilized. This is therefore
usually Derivative Work and Derivative Work can be provided under a
different license. Note, this only holds, if the additional code
introduced is sufficient to qualify for Derivative Work. Merely, just
copying a class and changing, say, one character in the documentation
of this class would be no Derivative Work and therefore the copied
code would have to stay under Modelica License 2.</p>

<p><b>Can
I copy a class out of a Modelica package (under Modelica License 2)
and include it in </b><u><b>modified </b></u><b>form in a
</b><u><b>commercial/proprietary</b></u><b> Modelica package?</b></p>
<p>Yes.
If the modification can be seen as a &ldquo;Derivative Work&rdquo;,
you can place it under your commercial/proprietary license. If the
modification does not qualify as &ldquo;Derivative Work&rdquo; (e.g.,
bug fixes, vendor specific annotations), it must remain under
Modelica License 2. This means that your Modelica package could be
under a commercial/proprietary license, but one or more parts of it
are under Modelica License 2.</p>

<p><b>Can I distribute a
&ldquo;save total model&rdquo; under my commercial/proprietary
license, even if classes under Modelica License 2 are included?</b></p>
<p>Your
classes of the &ldquo;save total model&rdquo; can be distributed
under your commercial/proprietary license, but the classes under
Modelica License 2 must remain under Modelica License 2. This means
you can distribute a &ldquo;save total model&rdquo;, but some parts
might be under Modelica License 2.</p>

<p><b>Can I distribute a
Modelica package (under Modelica License 2) in encrypted form?</b></p>
<p>Yes.
Note, if the encryption does not allow &ldquo;copying&rdquo; of
classes (in to unencrypted Modelica source code), you have to send
the Modelica source code of this package to your customer, if he/she
wishes it, according to article&nbsp;6.</p>

<p><b>Can I distribute an
executable under my commercial/proprietary license, if the model from
which the executable is generated uses models from a Modelica package
under Modelica License 2?</b></p>
<p>Yes,
according to article 2d), since this is seen as Derivative Work. The
reasoning is the following: An executable allows the simulation of a
concrete model, whereas models from a Modelica package (without
pre-processing, translation, tool run-time library) are not able to
be simulated without tool support. By the processing of the tool and
by its run-time libraries, significant new functionality is added (a
model can be simulated whereas previously it could not be simulated)
and functionality available in the package is removed (e.g., to build
up a new model by dragging components of the package is no longer
possible with the executable).</p>

<p><b>Is my modification to
a Modelica package (under Modelica License 2) a Derivative Work?</b></p>
<p>It
is not possible to give a general answer to it. To be regarded as &quot;an
original work of authorship&quot;, a derivative work must be
different enough from the original or must contain a substantial
amount of new material. Making minor changes or additions of little
substance to a preexisting work will not qualify the work as a new
version for such purposes.
</p>

<p><br>
</p>
<p><FONT COLOR=\"#008000\"><FONT SIZE=3><b>Using
or Distributing a Modelica </b></FONT></FONT><FONT COLOR=\"#008000\"><FONT SIZE=3><u><b>Document</b></u></FONT></FONT><FONT COLOR=\"#008000\"><FONT SIZE=3><b>
under the Modelica License 2</b></FONT></FONT></p>

<p>This
section is devoted especially for the following applications:</p>
<ol>
 <li><p>
 A Modelica tool extracts information out of a Modelica package and
 presents the result in form of a &ldquo;manual&rdquo; for this
 package in, e.g., html, doc, or pdf format.</p>
 <li><p>
 The Modelica language specification is a document defining the
 Modelica language. It will be licensed under Modelica License 2.</p>
 <li><p>
 Someone writes a book about the Modelica language and/or Modelica
 packages and uses information which is available in the Modelica
 language specification and/or the corresponding Modelica package.</p>
</ol>

<p><b>Can I sell a manual
that was basically derived by extracting information automatically
from a Modelica package under Modelica License 2 (e.g., a &ldquo;reference
guide&rdquo; of the Modelica Standard Library):</b></p>
<p>Yes.
Extracting information from a Modelica package, and providing it in a
human readable, suitable format, like html, doc or pdf format, where
the content is significantly modified (e.g. tables with interface
information are constructed from the declarations of the public
variables) qualifies as Derivative Work and there are no restrictions
to charge a fee for Derivative Work under alternative 2d).</p>

<p><b>Can
I copy a text passage out of a Modelica document (under Modelica
License 2) and use it </b><u><b>unmodified</b></u><b> in my document
(e.g. the Modelica syntax description in the Modelica Specification)?</b></p>
<p>Yes.
In case you distribute your document, the copied parts are still
under Modelica License 2 and you are not allowed to charge a license
fee for this part. You can, of course, charge a fee for the rest of
your document.</p>

<p><b>Can
I copy a text passage out of a Modelica document (under Modelica
License 2) and use it in </b><u><b>modified</b></u><b> form in my
document?</b></p>
<p>Yes,
the creation of Derivative Works is allowed. In case the content is
significantly modified this qualifies as Derivative Work and there
are no restrictions to charge a fee for Derivative Work under
alternative 2d).</p>

<p><b>Can I sell a printed
version of a Modelica document (under Modelica License 2), e.g., the
Modelica Language Specification?</b></p>
<p>No,
if you are not the copyright-holder, since article 2c) does not allow
a selling fee for a (in this case physical) copy. However, mere
printing and shipping costs may be recovered.</p>
</html>"));
    end ModelicaLicense2;
    class Contact "Contact"
      annotation(Documentation(info = "<html>
<dl>
<dt><b>Main Author:</b>
<dd>
</dl>

<table border=0 cellspacing=0 cellpadding=2>
<tr>
<td>
<a href=\"http://www.robotic.dlr.de/Martin.Otter/\">Martin Otter</a><br>
    Deutsches Zentrum f&uuml;r Luft und Raumfahrt e.V. (DLR)<br>
    Institut f&uuml;r Robotik und Mechatronik<br>
    Abteilung f&uuml;r Systemdynamik und Regelungstechnik<br>
    Postfach 1116<br>
    D-82230 Wessling<br>
    Germany<br>
    email: <A HREF=\"mailto:Martin.Otter@dlr.de\">Martin.Otter@dlr.de</A></td>
</tr>
</table>


<p><b>Acknowledgements:</b></p>

<p>
The design of the Animation.Shape component is from Hilding Elmqvist, Dynasim AB.
</p>

</html>
"));
    end Contact;
  end UsersGuide;
  annotation(preferredView = "info", version = "1.0", versionDate = "2009-06-21", versionBuild = 2, revisionId = "$Id:: package.mo 3123 2009-11-08 18:29:01Z #$", Documentation(info = "<html>
<p>
This package contains a set of functions and models to be used in the
Modelica Standard Library that requires a tool specific implementation.
These are:
</p>

<ul>
<li> <a href=\"Modelica://ModelicaServices.Animation.Shape\">ModelicaServices.Animation.Shape</a>.
     provides a 3-dim. visualization of
     mechanical objects. It is used in
<a href=\"Modelica://Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape\">Modelica.Mechanics.MultiBody.Visualizers.Advanced.Shape</a>
     via inheritance.</li>
</ul>

<p>
<b>Licensed by DLR and Dynasim under the Modelica License 2</b><br>
Copyright &copy; 2009, DLR and Dynasim.
</p>

<p>
<i>This Modelica package is <u>free</u> software and
the use is completely at <u>your own risk</u>;
it can be redistributed and/or modified under the terms of the
Modelica license 2, see the license conditions (including the
disclaimer of warranty)
<a href=\"Modelica://ModelicaServices.UsersGuide.ModelicaLicense2\">here</a></u>
or at
<a href=\"http://www.Modelica.org/licenses/ModelicaLicense2\">
http://www.Modelica.org/licenses/ModelicaLicense2</a>.
</p>

</html>"), uses(Modelica(version = "3.1")));
  package Animation "Models and functions for 3-dim. animation"
    model Shape "Different visual shapes with variable size; all data have to be set as modifiers (see info layer)"
      extends Modelica.Utilities.Internal.PartialModelicaServices.Animation.PartialShape;
      import T = Modelica.Mechanics.MultiBody.Frames.TransformationMatrices;
      import SI = Modelica.SIunits;
      import Modelica.Mechanics.MultiBody.Frames;
      import Modelica.Mechanics.MultiBody.Types;
      function PackShape
        input Types.ShapeType shapeType;
        output Real pack;
      alg