/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import ptolemy.gui.QueryListener;

public class Query
extends JPanel {
    public static final int DEFAULT_ENTRY_HEIGHT = 10;
    public static final int DEFAULT_ENTRY_WIDTH = 30;
    protected Color _background = null;
    protected GridBagConstraints _constraints;
    protected GridBagLayout _grid;
    protected Vector _listeners;
    private int _columns = 1;
    private Map _entries = new HashMap();
    private JPanel _entryPanel = new JPanel();
    private JScrollPane _entryScrollPane;
    private int _height = 10;
    private Map _labels = new HashMap();
    private Insets _leftPadding = new Insets(0, 10, 0, 0);
    private JTextArea _messageArea = null;
    private JScrollPane _messageScrollPane;
    private boolean _messageScrollPaneAdded = false;
    private Insets _noPadding = new Insets(0, 0, 0, 0);
    private Map _previous = new HashMap();
    private int _widgetsHeight = 20;
    private int _width = 30;

    public Query() {
        this._grid = new GridBagLayout();
        this._constraints = new GridBagConstraints();
        this._constraints.fill = 2;
        this._constraints.weightx = 1.0;
        this._constraints.anchor = 18;
        this._entryPanel.setLayout(this._grid);
        this.setLayout(new BoxLayout(this, 1));
        this._entryPanel.setAlignmentX(0.0f);
        this._messageArea = new JTextArea("");
        this._messageArea.setFont(new Font("SansSerif", 0, 12));
        this._messageArea.setEditable(false);
        this._messageArea.setLineWrap(true);
        this._messageArea.setWrapStyleWord(true);
        this._messageArea.setBackground(null);
        this._messageArea.setAlignmentX(0.0f);
        this._messageScrollPane = new JScrollPane(this._messageArea);
        this._messageScrollPane.setVerticalScrollBarPolicy(20);
        this._messageScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._messageScrollPane.getViewport().setBackground(null);
        this._entryScrollPane = new JScrollPane(this._entryPanel);
        this._entryScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this._entryScrollPane.getViewport().setBackground(null);
        this._entryScrollPane.setBackground(null);
        this.add(this._entryScrollPane);
        this._entryPanel.setBackground(null);
    }

    public void addCheckBox(String name, String label, boolean defaultValue) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        JCheckBox checkbox = new JCheckBox();
        checkbox.setBackground(this._background);
        checkbox.setOpaque(false);
        checkbox.setSelected(defaultValue);
        this._addPair(name, lbl, checkbox, checkbox);
        checkbox.addItemListener(new QueryItemListener(name));
    }

    public void addChoice(String name, String label, String[] values, String defaultChoice) {
        this.addChoice(name, label, values, defaultChoice, false);
    }

    public void addChoice(String name, String label, String[] values, String defaultChoice, boolean editable) {
        this.addChoice(name, label, values, defaultChoice, editable, Color.white, Color.black);
    }

    public void addChoice(String name, String label, String[] values, String defaultChoice, boolean editable, final Color background, final Color foreground) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        JComboBox<String> combobox = new JComboBox<String>(values);
        combobox.setEditable(editable);
        combobox.setEditor(new BasicComboBoxEditor(){

            public Component getEditorComponent() {
                Component result = super.getEditorComponent();
                result.setBackground(background);
                result.setForeground(foreground);
                return result;
            }
        });
        combobox.setSelectedItem(defaultChoice);
        this._addPair(name, lbl, combobox, combobox);
        combobox.addItemListener(new QueryItemListener(name));
    }

    public void addColorChooser(String name, String label, String defaultColor) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        QueryColorChooser colorChooser = new QueryColorChooser(name, defaultColor);
        this._addPair(name, lbl, colorChooser, colorChooser);
    }

    public void addDisplay(String name, String label, String theValue) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        JTextArea displayField = new JTextArea(theValue, 1, 10);
        displayField.setEditable(false);
        displayField.setBackground(this._background);
        this._addPair(name, lbl, displayField, displayField);
    }

    public void addFileChooser(String name, String label, String defaultName, URI base, File startingDirectory) {
        this.addFileChooser(name, label, defaultName, base, startingDirectory, true, false, Color.white, Color.black);
    }

    public void addFileChooser(String name, String label, String defaultName, URI base, File startingDirectory, boolean allowFiles, boolean allowDirectories) {
        this.addFileChooser(name, label, defaultName, base, startingDirectory, allowFiles, allowDirectories, Color.white, Color.black);
    }

    public void addFileChooser(String name, String label, String defaultName, URI base, File startingDirectory, Color background, Color foreground) {
        this.addFileChooser(name, label, defaultName, base, startingDirectory, true, false, background, foreground);
    }

    public void addFileChooser(String name, String label, String defaultName, URI base, File startingDirectory, boolean allowFiles, boolean allowDirectories, Color background, Color foreground) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        QueryFileChooser fileChooser = new QueryFileChooser(name, defaultName, base, startingDirectory, allowFiles, allowDirectories, background, foreground);
        this._addPair(name, lbl, fileChooser, fileChooser);
    }

    public void addLine(String name, String label, String defaultValue) {
        this.addLine(name, label, defaultValue, Color.white, Color.black);
    }

    public void addLine(String name, String label, String defaultValue, Color background, Color foreground) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        JTextField entryBox = new JTextField(defaultValue, this._width);
        entryBox.setBackground(background);
        entryBox.setForeground(foreground);
        this._addPair(name, lbl, entryBox, entryBox);
        entryBox.addActionListener(new QueryActionListener(name));
        entryBox.addFocusListener(new QueryFocusListener(name));
    }

    public void addPassword(String name, String label, String defaultValue) {
        this.addPassword(name, label, defaultValue, Color.white, Color.black);
    }

    public void addPassword(String name, String label, String defaultValue, Color background, Color foreground) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        JPasswordField entryBox = new JPasswordField(defaultValue, this._width);
        entryBox.setBackground(background);
        entryBox.setForeground(foreground);
        this._addPair(name, lbl, entryBox, entryBox);
        entryBox.addActionListener(new QueryActionListener(name));
        entryBox.addFocusListener(new QueryFocusListener(name));
    }

    public void addQueryListener(QueryListener listener) {
        if (this._listeners == null) {
            this._listeners = new Vector();
        }
        if (this._listeners.contains(listener)) {
            return;
        }
        this._listeners.add(listener);
    }

    public void addRadioButtons(String name, String label, String[] values, String defaultValue) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(0);
        JPanel buttonPanel = new JPanel(flow);
        ButtonGroup group = new ButtonGroup();
        QueryActionListener listener = new QueryActionListener(name);
        JRadioButton[] buttons = new JRadioButton[values.length];
        int i = 0;
        while (i < values.length) {
            JRadioButton checkbox;
            buttons[i] = checkbox = new JRadioButton(values[i]);
            checkbox.setBackground(this._background);
            checkbox.setOpaque(false);
            if (values[i].equals(defaultValue)) {
                checkbox.setSelected(true);
            }
            group.add(checkbox);
            buttonPanel.add(checkbox);
            checkbox.addActionListener(listener);
            ++i;
        }
        this._addPair(name, lbl, buttonPanel, buttons);
    }

    public void addSelectButtons(String name, String label, String[] values, Set initiallySelected) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        FlowLayout flow = new FlowLayout();
        flow.setAlignment(0);
        JPanel buttonPanel = new JPanel(flow);
        QueryActionListener listener = new QueryActionListener(name);
        if (initiallySelected == null) {
            initiallySelected = new HashSet();
        }
        JRadioButton[] buttons = new JRadioButton[values.length];
        int i = 0;
        while (i < values.length) {
            JRadioButton checkbox;
            buttons[i] = checkbox = new JRadioButton(values[i]);
            checkbox.setBackground(this._background);
            checkbox.setOpaque(false);
            if (initiallySelected.contains(values[i])) {
                checkbox.setSelected(true);
            }
            buttonPanel.add(checkbox);
            checkbox.addActionListener(listener);
            ++i;
        }
        this._addPair(name, lbl, buttonPanel, buttons);
    }

    public void addSlider(String name, String label, int defaultValue, int minimum, int maximum) throws IllegalArgumentException {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        if (minimum > maximum) {
            int temp = minimum;
            minimum = maximum;
            maximum = temp;
        }
        if (defaultValue > maximum || defaultValue < minimum) {
            throw new IllegalArgumentException("Desired default value \"" + defaultValue + "\" does not fall " + "between the minimum and maximum.");
        }
        JSlider slider = new JSlider(minimum, maximum, defaultValue);
        this._addPair(name, lbl, slider, slider);
        slider.addChangeListener(new SliderListener(name));
    }

    public void addTextArea(String name, String label, String theValue) {
        this.addTextArea(name, label, theValue, Color.white, Color.black, this._height, this._width);
    }

    public void addTextArea(String name, String label, String theValue, Color background, Color foreground) {
        this.addTextArea(name, label, theValue, background, foreground, this._height, this._width);
    }

    public void addTextArea(String name, String label, String theValue, Color background, Color foreground, int height, int width) {
        JLabel lbl = new JLabel(String.valueOf(label) + ": ");
        lbl.setBackground(this._background);
        JTextArea textArea = new JTextArea(theValue, height, width);
        textArea.setEditable(true);
        textArea.setBackground(background);
        textArea.setForeground(foreground);
        QueryScrollPane textPane = new QueryScrollPane(textArea);
        this._addPair(name, lbl, textPane, textPane);
        textArea.addFocusListener(new QueryFocusListener(name));
    }

    public boolean booleanValue(String name) throws NoSuchElementException, IllegalArgumentException {
        return this.getBooleanValue(name);
    }

    public double doubleValue(String name) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        return this.getDoubleValue(name);
    }

    public boolean getBooleanValue(String name) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + "\" in the query box.");
        }
        if (result instanceof JToggleButton) {
            return ((JToggleButton)result).isSelected();
        }
        throw new IllegalArgumentException("Item named \"" + name + "\" is not a radio button, and hence does not have " + "a boolean value.");
    }

    public char[] getCharArrayValue(String name) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + "\" in the query box.");
        }
        if (result instanceof JPasswordField) {
            return ((JPasswordField)result).getPassword();
        }
        return this.getStringValue(name).toCharArray();
    }

    public double getDoubleValue(String name) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JPasswordField) {
            throw new IllegalArgumentException("For security reasons, calling getDoubleValue() on a password field is not permitted.  Instead, call getCharArrayValue()");
        }
        if (result instanceof JTextField) {
            return new Double(((JTextField)result).getText());
        }
        throw new IllegalArgumentException("Item named \"" + name + "\" is not a text line, and hence cannot be converted " + "to a double value.");
    }

    public int getIntValue(String name) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JPasswordField) {
            throw new IllegalArgumentException("For security reasons, calling getIntValue() on a password field is not permitted.  Instead, call getCharArrayValue()");
        }
        if (result instanceof JTextField) {
            return new Integer(((JTextField)result).getText());
        }
        if (result instanceof JSlider) {
            return ((JSlider)result).getValue();
        }
        if (result instanceof JComboBox) {
            return ((JComboBox)result).getSelectedIndex();
        }
        if (result instanceof JToggleButton[]) {
            JToggleButton[] buttons = (JToggleButton[])result;
            int i = 0;
            while (i < buttons.length) {
                if (buttons[i].isSelected()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        throw new IllegalArgumentException("Item named \"" + name + "\" is not a text line or slider, and hence " + "cannot be converted to " + "an integer value.");
    }

    public Dimension getMaximumSize() {
        Dimension preferred = this.getPreferredSize();
        preferred.width = Short.MAX_VALUE;
        return preferred;
    }

    public String getStringValue(String name) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JTextField) {
            return ((JTextField)result).getText();
        }
        if (result instanceof QueryColorChooser) {
            return ((QueryColorChooser)result).getSelectedColor();
        }
        if (result instanceof QueryFileChooser) {
            return ((QueryFileChooser)result).getSelectedFileName();
        }
        if (result instanceof JTextArea) {
            return ((JTextArea)result).getText();
        }
        if (result instanceof JToggleButton) {
            JToggleButton toggleButton = (JToggleButton)result;
            if (toggleButton.isSelected()) {
                return "true";
            }
            return "false";
        }
        if (result instanceof JSlider) {
            return "" + ((JSlider)result).getValue();
        }
        if (result instanceof JComboBox) {
            return (String)((JComboBox)result).getSelectedItem();
        }
        if (result instanceof JToggleButton[]) {
            JToggleButton[] buttons = (JToggleButton[])result;
            String toReturn = null;
            int i = 0;
            while (i < buttons.length) {
                if (buttons[i].isSelected()) {
                    toReturn = toReturn == null ? buttons[i].getText() : String.valueOf(toReturn) + ", " + buttons[i].getText();
                }
                ++i;
            }
            if (toReturn == null) {
                toReturn = "";
            }
            return toReturn;
        }
        if (result instanceof QueryScrollPane) {
            return ((QueryScrollPane)result).getText();
        }
        throw new IllegalArgumentException("Query class cannot generate a string representation for entries of type " + result.getClass());
    }

    public int getTextHeight() {
        return this._height;
    }

    public int getTextWidth() {
        return this._width;
    }

    public int intValue(String name) throws IllegalArgumentException, NoSuchElementException, NumberFormatException {
        return this.getIntValue(name);
    }

    public void notifyListeners() {
        Iterator names = this._entries.keySet().iterator();
        while (names.hasNext()) {
            String name = (String)names.next();
            this._notifyListeners(name);
        }
    }

    public void removeQueryListener(QueryListener listener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public void set(String name, String value) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JTextField) {
            ((JTextField)result).setText(value);
        } else if (result instanceof JTextArea) {
            ((JTextArea)result).setText(value);
        } else if (result instanceof QueryScrollPane) {
            ((QueryScrollPane)result).setText(value);
        } else if (result instanceof JToggleButton) {
            Boolean flag = Boolean.valueOf(value);
            this.setBoolean(name, flag);
        } else if (result instanceof JSlider) {
            Integer parsed = new Integer(value);
            ((JSlider)result).setValue(parsed);
        } else if (result instanceof JComboBox) {
            ((JComboBox)result).setSelectedItem(value);
        } else if (result instanceof JToggleButton[]) {
            HashSet<String> selectedValues = new HashSet<String>();
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            while (tokenizer.hasMoreTokens()) {
                selectedValues.add(tokenizer.nextToken().trim());
            }
            JToggleButton[] buttons = (JToggleButton[])result;
            int i = 0;
            while (i < buttons.length) {
                if (selectedValues.contains(buttons[i].getText())) {
                    buttons[i].setSelected(true);
                } else {
                    buttons[i].setSelected(false);
                }
                ++i;
            }
        } else if (result instanceof QueryColorChooser) {
            ((QueryColorChooser)result).setColor(value);
        } else if (result instanceof QueryFileChooser) {
            ((QueryFileChooser)result).setFileName(value);
        } else {
            throw new IllegalArgumentException("Query class cannot set a string representation for entries of type " + result.getClass());
        }
        this._previous.put(name, value);
    }

    public void setAndNotify(String name, String value) throws NoSuchElementException, IllegalArgumentException {
        this.set(name, value);
        this._notifyListeners(name);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this._background = color;
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (!(components[i] instanceof JTextField)) {
                components[i].setBackground(this._background);
            }
            ++i;
        }
    }

    public void setBoolean(String name, boolean value) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + "\" in the query box.");
        }
        if (!(result instanceof JToggleButton)) {
            throw new IllegalArgumentException("Item named \"" + name + "\" is not a radio button, and hence does not have " + "a boolean value.");
        }
        ((JToggleButton)result).setSelected(value);
        this._notifyListeners(name);
    }

    public void setColumns(int columns) {
        if (columns <= 0) {
            throw new IllegalArgumentException("Query.setColumns() requires a strictly positive argument.");
        }
        this._columns = columns;
    }

    public void setDisplay(String name, String value) throws NoSuchElementException, IllegalArgumentException {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (!(result instanceof JTextArea)) {
            throw new IllegalArgumentException("Item named \"" + name + "\" is not a display, and hence cannot be set using " + "setDisplay().");
        }
        JTextArea label = (JTextArea)result;
        label.setText(value);
        this._notifyListeners(name);
    }

    public void setEnabled(String name, boolean value) {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (result instanceof JComponent) {
            ((JComponent)result).setEnabled(value);
        } else if (result instanceof JToggleButton[]) {
            JToggleButton[] buttons = (JToggleButton[])result;
            int i = 0;
            while (i < buttons.length) {
                buttons[i].setEnabled(value);
                ++i;
            }
        }
    }

    public void setLine(String name, String value) {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (!(result instanceof JTextField)) {
            throw new IllegalArgumentException("Item named \"" + name + "\" is not a line, and hence cannot be set using " + "setLine().");
        }
        JTextField line = (JTextField)result;
        line.setText(value);
        this._notifyListeners(name);
    }

    public void setMessage(String message) {
        if (!this._messageScrollPaneAdded) {
            this._messageScrollPaneAdded = true;
            this.add((Component)this._messageScrollPane, 1);
            this.add(Box.createRigidArea(new Dimension(0, 10)), 2);
        }
        this._messageArea.setText(message);
        int lineCount = this._messageArea.getLineCount() + 1;
        if (lineCount > 30) {
            lineCount = 30;
        }
        this._messageArea.setRows(lineCount);
        this._messageArea.setColumns(this._width);
        this.validate();
    }

    public void setSlider(String name, int value) {
        Object result = this._entries.get(name);
        if (result == null) {
            throw new NoSuchElementException("No item named \"" + name + " \" in the query box.");
        }
        if (!(result instanceof JSlider)) {
            throw new IllegalArgumentException("Item named \"" + name + "\" is not a slider, and hence cannot be set using " + "setSlider().");
        }
        JSlider theSlider = (JSlider)result;
        theSlider.setValue(value);
        this._notifyListeners(name);
    }

    public void setTextHeight(int characters) {
        this._height = characters;
    }

    public void setTextWidth(int characters) {
        this._width = characters;
    }

    public void setToolTip(String name, String tip) {
        JLabel label = (JLabel)this._labels.get(name);
        if (label != null) {
            label.setToolTipText(tip);
        }
    }

    public String stringValue(String name) throws NoSuchElementException, IllegalArgumentException {
        return this.getStringValue(name);
    }

    protected void _addPair(String name, JLabel label, Component widget, Object entry) {
        this._constraints.gridwidth = 1;
        this._constraints.insets = this._leftPadding;
        this._grid.setConstraints(label, this._constraints);
        this._entryPanel.add(label);
        this._constraints.insets = this._noPadding;
        this._constraints.gridwidth = this._columns > 1 && (this._entries.size() + 1) % this._columns != 0 ? 1 : 0;
        this._grid.setConstraints(widget, this._constraints);
        this._entryPanel.add(widget);
        this._entries.put(name, entry);
        this._labels.put(name, label);
        this._previous.put(name, this.getStringValue(name));
        Dimension preferredSize = this._entryPanel.getPreferredSize();
        preferredSize.width += 25;
        this._widgetsHeight += widget.getPreferredSize().height;
        preferredSize.height = this._widgetsHeight;
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (preferredSize.height > tk.getScreenSize().height) {
            preferredSize.height = (int)((double)tk.getScreenSize().height * 0.75);
            this._entryScrollPane.setPreferredSize(preferredSize);
        }
        this._entryScrollPane.setPreferredSize(preferredSize);
        this._entryPanel.revalidate();
    }

    void _notifyListeners(String name) {
        if (this._listeners != null) {
            String previous = (String)this._previous.get(name);
            String newValue = this.getStringValue(name);
            if (newValue.equals(previous)) {
                return;
            }
            this._previous.put(name, newValue);
            Enumeration listeners = this._listeners.elements();
            while (listeners.hasMoreElements()) {
                QueryListener queryListener = (QueryListener)listeners.nextElement();
                queryListener.changed(name);
            }
        }
    }

    class QueryActionListener
    implements ActionListener {
        private String _name;

        public QueryActionListener(String name) {
            this._name = name;
        }

        public void actionPerformed(ActionEvent e) {
            Query.this._notifyListeners(this._name);
        }
    }

    class QueryColorChooser
    extends Box
    implements ActionListener {
        private JTextField _entryBox;
        private String _name;
        private String _defaultColor;

        public QueryColorChooser(String name, String defaultColor) {
            super(0);
            this._defaultColor = defaultColor;
            this._entryBox = new JTextField(defaultColor, Query.this._width);
            JButton button = new JButton("Choose");
            button.addActionListener(this);
            this.add(this._entryBox);
            this.add(button);
            this._entryBox.addActionListener(new QueryActionListener(name));
            this._entryBox.addFocusListener(new QueryFocusListener(name));
            this._name = name;
        }

        public void actionPerformed(ActionEvent e) {
            Color newColor;
            String spec = this.getSelectedColor().trim();
            String[] specArray = spec.split("[{},]");
            float red = 0.0f;
            float green = 0.0f;
            float blue = 0.0f;
            float alpha = 1.0f;
            try {
                int i = 0;
                while (specArray[i].trim().equals("")) {
                    ++i;
                }
                if (specArray.length > i) {
                    red = Float.parseFloat(specArray[i]);
                }
                ++i;
                while (specArray[i].trim().equals("")) {
                    ++i;
                }
                if (specArray.length > i) {
                    green = Float.parseFloat(specArray[i]);
                }
                ++i;
                while (specArray[i].trim().equals("")) {
                    ++i;
                }
                if (specArray.length > i) {
                    blue = Float.parseFloat(specArray[i]);
                }
                ++i;
                while (specArray[i].trim().equals("")) {
                    ++i;
                }
                if (specArray.length > i) {
                    alpha = Float.parseFloat(specArray[i]);
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            if ((newColor = JColorChooser.showDialog(Query.this, "Choose Color", new Color(red, green, blue, alpha))) != null) {
                float[] components = newColor.getRGBComponents(null);
                StringBuffer string = new StringBuffer("{");
                int j = 0;
                while (j < components.length) {
                    string.append(components[j]);
                    if (j < components.length - 1) {
                        string.append(",");
                    } else {
                        string.append("}");
                    }
                    ++j;
                }
                this._entryBox.setText(string.toString());
                Query.this._notifyListeners(this._name);
            }
        }

        public String getSelectedColor() {
            return this._entryBox.getText();
        }

        public void setColor(String name) {
            this._entryBox.setText(name);
        }
    }

    class QueryFileChooser
    extends Box
    implements ActionListener {
        private URI _base;
        private JTextField _entryBox;
        private String _name;
        private File _startingDirectory;
        private boolean _allowFiles;
        private boolean _allowDirectories;

        public QueryFileChooser(String name, String defaultName, URI base, File startingDirectory, boolean allowFiles, boolean allowDirectories) {
            this(name, defaultName, base, startingDirectory, allowFiles, allowDirectories, Color.white, Color.black);
        }

        public QueryFileChooser(String name, String defaultName, URI base, File startingDirectory, boolean allowFiles, boolean allowDirectories, Color background, Color foreground) {
            super(0);
            this._base = base;
            this._startingDirectory = startingDirectory;
            if (!allowFiles && !allowDirectories) {
                throw new IllegalArgumentException("QueryFileChooser: nothing to be chosen.");
            }
            this._allowFiles = allowFiles;
            this._allowDirectories = allowDirectories;
            this._entryBox = new JTextField(defaultName, Query.this._width);
            this._entryBox.setBackground(background);
            this._entryBox.setForeground(foreground);
            JButton button = new JButton("Browse");
            button.addActionListener(this);
            this.add(this._entryBox);
            this.add(button);
            this._entryBox.addActionListener(new QueryActionListener(name));
            this._entryBox.addFocusListener(new QueryFocusListener(name));
            this._name = name;
        }

        public void actionPerformed(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser(this._startingDirectory);
            fileChooser.setApproveButtonText("Select");
            fileChooser.setApproveButtonMnemonic('S');
            if (this._allowFiles && this._allowDirectories) {
                fileChooser.setFileSelectionMode(2);
            } else if (this._allowFiles && !this._allowDirectories) {
                fileChooser.setFileSelectionMode(0);
            } else if (!this._allowFiles && this._allowDirectories) {
                fileChooser.setFileSelectionMode(1);
            } else {
                throw new RuntimeException("QueryFileChooser: nothing to be chosen.");
            }
            int returnValue = fileChooser.showOpenDialog(Query.this);
            if (returnValue == 0) {
                if (this._base == null) {
                    try {
                        this._entryBox.setText(fileChooser.getSelectedFile().getCanonicalPath());
                    }
                    catch (IOException ex) {
                        this._entryBox.setText(fileChooser.getSelectedFile().getName());
                    }
                } else {
                    File selectedFile = fileChooser.getSelectedFile();
                    try {
                        selectedFile = selectedFile.getCanonicalFile();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    URI relativeURI = this._base.relativize(selectedFile.toURI());
                    this._entryBox.setText(relativeURI.toString());
                }
                Query.this._notifyListeners(this._name);
            }
        }

        public String getSelectedFileName() {
            return this._entryBox.getText();
        }

        public void setFileName(String name) {
            this._entryBox.setText(name);
        }
    }

    class QueryFocusListener
    implements FocusListener {
        private String _name;

        public QueryFocusListener(String name) {
            this._name = name;
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Query.this._notifyListeners(this._name);
        }
    }

    class QueryItemListener
    implements ItemListener {
        private String _name;

        public QueryItemListener(String name) {
            this._name = name;
        }

        public void itemStateChanged(ItemEvent e) {
            Query.this._notifyListeners(this._name);
        }
    }

    class QueryScrollPane
    extends JScrollPane {
        public JTextArea textArea;

        QueryScrollPane(JTextArea c) {
            super(c);
            this.textArea = c;
        }

        public String getText() {
            String retval = this.textArea.getText();
            return retval;
        }

        public void setText(String s) {
            this.textArea.setText(s);
        }
    }

    class SliderListener
    implements ChangeListener {
        private String _name;

        public SliderListener(String name) {
            this._name = name;
        }

        public void stateChanged(ChangeEvent event) {
            Query.this._notifyListeners(this._name);
        }
    }
}

