#include "Modelica_Math_Matrices_LAPACK_dgetri.h"
#include <algorithm>
#define MODELICA_ASSERT(info,msg) { printInfo(stderr,info); fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {


Modelica_Math_Matrices_LAPACK_dgetri_rettype _Modelica_Math_Matrices_LAPACK_dgetri(real_array _LU, integer_array _pivots)
{
  Modelica_Math_Matrices_LAPACK_dgetri_rettype out;
  state tmp1;
  int tmp2;
  int tmp3;
  real_array _inv_ext;
  integer_array _pivots_ext;
  modelica_integer _lwork;
  modelica_integer _lwork_ext;
  modelica_integer tmp4;
  modelica_integer tmp5;
  real_array _work;
  real_array _work_ext;
  modelica_integer _info;
  modelica_integer _info_ext;
  modelica_integer tmp6;
  modelica_integer tmp7;
  tmp1 = get_memory_state();
  tmp2 = size_of_dimension_real_array(_LU, (modelica_integer) 1);
  tmp3 = size_of_dimension_real_array(_LU, (modelica_integer) 1);
  tmp4 = size_of_dimension_real_array(_LU, (modelica_integer) 1);
  tmp5 = size_of_dimension_real_array(_LU, (modelica_integer) 1);
  _lwork = (modelica_integer_min((modelica_integer)(modelica_integer) 10,(modelica_integer)tmp4) * tmp5);
  alloc_real_array(&_work, 1, (modelica_integer)_lwork);
  convert_alloc_real_array_to_f77(&_work, &_work_ext);
  tmp6 = size_of_dimension_real_array(_LU, (modelica_integer) 1);
  tmp7 = size_of_dimension_real_array(_LU, (modelica_integer) 2);
  alloc_real_array(&out.targ1, 2, tmp6, tmp7);
  copy_real_array_data(&_LU, &out.targ1);
  _inv_ext = _LU;
  convert_alloc_real_array_to_f77(&out.targ1, &_inv_ext);
  convert_alloc_integer_array_to_f77(&_pivots, &_pivots_ext);
  dgetri_(&tmp2, data_of_real_array(&(_inv_ext)), &tmp3, data_of_integer_array(&(_pivots_ext)), data_of_real_array(&(_work_ext)), (int*) &_lwork, (int*) &_info);
  convert_alloc_real_array_from_f77(&_inv_ext, &out.targ1);
  restore_memory_state(tmp1);
  return out;
}

int in_Modelica_Math_Matrices_LAPACK_dgetri(type_description * inArgs, type_description * outVar)
{
  real_array _LU;
  integer_array _pivots;
  Modelica_Math_Matrices_LAPACK_dgetri_rettype out;
  if (read_real_array(&inArgs, &_LU)) return 1;
  if (read_integer_array(&inArgs, &_pivots)) return 1;
  MMC_TRY_TOP()
  out = _Modelica_Math_Matrices_LAPACK_dgetri(_LU, _pivots);
  MMC_CATCH_TOP(return 1)
  write_real_array(outVar, &out.targ1);
  return 0;
}

}

