
package Common "Common packages and data for the ideal gas models"

      record DataRecord "Coefficient data record for properties of ideal gases based on NASA source"
        String name "Name of ideal gas";
        Real MM "Molar mass";
        Real Hf "Enthalpy of formation at 298.15K";
        Real H0 "H0(298.15K) - H0(0K)";
        Real Tlimit "Temperature limit between low and high data sets";
        Real alow[7] "Low temperature coefficients a";
        Real blow[2] "Low temperature constants b";
        Real ahigh[7] "High temperature coefficients a";
        Real bhigh[2] "High temperature constants b";
        Real R "Gas constant";
      end DataRecord;

    partial package PartialMedium "Partial medium properties (base package of all media packages)"

      constant String mediumName = "unusablePartialMedium" "Name of the medium";
      constant String substanceNames[:]={mediumName};

      replaceable record FluidConstants "critical, triple, molecular and other standard data of fluid"
        String iupacName "complete IUPAC name (or common name, if non-existent)";
        String casRegistryNumber "chemical abstracts sequencing number (if it exists)";
        String chemicalFormula "Chemical formula, (brutto, nomenclature according to Hill";
        String structureFormula "Chemical structure formula";
        Real molarMass "molar mass";
      end FluidConstants;
    end PartialMedium;

      partial package SingleGasNasa
        "Medium model of an ideal gas based on NASA source"
        extends PartialMedium(mediumName=data.name, substanceNames={data.name});

        redeclare record extends FluidConstants "Extended fluid constants"
          Real criticalTemperature "critical temperature";
          Real criticalPressure "critical pressure";
          Real criticalMolarVolume "critical molar Volume";
          Real acentricFactor "Pitzer acentric factor";
          Real triplePointTemperature "triple point temperature";
          Real triplePointPressure "triple point pressure";
          Real meltingPoint "melting point at 101325 Pa";
          Real normalBoilingPoint "normal boiling point (at 101325 Pa)";
          Real dipoleMoment "dipole moment of molecule in Debye (1 debye = 3.33564e10-30 C.m)";
          Boolean hasIdealGasHeatCapacity=false "true if ideal gas heat capacity is available";
          Boolean hasCriticalData=false "true if critical data are known";
          Boolean hasDipoleMoment=false "true if a dipole moment known";
          Boolean hasFundamentalEquation=false "true if a fundamental equation";
          Boolean hasLiquidHeatCapacity=false "true if liquid heat capacity is available";
          Boolean hasSolidHeatCapacity=false "true if solid heat capacity is available";
          Boolean hasAccurateViscosityData=false "true if accurate data for a viscosity function is available";
          Boolean hasAccurateConductivityData=false "true if accurate data for thermal conductivity is available";
          Boolean hasVapourPressureCurve=false "true if vapour pressure data, e.g. Antoine coefficents are known";
          Boolean hasAcentricFactor=false "true if Pitzer accentric factor is known";
          Real HCRIT0=0.0 "Critical specific enthalpy of the fundamental equation";
          Real SCRIT0=0.0  "Critical specific entropy of the fundamental equation";
          Real deltah=0.0 "Difference between specific enthalpy model (h_m) and f.eq. (h_f) (h_m - h_f)";
          Real deltas=0.0 "Difference between specific enthalpy model (s_m) and f.eq. (s_f) (s_m - s_f)";
        end FluidConstants;

        constant Common.DataRecord data;

      end SingleGasNasa;

        package FluidData "Critical data, dipole moments and related data"
          import Common.PartialMedium;
          import Common.SingleGasesData;

          constant SingleGasNasa.FluidConstants H2O(
                               chemicalFormula =        "H2O",
                               iupacName =              "unknown",
                               structureFormula =       "unknown",
                               casRegistryNumber =      "7732-18-5",
                               meltingPoint =           273.15,
                               normalBoilingPoint =     373.15,
                               criticalTemperature =    647.14,
                               criticalPressure =       220.64e5,
                               criticalMolarVolume =     55.95e-6,
                               acentricFactor =           0.344,
                               dipoleMoment =             1.8,
                               molarMass =              SingleGasesData.H2O.MM,
                               hasDipoleMoment =       true,
                               hasIdealGasHeatCapacity=true,
                               hasCriticalData =       true,
                               hasAcentricFactor =     true);
        end FluidData;

        package SingleGasesData "Ideal gas data based on the NASA Glenn coefficients"

          constant Common.DataRecord Air(
            name="Air",
            MM=0.0289651159,
            Hf=-4333.833858403446,
            H0=298609.6803431054,
            Tlimit=1000,
            alow={10099.5016,-196.827561,5.00915511,-0.00576101373,1.06685993e-005,-7.94029797e-009,
                2.18523191e-012},
            blow={-176.796731,-3.921504225},
            ahigh={241521.443,-1257.8746,5.14455867,-0.000213854179,7.06522784e-008,-1.07148349e-011,
                6.57780015e-016},
            bhigh={6462.26319,-8.147411905},
            R=287.0512249529787);

          constant Common.DataRecord H2O(
            name="H2O",
            MM=0.01801528,
            Hf=-13423382.81725291,
            H0=549760.6476280135,
            Tlimit=1000,
            alow={-39479.6083,575.573102,0.931782653,0.00722271286,-7.34255737e-006,
                4.95504349e-009,-1.336933246e-012},
            blow={-33039.7431,17.24205775},
            ahigh={1034972.096,-2412.698562,4.64611078,0.002291998307,-6.836830479999999e-007,
                9.426468930000001e-011,-4.82238053e-015},
            bhigh={-13842.86509,-7.97814851},
            R=461.5233290850878);

        end SingleGasesData;

end Common;

model Model 
  Common.SingleGasNasa.FluidConstants x = Common.FluidData.H2O;
end Model;

