#include "myTan.h"
#include <algorithm>
#define MODELICA_ASSERT(cond,msg) { if (!(cond)) fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {
myTan_rettype _myTan(modelica_real _x)
{
  myTan_rettype tmp1;
  state tmp2;
  modelica_real _result;
  sin_rettype tmp3;
  cos_rettype tmp4;
  tmp2 = get_memory_state();


  tmp3 = sin(_x);
  tmp4 = cos(_x);
  _result = (tmp3 / tmp4);
  
  _return:
  tmp1.targ1 = _result;
  restore_memory_state(tmp2);
  return tmp1;
}

int in_myTan(type_description * inArgs, type_description * outVar)
{
  modelica_real _x;
  myTan_rettype out;
  if (read_modelica_real(&inArgs, &_x)) return 1;
  out = _myTan(_x);
  write_modelica_real(outVar, &out.targ1);
  return 0;
}

}

