#include "ZeroRange_testRangeLoop.h"
#include <algorithm>
#define MODELICA_ASSERT(info,msg) { printInfo(stderr,info); fprintf(stderr,"Modelica Assert: %s!\n", msg); }
#define MODELICA_TERMINATE(msg) { fprintf(stderr,"Modelica Terminate: %s!\n", msg); fflush(stderr); }

extern "C" {


ZeroRange_testRangeLoop_rettype _ZeroRange_testRangeLoop(modelica_integer _start, modelica_integer _step, modelica_integer _stop)
{

  /* GC: save roots mark when you enter the function */
  /* GC: adding inputs as roots! */
  
  /* GC: do garbage collection */
  
  /* arguments */
  /* locals */
  ZeroRange_testRangeLoop_rettype tmp1;
  state tmp2;
  modelica_integer _o;
  state tmp3;
  modelica_integer tmp4;
  modelica_integer tmp5;
  modelica_integer tmp6;
  /* out inits */

  tmp2 = get_memory_state();
  
  /* var inits */
  /* body */
  /*#modelicaLine [ZeroRange.mo:9:3-9:9]*/
  _o = (modelica_integer) 0;
  /*#endModelicaLine*/
  /*#modelicaLine [ZeroRange.mo:10:3-12:10]*/
  tmp4 = (modelica_integer)_start; tmp5 = (modelica_integer)_step; tmp6 = (modelica_integer)_stop;
  if (!tmp5) {
    MODELICA_ASSERT(omc_dummyFileInfo, "assertion range step != 0 failed");
  } else if (!(((tmp5 > 0) && (tmp4 > tmp6)) || ((tmp5 < 0) && (tmp4 < tmp6)))) {
    for(modelica_integer _i = (modelica_integer)_start; in_range_integer(_i, tmp4, tmp6); _i += tmp5) {
      tmp3 = get_memory_state();
      /*#modelicaLine [ZeroRange.mo:11:5-11:15]*/
      _o = ((modelica_integer) 1 + (modelica_integer)_o);
      /*#endModelicaLine*/
      restore_memory_state(tmp3);
    }
  }
  /*#endModelicaLine*/
  
  _return:
  /* out var copy */
  restore_memory_state(tmp2);
  /* out var assign */
  tmp1.targ1 = _o;
  
  /* GC: pop the mark! */
  
  /* return the outs */
  return  tmp1;
}

int in_ZeroRange_testRangeLoop(type_description * inArgs, type_description * outVar)
{
  modelica_integer _start;
  modelica_integer _step;
  modelica_integer _stop;
  ZeroRange_testRangeLoop_rettype out;
  if (read_modelica_integer(&inArgs, &_start)) return 1;
  if (read_modelica_integer(&inArgs, &_step)) return 1;
  if (read_modelica_integer(&inArgs, &_stop)) return 1;
  MMC_TRY_TOP()
  out = _ZeroRange_testRangeLoop(_start, _step, _stop);
  MMC_CATCH_TOP(return 1)
  write_modelica_integer(outVar, &out.targ1);
  return 0;
}

}

