model Transistor
   annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-80.,80.},{80.,-80.}},lineColor={0,0,255}),Line(points={{80.,60.},{100.,60.}},color={0,0,255}),Line(points={{80.,-60.},{100.,-60.}},color={0,0,255}),Line(points={{-100.,0.},{-80.,0.}},color={0,0,255}),Line(points={{-60.,0.},{-10.,0.}},color={0,0,255}),Line(points={{-10.,40.},{-10.,-40.}},color={0,0,255}),Line(points={{60.,60.},{40.,60.},{-10.,10.}},color={0,0,255}),Line(points={{-10.,-10.},{40.,-60.},{60.,-60.}},color={0,0,255})}));
   Basic.Resistor rtb(R=0.05) annotation (Placement(transformation(x=-70.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=-70.,y=0.,scale=0.1,aspectRatio=1.)));
   Basic.Resistor rtc(R=0.1) annotation (Placement(transformation(x=50.,y=10.,scale=0.1,aspectRatio=1.),iconTransformation(x=50.,y=10.,scale=0.1,aspectRatio=1.)));
   Basic.Capacitor ct(C=1/10000000000.0) annotation (Placement(transformation(x=-40.,y=-30.,scale=0.1,aspectRatio=1.,rotation=-90),iconTransformation(x=-40.,y=-30.,scale=0.1,aspectRatio=1.,rotation=-90)));
   Semiconductors.NPN Tr(Bf=50,Br=0.1,Is=1/10000000000000000.0,Vak=0.02,Tauf=1.2e-10,Taur=1/200000000.0,Ccs=1/1000000000000.0,Cje=4.e-13,Cjc=5.e-13,Phie=0.8,Me=0.4,Phic=0.8,Mc=0.333,Gbc=1/1000000000000000.0,Gbe=1/1000000000000000.0,Vt=0.02585) annotation (Placement(transformation(x=0.,y=0.,scale=0.2,aspectRatio=1.),iconTransformation(x=0.,y=0.,scale=0.2,aspectRatio=1.)));
   Basic.Ground Ground1 annotation (Placement(transformation(x=-40.,y=-70.,scale=0.1,aspectRatio=1.),iconTransformation(x=-40.,y=-70.,scale=0.1,aspectRatio=1.)));
   Interfaces.Pin c annotation (Placement(transformation(x=100.,y=60.,scale=0.1,aspectRatio=1.),iconTransformation(x=100.,y=60.,scale=0.1,aspectRatio=1.)));
   Interfaces.Pin b annotation (Placement(transformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.)));
   Interfaces.Pin e annotation (Placement(transformation(x=100.,y=-60.,scale=0.1,aspectRatio=1.),iconTransformation(x=100.,y=-60.,scale=0.1,aspectRatio=1.)));
   
equation
   connect(rtb.n, Tr.B) annotation (Line(points={{-60.,0.},{-20.,0.}},color={0,0,255}));
   connect(rtb.n, ct.p) annotation (Line(points={{-60.,0.},{-40.,0.},{-40.,-20.}},color={0,0,255}));
   connect(ct.n, Ground1.p) annotation (Line(points={{-40.,-40.},{-40.,-60.}},color={0,0,255}));
   connect(Tr.C, rtc.p) annotation (Line(points={{20.,10.},{40.,10.}},color={0,0,255}));
   connect(rtc.n, c) annotation (Line(points={{60.,10.},{80.,10.},{80.,60.},{100.,60.}},color={0,0,255}));
   connect(b, rtb.p) annotation (Line(points={{-100.,0.},{-80.,0.}},color={0,0,255}));
   connect(Tr.E, e) annotation (Line(points={{20.,-10.},{80.,-10.},{80.,-60.},{100.,-60.}},color={0,0,255}));
end Transistor;