/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.collection;

import java.util.Enumeration;
import org.jacorb.collection.IteratorFactory;
import org.jacorb.collection.PositionalIteratorImpl;
import org.jacorb.collection.util.DynArray;
import org.jacorb.collection.util.ObjectInvalid;
import org.jacorb.collection.util.SortedVector;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.TypeCode;
import org.omg.CosCollection.Collection;
import org.omg.CosCollection.Command;
import org.omg.CosCollection.ElementInvalid;
import org.omg.CosCollection.ElementInvalidReason;
import org.omg.CosCollection.EmptyCollection;
import org.omg.CosCollection.Iterator;
import org.omg.CosCollection.IteratorHelper;
import org.omg.CosCollection.IteratorInBetween;
import org.omg.CosCollection.IteratorInvalid;
import org.omg.CosCollection.IteratorInvalidReason;
import org.omg.CosCollection.IteratorPOATie;
import org.omg.CosCollection.OperationsOperations;
import org.omg.CosCollection.PositionInvalid;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

class CollectionImpl {
    protected DynArray iterators = new DynArray();
    protected POA poa;
    protected OperationsOperations ops;
    protected IteratorFactory iterator_factory;
    protected SortedVector data;
    private Servant srvnt = null;

    CollectionImpl(OperationsOperations ops, POA poa, IteratorFactory iterator_factory) {
        this.poa = poa;
        this.ops = ops;
        this.iterator_factory = iterator_factory;
    }

    public synchronized TypeCode element_type() {
        return this.ops.element_type();
    }

    public synchronized boolean add_element(Any element) throws ElementInvalid {
        this.element_add(element);
        return true;
    }

    public synchronized boolean add_element_set_iterator(Any element, Iterator where) throws IteratorInvalid, ElementInvalid {
        PositionalIteratorImpl i = this.check_iterator(where);
        int pos = this.element_add(element);
        i.set_pos(pos);
        i.set_in_between(false);
        return true;
    }

    public synchronized void add_all_from(Collection collector) throws ElementInvalid {
        throw new NO_IMPLEMENT();
    }

    public synchronized void remove_element_at(Iterator where) throws IteratorInvalid, IteratorInBetween {
        PositionalIteratorImpl i = this.check_iterator(where);
        if (i.is_in_between()) {
            throw new IteratorInBetween();
        }
        int pos = i.get_pos();
        try {
            this.element_remove(pos);
        }
        catch (PositionInvalid e) {
            i.invalidate();
            throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
        }
        catch (EmptyCollection e) {
            i.invalidate();
            throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
        }
    }

    public synchronized int remove_all() {
        Enumeration enumeration = this.iterators.elements();
        while (enumeration.hasMoreElements()) {
            PositionalIteratorImpl i = (PositionalIteratorImpl)enumeration.nextElement();
            i.invalidate();
        }
        int count = this.data.size();
        this.data.removeAllElements();
        return count;
    }

    public synchronized void replace_element_at(Iterator where, Any element) throws IteratorInvalid, IteratorInBetween, ElementInvalid {
        PositionalIteratorImpl i = this.check_iterator(where);
        if (i.is_in_between()) {
            throw new IteratorInBetween();
        }
        int pos = i.get_pos();
        try {
            this.element_replace(pos, element);
        }
        catch (PositionInvalid e) {
            i.invalidate();
            throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
        }
    }

    public synchronized boolean retrieve_element_at(Iterator where, AnyHolder element) throws IteratorInvalid, IteratorInBetween {
        PositionalIteratorImpl i = this.check_iterator(where);
        if (i.is_in_between()) {
            throw new IteratorInBetween();
        }
        int pos = i.get_pos();
        try {
            element.value = this.element_retrieve(pos);
            return true;
        }
        catch (PositionInvalid e) {
            i.invalidate();
            throw new IteratorInvalid(IteratorInvalidReason.is_invalid);
        }
    }

    public synchronized boolean all_elements_do(Command what) {
        throw new NO_IMPLEMENT();
    }

    public synchronized int number_of_elements() {
        return this.data.size();
    }

    public synchronized boolean is_empty() {
        return this.data.size() == 0;
    }

    public synchronized void destroy() {
        Enumeration enumeration = this.iterators.elements();
        while (enumeration.hasMoreElements()) {
            PositionalIteratorImpl i = (PositionalIteratorImpl)enumeration.nextElement();
            i.destroy();
        }
        try {
            byte[] ObjID = this.poa.servant_to_id(this.srvnt);
            this.poa.deactivate_object(ObjID);
        }
        catch (Exception e) {
            System.out.println("Internal error: Can not deactivate object");
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    public synchronized Iterator create_iterator(boolean read_only) {
        PositionalIteratorImpl iter = this.iterator_factory.create_iterator(this, read_only);
        IteratorPOATie servant = new IteratorPOATie(iter);
        try {
            Iterator i = IteratorHelper.narrow(this.poa.servant_to_reference((Servant)servant));
            iter.set_servant(servant);
            return i;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    public synchronized int element_add(Any element) throws ElementInvalid {
        this.check_element(element);
        try {
            int pos = this.data.addElement(element);
            this.element_inserted(pos);
            return pos;
        }
        catch (ObjectInvalid e) {
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    public synchronized void element_remove(int pos) throws PositionInvalid, EmptyCollection {
        if (this.data.size() == 0) {
            throw new EmptyCollection();
        }
        if (pos < 0 || pos >= this.data.size()) {
            throw new PositionInvalid();
        }
        Any old = (Any)this.data.elementAt(pos);
        this.data.removeElementAt(pos);
        this.element_removed(pos, old);
    }

    public synchronized int element_replace(int pos, Any element) throws PositionInvalid, ElementInvalid {
        if (pos < 0 || pos >= this.data.size()) {
            throw new PositionInvalid();
        }
        this.check_element(element);
        try {
            Any old = (Any)this.data.elementAt(pos);
            this.data.setElementAt(element, pos);
            this.element_replaced(pos, old);
        }
        catch (ObjectInvalid e) {
            throw new ElementInvalid(ElementInvalidReason.positioning_property_invalid);
        }
        return pos;
    }

    public synchronized Any element_retrieve(int pos) throws PositionInvalid {
        if (pos < 0 || pos >= this.data.size()) {
            throw new PositionInvalid();
        }
        return (Any)this.data.elementAt(pos);
    }

    public synchronized PositionalIteratorImpl check_iterator(Iterator iter) throws IteratorInvalid {
        PositionalIteratorImpl i = null;
        Enumeration enumeration = this.iterators.elements();
        while (enumeration.hasMoreElements()) {
            i = (PositionalIteratorImpl)enumeration.nextElement();
            try {
                if (i.get_servant() != this.poa.reference_to_servant((Object)iter)) continue;
                return i;
            }
            catch (Exception e) {
                System.out.println("Internal error: Invalid POA policy or POA internal error");
                e.printStackTrace();
                throw new INTERNAL();
            }
        }
        throw new IteratorInvalid(IteratorInvalidReason.is_not_for_collection);
    }

    public synchronized boolean is_this_you(Collection col) {
        try {
            return this.srvnt == this.poa.reference_to_servant((Object)col);
        }
        catch (Exception e) {
            System.out.println("InternalError: Can not test Object equality");
            e.printStackTrace(System.out);
            throw new INTERNAL();
        }
    }

    public synchronized void destroy_me(PositionalIteratorImpl i) {
        if (this.iterators.removeElement(i)) {
            try {
                byte[] ObjID = this.poa.servant_to_id(i.get_servant());
                this.poa.deactivate_object(ObjID);
            }
            catch (Exception e) {
                System.out.println("Internal error: Attempt destroy not my Iterator");
                e.printStackTrace(System.out);
                throw new INTERNAL();
            }
        } else {
            System.out.println("Internal error: Attempt destroy not my Iterator");
            throw new INTERNAL();
        }
    }

    public void check_element(Any element) throws ElementInvalid {
        if (!this.ops.check_element_type(element)) {
            throw new ElementInvalid(ElementInvalidReason.element_type_invalid);
        }
    }

    synchronized void set_servant(Servant srvnt) {
        this.srvnt = srvnt;
    }

    protected void element_inserted(int pos) {
        Enumeration enumeration = this.iterators.elements();
        while (enumeration.hasMoreElements()) {
            int p;
            PositionalIteratorImpl i = (PositionalIteratorImpl)enumeration.nextElement();
            if (!i.is_valid() || (p = i.get_pos()) < pos) continue;
            i.set_pos(pos + 1);
        }
    }

    protected void element_removed(int pos, Any old) {
        Enumeration enumeration = this.iterators.elements();
        while (enumeration.hasMoreElements()) {
            PositionalIteratorImpl i = (PositionalIteratorImpl)enumeration.nextElement();
            if (!i.is_valid()) continue;
            int p = i.get_pos();
            if (p == pos) {
                i.set_in_between(true);
                continue;
            }
            if (p <= pos) continue;
            i.set_pos(p - 1);
        }
    }

    protected void element_replaced(int pos, Any old) {
    }
}

